MODULE cv3_enthalpmix_mod
  PRIVATE

  PUBLIC cv3_enthalpmix

CONTAINS

SUBROUTINE cv3_enthalpmix(len, nd, iflag, plim1, plim2, p, ph, &
                       t, q, u, v, w, &
                       wi, nk, tmix, thmix, qmix, qsmix, umix, vmix, plcl &
#ifdef ISO
     &                 ,xt,xtmix &
#endif
                       )
#ifdef ISO
    use infotrac_phy, ONLY: ntiso
#endif
  ! **************************************************************
  ! *
  ! CV3_ENTHALPMIX   Brassage adiabatique d'une couche d'epaisseur *
  ! arbitraire.                                   *
  ! *
  ! written by   : Grandpeix Jean-Yves, 28/12/2001, 13.14.24    *
  ! modified by :  Filiberti M-A 06/2005 vectorisation          *
  ! **************************************************************

  USE lmdz_cv_ini, ONLY : cpd,cpv,rrd,rrv
  USE yomcst_mod_h
  USE yoethf_mod_h
IMPLICIT NONE
  ! ==============================================================

  ! vertmix : determines theta, t, q, qs, u and v of the mixture generated by
  ! adiabatic mixing of air between plim1 and plim2 with weighting w.
  ! If plim1 and plim2 fall within the same model layer, then theta, ... v
  ! are those of that layer.
  ! A minimum value (dpmin) is imposed upon plim1-plim2

  ! ===============================================================

  include "FCTTRE.h"
!inputs:
  INTEGER, INTENT (IN)                      :: nd, len
  INTEGER, DIMENSION (len), INTENT (IN)     :: nk
  REAL, DIMENSION (len), INTENT (IN)        :: plim1, plim2
  REAL, DIMENSION (len,nd), INTENT (IN)     :: t, q
  REAL, DIMENSION (len,nd), INTENT (IN)     :: u, v
  REAL, DIMENSION (nd), INTENT (IN)         :: w
  REAL, DIMENSION (len,nd), INTENT (IN)     :: p
  REAL, DIMENSION (len,nd+1), INTENT (IN)   :: ph
#ifdef ISO
  REAL, DIMENSION (ntiso,len,nd),INTENT (IN) :: xt
#endif
!input/output:
  INTEGER, DIMENSION (len), INTENT (INOUT)  ::  iflag
!outputs:
  REAL, DIMENSION (len), INTENT (OUT)       :: tmix, thmix, qmix
  REAL, DIMENSION (len), INTENT (OUT)       :: umix, vmix
  REAL, DIMENSION (len), INTENT (OUT)       :: qsmix
  REAL, DIMENSION (len), INTENT (OUT)       :: plcl
  REAL, DIMENSION (len,nd), INTENT (OUT)    :: wi
#ifdef ISO
  REAL, DIMENSION (ntiso,len), INTENT (OUT) :: xtmix
#endif
!internal variables :
  INTEGER i, j
  INTEGER niflag7
  INTEGER, DIMENSION(len)                   :: j1, j2
  REAL                                      :: a, b
  REAL                                      :: cpn
  REAL                                      :: x, y, p0, p0m1, zdelta, zcor
  REAL, PARAMETER                           :: dpmin=1.
  REAL, DIMENSION(len)                      :: plim2p  ! = min(plim2(:),plim1(:)-dpmin)
  REAL, DIMENSION(len)                      :: akm     ! mixture enthalpy
  REAL, DIMENSION(len)                      :: dpw, coef
  REAL, DIMENSION(len)                      :: rdcp, a2, b2, pnk
  REAL, DIMENSION(len)                      :: rh, chi
  REAL, DIMENSION(len)                      :: eqwght
  REAL, DIMENSION(len,nd)                   :: p1, p2
#ifdef ISO
  INTEGER ixt
#endif


!!  print *,' ->cv3_vertmix, plim1,plim2 ', plim1,plim2   !jyg
  plim2p(:) = min(plim2(:),plim1(:)-dpmin)
  j1(:)=nd
  j2(:) = 0
  DO j = 1, nd
    DO i = 1, len
      IF (plim1(i)<=ph(i,j)) j1(i) = j
!!!      IF (plim2p(i)>=ph(i,j+1) .AND. plim2p(i)<ph(i,j)) j2(i) = j
      IF (plim2p(i)< ph(i,j)) j2(i) = j
    ENDDO
  ENDDO

  DO j = 1, nd
    DO i = 1, len
      wi(i, j) = 0.
    ENDDO
  ENDDO
  DO i = 1, len
    akm(i) = 0.
    qmix(i) = 0.
    umix(i) = 0.
    vmix(i) = 0.
    dpw(i) = 0.
    a2(i) = 0.0
    b2(i) = 0.
    pnk(i) = p(i, nk(i))
#ifdef ISO
    xtmix(:,i) = 0.
#endif
  ENDDO
  eqwght(:) = 0.

  p0 = 1000.
  p0m1 = 1./p0

  DO i = 1, len
    IF (j2(i) < j1(i)) THEN
      coef(i) = 1.
      eqwght(i) = 1.
    ELSE
      coef(i) = 1./(plim1(i)-plim2p(i))
    ENDIF
  ENDDO

!!  print *,'cv3_vertmix, j1,j2,coef ', j1,j2,coef  !jyg

  DO j = 1, nd
    DO i = 1, len
      IF (j>=j1(i) .AND. j<=j2(i)) THEN
        p1(i, j) = min(ph(i,j), plim1(i))
        p2(i, j) = max(ph(i,j+1), plim2p(i))
        ! CRtest:couplage thermiques: deja normalise
        ! wi(i,j) = w(j)
        ! print*,'wi',wi(i,j)
        wi(i, j) = w(j)*(p1(i,j)-p2(i,j))*coef(i)+eqwght(i)
        dpw(i) = dpw(i) + wi(i, j)

!!  print *,'cv3_vertmix, j, wi(1,j),dpw ', j, wi(1,j),dpw  !jyg

      ENDIF
    ENDDO
  ENDDO

  ! CR:print
  ! do i=1,len
  ! print*,'plim',plim1(i),plim2p(i)
  ! enddo
  DO j = 1, nd
    DO i = 1, len
      IF (j>=j1(i) .AND. j<=j2(i)) THEN
        wi(i, j) = wi(i, j)/dpw(i)
        akm(i) = akm(i) + (cpd*(1.-q(i,j))+q(i,j)*cpv)*t(i, j)*wi(i, j)
        qmix(i) = qmix(i) + q(i, j)*wi(i, j)
        umix(i) = umix(i) + u(i, j)*wi(i, j)
        vmix(i) = vmix(i) + v(i, j)*wi(i, j)
#ifdef ISO
        DO ixt=1,ntiso
          xtmix(ixt,i) = xtmix(ixt,i) +  xt(ixt,i, j)*wi(i, j)
        ENDDO
#endif
      ENDIF
    ENDDO
  ENDDO

  DO i = 1, len
    rdcp(i) = (rrd*(1.-qmix(i))+qmix(i)*rrv)/(cpd*(1.-qmix(i))+qmix(i)*cpv)
  ENDDO


!!  print *,'cv3_vertmix, rdcp ', rdcp  !jyg



  DO j = 1, nd
    DO i = 1, len
      IF (j>=j1(i) .AND. j<=j2(i)) THEN
        ! c            x=(.5*(p1(i,j)+p2(i,j))*p0m1)**rdcp(i)
        y = (.5*(p1(i,j)+p2(i,j))/pnk(i))**rdcp(i)
        ! c            a2(i)=a2(i)+(cpd*(1.-qmix(i))+qmix(i)*cpv)*x*wi(i,j)
        b2(i) = b2(i) + (cpd*(1.-qmix(i))+qmix(i)*cpv)*y*wi(i, j)
      ENDIF
    ENDDO
  ENDDO

  DO i = 1, len
    tmix(i) = akm(i)/b2(i)
    thmix(i) = tmix(i)*(p0/pnk(i))**rdcp(i)
    ! print*,'thmix akm',akm(i),b2(i)
    ! print*,'thmix t',tmix(i),p0
    ! print*,'thmix p',pnk(i),rdcp(i)
    ! print*,'thmix',thmix(i)
    ! c         thmix(i) = akm(i)/a2(i)
    ! c         tmix(i)= thmix(i)*(pnk(i)*p0m1)**rdcp(i)
    zdelta = max(0., sign(1.,rtt-tmix(i)))
    qsmix(i) = r2es*foeew(tmix(i), zdelta)/(pnk(i)*100.)
    qsmix(i) = min(0.5, qsmix(i))
    zcor = 1./(1.-retv*qsmix(i))
    qsmix(i) = qsmix(i)*zcor
  ENDDO

  ! -------------------------------------------------------------------
  ! --- Calculate lifted condensation level of air at parcel origin level
  ! --- (Within 0.2% of formula of Bolton, MON. WEA. REV.,1980)
  ! -------------------------------------------------------------------

  a = 1669.0 ! convect3
  b = 122.0 ! convect3


  niflag7 = 0
  DO i = 1, len

    IF (iflag(i)/=7) THEN ! modif sb Jun7th 2002

      rh(i) = qmix(i)/qsmix(i)
      chi(i) = tmix(i)/(a-b*rh(i)-tmix(i)) ! convect3
      ! ATTENTION, la LIGNE DESSOUS A ETE RAJOUTEE ARBITRAIREMENT ET
      ! MASQUE UN PB POTENTIEL
      chi(i) = max(chi(i), 0.)
      rh(i) = max(rh(i), 0.)
      plcl(i) = pnk(i)*(rh(i)**chi(i))
      IF (((plcl(i)<200.0) .OR. (plcl(i)>=2000.0)) .AND. (iflag(i)==0)) &
          iflag(i) = 8

    ELSE

      niflag7 = niflag7 + 1
      plcl(i) = plim2p(i)

    ENDIF ! iflag=7

    ! print*,'NIFLAG7  =',niflag7

  ENDDO

!!  print *,' cv3_vertmix->'  !jyg


  RETURN
END SUBROUTINE cv3_enthalpmix

END MODULE cv3_enthalpmix_mod
