MODULE YOMRAD15

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------
!*    ** *YOMRAD15* - CONTROL OPTIONS FOR RADIATION CONFIGURATION
!*                          FROZEN VERSION (CYCLE 15) OF YOERAD
!     ------------------------------------------------------------------

INTEGER(KIND=JPIM) :: NAER15
INTEGER(KIND=JPIM) :: NFLUX15
INTEGER(KIND=JPIM) :: NMODE15
INTEGER(KIND=JPIM) :: NRAD15
INTEGER(KIND=JPIM) :: NRADFR15
INTEGER(KIND=JPIM) :: NRADPFR15
INTEGER(KIND=JPIM) :: NRADPLA15
INTEGER(KIND=JPIM) :: NRINT15
INTEGER(KIND=JPIM) :: NRADNFR15
INTEGER(KIND=JPIM) :: NRADSFR15
INTEGER(KIND=JPIM) :: NOVLP15
INTEGER(KIND=JPIM) :: NRPROMA15
INTEGER(KIND=JPIM) :: NRADF2C15
INTEGER(KIND=JPIM) :: NRADC2F15
LOGICAL :: LERAD6H15
LOGICAL :: LERADHS15
LOGICAL :: LRADLB15
LOGICAL :: LRADAER15
LOGICAL :: LNEWAER15

!        * E.C.M.W.F. PHYSICS PACKAGE *

!        96-11: Ph. Dandin. Meteo-France
!     ORIGINAL BY J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME       TYPE     PURPOSE
!  ----    :  ----   : -------------------------------------------------
! LERAD6H15: LOGICAL : .T. TO ALLOW MORE FREQUENT RADIATION CALCULATIONS
!                  : DURING FIRST 6 HOURS OF FORECAST
! LERADHS15: LOGICAL : .T. IF RAD.COMPUTED ON A COARSER SAMPLED GRID
! NAER15   : INTEGER : CONFIGURATION INDEX FOR AEROSOLS
! NFLUX15  : INTEGER : NUMBER OF RADIATIVE FLUXES
! NMODE15  : INTEGER : CONFIG. FOR RADIATION CODE: FLUX VS. RADIANCE
! NRAD15   : INTEGER : NUMBER OF RADIANCES
! NRADFR15 : INTEGER : FREQUENCY OF FULL RADIATION COMPUTATIONS
!                      IF.GT.0: RAD EVERY 'NRADFR15' TIME-STEPS
!                      IF.LT.0: RAD EVERY '-NRADFR15' HOURS
! NRADPFR15: INTEGER : PRINT FREQ. FOR RAD. STATISTICS (in RAD.T.STEPS)
! NRADPLA15: INTEGER : PRINT RAD.STATISTICS EVERY 'NRADPLA15' ROWS
! NRINT15  : INTEGER : INTERPOLATION DISTANCE (in points)
! NRADNFR15: INTEGER : NORMAL   FREQUENCY OF RADIATION STEPS
! NRADSFR15: INTEGER : START-UP FREQUENCY OF RADIATION STEPS
! NOVLP15  : INTEGER : CLOUD OVERLAP CONFIGURATION
! NRPROMA15: INTEGER : VECTOR LENGTH FOR RADIATION CALCULATIONS
! NRADF2C15: INTEGER : INTERPOLATION SCHEME FOR FINE TO COURSE GRID TO
!                    : BE USED WHEN NRINT15 IS GREATER THAN 1
! NRADC2F15: INTEGER : INTERPOLATION SCHEME FOR COURSE TO FINE GRID TO
!                    : BE USED WHEN NRINT15 IS GREATER THAN 1
! LRADLB15 : LOGICAL : .TRUE. IF RADIATION COURSER GRID IS TO BE LOAD
!                    : BALANCED OVER PROCESSORS (I.E. WHEN NRINT15>1)
! LRADAER15 :LOGICAL : .TRUE. IF CLIMATOLOGICAL VALUES FOR TROPOSPHERIC 
!                    : AEROSOLS ARE INITIALIZED
! LNEWAER15 :LOGICAL : .TRUE. IF TEGEN AEROSOLS ARE USED
!     ------------------------------------------------------------------
!$OMP THREADPRIVATE(lerad6h15,leradhs15,lnewaer15,lradaer15,lradlb15,naer15,nflux15,nmode15,novlp15)
!$OMP THREADPRIVATE(nrad15,nradc2f15,nradf2c15,nradfr15,nradnfr15,nradpfr15,nradpla15,nradsfr15,nrint15,nrproma15)
END MODULE YOMRAD15
