MODULE YOESW

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------
!*    ** *YOESW* - COEFFICIENTS FOR SHORTWAVE RADIATION TRANSFER
!     ------------------------------------------------------------------

REAL(KIND=JPRB) :: APAD(6,3,7)
REAL(KIND=JPRB) :: BPAD(6,3,7)
REAL(KIND=JPRB) :: RRAY(6,6)
REAL(KIND=JPRB), ALLOCATABLE :: RSUN(:)
REAL(KIND=JPRB) :: RPDH1
REAL(KIND=JPRB) :: RPDU1
REAL(KIND=JPRB) :: RPNH
REAL(KIND=JPRB) :: RPNU
REAL(KIND=JPRB) :: RSWCE(6)
REAL(KIND=JPRB) :: RSWCP(6)
REAL(KIND=JPRB) :: RTDH2O
REAL(KIND=JPRB) :: RTDUMG
REAL(KIND=JPRB) :: RTH2O
REAL(KIND=JPRB) :: RTUMG
REAL(KIND=JPRB) :: D(6,3)
REAL(KIND=JPRB) :: REXPO3(6,2,7)
INTEGER(KIND=JPIM) :: NEXPO3(6)

REAL(KIND=JPRB) :: RYFWCA(6)
REAL(KIND=JPRB) :: RYFWCB(6)
REAL(KIND=JPRB) :: RYFWCC(6)
REAL(KIND=JPRB) :: RYFWCD(6)
REAL(KIND=JPRB) :: RYFWCE(6)
REAL(KIND=JPRB) :: RYFWCF(6)

REAL(KIND=JPRB) :: REBCUA(6)
REAL(KIND=JPRB) :: REBCUB(6)
REAL(KIND=JPRB) :: REBCUC(6)
REAL(KIND=JPRB) :: REBCUD(6)
REAL(KIND=JPRB) :: REBCUE(6)
REAL(KIND=JPRB) :: REBCUF(6)
REAL(KIND=JPRB) :: REBCUG(16)
REAL(KIND=JPRB) :: REBCUH(16)
REAL(KIND=JPRB) :: REBCUI(6)
REAL(KIND=JPRB) :: REBCUJ(6)

REAL(KIND=JPRB) :: RASWCA(6)
REAL(KIND=JPRB) :: RASWCB(6)
REAL(KIND=JPRB) :: RASWCC(6)
REAL(KIND=JPRB) :: RASWCD(6)
REAL(KIND=JPRB) :: RASWCE(6)
REAL(KIND=JPRB) :: RASWCF(6)

REAL(KIND=JPRB) :: RFUETA(16,3),RFUETB(16,4), RFUETC(16,4)
REAL(KIND=JPRB) :: RFULIO(16,3)
REAL(KIND=JPRB) :: RHSAVI(16,3)
REAL(KIND=JPRB) :: RLILIA(16,5),RLILIB(16,4)

REAL(KIND=JPRB) :: RFLAA0(6)
REAL(KIND=JPRB) :: RFLAA1(6)
REAL(KIND=JPRB) :: RFLBB0(6)
REAL(KIND=JPRB) :: RFLBB1(6)
REAL(KIND=JPRB) :: RFLBB2(6)
REAL(KIND=JPRB) :: RFLBB3(6)
REAL(KIND=JPRB) :: RFLCC0(6)
REAL(KIND=JPRB) :: RFLCC1(6)
REAL(KIND=JPRB) :: RFLCC2(6)
REAL(KIND=JPRB) :: RFLCC3(6)

REAL(KIND=JPRB) :: RFUAA0(6)
REAL(KIND=JPRB) :: RFUAA1(6)
REAL(KIND=JPRB) :: RFUBB0(6)
REAL(KIND=JPRB) :: RFUBB1(6)
REAL(KIND=JPRB) :: RFUBB2(6)
REAL(KIND=JPRB) :: RFUBB3(6)
REAL(KIND=JPRB) :: RFUCC0(6)
REAL(KIND=JPRB) :: RFUCC1(6)
REAL(KIND=JPRB) :: RFUCC2(6)
REAL(KIND=JPRB) :: RFUCC3(6)
REAL(KIND=JPRB) :: RFLDD0(6)
REAL(KIND=JPRB) :: RFLDD1(6)
REAL(KIND=JPRB) :: RFLDD2(6)
REAL(KIND=JPRB) :: RFLDD3(6)

REAL(KIND=JPRB) :: REFFIA

REAL(KIND=JPRB) :: RTAUA(6,6)
REAL(KIND=JPRB) :: RPIZA(6,6)
REAL(KIND=JPRB) :: RCGA(6,6)
REAL(KIND=JPRB) :: RAER(6,6)

INTEGER(KIND=JPIM) :: NMPSRTM(14), NTYPS

REAL(KIND=JPRB) :: RADJUST

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
!  APAD  :  REAL     PADE APPROXIMANTS NUMERATOR
!  BPAD  :  REAL     PADE APPROXIMANTS DENOMINATOR
!  D     :  REAL     TRANSMISSION LIMIT FOR INFINITE ABSORBER AMOUNT
!  RRAY  :  REAL     RAYLEIGH SCATTERING COEFFICIENTS
!  RSUN  :  REAL     SOLAR FRACTION IN SPECTRAL INTERVALS
!  RPDH1 :  1 + EXPONENT PRESSURE DEPENDENCE H2O
!  RPDU1 :  1 + EXPONENT PRESSURE DEPENDENCE UNIFORMLY MIXED GASES
!  RPNH  :  REFERENCE PRESSURE FACTOR FOR H2O
!  RPNU  :  REFERENCE PRESSURE FACTOR FOR UNIFORMLY MIXED GASES
!  RSWCE :  E-TYPE, H2O CONTINUUM ABSORPTION COEFFICIENT 
!  RSWCP :  P-TYPE, H2O CONTINUUM ABSORPTION COEFFICIENT 
!  RTDH2O:  EXPONENT TEMPERATURE DEPENDENCE H2O
!  RTDUMG:  EXPONENT TEMPERATURE DEPENDENCE UNIFORMLY MIXED GASES
!  RTH2O :  REFERENCE TEMPERATURE H2O
!  RTUMG :  REFERENCE TEMPERATURE UNIFORMLY MIXED GASES
!     -----------------------------------------------------------------

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
!*    FOUQUART (1987) WATER CLOUD OPTICAL PROPERTIES

! RYFWCA :  REAL   : C1 IN OPTICAL THICKNESS FORMULA
! RYFWCB :  REAL   : C2 IN OPTICAL THICKNESS FORMULA
! RYFWCC :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RYFWCD :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RYFWCE :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RYFWCF :  REAL   : ASSYMETRY FACTOR

!*    SLINGO (1989) WATER CLOUD OPTICAL PROPERTIES

! RASWCA :  REAL   : C1 IN OPTICAL THICKNESS FORMULA
! RASWCB :  REAL   : C2 IN OPTICAL THICKNESS FORMULA
! RASWCC :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RASWCD :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RASWCE :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RASWCF :  REAL   : ASSYMETRY FACTOR

!*   LINDNER,LI (2000) WATER CLOUD OPTICAL PROPERTIES (RRTM)

! RLILIA : REAL    : MASS ABSORPTION COEFFICIENTS (POLYNOMIAL DEVELOPM)
! RLILIB : REAL    : 1-SSA COEFFICIENTS  (POLYNOMIAL DEVELOPM)

!*    ICE CLOUD OPTICAL PROPERTIES DERIVED FROM EBERT-CURRY (1992)

! REBCUA :  REAL   : C1 IN OPTICAL THICKNESS FORMULA
! REBCUB :  REAL   : C2 IN OPTICAL THICKNESS FORMULA
! REBCUC :  REAL   : 1-C3  IN SINGLE SCATTERING ALBEDO FORMULA
! REBCUD :  REAL   : C4 IN SINGLE SCATTERING ALBEDO FORMULA
! REBCUE :  REAL   : C5 IN ASSYMETRY FACTOR FORMULA
! REBCUF :  REAL   : C6 IN ASSYMETRY FACTOR FORMULA
! REBCUG :  REAL   : C7 IN MASS ABSORPTION COEFFICIENT FORMULA
! REBCUH :  REAL   : C8 IN MASS ABSORPTION COEFFICIENT FORMULA
! REBCUI :  REAL   : C7 IN MASS ABSORPTION COEFFICIENT SPECTRAL FORMULA
! REBCUJ :  REAL   : C8 IN MASS ABSORPTION COEFFICIENT SPECTRAL FORMULA

!*    ICE CLOUD OPTICAL PROPERTIES DERIVED FROM SUN-SHINE (1995)

! RSHSUE :  REAL   : E IN SINGLE SCATTERING ALBEDO FORMULA
! RSHSUF :  REAL   : F IN SINGLE SCATTERING ALBEDO FORMULA
! RSHSUH :  REAL   : H IN ASSYMETRY FACTOR FORMULA
! RSHSUK :  REAL   : K IN ASSYMETRY FACTOR FORMULA
! RSHSUA :  REAL   : ALPHA IN SSA CORRECTION FACTOR FORMULA
! RSHSUG :  REAL   : GAMMA IN ASSYMETRY CORRECTION FACTOR FORMULA
! RSHSUFA:  REAL   : COEFFICIENTS IN TEMPERATURE CORRECTION FACTOR

! REFFIA :  REAL   : C9  IN EFFECTIVE RADIUS FORMULA

!*    ICE CLOUD OPTICAL PROPERTIES DERIVED FROM FU-LIOU (1993)

! RFULIO :  REAL   : COEFFICIENTS IN EXPRESSION FOR LW EXTINCTION COEFF.
! RFLAA  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW EXTINCTION COEFF.
! RFLBB  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW SINGLE SCATT.ALB.
! RFLCC  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW ASSYMETRY FACTOR
! RFLDD  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW ASSYMETRY FACTOR

!*    ICE CLOUD OPTICAL PROPERTIES DERIVED FROM FU (1996) & FU ET AL. (1998)

! RFUETA :  REAL   : COEFFICIENTS IN EXPRESSION FOR LW EXTINCTION COEFF.
! RFUAA  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW EXTINCTION COEFF.
! RFUBB  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW SINGLE SCATT.ALB.
! RFUCC  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW ASSYMETRY FACTOR

!     -----------------------------------------------------------------

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : -------
!  RTAUA :  REAL     S.W. NORMALIZED OPTICAL THICKNESS AT 0.55 MICRON
!  RPIZA :  REAL     S.W. SINGLE SCATTERING ALBEDO
!  RCGA  :  REAL     S.W. ASSYMETRY FACTOR
!  RAER  :  REAL     L.W. ABSORPTION COEFFICIENTS
!     -----------------------------------------------------------------

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : -------
!RTWEIGHT:  REAL     S.W. INTEGRATED WEIGHT 
! NMPSRTM: INTEGER  : Indices for mapping SW[1:6] albedo into SRTM[1:14]  
!     -----------------------------------------------------------------
END MODULE YOESW
