LOGICAL FUNCTION iso_verif_noNaN_nostop(x, err_msg) RESULT(lerr)
   IMPLICIT NONE
! If "x" is NaN, print an error message .
   REAL,             INTENT(IN) :: x
   CHARACTER(LEN=*), INTENT(IN) :: err_msg
   REAL, PARAMETER :: borne = 1e19
   lerr = x < -borne .OR. x > borne
   IF(.NOT.lerr) RETURN
   WRITE(*,*) 'erreur detectee par iso_verif_nonNaN:'
   WRITE(*,*) err_msg
   WRITE(*,*) 'x=',x
END FUNCTION iso_verif_noNaN_nostop


LOGICAL FUNCTION iso_verif_egalite_nostop(a, b, err_msg) RESULT(lerr)
   IMPLICIT NONE
!   Compare "a" and "b". If a/=b, print an error message.
!   Both absolute and relative errors are checked for equality.
   REAL,             INTENT(IN) :: a, b
   CHARACTER(LEN=*), INTENT(IN) :: err_msg
   REAL, PARAMETER :: errmax = 1e-8, &           ! max absolute error
                   errmaxrel = 1e-3              ! max relative error
   lerr = ABS(a-b) > errmax
   IF(.NOT.lerr) RETURN
   lerr = ABS( (a-b) / MAX(MAX(ABS(b), ABS(a)),1e-18) ) > errmaxrel
   IF(.NOT.lerr) RETURN
   WRITE(*,*) 'erreur detectee par iso_verif_egalite:'
   WRITE(*,*) err_msg
   WRITE(*,*) 'a=',a
   WRITE(*,*) 'b=',b
END FUNCTION iso_verif_egalite_nostop


LOGICAL FUNCTION iso_verif_aberrant_nostop(x, iso, q, err_msg) RESULT(lerr)
   USE IOIPSL, ONLY: getin
   USE iso_params_mod, ONLY: tnat_HDO
   IMPLICIT NONE
   REAL,             INTENT(IN) :: x, q
   INTEGER,          INTENT(IN) :: iso ! 2=HDO, 1=O18
   CHARACTER(LEN=*), INTENT(IN) :: err_msg

   REAL, PARAMETER :: qmin = 1e-11, &
                 deltaDmax = 200.0, &
                 deltaDmin =-999.9
   LOGICAL       :: ltnat1
   LOGICAL, SAVE :: lFirst=.TRUE.
   REAL,    SAVE :: tnat
   REAL          :: deltaD
   IF(lFirst) THEN
      ltnat1 = .TRUE.; CALL getin('tnateq1', ltnat1)
      tnat = tnat_HDO; IF(ltnat1) tnat = 1.0
      lFirst = .FALSE.
   END IF
   lerr = q > qmin
   IF(.NOT.lerr) RETURN
   deltaD = (x / q /tnat - 1.) * 1000.
   lerr = deltaD > deltaDmax .OR. deltaD < deltaDmin
   IF(.NOT.lerr) RETURN
   WRITE(*,*) 'erreur detectee par iso_verif_aberrant:'
   WRITE(*,*) err_msg
   WRITE(*,*) 'q=',q
   WRITE(*,*) 'deltaD=',deltaD
   WRITE(*,*) 'iso=',iso
END FUNCTION iso_verif_aberrant_nostop

