MODULE lmdz_wake_first
  LOGICAL            :: first_call=.true.
  !$OMP THREADPRIVATE(first_call)
PUBLIC wake_first
CONTAINS

SUBROUTINE wake_first(klev, dtime)            
USE lmdz_wake_ini , ONLY : CPPKEY_IOPHYS_WK
USE lmdz_wake_ini , ONLY : phys_sub
USE lmdz_wake_ini , ONLY : wk_nsub
IMPLICIT NONE  
  INTEGER, INTENT(IN) :: klev
  REAL, INTENT(IN)    :: dtime
  REAL                :: dtimesub

  dtimesub = dtime/wk_nsub
  !
  IF (first_call) THEN
    IF (CPPKEY_IOPHYS_WK) THEN
      IF (phys_sub) THEN
        call iophys_ini(dtimesub,klev)
      ELSE
        call iophys_ini(dtime,klev)
      ENDIF
    END IF
    first_call = .false.
  ENDIF   !(first_call)

END SUBROUTINE wake_first
END MODULE lmdz_wake_first
