SUBROUTINE SU_AEROP

!**** *SU_AEROP*   - INITIALIZE MODULES YOEAEROP

!     PURPOSE.
!     --------
!           INITIALIZE YOEAEROP THE MODULE THAT CONTAINS THE
!           OPTICAL PROPERTIES FOR THE PROGNOSTIC AEROSOLS

!**   INTERFACE.
!     ----------
!        *CALL* *SU_AEROP

!        EXPLICIT ARGUMENTS :
!        --------------------
!        NONE

!        IMPLICIT ARGUMENTS :
!        --------------------
!        YOEAEROP

!     METHOD.
!     -------
!        SEE DOCUMENTATION

!     EXTERNALS.
!     ----------

!     REFERENCE.
!     ----------
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE IFS

!     AUTHOR.
!     -------
!        JEAN-JACQUES MORCRETTE *ECMWF*
!        from O.BOUCHER's stand-alone codes (LOA, 2005-03) 

!     MODIFICATIONS.
!     --------------
!        ORIGINAL : 2005-03-25

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOEAEROP  , ONLY : ALF_SU, ASY_SU, OMG_SU, ALF_OM, ASY_OM, OMG_OM, &
  & ALF_DD, ASY_DD, OMG_DD, ALF_SS, ASY_SS, OMG_SS, ALF_BC, ASY_BC, OMG_BC, &
  & ALF_FA, ASY_FA, OMG_FA 

IMPLICIT NONE

REAL(KIND=JPRB) :: ZHOOK_HANDLE
!     ----------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('SU_AEROP',0,ZHOOK_HANDLE)


!*      1.    PARAMETERS RELATED TO OPTICAL PROPERTIES
!             ----------------------------------------

! All arrays are given in three blocks: 
! first, for 16 wavelengths relevant to observations 
! 340, 380, 400, 440, 469, 500, 532, 555, 645, 670, 800, 858, 865, 1240, 1640, 2130 

!(  not done yet, depends whether SW6 or RRTM_SW is used, to be computed for RRTM_LW)
! second, for the spectral intervals of the SW radiation scheme
! third, for the spectral intervals of the LW radiation scheme

! For sulfates (_SU) and organic matters (_OM), values are given as function 
! of RH (12 values) for the 8 wavelengths
! For sea-salt (_SS), 3 bins are considered      (0.03, 0.50, 5.0, 20.)
! For desert dust (_DD), 3 bins are considered	 (0.03, 0.55, 0.9, 20.)
!
! IF BIN LIMITS ARE CHANGED, MAKE SURE THAT THE RELEVANT SEDIMENTATION SPEEDS ARE 
! RECOMPUTED ACCORDINGLY

! RH  0.   	 10.	     20.         30.         40.         50.
!    60.         70.         80.         85.         90.         95.    

ALF_FA(:) =0.0_JPRB
ASY_FA(:) =0.0_JPRB
OMG_FA(:) =0.0_JPRB

! alpha_aer_bc
ALF_BC( :) = (/ &
  & 14.237_JPRB, 14.237_JPRB, &
  & 14.237_JPRB, 12.619_JPRB, 12.000_JPRB, 10.684_JPRB,  9.840_JPRB,  9.412_JPRB,  9.000_JPRB, &
  &  7.212_JPRB,  5.677_JPRB,  5.500_JPRB,  5.113_JPRB,  5.000_JPRB,  5.000_JPRB,  5.000_JPRB /)

! cg_aer_bc
ASY_BC( :) = (/ &
  &   .398_JPRB,   .398_JPRB, &
  &   .398_JPRB,   .379_JPRB,   .353_JPRB,   .350_JPRB,   .341_JPRB,   .335_JPRB,   .300_JPRB, & 
  &   .296_JPRB,   .263_JPRB,   .250_JPRB,   .248_JPRB,   .200_JPRB,   .200_JPRB,   .200_JPRB /)

! om_aer_bc
OMG_BC( :) = (/ &
  &   .270_JPRB,   .270_JPRB, &
  &   .270_JPRB,   .251_JPRB,   .240_JPRB,   .226_JPRB,   .213_JPRB,   .206_JPRB,   .180_JPRB, &
  &   .166_JPRB,   .132_JPRB,   .120_JPRB,   .118_JPRB,   .100_JPRB,   .100_JPRB,   .100_JPRB  /)

! alpha_aer_sulfate
ALF_SU( :,1) = (/ &
  &  6.823_JPRB, 6.823_JPRB, 6.823_JPRB, 6.823_JPRB, 9.168_JPRB,10.246_JPRB, &
  & 11.685_JPRB,13.796_JPRB,17.504_JPRB,20.617_JPRB,26.335_JPRB,42.574_JPRB /)
ALF_SU( :,2) = (/ &
  &  6.823_JPRB, 6.823_JPRB, 6.823_JPRB, 6.823_JPRB, 9.168_JPRB,10.246_JPRB, &
  & 11.685_JPRB,13.796_JPRB,17.504_JPRB,20.617_JPRB,26.335_JPRB,42.574_JPRB /)
ALF_SU( :,3) = (/ &
  &  6.823_JPRB, 6.823_JPRB, 6.823_JPRB, 6.823_JPRB, 9.168_JPRB,10.246_JPRB, &
  & 11.685_JPRB,13.796_JPRB,17.504_JPRB,20.617_JPRB,26.335_JPRB,42.574_JPRB /)
ALF_SU( :,4) = (/ &
  &  6.023_JPRB, 6.023_JPRB, 6.023_JPRB, 6.023_JPRB, 8.115_JPRB, 9.094_JPRB, &
  & 10.407_JPRB,12.344_JPRB,15.773_JPRB,18.661_JPRB,24.014_JPRB,39.387_JPRB /)
ALF_SU( :,5) = (/ &
  &  6.023_JPRB, 6.023_JPRB, 6.023_JPRB, 6.023_JPRB, 8.115_JPRB, 9.094_JPRB, &
  & 10.407_JPRB,12.344_JPRB,15.773_JPRB,18.661_JPRB,24.014_JPRB,39.387_JPRB /)

ALF_SU( :,6) = (/ &
  &  5.009_JPRB, 5.009_JPRB, 5.009_JPRB, 5.009_JPRB, 6.779_JPRB, 7.626_JPRB, &
  &  8.769_JPRB,10.466_JPRB,13.501_JPRB,16.072_JPRB,20.889_JPRB,34.944_JPRB /)
ALF_SU( :,7) = (/ &
  &  4.548_JPRB, 4.548_JPRB, 4.548_JPRB, 4.548_JPRB, 6.171_JPRB, 6.956_JPRB, &
  &  8.016_JPRB, 9.597_JPRB,12.438_JPRB,14.852_JPRB,19.397_JPRB,32.764_JPRB /)

ALF_SU( :,8) = (/ &
  &  4.311_JPRB, 4.311_JPRB, 4.311_JPRB, 4.311_JPRB, 5.858_JPRB, 6.609_JPRB, &
  &  7.626_JPRB, 9.145_JPRB,11.882_JPRB,14.211_JPRB,18.609_JPRB,31.596_JPRB /)
ALF_SU( :,9) = (/ &
  &  4.311_JPRB, 4.311_JPRB, 4.311_JPRB, 4.311_JPRB, 5.858_JPRB, 6.609_JPRB, &
  &  7.626_JPRB, 9.145_JPRB,11.882_JPRB,14.211_JPRB,18.609_JPRB,31.596_JPRB /)

ALF_SU(:,10) = (/ &
  &  3.053_JPRB, 3.053_JPRB, 3.053_JPRB, 3.053_JPRB, 4.191_JPRB, 4.758_JPRB, &
  &  5.532_JPRB, 6.700_JPRB, 8.836_JPRB,10.671_JPRB,14.193_JPRB,24.859_JPRB /)
ALF_SU(:,11) = (/ &
  &  2.155_JPRB, 2.155_JPRB, 2.155_JPRB, 2.155_JPRB, 2.992_JPRB, 3.416_JPRB, &
  &  3.999_JPRB, 4.886_JPRB, 6.532_JPRB, 7.958_JPRB,10.735_JPRB,19.336_JPRB /)
ALF_SU(:,12) = (/ &
  &  2.155_JPRB, 2.155_JPRB, 2.155_JPRB, 2.155_JPRB, 2.992_JPRB, 3.416_JPRB, &
  &  3.999_JPRB, 4.886_JPRB, 6.532_JPRB, 7.958_JPRB,10.735_JPRB,19.336_JPRB /)

ALF_SU(:,13) = (/ &
  &  1.827_JPRB, 1.827_JPRB, 1.827_JPRB, 1.827_JPRB, 2.551_JPRB, 2.920_JPRB, &
  &  3.429_JPRB, 4.207_JPRB, 5.657_JPRB, 6.920_JPRB, 9.392_JPRB,17.128_JPRB /)
ALF_SU(:,14) = (/ &
  &  1.827_JPRB, 1.827_JPRB, 1.827_JPRB, 1.827_JPRB, 2.551_JPRB, 2.920_JPRB, &
  &  3.429_JPRB, 4.207_JPRB, 5.657_JPRB, 6.920_JPRB, 9.392_JPRB,17.128_JPRB /)
ALF_SU(:,15) = (/ &
  &  1.827_JPRB, 1.827_JPRB, 1.827_JPRB, 1.827_JPRB, 2.551_JPRB, 2.920_JPRB, &
  &  3.429_JPRB, 4.207_JPRB, 5.657_JPRB, 6.920_JPRB, 9.392_JPRB,17.128_JPRB /)
ALF_SU(:,16) = (/ &
  &  1.827_JPRB, 1.827_JPRB, 1.827_JPRB, 1.827_JPRB, 2.551_JPRB, 2.920_JPRB, &
  &  3.429_JPRB, 4.207_JPRB, 5.657_JPRB, 6.920_JPRB, 9.392_JPRB,17.128_JPRB /)

! cg_aer_sulfate
ASY_SU( :,1) = (/ &
  &  0.640_JPRB,  .640_JPRB,  .640_JPRB,  .640_JPRB,  .695_JPRB,  .704_JPRB, &
  &   .713_JPRB,  .723_JPRB,  .734_JPRB,  .744_JPRB,  .754_JPRB,  .775_JPRB /)
ASY_SU( :,2) = (/ &
  &  0.640_JPRB,  .640_JPRB,  .640_JPRB,  .640_JPRB,  .695_JPRB,  .704_JPRB, &
  &   .713_JPRB,  .723_JPRB,  .734_JPRB,  .744_JPRB,  .754_JPRB,  .775_JPRB /)
ASY_SU( :,3) = (/ &
  &  0.640_JPRB,  .640_JPRB,  .640_JPRB,  .640_JPRB,  .695_JPRB,  .704_JPRB, &
  &   .713_JPRB,  .723_JPRB,  .734_JPRB,  .744_JPRB,  .754_JPRB,  .775_JPRB /)
ASY_SU( :,4) = (/ &
  &   .632_JPRB,  .632_JPRB,  .632_JPRB,  .632_JPRB,  .687_JPRB,  .696_JPRB, &
  &   .705_JPRB,  .716_JPRB,  .728_JPRB,  .738_JPRB,  .749_JPRB,  .771_JPRB /)
ASY_SU( :,5) = (/ &
  &   .632_JPRB,  .632_JPRB,  .632_JPRB,  .632_JPRB,  .687_JPRB,  .696_JPRB, &
  &   .705_JPRB,  .716_JPRB,  .728_JPRB,  .738_JPRB,  .749_JPRB,  .771_JPRB /)

ASY_SU( :,6) = (/ &
  &   .620_JPRB,  .620_JPRB,  .620_JPRB,  .620_JPRB,  .674_JPRB,  .683_JPRB, &
  &   .693_JPRB,  .704_JPRB,  .717_JPRB,  .728_JPRB,  .740_JPRB,  .764_JPRB /)
ASY_SU( :,7) = (/ &
  &   .613_JPRB,  .613_JPRB,  .613_JPRB,  .613_JPRB,  .667_JPRB,  .677_JPRB, &
  &   .687_JPRB,  .698_JPRB,  .711_JPRB,  .722_JPRB,  .735_JPRB,  .760_JPRB /)

ASY_SU( :,8) = (/ &
  &   .609_JPRB,  .609_JPRB,  .609_JPRB,  .609_JPRB,  .664_JPRB,  .673_JPRB, &
  &   .683_JPRB,  .694_JPRB,  .708_JPRB,  .719_JPRB,  .733_JPRB,  .758_JPRB /)
ASY_SU( :,9) = (/ &
  &   .609_JPRB,  .609_JPRB,  .609_JPRB,  .609_JPRB,  .664_JPRB,  .673_JPRB, &
  &   .683_JPRB,  .694_JPRB,  .708_JPRB,  .719_JPRB,  .733_JPRB,  .758_JPRB /)

ASY_SU(:,10) = (/ &
  &   .584_JPRB,  .584_JPRB,  .584_JPRB,  .584_JPRB,  .637_JPRB,  .647_JPRB, &
  &   .658_JPRB,  .670_JPRB,  .686_JPRB,  .698_JPRB,  .713_JPRB,  .742_JPRB /)
ASY_SU(:,11) = (/ &
  &   .558_JPRB,  .558_JPRB,  .558_JPRB,  .558_JPRB,  .609_JPRB,  .620_JPRB, &
  &   .631_JPRB,  .644_JPRB,  .661_JPRB,  .674_JPRB,  .691_JPRB,  .723_JPRB /)
ASY_SU(:,12) = (/ &
  &   .558_JPRB,  .558_JPRB,  .558_JPRB,  .558_JPRB,  .609_JPRB,  .620_JPRB, &
  &   .631_JPRB,  .644_JPRB,  .661_JPRB,  .674_JPRB,  .691_JPRB,  .723_JPRB /)

ASY_SU(:,13) = (/ &
  &   .546_JPRB,  .546_JPRB,  .546_JPRB,  .546_JPRB,  .596_JPRB,  .606_JPRB, &
  &   .618_JPRB,  .632_JPRB,  .649_JPRB,  .663_JPRB,  .680_JPRB,  .714_JPRB /)
ASY_SU(:,14) = (/ &
  &   .546_JPRB,  .546_JPRB,  .546_JPRB,  .546_JPRB,  .596_JPRB,  .606_JPRB, &
  &   .618_JPRB,  .632_JPRB,  .649_JPRB,  .663_JPRB,  .680_JPRB,  .714_JPRB /)
ASY_SU(:,15) = (/ &
  &   .546_JPRB,  .546_JPRB,  .546_JPRB,  .546_JPRB,  .596_JPRB,  .606_JPRB, &
  &   .618_JPRB,  .632_JPRB,  .649_JPRB,  .663_JPRB,  .680_JPRB,  .714_JPRB /)
ASY_SU(:,16) = (/ &
  &   .546_JPRB,  .546_JPRB,  .546_JPRB,  .546_JPRB,  .596_JPRB,  .606_JPRB, &
  &   .618_JPRB,  .632_JPRB,  .649_JPRB,  .663_JPRB,  .680_JPRB,  .714_JPRB /)

! om_aer_sulfate
OMG_SU( :,1) = (/ &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, & 
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SU( :,2) = (/ &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, & 
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SU( :,3) = (/ &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, & 
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SU( :,4) = (/ &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, & 
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /) 
OMG_SU( :,5) = (/ &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, & 
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /) 
OMG_SU( :,6) = (/ &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /) 
OMG_SU( :,7) = (/ &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, & 
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)  

OMG_SU( :,8) = (/ &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, & 
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /) 
OMG_SU( :,9) = (/ &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, & 
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /) 
OMG_SU(:,10) = (/ &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, &  
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /) 
OMG_SU(:,11) = (/ &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, & 
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SU(:,12) = (/ &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, & 
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SU(:,13) = (/ &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, & 
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SU(:,14) = (/ &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, & 
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SU(:,15) = (/ &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, & 
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SU(:,16) = (/ &
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, & 
  &  1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)


! alpha_aer_om (organic matter)
ALF_OM( :,1) = (/ &
  &  4.973_JPRB, 4.973_JPRB, 4.973_JPRB, 4.973_JPRB, 7.408_JPRB, 8.294_JPRB, &
  &  9.468_JPRB,11.168_JPRB,14.087_JPRB,16.688_JPRB,21.321_JPRB,24.076_JPRB /)
ALF_OM( :,2) = (/ &
  &  4.973_JPRB, 4.973_JPRB, 4.973_JPRB, 4.973_JPRB, 7.408_JPRB, 8.294_JPRB, &
  &  9.468_JPRB,11.168_JPRB,14.087_JPRB,16.688_JPRB,21.321_JPRB,24.076_JPRB /)
ALF_OM( :,3) = (/ &
  &  4.973_JPRB, 4.973_JPRB, 4.973_JPRB, 4.973_JPRB, 7.408_JPRB, 8.294_JPRB, &
  &  9.468_JPRB,11.168_JPRB,14.087_JPRB,16.688_JPRB,21.321_JPRB,24.076_JPRB /)
ALF_OM( :,4) = (/ &
  &  4.396_JPRB, 4.396_JPRB, 4.396_JPRB, 4.396_JPRB, 6.612_JPRB, 7.425_JPRB, &
  &  8.508_JPRB,10.084_JPRB,12.810_JPRB,15.257_JPRB,19.652_JPRB,22.764_JPRB /)
ALF_OM( :,5) = (/ &
  &  4.396_JPRB, 4.396_JPRB, 4.396_JPRB, 4.396_JPRB, 6.612_JPRB, 7.425_JPRB, &
  &  8.508_JPRB,10.084_JPRB,12.810_JPRB,15.257_JPRB,19.652_JPRB,22.764_JPRB /)

ALF_OM( :,6) = (/ &
  &  3.664_JPRB, 3.664_JPRB, 3.664_JPRB, 3.664_JPRB, 5.585_JPRB, 6.298_JPRB, &
  &  7.253_JPRB, 8.652_JPRB,11.097_JPRB,13.314_JPRB,17.340_JPRB,20.901_JPRB /)
ALF_OM( :,7) = (/ &
  &  3.331_JPRB, 3.331_JPRB, 3.331_JPRB, 3.331_JPRB, 5.111_JPRB, 5.775_JPRB, &
  &  6.667_JPRB, 7.979_JPRB,10.281_JPRB,12.380_JPRB,16.211_JPRB,19.964_JPRB /)

ALF_OM( :,8) = (/ &
  &  3.159_JPRB, 3.159_JPRB, 3.159_JPRB, 3.159_JPRB, 4.865_JPRB, 5.502_JPRB, &
  &  6.361_JPRB, 7.625_JPRB, 9.851_JPRB,11.885_JPRB,15.608_JPRB,19.454_JPRB /)
ALF_OM( :,9) = (/ &
  &  3.159_JPRB, 3.159_JPRB, 3.159_JPRB, 3.159_JPRB, 4.865_JPRB, 5.502_JPRB, &
  &  6.361_JPRB, 7.625_JPRB, 9.851_JPRB,11.885_JPRB,15.608_JPRB,19.454_JPRB /)

ALF_OM(:,10) = (/ &
  &  2.248_JPRB, 2.248_JPRB, 2.248_JPRB, 2.248_JPRB, 3.537_JPRB, 4.027_JPRB, &
  &  4.692_JPRB, 5.682_JPRB, 7.451_JPRB, 9.094_JPRB,12.150_JPRB,16.386_JPRB /)
ALF_OM(:,11) = (/ &
  &  1.595_JPRB, 1.595_JPRB, 1.595_JPRB, 1.595_JPRB, 2.559_JPRB, 2.931_JPRB, &
  &  3.439_JPRB, 4.203_JPRB, 5.587_JPRB, 6.888_JPRB, 9.348_JPRB,13.658_JPRB /)
ALF_OM(:,12) = (/ &
  &  1.595_JPRB, 1.595_JPRB, 1.595_JPRB, 1.595_JPRB, 2.559_JPRB, 2.931_JPRB, &
  &  3.439_JPRB, 4.203_JPRB, 5.587_JPRB, 6.888_JPRB, 9.348_JPRB,13.658_JPRB /)

ALF_OM(:,13) = (/ &
  &  1.356_JPRB, 1.356_JPRB, 1.356_JPRB, 1.356_JPRB, 2.195_JPRB, 2.520_JPRB, &
  &  2.967_JPRB, 3.641_JPRB, 4.867_JPRB, 6.028_JPRB, 8.236_JPRB,12.495_JPRB /)
ALF_OM(:,14) = (/ &
  &  1.356_JPRB, 1.356_JPRB, 1.356_JPRB, 1.356_JPRB, 2.195_JPRB, 2.520_JPRB, &
  &  2.967_JPRB, 3.641_JPRB, 4.867_JPRB, 6.028_JPRB, 8.236_JPRB,12.495_JPRB /)
ALF_OM(:,15) = (/ &
  &  1.356_JPRB, 1.356_JPRB, 1.356_JPRB, 1.356_JPRB, 2.195_JPRB, 2.520_JPRB, &
  &  2.967_JPRB, 3.641_JPRB, 4.867_JPRB, 6.028_JPRB, 8.236_JPRB,12.495_JPRB /)
ALF_OM(:,16) = (/ &
  &  1.356_JPRB, 1.356_JPRB, 1.356_JPRB, 1.356_JPRB, 2.195_JPRB, 2.520_JPRB, &
  &  2.967_JPRB, 3.641_JPRB, 4.867_JPRB, 6.028_JPRB, 8.236_JPRB,12.495_JPRB /)

ASY_OM( :,1) = (/ &
  &   .644_JPRB,  .644_JPRB,  .644_JPRB,  .644_JPRB,  .676_JPRB,  .684_JPRB, &
  &   .692_JPRB,  .700_JPRB,  .711_JPRB,  .718_JPRB,  .726_JPRB,  .543_JPRB /)
ASY_OM( :,2) = (/ &
  &   .644_JPRB,  .644_JPRB,  .644_JPRB,  .644_JPRB,  .676_JPRB,  .684_JPRB, &
  &   .692_JPRB,  .700_JPRB,  .711_JPRB,  .718_JPRB,  .726_JPRB,  .543_JPRB /)
ASY_OM( :,3) = (/ &
  &   .644_JPRB,  .644_JPRB,  .644_JPRB,  .644_JPRB,  .676_JPRB,  .684_JPRB, &
  &   .692_JPRB,  .700_JPRB,  .711_JPRB,  .718_JPRB,  .726_JPRB,  .543_JPRB /)
ASY_OM( :,4) = (/ &
  &   .635_JPRB,  .635_JPRB,  .635_JPRB,  .635_JPRB,  .669_JPRB,  .676_JPRB, &
  &   .685_JPRB,  .694_JPRB,  .705_JPRB,  .713_JPRB,  .721_JPRB,  .538_JPRB /)
ASY_OM( :,5) = (/ &
  &   .635_JPRB,  .635_JPRB,  .635_JPRB,  .635_JPRB,  .669_JPRB,  .676_JPRB, &
  &   .685_JPRB,  .694_JPRB,  .705_JPRB,  .713_JPRB,  .721_JPRB,  .538_JPRB /)

ASY_OM( :,6) = (/ &
  &   .623_JPRB,  .623_JPRB,  .623_JPRB,  .623_JPRB,  .657_JPRB,  .665_JPRB, &
  &   .674_JPRB,  .684_JPRB,  .696_JPRB,  .704_JPRB,  .714_JPRB,  .529_JPRB /)
ASY_OM( :,7) = (/ &
  &   .616_JPRB,  .616_JPRB,  .616_JPRB,  .616_JPRB,  .651_JPRB,  .659_JPRB, &
  &   .668_JPRB,  .678_JPRB,  .691_JPRB,  .699_JPRB,  .710_JPRB,  .524_JPRB /)

ASY_OM( :,8) = (/ &
  &   .612_JPRB,  .612_JPRB,  .612_JPRB,  .612_JPRB,  .647_JPRB,  .655_JPRB, &
  &   .664_JPRB,  .675_JPRB,  .688_JPRB,  .696_JPRB,  .707_JPRB,  .521_JPRB /)
ASY_OM( :,9) = (/ &
  &   .612_JPRB,  .612_JPRB,  .612_JPRB,  .612_JPRB,  .647_JPRB,  .655_JPRB, &
  &   .664_JPRB,  .675_JPRB,  .688_JPRB,  .696_JPRB,  .707_JPRB,  .521_JPRB /)

ASY_OM(:,10) = (/ &
  &   .586_JPRB,  .586_JPRB,  .586_JPRB,  .586_JPRB,  .623_JPRB,  .632_JPRB, &
  &   .641_JPRB,  .653_JPRB,  .667_JPRB,  .677_JPRB,  .690_JPRB,  .502_JPRB /)
ASY_OM(:,11) = (/ &
  &   .559_JPRB,  .559_JPRB,  .559_JPRB,  .559_JPRB,  .597_JPRB,  .606_JPRB, &
  &   .617_JPRB,  .629_JPRB,  .645_JPRB,  .656_JPRB,  .670_JPRB,  .482_JPRB /)
ASY_OM(:,12) = (/ &
  &   .559_JPRB,  .559_JPRB,  .559_JPRB,  .559_JPRB,  .597_JPRB,  .606_JPRB, &
  &   .617_JPRB,  .629_JPRB,  .645_JPRB,  .656_JPRB,  .670_JPRB,  .482_JPRB /)

ASY_OM(:,13) = (/ &
  &   .546_JPRB,  .546_JPRB,  .546_JPRB,  .546_JPRB,  .584_JPRB,  .594_JPRB, &
  &   .605_JPRB,  .617_JPRB,  .634_JPRB,  .645_JPRB,  .660_JPRB,  .472_JPRB /)
ASY_OM(:,14) = (/ &
  &   .546_JPRB,  .546_JPRB,  .546_JPRB,  .546_JPRB,  .584_JPRB,  .594_JPRB, &
  &   .605_JPRB,  .617_JPRB,  .634_JPRB,  .645_JPRB,  .660_JPRB,  .472_JPRB /)
ASY_OM(:,15) = (/ &
  &   .546_JPRB,  .546_JPRB,  .546_JPRB,  .546_JPRB,  .584_JPRB,  .594_JPRB, &
  &   .605_JPRB,  .617_JPRB,  .634_JPRB,  .645_JPRB,  .660_JPRB,  .472_JPRB /)
ASY_OM(:,16) = (/ &
  &   .546_JPRB,  .546_JPRB,  .546_JPRB,  .546_JPRB,  .584_JPRB,  .594_JPRB, &
  &   .605_JPRB,  .617_JPRB,  .634_JPRB,  .645_JPRB,  .660_JPRB,  .472_JPRB /)

OMG_OM( :,1) = (/ &
  &   .971_JPRB,  .971_JPRB,  .971_JPRB,  .971_JPRB,  .980_JPRB,  .982_JPRB, &
  &   .984_JPRB,  .987_JPRB,  .989_JPRB,  .991_JPRB,  .993_JPRB, 1.000_JPRB /)
OMG_OM( :,2) = (/ &
  &   .971_JPRB,  .971_JPRB,  .971_JPRB,  .971_JPRB,  .980_JPRB,  .982_JPRB, &
  &   .984_JPRB,  .987_JPRB,  .989_JPRB,  .991_JPRB,  .993_JPRB, 1.000_JPRB /)
OMG_OM( :,3) = (/ &
  &   .971_JPRB,  .971_JPRB,  .971_JPRB,  .971_JPRB,  .980_JPRB,  .982_JPRB, &
  &   .984_JPRB,  .987_JPRB,  .989_JPRB,  .991_JPRB,  .993_JPRB, 1.000_JPRB /)
OMG_OM( :,4) = (/ &
  &   .971_JPRB,  .971_JPRB,  .971_JPRB,  .971_JPRB,  .980_JPRB,  .982_JPRB, & 
  &   .985_JPRB,  .987_JPRB,  .990_JPRB,  .991_JPRB,  .993_JPRB, 1.000_JPRB /)
OMG_OM( :,5) = (/ &
  &   .971_JPRB,  .971_JPRB,  .971_JPRB,  .971_JPRB,  .980_JPRB,  .982_JPRB, & 
  &   .985_JPRB,  .987_JPRB,  .990_JPRB,  .991_JPRB,  .993_JPRB, 1.000_JPRB /)

OMG_OM( :,6) = (/ &
  &   .970_JPRB,  .970_JPRB,  .970_JPRB,  .970_JPRB,  .980_JPRB,  .982_JPRB, &
  &   .984_JPRB,  .987_JPRB,  .990_JPRB,  .991_JPRB,  .993_JPRB, 1.000_JPRB /)
OMG_OM( :,7) = (/ &
  &   .970_JPRB,  .970_JPRB,  .970_JPRB,  .970_JPRB,  .980_JPRB,  .982_JPRB, &
  &   .984_JPRB,  .987_JPRB,  .990_JPRB,  .991_JPRB,  .993_JPRB, 1.000_JPRB /)

OMG_OM( :,8) = (/ &
  &   .969_JPRB,  .969_JPRB,  .969_JPRB,  .969_JPRB,  .980_JPRB,  .982_JPRB, &
  &   .984_JPRB,  .987_JPRB,  .990_JPRB,  .991_JPRB,  .993_JPRB, 1.000_JPRB /)
OMG_OM( :,9) = (/ &
  &   .969_JPRB,  .969_JPRB,  .969_JPRB,  .969_JPRB,  .980_JPRB,  .982_JPRB, &
  &   .984_JPRB,  .987_JPRB,  .990_JPRB,  .991_JPRB,  .993_JPRB, 1.000_JPRB /)

OMG_OM(:,10) = (/ &
  &   .967_JPRB,  .967_JPRB,  .967_JPRB,  .967_JPRB,  .979_JPRB,  .981_JPRB, &
  &   .984_JPRB,  .986_JPRB,  .989_JPRB,  .991_JPRB,  .993_JPRB, 1.000_JPRB /)
OMG_OM(:,11) = (/ &
  &   .964_JPRB,  .964_JPRB,  .964_JPRB,  .964_JPRB,  .977_JPRB,  .979_JPRB, &
  &   .982_JPRB,  .985_JPRB,  .989_JPRB,  .991_JPRB,  .993_JPRB, 1.000_JPRB /)
OMG_OM(:,12) = (/ &
  &   .964_JPRB,  .964_JPRB,  .964_JPRB,  .964_JPRB,  .977_JPRB,  .979_JPRB, &
  &   .982_JPRB,  .985_JPRB,  .989_JPRB,  .991_JPRB,  .993_JPRB, 1.000_JPRB /)

OMG_OM(:,13) = (/ &
  &   .962_JPRB,  .962_JPRB,  .962_JPRB,  .962_JPRB,  .976_JPRB,  .979_JPRB, &
  &   .982_JPRB,  .985_JPRB,  .988_JPRB,  .990_JPRB,  .993_JPRB,  .999_JPRB /)
OMG_OM(:,14) = (/ &
  &   .962_JPRB,  .962_JPRB,  .962_JPRB,  .962_JPRB,  .976_JPRB,  .979_JPRB, &
  &   .982_JPRB,  .985_JPRB,  .988_JPRB,  .990_JPRB,  .993_JPRB,  .999_JPRB /)
OMG_OM(:,15) = (/ &
  &   .962_JPRB,  .962_JPRB,  .962_JPRB,  .962_JPRB,  .976_JPRB,  .979_JPRB, &
  &   .982_JPRB,  .985_JPRB,  .988_JPRB,  .990_JPRB,  .993_JPRB,  .999_JPRB /)
OMG_OM(:,16) = (/ &
  &   .962_JPRB,  .962_JPRB,  .962_JPRB,  .962_JPRB,  .976_JPRB,  .979_JPRB, &
  &   .982_JPRB,  .985_JPRB,  .988_JPRB,  .990_JPRB,  .993_JPRB,  .999_JPRB /)


!alpha_aer_dd (desert dust) 
!                    bin1,       bin2,       bin3
ALF_DD( :,1) = (/ 2.210_JPRB, 1.011_JPRB,  .398_JPRB /)
ALF_DD( :,2) = (/ 2.210_JPRB, 1.011_JPRB,  .398_JPRB /)
ALF_DD( :,3) = (/ 2.210_JPRB, 1.011_JPRB,  .398_JPRB /)
ALF_DD( :,4) = (/ 2.357_JPRB,  .985_JPRB,  .398_JPRB /)
ALF_DD( :,5) = (/ 2.453_JPRB, 0.949_JPRB, 0.404_JPRB /)
ALF_DD( :,6) = (/ 2.549_JPRB,  .901_JPRB,  .414_JPRB /)
ALF_DD( :,7) = (/ 2.605_JPRB,  .877_JPRB,  .423_JPRB /)
ALF_DD( :,8) = (/ 2.635_JPRB, 0.869_JPRB, 0.428_JPRB /)
ALF_DD( :,9) = (/ 2.596_JPRB, 0.978_JPRB, 0.428_JPRB /)
ALF_DD(:,10) = (/ 2.555_JPRB, 1.039_JPRB,  .424_JPRB /)
ALF_DD(:,11) = (/ 2.227_JPRB, 1.360_JPRB,  .404_JPRB /)
ALF_DD(:,12) = (/ 2.058_JPRB, 1.460_JPRB, 0.405_JPRB /)
ALF_DD(:,13) = (/ 2.041_JPRB, 1.474_JPRB,  .405_JPRB /)
ALF_DD(:,14) = (/ 1.117_JPRB, 1.523_JPRB, 0.502_JPRB /)
ALF_DD(:,15) = (/ 0.583_JPRB, 1.117_JPRB, 0.596_JPRB /)
ALF_DD(:,16) = (/ 0.263_JPRB, 0.705_JPRB, 0.607_JPRB /)

ASY_DD( :,1) = (/  .673_JPRB,  .745_JPRB,  .799_JPRB /)
ASY_DD( :,2) = (/  .673_JPRB,  .745_JPRB,  .799_JPRB /)
ASY_DD( :,3) = (/  .673_JPRB,  .745_JPRB,  .799_JPRB /)
ASY_DD( :,4) = (/  .691_JPRB,  .712_JPRB,  .792_JPRB /)
ASY_DD( :,5) = (/ 0.704_JPRB, 0.679_JPRB, 0.791_JPRB /)
ASY_DD( :,6) = (/  .715_JPRB,  .640_JPRB,  .786_JPRB /)
ASY_DD( :,7) = (/  .726_JPRB,  .605_JPRB,  .782_JPRB /)
ASY_DD( :,8) = (/ 0.731_JPRB, 0.591_JPRB, 0.782_JPRB /)
ASY_DD( :,9) = (/ 0.741_JPRB, 0.606_JPRB, 0.756_JPRB /)
ASY_DD(:,10) = (/  .740_JPRB,  .617_JPRB,  .738_JPRB /)
ASY_DD(:,11) = (/  .732_JPRB,  .698_JPRB,  .687_JPRB /)
ASY_DD(:,12) = (/ 0.725_JPRB, 0.722_JPRB, 0.679_JPRB /)
ASY_DD(:,13) = (/  .723_JPRB,  .722_JPRB,  .669_JPRB /)
ASY_DD(:,14) = (/ 0.645_JPRB, 0.755_JPRB, 0.682_JPRB /)
ASY_DD(:,15) = (/ 0.556_JPRB, 0.716_JPRB, 0.718_JPRB /)
ASY_DD(:,16) = (/ 0.392_JPRB, 0.652_JPRB, 0.730_JPRB /)

OMG_DD( :,1) = (/  .974_JPRB,  .944_JPRB,  .894_JPRB /)
OMG_DD( :,2) = (/  .974_JPRB,  .944_JPRB,  .894_JPRB /)
OMG_DD( :,3) = (/  .974_JPRB,  .944_JPRB,  .894_JPRB /)
OMG_DD( :,4) = (/  .978_JPRB,  .947_JPRB,  .900_JPRB /)
OMG_DD( :,5) = (/ 0.980_JPRB, 0.947_JPRB, 0.905_JPRB /)
OMG_DD( :,6) = (/  .985_JPRB,  .957_JPRB,  .926_JPRB /)
OMG_DD( :,7) = (/  .988_JPRB,  .963_JPRB,  .938_JPRB /)
OMG_DD( :,8) = (/ 0.987_JPRB, 0.960_JPRB, 0.933_JPRB /)
OMG_DD( :,9) = (/ 0.990_JPRB, 0.973_JPRB, 0.946_JPRB /)
OMG_DD(:,10) = (/  .996_JPRB,  .990_JPRB,  .978_JPRB /)
OMG_DD(:,11) = (/  .997_JPRB,  .994_JPRB,  .982_JPRB /)
OMG_DD(:,12) = (/ 0.992_JPRB, 0.988_JPRB, 0.958_JPRB /)
OMG_DD(:,13) = (/  .997_JPRB,  .996_JPRB,  .984_JPRB /)
OMG_DD(:,14) = (/ 0.996_JPRB, 0.997_JPRB, 0.989_JPRB /)
OMG_DD(:,15) = (/ 0.995_JPRB, 0.997_JPRB, 0.994_JPRB /)
OMG_DD(:,16) = (/ 0.994_JPRB, 0.997_JPRB, 0.996_JPRB /)


!-- For sea-salt, XX( RH, wavelength, binNo)

! BIN No. 1
! optical thickness
ALF_SS( :, 1, 1) = (/ &
  & 1.299_JPRB, 1.299_JPRB, 1.299_JPRB, 1.299_JPRB, 3.482_JPRB, 3.940_JPRB, &
  & 4.572_JPRB, 5.358_JPRB, 6.455_JPRB, 7.261_JPRB, 8.565_JPRB,11.796_JPRB /)
ALF_SS( :, 2, 1) = (/ &
  & 1.299_JPRB, 1.299_JPRB, 1.299_JPRB, 1.299_JPRB, 3.482_JPRB, 3.940_JPRB, &
  & 4.572_JPRB, 5.358_JPRB, 6.455_JPRB, 7.261_JPRB, 8.565_JPRB,11.796_JPRB /)
ALF_SS( :, 3, 1) = (/ &
  & 1.299_JPRB, 1.299_JPRB, 1.299_JPRB, 1.299_JPRB, 3.482_JPRB, 3.940_JPRB, &
  & 4.572_JPRB, 5.358_JPRB, 6.455_JPRB, 7.261_JPRB, 8.565_JPRB,11.796_JPRB /)
ALF_SS( :, 4, 1) = (/ &
  & 1.143_JPRB, 1.143_JPRB, 1.143_JPRB, 1.143_JPRB, 3.393_JPRB, 3.761_JPRB, &
  & 4.436_JPRB, 5.291_JPRB, 6.530_JPRB, 7.452_JPRB, 8.917_JPRB,12.189_JPRB /)
ALF_SS( :, 5, 1) = (/ &
  & 1.031_JPRB, 1.031_JPRB, 1.031_JPRB, 1.031_JPRB, 3.266_JPRB, 3.589_JPRB, &
  & 4.286_JPRB, 5.165_JPRB, 6.472_JPRB, 7.496_JPRB, 9.102_JPRB,12.541_JPRB /)

ALF_SS( :, 6, 1) = (/ &
  &  .927_JPRB,  .927_JPRB,  .927_JPRB,  .927_JPRB, 3.124_JPRB, 3.387_JPRB, &
  & 4.083_JPRB, 4.985_JPRB, 6.361_JPRB, 7.426_JPRB, 9.175_JPRB,12.904_JPRB /)
ALF_SS( :, 7, 1) = (/ &
  &  .830_JPRB,  .830_JPRB,  .830_JPRB,  .830_JPRB, 2.943_JPRB, 3.174_JPRB, &
  & 3.855_JPRB, 4.761_JPRB, 6.156_JPRB, 7.300_JPRB, 9.170_JPRB,13.236_JPRB /)

ALF_SS( :, 8, 1) = (/ &
  & 0.763_JPRB, 0.763_JPRB, 0.763_JPRB, 0.763_JPRB, 2.806_JPRB, 3.012_JPRB, &
  & 3.691_JPRB, 4.578_JPRB, 5.999_JPRB, 7.146_JPRB, 9.085_JPRB,13.416_JPRB /)
ALF_SS( :, 9, 1) = (/ &
  & 0.545_JPRB, 0.545_JPRB, 0.545_JPRB, 0.545_JPRB, 2.301_JPRB, 2.434_JPRB, &
  & 3.035_JPRB, 3.857_JPRB, 5.227_JPRB, 6.386_JPRB, 8.466_JPRB,13.570_JPRB /)

ALF_SS( :,10, 1) = (/ &
  &  .500_JPRB,  .500_JPRB,  .500_JPRB,  .500_JPRB, 2.162_JPRB, 2.283_JPRB, &
  & 2.869_JPRB, 3.662_JPRB, 5.004_JPRB, 6.147_JPRB, 8.239_JPRB,13.447_JPRB /)
ALF_SS( :,11, 1) = (/ &
  &  .314_JPRB,  .314_JPRB,  .314_JPRB,  .314_JPRB, 1.575_JPRB, 1.648_JPRB, &
  & 2.106_JPRB, 2.754_JPRB, 3.898_JPRB, 4.910_JPRB, 6.855_JPRB,12.275_JPRB /)
ALF_SS( :,12, 1) = (/ &
  & 0.252_JPRB, 0.252_JPRB, 0.252_JPRB, 0.252_JPRB, 1.350_JPRB, 1.417_JPRB, &
  & 1.836_JPRB, 2.425_JPRB, 3.458_JPRB, 4.416_JPRB, 6.229_JPRB,11.532_JPRB /)

ALF_SS( :,13, 1) = (/ &
  &  .246_JPRB,  .246_JPRB,  .246_JPRB,  .246_JPRB, 1.325_JPRB, 1.391_JPRB, &
  & 1.805_JPRB, 2.388_JPRB, 3.408_JPRB, 4.357_JPRB, 6.157_JPRB,11.438_JPRB /)
ALF_SS( :,14, 1) = (/ &
  & 0.078_JPRB, 0.078_JPRB, 0.078_JPRB, 0.078_JPRB, 0.516_JPRB, 0.557_JPRB, &
  & 0.759_JPRB, 1.059_JPRB, 1.601_JPRB, 2.125_JPRB, 3.232_JPRB, 6.884_JPRB /)
ALF_SS( :,15, 1) = (/ &
  & 0.028_JPRB, 0.028_JPRB, 0.028_JPRB, 0.028_JPRB, 0.213_JPRB, 0.237_JPRB, &
  & 0.327_JPRB, 0.466_JPRB, 0.746_JPRB, 1.037_JPRB, 1.666_JPRB, 3.881_JPRB /)
ALF_SS( :,16, 1) = (/ &
  & 0.010_JPRB, 0.010_JPRB, 0.010_JPRB, 0.010_JPRB, 0.086_JPRB, 0.099_JPRB, &
  & 0.141_JPRB, 0.207_JPRB, 0.338_JPRB, 0.472_JPRB, 0.773_JPRB, 2.013_JPRB /)






! assymetry factor
ASY_SS( :, 1, 1) = (/ & 
  &  .698_JPRB,  .698_JPRB,  .698_JPRB,  .698_JPRB,  .707_JPRB,  .754_JPRB, &
  &  .756_JPRB,  .755_JPRB,  .750_JPRB,  .744_JPRB,  .732_JPRB,  .717_JPRB /)
ASY_SS( :, 2, 1) = (/ & 
  &  .698_JPRB,  .698_JPRB,  .698_JPRB,  .698_JPRB,  .707_JPRB,  .754_JPRB, &
  &  .756_JPRB,  .755_JPRB,  .750_JPRB,  .744_JPRB,  .732_JPRB,  .717_JPRB /)
ASY_SS( :, 3, 1) = (/ & 
  &  .698_JPRB,  .698_JPRB,  .698_JPRB,  .698_JPRB,  .707_JPRB,  .754_JPRB, &
  &  .756_JPRB,  .755_JPRB,  .750_JPRB,  .744_JPRB,  .732_JPRB,  .717_JPRB /)
ASY_SS( :, 4, 1) = (/ & 
  &  .682_JPRB,  .682_JPRB,  .682_JPRB,  .682_JPRB,  .711_JPRB,  .755_JPRB, &
  &  .759_JPRB,  .762_JPRB,  .760_JPRB,  .757_JPRB,  .747_JPRB,  .724_JPRB /)
ASY_SS( :, 5, 1) = (/ & 
  & 0.670_JPRB, 0.670_JPRB, 0.670_JPRB, 0.670_JPRB, 0.711_JPRB, 0.753_JPRB, &
  & 0.759_JPRB, 0.763_JPRB, 0.765_JPRB, 0.763_JPRB, 0.756_JPRB, 0.733_JPRB /)

ASY_SS( :, 6, 1) = (/ & 
  &  .659_JPRB,  .659_JPRB,  .659_JPRB,  .659_JPRB,  .709_JPRB,  .749_JPRB, &
  &  .756_JPRB,  .763_JPRB,  .767_JPRB,  .767_JPRB,  .764_JPRB,  .743_JPRB /)
ASY_SS( :, 7, 1) = (/ & 
  &  .645_JPRB,  .645_JPRB,  .645_JPRB,  .645_JPRB,  .705_JPRB,  .743_JPRB, &
  &  .752_JPRB,  .761_JPRB,  .767_JPRB,  .770_JPRB,  .768_JPRB,  .751_JPRB /)

ASY_SS( :, 8, 1) = (/ & 
  & 0.633_JPRB, 0.633_JPRB, 0.633_JPRB, 0.633_JPRB, 0.701_JPRB, 0.738_JPRB, &
  & 0.749_JPRB, 0.758_JPRB, 0.767_JPRB, 0.769_JPRB, 0.771_JPRB, 0.758_JPRB /)
ASY_SS( :, 9, 1) = (/ & 
  & 0.581_JPRB, 0.581_JPRB, 0.581_JPRB, 0.581_JPRB, 0.679_JPRB, 0.715_JPRB, &
  & 0.729_JPRB, 0.743_JPRB, 0.757_JPRB, 0.764_JPRB, 0.772_JPRB, 0.772_JPRB /)

ASY_SS( :,10, 1) = (/ & 
  &  .569_JPRB,  .569_JPRB,  .569_JPRB,  .569_JPRB,  .672_JPRB,  .707_JPRB, &
  &  .723_JPRB,  .738_JPRB,  .753_JPRB,  .761_JPRB,  .771_JPRB,  .774_JPRB /)
ASY_SS( :,11, 1) = (/ & 
  &  .513_JPRB,  .513_JPRB,  .513_JPRB,  .513_JPRB,  .633_JPRB,  .667_JPRB, &
  &  .685_JPRB,  .704_JPRB,  .726_JPRB,  .740_JPRB,  .756_JPRB,  .774_JPRB /)
ASY_SS( :,12, 1) = (/ & 
  & 0.475_JPRB, 0.475_JPRB, 0.475_JPRB, 0.475_JPRB, 0.609_JPRB, 0.644_JPRB, &
  & 0.667_JPRB, 0.688_JPRB, 0.712_JPRB, 0.727_JPRB, 0.746_JPRB, 0.770_JPRB /)

ASY_SS( :,13, 1) = (/ & 
  &  .470_JPRB,  .470_JPRB,  .470_JPRB,  .470_JPRB,  .606_JPRB,  .641_JPRB, &
  &  .665_JPRB,  .686_JPRB,  .710_JPRB,  .726_JPRB,  .745_JPRB,  .769_JPRB /)
ASY_SS( :,14, 1) = (/ & 
  & 0.230_JPRB, 0.230_JPRB, 0.230_JPRB, 0.230_JPRB, 0.473_JPRB, 0.506_JPRB, &
  & 0.539_JPRB, 0.568_JPRB, 0.601_JPRB, 0.627_JPRB, 0.664_JPRB, 0.716_JPRB /)
ASY_SS( :,15, 1) = (/ & 
  & 0.128_JPRB, 0.128_JPRB, 0.128_JPRB, 0.128_JPRB, 0.276_JPRB, 0.311_JPRB, &
  & 0.357_JPRB, 0.413_JPRB, 0.482_JPRB, 0.522_JPRB, 0.566_JPRB, 0.635_JPRB /)
ASY_SS( :,16, 1) = (/ & 
  & 0.076_JPRB, 0.076_JPRB, 0.076_JPRB, 0.076_JPRB, 0.158_JPRB, 0.179_JPRB, &
  & 0.206_JPRB, 0.242_JPRB, 0.297_JPRB, 0.343_JPRB, 0.417_JPRB, 0.540_JPRB /)

! single scattering albedo
OMG_SS( :, 1, 1) = (/ &
  &  .999_JPRB,  .999_JPRB,  .999_JPRB,  .999_JPRB,  .999_JPRB, 1.000_JPRB, &
  & 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SS( :, 2, 1) = (/ &
  &  .999_JPRB,  .999_JPRB,  .999_JPRB,  .999_JPRB,  .999_JPRB, 1.000_JPRB, &
  & 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SS( :, 3, 1) = (/ &
  &  .999_JPRB,  .999_JPRB,  .999_JPRB,  .999_JPRB,  .999_JPRB, 1.000_JPRB, &
  & 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SS( :, 4, 1) = (/ &
  &  .999_JPRB,  .999_JPRB,  .999_JPRB,  .999_JPRB,  .999_JPRB, 1.000_JPRB, &
  & 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SS( :, 5, 1) = (/ &
  & 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 1.000_JPRB, &
  & 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)

OMG_SS( :, 6, 1) = (/ &
  &  .999_JPRB,  .999_JPRB,  .999_JPRB,  .999_JPRB,  .999_JPRB, 1.000_JPRB, &
  & 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SS( :, 7, 1) = (/ &
  &  .999_JPRB,  .999_JPRB,  .999_JPRB,  .999_JPRB,  .999_JPRB, 1.000_JPRB, &
  & 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)

OMG_SS( :, 8, 1) = (/ &
  & 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 1.000_JPRB, &
  & 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SS( :, 9, 1) = (/ &
  & 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 1.000_JPRB, &
  & 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)

OMG_SS( :,10, 1) = (/ &
  &  .999_JPRB,  .999_JPRB,  .999_JPRB,  .999_JPRB,  .999_JPRB, 1.000_JPRB, &
  & 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SS( :,11, 1) = (/ &
  &  .998_JPRB,  .998_JPRB,  .998_JPRB,  .998_JPRB,  .999_JPRB, 1.000_JPRB, &
  & 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SS( :,12, 1) = (/ &
  & 0.998_JPRB, 0.998_JPRB, 0.998_JPRB, 0.998_JPRB, 0.999_JPRB, 1.000_JPRB, &
  & 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)

OMG_SS( :,13, 1) = (/ &
  &  .998_JPRB,  .998_JPRB,  .998_JPRB,  .998_JPRB,  .999_JPRB, 1.000_JPRB, &
  & 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SS( :,14, 1) = (/ &
  & 0.997_JPRB, 0.997_JPRB, 0.997_JPRB, 0.997_JPRB, 0.998_JPRB, 0.999_JPRB, &
  & 0.999_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SS( :,15, 1) = (/ &
  & 0.994_JPRB, 0.994_JPRB, 0.994_JPRB, 0.994_JPRB, 0.997_JPRB, 0.999_JPRB, &
  & 0.999_JPRB, 0.999_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)
OMG_SS( :,16, 1) = (/ &
  & 0.988_JPRB, 0.988_JPRB, 0.988_JPRB, 0.988_JPRB, 0.995_JPRB, 0.998_JPRB, &
  & 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 1.000_JPRB, 1.000_JPRB, 1.000_JPRB /)

! BIN No. 2
ALF_SS( :, 1, 2) = (/ &
  &  .137_JPRB,  .137_JPRB,  .137_JPRB,  .137_JPRB,  .264_JPRB,  .309_JPRB, &
  &  .351_JPRB,  .406_JPRB,  .494_JPRB,  .567_JPRB,  .697_JPRB, 1.031_JPRB /)
ALF_SS( :, 2, 2) = (/ &
  &  .137_JPRB,  .137_JPRB,  .137_JPRB,  .137_JPRB,  .264_JPRB,  .309_JPRB, &
  &  .351_JPRB,  .406_JPRB,  .494_JPRB,  .567_JPRB,  .697_JPRB, 1.031_JPRB /)
ALF_SS( :, 3, 2) = (/ &
  &  .137_JPRB,  .137_JPRB,  .137_JPRB,  .137_JPRB,  .264_JPRB,  .309_JPRB, &
  &  .351_JPRB,  .406_JPRB,  .494_JPRB,  .567_JPRB,  .697_JPRB, 1.031_JPRB /)
ALF_SS( :, 4, 2) = (/ &
  &  .140_JPRB,  .140_JPRB,  .140_JPRB,  .140_JPRB,  .268_JPRB,  .313_JPRB, &
  &  .356_JPRB,  .411_JPRB,  .496_JPRB,  .568_JPRB,  .697_JPRB, 1.035_JPRB /)
ALF_SS( :, 5, 2) = (/ &
  & 0.141_JPRB, 0.141_JPRB, 0.141_JPRB, 0.141_JPRB, 0.272_JPRB, 0.317_JPRB, &
  & 0.360_JPRB, 0.415_JPRB, 0.500_JPRB, 0.571_JPRB, 0.697_JPRB, 1.033_JPRB /)

ALF_SS( :, 6, 2) = (/ &
  &  .143_JPRB,  .143_JPRB,  .143_JPRB,  .143_JPRB,  .274_JPRB,  .322_JPRB, &
  &  .365_JPRB,  .420_JPRB,  .505_JPRB,  .574_JPRB,  .699_JPRB, 1.033_JPRB /)
ALF_SS( :, 7, 2) = (/ &
  &  .144_JPRB,  .144_JPRB,  .144_JPRB,  .144_JPRB,  .279_JPRB,  .326_JPRB, &
  &  .370_JPRB,  .425_JPRB,  .510_JPRB,  .578_JPRB,  .701_JPRB, 1.032_JPRB /)

ALF_SS( :, 8, 2) = (/ &
  & 0.144_JPRB, 0.144_JPRB, 0.144_JPRB, 0.144_JPRB, 0.281_JPRB, 0.329_JPRB, &
  & 0.373_JPRB, 0.429_JPRB, 0.514_JPRB, 0.584_JPRB, 0.707_JPRB, 1.032_JPRB /)
ALF_SS( :, 9, 2) = (/ &
  & 0.146_JPRB, 0.146_JPRB, 0.146_JPRB, 0.146_JPRB, 0.290_JPRB, 0.337_JPRB, &
  & 0.384_JPRB, 0.443_JPRB, 0.530_JPRB, 0.602_JPRB, 0.724_JPRB, 1.041_JPRB /)

ALF_SS( :,10, 2) = (/ &
  &  .147_JPRB,  .147_JPRB,  .147_JPRB,  .147_JPRB,  .292_JPRB,  .340_JPRB, &
  &  .385_JPRB,  .446_JPRB,  .533_JPRB,  .606_JPRB,  .728_JPRB, 1.047_JPRB /)
ALF_SS( :,11, 2) = (/ &
  &  .146_JPRB,  .146_JPRB,  .146_JPRB,  .146_JPRB,  .299_JPRB,  .345_JPRB, &
  &  .395_JPRB,  .459_JPRB,  .551_JPRB,  .628_JPRB,  .758_JPRB, 1.078_JPRB /)
ALF_SS( :,12, 2) = (/ &
  & 0.147_JPRB, 0.147_JPRB, 0.147_JPRB, 0.147_JPRB, 0.300_JPRB, 0.348_JPRB, &
  & 0.397_JPRB, 0.459_JPRB, 0.559_JPRB, 0.634_JPRB, 0.768_JPRB, 1.095_JPRB /)

ALF_SS( :,13, 2) = (/ &
  &  .147_JPRB,  .147_JPRB,  .147_JPRB,  .147_JPRB,  .301_JPRB,  .348_JPRB, &
  &  .398_JPRB,  .459_JPRB,  .559_JPRB,  .635_JPRB,  .769_JPRB, 1.098_JPRB /)
ALF_SS( :,14, 2) = (/ &
  & 0.148_JPRB, 0.148_JPRB, 0.148_JPRB, 0.148_JPRB, 0.305_JPRB, 0.349_JPRB, &
  & 0.403_JPRB, 0.466_JPRB, 0.566_JPRB, 0.651_JPRB, 0.802_JPRB, 1.167_JPRB /)
ALF_SS( :,15, 2) = (/ &
  & 0.146_JPRB, 0.146_JPRB, 0.146_JPRB, 0.146_JPRB, 0.302_JPRB, 0.351_JPRB, &
  & 0.399_JPRB, 0.461_JPRB, 0.563_JPRB, 0.651_JPRB, 0.805_JPRB, 1.183_JPRB /)
ALF_SS( :,16, 2) = (/ &
  & 0.155_JPRB, 0.155_JPRB, 0.155_JPRB, 0.155_JPRB, 0.305_JPRB, 0.348_JPRB, &
  & 0.402_JPRB, 0.472_JPRB, 0.576_JPRB, 0.657_JPRB, 0.793_JPRB, 1.187_JPRB /)

! assymetry factor
ASY_SS( :, 1, 2) = (/ &
  &  .741_JPRB,  .741_JPRB,  .741_JPRB,  .741_JPRB,  .755_JPRB,  .778_JPRB, &
  &  .782_JPRB,  .789_JPRB,  .796_JPRB,  .801_JPRB,  .809_JPRB,  .819_JPRB /)
ASY_SS( :, 2, 2) = (/ &
  &  .741_JPRB,  .741_JPRB,  .741_JPRB,  .741_JPRB,  .755_JPRB,  .778_JPRB, &
  &  .782_JPRB,  .789_JPRB,  .796_JPRB,  .801_JPRB,  .809_JPRB,  .819_JPRB /)
ASY_SS( :, 3, 2) = (/ &
  &  .741_JPRB,  .741_JPRB,  .741_JPRB,  .741_JPRB,  .755_JPRB,  .778_JPRB, &
  &  .782_JPRB,  .789_JPRB,  .796_JPRB,  .801_JPRB,  .809_JPRB,  .819_JPRB /)
ASY_SS( :, 4, 2) = (/ &
  &  .739_JPRB,  .739_JPRB,  .739_JPRB,  .739_JPRB,  .750_JPRB,  .776_JPRB, &
  &  .779_JPRB,  .784_JPRB,  .792_JPRB,  .795_JPRB,  .802_JPRB,  .816_JPRB /)
ASY_SS( :, 5, 2) = (/ &
  & 0.737_JPRB, 0.737_JPRB, 0.737_JPRB, 0.737_JPRB, 0.747_JPRB, 0.773_JPRB, &
  & 0.778_JPRB, 0.782_JPRB, 0.788_JPRB, 0.791_JPRB, 0.798_JPRB, 0.812_JPRB /)

ASY_SS( :, 6, 2) = (/ &
  &  .734_JPRB,  .734_JPRB,  .734_JPRB,  .734_JPRB,  .745_JPRB,  .772_JPRB, &
  &  .775_JPRB,  .780_JPRB,  .785_JPRB,  .789_JPRB,  .795_JPRB,  .807_JPRB /)
ASY_SS( :, 7, 2) = (/ &
  &  .732_JPRB,  .732_JPRB,  .732_JPRB,  .732_JPRB,  .744_JPRB,  .770_JPRB, &
  &  .775_JPRB,  .778_JPRB,  .784_JPRB,  .787_JPRB,  .793_JPRB,  .804_JPRB /)

ASY_SS( :, 8, 2) = (/ &
  & 0.730_JPRB, 0.730_JPRB, 0.730_JPRB, 0.730_JPRB, 0.742_JPRB, 0.770_JPRB, &
  & 0.773_JPRB, 0.779_JPRB, 0.782_JPRB, 0.785_JPRB, 0.790_JPRB, 0.802_JPRB /)
ASY_SS( :, 9, 2) = (/ &
  & 0.723_JPRB, 0.723_JPRB, 0.723_JPRB, 0.723_JPRB, 0.739_JPRB, 0.766_JPRB, &
  & 0.771_JPRB, 0.776_JPRB, 0.780_JPRB, 0.783_JPRB, 0.786_JPRB, 0.794_JPRB /)

ASY_SS( :,10, 2) = (/ &
  &  .720_JPRB,  .720_JPRB,  .720_JPRB,  .720_JPRB,  .737_JPRB,  .765_JPRB, &
  &  .770_JPRB,  .774_JPRB,  .780_JPRB,  .782_JPRB,  .785_JPRB,  .793_JPRB /)
ASY_SS( :,11, 2) = (/ &
  &  .705_JPRB,  .705_JPRB,  .705_JPRB,  .705_JPRB,  .730_JPRB,  .758_JPRB, &
  &  .763_JPRB,  .770_JPRB,  .775_JPRB,  .777_JPRB,  .781_JPRB,  .787_JPRB /)
ASY_SS( :,12, 2) = (/ &
  & 0.701_JPRB, 0.701_JPRB, 0.701_JPRB, 0.701_JPRB, 0.727_JPRB, 0.757_JPRB, &
  & 0.760_JPRB, 0.767_JPRB, 0.773_JPRB, 0.776_JPRB, 0.780_JPRB, 0.788_JPRB /)

ASY_SS( :,13, 2) = (/ &
  &  .701_JPRB,  .701_JPRB,  .701_JPRB,  .701_JPRB,  .726_JPRB,  .756_JPRB, &
  &  .760_JPRB,  .766_JPRB,  .773_JPRB,  .776_JPRB,  .780_JPRB,  .787_JPRB /)
ASY_SS( :,14, 2) = (/ &
  & 0.671_JPRB, 0.671_JPRB, 0.671_JPRB, 0.671_JPRB, 0.701_JPRB, 0.731_JPRB, &
  & 0.738_JPRB, 0.747_JPRB, 0.753_JPRB, 0.759_JPRB, 0.767_JPRB, 0.779_JPRB /)
ASY_SS( :,15, 2) = (/ &
  & 0.642_JPRB, 0.642_JPRB, 0.642_JPRB, 0.642_JPRB, 0.675_JPRB, 0.711_JPRB, &
  & 0.716_JPRB, 0.723_JPRB, 0.733_JPRB, 0.742_JPRB, 0.751_JPRB, 0.764_JPRB /)
ASY_SS( :,16, 2) = (/ &
  & 0.662_JPRB, 0.662_JPRB, 0.662_JPRB, 0.662_JPRB, 0.653_JPRB, 0.690_JPRB, &
  & 0.699_JPRB, 0.709_JPRB, 0.720_JPRB, 0.724_JPRB, 0.730_JPRB, 0.748_JPRB /)

! single scattering albedo
OMG_SS( :, 1, 2) = (/ &
  &  .990_JPRB,  .990_JPRB,  .990_JPRB,  .990_JPRB,  .986_JPRB,  .994_JPRB, &
  &  .995_JPRB,  .996_JPRB,  .997_JPRB,  .997_JPRB,  .998_JPRB,  .999_JPRB /)
OMG_SS( :, 2, 2) = (/ &
  &  .990_JPRB,  .990_JPRB,  .990_JPRB,  .990_JPRB,  .986_JPRB,  .994_JPRB, &
  &  .995_JPRB,  .996_JPRB,  .997_JPRB,  .997_JPRB,  .998_JPRB,  .999_JPRB /)
OMG_SS( :, 3, 2) = (/ &
  &  .990_JPRB,  .990_JPRB,  .990_JPRB,  .990_JPRB,  .986_JPRB,  .994_JPRB, &
  &  .995_JPRB,  .996_JPRB,  .997_JPRB,  .997_JPRB,  .998_JPRB,  .999_JPRB /)
OMG_SS( :, 4, 2) = (/ &
  &  .991_JPRB,  .991_JPRB,  .991_JPRB,  .991_JPRB,  .987_JPRB,  .995_JPRB, &
  &  .995_JPRB,  .996_JPRB,  .997_JPRB,  .997_JPRB,  .998_JPRB,  .999_JPRB /)
OMG_SS( :, 5, 2) = (/ &
  & 0.992_JPRB, 0.992_JPRB, 0.992_JPRB, 0.992_JPRB, 0.988_JPRB, 0.995_JPRB, &
  & 0.996_JPRB, 0.996_JPRB, 0.997_JPRB, 0.997_JPRB, 0.998_JPRB, 0.999_JPRB /)

OMG_SS( :, 6, 2) = (/ &
  &  .992_JPRB,  .992_JPRB,  .992_JPRB,  .992_JPRB,  .989_JPRB,  .996_JPRB, &
  &  .996_JPRB,  .997_JPRB,  .997_JPRB,  .997_JPRB,  .998_JPRB,  .999_JPRB /)
OMG_SS( :, 7, 2) = (/ &
  &  .993_JPRB,  .993_JPRB,  .993_JPRB,  .993_JPRB,  .989_JPRB,  .996_JPRB, &
  &  .996_JPRB,  .997_JPRB,  .997_JPRB,  .998_JPRB,  .998_JPRB,  .999_JPRB /)

OMG_SS( :, 8, 2) = (/ &
  & 0.993_JPRB, 0.993_JPRB, 0.993_JPRB, 0.993_JPRB, 0.990_JPRB, 0.996_JPRB, &
  & 0.996_JPRB, 0.997_JPRB, 0.998_JPRB, 0.998_JPRB, 0.998_JPRB, 0.999_JPRB /)
OMG_SS( :, 9, 2) = (/ &
  & 0.994_JPRB, 0.994_JPRB, 0.994_JPRB, 0.994_JPRB, 0.991_JPRB, 0.997_JPRB, &
  & 0.997_JPRB, 0.998_JPRB, 0.998_JPRB, 0.998_JPRB, 0.998_JPRB, 0.999_JPRB /)

OMG_SS( :,10, 2) = (/ &
  &  .994_JPRB,  .994_JPRB,  .994_JPRB,  .994_JPRB,  .992_JPRB,  .997_JPRB, &
  &  .997_JPRB,  .997_JPRB,  .998_JPRB,  .998_JPRB,  .999_JPRB,  .999_JPRB /)
OMG_SS( :,11, 2) = (/ &
  &  .995_JPRB,  .995_JPRB,  .995_JPRB,  .995_JPRB,  .993_JPRB,  .997_JPRB, &
  &  .998_JPRB,  .998_JPRB,  .998_JPRB,  .998_JPRB,  .999_JPRB,  .999_JPRB /)
OMG_SS( :,12, 2) = (/ &
  & 0.995_JPRB, 0.995_JPRB, 0.995_JPRB, 0.995_JPRB, 0.993_JPRB, 0.998_JPRB, &
  & 0.998_JPRB, 0.998_JPRB, 0.998_JPRB, 0.999_JPRB, 0.999_JPRB, 0.999_JPRB /)

OMG_SS( :,13, 2) = (/ &
  &  .995_JPRB,  .995_JPRB,  .995_JPRB,  .995_JPRB,  .993_JPRB,  .998_JPRB, &
  &  .998_JPRB,  .998_JPRB,  .998_JPRB,  .999_JPRB,  .999_JPRB,  .999_JPRB /)
OMG_SS( :,14, 2) = (/ &
  & 0.997_JPRB, 0.997_JPRB, 0.997_JPRB, 0.997_JPRB, 0.995_JPRB, 0.998_JPRB, &
  & 0.998_JPRB, 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 0.999_JPRB /)
OMG_SS( :,15, 2) = (/ &
  & 0.997_JPRB, 0.997_JPRB, 0.997_JPRB, 0.997_JPRB, 0.996_JPRB, 0.999_JPRB, &
  & 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 1.000_JPRB /)
OMG_SS( :,16, 2) = (/ &
  & 0.998_JPRB, 0.998_JPRB, 0.998_JPRB, 0.998_JPRB, 0.997_JPRB, 0.999_JPRB, &
  & 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 0.999_JPRB, 1.000_JPRB, 1.000_JPRB /)

! BIN No. 3
ALF_SS( :, 1, 3) = (/ &
  &  .038_JPRB,  .038_JPRB,  .038_JPRB,  .038_JPRB,  .078_JPRB,  .091_JPRB, &
  &  .105_JPRB,  .122_JPRB,  .148_JPRB,  .170_JPRB,  .208_JPRB,  .308_JPRB /)
ALF_SS( :, 2, 3) = (/ &
  &  .038_JPRB,  .038_JPRB,  .038_JPRB,  .038_JPRB,  .078_JPRB,  .091_JPRB, &
  &  .105_JPRB,  .122_JPRB,  .148_JPRB,  .170_JPRB,  .208_JPRB,  .308_JPRB /)
ALF_SS( :, 3, 3) = (/ &
  &  .038_JPRB,  .038_JPRB,  .038_JPRB,  .038_JPRB,  .078_JPRB,  .091_JPRB, &
  &  .105_JPRB,  .122_JPRB,  .148_JPRB,  .170_JPRB,  .208_JPRB,  .308_JPRB /)
ALF_SS( :, 4, 3) = (/ &
  &  .038_JPRB,  .038_JPRB,  .038_JPRB,  .038_JPRB,  .079_JPRB,  .091_JPRB, &
  &  .105_JPRB,  .122_JPRB,  .149_JPRB,  .171_JPRB,  .209_JPRB,  .308_JPRB /)
ALF_SS( :, 5, 3) = (/ &
  & 0.039_JPRB, 0.039_JPRB, 0.039_JPRB, 0.039_JPRB, 0.079_JPRB, 0.092_JPRB, &
  & 0.105_JPRB, 0.122_JPRB, 0.149_JPRB, 0.171_JPRB, 0.210_JPRB, 0.309_JPRB /)

ALF_SS( :, 6, 3) = (/ &
  &  .039_JPRB,  .039_JPRB,  .039_JPRB,  .039_JPRB,  .079_JPRB,  .092_JPRB, &
  &  .105_JPRB,  .123_JPRB,  .149_JPRB,  .171_JPRB,  .209_JPRB,  .309_JPRB /)
ALF_SS( :, 7, 3) = (/ &
  &  .039_JPRB,  .039_JPRB,  .039_JPRB,  .039_JPRB,  .079_JPRB,  .092_JPRB, &
  &  .105_JPRB,  .123_JPRB,  .149_JPRB,  .172_JPRB,  .210_JPRB,  .310_JPRB /)

ALF_SS( :, 8, 3) = (/ &
  & 0.039_JPRB, 0.039_JPRB, 0.039_JPRB, 0.039_JPRB, 0.079_JPRB, 0.092_JPRB, &
  & 0.106_JPRB, 0.123_JPRB, 0.150_JPRB, 0.172_JPRB, 0.210_JPRB, 0.310_JPRB /)
ALF_SS( :, 9, 3) = (/ &
  & 0.039_JPRB, 0.039_JPRB, 0.039_JPRB, 0.039_JPRB, 0.080_JPRB, 0.093_JPRB, &
  & 0.106_JPRB, 0.123_JPRB, 0.151_JPRB, 0.172_JPRB, 0.211_JPRB, 0.311_JPRB /)

ALF_SS( :,10, 3) = (/ &
  &  .039_JPRB,  .039_JPRB,  .039_JPRB,  .039_JPRB,  .080_JPRB,  .093_JPRB, &
  &  .107_JPRB,  .124_JPRB,  .151_JPRB,  .173_JPRB,  .212_JPRB,  .311_JPRB /)
ALF_SS( :,11, 3) = (/ &
  &  .040_JPRB,  .040_JPRB,  .040_JPRB,  .040_JPRB,  .081_JPRB,  .094_JPRB, &
  &  .108_JPRB,  .124_JPRB,  .152_JPRB,  .174_JPRB,  .212_JPRB,  .314_JPRB /)
ALF_SS( :,12, 3) = (/ &
  & 0.040_JPRB, 0.040_JPRB, 0.040_JPRB, 0.040_JPRB, 0.081_JPRB, 0.094_JPRB, &
  & 0.108_JPRB, 0.126_JPRB, 0.152_JPRB, 0.174_JPRB, 0.213_JPRB, 0.314_JPRB /)

ALF_SS( :,13, 3) = (/ &
  &  .040_JPRB,  .040_JPRB,  .040_JPRB,  .040_JPRB,  .081_JPRB,  .094_JPRB, &
  &  .108_JPRB,  .126_JPRB,  .152_JPRB,  .174_JPRB,  .213_JPRB,  .314_JPRB /)
ALF_SS( :,14, 3) = (/ &
  & 0.040_JPRB, 0.040_JPRB, 0.040_JPRB, 0.040_JPRB, 0.082_JPRB, 0.096_JPRB, &
  & 0.109_JPRB, 0.127_JPRB, 0.156_JPRB, 0.178_JPRB, 0.215_JPRB, 0.318_JPRB /)
ALF_SS( :,15, 3) = (/ &
  & 0.043_JPRB, 0.043_JPRB, 0.043_JPRB, 0.043_JPRB, 0.084_JPRB, 0.097_JPRB, &
  & 0.112_JPRB, 0.131_JPRB, 0.159_JPRB, 0.180_JPRB, 0.218_JPRB, 0.324_JPRB /)
ALF_SS( :,16, 3) = (/ &
  & 0.042_JPRB, 0.042_JPRB, 0.042_JPRB, 0.042_JPRB, 0.086_JPRB, 0.102_JPRB, &
  & 0.115_JPRB, 0.131_JPRB, 0.157_JPRB, 0.181_JPRB, 0.225_JPRB, 0.326_JPRB /)

! assymetry factor
ASY_SS( :, 1, 3) = (/ &
  &  .803_JPRB,  .803_JPRB,  .803_JPRB,  .803_JPRB,  .810_JPRB,  .828_JPRB, &
  &  .831_JPRB,  .834_JPRB,  .837_JPRB,  .839_JPRB,  .842_JPRB,  .845_JPRB /)
ASY_SS( :, 2, 3) = (/ &
  &  .803_JPRB,  .803_JPRB,  .803_JPRB,  .803_JPRB,  .810_JPRB,  .828_JPRB, &
  &  .831_JPRB,  .834_JPRB,  .837_JPRB,  .839_JPRB,  .842_JPRB,  .845_JPRB /)
ASY_SS( :, 3, 3) = (/ &
  &  .803_JPRB,  .803_JPRB,  .803_JPRB,  .803_JPRB,  .810_JPRB,  .828_JPRB, &
  &  .831_JPRB,  .834_JPRB,  .837_JPRB,  .839_JPRB,  .842_JPRB,  .845_JPRB /)
ASY_SS( :, 4, 3) = (/ &
  &  .800_JPRB,  .800_JPRB,  .800_JPRB,  .800_JPRB,  .808_JPRB,  .827_JPRB, &
  &  .830_JPRB,  .832_JPRB,  .836_JPRB,  .838_JPRB,  .840_JPRB,  .844_JPRB /)
ASY_SS( :, 5, 3) = (/ &
  & 0.799_JPRB, 0.799_JPRB, 0.799_JPRB, 0.799_JPRB, 0.807_JPRB, 0.826_JPRB, &
  & 0.829_JPRB, 0.832_JPRB, 0.834_JPRB, 0.837_JPRB, 0.840_JPRB, 0.845_JPRB /)
ASY_SS( :, 6, 3) = (/ &
  &  .796_JPRB,  .796_JPRB,  .796_JPRB,  .796_JPRB,  .806_JPRB,  .824_JPRB, &
  &  .828_JPRB,  .830_JPRB,  .834_JPRB,  .836_JPRB,  .839_JPRB,  .843_JPRB /)
ASY_SS( :, 7, 3) = (/ &
  &  .795_JPRB,  .795_JPRB,  .795_JPRB,  .795_JPRB,  .804_JPRB,  .823_JPRB, &
  &  .826_JPRB,  .829_JPRB,  .833_JPRB,  .835_JPRB,  .837_JPRB,  .842_JPRB /)

ASY_SS( :, 8, 3) = (/ &
  & 0.794_JPRB, 0.794_JPRB, 0.794_JPRB, 0.794_JPRB, 0.803_JPRB, 0.822_JPRB, &
  & 0.826_JPRB, 0.829_JPRB, 0.832_JPRB, 0.834_JPRB, 0.837_JPRB, 0.841_JPRB /)
ASY_SS( :, 9, 3) = (/ &
  & 0.788_JPRB, 0.788_JPRB, 0.788_JPRB, 0.788_JPRB, 0.800_JPRB, 0.819_JPRB, &
  & 0.823_JPRB, 0.825_JPRB, 0.829_JPRB, 0.832_JPRB, 0.835_JPRB, 0.840_JPRB /)

ASY_SS( :,10, 3) = (/ &
  &  .786_JPRB,  .786_JPRB,  .786_JPRB,  .786_JPRB,  .800_JPRB,  .818_JPRB, &
  &  .822_JPRB,  .824_JPRB,  .829_JPRB,  .831_JPRB,  .834_JPRB,  .838_JPRB /)
ASY_SS( :,11, 3) = (/ &
  &  .779_JPRB,  .779_JPRB,  .779_JPRB,  .779_JPRB,  .794_JPRB,  .813_JPRB, &
  &  .817_JPRB,  .820_JPRB,  .824_JPRB,  .827_JPRB,  .830_JPRB,  .836_JPRB /)
ASY_SS( :,12, 3) = (/ &
  & 0.774_JPRB, 0.774_JPRB, 0.774_JPRB, 0.774_JPRB, 0.791_JPRB, 0.810_JPRB, &
  & 0.815_JPRB, 0.819_JPRB, 0.822_JPRB, 0.826_JPRB, 0.829_JPRB, 0.833_JPRB /)

ASY_SS( :,13, 3) = (/ &
  &  .774_JPRB,  .774_JPRB,  .774_JPRB,  .774_JPRB,  .791_JPRB,  .809_JPRB, &
  &  .814_JPRB,  .819_JPRB,  .821_JPRB,  .825_JPRB,  .829_JPRB,  .834_JPRB /)
ASY_SS( :,14, 3) = (/ &
  & 0.754_JPRB, 0.754_JPRB, 0.754_JPRB, 0.754_JPRB, 0.774_JPRB, 0.795_JPRB, &
  & 0.799_JPRB, 0.805_JPRB, 0.813_JPRB, 0.816_JPRB, 0.819_JPRB, 0.826_JPRB /)
ASY_SS( :,15, 3) = (/ &
  & 0.751_JPRB, 0.751_JPRB, 0.751_JPRB, 0.751_JPRB, 0.762_JPRB, 0.784_JPRB, &
  & 0.790_JPRB, 0.797_JPRB, 0.802_JPRB, 0.804_JPRB, 0.808_JPRB, 0.819_JPRB /)
ASY_SS( :,16, 3) = (/ &
  & 0.708_JPRB, 0.708_JPRB, 0.708_JPRB, 0.708_JPRB, 0.752_JPRB, 0.778_JPRB, &
  & 0.781_JPRB, 0.783_JPRB, 0.788_JPRB, 0.792_JPRB, 0.801_JPRB, 0.808_JPRB /)

! single scattering albedo
OMG_SS( :, 1, 3) = (/ &
  &  .980_JPRB,  .980_JPRB,  .980_JPRB,  .980_JPRB,  .982_JPRB,  .992_JPRB, &
  &  .993_JPRB,  .994_JPRB,  .996_JPRB,  .996_JPRB,  .997_JPRB,  .998_JPRB /)
OMG_SS( :, 2, 3) = (/ &
  &  .980_JPRB,  .980_JPRB,  .980_JPRB,  .980_JPRB,  .982_JPRB,  .992_JPRB, &
  &  .993_JPRB,  .994_JPRB,  .996_JPRB,  .996_JPRB,  .997_JPRB,  .998_JPRB /)
OMG_SS( :, 3, 3) = (/ &
  &  .980_JPRB,  .980_JPRB,  .980_JPRB,  .980_JPRB,  .982_JPRB,  .992_JPRB, &
  &  .993_JPRB,  .994_JPRB,  .996_JPRB,  .996_JPRB,  .997_JPRB,  .998_JPRB /)
OMG_SS( :, 4, 3) = (/ &
  &  .981_JPRB,  .981_JPRB,  .981_JPRB,  .981_JPRB,  .981_JPRB,  .991_JPRB, &
  &  .993_JPRB,  .994_JPRB,  .996_JPRB,  .996_JPRB,  .997_JPRB,  .998_JPRB /)
OMG_SS( :, 5, 3) = (/ &
  & 0.981_JPRB, 0.981_JPRB, 0.981_JPRB, 0.981_JPRB, 0.981_JPRB, 0.991_JPRB, &
  & 0.993_JPRB, 0.994_JPRB, 0.995_JPRB, 0.996_JPRB, 0.997_JPRB, 0.998_JPRB /)

OMG_SS( :, 6, 3) = (/ &
  &  .981_JPRB,  .981_JPRB,  .981_JPRB,  .981_JPRB,  .981_JPRB,  .991_JPRB, &
  &  .993_JPRB,  .994_JPRB,  .995_JPRB,  .996_JPRB,  .997_JPRB,  .998_JPRB /)
OMG_SS( :, 7, 3) = (/ &
  &  .982_JPRB,  .982_JPRB,  .982_JPRB,  .982_JPRB,  .990_JPRB,  .992_JPRB, &
  &  .993_JPRB,  .994_JPRB,  .995_JPRB,  .996_JPRB,  .997_JPRB,  .998_JPRB /)

OMG_SS( :, 8, 3) = (/ &
  & 0.982_JPRB, 0.982_JPRB, 0.982_JPRB, 0.982_JPRB, 0.990_JPRB, 0.992_JPRB, &
  & 0.993_JPRB, 0.994_JPRB, 0.995_JPRB, 0.996_JPRB, 0.997_JPRB, 0.998_JPRB /)
OMG_SS( :, 9, 3) = (/ &
  & 0.982_JPRB, 0.982_JPRB, 0.982_JPRB, 0.982_JPRB, 0.990_JPRB, 0.992_JPRB, &
  & 0.993_JPRB, 0.994_JPRB, 0.995_JPRB, 0.996_JPRB, 0.997_JPRB, 0.998_JPRB /)

OMG_SS( :,10, 3) = (/ &
  &  .983_JPRB,  .983_JPRB,  .983_JPRB,  .983_JPRB,  .987_JPRB,  .992_JPRB, &
  &  .993_JPRB,  .994_JPRB,  .996_JPRB,  .996_JPRB,  .997_JPRB,  .998_JPRB /)
OMG_SS( :,11, 3) = (/ &
  &  .985_JPRB,  .985_JPRB,  .985_JPRB,  .985_JPRB,  .990_JPRB,  .993_JPRB, &
  &  .994_JPRB,  .995_JPRB,  .996_JPRB,  .996_JPRB,  .997_JPRB,  .998_JPRB /)
OMG_SS( :,12, 3) = (/ &
  & 0.985_JPRB, 0.985_JPRB, 0.985_JPRB, 0.985_JPRB, 0.990_JPRB, 0.993_JPRB, &
  & 0.994_JPRB, 0.995_JPRB, 0.996_JPRB, 0.997_JPRB, 0.997_JPRB, 0.998_JPRB /)

OMG_SS( :,13, 3) = (/ &
  &  .986_JPRB,  .986_JPRB,  .986_JPRB,  .986_JPRB,  .990_JPRB,  .993_JPRB, &
  &  .994_JPRB,  .995_JPRB,  .996_JPRB,  .996_JPRB,  .997_JPRB,  .998_JPRB /)
OMG_SS( :,14, 3) = (/ &
  & 0.989_JPRB, 0.989_JPRB, 0.989_JPRB, 0.989_JPRB, 0.991_JPRB, 0.994_JPRB, &
  & 0.995_JPRB, 0.996_JPRB, 0.997_JPRB, 0.997_JPRB, 0.998_JPRB, 0.999_JPRB /)
OMG_SS( :,15, 3) = (/ &
  & 0.992_JPRB, 0.992_JPRB, 0.992_JPRB, 0.992_JPRB, 0.994_JPRB, 0.996_JPRB, &
  & 0.996_JPRB, 0.997_JPRB, 0.997_JPRB, 0.998_JPRB, 0.998_JPRB, 0.999_JPRB /)
OMG_SS( :,16, 3) = (/ &
  & 0.993_JPRB, 0.993_JPRB, 0.993_JPRB, 0.993_JPRB, 0.995_JPRB, 0.997_JPRB, &
  & 0.997_JPRB, 0.997_JPRB, 0.998_JPRB, 0.998_JPRB, 0.998_JPRB, 0.999_JPRB /)

!     ----------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('SU_AEROP',1,ZHOOK_HANDLE)
END SUBROUTINE SU_AEROP
