MODULE YOMRDU15

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------
!*    ** *YOMRDU15* - CONTROL, PARAM. AND SECURITY IN RADIATION
!*                          FROZEN VERSION (CYCLE 15) OF YOERDU
!     ------------------------------------------------------------------

INTEGER(KIND=JPIM) :: NUAER15
INTEGER(KIND=JPIM) :: NTRAER15
INTEGER(KIND=JPIM) :: NIMP15
INTEGER(KIND=JPIM) :: NOUT15
REAL(KIND=JPRB) :: RCDAY15
REAL(KIND=JPRB) :: R10E15
REAL(KIND=JPRB) :: REELOG15
REAL(KIND=JPRB) :: REPSC15
REAL(KIND=JPRB) :: REPSCO15
REAL(KIND=JPRB) :: REPSCQ15
REAL(KIND=JPRB) :: REPSCT15
REAL(KIND=JPRB) :: REPSCW15
REAL(KIND=JPRB) :: REPSEC15
REAL(KIND=JPRB) :: DIFF15

!        * E.C.M.W.F. PHYSICS PACKAGE *

!        96-11: Ph. Dandin. Meteo-France
!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME        TYPE     PURPOSE
!  ----     :  ----   : ------------------------------------------------
! NUAER15   : INTEGER   # OF ABSORBER AMOUNTS        W OR W/O AEROSOLS
! NTRAER15  : INTEGER   # OF TRANSMISSION FUNCTIONS  W OR W/O AEROSOLS
! NIMP15    : INTEGER   INDEX FOR EXTRA PRINTS WITHIN RADIATION CODE
! NOUT15    : INTEGER   UNIT NUMBER FOR THE EXTRA PRINTS
! RCDAY15   : REAL
! CCO215    : REAL      CONVERSION COEFFICIENT FOR CO2 IN S.W. CODE
! CH2O15    : REAL      CONVERSION COEFFICIENT FOR H2O IN S.W. CODE
! R10E15    : REAL      DECIMAL/NATURAL LOG.FACTOR
! DIFF15    : REAL      DIFFUSIVITY FACTOR
!-SECURITY THRESHOLDS
! REELOG15  : REAL      SEC. EPSILON FOR ABS.AMOUNT IN LAPLACE TRANSFORM
! REPSC15   : REAL      SEC. EPSILON FOR CLOUD COVER
! REPSEC15  : REAL      SEC. EPSILON FOR CLOUD COVER (was in YOECLD)
! REPSCO15  : REAL      SEC. EPSILON FOR OZONE AMOUNT
! REPSCQ15  : REAL      SEC. EPSILON FOR WATER VAPOR
! REPSCT15  : REAL      SEC. EPSILON FOR SHORTWAVE OPTICAL THICKNESS
! REPSCW15  : REAL      SEC. EPSILON FOR CLOUD LIQUID WATER PATH
!     -----------------------------------------------------------------
!$OMP THREADPRIVATE(diff15,nimp15,nout15,ntraer15,nuaer15,r10e15,rcday15,reelog15)
!$OMP THREADPRIVATE(repsc15,repsco15,repscq15,repsct15,repscw15,repsec15)
END MODULE YOMRDU15
