SUBROUTINE  grad_p(klevel, pg,pgx,pgy )
  !
  !  P. Le Van
  !
  !    ******************************************************************
  ! .. calcul des composantes covariantes en x et y du gradient de g
  !
  !    ******************************************************************
  !         pg        est un   argument  d'entree pour le s-prog
  !   pgx  et  pgy    sont des arguments de sortie pour le s-prog
  !
  USE parallel_lmdz
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h
IMPLICIT NONE
  !


  INTEGER :: klevel
  REAL :: pg( ip1jmp1,klevel )
  REAL :: pgx( ip1jmp1,klevel ) , pgy( ip1jm,klevel )
  INTEGER :: l,ij
  INTEGER :: ijb,ije,jjb,jje
  !
  !
!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO l = 1,klevel
  !
  ijb=ij_begin
  ije=ij_end
  DO  ij = ijb, ije - 1
    pgx( ij,l ) = pg( ij +1,l ) - pg( ij,l )
  END DO
  !
  !    .... correction pour  pgx(ip1,j,l)  ....
  !    ...    pgx(iip1,j,l)= pgx(1,j,l)  ....
  !DIR$ IVDEP
  DO  ij = ijb+iip1-1, ije, iip1
    pgx( ij,l ) = pgx( ij -iim,l )
  END DO
  !
  ijb=ij_begin-iip1
  ije=ij_end
  if (pole_nord) ijb=ij_begin
  if (pole_sud)  ije=ij_end-iip1

  DO ij = ijb,ije
    pgy( ij,l ) = pg( ij,l ) - pg( ij +iip1,l )
  END DO
  !
  END DO
!$OMP END DO NOWAIT

  RETURN
END SUBROUTINE grad_p
