MODULE YOERAD

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------
!*    ** *YOERAD* - CONTROL OPTIONS FOR RADIATION CONFIGURATION
!     ------------------------------------------------------------------

INTEGER(KIND=JPIM) :: NAER
INTEGER(KIND=JPIM) :: NMODE
INTEGER(KIND=JPIM) :: NOZOCL
INTEGER(KIND=JPIM) :: NRADFR
INTEGER(KIND=JPIM) :: NRADPFR
INTEGER(KIND=JPIM) :: NRADPLA
INTEGER(KIND=JPIM) :: NRINT
INTEGER(KIND=JPIM) :: NRADINT
INTEGER(KIND=JPIM) :: NRADRES
INTEGER(KIND=JPIM) :: NRADNFR
INTEGER(KIND=JPIM) :: NRADSFR
INTEGER(KIND=JPIM) :: NOVLP
INTEGER(KIND=JPIM) :: NRPROMA
INTEGER(KIND=JPIM) :: NLW
!INTEGER(KIND=JPIM) :: NSW  mis dans .def MPL 20140211
INTEGER(KIND=JPIM) :: NSWNL
INTEGER(KIND=JPIM) :: NSWTL
INTEGER(KIND=JPIM) :: NTSW
INTEGER(KIND=JPIM) :: NUV
INTEGER(KIND=JPIM) :: NCSRADF
INTEGER(KIND=JPIM) :: NICEOPT
INTEGER(KIND=JPIM) :: NLIQOPT
INTEGER(KIND=JPIM) :: NRADIP
INTEGER(KIND=JPIM) :: NRADLP
INTEGER(KIND=JPIM) :: NINHOM
INTEGER(KIND=JPIM) :: NLAYINH
INTEGER(KIND=JPIM) :: NLNGR1H
INTEGER(KIND=JPIM) :: NPERTAER
INTEGER(KIND=JPIM) :: NPERTOZ
INTEGER(KIND=JPIM) :: NSCEN
INTEGER(KIND=JPIM) :: NHINCSOL
INTEGER(KIND=JPIM) :: NMCICA

LOGICAL :: LERAD1H
LOGICAL :: LERADHS
LOGICAL :: LEPO3RA
LOGICAL :: LRADLB
LOGICAL :: LONEWSW
LOGICAL :: LECSRAD
LOGICAL :: LRRTM
LOGICAL :: LSRTM
LOGICAL :: LDIFFC
LOGICAL :: LHVOLCA
LOGICAL :: LNEWAER
LOGICAL :: LNOTROAER
LOGICAL :: LRAYL
LOGICAL :: LOPTRPROMA
LOGICAL :: LECO2VAR
LOGICAL :: LHGHG

CHARACTER (LEN = 256) ::  CRTABLEDIR
CHARACTER (LEN = 32) ::   CRTABLEFIL
LOGICAL :: LCCNL
LOGICAL :: LCCNO

REAL(KIND=JPRB) :: RAOVLP , RBOVLP
REAL(KIND=JPRB) :: RCCNLND, RCCNSEA
LOGICAL :: LEDBUG
REAL(KIND=JPRB) :: RPERTOZ, RRe2De
REAL(KIND=JPRB) :: RLWINHF, RSWINHF

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
! LERAD1H: LOGICAL : .T. TO ALLOW MORE FREQUENT RADIATION CALCULATIONS
!                  : DURING FIRST N HOURS OF FORECAST
! NLNGR1H: INTEGER : NUMBER FORECAST HOURS DURING WHICH MORE FREQUENT
!                    RADIATION CALCULATIONS ARE REQUIRED
! LERADHS: LOGICAL : .T. IF RAD.COMPUTED ON A COARSER SAMPLED GRID
! LEPO3RA: LOGICAL : .T. IF PROGNOSTIC OZONE (EC) IS PASSED TO RADIATION
! NAER   : INTEGER : CONFIGURATION INDEX FOR AEROSOLS
! NMODE  : INTEGER : CONFIGURATION FOR RADIATION CODE: FLUX VS. RADIANCE
! NOZOCL : INTEGER : CHOICE OF OZONE CLIMATOLOGY (0 old, 1 new)
! NRADFR : INTEGER : FREQUENCY OF FULL RADIATION COMPUTATIONS
!                    IF(NRADFR.GT.0): RAD EVERY 'NRADFR' TIME-STEPS
!                    IF(NRADFR.LT.0): RAD EVERY '-NRADFR' HOURS
! NRADPFR: INTEGER : PRINT FREQUENCY FOR RAD.STATISTICS (in RAD.T.STEPS)
! NRADPLA: INTEGER : PRINT RAD.STATISTICS EVERY 'NRADPLA' ROWS
! NRINT  : INTEGER : INTERPOLATION DISTANCE (in points)
! NRADINT: INTEGER : RADIATION INTERPOLATION METHOD
!                  : 0 = CURRENT RADIATION INTERPOLATION (CONTROLLED BY NRINT)
!                  : 1 = SPECTRAL TRANSFORM INTERPOLATION
!                  : 2 =  4 POINT HORIZONTAL INTERPOLATION
!                  : 3 = 12 POINT HORIZONTAL INTERPOLATION
! NRADRES: INTEGER : RADIATION GRID SPECTRAL RESOLUTION
! NRADNFR: INTEGER : NORMAL   FREQUENCY OF RADIATION STEPS
! NRADSFR: INTEGER : START-UP FREQUENCY OF RADIATION STEPS
! NOVLP  : INTEGER : CLOUD OVERLAP CONFIGURATION
! NRPROMA: INTEGER : VECTOR LENGTH FOR RADIATION CALCULATIONS
! NLW    : INTEGER : NUMBER OF LONGWAVE SPECTRAL INTERVALS    
! NSW    : INTEGER : NUMBER OF SHORTWAVE SPECTRAL INTERVALS
! NSWNL  : INTEGER : NUMBER OF SHORTWAVE SPECTRAL INTERVALS IN NL MODEL
! NSWTL  : INTEGER : NUMBER OF SHORTWAVE SPECTRAL INTERVALS IN TL MODEL
! NTSW   : INTEGER : MAXIMUM POSSIBLE NUMBER OF SW SPECTRAL INTERVALS 
! NUV    : INTEGER : NUMBER OF UV SPECTRAL INTERVALS FOR THE UV PROCESSOR   
! LRADLB : LOGICAL : .T. IF RADIATION COURSER GRID IS TO BE LOAD BALANCED
!                  : OVER PROCESSORS (I.E. WHEN NRINT>1)
! LOPTRPROMA:LOGICAL: .T. NRPROMA will be optimised
!                   : .F. NRPROMA will not be optimised (forced
!                   :         by negative NRPROMA in namelist)

! NRADIP : INTEGER : INDEX FOR DIAGNOSIS OF ICE CLOUD EFFECTIVE RADIUS
!          0=EbCu/SmSh  1=EbCu/EbCu  2=FuLi/FuLi  3=Fu/Fu&al
! NRADLP : INTEGER : INDEX FOR DIAGNOSIS OF LIQ. CLOUD EFFECTIVE RADIUS
!          0=YF/SmSh    1=ASl/HSa    2=ASl/LiLi
! NICEOPT: INTEGER : INDEX FOR ICE CLOUD OPTICAL PROPERTIES
!          0=40u        1=40-130     2=30-60      3=Sun'01
! NLIQOPT: INTEGER : INDEX FOR LIQUID WATER CLOUD OPTICAL PROPERTIES
!          0=f(P)       1=10/13      2=Martin_et_al

! LONEWSW: LOGICAL : .T. IF NEW SW CODE IS ACTIVE
! LECSRAD: LOGICAL : .T. IF CLEAR-SKY RADIATION IS ARCHIVED AS PEXTR2
! NCSRADF: INTEGER : 1 IF ACCUMULATED, 2 IF INSTANTANEOUS
! LRRTM  : LOGICAL : .T. IF RRTM140MR IS USED FOR LW RADIATION TRANSFER

! LHVOLCA: LOGICAL : .T. IF GISS HISTORY OF VOLCANIC AEROSOLS IS ON
! LNEWAER: LOGICAL : .T. IF AEROSOL MONTHLY DISTRIBUTIONS ARE USED
! LNOTROAER:LOGICAL: .T. IF NO TROPOSPHERIC AEROSOLS
! CRTABLEDIR: CHAR : IF NRADINT > 0 SPECIFIES DIRECTORY PATH FOR RADIATION
!                  : GRID RTABLE NAMELIST
! CRTABLEFIL: CHAR : IF NRADINT > 0 SPECIFIES FILE NAME OF RADIATION 
!                  : GRID RTABLE NAMELIST
! LRAYL  : LOGICAL : .T. NEW RAYLEIGH FOR SW-6 VERSION

! RAOVLP : REAL    : COEFFICIENTS FOR ALPHA1 FACTOR IN HOGAN & 
! RBOVLP : REAL    : ILLINGWORTH's PARAMETRIZATION

! LCCNL  : LOGICAL : .T. IF CCN CONCENTRATION OVER LAND IS DIAGNOSED
! LCCNO  : LOGICAL : .T. IF CCN CONCENTRATION OVER OCEAN IS DIAGNOSED
! RCCNLND: REAL    : NUMBER CONCENTRATION (CM-3) OF CCNs OVER LAND
! RCCNSEA: REAL    : NUMBER CONCENTRATION (CM-3) OF CCNs OVER SEA

! LDIFFC : LOGICAL : .T. IF SAVIJARVI'S DIFFUSIVITY CORRECTION IS ON

! NINHOM : INTEGER : 0 IF NO INHOMOGENEITY SCALING EFFECT 
!                    1 IF SIMPLE 0.7 SCALING
!                    2 IF BARKER, 3 IF CAIRNS ET AL.
! RLWINHF: REAL    : INHOMOG. SCALING FACTOR FOR CLOUD LW OPTICAL THICKNESS
! RSWINHF: REAL    : INHOMOG. SCALING FACTOR FOR CLOUD SW OPTICAL THICKNESS

! NPERTAER : INTERGER : PERCENTAGE OF PERTURBATION FOR AEROSOL   
! NPERTOZONE : INTEGER : PERCENTAGE OF PERTURBATION FOR OZONE 
! NHINCSOL:INTEGER :
!        = 0 NO VARIABILITY OF SOLAR CONSTANT IS ACCOUNTED FOR 
!        = 1 IF YEAR-TO-YEAR VARIABILITY OF SOLAR CONSTANT IS ACCOUNTED FOR 
!        = 2 IF MONTH-TO-MONTH VARIABILITY OF SOLAR CONSTANT IS ACCOUNTED FOR 
! LECO2VAR: LOGICAL: .T. IF ERA-40/AMIP2 VARIABILITY OF GHG IS ON
! LHGHG  : LOGICAL : .T. IF VARIABILITY OF GREENHOUSE GASES (INCLUDING CO2) IS ON
! N.B.: LHGHG supercedes LECO2VAR and allows using better specification of trace gases
! NSCEN  : INTEGER : 21st CENTURY SCENARIO FOR GHG (1=A1B, 2=A2, 3=B1)
! RRe2De : REAL    : CONVERSION FACTOR BETWWEN EFFECTIVE RADIUS AND PARTICLE SIZE
!                    FOR ICE
! NMCICA : INTEGER :  0: NO McICA
!                     1: McICA w maximum-random in cloud generator
!                     2: McICA w generalized overlap in cloud generator
!     ------------------------------------------------------------------

!$OMP THREADPRIVATE(crtabledir,crtablefil,lccnl,lccno,ldiffc,leco2var,lecsrad)
!$OMP THREADPRIVATE(ledbug,lepo3ra,lerad1h,leradhs,lhghg,lhvolca,lnewaer,lnotroaer)
!$OMP THREADPRIVATE(lonewsw,loptrproma,lradlb,lrayl,lrrtm,lsrtm,naer,ncsradf,nhincsol)
!$OMP THREADPRIVATE(niceopt,ninhom,nlayinh,nliqopt,nlngr1h,nlw,nmcica,nmode,novlp,nozocl)
!$OMP THREADPRIVATE(npertaer,npertoz,nradfr,nradint,nradip,nradlp,nradnfr,nradpfr,nradpla)
!$OMP THREADPRIVATE(nradres,nradsfr,nrint,nrproma,nscen,nswnl,nswtl,ntsw,nuv,raovlp)
!$OMP THREADPRIVATE(rbovlp,rccnlnd,rccnsea,rlwinhf,rpertoz,rre2de,rswinhf)

END MODULE YOERAD
