!***************************************************************************
SUBROUTINE RRTM_CMBGB9
!***************************************************************************

!     BAND 9:  1180-1390 cm-1 (low - H2O,CH4; high - CH4)
!***************************************************************************

! Parameters
USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOERRTO9 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
 & FRACREFBO, ABSN2OO  
USE YOERRTA9 , ONLY : KA      ,KB      ,SELFREF    ,FRACREFA  ,&
 & FRACREFB , ABSN2O  
USE YOERRTRWT, ONLY : FREFA    ,FREFB    ,FREFADF  ,RWGT
USE YOERRTFTR, ONLY : NGC      ,NGS      ,NGN      

IMPLICIT NONE

INTEGER(KIND=JPIM) :: IGC, IPR, IPRSM, JN, JND, JNDC, JP, JT

REAL(KIND=JPRB) :: Z_SUMF, Z_SUMK
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('RRTM_CMBGB9',0,ZHOOK_HANDLE)
DO JN = 1,11
  DO JT = 1,5
    DO JP = 1,13
      IPRSM = 0
      DO IGC = 1,NGC(9)
        Z_SUMK = 0.0_JPRB
        DO IPR = 1, NGN(NGS(8)+IGC)
          IPRSM = IPRSM + 1

          Z_SUMK = Z_SUMK + KAO(JN,JT,JP,IPRSM)*RWGT(IPRSM+128)
        ENDDO

        KA(JN,JT,JP,IGC) = Z_SUMK
      ENDDO
    ENDDO
  ENDDO
ENDDO

DO JT = 1,5
  DO JP = 13,59
    IPRSM = 0
    DO IGC = 1,NGC(9)
      Z_SUMK = 0.0_JPRB
      DO IPR = 1, NGN(NGS(8)+IGC)
        IPRSM = IPRSM + 1

        Z_SUMK = Z_SUMK + KBO(JT,JP,IPRSM)*RWGT(IPRSM+128)
      ENDDO

      KB(JT,JP,IGC) = Z_SUMK
    ENDDO
  ENDDO
ENDDO

DO JT = 1,10
  IPRSM = 0
  DO IGC = 1,NGC(9)
    Z_SUMK = 0.0_JPRB
    DO IPR = 1, NGN(NGS(8)+IGC)
      IPRSM = IPRSM + 1

      Z_SUMK = Z_SUMK + SELFREFO(JT,IPRSM)*RWGT(IPRSM+128)
    ENDDO

    SELFREF(JT,IGC) = Z_SUMK
  ENDDO
ENDDO

DO JN = 1,3
  IPRSM = 0
  DO IGC = 1,NGC(9)
    Z_SUMK = 0.0_JPRB
    DO IPR = 1, NGN(NGS(8)+IGC)
      IPRSM = IPRSM + 1
      JND = (JN-1)*16

      Z_SUMK = Z_SUMK + ABSN2OO(JND+IPRSM)*RWGT(IPRSM+128)
    ENDDO
    JNDC = (JN-1)*NGC(9)

    ABSN2O(JNDC+IGC) = Z_SUMK
  ENDDO
ENDDO

DO JP = 1,9
  IPRSM = 0
  DO IGC = 1,NGC(9)
    Z_SUMF = 0.0_JPRB
    DO IPR = 1, NGN(NGS(8)+IGC)
      IPRSM = IPRSM + 1

      Z_SUMF = Z_SUMF + FRACREFAO(IPRSM,JP)
    ENDDO

    FRACREFA(IGC,JP) = Z_SUMF
  ENDDO
ENDDO

IPRSM = 0
DO IGC = 1,NGC(9)
  Z_SUMF = 0.0_JPRB
  DO IPR = 1, NGN(NGS(8)+IGC)
    IPRSM = IPRSM + 1

    Z_SUMF = Z_SUMF + FRACREFBO(IPRSM)
  ENDDO

  FRACREFB(IGC) = Z_SUMF
ENDDO

DO JP = 1,9
  DO IGC = 1,NGC(9)

    FREFA(NGS(8)+IGC,JP) = FRACREFA(IGC,JP)
  ENDDO
ENDDO
DO JP = 1,8
  DO IGC = 1,NGC(9)

    FREFADF(NGS(8)+IGC,JP) = FRACREFA(IGC,JP+1) -FRACREFA(IGC,JP)
  ENDDO
ENDDO
DO IGC = 1,NGC(9)

  FREFB(NGS(8)+IGC,1) = FRACREFB(IGC)
ENDDO

IF (LHOOK) CALL DR_HOOK('RRTM_CMBGB9',1,ZHOOK_HANDLE)
END SUBROUTINE RRTM_CMBGB9
