!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif 
!pgi$r opt=0
SUBROUTINE SRTM_KGB21

!     Originally by J.Delamere, Atmospheric & Environmental Research.
!     Revision: 2.4
!     BAND 21:  6150-7700 cm-1 (low - H2O,CO2; high - H2O,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOESRTA21, ONLY : KA, KB, SELFREF, FORREF, SFLUXREF, RAYL, STRRAT &
 & , LAYREFFR  

!     ------------------------------------------------------------------

IMPLICIT NONE

! KURUCZ
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2
CALL PART3
CALL PART4
CALL PART5
CALL PART6
CALL PART7
CALL PART8
CALL PART9
CALL PART10
CALL PART11
CALL PART12
CALL PART13
CALL PART14
CALL PART15
CALL PART16
CALL PART17
CALL PART18
CALL PART19
CALL PART20
CALL PART21
CALL PART22
CALL PART23
CALL PART24
CALL PART25
CALL PART26
CALL PART27
CALL PART28
CALL PART29
CALL PART30
CALL PART31
CALL PART32
CALL PART33
CALL PART34
CALL PART35
CALL PART36
CALL PART37
CALL PART38

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21',1,ZHOOK_HANDLE)

!     -----------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART1',0,ZHOOK_HANDLE)


SFLUXREF(:, 1) = (/ &
 & 16.1643_JPRB , 15.5806_JPRB, 14.7254_JPRB    , 13.5541_JPRB    , &
 & 11.9519_JPRB ,10.44410_JPRB, 8.37884_JPRB    , 6.26384_JPRB    , &
 & 4.28435_JPRB ,0.465228_JPRB, 0.385095_JPRB   ,0.304226_JPRB    , &
 & 0.222479_JPRB,0.143286_JPRB, 5.58046E-02_JPRB, 7.84856E-03_JPRB /)  
SFLUXREF(:, 2) = (/ &
 & 15.6451_JPRB , 15.3170_JPRB, 14.6987_JPRB    , 13.7350_JPRB    , &
 & 12.2267_JPRB ,10.51646_JPRB, 8.47150_JPRB    , 6.38873_JPRB    , &
 & 4.33536_JPRB ,0.470610_JPRB,0.389426_JPRB    ,0.306461_JPRB    , &
 & 0.223537_JPRB,0.143273_JPRB, 5.58179E-02_JPRB, 7.84856E-03_JPRB /)  
SFLUXREF(:, 3) = (/ &
 & 15.6092_JPRB , 15.3293_JPRB, 14.6881_JPRB    , 13.6693_JPRB    , &
 & 12.2342_JPRB ,10.52010_JPRB, 8.49442_JPRB    , 6.42138_JPRB    , &
 & 4.35865_JPRB ,0.473349_JPRB,0.391349_JPRB    ,0.308861_JPRB    , &
 & 0.224666_JPRB,0.144799_JPRB, 5.58176E-02_JPRB, 7.84881E-03_JPRB /)  
SFLUXREF(:, 4) = (/ &
 & 15.5786_JPRB , 15.3422_JPRB, 14.6894_JPRB    , 13.6040_JPRB    , &
 & 12.2567_JPRB ,10.49400_JPRB, 8.53521_JPRB    , 6.44427_JPRB    , &
 & 4.37208_JPRB ,0.475709_JPRB,0.392956_JPRB    ,0.309737_JPRB    , &
 & 0.226274_JPRB,0.146483_JPRB, 5.59325E-02_JPRB, 7.84881E-03_JPRB /)  
SFLUXREF(:, 5) = (/ &
 & 15.5380_JPRB , 15.3826_JPRB, 14.6575_JPRB    , 13.5722_JPRB    , &
 & 12.2646_JPRB ,10.47672_JPRB, 8.57158_JPRB    , 6.46343_JPRB    , &
 & 4.38259_JPRB ,0.477647_JPRB,0.393982_JPRB    ,0.310686_JPRB    , &
 & 0.227620_JPRB,0.148376_JPRB, 5.60398E-02_JPRB, 7.83925E-03_JPRB /)  
SFLUXREF(:, 6) = (/ &
 & 15.5124_JPRB , 15.3986_JPRB, 14.6240_JPRB    , 13.5535_JPRB    , &
 & 12.2468_JPRB ,10.48891_JPRB, 8.60434_JPRB    , 6.47985_JPRB    , &
 & 4.39448_JPRB ,0.478267_JPRB,0.395618_JPRB    ,0.311043_JPRB    , &
 & 0.230927_JPRB,0.148774_JPRB, 5.61189E-02_JPRB, 7.83925E-03_JPRB /)  
SFLUXREF(:, 7) = (/ &
 & 15.4910_JPRB , 15.4028_JPRB, 14.5772_JPRB    , 13.5507_JPRB    , &
 & 12.2122_JPRB ,10.52735_JPRB, 8.62650_JPRB    , 6.49644_JPRB    , &
 & 4.41173_JPRB ,0.478627_JPRB,0.396433_JPRB    ,0.314199_JPRB    ,  &
 & 0.233125_JPRB,0.149052_JPRB, 5.62309E-02_JPRB, 7.83925E-03_JPRB /)  
SFLUXREF(:, 8) = (/ &
 & 15.4562_JPRB , 15.3928_JPRB, 14.5510_JPRB    , 13.5122_JPRB    , &
 & 12.1890_JPRB , 10.5826_JPRB, 8.65842_JPRB    , 6.51558_JPRB    , &
 & 4.42747_JPRB ,0.480669_JPRB,0.400143_JPRB    ,0.318144_JPRB    , &
 & 0.233937_JPRB,0.149119_JPRB, 5.62309E-02_JPRB, 7.83925E-03_JPRB /)  
SFLUXREF(:, 9) = (/ &
 & 15.0069_JPRB , 15.1479_JPRB, 14.7802_JPRB    , 13.6085_JPRB    , &
 & 12.2793_JPRB , 10.6929_JPRB, 8.72723_JPRB    , 6.57114_JPRB    , &
 & 4.46330_JPRB ,0.486724_JPRB,0.401446_JPRB    ,0.318879_JPRB    , &
 & 0.233959_JPRB,0.149119_JPRB, 5.62309E-02_JPRB, 7.83925E-03_JPRB /)  

!     Rayleigh extinction coefficient at v = 6925 cm-1.
RAYL = 9.41E-09_JPRB

STRRAT = 0.0045321_JPRB

LAYREFFR = 8

!     ------------------------------------------------------------------

!     The array KA contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KA(:, 1, 1, 1) = (/ &
 & 0.31482E-07_JPRB,0.64010E-05_JPRB,0.95017E-05_JPRB,0.11735E-04_JPRB,0.13561E-04_JPRB, &
 & 0.15077E-04_JPRB,0.16121E-04_JPRB,0.16138E-04_JPRB,0.41687E-06_JPRB /)  
KA(:, 2, 1, 1) = (/ &
 & 0.29791E-07_JPRB,0.68206E-05_JPRB,0.10260E-04_JPRB,0.12764E-04_JPRB,0.14880E-04_JPRB, &
 & 0.16665E-04_JPRB,0.17944E-04_JPRB,0.18170E-04_JPRB,0.44246E-06_JPRB /)  
KA(:, 3, 1, 1) = (/ &
 & 0.28272E-07_JPRB,0.72448E-05_JPRB,0.11083E-04_JPRB,0.13866E-04_JPRB,0.16256E-04_JPRB, &
 & 0.18323E-04_JPRB,0.19886E-04_JPRB,0.20229E-04_JPRB,0.47472E-06_JPRB /)  
KA(:, 4, 1, 1) = (/ &
 & 0.26900E-07_JPRB,0.76935E-05_JPRB,0.11934E-04_JPRB,0.15015E-04_JPRB,0.17657E-04_JPRB, &
 & 0.20038E-04_JPRB,0.21902E-04_JPRB,0.22361E-04_JPRB,0.50770E-06_JPRB /)  
KA(:, 5, 1, 1) = (/ &
 & 0.25656E-07_JPRB,0.81661E-05_JPRB,0.12769E-04_JPRB,0.16181E-04_JPRB,0.19127E-04_JPRB, &
 & 0.21755E-04_JPRB,0.23963E-04_JPRB,0.24421E-04_JPRB,0.54205E-06_JPRB /)  
KA(:, 1, 2, 1) = (/ &
 & 0.26396E-07_JPRB,0.52225E-05_JPRB,0.77221E-05_JPRB,0.95150E-05_JPRB,0.11004E-04_JPRB, &
 & 0.12195E-04_JPRB,0.13037E-04_JPRB,0.12985E-04_JPRB,0.32097E-06_JPRB /)  
KA(:, 2, 2, 1) = (/ &
 & 0.24945E-07_JPRB,0.55737E-05_JPRB,0.83612E-05_JPRB,0.10375E-04_JPRB,0.12116E-04_JPRB, &
 & 0.13569E-04_JPRB,0.14561E-04_JPRB,0.14711E-04_JPRB,0.34579E-06_JPRB /)  
KA(:, 3, 2, 1) = (/ &
 & 0.23646E-07_JPRB,0.59333E-05_JPRB,0.90531E-05_JPRB,0.11301E-04_JPRB,0.13247E-04_JPRB, &
 & 0.14956E-04_JPRB,0.16193E-04_JPRB,0.16396E-04_JPRB,0.37200E-06_JPRB /)  
KA(:, 4, 2, 1) = (/ &
 & 0.22476E-07_JPRB,0.63144E-05_JPRB,0.97732E-05_JPRB,0.12274E-04_JPRB,0.14436E-04_JPRB, &
 & 0.16377E-04_JPRB,0.17879E-04_JPRB,0.18223E-04_JPRB,0.40051E-06_JPRB /)  
KA(:, 5, 2, 1) = (/ &
 & 0.21415E-07_JPRB,0.67133E-05_JPRB,0.10471E-04_JPRB,0.13264E-04_JPRB,0.15681E-04_JPRB, &
 & 0.17843E-04_JPRB,0.19627E-04_JPRB,0.19954E-04_JPRB,0.42929E-06_JPRB /)  
KA(:, 1, 3, 1) = (/ &
 & 0.22397E-07_JPRB,0.41930E-05_JPRB,0.61559E-05_JPRB,0.75544E-05_JPRB,0.86902E-05_JPRB, &
 & 0.95896E-05_JPRB,0.10269E-04_JPRB,0.10114E-04_JPRB,0.24148E-06_JPRB /)  
KA(:, 2, 3, 1) = (/ &
 & 0.21124E-07_JPRB,0.44837E-05_JPRB,0.66786E-05_JPRB,0.82475E-05_JPRB,0.96353E-05_JPRB, &
 & 0.10742E-04_JPRB,0.11469E-04_JPRB,0.11556E-04_JPRB,0.26304E-06_JPRB /)  
KA(:, 3, 3, 1) = (/ &
 & 0.19988E-07_JPRB,0.47839E-05_JPRB,0.72499E-05_JPRB,0.90229E-05_JPRB,0.10560E-04_JPRB, &
 & 0.11900E-04_JPRB,0.12859E-04_JPRB,0.12935E-04_JPRB,0.28618E-06_JPRB /)  
KA(:, 4, 3, 1) = (/ &
 & 0.18968E-07_JPRB,0.51040E-05_JPRB,0.78586E-05_JPRB,0.98308E-05_JPRB,0.11551E-04_JPRB, &
 & 0.13094E-04_JPRB,0.14240E-04_JPRB,0.14455E-04_JPRB,0.30983E-06_JPRB /)  
KA(:, 5, 3, 1) = (/ &
 & 0.18047E-07_JPRB,0.54366E-05_JPRB,0.84462E-05_JPRB,0.10670E-04_JPRB,0.12585E-04_JPRB, &
 & 0.14313E-04_JPRB,0.15695E-04_JPRB,0.15934E-04_JPRB,0.33255E-06_JPRB /)  
KA(:, 1, 4, 1) = (/ &
 & 0.19080E-07_JPRB,0.33409E-05_JPRB,0.48738E-05_JPRB,0.59354E-05_JPRB,0.67877E-05_JPRB, &
 & 0.74900E-05_JPRB,0.79142E-05_JPRB,0.77200E-05_JPRB,0.18466E-06_JPRB /)  
KA(:, 2, 4, 1) = (/ &
 & 0.17954E-07_JPRB,0.35910E-05_JPRB,0.52960E-05_JPRB,0.65037E-05_JPRB,0.75744E-05_JPRB, &
 & 0.84082E-05_JPRB,0.89422E-05_JPRB,0.89302E-05_JPRB,0.20292E-06_JPRB /)  
KA(:, 3, 4, 1) = (/ &
 & 0.16954E-07_JPRB,0.38317E-05_JPRB,0.57536E-05_JPRB,0.71322E-05_JPRB,0.83424E-05_JPRB, &
 & 0.93788E-05_JPRB,0.10063E-04_JPRB,0.10098E-04_JPRB,0.22173E-06_JPRB /)  
KA(:, 4, 4, 1) = (/ &
 & 0.16059E-07_JPRB,0.40932E-05_JPRB,0.62586E-05_JPRB,0.77961E-05_JPRB,0.91475E-05_JPRB, &
 & 0.10347E-04_JPRB,0.11222E-04_JPRB,0.11312E-04_JPRB,0.24005E-06_JPRB /)  
KA(:, 5, 4, 1) = (/ &
 & 0.15254E-07_JPRB,0.43678E-05_JPRB,0.67525E-05_JPRB,0.84873E-05_JPRB,0.99995E-05_JPRB, &
 & 0.11353E-04_JPRB,0.12416E-04_JPRB,0.12586E-04_JPRB,0.25939E-06_JPRB /)  
KA(:, 1, 5, 1) = (/ &
 & 0.16261E-07_JPRB,0.26540E-05_JPRB,0.38541E-05_JPRB,0.46443E-05_JPRB,0.52961E-05_JPRB, &
 & 0.58054E-05_JPRB,0.60718E-05_JPRB,0.58540E-05_JPRB,0.14274E-06_JPRB /)  
KA(:, 2, 5, 1) = (/ &
 & 0.15265E-07_JPRB,0.28598E-05_JPRB,0.41831E-05_JPRB,0.51221E-05_JPRB,0.59110E-05_JPRB, &
 & 0.65207E-05_JPRB,0.69761E-05_JPRB,0.68685E-05_JPRB,0.15725E-06_JPRB /)  
KA(:, 3, 5, 1) = (/ &
 & 0.14384E-07_JPRB,0.30623E-05_JPRB,0.45528E-05_JPRB,0.56124E-05_JPRB,0.65650E-05_JPRB, &
 & 0.73436E-05_JPRB,0.78208E-05_JPRB,0.78523E-05_JPRB,0.17271E-06_JPRB /)  
KA(:, 4, 5, 1) = (/ &
 & 0.13599E-07_JPRB,0.32720E-05_JPRB,0.49622E-05_JPRB,0.61605E-05_JPRB,0.72244E-05_JPRB, &
 & 0.81582E-05_JPRB,0.87971E-05_JPRB,0.88096E-05_JPRB,0.18766E-06_JPRB /)  
KA(:, 5, 5, 1) = (/ &
 & 0.12895E-07_JPRB,0.34985E-05_JPRB,0.53833E-05_JPRB,0.67240E-05_JPRB,0.79091E-05_JPRB, &
 & 0.89688E-05_JPRB,0.97698E-05_JPRB,0.98639E-05_JPRB,0.20375E-06_JPRB /)  
KA(:, 1, 6, 1) = (/ &
 & 0.13898E-07_JPRB,0.20981E-05_JPRB,0.30384E-05_JPRB,0.36041E-05_JPRB,0.41040E-05_JPRB, &
 & 0.44334E-05_JPRB,0.45761E-05_JPRB,0.43950E-05_JPRB,0.11025E-06_JPRB /)  
KA(:, 2, 6, 1) = (/ &
 & 0.13011E-07_JPRB,0.22645E-05_JPRB,0.32890E-05_JPRB,0.40042E-05_JPRB,0.45851E-05_JPRB, &
 & 0.50473E-05_JPRB,0.53250E-05_JPRB,0.51854E-05_JPRB,0.12227E-06_JPRB /)  
KA(:, 3, 6, 1) = (/ &
 & 0.12231E-07_JPRB,0.24322E-05_JPRB,0.35842E-05_JPRB,0.43915E-05_JPRB,0.51259E-05_JPRB, &
 & 0.56903E-05_JPRB,0.60343E-05_JPRB,0.60166E-05_JPRB,0.13506E-06_JPRB /)  
KA(:, 4, 6, 1) = (/ &
 & 0.11539E-07_JPRB,0.26032E-05_JPRB,0.39107E-05_JPRB,0.48321E-05_JPRB,0.56525E-05_JPRB, &
 & 0.63625E-05_JPRB,0.68078E-05_JPRB,0.68024E-05_JPRB,0.14719E-06_JPRB /)  
KA(:, 5, 6, 1) = (/ &
 & 0.10921E-07_JPRB,0.27866E-05_JPRB,0.42578E-05_JPRB,0.52919E-05_JPRB,0.62181E-05_JPRB, &
 & 0.70362E-05_JPRB,0.76140E-05_JPRB,0.76519E-05_JPRB,0.16052E-06_JPRB /)  
KA(:, 1, 7, 1) = (/ &
 & 0.11886E-07_JPRB,0.16563E-05_JPRB,0.23860E-05_JPRB,0.28276E-05_JPRB,0.31449E-05_JPRB, &
 & 0.33771E-05_JPRB,0.34305E-05_JPRB,0.32824E-05_JPRB,0.84943E-07_JPRB /)  
KA(:, 2, 7, 1) = (/ &
 & 0.11096E-07_JPRB,0.17874E-05_JPRB,0.25861E-05_JPRB,0.31100E-05_JPRB,0.35425E-05_JPRB, &
 & 0.38737E-05_JPRB,0.40468E-05_JPRB,0.38933E-05_JPRB,0.94734E-07_JPRB /)  
KA(:, 3, 7, 1) = (/ &
 & 0.10405E-07_JPRB,0.19286E-05_JPRB,0.28166E-05_JPRB,0.34417E-05_JPRB,0.39786E-05_JPRB, &
 & 0.43804E-05_JPRB,0.46759E-05_JPRB,0.45835E-05_JPRB,0.10531E-06_JPRB /)  
KA(:, 4, 7, 1) = (/ &
 & 0.97948E-08_JPRB,0.20680E-05_JPRB,0.30741E-05_JPRB,0.37803E-05_JPRB,0.44163E-05_JPRB, &
 & 0.49420E-05_JPRB,0.52477E-05_JPRB,0.52509E-05_JPRB,0.11517E-06_JPRB /)  
KA(:, 5, 7, 1) = (/ &
 & 0.92522E-08_JPRB,0.22140E-05_JPRB,0.33558E-05_JPRB,0.41544E-05_JPRB,0.48719E-05_JPRB, &
 & 0.54968E-05_JPRB,0.59225E-05_JPRB,0.59027E-05_JPRB,0.12618E-06_JPRB /)  
KA(:, 1, 8, 1) = (/ &
 & 0.10164E-07_JPRB,0.13056E-05_JPRB,0.18690E-05_JPRB,0.21940E-05_JPRB,0.24210E-05_JPRB, &
 & 0.25504E-05_JPRB,0.25676E-05_JPRB,0.24444E-05_JPRB,0.66021E-07_JPRB /)  
KA(:, 2, 8, 1) = (/ &
 & 0.94612E-08_JPRB,0.14106E-05_JPRB,0.20398E-05_JPRB,0.24136E-05_JPRB,0.27424E-05_JPRB, &
 & 0.29578E-05_JPRB,0.30446E-05_JPRB,0.29182E-05_JPRB,0.73985E-07_JPRB /)  
KA(:, 3, 8, 1) = (/ &
 & 0.88489E-08_JPRB,0.15256E-05_JPRB,0.22123E-05_JPRB,0.26894E-05_JPRB,0.30704E-05_JPRB, &
 & 0.33808E-05_JPRB,0.35521E-05_JPRB,0.34526E-05_JPRB,0.82666E-07_JPRB /)  
KA(:, 4, 8, 1) = (/ &
 & 0.83111E-08_JPRB,0.16396E-05_JPRB,0.24159E-05_JPRB,0.29563E-05_JPRB,0.34504E-05_JPRB, &
 & 0.38196E-05_JPRB,0.40425E-05_JPRB,0.40093E-05_JPRB,0.90940E-07_JPRB /)  
KA(:, 5, 8, 1) = (/ &
 & 0.78349E-08_JPRB,0.17570E-05_JPRB,0.26398E-05_JPRB,0.32547E-05_JPRB,0.38060E-05_JPRB, &
 & 0.42813E-05_JPRB,0.45732E-05_JPRB,0.45465E-05_JPRB,0.10022E-06_JPRB /)  
KA(:, 1, 9, 1) = (/ &
 & 0.86983E-08_JPRB,0.10284E-05_JPRB,0.14734E-05_JPRB,0.16973E-05_JPRB,0.18551E-05_JPRB, &
 & 0.19223E-05_JPRB,0.19222E-05_JPRB,0.18289E-05_JPRB,0.53460E-07_JPRB /)  
KA(:, 2, 9, 1) = (/ &
 & 0.80712E-08_JPRB,0.11141E-05_JPRB,0.16016E-05_JPRB,0.18902E-05_JPRB,0.21027E-05_JPRB, &
 & 0.22504E-05_JPRB,0.22800E-05_JPRB,0.21749E-05_JPRB,0.60180E-07_JPRB /)  
KA(:, 3, 9, 1) = (/ &
 & 0.75284E-08_JPRB,0.12033E-05_JPRB,0.17376E-05_JPRB,0.20849E-05_JPRB,0.23719E-05_JPRB, &
 & 0.25906E-05_JPRB,0.26977E-05_JPRB,0.25910E-05_JPRB,0.66886E-07_JPRB /)  
KA(:, 4, 9, 1) = (/ &
 & 0.70541E-08_JPRB,0.12979E-05_JPRB,0.18959E-05_JPRB,0.23090E-05_JPRB,0.26695E-05_JPRB, &
 & 0.29367E-05_JPRB,0.31239E-05_JPRB,0.30574E-05_JPRB,0.73978E-07_JPRB /)  
KA(:, 5, 9, 1) = (/ &
 & 0.66359E-08_JPRB,0.13937E-05_JPRB,0.20720E-05_JPRB,0.25448E-05_JPRB,0.29680E-05_JPRB, &
 & 0.33208E-05_JPRB,0.35191E-05_JPRB,0.35097E-05_JPRB,0.81724E-07_JPRB /)  
KA(:, 1,10, 1) = (/ &
 & 0.74006E-08_JPRB,0.81705E-06_JPRB,0.11610E-05_JPRB,0.13325E-05_JPRB,0.14305E-05_JPRB, &
 & 0.14668E-05_JPRB,0.14642E-05_JPRB,0.13765E-05_JPRB,0.44724E-07_JPRB /)  
KA(:, 2,10, 1) = (/ &
 & 0.68477E-08_JPRB,0.88306E-06_JPRB,0.12640E-05_JPRB,0.14768E-05_JPRB,0.16329E-05_JPRB, &
 & 0.17209E-05_JPRB,0.17306E-05_JPRB,0.16441E-05_JPRB,0.50688E-07_JPRB /)  
KA(:, 3,10, 1) = (/ &
 & 0.63717E-08_JPRB,0.95522E-06_JPRB,0.13783E-05_JPRB,0.16303E-05_JPRB,0.18546E-05_JPRB, &
 & 0.19963E-05_JPRB,0.20570E-05_JPRB,0.19678E-05_JPRB,0.56052E-07_JPRB /)  
KA(:, 4,10, 1) = (/ &
 & 0.59576E-08_JPRB,0.10331E-05_JPRB,0.14975E-05_JPRB,0.18180E-05_JPRB,0.20770E-05_JPRB, &
 & 0.22813E-05_JPRB,0.24021E-05_JPRB,0.23350E-05_JPRB,0.62412E-07_JPRB /)  
KA(:, 5,10, 1) = (/ &
 & 0.55940E-08_JPRB,0.11102E-05_JPRB,0.16370E-05_JPRB,0.19999E-05_JPRB,0.23349E-05_JPRB, &
 & 0.25900E-05_JPRB,0.27328E-05_JPRB,0.27057E-05_JPRB,0.69466E-07_JPRB /)  
KA(:, 1,11, 1) = (/ &
 & 0.60617E-08_JPRB,0.67167E-06_JPRB,0.95594E-06_JPRB,0.10939E-05_JPRB,0.11767E-05_JPRB, &
 & 0.12059E-05_JPRB,0.12032E-05_JPRB,0.11314E-05_JPRB,0.37093E-07_JPRB /)  
KA(:, 2,11, 1) = (/ &
 & 0.56087E-08_JPRB,0.72704E-06_JPRB,0.10406E-05_JPRB,0.12137E-05_JPRB,0.13434E-05_JPRB, &
 & 0.14171E-05_JPRB,0.14246E-05_JPRB,0.13521E-05_JPRB,0.41918E-07_JPRB /)  
KA(:, 3,11, 1) = (/ &
 & 0.52187E-08_JPRB,0.78681E-06_JPRB,0.11338E-05_JPRB,0.13419E-05_JPRB,0.15254E-05_JPRB, &
 & 0.16426E-05_JPRB,0.16950E-05_JPRB,0.16203E-05_JPRB,0.46339E-07_JPRB /)  
KA(:, 4,11, 1) = (/ &
 & 0.48793E-08_JPRB,0.85013E-06_JPRB,0.12327E-05_JPRB,0.14971E-05_JPRB,0.17109E-05_JPRB, &
 & 0.18776E-05_JPRB,0.19784E-05_JPRB,0.19240E-05_JPRB,0.51725E-07_JPRB /)  
KA(:, 5,11, 1) = (/ &
 & 0.45815E-08_JPRB,0.91420E-06_JPRB,0.13427E-05_JPRB,0.16458E-05_JPRB,0.19221E-05_JPRB, &
 & 0.21323E-05_JPRB,0.22490E-05_JPRB,0.22263E-05_JPRB,0.57555E-07_JPRB /)  
KA(:, 1,12, 1) = (/ &
 & 0.49629E-08_JPRB,0.55223E-06_JPRB,0.78677E-06_JPRB,0.89789E-06_JPRB,0.96778E-06_JPRB, &
 & 0.99148E-06_JPRB,0.98883E-06_JPRB,0.93028E-06_JPRB,0.30610E-07_JPRB /)  
KA(:, 2,12, 1) = (/ &
 & 0.45920E-08_JPRB,0.59832E-06_JPRB,0.85632E-06_JPRB,0.99730E-06_JPRB,0.11052E-05_JPRB, &
 & 0.11665E-05_JPRB,0.11729E-05_JPRB,0.11125E-05_JPRB,0.34553E-07_JPRB /)  
KA(:, 3,12, 1) = (/ &
 & 0.42727E-08_JPRB,0.64760E-06_JPRB,0.93315E-06_JPRB,0.11041E-05_JPRB,0.12552E-05_JPRB, &
 & 0.13521E-05_JPRB,0.13956E-05_JPRB,0.13333E-05_JPRB,0.38176E-07_JPRB /)  
KA(:, 4,12, 1) = (/ &
 & 0.39949E-08_JPRB,0.69926E-06_JPRB,0.10110E-05_JPRB,0.12304E-05_JPRB,0.14083E-05_JPRB, &
 & 0.15442E-05_JPRB,0.16283E-05_JPRB,0.15837E-05_JPRB,0.42648E-07_JPRB /)  
KA(:, 5,12, 1) = (/ &
 & 0.37510E-08_JPRB,0.75239E-06_JPRB,0.11006E-05_JPRB,0.13535E-05_JPRB,0.15785E-05_JPRB, &
 & 0.17547E-05_JPRB,0.18501E-05_JPRB,0.18298E-05_JPRB,0.47452E-07_JPRB /)  
KA(:, 1,13, 1) = (/ &
 & 0.40633E-08_JPRB,0.45378E-06_JPRB,0.64719E-06_JPRB,0.73637E-06_JPRB,0.79571E-06_JPRB, &
 & 0.81503E-06_JPRB,0.81264E-06_JPRB,0.76488E-06_JPRB,0.25080E-07_JPRB /)  
KA(:, 2,13, 1) = (/ &
 & 0.37596E-08_JPRB,0.49208E-06_JPRB,0.70430E-06_JPRB,0.81894E-06_JPRB,0.90856E-06_JPRB, &
 & 0.95919E-06_JPRB,0.96435E-06_JPRB,0.91411E-06_JPRB,0.28293E-07_JPRB /)  
KA(:, 3,13, 1) = (/ &
 & 0.34982E-08_JPRB,0.53259E-06_JPRB,0.76370E-06_JPRB,0.90761E-06_JPRB,0.10316E-05_JPRB, &
 & 0.11116E-05_JPRB,0.11472E-05_JPRB,0.10956E-05_JPRB,0.31267E-07_JPRB /)  
KA(:, 4,13, 1) = (/ &
 & 0.32707E-08_JPRB,0.57488E-06_JPRB,0.82833E-06_JPRB,0.10096E-05_JPRB,0.11577E-05_JPRB, &
 & 0.12688E-05_JPRB,0.13388E-05_JPRB,0.13015E-05_JPRB,0.34930E-07_JPRB /)  
KA(:, 5,13, 1) = (/ &
 & 0.30710E-08_JPRB,0.61832E-06_JPRB,0.90250E-06_JPRB,0.11120E-05_JPRB,0.12962E-05_JPRB, &
 & 0.14424E-05_JPRB,0.15206E-05_JPRB,0.15032E-05_JPRB,0.38861E-07_JPRB /)  
KA(:, 1, 1, 2) = (/ &
 & 0.14215E-06_JPRB,0.65726E-04_JPRB,0.11327E-03_JPRB,0.15324E-03_JPRB,0.18473E-03_JPRB, &
 & 0.20658E-03_JPRB,0.21603E-03_JPRB,0.20617E-03_JPRB,0.13252E-04_JPRB /)  
KA(:, 2, 1, 2) = (/ &
 & 0.13452E-06_JPRB,0.69521E-04_JPRB,0.12059E-03_JPRB,0.16342E-03_JPRB,0.19613E-03_JPRB, &
 & 0.21987E-03_JPRB,0.22946E-03_JPRB,0.21879E-03_JPRB,0.14816E-04_JPRB /)  
KA(:, 3, 1, 2) = (/ &
 & 0.12766E-06_JPRB,0.73313E-04_JPRB,0.12786E-03_JPRB,0.17303E-03_JPRB,0.20754E-03_JPRB, &
 & 0.23326E-03_JPRB,0.24324E-03_JPRB,0.22956E-03_JPRB,0.16536E-04_JPRB /)  
KA(:, 4, 1, 2) = (/ &
 & 0.12147E-06_JPRB,0.77087E-04_JPRB,0.13521E-03_JPRB,0.18263E-03_JPRB,0.21904E-03_JPRB, &
 & 0.24614E-03_JPRB,0.25637E-03_JPRB,0.24060E-03_JPRB,0.18092E-04_JPRB /)  
KA(:, 5, 1, 2) = (/ &
 & 0.11584E-06_JPRB,0.80946E-04_JPRB,0.14233E-03_JPRB,0.19230E-03_JPRB,0.23047E-03_JPRB, &
 & 0.25869E-03_JPRB,0.26904E-03_JPRB,0.25139E-03_JPRB,0.19768E-04_JPRB /)  
KA(:, 1, 2, 2) = (/ &
 & 0.11918E-06_JPRB,0.55167E-04_JPRB,0.94557E-04_JPRB,0.12760E-03_JPRB,0.15322E-03_JPRB, &
 & 0.17148E-03_JPRB,0.17894E-03_JPRB,0.17049E-03_JPRB,0.10710E-04_JPRB /)  
KA(:, 2, 2, 2) = (/ &
 & 0.11264E-06_JPRB,0.58581E-04_JPRB,0.10113E-03_JPRB,0.13648E-03_JPRB,0.16335E-03_JPRB, &
 & 0.18288E-03_JPRB,0.19059E-03_JPRB,0.18131E-03_JPRB,0.12067E-04_JPRB /)  
KA(:, 3, 2, 2) = (/ &
 & 0.10678E-06_JPRB,0.61935E-04_JPRB,0.10756E-03_JPRB,0.14497E-03_JPRB,0.17335E-03_JPRB, &
 & 0.19437E-03_JPRB,0.20245E-03_JPRB,0.19070E-03_JPRB,0.13553E-04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART2',0,ZHOOK_HANDLE)


KA(:, 4, 2, 2) = (/ &
 & 0.10149E-06_JPRB,0.65261E-04_JPRB,0.11404E-03_JPRB,0.15331E-03_JPRB,0.18323E-03_JPRB, &
 & 0.20559E-03_JPRB,0.21385E-03_JPRB,0.20024E-03_JPRB,0.14801E-04_JPRB /)  
KA(:, 5, 2, 2) = (/ &
 & 0.96699E-07_JPRB,0.68698E-04_JPRB,0.12038E-03_JPRB,0.16167E-03_JPRB,0.19308E-03_JPRB, &
 & 0.21635E-03_JPRB,0.22479E-03_JPRB,0.20964E-03_JPRB,0.16245E-04_JPRB /)  
KA(:, 1, 3, 2) = (/ &
 & 0.10112E-06_JPRB,0.45399E-04_JPRB,0.77226E-04_JPRB,0.10397E-03_JPRB,0.12462E-03_JPRB, &
 & 0.13956E-03_JPRB,0.14531E-03_JPRB,0.13816E-03_JPRB,0.83635E-05_JPRB /)  
KA(:, 2, 3, 2) = (/ &
 & 0.95381E-07_JPRB,0.48357E-04_JPRB,0.82986E-04_JPRB,0.11173E-03_JPRB,0.13338E-03_JPRB, &
 & 0.14898E-03_JPRB,0.15534E-03_JPRB,0.14786E-03_JPRB,0.94915E-05_JPRB /)  
KA(:, 3, 3, 2) = (/ &
 & 0.90257E-07_JPRB,0.51355E-04_JPRB,0.88727E-04_JPRB,0.11920E-03_JPRB,0.14215E-03_JPRB, &
 & 0.15859E-03_JPRB,0.16541E-03_JPRB,0.15622E-03_JPRB,0.10683E-04_JPRB /)  
KA(:, 4, 3, 2) = (/ &
 & 0.85653E-07_JPRB,0.54322E-04_JPRB,0.94369E-04_JPRB,0.12646E-03_JPRB,0.15072E-03_JPRB, &
 & 0.16838E-03_JPRB,0.17536E-03_JPRB,0.16433E-03_JPRB,0.11764E-04_JPRB /)  
KA(:, 5, 3, 2) = (/ &
 & 0.81492E-07_JPRB,0.57300E-04_JPRB,0.99940E-04_JPRB,0.13355E-03_JPRB,0.15929E-03_JPRB, &
 & 0.17800E-03_JPRB,0.18496E-03_JPRB,0.17234E-03_JPRB,0.12979E-04_JPRB /)  
KA(:, 1, 4, 2) = (/ &
 & 0.86132E-07_JPRB,0.36910E-04_JPRB,0.62346E-04_JPRB,0.83628E-04_JPRB,0.10025E-03_JPRB, &
 & 0.11224E-03_JPRB,0.11706E-03_JPRB,0.11109E-03_JPRB,0.64715E-05_JPRB /)  
KA(:, 2, 4, 2) = (/ &
 & 0.81062E-07_JPRB,0.39490E-04_JPRB,0.67274E-04_JPRB,0.90384E-04_JPRB,0.10785E-03_JPRB, &
 & 0.12026E-03_JPRB,0.12543E-03_JPRB,0.11944E-03_JPRB,0.73991E-05_JPRB /)  
KA(:, 3, 4, 2) = (/ &
 & 0.76553E-07_JPRB,0.42055E-04_JPRB,0.72269E-04_JPRB,0.96956E-04_JPRB,0.11528E-03_JPRB, &
 & 0.12833E-03_JPRB,0.13396E-03_JPRB,0.12697E-03_JPRB,0.83899E-05_JPRB /)  
KA(:, 4, 4, 2) = (/ &
 & 0.72516E-07_JPRB,0.44696E-04_JPRB,0.77235E-04_JPRB,0.10321E-03_JPRB,0.12276E-03_JPRB, &
 & 0.13674E-03_JPRB,0.14260E-03_JPRB,0.13384E-03_JPRB,0.93052E-05_JPRB /)  
KA(:, 5, 4, 2) = (/ &
 & 0.68881E-07_JPRB,0.47273E-04_JPRB,0.82118E-04_JPRB,0.10935E-03_JPRB,0.13016E-03_JPRB, &
 & 0.14506E-03_JPRB,0.15080E-03_JPRB,0.14062E-03_JPRB,0.10314E-04_JPRB /)  
KA(:, 1, 5, 2) = (/ &
 & 0.73401E-07_JPRB,0.29772E-04_JPRB,0.49957E-04_JPRB,0.66720E-04_JPRB,0.80104E-04_JPRB, &
 & 0.89761E-04_JPRB,0.93853E-04_JPRB,0.88953E-04_JPRB,0.50171E-05_JPRB /)  
KA(:, 2, 5, 2) = (/ &
 & 0.68916E-07_JPRB,0.31976E-04_JPRB,0.54217E-04_JPRB,0.72570E-04_JPRB,0.86671E-04_JPRB, &
 & 0.96653E-04_JPRB,0.10073E-03_JPRB,0.95875E-04_JPRB,0.57746E-05_JPRB /)  
KA(:, 3, 5, 2) = (/ &
 & 0.64945E-07_JPRB,0.34219E-04_JPRB,0.58417E-04_JPRB,0.78327E-04_JPRB,0.92950E-04_JPRB, &
 & 0.10358E-03_JPRB,0.10803E-03_JPRB,0.10274E-03_JPRB,0.66197E-05_JPRB /)  
KA(:, 4, 5, 2) = (/ &
 & 0.61405E-07_JPRB,0.36457E-04_JPRB,0.62694E-04_JPRB,0.83756E-04_JPRB,0.99356E-04_JPRB, &
 & 0.11058E-03_JPRB,0.11542E-03_JPRB,0.10858E-03_JPRB,0.73729E-05_JPRB /)  
KA(:, 5, 5, 2) = (/ &
 & 0.58229E-07_JPRB,0.38713E-04_JPRB,0.67059E-04_JPRB,0.89033E-04_JPRB,0.10573E-03_JPRB, &
 & 0.11764E-03_JPRB,0.12243E-03_JPRB,0.11440E-03_JPRB,0.82149E-05_JPRB /)  
KA(:, 1, 6, 2) = (/ &
 & 0.62723E-07_JPRB,0.23750E-04_JPRB,0.39643E-04_JPRB,0.52796E-04_JPRB,0.63478E-04_JPRB, &
 & 0.71151E-04_JPRB,0.74640E-04_JPRB,0.70193E-04_JPRB,0.38899E-05_JPRB /)  
KA(:, 2, 6, 2) = (/ &
 & 0.58735E-07_JPRB,0.25657E-04_JPRB,0.43274E-04_JPRB,0.57719E-04_JPRB,0.69124E-04_JPRB, &
 & 0.77375E-04_JPRB,0.80498E-04_JPRB,0.76543E-04_JPRB,0.44833E-05_JPRB /)  
KA(:, 3, 6, 2) = (/ &
 & 0.55222E-07_JPRB,0.27563E-04_JPRB,0.46866E-04_JPRB,0.62699E-04_JPRB,0.74494E-04_JPRB, &
 & 0.82946E-04_JPRB,0.86653E-04_JPRB,0.82509E-04_JPRB,0.51635E-05_JPRB /)  
KA(:, 4, 6, 2) = (/ &
 & 0.52103E-07_JPRB,0.29528E-04_JPRB,0.50470E-04_JPRB,0.67473E-04_JPRB,0.79899E-04_JPRB, &
 & 0.89004E-04_JPRB,0.92786E-04_JPRB,0.87628E-04_JPRB,0.58104E-05_JPRB /)  
KA(:, 5, 6, 2) = (/ &
 & 0.49317E-07_JPRB,0.31444E-04_JPRB,0.54175E-04_JPRB,0.72000E-04_JPRB,0.85322E-04_JPRB, &
 & 0.94885E-04_JPRB,0.98826E-04_JPRB,0.92648E-04_JPRB,0.64997E-05_JPRB /)  
KA(:, 1, 7, 2) = (/ &
 & 0.53634E-07_JPRB,0.18862E-04_JPRB,0.31325E-04_JPRB,0.41575E-04_JPRB,0.50141E-04_JPRB, &
 & 0.56190E-04_JPRB,0.58882E-04_JPRB,0.55026E-04_JPRB,0.29795E-05_JPRB /)  
KA(:, 2, 7, 2) = (/ &
 & 0.50084E-07_JPRB,0.20474E-04_JPRB,0.34342E-04_JPRB,0.45732E-04_JPRB,0.54884E-04_JPRB, &
 & 0.61494E-04_JPRB,0.64187E-04_JPRB,0.60857E-04_JPRB,0.34589E-05_JPRB /)  
KA(:, 3, 7, 2) = (/ &
 & 0.46973E-07_JPRB,0.22063E-04_JPRB,0.37411E-04_JPRB,0.49893E-04_JPRB,0.59475E-04_JPRB, &
 & 0.66279E-04_JPRB,0.69129E-04_JPRB,0.65758E-04_JPRB,0.39983E-05_JPRB /)  
KA(:, 4, 7, 2) = (/ &
 & 0.44224E-07_JPRB,0.23764E-04_JPRB,0.40481E-04_JPRB,0.54107E-04_JPRB,0.64026E-04_JPRB, &
 & 0.71350E-04_JPRB,0.74328E-04_JPRB,0.70513E-04_JPRB,0.45526E-05_JPRB /)  
KA(:, 5, 7, 2) = (/ &
 & 0.41777E-07_JPRB,0.25434E-04_JPRB,0.43555E-04_JPRB,0.57958E-04_JPRB,0.68599E-04_JPRB, &
 & 0.76304E-04_JPRB,0.79456E-04_JPRB,0.74649E-04_JPRB,0.51046E-05_JPRB /)  
KA(:, 1, 8, 2) = (/ &
 & 0.45857E-07_JPRB,0.14945E-04_JPRB,0.24594E-04_JPRB,0.32696E-04_JPRB,0.39571E-04_JPRB, &
 & 0.44348E-04_JPRB,0.46090E-04_JPRB,0.43034E-04_JPRB,0.22833E-05_JPRB /)  
KA(:, 2, 8, 2) = (/ &
 & 0.42697E-07_JPRB,0.16265E-04_JPRB,0.27198E-04_JPRB,0.36108E-04_JPRB,0.43381E-04_JPRB, &
 & 0.48642E-04_JPRB,0.50943E-04_JPRB,0.47848E-04_JPRB,0.26669E-05_JPRB /)  
KA(:, 3, 8, 2) = (/ &
 & 0.39944E-07_JPRB,0.17616E-04_JPRB,0.29775E-04_JPRB,0.39577E-04_JPRB,0.47366E-04_JPRB, &
 & 0.52791E-04_JPRB,0.54992E-04_JPRB,0.52236E-04_JPRB,0.30932E-05_JPRB /)  
KA(:, 4, 8, 2) = (/ &
 & 0.37522E-07_JPRB,0.19042E-04_JPRB,0.32351E-04_JPRB,0.43126E-04_JPRB,0.51153E-04_JPRB, &
 & 0.56987E-04_JPRB,0.59316E-04_JPRB,0.56438E-04_JPRB,0.35666E-05_JPRB /)  
KA(:, 5, 8, 2) = (/ &
 & 0.35376E-07_JPRB,0.20476E-04_JPRB,0.34946E-04_JPRB,0.46521E-04_JPRB,0.55009E-04_JPRB, &
 & 0.61221E-04_JPRB,0.63714E-04_JPRB,0.60035E-04_JPRB,0.40037E-05_JPRB /)  
KA(:, 1, 9, 2) = (/ &
 & 0.39233E-07_JPRB,0.11817E-04_JPRB,0.19254E-04_JPRB,0.25596E-04_JPRB,0.30843E-04_JPRB, &
 & 0.34574E-04_JPRB,0.36035E-04_JPRB,0.33425E-04_JPRB,0.17673E-05_JPRB /)  
KA(:, 2, 9, 2) = (/ &
 & 0.36418E-07_JPRB,0.12914E-04_JPRB,0.21404E-04_JPRB,0.28372E-04_JPRB,0.34161E-04_JPRB, &
 & 0.38321E-04_JPRB,0.40053E-04_JPRB,0.37435E-04_JPRB,0.20751E-05_JPRB /)  
KA(:, 3, 9, 2) = (/ &
 & 0.33979E-07_JPRB,0.14026E-04_JPRB,0.23574E-04_JPRB,0.31316E-04_JPRB,0.37514E-04_JPRB, &
 & 0.41977E-04_JPRB,0.43747E-04_JPRB,0.41346E-04_JPRB,0.24151E-05_JPRB /)  
KA(:, 4, 9, 2) = (/ &
 & 0.31844E-07_JPRB,0.15205E-04_JPRB,0.25770E-04_JPRB,0.34231E-04_JPRB,0.40723E-04_JPRB, &
 & 0.45315E-04_JPRB,0.47202E-04_JPRB,0.44869E-04_JPRB,0.28151E-05_JPRB /)  
KA(:, 5, 9, 2) = (/ &
 & 0.29961E-07_JPRB,0.16420E-04_JPRB,0.27955E-04_JPRB,0.37187E-04_JPRB,0.43941E-04_JPRB, &
 & 0.48873E-04_JPRB,0.50856E-04_JPRB,0.48170E-04_JPRB,0.31733E-05_JPRB /)  
KA(:, 1,10, 2) = (/ &
 & 0.33373E-07_JPRB,0.93505E-05_JPRB,0.15216E-04_JPRB,0.20198E-04_JPRB,0.24244E-04_JPRB, &
 & 0.27077E-04_JPRB,0.28186E-04_JPRB,0.25996E-04_JPRB,0.13941E-05_JPRB /)  
KA(:, 2,10, 2) = (/ &
 & 0.30893E-07_JPRB,0.10284E-04_JPRB,0.16902E-04_JPRB,0.22468E-04_JPRB,0.27072E-04_JPRB, &
 & 0.30382E-04_JPRB,0.31603E-04_JPRB,0.29456E-04_JPRB,0.16352E-05_JPRB /)  
KA(:, 3,10, 2) = (/ &
 & 0.28754E-07_JPRB,0.11207E-04_JPRB,0.18715E-04_JPRB,0.24849E-04_JPRB,0.29815E-04_JPRB, &
 & 0.33379E-04_JPRB,0.34901E-04_JPRB,0.32836E-04_JPRB,0.19188E-05_JPRB /)  
KA(:, 4,10, 2) = (/ &
 & 0.26892E-07_JPRB,0.12172E-04_JPRB,0.20578E-04_JPRB,0.27269E-04_JPRB,0.32536E-04_JPRB, &
 & 0.36182E-04_JPRB,0.37703E-04_JPRB,0.35750E-04_JPRB,0.22467E-05_JPRB /)  
KA(:, 5,10, 2) = (/ &
 & 0.25255E-07_JPRB,0.13195E-04_JPRB,0.22422E-04_JPRB,0.29781E-04_JPRB,0.35220E-04_JPRB, &
 & 0.39157E-04_JPRB,0.40719E-04_JPRB,0.38729E-04_JPRB,0.25535E-05_JPRB /)  
KA(:, 1,11, 2) = (/ &
 & 0.27335E-07_JPRB,0.77491E-05_JPRB,0.12607E-04_JPRB,0.16695E-04_JPRB,0.20093E-04_JPRB, &
 & 0.22431E-04_JPRB,0.23345E-04_JPRB,0.21522E-04_JPRB,0.11569E-05_JPRB /)  
KA(:, 2,11, 2) = (/ &
 & 0.25303E-07_JPRB,0.85322E-05_JPRB,0.14022E-04_JPRB,0.18593E-04_JPRB,0.22378E-04_JPRB, &
 & 0.25133E-04_JPRB,0.26161E-04_JPRB,0.24379E-04_JPRB,0.13709E-05_JPRB /)  
KA(:, 3,11, 2) = (/ &
 & 0.23551E-07_JPRB,0.92912E-05_JPRB,0.15536E-04_JPRB,0.20618E-04_JPRB,0.24722E-04_JPRB, &
 & 0.27647E-04_JPRB,0.28874E-04_JPRB,0.27196E-04_JPRB,0.16099E-05_JPRB /)  
KA(:, 4,11, 2) = (/ &
 & 0.22025E-07_JPRB,0.10117E-04_JPRB,0.17115E-04_JPRB,0.22645E-04_JPRB,0.26974E-04_JPRB, &
 & 0.29947E-04_JPRB,0.31210E-04_JPRB,0.29581E-04_JPRB,0.18845E-05_JPRB /)  
KA(:, 5,11, 2) = (/ &
 & 0.20684E-07_JPRB,0.10977E-04_JPRB,0.18645E-04_JPRB,0.24734E-04_JPRB,0.29203E-04_JPRB, &
 & 0.32453E-04_JPRB,0.33733E-04_JPRB,0.32056E-04_JPRB,0.21326E-05_JPRB /)  
KA(:, 1,12, 2) = (/ &
 & 0.22380E-07_JPRB,0.64144E-05_JPRB,0.10436E-04_JPRB,0.13802E-04_JPRB,0.16622E-04_JPRB, &
 & 0.18557E-04_JPRB,0.19314E-04_JPRB,0.17793E-04_JPRB,0.95906E-06_JPRB /)  
KA(:, 2,12, 2) = (/ &
 & 0.20716E-07_JPRB,0.70603E-05_JPRB,0.11625E-04_JPRB,0.15385E-04_JPRB,0.18503E-04_JPRB, &
 & 0.20776E-04_JPRB,0.21630E-04_JPRB,0.20152E-04_JPRB,0.11363E-05_JPRB /)  
KA(:, 3,12, 2) = (/ &
 & 0.19282E-07_JPRB,0.76960E-05_JPRB,0.12886E-04_JPRB,0.17087E-04_JPRB,0.20475E-04_JPRB, &
 & 0.22867E-04_JPRB,0.23856E-04_JPRB,0.22506E-04_JPRB,0.13400E-05_JPRB /)  
KA(:, 4,12, 2) = (/ &
 & 0.18032E-07_JPRB,0.83983E-05_JPRB,0.14206E-04_JPRB,0.18783E-04_JPRB,0.22334E-04_JPRB, &
 & 0.24764E-04_JPRB,0.25815E-04_JPRB,0.24461E-04_JPRB,0.15637E-05_JPRB /)  
KA(:, 5,12, 2) = (/ &
 & 0.16934E-07_JPRB,0.91186E-05_JPRB,0.15491E-04_JPRB,0.20513E-04_JPRB,0.24201E-04_JPRB, &
 & 0.26864E-04_JPRB,0.27917E-04_JPRB,0.26491E-04_JPRB,0.17707E-05_JPRB /)  
KA(:, 1,13, 2) = (/ &
 & 0.18323E-07_JPRB,0.53022E-05_JPRB,0.86273E-05_JPRB,0.11385E-04_JPRB,0.13729E-04_JPRB, &
 & 0.15318E-04_JPRB,0.15952E-04_JPRB,0.14693E-04_JPRB,0.78927E-06_JPRB /)  
KA(:, 2,13, 2) = (/ &
 & 0.16961E-07_JPRB,0.58316E-05_JPRB,0.96204E-05_JPRB,0.12717E-04_JPRB,0.15275E-04_JPRB, &
 & 0.17141E-04_JPRB,0.17863E-04_JPRB,0.16639E-04_JPRB,0.93659E-06_JPRB /)  
KA(:, 3,13, 2) = (/ &
 & 0.15787E-07_JPRB,0.63710E-05_JPRB,0.10675E-04_JPRB,0.14140E-04_JPRB,0.16925E-04_JPRB, &
 & 0.18881E-04_JPRB,0.19675E-04_JPRB,0.18564E-04_JPRB,0.11050E-05_JPRB /)  
KA(:, 4,13, 2) = (/ &
 & 0.14764E-07_JPRB,0.69607E-05_JPRB,0.11779E-04_JPRB,0.15554E-04_JPRB,0.18475E-04_JPRB, &
 & 0.20461E-04_JPRB,0.21320E-04_JPRB,0.20207E-04_JPRB,0.12868E-05_JPRB /)  
KA(:, 5,13, 2) = (/ &
 & 0.13865E-07_JPRB,0.75611E-05_JPRB,0.12843E-04_JPRB,0.16991E-04_JPRB,0.20029E-04_JPRB, &
 & 0.22208E-04_JPRB,0.23079E-04_JPRB,0.21838E-04_JPRB,0.14565E-05_JPRB /)  
KA(:, 1, 1, 3) = (/ &
 & 0.55948E-06_JPRB,0.43472E-03_JPRB,0.65689E-03_JPRB,0.80237E-03_JPRB,0.90326E-03_JPRB, &
 & 0.95995E-03_JPRB,0.94242E-03_JPRB,0.81801E-03_JPRB,0.18380E-03_JPRB /)  
KA(:, 2, 1, 3) = (/ &
 & 0.53175E-06_JPRB,0.45395E-03_JPRB,0.68779E-03_JPRB,0.84040E-03_JPRB,0.94598E-03_JPRB, &
 & 0.10011E-02_JPRB,0.98481E-03_JPRB,0.85748E-03_JPRB,0.19567E-03_JPRB /)  
KA(:, 3, 1, 3) = (/ &
 & 0.50648E-06_JPRB,0.46835E-03_JPRB,0.71403E-03_JPRB,0.87684E-03_JPRB,0.98520E-03_JPRB, &
 & 0.10393E-02_JPRB,0.10233E-02_JPRB,0.89729E-03_JPRB,0.20725E-03_JPRB /)  
KA(:, 4, 1, 3) = (/ &
 & 0.48330E-06_JPRB,0.48143E-03_JPRB,0.73979E-03_JPRB,0.91063E-03_JPRB,0.10212E-02_JPRB, &
 & 0.10762E-02_JPRB,0.10600E-02_JPRB,0.93507E-03_JPRB,0.21814E-03_JPRB /)  
KA(:, 5, 1, 3) = (/ &
 & 0.46195E-06_JPRB,0.49413E-03_JPRB,0.76470E-03_JPRB,0.94208E-03_JPRB,0.10547E-02_JPRB, &
 & 0.11099E-02_JPRB,0.10960E-02_JPRB,0.97164E-03_JPRB,0.23056E-03_JPRB /)  
KA(:, 1, 2, 3) = (/ &
 & 0.46813E-06_JPRB,0.36711E-03_JPRB,0.55743E-03_JPRB,0.68070E-03_JPRB,0.76614E-03_JPRB, &
 & 0.81442E-03_JPRB,0.79940E-03_JPRB,0.69691E-03_JPRB,0.14988E-03_JPRB /)  
KA(:, 2, 2, 3) = (/ &
 & 0.44450E-06_JPRB,0.38413E-03_JPRB,0.58502E-03_JPRB,0.71506E-03_JPRB,0.80409E-03_JPRB, &
 & 0.85191E-03_JPRB,0.83722E-03_JPRB,0.73231E-03_JPRB,0.15985E-03_JPRB /)  
KA(:, 3, 2, 3) = (/ &
 & 0.42301E-06_JPRB,0.39744E-03_JPRB,0.60852E-03_JPRB,0.74741E-03_JPRB,0.83920E-03_JPRB, &
 & 0.88588E-03_JPRB,0.87206E-03_JPRB,0.76677E-03_JPRB,0.16968E-03_JPRB /)  
KA(:, 4, 2, 3) = (/ &
 & 0.40335E-06_JPRB,0.40927E-03_JPRB,0.63200E-03_JPRB,0.77835E-03_JPRB,0.87190E-03_JPRB, &
 & 0.91843E-03_JPRB,0.90467E-03_JPRB,0.79859E-03_JPRB,0.17948E-03_JPRB /)  
KA(:, 5, 2, 3) = (/ &
 & 0.38529E-06_JPRB,0.42034E-03_JPRB,0.65353E-03_JPRB,0.80758E-03_JPRB,0.90248E-03_JPRB, &
 & 0.94929E-03_JPRB,0.93715E-03_JPRB,0.83136E-03_JPRB,0.19018E-03_JPRB /)  
KA(:, 1, 3, 3) = (/ &
 & 0.39591E-06_JPRB,0.30459E-03_JPRB,0.46364E-03_JPRB,0.56590E-03_JPRB,0.63680E-03_JPRB, &
 & 0.67681E-03_JPRB,0.66517E-03_JPRB,0.58106E-03_JPRB,0.11936E-03_JPRB /)  
KA(:, 2, 3, 3) = (/ &
 & 0.37538E-06_JPRB,0.32036E-03_JPRB,0.48874E-03_JPRB,0.59649E-03_JPRB,0.67170E-03_JPRB, &
 & 0.71161E-03_JPRB,0.69943E-03_JPRB,0.61159E-03_JPRB,0.12804E-03_JPRB /)  
KA(:, 3, 3, 3) = (/ &
 & 0.35675E-06_JPRB,0.33321E-03_JPRB,0.50999E-03_JPRB,0.62591E-03_JPRB,0.70319E-03_JPRB, &
 & 0.74333E-03_JPRB,0.73015E-03_JPRB,0.64070E-03_JPRB,0.13642E-03_JPRB /)  
KA(:, 4, 3, 3) = (/ &
 & 0.33978E-06_JPRB,0.34382E-03_JPRB,0.53102E-03_JPRB,0.65391E-03_JPRB,0.73278E-03_JPRB, &
 & 0.77303E-03_JPRB,0.75990E-03_JPRB,0.66979E-03_JPRB,0.14477E-03_JPRB /)  
KA(:, 5, 3, 3) = (/ &
 & 0.32422E-06_JPRB,0.35416E-03_JPRB,0.55071E-03_JPRB,0.68042E-03_JPRB,0.76041E-03_JPRB, &
 & 0.80118E-03_JPRB,0.78914E-03_JPRB,0.69923E-03_JPRB,0.15365E-03_JPRB /)  
KA(:, 1, 4, 3) = (/ &
 & 0.33598E-06_JPRB,0.24970E-03_JPRB,0.38053E-03_JPRB,0.46464E-03_JPRB,0.52234E-03_JPRB, &
 & 0.55488E-03_JPRB,0.54675E-03_JPRB,0.47794E-03_JPRB,0.95275E-04_JPRB /)  
KA(:, 2, 4, 3) = (/ &
 & 0.31800E-06_JPRB,0.26415E-03_JPRB,0.40313E-03_JPRB,0.49210E-03_JPRB,0.55359E-03_JPRB, &
 & 0.58661E-03_JPRB,0.57694E-03_JPRB,0.50393E-03_JPRB,0.10292E-03_JPRB /)  
KA(:, 3, 4, 3) = (/ &
 & 0.30177E-06_JPRB,0.27638E-03_JPRB,0.42268E-03_JPRB,0.51823E-03_JPRB,0.58348E-03_JPRB, &
 & 0.61591E-03_JPRB,0.60497E-03_JPRB,0.52947E-03_JPRB,0.11016E-03_JPRB /)  
KA(:, 4, 4, 3) = (/ &
 & 0.28703E-06_JPRB,0.28612E-03_JPRB,0.44165E-03_JPRB,0.54326E-03_JPRB,0.61010E-03_JPRB, &
 & 0.64299E-03_JPRB,0.63151E-03_JPRB,0.55558E-03_JPRB,0.11708E-03_JPRB /)  
KA(:, 5, 4, 3) = (/ &
 & 0.27356E-06_JPRB,0.29550E-03_JPRB,0.45903E-03_JPRB,0.56703E-03_JPRB,0.63522E-03_JPRB, &
 & 0.66839E-03_JPRB,0.65812E-03_JPRB,0.58142E-03_JPRB,0.12444E-03_JPRB /)  
KA(:, 1, 5, 3) = (/ &
 & 0.28517E-06_JPRB,0.20305E-03_JPRB,0.30940E-03_JPRB,0.37854E-03_JPRB,0.42516E-03_JPRB, &
 & 0.45167E-03_JPRB,0.44617E-03_JPRB,0.39006E-03_JPRB,0.76394E-04_JPRB /)  
KA(:, 2, 5, 3) = (/ &
 & 0.26943E-06_JPRB,0.21631E-03_JPRB,0.32942E-03_JPRB,0.40279E-03_JPRB,0.45281E-03_JPRB, &
 & 0.47959E-03_JPRB,0.47274E-03_JPRB,0.41219E-03_JPRB,0.83093E-04_JPRB /)  
KA(:, 3, 5, 3) = (/ &
 & 0.25526E-06_JPRB,0.22760E-03_JPRB,0.34736E-03_JPRB,0.42603E-03_JPRB,0.47928E-03_JPRB, &
 & 0.50573E-03_JPRB,0.49753E-03_JPRB,0.43423E-03_JPRB,0.89137E-04_JPRB /)  
KA(:, 4, 5, 3) = (/ &
 & 0.24245E-06_JPRB,0.23661E-03_JPRB,0.36423E-03_JPRB,0.44832E-03_JPRB,0.50373E-03_JPRB, &
 & 0.53021E-03_JPRB,0.52092E-03_JPRB,0.45715E-03_JPRB,0.95026E-04_JPRB /)  
KA(:, 5, 5, 3) = (/ &
 & 0.23079E-06_JPRB,0.24490E-03_JPRB,0.37979E-03_JPRB,0.46958E-03_JPRB,0.52671E-03_JPRB, &
 & 0.55360E-03_JPRB,0.54422E-03_JPRB,0.47982E-03_JPRB,0.10100E-03_JPRB /)  
KA(:, 1, 6, 3) = (/ &
 & 0.24258E-06_JPRB,0.16374E-03_JPRB,0.24889E-03_JPRB,0.30526E-03_JPRB,0.34256E-03_JPRB, &
 & 0.36437E-03_JPRB,0.36054E-03_JPRB,0.31643E-03_JPRB,0.60983E-04_JPRB /)  
KA(:, 2, 6, 3) = (/ &
 & 0.22873E-06_JPRB,0.17557E-03_JPRB,0.26674E-03_JPRB,0.32662E-03_JPRB,0.36698E-03_JPRB, &
 & 0.38862E-03_JPRB,0.38395E-03_JPRB,0.33481E-03_JPRB,0.66717E-04_JPRB /)  
KA(:, 3, 6, 3) = (/ &
 & 0.21632E-06_JPRB,0.18596E-03_JPRB,0.28315E-03_JPRB,0.34710E-03_JPRB,0.39032E-03_JPRB, &
 & 0.41186E-03_JPRB,0.40597E-03_JPRB,0.35347E-03_JPRB,0.71805E-04_JPRB /)  
KA(:, 4, 6, 3) = (/ &
 & 0.20515E-06_JPRB,0.19412E-03_JPRB,0.29825E-03_JPRB,0.36672E-03_JPRB,0.41223E-03_JPRB, &
 & 0.43370E-03_JPRB,0.42654E-03_JPRB,0.37308E-03_JPRB,0.76950E-04_JPRB /)  
KA(:, 5, 6, 3) = (/ &
 & 0.19500E-06_JPRB,0.20163E-03_JPRB,0.31177E-03_JPRB,0.38573E-03_JPRB,0.43298E-03_JPRB, &
 & 0.45474E-03_JPRB,0.44659E-03_JPRB,0.39273E-03_JPRB,0.81854E-04_JPRB /)  
KA(:, 1, 7, 3) = (/ &
 & 0.20644E-06_JPRB,0.13088E-03_JPRB,0.19883E-03_JPRB,0.24453E-03_JPRB,0.27379E-03_JPRB, &
 & 0.29133E-03_JPRB,0.28972E-03_JPRB,0.25527E-03_JPRB,0.48483E-04_JPRB /)  
KA(:, 2, 7, 3) = (/ &
 & 0.19422E-06_JPRB,0.14123E-03_JPRB,0.21464E-03_JPRB,0.26307E-03_JPRB,0.29520E-03_JPRB, &
 & 0.31262E-03_JPRB,0.30976E-03_JPRB,0.27057E-03_JPRB,0.53189E-04_JPRB /)  
KA(:, 3, 7, 3) = (/ &
 & 0.18334E-06_JPRB,0.15056E-03_JPRB,0.22945E-03_JPRB,0.28102E-03_JPRB,0.31570E-03_JPRB, &
 & 0.33336E-03_JPRB,0.32921E-03_JPRB,0.28657E-03_JPRB,0.57664E-04_JPRB /)  
KA(:, 4, 7, 3) = (/ &
 & 0.17359E-06_JPRB,0.15845E-03_JPRB,0.24254E-03_JPRB,0.29812E-03_JPRB,0.33533E-03_JPRB, &
 & 0.35273E-03_JPRB,0.34737E-03_JPRB,0.30290E-03_JPRB,0.62080E-04_JPRB /)  
KA(:, 5, 7, 3) = (/ &
 & 0.16476E-06_JPRB,0.16515E-03_JPRB,0.25472E-03_JPRB,0.31492E-03_JPRB,0.35368E-03_JPRB, &
 & 0.37134E-03_JPRB,0.36466E-03_JPRB,0.31971E-03_JPRB,0.66283E-04_JPRB /)  
KA(:, 1, 8, 3) = (/ &
 & 0.17564E-06_JPRB,0.10377E-03_JPRB,0.15799E-03_JPRB,0.19443E-03_JPRB,0.21775E-03_JPRB, &
 & 0.23221E-03_JPRB,0.23178E-03_JPRB,0.20518E-03_JPRB,0.38613E-04_JPRB /)  
KA(:, 2, 8, 3) = (/ &
 & 0.16486E-06_JPRB,0.11291E-03_JPRB,0.17177E-03_JPRB,0.21060E-03_JPRB,0.23605E-03_JPRB, &
 & 0.25023E-03_JPRB,0.24860E-03_JPRB,0.21840E-03_JPRB,0.42574E-04_JPRB /)  
KA(:, 3, 8, 3) = (/ &
 & 0.15532E-06_JPRB,0.12160E-03_JPRB,0.18472E-03_JPRB,0.22613E-03_JPRB,0.25383E-03_JPRB, &
 & 0.26813E-03_JPRB,0.26569E-03_JPRB,0.23149E-03_JPRB,0.46438E-04_JPRB /)  
KA(:, 4, 8, 3) = (/ &
 & 0.14679E-06_JPRB,0.12871E-03_JPRB,0.19629E-03_JPRB,0.24117E-03_JPRB,0.27101E-03_JPRB, &
 & 0.28546E-03_JPRB,0.28148E-03_JPRB,0.24511E-03_JPRB,0.50132E-04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


SUBROUTINE PART3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART3',0,ZHOOK_HANDLE)


KA(:, 5, 8, 3) = (/ &
 & 0.13913E-06_JPRB,0.13470E-03_JPRB,0.20711E-03_JPRB,0.25583E-03_JPRB,0.28735E-03_JPRB, &
 & 0.30171E-03_JPRB,0.29653E-03_JPRB,0.25931E-03_JPRB,0.53892E-04_JPRB /)  
KA(:, 1, 9, 3) = (/ &
 & 0.14950E-06_JPRB,0.81941E-04_JPRB,0.12473E-03_JPRB,0.15363E-03_JPRB,0.17257E-03_JPRB, &
 & 0.18409E-03_JPRB,0.18424E-03_JPRB,0.16439E-03_JPRB,0.30772E-04_JPRB /)  
KA(:, 2, 9, 3) = (/ &
 & 0.13998E-06_JPRB,0.89702E-04_JPRB,0.13655E-03_JPRB,0.16763E-03_JPRB,0.18779E-03_JPRB, &
 & 0.19919E-03_JPRB,0.19877E-03_JPRB,0.17581E-03_JPRB,0.34022E-04_JPRB /)  
KA(:, 3, 9, 3) = (/ &
 & 0.13160E-06_JPRB,0.97263E-04_JPRB,0.14776E-03_JPRB,0.18089E-03_JPRB,0.20292E-03_JPRB, &
 & 0.21451E-03_JPRB,0.21317E-03_JPRB,0.18640E-03_JPRB,0.37381E-04_JPRB /)  
KA(:, 4, 9, 3) = (/ &
 & 0.12415E-06_JPRB,0.10389E-03_JPRB,0.15817E-03_JPRB,0.19404E-03_JPRB,0.21794E-03_JPRB, &
 & 0.22980E-03_JPRB,0.22715E-03_JPRB,0.19784E-03_JPRB,0.40457E-04_JPRB /)  
KA(:, 5, 9, 3) = (/ &
 & 0.11749E-06_JPRB,0.10934E-03_JPRB,0.16768E-03_JPRB,0.20680E-03_JPRB,0.23234E-03_JPRB, &
 & 0.24414E-03_JPRB,0.24026E-03_JPRB,0.20959E-03_JPRB,0.43586E-04_JPRB /)  
KA(:, 1,10, 3) = (/ &
 & 0.12658E-06_JPRB,0.64763E-04_JPRB,0.98690E-04_JPRB,0.12170E-03_JPRB,0.13709E-03_JPRB, &
 & 0.14644E-03_JPRB,0.14709E-03_JPRB,0.13215E-03_JPRB,0.24737E-04_JPRB /)  
KA(:, 2,10, 3) = (/ &
 & 0.11826E-06_JPRB,0.71405E-04_JPRB,0.10875E-03_JPRB,0.13368E-03_JPRB,0.14978E-03_JPRB, &
 & 0.15901E-03_JPRB,0.15937E-03_JPRB,0.14153E-03_JPRB,0.27487E-04_JPRB /)  
KA(:, 3,10, 3) = (/ &
 & 0.11097E-06_JPRB,0.77857E-04_JPRB,0.11842E-03_JPRB,0.14510E-03_JPRB,0.16261E-03_JPRB, &
 & 0.17204E-03_JPRB,0.17129E-03_JPRB,0.15041E-03_JPRB,0.30250E-04_JPRB /)  
KA(:, 4,10, 3) = (/ &
 & 0.10451E-06_JPRB,0.83764E-04_JPRB,0.12762E-03_JPRB,0.15625E-03_JPRB,0.17544E-03_JPRB, &
 & 0.18516E-03_JPRB,0.18345E-03_JPRB,0.16010E-03_JPRB,0.32891E-04_JPRB /)  
KA(:, 5,10, 3) = (/ &
 & 0.98767E-07_JPRB,0.88833E-04_JPRB,0.13595E-03_JPRB,0.16723E-03_JPRB,0.18798E-03_JPRB, &
 & 0.19766E-03_JPRB,0.19477E-03_JPRB,0.16979E-03_JPRB,0.35547E-04_JPRB /)  
KA(:, 1,11, 3) = (/ &
 & 0.10368E-06_JPRB,0.53714E-04_JPRB,0.81748E-04_JPRB,0.10085E-03_JPRB,0.11349E-03_JPRB, &
 & 0.12126E-03_JPRB,0.12180E-03_JPRB,0.10950E-03_JPRB,0.20787E-04_JPRB /)  
KA(:, 2,11, 3) = (/ &
 & 0.96854E-07_JPRB,0.59175E-04_JPRB,0.90131E-04_JPRB,0.11085E-03_JPRB,0.12425E-03_JPRB, &
 & 0.13166E-03_JPRB,0.13207E-03_JPRB,0.11733E-03_JPRB,0.23028E-04_JPRB /)  
KA(:, 3,11, 3) = (/ &
 & 0.90882E-07_JPRB,0.64593E-04_JPRB,0.98275E-04_JPRB,0.12041E-03_JPRB,0.13497E-03_JPRB, &
 & 0.14273E-03_JPRB,0.14215E-03_JPRB,0.12479E-03_JPRB,0.25362E-04_JPRB /)  
KA(:, 4,11, 3) = (/ &
 & 0.85602E-07_JPRB,0.69545E-04_JPRB,0.10592E-03_JPRB,0.12982E-03_JPRB,0.14583E-03_JPRB, &
 & 0.15388E-03_JPRB,0.15228E-03_JPRB,0.13297E-03_JPRB,0.27585E-04_JPRB /)  
KA(:, 5,11, 3) = (/ &
 & 0.80889E-07_JPRB,0.73731E-04_JPRB,0.11290E-03_JPRB,0.13914E-03_JPRB,0.15637E-03_JPRB, &
 & 0.16431E-03_JPRB,0.16189E-03_JPRB,0.14116E-03_JPRB,0.29828E-04_JPRB /)  
KA(:, 1,12, 3) = (/ &
 & 0.84886E-07_JPRB,0.44418E-04_JPRB,0.67641E-04_JPRB,0.83490E-04_JPRB,0.93906E-04_JPRB, &
 & 0.10034E-03_JPRB,0.10075E-03_JPRB,0.90614E-04_JPRB,0.17350E-04_JPRB /)  
KA(:, 2,12, 3) = (/ &
 & 0.79297E-07_JPRB,0.48981E-04_JPRB,0.74656E-04_JPRB,0.91821E-04_JPRB,0.10299E-03_JPRB, &
 & 0.10891E-03_JPRB,0.10933E-03_JPRB,0.97221E-04_JPRB,0.19237E-04_JPRB /)  
KA(:, 3,12, 3) = (/ &
 & 0.74408E-07_JPRB,0.53553E-04_JPRB,0.81503E-04_JPRB,0.99872E-04_JPRB,0.11196E-03_JPRB, &
 & 0.11832E-03_JPRB,0.11782E-03_JPRB,0.10341E-03_JPRB,0.21189E-04_JPRB /)  
KA(:, 4,12, 3) = (/ &
 & 0.70085E-07_JPRB,0.57698E-04_JPRB,0.87887E-04_JPRB,0.10781E-03_JPRB,0.12107E-03_JPRB, &
 & 0.12775E-03_JPRB,0.12624E-03_JPRB,0.11034E-03_JPRB,0.23038E-04_JPRB /)  
KA(:, 5,12, 3) = (/ &
 & 0.66226E-07_JPRB,0.61177E-04_JPRB,0.93694E-04_JPRB,0.11567E-03_JPRB,0.12995E-03_JPRB, &
 & 0.13645E-03_JPRB,0.13436E-03_JPRB,0.11726E-03_JPRB,0.24913E-04_JPRB /)  
KA(:, 1,13, 3) = (/ &
 & 0.69499E-07_JPRB,0.36716E-04_JPRB,0.55902E-04_JPRB,0.69067E-04_JPRB,0.77635E-04_JPRB, &
 & 0.82934E-04_JPRB,0.83302E-04_JPRB,0.74905E-04_JPRB,0.14419E-04_JPRB /)  
KA(:, 2,13, 3) = (/ &
 & 0.64923E-07_JPRB,0.40511E-04_JPRB,0.61779E-04_JPRB,0.75984E-04_JPRB,0.85239E-04_JPRB, &
 & 0.90090E-04_JPRB,0.90456E-04_JPRB,0.80264E-04_JPRB,0.15996E-04_JPRB /)  
KA(:, 3,13, 3) = (/ &
 & 0.60920E-07_JPRB,0.44356E-04_JPRB,0.67533E-04_JPRB,0.82746E-04_JPRB,0.92816E-04_JPRB, &
 & 0.98017E-04_JPRB,0.97590E-04_JPRB,0.85621E-04_JPRB,0.17623E-04_JPRB /)  
KA(:, 4,13, 3) = (/ &
 & 0.57381E-07_JPRB,0.47826E-04_JPRB,0.72874E-04_JPRB,0.89443E-04_JPRB,0.10040E-03_JPRB, &
 & 0.10588E-03_JPRB,0.10456E-03_JPRB,0.91429E-04_JPRB,0.19144E-04_JPRB /)  
KA(:, 5,13, 3) = (/ &
 & 0.54221E-07_JPRB,0.50750E-04_JPRB,0.77698E-04_JPRB,0.96005E-04_JPRB,0.10784E-03_JPRB, &
 & 0.11318E-03_JPRB,0.11139E-03_JPRB,0.97258E-04_JPRB,0.20671E-04_JPRB /)  
KA(:, 1, 1, 4) = (/ &
 & 0.36654E-05_JPRB,0.13689E-02_JPRB,0.21108E-02_JPRB,0.26314E-02_JPRB,0.29458E-02_JPRB, &
 & 0.30831E-02_JPRB,0.30207E-02_JPRB,0.26003E-02_JPRB,0.93689E-03_JPRB /)  
KA(:, 2, 1, 4) = (/ &
 & 0.35304E-05_JPRB,0.14025E-02_JPRB,0.21716E-02_JPRB,0.27078E-02_JPRB,0.30551E-02_JPRB, &
 & 0.31948E-02_JPRB,0.31649E-02_JPRB,0.27258E-02_JPRB,0.97983E-03_JPRB /)  
KA(:, 3, 1, 4) = (/ &
 & 0.34059E-05_JPRB,0.14340E-02_JPRB,0.22214E-02_JPRB,0.27773E-02_JPRB,0.31348E-02_JPRB, &
 & 0.33049E-02_JPRB,0.32835E-02_JPRB,0.28461E-02_JPRB,0.10251E-02_JPRB /)  
KA(:, 4, 1, 4) = (/ &
 & 0.32895E-05_JPRB,0.14610E-02_JPRB,0.22596E-02_JPRB,0.28314E-02_JPRB,0.32113E-02_JPRB, &
 & 0.34131E-02_JPRB,0.33921E-02_JPRB,0.29508E-02_JPRB,0.10730E-02_JPRB /)  
KA(:, 5, 1, 4) = (/ &
 & 0.31814E-05_JPRB,0.14814E-02_JPRB,0.22905E-02_JPRB,0.28789E-02_JPRB,0.32785E-02_JPRB, &
 & 0.34996E-02_JPRB,0.34952E-02_JPRB,0.30528E-02_JPRB,0.11205E-02_JPRB /)  
KA(:, 1, 2, 4) = (/ &
 & 0.30293E-05_JPRB,0.11600E-02_JPRB,0.17946E-02_JPRB,0.22370E-02_JPRB,0.25205E-02_JPRB, &
 & 0.26432E-02_JPRB,0.26172E-02_JPRB,0.22691E-02_JPRB,0.78466E-03_JPRB /)  
KA(:, 2, 2, 4) = (/ &
 & 0.29173E-05_JPRB,0.11916E-02_JPRB,0.18468E-02_JPRB,0.23072E-02_JPRB,0.26094E-02_JPRB, &
 & 0.27477E-02_JPRB,0.27388E-02_JPRB,0.23809E-02_JPRB,0.82356E-03_JPRB /)  
KA(:, 3, 2, 4) = (/ &
 & 0.28152E-05_JPRB,0.12203E-02_JPRB,0.18939E-02_JPRB,0.23691E-02_JPRB,0.26814E-02_JPRB, &
 & 0.28506E-02_JPRB,0.28414E-02_JPRB,0.24825E-02_JPRB,0.86161E-03_JPRB /)  
KA(:, 4, 2, 4) = (/ &
 & 0.27207E-05_JPRB,0.12454E-02_JPRB,0.19291E-02_JPRB,0.24180E-02_JPRB,0.27489E-02_JPRB, &
 & 0.29380E-02_JPRB,0.29345E-02_JPRB,0.25808E-02_JPRB,0.90328E-03_JPRB /)  
KA(:, 5, 2, 4) = (/ &
 & 0.26316E-05_JPRB,0.12644E-02_JPRB,0.19586E-02_JPRB,0.24624E-02_JPRB,0.28146E-02_JPRB, &
 & 0.30125E-02_JPRB,0.30237E-02_JPRB,0.26695E-02_JPRB,0.94678E-03_JPRB /)  
KA(:, 1, 3, 4) = (/ &
 & 0.25288E-05_JPRB,0.97348E-03_JPRB,0.15070E-02_JPRB,0.18795E-02_JPRB,0.21206E-02_JPRB, &
 & 0.22362E-02_JPRB,0.22210E-02_JPRB,0.19369E-02_JPRB,0.64308E-03_JPRB /)  
KA(:, 2, 3, 4) = (/ &
 & 0.24353E-05_JPRB,0.10031E-02_JPRB,0.15552E-02_JPRB,0.19441E-02_JPRB,0.22013E-02_JPRB, &
 & 0.23257E-02_JPRB,0.23286E-02_JPRB,0.20362E-02_JPRB,0.67529E-03_JPRB /)  
KA(:, 3, 3, 4) = (/ &
 & 0.23495E-05_JPRB,0.10295E-02_JPRB,0.15986E-02_JPRB,0.20019E-02_JPRB,0.22663E-02_JPRB, &
 & 0.24160E-02_JPRB,0.24204E-02_JPRB,0.21276E-02_JPRB,0.70991E-03_JPRB /)  
KA(:, 4, 3, 4) = (/ &
 & 0.22699E-05_JPRB,0.10533E-02_JPRB,0.16337E-02_JPRB,0.20489E-02_JPRB,0.23288E-02_JPRB, &
 & 0.24911E-02_JPRB,0.25016E-02_JPRB,0.22148E-02_JPRB,0.74635E-03_JPRB /)  
KA(:, 5, 3, 4) = (/ &
 & 0.21951E-05_JPRB,0.10724E-02_JPRB,0.16625E-02_JPRB,0.20891E-02_JPRB,0.23896E-02_JPRB, &
 & 0.25582E-02_JPRB,0.25812E-02_JPRB,0.22925E-02_JPRB,0.78432E-03_JPRB /)  
KA(:, 1, 4, 4) = (/ &
 & 0.21169E-05_JPRB,0.81053E-03_JPRB,0.12568E-02_JPRB,0.15647E-02_JPRB,0.17654E-02_JPRB, &
 & 0.18662E-02_JPRB,0.18568E-02_JPRB,0.16269E-02_JPRB,0.52608E-03_JPRB /)  
KA(:, 2, 4, 4) = (/ &
 & 0.20407E-05_JPRB,0.83875E-03_JPRB,0.13019E-02_JPRB,0.16252E-02_JPRB,0.18383E-02_JPRB, &
 & 0.19441E-02_JPRB,0.19538E-02_JPRB,0.17139E-02_JPRB,0.55325E-03_JPRB /)  
KA(:, 3, 4, 4) = (/ &
 & 0.19674E-05_JPRB,0.86329E-03_JPRB,0.13417E-02_JPRB,0.16788E-02_JPRB,0.18985E-02_JPRB, &
 & 0.20246E-02_JPRB,0.20315E-02_JPRB,0.17978E-02_JPRB,0.58253E-03_JPRB /)  
KA(:, 4, 4, 4) = (/ &
 & 0.18994E-05_JPRB,0.88551E-03_JPRB,0.13753E-02_JPRB,0.17238E-02_JPRB,0.19566E-02_JPRB, &
 & 0.20923E-02_JPRB,0.21035E-02_JPRB,0.18724E-02_JPRB,0.61438E-03_JPRB /)  
KA(:, 5, 4, 4) = (/ &
 & 0.18358E-05_JPRB,0.90442E-03_JPRB,0.14042E-02_JPRB,0.17619E-02_JPRB,0.20119E-02_JPRB, &
 & 0.21542E-02_JPRB,0.21749E-02_JPRB,0.19425E-02_JPRB,0.64762E-03_JPRB /)  
KA(:, 1, 5, 4) = (/ &
 & 0.17725E-05_JPRB,0.67146E-03_JPRB,0.10396E-02_JPRB,0.12935E-02_JPRB,0.14576E-02_JPRB, &
 & 0.15437E-02_JPRB,0.15341E-02_JPRB,0.13532E-02_JPRB,0.42981E-03_JPRB /)  
KA(:, 2, 5, 4) = (/ &
 & 0.17095E-05_JPRB,0.69774E-03_JPRB,0.10823E-02_JPRB,0.13477E-02_JPRB,0.15227E-02_JPRB, &
 & 0.16117E-02_JPRB,0.16222E-02_JPRB,0.14302E-02_JPRB,0.45286E-03_JPRB /)  
KA(:, 3, 5, 4) = (/ &
 & 0.16478E-05_JPRB,0.72044E-03_JPRB,0.11190E-02_JPRB,0.13967E-02_JPRB,0.15783E-02_JPRB, &
 & 0.16817E-02_JPRB,0.16897E-02_JPRB,0.15040E-02_JPRB,0.47782E-03_JPRB /)  
KA(:, 4, 5, 4) = (/ &
 & 0.15896E-05_JPRB,0.74136E-03_JPRB,0.11512E-02_JPRB,0.14394E-02_JPRB,0.16307E-02_JPRB, &
 & 0.17435E-02_JPRB,0.17536E-02_JPRB,0.15687E-02_JPRB,0.50468E-03_JPRB /)  
KA(:, 5, 5, 4) = (/ &
 & 0.15353E-05_JPRB,0.75977E-03_JPRB,0.11790E-02_JPRB,0.14755E-02_JPRB,0.16811E-02_JPRB, &
 & 0.17990E-02_JPRB,0.18175E-02_JPRB,0.16279E-02_JPRB,0.53353E-03_JPRB /)  
KA(:, 1, 6, 4) = (/ &
 & 0.14856E-05_JPRB,0.55163E-03_JPRB,0.85182E-03_JPRB,0.10583E-02_JPRB,0.11933E-02_JPRB, &
 & 0.12633E-02_JPRB,0.12519E-02_JPRB,0.11126E-02_JPRB,0.34969E-03_JPRB /)  
KA(:, 2, 6, 4) = (/ &
 & 0.14323E-05_JPRB,0.57534E-03_JPRB,0.89211E-03_JPRB,0.11084E-02_JPRB,0.12510E-02_JPRB, &
 & 0.13248E-02_JPRB,0.13302E-02_JPRB,0.11815E-02_JPRB,0.36893E-03_JPRB /)  
KA(:, 3, 6, 4) = (/ &
 & 0.13818E-05_JPRB,0.59705E-03_JPRB,0.92552E-03_JPRB,0.11530E-02_JPRB,0.13018E-02_JPRB, &
 & 0.13860E-02_JPRB,0.13942E-02_JPRB,0.12437E-02_JPRB,0.38991E-03_JPRB /)  
KA(:, 4, 6, 4) = (/ &
 & 0.13317E-05_JPRB,0.61671E-03_JPRB,0.95568E-03_JPRB,0.11922E-02_JPRB,0.13481E-02_JPRB, &
 & 0.14426E-02_JPRB,0.14508E-02_JPRB,0.13001E-02_JPRB,0.41248E-03_JPRB /)  
KA(:, 5, 6, 4) = (/ &
 & 0.12851E-05_JPRB,0.63414E-03_JPRB,0.98227E-03_JPRB,0.12265E-02_JPRB,0.13936E-02_JPRB, &
 & 0.14913E-02_JPRB,0.15064E-02_JPRB,0.13512E-02_JPRB,0.43696E-03_JPRB /)  
KA(:, 1, 7, 4) = (/ &
 & 0.12453E-05_JPRB,0.44982E-03_JPRB,0.69286E-03_JPRB,0.85857E-03_JPRB,0.97115E-03_JPRB, &
 & 0.10268E-02_JPRB,0.10132E-02_JPRB,0.90661E-03_JPRB,0.28333E-03_JPRB /)  
KA(:, 2, 7, 4) = (/ &
 & 0.11997E-05_JPRB,0.47163E-03_JPRB,0.72984E-03_JPRB,0.90525E-03_JPRB,0.10209E-02_JPRB, &
 & 0.10830E-02_JPRB,0.10815E-02_JPRB,0.96820E-03_JPRB,0.29991E-03_JPRB /)  
KA(:, 3, 7, 4) = (/ &
 & 0.11571E-05_JPRB,0.49170E-03_JPRB,0.76064E-03_JPRB,0.94597E-03_JPRB,0.10683E-02_JPRB, &
 & 0.11337E-02_JPRB,0.11418E-02_JPRB,0.10210E-02_JPRB,0.31738E-03_JPRB /)  
KA(:, 4, 7, 4) = (/ &
 & 0.11157E-05_JPRB,0.50964E-03_JPRB,0.78859E-03_JPRB,0.98236E-03_JPRB,0.11088E-02_JPRB, &
 & 0.11859E-02_JPRB,0.11920E-02_JPRB,0.10690E-02_JPRB,0.33600E-03_JPRB /)  
KA(:, 5, 7, 4) = (/ &
 & 0.10757E-05_JPRB,0.52578E-03_JPRB,0.81330E-03_JPRB,0.10141E-02_JPRB,0.11493E-02_JPRB, &
 & 0.12285E-02_JPRB,0.12399E-02_JPRB,0.11151E-02_JPRB,0.35631E-03_JPRB /)  
KA(:, 1, 8, 4) = (/ &
 & 0.10436E-05_JPRB,0.36475E-03_JPRB,0.55948E-03_JPRB,0.69399E-03_JPRB,0.78699E-03_JPRB, &
 & 0.82733E-03_JPRB,0.81546E-03_JPRB,0.73443E-03_JPRB,0.22874E-03_JPRB /)  
KA(:, 2, 8, 4) = (/ &
 & 0.10043E-05_JPRB,0.38461E-03_JPRB,0.59365E-03_JPRB,0.73631E-03_JPRB,0.82902E-03_JPRB, &
 & 0.87996E-03_JPRB,0.87589E-03_JPRB,0.78745E-03_JPRB,0.24281E-03_JPRB /)  
KA(:, 3, 8, 4) = (/ &
 & 0.96785E-06_JPRB,0.40227E-03_JPRB,0.62191E-03_JPRB,0.77183E-03_JPRB,0.87067E-03_JPRB, &
 & 0.92338E-03_JPRB,0.93116E-03_JPRB,0.83334E-03_JPRB,0.25735E-03_JPRB /)  
KA(:, 4, 8, 4) = (/ &
 & 0.93367E-06_JPRB,0.41881E-03_JPRB,0.64697E-03_JPRB,0.80474E-03_JPRB,0.90754E-03_JPRB, &
 & 0.96806E-03_JPRB,0.97434E-03_JPRB,0.87439E-03_JPRB,0.27286E-03_JPRB /)  
KA(:, 5, 8, 4) = (/ &
 & 0.90017E-06_JPRB,0.43377E-03_JPRB,0.67026E-03_JPRB,0.83398E-03_JPRB,0.94269E-03_JPRB, &
 & 0.10080E-02_JPRB,0.10154E-02_JPRB,0.91479E-03_JPRB,0.28948E-03_JPRB /)  
KA(:, 1, 9, 4) = (/ &
 & 0.87469E-06_JPRB,0.29345E-03_JPRB,0.44857E-03_JPRB,0.55653E-03_JPRB,0.63371E-03_JPRB, &
 & 0.66253E-03_JPRB,0.65229E-03_JPRB,0.59009E-03_JPRB,0.18475E-03_JPRB /)  
KA(:, 2, 9, 4) = (/ &
 & 0.84062E-06_JPRB,0.31152E-03_JPRB,0.47975E-03_JPRB,0.59422E-03_JPRB,0.67077E-03_JPRB, &
 & 0.71168E-03_JPRB,0.70550E-03_JPRB,0.63674E-03_JPRB,0.19669E-03_JPRB /)  
KA(:, 3, 9, 4) = (/ &
 & 0.80947E-06_JPRB,0.32779E-03_JPRB,0.50582E-03_JPRB,0.62707E-03_JPRB,0.70705E-03_JPRB, &
 & 0.74936E-03_JPRB,0.75252E-03_JPRB,0.67682E-03_JPRB,0.20896E-03_JPRB /)  
KA(:, 4, 9, 4) = (/ &
 & 0.78052E-06_JPRB,0.34262E-03_JPRB,0.52820E-03_JPRB,0.65631E-03_JPRB,0.74002E-03_JPRB, &
 & 0.78731E-03_JPRB,0.79257E-03_JPRB,0.71155E-03_JPRB,0.22197E-03_JPRB /)  
KA(:, 5, 9, 4) = (/ &
 & 0.75300E-06_JPRB,0.35618E-03_JPRB,0.54940E-03_JPRB,0.68236E-03_JPRB,0.76978E-03_JPRB, &
 & 0.82271E-03_JPRB,0.82806E-03_JPRB,0.74658E-03_JPRB,0.23588E-03_JPRB /)  
KA(:, 1,10, 4) = (/ &
 & 0.73080E-06_JPRB,0.23619E-03_JPRB,0.36002E-03_JPRB,0.44769E-03_JPRB,0.51001E-03_JPRB, &
 & 0.53294E-03_JPRB,0.52319E-03_JPRB,0.47492E-03_JPRB,0.15005E-03_JPRB /)  
KA(:, 2,10, 4) = (/ &
 & 0.70142E-06_JPRB,0.25225E-03_JPRB,0.38742E-03_JPRB,0.48039E-03_JPRB,0.54285E-03_JPRB, &
 & 0.57407E-03_JPRB,0.56765E-03_JPRB,0.51444E-03_JPRB,0.16000E-03_JPRB /)  
KA(:, 3,10, 4) = (/ &
 & 0.67484E-06_JPRB,0.26687E-03_JPRB,0.41119E-03_JPRB,0.50924E-03_JPRB,0.57372E-03_JPRB, &
 & 0.60912E-03_JPRB,0.60813E-03_JPRB,0.54945E-03_JPRB,0.17036E-03_JPRB /)  
KA(:, 4,10, 4) = (/ &
 & 0.65032E-06_JPRB,0.28002E-03_JPRB,0.43104E-03_JPRB,0.53513E-03_JPRB,0.60294E-03_JPRB, &
 & 0.63998E-03_JPRB,0.64485E-03_JPRB,0.57888E-03_JPRB,0.18120E-03_JPRB /)  
KA(:, 5,10, 4) = (/ &
 & 0.62752E-06_JPRB,0.29182E-03_JPRB,0.44950E-03_JPRB,0.55836E-03_JPRB,0.62849E-03_JPRB, &
 & 0.67148E-03_JPRB,0.67570E-03_JPRB,0.60918E-03_JPRB,0.19271E-03_JPRB /)  
KA(:, 1,11, 4) = (/ &
 & 0.59846E-06_JPRB,0.19603E-03_JPRB,0.29902E-03_JPRB,0.37159E-03_JPRB,0.42367E-03_JPRB, &
 & 0.44241E-03_JPRB,0.43550E-03_JPRB,0.39618E-03_JPRB,0.12498E-03_JPRB /)  
KA(:, 2,11, 4) = (/ &
 & 0.57447E-06_JPRB,0.20953E-03_JPRB,0.32187E-03_JPRB,0.39882E-03_JPRB,0.45021E-03_JPRB, &
 & 0.47717E-03_JPRB,0.47240E-03_JPRB,0.42894E-03_JPRB,0.13362E-03_JPRB /)  
KA(:, 3,11, 4) = (/ &
 & 0.55265E-06_JPRB,0.22185E-03_JPRB,0.34133E-03_JPRB,0.42283E-03_JPRB,0.47616E-03_JPRB, &
 & 0.50481E-03_JPRB,0.50553E-03_JPRB,0.45654E-03_JPRB,0.14246E-03_JPRB /)  
KA(:, 4,11, 4) = (/ &
 & 0.53259E-06_JPRB,0.23301E-03_JPRB,0.35816E-03_JPRB,0.44448E-03_JPRB,0.50048E-03_JPRB, &
 & 0.53147E-03_JPRB,0.53574E-03_JPRB,0.48169E-03_JPRB,0.15168E-03_JPRB /)  
KA(:, 5,11, 4) = (/ &
 & 0.51379E-06_JPRB,0.24302E-03_JPRB,0.37383E-03_JPRB,0.46352E-03_JPRB,0.52203E-03_JPRB, &
 & 0.55783E-03_JPRB,0.56175E-03_JPRB,0.50737E-03_JPRB,0.16153E-03_JPRB /)  
KA(:, 1,12, 4) = (/ &
 & 0.49006E-06_JPRB,0.16259E-03_JPRB,0.24802E-03_JPRB,0.30804E-03_JPRB,0.35111E-03_JPRB, &
 & 0.36672E-03_JPRB,0.36166E-03_JPRB,0.32968E-03_JPRB,0.10401E-03_JPRB /)  
KA(:, 2,12, 4) = (/ &
 & 0.47033E-06_JPRB,0.17379E-03_JPRB,0.26697E-03_JPRB,0.33069E-03_JPRB,0.37292E-03_JPRB, &
 & 0.39587E-03_JPRB,0.39239E-03_JPRB,0.35672E-03_JPRB,0.11138E-03_JPRB /)  
KA(:, 3,12, 4) = (/ &
 & 0.45247E-06_JPRB,0.18417E-03_JPRB,0.28295E-03_JPRB,0.35045E-03_JPRB,0.39465E-03_JPRB, &
 & 0.41825E-03_JPRB,0.41984E-03_JPRB,0.37867E-03_JPRB,0.11882E-03_JPRB /)  
KA(:, 4,12, 4) = (/ &
 & 0.43605E-06_JPRB,0.19351E-03_JPRB,0.29716E-03_JPRB,0.36850E-03_JPRB,0.41489E-03_JPRB, &
 & 0.44074E-03_JPRB,0.44460E-03_JPRB,0.40031E-03_JPRB,0.12667E-03_JPRB /)  
KA(:, 5,12, 4) = (/ &
 & 0.42066E-06_JPRB,0.20206E-03_JPRB,0.31038E-03_JPRB,0.38464E-03_JPRB,0.43337E-03_JPRB, &
 & 0.46297E-03_JPRB,0.46667E-03_JPRB,0.42202E-03_JPRB,0.13498E-03_JPRB /)  
KA(:, 1,13, 4) = (/ &
 & 0.40122E-06_JPRB,0.13465E-03_JPRB,0.20541E-03_JPRB,0.25488E-03_JPRB,0.29006E-03_JPRB, &
 & 0.30358E-03_JPRB,0.29984E-03_JPRB,0.27375E-03_JPRB,0.86406E-04_JPRB /)  
KA(:, 2,13, 4) = (/ &
 & 0.38502E-06_JPRB,0.14398E-03_JPRB,0.22086E-03_JPRB,0.27376E-03_JPRB,0.30832E-03_JPRB, &
 & 0.32794E-03_JPRB,0.32517E-03_JPRB,0.29562E-03_JPRB,0.92614E-04_JPRB /)  
KA(:, 3,13, 4) = (/ &
 & 0.37045E-06_JPRB,0.15266E-03_JPRB,0.23416E-03_JPRB,0.29013E-03_JPRB,0.32675E-03_JPRB, &
 & 0.34622E-03_JPRB,0.34816E-03_JPRB,0.31401E-03_JPRB,0.98880E-04_JPRB /)  
KA(:, 4,13, 4) = (/ &
 & 0.35702E-06_JPRB,0.16050E-03_JPRB,0.24608E-03_JPRB,0.30521E-03_JPRB,0.34336E-03_JPRB, &
 & 0.36522E-03_JPRB,0.36857E-03_JPRB,0.33246E-03_JPRB,0.10559E-03_JPRB /)  
KA(:, 5,13, 4) = (/ &
 & 0.34440E-06_JPRB,0.16771E-03_JPRB,0.25742E-03_JPRB,0.31904E-03_JPRB,0.35943E-03_JPRB, &
 & 0.38405E-03_JPRB,0.38715E-03_JPRB,0.35087E-03_JPRB,0.11262E-03_JPRB /)  
KA(:, 1, 1, 5) = (/ &
 & 0.15583E-03_JPRB,0.37546E-02_JPRB,0.53536E-02_JPRB,0.64161E-02_JPRB,0.71223E-02_JPRB, &
 & 0.74982E-02_JPRB,0.73596E-02_JPRB,0.65135E-02_JPRB,0.35175E-02_JPRB /)  
KA(:, 2, 1, 5) = (/ &
 & 0.16148E-03_JPRB,0.38569E-02_JPRB,0.55256E-02_JPRB,0.66461E-02_JPRB,0.73757E-02_JPRB, &
 & 0.77530E-02_JPRB,0.75665E-02_JPRB,0.66496E-02_JPRB,0.36840E-02_JPRB /)  
KA(:, 3, 1, 5) = (/ &
 & 0.16484E-03_JPRB,0.39353E-02_JPRB,0.56745E-02_JPRB,0.68364E-02_JPRB,0.76166E-02_JPRB, &
 & 0.79711E-02_JPRB,0.77717E-02_JPRB,0.67846E-02_JPRB,0.38485E-02_JPRB /)  
KA(:, 4, 1, 5) = (/ &
 & 0.16621E-03_JPRB,0.39946E-02_JPRB,0.57947E-02_JPRB,0.70071E-02_JPRB,0.78193E-02_JPRB, &
 & 0.81581E-02_JPRB,0.79592E-02_JPRB,0.69132E-02_JPRB,0.39769E-02_JPRB /)  
KA(:, 5, 1, 5) = (/ &
 & 0.16518E-03_JPRB,0.40386E-02_JPRB,0.58925E-02_JPRB,0.71530E-02_JPRB,0.79946E-02_JPRB, &
 & 0.83258E-02_JPRB,0.81107E-02_JPRB,0.70226E-02_JPRB,0.41134E-02_JPRB /)  
KA(:, 1, 2, 5) = (/ &
 & 0.12482E-03_JPRB,0.32204E-02_JPRB,0.46102E-02_JPRB,0.55475E-02_JPRB,0.61730E-02_JPRB, &
 & 0.65000E-02_JPRB,0.63942E-02_JPRB,0.56394E-02_JPRB,0.30002E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART3',1,ZHOOK_HANDLE)
END SUBROUTINE PART3


SUBROUTINE PART4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART4',0,ZHOOK_HANDLE)


KA(:, 2, 2, 5) = (/ &
 & 0.13027E-03_JPRB,0.33099E-02_JPRB,0.47617E-02_JPRB,0.57497E-02_JPRB,0.64031E-02_JPRB, &
 & 0.67184E-02_JPRB,0.65829E-02_JPRB,0.57721E-02_JPRB,0.31442E-02_JPRB /)  
KA(:, 3, 2, 5) = (/ &
 & 0.13370E-03_JPRB,0.33808E-02_JPRB,0.48845E-02_JPRB,0.59235E-02_JPRB,0.66074E-02_JPRB, &
 & 0.69048E-02_JPRB,0.67660E-02_JPRB,0.59018E-02_JPRB,0.32788E-02_JPRB /)  
KA(:, 4, 2, 5) = (/ &
 & 0.13549E-03_JPRB,0.34340E-02_JPRB,0.49885E-02_JPRB,0.60745E-02_JPRB,0.67877E-02_JPRB, &
 & 0.70780E-02_JPRB,0.69202E-02_JPRB,0.60131E-02_JPRB,0.33946E-02_JPRB /)  
KA(:, 5, 2, 5) = (/ &
 & 0.13543E-03_JPRB,0.34778E-02_JPRB,0.50745E-02_JPRB,0.61981E-02_JPRB,0.69282E-02_JPRB, &
 & 0.72229E-02_JPRB,0.70521E-02_JPRB,0.61218E-02_JPRB,0.35097E-02_JPRB /)  
KA(:, 1, 3, 5) = (/ &
 & 0.98437E-04_JPRB,0.27209E-02_JPRB,0.39035E-02_JPRB,0.47185E-02_JPRB,0.52706E-02_JPRB, &
 & 0.55579E-02_JPRB,0.54846E-02_JPRB,0.48469E-02_JPRB,0.25077E-02_JPRB /)  
KA(:, 2, 3, 5) = (/ &
 & 0.10396E-03_JPRB,0.28031E-02_JPRB,0.40384E-02_JPRB,0.48993E-02_JPRB,0.54753E-02_JPRB, &
 & 0.57575E-02_JPRB,0.56525E-02_JPRB,0.49684E-02_JPRB,0.26366E-02_JPRB /)  
KA(:, 3, 3, 5) = (/ &
 & 0.10770E-03_JPRB,0.28702E-02_JPRB,0.41513E-02_JPRB,0.50504E-02_JPRB,0.56640E-02_JPRB, &
 & 0.59245E-02_JPRB,0.58125E-02_JPRB,0.50922E-02_JPRB,0.27478E-02_JPRB /)  
KA(:, 4, 3, 5) = (/ &
 & 0.10996E-03_JPRB,0.29232E-02_JPRB,0.42451E-02_JPRB,0.51838E-02_JPRB,0.58257E-02_JPRB, &
 & 0.60793E-02_JPRB,0.59498E-02_JPRB,0.51949E-02_JPRB,0.28490E-02_JPRB /)  
KA(:, 5, 3, 5) = (/ &
 & 0.11088E-03_JPRB,0.29645E-02_JPRB,0.43251E-02_JPRB,0.52992E-02_JPRB,0.59468E-02_JPRB, &
 & 0.62096E-02_JPRB,0.60648E-02_JPRB,0.52904E-02_JPRB,0.29495E-02_JPRB /)  
KA(:, 1, 4, 5) = (/ &
 & 0.76587E-04_JPRB,0.22792E-02_JPRB,0.32731E-02_JPRB,0.39724E-02_JPRB,0.44561E-02_JPRB, &
 & 0.47109E-02_JPRB,0.46706E-02_JPRB,0.41444E-02_JPRB,0.20810E-02_JPRB /)  
KA(:, 2, 4, 5) = (/ &
 & 0.82225E-04_JPRB,0.23548E-02_JPRB,0.33943E-02_JPRB,0.41325E-02_JPRB,0.46415E-02_JPRB, &
 & 0.48939E-02_JPRB,0.48200E-02_JPRB,0.42591E-02_JPRB,0.21925E-02_JPRB /)  
KA(:, 3, 4, 5) = (/ &
 & 0.86203E-04_JPRB,0.24180E-02_JPRB,0.34991E-02_JPRB,0.42684E-02_JPRB,0.48074E-02_JPRB, &
 & 0.50416E-02_JPRB,0.49651E-02_JPRB,0.43643E-02_JPRB,0.22938E-02_JPRB /)  
KA(:, 4, 4, 5) = (/ &
 & 0.88766E-04_JPRB,0.24694E-02_JPRB,0.35874E-02_JPRB,0.43875E-02_JPRB,0.49469E-02_JPRB, &
 & 0.51810E-02_JPRB,0.50850E-02_JPRB,0.44606E-02_JPRB,0.23791E-02_JPRB /)  
KA(:, 5, 4, 5) = (/ &
 & 0.90218E-04_JPRB,0.25110E-02_JPRB,0.36613E-02_JPRB,0.44937E-02_JPRB,0.50548E-02_JPRB, &
 & 0.52982E-02_JPRB,0.51883E-02_JPRB,0.45498E-02_JPRB,0.24658E-02_JPRB /)  
KA(:, 1, 5, 5) = (/ &
 & 0.59080E-04_JPRB,0.18972E-02_JPRB,0.27294E-02_JPRB,0.33195E-02_JPRB,0.37395E-02_JPRB, &
 & 0.39683E-02_JPRB,0.39523E-02_JPRB,0.35161E-02_JPRB,0.17195E-02_JPRB /)  
KA(:, 2, 5, 5) = (/ &
 & 0.64508E-04_JPRB,0.19673E-02_JPRB,0.28376E-02_JPRB,0.34632E-02_JPRB,0.39033E-02_JPRB, &
 & 0.41343E-02_JPRB,0.40826E-02_JPRB,0.36195E-02_JPRB,0.18173E-02_JPRB /)  
KA(:, 3, 5, 5) = (/ &
 & 0.68538E-04_JPRB,0.20264E-02_JPRB,0.29342E-02_JPRB,0.35856E-02_JPRB,0.40488E-02_JPRB, &
 & 0.42664E-02_JPRB,0.42141E-02_JPRB,0.37144E-02_JPRB,0.19081E-02_JPRB /)  
KA(:, 4, 5, 5) = (/ &
 & 0.71328E-04_JPRB,0.20750E-02_JPRB,0.30165E-02_JPRB,0.36933E-02_JPRB,0.41719E-02_JPRB, &
 & 0.43880E-02_JPRB,0.43221E-02_JPRB,0.38006E-02_JPRB,0.19818E-02_JPRB /)  
KA(:, 5, 5, 5) = (/ &
 & 0.73073E-04_JPRB,0.21155E-02_JPRB,0.30861E-02_JPRB,0.37892E-02_JPRB,0.42690E-02_JPRB, &
 & 0.44901E-02_JPRB,0.44161E-02_JPRB,0.38864E-02_JPRB,0.20583E-02_JPRB /)  
KA(:, 1, 6, 5) = (/ &
 & 0.45069E-04_JPRB,0.15673E-02_JPRB,0.22596E-02_JPRB,0.27566E-02_JPRB,0.31117E-02_JPRB, &
 & 0.33162E-02_JPRB,0.33135E-02_JPRB,0.29574E-02_JPRB,0.14089E-02_JPRB /)  
KA(:, 2, 6, 5) = (/ &
 & 0.49959E-04_JPRB,0.16342E-02_JPRB,0.23577E-02_JPRB,0.28828E-02_JPRB,0.32572E-02_JPRB, &
 & 0.34626E-02_JPRB,0.34302E-02_JPRB,0.30476E-02_JPRB,0.14955E-02_JPRB /)  
KA(:, 3, 6, 5) = (/ &
 & 0.54013E-04_JPRB,0.16891E-02_JPRB,0.24457E-02_JPRB,0.29926E-02_JPRB,0.33865E-02_JPRB, &
 & 0.35809E-02_JPRB,0.35427E-02_JPRB,0.31358E-02_JPRB,0.15763E-02_JPRB /)  
KA(:, 4, 6, 5) = (/ &
 & 0.56910E-04_JPRB,0.17356E-02_JPRB,0.25220E-02_JPRB,0.30903E-02_JPRB,0.34968E-02_JPRB, &
 & 0.36853E-02_JPRB,0.36443E-02_JPRB,0.32140E-02_JPRB,0.16428E-02_JPRB /)  
KA(:, 5, 6, 5) = (/ &
 & 0.58852E-04_JPRB,0.17743E-02_JPRB,0.25868E-02_JPRB,0.31771E-02_JPRB,0.35857E-02_JPRB, &
 & 0.37782E-02_JPRB,0.37284E-02_JPRB,0.32905E-02_JPRB,0.17079E-02_JPRB /)  
KA(:, 1, 7, 5) = (/ &
 & 0.34131E-04_JPRB,0.12873E-02_JPRB,0.18619E-02_JPRB,0.22745E-02_JPRB,0.25688E-02_JPRB, &
 & 0.27494E-02_JPRB,0.27574E-02_JPRB,0.24658E-02_JPRB,0.11444E-02_JPRB /)  
KA(:, 2, 7, 5) = (/ &
 & 0.38379E-04_JPRB,0.13503E-02_JPRB,0.19490E-02_JPRB,0.23869E-02_JPRB,0.26985E-02_JPRB, &
 & 0.28761E-02_JPRB,0.28607E-02_JPRB,0.25443E-02_JPRB,0.12242E-02_JPRB /)  
KA(:, 3, 7, 5) = (/ &
 & 0.42146E-04_JPRB,0.14018E-02_JPRB,0.20287E-02_JPRB,0.24843E-02_JPRB,0.28119E-02_JPRB, &
 & 0.29848E-02_JPRB,0.29569E-02_JPRB,0.26258E-02_JPRB,0.12956E-02_JPRB /)  
KA(:, 4, 7, 5) = (/ &
 & 0.45116E-04_JPRB,0.14454E-02_JPRB,0.20989E-02_JPRB,0.25718E-02_JPRB,0.29115E-02_JPRB, &
 & 0.30740E-02_JPRB,0.30482E-02_JPRB,0.26967E-02_JPRB,0.13537E-02_JPRB /)  
KA(:, 5, 7, 5) = (/ &
 & 0.47178E-04_JPRB,0.14818E-02_JPRB,0.21591E-02_JPRB,0.26509E-02_JPRB,0.29945E-02_JPRB, &
 & 0.31590E-02_JPRB,0.31235E-02_JPRB,0.27641E-02_JPRB,0.14100E-02_JPRB /)  
KA(:, 1, 8, 5) = (/ &
 & 0.25656E-04_JPRB,0.10525E-02_JPRB,0.15266E-02_JPRB,0.18648E-02_JPRB,0.21060E-02_JPRB, &
 & 0.22660E-02_JPRB,0.22807E-02_JPRB,0.20415E-02_JPRB,0.92482E-03_JPRB /)  
KA(:, 2, 8, 5) = (/ &
 & 0.29313E-04_JPRB,0.11096E-02_JPRB,0.16027E-02_JPRB,0.19628E-02_JPRB,0.22224E-02_JPRB, &
 & 0.23730E-02_JPRB,0.23683E-02_JPRB,0.21111E-02_JPRB,0.99366E-03_JPRB /)  
KA(:, 3, 8, 5) = (/ &
 & 0.32643E-04_JPRB,0.11579E-02_JPRB,0.16732E-02_JPRB,0.20503E-02_JPRB,0.23231E-02_JPRB, &
 & 0.24721E-02_JPRB,0.24512E-02_JPRB,0.21842E-02_JPRB,0.10570E-02_JPRB /)  
KA(:, 4, 8, 5) = (/ &
 & 0.35509E-04_JPRB,0.11985E-02_JPRB,0.17379E-02_JPRB,0.21284E-02_JPRB,0.24110E-02_JPRB, &
 & 0.25519E-02_JPRB,0.25339E-02_JPRB,0.22496E-02_JPRB,0.11116E-02_JPRB /)  
KA(:, 5, 8, 5) = (/ &
 & 0.37616E-04_JPRB,0.12327E-02_JPRB,0.17933E-02_JPRB,0.21996E-02_JPRB,0.24880E-02_JPRB, &
 & 0.26258E-02_JPRB,0.26029E-02_JPRB,0.23088E-02_JPRB,0.11595E-02_JPRB /)  
KA(:, 1, 9, 5) = (/ &
 & 0.19166E-04_JPRB,0.85559E-03_JPRB,0.12446E-02_JPRB,0.15213E-02_JPRB,0.17160E-02_JPRB, &
 & 0.18527E-02_JPRB,0.18723E-02_JPRB,0.16794E-02_JPRB,0.74316E-03_JPRB /)  
KA(:, 2, 9, 5) = (/ &
 & 0.22251E-04_JPRB,0.90701E-03_JPRB,0.13107E-02_JPRB,0.16061E-02_JPRB,0.18177E-02_JPRB, &
 & 0.19452E-02_JPRB,0.19496E-02_JPRB,0.17420E-02_JPRB,0.80168E-03_JPRB /)  
KA(:, 3, 9, 5) = (/ &
 & 0.25123E-04_JPRB,0.95106E-03_JPRB,0.13724E-02_JPRB,0.16826E-02_JPRB,0.19064E-02_JPRB, &
 & 0.20352E-02_JPRB,0.20241E-02_JPRB,0.18064E-02_JPRB,0.85659E-03_JPRB /)  
KA(:, 4, 9, 5) = (/ &
 & 0.27713E-04_JPRB,0.98903E-03_JPRB,0.14301E-02_JPRB,0.17523E-02_JPRB,0.19862E-02_JPRB, &
 & 0.21079E-02_JPRB,0.20944E-02_JPRB,0.18656E-02_JPRB,0.90655E-03_JPRB /)  
KA(:, 5, 9, 5) = (/ &
 & 0.29821E-04_JPRB,0.10207E-02_JPRB,0.14813E-02_JPRB,0.18163E-02_JPRB,0.20570E-02_JPRB, &
 & 0.21737E-02_JPRB,0.21574E-02_JPRB,0.19153E-02_JPRB,0.94882E-03_JPRB /)  
KA(:, 1,10, 5) = (/ &
 & 0.14455E-04_JPRB,0.69508E-03_JPRB,0.10143E-02_JPRB,0.12382E-02_JPRB,0.13977E-02_JPRB, &
 & 0.15101E-02_JPRB,0.15339E-02_JPRB,0.13794E-02_JPRB,0.60064E-03_JPRB /)  
KA(:, 2,10, 5) = (/ &
 & 0.16975E-04_JPRB,0.74055E-03_JPRB,0.10715E-02_JPRB,0.13117E-02_JPRB,0.14851E-02_JPRB, &
 & 0.15938E-02_JPRB,0.16026E-02_JPRB,0.14354E-02_JPRB,0.65034E-03_JPRB /)  
KA(:, 3,10, 5) = (/ &
 & 0.19421E-04_JPRB,0.77996E-03_JPRB,0.11243E-02_JPRB,0.13791E-02_JPRB,0.15636E-02_JPRB, &
 & 0.16707E-02_JPRB,0.16678E-02_JPRB,0.14908E-02_JPRB,0.69875E-03_JPRB /)  
KA(:, 4,10, 5) = (/ &
 & 0.21659E-04_JPRB,0.81369E-03_JPRB,0.11746E-02_JPRB,0.14408E-02_JPRB,0.16340E-02_JPRB, &
 & 0.17376E-02_JPRB,0.17267E-02_JPRB,0.15418E-02_JPRB,0.74336E-03_JPRB /)  
KA(:, 5,10, 5) = (/ &
 & 0.23616E-04_JPRB,0.84316E-03_JPRB,0.12215E-02_JPRB,0.14972E-02_JPRB,0.16971E-02_JPRB, &
 & 0.17945E-02_JPRB,0.17834E-02_JPRB,0.15844E-02_JPRB,0.78045E-03_JPRB /)  
KA(:, 1,11, 5) = (/ &
 & 0.11812E-04_JPRB,0.58067E-03_JPRB,0.84658E-03_JPRB,0.10349E-02_JPRB,0.11681E-02_JPRB, &
 & 0.12622E-02_JPRB,0.12806E-02_JPRB,0.11518E-02_JPRB,0.50197E-03_JPRB /)  
KA(:, 2,11, 5) = (/ &
 & 0.13870E-04_JPRB,0.61870E-03_JPRB,0.89364E-03_JPRB,0.10957E-02_JPRB,0.12411E-02_JPRB, &
 & 0.13307E-02_JPRB,0.13366E-02_JPRB,0.11990E-02_JPRB,0.54419E-03_JPRB /)  
KA(:, 3,11, 5) = (/ &
 & 0.15872E-04_JPRB,0.65131E-03_JPRB,0.93843E-03_JPRB,0.11520E-02_JPRB,0.13068E-02_JPRB, &
 & 0.13966E-02_JPRB,0.13927E-02_JPRB,0.12459E-02_JPRB,0.58412E-03_JPRB /)  
KA(:, 4,11, 5) = (/ &
 & 0.17706E-04_JPRB,0.67957E-03_JPRB,0.98128E-03_JPRB,0.12037E-02_JPRB,0.13653E-02_JPRB, &
 & 0.14510E-02_JPRB,0.14423E-02_JPRB,0.12873E-02_JPRB,0.62086E-03_JPRB /)  
KA(:, 5,11, 5) = (/ &
 & 0.19307E-04_JPRB,0.70477E-03_JPRB,0.10208E-02_JPRB,0.12522E-02_JPRB,0.14187E-02_JPRB, &
 & 0.15000E-02_JPRB,0.14882E-02_JPRB,0.13223E-02_JPRB,0.65273E-03_JPRB /)  
KA(:, 1,12, 5) = (/ &
 & 0.96633E-05_JPRB,0.48384E-03_JPRB,0.70464E-03_JPRB,0.86214E-03_JPRB,0.97325E-03_JPRB, &
 & 0.10525E-02_JPRB,0.10661E-02_JPRB,0.95818E-03_JPRB,0.41838E-03_JPRB /)  
KA(:, 2,12, 5) = (/ &
 & 0.11346E-04_JPRB,0.51544E-03_JPRB,0.74375E-03_JPRB,0.91255E-03_JPRB,0.10346E-02_JPRB, &
 & 0.11088E-02_JPRB,0.11124E-02_JPRB,0.99787E-03_JPRB,0.45436E-03_JPRB /)  
KA(:, 3,12, 5) = (/ &
 & 0.12983E-04_JPRB,0.54258E-03_JPRB,0.78191E-03_JPRB,0.95994E-03_JPRB,0.10893E-02_JPRB, &
 & 0.11636E-02_JPRB,0.11595E-02_JPRB,0.10379E-02_JPRB,0.48767E-03_JPRB /)  
KA(:, 4,12, 5) = (/ &
 & 0.14483E-04_JPRB,0.56662E-03_JPRB,0.81795E-03_JPRB,0.10036E-02_JPRB,0.11385E-02_JPRB, &
 & 0.12091E-02_JPRB,0.12012E-02_JPRB,0.10707E-02_JPRB,0.51810E-03_JPRB /)  
KA(:, 5,12, 5) = (/ &
 & 0.15790E-04_JPRB,0.58805E-03_JPRB,0.85165E-03_JPRB,0.10447E-02_JPRB,0.11830E-02_JPRB, &
 & 0.12500E-02_JPRB,0.12389E-02_JPRB,0.11012E-02_JPRB,0.54508E-03_JPRB /)  
KA(:, 1,13, 5) = (/ &
 & 0.79057E-05_JPRB,0.40215E-03_JPRB,0.58516E-03_JPRB,0.71666E-03_JPRB,0.80969E-03_JPRB, &
 & 0.87518E-03_JPRB,0.88581E-03_JPRB,0.79569E-03_JPRB,0.34825E-03_JPRB /)  
KA(:, 2,13, 5) = (/ &
 & 0.92808E-05_JPRB,0.42853E-03_JPRB,0.61818E-03_JPRB,0.75847E-03_JPRB,0.86082E-03_JPRB, &
 & 0.92160E-03_JPRB,0.92436E-03_JPRB,0.82894E-03_JPRB,0.37871E-03_JPRB /)  
KA(:, 3,13, 5) = (/ &
 & 0.10621E-04_JPRB,0.45134E-03_JPRB,0.65028E-03_JPRB,0.79815E-03_JPRB,0.90622E-03_JPRB, &
 & 0.96752E-03_JPRB,0.96291E-03_JPRB,0.86177E-03_JPRB,0.40642E-03_JPRB /)  
KA(:, 4,13, 5) = (/ &
 & 0.11849E-04_JPRB,0.47161E-03_JPRB,0.68090E-03_JPRB,0.83530E-03_JPRB,0.94770E-03_JPRB, &
 & 0.10054E-02_JPRB,0.99815E-03_JPRB,0.88908E-03_JPRB,0.43149E-03_JPRB /)  
KA(:, 5,13, 5) = (/ &
 & 0.12897E-04_JPRB,0.49000E-03_JPRB,0.70944E-03_JPRB,0.86982E-03_JPRB,0.98430E-03_JPRB, &
 & 0.10398E-02_JPRB,0.10297E-02_JPRB,0.91483E-03_JPRB,0.45459E-03_JPRB /)  
KA(:, 1, 1, 6) = (/ &
 & 0.23575E-02_JPRB,0.96457E-02_JPRB,0.13128E-01_JPRB,0.15361E-01_JPRB,0.16662E-01_JPRB, &
 & 0.16999E-01_JPRB,0.16303E-01_JPRB,0.14368E-01_JPRB,0.10185E-01_JPRB /)  
KA(:, 2, 1, 6) = (/ &
 & 0.24508E-02_JPRB,0.99768E-02_JPRB,0.13562E-01_JPRB,0.15786E-01_JPRB,0.17046E-01_JPRB, &
 & 0.17316E-01_JPRB,0.16539E-01_JPRB,0.14627E-01_JPRB,0.10447E-01_JPRB /)  
KA(:, 3, 1, 6) = (/ &
 & 0.25176E-02_JPRB,0.10262E-01_JPRB,0.13947E-01_JPRB,0.16182E-01_JPRB,0.17390E-01_JPRB, &
 & 0.17588E-01_JPRB,0.16752E-01_JPRB,0.14857E-01_JPRB,0.10699E-01_JPRB /)  
KA(:, 4, 1, 6) = (/ &
 & 0.25627E-02_JPRB,0.10510E-01_JPRB,0.14271E-01_JPRB,0.16517E-01_JPRB,0.17678E-01_JPRB, &
 & 0.17815E-01_JPRB,0.16941E-01_JPRB,0.15073E-01_JPRB,0.10970E-01_JPRB /)  
KA(:, 5, 1, 6) = (/ &
 & 0.25904E-02_JPRB,0.10712E-01_JPRB,0.14528E-01_JPRB,0.16788E-01_JPRB,0.17912E-01_JPRB, &
 & 0.18013E-01_JPRB,0.17126E-01_JPRB,0.15282E-01_JPRB,0.11215E-01_JPRB /)  
KA(:, 1, 2, 6) = (/ &
 & 0.19422E-02_JPRB,0.85179E-02_JPRB,0.11603E-01_JPRB,0.13561E-01_JPRB,0.14694E-01_JPRB, &
 & 0.14952E-01_JPRB,0.14274E-01_JPRB,0.12616E-01_JPRB,0.86910E-02_JPRB /)  
KA(:, 2, 2, 6) = (/ &
 & 0.20231E-02_JPRB,0.88208E-02_JPRB,0.11992E-01_JPRB,0.13942E-01_JPRB,0.15043E-01_JPRB, &
 & 0.15241E-01_JPRB,0.14503E-01_JPRB,0.12849E-01_JPRB,0.89203E-02_JPRB /)  
KA(:, 3, 2, 6) = (/ &
 & 0.20824E-02_JPRB,0.90892E-02_JPRB,0.12333E-01_JPRB,0.14283E-01_JPRB,0.15343E-01_JPRB, &
 & 0.15493E-01_JPRB,0.14704E-01_JPRB,0.13065E-01_JPRB,0.91412E-02_JPRB /)  
KA(:, 4, 2, 6) = (/ &
 & 0.21235E-02_JPRB,0.93193E-02_JPRB,0.12613E-01_JPRB,0.14573E-01_JPRB,0.15586E-01_JPRB, &
 & 0.15696E-01_JPRB,0.14900E-01_JPRB,0.13269E-01_JPRB,0.93731E-02_JPRB /)  
KA(:, 5, 2, 6) = (/ &
 & 0.21501E-02_JPRB,0.95064E-02_JPRB,0.12844E-01_JPRB,0.14802E-01_JPRB,0.15789E-01_JPRB, &
 & 0.15872E-01_JPRB,0.15079E-01_JPRB,0.13459E-01_JPRB,0.95922E-02_JPRB /)  
KA(:, 1, 3, 6) = (/ &
 & 0.15710E-02_JPRB,0.73739E-02_JPRB,0.10084E-01_JPRB,0.11795E-01_JPRB,0.12791E-01_JPRB, &
 & 0.13002E-01_JPRB,0.12408E-01_JPRB,0.10948E-01_JPRB,0.73256E-02_JPRB /)  
KA(:, 2, 3, 6) = (/ &
 & 0.16445E-02_JPRB,0.76603E-02_JPRB,0.10441E-01_JPRB,0.12136E-01_JPRB,0.13098E-01_JPRB, &
 & 0.13272E-01_JPRB,0.12629E-01_JPRB,0.11169E-01_JPRB,0.75277E-02_JPRB /)  
KA(:, 3, 3, 6) = (/ &
 & 0.17016E-02_JPRB,0.79120E-02_JPRB,0.10738E-01_JPRB,0.12444E-01_JPRB,0.13365E-01_JPRB, &
 & 0.13502E-01_JPRB,0.12827E-01_JPRB,0.11365E-01_JPRB,0.77275E-02_JPRB /)  
KA(:, 4, 3, 6) = (/ &
 & 0.17419E-02_JPRB,0.81204E-02_JPRB,0.10992E-01_JPRB,0.12704E-01_JPRB,0.13579E-01_JPRB, &
 & 0.13687E-01_JPRB,0.13022E-01_JPRB,0.11565E-01_JPRB,0.79327E-02_JPRB /)  
KA(:, 5, 3, 6) = (/ &
 & 0.17693E-02_JPRB,0.82896E-02_JPRB,0.11201E-01_JPRB,0.12903E-01_JPRB,0.13761E-01_JPRB, &
 & 0.13854E-01_JPRB,0.13193E-01_JPRB,0.11760E-01_JPRB,0.81324E-02_JPRB /)  
KA(:, 1, 4, 6) = (/ &
 & 0.12568E-02_JPRB,0.62925E-02_JPRB,0.86570E-02_JPRB,0.10156E-01_JPRB,0.11020E-01_JPRB, &
 & 0.11220E-01_JPRB,0.10710E-01_JPRB,0.94329E-02_JPRB,0.61812E-02_JPRB /)  
KA(:, 2, 4, 6) = (/ &
 & 0.13242E-02_JPRB,0.65532E-02_JPRB,0.89756E-02_JPRB,0.10460E-01_JPRB,0.11292E-01_JPRB, &
 & 0.11463E-01_JPRB,0.10924E-01_JPRB,0.96449E-02_JPRB,0.63620E-02_JPRB /)  
KA(:, 3, 4, 6) = (/ &
 & 0.13782E-02_JPRB,0.67807E-02_JPRB,0.92447E-02_JPRB,0.10739E-01_JPRB,0.11531E-01_JPRB, &
 & 0.11676E-01_JPRB,0.11115E-01_JPRB,0.98384E-02_JPRB,0.65417E-02_JPRB /)  
KA(:, 4, 4, 6) = (/ &
 & 0.14185E-02_JPRB,0.69728E-02_JPRB,0.94724E-02_JPRB,0.10967E-01_JPRB,0.11732E-01_JPRB, &
 & 0.11853E-01_JPRB,0.11299E-01_JPRB,0.10029E-01_JPRB,0.67314E-02_JPRB /)  
KA(:, 5, 4, 6) = (/ &
 & 0.14466E-02_JPRB,0.71294E-02_JPRB,0.96551E-02_JPRB,0.11150E-01_JPRB,0.11897E-01_JPRB, &
 & 0.12003E-01_JPRB,0.11457E-01_JPRB,0.10212E-01_JPRB,0.69134E-02_JPRB /)  
KA(:, 1, 5, 6) = (/ &
 & 0.99815E-03_JPRB,0.53184E-02_JPRB,0.73668E-02_JPRB,0.86661E-02_JPRB,0.94189E-02_JPRB, &
 & 0.96088E-02_JPRB,0.91860E-02_JPRB,0.80854E-02_JPRB,0.52147E-02_JPRB /)  
KA(:, 2, 5, 6) = (/ &
 & 0.10594E-02_JPRB,0.55502E-02_JPRB,0.76480E-02_JPRB,0.89382E-02_JPRB,0.96675E-02_JPRB, &
 & 0.98281E-02_JPRB,0.93908E-02_JPRB,0.82904E-02_JPRB,0.53805E-02_JPRB /)  
KA(:, 3, 5, 6) = (/ &
 & 0.11093E-02_JPRB,0.57534E-02_JPRB,0.78820E-02_JPRB,0.91873E-02_JPRB,0.98860E-02_JPRB, &
 & 0.10027E-01_JPRB,0.95739E-02_JPRB,0.84774E-02_JPRB,0.55398E-02_JPRB /)  
KA(:, 4, 5, 6) = (/ &
 & 0.11487E-02_JPRB,0.59264E-02_JPRB,0.80746E-02_JPRB,0.93952E-02_JPRB,0.10070E-01_JPRB, &
 & 0.10196E-01_JPRB,0.97460E-02_JPRB,0.86586E-02_JPRB,0.57118E-02_JPRB /)  
KA(:, 5, 5, 6) = (/ &
 & 0.11770E-02_JPRB,0.60715E-02_JPRB,0.82322E-02_JPRB,0.95590E-02_JPRB,0.10225E-01_JPRB, &
 & 0.10337E-01_JPRB,0.98891E-02_JPRB,0.88282E-02_JPRB,0.58756E-02_JPRB /)  
KA(:, 1, 6, 6) = (/ &
 & 0.78484E-03_JPRB,0.44557E-02_JPRB,0.62088E-02_JPRB,0.73238E-02_JPRB,0.79758E-02_JPRB, &
 & 0.81565E-02_JPRB,0.78234E-02_JPRB,0.68949E-02_JPRB,0.43721E-02_JPRB /)  
KA(:, 2, 6, 6) = (/ &
 & 0.84104E-03_JPRB,0.46584E-02_JPRB,0.64548E-02_JPRB,0.75720E-02_JPRB,0.82049E-02_JPRB, &
 & 0.83603E-02_JPRB,0.80139E-02_JPRB,0.70912E-02_JPRB,0.45208E-02_JPRB /)  
KA(:, 3, 6, 6) = (/ &
 & 0.88703E-03_JPRB,0.48386E-02_JPRB,0.66585E-02_JPRB,0.77939E-02_JPRB,0.84077E-02_JPRB, &
 & 0.85494E-02_JPRB,0.81878E-02_JPRB,0.72673E-02_JPRB,0.46664E-02_JPRB /)  
KA(:, 4, 6, 6) = (/ &
 & 0.92429E-03_JPRB,0.49939E-02_JPRB,0.68255E-02_JPRB,0.79793E-02_JPRB,0.85811E-02_JPRB, &
 & 0.87123E-02_JPRB,0.83423E-02_JPRB,0.74324E-02_JPRB,0.48193E-02_JPRB /)  
KA(:, 5, 6, 6) = (/ &
 & 0.95287E-03_JPRB,0.51269E-02_JPRB,0.69664E-02_JPRB,0.81216E-02_JPRB,0.87256E-02_JPRB, &
 & 0.88404E-02_JPRB,0.84793E-02_JPRB,0.75885E-02_JPRB,0.49684E-02_JPRB /)  
KA(:, 1, 7, 6) = (/ &
 & 0.61176E-03_JPRB,0.37105E-02_JPRB,0.51921E-02_JPRB,0.61495E-02_JPRB,0.67086E-02_JPRB, &
 & 0.68737E-02_JPRB,0.66196E-02_JPRB,0.58499E-02_JPRB,0.36398E-02_JPRB /)  
KA(:, 2, 7, 6) = (/ &
 & 0.66355E-03_JPRB,0.38845E-02_JPRB,0.54092E-02_JPRB,0.63684E-02_JPRB,0.69191E-02_JPRB, &
 & 0.70638E-02_JPRB,0.67967E-02_JPRB,0.60329E-02_JPRB,0.37725E-02_JPRB /)  
KA(:, 3, 7, 6) = (/ &
 & 0.70584E-03_JPRB,0.40429E-02_JPRB,0.55891E-02_JPRB,0.65665E-02_JPRB,0.71061E-02_JPRB, &
 & 0.72392E-02_JPRB,0.69566E-02_JPRB,0.61958E-02_JPRB,0.39040E-02_JPRB /)  
KA(:, 4, 7, 6) = (/ &
 & 0.74016E-03_JPRB,0.41804E-02_JPRB,0.57362E-02_JPRB,0.67306E-02_JPRB,0.72656E-02_JPRB, &
 & 0.73939E-02_JPRB,0.71002E-02_JPRB,0.63458E-02_JPRB,0.40422E-02_JPRB /)  
KA(:, 5, 7, 6) = (/ &
 & 0.76793E-03_JPRB,0.43013E-02_JPRB,0.58634E-02_JPRB,0.68605E-02_JPRB,0.73917E-02_JPRB, &
 & 0.75160E-02_JPRB,0.72292E-02_JPRB,0.64867E-02_JPRB,0.41753E-02_JPRB /)  
KA(:, 1, 8, 6) = (/ &
 & 0.47383E-03_JPRB,0.30719E-02_JPRB,0.43157E-02_JPRB,0.51299E-02_JPRB,0.56113E-02_JPRB, &
 & 0.57604E-02_JPRB,0.55584E-02_JPRB,0.49263E-02_JPRB,0.30099E-02_JPRB /)  
KA(:, 2, 8, 6) = (/ &
 & 0.52030E-03_JPRB,0.32224E-02_JPRB,0.45088E-02_JPRB,0.53256E-02_JPRB,0.58049E-02_JPRB, &
 & 0.59369E-02_JPRB,0.57249E-02_JPRB,0.50950E-02_JPRB,0.31335E-02_JPRB /)  
KA(:, 3, 8, 6) = (/ &
 & 0.55897E-03_JPRB,0.33601E-02_JPRB,0.46690E-02_JPRB,0.55008E-02_JPRB,0.59733E-02_JPRB, &
 & 0.60982E-02_JPRB,0.58703E-02_JPRB,0.52416E-02_JPRB,0.32505E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART4',1,ZHOOK_HANDLE)
END SUBROUTINE PART4


SUBROUTINE PART5

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART5',0,ZHOOK_HANDLE)


KA(:, 4, 8, 6) = (/ &
 & 0.59051E-03_JPRB,0.34823E-02_JPRB,0.48003E-02_JPRB,0.56492E-02_JPRB,0.61147E-02_JPRB, &
 & 0.62407E-02_JPRB,0.60011E-02_JPRB,0.53776E-02_JPRB,0.33691E-02_JPRB /)  
KA(:, 5, 8, 6) = (/ &
 & 0.61638E-03_JPRB,0.35908E-02_JPRB,0.49151E-02_JPRB,0.57682E-02_JPRB,0.62269E-02_JPRB, &
 & 0.63505E-02_JPRB,0.61226E-02_JPRB,0.55061E-02_JPRB,0.34893E-02_JPRB /)  
KA(:, 1, 9, 6) = (/ &
 & 0.36452E-03_JPRB,0.25301E-02_JPRB,0.35655E-02_JPRB,0.42558E-02_JPRB,0.46668E-02_JPRB, &
 & 0.47995E-02_JPRB,0.46391E-02_JPRB,0.41176E-02_JPRB,0.24723E-02_JPRB /)  
KA(:, 2, 9, 6) = (/ &
 & 0.40521E-03_JPRB,0.26609E-02_JPRB,0.37368E-02_JPRB,0.44313E-02_JPRB,0.48422E-02_JPRB, &
 & 0.49605E-02_JPRB,0.47876E-02_JPRB,0.42682E-02_JPRB,0.25854E-02_JPRB /)  
KA(:, 3, 9, 6) = (/ &
 & 0.44042E-03_JPRB,0.27811E-02_JPRB,0.38822E-02_JPRB,0.45871E-02_JPRB,0.49951E-02_JPRB, &
 & 0.51048E-02_JPRB,0.49189E-02_JPRB,0.43988E-02_JPRB,0.26922E-02_JPRB /)  
KA(:, 4, 9, 6) = (/ &
 & 0.46934E-03_JPRB,0.28890E-02_JPRB,0.40015E-02_JPRB,0.47204E-02_JPRB,0.51195E-02_JPRB, &
 & 0.52329E-02_JPRB,0.50398E-02_JPRB,0.45211E-02_JPRB,0.27947E-02_JPRB /)  
KA(:, 5, 9, 6) = (/ &
 & 0.49296E-03_JPRB,0.29863E-02_JPRB,0.41052E-02_JPRB,0.48296E-02_JPRB,0.52212E-02_JPRB, &
 & 0.53320E-02_JPRB,0.51516E-02_JPRB,0.46410E-02_JPRB,0.29014E-02_JPRB /)  
KA(:, 1,10, 6) = (/ &
 & 0.28141E-03_JPRB,0.20839E-02_JPRB,0.29434E-02_JPRB,0.35250E-02_JPRB,0.38705E-02_JPRB, &
 & 0.39907E-02_JPRB,0.38574E-02_JPRB,0.34280E-02_JPRB,0.20276E-02_JPRB /)  
KA(:, 2,10, 6) = (/ &
 & 0.31642E-03_JPRB,0.21962E-02_JPRB,0.30947E-02_JPRB,0.36798E-02_JPRB,0.40279E-02_JPRB, &
 & 0.41317E-02_JPRB,0.39905E-02_JPRB,0.35591E-02_JPRB,0.21304E-02_JPRB /)  
KA(:, 3,10, 6) = (/ &
 & 0.34743E-03_JPRB,0.23002E-02_JPRB,0.32251E-02_JPRB,0.38167E-02_JPRB,0.41632E-02_JPRB, &
 & 0.42588E-02_JPRB,0.41077E-02_JPRB,0.36737E-02_JPRB,0.22246E-02_JPRB /)  
KA(:, 4,10, 6) = (/ &
 & 0.37337E-03_JPRB,0.23958E-02_JPRB,0.33326E-02_JPRB,0.39351E-02_JPRB,0.42727E-02_JPRB, &
 & 0.43699E-02_JPRB,0.42167E-02_JPRB,0.37850E-02_JPRB,0.23171E-02_JPRB /)  
KA(:, 5,10, 6) = (/ &
 & 0.39464E-03_JPRB,0.24818E-02_JPRB,0.34245E-02_JPRB,0.40341E-02_JPRB,0.43635E-02_JPRB, &
 & 0.44592E-02_JPRB,0.43133E-02_JPRB,0.38931E-02_JPRB,0.24123E-02_JPRB /)  
KA(:, 1,11, 6) = (/ &
 & 0.23046E-03_JPRB,0.17561E-02_JPRB,0.24821E-02_JPRB,0.29697E-02_JPRB,0.32603E-02_JPRB, &
 & 0.33590E-02_JPRB,0.32465E-02_JPRB,0.28911E-02_JPRB,0.17000E-02_JPRB /)  
KA(:, 2,11, 6) = (/ &
 & 0.25900E-03_JPRB,0.18499E-02_JPRB,0.26079E-02_JPRB,0.30983E-02_JPRB,0.33914E-02_JPRB, &
 & 0.34790E-02_JPRB,0.33598E-02_JPRB,0.30000E-02_JPRB,0.17879E-02_JPRB /)  
KA(:, 3,11, 6) = (/ &
 & 0.28431E-03_JPRB,0.19371E-02_JPRB,0.27154E-02_JPRB,0.32123E-02_JPRB,0.35009E-02_JPRB, &
 & 0.35810E-02_JPRB,0.34582E-02_JPRB,0.30989E-02_JPRB,0.18709E-02_JPRB /)  
KA(:, 4,11, 6) = (/ &
 & 0.30554E-03_JPRB,0.20175E-02_JPRB,0.28047E-02_JPRB,0.33094E-02_JPRB,0.35897E-02_JPRB, &
 & 0.36708E-02_JPRB,0.35500E-02_JPRB,0.31964E-02_JPRB,0.19524E-02_JPRB /)  
KA(:, 5,11, 6) = (/ &
 & 0.32290E-03_JPRB,0.20906E-02_JPRB,0.28827E-02_JPRB,0.33907E-02_JPRB,0.36638E-02_JPRB, &
 & 0.37448E-02_JPRB,0.36322E-02_JPRB,0.32921E-02_JPRB,0.20342E-02_JPRB /)  
KA(:, 1,12, 6) = (/ &
 & 0.18873E-03_JPRB,0.14753E-02_JPRB,0.20859E-02_JPRB,0.24932E-02_JPRB,0.27362E-02_JPRB, &
 & 0.28163E-02_JPRB,0.27231E-02_JPRB,0.24287E-02_JPRB,0.14226E-02_JPRB /)  
KA(:, 2,12, 6) = (/ &
 & 0.21206E-03_JPRB,0.15542E-02_JPRB,0.21905E-02_JPRB,0.25997E-02_JPRB,0.28436E-02_JPRB, &
 & 0.29146E-02_JPRB,0.28182E-02_JPRB,0.25196E-02_JPRB,0.14964E-02_JPRB /)  
KA(:, 3,12, 6) = (/ &
 & 0.23271E-03_JPRB,0.16282E-02_JPRB,0.22789E-02_JPRB,0.26937E-02_JPRB,0.29320E-02_JPRB, &
 & 0.29995E-02_JPRB,0.29004E-02_JPRB,0.26063E-02_JPRB,0.15684E-02_JPRB /)  
KA(:, 4,12, 6) = (/ &
 & 0.25005E-03_JPRB,0.16959E-02_JPRB,0.23539E-02_JPRB,0.27739E-02_JPRB,0.30052E-02_JPRB, &
 & 0.30738E-02_JPRB,0.29781E-02_JPRB,0.26924E-02_JPRB,0.16388E-02_JPRB /)  
KA(:, 5,12, 6) = (/ &
 & 0.26424E-03_JPRB,0.17579E-02_JPRB,0.24198E-02_JPRB,0.28418E-02_JPRB,0.30688E-02_JPRB, &
 & 0.31370E-02_JPRB,0.30478E-02_JPRB,0.27734E-02_JPRB,0.17090E-02_JPRB /)  
KA(:, 1,13, 6) = (/ &
 & 0.15451E-03_JPRB,0.12362E-02_JPRB,0.17471E-02_JPRB,0.20856E-02_JPRB,0.22870E-02_JPRB, &
 & 0.23530E-02_JPRB,0.22758E-02_JPRB,0.20318E-02_JPRB,0.11868E-02_JPRB /)  
KA(:, 2,13, 6) = (/ &
 & 0.17357E-03_JPRB,0.13027E-02_JPRB,0.18337E-02_JPRB,0.21736E-02_JPRB,0.23752E-02_JPRB, &
 & 0.24339E-02_JPRB,0.23549E-02_JPRB,0.21104E-02_JPRB,0.12492E-02_JPRB /)  
KA(:, 3,13, 6) = (/ &
 & 0.19045E-03_JPRB,0.13651E-02_JPRB,0.19071E-02_JPRB,0.22520E-02_JPRB,0.24479E-02_JPRB, &
 & 0.25052E-02_JPRB,0.24255E-02_JPRB,0.21862E-02_JPRB,0.13114E-02_JPRB /)  
KA(:, 4,13, 6) = (/ &
 & 0.20459E-03_JPRB,0.14225E-02_JPRB,0.19702E-02_JPRB,0.23195E-02_JPRB,0.25109E-02_JPRB, &
 & 0.25680E-02_JPRB,0.24906E-02_JPRB,0.22592E-02_JPRB,0.13717E-02_JPRB /)  
KA(:, 5,13, 6) = (/ &
 & 0.21621E-03_JPRB,0.14751E-02_JPRB,0.20267E-02_JPRB,0.23775E-02_JPRB,0.25654E-02_JPRB, &
 & 0.26221E-02_JPRB,0.25513E-02_JPRB,0.23283E-02_JPRB,0.14321E-02_JPRB /)  
KA(:, 1, 1, 7) = (/ &
 & 0.14551E-01_JPRB,0.26282E-01_JPRB,0.32053E-01_JPRB,0.35189E-01_JPRB,0.36600E-01_JPRB, &
 & 0.36646E-01_JPRB,0.35552E-01_JPRB,0.33215E-01_JPRB,0.27309E-01_JPRB /)  
KA(:, 2, 1, 7) = (/ &
 & 0.15360E-01_JPRB,0.26847E-01_JPRB,0.32411E-01_JPRB,0.35426E-01_JPRB,0.36803E-01_JPRB, &
 & 0.36994E-01_JPRB,0.36037E-01_JPRB,0.33674E-01_JPRB,0.27881E-01_JPRB /)  
KA(:, 3, 1, 7) = (/ &
 & 0.16052E-01_JPRB,0.27358E-01_JPRB,0.32711E-01_JPRB,0.35602E-01_JPRB,0.37002E-01_JPRB, &
 & 0.37322E-01_JPRB,0.36495E-01_JPRB,0.34092E-01_JPRB,0.28365E-01_JPRB /)  
KA(:, 4, 1, 7) = (/ &
 & 0.16634E-01_JPRB,0.27765E-01_JPRB,0.32975E-01_JPRB,0.35757E-01_JPRB,0.37198E-01_JPRB, &
 & 0.37629E-01_JPRB,0.36871E-01_JPRB,0.34489E-01_JPRB,0.28817E-01_JPRB /)  
KA(:, 5, 1, 7) = (/ &
 & 0.17092E-01_JPRB,0.28088E-01_JPRB,0.33173E-01_JPRB,0.35899E-01_JPRB,0.37369E-01_JPRB, &
 & 0.37894E-01_JPRB,0.37206E-01_JPRB,0.34856E-01_JPRB,0.29236E-01_JPRB /)  
KA(:, 1, 2, 7) = (/ &
 & 0.12675E-01_JPRB,0.23757E-01_JPRB,0.28827E-01_JPRB,0.31475E-01_JPRB,0.32647E-01_JPRB, &
 & 0.32779E-01_JPRB,0.31874E-01_JPRB,0.29659E-01_JPRB,0.23735E-01_JPRB /)  
KA(:, 2, 2, 7) = (/ &
 & 0.13363E-01_JPRB,0.24261E-01_JPRB,0.29165E-01_JPRB,0.31734E-01_JPRB,0.32905E-01_JPRB, &
 & 0.33137E-01_JPRB,0.32357E-01_JPRB,0.30114E-01_JPRB,0.24241E-01_JPRB /)  
KA(:, 3, 2, 7) = (/ &
 & 0.13952E-01_JPRB,0.24673E-01_JPRB,0.29458E-01_JPRB,0.31940E-01_JPRB,0.33167E-01_JPRB, &
 & 0.33486E-01_JPRB,0.32794E-01_JPRB,0.30540E-01_JPRB,0.24704E-01_JPRB /)  
KA(:, 4, 2, 7) = (/ &
 & 0.14440E-01_JPRB,0.25010E-01_JPRB,0.29692E-01_JPRB,0.32131E-01_JPRB,0.33402E-01_JPRB, &
 & 0.33816E-01_JPRB,0.33185E-01_JPRB,0.30944E-01_JPRB,0.25123E-01_JPRB /)  
KA(:, 5, 2, 7) = (/ &
 & 0.14810E-01_JPRB,0.25246E-01_JPRB,0.29865E-01_JPRB,0.32323E-01_JPRB,0.33624E-01_JPRB, &
 & 0.34125E-01_JPRB,0.33530E-01_JPRB,0.31299E-01_JPRB,0.25501E-01_JPRB /)  
KA(:, 1, 3, 7) = (/ &
 & 0.10764E-01_JPRB,0.21180E-01_JPRB,0.25645E-01_JPRB,0.27934E-01_JPRB,0.28891E-01_JPRB, &
 & 0.28978E-01_JPRB,0.28215E-01_JPRB,0.26250E-01_JPRB,0.20340E-01_JPRB /)  
KA(:, 2, 3, 7) = (/ &
 & 0.11371E-01_JPRB,0.21611E-01_JPRB,0.25976E-01_JPRB,0.28221E-01_JPRB,0.29204E-01_JPRB, &
 & 0.29347E-01_JPRB,0.28689E-01_JPRB,0.26687E-01_JPRB,0.20803E-01_JPRB /)  
KA(:, 3, 3, 7) = (/ &
 & 0.11882E-01_JPRB,0.21977E-01_JPRB,0.26258E-01_JPRB,0.28467E-01_JPRB,0.29498E-01_JPRB, &
 & 0.29730E-01_JPRB,0.29113E-01_JPRB,0.27115E-01_JPRB,0.21241E-01_JPRB /)  
KA(:, 4, 3, 7) = (/ &
 & 0.12302E-01_JPRB,0.22273E-01_JPRB,0.26477E-01_JPRB,0.28696E-01_JPRB,0.29766E-01_JPRB, &
 & 0.30099E-01_JPRB,0.29507E-01_JPRB,0.27503E-01_JPRB,0.21620E-01_JPRB /)  
KA(:, 5, 3, 7) = (/ &
 & 0.12624E-01_JPRB,0.22481E-01_JPRB,0.26631E-01_JPRB,0.28900E-01_JPRB,0.30032E-01_JPRB, &
 & 0.30425E-01_JPRB,0.29859E-01_JPRB,0.27842E-01_JPRB,0.21966E-01_JPRB /)  
KA(:, 1, 4, 7) = (/ &
 & 0.89860E-02_JPRB,0.18659E-01_JPRB,0.22605E-01_JPRB,0.24580E-01_JPRB,0.25383E-01_JPRB, &
 & 0.25435E-01_JPRB,0.24761E-01_JPRB,0.23037E-01_JPRB,0.17414E-01_JPRB /)  
KA(:, 2, 4, 7) = (/ &
 & 0.95207E-02_JPRB,0.19048E-01_JPRB,0.22924E-01_JPRB,0.24888E-01_JPRB,0.25739E-01_JPRB, &
 & 0.25823E-01_JPRB,0.25200E-01_JPRB,0.23450E-01_JPRB,0.17847E-01_JPRB /)  
KA(:, 3, 4, 7) = (/ &
 & 0.99723E-02_JPRB,0.19380E-01_JPRB,0.23182E-01_JPRB,0.25155E-01_JPRB,0.26061E-01_JPRB, &
 & 0.26209E-01_JPRB,0.25611E-01_JPRB,0.23862E-01_JPRB,0.18251E-01_JPRB /)  
KA(:, 4, 4, 7) = (/ &
 & 0.10354E-01_JPRB,0.19644E-01_JPRB,0.23397E-01_JPRB,0.25401E-01_JPRB,0.26345E-01_JPRB, &
 & 0.26580E-01_JPRB,0.26000E-01_JPRB,0.24233E-01_JPRB,0.18600E-01_JPRB /)  
KA(:, 5, 4, 7) = (/ &
 & 0.10637E-01_JPRB,0.19822E-01_JPRB,0.23556E-01_JPRB,0.25605E-01_JPRB,0.26619E-01_JPRB, &
 & 0.26913E-01_JPRB,0.26359E-01_JPRB,0.24562E-01_JPRB,0.18925E-01_JPRB /)  
KA(:, 1, 5, 7) = (/ &
 & 0.74104E-02_JPRB,0.16264E-01_JPRB,0.19717E-01_JPRB,0.21452E-01_JPRB,0.22172E-01_JPRB, &
 & 0.22207E-01_JPRB,0.21598E-01_JPRB,0.20075E-01_JPRB,0.14880E-01_JPRB /)  
KA(:, 2, 5, 7) = (/ &
 & 0.78778E-02_JPRB,0.16624E-01_JPRB,0.20022E-01_JPRB,0.21765E-01_JPRB,0.22531E-01_JPRB, &
 & 0.22596E-01_JPRB,0.21999E-01_JPRB,0.20458E-01_JPRB,0.15279E-01_JPRB /)  
KA(:, 3, 5, 7) = (/ &
 & 0.82694E-02_JPRB,0.16928E-01_JPRB,0.20277E-01_JPRB,0.22036E-01_JPRB,0.22859E-01_JPRB, &
 & 0.22978E-01_JPRB,0.22384E-01_JPRB,0.20834E-01_JPRB,0.15650E-01_JPRB /)  
KA(:, 4, 5, 7) = (/ &
 & 0.85919E-02_JPRB,0.17168E-01_JPRB,0.20498E-01_JPRB,0.22274E-01_JPRB,0.23143E-01_JPRB, &
 & 0.23326E-01_JPRB,0.22754E-01_JPRB,0.21189E-01_JPRB,0.15980E-01_JPRB /)  
KA(:, 5, 5, 7) = (/ &
 & 0.88337E-02_JPRB,0.17332E-01_JPRB,0.20664E-01_JPRB,0.22477E-01_JPRB,0.23407E-01_JPRB, &
 & 0.23648E-01_JPRB,0.23111E-01_JPRB,0.21509E-01_JPRB,0.16283E-01_JPRB /)  
KA(:, 1, 6, 7) = (/ &
 & 0.60305E-02_JPRB,0.14008E-01_JPRB,0.17028E-01_JPRB,0.18574E-01_JPRB,0.19236E-01_JPRB, &
 & 0.19269E-01_JPRB,0.18720E-01_JPRB,0.17347E-01_JPRB,0.12656E-01_JPRB /)  
KA(:, 2, 6, 7) = (/ &
 & 0.64356E-02_JPRB,0.14339E-01_JPRB,0.17318E-01_JPRB,0.18872E-01_JPRB,0.19580E-01_JPRB, &
 & 0.19645E-01_JPRB,0.19095E-01_JPRB,0.17705E-01_JPRB,0.13025E-01_JPRB /)  
KA(:, 3, 6, 7) = (/ &
 & 0.67708E-02_JPRB,0.14626E-01_JPRB,0.17575E-01_JPRB,0.19135E-01_JPRB,0.19883E-01_JPRB, &
 & 0.20004E-01_JPRB,0.19454E-01_JPRB,0.18055E-01_JPRB,0.13366E-01_JPRB /)  
KA(:, 4, 6, 7) = (/ &
 & 0.70449E-02_JPRB,0.14853E-01_JPRB,0.17795E-01_JPRB,0.19363E-01_JPRB,0.20156E-01_JPRB, &
 & 0.20324E-01_JPRB,0.19811E-01_JPRB,0.18392E-01_JPRB,0.13679E-01_JPRB /)  
KA(:, 5, 6, 7) = (/ &
 & 0.72586E-02_JPRB,0.15014E-01_JPRB,0.17954E-01_JPRB,0.19569E-01_JPRB,0.20401E-01_JPRB, &
 & 0.20622E-01_JPRB,0.20155E-01_JPRB,0.18706E-01_JPRB,0.13963E-01_JPRB /)  
KA(:, 1, 7, 7) = (/ &
 & 0.48615E-02_JPRB,0.11936E-01_JPRB,0.14574E-01_JPRB,0.15963E-01_JPRB,0.16578E-01_JPRB, &
 & 0.16615E-01_JPRB,0.16125E-01_JPRB,0.14904E-01_JPRB,0.10718E-01_JPRB /)  
KA(:, 2, 7, 7) = (/ &
 & 0.52093E-02_JPRB,0.12247E-01_JPRB,0.14845E-01_JPRB,0.16239E-01_JPRB,0.16890E-01_JPRB, &
 & 0.16965E-01_JPRB,0.16477E-01_JPRB,0.15238E-01_JPRB,0.11050E-01_JPRB /)  
KA(:, 3, 7, 7) = (/ &
 & 0.54981E-02_JPRB,0.12520E-01_JPRB,0.15089E-01_JPRB,0.16485E-01_JPRB,0.17163E-01_JPRB, &
 & 0.17296E-01_JPRB,0.16823E-01_JPRB,0.15561E-01_JPRB,0.11367E-01_JPRB /)  
KA(:, 4, 7, 7) = (/ &
 & 0.57341E-02_JPRB,0.12732E-01_JPRB,0.15302E-01_JPRB,0.16709E-01_JPRB,0.17412E-01_JPRB, &
 & 0.17587E-01_JPRB,0.17156E-01_JPRB,0.15882E-01_JPRB,0.11657E-01_JPRB /)  
KA(:, 5, 7, 7) = (/ &
 & 0.59245E-02_JPRB,0.12879E-01_JPRB,0.15460E-01_JPRB,0.16900E-01_JPRB,0.17646E-01_JPRB, &
 & 0.17862E-01_JPRB,0.17475E-01_JPRB,0.16189E-01_JPRB,0.11924E-01_JPRB /)  
KA(:, 1, 8, 7) = (/ &
 & 0.38903E-02_JPRB,0.10086E-01_JPRB,0.12393E-01_JPRB,0.13617E-01_JPRB,0.14179E-01_JPRB, &
 & 0.14230E-01_JPRB,0.13810E-01_JPRB,0.12741E-01_JPRB,0.90402E-02_JPRB /)  
KA(:, 2, 8, 7) = (/ &
 & 0.41883E-02_JPRB,0.10379E-01_JPRB,0.12642E-01_JPRB,0.13866E-01_JPRB,0.14454E-01_JPRB, &
 & 0.14549E-01_JPRB,0.14140E-01_JPRB,0.13050E-01_JPRB,0.93407E-02_JPRB /)  
KA(:, 3, 8, 7) = (/ &
 & 0.44374E-02_JPRB,0.10628E-01_JPRB,0.12866E-01_JPRB,0.14093E-01_JPRB,0.14702E-01_JPRB, &
 & 0.14847E-01_JPRB,0.14466E-01_JPRB,0.13354E-01_JPRB,0.96289E-02_JPRB /)  
KA(:, 4, 8, 7) = (/ &
 & 0.46417E-02_JPRB,0.10823E-01_JPRB,0.13067E-01_JPRB,0.14297E-01_JPRB,0.14936E-01_JPRB, &
 & 0.15113E-01_JPRB,0.14777E-01_JPRB,0.13659E-01_JPRB,0.98946E-02_JPRB /)  
KA(:, 5, 8, 7) = (/ &
 & 0.48106E-02_JPRB,0.10958E-01_JPRB,0.13212E-01_JPRB,0.14477E-01_JPRB,0.15155E-01_JPRB, &
 & 0.15369E-01_JPRB,0.15065E-01_JPRB,0.13954E-01_JPRB,0.10137E-01_JPRB /)  
KA(:, 1, 9, 7) = (/ &
 & 0.30906E-02_JPRB,0.84716E-02_JPRB,0.10475E-01_JPRB,0.11533E-01_JPRB,0.12037E-01_JPRB, &
 & 0.12102E-01_JPRB,0.11757E-01_JPRB,0.10840E-01_JPRB,0.75790E-02_JPRB /)  
KA(:, 2, 9, 7) = (/ &
 & 0.33456E-02_JPRB,0.87380E-02_JPRB,0.10698E-01_JPRB,0.11759E-01_JPRB,0.12281E-01_JPRB, &
 & 0.12384E-01_JPRB,0.12063E-01_JPRB,0.11124E-01_JPRB,0.78524E-02_JPRB /)  
KA(:, 3, 9, 7) = (/ &
 & 0.35624E-02_JPRB,0.89636E-02_JPRB,0.10908E-01_JPRB,0.11964E-01_JPRB,0.12503E-01_JPRB, &
 & 0.12651E-01_JPRB,0.12366E-01_JPRB,0.11413E-01_JPRB,0.81116E-02_JPRB /)  
KA(:, 4, 9, 7) = (/ &
 & 0.37409E-02_JPRB,0.91394E-02_JPRB,0.11085E-01_JPRB,0.12156E-01_JPRB,0.12717E-01_JPRB, &
 & 0.12895E-01_JPRB,0.12646E-01_JPRB,0.11703E-01_JPRB,0.83543E-02_JPRB /)  
KA(:, 5, 9, 7) = (/ &
 & 0.38899E-02_JPRB,0.92663E-02_JPRB,0.11210E-01_JPRB,0.12323E-01_JPRB,0.12923E-01_JPRB, &
 & 0.13135E-01_JPRB,0.12909E-01_JPRB,0.11979E-01_JPRB,0.85748E-02_JPRB /)  
KA(:, 1,10, 7) = (/ &
 & 0.24588E-02_JPRB,0.70997E-02_JPRB,0.88156E-02_JPRB,0.97280E-02_JPRB,0.10175E-01_JPRB, &
 & 0.10246E-01_JPRB,0.99712E-02_JPRB,0.91951E-02_JPRB,0.63324E-02_JPRB /)  
KA(:, 2,10, 7) = (/ &
 & 0.26743E-02_JPRB,0.73393E-02_JPRB,0.90183E-02_JPRB,0.99289E-02_JPRB,0.10387E-01_JPRB, &
 & 0.10496E-01_JPRB,0.10249E-01_JPRB,0.94566E-02_JPRB,0.65770E-02_JPRB /)  
KA(:, 3,10, 7) = (/ &
 & 0.28610E-02_JPRB,0.75352E-02_JPRB,0.92028E-02_JPRB,0.10117E-01_JPRB,0.10586E-01_JPRB, &
 & 0.10730E-01_JPRB,0.10524E-01_JPRB,0.97307E-02_JPRB,0.68077E-02_JPRB /)  
KA(:, 4,10, 7) = (/ &
 & 0.30147E-02_JPRB,0.76899E-02_JPRB,0.93550E-02_JPRB,0.10291E-01_JPRB,0.10781E-01_JPRB, &
 & 0.10954E-01_JPRB,0.10778E-01_JPRB,0.10001E-01_JPRB,0.70201E-02_JPRB /)  
KA(:, 5,10, 7) = (/ &
 & 0.31444E-02_JPRB,0.78050E-02_JPRB,0.94668E-02_JPRB,0.10433E-01_JPRB,0.10974E-01_JPRB, &
 & 0.11173E-01_JPRB,0.11019E-01_JPRB,0.10253E-01_JPRB,0.72189E-02_JPRB /)  
KA(:, 1,11, 7) = (/ &
 & 0.20345E-02_JPRB,0.60249E-02_JPRB,0.74716E-02_JPRB,0.82496E-02_JPRB,0.86458E-02_JPRB, &
 & 0.87340E-02_JPRB,0.85222E-02_JPRB,0.78657E-02_JPRB,0.53714E-02_JPRB /)  
KA(:, 2,11, 7) = (/ &
 & 0.22071E-02_JPRB,0.62176E-02_JPRB,0.76440E-02_JPRB,0.84251E-02_JPRB,0.88273E-02_JPRB, &
 & 0.89461E-02_JPRB,0.87689E-02_JPRB,0.81125E-02_JPRB,0.55835E-02_JPRB /)  
KA(:, 3,11, 7) = (/ &
 & 0.23554E-02_JPRB,0.63729E-02_JPRB,0.77932E-02_JPRB,0.85868E-02_JPRB,0.90058E-02_JPRB, &
 & 0.91548E-02_JPRB,0.90075E-02_JPRB,0.83660E-02_JPRB,0.57827E-02_JPRB /)  
KA(:, 4,11, 7) = (/ &
 & 0.24780E-02_JPRB,0.64944E-02_JPRB,0.79106E-02_JPRB,0.87291E-02_JPRB,0.91857E-02_JPRB, &
 & 0.93565E-02_JPRB,0.92302E-02_JPRB,0.86036E-02_JPRB,0.59695E-02_JPRB /)  
KA(:, 5,11, 7) = (/ &
 & 0.25820E-02_JPRB,0.65802E-02_JPRB,0.79974E-02_JPRB,0.88427E-02_JPRB,0.93482E-02_JPRB, &
 & 0.95539E-02_JPRB,0.94443E-02_JPRB,0.88180E-02_JPRB,0.61512E-02_JPRB /)  
KA(:, 1,12, 7) = (/ &
 & 0.16789E-02_JPRB,0.50906E-02_JPRB,0.63078E-02_JPRB,0.69750E-02_JPRB,0.73172E-02_JPRB, &
 & 0.74078E-02_JPRB,0.72504E-02_JPRB,0.67015E-02_JPRB,0.45394E-02_JPRB /)  
KA(:, 2,12, 7) = (/ &
 & 0.18170E-02_JPRB,0.52437E-02_JPRB,0.64512E-02_JPRB,0.71255E-02_JPRB,0.74790E-02_JPRB, &
 & 0.75959E-02_JPRB,0.74655E-02_JPRB,0.69307E-02_JPRB,0.47237E-02_JPRB /)  
KA(:, 3,12, 7) = (/ &
 & 0.19356E-02_JPRB,0.53689E-02_JPRB,0.65701E-02_JPRB,0.72610E-02_JPRB,0.76415E-02_JPRB, &
 & 0.77811E-02_JPRB,0.76703E-02_JPRB,0.71508E-02_JPRB,0.48953E-02_JPRB /)  
KA(:, 4,12, 7) = (/ &
 & 0.20342E-02_JPRB,0.54644E-02_JPRB,0.66640E-02_JPRB,0.73792E-02_JPRB,0.77929E-02_JPRB, &
 & 0.79635E-02_JPRB,0.78660E-02_JPRB,0.73532E-02_JPRB,0.50607E-02_JPRB /)  
KA(:, 5,12, 7) = (/ &
 & 0.21182E-02_JPRB,0.55328E-02_JPRB,0.67352E-02_JPRB,0.74736E-02_JPRB,0.79282E-02_JPRB, &
 & 0.81307E-02_JPRB,0.80542E-02_JPRB,0.75407E-02_JPRB,0.52234E-02_JPRB /)  
KA(:, 1,13, 7) = (/ &
 & 0.13819E-02_JPRB,0.42823E-02_JPRB,0.53096E-02_JPRB,0.58771E-02_JPRB,0.61745E-02_JPRB, &
 & 0.62601E-02_JPRB,0.61411E-02_JPRB,0.56893E-02_JPRB,0.38201E-02_JPRB /)  
KA(:, 2,13, 7) = (/ &
 & 0.14927E-02_JPRB,0.44078E-02_JPRB,0.54261E-02_JPRB,0.60055E-02_JPRB,0.63167E-02_JPRB, &
 & 0.64278E-02_JPRB,0.63268E-02_JPRB,0.58891E-02_JPRB,0.39789E-02_JPRB /)  
KA(:, 3,13, 7) = (/ &
 & 0.15884E-02_JPRB,0.45090E-02_JPRB,0.55246E-02_JPRB,0.61217E-02_JPRB,0.64577E-02_JPRB, &
 & 0.65903E-02_JPRB,0.65044E-02_JPRB,0.60758E-02_JPRB,0.41288E-02_JPRB /)  
KA(:, 4,13, 7) = (/ &
 & 0.16683E-02_JPRB,0.45858E-02_JPRB,0.56029E-02_JPRB,0.62193E-02_JPRB,0.65859E-02_JPRB, &
 & 0.67454E-02_JPRB,0.66768E-02_JPRB,0.62506E-02_JPRB,0.42765E-02_JPRB /)  
KA(:, 5,13, 7) = (/ &
 & 0.17364E-02_JPRB,0.46419E-02_JPRB,0.56644E-02_JPRB,0.62996E-02_JPRB,0.66998E-02_JPRB, &
 & 0.68888E-02_JPRB,0.68404E-02_JPRB,0.64188E-02_JPRB,0.44198E-02_JPRB /)  
KA(:, 1, 1, 8) = (/ &
 & 0.57760E-01_JPRB,0.69432E-01_JPRB,0.76402E-01_JPRB,0.81517E-01_JPRB,0.85125E-01_JPRB, &
 & 0.87289E-01_JPRB,0.87408E-01_JPRB,0.83317E-01_JPRB,0.74720E-01_JPRB /)  
KA(:, 2, 1, 8) = (/ &
 & 0.58256E-01_JPRB,0.69667E-01_JPRB,0.76723E-01_JPRB,0.81911E-01_JPRB,0.85362E-01_JPRB, &
 & 0.87289E-01_JPRB,0.87306E-01_JPRB,0.83357E-01_JPRB,0.75177E-01_JPRB /)  
KA(:, 3, 1, 8) = (/ &
 & 0.58710E-01_JPRB,0.69859E-01_JPRB,0.76973E-01_JPRB,0.82328E-01_JPRB,0.85690E-01_JPRB, &
 & 0.87420E-01_JPRB,0.87264E-01_JPRB,0.83435E-01_JPRB,0.75701E-01_JPRB /)  
KA(:, 4, 1, 8) = (/ &
 & 0.59052E-01_JPRB,0.70050E-01_JPRB,0.77176E-01_JPRB,0.82642E-01_JPRB,0.86071E-01_JPRB, &
 & 0.87660E-01_JPRB,0.87341E-01_JPRB,0.83544E-01_JPRB,0.76230E-01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART5',1,ZHOOK_HANDLE)
END SUBROUTINE PART5


SUBROUTINE PART6

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART6',0,ZHOOK_HANDLE)


KA(:, 5, 1, 8) = (/ &
 & 0.59298E-01_JPRB,0.70198E-01_JPRB,0.77374E-01_JPRB,0.82883E-01_JPRB,0.86469E-01_JPRB, &
 & 0.87977E-01_JPRB,0.87473E-01_JPRB,0.83691E-01_JPRB,0.76769E-01_JPRB /)  
KA(:, 1, 2, 8) = (/ &
 & 0.50908E-01_JPRB,0.62848E-01_JPRB,0.70003E-01_JPRB,0.75263E-01_JPRB,0.78670E-01_JPRB, &
 & 0.80594E-01_JPRB,0.80694E-01_JPRB,0.77048E-01_JPRB,0.67048E-01_JPRB /)  
KA(:, 2, 2, 8) = (/ &
 & 0.51469E-01_JPRB,0.63178E-01_JPRB,0.70395E-01_JPRB,0.75763E-01_JPRB,0.79033E-01_JPRB, &
 & 0.80775E-01_JPRB,0.80686E-01_JPRB,0.77199E-01_JPRB,0.67605E-01_JPRB /)  
KA(:, 3, 2, 8) = (/ &
 & 0.51956E-01_JPRB,0.63519E-01_JPRB,0.70748E-01_JPRB,0.76221E-01_JPRB,0.79512E-01_JPRB, &
 & 0.81067E-01_JPRB,0.80797E-01_JPRB,0.77370E-01_JPRB,0.68182E-01_JPRB /)  
KA(:, 4, 2, 8) = (/ &
 & 0.52329E-01_JPRB,0.63831E-01_JPRB,0.71115E-01_JPRB,0.76591E-01_JPRB,0.80032E-01_JPRB, &
 & 0.81445E-01_JPRB,0.81001E-01_JPRB,0.77568E-01_JPRB,0.68768E-01_JPRB /)  
KA(:, 5, 2, 8) = (/ &
 & 0.52648E-01_JPRB,0.64108E-01_JPRB,0.71441E-01_JPRB,0.76941E-01_JPRB,0.80464E-01_JPRB, &
 & 0.81866E-01_JPRB,0.81282E-01_JPRB,0.77796E-01_JPRB,0.69377E-01_JPRB /)  
KA(:, 1, 3, 8) = (/ &
 & 0.44636E-01_JPRB,0.56575E-01_JPRB,0.63667E-01_JPRB,0.68804E-01_JPRB,0.72146E-01_JPRB, &
 & 0.73940E-01_JPRB,0.73756E-01_JPRB,0.70359E-01_JPRB,0.59446E-01_JPRB /)  
KA(:, 2, 3, 8) = (/ &
 & 0.45216E-01_JPRB,0.57005E-01_JPRB,0.64111E-01_JPRB,0.69328E-01_JPRB,0.72620E-01_JPRB, &
 & 0.74228E-01_JPRB,0.73854E-01_JPRB,0.70600E-01_JPRB,0.60086E-01_JPRB /)  
KA(:, 3, 3, 8) = (/ &
 & 0.45716E-01_JPRB,0.57448E-01_JPRB,0.64591E-01_JPRB,0.69816E-01_JPRB,0.73178E-01_JPRB, &
 & 0.74616E-01_JPRB,0.74093E-01_JPRB,0.70843E-01_JPRB,0.60738E-01_JPRB /)  
KA(:, 4, 3, 8) = (/ &
 & 0.46137E-01_JPRB,0.57862E-01_JPRB,0.65060E-01_JPRB,0.70283E-01_JPRB,0.73724E-01_JPRB, &
 & 0.75067E-01_JPRB,0.74408E-01_JPRB,0.71130E-01_JPRB,0.61385E-01_JPRB /)  
KA(:, 5, 3, 8) = (/ &
 & 0.46490E-01_JPRB,0.58240E-01_JPRB,0.65537E-01_JPRB,0.70752E-01_JPRB,0.74187E-01_JPRB, &
 & 0.75545E-01_JPRB,0.74817E-01_JPRB,0.71479E-01_JPRB,0.61998E-01_JPRB /)  
KA(:, 1, 4, 8) = (/ &
 & 0.38910E-01_JPRB,0.50823E-01_JPRB,0.57505E-01_JPRB,0.62364E-01_JPRB,0.65559E-01_JPRB, &
 & 0.67154E-01_JPRB,0.66798E-01_JPRB,0.63531E-01_JPRB,0.52401E-01_JPRB /)  
KA(:, 2, 4, 8) = (/ &
 & 0.39488E-01_JPRB,0.51307E-01_JPRB,0.58022E-01_JPRB,0.62912E-01_JPRB,0.66074E-01_JPRB, &
 & 0.67518E-01_JPRB,0.67025E-01_JPRB,0.63840E-01_JPRB,0.53093E-01_JPRB /)  
KA(:, 3, 4, 8) = (/ &
 & 0.39991E-01_JPRB,0.51812E-01_JPRB,0.58566E-01_JPRB,0.63451E-01_JPRB,0.66632E-01_JPRB, &
 & 0.68010E-01_JPRB,0.67348E-01_JPRB,0.64169E-01_JPRB,0.53782E-01_JPRB /)  
KA(:, 4, 4, 8) = (/ &
 & 0.40387E-01_JPRB,0.52291E-01_JPRB,0.59117E-01_JPRB,0.64001E-01_JPRB,0.67196E-01_JPRB, &
 & 0.68514E-01_JPRB,0.67789E-01_JPRB,0.64555E-01_JPRB,0.54470E-01_JPRB /)  
KA(:, 5, 4, 8) = (/ &
 & 0.40719E-01_JPRB,0.52739E-01_JPRB,0.59691E-01_JPRB,0.64572E-01_JPRB,0.67725E-01_JPRB, &
 & 0.69031E-01_JPRB,0.68307E-01_JPRB,0.64985E-01_JPRB,0.55091E-01_JPRB /)  
KA(:, 1, 5, 8) = (/ &
 & 0.33692E-01_JPRB,0.45459E-01_JPRB,0.51705E-01_JPRB,0.56111E-01_JPRB,0.58984E-01_JPRB, &
 & 0.60384E-01_JPRB,0.59951E-01_JPRB,0.56770E-01_JPRB,0.45939E-01_JPRB /)  
KA(:, 2, 5, 8) = (/ &
 & 0.34254E-01_JPRB,0.45979E-01_JPRB,0.52252E-01_JPRB,0.56664E-01_JPRB,0.59515E-01_JPRB, &
 & 0.60816E-01_JPRB,0.60273E-01_JPRB,0.57146E-01_JPRB,0.46647E-01_JPRB /)  
KA(:, 3, 5, 8) = (/ &
 & 0.34738E-01_JPRB,0.46532E-01_JPRB,0.52846E-01_JPRB,0.57238E-01_JPRB,0.60077E-01_JPRB, &
 & 0.61352E-01_JPRB,0.60714E-01_JPRB,0.57566E-01_JPRB,0.47359E-01_JPRB /)  
KA(:, 4, 5, 8) = (/ &
 & 0.35117E-01_JPRB,0.47047E-01_JPRB,0.53459E-01_JPRB,0.57849E-01_JPRB,0.60668E-01_JPRB, &
 & 0.61902E-01_JPRB,0.61259E-01_JPRB,0.58030E-01_JPRB,0.48036E-01_JPRB /)  
KA(:, 5, 5, 8) = (/ &
 & 0.35428E-01_JPRB,0.47508E-01_JPRB,0.54083E-01_JPRB,0.58493E-01_JPRB,0.61253E-01_JPRB, &
 & 0.62481E-01_JPRB,0.61851E-01_JPRB,0.58523E-01_JPRB,0.48648E-01_JPRB /)  
KA(:, 1, 6, 8) = (/ &
 & 0.28910E-01_JPRB,0.40429E-01_JPRB,0.46176E-01_JPRB,0.50108E-01_JPRB,0.52609E-01_JPRB, &
 & 0.53750E-01_JPRB,0.53289E-01_JPRB,0.50286E-01_JPRB,0.40061E-01_JPRB /)  
KA(:, 2, 6, 8) = (/ &
 & 0.29433E-01_JPRB,0.40967E-01_JPRB,0.46731E-01_JPRB,0.50653E-01_JPRB,0.53149E-01_JPRB, &
 & 0.54232E-01_JPRB,0.53687E-01_JPRB,0.50714E-01_JPRB,0.40756E-01_JPRB /)  
KA(:, 3, 6, 8) = (/ &
 & 0.29883E-01_JPRB,0.41520E-01_JPRB,0.47349E-01_JPRB,0.51251E-01_JPRB,0.53731E-01_JPRB, &
 & 0.54796E-01_JPRB,0.54207E-01_JPRB,0.51188E-01_JPRB,0.41443E-01_JPRB /)  
KA(:, 4, 6, 8) = (/ &
 & 0.30252E-01_JPRB,0.42024E-01_JPRB,0.47998E-01_JPRB,0.51918E-01_JPRB,0.54339E-01_JPRB, &
 & 0.55387E-01_JPRB,0.54820E-01_JPRB,0.51711E-01_JPRB,0.42085E-01_JPRB /)  
KA(:, 5, 6, 8) = (/ &
 & 0.30542E-01_JPRB,0.42447E-01_JPRB,0.48635E-01_JPRB,0.52598E-01_JPRB,0.54986E-01_JPRB, &
 & 0.56038E-01_JPRB,0.55430E-01_JPRB,0.52236E-01_JPRB,0.42675E-01_JPRB /)  
KA(:, 1, 7, 8) = (/ &
 & 0.24600E-01_JPRB,0.35725E-01_JPRB,0.40952E-01_JPRB,0.44398E-01_JPRB,0.46558E-01_JPRB, &
 & 0.47462E-01_JPRB,0.46950E-01_JPRB,0.44227E-01_JPRB,0.34751E-01_JPRB /)  
KA(:, 2, 7, 8) = (/ &
 & 0.25060E-01_JPRB,0.36250E-01_JPRB,0.41498E-01_JPRB,0.44950E-01_JPRB,0.47097E-01_JPRB, &
 & 0.47977E-01_JPRB,0.47399E-01_JPRB,0.44690E-01_JPRB,0.35410E-01_JPRB /)  
KA(:, 3, 7, 8) = (/ &
 & 0.25466E-01_JPRB,0.36769E-01_JPRB,0.42119E-01_JPRB,0.45572E-01_JPRB,0.47696E-01_JPRB, &
 & 0.48548E-01_JPRB,0.47965E-01_JPRB,0.45198E-01_JPRB,0.36050E-01_JPRB /)  
KA(:, 4, 7, 8) = (/ &
 & 0.25804E-01_JPRB,0.37232E-01_JPRB,0.42764E-01_JPRB,0.46249E-01_JPRB,0.48349E-01_JPRB, &
 & 0.49173E-01_JPRB,0.48603E-01_JPRB,0.45737E-01_JPRB,0.36649E-01_JPRB /)  
KA(:, 5, 7, 8) = (/ &
 & 0.26075E-01_JPRB,0.37645E-01_JPRB,0.43371E-01_JPRB,0.46950E-01_JPRB,0.49045E-01_JPRB, &
 & 0.49856E-01_JPRB,0.49223E-01_JPRB,0.46279E-01_JPRB,0.37198E-01_JPRB /)  
KA(:, 1, 8, 8) = (/ &
 & 0.20747E-01_JPRB,0.31325E-01_JPRB,0.36016E-01_JPRB,0.39047E-01_JPRB,0.40921E-01_JPRB, &
 & 0.41656E-01_JPRB,0.41097E-01_JPRB,0.38682E-01_JPRB,0.29955E-01_JPRB /)  
KA(:, 2, 8, 8) = (/ &
 & 0.21145E-01_JPRB,0.31811E-01_JPRB,0.36541E-01_JPRB,0.39597E-01_JPRB,0.41455E-01_JPRB, &
 & 0.42169E-01_JPRB,0.41575E-01_JPRB,0.39145E-01_JPRB,0.30577E-01_JPRB /)  
KA(:, 3, 8, 8) = (/ &
 & 0.21497E-01_JPRB,0.32290E-01_JPRB,0.37155E-01_JPRB,0.40238E-01_JPRB,0.42067E-01_JPRB, &
 & 0.42744E-01_JPRB,0.42154E-01_JPRB,0.39648E-01_JPRB,0.31178E-01_JPRB /)  
KA(:, 4, 8, 8) = (/ &
 & 0.21796E-01_JPRB,0.32717E-01_JPRB,0.37766E-01_JPRB,0.40923E-01_JPRB,0.42738E-01_JPRB, &
 & 0.43394E-01_JPRB,0.42768E-01_JPRB,0.40185E-01_JPRB,0.31733E-01_JPRB /)  
KA(:, 5, 8, 8) = (/ &
 & 0.22044E-01_JPRB,0.33112E-01_JPRB,0.38338E-01_JPRB,0.41597E-01_JPRB,0.43462E-01_JPRB, &
 & 0.44087E-01_JPRB,0.43385E-01_JPRB,0.40740E-01_JPRB,0.32254E-01_JPRB /)  
KA(:, 1, 9, 8) = (/ &
 & 0.17360E-01_JPRB,0.27218E-01_JPRB,0.31401E-01_JPRB,0.34084E-01_JPRB,0.35741E-01_JPRB, &
 & 0.36373E-01_JPRB,0.35798E-01_JPRB,0.33594E-01_JPRB,0.25664E-01_JPRB /)  
KA(:, 2, 9, 8) = (/ &
 & 0.17693E-01_JPRB,0.27662E-01_JPRB,0.31908E-01_JPRB,0.34622E-01_JPRB,0.36264E-01_JPRB, &
 & 0.36877E-01_JPRB,0.36285E-01_JPRB,0.34049E-01_JPRB,0.26251E-01_JPRB /)  
KA(:, 3, 9, 8) = (/ &
 & 0.17992E-01_JPRB,0.28089E-01_JPRB,0.32477E-01_JPRB,0.35255E-01_JPRB,0.36874E-01_JPRB, &
 & 0.37444E-01_JPRB,0.36831E-01_JPRB,0.34544E-01_JPRB,0.26814E-01_JPRB /)  
KA(:, 4, 9, 8) = (/ &
 & 0.18258E-01_JPRB,0.28481E-01_JPRB,0.33050E-01_JPRB,0.35909E-01_JPRB,0.37552E-01_JPRB, &
 & 0.38078E-01_JPRB,0.37421E-01_JPRB,0.35073E-01_JPRB,0.27335E-01_JPRB /)  
KA(:, 5, 9, 8) = (/ &
 & 0.18484E-01_JPRB,0.28849E-01_JPRB,0.33601E-01_JPRB,0.36536E-01_JPRB,0.38254E-01_JPRB, &
 & 0.38756E-01_JPRB,0.38026E-01_JPRB,0.35616E-01_JPRB,0.27829E-01_JPRB /)  
KA(:, 1,10, 8) = (/ &
 & 0.14462E-01_JPRB,0.23463E-01_JPRB,0.27186E-01_JPRB,0.29588E-01_JPRB,0.31079E-01_JPRB, &
 & 0.31625E-01_JPRB,0.31053E-01_JPRB,0.29012E-01_JPRB,0.21916E-01_JPRB /)  
KA(:, 2,10, 8) = (/ &
 & 0.14737E-01_JPRB,0.23853E-01_JPRB,0.27662E-01_JPRB,0.30109E-01_JPRB,0.31581E-01_JPRB, &
 & 0.32116E-01_JPRB,0.31527E-01_JPRB,0.29461E-01_JPRB,0.22460E-01_JPRB /)  
KA(:, 3,10, 8) = (/ &
 & 0.14983E-01_JPRB,0.24238E-01_JPRB,0.28187E-01_JPRB,0.30710E-01_JPRB,0.32176E-01_JPRB, &
 & 0.32664E-01_JPRB,0.32044E-01_JPRB,0.29948E-01_JPRB,0.22987E-01_JPRB /)  
KA(:, 4,10, 8) = (/ &
 & 0.15228E-01_JPRB,0.24593E-01_JPRB,0.28718E-01_JPRB,0.31312E-01_JPRB,0.32826E-01_JPRB, &
 & 0.33282E-01_JPRB,0.32615E-01_JPRB,0.30467E-01_JPRB,0.23478E-01_JPRB /)  
KA(:, 5,10, 8) = (/ &
 & 0.15411E-01_JPRB,0.24932E-01_JPRB,0.29228E-01_JPRB,0.31903E-01_JPRB,0.33455E-01_JPRB, &
 & 0.33943E-01_JPRB,0.33207E-01_JPRB,0.30994E-01_JPRB,0.23939E-01_JPRB /)  
KA(:, 1,11, 8) = (/ &
 & 0.12097E-01_JPRB,0.20230E-01_JPRB,0.23554E-01_JPRB,0.25737E-01_JPRB,0.27070E-01_JPRB, &
 & 0.27526E-01_JPRB,0.26987E-01_JPRB,0.25125E-01_JPRB,0.18843E-01_JPRB /)  
KA(:, 2,11, 8) = (/ &
 & 0.12316E-01_JPRB,0.20564E-01_JPRB,0.24014E-01_JPRB,0.26265E-01_JPRB,0.27589E-01_JPRB, &
 & 0.28021E-01_JPRB,0.27462E-01_JPRB,0.25580E-01_JPRB,0.19341E-01_JPRB /)  
KA(:, 3,11, 8) = (/ &
 & 0.12525E-01_JPRB,0.20893E-01_JPRB,0.24494E-01_JPRB,0.26817E-01_JPRB,0.28172E-01_JPRB, &
 & 0.28578E-01_JPRB,0.27985E-01_JPRB,0.26073E-01_JPRB,0.19811E-01_JPRB /)  
KA(:, 4,11, 8) = (/ &
 & 0.12698E-01_JPRB,0.21212E-01_JPRB,0.24971E-01_JPRB,0.27358E-01_JPRB,0.28752E-01_JPRB, &
 & 0.29196E-01_JPRB,0.28554E-01_JPRB,0.26575E-01_JPRB,0.20254E-01_JPRB /)  
KA(:, 5,11, 8) = (/ &
 & 0.12813E-01_JPRB,0.21527E-01_JPRB,0.25428E-01_JPRB,0.27886E-01_JPRB,0.29316E-01_JPRB, &
 & 0.29794E-01_JPRB,0.29144E-01_JPRB,0.27095E-01_JPRB,0.20669E-01_JPRB /)  
KA(:, 1,12, 8) = (/ &
 & 0.10079E-01_JPRB,0.17332E-01_JPRB,0.20326E-01_JPRB,0.22283E-01_JPRB,0.23452E-01_JPRB, &
 & 0.23840E-01_JPRB,0.23351E-01_JPRB,0.21701E-01_JPRB,0.16150E-01_JPRB /)  
KA(:, 2,12, 8) = (/ &
 & 0.10253E-01_JPRB,0.17624E-01_JPRB,0.20738E-01_JPRB,0.22772E-01_JPRB,0.23963E-01_JPRB, &
 & 0.24343E-01_JPRB,0.23830E-01_JPRB,0.22159E-01_JPRB,0.16605E-01_JPRB /)  
KA(:, 3,12, 8) = (/ &
 & 0.10412E-01_JPRB,0.17914E-01_JPRB,0.21165E-01_JPRB,0.23257E-01_JPRB,0.24491E-01_JPRB, &
 & 0.24907E-01_JPRB,0.24364E-01_JPRB,0.22633E-01_JPRB,0.17031E-01_JPRB /)  
KA(:, 4,12, 8) = (/ &
 & 0.10528E-01_JPRB,0.18203E-01_JPRB,0.21585E-01_JPRB,0.23732E-01_JPRB,0.25019E-01_JPRB, &
 & 0.25466E-01_JPRB,0.24925E-01_JPRB,0.23123E-01_JPRB,0.17440E-01_JPRB /)  
KA(:, 5,12, 8) = (/ &
 & 0.10595E-01_JPRB,0.18491E-01_JPRB,0.21987E-01_JPRB,0.24205E-01_JPRB,0.25526E-01_JPRB, &
 & 0.26013E-01_JPRB,0.25497E-01_JPRB,0.23633E-01_JPRB,0.17825E-01_JPRB /)  
KA(:, 1,13, 8) = (/ &
 & 0.83675E-02_JPRB,0.14778E-01_JPRB,0.17455E-01_JPRB,0.19201E-01_JPRB,0.20214E-01_JPRB, &
 & 0.20545E-01_JPRB,0.20133E-01_JPRB,0.18703E-01_JPRB,0.13810E-01_JPRB /)  
KA(:, 2,13, 8) = (/ &
 & 0.85037E-02_JPRB,0.15033E-01_JPRB,0.17824E-01_JPRB,0.19621E-01_JPRB,0.20684E-01_JPRB, &
 & 0.21052E-01_JPRB,0.20616E-01_JPRB,0.19145E-01_JPRB,0.14218E-01_JPRB /)  
KA(:, 3,13, 8) = (/ &
 & 0.86129E-02_JPRB,0.15303E-01_JPRB,0.18197E-01_JPRB,0.20043E-01_JPRB,0.21163E-01_JPRB, &
 & 0.21577E-01_JPRB,0.21143E-01_JPRB,0.19600E-01_JPRB,0.14617E-01_JPRB /)  
KA(:, 4,13, 8) = (/ &
 & 0.86912E-02_JPRB,0.15568E-01_JPRB,0.18565E-01_JPRB,0.20472E-01_JPRB,0.21636E-01_JPRB, &
 & 0.22091E-01_JPRB,0.21674E-01_JPRB,0.20090E-01_JPRB,0.14991E-01_JPRB /)  
KA(:, 5,13, 8) = (/ &
 & 0.87302E-02_JPRB,0.15800E-01_JPRB,0.18917E-01_JPRB,0.20887E-01_JPRB,0.22103E-01_JPRB, &
 & 0.22594E-01_JPRB,0.22198E-01_JPRB,0.20586E-01_JPRB,0.15351E-01_JPRB /)  
KA(:, 1, 1, 9) = (/ &
 & 0.23898E+00_JPRB,0.24353E+00_JPRB,0.26297E+00_JPRB,0.27410E+00_JPRB,0.27635E+00_JPRB, &
 & 0.27151E+00_JPRB,0.26001E+00_JPRB,0.24536E+00_JPRB,0.24840E+00_JPRB /)  
KA(:, 2, 1, 9) = (/ &
 & 0.23703E+00_JPRB,0.24151E+00_JPRB,0.26057E+00_JPRB,0.27148E+00_JPRB,0.27415E+00_JPRB, &
 & 0.26993E+00_JPRB,0.25912E+00_JPRB,0.24520E+00_JPRB,0.24830E+00_JPRB /)  
KA(:, 3, 1, 9) = (/ &
 & 0.23567E+00_JPRB,0.23998E+00_JPRB,0.25868E+00_JPRB,0.26917E+00_JPRB,0.27195E+00_JPRB, &
 & 0.26833E+00_JPRB,0.25809E+00_JPRB,0.24488E+00_JPRB,0.24801E+00_JPRB /)  
KA(:, 4, 1, 9) = (/ &
 & 0.23478E+00_JPRB,0.23885E+00_JPRB,0.25713E+00_JPRB,0.26729E+00_JPRB,0.26990E+00_JPRB, &
 & 0.26662E+00_JPRB,0.25696E+00_JPRB,0.24453E+00_JPRB,0.24772E+00_JPRB /)  
KA(:, 5, 1, 9) = (/ &
 & 0.23430E+00_JPRB,0.23810E+00_JPRB,0.25588E+00_JPRB,0.26568E+00_JPRB,0.26809E+00_JPRB, &
 & 0.26490E+00_JPRB,0.25575E+00_JPRB,0.24412E+00_JPRB,0.24745E+00_JPRB /)  
KA(:, 1, 2, 9) = (/ &
 & 0.22071E+00_JPRB,0.23189E+00_JPRB,0.25280E+00_JPRB,0.26428E+00_JPRB,0.26846E+00_JPRB, &
 & 0.26544E+00_JPRB,0.25423E+00_JPRB,0.23818E+00_JPRB,0.23526E+00_JPRB /)  
KA(:, 2, 2, 9) = (/ &
 & 0.21924E+00_JPRB,0.23025E+00_JPRB,0.25076E+00_JPRB,0.26194E+00_JPRB,0.26631E+00_JPRB, &
 & 0.26393E+00_JPRB,0.25356E+00_JPRB,0.23803E+00_JPRB,0.23534E+00_JPRB /)  
KA(:, 3, 2, 9) = (/ &
 & 0.21843E+00_JPRB,0.22915E+00_JPRB,0.24919E+00_JPRB,0.26005E+00_JPRB,0.26425E+00_JPRB, &
 & 0.26237E+00_JPRB,0.25262E+00_JPRB,0.23788E+00_JPRB,0.23535E+00_JPRB /)  
KA(:, 4, 2, 9) = (/ &
 & 0.21819E+00_JPRB,0.22852E+00_JPRB,0.24801E+00_JPRB,0.25855E+00_JPRB,0.26247E+00_JPRB, &
 & 0.26079E+00_JPRB,0.25163E+00_JPRB,0.23767E+00_JPRB,0.23532E+00_JPRB /)  
KA(:, 5, 2, 9) = (/ &
 & 0.21836E+00_JPRB,0.22826E+00_JPRB,0.24718E+00_JPRB,0.25726E+00_JPRB,0.26101E+00_JPRB, &
 & 0.25924E+00_JPRB,0.25059E+00_JPRB,0.23733E+00_JPRB,0.23520E+00_JPRB /)  
KA(:, 1, 3, 9) = (/ &
 & 0.20172E+00_JPRB,0.21909E+00_JPRB,0.24049E+00_JPRB,0.25259E+00_JPRB,0.25809E+00_JPRB, &
 & 0.25661E+00_JPRB,0.24776E+00_JPRB,0.23048E+00_JPRB,0.22176E+00_JPRB /)  
KA(:, 2, 3, 9) = (/ &
 & 0.20072E+00_JPRB,0.21779E+00_JPRB,0.23872E+00_JPRB,0.25058E+00_JPRB,0.25610E+00_JPRB, &
 & 0.25527E+00_JPRB,0.24712E+00_JPRB,0.23055E+00_JPRB,0.22209E+00_JPRB /)  
KA(:, 3, 3, 9) = (/ &
 & 0.20047E+00_JPRB,0.21708E+00_JPRB,0.23748E+00_JPRB,0.24902E+00_JPRB,0.25438E+00_JPRB, &
 & 0.25391E+00_JPRB,0.24629E+00_JPRB,0.23063E+00_JPRB,0.22233E+00_JPRB /)  
KA(:, 4, 3, 9) = (/ &
 & 0.20080E+00_JPRB,0.21687E+00_JPRB,0.23670E+00_JPRB,0.24777E+00_JPRB,0.25298E+00_JPRB, &
 & 0.25252E+00_JPRB,0.24542E+00_JPRB,0.23053E+00_JPRB,0.22249E+00_JPRB /)  
KA(:, 5, 3, 9) = (/ &
 & 0.20160E+00_JPRB,0.21710E+00_JPRB,0.23623E+00_JPRB,0.24683E+00_JPRB,0.25186E+00_JPRB, &
 & 0.25126E+00_JPRB,0.24453E+00_JPRB,0.23018E+00_JPRB,0.22257E+00_JPRB /)  
KA(:, 1, 4, 9) = (/ &
 & 0.18271E+00_JPRB,0.20499E+00_JPRB,0.22645E+00_JPRB,0.23921E+00_JPRB,0.24553E+00_JPRB, &
 & 0.24573E+00_JPRB,0.23916E+00_JPRB,0.22190E+00_JPRB,0.20803E+00_JPRB /)  
KA(:, 2, 4, 9) = (/ &
 & 0.18212E+00_JPRB,0.20407E+00_JPRB,0.22500E+00_JPRB,0.23755E+00_JPRB,0.24385E+00_JPRB, &
 & 0.24460E+00_JPRB,0.23866E+00_JPRB,0.22223E+00_JPRB,0.20862E+00_JPRB /)  
KA(:, 3, 4, 9) = (/ &
 & 0.18234E+00_JPRB,0.20374E+00_JPRB,0.22412E+00_JPRB,0.23625E+00_JPRB,0.24249E+00_JPRB, &
 & 0.24341E+00_JPRB,0.23801E+00_JPRB,0.22245E+00_JPRB,0.20916E+00_JPRB /)  
KA(:, 4, 4, 9) = (/ &
 & 0.18327E+00_JPRB,0.20396E+00_JPRB,0.22372E+00_JPRB,0.23535E+00_JPRB,0.24149E+00_JPRB, &
 & 0.24231E+00_JPRB,0.23730E+00_JPRB,0.22248E+00_JPRB,0.20951E+00_JPRB /)  
KA(:, 5, 4, 9) = (/ &
 & 0.18465E+00_JPRB,0.20466E+00_JPRB,0.22368E+00_JPRB,0.23479E+00_JPRB,0.24072E+00_JPRB, &
 & 0.24142E+00_JPRB,0.23656E+00_JPRB,0.22226E+00_JPRB,0.20975E+00_JPRB /)  
KA(:, 1, 5, 9) = (/ &
 & 0.16429E+00_JPRB,0.19018E+00_JPRB,0.21120E+00_JPRB,0.22440E+00_JPRB,0.23155E+00_JPRB, &
 & 0.23328E+00_JPRB,0.22834E+00_JPRB,0.21231E+00_JPRB,0.19389E+00_JPRB /)  
KA(:, 2, 5, 9) = (/ &
 & 0.16411E+00_JPRB,0.18954E+00_JPRB,0.21010E+00_JPRB,0.22306E+00_JPRB,0.23026E+00_JPRB, &
 & 0.23235E+00_JPRB,0.22803E+00_JPRB,0.21280E+00_JPRB,0.19477E+00_JPRB /)  
KA(:, 3, 5, 9) = (/ &
 & 0.16481E+00_JPRB,0.18955E+00_JPRB,0.20958E+00_JPRB,0.22215E+00_JPRB,0.22928E+00_JPRB, &
 & 0.23142E+00_JPRB,0.22762E+00_JPRB,0.21318E+00_JPRB,0.19549E+00_JPRB /)  
KA(:, 4, 5, 9) = (/ &
 & 0.16626E+00_JPRB,0.19018E+00_JPRB,0.20952E+00_JPRB,0.22166E+00_JPRB,0.22860E+00_JPRB, &
 & 0.23069E+00_JPRB,0.22713E+00_JPRB,0.21333E+00_JPRB,0.19598E+00_JPRB /)  
KA(:, 5, 5, 9) = (/ &
 & 0.16812E+00_JPRB,0.19134E+00_JPRB,0.20988E+00_JPRB,0.22152E+00_JPRB,0.22816E+00_JPRB, &
 & 0.23013E+00_JPRB,0.22663E+00_JPRB,0.21325E+00_JPRB,0.19645E+00_JPRB /)  
KA(:, 1, 6, 9) = (/ &
 & 0.14677E+00_JPRB,0.17503E+00_JPRB,0.19553E+00_JPRB,0.20871E+00_JPRB,0.21680E+00_JPRB, &
 & 0.21948E+00_JPRB,0.21556E+00_JPRB,0.20158E+00_JPRB,0.17922E+00_JPRB /)  
KA(:, 2, 6, 9) = (/ &
 & 0.14688E+00_JPRB,0.17460E+00_JPRB,0.19479E+00_JPRB,0.20777E+00_JPRB,0.21582E+00_JPRB, &
 & 0.21883E+00_JPRB,0.21549E+00_JPRB,0.20223E+00_JPRB,0.18038E+00_JPRB /)  
KA(:, 3, 6, 9) = (/ &
 & 0.14791E+00_JPRB,0.17490E+00_JPRB,0.19459E+00_JPRB,0.20727E+00_JPRB,0.21519E+00_JPRB, &
 & 0.21822E+00_JPRB,0.21533E+00_JPRB,0.20278E+00_JPRB,0.18127E+00_JPRB /)  
KA(:, 4, 6, 9) = (/ &
 & 0.14970E+00_JPRB,0.17592E+00_JPRB,0.19488E+00_JPRB,0.20713E+00_JPRB,0.21485E+00_JPRB, &
 & 0.21785E+00_JPRB,0.21514E+00_JPRB,0.20305E+00_JPRB,0.18200E+00_JPRB /)  
KA(:, 5, 6, 9) = (/ &
 & 0.15169E+00_JPRB,0.17756E+00_JPRB,0.19568E+00_JPRB,0.20736E+00_JPRB,0.21479E+00_JPRB, &
 & 0.21766E+00_JPRB,0.21494E+00_JPRB,0.20315E+00_JPRB,0.18271E+00_JPRB /)  
KA(:, 1, 7, 9) = (/ &
 & 0.13000E+00_JPRB,0.15987E+00_JPRB,0.17978E+00_JPRB,0.19301E+00_JPRB,0.20129E+00_JPRB, &
 & 0.20436E+00_JPRB,0.20140E+00_JPRB,0.18919E+00_JPRB,0.16414E+00_JPRB /)  
KA(:, 2, 7, 9) = (/ &
 & 0.13035E+00_JPRB,0.15964E+00_JPRB,0.17934E+00_JPRB,0.19244E+00_JPRB,0.20068E+00_JPRB, &
 & 0.20402E+00_JPRB,0.20156E+00_JPRB,0.19006E+00_JPRB,0.16551E+00_JPRB /)  
KA(:, 3, 7, 9) = (/ &
 & 0.13166E+00_JPRB,0.16021E+00_JPRB,0.17944E+00_JPRB,0.19225E+00_JPRB,0.20040E+00_JPRB, &
 & 0.20381E+00_JPRB,0.20166E+00_JPRB,0.19078E+00_JPRB,0.16662E+00_JPRB /)  
KA(:, 4, 7, 9) = (/ &
 & 0.13361E+00_JPRB,0.16157E+00_JPRB,0.18010E+00_JPRB,0.19248E+00_JPRB,0.20041E+00_JPRB, &
 & 0.20379E+00_JPRB,0.20172E+00_JPRB,0.19125E+00_JPRB,0.16758E+00_JPRB /)  
KA(:, 5, 7, 9) = (/ &
 & 0.13554E+00_JPRB,0.16344E+00_JPRB,0.18132E+00_JPRB,0.19308E+00_JPRB,0.20075E+00_JPRB, &
 & 0.20397E+00_JPRB,0.20182E+00_JPRB,0.19159E+00_JPRB,0.16855E+00_JPRB /)  
KA(:, 1, 8, 9) = (/ &
 & 0.11433E+00_JPRB,0.14488E+00_JPRB,0.16431E+00_JPRB,0.17738E+00_JPRB,0.18527E+00_JPRB, &
 & 0.18841E+00_JPRB,0.18617E+00_JPRB,0.17535E+00_JPRB,0.14893E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART6',1,ZHOOK_HANDLE)
END SUBROUTINE PART6


SUBROUTINE PART7

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART7',0,ZHOOK_HANDLE)


KA(:, 2, 8, 9) = (/ &
 & 0.11487E+00_JPRB,0.14487E+00_JPRB,0.16414E+00_JPRB,0.17713E+00_JPRB,0.18501E+00_JPRB, &
 & 0.18837E+00_JPRB,0.18658E+00_JPRB,0.17646E+00_JPRB,0.15049E+00_JPRB /)  
KA(:, 3, 8, 9) = (/ &
 & 0.11635E+00_JPRB,0.14571E+00_JPRB,0.16452E+00_JPRB,0.17724E+00_JPRB,0.18506E+00_JPRB, &
 & 0.18853E+00_JPRB,0.18695E+00_JPRB,0.17741E+00_JPRB,0.15180E+00_JPRB /)  
KA(:, 4, 8, 9) = (/ &
 & 0.11822E+00_JPRB,0.14733E+00_JPRB,0.16549E+00_JPRB,0.17782E+00_JPRB,0.18544E+00_JPRB, &
 & 0.18888E+00_JPRB,0.18734E+00_JPRB,0.17811E+00_JPRB,0.15295E+00_JPRB /)  
KA(:, 5, 8, 9) = (/ &
 & 0.12009E+00_JPRB,0.14924E+00_JPRB,0.16704E+00_JPRB,0.17887E+00_JPRB,0.18614E+00_JPRB, &
 & 0.18940E+00_JPRB,0.18775E+00_JPRB,0.17867E+00_JPRB,0.15411E+00_JPRB /)  
KA(:, 1, 9, 9) = (/ &
 & 0.10002E+00_JPRB,0.13043E+00_JPRB,0.14919E+00_JPRB,0.16171E+00_JPRB,0.16913E+00_JPRB, &
 & 0.17211E+00_JPRB,0.17023E+00_JPRB,0.16067E+00_JPRB,0.13380E+00_JPRB /)  
KA(:, 2, 9, 9) = (/ &
 & 0.10070E+00_JPRB,0.13063E+00_JPRB,0.14927E+00_JPRB,0.16171E+00_JPRB,0.16923E+00_JPRB, &
 & 0.17237E+00_JPRB,0.17091E+00_JPRB,0.16202E+00_JPRB,0.13552E+00_JPRB /)  
KA(:, 3, 9, 9) = (/ &
 & 0.10219E+00_JPRB,0.13166E+00_JPRB,0.14990E+00_JPRB,0.16210E+00_JPRB,0.16959E+00_JPRB, &
 & 0.17285E+00_JPRB,0.17161E+00_JPRB,0.16316E+00_JPRB,0.13700E+00_JPRB /)  
KA(:, 4, 9, 9) = (/ &
 & 0.10390E+00_JPRB,0.13341E+00_JPRB,0.15118E+00_JPRB,0.16299E+00_JPRB,0.17031E+00_JPRB, &
 & 0.17358E+00_JPRB,0.17229E+00_JPRB,0.16405E+00_JPRB,0.13837E+00_JPRB /)  
KA(:, 5, 9, 9) = (/ &
 & 0.10569E+00_JPRB,0.13530E+00_JPRB,0.15298E+00_JPRB,0.16444E+00_JPRB,0.17139E+00_JPRB, &
 & 0.17443E+00_JPRB,0.17301E+00_JPRB,0.16481E+00_JPRB,0.13976E+00_JPRB /)  
KA(:, 1,10, 9) = (/ &
 & 0.87148E-01_JPRB,0.11690E+00_JPRB,0.13450E+00_JPRB,0.14609E+00_JPRB,0.15307E+00_JPRB, &
 & 0.15588E+00_JPRB,0.15420E+00_JPRB,0.14572E+00_JPRB,0.11917E+00_JPRB /)  
KA(:, 2,10, 9) = (/ &
 & 0.87948E-01_JPRB,0.11730E+00_JPRB,0.13485E+00_JPRB,0.14637E+00_JPRB,0.15348E+00_JPRB, &
 & 0.15645E+00_JPRB,0.15513E+00_JPRB,0.14723E+00_JPRB,0.12103E+00_JPRB /)  
KA(:, 3,10, 9) = (/ &
 & 0.89341E-01_JPRB,0.11856E+00_JPRB,0.13575E+00_JPRB,0.14709E+00_JPRB,0.15418E+00_JPRB, &
 & 0.15726E+00_JPRB,0.15609E+00_JPRB,0.14852E+00_JPRB,0.12266E+00_JPRB /)  
KA(:, 4,10, 9) = (/ &
 & 0.90912E-01_JPRB,0.12032E+00_JPRB,0.13733E+00_JPRB,0.14835E+00_JPRB,0.15527E+00_JPRB, &
 & 0.15827E+00_JPRB,0.15702E+00_JPRB,0.14960E+00_JPRB,0.12424E+00_JPRB /)  
KA(:, 5,10, 9) = (/ &
 & 0.92651E-01_JPRB,0.12218E+00_JPRB,0.13930E+00_JPRB,0.15018E+00_JPRB,0.15676E+00_JPRB, &
 & 0.15942E+00_JPRB,0.15802E+00_JPRB,0.15063E+00_JPRB,0.12583E+00_JPRB /)  
KA(:, 1,11, 9) = (/ &
 & 0.75810E-01_JPRB,0.10456E+00_JPRB,0.12069E+00_JPRB,0.13117E+00_JPRB,0.13761E+00_JPRB, &
 & 0.14039E+00_JPRB,0.13895E+00_JPRB,0.13157E+00_JPRB,0.10610E+00_JPRB /)  
KA(:, 2,11, 9) = (/ &
 & 0.76895E-01_JPRB,0.10557E+00_JPRB,0.12151E+00_JPRB,0.13190E+00_JPRB,0.13842E+00_JPRB, &
 & 0.14134E+00_JPRB,0.14014E+00_JPRB,0.13312E+00_JPRB,0.10796E+00_JPRB /)  
KA(:, 3,11, 9) = (/ &
 & 0.78244E-01_JPRB,0.10718E+00_JPRB,0.12298E+00_JPRB,0.13318E+00_JPRB,0.13962E+00_JPRB, &
 & 0.14250E+00_JPRB,0.14130E+00_JPRB,0.13446E+00_JPRB,0.10971E+00_JPRB /)  
KA(:, 4,11, 9) = (/ &
 & 0.79823E-01_JPRB,0.10896E+00_JPRB,0.12491E+00_JPRB,0.13508E+00_JPRB,0.14123E+00_JPRB, &
 & 0.14382E+00_JPRB,0.14250E+00_JPRB,0.13575E+00_JPRB,0.11145E+00_JPRB /)  
KA(:, 5,11, 9) = (/ &
 & 0.81587E-01_JPRB,0.11081E+00_JPRB,0.12696E+00_JPRB,0.13729E+00_JPRB,0.14323E+00_JPRB, &
 & 0.14541E+00_JPRB,0.14385E+00_JPRB,0.13708E+00_JPRB,0.11322E+00_JPRB /)  
KA(:, 1,12, 9) = (/ &
 & 0.65751E-01_JPRB,0.93358E-01_JPRB,0.10793E+00_JPRB,0.11727E+00_JPRB,0.12307E+00_JPRB, &
 & 0.12565E+00_JPRB,0.12447E+00_JPRB,0.11782E+00_JPRB,0.93944E-01_JPRB /)  
KA(:, 2,12, 9) = (/ &
 & 0.66851E-01_JPRB,0.94791E-01_JPRB,0.10927E+00_JPRB,0.11849E+00_JPRB,0.12430E+00_JPRB, &
 & 0.12692E+00_JPRB,0.12584E+00_JPRB,0.11940E+00_JPRB,0.95825E-01_JPRB /)  
KA(:, 3,12, 9) = (/ &
 & 0.68215E-01_JPRB,0.96468E-01_JPRB,0.11113E+00_JPRB,0.12035E+00_JPRB,0.12596E+00_JPRB, &
 & 0.12837E+00_JPRB,0.12723E+00_JPRB,0.12088E+00_JPRB,0.97697E-01_JPRB /)  
KA(:, 4,12, 9) = (/ &
 & 0.69822E-01_JPRB,0.98288E-01_JPRB,0.11318E+00_JPRB,0.12260E+00_JPRB,0.12800E+00_JPRB, &
 & 0.13009E+00_JPRB,0.12875E+00_JPRB,0.12246E+00_JPRB,0.99558E-01_JPRB /)  
KA(:, 5,12, 9) = (/ &
 & 0.71562E-01_JPRB,0.10021E+00_JPRB,0.11536E+00_JPRB,0.12491E+00_JPRB,0.13035E+00_JPRB, &
 & 0.13218E+00_JPRB,0.13049E+00_JPRB,0.12412E+00_JPRB,0.10142E+00_JPRB /)  
KA(:, 1,13, 9) = (/ &
 & 0.56716E-01_JPRB,0.83175E-01_JPRB,0.96227E-01_JPRB,0.10452E+00_JPRB,0.10961E+00_JPRB, &
 & 0.11186E+00_JPRB,0.11078E+00_JPRB,0.10487E+00_JPRB,0.82822E-01_JPRB /)  
KA(:, 2,13, 9) = (/ &
 & 0.57829E-01_JPRB,0.84711E-01_JPRB,0.97973E-01_JPRB,0.10625E+00_JPRB,0.11123E+00_JPRB, &
 & 0.11339E+00_JPRB,0.11236E+00_JPRB,0.10648E+00_JPRB,0.84781E-01_JPRB /)  
KA(:, 3,13, 9) = (/ &
 & 0.59231E-01_JPRB,0.86426E-01_JPRB,0.99996E-01_JPRB,0.10847E+00_JPRB,0.11329E+00_JPRB, &
 & 0.11518E+00_JPRB,0.11401E+00_JPRB,0.10821E+00_JPRB,0.86727E-01_JPRB /)  
KA(:, 4,13, 9) = (/ &
 & 0.60793E-01_JPRB,0.88335E-01_JPRB,0.10220E+00_JPRB,0.11080E+00_JPRB,0.11568E+00_JPRB, &
 & 0.11734E+00_JPRB,0.11592E+00_JPRB,0.11003E+00_JPRB,0.88652E-01_JPRB /)  
KA(:, 5,13, 9) = (/ &
 & 0.62288E-01_JPRB,0.90379E-01_JPRB,0.10449E+00_JPRB,0.11321E+00_JPRB,0.11819E+00_JPRB, &
 & 0.11985E+00_JPRB,0.11808E+00_JPRB,0.11193E+00_JPRB,0.90608E-01_JPRB /)  
KA(:, 1, 1,10) = (/ &
 & 0.73370E+00_JPRB,0.66239E+00_JPRB,0.64754E+00_JPRB,0.65671E+00_JPRB,0.64798E+00_JPRB, &
 & 0.62443E+00_JPRB,0.62156E+00_JPRB,0.59642E+00_JPRB,0.65694E+00_JPRB /)  
KA(:, 2, 1,10) = (/ &
 & 0.72227E+00_JPRB,0.65245E+00_JPRB,0.64115E+00_JPRB,0.65244E+00_JPRB,0.64519E+00_JPRB, &
 & 0.62272E+00_JPRB,0.62178E+00_JPRB,0.59807E+00_JPRB,0.65734E+00_JPRB /)  
KA(:, 3, 1,10) = (/ &
 & 0.71096E+00_JPRB,0.64287E+00_JPRB,0.63490E+00_JPRB,0.64719E+00_JPRB,0.64246E+00_JPRB, &
 & 0.61928E+00_JPRB,0.62164E+00_JPRB,0.59971E+00_JPRB,0.65975E+00_JPRB /)  
KA(:, 4, 1,10) = (/ &
 & 0.69997E+00_JPRB,0.63340E+00_JPRB,0.62893E+00_JPRB,0.64188E+00_JPRB,0.63859E+00_JPRB, &
 & 0.61601E+00_JPRB,0.62127E+00_JPRB,0.59924E+00_JPRB,0.66003E+00_JPRB /)  
KA(:, 5, 1,10) = (/ &
 & 0.68921E+00_JPRB,0.62412E+00_JPRB,0.62274E+00_JPRB,0.63660E+00_JPRB,0.63341E+00_JPRB, &
 & 0.61371E+00_JPRB,0.61976E+00_JPRB,0.59796E+00_JPRB,0.65874E+00_JPRB /)  
KA(:, 1, 2,10) = (/ &
 & 0.71435E+00_JPRB,0.65898E+00_JPRB,0.65791E+00_JPRB,0.67621E+00_JPRB,0.66803E+00_JPRB, &
 & 0.63952E+00_JPRB,0.62227E+00_JPRB,0.60345E+00_JPRB,0.64341E+00_JPRB /)  
KA(:, 2, 2,10) = (/ &
 & 0.70295E+00_JPRB,0.64927E+00_JPRB,0.65209E+00_JPRB,0.67168E+00_JPRB,0.66601E+00_JPRB, &
 & 0.63761E+00_JPRB,0.62183E+00_JPRB,0.60472E+00_JPRB,0.64489E+00_JPRB /)  
KA(:, 3, 2,10) = (/ &
 & 0.69214E+00_JPRB,0.64012E+00_JPRB,0.64637E+00_JPRB,0.66639E+00_JPRB,0.66353E+00_JPRB, &
 & 0.63487E+00_JPRB,0.62217E+00_JPRB,0.60467E+00_JPRB,0.64521E+00_JPRB /)  
KA(:, 4, 2,10) = (/ &
 & 0.68145E+00_JPRB,0.63089E+00_JPRB,0.64022E+00_JPRB,0.66099E+00_JPRB,0.65898E+00_JPRB, &
 & 0.63312E+00_JPRB,0.62106E+00_JPRB,0.60298E+00_JPRB,0.64380E+00_JPRB /)  
KA(:, 5, 2,10) = (/ &
 & 0.67068E+00_JPRB,0.62208E+00_JPRB,0.63390E+00_JPRB,0.65546E+00_JPRB,0.65376E+00_JPRB, &
 & 0.63122E+00_JPRB,0.61818E+00_JPRB,0.60158E+00_JPRB,0.64256E+00_JPRB /)  
KA(:, 1, 3,10) = (/ &
 & 0.68340E+00_JPRB,0.64482E+00_JPRB,0.66290E+00_JPRB,0.68284E+00_JPRB,0.67896E+00_JPRB, &
 & 0.65800E+00_JPRB,0.61589E+00_JPRB,0.60026E+00_JPRB,0.62209E+00_JPRB /)  
KA(:, 2, 3,10) = (/ &
 & 0.67251E+00_JPRB,0.63550E+00_JPRB,0.65818E+00_JPRB,0.67891E+00_JPRB,0.67722E+00_JPRB, &
 & 0.65575E+00_JPRB,0.61745E+00_JPRB,0.60017E+00_JPRB,0.62247E+00_JPRB /)  
KA(:, 3, 3,10) = (/ &
 & 0.66182E+00_JPRB,0.62604E+00_JPRB,0.65231E+00_JPRB,0.67447E+00_JPRB,0.67369E+00_JPRB, &
 & 0.65314E+00_JPRB,0.61804E+00_JPRB,0.59851E+00_JPRB,0.62084E+00_JPRB /)  
KA(:, 4, 3,10) = (/ &
 & 0.65114E+00_JPRB,0.61727E+00_JPRB,0.64569E+00_JPRB,0.67007E+00_JPRB,0.66854E+00_JPRB, &
 & 0.65146E+00_JPRB,0.61713E+00_JPRB,0.59641E+00_JPRB,0.61922E+00_JPRB /)  
KA(:, 5, 3,10) = (/ &
 & 0.64110E+00_JPRB,0.60881E+00_JPRB,0.63926E+00_JPRB,0.66468E+00_JPRB,0.66347E+00_JPRB, &
 & 0.64931E+00_JPRB,0.61433E+00_JPRB,0.59600E+00_JPRB,0.61885E+00_JPRB /)  
KA(:, 1, 4,10) = (/ &
 & 0.64233E+00_JPRB,0.62207E+00_JPRB,0.65747E+00_JPRB,0.67845E+00_JPRB,0.68170E+00_JPRB, &
 & 0.66374E+00_JPRB,0.61548E+00_JPRB,0.59270E+00_JPRB,0.60473E+00_JPRB /)  
KA(:, 2, 4,10) = (/ &
 & 0.63185E+00_JPRB,0.61324E+00_JPRB,0.65237E+00_JPRB,0.67473E+00_JPRB,0.67959E+00_JPRB, &
 & 0.66215E+00_JPRB,0.61741E+00_JPRB,0.59134E+00_JPRB,0.60361E+00_JPRB /)  
KA(:, 3, 4,10) = (/ &
 & 0.62122E+00_JPRB,0.60440E+00_JPRB,0.64660E+00_JPRB,0.67096E+00_JPRB,0.67570E+00_JPRB, &
 & 0.66004E+00_JPRB,0.61834E+00_JPRB,0.58886E+00_JPRB,0.60079E+00_JPRB /)  
KA(:, 4, 4,10) = (/ &
 & 0.61111E+00_JPRB,0.59616E+00_JPRB,0.64034E+00_JPRB,0.66675E+00_JPRB,0.67073E+00_JPRB, &
 & 0.65786E+00_JPRB,0.61721E+00_JPRB,0.58692E+00_JPRB,0.59978E+00_JPRB /)  
KA(:, 5, 4,10) = (/ &
 & 0.60223E+00_JPRB,0.58851E+00_JPRB,0.63401E+00_JPRB,0.66136E+00_JPRB,0.66631E+00_JPRB, &
 & 0.65503E+00_JPRB,0.61469E+00_JPRB,0.58697E+00_JPRB,0.60040E+00_JPRB /)  
KA(:, 1, 5,10) = (/ &
 & 0.59185E+00_JPRB,0.59370E+00_JPRB,0.63992E+00_JPRB,0.66463E+00_JPRB,0.67279E+00_JPRB, &
 & 0.65610E+00_JPRB,0.61852E+00_JPRB,0.58331E+00_JPRB,0.58763E+00_JPRB /)  
KA(:, 2, 5,10) = (/ &
 & 0.58158E+00_JPRB,0.58584E+00_JPRB,0.63500E+00_JPRB,0.66123E+00_JPRB,0.67045E+00_JPRB, &
 & 0.65504E+00_JPRB,0.62015E+00_JPRB,0.58225E+00_JPRB,0.58623E+00_JPRB /)  
KA(:, 3, 5,10) = (/ &
 & 0.57197E+00_JPRB,0.57827E+00_JPRB,0.62932E+00_JPRB,0.65791E+00_JPRB,0.66630E+00_JPRB, &
 & 0.65353E+00_JPRB,0.61959E+00_JPRB,0.58025E+00_JPRB,0.58483E+00_JPRB /)  
KA(:, 4, 5,10) = (/ &
 & 0.56277E+00_JPRB,0.57099E+00_JPRB,0.62369E+00_JPRB,0.65326E+00_JPRB,0.66229E+00_JPRB, &
 & 0.65156E+00_JPRB,0.61745E+00_JPRB,0.57913E+00_JPRB,0.58544E+00_JPRB /)  
KA(:, 5, 5,10) = (/ &
 & 0.55581E+00_JPRB,0.56431E+00_JPRB,0.61807E+00_JPRB,0.64784E+00_JPRB,0.65855E+00_JPRB, &
 & 0.64845E+00_JPRB,0.61479E+00_JPRB,0.57987E+00_JPRB,0.58646E+00_JPRB /)  
KA(:, 1, 6,10) = (/ &
 & 0.53954E+00_JPRB,0.56255E+00_JPRB,0.61290E+00_JPRB,0.64303E+00_JPRB,0.64974E+00_JPRB, &
 & 0.64176E+00_JPRB,0.61714E+00_JPRB,0.56940E+00_JPRB,0.56484E+00_JPRB /)  
KA(:, 2, 6,10) = (/ &
 & 0.53060E+00_JPRB,0.55651E+00_JPRB,0.60789E+00_JPRB,0.63988E+00_JPRB,0.64820E+00_JPRB, &
 & 0.64042E+00_JPRB,0.61834E+00_JPRB,0.56932E+00_JPRB,0.56418E+00_JPRB /)  
KA(:, 3, 6,10) = (/ &
 & 0.52216E+00_JPRB,0.54988E+00_JPRB,0.60294E+00_JPRB,0.63619E+00_JPRB,0.64521E+00_JPRB, &
 & 0.63878E+00_JPRB,0.61726E+00_JPRB,0.56850E+00_JPRB,0.56474E+00_JPRB /)  
KA(:, 4, 6,10) = (/ &
 & 0.51474E+00_JPRB,0.54331E+00_JPRB,0.59815E+00_JPRB,0.63165E+00_JPRB,0.64200E+00_JPRB, &
 & 0.63625E+00_JPRB,0.61431E+00_JPRB,0.56860E+00_JPRB,0.56684E+00_JPRB /)  
KA(:, 5, 6,10) = (/ &
 & 0.51206E+00_JPRB,0.53704E+00_JPRB,0.59303E+00_JPRB,0.62695E+00_JPRB,0.63853E+00_JPRB, &
 & 0.63290E+00_JPRB,0.61169E+00_JPRB,0.57018E+00_JPRB,0.56804E+00_JPRB /)  
KA(:, 1, 7,10) = (/ &
 & 0.49102E+00_JPRB,0.52896E+00_JPRB,0.58005E+00_JPRB,0.60940E+00_JPRB,0.62179E+00_JPRB, &
 & 0.62452E+00_JPRB,0.60693E+00_JPRB,0.55666E+00_JPRB,0.53830E+00_JPRB /)  
KA(:, 2, 7,10) = (/ &
 & 0.48351E+00_JPRB,0.52394E+00_JPRB,0.57551E+00_JPRB,0.60647E+00_JPRB,0.62043E+00_JPRB, &
 & 0.62318E+00_JPRB,0.60808E+00_JPRB,0.55693E+00_JPRB,0.53902E+00_JPRB /)  
KA(:, 3, 7,10) = (/ &
 & 0.47604E+00_JPRB,0.51848E+00_JPRB,0.57124E+00_JPRB,0.60324E+00_JPRB,0.61835E+00_JPRB, &
 & 0.62080E+00_JPRB,0.60698E+00_JPRB,0.55691E+00_JPRB,0.54116E+00_JPRB /)  
KA(:, 4, 7,10) = (/ &
 & 0.47121E+00_JPRB,0.51294E+00_JPRB,0.56659E+00_JPRB,0.59937E+00_JPRB,0.61527E+00_JPRB, &
 & 0.61807E+00_JPRB,0.60502E+00_JPRB,0.55819E+00_JPRB,0.54361E+00_JPRB /)  
KA(:, 5, 7,10) = (/ &
 & 0.47306E+00_JPRB,0.50884E+00_JPRB,0.56199E+00_JPRB,0.59548E+00_JPRB,0.61135E+00_JPRB, &
 & 0.61474E+00_JPRB,0.60372E+00_JPRB,0.56024E+00_JPRB,0.54444E+00_JPRB /)  
KA(:, 1, 8,10) = (/ &
 & 0.44396E+00_JPRB,0.49532E+00_JPRB,0.54249E+00_JPRB,0.57145E+00_JPRB,0.59186E+00_JPRB, &
 & 0.60060E+00_JPRB,0.58785E+00_JPRB,0.54441E+00_JPRB,0.50913E+00_JPRB /)  
KA(:, 2, 8,10) = (/ &
 & 0.43707E+00_JPRB,0.49048E+00_JPRB,0.53914E+00_JPRB,0.56868E+00_JPRB,0.59107E+00_JPRB, &
 & 0.60049E+00_JPRB,0.58883E+00_JPRB,0.54507E+00_JPRB,0.51101E+00_JPRB /)  
KA(:, 3, 8,10) = (/ &
 & 0.43098E+00_JPRB,0.48531E+00_JPRB,0.53541E+00_JPRB,0.56592E+00_JPRB,0.58911E+00_JPRB, &
 & 0.59846E+00_JPRB,0.58812E+00_JPRB,0.54578E+00_JPRB,0.51441E+00_JPRB /)  
KA(:, 4, 8,10) = (/ &
 & 0.42957E+00_JPRB,0.48093E+00_JPRB,0.53173E+00_JPRB,0.56262E+00_JPRB,0.58636E+00_JPRB, &
 & 0.59589E+00_JPRB,0.58708E+00_JPRB,0.54776E+00_JPRB,0.51773E+00_JPRB /)  
KA(:, 5, 8,10) = (/ &
 & 0.43487E+00_JPRB,0.48035E+00_JPRB,0.52822E+00_JPRB,0.55903E+00_JPRB,0.58272E+00_JPRB, &
 & 0.59353E+00_JPRB,0.58697E+00_JPRB,0.54985E+00_JPRB,0.51918E+00_JPRB /)  
KA(:, 1, 9,10) = (/ &
 & 0.39531E+00_JPRB,0.46021E+00_JPRB,0.50510E+00_JPRB,0.53588E+00_JPRB,0.55895E+00_JPRB, &
 & 0.56979E+00_JPRB,0.56191E+00_JPRB,0.52659E+00_JPRB,0.47758E+00_JPRB /)  
KA(:, 2, 9,10) = (/ &
 & 0.38905E+00_JPRB,0.45517E+00_JPRB,0.50180E+00_JPRB,0.53416E+00_JPRB,0.55846E+00_JPRB, &
 & 0.57047E+00_JPRB,0.56355E+00_JPRB,0.52717E+00_JPRB,0.48088E+00_JPRB /)  
KA(:, 3, 9,10) = (/ &
 & 0.38493E+00_JPRB,0.45067E+00_JPRB,0.49854E+00_JPRB,0.53220E+00_JPRB,0.55699E+00_JPRB, &
 & 0.56934E+00_JPRB,0.56332E+00_JPRB,0.52868E+00_JPRB,0.48536E+00_JPRB /)  
KA(:, 4, 9,10) = (/ &
 & 0.38723E+00_JPRB,0.44786E+00_JPRB,0.49546E+00_JPRB,0.52928E+00_JPRB,0.55471E+00_JPRB, &
 & 0.56730E+00_JPRB,0.56372E+00_JPRB,0.53178E+00_JPRB,0.48902E+00_JPRB /)  
KA(:, 5, 9,10) = (/ &
 & 0.39433E+00_JPRB,0.45054E+00_JPRB,0.49350E+00_JPRB,0.52621E+00_JPRB,0.55192E+00_JPRB, &
 & 0.56604E+00_JPRB,0.56481E+00_JPRB,0.53491E+00_JPRB,0.49067E+00_JPRB /)  
KA(:, 1,10,10) = (/ &
 & 0.34716E+00_JPRB,0.41992E+00_JPRB,0.46841E+00_JPRB,0.50264E+00_JPRB,0.52377E+00_JPRB, &
 & 0.53462E+00_JPRB,0.53096E+00_JPRB,0.50215E+00_JPRB,0.44481E+00_JPRB /)  
KA(:, 2,10,10) = (/ &
 & 0.34195E+00_JPRB,0.41601E+00_JPRB,0.46506E+00_JPRB,0.50165E+00_JPRB,0.52385E+00_JPRB, &
 & 0.53574E+00_JPRB,0.53310E+00_JPRB,0.50401E+00_JPRB,0.44924E+00_JPRB /)  
KA(:, 3,10,10) = (/ &
 & 0.34072E+00_JPRB,0.41255E+00_JPRB,0.46265E+00_JPRB,0.50007E+00_JPRB,0.52273E+00_JPRB, &
 & 0.53553E+00_JPRB,0.53434E+00_JPRB,0.50668E+00_JPRB,0.45414E+00_JPRB /)  
KA(:, 4,10,10) = (/ &
 & 0.34572E+00_JPRB,0.41258E+00_JPRB,0.46029E+00_JPRB,0.49770E+00_JPRB,0.52100E+00_JPRB, &
 & 0.53482E+00_JPRB,0.53633E+00_JPRB,0.51056E+00_JPRB,0.45768E+00_JPRB /)  
KA(:, 5,10,10) = (/ &
 & 0.35242E+00_JPRB,0.41826E+00_JPRB,0.46028E+00_JPRB,0.49520E+00_JPRB,0.51927E+00_JPRB, &
 & 0.53500E+00_JPRB,0.53892E+00_JPRB,0.51405E+00_JPRB,0.45947E+00_JPRB /)  
KA(:, 1,11,10) = (/ &
 & 0.30160E+00_JPRB,0.37714E+00_JPRB,0.42971E+00_JPRB,0.46717E+00_JPRB,0.48926E+00_JPRB, &
 & 0.49871E+00_JPRB,0.49756E+00_JPRB,0.47436E+00_JPRB,0.41261E+00_JPRB /)  
KA(:, 2,11,10) = (/ &
 & 0.29962E+00_JPRB,0.37395E+00_JPRB,0.42779E+00_JPRB,0.46654E+00_JPRB,0.48929E+00_JPRB, &
 & 0.49998E+00_JPRB,0.50016E+00_JPRB,0.47769E+00_JPRB,0.41819E+00_JPRB /)  
KA(:, 3,11,10) = (/ &
 & 0.30371E+00_JPRB,0.37339E+00_JPRB,0.42611E+00_JPRB,0.46502E+00_JPRB,0.48821E+00_JPRB, &
 & 0.50080E+00_JPRB,0.50323E+00_JPRB,0.48215E+00_JPRB,0.42266E+00_JPRB /)  
KA(:, 4,11,10) = (/ &
 & 0.30955E+00_JPRB,0.37857E+00_JPRB,0.42639E+00_JPRB,0.46320E+00_JPRB,0.48745E+00_JPRB, &
 & 0.50213E+00_JPRB,0.50694E+00_JPRB,0.48639E+00_JPRB,0.42570E+00_JPRB /)  
KA(:, 5,11,10) = (/ &
 & 0.31511E+00_JPRB,0.38606E+00_JPRB,0.43107E+00_JPRB,0.46346E+00_JPRB,0.48731E+00_JPRB, &
 & 0.50398E+00_JPRB,0.50975E+00_JPRB,0.48945E+00_JPRB,0.42790E+00_JPRB /)  
KA(:, 1,12,10) = (/ &
 & 0.26311E+00_JPRB,0.33847E+00_JPRB,0.39159E+00_JPRB,0.42993E+00_JPRB,0.45370E+00_JPRB, &
 & 0.46372E+00_JPRB,0.46279E+00_JPRB,0.44427E+00_JPRB,0.37907E+00_JPRB /)  
KA(:, 2,12,10) = (/ &
 & 0.26583E+00_JPRB,0.33679E+00_JPRB,0.39073E+00_JPRB,0.42938E+00_JPRB,0.45415E+00_JPRB, &
 & 0.46569E+00_JPRB,0.46639E+00_JPRB,0.44945E+00_JPRB,0.38485E+00_JPRB /)  
KA(:, 3,12,10) = (/ &
 & 0.27082E+00_JPRB,0.34071E+00_JPRB,0.39077E+00_JPRB,0.42842E+00_JPRB,0.45412E+00_JPRB, &
 & 0.46820E+00_JPRB,0.47089E+00_JPRB,0.45477E+00_JPRB,0.38900E+00_JPRB /)  
KA(:, 4,12,10) = (/ &
 & 0.27574E+00_JPRB,0.34733E+00_JPRB,0.39532E+00_JPRB,0.42923E+00_JPRB,0.45504E+00_JPRB, &
 & 0.47097E+00_JPRB,0.47486E+00_JPRB,0.45848E+00_JPRB,0.39247E+00_JPRB /)  
KA(:, 5,12,10) = (/ &
 & 0.28099E+00_JPRB,0.35386E+00_JPRB,0.40190E+00_JPRB,0.43447E+00_JPRB,0.45757E+00_JPRB, &
 & 0.47294E+00_JPRB,0.47760E+00_JPRB,0.46125E+00_JPRB,0.39629E+00_JPRB /)  
KA(:, 1,13,10) = (/ &
 & 0.23133E+00_JPRB,0.30448E+00_JPRB,0.35592E+00_JPRB,0.39245E+00_JPRB,0.41703E+00_JPRB, &
 & 0.42944E+00_JPRB,0.42838E+00_JPRB,0.41191E+00_JPRB,0.34405E+00_JPRB /)  
KA(:, 2,13,10) = (/ &
 & 0.23569E+00_JPRB,0.30675E+00_JPRB,0.35574E+00_JPRB,0.39238E+00_JPRB,0.41854E+00_JPRB, &
 & 0.43261E+00_JPRB,0.43319E+00_JPRB,0.41851E+00_JPRB,0.34979E+00_JPRB /)  
KA(:, 3,13,10) = (/ &
 & 0.23995E+00_JPRB,0.31287E+00_JPRB,0.35958E+00_JPRB,0.39339E+00_JPRB,0.42025E+00_JPRB, &
 & 0.43649E+00_JPRB,0.43814E+00_JPRB,0.42387E+00_JPRB,0.35427E+00_JPRB /)  
KA(:, 4,13,10) = (/ &
 & 0.24491E+00_JPRB,0.31868E+00_JPRB,0.36597E+00_JPRB,0.39887E+00_JPRB,0.42348E+00_JPRB, &
 & 0.43960E+00_JPRB,0.44180E+00_JPRB,0.42781E+00_JPRB,0.35946E+00_JPRB /)  
KA(:, 5,13,10) = (/ &
 & 0.25204E+00_JPRB,0.32443E+00_JPRB,0.37244E+00_JPRB,0.40709E+00_JPRB,0.42924E+00_JPRB, &
 & 0.44176E+00_JPRB,0.44465E+00_JPRB,0.43196E+00_JPRB,0.36481E+00_JPRB /)  
KA(:, 1, 1,11) = (/ &
 & 0.10293E+01_JPRB,0.90445E+00_JPRB,0.86137E+00_JPRB,0.83022E+00_JPRB,0.84086E+00_JPRB, &
 & 0.86548E+00_JPRB,0.85587E+00_JPRB,0.85325E+00_JPRB,0.97261E+00_JPRB /)  
KA(:, 2, 1,11) = (/ &
 & 0.10191E+01_JPRB,0.89556E+00_JPRB,0.85472E+00_JPRB,0.82839E+00_JPRB,0.83827E+00_JPRB, &
 & 0.86712E+00_JPRB,0.85626E+00_JPRB,0.85096E+00_JPRB,0.97088E+00_JPRB /)  
KA(:, 3, 1,11) = (/ &
 & 0.10070E+01_JPRB,0.88513E+00_JPRB,0.84750E+00_JPRB,0.82570E+00_JPRB,0.83354E+00_JPRB, &
 & 0.86668E+00_JPRB,0.85692E+00_JPRB,0.84837E+00_JPRB,0.96710E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART7',1,ZHOOK_HANDLE)
END SUBROUTINE PART7


SUBROUTINE PART8

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART8',0,ZHOOK_HANDLE)


KA(:, 4, 1,11) = (/ &
 & 0.99477E+00_JPRB,0.87449E+00_JPRB,0.83958E+00_JPRB,0.82146E+00_JPRB,0.82897E+00_JPRB, &
 & 0.86436E+00_JPRB,0.85744E+00_JPRB,0.84703E+00_JPRB,0.96450E+00_JPRB /)  
KA(:, 5, 1,11) = (/ &
 & 0.98126E+00_JPRB,0.86272E+00_JPRB,0.83128E+00_JPRB,0.81555E+00_JPRB,0.82401E+00_JPRB, &
 & 0.85929E+00_JPRB,0.85825E+00_JPRB,0.84707E+00_JPRB,0.96358E+00_JPRB /)  
KA(:, 1, 2,11) = (/ &
 & 0.10475E+01_JPRB,0.93151E+00_JPRB,0.89830E+00_JPRB,0.88420E+00_JPRB,0.87933E+00_JPRB, &
 & 0.87846E+00_JPRB,0.87987E+00_JPRB,0.86086E+00_JPRB,0.97265E+00_JPRB /)  
KA(:, 2, 2,11) = (/ &
 & 0.10370E+01_JPRB,0.92196E+00_JPRB,0.89215E+00_JPRB,0.88284E+00_JPRB,0.87783E+00_JPRB, &
 & 0.88073E+00_JPRB,0.88059E+00_JPRB,0.85882E+00_JPRB,0.96972E+00_JPRB /)  
KA(:, 3, 2,11) = (/ &
 & 0.10244E+01_JPRB,0.91082E+00_JPRB,0.88511E+00_JPRB,0.87976E+00_JPRB,0.87455E+00_JPRB, &
 & 0.88046E+00_JPRB,0.88070E+00_JPRB,0.85623E+00_JPRB,0.96599E+00_JPRB /)  
KA(:, 4, 2,11) = (/ &
 & 0.10111E+01_JPRB,0.89911E+00_JPRB,0.87761E+00_JPRB,0.87481E+00_JPRB,0.87132E+00_JPRB, &
 & 0.87692E+00_JPRB,0.88074E+00_JPRB,0.85652E+00_JPRB,0.96500E+00_JPRB /)  
KA(:, 5, 2,11) = (/ &
 & 0.99734E+00_JPRB,0.88696E+00_JPRB,0.86940E+00_JPRB,0.86908E+00_JPRB,0.86706E+00_JPRB, &
 & 0.87191E+00_JPRB,0.88156E+00_JPRB,0.85742E+00_JPRB,0.96567E+00_JPRB /)  
KA(:, 1, 3,11) = (/ &
 & 0.10481E+01_JPRB,0.94949E+00_JPRB,0.92754E+00_JPRB,0.93134E+00_JPRB,0.92020E+00_JPRB, &
 & 0.88963E+00_JPRB,0.89353E+00_JPRB,0.87368E+00_JPRB,0.96341E+00_JPRB /)  
KA(:, 2, 3,11) = (/ &
 & 0.10364E+01_JPRB,0.93961E+00_JPRB,0.92141E+00_JPRB,0.92962E+00_JPRB,0.91951E+00_JPRB, &
 & 0.89266E+00_JPRB,0.89347E+00_JPRB,0.87218E+00_JPRB,0.95995E+00_JPRB /)  
KA(:, 3, 3,11) = (/ &
 & 0.10237E+01_JPRB,0.92877E+00_JPRB,0.91434E+00_JPRB,0.92574E+00_JPRB,0.91740E+00_JPRB, &
 & 0.89302E+00_JPRB,0.89281E+00_JPRB,0.87167E+00_JPRB,0.95907E+00_JPRB /)  
KA(:, 4, 3,11) = (/ &
 & 0.10107E+01_JPRB,0.91711E+00_JPRB,0.90716E+00_JPRB,0.92023E+00_JPRB,0.91517E+00_JPRB, &
 & 0.89037E+00_JPRB,0.89222E+00_JPRB,0.87266E+00_JPRB,0.95928E+00_JPRB /)  
KA(:, 5, 3,11) = (/ &
 & 0.99633E+00_JPRB,0.90470E+00_JPRB,0.89927E+00_JPRB,0.91439E+00_JPRB,0.91120E+00_JPRB, &
 & 0.88600E+00_JPRB,0.89266E+00_JPRB,0.87273E+00_JPRB,0.95886E+00_JPRB /)  
KA(:, 1, 4,11) = (/ &
 & 0.10264E+01_JPRB,0.95071E+00_JPRB,0.94674E+00_JPRB,0.96322E+00_JPRB,0.95099E+00_JPRB, &
 & 0.91374E+00_JPRB,0.89446E+00_JPRB,0.87855E+00_JPRB,0.93628E+00_JPRB /)  
KA(:, 2, 4,11) = (/ &
 & 0.10149E+01_JPRB,0.94036E+00_JPRB,0.94196E+00_JPRB,0.96089E+00_JPRB,0.95153E+00_JPRB, &
 & 0.91752E+00_JPRB,0.89401E+00_JPRB,0.87842E+00_JPRB,0.93496E+00_JPRB /)  
KA(:, 3, 4,11) = (/ &
 & 0.10022E+01_JPRB,0.92957E+00_JPRB,0.93566E+00_JPRB,0.95688E+00_JPRB,0.95066E+00_JPRB, &
 & 0.91784E+00_JPRB,0.89284E+00_JPRB,0.87926E+00_JPRB,0.93586E+00_JPRB /)  
KA(:, 4, 4,11) = (/ &
 & 0.98847E+00_JPRB,0.91773E+00_JPRB,0.92854E+00_JPRB,0.95134E+00_JPRB,0.94862E+00_JPRB, &
 & 0.91547E+00_JPRB,0.89366E+00_JPRB,0.87951E+00_JPRB,0.93591E+00_JPRB /)  
KA(:, 5, 4,11) = (/ &
 & 0.97390E+00_JPRB,0.90550E+00_JPRB,0.92045E+00_JPRB,0.94604E+00_JPRB,0.94431E+00_JPRB, &
 & 0.91218E+00_JPRB,0.89395E+00_JPRB,0.87858E+00_JPRB,0.93476E+00_JPRB /)  
KA(:, 1, 5,11) = (/ &
 & 0.98609E+00_JPRB,0.93424E+00_JPRB,0.95643E+00_JPRB,0.97684E+00_JPRB,0.96999E+00_JPRB, &
 & 0.93774E+00_JPRB,0.88693E+00_JPRB,0.86915E+00_JPRB,0.90145E+00_JPRB /)  
KA(:, 2, 5,11) = (/ &
 & 0.97412E+00_JPRB,0.92401E+00_JPRB,0.95137E+00_JPRB,0.97507E+00_JPRB,0.97005E+00_JPRB, &
 & 0.94299E+00_JPRB,0.88698E+00_JPRB,0.86947E+00_JPRB,0.90218E+00_JPRB /)  
KA(:, 3, 5,11) = (/ &
 & 0.96114E+00_JPRB,0.91242E+00_JPRB,0.94531E+00_JPRB,0.97096E+00_JPRB,0.96958E+00_JPRB, &
 & 0.94325E+00_JPRB,0.88812E+00_JPRB,0.86965E+00_JPRB,0.90220E+00_JPRB /)  
KA(:, 4, 5,11) = (/ &
 & 0.94742E+00_JPRB,0.90067E+00_JPRB,0.93796E+00_JPRB,0.96622E+00_JPRB,0.96802E+00_JPRB, &
 & 0.94082E+00_JPRB,0.89013E+00_JPRB,0.86974E+00_JPRB,0.90156E+00_JPRB /)  
KA(:, 5, 5,11) = (/ &
 & 0.93336E+00_JPRB,0.88866E+00_JPRB,0.92975E+00_JPRB,0.96102E+00_JPRB,0.96365E+00_JPRB, &
 & 0.93814E+00_JPRB,0.89133E+00_JPRB,0.86813E+00_JPRB,0.89955E+00_JPRB /)  
KA(:, 1, 6,11) = (/ &
 & 0.92984E+00_JPRB,0.90494E+00_JPRB,0.94972E+00_JPRB,0.97425E+00_JPRB,0.97662E+00_JPRB, &
 & 0.94556E+00_JPRB,0.88351E+00_JPRB,0.85584E+00_JPRB,0.87463E+00_JPRB /)  
KA(:, 2, 6,11) = (/ &
 & 0.91725E+00_JPRB,0.89370E+00_JPRB,0.94535E+00_JPRB,0.97222E+00_JPRB,0.97680E+00_JPRB, &
 & 0.95110E+00_JPRB,0.88518E+00_JPRB,0.85597E+00_JPRB,0.87435E+00_JPRB /)  
KA(:, 3, 6,11) = (/ &
 & 0.90427E+00_JPRB,0.88250E+00_JPRB,0.93903E+00_JPRB,0.96844E+00_JPRB,0.97606E+00_JPRB, &
 & 0.95304E+00_JPRB,0.88753E+00_JPRB,0.85497E+00_JPRB,0.87307E+00_JPRB /)  
KA(:, 4, 6,11) = (/ &
 & 0.89063E+00_JPRB,0.87150E+00_JPRB,0.93110E+00_JPRB,0.96495E+00_JPRB,0.97386E+00_JPRB, &
 & 0.95208E+00_JPRB,0.89056E+00_JPRB,0.85380E+00_JPRB,0.87067E+00_JPRB /)  
KA(:, 5, 6,11) = (/ &
 & 0.87675E+00_JPRB,0.86027E+00_JPRB,0.92261E+00_JPRB,0.96002E+00_JPRB,0.96930E+00_JPRB, &
 & 0.94959E+00_JPRB,0.89201E+00_JPRB,0.85155E+00_JPRB,0.86905E+00_JPRB /)  
KA(:, 1, 7,11) = (/ &
 & 0.85919E+00_JPRB,0.86562E+00_JPRB,0.92649E+00_JPRB,0.95965E+00_JPRB,0.96523E+00_JPRB, &
 & 0.93650E+00_JPRB,0.88529E+00_JPRB,0.84057E+00_JPRB,0.84722E+00_JPRB /)  
KA(:, 2, 7,11) = (/ &
 & 0.84717E+00_JPRB,0.85599E+00_JPRB,0.92166E+00_JPRB,0.95676E+00_JPRB,0.96677E+00_JPRB, &
 & 0.94156E+00_JPRB,0.88807E+00_JPRB,0.84087E+00_JPRB,0.84785E+00_JPRB /)  
KA(:, 3, 7,11) = (/ &
 & 0.83473E+00_JPRB,0.84556E+00_JPRB,0.91525E+00_JPRB,0.95342E+00_JPRB,0.96579E+00_JPRB, &
 & 0.94506E+00_JPRB,0.89084E+00_JPRB,0.83990E+00_JPRB,0.84680E+00_JPRB /)  
KA(:, 4, 7,11) = (/ &
 & 0.82211E+00_JPRB,0.83508E+00_JPRB,0.90782E+00_JPRB,0.94944E+00_JPRB,0.96296E+00_JPRB, &
 & 0.94530E+00_JPRB,0.89295E+00_JPRB,0.83822E+00_JPRB,0.84533E+00_JPRB /)  
KA(:, 5, 7,11) = (/ &
 & 0.80945E+00_JPRB,0.82542E+00_JPRB,0.90011E+00_JPRB,0.94513E+00_JPRB,0.95957E+00_JPRB, &
 & 0.94356E+00_JPRB,0.89326E+00_JPRB,0.83636E+00_JPRB,0.84582E+00_JPRB /)  
KA(:, 1, 8,11) = (/ &
 & 0.78535E+00_JPRB,0.81958E+00_JPRB,0.89069E+00_JPRB,0.92943E+00_JPRB,0.93702E+00_JPRB, &
 & 0.91895E+00_JPRB,0.88182E+00_JPRB,0.81942E+00_JPRB,0.81355E+00_JPRB /)  
KA(:, 2, 8,11) = (/ &
 & 0.77455E+00_JPRB,0.81120E+00_JPRB,0.88449E+00_JPRB,0.92737E+00_JPRB,0.93847E+00_JPRB, &
 & 0.92275E+00_JPRB,0.88568E+00_JPRB,0.82187E+00_JPRB,0.81529E+00_JPRB /)  
KA(:, 3, 8,11) = (/ &
 & 0.76320E+00_JPRB,0.80325E+00_JPRB,0.87799E+00_JPRB,0.92413E+00_JPRB,0.93785E+00_JPRB, &
 & 0.92584E+00_JPRB,0.88848E+00_JPRB,0.82246E+00_JPRB,0.81526E+00_JPRB /)  
KA(:, 4, 8,11) = (/ &
 & 0.75209E+00_JPRB,0.79461E+00_JPRB,0.87173E+00_JPRB,0.92037E+00_JPRB,0.93562E+00_JPRB, &
 & 0.92659E+00_JPRB,0.89042E+00_JPRB,0.82203E+00_JPRB,0.81583E+00_JPRB /)  
KA(:, 5, 8,11) = (/ &
 & 0.74191E+00_JPRB,0.78569E+00_JPRB,0.86500E+00_JPRB,0.91565E+00_JPRB,0.93275E+00_JPRB, &
 & 0.92508E+00_JPRB,0.89021E+00_JPRB,0.82215E+00_JPRB,0.81833E+00_JPRB /)  
KA(:, 1, 9,11) = (/ &
 & 0.71539E+00_JPRB,0.77045E+00_JPRB,0.84442E+00_JPRB,0.88339E+00_JPRB,0.89968E+00_JPRB, &
 & 0.89536E+00_JPRB,0.86841E+00_JPRB,0.79955E+00_JPRB,0.77318E+00_JPRB /)  
KA(:, 2, 9,11) = (/ &
 & 0.70564E+00_JPRB,0.76424E+00_JPRB,0.83867E+00_JPRB,0.88222E+00_JPRB,0.90019E+00_JPRB, &
 & 0.89929E+00_JPRB,0.87308E+00_JPRB,0.80390E+00_JPRB,0.77664E+00_JPRB /)  
KA(:, 3, 9,11) = (/ &
 & 0.69566E+00_JPRB,0.75811E+00_JPRB,0.83280E+00_JPRB,0.87940E+00_JPRB,0.90026E+00_JPRB, &
 & 0.90222E+00_JPRB,0.87663E+00_JPRB,0.80593E+00_JPRB,0.77834E+00_JPRB /)  
KA(:, 4, 9,11) = (/ &
 & 0.68611E+00_JPRB,0.75067E+00_JPRB,0.82727E+00_JPRB,0.87623E+00_JPRB,0.89845E+00_JPRB, &
 & 0.90248E+00_JPRB,0.87886E+00_JPRB,0.80698E+00_JPRB,0.78085E+00_JPRB /)  
KA(:, 5, 9,11) = (/ &
 & 0.67924E+00_JPRB,0.74336E+00_JPRB,0.82173E+00_JPRB,0.87192E+00_JPRB,0.89575E+00_JPRB, &
 & 0.90118E+00_JPRB,0.87929E+00_JPRB,0.80840E+00_JPRB,0.78556E+00_JPRB /)  
KA(:, 1,10,11) = (/ &
 & 0.64750E+00_JPRB,0.72291E+00_JPRB,0.79049E+00_JPRB,0.83093E+00_JPRB,0.85723E+00_JPRB, &
 & 0.86420E+00_JPRB,0.84410E+00_JPRB,0.78062E+00_JPRB,0.72995E+00_JPRB /)  
KA(:, 2,10,11) = (/ &
 & 0.63786E+00_JPRB,0.71701E+00_JPRB,0.78689E+00_JPRB,0.82920E+00_JPRB,0.85838E+00_JPRB, &
 & 0.86903E+00_JPRB,0.84994E+00_JPRB,0.78581E+00_JPRB,0.73484E+00_JPRB /)  
KA(:, 3,10,11) = (/ &
 & 0.62879E+00_JPRB,0.71055E+00_JPRB,0.78212E+00_JPRB,0.82630E+00_JPRB,0.85919E+00_JPRB, &
 & 0.87234E+00_JPRB,0.85358E+00_JPRB,0.78925E+00_JPRB,0.73873E+00_JPRB /)  
KA(:, 4,10,11) = (/ &
 & 0.62087E+00_JPRB,0.70389E+00_JPRB,0.77761E+00_JPRB,0.82356E+00_JPRB,0.85812E+00_JPRB, &
 & 0.87281E+00_JPRB,0.85602E+00_JPRB,0.79174E+00_JPRB,0.74394E+00_JPRB /)  
KA(:, 5,10,11) = (/ &
 & 0.61947E+00_JPRB,0.69759E+00_JPRB,0.77360E+00_JPRB,0.82013E+00_JPRB,0.85542E+00_JPRB, &
 & 0.87157E+00_JPRB,0.85709E+00_JPRB,0.79529E+00_JPRB,0.75052E+00_JPRB /)  
KA(:, 1,11,11) = (/ &
 & 0.57317E+00_JPRB,0.67082E+00_JPRB,0.73559E+00_JPRB,0.77934E+00_JPRB,0.81170E+00_JPRB, &
 & 0.82582E+00_JPRB,0.81431E+00_JPRB,0.75887E+00_JPRB,0.68710E+00_JPRB /)  
KA(:, 2,11,11) = (/ &
 & 0.56447E+00_JPRB,0.66437E+00_JPRB,0.73216E+00_JPRB,0.77740E+00_JPRB,0.81370E+00_JPRB, &
 & 0.83183E+00_JPRB,0.81926E+00_JPRB,0.76438E+00_JPRB,0.69316E+00_JPRB /)  
KA(:, 3,11,11) = (/ &
 & 0.55710E+00_JPRB,0.65798E+00_JPRB,0.72792E+00_JPRB,0.77609E+00_JPRB,0.81480E+00_JPRB, &
 & 0.83377E+00_JPRB,0.82304E+00_JPRB,0.76833E+00_JPRB,0.70018E+00_JPRB /)  
KA(:, 4,11,11) = (/ &
 & 0.55630E+00_JPRB,0.65257E+00_JPRB,0.72437E+00_JPRB,0.77329E+00_JPRB,0.81397E+00_JPRB, &
 & 0.83437E+00_JPRB,0.82566E+00_JPRB,0.77320E+00_JPRB,0.70886E+00_JPRB /)  
KA(:, 5,11,11) = (/ &
 & 0.56411E+00_JPRB,0.65194E+00_JPRB,0.72119E+00_JPRB,0.77017E+00_JPRB,0.81118E+00_JPRB, &
 & 0.83405E+00_JPRB,0.82785E+00_JPRB,0.77913E+00_JPRB,0.71658E+00_JPRB /)  
KA(:, 1,12,11) = (/ &
 & 0.50093E+00_JPRB,0.61265E+00_JPRB,0.68222E+00_JPRB,0.73081E+00_JPRB,0.76376E+00_JPRB, &
 & 0.78196E+00_JPRB,0.77611E+00_JPRB,0.73046E+00_JPRB,0.64374E+00_JPRB /)  
KA(:, 2,12,11) = (/ &
 & 0.49374E+00_JPRB,0.60693E+00_JPRB,0.67860E+00_JPRB,0.73087E+00_JPRB,0.76701E+00_JPRB, &
 & 0.78657E+00_JPRB,0.78196E+00_JPRB,0.73646E+00_JPRB,0.65183E+00_JPRB /)  
KA(:, 3,12,11) = (/ &
 & 0.49262E+00_JPRB,0.60232E+00_JPRB,0.67517E+00_JPRB,0.73017E+00_JPRB,0.76805E+00_JPRB, &
 & 0.78863E+00_JPRB,0.78651E+00_JPRB,0.74261E+00_JPRB,0.66205E+00_JPRB /)  
KA(:, 4,12,11) = (/ &
 & 0.49989E+00_JPRB,0.60234E+00_JPRB,0.67259E+00_JPRB,0.72790E+00_JPRB,0.76753E+00_JPRB, &
 & 0.79017E+00_JPRB,0.79054E+00_JPRB,0.75027E+00_JPRB,0.67174E+00_JPRB /)  
KA(:, 5,12,11) = (/ &
 & 0.51177E+00_JPRB,0.60963E+00_JPRB,0.67313E+00_JPRB,0.72489E+00_JPRB,0.76606E+00_JPRB, &
 & 0.79187E+00_JPRB,0.79524E+00_JPRB,0.75809E+00_JPRB,0.67955E+00_JPRB /)  
KA(:, 1,13,11) = (/ &
 & 0.43610E+00_JPRB,0.55280E+00_JPRB,0.62805E+00_JPRB,0.68236E+00_JPRB,0.71726E+00_JPRB, &
 & 0.73439E+00_JPRB,0.73316E+00_JPRB,0.69581E+00_JPRB,0.60098E+00_JPRB /)  
KA(:, 2,13,11) = (/ &
 & 0.43332E+00_JPRB,0.54879E+00_JPRB,0.62602E+00_JPRB,0.68387E+00_JPRB,0.71981E+00_JPRB, &
 & 0.73863E+00_JPRB,0.74004E+00_JPRB,0.70395E+00_JPRB,0.61188E+00_JPRB /)  
KA(:, 3,13,11) = (/ &
 & 0.43938E+00_JPRB,0.54819E+00_JPRB,0.62420E+00_JPRB,0.68392E+00_JPRB,0.72120E+00_JPRB, &
 & 0.74159E+00_JPRB,0.74634E+00_JPRB,0.71286E+00_JPRB,0.62343E+00_JPRB /)  
KA(:, 4,13,11) = (/ &
 & 0.44997E+00_JPRB,0.55515E+00_JPRB,0.62479E+00_JPRB,0.68255E+00_JPRB,0.72173E+00_JPRB, &
 & 0.74510E+00_JPRB,0.75297E+00_JPRB,0.72278E+00_JPRB,0.63265E+00_JPRB /)  
KA(:, 5,13,11) = (/ &
 & 0.46055E+00_JPRB,0.56787E+00_JPRB,0.63110E+00_JPRB,0.68248E+00_JPRB,0.72225E+00_JPRB, &
 & 0.74921E+00_JPRB,0.75987E+00_JPRB,0.73098E+00_JPRB,0.64026E+00_JPRB /)  
KA(:, 1, 1,12) = (/ &
 & 0.14171E+01_JPRB,0.12412E+01_JPRB,0.11453E+01_JPRB,0.11122E+01_JPRB,0.11253E+01_JPRB, &
 & 0.11573E+01_JPRB,0.11791E+01_JPRB,0.12973E+01_JPRB,0.14638E+01_JPRB /)  
KA(:, 2, 1,12) = (/ &
 & 0.14090E+01_JPRB,0.12342E+01_JPRB,0.11388E+01_JPRB,0.11095E+01_JPRB,0.11322E+01_JPRB, &
 & 0.11607E+01_JPRB,0.11781E+01_JPRB,0.12938E+01_JPRB,0.14611E+01_JPRB /)  
KA(:, 3, 1,12) = (/ &
 & 0.13994E+01_JPRB,0.12258E+01_JPRB,0.11299E+01_JPRB,0.11046E+01_JPRB,0.11339E+01_JPRB, &
 & 0.11641E+01_JPRB,0.11762E+01_JPRB,0.12907E+01_JPRB,0.14569E+01_JPRB /)  
KA(:, 4, 1,12) = (/ &
 & 0.13872E+01_JPRB,0.12151E+01_JPRB,0.11205E+01_JPRB,0.10983E+01_JPRB,0.11321E+01_JPRB, &
 & 0.11655E+01_JPRB,0.11746E+01_JPRB,0.12884E+01_JPRB,0.14537E+01_JPRB /)  
KA(:, 5, 1,12) = (/ &
 & 0.13737E+01_JPRB,0.12034E+01_JPRB,0.11101E+01_JPRB,0.10915E+01_JPRB,0.11280E+01_JPRB, &
 & 0.11664E+01_JPRB,0.11724E+01_JPRB,0.12834E+01_JPRB,0.14491E+01_JPRB /)  
KA(:, 1, 2,12) = (/ &
 & 0.15051E+01_JPRB,0.13181E+01_JPRB,0.12304E+01_JPRB,0.11719E+01_JPRB,0.11855E+01_JPRB, &
 & 0.12309E+01_JPRB,0.12496E+01_JPRB,0.13203E+01_JPRB,0.15049E+01_JPRB /)  
KA(:, 2, 2,12) = (/ &
 & 0.14984E+01_JPRB,0.13123E+01_JPRB,0.12250E+01_JPRB,0.11699E+01_JPRB,0.11925E+01_JPRB, &
 & 0.12340E+01_JPRB,0.12487E+01_JPRB,0.13193E+01_JPRB,0.15024E+01_JPRB /)  
KA(:, 3, 2,12) = (/ &
 & 0.14884E+01_JPRB,0.13036E+01_JPRB,0.12176E+01_JPRB,0.11665E+01_JPRB,0.11942E+01_JPRB, &
 & 0.12376E+01_JPRB,0.12478E+01_JPRB,0.13196E+01_JPRB,0.15020E+01_JPRB /)  
KA(:, 4, 2,12) = (/ &
 & 0.14762E+01_JPRB,0.12929E+01_JPRB,0.12082E+01_JPRB,0.11628E+01_JPRB,0.11911E+01_JPRB, &
 & 0.12406E+01_JPRB,0.12476E+01_JPRB,0.13168E+01_JPRB,0.15001E+01_JPRB /)  
KA(:, 5, 2,12) = (/ &
 & 0.14614E+01_JPRB,0.12800E+01_JPRB,0.11975E+01_JPRB,0.11575E+01_JPRB,0.11857E+01_JPRB, &
 & 0.12414E+01_JPRB,0.12460E+01_JPRB,0.13124E+01_JPRB,0.14945E+01_JPRB /)  
KA(:, 1, 3,12) = (/ &
 & 0.15822E+01_JPRB,0.13890E+01_JPRB,0.13182E+01_JPRB,0.12547E+01_JPRB,0.12476E+01_JPRB, &
 & 0.12873E+01_JPRB,0.13056E+01_JPRB,0.13300E+01_JPRB,0.15181E+01_JPRB /)  
KA(:, 2, 3,12) = (/ &
 & 0.15752E+01_JPRB,0.13826E+01_JPRB,0.13120E+01_JPRB,0.12557E+01_JPRB,0.12556E+01_JPRB, &
 & 0.12906E+01_JPRB,0.13067E+01_JPRB,0.13310E+01_JPRB,0.15193E+01_JPRB /)  
KA(:, 3, 3,12) = (/ &
 & 0.15647E+01_JPRB,0.13732E+01_JPRB,0.13046E+01_JPRB,0.12538E+01_JPRB,0.12575E+01_JPRB, &
 & 0.12941E+01_JPRB,0.13084E+01_JPRB,0.13307E+01_JPRB,0.15193E+01_JPRB /)  
KA(:, 4, 3,12) = (/ &
 & 0.15514E+01_JPRB,0.13616E+01_JPRB,0.12950E+01_JPRB,0.12500E+01_JPRB,0.12556E+01_JPRB, &
 & 0.12989E+01_JPRB,0.13088E+01_JPRB,0.13292E+01_JPRB,0.15174E+01_JPRB /)  
KA(:, 5, 3,12) = (/ &
 & 0.15358E+01_JPRB,0.13480E+01_JPRB,0.12843E+01_JPRB,0.12443E+01_JPRB,0.12517E+01_JPRB, &
 & 0.13009E+01_JPRB,0.13074E+01_JPRB,0.13265E+01_JPRB,0.15142E+01_JPRB /)  
KA(:, 1, 4,12) = (/ &
 & 0.16350E+01_JPRB,0.14490E+01_JPRB,0.13916E+01_JPRB,0.13443E+01_JPRB,0.13174E+01_JPRB, &
 & 0.13244E+01_JPRB,0.13476E+01_JPRB,0.13365E+01_JPRB,0.15180E+01_JPRB /)  
KA(:, 2, 4,12) = (/ &
 & 0.16281E+01_JPRB,0.14425E+01_JPRB,0.13866E+01_JPRB,0.13479E+01_JPRB,0.13260E+01_JPRB, &
 & 0.13268E+01_JPRB,0.13503E+01_JPRB,0.13390E+01_JPRB,0.15205E+01_JPRB /)  
KA(:, 3, 4,12) = (/ &
 & 0.16161E+01_JPRB,0.14310E+01_JPRB,0.13789E+01_JPRB,0.13476E+01_JPRB,0.13293E+01_JPRB, &
 & 0.13314E+01_JPRB,0.13532E+01_JPRB,0.13408E+01_JPRB,0.15220E+01_JPRB /)  
KA(:, 4, 4,12) = (/ &
 & 0.16014E+01_JPRB,0.14178E+01_JPRB,0.13691E+01_JPRB,0.13444E+01_JPRB,0.13282E+01_JPRB, &
 & 0.13379E+01_JPRB,0.13534E+01_JPRB,0.13410E+01_JPRB,0.15212E+01_JPRB /)  
KA(:, 5, 4,12) = (/ &
 & 0.15848E+01_JPRB,0.14026E+01_JPRB,0.13577E+01_JPRB,0.13378E+01_JPRB,0.13257E+01_JPRB, &
 & 0.13408E+01_JPRB,0.13534E+01_JPRB,0.13387E+01_JPRB,0.15183E+01_JPRB /)  
KA(:, 1, 5,12) = (/ &
 & 0.16591E+01_JPRB,0.14947E+01_JPRB,0.14480E+01_JPRB,0.14262E+01_JPRB,0.13903E+01_JPRB, &
 & 0.13587E+01_JPRB,0.13777E+01_JPRB,0.13491E+01_JPRB,0.15046E+01_JPRB /)  
KA(:, 2, 5,12) = (/ &
 & 0.16509E+01_JPRB,0.14862E+01_JPRB,0.14440E+01_JPRB,0.14316E+01_JPRB,0.13991E+01_JPRB, &
 & 0.13598E+01_JPRB,0.13805E+01_JPRB,0.13541E+01_JPRB,0.15083E+01_JPRB /)  
KA(:, 3, 5,12) = (/ &
 & 0.16386E+01_JPRB,0.14750E+01_JPRB,0.14364E+01_JPRB,0.14307E+01_JPRB,0.14045E+01_JPRB, &
 & 0.13655E+01_JPRB,0.13826E+01_JPRB,0.13579E+01_JPRB,0.15118E+01_JPRB /)  
KA(:, 4, 5,12) = (/ &
 & 0.16229E+01_JPRB,0.14605E+01_JPRB,0.14277E+01_JPRB,0.14269E+01_JPRB,0.14036E+01_JPRB, &
 & 0.13722E+01_JPRB,0.13840E+01_JPRB,0.13579E+01_JPRB,0.15115E+01_JPRB /)  
KA(:, 5, 5,12) = (/ &
 & 0.16043E+01_JPRB,0.14439E+01_JPRB,0.14169E+01_JPRB,0.14203E+01_JPRB,0.14024E+01_JPRB, &
 & 0.13765E+01_JPRB,0.13831E+01_JPRB,0.13575E+01_JPRB,0.15115E+01_JPRB /)  
KA(:, 1, 6,12) = (/ &
 & 0.16482E+01_JPRB,0.15147E+01_JPRB,0.14918E+01_JPRB,0.14883E+01_JPRB,0.14555E+01_JPRB, &
 & 0.14030E+01_JPRB,0.13913E+01_JPRB,0.13585E+01_JPRB,0.14685E+01_JPRB /)  
KA(:, 2, 6,12) = (/ &
 & 0.16385E+01_JPRB,0.15059E+01_JPRB,0.14880E+01_JPRB,0.14958E+01_JPRB,0.14629E+01_JPRB, &
 & 0.14056E+01_JPRB,0.13940E+01_JPRB,0.13659E+01_JPRB,0.14762E+01_JPRB /)  
KA(:, 3, 6,12) = (/ &
 & 0.16253E+01_JPRB,0.14941E+01_JPRB,0.14803E+01_JPRB,0.14965E+01_JPRB,0.14689E+01_JPRB, &
 & 0.14106E+01_JPRB,0.13970E+01_JPRB,0.13717E+01_JPRB,0.14817E+01_JPRB /)  
KA(:, 4, 6,12) = (/ &
 & 0.16089E+01_JPRB,0.14791E+01_JPRB,0.14713E+01_JPRB,0.14908E+01_JPRB,0.14702E+01_JPRB, &
 & 0.14165E+01_JPRB,0.13983E+01_JPRB,0.13748E+01_JPRB,0.14851E+01_JPRB /)  
KA(:, 5, 6,12) = (/ &
 & 0.15910E+01_JPRB,0.14633E+01_JPRB,0.14618E+01_JPRB,0.14838E+01_JPRB,0.14693E+01_JPRB, &
 & 0.14213E+01_JPRB,0.13976E+01_JPRB,0.13770E+01_JPRB,0.14876E+01_JPRB /)  
KA(:, 1, 7,12) = (/ &
 & 0.16064E+01_JPRB,0.15086E+01_JPRB,0.15144E+01_JPRB,0.15268E+01_JPRB,0.15040E+01_JPRB, &
 & 0.14507E+01_JPRB,0.13904E+01_JPRB,0.13521E+01_JPRB,0.14179E+01_JPRB /)  
KA(:, 2, 7,12) = (/ &
 & 0.15953E+01_JPRB,0.14985E+01_JPRB,0.15140E+01_JPRB,0.15345E+01_JPRB,0.15085E+01_JPRB, &
 & 0.14549E+01_JPRB,0.13952E+01_JPRB,0.13604E+01_JPRB,0.14259E+01_JPRB /)  
KA(:, 3, 7,12) = (/ &
 & 0.15801E+01_JPRB,0.14851E+01_JPRB,0.15073E+01_JPRB,0.15363E+01_JPRB,0.15134E+01_JPRB, &
 & 0.14598E+01_JPRB,0.13998E+01_JPRB,0.13678E+01_JPRB,0.14328E+01_JPRB /)  
KA(:, 4, 7,12) = (/ &
 & 0.15629E+01_JPRB,0.14703E+01_JPRB,0.14995E+01_JPRB,0.15318E+01_JPRB,0.15172E+01_JPRB, &
 & 0.14656E+01_JPRB,0.14020E+01_JPRB,0.13732E+01_JPRB,0.14388E+01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART8',1,ZHOOK_HANDLE)
END SUBROUTINE PART8


SUBROUTINE PART9

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART9',0,ZHOOK_HANDLE)


KA(:, 5, 7,12) = (/ &
 & 0.15443E+01_JPRB,0.14531E+01_JPRB,0.14892E+01_JPRB,0.15236E+01_JPRB,0.15169E+01_JPRB, &
 & 0.14692E+01_JPRB,0.14038E+01_JPRB,0.13766E+01_JPRB,0.14425E+01_JPRB /)  
KA(:, 1, 8,12) = (/ &
 & 0.15344E+01_JPRB,0.14766E+01_JPRB,0.15157E+01_JPRB,0.15423E+01_JPRB,0.15330E+01_JPRB, &
 & 0.14811E+01_JPRB,0.13889E+01_JPRB,0.13373E+01_JPRB,0.13698E+01_JPRB /)  
KA(:, 2, 8,12) = (/ &
 & 0.15222E+01_JPRB,0.14679E+01_JPRB,0.15175E+01_JPRB,0.15473E+01_JPRB,0.15363E+01_JPRB, &
 & 0.14872E+01_JPRB,0.13948E+01_JPRB,0.13442E+01_JPRB,0.13786E+01_JPRB /)  
KA(:, 3, 8,12) = (/ &
 & 0.15059E+01_JPRB,0.14533E+01_JPRB,0.15144E+01_JPRB,0.15489E+01_JPRB,0.15409E+01_JPRB, &
 & 0.14932E+01_JPRB,0.14005E+01_JPRB,0.13518E+01_JPRB,0.13861E+01_JPRB /)  
KA(:, 4, 8,12) = (/ &
 & 0.14877E+01_JPRB,0.14368E+01_JPRB,0.15058E+01_JPRB,0.15451E+01_JPRB,0.15445E+01_JPRB, &
 & 0.14989E+01_JPRB,0.14044E+01_JPRB,0.13574E+01_JPRB,0.13922E+01_JPRB /)  
KA(:, 5, 8,12) = (/ &
 & 0.14686E+01_JPRB,0.14200E+01_JPRB,0.14953E+01_JPRB,0.15388E+01_JPRB,0.15447E+01_JPRB, &
 & 0.15024E+01_JPRB,0.14082E+01_JPRB,0.13605E+01_JPRB,0.13964E+01_JPRB /)  
KA(:, 1, 9,12) = (/ &
 & 0.14373E+01_JPRB,0.14266E+01_JPRB,0.14938E+01_JPRB,0.15367E+01_JPRB,0.15341E+01_JPRB, &
 & 0.14871E+01_JPRB,0.13939E+01_JPRB,0.13173E+01_JPRB,0.13285E+01_JPRB /)  
KA(:, 2, 9,12) = (/ &
 & 0.14250E+01_JPRB,0.14168E+01_JPRB,0.14968E+01_JPRB,0.15390E+01_JPRB,0.15386E+01_JPRB, &
 & 0.14934E+01_JPRB,0.13987E+01_JPRB,0.13260E+01_JPRB,0.13388E+01_JPRB /)  
KA(:, 3, 9,12) = (/ &
 & 0.14085E+01_JPRB,0.14020E+01_JPRB,0.14946E+01_JPRB,0.15393E+01_JPRB,0.15430E+01_JPRB, &
 & 0.14996E+01_JPRB,0.14050E+01_JPRB,0.13340E+01_JPRB,0.13471E+01_JPRB /)  
KA(:, 4, 9,12) = (/ &
 & 0.13898E+01_JPRB,0.13862E+01_JPRB,0.14874E+01_JPRB,0.15365E+01_JPRB,0.15469E+01_JPRB, &
 & 0.15061E+01_JPRB,0.14095E+01_JPRB,0.13387E+01_JPRB,0.13529E+01_JPRB /)  
KA(:, 5, 9,12) = (/ &
 & 0.13711E+01_JPRB,0.13694E+01_JPRB,0.14772E+01_JPRB,0.15321E+01_JPRB,0.15481E+01_JPRB, &
 & 0.15103E+01_JPRB,0.14136E+01_JPRB,0.13413E+01_JPRB,0.13557E+01_JPRB /)  
KA(:, 1,10,12) = (/ &
 & 0.13234E+01_JPRB,0.13585E+01_JPRB,0.14531E+01_JPRB,0.15073E+01_JPRB,0.15094E+01_JPRB, &
 & 0.14728E+01_JPRB,0.13972E+01_JPRB,0.12936E+01_JPRB,0.12835E+01_JPRB /)  
KA(:, 2,10,12) = (/ &
 & 0.13109E+01_JPRB,0.13494E+01_JPRB,0.14540E+01_JPRB,0.15085E+01_JPRB,0.15139E+01_JPRB, &
 & 0.14784E+01_JPRB,0.14019E+01_JPRB,0.13047E+01_JPRB,0.12968E+01_JPRB /)  
KA(:, 3,10,12) = (/ &
 & 0.12956E+01_JPRB,0.13371E+01_JPRB,0.14504E+01_JPRB,0.15092E+01_JPRB,0.15192E+01_JPRB, &
 & 0.14835E+01_JPRB,0.14094E+01_JPRB,0.13136E+01_JPRB,0.13076E+01_JPRB /)  
KA(:, 4,10,12) = (/ &
 & 0.12784E+01_JPRB,0.13237E+01_JPRB,0.14435E+01_JPRB,0.15071E+01_JPRB,0.15234E+01_JPRB, &
 & 0.14905E+01_JPRB,0.14145E+01_JPRB,0.13190E+01_JPRB,0.13139E+01_JPRB /)  
KA(:, 5,10,12) = (/ &
 & 0.12607E+01_JPRB,0.13090E+01_JPRB,0.14344E+01_JPRB,0.15038E+01_JPRB,0.15261E+01_JPRB, &
 & 0.14956E+01_JPRB,0.14181E+01_JPRB,0.13210E+01_JPRB,0.13178E+01_JPRB /)  
KA(:, 1,11,12) = (/ &
 & 0.12047E+01_JPRB,0.12789E+01_JPRB,0.13923E+01_JPRB,0.14530E+01_JPRB,0.14659E+01_JPRB, &
 & 0.14483E+01_JPRB,0.13898E+01_JPRB,0.12749E+01_JPRB,0.12386E+01_JPRB /)  
KA(:, 2,11,12) = (/ &
 & 0.11911E+01_JPRB,0.12701E+01_JPRB,0.13902E+01_JPRB,0.14549E+01_JPRB,0.14710E+01_JPRB, &
 & 0.14517E+01_JPRB,0.13981E+01_JPRB,0.12874E+01_JPRB,0.12546E+01_JPRB /)  
KA(:, 3,11,12) = (/ &
 & 0.11768E+01_JPRB,0.12599E+01_JPRB,0.13852E+01_JPRB,0.14552E+01_JPRB,0.14760E+01_JPRB, &
 & 0.14581E+01_JPRB,0.14056E+01_JPRB,0.12968E+01_JPRB,0.12644E+01_JPRB /)  
KA(:, 4,11,12) = (/ &
 & 0.11609E+01_JPRB,0.12491E+01_JPRB,0.13785E+01_JPRB,0.14542E+01_JPRB,0.14794E+01_JPRB, &
 & 0.14643E+01_JPRB,0.14106E+01_JPRB,0.13015E+01_JPRB,0.12707E+01_JPRB /)  
KA(:, 5,11,12) = (/ &
 & 0.11453E+01_JPRB,0.12370E+01_JPRB,0.13722E+01_JPRB,0.14526E+01_JPRB,0.14820E+01_JPRB, &
 & 0.14680E+01_JPRB,0.14139E+01_JPRB,0.13041E+01_JPRB,0.12775E+01_JPRB /)  
KA(:, 1,12,12) = (/ &
 & 0.10892E+01_JPRB,0.11978E+01_JPRB,0.13175E+01_JPRB,0.13800E+01_JPRB,0.14113E+01_JPRB, &
 & 0.14104E+01_JPRB,0.13697E+01_JPRB,0.12563E+01_JPRB,0.11895E+01_JPRB /)  
KA(:, 2,12,12) = (/ &
 & 0.10764E+01_JPRB,0.11912E+01_JPRB,0.13142E+01_JPRB,0.13828E+01_JPRB,0.14151E+01_JPRB, &
 & 0.14161E+01_JPRB,0.13800E+01_JPRB,0.12704E+01_JPRB,0.12046E+01_JPRB /)  
KA(:, 3,12,12) = (/ &
 & 0.10634E+01_JPRB,0.11835E+01_JPRB,0.13099E+01_JPRB,0.13835E+01_JPRB,0.14196E+01_JPRB, &
 & 0.14241E+01_JPRB,0.13887E+01_JPRB,0.12786E+01_JPRB,0.12148E+01_JPRB /)  
KA(:, 4,12,12) = (/ &
 & 0.10495E+01_JPRB,0.11751E+01_JPRB,0.13057E+01_JPRB,0.13846E+01_JPRB,0.14230E+01_JPRB, &
 & 0.14300E+01_JPRB,0.13945E+01_JPRB,0.12836E+01_JPRB,0.12244E+01_JPRB /)  
KA(:, 5,12,12) = (/ &
 & 0.10406E+01_JPRB,0.11650E+01_JPRB,0.13011E+01_JPRB,0.13864E+01_JPRB,0.14254E+01_JPRB, &
 & 0.14322E+01_JPRB,0.13980E+01_JPRB,0.12878E+01_JPRB,0.12342E+01_JPRB /)  
KA(:, 1,13,12) = (/ &
 & 0.97671E+00_JPRB,0.11194E+01_JPRB,0.12352E+01_JPRB,0.13029E+01_JPRB,0.13468E+01_JPRB, &
 & 0.13623E+01_JPRB,0.13355E+01_JPRB,0.12363E+01_JPRB,0.11351E+01_JPRB /)  
KA(:, 2,13,12) = (/ &
 & 0.96514E+00_JPRB,0.11135E+01_JPRB,0.12326E+01_JPRB,0.13049E+01_JPRB,0.13523E+01_JPRB, &
 & 0.13721E+01_JPRB,0.13488E+01_JPRB,0.12496E+01_JPRB,0.11500E+01_JPRB /)  
KA(:, 3,13,12) = (/ &
 & 0.95350E+00_JPRB,0.11073E+01_JPRB,0.12308E+01_JPRB,0.13063E+01_JPRB,0.13575E+01_JPRB, &
 & 0.13815E+01_JPRB,0.13588E+01_JPRB,0.12584E+01_JPRB,0.11629E+01_JPRB /)  
KA(:, 4,13,12) = (/ &
 & 0.94648E+00_JPRB,0.11002E+01_JPRB,0.12294E+01_JPRB,0.13087E+01_JPRB,0.13617E+01_JPRB, &
 & 0.13873E+01_JPRB,0.13660E+01_JPRB,0.12653E+01_JPRB,0.11761E+01_JPRB /)  
KA(:, 5,13,12) = (/ &
 & 0.94953E+00_JPRB,0.10941E+01_JPRB,0.12277E+01_JPRB,0.13116E+01_JPRB,0.13645E+01_JPRB, &
 & 0.13901E+01_JPRB,0.13713E+01_JPRB,0.12717E+01_JPRB,0.11896E+01_JPRB /)  
KA(:, 1, 1,13) = (/ &
 & 0.21877E+01_JPRB,0.19168E+01_JPRB,0.16830E+01_JPRB,0.16306E+01_JPRB,0.15763E+01_JPRB, &
 & 0.15398E+01_JPRB,0.15859E+01_JPRB,0.18468E+01_JPRB,0.20593E+01_JPRB /)  
KA(:, 2, 1,13) = (/ &
 & 0.22022E+01_JPRB,0.19296E+01_JPRB,0.16916E+01_JPRB,0.16400E+01_JPRB,0.15796E+01_JPRB, &
 & 0.15432E+01_JPRB,0.15912E+01_JPRB,0.18534E+01_JPRB,0.20655E+01_JPRB /)  
KA(:, 3, 1,13) = (/ &
 & 0.22022E+01_JPRB,0.19297E+01_JPRB,0.16911E+01_JPRB,0.16436E+01_JPRB,0.15885E+01_JPRB, &
 & 0.15469E+01_JPRB,0.15941E+01_JPRB,0.18569E+01_JPRB,0.20695E+01_JPRB /)  
KA(:, 4, 1,13) = (/ &
 & 0.21895E+01_JPRB,0.19186E+01_JPRB,0.16803E+01_JPRB,0.16425E+01_JPRB,0.15962E+01_JPRB, &
 & 0.15525E+01_JPRB,0.15947E+01_JPRB,0.18575E+01_JPRB,0.20703E+01_JPRB /)  
KA(:, 5, 1,13) = (/ &
 & 0.21697E+01_JPRB,0.19013E+01_JPRB,0.16648E+01_JPRB,0.16344E+01_JPRB,0.16003E+01_JPRB, &
 & 0.15574E+01_JPRB,0.15941E+01_JPRB,0.18572E+01_JPRB,0.20709E+01_JPRB /)  
KA(:, 1, 2,13) = (/ &
 & 0.22550E+01_JPRB,0.19753E+01_JPRB,0.17734E+01_JPRB,0.17443E+01_JPRB,0.17102E+01_JPRB, &
 & 0.16986E+01_JPRB,0.17217E+01_JPRB,0.19863E+01_JPRB,0.22329E+01_JPRB /)  
KA(:, 2, 2,13) = (/ &
 & 0.22679E+01_JPRB,0.19867E+01_JPRB,0.17791E+01_JPRB,0.17520E+01_JPRB,0.17112E+01_JPRB, &
 & 0.17026E+01_JPRB,0.17283E+01_JPRB,0.19934E+01_JPRB,0.22409E+01_JPRB /)  
KA(:, 3, 2,13) = (/ &
 & 0.22698E+01_JPRB,0.19883E+01_JPRB,0.17767E+01_JPRB,0.17568E+01_JPRB,0.17174E+01_JPRB, &
 & 0.17053E+01_JPRB,0.17318E+01_JPRB,0.19966E+01_JPRB,0.22448E+01_JPRB /)  
KA(:, 4, 2,13) = (/ &
 & 0.22597E+01_JPRB,0.19796E+01_JPRB,0.17668E+01_JPRB,0.17548E+01_JPRB,0.17261E+01_JPRB, &
 & 0.17073E+01_JPRB,0.17314E+01_JPRB,0.19968E+01_JPRB,0.22451E+01_JPRB /)  
KA(:, 5, 2,13) = (/ &
 & 0.22409E+01_JPRB,0.19632E+01_JPRB,0.17511E+01_JPRB,0.17475E+01_JPRB,0.17318E+01_JPRB, &
 & 0.17099E+01_JPRB,0.17295E+01_JPRB,0.19947E+01_JPRB,0.22431E+01_JPRB /)  
KA(:, 1, 3,13) = (/ &
 & 0.23526E+01_JPRB,0.20603E+01_JPRB,0.18829E+01_JPRB,0.18493E+01_JPRB,0.18420E+01_JPRB, &
 & 0.18637E+01_JPRB,0.18729E+01_JPRB,0.21122E+01_JPRB,0.23977E+01_JPRB /)  
KA(:, 2, 3,13) = (/ &
 & 0.23692E+01_JPRB,0.20749E+01_JPRB,0.18925E+01_JPRB,0.18515E+01_JPRB,0.18400E+01_JPRB, &
 & 0.18683E+01_JPRB,0.18793E+01_JPRB,0.21211E+01_JPRB,0.24079E+01_JPRB /)  
KA(:, 3, 3,13) = (/ &
 & 0.23722E+01_JPRB,0.20775E+01_JPRB,0.18924E+01_JPRB,0.18562E+01_JPRB,0.18451E+01_JPRB, &
 & 0.18704E+01_JPRB,0.18820E+01_JPRB,0.21249E+01_JPRB,0.24125E+01_JPRB /)  
KA(:, 4, 3,13) = (/ &
 & 0.23635E+01_JPRB,0.20699E+01_JPRB,0.18842E+01_JPRB,0.18555E+01_JPRB,0.18524E+01_JPRB, &
 & 0.18695E+01_JPRB,0.18827E+01_JPRB,0.21252E+01_JPRB,0.24130E+01_JPRB /)  
KA(:, 5, 3,13) = (/ &
 & 0.23480E+01_JPRB,0.20564E+01_JPRB,0.18701E+01_JPRB,0.18499E+01_JPRB,0.18587E+01_JPRB, &
 & 0.18689E+01_JPRB,0.18824E+01_JPRB,0.21250E+01_JPRB,0.24123E+01_JPRB /)  
KA(:, 1, 4,13) = (/ &
 & 0.24939E+01_JPRB,0.21837E+01_JPRB,0.20232E+01_JPRB,0.19589E+01_JPRB,0.19737E+01_JPRB, &
 & 0.20251E+01_JPRB,0.20263E+01_JPRB,0.22145E+01_JPRB,0.25248E+01_JPRB /)  
KA(:, 2, 4,13) = (/ &
 & 0.25110E+01_JPRB,0.21986E+01_JPRB,0.20314E+01_JPRB,0.19589E+01_JPRB,0.19697E+01_JPRB, &
 & 0.20307E+01_JPRB,0.20352E+01_JPRB,0.22253E+01_JPRB,0.25374E+01_JPRB /)  
KA(:, 3, 4,13) = (/ &
 & 0.25161E+01_JPRB,0.22032E+01_JPRB,0.20346E+01_JPRB,0.19625E+01_JPRB,0.19727E+01_JPRB, &
 & 0.20334E+01_JPRB,0.20403E+01_JPRB,0.22301E+01_JPRB,0.25429E+01_JPRB /)  
KA(:, 4, 4,13) = (/ &
 & 0.25095E+01_JPRB,0.21974E+01_JPRB,0.20283E+01_JPRB,0.19657E+01_JPRB,0.19780E+01_JPRB, &
 & 0.20313E+01_JPRB,0.20420E+01_JPRB,0.22330E+01_JPRB,0.25458E+01_JPRB /)  
KA(:, 5, 4,13) = (/ &
 & 0.24957E+01_JPRB,0.21853E+01_JPRB,0.20162E+01_JPRB,0.19613E+01_JPRB,0.19825E+01_JPRB, &
 & 0.20289E+01_JPRB,0.20423E+01_JPRB,0.22370E+01_JPRB,0.25500E+01_JPRB /)  
KA(:, 1, 5,13) = (/ &
 & 0.26637E+01_JPRB,0.23330E+01_JPRB,0.21864E+01_JPRB,0.20904E+01_JPRB,0.21013E+01_JPRB, &
 & 0.21699E+01_JPRB,0.21691E+01_JPRB,0.22859E+01_JPRB,0.26102E+01_JPRB /)  
KA(:, 2, 5,13) = (/ &
 & 0.26795E+01_JPRB,0.23466E+01_JPRB,0.21930E+01_JPRB,0.20883E+01_JPRB,0.21007E+01_JPRB, &
 & 0.21775E+01_JPRB,0.21807E+01_JPRB,0.22957E+01_JPRB,0.26216E+01_JPRB /)  
KA(:, 3, 5,13) = (/ &
 & 0.26872E+01_JPRB,0.23531E+01_JPRB,0.22001E+01_JPRB,0.20926E+01_JPRB,0.21029E+01_JPRB, &
 & 0.21797E+01_JPRB,0.21879E+01_JPRB,0.23020E+01_JPRB,0.26289E+01_JPRB /)  
KA(:, 4, 5,13) = (/ &
 & 0.26803E+01_JPRB,0.23471E+01_JPRB,0.21948E+01_JPRB,0.20970E+01_JPRB,0.21069E+01_JPRB, &
 & 0.21770E+01_JPRB,0.21901E+01_JPRB,0.23087E+01_JPRB,0.26364E+01_JPRB /)  
KA(:, 5, 5,13) = (/ &
 & 0.26667E+01_JPRB,0.23351E+01_JPRB,0.21832E+01_JPRB,0.20959E+01_JPRB,0.21091E+01_JPRB, &
 & 0.21729E+01_JPRB,0.21936E+01_JPRB,0.23158E+01_JPRB,0.26444E+01_JPRB /)  
KA(:, 1, 6,13) = (/ &
 & 0.28246E+01_JPRB,0.24844E+01_JPRB,0.23554E+01_JPRB,0.22494E+01_JPRB,0.22325E+01_JPRB, &
 & 0.22877E+01_JPRB,0.22925E+01_JPRB,0.23319E+01_JPRB,0.26619E+01_JPRB /)  
KA(:, 2, 6,13) = (/ &
 & 0.28376E+01_JPRB,0.24941E+01_JPRB,0.23589E+01_JPRB,0.22458E+01_JPRB,0.22369E+01_JPRB, &
 & 0.22959E+01_JPRB,0.23048E+01_JPRB,0.23408E+01_JPRB,0.26720E+01_JPRB /)  
KA(:, 3, 6,13) = (/ &
 & 0.28468E+01_JPRB,0.25010E+01_JPRB,0.23646E+01_JPRB,0.22473E+01_JPRB,0.22379E+01_JPRB, &
 & 0.22992E+01_JPRB,0.23116E+01_JPRB,0.23486E+01_JPRB,0.26812E+01_JPRB /)  
KA(:, 4, 6,13) = (/ &
 & 0.28432E+01_JPRB,0.24967E+01_JPRB,0.23643E+01_JPRB,0.22531E+01_JPRB,0.22409E+01_JPRB, &
 & 0.22981E+01_JPRB,0.23157E+01_JPRB,0.23572E+01_JPRB,0.26911E+01_JPRB /)  
KA(:, 5, 6,13) = (/ &
 & 0.28266E+01_JPRB,0.24816E+01_JPRB,0.23521E+01_JPRB,0.22549E+01_JPRB,0.22433E+01_JPRB, &
 & 0.22953E+01_JPRB,0.23213E+01_JPRB,0.23655E+01_JPRB,0.27010E+01_JPRB /)  
KA(:, 1, 7,13) = (/ &
 & 0.29507E+01_JPRB,0.26186E+01_JPRB,0.25154E+01_JPRB,0.24214E+01_JPRB,0.23698E+01_JPRB, &
 & 0.23809E+01_JPRB,0.23936E+01_JPRB,0.23723E+01_JPRB,0.26904E+01_JPRB /)  
KA(:, 2, 7,13) = (/ &
 & 0.29579E+01_JPRB,0.26218E+01_JPRB,0.25131E+01_JPRB,0.24179E+01_JPRB,0.23791E+01_JPRB, &
 & 0.23895E+01_JPRB,0.24036E+01_JPRB,0.23830E+01_JPRB,0.27026E+01_JPRB /)  
KA(:, 3, 7,13) = (/ &
 & 0.29645E+01_JPRB,0.26250E+01_JPRB,0.25156E+01_JPRB,0.24180E+01_JPRB,0.23828E+01_JPRB, &
 & 0.23929E+01_JPRB,0.24104E+01_JPRB,0.23923E+01_JPRB,0.27131E+01_JPRB /)  
KA(:, 4, 7,13) = (/ &
 & 0.29630E+01_JPRB,0.26222E+01_JPRB,0.25142E+01_JPRB,0.24231E+01_JPRB,0.23851E+01_JPRB, &
 & 0.23923E+01_JPRB,0.24170E+01_JPRB,0.24017E+01_JPRB,0.27241E+01_JPRB /)  
KA(:, 5, 7,13) = (/ &
 & 0.29476E+01_JPRB,0.26071E+01_JPRB,0.25053E+01_JPRB,0.24267E+01_JPRB,0.23855E+01_JPRB, &
 & 0.23922E+01_JPRB,0.24228E+01_JPRB,0.24116E+01_JPRB,0.27361E+01_JPRB /)  
KA(:, 1, 8,13) = (/ &
 & 0.30283E+01_JPRB,0.27271E+01_JPRB,0.26499E+01_JPRB,0.25812E+01_JPRB,0.25068E+01_JPRB, &
 & 0.24674E+01_JPRB,0.24700E+01_JPRB,0.24088E+01_JPRB,0.26873E+01_JPRB /)  
KA(:, 2, 8,13) = (/ &
 & 0.30302E+01_JPRB,0.27229E+01_JPRB,0.26429E+01_JPRB,0.25805E+01_JPRB,0.25199E+01_JPRB, &
 & 0.24758E+01_JPRB,0.24797E+01_JPRB,0.24223E+01_JPRB,0.27017E+01_JPRB /)  
KA(:, 3, 8,13) = (/ &
 & 0.30313E+01_JPRB,0.27198E+01_JPRB,0.26386E+01_JPRB,0.25814E+01_JPRB,0.25257E+01_JPRB, &
 & 0.24788E+01_JPRB,0.24874E+01_JPRB,0.24335E+01_JPRB,0.27156E+01_JPRB /)  
KA(:, 4, 8,13) = (/ &
 & 0.30296E+01_JPRB,0.27153E+01_JPRB,0.26358E+01_JPRB,0.25865E+01_JPRB,0.25285E+01_JPRB, &
 & 0.24798E+01_JPRB,0.24941E+01_JPRB,0.24451E+01_JPRB,0.27296E+01_JPRB /)  
KA(:, 5, 8,13) = (/ &
 & 0.30139E+01_JPRB,0.26994E+01_JPRB,0.26290E+01_JPRB,0.25893E+01_JPRB,0.25296E+01_JPRB, &
 & 0.24809E+01_JPRB,0.25004E+01_JPRB,0.24568E+01_JPRB,0.27436E+01_JPRB /)  
KA(:, 1, 9,13) = (/ &
 & 0.30493E+01_JPRB,0.27941E+01_JPRB,0.27550E+01_JPRB,0.27119E+01_JPRB,0.26405E+01_JPRB, &
 & 0.25561E+01_JPRB,0.25144E+01_JPRB,0.24302E+01_JPRB,0.26456E+01_JPRB /)  
KA(:, 2, 9,13) = (/ &
 & 0.30457E+01_JPRB,0.27865E+01_JPRB,0.27445E+01_JPRB,0.27145E+01_JPRB,0.26540E+01_JPRB, &
 & 0.25649E+01_JPRB,0.25264E+01_JPRB,0.24468E+01_JPRB,0.26636E+01_JPRB /)  
KA(:, 3, 9,13) = (/ &
 & 0.30433E+01_JPRB,0.27809E+01_JPRB,0.27367E+01_JPRB,0.27179E+01_JPRB,0.26606E+01_JPRB, &
 & 0.25683E+01_JPRB,0.25354E+01_JPRB,0.24613E+01_JPRB,0.26815E+01_JPRB /)  
KA(:, 4, 9,13) = (/ &
 & 0.30389E+01_JPRB,0.27734E+01_JPRB,0.27309E+01_JPRB,0.27229E+01_JPRB,0.26627E+01_JPRB, &
 & 0.25715E+01_JPRB,0.25441E+01_JPRB,0.24765E+01_JPRB,0.27005E+01_JPRB /)  
KA(:, 5, 9,13) = (/ &
 & 0.30246E+01_JPRB,0.27583E+01_JPRB,0.27239E+01_JPRB,0.27244E+01_JPRB,0.26642E+01_JPRB, &
 & 0.25740E+01_JPRB,0.25518E+01_JPRB,0.24921E+01_JPRB,0.27199E+01_JPRB /)  
KA(:, 1,10,13) = (/ &
 & 0.30121E+01_JPRB,0.28154E+01_JPRB,0.28201E+01_JPRB,0.28057E+01_JPRB,0.27531E+01_JPRB, &
 & 0.26438E+01_JPRB,0.25360E+01_JPRB,0.24395E+01_JPRB,0.25814E+01_JPRB /)  
KA(:, 2,10,13) = (/ &
 & 0.30058E+01_JPRB,0.28055E+01_JPRB,0.28091E+01_JPRB,0.28117E+01_JPRB,0.27659E+01_JPRB, &
 & 0.26536E+01_JPRB,0.25505E+01_JPRB,0.24578E+01_JPRB,0.26020E+01_JPRB /)  
KA(:, 3,10,13) = (/ &
 & 0.29984E+01_JPRB,0.27957E+01_JPRB,0.28033E+01_JPRB,0.28172E+01_JPRB,0.27717E+01_JPRB, &
 & 0.26597E+01_JPRB,0.25631E+01_JPRB,0.24765E+01_JPRB,0.26239E+01_JPRB /)  
KA(:, 4,10,13) = (/ &
 & 0.29909E+01_JPRB,0.27859E+01_JPRB,0.27980E+01_JPRB,0.28231E+01_JPRB,0.27737E+01_JPRB, &
 & 0.26641E+01_JPRB,0.25752E+01_JPRB,0.24953E+01_JPRB,0.26473E+01_JPRB /)  
KA(:, 5,10,13) = (/ &
 & 0.29757E+01_JPRB,0.27703E+01_JPRB,0.27906E+01_JPRB,0.28248E+01_JPRB,0.27751E+01_JPRB, &
 & 0.26687E+01_JPRB,0.25862E+01_JPRB,0.25141E+01_JPRB,0.26704E+01_JPRB /)  
KA(:, 1,11,13) = (/ &
 & 0.29105E+01_JPRB,0.27849E+01_JPRB,0.28418E+01_JPRB,0.28641E+01_JPRB,0.28368E+01_JPRB, &
 & 0.27205E+01_JPRB,0.25555E+01_JPRB,0.24401E+01_JPRB,0.25196E+01_JPRB /)  
KA(:, 2,11,13) = (/ &
 & 0.29013E+01_JPRB,0.27742E+01_JPRB,0.28363E+01_JPRB,0.28719E+01_JPRB,0.28460E+01_JPRB, &
 & 0.27321E+01_JPRB,0.25730E+01_JPRB,0.24607E+01_JPRB,0.25412E+01_JPRB /)  
KA(:, 3,11,13) = (/ &
 & 0.28911E+01_JPRB,0.27633E+01_JPRB,0.28321E+01_JPRB,0.28799E+01_JPRB,0.28506E+01_JPRB, &
 & 0.27417E+01_JPRB,0.25892E+01_JPRB,0.24813E+01_JPRB,0.25665E+01_JPRB /)  
KA(:, 4,11,13) = (/ &
 & 0.28805E+01_JPRB,0.27495E+01_JPRB,0.28275E+01_JPRB,0.28852E+01_JPRB,0.28551E+01_JPRB, &
 & 0.27503E+01_JPRB,0.26048E+01_JPRB,0.25023E+01_JPRB,0.25905E+01_JPRB /)  
KA(:, 5,11,13) = (/ &
 & 0.28607E+01_JPRB,0.27299E+01_JPRB,0.28179E+01_JPRB,0.28868E+01_JPRB,0.28597E+01_JPRB, &
 & 0.27578E+01_JPRB,0.26198E+01_JPRB,0.25207E+01_JPRB,0.26120E+01_JPRB /)  
KA(:, 1,12,13) = (/ &
 & 0.27583E+01_JPRB,0.27145E+01_JPRB,0.28231E+01_JPRB,0.28871E+01_JPRB,0.28764E+01_JPRB, &
 & 0.27674E+01_JPRB,0.25743E+01_JPRB,0.24278E+01_JPRB,0.24570E+01_JPRB /)  
KA(:, 2,12,13) = (/ &
 & 0.27477E+01_JPRB,0.27023E+01_JPRB,0.28226E+01_JPRB,0.28962E+01_JPRB,0.28884E+01_JPRB, &
 & 0.27832E+01_JPRB,0.25939E+01_JPRB,0.24483E+01_JPRB,0.24817E+01_JPRB /)  
KA(:, 3,12,13) = (/ &
 & 0.27363E+01_JPRB,0.26890E+01_JPRB,0.28229E+01_JPRB,0.29041E+01_JPRB,0.28966E+01_JPRB, &
 & 0.27972E+01_JPRB,0.26117E+01_JPRB,0.24706E+01_JPRB,0.25053E+01_JPRB /)  
KA(:, 4,12,13) = (/ &
 & 0.27215E+01_JPRB,0.26719E+01_JPRB,0.28199E+01_JPRB,0.29098E+01_JPRB,0.29044E+01_JPRB, &
 & 0.28097E+01_JPRB,0.26305E+01_JPRB,0.24926E+01_JPRB,0.25297E+01_JPRB /)  
KA(:, 5,12,13) = (/ &
 & 0.27019E+01_JPRB,0.26521E+01_JPRB,0.28123E+01_JPRB,0.29106E+01_JPRB,0.29127E+01_JPRB, &
 & 0.28234E+01_JPRB,0.26485E+01_JPRB,0.25112E+01_JPRB,0.25512E+01_JPRB /)  
KA(:, 1,13,13) = (/ &
 & 0.25703E+01_JPRB,0.26073E+01_JPRB,0.27736E+01_JPRB,0.28686E+01_JPRB,0.28762E+01_JPRB, &
 & 0.27819E+01_JPRB,0.25967E+01_JPRB,0.24069E+01_JPRB,0.23967E+01_JPRB /)  
KA(:, 2,13,13) = (/ &
 & 0.25597E+01_JPRB,0.25968E+01_JPRB,0.27777E+01_JPRB,0.28810E+01_JPRB,0.28904E+01_JPRB, &
 & 0.28011E+01_JPRB,0.26158E+01_JPRB,0.24298E+01_JPRB,0.24224E+01_JPRB /)  
KA(:, 3,13,13) = (/ &
 & 0.25492E+01_JPRB,0.25857E+01_JPRB,0.27800E+01_JPRB,0.28929E+01_JPRB,0.29040E+01_JPRB, &
 & 0.28202E+01_JPRB,0.26351E+01_JPRB,0.24527E+01_JPRB,0.24494E+01_JPRB /)  
KA(:, 4,13,13) = (/ &
 & 0.25336E+01_JPRB,0.25705E+01_JPRB,0.27801E+01_JPRB,0.29008E+01_JPRB,0.29182E+01_JPRB, &
 & 0.28403E+01_JPRB,0.26542E+01_JPRB,0.24758E+01_JPRB,0.24745E+01_JPRB /)  
KA(:, 5,13,13) = (/ &
 & 0.25174E+01_JPRB,0.25538E+01_JPRB,0.27760E+01_JPRB,0.29061E+01_JPRB,0.29321E+01_JPRB, &
 & 0.28592E+01_JPRB,0.26728E+01_JPRB,0.24954E+01_JPRB,0.24962E+01_JPRB /)  
KA(:, 1, 1,14) = (/ &
 & 0.34915E+01_JPRB,0.30588E+01_JPRB,0.26262E+01_JPRB,0.23144E+01_JPRB,0.22122E+01_JPRB, &
 & 0.21892E+01_JPRB,0.25558E+01_JPRB,0.29818E+01_JPRB,0.32991E+01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART9',1,ZHOOK_HANDLE)
END SUBROUTINE PART9


SUBROUTINE PART10

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART10',0,ZHOOK_HANDLE)


KA(:, 2, 1,14) = (/ &
 & 0.35009E+01_JPRB,0.30672E+01_JPRB,0.26335E+01_JPRB,0.23059E+01_JPRB,0.22071E+01_JPRB, &
 & 0.21796E+01_JPRB,0.25444E+01_JPRB,0.29683E+01_JPRB,0.32820E+01_JPRB /)  
KA(:, 3, 1,14) = (/ &
 & 0.35192E+01_JPRB,0.30832E+01_JPRB,0.26472E+01_JPRB,0.23037E+01_JPRB,0.22014E+01_JPRB, &
 & 0.21706E+01_JPRB,0.25342E+01_JPRB,0.29565E+01_JPRB,0.32692E+01_JPRB /)  
KA(:, 4, 1,14) = (/ &
 & 0.35462E+01_JPRB,0.31069E+01_JPRB,0.26676E+01_JPRB,0.23054E+01_JPRB,0.21967E+01_JPRB, &
 & 0.21619E+01_JPRB,0.25265E+01_JPRB,0.29475E+01_JPRB,0.32591E+01_JPRB /)  
KA(:, 5, 1,14) = (/ &
 & 0.35714E+01_JPRB,0.31290E+01_JPRB,0.26866E+01_JPRB,0.23141E+01_JPRB,0.21952E+01_JPRB, &
 & 0.21552E+01_JPRB,0.25228E+01_JPRB,0.29432E+01_JPRB,0.32501E+01_JPRB /)  
KA(:, 1, 2,14) = (/ &
 & 0.38742E+01_JPRB,0.33939E+01_JPRB,0.29135E+01_JPRB,0.26368E+01_JPRB,0.25318E+01_JPRB, &
 & 0.24566E+01_JPRB,0.27984E+01_JPRB,0.32648E+01_JPRB,0.36583E+01_JPRB /)  
KA(:, 2, 2,14) = (/ &
 & 0.38780E+01_JPRB,0.33972E+01_JPRB,0.29165E+01_JPRB,0.26245E+01_JPRB,0.25266E+01_JPRB, &
 & 0.24447E+01_JPRB,0.27836E+01_JPRB,0.32475E+01_JPRB,0.36397E+01_JPRB /)  
KA(:, 3, 2,14) = (/ &
 & 0.38887E+01_JPRB,0.34066E+01_JPRB,0.29246E+01_JPRB,0.26139E+01_JPRB,0.25181E+01_JPRB, &
 & 0.24355E+01_JPRB,0.27726E+01_JPRB,0.32346E+01_JPRB,0.36242E+01_JPRB /)  
KA(:, 4, 2,14) = (/ &
 & 0.39063E+01_JPRB,0.34220E+01_JPRB,0.29378E+01_JPRB,0.26094E+01_JPRB,0.25085E+01_JPRB, &
 & 0.24291E+01_JPRB,0.27676E+01_JPRB,0.32288E+01_JPRB,0.36150E+01_JPRB /)  
KA(:, 5, 2,14) = (/ &
 & 0.39241E+01_JPRB,0.34376E+01_JPRB,0.29511E+01_JPRB,0.26073E+01_JPRB,0.25021E+01_JPRB, &
 & 0.24243E+01_JPRB,0.27677E+01_JPRB,0.32289E+01_JPRB,0.36134E+01_JPRB /)  
KA(:, 1, 3,14) = (/ &
 & 0.42487E+01_JPRB,0.37216E+01_JPRB,0.32039E+01_JPRB,0.29799E+01_JPRB,0.28758E+01_JPRB, &
 & 0.27551E+01_JPRB,0.30498E+01_JPRB,0.35581E+01_JPRB,0.40304E+01_JPRB /)  
KA(:, 2, 3,14) = (/ &
 & 0.42439E+01_JPRB,0.37174E+01_JPRB,0.31977E+01_JPRB,0.29675E+01_JPRB,0.28698E+01_JPRB, &
 & 0.27440E+01_JPRB,0.30347E+01_JPRB,0.35405E+01_JPRB,0.40101E+01_JPRB /)  
KA(:, 3, 3,14) = (/ &
 & 0.42511E+01_JPRB,0.37238E+01_JPRB,0.32007E+01_JPRB,0.29528E+01_JPRB,0.28598E+01_JPRB, &
 & 0.27364E+01_JPRB,0.30269E+01_JPRB,0.35313E+01_JPRB,0.39978E+01_JPRB /)  
KA(:, 4, 3,14) = (/ &
 & 0.42624E+01_JPRB,0.37337E+01_JPRB,0.32078E+01_JPRB,0.29428E+01_JPRB,0.28469E+01_JPRB, &
 & 0.27311E+01_JPRB,0.30242E+01_JPRB,0.35281E+01_JPRB,0.39928E+01_JPRB /)  
KA(:, 5, 3,14) = (/ &
 & 0.42720E+01_JPRB,0.37420E+01_JPRB,0.32138E+01_JPRB,0.29343E+01_JPRB,0.28324E+01_JPRB, &
 & 0.27276E+01_JPRB,0.30224E+01_JPRB,0.35261E+01_JPRB,0.39910E+01_JPRB /)  
KA(:, 1, 4,14) = (/ &
 & 0.45954E+01_JPRB,0.40249E+01_JPRB,0.35022E+01_JPRB,0.33403E+01_JPRB,0.32328E+01_JPRB, &
 & 0.30833E+01_JPRB,0.33112E+01_JPRB,0.38621E+01_JPRB,0.43957E+01_JPRB /)  
KA(:, 2, 4,14) = (/ &
 & 0.45847E+01_JPRB,0.40157E+01_JPRB,0.34904E+01_JPRB,0.33265E+01_JPRB,0.32256E+01_JPRB, &
 & 0.30748E+01_JPRB,0.32975E+01_JPRB,0.38466E+01_JPRB,0.43773E+01_JPRB /)  
KA(:, 3, 4,14) = (/ &
 & 0.45864E+01_JPRB,0.40172E+01_JPRB,0.34822E+01_JPRB,0.33081E+01_JPRB,0.32132E+01_JPRB, &
 & 0.30693E+01_JPRB,0.32915E+01_JPRB,0.38399E+01_JPRB,0.43696E+01_JPRB /)  
KA(:, 4, 4,14) = (/ &
 & 0.45919E+01_JPRB,0.40220E+01_JPRB,0.34808E+01_JPRB,0.32873E+01_JPRB,0.31989E+01_JPRB, &
 & 0.30656E+01_JPRB,0.32892E+01_JPRB,0.38374E+01_JPRB,0.43666E+01_JPRB /)  
KA(:, 5, 4,14) = (/ &
 & 0.45961E+01_JPRB,0.40254E+01_JPRB,0.34809E+01_JPRB,0.32746E+01_JPRB,0.31817E+01_JPRB, &
 & 0.30639E+01_JPRB,0.32889E+01_JPRB,0.38370E+01_JPRB,0.43660E+01_JPRB /)  
KA(:, 1, 5,14) = (/ &
 & 0.49114E+01_JPRB,0.43012E+01_JPRB,0.38001E+01_JPRB,0.37007E+01_JPRB,0.36023E+01_JPRB, &
 & 0.34476E+01_JPRB,0.35973E+01_JPRB,0.41814E+01_JPRB,0.47692E+01_JPRB /)  
KA(:, 2, 5,14) = (/ &
 & 0.49023E+01_JPRB,0.42934E+01_JPRB,0.37862E+01_JPRB,0.36850E+01_JPRB,0.35912E+01_JPRB, &
 & 0.34412E+01_JPRB,0.35890E+01_JPRB,0.41727E+01_JPRB,0.47592E+01_JPRB /)  
KA(:, 3, 5,14) = (/ &
 & 0.48929E+01_JPRB,0.42852E+01_JPRB,0.37666E+01_JPRB,0.36647E+01_JPRB,0.35739E+01_JPRB, &
 & 0.34368E+01_JPRB,0.35843E+01_JPRB,0.41678E+01_JPRB,0.47530E+01_JPRB /)  
KA(:, 4, 5,14) = (/ &
 & 0.48957E+01_JPRB,0.42875E+01_JPRB,0.37577E+01_JPRB,0.36399E+01_JPRB,0.35570E+01_JPRB, &
 & 0.34352E+01_JPRB,0.35822E+01_JPRB,0.41658E+01_JPRB,0.47507E+01_JPRB /)  
KA(:, 5, 5,14) = (/ &
 & 0.48955E+01_JPRB,0.42870E+01_JPRB,0.37502E+01_JPRB,0.36181E+01_JPRB,0.35379E+01_JPRB, &
 & 0.34333E+01_JPRB,0.35807E+01_JPRB,0.41639E+01_JPRB,0.47483E+01_JPRB /)  
KA(:, 1, 6,14) = (/ &
 & 0.52336E+01_JPRB,0.45828E+01_JPRB,0.41059E+01_JPRB,0.40455E+01_JPRB,0.39709E+01_JPRB, &
 & 0.38438E+01_JPRB,0.39195E+01_JPRB,0.45101E+01_JPRB,0.51488E+01_JPRB /)  
KA(:, 2, 6,14) = (/ &
 & 0.52264E+01_JPRB,0.45766E+01_JPRB,0.40903E+01_JPRB,0.40272E+01_JPRB,0.39556E+01_JPRB, &
 & 0.38368E+01_JPRB,0.39154E+01_JPRB,0.45074E+01_JPRB,0.51460E+01_JPRB /)  
KA(:, 3, 6,14) = (/ &
 & 0.52116E+01_JPRB,0.45637E+01_JPRB,0.40682E+01_JPRB,0.40069E+01_JPRB,0.39387E+01_JPRB, &
 & 0.38311E+01_JPRB,0.39117E+01_JPRB,0.45034E+01_JPRB,0.51413E+01_JPRB /)  
KA(:, 4, 6,14) = (/ &
 & 0.52061E+01_JPRB,0.45585E+01_JPRB,0.40484E+01_JPRB,0.39793E+01_JPRB,0.39195E+01_JPRB, &
 & 0.38275E+01_JPRB,0.39110E+01_JPRB,0.45018E+01_JPRB,0.51396E+01_JPRB /)  
KA(:, 5, 6,14) = (/ &
 & 0.52033E+01_JPRB,0.45559E+01_JPRB,0.40356E+01_JPRB,0.39520E+01_JPRB,0.38983E+01_JPRB, &
 & 0.38238E+01_JPRB,0.39105E+01_JPRB,0.45008E+01_JPRB,0.51385E+01_JPRB /)  
KA(:, 1, 7,14) = (/ &
 & 0.55789E+01_JPRB,0.48845E+01_JPRB,0.44392E+01_JPRB,0.43787E+01_JPRB,0.43341E+01_JPRB, &
 & 0.42496E+01_JPRB,0.42580E+01_JPRB,0.48177E+01_JPRB,0.55034E+01_JPRB /)  
KA(:, 2, 7,14) = (/ &
 & 0.55750E+01_JPRB,0.48811E+01_JPRB,0.44216E+01_JPRB,0.43602E+01_JPRB,0.43147E+01_JPRB, &
 & 0.42460E+01_JPRB,0.42594E+01_JPRB,0.48202E+01_JPRB,0.55064E+01_JPRB /)  
KA(:, 3, 7,14) = (/ &
 & 0.55641E+01_JPRB,0.48716E+01_JPRB,0.43996E+01_JPRB,0.43387E+01_JPRB,0.42975E+01_JPRB, &
 & 0.42414E+01_JPRB,0.42613E+01_JPRB,0.48234E+01_JPRB,0.55098E+01_JPRB /)  
KA(:, 4, 7,14) = (/ &
 & 0.55497E+01_JPRB,0.48588E+01_JPRB,0.43740E+01_JPRB,0.43098E+01_JPRB,0.42767E+01_JPRB, &
 & 0.42365E+01_JPRB,0.42657E+01_JPRB,0.48283E+01_JPRB,0.55153E+01_JPRB /)  
KA(:, 5, 7,14) = (/ &
 & 0.55426E+01_JPRB,0.48524E+01_JPRB,0.43530E+01_JPRB,0.42800E+01_JPRB,0.42577E+01_JPRB, &
 & 0.42309E+01_JPRB,0.42668E+01_JPRB,0.48295E+01_JPRB,0.55168E+01_JPRB /)  
KA(:, 1, 8,14) = (/ &
 & 0.59399E+01_JPRB,0.51999E+01_JPRB,0.48042E+01_JPRB,0.47185E+01_JPRB,0.46865E+01_JPRB, &
 & 0.46496E+01_JPRB,0.46000E+01_JPRB,0.50897E+01_JPRB,0.58161E+01_JPRB /)  
KA(:, 2, 8,14) = (/ &
 & 0.59397E+01_JPRB,0.51999E+01_JPRB,0.47874E+01_JPRB,0.46998E+01_JPRB,0.46665E+01_JPRB, &
 & 0.46493E+01_JPRB,0.46097E+01_JPRB,0.50997E+01_JPRB,0.58275E+01_JPRB /)  
KA(:, 3, 8,14) = (/ &
 & 0.59349E+01_JPRB,0.51955E+01_JPRB,0.47656E+01_JPRB,0.46767E+01_JPRB,0.46485E+01_JPRB, &
 & 0.46473E+01_JPRB,0.46203E+01_JPRB,0.51120E+01_JPRB,0.58414E+01_JPRB /)  
KA(:, 4, 8,14) = (/ &
 & 0.59186E+01_JPRB,0.51811E+01_JPRB,0.47381E+01_JPRB,0.46470E+01_JPRB,0.46283E+01_JPRB, &
 & 0.46432E+01_JPRB,0.46335E+01_JPRB,0.51262E+01_JPRB,0.58574E+01_JPRB /)  
KA(:, 5, 8,14) = (/ &
 & 0.59097E+01_JPRB,0.51733E+01_JPRB,0.47110E+01_JPRB,0.46158E+01_JPRB,0.46095E+01_JPRB, &
 & 0.46379E+01_JPRB,0.46369E+01_JPRB,0.51321E+01_JPRB,0.58644E+01_JPRB /)  
KA(:, 1, 9,14) = (/ &
 & 0.63127E+01_JPRB,0.55322E+01_JPRB,0.51834E+01_JPRB,0.50691E+01_JPRB,0.50247E+01_JPRB, &
 & 0.50209E+01_JPRB,0.49367E+01_JPRB,0.53236E+01_JPRB,0.60842E+01_JPRB /)  
KA(:, 2, 9,14) = (/ &
 & 0.63183E+01_JPRB,0.55346E+01_JPRB,0.51727E+01_JPRB,0.50532E+01_JPRB,0.50080E+01_JPRB, &
 & 0.50274E+01_JPRB,0.49592E+01_JPRB,0.53436E+01_JPRB,0.61069E+01_JPRB /)  
KA(:, 3, 9,14) = (/ &
 & 0.63124E+01_JPRB,0.55272E+01_JPRB,0.51546E+01_JPRB,0.50297E+01_JPRB,0.49909E+01_JPRB, &
 & 0.50310E+01_JPRB,0.49812E+01_JPRB,0.53668E+01_JPRB,0.61332E+01_JPRB /)  
KA(:, 4, 9,14) = (/ &
 & 0.63001E+01_JPRB,0.55154E+01_JPRB,0.51286E+01_JPRB,0.50009E+01_JPRB,0.49750E+01_JPRB, &
 & 0.50299E+01_JPRB,0.49995E+01_JPRB,0.53888E+01_JPRB,0.61587E+01_JPRB /)  
KA(:, 5, 9,14) = (/ &
 & 0.62858E+01_JPRB,0.55023E+01_JPRB,0.50977E+01_JPRB,0.49708E+01_JPRB,0.49573E+01_JPRB, &
 & 0.50270E+01_JPRB,0.50058E+01_JPRB,0.53988E+01_JPRB,0.61697E+01_JPRB /)  
KA(:, 1,10,14) = (/ &
 & 0.66894E+01_JPRB,0.58832E+01_JPRB,0.55701E+01_JPRB,0.54237E+01_JPRB,0.53594E+01_JPRB, &
 & 0.53556E+01_JPRB,0.52686E+01_JPRB,0.55192E+01_JPRB,0.63037E+01_JPRB /)  
KA(:, 2,10,14) = (/ &
 & 0.66981E+01_JPRB,0.58851E+01_JPRB,0.55643E+01_JPRB,0.54120E+01_JPRB,0.53500E+01_JPRB, &
 & 0.53705E+01_JPRB,0.53019E+01_JPRB,0.55500E+01_JPRB,0.63389E+01_JPRB /)  
KA(:, 3,10,14) = (/ &
 & 0.66967E+01_JPRB,0.58795E+01_JPRB,0.55464E+01_JPRB,0.53921E+01_JPRB,0.53372E+01_JPRB, &
 & 0.53796E+01_JPRB,0.53288E+01_JPRB,0.55798E+01_JPRB,0.63734E+01_JPRB /)  
KA(:, 4,10,14) = (/ &
 & 0.66854E+01_JPRB,0.58646E+01_JPRB,0.55228E+01_JPRB,0.53676E+01_JPRB,0.53254E+01_JPRB, &
 & 0.53837E+01_JPRB,0.53529E+01_JPRB,0.56104E+01_JPRB,0.64086E+01_JPRB /)  
KA(:, 5,10,14) = (/ &
 & 0.66717E+01_JPRB,0.58486E+01_JPRB,0.54914E+01_JPRB,0.53392E+01_JPRB,0.53082E+01_JPRB, &
 & 0.53849E+01_JPRB,0.53627E+01_JPRB,0.56270E+01_JPRB,0.64281E+01_JPRB /)  
KA(:, 1,11,14) = (/ &
 & 0.70715E+01_JPRB,0.62495E+01_JPRB,0.59582E+01_JPRB,0.57869E+01_JPRB,0.56930E+01_JPRB, &
 & 0.56655E+01_JPRB,0.56036E+01_JPRB,0.57057E+01_JPRB,0.64838E+01_JPRB /)  
KA(:, 2,11,14) = (/ &
 & 0.70771E+01_JPRB,0.62459E+01_JPRB,0.59461E+01_JPRB,0.57734E+01_JPRB,0.56903E+01_JPRB, &
 & 0.56860E+01_JPRB,0.56380E+01_JPRB,0.57455E+01_JPRB,0.65310E+01_JPRB /)  
KA(:, 3,11,14) = (/ &
 & 0.70723E+01_JPRB,0.62337E+01_JPRB,0.59291E+01_JPRB,0.57507E+01_JPRB,0.56859E+01_JPRB, &
 & 0.56988E+01_JPRB,0.56691E+01_JPRB,0.57882E+01_JPRB,0.65837E+01_JPRB /)  
KA(:, 4,11,14) = (/ &
 & 0.70579E+01_JPRB,0.62141E+01_JPRB,0.59017E+01_JPRB,0.57243E+01_JPRB,0.56747E+01_JPRB, &
 & 0.57061E+01_JPRB,0.56917E+01_JPRB,0.58206E+01_JPRB,0.66248E+01_JPRB /)  
KA(:, 5,11,14) = (/ &
 & 0.70436E+01_JPRB,0.61942E+01_JPRB,0.58711E+01_JPRB,0.56953E+01_JPRB,0.56563E+01_JPRB, &
 & 0.57095E+01_JPRB,0.57007E+01_JPRB,0.58439E+01_JPRB,0.66547E+01_JPRB /)  
KA(:, 1,12,14) = (/ &
 & 0.73996E+01_JPRB,0.65875E+01_JPRB,0.63444E+01_JPRB,0.61468E+01_JPRB,0.60255E+01_JPRB, &
 & 0.59627E+01_JPRB,0.59009E+01_JPRB,0.58767E+01_JPRB,0.66113E+01_JPRB /)  
KA(:, 2,12,14) = (/ &
 & 0.74059E+01_JPRB,0.65818E+01_JPRB,0.63297E+01_JPRB,0.61319E+01_JPRB,0.60289E+01_JPRB, &
 & 0.59857E+01_JPRB,0.59393E+01_JPRB,0.59291E+01_JPRB,0.66795E+01_JPRB /)  
KA(:, 3,12,14) = (/ &
 & 0.73985E+01_JPRB,0.65639E+01_JPRB,0.63058E+01_JPRB,0.61104E+01_JPRB,0.60278E+01_JPRB, &
 & 0.60017E+01_JPRB,0.59765E+01_JPRB,0.59805E+01_JPRB,0.67466E+01_JPRB /)  
KA(:, 4,12,14) = (/ &
 & 0.73888E+01_JPRB,0.65439E+01_JPRB,0.62733E+01_JPRB,0.60850E+01_JPRB,0.60189E+01_JPRB, &
 & 0.60123E+01_JPRB,0.59968E+01_JPRB,0.60157E+01_JPRB,0.67935E+01_JPRB /)  
KA(:, 5,12,14) = (/ &
 & 0.73717E+01_JPRB,0.65185E+01_JPRB,0.62375E+01_JPRB,0.60536E+01_JPRB,0.59983E+01_JPRB, &
 & 0.60180E+01_JPRB,0.60067E+01_JPRB,0.60456E+01_JPRB,0.68365E+01_JPRB /)  
KA(:, 1,13,14) = (/ &
 & 0.76469E+01_JPRB,0.68731E+01_JPRB,0.66871E+01_JPRB,0.64997E+01_JPRB,0.63502E+01_JPRB, &
 & 0.62466E+01_JPRB,0.61469E+01_JPRB,0.60253E+01_JPRB,0.66908E+01_JPRB /)  
KA(:, 2,13,14) = (/ &
 & 0.76513E+01_JPRB,0.68603E+01_JPRB,0.66717E+01_JPRB,0.64853E+01_JPRB,0.63628E+01_JPRB, &
 & 0.62754E+01_JPRB,0.61942E+01_JPRB,0.60911E+01_JPRB,0.67781E+01_JPRB /)  
KA(:, 3,13,14) = (/ &
 & 0.76480E+01_JPRB,0.68404E+01_JPRB,0.66430E+01_JPRB,0.64664E+01_JPRB,0.63629E+01_JPRB, &
 & 0.62938E+01_JPRB,0.62370E+01_JPRB,0.61432E+01_JPRB,0.68460E+01_JPRB /)  
KA(:, 4,13,14) = (/ &
 & 0.76417E+01_JPRB,0.68180E+01_JPRB,0.66082E+01_JPRB,0.64389E+01_JPRB,0.63512E+01_JPRB, &
 & 0.63082E+01_JPRB,0.62633E+01_JPRB,0.61842E+01_JPRB,0.69071E+01_JPRB /)  
KA(:, 5,13,14) = (/ &
 & 0.76283E+01_JPRB,0.67918E+01_JPRB,0.65683E+01_JPRB,0.64071E+01_JPRB,0.63329E+01_JPRB, &
 & 0.63131E+01_JPRB,0.62779E+01_JPRB,0.62184E+01_JPRB,0.69616E+01_JPRB /)  
KA(:, 1, 1,15) = (/ &
 & 0.48056E+01_JPRB,0.42094E+01_JPRB,0.36132E+01_JPRB,0.30171E+01_JPRB,0.28404E+01_JPRB, &
 & 0.34490E+01_JPRB,0.41388E+01_JPRB,0.48284E+01_JPRB,0.52314E+01_JPRB /)  
KA(:, 2, 1,15) = (/ &
 & 0.48171E+01_JPRB,0.42194E+01_JPRB,0.36219E+01_JPRB,0.30243E+01_JPRB,0.28141E+01_JPRB, &
 & 0.34073E+01_JPRB,0.40887E+01_JPRB,0.47701E+01_JPRB,0.51637E+01_JPRB /)  
KA(:, 3, 1,15) = (/ &
 & 0.48231E+01_JPRB,0.42245E+01_JPRB,0.36259E+01_JPRB,0.30275E+01_JPRB,0.27871E+01_JPRB, &
 & 0.33709E+01_JPRB,0.40450E+01_JPRB,0.47190E+01_JPRB,0.51029E+01_JPRB /)  
KA(:, 4, 1,15) = (/ &
 & 0.48223E+01_JPRB,0.42236E+01_JPRB,0.36250E+01_JPRB,0.30265E+01_JPRB,0.27616E+01_JPRB, &
 & 0.33346E+01_JPRB,0.40014E+01_JPRB,0.46682E+01_JPRB,0.50473E+01_JPRB /)  
KA(:, 5, 1,15) = (/ &
 & 0.48164E+01_JPRB,0.42183E+01_JPRB,0.36202E+01_JPRB,0.30224E+01_JPRB,0.27378E+01_JPRB, &
 & 0.32980E+01_JPRB,0.39575E+01_JPRB,0.46170E+01_JPRB,0.49922E+01_JPRB /)  
KA(:, 1, 2,15) = (/ &
 & 0.56696E+01_JPRB,0.49649E+01_JPRB,0.42601E+01_JPRB,0.35603E+01_JPRB,0.33660E+01_JPRB, &
 & 0.40230E+01_JPRB,0.48275E+01_JPRB,0.56320E+01_JPRB,0.62204E+01_JPRB /)  
KA(:, 2, 2,15) = (/ &
 & 0.56853E+01_JPRB,0.49788E+01_JPRB,0.42721E+01_JPRB,0.35690E+01_JPRB,0.33370E+01_JPRB, &
 & 0.39815E+01_JPRB,0.47778E+01_JPRB,0.55740E+01_JPRB,0.61522E+01_JPRB /)  
KA(:, 3, 2,15) = (/ &
 & 0.56912E+01_JPRB,0.49841E+01_JPRB,0.42769E+01_JPRB,0.35723E+01_JPRB,0.33088E+01_JPRB, &
 & 0.39404E+01_JPRB,0.47285E+01_JPRB,0.55164E+01_JPRB,0.60886E+01_JPRB /)  
KA(:, 4, 2,15) = (/ &
 & 0.56900E+01_JPRB,0.49829E+01_JPRB,0.42759E+01_JPRB,0.35705E+01_JPRB,0.32819E+01_JPRB, &
 & 0.38975E+01_JPRB,0.46769E+01_JPRB,0.54563E+01_JPRB,0.60227E+01_JPRB /)  
KA(:, 5, 2,15) = (/ &
 & 0.56828E+01_JPRB,0.49765E+01_JPRB,0.42703E+01_JPRB,0.35653E+01_JPRB,0.32552E+01_JPRB, &
 & 0.38520E+01_JPRB,0.46223E+01_JPRB,0.53926E+01_JPRB,0.59537E+01_JPRB /)  
KA(:, 1, 3,15) = (/ &
 & 0.66640E+01_JPRB,0.58345E+01_JPRB,0.50050E+01_JPRB,0.41960E+01_JPRB,0.39837E+01_JPRB, &
 & 0.46765E+01_JPRB,0.56117E+01_JPRB,0.65468E+01_JPRB,0.73624E+01_JPRB /)  
KA(:, 2, 3,15) = (/ &
 & 0.66851E+01_JPRB,0.58530E+01_JPRB,0.50209E+01_JPRB,0.42035E+01_JPRB,0.39538E+01_JPRB, &
 & 0.46274E+01_JPRB,0.55528E+01_JPRB,0.64781E+01_JPRB,0.72849E+01_JPRB /)  
KA(:, 3, 3,15) = (/ &
 & 0.66916E+01_JPRB,0.58588E+01_JPRB,0.50261E+01_JPRB,0.42046E+01_JPRB,0.39240E+01_JPRB, &
 & 0.45763E+01_JPRB,0.54915E+01_JPRB,0.64066E+01_JPRB,0.72060E+01_JPRB /)  
KA(:, 4, 3,15) = (/ &
 & 0.66884E+01_JPRB,0.58563E+01_JPRB,0.50241E+01_JPRB,0.42004E+01_JPRB,0.38957E+01_JPRB, &
 & 0.45225E+01_JPRB,0.54270E+01_JPRB,0.63313E+01_JPRB,0.71219E+01_JPRB /)  
KA(:, 5, 3,15) = (/ &
 & 0.66766E+01_JPRB,0.58462E+01_JPRB,0.50163E+01_JPRB,0.41933E+01_JPRB,0.38675E+01_JPRB, &
 & 0.44702E+01_JPRB,0.53642E+01_JPRB,0.62581E+01_JPRB,0.70387E+01_JPRB /)  
KA(:, 1, 4,15) = (/ &
 & 0.77848E+01_JPRB,0.68149E+01_JPRB,0.58451E+01_JPRB,0.49331E+01_JPRB,0.46977E+01_JPRB, &
 & 0.54033E+01_JPRB,0.64839E+01_JPRB,0.75644E+01_JPRB,0.85830E+01_JPRB /)  
KA(:, 2, 4,15) = (/ &
 & 0.78108E+01_JPRB,0.68377E+01_JPRB,0.58646E+01_JPRB,0.49375E+01_JPRB,0.46695E+01_JPRB, &
 & 0.53453E+01_JPRB,0.64143E+01_JPRB,0.74831E+01_JPRB,0.84915E+01_JPRB /)  
KA(:, 3, 4,15) = (/ &
 & 0.78236E+01_JPRB,0.68489E+01_JPRB,0.58743E+01_JPRB,0.49373E+01_JPRB,0.46417E+01_JPRB, &
 & 0.52821E+01_JPRB,0.63384E+01_JPRB,0.73947E+01_JPRB,0.83915E+01_JPRB /)  
KA(:, 4, 4,15) = (/ &
 & 0.78238E+01_JPRB,0.68493E+01_JPRB,0.58748E+01_JPRB,0.49301E+01_JPRB,0.46103E+01_JPRB, &
 & 0.52166E+01_JPRB,0.62599E+01_JPRB,0.73031E+01_JPRB,0.82871E+01_JPRB /)  
KA(:, 5, 4,15) = (/ &
 & 0.78090E+01_JPRB,0.68373E+01_JPRB,0.58658E+01_JPRB,0.49180E+01_JPRB,0.45786E+01_JPRB, &
 & 0.51516E+01_JPRB,0.61819E+01_JPRB,0.72121E+01_JPRB,0.81837E+01_JPRB /)  
KA(:, 1, 5,15) = (/ &
 & 0.90367E+01_JPRB,0.79101E+01_JPRB,0.67835E+01_JPRB,0.57840E+01_JPRB,0.55090E+01_JPRB, &
 & 0.61816E+01_JPRB,0.74174E+01_JPRB,0.86536E+01_JPRB,0.98560E+01_JPRB /)  
KA(:, 2, 5,15) = (/ &
 & 0.90658E+01_JPRB,0.79355E+01_JPRB,0.68052E+01_JPRB,0.57840E+01_JPRB,0.54825E+01_JPRB, &
 & 0.61122E+01_JPRB,0.73329E+01_JPRB,0.85548E+01_JPRB,0.97452E+01_JPRB /)  
KA(:, 3, 5,15) = (/ &
 & 0.90837E+01_JPRB,0.79512E+01_JPRB,0.68188E+01_JPRB,0.57766E+01_JPRB,0.54581E+01_JPRB, &
 & 0.60426E+01_JPRB,0.72485E+01_JPRB,0.84564E+01_JPRB,0.96328E+01_JPRB /)  
KA(:, 4, 5,15) = (/ &
 & 0.90830E+01_JPRB,0.79510E+01_JPRB,0.68192E+01_JPRB,0.57645E+01_JPRB,0.54297E+01_JPRB, &
 & 0.59729E+01_JPRB,0.71644E+01_JPRB,0.83583E+01_JPRB,0.95205E+01_JPRB /)  
KA(:, 5, 5,15) = (/ &
 & 0.90677E+01_JPRB,0.79386E+01_JPRB,0.68094E+01_JPRB,0.57479E+01_JPRB,0.53962E+01_JPRB, &
 & 0.58998E+01_JPRB,0.70740E+01_JPRB,0.82528E+01_JPRB,0.94008E+01_JPRB /)  
KA(:, 1, 6,15) = (/ &
 & 0.10412E+02_JPRB,0.91128E+01_JPRB,0.78140E+01_JPRB,0.67504E+01_JPRB,0.64389E+01_JPRB, &
 & 0.70217E+01_JPRB,0.83899E+01_JPRB,0.97882E+01_JPRB,0.11168E+02_JPRB /)  
KA(:, 2, 6,15) = (/ &
 & 0.10449E+02_JPRB,0.91451E+01_JPRB,0.78417E+01_JPRB,0.67466E+01_JPRB,0.64110E+01_JPRB, &
 & 0.69507E+01_JPRB,0.82964E+01_JPRB,0.96789E+01_JPRB,0.11043E+02_JPRB /)  
KA(:, 3, 6,15) = (/ &
 & 0.10469E+02_JPRB,0.91634E+01_JPRB,0.78574E+01_JPRB,0.67323E+01_JPRB,0.63834E+01_JPRB, &
 & 0.68804E+01_JPRB,0.82097E+01_JPRB,0.95778E+01_JPRB,0.10928E+02_JPRB /)  
KA(:, 4, 6,15) = (/ &
 & 0.10466E+02_JPRB,0.91614E+01_JPRB,0.78568E+01_JPRB,0.67135E+01_JPRB,0.63530E+01_JPRB, &
 & 0.68083E+01_JPRB,0.81167E+01_JPRB,0.94694E+01_JPRB,0.10805E+02_JPRB /)  
KA(:, 5, 6,15) = (/ &
 & 0.10450E+02_JPRB,0.91481E+01_JPRB,0.78461E+01_JPRB,0.66866E+01_JPRB,0.63182E+01_JPRB, &
 & 0.67317E+01_JPRB,0.80175E+01_JPRB,0.93536E+01_JPRB,0.10671E+02_JPRB /)  
KA(:, 1, 7,15) = (/ &
 & 0.11882E+02_JPRB,0.10399E+02_JPRB,0.89166E+01_JPRB,0.78253E+01_JPRB,0.74792E+01_JPRB, &
 & 0.79512E+01_JPRB,0.94202E+01_JPRB,0.10990E+02_JPRB,0.12550E+02_JPRB /)  
KA(:, 2, 7,15) = (/ &
 & 0.11932E+02_JPRB,0.10443E+02_JPRB,0.89541E+01_JPRB,0.78202E+01_JPRB,0.74549E+01_JPRB, &
 & 0.78754E+01_JPRB,0.93207E+01_JPRB,0.10874E+02_JPRB,0.12417E+02_JPRB /)  
KA(:, 3, 7,15) = (/ &
 & 0.11956E+02_JPRB,0.10464E+02_JPRB,0.89727E+01_JPRB,0.78020E+01_JPRB,0.74258E+01_JPRB, &
 & 0.78051E+01_JPRB,0.92218E+01_JPRB,0.10758E+02_JPRB,0.12285E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART10',1,ZHOOK_HANDLE)
END SUBROUTINE PART10


SUBROUTINE PART11

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART11',0,ZHOOK_HANDLE)


KA(:, 4, 7,15) = (/ &
 & 0.11956E+02_JPRB,0.10465E+02_JPRB,0.89740E+01_JPRB,0.77736E+01_JPRB,0.73912E+01_JPRB, &
 & 0.77319E+01_JPRB,0.91108E+01_JPRB,0.10629E+02_JPRB,0.12138E+02_JPRB /)  
KA(:, 5, 7,15) = (/ &
 & 0.11934E+02_JPRB,0.10446E+02_JPRB,0.89587E+01_JPRB,0.77346E+01_JPRB,0.73464E+01_JPRB, &
 & 0.76503E+01_JPRB,0.90007E+01_JPRB,0.10501E+02_JPRB,0.11991E+02_JPRB /)  
KA(:, 1, 8,15) = (/ &
 & 0.13440E+02_JPRB,0.11762E+02_JPRB,0.10084E+02_JPRB,0.90134E+01_JPRB,0.86298E+01_JPRB, &
 & 0.89787E+01_JPRB,0.10509E+02_JPRB,0.12260E+02_JPRB,0.14008E+02_JPRB /)  
KA(:, 2, 8,15) = (/ &
 & 0.13496E+02_JPRB,0.11811E+02_JPRB,0.10127E+02_JPRB,0.90042E+01_JPRB,0.86075E+01_JPRB, &
 & 0.89016E+01_JPRB,0.10401E+02_JPRB,0.12134E+02_JPRB,0.13863E+02_JPRB /)  
KA(:, 3, 8,15) = (/ &
 & 0.13522E+02_JPRB,0.11835E+02_JPRB,0.10148E+02_JPRB,0.89806E+01_JPRB,0.85777E+01_JPRB, &
 & 0.88306E+01_JPRB,0.10284E+02_JPRB,0.11998E+02_JPRB,0.13707E+02_JPRB /)  
KA(:, 4, 8,15) = (/ &
 & 0.13526E+02_JPRB,0.11839E+02_JPRB,0.10151E+02_JPRB,0.89422E+01_JPRB,0.85378E+01_JPRB, &
 & 0.87510E+01_JPRB,0.10150E+02_JPRB,0.11842E+02_JPRB,0.13529E+02_JPRB /)  
KA(:, 5, 8,15) = (/ &
 & 0.13498E+02_JPRB,0.11814E+02_JPRB,0.10131E+02_JPRB,0.88918E+01_JPRB,0.84819E+01_JPRB, &
 & 0.86621E+01_JPRB,0.10028E+02_JPRB,0.11700E+02_JPRB,0.13367E+02_JPRB /)  
KA(:, 1, 9,15) = (/ &
 & 0.15050E+02_JPRB,0.13171E+02_JPRB,0.11325E+02_JPRB,0.10314E+02_JPRB,0.98844E+01_JPRB, &
 & 0.10113E+02_JPRB,0.11655E+02_JPRB,0.13598E+02_JPRB,0.15538E+02_JPRB /)  
KA(:, 2, 9,15) = (/ &
 & 0.15110E+02_JPRB,0.13224E+02_JPRB,0.11358E+02_JPRB,0.10290E+02_JPRB,0.98636E+01_JPRB, &
 & 0.10034E+02_JPRB,0.11528E+02_JPRB,0.13449E+02_JPRB,0.15369E+02_JPRB /)  
KA(:, 3, 9,15) = (/ &
 & 0.15142E+02_JPRB,0.13253E+02_JPRB,0.11372E+02_JPRB,0.10253E+02_JPRB,0.98329E+01_JPRB, &
 & 0.99565E+01_JPRB,0.11387E+02_JPRB,0.13285E+02_JPRB,0.15182E+02_JPRB /)  
KA(:, 4, 9,15) = (/ &
 & 0.15140E+02_JPRB,0.13251E+02_JPRB,0.11368E+02_JPRB,0.10200E+02_JPRB,0.97822E+01_JPRB, &
 & 0.98656E+01_JPRB,0.11236E+02_JPRB,0.13109E+02_JPRB,0.14981E+02_JPRB /)  
KA(:, 5, 9,15) = (/ &
 & 0.15112E+02_JPRB,0.13227E+02_JPRB,0.11344E+02_JPRB,0.10134E+02_JPRB,0.97132E+01_JPRB, &
 & 0.97634E+01_JPRB,0.11104E+02_JPRB,0.12955E+02_JPRB,0.14806E+02_JPRB /)  
KA(:, 1,10,15) = (/ &
 & 0.16679E+02_JPRB,0.14596E+02_JPRB,0.12639E+02_JPRB,0.11713E+02_JPRB,0.11234E+02_JPRB, &
 & 0.11344E+02_JPRB,0.12833E+02_JPRB,0.14972E+02_JPRB,0.17110E+02_JPRB /)  
KA(:, 2,10,15) = (/ &
 & 0.16740E+02_JPRB,0.14649E+02_JPRB,0.12658E+02_JPRB,0.11669E+02_JPRB,0.11203E+02_JPRB, &
 & 0.11257E+02_JPRB,0.12688E+02_JPRB,0.14803E+02_JPRB,0.16918E+02_JPRB /)  
KA(:, 3,10,15) = (/ &
 & 0.16768E+02_JPRB,0.14675E+02_JPRB,0.12658E+02_JPRB,0.11609E+02_JPRB,0.11161E+02_JPRB, &
 & 0.11169E+02_JPRB,0.12530E+02_JPRB,0.14619E+02_JPRB,0.16708E+02_JPRB /)  
KA(:, 4,10,15) = (/ &
 & 0.16761E+02_JPRB,0.14669E+02_JPRB,0.12632E+02_JPRB,0.11528E+02_JPRB,0.11096E+02_JPRB, &
 & 0.11064E+02_JPRB,0.12360E+02_JPRB,0.14420E+02_JPRB,0.16480E+02_JPRB /)  
KA(:, 5,10,15) = (/ &
 & 0.16723E+02_JPRB,0.14636E+02_JPRB,0.12592E+02_JPRB,0.11437E+02_JPRB,0.11017E+02_JPRB, &
 & 0.10938E+02_JPRB,0.12210E+02_JPRB,0.14245E+02_JPRB,0.16279E+02_JPRB /)  
KA(:, 1,11,15) = (/ &
 & 0.18294E+02_JPRB,0.16009E+02_JPRB,0.13989E+02_JPRB,0.13135E+02_JPRB,0.12643E+02_JPRB, &
 & 0.12628E+02_JPRB,0.13972E+02_JPRB,0.16290E+02_JPRB,0.18616E+02_JPRB /)  
KA(:, 2,11,15) = (/ &
 & 0.18347E+02_JPRB,0.16056E+02_JPRB,0.13990E+02_JPRB,0.13069E+02_JPRB,0.12593E+02_JPRB, &
 & 0.12524E+02_JPRB,0.13808E+02_JPRB,0.16097E+02_JPRB,0.18396E+02_JPRB /)  
KA(:, 3,11,15) = (/ &
 & 0.18360E+02_JPRB,0.16067E+02_JPRB,0.13961E+02_JPRB,0.12977E+02_JPRB,0.12519E+02_JPRB, &
 & 0.12404E+02_JPRB,0.13621E+02_JPRB,0.15875E+02_JPRB,0.18143E+02_JPRB /)  
KA(:, 4,11,15) = (/ &
 & 0.18335E+02_JPRB,0.16046E+02_JPRB,0.13912E+02_JPRB,0.12870E+02_JPRB,0.12428E+02_JPRB, &
 & 0.12262E+02_JPRB,0.13438E+02_JPRB,0.15668E+02_JPRB,0.17906E+02_JPRB /)  
KA(:, 5,11,15) = (/ &
 & 0.18275E+02_JPRB,0.15994E+02_JPRB,0.13835E+02_JPRB,0.12741E+02_JPRB,0.12318E+02_JPRB, &
 & 0.12107E+02_JPRB,0.13269E+02_JPRB,0.15473E+02_JPRB,0.17684E+02_JPRB /)  
KA(:, 1,12,15) = (/ &
 & 0.19924E+02_JPRB,0.17435E+02_JPRB,0.15328E+02_JPRB,0.14570E+02_JPRB,0.14103E+02_JPRB, &
 & 0.13966E+02_JPRB,0.15137E+02_JPRB,0.17574E+02_JPRB,0.20085E+02_JPRB /)  
KA(:, 2,12,15) = (/ &
 & 0.19952E+02_JPRB,0.17460E+02_JPRB,0.15303E+02_JPRB,0.14472E+02_JPRB,0.14016E+02_JPRB, &
 & 0.13836E+02_JPRB,0.14951E+02_JPRB,0.17356E+02_JPRB,0.19836E+02_JPRB /)  
KA(:, 3,12,15) = (/ &
 & 0.19950E+02_JPRB,0.17459E+02_JPRB,0.15252E+02_JPRB,0.14354E+02_JPRB,0.13911E+02_JPRB, &
 & 0.13674E+02_JPRB,0.14736E+02_JPRB,0.17121E+02_JPRB,0.19567E+02_JPRB /)  
KA(:, 4,12,15) = (/ &
 & 0.19898E+02_JPRB,0.17414E+02_JPRB,0.15172E+02_JPRB,0.14207E+02_JPRB,0.13782E+02_JPRB, &
 & 0.13496E+02_JPRB,0.14540E+02_JPRB,0.16905E+02_JPRB,0.19321E+02_JPRB /)  
KA(:, 5,12,15) = (/ &
 & 0.19813E+02_JPRB,0.17339E+02_JPRB,0.15067E+02_JPRB,0.14045E+02_JPRB,0.13635E+02_JPRB, &
 & 0.13302E+02_JPRB,0.14349E+02_JPRB,0.16691E+02_JPRB,0.19076E+02_JPRB /)  
KA(:, 1,13,15) = (/ &
 & 0.21582E+02_JPRB,0.18886E+02_JPRB,0.16708E+02_JPRB,0.15984E+02_JPRB,0.15578E+02_JPRB, &
 & 0.15338E+02_JPRB,0.16324E+02_JPRB,0.18812E+02_JPRB,0.21500E+02_JPRB /)  
KA(:, 2,13,15) = (/ &
 & 0.21595E+02_JPRB,0.18898E+02_JPRB,0.16645E+02_JPRB,0.15860E+02_JPRB,0.15448E+02_JPRB, &
 & 0.15169E+02_JPRB,0.16117E+02_JPRB,0.18583E+02_JPRB,0.21237E+02_JPRB /)  
KA(:, 3,13,15) = (/ &
 & 0.21561E+02_JPRB,0.18868E+02_JPRB,0.16562E+02_JPRB,0.15696E+02_JPRB,0.15303E+02_JPRB, &
 & 0.14968E+02_JPRB,0.15881E+02_JPRB,0.18352E+02_JPRB,0.20974E+02_JPRB /)  
KA(:, 4,13,15) = (/ &
 & 0.21483E+02_JPRB,0.18800E+02_JPRB,0.16445E+02_JPRB,0.15517E+02_JPRB,0.15132E+02_JPRB, &
 & 0.14742E+02_JPRB,0.15661E+02_JPRB,0.18119E+02_JPRB,0.20709E+02_JPRB /)  
KA(:, 5,13,15) = (/ &
 & 0.21359E+02_JPRB,0.18692E+02_JPRB,0.16307E+02_JPRB,0.15310E+02_JPRB,0.14932E+02_JPRB, &
 & 0.14513E+02_JPRB,0.15442E+02_JPRB,0.17892E+02_JPRB,0.20448E+02_JPRB /)  
KA(:, 1, 1,16) = (/ &
 & 0.54900E+01_JPRB,0.48060E+01_JPRB,0.41232E+01_JPRB,0.34422E+01_JPRB,0.34870E+01_JPRB, &
 & 0.43588E+01_JPRB,0.52305E+01_JPRB,0.61020E+01_JPRB,0.65047E+01_JPRB /)  
KA(:, 2, 1,16) = (/ &
 & 0.54959E+01_JPRB,0.48102E+01_JPRB,0.41246E+01_JPRB,0.34396E+01_JPRB,0.34389E+01_JPRB, &
 & 0.42986E+01_JPRB,0.51583E+01_JPRB,0.60178E+01_JPRB,0.64181E+01_JPRB /)  
KA(:, 3, 1,16) = (/ &
 & 0.54964E+01_JPRB,0.48111E+01_JPRB,0.41257E+01_JPRB,0.34404E+01_JPRB,0.33906E+01_JPRB, &
 & 0.42383E+01_JPRB,0.50859E+01_JPRB,0.59334E+01_JPRB,0.63255E+01_JPRB /)  
KA(:, 4, 1,16) = (/ &
 & 0.54872E+01_JPRB,0.48032E+01_JPRB,0.41193E+01_JPRB,0.34354E+01_JPRB,0.33485E+01_JPRB, &
 & 0.41856E+01_JPRB,0.50227E+01_JPRB,0.58596E+01_JPRB,0.62437E+01_JPRB /)  
KA(:, 5, 1,16) = (/ &
 & 0.54677E+01_JPRB,0.47864E+01_JPRB,0.41051E+01_JPRB,0.34238E+01_JPRB,0.33099E+01_JPRB, &
 & 0.41373E+01_JPRB,0.49647E+01_JPRB,0.57920E+01_JPRB,0.61726E+01_JPRB /)  
KA(:, 1, 2,16) = (/ &
 & 0.65993E+01_JPRB,0.57796E+01_JPRB,0.49604E+01_JPRB,0.41421E+01_JPRB,0.42011E+01_JPRB, &
 & 0.52514E+01_JPRB,0.63014E+01_JPRB,0.73516E+01_JPRB,0.80279E+01_JPRB /)  
KA(:, 2, 2,16) = (/ &
 & 0.66032E+01_JPRB,0.57810E+01_JPRB,0.49597E+01_JPRB,0.41395E+01_JPRB,0.41430E+01_JPRB, &
 & 0.51787E+01_JPRB,0.62144E+01_JPRB,0.72499E+01_JPRB,0.79170E+01_JPRB /)  
KA(:, 3, 2,16) = (/ &
 & 0.66114E+01_JPRB,0.57864E+01_JPRB,0.49618E+01_JPRB,0.41380E+01_JPRB,0.40849E+01_JPRB, &
 & 0.51061E+01_JPRB,0.61273E+01_JPRB,0.71483E+01_JPRB,0.78058E+01_JPRB /)  
KA(:, 4, 2,16) = (/ &
 & 0.66055E+01_JPRB,0.57814E+01_JPRB,0.49573E+01_JPRB,0.41341E+01_JPRB,0.40341E+01_JPRB, &
 & 0.50426E+01_JPRB,0.60510E+01_JPRB,0.70593E+01_JPRB,0.77043E+01_JPRB /)  
KA(:, 5, 2,16) = (/ &
 & 0.65867E+01_JPRB,0.57651E+01_JPRB,0.49435E+01_JPRB,0.41221E+01_JPRB,0.39863E+01_JPRB, &
 & 0.49829E+01_JPRB,0.59794E+01_JPRB,0.69758E+01_JPRB,0.76124E+01_JPRB /)  
KA(:, 1, 3,16) = (/ &
 & 0.79380E+01_JPRB,0.69526E+01_JPRB,0.59676E+01_JPRB,0.49832E+01_JPRB,0.50788E+01_JPRB, &
 & 0.63485E+01_JPRB,0.76181E+01_JPRB,0.88875E+01_JPRB,0.99377E+01_JPRB /)  
KA(:, 2, 3,16) = (/ &
 & 0.79519E+01_JPRB,0.69640E+01_JPRB,0.59765E+01_JPRB,0.49895E+01_JPRB,0.50033E+01_JPRB, &
 & 0.62541E+01_JPRB,0.75048E+01_JPRB,0.87554E+01_JPRB,0.97869E+01_JPRB /)  
KA(:, 3, 3,16) = (/ &
 & 0.79564E+01_JPRB,0.69660E+01_JPRB,0.59762E+01_JPRB,0.49871E+01_JPRB,0.49341E+01_JPRB, &
 & 0.61676E+01_JPRB,0.74011E+01_JPRB,0.86343E+01_JPRB,0.96531E+01_JPRB /)  
KA(:, 4, 3,16) = (/ &
 & 0.79604E+01_JPRB,0.69678E+01_JPRB,0.59753E+01_JPRB,0.49833E+01_JPRB,0.48716E+01_JPRB, &
 & 0.60895E+01_JPRB,0.73073E+01_JPRB,0.85250E+01_JPRB,0.95280E+01_JPRB /)  
KA(:, 5, 3,16) = (/ &
 & 0.79454E+01_JPRB,0.69546E+01_JPRB,0.59641E+01_JPRB,0.49739E+01_JPRB,0.48117E+01_JPRB, &
 & 0.60146E+01_JPRB,0.72174E+01_JPRB,0.84201E+01_JPRB,0.94106E+01_JPRB /)  
KA(:, 1, 4,16) = (/ &
 & 0.95482E+01_JPRB,0.83619E+01_JPRB,0.71758E+01_JPRB,0.59904E+01_JPRB,0.61617E+01_JPRB, &
 & 0.77021E+01_JPRB,0.92425E+01_JPRB,0.10783E+02_JPRB,0.12199E+02_JPRB /)  
KA(:, 2, 4,16) = (/ &
 & 0.95751E+01_JPRB,0.83849E+01_JPRB,0.71952E+01_JPRB,0.60057E+01_JPRB,0.60507E+01_JPRB, &
 & 0.75634E+01_JPRB,0.90760E+01_JPRB,0.10588E+02_JPRB,0.11979E+02_JPRB /)  
KA(:, 3, 4,16) = (/ &
 & 0.95851E+01_JPRB,0.83928E+01_JPRB,0.72008E+01_JPRB,0.60093E+01_JPRB,0.59519E+01_JPRB, &
 & 0.74398E+01_JPRB,0.89277E+01_JPRB,0.10415E+02_JPRB,0.11784E+02_JPRB /)  
KA(:, 4, 4,16) = (/ &
 & 0.95899E+01_JPRB,0.83956E+01_JPRB,0.72016E+01_JPRB,0.60083E+01_JPRB,0.58751E+01_JPRB, &
 & 0.73438E+01_JPRB,0.88125E+01_JPRB,0.10281E+02_JPRB,0.11628E+02_JPRB /)  
KA(:, 5, 4,16) = (/ &
 & 0.95802E+01_JPRB,0.83858E+01_JPRB,0.71919E+01_JPRB,0.59984E+01_JPRB,0.58004E+01_JPRB, &
 & 0.72505E+01_JPRB,0.87005E+01_JPRB,0.10150E+02_JPRB,0.11482E+02_JPRB /)  
KA(:, 1, 5,16) = (/ &
 & 0.11467E+02_JPRB,0.10041E+02_JPRB,0.86153E+01_JPRB,0.71899E+01_JPRB,0.74662E+01_JPRB, &
 & 0.93327E+01_JPRB,0.11199E+02_JPRB,0.13065E+02_JPRB,0.14858E+02_JPRB /)  
KA(:, 2, 5,16) = (/ &
 & 0.11518E+02_JPRB,0.10085E+02_JPRB,0.86526E+01_JPRB,0.72201E+01_JPRB,0.73208E+01_JPRB, &
 & 0.91509E+01_JPRB,0.10981E+02_JPRB,0.12811E+02_JPRB,0.14568E+02_JPRB /)  
KA(:, 3, 5,16) = (/ &
 & 0.11535E+02_JPRB,0.10099E+02_JPRB,0.86636E+01_JPRB,0.72282E+01_JPRB,0.71844E+01_JPRB, &
 & 0.89805E+01_JPRB,0.10776E+02_JPRB,0.12572E+02_JPRB,0.14298E+02_JPRB /)  
KA(:, 4, 5,16) = (/ &
 & 0.11542E+02_JPRB,0.10105E+02_JPRB,0.86677E+01_JPRB,0.72309E+01_JPRB,0.70636E+01_JPRB, &
 & 0.88295E+01_JPRB,0.10595E+02_JPRB,0.12361E+02_JPRB,0.14056E+02_JPRB /)  
KA(:, 5, 5,16) = (/ &
 & 0.11528E+02_JPRB,0.10092E+02_JPRB,0.86561E+01_JPRB,0.72209E+01_JPRB,0.69634E+01_JPRB, &
 & 0.87042E+01_JPRB,0.10445E+02_JPRB,0.12185E+02_JPRB,0.13857E+02_JPRB /)  
KA(:, 1, 6,16) = (/ &
 & 0.13743E+02_JPRB,0.12032E+02_JPRB,0.10321E+02_JPRB,0.86104E+01_JPRB,0.90301E+01_JPRB, &
 & 0.11288E+02_JPRB,0.13545E+02_JPRB,0.15802E+02_JPRB,0.18010E+02_JPRB /)  
KA(:, 2, 6,16) = (/ &
 & 0.13809E+02_JPRB,0.12090E+02_JPRB,0.10370E+02_JPRB,0.86513E+01_JPRB,0.88422E+01_JPRB, &
 & 0.11053E+02_JPRB,0.13263E+02_JPRB,0.15473E+02_JPRB,0.17638E+02_JPRB /)  
KA(:, 3, 6,16) = (/ &
 & 0.13850E+02_JPRB,0.12125E+02_JPRB,0.10400E+02_JPRB,0.86753E+01_JPRB,0.86607E+01_JPRB, &
 & 0.10826E+02_JPRB,0.12991E+02_JPRB,0.15156E+02_JPRB,0.17275E+02_JPRB /)  
KA(:, 4, 6,16) = (/ &
 & 0.13866E+02_JPRB,0.12138E+02_JPRB,0.10411E+02_JPRB,0.86837E+01_JPRB,0.84930E+01_JPRB, &
 & 0.10616E+02_JPRB,0.12739E+02_JPRB,0.14862E+02_JPRB,0.16940E+02_JPRB /)  
KA(:, 5, 6,16) = (/ &
 & 0.13850E+02_JPRB,0.12124E+02_JPRB,0.10399E+02_JPRB,0.86732E+01_JPRB,0.83442E+01_JPRB, &
 & 0.10430E+02_JPRB,0.12516E+02_JPRB,0.14602E+02_JPRB,0.16644E+02_JPRB /)  
KA(:, 1, 7,16) = (/ &
 & 0.16450E+02_JPRB,0.14400E+02_JPRB,0.12350E+02_JPRB,0.10300E+02_JPRB,0.10874E+02_JPRB, &
 & 0.13593E+02_JPRB,0.16311E+02_JPRB,0.19030E+02_JPRB,0.21722E+02_JPRB /)  
KA(:, 2, 7,16) = (/ &
 & 0.16525E+02_JPRB,0.14465E+02_JPRB,0.12405E+02_JPRB,0.10346E+02_JPRB,0.10632E+02_JPRB, &
 & 0.13290E+02_JPRB,0.15948E+02_JPRB,0.18606E+02_JPRB,0.21239E+02_JPRB /)  
KA(:, 3, 7,16) = (/ &
 & 0.16563E+02_JPRB,0.14499E+02_JPRB,0.12434E+02_JPRB,0.10370E+02_JPRB,0.10395E+02_JPRB, &
 & 0.12994E+02_JPRB,0.15592E+02_JPRB,0.18191E+02_JPRB,0.20762E+02_JPRB /)  
KA(:, 4, 7,16) = (/ &
 & 0.16590E+02_JPRB,0.14522E+02_JPRB,0.12454E+02_JPRB,0.10386E+02_JPRB,0.10172E+02_JPRB, &
 & 0.12715E+02_JPRB,0.15258E+02_JPRB,0.17801E+02_JPRB,0.20317E+02_JPRB /)  
KA(:, 5, 7,16) = (/ &
 & 0.16576E+02_JPRB,0.14509E+02_JPRB,0.12443E+02_JPRB,0.10377E+02_JPRB,0.99688E+01_JPRB, &
 & 0.12461E+02_JPRB,0.14953E+02_JPRB,0.17445E+02_JPRB,0.19913E+02_JPRB /)  
KA(:, 1, 8,16) = (/ &
 & 0.19629E+02_JPRB,0.17181E+02_JPRB,0.14733E+02_JPRB,0.12285E+02_JPRB,0.13022E+02_JPRB, &
 & 0.16277E+02_JPRB,0.19532E+02_JPRB,0.22787E+02_JPRB,0.26029E+02_JPRB /)  
KA(:, 2, 8,16) = (/ &
 & 0.19728E+02_JPRB,0.17267E+02_JPRB,0.14807E+02_JPRB,0.12346E+02_JPRB,0.12711E+02_JPRB, &
 & 0.15888E+02_JPRB,0.19066E+02_JPRB,0.22243E+02_JPRB,0.25406E+02_JPRB /)  
KA(:, 3, 8,16) = (/ &
 & 0.19768E+02_JPRB,0.17302E+02_JPRB,0.14837E+02_JPRB,0.12371E+02_JPRB,0.12399E+02_JPRB, &
 & 0.15499E+02_JPRB,0.18599E+02_JPRB,0.21698E+02_JPRB,0.24782E+02_JPRB /)  
KA(:, 4, 8,16) = (/ &
 & 0.19773E+02_JPRB,0.17307E+02_JPRB,0.14840E+02_JPRB,0.12374E+02_JPRB,0.12111E+02_JPRB, &
 & 0.15139E+02_JPRB,0.18167E+02_JPRB,0.21194E+02_JPRB,0.24210E+02_JPRB /)  
KA(:, 5, 8,16) = (/ &
 & 0.19744E+02_JPRB,0.17281E+02_JPRB,0.14818E+02_JPRB,0.12356E+02_JPRB,0.11840E+02_JPRB, &
 & 0.14800E+02_JPRB,0.17760E+02_JPRB,0.20720E+02_JPRB,0.23667E+02_JPRB /)  
KA(:, 1, 9,16) = (/ &
 & 0.23312E+02_JPRB,0.20403E+02_JPRB,0.17494E+02_JPRB,0.14584E+02_JPRB,0.15488E+02_JPRB, &
 & 0.19360E+02_JPRB,0.23231E+02_JPRB,0.27103E+02_JPRB,0.30970E+02_JPRB /)  
KA(:, 2, 9,16) = (/ &
 & 0.23439E+02_JPRB,0.20514E+02_JPRB,0.17588E+02_JPRB,0.14663E+02_JPRB,0.15085E+02_JPRB, &
 & 0.18856E+02_JPRB,0.22627E+02_JPRB,0.26397E+02_JPRB,0.30166E+02_JPRB /)  
KA(:, 3, 9,16) = (/ &
 & 0.23492E+02_JPRB,0.20560E+02_JPRB,0.17628E+02_JPRB,0.14696E+02_JPRB,0.14687E+02_JPRB, &
 & 0.18356E+02_JPRB,0.22027E+02_JPRB,0.25697E+02_JPRB,0.29367E+02_JPRB /)  
KA(:, 4, 9,16) = (/ &
 & 0.23479E+02_JPRB,0.20549E+02_JPRB,0.17619E+02_JPRB,0.14689E+02_JPRB,0.14321E+02_JPRB, &
 & 0.17895E+02_JPRB,0.21474E+02_JPRB,0.25052E+02_JPRB,0.28629E+02_JPRB /)  
KA(:, 5, 9,16) = (/ &
 & 0.23411E+02_JPRB,0.20489E+02_JPRB,0.17567E+02_JPRB,0.14646E+02_JPRB,0.13982E+02_JPRB, &
 & 0.17451E+02_JPRB,0.20941E+02_JPRB,0.24431E+02_JPRB,0.27917E+02_JPRB /)  
KA(:, 1,10,16) = (/ &
 & 0.27592E+02_JPRB,0.24147E+02_JPRB,0.20702E+02_JPRB,0.17264E+02_JPRB,0.18240E+02_JPRB, &
 & 0.22793E+02_JPRB,0.27352E+02_JPRB,0.31910E+02_JPRB,0.36473E+02_JPRB /)  
KA(:, 2,10,16) = (/ &
 & 0.27703E+02_JPRB,0.24245E+02_JPRB,0.20786E+02_JPRB,0.17327E+02_JPRB,0.17749E+02_JPRB, &
 & 0.22147E+02_JPRB,0.26577E+02_JPRB,0.31006E+02_JPRB,0.35436E+02_JPRB /)  
KA(:, 3,10,16) = (/ &
 & 0.27743E+02_JPRB,0.24279E+02_JPRB,0.20816E+02_JPRB,0.17352E+02_JPRB,0.17266E+02_JPRB, &
 & 0.21525E+02_JPRB,0.25830E+02_JPRB,0.30134E+02_JPRB,0.34441E+02_JPRB /)  
KA(:, 4,10,16) = (/ &
 & 0.27709E+02_JPRB,0.24250E+02_JPRB,0.20790E+02_JPRB,0.17331E+02_JPRB,0.16811E+02_JPRB, &
 & 0.20946E+02_JPRB,0.25135E+02_JPRB,0.29324E+02_JPRB,0.33510E+02_JPRB /)  
KA(:, 5,10,16) = (/ &
 & 0.27598E+02_JPRB,0.24153E+02_JPRB,0.20707E+02_JPRB,0.17262E+02_JPRB,0.16378E+02_JPRB, &
 & 0.20388E+02_JPRB,0.24466E+02_JPRB,0.28543E+02_JPRB,0.32622E+02_JPRB /)  
KA(:, 1,11,16) = (/ &
 & 0.32570E+02_JPRB,0.28502E+02_JPRB,0.24434E+02_JPRB,0.20393E+02_JPRB,0.21083E+02_JPRB, &
 & 0.26245E+02_JPRB,0.31494E+02_JPRB,0.36742E+02_JPRB,0.41994E+02_JPRB /)  
KA(:, 2,11,16) = (/ &
 & 0.32601E+02_JPRB,0.28529E+02_JPRB,0.24458E+02_JPRB,0.20386E+02_JPRB,0.20492E+02_JPRB, &
 & 0.25469E+02_JPRB,0.30563E+02_JPRB,0.35657E+02_JPRB,0.40747E+02_JPRB /)  
KA(:, 3,11,16) = (/ &
 & 0.32535E+02_JPRB,0.28472E+02_JPRB,0.24408E+02_JPRB,0.20345E+02_JPRB,0.19916E+02_JPRB, &
 & 0.24733E+02_JPRB,0.29679E+02_JPRB,0.34625E+02_JPRB,0.39568E+02_JPRB /)  
KA(:, 4,11,16) = (/ &
 & 0.32390E+02_JPRB,0.28345E+02_JPRB,0.24301E+02_JPRB,0.20256E+02_JPRB,0.19358E+02_JPRB, &
 & 0.24023E+02_JPRB,0.28827E+02_JPRB,0.33631E+02_JPRB,0.38435E+02_JPRB /)  
KA(:, 5,11,16) = (/ &
 & 0.32175E+02_JPRB,0.28157E+02_JPRB,0.24140E+02_JPRB,0.20122E+02_JPRB,0.18819E+02_JPRB, &
 & 0.23330E+02_JPRB,0.27996E+02_JPRB,0.32661E+02_JPRB,0.37328E+02_JPRB /)  
KA(:, 1,12,16) = (/ &
 & 0.38135E+02_JPRB,0.33371E+02_JPRB,0.28607E+02_JPRB,0.23891E+02_JPRB,0.24203E+02_JPRB, &
 & 0.29981E+02_JPRB,0.35977E+02_JPRB,0.41973E+02_JPRB,0.47971E+02_JPRB /)  
KA(:, 2,12,16) = (/ &
 & 0.38033E+02_JPRB,0.33282E+02_JPRB,0.28531E+02_JPRB,0.23779E+02_JPRB,0.23491E+02_JPRB, &
 & 0.29038E+02_JPRB,0.34845E+02_JPRB,0.40652E+02_JPRB,0.46464E+02_JPRB /)  
KA(:, 3,12,16) = (/ &
 & 0.37806E+02_JPRB,0.33084E+02_JPRB,0.28361E+02_JPRB,0.23639E+02_JPRB,0.22788E+02_JPRB, &
 & 0.28150E+02_JPRB,0.33780E+02_JPRB,0.39409E+02_JPRB,0.45036E+02_JPRB /)  
KA(:, 4,12,16) = (/ &
 & 0.37497E+02_JPRB,0.32813E+02_JPRB,0.28129E+02_JPRB,0.23446E+02_JPRB,0.22100E+02_JPRB, &
 & 0.27270E+02_JPRB,0.32724E+02_JPRB,0.38179E+02_JPRB,0.43632E+02_JPRB /)  
KA(:, 5,12,16) = (/ &
 & 0.37099E+02_JPRB,0.32465E+02_JPRB,0.27831E+02_JPRB,0.23198E+02_JPRB,0.21440E+02_JPRB, &
 & 0.26398E+02_JPRB,0.31678E+02_JPRB,0.36957E+02_JPRB,0.42237E+02_JPRB /)  
KA(:, 1,13,16) = (/ &
 & 0.44217E+02_JPRB,0.38692E+02_JPRB,0.33167E+02_JPRB,0.27730E+02_JPRB,0.27605E+02_JPRB, &
 & 0.33969E+02_JPRB,0.40763E+02_JPRB,0.47556E+02_JPRB,0.54352E+02_JPRB /)  
KA(:, 2,13,16) = (/ &
 & 0.43915E+02_JPRB,0.38428E+02_JPRB,0.32941E+02_JPRB,0.27455E+02_JPRB,0.26738E+02_JPRB, &
 & 0.32787E+02_JPRB,0.39345E+02_JPRB,0.45901E+02_JPRB,0.52455E+02_JPRB /)  
KA(:, 3,13,16) = (/ &
 & 0.43489E+02_JPRB,0.38055E+02_JPRB,0.32622E+02_JPRB,0.27188E+02_JPRB,0.25861E+02_JPRB, &
 & 0.31686E+02_JPRB,0.38022E+02_JPRB,0.44359E+02_JPRB,0.50700E+02_JPRB /)  
KA(:, 4,13,16) = (/ &
 & 0.42951E+02_JPRB,0.37585E+02_JPRB,0.32219E+02_JPRB,0.26853E+02_JPRB,0.25006E+02_JPRB, &
 & 0.30590E+02_JPRB,0.36708E+02_JPRB,0.42826E+02_JPRB,0.48946E+02_JPRB /)  
KA(:, 5,13,16) = (/ &
 & 0.42298E+02_JPRB,0.37013E+02_JPRB,0.31729E+02_JPRB,0.26445E+02_JPRB,0.24180E+02_JPRB, &
 & 0.29511E+02_JPRB,0.35413E+02_JPRB,0.41314E+02_JPRB,0.47218E+02_JPRB /)  
  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART11',1,ZHOOK_HANDLE)
END SUBROUTINE PART11


SUBROUTINE PART12

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART12',0,ZHOOK_HANDLE)


!     -----------------------------------------------------------------
!     The array KB contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KB(:, 1,13, 1) = (/ &
 & 0.40633E-08_JPRB,0.64718E-06_JPRB,0.79567E-06_JPRB,0.81264E-06_JPRB,0.25080E-07_JPRB /)  
KB(:, 2,13, 1) = (/ &
 & 0.37596E-08_JPRB,0.70429E-06_JPRB,0.90855E-06_JPRB,0.96432E-06_JPRB,0.28292E-07_JPRB /)  
KB(:, 3,13, 1) = (/ &
 & 0.34982E-08_JPRB,0.76370E-06_JPRB,0.10316E-05_JPRB,0.11472E-05_JPRB,0.31265E-07_JPRB /)  
KB(:, 4,13, 1) = (/ &
 & 0.32707E-08_JPRB,0.82834E-06_JPRB,0.11577E-05_JPRB,0.13387E-05_JPRB,0.34928E-07_JPRB /)  
KB(:, 5,13, 1) = (/ &
 & 0.30710E-08_JPRB,0.90252E-06_JPRB,0.12962E-05_JPRB,0.15206E-05_JPRB,0.38859E-07_JPRB /)  
KB(:, 1,14, 1) = (/ &
 & 0.33026E-08_JPRB,0.53592E-06_JPRB,0.66171E-06_JPRB,0.67633E-06_JPRB,0.20767E-07_JPRB /)  
KB(:, 2,14, 1) = (/ &
 & 0.30574E-08_JPRB,0.57959E-06_JPRB,0.75386E-06_JPRB,0.80395E-06_JPRB,0.23334E-07_JPRB /)  
KB(:, 3,14, 1) = (/ &
 & 0.28461E-08_JPRB,0.62897E-06_JPRB,0.85486E-06_JPRB,0.95745E-06_JPRB,0.25841E-07_JPRB /)  
KB(:, 4,14, 1) = (/ &
 & 0.26621E-08_JPRB,0.68352E-06_JPRB,0.96132E-06_JPRB,0.11148E-05_JPRB,0.28862E-07_JPRB /)  
KB(:, 5,14, 1) = (/ &
 & 0.25005E-08_JPRB,0.74517E-06_JPRB,0.10739E-05_JPRB,0.12632E-05_JPRB,0.32093E-07_JPRB /)  
KB(:, 1,15, 1) = (/ &
 & 0.26821E-08_JPRB,0.44081E-06_JPRB,0.55093E-06_JPRB,0.56465E-06_JPRB,0.17186E-07_JPRB /)  
KB(:, 2,15, 1) = (/ &
 & 0.24845E-08_JPRB,0.47773E-06_JPRB,0.62636E-06_JPRB,0.67180E-06_JPRB,0.19234E-07_JPRB /)  
KB(:, 3,15, 1) = (/ &
 & 0.23140E-08_JPRB,0.51811E-06_JPRB,0.70791E-06_JPRB,0.79658E-06_JPRB,0.21348E-07_JPRB /)  
KB(:, 4,15, 1) = (/ &
 & 0.21654E-08_JPRB,0.56416E-06_JPRB,0.79893E-06_JPRB,0.92873E-06_JPRB,0.23832E-07_JPRB /)  
KB(:, 5,15, 1) = (/ &
 & 0.20347E-08_JPRB,0.61535E-06_JPRB,0.88985E-06_JPRB,0.10499E-05_JPRB,0.26485E-07_JPRB /)  
KB(:, 1,16, 1) = (/ &
 & 0.21775E-08_JPRB,0.36254E-06_JPRB,0.45870E-06_JPRB,0.47125E-06_JPRB,0.14211E-07_JPRB /)  
KB(:, 2,16, 1) = (/ &
 & 0.20183E-08_JPRB,0.39376E-06_JPRB,0.52053E-06_JPRB,0.56163E-06_JPRB,0.15869E-07_JPRB /)  
KB(:, 3,16, 1) = (/ &
 & 0.18808E-08_JPRB,0.42687E-06_JPRB,0.58699E-06_JPRB,0.66386E-06_JPRB,0.17627E-07_JPRB /)  
KB(:, 4,16, 1) = (/ &
 & 0.17608E-08_JPRB,0.46559E-06_JPRB,0.66388E-06_JPRB,0.77063E-06_JPRB,0.19664E-07_JPRB /)  
KB(:, 5,16, 1) = (/ &
 & 0.16552E-08_JPRB,0.50747E-06_JPRB,0.73699E-06_JPRB,0.87249E-06_JPRB,0.21844E-07_JPRB /)  
KB(:, 1,17, 1) = (/ &
 & 0.17682E-08_JPRB,0.29836E-06_JPRB,0.38104E-06_JPRB,0.39314E-06_JPRB,0.11735E-07_JPRB /)  
KB(:, 2,17, 1) = (/ &
 & 0.16399E-08_JPRB,0.32493E-06_JPRB,0.43215E-06_JPRB,0.46897E-06_JPRB,0.13077E-07_JPRB /)  
KB(:, 3,17, 1) = (/ &
 & 0.15290E-08_JPRB,0.35203E-06_JPRB,0.48665E-06_JPRB,0.55328E-06_JPRB,0.14535E-07_JPRB /)  
KB(:, 4,17, 1) = (/ &
 & 0.14321E-08_JPRB,0.38383E-06_JPRB,0.55033E-06_JPRB,0.63844E-06_JPRB,0.16208E-07_JPRB /)  
KB(:, 5,17, 1) = (/ &
 & 0.13468E-08_JPRB,0.41822E-06_JPRB,0.60950E-06_JPRB,0.72376E-06_JPRB,0.17995E-07_JPRB /)  
KB(:, 1,18, 1) = (/ &
 & 0.14362E-08_JPRB,0.24560E-06_JPRB,0.31667E-06_JPRB,0.32797E-06_JPRB,0.96831E-08_JPRB /)  
KB(:, 2,18, 1) = (/ &
 & 0.13327E-08_JPRB,0.26784E-06_JPRB,0.35872E-06_JPRB,0.39134E-06_JPRB,0.10773E-07_JPRB /)  
KB(:, 3,18, 1) = (/ &
 & 0.12432E-08_JPRB,0.29008E-06_JPRB,0.40334E-06_JPRB,0.46026E-06_JPRB,0.11980E-07_JPRB /)  
KB(:, 4,18, 1) = (/ &
 & 0.11650E-08_JPRB,0.31637E-06_JPRB,0.45583E-06_JPRB,0.52880E-06_JPRB,0.13350E-07_JPRB /)  
KB(:, 5,18, 1) = (/ &
 & 0.10960E-08_JPRB,0.34503E-06_JPRB,0.50363E-06_JPRB,0.59967E-06_JPRB,0.14815E-07_JPRB /)  
KB(:, 1,19, 1) = (/ &
 & 0.11667E-08_JPRB,0.20231E-06_JPRB,0.26313E-06_JPRB,0.27359E-06_JPRB,0.79934E-08_JPRB /)  
KB(:, 2,19, 1) = (/ &
 & 0.10833E-08_JPRB,0.22085E-06_JPRB,0.29760E-06_JPRB,0.32620E-06_JPRB,0.88807E-08_JPRB /)  
KB(:, 3,19, 1) = (/ &
 & 0.10110E-08_JPRB,0.23912E-06_JPRB,0.33423E-06_JPRB,0.38271E-06_JPRB,0.98771E-08_JPRB /)  
KB(:, 4,19, 1) = (/ &
 & 0.94778E-09_JPRB,0.26073E-06_JPRB,0.37685E-06_JPRB,0.43791E-06_JPRB,0.11002E-07_JPRB /)  
KB(:, 5,19, 1) = (/ &
 & 0.89198E-09_JPRB,0.28425E-06_JPRB,0.41589E-06_JPRB,0.49682E-06_JPRB,0.12204E-07_JPRB /)  
KB(:, 1,20, 1) = (/ &
 & 0.94668E-09_JPRB,0.16735E-06_JPRB,0.21822E-06_JPRB,0.22914E-06_JPRB,0.66237E-08_JPRB /)  
KB(:, 2,20, 1) = (/ &
 & 0.87956E-09_JPRB,0.18255E-06_JPRB,0.24770E-06_JPRB,0.27290E-06_JPRB,0.73470E-08_JPRB /)  
KB(:, 3,20, 1) = (/ &
 & 0.82132E-09_JPRB,0.19776E-06_JPRB,0.27786E-06_JPRB,0.31913E-06_JPRB,0.81732E-08_JPRB /)  
KB(:, 4,20, 1) = (/ &
 & 0.77032E-09_JPRB,0.21557E-06_JPRB,0.31197E-06_JPRB,0.36380E-06_JPRB,0.91019E-08_JPRB /)  
KB(:, 5,20, 1) = (/ &
 & 0.72528E-09_JPRB,0.23458E-06_JPRB,0.34449E-06_JPRB,0.41257E-06_JPRB,0.10084E-07_JPRB /)  
KB(:, 1,21, 1) = (/ &
 & 0.76809E-09_JPRB,0.13858E-06_JPRB,0.18138E-06_JPRB,0.19188E-06_JPRB,0.54929E-08_JPRB /)  
KB(:, 2,21, 1) = (/ &
 & 0.71408E-09_JPRB,0.15088E-06_JPRB,0.20614E-06_JPRB,0.22835E-06_JPRB,0.60825E-08_JPRB /)  
KB(:, 3,21, 1) = (/ &
 & 0.66717E-09_JPRB,0.16366E-06_JPRB,0.23111E-06_JPRB,0.26622E-06_JPRB,0.67680E-08_JPRB /)  
KB(:, 4,21, 1) = (/ &
 & 0.62605E-09_JPRB,0.17816E-06_JPRB,0.25834E-06_JPRB,0.30242E-06_JPRB,0.75344E-08_JPRB /)  
KB(:, 5,21, 1) = (/ &
 & 0.58970E-09_JPRB,0.19374E-06_JPRB,0.28542E-06_JPRB,0.34222E-06_JPRB,0.83394E-08_JPRB /)  
KB(:, 1,22, 1) = (/ &
 & 0.62013E-09_JPRB,0.11547E-06_JPRB,0.15212E-06_JPRB,0.16227E-06_JPRB,0.45926E-08_JPRB /)  
KB(:, 2,22, 1) = (/ &
 & 0.57709E-09_JPRB,0.12552E-06_JPRB,0.17211E-06_JPRB,0.19265E-06_JPRB,0.50728E-08_JPRB /)  
KB(:, 3,22, 1) = (/ &
 & 0.53964E-09_JPRB,0.13619E-06_JPRB,0.19363E-06_JPRB,0.22402E-06_JPRB,0.56454E-08_JPRB /)  
KB(:, 4,22, 1) = (/ &
 & 0.50675E-09_JPRB,0.14805E-06_JPRB,0.21557E-06_JPRB,0.25320E-06_JPRB,0.62805E-08_JPRB /)  
KB(:, 5,22, 1) = (/ &
 & 0.47764E-09_JPRB,0.16097E-06_JPRB,0.23799E-06_JPRB,0.28574E-06_JPRB,0.69414E-08_JPRB /)  
KB(:, 1,23, 1) = (/ &
 & 0.50055E-09_JPRB,0.96165E-07_JPRB,0.12776E-06_JPRB,0.13752E-06_JPRB,0.37933E-08_JPRB /)  
KB(:, 2,23, 1) = (/ &
 & 0.46627E-09_JPRB,0.10421E-06_JPRB,0.14387E-06_JPRB,0.16226E-06_JPRB,0.42154E-08_JPRB /)  
KB(:, 3,23, 1) = (/ &
 & 0.43638E-09_JPRB,0.11320E-06_JPRB,0.16240E-06_JPRB,0.18806E-06_JPRB,0.46761E-08_JPRB /)  
KB(:, 4,23, 1) = (/ &
 & 0.41009E-09_JPRB,0.12312E-06_JPRB,0.18002E-06_JPRB,0.21214E-06_JPRB,0.51724E-08_JPRB /)  
KB(:, 5,23, 1) = (/ &
 & 0.38679E-09_JPRB,0.13380E-06_JPRB,0.19835E-06_JPRB,0.23836E-06_JPRB,0.56863E-08_JPRB /)  
KB(:, 1,24, 1) = (/ &
 & 0.40384E-09_JPRB,0.80174E-07_JPRB,0.10742E-06_JPRB,0.11665E-06_JPRB,0.31435E-08_JPRB /)  
KB(:, 2,24, 1) = (/ &
 & 0.37656E-09_JPRB,0.86611E-07_JPRB,0.12062E-06_JPRB,0.13694E-06_JPRB,0.34746E-08_JPRB /)  
KB(:, 3,24, 1) = (/ &
 & 0.35273E-09_JPRB,0.94203E-07_JPRB,0.13610E-06_JPRB,0.15729E-06_JPRB,0.38586E-08_JPRB /)  
KB(:, 4,24, 1) = (/ &
 & 0.33174E-09_JPRB,0.10246E-06_JPRB,0.15035E-06_JPRB,0.17775E-06_JPRB,0.42707E-08_JPRB /)  
KB(:, 5,24, 1) = (/ &
 & 0.31310E-09_JPRB,0.11122E-06_JPRB,0.16543E-06_JPRB,0.19917E-06_JPRB,0.47020E-08_JPRB /)  
KB(:, 1,25, 1) = (/ &
 & 0.32562E-09_JPRB,0.66785E-07_JPRB,0.90447E-07_JPRB,0.99059E-07_JPRB,0.26134E-08_JPRB /)  
KB(:, 2,25, 1) = (/ &
 & 0.30393E-09_JPRB,0.72133E-07_JPRB,0.10139E-06_JPRB,0.11571E-06_JPRB,0.28872E-08_JPRB /)  
KB(:, 3,25, 1) = (/ &
 & 0.28495E-09_JPRB,0.78448E-07_JPRB,0.11385E-06_JPRB,0.13178E-06_JPRB,0.32061E-08_JPRB /)  
KB(:, 4,25, 1) = (/ &
 & 0.26821E-09_JPRB,0.85339E-07_JPRB,0.12563E-06_JPRB,0.14914E-06_JPRB,0.35489E-08_JPRB /)  
KB(:, 5,25, 1) = (/ &
 & 0.25332E-09_JPRB,0.92445E-07_JPRB,0.13814E-06_JPRB,0.16674E-06_JPRB,0.39060E-08_JPRB /)  
KB(:, 1,26, 1) = (/ &
 & 0.26224E-09_JPRB,0.55680E-07_JPRB,0.76369E-07_JPRB,0.84400E-07_JPRB,0.21759E-08_JPRB /)  
KB(:, 2,26, 1) = (/ &
 & 0.24504E-09_JPRB,0.60204E-07_JPRB,0.85423E-07_JPRB,0.97885E-07_JPRB,0.24118E-08_JPRB /)  
KB(:, 3,26, 1) = (/ &
 & 0.22996E-09_JPRB,0.65477E-07_JPRB,0.95321E-07_JPRB,0.11093E-06_JPRB,0.26774E-08_JPRB /)  
KB(:, 4,26, 1) = (/ &
 & 0.21663E-09_JPRB,0.71188E-07_JPRB,0.10529E-06_JPRB,0.12544E-06_JPRB,0.29615E-08_JPRB /)  
KB(:, 5,26, 1) = (/ &
 & 0.20475E-09_JPRB,0.76940E-07_JPRB,0.11556E-06_JPRB,0.13977E-06_JPRB,0.32569E-08_JPRB /)  
KB(:, 1,27, 1) = (/ &
 & 0.21120E-09_JPRB,0.46382E-07_JPRB,0.63894E-07_JPRB,0.71379E-07_JPRB,0.18178E-08_JPRB /)  
KB(:, 2,27, 1) = (/ &
 & 0.19756E-09_JPRB,0.50278E-07_JPRB,0.72033E-07_JPRB,0.82909E-07_JPRB,0.20181E-08_JPRB /)  
KB(:, 3,27, 1) = (/ &
 & 0.18557E-09_JPRB,0.54670E-07_JPRB,0.79953E-07_JPRB,0.93505E-07_JPRB,0.22396E-08_JPRB /)  
KB(:, 4,27, 1) = (/ &
 & 0.17496E-09_JPRB,0.59408E-07_JPRB,0.88179E-07_JPRB,0.10553E-06_JPRB,0.24737E-08_JPRB /)  
KB(:, 5,27, 1) = (/ &
 & 0.16549E-09_JPRB,0.64025E-07_JPRB,0.96696E-07_JPRB,0.11704E-06_JPRB,0.27092E-08_JPRB /)  
KB(:, 1,28, 1) = (/ &
 & 0.17010E-09_JPRB,0.38631E-07_JPRB,0.53773E-07_JPRB,0.60579E-07_JPRB,0.15220E-08_JPRB /)  
KB(:, 2,28, 1) = (/ &
 & 0.15928E-09_JPRB,0.42001E-07_JPRB,0.60660E-07_JPRB,0.69727E-07_JPRB,0.16901E-08_JPRB /)  
KB(:, 3,28, 1) = (/ &
 & 0.14976E-09_JPRB,0.45661E-07_JPRB,0.67065E-07_JPRB,0.78845E-07_JPRB,0.18696E-08_JPRB /)  
KB(:, 4,28, 1) = (/ &
 & 0.14131E-09_JPRB,0.49571E-07_JPRB,0.73809E-07_JPRB,0.88481E-07_JPRB,0.20611E-08_JPRB /)  
KB(:, 5,28, 1) = (/ &
 & 0.13376E-09_JPRB,0.53304E-07_JPRB,0.80910E-07_JPRB,0.98017E-07_JPRB,0.22565E-08_JPRB /)  
KB(:, 1,29, 1) = (/ &
 & 0.13696E-09_JPRB,0.32270E-07_JPRB,0.45392E-07_JPRB,0.51438E-07_JPRB,0.12721E-08_JPRB /)  
KB(:, 2,29, 1) = (/ &
 & 0.12839E-09_JPRB,0.35079E-07_JPRB,0.50946E-07_JPRB,0.58726E-07_JPRB,0.14118E-08_JPRB /)  
KB(:, 3,29, 1) = (/ &
 & 0.12082E-09_JPRB,0.38150E-07_JPRB,0.56258E-07_JPRB,0.66493E-07_JPRB,0.15628E-08_JPRB /)  
KB(:, 4,29, 1) = (/ &
 & 0.11410E-09_JPRB,0.41324E-07_JPRB,0.61843E-07_JPRB,0.74387E-07_JPRB,0.17205E-08_JPRB /)  
KB(:, 5,29, 1) = (/ &
 & 0.10808E-09_JPRB,0.44387E-07_JPRB,0.67739E-07_JPRB,0.82216E-07_JPRB,0.18745E-08_JPRB /)  
KB(:, 1,30, 1) = (/ &
 & 0.11029E-09_JPRB,0.26970E-07_JPRB,0.38330E-07_JPRB,0.43698E-07_JPRB,0.10655E-08_JPRB /)  
KB(:, 2,30, 1) = (/ &
 & 0.10349E-09_JPRB,0.29319E-07_JPRB,0.42739E-07_JPRB,0.49552E-07_JPRB,0.11823E-08_JPRB /)  
KB(:, 3,30, 1) = (/ &
 & 0.97483E-10_JPRB,0.31869E-07_JPRB,0.47210E-07_JPRB,0.56057E-07_JPRB,0.13038E-08_JPRB /)  
KB(:, 4,30, 1) = (/ &
 & 0.92133E-10_JPRB,0.34436E-07_JPRB,0.51812E-07_JPRB,0.62485E-07_JPRB,0.14285E-08_JPRB /)  
KB(:, 5,30, 1) = (/ &
 & 0.87340E-10_JPRB,0.36953E-07_JPRB,0.56709E-07_JPRB,0.68921E-07_JPRB,0.15563E-08_JPRB /)  
KB(:, 1,31, 1) = (/ &
 & 0.88806E-10_JPRB,0.22555E-07_JPRB,0.32386E-07_JPRB,0.37129E-07_JPRB,0.89029E-09_JPRB /)  
KB(:, 2,31, 1) = (/ &
 & 0.83417E-10_JPRB,0.24519E-07_JPRB,0.35921E-07_JPRB,0.41870E-07_JPRB,0.98548E-09_JPRB /)  
KB(:, 3,31, 1) = (/ &
 & 0.78644E-10_JPRB,0.26638E-07_JPRB,0.39609E-07_JPRB,0.47273E-07_JPRB,0.10854E-08_JPRB /)  
KB(:, 4,31, 1) = (/ &
 & 0.74388E-10_JPRB,0.28694E-07_JPRB,0.43423E-07_JPRB,0.52435E-07_JPRB,0.11880E-08_JPRB /)  
KB(:, 5,31, 1) = (/ &
 & 0.70568E-10_JPRB,0.30776E-07_JPRB,0.47411E-07_JPRB,0.57750E-07_JPRB,0.12931E-08_JPRB /)  
KB(:, 1,32, 1) = (/ &
 & 0.71507E-10_JPRB,0.18870E-07_JPRB,0.27332E-07_JPRB,0.31309E-07_JPRB,0.74436E-09_JPRB /)  
KB(:, 2,32, 1) = (/ &
 & 0.67235E-10_JPRB,0.20512E-07_JPRB,0.30189E-07_JPRB,0.35407E-07_JPRB,0.82294E-09_JPRB /)  
KB(:, 3,32, 1) = (/ &
 & 0.63444E-10_JPRB,0.22259E-07_JPRB,0.33218E-07_JPRB,0.39730E-07_JPRB,0.90483E-09_JPRB /)  
KB(:, 4,32, 1) = (/ &
 & 0.60058E-10_JPRB,0.23923E-07_JPRB,0.36405E-07_JPRB,0.43976E-07_JPRB,0.98908E-09_JPRB /)  
KB(:, 5,32, 1) = (/ &
 & 0.57015E-10_JPRB,0.25634E-07_JPRB,0.39548E-07_JPRB,0.48346E-07_JPRB,0.10750E-08_JPRB /)  
KB(:, 1,33, 1) = (/ &
 & 0.57586E-10_JPRB,0.15779E-07_JPRB,0.22950E-07_JPRB,0.26415E-07_JPRB,0.62256E-09_JPRB /)  
KB(:, 2,33, 1) = (/ &
 & 0.54199E-10_JPRB,0.17153E-07_JPRB,0.25354E-07_JPRB,0.29904E-07_JPRB,0.68734E-09_JPRB /)  
KB(:, 3,33, 1) = (/ &
 & 0.51188E-10_JPRB,0.18569E-07_JPRB,0.27869E-07_JPRB,0.33404E-07_JPRB,0.75467E-09_JPRB /)  
KB(:, 4,33, 1) = (/ &
 & 0.48493E-10_JPRB,0.19935E-07_JPRB,0.30437E-07_JPRB,0.36856E-07_JPRB,0.82369E-09_JPRB /)  
KB(:, 5,33, 1) = (/ &
 & 0.46069E-10_JPRB,0.21345E-07_JPRB,0.32988E-07_JPRB,0.40478E-07_JPRB,0.89402E-09_JPRB /)  
KB(:, 1,34, 1) = (/ &
 & 0.46487E-10_JPRB,0.13161E-07_JPRB,0.19216E-07_JPRB,0.22212E-07_JPRB,0.51910E-09_JPRB /)  
KB(:, 2,34, 1) = (/ &
 & 0.43789E-10_JPRB,0.14301E-07_JPRB,0.21182E-07_JPRB,0.25090E-07_JPRB,0.57247E-09_JPRB /)  
KB(:, 3,34, 1) = (/ &
 & 0.41386E-10_JPRB,0.15447E-07_JPRB,0.23208E-07_JPRB,0.27938E-07_JPRB,0.62767E-09_JPRB /)  
KB(:, 4,34, 1) = (/ &
 & 0.39234E-10_JPRB,0.16571E-07_JPRB,0.25347E-07_JPRB,0.30795E-07_JPRB,0.68426E-09_JPRB /)  
KB(:, 5,34, 1) = (/ &
 & 0.37294E-10_JPRB,0.17725E-07_JPRB,0.27392E-07_JPRB,0.33781E-07_JPRB,0.74179E-09_JPRB /)  
KB(:, 1,35, 1) = (/ &
 & 0.37756E-10_JPRB,0.10890E-07_JPRB,0.15882E-07_JPRB,0.18441E-07_JPRB,0.42871E-09_JPRB /)  
KB(:, 2,35, 1) = (/ &
 & 0.35581E-10_JPRB,0.11830E-07_JPRB,0.17514E-07_JPRB,0.20810E-07_JPRB,0.47251E-09_JPRB /)  
KB(:, 3,35, 1) = (/ &
 & 0.33643E-10_JPRB,0.12757E-07_JPRB,0.19184E-07_JPRB,0.23148E-07_JPRB,0.51769E-09_JPRB /)  
KB(:, 4,35, 1) = (/ &
 & 0.31905E-10_JPRB,0.13682E-07_JPRB,0.20941E-07_JPRB,0.25477E-07_JPRB,0.56394E-09_JPRB /)  
KB(:, 5,35, 1) = (/ &
 & 0.30338E-10_JPRB,0.14628E-07_JPRB,0.22613E-07_JPRB,0.27948E-07_JPRB,0.61100E-09_JPRB /)  
KB(:, 1,36, 1) = (/ &
 & 0.30872E-10_JPRB,0.89290E-08_JPRB,0.13007E-07_JPRB,0.15108E-07_JPRB,0.35034E-09_JPRB /)  
KB(:, 2,36, 1) = (/ &
 & 0.29096E-10_JPRB,0.96995E-08_JPRB,0.14343E-07_JPRB,0.17051E-07_JPRB,0.38609E-09_JPRB /)  
KB(:, 3,36, 1) = (/ &
 & 0.27513E-10_JPRB,0.10456E-07_JPRB,0.15713E-07_JPRB,0.18968E-07_JPRB,0.42296E-09_JPRB /)  
KB(:, 4,36, 1) = (/ &
 & 0.26093E-10_JPRB,0.11213E-07_JPRB,0.17153E-07_JPRB,0.20875E-07_JPRB,0.46073E-09_JPRB /)  
KB(:, 5,36, 1) = (/ &
 & 0.24812E-10_JPRB,0.11987E-07_JPRB,0.18522E-07_JPRB,0.22899E-07_JPRB,0.49916E-09_JPRB /)  
KB(:, 1,37, 1) = (/ &
 & 0.25479E-10_JPRB,0.72338E-08_JPRB,0.10508E-07_JPRB,0.12165E-07_JPRB,0.28268E-09_JPRB /)  
KB(:, 2,37, 1) = (/ &
 & 0.24002E-10_JPRB,0.78593E-08_JPRB,0.11594E-07_JPRB,0.13747E-07_JPRB,0.31173E-09_JPRB /)  
KB(:, 3,37, 1) = (/ &
 & 0.22687E-10_JPRB,0.84845E-08_JPRB,0.12712E-07_JPRB,0.15315E-07_JPRB,0.34178E-09_JPRB /)  
KB(:, 4,37, 1) = (/ &
 & 0.21508E-10_JPRB,0.90997E-08_JPRB,0.13892E-07_JPRB,0.16886E-07_JPRB,0.37260E-09_JPRB /)  
KB(:, 5,37, 1) = (/ &
 & 0.20446E-10_JPRB,0.97322E-08_JPRB,0.15012E-07_JPRB,0.18526E-07_JPRB,0.40398E-09_JPRB /)  
KB(:, 1,38, 1) = (/ &
 & 0.21041E-10_JPRB,0.58565E-08_JPRB,0.84831E-08_JPRB,0.97892E-08_JPRB,0.22791E-09_JPRB /)  
KB(:, 2,38, 1) = (/ &
 & 0.19811E-10_JPRB,0.63636E-08_JPRB,0.93619E-08_JPRB,0.11072E-07_JPRB,0.25148E-09_JPRB /)  
KB(:, 3,38, 1) = (/ &
 & 0.18717E-10_JPRB,0.68784E-08_JPRB,0.10276E-07_JPRB,0.12360E-07_JPRB,0.27595E-09_JPRB /)  
KB(:, 4,38, 1) = (/ &
 & 0.17738E-10_JPRB,0.73792E-08_JPRB,0.11234E-07_JPRB,0.13638E-07_JPRB,0.30109E-09_JPRB /)  
KB(:, 5,38, 1) = (/ &
 & 0.16856E-10_JPRB,0.78971E-08_JPRB,0.12166E-07_JPRB,0.14977E-07_JPRB,0.32671E-09_JPRB /)  
KB(:, 1,39, 1) = (/ &
 & 0.17377E-10_JPRB,0.47418E-08_JPRB,0.68561E-08_JPRB,0.78795E-08_JPRB,0.18373E-09_JPRB /)  
KB(:, 2,39, 1) = (/ &
 & 0.16353E-10_JPRB,0.51532E-08_JPRB,0.75620E-08_JPRB,0.89128E-08_JPRB,0.20284E-09_JPRB /)  
KB(:, 3,39, 1) = (/ &
 & 0.15443E-10_JPRB,0.55752E-08_JPRB,0.83069E-08_JPRB,0.99666E-08_JPRB,0.22279E-09_JPRB /)  
KB(:, 4,39, 1) = (/ &
 & 0.14629E-10_JPRB,0.59857E-08_JPRB,0.90872E-08_JPRB,0.11011E-07_JPRB,0.24327E-09_JPRB /)  
KB(:, 5,39, 1) = (/ &
 & 0.13896E-10_JPRB,0.64086E-08_JPRB,0.98616E-08_JPRB,0.12104E-07_JPRB,0.26420E-09_JPRB /)  
KB(:, 1,40, 1) = (/ &
 & 0.14445E-10_JPRB,0.38091E-08_JPRB,0.54799E-08_JPRB,0.62754E-08_JPRB,0.14679E-09_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART12',1,ZHOOK_HANDLE)
END SUBROUTINE PART12


SUBROUTINE PART13

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART13',0,ZHOOK_HANDLE)


KB(:, 2,40, 1) = (/ &
 & 0.13581E-10_JPRB,0.41391E-08_JPRB,0.60530E-08_JPRB,0.70909E-08_JPRB,0.16220E-09_JPRB /)  
KB(:, 3,40, 1) = (/ &
 & 0.12815E-10_JPRB,0.44888E-08_JPRB,0.66555E-08_JPRB,0.79532E-08_JPRB,0.17842E-09_JPRB /)  
KB(:, 4,40, 1) = (/ &
 & 0.12131E-10_JPRB,0.48207E-08_JPRB,0.72855E-08_JPRB,0.88071E-08_JPRB,0.19509E-09_JPRB /)  
KB(:, 5,40, 1) = (/ &
 & 0.11516E-10_JPRB,0.51646E-08_JPRB,0.79268E-08_JPRB,0.96932E-08_JPRB,0.21214E-09_JPRB /)  
KB(:, 1,41, 1) = (/ &
 & 0.12021E-10_JPRB,0.30566E-08_JPRB,0.43606E-08_JPRB,0.49921E-08_JPRB,0.11713E-09_JPRB /)  
KB(:, 2,41, 1) = (/ &
 & 0.11291E-10_JPRB,0.33205E-08_JPRB,0.48340E-08_JPRB,0.56256E-08_JPRB,0.12954E-09_JPRB /)  
KB(:, 3,41, 1) = (/ &
 & 0.10645E-10_JPRB,0.36053E-08_JPRB,0.53261E-08_JPRB,0.63473E-08_JPRB,0.14269E-09_JPRB /)  
KB(:, 4,41, 1) = (/ &
 & 0.10069E-10_JPRB,0.38782E-08_JPRB,0.58347E-08_JPRB,0.70386E-08_JPRB,0.15624E-09_JPRB /)  
KB(:, 5,41, 1) = (/ &
 & 0.95520E-11_JPRB,0.41580E-08_JPRB,0.63647E-08_JPRB,0.77515E-08_JPRB,0.17013E-09_JPRB /)  
KB(:, 1,42, 1) = (/ &
 & 0.10007E-10_JPRB,0.24516E-08_JPRB,0.34653E-08_JPRB,0.39398E-08_JPRB,0.93475E-10_JPRB /)  
KB(:, 2,42, 1) = (/ &
 & 0.93902E-11_JPRB,0.26631E-08_JPRB,0.38588E-08_JPRB,0.44635E-08_JPRB,0.10342E-09_JPRB /)  
KB(:, 3,42, 1) = (/ &
 & 0.88449E-11_JPRB,0.28926E-08_JPRB,0.42600E-08_JPRB,0.50466E-08_JPRB,0.11406E-09_JPRB /)  
KB(:, 4,42, 1) = (/ &
 & 0.83594E-11_JPRB,0.31198E-08_JPRB,0.46719E-08_JPRB,0.56218E-08_JPRB,0.12507E-09_JPRB /)  
KB(:, 5,42, 1) = (/ &
 & 0.79244E-11_JPRB,0.33465E-08_JPRB,0.51065E-08_JPRB,0.61999E-08_JPRB,0.13640E-09_JPRB /)  
KB(:, 1,43, 1) = (/ &
 & 0.83647E-11_JPRB,0.19578E-08_JPRB,0.27341E-08_JPRB,0.30827E-08_JPRB,0.74277E-10_JPRB /)  
KB(:, 2,43, 1) = (/ &
 & 0.78389E-11_JPRB,0.21263E-08_JPRB,0.30690E-08_JPRB,0.35212E-08_JPRB,0.82118E-10_JPRB /)  
KB(:, 3,43, 1) = (/ &
 & 0.73752E-11_JPRB,0.23103E-08_JPRB,0.33865E-08_JPRB,0.39836E-08_JPRB,0.90672E-10_JPRB /)  
KB(:, 4,43, 1) = (/ &
 & 0.69633E-11_JPRB,0.24984E-08_JPRB,0.37198E-08_JPRB,0.44569E-08_JPRB,0.99628E-10_JPRB /)  
KB(:, 5,43, 1) = (/ &
 & 0.65950E-11_JPRB,0.26833E-08_JPRB,0.40709E-08_JPRB,0.49265E-08_JPRB,0.10883E-09_JPRB /)  
KB(:, 1,44, 1) = (/ &
 & 0.70070E-11_JPRB,0.15628E-08_JPRB,0.21521E-08_JPRB,0.24017E-08_JPRB,0.59116E-10_JPRB /)  
KB(:, 2,44, 1) = (/ &
 & 0.65570E-11_JPRB,0.16954E-08_JPRB,0.24254E-08_JPRB,0.27772E-08_JPRB,0.65027E-10_JPRB /)  
KB(:, 3,44, 1) = (/ &
 & 0.61612E-11_JPRB,0.18413E-08_JPRB,0.26845E-08_JPRB,0.31310E-08_JPRB,0.71892E-10_JPRB /)  
KB(:, 4,44, 1) = (/ &
 & 0.58106E-11_JPRB,0.19977E-08_JPRB,0.29542E-08_JPRB,0.35211E-08_JPRB,0.79144E-10_JPRB /)  
KB(:, 5,44, 1) = (/ &
 & 0.54976E-11_JPRB,0.21464E-08_JPRB,0.32360E-08_JPRB,0.39045E-08_JPRB,0.86629E-10_JPRB /)  
KB(:, 1,45, 1) = (/ &
 & 0.58728E-11_JPRB,0.12500E-08_JPRB,0.17079E-08_JPRB,0.18743E-08_JPRB,0.46646E-10_JPRB /)  
KB(:, 2,45, 1) = (/ &
 & 0.54873E-11_JPRB,0.13505E-08_JPRB,0.19105E-08_JPRB,0.21719E-08_JPRB,0.51499E-10_JPRB /)  
KB(:, 3,45, 1) = (/ &
 & 0.51492E-11_JPRB,0.14670E-08_JPRB,0.21250E-08_JPRB,0.24590E-08_JPRB,0.56982E-10_JPRB /)  
KB(:, 4,45, 1) = (/ &
 & 0.48504E-11_JPRB,0.15931E-08_JPRB,0.23464E-08_JPRB,0.27802E-08_JPRB,0.62839E-10_JPRB /)  
KB(:, 5,45, 1) = (/ &
 & 0.45844E-11_JPRB,0.17167E-08_JPRB,0.25731E-08_JPRB,0.30954E-08_JPRB,0.68908E-10_JPRB /)  
KB(:, 1,46, 1) = (/ &
 & 0.49328E-11_JPRB,0.99811E-09_JPRB,0.13397E-08_JPRB,0.14457E-08_JPRB,0.36694E-10_JPRB /)  
KB(:, 2,46, 1) = (/ &
 & 0.46012E-11_JPRB,0.10742E-08_JPRB,0.14986E-08_JPRB,0.16875E-08_JPRB,0.40742E-10_JPRB /)  
KB(:, 3,46, 1) = (/ &
 & 0.43113E-11_JPRB,0.11665E-08_JPRB,0.16813E-08_JPRB,0.19281E-08_JPRB,0.45049E-10_JPRB /)  
KB(:, 4,46, 1) = (/ &
 & 0.40558E-11_JPRB,0.12673E-08_JPRB,0.18567E-08_JPRB,0.21817E-08_JPRB,0.49751E-10_JPRB /)  
KB(:, 5,46, 1) = (/ &
 & 0.38288E-11_JPRB,0.13702E-08_JPRB,0.20399E-08_JPRB,0.24419E-08_JPRB,0.54679E-10_JPRB /)  
KB(:, 1,47, 1) = (/ &
 & 0.41592E-11_JPRB,0.79205E-09_JPRB,0.10438E-08_JPRB,0.11055E-08_JPRB,0.28709E-10_JPRB /)  
KB(:, 2,47, 1) = (/ &
 & 0.38717E-11_JPRB,0.85357E-09_JPRB,0.11710E-08_JPRB,0.13015E-08_JPRB,0.32198E-10_JPRB /)  
KB(:, 3,47, 1) = (/ &
 & 0.36215E-11_JPRB,0.92515E-09_JPRB,0.13196E-08_JPRB,0.15103E-08_JPRB,0.35448E-10_JPRB /)  
KB(:, 4,47, 1) = (/ &
 & 0.34016E-11_JPRB,0.10046E-08_JPRB,0.14619E-08_JPRB,0.17010E-08_JPRB,0.39203E-10_JPRB /)  
KB(:, 5,47, 1) = (/ &
 & 0.32069E-11_JPRB,0.10904E-08_JPRB,0.16100E-08_JPRB,0.19168E-08_JPRB,0.43187E-10_JPRB /)  
KB(:, 1,48, 1) = (/ &
 & 0.35100E-11_JPRB,0.62849E-09_JPRB,0.81319E-09_JPRB,0.84567E-09_JPRB,0.22456E-10_JPRB /)  
KB(:, 2,48, 1) = (/ &
 & 0.32605E-11_JPRB,0.68021E-09_JPRB,0.92169E-09_JPRB,0.10040E-08_JPRB,0.25229E-10_JPRB /)  
KB(:, 3,48, 1) = (/ &
 & 0.30441E-11_JPRB,0.73294E-09_JPRB,0.10314E-08_JPRB,0.11665E-08_JPRB,0.27903E-10_JPRB /)  
KB(:, 4,48, 1) = (/ &
 & 0.28547E-11_JPRB,0.79615E-09_JPRB,0.11495E-08_JPRB,0.13251E-08_JPRB,0.30879E-10_JPRB /)  
KB(:, 5,48, 1) = (/ &
 & 0.26874E-11_JPRB,0.86463E-09_JPRB,0.12703E-08_JPRB,0.14994E-08_JPRB,0.34082E-10_JPRB /)  
KB(:, 1,49, 1) = (/ &
 & 0.29649E-11_JPRB,0.49867E-09_JPRB,0.63572E-09_JPRB,0.64557E-09_JPRB,0.17554E-10_JPRB /)  
KB(:, 2,49, 1) = (/ &
 & 0.27480E-11_JPRB,0.54124E-09_JPRB,0.71871E-09_JPRB,0.76840E-09_JPRB,0.19749E-10_JPRB /)  
KB(:, 3,49, 1) = (/ &
 & 0.25606E-11_JPRB,0.58140E-09_JPRB,0.80413E-09_JPRB,0.90054E-09_JPRB,0.22012E-10_JPRB /)  
KB(:, 4,49, 1) = (/ &
 & 0.23972E-11_JPRB,0.63097E-09_JPRB,0.90637E-09_JPRB,0.10349E-08_JPRB,0.24308E-10_JPRB /)  
KB(:, 5,49, 1) = (/ &
 & 0.22534E-11_JPRB,0.68545E-09_JPRB,0.10006E-08_JPRB,0.11704E-08_JPRB,0.26872E-10_JPRB /)  
KB(:, 1,50, 1) = (/ &
 & 0.25019E-11_JPRB,0.39853E-09_JPRB,0.49374E-09_JPRB,0.49615E-09_JPRB,0.13762E-10_JPRB /)  
KB(:, 2,50, 1) = (/ &
 & 0.23136E-11_JPRB,0.42952E-09_JPRB,0.56141E-09_JPRB,0.58980E-09_JPRB,0.15500E-10_JPRB /)  
KB(:, 3,50, 1) = (/ &
 & 0.21517E-11_JPRB,0.46334E-09_JPRB,0.63284E-09_JPRB,0.69788E-09_JPRB,0.17390E-10_JPRB /)  
KB(:, 4,50, 1) = (/ &
 & 0.20110E-11_JPRB,0.50130E-09_JPRB,0.71124E-09_JPRB,0.80903E-09_JPRB,0.19184E-10_JPRB /)  
KB(:, 5,50, 1) = (/ &
 & 0.18875E-11_JPRB,0.54446E-09_JPRB,0.78908E-09_JPRB,0.91435E-09_JPRB,0.21230E-10_JPRB /)  
KB(:, 1,51, 1) = (/ &
 & 0.21111E-11_JPRB,0.31534E-09_JPRB,0.38552E-09_JPRB,0.38324E-09_JPRB,0.10851E-10_JPRB /)  
KB(:, 2,51, 1) = (/ &
 & 0.19478E-11_JPRB,0.34179E-09_JPRB,0.43986E-09_JPRB,0.45355E-09_JPRB,0.12176E-10_JPRB /)  
KB(:, 3,51, 1) = (/ &
 & 0.18079E-11_JPRB,0.37016E-09_JPRB,0.49835E-09_JPRB,0.53919E-09_JPRB,0.13683E-10_JPRB /)  
KB(:, 4,51, 1) = (/ &
 & 0.16868E-11_JPRB,0.39846E-09_JPRB,0.55746E-09_JPRB,0.62805E-09_JPRB,0.15164E-10_JPRB /)  
KB(:, 5,51, 1) = (/ &
 & 0.15809E-11_JPRB,0.43272E-09_JPRB,0.62310E-09_JPRB,0.71587E-09_JPRB,0.16785E-10_JPRB /)  
KB(:, 1,52, 1) = (/ &
 & 0.17830E-11_JPRB,0.24939E-09_JPRB,0.30033E-09_JPRB,0.29708E-09_JPRB,0.85480E-11_JPRB /)  
KB(:, 2,52, 1) = (/ &
 & 0.16410E-11_JPRB,0.27244E-09_JPRB,0.34467E-09_JPRB,0.34870E-09_JPRB,0.95642E-11_JPRB /)  
KB(:, 3,52, 1) = (/ &
 & 0.15200E-11_JPRB,0.29507E-09_JPRB,0.39020E-09_JPRB,0.41505E-09_JPRB,0.10764E-10_JPRB /)  
KB(:, 4,52, 1) = (/ &
 & 0.14156E-11_JPRB,0.31736E-09_JPRB,0.43693E-09_JPRB,0.48758E-09_JPRB,0.12016E-10_JPRB /)  
KB(:, 5,52, 1) = (/ &
 & 0.13246E-11_JPRB,0.34409E-09_JPRB,0.49243E-09_JPRB,0.56181E-09_JPRB,0.13267E-10_JPRB /)  
KB(:, 1,53, 1) = (/ &
 & 0.15074E-11_JPRB,0.19746E-09_JPRB,0.23442E-09_JPRB,0.23027E-09_JPRB,0.66942E-11_JPRB /)  
KB(:, 2,53, 1) = (/ &
 & 0.13838E-11_JPRB,0.21754E-09_JPRB,0.26812E-09_JPRB,0.26865E-09_JPRB,0.75095E-11_JPRB /)  
KB(:, 3,53, 1) = (/ &
 & 0.12789E-11_JPRB,0.23445E-09_JPRB,0.30510E-09_JPRB,0.31916E-09_JPRB,0.84626E-11_JPRB /)  
KB(:, 4,53, 1) = (/ &
 & 0.11888E-11_JPRB,0.25305E-09_JPRB,0.34496E-09_JPRB,0.37906E-09_JPRB,0.94963E-11_JPRB /)  
KB(:, 5,53, 1) = (/ &
 & 0.11106E-11_JPRB,0.27355E-09_JPRB,0.38680E-09_JPRB,0.43882E-09_JPRB,0.10486E-10_JPRB /)  
KB(:, 1,54, 1) = (/ &
 & 0.12722E-11_JPRB,0.15676E-09_JPRB,0.18436E-09_JPRB,0.18188E-09_JPRB,0.52601E-11_JPRB /)  
KB(:, 2,54, 1) = (/ &
 & 0.11649E-11_JPRB,0.17256E-09_JPRB,0.21030E-09_JPRB,0.20876E-09_JPRB,0.59465E-11_JPRB /)  
KB(:, 3,54, 1) = (/ &
 & 0.10743E-11_JPRB,0.18706E-09_JPRB,0.24022E-09_JPRB,0.24657E-09_JPRB,0.66750E-11_JPRB /)  
KB(:, 4,54, 1) = (/ &
 & 0.99683E-12_JPRB,0.20263E-09_JPRB,0.27206E-09_JPRB,0.29337E-09_JPRB,0.75016E-11_JPRB /)  
KB(:, 5,54, 1) = (/ &
 & 0.92975E-12_JPRB,0.21798E-09_JPRB,0.30420E-09_JPRB,0.34203E-09_JPRB,0.83182E-11_JPRB /)  
KB(:, 1,55, 1) = (/ &
 & 0.10733E-11_JPRB,0.12552E-09_JPRB,0.14668E-09_JPRB,0.14477E-09_JPRB,0.41440E-11_JPRB /)  
KB(:, 2,55, 1) = (/ &
 & 0.98027E-12_JPRB,0.13705E-09_JPRB,0.16480E-09_JPRB,0.16298E-09_JPRB,0.47137E-11_JPRB /)  
KB(:, 3,55, 1) = (/ &
 & 0.90209E-12_JPRB,0.14966E-09_JPRB,0.18911E-09_JPRB,0.19117E-09_JPRB,0.52730E-11_JPRB /)  
KB(:, 4,55, 1) = (/ &
 & 0.83546E-12_JPRB,0.16210E-09_JPRB,0.21410E-09_JPRB,0.22758E-09_JPRB,0.59349E-11_JPRB /)  
KB(:, 5,55, 1) = (/ &
 & 0.77800E-12_JPRB,0.17423E-09_JPRB,0.23972E-09_JPRB,0.26725E-09_JPRB,0.66163E-11_JPRB /)  
KB(:, 1,56, 1) = (/ &
 & 0.90624E-12_JPRB,0.99786E-10_JPRB,0.11674E-09_JPRB,0.11286E-09_JPRB,0.32776E-11_JPRB /)  
KB(:, 2,56, 1) = (/ &
 & 0.82547E-12_JPRB,0.10897E-09_JPRB,0.12938E-09_JPRB,0.12705E-09_JPRB,0.37161E-11_JPRB /)  
KB(:, 3,56, 1) = (/ &
 & 0.75791E-12_JPRB,0.12009E-09_JPRB,0.14804E-09_JPRB,0.14827E-09_JPRB,0.41646E-11_JPRB /)  
KB(:, 4,56, 1) = (/ &
 & 0.70058E-12_JPRB,0.12925E-09_JPRB,0.16837E-09_JPRB,0.17630E-09_JPRB,0.46957E-11_JPRB /)  
KB(:, 5,56, 1) = (/ &
 & 0.65131E-12_JPRB,0.13937E-09_JPRB,0.18999E-09_JPRB,0.20899E-09_JPRB,0.52742E-11_JPRB /)  
KB(:, 1,57, 1) = (/ &
 & 0.76595E-12_JPRB,0.78822E-10_JPRB,0.93863E-10_JPRB,0.87529E-10_JPRB,0.26033E-11_JPRB /)  
KB(:, 2,57, 1) = (/ &
 & 0.69568E-12_JPRB,0.86555E-10_JPRB,0.10190E-09_JPRB,0.10022E-09_JPRB,0.29288E-11_JPRB /)  
KB(:, 3,57, 1) = (/ &
 & 0.63721E-12_JPRB,0.95385E-10_JPRB,0.11640E-09_JPRB,0.11533E-09_JPRB,0.32994E-11_JPRB /)  
KB(:, 4,57, 1) = (/ &
 & 0.58782E-12_JPRB,0.10325E-09_JPRB,0.13264E-09_JPRB,0.13663E-09_JPRB,0.37186E-11_JPRB /)  
KB(:, 5,57, 1) = (/ &
 & 0.54552E-12_JPRB,0.11173E-09_JPRB,0.15042E-09_JPRB,0.16253E-09_JPRB,0.41819E-11_JPRB /)  
KB(:, 1,58, 1) = (/ &
 & 0.64693E-12_JPRB,0.62421E-10_JPRB,0.76174E-10_JPRB,0.68324E-10_JPRB,0.20833E-11_JPRB /)  
KB(:, 2,58, 1) = (/ &
 & 0.58588E-12_JPRB,0.69278E-10_JPRB,0.81197E-10_JPRB,0.79691E-10_JPRB,0.23130E-11_JPRB /)  
KB(:, 3,58, 1) = (/ &
 & 0.53535E-12_JPRB,0.75873E-10_JPRB,0.91414E-10_JPRB,0.90398E-10_JPRB,0.26350E-11_JPRB /)  
KB(:, 4,58, 1) = (/ &
 & 0.49285E-12_JPRB,0.82653E-10_JPRB,0.10493E-09_JPRB,0.10617E-09_JPRB,0.29473E-11_JPRB /)  
KB(:, 5,58, 1) = (/ &
 & 0.45660E-12_JPRB,0.89643E-10_JPRB,0.11861E-09_JPRB,0.12647E-09_JPRB,0.33231E-11_JPRB /)  
KB(:, 1,59, 1) = (/ &
 & 0.53645E-12_JPRB,0.50557E-10_JPRB,0.62240E-10_JPRB,0.54854E-10_JPRB,0.16930E-11_JPRB /)  
KB(:, 2,59, 1) = (/ &
 & 0.48523E-12_JPRB,0.56468E-10_JPRB,0.65604E-10_JPRB,0.64827E-10_JPRB,0.18702E-11_JPRB /)  
KB(:, 3,59, 1) = (/ &
 & 0.44294E-12_JPRB,0.61442E-10_JPRB,0.73667E-10_JPRB,0.72688E-10_JPRB,0.21292E-11_JPRB /)  
KB(:, 4,59, 1) = (/ &
 & 0.40744E-12_JPRB,0.67184E-10_JPRB,0.84490E-10_JPRB,0.85217E-10_JPRB,0.23832E-11_JPRB /)  
KB(:, 5,59, 1) = (/ &
 & 0.37720E-12_JPRB,0.72657E-10_JPRB,0.95692E-10_JPRB,0.10144E-09_JPRB,0.26852E-11_JPRB /)  
KB(:, 1,13, 2) = (/ &
 & 0.18323E-07_JPRB,0.86266E-05_JPRB,0.13728E-04_JPRB,0.15952E-04_JPRB,0.78927E-06_JPRB /)  
KB(:, 2,13, 2) = (/ &
 & 0.16961E-07_JPRB,0.96203E-05_JPRB,0.15275E-04_JPRB,0.17863E-04_JPRB,0.93659E-06_JPRB /)  
KB(:, 3,13, 2) = (/ &
 & 0.15787E-07_JPRB,0.10675E-04_JPRB,0.16924E-04_JPRB,0.19675E-04_JPRB,0.11050E-05_JPRB /)  
KB(:, 4,13, 2) = (/ &
 & 0.14764E-07_JPRB,0.11779E-04_JPRB,0.18474E-04_JPRB,0.21320E-04_JPRB,0.12868E-05_JPRB /)  
KB(:, 5,13, 2) = (/ &
 & 0.13865E-07_JPRB,0.12843E-04_JPRB,0.20029E-04_JPRB,0.23080E-04_JPRB,0.14565E-05_JPRB /)  
KB(:, 1,14, 2) = (/ &
 & 0.14893E-07_JPRB,0.71882E-05_JPRB,0.11443E-04_JPRB,0.13271E-04_JPRB,0.65835E-06_JPRB /)  
KB(:, 2,14, 2) = (/ &
 & 0.13793E-07_JPRB,0.80276E-05_JPRB,0.12732E-04_JPRB,0.14890E-04_JPRB,0.78132E-06_JPRB /)  
KB(:, 3,14, 2) = (/ &
 & 0.12844E-07_JPRB,0.89189E-05_JPRB,0.14101E-04_JPRB,0.16339E-04_JPRB,0.92233E-06_JPRB /)  
KB(:, 4,14, 2) = (/ &
 & 0.12017E-07_JPRB,0.98309E-05_JPRB,0.15384E-04_JPRB,0.17721E-04_JPRB,0.10676E-05_JPRB /)  
KB(:, 5,14, 2) = (/ &
 & 0.11289E-07_JPRB,0.10704E-04_JPRB,0.16679E-04_JPRB,0.19194E-04_JPRB,0.12091E-05_JPRB /)  
KB(:, 1,15, 2) = (/ &
 & 0.12096E-07_JPRB,0.59934E-05_JPRB,0.95449E-05_JPRB,0.11058E-04_JPRB,0.54969E-06_JPRB /)  
KB(:, 2,15, 2) = (/ &
 & 0.11209E-07_JPRB,0.66932E-05_JPRB,0.10623E-04_JPRB,0.12407E-04_JPRB,0.65197E-06_JPRB /)  
KB(:, 3,15, 2) = (/ &
 & 0.10443E-07_JPRB,0.74449E-05_JPRB,0.11746E-04_JPRB,0.13571E-04_JPRB,0.76940E-06_JPRB /)  
KB(:, 4,15, 2) = (/ &
 & 0.97747E-08_JPRB,0.81948E-05_JPRB,0.12814E-04_JPRB,0.14732E-04_JPRB,0.88496E-06_JPRB /)  
KB(:, 5,15, 2) = (/ &
 & 0.91864E-08_JPRB,0.89188E-05_JPRB,0.13883E-04_JPRB,0.15946E-04_JPRB,0.10023E-05_JPRB /)  
KB(:, 1,16, 2) = (/ &
 & 0.98205E-08_JPRB,0.50027E-05_JPRB,0.79644E-05_JPRB,0.92248E-05_JPRB,0.45876E-06_JPRB /)  
KB(:, 2,16, 2) = (/ &
 & 0.91061E-08_JPRB,0.55846E-05_JPRB,0.88593E-05_JPRB,0.10331E-04_JPRB,0.54334E-06_JPRB /)  
KB(:, 3,16, 2) = (/ &
 & 0.84882E-08_JPRB,0.62183E-05_JPRB,0.97757E-05_JPRB,0.11279E-04_JPRB,0.64050E-06_JPRB /)  
KB(:, 4,16, 2) = (/ &
 & 0.79486E-08_JPRB,0.68276E-05_JPRB,0.10664E-04_JPRB,0.12244E-04_JPRB,0.73344E-06_JPRB /)  
KB(:, 5,16, 2) = (/ &
 & 0.74732E-08_JPRB,0.74268E-05_JPRB,0.11545E-04_JPRB,0.13224E-04_JPRB,0.82955E-06_JPRB /)  
KB(:, 1,17, 2) = (/ &
 & 0.79753E-08_JPRB,0.41713E-05_JPRB,0.66153E-05_JPRB,0.76892E-05_JPRB,0.38247E-06_JPRB /)  
KB(:, 2,17, 2) = (/ &
 & 0.73994E-08_JPRB,0.46562E-05_JPRB,0.73753E-05_JPRB,0.85922E-05_JPRB,0.45188E-06_JPRB /)  
KB(:, 3,17, 2) = (/ &
 & 0.69008E-08_JPRB,0.51829E-05_JPRB,0.81280E-05_JPRB,0.93638E-05_JPRB,0.53211E-06_JPRB /)  
KB(:, 4,17, 2) = (/ &
 & 0.64650E-08_JPRB,0.56765E-05_JPRB,0.88560E-05_JPRB,0.10168E-04_JPRB,0.60647E-06_JPRB /)  
KB(:, 5,17, 2) = (/ &
 & 0.60807E-08_JPRB,0.61758E-05_JPRB,0.95894E-05_JPRB,0.10949E-04_JPRB,0.68549E-06_JPRB /)  
KB(:, 1,18, 2) = (/ &
 & 0.64779E-08_JPRB,0.34727E-05_JPRB,0.54875E-05_JPRB,0.64000E-05_JPRB,0.31851E-06_JPRB /)  
KB(:, 2,18, 2) = (/ &
 & 0.60135E-08_JPRB,0.38751E-05_JPRB,0.61308E-05_JPRB,0.71372E-05_JPRB,0.37552E-06_JPRB /)  
KB(:, 3,18, 2) = (/ &
 & 0.56111E-08_JPRB,0.43132E-05_JPRB,0.67478E-05_JPRB,0.77698E-05_JPRB,0.44141E-06_JPRB /)  
KB(:, 4,18, 2) = (/ &
 & 0.52590E-08_JPRB,0.47150E-05_JPRB,0.73444E-05_JPRB,0.84370E-05_JPRB,0.50075E-06_JPRB /)  
KB(:, 5,18, 2) = (/ &
 & 0.49483E-08_JPRB,0.51345E-05_JPRB,0.79495E-05_JPRB,0.90637E-05_JPRB,0.56601E-06_JPRB /)  
KB(:, 1,19, 2) = (/ &
 & 0.52627E-08_JPRB,0.28908E-05_JPRB,0.45586E-05_JPRB,0.53260E-05_JPRB,0.26516E-06_JPRB /)  
KB(:, 2,19, 2) = (/ &
 & 0.48882E-08_JPRB,0.32260E-05_JPRB,0.50940E-05_JPRB,0.59200E-05_JPRB,0.31190E-06_JPRB /)  
KB(:, 3,19, 2) = (/ &
 & 0.45632E-08_JPRB,0.35843E-05_JPRB,0.55992E-05_JPRB,0.64397E-05_JPRB,0.36608E-06_JPRB /)  
KB(:, 4,19, 2) = (/ &
 & 0.42786E-08_JPRB,0.39167E-05_JPRB,0.60923E-05_JPRB,0.69972E-05_JPRB,0.41361E-06_JPRB /)  
KB(:, 5,19, 2) = (/ &
 & 0.40273E-08_JPRB,0.42667E-05_JPRB,0.65904E-05_JPRB,0.75021E-05_JPRB,0.46741E-06_JPRB /)  
KB(:, 1,20, 2) = (/ &
 & 0.42704E-08_JPRB,0.24074E-05_JPRB,0.37990E-05_JPRB,0.44458E-05_JPRB,0.22103E-06_JPRB /)  
KB(:, 2,20, 2) = (/ &
 & 0.39690E-08_JPRB,0.26942E-05_JPRB,0.42393E-05_JPRB,0.49120E-05_JPRB,0.26014E-06_JPRB /)  
KB(:, 3,20, 2) = (/ &
 & 0.37071E-08_JPRB,0.29827E-05_JPRB,0.46574E-05_JPRB,0.53487E-05_JPRB,0.30416E-06_JPRB /)  
KB(:, 4,20, 2) = (/ &
 & 0.34776E-08_JPRB,0.32601E-05_JPRB,0.50635E-05_JPRB,0.58076E-05_JPRB,0.34304E-06_JPRB /)  
KB(:, 5,20, 2) = (/ &
 & 0.32747E-08_JPRB,0.35518E-05_JPRB,0.54700E-05_JPRB,0.62197E-05_JPRB,0.38752E-06_JPRB /)  
KB(:, 1,21, 2) = (/ &
 & 0.34649E-08_JPRB,0.20096E-05_JPRB,0.31689E-05_JPRB,0.37070E-05_JPRB,0.18424E-06_JPRB /)  
KB(:, 2,21, 2) = (/ &
 & 0.32224E-08_JPRB,0.22503E-05_JPRB,0.35271E-05_JPRB,0.40784E-05_JPRB,0.21705E-06_JPRB /)  
KB(:, 3,21, 2) = (/ &
 & 0.30114E-08_JPRB,0.24834E-05_JPRB,0.38737E-05_JPRB,0.44436E-05_JPRB,0.25229E-06_JPRB /)  
KB(:, 4,21, 2) = (/ &
 & 0.28263E-08_JPRB,0.27149E-05_JPRB,0.42083E-05_JPRB,0.48061E-05_JPRB,0.28464E-06_JPRB /)  
KB(:, 5,21, 2) = (/ &
 & 0.26626E-08_JPRB,0.29556E-05_JPRB,0.45394E-05_JPRB,0.51565E-05_JPRB,0.32148E-06_JPRB /)  
KB(:, 1,22, 2) = (/ &
 & 0.27976E-08_JPRB,0.16913E-05_JPRB,0.26632E-05_JPRB,0.31108E-05_JPRB,0.15537E-06_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART13',1,ZHOOK_HANDLE)
END SUBROUTINE PART13


SUBROUTINE PART14

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART14',0,ZHOOK_HANDLE)


KB(:, 2,22, 2) = (/ &
 & 0.26043E-08_JPRB,0.18908E-05_JPRB,0.29553E-05_JPRB,0.34067E-05_JPRB,0.18311E-06_JPRB /)  
KB(:, 3,22, 2) = (/ &
 & 0.24359E-08_JPRB,0.20811E-05_JPRB,0.32390E-05_JPRB,0.37110E-05_JPRB,0.21094E-06_JPRB /)  
KB(:, 4,22, 2) = (/ &
 & 0.22878E-08_JPRB,0.22746E-05_JPRB,0.35144E-05_JPRB,0.40009E-05_JPRB,0.23816E-06_JPRB /)  
KB(:, 5,22, 2) = (/ &
 & 0.21567E-08_JPRB,0.24714E-05_JPRB,0.37839E-05_JPRB,0.42910E-05_JPRB,0.26886E-06_JPRB /)  
KB(:, 1,23, 2) = (/ &
 & 0.22583E-08_JPRB,0.14234E-05_JPRB,0.22388E-05_JPRB,0.26088E-05_JPRB,0.13143E-06_JPRB /)  
KB(:, 2,23, 2) = (/ &
 & 0.21043E-08_JPRB,0.15864E-05_JPRB,0.24776E-05_JPRB,0.28493E-05_JPRB,0.15460E-06_JPRB /)  
KB(:, 3,23, 2) = (/ &
 & 0.19699E-08_JPRB,0.17436E-05_JPRB,0.27072E-05_JPRB,0.31009E-05_JPRB,0.17669E-06_JPRB /)  
KB(:, 4,23, 2) = (/ &
 & 0.18515E-08_JPRB,0.19057E-05_JPRB,0.29355E-05_JPRB,0.33308E-05_JPRB,0.19953E-06_JPRB /)  
KB(:, 5,23, 2) = (/ &
 & 0.17465E-08_JPRB,0.20653E-05_JPRB,0.31542E-05_JPRB,0.35663E-05_JPRB,0.22501E-06_JPRB /)  
KB(:, 1,24, 2) = (/ &
 & 0.18221E-08_JPRB,0.12001E-05_JPRB,0.18808E-05_JPRB,0.21868E-05_JPRB,0.11138E-06_JPRB /)  
KB(:, 2,24, 2) = (/ &
 & 0.16995E-08_JPRB,0.13315E-05_JPRB,0.20779E-05_JPRB,0.23825E-05_JPRB,0.13068E-06_JPRB /)  
KB(:, 3,24, 2) = (/ &
 & 0.15923E-08_JPRB,0.14625E-05_JPRB,0.22647E-05_JPRB,0.25884E-05_JPRB,0.14820E-06_JPRB /)  
KB(:, 4,24, 2) = (/ &
 & 0.14978E-08_JPRB,0.15972E-05_JPRB,0.24512E-05_JPRB,0.27771E-05_JPRB,0.16734E-06_JPRB /)  
KB(:, 5,24, 2) = (/ &
 & 0.14138E-08_JPRB,0.17254E-05_JPRB,0.26296E-05_JPRB,0.29649E-05_JPRB,0.18848E-06_JPRB /)  
KB(:, 1,25, 2) = (/ &
 & 0.14693E-08_JPRB,0.10111E-05_JPRB,0.15809E-05_JPRB,0.18286E-05_JPRB,0.94366E-07_JPRB /)  
KB(:, 2,25, 2) = (/ &
 & 0.13718E-08_JPRB,0.11199E-05_JPRB,0.17430E-05_JPRB,0.19952E-05_JPRB,0.11045E-06_JPRB /)  
KB(:, 3,25, 2) = (/ &
 & 0.12864E-08_JPRB,0.12273E-05_JPRB,0.18957E-05_JPRB,0.21572E-05_JPRB,0.12445E-06_JPRB /)  
KB(:, 4,25, 2) = (/ &
 & 0.12110E-08_JPRB,0.13373E-05_JPRB,0.20462E-05_JPRB,0.23162E-05_JPRB,0.14042E-06_JPRB /)  
KB(:, 5,25, 2) = (/ &
 & 0.11438E-08_JPRB,0.14410E-05_JPRB,0.21916E-05_JPRB,0.24648E-05_JPRB,0.15767E-06_JPRB /)  
KB(:, 1,26, 2) = (/ &
 & 0.11834E-08_JPRB,0.85331E-06_JPRB,0.13316E-05_JPRB,0.15329E-05_JPRB,0.80212E-07_JPRB /)  
KB(:, 2,26, 2) = (/ &
 & 0.11061E-08_JPRB,0.94192E-06_JPRB,0.14626E-05_JPRB,0.16729E-05_JPRB,0.92775E-07_JPRB /)  
KB(:, 3,26, 2) = (/ &
 & 0.10382E-08_JPRB,0.10317E-05_JPRB,0.15890E-05_JPRB,0.18006E-05_JPRB,0.10462E-06_JPRB /)  
KB(:, 4,26, 2) = (/ &
 & 0.97810E-09_JPRB,0.11205E-05_JPRB,0.17099E-05_JPRB,0.19314E-05_JPRB,0.11800E-06_JPRB /)  
KB(:, 5,26, 2) = (/ &
 & 0.92457E-09_JPRB,0.12034E-05_JPRB,0.18276E-05_JPRB,0.20504E-05_JPRB,0.13209E-06_JPRB /)  
KB(:, 1,27, 2) = (/ &
 & 0.95311E-09_JPRB,0.71890E-06_JPRB,0.11218E-05_JPRB,0.12867E-05_JPRB,0.68084E-07_JPRB /)  
KB(:, 2,27, 2) = (/ &
 & 0.89177E-09_JPRB,0.79258E-06_JPRB,0.12275E-05_JPRB,0.14019E-05_JPRB,0.77999E-07_JPRB /)  
KB(:, 3,27, 2) = (/ &
 & 0.83781E-09_JPRB,0.86605E-06_JPRB,0.13308E-05_JPRB,0.15040E-05_JPRB,0.88027E-07_JPRB /)  
KB(:, 4,27, 2) = (/ &
 & 0.78998E-09_JPRB,0.93815E-06_JPRB,0.14285E-05_JPRB,0.16091E-05_JPRB,0.99057E-07_JPRB /)  
KB(:, 5,27, 2) = (/ &
 & 0.74729E-09_JPRB,0.10046E-05_JPRB,0.15236E-05_JPRB,0.17059E-05_JPRB,0.11074E-06_JPRB /)  
KB(:, 1,28, 2) = (/ &
 & 0.76771E-09_JPRB,0.60623E-06_JPRB,0.94427E-06_JPRB,0.10796E-05_JPRB,0.57844E-07_JPRB /)  
KB(:, 2,28, 2) = (/ &
 & 0.71904E-09_JPRB,0.66653E-06_JPRB,0.10298E-05_JPRB,0.11699E-05_JPRB,0.65726E-07_JPRB /)  
KB(:, 3,28, 2) = (/ &
 & 0.67614E-09_JPRB,0.72689E-06_JPRB,0.11131E-05_JPRB,0.12568E-05_JPRB,0.74009E-07_JPRB /)  
KB(:, 4,28, 2) = (/ &
 & 0.63806E-09_JPRB,0.78482E-06_JPRB,0.11927E-05_JPRB,0.13406E-05_JPRB,0.83200E-07_JPRB /)  
KB(:, 5,28, 2) = (/ &
 & 0.60401E-09_JPRB,0.83806E-06_JPRB,0.12695E-05_JPRB,0.14186E-05_JPRB,0.92306E-07_JPRB /)  
KB(:, 1,29, 2) = (/ &
 & 0.61817E-09_JPRB,0.51053E-06_JPRB,0.79450E-06_JPRB,0.90687E-06_JPRB,0.49078E-07_JPRB /)  
KB(:, 2,29, 2) = (/ &
 & 0.57958E-09_JPRB,0.56071E-06_JPRB,0.86403E-06_JPRB,0.97690E-06_JPRB,0.55257E-07_JPRB /)  
KB(:, 3,29, 2) = (/ &
 & 0.54551E-09_JPRB,0.61009E-06_JPRB,0.93077E-06_JPRB,0.10495E-05_JPRB,0.62286E-07_JPRB /)  
KB(:, 4,29, 2) = (/ &
 & 0.51520E-09_JPRB,0.65631E-06_JPRB,0.99567E-06_JPRB,0.11159E-05_JPRB,0.69954E-07_JPRB /)  
KB(:, 5,29, 2) = (/ &
 & 0.48806E-09_JPRB,0.69830E-06_JPRB,0.10576E-05_JPRB,0.11790E-05_JPRB,0.77228E-07_JPRB /)  
KB(:, 1,30, 2) = (/ &
 & 0.49783E-09_JPRB,0.43014E-06_JPRB,0.66732E-06_JPRB,0.76058E-06_JPRB,0.41306E-07_JPRB /)  
KB(:, 2,30, 2) = (/ &
 & 0.46723E-09_JPRB,0.47148E-06_JPRB,0.72434E-06_JPRB,0.81682E-06_JPRB,0.46537E-07_JPRB /)  
KB(:, 3,30, 2) = (/ &
 & 0.44015E-09_JPRB,0.51146E-06_JPRB,0.77809E-06_JPRB,0.87537E-06_JPRB,0.52451E-07_JPRB /)  
KB(:, 4,30, 2) = (/ &
 & 0.41603E-09_JPRB,0.54877E-06_JPRB,0.83073E-06_JPRB,0.92884E-06_JPRB,0.58793E-07_JPRB /)  
KB(:, 5,30, 2) = (/ &
 & 0.39440E-09_JPRB,0.58159E-06_JPRB,0.88054E-06_JPRB,0.98030E-06_JPRB,0.64630E-07_JPRB /)  
KB(:, 1,31, 2) = (/ &
 & 0.40087E-09_JPRB,0.36256E-06_JPRB,0.56062E-06_JPRB,0.63549E-06_JPRB,0.34778E-07_JPRB /)  
KB(:, 2,31, 2) = (/ &
 & 0.37660E-09_JPRB,0.39620E-06_JPRB,0.60674E-06_JPRB,0.68313E-06_JPRB,0.39213E-07_JPRB /)  
KB(:, 3,31, 2) = (/ &
 & 0.35510E-09_JPRB,0.42855E-06_JPRB,0.65037E-06_JPRB,0.72999E-06_JPRB,0.44176E-07_JPRB /)  
KB(:, 4,31, 2) = (/ &
 & 0.33590E-09_JPRB,0.45852E-06_JPRB,0.69308E-06_JPRB,0.77338E-06_JPRB,0.49424E-07_JPRB /)  
KB(:, 5,31, 2) = (/ &
 & 0.31866E-09_JPRB,0.48459E-06_JPRB,0.73297E-06_JPRB,0.81484E-06_JPRB,0.54137E-07_JPRB /)  
KB(:, 1,32, 2) = (/ &
 & 0.32280E-09_JPRB,0.30547E-06_JPRB,0.47083E-06_JPRB,0.53147E-06_JPRB,0.29353E-07_JPRB /)  
KB(:, 2,32, 2) = (/ &
 & 0.30356E-09_JPRB,0.33271E-06_JPRB,0.50770E-06_JPRB,0.57112E-06_JPRB,0.33078E-07_JPRB /)  
KB(:, 3,32, 2) = (/ &
 & 0.28647E-09_JPRB,0.35876E-06_JPRB,0.54339E-06_JPRB,0.60852E-06_JPRB,0.37211E-07_JPRB /)  
KB(:, 4,32, 2) = (/ &
 & 0.27120E-09_JPRB,0.38214E-06_JPRB,0.57781E-06_JPRB,0.64354E-06_JPRB,0.41295E-07_JPRB /)  
KB(:, 5,32, 2) = (/ &
 & 0.25746E-09_JPRB,0.40374E-06_JPRB,0.60990E-06_JPRB,0.67711E-06_JPRB,0.45362E-07_JPRB /)  
KB(:, 1,33, 2) = (/ &
 & 0.25997E-09_JPRB,0.25723E-06_JPRB,0.39505E-06_JPRB,0.44467E-06_JPRB,0.24754E-07_JPRB /)  
KB(:, 2,33, 2) = (/ &
 & 0.24471E-09_JPRB,0.27926E-06_JPRB,0.42469E-06_JPRB,0.47702E-06_JPRB,0.27907E-07_JPRB /)  
KB(:, 3,33, 2) = (/ &
 & 0.23113E-09_JPRB,0.30024E-06_JPRB,0.45384E-06_JPRB,0.50672E-06_JPRB,0.31344E-07_JPRB /)  
KB(:, 4,33, 2) = (/ &
 & 0.21898E-09_JPRB,0.31862E-06_JPRB,0.48142E-06_JPRB,0.53515E-06_JPRB,0.34590E-07_JPRB /)  
KB(:, 5,33, 2) = (/ &
 & 0.20803E-09_JPRB,0.33624E-06_JPRB,0.50721E-06_JPRB,0.56242E-06_JPRB,0.37957E-07_JPRB /)  
KB(:, 1,34, 2) = (/ &
 & 0.20987E-09_JPRB,0.21561E-06_JPRB,0.33035E-06_JPRB,0.37093E-06_JPRB,0.20801E-07_JPRB /)  
KB(:, 2,34, 2) = (/ &
 & 0.19771E-09_JPRB,0.23356E-06_JPRB,0.35433E-06_JPRB,0.39723E-06_JPRB,0.23443E-07_JPRB /)  
KB(:, 3,34, 2) = (/ &
 & 0.18688E-09_JPRB,0.25042E-06_JPRB,0.37804E-06_JPRB,0.42127E-06_JPRB,0.26271E-07_JPRB /)  
KB(:, 4,34, 2) = (/ &
 & 0.17716E-09_JPRB,0.26514E-06_JPRB,0.40029E-06_JPRB,0.44433E-06_JPRB,0.28867E-07_JPRB /)  
KB(:, 5,34, 2) = (/ &
 & 0.16840E-09_JPRB,0.27949E-06_JPRB,0.42102E-06_JPRB,0.46612E-06_JPRB,0.31620E-07_JPRB /)  
KB(:, 1,35, 2) = (/ &
 & 0.17046E-09_JPRB,0.17909E-06_JPRB,0.27397E-06_JPRB,0.30730E-06_JPRB,0.17283E-07_JPRB /)  
KB(:, 2,35, 2) = (/ &
 & 0.16066E-09_JPRB,0.19378E-06_JPRB,0.29367E-06_JPRB,0.32869E-06_JPRB,0.19456E-07_JPRB /)  
KB(:, 3,35, 2) = (/ &
 & 0.15191E-09_JPRB,0.20716E-06_JPRB,0.31287E-06_JPRB,0.34820E-06_JPRB,0.21759E-07_JPRB /)  
KB(:, 4,35, 2) = (/ &
 & 0.14407E-09_JPRB,0.21938E-06_JPRB,0.33090E-06_JPRB,0.36703E-06_JPRB,0.23854E-07_JPRB /)  
KB(:, 5,35, 2) = (/ &
 & 0.13699E-09_JPRB,0.23115E-06_JPRB,0.34779E-06_JPRB,0.38459E-06_JPRB,0.26128E-07_JPRB /)  
KB(:, 1,36, 2) = (/ &
 & 0.13938E-09_JPRB,0.14742E-06_JPRB,0.22535E-06_JPRB,0.25261E-06_JPRB,0.14145E-07_JPRB /)  
KB(:, 2,36, 2) = (/ &
 & 0.13137E-09_JPRB,0.15949E-06_JPRB,0.24155E-06_JPRB,0.27011E-06_JPRB,0.15917E-07_JPRB /)  
KB(:, 3,36, 2) = (/ &
 & 0.12423E-09_JPRB,0.17037E-06_JPRB,0.25721E-06_JPRB,0.28606E-06_JPRB,0.17809E-07_JPRB /)  
KB(:, 4,36, 2) = (/ &
 & 0.11782E-09_JPRB,0.18044E-06_JPRB,0.27200E-06_JPRB,0.30149E-06_JPRB,0.19530E-07_JPRB /)  
KB(:, 5,36, 2) = (/ &
 & 0.11204E-09_JPRB,0.19011E-06_JPRB,0.28582E-06_JPRB,0.31581E-06_JPRB,0.21391E-07_JPRB /)  
KB(:, 1,37, 2) = (/ &
 & 0.11503E-09_JPRB,0.11991E-06_JPRB,0.18339E-06_JPRB,0.20540E-06_JPRB,0.11398E-07_JPRB /)  
KB(:, 2,37, 2) = (/ &
 & 0.10837E-09_JPRB,0.12985E-06_JPRB,0.19670E-06_JPRB,0.21991E-06_JPRB,0.12829E-07_JPRB /)  
KB(:, 3,37, 2) = (/ &
 & 0.10244E-09_JPRB,0.13895E-06_JPRB,0.20964E-06_JPRB,0.23310E-06_JPRB,0.14370E-07_JPRB /)  
KB(:, 4,37, 2) = (/ &
 & 0.97122E-10_JPRB,0.14725E-06_JPRB,0.22183E-06_JPRB,0.24582E-06_JPRB,0.15790E-07_JPRB /)  
KB(:, 5,37, 2) = (/ &
 & 0.92325E-10_JPRB,0.15526E-06_JPRB,0.23327E-06_JPRB,0.25767E-06_JPRB,0.17308E-07_JPRB /)  
KB(:, 1,38, 2) = (/ &
 & 0.94990E-10_JPRB,0.97434E-07_JPRB,0.14912E-06_JPRB,0.16699E-06_JPRB,0.91745E-08_JPRB /)  
KB(:, 2,38, 2) = (/ &
 & 0.89449E-10_JPRB,0.10563E-06_JPRB,0.16007E-06_JPRB,0.17890E-06_JPRB,0.10330E-07_JPRB /)  
KB(:, 3,38, 2) = (/ &
 & 0.84516E-10_JPRB,0.11322E-06_JPRB,0.17071E-06_JPRB,0.18982E-06_JPRB,0.11585E-07_JPRB /)  
KB(:, 4,38, 2) = (/ &
 & 0.80096E-10_JPRB,0.12009E-06_JPRB,0.18084E-06_JPRB,0.20030E-06_JPRB,0.12759E-07_JPRB /)  
KB(:, 5,38, 2) = (/ &
 & 0.76113E-10_JPRB,0.12672E-06_JPRB,0.19028E-06_JPRB,0.21012E-06_JPRB,0.13992E-07_JPRB /)  
KB(:, 1,39, 2) = (/ &
 & 0.78444E-10_JPRB,0.79147E-07_JPRB,0.12122E-06_JPRB,0.13573E-06_JPRB,0.73846E-08_JPRB /)  
KB(:, 2,39, 2) = (/ &
 & 0.73832E-10_JPRB,0.85901E-07_JPRB,0.13022E-06_JPRB,0.14552E-06_JPRB,0.83180E-08_JPRB /)  
KB(:, 3,39, 2) = (/ &
 & 0.69729E-10_JPRB,0.92230E-07_JPRB,0.13899E-06_JPRB,0.15459E-06_JPRB,0.93374E-08_JPRB /)  
KB(:, 4,39, 2) = (/ &
 & 0.66056E-10_JPRB,0.97919E-07_JPRB,0.14737E-06_JPRB,0.16325E-06_JPRB,0.10307E-07_JPRB /)  
KB(:, 5,39, 2) = (/ &
 & 0.62749E-10_JPRB,0.10341E-06_JPRB,0.15518E-06_JPRB,0.17133E-06_JPRB,0.11312E-07_JPRB /)  
KB(:, 1,40, 2) = (/ &
 & 0.65207E-10_JPRB,0.63715E-07_JPRB,0.97755E-07_JPRB,0.10945E-06_JPRB,0.58831E-08_JPRB /)  
KB(:, 2,40, 2) = (/ &
 & 0.61319E-10_JPRB,0.69289E-07_JPRB,0.10524E-06_JPRB,0.11757E-06_JPRB,0.66237E-08_JPRB /)  
KB(:, 3,40, 2) = (/ &
 & 0.57866E-10_JPRB,0.74694E-07_JPRB,0.11245E-06_JPRB,0.12515E-06_JPRB,0.74455E-08_JPRB /)  
KB(:, 4,40, 2) = (/ &
 & 0.54779E-10_JPRB,0.79359E-07_JPRB,0.11941E-06_JPRB,0.13229E-06_JPRB,0.82595E-08_JPRB /)  
KB(:, 5,40, 2) = (/ &
 & 0.52003E-10_JPRB,0.83957E-07_JPRB,0.12593E-06_JPRB,0.13909E-06_JPRB,0.90698E-08_JPRB /)  
KB(:, 1,41, 2) = (/ &
 & 0.54263E-10_JPRB,0.51172E-07_JPRB,0.78714E-07_JPRB,0.88183E-07_JPRB,0.46740E-08_JPRB /)  
KB(:, 2,41, 2) = (/ &
 & 0.50978E-10_JPRB,0.55838E-07_JPRB,0.84939E-07_JPRB,0.94828E-07_JPRB,0.52655E-08_JPRB /)  
KB(:, 3,41, 2) = (/ &
 & 0.48066E-10_JPRB,0.60328E-07_JPRB,0.90859E-07_JPRB,0.10118E-06_JPRB,0.59273E-08_JPRB /)  
KB(:, 4,41, 2) = (/ &
 & 0.45467E-10_JPRB,0.64260E-07_JPRB,0.96667E-07_JPRB,0.10710E-06_JPRB,0.66279E-08_JPRB /)  
KB(:, 5,41, 2) = (/ &
 & 0.43134E-10_JPRB,0.68089E-07_JPRB,0.10208E-06_JPRB,0.11279E-06_JPRB,0.72560E-08_JPRB /)  
KB(:, 1,42, 2) = (/ &
 & 0.45170E-10_JPRB,0.41073E-07_JPRB,0.63333E-07_JPRB,0.71067E-07_JPRB,0.37185E-08_JPRB /)  
KB(:, 2,42, 2) = (/ &
 & 0.42393E-10_JPRB,0.44964E-07_JPRB,0.68507E-07_JPRB,0.76455E-07_JPRB,0.41864E-08_JPRB /)  
KB(:, 3,42, 2) = (/ &
 & 0.39936E-10_JPRB,0.48667E-07_JPRB,0.73382E-07_JPRB,0.81772E-07_JPRB,0.47157E-08_JPRB /)  
KB(:, 4,42, 2) = (/ &
 & 0.37747E-10_JPRB,0.51996E-07_JPRB,0.78220E-07_JPRB,0.86689E-07_JPRB,0.52834E-08_JPRB /)  
KB(:, 5,42, 2) = (/ &
 & 0.35784E-10_JPRB,0.55178E-07_JPRB,0.82739E-07_JPRB,0.91434E-07_JPRB,0.58040E-08_JPRB /)  
KB(:, 1,43, 2) = (/ &
 & 0.37754E-10_JPRB,0.32770E-07_JPRB,0.50662E-07_JPRB,0.56979E-07_JPRB,0.29405E-08_JPRB /)  
KB(:, 2,43, 2) = (/ &
 & 0.35387E-10_JPRB,0.35997E-07_JPRB,0.54993E-07_JPRB,0.61357E-07_JPRB,0.33066E-08_JPRB /)  
KB(:, 3,43, 2) = (/ &
 & 0.33299E-10_JPRB,0.39073E-07_JPRB,0.59036E-07_JPRB,0.65793E-07_JPRB,0.37265E-08_JPRB /)  
KB(:, 4,43, 2) = (/ &
 & 0.31442E-10_JPRB,0.41903E-07_JPRB,0.63014E-07_JPRB,0.69920E-07_JPRB,0.41848E-08_JPRB /)  
KB(:, 5,43, 2) = (/ &
 & 0.29781E-10_JPRB,0.44546E-07_JPRB,0.66822E-07_JPRB,0.73849E-07_JPRB,0.46204E-08_JPRB /)  
KB(:, 1,44, 2) = (/ &
 & 0.31623E-10_JPRB,0.26054E-07_JPRB,0.40405E-07_JPRB,0.45692E-07_JPRB,0.22918E-08_JPRB /)  
KB(:, 2,44, 2) = (/ &
 & 0.29599E-10_JPRB,0.28713E-07_JPRB,0.44010E-07_JPRB,0.49122E-07_JPRB,0.26053E-08_JPRB /)  
KB(:, 3,44, 2) = (/ &
 & 0.27817E-10_JPRB,0.31296E-07_JPRB,0.47391E-07_JPRB,0.52815E-07_JPRB,0.29353E-08_JPRB /)  
KB(:, 4,44, 2) = (/ &
 & 0.26236E-10_JPRB,0.33677E-07_JPRB,0.50655E-07_JPRB,0.56264E-07_JPRB,0.33023E-08_JPRB /)  
KB(:, 5,44, 2) = (/ &
 & 0.24825E-10_JPRB,0.35896E-07_JPRB,0.53863E-07_JPRB,0.59538E-07_JPRB,0.36730E-08_JPRB /)  
KB(:, 1,45, 2) = (/ &
 & 0.26502E-10_JPRB,0.20705E-07_JPRB,0.32152E-07_JPRB,0.36448E-07_JPRB,0.17841E-08_JPRB /)  
KB(:, 2,45, 2) = (/ &
 & 0.24768E-10_JPRB,0.22868E-07_JPRB,0.35185E-07_JPRB,0.39329E-07_JPRB,0.20515E-08_JPRB /)  
KB(:, 3,45, 2) = (/ &
 & 0.23247E-10_JPRB,0.25027E-07_JPRB,0.37999E-07_JPRB,0.42338E-07_JPRB,0.23118E-08_JPRB /)  
KB(:, 4,45, 2) = (/ &
 & 0.21900E-10_JPRB,0.27063E-07_JPRB,0.40694E-07_JPRB,0.45258E-07_JPRB,0.26048E-08_JPRB /)  
KB(:, 5,45, 2) = (/ &
 & 0.20701E-10_JPRB,0.28901E-07_JPRB,0.43361E-07_JPRB,0.47969E-07_JPRB,0.29174E-08_JPRB /)  
KB(:, 1,46, 2) = (/ &
 & 0.22258E-10_JPRB,0.16422E-07_JPRB,0.25480E-07_JPRB,0.28991E-07_JPRB,0.13830E-08_JPRB /)  
KB(:, 2,46, 2) = (/ &
 & 0.20767E-10_JPRB,0.18158E-07_JPRB,0.28033E-07_JPRB,0.31442E-07_JPRB,0.16144E-08_JPRB /)  
KB(:, 3,46, 2) = (/ &
 & 0.19462E-10_JPRB,0.19953E-07_JPRB,0.30402E-07_JPRB,0.33850E-07_JPRB,0.18162E-08_JPRB /)  
KB(:, 4,46, 2) = (/ &
 & 0.18312E-10_JPRB,0.21658E-07_JPRB,0.32639E-07_JPRB,0.36308E-07_JPRB,0.20475E-08_JPRB /)  
KB(:, 5,46, 2) = (/ &
 & 0.17289E-10_JPRB,0.23211E-07_JPRB,0.34839E-07_JPRB,0.38583E-07_JPRB,0.22994E-08_JPRB /)  
KB(:, 1,47, 2) = (/ &
 & 0.18764E-10_JPRB,0.12951E-07_JPRB,0.20072E-07_JPRB,0.22982E-07_JPRB,0.10645E-08_JPRB /)  
KB(:, 2,47, 2) = (/ &
 & 0.17473E-10_JPRB,0.14335E-07_JPRB,0.22214E-07_JPRB,0.25085E-07_JPRB,0.12479E-08_JPRB /)  
KB(:, 3,47, 2) = (/ &
 & 0.16347E-10_JPRB,0.15813E-07_JPRB,0.24205E-07_JPRB,0.26971E-07_JPRB,0.14207E-08_JPRB /)  
KB(:, 4,47, 2) = (/ &
 & 0.15357E-10_JPRB,0.17255E-07_JPRB,0.26075E-07_JPRB,0.29015E-07_JPRB,0.16008E-08_JPRB /)  
KB(:, 5,47, 2) = (/ &
 & 0.14480E-10_JPRB,0.18558E-07_JPRB,0.27885E-07_JPRB,0.30922E-07_JPRB,0.18018E-08_JPRB /)  
KB(:, 1,48, 2) = (/ &
 & 0.15833E-10_JPRB,0.10186E-07_JPRB,0.15782E-07_JPRB,0.18174E-07_JPRB,0.81718E-09_JPRB /)  
KB(:, 2,48, 2) = (/ &
 & 0.14713E-10_JPRB,0.11312E-07_JPRB,0.17555E-07_JPRB,0.19891E-07_JPRB,0.96098E-09_JPRB /)  
KB(:, 3,48, 2) = (/ &
 & 0.13740E-10_JPRB,0.12509E-07_JPRB,0.19248E-07_JPRB,0.21482E-07_JPRB,0.11112E-08_JPRB /)  
KB(:, 4,48, 2) = (/ &
 & 0.12887E-10_JPRB,0.13719E-07_JPRB,0.20811E-07_JPRB,0.23140E-07_JPRB,0.12515E-08_JPRB /)  
KB(:, 5,48, 2) = (/ &
 & 0.12134E-10_JPRB,0.14840E-07_JPRB,0.22313E-07_JPRB,0.24769E-07_JPRB,0.14105E-08_JPRB /)  
KB(:, 1,49, 2) = (/ &
 & 0.13372E-10_JPRB,0.80050E-08_JPRB,0.12403E-07_JPRB,0.14283E-07_JPRB,0.63117E-09_JPRB /)  
KB(:, 2,49, 2) = (/ &
 & 0.12398E-10_JPRB,0.89393E-08_JPRB,0.13840E-07_JPRB,0.15751E-07_JPRB,0.73907E-09_JPRB /)  
KB(:, 3,49, 2) = (/ &
 & 0.11556E-10_JPRB,0.98821E-08_JPRB,0.15261E-07_JPRB,0.17104E-07_JPRB,0.86645E-09_JPRB /)  
KB(:, 4,49, 2) = (/ &
 & 0.10821E-10_JPRB,0.10884E-07_JPRB,0.16582E-07_JPRB,0.18441E-07_JPRB,0.97829E-09_JPRB /)  
KB(:, 5,49, 2) = (/ &
 & 0.10174E-10_JPRB,0.11841E-07_JPRB,0.17828E-07_JPRB,0.19804E-07_JPRB,0.11034E-08_JPRB /)  
KB(:, 1,50, 2) = (/ &
 & 0.11282E-10_JPRB,0.62726E-08_JPRB,0.97478E-08_JPRB,0.11226E-07_JPRB,0.48398E-09_JPRB /)  
KB(:, 2,50, 2) = (/ &
 & 0.10437E-10_JPRB,0.70546E-08_JPRB,0.10932E-07_JPRB,0.12518E-07_JPRB,0.57051E-09_JPRB /)  
KB(:, 3,50, 2) = (/ &
 & 0.97101E-11_JPRB,0.78193E-08_JPRB,0.12114E-07_JPRB,0.13671E-07_JPRB,0.66997E-09_JPRB /)  
KB(:, 4,50, 2) = (/ &
 & 0.90772E-11_JPRB,0.86379E-08_JPRB,0.13218E-07_JPRB,0.14712E-07_JPRB,0.76625E-09_JPRB /)  
KB(:, 5,50, 2) = (/ &
 & 0.85216E-11_JPRB,0.94405E-08_JPRB,0.14258E-07_JPRB,0.15844E-07_JPRB,0.86488E-09_JPRB /)  
KB(:, 1,51, 2) = (/ &
 & 0.95179E-11_JPRB,0.49251E-08_JPRB,0.76356E-08_JPRB,0.87761E-08_JPRB,0.37213E-09_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART14',1,ZHOOK_HANDLE)
END SUBROUTINE PART14


SUBROUTINE PART15

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART15',0,ZHOOK_HANDLE)


KB(:, 2,51, 2) = (/ &
 & 0.87856E-11_JPRB,0.55681E-08_JPRB,0.86220E-08_JPRB,0.99159E-08_JPRB,0.44074E-09_JPRB /)  
KB(:, 3,51, 2) = (/ &
 & 0.81576E-11_JPRB,0.61930E-08_JPRB,0.95989E-08_JPRB,0.10865E-07_JPRB,0.51843E-09_JPRB /)  
KB(:, 4,51, 2) = (/ &
 & 0.76131E-11_JPRB,0.68518E-08_JPRB,0.10539E-07_JPRB,0.11746E-07_JPRB,0.60210E-09_JPRB /)  
KB(:, 5,51, 2) = (/ &
 & 0.71366E-11_JPRB,0.75206E-08_JPRB,0.11403E-07_JPRB,0.12659E-07_JPRB,0.67841E-09_JPRB /)  
KB(:, 1,52, 2) = (/ &
 & 0.80368E-11_JPRB,0.38608E-08_JPRB,0.60010E-08_JPRB,0.68441E-08_JPRB,0.28848E-09_JPRB /)  
KB(:, 2,52, 2) = (/ &
 & 0.74007E-11_JPRB,0.43903E-08_JPRB,0.67974E-08_JPRB,0.78127E-08_JPRB,0.34245E-09_JPRB /)  
KB(:, 3,52, 2) = (/ &
 & 0.68577E-11_JPRB,0.49086E-08_JPRB,0.75959E-08_JPRB,0.86279E-08_JPRB,0.40106E-09_JPRB /)  
KB(:, 4,52, 2) = (/ &
 & 0.63886E-11_JPRB,0.54297E-08_JPRB,0.83801E-08_JPRB,0.93778E-08_JPRB,0.47058E-09_JPRB /)  
KB(:, 5,52, 2) = (/ &
 & 0.59795E-11_JPRB,0.59829E-08_JPRB,0.91103E-08_JPRB,0.10111E-07_JPRB,0.53218E-09_JPRB /)  
KB(:, 1,53, 2) = (/ &
 & 0.67932E-11_JPRB,0.30102E-08_JPRB,0.47269E-08_JPRB,0.53395E-08_JPRB,0.22432E-09_JPRB /)  
KB(:, 2,53, 2) = (/ &
 & 0.62397E-11_JPRB,0.34450E-08_JPRB,0.53458E-08_JPRB,0.61449E-08_JPRB,0.26282E-09_JPRB /)  
KB(:, 3,53, 2) = (/ &
 & 0.57693E-11_JPRB,0.38768E-08_JPRB,0.60006E-08_JPRB,0.68613E-08_JPRB,0.31020E-09_JPRB /)  
KB(:, 4,53, 2) = (/ &
 & 0.53647E-11_JPRB,0.43002E-08_JPRB,0.66533E-08_JPRB,0.74990E-08_JPRB,0.36446E-09_JPRB /)  
KB(:, 5,53, 2) = (/ &
 & 0.50129E-11_JPRB,0.47527E-08_JPRB,0.72638E-08_JPRB,0.80717E-08_JPRB,0.41759E-09_JPRB /)  
KB(:, 1,54, 2) = (/ &
 & 0.57320E-11_JPRB,0.23582E-08_JPRB,0.36837E-08_JPRB,0.41317E-08_JPRB,0.17477E-09_JPRB /)  
KB(:, 2,54, 2) = (/ &
 & 0.52518E-11_JPRB,0.27163E-08_JPRB,0.42048E-08_JPRB,0.48208E-08_JPRB,0.20321E-09_JPRB /)  
KB(:, 3,54, 2) = (/ &
 & 0.48457E-11_JPRB,0.30678E-08_JPRB,0.47472E-08_JPRB,0.54472E-08_JPRB,0.24081E-09_JPRB /)  
KB(:, 4,54, 2) = (/ &
 & 0.44978E-11_JPRB,0.34148E-08_JPRB,0.52851E-08_JPRB,0.59735E-08_JPRB,0.28345E-09_JPRB /)  
KB(:, 5,54, 2) = (/ &
 & 0.41963E-11_JPRB,0.37804E-08_JPRB,0.58001E-08_JPRB,0.64570E-08_JPRB,0.32923E-09_JPRB /)  
KB(:, 1,55, 2) = (/ &
 & 0.48347E-11_JPRB,0.18534E-08_JPRB,0.28539E-08_JPRB,0.31828E-08_JPRB,0.13492E-09_JPRB /)  
KB(:, 2,55, 2) = (/ &
 & 0.44186E-11_JPRB,0.21392E-08_JPRB,0.33190E-08_JPRB,0.37817E-08_JPRB,0.15848E-09_JPRB /)  
KB(:, 3,55, 2) = (/ &
 & 0.40683E-11_JPRB,0.24320E-08_JPRB,0.37592E-08_JPRB,0.43156E-08_JPRB,0.18835E-09_JPRB /)  
KB(:, 4,55, 2) = (/ &
 & 0.37693E-11_JPRB,0.27150E-08_JPRB,0.41999E-08_JPRB,0.47625E-08_JPRB,0.22076E-09_JPRB /)  
KB(:, 5,55, 2) = (/ &
 & 0.35111E-11_JPRB,0.30082E-08_JPRB,0.46345E-08_JPRB,0.51736E-08_JPRB,0.25916E-09_JPRB /)  
KB(:, 1,56, 2) = (/ &
 & 0.40813E-11_JPRB,0.14543E-08_JPRB,0.22038E-08_JPRB,0.24488E-08_JPRB,0.10328E-09_JPRB /)  
KB(:, 2,56, 2) = (/ &
 & 0.37201E-11_JPRB,0.16813E-08_JPRB,0.26371E-08_JPRB,0.29640E-08_JPRB,0.12446E-09_JPRB /)  
KB(:, 3,56, 2) = (/ &
 & 0.34175E-11_JPRB,0.19191E-08_JPRB,0.29747E-08_JPRB,0.34115E-08_JPRB,0.14604E-09_JPRB /)  
KB(:, 4,56, 2) = (/ &
 & 0.31604E-11_JPRB,0.21575E-08_JPRB,0.33348E-08_JPRB,0.38018E-08_JPRB,0.17202E-09_JPRB /)  
KB(:, 5,56, 2) = (/ &
 & 0.29391E-11_JPRB,0.23932E-08_JPRB,0.36930E-08_JPRB,0.41472E-08_JPRB,0.20235E-09_JPRB /)  
KB(:, 1,57, 2) = (/ &
 & 0.34486E-11_JPRB,0.11480E-08_JPRB,0.17032E-08_JPRB,0.18771E-08_JPRB,0.78787E-10_JPRB /)  
KB(:, 2,57, 2) = (/ &
 & 0.31345E-11_JPRB,0.13189E-08_JPRB,0.20615E-08_JPRB,0.23121E-08_JPRB,0.96832E-10_JPRB /)  
KB(:, 3,57, 2) = (/ &
 & 0.28728E-11_JPRB,0.15144E-08_JPRB,0.23440E-08_JPRB,0.26863E-08_JPRB,0.11317E-09_JPRB /)  
KB(:, 4,57, 2) = (/ &
 & 0.26513E-11_JPRB,0.17102E-08_JPRB,0.26436E-08_JPRB,0.30246E-08_JPRB,0.13393E-09_JPRB /)  
KB(:, 5,57, 2) = (/ &
 & 0.24615E-11_JPRB,0.19022E-08_JPRB,0.29394E-08_JPRB,0.33135E-08_JPRB,0.15772E-09_JPRB /)  
KB(:, 1,58, 2) = (/ &
 & 0.29119E-11_JPRB,0.89500E-09_JPRB,0.13020E-08_JPRB,0.14383E-08_JPRB,0.60253E-10_JPRB /)  
KB(:, 2,58, 2) = (/ &
 & 0.26392E-11_JPRB,0.10369E-08_JPRB,0.16036E-08_JPRB,0.17891E-08_JPRB,0.75765E-10_JPRB /)  
KB(:, 3,58, 2) = (/ &
 & 0.24132E-11_JPRB,0.11975E-08_JPRB,0.18523E-08_JPRB,0.21114E-08_JPRB,0.88260E-10_JPRB /)  
KB(:, 4,58, 2) = (/ &
 & 0.22227E-11_JPRB,0.13570E-08_JPRB,0.20959E-08_JPRB,0.24045E-08_JPRB,0.10478E-09_JPRB /)  
KB(:, 5,58, 2) = (/ &
 & 0.20601E-11_JPRB,0.15139E-08_JPRB,0.23406E-08_JPRB,0.26456E-08_JPRB,0.12331E-09_JPRB /)  
KB(:, 1,59, 2) = (/ &
 & 0.24143E-11_JPRB,0.71851E-09_JPRB,0.10362E-08_JPRB,0.11516E-08_JPRB,0.48086E-10_JPRB /)  
KB(:, 2,59, 2) = (/ &
 & 0.21857E-11_JPRB,0.83732E-09_JPRB,0.12892E-08_JPRB,0.14335E-08_JPRB,0.60630E-10_JPRB /)  
KB(:, 3,59, 2) = (/ &
 & 0.19965E-11_JPRB,0.96815E-09_JPRB,0.14990E-08_JPRB,0.17039E-08_JPRB,0.71208E-10_JPRB /)  
KB(:, 4,59, 2) = (/ &
 & 0.18374E-11_JPRB,0.10982E-08_JPRB,0.16973E-08_JPRB,0.19455E-08_JPRB,0.84514E-10_JPRB /)  
KB(:, 5,59, 2) = (/ &
 & 0.17017E-11_JPRB,0.12277E-08_JPRB,0.18981E-08_JPRB,0.21472E-08_JPRB,0.99289E-10_JPRB /)  
KB(:, 1,13, 3) = (/ &
 & 0.69497E-07_JPRB,0.55900E-04_JPRB,0.77634E-04_JPRB,0.83300E-04_JPRB,0.14419E-04_JPRB /)  
KB(:, 2,13, 3) = (/ &
 & 0.64923E-07_JPRB,0.61779E-04_JPRB,0.85238E-04_JPRB,0.90458E-04_JPRB,0.15996E-04_JPRB /)  
KB(:, 3,13, 3) = (/ &
 & 0.60920E-07_JPRB,0.67532E-04_JPRB,0.92811E-04_JPRB,0.97588E-04_JPRB,0.17622E-04_JPRB /)  
KB(:, 4,13, 3) = (/ &
 & 0.57379E-07_JPRB,0.72876E-04_JPRB,0.10040E-03_JPRB,0.10455E-03_JPRB,0.19144E-04_JPRB /)  
KB(:, 5,13, 3) = (/ &
 & 0.54220E-07_JPRB,0.77699E-04_JPRB,0.10784E-03_JPRB,0.11139E-03_JPRB,0.20671E-04_JPRB /)  
KB(:, 1,14, 3) = (/ &
 & 0.56538E-07_JPRB,0.46627E-04_JPRB,0.64678E-04_JPRB,0.69399E-04_JPRB,0.12086E-04_JPRB /)  
KB(:, 2,14, 3) = (/ &
 & 0.52839E-07_JPRB,0.51536E-04_JPRB,0.71080E-04_JPRB,0.75292E-04_JPRB,0.13414E-04_JPRB /)  
KB(:, 3,14, 3) = (/ &
 & 0.49600E-07_JPRB,0.56334E-04_JPRB,0.77384E-04_JPRB,0.81277E-04_JPRB,0.14732E-04_JPRB /)  
KB(:, 4,14, 3) = (/ &
 & 0.46731E-07_JPRB,0.60751E-04_JPRB,0.83753E-04_JPRB,0.87067E-04_JPRB,0.15973E-04_JPRB /)  
KB(:, 5,14, 3) = (/ &
 & 0.44171E-07_JPRB,0.64792E-04_JPRB,0.89963E-04_JPRB,0.92617E-04_JPRB,0.17214E-04_JPRB /)  
KB(:, 1,15, 3) = (/ &
 & 0.45963E-07_JPRB,0.38920E-04_JPRB,0.53921E-04_JPRB,0.57824E-04_JPRB,0.10089E-04_JPRB /)  
KB(:, 2,15, 3) = (/ &
 & 0.42976E-07_JPRB,0.42987E-04_JPRB,0.59286E-04_JPRB,0.62615E-04_JPRB,0.11238E-04_JPRB /)  
KB(:, 3,15, 3) = (/ &
 & 0.40358E-07_JPRB,0.47014E-04_JPRB,0.64557E-04_JPRB,0.67658E-04_JPRB,0.12293E-04_JPRB /)  
KB(:, 4,15, 3) = (/ &
 & 0.38037E-07_JPRB,0.50641E-04_JPRB,0.69879E-04_JPRB,0.72487E-04_JPRB,0.13317E-04_JPRB /)  
KB(:, 5,15, 3) = (/ &
 & 0.35964E-07_JPRB,0.54003E-04_JPRB,0.75064E-04_JPRB,0.77083E-04_JPRB,0.14321E-04_JPRB /)  
KB(:, 1,16, 3) = (/ &
 & 0.37354E-07_JPRB,0.32479E-04_JPRB,0.44953E-04_JPRB,0.48146E-04_JPRB,0.84079E-05_JPRB /)  
KB(:, 2,16, 3) = (/ &
 & 0.34944E-07_JPRB,0.35873E-04_JPRB,0.49454E-04_JPRB,0.52120E-04_JPRB,0.93405E-05_JPRB /)  
KB(:, 3,16, 3) = (/ &
 & 0.32829E-07_JPRB,0.39220E-04_JPRB,0.53861E-04_JPRB,0.56293E-04_JPRB,0.10209E-04_JPRB /)  
KB(:, 4,16, 3) = (/ &
 & 0.30952E-07_JPRB,0.42155E-04_JPRB,0.58309E-04_JPRB,0.60268E-04_JPRB,0.11080E-04_JPRB /)  
KB(:, 5,16, 3) = (/ &
 & 0.29274E-07_JPRB,0.45014E-04_JPRB,0.62610E-04_JPRB,0.64184E-04_JPRB,0.11887E-04_JPRB /)  
KB(:, 1,17, 3) = (/ &
 & 0.30364E-07_JPRB,0.27086E-04_JPRB,0.37451E-04_JPRB,0.39995E-04_JPRB,0.70049E-05_JPRB /)  
KB(:, 2,17, 3) = (/ &
 & 0.28420E-07_JPRB,0.29919E-04_JPRB,0.41194E-04_JPRB,0.43367E-04_JPRB,0.77736E-05_JPRB /)  
KB(:, 3,17, 3) = (/ &
 & 0.26710E-07_JPRB,0.32650E-04_JPRB,0.44902E-04_JPRB,0.46817E-04_JPRB,0.84838E-05_JPRB /)  
KB(:, 4,17, 3) = (/ &
 & 0.25192E-07_JPRB,0.35098E-04_JPRB,0.48605E-04_JPRB,0.50103E-04_JPRB,0.92038E-05_JPRB /)  
KB(:, 5,17, 3) = (/ &
 & 0.23833E-07_JPRB,0.37507E-04_JPRB,0.52188E-04_JPRB,0.53413E-04_JPRB,0.98607E-05_JPRB /)  
KB(:, 1,18, 3) = (/ &
 & 0.24687E-07_JPRB,0.22581E-04_JPRB,0.31211E-04_JPRB,0.33220E-04_JPRB,0.58361E-05_JPRB /)  
KB(:, 2,18, 3) = (/ &
 & 0.23116E-07_JPRB,0.24940E-04_JPRB,0.34308E-04_JPRB,0.36078E-04_JPRB,0.64640E-05_JPRB /)  
KB(:, 3,18, 3) = (/ &
 & 0.21734E-07_JPRB,0.27181E-04_JPRB,0.37414E-04_JPRB,0.38933E-04_JPRB,0.70344E-05_JPRB /)  
KB(:, 4,18, 3) = (/ &
 & 0.20506E-07_JPRB,0.29216E-04_JPRB,0.40517E-04_JPRB,0.41653E-04_JPRB,0.76276E-05_JPRB /)  
KB(:, 5,18, 3) = (/ &
 & 0.19406E-07_JPRB,0.31237E-04_JPRB,0.43490E-04_JPRB,0.44397E-04_JPRB,0.81753E-05_JPRB /)  
KB(:, 1,19, 3) = (/ &
 & 0.20074E-07_JPRB,0.18818E-04_JPRB,0.25999E-04_JPRB,0.27597E-04_JPRB,0.48662E-05_JPRB /)  
KB(:, 2,19, 3) = (/ &
 & 0.18805E-07_JPRB,0.20784E-04_JPRB,0.28562E-04_JPRB,0.29993E-04_JPRB,0.53723E-05_JPRB /)  
KB(:, 3,19, 3) = (/ &
 & 0.17688E-07_JPRB,0.22626E-04_JPRB,0.31151E-04_JPRB,0.32363E-04_JPRB,0.58377E-05_JPRB /)  
KB(:, 4,19, 3) = (/ &
 & 0.16693E-07_JPRB,0.24300E-04_JPRB,0.33760E-04_JPRB,0.34629E-04_JPRB,0.63177E-05_JPRB /)  
KB(:, 5,19, 3) = (/ &
 & 0.15802E-07_JPRB,0.25985E-04_JPRB,0.36226E-04_JPRB,0.36903E-04_JPRB,0.67742E-05_JPRB /)  
KB(:, 1,20, 3) = (/ &
 & 0.16306E-07_JPRB,0.15717E-04_JPRB,0.21686E-04_JPRB,0.22959E-04_JPRB,0.40680E-05_JPRB /)  
KB(:, 2,20, 3) = (/ &
 & 0.15283E-07_JPRB,0.17355E-04_JPRB,0.23826E-04_JPRB,0.24969E-04_JPRB,0.44706E-05_JPRB /)  
KB(:, 3,20, 3) = (/ &
 & 0.14381E-07_JPRB,0.18856E-04_JPRB,0.25992E-04_JPRB,0.26912E-04_JPRB,0.48550E-05_JPRB /)  
KB(:, 4,20, 3) = (/ &
 & 0.13578E-07_JPRB,0.20265E-04_JPRB,0.28162E-04_JPRB,0.28817E-04_JPRB,0.52355E-05_JPRB /)  
KB(:, 5,20, 3) = (/ &
 & 0.12857E-07_JPRB,0.21638E-04_JPRB,0.30215E-04_JPRB,0.30707E-04_JPRB,0.56224E-05_JPRB /)  
KB(:, 1,21, 3) = (/ &
 & 0.13245E-07_JPRB,0.13128E-04_JPRB,0.18091E-04_JPRB,0.19107E-04_JPRB,0.33880E-05_JPRB /)  
KB(:, 2,21, 3) = (/ &
 & 0.12420E-07_JPRB,0.14495E-04_JPRB,0.19887E-04_JPRB,0.20794E-04_JPRB,0.37144E-05_JPRB /)  
KB(:, 3,21, 3) = (/ &
 & 0.11692E-07_JPRB,0.15704E-04_JPRB,0.21703E-04_JPRB,0.22397E-04_JPRB,0.40415E-05_JPRB /)  
KB(:, 4,21, 3) = (/ &
 & 0.11043E-07_JPRB,0.16904E-04_JPRB,0.23489E-04_JPRB,0.23984E-04_JPRB,0.43455E-05_JPRB /)  
KB(:, 5,21, 3) = (/ &
 & 0.10460E-07_JPRB,0.18037E-04_JPRB,0.25197E-04_JPRB,0.25558E-04_JPRB,0.46662E-05_JPRB /)  
KB(:, 1,22, 3) = (/ &
 & 0.10711E-07_JPRB,0.11044E-04_JPRB,0.15199E-04_JPRB,0.16008E-04_JPRB,0.28409E-05_JPRB /)  
KB(:, 2,22, 3) = (/ &
 & 0.10052E-07_JPRB,0.12165E-04_JPRB,0.16699E-04_JPRB,0.17419E-04_JPRB,0.31041E-05_JPRB /)  
KB(:, 3,22, 3) = (/ &
 & 0.94690E-08_JPRB,0.13158E-04_JPRB,0.18224E-04_JPRB,0.18733E-04_JPRB,0.33768E-05_JPRB /)  
KB(:, 4,22, 3) = (/ &
 & 0.89484E-08_JPRB,0.14166E-04_JPRB,0.19691E-04_JPRB,0.20050E-04_JPRB,0.36237E-05_JPRB /)  
KB(:, 5,22, 3) = (/ &
 & 0.84804E-08_JPRB,0.15085E-04_JPRB,0.21105E-04_JPRB,0.21356E-04_JPRB,0.38876E-05_JPRB /)  
KB(:, 1,23, 3) = (/ &
 & 0.86606E-08_JPRB,0.93002E-05_JPRB,0.12775E-04_JPRB,0.13420E-04_JPRB,0.23815E-05_JPRB /)  
KB(:, 2,23, 3) = (/ &
 & 0.81340E-08_JPRB,0.10210E-04_JPRB,0.14034E-04_JPRB,0.14552E-04_JPRB,0.25955E-05_JPRB /)  
KB(:, 3,23, 3) = (/ &
 & 0.76671E-08_JPRB,0.11035E-04_JPRB,0.15302E-04_JPRB,0.15657E-04_JPRB,0.28150E-05_JPRB /)  
KB(:, 4,23, 3) = (/ &
 & 0.72497E-08_JPRB,0.11863E-04_JPRB,0.16513E-04_JPRB,0.16770E-04_JPRB,0.30198E-05_JPRB /)  
KB(:, 5,23, 3) = (/ &
 & 0.68739E-08_JPRB,0.12616E-04_JPRB,0.17664E-04_JPRB,0.17848E-04_JPRB,0.32387E-05_JPRB /)  
KB(:, 1,24, 3) = (/ &
 & 0.69995E-08_JPRB,0.78392E-05_JPRB,0.10754E-04_JPRB,0.11250E-04_JPRB,0.19986E-05_JPRB /)  
KB(:, 2,24, 3) = (/ &
 & 0.65790E-08_JPRB,0.85674E-05_JPRB,0.11806E-04_JPRB,0.12186E-04_JPRB,0.21738E-05_JPRB /)  
KB(:, 3,24, 3) = (/ &
 & 0.62055E-08_JPRB,0.92664E-05_JPRB,0.12850E-04_JPRB,0.13103E-04_JPRB,0.23469E-05_JPRB /)  
KB(:, 4,24, 3) = (/ &
 & 0.58710E-08_JPRB,0.99376E-05_JPRB,0.13854E-04_JPRB,0.14027E-04_JPRB,0.25195E-05_JPRB /)  
KB(:, 5,24, 3) = (/ &
 & 0.55696E-08_JPRB,0.10527E-04_JPRB,0.14795E-04_JPRB,0.14917E-04_JPRB,0.26988E-05_JPRB /)  
KB(:, 1,25, 3) = (/ &
 & 0.56538E-08_JPRB,0.66118E-05_JPRB,0.90610E-05_JPRB,0.94422E-05_JPRB,0.16753E-05_JPRB /)  
KB(:, 2,25, 3) = (/ &
 & 0.53184E-08_JPRB,0.71986E-05_JPRB,0.99389E-05_JPRB,0.10209E-04_JPRB,0.18223E-05_JPRB /)  
KB(:, 3,25, 3) = (/ &
 & 0.50199E-08_JPRB,0.77863E-05_JPRB,0.10800E-04_JPRB,0.10981E-04_JPRB,0.19590E-05_JPRB /)  
KB(:, 4,25, 3) = (/ &
 & 0.47522E-08_JPRB,0.83415E-05_JPRB,0.11626E-04_JPRB,0.11737E-04_JPRB,0.21020E-05_JPRB /)  
KB(:, 5,25, 3) = (/ &
 & 0.45105E-08_JPRB,0.88017E-05_JPRB,0.12373E-04_JPRB,0.12468E-04_JPRB,0.22498E-05_JPRB /)  
KB(:, 1,26, 3) = (/ &
 & 0.45620E-08_JPRB,0.55749E-05_JPRB,0.76463E-05_JPRB,0.79285E-05_JPRB,0.14032E-05_JPRB /)  
KB(:, 2,26, 3) = (/ &
 & 0.42950E-08_JPRB,0.60590E-05_JPRB,0.83822E-05_JPRB,0.85652E-05_JPRB,0.15255E-05_JPRB /)  
KB(:, 3,26, 3) = (/ &
 & 0.40569E-08_JPRB,0.65510E-05_JPRB,0.90888E-05_JPRB,0.92116E-05_JPRB,0.16373E-05_JPRB /)  
KB(:, 4,26, 3) = (/ &
 & 0.38429E-08_JPRB,0.69918E-05_JPRB,0.97604E-05_JPRB,0.98329E-05_JPRB,0.17561E-05_JPRB /)  
KB(:, 5,26, 3) = (/ &
 & 0.36495E-08_JPRB,0.73566E-05_JPRB,0.10367E-04_JPRB,0.10429E-04_JPRB,0.18769E-05_JPRB /)  
KB(:, 1,27, 3) = (/ &
 & 0.36809E-08_JPRB,0.46967E-05_JPRB,0.64580E-05_JPRB,0.66649E-05_JPRB,0.11786E-05_JPRB /)  
KB(:, 2,27, 3) = (/ &
 & 0.34683E-08_JPRB,0.51072E-05_JPRB,0.70661E-05_JPRB,0.71902E-05_JPRB,0.12759E-05_JPRB /)  
KB(:, 3,27, 3) = (/ &
 & 0.32784E-08_JPRB,0.55053E-05_JPRB,0.76470E-05_JPRB,0.77250E-05_JPRB,0.13691E-05_JPRB /)  
KB(:, 4,27, 3) = (/ &
 & 0.31074E-08_JPRB,0.58474E-05_JPRB,0.81898E-05_JPRB,0.82340E-05_JPRB,0.14666E-05_JPRB /)  
KB(:, 5,27, 3) = (/ &
 & 0.29526E-08_JPRB,0.61493E-05_JPRB,0.86815E-05_JPRB,0.87199E-05_JPRB,0.15650E-05_JPRB /)  
KB(:, 1,28, 3) = (/ &
 & 0.29701E-08_JPRB,0.39582E-05_JPRB,0.54573E-05_JPRB,0.55959E-05_JPRB,0.99037E-06_JPRB /)  
KB(:, 2,28, 3) = (/ &
 & 0.28008E-08_JPRB,0.43048E-05_JPRB,0.59546E-05_JPRB,0.60406E-05_JPRB,0.10659E-05_JPRB /)  
KB(:, 3,28, 3) = (/ &
 & 0.26493E-08_JPRB,0.46277E-05_JPRB,0.64286E-05_JPRB,0.64745E-05_JPRB,0.11442E-05_JPRB /)  
KB(:, 4,28, 3) = (/ &
 & 0.25127E-08_JPRB,0.48940E-05_JPRB,0.68612E-05_JPRB,0.68918E-05_JPRB,0.12250E-05_JPRB /)  
KB(:, 5,28, 3) = (/ &
 & 0.23888E-08_JPRB,0.51428E-05_JPRB,0.72654E-05_JPRB,0.72865E-05_JPRB,0.13046E-05_JPRB /)  
KB(:, 1,29, 3) = (/ &
 & 0.23958E-08_JPRB,0.33409E-05_JPRB,0.46115E-05_JPRB,0.47054E-05_JPRB,0.83021E-06_JPRB /)  
KB(:, 2,29, 3) = (/ &
 & 0.22611E-08_JPRB,0.36267E-05_JPRB,0.50192E-05_JPRB,0.50754E-05_JPRB,0.89157E-06_JPRB /)  
KB(:, 3,29, 3) = (/ &
 & 0.21402E-08_JPRB,0.38805E-05_JPRB,0.54053E-05_JPRB,0.54291E-05_JPRB,0.95663E-06_JPRB /)  
KB(:, 4,29, 3) = (/ &
 & 0.20311E-08_JPRB,0.40929E-05_JPRB,0.57529E-05_JPRB,0.57685E-05_JPRB,0.10232E-05_JPRB /)  
KB(:, 5,29, 3) = (/ &
 & 0.19320E-08_JPRB,0.43014E-05_JPRB,0.60684E-05_JPRB,0.60868E-05_JPRB,0.10874E-05_JPRB /)  
KB(:, 1,30, 3) = (/ &
 & 0.19328E-08_JPRB,0.28217E-05_JPRB,0.38955E-05_JPRB,0.39562E-05_JPRB,0.69464E-06_JPRB /)  
KB(:, 2,30, 3) = (/ &
 & 0.18255E-08_JPRB,0.30515E-05_JPRB,0.42293E-05_JPRB,0.42605E-05_JPRB,0.74588E-06_JPRB /)  
KB(:, 3,30, 3) = (/ &
 & 0.17291E-08_JPRB,0.32496E-05_JPRB,0.45390E-05_JPRB,0.45501E-05_JPRB,0.79957E-06_JPRB /)  
KB(:, 4,30, 3) = (/ &
 & 0.16419E-08_JPRB,0.34235E-05_JPRB,0.48191E-05_JPRB,0.48249E-05_JPRB,0.85373E-06_JPRB /)  
KB(:, 5,30, 3) = (/ &
 & 0.15626E-08_JPRB,0.35992E-05_JPRB,0.50632E-05_JPRB,0.50805E-05_JPRB,0.90582E-06_JPRB /)  
KB(:, 1,31, 3) = (/ &
 & 0.15590E-08_JPRB,0.23841E-05_JPRB,0.32890E-05_JPRB,0.33282E-05_JPRB,0.58108E-06_JPRB /)  
KB(:, 2,31, 3) = (/ &
 & 0.14736E-08_JPRB,0.25683E-05_JPRB,0.35605E-05_JPRB,0.35756E-05_JPRB,0.62401E-06_JPRB /)  
KB(:, 3,31, 3) = (/ &
 & 0.13967E-08_JPRB,0.27223E-05_JPRB,0.38055E-05_JPRB,0.38110E-05_JPRB,0.66862E-06_JPRB /)  
KB(:, 4,31, 3) = (/ &
 & 0.13271E-08_JPRB,0.28652E-05_JPRB,0.40295E-05_JPRB,0.40331E-05_JPRB,0.71216E-06_JPRB /)  
KB(:, 5,31, 3) = (/ &
 & 0.12637E-08_JPRB,0.30069E-05_JPRB,0.42257E-05_JPRB,0.42393E-05_JPRB,0.75527E-06_JPRB /)  
KB(:, 1,32, 3) = (/ &
 & 0.12575E-08_JPRB,0.20099E-05_JPRB,0.27764E-05_JPRB,0.27988E-05_JPRB,0.48614E-06_JPRB /)  
KB(:, 2,32, 3) = (/ &
 & 0.11895E-08_JPRB,0.21551E-05_JPRB,0.29961E-05_JPRB,0.29996E-05_JPRB,0.52199E-06_JPRB /)  
KB(:, 3,32, 3) = (/ &
 & 0.11282E-08_JPRB,0.22771E-05_JPRB,0.31901E-05_JPRB,0.31897E-05_JPRB,0.55867E-06_JPRB /)  
KB(:, 4,32, 3) = (/ &
 & 0.10726E-08_JPRB,0.23969E-05_JPRB,0.33657E-05_JPRB,0.33696E-05_JPRB,0.59410E-06_JPRB /)  
KB(:, 5,32, 3) = (/ &
 & 0.10218E-08_JPRB,0.25076E-05_JPRB,0.35232E-05_JPRB,0.35366E-05_JPRB,0.62965E-06_JPRB /)  
KB(:, 1,33, 3) = (/ &
 & 0.10144E-08_JPRB,0.16940E-05_JPRB,0.23421E-05_JPRB,0.23519E-05_JPRB,0.40701E-06_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART15',1,ZHOOK_HANDLE)
END SUBROUTINE PART15


SUBROUTINE PART16

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART16',0,ZHOOK_HANDLE)


KB(:, 2,33, 3) = (/ &
 & 0.96024E-09_JPRB,0.18066E-05_JPRB,0.25146E-05_JPRB,0.25148E-05_JPRB,0.43657E-06_JPRB /)  
KB(:, 3,33, 3) = (/ &
 & 0.91134E-09_JPRB,0.19053E-05_JPRB,0.26738E-05_JPRB,0.26690E-05_JPRB,0.46656E-06_JPRB /)  
KB(:, 4,33, 3) = (/ &
 & 0.86689E-09_JPRB,0.20038E-05_JPRB,0.28104E-05_JPRB,0.28139E-05_JPRB,0.49516E-06_JPRB /)  
KB(:, 5,33, 3) = (/ &
 & 0.82630E-09_JPRB,0.20860E-05_JPRB,0.29294E-05_JPRB,0.29485E-05_JPRB,0.52462E-06_JPRB /)  
KB(:, 1,34, 3) = (/ &
 & 0.82000E-09_JPRB,0.14231E-05_JPRB,0.19661E-05_JPRB,0.19700E-05_JPRB,0.33996E-06_JPRB /)  
KB(:, 2,34, 3) = (/ &
 & 0.77672E-09_JPRB,0.15105E-05_JPRB,0.21047E-05_JPRB,0.21018E-05_JPRB,0.36435E-06_JPRB /)  
KB(:, 3,34, 3) = (/ &
 & 0.73757E-09_JPRB,0.15908E-05_JPRB,0.22307E-05_JPRB,0.22272E-05_JPRB,0.38851E-06_JPRB /)  
KB(:, 4,34, 3) = (/ &
 & 0.70193E-09_JPRB,0.16706E-05_JPRB,0.23421E-05_JPRB,0.23448E-05_JPRB,0.41219E-06_JPRB /)  
KB(:, 5,34, 3) = (/ &
 & 0.66936E-09_JPRB,0.17330E-05_JPRB,0.24342E-05_JPRB,0.24538E-05_JPRB,0.43607E-06_JPRB /)  
KB(:, 1,35, 3) = (/ &
 & 0.66652E-09_JPRB,0.11842E-05_JPRB,0.16383E-05_JPRB,0.16382E-05_JPRB,0.28183E-06_JPRB /)  
KB(:, 2,35, 3) = (/ &
 & 0.63156E-09_JPRB,0.12541E-05_JPRB,0.17499E-05_JPRB,0.17457E-05_JPRB,0.30195E-06_JPRB /)  
KB(:, 3,35, 3) = (/ &
 & 0.59990E-09_JPRB,0.13209E-05_JPRB,0.18504E-05_JPRB,0.18484E-05_JPRB,0.32174E-06_JPRB /)  
KB(:, 4,35, 3) = (/ &
 & 0.57107E-09_JPRB,0.13850E-05_JPRB,0.19418E-05_JPRB,0.19438E-05_JPRB,0.34124E-06_JPRB /)  
KB(:, 5,35, 3) = (/ &
 & 0.54470E-09_JPRB,0.14348E-05_JPRB,0.20135E-05_JPRB,0.20335E-05_JPRB,0.36050E-06_JPRB /)  
KB(:, 1,36, 3) = (/ &
 & 0.54506E-09_JPRB,0.97870E-06_JPRB,0.13541E-05_JPRB,0.13520E-05_JPRB,0.23190E-06_JPRB /)  
KB(:, 2,36, 3) = (/ &
 & 0.51650E-09_JPRB,0.10354E-05_JPRB,0.14455E-05_JPRB,0.14404E-05_JPRB,0.24845E-06_JPRB /)  
KB(:, 3,36, 3) = (/ &
 & 0.49063E-09_JPRB,0.10910E-05_JPRB,0.15270E-05_JPRB,0.15247E-05_JPRB,0.26464E-06_JPRB /)  
KB(:, 4,36, 3) = (/ &
 & 0.46707E-09_JPRB,0.11427E-05_JPRB,0.16012E-05_JPRB,0.16033E-05_JPRB,0.28072E-06_JPRB /)  
KB(:, 5,36, 3) = (/ &
 & 0.44553E-09_JPRB,0.11833E-05_JPRB,0.16604E-05_JPRB,0.16774E-05_JPRB,0.29643E-06_JPRB /)  
KB(:, 1,37, 3) = (/ &
 & 0.44949E-09_JPRB,0.80104E-06_JPRB,0.11066E-05_JPRB,0.11045E-05_JPRB,0.18888E-06_JPRB /)  
KB(:, 2,37, 3) = (/ &
 & 0.42579E-09_JPRB,0.84810E-06_JPRB,0.11826E-05_JPRB,0.11777E-05_JPRB,0.20242E-06_JPRB /)  
KB(:, 3,37, 3) = (/ &
 & 0.40435E-09_JPRB,0.89404E-06_JPRB,0.12504E-05_JPRB,0.12477E-05_JPRB,0.21578E-06_JPRB /)  
KB(:, 4,37, 3) = (/ &
 & 0.38483E-09_JPRB,0.93737E-06_JPRB,0.13124E-05_JPRB,0.13129E-05_JPRB,0.22892E-06_JPRB /)  
KB(:, 5,37, 3) = (/ &
 & 0.36699E-09_JPRB,0.97118E-06_JPRB,0.13617E-05_JPRB,0.13744E-05_JPRB,0.24190E-06_JPRB /)  
KB(:, 1,38, 3) = (/ &
 & 0.37088E-09_JPRB,0.65468E-06_JPRB,0.90347E-06_JPRB,0.90140E-06_JPRB,0.15371E-06_JPRB /)  
KB(:, 2,38, 3) = (/ &
 & 0.35120E-09_JPRB,0.69421E-06_JPRB,0.96676E-06_JPRB,0.96222E-06_JPRB,0.16484E-06_JPRB /)  
KB(:, 3,38, 3) = (/ &
 & 0.33340E-09_JPRB,0.73211E-06_JPRB,0.10233E-05_JPRB,0.10203E-05_JPRB,0.17578E-06_JPRB /)  
KB(:, 4,38, 3) = (/ &
 & 0.31721E-09_JPRB,0.76838E-06_JPRB,0.10750E-05_JPRB,0.10745E-05_JPRB,0.18656E-06_JPRB /)  
KB(:, 5,38, 3) = (/ &
 & 0.30242E-09_JPRB,0.79676E-06_JPRB,0.11164E-05_JPRB,0.11256E-05_JPRB,0.19730E-06_JPRB /)  
KB(:, 1,39, 3) = (/ &
 & 0.30603E-09_JPRB,0.53518E-06_JPRB,0.73755E-06_JPRB,0.73560E-06_JPRB,0.12509E-06_JPRB /)  
KB(:, 2,39, 3) = (/ &
 & 0.28967E-09_JPRB,0.56827E-06_JPRB,0.79017E-06_JPRB,0.78607E-06_JPRB,0.13420E-06_JPRB /)  
KB(:, 3,39, 3) = (/ &
 & 0.27490E-09_JPRB,0.59946E-06_JPRB,0.83729E-06_JPRB,0.83418E-06_JPRB,0.14320E-06_JPRB /)  
KB(:, 4,39, 3) = (/ &
 & 0.26148E-09_JPRB,0.62968E-06_JPRB,0.88045E-06_JPRB,0.87919E-06_JPRB,0.15206E-06_JPRB /)  
KB(:, 5,39, 3) = (/ &
 & 0.24922E-09_JPRB,0.65358E-06_JPRB,0.91511E-06_JPRB,0.92187E-06_JPRB,0.16092E-06_JPRB /)  
KB(:, 1,40, 3) = (/ &
 & 0.25401E-09_JPRB,0.43491E-06_JPRB,0.59706E-06_JPRB,0.59583E-06_JPRB,0.10103E-06_JPRB /)  
KB(:, 2,40, 3) = (/ &
 & 0.24027E-09_JPRB,0.46243E-06_JPRB,0.64127E-06_JPRB,0.63780E-06_JPRB,0.10854E-06_JPRB /)  
KB(:, 3,40, 3) = (/ &
 & 0.22788E-09_JPRB,0.48789E-06_JPRB,0.68111E-06_JPRB,0.67785E-06_JPRB,0.11596E-06_JPRB /)  
KB(:, 4,40, 3) = (/ &
 & 0.21664E-09_JPRB,0.51370E-06_JPRB,0.71776E-06_JPRB,0.71557E-06_JPRB,0.12318E-06_JPRB /)  
KB(:, 5,40, 3) = (/ &
 & 0.20639E-09_JPRB,0.53413E-06_JPRB,0.74738E-06_JPRB,0.75116E-06_JPRB,0.13055E-06_JPRB /)  
KB(:, 1,41, 3) = (/ &
 & 0.21103E-09_JPRB,0.35162E-06_JPRB,0.48245E-06_JPRB,0.48181E-06_JPRB,0.81551E-07_JPRB /)  
KB(:, 2,41, 3) = (/ &
 & 0.19947E-09_JPRB,0.37577E-06_JPRB,0.51975E-06_JPRB,0.51683E-06_JPRB,0.87624E-07_JPRB /)  
KB(:, 3,41, 3) = (/ &
 & 0.18906E-09_JPRB,0.39681E-06_JPRB,0.55372E-06_JPRB,0.55016E-06_JPRB,0.93775E-07_JPRB /)  
KB(:, 4,41, 3) = (/ &
 & 0.17963E-09_JPRB,0.41856E-06_JPRB,0.58405E-06_JPRB,0.58177E-06_JPRB,0.99677E-07_JPRB /)  
KB(:, 5,41, 3) = (/ &
 & 0.17105E-09_JPRB,0.43610E-06_JPRB,0.60957E-06_JPRB,0.61150E-06_JPRB,0.10578E-06_JPRB /)  
KB(:, 1,42, 3) = (/ &
 & 0.17536E-09_JPRB,0.28412E-06_JPRB,0.38948E-06_JPRB,0.38933E-06_JPRB,0.65791E-07_JPRB /)  
KB(:, 2,42, 3) = (/ &
 & 0.16563E-09_JPRB,0.30504E-06_JPRB,0.42097E-06_JPRB,0.41854E-06_JPRB,0.70752E-07_JPRB /)  
KB(:, 3,42, 3) = (/ &
 & 0.15688E-09_JPRB,0.32265E-06_JPRB,0.44957E-06_JPRB,0.44624E-06_JPRB,0.75790E-07_JPRB /)  
KB(:, 4,42, 3) = (/ &
 & 0.14897E-09_JPRB,0.34080E-06_JPRB,0.47502E-06_JPRB,0.47268E-06_JPRB,0.80648E-07_JPRB /)  
KB(:, 5,42, 3) = (/ &
 & 0.14178E-09_JPRB,0.35584E-06_JPRB,0.49696E-06_JPRB,0.49747E-06_JPRB,0.85685E-07_JPRB /)  
KB(:, 1,43, 3) = (/ &
 & 0.14625E-09_JPRB,0.22828E-06_JPRB,0.31269E-06_JPRB,0.31301E-06_JPRB,0.52858E-07_JPRB /)  
KB(:, 2,43, 3) = (/ &
 & 0.13800E-09_JPRB,0.24660E-06_JPRB,0.33945E-06_JPRB,0.33736E-06_JPRB,0.56872E-07_JPRB /)  
KB(:, 3,43, 3) = (/ &
 & 0.13060E-09_JPRB,0.26150E-06_JPRB,0.36382E-06_JPRB,0.36052E-06_JPRB,0.61005E-07_JPRB /)  
KB(:, 4,43, 3) = (/ &
 & 0.12392E-09_JPRB,0.27637E-06_JPRB,0.38496E-06_JPRB,0.38262E-06_JPRB,0.65064E-07_JPRB /)  
KB(:, 5,43, 3) = (/ &
 & 0.11786E-09_JPRB,0.28960E-06_JPRB,0.40432E-06_JPRB,0.40346E-06_JPRB,0.69134E-07_JPRB /)  
KB(:, 1,44, 3) = (/ &
 & 0.12220E-09_JPRB,0.18299E-06_JPRB,0.25003E-06_JPRB,0.25075E-06_JPRB,0.42426E-07_JPRB /)  
KB(:, 2,44, 3) = (/ &
 & 0.11518E-09_JPRB,0.19858E-06_JPRB,0.27271E-06_JPRB,0.27124E-06_JPRB,0.45605E-07_JPRB /)  
KB(:, 3,44, 3) = (/ &
 & 0.10890E-09_JPRB,0.21149E-06_JPRB,0.29306E-06_JPRB,0.29059E-06_JPRB,0.48989E-07_JPRB /)  
KB(:, 4,44, 3) = (/ &
 & 0.10324E-09_JPRB,0.22361E-06_JPRB,0.31128E-06_JPRB,0.30909E-06_JPRB,0.52357E-07_JPRB /)  
KB(:, 5,44, 3) = (/ &
 & 0.98119E-10_JPRB,0.23540E-06_JPRB,0.32782E-06_JPRB,0.32657E-06_JPRB,0.55650E-07_JPRB /)  
KB(:, 1,45, 3) = (/ &
 & 0.10215E-09_JPRB,0.14604E-06_JPRB,0.19957E-06_JPRB,0.20079E-06_JPRB,0.34009E-07_JPRB /)  
KB(:, 2,45, 3) = (/ &
 & 0.96168E-10_JPRB,0.15976E-06_JPRB,0.21859E-06_JPRB,0.21782E-06_JPRB,0.36565E-07_JPRB /)  
KB(:, 3,45, 3) = (/ &
 & 0.90832E-10_JPRB,0.17092E-06_JPRB,0.23594E-06_JPRB,0.23403E-06_JPRB,0.39336E-07_JPRB /)  
KB(:, 4,45, 3) = (/ &
 & 0.86039E-10_JPRB,0.18076E-06_JPRB,0.25148E-06_JPRB,0.24940E-06_JPRB,0.42120E-07_JPRB /)  
KB(:, 5,45, 3) = (/ &
 & 0.81705E-10_JPRB,0.19091E-06_JPRB,0.26579E-06_JPRB,0.26417E-06_JPRB,0.44806E-07_JPRB /)  
KB(:, 1,46, 3) = (/ &
 & 0.85548E-10_JPRB,0.11606E-06_JPRB,0.15858E-06_JPRB,0.16025E-06_JPRB,0.27138E-07_JPRB /)  
KB(:, 2,46, 3) = (/ &
 & 0.80430E-10_JPRB,0.12777E-06_JPRB,0.17465E-06_JPRB,0.17439E-06_JPRB,0.29260E-07_JPRB /)  
KB(:, 3,46, 3) = (/ &
 & 0.75882E-10_JPRB,0.13771E-06_JPRB,0.18956E-06_JPRB,0.18801E-06_JPRB,0.31519E-07_JPRB /)  
KB(:, 4,46, 3) = (/ &
 & 0.71807E-10_JPRB,0.14597E-06_JPRB,0.20282E-06_JPRB,0.20085E-06_JPRB,0.33790E-07_JPRB /)  
KB(:, 5,46, 3) = (/ &
 & 0.68131E-10_JPRB,0.15454E-06_JPRB,0.21485E-06_JPRB,0.21321E-06_JPRB,0.36016E-07_JPRB /)  
KB(:, 1,47, 3) = (/ &
 & 0.71880E-10_JPRB,0.91677E-07_JPRB,0.12518E-06_JPRB,0.12717E-06_JPRB,0.21548E-07_JPRB /)  
KB(:, 2,47, 3) = (/ &
 & 0.67474E-10_JPRB,0.10182E-06_JPRB,0.13885E-06_JPRB,0.13887E-06_JPRB,0.23366E-07_JPRB /)  
KB(:, 3,47, 3) = (/ &
 & 0.63573E-10_JPRB,0.11037E-06_JPRB,0.15155E-06_JPRB,0.15037E-06_JPRB,0.25140E-07_JPRB /)  
KB(:, 4,47, 3) = (/ &
 & 0.60089E-10_JPRB,0.11757E-06_JPRB,0.16292E-06_JPRB,0.16115E-06_JPRB,0.27023E-07_JPRB /)  
KB(:, 5,47, 3) = (/ &
 & 0.56955E-10_JPRB,0.12460E-06_JPRB,0.17303E-06_JPRB,0.17150E-06_JPRB,0.28886E-07_JPRB /)  
KB(:, 1,48, 3) = (/ &
 & 0.60438E-10_JPRB,0.72378E-07_JPRB,0.98586E-07_JPRB,0.10075E-06_JPRB,0.17068E-07_JPRB /)  
KB(:, 2,48, 3) = (/ &
 & 0.56639E-10_JPRB,0.80662E-07_JPRB,0.11003E-06_JPRB,0.11052E-06_JPRB,0.18643E-07_JPRB /)  
KB(:, 3,48, 3) = (/ &
 & 0.53288E-10_JPRB,0.88391E-07_JPRB,0.12069E-06_JPRB,0.12007E-06_JPRB,0.20050E-07_JPRB /)  
KB(:, 4,48, 3) = (/ &
 & 0.50306E-10_JPRB,0.94624E-07_JPRB,0.13045E-06_JPRB,0.12916E-06_JPRB,0.21587E-07_JPRB /)  
KB(:, 5,48, 3) = (/ &
 & 0.47632E-10_JPRB,0.10026E-06_JPRB,0.13914E-06_JPRB,0.13778E-06_JPRB,0.23136E-07_JPRB /)  
KB(:, 1,49, 3) = (/ &
 & 0.50856E-10_JPRB,0.57046E-07_JPRB,0.77565E-07_JPRB,0.79741E-07_JPRB,0.13510E-07_JPRB /)  
KB(:, 2,49, 3) = (/ &
 & 0.47574E-10_JPRB,0.63730E-07_JPRB,0.86939E-07_JPRB,0.87826E-07_JPRB,0.14811E-07_JPRB /)  
KB(:, 3,49, 3) = (/ &
 & 0.44692E-10_JPRB,0.70367E-07_JPRB,0.95974E-07_JPRB,0.95707E-07_JPRB,0.15992E-07_JPRB /)  
KB(:, 4,49, 3) = (/ &
 & 0.42136E-10_JPRB,0.75959E-07_JPRB,0.10441E-06_JPRB,0.10336E-06_JPRB,0.17235E-07_JPRB /)  
KB(:, 5,49, 3) = (/ &
 & 0.39851E-10_JPRB,0.80662E-07_JPRB,0.11179E-06_JPRB,0.11061E-06_JPRB,0.18501E-07_JPRB /)  
KB(:, 1,50, 3) = (/ &
 & 0.42752E-10_JPRB,0.44994E-07_JPRB,0.60933E-07_JPRB,0.63170E-07_JPRB,0.10733E-07_JPRB /)  
KB(:, 2,50, 3) = (/ &
 & 0.39920E-10_JPRB,0.50417E-07_JPRB,0.68695E-07_JPRB,0.69776E-07_JPRB,0.11778E-07_JPRB /)  
KB(:, 3,50, 3) = (/ &
 & 0.37445E-10_JPRB,0.56129E-07_JPRB,0.76381E-07_JPRB,0.76292E-07_JPRB,0.12796E-07_JPRB /)  
KB(:, 4,50, 3) = (/ &
 & 0.35258E-10_JPRB,0.60916E-07_JPRB,0.83533E-07_JPRB,0.82746E-07_JPRB,0.13770E-07_JPRB /)  
KB(:, 5,50, 3) = (/ &
 & 0.33309E-10_JPRB,0.65010E-07_JPRB,0.89933E-07_JPRB,0.88828E-07_JPRB,0.14809E-07_JPRB /)  
KB(:, 1,51, 3) = (/ &
 & 0.35935E-10_JPRB,0.35278E-07_JPRB,0.47901E-07_JPRB,0.50056E-07_JPRB,0.85239E-08_JPRB /)  
KB(:, 2,51, 3) = (/ &
 & 0.33494E-10_JPRB,0.39897E-07_JPRB,0.54245E-07_JPRB,0.55439E-07_JPRB,0.93562E-08_JPRB /)  
KB(:, 3,51, 3) = (/ &
 & 0.31368E-10_JPRB,0.44577E-07_JPRB,0.60687E-07_JPRB,0.60854E-07_JPRB,0.10229E-07_JPRB /)  
KB(:, 4,51, 3) = (/ &
 & 0.29497E-10_JPRB,0.48906E-07_JPRB,0.66668E-07_JPRB,0.66217E-07_JPRB,0.11009E-07_JPRB /)  
KB(:, 5,51, 3) = (/ &
 & 0.27834E-10_JPRB,0.52348E-07_JPRB,0.72154E-07_JPRB,0.71322E-07_JPRB,0.11856E-07_JPRB /)  
KB(:, 1,52, 3) = (/ &
 & 0.30227E-10_JPRB,0.27572E-07_JPRB,0.37524E-07_JPRB,0.39754E-07_JPRB,0.67198E-08_JPRB /)  
KB(:, 2,52, 3) = (/ &
 & 0.28118E-10_JPRB,0.31560E-07_JPRB,0.42810E-07_JPRB,0.44031E-07_JPRB,0.74267E-08_JPRB /)  
KB(:, 3,52, 3) = (/ &
 & 0.26290E-10_JPRB,0.35319E-07_JPRB,0.48079E-07_JPRB,0.48486E-07_JPRB,0.81511E-08_JPRB /)  
KB(:, 4,52, 3) = (/ &
 & 0.24687E-10_JPRB,0.39041E-07_JPRB,0.53141E-07_JPRB,0.52898E-07_JPRB,0.88044E-08_JPRB /)  
KB(:, 5,52, 3) = (/ &
 & 0.23267E-10_JPRB,0.42123E-07_JPRB,0.57835E-07_JPRB,0.57177E-07_JPRB,0.94934E-08_JPRB /)  
KB(:, 1,53, 3) = (/ &
 & 0.25448E-10_JPRB,0.21456E-07_JPRB,0.29324E-07_JPRB,0.31450E-07_JPRB,0.53035E-08_JPRB /)  
KB(:, 2,53, 3) = (/ &
 & 0.23623E-10_JPRB,0.24922E-07_JPRB,0.33706E-07_JPRB,0.34903E-07_JPRB,0.59025E-08_JPRB /)  
KB(:, 3,53, 3) = (/ &
 & 0.22048E-10_JPRB,0.27931E-07_JPRB,0.38009E-07_JPRB,0.38548E-07_JPRB,0.64842E-08_JPRB /)  
KB(:, 4,53, 3) = (/ &
 & 0.20673E-10_JPRB,0.31117E-07_JPRB,0.42293E-07_JPRB,0.42180E-07_JPRB,0.70454E-08_JPRB /)  
KB(:, 5,53, 3) = (/ &
 & 0.19459E-10_JPRB,0.33800E-07_JPRB,0.46316E-07_JPRB,0.45776E-07_JPRB,0.75886E-08_JPRB /)  
KB(:, 1,54, 3) = (/ &
 & 0.21390E-10_JPRB,0.16743E-07_JPRB,0.23031E-07_JPRB,0.24877E-07_JPRB,0.41777E-08_JPRB /)  
KB(:, 2,54, 3) = (/ &
 & 0.19815E-10_JPRB,0.19619E-07_JPRB,0.26556E-07_JPRB,0.27722E-07_JPRB,0.47031E-08_JPRB /)  
KB(:, 3,54, 3) = (/ &
 & 0.18463E-10_JPRB,0.22167E-07_JPRB,0.30101E-07_JPRB,0.30708E-07_JPRB,0.51646E-08_JPRB /)  
KB(:, 4,54, 3) = (/ &
 & 0.17286E-10_JPRB,0.24804E-07_JPRB,0.33704E-07_JPRB,0.33716E-07_JPRB,0.56448E-08_JPRB /)  
KB(:, 5,54, 3) = (/ &
 & 0.16251E-10_JPRB,0.27183E-07_JPRB,0.37049E-07_JPRB,0.36696E-07_JPRB,0.60788E-08_JPRB /)  
KB(:, 1,55, 3) = (/ &
 & 0.17973E-10_JPRB,0.13037E-07_JPRB,0.18115E-07_JPRB,0.19727E-07_JPRB,0.32912E-08_JPRB /)  
KB(:, 2,55, 3) = (/ &
 & 0.16615E-10_JPRB,0.15402E-07_JPRB,0.20942E-07_JPRB,0.22043E-07_JPRB,0.37301E-08_JPRB /)  
KB(:, 3,55, 3) = (/ &
 & 0.15454E-10_JPRB,0.17592E-07_JPRB,0.23848E-07_JPRB,0.24485E-07_JPRB,0.41129E-08_JPRB /)  
KB(:, 4,55, 3) = (/ &
 & 0.14448E-10_JPRB,0.19733E-07_JPRB,0.26815E-07_JPRB,0.26954E-07_JPRB,0.45146E-08_JPRB /)  
KB(:, 5,55, 3) = (/ &
 & 0.13565E-10_JPRB,0.21785E-07_JPRB,0.29633E-07_JPRB,0.29414E-07_JPRB,0.48762E-08_JPRB /)  
KB(:, 1,56, 3) = (/ &
 & 0.15112E-10_JPRB,0.10127E-07_JPRB,0.14262E-07_JPRB,0.15637E-07_JPRB,0.25986E-08_JPRB /)  
KB(:, 2,56, 3) = (/ &
 & 0.13939E-10_JPRB,0.12082E-07_JPRB,0.16458E-07_JPRB,0.17567E-07_JPRB,0.29510E-08_JPRB /)  
KB(:, 3,56, 3) = (/ &
 & 0.12942E-10_JPRB,0.13980E-07_JPRB,0.18876E-07_JPRB,0.19499E-07_JPRB,0.32803E-08_JPRB /)  
KB(:, 4,56, 3) = (/ &
 & 0.12080E-10_JPRB,0.15677E-07_JPRB,0.21298E-07_JPRB,0.21516E-07_JPRB,0.36078E-08_JPRB /)  
KB(:, 5,56, 3) = (/ &
 & 0.11328E-10_JPRB,0.17421E-07_JPRB,0.23674E-07_JPRB,0.23552E-07_JPRB,0.39142E-08_JPRB /)  
KB(:, 1,57, 3) = (/ &
 & 0.12716E-10_JPRB,0.78423E-08_JPRB,0.11218E-07_JPRB,0.12368E-07_JPRB,0.20572E-08_JPRB /)  
KB(:, 2,57, 3) = (/ &
 & 0.11703E-10_JPRB,0.94468E-08_JPRB,0.12944E-07_JPRB,0.13939E-07_JPRB,0.23449E-08_JPRB /)  
KB(:, 3,57, 3) = (/ &
 & 0.10844E-10_JPRB,0.11054E-07_JPRB,0.14933E-07_JPRB,0.15504E-07_JPRB,0.26161E-08_JPRB /)  
KB(:, 4,57, 3) = (/ &
 & 0.10105E-10_JPRB,0.12445E-07_JPRB,0.16895E-07_JPRB,0.17167E-07_JPRB,0.28789E-08_JPRB /)  
KB(:, 5,57, 3) = (/ &
 & 0.94629E-11_JPRB,0.13929E-07_JPRB,0.18884E-07_JPRB,0.18837E-07_JPRB,0.31391E-08_JPRB /)  
KB(:, 1,58, 3) = (/ &
 & 0.10694E-10_JPRB,0.61084E-08_JPRB,0.88278E-08_JPRB,0.97801E-08_JPRB,0.16192E-08_JPRB /)  
KB(:, 2,58, 3) = (/ &
 & 0.98180E-11_JPRB,0.73859E-08_JPRB,0.10206E-07_JPRB,0.11064E-07_JPRB,0.18486E-08_JPRB /)  
KB(:, 3,58, 3) = (/ &
 & 0.90797E-11_JPRB,0.87113E-08_JPRB,0.11801E-07_JPRB,0.12348E-07_JPRB,0.20872E-08_JPRB /)  
KB(:, 4,58, 3) = (/ &
 & 0.84478E-11_JPRB,0.99003E-08_JPRB,0.13409E-07_JPRB,0.13707E-07_JPRB,0.22967E-08_JPRB /)  
KB(:, 5,58, 3) = (/ &
 & 0.78998E-11_JPRB,0.11108E-07_JPRB,0.15069E-07_JPRB,0.15082E-07_JPRB,0.25182E-08_JPRB /)  
KB(:, 1,59, 3) = (/ &
 & 0.88513E-11_JPRB,0.49239E-08_JPRB,0.71386E-08_JPRB,0.79170E-08_JPRB,0.13089E-08_JPRB /)  
KB(:, 2,59, 3) = (/ &
 & 0.81187E-11_JPRB,0.59541E-08_JPRB,0.82539E-08_JPRB,0.89758E-08_JPRB,0.14952E-08_JPRB /)  
KB(:, 3,59, 3) = (/ &
 & 0.75021E-11_JPRB,0.70450E-08_JPRB,0.95567E-08_JPRB,0.10024E-07_JPRB,0.16919E-08_JPRB /)  
KB(:, 4,59, 3) = (/ &
 & 0.69753E-11_JPRB,0.80391E-08_JPRB,0.10874E-07_JPRB,0.11143E-07_JPRB,0.18646E-08_JPRB /)  
KB(:, 5,59, 3) = (/ &
 & 0.65191E-11_JPRB,0.90265E-08_JPRB,0.12240E-07_JPRB,0.12268E-07_JPRB,0.20471E-08_JPRB /)  
KB(:, 1,13, 4) = (/ &
 & 0.40115E-06_JPRB,0.20542E-03_JPRB,0.29006E-03_JPRB,0.29983E-03_JPRB,0.86404E-04_JPRB /)  
KB(:, 2,13, 4) = (/ &
 & 0.38503E-06_JPRB,0.22086E-03_JPRB,0.30833E-03_JPRB,0.32518E-03_JPRB,0.92611E-04_JPRB /)  
KB(:, 3,13, 4) = (/ &
 & 0.37042E-06_JPRB,0.23415E-03_JPRB,0.32674E-03_JPRB,0.34814E-03_JPRB,0.98878E-04_JPRB /)  
KB(:, 4,13, 4) = (/ &
 & 0.35699E-06_JPRB,0.24607E-03_JPRB,0.34335E-03_JPRB,0.36858E-03_JPRB,0.10559E-03_JPRB /)  
KB(:, 5,13, 4) = (/ &
 & 0.34439E-06_JPRB,0.25741E-03_JPRB,0.35943E-03_JPRB,0.38716E-03_JPRB,0.11262E-03_JPRB /)  
KB(:, 1,14, 4) = (/ &
 & 0.32717E-06_JPRB,0.17086E-03_JPRB,0.24121E-03_JPRB,0.25001E-03_JPRB,0.72120E-04_JPRB /)  
KB(:, 2,14, 4) = (/ &
 & 0.31411E-06_JPRB,0.18358E-03_JPRB,0.25599E-03_JPRB,0.27089E-03_JPRB,0.77351E-04_JPRB /)  
KB(:, 3,14, 4) = (/ &
 & 0.30225E-06_JPRB,0.19456E-03_JPRB,0.27149E-03_JPRB,0.29002E-03_JPRB,0.82676E-04_JPRB /)  
KB(:, 4,14, 4) = (/ &
 & 0.29132E-06_JPRB,0.20460E-03_JPRB,0.28544E-03_JPRB,0.30678E-03_JPRB,0.88331E-04_JPRB /)  
KB(:, 5,14, 4) = (/ &
 & 0.28105E-06_JPRB,0.21410E-03_JPRB,0.29919E-03_JPRB,0.32271E-03_JPRB,0.94451E-04_JPRB /)  
KB(:, 1,15, 4) = (/ &
 & 0.26673E-06_JPRB,0.14221E-03_JPRB,0.20048E-03_JPRB,0.20843E-03_JPRB,0.60213E-04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART16',1,ZHOOK_HANDLE)
END SUBROUTINE PART16


SUBROUTINE PART17

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART17',0,ZHOOK_HANDLE)


KB(:, 2,15, 4) = (/ &
 & 0.25615E-06_JPRB,0.15268E-03_JPRB,0.21264E-03_JPRB,0.22531E-03_JPRB,0.64531E-04_JPRB /)  
KB(:, 3,15, 4) = (/ &
 & 0.24652E-06_JPRB,0.16170E-03_JPRB,0.22567E-03_JPRB,0.24157E-03_JPRB,0.69102E-04_JPRB /)  
KB(:, 4,15, 4) = (/ &
 & 0.23764E-06_JPRB,0.17023E-03_JPRB,0.23750E-03_JPRB,0.25543E-03_JPRB,0.73891E-04_JPRB /)  
KB(:, 5,15, 4) = (/ &
 & 0.22926E-06_JPRB,0.17815E-03_JPRB,0.24912E-03_JPRB,0.26892E-03_JPRB,0.79167E-04_JPRB /)  
KB(:, 1,16, 4) = (/ &
 & 0.21740E-06_JPRB,0.11824E-03_JPRB,0.16644E-03_JPRB,0.17381E-03_JPRB,0.50227E-04_JPRB /)  
KB(:, 2,16, 4) = (/ &
 & 0.20884E-06_JPRB,0.12696E-03_JPRB,0.17683E-03_JPRB,0.18780E-03_JPRB,0.53903E-04_JPRB /)  
KB(:, 3,16, 4) = (/ &
 & 0.20104E-06_JPRB,0.13434E-03_JPRB,0.18764E-03_JPRB,0.20094E-03_JPRB,0.57777E-04_JPRB /)  
KB(:, 4,16, 4) = (/ &
 & 0.19381E-06_JPRB,0.14177E-03_JPRB,0.19757E-03_JPRB,0.21259E-03_JPRB,0.61821E-04_JPRB /)  
KB(:, 5,16, 4) = (/ &
 & 0.18698E-06_JPRB,0.14828E-03_JPRB,0.20747E-03_JPRB,0.22416E-03_JPRB,0.66326E-04_JPRB /)  
KB(:, 1,17, 4) = (/ &
 & 0.17724E-06_JPRB,0.98287E-04_JPRB,0.13813E-03_JPRB,0.14496E-03_JPRB,0.41851E-04_JPRB /)  
KB(:, 2,17, 4) = (/ &
 & 0.17029E-06_JPRB,0.10548E-03_JPRB,0.14701E-03_JPRB,0.15636E-03_JPRB,0.44943E-04_JPRB /)  
KB(:, 3,17, 4) = (/ &
 & 0.16396E-06_JPRB,0.11169E-03_JPRB,0.15605E-03_JPRB,0.16727E-03_JPRB,0.48176E-04_JPRB /)  
KB(:, 4,17, 4) = (/ &
 & 0.15809E-06_JPRB,0.11795E-03_JPRB,0.16435E-03_JPRB,0.17684E-03_JPRB,0.51716E-04_JPRB /)  
KB(:, 5,17, 4) = (/ &
 & 0.15251E-06_JPRB,0.12332E-03_JPRB,0.17265E-03_JPRB,0.18683E-03_JPRB,0.55480E-04_JPRB /)  
KB(:, 1,18, 4) = (/ &
 & 0.14450E-06_JPRB,0.81703E-04_JPRB,0.11464E-03_JPRB,0.12079E-03_JPRB,0.34849E-04_JPRB /)  
KB(:, 2,18, 4) = (/ &
 & 0.13887E-06_JPRB,0.87580E-04_JPRB,0.12224E-03_JPRB,0.13028E-03_JPRB,0.37465E-04_JPRB /)  
KB(:, 3,18, 4) = (/ &
 & 0.13373E-06_JPRB,0.92869E-04_JPRB,0.12966E-03_JPRB,0.13906E-03_JPRB,0.40225E-04_JPRB /)  
KB(:, 4,18, 4) = (/ &
 & 0.12896E-06_JPRB,0.98034E-04_JPRB,0.13668E-03_JPRB,0.14712E-03_JPRB,0.43227E-04_JPRB /)  
KB(:, 5,18, 4) = (/ &
 & 0.12439E-06_JPRB,0.10250E-03_JPRB,0.14367E-03_JPRB,0.15557E-03_JPRB,0.46383E-04_JPRB /)  
KB(:, 1,19, 4) = (/ &
 & 0.11782E-06_JPRB,0.67922E-04_JPRB,0.95121E-04_JPRB,0.10059E-03_JPRB,0.29014E-04_JPRB /)  
KB(:, 2,19, 4) = (/ &
 & 0.11325E-06_JPRB,0.72759E-04_JPRB,0.10166E-03_JPRB,0.10843E-03_JPRB,0.31239E-04_JPRB /)  
KB(:, 3,19, 4) = (/ &
 & 0.10909E-06_JPRB,0.77213E-04_JPRB,0.10769E-03_JPRB,0.11563E-03_JPRB,0.33594E-04_JPRB /)  
KB(:, 4,19, 4) = (/ &
 & 0.10521E-06_JPRB,0.81507E-04_JPRB,0.11367E-03_JPRB,0.12244E-03_JPRB,0.36087E-04_JPRB /)  
KB(:, 5,19, 4) = (/ &
 & 0.10146E-06_JPRB,0.85229E-04_JPRB,0.11951E-03_JPRB,0.12955E-03_JPRB,0.38760E-04_JPRB /)  
KB(:, 1,20, 4) = (/ &
 & 0.96005E-07_JPRB,0.56539E-04_JPRB,0.79048E-04_JPRB,0.83638E-04_JPRB,0.24182E-04_JPRB /)  
KB(:, 2,20, 4) = (/ &
 & 0.92311E-07_JPRB,0.60522E-04_JPRB,0.84506E-04_JPRB,0.90308E-04_JPRB,0.26052E-04_JPRB /)  
KB(:, 3,20, 4) = (/ &
 & 0.88927E-07_JPRB,0.64305E-04_JPRB,0.89608E-04_JPRB,0.96229E-04_JPRB,0.28071E-04_JPRB /)  
KB(:, 4,20, 4) = (/ &
 & 0.85775E-07_JPRB,0.67811E-04_JPRB,0.94659E-04_JPRB,0.10203E-03_JPRB,0.30185E-04_JPRB /)  
KB(:, 5,20, 4) = (/ &
 & 0.82709E-07_JPRB,0.70967E-04_JPRB,0.99551E-04_JPRB,0.10796E-03_JPRB,0.32438E-04_JPRB /)  
KB(:, 1,21, 4) = (/ &
 & 0.78225E-07_JPRB,0.47094E-04_JPRB,0.65736E-04_JPRB,0.69706E-04_JPRB,0.20168E-04_JPRB /)  
KB(:, 2,21, 4) = (/ &
 & 0.75235E-07_JPRB,0.50383E-04_JPRB,0.70309E-04_JPRB,0.75210E-04_JPRB,0.21748E-04_JPRB /)  
KB(:, 3,21, 4) = (/ &
 & 0.72491E-07_JPRB,0.53581E-04_JPRB,0.74579E-04_JPRB,0.80106E-04_JPRB,0.23442E-04_JPRB /)  
KB(:, 4,21, 4) = (/ &
 & 0.69929E-07_JPRB,0.56448E-04_JPRB,0.78864E-04_JPRB,0.85108E-04_JPRB,0.25248E-04_JPRB /)  
KB(:, 5,21, 4) = (/ &
 & 0.67419E-07_JPRB,0.59090E-04_JPRB,0.82932E-04_JPRB,0.89870E-04_JPRB,0.27098E-04_JPRB /)  
KB(:, 1,22, 4) = (/ &
 & 0.63572E-07_JPRB,0.39426E-04_JPRB,0.54979E-04_JPRB,0.58443E-04_JPRB,0.16913E-04_JPRB /)  
KB(:, 2,22, 4) = (/ &
 & 0.61166E-07_JPRB,0.42097E-04_JPRB,0.58779E-04_JPRB,0.62933E-04_JPRB,0.18259E-04_JPRB /)  
KB(:, 3,22, 4) = (/ &
 & 0.58951E-07_JPRB,0.44794E-04_JPRB,0.62330E-04_JPRB,0.66952E-04_JPRB,0.19670E-04_JPRB /)  
KB(:, 4,22, 4) = (/ &
 & 0.56872E-07_JPRB,0.47147E-04_JPRB,0.65961E-04_JPRB,0.71230E-04_JPRB,0.21221E-04_JPRB /)  
KB(:, 5,22, 4) = (/ &
 & 0.54822E-07_JPRB,0.49377E-04_JPRB,0.69234E-04_JPRB,0.75038E-04_JPRB,0.22743E-04_JPRB /)  
KB(:, 1,23, 4) = (/ &
 & 0.51656E-07_JPRB,0.32950E-04_JPRB,0.46052E-04_JPRB,0.49084E-04_JPRB,0.14181E-04_JPRB /)  
KB(:, 2,23, 4) = (/ &
 & 0.49721E-07_JPRB,0.35250E-04_JPRB,0.49106E-04_JPRB,0.52675E-04_JPRB,0.15330E-04_JPRB /)  
KB(:, 3,23, 4) = (/ &
 & 0.47930E-07_JPRB,0.37438E-04_JPRB,0.52152E-04_JPRB,0.56097E-04_JPRB,0.16532E-04_JPRB /)  
KB(:, 4,23, 4) = (/ &
 & 0.46242E-07_JPRB,0.39418E-04_JPRB,0.55160E-04_JPRB,0.59674E-04_JPRB,0.17811E-04_JPRB /)  
KB(:, 5,23, 4) = (/ &
 & 0.44570E-07_JPRB,0.41280E-04_JPRB,0.57899E-04_JPRB,0.62654E-04_JPRB,0.19100E-04_JPRB /)  
KB(:, 1,24, 4) = (/ &
 & 0.41962E-07_JPRB,0.27608E-04_JPRB,0.38527E-04_JPRB,0.41167E-04_JPRB,0.11908E-04_JPRB /)  
KB(:, 2,24, 4) = (/ &
 & 0.40405E-07_JPRB,0.29547E-04_JPRB,0.41099E-04_JPRB,0.44081E-04_JPRB,0.12880E-04_JPRB /)  
KB(:, 3,24, 4) = (/ &
 & 0.38959E-07_JPRB,0.31321E-04_JPRB,0.43687E-04_JPRB,0.47051E-04_JPRB,0.13912E-04_JPRB /)  
KB(:, 4,24, 4) = (/ &
 & 0.37583E-07_JPRB,0.32994E-04_JPRB,0.46190E-04_JPRB,0.49890E-04_JPRB,0.14961E-04_JPRB /)  
KB(:, 5,24, 4) = (/ &
 & 0.36227E-07_JPRB,0.34560E-04_JPRB,0.48473E-04_JPRB,0.52358E-04_JPRB,0.16039E-04_JPRB /)  
KB(:, 1,25, 4) = (/ &
 & 0.34075E-07_JPRB,0.23153E-04_JPRB,0.32305E-04_JPRB,0.34566E-04_JPRB,0.10014E-04_JPRB /)  
KB(:, 2,25, 4) = (/ &
 & 0.32822E-07_JPRB,0.24769E-04_JPRB,0.34435E-04_JPRB,0.36968E-04_JPRB,0.10822E-04_JPRB /)  
KB(:, 3,25, 4) = (/ &
 & 0.31655E-07_JPRB,0.26242E-04_JPRB,0.36635E-04_JPRB,0.39484E-04_JPRB,0.11699E-04_JPRB /)  
KB(:, 4,25, 4) = (/ &
 & 0.30528E-07_JPRB,0.27624E-04_JPRB,0.38648E-04_JPRB,0.41770E-04_JPRB,0.12588E-04_JPRB /)  
KB(:, 5,25, 4) = (/ &
 & 0.29434E-07_JPRB,0.28951E-04_JPRB,0.40632E-04_JPRB,0.43774E-04_JPRB,0.13479E-04_JPRB /)  
KB(:, 1,26, 4) = (/ &
 & 0.27652E-07_JPRB,0.19460E-04_JPRB,0.27114E-04_JPRB,0.29052E-04_JPRB,0.84372E-05_JPRB /)  
KB(:, 2,26, 4) = (/ &
 & 0.26645E-07_JPRB,0.20785E-04_JPRB,0.28933E-04_JPRB,0.31091E-04_JPRB,0.91305E-05_JPRB /)  
KB(:, 3,26, 4) = (/ &
 & 0.25703E-07_JPRB,0.22018E-04_JPRB,0.30749E-04_JPRB,0.33173E-04_JPRB,0.98560E-05_JPRB /)  
KB(:, 4,26, 4) = (/ &
 & 0.24780E-07_JPRB,0.23166E-04_JPRB,0.32405E-04_JPRB,0.34971E-04_JPRB,0.10593E-04_JPRB /)  
KB(:, 5,26, 4) = (/ &
 & 0.23900E-07_JPRB,0.24286E-04_JPRB,0.34048E-04_JPRB,0.36663E-04_JPRB,0.11346E-04_JPRB /)  
KB(:, 1,27, 4) = (/ &
 & 0.22439E-07_JPRB,0.16370E-04_JPRB,0.22763E-04_JPRB,0.24397E-04_JPRB,0.71084E-05_JPRB /)  
KB(:, 2,27, 4) = (/ &
 & 0.21628E-07_JPRB,0.17461E-04_JPRB,0.24318E-04_JPRB,0.26140E-04_JPRB,0.76961E-05_JPRB /)  
KB(:, 3,27, 4) = (/ &
 & 0.20865E-07_JPRB,0.18493E-04_JPRB,0.25826E-04_JPRB,0.27824E-04_JPRB,0.83080E-05_JPRB /)  
KB(:, 4,27, 4) = (/ &
 & 0.20113E-07_JPRB,0.19452E-04_JPRB,0.27215E-04_JPRB,0.29287E-04_JPRB,0.89207E-05_JPRB /)  
KB(:, 5,27, 4) = (/ &
 & 0.19405E-07_JPRB,0.20376E-04_JPRB,0.28543E-04_JPRB,0.30710E-04_JPRB,0.95477E-05_JPRB /)  
KB(:, 1,28, 4) = (/ &
 & 0.18208E-07_JPRB,0.13777E-04_JPRB,0.19138E-04_JPRB,0.20524E-04_JPRB,0.59952E-05_JPRB /)  
KB(:, 2,28, 4) = (/ &
 & 0.17555E-07_JPRB,0.14679E-04_JPRB,0.20448E-04_JPRB,0.21996E-04_JPRB,0.64907E-05_JPRB /)  
KB(:, 3,28, 4) = (/ &
 & 0.16936E-07_JPRB,0.15522E-04_JPRB,0.21661E-04_JPRB,0.23357E-04_JPRB,0.69966E-05_JPRB /)  
KB(:, 4,28, 4) = (/ &
 & 0.16325E-07_JPRB,0.16334E-04_JPRB,0.22846E-04_JPRB,0.24537E-04_JPRB,0.75124E-05_JPRB /)  
KB(:, 5,28, 4) = (/ &
 & 0.15755E-07_JPRB,0.17088E-04_JPRB,0.23931E-04_JPRB,0.25722E-04_JPRB,0.80305E-05_JPRB /)  
KB(:, 1,29, 4) = (/ &
 & 0.14772E-07_JPRB,0.11598E-04_JPRB,0.16117E-04_JPRB,0.17294E-04_JPRB,0.50602E-05_JPRB /)  
KB(:, 2,29, 4) = (/ &
 & 0.14246E-07_JPRB,0.12346E-04_JPRB,0.17198E-04_JPRB,0.18521E-04_JPRB,0.54799E-05_JPRB /)  
KB(:, 3,29, 4) = (/ &
 & 0.13739E-07_JPRB,0.13047E-04_JPRB,0.18205E-04_JPRB,0.19566E-04_JPRB,0.58992E-05_JPRB /)  
KB(:, 4,29, 4) = (/ &
 & 0.13247E-07_JPRB,0.13729E-04_JPRB,0.19173E-04_JPRB,0.20574E-04_JPRB,0.63251E-05_JPRB /)  
KB(:, 5,29, 4) = (/ &
 & 0.12789E-07_JPRB,0.14341E-04_JPRB,0.20068E-04_JPRB,0.21536E-04_JPRB,0.67496E-05_JPRB /)  
KB(:, 1,30, 4) = (/ &
 & 0.11984E-07_JPRB,0.97679E-05_JPRB,0.13568E-04_JPRB,0.14565E-04_JPRB,0.42721E-05_JPRB /)  
KB(:, 2,30, 4) = (/ &
 & 0.11560E-07_JPRB,0.10389E-04_JPRB,0.14461E-04_JPRB,0.15560E-04_JPRB,0.46182E-05_JPRB /)  
KB(:, 3,30, 4) = (/ &
 & 0.11144E-07_JPRB,0.10973E-04_JPRB,0.15302E-04_JPRB,0.16410E-04_JPRB,0.49715E-05_JPRB /)  
KB(:, 4,30, 4) = (/ &
 & 0.10750E-07_JPRB,0.11532E-04_JPRB,0.16091E-04_JPRB,0.17244E-04_JPRB,0.53212E-05_JPRB /)  
KB(:, 5,30, 4) = (/ &
 & 0.10381E-07_JPRB,0.12034E-04_JPRB,0.16821E-04_JPRB,0.18023E-04_JPRB,0.56712E-05_JPRB /)  
KB(:, 1,31, 4) = (/ &
 & 0.97205E-08_JPRB,0.82296E-05_JPRB,0.11440E-04_JPRB,0.12288E-04_JPRB,0.36079E-05_JPRB /)  
KB(:, 2,31, 4) = (/ &
 & 0.93777E-08_JPRB,0.87431E-05_JPRB,0.12158E-04_JPRB,0.13067E-04_JPRB,0.38974E-05_JPRB /)  
KB(:, 3,31, 4) = (/ &
 & 0.90391E-08_JPRB,0.92300E-05_JPRB,0.12862E-04_JPRB,0.13769E-04_JPRB,0.41885E-05_JPRB /)  
KB(:, 4,31, 4) = (/ &
 & 0.87219E-08_JPRB,0.96854E-05_JPRB,0.13508E-04_JPRB,0.14454E-04_JPRB,0.44756E-05_JPRB /)  
KB(:, 5,31, 4) = (/ &
 & 0.84251E-08_JPRB,0.10101E-04_JPRB,0.14090E-04_JPRB,0.15064E-04_JPRB,0.47643E-05_JPRB /)  
KB(:, 1,32, 4) = (/ &
 & 0.78842E-08_JPRB,0.69379E-05_JPRB,0.96378E-05_JPRB,0.10350E-04_JPRB,0.30462E-05_JPRB /)  
KB(:, 2,32, 4) = (/ &
 & 0.76058E-08_JPRB,0.73605E-05_JPRB,0.10230E-04_JPRB,0.10964E-04_JPRB,0.32879E-05_JPRB /)  
KB(:, 3,32, 4) = (/ &
 & 0.73312E-08_JPRB,0.77685E-05_JPRB,0.10806E-04_JPRB,0.11552E-04_JPRB,0.35258E-05_JPRB /)  
KB(:, 4,32, 4) = (/ &
 & 0.70761E-08_JPRB,0.81393E-05_JPRB,0.11329E-04_JPRB,0.12109E-04_JPRB,0.37642E-05_JPRB /)  
KB(:, 5,32, 4) = (/ &
 & 0.68375E-08_JPRB,0.84723E-05_JPRB,0.11806E-04_JPRB,0.12582E-04_JPRB,0.40027E-05_JPRB /)  
KB(:, 1,33, 4) = (/ &
 & 0.63946E-08_JPRB,0.58484E-05_JPRB,0.81132E-05_JPRB,0.87138E-05_JPRB,0.25722E-05_JPRB /)  
KB(:, 2,33, 4) = (/ &
 & 0.61668E-08_JPRB,0.61985E-05_JPRB,0.86152E-05_JPRB,0.92043E-05_JPRB,0.27716E-05_JPRB /)  
KB(:, 3,33, 4) = (/ &
 & 0.59460E-08_JPRB,0.65329E-05_JPRB,0.90761E-05_JPRB,0.96914E-05_JPRB,0.29672E-05_JPRB /)  
KB(:, 4,33, 4) = (/ &
 & 0.57410E-08_JPRB,0.68349E-05_JPRB,0.94991E-05_JPRB,0.10128E-04_JPRB,0.31649E-05_JPRB /)  
KB(:, 5,33, 4) = (/ &
 & 0.55490E-08_JPRB,0.71098E-05_JPRB,0.98972E-05_JPRB,0.10494E-04_JPRB,0.33613E-05_JPRB /)  
KB(:, 1,34, 4) = (/ &
 & 0.51931E-08_JPRB,0.49155E-05_JPRB,0.68122E-05_JPRB,0.73003E-05_JPRB,0.21648E-05_JPRB /)  
KB(:, 2,34, 4) = (/ &
 & 0.50066E-08_JPRB,0.52108E-05_JPRB,0.72299E-05_JPRB,0.77128E-05_JPRB,0.23280E-05_JPRB /)  
KB(:, 3,34, 4) = (/ &
 & 0.48289E-08_JPRB,0.54838E-05_JPRB,0.76076E-05_JPRB,0.81077E-05_JPRB,0.24906E-05_JPRB /)  
KB(:, 4,34, 4) = (/ &
 & 0.46636E-08_JPRB,0.57271E-05_JPRB,0.79460E-05_JPRB,0.84494E-05_JPRB,0.26534E-05_JPRB /)  
KB(:, 5,34, 4) = (/ &
 & 0.45089E-08_JPRB,0.59543E-05_JPRB,0.82751E-05_JPRB,0.87422E-05_JPRB,0.28159E-05_JPRB /)  
KB(:, 1,35, 4) = (/ &
 & 0.42177E-08_JPRB,0.41104E-05_JPRB,0.56914E-05_JPRB,0.60852E-05_JPRB,0.18078E-05_JPRB /)  
KB(:, 2,35, 4) = (/ &
 & 0.40795E-08_JPRB,0.43580E-05_JPRB,0.60334E-05_JPRB,0.64274E-05_JPRB,0.19421E-05_JPRB /)  
KB(:, 3,35, 4) = (/ &
 & 0.39353E-08_JPRB,0.45814E-05_JPRB,0.63407E-05_JPRB,0.67443E-05_JPRB,0.20767E-05_JPRB /)  
KB(:, 4,35, 4) = (/ &
 & 0.38012E-08_JPRB,0.47803E-05_JPRB,0.66196E-05_JPRB,0.70144E-05_JPRB,0.22114E-05_JPRB /)  
KB(:, 5,35, 4) = (/ &
 & 0.36756E-08_JPRB,0.49682E-05_JPRB,0.68884E-05_JPRB,0.72539E-05_JPRB,0.23458E-05_JPRB /)  
KB(:, 1,36, 4) = (/ &
 & 0.34162E-08_JPRB,0.34141E-05_JPRB,0.47224E-05_JPRB,0.50412E-05_JPRB,0.14965E-05_JPRB /)  
KB(:, 2,36, 4) = (/ &
 & 0.33196E-08_JPRB,0.36215E-05_JPRB,0.50037E-05_JPRB,0.53241E-05_JPRB,0.16078E-05_JPRB /)  
KB(:, 3,36, 4) = (/ &
 & 0.32195E-08_JPRB,0.38064E-05_JPRB,0.52583E-05_JPRB,0.55817E-05_JPRB,0.17188E-05_JPRB /)  
KB(:, 4,36, 4) = (/ &
 & 0.31099E-08_JPRB,0.39715E-05_JPRB,0.54881E-05_JPRB,0.58006E-05_JPRB,0.18307E-05_JPRB /)  
KB(:, 5,36, 4) = (/ &
 & 0.30072E-08_JPRB,0.41270E-05_JPRB,0.57065E-05_JPRB,0.59974E-05_JPRB,0.19419E-05_JPRB /)  
KB(:, 1,37, 4) = (/ &
 & 0.28008E-08_JPRB,0.28094E-05_JPRB,0.38801E-05_JPRB,0.41393E-05_JPRB,0.12248E-05_JPRB /)  
KB(:, 2,37, 4) = (/ &
 & 0.27121E-08_JPRB,0.29836E-05_JPRB,0.41155E-05_JPRB,0.43748E-05_JPRB,0.13168E-05_JPRB /)  
KB(:, 3,37, 4) = (/ &
 & 0.26482E-08_JPRB,0.31397E-05_JPRB,0.43282E-05_JPRB,0.45885E-05_JPRB,0.14087E-05_JPRB /)  
KB(:, 4,37, 4) = (/ &
 & 0.25576E-08_JPRB,0.32779E-05_JPRB,0.45200E-05_JPRB,0.47706E-05_JPRB,0.15013E-05_JPRB /)  
KB(:, 5,37, 4) = (/ &
 & 0.24727E-08_JPRB,0.34082E-05_JPRB,0.47023E-05_JPRB,0.49354E-05_JPRB,0.15935E-05_JPRB /)  
KB(:, 1,38, 4) = (/ &
 & 0.22984E-08_JPRB,0.23106E-05_JPRB,0.31856E-05_JPRB,0.33961E-05_JPRB,0.10016E-05_JPRB /)  
KB(:, 2,38, 4) = (/ &
 & 0.22220E-08_JPRB,0.24563E-05_JPRB,0.33826E-05_JPRB,0.35915E-05_JPRB,0.10776E-05_JPRB /)  
KB(:, 3,38, 4) = (/ &
 & 0.21588E-08_JPRB,0.25882E-05_JPRB,0.35600E-05_JPRB,0.37696E-05_JPRB,0.11538E-05_JPRB /)  
KB(:, 4,38, 4) = (/ &
 & 0.21040E-08_JPRB,0.27033E-05_JPRB,0.37199E-05_JPRB,0.39213E-05_JPRB,0.12304E-05_JPRB /)  
KB(:, 5,38, 4) = (/ &
 & 0.20339E-08_JPRB,0.28122E-05_JPRB,0.38728E-05_JPRB,0.40597E-05_JPRB,0.13067E-05_JPRB /)  
KB(:, 1,39, 4) = (/ &
 & 0.18867E-08_JPRB,0.18990E-05_JPRB,0.26147E-05_JPRB,0.27855E-05_JPRB,0.81895E-06_JPRB /)  
KB(:, 2,39, 4) = (/ &
 & 0.18219E-08_JPRB,0.20211E-05_JPRB,0.27789E-05_JPRB,0.29482E-05_JPRB,0.88168E-06_JPRB /)  
KB(:, 3,39, 4) = (/ &
 & 0.17671E-08_JPRB,0.21324E-05_JPRB,0.29272E-05_JPRB,0.30962E-05_JPRB,0.94475E-06_JPRB /)  
KB(:, 4,39, 4) = (/ &
 & 0.17201E-08_JPRB,0.22287E-05_JPRB,0.30607E-05_JPRB,0.32231E-05_JPRB,0.10080E-05_JPRB /)  
KB(:, 5,39, 4) = (/ &
 & 0.16729E-08_JPRB,0.23197E-05_JPRB,0.31885E-05_JPRB,0.33389E-05_JPRB,0.10713E-05_JPRB /)  
KB(:, 1,40, 4) = (/ &
 & 0.15567E-08_JPRB,0.15486E-05_JPRB,0.21299E-05_JPRB,0.22697E-05_JPRB,0.66418E-06_JPRB /)  
KB(:, 2,40, 4) = (/ &
 & 0.15030E-08_JPRB,0.16525E-05_JPRB,0.22686E-05_JPRB,0.24063E-05_JPRB,0.71591E-06_JPRB /)  
KB(:, 3,40, 4) = (/ &
 & 0.14559E-08_JPRB,0.17468E-05_JPRB,0.23938E-05_JPRB,0.25304E-05_JPRB,0.76804E-06_JPRB /)  
KB(:, 4,40, 4) = (/ &
 & 0.14147E-08_JPRB,0.18284E-05_JPRB,0.25062E-05_JPRB,0.26377E-05_JPRB,0.82053E-06_JPRB /)  
KB(:, 5,40, 4) = (/ &
 & 0.13808E-08_JPRB,0.19051E-05_JPRB,0.26142E-05_JPRB,0.27362E-05_JPRB,0.87282E-06_JPRB /)  
KB(:, 1,41, 4) = (/ &
 & 0.12855E-08_JPRB,0.12622E-05_JPRB,0.17326E-05_JPRB,0.18472E-05_JPRB,0.53778E-06_JPRB /)  
KB(:, 2,41, 4) = (/ &
 & 0.12414E-08_JPRB,0.13486E-05_JPRB,0.18494E-05_JPRB,0.19612E-05_JPRB,0.58062E-06_JPRB /)  
KB(:, 3,41, 4) = (/ &
 & 0.12006E-08_JPRB,0.14290E-05_JPRB,0.19551E-05_JPRB,0.20665E-05_JPRB,0.62365E-06_JPRB /)  
KB(:, 4,41, 4) = (/ &
 & 0.11655E-08_JPRB,0.14984E-05_JPRB,0.20506E-05_JPRB,0.21570E-05_JPRB,0.66707E-06_JPRB /)  
KB(:, 5,41, 4) = (/ &
 & 0.11366E-08_JPRB,0.15630E-05_JPRB,0.21416E-05_JPRB,0.22404E-05_JPRB,0.71035E-06_JPRB /)  
KB(:, 1,42, 4) = (/ &
 & 0.10616E-08_JPRB,0.10273E-05_JPRB,0.14085E-05_JPRB,0.15034E-05_JPRB,0.43514E-06_JPRB /)  
KB(:, 2,42, 4) = (/ &
 & 0.10250E-08_JPRB,0.10997E-05_JPRB,0.15070E-05_JPRB,0.15973E-05_JPRB,0.47061E-06_JPRB /)  
KB(:, 3,42, 4) = (/ &
 & 0.99030E-09_JPRB,0.11679E-05_JPRB,0.15953E-05_JPRB,0.16861E-05_JPRB,0.50613E-06_JPRB /)  
KB(:, 4,42, 4) = (/ &
 & 0.96062E-09_JPRB,0.12272E-05_JPRB,0.16766E-05_JPRB,0.17642E-05_JPRB,0.54216E-06_JPRB /)  
KB(:, 5,42, 4) = (/ &
 & 0.93443E-09_JPRB,0.12817E-05_JPRB,0.17529E-05_JPRB,0.18333E-05_JPRB,0.57784E-06_JPRB /)  
KB(:, 1,43, 4) = (/ &
 & 0.87883E-09_JPRB,0.83199E-06_JPRB,0.11402E-05_JPRB,0.12168E-05_JPRB,0.35025E-06_JPRB /)  
KB(:, 2,43, 4) = (/ &
 & 0.84829E-09_JPRB,0.89254E-06_JPRB,0.12225E-05_JPRB,0.12958E-05_JPRB,0.37960E-06_JPRB /)  
KB(:, 3,43, 4) = (/ &
 & 0.81903E-09_JPRB,0.95072E-06_JPRB,0.12966E-05_JPRB,0.13708E-05_JPRB,0.40893E-06_JPRB /)  
KB(:, 4,43, 4) = (/ &
 & 0.79369E-09_JPRB,0.10020E-05_JPRB,0.13665E-05_JPRB,0.14379E-05_JPRB,0.43862E-06_JPRB /)  
KB(:, 5,43, 4) = (/ &
 & 0.77108E-09_JPRB,0.10478E-05_JPRB,0.14302E-05_JPRB,0.14962E-05_JPRB,0.46817E-06_JPRB /)  
KB(:, 1,44, 4) = (/ &
 & 0.72838E-09_JPRB,0.67080E-06_JPRB,0.91962E-06_JPRB,0.98102E-06_JPRB,0.28107E-06_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART17',1,ZHOOK_HANDLE)
END SUBROUTINE PART17


SUBROUTINE PART18

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART18',0,ZHOOK_HANDLE)


KB(:, 2,44, 4) = (/ &
 & 0.70279E-09_JPRB,0.72271E-06_JPRB,0.98853E-06_JPRB,0.10491E-05_JPRB,0.30540E-06_JPRB /)  
KB(:, 3,44, 4) = (/ &
 & 0.67858E-09_JPRB,0.77203E-06_JPRB,0.10522E-05_JPRB,0.11122E-05_JPRB,0.32958E-06_JPRB /)  
KB(:, 4,44, 4) = (/ &
 & 0.65651E-09_JPRB,0.81625E-06_JPRB,0.11115E-05_JPRB,0.11697E-05_JPRB,0.35407E-06_JPRB /)  
KB(:, 5,44, 4) = (/ &
 & 0.63727E-09_JPRB,0.85495E-06_JPRB,0.11651E-05_JPRB,0.12192E-05_JPRB,0.37850E-06_JPRB /)  
KB(:, 1,45, 4) = (/ &
 & 0.60379E-09_JPRB,0.54047E-06_JPRB,0.74128E-06_JPRB,0.79100E-06_JPRB,0.22535E-06_JPRB /)  
KB(:, 2,45, 4) = (/ &
 & 0.58228E-09_JPRB,0.58429E-06_JPRB,0.79854E-06_JPRB,0.84841E-06_JPRB,0.24548E-06_JPRB /)  
KB(:, 3,45, 4) = (/ &
 & 0.56220E-09_JPRB,0.62606E-06_JPRB,0.85283E-06_JPRB,0.90157E-06_JPRB,0.26541E-06_JPRB /)  
KB(:, 4,45, 4) = (/ &
 & 0.54320E-09_JPRB,0.66423E-06_JPRB,0.90296E-06_JPRB,0.95015E-06_JPRB,0.28558E-06_JPRB /)  
KB(:, 5,45, 4) = (/ &
 & 0.52686E-09_JPRB,0.69719E-06_JPRB,0.94830E-06_JPRB,0.99254E-06_JPRB,0.30580E-06_JPRB /)  
KB(:, 1,46, 4) = (/ &
 & 0.50108E-09_JPRB,0.43361E-06_JPRB,0.59554E-06_JPRB,0.63432E-06_JPRB,0.18023E-06_JPRB /)  
KB(:, 2,46, 4) = (/ &
 & 0.48291E-09_JPRB,0.47127E-06_JPRB,0.64349E-06_JPRB,0.68510E-06_JPRB,0.19677E-06_JPRB /)  
KB(:, 3,46, 4) = (/ &
 & 0.46612E-09_JPRB,0.50621E-06_JPRB,0.68942E-06_JPRB,0.72929E-06_JPRB,0.21325E-06_JPRB /)  
KB(:, 4,46, 4) = (/ &
 & 0.45004E-09_JPRB,0.53903E-06_JPRB,0.73169E-06_JPRB,0.77095E-06_JPRB,0.22986E-06_JPRB /)  
KB(:, 5,46, 4) = (/ &
 & 0.43600E-09_JPRB,0.56740E-06_JPRB,0.77081E-06_JPRB,0.80714E-06_JPRB,0.24654E-06_JPRB /)  
KB(:, 1,47, 4) = (/ &
 & 0.41665E-09_JPRB,0.34614E-06_JPRB,0.47565E-06_JPRB,0.50598E-06_JPRB,0.14345E-06_JPRB /)  
KB(:, 2,47, 4) = (/ &
 & 0.40119E-09_JPRB,0.37779E-06_JPRB,0.51642E-06_JPRB,0.55015E-06_JPRB,0.15697E-06_JPRB /)  
KB(:, 3,47, 4) = (/ &
 & 0.38702E-09_JPRB,0.40752E-06_JPRB,0.55525E-06_JPRB,0.58759E-06_JPRB,0.17064E-06_JPRB /)  
KB(:, 4,47, 4) = (/ &
 & 0.37372E-09_JPRB,0.43563E-06_JPRB,0.59076E-06_JPRB,0.62318E-06_JPRB,0.18430E-06_JPRB /)  
KB(:, 5,47, 4) = (/ &
 & 0.36139E-09_JPRB,0.46041E-06_JPRB,0.62474E-06_JPRB,0.65515E-06_JPRB,0.19800E-06_JPRB /)  
KB(:, 1,48, 4) = (/ &
 & 0.34658E-09_JPRB,0.27494E-06_JPRB,0.37924E-06_JPRB,0.40349E-06_JPRB,0.11407E-06_JPRB /)  
KB(:, 2,48, 4) = (/ &
 & 0.33340E-09_JPRB,0.30243E-06_JPRB,0.41340E-06_JPRB,0.44066E-06_JPRB,0.12508E-06_JPRB /)  
KB(:, 3,48, 4) = (/ &
 & 0.32143E-09_JPRB,0.32756E-06_JPRB,0.44635E-06_JPRB,0.47308E-06_JPRB,0.13636E-06_JPRB /)  
KB(:, 4,48, 4) = (/ &
 & 0.31032E-09_JPRB,0.35149E-06_JPRB,0.47669E-06_JPRB,0.50309E-06_JPRB,0.14763E-06_JPRB /)  
KB(:, 5,48, 4) = (/ &
 & 0.29969E-09_JPRB,0.37323E-06_JPRB,0.50542E-06_JPRB,0.53062E-06_JPRB,0.15892E-06_JPRB /)  
KB(:, 1,49, 4) = (/ &
 & 0.28846E-09_JPRB,0.21778E-06_JPRB,0.30168E-06_JPRB,0.32158E-06_JPRB,0.90607E-07_JPRB /)  
KB(:, 2,49, 4) = (/ &
 & 0.27716E-09_JPRB,0.24139E-06_JPRB,0.33071E-06_JPRB,0.35214E-06_JPRB,0.99577E-07_JPRB /)  
KB(:, 3,49, 4) = (/ &
 & 0.26700E-09_JPRB,0.26304E-06_JPRB,0.35804E-06_JPRB,0.38049E-06_JPRB,0.10881E-06_JPRB /)  
KB(:, 4,49, 4) = (/ &
 & 0.25767E-09_JPRB,0.28313E-06_JPRB,0.38394E-06_JPRB,0.40566E-06_JPRB,0.11814E-06_JPRB /)  
KB(:, 5,49, 4) = (/ &
 & 0.24875E-09_JPRB,0.30183E-06_JPRB,0.40832E-06_JPRB,0.42906E-06_JPRB,0.12742E-06_JPRB /)  
KB(:, 1,50, 4) = (/ &
 & 0.23994E-09_JPRB,0.17276E-06_JPRB,0.24039E-06_JPRB,0.25644E-06_JPRB,0.72124E-07_JPRB /)  
KB(:, 2,50, 4) = (/ &
 & 0.23028E-09_JPRB,0.19275E-06_JPRB,0.26429E-06_JPRB,0.28117E-06_JPRB,0.79388E-07_JPRB /)  
KB(:, 3,50, 4) = (/ &
 & 0.22162E-09_JPRB,0.21106E-06_JPRB,0.28758E-06_JPRB,0.30606E-06_JPRB,0.86922E-07_JPRB /)  
KB(:, 4,50, 4) = (/ &
 & 0.21377E-09_JPRB,0.22807E-06_JPRB,0.30947E-06_JPRB,0.32714E-06_JPRB,0.94628E-07_JPRB /)  
KB(:, 5,50, 4) = (/ &
 & 0.20641E-09_JPRB,0.24400E-06_JPRB,0.32962E-06_JPRB,0.34715E-06_JPRB,0.10228E-06_JPRB /)  
KB(:, 1,51, 4) = (/ &
 & 0.19960E-09_JPRB,0.13709E-06_JPRB,0.19101E-06_JPRB,0.20407E-06_JPRB,0.57566E-07_JPRB /)  
KB(:, 2,51, 4) = (/ &
 & 0.19132E-09_JPRB,0.15352E-06_JPRB,0.21120E-06_JPRB,0.22455E-06_JPRB,0.63308E-07_JPRB /)  
KB(:, 3,51, 4) = (/ &
 & 0.18395E-09_JPRB,0.16924E-06_JPRB,0.23068E-06_JPRB,0.24563E-06_JPRB,0.69421E-07_JPRB /)  
KB(:, 4,51, 4) = (/ &
 & 0.17732E-09_JPRB,0.18352E-06_JPRB,0.24926E-06_JPRB,0.26383E-06_JPRB,0.75773E-07_JPRB /)  
KB(:, 5,51, 4) = (/ &
 & 0.17117E-09_JPRB,0.19715E-06_JPRB,0.26630E-06_JPRB,0.28068E-06_JPRB,0.82097E-07_JPRB /)  
KB(:, 1,52, 4) = (/ &
 & 0.16616E-09_JPRB,0.10852E-06_JPRB,0.15191E-06_JPRB,0.16137E-06_JPRB,0.45975E-07_JPRB /)  
KB(:, 2,52, 4) = (/ &
 & 0.15901E-09_JPRB,0.12188E-06_JPRB,0.16855E-06_JPRB,0.17943E-06_JPRB,0.50454E-07_JPRB /)  
KB(:, 3,52, 4) = (/ &
 & 0.15272E-09_JPRB,0.13535E-06_JPRB,0.18502E-06_JPRB,0.19705E-06_JPRB,0.55424E-07_JPRB /)  
KB(:, 4,52, 4) = (/ &
 & 0.14711E-09_JPRB,0.14765E-06_JPRB,0.20042E-06_JPRB,0.21252E-06_JPRB,0.60616E-07_JPRB /)  
KB(:, 5,52, 4) = (/ &
 & 0.14194E-09_JPRB,0.15907E-06_JPRB,0.21484E-06_JPRB,0.22673E-06_JPRB,0.65826E-07_JPRB /)  
KB(:, 1,53, 4) = (/ &
 & 0.13839E-09_JPRB,0.85704E-07_JPRB,0.12023E-06_JPRB,0.12744E-06_JPRB,0.36523E-07_JPRB /)  
KB(:, 2,53, 4) = (/ &
 & 0.13223E-09_JPRB,0.96600E-07_JPRB,0.13438E-06_JPRB,0.14312E-06_JPRB,0.40152E-07_JPRB /)  
KB(:, 3,53, 4) = (/ &
 & 0.12684E-09_JPRB,0.10804E-06_JPRB,0.14784E-06_JPRB,0.15735E-06_JPRB,0.44207E-07_JPRB /)  
KB(:, 4,53, 4) = (/ &
 & 0.12208E-09_JPRB,0.11851E-06_JPRB,0.16093E-06_JPRB,0.17108E-06_JPRB,0.48435E-07_JPRB /)  
KB(:, 5,53, 4) = (/ &
 & 0.11772E-09_JPRB,0.12811E-06_JPRB,0.17313E-06_JPRB,0.18293E-06_JPRB,0.52733E-07_JPRB /)  
KB(:, 1,54, 4) = (/ &
 & 0.11516E-09_JPRB,0.67802E-07_JPRB,0.95400E-07_JPRB,0.10065E-06_JPRB,0.29040E-07_JPRB /)  
KB(:, 2,54, 4) = (/ &
 & 0.10986E-09_JPRB,0.76927E-07_JPRB,0.10712E-06_JPRB,0.11428E-06_JPRB,0.32044E-07_JPRB /)  
KB(:, 3,54, 4) = (/ &
 & 0.10526E-09_JPRB,0.86295E-07_JPRB,0.11833E-06_JPRB,0.12580E-06_JPRB,0.35335E-07_JPRB /)  
KB(:, 4,54, 4) = (/ &
 & 0.10122E-09_JPRB,0.95190E-07_JPRB,0.12936E-06_JPRB,0.13763E-06_JPRB,0.38764E-07_JPRB /)  
KB(:, 5,54, 4) = (/ &
 & 0.97545E-10_JPRB,0.10324E-06_JPRB,0.13969E-06_JPRB,0.14768E-06_JPRB,0.42312E-07_JPRB /)  
KB(:, 1,55, 4) = (/ &
 & 0.95832E-10_JPRB,0.53610E-07_JPRB,0.75981E-07_JPRB,0.79667E-07_JPRB,0.23117E-07_JPRB /)  
KB(:, 2,55, 4) = (/ &
 & 0.91281E-10_JPRB,0.61130E-07_JPRB,0.85329E-07_JPRB,0.91005E-07_JPRB,0.25657E-07_JPRB /)  
KB(:, 3,55, 4) = (/ &
 & 0.87335E-10_JPRB,0.68825E-07_JPRB,0.94736E-07_JPRB,0.10075E-06_JPRB,0.28264E-07_JPRB /)  
KB(:, 4,55, 4) = (/ &
 & 0.83897E-10_JPRB,0.76435E-07_JPRB,0.10396E-06_JPRB,0.11070E-06_JPRB,0.31057E-07_JPRB /)  
KB(:, 5,55, 4) = (/ &
 & 0.80810E-10_JPRB,0.83278E-07_JPRB,0.11269E-06_JPRB,0.11928E-06_JPRB,0.33972E-07_JPRB /)  
KB(:, 1,56, 4) = (/ &
 & 0.79810E-10_JPRB,0.42322E-07_JPRB,0.60374E-07_JPRB,0.62926E-07_JPRB,0.18404E-07_JPRB /)  
KB(:, 2,56, 4) = (/ &
 & 0.75864E-10_JPRB,0.48559E-07_JPRB,0.68039E-07_JPRB,0.72241E-07_JPRB,0.20548E-07_JPRB /)  
KB(:, 3,56, 4) = (/ &
 & 0.72485E-10_JPRB,0.54773E-07_JPRB,0.75799E-07_JPRB,0.80757E-07_JPRB,0.22581E-07_JPRB /)  
KB(:, 4,56, 4) = (/ &
 & 0.69560E-10_JPRB,0.61224E-07_JPRB,0.83554E-07_JPRB,0.88967E-07_JPRB,0.24859E-07_JPRB /)  
KB(:, 5,56, 4) = (/ &
 & 0.66951E-10_JPRB,0.67084E-07_JPRB,0.90797E-07_JPRB,0.96246E-07_JPRB,0.27245E-07_JPRB /)  
KB(:, 1,57, 4) = (/ &
 & 0.66524E-10_JPRB,0.33320E-07_JPRB,0.47516E-07_JPRB,0.49541E-07_JPRB,0.14620E-07_JPRB /)  
KB(:, 2,57, 4) = (/ &
 & 0.63081E-10_JPRB,0.38443E-07_JPRB,0.54027E-07_JPRB,0.57142E-07_JPRB,0.16370E-07_JPRB /)  
KB(:, 3,57, 4) = (/ &
 & 0.60187E-10_JPRB,0.43587E-07_JPRB,0.60611E-07_JPRB,0.64608E-07_JPRB,0.18036E-07_JPRB /)  
KB(:, 4,57, 4) = (/ &
 & 0.57689E-10_JPRB,0.48970E-07_JPRB,0.66915E-07_JPRB,0.71233E-07_JPRB,0.19895E-07_JPRB /)  
KB(:, 5,57, 4) = (/ &
 & 0.55478E-10_JPRB,0.53925E-07_JPRB,0.73045E-07_JPRB,0.77618E-07_JPRB,0.21831E-07_JPRB /)  
KB(:, 1,58, 4) = (/ &
 & 0.55447E-10_JPRB,0.26240E-07_JPRB,0.37435E-07_JPRB,0.38989E-07_JPRB,0.11606E-07_JPRB /)  
KB(:, 2,58, 4) = (/ &
 & 0.52442E-10_JPRB,0.30460E-07_JPRB,0.42955E-07_JPRB,0.45233E-07_JPRB,0.13047E-07_JPRB /)  
KB(:, 3,58, 4) = (/ &
 & 0.49962E-10_JPRB,0.34761E-07_JPRB,0.48418E-07_JPRB,0.51680E-07_JPRB,0.14431E-07_JPRB /)  
KB(:, 4,58, 4) = (/ &
 & 0.47826E-10_JPRB,0.39152E-07_JPRB,0.53626E-07_JPRB,0.57047E-07_JPRB,0.15934E-07_JPRB /)  
KB(:, 5,58, 4) = (/ &
 & 0.45954E-10_JPRB,0.43380E-07_JPRB,0.58786E-07_JPRB,0.62538E-07_JPRB,0.17511E-07_JPRB /)  
KB(:, 1,59, 4) = (/ &
 & 0.45740E-10_JPRB,0.21248E-07_JPRB,0.30261E-07_JPRB,0.31577E-07_JPRB,0.94221E-08_JPRB /)  
KB(:, 2,59, 4) = (/ &
 & 0.43210E-10_JPRB,0.24730E-07_JPRB,0.34948E-07_JPRB,0.36722E-07_JPRB,0.10608E-07_JPRB /)  
KB(:, 3,59, 4) = (/ &
 & 0.41141E-10_JPRB,0.28288E-07_JPRB,0.39410E-07_JPRB,0.42052E-07_JPRB,0.11754E-07_JPRB /)  
KB(:, 4,59, 4) = (/ &
 & 0.39361E-10_JPRB,0.31904E-07_JPRB,0.43740E-07_JPRB,0.46527E-07_JPRB,0.12986E-07_JPRB /)  
KB(:, 5,59, 4) = (/ &
 & 0.37805E-10_JPRB,0.35442E-07_JPRB,0.48020E-07_JPRB,0.51083E-07_JPRB,0.14278E-07_JPRB /)  
KB(:, 1,13, 5) = (/ &
 & 0.79045E-05_JPRB,0.58512E-03_JPRB,0.80967E-03_JPRB,0.88578E-03_JPRB,0.34824E-03_JPRB /)  
KB(:, 2,13, 5) = (/ &
 & 0.92807E-05_JPRB,0.61818E-03_JPRB,0.86083E-03_JPRB,0.92437E-03_JPRB,0.37870E-03_JPRB /)  
KB(:, 3,13, 5) = (/ &
 & 0.10620E-04_JPRB,0.65025E-03_JPRB,0.90617E-03_JPRB,0.96290E-03_JPRB,0.40639E-03_JPRB /)  
KB(:, 4,13, 5) = (/ &
 & 0.11847E-04_JPRB,0.68086E-03_JPRB,0.94767E-03_JPRB,0.99815E-03_JPRB,0.43149E-03_JPRB /)  
KB(:, 5,13, 5) = (/ &
 & 0.12897E-04_JPRB,0.70941E-03_JPRB,0.98426E-03_JPRB,0.10296E-02_JPRB,0.45459E-03_JPRB /)  
KB(:, 1,14, 5) = (/ &
 & 0.65683E-05_JPRB,0.48798E-03_JPRB,0.67570E-03_JPRB,0.73755E-03_JPRB,0.29172E-03_JPRB /)  
KB(:, 2,14, 5) = (/ &
 & 0.76957E-05_JPRB,0.51555E-03_JPRB,0.71856E-03_JPRB,0.76978E-03_JPRB,0.31709E-03_JPRB /)  
KB(:, 3,14, 5) = (/ &
 & 0.87852E-05_JPRB,0.54243E-03_JPRB,0.75604E-03_JPRB,0.80142E-03_JPRB,0.34064E-03_JPRB /)  
KB(:, 4,14, 5) = (/ &
 & 0.97622E-05_JPRB,0.56817E-03_JPRB,0.79038E-03_JPRB,0.83091E-03_JPRB,0.36095E-03_JPRB /)  
KB(:, 5,14, 5) = (/ &
 & 0.10614E-04_JPRB,0.59208E-03_JPRB,0.82018E-03_JPRB,0.85691E-03_JPRB,0.38095E-03_JPRB /)  
KB(:, 1,15, 5) = (/ &
 & 0.54643E-05_JPRB,0.40660E-03_JPRB,0.56371E-03_JPRB,0.61286E-03_JPRB,0.24435E-03_JPRB /)  
KB(:, 2,15, 5) = (/ &
 & 0.63883E-05_JPRB,0.42973E-03_JPRB,0.59914E-03_JPRB,0.64093E-03_JPRB,0.26475E-03_JPRB /)  
KB(:, 3,15, 5) = (/ &
 & 0.72593E-05_JPRB,0.45218E-03_JPRB,0.63004E-03_JPRB,0.66659E-03_JPRB,0.28486E-03_JPRB /)  
KB(:, 4,15, 5) = (/ &
 & 0.80526E-05_JPRB,0.47373E-03_JPRB,0.65847E-03_JPRB,0.69128E-03_JPRB,0.30200E-03_JPRB /)  
KB(:, 5,15, 5) = (/ &
 & 0.87364E-05_JPRB,0.49393E-03_JPRB,0.68318E-03_JPRB,0.71321E-03_JPRB,0.31930E-03_JPRB /)  
KB(:, 1,16, 5) = (/ &
 & 0.45482E-05_JPRB,0.33872E-03_JPRB,0.47003E-03_JPRB,0.50920E-03_JPRB,0.20473E-03_JPRB /)  
KB(:, 2,16, 5) = (/ &
 & 0.52893E-05_JPRB,0.35785E-03_JPRB,0.49898E-03_JPRB,0.53306E-03_JPRB,0.22171E-03_JPRB /)  
KB(:, 3,16, 5) = (/ &
 & 0.59989E-05_JPRB,0.37673E-03_JPRB,0.52467E-03_JPRB,0.55461E-03_JPRB,0.23803E-03_JPRB /)  
KB(:, 4,16, 5) = (/ &
 & 0.66426E-05_JPRB,0.39470E-03_JPRB,0.54827E-03_JPRB,0.57515E-03_JPRB,0.25244E-03_JPRB /)  
KB(:, 5,16, 5) = (/ &
 & 0.71759E-05_JPRB,0.41193E-03_JPRB,0.56909E-03_JPRB,0.59361E-03_JPRB,0.26773E-03_JPRB /)  
KB(:, 1,17, 5) = (/ &
 & 0.37690E-05_JPRB,0.28177E-03_JPRB,0.39153E-03_JPRB,0.42265E-03_JPRB,0.17155E-03_JPRB /)  
KB(:, 2,17, 5) = (/ &
 & 0.43790E-05_JPRB,0.29778E-03_JPRB,0.41535E-03_JPRB,0.44288E-03_JPRB,0.18563E-03_JPRB /)  
KB(:, 3,17, 5) = (/ &
 & 0.49545E-05_JPRB,0.31371E-03_JPRB,0.43664E-03_JPRB,0.46090E-03_JPRB,0.19908E-03_JPRB /)  
KB(:, 4,17, 5) = (/ &
 & 0.54563E-05_JPRB,0.32886E-03_JPRB,0.45637E-03_JPRB,0.47854E-03_JPRB,0.21097E-03_JPRB /)  
KB(:, 5,17, 5) = (/ &
 & 0.58879E-05_JPRB,0.34359E-03_JPRB,0.47416E-03_JPRB,0.49387E-03_JPRB,0.22440E-03_JPRB /)  
KB(:, 1,18, 5) = (/ &
 & 0.31260E-05_JPRB,0.23432E-03_JPRB,0.32596E-03_JPRB,0.35082E-03_JPRB,0.14348E-03_JPRB /)  
KB(:, 2,18, 5) = (/ &
 & 0.36185E-05_JPRB,0.24786E-03_JPRB,0.34561E-03_JPRB,0.36765E-03_JPRB,0.15546E-03_JPRB /)  
KB(:, 3,18, 5) = (/ &
 & 0.40732E-05_JPRB,0.26120E-03_JPRB,0.36343E-03_JPRB,0.38325E-03_JPRB,0.16623E-03_JPRB /)  
KB(:, 4,18, 5) = (/ &
 & 0.44839E-05_JPRB,0.27403E-03_JPRB,0.37997E-03_JPRB,0.39811E-03_JPRB,0.17659E-03_JPRB /)  
KB(:, 5,18, 5) = (/ &
 & 0.48304E-05_JPRB,0.28674E-03_JPRB,0.39513E-03_JPRB,0.41114E-03_JPRB,0.18813E-03_JPRB /)  
KB(:, 1,19, 5) = (/ &
 & 0.25853E-05_JPRB,0.19483E-03_JPRB,0.27128E-03_JPRB,0.29126E-03_JPRB,0.11969E-03_JPRB /)  
KB(:, 2,19, 5) = (/ &
 & 0.29834E-05_JPRB,0.20623E-03_JPRB,0.28749E-03_JPRB,0.30541E-03_JPRB,0.12978E-03_JPRB /)  
KB(:, 3,19, 5) = (/ &
 & 0.33546E-05_JPRB,0.21750E-03_JPRB,0.30267E-03_JPRB,0.31871E-03_JPRB,0.13874E-03_JPRB /)  
KB(:, 4,19, 5) = (/ &
 & 0.36863E-05_JPRB,0.22842E-03_JPRB,0.31656E-03_JPRB,0.33115E-03_JPRB,0.14789E-03_JPRB /)  
KB(:, 5,19, 5) = (/ &
 & 0.39634E-05_JPRB,0.23942E-03_JPRB,0.32944E-03_JPRB,0.34220E-03_JPRB,0.15742E-03_JPRB /)  
KB(:, 1,20, 5) = (/ &
 & 0.21486E-05_JPRB,0.16221E-03_JPRB,0.22609E-03_JPRB,0.24236E-03_JPRB,0.10014E-03_JPRB /)  
KB(:, 2,20, 5) = (/ &
 & 0.24735E-05_JPRB,0.17178E-03_JPRB,0.23949E-03_JPRB,0.25399E-03_JPRB,0.10857E-03_JPRB /)  
KB(:, 3,20, 5) = (/ &
 & 0.27744E-05_JPRB,0.18136E-03_JPRB,0.25226E-03_JPRB,0.26535E-03_JPRB,0.11604E-03_JPRB /)  
KB(:, 4,20, 5) = (/ &
 & 0.30414E-05_JPRB,0.19076E-03_JPRB,0.26397E-03_JPRB,0.27566E-03_JPRB,0.12398E-03_JPRB /)  
KB(:, 5,20, 5) = (/ &
 & 0.32610E-05_JPRB,0.20019E-03_JPRB,0.27488E-03_JPRB,0.28510E-03_JPRB,0.13199E-03_JPRB /)  
KB(:, 1,21, 5) = (/ &
 & 0.17877E-05_JPRB,0.13507E-03_JPRB,0.18845E-03_JPRB,0.20163E-03_JPRB,0.83879E-04_JPRB /)  
KB(:, 2,21, 5) = (/ &
 & 0.20518E-05_JPRB,0.14319E-03_JPRB,0.19968E-03_JPRB,0.21134E-03_JPRB,0.90858E-04_JPRB /)  
KB(:, 3,21, 5) = (/ &
 & 0.22953E-05_JPRB,0.15137E-03_JPRB,0.21038E-03_JPRB,0.22094E-03_JPRB,0.97098E-04_JPRB /)  
KB(:, 4,21, 5) = (/ &
 & 0.25098E-05_JPRB,0.15947E-03_JPRB,0.22019E-03_JPRB,0.22948E-03_JPRB,0.10402E-03_JPRB /)  
KB(:, 5,21, 5) = (/ &
 & 0.26830E-05_JPRB,0.16749E-03_JPRB,0.22950E-03_JPRB,0.23761E-03_JPRB,0.11069E-03_JPRB /)  
KB(:, 1,22, 5) = (/ &
 & 0.15022E-05_JPRB,0.11297E-03_JPRB,0.15773E-03_JPRB,0.16819E-03_JPRB,0.70808E-04_JPRB /)  
KB(:, 2,22, 5) = (/ &
 & 0.17157E-05_JPRB,0.11998E-03_JPRB,0.16714E-03_JPRB,0.17644E-03_JPRB,0.76345E-04_JPRB /)  
KB(:, 3,22, 5) = (/ &
 & 0.19111E-05_JPRB,0.12690E-03_JPRB,0.17611E-03_JPRB,0.18454E-03_JPRB,0.81804E-04_JPRB /)  
KB(:, 4,22, 5) = (/ &
 & 0.20812E-05_JPRB,0.13385E-03_JPRB,0.18425E-03_JPRB,0.19164E-03_JPRB,0.87591E-04_JPRB /)  
KB(:, 5,22, 5) = (/ &
 & 0.22144E-05_JPRB,0.14066E-03_JPRB,0.19235E-03_JPRB,0.19867E-03_JPRB,0.93228E-04_JPRB /)  
KB(:, 1,23, 5) = (/ &
 & 0.12621E-05_JPRB,0.94681E-04_JPRB,0.13210E-03_JPRB,0.14032E-03_JPRB,0.59630E-04_JPRB /)  
KB(:, 2,23, 5) = (/ &
 & 0.14346E-05_JPRB,0.10061E-03_JPRB,0.14009E-03_JPRB,0.14751E-03_JPRB,0.64142E-04_JPRB /)  
KB(:, 3,23, 5) = (/ &
 & 0.15908E-05_JPRB,0.10655E-03_JPRB,0.14749E-03_JPRB,0.15413E-03_JPRB,0.68988E-04_JPRB /)  
KB(:, 4,23, 5) = (/ &
 & 0.17253E-05_JPRB,0.11246E-03_JPRB,0.15437E-03_JPRB,0.16013E-03_JPRB,0.73893E-04_JPRB /)  
KB(:, 5,23, 5) = (/ &
 & 0.18272E-05_JPRB,0.11825E-03_JPRB,0.16130E-03_JPRB,0.16627E-03_JPRB,0.78649E-04_JPRB /)  
KB(:, 1,24, 5) = (/ &
 & 0.10611E-05_JPRB,0.79419E-04_JPRB,0.11079E-03_JPRB,0.11736E-03_JPRB,0.50244E-04_JPRB /)  
KB(:, 2,24, 5) = (/ &
 & 0.11996E-05_JPRB,0.84486E-04_JPRB,0.11749E-03_JPRB,0.12345E-03_JPRB,0.54054E-04_JPRB /)  
KB(:, 3,24, 5) = (/ &
 & 0.13241E-05_JPRB,0.89565E-04_JPRB,0.12364E-03_JPRB,0.12883E-03_JPRB,0.58259E-04_JPRB /)  
KB(:, 4,24, 5) = (/ &
 & 0.14300E-05_JPRB,0.94592E-04_JPRB,0.12949E-03_JPRB,0.13406E-03_JPRB,0.62300E-04_JPRB /)  
KB(:, 5,24, 5) = (/ &
 & 0.15070E-05_JPRB,0.99545E-04_JPRB,0.13538E-03_JPRB,0.13928E-03_JPRB,0.66485E-04_JPRB /)  
KB(:, 1,25, 5) = (/ &
 & 0.89248E-06_JPRB,0.66757E-04_JPRB,0.93043E-04_JPRB,0.98269E-04_JPRB,0.42396E-04_JPRB /)  
KB(:, 2,25, 5) = (/ &
 & 0.10034E-05_JPRB,0.71082E-04_JPRB,0.98652E-04_JPRB,0.10332E-03_JPRB,0.45719E-04_JPRB /)  
KB(:, 3,25, 5) = (/ &
 & 0.11024E-05_JPRB,0.75404E-04_JPRB,0.10375E-03_JPRB,0.10782E-03_JPRB,0.49228E-04_JPRB /)  
KB(:, 4,25, 5) = (/ &
 & 0.11835E-05_JPRB,0.79694E-04_JPRB,0.10882E-03_JPRB,0.11234E-03_JPRB,0.52649E-04_JPRB /)  
KB(:, 5,25, 5) = (/ &
 & 0.12406E-05_JPRB,0.83915E-04_JPRB,0.11376E-03_JPRB,0.11677E-03_JPRB,0.56264E-04_JPRB /)  
KB(:, 1,26, 5) = (/ &
 & 0.75147E-06_JPRB,0.56248E-04_JPRB,0.78291E-04_JPRB,0.82441E-04_JPRB,0.35781E-04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART18',1,ZHOOK_HANDLE)
END SUBROUTINE PART18


SUBROUTINE PART19

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART19',0,ZHOOK_HANDLE)


KB(:, 2,26, 5) = (/ &
 & 0.84025E-06_JPRB,0.59929E-04_JPRB,0.82917E-04_JPRB,0.86562E-04_JPRB,0.38715E-04_JPRB /)  
KB(:, 3,26, 5) = (/ &
 & 0.91728E-06_JPRB,0.63618E-04_JPRB,0.87231E-04_JPRB,0.90442E-04_JPRB,0.41682E-04_JPRB /)  
KB(:, 4,26, 5) = (/ &
 & 0.97947E-06_JPRB,0.67285E-04_JPRB,0.91606E-04_JPRB,0.94311E-04_JPRB,0.44610E-04_JPRB /)  
KB(:, 5,26, 5) = (/ &
 & 0.10222E-05_JPRB,0.70879E-04_JPRB,0.95759E-04_JPRB,0.97954E-04_JPRB,0.47678E-04_JPRB /)  
KB(:, 1,27, 5) = (/ &
 & 0.63228E-06_JPRB,0.47448E-04_JPRB,0.65926E-04_JPRB,0.69211E-04_JPRB,0.30312E-04_JPRB /)  
KB(:, 2,27, 5) = (/ &
 & 0.70187E-06_JPRB,0.50583E-04_JPRB,0.69752E-04_JPRB,0.72622E-04_JPRB,0.32844E-04_JPRB /)  
KB(:, 3,27, 5) = (/ &
 & 0.76263E-06_JPRB,0.53723E-04_JPRB,0.73431E-04_JPRB,0.75943E-04_JPRB,0.35283E-04_JPRB /)  
KB(:, 4,27, 5) = (/ &
 & 0.80975E-06_JPRB,0.56884E-04_JPRB,0.77139E-04_JPRB,0.79235E-04_JPRB,0.37837E-04_JPRB /)  
KB(:, 5,27, 5) = (/ &
 & 0.84099E-06_JPRB,0.59937E-04_JPRB,0.80670E-04_JPRB,0.82198E-04_JPRB,0.40398E-04_JPRB /)  
KB(:, 1,28, 5) = (/ &
 & 0.53062E-06_JPRB,0.40054E-04_JPRB,0.55536E-04_JPRB,0.58105E-04_JPRB,0.25683E-04_JPRB /)  
KB(:, 2,28, 5) = (/ &
 & 0.58581E-06_JPRB,0.42748E-04_JPRB,0.58719E-04_JPRB,0.60988E-04_JPRB,0.27829E-04_JPRB /)  
KB(:, 3,28, 5) = (/ &
 & 0.63283E-06_JPRB,0.45445E-04_JPRB,0.61927E-04_JPRB,0.63808E-04_JPRB,0.29914E-04_JPRB /)  
KB(:, 4,28, 5) = (/ &
 & 0.66841E-06_JPRB,0.48141E-04_JPRB,0.65033E-04_JPRB,0.66567E-04_JPRB,0.32101E-04_JPRB /)  
KB(:, 5,28, 5) = (/ &
 & 0.69132E-06_JPRB,0.50744E-04_JPRB,0.68002E-04_JPRB,0.69024E-04_JPRB,0.34196E-04_JPRB /)  
KB(:, 1,29, 5) = (/ &
 & 0.44482E-06_JPRB,0.33876E-04_JPRB,0.46813E-04_JPRB,0.48820E-04_JPRB,0.21822E-04_JPRB /)  
KB(:, 2,29, 5) = (/ &
 & 0.48830E-06_JPRB,0.36173E-04_JPRB,0.49534E-04_JPRB,0.51267E-04_JPRB,0.23598E-04_JPRB /)  
KB(:, 3,29, 5) = (/ &
 & 0.52520E-06_JPRB,0.38507E-04_JPRB,0.52264E-04_JPRB,0.53700E-04_JPRB,0.25407E-04_JPRB /)  
KB(:, 4,29, 5) = (/ &
 & 0.55142E-06_JPRB,0.40790E-04_JPRB,0.54879E-04_JPRB,0.55934E-04_JPRB,0.27233E-04_JPRB /)  
KB(:, 5,29, 5) = (/ &
 & 0.56821E-06_JPRB,0.43005E-04_JPRB,0.57374E-04_JPRB,0.57995E-04_JPRB,0.28939E-04_JPRB /)  
KB(:, 1,30, 5) = (/ &
 & 0.37240E-06_JPRB,0.28688E-04_JPRB,0.39498E-04_JPRB,0.41082E-04_JPRB,0.18542E-04_JPRB /)  
KB(:, 2,30, 5) = (/ &
 & 0.40697E-06_JPRB,0.30662E-04_JPRB,0.41832E-04_JPRB,0.43139E-04_JPRB,0.20037E-04_JPRB /)  
KB(:, 3,30, 5) = (/ &
 & 0.43518E-06_JPRB,0.32657E-04_JPRB,0.44137E-04_JPRB,0.45198E-04_JPRB,0.21592E-04_JPRB /)  
KB(:, 4,30, 5) = (/ &
 & 0.45459E-06_JPRB,0.34600E-04_JPRB,0.46342E-04_JPRB,0.47030E-04_JPRB,0.23099E-04_JPRB /)  
KB(:, 5,30, 5) = (/ &
 & 0.46674E-06_JPRB,0.36468E-04_JPRB,0.48427E-04_JPRB,0.48752E-04_JPRB,0.24524E-04_JPRB /)  
KB(:, 1,31, 5) = (/ &
 & 0.31167E-06_JPRB,0.24328E-04_JPRB,0.33365E-04_JPRB,0.34577E-04_JPRB,0.15775E-04_JPRB /)  
KB(:, 2,31, 5) = (/ &
 & 0.33880E-06_JPRB,0.26033E-04_JPRB,0.35376E-04_JPRB,0.36343E-04_JPRB,0.17037E-04_JPRB /)  
KB(:, 3,31, 5) = (/ &
 & 0.36022E-06_JPRB,0.27728E-04_JPRB,0.37306E-04_JPRB,0.38025E-04_JPRB,0.18334E-04_JPRB /)  
KB(:, 4,31, 5) = (/ &
 & 0.37443E-06_JPRB,0.29381E-04_JPRB,0.39153E-04_JPRB,0.39551E-04_JPRB,0.19559E-04_JPRB /)  
KB(:, 5,31, 5) = (/ &
 & 0.38304E-06_JPRB,0.30940E-04_JPRB,0.40888E-04_JPRB,0.41012E-04_JPRB,0.20735E-04_JPRB /)  
KB(:, 1,32, 5) = (/ &
 & 0.26065E-06_JPRB,0.20666E-04_JPRB,0.28226E-04_JPRB,0.29128E-04_JPRB,0.13403E-04_JPRB /)  
KB(:, 2,32, 5) = (/ &
 & 0.28179E-06_JPRB,0.22130E-04_JPRB,0.29934E-04_JPRB,0.30642E-04_JPRB,0.14495E-04_JPRB /)  
KB(:, 3,32, 5) = (/ &
 & 0.29791E-06_JPRB,0.23572E-04_JPRB,0.31554E-04_JPRB,0.32005E-04_JPRB,0.15576E-04_JPRB /)  
KB(:, 4,32, 5) = (/ &
 & 0.30813E-06_JPRB,0.24963E-04_JPRB,0.33101E-04_JPRB,0.33278E-04_JPRB,0.16582E-04_JPRB /)  
KB(:, 5,32, 5) = (/ &
 & 0.31412E-06_JPRB,0.26261E-04_JPRB,0.34510E-04_JPRB,0.34497E-04_JPRB,0.17533E-04_JPRB /)  
KB(:, 1,33, 5) = (/ &
 & 0.21768E-06_JPRB,0.17581E-04_JPRB,0.23903E-04_JPRB,0.24558E-04_JPRB,0.11405E-04_JPRB /)  
KB(:, 2,33, 5) = (/ &
 & 0.23409E-06_JPRB,0.18827E-04_JPRB,0.25333E-04_JPRB,0.25812E-04_JPRB,0.12331E-04_JPRB /)  
KB(:, 3,33, 5) = (/ &
 & 0.24596E-06_JPRB,0.20053E-04_JPRB,0.26696E-04_JPRB,0.26942E-04_JPRB,0.13200E-04_JPRB /)  
KB(:, 4,33, 5) = (/ &
 & 0.25338E-06_JPRB,0.21211E-04_JPRB,0.27978E-04_JPRB,0.28012E-04_JPRB,0.14037E-04_JPRB /)  
KB(:, 5,33, 5) = (/ &
 & 0.25735E-06_JPRB,0.22292E-04_JPRB,0.29113E-04_JPRB,0.29019E-04_JPRB,0.14789E-04_JPRB /)  
KB(:, 1,34, 5) = (/ &
 & 0.18111E-06_JPRB,0.14933E-04_JPRB,0.20221E-04_JPRB,0.20691E-04_JPRB,0.96853E-05_JPRB /)  
KB(:, 2,34, 5) = (/ &
 & 0.19373E-06_JPRB,0.15993E-04_JPRB,0.21413E-04_JPRB,0.21708E-04_JPRB,0.10459E-04_JPRB /)  
KB(:, 3,34, 5) = (/ &
 & 0.20262E-06_JPRB,0.17025E-04_JPRB,0.22551E-04_JPRB,0.22651E-04_JPRB,0.11170E-04_JPRB /)  
KB(:, 4,34, 5) = (/ &
 & 0.20802E-06_JPRB,0.17992E-04_JPRB,0.23603E-04_JPRB,0.23540E-04_JPRB,0.11847E-04_JPRB /)  
KB(:, 5,34, 5) = (/ &
 & 0.21068E-06_JPRB,0.18892E-04_JPRB,0.24522E-04_JPRB,0.24370E-04_JPRB,0.12444E-04_JPRB /)  
KB(:, 1,35, 5) = (/ &
 & 0.14940E-06_JPRB,0.12604E-04_JPRB,0.17001E-04_JPRB,0.17339E-04_JPRB,0.81630E-05_JPRB /)  
KB(:, 2,35, 5) = (/ &
 & 0.15934E-06_JPRB,0.13505E-04_JPRB,0.18008E-04_JPRB,0.18183E-04_JPRB,0.87890E-05_JPRB /)  
KB(:, 3,35, 5) = (/ &
 & 0.16626E-06_JPRB,0.14374E-04_JPRB,0.18963E-04_JPRB,0.18976E-04_JPRB,0.93838E-05_JPRB /)  
KB(:, 4,35, 5) = (/ &
 & 0.17040E-06_JPRB,0.15187E-04_JPRB,0.19824E-04_JPRB,0.19720E-04_JPRB,0.99229E-05_JPRB /)  
KB(:, 5,35, 5) = (/ &
 & 0.17229E-06_JPRB,0.15939E-04_JPRB,0.20582E-04_JPRB,0.20394E-04_JPRB,0.10412E-04_JPRB /)  
KB(:, 1,36, 5) = (/ &
 & 0.12224E-06_JPRB,0.10560E-04_JPRB,0.14203E-04_JPRB,0.14447E-04_JPRB,0.68196E-05_JPRB /)  
KB(:, 2,36, 5) = (/ &
 & 0.13030E-06_JPRB,0.11326E-04_JPRB,0.15055E-04_JPRB,0.15156E-04_JPRB,0.73321E-05_JPRB /)  
KB(:, 3,36, 5) = (/ &
 & 0.13590E-06_JPRB,0.12062E-04_JPRB,0.15856E-04_JPRB,0.15823E-04_JPRB,0.78230E-05_JPRB /)  
KB(:, 4,36, 5) = (/ &
 & 0.13929E-06_JPRB,0.12750E-04_JPRB,0.16573E-04_JPRB,0.16449E-04_JPRB,0.82632E-05_JPRB /)  
KB(:, 5,36, 5) = (/ &
 & 0.14081E-06_JPRB,0.13384E-04_JPRB,0.17208E-04_JPRB,0.17006E-04_JPRB,0.86656E-05_JPRB /)  
KB(:, 1,37, 5) = (/ &
 & 0.98979E-07_JPRB,0.87500E-05_JPRB,0.11755E-04_JPRB,0.11943E-04_JPRB,0.56269E-05_JPRB /)  
KB(:, 2,37, 5) = (/ &
 & 0.10583E-06_JPRB,0.94035E-05_JPRB,0.12480E-04_JPRB,0.12544E-04_JPRB,0.60528E-05_JPRB /)  
KB(:, 3,37, 5) = (/ &
 & 0.11068E-06_JPRB,0.10031E-04_JPRB,0.13161E-04_JPRB,0.13110E-04_JPRB,0.64604E-05_JPRB /)  
KB(:, 4,37, 5) = (/ &
 & 0.11365E-06_JPRB,0.10619E-04_JPRB,0.13767E-04_JPRB,0.13642E-04_JPRB,0.68253E-05_JPRB /)  
KB(:, 5,37, 5) = (/ &
 & 0.11510E-06_JPRB,0.11162E-04_JPRB,0.14306E-04_JPRB,0.14108E-04_JPRB,0.71615E-05_JPRB /)  
KB(:, 1,38, 5) = (/ &
 & 0.80050E-07_JPRB,0.72436E-05_JPRB,0.97225E-05_JPRB,0.98657E-05_JPRB,0.46375E-05_JPRB /)  
KB(:, 2,38, 5) = (/ &
 & 0.85886E-07_JPRB,0.78006E-05_JPRB,0.10338E-04_JPRB,0.10378E-04_JPRB,0.49919E-05_JPRB /)  
KB(:, 3,38, 5) = (/ &
 & 0.90108E-07_JPRB,0.83355E-05_JPRB,0.10916E-04_JPRB,0.10856E-04_JPRB,0.53303E-05_JPRB /)  
KB(:, 4,38, 5) = (/ &
 & 0.92690E-07_JPRB,0.88380E-05_JPRB,0.11429E-04_JPRB,0.11306E-04_JPRB,0.56349E-05_JPRB /)  
KB(:, 5,38, 5) = (/ &
 & 0.94046E-07_JPRB,0.93019E-05_JPRB,0.11885E-04_JPRB,0.11696E-04_JPRB,0.59152E-05_JPRB /)  
KB(:, 1,39, 5) = (/ &
 & 0.64720E-07_JPRB,0.59955E-05_JPRB,0.80389E-05_JPRB,0.81488E-05_JPRB,0.38192E-05_JPRB /)  
KB(:, 2,39, 5) = (/ &
 & 0.69663E-07_JPRB,0.64699E-05_JPRB,0.85613E-05_JPRB,0.85818E-05_JPRB,0.41159E-05_JPRB /)  
KB(:, 3,39, 5) = (/ &
 & 0.73305E-07_JPRB,0.69246E-05_JPRB,0.90506E-05_JPRB,0.89861E-05_JPRB,0.43968E-05_JPRB /)  
KB(:, 4,39, 5) = (/ &
 & 0.75588E-07_JPRB,0.73530E-05_JPRB,0.94857E-05_JPRB,0.93637E-05_JPRB,0.46505E-05_JPRB /)  
KB(:, 5,39, 5) = (/ &
 & 0.76825E-07_JPRB,0.77492E-05_JPRB,0.98708E-05_JPRB,0.96898E-05_JPRB,0.48841E-05_JPRB /)  
KB(:, 1,40, 5) = (/ &
 & 0.51871E-07_JPRB,0.49191E-05_JPRB,0.65994E-05_JPRB,0.66890E-05_JPRB,0.31186E-05_JPRB /)  
KB(:, 2,40, 5) = (/ &
 & 0.56127E-07_JPRB,0.53227E-05_JPRB,0.70435E-05_JPRB,0.70578E-05_JPRB,0.33678E-05_JPRB /)  
KB(:, 3,40, 5) = (/ &
 & 0.59395E-07_JPRB,0.57124E-05_JPRB,0.74609E-05_JPRB,0.74018E-05_JPRB,0.36025E-05_JPRB /)  
KB(:, 4,40, 5) = (/ &
 & 0.61501E-07_JPRB,0.60790E-05_JPRB,0.78333E-05_JPRB,0.77210E-05_JPRB,0.38164E-05_JPRB /)  
KB(:, 5,40, 5) = (/ &
 & 0.62710E-07_JPRB,0.64194E-05_JPRB,0.81613E-05_JPRB,0.79980E-05_JPRB,0.40122E-05_JPRB /)  
KB(:, 1,41, 5) = (/ &
 & 0.41471E-07_JPRB,0.40276E-05_JPRB,0.54076E-05_JPRB,0.54815E-05_JPRB,0.25402E-05_JPRB /)  
KB(:, 2,41, 5) = (/ &
 & 0.45127E-07_JPRB,0.43711E-05_JPRB,0.57847E-05_JPRB,0.57971E-05_JPRB,0.27507E-05_JPRB /)  
KB(:, 3,41, 5) = (/ &
 & 0.48018E-07_JPRB,0.47040E-05_JPRB,0.61407E-05_JPRB,0.60883E-05_JPRB,0.29479E-05_JPRB /)  
KB(:, 4,41, 5) = (/ &
 & 0.49983E-07_JPRB,0.50177E-05_JPRB,0.64595E-05_JPRB,0.63587E-05_JPRB,0.31286E-05_JPRB /)  
KB(:, 5,41, 5) = (/ &
 & 0.51153E-07_JPRB,0.53098E-05_JPRB,0.67389E-05_JPRB,0.65950E-05_JPRB,0.32928E-05_JPRB /)  
KB(:, 1,42, 5) = (/ &
 & 0.33108E-07_JPRB,0.32945E-05_JPRB,0.44261E-05_JPRB,0.44871E-05_JPRB,0.20674E-05_JPRB /)  
KB(:, 2,42, 5) = (/ &
 & 0.36228E-07_JPRB,0.35861E-05_JPRB,0.47462E-05_JPRB,0.47571E-05_JPRB,0.22452E-05_JPRB /)  
KB(:, 3,42, 5) = (/ &
 & 0.38776E-07_JPRB,0.38701E-05_JPRB,0.50505E-05_JPRB,0.50046E-05_JPRB,0.24106E-05_JPRB /)  
KB(:, 4,42, 5) = (/ &
 & 0.40580E-07_JPRB,0.41378E-05_JPRB,0.53219E-05_JPRB,0.52323E-05_JPRB,0.25622E-05_JPRB /)  
KB(:, 5,42, 5) = (/ &
 & 0.41689E-07_JPRB,0.43881E-05_JPRB,0.55607E-05_JPRB,0.54356E-05_JPRB,0.27015E-05_JPRB /)  
KB(:, 1,43, 5) = (/ &
 & 0.26243E-07_JPRB,0.26780E-05_JPRB,0.36021E-05_JPRB,0.36578E-05_JPRB,0.16722E-05_JPRB /)  
KB(:, 2,43, 5) = (/ &
 & 0.28903E-07_JPRB,0.29254E-05_JPRB,0.38754E-05_JPRB,0.38886E-05_JPRB,0.18235E-05_JPRB /)  
KB(:, 3,43, 5) = (/ &
 & 0.31158E-07_JPRB,0.31674E-05_JPRB,0.41363E-05_JPRB,0.40998E-05_JPRB,0.19628E-05_JPRB /)  
KB(:, 4,43, 5) = (/ &
 & 0.32828E-07_JPRB,0.33966E-05_JPRB,0.43687E-05_JPRB,0.42935E-05_JPRB,0.20906E-05_JPRB /)  
KB(:, 5,43, 5) = (/ &
 & 0.33896E-07_JPRB,0.36112E-05_JPRB,0.45745E-05_JPRB,0.44680E-05_JPRB,0.22088E-05_JPRB /)  
KB(:, 1,44, 5) = (/ &
 & 0.20692E-07_JPRB,0.21688E-05_JPRB,0.29226E-05_JPRB,0.29738E-05_JPRB,0.13486E-05_JPRB /)  
KB(:, 2,44, 5) = (/ &
 & 0.22961E-07_JPRB,0.23776E-05_JPRB,0.31556E-05_JPRB,0.31699E-05_JPRB,0.14759E-05_JPRB /)  
KB(:, 3,44, 5) = (/ &
 & 0.24934E-07_JPRB,0.25834E-05_JPRB,0.33779E-05_JPRB,0.33507E-05_JPRB,0.15926E-05_JPRB /)  
KB(:, 4,44, 5) = (/ &
 & 0.26472E-07_JPRB,0.27800E-05_JPRB,0.35779E-05_JPRB,0.35162E-05_JPRB,0.17017E-05_JPRB /)  
KB(:, 5,44, 5) = (/ &
 & 0.27504E-07_JPRB,0.29637E-05_JPRB,0.37558E-05_JPRB,0.36666E-05_JPRB,0.18017E-05_JPRB /)  
KB(:, 1,45, 5) = (/ &
 & 0.16269E-07_JPRB,0.17537E-05_JPRB,0.23672E-05_JPRB,0.24133E-05_JPRB,0.10856E-05_JPRB /)  
KB(:, 2,45, 5) = (/ &
 & 0.18194E-07_JPRB,0.19291E-05_JPRB,0.25663E-05_JPRB,0.25809E-05_JPRB,0.11927E-05_JPRB /)  
KB(:, 3,45, 5) = (/ &
 & 0.19903E-07_JPRB,0.21039E-05_JPRB,0.27552E-05_JPRB,0.27360E-05_JPRB,0.12909E-05_JPRB /)  
KB(:, 4,45, 5) = (/ &
 & 0.21293E-07_JPRB,0.22721E-05_JPRB,0.29270E-05_JPRB,0.28775E-05_JPRB,0.13839E-05_JPRB /)  
KB(:, 5,45, 5) = (/ &
 & 0.22283E-07_JPRB,0.24292E-05_JPRB,0.30802E-05_JPRB,0.30067E-05_JPRB,0.14686E-05_JPRB /)  
KB(:, 1,46, 5) = (/ &
 & 0.12712E-07_JPRB,0.14128E-05_JPRB,0.19113E-05_JPRB,0.19548E-05_JPRB,0.87114E-06_JPRB /)  
KB(:, 2,46, 5) = (/ &
 & 0.14351E-07_JPRB,0.15596E-05_JPRB,0.20802E-05_JPRB,0.20949E-05_JPRB,0.96118E-06_JPRB /)  
KB(:, 3,46, 5) = (/ &
 & 0.15815E-07_JPRB,0.17076E-05_JPRB,0.22404E-05_JPRB,0.22289E-05_JPRB,0.10436E-05_JPRB /)  
KB(:, 4,46, 5) = (/ &
 & 0.17062E-07_JPRB,0.18511E-05_JPRB,0.23889E-05_JPRB,0.23492E-05_JPRB,0.11225E-05_JPRB /)  
KB(:, 5,46, 5) = (/ &
 & 0.17993E-07_JPRB,0.19855E-05_JPRB,0.25206E-05_JPRB,0.24609E-05_JPRB,0.11948E-05_JPRB /)  
KB(:, 1,47, 5) = (/ &
 & 0.98364E-08_JPRB,0.11306E-05_JPRB,0.15353E-05_JPRB,0.15746E-05_JPRB,0.69554E-06_JPRB /)  
KB(:, 2,47, 5) = (/ &
 & 0.11226E-07_JPRB,0.12534E-05_JPRB,0.16765E-05_JPRB,0.16944E-05_JPRB,0.76925E-06_JPRB /)  
KB(:, 3,47, 5) = (/ &
 & 0.12483E-07_JPRB,0.13784E-05_JPRB,0.18130E-05_JPRB,0.18087E-05_JPRB,0.84036E-06_JPRB /)  
KB(:, 4,47, 5) = (/ &
 & 0.13587E-07_JPRB,0.15007E-05_JPRB,0.19418E-05_JPRB,0.19122E-05_JPRB,0.90712E-06_JPRB /)  
KB(:, 5,47, 5) = (/ &
 & 0.14457E-07_JPRB,0.16158E-05_JPRB,0.20557E-05_JPRB,0.20073E-05_JPRB,0.96847E-06_JPRB /)  
KB(:, 1,48, 5) = (/ &
 & 0.75824E-08_JPRB,0.90329E-06_JPRB,0.12307E-05_JPRB,0.12653E-05_JPRB,0.55346E-06_JPRB /)  
KB(:, 2,48, 5) = (/ &
 & 0.87453E-08_JPRB,0.10050E-05_JPRB,0.13490E-05_JPRB,0.13676E-05_JPRB,0.61470E-06_JPRB /)  
KB(:, 3,48, 5) = (/ &
 & 0.98194E-08_JPRB,0.11101E-05_JPRB,0.14650E-05_JPRB,0.14651E-05_JPRB,0.67492E-06_JPRB /)  
KB(:, 4,48, 5) = (/ &
 & 0.10779E-07_JPRB,0.12141E-05_JPRB,0.15756E-05_JPRB,0.15544E-05_JPRB,0.73163E-06_JPRB /)  
KB(:, 5,48, 5) = (/ &
 & 0.11579E-07_JPRB,0.13125E-05_JPRB,0.16743E-05_JPRB,0.16359E-05_JPRB,0.78405E-06_JPRB /)  
KB(:, 1,49, 5) = (/ &
 & 0.58219E-08_JPRB,0.72015E-06_JPRB,0.98379E-06_JPRB,0.10143E-05_JPRB,0.43933E-06_JPRB /)  
KB(:, 2,49, 5) = (/ &
 & 0.67817E-08_JPRB,0.80423E-06_JPRB,0.10832E-05_JPRB,0.11023E-05_JPRB,0.49018E-06_JPRB /)  
KB(:, 3,49, 5) = (/ &
 & 0.76966E-08_JPRB,0.89205E-06_JPRB,0.11819E-05_JPRB,0.11846E-05_JPRB,0.54131E-06_JPRB /)  
KB(:, 4,49, 5) = (/ &
 & 0.85224E-08_JPRB,0.98005E-06_JPRB,0.12760E-05_JPRB,0.12617E-05_JPRB,0.58858E-06_JPRB /)  
KB(:, 5,49, 5) = (/ &
 & 0.92350E-08_JPRB,0.10644E-05_JPRB,0.13615E-05_JPRB,0.13319E-05_JPRB,0.63358E-06_JPRB /)  
KB(:, 1,50, 5) = (/ &
 & 0.44790E-08_JPRB,0.57418E-06_JPRB,0.78635E-06_JPRB,0.81296E-06_JPRB,0.34881E-06_JPRB /)  
KB(:, 2,50, 5) = (/ &
 & 0.52579E-08_JPRB,0.64388E-06_JPRB,0.87056E-06_JPRB,0.88896E-06_JPRB,0.39135E-06_JPRB /)  
KB(:, 3,50, 5) = (/ &
 & 0.60279E-08_JPRB,0.71722E-06_JPRB,0.95348E-06_JPRB,0.95809E-06_JPRB,0.43444E-06_JPRB /)  
KB(:, 4,50, 5) = (/ &
 & 0.67324E-08_JPRB,0.79134E-06_JPRB,0.10331E-05_JPRB,0.10243E-05_JPRB,0.47391E-06_JPRB /)  
KB(:, 5,50, 5) = (/ &
 & 0.73551E-08_JPRB,0.86330E-06_JPRB,0.11073E-05_JPRB,0.10842E-05_JPRB,0.51234E-06_JPRB /)  
KB(:, 1,51, 5) = (/ &
 & 0.34450E-08_JPRB,0.45753E-06_JPRB,0.62814E-06_JPRB,0.65158E-06_JPRB,0.27625E-06_JPRB /)  
KB(:, 2,51, 5) = (/ &
 & 0.40690E-08_JPRB,0.51530E-06_JPRB,0.69892E-06_JPRB,0.71555E-06_JPRB,0.31260E-06_JPRB /)  
KB(:, 3,51, 5) = (/ &
 & 0.47087E-08_JPRB,0.57624E-06_JPRB,0.76840E-06_JPRB,0.77477E-06_JPRB,0.34804E-06_JPRB /)  
KB(:, 4,51, 5) = (/ &
 & 0.53086E-08_JPRB,0.63843E-06_JPRB,0.83580E-06_JPRB,0.83092E-06_JPRB,0.38181E-06_JPRB /)  
KB(:, 5,51, 5) = (/ &
 & 0.58439E-08_JPRB,0.69956E-06_JPRB,0.89962E-06_JPRB,0.88225E-06_JPRB,0.41412E-06_JPRB /)  
KB(:, 1,52, 5) = (/ &
 & 0.26454E-08_JPRB,0.36387E-06_JPRB,0.50007E-06_JPRB,0.52179E-06_JPRB,0.21894E-06_JPRB /)  
KB(:, 2,52, 5) = (/ &
 & 0.31403E-08_JPRB,0.41173E-06_JPRB,0.55997E-06_JPRB,0.57479E-06_JPRB,0.24870E-06_JPRB /)  
KB(:, 3,52, 5) = (/ &
 & 0.36655E-08_JPRB,0.46211E-06_JPRB,0.61819E-06_JPRB,0.62511E-06_JPRB,0.27840E-06_JPRB /)  
KB(:, 4,52, 5) = (/ &
 & 0.41730E-08_JPRB,0.51415E-06_JPRB,0.67546E-06_JPRB,0.67307E-06_JPRB,0.30695E-06_JPRB /)  
KB(:, 5,52, 5) = (/ &
 & 0.46311E-08_JPRB,0.56582E-06_JPRB,0.72973E-06_JPRB,0.71697E-06_JPRB,0.33407E-06_JPRB /)  
KB(:, 1,53, 5) = (/ &
 & 0.20275E-08_JPRB,0.28873E-06_JPRB,0.39749E-06_JPRB,0.41647E-06_JPRB,0.17355E-06_JPRB /)  
KB(:, 2,53, 5) = (/ &
 & 0.24190E-08_JPRB,0.32821E-06_JPRB,0.44730E-06_JPRB,0.46063E-06_JPRB,0.19774E-06_JPRB /)  
KB(:, 3,53, 5) = (/ &
 & 0.28440E-08_JPRB,0.36981E-06_JPRB,0.49677E-06_JPRB,0.50411E-06_JPRB,0.22218E-06_JPRB /)  
KB(:, 4,53, 5) = (/ &
 & 0.32690E-08_JPRB,0.41315E-06_JPRB,0.54488E-06_JPRB,0.54408E-06_JPRB,0.24647E-06_JPRB /)  
KB(:, 5,53, 5) = (/ &
 & 0.36592E-08_JPRB,0.45680E-06_JPRB,0.59090E-06_JPRB,0.58189E-06_JPRB,0.26902E-06_JPRB /)  
KB(:, 1,54, 5) = (/ &
 & 0.15611E-08_JPRB,0.22962E-06_JPRB,0.31613E-06_JPRB,0.33300E-06_JPRB,0.13730E-06_JPRB /)  
KB(:, 2,54, 5) = (/ &
 & 0.18696E-08_JPRB,0.26187E-06_JPRB,0.35802E-06_JPRB,0.36954E-06_JPRB,0.15701E-06_JPRB /)  
KB(:, 3,54, 5) = (/ &
 & 0.22100E-08_JPRB,0.29641E-06_JPRB,0.39970E-06_JPRB,0.40683E-06_JPRB,0.17764E-06_JPRB /)  
KB(:, 4,54, 5) = (/ &
 & 0.25619E-08_JPRB,0.33255E-06_JPRB,0.44009E-06_JPRB,0.44063E-06_JPRB,0.19808E-06_JPRB /)  
KB(:, 5,54, 5) = (/ &
 & 0.28928E-08_JPRB,0.36908E-06_JPRB,0.47892E-06_JPRB,0.47270E-06_JPRB,0.21696E-06_JPRB /)  
KB(:, 1,55, 5) = (/ &
 & 0.12041E-08_JPRB,0.18259E-06_JPRB,0.25108E-06_JPRB,0.26608E-06_JPRB,0.10842E-06_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART19',1,ZHOOK_HANDLE)
END SUBROUTINE PART19


SUBROUTINE PART20

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART20',0,ZHOOK_HANDLE)


KB(:, 2,55, 5) = (/ &
 & 0.14466E-08_JPRB,0.20918E-06_JPRB,0.28633E-06_JPRB,0.29677E-06_JPRB,0.12468E-06_JPRB /)  
KB(:, 3,55, 5) = (/ &
 & 0.17176E-08_JPRB,0.23765E-06_JPRB,0.32139E-06_JPRB,0.32799E-06_JPRB,0.14213E-06_JPRB /)  
KB(:, 4,55, 5) = (/ &
 & 0.20058E-08_JPRB,0.26766E-06_JPRB,0.35523E-06_JPRB,0.35664E-06_JPRB,0.15907E-06_JPRB /)  
KB(:, 5,55, 5) = (/ &
 & 0.22852E-08_JPRB,0.29818E-06_JPRB,0.38806E-06_JPRB,0.38381E-06_JPRB,0.17512E-06_JPRB /)  
KB(:, 1,56, 5) = (/ &
 & 0.92934E-09_JPRB,0.14496E-06_JPRB,0.19887E-06_JPRB,0.21215E-06_JPRB,0.85185E-07_JPRB /)  
KB(:, 2,56, 5) = (/ &
 & 0.11180E-08_JPRB,0.16668E-06_JPRB,0.22841E-06_JPRB,0.23799E-06_JPRB,0.99172E-07_JPRB /)  
KB(:, 3,56, 5) = (/ &
 & 0.13333E-08_JPRB,0.19024E-06_JPRB,0.25790E-06_JPRB,0.26385E-06_JPRB,0.11331E-06_JPRB /)  
KB(:, 4,56, 5) = (/ &
 & 0.15668E-08_JPRB,0.21512E-06_JPRB,0.28626E-06_JPRB,0.28820E-06_JPRB,0.12758E-06_JPRB /)  
KB(:, 5,56, 5) = (/ &
 & 0.18000E-08_JPRB,0.24055E-06_JPRB,0.31405E-06_JPRB,0.31134E-06_JPRB,0.14106E-06_JPRB /)  
KB(:, 1,57, 5) = (/ &
 & 0.71747E-09_JPRB,0.11491E-06_JPRB,0.15760E-06_JPRB,0.16907E-06_JPRB,0.66762E-07_JPRB /)  
KB(:, 2,57, 5) = (/ &
 & 0.86318E-09_JPRB,0.13266E-06_JPRB,0.18198E-06_JPRB,0.19051E-06_JPRB,0.78844E-07_JPRB /)  
KB(:, 3,57, 5) = (/ &
 & 0.10332E-08_JPRB,0.15199E-06_JPRB,0.20646E-06_JPRB,0.21185E-06_JPRB,0.90317E-07_JPRB /)  
KB(:, 4,57, 5) = (/ &
 & 0.12205E-08_JPRB,0.17255E-06_JPRB,0.23049E-06_JPRB,0.23280E-06_JPRB,0.10211E-06_JPRB /)  
KB(:, 5,57, 5) = (/ &
 & 0.14137E-08_JPRB,0.19374E-06_JPRB,0.25377E-06_JPRB,0.25209E-06_JPRB,0.11347E-06_JPRB /)  
KB(:, 1,58, 5) = (/ &
 & 0.55534E-09_JPRB,0.91161E-07_JPRB,0.12495E-06_JPRB,0.13481E-06_JPRB,0.52524E-07_JPRB /)  
KB(:, 2,58, 5) = (/ &
 & 0.66796E-09_JPRB,0.10564E-06_JPRB,0.14490E-06_JPRB,0.15246E-06_JPRB,0.62491E-07_JPRB /)  
KB(:, 3,58, 5) = (/ &
 & 0.80208E-09_JPRB,0.12142E-06_JPRB,0.16540E-06_JPRB,0.17013E-06_JPRB,0.71923E-07_JPRB /)  
KB(:, 4,58, 5) = (/ &
 & 0.95155E-09_JPRB,0.13846E-06_JPRB,0.18562E-06_JPRB,0.18803E-06_JPRB,0.81760E-07_JPRB /)  
KB(:, 5,58, 5) = (/ &
 & 0.11100E-08_JPRB,0.15608E-06_JPRB,0.20513E-06_JPRB,0.20425E-06_JPRB,0.91405E-07_JPRB /)  
KB(:, 1,59, 5) = (/ &
 & 0.44483E-09_JPRB,0.74201E-07_JPRB,0.10175E-06_JPRB,0.10986E-06_JPRB,0.42626E-07_JPRB /)  
KB(:, 2,59, 5) = (/ &
 & 0.53478E-09_JPRB,0.86257E-07_JPRB,0.11818E-06_JPRB,0.12453E-06_JPRB,0.50816E-07_JPRB /)  
KB(:, 3,59, 5) = (/ &
 & 0.64265E-09_JPRB,0.99390E-07_JPRB,0.13535E-06_JPRB,0.13928E-06_JPRB,0.58658E-07_JPRB /)  
KB(:, 4,59, 5) = (/ &
 & 0.76369E-09_JPRB,0.11360E-06_JPRB,0.15224E-06_JPRB,0.15417E-06_JPRB,0.66845E-07_JPRB /)  
KB(:, 5,59, 5) = (/ &
 & 0.89316E-09_JPRB,0.12826E-06_JPRB,0.16850E-06_JPRB,0.16775E-06_JPRB,0.74841E-07_JPRB /)  
KB(:, 1,13, 6) = (/ &
 & 0.15452E-03_JPRB,0.17471E-02_JPRB,0.22870E-02_JPRB,0.22757E-02_JPRB,0.11868E-02_JPRB /)  
KB(:, 2,13, 6) = (/ &
 & 0.17358E-03_JPRB,0.18337E-02_JPRB,0.23752E-02_JPRB,0.23549E-02_JPRB,0.12492E-02_JPRB /)  
KB(:, 3,13, 6) = (/ &
 & 0.19043E-03_JPRB,0.19070E-02_JPRB,0.24479E-02_JPRB,0.24255E-02_JPRB,0.13114E-02_JPRB /)  
KB(:, 4,13, 6) = (/ &
 & 0.20459E-03_JPRB,0.19702E-02_JPRB,0.25109E-02_JPRB,0.24905E-02_JPRB,0.13717E-02_JPRB /)  
KB(:, 5,13, 6) = (/ &
 & 0.21621E-03_JPRB,0.20266E-02_JPRB,0.25653E-02_JPRB,0.25512E-02_JPRB,0.14320E-02_JPRB /)  
KB(:, 1,14, 6) = (/ &
 & 0.12793E-03_JPRB,0.14662E-02_JPRB,0.19141E-02_JPRB,0.19032E-02_JPRB,0.99404E-03_JPRB /)  
KB(:, 2,14, 6) = (/ &
 & 0.14335E-03_JPRB,0.15367E-02_JPRB,0.19852E-02_JPRB,0.19691E-02_JPRB,0.10462E-02_JPRB /)  
KB(:, 3,14, 6) = (/ &
 & 0.15698E-03_JPRB,0.15974E-02_JPRB,0.20454E-02_JPRB,0.20285E-02_JPRB,0.10986E-02_JPRB /)  
KB(:, 4,14, 6) = (/ &
 & 0.16837E-03_JPRB,0.16505E-02_JPRB,0.20982E-02_JPRB,0.20828E-02_JPRB,0.11509E-02_JPRB /)  
KB(:, 5,14, 6) = (/ &
 & 0.17765E-03_JPRB,0.16990E-02_JPRB,0.21452E-02_JPRB,0.21357E-02_JPRB,0.12020E-02_JPRB /)  
KB(:, 1,15, 6) = (/ &
 & 0.10600E-03_JPRB,0.12280E-02_JPRB,0.15987E-02_JPRB,0.15899E-02_JPRB,0.83160E-03_JPRB /)  
KB(:, 2,15, 6) = (/ &
 & 0.11846E-03_JPRB,0.12858E-02_JPRB,0.16570E-02_JPRB,0.16438E-02_JPRB,0.87641E-03_JPRB /)  
KB(:, 3,15, 6) = (/ &
 & 0.12947E-03_JPRB,0.13362E-02_JPRB,0.17073E-02_JPRB,0.16937E-02_JPRB,0.92037E-03_JPRB /)  
KB(:, 4,15, 6) = (/ &
 & 0.13860E-03_JPRB,0.13818E-02_JPRB,0.17519E-02_JPRB,0.17401E-02_JPRB,0.96514E-03_JPRB /)  
KB(:, 5,15, 6) = (/ &
 & 0.14605E-03_JPRB,0.14231E-02_JPRB,0.17922E-02_JPRB,0.17849E-02_JPRB,0.10088E-02_JPRB /)  
KB(:, 1,16, 6) = (/ &
 & 0.87844E-04_JPRB,0.10268E-02_JPRB,0.13337E-02_JPRB,0.13258E-02_JPRB,0.69471E-03_JPRB /)  
KB(:, 2,16, 6) = (/ &
 & 0.97921E-04_JPRB,0.10747E-02_JPRB,0.13816E-02_JPRB,0.13704E-02_JPRB,0.73309E-03_JPRB /)  
KB(:, 3,16, 6) = (/ &
 & 0.10678E-03_JPRB,0.11173E-02_JPRB,0.14240E-02_JPRB,0.14122E-02_JPRB,0.77126E-03_JPRB /)  
KB(:, 4,16, 6) = (/ &
 & 0.11410E-03_JPRB,0.11561E-02_JPRB,0.14619E-02_JPRB,0.14525E-02_JPRB,0.80983E-03_JPRB /)  
KB(:, 5,16, 6) = (/ &
 & 0.12008E-03_JPRB,0.11913E-02_JPRB,0.14957E-02_JPRB,0.14904E-02_JPRB,0.84685E-03_JPRB /)  
KB(:, 1,17, 6) = (/ &
 & 0.72736E-04_JPRB,0.85770E-03_JPRB,0.11110E-02_JPRB,0.11043E-02_JPRB,0.57988E-03_JPRB /)  
KB(:, 2,17, 6) = (/ &
 & 0.80870E-04_JPRB,0.89737E-03_JPRB,0.11508E-02_JPRB,0.11412E-02_JPRB,0.61310E-03_JPRB /)  
KB(:, 3,17, 6) = (/ &
 & 0.87984E-04_JPRB,0.93334E-03_JPRB,0.11865E-02_JPRB,0.11769E-02_JPRB,0.64563E-03_JPRB /)  
KB(:, 4,17, 6) = (/ &
 & 0.93900E-04_JPRB,0.96637E-03_JPRB,0.12188E-02_JPRB,0.12115E-02_JPRB,0.67946E-03_JPRB /)  
KB(:, 5,17, 6) = (/ &
 & 0.98669E-04_JPRB,0.99682E-03_JPRB,0.12477E-02_JPRB,0.12444E-02_JPRB,0.71129E-03_JPRB /)  
KB(:, 1,18, 6) = (/ &
 & 0.60196E-04_JPRB,0.71585E-03_JPRB,0.92484E-03_JPRB,0.91885E-03_JPRB,0.48428E-03_JPRB /)  
KB(:, 2,18, 6) = (/ &
 & 0.66759E-04_JPRB,0.74902E-03_JPRB,0.95806E-03_JPRB,0.95007E-03_JPRB,0.51254E-03_JPRB /)  
KB(:, 3,18, 6) = (/ &
 & 0.72486E-04_JPRB,0.77936E-03_JPRB,0.98828E-03_JPRB,0.98036E-03_JPRB,0.54118E-03_JPRB /)  
KB(:, 4,18, 6) = (/ &
 & 0.77210E-04_JPRB,0.80757E-03_JPRB,0.10157E-02_JPRB,0.10101E-02_JPRB,0.56995E-03_JPRB /)  
KB(:, 5,18, 6) = (/ &
 & 0.81046E-04_JPRB,0.83344E-03_JPRB,0.10405E-02_JPRB,0.10390E-02_JPRB,0.59762E-03_JPRB /)  
KB(:, 1,19, 6) = (/ &
 & 0.49797E-04_JPRB,0.59714E-03_JPRB,0.76951E-03_JPRB,0.76408E-03_JPRB,0.40487E-03_JPRB /)  
KB(:, 2,19, 6) = (/ &
 & 0.55098E-04_JPRB,0.62505E-03_JPRB,0.79728E-03_JPRB,0.79071E-03_JPRB,0.42904E-03_JPRB /)  
KB(:, 3,19, 6) = (/ &
 & 0.59690E-04_JPRB,0.65071E-03_JPRB,0.82294E-03_JPRB,0.81671E-03_JPRB,0.45375E-03_JPRB /)  
KB(:, 4,19, 6) = (/ &
 & 0.63457E-04_JPRB,0.67490E-03_JPRB,0.84635E-03_JPRB,0.84245E-03_JPRB,0.47833E-03_JPRB /)  
KB(:, 5,19, 6) = (/ &
 & 0.66538E-04_JPRB,0.69683E-03_JPRB,0.86805E-03_JPRB,0.86812E-03_JPRB,0.50238E-03_JPRB /)  
KB(:, 1,20, 6) = (/ &
 & 0.41277E-04_JPRB,0.49854E-03_JPRB,0.64043E-03_JPRB,0.63582E-03_JPRB,0.33885E-03_JPRB /)  
KB(:, 2,20, 6) = (/ &
 & 0.45557E-04_JPRB,0.52197E-03_JPRB,0.66408E-03_JPRB,0.65859E-03_JPRB,0.35960E-03_JPRB /)  
KB(:, 3,20, 6) = (/ &
 & 0.49226E-04_JPRB,0.54380E-03_JPRB,0.68582E-03_JPRB,0.68111E-03_JPRB,0.38108E-03_JPRB /)  
KB(:, 4,20, 6) = (/ &
 & 0.52238E-04_JPRB,0.56442E-03_JPRB,0.70598E-03_JPRB,0.70364E-03_JPRB,0.40199E-03_JPRB /)  
KB(:, 5,20, 6) = (/ &
 & 0.54694E-04_JPRB,0.58320E-03_JPRB,0.72504E-03_JPRB,0.72645E-03_JPRB,0.42282E-03_JPRB /)  
KB(:, 1,21, 6) = (/ &
 & 0.34218E-04_JPRB,0.41624E-03_JPRB,0.53312E-03_JPRB,0.52912E-03_JPRB,0.28376E-03_JPRB /)  
KB(:, 2,21, 6) = (/ &
 & 0.37670E-04_JPRB,0.43597E-03_JPRB,0.55316E-03_JPRB,0.54893E-03_JPRB,0.30161E-03_JPRB /)  
KB(:, 3,21, 6) = (/ &
 & 0.40602E-04_JPRB,0.45467E-03_JPRB,0.57178E-03_JPRB,0.56861E-03_JPRB,0.32023E-03_JPRB /)  
KB(:, 4,21, 6) = (/ &
 & 0.43009E-04_JPRB,0.47220E-03_JPRB,0.58931E-03_JPRB,0.58850E-03_JPRB,0.33805E-03_JPRB /)  
KB(:, 5,21, 6) = (/ &
 & 0.44968E-04_JPRB,0.48850E-03_JPRB,0.60624E-03_JPRB,0.60867E-03_JPRB,0.35633E-03_JPRB /)  
KB(:, 1,22, 6) = (/ &
 & 0.28554E-04_JPRB,0.34872E-03_JPRB,0.44519E-03_JPRB,0.44203E-03_JPRB,0.23865E-03_JPRB /)  
KB(:, 2,22, 6) = (/ &
 & 0.31312E-04_JPRB,0.36543E-03_JPRB,0.46215E-03_JPRB,0.45896E-03_JPRB,0.25429E-03_JPRB /)  
KB(:, 3,22, 6) = (/ &
 & 0.33623E-04_JPRB,0.38136E-03_JPRB,0.47808E-03_JPRB,0.47625E-03_JPRB,0.27020E-03_JPRB /)  
KB(:, 4,22, 6) = (/ &
 & 0.35518E-04_JPRB,0.39638E-03_JPRB,0.49352E-03_JPRB,0.49393E-03_JPRB,0.28567E-03_JPRB /)  
KB(:, 5,22, 6) = (/ &
 & 0.37060E-04_JPRB,0.41046E-03_JPRB,0.50833E-03_JPRB,0.51152E-03_JPRB,0.30169E-03_JPRB /)  
KB(:, 1,23, 6) = (/ &
 & 0.23825E-04_JPRB,0.29241E-03_JPRB,0.37202E-03_JPRB,0.36957E-03_JPRB,0.20120E-03_JPRB /)  
KB(:, 2,23, 6) = (/ &
 & 0.26019E-04_JPRB,0.30664E-03_JPRB,0.38650E-03_JPRB,0.38433E-03_JPRB,0.21484E-03_JPRB /)  
KB(:, 3,23, 6) = (/ &
 & 0.27840E-04_JPRB,0.32027E-03_JPRB,0.40038E-03_JPRB,0.39957E-03_JPRB,0.22829E-03_JPRB /)  
KB(:, 4,23, 6) = (/ &
 & 0.29329E-04_JPRB,0.33317E-03_JPRB,0.41396E-03_JPRB,0.41498E-03_JPRB,0.24169E-03_JPRB /)  
KB(:, 5,23, 6) = (/ &
 & 0.30542E-04_JPRB,0.34547E-03_JPRB,0.42681E-03_JPRB,0.43048E-03_JPRB,0.25568E-03_JPRB /)  
KB(:, 1,24, 6) = (/ &
 & 0.19879E-04_JPRB,0.24552E-03_JPRB,0.31135E-03_JPRB,0.30936E-03_JPRB,0.16986E-03_JPRB /)  
KB(:, 2,24, 6) = (/ &
 & 0.21617E-04_JPRB,0.25767E-03_JPRB,0.32376E-03_JPRB,0.32228E-03_JPRB,0.18173E-03_JPRB /)  
KB(:, 3,24, 6) = (/ &
 & 0.23050E-04_JPRB,0.26937E-03_JPRB,0.33590E-03_JPRB,0.33579E-03_JPRB,0.19320E-03_JPRB /)  
KB(:, 4,24, 6) = (/ &
 & 0.24217E-04_JPRB,0.28054E-03_JPRB,0.34772E-03_JPRB,0.34922E-03_JPRB,0.20501E-03_JPRB /)  
KB(:, 5,24, 6) = (/ &
 & 0.25164E-04_JPRB,0.29121E-03_JPRB,0.35883E-03_JPRB,0.36286E-03_JPRB,0.21708E-03_JPRB /)  
KB(:, 1,25, 6) = (/ &
 & 0.16589E-04_JPRB,0.20645E-03_JPRB,0.26087E-03_JPRB,0.25944E-03_JPRB,0.14369E-03_JPRB /)  
KB(:, 2,25, 6) = (/ &
 & 0.17961E-04_JPRB,0.21688E-03_JPRB,0.27162E-03_JPRB,0.27083E-03_JPRB,0.15386E-03_JPRB /)  
KB(:, 3,25, 6) = (/ &
 & 0.19083E-04_JPRB,0.22697E-03_JPRB,0.28229E-03_JPRB,0.28258E-03_JPRB,0.16383E-03_JPRB /)  
KB(:, 4,25, 6) = (/ &
 & 0.19998E-04_JPRB,0.23668E-03_JPRB,0.29245E-03_JPRB,0.29438E-03_JPRB,0.17418E-03_JPRB /)  
KB(:, 5,25, 6) = (/ &
 & 0.20737E-04_JPRB,0.24589E-03_JPRB,0.30216E-03_JPRB,0.30647E-03_JPRB,0.18465E-03_JPRB /)  
KB(:, 1,26, 6) = (/ &
 & 0.13858E-04_JPRB,0.17402E-03_JPRB,0.21906E-03_JPRB,0.21804E-03_JPRB,0.12205E-03_JPRB /)  
KB(:, 2,26, 6) = (/ &
 & 0.14930E-04_JPRB,0.18300E-03_JPRB,0.22843E-03_JPRB,0.22813E-03_JPRB,0.13065E-03_JPRB /)  
KB(:, 3,26, 6) = (/ &
 & 0.15807E-04_JPRB,0.19174E-03_JPRB,0.23770E-03_JPRB,0.23830E-03_JPRB,0.13933E-03_JPRB /)  
KB(:, 4,26, 6) = (/ &
 & 0.16522E-04_JPRB,0.20010E-03_JPRB,0.24640E-03_JPRB,0.24876E-03_JPRB,0.14837E-03_JPRB /)  
KB(:, 5,26, 6) = (/ &
 & 0.17090E-04_JPRB,0.20798E-03_JPRB,0.25500E-03_JPRB,0.25943E-03_JPRB,0.15748E-03_JPRB /)  
KB(:, 1,27, 6) = (/ &
 & 0.11565E-04_JPRB,0.14689E-03_JPRB,0.18423E-03_JPRB,0.18358E-03_JPRB,0.10372E-03_JPRB /)  
KB(:, 2,27, 6) = (/ &
 & 0.12404E-04_JPRB,0.15466E-03_JPRB,0.19242E-03_JPRB,0.19242E-03_JPRB,0.11104E-03_JPRB /)  
KB(:, 3,27, 6) = (/ &
 & 0.13088E-04_JPRB,0.16225E-03_JPRB,0.20035E-03_JPRB,0.20136E-03_JPRB,0.11877E-03_JPRB /)  
KB(:, 4,27, 6) = (/ &
 & 0.13644E-04_JPRB,0.16938E-03_JPRB,0.20793E-03_JPRB,0.21054E-03_JPRB,0.12658E-03_JPRB /)  
KB(:, 5,27, 6) = (/ &
 & 0.14079E-04_JPRB,0.17614E-03_JPRB,0.21553E-03_JPRB,0.22004E-03_JPRB,0.13455E-03_JPRB /)  
KB(:, 1,28, 6) = (/ &
 & 0.96429E-05_JPRB,0.12422E-03_JPRB,0.15518E-03_JPRB,0.15486E-03_JPRB,0.88240E-04_JPRB /)  
KB(:, 2,28, 6) = (/ &
 & 0.10297E-04_JPRB,0.13093E-03_JPRB,0.16229E-03_JPRB,0.16255E-03_JPRB,0.94664E-04_JPRB /)  
KB(:, 3,28, 6) = (/ &
 & 0.10829E-04_JPRB,0.13744E-03_JPRB,0.16911E-03_JPRB,0.17043E-03_JPRB,0.10137E-03_JPRB /)  
KB(:, 4,28, 6) = (/ &
 & 0.11263E-04_JPRB,0.14355E-03_JPRB,0.17577E-03_JPRB,0.17861E-03_JPRB,0.10818E-03_JPRB /)  
KB(:, 5,28, 6) = (/ &
 & 0.11593E-04_JPRB,0.14936E-03_JPRB,0.18245E-03_JPRB,0.18698E-03_JPRB,0.11517E-03_JPRB /)  
KB(:, 1,29, 6) = (/ &
 & 0.80357E-05_JPRB,0.10525E-03_JPRB,0.13098E-03_JPRB,0.13087E-03_JPRB,0.75199E-04_JPRB /)  
KB(:, 2,29, 6) = (/ &
 & 0.85457E-05_JPRB,0.11106E-03_JPRB,0.13709E-03_JPRB,0.13756E-03_JPRB,0.80877E-04_JPRB /)  
KB(:, 3,29, 6) = (/ &
 & 0.89585E-05_JPRB,0.11659E-03_JPRB,0.14298E-03_JPRB,0.14458E-03_JPRB,0.86703E-04_JPRB /)  
KB(:, 4,29, 6) = (/ &
 & 0.92936E-05_JPRB,0.12185E-03_JPRB,0.14887E-03_JPRB,0.15184E-03_JPRB,0.92679E-04_JPRB /)  
KB(:, 5,29, 6) = (/ &
 & 0.95413E-05_JPRB,0.12685E-03_JPRB,0.15476E-03_JPRB,0.15926E-03_JPRB,0.98770E-04_JPRB /)  
KB(:, 1,30, 6) = (/ &
 & 0.66891E-05_JPRB,0.89326E-04_JPRB,0.11070E-03_JPRB,0.11075E-03_JPRB,0.64254E-04_JPRB /)  
KB(:, 2,30, 6) = (/ &
 & 0.70855E-05_JPRB,0.94280E-04_JPRB,0.11595E-03_JPRB,0.11668E-03_JPRB,0.69215E-04_JPRB /)  
KB(:, 3,30, 6) = (/ &
 & 0.74068E-05_JPRB,0.99029E-04_JPRB,0.12112E-03_JPRB,0.12290E-03_JPRB,0.74278E-04_JPRB /)  
KB(:, 4,30, 6) = (/ &
 & 0.76634E-05_JPRB,0.10356E-03_JPRB,0.12631E-03_JPRB,0.12933E-03_JPRB,0.79489E-04_JPRB /)  
KB(:, 5,30, 6) = (/ &
 & 0.78499E-05_JPRB,0.10785E-03_JPRB,0.13152E-03_JPRB,0.13588E-03_JPRB,0.84762E-04_JPRB /)  
KB(:, 1,31, 6) = (/ &
 & 0.55647E-05_JPRB,0.75943E-04_JPRB,0.93695E-04_JPRB,0.93906E-04_JPRB,0.55002E-04_JPRB /)  
KB(:, 2,31, 6) = (/ &
 & 0.58719E-05_JPRB,0.80167E-04_JPRB,0.98229E-04_JPRB,0.99204E-04_JPRB,0.59329E-04_JPRB /)  
KB(:, 3,31, 6) = (/ &
 & 0.61212E-05_JPRB,0.84249E-04_JPRB,0.10281E-03_JPRB,0.10471E-03_JPRB,0.63778E-04_JPRB /)  
KB(:, 4,31, 6) = (/ &
 & 0.63162E-05_JPRB,0.88122E-04_JPRB,0.10738E-03_JPRB,0.11041E-03_JPRB,0.68318E-04_JPRB /)  
KB(:, 5,31, 6) = (/ &
 & 0.64553E-05_JPRB,0.91835E-04_JPRB,0.11204E-03_JPRB,0.11614E-03_JPRB,0.72907E-04_JPRB /)  
KB(:, 1,32, 6) = (/ &
 & 0.46246E-05_JPRB,0.64633E-04_JPRB,0.79398E-04_JPRB,0.79831E-04_JPRB,0.47190E-04_JPRB /)  
KB(:, 2,32, 6) = (/ &
 & 0.48628E-05_JPRB,0.68258E-04_JPRB,0.83383E-04_JPRB,0.84521E-04_JPRB,0.50953E-04_JPRB /)  
KB(:, 3,32, 6) = (/ &
 & 0.50557E-05_JPRB,0.71758E-04_JPRB,0.87418E-04_JPRB,0.89417E-04_JPRB,0.54823E-04_JPRB /)  
KB(:, 4,32, 6) = (/ &
 & 0.52035E-05_JPRB,0.75099E-04_JPRB,0.91481E-04_JPRB,0.94423E-04_JPRB,0.58785E-04_JPRB /)  
KB(:, 5,32, 6) = (/ &
 & 0.53068E-05_JPRB,0.78317E-04_JPRB,0.95646E-04_JPRB,0.99452E-04_JPRB,0.62766E-04_JPRB /)  
KB(:, 1,33, 6) = (/ &
 & 0.38403E-05_JPRB,0.55077E-04_JPRB,0.67410E-04_JPRB,0.68024E-04_JPRB,0.40538E-04_JPRB /)  
KB(:, 2,33, 6) = (/ &
 & 0.40244E-05_JPRB,0.58199E-04_JPRB,0.70924E-04_JPRB,0.72180E-04_JPRB,0.43839E-04_JPRB /)  
KB(:, 3,33, 6) = (/ &
 & 0.41730E-05_JPRB,0.61206E-04_JPRB,0.74475E-04_JPRB,0.76502E-04_JPRB,0.47222E-04_JPRB /)  
KB(:, 4,33, 6) = (/ &
 & 0.42835E-05_JPRB,0.64091E-04_JPRB,0.78114E-04_JPRB,0.80883E-04_JPRB,0.50652E-04_JPRB /)  
KB(:, 5,33, 6) = (/ &
 & 0.43604E-05_JPRB,0.66898E-04_JPRB,0.81798E-04_JPRB,0.85293E-04_JPRB,0.54102E-04_JPRB /)  
KB(:, 1,34, 6) = (/ &
 & 0.31801E-05_JPRB,0.46888E-04_JPRB,0.57233E-04_JPRB,0.57945E-04_JPRB,0.34781E-04_JPRB /)  
KB(:, 2,34, 6) = (/ &
 & 0.33244E-05_JPRB,0.49586E-04_JPRB,0.60319E-04_JPRB,0.61625E-04_JPRB,0.37646E-04_JPRB /)  
KB(:, 3,34, 6) = (/ &
 & 0.34389E-05_JPRB,0.52183E-04_JPRB,0.63465E-04_JPRB,0.65422E-04_JPRB,0.40606E-04_JPRB /)  
KB(:, 4,34, 6) = (/ &
 & 0.35228E-05_JPRB,0.54696E-04_JPRB,0.66697E-04_JPRB,0.69266E-04_JPRB,0.43571E-04_JPRB /)  
KB(:, 5,34, 6) = (/ &
 & 0.35804E-05_JPRB,0.57162E-04_JPRB,0.69964E-04_JPRB,0.73120E-04_JPRB,0.46562E-04_JPRB /)  
KB(:, 1,35, 6) = (/ &
 & 0.26200E-05_JPRB,0.39742E-04_JPRB,0.48410E-04_JPRB,0.49141E-04_JPRB,0.29639E-04_JPRB /)  
KB(:, 2,35, 6) = (/ &
 & 0.27351E-05_JPRB,0.42075E-04_JPRB,0.51122E-04_JPRB,0.52382E-04_JPRB,0.32146E-04_JPRB /)  
KB(:, 3,35, 6) = (/ &
 & 0.28253E-05_JPRB,0.44325E-04_JPRB,0.53916E-04_JPRB,0.55698E-04_JPRB,0.34701E-04_JPRB /)  
KB(:, 4,35, 6) = (/ &
 & 0.28907E-05_JPRB,0.46530E-04_JPRB,0.56769E-04_JPRB,0.59068E-04_JPRB,0.37280E-04_JPRB /)  
KB(:, 5,35, 6) = (/ &
 & 0.29354E-05_JPRB,0.48707E-04_JPRB,0.59649E-04_JPRB,0.62461E-04_JPRB,0.39864E-04_JPRB /)  
KB(:, 1,36, 6) = (/ &
 & 0.21469E-05_JPRB,0.33498E-04_JPRB,0.40744E-04_JPRB,0.41427E-04_JPRB,0.25045E-04_JPRB /)  
KB(:, 2,36, 6) = (/ &
 & 0.22407E-05_JPRB,0.35513E-04_JPRB,0.43124E-04_JPRB,0.44262E-04_JPRB,0.27227E-04_JPRB /)  
KB(:, 3,36, 6) = (/ &
 & 0.23140E-05_JPRB,0.37481E-04_JPRB,0.45588E-04_JPRB,0.47157E-04_JPRB,0.29433E-04_JPRB /)  
KB(:, 4,36, 6) = (/ &
 & 0.23673E-05_JPRB,0.39419E-04_JPRB,0.48109E-04_JPRB,0.50107E-04_JPRB,0.31672E-04_JPRB /)  
KB(:, 5,36, 6) = (/ &
 & 0.24035E-05_JPRB,0.41345E-04_JPRB,0.50640E-04_JPRB,0.53089E-04_JPRB,0.33911E-04_JPRB /)  
KB(:, 1,37, 6) = (/ &
 & 0.17464E-05_JPRB,0.27984E-04_JPRB,0.34007E-04_JPRB,0.34584E-04_JPRB,0.20899E-04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART20',1,ZHOOK_HANDLE)
END SUBROUTINE PART20


SUBROUTINE PART21

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART21',0,ZHOOK_HANDLE)


KB(:, 2,37, 6) = (/ &
 & 0.18252E-05_JPRB,0.29737E-04_JPRB,0.36088E-04_JPRB,0.37051E-04_JPRB,0.22785E-04_JPRB /)  
KB(:, 3,37, 6) = (/ &
 & 0.18877E-05_JPRB,0.31460E-04_JPRB,0.38247E-04_JPRB,0.39573E-04_JPRB,0.24687E-04_JPRB /)  
KB(:, 4,37, 6) = (/ &
 & 0.19333E-05_JPRB,0.33165E-04_JPRB,0.40460E-04_JPRB,0.42146E-04_JPRB,0.26626E-04_JPRB /)  
KB(:, 5,37, 6) = (/ &
 & 0.19647E-05_JPRB,0.34869E-04_JPRB,0.42691E-04_JPRB,0.44765E-04_JPRB,0.28561E-04_JPRB /)  
KB(:, 1,38, 6) = (/ &
 & 0.14198E-05_JPRB,0.23364E-04_JPRB,0.28367E-04_JPRB,0.28854E-04_JPRB,0.17422E-04_JPRB /)  
KB(:, 2,38, 6) = (/ &
 & 0.14862E-05_JPRB,0.24892E-04_JPRB,0.30186E-04_JPRB,0.30994E-04_JPRB,0.19047E-04_JPRB /)  
KB(:, 3,38, 6) = (/ &
 & 0.15394E-05_JPRB,0.26399E-04_JPRB,0.32076E-04_JPRB,0.33192E-04_JPRB,0.20688E-04_JPRB /)  
KB(:, 4,38, 6) = (/ &
 & 0.15786E-05_JPRB,0.27898E-04_JPRB,0.34020E-04_JPRB,0.35441E-04_JPRB,0.22360E-04_JPRB /)  
KB(:, 5,38, 6) = (/ &
 & 0.16058E-05_JPRB,0.29401E-04_JPRB,0.35983E-04_JPRB,0.37735E-04_JPRB,0.24033E-04_JPRB /)  
KB(:, 1,39, 6) = (/ &
 & 0.11541E-05_JPRB,0.19509E-04_JPRB,0.23663E-04_JPRB,0.24072E-04_JPRB,0.14521E-04_JPRB /)  
KB(:, 2,39, 6) = (/ &
 & 0.12100E-05_JPRB,0.20837E-04_JPRB,0.25252E-04_JPRB,0.25929E-04_JPRB,0.15915E-04_JPRB /)  
KB(:, 3,39, 6) = (/ &
 & 0.12551E-05_JPRB,0.22155E-04_JPRB,0.26902E-04_JPRB,0.27842E-04_JPRB,0.17331E-04_JPRB /)  
KB(:, 4,39, 6) = (/ &
 & 0.12888E-05_JPRB,0.23470E-04_JPRB,0.28603E-04_JPRB,0.29806E-04_JPRB,0.18773E-04_JPRB /)  
KB(:, 5,39, 6) = (/ &
 & 0.13123E-05_JPRB,0.24794E-04_JPRB,0.30331E-04_JPRB,0.31815E-04_JPRB,0.20216E-04_JPRB /)  
KB(:, 1,40, 6) = (/ &
 & 0.93244E-06_JPRB,0.16171E-04_JPRB,0.19599E-04_JPRB,0.19918E-04_JPRB,0.11977E-04_JPRB /)  
KB(:, 2,40, 6) = (/ &
 & 0.98059E-06_JPRB,0.17324E-04_JPRB,0.20976E-04_JPRB,0.21519E-04_JPRB,0.13169E-04_JPRB /)  
KB(:, 3,40, 6) = (/ &
 & 0.10196E-05_JPRB,0.18475E-04_JPRB,0.22411E-04_JPRB,0.23178E-04_JPRB,0.14387E-04_JPRB /)  
KB(:, 4,40, 6) = (/ &
 & 0.10496E-05_JPRB,0.19626E-04_JPRB,0.23897E-04_JPRB,0.24887E-04_JPRB,0.15625E-04_JPRB /)  
KB(:, 5,40, 6) = (/ &
 & 0.10706E-05_JPRB,0.20792E-04_JPRB,0.25411E-04_JPRB,0.26641E-04_JPRB,0.16871E-04_JPRB /)  
KB(:, 1,41, 6) = (/ &
 & 0.75206E-06_JPRB,0.13381E-04_JPRB,0.16204E-04_JPRB,0.16448E-04_JPRB,0.98582E-05_JPRB /)  
KB(:, 2,41, 6) = (/ &
 & 0.79368E-06_JPRB,0.14380E-04_JPRB,0.17395E-04_JPRB,0.17824E-04_JPRB,0.10873E-04_JPRB /)  
KB(:, 3,41, 6) = (/ &
 & 0.82742E-06_JPRB,0.15382E-04_JPRB,0.18640E-04_JPRB,0.19259E-04_JPRB,0.11916E-04_JPRB /)  
KB(:, 4,41, 6) = (/ &
 & 0.85390E-06_JPRB,0.16388E-04_JPRB,0.19935E-04_JPRB,0.20745E-04_JPRB,0.12979E-04_JPRB /)  
KB(:, 5,41, 6) = (/ &
 & 0.87281E-06_JPRB,0.17412E-04_JPRB,0.21261E-04_JPRB,0.22271E-04_JPRB,0.14053E-04_JPRB /)  
KB(:, 1,42, 6) = (/ &
 & 0.60591E-06_JPRB,0.11061E-04_JPRB,0.13385E-04_JPRB,0.13568E-04_JPRB,0.81045E-05_JPRB /)  
KB(:, 2,42, 6) = (/ &
 & 0.64182E-06_JPRB,0.11926E-04_JPRB,0.14412E-04_JPRB,0.14751E-04_JPRB,0.89661E-05_JPRB /)  
KB(:, 3,42, 6) = (/ &
 & 0.67101E-06_JPRB,0.12797E-04_JPRB,0.15489E-04_JPRB,0.15987E-04_JPRB,0.98578E-05_JPRB /)  
KB(:, 4,42, 6) = (/ &
 & 0.69427E-06_JPRB,0.13675E-04_JPRB,0.16616E-04_JPRB,0.17274E-04_JPRB,0.10770E-04_JPRB /)  
KB(:, 5,42, 6) = (/ &
 & 0.71122E-06_JPRB,0.14573E-04_JPRB,0.17774E-04_JPRB,0.18601E-04_JPRB,0.11690E-04_JPRB /)  
KB(:, 1,43, 6) = (/ &
 & 0.48565E-06_JPRB,0.90929E-05_JPRB,0.10998E-04_JPRB,0.11127E-04_JPRB,0.66136E-05_JPRB /)  
KB(:, 2,43, 6) = (/ &
 & 0.51703E-06_JPRB,0.98401E-05_JPRB,0.11878E-04_JPRB,0.12136E-04_JPRB,0.73431E-05_JPRB /)  
KB(:, 3,43, 6) = (/ &
 & 0.54246E-06_JPRB,0.10594E-04_JPRB,0.12807E-04_JPRB,0.13197E-04_JPRB,0.81019E-05_JPRB /)  
KB(:, 4,43, 6) = (/ &
 & 0.56309E-06_JPRB,0.11359E-04_JPRB,0.13782E-04_JPRB,0.14306E-04_JPRB,0.88812E-05_JPRB /)  
KB(:, 5,43, 6) = (/ &
 & 0.57854E-06_JPRB,0.12144E-04_JPRB,0.14791E-04_JPRB,0.15456E-04_JPRB,0.96685E-05_JPRB /)  
KB(:, 1,44, 6) = (/ &
 & 0.38777E-06_JPRB,0.74478E-05_JPRB,0.90062E-05_JPRB,0.90921E-05_JPRB,0.53709E-05_JPRB /)  
KB(:, 2,44, 6) = (/ &
 & 0.41522E-06_JPRB,0.80919E-05_JPRB,0.97570E-05_JPRB,0.99478E-05_JPRB,0.59889E-05_JPRB /)  
KB(:, 3,44, 6) = (/ &
 & 0.43761E-06_JPRB,0.87433E-05_JPRB,0.10555E-04_JPRB,0.10856E-04_JPRB,0.66332E-05_JPRB /)  
KB(:, 4,44, 6) = (/ &
 & 0.45584E-06_JPRB,0.94063E-05_JPRB,0.11395E-04_JPRB,0.11808E-04_JPRB,0.72955E-05_JPRB /)  
KB(:, 5,44, 6) = (/ &
 & 0.46990E-06_JPRB,0.10091E-04_JPRB,0.12269E-04_JPRB,0.12799E-04_JPRB,0.79696E-05_JPRB /)  
KB(:, 1,45, 6) = (/ &
 & 0.30888E-06_JPRB,0.60898E-05_JPRB,0.73632E-05_JPRB,0.74181E-05_JPRB,0.43535E-05_JPRB /)  
KB(:, 2,45, 6) = (/ &
 & 0.33291E-06_JPRB,0.66440E-05_JPRB,0.80023E-05_JPRB,0.81416E-05_JPRB,0.48741E-05_JPRB /)  
KB(:, 3,45, 6) = (/ &
 & 0.35255E-06_JPRB,0.72052E-05_JPRB,0.86855E-05_JPRB,0.89154E-05_JPRB,0.54207E-05_JPRB /)  
KB(:, 4,45, 6) = (/ &
 & 0.36854E-06_JPRB,0.77787E-05_JPRB,0.94068E-05_JPRB,0.97308E-05_JPRB,0.59833E-05_JPRB /)  
KB(:, 5,45, 6) = (/ &
 & 0.38125E-06_JPRB,0.83745E-05_JPRB,0.10163E-04_JPRB,0.10583E-04_JPRB,0.65578E-05_JPRB /)  
KB(:, 1,46, 6) = (/ &
 & 0.24494E-06_JPRB,0.49598E-05_JPRB,0.59987E-05_JPRB,0.60289E-05_JPRB,0.35123E-05_JPRB /)  
KB(:, 2,46, 6) = (/ &
 & 0.26595E-06_JPRB,0.54355E-05_JPRB,0.65411E-05_JPRB,0.66383E-05_JPRB,0.39494E-05_JPRB /)  
KB(:, 3,46, 6) = (/ &
 & 0.28328E-06_JPRB,0.59173E-05_JPRB,0.71233E-05_JPRB,0.72943E-05_JPRB,0.44113E-05_JPRB /)  
KB(:, 4,46, 6) = (/ &
 & 0.29735E-06_JPRB,0.64123E-05_JPRB,0.77406E-05_JPRB,0.79904E-05_JPRB,0.48883E-05_JPRB /)  
KB(:, 5,46, 6) = (/ &
 & 0.30876E-06_JPRB,0.69283E-05_JPRB,0.83913E-05_JPRB,0.87211E-05_JPRB,0.53766E-05_JPRB /)  
KB(:, 1,47, 6) = (/ &
 & 0.19287E-06_JPRB,0.40134E-05_JPRB,0.48586E-05_JPRB,0.48718E-05_JPRB,0.28114E-05_JPRB /)  
KB(:, 2,47, 6) = (/ &
 & 0.21123E-06_JPRB,0.44208E-05_JPRB,0.53178E-05_JPRB,0.53794E-05_JPRB,0.31781E-05_JPRB /)  
KB(:, 3,47, 6) = (/ &
 & 0.22658E-06_JPRB,0.48332E-05_JPRB,0.58104E-05_JPRB,0.59335E-05_JPRB,0.35646E-05_JPRB /)  
KB(:, 4,47, 6) = (/ &
 & 0.23912E-06_JPRB,0.52582E-05_JPRB,0.63354E-05_JPRB,0.65230E-05_JPRB,0.39676E-05_JPRB /)  
KB(:, 5,47, 6) = (/ &
 & 0.24931E-06_JPRB,0.57025E-05_JPRB,0.68920E-05_JPRB,0.71458E-05_JPRB,0.43826E-05_JPRB /)  
KB(:, 1,48, 6) = (/ &
 & 0.15132E-06_JPRB,0.32395E-05_JPRB,0.39269E-05_JPRB,0.39289E-05_JPRB,0.22458E-05_JPRB /)  
KB(:, 2,48, 6) = (/ &
 & 0.16716E-06_JPRB,0.35866E-05_JPRB,0.43144E-05_JPRB,0.43511E-05_JPRB,0.25512E-05_JPRB /)  
KB(:, 3,48, 6) = (/ &
 & 0.18076E-06_JPRB,0.39391E-05_JPRB,0.47294E-05_JPRB,0.48161E-05_JPRB,0.28746E-05_JPRB /)  
KB(:, 4,48, 6) = (/ &
 & 0.19194E-06_JPRB,0.43030E-05_JPRB,0.51748E-05_JPRB,0.53142E-05_JPRB,0.32135E-05_JPRB /)  
KB(:, 5,48, 6) = (/ &
 & 0.20099E-06_JPRB,0.46842E-05_JPRB,0.56488E-05_JPRB,0.58430E-05_JPRB,0.35644E-05_JPRB /)  
KB(:, 1,49, 6) = (/ &
 & 0.11828E-06_JPRB,0.26078E-05_JPRB,0.31672E-05_JPRB,0.31617E-05_JPRB,0.17894E-05_JPRB /)  
KB(:, 2,49, 6) = (/ &
 & 0.13185E-06_JPRB,0.29029E-05_JPRB,0.34929E-05_JPRB,0.35125E-05_JPRB,0.20423E-05_JPRB /)  
KB(:, 3,49, 6) = (/ &
 & 0.14378E-06_JPRB,0.32030E-05_JPRB,0.38409E-05_JPRB,0.39000E-05_JPRB,0.23121E-05_JPRB /)  
KB(:, 4,49, 6) = (/ &
 & 0.15369E-06_JPRB,0.35139E-05_JPRB,0.42179E-05_JPRB,0.43198E-05_JPRB,0.25971E-05_JPRB /)  
KB(:, 5,49, 6) = (/ &
 & 0.16176E-06_JPRB,0.38391E-05_JPRB,0.46198E-05_JPRB,0.47667E-05_JPRB,0.28929E-05_JPRB /)  
KB(:, 1,50, 6) = (/ &
 & 0.92362E-07_JPRB,0.20997E-05_JPRB,0.25556E-05_JPRB,0.25471E-05_JPRB,0.14267E-05_JPRB /)  
KB(:, 2,50, 6) = (/ &
 & 0.10390E-06_JPRB,0.23496E-05_JPRB,0.28286E-05_JPRB,0.28368E-05_JPRB,0.16356E-05_JPRB /)  
KB(:, 3,50, 6) = (/ &
 & 0.11421E-06_JPRB,0.26049E-05_JPRB,0.31213E-05_JPRB,0.31606E-05_JPRB,0.18609E-05_JPRB /)  
KB(:, 4,50, 6) = (/ &
 & 0.12297E-06_JPRB,0.28694E-05_JPRB,0.34392E-05_JPRB,0.35125E-05_JPRB,0.20996E-05_JPRB /)  
KB(:, 5,50, 6) = (/ &
 & 0.13012E-06_JPRB,0.31471E-05_JPRB,0.37794E-05_JPRB,0.38900E-05_JPRB,0.23486E-05_JPRB /)  
KB(:, 1,51, 6) = (/ &
 & 0.72029E-07_JPRB,0.16879E-05_JPRB,0.20606E-05_JPRB,0.20506E-05_JPRB,0.11365E-05_JPRB /)  
KB(:, 2,51, 6) = (/ &
 & 0.81717E-07_JPRB,0.18994E-05_JPRB,0.22886E-05_JPRB,0.22902E-05_JPRB,0.13081E-05_JPRB /)  
KB(:, 3,51, 6) = (/ &
 & 0.90547E-07_JPRB,0.21162E-05_JPRB,0.25347E-05_JPRB,0.25588E-05_JPRB,0.14964E-05_JPRB /)  
KB(:, 4,51, 6) = (/ &
 & 0.98231E-07_JPRB,0.23407E-05_JPRB,0.28017E-05_JPRB,0.28537E-05_JPRB,0.16958E-05_JPRB /)  
KB(:, 5,51, 6) = (/ &
 & 0.10454E-06_JPRB,0.25770E-05_JPRB,0.30891E-05_JPRB,0.31719E-05_JPRB,0.19053E-05_JPRB /)  
KB(:, 1,52, 6) = (/ &
 & 0.55994E-07_JPRB,0.13535E-05_JPRB,0.16583E-05_JPRB,0.16483E-05_JPRB,0.90215E-06_JPRB /)  
KB(:, 2,52, 6) = (/ &
 & 0.64065E-07_JPRB,0.15318E-05_JPRB,0.18483E-05_JPRB,0.18452E-05_JPRB,0.10447E-05_JPRB /)  
KB(:, 3,52, 6) = (/ &
 & 0.71601E-07_JPRB,0.17156E-05_JPRB,0.20541E-05_JPRB,0.20679E-05_JPRB,0.12005E-05_JPRB /)  
KB(:, 4,52, 6) = (/ &
 & 0.78265E-07_JPRB,0.19055E-05_JPRB,0.22786E-05_JPRB,0.23151E-05_JPRB,0.13673E-05_JPRB /)  
KB(:, 5,52, 6) = (/ &
 & 0.83827E-07_JPRB,0.21062E-05_JPRB,0.25201E-05_JPRB,0.25812E-05_JPRB,0.15426E-05_JPRB /)  
KB(:, 1,53, 6) = (/ &
 & 0.43376E-07_JPRB,0.10823E-05_JPRB,0.13316E-05_JPRB,0.13229E-05_JPRB,0.71387E-06_JPRB /)  
KB(:, 2,53, 6) = (/ &
 & 0.50078E-07_JPRB,0.12320E-05_JPRB,0.14898E-05_JPRB,0.14843E-05_JPRB,0.83196E-06_JPRB /)  
KB(:, 3,53, 6) = (/ &
 & 0.56440E-07_JPRB,0.13873E-05_JPRB,0.16612E-05_JPRB,0.16678E-05_JPRB,0.96085E-06_JPRB /)  
KB(:, 4,53, 6) = (/ &
 & 0.62188E-07_JPRB,0.15481E-05_JPRB,0.18489E-05_JPRB,0.18736E-05_JPRB,0.10995E-05_JPRB /)  
KB(:, 5,53, 6) = (/ &
 & 0.67072E-07_JPRB,0.17179E-05_JPRB,0.20520E-05_JPRB,0.20964E-05_JPRB,0.12465E-05_JPRB /)  
KB(:, 1,54, 6) = (/ &
 & 0.33662E-07_JPRB,0.86685E-06_JPRB,0.10712E-05_JPRB,0.10638E-05_JPRB,0.56675E-06_JPRB /)  
KB(:, 2,54, 6) = (/ &
 & 0.39188E-07_JPRB,0.99237E-06_JPRB,0.12024E-05_JPRB,0.11965E-05_JPRB,0.66407E-06_JPRB /)  
KB(:, 3,54, 6) = (/ &
 & 0.44517E-07_JPRB,0.11234E-05_JPRB,0.13453E-05_JPRB,0.13477E-05_JPRB,0.77015E-06_JPRB /)  
KB(:, 4,54, 6) = (/ &
 & 0.49410E-07_JPRB,0.12591E-05_JPRB,0.15022E-05_JPRB,0.15186E-05_JPRB,0.88568E-06_JPRB /)  
KB(:, 5,54, 6) = (/ &
 & 0.53662E-07_JPRB,0.14028E-05_JPRB,0.16732E-05_JPRB,0.17054E-05_JPRB,0.10088E-05_JPRB /)  
KB(:, 1,55, 6) = (/ &
 & 0.26107E-07_JPRB,0.69409E-06_JPRB,0.86148E-06_JPRB,0.85535E-06_JPRB,0.44993E-06_JPRB /)  
KB(:, 2,55, 6) = (/ &
 & 0.30648E-07_JPRB,0.79874E-06_JPRB,0.97050E-06_JPRB,0.96432E-06_JPRB,0.52987E-06_JPRB /)  
KB(:, 3,55, 6) = (/ &
 & 0.35070E-07_JPRB,0.90919E-06_JPRB,0.10893E-05_JPRB,0.10889E-05_JPRB,0.61727E-06_JPRB /)  
KB(:, 4,55, 6) = (/ &
 & 0.39223E-07_JPRB,0.10237E-05_JPRB,0.12206E-05_JPRB,0.12308E-05_JPRB,0.71345E-06_JPRB /)  
KB(:, 5,55, 6) = (/ &
 & 0.42897E-07_JPRB,0.11450E-05_JPRB,0.13641E-05_JPRB,0.13878E-05_JPRB,0.81614E-06_JPRB /)  
KB(:, 1,56, 6) = (/ &
 & 0.20183E-07_JPRB,0.55461E-06_JPRB,0.69187E-06_JPRB,0.68686E-06_JPRB,0.35634E-06_JPRB /)  
KB(:, 2,56, 6) = (/ &
 & 0.23906E-07_JPRB,0.64143E-06_JPRB,0.78193E-06_JPRB,0.77615E-06_JPRB,0.42133E-06_JPRB /)  
KB(:, 3,56, 6) = (/ &
 & 0.27573E-07_JPRB,0.73422E-06_JPRB,0.88059E-06_JPRB,0.87848E-06_JPRB,0.49387E-06_JPRB /)  
KB(:, 4,56, 6) = (/ &
 & 0.31066E-07_JPRB,0.83083E-06_JPRB,0.99001E-06_JPRB,0.99604E-06_JPRB,0.57362E-06_JPRB /)  
KB(:, 5,56, 6) = (/ &
 & 0.34213E-07_JPRB,0.93302E-06_JPRB,0.11103E-05_JPRB,0.11271E-05_JPRB,0.65906E-06_JPRB /)  
KB(:, 1,57, 6) = (/ &
 & 0.15553E-07_JPRB,0.44221E-06_JPRB,0.55475E-06_JPRB,0.55051E-06_JPRB,0.28158E-06_JPRB /)  
KB(:, 2,57, 6) = (/ &
 & 0.18597E-07_JPRB,0.51387E-06_JPRB,0.62883E-06_JPRB,0.62381E-06_JPRB,0.33432E-06_JPRB /)  
KB(:, 3,57, 6) = (/ &
 & 0.21627E-07_JPRB,0.59165E-06_JPRB,0.71079E-06_JPRB,0.70768E-06_JPRB,0.39423E-06_JPRB /)  
KB(:, 4,57, 6) = (/ &
 & 0.24548E-07_JPRB,0.67286E-06_JPRB,0.80159E-06_JPRB,0.80451E-06_JPRB,0.46009E-06_JPRB /)  
KB(:, 5,57, 6) = (/ &
 & 0.27223E-07_JPRB,0.75870E-06_JPRB,0.90196E-06_JPRB,0.91372E-06_JPRB,0.53126E-06_JPRB /)  
KB(:, 1,58, 6) = (/ &
 & 0.11989E-07_JPRB,0.35271E-06_JPRB,0.44504E-06_JPRB,0.44164E-06_JPRB,0.22247E-06_JPRB /)  
KB(:, 2,58, 6) = (/ &
 & 0.14473E-07_JPRB,0.41167E-06_JPRB,0.50593E-06_JPRB,0.50179E-06_JPRB,0.26557E-06_JPRB /)  
KB(:, 3,58, 6) = (/ &
 & 0.16959E-07_JPRB,0.47681E-06_JPRB,0.57389E-06_JPRB,0.57055E-06_JPRB,0.31488E-06_JPRB /)  
KB(:, 4,58, 6) = (/ &
 & 0.19386E-07_JPRB,0.54503E-06_JPRB,0.64933E-06_JPRB,0.65043E-06_JPRB,0.36927E-06_JPRB /)  
KB(:, 5,58, 6) = (/ &
 & 0.21655E-07_JPRB,0.61705E-06_JPRB,0.73285E-06_JPRB,0.74092E-06_JPRB,0.42823E-06_JPRB /)  
KB(:, 1,59, 6) = (/ &
 & 0.95745E-08_JPRB,0.28909E-06_JPRB,0.36504E-06_JPRB,0.36221E-06_JPRB,0.18143E-06_JPRB /)  
KB(:, 2,59, 6) = (/ &
 & 0.11602E-07_JPRB,0.33869E-06_JPRB,0.41625E-06_JPRB,0.41267E-06_JPRB,0.21754E-06_JPRB /)  
KB(:, 3,59, 6) = (/ &
 & 0.13639E-07_JPRB,0.39363E-06_JPRB,0.47345E-06_JPRB,0.47053E-06_JPRB,0.25873E-06_JPRB /)  
KB(:, 4,59, 6) = (/ &
 & 0.15635E-07_JPRB,0.45132E-06_JPRB,0.53722E-06_JPRB,0.53779E-06_JPRB,0.30436E-06_JPRB /)  
KB(:, 5,59, 6) = (/ &
 & 0.17515E-07_JPRB,0.51255E-06_JPRB,0.60804E-06_JPRB,0.61445E-06_JPRB,0.35395E-06_JPRB /)  
KB(:, 1,13, 7) = (/ &
 & 0.13818E-02_JPRB,0.53095E-02_JPRB,0.61744E-02_JPRB,0.61409E-02_JPRB,0.38201E-02_JPRB /)  
KB(:, 2,13, 7) = (/ &
 & 0.14927E-02_JPRB,0.54262E-02_JPRB,0.63169E-02_JPRB,0.63268E-02_JPRB,0.39787E-02_JPRB /)  
KB(:, 3,13, 7) = (/ &
 & 0.15882E-02_JPRB,0.55245E-02_JPRB,0.64575E-02_JPRB,0.65042E-02_JPRB,0.41285E-02_JPRB /)  
KB(:, 4,13, 7) = (/ &
 & 0.16683E-02_JPRB,0.56028E-02_JPRB,0.65859E-02_JPRB,0.66764E-02_JPRB,0.42766E-02_JPRB /)  
KB(:, 5,13, 7) = (/ &
 & 0.17364E-02_JPRB,0.56642E-02_JPRB,0.66996E-02_JPRB,0.68400E-02_JPRB,0.44196E-02_JPRB /)  
KB(:, 1,14, 7) = (/ &
 & 0.11439E-02_JPRB,0.44642E-02_JPRB,0.52052E-02_JPRB,0.51954E-02_JPRB,0.32185E-02_JPRB /)  
KB(:, 2,14, 7) = (/ &
 & 0.12322E-02_JPRB,0.45612E-02_JPRB,0.53295E-02_JPRB,0.53554E-02_JPRB,0.33544E-02_JPRB /)  
KB(:, 3,14, 7) = (/ &
 & 0.13082E-02_JPRB,0.46425E-02_JPRB,0.54474E-02_JPRB,0.55111E-02_JPRB,0.34869E-02_JPRB /)  
KB(:, 4,14, 7) = (/ &
 & 0.13723E-02_JPRB,0.47078E-02_JPRB,0.55568E-02_JPRB,0.56605E-02_JPRB,0.36178E-02_JPRB /)  
KB(:, 5,14, 7) = (/ &
 & 0.14273E-02_JPRB,0.47614E-02_JPRB,0.56536E-02_JPRB,0.58004E-02_JPRB,0.37445E-02_JPRB /)  
KB(:, 1,15, 7) = (/ &
 & 0.94600E-03_JPRB,0.37452E-02_JPRB,0.43786E-02_JPRB,0.43839E-02_JPRB,0.27064E-02_JPRB /)  
KB(:, 2,15, 7) = (/ &
 & 0.10166E-02_JPRB,0.38272E-02_JPRB,0.44845E-02_JPRB,0.45238E-02_JPRB,0.28259E-02_JPRB /)  
KB(:, 3,15, 7) = (/ &
 & 0.10772E-02_JPRB,0.38951E-02_JPRB,0.45852E-02_JPRB,0.46569E-02_JPRB,0.29424E-02_JPRB /)  
KB(:, 4,15, 7) = (/ &
 & 0.11287E-02_JPRB,0.39508E-02_JPRB,0.46776E-02_JPRB,0.47856E-02_JPRB,0.30573E-02_JPRB /)  
KB(:, 5,15, 7) = (/ &
 & 0.11727E-02_JPRB,0.39984E-02_JPRB,0.47639E-02_JPRB,0.49094E-02_JPRB,0.31707E-02_JPRB /)  
KB(:, 1,16, 7) = (/ &
 & 0.78170E-03_JPRB,0.31386E-02_JPRB,0.36753E-02_JPRB,0.36925E-02_JPRB,0.22749E-02_JPRB /)  
KB(:, 2,16, 7) = (/ &
 & 0.83828E-03_JPRB,0.32067E-02_JPRB,0.37655E-02_JPRB,0.38108E-02_JPRB,0.23791E-02_JPRB /)  
KB(:, 3,16, 7) = (/ &
 & 0.88677E-03_JPRB,0.32636E-02_JPRB,0.38524E-02_JPRB,0.39267E-02_JPRB,0.24809E-02_JPRB /)  
KB(:, 4,16, 7) = (/ &
 & 0.92814E-03_JPRB,0.33127E-02_JPRB,0.39332E-02_JPRB,0.40389E-02_JPRB,0.25819E-02_JPRB /)  
KB(:, 5,16, 7) = (/ &
 & 0.96342E-03_JPRB,0.33561E-02_JPRB,0.40123E-02_JPRB,0.41493E-02_JPRB,0.26825E-02_JPRB /)  
KB(:, 1,17, 7) = (/ &
 & 0.64513E-03_JPRB,0.26258E-02_JPRB,0.30792E-02_JPRB,0.31027E-02_JPRB,0.19109E-02_JPRB /)  
KB(:, 2,17, 7) = (/ &
 & 0.69065E-03_JPRB,0.26830E-02_JPRB,0.31573E-02_JPRB,0.32056E-02_JPRB,0.20013E-02_JPRB /)  
KB(:, 3,17, 7) = (/ &
 & 0.72951E-03_JPRB,0.27321E-02_JPRB,0.32326E-02_JPRB,0.33061E-02_JPRB,0.20905E-02_JPRB /)  
KB(:, 4,17, 7) = (/ &
 & 0.76279E-03_JPRB,0.27759E-02_JPRB,0.33057E-02_JPRB,0.34049E-02_JPRB,0.21791E-02_JPRB /)  
KB(:, 5,17, 7) = (/ &
 & 0.79127E-03_JPRB,0.28164E-02_JPRB,0.33776E-02_JPRB,0.35037E-02_JPRB,0.22680E-02_JPRB /)  
KB(:, 1,18, 7) = (/ &
 & 0.53216E-03_JPRB,0.21945E-02_JPRB,0.25768E-02_JPRB,0.26041E-02_JPRB,0.16047E-02_JPRB /)  
KB(:, 2,18, 7) = (/ &
 & 0.56878E-03_JPRB,0.22431E-02_JPRB,0.26453E-02_JPRB,0.26934E-02_JPRB,0.16829E-02_JPRB /)  
KB(:, 3,18, 7) = (/ &
 & 0.60002E-03_JPRB,0.22864E-02_JPRB,0.27121E-02_JPRB,0.27812E-02_JPRB,0.17605E-02_JPRB /)  
KB(:, 4,18, 7) = (/ &
 & 0.62666E-03_JPRB,0.23265E-02_JPRB,0.27778E-02_JPRB,0.28689E-02_JPRB,0.18389E-02_JPRB /)  
KB(:, 5,18, 7) = (/ &
 & 0.64956E-03_JPRB,0.23645E-02_JPRB,0.28436E-02_JPRB,0.29587E-02_JPRB,0.19175E-02_JPRB /)  
KB(:, 1,19, 7) = (/ &
 & 0.43878E-03_JPRB,0.18328E-02_JPRB,0.21555E-02_JPRB,0.21844E-02_JPRB,0.13470E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART21',1,ZHOOK_HANDLE)
END SUBROUTINE PART21


SUBROUTINE PART22

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART22',0,ZHOOK_HANDLE)


KB(:, 2,19, 7) = (/ &
 & 0.46832E-03_JPRB,0.18749E-02_JPRB,0.22160E-02_JPRB,0.22619E-02_JPRB,0.14147E-02_JPRB /)  
KB(:, 3,19, 7) = (/ &
 & 0.49337E-03_JPRB,0.19136E-02_JPRB,0.22752E-02_JPRB,0.23395E-02_JPRB,0.14834E-02_JPRB /)  
KB(:, 4,19, 7) = (/ &
 & 0.51483E-03_JPRB,0.19509E-02_JPRB,0.23344E-02_JPRB,0.24177E-02_JPRB,0.15526E-02_JPRB /)  
KB(:, 5,19, 7) = (/ &
 & 0.53321E-03_JPRB,0.19863E-02_JPRB,0.23950E-02_JPRB,0.24983E-02_JPRB,0.16228E-02_JPRB /)  
KB(:, 1,20, 7) = (/ &
 & 0.36218E-03_JPRB,0.15310E-02_JPRB,0.18044E-02_JPRB,0.18333E-02_JPRB,0.11320E-02_JPRB /)  
KB(:, 2,20, 7) = (/ &
 & 0.38587E-03_JPRB,0.15681E-02_JPRB,0.18573E-02_JPRB,0.19010E-02_JPRB,0.11911E-02_JPRB /)  
KB(:, 3,20, 7) = (/ &
 & 0.40599E-03_JPRB,0.16034E-02_JPRB,0.19105E-02_JPRB,0.19693E-02_JPRB,0.12516E-02_JPRB /)  
KB(:, 4,20, 7) = (/ &
 & 0.42327E-03_JPRB,0.16372E-02_JPRB,0.19642E-02_JPRB,0.20400E-02_JPRB,0.13133E-02_JPRB /)  
KB(:, 5,20, 7) = (/ &
 & 0.43800E-03_JPRB,0.16702E-02_JPRB,0.20196E-02_JPRB,0.21120E-02_JPRB,0.13760E-02_JPRB /)  
KB(:, 1,21, 7) = (/ &
 & 0.29894E-03_JPRB,0.12794E-02_JPRB,0.15109E-02_JPRB,0.15392E-02_JPRB,0.95196E-03_JPRB /)  
KB(:, 2,21, 7) = (/ &
 & 0.31795E-03_JPRB,0.13126E-02_JPRB,0.15578E-02_JPRB,0.15985E-02_JPRB,0.10041E-02_JPRB /)  
KB(:, 3,21, 7) = (/ &
 & 0.33409E-03_JPRB,0.13444E-02_JPRB,0.16054E-02_JPRB,0.16590E-02_JPRB,0.10575E-02_JPRB /)  
KB(:, 4,21, 7) = (/ &
 & 0.34798E-03_JPRB,0.13752E-02_JPRB,0.16542E-02_JPRB,0.17228E-02_JPRB,0.11124E-02_JPRB /)  
KB(:, 5,21, 7) = (/ &
 & 0.35982E-03_JPRB,0.14062E-02_JPRB,0.17046E-02_JPRB,0.17872E-02_JPRB,0.11688E-02_JPRB /)  
KB(:, 1,22, 7) = (/ &
 & 0.24779E-03_JPRB,0.10720E-02_JPRB,0.12687E-02_JPRB,0.12959E-02_JPRB,0.80428E-03_JPRB /)  
KB(:, 2,22, 7) = (/ &
 & 0.26287E-03_JPRB,0.11012E-02_JPRB,0.13104E-02_JPRB,0.13483E-02_JPRB,0.85046E-03_JPRB /)  
KB(:, 3,22, 7) = (/ &
 & 0.27570E-03_JPRB,0.11300E-02_JPRB,0.13532E-02_JPRB,0.14032E-02_JPRB,0.89796E-03_JPRB /)  
KB(:, 4,22, 7) = (/ &
 & 0.28676E-03_JPRB,0.11583E-02_JPRB,0.13978E-02_JPRB,0.14602E-02_JPRB,0.94722E-03_JPRB /)  
KB(:, 5,22, 7) = (/ &
 & 0.29612E-03_JPRB,0.11873E-02_JPRB,0.14439E-02_JPRB,0.15185E-02_JPRB,0.99812E-03_JPRB /)  
KB(:, 1,23, 7) = (/ &
 & 0.20536E-03_JPRB,0.89901E-03_JPRB,0.10666E-02_JPRB,0.10925E-02_JPRB,0.68077E-03_JPRB /)  
KB(:, 2,23, 7) = (/ &
 & 0.21732E-03_JPRB,0.92514E-03_JPRB,0.11037E-02_JPRB,0.11394E-02_JPRB,0.72189E-03_JPRB /)  
KB(:, 3,23, 7) = (/ &
 & 0.22752E-03_JPRB,0.95109E-03_JPRB,0.11426E-02_JPRB,0.11888E-02_JPRB,0.76437E-03_JPRB /)  
KB(:, 4,23, 7) = (/ &
 & 0.23632E-03_JPRB,0.97728E-03_JPRB,0.11832E-02_JPRB,0.12403E-02_JPRB,0.80877E-03_JPRB /)  
KB(:, 5,23, 7) = (/ &
 & 0.24369E-03_JPRB,0.10040E-02_JPRB,0.12260E-02_JPRB,0.12934E-02_JPRB,0.85489E-03_JPRB /)  
KB(:, 1,24, 7) = (/ &
 & 0.17021E-03_JPRB,0.75506E-03_JPRB,0.89800E-03_JPRB,0.92265E-03_JPRB,0.57788E-03_JPRB /)  
KB(:, 2,24, 7) = (/ &
 & 0.17969E-03_JPRB,0.77853E-03_JPRB,0.93149E-03_JPRB,0.96497E-03_JPRB,0.61443E-03_JPRB /)  
KB(:, 3,24, 7) = (/ &
 & 0.18778E-03_JPRB,0.80207E-03_JPRB,0.96680E-03_JPRB,0.10097E-02_JPRB,0.65278E-03_JPRB /)  
KB(:, 4,24, 7) = (/ &
 & 0.19477E-03_JPRB,0.82622E-03_JPRB,0.10041E-02_JPRB,0.10564E-02_JPRB,0.69293E-03_JPRB /)  
KB(:, 5,24, 7) = (/ &
 & 0.20055E-03_JPRB,0.85104E-03_JPRB,0.10439E-02_JPRB,0.11053E-02_JPRB,0.73424E-03_JPRB /)  
KB(:, 1,25, 7) = (/ &
 & 0.14110E-03_JPRB,0.63531E-03_JPRB,0.75746E-03_JPRB,0.78109E-03_JPRB,0.49195E-03_JPRB /)  
KB(:, 2,25, 7) = (/ &
 & 0.14860E-03_JPRB,0.65629E-03_JPRB,0.78801E-03_JPRB,0.81951E-03_JPRB,0.52472E-03_JPRB /)  
KB(:, 3,25, 7) = (/ &
 & 0.15502E-03_JPRB,0.67802E-03_JPRB,0.82018E-03_JPRB,0.86005E-03_JPRB,0.55929E-03_JPRB /)  
KB(:, 4,25, 7) = (/ &
 & 0.16054E-03_JPRB,0.70023E-03_JPRB,0.85487E-03_JPRB,0.90270E-03_JPRB,0.59546E-03_JPRB /)  
KB(:, 5,25, 7) = (/ &
 & 0.16506E-03_JPRB,0.72333E-03_JPRB,0.89213E-03_JPRB,0.94794E-03_JPRB,0.63296E-03_JPRB /)  
KB(:, 1,26, 7) = (/ &
 & 0.11704E-03_JPRB,0.53563E-03_JPRB,0.64089E-03_JPRB,0.66348E-03_JPRB,0.42036E-03_JPRB /)  
KB(:, 2,26, 7) = (/ &
 & 0.12296E-03_JPRB,0.55482E-03_JPRB,0.66859E-03_JPRB,0.69842E-03_JPRB,0.44986E-03_JPRB /)  
KB(:, 3,26, 7) = (/ &
 & 0.12804E-03_JPRB,0.57460E-03_JPRB,0.69838E-03_JPRB,0.73532E-03_JPRB,0.48115E-03_JPRB /)  
KB(:, 4,26, 7) = (/ &
 & 0.13237E-03_JPRB,0.59528E-03_JPRB,0.73081E-03_JPRB,0.77472E-03_JPRB,0.51371E-03_JPRB /)  
KB(:, 5,26, 7) = (/ &
 & 0.13587E-03_JPRB,0.61708E-03_JPRB,0.76562E-03_JPRB,0.81649E-03_JPRB,0.54800E-03_JPRB /)  
KB(:, 1,27, 7) = (/ &
 & 0.97037E-04_JPRB,0.45263E-03_JPRB,0.54353E-03_JPRB,0.56528E-03_JPRB,0.36031E-03_JPRB /)  
KB(:, 2,27, 7) = (/ &
 & 0.10171E-03_JPRB,0.47018E-03_JPRB,0.56899E-03_JPRB,0.59710E-03_JPRB,0.38698E-03_JPRB /)  
KB(:, 3,27, 7) = (/ &
 & 0.10572E-03_JPRB,0.48833E-03_JPRB,0.59675E-03_JPRB,0.63096E-03_JPRB,0.41505E-03_JPRB /)  
KB(:, 4,27, 7) = (/ &
 & 0.10911E-03_JPRB,0.50767E-03_JPRB,0.62713E-03_JPRB,0.66736E-03_JPRB,0.44466E-03_JPRB /)  
KB(:, 5,27, 7) = (/ &
 & 0.11182E-03_JPRB,0.52830E-03_JPRB,0.65949E-03_JPRB,0.70600E-03_JPRB,0.47625E-03_JPRB /)  
KB(:, 1,28, 7) = (/ &
 & 0.80419E-04_JPRB,0.38349E-03_JPRB,0.46224E-03_JPRB,0.48308E-03_JPRB,0.30982E-03_JPRB /)  
KB(:, 2,28, 7) = (/ &
 & 0.84110E-04_JPRB,0.39943E-03_JPRB,0.48584E-03_JPRB,0.51214E-03_JPRB,0.33386E-03_JPRB /)  
KB(:, 3,28, 7) = (/ &
 & 0.87283E-04_JPRB,0.41636E-03_JPRB,0.51189E-03_JPRB,0.54353E-03_JPRB,0.35924E-03_JPRB /)  
KB(:, 4,28, 7) = (/ &
 & 0.89914E-04_JPRB,0.43456E-03_JPRB,0.54020E-03_JPRB,0.57698E-03_JPRB,0.38635E-03_JPRB /)  
KB(:, 5,28, 7) = (/ &
 & 0.92003E-04_JPRB,0.45406E-03_JPRB,0.57030E-03_JPRB,0.61286E-03_JPRB,0.41553E-03_JPRB /)  
KB(:, 1,29, 7) = (/ &
 & 0.66637E-04_JPRB,0.32580E-03_JPRB,0.39453E-03_JPRB,0.41439E-03_JPRB,0.26738E-03_JPRB /)  
KB(:, 2,29, 7) = (/ &
 & 0.69552E-04_JPRB,0.34052E-03_JPRB,0.41660E-03_JPRB,0.44116E-03_JPRB,0.28904E-03_JPRB /)  
KB(:, 3,29, 7) = (/ &
 & 0.72042E-04_JPRB,0.35633E-03_JPRB,0.44102E-03_JPRB,0.47005E-03_JPRB,0.31218E-03_JPRB /)  
KB(:, 4,29, 7) = (/ &
 & 0.74082E-04_JPRB,0.37351E-03_JPRB,0.46731E-03_JPRB,0.50108E-03_JPRB,0.33714E-03_JPRB /)  
KB(:, 5,29, 7) = (/ &
 & 0.75692E-04_JPRB,0.39190E-03_JPRB,0.49529E-03_JPRB,0.53447E-03_JPRB,0.36421E-03_JPRB /)  
KB(:, 1,30, 7) = (/ &
 & 0.55194E-04_JPRB,0.27757E-03_JPRB,0.33804E-03_JPRB,0.35670E-03_JPRB,0.23148E-03_JPRB /)  
KB(:, 2,30, 7) = (/ &
 & 0.57489E-04_JPRB,0.29130E-03_JPRB,0.35876E-03_JPRB,0.38143E-03_JPRB,0.25115E-03_JPRB /)  
KB(:, 3,30, 7) = (/ &
 & 0.59445E-04_JPRB,0.30619E-03_JPRB,0.38148E-03_JPRB,0.40810E-03_JPRB,0.27242E-03_JPRB /)  
KB(:, 4,30, 7) = (/ &
 & 0.61024E-04_JPRB,0.32233E-03_JPRB,0.40578E-03_JPRB,0.43698E-03_JPRB,0.29552E-03_JPRB /)  
KB(:, 5,30, 7) = (/ &
 & 0.62251E-04_JPRB,0.33969E-03_JPRB,0.43185E-03_JPRB,0.46830E-03_JPRB,0.32052E-03_JPRB /)  
KB(:, 1,31, 7) = (/ &
 & 0.45701E-04_JPRB,0.23736E-03_JPRB,0.29086E-03_JPRB,0.30834E-03_JPRB,0.20114E-03_JPRB /)  
KB(:, 2,31, 7) = (/ &
 & 0.47516E-04_JPRB,0.25020E-03_JPRB,0.31032E-03_JPRB,0.33113E-03_JPRB,0.21916E-03_JPRB /)  
KB(:, 3,31, 7) = (/ &
 & 0.49034E-04_JPRB,0.26424E-03_JPRB,0.33131E-03_JPRB,0.35593E-03_JPRB,0.23874E-03_JPRB /)  
KB(:, 4,31, 7) = (/ &
 & 0.50247E-04_JPRB,0.27943E-03_JPRB,0.35395E-03_JPRB,0.38299E-03_JPRB,0.26024E-03_JPRB /)  
KB(:, 5,31, 7) = (/ &
 & 0.51186E-04_JPRB,0.29578E-03_JPRB,0.37829E-03_JPRB,0.41250E-03_JPRB,0.28341E-03_JPRB /)  
KB(:, 1,32, 7) = (/ &
 & 0.37829E-04_JPRB,0.20379E-03_JPRB,0.25145E-03_JPRB,0.26761E-03_JPRB,0.17549E-03_JPRB /)  
KB(:, 2,32, 7) = (/ &
 & 0.39256E-04_JPRB,0.21585E-03_JPRB,0.26951E-03_JPRB,0.28871E-03_JPRB,0.19207E-03_JPRB /)  
KB(:, 3,32, 7) = (/ &
 & 0.40434E-04_JPRB,0.22904E-03_JPRB,0.28903E-03_JPRB,0.31192E-03_JPRB,0.21034E-03_JPRB /)  
KB(:, 4,32, 7) = (/ &
 & 0.41367E-04_JPRB,0.24332E-03_JPRB,0.31020E-03_JPRB,0.33744E-03_JPRB,0.23024E-03_JPRB /)  
KB(:, 5,32, 7) = (/ &
 & 0.42072E-04_JPRB,0.25873E-03_JPRB,0.33309E-03_JPRB,0.36527E-03_JPRB,0.25179E-03_JPRB /)  
KB(:, 1,33, 7) = (/ &
 & 0.31302E-04_JPRB,0.17572E-03_JPRB,0.21830E-03_JPRB,0.23321E-03_JPRB,0.15375E-03_JPRB /)  
KB(:, 2,33, 7) = (/ &
 & 0.32419E-04_JPRB,0.18706E-03_JPRB,0.23504E-03_JPRB,0.25291E-03_JPRB,0.16915E-03_JPRB /)  
KB(:, 3,33, 7) = (/ &
 & 0.33327E-04_JPRB,0.19940E-03_JPRB,0.25328E-03_JPRB,0.27479E-03_JPRB,0.18617E-03_JPRB /)  
KB(:, 4,33, 7) = (/ &
 & 0.34039E-04_JPRB,0.21283E-03_JPRB,0.27315E-03_JPRB,0.29887E-03_JPRB,0.20465E-03_JPRB /)  
KB(:, 5,33, 7) = (/ &
 & 0.34568E-04_JPRB,0.22731E-03_JPRB,0.29474E-03_JPRB,0.32519E-03_JPRB,0.22485E-03_JPRB /)  
KB(:, 1,34, 7) = (/ &
 & 0.25851E-04_JPRB,0.15182E-03_JPRB,0.18976E-03_JPRB,0.20353E-03_JPRB,0.13483E-03_JPRB /)  
KB(:, 2,34, 7) = (/ &
 & 0.26731E-04_JPRB,0.16241E-03_JPRB,0.20531E-03_JPRB,0.22199E-03_JPRB,0.14918E-03_JPRB /)  
KB(:, 3,34, 7) = (/ &
 & 0.27437E-04_JPRB,0.17395E-03_JPRB,0.22237E-03_JPRB,0.24258E-03_JPRB,0.16491E-03_JPRB /)  
KB(:, 4,34, 7) = (/ &
 & 0.27988E-04_JPRB,0.18656E-03_JPRB,0.24113E-03_JPRB,0.26529E-03_JPRB,0.18217E-03_JPRB /)  
KB(:, 5,34, 7) = (/ &
 & 0.28384E-04_JPRB,0.20017E-03_JPRB,0.26144E-03_JPRB,0.29020E-03_JPRB,0.20116E-03_JPRB /)  
KB(:, 1,35, 7) = (/ &
 & 0.21271E-04_JPRB,0.13078E-03_JPRB,0.16426E-03_JPRB,0.17685E-03_JPRB,0.11756E-03_JPRB /)  
KB(:, 2,35, 7) = (/ &
 & 0.21975E-04_JPRB,0.14058E-03_JPRB,0.17865E-03_JPRB,0.19403E-03_JPRB,0.13072E-03_JPRB /)  
KB(:, 3,35, 7) = (/ &
 & 0.22533E-04_JPRB,0.15132E-03_JPRB,0.19456E-03_JPRB,0.21323E-03_JPRB,0.14523E-03_JPRB /)  
KB(:, 4,35, 7) = (/ &
 & 0.22966E-04_JPRB,0.16307E-03_JPRB,0.21206E-03_JPRB,0.23454E-03_JPRB,0.16133E-03_JPRB /)  
KB(:, 5,35, 7) = (/ &
 & 0.23274E-04_JPRB,0.17579E-03_JPRB,0.23112E-03_JPRB,0.25800E-03_JPRB,0.17911E-03_JPRB /)  
KB(:, 1,36, 7) = (/ &
 & 0.17431E-04_JPRB,0.11205E-03_JPRB,0.14128E-03_JPRB,0.15260E-03_JPRB,0.10161E-03_JPRB /)  
KB(:, 2,36, 7) = (/ &
 & 0.18004E-04_JPRB,0.12103E-03_JPRB,0.15448E-03_JPRB,0.16840E-03_JPRB,0.11356E-03_JPRB /)  
KB(:, 3,36, 7) = (/ &
 & 0.18458E-04_JPRB,0.13095E-03_JPRB,0.16918E-03_JPRB,0.18616E-03_JPRB,0.12687E-03_JPRB /)  
KB(:, 4,36, 7) = (/ &
 & 0.18810E-04_JPRB,0.14182E-03_JPRB,0.18539E-03_JPRB,0.20596E-03_JPRB,0.14179E-03_JPRB /)  
KB(:, 5,36, 7) = (/ &
 & 0.19059E-04_JPRB,0.15363E-03_JPRB,0.20317E-03_JPRB,0.22788E-03_JPRB,0.15831E-03_JPRB /)  
KB(:, 1,37, 7) = (/ &
 & 0.14204E-04_JPRB,0.95010E-04_JPRB,0.12008E-03_JPRB,0.12996E-03_JPRB,0.86482E-04_JPRB /)  
KB(:, 2,37, 7) = (/ &
 & 0.14685E-04_JPRB,0.10313E-03_JPRB,0.13200E-03_JPRB,0.14426E-03_JPRB,0.97179E-04_JPRB /)  
KB(:, 3,37, 7) = (/ &
 & 0.15069E-04_JPRB,0.11214E-03_JPRB,0.14536E-03_JPRB,0.16042E-03_JPRB,0.10922E-03_JPRB /)  
KB(:, 4,37, 7) = (/ &
 & 0.15369E-04_JPRB,0.12211E-03_JPRB,0.16020E-03_JPRB,0.17855E-03_JPRB,0.12282E-03_JPRB /)  
KB(:, 5,37, 7) = (/ &
 & 0.15586E-04_JPRB,0.13296E-03_JPRB,0.17661E-03_JPRB,0.19876E-03_JPRB,0.13797E-03_JPRB /)  
KB(:, 1,38, 7) = (/ &
 & 0.11571E-04_JPRB,0.80545E-04_JPRB,0.10206E-03_JPRB,0.11063E-03_JPRB,0.73563E-04_JPRB /)  
KB(:, 2,38, 7) = (/ &
 & 0.11976E-04_JPRB,0.87875E-04_JPRB,0.11281E-03_JPRB,0.12357E-03_JPRB,0.83149E-04_JPRB /)  
KB(:, 3,38, 7) = (/ &
 & 0.12301E-04_JPRB,0.96063E-04_JPRB,0.12495E-03_JPRB,0.13829E-03_JPRB,0.94026E-04_JPRB /)  
KB(:, 4,38, 7) = (/ &
 & 0.12557E-04_JPRB,0.10518E-03_JPRB,0.13851E-03_JPRB,0.15487E-03_JPRB,0.10642E-03_JPRB /)  
KB(:, 5,38, 7) = (/ &
 & 0.12744E-04_JPRB,0.11515E-03_JPRB,0.15364E-03_JPRB,0.17352E-03_JPRB,0.12029E-03_JPRB /)  
KB(:, 1,39, 7) = (/ &
 & 0.94254E-05_JPRB,0.68333E-04_JPRB,0.86798E-04_JPRB,0.94247E-04_JPRB,0.62604E-04_JPRB /)  
KB(:, 2,39, 7) = (/ &
 & 0.97657E-05_JPRB,0.74945E-04_JPRB,0.96495E-04_JPRB,0.10595E-03_JPRB,0.71185E-04_JPRB /)  
KB(:, 3,39, 7) = (/ &
 & 0.10041E-04_JPRB,0.82376E-04_JPRB,0.10752E-03_JPRB,0.11934E-03_JPRB,0.81022E-04_JPRB /)  
KB(:, 4,39, 7) = (/ &
 & 0.10258E-04_JPRB,0.90687E-04_JPRB,0.11992E-03_JPRB,0.13453E-03_JPRB,0.92315E-04_JPRB /)  
KB(:, 5,39, 7) = (/ &
 & 0.10419E-04_JPRB,0.99852E-04_JPRB,0.13387E-03_JPRB,0.15177E-03_JPRB,0.10504E-03_JPRB /)  
KB(:, 1,40, 7) = (/ &
 & 0.76452E-05_JPRB,0.57428E-04_JPRB,0.73021E-04_JPRB,0.79333E-04_JPRB,0.52568E-04_JPRB /)  
KB(:, 2,40, 7) = (/ &
 & 0.79354E-05_JPRB,0.63315E-04_JPRB,0.81650E-04_JPRB,0.89752E-04_JPRB,0.60144E-04_JPRB /)  
KB(:, 3,40, 7) = (/ &
 & 0.81739E-05_JPRB,0.69961E-04_JPRB,0.91542E-04_JPRB,0.10176E-03_JPRB,0.68905E-04_JPRB /)  
KB(:, 4,40, 7) = (/ &
 & 0.83626E-05_JPRB,0.77456E-04_JPRB,0.10275E-03_JPRB,0.11552E-03_JPRB,0.79059E-04_JPRB /)  
KB(:, 5,40, 7) = (/ &
 & 0.85064E-05_JPRB,0.85795E-04_JPRB,0.11542E-03_JPRB,0.13128E-03_JPRB,0.90578E-04_JPRB /)  
KB(:, 1,41, 7) = (/ &
 & 0.61953E-05_JPRB,0.48163E-04_JPRB,0.61287E-04_JPRB,0.66616E-04_JPRB,0.44011E-04_JPRB /)  
KB(:, 2,41, 7) = (/ &
 & 0.64418E-05_JPRB,0.53383E-04_JPRB,0.68934E-04_JPRB,0.75842E-04_JPRB,0.50670E-04_JPRB /)  
KB(:, 3,41, 7) = (/ &
 & 0.66484E-05_JPRB,0.59312E-04_JPRB,0.77785E-04_JPRB,0.86580E-04_JPRB,0.58448E-04_JPRB /)  
KB(:, 4,41, 7) = (/ &
 & 0.68134E-05_JPRB,0.66054E-04_JPRB,0.87876E-04_JPRB,0.98995E-04_JPRB,0.67543E-04_JPRB /)  
KB(:, 5,41, 7) = (/ &
 & 0.69402E-05_JPRB,0.73614E-04_JPRB,0.99378E-04_JPRB,0.11337E-03_JPRB,0.77942E-04_JPRB /)  
KB(:, 1,42, 7) = (/ &
 & 0.50170E-05_JPRB,0.40358E-04_JPRB,0.51378E-04_JPRB,0.55875E-04_JPRB,0.36794E-04_JPRB /)  
KB(:, 2,42, 7) = (/ &
 & 0.52266E-05_JPRB,0.44971E-04_JPRB,0.58141E-04_JPRB,0.64024E-04_JPRB,0.42639E-04_JPRB /)  
KB(:, 3,42, 7) = (/ &
 & 0.54046E-05_JPRB,0.50250E-04_JPRB,0.66034E-04_JPRB,0.73601E-04_JPRB,0.49527E-04_JPRB /)  
KB(:, 4,42, 7) = (/ &
 & 0.55484E-05_JPRB,0.56302E-04_JPRB,0.75111E-04_JPRB,0.84788E-04_JPRB,0.57654E-04_JPRB /)  
KB(:, 5,42, 7) = (/ &
 & 0.56600E-05_JPRB,0.63153E-04_JPRB,0.85551E-04_JPRB,0.97898E-04_JPRB,0.67040E-04_JPRB /)  
KB(:, 1,43, 7) = (/ &
 & 0.40498E-05_JPRB,0.33563E-04_JPRB,0.42716E-04_JPRB,0.46433E-04_JPRB,0.30447E-04_JPRB /)  
KB(:, 2,43, 7) = (/ &
 & 0.42291E-05_JPRB,0.37603E-04_JPRB,0.48619E-04_JPRB,0.53551E-04_JPRB,0.35516E-04_JPRB /)  
KB(:, 3,43, 7) = (/ &
 & 0.43833E-05_JPRB,0.42260E-04_JPRB,0.55585E-04_JPRB,0.61999E-04_JPRB,0.41549E-04_JPRB /)  
KB(:, 4,43, 7) = (/ &
 & 0.45099E-05_JPRB,0.47650E-04_JPRB,0.63668E-04_JPRB,0.71964E-04_JPRB,0.48728E-04_JPRB /)  
KB(:, 5,43, 7) = (/ &
 & 0.46096E-05_JPRB,0.53790E-04_JPRB,0.73053E-04_JPRB,0.83779E-04_JPRB,0.57105E-04_JPRB /)  
KB(:, 1,44, 7) = (/ &
 & 0.32616E-05_JPRB,0.27781E-04_JPRB,0.35335E-04_JPRB,0.38366E-04_JPRB,0.25032E-04_JPRB /)  
KB(:, 2,44, 7) = (/ &
 & 0.34164E-05_JPRB,0.31296E-04_JPRB,0.40444E-04_JPRB,0.44531E-04_JPRB,0.29399E-04_JPRB /)  
KB(:, 3,44, 7) = (/ &
 & 0.35491E-05_JPRB,0.35375E-04_JPRB,0.46540E-04_JPRB,0.51925E-04_JPRB,0.34633E-04_JPRB /)  
KB(:, 4,44, 7) = (/ &
 & 0.36610E-05_JPRB,0.40146E-04_JPRB,0.53687E-04_JPRB,0.60738E-04_JPRB,0.40935E-04_JPRB /)  
KB(:, 5,44, 7) = (/ &
 & 0.37500E-05_JPRB,0.45618E-04_JPRB,0.62061E-04_JPRB,0.71298E-04_JPRB,0.48356E-04_JPRB /)  
KB(:, 1,45, 7) = (/ &
 & 0.26238E-05_JPRB,0.22952E-04_JPRB,0.29162E-04_JPRB,0.31630E-04_JPRB,0.20522E-04_JPRB /)  
KB(:, 2,45, 7) = (/ &
 & 0.27571E-05_JPRB,0.25992E-04_JPRB,0.33567E-04_JPRB,0.36938E-04_JPRB,0.24268E-04_JPRB /)  
KB(:, 3,45, 7) = (/ &
 & 0.28713E-05_JPRB,0.29549E-04_JPRB,0.38881E-04_JPRB,0.43383E-04_JPRB,0.28792E-04_JPRB /)  
KB(:, 4,45, 7) = (/ &
 & 0.29693E-05_JPRB,0.33760E-04_JPRB,0.45177E-04_JPRB,0.51149E-04_JPRB,0.34303E-04_JPRB /)  
KB(:, 5,45, 7) = (/ &
 & 0.30482E-05_JPRB,0.38627E-04_JPRB,0.52624E-04_JPRB,0.60551E-04_JPRB,0.40857E-04_JPRB /)  
KB(:, 1,46, 7) = (/ &
 & 0.21051E-05_JPRB,0.18867E-04_JPRB,0.23935E-04_JPRB,0.25917E-04_JPRB,0.16710E-04_JPRB /)  
KB(:, 2,46, 7) = (/ &
 & 0.22206E-05_JPRB,0.21480E-04_JPRB,0.27705E-04_JPRB,0.30449E-04_JPRB,0.19893E-04_JPRB /)  
KB(:, 3,46, 7) = (/ &
 & 0.23191E-05_JPRB,0.24557E-04_JPRB,0.32298E-04_JPRB,0.36019E-04_JPRB,0.23769E-04_JPRB /)  
KB(:, 4,46, 7) = (/ &
 & 0.24046E-05_JPRB,0.28239E-04_JPRB,0.37798E-04_JPRB,0.42807E-04_JPRB,0.28545E-04_JPRB /)  
KB(:, 5,46, 7) = (/ &
 & 0.24746E-05_JPRB,0.32543E-04_JPRB,0.44374E-04_JPRB,0.51109E-04_JPRB,0.34299E-04_JPRB /)  
KB(:, 1,47, 7) = (/ &
 & 0.16817E-05_JPRB,0.15386E-04_JPRB,0.19464E-04_JPRB,0.21024E-04_JPRB,0.13455E-04_JPRB /)  
KB(:, 2,47, 7) = (/ &
 & 0.17822E-05_JPRB,0.17605E-04_JPRB,0.22652E-04_JPRB,0.24840E-04_JPRB,0.16124E-04_JPRB /)  
KB(:, 3,47, 7) = (/ &
 & 0.18680E-05_JPRB,0.20236E-04_JPRB,0.26567E-04_JPRB,0.29585E-04_JPRB,0.19401E-04_JPRB /)  
KB(:, 4,47, 7) = (/ &
 & 0.19423E-05_JPRB,0.23413E-04_JPRB,0.31317E-04_JPRB,0.35433E-04_JPRB,0.23476E-04_JPRB /)  
KB(:, 5,47, 7) = (/ &
 & 0.20049E-05_JPRB,0.27181E-04_JPRB,0.37054E-04_JPRB,0.42668E-04_JPRB,0.28466E-04_JPRB /)  
KB(:, 1,48, 7) = (/ &
 & 0.13405E-05_JPRB,0.12514E-04_JPRB,0.15779E-04_JPRB,0.16993E-04_JPRB,0.10791E-04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART22',1,ZHOOK_HANDLE)
END SUBROUTINE PART22


SUBROUTINE PART23

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART23',0,ZHOOK_HANDLE)


KB(:, 2,48, 7) = (/ &
 & 0.14280E-05_JPRB,0.14385E-04_JPRB,0.18460E-04_JPRB,0.20187E-04_JPRB,0.13017E-04_JPRB /)  
KB(:, 3,48, 7) = (/ &
 & 0.15026E-05_JPRB,0.16623E-04_JPRB,0.21773E-04_JPRB,0.24205E-04_JPRB,0.15768E-04_JPRB /)  
KB(:, 4,48, 7) = (/ &
 & 0.15671E-05_JPRB,0.19354E-04_JPRB,0.25854E-04_JPRB,0.29218E-04_JPRB,0.19227E-04_JPRB /)  
KB(:, 5,48, 7) = (/ &
 & 0.16224E-05_JPRB,0.22629E-04_JPRB,0.30833E-04_JPRB,0.35479E-04_JPRB,0.23525E-04_JPRB /)  
KB(:, 1,49, 7) = (/ &
 & 0.10664E-05_JPRB,0.10149E-04_JPRB,0.12751E-04_JPRB,0.13684E-04_JPRB,0.86188E-05_JPRB /)  
KB(:, 2,49, 7) = (/ &
 & 0.11418E-05_JPRB,0.11720E-04_JPRB,0.14999E-04_JPRB,0.16352E-04_JPRB,0.10467E-04_JPRB /)  
KB(:, 3,49, 7) = (/ &
 & 0.12069E-05_JPRB,0.13612E-04_JPRB,0.17780E-04_JPRB,0.19716E-04_JPRB,0.12759E-04_JPRB /)  
KB(:, 4,49, 7) = (/ &
 & 0.12630E-05_JPRB,0.15945E-04_JPRB,0.21262E-04_JPRB,0.23990E-04_JPRB,0.15676E-04_JPRB /)  
KB(:, 5,49, 7) = (/ &
 & 0.13113E-05_JPRB,0.18775E-04_JPRB,0.25560E-04_JPRB,0.29382E-04_JPRB,0.19352E-04_JPRB /)  
KB(:, 1,50, 7) = (/ &
 & 0.84808E-06_JPRB,0.82401E-05_JPRB,0.10318E-04_JPRB,0.11036E-04_JPRB,0.68939E-05_JPRB /)  
KB(:, 2,50, 7) = (/ &
 & 0.91269E-06_JPRB,0.95513E-05_JPRB,0.12189E-04_JPRB,0.13247E-04_JPRB,0.84209E-05_JPRB /)  
KB(:, 3,50, 7) = (/ &
 & 0.96928E-06_JPRB,0.11160E-04_JPRB,0.14539E-04_JPRB,0.16084E-04_JPRB,0.10336E-04_JPRB /)  
KB(:, 4,50, 7) = (/ &
 & 0.10177E-05_JPRB,0.13146E-04_JPRB,0.17498E-04_JPRB,0.19711E-04_JPRB,0.12790E-04_JPRB /)  
KB(:, 5,50, 7) = (/ &
 & 0.10595E-05_JPRB,0.15592E-04_JPRB,0.21207E-04_JPRB,0.24356E-04_JPRB,0.15929E-04_JPRB /)  
KB(:, 1,51, 7) = (/ &
 & 0.67378E-06_JPRB,0.66826E-05_JPRB,0.83381E-05_JPRB,0.88828E-05_JPRB,0.55052E-05_JPRB /)  
KB(:, 2,51, 7) = (/ &
 & 0.72873E-06_JPRB,0.77753E-05_JPRB,0.98905E-05_JPRB,0.10714E-04_JPRB,0.67636E-05_JPRB /)  
KB(:, 3,51, 7) = (/ &
 & 0.77763E-06_JPRB,0.91368E-05_JPRB,0.11866E-04_JPRB,0.13091E-04_JPRB,0.83559E-05_JPRB /)  
KB(:, 4,51, 7) = (/ &
 & 0.81953E-06_JPRB,0.10824E-04_JPRB,0.14378E-04_JPRB,0.16168E-04_JPRB,0.10417E-04_JPRB /)  
KB(:, 5,51, 7) = (/ &
 & 0.85561E-06_JPRB,0.12933E-04_JPRB,0.17571E-04_JPRB,0.20159E-04_JPRB,0.13087E-04_JPRB /)  
KB(:, 1,52, 7) = (/ &
 & 0.53444E-06_JPRB,0.54066E-05_JPRB,0.67197E-05_JPRB,0.71297E-05_JPRB,0.43814E-05_JPRB /)  
KB(:, 2,52, 7) = (/ &
 & 0.58095E-06_JPRB,0.63124E-05_JPRB,0.79989E-05_JPRB,0.86346E-05_JPRB,0.54122E-05_JPRB /)  
KB(:, 3,52, 7) = (/ &
 & 0.62282E-06_JPRB,0.74561E-05_JPRB,0.96489E-05_JPRB,0.10614E-04_JPRB,0.67289E-05_JPRB /)  
KB(:, 4,52, 7) = (/ &
 & 0.65913E-06_JPRB,0.88917E-05_JPRB,0.11780E-04_JPRB,0.13220E-04_JPRB,0.84497E-05_JPRB /)  
KB(:, 5,52, 7) = (/ &
 & 0.69032E-06_JPRB,0.10691E-04_JPRB,0.14504E-04_JPRB,0.16615E-04_JPRB,0.10706E-04_JPRB /)  
KB(:, 1,53, 7) = (/ &
 & 0.42309E-06_JPRB,0.43635E-05_JPRB,0.54017E-05_JPRB,0.57047E-05_JPRB,0.34733E-05_JPRB /)  
KB(:, 2,53, 7) = (/ &
 & 0.46223E-06_JPRB,0.51097E-05_JPRB,0.64465E-05_JPRB,0.69322E-05_JPRB,0.43120E-05_JPRB /)  
KB(:, 3,53, 7) = (/ &
 & 0.49791E-06_JPRB,0.60643E-05_JPRB,0.78166E-05_JPRB,0.85690E-05_JPRB,0.53948E-05_JPRB /)  
KB(:, 4,53, 7) = (/ &
 & 0.52942E-06_JPRB,0.72726E-05_JPRB,0.96042E-05_JPRB,0.10748E-04_JPRB,0.68211E-05_JPRB /)  
KB(:, 5,53, 7) = (/ &
 & 0.55635E-06_JPRB,0.88074E-05_JPRB,0.11924E-04_JPRB,0.13632E-04_JPRB,0.87176E-05_JPRB /)  
KB(:, 1,54, 7) = (/ &
 & 0.33525E-06_JPRB,0.35291E-05_JPRB,0.43533E-05_JPRB,0.45783E-05_JPRB,0.27618E-05_JPRB /)  
KB(:, 2,54, 7) = (/ &
 & 0.36801E-06_JPRB,0.41464E-05_JPRB,0.52098E-05_JPRB,0.55821E-05_JPRB,0.34468E-05_JPRB /)  
KB(:, 3,54, 7) = (/ &
 & 0.39830E-06_JPRB,0.49442E-05_JPRB,0.63495E-05_JPRB,0.69393E-05_JPRB,0.43390E-05_JPRB /)  
KB(:, 4,54, 7) = (/ &
 & 0.42530E-06_JPRB,0.59638E-05_JPRB,0.78520E-05_JPRB,0.87652E-05_JPRB,0.55238E-05_JPRB /)  
KB(:, 5,54, 7) = (/ &
 & 0.44850E-06_JPRB,0.72711E-05_JPRB,0.98256E-05_JPRB,0.11213E-04_JPRB,0.71180E-05_JPRB /)  
KB(:, 1,55, 7) = (/ &
 & 0.26561E-06_JPRB,0.28535E-05_JPRB,0.35091E-05_JPRB,0.36747E-05_JPRB,0.21953E-05_JPRB /)  
KB(:, 2,55, 7) = (/ &
 & 0.29299E-06_JPRB,0.33630E-05_JPRB,0.42093E-05_JPRB,0.44935E-05_JPRB,0.27543E-05_JPRB /)  
KB(:, 3,55, 7) = (/ &
 & 0.31855E-06_JPRB,0.40286E-05_JPRB,0.51555E-05_JPRB,0.56160E-05_JPRB,0.34885E-05_JPRB /)  
KB(:, 4,55, 7) = (/ &
 & 0.34149E-06_JPRB,0.48884E-05_JPRB,0.64166E-05_JPRB,0.71432E-05_JPRB,0.44712E-05_JPRB /)  
KB(:, 5,55, 7) = (/ &
 & 0.36149E-06_JPRB,0.60082E-05_JPRB,0.81053E-05_JPRB,0.92338E-05_JPRB,0.58114E-05_JPRB /)  
KB(:, 1,56, 7) = (/ &
 & 0.21017E-06_JPRB,0.23019E-05_JPRB,0.28217E-05_JPRB,0.29420E-05_JPRB,0.17403E-05_JPRB /)  
KB(:, 2,56, 7) = (/ &
 & 0.23294E-06_JPRB,0.27215E-05_JPRB,0.33922E-05_JPRB,0.36070E-05_JPRB,0.21943E-05_JPRB /)  
KB(:, 3,56, 7) = (/ &
 & 0.25436E-06_JPRB,0.32732E-05_JPRB,0.41720E-05_JPRB,0.45291E-05_JPRB,0.27950E-05_JPRB /)  
KB(:, 4,56, 7) = (/ &
 & 0.27383E-06_JPRB,0.39951E-05_JPRB,0.52252E-05_JPRB,0.57990E-05_JPRB,0.36054E-05_JPRB /)  
KB(:, 5,56, 7) = (/ &
 & 0.29106E-06_JPRB,0.49429E-05_JPRB,0.66518E-05_JPRB,0.75613E-05_JPRB,0.47246E-05_JPRB /)  
KB(:, 1,57, 7) = (/ &
 & 0.16608E-06_JPRB,0.18531E-05_JPRB,0.22639E-05_JPRB,0.23504E-05_JPRB,0.13760E-05_JPRB /)  
KB(:, 2,57, 7) = (/ &
 & 0.18488E-06_JPRB,0.21971E-05_JPRB,0.27271E-05_JPRB,0.28870E-05_JPRB,0.17421E-05_JPRB /)  
KB(:, 3,57, 7) = (/ &
 & 0.20279E-06_JPRB,0.26520E-05_JPRB,0.33659E-05_JPRB,0.36392E-05_JPRB,0.22316E-05_JPRB /)  
KB(:, 4,57, 7) = (/ &
 & 0.21931E-06_JPRB,0.32543E-05_JPRB,0.42391E-05_JPRB,0.46891E-05_JPRB,0.28949E-05_JPRB /)  
KB(:, 5,57, 7) = (/ &
 & 0.23404E-06_JPRB,0.40527E-05_JPRB,0.54380E-05_JPRB,0.61649E-05_JPRB,0.38234E-05_JPRB /)  
KB(:, 1,58, 7) = (/ &
 & 0.13131E-06_JPRB,0.14927E-05_JPRB,0.18179E-05_JPRB,0.18787E-05_JPRB,0.10893E-05_JPRB /)  
KB(:, 2,58, 7) = (/ &
 & 0.14677E-06_JPRB,0.17748E-05_JPRB,0.21946E-05_JPRB,0.23122E-05_JPRB,0.13839E-05_JPRB /)  
KB(:, 3,58, 7) = (/ &
 & 0.16171E-06_JPRB,0.21494E-05_JPRB,0.27171E-05_JPRB,0.29256E-05_JPRB,0.17827E-05_JPRB /)  
KB(:, 4,58, 7) = (/ &
 & 0.17567E-06_JPRB,0.26514E-05_JPRB,0.34407E-05_JPRB,0.37923E-05_JPRB,0.23269E-05_JPRB /)  
KB(:, 5,58, 7) = (/ &
 & 0.18816E-06_JPRB,0.33237E-05_JPRB,0.44466E-05_JPRB,0.50280E-05_JPRB,0.30958E-05_JPRB /)  
KB(:, 1,59, 7) = (/ &
 & 0.10599E-06_JPRB,0.12374E-05_JPRB,0.15060E-05_JPRB,0.15543E-05_JPRB,0.89750E-06_JPRB /)  
KB(:, 2,59, 7) = (/ &
 & 0.11868E-06_JPRB,0.14795E-05_JPRB,0.18285E-05_JPRB,0.19251E-05_JPRB,0.11479E-05_JPRB /)  
KB(:, 3,59, 7) = (/ &
 & 0.13098E-06_JPRB,0.18042E-05_JPRB,0.22807E-05_JPRB,0.24552E-05_JPRB,0.14897E-05_JPRB /)  
KB(:, 4,59, 7) = (/ &
 & 0.14252E-06_JPRB,0.22439E-05_JPRB,0.29152E-05_JPRB,0.32163E-05_JPRB,0.19622E-05_JPRB /)  
KB(:, 5,59, 7) = (/ &
 & 0.15291E-06_JPRB,0.28396E-05_JPRB,0.38087E-05_JPRB,0.43138E-05_JPRB,0.26387E-05_JPRB /)  
KB(:, 1,13, 8) = (/ &
 & 0.83673E-02_JPRB,0.17454E-01_JPRB,0.20213E-01_JPRB,0.20132E-01_JPRB,0.13810E-01_JPRB /)  
KB(:, 2,13, 8) = (/ &
 & 0.85039E-02_JPRB,0.17824E-01_JPRB,0.20684E-01_JPRB,0.20616E-01_JPRB,0.14219E-01_JPRB /)  
KB(:, 3,13, 8) = (/ &
 & 0.86129E-02_JPRB,0.18196E-01_JPRB,0.21163E-01_JPRB,0.21143E-01_JPRB,0.14616E-01_JPRB /)  
KB(:, 4,13, 8) = (/ &
 & 0.86913E-02_JPRB,0.18563E-01_JPRB,0.21635E-01_JPRB,0.21674E-01_JPRB,0.14991E-01_JPRB /)  
KB(:, 5,13, 8) = (/ &
 & 0.87301E-02_JPRB,0.18916E-01_JPRB,0.22103E-01_JPRB,0.22198E-01_JPRB,0.15351E-01_JPRB /)  
KB(:, 1,14, 8) = (/ &
 & 0.69346E-02_JPRB,0.14952E-01_JPRB,0.17380E-01_JPRB,0.17342E-01_JPRB,0.11803E-01_JPRB /)  
KB(:, 2,14, 8) = (/ &
 & 0.70328E-02_JPRB,0.15276E-01_JPRB,0.17808E-01_JPRB,0.17830E-01_JPRB,0.12181E-01_JPRB /)  
KB(:, 3,14, 8) = (/ &
 & 0.71113E-02_JPRB,0.15604E-01_JPRB,0.18240E-01_JPRB,0.18321E-01_JPRB,0.12544E-01_JPRB /)  
KB(:, 4,14, 8) = (/ &
 & 0.71580E-02_JPRB,0.15937E-01_JPRB,0.18667E-01_JPRB,0.18814E-01_JPRB,0.12884E-01_JPRB /)  
KB(:, 5,14, 8) = (/ &
 & 0.71785E-02_JPRB,0.16228E-01_JPRB,0.19093E-01_JPRB,0.19299E-01_JPRB,0.13230E-01_JPRB /)  
KB(:, 1,15, 8) = (/ &
 & 0.57307E-02_JPRB,0.12763E-01_JPRB,0.14890E-01_JPRB,0.14912E-01_JPRB,0.10073E-01_JPRB /)  
KB(:, 2,15, 8) = (/ &
 & 0.58017E-02_JPRB,0.13052E-01_JPRB,0.15278E-01_JPRB,0.15370E-01_JPRB,0.10417E-01_JPRB /)  
KB(:, 3,15, 8) = (/ &
 & 0.58533E-02_JPRB,0.13347E-01_JPRB,0.15666E-01_JPRB,0.15828E-01_JPRB,0.10742E-01_JPRB /)  
KB(:, 4,15, 8) = (/ &
 & 0.58826E-02_JPRB,0.13628E-01_JPRB,0.16057E-01_JPRB,0.16289E-01_JPRB,0.11066E-01_JPRB /)  
KB(:, 5,15, 8) = (/ &
 & 0.58933E-02_JPRB,0.13873E-01_JPRB,0.16444E-01_JPRB,0.16739E-01_JPRB,0.11388E-01_JPRB /)  
KB(:, 1,16, 8) = (/ &
 & 0.47247E-02_JPRB,0.10863E-01_JPRB,0.12723E-01_JPRB,0.12788E-01_JPRB,0.85822E-02_JPRB /)  
KB(:, 2,16, 8) = (/ &
 & 0.47755E-02_JPRB,0.11124E-01_JPRB,0.13076E-01_JPRB,0.13211E-01_JPRB,0.88907E-02_JPRB /)  
KB(:, 3,16, 8) = (/ &
 & 0.48095E-02_JPRB,0.11385E-01_JPRB,0.13431E-01_JPRB,0.13641E-01_JPRB,0.91903E-02_JPRB /)  
KB(:, 4,16, 8) = (/ &
 & 0.48283E-02_JPRB,0.11622E-01_JPRB,0.13790E-01_JPRB,0.14066E-01_JPRB,0.94912E-02_JPRB /)  
KB(:, 5,16, 8) = (/ &
 & 0.48333E-02_JPRB,0.11841E-01_JPRB,0.14135E-01_JPRB,0.14487E-01_JPRB,0.97938E-02_JPRB /)  
KB(:, 1,17, 8) = (/ &
 & 0.38881E-02_JPRB,0.92313E-02_JPRB,0.10848E-01_JPRB,0.10942E-01_JPRB,0.73006E-02_JPRB /)  
KB(:, 2,17, 8) = (/ &
 & 0.39238E-02_JPRB,0.94601E-02_JPRB,0.11171E-01_JPRB,0.11333E-01_JPRB,0.75792E-02_JPRB /)  
KB(:, 3,17, 8) = (/ &
 & 0.39468E-02_JPRB,0.96874E-02_JPRB,0.11500E-01_JPRB,0.11732E-01_JPRB,0.78560E-02_JPRB /)  
KB(:, 4,17, 8) = (/ &
 & 0.39590E-02_JPRB,0.98962E-02_JPRB,0.11826E-01_JPRB,0.12129E-01_JPRB,0.81376E-02_JPRB /)  
KB(:, 5,17, 8) = (/ &
 & 0.39612E-02_JPRB,0.10094E-01_JPRB,0.12144E-01_JPRB,0.12521E-01_JPRB,0.84293E-02_JPRB /)  
KB(:, 1,18, 8) = (/ &
 & 0.31953E-02_JPRB,0.78309E-02_JPRB,0.92361E-02_JPRB,0.93523E-02_JPRB,0.62048E-02_JPRB /)  
KB(:, 2,18, 8) = (/ &
 & 0.32208E-02_JPRB,0.80372E-02_JPRB,0.95350E-02_JPRB,0.97148E-02_JPRB,0.64590E-02_JPRB /)  
KB(:, 3,18, 8) = (/ &
 & 0.32365E-02_JPRB,0.82342E-02_JPRB,0.98382E-02_JPRB,0.10082E-01_JPRB,0.67154E-02_JPRB /)  
KB(:, 4,18, 8) = (/ &
 & 0.32447E-02_JPRB,0.84229E-02_JPRB,0.10138E-01_JPRB,0.10450E-01_JPRB,0.69838E-02_JPRB /)  
KB(:, 5,18, 8) = (/ &
 & 0.32450E-02_JPRB,0.86061E-02_JPRB,0.10427E-01_JPRB,0.10814E-01_JPRB,0.72626E-02_JPRB /)  
KB(:, 1,19, 8) = (/ &
 & 0.26235E-02_JPRB,0.66399E-02_JPRB,0.78599E-02_JPRB,0.79875E-02_JPRB,0.52728E-02_JPRB /)  
KB(:, 2,19, 8) = (/ &
 & 0.26414E-02_JPRB,0.68231E-02_JPRB,0.81351E-02_JPRB,0.83230E-02_JPRB,0.55070E-02_JPRB /)  
KB(:, 3,19, 8) = (/ &
 & 0.26530E-02_JPRB,0.70004E-02_JPRB,0.84138E-02_JPRB,0.86629E-02_JPRB,0.57468E-02_JPRB /)  
KB(:, 4,19, 8) = (/ &
 & 0.26583E-02_JPRB,0.71756E-02_JPRB,0.86887E-02_JPRB,0.90029E-02_JPRB,0.60006E-02_JPRB /)  
KB(:, 5,19, 8) = (/ &
 & 0.26573E-02_JPRB,0.73457E-02_JPRB,0.89549E-02_JPRB,0.93422E-02_JPRB,0.62658E-02_JPRB /)  
KB(:, 1,20, 8) = (/ &
 & 0.21528E-02_JPRB,0.56300E-02_JPRB,0.66928E-02_JPRB,0.68275E-02_JPRB,0.44887E-02_JPRB /)  
KB(:, 2,20, 8) = (/ &
 & 0.21659E-02_JPRB,0.57965E-02_JPRB,0.69483E-02_JPRB,0.71374E-02_JPRB,0.47044E-02_JPRB /)  
KB(:, 3,20, 8) = (/ &
 & 0.21742E-02_JPRB,0.59617E-02_JPRB,0.72036E-02_JPRB,0.74503E-02_JPRB,0.49314E-02_JPRB /)  
KB(:, 4,20, 8) = (/ &
 & 0.21777E-02_JPRB,0.61251E-02_JPRB,0.74562E-02_JPRB,0.77657E-02_JPRB,0.51700E-02_JPRB /)  
KB(:, 5,20, 8) = (/ &
 & 0.21757E-02_JPRB,0.62850E-02_JPRB,0.77065E-02_JPRB,0.80891E-02_JPRB,0.54225E-02_JPRB /)  
KB(:, 1,21, 8) = (/ &
 & 0.17659E-02_JPRB,0.47778E-02_JPRB,0.57054E-02_JPRB,0.58417E-02_JPRB,0.38271E-02_JPRB /)  
KB(:, 2,21, 8) = (/ &
 & 0.17754E-02_JPRB,0.49299E-02_JPRB,0.59393E-02_JPRB,0.61257E-02_JPRB,0.40264E-02_JPRB /)  
KB(:, 3,21, 8) = (/ &
 & 0.17817E-02_JPRB,0.50836E-02_JPRB,0.61750E-02_JPRB,0.64148E-02_JPRB,0.42397E-02_JPRB /)  
KB(:, 4,21, 8) = (/ &
 & 0.17836E-02_JPRB,0.52370E-02_JPRB,0.64083E-02_JPRB,0.67125E-02_JPRB,0.44647E-02_JPRB /)  
KB(:, 5,21, 8) = (/ &
 & 0.17811E-02_JPRB,0.53876E-02_JPRB,0.66480E-02_JPRB,0.70201E-02_JPRB,0.47076E-02_JPRB /)  
KB(:, 1,22, 8) = (/ &
 & 0.14486E-02_JPRB,0.40679E-02_JPRB,0.48826E-02_JPRB,0.50205E-02_JPRB,0.32805E-02_JPRB /)  
KB(:, 2,22, 8) = (/ &
 & 0.14554E-02_JPRB,0.42085E-02_JPRB,0.50980E-02_JPRB,0.52827E-02_JPRB,0.34669E-02_JPRB /)  
KB(:, 3,22, 8) = (/ &
 & 0.14597E-02_JPRB,0.43515E-02_JPRB,0.53153E-02_JPRB,0.55535E-02_JPRB,0.36674E-02_JPRB /)  
KB(:, 4,22, 8) = (/ &
 & 0.14606E-02_JPRB,0.44957E-02_JPRB,0.55353E-02_JPRB,0.58376E-02_JPRB,0.38816E-02_JPRB /)  
KB(:, 5,22, 8) = (/ &
 & 0.14577E-02_JPRB,0.46383E-02_JPRB,0.57672E-02_JPRB,0.61302E-02_JPRB,0.41156E-02_JPRB /)  
KB(:, 1,23, 8) = (/ &
 & 0.11880E-02_JPRB,0.34698E-02_JPRB,0.41861E-02_JPRB,0.43248E-02_JPRB,0.28199E-02_JPRB /)  
KB(:, 2,23, 8) = (/ &
 & 0.11929E-02_JPRB,0.36010E-02_JPRB,0.43862E-02_JPRB,0.45689E-02_JPRB,0.29956E-02_JPRB /)  
KB(:, 3,23, 8) = (/ &
 & 0.11958E-02_JPRB,0.37344E-02_JPRB,0.45877E-02_JPRB,0.48273E-02_JPRB,0.31843E-02_JPRB /)  
KB(:, 4,23, 8) = (/ &
 & 0.11959E-02_JPRB,0.38697E-02_JPRB,0.48007E-02_JPRB,0.50965E-02_JPRB,0.33903E-02_JPRB /)  
KB(:, 5,23, 8) = (/ &
 & 0.11929E-02_JPRB,0.40068E-02_JPRB,0.50232E-02_JPRB,0.53791E-02_JPRB,0.36136E-02_JPRB /)  
KB(:, 1,24, 8) = (/ &
 & 0.97406E-03_JPRB,0.29675E-02_JPRB,0.36006E-02_JPRB,0.37379E-02_JPRB,0.24344E-02_JPRB /)  
KB(:, 2,24, 8) = (/ &
 & 0.97756E-03_JPRB,0.30896E-02_JPRB,0.37850E-02_JPRB,0.39686E-02_JPRB,0.25994E-02_JPRB /)  
KB(:, 3,24, 8) = (/ &
 & 0.97946E-03_JPRB,0.32150E-02_JPRB,0.39775E-02_JPRB,0.42135E-02_JPRB,0.27776E-02_JPRB /)  
KB(:, 4,24, 8) = (/ &
 & 0.97899E-03_JPRB,0.33430E-02_JPRB,0.41825E-02_JPRB,0.44708E-02_JPRB,0.29753E-02_JPRB /)  
KB(:, 5,24, 8) = (/ &
 & 0.97615E-03_JPRB,0.34761E-02_JPRB,0.43966E-02_JPRB,0.47457E-02_JPRB,0.31900E-02_JPRB /)  
KB(:, 1,25, 8) = (/ &
 & 0.79856E-03_JPRB,0.25459E-02_JPRB,0.31077E-02_JPRB,0.32447E-02_JPRB,0.21114E-02_JPRB /)  
KB(:, 2,25, 8) = (/ &
 & 0.80110E-03_JPRB,0.26605E-02_JPRB,0.32805E-02_JPRB,0.34640E-02_JPRB,0.22664E-02_JPRB /)  
KB(:, 3,25, 8) = (/ &
 & 0.80222E-03_JPRB,0.27778E-02_JPRB,0.34666E-02_JPRB,0.36958E-02_JPRB,0.24376E-02_JPRB /)  
KB(:, 4,25, 8) = (/ &
 & 0.80129E-03_JPRB,0.29014E-02_JPRB,0.36623E-02_JPRB,0.39444E-02_JPRB,0.26269E-02_JPRB /)  
KB(:, 5,25, 8) = (/ &
 & 0.79857E-03_JPRB,0.30302E-02_JPRB,0.38698E-02_JPRB,0.42126E-02_JPRB,0.28335E-02_JPRB /)  
KB(:, 1,26, 8) = (/ &
 & 0.65460E-03_JPRB,0.21933E-02_JPRB,0.26944E-02_JPRB,0.28334E-02_JPRB,0.18417E-02_JPRB /)  
KB(:, 2,26, 8) = (/ &
 & 0.65639E-03_JPRB,0.23003E-02_JPRB,0.28599E-02_JPRB,0.30409E-02_JPRB,0.19886E-02_JPRB /)  
KB(:, 3,26, 8) = (/ &
 & 0.65685E-03_JPRB,0.24132E-02_JPRB,0.30384E-02_JPRB,0.32639E-02_JPRB,0.21545E-02_JPRB /)  
KB(:, 4,26, 8) = (/ &
 & 0.65577E-03_JPRB,0.25323E-02_JPRB,0.32275E-02_JPRB,0.35055E-02_JPRB,0.23366E-02_JPRB /)  
KB(:, 5,26, 8) = (/ &
 & 0.65325E-03_JPRB,0.26572E-02_JPRB,0.34294E-02_JPRB,0.37687E-02_JPRB,0.25365E-02_JPRB /)  
KB(:, 1,27, 8) = (/ &
 & 0.53655E-03_JPRB,0.18966E-02_JPRB,0.23474E-02_JPRB,0.24873E-02_JPRB,0.16142E-02_JPRB /)  
KB(:, 2,27, 8) = (/ &
 & 0.53777E-03_JPRB,0.19979E-02_JPRB,0.25069E-02_JPRB,0.26849E-02_JPRB,0.17570E-02_JPRB /)  
KB(:, 3,27, 8) = (/ &
 & 0.53783E-03_JPRB,0.21070E-02_JPRB,0.26778E-02_JPRB,0.29010E-02_JPRB,0.19163E-02_JPRB /)  
KB(:, 4,27, 8) = (/ &
 & 0.53661E-03_JPRB,0.22218E-02_JPRB,0.28609E-02_JPRB,0.31373E-02_JPRB,0.20925E-02_JPRB /)  
KB(:, 5,27, 8) = (/ &
 & 0.53426E-03_JPRB,0.23437E-02_JPRB,0.30591E-02_JPRB,0.33953E-02_JPRB,0.22871E-02_JPRB /)  
KB(:, 1,28, 8) = (/ &
 & 0.43973E-03_JPRB,0.16467E-02_JPRB,0.20564E-02_JPRB,0.21950E-02_JPRB,0.14243E-02_JPRB /)  
KB(:, 2,28, 8) = (/ &
 & 0.44046E-03_JPRB,0.17445E-02_JPRB,0.22094E-02_JPRB,0.23854E-02_JPRB,0.15622E-02_JPRB /)  
KB(:, 3,28, 8) = (/ &
 & 0.44027E-03_JPRB,0.18495E-02_JPRB,0.23737E-02_JPRB,0.25954E-02_JPRB,0.17160E-02_JPRB /)  
KB(:, 4,28, 8) = (/ &
 & 0.43902E-03_JPRB,0.19607E-02_JPRB,0.25527E-02_JPRB,0.28280E-02_JPRB,0.18875E-02_JPRB /)  
KB(:, 5,28, 8) = (/ &
 & 0.43690E-03_JPRB,0.20797E-02_JPRB,0.27483E-02_JPRB,0.30809E-02_JPRB,0.20783E-02_JPRB /)  
KB(:, 1,29, 8) = (/ &
 & 0.36035E-03_JPRB,0.14377E-02_JPRB,0.18129E-02_JPRB,0.19502E-02_JPRB,0.12665E-02_JPRB /)  
KB(:, 2,29, 8) = (/ &
 & 0.36078E-03_JPRB,0.15322E-02_JPRB,0.19593E-02_JPRB,0.21346E-02_JPRB,0.13993E-02_JPRB /)  
KB(:, 3,29, 8) = (/ &
 & 0.36035E-03_JPRB,0.16333E-02_JPRB,0.21194E-02_JPRB,0.23407E-02_JPRB,0.15489E-02_JPRB /)  
KB(:, 4,29, 8) = (/ &
 & 0.35917E-03_JPRB,0.17416E-02_JPRB,0.22958E-02_JPRB,0.25693E-02_JPRB,0.17169E-02_JPRB /)  
KB(:, 5,29, 8) = (/ &
 & 0.35722E-03_JPRB,0.18583E-02_JPRB,0.24893E-02_JPRB,0.28199E-02_JPRB,0.19058E-02_JPRB /)  
KB(:, 1,30, 8) = (/ &
 & 0.29522E-03_JPRB,0.12625E-02_JPRB,0.16073E-02_JPRB,0.17444E-02_JPRB,0.11337E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART23',1,ZHOOK_HANDLE)
END SUBROUTINE PART23


SUBROUTINE PART24

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART24',0,ZHOOK_HANDLE)


KB(:, 2,30, 8) = (/ &
 & 0.29544E-03_JPRB,0.13534E-02_JPRB,0.17493E-02_JPRB,0.19248E-02_JPRB,0.12629E-02_JPRB /)  
KB(:, 3,30, 8) = (/ &
 & 0.29489E-03_JPRB,0.14513E-02_JPRB,0.19064E-02_JPRB,0.21281E-02_JPRB,0.14093E-02_JPRB /)  
KB(:, 4,30, 8) = (/ &
 & 0.29377E-03_JPRB,0.15575E-02_JPRB,0.20813E-02_JPRB,0.23536E-02_JPRB,0.15751E-02_JPRB /)  
KB(:, 5,30, 8) = (/ &
 & 0.29201E-03_JPRB,0.16725E-02_JPRB,0.22728E-02_JPRB,0.26031E-02_JPRB,0.17633E-02_JPRB /)  
KB(:, 1,31, 8) = (/ &
 & 0.24186E-03_JPRB,0.11155E-02_JPRB,0.14353E-02_JPRB,0.15729E-02_JPRB,0.10232E-02_JPRB /)  
KB(:, 2,31, 8) = (/ &
 & 0.24189E-03_JPRB,0.12032E-02_JPRB,0.15739E-02_JPRB,0.17508E-02_JPRB,0.11498E-02_JPRB /)  
KB(:, 3,31, 8) = (/ &
 & 0.24130E-03_JPRB,0.12988E-02_JPRB,0.17296E-02_JPRB,0.19516E-02_JPRB,0.12942E-02_JPRB /)  
KB(:, 4,31, 8) = (/ &
 & 0.24025E-03_JPRB,0.14034E-02_JPRB,0.19030E-02_JPRB,0.21764E-02_JPRB,0.14594E-02_JPRB /)  
KB(:, 5,31, 8) = (/ &
 & 0.23866E-03_JPRB,0.15170E-02_JPRB,0.20940E-02_JPRB,0.24270E-02_JPRB,0.16471E-02_JPRB /)  
KB(:, 1,32, 8) = (/ &
 & 0.19811E-03_JPRB,0.99188E-03_JPRB,0.12914E-02_JPRB,0.14311E-02_JPRB,0.93157E-03_JPRB /)  
KB(:, 2,32, 8) = (/ &
 & 0.19799E-03_JPRB,0.10771E-02_JPRB,0.14282E-02_JPRB,0.16073E-02_JPRB,0.10562E-02_JPRB /)  
KB(:, 3,32, 8) = (/ &
 & 0.19741E-03_JPRB,0.11711E-02_JPRB,0.15828E-02_JPRB,0.18068E-02_JPRB,0.11999E-02_JPRB /)  
KB(:, 4,32, 8) = (/ &
 & 0.19645E-03_JPRB,0.12746E-02_JPRB,0.17559E-02_JPRB,0.20320E-02_JPRB,0.13654E-02_JPRB /)  
KB(:, 5,32, 8) = (/ &
 & 0.19503E-03_JPRB,0.13871E-02_JPRB,0.19473E-02_JPRB,0.22851E-02_JPRB,0.15533E-02_JPRB /)  
KB(:, 1,33, 8) = (/ &
 & 0.16225E-03_JPRB,0.88803E-03_JPRB,0.11717E-02_JPRB,0.13138E-02_JPRB,0.85556E-03_JPRB /)  
KB(:, 2,33, 8) = (/ &
 & 0.16205E-03_JPRB,0.97174E-03_JPRB,0.13077E-02_JPRB,0.14890E-02_JPRB,0.97930E-03_JPRB /)  
KB(:, 3,33, 8) = (/ &
 & 0.16148E-03_JPRB,0.10648E-02_JPRB,0.14621E-02_JPRB,0.16891E-02_JPRB,0.11237E-02_JPRB /)  
KB(:, 4,33, 8) = (/ &
 & 0.16059E-03_JPRB,0.11673E-02_JPRB,0.16357E-02_JPRB,0.19165E-02_JPRB,0.12896E-02_JPRB /)  
KB(:, 5,33, 8) = (/ &
 & 0.15934E-03_JPRB,0.12795E-02_JPRB,0.18288E-02_JPRB,0.21736E-02_JPRB,0.14791E-02_JPRB /)  
KB(:, 1,34, 8) = (/ &
 & 0.13286E-03_JPRB,0.79835E-03_JPRB,0.10683E-02_JPRB,0.12117E-02_JPRB,0.78908E-03_JPRB /)  
KB(:, 2,34, 8) = (/ &
 & 0.13261E-03_JPRB,0.88066E-03_JPRB,0.12036E-02_JPRB,0.13865E-02_JPRB,0.91252E-03_JPRB /)  
KB(:, 3,34, 8) = (/ &
 & 0.13209E-03_JPRB,0.97270E-03_JPRB,0.13580E-02_JPRB,0.15871E-02_JPRB,0.10570E-02_JPRB /)  
KB(:, 4,34, 8) = (/ &
 & 0.13130E-03_JPRB,0.10748E-02_JPRB,0.15318E-02_JPRB,0.18171E-02_JPRB,0.12236E-02_JPRB /)  
KB(:, 5,34, 8) = (/ &
 & 0.13022E-03_JPRB,0.11866E-02_JPRB,0.17264E-02_JPRB,0.20786E-02_JPRB,0.14148E-02_JPRB /)  
KB(:, 1,35, 8) = (/ &
 & 0.10879E-03_JPRB,0.71567E-03_JPRB,0.97075E-03_JPRB,0.11118E-02_JPRB,0.72353E-03_JPRB /)  
KB(:, 2,35, 8) = (/ &
 & 0.10855E-03_JPRB,0.79625E-03_JPRB,0.11041E-02_JPRB,0.12845E-02_JPRB,0.84540E-03_JPRB /)  
KB(:, 3,35, 8) = (/ &
 & 0.10811E-03_JPRB,0.88686E-03_JPRB,0.12569E-02_JPRB,0.14847E-02_JPRB,0.98831E-03_JPRB /)  
KB(:, 4,35, 8) = (/ &
 & 0.10743E-03_JPRB,0.98761E-03_JPRB,0.14300E-02_JPRB,0.17157E-02_JPRB,0.11541E-02_JPRB /)  
KB(:, 5,35, 8) = (/ &
 & 0.10650E-03_JPRB,0.10987E-02_JPRB,0.16251E-02_JPRB,0.19799E-02_JPRB,0.13460E-02_JPRB /)  
KB(:, 1,36, 8) = (/ &
 & 0.89091E-04_JPRB,0.63773E-03_JPRB,0.87525E-03_JPRB,0.10106E-02_JPRB,0.65643E-03_JPRB /)  
KB(:, 2,36, 8) = (/ &
 & 0.88892E-04_JPRB,0.71572E-03_JPRB,0.10050E-02_JPRB,0.11794E-02_JPRB,0.77482E-03_JPRB /)  
KB(:, 3,36, 8) = (/ &
 & 0.88510E-04_JPRB,0.80390E-03_JPRB,0.11544E-02_JPRB,0.13768E-02_JPRB,0.91437E-03_JPRB /)  
KB(:, 4,36, 8) = (/ &
 & 0.87951E-04_JPRB,0.90253E-03_JPRB,0.13255E-02_JPRB,0.16063E-02_JPRB,0.10779E-02_JPRB /)  
KB(:, 5,36, 8) = (/ &
 & 0.87175E-04_JPRB,0.10120E-02_JPRB,0.15187E-02_JPRB,0.18703E-02_JPRB,0.12677E-02_JPRB /)  
KB(:, 1,37, 8) = (/ &
 & 0.72967E-04_JPRB,0.56051E-03_JPRB,0.77586E-03_JPRB,0.90139E-03_JPRB,0.58319E-03_JPRB /)  
KB(:, 2,37, 8) = (/ &
 & 0.72818E-04_JPRB,0.63459E-03_JPRB,0.89962E-03_JPRB,0.10627E-02_JPRB,0.69545E-03_JPRB /)  
KB(:, 3,37, 8) = (/ &
 & 0.72523E-04_JPRB,0.71909E-03_JPRB,0.10433E-02_JPRB,0.12533E-02_JPRB,0.82896E-03_JPRB /)  
KB(:, 4,37, 8) = (/ &
 & 0.72087E-04_JPRB,0.81427E-03_JPRB,0.12092E-02_JPRB,0.14766E-02_JPRB,0.98671E-03_JPRB /)  
KB(:, 5,37, 8) = (/ &
 & 0.71486E-04_JPRB,0.92093E-03_JPRB,0.13977E-02_JPRB,0.17355E-02_JPRB,0.11708E-02_JPRB /)  
KB(:, 1,38, 8) = (/ &
 & 0.59765E-04_JPRB,0.49320E-03_JPRB,0.68844E-03_JPRB,0.80478E-03_JPRB,0.51849E-03_JPRB /)  
KB(:, 2,38, 8) = (/ &
 & 0.59660E-04_JPRB,0.56354E-03_JPRB,0.80640E-03_JPRB,0.95876E-03_JPRB,0.62466E-03_JPRB /)  
KB(:, 3,38, 8) = (/ &
 & 0.59436E-04_JPRB,0.64440E-03_JPRB,0.94454E-03_JPRB,0.11426E-02_JPRB,0.75236E-03_JPRB /)  
KB(:, 4,38, 8) = (/ &
 & 0.59102E-04_JPRB,0.73631E-03_JPRB,0.11052E-02_JPRB,0.13599E-02_JPRB,0.90433E-03_JPRB /)  
KB(:, 5,38, 8) = (/ &
 & 0.58635E-04_JPRB,0.84009E-03_JPRB,0.12891E-02_JPRB,0.16134E-02_JPRB,0.10829E-02_JPRB /)  
KB(:, 1,39, 8) = (/ &
 & 0.48956E-04_JPRB,0.43499E-03_JPRB,0.61231E-03_JPRB,0.72017E-03_JPRB,0.46189E-03_JPRB /)  
KB(:, 2,39, 8) = (/ &
 & 0.48890E-04_JPRB,0.50181E-03_JPRB,0.72478E-03_JPRB,0.86730E-03_JPRB,0.56244E-03_JPRB /)  
KB(:, 3,39, 8) = (/ &
 & 0.48717E-04_JPRB,0.57923E-03_JPRB,0.85778E-03_JPRB,0.10448E-02_JPRB,0.68464E-03_JPRB /)  
KB(:, 4,39, 8) = (/ &
 & 0.48451E-04_JPRB,0.66799E-03_JPRB,0.10132E-02_JPRB,0.12563E-02_JPRB,0.83112E-03_JPRB /)  
KB(:, 5,39, 8) = (/ &
 & 0.48085E-04_JPRB,0.76898E-03_JPRB,0.11928E-02_JPRB,0.15047E-02_JPRB,0.10044E-02_JPRB /)  
KB(:, 1,40, 8) = (/ &
 & 0.40107E-04_JPRB,0.37860E-03_JPRB,0.53596E-03_JPRB,0.63302E-03_JPRB,0.40350E-03_JPRB /)  
KB(:, 2,40, 8) = (/ &
 & 0.40068E-04_JPRB,0.44099E-03_JPRB,0.64126E-03_JPRB,0.77105E-03_JPRB,0.49697E-03_JPRB /)  
KB(:, 3,40, 8) = (/ &
 & 0.39945E-04_JPRB,0.51399E-03_JPRB,0.76694E-03_JPRB,0.93934E-03_JPRB,0.61166E-03_JPRB /)  
KB(:, 4,40, 8) = (/ &
 & 0.39752E-04_JPRB,0.59851E-03_JPRB,0.91528E-03_JPRB,0.11416E-02_JPRB,0.75037E-03_JPRB /)  
KB(:, 5,40, 8) = (/ &
 & 0.39469E-04_JPRB,0.69544E-03_JPRB,0.10880E-02_JPRB,0.13809E-02_JPRB,0.91593E-03_JPRB /)  
KB(:, 1,41, 8) = (/ &
 & 0.32851E-04_JPRB,0.32878E-03_JPRB,0.46786E-03_JPRB,0.55469E-03_JPRB,0.35120E-03_JPRB /)  
KB(:, 2,41, 8) = (/ &
 & 0.32839E-04_JPRB,0.38683E-03_JPRB,0.56607E-03_JPRB,0.68394E-03_JPRB,0.43769E-03_JPRB /)  
KB(:, 3,41, 8) = (/ &
 & 0.32749E-04_JPRB,0.45542E-03_JPRB,0.68444E-03_JPRB,0.84259E-03_JPRB,0.54490E-03_JPRB /)  
KB(:, 4,41, 8) = (/ &
 & 0.32607E-04_JPRB,0.53564E-03_JPRB,0.82547E-03_JPRB,0.10352E-02_JPRB,0.67585E-03_JPRB /)  
KB(:, 5,41, 8) = (/ &
 & 0.32395E-04_JPRB,0.62841E-03_JPRB,0.99133E-03_JPRB,0.12652E-02_JPRB,0.83332E-03_JPRB /)  
KB(:, 1,42, 8) = (/ &
 & 0.26906E-04_JPRB,0.28534E-03_JPRB,0.40805E-03_JPRB,0.48535E-03_JPRB,0.30526E-03_JPRB /)  
KB(:, 2,42, 8) = (/ &
 & 0.26908E-04_JPRB,0.33922E-03_JPRB,0.49950E-03_JPRB,0.60603E-03_JPRB,0.38505E-03_JPRB /)  
KB(:, 3,42, 8) = (/ &
 & 0.26846E-04_JPRB,0.40361E-03_JPRB,0.61076E-03_JPRB,0.75564E-03_JPRB,0.48524E-03_JPRB /)  
KB(:, 4,42, 8) = (/ &
 & 0.26739E-04_JPRB,0.47953E-03_JPRB,0.74454E-03_JPRB,0.93882E-03_JPRB,0.60861E-03_JPRB /)  
KB(:, 5,42, 8) = (/ &
 & 0.26585E-04_JPRB,0.56816E-03_JPRB,0.90363E-03_JPRB,0.11597E-02_JPRB,0.75829E-03_JPRB /)  
KB(:, 1,43, 8) = (/ &
 & 0.22034E-04_JPRB,0.24494E-03_JPRB,0.35126E-03_JPRB,0.41862E-03_JPRB,0.26133E-03_JPRB /)  
KB(:, 2,43, 8) = (/ &
 & 0.22045E-04_JPRB,0.29428E-03_JPRB,0.43526E-03_JPRB,0.52960E-03_JPRB,0.33379E-03_JPRB /)  
KB(:, 3,43, 8) = (/ &
 & 0.22009E-04_JPRB,0.35394E-03_JPRB,0.53838E-03_JPRB,0.66893E-03_JPRB,0.42599E-03_JPRB /)  
KB(:, 4,43, 8) = (/ &
 & 0.21933E-04_JPRB,0.42510E-03_JPRB,0.66392E-03_JPRB,0.84090E-03_JPRB,0.54061E-03_JPRB /)  
KB(:, 5,43, 8) = (/ &
 & 0.21820E-04_JPRB,0.50878E-03_JPRB,0.81474E-03_JPRB,0.10503E-02_JPRB,0.68139E-03_JPRB /)  
KB(:, 1,44, 8) = (/ &
 & 0.18042E-04_JPRB,0.20878E-03_JPRB,0.29988E-03_JPRB,0.35782E-03_JPRB,0.22160E-03_JPRB /)  
KB(:, 2,44, 8) = (/ &
 & 0.18058E-04_JPRB,0.25360E-03_JPRB,0.37621E-03_JPRB,0.45875E-03_JPRB,0.28670E-03_JPRB /)  
KB(:, 3,44, 8) = (/ &
 & 0.18041E-04_JPRB,0.30845E-03_JPRB,0.47123E-03_JPRB,0.58727E-03_JPRB,0.37070E-03_JPRB /)  
KB(:, 4,44, 8) = (/ &
 & 0.17989E-04_JPRB,0.37459E-03_JPRB,0.58804E-03_JPRB,0.74739E-03_JPRB,0.47650E-03_JPRB /)  
KB(:, 5,44, 8) = (/ &
 & 0.17906E-04_JPRB,0.45317E-03_JPRB,0.73003E-03_JPRB,0.94454E-03_JPRB,0.60768E-03_JPRB /)  
KB(:, 1,45, 8) = (/ &
 & 0.14770E-04_JPRB,0.17743E-03_JPRB,0.25518E-03_JPRB,0.30461E-03_JPRB,0.18718E-03_JPRB /)  
KB(:, 2,45, 8) = (/ &
 & 0.14790E-04_JPRB,0.21794E-03_JPRB,0.32424E-03_JPRB,0.39603E-03_JPRB,0.24534E-03_JPRB /)  
KB(:, 3,45, 8) = (/ &
 & 0.14785E-04_JPRB,0.26822E-03_JPRB,0.41132E-03_JPRB,0.51406E-03_JPRB,0.32158E-03_JPRB /)  
KB(:, 4,45, 8) = (/ &
 & 0.14751E-04_JPRB,0.32948E-03_JPRB,0.51968E-03_JPRB,0.66288E-03_JPRB,0.41889E-03_JPRB /)  
KB(:, 5,45, 8) = (/ &
 & 0.14692E-04_JPRB,0.40309E-03_JPRB,0.65298E-03_JPRB,0.84795E-03_JPRB,0.54078E-03_JPRB /)  
KB(:, 1,46, 8) = (/ &
 & 0.12091E-04_JPRB,0.14956E-03_JPRB,0.21507E-03_JPRB,0.25664E-03_JPRB,0.15641E-03_JPRB /)  
KB(:, 2,46, 8) = (/ &
 & 0.12112E-04_JPRB,0.18585E-03_JPRB,0.27689E-03_JPRB,0.33853E-03_JPRB,0.20778E-03_JPRB /)  
KB(:, 3,46, 8) = (/ &
 & 0.12113E-04_JPRB,0.23156E-03_JPRB,0.35597E-03_JPRB,0.44575E-03_JPRB,0.27619E-03_JPRB /)  
KB(:, 4,46, 8) = (/ &
 & 0.12094E-04_JPRB,0.28789E-03_JPRB,0.45576E-03_JPRB,0.58313E-03_JPRB,0.36492E-03_JPRB /)  
KB(:, 5,46, 8) = (/ &
 & 0.12054E-04_JPRB,0.35628E-03_JPRB,0.57980E-03_JPRB,0.75523E-03_JPRB,0.47721E-03_JPRB /)  
KB(:, 1,47, 8) = (/ &
 & 0.98958E-05_JPRB,0.12436E-03_JPRB,0.17838E-03_JPRB,0.21241E-03_JPRB,0.12841E-03_JPRB /)  
KB(:, 2,47, 8) = (/ &
 & 0.99157E-05_JPRB,0.15633E-03_JPRB,0.23279E-03_JPRB,0.28443E-03_JPRB,0.17291E-03_JPRB /)  
KB(:, 3,47, 8) = (/ &
 & 0.99224E-05_JPRB,0.19724E-03_JPRB,0.30350E-03_JPRB,0.38017E-03_JPRB,0.23323E-03_JPRB /)  
KB(:, 4,47, 8) = (/ &
 & 0.99150E-05_JPRB,0.24831E-03_JPRB,0.39396E-03_JPRB,0.50488E-03_JPRB,0.31274E-03_JPRB /)  
KB(:, 5,47, 8) = (/ &
 & 0.98881E-05_JPRB,0.31110E-03_JPRB,0.50788E-03_JPRB,0.66304E-03_JPRB,0.41485E-03_JPRB /)  
KB(:, 1,48, 8) = (/ &
 & 0.80981E-05_JPRB,0.10284E-03_JPRB,0.14701E-03_JPRB,0.17457E-03_JPRB,0.10464E-03_JPRB /)  
KB(:, 2,48, 8) = (/ &
 & 0.81170E-05_JPRB,0.13083E-03_JPRB,0.19452E-03_JPRB,0.23734E-03_JPRB,0.14298E-03_JPRB /)  
KB(:, 3,48, 8) = (/ &
 & 0.81254E-05_JPRB,0.16716E-03_JPRB,0.25727E-03_JPRB,0.32230E-03_JPRB,0.19565E-03_JPRB /)  
KB(:, 4,48, 8) = (/ &
 & 0.81253E-05_JPRB,0.21328E-03_JPRB,0.33887E-03_JPRB,0.43475E-03_JPRB,0.26652E-03_JPRB /)  
KB(:, 5,48, 8) = (/ &
 & 0.81092E-05_JPRB,0.27062E-03_JPRB,0.44301E-03_JPRB,0.57972E-03_JPRB,0.35887E-03_JPRB /)  
KB(:, 1,49, 8) = (/ &
 & 0.66262E-05_JPRB,0.84542E-04_JPRB,0.12034E-03_JPRB,0.14245E-03_JPRB,0.84636E-04_JPRB /)  
KB(:, 2,49, 8) = (/ &
 & 0.66435E-05_JPRB,0.10903E-03_JPRB,0.16168E-03_JPRB,0.19686E-03_JPRB,0.11740E-03_JPRB /)  
KB(:, 3,49, 8) = (/ &
 & 0.66527E-05_JPRB,0.14092E-03_JPRB,0.21685E-03_JPRB,0.27156E-03_JPRB,0.16309E-03_JPRB /)  
KB(:, 4,49, 8) = (/ &
 & 0.66567E-05_JPRB,0.18229E-03_JPRB,0.28989E-03_JPRB,0.37214E-03_JPRB,0.22572E-03_JPRB /)  
KB(:, 5,49, 8) = (/ &
 & 0.66489E-05_JPRB,0.23443E-03_JPRB,0.38461E-03_JPRB,0.50418E-03_JPRB,0.30883E-03_JPRB /)  
KB(:, 1,50, 8) = (/ &
 & 0.54202E-05_JPRB,0.69608E-04_JPRB,0.98680E-04_JPRB,0.11646E-03_JPRB,0.68510E-04_JPRB /)  
KB(:, 2,50, 8) = (/ &
 & 0.54374E-05_JPRB,0.90802E-04_JPRB,0.13434E-03_JPRB,0.16330E-03_JPRB,0.96499E-04_JPRB /)  
KB(:, 3,50, 8) = (/ &
 & 0.54475E-05_JPRB,0.11916E-03_JPRB,0.18327E-03_JPRB,0.22932E-03_JPRB,0.13620E-03_JPRB /)  
KB(:, 4,50, 8) = (/ &
 & 0.54521E-05_JPRB,0.15608E-03_JPRB,0.24845E-03_JPRB,0.31928E-03_JPRB,0.19154E-03_JPRB /)  
KB(:, 5,50, 8) = (/ &
 & 0.54498E-05_JPRB,0.20348E-03_JPRB,0.33466E-03_JPRB,0.43937E-03_JPRB,0.26626E-03_JPRB /)  
KB(:, 1,51, 8) = (/ &
 & 0.44351E-05_JPRB,0.57088E-04_JPRB,0.80582E-04_JPRB,0.94790E-04_JPRB,0.55250E-04_JPRB /)  
KB(:, 2,51, 8) = (/ &
 & 0.44504E-05_JPRB,0.75435E-04_JPRB,0.11131E-03_JPRB,0.13503E-03_JPRB,0.79024E-04_JPRB /)  
KB(:, 3,51, 8) = (/ &
 & 0.44599E-05_JPRB,0.10037E-03_JPRB,0.15428E-03_JPRB,0.19291E-03_JPRB,0.11343E-03_JPRB /)  
KB(:, 4,51, 8) = (/ &
 & 0.44651E-05_JPRB,0.13336E-03_JPRB,0.21252E-03_JPRB,0.27335E-03_JPRB,0.16218E-03_JPRB /)  
KB(:, 5,51, 8) = (/ &
 & 0.44653E-05_JPRB,0.17640E-03_JPRB,0.29075E-03_JPRB,0.38229E-03_JPRB,0.22923E-03_JPRB /)  
KB(:, 1,52, 8) = (/ &
 & 0.36290E-05_JPRB,0.46565E-04_JPRB,0.65364E-04_JPRB,0.76598E-04_JPRB,0.44240E-04_JPRB /)  
KB(:, 2,52, 8) = (/ &
 & 0.36420E-05_JPRB,0.62314E-04_JPRB,0.91644E-04_JPRB,0.11090E-03_JPRB,0.64234E-04_JPRB /)  
KB(:, 3,52, 8) = (/ &
 & 0.36509E-05_JPRB,0.84102E-04_JPRB,0.12910E-03_JPRB,0.16125E-03_JPRB,0.93833E-04_JPRB /)  
KB(:, 4,52, 8) = (/ &
 & 0.36555E-05_JPRB,0.11362E-03_JPRB,0.18115E-03_JPRB,0.23297E-03_JPRB,0.13657E-03_JPRB /)  
KB(:, 5,52, 8) = (/ &
 & 0.36579E-05_JPRB,0.15226E-03_JPRB,0.25136E-03_JPRB,0.33099E-03_JPRB,0.19621E-03_JPRB /)  
KB(:, 1,53, 8) = (/ &
 & 0.29692E-05_JPRB,0.37746E-04_JPRB,0.52632E-04_JPRB,0.61397E-04_JPRB,0.35165E-04_JPRB /)  
KB(:, 2,53, 8) = (/ &
 & 0.29808E-05_JPRB,0.51149E-04_JPRB,0.74879E-04_JPRB,0.90335E-04_JPRB,0.51807E-04_JPRB /)  
KB(:, 3,53, 8) = (/ &
 & 0.29880E-05_JPRB,0.70028E-04_JPRB,0.10724E-03_JPRB,0.13375E-03_JPRB,0.77010E-04_JPRB /)  
KB(:, 4,53, 8) = (/ &
 & 0.29931E-05_JPRB,0.96105E-04_JPRB,0.15314E-03_JPRB,0.19689E-03_JPRB,0.11417E-03_JPRB /)  
KB(:, 5,53, 8) = (/ &
 & 0.29959E-05_JPRB,0.13074E-03_JPRB,0.21612E-03_JPRB,0.28492E-03_JPRB,0.16697E-03_JPRB /)  
KB(:, 1,54, 8) = (/ &
 & 0.24296E-05_JPRB,0.30698E-04_JPRB,0.42544E-04_JPRB,0.49406E-04_JPRB,0.28072E-04_JPRB /)  
KB(:, 2,54, 8) = (/ &
 & 0.24393E-05_JPRB,0.42122E-04_JPRB,0.61454E-04_JPRB,0.73927E-04_JPRB,0.41964E-04_JPRB /)  
KB(:, 3,54, 8) = (/ &
 & 0.24460E-05_JPRB,0.58528E-04_JPRB,0.89500E-04_JPRB,0.11146E-03_JPRB,0.63503E-04_JPRB /)  
KB(:, 4,54, 8) = (/ &
 & 0.24507E-05_JPRB,0.81611E-04_JPRB,0.13009E-03_JPRB,0.16728E-03_JPRB,0.95947E-04_JPRB /)  
KB(:, 5,54, 8) = (/ &
 & 0.24535E-05_JPRB,0.11276E-03_JPRB,0.18682E-03_JPRB,0.24654E-03_JPRB,0.14286E-03_JPRB /)  
KB(:, 1,55, 8) = (/ &
 & 0.19883E-05_JPRB,0.24921E-04_JPRB,0.34312E-04_JPRB,0.39666E-04_JPRB,0.22375E-04_JPRB /)  
KB(:, 2,55, 8) = (/ &
 & 0.19963E-05_JPRB,0.34641E-04_JPRB,0.50344E-04_JPRB,0.60381E-04_JPRB,0.33942E-04_JPRB /)  
KB(:, 3,55, 8) = (/ &
 & 0.20020E-05_JPRB,0.48868E-04_JPRB,0.74618E-04_JPRB,0.92809E-04_JPRB,0.52280E-04_JPRB /)  
KB(:, 4,55, 8) = (/ &
 & 0.20065E-05_JPRB,0.69255E-04_JPRB,0.11042E-03_JPRB,0.14203E-03_JPRB,0.80566E-04_JPRB /)  
KB(:, 5,55, 8) = (/ &
 & 0.20089E-05_JPRB,0.97527E-04_JPRB,0.16182E-03_JPRB,0.21373E-03_JPRB,0.12228E-03_JPRB /)  
KB(:, 1,56, 8) = (/ &
 & 0.16268E-05_JPRB,0.20122E-04_JPRB,0.27506E-04_JPRB,0.31629E-04_JPRB,0.17718E-04_JPRB /)  
KB(:, 2,56, 8) = (/ &
 & 0.16337E-05_JPRB,0.28321E-04_JPRB,0.40966E-04_JPRB,0.48960E-04_JPRB,0.27271E-04_JPRB /)  
KB(:, 3,56, 8) = (/ &
 & 0.16385E-05_JPRB,0.40579E-04_JPRB,0.61828E-04_JPRB,0.76747E-04_JPRB,0.42739E-04_JPRB /)  
KB(:, 4,56, 8) = (/ &
 & 0.16424E-05_JPRB,0.58490E-04_JPRB,0.93220E-04_JPRB,0.11991E-03_JPRB,0.67232E-04_JPRB /)  
KB(:, 5,56, 8) = (/ &
 & 0.16450E-05_JPRB,0.83776E-04_JPRB,0.13917E-03_JPRB,0.18401E-03_JPRB,0.10406E-03_JPRB /)  
KB(:, 1,57, 8) = (/ &
 & 0.13311E-05_JPRB,0.16151E-04_JPRB,0.21901E-04_JPRB,0.25044E-04_JPRB,0.13934E-04_JPRB /)  
KB(:, 2,57, 8) = (/ &
 & 0.13369E-05_JPRB,0.23005E-04_JPRB,0.33083E-04_JPRB,0.39377E-04_JPRB,0.21751E-04_JPRB /)  
KB(:, 3,57, 8) = (/ &
 & 0.13411E-05_JPRB,0.33501E-04_JPRB,0.50888E-04_JPRB,0.63014E-04_JPRB,0.34696E-04_JPRB /)  
KB(:, 4,57, 8) = (/ &
 & 0.13443E-05_JPRB,0.49111E-04_JPRB,0.78191E-04_JPRB,0.10051E-03_JPRB,0.55711E-04_JPRB /)  
KB(:, 5,57, 8) = (/ &
 & 0.13467E-05_JPRB,0.71586E-04_JPRB,0.11902E-03_JPRB,0.15744E-03_JPRB,0.88025E-04_JPRB /)  
KB(:, 1,58, 8) = (/ &
 & 0.10892E-05_JPRB,0.12962E-04_JPRB,0.17443E-04_JPRB,0.19825E-04_JPRB,0.10955E-04_JPRB /)  
KB(:, 2,58, 8) = (/ &
 & 0.10942E-05_JPRB,0.18688E-04_JPRB,0.26716E-04_JPRB,0.31664E-04_JPRB,0.17348E-04_JPRB /)  
KB(:, 3,58, 8) = (/ &
 & 0.10976E-05_JPRB,0.27650E-04_JPRB,0.41864E-04_JPRB,0.51716E-04_JPRB,0.28159E-04_JPRB /)  
KB(:, 4,58, 8) = (/ &
 & 0.11004E-05_JPRB,0.41251E-04_JPRB,0.65630E-04_JPRB,0.84299E-04_JPRB,0.46156E-04_JPRB /)  
KB(:, 5,58, 8) = (/ &
 & 0.11025E-05_JPRB,0.61261E-04_JPRB,0.10196E-03_JPRB,0.13496E-03_JPRB,0.74536E-04_JPRB /)  
KB(:, 1,59, 8) = (/ &
 & 0.89197E-06_JPRB,0.11047E-04_JPRB,0.14899E-04_JPRB,0.16964E-04_JPRB,0.92999E-05_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART24',1,ZHOOK_HANDLE)
END SUBROUTINE PART24


SUBROUTINE PART25

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART25',0,ZHOOK_HANDLE)


KB(:, 2,59, 8) = (/ &
 & 0.89605E-06_JPRB,0.16215E-04_JPRB,0.23291E-04_JPRB,0.27686E-04_JPRB,0.15019E-04_JPRB /)  
KB(:, 3,59, 8) = (/ &
 & 0.89875E-06_JPRB,0.24462E-04_JPRB,0.37267E-04_JPRB,0.46243E-04_JPRB,0.24905E-04_JPRB /)  
KB(:, 4,59, 8) = (/ &
 & 0.90117E-06_JPRB,0.37175E-04_JPRB,0.59594E-04_JPRB,0.76969E-04_JPRB,0.41672E-04_JPRB /)  
KB(:, 5,59, 8) = (/ &
 & 0.90310E-06_JPRB,0.56115E-04_JPRB,0.94187E-04_JPRB,0.12528E-03_JPRB,0.68497E-04_JPRB /)  
KB(:, 1,13, 9) = (/ &
 & 0.56714E-01_JPRB,0.96228E-01_JPRB,0.10961E+00_JPRB,0.11078E+00_JPRB,0.82822E-01_JPRB /)  
KB(:, 2,13, 9) = (/ &
 & 0.57828E-01_JPRB,0.97972E-01_JPRB,0.11123E+00_JPRB,0.11236E+00_JPRB,0.84782E-01_JPRB /)  
KB(:, 3,13, 9) = (/ &
 & 0.59232E-01_JPRB,0.99998E-01_JPRB,0.11329E+00_JPRB,0.11400E+00_JPRB,0.86728E-01_JPRB /)  
KB(:, 4,13, 9) = (/ &
 & 0.60790E-01_JPRB,0.10219E+00_JPRB,0.11568E+00_JPRB,0.11591E+00_JPRB,0.88651E-01_JPRB /)  
KB(:, 5,13, 9) = (/ &
 & 0.62290E-01_JPRB,0.10448E+00_JPRB,0.11818E+00_JPRB,0.11808E+00_JPRB,0.90606E-01_JPRB /)  
KB(:, 1,14, 9) = (/ &
 & 0.48757E-01_JPRB,0.85742E-01_JPRB,0.97473E-01_JPRB,0.98306E-01_JPRB,0.73073E-01_JPRB /)  
KB(:, 2,14, 9) = (/ &
 & 0.49942E-01_JPRB,0.87692E-01_JPRB,0.99489E-01_JPRB,0.10004E+00_JPRB,0.75064E-01_JPRB /)  
KB(:, 3,14, 9) = (/ &
 & 0.51318E-01_JPRB,0.89856E-01_JPRB,0.10188E+00_JPRB,0.10205E+00_JPRB,0.77018E-01_JPRB /)  
KB(:, 4,14, 9) = (/ &
 & 0.52660E-01_JPRB,0.92153E-01_JPRB,0.10444E+00_JPRB,0.10434E+00_JPRB,0.78996E-01_JPRB /)  
KB(:, 5,14, 9) = (/ &
 & 0.53901E-01_JPRB,0.94584E-01_JPRB,0.10712E+00_JPRB,0.10687E+00_JPRB,0.81028E-01_JPRB /)  
KB(:, 1,15, 9) = (/ &
 & 0.41752E-01_JPRB,0.76198E-01_JPRB,0.86593E-01_JPRB,0.87037E-01_JPRB,0.64464E-01_JPRB /)  
KB(:, 2,15, 9) = (/ &
 & 0.42945E-01_JPRB,0.78277E-01_JPRB,0.88919E-01_JPRB,0.89055E-01_JPRB,0.66440E-01_JPRB /)  
KB(:, 3,15, 9) = (/ &
 & 0.44132E-01_JPRB,0.80544E-01_JPRB,0.91468E-01_JPRB,0.91397E-01_JPRB,0.68401E-01_JPRB /)  
KB(:, 4,15, 9) = (/ &
 & 0.45260E-01_JPRB,0.82968E-01_JPRB,0.94189E-01_JPRB,0.93993E-01_JPRB,0.70410E-01_JPRB /)  
KB(:, 5,15, 9) = (/ &
 & 0.46298E-01_JPRB,0.85502E-01_JPRB,0.97029E-01_JPRB,0.96802E-01_JPRB,0.72466E-01_JPRB /)  
KB(:, 1,16, 9) = (/ &
 & 0.35640E-01_JPRB,0.67555E-01_JPRB,0.76928E-01_JPRB,0.77126E-01_JPRB,0.56847E-01_JPRB /)  
KB(:, 2,16, 9) = (/ &
 & 0.36668E-01_JPRB,0.69730E-01_JPRB,0.79394E-01_JPRB,0.79411E-01_JPRB,0.58796E-01_JPRB /)  
KB(:, 3,16, 9) = (/ &
 & 0.37665E-01_JPRB,0.72105E-01_JPRB,0.82070E-01_JPRB,0.81996E-01_JPRB,0.60763E-01_JPRB /)  
KB(:, 4,16, 9) = (/ &
 & 0.38606E-01_JPRB,0.74641E-01_JPRB,0.84920E-01_JPRB,0.84810E-01_JPRB,0.62792E-01_JPRB /)  
KB(:, 5,16, 9) = (/ &
 & 0.39473E-01_JPRB,0.77118E-01_JPRB,0.87904E-01_JPRB,0.87777E-01_JPRB,0.64884E-01_JPRB /)  
KB(:, 1,17, 9) = (/ &
 & 0.30249E-01_JPRB,0.59768E-01_JPRB,0.68325E-01_JPRB,0.68492E-01_JPRB,0.50101E-01_JPRB /)  
KB(:, 2,17, 9) = (/ &
 & 0.31103E-01_JPRB,0.62060E-01_JPRB,0.70903E-01_JPRB,0.70988E-01_JPRB,0.52022E-01_JPRB /)  
KB(:, 3,17, 9) = (/ &
 & 0.31936E-01_JPRB,0.64534E-01_JPRB,0.73696E-01_JPRB,0.73735E-01_JPRB,0.54005E-01_JPRB /)  
KB(:, 4,17, 9) = (/ &
 & 0.32730E-01_JPRB,0.67029E-01_JPRB,0.76655E-01_JPRB,0.76665E-01_JPRB,0.56059E-01_JPRB /)  
KB(:, 5,17, 9) = (/ &
 & 0.33443E-01_JPRB,0.69449E-01_JPRB,0.79757E-01_JPRB,0.79742E-01_JPRB,0.58173E-01_JPRB /)  
KB(:, 1,18, 9) = (/ &
 & 0.25545E-01_JPRB,0.52871E-01_JPRB,0.60740E-01_JPRB,0.60992E-01_JPRB,0.44172E-01_JPRB /)  
KB(:, 2,18, 9) = (/ &
 & 0.26254E-01_JPRB,0.55233E-01_JPRB,0.63406E-01_JPRB,0.63637E-01_JPRB,0.46086E-01_JPRB /)  
KB(:, 3,18, 9) = (/ &
 & 0.26956E-01_JPRB,0.57692E-01_JPRB,0.66286E-01_JPRB,0.66462E-01_JPRB,0.48089E-01_JPRB /)  
KB(:, 4,18, 9) = (/ &
 & 0.27612E-01_JPRB,0.60136E-01_JPRB,0.69343E-01_JPRB,0.69465E-01_JPRB,0.50154E-01_JPRB /)  
KB(:, 5,18, 9) = (/ &
 & 0.28200E-01_JPRB,0.62534E-01_JPRB,0.72542E-01_JPRB,0.72608E-01_JPRB,0.52275E-01_JPRB /)  
KB(:, 1,19, 9) = (/ &
 & 0.21487E-01_JPRB,0.46786E-01_JPRB,0.54092E-01_JPRB,0.54451E-01_JPRB,0.38986E-01_JPRB /)  
KB(:, 2,19, 9) = (/ &
 & 0.22086E-01_JPRB,0.49151E-01_JPRB,0.56837E-01_JPRB,0.57167E-01_JPRB,0.40916E-01_JPRB /)  
KB(:, 3,19, 9) = (/ &
 & 0.22671E-01_JPRB,0.51565E-01_JPRB,0.59787E-01_JPRB,0.60059E-01_JPRB,0.42916E-01_JPRB /)  
KB(:, 4,19, 9) = (/ &
 & 0.23212E-01_JPRB,0.53966E-01_JPRB,0.62913E-01_JPRB,0.63134E-01_JPRB,0.44993E-01_JPRB /)  
KB(:, 5,19, 9) = (/ &
 & 0.23674E-01_JPRB,0.56335E-01_JPRB,0.66121E-01_JPRB,0.66362E-01_JPRB,0.47140E-01_JPRB /)  
KB(:, 1,20, 9) = (/ &
 & 0.18039E-01_JPRB,0.41493E-01_JPRB,0.48348E-01_JPRB,0.48783E-01_JPRB,0.34522E-01_JPRB /)  
KB(:, 2,20, 9) = (/ &
 & 0.18543E-01_JPRB,0.43801E-01_JPRB,0.51155E-01_JPRB,0.51541E-01_JPRB,0.36457E-01_JPRB /)  
KB(:, 3,20, 9) = (/ &
 & 0.19027E-01_JPRB,0.46166E-01_JPRB,0.54164E-01_JPRB,0.54503E-01_JPRB,0.38468E-01_JPRB /)  
KB(:, 4,20, 9) = (/ &
 & 0.19452E-01_JPRB,0.48538E-01_JPRB,0.57292E-01_JPRB,0.57654E-01_JPRB,0.40551E-01_JPRB /)  
KB(:, 5,20, 9) = (/ &
 & 0.19805E-01_JPRB,0.50879E-01_JPRB,0.60490E-01_JPRB,0.60969E-01_JPRB,0.42726E-01_JPRB /)  
KB(:, 1,21, 9) = (/ &
 & 0.15116E-01_JPRB,0.36867E-01_JPRB,0.43373E-01_JPRB,0.43860E-01_JPRB,0.30692E-01_JPRB /)  
KB(:, 2,21, 9) = (/ &
 & 0.15537E-01_JPRB,0.39121E-01_JPRB,0.46234E-01_JPRB,0.46663E-01_JPRB,0.32616E-01_JPRB /)  
KB(:, 3,21, 9) = (/ &
 & 0.15924E-01_JPRB,0.41438E-01_JPRB,0.49238E-01_JPRB,0.49692E-01_JPRB,0.34628E-01_JPRB /)  
KB(:, 4,21, 9) = (/ &
 & 0.16258E-01_JPRB,0.43774E-01_JPRB,0.52361E-01_JPRB,0.52910E-01_JPRB,0.36736E-01_JPRB /)  
KB(:, 5,21, 9) = (/ &
 & 0.16525E-01_JPRB,0.46101E-01_JPRB,0.55542E-01_JPRB,0.56309E-01_JPRB,0.38934E-01_JPRB /)  
KB(:, 1,22, 9) = (/ &
 & 0.12675E-01_JPRB,0.32993E-01_JPRB,0.39256E-01_JPRB,0.39779E-01_JPRB,0.27529E-01_JPRB /)  
KB(:, 2,22, 9) = (/ &
 & 0.13009E-01_JPRB,0.35201E-01_JPRB,0.42138E-01_JPRB,0.42658E-01_JPRB,0.29453E-01_JPRB /)  
KB(:, 3,22, 9) = (/ &
 & 0.13317E-01_JPRB,0.37474E-01_JPRB,0.45144E-01_JPRB,0.45756E-01_JPRB,0.31474E-01_JPRB /)  
KB(:, 4,22, 9) = (/ &
 & 0.13574E-01_JPRB,0.39784E-01_JPRB,0.48260E-01_JPRB,0.49049E-01_JPRB,0.33608E-01_JPRB /)  
KB(:, 5,22, 9) = (/ &
 & 0.13778E-01_JPRB,0.42099E-01_JPRB,0.51448E-01_JPRB,0.52529E-01_JPRB,0.35844E-01_JPRB /)  
KB(:, 1,23, 9) = (/ &
 & 0.10608E-01_JPRB,0.29677E-01_JPRB,0.35736E-01_JPRB,0.36323E-01_JPRB,0.24847E-01_JPRB /)  
KB(:, 2,23, 9) = (/ &
 & 0.10880E-01_JPRB,0.31843E-01_JPRB,0.38613E-01_JPRB,0.39274E-01_JPRB,0.26772E-01_JPRB /)  
KB(:, 3,23, 9) = (/ &
 & 0.11120E-01_JPRB,0.34081E-01_JPRB,0.41634E-01_JPRB,0.42440E-01_JPRB,0.28816E-01_JPRB /)  
KB(:, 4,23, 9) = (/ &
 & 0.11313E-01_JPRB,0.36372E-01_JPRB,0.44754E-01_JPRB,0.45808E-01_JPRB,0.30978E-01_JPRB /)  
KB(:, 5,23, 9) = (/ &
 & 0.11474E-01_JPRB,0.38689E-01_JPRB,0.47973E-01_JPRB,0.49367E-01_JPRB,0.33255E-01_JPRB /)  
KB(:, 1,24, 9) = (/ &
 & 0.88685E-02_JPRB,0.26862E-01_JPRB,0.32736E-01_JPRB,0.33437E-01_JPRB,0.22600E-01_JPRB /)  
KB(:, 2,24, 9) = (/ &
 & 0.90884E-02_JPRB,0.28994E-01_JPRB,0.35625E-01_JPRB,0.36451E-01_JPRB,0.24532E-01_JPRB /)  
KB(:, 3,24, 9) = (/ &
 & 0.92759E-02_JPRB,0.31210E-01_JPRB,0.38663E-01_JPRB,0.39696E-01_JPRB,0.26600E-01_JPRB /)  
KB(:, 4,24, 9) = (/ &
 & 0.94299E-02_JPRB,0.33488E-01_JPRB,0.41810E-01_JPRB,0.43137E-01_JPRB,0.28795E-01_JPRB /)  
KB(:, 5,24, 9) = (/ &
 & 0.95655E-02_JPRB,0.35810E-01_JPRB,0.45067E-01_JPRB,0.46765E-01_JPRB,0.31119E-01_JPRB /)  
KB(:, 1,25, 9) = (/ &
 & 0.74112E-02_JPRB,0.24493E-01_JPRB,0.30220E-01_JPRB,0.31056E-01_JPRB,0.20732E-01_JPRB /)  
KB(:, 2,25, 9) = (/ &
 & 0.75852E-02_JPRB,0.26600E-01_JPRB,0.33130E-01_JPRB,0.34139E-01_JPRB,0.22685E-01_JPRB /)  
KB(:, 3,25, 9) = (/ &
 & 0.77307E-02_JPRB,0.28805E-01_JPRB,0.36194E-01_JPRB,0.37461E-01_JPRB,0.24778E-01_JPRB /)  
KB(:, 4,25, 9) = (/ &
 & 0.78603E-02_JPRB,0.31085E-01_JPRB,0.39384E-01_JPRB,0.40978E-01_JPRB,0.27016E-01_JPRB /)  
KB(:, 5,25, 9) = (/ &
 & 0.79718E-02_JPRB,0.33416E-01_JPRB,0.42696E-01_JPRB,0.44682E-01_JPRB,0.29393E-01_JPRB /)  
KB(:, 1,26, 9) = (/ &
 & 0.61902E-02_JPRB,0.22538E-01_JPRB,0.28170E-01_JPRB,0.29154E-01_JPRB,0.19220E-01_JPRB /)  
KB(:, 2,26, 9) = (/ &
 & 0.63276E-02_JPRB,0.24632E-01_JPRB,0.31111E-01_JPRB,0.32321E-01_JPRB,0.21200E-01_JPRB /)  
KB(:, 3,26, 9) = (/ &
 & 0.64499E-02_JPRB,0.26835E-01_JPRB,0.34213E-01_JPRB,0.35713E-01_JPRB,0.23332E-01_JPRB /)  
KB(:, 4,26, 9) = (/ &
 & 0.65597E-02_JPRB,0.29126E-01_JPRB,0.37461E-01_JPRB,0.39319E-01_JPRB,0.25615E-01_JPRB /)  
KB(:, 5,26, 9) = (/ &
 & 0.66551E-02_JPRB,0.31472E-01_JPRB,0.40844E-01_JPRB,0.43117E-01_JPRB,0.28057E-01_JPRB /)  
KB(:, 1,27, 9) = (/ &
 & 0.51713E-02_JPRB,0.20911E-01_JPRB,0.26500E-01_JPRB,0.27639E-01_JPRB,0.17995E-01_JPRB /)  
KB(:, 2,27, 9) = (/ &
 & 0.52848E-02_JPRB,0.23004E-01_JPRB,0.29475E-01_JPRB,0.30887E-01_JPRB,0.20007E-01_JPRB /)  
KB(:, 3,27, 9) = (/ &
 & 0.53879E-02_JPRB,0.25219E-01_JPRB,0.32635E-01_JPRB,0.34364E-01_JPRB,0.22181E-01_JPRB /)  
KB(:, 4,27, 9) = (/ &
 & 0.54763E-02_JPRB,0.27525E-01_JPRB,0.35956E-01_JPRB,0.38064E-01_JPRB,0.24520E-01_JPRB /)  
KB(:, 5,27, 9) = (/ &
 & 0.55573E-02_JPRB,0.29889E-01_JPRB,0.39426E-01_JPRB,0.41977E-01_JPRB,0.27035E-01_JPRB /)  
KB(:, 1,28, 9) = (/ &
 & 0.43195E-02_JPRB,0.19576E-01_JPRB,0.25160E-01_JPRB,0.26468E-01_JPRB,0.17016E-01_JPRB /)  
KB(:, 2,28, 9) = (/ &
 & 0.44139E-02_JPRB,0.21680E-01_JPRB,0.28188E-01_JPRB,0.29800E-01_JPRB,0.19070E-01_JPRB /)  
KB(:, 3,28, 9) = (/ &
 & 0.44969E-02_JPRB,0.23912E-01_JPRB,0.31420E-01_JPRB,0.33375E-01_JPRB,0.21294E-01_JPRB /)  
KB(:, 4,28, 9) = (/ &
 & 0.45726E-02_JPRB,0.26235E-01_JPRB,0.34830E-01_JPRB,0.37186E-01_JPRB,0.23695E-01_JPRB /)  
KB(:, 5,28, 9) = (/ &
 & 0.46426E-02_JPRB,0.28627E-01_JPRB,0.38395E-01_JPRB,0.41222E-01_JPRB,0.26282E-01_JPRB /)  
KB(:, 1,29, 9) = (/ &
 & 0.36095E-02_JPRB,0.18508E-01_JPRB,0.24142E-01_JPRB,0.25625E-01_JPRB,0.16268E-01_JPRB /)  
KB(:, 2,29, 9) = (/ &
 & 0.36856E-02_JPRB,0.20634E-01_JPRB,0.27243E-01_JPRB,0.29053E-01_JPRB,0.18372E-01_JPRB /)  
KB(:, 3,29, 9) = (/ &
 & 0.37545E-02_JPRB,0.22890E-01_JPRB,0.30565E-01_JPRB,0.32742E-01_JPRB,0.20653E-01_JPRB /)  
KB(:, 4,29, 9) = (/ &
 & 0.38219E-02_JPRB,0.25246E-01_JPRB,0.34070E-01_JPRB,0.36676E-01_JPRB,0.23125E-01_JPRB /)  
KB(:, 5,29, 9) = (/ &
 & 0.38805E-02_JPRB,0.27676E-01_JPRB,0.37739E-01_JPRB,0.40837E-01_JPRB,0.25787E-01_JPRB /)  
KB(:, 1,30, 9) = (/ &
 & 0.30149E-02_JPRB,0.17668E-01_JPRB,0.23401E-01_JPRB,0.25061E-01_JPRB,0.15717E-01_JPRB /)  
KB(:, 2,30, 9) = (/ &
 & 0.30780E-02_JPRB,0.19823E-01_JPRB,0.26594E-01_JPRB,0.28602E-01_JPRB,0.17873E-01_JPRB /)  
KB(:, 3,30, 9) = (/ &
 & 0.31391E-02_JPRB,0.22111E-01_JPRB,0.30012E-01_JPRB,0.32409E-01_JPRB,0.20220E-01_JPRB /)  
KB(:, 4,30, 9) = (/ &
 & 0.31952E-02_JPRB,0.24511E-01_JPRB,0.33620E-01_JPRB,0.36467E-01_JPRB,0.22768E-01_JPRB /)  
KB(:, 5,30, 9) = (/ &
 & 0.32462E-02_JPRB,0.26992E-01_JPRB,0.37393E-01_JPRB,0.40756E-01_JPRB,0.25513E-01_JPRB /)  
KB(:, 1,31, 9) = (/ &
 & 0.25190E-02_JPRB,0.17039E-01_JPRB,0.22932E-01_JPRB,0.24769E-01_JPRB,0.15346E-01_JPRB /)  
KB(:, 2,31, 9) = (/ &
 & 0.25729E-02_JPRB,0.19232E-01_JPRB,0.26227E-01_JPRB,0.28432E-01_JPRB,0.17564E-01_JPRB /)  
KB(:, 3,31, 9) = (/ &
 & 0.26259E-02_JPRB,0.21567E-01_JPRB,0.29750E-01_JPRB,0.32369E-01_JPRB,0.19984E-01_JPRB /)  
KB(:, 4,31, 9) = (/ &
 & 0.26746E-02_JPRB,0.24020E-01_JPRB,0.33463E-01_JPRB,0.36549E-01_JPRB,0.22614E-01_JPRB /)  
KB(:, 5,31, 9) = (/ &
 & 0.27170E-02_JPRB,0.26556E-01_JPRB,0.37338E-01_JPRB,0.40957E-01_JPRB,0.25451E-01_JPRB /)  
KB(:, 1,32, 9) = (/ &
 & 0.21057E-02_JPRB,0.16597E-01_JPRB,0.22710E-01_JPRB,0.24723E-01_JPRB,0.15137E-01_JPRB /)  
KB(:, 2,32, 9) = (/ &
 & 0.21537E-02_JPRB,0.18840E-01_JPRB,0.26112E-01_JPRB,0.28512E-01_JPRB,0.17424E-01_JPRB /)  
KB(:, 3,32, 9) = (/ &
 & 0.21983E-02_JPRB,0.21233E-01_JPRB,0.29743E-01_JPRB,0.32575E-01_JPRB,0.19926E-01_JPRB /)  
KB(:, 4,32, 9) = (/ &
 & 0.22397E-02_JPRB,0.23745E-01_JPRB,0.33557E-01_JPRB,0.36873E-01_JPRB,0.22643E-01_JPRB /)  
KB(:, 5,32, 9) = (/ &
 & 0.22779E-02_JPRB,0.26339E-01_JPRB,0.37525E-01_JPRB,0.41395E-01_JPRB,0.25571E-01_JPRB /)  
KB(:, 1,33, 9) = (/ &
 & 0.17621E-02_JPRB,0.16326E-01_JPRB,0.22706E-01_JPRB,0.24894E-01_JPRB,0.15071E-01_JPRB /)  
KB(:, 2,33, 9) = (/ &
 & 0.18037E-02_JPRB,0.18626E-01_JPRB,0.26218E-01_JPRB,0.28807E-01_JPRB,0.17434E-01_JPRB /)  
KB(:, 3,33, 9) = (/ &
 & 0.18413E-02_JPRB,0.21083E-01_JPRB,0.29952E-01_JPRB,0.32989E-01_JPRB,0.20023E-01_JPRB /)  
KB(:, 4,33, 9) = (/ &
 & 0.18774E-02_JPRB,0.23655E-01_JPRB,0.33863E-01_JPRB,0.37400E-01_JPRB,0.22833E-01_JPRB /)  
KB(:, 5,33, 9) = (/ &
 & 0.19114E-02_JPRB,0.26308E-01_JPRB,0.37916E-01_JPRB,0.42025E-01_JPRB,0.25847E-01_JPRB /)  
KB(:, 1,34, 9) = (/ &
 & 0.14751E-02_JPRB,0.16125E-01_JPRB,0.22769E-01_JPRB,0.25117E-01_JPRB,0.15050E-01_JPRB /)  
KB(:, 2,34, 9) = (/ &
 & 0.15101E-02_JPRB,0.18488E-01_JPRB,0.26381E-01_JPRB,0.29139E-01_JPRB,0.17489E-01_JPRB /)  
KB(:, 3,34, 9) = (/ &
 & 0.15432E-02_JPRB,0.21005E-01_JPRB,0.30205E-01_JPRB,0.33424E-01_JPRB,0.20158E-01_JPRB /)  
KB(:, 4,34, 9) = (/ &
 & 0.15747E-02_JPRB,0.23633E-01_JPRB,0.34198E-01_JPRB,0.37931E-01_JPRB,0.23050E-01_JPRB /)  
KB(:, 5,34, 9) = (/ &
 & 0.16051E-02_JPRB,0.26339E-01_JPRB,0.38321E-01_JPRB,0.42642E-01_JPRB,0.26140E-01_JPRB /)  
KB(:, 1,35, 9) = (/ &
 & 0.12323E-02_JPRB,0.15834E-01_JPRB,0.22646E-01_JPRB,0.25106E-01_JPRB,0.14908E-01_JPRB /)  
KB(:, 2,35, 9) = (/ &
 & 0.12626E-02_JPRB,0.18245E-01_JPRB,0.26331E-01_JPRB,0.29206E-01_JPRB,0.17403E-01_JPRB /)  
KB(:, 3,35, 9) = (/ &
 & 0.12919E-02_JPRB,0.20808E-01_JPRB,0.30221E-01_JPRB,0.33562E-01_JPRB,0.20132E-01_JPRB /)  
KB(:, 4,35, 9) = (/ &
 & 0.13197E-02_JPRB,0.23481E-01_JPRB,0.34270E-01_JPRB,0.38136E-01_JPRB,0.23081E-01_JPRB /)  
KB(:, 5,35, 9) = (/ &
 & 0.13470E-02_JPRB,0.26228E-01_JPRB,0.38442E-01_JPRB,0.42907E-01_JPRB,0.26222E-01_JPRB /)  
KB(:, 1,36, 9) = (/ &
 & 0.10273E-02_JPRB,0.15393E-01_JPRB,0.22247E-01_JPRB,0.24766E-01_JPRB,0.14589E-01_JPRB /)  
KB(:, 2,36, 9) = (/ &
 & 0.10537E-02_JPRB,0.17833E-01_JPRB,0.25974E-01_JPRB,0.28911E-01_JPRB,0.17115E-01_JPRB /)  
KB(:, 3,36, 9) = (/ &
 & 0.10795E-02_JPRB,0.20426E-01_JPRB,0.29904E-01_JPRB,0.33307E-01_JPRB,0.19875E-01_JPRB /)  
KB(:, 4,36, 9) = (/ &
 & 0.11043E-02_JPRB,0.23131E-01_JPRB,0.33989E-01_JPRB,0.37917E-01_JPRB,0.22855E-01_JPRB /)  
KB(:, 5,36, 9) = (/ &
 & 0.11288E-02_JPRB,0.25909E-01_JPRB,0.38197E-01_JPRB,0.42722E-01_JPRB,0.26026E-01_JPRB /)  
KB(:, 1,37, 9) = (/ &
 & 0.85383E-03_JPRB,0.14679E-01_JPRB,0.21388E-01_JPRB,0.23897E-01_JPRB,0.13970E-01_JPRB /)  
KB(:, 2,37, 9) = (/ &
 & 0.87682E-03_JPRB,0.17120E-01_JPRB,0.25115E-01_JPRB,0.28039E-01_JPRB,0.16489E-01_JPRB /)  
KB(:, 3,37, 9) = (/ &
 & 0.89996E-03_JPRB,0.19721E-01_JPRB,0.29054E-01_JPRB,0.32436E-01_JPRB,0.19242E-01_JPRB /)  
KB(:, 4,37, 9) = (/ &
 & 0.92246E-03_JPRB,0.22439E-01_JPRB,0.33150E-01_JPRB,0.37047E-01_JPRB,0.22217E-01_JPRB /)  
KB(:, 5,37, 9) = (/ &
 & 0.94506E-03_JPRB,0.25234E-01_JPRB,0.37369E-01_JPRB,0.41852E-01_JPRB,0.25386E-01_JPRB /)  
KB(:, 1,38, 9) = (/ &
 & 0.70953E-03_JPRB,0.14014E-01_JPRB,0.20566E-01_JPRB,0.23058E-01_JPRB,0.13383E-01_JPRB /)  
KB(:, 2,38, 9) = (/ &
 & 0.73008E-03_JPRB,0.16455E-01_JPRB,0.24289E-01_JPRB,0.27191E-01_JPRB,0.15892E-01_JPRB /)  
KB(:, 3,38, 9) = (/ &
 & 0.75050E-03_JPRB,0.19058E-01_JPRB,0.28230E-01_JPRB,0.31581E-01_JPRB,0.18633E-01_JPRB /)  
KB(:, 4,38, 9) = (/ &
 & 0.77107E-03_JPRB,0.21784E-01_JPRB,0.32331E-01_JPRB,0.36184E-01_JPRB,0.21597E-01_JPRB /)  
KB(:, 5,38, 9) = (/ &
 & 0.79117E-03_JPRB,0.24590E-01_JPRB,0.36557E-01_JPRB,0.40986E-01_JPRB,0.24760E-01_JPRB /)  
KB(:, 1,39, 9) = (/ &
 & 0.58982E-03_JPRB,0.13410E-01_JPRB,0.19807E-01_JPRB,0.22275E-01_JPRB,0.12843E-01_JPRB /)  
KB(:, 2,39, 9) = (/ &
 & 0.60777E-03_JPRB,0.15847E-01_JPRB,0.23520E-01_JPRB,0.26395E-01_JPRB,0.15340E-01_JPRB /)  
KB(:, 3,39, 9) = (/ &
 & 0.62607E-03_JPRB,0.18449E-01_JPRB,0.27458E-01_JPRB,0.30773E-01_JPRB,0.18067E-01_JPRB /)  
KB(:, 4,39, 9) = (/ &
 & 0.64471E-03_JPRB,0.21179E-01_JPRB,0.31559E-01_JPRB,0.35367E-01_JPRB,0.21018E-01_JPRB /)  
KB(:, 5,39, 9) = (/ &
 & 0.66285E-03_JPRB,0.23994E-01_JPRB,0.35788E-01_JPRB,0.40160E-01_JPRB,0.24170E-01_JPRB /)  
KB(:, 1,40, 9) = (/ &
 & 0.48914E-03_JPRB,0.12617E-01_JPRB,0.18733E-01_JPRB,0.21131E-01_JPRB,0.12100E-01_JPRB /)  
KB(:, 2,40, 9) = (/ &
 & 0.50499E-03_JPRB,0.15028E-01_JPRB,0.22406E-01_JPRB,0.25206E-01_JPRB,0.14559E-01_JPRB /)  
KB(:, 3,40, 9) = (/ &
 & 0.52119E-03_JPRB,0.17611E-01_JPRB,0.26314E-01_JPRB,0.29544E-01_JPRB,0.17245E-01_JPRB /)  
KB(:, 4,40, 9) = (/ &
 & 0.53770E-03_JPRB,0.20330E-01_JPRB,0.30397E-01_JPRB,0.34103E-01_JPRB,0.20159E-01_JPRB /)  
KB(:, 5,40, 9) = (/ &
 & 0.55398E-03_JPRB,0.23142E-01_JPRB,0.34616E-01_JPRB,0.38867E-01_JPRB,0.23278E-01_JPRB /)  
KB(:, 1,41, 9) = (/ &
 & 0.40532E-03_JPRB,0.11840E-01_JPRB,0.17661E-01_JPRB,0.19981E-01_JPRB,0.11365E-01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART25',1,ZHOOK_HANDLE)
END SUBROUTINE PART25


SUBROUTINE PART26

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART26',0,ZHOOK_HANDLE)


KB(:, 2,41, 9) = (/ &
 & 0.41916E-03_JPRB,0.14219E-01_JPRB,0.21285E-01_JPRB,0.24002E-01_JPRB,0.13782E-01_JPRB /)  
KB(:, 3,41, 9) = (/ &
 & 0.43354E-03_JPRB,0.16775E-01_JPRB,0.25154E-01_JPRB,0.28292E-01_JPRB,0.16423E-01_JPRB /)  
KB(:, 4,41, 9) = (/ &
 & 0.44807E-03_JPRB,0.19478E-01_JPRB,0.29214E-01_JPRB,0.32812E-01_JPRB,0.19291E-01_JPRB /)  
KB(:, 5,41, 9) = (/ &
 & 0.46282E-03_JPRB,0.22283E-01_JPRB,0.33415E-01_JPRB,0.37538E-01_JPRB,0.22373E-01_JPRB /)  
KB(:, 1,42, 9) = (/ &
 & 0.33573E-03_JPRB,0.11104E-01_JPRB,0.16634E-01_JPRB,0.18873E-01_JPRB,0.10664E-01_JPRB /)  
KB(:, 2,42, 9) = (/ &
 & 0.34776E-03_JPRB,0.13446E-01_JPRB,0.20201E-01_JPRB,0.22835E-01_JPRB,0.13037E-01_JPRB /)  
KB(:, 3,42, 9) = (/ &
 & 0.36046E-03_JPRB,0.15973E-01_JPRB,0.24027E-01_JPRB,0.27071E-01_JPRB,0.15631E-01_JPRB /)  
KB(:, 4,42, 9) = (/ &
 & 0.37344E-03_JPRB,0.18654E-01_JPRB,0.28057E-01_JPRB,0.31550E-01_JPRB,0.18451E-01_JPRB /)  
KB(:, 5,42, 9) = (/ &
 & 0.38663E-03_JPRB,0.21448E-01_JPRB,0.32235E-01_JPRB,0.36231E-01_JPRB,0.21492E-01_JPRB /)  
KB(:, 1,43, 9) = (/ &
 & 0.27733E-03_JPRB,0.10283E-01_JPRB,0.15460E-01_JPRB,0.17597E-01_JPRB,0.98707E-02_JPRB /)  
KB(:, 2,43, 9) = (/ &
 & 0.28779E-03_JPRB,0.12571E-01_JPRB,0.18947E-01_JPRB,0.21473E-01_JPRB,0.12183E-01_JPRB /)  
KB(:, 3,43, 9) = (/ &
 & 0.29891E-03_JPRB,0.15054E-01_JPRB,0.22712E-01_JPRB,0.25638E-01_JPRB,0.14718E-01_JPRB /)  
KB(:, 4,43, 9) = (/ &
 & 0.31033E-03_JPRB,0.17702E-01_JPRB,0.26696E-01_JPRB,0.30055E-01_JPRB,0.17477E-01_JPRB /)  
KB(:, 5,43, 9) = (/ &
 & 0.32200E-03_JPRB,0.20476E-01_JPRB,0.30841E-01_JPRB,0.34682E-01_JPRB,0.20459E-01_JPRB /)  
KB(:, 1,44, 9) = (/ &
 & 0.22878E-03_JPRB,0.94499E-02_JPRB,0.14251E-01_JPRB,0.16276E-01_JPRB,0.90607E-02_JPRB /)  
KB(:, 2,44, 9) = (/ &
 & 0.23775E-03_JPRB,0.11673E-01_JPRB,0.17646E-01_JPRB,0.20049E-01_JPRB,0.11303E-01_JPRB /)  
KB(:, 3,44, 9) = (/ &
 & 0.24747E-03_JPRB,0.14106E-01_JPRB,0.21336E-01_JPRB,0.24135E-01_JPRB,0.13772E-01_JPRB /)  
KB(:, 4,44, 9) = (/ &
 & 0.25755E-03_JPRB,0.16710E-01_JPRB,0.25261E-01_JPRB,0.28479E-01_JPRB,0.16464E-01_JPRB /)  
KB(:, 5,44, 9) = (/ &
 & 0.26798E-03_JPRB,0.19454E-01_JPRB,0.29363E-01_JPRB,0.33046E-01_JPRB,0.19378E-01_JPRB /)  
KB(:, 1,45, 9) = (/ &
 & 0.18849E-03_JPRB,0.86584E-02_JPRB,0.13096E-01_JPRB,0.15007E-01_JPRB,0.82904E-02_JPRB /)  
KB(:, 2,45, 9) = (/ &
 & 0.19636E-03_JPRB,0.10814E-01_JPRB,0.16390E-01_JPRB,0.18672E-01_JPRB,0.10458E-01_JPRB /)  
KB(:, 3,45, 9) = (/ &
 & 0.20470E-03_JPRB,0.13189E-01_JPRB,0.19995E-01_JPRB,0.22671E-01_JPRB,0.12861E-01_JPRB /)  
KB(:, 4,45, 9) = (/ &
 & 0.21344E-03_JPRB,0.15746E-01_JPRB,0.23854E-01_JPRB,0.26936E-01_JPRB,0.15483E-01_JPRB /)  
KB(:, 5,45, 9) = (/ &
 & 0.22266E-03_JPRB,0.18454E-01_JPRB,0.27912E-01_JPRB,0.31439E-01_JPRB,0.18328E-01_JPRB /)  
KB(:, 1,46, 9) = (/ &
 & 0.15507E-03_JPRB,0.78632E-02_JPRB,0.11928E-01_JPRB,0.13712E-01_JPRB,0.75164E-02_JPRB /)  
KB(:, 2,46, 9) = (/ &
 & 0.16179E-03_JPRB,0.99413E-02_JPRB,0.15104E-01_JPRB,0.17260E-01_JPRB,0.95985E-02_JPRB /)  
KB(:, 3,46, 9) = (/ &
 & 0.16890E-03_JPRB,0.12249E-01_JPRB,0.18612E-01_JPRB,0.21154E-01_JPRB,0.11927E-01_JPRB /)  
KB(:, 4,46, 9) = (/ &
 & 0.17659E-03_JPRB,0.14751E-01_JPRB,0.22394E-01_JPRB,0.25333E-01_JPRB,0.14476E-01_JPRB /)  
KB(:, 5,46, 9) = (/ &
 & 0.18474E-03_JPRB,0.17415E-01_JPRB,0.26393E-01_JPRB,0.29761E-01_JPRB,0.17246E-01_JPRB /)  
KB(:, 1,47, 9) = (/ &
 & 0.12726E-03_JPRB,0.70304E-02_JPRB,0.10696E-01_JPRB,0.12336E-01_JPRB,0.67029E-02_JPRB /)  
KB(:, 2,47, 9) = (/ &
 & 0.13291E-03_JPRB,0.90171E-02_JPRB,0.13730E-01_JPRB,0.15745E-01_JPRB,0.86863E-02_JPRB /)  
KB(:, 3,47, 9) = (/ &
 & 0.13906E-03_JPRB,0.11243E-01_JPRB,0.17120E-01_JPRB,0.19510E-01_JPRB,0.10925E-01_JPRB /)  
KB(:, 4,47, 9) = (/ &
 & 0.14561E-03_JPRB,0.13678E-01_JPRB,0.20805E-01_JPRB,0.23588E-01_JPRB,0.13392E-01_JPRB /)  
KB(:, 5,47, 9) = (/ &
 & 0.15268E-03_JPRB,0.16286E-01_JPRB,0.24728E-01_JPRB,0.27924E-01_JPRB,0.16077E-01_JPRB /)  
KB(:, 1,48, 9) = (/ &
 & 0.10430E-03_JPRB,0.62479E-02_JPRB,0.95325E-02_JPRB,0.11029E-01_JPRB,0.59380E-02_JPRB /)  
KB(:, 2,48, 9) = (/ &
 & 0.10909E-03_JPRB,0.81380E-02_JPRB,0.12419E-01_JPRB,0.14291E-01_JPRB,0.78205E-02_JPRB /)  
KB(:, 3,48, 9) = (/ &
 & 0.11429E-03_JPRB,0.10277E-01_JPRB,0.15680E-01_JPRB,0.17922E-01_JPRB,0.99641E-02_JPRB /)  
KB(:, 4,48, 9) = (/ &
 & 0.11996E-03_JPRB,0.12637E-01_JPRB,0.19259E-01_JPRB,0.21888E-01_JPRB,0.12347E-01_JPRB /)  
KB(:, 5,48, 9) = (/ &
 & 0.12611E-03_JPRB,0.15183E-01_JPRB,0.23095E-01_JPRB,0.26125E-01_JPRB,0.14947E-01_JPRB /)  
KB(:, 1,49, 9) = (/ &
 & 0.85361E-04_JPRB,0.55178E-02_JPRB,0.84413E-02_JPRB,0.97939E-02_JPRB,0.52224E-02_JPRB /)  
KB(:, 2,49, 9) = (/ &
 & 0.89682E-04_JPRB,0.73124E-02_JPRB,0.11182E-01_JPRB,0.12906E-01_JPRB,0.70024E-02_JPRB /)  
KB(:, 3,49, 9) = (/ &
 & 0.93818E-04_JPRB,0.93518E-02_JPRB,0.14295E-01_JPRB,0.16393E-01_JPRB,0.90454E-02_JPRB /)  
KB(:, 4,49, 9) = (/ &
 & 0.98731E-04_JPRB,0.11631E-01_JPRB,0.17758E-01_JPRB,0.20234E-01_JPRB,0.11339E-01_JPRB /)  
KB(:, 5,49, 9) = (/ &
 & 0.10398E-03_JPRB,0.14111E-01_JPRB,0.21502E-01_JPRB,0.24370E-01_JPRB,0.13856E-01_JPRB /)  
KB(:, 1,50, 9) = (/ &
 & 0.70068E-04_JPRB,0.48843E-02_JPRB,0.74862E-02_JPRB,0.87029E-02_JPRB,0.45961E-02_JPRB /)  
KB(:, 2,50, 9) = (/ &
 & 0.73528E-04_JPRB,0.65706E-02_JPRB,0.10074E-01_JPRB,0.11661E-01_JPRB,0.62737E-02_JPRB /)  
KB(:, 3,50, 9) = (/ &
 & 0.77377E-04_JPRB,0.85288E-02_JPRB,0.13057E-01_JPRB,0.15019E-01_JPRB,0.82236E-02_JPRB /)  
KB(:, 4,50, 9) = (/ &
 & 0.81195E-04_JPRB,0.10720E-01_JPRB,0.16396E-01_JPRB,0.18728E-01_JPRB,0.10428E-01_JPRB /)  
KB(:, 5,50, 9) = (/ &
 & 0.85703E-04_JPRB,0.13133E-01_JPRB,0.20042E-01_JPRB,0.22765E-01_JPRB,0.12867E-01_JPRB /)  
KB(:, 1,51, 9) = (/ &
 & 0.57383E-04_JPRB,0.43058E-02_JPRB,0.66126E-02_JPRB,0.77023E-02_JPRB,0.40299E-02_JPRB /)  
KB(:, 2,51, 9) = (/ &
 & 0.60290E-04_JPRB,0.58916E-02_JPRB,0.90543E-02_JPRB,0.10509E-01_JPRB,0.56057E-02_JPRB /)  
KB(:, 3,51, 9) = (/ &
 & 0.63513E-04_JPRB,0.77586E-02_JPRB,0.11901E-01_JPRB,0.13729E-01_JPRB,0.74620E-02_JPRB /)  
KB(:, 4,51, 9) = (/ &
 & 0.66727E-04_JPRB,0.98672E-02_JPRB,0.15116E-01_JPRB,0.17314E-01_JPRB,0.95779E-02_JPRB /)  
KB(:, 5,51, 9) = (/ &
 & 0.70598E-04_JPRB,0.12209E-01_JPRB,0.18661E-01_JPRB,0.21244E-01_JPRB,0.11938E-01_JPRB /)  
KB(:, 1,52, 9) = (/ &
 & 0.46933E-04_JPRB,0.37683E-02_JPRB,0.57987E-02_JPRB,0.67684E-02_JPRB,0.35066E-02_JPRB /)  
KB(:, 2,52, 9) = (/ &
 & 0.49374E-04_JPRB,0.52554E-02_JPRB,0.80944E-02_JPRB,0.94163E-02_JPRB,0.49785E-02_JPRB /)  
KB(:, 3,52, 9) = (/ &
 & 0.52069E-04_JPRB,0.70251E-02_JPRB,0.10799E-01_JPRB,0.12493E-01_JPRB,0.67384E-02_JPRB /)  
KB(:, 4,52, 9) = (/ &
 & 0.55066E-04_JPRB,0.90579E-02_JPRB,0.13892E-01_JPRB,0.15957E-01_JPRB,0.87644E-02_JPRB /)  
KB(:, 5,52, 9) = (/ &
 & 0.58094E-04_JPRB,0.11314E-01_JPRB,0.17321E-01_JPRB,0.19762E-01_JPRB,0.11039E-01_JPRB /)  
KB(:, 1,53, 9) = (/ &
 & 0.38369E-04_JPRB,0.32705E-02_JPRB,0.50428E-02_JPRB,0.58997E-02_JPRB,0.30250E-02_JPRB /)  
KB(:, 2,53, 9) = (/ &
 & 0.40389E-04_JPRB,0.46579E-02_JPRB,0.71882E-02_JPRB,0.83794E-02_JPRB,0.43908E-02_JPRB /)  
KB(:, 3,53, 9) = (/ &
 & 0.42656E-04_JPRB,0.63275E-02_JPRB,0.97486E-02_JPRB,0.11308E-01_JPRB,0.60500E-02_JPRB /)  
KB(:, 4,53, 9) = (/ &
 & 0.45173E-04_JPRB,0.82714E-02_JPRB,0.12706E-01_JPRB,0.14639E-01_JPRB,0.79824E-02_JPRB /)  
KB(:, 5,53, 9) = (/ &
 & 0.47733E-04_JPRB,0.10447E-01_JPRB,0.16018E-01_JPRB,0.18320E-01_JPRB,0.10170E-01_JPRB /)  
KB(:, 1,54, 9) = (/ &
 & 0.31373E-04_JPRB,0.28489E-02_JPRB,0.44023E-02_JPRB,0.51602E-02_JPRB,0.26198E-02_JPRB /)  
KB(:, 2,54, 9) = (/ &
 & 0.33072E-04_JPRB,0.41448E-02_JPRB,0.64072E-02_JPRB,0.74821E-02_JPRB,0.38868E-02_JPRB /)  
KB(:, 3,54, 9) = (/ &
 & 0.34962E-04_JPRB,0.57219E-02_JPRB,0.88331E-02_JPRB,0.10271E-01_JPRB,0.54518E-02_JPRB /)  
KB(:, 4,54, 9) = (/ &
 & 0.37073E-04_JPRB,0.75801E-02_JPRB,0.11663E-01_JPRB,0.13472E-01_JPRB,0.72975E-02_JPRB /)  
KB(:, 5,54, 9) = (/ &
 & 0.39224E-04_JPRB,0.96795E-02_JPRB,0.14861E-01_JPRB,0.17039E-01_JPRB,0.94030E-02_JPRB /)  
KB(:, 1,55, 9) = (/ &
 & 0.25649E-04_JPRB,0.24774E-02_JPRB,0.38358E-02_JPRB,0.45027E-02_JPRB,0.22635E-02_JPRB /)  
KB(:, 2,55, 9) = (/ &
 & 0.27065E-04_JPRB,0.36831E-02_JPRB,0.57040E-02_JPRB,0.66733E-02_JPRB,0.34361E-02_JPRB /)  
KB(:, 3,55, 9) = (/ &
 & 0.28649E-04_JPRB,0.51728E-02_JPRB,0.80003E-02_JPRB,0.93199E-02_JPRB,0.49087E-02_JPRB /)  
KB(:, 4,55, 9) = (/ &
 & 0.30419E-04_JPRB,0.69443E-02_JPRB,0.10704E-01_JPRB,0.12395E-01_JPRB,0.66688E-02_JPRB /)  
KB(:, 5,55, 9) = (/ &
 & 0.32478E-04_JPRB,0.89781E-02_JPRB,0.13794E-01_JPRB,0.15856E-01_JPRB,0.86947E-02_JPRB /)  
KB(:, 1,56, 9) = (/ &
 & 0.20960E-04_JPRB,0.21374E-02_JPRB,0.33161E-02_JPRB,0.38972E-02_JPRB,0.19394E-02_JPRB /)  
KB(:, 2,56, 9) = (/ &
 & 0.22130E-04_JPRB,0.32530E-02_JPRB,0.50471E-02_JPRB,0.59166E-02_JPRB,0.30185E-02_JPRB /)  
KB(:, 3,56, 9) = (/ &
 & 0.23455E-04_JPRB,0.46545E-02_JPRB,0.72105E-02_JPRB,0.84156E-02_JPRB,0.43975E-02_JPRB /)  
KB(:, 4,56, 9) = (/ &
 & 0.24958E-04_JPRB,0.63377E-02_JPRB,0.97876E-02_JPRB,0.11360E-01_JPRB,0.60688E-02_JPRB /)  
KB(:, 5,56, 9) = (/ &
 & 0.26672E-04_JPRB,0.82933E-02_JPRB,0.12759E-01_JPRB,0.14704E-01_JPRB,0.80123E-02_JPRB /)  
KB(:, 1,57, 9) = (/ &
 & 0.17108E-04_JPRB,0.18275E-02_JPRB,0.28407E-02_JPRB,0.33429E-02_JPRB,0.16463E-02_JPRB /)  
KB(:, 2,57, 9) = (/ &
 & 0.18082E-04_JPRB,0.28535E-02_JPRB,0.44360E-02_JPRB,0.52097E-02_JPRB,0.26326E-02_JPRB /)  
KB(:, 3,57, 9) = (/ &
 & 0.19184E-04_JPRB,0.41668E-02_JPRB,0.64646E-02_JPRB,0.75572E-02_JPRB,0.39170E-02_JPRB /)  
KB(:, 4,57, 9) = (/ &
 & 0.20446E-04_JPRB,0.57610E-02_JPRB,0.89128E-02_JPRB,0.10368E-01_JPRB,0.54979E-02_JPRB /)  
KB(:, 5,57, 9) = (/ &
 & 0.21854E-04_JPRB,0.76342E-02_JPRB,0.11762E-01_JPRB,0.13588E-01_JPRB,0.73577E-02_JPRB /)  
KB(:, 1,58, 9) = (/ &
 & 0.13963E-04_JPRB,0.15602E-02_JPRB,0.24292E-02_JPRB,0.28638E-02_JPRB,0.13965E-02_JPRB /)  
KB(:, 2,58, 9) = (/ &
 & 0.14773E-04_JPRB,0.25031E-02_JPRB,0.38984E-02_JPRB,0.45849E-02_JPRB,0.22957E-02_JPRB /)  
KB(:, 3,58, 9) = (/ &
 & 0.15698E-04_JPRB,0.37311E-02_JPRB,0.57975E-02_JPRB,0.67885E-02_JPRB,0.34899E-02_JPRB /)  
KB(:, 4,58, 9) = (/ &
 & 0.16731E-04_JPRB,0.52413E-02_JPRB,0.81221E-02_JPRB,0.94657E-02_JPRB,0.49831E-02_JPRB /)  
KB(:, 5,58, 9) = (/ &
 & 0.17926E-04_JPRB,0.70329E-02_JPRB,0.10852E-01_JPRB,0.12566E-01_JPRB,0.67622E-02_JPRB /)  
KB(:, 1,59, 9) = (/ &
 & 0.11515E-04_JPRB,0.14557E-02_JPRB,0.22712E-02_JPRB,0.26808E-02_JPRB,0.13001E-02_JPRB /)  
KB(:, 2,59, 9) = (/ &
 & 0.12194E-04_JPRB,0.23665E-02_JPRB,0.36913E-02_JPRB,0.43444E-02_JPRB,0.21654E-02_JPRB /)  
KB(:, 3,59, 9) = (/ &
 & 0.12975E-04_JPRB,0.35608E-02_JPRB,0.55385E-02_JPRB,0.64911E-02_JPRB,0.33241E-02_JPRB /)  
KB(:, 4,59, 9) = (/ &
 & 0.13854E-04_JPRB,0.50382E-02_JPRB,0.78142E-02_JPRB,0.91137E-02_JPRB,0.47825E-02_JPRB /)  
KB(:, 5,59, 9) = (/ &
 & 0.14890E-04_JPRB,0.67966E-02_JPRB,0.10497E-01_JPRB,0.12166E-01_JPRB,0.65291E-02_JPRB /)  
KB(:, 1,13,10) = (/ &
 & 0.23136E+00_JPRB,0.35590E+00_JPRB,0.41705E+00_JPRB,0.42838E+00_JPRB,0.34405E+00_JPRB /)  
KB(:, 2,13,10) = (/ &
 & 0.23570E+00_JPRB,0.35573E+00_JPRB,0.41855E+00_JPRB,0.43318E+00_JPRB,0.34979E+00_JPRB /)  
KB(:, 3,13,10) = (/ &
 & 0.23997E+00_JPRB,0.35949E+00_JPRB,0.42029E+00_JPRB,0.43813E+00_JPRB,0.35426E+00_JPRB /)  
KB(:, 4,13,10) = (/ &
 & 0.24492E+00_JPRB,0.36590E+00_JPRB,0.42350E+00_JPRB,0.44177E+00_JPRB,0.35947E+00_JPRB /)  
KB(:, 5,13,10) = (/ &
 & 0.25202E+00_JPRB,0.37242E+00_JPRB,0.42924E+00_JPRB,0.44467E+00_JPRB,0.36481E+00_JPRB /)  
KB(:, 1,14,10) = (/ &
 & 0.20433E+00_JPRB,0.32280E+00_JPRB,0.38114E+00_JPRB,0.39530E+00_JPRB,0.30987E+00_JPRB /)  
KB(:, 2,14,10) = (/ &
 & 0.20812E+00_JPRB,0.32580E+00_JPRB,0.38400E+00_JPRB,0.40099E+00_JPRB,0.31521E+00_JPRB /)  
KB(:, 3,14,10) = (/ &
 & 0.21260E+00_JPRB,0.33207E+00_JPRB,0.38794E+00_JPRB,0.40573E+00_JPRB,0.32135E+00_JPRB /)  
KB(:, 4,14,10) = (/ &
 & 0.21971E+00_JPRB,0.33857E+00_JPRB,0.39426E+00_JPRB,0.40959E+00_JPRB,0.32811E+00_JPRB /)  
KB(:, 5,14,10) = (/ &
 & 0.22862E+00_JPRB,0.34522E+00_JPRB,0.40235E+00_JPRB,0.41376E+00_JPRB,0.33439E+00_JPRB /)  
KB(:, 1,15,10) = (/ &
 & 0.17974E+00_JPRB,0.29385E+00_JPRB,0.34710E+00_JPRB,0.36214E+00_JPRB,0.27698E+00_JPRB /)  
KB(:, 2,15,10) = (/ &
 & 0.18361E+00_JPRB,0.29985E+00_JPRB,0.35176E+00_JPRB,0.36835E+00_JPRB,0.28361E+00_JPRB /)  
KB(:, 3,15,10) = (/ &
 & 0.19011E+00_JPRB,0.30650E+00_JPRB,0.35844E+00_JPRB,0.37336E+00_JPRB,0.29140E+00_JPRB /)  
KB(:, 4,15,10) = (/ &
 & 0.19870E+00_JPRB,0.31340E+00_JPRB,0.36676E+00_JPRB,0.37856E+00_JPRB,0.29913E+00_JPRB /)  
KB(:, 5,15,10) = (/ &
 & 0.20713E+00_JPRB,0.32067E+00_JPRB,0.37517E+00_JPRB,0.38452E+00_JPRB,0.30673E+00_JPRB /)  
KB(:, 1,16,10) = (/ &
 & 0.15768E+00_JPRB,0.26909E+00_JPRB,0.31566E+00_JPRB,0.32905E+00_JPRB,0.24795E+00_JPRB /)  
KB(:, 2,16,10) = (/ &
 & 0.16341E+00_JPRB,0.27579E+00_JPRB,0.32257E+00_JPRB,0.33542E+00_JPRB,0.25593E+00_JPRB /)  
KB(:, 3,16,10) = (/ &
 & 0.17143E+00_JPRB,0.28283E+00_JPRB,0.33152E+00_JPRB,0.34164E+00_JPRB,0.26468E+00_JPRB /)  
KB(:, 4,16,10) = (/ &
 & 0.17943E+00_JPRB,0.29026E+00_JPRB,0.34054E+00_JPRB,0.34897E+00_JPRB,0.27328E+00_JPRB /)  
KB(:, 5,16,10) = (/ &
 & 0.18690E+00_JPRB,0.29935E+00_JPRB,0.34954E+00_JPRB,0.35767E+00_JPRB,0.28225E+00_JPRB /)  
KB(:, 1,17,10) = (/ &
 & 0.13875E+00_JPRB,0.24652E+00_JPRB,0.28696E+00_JPRB,0.29693E+00_JPRB,0.22321E+00_JPRB /)  
KB(:, 2,17,10) = (/ &
 & 0.14611E+00_JPRB,0.25366E+00_JPRB,0.29630E+00_JPRB,0.30411E+00_JPRB,0.23216E+00_JPRB /)  
KB(:, 3,17,10) = (/ &
 & 0.15377E+00_JPRB,0.26122E+00_JPRB,0.30597E+00_JPRB,0.31229E+00_JPRB,0.24127E+00_JPRB /)  
KB(:, 4,17,10) = (/ &
 & 0.16099E+00_JPRB,0.27029E+00_JPRB,0.31565E+00_JPRB,0.32218E+00_JPRB,0.25077E+00_JPRB /)  
KB(:, 5,17,10) = (/ &
 & 0.16791E+00_JPRB,0.28100E+00_JPRB,0.32533E+00_JPRB,0.33316E+00_JPRB,0.26091E+00_JPRB /)  
KB(:, 1,18,10) = (/ &
 & 0.12258E+00_JPRB,0.22568E+00_JPRB,0.26154E+00_JPRB,0.26746E+00_JPRB,0.20208E+00_JPRB /)  
KB(:, 2,18,10) = (/ &
 & 0.12972E+00_JPRB,0.23340E+00_JPRB,0.27183E+00_JPRB,0.27607E+00_JPRB,0.21144E+00_JPRB /)  
KB(:, 3,18,10) = (/ &
 & 0.13673E+00_JPRB,0.24228E+00_JPRB,0.28202E+00_JPRB,0.28661E+00_JPRB,0.22093E+00_JPRB /)  
KB(:, 4,18,10) = (/ &
 & 0.14352E+00_JPRB,0.25285E+00_JPRB,0.29256E+00_JPRB,0.29859E+00_JPRB,0.23121E+00_JPRB /)  
KB(:, 5,18,10) = (/ &
 & 0.14999E+00_JPRB,0.26447E+00_JPRB,0.30340E+00_JPRB,0.31163E+00_JPRB,0.24203E+00_JPRB /)  
KB(:, 1,19,10) = (/ &
 & 0.10785E+00_JPRB,0.20667E+00_JPRB,0.23879E+00_JPRB,0.24194E+00_JPRB,0.18368E+00_JPRB /)  
KB(:, 2,19,10) = (/ &
 & 0.11429E+00_JPRB,0.21546E+00_JPRB,0.24926E+00_JPRB,0.25235E+00_JPRB,0.19325E+00_JPRB /)  
KB(:, 3,19,10) = (/ &
 & 0.12064E+00_JPRB,0.22577E+00_JPRB,0.26022E+00_JPRB,0.26472E+00_JPRB,0.20338E+00_JPRB /)  
KB(:, 4,19,10) = (/ &
 & 0.12700E+00_JPRB,0.23751E+00_JPRB,0.27175E+00_JPRB,0.27823E+00_JPRB,0.21416E+00_JPRB /)  
KB(:, 5,19,10) = (/ &
 & 0.13335E+00_JPRB,0.24924E+00_JPRB,0.28423E+00_JPRB,0.29239E+00_JPRB,0.22548E+00_JPRB /)  
KB(:, 1,20,10) = (/ &
 & 0.94314E-01_JPRB,0.18969E+00_JPRB,0.21843E+00_JPRB,0.22089E+00_JPRB,0.16767E+00_JPRB /)  
KB(:, 2,20,10) = (/ &
 & 0.10011E+00_JPRB,0.20009E+00_JPRB,0.22938E+00_JPRB,0.23290E+00_JPRB,0.17759E+00_JPRB /)  
KB(:, 3,20,10) = (/ &
 & 0.10602E+00_JPRB,0.21171E+00_JPRB,0.24114E+00_JPRB,0.24650E+00_JPRB,0.18815E+00_JPRB /)  
KB(:, 4,20,10) = (/ &
 & 0.11212E+00_JPRB,0.22366E+00_JPRB,0.25410E+00_JPRB,0.26076E+00_JPRB,0.19951E+00_JPRB /)  
KB(:, 5,20,10) = (/ &
 & 0.11820E+00_JPRB,0.23566E+00_JPRB,0.26816E+00_JPRB,0.27572E+00_JPRB,0.21140E+00_JPRB /)  
KB(:, 1,21,10) = (/ &
 & 0.82096E-01_JPRB,0.17498E+00_JPRB,0.20057E+00_JPRB,0.20349E+00_JPRB,0.15368E+00_JPRB /)  
KB(:, 2,21,10) = (/ &
 & 0.87376E-01_JPRB,0.18671E+00_JPRB,0.21217E+00_JPRB,0.21678E+00_JPRB,0.16394E+00_JPRB /)  
KB(:, 3,21,10) = (/ &
 & 0.92996E-01_JPRB,0.19901E+00_JPRB,0.22527E+00_JPRB,0.23088E+00_JPRB,0.17505E+00_JPRB /)  
KB(:, 4,21,10) = (/ &
 & 0.98752E-01_JPRB,0.21131E+00_JPRB,0.23942E+00_JPRB,0.24575E+00_JPRB,0.18685E+00_JPRB /)  
KB(:, 5,21,10) = (/ &
 & 0.10451E+00_JPRB,0.22356E+00_JPRB,0.25490E+00_JPRB,0.26152E+00_JPRB,0.19924E+00_JPRB /)  
KB(:, 1,22,10) = (/ &
 & 0.71578E-01_JPRB,0.16309E+00_JPRB,0.18609E+00_JPRB,0.19018E+00_JPRB,0.14217E+00_JPRB /)  
KB(:, 2,22,10) = (/ &
 & 0.76626E-01_JPRB,0.17564E+00_JPRB,0.19884E+00_JPRB,0.20398E+00_JPRB,0.15291E+00_JPRB /)  
KB(:, 3,22,10) = (/ &
 & 0.81885E-01_JPRB,0.18840E+00_JPRB,0.21309E+00_JPRB,0.21858E+00_JPRB,0.16461E+00_JPRB /)  
KB(:, 4,22,10) = (/ &
 & 0.87223E-01_JPRB,0.20113E+00_JPRB,0.22859E+00_JPRB,0.23430E+00_JPRB,0.17688E+00_JPRB /)  
KB(:, 5,22,10) = (/ &
 & 0.92500E-01_JPRB,0.21374E+00_JPRB,0.24532E+00_JPRB,0.25104E+00_JPRB,0.18976E+00_JPRB /)  
KB(:, 1,23,10) = (/ &
 & 0.62506E-01_JPRB,0.15298E+00_JPRB,0.17442E+00_JPRB,0.17913E+00_JPRB,0.13258E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART26',1,ZHOOK_HANDLE)
END SUBROUTINE PART26


SUBROUTINE PART27

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART27',0,ZHOOK_HANDLE)


KB(:, 2,23,10) = (/ &
 & 0.67194E-01_JPRB,0.16597E+00_JPRB,0.18829E+00_JPRB,0.19340E+00_JPRB,0.14391E+00_JPRB /)  
KB(:, 3,23,10) = (/ &
 & 0.72099E-01_JPRB,0.17922E+00_JPRB,0.20360E+00_JPRB,0.20869E+00_JPRB,0.15600E+00_JPRB /)  
KB(:, 4,23,10) = (/ &
 & 0.77023E-01_JPRB,0.19243E+00_JPRB,0.22032E+00_JPRB,0.22532E+00_JPRB,0.16873E+00_JPRB /)  
KB(:, 5,23,10) = (/ &
 & 0.81629E-01_JPRB,0.20537E+00_JPRB,0.23792E+00_JPRB,0.24291E+00_JPRB,0.18203E+00_JPRB /)  
KB(:, 1,24,10) = (/ &
 & 0.54705E-01_JPRB,0.14435E+00_JPRB,0.16539E+00_JPRB,0.17004E+00_JPRB,0.12479E+00_JPRB /)  
KB(:, 2,24,10) = (/ &
 & 0.59055E-01_JPRB,0.15781E+00_JPRB,0.18024E+00_JPRB,0.18505E+00_JPRB,0.13663E+00_JPRB /)  
KB(:, 3,24,10) = (/ &
 & 0.63456E-01_JPRB,0.17157E+00_JPRB,0.19662E+00_JPRB,0.20113E+00_JPRB,0.14915E+00_JPRB /)  
KB(:, 4,24,10) = (/ &
 & 0.67778E-01_JPRB,0.18520E+00_JPRB,0.21409E+00_JPRB,0.21860E+00_JPRB,0.16222E+00_JPRB /)  
KB(:, 5,24,10) = (/ &
 & 0.71741E-01_JPRB,0.19852E+00_JPRB,0.23252E+00_JPRB,0.23726E+00_JPRB,0.17594E+00_JPRB /)  
KB(:, 1,25,10) = (/ &
 & 0.47972E-01_JPRB,0.13725E+00_JPRB,0.15860E+00_JPRB,0.16297E+00_JPRB,0.11866E+00_JPRB /)  
KB(:, 2,25,10) = (/ &
 & 0.51893E-01_JPRB,0.15121E+00_JPRB,0.17443E+00_JPRB,0.17877E+00_JPRB,0.13085E+00_JPRB /)  
KB(:, 3,25,10) = (/ &
 & 0.55832E-01_JPRB,0.16535E+00_JPRB,0.19157E+00_JPRB,0.19578E+00_JPRB,0.14380E+00_JPRB /)  
KB(:, 4,25,10) = (/ &
 & 0.59570E-01_JPRB,0.17943E+00_JPRB,0.20993E+00_JPRB,0.21423E+00_JPRB,0.15728E+00_JPRB /)  
KB(:, 5,25,10) = (/ &
 & 0.62996E-01_JPRB,0.19323E+00_JPRB,0.22909E+00_JPRB,0.23401E+00_JPRB,0.17147E+00_JPRB /)  
KB(:, 1,26,10) = (/ &
 & 0.42166E-01_JPRB,0.13173E+00_JPRB,0.15395E+00_JPRB,0.15801E+00_JPRB,0.11401E+00_JPRB /)  
KB(:, 2,26,10) = (/ &
 & 0.45660E-01_JPRB,0.14616E+00_JPRB,0.17062E+00_JPRB,0.17468E+00_JPRB,0.12664E+00_JPRB /)  
KB(:, 3,26,10) = (/ &
 & 0.49079E-01_JPRB,0.16071E+00_JPRB,0.18859E+00_JPRB,0.19278E+00_JPRB,0.14002E+00_JPRB /)  
KB(:, 4,26,10) = (/ &
 & 0.52306E-01_JPRB,0.17521E+00_JPRB,0.20782E+00_JPRB,0.21223E+00_JPRB,0.15402E+00_JPRB /)  
KB(:, 5,26,10) = (/ &
 & 0.55285E-01_JPRB,0.18955E+00_JPRB,0.22765E+00_JPRB,0.23299E+00_JPRB,0.16864E+00_JPRB /)  
KB(:, 1,27,10) = (/ &
 & 0.37040E-01_JPRB,0.12755E+00_JPRB,0.15088E+00_JPRB,0.15474E+00_JPRB,0.11059E+00_JPRB /)  
KB(:, 2,27,10) = (/ &
 & 0.40121E-01_JPRB,0.14241E+00_JPRB,0.16845E+00_JPRB,0.17243E+00_JPRB,0.12369E+00_JPRB /)  
KB(:, 3,27,10) = (/ &
 & 0.43101E-01_JPRB,0.15742E+00_JPRB,0.18726E+00_JPRB,0.19156E+00_JPRB,0.13753E+00_JPRB /)  
KB(:, 4,27,10) = (/ &
 & 0.45931E-01_JPRB,0.17241E+00_JPRB,0.20722E+00_JPRB,0.21200E+00_JPRB,0.15204E+00_JPRB /)  
KB(:, 5,27,10) = (/ &
 & 0.48598E-01_JPRB,0.18733E+00_JPRB,0.22772E+00_JPRB,0.23361E+00_JPRB,0.16711E+00_JPRB /)  
KB(:, 1,28,10) = (/ &
 & 0.32582E-01_JPRB,0.12457E+00_JPRB,0.14931E+00_JPRB,0.15310E+00_JPRB,0.10829E+00_JPRB /)  
KB(:, 2,28,10) = (/ &
 & 0.35269E-01_JPRB,0.13987E+00_JPRB,0.16776E+00_JPRB,0.17185E+00_JPRB,0.12185E+00_JPRB /)  
KB(:, 3,28,10) = (/ &
 & 0.37905E-01_JPRB,0.15538E+00_JPRB,0.18740E+00_JPRB,0.19192E+00_JPRB,0.13621E+00_JPRB /)  
KB(:, 4,28,10) = (/ &
 & 0.40411E-01_JPRB,0.17101E+00_JPRB,0.20797E+00_JPRB,0.21319E+00_JPRB,0.15122E+00_JPRB /)  
KB(:, 5,28,10) = (/ &
 & 0.42843E-01_JPRB,0.18643E+00_JPRB,0.22906E+00_JPRB,0.23551E+00_JPRB,0.16683E+00_JPRB /)  
KB(:, 1,29,10) = (/ &
 & 0.28694E-01_JPRB,0.12285E+00_JPRB,0.14922E+00_JPRB,0.15309E+00_JPRB,0.10715E+00_JPRB /)  
KB(:, 2,29,10) = (/ &
 & 0.31078E-01_JPRB,0.13867E+00_JPRB,0.16851E+00_JPRB,0.17281E+00_JPRB,0.12115E+00_JPRB /)  
KB(:, 3,29,10) = (/ &
 & 0.33398E-01_JPRB,0.15475E+00_JPRB,0.18886E+00_JPRB,0.19373E+00_JPRB,0.13609E+00_JPRB /)  
KB(:, 4,29,10) = (/ &
 & 0.35655E-01_JPRB,0.17087E+00_JPRB,0.21002E+00_JPRB,0.21569E+00_JPRB,0.15161E+00_JPRB /)  
KB(:, 5,29,10) = (/ &
 & 0.37934E-01_JPRB,0.18672E+00_JPRB,0.23156E+00_JPRB,0.23855E+00_JPRB,0.16767E+00_JPRB /)  
KB(:, 1,30,10) = (/ &
 & 0.25318E-01_JPRB,0.12223E+00_JPRB,0.15038E+00_JPRB,0.15442E+00_JPRB,0.10692E+00_JPRB /)  
KB(:, 2,30,10) = (/ &
 & 0.27416E-01_JPRB,0.13863E+00_JPRB,0.17040E+00_JPRB,0.17493E+00_JPRB,0.12146E+00_JPRB /)  
KB(:, 3,30,10) = (/ &
 & 0.29487E-01_JPRB,0.15524E+00_JPRB,0.19136E+00_JPRB,0.19656E+00_JPRB,0.13693E+00_JPRB /)  
KB(:, 4,30,10) = (/ &
 & 0.31585E-01_JPRB,0.17178E+00_JPRB,0.21298E+00_JPRB,0.21911E+00_JPRB,0.15294E+00_JPRB /)  
KB(:, 5,30,10) = (/ &
 & 0.33743E-01_JPRB,0.18794E+00_JPRB,0.23489E+00_JPRB,0.24234E+00_JPRB,0.16937E+00_JPRB /)  
KB(:, 1,31,10) = (/ &
 & 0.22384E-01_JPRB,0.12276E+00_JPRB,0.15268E+00_JPRB,0.15694E+00_JPRB,0.10764E+00_JPRB /)  
KB(:, 2,31,10) = (/ &
 & 0.24241E-01_JPRB,0.13972E+00_JPRB,0.17333E+00_JPRB,0.17809E+00_JPRB,0.12275E+00_JPRB /)  
KB(:, 3,31,10) = (/ &
 & 0.26155E-01_JPRB,0.15678E+00_JPRB,0.19481E+00_JPRB,0.20028E+00_JPRB,0.13870E+00_JPRB /)  
KB(:, 4,31,10) = (/ &
 & 0.28119E-01_JPRB,0.17362E+00_JPRB,0.21675E+00_JPRB,0.22330E+00_JPRB,0.15510E+00_JPRB /)  
KB(:, 5,31,10) = (/ &
 & 0.30218E-01_JPRB,0.19000E+00_JPRB,0.23891E+00_JPRB,0.24680E+00_JPRB,0.17182E+00_JPRB /)  
KB(:, 1,32,10) = (/ &
 & 0.19818E-01_JPRB,0.12431E+00_JPRB,0.15590E+00_JPRB,0.16037E+00_JPRB,0.10919E+00_JPRB /)  
KB(:, 2,32,10) = (/ &
 & 0.21499E-01_JPRB,0.14174E+00_JPRB,0.17710E+00_JPRB,0.18207E+00_JPRB,0.12484E+00_JPRB /)  
KB(:, 3,32,10) = (/ &
 & 0.23289E-01_JPRB,0.15910E+00_JPRB,0.19892E+00_JPRB,0.20468E+00_JPRB,0.14116E+00_JPRB /)  
KB(:, 4,32,10) = (/ &
 & 0.25197E-01_JPRB,0.17612E+00_JPRB,0.22110E+00_JPRB,0.22808E+00_JPRB,0.15787E+00_JPRB /)  
KB(:, 5,32,10) = (/ &
 & 0.27257E-01_JPRB,0.19267E+00_JPRB,0.24341E+00_JPRB,0.25172E+00_JPRB,0.17483E+00_JPRB /)  
KB(:, 1,33,10) = (/ &
 & 0.17588E-01_JPRB,0.12670E+00_JPRB,0.15984E+00_JPRB,0.16448E+00_JPRB,0.11147E+00_JPRB /)  
KB(:, 2,33,10) = (/ &
 & 0.19157E-01_JPRB,0.14450E+00_JPRB,0.18143E+00_JPRB,0.18665E+00_JPRB,0.12758E+00_JPRB /)  
KB(:, 3,33,10) = (/ &
 & 0.20859E-01_JPRB,0.16204E+00_JPRB,0.20353E+00_JPRB,0.20957E+00_JPRB,0.14421E+00_JPRB /)  
KB(:, 4,33,10) = (/ &
 & 0.22735E-01_JPRB,0.17915E+00_JPRB,0.22585E+00_JPRB,0.23324E+00_JPRB,0.16113E+00_JPRB /)  
KB(:, 5,33,10) = (/ &
 & 0.24799E-01_JPRB,0.19574E+00_JPRB,0.24826E+00_JPRB,0.25697E+00_JPRB,0.17829E+00_JPRB /)  
KB(:, 1,34,10) = (/ &
 & 0.15617E-01_JPRB,0.12913E+00_JPRB,0.16354E+00_JPRB,0.16830E+00_JPRB,0.11378E+00_JPRB /)  
KB(:, 2,34,10) = (/ &
 & 0.17096E-01_JPRB,0.14716E+00_JPRB,0.18538E+00_JPRB,0.19084E+00_JPRB,0.13021E+00_JPRB /)  
KB(:, 3,34,10) = (/ &
 & 0.18753E-01_JPRB,0.16482E+00_JPRB,0.20769E+00_JPRB,0.21402E+00_JPRB,0.14705E+00_JPRB /)  
KB(:, 4,34,10) = (/ &
 & 0.20625E-01_JPRB,0.18194E+00_JPRB,0.23012E+00_JPRB,0.23784E+00_JPRB,0.16411E+00_JPRB /)  
KB(:, 5,34,10) = (/ &
 & 0.22709E-01_JPRB,0.19848E+00_JPRB,0.25256E+00_JPRB,0.26160E+00_JPRB,0.18143E+00_JPRB /)  
KB(:, 1,35,10) = (/ &
 & 0.13789E-01_JPRB,0.13026E+00_JPRB,0.16543E+00_JPRB,0.17032E+00_JPRB,0.11490E+00_JPRB /)  
KB(:, 2,35,10) = (/ &
 & 0.15216E-01_JPRB,0.14846E+00_JPRB,0.18743E+00_JPRB,0.19307E+00_JPRB,0.13153E+00_JPRB /)  
KB(:, 3,35,10) = (/ &
 & 0.16842E-01_JPRB,0.16621E+00_JPRB,0.20987E+00_JPRB,0.21641E+00_JPRB,0.14851E+00_JPRB /)  
KB(:, 4,35,10) = (/ &
 & 0.18686E-01_JPRB,0.18333E+00_JPRB,0.23239E+00_JPRB,0.24032E+00_JPRB,0.16565E+00_JPRB /)  
KB(:, 5,35,10) = (/ &
 & 0.20799E-01_JPRB,0.19983E+00_JPRB,0.25487E+00_JPRB,0.26409E+00_JPRB,0.18307E+00_JPRB /)  
KB(:, 1,36,10) = (/ &
 & 0.12099E-01_JPRB,0.12969E+00_JPRB,0.16517E+00_JPRB,0.17011E+00_JPRB,0.11448E+00_JPRB /)  
KB(:, 2,36,10) = (/ &
 & 0.13456E-01_JPRB,0.14803E+00_JPRB,0.18723E+00_JPRB,0.19293E+00_JPRB,0.13120E+00_JPRB /)  
KB(:, 3,36,10) = (/ &
 & 0.15032E-01_JPRB,0.16587E+00_JPRB,0.20973E+00_JPRB,0.21635E+00_JPRB,0.14826E+00_JPRB /)  
KB(:, 4,36,10) = (/ &
 & 0.16854E-01_JPRB,0.18305E+00_JPRB,0.23232E+00_JPRB,0.24032E+00_JPRB,0.16546E+00_JPRB /)  
KB(:, 5,36,10) = (/ &
 & 0.18993E-01_JPRB,0.19959E+00_JPRB,0.25485E+00_JPRB,0.26414E+00_JPRB,0.18292E+00_JPRB /)  
KB(:, 1,37,10) = (/ &
 & 0.10461E-01_JPRB,0.12652E+00_JPRB,0.16173E+00_JPRB,0.16663E+00_JPRB,0.11173E+00_JPRB /)  
KB(:, 2,37,10) = (/ &
 & 0.11729E-01_JPRB,0.14498E+00_JPRB,0.18379E+00_JPRB,0.18940E+00_JPRB,0.12844E+00_JPRB /)  
KB(:, 3,37,10) = (/ &
 & 0.13230E-01_JPRB,0.16298E+00_JPRB,0.20628E+00_JPRB,0.21278E+00_JPRB,0.14553E+00_JPRB /)  
KB(:, 4,37,10) = (/ &
 & 0.15005E-01_JPRB,0.18033E+00_JPRB,0.22891E+00_JPRB,0.23679E+00_JPRB,0.16275E+00_JPRB /)  
KB(:, 5,37,10) = (/ &
 & 0.17126E-01_JPRB,0.19699E+00_JPRB,0.25151E+00_JPRB,0.26065E+00_JPRB,0.18019E+00_JPRB /)  
KB(:, 1,38,10) = (/ &
 & 0.90496E-02_JPRB,0.12333E+00_JPRB,0.15823E+00_JPRB,0.16307E+00_JPRB,0.10897E+00_JPRB /)  
KB(:, 2,38,10) = (/ &
 & 0.10227E-01_JPRB,0.14188E+00_JPRB,0.18026E+00_JPRB,0.18578E+00_JPRB,0.12565E+00_JPRB /)  
KB(:, 3,38,10) = (/ &
 & 0.11665E-01_JPRB,0.16002E+00_JPRB,0.20273E+00_JPRB,0.20911E+00_JPRB,0.14274E+00_JPRB /)  
KB(:, 4,38,10) = (/ &
 & 0.13392E-01_JPRB,0.17754E+00_JPRB,0.22537E+00_JPRB,0.23309E+00_JPRB,0.15996E+00_JPRB /)  
KB(:, 5,38,10) = (/ &
 & 0.15506E-01_JPRB,0.19433E+00_JPRB,0.24804E+00_JPRB,0.25702E+00_JPRB,0.17741E+00_JPRB /)  
KB(:, 1,39,10) = (/ &
 & 0.78338E-02_JPRB,0.12027E+00_JPRB,0.15482E+00_JPRB,0.15961E+00_JPRB,0.10632E+00_JPRB /)  
KB(:, 2,39,10) = (/ &
 & 0.89378E-02_JPRB,0.13888E+00_JPRB,0.17682E+00_JPRB,0.18224E+00_JPRB,0.12295E+00_JPRB /)  
KB(:, 3,39,10) = (/ &
 & 0.10310E-01_JPRB,0.15714E+00_JPRB,0.19926E+00_JPRB,0.20553E+00_JPRB,0.14003E+00_JPRB /)  
KB(:, 4,39,10) = (/ &
 & 0.12002E-01_JPRB,0.17480E+00_JPRB,0.22192E+00_JPRB,0.22947E+00_JPRB,0.15725E+00_JPRB /)  
KB(:, 5,39,10) = (/ &
 & 0.14105E-01_JPRB,0.19172E+00_JPRB,0.24464E+00_JPRB,0.25344E+00_JPRB,0.17470E+00_JPRB /)  
KB(:, 1,40,10) = (/ &
 & 0.66914E-02_JPRB,0.11542E+00_JPRB,0.14925E+00_JPRB,0.15395E+00_JPRB,0.10210E+00_JPRB /)  
KB(:, 2,40,10) = (/ &
 & 0.77047E-02_JPRB,0.13403E+00_JPRB,0.17118E+00_JPRB,0.17643E+00_JPRB,0.11860E+00_JPRB /)  
KB(:, 3,40,10) = (/ &
 & 0.89835E-02_JPRB,0.15246E+00_JPRB,0.19353E+00_JPRB,0.19961E+00_JPRB,0.13564E+00_JPRB /)  
KB(:, 4,40,10) = (/ &
 & 0.10606E-01_JPRB,0.17030E+00_JPRB,0.21619E+00_JPRB,0.22340E+00_JPRB,0.15283E+00_JPRB /)  
KB(:, 5,40,10) = (/ &
 & 0.12648E-01_JPRB,0.18743E+00_JPRB,0.23893E+00_JPRB,0.24746E+00_JPRB,0.17023E+00_JPRB /)  
KB(:, 1,41,10) = (/ &
 & 0.57043E-02_JPRB,0.11041E+00_JPRB,0.14350E+00_JPRB,0.14812E+00_JPRB,0.97770E-01_JPRB /)  
KB(:, 2,41,10) = (/ &
 & 0.66329E-02_JPRB,0.12897E+00_JPRB,0.16532E+00_JPRB,0.17041E+00_JPRB,0.11409E+00_JPRB /)  
KB(:, 3,41,10) = (/ &
 & 0.78105E-02_JPRB,0.14755E+00_JPRB,0.18757E+00_JPRB,0.19344E+00_JPRB,0.13104E+00_JPRB /)  
KB(:, 4,41,10) = (/ &
 & 0.93536E-02_JPRB,0.16558E+00_JPRB,0.21020E+00_JPRB,0.21707E+00_JPRB,0.14824E+00_JPRB /)  
KB(:, 5,41,10) = (/ &
 & 0.11328E-01_JPRB,0.18290E+00_JPRB,0.23295E+00_JPRB,0.24119E+00_JPRB,0.16557E+00_JPRB /)  
KB(:, 1,42,10) = (/ &
 & 0.48607E-02_JPRB,0.10547E+00_JPRB,0.13783E+00_JPRB,0.14238E+00_JPRB,0.93542E-01_JPRB /)  
KB(:, 2,42,10) = (/ &
 & 0.56953E-02_JPRB,0.12396E+00_JPRB,0.15948E+00_JPRB,0.16442E+00_JPRB,0.10965E+00_JPRB /)  
KB(:, 3,42,10) = (/ &
 & 0.67857E-02_JPRB,0.14262E+00_JPRB,0.18165E+00_JPRB,0.18732E+00_JPRB,0.12648E+00_JPRB /)  
KB(:, 4,42,10) = (/ &
 & 0.82516E-02_JPRB,0.16083E+00_JPRB,0.20424E+00_JPRB,0.21080E+00_JPRB,0.14367E+00_JPRB /)  
KB(:, 5,42,10) = (/ &
 & 0.10149E-01_JPRB,0.17836E+00_JPRB,0.22696E+00_JPRB,0.23490E+00_JPRB,0.16095E+00_JPRB /)  
KB(:, 1,43,10) = (/ &
 & 0.40934E-02_JPRB,0.99600E-01_JPRB,0.13106E+00_JPRB,0.13554E+00_JPRB,0.88531E-01_JPRB /)  
KB(:, 2,43,10) = (/ &
 & 0.48473E-02_JPRB,0.11796E+00_JPRB,0.15249E+00_JPRB,0.15728E+00_JPRB,0.10438E+00_JPRB /)  
KB(:, 3,43,10) = (/ &
 & 0.58407E-02_JPRB,0.13665E+00_JPRB,0.17453E+00_JPRB,0.17995E+00_JPRB,0.12102E+00_JPRB /)  
KB(:, 4,43,10) = (/ &
 & 0.71922E-02_JPRB,0.15505E+00_JPRB,0.19702E+00_JPRB,0.20328E+00_JPRB,0.13817E+00_JPRB /)  
KB(:, 5,43,10) = (/ &
 & 0.89819E-02_JPRB,0.17282E+00_JPRB,0.21974E+00_JPRB,0.22722E+00_JPRB,0.15541E+00_JPRB /)  
KB(:, 1,44,10) = (/ &
 & 0.34279E-02_JPRB,0.93376E-01_JPRB,0.12386E+00_JPRB,0.12828E+00_JPRB,0.83256E-01_JPRB /)  
KB(:, 2,44,10) = (/ &
 & 0.40981E-02_JPRB,0.11153E+00_JPRB,0.14501E+00_JPRB,0.14969E+00_JPRB,0.98786E-01_JPRB /)  
KB(:, 3,44,10) = (/ &
 & 0.49801E-02_JPRB,0.13017E+00_JPRB,0.16691E+00_JPRB,0.17209E+00_JPRB,0.11523E+00_JPRB /)  
KB(:, 4,44,10) = (/ &
 & 0.62140E-02_JPRB,0.14877E+00_JPRB,0.18924E+00_JPRB,0.19525E+00_JPRB,0.13223E+00_JPRB /)  
KB(:, 5,44,10) = (/ &
 & 0.78865E-02_JPRB,0.16678E+00_JPRB,0.21196E+00_JPRB,0.21896E+00_JPRB,0.14947E+00_JPRB /)  
KB(:, 1,45,10) = (/ &
 & 0.28724E-02_JPRB,0.87295E-01_JPRB,0.11671E+00_JPRB,0.12114E+00_JPRB,0.78089E-01_JPRB /)  
KB(:, 2,45,10) = (/ &
 & 0.34468E-02_JPRB,0.10517E+00_JPRB,0.13765E+00_JPRB,0.14225E+00_JPRB,0.93322E-01_JPRB /)  
KB(:, 3,45,10) = (/ &
 & 0.42450E-02_JPRB,0.12371E+00_JPRB,0.15937E+00_JPRB,0.16431E+00_JPRB,0.10950E+00_JPRB /)  
KB(:, 4,45,10) = (/ &
 & 0.53608E-02_JPRB,0.14242E+00_JPRB,0.18156E+00_JPRB,0.18727E+00_JPRB,0.12633E+00_JPRB /)  
KB(:, 5,45,10) = (/ &
 & 0.69069E-02_JPRB,0.16067E+00_JPRB,0.20420E+00_JPRB,0.21079E+00_JPRB,0.14356E+00_JPRB /)  
KB(:, 1,46,10) = (/ &
 & 0.23836E-02_JPRB,0.81023E-01_JPRB,0.10917E+00_JPRB,0.11375E+00_JPRB,0.72722E-01_JPRB /)  
KB(:, 2,46,10) = (/ &
 & 0.28929E-02_JPRB,0.98528E-01_JPRB,0.12997E+00_JPRB,0.13446E+00_JPRB,0.87653E-01_JPRB /)  
KB(:, 3,46,10) = (/ &
 & 0.35850E-02_JPRB,0.11690E+00_JPRB,0.15139E+00_JPRB,0.15617E+00_JPRB,0.10350E+00_JPRB /)  
KB(:, 4,46,10) = (/ &
 & 0.45850E-02_JPRB,0.13564E+00_JPRB,0.17345E+00_JPRB,0.17887E+00_JPRB,0.12014E+00_JPRB /)  
KB(:, 5,46,10) = (/ &
 & 0.59899E-02_JPRB,0.15409E+00_JPRB,0.19595E+00_JPRB,0.20220E+00_JPRB,0.13729E+00_JPRB /)  
KB(:, 1,47,10) = (/ &
 & 0.19470E-02_JPRB,0.74238E-01_JPRB,0.10082E+00_JPRB,0.10569E+00_JPRB,0.66936E-01_JPRB /)  
KB(:, 2,47,10) = (/ &
 & 0.23890E-02_JPRB,0.91244E-01_JPRB,0.12148E+00_JPRB,0.12591E+00_JPRB,0.81479E-01_JPRB /)  
KB(:, 3,47,10) = (/ &
 & 0.29827E-02_JPRB,0.10934E+00_JPRB,0.14258E+00_JPRB,0.14724E+00_JPRB,0.96940E-01_JPRB /)  
KB(:, 4,47,10) = (/ &
 & 0.38583E-02_JPRB,0.12800E+00_JPRB,0.16447E+00_JPRB,0.16958E+00_JPRB,0.11333E+00_JPRB /)  
KB(:, 5,47,10) = (/ &
 & 0.51142E-02_JPRB,0.14666E+00_JPRB,0.18678E+00_JPRB,0.19270E+00_JPRB,0.13028E+00_JPRB /)  
KB(:, 1,48,10) = (/ &
 & 0.15861E-02_JPRB,0.67739E-01_JPRB,0.92637E-01_JPRB,0.97854E-01_JPRB,0.61349E-01_JPRB /)  
KB(:, 2,48,10) = (/ &
 & 0.19649E-02_JPRB,0.84157E-01_JPRB,0.11305E+00_JPRB,0.11755E+00_JPRB,0.75432E-01_JPRB /)  
KB(:, 3,48,10) = (/ &
 & 0.24852E-02_JPRB,0.10189E+00_JPRB,0.13395E+00_JPRB,0.13849E+00_JPRB,0.90556E-01_JPRB /)  
KB(:, 4,48,10) = (/ &
 & 0.32371E-02_JPRB,0.12039E+00_JPRB,0.15554E+00_JPRB,0.16041E+00_JPRB,0.10658E+00_JPRB /)  
KB(:, 5,48,10) = (/ &
 & 0.43439E-02_JPRB,0.13914E+00_JPRB,0.17770E+00_JPRB,0.18327E+00_JPRB,0.12334E+00_JPRB /)  
KB(:, 1,49,10) = (/ &
 & 0.12857E-02_JPRB,0.61441E-01_JPRB,0.84638E-01_JPRB,0.90184E-01_JPRB,0.55928E-01_JPRB /)  
KB(:, 2,49,10) = (/ &
 & 0.16127E-02_JPRB,0.77337E-01_JPRB,0.10472E+00_JPRB,0.10945E+00_JPRB,0.69577E-01_JPRB /)  
KB(:, 3,49,10) = (/ &
 & 0.20537E-02_JPRB,0.94575E-01_JPRB,0.12545E+00_JPRB,0.12989E+00_JPRB,0.84331E-01_JPRB /)  
KB(:, 4,49,10) = (/ &
 & 0.26910E-02_JPRB,0.11284E+00_JPRB,0.14670E+00_JPRB,0.15143E+00_JPRB,0.99981E-01_JPRB /)  
KB(:, 5,49,10) = (/ &
 & 0.36640E-02_JPRB,0.13156E+00_JPRB,0.16870E+00_JPRB,0.17395E+00_JPRB,0.11651E+00_JPRB /)  
KB(:, 1,50,10) = (/ &
 & 0.10457E-02_JPRB,0.55773E-01_JPRB,0.77388E-01_JPRB,0.83215E-01_JPRB,0.51035E-01_JPRB /)  
KB(:, 2,50,10) = (/ &
 & 0.13145E-02_JPRB,0.71139E-01_JPRB,0.96987E-01_JPRB,0.10202E+00_JPRB,0.64279E-01_JPRB /)  
KB(:, 3,50,10) = (/ &
 & 0.17051E-02_JPRB,0.87902E-01_JPRB,0.11756E+00_JPRB,0.12199E+00_JPRB,0.78626E-01_JPRB /)  
KB(:, 4,50,10) = (/ &
 & 0.22648E-02_JPRB,0.10582E+00_JPRB,0.13854E+00_JPRB,0.14317E+00_JPRB,0.93933E-01_JPRB /)  
KB(:, 5,50,10) = (/ &
 & 0.31061E-02_JPRB,0.12442E+00_JPRB,0.16033E+00_JPRB,0.16532E+00_JPRB,0.11017E+00_JPRB /)  
KB(:, 1,51,10) = (/ &
 & 0.84549E-03_JPRB,0.50472E-01_JPRB,0.70528E-01_JPRB,0.76615E-01_JPRB,0.46420E-01_JPRB /)  
KB(:, 2,51,10) = (/ &
 & 0.10690E-02_JPRB,0.65329E-01_JPRB,0.89631E-01_JPRB,0.94967E-01_JPRB,0.59271E-01_JPRB /)  
KB(:, 3,51,10) = (/ &
 & 0.14006E-02_JPRB,0.81572E-01_JPRB,0.10994E+00_JPRB,0.11450E+00_JPRB,0.73207E-01_JPRB /)  
KB(:, 4,51,10) = (/ &
 & 0.18893E-02_JPRB,0.99123E-01_JPRB,0.13077E+00_JPRB,0.13529E+00_JPRB,0.88203E-01_JPRB /)  
KB(:, 5,51,10) = (/ &
 & 0.26211E-02_JPRB,0.11756E+00_JPRB,0.15226E+00_JPRB,0.15707E+00_JPRB,0.10410E+00_JPRB /)  
KB(:, 1,52,10) = (/ &
 & 0.67948E-03_JPRB,0.45452E-01_JPRB,0.63925E-01_JPRB,0.70191E-01_JPRB,0.41984E-01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART27',1,ZHOOK_HANDLE)
END SUBROUTINE PART27


SUBROUTINE PART28

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART28',0,ZHOOK_HANDLE)


KB(:, 2,52,10) = (/ &
 & 0.86532E-03_JPRB,0.59697E-01_JPRB,0.82454E-01_JPRB,0.88085E-01_JPRB,0.54427E-01_JPRB /)  
KB(:, 3,52,10) = (/ &
 & 0.11431E-02_JPRB,0.75434E-01_JPRB,0.10239E+00_JPRB,0.10721E+00_JPRB,0.67964E-01_JPRB /)  
KB(:, 4,52,10) = (/ &
 & 0.15771E-02_JPRB,0.92585E-01_JPRB,0.12313E+00_JPRB,0.12757E+00_JPRB,0.82618E-01_JPRB /)  
KB(:, 5,52,10) = (/ &
 & 0.22169E-02_JPRB,0.11074E+00_JPRB,0.14429E+00_JPRB,0.14899E+00_JPRB,0.98166E-01_JPRB /)  
KB(:, 1,53,10) = (/ &
 & 0.54404E-03_JPRB,0.40689E-01_JPRB,0.57565E-01_JPRB,0.63870E-01_JPRB,0.37709E-01_JPRB /)  
KB(:, 2,53,10) = (/ &
 & 0.69516E-03_JPRB,0.54249E-01_JPRB,0.75469E-01_JPRB,0.81366E-01_JPRB,0.49728E-01_JPRB /)  
KB(:, 3,53,10) = (/ &
 & 0.92495E-03_JPRB,0.69505E-01_JPRB,0.94951E-01_JPRB,0.10007E+00_JPRB,0.62880E-01_JPRB /)  
KB(:, 4,53,10) = (/ &
 & 0.12935E-02_JPRB,0.86139E-01_JPRB,0.11548E+00_JPRB,0.11993E+00_JPRB,0.77126E-01_JPRB /)  
KB(:, 5,53,10) = (/ &
 & 0.18603E-02_JPRB,0.10397E+00_JPRB,0.13641E+00_JPRB,0.14102E+00_JPRB,0.92352E-01_JPRB /)  
KB(:, 1,54,10) = (/ &
 & 0.43618E-03_JPRB,0.36557E-01_JPRB,0.51984E-01_JPRB,0.58236E-01_JPRB,0.33960E-01_JPRB /)  
KB(:, 2,54,10) = (/ &
 & 0.56166E-03_JPRB,0.49456E-01_JPRB,0.69241E-01_JPRB,0.75371E-01_JPRB,0.45540E-01_JPRB /)  
KB(:, 3,54,10) = (/ &
 & 0.75035E-03_JPRB,0.64217E-01_JPRB,0.88252E-01_JPRB,0.93648E-01_JPRB,0.58325E-01_JPRB /)  
KB(:, 4,54,10) = (/ &
 & 0.10628E-02_JPRB,0.80385E-01_JPRB,0.10853E+00_JPRB,0.11313E+00_JPRB,0.72201E-01_JPRB /)  
KB(:, 5,54,10) = (/ &
 & 0.15600E-02_JPRB,0.97867E-01_JPRB,0.12933E+00_JPRB,0.13384E+00_JPRB,0.87138E-01_JPRB /)  
KB(:, 1,55,10) = (/ &
 & 0.34930E-03_JPRB,0.32793E-01_JPRB,0.46881E-01_JPRB,0.52981E-01_JPRB,0.30517E-01_JPRB /)  
KB(:, 2,55,10) = (/ &
 & 0.45330E-03_JPRB,0.45087E-01_JPRB,0.63469E-01_JPRB,0.69744E-01_JPRB,0.41669E-01_JPRB /)  
KB(:, 3,55,10) = (/ &
 & 0.61016E-03_JPRB,0.59300E-01_JPRB,0.81969E-01_JPRB,0.87622E-01_JPRB,0.54097E-01_JPRB /)  
KB(:, 4,55,10) = (/ &
 & 0.87186E-03_JPRB,0.75017E-01_JPRB,0.10190E+00_JPRB,0.10674E+00_JPRB,0.67613E-01_JPRB /)  
KB(:, 5,55,10) = (/ &
 & 0.13255E-02_JPRB,0.92144E-01_JPRB,0.12263E+00_JPRB,0.12707E+00_JPRB,0.82251E-01_JPRB /)  
KB(:, 1,56,10) = (/ &
 & 0.27869E-03_JPRB,0.29255E-01_JPRB,0.42021E-01_JPRB,0.47895E-01_JPRB,0.27250E-01_JPRB /)  
KB(:, 2,56,10) = (/ &
 & 0.36450E-03_JPRB,0.40920E-01_JPRB,0.57903E-01_JPRB,0.64209E-01_JPRB,0.37931E-01_JPRB /)  
KB(:, 3,56,10) = (/ &
 & 0.49136E-03_JPRB,0.54534E-01_JPRB,0.75862E-01_JPRB,0.81747E-01_JPRB,0.49990E-01_JPRB /)  
KB(:, 4,56,10) = (/ &
 & 0.71172E-03_JPRB,0.69828E-01_JPRB,0.95390E-01_JPRB,0.10049E+00_JPRB,0.63168E-01_JPRB /)  
KB(:, 5,56,10) = (/ &
 & 0.11017E-02_JPRB,0.86502E-01_JPRB,0.11594E+00_JPRB,0.12039E+00_JPRB,0.77442E-01_JPRB /)  
KB(:, 1,57,10) = (/ &
 & 0.22107E-03_JPRB,0.25925E-01_JPRB,0.37436E-01_JPRB,0.42992E-01_JPRB,0.24134E-01_JPRB /)  
KB(:, 2,57,10) = (/ &
 & 0.29170E-03_JPRB,0.36963E-01_JPRB,0.52553E-01_JPRB,0.58819E-01_JPRB,0.34341E-01_JPRB /)  
KB(:, 3,57,10) = (/ &
 & 0.39477E-03_JPRB,0.49943E-01_JPRB,0.69900E-01_JPRB,0.76011E-01_JPRB,0.45979E-01_JPRB /)  
KB(:, 4,57,10) = (/ &
 & 0.57598E-03_JPRB,0.64771E-01_JPRB,0.88986E-01_JPRB,0.94351E-01_JPRB,0.58814E-01_JPRB /)  
KB(:, 5,57,10) = (/ &
 & 0.90995E-03_JPRB,0.80998E-01_JPRB,0.10929E+00_JPRB,0.11387E+00_JPRB,0.72731E-01_JPRB /)  
KB(:, 1,58,10) = (/ &
 & 0.17561E-03_JPRB,0.22952E-01_JPRB,0.33334E-01_JPRB,0.38531E-01_JPRB,0.21328E-01_JPRB /)  
KB(:, 2,58,10) = (/ &
 & 0.23328E-03_JPRB,0.33378E-01_JPRB,0.47700E-01_JPRB,0.53835E-01_JPRB,0.31067E-01_JPRB /)  
KB(:, 3,58,10) = (/ &
 & 0.31697E-03_JPRB,0.45784E-01_JPRB,0.64416E-01_JPRB,0.70683E-01_JPRB,0.42303E-01_JPRB /)  
KB(:, 4,58,10) = (/ &
 & 0.46537E-03_JPRB,0.60108E-01_JPRB,0.83029E-01_JPRB,0.88636E-01_JPRB,0.54797E-01_JPRB /)  
KB(:, 5,58,10) = (/ &
 & 0.74786E-03_JPRB,0.75908E-01_JPRB,0.10302E+00_JPRB,0.10782E+00_JPRB,0.68377E-01_JPRB /)  
KB(:, 1,59,10) = (/ &
 & 0.14648E-03_JPRB,0.21806E-01_JPRB,0.31752E-01_JPRB,0.36796E-01_JPRB,0.20240E-01_JPRB /)  
KB(:, 2,59,10) = (/ &
 & 0.19618E-03_JPRB,0.31995E-01_JPRB,0.45805E-01_JPRB,0.51875E-01_JPRB,0.29797E-01_JPRB /)  
KB(:, 3,59,10) = (/ &
 & 0.27063E-03_JPRB,0.44166E-01_JPRB,0.62268E-01_JPRB,0.68564E-01_JPRB,0.40859E-01_JPRB /)  
KB(:, 4,59,10) = (/ &
 & 0.40629E-03_JPRB,0.58271E-01_JPRB,0.80681E-01_JPRB,0.86380E-01_JPRB,0.53223E-01_JPRB /)  
KB(:, 5,59,10) = (/ &
 & 0.67143E-03_JPRB,0.73904E-01_JPRB,0.10053E+00_JPRB,0.10542E+00_JPRB,0.66665E-01_JPRB /)  
KB(:, 1,13,11) = (/ &
 & 0.43607E+00_JPRB,0.62808E+00_JPRB,0.71724E+00_JPRB,0.73315E+00_JPRB,0.60101E+00_JPRB /)  
KB(:, 2,13,11) = (/ &
 & 0.43332E+00_JPRB,0.62604E+00_JPRB,0.71980E+00_JPRB,0.74002E+00_JPRB,0.61186E+00_JPRB /)  
KB(:, 3,13,11) = (/ &
 & 0.43924E+00_JPRB,0.62431E+00_JPRB,0.72116E+00_JPRB,0.74635E+00_JPRB,0.62343E+00_JPRB /)  
KB(:, 4,13,11) = (/ &
 & 0.44984E+00_JPRB,0.62482E+00_JPRB,0.72168E+00_JPRB,0.75298E+00_JPRB,0.63261E+00_JPRB /)  
KB(:, 5,13,11) = (/ &
 & 0.46047E+00_JPRB,0.63112E+00_JPRB,0.72222E+00_JPRB,0.75987E+00_JPRB,0.64021E+00_JPRB /)  
KB(:, 1,14,11) = (/ &
 & 0.38105E+00_JPRB,0.57533E+00_JPRB,0.67001E+00_JPRB,0.68808E+00_JPRB,0.55899E+00_JPRB /)  
KB(:, 2,14,11) = (/ &
 & 0.38509E+00_JPRB,0.57518E+00_JPRB,0.67285E+00_JPRB,0.69660E+00_JPRB,0.57227E+00_JPRB /)  
KB(:, 3,14,11) = (/ &
 & 0.39449E+00_JPRB,0.57649E+00_JPRB,0.67532E+00_JPRB,0.70510E+00_JPRB,0.58361E+00_JPRB /)  
KB(:, 4,14,11) = (/ &
 & 0.40382E+00_JPRB,0.58297E+00_JPRB,0.67784E+00_JPRB,0.71417E+00_JPRB,0.59305E+00_JPRB /)  
KB(:, 5,14,11) = (/ &
 & 0.41367E+00_JPRB,0.59430E+00_JPRB,0.68136E+00_JPRB,0.72200E+00_JPRB,0.60202E+00_JPRB /)  
KB(:, 1,15,11) = (/ &
 & 0.33634E+00_JPRB,0.52577E+00_JPRB,0.62172E+00_JPRB,0.64383E+00_JPRB,0.51752E+00_JPRB /)  
KB(:, 2,15,11) = (/ &
 & 0.34434E+00_JPRB,0.52795E+00_JPRB,0.62601E+00_JPRB,0.65389E+00_JPRB,0.53138E+00_JPRB /)  
KB(:, 3,15,11) = (/ &
 & 0.35278E+00_JPRB,0.53440E+00_JPRB,0.63064E+00_JPRB,0.66483E+00_JPRB,0.54288E+00_JPRB /)  
KB(:, 4,15,11) = (/ &
 & 0.36194E+00_JPRB,0.54564E+00_JPRB,0.63643E+00_JPRB,0.67473E+00_JPRB,0.55371E+00_JPRB /)  
KB(:, 5,15,11) = (/ &
 & 0.37392E+00_JPRB,0.55836E+00_JPRB,0.64562E+00_JPRB,0.68317E+00_JPRB,0.56497E+00_JPRB /)  
KB(:, 1,16,11) = (/ &
 & 0.29938E+00_JPRB,0.48063E+00_JPRB,0.57442E+00_JPRB,0.60090E+00_JPRB,0.47563E+00_JPRB /)  
KB(:, 2,16,11) = (/ &
 & 0.30677E+00_JPRB,0.48684E+00_JPRB,0.58100E+00_JPRB,0.61362E+00_JPRB,0.49008E+00_JPRB /)  
KB(:, 3,16,11) = (/ &
 & 0.31495E+00_JPRB,0.49797E+00_JPRB,0.58852E+00_JPRB,0.62578E+00_JPRB,0.50309E+00_JPRB /)  
KB(:, 4,16,11) = (/ &
 & 0.32635E+00_JPRB,0.51101E+00_JPRB,0.59933E+00_JPRB,0.63613E+00_JPRB,0.51641E+00_JPRB /)  
KB(:, 5,16,11) = (/ &
 & 0.34098E+00_JPRB,0.52383E+00_JPRB,0.61318E+00_JPRB,0.64534E+00_JPRB,0.52976E+00_JPRB /)  
KB(:, 1,17,11) = (/ &
 & 0.26573E+00_JPRB,0.44123E+00_JPRB,0.53003E+00_JPRB,0.56054E+00_JPRB,0.43533E+00_JPRB /)  
KB(:, 2,17,11) = (/ &
 & 0.27295E+00_JPRB,0.45155E+00_JPRB,0.53872E+00_JPRB,0.57479E+00_JPRB,0.45023E+00_JPRB /)  
KB(:, 3,17,11) = (/ &
 & 0.28334E+00_JPRB,0.46499E+00_JPRB,0.55060E+00_JPRB,0.58775E+00_JPRB,0.46535E+00_JPRB /)  
KB(:, 4,17,11) = (/ &
 & 0.29718E+00_JPRB,0.47854E+00_JPRB,0.56610E+00_JPRB,0.59925E+00_JPRB,0.48105E+00_JPRB /)  
KB(:, 5,17,11) = (/ &
 & 0.31347E+00_JPRB,0.49215E+00_JPRB,0.58364E+00_JPRB,0.61031E+00_JPRB,0.49645E+00_JPRB /)  
KB(:, 1,18,11) = (/ &
 & 0.23548E+00_JPRB,0.40722E+00_JPRB,0.48899E+00_JPRB,0.52175E+00_JPRB,0.39754E+00_JPRB /)  
KB(:, 2,18,11) = (/ &
 & 0.24465E+00_JPRB,0.42091E+00_JPRB,0.50155E+00_JPRB,0.53754E+00_JPRB,0.41400E+00_JPRB /)  
KB(:, 3,18,11) = (/ &
 & 0.25717E+00_JPRB,0.43494E+00_JPRB,0.51756E+00_JPRB,0.55168E+00_JPRB,0.43132E+00_JPRB /)  
KB(:, 4,18,11) = (/ &
 & 0.27241E+00_JPRB,0.44915E+00_JPRB,0.53619E+00_JPRB,0.56524E+00_JPRB,0.44875E+00_JPRB /)  
KB(:, 5,18,11) = (/ &
 & 0.28792E+00_JPRB,0.46398E+00_JPRB,0.55551E+00_JPRB,0.57930E+00_JPRB,0.46590E+00_JPRB /)  
KB(:, 1,19,11) = (/ &
 & 0.20944E+00_JPRB,0.37826E+00_JPRB,0.45234E+00_JPRB,0.48406E+00_JPRB,0.36392E+00_JPRB /)  
KB(:, 2,19,11) = (/ &
 & 0.22089E+00_JPRB,0.39288E+00_JPRB,0.46903E+00_JPRB,0.50178E+00_JPRB,0.38211E+00_JPRB /)  
KB(:, 3,19,11) = (/ &
 & 0.23514E+00_JPRB,0.40761E+00_JPRB,0.48827E+00_JPRB,0.51821E+00_JPRB,0.40103E+00_JPRB /)  
KB(:, 4,19,11) = (/ &
 & 0.24973E+00_JPRB,0.42303E+00_JPRB,0.50894E+00_JPRB,0.53472E+00_JPRB,0.42003E+00_JPRB /)  
KB(:, 5,19,11) = (/ &
 & 0.26400E+00_JPRB,0.44033E+00_JPRB,0.52950E+00_JPRB,0.55236E+00_JPRB,0.43892E+00_JPRB /)  
KB(:, 1,20,11) = (/ &
 & 0.18773E+00_JPRB,0.35288E+00_JPRB,0.42094E+00_JPRB,0.44918E+00_JPRB,0.33536E+00_JPRB /)  
KB(:, 2,20,11) = (/ &
 & 0.20090E+00_JPRB,0.36792E+00_JPRB,0.44069E+00_JPRB,0.46887E+00_JPRB,0.35493E+00_JPRB /)  
KB(:, 3,20,11) = (/ &
 & 0.21482E+00_JPRB,0.38362E+00_JPRB,0.46266E+00_JPRB,0.48831E+00_JPRB,0.37530E+00_JPRB /)  
KB(:, 4,20,11) = (/ &
 & 0.22865E+00_JPRB,0.40117E+00_JPRB,0.48452E+00_JPRB,0.50881E+00_JPRB,0.39557E+00_JPRB /)  
KB(:, 5,20,11) = (/ &
 & 0.24234E+00_JPRB,0.42087E+00_JPRB,0.50657E+00_JPRB,0.53012E+00_JPRB,0.41595E+00_JPRB /)  
KB(:, 1,21,11) = (/ &
 & 0.16913E+00_JPRB,0.33019E+00_JPRB,0.39388E+00_JPRB,0.41795E+00_JPRB,0.31127E+00_JPRB /)  
KB(:, 2,21,11) = (/ &
 & 0.18253E+00_JPRB,0.34600E+00_JPRB,0.41645E+00_JPRB,0.43947E+00_JPRB,0.33210E+00_JPRB /)  
KB(:, 3,21,11) = (/ &
 & 0.19592E+00_JPRB,0.36350E+00_JPRB,0.43977E+00_JPRB,0.46279E+00_JPRB,0.35347E+00_JPRB /)  
KB(:, 4,21,11) = (/ &
 & 0.20921E+00_JPRB,0.38317E+00_JPRB,0.46337E+00_JPRB,0.48719E+00_JPRB,0.37483E+00_JPRB /)  
KB(:, 5,21,11) = (/ &
 & 0.22258E+00_JPRB,0.40476E+00_JPRB,0.48708E+00_JPRB,0.51206E+00_JPRB,0.39691E+00_JPRB /)  
KB(:, 1,22,11) = (/ &
 & 0.15329E+00_JPRB,0.31121E+00_JPRB,0.37219E+00_JPRB,0.39211E+00_JPRB,0.29266E+00_JPRB /)  
KB(:, 2,22,11) = (/ &
 & 0.16615E+00_JPRB,0.32878E+00_JPRB,0.39682E+00_JPRB,0.41672E+00_JPRB,0.31445E+00_JPRB /)  
KB(:, 3,22,11) = (/ &
 & 0.17924E+00_JPRB,0.34835E+00_JPRB,0.42167E+00_JPRB,0.44342E+00_JPRB,0.33660E+00_JPRB /)  
KB(:, 4,22,11) = (/ &
 & 0.19225E+00_JPRB,0.36990E+00_JPRB,0.44699E+00_JPRB,0.47133E+00_JPRB,0.35944E+00_JPRB /)  
KB(:, 5,22,11) = (/ &
 & 0.20541E+00_JPRB,0.39323E+00_JPRB,0.47271E+00_JPRB,0.49943E+00_JPRB,0.38308E+00_JPRB /)  
KB(:, 1,23,11) = (/ &
 & 0.13887E+00_JPRB,0.29534E+00_JPRB,0.35451E+00_JPRB,0.37144E+00_JPRB,0.27763E+00_JPRB /)  
KB(:, 2,23,11) = (/ &
 & 0.15131E+00_JPRB,0.31502E+00_JPRB,0.38068E+00_JPRB,0.39927E+00_JPRB,0.30013E+00_JPRB /)  
KB(:, 3,23,11) = (/ &
 & 0.16398E+00_JPRB,0.33651E+00_JPRB,0.40726E+00_JPRB,0.42913E+00_JPRB,0.32331E+00_JPRB /)  
KB(:, 4,23,11) = (/ &
 & 0.17699E+00_JPRB,0.35967E+00_JPRB,0.43436E+00_JPRB,0.45990E+00_JPRB,0.34758E+00_JPRB /)  
KB(:, 5,23,11) = (/ &
 & 0.19026E+00_JPRB,0.38467E+00_JPRB,0.46223E+00_JPRB,0.49074E+00_JPRB,0.37282E+00_JPRB /)  
KB(:, 1,24,11) = (/ &
 & 0.12585E+00_JPRB,0.28281E+00_JPRB,0.34015E+00_JPRB,0.35619E+00_JPRB,0.26580E+00_JPRB /)  
KB(:, 2,24,11) = (/ &
 & 0.13791E+00_JPRB,0.30436E+00_JPRB,0.36812E+00_JPRB,0.38675E+00_JPRB,0.28903E+00_JPRB /)  
KB(:, 3,24,11) = (/ &
 & 0.15049E+00_JPRB,0.32769E+00_JPRB,0.39648E+00_JPRB,0.41925E+00_JPRB,0.31342E+00_JPRB /)  
KB(:, 4,24,11) = (/ &
 & 0.16367E+00_JPRB,0.35256E+00_JPRB,0.42575E+00_JPRB,0.45270E+00_JPRB,0.33923E+00_JPRB /)  
KB(:, 5,24,11) = (/ &
 & 0.17705E+00_JPRB,0.37855E+00_JPRB,0.45558E+00_JPRB,0.48562E+00_JPRB,0.36598E+00_JPRB /)  
KB(:, 1,25,11) = (/ &
 & 0.11440E+00_JPRB,0.27340E+00_JPRB,0.32939E+00_JPRB,0.34570E+00_JPRB,0.25676E+00_JPRB /)  
KB(:, 2,25,11) = (/ &
 & 0.12619E+00_JPRB,0.29667E+00_JPRB,0.35918E+00_JPRB,0.37882E+00_JPRB,0.28103E+00_JPRB /)  
KB(:, 3,25,11) = (/ &
 & 0.13880E+00_JPRB,0.32182E+00_JPRB,0.38965E+00_JPRB,0.41370E+00_JPRB,0.30678E+00_JPRB /)  
KB(:, 4,25,11) = (/ &
 & 0.15209E+00_JPRB,0.34806E+00_JPRB,0.42076E+00_JPRB,0.44907E+00_JPRB,0.33404E+00_JPRB /)  
KB(:, 5,25,11) = (/ &
 & 0.16564E+00_JPRB,0.37478E+00_JPRB,0.45238E+00_JPRB,0.48364E+00_JPRB,0.36209E+00_JPRB /)  
KB(:, 1,26,11) = (/ &
 & 0.10459E+00_JPRB,0.26698E+00_JPRB,0.32246E+00_JPRB,0.33976E+00_JPRB,0.25076E+00_JPRB /)  
KB(:, 2,26,11) = (/ &
 & 0.11626E+00_JPRB,0.29209E+00_JPRB,0.35422E+00_JPRB,0.37512E+00_JPRB,0.27618E+00_JPRB /)  
KB(:, 3,26,11) = (/ &
 & 0.12895E+00_JPRB,0.31885E+00_JPRB,0.38669E+00_JPRB,0.41203E+00_JPRB,0.30332E+00_JPRB /)  
KB(:, 4,26,11) = (/ &
 & 0.14230E+00_JPRB,0.34607E+00_JPRB,0.41933E+00_JPRB,0.44889E+00_JPRB,0.33190E+00_JPRB /)  
KB(:, 5,26,11) = (/ &
 & 0.15605E+00_JPRB,0.37346E+00_JPRB,0.45243E+00_JPRB,0.48462E+00_JPRB,0.36103E+00_JPRB /)  
KB(:, 1,27,11) = (/ &
 & 0.96118E-01_JPRB,0.26319E+00_JPRB,0.31888E+00_JPRB,0.33748E+00_JPRB,0.24718E+00_JPRB /)  
KB(:, 2,27,11) = (/ &
 & 0.10777E+00_JPRB,0.29006E+00_JPRB,0.35247E+00_JPRB,0.37471E+00_JPRB,0.27379E+00_JPRB /)  
KB(:, 3,27,11) = (/ &
 & 0.12054E+00_JPRB,0.31789E+00_JPRB,0.38657E+00_JPRB,0.41315E+00_JPRB,0.30239E+00_JPRB /)  
KB(:, 4,27,11) = (/ &
 & 0.13403E+00_JPRB,0.34597E+00_JPRB,0.42050E+00_JPRB,0.45108E+00_JPRB,0.33196E+00_JPRB /)  
KB(:, 5,27,11) = (/ &
 & 0.14803E+00_JPRB,0.37409E+00_JPRB,0.45469E+00_JPRB,0.48753E+00_JPRB,0.36202E+00_JPRB /)  
KB(:, 1,28,11) = (/ &
 & 0.88934E-01_JPRB,0.26189E+00_JPRB,0.31824E+00_JPRB,0.33815E+00_JPRB,0.24575E+00_JPRB /)  
KB(:, 2,28,11) = (/ &
 & 0.10066E+00_JPRB,0.29004E+00_JPRB,0.35339E+00_JPRB,0.37699E+00_JPRB,0.27368E+00_JPRB /)  
KB(:, 3,28,11) = (/ &
 & 0.11346E+00_JPRB,0.31878E+00_JPRB,0.38868E+00_JPRB,0.41646E+00_JPRB,0.30334E+00_JPRB /)  
KB(:, 4,28,11) = (/ &
 & 0.12719E+00_JPRB,0.34746E+00_JPRB,0.42368E+00_JPRB,0.45510E+00_JPRB,0.33384E+00_JPRB /)  
KB(:, 5,28,11) = (/ &
 & 0.14149E+00_JPRB,0.37622E+00_JPRB,0.45856E+00_JPRB,0.49189E+00_JPRB,0.36458E+00_JPRB /)  
KB(:, 1,29,11) = (/ &
 & 0.82953E-01_JPRB,0.26276E+00_JPRB,0.32032E+00_JPRB,0.34153E+00_JPRB,0.24649E+00_JPRB /)  
KB(:, 2,29,11) = (/ &
 & 0.94812E-01_JPRB,0.29186E+00_JPRB,0.35678E+00_JPRB,0.38153E+00_JPRB,0.27563E+00_JPRB /)  
KB(:, 3,29,11) = (/ &
 & 0.10778E+00_JPRB,0.32138E+00_JPRB,0.39278E+00_JPRB,0.42163E+00_JPRB,0.30623E+00_JPRB /)  
KB(:, 4,29,11) = (/ &
 & 0.12182E+00_JPRB,0.35053E+00_JPRB,0.42853E+00_JPRB,0.46064E+00_JPRB,0.33743E+00_JPRB /)  
KB(:, 5,29,11) = (/ &
 & 0.13655E+00_JPRB,0.37990E+00_JPRB,0.46387E+00_JPRB,0.49754E+00_JPRB,0.36866E+00_JPRB /)  
KB(:, 1,30,11) = (/ &
 & 0.78111E-01_JPRB,0.26530E+00_JPRB,0.32451E+00_JPRB,0.34680E+00_JPRB,0.24893E+00_JPRB /)  
KB(:, 2,30,11) = (/ &
 & 0.90075E-01_JPRB,0.29517E+00_JPRB,0.36183E+00_JPRB,0.38763E+00_JPRB,0.27915E+00_JPRB /)  
KB(:, 3,30,11) = (/ &
 & 0.10336E+00_JPRB,0.32522E+00_JPRB,0.39838E+00_JPRB,0.42809E+00_JPRB,0.31046E+00_JPRB /)  
KB(:, 4,30,11) = (/ &
 & 0.11787E+00_JPRB,0.35483E+00_JPRB,0.43455E+00_JPRB,0.46718E+00_JPRB,0.34218E+00_JPRB /)  
KB(:, 5,30,11) = (/ &
 & 0.13307E+00_JPRB,0.38452E+00_JPRB,0.47003E+00_JPRB,0.50395E+00_JPRB,0.37368E+00_JPRB /)  
KB(:, 1,31,11) = (/ &
 & 0.74235E-01_JPRB,0.26927E+00_JPRB,0.33033E+00_JPRB,0.35368E+00_JPRB,0.25294E+00_JPRB /)  
KB(:, 2,31,11) = (/ &
 & 0.86475E-01_JPRB,0.29980E+00_JPRB,0.36814E+00_JPRB,0.39505E+00_JPRB,0.28398E+00_JPRB /)  
KB(:, 3,31,11) = (/ &
 & 0.10025E+00_JPRB,0.33020E+00_JPRB,0.40500E+00_JPRB,0.43563E+00_JPRB,0.31586E+00_JPRB /)  
KB(:, 4,31,11) = (/ &
 & 0.11530E+00_JPRB,0.36008E+00_JPRB,0.44151E+00_JPRB,0.47461E+00_JPRB,0.34790E+00_JPRB /)  
KB(:, 5,31,11) = (/ &
 & 0.13103E+00_JPRB,0.38989E+00_JPRB,0.47695E+00_JPRB,0.51108E+00_JPRB,0.37953E+00_JPRB /)  
KB(:, 1,32,11) = (/ &
 & 0.71362E-01_JPRB,0.27445E+00_JPRB,0.33748E+00_JPRB,0.36171E+00_JPRB,0.25820E+00_JPRB /)  
KB(:, 2,32,11) = (/ &
 & 0.84060E-01_JPRB,0.30547E+00_JPRB,0.37545E+00_JPRB,0.40335E+00_JPRB,0.28988E+00_JPRB /)  
KB(:, 3,32,11) = (/ &
 & 0.98456E-01_JPRB,0.33600E+00_JPRB,0.41253E+00_JPRB,0.44393E+00_JPRB,0.32217E+00_JPRB /)  
KB(:, 4,32,11) = (/ &
 & 0.11408E+00_JPRB,0.36612E+00_JPRB,0.44914E+00_JPRB,0.48266E+00_JPRB,0.35443E+00_JPRB /)  
KB(:, 5,32,11) = (/ &
 & 0.13035E+00_JPRB,0.39590E+00_JPRB,0.48448E+00_JPRB,0.51873E+00_JPRB,0.38602E+00_JPRB /)  
KB(:, 1,33,11) = (/ &
 & 0.69437E-01_JPRB,0.28056E+00_JPRB,0.34548E+00_JPRB,0.37055E+00_JPRB,0.26439E+00_JPRB /)  
KB(:, 2,33,11) = (/ &
 & 0.82778E-01_JPRB,0.31179E+00_JPRB,0.38345E+00_JPRB,0.41222E+00_JPRB,0.29653E+00_JPRB /)  
KB(:, 3,33,11) = (/ &
 & 0.97818E-01_JPRB,0.34234E+00_JPRB,0.42058E+00_JPRB,0.45271E+00_JPRB,0.32902E+00_JPRB /)  
KB(:, 4,33,11) = (/ &
 & 0.11406E+00_JPRB,0.37264E+00_JPRB,0.45719E+00_JPRB,0.49102E+00_JPRB,0.36138E+00_JPRB /)  
KB(:, 5,33,11) = (/ &
 & 0.13083E+00_JPRB,0.40228E+00_JPRB,0.49234E+00_JPRB,0.52669E+00_JPRB,0.39293E+00_JPRB /)  
KB(:, 1,34,11) = (/ &
 & 0.68001E-01_JPRB,0.28611E+00_JPRB,0.35258E+00_JPRB,0.37843E+00_JPRB,0.27007E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART28',1,ZHOOK_HANDLE)
END SUBROUTINE PART28


SUBROUTINE PART29

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART29',0,ZHOOK_HANDLE)


KB(:, 2,34,11) = (/ &
 & 0.82015E-01_JPRB,0.31742E+00_JPRB,0.39059E+00_JPRB,0.42007E+00_JPRB,0.30253E+00_JPRB /)  
KB(:, 3,34,11) = (/ &
 & 0.97684E-01_JPRB,0.34800E+00_JPRB,0.42777E+00_JPRB,0.46038E+00_JPRB,0.33518E+00_JPRB /)  
KB(:, 4,34,11) = (/ &
 & 0.11453E+00_JPRB,0.37836E+00_JPRB,0.46423E+00_JPRB,0.49832E+00_JPRB,0.36754E+00_JPRB /)  
KB(:, 5,34,11) = (/ &
 & 0.13165E+00_JPRB,0.40799E+00_JPRB,0.49927E+00_JPRB,0.53358E+00_JPRB,0.39902E+00_JPRB /)  
KB(:, 1,35,11) = (/ &
 & 0.66173E-01_JPRB,0.28901E+00_JPRB,0.35634E+00_JPRB,0.38261E+00_JPRB,0.27305E+00_JPRB /)  
KB(:, 2,35,11) = (/ &
 & 0.80679E-01_JPRB,0.32036E+00_JPRB,0.39443E+00_JPRB,0.42428E+00_JPRB,0.30572E+00_JPRB /)  
KB(:, 3,35,11) = (/ &
 & 0.96839E-01_JPRB,0.35097E+00_JPRB,0.43164E+00_JPRB,0.46448E+00_JPRB,0.33845E+00_JPRB /)  
KB(:, 4,35,11) = (/ &
 & 0.11412E+00_JPRB,0.38139E+00_JPRB,0.46804E+00_JPRB,0.50225E+00_JPRB,0.37079E+00_JPRB /)  
KB(:, 5,35,11) = (/ &
 & 0.13154E+00_JPRB,0.41104E+00_JPRB,0.50302E+00_JPRB,0.53730E+00_JPRB,0.40230E+00_JPRB /)  
KB(:, 1,36,11) = (/ &
 & 0.63512E-01_JPRB,0.28876E+00_JPRB,0.35615E+00_JPRB,0.38246E+00_JPRB,0.27277E+00_JPRB /)  
KB(:, 2,36,11) = (/ &
 & 0.78322E-01_JPRB,0.32017E+00_JPRB,0.39440E+00_JPRB,0.42423E+00_JPRB,0.30554E+00_JPRB /)  
KB(:, 3,36,11) = (/ &
 & 0.94792E-01_JPRB,0.35084E+00_JPRB,0.43169E+00_JPRB,0.46451E+00_JPRB,0.33835E+00_JPRB /)  
KB(:, 4,36,11) = (/ &
 & 0.11239E+00_JPRB,0.38129E+00_JPRB,0.46814E+00_JPRB,0.50234E+00_JPRB,0.37075E+00_JPRB /)  
KB(:, 5,36,11) = (/ &
 & 0.13007E+00_JPRB,0.41105E+00_JPRB,0.50318E+00_JPRB,0.53745E+00_JPRB,0.40235E+00_JPRB /)  
KB(:, 1,37,11) = (/ &
 & 0.59276E-01_JPRB,0.28388E+00_JPRB,0.35018E+00_JPRB,0.37605E+00_JPRB,0.26777E+00_JPRB /)  
KB(:, 2,37,11) = (/ &
 & 0.74070E-01_JPRB,0.31543E+00_JPRB,0.38877E+00_JPRB,0.41809E+00_JPRB,0.30055E+00_JPRB /)  
KB(:, 3,37,11) = (/ &
 & 0.90621E-01_JPRB,0.34621E+00_JPRB,0.42622E+00_JPRB,0.45870E+00_JPRB,0.33345E+00_JPRB /)  
KB(:, 4,37,11) = (/ &
 & 0.10838E+00_JPRB,0.37677E+00_JPRB,0.46291E+00_JPRB,0.49695E+00_JPRB,0.36598E+00_JPRB /)  
KB(:, 5,37,11) = (/ &
 & 0.12629E+00_JPRB,0.40664E+00_JPRB,0.49817E+00_JPRB,0.53255E+00_JPRB,0.39771E+00_JPRB /)  
KB(:, 1,38,11) = (/ &
 & 0.55352E-01_JPRB,0.27885E+00_JPRB,0.34399E+00_JPRB,0.36943E+00_JPRB,0.26263E+00_JPRB /)  
KB(:, 2,38,11) = (/ &
 & 0.70099E-01_JPRB,0.31053E+00_JPRB,0.38289E+00_JPRB,0.41165E+00_JPRB,0.29537E+00_JPRB /)  
KB(:, 3,38,11) = (/ &
 & 0.86674E-01_JPRB,0.34144E+00_JPRB,0.42052E+00_JPRB,0.45261E+00_JPRB,0.32834E+00_JPRB /)  
KB(:, 4,38,11) = (/ &
 & 0.10451E+00_JPRB,0.37207E+00_JPRB,0.45745E+00_JPRB,0.49130E+00_JPRB,0.36103E+00_JPRB /)  
KB(:, 5,38,11) = (/ &
 & 0.12261E+00_JPRB,0.40208E+00_JPRB,0.49291E+00_JPRB,0.52735E+00_JPRB,0.39288E+00_JPRB /)  
KB(:, 1,39,11) = (/ &
 & 0.51830E-01_JPRB,0.27388E+00_JPRB,0.33795E+00_JPRB,0.36294E+00_JPRB,0.25765E+00_JPRB /)  
KB(:, 2,39,11) = (/ &
 & 0.66473E-01_JPRB,0.30570E+00_JPRB,0.37709E+00_JPRB,0.40534E+00_JPRB,0.29029E+00_JPRB /)  
KB(:, 3,39,11) = (/ &
 & 0.83032E-01_JPRB,0.33678E+00_JPRB,0.41490E+00_JPRB,0.44656E+00_JPRB,0.32332E+00_JPRB /)  
KB(:, 4,39,11) = (/ &
 & 0.10089E+00_JPRB,0.36746E+00_JPRB,0.45203E+00_JPRB,0.48569E+00_JPRB,0.35615E+00_JPRB /)  
KB(:, 5,39,11) = (/ &
 & 0.11914E+00_JPRB,0.39759E+00_JPRB,0.48773E+00_JPRB,0.52218E+00_JPRB,0.38813E+00_JPRB /)  
KB(:, 1,40,11) = (/ &
 & 0.47273E-01_JPRB,0.26566E+00_JPRB,0.32789E+00_JPRB,0.35219E+00_JPRB,0.24948E+00_JPRB /)  
KB(:, 2,40,11) = (/ &
 & 0.61538E-01_JPRB,0.29768E+00_JPRB,0.36730E+00_JPRB,0.39473E+00_JPRB,0.28193E+00_JPRB /)  
KB(:, 3,40,11) = (/ &
 & 0.77858E-01_JPRB,0.32903E+00_JPRB,0.40551E+00_JPRB,0.43635E+00_JPRB,0.31499E+00_JPRB /)  
KB(:, 4,40,11) = (/ &
 & 0.95580E-01_JPRB,0.35975E+00_JPRB,0.44288E+00_JPRB,0.47617E+00_JPRB,0.34794E+00_JPRB /)  
KB(:, 5,40,11) = (/ &
 & 0.11394E+00_JPRB,0.39008E+00_JPRB,0.47900E+00_JPRB,0.51333E+00_JPRB,0.38020E+00_JPRB /)  
KB(:, 1,41,11) = (/ &
 & 0.42888E-01_JPRB,0.25708E+00_JPRB,0.31732E+00_JPRB,0.34096E+00_JPRB,0.24098E+00_JPRB /)  
KB(:, 2,41,11) = (/ &
 & 0.56697E-01_JPRB,0.28927E+00_JPRB,0.35696E+00_JPRB,0.38355E+00_JPRB,0.27327E+00_JPRB /)  
KB(:, 3,41,11) = (/ &
 & 0.72702E-01_JPRB,0.32083E+00_JPRB,0.39561E+00_JPRB,0.42555E+00_JPRB,0.30626E+00_JPRB /)  
KB(:, 4,41,11) = (/ &
 & 0.90227E-01_JPRB,0.35164E+00_JPRB,0.43315E+00_JPRB,0.46599E+00_JPRB,0.33930E+00_JPRB /)  
KB(:, 5,41,11) = (/ &
 & 0.10861E+00_JPRB,0.38219E+00_JPRB,0.46971E+00_JPRB,0.50385E+00_JPRB,0.37183E+00_JPRB /)  
KB(:, 1,42,11) = (/ &
 & 0.38819E-01_JPRB,0.24850E+00_JPRB,0.30677E+00_JPRB,0.32968E+00_JPRB,0.23256E+00_JPRB /)  
KB(:, 2,42,11) = (/ &
 & 0.52147E-01_JPRB,0.28080E+00_JPRB,0.34660E+00_JPRB,0.37239E+00_JPRB,0.26466E+00_JPRB /)  
KB(:, 3,42,11) = (/ &
 & 0.67768E-01_JPRB,0.31263E+00_JPRB,0.38564E+00_JPRB,0.41466E+00_JPRB,0.29758E+00_JPRB /)  
KB(:, 4,42,11) = (/ &
 & 0.85041E-01_JPRB,0.34356E+00_JPRB,0.42336E+00_JPRB,0.45563E+00_JPRB,0.33065E+00_JPRB /)  
KB(:, 5,42,11) = (/ &
 & 0.10335E+00_JPRB,0.37426E+00_JPRB,0.46032E+00_JPRB,0.49419E+00_JPRB,0.36339E+00_JPRB /)  
KB(:, 1,43,11) = (/ &
 & 0.34406E-01_JPRB,0.23801E+00_JPRB,0.29406E+00_JPRB,0.31601E+00_JPRB,0.22240E+00_JPRB /)  
KB(:, 2,43,11) = (/ &
 & 0.47048E-01_JPRB,0.27050E+00_JPRB,0.33401E+00_JPRB,0.35883E+00_JPRB,0.25435E+00_JPRB /)  
KB(:, 3,43,11) = (/ &
 & 0.62114E-01_JPRB,0.30257E+00_JPRB,0.37337E+00_JPRB,0.40135E+00_JPRB,0.28701E+00_JPRB /)  
KB(:, 4,43,11) = (/ &
 & 0.79018E-01_JPRB,0.33381E+00_JPRB,0.41146E+00_JPRB,0.44285E+00_JPRB,0.32012E+00_JPRB /)  
KB(:, 5,43,11) = (/ &
 & 0.97123E-01_JPRB,0.36459E+00_JPRB,0.44877E+00_JPRB,0.48229E+00_JPRB,0.35311E+00_JPRB /)  
KB(:, 1,44,11) = (/ &
 & 0.30068E-01_JPRB,0.22661E+00_JPRB,0.28047E+00_JPRB,0.30141E+00_JPRB,0.21157E+00_JPRB /)  
KB(:, 2,44,11) = (/ &
 & 0.41934E-01_JPRB,0.25939E+00_JPRB,0.32031E+00_JPRB,0.34420E+00_JPRB,0.24331E+00_JPRB /)  
KB(:, 3,44,11) = (/ &
 & 0.56334E-01_JPRB,0.29165E+00_JPRB,0.35997E+00_JPRB,0.38686E+00_JPRB,0.27569E+00_JPRB /)  
KB(:, 4,44,11) = (/ &
 & 0.72738E-01_JPRB,0.32319E+00_JPRB,0.39860E+00_JPRB,0.42881E+00_JPRB,0.30880E+00_JPRB /)  
KB(:, 5,44,11) = (/ &
 & 0.90538E-01_JPRB,0.35407E+00_JPRB,0.43616E+00_JPRB,0.46913E+00_JPRB,0.34187E+00_JPRB /)  
KB(:, 1,45,11) = (/ &
 & 0.26090E-01_JPRB,0.21511E+00_JPRB,0.26705E+00_JPRB,0.28701E+00_JPRB,0.20089E+00_JPRB /)  
KB(:, 2,45,11) = (/ &
 & 0.37182E-01_JPRB,0.24828E+00_JPRB,0.30662E+00_JPRB,0.32954E+00_JPRB,0.23239E+00_JPRB /)  
KB(:, 3,45,11) = (/ &
 & 0.50828E-01_JPRB,0.28069E+00_JPRB,0.34649E+00_JPRB,0.37235E+00_JPRB,0.26452E+00_JPRB /)  
KB(:, 4,45,11) = (/ &
 & 0.66683E-01_JPRB,0.31254E+00_JPRB,0.38562E+00_JPRB,0.41465E+00_JPRB,0.29751E+00_JPRB /)  
KB(:, 5,45,11) = (/ &
 & 0.84110E-01_JPRB,0.34354E+00_JPRB,0.42341E+00_JPRB,0.45565E+00_JPRB,0.33061E+00_JPRB /)  
KB(:, 1,46,11) = (/ &
 & 0.22282E-01_JPRB,0.20276E+00_JPRB,0.25300E+00_JPRB,0.27194E+00_JPRB,0.18966E+00_JPRB /)  
KB(:, 2,46,11) = (/ &
 & 0.32494E-01_JPRB,0.23634E+00_JPRB,0.29212E+00_JPRB,0.31397E+00_JPRB,0.22083E+00_JPRB /)  
KB(:, 3,46,11) = (/ &
 & 0.45322E-01_JPRB,0.26893E+00_JPRB,0.33209E+00_JPRB,0.35685E+00_JPRB,0.25276E+00_JPRB /)  
KB(:, 4,46,11) = (/ &
 & 0.60492E-01_JPRB,0.30105E+00_JPRB,0.37160E+00_JPRB,0.39945E+00_JPRB,0.28546E+00_JPRB /)  
KB(:, 5,46,11) = (/ &
 & 0.77449E-01_JPRB,0.33241E+00_JPRB,0.40979E+00_JPRB,0.44100E+00_JPRB,0.31859E+00_JPRB /)  
KB(:, 1,47,11) = (/ &
 & 0.18534E-01_JPRB,0.18898E+00_JPRB,0.23758E+00_JPRB,0.25552E+00_JPRB,0.17724E+00_JPRB /)  
KB(:, 2,47,11) = (/ &
 & 0.27732E-01_JPRB,0.22283E+00_JPRB,0.27608E+00_JPRB,0.29673E+00_JPRB,0.20806E+00_JPRB /)  
KB(:, 3,47,11) = (/ &
 & 0.39604E-01_JPRB,0.25581E+00_JPRB,0.31589E+00_JPRB,0.33953E+00_JPRB,0.23975E+00_JPRB /)  
KB(:, 4,47,11) = (/ &
 & 0.53911E-01_JPRB,0.28814E+00_JPRB,0.35568E+00_JPRB,0.38226E+00_JPRB,0.27210E+00_JPRB /)  
KB(:, 5,47,11) = (/ &
 & 0.70242E-01_JPRB,0.31982E+00_JPRB,0.39452E+00_JPRB,0.42435E+00_JPRB,0.30521E+00_JPRB /)  
KB(:, 1,48,11) = (/ &
 & 0.15230E-01_JPRB,0.17512E+00_JPRB,0.22238E+00_JPRB,0.23953E+00_JPRB,0.16496E+00_JPRB /)  
KB(:, 2,48,11) = (/ &
 & 0.23424E-01_JPRB,0.20917E+00_JPRB,0.26028E+00_JPRB,0.27977E+00_JPRB,0.19549E+00_JPRB /)  
KB(:, 3,48,11) = (/ &
 & 0.34289E-01_JPRB,0.24261E+00_JPRB,0.29967E+00_JPRB,0.32213E+00_JPRB,0.22686E+00_JPRB /)  
KB(:, 4,48,11) = (/ &
 & 0.47677E-01_JPRB,0.27510E+00_JPRB,0.33967E+00_JPRB,0.36502E+00_JPRB,0.25892E+00_JPRB /)  
KB(:, 5,48,11) = (/ &
 & 0.63303E-01_JPRB,0.30711E+00_JPRB,0.37902E+00_JPRB,0.40749E+00_JPRB,0.29180E+00_JPRB /)  
KB(:, 1,49,11) = (/ &
 & 0.12348E-01_JPRB,0.16145E+00_JPRB,0.20748E+00_JPRB,0.22396E+00_JPRB,0.15290E+00_JPRB /)  
KB(:, 2,49,11) = (/ &
 & 0.19656E-01_JPRB,0.19547E+00_JPRB,0.24481E+00_JPRB,0.26319E+00_JPRB,0.18304E+00_JPRB /)  
KB(:, 3,49,11) = (/ &
 & 0.29411E-01_JPRB,0.22922E+00_JPRB,0.28358E+00_JPRB,0.30484E+00_JPRB,0.21403E+00_JPRB /)  
KB(:, 4,49,11) = (/ &
 & 0.41852E-01_JPRB,0.26199E+00_JPRB,0.32356E+00_JPRB,0.34774E+00_JPRB,0.24589E+00_JPRB /)  
KB(:, 5,49,11) = (/ &
 & 0.56641E-01_JPRB,0.29425E+00_JPRB,0.36325E+00_JPRB,0.39043E+00_JPRB,0.27839E+00_JPRB /)  
KB(:, 1,50,11) = (/ &
 & 0.10059E-01_JPRB,0.14901E+00_JPRB,0.19385E+00_JPRB,0.20977E+00_JPRB,0.14182E+00_JPRB /)  
KB(:, 2,50,11) = (/ &
 & 0.16439E-01_JPRB,0.18255E+00_JPRB,0.23049E+00_JPRB,0.24806E+00_JPRB,0.17150E+00_JPRB /)  
KB(:, 3,50,11) = (/ &
 & 0.25328E-01_JPRB,0.21656E+00_JPRB,0.26875E+00_JPRB,0.28888E+00_JPRB,0.20219E+00_JPRB /)  
KB(:, 4,50,11) = (/ &
 & 0.36730E-01_JPRB,0.24971E+00_JPRB,0.30839E+00_JPRB,0.33151E+00_JPRB,0.23378E+00_JPRB /)  
KB(:, 5,50,11) = (/ &
 & 0.50682E-01_JPRB,0.28213E+00_JPRB,0.34832E+00_JPRB,0.37432E+00_JPRB,0.26599E+00_JPRB /)  
KB(:, 1,51,11) = (/ &
 & 0.81000E-02_JPRB,0.13718E+00_JPRB,0.18086E+00_JPRB,0.19633E+00_JPRB,0.13125E+00_JPRB /)  
KB(:, 2,51,11) = (/ &
 & 0.13663E-01_JPRB,0.17002E+00_JPRB,0.21682E+00_JPRB,0.23372E+00_JPRB,0.16044E+00_JPRB /)  
KB(:, 3,51,11) = (/ &
 & 0.21646E-01_JPRB,0.20410E+00_JPRB,0.25452E+00_JPRB,0.27362E+00_JPRB,0.19085E+00_JPRB /)  
KB(:, 4,51,11) = (/ &
 & 0.32117E-01_JPRB,0.23766E+00_JPRB,0.29370E+00_JPRB,0.31573E+00_JPRB,0.22210E+00_JPRB /)  
KB(:, 5,51,11) = (/ &
 & 0.45217E-01_JPRB,0.27026E+00_JPRB,0.33377E+00_JPRB,0.35865E+00_JPRB,0.25409E+00_JPRB /)  
KB(:, 1,52,11) = (/ &
 & 0.64392E-02_JPRB,0.12568E+00_JPRB,0.16814E+00_JPRB,0.18321E+00_JPRB,0.12091E+00_JPRB /)  
KB(:, 2,52,11) = (/ &
 & 0.11223E-01_JPRB,0.15773E+00_JPRB,0.20341E+00_JPRB,0.21973E+00_JPRB,0.14959E+00_JPRB /)  
KB(:, 3,52,11) = (/ &
 & 0.18327E-01_JPRB,0.19165E+00_JPRB,0.24057E+00_JPRB,0.25870E+00_JPRB,0.17960E+00_JPRB /)  
KB(:, 4,52,11) = (/ &
 & 0.27978E-01_JPRB,0.22553E+00_JPRB,0.27924E+00_JPRB,0.30015E+00_JPRB,0.21055E+00_JPRB /)  
KB(:, 5,52,11) = (/ &
 & 0.40066E-01_JPRB,0.25840E+00_JPRB,0.31913E+00_JPRB,0.34300E+00_JPRB,0.24233E+00_JPRB /)  
KB(:, 1,53,11) = (/ &
 & 0.50582E-02_JPRB,0.11452E+00_JPRB,0.15565E+00_JPRB,0.17040E+00_JPRB,0.11082E+00_JPRB /)  
KB(:, 2,53,11) = (/ &
 & 0.90986E-02_JPRB,0.14571E+00_JPRB,0.19026E+00_JPRB,0.20608E+00_JPRB,0.13891E+00_JPRB /)  
KB(:, 3,53,11) = (/ &
 & 0.15360E-01_JPRB,0.17911E+00_JPRB,0.22674E+00_JPRB,0.24415E+00_JPRB,0.16845E+00_JPRB /)  
KB(:, 4,53,11) = (/ &
 & 0.24079E-01_JPRB,0.21320E+00_JPRB,0.26488E+00_JPRB,0.28473E+00_JPRB,0.19911E+00_JPRB /)  
KB(:, 5,53,11) = (/ &
 & 0.35249E-01_JPRB,0.24647E+00_JPRB,0.30443E+00_JPRB,0.32725E+00_JPRB,0.23061E+00_JPRB /)  
KB(:, 1,54,11) = (/ &
 & 0.39947E-02_JPRB,0.10467E+00_JPRB,0.14438E+00_JPRB,0.15895E+00_JPRB,0.10183E+00_JPRB /)  
KB(:, 2,54,11) = (/ &
 & 0.74123E-02_JPRB,0.13495E+00_JPRB,0.17842E+00_JPRB,0.19384E+00_JPRB,0.12928E+00_JPRB /)  
KB(:, 3,54,11) = (/ &
 & 0.12928E-01_JPRB,0.16768E+00_JPRB,0.21428E+00_JPRB,0.23108E+00_JPRB,0.15838E+00_JPRB /)  
KB(:, 4,54,11) = (/ &
 & 0.20817E-01_JPRB,0.20178E+00_JPRB,0.25191E+00_JPRB,0.27082E+00_JPRB,0.18875E+00_JPRB /)  
KB(:, 5,54,11) = (/ &
 & 0.31131E-01_JPRB,0.23540E+00_JPRB,0.29100E+00_JPRB,0.31283E+00_JPRB,0.21994E+00_JPRB /)  
KB(:, 1,55,11) = (/ &
 & 0.31444E-02_JPRB,0.95645E-01_JPRB,0.13357E+00_JPRB,0.14821E+00_JPRB,0.93456E-01_JPRB /)  
KB(:, 2,55,11) = (/ &
 & 0.60192E-02_JPRB,0.12488E+00_JPRB,0.16728E+00_JPRB,0.18235E+00_JPRB,0.12022E+00_JPRB /)  
KB(:, 3,55,11) = (/ &
 & 0.10844E-01_JPRB,0.15692E+00_JPRB,0.20255E+00_JPRB,0.21884E+00_JPRB,0.14887E+00_JPRB /)  
KB(:, 4,55,11) = (/ &
 & 0.17966E-01_JPRB,0.19085E+00_JPRB,0.23968E+00_JPRB,0.25776E+00_JPRB,0.17889E+00_JPRB /)  
KB(:, 5,55,11) = (/ &
 & 0.27575E-01_JPRB,0.22475E+00_JPRB,0.27833E+00_JPRB,0.29920E+00_JPRB,0.20981E+00_JPRB /)  
KB(:, 1,56,11) = (/ &
 & 0.24408E-02_JPRB,0.87042E-01_JPRB,0.12294E+00_JPRB,0.13774E+00_JPRB,0.85384E-01_JPRB /)  
KB(:, 2,56,11) = (/ &
 & 0.48425E-02_JPRB,0.11512E+00_JPRB,0.15634E+00_JPRB,0.17115E+00_JPRB,0.11140E+00_JPRB /)  
KB(:, 3,56,11) = (/ &
 & 0.90070E-02_JPRB,0.14641E+00_JPRB,0.19103E+00_JPRB,0.20689E+00_JPRB,0.13953E+00_JPRB /)  
KB(:, 4,56,11) = (/ &
 & 0.15384E-01_JPRB,0.17987E+00_JPRB,0.22757E+00_JPRB,0.24502E+00_JPRB,0.16913E+00_JPRB /)  
KB(:, 5,56,11) = (/ &
 & 0.24183E-01_JPRB,0.21396E+00_JPRB,0.26576E+00_JPRB,0.28569E+00_JPRB,0.19980E+00_JPRB /)  
KB(:, 1,57,11) = (/ &
 & 0.18661E-02_JPRB,0.78869E-01_JPRB,0.11259E+00_JPRB,0.12744E+00_JPRB,0.77594E-01_JPRB /)  
KB(:, 2,57,11) = (/ &
 & 0.38393E-02_JPRB,0.10567E+00_JPRB,0.14558E+00_JPRB,0.16018E+00_JPRB,0.10279E+00_JPRB /)  
KB(:, 3,57,11) = (/ &
 & 0.73986E-02_JPRB,0.13611E+00_JPRB,0.17972E+00_JPRB,0.19518E+00_JPRB,0.13032E+00_JPRB /)  
KB(:, 4,57,11) = (/ &
 & 0.13057E-01_JPRB,0.16895E+00_JPRB,0.21565E+00_JPRB,0.23253E+00_JPRB,0.15951E+00_JPRB /)  
KB(:, 5,57,11) = (/ &
 & 0.21059E-01_JPRB,0.20305E+00_JPRB,0.25335E+00_JPRB,0.27238E+00_JPRB,0.18989E+00_JPRB /)  
KB(:, 1,58,11) = (/ &
 & 0.14289E-02_JPRB,0.71481E-01_JPRB,0.10314E+00_JPRB,0.11789E+00_JPRB,0.70461E-01_JPRB /)  
KB(:, 2,58,11) = (/ &
 & 0.30447E-02_JPRB,0.97100E-01_JPRB,0.13537E+00_JPRB,0.15001E+00_JPRB,0.94840E-01_JPRB /)  
KB(:, 3,58,11) = (/ &
 & 0.60785E-02_JPRB,0.12656E+00_JPRB,0.16917E+00_JPRB,0.18428E+00_JPRB,0.12173E+00_JPRB /)  
KB(:, 4,58,11) = (/ &
 & 0.11073E-01_JPRB,0.15875E+00_JPRB,0.20453E+00_JPRB,0.22090E+00_JPRB,0.15049E+00_JPRB /)  
KB(:, 5,58,11) = (/ &
 & 0.18344E-01_JPRB,0.19271E+00_JPRB,0.24175E+00_JPRB,0.25997E+00_JPRB,0.18056E+00_JPRB /)  
KB(:, 1,59,11) = (/ &
 & 0.12466E-02_JPRB,0.68608E-01_JPRB,0.99449E-01_JPRB,0.11409E+00_JPRB,0.67679E-01_JPRB /)  
KB(:, 2,59,11) = (/ &
 & 0.27400E-02_JPRB,0.93756E-01_JPRB,0.13130E+00_JPRB,0.14598E+00_JPRB,0.91727E-01_JPRB /)  
KB(:, 3,59,11) = (/ &
 & 0.55829E-02_JPRB,0.12280E+00_JPRB,0.16498E+00_JPRB,0.17997E+00_JPRB,0.11835E+00_JPRB /)  
KB(:, 4,59,11) = (/ &
 & 0.10327E-01_JPRB,0.15471E+00_JPRB,0.20012E+00_JPRB,0.21632E+00_JPRB,0.14691E+00_JPRB /)  
KB(:, 5,59,11) = (/ &
 & 0.17312E-01_JPRB,0.18856E+00_JPRB,0.23714E+00_JPRB,0.25511E+00_JPRB,0.17685E+00_JPRB /)  
KB(:, 1,13,12) = (/ &
 & 0.97672E+00_JPRB,0.12351E+01_JPRB,0.13467E+01_JPRB,0.13355E+01_JPRB,0.11350E+01_JPRB /)  
KB(:, 2,13,12) = (/ &
 & 0.96517E+00_JPRB,0.12326E+01_JPRB,0.13523E+01_JPRB,0.13488E+01_JPRB,0.11500E+01_JPRB /)  
KB(:, 3,13,12) = (/ &
 & 0.95359E+00_JPRB,0.12308E+01_JPRB,0.13576E+01_JPRB,0.13588E+01_JPRB,0.11629E+01_JPRB /)  
KB(:, 4,13,12) = (/ &
 & 0.94644E+00_JPRB,0.12294E+01_JPRB,0.13618E+01_JPRB,0.13660E+01_JPRB,0.11761E+01_JPRB /)  
KB(:, 5,13,12) = (/ &
 & 0.94938E+00_JPRB,0.12277E+01_JPRB,0.13647E+01_JPRB,0.13713E+01_JPRB,0.11895E+01_JPRB /)  
KB(:, 1,14,12) = (/ &
 & 0.86287E+00_JPRB,0.11528E+01_JPRB,0.12800E+01_JPRB,0.12931E+01_JPRB,0.10793E+01_JPRB /)  
KB(:, 2,14,12) = (/ &
 & 0.85328E+00_JPRB,0.11519E+01_JPRB,0.12878E+01_JPRB,0.13082E+01_JPRB,0.10960E+01_JPRB /)  
KB(:, 3,14,12) = (/ &
 & 0.84776E+00_JPRB,0.11522E+01_JPRB,0.12944E+01_JPRB,0.13193E+01_JPRB,0.11122E+01_JPRB /)  
KB(:, 4,14,12) = (/ &
 & 0.85264E+00_JPRB,0.11532E+01_JPRB,0.12995E+01_JPRB,0.13287E+01_JPRB,0.11288E+01_JPRB /)  
KB(:, 5,14,12) = (/ &
 & 0.86761E+00_JPRB,0.11556E+01_JPRB,0.13039E+01_JPRB,0.13378E+01_JPRB,0.11458E+01_JPRB /)  
KB(:, 1,15,12) = (/ &
 & 0.75595E+00_JPRB,0.10736E+01_JPRB,0.12146E+01_JPRB,0.12437E+01_JPRB,0.10230E+01_JPRB /)  
KB(:, 2,15,12) = (/ &
 & 0.75063E+00_JPRB,0.10744E+01_JPRB,0.12248E+01_JPRB,0.12603E+01_JPRB,0.10430E+01_JPRB /)  
KB(:, 3,15,12) = (/ &
 & 0.75594E+00_JPRB,0.10769E+01_JPRB,0.12334E+01_JPRB,0.12743E+01_JPRB,0.10635E+01_JPRB /)  
KB(:, 4,15,12) = (/ &
 & 0.77107E+00_JPRB,0.10807E+01_JPRB,0.12402E+01_JPRB,0.12881E+01_JPRB,0.10841E+01_JPRB /)  
KB(:, 5,15,12) = (/ &
 & 0.79469E+00_JPRB,0.10902E+01_JPRB,0.12461E+01_JPRB,0.13012E+01_JPRB,0.11031E+01_JPRB /)  
KB(:, 1,16,12) = (/ &
 & 0.66063E+00_JPRB,0.99640E+00_JPRB,0.11502E+01_JPRB,0.11902E+01_JPRB,0.96912E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART29',1,ZHOOK_HANDLE)
END SUBROUTINE PART29


SUBROUTINE PART30

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART30',0,ZHOOK_HANDLE)


KB(:, 2,16,12) = (/ &
 & 0.66454E+00_JPRB,0.10001E+01_JPRB,0.11634E+01_JPRB,0.12095E+01_JPRB,0.99257E+00_JPRB /)  
KB(:, 3,16,12) = (/ &
 & 0.67895E+00_JPRB,0.10049E+01_JPRB,0.11739E+01_JPRB,0.12282E+01_JPRB,0.10170E+01_JPRB /)  
KB(:, 4,16,12) = (/ &
 & 0.70145E+00_JPRB,0.10153E+01_JPRB,0.11833E+01_JPRB,0.12469E+01_JPRB,0.10404E+01_JPRB /)  
KB(:, 5,16,12) = (/ &
 & 0.72525E+00_JPRB,0.10330E+01_JPRB,0.11925E+01_JPRB,0.12646E+01_JPRB,0.10610E+01_JPRB /)  
KB(:, 1,17,12) = (/ &
 & 0.58214E+00_JPRB,0.92297E+00_JPRB,0.10896E+01_JPRB,0.11346E+01_JPRB,0.91647E+00_JPRB /)  
KB(:, 2,17,12) = (/ &
 & 0.59400E+00_JPRB,0.92929E+00_JPRB,0.11045E+01_JPRB,0.11590E+01_JPRB,0.94550E+00_JPRB /)  
KB(:, 3,17,12) = (/ &
 & 0.61460E+00_JPRB,0.94000E+00_JPRB,0.11172E+01_JPRB,0.11832E+01_JPRB,0.97371E+00_JPRB /)  
KB(:, 4,17,12) = (/ &
 & 0.63691E+00_JPRB,0.95830E+00_JPRB,0.11303E+01_JPRB,0.12071E+01_JPRB,0.99891E+00_JPRB /)  
KB(:, 5,17,12) = (/ &
 & 0.66003E+00_JPRB,0.98295E+00_JPRB,0.11440E+01_JPRB,0.12298E+01_JPRB,0.10215E+01_JPRB /)  
KB(:, 1,18,12) = (/ &
 & 0.51831E+00_JPRB,0.85586E+00_JPRB,0.10313E+01_JPRB,0.10823E+01_JPRB,0.86734E+00_JPRB /)  
KB(:, 2,18,12) = (/ &
 & 0.53638E+00_JPRB,0.86645E+00_JPRB,0.10487E+01_JPRB,0.11114E+01_JPRB,0.90071E+00_JPRB /)  
KB(:, 3,18,12) = (/ &
 & 0.55679E+00_JPRB,0.88410E+00_JPRB,0.10657E+01_JPRB,0.11407E+01_JPRB,0.93149E+00_JPRB /)  
KB(:, 4,18,12) = (/ &
 & 0.57819E+00_JPRB,0.90902E+00_JPRB,0.10831E+01_JPRB,0.11693E+01_JPRB,0.95937E+00_JPRB /)  
KB(:, 5,18,12) = (/ &
 & 0.60387E+00_JPRB,0.94010E+00_JPRB,0.11032E+01_JPRB,0.11966E+01_JPRB,0.98550E+00_JPRB /)  
KB(:, 1,19,12) = (/ &
 & 0.46547E+00_JPRB,0.79533E+00_JPRB,0.97579E+00_JPRB,0.10353E+01_JPRB,0.82208E+00_JPRB /)  
KB(:, 2,19,12) = (/ &
 & 0.48441E+00_JPRB,0.81281E+00_JPRB,0.99768E+00_JPRB,0.10690E+01_JPRB,0.85858E+00_JPRB /)  
KB(:, 3,19,12) = (/ &
 & 0.50438E+00_JPRB,0.83723E+00_JPRB,0.10197E+01_JPRB,0.11027E+01_JPRB,0.89202E+00_JPRB /)  
KB(:, 4,19,12) = (/ &
 & 0.52861E+00_JPRB,0.86772E+00_JPRB,0.10433E+01_JPRB,0.11355E+01_JPRB,0.92298E+00_JPRB /)  
KB(:, 5,19,12) = (/ &
 & 0.55711E+00_JPRB,0.90301E+00_JPRB,0.10701E+01_JPRB,0.11672E+01_JPRB,0.95266E+00_JPRB /)  
KB(:, 1,20,12) = (/ &
 & 0.41965E+00_JPRB,0.74319E+00_JPRB,0.92508E+00_JPRB,0.99412E+00_JPRB,0.78089E+00_JPRB /)  
KB(:, 2,20,12) = (/ &
 & 0.43802E+00_JPRB,0.76766E+00_JPRB,0.95235E+00_JPRB,0.10327E+01_JPRB,0.82017E+00_JPRB /)  
KB(:, 3,20,12) = (/ &
 & 0.46025E+00_JPRB,0.79818E+00_JPRB,0.98022E+00_JPRB,0.10706E+01_JPRB,0.85677E+00_JPRB /)  
KB(:, 4,20,12) = (/ &
 & 0.48727E+00_JPRB,0.83370E+00_JPRB,0.10109E+01_JPRB,0.11072E+01_JPRB,0.89127E+00_JPRB /)  
KB(:, 5,20,12) = (/ &
 & 0.51863E+00_JPRB,0.87091E+00_JPRB,0.10440E+01_JPRB,0.11423E+01_JPRB,0.92433E+00_JPRB /)  
KB(:, 1,21,12) = (/ &
 & 0.37915E+00_JPRB,0.69998E+00_JPRB,0.88069E+00_JPRB,0.95835E+00_JPRB,0.74387E+00_JPRB /)  
KB(:, 2,21,12) = (/ &
 & 0.39885E+00_JPRB,0.72965E+00_JPRB,0.91291E+00_JPRB,0.10022E+01_JPRB,0.78645E+00_JPRB /)  
KB(:, 3,21,12) = (/ &
 & 0.42350E+00_JPRB,0.76561E+00_JPRB,0.94765E+00_JPRB,0.10443E+01_JPRB,0.82639E+00_JPRB /)  
KB(:, 4,21,12) = (/ &
 & 0.45298E+00_JPRB,0.80432E+00_JPRB,0.98473E+00_JPRB,0.10842E+01_JPRB,0.86477E+00_JPRB /)  
KB(:, 5,21,12) = (/ &
 & 0.48674E+00_JPRB,0.84344E+00_JPRB,0.10236E+01_JPRB,0.11221E+01_JPRB,0.90082E+00_JPRB /)  
KB(:, 1,22,12) = (/ &
 & 0.34554E+00_JPRB,0.66631E+00_JPRB,0.84565E+00_JPRB,0.93193E+00_JPRB,0.71462E+00_JPRB /)  
KB(:, 2,22,12) = (/ &
 & 0.36807E+00_JPRB,0.70096E+00_JPRB,0.88353E+00_JPRB,0.98021E+00_JPRB,0.76038E+00_JPRB /)  
KB(:, 3,22,12) = (/ &
 & 0.39520E+00_JPRB,0.74099E+00_JPRB,0.92460E+00_JPRB,0.10260E+01_JPRB,0.80381E+00_JPRB /)  
KB(:, 4,22,12) = (/ &
 & 0.42700E+00_JPRB,0.78213E+00_JPRB,0.96750E+00_JPRB,0.10688E+01_JPRB,0.84544E+00_JPRB /)  
KB(:, 5,22,12) = (/ &
 & 0.46306E+00_JPRB,0.82357E+00_JPRB,0.10116E+01_JPRB,0.11089E+01_JPRB,0.88444E+00_JPRB /)  
KB(:, 1,23,12) = (/ &
 & 0.31790E+00_JPRB,0.64007E+00_JPRB,0.81825E+00_JPRB,0.91240E+00_JPRB,0.69117E+00_JPRB /)  
KB(:, 2,23,12) = (/ &
 & 0.34313E+00_JPRB,0.67943E+00_JPRB,0.86200E+00_JPRB,0.96400E+00_JPRB,0.74026E+00_JPRB /)  
KB(:, 3,23,12) = (/ &
 & 0.37292E+00_JPRB,0.72179E+00_JPRB,0.90853E+00_JPRB,0.10128E+01_JPRB,0.78692E+00_JPRB /)  
KB(:, 4,23,12) = (/ &
 & 0.40683E+00_JPRB,0.76528E+00_JPRB,0.95638E+00_JPRB,0.10584E+01_JPRB,0.83132E+00_JPRB /)  
KB(:, 5,23,12) = (/ &
 & 0.44434E+00_JPRB,0.80906E+00_JPRB,0.10049E+01_JPRB,0.11007E+01_JPRB,0.87324E+00_JPRB /)  
KB(:, 1,24,12) = (/ &
 & 0.29587E+00_JPRB,0.62091E+00_JPRB,0.79898E+00_JPRB,0.89859E+00_JPRB,0.67383E+00_JPRB /)  
KB(:, 2,24,12) = (/ &
 & 0.32356E+00_JPRB,0.66370E+00_JPRB,0.84800E+00_JPRB,0.95354E+00_JPRB,0.72591E+00_JPRB /)  
KB(:, 3,24,12) = (/ &
 & 0.35587E+00_JPRB,0.70805E+00_JPRB,0.89882E+00_JPRB,0.10049E+01_JPRB,0.77551E+00_JPRB /)  
KB(:, 4,24,12) = (/ &
 & 0.39090E+00_JPRB,0.75345E+00_JPRB,0.95073E+00_JPRB,0.10524E+01_JPRB,0.82233E+00_JPRB /)  
KB(:, 5,24,12) = (/ &
 & 0.42938E+00_JPRB,0.80019E+00_JPRB,0.10026E+01_JPRB,0.10965E+01_JPRB,0.86634E+00_JPRB /)  
KB(:, 1,25,12) = (/ &
 & 0.27857E+00_JPRB,0.60799E+00_JPRB,0.78705E+00_JPRB,0.89081E+00_JPRB,0.66256E+00_JPRB /)  
KB(:, 2,25,12) = (/ &
 & 0.30889E+00_JPRB,0.65303E+00_JPRB,0.84032E+00_JPRB,0.94841E+00_JPRB,0.71733E+00_JPRB /)  
KB(:, 3,25,12) = (/ &
 & 0.34245E+00_JPRB,0.69924E+00_JPRB,0.89488E+00_JPRB,0.10015E+01_JPRB,0.76917E+00_JPRB /)  
KB(:, 4,25,12) = (/ &
 & 0.37871E+00_JPRB,0.74693E+00_JPRB,0.95015E+00_JPRB,0.10506E+01_JPRB,0.81807E+00_JPRB /)  
KB(:, 5,25,12) = (/ &
 & 0.41833E+00_JPRB,0.79644E+00_JPRB,0.10044E+01_JPRB,0.10958E+01_JPRB,0.86374E+00_JPRB /)  
KB(:, 1,26,12) = (/ &
 & 0.26580E+00_JPRB,0.60063E+00_JPRB,0.78228E+00_JPRB,0.88879E+00_JPRB,0.65720E+00_JPRB /)  
KB(:, 2,26,12) = (/ &
 & 0.29790E+00_JPRB,0.64759E+00_JPRB,0.83895E+00_JPRB,0.94821E+00_JPRB,0.71439E+00_JPRB /)  
KB(:, 3,26,12) = (/ &
 & 0.33261E+00_JPRB,0.69574E+00_JPRB,0.89642E+00_JPRB,0.10025E+01_JPRB,0.76782E+00_JPRB /)  
KB(:, 4,26,12) = (/ &
 & 0.37054E+00_JPRB,0.74591E+00_JPRB,0.95396E+00_JPRB,0.10524E+01_JPRB,0.81818E+00_JPRB /)  
KB(:, 5,26,12) = (/ &
 & 0.41158E+00_JPRB,0.79751E+00_JPRB,0.10099E+01_JPRB,0.10981E+01_JPRB,0.86507E+00_JPRB /)  
KB(:, 1,27,12) = (/ &
 & 0.25628E+00_JPRB,0.59727E+00_JPRB,0.78261E+00_JPRB,0.89115E+00_JPRB,0.65648E+00_JPRB /)  
KB(:, 2,27,12) = (/ &
 & 0.28973E+00_JPRB,0.64617E+00_JPRB,0.84187E+00_JPRB,0.95137E+00_JPRB,0.71531E+00_JPRB /)  
KB(:, 3,27,12) = (/ &
 & 0.32602E+00_JPRB,0.69640E+00_JPRB,0.90149E+00_JPRB,0.10062E+01_JPRB,0.76992E+00_JPRB /)  
KB(:, 4,27,12) = (/ &
 & 0.36566E+00_JPRB,0.74858E+00_JPRB,0.96067E+00_JPRB,0.10565E+01_JPRB,0.82130E+00_JPRB /)  
KB(:, 5,27,12) = (/ &
 & 0.40839E+00_JPRB,0.80160E+00_JPRB,0.10174E+01_JPRB,0.11025E+01_JPRB,0.86892E+00_JPRB /)  
KB(:, 1,28,12) = (/ &
 & 0.24931E+00_JPRB,0.59767E+00_JPRB,0.78703E+00_JPRB,0.89664E+00_JPRB,0.65970E+00_JPRB /)  
KB(:, 2,28,12) = (/ &
 & 0.28438E+00_JPRB,0.64828E+00_JPRB,0.84808E+00_JPRB,0.95711E+00_JPRB,0.71948E+00_JPRB /)  
KB(:, 3,28,12) = (/ &
 & 0.32259E+00_JPRB,0.70046E+00_JPRB,0.90930E+00_JPRB,0.10123E+01_JPRB,0.77494E+00_JPRB /)  
KB(:, 4,28,12) = (/ &
 & 0.36394E+00_JPRB,0.75423E+00_JPRB,0.96943E+00_JPRB,0.10625E+01_JPRB,0.82683E+00_JPRB /)  
KB(:, 5,28,12) = (/ &
 & 0.40857E+00_JPRB,0.80828E+00_JPRB,0.10265E+01_JPRB,0.11085E+01_JPRB,0.87457E+00_JPRB /)  
KB(:, 1,29,12) = (/ &
 & 0.24529E+00_JPRB,0.60153E+00_JPRB,0.79470E+00_JPRB,0.90469E+00_JPRB,0.66635E+00_JPRB /)  
KB(:, 2,29,12) = (/ &
 & 0.28215E+00_JPRB,0.65374E+00_JPRB,0.85707E+00_JPRB,0.96518E+00_JPRB,0.72659E+00_JPRB /)  
KB(:, 3,29,12) = (/ &
 & 0.32237E+00_JPRB,0.70744E+00_JPRB,0.91955E+00_JPRB,0.10202E+01_JPRB,0.78233E+00_JPRB /)  
KB(:, 4,29,12) = (/ &
 & 0.36548E+00_JPRB,0.76246E+00_JPRB,0.98006E+00_JPRB,0.10704E+01_JPRB,0.83435E+00_JPRB /)  
KB(:, 5,29,12) = (/ &
 & 0.41179E+00_JPRB,0.81715E+00_JPRB,0.10368E+01_JPRB,0.11160E+01_JPRB,0.88198E+00_JPRB /)  
KB(:, 1,30,12) = (/ &
 & 0.24386E+00_JPRB,0.60816E+00_JPRB,0.80473E+00_JPRB,0.91460E+00_JPRB,0.67543E+00_JPRB /)  
KB(:, 2,30,12) = (/ &
 & 0.28279E+00_JPRB,0.66165E+00_JPRB,0.86804E+00_JPRB,0.97470E+00_JPRB,0.73566E+00_JPRB /)  
KB(:, 3,30,12) = (/ &
 & 0.32483E+00_JPRB,0.71650E+00_JPRB,0.93115E+00_JPRB,0.10292E+01_JPRB,0.79124E+00_JPRB /)  
KB(:, 4,30,12) = (/ &
 & 0.36954E+00_JPRB,0.77208E+00_JPRB,0.99158E+00_JPRB,0.10790E+01_JPRB,0.84299E+00_JPRB /)  
KB(:, 5,30,12) = (/ &
 & 0.41749E+00_JPRB,0.82738E+00_JPRB,0.10478E+01_JPRB,0.11245E+01_JPRB,0.89039E+00_JPRB /)  
KB(:, 1,31,12) = (/ &
 & 0.24525E+00_JPRB,0.61702E+00_JPRB,0.81682E+00_JPRB,0.92621E+00_JPRB,0.68640E+00_JPRB /)  
KB(:, 2,31,12) = (/ &
 & 0.28616E+00_JPRB,0.67142E+00_JPRB,0.88072E+00_JPRB,0.98550E+00_JPRB,0.74643E+00_JPRB /)  
KB(:, 3,31,12) = (/ &
 & 0.32989E+00_JPRB,0.72710E+00_JPRB,0.94409E+00_JPRB,0.10393E+01_JPRB,0.80152E+00_JPRB /)  
KB(:, 4,31,12) = (/ &
 & 0.37609E+00_JPRB,0.78314E+00_JPRB,0.10041E+01_JPRB,0.10886E+01_JPRB,0.85269E+00_JPRB /)  
KB(:, 5,31,12) = (/ &
 & 0.42530E+00_JPRB,0.83896E+00_JPRB,0.10596E+01_JPRB,0.11338E+01_JPRB,0.89957E+00_JPRB /)  
KB(:, 1,32,12) = (/ &
 & 0.24917E+00_JPRB,0.62738E+00_JPRB,0.83018E+00_JPRB,0.93886E+00_JPRB,0.69870E+00_JPRB /)  
KB(:, 2,32,12) = (/ &
 & 0.29180E+00_JPRB,0.68257E+00_JPRB,0.89466E+00_JPRB,0.99723E+00_JPRB,0.75819E+00_JPRB /)  
KB(:, 3,32,12) = (/ &
 & 0.33695E+00_JPRB,0.73898E+00_JPRB,0.95783E+00_JPRB,0.10503E+01_JPRB,0.81270E+00_JPRB /)  
KB(:, 4,32,12) = (/ &
 & 0.38441E+00_JPRB,0.79527E+00_JPRB,0.10172E+01_JPRB,0.10987E+01_JPRB,0.86313E+00_JPRB /)  
KB(:, 5,32,12) = (/ &
 & 0.43473E+00_JPRB,0.85145E+00_JPRB,0.10718E+01_JPRB,0.11436E+01_JPRB,0.90933E+00_JPRB /)  
KB(:, 1,33,12) = (/ &
 & 0.25524E+00_JPRB,0.63888E+00_JPRB,0.84456E+00_JPRB,0.95208E+00_JPRB,0.71177E+00_JPRB /)  
KB(:, 2,33,12) = (/ &
 & 0.29923E+00_JPRB,0.69477E+00_JPRB,0.90943E+00_JPRB,0.10094E+01_JPRB,0.77043E+00_JPRB /)  
KB(:, 3,33,12) = (/ &
 & 0.34555E+00_JPRB,0.75166E+00_JPRB,0.97211E+00_JPRB,0.10616E+01_JPRB,0.82442E+00_JPRB /)  
KB(:, 4,33,12) = (/ &
 & 0.39409E+00_JPRB,0.80804E+00_JPRB,0.10306E+01_JPRB,0.11094E+01_JPRB,0.87396E+00_JPRB /)  
KB(:, 5,33,12) = (/ &
 & 0.44532E+00_JPRB,0.86454E+00_JPRB,0.10842E+01_JPRB,0.11536E+01_JPRB,0.91947E+00_JPRB /)  
KB(:, 1,34,12) = (/ &
 & 0.26139E+00_JPRB,0.64937E+00_JPRB,0.85738E+00_JPRB,0.96358E+00_JPRB,0.72330E+00_JPRB /)  
KB(:, 2,34,12) = (/ &
 & 0.30644E+00_JPRB,0.70578E+00_JPRB,0.92238E+00_JPRB,0.10200E+01_JPRB,0.78117E+00_JPRB /)  
KB(:, 3,34,12) = (/ &
 & 0.35368E+00_JPRB,0.76284E+00_JPRB,0.98445E+00_JPRB,0.10715E+01_JPRB,0.83457E+00_JPRB /)  
KB(:, 4,34,12) = (/ &
 & 0.40294E+00_JPRB,0.81944E+00_JPRB,0.10421E+01_JPRB,0.11185E+01_JPRB,0.88331E+00_JPRB /)  
KB(:, 5,34,12) = (/ &
 & 0.45497E+00_JPRB,0.87610E+00_JPRB,0.10949E+01_JPRB,0.11623E+01_JPRB,0.92821E+00_JPRB /)  
KB(:, 1,35,12) = (/ &
 & 0.26429E+00_JPRB,0.65495E+00_JPRB,0.86437E+00_JPRB,0.96967E+00_JPRB,0.72944E+00_JPRB /)  
KB(:, 2,35,12) = (/ &
 & 0.31003E+00_JPRB,0.71171E+00_JPRB,0.92940E+00_JPRB,0.10257E+01_JPRB,0.78687E+00_JPRB /)  
KB(:, 3,35,12) = (/ &
 & 0.35779E+00_JPRB,0.76892E+00_JPRB,0.99113E+00_JPRB,0.10767E+01_JPRB,0.83993E+00_JPRB /)  
KB(:, 4,35,12) = (/ &
 & 0.40757E+00_JPRB,0.82572E+00_JPRB,0.10483E+01_JPRB,0.11235E+01_JPRB,0.88834E+00_JPRB /)  
KB(:, 5,35,12) = (/ &
 & 0.46005E+00_JPRB,0.88243E+00_JPRB,0.11007E+01_JPRB,0.11671E+01_JPRB,0.93291E+00_JPRB /)  
KB(:, 1,36,12) = (/ &
 & 0.26301E+00_JPRB,0.65478E+00_JPRB,0.86458E+00_JPRB,0.96965E+00_JPRB,0.72937E+00_JPRB /)  
KB(:, 2,36,12) = (/ &
 & 0.30906E+00_JPRB,0.71167E+00_JPRB,0.92967E+00_JPRB,0.10257E+01_JPRB,0.78687E+00_JPRB /)  
KB(:, 3,36,12) = (/ &
 & 0.35709E+00_JPRB,0.76907E+00_JPRB,0.99151E+00_JPRB,0.10769E+01_JPRB,0.84005E+00_JPRB /)  
KB(:, 4,36,12) = (/ &
 & 0.40702E+00_JPRB,0.82602E+00_JPRB,0.10488E+01_JPRB,0.11238E+01_JPRB,0.88850E+00_JPRB /)  
KB(:, 5,36,12) = (/ &
 & 0.45966E+00_JPRB,0.88282E+00_JPRB,0.11012E+01_JPRB,0.11674E+01_JPRB,0.93315E+00_JPRB /)  
KB(:, 1,37,12) = (/ &
 & 0.25532E+00_JPRB,0.64621E+00_JPRB,0.85496E+00_JPRB,0.96073E+00_JPRB,0.72018E+00_JPRB /)  
KB(:, 2,37,12) = (/ &
 & 0.30133E+00_JPRB,0.70315E+00_JPRB,0.92046E+00_JPRB,0.10178E+01_JPRB,0.77861E+00_JPRB /)  
KB(:, 3,37,12) = (/ &
 & 0.34928E+00_JPRB,0.76070E+00_JPRB,0.98300E+00_JPRB,0.10697E+01_JPRB,0.83253E+00_JPRB /)  
KB(:, 4,37,12) = (/ &
 & 0.39901E+00_JPRB,0.81782E+00_JPRB,0.10410E+01_JPRB,0.11173E+01_JPRB,0.88173E+00_JPRB /)  
KB(:, 5,37,12) = (/ &
 & 0.45136E+00_JPRB,0.87470E+00_JPRB,0.10942E+01_JPRB,0.11614E+01_JPRB,0.92694E+00_JPRB /)  
KB(:, 1,38,12) = (/ &
 & 0.24761E+00_JPRB,0.63742E+00_JPRB,0.84491E+00_JPRB,0.95139E+00_JPRB,0.71066E+00_JPRB /)  
KB(:, 2,38,12) = (/ &
 & 0.29353E+00_JPRB,0.69428E+00_JPRB,0.91068E+00_JPRB,0.10095E+01_JPRB,0.76992E+00_JPRB /)  
KB(:, 3,38,12) = (/ &
 & 0.34135E+00_JPRB,0.75196E+00_JPRB,0.97396E+00_JPRB,0.10621E+01_JPRB,0.82461E+00_JPRB /)  
KB(:, 4,38,12) = (/ &
 & 0.39084E+00_JPRB,0.80925E+00_JPRB,0.10327E+01_JPRB,0.11104E+01_JPRB,0.87459E+00_JPRB /)  
KB(:, 5,38,12) = (/ &
 & 0.44289E+00_JPRB,0.86617E+00_JPRB,0.10866E+01_JPRB,0.11550E+01_JPRB,0.92038E+00_JPRB /)  
KB(:, 1,39,12) = (/ &
 & 0.24017E+00_JPRB,0.62886E+00_JPRB,0.83503E+00_JPRB,0.94210E+00_JPRB,0.70124E+00_JPRB /)  
KB(:, 2,39,12) = (/ &
 & 0.28601E+00_JPRB,0.68569E+00_JPRB,0.90106E+00_JPRB,0.10011E+01_JPRB,0.76142E+00_JPRB /)  
KB(:, 3,39,12) = (/ &
 & 0.33368E+00_JPRB,0.74335E+00_JPRB,0.96490E+00_JPRB,0.10546E+01_JPRB,0.81673E+00_JPRB /)  
KB(:, 4,39,12) = (/ &
 & 0.38296E+00_JPRB,0.80081E+00_JPRB,0.10243E+01_JPRB,0.11035E+01_JPRB,0.86747E+00_JPRB /)  
KB(:, 5,39,12) = (/ &
 & 0.43465E+00_JPRB,0.85778E+00_JPRB,0.10791E+01_JPRB,0.11488E+01_JPRB,0.91385E+00_JPRB /)  
KB(:, 1,40,12) = (/ &
 & 0.22833E+00_JPRB,0.61463E+00_JPRB,0.81821E+00_JPRB,0.92620E+00_JPRB,0.68530E+00_JPRB /)  
KB(:, 2,40,12) = (/ &
 & 0.27395E+00_JPRB,0.67134E+00_JPRB,0.88467E+00_JPRB,0.98686E+00_JPRB,0.74688E+00_JPRB /)  
KB(:, 3,40,12) = (/ &
 & 0.32124E+00_JPRB,0.72890E+00_JPRB,0.94943E+00_JPRB,0.10418E+01_JPRB,0.80324E+00_JPRB /)  
KB(:, 4,40,12) = (/ &
 & 0.37015E+00_JPRB,0.78652E+00_JPRB,0.10100E+01_JPRB,0.10918E+01_JPRB,0.85523E+00_JPRB /)  
KB(:, 5,40,12) = (/ &
 & 0.42126E+00_JPRB,0.84372E+00_JPRB,0.10660E+01_JPRB,0.11379E+01_JPRB,0.90264E+00_JPRB /)  
KB(:, 1,41,12) = (/ &
 & 0.21612E+00_JPRB,0.59971E+00_JPRB,0.80041E+00_JPRB,0.90904E+00_JPRB,0.66824E+00_JPRB /)  
KB(:, 2,41,12) = (/ &
 & 0.26150E+00_JPRB,0.65630E+00_JPRB,0.86743E+00_JPRB,0.97155E+00_JPRB,0.73120E+00_JPRB /)  
KB(:, 3,41,12) = (/ &
 & 0.30837E+00_JPRB,0.71376E+00_JPRB,0.93288E+00_JPRB,0.10279E+01_JPRB,0.78880E+00_JPRB /)  
KB(:, 4,41,12) = (/ &
 & 0.35698E+00_JPRB,0.77150E+00_JPRB,0.99473E+00_JPRB,0.10791E+01_JPRB,0.84209E+00_JPRB /)  
KB(:, 5,41,12) = (/ &
 & 0.40745E+00_JPRB,0.82887E+00_JPRB,0.10519E+01_JPRB,0.11261E+01_JPRB,0.89062E+00_JPRB /)  
KB(:, 1,42,12) = (/ &
 & 0.20417E+00_JPRB,0.58472E+00_JPRB,0.78237E+00_JPRB,0.89154E+00_JPRB,0.65066E+00_JPRB /)  
KB(:, 2,42,12) = (/ &
 & 0.24921E+00_JPRB,0.64136E+00_JPRB,0.85007E+00_JPRB,0.95580E+00_JPRB,0.71510E+00_JPRB /)  
KB(:, 3,42,12) = (/ &
 & 0.29566E+00_JPRB,0.69861E+00_JPRB,0.91611E+00_JPRB,0.10137E+01_JPRB,0.77414E+00_JPRB /)  
KB(:, 4,42,12) = (/ &
 & 0.34395E+00_JPRB,0.75651E+00_JPRB,0.97922E+00_JPRB,0.10662E+01_JPRB,0.82865E+00_JPRB /)  
KB(:, 5,42,12) = (/ &
 & 0.39383E+00_JPRB,0.81397E+00_JPRB,0.10376E+01_JPRB,0.11142E+01_JPRB,0.87842E+00_JPRB /)  
KB(:, 1,43,12) = (/ &
 & 0.18997E+00_JPRB,0.56647E+00_JPRB,0.76032E+00_JPRB,0.86976E+00_JPRB,0.62901E+00_JPRB /)  
KB(:, 2,43,12) = (/ &
 & 0.23447E+00_JPRB,0.62342E+00_JPRB,0.82892E+00_JPRB,0.93617E+00_JPRB,0.69524E+00_JPRB /)  
KB(:, 3,43,12) = (/ &
 & 0.28050E+00_JPRB,0.68037E+00_JPRB,0.89544E+00_JPRB,0.99597E+00_JPRB,0.75607E+00_JPRB /)  
KB(:, 4,43,12) = (/ &
 & 0.32830E+00_JPRB,0.73817E+00_JPRB,0.95981E+00_JPRB,0.10502E+01_JPRB,0.81194E+00_JPRB /)  
KB(:, 5,43,12) = (/ &
 & 0.37763E+00_JPRB,0.79580E+00_JPRB,0.10196E+01_JPRB,0.10995E+01_JPRB,0.86317E+00_JPRB /)  
KB(:, 1,44,12) = (/ &
 & 0.17494E+00_JPRB,0.54678E+00_JPRB,0.73637E+00_JPRB,0.84544E+00_JPRB,0.60542E+00_JPRB /)  
KB(:, 2,44,12) = (/ &
 & 0.21877E+00_JPRB,0.60406E+00_JPRB,0.80575E+00_JPRB,0.91415E+00_JPRB,0.67322E+00_JPRB /)  
KB(:, 3,44,12) = (/ &
 & 0.26445E+00_JPRB,0.66075E+00_JPRB,0.87287E+00_JPRB,0.97625E+00_JPRB,0.73598E+00_JPRB /)  
KB(:, 4,44,12) = (/ &
 & 0.31161E+00_JPRB,0.71841E+00_JPRB,0.93827E+00_JPRB,0.10322E+01_JPRB,0.79326E+00_JPRB /)  
KB(:, 5,44,12) = (/ &
 & 0.36052E+00_JPRB,0.77622E+00_JPRB,0.99972E+00_JPRB,0.10831E+01_JPRB,0.84620E+00_JPRB /)  
KB(:, 1,45,12) = (/ &
 & 0.16016E+00_JPRB,0.52729E+00_JPRB,0.71224E+00_JPRB,0.82038E+00_JPRB,0.58172E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART30',1,ZHOOK_HANDLE)
END SUBROUTINE PART30


SUBROUTINE PART31

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART31',0,ZHOOK_HANDLE)


KB(:, 2,45,12) = (/ &
 & 0.20336E+00_JPRB,0.58455E+00_JPRB,0.78227E+00_JPRB,0.89144E+00_JPRB,0.65050E+00_JPRB /)  
KB(:, 3,45,12) = (/ &
 & 0.24861E+00_JPRB,0.64128E+00_JPRB,0.85023E+00_JPRB,0.95584E+00_JPRB,0.71509E+00_JPRB /)  
KB(:, 4,45,12) = (/ &
 & 0.29518E+00_JPRB,0.69870E+00_JPRB,0.91640E+00_JPRB,0.10138E+01_JPRB,0.77417E+00_JPRB /)  
KB(:, 5,45,12) = (/ &
 & 0.34361E+00_JPRB,0.75661E+00_JPRB,0.97947E+00_JPRB,0.10663E+01_JPRB,0.82874E+00_JPRB /)  
KB(:, 1,46,12) = (/ &
 & 0.14495E+00_JPRB,0.50668E+00_JPRB,0.68614E+00_JPRB,0.79268E+00_JPRB,0.55619E+00_JPRB /)  
KB(:, 2,46,12) = (/ &
 & 0.18729E+00_JPRB,0.56366E+00_JPRB,0.75707E+00_JPRB,0.86650E+00_JPRB,0.62580E+00_JPRB /)  
KB(:, 3,46,12) = (/ &
 & 0.23189E+00_JPRB,0.62077E+00_JPRB,0.82600E+00_JPRB,0.93336E+00_JPRB,0.69232E+00_JPRB /)  
KB(:, 4,46,12) = (/ &
 & 0.27798E+00_JPRB,0.67784E+00_JPRB,0.89269E+00_JPRB,0.99345E+00_JPRB,0.75352E+00_JPRB /)  
KB(:, 5,46,12) = (/ &
 & 0.32583E+00_JPRB,0.73560E+00_JPRB,0.95715E+00_JPRB,0.10480E+01_JPRB,0.80957E+00_JPRB /)  
KB(:, 1,47,12) = (/ &
 & 0.12858E+00_JPRB,0.48369E+00_JPRB,0.65638E+00_JPRB,0.76017E+00_JPRB,0.52730E+00_JPRB /)  
KB(:, 2,47,12) = (/ &
 & 0.16969E+00_JPRB,0.54041E+00_JPRB,0.72859E+00_JPRB,0.83745E+00_JPRB,0.59783E+00_JPRB /)  
KB(:, 3,47,12) = (/ &
 & 0.21344E+00_JPRB,0.59783E+00_JPRB,0.79837E+00_JPRB,0.90704E+00_JPRB,0.66606E+00_JPRB /)  
KB(:, 4,47,12) = (/ &
 & 0.25910E+00_JPRB,0.65455E+00_JPRB,0.86586E+00_JPRB,0.96989E+00_JPRB,0.72949E+00_JPRB /)  
KB(:, 5,47,12) = (/ &
 & 0.30618E+00_JPRB,0.71222E+00_JPRB,0.93155E+00_JPRB,0.10265E+01_JPRB,0.78728E+00_JPRB /)  
KB(:, 1,48,12) = (/ &
 & 0.11298E+00_JPRB,0.46082E+00_JPRB,0.62642E+00_JPRB,0.72640E+00_JPRB,0.49809E+00_JPRB /)  
KB(:, 2,48,12) = (/ &
 & 0.15246E+00_JPRB,0.51740E+00_JPRB,0.69983E+00_JPRB,0.80735E+00_JPRB,0.56961E+00_JPRB /)  
KB(:, 3,48,12) = (/ &
 & 0.19539E+00_JPRB,0.57459E+00_JPRB,0.77041E+00_JPRB,0.87978E+00_JPRB,0.63885E+00_JPRB /)  
KB(:, 4,48,12) = (/ &
 & 0.24045E+00_JPRB,0.63157E+00_JPRB,0.83892E+00_JPRB,0.94534E+00_JPRB,0.70441E+00_JPRB /)  
KB(:, 5,48,12) = (/ &
 & 0.28683E+00_JPRB,0.68881E+00_JPRB,0.90534E+00_JPRB,0.10043E+01_JPRB,0.76449E+00_JPRB /)  
KB(:, 1,49,12) = (/ &
 & 0.98247E-01_JPRB,0.43787E+00_JPRB,0.59630E+00_JPRB,0.69142E+00_JPRB,0.46886E+00_JPRB /)  
KB(:, 2,49,12) = (/ &
 & 0.13602E+00_JPRB,0.49453E+00_JPRB,0.67051E+00_JPRB,0.77567E+00_JPRB,0.54098E+00_JPRB /)  
KB(:, 3,49,12) = (/ &
 & 0.17773E+00_JPRB,0.55136E+00_JPRB,0.74221E+00_JPRB,0.85142E+00_JPRB,0.61109E+00_JPRB /)  
KB(:, 4,49,12) = (/ &
 & 0.22196E+00_JPRB,0.60876E+00_JPRB,0.81162E+00_JPRB,0.91969E+00_JPRB,0.67863E+00_JPRB /)  
KB(:, 5,49,12) = (/ &
 & 0.26789E+00_JPRB,0.66564E+00_JPRB,0.87866E+00_JPRB,0.98128E+00_JPRB,0.74108E+00_JPRB /)  
KB(:, 1,50,12) = (/ &
 & 0.85448E-01_JPRB,0.41621E+00_JPRB,0.56763E+00_JPRB,0.65757E+00_JPRB,0.44117E+00_JPRB /)  
KB(:, 2,50,12) = (/ &
 & 0.12109E+00_JPRB,0.47310E+00_JPRB,0.64247E+00_JPRB,0.74462E+00_JPRB,0.51379E+00_JPRB /)  
KB(:, 3,50,12) = (/ &
 & 0.16156E+00_JPRB,0.52985E+00_JPRB,0.71554E+00_JPRB,0.82373E+00_JPRB,0.58488E+00_JPRB /)  
KB(:, 4,50,12) = (/ &
 & 0.20488E+00_JPRB,0.58711E+00_JPRB,0.78559E+00_JPRB,0.89468E+00_JPRB,0.65362E+00_JPRB /)  
KB(:, 5,50,12) = (/ &
 & 0.25037E+00_JPRB,0.64398E+00_JPRB,0.85353E+00_JPRB,0.95880E+00_JPRB,0.71804E+00_JPRB /)  
KB(:, 1,51,12) = (/ &
 & 0.73759E-01_JPRB,0.39485E+00_JPRB,0.53977E+00_JPRB,0.62407E+00_JPRB,0.41437E+00_JPRB /)  
KB(:, 2,51,12) = (/ &
 & 0.10727E+00_JPRB,0.45237E+00_JPRB,0.61531E+00_JPRB,0.71353E+00_JPRB,0.48727E+00_JPRB /)  
KB(:, 3,51,12) = (/ &
 & 0.14620E+00_JPRB,0.50899E+00_JPRB,0.68916E+00_JPRB,0.79586E+00_JPRB,0.55909E+00_JPRB /)  
KB(:, 4,51,12) = (/ &
 & 0.18867E+00_JPRB,0.56597E+00_JPRB,0.76009E+00_JPRB,0.86950E+00_JPRB,0.62868E+00_JPRB /)  
KB(:, 5,51,12) = (/ &
 & 0.23351E+00_JPRB,0.62321E+00_JPRB,0.82900E+00_JPRB,0.93613E+00_JPRB,0.69507E+00_JPRB /)  
KB(:, 1,52,12) = (/ &
 & 0.62975E-01_JPRB,0.37352E+00_JPRB,0.51168E+00_JPRB,0.59007E+00_JPRB,0.38790E+00_JPRB /)  
KB(:, 2,52,12) = (/ &
 & 0.94238E-01_JPRB,0.43155E+00_JPRB,0.58786E+00_JPRB,0.68153E+00_JPRB,0.46072E+00_JPRB /)  
KB(:, 3,52,12) = (/ &
 & 0.13138E+00_JPRB,0.48824E+00_JPRB,0.66233E+00_JPRB,0.76673E+00_JPRB,0.53305E+00_JPRB /)  
KB(:, 4,52,12) = (/ &
 & 0.17291E+00_JPRB,0.54507E+00_JPRB,0.73444E+00_JPRB,0.84335E+00_JPRB,0.60343E+00_JPRB /)  
KB(:, 5,52,12) = (/ &
 & 0.21681E+00_JPRB,0.60245E+00_JPRB,0.80402E+00_JPRB,0.91249E+00_JPRB,0.67147E+00_JPRB /)  
KB(:, 1,53,12) = (/ &
 & 0.53060E-01_JPRB,0.35230E+00_JPRB,0.48353E+00_JPRB,0.55561E+00_JPRB,0.36178E+00_JPRB /)  
KB(:, 2,53,12) = (/ &
 & 0.81984E-01_JPRB,0.41041E+00_JPRB,0.56005E+00_JPRB,0.64855E+00_JPRB,0.43393E+00_JPRB /)  
KB(:, 3,53,12) = (/ &
 & 0.11713E+00_JPRB,0.46754E+00_JPRB,0.63518E+00_JPRB,0.73640E+00_JPRB,0.50665E+00_JPRB /)  
KB(:, 4,53,12) = (/ &
 & 0.15723E+00_JPRB,0.52417E+00_JPRB,0.70847E+00_JPRB,0.81636E+00_JPRB,0.57800E+00_JPRB /)  
KB(:, 5,53,12) = (/ &
 & 0.20038E+00_JPRB,0.58144E+00_JPRB,0.77877E+00_JPRB,0.88807E+00_JPRB,0.64700E+00_JPRB /)  
KB(:, 1,54,12) = (/ &
 & 0.44825E-01_JPRB,0.33285E+00_JPRB,0.45764E+00_JPRB,0.52392E+00_JPRB,0.33821E+00_JPRB /)  
KB(:, 2,54,12) = (/ &
 & 0.71480E-01_JPRB,0.39083E+00_JPRB,0.53456E+00_JPRB,0.61778E+00_JPRB,0.40943E+00_JPRB /)  
KB(:, 3,54,12) = (/ &
 & 0.10463E+00_JPRB,0.44857E+00_JPRB,0.61031E+00_JPRB,0.70773E+00_JPRB,0.48234E+00_JPRB /)  
KB(:, 4,54,12) = (/ &
 & 0.14329E+00_JPRB,0.50511E+00_JPRB,0.68427E+00_JPRB,0.79060E+00_JPRB,0.55433E+00_JPRB /)  
KB(:, 5,54,12) = (/ &
 & 0.18561E+00_JPRB,0.56209E+00_JPRB,0.75543E+00_JPRB,0.86487E+00_JPRB,0.62409E+00_JPRB /)  
KB(:, 1,55,12) = (/ &
 & 0.37713E-01_JPRB,0.31417E+00_JPRB,0.43292E+00_JPRB,0.49354E+00_JPRB,0.31617E+00_JPRB /)  
KB(:, 2,55,12) = (/ &
 & 0.62120E-01_JPRB,0.37210E+00_JPRB,0.50985E+00_JPRB,0.58786E+00_JPRB,0.38623E+00_JPRB /)  
KB(:, 3,55,12) = (/ &
 & 0.93283E-01_JPRB,0.43021E+00_JPRB,0.58608E+00_JPRB,0.67950E+00_JPRB,0.45902E+00_JPRB /)  
KB(:, 4,55,12) = (/ &
 & 0.13035E+00_JPRB,0.48690E+00_JPRB,0.66064E+00_JPRB,0.76487E+00_JPRB,0.53142E+00_JPRB /)  
KB(:, 5,55,12) = (/ &
 & 0.17183E+00_JPRB,0.54374E+00_JPRB,0.73284E+00_JPRB,0.84168E+00_JPRB,0.60189E+00_JPRB /)  
KB(:, 1,56,12) = (/ &
 & 0.31364E-01_JPRB,0.29533E+00_JPRB,0.40826E+00_JPRB,0.46346E+00_JPRB,0.29456E+00_JPRB /)  
KB(:, 2,56,12) = (/ &
 & 0.53447E-01_JPRB,0.35352E+00_JPRB,0.48522E+00_JPRB,0.55771E+00_JPRB,0.36336E+00_JPRB /)  
KB(:, 3,56,12) = (/ &
 & 0.82579E-01_JPRB,0.41171E+00_JPRB,0.56173E+00_JPRB,0.65061E+00_JPRB,0.43556E+00_JPRB /)  
KB(:, 4,56,12) = (/ &
 & 0.11788E+00_JPRB,0.46877E+00_JPRB,0.63683E+00_JPRB,0.73828E+00_JPRB,0.50830E+00_JPRB /)  
KB(:, 5,56,12) = (/ &
 & 0.15810E+00_JPRB,0.52547E+00_JPRB,0.71011E+00_JPRB,0.81806E+00_JPRB,0.57961E+00_JPRB /)  
KB(:, 1,57,12) = (/ &
 & 0.25728E-01_JPRB,0.27641E+00_JPRB,0.38366E+00_JPRB,0.43364E+00_JPRB,0.27324E+00_JPRB /)  
KB(:, 2,57,12) = (/ &
 & 0.45538E-01_JPRB,0.33495E+00_JPRB,0.46047E+00_JPRB,0.52741E+00_JPRB,0.34078E+00_JPRB /)  
KB(:, 3,57,12) = (/ &
 & 0.72492E-01_JPRB,0.39302E+00_JPRB,0.53741E+00_JPRB,0.62128E+00_JPRB,0.41216E+00_JPRB /)  
KB(:, 4,57,12) = (/ &
 & 0.10590E+00_JPRB,0.45065E+00_JPRB,0.61311E+00_JPRB,0.71103E+00_JPRB,0.48510E+00_JPRB /)  
KB(:, 5,57,12) = (/ &
 & 0.14476E+00_JPRB,0.50725E+00_JPRB,0.68700E+00_JPRB,0.79354E+00_JPRB,0.55702E+00_JPRB /)  
KB(:, 1,58,12) = (/ &
 & 0.21034E-01_JPRB,0.25862E+00_JPRB,0.36035E+00_JPRB,0.40559E+00_JPRB,0.25327E+00_JPRB /)  
KB(:, 2,58,12) = (/ &
 & 0.38718E-01_JPRB,0.31732E+00_JPRB,0.43714E+00_JPRB,0.49876E+00_JPRB,0.31992E+00_JPRB /)  
KB(:, 3,58,12) = (/ &
 & 0.63552E-01_JPRB,0.37529E+00_JPRB,0.51407E+00_JPRB,0.59305E+00_JPRB,0.39018E+00_JPRB /)  
KB(:, 4,58,12) = (/ &
 & 0.95105E-01_JPRB,0.43334E+00_JPRB,0.59030E+00_JPRB,0.68443E+00_JPRB,0.46307E+00_JPRB /)  
KB(:, 5,58,12) = (/ &
 & 0.13248E+00_JPRB,0.49002E+00_JPRB,0.66471E+00_JPRB,0.76934E+00_JPRB,0.53538E+00_JPRB /)  
KB(:, 1,59,12) = (/ &
 & 0.19312E-01_JPRB,0.25156E+00_JPRB,0.35103E+00_JPRB,0.39450E+00_JPRB,0.24538E+00_JPRB /)  
KB(:, 2,59,12) = (/ &
 & 0.36163E-01_JPRB,0.31020E+00_JPRB,0.42773E+00_JPRB,0.48723E+00_JPRB,0.31163E+00_JPRB /)  
KB(:, 3,59,12) = (/ &
 & 0.60143E-01_JPRB,0.36820E+00_JPRB,0.50471E+00_JPRB,0.58164E+00_JPRB,0.38146E+00_JPRB /)  
KB(:, 4,59,12) = (/ &
 & 0.90924E-01_JPRB,0.42637E+00_JPRB,0.58105E+00_JPRB,0.67358E+00_JPRB,0.45417E+00_JPRB /)  
KB(:, 5,59,12) = (/ &
 & 0.12765E+00_JPRB,0.48313E+00_JPRB,0.65572E+00_JPRB,0.75941E+00_JPRB,0.52665E+00_JPRB /)  
KB(:, 1,13,13) = (/ &
 & 0.25702E+01_JPRB,0.27735E+01_JPRB,0.28760E+01_JPRB,0.25966E+01_JPRB,0.23968E+01_JPRB /)  
KB(:, 2,13,13) = (/ &
 & 0.25597E+01_JPRB,0.27776E+01_JPRB,0.28903E+01_JPRB,0.26158E+01_JPRB,0.24224E+01_JPRB /)  
KB(:, 3,13,13) = (/ &
 & 0.25494E+01_JPRB,0.27801E+01_JPRB,0.29040E+01_JPRB,0.26351E+01_JPRB,0.24494E+01_JPRB /)  
KB(:, 4,13,13) = (/ &
 & 0.25338E+01_JPRB,0.27802E+01_JPRB,0.29182E+01_JPRB,0.26543E+01_JPRB,0.24747E+01_JPRB /)  
KB(:, 5,13,13) = (/ &
 & 0.25177E+01_JPRB,0.27760E+01_JPRB,0.29320E+01_JPRB,0.26728E+01_JPRB,0.24963E+01_JPRB /)  
KB(:, 1,14,13) = (/ &
 & 0.23659E+01_JPRB,0.26936E+01_JPRB,0.28410E+01_JPRB,0.26130E+01_JPRB,0.23363E+01_JPRB /)  
KB(:, 2,14,13) = (/ &
 & 0.23577E+01_JPRB,0.27024E+01_JPRB,0.28615E+01_JPRB,0.26344E+01_JPRB,0.23684E+01_JPRB /)  
KB(:, 3,14,13) = (/ &
 & 0.23468E+01_JPRB,0.27102E+01_JPRB,0.28819E+01_JPRB,0.26565E+01_JPRB,0.24004E+01_JPRB /)  
KB(:, 4,14,13) = (/ &
 & 0.23350E+01_JPRB,0.27153E+01_JPRB,0.29051E+01_JPRB,0.26785E+01_JPRB,0.24267E+01_JPRB /)  
KB(:, 5,14,13) = (/ &
 & 0.23244E+01_JPRB,0.27141E+01_JPRB,0.29262E+01_JPRB,0.26967E+01_JPRB,0.24480E+01_JPRB /)  
KB(:, 1,15,13) = (/ &
 & 0.21606E+01_JPRB,0.25927E+01_JPRB,0.27805E+01_JPRB,0.26146E+01_JPRB,0.22773E+01_JPRB /)  
KB(:, 2,15,13) = (/ &
 & 0.21537E+01_JPRB,0.26084E+01_JPRB,0.28087E+01_JPRB,0.26417E+01_JPRB,0.23162E+01_JPRB /)  
KB(:, 3,15,13) = (/ &
 & 0.21448E+01_JPRB,0.26237E+01_JPRB,0.28408E+01_JPRB,0.26683E+01_JPRB,0.23515E+01_JPRB /)  
KB(:, 4,15,13) = (/ &
 & 0.21380E+01_JPRB,0.26327E+01_JPRB,0.28720E+01_JPRB,0.26931E+01_JPRB,0.23792E+01_JPRB /)  
KB(:, 5,15,13) = (/ &
 & 0.21347E+01_JPRB,0.26387E+01_JPRB,0.29018E+01_JPRB,0.27159E+01_JPRB,0.24036E+01_JPRB /)  
KB(:, 1,16,13) = (/ &
 & 0.19588E+01_JPRB,0.24824E+01_JPRB,0.27086E+01_JPRB,0.26036E+01_JPRB,0.22170E+01_JPRB /)  
KB(:, 2,16,13) = (/ &
 & 0.19544E+01_JPRB,0.25053E+01_JPRB,0.27466E+01_JPRB,0.26370E+01_JPRB,0.22638E+01_JPRB /)  
KB(:, 3,16,13) = (/ &
 & 0.19508E+01_JPRB,0.25256E+01_JPRB,0.27882E+01_JPRB,0.26694E+01_JPRB,0.23023E+01_JPRB /)  
KB(:, 4,16,13) = (/ &
 & 0.19522E+01_JPRB,0.25422E+01_JPRB,0.28288E+01_JPRB,0.26997E+01_JPRB,0.23338E+01_JPRB /)  
KB(:, 5,16,13) = (/ &
 & 0.19669E+01_JPRB,0.25568E+01_JPRB,0.28660E+01_JPRB,0.27268E+01_JPRB,0.23639E+01_JPRB /)  
KB(:, 1,17,13) = (/ &
 & 0.17683E+01_JPRB,0.23717E+01_JPRB,0.26296E+01_JPRB,0.25828E+01_JPRB,0.21586E+01_JPRB /)  
KB(:, 2,17,13) = (/ &
 & 0.17670E+01_JPRB,0.24002E+01_JPRB,0.26798E+01_JPRB,0.26243E+01_JPRB,0.22104E+01_JPRB /)  
KB(:, 3,17,13) = (/ &
 & 0.17705E+01_JPRB,0.24261E+01_JPRB,0.27313E+01_JPRB,0.26643E+01_JPRB,0.22525E+01_JPRB /)  
KB(:, 4,17,13) = (/ &
 & 0.17889E+01_JPRB,0.24495E+01_JPRB,0.27802E+01_JPRB,0.27001E+01_JPRB,0.22912E+01_JPRB /)  
KB(:, 5,17,13) = (/ &
 & 0.18206E+01_JPRB,0.24734E+01_JPRB,0.28261E+01_JPRB,0.27304E+01_JPRB,0.23278E+01_JPRB /)  
KB(:, 1,18,13) = (/ &
 & 0.15903E+01_JPRB,0.22606E+01_JPRB,0.25530E+01_JPRB,0.25561E+01_JPRB,0.21033E+01_JPRB /)  
KB(:, 2,18,13) = (/ &
 & 0.15961E+01_JPRB,0.22974E+01_JPRB,0.26139E+01_JPRB,0.26069E+01_JPRB,0.21585E+01_JPRB /)  
KB(:, 3,18,13) = (/ &
 & 0.16151E+01_JPRB,0.23303E+01_JPRB,0.26738E+01_JPRB,0.26546E+01_JPRB,0.22069E+01_JPRB /)  
KB(:, 4,18,13) = (/ &
 & 0.16495E+01_JPRB,0.23625E+01_JPRB,0.27316E+01_JPRB,0.26970E+01_JPRB,0.22532E+01_JPRB /)  
KB(:, 5,18,13) = (/ &
 & 0.16970E+01_JPRB,0.23957E+01_JPRB,0.27859E+01_JPRB,0.27320E+01_JPRB,0.22970E+01_JPRB /)  
KB(:, 1,19,13) = (/ &
 & 0.14257E+01_JPRB,0.21563E+01_JPRB,0.24826E+01_JPRB,0.25271E+01_JPRB,0.20500E+01_JPRB /)  
KB(:, 2,19,13) = (/ &
 & 0.14448E+01_JPRB,0.21999E+01_JPRB,0.25521E+01_JPRB,0.25882E+01_JPRB,0.21113E+01_JPRB /)  
KB(:, 3,19,13) = (/ &
 & 0.14809E+01_JPRB,0.22420E+01_JPRB,0.26202E+01_JPRB,0.26436E+01_JPRB,0.21676E+01_JPRB /)  
KB(:, 4,19,13) = (/ &
 & 0.15301E+01_JPRB,0.22839E+01_JPRB,0.26861E+01_JPRB,0.26918E+01_JPRB,0.22215E+01_JPRB /)  
KB(:, 5,19,13) = (/ &
 & 0.15917E+01_JPRB,0.23278E+01_JPRB,0.27486E+01_JPRB,0.27324E+01_JPRB,0.22720E+01_JPRB /)  
KB(:, 1,20,13) = (/ &
 & 0.12800E+01_JPRB,0.20626E+01_JPRB,0.24230E+01_JPRB,0.25008E+01_JPRB,0.20040E+01_JPRB /)  
KB(:, 2,20,13) = (/ &
 & 0.13152E+01_JPRB,0.21132E+01_JPRB,0.24996E+01_JPRB,0.25711E+01_JPRB,0.20725E+01_JPRB /)  
KB(:, 3,20,13) = (/ &
 & 0.13653E+01_JPRB,0.21643E+01_JPRB,0.25750E+01_JPRB,0.26341E+01_JPRB,0.21362E+01_JPRB /)  
KB(:, 4,20,13) = (/ &
 & 0.14290E+01_JPRB,0.22166E+01_JPRB,0.26493E+01_JPRB,0.26871E+01_JPRB,0.21969E+01_JPRB /)  
KB(:, 5,20,13) = (/ &
 & 0.15047E+01_JPRB,0.22739E+01_JPRB,0.27186E+01_JPRB,0.27332E+01_JPRB,0.22536E+01_JPRB /)  
KB(:, 1,21,13) = (/ &
 & 0.11565E+01_JPRB,0.19804E+01_JPRB,0.23723E+01_JPRB,0.24790E+01_JPRB,0.19652E+01_JPRB /)  
KB(:, 2,21,13) = (/ &
 & 0.12043E+01_JPRB,0.20401E+01_JPRB,0.24563E+01_JPRB,0.25572E+01_JPRB,0.20406E+01_JPRB /)  
KB(:, 3,21,13) = (/ &
 & 0.12682E+01_JPRB,0.20995E+01_JPRB,0.25386E+01_JPRB,0.26265E+01_JPRB,0.21117E+01_JPRB /)  
KB(:, 4,21,13) = (/ &
 & 0.13446E+01_JPRB,0.21634E+01_JPRB,0.26197E+01_JPRB,0.26846E+01_JPRB,0.21783E+01_JPRB /)  
KB(:, 5,21,13) = (/ &
 & 0.14328E+01_JPRB,0.22322E+01_JPRB,0.26943E+01_JPRB,0.27351E+01_JPRB,0.22400E+01_JPRB /)  
KB(:, 1,22,13) = (/ &
 & 0.10567E+01_JPRB,0.19161E+01_JPRB,0.23380E+01_JPRB,0.24675E+01_JPRB,0.19394E+01_JPRB /)  
KB(:, 2,22,13) = (/ &
 & 0.11171E+01_JPRB,0.19843E+01_JPRB,0.24279E+01_JPRB,0.25525E+01_JPRB,0.20217E+01_JPRB /)  
KB(:, 3,22,13) = (/ &
 & 0.11926E+01_JPRB,0.20529E+01_JPRB,0.25167E+01_JPRB,0.26264E+01_JPRB,0.20987E+01_JPRB /)  
KB(:, 4,22,13) = (/ &
 & 0.12819E+01_JPRB,0.21280E+01_JPRB,0.26028E+01_JPRB,0.26881E+01_JPRB,0.21696E+01_JPRB /)  
KB(:, 5,22,13) = (/ &
 & 0.13818E+01_JPRB,0.22069E+01_JPRB,0.26807E+01_JPRB,0.27417E+01_JPRB,0.22350E+01_JPRB /)  
KB(:, 1,23,13) = (/ &
 & 0.97722E+00_JPRB,0.18665E+01_JPRB,0.23140E+01_JPRB,0.24623E+01_JPRB,0.19226E+01_JPRB /)  
KB(:, 2,23,13) = (/ &
 & 0.10487E+01_JPRB,0.19424E+01_JPRB,0.24103E+01_JPRB,0.25530E+01_JPRB,0.20109E+01_JPRB /)  
KB(:, 3,23,13) = (/ &
 & 0.11351E+01_JPRB,0.20216E+01_JPRB,0.25035E+01_JPRB,0.26294E+01_JPRB,0.20926E+01_JPRB /)  
KB(:, 4,23,13) = (/ &
 & 0.12356E+01_JPRB,0.21056E+01_JPRB,0.25931E+01_JPRB,0.26937E+01_JPRB,0.21670E+01_JPRB /)  
KB(:, 5,23,13) = (/ &
 & 0.13470E+01_JPRB,0.21926E+01_JPRB,0.26734E+01_JPRB,0.27495E+01_JPRB,0.22345E+01_JPRB /)  
KB(:, 1,24,13) = (/ &
 & 0.91609E+00_JPRB,0.18302E+01_JPRB,0.23004E+01_JPRB,0.24641E+01_JPRB,0.19149E+01_JPRB /)  
KB(:, 2,24,13) = (/ &
 & 0.99757E+00_JPRB,0.19150E+01_JPRB,0.24014E+01_JPRB,0.25579E+01_JPRB,0.20076E+01_JPRB /)  
KB(:, 3,24,13) = (/ &
 & 0.10945E+01_JPRB,0.20031E+01_JPRB,0.24987E+01_JPRB,0.26360E+01_JPRB,0.20926E+01_JPRB /)  
KB(:, 4,24,13) = (/ &
 & 0.12058E+01_JPRB,0.20942E+01_JPRB,0.25896E+01_JPRB,0.27020E+01_JPRB,0.21691E+01_JPRB /)  
KB(:, 5,24,13) = (/ &
 & 0.13269E+01_JPRB,0.21869E+01_JPRB,0.26718E+01_JPRB,0.27594E+01_JPRB,0.22381E+01_JPRB /)  
KB(:, 1,25,13) = (/ &
 & 0.87183E+00_JPRB,0.18068E+01_JPRB,0.22964E+01_JPRB,0.24719E+01_JPRB,0.19153E+01_JPRB /)  
KB(:, 2,25,13) = (/ &
 & 0.96269E+00_JPRB,0.19004E+01_JPRB,0.24012E+01_JPRB,0.25669E+01_JPRB,0.20109E+01_JPRB /)  
KB(:, 3,25,13) = (/ &
 & 0.10701E+01_JPRB,0.19953E+01_JPRB,0.24998E+01_JPRB,0.26458E+01_JPRB,0.20980E+01_JPRB /)  
KB(:, 4,25,13) = (/ &
 & 0.11910E+01_JPRB,0.20919E+01_JPRB,0.25913E+01_JPRB,0.27126E+01_JPRB,0.21754E+01_JPRB /)  
KB(:, 5,25,13) = (/ &
 & 0.13188E+01_JPRB,0.21891E+01_JPRB,0.26749E+01_JPRB,0.27711E+01_JPRB,0.22449E+01_JPRB /)  
KB(:, 1,26,13) = (/ &
 & 0.84313E+00_JPRB,0.17965E+01_JPRB,0.23011E+01_JPRB,0.24858E+01_JPRB,0.19238E+01_JPRB /)  
KB(:, 2,26,13) = (/ &
 & 0.94434E+00_JPRB,0.18970E+01_JPRB,0.24073E+01_JPRB,0.25798E+01_JPRB,0.20205E+01_JPRB /)  
KB(:, 3,26,13) = (/ &
 & 0.10612E+01_JPRB,0.19972E+01_JPRB,0.25069E+01_JPRB,0.26589E+01_JPRB,0.21080E+01_JPRB /)  
KB(:, 4,26,13) = (/ &
 & 0.11887E+01_JPRB,0.20979E+01_JPRB,0.25988E+01_JPRB,0.27257E+01_JPRB,0.21853E+01_JPRB /)  
KB(:, 5,26,13) = (/ &
 & 0.13225E+01_JPRB,0.21985E+01_JPRB,0.26831E+01_JPRB,0.27841E+01_JPRB,0.22550E+01_JPRB /)  
KB(:, 1,27,13) = (/ &
 & 0.82783E+00_JPRB,0.17960E+01_JPRB,0.23110E+01_JPRB,0.25019E+01_JPRB,0.19363E+01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART31',1,ZHOOK_HANDLE)
END SUBROUTINE PART31


SUBROUTINE PART32

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART32',0,ZHOOK_HANDLE)


KB(:, 2,27,13) = (/ &
 & 0.93873E+00_JPRB,0.19014E+01_JPRB,0.24182E+01_JPRB,0.25950E+01_JPRB,0.20338E+01_JPRB /)  
KB(:, 3,27,13) = (/ &
 & 0.10628E+01_JPRB,0.20052E+01_JPRB,0.25176E+01_JPRB,0.26735E+01_JPRB,0.21206E+01_JPRB /)  
KB(:, 4,27,13) = (/ &
 & 0.11961E+01_JPRB,0.21092E+01_JPRB,0.26097E+01_JPRB,0.27398E+01_JPRB,0.21974E+01_JPRB /)  
KB(:, 5,27,13) = (/ &
 & 0.13342E+01_JPRB,0.22123E+01_JPRB,0.26944E+01_JPRB,0.27973E+01_JPRB,0.22665E+01_JPRB /)  
KB(:, 1,28,13) = (/ &
 & 0.82452E+00_JPRB,0.18027E+01_JPRB,0.23247E+01_JPRB,0.25200E+01_JPRB,0.19523E+01_JPRB /)  
KB(:, 2,28,13) = (/ &
 & 0.94277E+00_JPRB,0.19121E+01_JPRB,0.24323E+01_JPRB,0.26114E+01_JPRB,0.20494E+01_JPRB /)  
KB(:, 3,28,13) = (/ &
 & 0.10725E+01_JPRB,0.20183E+01_JPRB,0.25313E+01_JPRB,0.26888E+01_JPRB,0.21352E+01_JPRB /)  
KB(:, 4,28,13) = (/ &
 & 0.12107E+01_JPRB,0.21244E+01_JPRB,0.26233E+01_JPRB,0.27544E+01_JPRB,0.22110E+01_JPRB /)  
KB(:, 5,28,13) = (/ &
 & 0.13516E+01_JPRB,0.22292E+01_JPRB,0.27078E+01_JPRB,0.28106E+01_JPRB,0.22794E+01_JPRB /)  
KB(:, 1,29,13) = (/ &
 & 0.83075E+00_JPRB,0.18160E+01_JPRB,0.23425E+01_JPRB,0.25401E+01_JPRB,0.19712E+01_JPRB /)  
KB(:, 2,29,13) = (/ &
 & 0.95513E+00_JPRB,0.19278E+01_JPRB,0.24494E+01_JPRB,0.26294E+01_JPRB,0.20669E+01_JPRB /)  
KB(:, 3,29,13) = (/ &
 & 0.10900E+01_JPRB,0.20358E+01_JPRB,0.25478E+01_JPRB,0.27053E+01_JPRB,0.21513E+01_JPRB /)  
KB(:, 4,29,13) = (/ &
 & 0.12315E+01_JPRB,0.21431E+01_JPRB,0.26391E+01_JPRB,0.27692E+01_JPRB,0.22259E+01_JPRB /)  
KB(:, 5,29,13) = (/ &
 & 0.13745E+01_JPRB,0.22488E+01_JPRB,0.27235E+01_JPRB,0.28240E+01_JPRB,0.22934E+01_JPRB /)  
KB(:, 1,30,13) = (/ &
 & 0.84416E+00_JPRB,0.18336E+01_JPRB,0.23624E+01_JPRB,0.25609E+01_JPRB,0.19916E+01_JPRB /)  
KB(:, 2,30,13) = (/ &
 & 0.97368E+00_JPRB,0.19464E+01_JPRB,0.24682E+01_JPRB,0.26481E+01_JPRB,0.20854E+01_JPRB /)  
KB(:, 3,30,13) = (/ &
 & 0.11126E+01_JPRB,0.20559E+01_JPRB,0.25658E+01_JPRB,0.27219E+01_JPRB,0.21680E+01_JPRB /)  
KB(:, 4,30,13) = (/ &
 & 0.12564E+01_JPRB,0.21643E+01_JPRB,0.26566E+01_JPRB,0.27840E+01_JPRB,0.22414E+01_JPRB /)  
KB(:, 5,30,13) = (/ &
 & 0.14008E+01_JPRB,0.22700E+01_JPRB,0.27405E+01_JPRB,0.28371E+01_JPRB,0.23076E+01_JPRB /)  
KB(:, 1,31,13) = (/ &
 & 0.86384E+00_JPRB,0.18548E+01_JPRB,0.23844E+01_JPRB,0.25824E+01_JPRB,0.20133E+01_JPRB /)  
KB(:, 2,31,13) = (/ &
 & 0.99753E+00_JPRB,0.19681E+01_JPRB,0.24888E+01_JPRB,0.26671E+01_JPRB,0.21046E+01_JPRB /)  
KB(:, 3,31,13) = (/ &
 & 0.11394E+01_JPRB,0.20787E+01_JPRB,0.25856E+01_JPRB,0.27387E+01_JPRB,0.21855E+01_JPRB /)  
KB(:, 4,31,13) = (/ &
 & 0.12850E+01_JPRB,0.21876E+01_JPRB,0.26758E+01_JPRB,0.27988E+01_JPRB,0.22577E+01_JPRB /)  
KB(:, 5,31,13) = (/ &
 & 0.14304E+01_JPRB,0.22931E+01_JPRB,0.27584E+01_JPRB,0.28498E+01_JPRB,0.23225E+01_JPRB /)  
KB(:, 1,32,13) = (/ &
 & 0.88808E+00_JPRB,0.18788E+01_JPRB,0.24078E+01_JPRB,0.26044E+01_JPRB,0.20359E+01_JPRB /)  
KB(:, 2,32,13) = (/ &
 & 0.10254E+01_JPRB,0.19921E+01_JPRB,0.25106E+01_JPRB,0.26862E+01_JPRB,0.21246E+01_JPRB /)  
KB(:, 3,32,13) = (/ &
 & 0.11696E+01_JPRB,0.21031E+01_JPRB,0.26064E+01_JPRB,0.27554E+01_JPRB,0.22034E+01_JPRB /)  
KB(:, 4,32,13) = (/ &
 & 0.13164E+01_JPRB,0.22122E+01_JPRB,0.26955E+01_JPRB,0.28135E+01_JPRB,0.22742E+01_JPRB /)  
KB(:, 5,32,13) = (/ &
 & 0.14621E+01_JPRB,0.23175E+01_JPRB,0.27772E+01_JPRB,0.28624E+01_JPRB,0.23376E+01_JPRB /)  
KB(:, 1,33,13) = (/ &
 & 0.91576E+00_JPRB,0.19044E+01_JPRB,0.24318E+01_JPRB,0.26262E+01_JPRB,0.20585E+01_JPRB /)  
KB(:, 2,33,13) = (/ &
 & 0.10563E+01_JPRB,0.20178E+01_JPRB,0.25332E+01_JPRB,0.27053E+01_JPRB,0.21448E+01_JPRB /)  
KB(:, 3,33,13) = (/ &
 & 0.12022E+01_JPRB,0.21286E+01_JPRB,0.26280E+01_JPRB,0.27719E+01_JPRB,0.22216E+01_JPRB /)  
KB(:, 4,33,13) = (/ &
 & 0.13498E+01_JPRB,0.22379E+01_JPRB,0.27158E+01_JPRB,0.28276E+01_JPRB,0.22909E+01_JPRB /)  
KB(:, 5,33,13) = (/ &
 & 0.14952E+01_JPRB,0.23427E+01_JPRB,0.27963E+01_JPRB,0.28748E+01_JPRB,0.23524E+01_JPRB /)  
KB(:, 1,34,13) = (/ &
 & 0.94113E+00_JPRB,0.19270E+01_JPRB,0.24527E+01_JPRB,0.26448E+01_JPRB,0.20775E+01_JPRB /)  
KB(:, 2,34,13) = (/ &
 & 0.10840E+01_JPRB,0.20405E+01_JPRB,0.25528E+01_JPRB,0.27213E+01_JPRB,0.21619E+01_JPRB /)  
KB(:, 3,34,13) = (/ &
 & 0.12311E+01_JPRB,0.21512E+01_JPRB,0.26466E+01_JPRB,0.27855E+01_JPRB,0.22370E+01_JPRB /)  
KB(:, 4,34,13) = (/ &
 & 0.13793E+01_JPRB,0.22602E+01_JPRB,0.27333E+01_JPRB,0.28395E+01_JPRB,0.23050E+01_JPRB /)  
KB(:, 5,34,13) = (/ &
 & 0.15242E+01_JPRB,0.23644E+01_JPRB,0.28128E+01_JPRB,0.28850E+01_JPRB,0.23650E+01_JPRB /)  
KB(:, 1,35,13) = (/ &
 & 0.95467E+00_JPRB,0.19391E+01_JPRB,0.24637E+01_JPRB,0.26549E+01_JPRB,0.20879E+01_JPRB /)  
KB(:, 2,35,13) = (/ &
 & 0.10989E+01_JPRB,0.20529E+01_JPRB,0.25635E+01_JPRB,0.27301E+01_JPRB,0.21712E+01_JPRB /)  
KB(:, 3,35,13) = (/ &
 & 0.12468E+01_JPRB,0.21638E+01_JPRB,0.26569E+01_JPRB,0.27931E+01_JPRB,0.22456E+01_JPRB /)  
KB(:, 4,35,13) = (/ &
 & 0.13953E+01_JPRB,0.22726E+01_JPRB,0.27430E+01_JPRB,0.28463E+01_JPRB,0.23128E+01_JPRB /)  
KB(:, 5,35,13) = (/ &
 & 0.15401E+01_JPRB,0.23764E+01_JPRB,0.28219E+01_JPRB,0.28908E+01_JPRB,0.23721E+01_JPRB /)  
KB(:, 1,36,13) = (/ &
 & 0.95401E+00_JPRB,0.19393E+01_JPRB,0.24641E+01_JPRB,0.26563E+01_JPRB,0.20890E+01_JPRB /)  
KB(:, 2,36,13) = (/ &
 & 0.10986E+01_JPRB,0.20534E+01_JPRB,0.25640E+01_JPRB,0.27314E+01_JPRB,0.21722E+01_JPRB /)  
KB(:, 3,36,13) = (/ &
 & 0.12470E+01_JPRB,0.21646E+01_JPRB,0.26577E+01_JPRB,0.27946E+01_JPRB,0.22466E+01_JPRB /)  
KB(:, 4,36,13) = (/ &
 & 0.13959E+01_JPRB,0.22738E+01_JPRB,0.27440E+01_JPRB,0.28477E+01_JPRB,0.23138E+01_JPRB /)  
KB(:, 5,36,13) = (/ &
 & 0.15410E+01_JPRB,0.23778E+01_JPRB,0.28230E+01_JPRB,0.28922E+01_JPRB,0.23732E+01_JPRB /)  
KB(:, 1,37,13) = (/ &
 & 0.93269E+00_JPRB,0.19221E+01_JPRB,0.24490E+01_JPRB,0.26452E+01_JPRB,0.20765E+01_JPRB /)  
KB(:, 2,37,13) = (/ &
 & 0.10767E+01_JPRB,0.20372E+01_JPRB,0.25499E+01_JPRB,0.27223E+01_JPRB,0.21614E+01_JPRB /)  
KB(:, 3,37,13) = (/ &
 & 0.12250E+01_JPRB,0.21490E+01_JPRB,0.26449E+01_JPRB,0.27873E+01_JPRB,0.22369E+01_JPRB /)  
KB(:, 4,37,13) = (/ &
 & 0.13744E+01_JPRB,0.22588E+01_JPRB,0.27324E+01_JPRB,0.28416E+01_JPRB,0.23053E+01_JPRB /)  
KB(:, 5,37,13) = (/ &
 & 0.15205E+01_JPRB,0.23639E+01_JPRB,0.28124E+01_JPRB,0.28871E+01_JPRB,0.23656E+01_JPRB /)  
KB(:, 1,38,13) = (/ &
 & 0.91080E+00_JPRB,0.19040E+01_JPRB,0.24332E+01_JPRB,0.26332E+01_JPRB,0.20631E+01_JPRB /)  
KB(:, 2,38,13) = (/ &
 & 0.10540E+01_JPRB,0.20201E+01_JPRB,0.25351E+01_JPRB,0.27123E+01_JPRB,0.21497E+01_JPRB /)  
KB(:, 3,38,13) = (/ &
 & 0.12022E+01_JPRB,0.21326E+01_JPRB,0.26310E+01_JPRB,0.27790E+01_JPRB,0.22264E+01_JPRB /)  
KB(:, 4,38,13) = (/ &
 & 0.13520E+01_JPRB,0.22432E+01_JPRB,0.27202E+01_JPRB,0.28347E+01_JPRB,0.22959E+01_JPRB /)  
KB(:, 5,38,13) = (/ &
 & 0.14989E+01_JPRB,0.23490E+01_JPRB,0.28012E+01_JPRB,0.28815E+01_JPRB,0.23575E+01_JPRB /)  
KB(:, 1,39,13) = (/ &
 & 0.88956E+00_JPRB,0.18861E+01_JPRB,0.24173E+01_JPRB,0.26207E+01_JPRB,0.20495E+01_JPRB /)  
KB(:, 2,39,13) = (/ &
 & 0.10319E+01_JPRB,0.20032E+01_JPRB,0.25205E+01_JPRB,0.27021E+01_JPRB,0.21379E+01_JPRB /)  
KB(:, 3,39,13) = (/ &
 & 0.11798E+01_JPRB,0.21163E+01_JPRB,0.26173E+01_JPRB,0.27704E+01_JPRB,0.22159E+01_JPRB /)  
KB(:, 4,39,13) = (/ &
 & 0.13298E+01_JPRB,0.22272E+01_JPRB,0.27078E+01_JPRB,0.28277E+01_JPRB,0.22865E+01_JPRB /)  
KB(:, 5,39,13) = (/ &
 & 0.14775E+01_JPRB,0.23341E+01_JPRB,0.27901E+01_JPRB,0.28757E+01_JPRB,0.23493E+01_JPRB /)  
KB(:, 1,40,13) = (/ &
 & 0.85494E+00_JPRB,0.18558E+01_JPRB,0.23904E+01_JPRB,0.25985E+01_JPRB,0.20255E+01_JPRB /)  
KB(:, 2,40,13) = (/ &
 & 0.99514E+00_JPRB,0.19745E+01_JPRB,0.24954E+01_JPRB,0.26836E+01_JPRB,0.21170E+01_JPRB /)  
KB(:, 3,40,13) = (/ &
 & 0.11424E+01_JPRB,0.20885E+01_JPRB,0.25938E+01_JPRB,0.27547E+01_JPRB,0.21975E+01_JPRB /)  
KB(:, 4,40,13) = (/ &
 & 0.12924E+01_JPRB,0.22001E+01_JPRB,0.26861E+01_JPRB,0.28148E+01_JPRB,0.22700E+01_JPRB /)  
KB(:, 5,40,13) = (/ &
 & 0.14413E+01_JPRB,0.23083E+01_JPRB,0.27705E+01_JPRB,0.28664E+01_JPRB,0.23349E+01_JPRB /)  
KB(:, 1,41,13) = (/ &
 & 0.81957E+00_JPRB,0.18237E+01_JPRB,0.23613E+01_JPRB,0.25741E+01_JPRB,0.19997E+01_JPRB /)  
KB(:, 2,41,13) = (/ &
 & 0.95728E+00_JPRB,0.19441E+01_JPRB,0.24688E+01_JPRB,0.26632E+01_JPRB,0.20945E+01_JPRB /)  
KB(:, 3,41,13) = (/ &
 & 0.11034E+01_JPRB,0.20591E+01_JPRB,0.25687E+01_JPRB,0.27378E+01_JPRB,0.21777E+01_JPRB /)  
KB(:, 4,41,13) = (/ &
 & 0.12530E+01_JPRB,0.21714E+01_JPRB,0.26630E+01_JPRB,0.28005E+01_JPRB,0.22519E+01_JPRB /)  
KB(:, 5,41,13) = (/ &
 & 0.14027E+01_JPRB,0.22807E+01_JPRB,0.27494E+01_JPRB,0.28533E+01_JPRB,0.23190E+01_JPRB /)  
KB(:, 1,42,13) = (/ &
 & 0.78503E+00_JPRB,0.17918E+01_JPRB,0.23317E+01_JPRB,0.25487E+01_JPRB,0.19734E+01_JPRB /)  
KB(:, 2,42,13) = (/ &
 & 0.92016E+00_JPRB,0.19132E+01_JPRB,0.24418E+01_JPRB,0.26418E+01_JPRB,0.20712E+01_JPRB /)  
KB(:, 3,42,13) = (/ &
 & 0.10646E+01_JPRB,0.20294E+01_JPRB,0.25432E+01_JPRB,0.27200E+01_JPRB,0.21575E+01_JPRB /)  
KB(:, 4,42,13) = (/ &
 & 0.12137E+01_JPRB,0.21426E+01_JPRB,0.26392E+01_JPRB,0.27859E+01_JPRB,0.22336E+01_JPRB /)  
KB(:, 5,42,13) = (/ &
 & 0.13639E+01_JPRB,0.22528E+01_JPRB,0.27279E+01_JPRB,0.28411E+01_JPRB,0.23026E+01_JPRB /)  
KB(:, 1,43,13) = (/ &
 & 0.74423E+00_JPRB,0.17527E+01_JPRB,0.22949E+01_JPRB,0.25159E+01_JPRB,0.19403E+01_JPRB /)  
KB(:, 2,43,13) = (/ &
 & 0.87589E+00_JPRB,0.18750E+01_JPRB,0.24080E+01_JPRB,0.26143E+01_JPRB,0.20417E+01_JPRB /)  
KB(:, 3,43,13) = (/ &
 & 0.10179E+01_JPRB,0.19932E+01_JPRB,0.25118E+01_JPRB,0.26972E+01_JPRB,0.21315E+01_JPRB /)  
KB(:, 4,43,13) = (/ &
 & 0.11661E+01_JPRB,0.21073E+01_JPRB,0.26096E+01_JPRB,0.27665E+01_JPRB,0.22105E+01_JPRB /)  
KB(:, 5,43,13) = (/ &
 & 0.13165E+01_JPRB,0.22185E+01_JPRB,0.27008E+01_JPRB,0.28247E+01_JPRB,0.22817E+01_JPRB /)  
KB(:, 1,44,13) = (/ &
 & 0.70183E+00_JPRB,0.17101E+01_JPRB,0.22539E+01_JPRB,0.24783E+01_JPRB,0.19029E+01_JPRB /)  
KB(:, 2,44,13) = (/ &
 & 0.82940E+00_JPRB,0.18334E+01_JPRB,0.23707E+01_JPRB,0.25829E+01_JPRB,0.20083E+01_JPRB /)  
KB(:, 3,44,13) = (/ &
 & 0.96829E+00_JPRB,0.19537E+01_JPRB,0.24774E+01_JPRB,0.26707E+01_JPRB,0.21022E+01_JPRB /)  
KB(:, 4,44,13) = (/ &
 & 0.11151E+01_JPRB,0.20687E+01_JPRB,0.25770E+01_JPRB,0.27443E+01_JPRB,0.21846E+01_JPRB /)  
KB(:, 5,44,13) = (/ &
 & 0.12651E+01_JPRB,0.21808E+01_JPRB,0.26707E+01_JPRB,0.28061E+01_JPRB,0.22584E+01_JPRB /)  
KB(:, 1,45,13) = (/ &
 & 0.66118E+00_JPRB,0.16676E+01_JPRB,0.22119E+01_JPRB,0.24384E+01_JPRB,0.18634E+01_JPRB /)  
KB(:, 2,45,13) = (/ &
 & 0.78445E+00_JPRB,0.17917E+01_JPRB,0.23321E+01_JPRB,0.25495E+01_JPRB,0.19739E+01_JPRB /)  
KB(:, 3,45,13) = (/ &
 & 0.91984E+00_JPRB,0.19133E+01_JPRB,0.24421E+01_JPRB,0.26427E+01_JPRB,0.20718E+01_JPRB /)  
KB(:, 4,45,13) = (/ &
 & 0.10646E+01_JPRB,0.20301E+01_JPRB,0.25439E+01_JPRB,0.27211E+01_JPRB,0.21582E+01_JPRB /)  
KB(:, 5,45,13) = (/ &
 & 0.12138E+01_JPRB,0.21430E+01_JPRB,0.26395E+01_JPRB,0.27867E+01_JPRB,0.22343E+01_JPRB /)  
KB(:, 1,46,13) = (/ &
 & 0.61933E+00_JPRB,0.16221E+01_JPRB,0.21659E+01_JPRB,0.23935E+01_JPRB,0.18196E+01_JPRB /)  
KB(:, 2,46,13) = (/ &
 & 0.73807E+00_JPRB,0.17470E+01_JPRB,0.22898E+01_JPRB,0.25118E+01_JPRB,0.19358E+01_JPRB /)  
KB(:, 3,46,13) = (/ &
 & 0.86934E+00_JPRB,0.18696E+01_JPRB,0.24034E+01_JPRB,0.26109E+01_JPRB,0.20379E+01_JPRB /)  
KB(:, 4,46,13) = (/ &
 & 0.10113E+01_JPRB,0.19884E+01_JPRB,0.25076E+01_JPRB,0.26946E+01_JPRB,0.21283E+01_JPRB /)  
KB(:, 5,46,13) = (/ &
 & 0.11593E+01_JPRB,0.21025E+01_JPRB,0.26055E+01_JPRB,0.27643E+01_JPRB,0.22076E+01_JPRB /)  
KB(:, 1,47,13) = (/ &
 & 0.57374E+00_JPRB,0.15709E+01_JPRB,0.21131E+01_JPRB,0.23400E+01_JPRB,0.17680E+01_JPRB /)  
KB(:, 2,47,13) = (/ &
 & 0.68838E+00_JPRB,0.16965E+01_JPRB,0.22409E+01_JPRB,0.24665E+01_JPRB,0.18907E+01_JPRB /)  
KB(:, 3,47,13) = (/ &
 & 0.81478E+00_JPRB,0.18201E+01_JPRB,0.23589E+01_JPRB,0.25731E+01_JPRB,0.19980E+01_JPRB /)  
KB(:, 4,47,13) = (/ &
 & 0.95278E+00_JPRB,0.19412E+01_JPRB,0.24665E+01_JPRB,0.26626E+01_JPRB,0.20931E+01_JPRB /)  
KB(:, 5,47,13) = (/ &
 & 0.10991E+01_JPRB,0.20567E+01_JPRB,0.25667E+01_JPRB,0.27376E+01_JPRB,0.21769E+01_JPRB /)  
KB(:, 1,48,13) = (/ &
 & 0.52946E+00_JPRB,0.15198E+01_JPRB,0.20592E+01_JPRB,0.22834E+01_JPRB,0.17136E+01_JPRB /)  
KB(:, 2,48,13) = (/ &
 & 0.64089E+00_JPRB,0.16459E+01_JPRB,0.21904E+01_JPRB,0.24180E+01_JPRB,0.18431E+01_JPRB /)  
KB(:, 3,48,13) = (/ &
 & 0.76211E+00_JPRB,0.17708E+01_JPRB,0.23126E+01_JPRB,0.25324E+01_JPRB,0.19565E+01_JPRB /)  
KB(:, 4,48,13) = (/ &
 & 0.89568E+00_JPRB,0.18928E+01_JPRB,0.24241E+01_JPRB,0.26284E+01_JPRB,0.20564E+01_JPRB /)  
KB(:, 5,48,13) = (/ &
 & 0.10393E+01_JPRB,0.20105E+01_JPRB,0.25268E+01_JPRB,0.27091E+01_JPRB,0.21445E+01_JPRB /)  
KB(:, 1,49,13) = (/ &
 & 0.48708E+00_JPRB,0.14681E+01_JPRB,0.20029E+01_JPRB,0.22232E+01_JPRB,0.16566E+01_JPRB /)  
KB(:, 2,49,13) = (/ &
 & 0.59510E+00_JPRB,0.15951E+01_JPRB,0.21382E+01_JPRB,0.23660E+01_JPRB,0.17928E+01_JPRB /)  
KB(:, 3,49,13) = (/ &
 & 0.71141E+00_JPRB,0.17205E+01_JPRB,0.22646E+01_JPRB,0.24889E+01_JPRB,0.19130E+01_JPRB /)  
KB(:, 4,49,13) = (/ &
 & 0.84034E+00_JPRB,0.18437E+01_JPRB,0.23804E+01_JPRB,0.25917E+01_JPRB,0.20174E+01_JPRB /)  
KB(:, 5,49,13) = (/ &
 & 0.98023E+00_JPRB,0.19637E+01_JPRB,0.24863E+01_JPRB,0.26785E+01_JPRB,0.21102E+01_JPRB /)  
KB(:, 1,50,13) = (/ &
 & 0.44946E+00_JPRB,0.14198E+01_JPRB,0.19480E+01_JPRB,0.21639E+01_JPRB,0.16005E+01_JPRB /)  
KB(:, 2,50,13) = (/ &
 & 0.55308E+00_JPRB,0.15472E+01_JPRB,0.20885E+01_JPRB,0.23146E+01_JPRB,0.17433E+01_JPRB /)  
KB(:, 3,50,13) = (/ &
 & 0.66640E+00_JPRB,0.16732E+01_JPRB,0.22179E+01_JPRB,0.24447E+01_JPRB,0.18693E+01_JPRB /)  
KB(:, 4,50,13) = (/ &
 & 0.79021E+00_JPRB,0.17975E+01_JPRB,0.23380E+01_JPRB,0.25550E+01_JPRB,0.19794E+01_JPRB /)  
KB(:, 5,50,13) = (/ &
 & 0.92626E+00_JPRB,0.19191E+01_JPRB,0.24474E+01_JPRB,0.26476E+01_JPRB,0.20768E+01_JPRB /)  
KB(:, 1,51,13) = (/ &
 & 0.41452E+00_JPRB,0.13727E+01_JPRB,0.18922E+01_JPRB,0.21038E+01_JPRB,0.15428E+01_JPRB /)  
KB(:, 2,51,13) = (/ &
 & 0.51362E+00_JPRB,0.15005E+01_JPRB,0.20385E+01_JPRB,0.22616E+01_JPRB,0.16930E+01_JPRB /)  
KB(:, 3,51,13) = (/ &
 & 0.62394E+00_JPRB,0.16272E+01_JPRB,0.21714E+01_JPRB,0.23993E+01_JPRB,0.18251E+01_JPRB /)  
KB(:, 4,51,13) = (/ &
 & 0.74304E+00_JPRB,0.17523E+01_JPRB,0.22953E+01_JPRB,0.25171E+01_JPRB,0.19410E+01_JPRB /)  
KB(:, 5,51,13) = (/ &
 & 0.87505E+00_JPRB,0.18748E+01_JPRB,0.24082E+01_JPRB,0.26155E+01_JPRB,0.20426E+01_JPRB /)  
KB(:, 1,52,13) = (/ &
 & 0.38121E+00_JPRB,0.13250E+01_JPRB,0.18350E+01_JPRB,0.20413E+01_JPRB,0.14822E+01_JPRB /)  
KB(:, 2,52,13) = (/ &
 & 0.47581E+00_JPRB,0.14538E+01_JPRB,0.19870E+01_JPRB,0.22062E+01_JPRB,0.16405E+01_JPRB /)  
KB(:, 3,52,13) = (/ &
 & 0.58258E+00_JPRB,0.15810E+01_JPRB,0.21239E+01_JPRB,0.23514E+01_JPRB,0.17789E+01_JPRB /)  
KB(:, 4,52,13) = (/ &
 & 0.69813E+00_JPRB,0.17065E+01_JPRB,0.22509E+01_JPRB,0.24762E+01_JPRB,0.19005E+01_JPRB /)  
KB(:, 5,52,13) = (/ &
 & 0.82543E+00_JPRB,0.18301E+01_JPRB,0.23683E+01_JPRB,0.25815E+01_JPRB,0.20067E+01_JPRB /)  
KB(:, 1,53,13) = (/ &
 & 0.34902E+00_JPRB,0.12769E+01_JPRB,0.17751E+01_JPRB,0.19762E+01_JPRB,0.14178E+01_JPRB /)  
KB(:, 2,53,13) = (/ &
 & 0.43953E+00_JPRB,0.14068E+01_JPRB,0.19332E+01_JPRB,0.21485E+01_JPRB,0.15854E+01_JPRB /)  
KB(:, 3,53,13) = (/ &
 & 0.54216E+00_JPRB,0.15348E+01_JPRB,0.20756E+01_JPRB,0.23010E+01_JPRB,0.17302E+01_JPRB /)  
KB(:, 4,53,13) = (/ &
 & 0.65469E+00_JPRB,0.16608E+01_JPRB,0.22054E+01_JPRB,0.24328E+01_JPRB,0.18578E+01_JPRB /)  
KB(:, 5,53,13) = (/ &
 & 0.77730E+00_JPRB,0.17854E+01_JPRB,0.23267E+01_JPRB,0.25453E+01_JPRB,0.19695E+01_JPRB /)  
KB(:, 1,54,13) = (/ &
 & 0.32058E+00_JPRB,0.12324E+01_JPRB,0.17175E+01_JPRB,0.19140E+01_JPRB,0.13553E+01_JPRB /)  
KB(:, 2,54,13) = (/ &
 & 0.40795E+00_JPRB,0.13637E+01_JPRB,0.18819E+01_JPRB,0.20929E+01_JPRB,0.15321E+01_JPRB /)  
KB(:, 3,54,13) = (/ &
 & 0.50645E+00_JPRB,0.14920E+01_JPRB,0.20295E+01_JPRB,0.22518E+01_JPRB,0.16837E+01_JPRB /)  
KB(:, 4,54,13) = (/ &
 & 0.61609E+00_JPRB,0.16187E+01_JPRB,0.21628E+01_JPRB,0.23909E+01_JPRB,0.18169E+01_JPRB /)  
KB(:, 5,54,13) = (/ &
 & 0.73448E+00_JPRB,0.17439E+01_JPRB,0.22873E+01_JPRB,0.25101E+01_JPRB,0.19340E+01_JPRB /)  
KB(:, 1,55,13) = (/ &
 & 0.29443E+00_JPRB,0.11892E+01_JPRB,0.16600E+01_JPRB,0.18513E+01_JPRB,0.12929E+01_JPRB /)  
KB(:, 2,55,13) = (/ &
 & 0.37883E+00_JPRB,0.13219E+01_JPRB,0.18314E+01_JPRB,0.20376E+01_JPRB,0.14784E+01_JPRB /)  
KB(:, 3,55,13) = (/ &
 & 0.47335E+00_JPRB,0.14508E+01_JPRB,0.19839E+01_JPRB,0.22027E+01_JPRB,0.16372E+01_JPRB /)  
KB(:, 4,55,13) = (/ &
 & 0.57989E+00_JPRB,0.15780E+01_JPRB,0.21210E+01_JPRB,0.23485E+01_JPRB,0.17761E+01_JPRB /)  
KB(:, 5,55,13) = (/ &
 & 0.69533E+00_JPRB,0.17037E+01_JPRB,0.22482E+01_JPRB,0.24738E+01_JPRB,0.18980E+01_JPRB /)  
KB(:, 1,56,13) = (/ &
 & 0.26936E+00_JPRB,0.11459E+01_JPRB,0.16007E+01_JPRB,0.17863E+01_JPRB,0.12289E+01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART32',1,ZHOOK_HANDLE)
END SUBROUTINE PART32


SUBROUTINE PART33

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART33',0,ZHOOK_HANDLE)


KB(:, 2,56,13) = (/ &
 & 0.35065E+00_JPRB,0.12797E+01_JPRB,0.17789E+01_JPRB,0.19807E+01_JPRB,0.14221E+01_JPRB /)  
KB(:, 3,56,13) = (/ &
 & 0.44158E+00_JPRB,0.14097E+01_JPRB,0.19368E+01_JPRB,0.21523E+01_JPRB,0.15891E+01_JPRB /)  
KB(:, 4,56,13) = (/ &
 & 0.54448E+00_JPRB,0.15375E+01_JPRB,0.20786E+01_JPRB,0.23043E+01_JPRB,0.17334E+01_JPRB /)  
KB(:, 5,56,13) = (/ &
 & 0.65732E+00_JPRB,0.16637E+01_JPRB,0.22084E+01_JPRB,0.24358E+01_JPRB,0.18606E+01_JPRB /)  
KB(:, 1,57,13) = (/ &
 & 0.24515E+00_JPRB,0.11022E+01_JPRB,0.15388E+01_JPRB,0.17186E+01_JPRB,0.11645E+01_JPRB /)  
KB(:, 2,57,13) = (/ &
 & 0.32341E+00_JPRB,0.12372E+01_JPRB,0.17241E+01_JPRB,0.19215E+01_JPRB,0.13626E+01_JPRB /)  
KB(:, 3,57,13) = (/ &
 & 0.41131E+00_JPRB,0.13686E+01_JPRB,0.18879E+01_JPRB,0.20994E+01_JPRB,0.15383E+01_JPRB /)  
KB(:, 4,57,13) = (/ &
 & 0.51026E+00_JPRB,0.14967E+01_JPRB,0.20347E+01_JPRB,0.22575E+01_JPRB,0.16892E+01_JPRB /)  
KB(:, 5,57,13) = (/ &
 & 0.62036E+00_JPRB,0.16234E+01_JPRB,0.21677E+01_JPRB,0.23959E+01_JPRB,0.18217E+01_JPRB /)  
KB(:, 1,58,13) = (/ &
 & 0.22298E+00_JPRB,0.10601E+01_JPRB,0.14788E+01_JPRB,0.16521E+01_JPRB,0.11024E+01_JPRB /)  
KB(:, 2,58,13) = (/ &
 & 0.29857E+00_JPRB,0.11965E+01_JPRB,0.16700E+01_JPRB,0.18625E+01_JPRB,0.13039E+01_JPRB /)  
KB(:, 3,58,13) = (/ &
 & 0.38366E+00_JPRB,0.13291E+01_JPRB,0.18404E+01_JPRB,0.20474E+01_JPRB,0.14880E+01_JPRB /)  
KB(:, 4,58,13) = (/ &
 & 0.47882E+00_JPRB,0.14579E+01_JPRB,0.19918E+01_JPRB,0.22114E+01_JPRB,0.16455E+01_JPRB /)  
KB(:, 5,58,13) = (/ &
 & 0.58601E+00_JPRB,0.15850E+01_JPRB,0.21282E+01_JPRB,0.23561E+01_JPRB,0.17833E+01_JPRB /)  
KB(:, 1,59,13) = (/ &
 & 0.21427E+00_JPRB,0.10429E+01_JPRB,0.14544E+01_JPRB,0.16247E+01_JPRB,0.10771E+01_JPRB /)  
KB(:, 2,59,13) = (/ &
 & 0.28885E+00_JPRB,0.11801E+01_JPRB,0.16480E+01_JPRB,0.18384E+01_JPRB,0.12798E+01_JPRB /)  
KB(:, 3,59,13) = (/ &
 & 0.37281E+00_JPRB,0.13132E+01_JPRB,0.18209E+01_JPRB,0.20260E+01_JPRB,0.14670E+01_JPRB /)  
KB(:, 4,59,13) = (/ &
 & 0.46652E+00_JPRB,0.14422E+01_JPRB,0.19743E+01_JPRB,0.21926E+01_JPRB,0.16276E+01_JPRB /)  
KB(:, 5,59,13) = (/ &
 & 0.57246E+00_JPRB,0.15697E+01_JPRB,0.21123E+01_JPRB,0.23397E+01_JPRB,0.17674E+01_JPRB /)  
KB(:, 1,13,14) = (/ &
 & 0.76467E+01_JPRB,0.66870E+01_JPRB,0.63502E+01_JPRB,0.61468E+01_JPRB,0.66906E+01_JPRB /)  
KB(:, 2,13,14) = (/ &
 & 0.76514E+01_JPRB,0.66716E+01_JPRB,0.63627E+01_JPRB,0.61942E+01_JPRB,0.67780E+01_JPRB /)  
KB(:, 3,13,14) = (/ &
 & 0.76475E+01_JPRB,0.66428E+01_JPRB,0.63628E+01_JPRB,0.62371E+01_JPRB,0.68460E+01_JPRB /)  
KB(:, 4,13,14) = (/ &
 & 0.76415E+01_JPRB,0.66083E+01_JPRB,0.63514E+01_JPRB,0.62630E+01_JPRB,0.69072E+01_JPRB /)  
KB(:, 5,13,14) = (/ &
 & 0.76283E+01_JPRB,0.65686E+01_JPRB,0.63330E+01_JPRB,0.62779E+01_JPRB,0.69614E+01_JPRB /)  
KB(:, 1,14,14) = (/ &
 & 0.77958E+01_JPRB,0.69779E+01_JPRB,0.66658E+01_JPRB,0.63591E+01_JPRB,0.67479E+01_JPRB /)  
KB(:, 2,14,14) = (/ &
 & 0.78014E+01_JPRB,0.69599E+01_JPRB,0.66792E+01_JPRB,0.64167E+01_JPRB,0.68357E+01_JPRB /)  
KB(:, 3,14,14) = (/ &
 & 0.78100E+01_JPRB,0.69314E+01_JPRB,0.66809E+01_JPRB,0.64627E+01_JPRB,0.69109E+01_JPRB /)  
KB(:, 4,14,14) = (/ &
 & 0.78098E+01_JPRB,0.68950E+01_JPRB,0.66685E+01_JPRB,0.64923E+01_JPRB,0.69838E+01_JPRB /)  
KB(:, 5,14,14) = (/ &
 & 0.77999E+01_JPRB,0.68585E+01_JPRB,0.66494E+01_JPRB,0.65137E+01_JPRB,0.70531E+01_JPRB /)  
KB(:, 1,15,14) = (/ &
 & 0.78397E+01_JPRB,0.72065E+01_JPRB,0.69626E+01_JPRB,0.65521E+01_JPRB,0.67717E+01_JPRB /)  
KB(:, 2,15,14) = (/ &
 & 0.78630E+01_JPRB,0.71900E+01_JPRB,0.69770E+01_JPRB,0.66166E+01_JPRB,0.68639E+01_JPRB /)  
KB(:, 3,15,14) = (/ &
 & 0.78829E+01_JPRB,0.71661E+01_JPRB,0.69761E+01_JPRB,0.66643E+01_JPRB,0.69508E+01_JPRB /)  
KB(:, 4,15,14) = (/ &
 & 0.78961E+01_JPRB,0.71374E+01_JPRB,0.69668E+01_JPRB,0.66987E+01_JPRB,0.70374E+01_JPRB /)  
KB(:, 5,15,14) = (/ &
 & 0.78984E+01_JPRB,0.71026E+01_JPRB,0.69440E+01_JPRB,0.67207E+01_JPRB,0.71207E+01_JPRB /)  
KB(:, 1,16,14) = (/ &
 & 0.77976E+01_JPRB,0.73768E+01_JPRB,0.72331E+01_JPRB,0.67309E+01_JPRB,0.67735E+01_JPRB /)  
KB(:, 2,16,14) = (/ &
 & 0.78456E+01_JPRB,0.73704E+01_JPRB,0.72485E+01_JPRB,0.67988E+01_JPRB,0.68801E+01_JPRB /)  
KB(:, 3,16,14) = (/ &
 & 0.78840E+01_JPRB,0.73590E+01_JPRB,0.72505E+01_JPRB,0.68482E+01_JPRB,0.69801E+01_JPRB /)  
KB(:, 4,16,14) = (/ &
 & 0.79146E+01_JPRB,0.73379E+01_JPRB,0.72385E+01_JPRB,0.68847E+01_JPRB,0.70795E+01_JPRB /)  
KB(:, 5,16,14) = (/ &
 & 0.79322E+01_JPRB,0.73060E+01_JPRB,0.72179E+01_JPRB,0.69099E+01_JPRB,0.71779E+01_JPRB /)  
KB(:, 1,17,14) = (/ &
 & 0.76851E+01_JPRB,0.74978E+01_JPRB,0.74681E+01_JPRB,0.68923E+01_JPRB,0.67646E+01_JPRB /)  
KB(:, 2,17,14) = (/ &
 & 0.77622E+01_JPRB,0.75112E+01_JPRB,0.74909E+01_JPRB,0.69618E+01_JPRB,0.68880E+01_JPRB /)  
KB(:, 3,17,14) = (/ &
 & 0.78293E+01_JPRB,0.75089E+01_JPRB,0.74964E+01_JPRB,0.70134E+01_JPRB,0.70063E+01_JPRB /)  
KB(:, 4,17,14) = (/ &
 & 0.78832E+01_JPRB,0.75014E+01_JPRB,0.74883E+01_JPRB,0.70540E+01_JPRB,0.71204E+01_JPRB /)  
KB(:, 5,17,14) = (/ &
 & 0.79237E+01_JPRB,0.74752E+01_JPRB,0.74629E+01_JPRB,0.70833E+01_JPRB,0.72311E+01_JPRB /)  
KB(:, 1,18,14) = (/ &
 & 0.75343E+01_JPRB,0.75844E+01_JPRB,0.76679E+01_JPRB,0.70369E+01_JPRB,0.67530E+01_JPRB /)  
KB(:, 2,18,14) = (/ &
 & 0.76372E+01_JPRB,0.76127E+01_JPRB,0.76999E+01_JPRB,0.71100E+01_JPRB,0.68939E+01_JPRB /)  
KB(:, 3,18,14) = (/ &
 & 0.77344E+01_JPRB,0.76293E+01_JPRB,0.77123E+01_JPRB,0.71649E+01_JPRB,0.70305E+01_JPRB /)  
KB(:, 4,18,14) = (/ &
 & 0.78168E+01_JPRB,0.76302E+01_JPRB,0.77077E+01_JPRB,0.72057E+01_JPRB,0.71594E+01_JPRB /)  
KB(:, 5,18,14) = (/ &
 & 0.78848E+01_JPRB,0.76120E+01_JPRB,0.76799E+01_JPRB,0.72369E+01_JPRB,0.72819E+01_JPRB /)  
KB(:, 1,19,14) = (/ &
 & 0.73642E+01_JPRB,0.76427E+01_JPRB,0.78392E+01_JPRB,0.71673E+01_JPRB,0.67426E+01_JPRB /)  
KB(:, 2,19,14) = (/ &
 & 0.75027E+01_JPRB,0.76890E+01_JPRB,0.78792E+01_JPRB,0.72411E+01_JPRB,0.69029E+01_JPRB /)  
KB(:, 3,19,14) = (/ &
 & 0.76261E+01_JPRB,0.77218E+01_JPRB,0.78995E+01_JPRB,0.72995E+01_JPRB,0.70551E+01_JPRB /)  
KB(:, 4,19,14) = (/ &
 & 0.77358E+01_JPRB,0.77317E+01_JPRB,0.78972E+01_JPRB,0.73431E+01_JPRB,0.71976E+01_JPRB /)  
KB(:, 5,19,14) = (/ &
 & 0.78306E+01_JPRB,0.77206E+01_JPRB,0.78669E+01_JPRB,0.73734E+01_JPRB,0.73288E+01_JPRB /)  
KB(:, 1,20,14) = (/ &
 & 0.71989E+01_JPRB,0.76856E+01_JPRB,0.79830E+01_JPRB,0.72835E+01_JPRB,0.67408E+01_JPRB /)  
KB(:, 2,20,14) = (/ &
 & 0.73691E+01_JPRB,0.77492E+01_JPRB,0.80344E+01_JPRB,0.73623E+01_JPRB,0.69200E+01_JPRB /)  
KB(:, 3,20,14) = (/ &
 & 0.75204E+01_JPRB,0.77952E+01_JPRB,0.80604E+01_JPRB,0.74206E+01_JPRB,0.70842E+01_JPRB /)  
KB(:, 4,20,14) = (/ &
 & 0.76560E+01_JPRB,0.78150E+01_JPRB,0.80567E+01_JPRB,0.74651E+01_JPRB,0.72381E+01_JPRB /)  
KB(:, 5,20,14) = (/ &
 & 0.77736E+01_JPRB,0.78108E+01_JPRB,0.80255E+01_JPRB,0.74944E+01_JPRB,0.73772E+01_JPRB /)  
KB(:, 1,21,14) = (/ &
 & 0.70426E+01_JPRB,0.77166E+01_JPRB,0.81049E+01_JPRB,0.73883E+01_JPRB,0.67480E+01_JPRB /)  
KB(:, 2,21,14) = (/ &
 & 0.72474E+01_JPRB,0.77946E+01_JPRB,0.81668E+01_JPRB,0.74708E+01_JPRB,0.69410E+01_JPRB /)  
KB(:, 3,21,14) = (/ &
 & 0.74271E+01_JPRB,0.78518E+01_JPRB,0.81976E+01_JPRB,0.75283E+01_JPRB,0.71153E+01_JPRB /)  
KB(:, 4,21,14) = (/ &
 & 0.75881E+01_JPRB,0.78806E+01_JPRB,0.81926E+01_JPRB,0.75722E+01_JPRB,0.72765E+01_JPRB /)  
KB(:, 5,21,14) = (/ &
 & 0.77244E+01_JPRB,0.78840E+01_JPRB,0.81605E+01_JPRB,0.76005E+01_JPRB,0.74219E+01_JPRB /)  
KB(:, 1,22,14) = (/ &
 & 0.69208E+01_JPRB,0.77467E+01_JPRB,0.82134E+01_JPRB,0.74892E+01_JPRB,0.67760E+01_JPRB /)  
KB(:, 2,22,14) = (/ &
 & 0.71527E+01_JPRB,0.78380E+01_JPRB,0.82825E+01_JPRB,0.75703E+01_JPRB,0.69788E+01_JPRB /)  
KB(:, 3,22,14) = (/ &
 & 0.73591E+01_JPRB,0.79026E+01_JPRB,0.83138E+01_JPRB,0.76265E+01_JPRB,0.71614E+01_JPRB /)  
KB(:, 4,22,14) = (/ &
 & 0.75412E+01_JPRB,0.79369E+01_JPRB,0.83052E+01_JPRB,0.76676E+01_JPRB,0.73269E+01_JPRB /)  
KB(:, 5,22,14) = (/ &
 & 0.76931E+01_JPRB,0.79423E+01_JPRB,0.82705E+01_JPRB,0.76932E+01_JPRB,0.74734E+01_JPRB /)  
KB(:, 1,23,14) = (/ &
 & 0.68264E+01_JPRB,0.77768E+01_JPRB,0.83085E+01_JPRB,0.75813E+01_JPRB,0.68129E+01_JPRB /)  
KB(:, 2,23,14) = (/ &
 & 0.70814E+01_JPRB,0.78791E+01_JPRB,0.83807E+01_JPRB,0.76573E+01_JPRB,0.70223E+01_JPRB /)  
KB(:, 3,23,14) = (/ &
 & 0.73108E+01_JPRB,0.79473E+01_JPRB,0.84103E+01_JPRB,0.77115E+01_JPRB,0.72087E+01_JPRB /)  
KB(:, 4,23,14) = (/ &
 & 0.75083E+01_JPRB,0.79850E+01_JPRB,0.83989E+01_JPRB,0.77500E+01_JPRB,0.73762E+01_JPRB /)  
KB(:, 5,23,14) = (/ &
 & 0.76738E+01_JPRB,0.79912E+01_JPRB,0.83608E+01_JPRB,0.77715E+01_JPRB,0.75218E+01_JPRB /)  
KB(:, 1,24,14) = (/ &
 & 0.67597E+01_JPRB,0.78092E+01_JPRB,0.83929E+01_JPRB,0.76639E+01_JPRB,0.68571E+01_JPRB /)  
KB(:, 2,24,14) = (/ &
 & 0.70359E+01_JPRB,0.79159E+01_JPRB,0.84653E+01_JPRB,0.77347E+01_JPRB,0.70700E+01_JPRB /)  
KB(:, 3,24,14) = (/ &
 & 0.72818E+01_JPRB,0.79869E+01_JPRB,0.84905E+01_JPRB,0.77860E+01_JPRB,0.72578E+01_JPRB /)  
KB(:, 4,24,14) = (/ &
 & 0.74908E+01_JPRB,0.80269E+01_JPRB,0.84765E+01_JPRB,0.78202E+01_JPRB,0.74248E+01_JPRB /)  
KB(:, 5,24,14) = (/ &
 & 0.76673E+01_JPRB,0.80324E+01_JPRB,0.84337E+01_JPRB,0.78375E+01_JPRB,0.75690E+01_JPRB /)  
KB(:, 1,25,14) = (/ &
 & 0.67209E+01_JPRB,0.78436E+01_JPRB,0.84676E+01_JPRB,0.77356E+01_JPRB,0.69066E+01_JPRB /)  
KB(:, 2,25,14) = (/ &
 & 0.70147E+01_JPRB,0.79506E+01_JPRB,0.85366E+01_JPRB,0.78027E+01_JPRB,0.71216E+01_JPRB /)  
KB(:, 3,25,14) = (/ &
 & 0.72710E+01_JPRB,0.80222E+01_JPRB,0.85567E+01_JPRB,0.78495E+01_JPRB,0.73079E+01_JPRB /)  
KB(:, 4,25,14) = (/ &
 & 0.74891E+01_JPRB,0.80627E+01_JPRB,0.85388E+01_JPRB,0.78803E+01_JPRB,0.74736E+01_JPRB /)  
KB(:, 5,25,14) = (/ &
 & 0.76763E+01_JPRB,0.80663E+01_JPRB,0.84908E+01_JPRB,0.78920E+01_JPRB,0.76152E+01_JPRB /)  
KB(:, 1,26,14) = (/ &
 & 0.67117E+01_JPRB,0.78809E+01_JPRB,0.85346E+01_JPRB,0.77996E+01_JPRB,0.69621E+01_JPRB /)  
KB(:, 2,26,14) = (/ &
 & 0.70163E+01_JPRB,0.79848E+01_JPRB,0.85977E+01_JPRB,0.78624E+01_JPRB,0.71766E+01_JPRB /)  
KB(:, 3,26,14) = (/ &
 & 0.72800E+01_JPRB,0.80555E+01_JPRB,0.86111E+01_JPRB,0.79043E+01_JPRB,0.73612E+01_JPRB /)  
KB(:, 4,26,14) = (/ &
 & 0.75048E+01_JPRB,0.80927E+01_JPRB,0.85874E+01_JPRB,0.79312E+01_JPRB,0.75235E+01_JPRB /)  
KB(:, 5,26,14) = (/ &
 & 0.76969E+01_JPRB,0.80929E+01_JPRB,0.85318E+01_JPRB,0.79367E+01_JPRB,0.76615E+01_JPRB /)  
KB(:, 1,27,14) = (/ &
 & 0.67222E+01_JPRB,0.79165E+01_JPRB,0.85935E+01_JPRB,0.78553E+01_JPRB,0.70208E+01_JPRB /)  
KB(:, 2,27,14) = (/ &
 & 0.70339E+01_JPRB,0.80174E+01_JPRB,0.86486E+01_JPRB,0.79134E+01_JPRB,0.72318E+01_JPRB /)  
KB(:, 3,27,14) = (/ &
 & 0.73021E+01_JPRB,0.80859E+01_JPRB,0.86549E+01_JPRB,0.79502E+01_JPRB,0.74127E+01_JPRB /)  
KB(:, 4,27,14) = (/ &
 & 0.75298E+01_JPRB,0.81175E+01_JPRB,0.86239E+01_JPRB,0.79721E+01_JPRB,0.75702E+01_JPRB /)  
KB(:, 5,27,14) = (/ &
 & 0.77246E+01_JPRB,0.81143E+01_JPRB,0.85613E+01_JPRB,0.79734E+01_JPRB,0.77047E+01_JPRB /)  
KB(:, 1,28,14) = (/ &
 & 0.67490E+01_JPRB,0.79508E+01_JPRB,0.86448E+01_JPRB,0.79039E+01_JPRB,0.70793E+01_JPRB /)  
KB(:, 2,28,14) = (/ &
 & 0.70641E+01_JPRB,0.80481E+01_JPRB,0.86903E+01_JPRB,0.79567E+01_JPRB,0.72853E+01_JPRB /)  
KB(:, 3,28,14) = (/ &
 & 0.73339E+01_JPRB,0.81119E+01_JPRB,0.86890E+01_JPRB,0.79886E+01_JPRB,0.74622E+01_JPRB /)  
KB(:, 4,28,14) = (/ &
 & 0.75625E+01_JPRB,0.81383E+01_JPRB,0.86502E+01_JPRB,0.80049E+01_JPRB,0.76145E+01_JPRB /)  
KB(:, 5,28,14) = (/ &
 & 0.77567E+01_JPRB,0.81304E+01_JPRB,0.85806E+01_JPRB,0.80023E+01_JPRB,0.77455E+01_JPRB /)  
KB(:, 1,29,14) = (/ &
 & 0.67914E+01_JPRB,0.79845E+01_JPRB,0.86886E+01_JPRB,0.79462E+01_JPRB,0.71386E+01_JPRB /)  
KB(:, 2,29,14) = (/ &
 & 0.71068E+01_JPRB,0.80770E+01_JPRB,0.87239E+01_JPRB,0.79933E+01_JPRB,0.73389E+01_JPRB /)  
KB(:, 3,29,14) = (/ &
 & 0.73751E+01_JPRB,0.81344E+01_JPRB,0.87144E+01_JPRB,0.80208E+01_JPRB,0.75104E+01_JPRB /)  
KB(:, 4,29,14) = (/ &
 & 0.76020E+01_JPRB,0.81550E+01_JPRB,0.86676E+01_JPRB,0.80316E+01_JPRB,0.76575E+01_JPRB /)  
KB(:, 5,29,14) = (/ &
 & 0.77937E+01_JPRB,0.81425E+01_JPRB,0.85914E+01_JPRB,0.80248E+01_JPRB,0.77840E+01_JPRB /)  
KB(:, 1,30,14) = (/ &
 & 0.68445E+01_JPRB,0.80166E+01_JPRB,0.87256E+01_JPRB,0.79827E+01_JPRB,0.71970E+01_JPRB /)  
KB(:, 2,30,14) = (/ &
 & 0.71563E+01_JPRB,0.81037E+01_JPRB,0.87505E+01_JPRB,0.80234E+01_JPRB,0.73900E+01_JPRB /)  
KB(:, 3,30,14) = (/ &
 & 0.74214E+01_JPRB,0.81535E+01_JPRB,0.87321E+01_JPRB,0.80469E+01_JPRB,0.75564E+01_JPRB /)  
KB(:, 4,30,14) = (/ &
 & 0.76455E+01_JPRB,0.81683E+01_JPRB,0.86770E+01_JPRB,0.80524E+01_JPRB,0.76986E+01_JPRB /)  
KB(:, 5,30,14) = (/ &
 & 0.78317E+01_JPRB,0.81499E+01_JPRB,0.85949E+01_JPRB,0.80416E+01_JPRB,0.78203E+01_JPRB /)  
KB(:, 1,31,14) = (/ &
 & 0.69054E+01_JPRB,0.80478E+01_JPRB,0.87566E+01_JPRB,0.80136E+01_JPRB,0.72537E+01_JPRB /)  
KB(:, 2,31,14) = (/ &
 & 0.72125E+01_JPRB,0.81281E+01_JPRB,0.87710E+01_JPRB,0.80494E+01_JPRB,0.74404E+01_JPRB /)  
KB(:, 3,31,14) = (/ &
 & 0.74718E+01_JPRB,0.81700E+01_JPRB,0.87427E+01_JPRB,0.80677E+01_JPRB,0.76003E+01_JPRB /)  
KB(:, 4,31,14) = (/ &
 & 0.76912E+01_JPRB,0.81779E+01_JPRB,0.86791E+01_JPRB,0.80682E+01_JPRB,0.77384E+01_JPRB /)  
KB(:, 5,31,14) = (/ &
 & 0.78715E+01_JPRB,0.81532E+01_JPRB,0.85914E+01_JPRB,0.80538E+01_JPRB,0.78547E+01_JPRB /)  
KB(:, 1,32,14) = (/ &
 & 0.69718E+01_JPRB,0.80767E+01_JPRB,0.87812E+01_JPRB,0.80405E+01_JPRB,0.73093E+01_JPRB /)  
KB(:, 2,32,14) = (/ &
 & 0.72714E+01_JPRB,0.81493E+01_JPRB,0.87845E+01_JPRB,0.80705E+01_JPRB,0.74889E+01_JPRB /)  
KB(:, 3,32,14) = (/ &
 & 0.75255E+01_JPRB,0.81843E+01_JPRB,0.87476E+01_JPRB,0.80843E+01_JPRB,0.76427E+01_JPRB /)  
KB(:, 4,32,14) = (/ &
 & 0.77373E+01_JPRB,0.81836E+01_JPRB,0.86757E+01_JPRB,0.80798E+01_JPRB,0.77759E+01_JPRB /)  
KB(:, 5,32,14) = (/ &
 & 0.79115E+01_JPRB,0.81523E+01_JPRB,0.85821E+01_JPRB,0.80611E+01_JPRB,0.78870E+01_JPRB /)  
KB(:, 1,33,14) = (/ &
 & 0.70424E+01_JPRB,0.81041E+01_JPRB,0.88003E+01_JPRB,0.80631E+01_JPRB,0.73621E+01_JPRB /)  
KB(:, 2,33,14) = (/ &
 & 0.73332E+01_JPRB,0.81674E+01_JPRB,0.87934E+01_JPRB,0.80887E+01_JPRB,0.75359E+01_JPRB /)  
KB(:, 3,33,14) = (/ &
 & 0.75797E+01_JPRB,0.81949E+01_JPRB,0.87467E+01_JPRB,0.80962E+01_JPRB,0.76832E+01_JPRB /)  
KB(:, 4,33,14) = (/ &
 & 0.77832E+01_JPRB,0.81860E+01_JPRB,0.86679E+01_JPRB,0.80880E+01_JPRB,0.78112E+01_JPRB /)  
KB(:, 5,33,14) = (/ &
 & 0.79514E+01_JPRB,0.81480E+01_JPRB,0.85688E+01_JPRB,0.80650E+01_JPRB,0.79176E+01_JPRB /)  
KB(:, 1,34,14) = (/ &
 & 0.71032E+01_JPRB,0.81256E+01_JPRB,0.88135E+01_JPRB,0.80801E+01_JPRB,0.74073E+01_JPRB /)  
KB(:, 2,34,14) = (/ &
 & 0.73864E+01_JPRB,0.81812E+01_JPRB,0.87981E+01_JPRB,0.81025E+01_JPRB,0.75752E+01_JPRB /)  
KB(:, 3,34,14) = (/ &
 & 0.76257E+01_JPRB,0.82022E+01_JPRB,0.87428E+01_JPRB,0.81055E+01_JPRB,0.77177E+01_JPRB /)  
KB(:, 4,34,14) = (/ &
 & 0.78229E+01_JPRB,0.81866E+01_JPRB,0.86595E+01_JPRB,0.80934E+01_JPRB,0.78409E+01_JPRB /)  
KB(:, 5,34,14) = (/ &
 & 0.79841E+01_JPRB,0.81428E+01_JPRB,0.85553E+01_JPRB,0.80663E+01_JPRB,0.79427E+01_JPRB /)  
KB(:, 1,35,14) = (/ &
 & 0.71357E+01_JPRB,0.81386E+01_JPRB,0.88238E+01_JPRB,0.80923E+01_JPRB,0.74328E+01_JPRB /)  
KB(:, 2,35,14) = (/ &
 & 0.74155E+01_JPRB,0.81901E+01_JPRB,0.88028E+01_JPRB,0.81125E+01_JPRB,0.75980E+01_JPRB /)  
KB(:, 3,35,14) = (/ &
 & 0.76506E+01_JPRB,0.82068E+01_JPRB,0.87428E+01_JPRB,0.81128E+01_JPRB,0.77381E+01_JPRB /)  
KB(:, 4,35,14) = (/ &
 & 0.78446E+01_JPRB,0.81876E+01_JPRB,0.86563E+01_JPRB,0.80980E+01_JPRB,0.78583E+01_JPRB /)  
KB(:, 5,35,14) = (/ &
 & 0.80022E+01_JPRB,0.81408E+01_JPRB,0.85492E+01_JPRB,0.80683E+01_JPRB,0.79574E+01_JPRB /)  
KB(:, 1,36,14) = (/ &
 & 0.71358E+01_JPRB,0.81426E+01_JPRB,0.88312E+01_JPRB,0.80996E+01_JPRB,0.74385E+01_JPRB /)  
KB(:, 2,36,14) = (/ &
 & 0.74168E+01_JPRB,0.81942E+01_JPRB,0.88101E+01_JPRB,0.81195E+01_JPRB,0.76033E+01_JPRB /)  
KB(:, 3,36,14) = (/ &
 & 0.76530E+01_JPRB,0.82111E+01_JPRB,0.87491E+01_JPRB,0.81189E+01_JPRB,0.77431E+01_JPRB /)  
KB(:, 4,36,14) = (/ &
 & 0.78475E+01_JPRB,0.81916E+01_JPRB,0.86625E+01_JPRB,0.81041E+01_JPRB,0.78633E+01_JPRB /)  
KB(:, 5,36,14) = (/ &
 & 0.80053E+01_JPRB,0.81444E+01_JPRB,0.85549E+01_JPRB,0.80739E+01_JPRB,0.79624E+01_JPRB /)  
KB(:, 1,37,14) = (/ &
 & 0.70898E+01_JPRB,0.81353E+01_JPRB,0.88375E+01_JPRB,0.81022E+01_JPRB,0.74173E+01_JPRB /)  
KB(:, 2,37,14) = (/ &
 & 0.73792E+01_JPRB,0.81923E+01_JPRB,0.88220E+01_JPRB,0.81236E+01_JPRB,0.75852E+01_JPRB /)  
KB(:, 3,37,14) = (/ &
 & 0.76229E+01_JPRB,0.82146E+01_JPRB,0.87658E+01_JPRB,0.81255E+01_JPRB,0.77281E+01_JPRB /)  
KB(:, 4,37,14) = (/ &
 & 0.78232E+01_JPRB,0.81996E+01_JPRB,0.86818E+01_JPRB,0.81120E+01_JPRB,0.78508E+01_JPRB /)  
KB(:, 5,37,14) = (/ &
 & 0.79866E+01_JPRB,0.81554E+01_JPRB,0.85764E+01_JPRB,0.80843E+01_JPRB,0.79525E+01_JPRB /)  
KB(:, 1,38,14) = (/ &
 & 0.70419E+01_JPRB,0.81271E+01_JPRB,0.88418E+01_JPRB,0.81031E+01_JPRB,0.73933E+01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART33',1,ZHOOK_HANDLE)
END SUBROUTINE PART33


SUBROUTINE PART34

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART34',0,ZHOOK_HANDLE)


KB(:, 2,38,14) = (/ &
 & 0.73389E+01_JPRB,0.81889E+01_JPRB,0.88323E+01_JPRB,0.81261E+01_JPRB,0.75648E+01_JPRB /)  
KB(:, 3,38,14) = (/ &
 & 0.75899E+01_JPRB,0.82161E+01_JPRB,0.87808E+01_JPRB,0.81301E+01_JPRB,0.77105E+01_JPRB /)  
KB(:, 4,38,14) = (/ &
 & 0.77971E+01_JPRB,0.82068E+01_JPRB,0.87000E+01_JPRB,0.81195E+01_JPRB,0.78368E+01_JPRB /)  
KB(:, 5,38,14) = (/ &
 & 0.79663E+01_JPRB,0.81665E+01_JPRB,0.85976E+01_JPRB,0.80935E+01_JPRB,0.79412E+01_JPRB /)  
KB(:, 1,39,14) = (/ &
 & 0.69923E+01_JPRB,0.81165E+01_JPRB,0.88435E+01_JPRB,0.81024E+01_JPRB,0.73685E+01_JPRB /)  
KB(:, 2,39,14) = (/ &
 & 0.72982E+01_JPRB,0.81845E+01_JPRB,0.88409E+01_JPRB,0.81277E+01_JPRB,0.75441E+01_JPRB /)  
KB(:, 3,39,14) = (/ &
 & 0.75563E+01_JPRB,0.82164E+01_JPRB,0.87952E+01_JPRB,0.81347E+01_JPRB,0.76928E+01_JPRB /)  
KB(:, 4,39,14) = (/ &
 & 0.77695E+01_JPRB,0.82122E+01_JPRB,0.87165E+01_JPRB,0.81250E+01_JPRB,0.78216E+01_JPRB /)  
KB(:, 5,39,14) = (/ &
 & 0.79452E+01_JPRB,0.81762E+01_JPRB,0.86172E+01_JPRB,0.81015E+01_JPRB,0.79291E+01_JPRB /)  
KB(:, 1,40,14) = (/ &
 & 0.69080E+01_JPRB,0.80958E+01_JPRB,0.88413E+01_JPRB,0.80965E+01_JPRB,0.73229E+01_JPRB /)  
KB(:, 2,40,14) = (/ &
 & 0.72277E+01_JPRB,0.81734E+01_JPRB,0.88495E+01_JPRB,0.81259E+01_JPRB,0.75046E+01_JPRB /)  
KB(:, 3,40,14) = (/ &
 & 0.74967E+01_JPRB,0.82131E+01_JPRB,0.88131E+01_JPRB,0.81381E+01_JPRB,0.76600E+01_JPRB /)  
KB(:, 4,40,14) = (/ &
 & 0.77214E+01_JPRB,0.82184E+01_JPRB,0.87413E+01_JPRB,0.81320E+01_JPRB,0.77938E+01_JPRB /)  
KB(:, 5,40,14) = (/ &
 & 0.79055E+01_JPRB,0.81894E+01_JPRB,0.86471E+01_JPRB,0.81094E+01_JPRB,0.79066E+01_JPRB /)  
KB(:, 1,41,14) = (/ &
 & 0.68155E+01_JPRB,0.80708E+01_JPRB,0.88352E+01_JPRB,0.80885E+01_JPRB,0.72719E+01_JPRB /)  
KB(:, 2,41,14) = (/ &
 & 0.71495E+01_JPRB,0.81585E+01_JPRB,0.88545E+01_JPRB,0.81224E+01_JPRB,0.74618E+01_JPRB /)  
KB(:, 3,41,14) = (/ &
 & 0.74308E+01_JPRB,0.82074E+01_JPRB,0.88291E+01_JPRB,0.81392E+01_JPRB,0.76238E+01_JPRB /)  
KB(:, 4,41,14) = (/ &
 & 0.76675E+01_JPRB,0.82222E+01_JPRB,0.87650E+01_JPRB,0.81374E+01_JPRB,0.77629E+01_JPRB /)  
KB(:, 5,41,14) = (/ &
 & 0.78621E+01_JPRB,0.82014E+01_JPRB,0.86761E+01_JPRB,0.81197E+01_JPRB,0.78805E+01_JPRB /)  
KB(:, 1,42,14) = (/ &
 & 0.67210E+01_JPRB,0.80436E+01_JPRB,0.88257E+01_JPRB,0.80787E+01_JPRB,0.72181E+01_JPRB /)  
KB(:, 2,42,14) = (/ &
 & 0.70672E+01_JPRB,0.81413E+01_JPRB,0.88562E+01_JPRB,0.81177E+01_JPRB,0.74171E+01_JPRB /)  
KB(:, 3,42,14) = (/ &
 & 0.73618E+01_JPRB,0.81993E+01_JPRB,0.88420E+01_JPRB,0.81387E+01_JPRB,0.75853E+01_JPRB /)  
KB(:, 4,42,14) = (/ &
 & 0.76110E+01_JPRB,0.82240E+01_JPRB,0.87872E+01_JPRB,0.81416E+01_JPRB,0.77301E+01_JPRB /)  
KB(:, 5,42,14) = (/ &
 & 0.78157E+01_JPRB,0.82114E+01_JPRB,0.87034E+01_JPRB,0.81275E+01_JPRB,0.78533E+01_JPRB /)  
KB(:, 1,43,14) = (/ &
 & 0.66012E+01_JPRB,0.80077E+01_JPRB,0.88083E+01_JPRB,0.80639E+01_JPRB,0.71482E+01_JPRB /)  
KB(:, 2,43,14) = (/ &
 & 0.69627E+01_JPRB,0.81158E+01_JPRB,0.88532E+01_JPRB,0.81101E+01_JPRB,0.73596E+01_JPRB /)  
KB(:, 3,43,14) = (/ &
 & 0.72743E+01_JPRB,0.81862E+01_JPRB,0.88533E+01_JPRB,0.81352E+01_JPRB,0.75360E+01_JPRB /)  
KB(:, 4,43,14) = (/ &
 & 0.75376E+01_JPRB,0.82203E+01_JPRB,0.88101E+01_JPRB,0.81444E+01_JPRB,0.76876E+01_JPRB /)  
KB(:, 5,43,14) = (/ &
 & 0.77560E+01_JPRB,0.82200E+01_JPRB,0.87338E+01_JPRB,0.81353E+01_JPRB,0.78176E+01_JPRB /)  
KB(:, 1,44,14) = (/ &
 & 0.64654E+01_JPRB,0.79624E+01_JPRB,0.87841E+01_JPRB,0.80450E+01_JPRB,0.70696E+01_JPRB /)  
KB(:, 2,44,14) = (/ &
 & 0.68452E+01_JPRB,0.80842E+01_JPRB,0.88456E+01_JPRB,0.80985E+01_JPRB,0.72931E+01_JPRB /)  
KB(:, 3,44,14) = (/ &
 & 0.71736E+01_JPRB,0.81668E+01_JPRB,0.88594E+01_JPRB,0.81294E+01_JPRB,0.74799E+01_JPRB /)  
KB(:, 4,44,14) = (/ &
 & 0.74536E+01_JPRB,0.82135E+01_JPRB,0.88309E+01_JPRB,0.81455E+01_JPRB,0.76398E+01_JPRB /)  
KB(:, 5,44,14) = (/ &
 & 0.76864E+01_JPRB,0.82252E+01_JPRB,0.87641E+01_JPRB,0.81417E+01_JPRB,0.77771E+01_JPRB /)  
KB(:, 1,45,14) = (/ &
 & 0.63246E+01_JPRB,0.79121E+01_JPRB,0.87529E+01_JPRB,0.80227E+01_JPRB,0.69872E+01_JPRB /)  
KB(:, 2,45,14) = (/ &
 & 0.67215E+01_JPRB,0.80478E+01_JPRB,0.88314E+01_JPRB,0.80840E+01_JPRB,0.72219E+01_JPRB /)  
KB(:, 3,45,14) = (/ &
 & 0.70680E+01_JPRB,0.81447E+01_JPRB,0.88609E+01_JPRB,0.81218E+01_JPRB,0.74205E+01_JPRB /)  
KB(:, 4,45,14) = (/ &
 & 0.73633E+01_JPRB,0.82020E+01_JPRB,0.88464E+01_JPRB,0.81437E+01_JPRB,0.75896E+01_JPRB /)  
KB(:, 5,45,14) = (/ &
 & 0.76123E+01_JPRB,0.82264E+01_JPRB,0.87913E+01_JPRB,0.81458E+01_JPRB,0.77333E+01_JPRB /)  
KB(:, 1,46,14) = (/ &
 & 0.61677E+01_JPRB,0.78522E+01_JPRB,0.87120E+01_JPRB,0.79958E+01_JPRB,0.68962E+01_JPRB /)  
KB(:, 2,46,14) = (/ &
 & 0.65843E+01_JPRB,0.80056E+01_JPRB,0.88106E+01_JPRB,0.80659E+01_JPRB,0.71413E+01_JPRB /)  
KB(:, 3,46,14) = (/ &
 & 0.69482E+01_JPRB,0.81147E+01_JPRB,0.88565E+01_JPRB,0.81122E+01_JPRB,0.73539E+01_JPRB /)  
KB(:, 4,46,14) = (/ &
 & 0.72620E+01_JPRB,0.81857E+01_JPRB,0.88581E+01_JPRB,0.81382E+01_JPRB,0.75320E+01_JPRB /)  
KB(:, 5,46,14) = (/ &
 & 0.75285E+01_JPRB,0.82222E+01_JPRB,0.88171E+01_JPRB,0.81482E+01_JPRB,0.76841E+01_JPRB /)  
KB(:, 1,47,14) = (/ &
 & 0.59872E+01_JPRB,0.77759E+01_JPRB,0.86581E+01_JPRB,0.79599E+01_JPRB,0.67904E+01_JPRB /)  
KB(:, 2,47,14) = (/ &
 & 0.64227E+01_JPRB,0.79505E+01_JPRB,0.87794E+01_JPRB,0.80417E+01_JPRB,0.70463E+01_JPRB /)  
KB(:, 3,47,14) = (/ &
 & 0.68067E+01_JPRB,0.80750E+01_JPRB,0.88445E+01_JPRB,0.80966E+01_JPRB,0.72732E+01_JPRB /)  
KB(:, 4,47,14) = (/ &
 & 0.71415E+01_JPRB,0.81619E+01_JPRB,0.88634E+01_JPRB,0.81302E+01_JPRB,0.74640E+01_JPRB /)  
KB(:, 5,47,14) = (/ &
 & 0.74259E+01_JPRB,0.82118E+01_JPRB,0.88390E+01_JPRB,0.81478E+01_JPRB,0.76260E+01_JPRB /)  
KB(:, 1,48,14) = (/ &
 & 0.57999E+01_JPRB,0.76897E+01_JPRB,0.85924E+01_JPRB,0.79165E+01_JPRB,0.66812E+01_JPRB /)  
KB(:, 2,48,14) = (/ &
 & 0.62523E+01_JPRB,0.78878E+01_JPRB,0.87384E+01_JPRB,0.80135E+01_JPRB,0.69471E+01_JPRB /)  
KB(:, 3,48,14) = (/ &
 & 0.66581E+01_JPRB,0.80303E+01_JPRB,0.88250E+01_JPRB,0.80783E+01_JPRB,0.71862E+01_JPRB /)  
KB(:, 4,48,14) = (/ &
 & 0.70120E+01_JPRB,0.81321E+01_JPRB,0.88616E+01_JPRB,0.81203E+01_JPRB,0.73915E+01_JPRB /)  
KB(:, 5,48,14) = (/ &
 & 0.73167E+01_JPRB,0.81963E+01_JPRB,0.88550E+01_JPRB,0.81433E+01_JPRB,0.75640E+01_JPRB /)  
KB(:, 1,49,14) = (/ &
 & 0.56056E+01_JPRB,0.75967E+01_JPRB,0.85186E+01_JPRB,0.78664E+01_JPRB,0.65684E+01_JPRB /)  
KB(:, 2,49,14) = (/ &
 & 0.60725E+01_JPRB,0.78139E+01_JPRB,0.86868E+01_JPRB,0.79799E+01_JPRB,0.68428E+01_JPRB /)  
KB(:, 3,49,14) = (/ &
 & 0.65005E+01_JPRB,0.79789E+01_JPRB,0.87970E+01_JPRB,0.80551E+01_JPRB,0.70936E+01_JPRB /)  
KB(:, 4,49,14) = (/ &
 & 0.68750E+01_JPRB,0.80955E+01_JPRB,0.88532E+01_JPRB,0.81069E+01_JPRB,0.73141E+01_JPRB /)  
KB(:, 5,49,14) = (/ &
 & 0.72008E+01_JPRB,0.81753E+01_JPRB,0.88640E+01_JPRB,0.81362E+01_JPRB,0.74980E+01_JPRB /)  
KB(:, 1,50,14) = (/ &
 & 0.54125E+01_JPRB,0.74991E+01_JPRB,0.84401E+01_JPRB,0.78123E+01_JPRB,0.64595E+01_JPRB /)  
KB(:, 2,50,14) = (/ &
 & 0.59003E+01_JPRB,0.77375E+01_JPRB,0.86301E+01_JPRB,0.79423E+01_JPRB,0.67420E+01_JPRB /)  
KB(:, 3,50,14) = (/ &
 & 0.63429E+01_JPRB,0.79215E+01_JPRB,0.87619E+01_JPRB,0.80304E+01_JPRB,0.70024E+01_JPRB /)  
KB(:, 4,50,14) = (/ &
 & 0.67393E+01_JPRB,0.80557E+01_JPRB,0.88380E+01_JPRB,0.80904E+01_JPRB,0.72354E+01_JPRB /)  
KB(:, 5,50,14) = (/ &
 & 0.70838E+01_JPRB,0.81507E+01_JPRB,0.88659E+01_JPRB,0.81277E+01_JPRB,0.74327E+01_JPRB /)  
KB(:, 1,51,14) = (/ &
 & 0.52191E+01_JPRB,0.73982E+01_JPRB,0.83585E+01_JPRB,0.77548E+01_JPRB,0.63504E+01_JPRB /)  
KB(:, 2,51,14) = (/ &
 & 0.57281E+01_JPRB,0.76566E+01_JPRB,0.85673E+01_JPRB,0.79002E+01_JPRB,0.66408E+01_JPRB /)  
KB(:, 3,51,14) = (/ &
 & 0.61850E+01_JPRB,0.78612E+01_JPRB,0.87206E+01_JPRB,0.80029E+01_JPRB,0.69102E+01_JPRB /)  
KB(:, 4,51,14) = (/ &
 & 0.66013E+01_JPRB,0.80131E+01_JPRB,0.88169E+01_JPRB,0.80719E+01_JPRB,0.71542E+01_JPRB /)  
KB(:, 5,51,14) = (/ &
 & 0.69630E+01_JPRB,0.81207E+01_JPRB,0.88611E+01_JPRB,0.81171E+01_JPRB,0.73645E+01_JPRB /)  
KB(:, 1,52,14) = (/ &
 & 0.50203E+01_JPRB,0.72853E+01_JPRB,0.82659E+01_JPRB,0.76900E+01_JPRB,0.62362E+01_JPRB /)  
KB(:, 2,52,14) = (/ &
 & 0.55489E+01_JPRB,0.75692E+01_JPRB,0.84974E+01_JPRB,0.78525E+01_JPRB,0.65380E+01_JPRB /)  
KB(:, 3,52,14) = (/ &
 & 0.60223E+01_JPRB,0.77933E+01_JPRB,0.86726E+01_JPRB,0.79710E+01_JPRB,0.68148E+01_JPRB /)  
KB(:, 4,52,14) = (/ &
 & 0.64533E+01_JPRB,0.79619E+01_JPRB,0.87883E+01_JPRB,0.80495E+01_JPRB,0.70682E+01_JPRB /)  
KB(:, 5,52,14) = (/ &
 & 0.68363E+01_JPRB,0.80853E+01_JPRB,0.88509E+01_JPRB,0.81034E+01_JPRB,0.72926E+01_JPRB /)  
KB(:, 1,53,14) = (/ &
 & 0.48171E+01_JPRB,0.71626E+01_JPRB,0.81646E+01_JPRB,0.76188E+01_JPRB,0.61179E+01_JPRB /)  
KB(:, 2,53,14) = (/ &
 & 0.53620E+01_JPRB,0.74745E+01_JPRB,0.84206E+01_JPRB,0.77982E+01_JPRB,0.64310E+01_JPRB /)  
KB(:, 3,53,14) = (/ &
 & 0.58544E+01_JPRB,0.77168E+01_JPRB,0.86150E+01_JPRB,0.79329E+01_JPRB,0.67166E+01_JPRB /)  
KB(:, 4,53,14) = (/ &
 & 0.63007E+01_JPRB,0.79064E+01_JPRB,0.87527E+01_JPRB,0.80244E+01_JPRB,0.69787E+01_JPRB /)  
KB(:, 5,53,14) = (/ &
 & 0.67036E+01_JPRB,0.80457E+01_JPRB,0.88348E+01_JPRB,0.80870E+01_JPRB,0.72150E+01_JPRB /)  
KB(:, 1,54,14) = (/ &
 & 0.46268E+01_JPRB,0.70415E+01_JPRB,0.80643E+01_JPRB,0.75453E+01_JPRB,0.60051E+01_JPRB /)  
KB(:, 2,54,14) = (/ &
 & 0.51834E+01_JPRB,0.73793E+01_JPRB,0.83436E+01_JPRB,0.77439E+01_JPRB,0.63304E+01_JPRB /)  
KB(:, 3,54,14) = (/ &
 & 0.56952E+01_JPRB,0.76416E+01_JPRB,0.85557E+01_JPRB,0.78930E+01_JPRB,0.66233E+01_JPRB /)  
KB(:, 4,54,14) = (/ &
 & 0.61555E+01_JPRB,0.78501E+01_JPRB,0.87136E+01_JPRB,0.79986E+01_JPRB,0.68935E+01_JPRB /)  
KB(:, 5,54,14) = (/ &
 & 0.65754E+01_JPRB,0.80055E+01_JPRB,0.88139E+01_JPRB,0.80689E+01_JPRB,0.71391E+01_JPRB /)  
KB(:, 1,55,14) = (/ &
 & 0.44418E+01_JPRB,0.69152E+01_JPRB,0.79589E+01_JPRB,0.74683E+01_JPRB,0.58909E+01_JPRB /)  
KB(:, 2,55,14) = (/ &
 & 0.50082E+01_JPRB,0.72786E+01_JPRB,0.82608E+01_JPRB,0.76866E+01_JPRB,0.62296E+01_JPRB /)  
KB(:, 3,55,14) = (/ &
 & 0.55372E+01_JPRB,0.75641E+01_JPRB,0.84935E+01_JPRB,0.78502E+01_JPRB,0.65324E+01_JPRB /)  
KB(:, 4,55,14) = (/ &
 & 0.60119E+01_JPRB,0.77891E+01_JPRB,0.86705E+01_JPRB,0.79700E+01_JPRB,0.68094E+01_JPRB /)  
KB(:, 5,55,14) = (/ &
 & 0.64443E+01_JPRB,0.79596E+01_JPRB,0.87874E+01_JPRB,0.80489E+01_JPRB,0.70636E+01_JPRB /)  
KB(:, 1,56,14) = (/ &
 & 0.42552E+01_JPRB,0.67816E+01_JPRB,0.78463E+01_JPRB,0.73861E+01_JPRB,0.57693E+01_JPRB /)  
KB(:, 2,56,14) = (/ &
 & 0.48302E+01_JPRB,0.71710E+01_JPRB,0.81721E+01_JPRB,0.76241E+01_JPRB,0.61259E+01_JPRB /)  
KB(:, 3,56,14) = (/ &
 & 0.53736E+01_JPRB,0.74812E+01_JPRB,0.84261E+01_JPRB,0.78026E+01_JPRB,0.64389E+01_JPRB /)  
KB(:, 4,56,14) = (/ &
 & 0.58648E+01_JPRB,0.77223E+01_JPRB,0.86198E+01_JPRB,0.79361E+01_JPRB,0.67232E+01_JPRB /)  
KB(:, 5,56,14) = (/ &
 & 0.63103E+01_JPRB,0.79105E+01_JPRB,0.87564E+01_JPRB,0.80271E+01_JPRB,0.69853E+01_JPRB /)  
KB(:, 1,57,14) = (/ &
 & 0.40639E+01_JPRB,0.66394E+01_JPRB,0.77238E+01_JPRB,0.72954E+01_JPRB,0.56390E+01_JPRB /)  
KB(:, 2,57,14) = (/ &
 & 0.46488E+01_JPRB,0.70563E+01_JPRB,0.80768E+01_JPRB,0.75544E+01_JPRB,0.60187E+01_JPRB /)  
KB(:, 3,57,14) = (/ &
 & 0.52035E+01_JPRB,0.73909E+01_JPRB,0.83529E+01_JPRB,0.77510E+01_JPRB,0.63425E+01_JPRB /)  
KB(:, 4,57,14) = (/ &
 & 0.57137E+01_JPRB,0.76510E+01_JPRB,0.85638E+01_JPRB,0.78985E+01_JPRB,0.66342E+01_JPRB /)  
KB(:, 5,57,14) = (/ &
 & 0.61722E+01_JPRB,0.78574E+01_JPRB,0.87192E+01_JPRB,0.80023E+01_JPRB,0.69038E+01_JPRB /)  
KB(:, 1,58,14) = (/ &
 & 0.38805E+01_JPRB,0.64976E+01_JPRB,0.75961E+01_JPRB,0.72010E+01_JPRB,0.55107E+01_JPRB /)  
KB(:, 2,58,14) = (/ &
 & 0.44745E+01_JPRB,0.69383E+01_JPRB,0.79787E+01_JPRB,0.74825E+01_JPRB,0.59115E+01_JPRB /)  
KB(:, 3,58,14) = (/ &
 & 0.50386E+01_JPRB,0.72976E+01_JPRB,0.82763E+01_JPRB,0.76973E+01_JPRB,0.62480E+01_JPRB /)  
KB(:, 4,58,14) = (/ &
 & 0.55648E+01_JPRB,0.75780E+01_JPRB,0.85055E+01_JPRB,0.78586E+01_JPRB,0.65486E+01_JPRB /)  
KB(:, 5,58,14) = (/ &
 & 0.60366E+01_JPRB,0.78002E+01_JPRB,0.86790E+01_JPRB,0.79756E+01_JPRB,0.68245E+01_JPRB /)  
KB(:, 1,59,14) = (/ &
 & 0.38057E+01_JPRB,0.64388E+01_JPRB,0.75416E+01_JPRB,0.71615E+01_JPRB,0.54582E+01_JPRB /)  
KB(:, 2,59,14) = (/ &
 & 0.44044E+01_JPRB,0.68893E+01_JPRB,0.79374E+01_JPRB,0.74528E+01_JPRB,0.58671E+01_JPRB /)  
KB(:, 3,59,14) = (/ &
 & 0.49711E+01_JPRB,0.72574E+01_JPRB,0.82432E+01_JPRB,0.76750E+01_JPRB,0.62091E+01_JPRB /)  
KB(:, 4,59,14) = (/ &
 & 0.55038E+01_JPRB,0.75476E+01_JPRB,0.84809E+01_JPRB,0.78415E+01_JPRB,0.65137E+01_JPRB /)  
KB(:, 5,59,14) = (/ &
 & 0.59820E+01_JPRB,0.77764E+01_JPRB,0.86612E+01_JPRB,0.79636E+01_JPRB,0.67922E+01_JPRB /)  
KB(:, 1,13,15) = (/ &
 & 0.21583E+02_JPRB,0.16708E+02_JPRB,0.15578E+02_JPRB,0.16324E+02_JPRB,0.21499E+02_JPRB /)  
KB(:, 2,13,15) = (/ &
 & 0.21596E+02_JPRB,0.16646E+02_JPRB,0.15448E+02_JPRB,0.16116E+02_JPRB,0.21237E+02_JPRB /)  
KB(:, 3,13,15) = (/ &
 & 0.21561E+02_JPRB,0.16562E+02_JPRB,0.15303E+02_JPRB,0.15881E+02_JPRB,0.20975E+02_JPRB /)  
KB(:, 4,13,15) = (/ &
 & 0.21482E+02_JPRB,0.16444E+02_JPRB,0.15131E+02_JPRB,0.15663E+02_JPRB,0.20709E+02_JPRB /)  
KB(:, 5,13,15) = (/ &
 & 0.21360E+02_JPRB,0.16308E+02_JPRB,0.14933E+02_JPRB,0.15443E+02_JPRB,0.20449E+02_JPRB /)  
KB(:, 1,14,15) = (/ &
 & 0.23286E+02_JPRB,0.18105E+02_JPRB,0.17022E+02_JPRB,0.17494E+02_JPRB,0.22811E+02_JPRB /)  
KB(:, 2,14,15) = (/ &
 & 0.23268E+02_JPRB,0.18001E+02_JPRB,0.16845E+02_JPRB,0.17259E+02_JPRB,0.22563E+02_JPRB /)  
KB(:, 3,14,15) = (/ &
 & 0.23185E+02_JPRB,0.17865E+02_JPRB,0.16645E+02_JPRB,0.17010E+02_JPRB,0.22295E+02_JPRB /)  
KB(:, 4,14,15) = (/ &
 & 0.23065E+02_JPRB,0.17707E+02_JPRB,0.16417E+02_JPRB,0.16757E+02_JPRB,0.22015E+02_JPRB /)  
KB(:, 5,14,15) = (/ &
 & 0.22894E+02_JPRB,0.17515E+02_JPRB,0.16163E+02_JPRB,0.16504E+02_JPRB,0.21733E+02_JPRB /)  
KB(:, 1,15,15) = (/ &
 & 0.24991E+02_JPRB,0.19505E+02_JPRB,0.18411E+02_JPRB,0.18638E+02_JPRB,0.24057E+02_JPRB /)  
KB(:, 2,15,15) = (/ &
 & 0.24920E+02_JPRB,0.19349E+02_JPRB,0.18180E+02_JPRB,0.18374E+02_JPRB,0.23810E+02_JPRB /)  
KB(:, 3,15,15) = (/ &
 & 0.24797E+02_JPRB,0.19155E+02_JPRB,0.17917E+02_JPRB,0.18103E+02_JPRB,0.23536E+02_JPRB /)  
KB(:, 4,15,15) = (/ &
 & 0.24619E+02_JPRB,0.18942E+02_JPRB,0.17624E+02_JPRB,0.17814E+02_JPRB,0.23238E+02_JPRB /)  
KB(:, 5,15,15) = (/ &
 & 0.24389E+02_JPRB,0.18694E+02_JPRB,0.17313E+02_JPRB,0.17524E+02_JPRB,0.22925E+02_JPRB /)  
KB(:, 1,16,15) = (/ &
 & 0.26656E+02_JPRB,0.20879E+02_JPRB,0.19716E+02_JPRB,0.19730E+02_JPRB,0.25227E+02_JPRB /)  
KB(:, 2,16,15) = (/ &
 & 0.26523E+02_JPRB,0.20660E+02_JPRB,0.19424E+02_JPRB,0.19442E+02_JPRB,0.24961E+02_JPRB /)  
KB(:, 3,16,15) = (/ &
 & 0.26348E+02_JPRB,0.20405E+02_JPRB,0.19093E+02_JPRB,0.19135E+02_JPRB,0.24671E+02_JPRB /)  
KB(:, 4,16,15) = (/ &
 & 0.26107E+02_JPRB,0.20124E+02_JPRB,0.18741E+02_JPRB,0.18812E+02_JPRB,0.24357E+02_JPRB /)  
KB(:, 5,16,15) = (/ &
 & 0.25816E+02_JPRB,0.19816E+02_JPRB,0.18364E+02_JPRB,0.18476E+02_JPRB,0.24001E+02_JPRB /)  
KB(:, 1,17,15) = (/ &
 & 0.28242E+02_JPRB,0.22184E+02_JPRB,0.20936E+02_JPRB,0.20769E+02_JPRB,0.26307E+02_JPRB /)  
KB(:, 2,17,15) = (/ &
 & 0.28053E+02_JPRB,0.21895E+02_JPRB,0.20570E+02_JPRB,0.20444E+02_JPRB,0.26016E+02_JPRB /)  
KB(:, 3,17,15) = (/ &
 & 0.27803E+02_JPRB,0.21584E+02_JPRB,0.20174E+02_JPRB,0.20096E+02_JPRB,0.25702E+02_JPRB /)  
KB(:, 4,17,15) = (/ &
 & 0.27499E+02_JPRB,0.21233E+02_JPRB,0.19753E+02_JPRB,0.19726E+02_JPRB,0.25351E+02_JPRB /)  
KB(:, 5,17,15) = (/ &
 & 0.27139E+02_JPRB,0.20859E+02_JPRB,0.19319E+02_JPRB,0.19342E+02_JPRB,0.24955E+02_JPRB /)  
KB(:, 1,18,15) = (/ &
 & 0.29720E+02_JPRB,0.23411E+02_JPRB,0.22065E+02_JPRB,0.21731E+02_JPRB,0.27280E+02_JPRB /)  
KB(:, 2,18,15) = (/ &
 & 0.29480E+02_JPRB,0.23053E+02_JPRB,0.21624E+02_JPRB,0.21360E+02_JPRB,0.26972E+02_JPRB /)  
KB(:, 3,18,15) = (/ &
 & 0.29159E+02_JPRB,0.22667E+02_JPRB,0.21156E+02_JPRB,0.20967E+02_JPRB,0.26625E+02_JPRB /)  
KB(:, 4,18,15) = (/ &
 & 0.28776E+02_JPRB,0.22248E+02_JPRB,0.20663E+02_JPRB,0.20553E+02_JPRB,0.26229E+02_JPRB /)  
KB(:, 5,18,15) = (/ &
 & 0.28340E+02_JPRB,0.21810E+02_JPRB,0.20170E+02_JPRB,0.20119E+02_JPRB,0.25790E+02_JPRB /)  
KB(:, 1,19,15) = (/ &
 & 0.31079E+02_JPRB,0.24533E+02_JPRB,0.23084E+02_JPRB,0.22601E+02_JPRB,0.28156E+02_JPRB /)  
KB(:, 2,19,15) = (/ &
 & 0.30766E+02_JPRB,0.24108E+02_JPRB,0.22572E+02_JPRB,0.22185E+02_JPRB,0.27815E+02_JPRB /)  
KB(:, 3,19,15) = (/ &
 & 0.30376E+02_JPRB,0.23641E+02_JPRB,0.22030E+02_JPRB,0.21741E+02_JPRB,0.27429E+02_JPRB /)  
KB(:, 4,19,15) = (/ &
 & 0.29923E+02_JPRB,0.23160E+02_JPRB,0.21471E+02_JPRB,0.21280E+02_JPRB,0.26992E+02_JPRB /)  
KB(:, 5,19,15) = (/ &
 & 0.29415E+02_JPRB,0.22660E+02_JPRB,0.20920E+02_JPRB,0.20797E+02_JPRB,0.26511E+02_JPRB /)  
KB(:, 1,20,15) = (/ &
 & 0.32290E+02_JPRB,0.25527E+02_JPRB,0.23984E+02_JPRB,0.23373E+02_JPRB,0.28918E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART34',1,ZHOOK_HANDLE)
END SUBROUTINE PART34


SUBROUTINE PART35

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART35',0,ZHOOK_HANDLE)


KB(:, 2,20,15) = (/ &
 & 0.31907E+02_JPRB,0.25035E+02_JPRB,0.23397E+02_JPRB,0.22899E+02_JPRB,0.28537E+02_JPRB /)  
KB(:, 3,20,15) = (/ &
 & 0.31450E+02_JPRB,0.24496E+02_JPRB,0.22784E+02_JPRB,0.22408E+02_JPRB,0.28112E+02_JPRB /)  
KB(:, 4,20,15) = (/ &
 & 0.30926E+02_JPRB,0.23946E+02_JPRB,0.22166E+02_JPRB,0.21898E+02_JPRB,0.27628E+02_JPRB /)  
KB(:, 5,20,15) = (/ &
 & 0.30351E+02_JPRB,0.23384E+02_JPRB,0.21559E+02_JPRB,0.21369E+02_JPRB,0.27109E+02_JPRB /)  
KB(:, 1,21,15) = (/ &
 & 0.33354E+02_JPRB,0.26397E+02_JPRB,0.24768E+02_JPRB,0.24040E+02_JPRB,0.29575E+02_JPRB /)  
KB(:, 2,21,15) = (/ &
 & 0.32901E+02_JPRB,0.25842E+02_JPRB,0.24107E+02_JPRB,0.23511E+02_JPRB,0.29153E+02_JPRB /)  
KB(:, 3,21,15) = (/ &
 & 0.32374E+02_JPRB,0.25240E+02_JPRB,0.23426E+02_JPRB,0.22972E+02_JPRB,0.28686E+02_JPRB /)  
KB(:, 4,21,15) = (/ &
 & 0.31781E+02_JPRB,0.24624E+02_JPRB,0.22754E+02_JPRB,0.22416E+02_JPRB,0.28162E+02_JPRB /)  
KB(:, 5,21,15) = (/ &
 & 0.31147E+02_JPRB,0.24003E+02_JPRB,0.22095E+02_JPRB,0.21845E+02_JPRB,0.27608E+02_JPRB /)  
KB(:, 1,22,15) = (/ &
 & 0.34245E+02_JPRB,0.27109E+02_JPRB,0.25388E+02_JPRB,0.24566E+02_JPRB,0.30099E+02_JPRB /)  
KB(:, 2,22,15) = (/ &
 & 0.33719E+02_JPRB,0.26481E+02_JPRB,0.24655E+02_JPRB,0.23987E+02_JPRB,0.29635E+02_JPRB /)  
KB(:, 3,22,15) = (/ &
 & 0.33121E+02_JPRB,0.25821E+02_JPRB,0.23916E+02_JPRB,0.23403E+02_JPRB,0.29124E+02_JPRB /)  
KB(:, 4,22,15) = (/ &
 & 0.32461E+02_JPRB,0.25147E+02_JPRB,0.23196E+02_JPRB,0.22805E+02_JPRB,0.28562E+02_JPRB /)  
KB(:, 5,22,15) = (/ &
 & 0.31774E+02_JPRB,0.24482E+02_JPRB,0.22495E+02_JPRB,0.22197E+02_JPRB,0.27979E+02_JPRB /)  
KB(:, 1,23,15) = (/ &
 & 0.34979E+02_JPRB,0.27686E+02_JPRB,0.25885E+02_JPRB,0.24985E+02_JPRB,0.30523E+02_JPRB /)  
KB(:, 2,23,15) = (/ &
 & 0.34390E+02_JPRB,0.26989E+02_JPRB,0.25088E+02_JPRB,0.24366E+02_JPRB,0.30015E+02_JPRB /)  
KB(:, 3,23,15) = (/ &
 & 0.33724E+02_JPRB,0.26279E+02_JPRB,0.24300E+02_JPRB,0.23742E+02_JPRB,0.29464E+02_JPRB /)  
KB(:, 4,23,15) = (/ &
 & 0.33013E+02_JPRB,0.25562E+02_JPRB,0.23538E+02_JPRB,0.23108E+02_JPRB,0.28875E+02_JPRB /)  
KB(:, 5,23,15) = (/ &
 & 0.32269E+02_JPRB,0.24853E+02_JPRB,0.22796E+02_JPRB,0.22467E+02_JPRB,0.28265E+02_JPRB /)  
KB(:, 1,24,15) = (/ &
 & 0.35573E+02_JPRB,0.28136E+02_JPRB,0.26264E+02_JPRB,0.25305E+02_JPRB,0.30849E+02_JPRB /)  
KB(:, 2,24,15) = (/ &
 & 0.34922E+02_JPRB,0.27387E+02_JPRB,0.25413E+02_JPRB,0.24653E+02_JPRB,0.30308E+02_JPRB /)  
KB(:, 3,24,15) = (/ &
 & 0.34200E+02_JPRB,0.26632E+02_JPRB,0.24587E+02_JPRB,0.23994E+02_JPRB,0.29723E+02_JPRB /)  
KB(:, 4,24,15) = (/ &
 & 0.33439E+02_JPRB,0.25872E+02_JPRB,0.23787E+02_JPRB,0.23329E+02_JPRB,0.29105E+02_JPRB /)  
KB(:, 5,24,15) = (/ &
 & 0.32647E+02_JPRB,0.25128E+02_JPRB,0.23014E+02_JPRB,0.22661E+02_JPRB,0.28477E+02_JPRB /)  
KB(:, 1,25,15) = (/ &
 & 0.36033E+02_JPRB,0.28469E+02_JPRB,0.26533E+02_JPRB,0.25539E+02_JPRB,0.31091E+02_JPRB /)  
KB(:, 2,25,15) = (/ &
 & 0.35324E+02_JPRB,0.27679E+02_JPRB,0.25640E+02_JPRB,0.24852E+02_JPRB,0.30512E+02_JPRB /)  
KB(:, 3,25,15) = (/ &
 & 0.34555E+02_JPRB,0.26887E+02_JPRB,0.24782E+02_JPRB,0.24167E+02_JPRB,0.29902E+02_JPRB /)  
KB(:, 4,25,15) = (/ &
 & 0.33752E+02_JPRB,0.26092E+02_JPRB,0.23953E+02_JPRB,0.23474E+02_JPRB,0.29262E+02_JPRB /)  
KB(:, 5,25,15) = (/ &
 & 0.32915E+02_JPRB,0.25319E+02_JPRB,0.23155E+02_JPRB,0.22787E+02_JPRB,0.28617E+02_JPRB /)  
KB(:, 1,26,15) = (/ &
 & 0.36371E+02_JPRB,0.28696E+02_JPRB,0.26697E+02_JPRB,0.25688E+02_JPRB,0.31254E+02_JPRB /)  
KB(:, 2,26,15) = (/ &
 & 0.35607E+02_JPRB,0.27872E+02_JPRB,0.25775E+02_JPRB,0.24975E+02_JPRB,0.30642E+02_JPRB /)  
KB(:, 3,26,15) = (/ &
 & 0.34798E+02_JPRB,0.27047E+02_JPRB,0.24890E+02_JPRB,0.24264E+02_JPRB,0.30007E+02_JPRB /)  
KB(:, 4,26,15) = (/ &
 & 0.33956E+02_JPRB,0.26227E+02_JPRB,0.24040E+02_JPRB,0.23549E+02_JPRB,0.29351E+02_JPRB /)  
KB(:, 5,26,15) = (/ &
 & 0.33076E+02_JPRB,0.25425E+02_JPRB,0.23222E+02_JPRB,0.22845E+02_JPRB,0.28688E+02_JPRB /)  
KB(:, 1,27,15) = (/ &
 & 0.36605E+02_JPRB,0.28839E+02_JPRB,0.26780E+02_JPRB,0.25770E+02_JPRB,0.31349E+02_JPRB /)  
KB(:, 2,27,15) = (/ &
 & 0.35796E+02_JPRB,0.27987E+02_JPRB,0.25836E+02_JPRB,0.25037E+02_JPRB,0.30713E+02_JPRB /)  
KB(:, 3,27,15) = (/ &
 & 0.34952E+02_JPRB,0.27136E+02_JPRB,0.24934E+02_JPRB,0.24306E+02_JPRB,0.30059E+02_JPRB /)  
KB(:, 4,27,15) = (/ &
 & 0.34075E+02_JPRB,0.26294E+02_JPRB,0.24068E+02_JPRB,0.23575E+02_JPRB,0.29392E+02_JPRB /)  
KB(:, 5,27,15) = (/ &
 & 0.33166E+02_JPRB,0.25473E+02_JPRB,0.23238E+02_JPRB,0.22856E+02_JPRB,0.28711E+02_JPRB /)  
KB(:, 1,28,15) = (/ &
 & 0.36758E+02_JPRB,0.28917E+02_JPRB,0.26804E+02_JPRB,0.25803E+02_JPRB,0.31396E+02_JPRB /)  
KB(:, 2,28,15) = (/ &
 & 0.35910E+02_JPRB,0.28037E+02_JPRB,0.25842E+02_JPRB,0.25051E+02_JPRB,0.30739E+02_JPRB /)  
KB(:, 3,28,15) = (/ &
 & 0.35033E+02_JPRB,0.27165E+02_JPRB,0.24925E+02_JPRB,0.24304E+02_JPRB,0.30070E+02_JPRB /)  
KB(:, 4,28,15) = (/ &
 & 0.34125E+02_JPRB,0.26307E+02_JPRB,0.24049E+02_JPRB,0.23563E+02_JPRB,0.29393E+02_JPRB /)  
KB(:, 5,28,15) = (/ &
 & 0.33188E+02_JPRB,0.25468E+02_JPRB,0.23210E+02_JPRB,0.22829E+02_JPRB,0.28695E+02_JPRB /)  
KB(:, 1,29,15) = (/ &
 & 0.36829E+02_JPRB,0.28926E+02_JPRB,0.26766E+02_JPRB,0.25785E+02_JPRB,0.31393E+02_JPRB /)  
KB(:, 2,29,15) = (/ &
 & 0.35949E+02_JPRB,0.28025E+02_JPRB,0.25792E+02_JPRB,0.25019E+02_JPRB,0.30723E+02_JPRB /)  
KB(:, 3,29,15) = (/ &
 & 0.35045E+02_JPRB,0.27141E+02_JPRB,0.24868E+02_JPRB,0.24260E+02_JPRB,0.30042E+02_JPRB /)  
KB(:, 4,29,15) = (/ &
 & 0.34114E+02_JPRB,0.26272E+02_JPRB,0.23986E+02_JPRB,0.23509E+02_JPRB,0.29353E+02_JPRB /)  
KB(:, 5,29,15) = (/ &
 & 0.33154E+02_JPRB,0.25419E+02_JPRB,0.23142E+02_JPRB,0.22765E+02_JPRB,0.28643E+02_JPRB /)  
KB(:, 1,30,15) = (/ &
 & 0.36836E+02_JPRB,0.28884E+02_JPRB,0.26681E+02_JPRB,0.25729E+02_JPRB,0.31353E+02_JPRB /)  
KB(:, 2,30,15) = (/ &
 & 0.35935E+02_JPRB,0.27972E+02_JPRB,0.25704E+02_JPRB,0.24955E+02_JPRB,0.30675E+02_JPRB /)  
KB(:, 3,30,15) = (/ &
 & 0.35002E+02_JPRB,0.27075E+02_JPRB,0.24775E+02_JPRB,0.24184E+02_JPRB,0.29984E+02_JPRB /)  
KB(:, 4,30,15) = (/ &
 & 0.34050E+02_JPRB,0.26196E+02_JPRB,0.23891E+02_JPRB,0.23427E+02_JPRB,0.29283E+02_JPRB /)  
KB(:, 5,30,15) = (/ &
 & 0.33076E+02_JPRB,0.25337E+02_JPRB,0.23046E+02_JPRB,0.22676E+02_JPRB,0.28566E+02_JPRB /)  
KB(:, 1,31,15) = (/ &
 & 0.36791E+02_JPRB,0.28797E+02_JPRB,0.26557E+02_JPRB,0.25640E+02_JPRB,0.31284E+02_JPRB /)  
KB(:, 2,31,15) = (/ &
 & 0.35869E+02_JPRB,0.27877E+02_JPRB,0.25582E+02_JPRB,0.24857E+02_JPRB,0.30596E+02_JPRB /)  
KB(:, 3,31,15) = (/ &
 & 0.34914E+02_JPRB,0.26971E+02_JPRB,0.24653E+02_JPRB,0.24083E+02_JPRB,0.29901E+02_JPRB /)  
KB(:, 4,31,15) = (/ &
 & 0.33941E+02_JPRB,0.26084E+02_JPRB,0.23767E+02_JPRB,0.23319E+02_JPRB,0.29185E+02_JPRB /)  
KB(:, 5,31,15) = (/ &
 & 0.32958E+02_JPRB,0.25224E+02_JPRB,0.22924E+02_JPRB,0.22563E+02_JPRB,0.28464E+02_JPRB /)  
KB(:, 1,32,15) = (/ &
 & 0.36704E+02_JPRB,0.28676E+02_JPRB,0.26402E+02_JPRB,0.25521E+02_JPRB,0.31186E+02_JPRB /)  
KB(:, 2,32,15) = (/ &
 & 0.35759E+02_JPRB,0.27748E+02_JPRB,0.25429E+02_JPRB,0.24734E+02_JPRB,0.30492E+02_JPRB /)  
KB(:, 3,32,15) = (/ &
 & 0.34789E+02_JPRB,0.26839E+02_JPRB,0.24504E+02_JPRB,0.23956E+02_JPRB,0.29792E+02_JPRB /)  
KB(:, 4,32,15) = (/ &
 & 0.33799E+02_JPRB,0.25947E+02_JPRB,0.23622E+02_JPRB,0.23189E+02_JPRB,0.29067E+02_JPRB /)  
KB(:, 5,32,15) = (/ &
 & 0.32807E+02_JPRB,0.25086E+02_JPRB,0.22780E+02_JPRB,0.22431E+02_JPRB,0.28343E+02_JPRB /)  
KB(:, 1,33,15) = (/ &
 & 0.36581E+02_JPRB,0.28529E+02_JPRB,0.26229E+02_JPRB,0.25386E+02_JPRB,0.31076E+02_JPRB /)  
KB(:, 2,33,15) = (/ &
 & 0.35618E+02_JPRB,0.27597E+02_JPRB,0.25258E+02_JPRB,0.24592E+02_JPRB,0.30373E+02_JPRB /)  
KB(:, 3,33,15) = (/ &
 & 0.34634E+02_JPRB,0.26685E+02_JPRB,0.24337E+02_JPRB,0.23815E+02_JPRB,0.29666E+02_JPRB /)  
KB(:, 4,33,15) = (/ &
 & 0.33632E+02_JPRB,0.25791E+02_JPRB,0.23459E+02_JPRB,0.23042E+02_JPRB,0.28931E+02_JPRB /)  
KB(:, 5,33,15) = (/ &
 & 0.32632E+02_JPRB,0.24931E+02_JPRB,0.22622E+02_JPRB,0.22288E+02_JPRB,0.28210E+02_JPRB /)  
KB(:, 1,34,15) = (/ &
 & 0.36458E+02_JPRB,0.28392E+02_JPRB,0.26072E+02_JPRB,0.25264E+02_JPRB,0.30972E+02_JPRB /)  
KB(:, 2,34,15) = (/ &
 & 0.35483E+02_JPRB,0.27459E+02_JPRB,0.25106E+02_JPRB,0.24467E+02_JPRB,0.30265E+02_JPRB /)  
KB(:, 3,34,15) = (/ &
 & 0.34486E+02_JPRB,0.26542E+02_JPRB,0.24189E+02_JPRB,0.23688E+02_JPRB,0.29550E+02_JPRB /)  
KB(:, 4,34,15) = (/ &
 & 0.33480E+02_JPRB,0.25653E+02_JPRB,0.23315E+02_JPRB,0.22913E+02_JPRB,0.28811E+02_JPRB /)  
KB(:, 5,34,15) = (/ &
 & 0.32478E+02_JPRB,0.24793E+02_JPRB,0.22484E+02_JPRB,0.22163E+02_JPRB,0.28094E+02_JPRB /)  
KB(:, 1,35,15) = (/ &
 & 0.36414E+02_JPRB,0.28334E+02_JPRB,0.25999E+02_JPRB,0.25206E+02_JPRB,0.30923E+02_JPRB /)  
KB(:, 2,35,15) = (/ &
 & 0.35425E+02_JPRB,0.27395E+02_JPRB,0.25033E+02_JPRB,0.24406E+02_JPRB,0.30215E+02_JPRB /)  
KB(:, 3,35,15) = (/ &
 & 0.34420E+02_JPRB,0.26476E+02_JPRB,0.24117E+02_JPRB,0.23624E+02_JPRB,0.29493E+02_JPRB /)  
KB(:, 4,35,15) = (/ &
 & 0.33407E+02_JPRB,0.25585E+02_JPRB,0.23243E+02_JPRB,0.22849E+02_JPRB,0.28753E+02_JPRB /)  
KB(:, 5,35,15) = (/ &
 & 0.32403E+02_JPRB,0.24726E+02_JPRB,0.22415E+02_JPRB,0.22101E+02_JPRB,0.28034E+02_JPRB /)  
KB(:, 1,36,15) = (/ &
 & 0.36456E+02_JPRB,0.28365E+02_JPRB,0.26023E+02_JPRB,0.25227E+02_JPRB,0.30947E+02_JPRB /)  
KB(:, 2,36,15) = (/ &
 & 0.35465E+02_JPRB,0.27424E+02_JPRB,0.25054E+02_JPRB,0.24425E+02_JPRB,0.30235E+02_JPRB /)  
KB(:, 3,36,15) = (/ &
 & 0.34451E+02_JPRB,0.26498E+02_JPRB,0.24134E+02_JPRB,0.23640E+02_JPRB,0.29510E+02_JPRB /)  
KB(:, 4,36,15) = (/ &
 & 0.33436E+02_JPRB,0.25606E+02_JPRB,0.23259E+02_JPRB,0.22862E+02_JPRB,0.28768E+02_JPRB /)  
KB(:, 5,36,15) = (/ &
 & 0.32427E+02_JPRB,0.24743E+02_JPRB,0.22427E+02_JPRB,0.22112E+02_JPRB,0.28048E+02_JPRB /)  
KB(:, 1,37,15) = (/ &
 & 0.36638E+02_JPRB,0.28533E+02_JPRB,0.26191E+02_JPRB,0.25363E+02_JPRB,0.31069E+02_JPRB /)  
KB(:, 2,37,15) = (/ &
 & 0.35645E+02_JPRB,0.27585E+02_JPRB,0.25212E+02_JPRB,0.24557E+02_JPRB,0.30356E+02_JPRB /)  
KB(:, 3,37,15) = (/ &
 & 0.34632E+02_JPRB,0.26655E+02_JPRB,0.24283E+02_JPRB,0.23768E+02_JPRB,0.29633E+02_JPRB /)  
KB(:, 4,37,15) = (/ &
 & 0.33611E+02_JPRB,0.25753E+02_JPRB,0.23398E+02_JPRB,0.22987E+02_JPRB,0.28889E+02_JPRB /)  
KB(:, 5,37,15) = (/ &
 & 0.32597E+02_JPRB,0.24885E+02_JPRB,0.22559E+02_JPRB,0.22230E+02_JPRB,0.28165E+02_JPRB /)  
KB(:, 1,38,15) = (/ &
 & 0.36818E+02_JPRB,0.28702E+02_JPRB,0.26363E+02_JPRB,0.25503E+02_JPRB,0.31194E+02_JPRB /)  
KB(:, 2,38,15) = (/ &
 & 0.35825E+02_JPRB,0.27749E+02_JPRB,0.25373E+02_JPRB,0.24692E+02_JPRB,0.30479E+02_JPRB /)  
KB(:, 3,38,15) = (/ &
 & 0.34809E+02_JPRB,0.26811E+02_JPRB,0.24434E+02_JPRB,0.23900E+02_JPRB,0.29757E+02_JPRB /)  
KB(:, 4,38,15) = (/ &
 & 0.33789E+02_JPRB,0.25904E+02_JPRB,0.23543E+02_JPRB,0.23114E+02_JPRB,0.29012E+02_JPRB /)  
KB(:, 5,38,15) = (/ &
 & 0.32767E+02_JPRB,0.25028E+02_JPRB,0.22694E+02_JPRB,0.22351E+02_JPRB,0.28285E+02_JPRB /)  
KB(:, 1,39,15) = (/ &
 & 0.36989E+02_JPRB,0.28865E+02_JPRB,0.26530E+02_JPRB,0.25636E+02_JPRB,0.31312E+02_JPRB /)  
KB(:, 2,39,15) = (/ &
 & 0.35999E+02_JPRB,0.27907E+02_JPRB,0.25529E+02_JPRB,0.24823E+02_JPRB,0.30597E+02_JPRB /)  
KB(:, 3,39,15) = (/ &
 & 0.34983E+02_JPRB,0.26966E+02_JPRB,0.24583E+02_JPRB,0.24027E+02_JPRB,0.29878E+02_JPRB /)  
KB(:, 4,39,15) = (/ &
 & 0.33957E+02_JPRB,0.26048E+02_JPRB,0.23683E+02_JPRB,0.23240E+02_JPRB,0.29134E+02_JPRB /)  
KB(:, 5,39,15) = (/ &
 & 0.32935E+02_JPRB,0.25169E+02_JPRB,0.22826E+02_JPRB,0.22468E+02_JPRB,0.28398E+02_JPRB /)  
KB(:, 1,40,15) = (/ &
 & 0.37254E+02_JPRB,0.29125E+02_JPRB,0.26800E+02_JPRB,0.25853E+02_JPRB,0.31502E+02_JPRB /)  
KB(:, 2,40,15) = (/ &
 & 0.36269E+02_JPRB,0.28159E+02_JPRB,0.25786E+02_JPRB,0.25036E+02_JPRB,0.30787E+02_JPRB /)  
KB(:, 3,40,15) = (/ &
 & 0.35253E+02_JPRB,0.27211E+02_JPRB,0.24825E+02_JPRB,0.24233E+02_JPRB,0.30069E+02_JPRB /)  
KB(:, 4,40,15) = (/ &
 & 0.34229E+02_JPRB,0.26287E+02_JPRB,0.23913E+02_JPRB,0.23442E+02_JPRB,0.29327E+02_JPRB /)  
KB(:, 5,40,15) = (/ &
 & 0.33202E+02_JPRB,0.25396E+02_JPRB,0.23042E+02_JPRB,0.22665E+02_JPRB,0.28587E+02_JPRB /)  
KB(:, 1,41,15) = (/ &
 & 0.37526E+02_JPRB,0.29396E+02_JPRB,0.27087E+02_JPRB,0.26081E+02_JPRB,0.31701E+02_JPRB /)  
KB(:, 2,41,15) = (/ &
 & 0.36546E+02_JPRB,0.28422E+02_JPRB,0.26056E+02_JPRB,0.25257E+02_JPRB,0.30982E+02_JPRB /)  
KB(:, 3,41,15) = (/ &
 & 0.35534E+02_JPRB,0.27467E+02_JPRB,0.25079E+02_JPRB,0.24448E+02_JPRB,0.30265E+02_JPRB /)  
KB(:, 4,41,15) = (/ &
 & 0.34510E+02_JPRB,0.26534E+02_JPRB,0.24153E+02_JPRB,0.23654E+02_JPRB,0.29528E+02_JPRB /)  
KB(:, 5,41,15) = (/ &
 & 0.33481E+02_JPRB,0.25633E+02_JPRB,0.23271E+02_JPRB,0.22872E+02_JPRB,0.28783E+02_JPRB /)  
KB(:, 1,42,15) = (/ &
 & 0.37791E+02_JPRB,0.29665E+02_JPRB,0.27375E+02_JPRB,0.26306E+02_JPRB,0.31897E+02_JPRB /)  
KB(:, 2,42,15) = (/ &
 & 0.36818E+02_JPRB,0.28682E+02_JPRB,0.26328E+02_JPRB,0.25479E+02_JPRB,0.31179E+02_JPRB /)  
KB(:, 3,42,15) = (/ &
 & 0.35814E+02_JPRB,0.27725E+02_JPRB,0.25336E+02_JPRB,0.24663E+02_JPRB,0.30459E+02_JPRB /)  
KB(:, 4,42,15) = (/ &
 & 0.34792E+02_JPRB,0.26784E+02_JPRB,0.24397E+02_JPRB,0.23867E+02_JPRB,0.29730E+02_JPRB /)  
KB(:, 5,42,15) = (/ &
 & 0.33761E+02_JPRB,0.25873E+02_JPRB,0.23504E+02_JPRB,0.23079E+02_JPRB,0.28983E+02_JPRB /)  
KB(:, 1,43,15) = (/ &
 & 0.38102E+02_JPRB,0.29987E+02_JPRB,0.27726E+02_JPRB,0.26579E+02_JPRB,0.32132E+02_JPRB /)  
KB(:, 2,43,15) = (/ &
 & 0.37142E+02_JPRB,0.29000E+02_JPRB,0.26660E+02_JPRB,0.25743E+02_JPRB,0.31410E+02_JPRB /)  
KB(:, 3,43,15) = (/ &
 & 0.36146E+02_JPRB,0.28034E+02_JPRB,0.25651E+02_JPRB,0.24927E+02_JPRB,0.30694E+02_JPRB /)  
KB(:, 4,43,15) = (/ &
 & 0.35125E+02_JPRB,0.27087E+02_JPRB,0.24694E+02_JPRB,0.24121E+02_JPRB,0.29968E+02_JPRB /)  
KB(:, 5,43,15) = (/ &
 & 0.34093E+02_JPRB,0.26161E+02_JPRB,0.23786E+02_JPRB,0.23330E+02_JPRB,0.29223E+02_JPRB /)  
KB(:, 1,44,15) = (/ &
 & 0.38433E+02_JPRB,0.30339E+02_JPRB,0.28106E+02_JPRB,0.26874E+02_JPRB,0.32381E+02_JPRB /)  
KB(:, 2,44,15) = (/ &
 & 0.37485E+02_JPRB,0.29344E+02_JPRB,0.27023E+02_JPRB,0.26033E+02_JPRB,0.31664E+02_JPRB /)  
KB(:, 3,44,15) = (/ &
 & 0.36497E+02_JPRB,0.28368E+02_JPRB,0.25996E+02_JPRB,0.25211E+02_JPRB,0.30945E+02_JPRB /)  
KB(:, 4,44,15) = (/ &
 & 0.35483E+02_JPRB,0.27414E+02_JPRB,0.25019E+02_JPRB,0.24397E+02_JPRB,0.30221E+02_JPRB /)  
KB(:, 5,44,15) = (/ &
 & 0.34454E+02_JPRB,0.26480E+02_JPRB,0.24095E+02_JPRB,0.23603E+02_JPRB,0.29482E+02_JPRB /)  
KB(:, 1,45,15) = (/ &
 & 0.38755E+02_JPRB,0.30690E+02_JPRB,0.28491E+02_JPRB,0.27169E+02_JPRB,0.32624E+02_JPRB /)  
KB(:, 2,45,15) = (/ &
 & 0.37819E+02_JPRB,0.29686E+02_JPRB,0.27393E+02_JPRB,0.26324E+02_JPRB,0.31916E+02_JPRB /)  
KB(:, 3,45,15) = (/ &
 & 0.36842E+02_JPRB,0.28700E+02_JPRB,0.26343E+02_JPRB,0.25494E+02_JPRB,0.31195E+02_JPRB /)  
KB(:, 4,45,15) = (/ &
 & 0.35840E+02_JPRB,0.27743E+02_JPRB,0.25350E+02_JPRB,0.24674E+02_JPRB,0.30470E+02_JPRB /)  
KB(:, 5,45,15) = (/ &
 & 0.34814E+02_JPRB,0.26800E+02_JPRB,0.24408E+02_JPRB,0.23874E+02_JPRB,0.29739E+02_JPRB /)  
KB(:, 1,46,15) = (/ &
 & 0.39090E+02_JPRB,0.31065E+02_JPRB,0.28908E+02_JPRB,0.27486E+02_JPRB,0.32877E+02_JPRB /)  
KB(:, 2,46,15) = (/ &
 & 0.38170E+02_JPRB,0.30050E+02_JPRB,0.27790E+02_JPRB,0.26631E+02_JPRB,0.32180E+02_JPRB /)  
KB(:, 3,46,15) = (/ &
 & 0.37208E+02_JPRB,0.29060E+02_JPRB,0.26719E+02_JPRB,0.25793E+02_JPRB,0.31457E+02_JPRB /)  
KB(:, 4,46,15) = (/ &
 & 0.36211E+02_JPRB,0.28091E+02_JPRB,0.25705E+02_JPRB,0.24972E+02_JPRB,0.30735E+02_JPRB /)  
KB(:, 5,46,15) = (/ &
 & 0.35190E+02_JPRB,0.27143E+02_JPRB,0.24746E+02_JPRB,0.24165E+02_JPRB,0.30011E+02_JPRB /)  
KB(:, 1,47,15) = (/ &
 & 0.39451E+02_JPRB,0.31490E+02_JPRB,0.29378E+02_JPRB,0.27842E+02_JPRB,0.33145E+02_JPRB /)  
KB(:, 2,47,15) = (/ &
 & 0.38554E+02_JPRB,0.30463E+02_JPRB,0.28238E+02_JPRB,0.26977E+02_JPRB,0.32470E+02_JPRB /)  
KB(:, 3,47,15) = (/ &
 & 0.37608E+02_JPRB,0.29464E+02_JPRB,0.27149E+02_JPRB,0.26134E+02_JPRB,0.31753E+02_JPRB /)  
KB(:, 4,47,15) = (/ &
 & 0.36624E+02_JPRB,0.28485E+02_JPRB,0.26114E+02_JPRB,0.25307E+02_JPRB,0.31030E+02_JPRB /)  
KB(:, 5,47,15) = (/ &
 & 0.35612E+02_JPRB,0.27529E+02_JPRB,0.25131E+02_JPRB,0.24491E+02_JPRB,0.30307E+02_JPRB /)  
KB(:, 1,48,15) = (/ &
 & 0.39789E+02_JPRB,0.31912E+02_JPRB,0.29855E+02_JPRB,0.28207E+02_JPRB,0.33402E+02_JPRB /)  
KB(:, 2,48,15) = (/ &
 & 0.38929E+02_JPRB,0.30877E+02_JPRB,0.28697E+02_JPRB,0.27328E+02_JPRB,0.32755E+02_JPRB /)  
KB(:, 3,48,15) = (/ &
 & 0.38000E+02_JPRB,0.29868E+02_JPRB,0.27588E+02_JPRB,0.26477E+02_JPRB,0.32050E+02_JPRB /)  
KB(:, 4,48,15) = (/ &
 & 0.37030E+02_JPRB,0.28879E+02_JPRB,0.26527E+02_JPRB,0.25639E+02_JPRB,0.31322E+02_JPRB /)  
KB(:, 5,48,15) = (/ &
 & 0.36027E+02_JPRB,0.27916E+02_JPRB,0.25523E+02_JPRB,0.24819E+02_JPRB,0.30601E+02_JPRB /)  
KB(:, 1,49,15) = (/ &
 & 0.40116E+02_JPRB,0.32336E+02_JPRB,0.30332E+02_JPRB,0.28574E+02_JPRB,0.33637E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART35',1,ZHOOK_HANDLE)
END SUBROUTINE PART35


SUBROUTINE PART36

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART36',0,ZHOOK_HANDLE)


KB(:, 2,49,15) = (/ &
 & 0.39295E+02_JPRB,0.31299E+02_JPRB,0.29164E+02_JPRB,0.27682E+02_JPRB,0.33028E+02_JPRB /)  
KB(:, 3,49,15) = (/ &
 & 0.38385E+02_JPRB,0.30275E+02_JPRB,0.28033E+02_JPRB,0.26821E+02_JPRB,0.32341E+02_JPRB /)  
KB(:, 4,49,15) = (/ &
 & 0.37432E+02_JPRB,0.29281E+02_JPRB,0.26949E+02_JPRB,0.25975E+02_JPRB,0.31615E+02_JPRB /)  
KB(:, 5,49,15) = (/ &
 & 0.36440E+02_JPRB,0.28306E+02_JPRB,0.25923E+02_JPRB,0.25151E+02_JPRB,0.30893E+02_JPRB /)  
KB(:, 1,50,15) = (/ &
 & 0.40414E+02_JPRB,0.32736E+02_JPRB,0.30783E+02_JPRB,0.28924E+02_JPRB,0.33845E+02_JPRB /)  
KB(:, 2,50,15) = (/ &
 & 0.39619E+02_JPRB,0.31694E+02_JPRB,0.29608E+02_JPRB,0.28020E+02_JPRB,0.33276E+02_JPRB /)  
KB(:, 3,50,15) = (/ &
 & 0.38737E+02_JPRB,0.30661E+02_JPRB,0.28456E+02_JPRB,0.27146E+02_JPRB,0.32609E+02_JPRB /)  
KB(:, 4,50,15) = (/ &
 & 0.37800E+02_JPRB,0.29658E+02_JPRB,0.27356E+02_JPRB,0.26296E+02_JPRB,0.31894E+02_JPRB /)  
KB(:, 5,50,15) = (/ &
 & 0.36822E+02_JPRB,0.28673E+02_JPRB,0.26306E+02_JPRB,0.25463E+02_JPRB,0.31168E+02_JPRB /)  
KB(:, 1,51,15) = (/ &
 & 0.40689E+02_JPRB,0.33123E+02_JPRB,0.31211E+02_JPRB,0.29252E+02_JPRB,0.34023E+02_JPRB /)  
KB(:, 2,51,15) = (/ &
 & 0.39919E+02_JPRB,0.32076E+02_JPRB,0.30039E+02_JPRB,0.28350E+02_JPRB,0.33499E+02_JPRB /)  
KB(:, 3,51,15) = (/ &
 & 0.39075E+02_JPRB,0.31039E+02_JPRB,0.28875E+02_JPRB,0.27462E+02_JPRB,0.32860E+02_JPRB /)  
KB(:, 4,51,15) = (/ &
 & 0.38151E+02_JPRB,0.30023E+02_JPRB,0.27755E+02_JPRB,0.26605E+02_JPRB,0.32160E+02_JPRB /)  
KB(:, 5,51,15) = (/ &
 & 0.37189E+02_JPRB,0.29033E+02_JPRB,0.26685E+02_JPRB,0.25765E+02_JPRB,0.31432E+02_JPRB /)  
KB(:, 1,52,15) = (/ &
 & 0.40936E+02_JPRB,0.33510E+02_JPRB,0.31640E+02_JPRB,0.29576E+02_JPRB,0.34183E+02_JPRB /)  
KB(:, 2,52,15) = (/ &
 & 0.40210E+02_JPRB,0.32459E+02_JPRB,0.30471E+02_JPRB,0.28683E+02_JPRB,0.33706E+02_JPRB /)  
KB(:, 3,52,15) = (/ &
 & 0.39397E+02_JPRB,0.31418E+02_JPRB,0.29296E+02_JPRB,0.27784E+02_JPRB,0.33107E+02_JPRB /)  
KB(:, 4,52,15) = (/ &
 & 0.38495E+02_JPRB,0.30394E+02_JPRB,0.28160E+02_JPRB,0.26919E+02_JPRB,0.32422E+02_JPRB /)  
KB(:, 5,52,15) = (/ &
 & 0.37548E+02_JPRB,0.29397E+02_JPRB,0.27070E+02_JPRB,0.26070E+02_JPRB,0.31697E+02_JPRB /)  
KB(:, 1,53,15) = (/ &
 & 0.41161E+02_JPRB,0.33900E+02_JPRB,0.32075E+02_JPRB,0.29895E+02_JPRB,0.34325E+02_JPRB /)  
KB(:, 2,53,15) = (/ &
 & 0.40494E+02_JPRB,0.32844E+02_JPRB,0.30901E+02_JPRB,0.29015E+02_JPRB,0.33898E+02_JPRB /)  
KB(:, 3,53,15) = (/ &
 & 0.39709E+02_JPRB,0.31802E+02_JPRB,0.29726E+02_JPRB,0.28110E+02_JPRB,0.33339E+02_JPRB /)  
KB(:, 4,53,15) = (/ &
 & 0.38833E+02_JPRB,0.30766E+02_JPRB,0.28570E+02_JPRB,0.27234E+02_JPRB,0.32680E+02_JPRB /)  
KB(:, 5,53,15) = (/ &
 & 0.37902E+02_JPRB,0.29761E+02_JPRB,0.27465E+02_JPRB,0.26380E+02_JPRB,0.31966E+02_JPRB /)  
KB(:, 1,54,15) = (/ &
 & 0.41350E+02_JPRB,0.34259E+02_JPRB,0.32468E+02_JPRB,0.30182E+02_JPRB,0.34433E+02_JPRB /)  
KB(:, 2,54,15) = (/ &
 & 0.40740E+02_JPRB,0.33197E+02_JPRB,0.31292E+02_JPRB,0.29316E+02_JPRB,0.34057E+02_JPRB /)  
KB(:, 3,54,15) = (/ &
 & 0.39978E+02_JPRB,0.32149E+02_JPRB,0.30122E+02_JPRB,0.28414E+02_JPRB,0.33542E+02_JPRB /)  
KB(:, 4,54,15) = (/ &
 & 0.39139E+02_JPRB,0.31111E+02_JPRB,0.28955E+02_JPRB,0.27524E+02_JPRB,0.32911E+02_JPRB /)  
KB(:, 5,54,15) = (/ &
 & 0.38222E+02_JPRB,0.30095E+02_JPRB,0.27832E+02_JPRB,0.26664E+02_JPRB,0.32209E+02_JPRB /)  
KB(:, 1,55,15) = (/ &
 & 0.41508E+02_JPRB,0.34608E+02_JPRB,0.32849E+02_JPRB,0.30454E+02_JPRB,0.34522E+02_JPRB /)  
KB(:, 2,55,15) = (/ &
 & 0.40955E+02_JPRB,0.33539E+02_JPRB,0.31671E+02_JPRB,0.29598E+02_JPRB,0.34194E+02_JPRB /)  
KB(:, 3,55,15) = (/ &
 & 0.40232E+02_JPRB,0.32485E+02_JPRB,0.30501E+02_JPRB,0.28707E+02_JPRB,0.33722E+02_JPRB /)  
KB(:, 4,55,15) = (/ &
 & 0.39425E+02_JPRB,0.31448E+02_JPRB,0.29326E+02_JPRB,0.27805E+02_JPRB,0.33122E+02_JPRB /)  
KB(:, 5,55,15) = (/ &
 & 0.38521E+02_JPRB,0.30419E+02_JPRB,0.28187E+02_JPRB,0.26941E+02_JPRB,0.32441E+02_JPRB /)  
KB(:, 1,56,15) = (/ &
 & 0.41645E+02_JPRB,0.34957E+02_JPRB,0.33233E+02_JPRB,0.30720E+02_JPRB,0.34599E+02_JPRB /)  
KB(:, 2,56,15) = (/ &
 & 0.41152E+02_JPRB,0.33880E+02_JPRB,0.32050E+02_JPRB,0.29874E+02_JPRB,0.34316E+02_JPRB /)  
KB(:, 3,56,15) = (/ &
 & 0.40482E+02_JPRB,0.32823E+02_JPRB,0.30877E+02_JPRB,0.28999E+02_JPRB,0.33890E+02_JPRB /)  
KB(:, 4,56,15) = (/ &
 & 0.39696E+02_JPRB,0.31783E+02_JPRB,0.29704E+02_JPRB,0.28093E+02_JPRB,0.33329E+02_JPRB /)  
KB(:, 5,56,15) = (/ &
 & 0.38819E+02_JPRB,0.30747E+02_JPRB,0.28547E+02_JPRB,0.27216E+02_JPRB,0.32666E+02_JPRB /)  
KB(:, 1,57,15) = (/ &
 & 0.41772E+02_JPRB,0.35313E+02_JPRB,0.33621E+02_JPRB,0.30980E+02_JPRB,0.34653E+02_JPRB /)  
KB(:, 2,57,15) = (/ &
 & 0.41335E+02_JPRB,0.34223E+02_JPRB,0.32428E+02_JPRB,0.30152E+02_JPRB,0.34423E+02_JPRB /)  
KB(:, 3,57,15) = (/ &
 & 0.40717E+02_JPRB,0.33158E+02_JPRB,0.31249E+02_JPRB,0.29283E+02_JPRB,0.34041E+02_JPRB /)  
KB(:, 4,57,15) = (/ &
 & 0.39952E+02_JPRB,0.32113E+02_JPRB,0.30080E+02_JPRB,0.28382E+02_JPRB,0.33523E+02_JPRB /)  
KB(:, 5,57,15) = (/ &
 & 0.39110E+02_JPRB,0.31075E+02_JPRB,0.28913E+02_JPRB,0.27492E+02_JPRB,0.32886E+02_JPRB /)  
KB(:, 1,58,15) = (/ &
 & 0.41872E+02_JPRB,0.35648E+02_JPRB,0.33990E+02_JPRB,0.31215E+02_JPRB,0.34668E+02_JPRB /)  
KB(:, 2,58,15) = (/ &
 & 0.41486E+02_JPRB,0.34551E+02_JPRB,0.32786E+02_JPRB,0.30408E+02_JPRB,0.34507E+02_JPRB /)  
KB(:, 3,58,15) = (/ &
 & 0.40923E+02_JPRB,0.33481E+02_JPRB,0.31606E+02_JPRB,0.29553E+02_JPRB,0.34175E+02_JPRB /)  
KB(:, 4,58,15) = (/ &
 & 0.40193E+02_JPRB,0.32431E+02_JPRB,0.30438E+02_JPRB,0.28657E+02_JPRB,0.33692E+02_JPRB /)  
KB(:, 5,58,15) = (/ &
 & 0.39381E+02_JPRB,0.31393E+02_JPRB,0.29263E+02_JPRB,0.27758E+02_JPRB,0.33088E+02_JPRB /)  
KB(:, 1,59,15) = (/ &
 & 0.41905E+02_JPRB,0.35780E+02_JPRB,0.34140E+02_JPRB,0.31306E+02_JPRB,0.34668E+02_JPRB /)  
KB(:, 2,59,15) = (/ &
 & 0.41541E+02_JPRB,0.34683E+02_JPRB,0.32931E+02_JPRB,0.30509E+02_JPRB,0.34539E+02_JPRB /)  
KB(:, 3,59,15) = (/ &
 & 0.41000E+02_JPRB,0.33610E+02_JPRB,0.31751E+02_JPRB,0.29658E+02_JPRB,0.34225E+02_JPRB /)  
KB(:, 4,59,15) = (/ &
 & 0.40289E+02_JPRB,0.32559E+02_JPRB,0.30582E+02_JPRB,0.28769E+02_JPRB,0.33760E+02_JPRB /)  
KB(:, 5,59,15) = (/ &
 & 0.39484E+02_JPRB,0.31518E+02_JPRB,0.29405E+02_JPRB,0.27867E+02_JPRB,0.33169E+02_JPRB /)  
KB(:, 1,13,16) = (/ &
 & 0.44218E+02_JPRB,0.33168E+02_JPRB,0.27605E+02_JPRB,0.40761E+02_JPRB,0.54348E+02_JPRB /)  
KB(:, 2,13,16) = (/ &
 & 0.43915E+02_JPRB,0.32941E+02_JPRB,0.26738E+02_JPRB,0.39342E+02_JPRB,0.52457E+02_JPRB /)  
KB(:, 3,13,16) = (/ &
 & 0.43491E+02_JPRB,0.32624E+02_JPRB,0.25861E+02_JPRB,0.38022E+02_JPRB,0.50696E+02_JPRB /)  
KB(:, 4,13,16) = (/ &
 & 0.42952E+02_JPRB,0.32220E+02_JPRB,0.25010E+02_JPRB,0.36713E+02_JPRB,0.48951E+02_JPRB /)  
KB(:, 5,13,16) = (/ &
 & 0.42305E+02_JPRB,0.31735E+02_JPRB,0.24184E+02_JPRB,0.35417E+02_JPRB,0.47222E+02_JPRB /)  
KB(:, 1,14,16) = (/ &
 & 0.50640E+02_JPRB,0.37984E+02_JPRB,0.31138E+02_JPRB,0.45571E+02_JPRB,0.60761E+02_JPRB /)  
KB(:, 2,14,16) = (/ &
 & 0.50072E+02_JPRB,0.37558E+02_JPRB,0.30053E+02_JPRB,0.43809E+02_JPRB,0.58413E+02_JPRB /)  
KB(:, 3,14,16) = (/ &
 & 0.49384E+02_JPRB,0.37043E+02_JPRB,0.28981E+02_JPRB,0.42162E+02_JPRB,0.56216E+02_JPRB /)  
KB(:, 4,14,16) = (/ &
 & 0.48531E+02_JPRB,0.36404E+02_JPRB,0.27924E+02_JPRB,0.40555E+02_JPRB,0.54074E+02_JPRB /)  
KB(:, 5,14,16) = (/ &
 & 0.47588E+02_JPRB,0.35696E+02_JPRB,0.26896E+02_JPRB,0.38961E+02_JPRB,0.51948E+02_JPRB /)  
KB(:, 1,15,16) = (/ &
 & 0.57280E+02_JPRB,0.42964E+02_JPRB,0.34740E+02_JPRB,0.50323E+02_JPRB,0.67098E+02_JPRB /)  
KB(:, 2,15,16) = (/ &
 & 0.56367E+02_JPRB,0.42280E+02_JPRB,0.33407E+02_JPRB,0.48191E+02_JPRB,0.64255E+02_JPRB /)  
KB(:, 3,15,16) = (/ &
 & 0.55318E+02_JPRB,0.41493E+02_JPRB,0.32092E+02_JPRB,0.46141E+02_JPRB,0.61520E+02_JPRB /)  
KB(:, 4,15,16) = (/ &
 & 0.54108E+02_JPRB,0.40586E+02_JPRB,0.30808E+02_JPRB,0.44198E+02_JPRB,0.58930E+02_JPRB /)  
KB(:, 5,15,16) = (/ &
 & 0.52826E+02_JPRB,0.39625E+02_JPRB,0.29570E+02_JPRB,0.42303E+02_JPRB,0.56404E+02_JPRB /)  
KB(:, 1,16,16) = (/ &
 & 0.63967E+02_JPRB,0.47979E+02_JPRB,0.38312E+02_JPRB,0.54909E+02_JPRB,0.73213E+02_JPRB /)  
KB(:, 2,16,16) = (/ &
 & 0.62626E+02_JPRB,0.46973E+02_JPRB,0.36695E+02_JPRB,0.52345E+02_JPRB,0.69794E+02_JPRB /)  
KB(:, 3,16,16) = (/ &
 & 0.61112E+02_JPRB,0.45838E+02_JPRB,0.35123E+02_JPRB,0.49904E+02_JPRB,0.66539E+02_JPRB /)  
KB(:, 4,16,16) = (/ &
 & 0.59503E+02_JPRB,0.44632E+02_JPRB,0.33592E+02_JPRB,0.47568E+02_JPRB,0.63425E+02_JPRB /)  
KB(:, 5,16,16) = (/ &
 & 0.57855E+02_JPRB,0.43396E+02_JPRB,0.32125E+02_JPRB,0.45372E+02_JPRB,0.60497E+02_JPRB /)  
KB(:, 1,17,16) = (/ &
 & 0.70540E+02_JPRB,0.52908E+02_JPRB,0.41791E+02_JPRB,0.59184E+02_JPRB,0.78912E+02_JPRB /)  
KB(:, 2,17,16) = (/ &
 & 0.68668E+02_JPRB,0.51504E+02_JPRB,0.39850E+02_JPRB,0.56189E+02_JPRB,0.74919E+02_JPRB /)  
KB(:, 3,17,16) = (/ &
 & 0.66662E+02_JPRB,0.50000E+02_JPRB,0.37983E+02_JPRB,0.53339E+02_JPRB,0.71119E+02_JPRB /)  
KB(:, 4,17,16) = (/ &
 & 0.64633E+02_JPRB,0.48479E+02_JPRB,0.36199E+02_JPRB,0.50655E+02_JPRB,0.67541E+02_JPRB /)  
KB(:, 5,17,16) = (/ &
 & 0.62569E+02_JPRB,0.46932E+02_JPRB,0.34500E+02_JPRB,0.48144E+02_JPRB,0.64192E+02_JPRB /)  
KB(:, 1,18,16) = (/ &
 & 0.76762E+02_JPRB,0.57574E+02_JPRB,0.45062E+02_JPRB,0.63079E+02_JPRB,0.84105E+02_JPRB /)  
KB(:, 2,18,16) = (/ &
 & 0.74320E+02_JPRB,0.55743E+02_JPRB,0.42789E+02_JPRB,0.59653E+02_JPRB,0.79537E+02_JPRB /)  
KB(:, 3,18,16) = (/ &
 & 0.71820E+02_JPRB,0.53869E+02_JPRB,0.40630E+02_JPRB,0.56414E+02_JPRB,0.75219E+02_JPRB /)  
KB(:, 4,18,16) = (/ &
 & 0.69367E+02_JPRB,0.52029E+02_JPRB,0.38584E+02_JPRB,0.53391E+02_JPRB,0.71188E+02_JPRB /)  
KB(:, 5,18,16) = (/ &
 & 0.66895E+02_JPRB,0.50176E+02_JPRB,0.36663E+02_JPRB,0.50596E+02_JPRB,0.67461E+02_JPRB /)  
KB(:, 1,19,16) = (/ &
 & 0.82534E+02_JPRB,0.61903E+02_JPRB,0.48066E+02_JPRB,0.66533E+02_JPRB,0.88711E+02_JPRB /)  
KB(:, 2,19,16) = (/ &
 & 0.79500E+02_JPRB,0.59627E+02_JPRB,0.45463E+02_JPRB,0.62698E+02_JPRB,0.83597E+02_JPRB /)  
KB(:, 3,19,16) = (/ &
 & 0.76531E+02_JPRB,0.57402E+02_JPRB,0.43003E+02_JPRB,0.59107E+02_JPRB,0.78810E+02_JPRB /)  
KB(:, 4,19,16) = (/ &
 & 0.73621E+02_JPRB,0.55219E+02_JPRB,0.40714E+02_JPRB,0.55776E+02_JPRB,0.74368E+02_JPRB /)  
KB(:, 5,19,16) = (/ &
 & 0.70758E+02_JPRB,0.53072E+02_JPRB,0.38580E+02_JPRB,0.52720E+02_JPRB,0.70294E+02_JPRB /)  
KB(:, 1,20,16) = (/ &
 & 0.87685E+02_JPRB,0.65766E+02_JPRB,0.50694E+02_JPRB,0.69445E+02_JPRB,0.92594E+02_JPRB /)  
KB(:, 2,20,16) = (/ &
 & 0.84090E+02_JPRB,0.63070E+02_JPRB,0.47778E+02_JPRB,0.65259E+02_JPRB,0.87012E+02_JPRB /)  
KB(:, 3,20,16) = (/ &
 & 0.80661E+02_JPRB,0.60499E+02_JPRB,0.45053E+02_JPRB,0.61350E+02_JPRB,0.81800E+02_JPRB /)  
KB(:, 4,20,16) = (/ &
 & 0.77340E+02_JPRB,0.58008E+02_JPRB,0.42537E+02_JPRB,0.57756E+02_JPRB,0.77009E+02_JPRB /)  
KB(:, 5,20,16) = (/ &
 & 0.74079E+02_JPRB,0.55564E+02_JPRB,0.40201E+02_JPRB,0.54475E+02_JPRB,0.72633E+02_JPRB /)  
KB(:, 1,21,16) = (/ &
 & 0.92165E+02_JPRB,0.69126E+02_JPRB,0.52960E+02_JPRB,0.71872E+02_JPRB,0.95829E+02_JPRB /)  
KB(:, 2,21,16) = (/ &
 & 0.88084E+02_JPRB,0.66065E+02_JPRB,0.49750E+02_JPRB,0.67363E+02_JPRB,0.89818E+02_JPRB /)  
KB(:, 3,21,16) = (/ &
 & 0.84210E+02_JPRB,0.63159E+02_JPRB,0.46796E+02_JPRB,0.63194E+02_JPRB,0.84259E+02_JPRB /)  
KB(:, 4,21,16) = (/ &
 & 0.80508E+02_JPRB,0.60384E+02_JPRB,0.44071E+02_JPRB,0.59388E+02_JPRB,0.79185E+02_JPRB /)  
KB(:, 5,21,16) = (/ &
 & 0.76889E+02_JPRB,0.57670E+02_JPRB,0.41555E+02_JPRB,0.55904E+02_JPRB,0.74538E+02_JPRB /)  
KB(:, 1,22,16) = (/ &
 & 0.95696E+02_JPRB,0.71774E+02_JPRB,0.54631E+02_JPRB,0.73526E+02_JPRB,0.98034E+02_JPRB /)  
KB(:, 2,22,16) = (/ &
 & 0.91190E+02_JPRB,0.68395E+02_JPRB,0.51188E+02_JPRB,0.68768E+02_JPRB,0.91690E+02_JPRB /)  
KB(:, 3,22,16) = (/ &
 & 0.86939E+02_JPRB,0.65206E+02_JPRB,0.48040E+02_JPRB,0.64409E+02_JPRB,0.85879E+02_JPRB /)  
KB(:, 4,22,16) = (/ &
 & 0.82890E+02_JPRB,0.62171E+02_JPRB,0.45151E+02_JPRB,0.60441E+02_JPRB,0.80589E+02_JPRB /)  
KB(:, 5,22,16) = (/ &
 & 0.78983E+02_JPRB,0.59241E+02_JPRB,0.42494E+02_JPRB,0.56811E+02_JPRB,0.75748E+02_JPRB /)  
KB(:, 1,23,16) = (/ &
 & 0.98505E+02_JPRB,0.73881E+02_JPRB,0.55897E+02_JPRB,0.74690E+02_JPRB,0.99587E+02_JPRB /)  
KB(:, 2,23,16) = (/ &
 & 0.93651E+02_JPRB,0.70240E+02_JPRB,0.52277E+02_JPRB,0.69755E+02_JPRB,0.93007E+02_JPRB /)  
KB(:, 3,23,16) = (/ &
 & 0.89065E+02_JPRB,0.66801E+02_JPRB,0.48963E+02_JPRB,0.65256E+02_JPRB,0.87008E+02_JPRB /)  
KB(:, 4,23,16) = (/ &
 & 0.84725E+02_JPRB,0.63546E+02_JPRB,0.45949E+02_JPRB,0.61155E+02_JPRB,0.81540E+02_JPRB /)  
KB(:, 5,23,16) = (/ &
 & 0.80582E+02_JPRB,0.60440E+02_JPRB,0.43182E+02_JPRB,0.57417E+02_JPRB,0.76556E+02_JPRB /)  
KB(:, 1,24,16) = (/ &
 & 0.10064E+03_JPRB,0.75484E+02_JPRB,0.56783E+02_JPRB,0.75422E+02_JPRB,0.10056E+03_JPRB /)  
KB(:, 2,24,16) = (/ &
 & 0.95486E+02_JPRB,0.71616E+02_JPRB,0.53021E+02_JPRB,0.70355E+02_JPRB,0.93807E+02_JPRB /)  
KB(:, 3,24,16) = (/ &
 & 0.90630E+02_JPRB,0.67975E+02_JPRB,0.49592E+02_JPRB,0.65751E+02_JPRB,0.87668E+02_JPRB /)  
KB(:, 4,24,16) = (/ &
 & 0.86059E+02_JPRB,0.64548E+02_JPRB,0.46483E+02_JPRB,0.61565E+02_JPRB,0.82086E+02_JPRB /)  
KB(:, 5,24,16) = (/ &
 & 0.81718E+02_JPRB,0.61292E+02_JPRB,0.43631E+02_JPRB,0.57753E+02_JPRB,0.77003E+02_JPRB /)  
KB(:, 1,25,16) = (/ &
 & 0.10215E+03_JPRB,0.76618E+02_JPRB,0.57324E+02_JPRB,0.75759E+02_JPRB,0.10101E+03_JPRB /)  
KB(:, 2,25,16) = (/ &
 & 0.96743E+02_JPRB,0.72560E+02_JPRB,0.53446E+02_JPRB,0.70607E+02_JPRB,0.94143E+02_JPRB /)  
KB(:, 3,25,16) = (/ &
 & 0.91681E+02_JPRB,0.68763E+02_JPRB,0.49955E+02_JPRB,0.65940E+02_JPRB,0.87921E+02_JPRB /)  
KB(:, 4,25,16) = (/ &
 & 0.86919E+02_JPRB,0.65192E+02_JPRB,0.46773E+02_JPRB,0.61703E+02_JPRB,0.82270E+02_JPRB /)  
KB(:, 5,25,16) = (/ &
 & 0.82440E+02_JPRB,0.61834E+02_JPRB,0.43873E+02_JPRB,0.57842E+02_JPRB,0.77123E+02_JPRB /)  
KB(:, 1,26,16) = (/ &
 & 0.10303E+03_JPRB,0.77274E+02_JPRB,0.57519E+02_JPRB,0.75701E+02_JPRB,0.10093E+03_JPRB /)  
KB(:, 2,26,16) = (/ &
 & 0.97444E+02_JPRB,0.73085E+02_JPRB,0.53575E+02_JPRB,0.70525E+02_JPRB,0.94033E+02_JPRB /)  
KB(:, 3,26,16) = (/ &
 & 0.92222E+02_JPRB,0.69170E+02_JPRB,0.50048E+02_JPRB,0.65828E+02_JPRB,0.87771E+02_JPRB /)  
KB(:, 4,26,16) = (/ &
 & 0.87336E+02_JPRB,0.65505E+02_JPRB,0.46824E+02_JPRB,0.61566E+02_JPRB,0.82088E+02_JPRB /)  
KB(:, 5,26,16) = (/ &
 & 0.82771E+02_JPRB,0.62082E+02_JPRB,0.43909E+02_JPRB,0.57710E+02_JPRB,0.76947E+02_JPRB /)  
KB(:, 1,27,16) = (/ &
 & 0.10345E+03_JPRB,0.77590E+02_JPRB,0.57467E+02_JPRB,0.75392E+02_JPRB,0.10052E+03_JPRB /)  
KB(:, 2,27,16) = (/ &
 & 0.97739E+02_JPRB,0.73306E+02_JPRB,0.53511E+02_JPRB,0.70214E+02_JPRB,0.93619E+02_JPRB /)  
KB(:, 3,27,16) = (/ &
 & 0.92406E+02_JPRB,0.69307E+02_JPRB,0.49956E+02_JPRB,0.65525E+02_JPRB,0.87366E+02_JPRB /)  
KB(:, 4,27,16) = (/ &
 & 0.87439E+02_JPRB,0.65583E+02_JPRB,0.46715E+02_JPRB,0.61255E+02_JPRB,0.81674E+02_JPRB /)  
KB(:, 5,27,16) = (/ &
 & 0.82826E+02_JPRB,0.62123E+02_JPRB,0.43807E+02_JPRB,0.57432E+02_JPRB,0.76576E+02_JPRB /)  
KB(:, 1,28,16) = (/ &
 & 0.10350E+03_JPRB,0.77625E+02_JPRB,0.57222E+02_JPRB,0.74881E+02_JPRB,0.99841E+02_JPRB /)  
KB(:, 2,28,16) = (/ &
 & 0.97691E+02_JPRB,0.73271E+02_JPRB,0.53275E+02_JPRB,0.69730E+02_JPRB,0.92974E+02_JPRB /)  
KB(:, 3,28,16) = (/ &
 & 0.92289E+02_JPRB,0.69219E+02_JPRB,0.49719E+02_JPRB,0.65057E+02_JPRB,0.86743E+02_JPRB /)  
KB(:, 4,28,16) = (/ &
 & 0.87284E+02_JPRB,0.65466E+02_JPRB,0.46485E+02_JPRB,0.60817E+02_JPRB,0.81090E+02_JPRB /)  
KB(:, 5,28,16) = (/ &
 & 0.82640E+02_JPRB,0.61984E+02_JPRB,0.43588E+02_JPRB,0.57042E+02_JPRB,0.76055E+02_JPRB /)  
KB(:, 1,29,16) = (/ &
 & 0.10319E+03_JPRB,0.77394E+02_JPRB,0.56799E+02_JPRB,0.74179E+02_JPRB,0.98906E+02_JPRB /)  
KB(:, 2,29,16) = (/ &
 & 0.97340E+02_JPRB,0.73008E+02_JPRB,0.52885E+02_JPRB,0.69064E+02_JPRB,0.92086E+02_JPRB /)  
KB(:, 3,29,16) = (/ &
 & 0.91909E+02_JPRB,0.68935E+02_JPRB,0.49342E+02_JPRB,0.64439E+02_JPRB,0.85918E+02_JPRB /)  
KB(:, 4,29,16) = (/ &
 & 0.86890E+02_JPRB,0.65171E+02_JPRB,0.46144E+02_JPRB,0.60253E+02_JPRB,0.80337E+02_JPRB /)  
KB(:, 5,29,16) = (/ &
 & 0.82249E+02_JPRB,0.61690E+02_JPRB,0.43266E+02_JPRB,0.56539E+02_JPRB,0.75385E+02_JPRB /)  
KB(:, 1,30,16) = (/ &
 & 0.10264E+03_JPRB,0.76981E+02_JPRB,0.56267E+02_JPRB,0.73352E+02_JPRB,0.97803E+02_JPRB /)  
KB(:, 2,30,16) = (/ &
 & 0.96761E+02_JPRB,0.72573E+02_JPRB,0.52390E+02_JPRB,0.68302E+02_JPRB,0.91070E+02_JPRB /)  
KB(:, 3,30,16) = (/ &
 & 0.91349E+02_JPRB,0.68515E+02_JPRB,0.48877E+02_JPRB,0.63734E+02_JPRB,0.84978E+02_JPRB /)  
KB(:, 4,30,16) = (/ &
 & 0.86346E+02_JPRB,0.64763E+02_JPRB,0.45722E+02_JPRB,0.59615E+02_JPRB,0.79487E+02_JPRB /)  
KB(:, 5,30,16) = (/ &
 & 0.81701E+02_JPRB,0.61280E+02_JPRB,0.42874E+02_JPRB,0.55973E+02_JPRB,0.74631E+02_JPRB /)  
KB(:, 1,31,16) = (/ &
 & 0.10185E+03_JPRB,0.76389E+02_JPRB,0.55624E+02_JPRB,0.72410E+02_JPRB,0.96547E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART36',1,ZHOOK_HANDLE)
END SUBROUTINE PART36


SUBROUTINE PART37

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART37',0,ZHOOK_HANDLE)


KB(:, 2,31,16) = (/ &
 & 0.95999E+02_JPRB,0.72002E+02_JPRB,0.51796E+02_JPRB,0.67443E+02_JPRB,0.89924E+02_JPRB /)  
KB(:, 3,31,16) = (/ &
 & 0.90614E+02_JPRB,0.67963E+02_JPRB,0.48327E+02_JPRB,0.62938E+02_JPRB,0.83917E+02_JPRB /)  
KB(:, 4,31,16) = (/ &
 & 0.85645E+02_JPRB,0.64237E+02_JPRB,0.45228E+02_JPRB,0.58906E+02_JPRB,0.78542E+02_JPRB /)  
KB(:, 5,31,16) = (/ &
 & 0.81007E+02_JPRB,0.60759E+02_JPRB,0.42414E+02_JPRB,0.55328E+02_JPRB,0.73771E+02_JPRB /)  
KB(:, 1,32,16) = (/ &
 & 0.10089E+03_JPRB,0.75672E+02_JPRB,0.54904E+02_JPRB,0.71387E+02_JPRB,0.95183E+02_JPRB /)  
KB(:, 2,32,16) = (/ &
 & 0.95077E+02_JPRB,0.71310E+02_JPRB,0.51129E+02_JPRB,0.66501E+02_JPRB,0.88668E+02_JPRB /)  
KB(:, 3,32,16) = (/ &
 & 0.89743E+02_JPRB,0.67310E+02_JPRB,0.47720E+02_JPRB,0.62089E+02_JPRB,0.82785E+02_JPRB /)  
KB(:, 4,32,16) = (/ &
 & 0.84830E+02_JPRB,0.63626E+02_JPRB,0.44676E+02_JPRB,0.58147E+02_JPRB,0.77529E+02_JPRB /)  
KB(:, 5,32,16) = (/ &
 & 0.80208E+02_JPRB,0.60160E+02_JPRB,0.41909E+02_JPRB,0.54638E+02_JPRB,0.72851E+02_JPRB /)  
KB(:, 1,33,16) = (/ &
 & 0.99806E+02_JPRB,0.74857E+02_JPRB,0.54124E+02_JPRB,0.70307E+02_JPRB,0.93742E+02_JPRB /)  
KB(:, 2,33,16) = (/ &
 & 0.94060E+02_JPRB,0.70548E+02_JPRB,0.50418E+02_JPRB,0.65525E+02_JPRB,0.87366E+02_JPRB /)  
KB(:, 3,33,16) = (/ &
 & 0.88780E+02_JPRB,0.66588E+02_JPRB,0.47080E+02_JPRB,0.61195E+02_JPRB,0.81594E+02_JPRB /)  
KB(:, 4,33,16) = (/ &
 & 0.83926E+02_JPRB,0.62948E+02_JPRB,0.44091E+02_JPRB,0.57369E+02_JPRB,0.76493E+02_JPRB /)  
KB(:, 5,33,16) = (/ &
 & 0.79342E+02_JPRB,0.59511E+02_JPRB,0.41372E+02_JPRB,0.53910E+02_JPRB,0.71880E+02_JPRB /)  
KB(:, 1,34,16) = (/ &
 & 0.98842E+02_JPRB,0.74134E+02_JPRB,0.53446E+02_JPRB,0.69373E+02_JPRB,0.92498E+02_JPRB /)  
KB(:, 2,34,16) = (/ &
 & 0.93169E+02_JPRB,0.69879E+02_JPRB,0.49796E+02_JPRB,0.64672E+02_JPRB,0.86229E+02_JPRB /)  
KB(:, 3,34,16) = (/ &
 & 0.87940E+02_JPRB,0.65958E+02_JPRB,0.46525E+02_JPRB,0.60437E+02_JPRB,0.80583E+02_JPRB /)  
KB(:, 4,34,16) = (/ &
 & 0.83124E+02_JPRB,0.62347E+02_JPRB,0.43581E+02_JPRB,0.56689E+02_JPRB,0.75585E+02_JPRB /)  
KB(:, 5,34,16) = (/ &
 & 0.78566E+02_JPRB,0.58929E+02_JPRB,0.40900E+02_JPRB,0.53287E+02_JPRB,0.71049E+02_JPRB /)  
KB(:, 1,35,16) = (/ &
 & 0.98383E+02_JPRB,0.73790E+02_JPRB,0.53104E+02_JPRB,0.68893E+02_JPRB,0.91857E+02_JPRB /)  
KB(:, 2,35,16) = (/ &
 & 0.92731E+02_JPRB,0.69551E+02_JPRB,0.49484E+02_JPRB,0.64233E+02_JPRB,0.85643E+02_JPRB /)  
KB(:, 3,35,16) = (/ &
 & 0.87537E+02_JPRB,0.65656E+02_JPRB,0.46247E+02_JPRB,0.60050E+02_JPRB,0.80067E+02_JPRB /)  
KB(:, 4,35,16) = (/ &
 & 0.82730E+02_JPRB,0.62051E+02_JPRB,0.43325E+02_JPRB,0.56336E+02_JPRB,0.75115E+02_JPRB /)  
KB(:, 5,35,16) = (/ &
 & 0.78184E+02_JPRB,0.58642E+02_JPRB,0.40664E+02_JPRB,0.52959E+02_JPRB,0.70611E+02_JPRB /)  
KB(:, 1,36,16) = (/ &
 & 0.98510E+02_JPRB,0.73885E+02_JPRB,0.53153E+02_JPRB,0.68921E+02_JPRB,0.91895E+02_JPRB /)  
KB(:, 2,36,16) = (/ &
 & 0.92845E+02_JPRB,0.69637E+02_JPRB,0.49525E+02_JPRB,0.64248E+02_JPRB,0.85664E+02_JPRB /)  
KB(:, 3,36,16) = (/ &
 & 0.87626E+02_JPRB,0.65723E+02_JPRB,0.46281E+02_JPRB,0.60067E+02_JPRB,0.80090E+02_JPRB /)  
KB(:, 4,36,16) = (/ &
 & 0.82805E+02_JPRB,0.62108E+02_JPRB,0.43352E+02_JPRB,0.56351E+02_JPRB,0.75135E+02_JPRB /)  
KB(:, 5,36,16) = (/ &
 & 0.78246E+02_JPRB,0.58689E+02_JPRB,0.40687E+02_JPRB,0.52970E+02_JPRB,0.70627E+02_JPRB /)  
KB(:, 1,37,16) = (/ &
 & 0.99499E+02_JPRB,0.74626E+02_JPRB,0.53765E+02_JPRB,0.69681E+02_JPRB,0.92907E+02_JPRB /)  
KB(:, 2,37,16) = (/ &
 & 0.93737E+02_JPRB,0.70305E+02_JPRB,0.50072E+02_JPRB,0.64938E+02_JPRB,0.86584E+02_JPRB /)  
KB(:, 3,37,16) = (/ &
 & 0.88443E+02_JPRB,0.66336E+02_JPRB,0.46765E+02_JPRB,0.60669E+02_JPRB,0.80892E+02_JPRB /)  
KB(:, 4,37,16) = (/ &
 & 0.83569E+02_JPRB,0.62680E+02_JPRB,0.43792E+02_JPRB,0.56887E+02_JPRB,0.75849E+02_JPRB /)  
KB(:, 5,37,16) = (/ &
 & 0.78959E+02_JPRB,0.59223E+02_JPRB,0.41087E+02_JPRB,0.53464E+02_JPRB,0.71286E+02_JPRB /)  
KB(:, 1,38,16) = (/ &
 & 0.10053E+03_JPRB,0.75401E+02_JPRB,0.54401E+02_JPRB,0.70469E+02_JPRB,0.93958E+02_JPRB /)  
KB(:, 2,38,16) = (/ &
 & 0.94665E+02_JPRB,0.71001E+02_JPRB,0.50643E+02_JPRB,0.65651E+02_JPRB,0.87535E+02_JPRB /)  
KB(:, 3,38,16) = (/ &
 & 0.89287E+02_JPRB,0.66968E+02_JPRB,0.47272E+02_JPRB,0.61298E+02_JPRB,0.81730E+02_JPRB /)  
KB(:, 4,38,16) = (/ &
 & 0.84354E+02_JPRB,0.63269E+02_JPRB,0.44250E+02_JPRB,0.57455E+02_JPRB,0.76607E+02_JPRB /)  
KB(:, 5,38,16) = (/ &
 & 0.79688E+02_JPRB,0.59770E+02_JPRB,0.41502E+02_JPRB,0.53978E+02_JPRB,0.71970E+02_JPRB /)  
KB(:, 1,39,16) = (/ &
 & 0.10152E+03_JPRB,0.76145E+02_JPRB,0.55030E+02_JPRB,0.71266E+02_JPRB,0.95022E+02_JPRB /)  
KB(:, 2,39,16) = (/ &
 & 0.95574E+02_JPRB,0.71683E+02_JPRB,0.51208E+02_JPRB,0.66359E+02_JPRB,0.88479E+02_JPRB /)  
KB(:, 3,39,16) = (/ &
 & 0.90127E+02_JPRB,0.67598E+02_JPRB,0.47776E+02_JPRB,0.61934E+02_JPRB,0.82579E+02_JPRB /)  
KB(:, 4,39,16) = (/ &
 & 0.85122E+02_JPRB,0.63845E+02_JPRB,0.44704E+02_JPRB,0.58015E+02_JPRB,0.77353E+02_JPRB /)  
KB(:, 5,39,16) = (/ &
 & 0.80410E+02_JPRB,0.60311E+02_JPRB,0.41916E+02_JPRB,0.54486E+02_JPRB,0.72649E+02_JPRB /)  
KB(:, 1,40,16) = (/ &
 & 0.10316E+03_JPRB,0.77371E+02_JPRB,0.56077E+02_JPRB,0.72600E+02_JPRB,0.96800E+02_JPRB /)  
KB(:, 2,40,16) = (/ &
 & 0.97060E+02_JPRB,0.72797E+02_JPRB,0.52149E+02_JPRB,0.67558E+02_JPRB,0.90077E+02_JPRB /)  
KB(:, 3,40,16) = (/ &
 & 0.91509E+02_JPRB,0.68635E+02_JPRB,0.48618E+02_JPRB,0.63010E+02_JPRB,0.84013E+02_JPRB /)  
KB(:, 4,40,16) = (/ &
 & 0.86384E+02_JPRB,0.64791E+02_JPRB,0.45460E+02_JPRB,0.58959E+02_JPRB,0.78612E+02_JPRB /)  
KB(:, 5,40,16) = (/ &
 & 0.81600E+02_JPRB,0.61204E+02_JPRB,0.42605E+02_JPRB,0.55349E+02_JPRB,0.73798E+02_JPRB /)  
KB(:, 1,41,16) = (/ &
 & 0.10490E+03_JPRB,0.78677E+02_JPRB,0.57202E+02_JPRB,0.74030E+02_JPRB,0.98707E+02_JPRB /)  
KB(:, 2,41,16) = (/ &
 & 0.98655E+02_JPRB,0.73994E+02_JPRB,0.53155E+02_JPRB,0.68836E+02_JPRB,0.91782E+02_JPRB /)  
KB(:, 3,41,16) = (/ &
 & 0.92964E+02_JPRB,0.69726E+02_JPRB,0.49517E+02_JPRB,0.64156E+02_JPRB,0.85541E+02_JPRB /)  
KB(:, 4,41,16) = (/ &
 & 0.87720E+02_JPRB,0.65793E+02_JPRB,0.46275E+02_JPRB,0.59984E+02_JPRB,0.79978E+02_JPRB /)  
KB(:, 5,41,16) = (/ &
 & 0.82858E+02_JPRB,0.62147E+02_JPRB,0.43340E+02_JPRB,0.56275E+02_JPRB,0.75033E+02_JPRB /)  
KB(:, 1,42,16) = (/ &
 & 0.10666E+03_JPRB,0.79997E+02_JPRB,0.58340E+02_JPRB,0.75485E+02_JPRB,0.10065E+03_JPRB /)  
KB(:, 2,42,16) = (/ &
 & 0.10028E+03_JPRB,0.75211E+02_JPRB,0.54189E+02_JPRB,0.70153E+02_JPRB,0.93537E+02_JPRB /)  
KB(:, 3,42,16) = (/ &
 & 0.94432E+02_JPRB,0.70827E+02_JPRB,0.50443E+02_JPRB,0.65340E+02_JPRB,0.87121E+02_JPRB /)  
KB(:, 4,42,16) = (/ &
 & 0.89075E+02_JPRB,0.66809E+02_JPRB,0.47102E+02_JPRB,0.61032E+02_JPRB,0.81376E+02_JPRB /)  
KB(:, 5,42,16) = (/ &
 & 0.84125E+02_JPRB,0.63097E+02_JPRB,0.44086E+02_JPRB,0.57211E+02_JPRB,0.76281E+02_JPRB /)  
KB(:, 1,43,16) = (/ &
 & 0.10883E+03_JPRB,0.81624E+02_JPRB,0.59771E+02_JPRB,0.77309E+02_JPRB,0.10308E+03_JPRB /)  
KB(:, 2,43,16) = (/ &
 & 0.10228E+03_JPRB,0.76711E+02_JPRB,0.55476E+02_JPRB,0.71797E+02_JPRB,0.95729E+02_JPRB /)  
KB(:, 3,43,16) = (/ &
 & 0.96257E+02_JPRB,0.72196E+02_JPRB,0.51599E+02_JPRB,0.66824E+02_JPRB,0.89098E+02_JPRB /)  
KB(:, 4,43,16) = (/ &
 & 0.90745E+02_JPRB,0.68062E+02_JPRB,0.48126E+02_JPRB,0.62350E+02_JPRB,0.83134E+02_JPRB /)  
KB(:, 5,43,16) = (/ &
 & 0.85682E+02_JPRB,0.64265E+02_JPRB,0.45017E+02_JPRB,0.58380E+02_JPRB,0.77840E+02_JPRB /)  
KB(:, 1,44,16) = (/ &
 & 0.11122E+03_JPRB,0.83416E+02_JPRB,0.61378E+02_JPRB,0.79350E+02_JPRB,0.10580E+03_JPRB /)  
KB(:, 2,44,16) = (/ &
 & 0.10448E+03_JPRB,0.78362E+02_JPRB,0.56905E+02_JPRB,0.73629E+02_JPRB,0.98171E+02_JPRB /)  
KB(:, 3,44,16) = (/ &
 & 0.98280E+02_JPRB,0.73712E+02_JPRB,0.52886E+02_JPRB,0.68474E+02_JPRB,0.91299E+02_JPRB /)  
KB(:, 4,44,16) = (/ &
 & 0.92614E+02_JPRB,0.69464E+02_JPRB,0.49277E+02_JPRB,0.63819E+02_JPRB,0.85092E+02_JPRB /)  
KB(:, 5,44,16) = (/ &
 & 0.87390E+02_JPRB,0.65546E+02_JPRB,0.46054E+02_JPRB,0.59688E+02_JPRB,0.79585E+02_JPRB /)  
KB(:, 1,45,16) = (/ &
 & 0.11367E+03_JPRB,0.85251E+02_JPRB,0.63043E+02_JPRB,0.81458E+02_JPRB,0.10861E+03_JPRB /)  
KB(:, 2,45,16) = (/ &
 & 0.10674E+03_JPRB,0.80056E+02_JPRB,0.58377E+02_JPRB,0.75516E+02_JPRB,0.10069E+03_JPRB /)  
KB(:, 3,45,16) = (/ &
 & 0.10036E+03_JPRB,0.75271E+02_JPRB,0.54217E+02_JPRB,0.70172E+02_JPRB,0.93562E+02_JPRB /)  
KB(:, 4,45,16) = (/ &
 & 0.94507E+02_JPRB,0.70883E+02_JPRB,0.50472E+02_JPRB,0.65352E+02_JPRB,0.87137E+02_JPRB /)  
KB(:, 5,45,16) = (/ &
 & 0.89124E+02_JPRB,0.66846E+02_JPRB,0.47119E+02_JPRB,0.61044E+02_JPRB,0.81393E+02_JPRB /)  
KB(:, 1,46,16) = (/ &
 & 0.11634E+03_JPRB,0.87256E+02_JPRB,0.64886E+02_JPRB,0.83772E+02_JPRB,0.11170E+03_JPRB /)  
KB(:, 2,46,16) = (/ &
 & 0.10921E+03_JPRB,0.81909E+02_JPRB,0.60009E+02_JPRB,0.77600E+02_JPRB,0.10347E+03_JPRB /)  
KB(:, 3,46,16) = (/ &
 & 0.10262E+03_JPRB,0.76969E+02_JPRB,0.55682E+02_JPRB,0.72046E+02_JPRB,0.96062E+02_JPRB /)  
KB(:, 4,46,16) = (/ &
 & 0.96578E+02_JPRB,0.72436E+02_JPRB,0.51790E+02_JPRB,0.67050E+02_JPRB,0.89399E+02_JPRB /)  
KB(:, 5,46,16) = (/ &
 & 0.91036E+02_JPRB,0.68280E+02_JPRB,0.48293E+02_JPRB,0.62556E+02_JPRB,0.83408E+02_JPRB /)  
KB(:, 1,47,16) = (/ &
 & 0.11944E+03_JPRB,0.89580E+02_JPRB,0.67039E+02_JPRB,0.86470E+02_JPRB,0.11529E+03_JPRB /)  
KB(:, 2,47,16) = (/ &
 & 0.11203E+03_JPRB,0.84025E+02_JPRB,0.61916E+02_JPRB,0.80032E+02_JPRB,0.10671E+03_JPRB /)  
KB(:, 3,47,16) = (/ &
 & 0.10523E+03_JPRB,0.78928E+02_JPRB,0.57378E+02_JPRB,0.74229E+02_JPRB,0.98972E+02_JPRB /)  
KB(:, 4,47,16) = (/ &
 & 0.98975E+02_JPRB,0.74234E+02_JPRB,0.53317E+02_JPRB,0.69003E+02_JPRB,0.92005E+02_JPRB /)  
KB(:, 5,47,16) = (/ &
 & 0.93247E+02_JPRB,0.69938E+02_JPRB,0.49666E+02_JPRB,0.64309E+02_JPRB,0.85745E+02_JPRB /)  
KB(:, 1,48,16) = (/ &
 & 0.12267E+03_JPRB,0.92006E+02_JPRB,0.69290E+02_JPRB,0.89280E+02_JPRB,0.11904E+03_JPRB /)  
KB(:, 2,48,16) = (/ &
 & 0.11495E+03_JPRB,0.86215E+02_JPRB,0.63917E+02_JPRB,0.82556E+02_JPRB,0.11008E+03_JPRB /)  
KB(:, 3,48,16) = (/ &
 & 0.10793E+03_JPRB,0.80951E+02_JPRB,0.59146E+02_JPRB,0.76493E+02_JPRB,0.10199E+03_JPRB /)  
KB(:, 4,48,16) = (/ &
 & 0.10147E+03_JPRB,0.76101E+02_JPRB,0.54918E+02_JPRB,0.71050E+02_JPRB,0.94733E+02_JPRB /)  
KB(:, 5,48,16) = (/ &
 & 0.95498E+02_JPRB,0.71626E+02_JPRB,0.51095E+02_JPRB,0.66155E+02_JPRB,0.88207E+02_JPRB /)  
KB(:, 1,49,16) = (/ &
 & 0.12603E+03_JPRB,0.94521E+02_JPRB,0.71680E+02_JPRB,0.92236E+02_JPRB,0.12298E+03_JPRB /)  
KB(:, 2,49,16) = (/ &
 & 0.11801E+03_JPRB,0.88509E+02_JPRB,0.66027E+02_JPRB,0.85192E+02_JPRB,0.11359E+03_JPRB /)  
KB(:, 3,49,16) = (/ &
 & 0.11070E+03_JPRB,0.83029E+02_JPRB,0.61003E+02_JPRB,0.78868E+02_JPRB,0.10516E+03_JPRB /)  
KB(:, 4,49,16) = (/ &
 & 0.10402E+03_JPRB,0.78016E+02_JPRB,0.56578E+02_JPRB,0.73185E+02_JPRB,0.97580E+02_JPRB /)  
KB(:, 5,49,16) = (/ &
 & 0.97847E+02_JPRB,0.73387E+02_JPRB,0.52593E+02_JPRB,0.68075E+02_JPRB,0.90767E+02_JPRB /)  
KB(:, 1,50,16) = (/ &
 & 0.12933E+03_JPRB,0.96996E+02_JPRB,0.74078E+02_JPRB,0.95132E+02_JPRB,0.12684E+03_JPRB /)  
KB(:, 2,50,16) = (/ &
 & 0.12097E+03_JPRB,0.90726E+02_JPRB,0.68085E+02_JPRB,0.87768E+02_JPRB,0.11702E+03_JPRB /)  
KB(:, 3,50,16) = (/ &
 & 0.11343E+03_JPRB,0.85073E+02_JPRB,0.62849E+02_JPRB,0.81185E+02_JPRB,0.10825E+03_JPRB /)  
KB(:, 4,50,16) = (/ &
 & 0.10650E+03_JPRB,0.79879E+02_JPRB,0.58193E+02_JPRB,0.75257E+02_JPRB,0.10034E+03_JPRB /)  
KB(:, 5,50,16) = (/ &
 & 0.10012E+03_JPRB,0.75094E+02_JPRB,0.54050E+02_JPRB,0.69940E+02_JPRB,0.93253E+02_JPRB /)  
KB(:, 1,51,16) = (/ &
 & 0.13262E+03_JPRB,0.99463E+02_JPRB,0.76537E+02_JPRB,0.98089E+02_JPRB,0.13079E+03_JPRB /)  
KB(:, 2,51,16) = (/ &
 & 0.12396E+03_JPRB,0.92972E+02_JPRB,0.70180E+02_JPRB,0.90371E+02_JPRB,0.12049E+03_JPRB /)  
KB(:, 3,51,16) = (/ &
 & 0.11611E+03_JPRB,0.87085E+02_JPRB,0.64700E+02_JPRB,0.83525E+02_JPRB,0.11137E+03_JPRB /)  
KB(:, 4,51,16) = (/ &
 & 0.10897E+03_JPRB,0.81728E+02_JPRB,0.59829E+02_JPRB,0.77356E+02_JPRB,0.10314E+03_JPRB /)  
KB(:, 5,51,16) = (/ &
 & 0.10241E+03_JPRB,0.76807E+02_JPRB,0.55526E+02_JPRB,0.71828E+02_JPRB,0.95771E+02_JPRB /)  
KB(:, 1,52,16) = (/ &
 & 0.13607E+03_JPRB,0.10205E+03_JPRB,0.79117E+02_JPRB,0.10117E+03_JPRB,0.13489E+03_JPRB /)  
KB(:, 2,52,16) = (/ &
 & 0.12703E+03_JPRB,0.95276E+02_JPRB,0.72382E+02_JPRB,0.93082E+02_JPRB,0.12411E+03_JPRB /)  
KB(:, 3,52,16) = (/ &
 & 0.11888E+03_JPRB,0.89162E+02_JPRB,0.66631E+02_JPRB,0.85943E+02_JPRB,0.11459E+03_JPRB /)  
KB(:, 4,52,16) = (/ &
 & 0.11155E+03_JPRB,0.83666E+02_JPRB,0.61557E+02_JPRB,0.79542E+02_JPRB,0.10606E+03_JPRB /)  
KB(:, 5,52,16) = (/ &
 & 0.10475E+03_JPRB,0.78563E+02_JPRB,0.57053E+02_JPRB,0.73794E+02_JPRB,0.98392E+02_JPRB /)  
KB(:, 1,53,16) = (/ &
 & 0.13969E+03_JPRB,0.10477E+03_JPRB,0.81852E+02_JPRB,0.10445E+03_JPRB,0.13926E+03_JPRB /)  
KB(:, 2,53,16) = (/ &
 & 0.13021E+03_JPRB,0.97660E+02_JPRB,0.74731E+02_JPRB,0.95923E+02_JPRB,0.12790E+03_JPRB /)  
KB(:, 3,53,16) = (/ &
 & 0.12178E+03_JPRB,0.91333E+02_JPRB,0.68644E+02_JPRB,0.88461E+02_JPRB,0.11795E+03_JPRB /)  
KB(:, 4,53,16) = (/ &
 & 0.11417E+03_JPRB,0.85628E+02_JPRB,0.63346E+02_JPRB,0.81812E+02_JPRB,0.10908E+03_JPRB /)  
KB(:, 5,53,16) = (/ &
 & 0.10716E+03_JPRB,0.80376E+02_JPRB,0.58630E+02_JPRB,0.75816E+02_JPRB,0.10109E+03_JPRB /)  
KB(:, 1,54,16) = (/ &
 & 0.14312E+03_JPRB,0.10734E+03_JPRB,0.84505E+02_JPRB,0.10757E+03_JPRB,0.14343E+03_JPRB /)  
KB(:, 2,54,16) = (/ &
 & 0.13326E+03_JPRB,0.99943E+02_JPRB,0.77008E+02_JPRB,0.98653E+02_JPRB,0.13154E+03_JPRB /)  
KB(:, 3,54,16) = (/ &
 & 0.12453E+03_JPRB,0.93400E+02_JPRB,0.70583E+02_JPRB,0.90867E+02_JPRB,0.12116E+03_JPRB /)  
KB(:, 4,54,16) = (/ &
 & 0.11663E+03_JPRB,0.87472E+02_JPRB,0.65055E+02_JPRB,0.83971E+02_JPRB,0.11196E+03_JPRB /)  
KB(:, 5,54,16) = (/ &
 & 0.10944E+03_JPRB,0.82085E+02_JPRB,0.60143E+02_JPRB,0.77761E+02_JPRB,0.10368E+03_JPRB /)  
KB(:, 1,55,16) = (/ &
 & 0.14652E+03_JPRB,0.10989E+03_JPRB,0.87185E+02_JPRB,0.11072E+03_JPRB,0.14762E+03_JPRB /)  
KB(:, 2,55,16) = (/ &
 & 0.13631E+03_JPRB,0.10223E+03_JPRB,0.79292E+02_JPRB,0.10139E+03_JPRB,0.13518E+03_JPRB /)  
KB(:, 3,55,16) = (/ &
 & 0.12725E+03_JPRB,0.95436E+02_JPRB,0.72534E+02_JPRB,0.93260E+02_JPRB,0.12435E+03_JPRB /)  
KB(:, 4,55,16) = (/ &
 & 0.11908E+03_JPRB,0.89315E+02_JPRB,0.66761E+02_JPRB,0.86100E+02_JPRB,0.11480E+03_JPRB /)  
KB(:, 5,55,16) = (/ &
 & 0.11172E+03_JPRB,0.83789E+02_JPRB,0.61666E+02_JPRB,0.79683E+02_JPRB,0.10624E+03_JPRB /)  
KB(:, 1,56,16) = (/ &
 & 0.15005E+03_JPRB,0.11254E+03_JPRB,0.89964E+02_JPRB,0.11399E+03_JPRB,0.15199E+03_JPRB /)  
KB(:, 2,56,16) = (/ &
 & 0.13946E+03_JPRB,0.10459E+03_JPRB,0.81673E+02_JPRB,0.10424E+03_JPRB,0.13899E+03_JPRB /)  
KB(:, 3,56,16) = (/ &
 & 0.13002E+03_JPRB,0.97512E+02_JPRB,0.74583E+02_JPRB,0.95730E+02_JPRB,0.12764E+03_JPRB /)  
KB(:, 4,56,16) = (/ &
 & 0.12160E+03_JPRB,0.91205E+02_JPRB,0.68519E+02_JPRB,0.88312E+02_JPRB,0.11775E+03_JPRB /)  
KB(:, 5,56,16) = (/ &
 & 0.11401E+03_JPRB,0.85509E+02_JPRB,0.63233E+02_JPRB,0.81665E+02_JPRB,0.10889E+03_JPRB /)  
KB(:, 1,57,16) = (/ &
 & 0.15367E+03_JPRB,0.11525E+03_JPRB,0.92893E+02_JPRB,0.11745E+03_JPRB,0.15659E+03_JPRB /)  
KB(:, 2,57,16) = (/ &
 & 0.14273E+03_JPRB,0.10705E+03_JPRB,0.84201E+02_JPRB,0.10722E+03_JPRB,0.14296E+03_JPRB /)  
KB(:, 3,57,16) = (/ &
 & 0.13291E+03_JPRB,0.99681E+02_JPRB,0.76750E+02_JPRB,0.98336E+02_JPRB,0.13111E+03_JPRB /)  
KB(:, 4,57,16) = (/ &
 & 0.12423E+03_JPRB,0.93171E+02_JPRB,0.70357E+02_JPRB,0.90589E+02_JPRB,0.12079E+03_JPRB /)  
KB(:, 5,57,16) = (/ &
 & 0.11636E+03_JPRB,0.87269E+02_JPRB,0.64859E+02_JPRB,0.83719E+02_JPRB,0.11162E+03_JPRB /)  
KB(:, 1,58,16) = (/ &
 & 0.15720E+03_JPRB,0.11790E+03_JPRB,0.95809E+02_JPRB,0.12090E+03_JPRB,0.16121E+03_JPRB /)  
KB(:, 2,58,16) = (/ &
 & 0.14594E+03_JPRB,0.10946E+03_JPRB,0.86713E+02_JPRB,0.11017E+03_JPRB,0.14690E+03_JPRB /)  
KB(:, 3,58,16) = (/ &
 & 0.13577E+03_JPRB,0.10183E+03_JPRB,0.78898E+02_JPRB,0.10090E+03_JPRB,0.13454E+03_JPRB /)  
KB(:, 4,58,16) = (/ &
 & 0.12678E+03_JPRB,0.95087E+02_JPRB,0.72188E+02_JPRB,0.92844E+02_JPRB,0.12379E+03_JPRB /)  
KB(:, 5,58,16) = (/ &
 & 0.11865E+03_JPRB,0.88989E+02_JPRB,0.66460E+02_JPRB,0.85728E+02_JPRB,0.11430E+03_JPRB /)  
KB(:, 1,59,16) = (/ &
 & 0.15867E+03_JPRB,0.11900E+03_JPRB,0.97023E+02_JPRB,0.12235E+03_JPRB,0.16313E+03_JPRB /)  
KB(:, 2,59,16) = (/ &
 & 0.14725E+03_JPRB,0.11044E+03_JPRB,0.87747E+02_JPRB,0.11139E+03_JPRB,0.14852E+03_JPRB /)  
KB(:, 3,59,16) = (/ &
 & 0.13696E+03_JPRB,0.10272E+03_JPRB,0.79780E+02_JPRB,0.10196E+03_JPRB,0.13595E+03_JPRB /)  
KB(:, 4,59,16) = (/ &
 & 0.12782E+03_JPRB,0.95865E+02_JPRB,0.72946E+02_JPRB,0.93765E+02_JPRB,0.12502E+03_JPRB /)  
KB(:, 5,59,16) = (/ &
 & 0.11961E+03_JPRB,0.89706E+02_JPRB,0.67116E+02_JPRB,0.86544E+02_JPRB,0.11539E+03_JPRB /)  

!     -----------------------------------------------------------------


IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART37',1,ZHOOK_HANDLE)
END SUBROUTINE PART37


SUBROUTINE PART38

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART38',0,ZHOOK_HANDLE)


FORREF(:, 1) = (/ 0.110008E-06_JPRB, 0.630912E-06_JPRB, 0.363159E-05_JPRB, 0.616892E-05_JPRB /)
FORREF(:, 2) = (/ 0.429709E-05_JPRB, 0.789174E-05_JPRB, 0.217416E-04_JPRB, 0.639393E-04_JPRB /)
FORREF(:, 3) = (/ 0.436283E-04_JPRB, 0.526247E-04_JPRB, 0.116341E-03_JPRB, 0.205616E-03_JPRB /)
FORREF(:, 4) = (/ 0.215627E-03_JPRB, 0.234522E-03_JPRB, 0.280497E-03_JPRB, 0.838668E-03_JPRB /)
FORREF(:, 5) = (/ 0.529283E-03_JPRB, 0.620848E-03_JPRB, 0.935561E-03_JPRB, 0.171252E-02_JPRB /)
FORREF(:, 6) = (/ 0.212267E-02_JPRB, 0.218564E-02_JPRB, 0.222227E-02_JPRB, 0.199650E-02_JPRB /)
FORREF(:, 7) = (/ 0.291120E-02_JPRB, 0.281168E-02_JPRB, 0.259543E-02_JPRB, 0.210159E-02_JPRB /)
FORREF(:, 8) = (/ 0.316249E-02_JPRB, 0.310695E-02_JPRB, 0.279501E-02_JPRB, 0.208076E-02_JPRB /)
FORREF(:, 9) = (/ 0.354993E-02_JPRB, 0.336989E-02_JPRB, 0.298930E-02_JPRB, 0.180424E-02_JPRB /)
FORREF(:,10) = (/ 0.397729E-02_JPRB, 0.367409E-02_JPRB, 0.328982E-02_JPRB, 0.177807E-02_JPRB /)
FORREF(:,11) = (/ 0.408831E-02_JPRB, 0.398792E-02_JPRB, 0.352727E-02_JPRB, 0.192470E-02_JPRB /)
FORREF(:,12) = (/ 0.433926E-02_JPRB, 0.420667E-02_JPRB, 0.383894E-02_JPRB, 0.220836E-02_JPRB /)
FORREF(:,13) = (/ 0.436397E-02_JPRB, 0.433769E-02_JPRB, 0.425752E-02_JPRB, 0.237343E-02_JPRB /)
FORREF(:,14) = (/ 0.440525E-02_JPRB, 0.449018E-02_JPRB, 0.451881E-02_JPRB, 0.269169E-02_JPRB /)
FORREF(:,15) = (/ 0.491350E-02_JPRB, 0.481760E-02_JPRB, 0.475799E-02_JPRB, 0.362666E-02_JPRB /)
FORREF(:,16) = (/ 0.561641E-02_JPRB, 0.524553E-02_JPRB, 0.512473E-02_JPRB, 0.493802E-02_JPRB /)

!     -----------------------------------------------------------------
!     The array SELFREF contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREF(:, 1) = (/ &
 & 0.115887E-03_JPRB, 0.926537E-04_JPRB, 0.740783E-04_JPRB, 0.592270E-04_JPRB, 0.473530E-04_JPRB, &
 & 0.378596E-04_JPRB, 0.302694E-04_JPRB, 0.242010E-04_JPRB, 0.193491E-04_JPRB, 0.154700E-04_JPRB /)  
SELFREF(:, 2) = (/ &
 & 0.459557E-03_JPRB, 0.381962E-03_JPRB, 0.317469E-03_JPRB, 0.263866E-03_JPRB, 0.219313E-03_JPRB, &
 & 0.182283E-03_JPRB, 0.151505E-03_JPRB, 0.125924E-03_JPRB, 0.104662E-03_JPRB, 0.869904E-04_JPRB /)  
SELFREF(:, 3) = (/ &
 & 0.166821E-02_JPRB, 0.151103E-02_JPRB, 0.136866E-02_JPRB, 0.123970E-02_JPRB, 0.112290E-02_JPRB, &
 & 0.101710E-02_JPRB, 0.921266E-03_JPRB, 0.834463E-03_JPRB, 0.755839E-03_JPRB, 0.684623E-03_JPRB /)  
SELFREF(:, 4) = (/ &
 & 0.460175E-02_JPRB, 0.421372E-02_JPRB, 0.385842E-02_JPRB, 0.353307E-02_JPRB, 0.323516E-02_JPRB, &
 & 0.296236E-02_JPRB, 0.271257E-02_JPRB, 0.248385E-02_JPRB, 0.227440E-02_JPRB, 0.208262E-02_JPRB /)  
SELFREF(:, 5) = (/ &
 & 0.101589E-01_JPRB, 0.924742E-02_JPRB, 0.841772E-02_JPRB, 0.766247E-02_JPRB, 0.697497E-02_JPRB, &
 & 0.634917E-02_JPRB, 0.577951E-02_JPRB, 0.526096E-02_JPRB, 0.478893E-02_JPRB, 0.435926E-02_JPRB /)  
SELFREF(:, 6) = (/ &
 & 0.328043E-01_JPRB, 0.300853E-01_JPRB, 0.275917E-01_JPRB, 0.253048E-01_JPRB, 0.232075E-01_JPRB, &
 & 0.212839E-01_JPRB, 0.195198E-01_JPRB, 0.179020E-01_JPRB, 0.164182E-01_JPRB, 0.150574E-01_JPRB /)  
SELFREF(:, 7) = (/ &
 & 0.405936E-01_JPRB, 0.376032E-01_JPRB, 0.348331E-01_JPRB, 0.322671E-01_JPRB, 0.298901E-01_JPRB, &
 & 0.276883E-01_JPRB, 0.256486E-01_JPRB, 0.237591E-01_JPRB, 0.220089E-01_JPRB, 0.203876E-01_JPRB /)  
SELFREF(:, 8) = (/ &
 & 0.448362E-01_JPRB, 0.413811E-01_JPRB, 0.381923E-01_JPRB, 0.352492E-01_JPRB, 0.325329E-01_JPRB, &
 & 0.300259E-01_JPRB, 0.277121E-01_JPRB, 0.255766E-01_JPRB, 0.236056E-01_JPRB, 0.217866E-01_JPRB /)  
SELFREF(:, 9) = (/ &
 & 0.479741E-01_JPRB, 0.445389E-01_JPRB, 0.413497E-01_JPRB, 0.383889E-01_JPRB, 0.356400E-01_JPRB, &
 & 0.330880E-01_JPRB, 0.307188E-01_JPRB, 0.285191E-01_JPRB, 0.264770E-01_JPRB, 0.245812E-01_JPRB /)  
SELFREF(:,10) = (/ &
 & 0.519308E-01_JPRB, 0.484130E-01_JPRB, 0.451335E-01_JPRB, 0.420761E-01_JPRB, 0.392259E-01_JPRB, &
 & 0.365687E-01_JPRB, 0.340916E-01_JPRB, 0.317822E-01_JPRB, 0.296293E-01_JPRB, 0.276222E-01_JPRB /)  
SELFREF(:,11) = (/ &
 & 0.572039E-01_JPRB, 0.527780E-01_JPRB, 0.486945E-01_JPRB, 0.449270E-01_JPRB, 0.414510E-01_JPRB, &
 & 0.382439E-01_JPRB, 0.352849E-01_JPRB, 0.325549E-01_JPRB, 0.300361E-01_JPRB, 0.277122E-01_JPRB /)  
SELFREF(:,12) = (/ &
 & 0.601046E-01_JPRB, 0.554411E-01_JPRB, 0.511395E-01_JPRB, 0.471716E-01_JPRB, 0.435116E-01_JPRB, &
 & 0.401356E-01_JPRB, 0.370215E-01_JPRB, 0.341490E-01_JPRB, 0.314994E-01_JPRB, 0.290554E-01_JPRB /)  
SELFREF(:,13) = (/ &
 & 0.616595E-01_JPRB, 0.567145E-01_JPRB, 0.521662E-01_JPRB, 0.479826E-01_JPRB, 0.441346E-01_JPRB, &
 & 0.405951E-01_JPRB, 0.373395E-01_JPRB, 0.343450E-01_JPRB, 0.315906E-01_JPRB, 0.290571E-01_JPRB /)  
SELFREF(:,14) = (/ &
 & 0.647916E-01_JPRB, 0.592493E-01_JPRB, 0.541811E-01_JPRB, 0.495465E-01_JPRB, 0.453083E-01_JPRB, &
 & 0.414326E-01_JPRB, 0.378885E-01_JPRB, 0.346475E-01_JPRB, 0.316837E-01_JPRB, 0.289735E-01_JPRB /)  
SELFREF(:,15) = (/ &
 & 0.694231E-01_JPRB, 0.637703E-01_JPRB, 0.585777E-01_JPRB, 0.538079E-01_JPRB, 0.494265E-01_JPRB, &
 & 0.454019E-01_JPRB, 0.417050E-01_JPRB, 0.383091E-01_JPRB, 0.351897E-01_JPRB, 0.323244E-01_JPRB /)  
SELFREF(:,16) = (/ &
 & 0.761764E-01_JPRB, 0.701815E-01_JPRB, 0.646584E-01_JPRB, 0.595700E-01_JPRB, 0.548820E-01_JPRB, &
 & 0.505629E-01_JPRB, 0.465838E-01_JPRB, 0.429178E-01_JPRB, 0.395403E-01_JPRB, 0.364286E-01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB21:PART38',1,ZHOOK_HANDLE)
END SUBROUTINE PART38


END SUBROUTINE SRTM_KGB21
