!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif 
SUBROUTINE SRTM_KGB27

!     Originally by J.Delamere, Atmospheric & Environmental Research.
!     Revision: 2.4
!     BAND 16: 29000-38000 cm-1 (low - O3; high - O3)
!     Reformatted for F90 by JJMorcrette, ECMWF

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOESRTA27, ONLY : KA, KB, SFLUXREF, RAYL, SCALEKUR &
 & , LAYREFFR  

!     ------------------------------------------------------------------

IMPLICIT NONE

! KURUCZ
!     The following values were obtained using the "low resolution"
!     version of the Kurucz solar source function.  For unknown reasons,
!     the total irradiance in this band differs from the corresponding
!     total in the "high-resolution" version of the Kurucz function.
!     Therefore, below these values are scaled by the factor SCALEKUR.
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB27',0,ZHOOK_HANDLE)
SFLUXREF = (/ &
 & 14.0526_JPRB    , 11.4794_JPRB    , 8.72590_JPRB    , 5.56966_JPRB    , &
 & 3.80927_JPRB    , 1.57690_JPRB    , 1.15099_JPRB    , 1.10012_JPRB    , &
 & 0.658212_JPRB   , 5.86859E-02_JPRB, 5.56186E-02_JPRB, 4.68040E-02_JPRB, &
 & 3.64897E-02_JPRB, 3.58053E-02_JPRB, 1.38130E-02_JPRB, 1.90193E-03_JPRB /)  

!     Rayleigh extinction coefficient at v = 2925 cm-1.
RAYL = (/ &
 & 3.44534E-06_JPRB,4.14480E-06_JPRB,4.95069E-06_JPRB,5.81204E-06_JPRB, &
 & 6.69748E-06_JPRB,7.56488E-06_JPRB,8.36344E-06_JPRB,9.04135E-06_JPRB, &
 & 9.58324E-06_JPRB,9.81542E-06_JPRB,9.75119E-06_JPRB,9.74533E-06_JPRB, &
 & 9.74139E-06_JPRB,9.73525E-06_JPRB,9.73577E-06_JPRB,9.73618E-06_JPRB /)  

SCALEKUR = 50.15_JPRB/48.37_JPRB

LAYREFFR = 32

!     ------------------------------------------------------------------

!     The array KA contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KA(:, 1, 1) = (/ &
 & 0.22907E+00_JPRB,0.25625E+00_JPRB,0.28779E+00_JPRB,0.32376E+00_JPRB,0.36426E+00_JPRB /)  
KA(:, 2, 1) = (/ &
 & 0.21913E+00_JPRB,0.24445E+00_JPRB,0.27422E+00_JPRB,0.30832E+00_JPRB,0.34694E+00_JPRB /)  
KA(:, 3, 1) = (/ &
 & 0.20602E+00_JPRB,0.22864E+00_JPRB,0.25574E+00_JPRB,0.28721E+00_JPRB,0.32310E+00_JPRB /)  
KA(:, 4, 1) = (/ &
 & 0.19379E+00_JPRB,0.21352E+00_JPRB,0.23771E+00_JPRB,0.26643E+00_JPRB,0.29940E+00_JPRB /)  
KA(:, 5, 1) = (/ &
 & 0.18369E+00_JPRB,0.20061E+00_JPRB,0.22200E+00_JPRB,0.24786E+00_JPRB,0.27816E+00_JPRB /)  
KA(:, 6, 1) = (/ &
 & 0.17517E+00_JPRB,0.18920E+00_JPRB,0.20771E+00_JPRB,0.23069E+00_JPRB,0.25817E+00_JPRB /)  
KA(:, 7, 1) = (/ &
 & 0.16888E+00_JPRB,0.17988E+00_JPRB,0.19559E+00_JPRB,0.21577E+00_JPRB,0.24042E+00_JPRB /)  
KA(:, 8, 1) = (/ &
 & 0.16442E+00_JPRB,0.17273E+00_JPRB,0.18565E+00_JPRB,0.20315E+00_JPRB,0.22512E+00_JPRB /)  
KA(:, 9, 1) = (/ &
 & 0.16159E+00_JPRB,0.16738E+00_JPRB,0.17752E+00_JPRB,0.19242E+00_JPRB,0.21179E+00_JPRB /)  
KA(:,10, 1) = (/ &
 & 0.16037E+00_JPRB,0.16402E+00_JPRB,0.17204E+00_JPRB,0.18463E+00_JPRB,0.20183E+00_JPRB /)  
KA(:,11, 1) = (/ &
 & 0.16036E+00_JPRB,0.16399E+00_JPRB,0.17198E+00_JPRB,0.18455E+00_JPRB,0.20173E+00_JPRB /)  
KA(:,12, 1) = (/ &
 & 0.16036E+00_JPRB,0.16399E+00_JPRB,0.17198E+00_JPRB,0.18455E+00_JPRB,0.20173E+00_JPRB /)  
KA(:,13, 1) = (/ &
 & 0.16036E+00_JPRB,0.16399E+00_JPRB,0.17198E+00_JPRB,0.18455E+00_JPRB,0.20173E+00_JPRB /)  
KA(:, 1, 2) = (/ &
 & 0.20716E+01_JPRB,0.21925E+01_JPRB,0.23327E+01_JPRB,0.24921E+01_JPRB,0.26726E+01_JPRB /)  
KA(:, 2, 2) = (/ &
 & 0.20272E+01_JPRB,0.21401E+01_JPRB,0.22723E+01_JPRB,0.24238E+01_JPRB,0.25950E+01_JPRB /)  
KA(:, 3, 2) = (/ &
 & 0.19684E+01_JPRB,0.20697E+01_JPRB,0.21902E+01_JPRB,0.23301E+01_JPRB,0.24892E+01_JPRB /)  
KA(:, 4, 2) = (/ &
 & 0.19133E+01_JPRB,0.20021E+01_JPRB,0.21101E+01_JPRB,0.22375E+01_JPRB,0.23842E+01_JPRB /)  
KA(:, 5, 2) = (/ &
 & 0.18673E+01_JPRB,0.19441E+01_JPRB,0.20400E+01_JPRB,0.21553E+01_JPRB,0.22898E+01_JPRB /)  
KA(:, 6, 2) = (/ &
 & 0.18277E+01_JPRB,0.18925E+01_JPRB,0.19760E+01_JPRB,0.20788E+01_JPRB,0.22009E+01_JPRB /)  
KA(:, 7, 2) = (/ &
 & 0.17963E+01_JPRB,0.18497E+01_JPRB,0.19214E+01_JPRB,0.20121E+01_JPRB,0.21222E+01_JPRB /)  
KA(:, 8, 2) = (/ &
 & 0.17749E+01_JPRB,0.18156E+01_JPRB,0.18763E+01_JPRB,0.19555E+01_JPRB,0.20540E+01_JPRB /)  
KA(:, 9, 2) = (/ &
 & 0.17600E+01_JPRB,0.17885E+01_JPRB,0.18388E+01_JPRB,0.19071E+01_JPRB,0.19943E+01_JPRB /)  
KA(:,10, 2) = (/ &
 & 0.17526E+01_JPRB,0.17729E+01_JPRB,0.18121E+01_JPRB,0.18716E+01_JPRB,0.19496E+01_JPRB /)  
KA(:,11, 2) = (/ &
 & 0.17525E+01_JPRB,0.17727E+01_JPRB,0.18119E+01_JPRB,0.18712E+01_JPRB,0.19491E+01_JPRB /)  
KA(:,12, 2) = (/ &
 & 0.17525E+01_JPRB,0.17727E+01_JPRB,0.18119E+01_JPRB,0.18712E+01_JPRB,0.19491E+01_JPRB /)  
KA(:,13, 2) = (/ &
 & 0.17525E+01_JPRB,0.17727E+01_JPRB,0.18119E+01_JPRB,0.18712E+01_JPRB,0.19491E+01_JPRB /)  
KA(:, 1, 3) = (/ &
 & 0.12189E+02_JPRB,0.12619E+02_JPRB,0.13110E+02_JPRB,0.13663E+02_JPRB,0.14275E+02_JPRB /)  
KA(:, 2, 3) = (/ &
 & 0.12030E+02_JPRB,0.12434E+02_JPRB,0.12899E+02_JPRB,0.13427E+02_JPRB,0.14015E+02_JPRB /)  
KA(:, 3, 3) = (/ &
 & 0.11816E+02_JPRB,0.12183E+02_JPRB,0.12611E+02_JPRB,0.13101E+02_JPRB,0.13653E+02_JPRB /)  
KA(:, 4, 3) = (/ &
 & 0.11611E+02_JPRB,0.11938E+02_JPRB,0.12327E+02_JPRB,0.12777E+02_JPRB,0.13289E+02_JPRB /)  
KA(:, 5, 3) = (/ &
 & 0.11437E+02_JPRB,0.11726E+02_JPRB,0.12076E+02_JPRB,0.12488E+02_JPRB,0.12961E+02_JPRB /)  
KA(:, 6, 3) = (/ &
 & 0.11284E+02_JPRB,0.11533E+02_JPRB,0.11843E+02_JPRB,0.12215E+02_JPRB,0.12649E+02_JPRB /)  
KA(:, 7, 3) = (/ &
 & 0.11160E+02_JPRB,0.11370E+02_JPRB,0.11641E+02_JPRB,0.11975E+02_JPRB,0.12370E+02_JPRB /)  
KA(:, 8, 3) = (/ &
 & 0.11063E+02_JPRB,0.11237E+02_JPRB,0.11471E+02_JPRB,0.11768E+02_JPRB,0.12126E+02_JPRB /)  
KA(:, 9, 3) = (/ &
 & 0.10990E+02_JPRB,0.11129E+02_JPRB,0.11327E+02_JPRB,0.11588E+02_JPRB,0.11910E+02_JPRB /)  
KA(:,10, 3) = (/ &
 & 0.10945E+02_JPRB,0.11053E+02_JPRB,0.11223E+02_JPRB,0.11454E+02_JPRB,0.11746E+02_JPRB /)  
KA(:,11, 3) = (/ &
 & 0.10945E+02_JPRB,0.11052E+02_JPRB,0.11222E+02_JPRB,0.11452E+02_JPRB,0.11744E+02_JPRB /)  
KA(:,12, 3) = (/ &
 & 0.10945E+02_JPRB,0.11052E+02_JPRB,0.11222E+02_JPRB,0.11452E+02_JPRB,0.11744E+02_JPRB /)  
KA(:,13, 3) = (/ &
 & 0.10945E+02_JPRB,0.11052E+02_JPRB,0.11222E+02_JPRB,0.11452E+02_JPRB,0.11744E+02_JPRB /)  
KA(:, 1, 4) = (/ &
 & 0.55057E+02_JPRB,0.56143E+02_JPRB,0.57364E+02_JPRB,0.58719E+02_JPRB,0.60208E+02_JPRB /)  
KA(:, 2, 4) = (/ &
 & 0.54647E+02_JPRB,0.55677E+02_JPRB,0.56842E+02_JPRB,0.58142E+02_JPRB,0.59575E+02_JPRB /)  
KA(:, 3, 4) = (/ &
 & 0.54090E+02_JPRB,0.55039E+02_JPRB,0.56123E+02_JPRB,0.57342E+02_JPRB,0.58694E+02_JPRB /)  
KA(:, 4, 4) = (/ &
 & 0.53548E+02_JPRB,0.54410E+02_JPRB,0.55408E+02_JPRB,0.56539E+02_JPRB,0.57805E+02_JPRB /)  
KA(:, 5, 4) = (/ &
 & 0.53074E+02_JPRB,0.53853E+02_JPRB,0.54766E+02_JPRB,0.55813E+02_JPRB,0.56995E+02_JPRB /)  
KA(:, 6, 4) = (/ &
 & 0.52644E+02_JPRB,0.53336E+02_JPRB,0.54162E+02_JPRB,0.55123E+02_JPRB,0.56218E+02_JPRB /)  
KA(:, 7, 4) = (/ &
 & 0.52279E+02_JPRB,0.52887E+02_JPRB,0.53629E+02_JPRB,0.54505E+02_JPRB,0.55516E+02_JPRB /)  
KA(:, 8, 4) = (/ &
 & 0.51979E+02_JPRB,0.52507E+02_JPRB,0.53168E+02_JPRB,0.53965E+02_JPRB,0.54895E+02_JPRB /)  
KA(:, 9, 4) = (/ &
 & 0.51734E+02_JPRB,0.52183E+02_JPRB,0.52767E+02_JPRB,0.53485E+02_JPRB,0.54337E+02_JPRB /)  
KA(:,10, 4) = (/ &
 & 0.51565E+02_JPRB,0.51948E+02_JPRB,0.52467E+02_JPRB,0.53120E+02_JPRB,0.53907E+02_JPRB /)  
KA(:,11, 4) = (/ &
 & 0.51563E+02_JPRB,0.51946E+02_JPRB,0.52464E+02_JPRB,0.53116E+02_JPRB,0.53902E+02_JPRB /)  
KA(:,12, 4) = (/ &
 & 0.51563E+02_JPRB,0.51946E+02_JPRB,0.52464E+02_JPRB,0.53116E+02_JPRB,0.53902E+02_JPRB /)  
KA(:,13, 4) = (/ &
 & 0.51563E+02_JPRB,0.51946E+02_JPRB,0.52464E+02_JPRB,0.53116E+02_JPRB,0.53902E+02_JPRB /)  
KA(:, 1, 5) = (/ &
 & 0.17794E+03_JPRB,0.17973E+03_JPRB,0.18164E+03_JPRB,0.18366E+03_JPRB,0.18581E+03_JPRB /)  
KA(:, 2, 5) = (/ &
 & 0.17724E+03_JPRB,0.17898E+03_JPRB,0.18083E+03_JPRB,0.18281E+03_JPRB,0.18491E+03_JPRB /)  
KA(:, 3, 5) = (/ &
 & 0.17624E+03_JPRB,0.17791E+03_JPRB,0.17970E+03_JPRB,0.18160E+03_JPRB,0.18363E+03_JPRB /)  
KA(:, 4, 5) = (/ &
 & 0.17523E+03_JPRB,0.17682E+03_JPRB,0.17853E+03_JPRB,0.18036E+03_JPRB,0.18231E+03_JPRB /)  
KA(:, 5, 5) = (/ &
 & 0.17429E+03_JPRB,0.17581E+03_JPRB,0.17744E+03_JPRB,0.17920E+03_JPRB,0.18107E+03_JPRB /)  
KA(:, 6, 5) = (/ &
 & 0.17338E+03_JPRB,0.17482E+03_JPRB,0.17638E+03_JPRB,0.17805E+03_JPRB,0.17985E+03_JPRB /)  
KA(:, 7, 5) = (/ &
 & 0.17253E+03_JPRB,0.17390E+03_JPRB,0.17539E+03_JPRB,0.17699E+03_JPRB,0.17871E+03_JPRB /)  
KA(:, 8, 5) = (/ &
 & 0.17177E+03_JPRB,0.17307E+03_JPRB,0.17448E+03_JPRB,0.17601E+03_JPRB,0.17767E+03_JPRB /)  
KA(:, 9, 5) = (/ &
 & 0.17107E+03_JPRB,0.17230E+03_JPRB,0.17364E+03_JPRB,0.17511E+03_JPRB,0.17669E+03_JPRB /)  
KA(:,10, 5) = (/ &
 & 0.17052E+03_JPRB,0.17169E+03_JPRB,0.17298E+03_JPRB,0.17438E+03_JPRB,0.17591E+03_JPRB /)  
KA(:,11, 5) = (/ &
 & 0.17051E+03_JPRB,0.17168E+03_JPRB,0.17297E+03_JPRB,0.17437E+03_JPRB,0.17590E+03_JPRB /)  
KA(:,12, 5) = (/ &
 & 0.17051E+03_JPRB,0.17168E+03_JPRB,0.17297E+03_JPRB,0.17437E+03_JPRB,0.17590E+03_JPRB /)  
KA(:,13, 5) = (/ &
 & 0.17051E+03_JPRB,0.17168E+03_JPRB,0.17297E+03_JPRB,0.17437E+03_JPRB,0.17590E+03_JPRB /)  
KA(:, 1, 6) = (/ &
 & 0.37680E+05_JPRB,0.36801E+05_JPRB,0.36011E+05_JPRB,0.35298E+05_JPRB,0.34715E+05_JPRB /)  
KA(:, 2, 6) = (/ &
 & 0.39286E+03_JPRB,0.39463E+03_JPRB,0.39616E+03_JPRB,0.39748E+03_JPRB,0.39858E+03_JPRB /)  
KA(:, 3, 6) = (/ &
 & 0.39169E+03_JPRB,0.39359E+03_JPRB,0.39526E+03_JPRB,0.39671E+03_JPRB,0.39794E+03_JPRB /)  
KA(:, 4, 6) = (/ &
 & 0.39034E+03_JPRB,0.39239E+03_JPRB,0.39421E+03_JPRB,0.39580E+03_JPRB,0.39717E+03_JPRB /)  
KA(:, 5, 6) = (/ &
 & 0.38895E+03_JPRB,0.39113E+03_JPRB,0.39309E+03_JPRB,0.39483E+03_JPRB,0.39634E+03_JPRB /)  
KA(:, 6, 6) = (/ &
 & 0.38742E+03_JPRB,0.38975E+03_JPRB,0.39185E+03_JPRB,0.39373E+03_JPRB,0.39539E+03_JPRB /)  
KA(:, 7, 6) = (/ &
 & 0.38585E+03_JPRB,0.38832E+03_JPRB,0.39056E+03_JPRB,0.39258E+03_JPRB,0.39438E+03_JPRB /)  
KA(:, 8, 6) = (/ &
 & 0.38426E+03_JPRB,0.38686E+03_JPRB,0.38924E+03_JPRB,0.39140E+03_JPRB,0.39333E+03_JPRB /)  
KA(:, 9, 6) = (/ &
 & 0.38264E+03_JPRB,0.38538E+03_JPRB,0.38789E+03_JPRB,0.39017E+03_JPRB,0.39223E+03_JPRB /)  
KA(:,10, 6) = (/ &
 & 0.38123E+03_JPRB,0.38408E+03_JPRB,0.38670E+03_JPRB,0.38909E+03_JPRB,0.39126E+03_JPRB /)  
KA(:,11, 6) = (/ &
 & 0.38122E+03_JPRB,0.38406E+03_JPRB,0.38668E+03_JPRB,0.38908E+03_JPRB,0.39125E+03_JPRB /)  
KA(:,12, 6) = (/ &
 & 0.38122E+03_JPRB,0.38406E+03_JPRB,0.38668E+03_JPRB,0.38908E+03_JPRB,0.39125E+03_JPRB /)  
KA(:,13, 6) = (/ &
 & 0.38122E+03_JPRB,0.38406E+03_JPRB,0.38668E+03_JPRB,0.38908E+03_JPRB,0.39125E+03_JPRB /)  
KA(:, 1, 7) = (/ &
 & 0.18202E+07_JPRB,0.17771E+07_JPRB,0.17382E+07_JPRB,0.17034E+07_JPRB,0.16716E+07_JPRB /)  
KA(:, 2, 7) = (/ &
 & 0.63027E+03_JPRB,0.63194E+03_JPRB,0.63388E+03_JPRB,0.63607E+03_JPRB,0.63849E+03_JPRB /)  
KA(:, 3, 7) = (/ &
 & 0.62938E+03_JPRB,0.63090E+03_JPRB,0.63268E+03_JPRB,0.63472E+03_JPRB,0.63701E+03_JPRB /)  
KA(:, 4, 7) = (/ &
 & 0.62853E+03_JPRB,0.62989E+03_JPRB,0.63150E+03_JPRB,0.63337E+03_JPRB,0.63550E+03_JPRB /)  
KA(:, 5, 7) = (/ &
 & 0.62781E+03_JPRB,0.62901E+03_JPRB,0.63046E+03_JPRB,0.63217E+03_JPRB,0.63413E+03_JPRB /)  
KA(:, 6, 7) = (/ &
 & 0.62717E+03_JPRB,0.62821E+03_JPRB,0.62950E+03_JPRB,0.63104E+03_JPRB,0.63283E+03_JPRB /)  
KA(:, 7, 7) = (/ &
 & 0.62666E+03_JPRB,0.62753E+03_JPRB,0.62867E+03_JPRB,0.63005E+03_JPRB,0.63168E+03_JPRB /)  
KA(:, 8, 7) = (/ &
 & 0.62627E+03_JPRB,0.62698E+03_JPRB,0.62795E+03_JPRB,0.62919E+03_JPRB,0.63067E+03_JPRB /)  
KA(:, 9, 7) = (/ &
 & 0.62600E+03_JPRB,0.62653E+03_JPRB,0.62735E+03_JPRB,0.62844E+03_JPRB,0.62978E+03_JPRB /)  
KA(:,10, 7) = (/ &
 & 0.62583E+03_JPRB,0.62624E+03_JPRB,0.62692E+03_JPRB,0.62788E+03_JPRB,0.62910E+03_JPRB /)  
KA(:,11, 7) = (/ &
 & 0.62583E+03_JPRB,0.62623E+03_JPRB,0.62691E+03_JPRB,0.62787E+03_JPRB,0.62909E+03_JPRB /)  
KA(:,12, 7) = (/ &
 & 0.62583E+03_JPRB,0.62623E+03_JPRB,0.62691E+03_JPRB,0.62787E+03_JPRB,0.62909E+03_JPRB /)  
KA(:,13, 7) = (/ &
 & 0.62583E+03_JPRB,0.62623E+03_JPRB,0.62691E+03_JPRB,0.62787E+03_JPRB,0.62909E+03_JPRB /)  
KA(:, 1, 8) = (/ &
 & 0.55488E+07_JPRB,0.54180E+07_JPRB,0.53005E+07_JPRB,0.51943E+07_JPRB,0.50978E+07_JPRB /)  
KA(:, 2, 8) = (/ &
 & 0.82143E+03_JPRB,0.82232E+03_JPRB,0.82327E+03_JPRB,0.82429E+03_JPRB,0.82541E+03_JPRB /)  
KA(:, 3, 8) = (/ &
 & 0.82092E+03_JPRB,0.82177E+03_JPRB,0.82269E+03_JPRB,0.82366E+03_JPRB,0.82472E+03_JPRB /)  
KA(:, 4, 8) = (/ &
 & 0.82041E+03_JPRB,0.82121E+03_JPRB,0.82209E+03_JPRB,0.82303E+03_JPRB,0.82402E+03_JPRB /)  
KA(:, 5, 8) = (/ &
 & 0.81996E+03_JPRB,0.82070E+03_JPRB,0.82152E+03_JPRB,0.82243E+03_JPRB,0.82339E+03_JPRB /)  
KA(:, 6, 8) = (/ &
 & 0.81952E+03_JPRB,0.82021E+03_JPRB,0.82098E+03_JPRB,0.82184E+03_JPRB,0.82277E+03_JPRB /)  
KA(:, 7, 8) = (/ &
 & 0.81917E+03_JPRB,0.81977E+03_JPRB,0.82048E+03_JPRB,0.82129E+03_JPRB,0.82218E+03_JPRB /)  
KA(:, 8, 8) = (/ &
 & 0.81881E+03_JPRB,0.81938E+03_JPRB,0.82004E+03_JPRB,0.82080E+03_JPRB,0.82163E+03_JPRB /)  
KA(:, 9, 8) = (/ &
 & 0.81846E+03_JPRB,0.81906E+03_JPRB,0.81965E+03_JPRB,0.82035E+03_JPRB,0.82114E+03_JPRB /)  
KA(:,10, 8) = (/ &
 & 0.81821E+03_JPRB,0.81877E+03_JPRB,0.81934E+03_JPRB,0.82000E+03_JPRB,0.82074E+03_JPRB /)  
KA(:,11, 8) = (/ &
 & 0.81821E+03_JPRB,0.81877E+03_JPRB,0.81934E+03_JPRB,0.81999E+03_JPRB,0.82074E+03_JPRB /)  
KA(:,12, 8) = (/ &
 & 0.81821E+03_JPRB,0.81877E+03_JPRB,0.81934E+03_JPRB,0.81999E+03_JPRB,0.82074E+03_JPRB /)  
KA(:,13, 8) = (/ &
 & 0.81821E+03_JPRB,0.81877E+03_JPRB,0.81935E+03_JPRB,0.81999E+03_JPRB,0.82074E+03_JPRB /)  
KA(:, 1, 9) = (/ &
 & 0.10204E+08_JPRB,0.99477E+07_JPRB,0.97209E+07_JPRB,0.95103E+07_JPRB,0.92960E+07_JPRB /)  
KA(:, 2, 9) = (/ &
 & 0.95102E+03_JPRB,0.95144E+03_JPRB,0.95133E+03_JPRB,0.95066E+03_JPRB,0.94964E+03_JPRB /)  
KA(:, 3, 9) = (/ &
 & 0.95048E+03_JPRB,0.95118E+03_JPRB,0.95136E+03_JPRB,0.95103E+03_JPRB,0.95020E+03_JPRB /)  
KA(:, 4, 9) = (/ &
 & 0.94969E+03_JPRB,0.95077E+03_JPRB,0.95126E+03_JPRB,0.95124E+03_JPRB,0.95074E+03_JPRB /)  
KA(:, 5, 9) = (/ &
 & 0.94872E+03_JPRB,0.95015E+03_JPRB,0.95101E+03_JPRB,0.95129E+03_JPRB,0.95105E+03_JPRB /)  
KA(:, 6, 9) = (/ &
 & 0.94752E+03_JPRB,0.94929E+03_JPRB,0.95052E+03_JPRB,0.95116E+03_JPRB,0.95126E+03_JPRB /)  
KA(:, 7, 9) = (/ &
 & 0.94612E+03_JPRB,0.94825E+03_JPRB,0.94981E+03_JPRB,0.95083E+03_JPRB,0.95126E+03_JPRB /)  
KA(:, 8, 9) = (/ &
 & 0.94461E+03_JPRB,0.94704E+03_JPRB,0.94894E+03_JPRB,0.95029E+03_JPRB,0.95107E+03_JPRB /)  
KA(:, 9, 9) = (/ &
 & 0.94291E+03_JPRB,0.94567E+03_JPRB,0.94791E+03_JPRB,0.94957E+03_JPRB,0.95069E+03_JPRB /)  
KA(:,10, 9) = (/ &
 & 0.94135E+03_JPRB,0.94441E+03_JPRB,0.94689E+03_JPRB,0.94884E+03_JPRB,0.95022E+03_JPRB /)  
KA(:,11, 9) = (/ &
 & 0.94133E+03_JPRB,0.94440E+03_JPRB,0.94688E+03_JPRB,0.94883E+03_JPRB,0.95021E+03_JPRB /)  
KA(:,12, 9) = (/ &
 & 0.94133E+03_JPRB,0.94438E+03_JPRB,0.94688E+03_JPRB,0.94883E+03_JPRB,0.95021E+03_JPRB /)  
KA(:,13, 9) = (/ &
 & 0.94133E+03_JPRB,0.94438E+03_JPRB,0.94687E+03_JPRB,0.94883E+03_JPRB,0.95021E+03_JPRB /)  
KA(:, 1,10) = (/ &
 & 0.12764E+08_JPRB,0.12408E+08_JPRB,0.12012E+08_JPRB,0.11438E+08_JPRB,0.11217E+08_JPRB /)  
KA(:, 2,10) = (/ &
 & 0.99589E+03_JPRB,0.99493E+03_JPRB,0.99263E+03_JPRB,0.98974E+03_JPRB,0.98742E+03_JPRB /)  
KA(:, 3,10) = (/ &
 & 0.99532E+03_JPRB,0.99571E+03_JPRB,0.99447E+03_JPRB,0.99207E+03_JPRB,0.98779E+03_JPRB /)  
KA(:, 4,10) = (/ &
 & 0.99446E+03_JPRB,0.99559E+03_JPRB,0.99536E+03_JPRB,0.99386E+03_JPRB,0.99088E+03_JPRB /)  
KA(:, 5,10) = (/ &
 & 0.99288E+03_JPRB,0.99493E+03_JPRB,0.99558E+03_JPRB,0.99487E+03_JPRB,0.99336E+03_JPRB /)  
KA(:, 6,10) = (/ &
 & 0.99069E+03_JPRB,0.99366E+03_JPRB,0.99519E+03_JPRB,0.99534E+03_JPRB,0.99428E+03_JPRB /)  
KA(:, 7,10) = (/ &
 & 0.98811E+03_JPRB,0.99191E+03_JPRB,0.99430E+03_JPRB,0.99510E+03_JPRB,0.99504E+03_JPRB /)  
KA(:, 8,10) = (/ &
 & 0.98531E+03_JPRB,0.98996E+03_JPRB,0.99300E+03_JPRB,0.99479E+03_JPRB,0.99513E+03_JPRB /)  
KA(:, 9,10) = (/ &
 & 0.98264E+03_JPRB,0.98737E+03_JPRB,0.99138E+03_JPRB,0.99390E+03_JPRB,0.99503E+03_JPRB /)  
KA(:,10,10) = (/ &
 & 0.98010E+03_JPRB,0.98517E+03_JPRB,0.98974E+03_JPRB,0.99281E+03_JPRB,0.99470E+03_JPRB /)  
KA(:,11,10) = (/ &
 & 0.98010E+03_JPRB,0.98509E+03_JPRB,0.98985E+03_JPRB,0.99280E+03_JPRB,0.99468E+03_JPRB /)  
KA(:,12,10) = (/ &
 & 0.98035E+03_JPRB,0.98524E+03_JPRB,0.98973E+03_JPRB,0.99279E+03_JPRB,0.99468E+03_JPRB /)  
KA(:,13,10) = (/ &
 & 0.98012E+03_JPRB,0.98526E+03_JPRB,0.98973E+03_JPRB,0.99279E+03_JPRB,0.99468E+03_JPRB /)  
KA(:, 1,11) = (/ &
 & 0.12266E+08_JPRB,0.12000E+08_JPRB,0.11724E+08_JPRB,0.11828E+08_JPRB,0.11523E+08_JPRB /)  
KA(:, 2,11) = (/ &
 & 0.10001E+04_JPRB,0.99984E+03_JPRB,0.99745E+03_JPRB,0.99535E+03_JPRB,0.98599E+03_JPRB /)  
KA(:, 3,11) = (/ &
 & 0.99963E+03_JPRB,0.99927E+03_JPRB,0.99848E+03_JPRB,0.99596E+03_JPRB,0.99390E+03_JPRB /)  
KA(:, 4,11) = (/ &
 & 0.99904E+03_JPRB,0.99942E+03_JPRB,0.99870E+03_JPRB,0.99747E+03_JPRB,0.99542E+03_JPRB /)  
KA(:, 5,11) = (/ &
 & 0.99826E+03_JPRB,0.99927E+03_JPRB,0.99919E+03_JPRB,0.99821E+03_JPRB,0.99627E+03_JPRB /)  
KA(:, 6,11) = (/ &
 & 0.99730E+03_JPRB,0.99882E+03_JPRB,0.99938E+03_JPRB,0.99902E+03_JPRB,0.99764E+03_JPRB /)  
KA(:, 7,11) = (/ &
 & 0.99551E+03_JPRB,0.99810E+03_JPRB,0.99919E+03_JPRB,0.99961E+03_JPRB,0.99863E+03_JPRB /)  
KA(:, 8,11) = (/ &
 & 0.99324E+03_JPRB,0.99688E+03_JPRB,0.99871E+03_JPRB,0.99940E+03_JPRB,0.99942E+03_JPRB /)  
KA(:, 9,11) = (/ &
 & 0.99058E+03_JPRB,0.99489E+03_JPRB,0.99773E+03_JPRB,0.99912E+03_JPRB,0.99954E+03_JPRB /)  
KA(:,10,11) = (/ &
 & 0.98802E+03_JPRB,0.99297E+03_JPRB,0.99656E+03_JPRB,0.99861E+03_JPRB,0.99937E+03_JPRB /)  
KA(:,11,11) = (/ &
 & 0.98800E+03_JPRB,0.99310E+03_JPRB,0.99655E+03_JPRB,0.99860E+03_JPRB,0.99936E+03_JPRB /)  
KA(:,12,11) = (/ &
 & 0.98771E+03_JPRB,0.99296E+03_JPRB,0.99669E+03_JPRB,0.99859E+03_JPRB,0.99936E+03_JPRB /)  
KA(:,13,11) = (/ &
 & 0.98800E+03_JPRB,0.99296E+03_JPRB,0.99655E+03_JPRB,0.99859E+03_JPRB,0.99936E+03_JPRB /)  
KA(:, 1,12) = (/ &
 & 0.12503E+08_JPRB,0.11946E+08_JPRB,0.11557E+08_JPRB,0.11503E+08_JPRB,0.11901E+08_JPRB /)  
KA(:, 2,12) = (/ &
 & 0.10015E+04_JPRB,0.10004E+04_JPRB,0.99932E+03_JPRB,0.99373E+03_JPRB,0.98591E+03_JPRB /)  
KA(:, 3,12) = (/ &
 & 0.10024E+04_JPRB,0.10021E+04_JPRB,0.10003E+04_JPRB,0.99817E+03_JPRB,0.99146E+03_JPRB /)  
KA(:, 4,12) = (/ &
 & 0.10022E+04_JPRB,0.10027E+04_JPRB,0.10021E+04_JPRB,0.99956E+03_JPRB,0.99610E+03_JPRB /)  
KA(:, 5,12) = (/ &
 & 0.10024E+04_JPRB,0.10024E+04_JPRB,0.10028E+04_JPRB,0.10015E+04_JPRB,0.99826E+03_JPRB /)  
KA(:, 6,12) = (/ &
 & 0.10017E+04_JPRB,0.10025E+04_JPRB,0.10025E+04_JPRB,0.10023E+04_JPRB,0.10008E+04_JPRB /)  
KA(:, 7,12) = (/ &
 & 0.10005E+04_JPRB,0.10020E+04_JPRB,0.10028E+04_JPRB,0.10028E+04_JPRB,0.10019E+04_JPRB /)  
KA(:, 8,12) = (/ &
 & 0.10000E+04_JPRB,0.10010E+04_JPRB,0.10024E+04_JPRB,0.10029E+04_JPRB,0.10023E+04_JPRB /)  
KA(:, 9,12) = (/ &
 & 0.99906E+03_JPRB,0.10004E+04_JPRB,0.10018E+04_JPRB,0.10029E+04_JPRB,0.10028E+04_JPRB /)  
KA(:,10,12) = (/ &
 & 0.99791E+03_JPRB,0.99989E+03_JPRB,0.10010E+04_JPRB,0.10024E+04_JPRB,0.10031E+04_JPRB /)  
KA(:,11,12) = (/ &
 & 0.99769E+03_JPRB,0.99967E+03_JPRB,0.10008E+04_JPRB,0.10024E+04_JPRB,0.10029E+04_JPRB /)  
KA(:,12,12) = (/ &
 & 0.99787E+03_JPRB,0.99985E+03_JPRB,0.10008E+04_JPRB,0.10025E+04_JPRB,0.10029E+04_JPRB /)  
KA(:,13,12) = (/ &
 & 0.99768E+03_JPRB,0.99984E+03_JPRB,0.10012E+04_JPRB,0.10026E+04_JPRB,0.10029E+04_JPRB /)  
KA(:, 1,13) = (/ &
 & 0.12359E+08_JPRB,0.12469E+08_JPRB,0.12868E+08_JPRB,0.12776E+08_JPRB,0.12590E+08_JPRB /)  
KA(:, 2,13) = (/ &
 & 0.10045E+04_JPRB,0.10033E+04_JPRB,0.99840E+03_JPRB,0.99184E+03_JPRB,0.98861E+03_JPRB /)  
KA(:, 3,13) = (/ &
 & 0.10050E+04_JPRB,0.10041E+04_JPRB,0.10024E+04_JPRB,0.99701E+03_JPRB,0.99083E+03_JPRB /)  
KA(:, 4,13) = (/ &
 & 0.10053E+04_JPRB,0.10043E+04_JPRB,0.10035E+04_JPRB,0.10017E+04_JPRB,0.99538E+03_JPRB /)  
KA(:, 5,13) = (/ &
 & 0.10048E+04_JPRB,0.10056E+04_JPRB,0.10038E+04_JPRB,0.10026E+04_JPRB,0.10008E+04_JPRB /)  
KA(:, 6,13) = (/ &
 & 0.10042E+04_JPRB,0.10054E+04_JPRB,0.10054E+04_JPRB,0.10039E+04_JPRB,0.10017E+04_JPRB /)  
KA(:, 7,13) = (/ &
 & 0.10029E+04_JPRB,0.10046E+04_JPRB,0.10055E+04_JPRB,0.10046E+04_JPRB,0.10033E+04_JPRB /)  
KA(:, 8,13) = (/ &
 & 0.10002E+04_JPRB,0.10039E+04_JPRB,0.10051E+04_JPRB,0.10054E+04_JPRB,0.10046E+04_JPRB /)  
KA(:, 9,13) = (/ &
 & 0.99825E+03_JPRB,0.10019E+04_JPRB,0.10043E+04_JPRB,0.10051E+04_JPRB,0.10052E+04_JPRB /)  
KA(:,10,13) = (/ &
 & 0.99595E+03_JPRB,0.99983E+03_JPRB,0.10034E+04_JPRB,0.10050E+04_JPRB,0.10051E+04_JPRB /)  
KA(:,11,13) = (/ &
 & 0.99621E+03_JPRB,0.99979E+03_JPRB,0.10034E+04_JPRB,0.10050E+04_JPRB,0.10054E+04_JPRB /)  
KA(:,12,13) = (/ &
 & 0.99597E+03_JPRB,0.99979E+03_JPRB,0.10031E+04_JPRB,0.10047E+04_JPRB,0.10054E+04_JPRB /)  
KA(:,13,13) = (/ &
 & 0.99623E+03_JPRB,0.99978E+03_JPRB,0.10031E+04_JPRB,0.10047E+04_JPRB,0.10054E+04_JPRB /)  
KA(:, 1,14) = (/ &
 & 0.13636E+08_JPRB,0.13818E+08_JPRB,0.13518E+08_JPRB,0.13266E+08_JPRB,0.13048E+08_JPRB /)  
KA(:, 2,14) = (/ &
 & 0.10049E+04_JPRB,0.99946E+03_JPRB,0.99774E+03_JPRB,0.99774E+03_JPRB,0.99771E+03_JPRB /)  
KA(:, 3,14) = (/ &
 & 0.10051E+04_JPRB,0.10068E+04_JPRB,0.10007E+04_JPRB,0.99775E+03_JPRB,0.99778E+03_JPRB /)  
KA(:, 4,14) = (/ &
 & 0.10071E+04_JPRB,0.10061E+04_JPRB,0.10050E+04_JPRB,0.10005E+04_JPRB,0.99776E+03_JPRB /)  
KA(:, 5,14) = (/ &
 & 0.10067E+04_JPRB,0.10072E+04_JPRB,0.10061E+04_JPRB,0.10044E+04_JPRB,0.99972E+03_JPRB /)  
KA(:, 6,14) = (/ &
 & 0.10049E+04_JPRB,0.10070E+04_JPRB,0.10074E+04_JPRB,0.10057E+04_JPRB,0.10037E+04_JPRB /)  
KA(:, 7,14) = (/ &
 & 0.10033E+04_JPRB,0.10063E+04_JPRB,0.10072E+04_JPRB,0.10067E+04_JPRB,0.10050E+04_JPRB /)  
KA(:, 8,14) = (/ &
 & 0.10025E+04_JPRB,0.10048E+04_JPRB,0.10068E+04_JPRB,0.10071E+04_JPRB,0.10062E+04_JPRB /)  
KA(:, 9,14) = (/ &
 & 0.99880E+03_JPRB,0.10031E+04_JPRB,0.10060E+04_JPRB,0.10071E+04_JPRB,0.10069E+04_JPRB /)  
KA(:,10,14) = (/ &
 & 0.99610E+03_JPRB,0.10023E+04_JPRB,0.10047E+04_JPRB,0.10067E+04_JPRB,0.10072E+04_JPRB /)  
KA(:,11,14) = (/ &
 & 0.99601E+03_JPRB,0.10023E+04_JPRB,0.10047E+04_JPRB,0.10067E+04_JPRB,0.10072E+04_JPRB /)  
KA(:,12,14) = (/ &
 & 0.99598E+03_JPRB,0.10023E+04_JPRB,0.10051E+04_JPRB,0.10067E+04_JPRB,0.10076E+04_JPRB /)  
KA(:,13,14) = (/ &
 & 0.99596E+03_JPRB,0.10027E+04_JPRB,0.10047E+04_JPRB,0.10067E+04_JPRB,0.10072E+04_JPRB /)  
KA(:, 1,15) = (/ &
 & 0.14285E+08_JPRB,0.13947E+08_JPRB,0.13644E+08_JPRB,0.13317E+08_JPRB,0.13015E+08_JPRB /)  
KA(:, 2,15) = (/ &
 & 0.99932E+03_JPRB,0.10011E+04_JPRB,0.10018E+04_JPRB,0.10007E+04_JPRB,0.99706E+03_JPRB /)  
KA(:, 3,15) = (/ &
 & 0.10097E+04_JPRB,0.99743E+03_JPRB,0.10015E+04_JPRB,0.10018E+04_JPRB,0.99920E+03_JPRB /)  
KA(:, 4,15) = (/ &
 & 0.10099E+04_JPRB,0.10076E+04_JPRB,0.10030E+04_JPRB,0.10017E+04_JPRB,0.10013E+04_JPRB /)  
KA(:, 5,15) = (/ &
 & 0.10075E+04_JPRB,0.10079E+04_JPRB,0.10073E+04_JPRB,0.10035E+04_JPRB,0.10018E+04_JPRB /)  
KA(:, 6,15) = (/ &
 & 0.10068E+04_JPRB,0.10088E+04_JPRB,0.10068E+04_JPRB,0.10090E+04_JPRB,0.10033E+04_JPRB /)  
KA(:, 7,15) = (/ &
 & 0.10057E+04_JPRB,0.10073E+04_JPRB,0.10090E+04_JPRB,0.10087E+04_JPRB,0.10062E+04_JPRB /)  
KA(:, 8,15) = (/ &
 & 0.10010E+04_JPRB,0.10054E+04_JPRB,0.10076E+04_JPRB,0.10079E+04_JPRB,0.10072E+04_JPRB /)  
KA(:, 9,15) = (/ &
 & 0.99853E+03_JPRB,0.10054E+04_JPRB,0.10071E+04_JPRB,0.10079E+04_JPRB,0.10078E+04_JPRB /)  
KA(:,10,15) = (/ &
 & 0.99742E+03_JPRB,0.10007E+04_JPRB,0.10064E+04_JPRB,0.10076E+04_JPRB,0.10080E+04_JPRB /)  
KA(:,11,15) = (/ &
 & 0.99635E+03_JPRB,0.10006E+04_JPRB,0.10064E+04_JPRB,0.10087E+04_JPRB,0.10090E+04_JPRB /)  
KA(:,12,15) = (/ &
 & 0.99635E+03_JPRB,0.10006E+04_JPRB,0.10064E+04_JPRB,0.10087E+04_JPRB,0.10069E+04_JPRB /)  
KA(:,13,15) = (/ &
 & 0.99635E+03_JPRB,0.99960E+03_JPRB,0.10064E+04_JPRB,0.10076E+04_JPRB,0.10080E+04_JPRB /)  
KA(:, 1,16) = (/ &
 & 0.14326E+08_JPRB,0.13988E+08_JPRB,0.13684E+08_JPRB,0.13409E+08_JPRB,0.13021E+08_JPRB /)  
KA(:, 2,16) = (/ &
 & 0.10008E+04_JPRB,0.10027E+04_JPRB,0.10036E+04_JPRB,0.10037E+04_JPRB,0.99673E+03_JPRB /)  
KA(:, 3,16) = (/ &
 & 0.99286E+03_JPRB,0.10016E+04_JPRB,0.10031E+04_JPRB,0.10038E+04_JPRB,0.10035E+04_JPRB /)  
KA(:, 4,16) = (/ &
 & 0.99278E+03_JPRB,0.10078E+04_JPRB,0.10023E+04_JPRB,0.10035E+04_JPRB,0.10038E+04_JPRB /)  
KA(:, 5,16) = (/ &
 & 0.10074E+04_JPRB,0.10079E+04_JPRB,0.10075E+04_JPRB,0.10028E+04_JPRB,0.10037E+04_JPRB /)  
KA(:, 6,16) = (/ &
 & 0.10069E+04_JPRB,0.10002E+04_JPRB,0.10079E+04_JPRB,0.99212E+03_JPRB,0.10032E+04_JPRB /)  
KA(:, 7,16) = (/ &
 & 0.10060E+04_JPRB,0.10072E+04_JPRB,0.10004E+04_JPRB,0.10003E+04_JPRB,0.10063E+04_JPRB /)  
KA(:, 8,16) = (/ &
 & 0.10009E+04_JPRB,0.10066E+04_JPRB,0.10075E+04_JPRB,0.10080E+04_JPRB,0.10074E+04_JPRB /)  
KA(:, 9,16) = (/ &
 & 0.99860E+03_JPRB,0.10057E+04_JPRB,0.10071E+04_JPRB,0.10078E+04_JPRB,0.10079E+04_JPRB /)  
KA(:,10,16) = (/ &
 & 0.98908E+03_JPRB,0.10006E+04_JPRB,0.10065E+04_JPRB,0.10075E+04_JPRB,0.10080E+04_JPRB /)  
KA(:,11,16) = (/ &
 & 0.99644E+03_JPRB,0.10006E+04_JPRB,0.10065E+04_JPRB,0.10000E+04_JPRB,0.10005E+04_JPRB /)  
KA(:,12,16) = (/ &
 & 0.99644E+03_JPRB,0.10006E+04_JPRB,0.10065E+04_JPRB,0.10000E+04_JPRB,0.10080E+04_JPRB /)  
KA(:,13,16) = (/ &
 & 0.99644E+03_JPRB,0.10006E+04_JPRB,0.10065E+04_JPRB,0.10075E+04_JPRB,0.10080E+04_JPRB /)  
  
!     -----------------------------------------------------------------
!     The array KB contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------
  
KB(:,13, 1) = (/ &
 & 0.16036E+00_JPRB,0.16399E+00_JPRB,0.17198E+00_JPRB,0.18455E+00_JPRB,0.20173E+00_JPRB /)  
KB(:,14, 1) = (/ &
 & 0.16050E+00_JPRB,0.16454E+00_JPRB,0.17292E+00_JPRB,0.18592E+00_JPRB,0.20351E+00_JPRB /)  
KB(:,15, 1) = (/ &
 & 0.16071E+00_JPRB,0.16519E+00_JPRB,0.17400E+00_JPRB,0.18750E+00_JPRB,0.20554E+00_JPRB /)  
KB(:,16, 1) = (/ &
 & 0.16098E+00_JPRB,0.16593E+00_JPRB,0.17517E+00_JPRB,0.18921E+00_JPRB,0.20772E+00_JPRB /)  
KB(:,17, 1) = (/ &
 & 0.16129E+00_JPRB,0.16670E+00_JPRB,0.17642E+00_JPRB,0.19093E+00_JPRB,0.20991E+00_JPRB /)  
KB(:,18, 1) = (/ &
 & 0.16164E+00_JPRB,0.16750E+00_JPRB,0.17771E+00_JPRB,0.19267E+00_JPRB,0.21211E+00_JPRB /)  
KB(:,19, 1) = (/ &
 & 0.16203E+00_JPRB,0.16832E+00_JPRB,0.17901E+00_JPRB,0.19443E+00_JPRB,0.21431E+00_JPRB /)  
KB(:,20, 1) = (/ &
 & 0.16255E+00_JPRB,0.16934E+00_JPRB,0.18059E+00_JPRB,0.19653E+00_JPRB,0.21694E+00_JPRB /)  
KB(:,21, 1) = (/ &
 & 0.16313E+00_JPRB,0.17044E+00_JPRB,0.18225E+00_JPRB,0.19873E+00_JPRB,0.21967E+00_JPRB /)  
KB(:,22, 1) = (/ &
 & 0.16416E+00_JPRB,0.17227E+00_JPRB,0.18498E+00_JPRB,0.20229E+00_JPRB,0.22406E+00_JPRB /)  
KB(:,23, 1) = (/ &
 & 0.16539E+00_JPRB,0.17431E+00_JPRB,0.18796E+00_JPRB,0.20612E+00_JPRB,0.22875E+00_JPRB /)  
KB(:,24, 1) = (/ &
 & 0.16684E+00_JPRB,0.17666E+00_JPRB,0.19125E+00_JPRB,0.21032E+00_JPRB,0.23385E+00_JPRB /)  
KB(:,25, 1) = (/ &
 & 0.16856E+00_JPRB,0.17939E+00_JPRB,0.19493E+00_JPRB,0.21495E+00_JPRB,0.23943E+00_JPRB /)  
KB(:,26, 1) = (/ &
 & 0.17067E+00_JPRB,0.18260E+00_JPRB,0.19919E+00_JPRB,0.22024E+00_JPRB,0.24578E+00_JPRB /)  
KB(:,27, 1) = (/ &
 & 0.17306E+00_JPRB,0.18613E+00_JPRB,0.20377E+00_JPRB,0.22588E+00_JPRB,0.25248E+00_JPRB /)  
KB(:,28, 1) = (/ &
 & 0.17570E+00_JPRB,0.18994E+00_JPRB,0.20865E+00_JPRB,0.23184E+00_JPRB,0.25952E+00_JPRB /)  
KB(:,29, 1) = (/ &
 & 0.17882E+00_JPRB,0.19417E+00_JPRB,0.21399E+00_JPRB,0.23828E+00_JPRB,0.26708E+00_JPRB /)  
KB(:,30, 1) = (/ &
 & 0.18223E+00_JPRB,0.19870E+00_JPRB,0.21964E+00_JPRB,0.24505E+00_JPRB,0.27492E+00_JPRB /)  
KB(:,31, 1) = (/ &
 & 0.18602E+00_JPRB,0.20364E+00_JPRB,0.22572E+00_JPRB,0.25229E+00_JPRB,0.28325E+00_JPRB /)  
KB(:,32, 1) = (/ &
 & 0.19018E+00_JPRB,0.20895E+00_JPRB,0.23219E+00_JPRB,0.25994E+00_JPRB,0.29200E+00_JPRB /)  
KB(:,33, 1) = (/ &
 & 0.19466E+00_JPRB,0.21461E+00_JPRB,0.23902E+00_JPRB,0.26795E+00_JPRB,0.30114E+00_JPRB /)  
KB(:,34, 1) = (/ &
 & 0.19880E+00_JPRB,0.21976E+00_JPRB,0.24520E+00_JPRB,0.27509E+00_JPRB,0.30932E+00_JPRB /)  
KB(:,35, 1) = (/ &
 & 0.20129E+00_JPRB,0.22283E+00_JPRB,0.24886E+00_JPRB,0.27931E+00_JPRB,0.31412E+00_JPRB /)  
KB(:,36, 1) = (/ &
 & 0.20170E+00_JPRB,0.22334E+00_JPRB,0.24946E+00_JPRB,0.28000E+00_JPRB,0.31492E+00_JPRB /)  
KB(:,37, 1) = (/ &
 & 0.19920E+00_JPRB,0.22026E+00_JPRB,0.24579E+00_JPRB,0.27578E+00_JPRB,0.31010E+00_JPRB /)  
KB(:,38, 1) = (/ &
 & 0.19662E+00_JPRB,0.21706E+00_JPRB,0.24197E+00_JPRB,0.27135E+00_JPRB,0.30504E+00_JPRB /)  
KB(:,39, 1) = (/ &
 & 0.19414E+00_JPRB,0.21396E+00_JPRB,0.23824E+00_JPRB,0.26704E+00_JPRB,0.30010E+00_JPRB /)  
KB(:,40, 1) = (/ &
 & 0.19003E+00_JPRB,0.20877E+00_JPRB,0.23197E+00_JPRB,0.25968E+00_JPRB,0.29171E+00_JPRB /)  
KB(:,41, 1) = (/ &
 & 0.18597E+00_JPRB,0.20357E+00_JPRB,0.22564E+00_JPRB,0.25219E+00_JPRB,0.28314E+00_JPRB /)  
KB(:,42, 1) = (/ &
 & 0.18220E+00_JPRB,0.19865E+00_JPRB,0.21958E+00_JPRB,0.24498E+00_JPRB,0.27484E+00_JPRB /)  
KB(:,43, 1) = (/ &
 & 0.17798E+00_JPRB,0.19304E+00_JPRB,0.21257E+00_JPRB,0.23657E+00_JPRB,0.26510E+00_JPRB /)  
KB(:,44, 1) = (/ &
 & 0.17397E+00_JPRB,0.18746E+00_JPRB,0.20548E+00_JPRB,0.22798E+00_JPRB,0.25496E+00_JPRB /)  
KB(:,45, 1) = (/ &
 & 0.17053E+00_JPRB,0.18239E+00_JPRB,0.19890E+00_JPRB,0.21989E+00_JPRB,0.24535E+00_JPRB /)  
KB(:,46, 1) = (/ &
 & 0.16739E+00_JPRB,0.17754E+00_JPRB,0.19245E+00_JPRB,0.21183E+00_JPRB,0.23568E+00_JPRB /)  
KB(:,47, 1) = (/ &
 & 0.16454E+00_JPRB,0.17292E+00_JPRB,0.18592E+00_JPRB,0.20351E+00_JPRB,0.22556E+00_JPRB /)  
KB(:,48, 1) = (/ &
 & 0.16239E+00_JPRB,0.16903E+00_JPRB,0.18011E+00_JPRB,0.19590E+00_JPRB,0.21615E+00_JPRB /)  
KB(:,49, 1) = (/ &
 & 0.16095E+00_JPRB,0.16584E+00_JPRB,0.17504E+00_JPRB,0.18902E+00_JPRB,0.20747E+00_JPRB /)  
KB(:,50, 1) = (/ &
 & 0.16025E+00_JPRB,0.16348E+00_JPRB,0.17109E+00_JPRB,0.18322E+00_JPRB,0.20000E+00_JPRB /)  
KB(:,51, 1) = (/ &
 & 0.16021E+00_JPRB,0.16179E+00_JPRB,0.16781E+00_JPRB,0.17821E+00_JPRB,0.19335E+00_JPRB /)  
KB(:,52, 1) = (/ &
 & 0.16078E+00_JPRB,0.16068E+00_JPRB,0.16511E+00_JPRB,0.17387E+00_JPRB,0.18731E+00_JPRB /)  
KB(:,53, 1) = (/ &
 & 0.16197E+00_JPRB,0.16018E+00_JPRB,0.16299E+00_JPRB,0.17017E+00_JPRB,0.18186E+00_JPRB /)  
KB(:,54, 1) = (/ &
 & 0.16362E+00_JPRB,0.16026E+00_JPRB,0.16155E+00_JPRB,0.16729E+00_JPRB,0.17738E+00_JPRB /)  
KB(:,55, 1) = (/ &
 & 0.16570E+00_JPRB,0.16083E+00_JPRB,0.16064E+00_JPRB,0.16498E+00_JPRB,0.17365E+00_JPRB /)  
KB(:,56, 1) = (/ &
 & 0.16825E+00_JPRB,0.16187E+00_JPRB,0.16020E+00_JPRB,0.16311E+00_JPRB,0.17041E+00_JPRB /)  
KB(:,57, 1) = (/ &
 & 0.17129E+00_JPRB,0.16340E+00_JPRB,0.16023E+00_JPRB,0.16169E+00_JPRB,0.16761E+00_JPRB /)  
KB(:,58, 1) = (/ &
 & 0.17462E+00_JPRB,0.16529E+00_JPRB,0.16069E+00_JPRB,0.16077E+00_JPRB,0.16535E+00_JPRB /)  
KB(:,59, 1) = (/ &
 & 0.17607E+00_JPRB,0.16617E+00_JPRB,0.16100E+00_JPRB,0.16051E+00_JPRB,0.16456E+00_JPRB /)  
KB(:,13, 2) = (/ &
 & 0.17525E+01_JPRB,0.17727E+01_JPRB,0.18119E+01_JPRB,0.18712E+01_JPRB,0.19491E+01_JPRB /)  
KB(:,14, 2) = (/ &
 & 0.17536E+01_JPRB,0.17755E+01_JPRB,0.18165E+01_JPRB,0.18775E+01_JPRB,0.19571E+01_JPRB /)  
KB(:,15, 2) = (/ &
 & 0.17549E+01_JPRB,0.17787E+01_JPRB,0.18219E+01_JPRB,0.18847E+01_JPRB,0.19662E+01_JPRB /)  
KB(:,16, 2) = (/ &
 & 0.17565E+01_JPRB,0.17819E+01_JPRB,0.18278E+01_JPRB,0.18925E+01_JPRB,0.19761E+01_JPRB /)  
KB(:,17, 2) = (/ &
 & 0.17583E+01_JPRB,0.17850E+01_JPRB,0.18336E+01_JPRB,0.19003E+01_JPRB,0.19859E+01_JPRB /)  
KB(:,18, 2) = (/ &
 & 0.17603E+01_JPRB,0.17891E+01_JPRB,0.18396E+01_JPRB,0.19082E+01_JPRB,0.19957E+01_JPRB /)  
KB(:,19, 2) = (/ &
 & 0.17624E+01_JPRB,0.17934E+01_JPRB,0.18457E+01_JPRB,0.19162E+01_JPRB,0.20056E+01_JPRB /)  
KB(:,20, 2) = (/ &
 & 0.17652E+01_JPRB,0.17986E+01_JPRB,0.18530E+01_JPRB,0.19257E+01_JPRB,0.20174E+01_JPRB /)  
KB(:,21, 2) = (/ &
 & 0.17683E+01_JPRB,0.18042E+01_JPRB,0.18607E+01_JPRB,0.19356E+01_JPRB,0.20296E+01_JPRB /)  
KB(:,22, 2) = (/ &
 & 0.17736E+01_JPRB,0.18133E+01_JPRB,0.18732E+01_JPRB,0.19516E+01_JPRB,0.20492E+01_JPRB /)  
KB(:,23, 2) = (/ &
 & 0.17796E+01_JPRB,0.18234E+01_JPRB,0.18868E+01_JPRB,0.19689E+01_JPRB,0.20702E+01_JPRB /)  
KB(:,24, 2) = (/ &
 & 0.17857E+01_JPRB,0.18347E+01_JPRB,0.19018E+01_JPRB,0.19877E+01_JPRB,0.20929E+01_JPRB /)  
KB(:,25, 2) = (/ &
 & 0.17946E+01_JPRB,0.18475E+01_JPRB,0.19185E+01_JPRB,0.20085E+01_JPRB,0.21178E+01_JPRB /)  
KB(:,26, 2) = (/ &
 & 0.18053E+01_JPRB,0.18623E+01_JPRB,0.19377E+01_JPRB,0.20322E+01_JPRB,0.21460E+01_JPRB /)  
KB(:,27, 2) = (/ &
 & 0.18172E+01_JPRB,0.18785E+01_JPRB,0.19583E+01_JPRB,0.20574E+01_JPRB,0.21757E+01_JPRB /)  
KB(:,28, 2) = (/ &
 & 0.18303E+01_JPRB,0.18959E+01_JPRB,0.19802E+01_JPRB,0.20839E+01_JPRB,0.22069E+01_JPRB /)  
KB(:,29, 2) = (/ &
 & 0.18448E+01_JPRB,0.19150E+01_JPRB,0.20042E+01_JPRB,0.21126E+01_JPRB,0.22404E+01_JPRB /)  
KB(:,30, 2) = (/ &
 & 0.18606E+01_JPRB,0.19355E+01_JPRB,0.20295E+01_JPRB,0.21428E+01_JPRB,0.22754E+01_JPRB /)  
KB(:,31, 2) = (/ &
 & 0.18780E+01_JPRB,0.19577E+01_JPRB,0.20566E+01_JPRB,0.21749E+01_JPRB,0.23125E+01_JPRB /)  
KB(:,32, 2) = (/ &
 & 0.18969E+01_JPRB,0.19816E+01_JPRB,0.20855E+01_JPRB,0.22088E+01_JPRB,0.23514E+01_JPRB /)  
KB(:,33, 2) = (/ &
 & 0.19172E+01_JPRB,0.20069E+01_JPRB,0.21160E+01_JPRB,0.22443E+01_JPRB,0.23920E+01_JPRB /)  
KB(:,34, 2) = (/ &
 & 0.19359E+01_JPRB,0.20300E+01_JPRB,0.21434E+01_JPRB,0.22762E+01_JPRB,0.24282E+01_JPRB /)  
KB(:,35, 2) = (/ &
 & 0.19471E+01_JPRB,0.20437E+01_JPRB,0.21597E+01_JPRB,0.22949E+01_JPRB,0.24495E+01_JPRB /)  
KB(:,36, 2) = (/ &
 & 0.19490E+01_JPRB,0.20460E+01_JPRB,0.21624E+01_JPRB,0.22980E+01_JPRB,0.24530E+01_JPRB /)  
KB(:,37, 2) = (/ &
 & 0.19377E+01_JPRB,0.20322E+01_JPRB,0.21461E+01_JPRB,0.22792E+01_JPRB,0.24317E+01_JPRB /)  
KB(:,38, 2) = (/ &
 & 0.19261E+01_JPRB,0.20179E+01_JPRB,0.21291E+01_JPRB,0.22595E+01_JPRB,0.24093E+01_JPRB /)  
KB(:,39, 2) = (/ &
 & 0.19149E+01_JPRB,0.20040E+01_JPRB,0.21125E+01_JPRB,0.22402E+01_JPRB,0.23873E+01_JPRB /)  
KB(:,40, 2) = (/ &
 & 0.18963E+01_JPRB,0.19807E+01_JPRB,0.20845E+01_JPRB,0.22076E+01_JPRB,0.23501E+01_JPRB /)  
KB(:,41, 2) = (/ &
 & 0.18778E+01_JPRB,0.19574E+01_JPRB,0.20563E+01_JPRB,0.21745E+01_JPRB,0.23120E+01_JPRB /)  
KB(:,42, 2) = (/ &
 & 0.18604E+01_JPRB,0.19352E+01_JPRB,0.20292E+01_JPRB,0.21425E+01_JPRB,0.22750E+01_JPRB /)  
KB(:,43, 2) = (/ &
 & 0.18409E+01_JPRB,0.19099E+01_JPRB,0.19978E+01_JPRB,0.21050E+01_JPRB,0.22315E+01_JPRB /)  
KB(:,44, 2) = (/ &
 & 0.18217E+01_JPRB,0.18845E+01_JPRB,0.19660E+01_JPRB,0.20667E+01_JPRB,0.21867E+01_JPRB /)  
KB(:,45, 2) = (/ &
 & 0.18046E+01_JPRB,0.18613E+01_JPRB,0.19364E+01_JPRB,0.20306E+01_JPRB,0.21441E+01_JPRB /)  
KB(:,46, 2) = (/ &
 & 0.17886E+01_JPRB,0.18389E+01_JPRB,0.19072E+01_JPRB,0.19945E+01_JPRB,0.21011E+01_JPRB /)  
KB(:,47, 2) = (/ &
 & 0.17755E+01_JPRB,0.18165E+01_JPRB,0.18775E+01_JPRB,0.19571E+01_JPRB,0.20559E+01_JPRB /)  
KB(:,48, 2) = (/ &
 & 0.17644E+01_JPRB,0.17970E+01_JPRB,0.18508E+01_JPRB,0.19228E+01_JPRB,0.20139E+01_JPRB /)  
KB(:,49, 2) = (/ &
 & 0.17563E+01_JPRB,0.17816E+01_JPRB,0.18271E+01_JPRB,0.18916E+01_JPRB,0.19749E+01_JPRB /)  
KB(:,50, 2) = (/ &
 & 0.17517E+01_JPRB,0.17702E+01_JPRB,0.18074E+01_JPRB,0.18651E+01_JPRB,0.19413E+01_JPRB /)  
KB(:,51, 2) = (/ &
 & 0.17504E+01_JPRB,0.17611E+01_JPRB,0.17908E+01_JPRB,0.18420E+01_JPRB,0.19113E+01_JPRB /)  
KB(:,52, 2) = (/ &
 & 0.17523E+01_JPRB,0.17547E+01_JPRB,0.17783E+01_JPRB,0.18212E+01_JPRB,0.18839E+01_JPRB /)  
KB(:,53, 2) = (/ &
 & 0.17566E+01_JPRB,0.17510E+01_JPRB,0.17675E+01_JPRB,0.18028E+01_JPRB,0.18589E+01_JPRB /)  
KB(:,54, 2) = (/ &
 & 0.17623E+01_JPRB,0.17507E+01_JPRB,0.17598E+01_JPRB,0.17881E+01_JPRB,0.18381E+01_JPRB /)  
KB(:,55, 2) = (/ &
 & 0.17691E+01_JPRB,0.17524E+01_JPRB,0.17544E+01_JPRB,0.17777E+01_JPRB,0.18201E+01_JPRB /)  
KB(:,56, 2) = (/ &
 & 0.17776E+01_JPRB,0.17562E+01_JPRB,0.17512E+01_JPRB,0.17682E+01_JPRB,0.18040E+01_JPRB /)  
KB(:,57, 2) = (/ &
 & 0.17881E+01_JPRB,0.17616E+01_JPRB,0.17505E+01_JPRB,0.17606E+01_JPRB,0.17897E+01_JPRB /)  
KB(:,58, 2) = (/ &
 & 0.17996E+01_JPRB,0.17678E+01_JPRB,0.17520E+01_JPRB,0.17552E+01_JPRB,0.17794E+01_JPRB /)  
KB(:,59, 2) = (/ &
 & 0.18045E+01_JPRB,0.17707E+01_JPRB,0.17530E+01_JPRB,0.17536E+01_JPRB,0.17756E+01_JPRB /)  
KB(:,13, 3) = (/ &
 & 0.10945E+02_JPRB,0.11052E+02_JPRB,0.11222E+02_JPRB,0.11452E+02_JPRB,0.11744E+02_JPRB /)  
KB(:,14, 3) = (/ &
 & 0.10952E+02_JPRB,0.11065E+02_JPRB,0.11240E+02_JPRB,0.11476E+02_JPRB,0.11774E+02_JPRB /)  
KB(:,15, 3) = (/ &
 & 0.10961E+02_JPRB,0.11080E+02_JPRB,0.11261E+02_JPRB,0.11503E+02_JPRB,0.11807E+02_JPRB /)  
KB(:,16, 3) = (/ &
 & 0.10971E+02_JPRB,0.11097E+02_JPRB,0.11284E+02_JPRB,0.11533E+02_JPRB,0.11844E+02_JPRB /)  
KB(:,17, 3) = (/ &
 & 0.10981E+02_JPRB,0.11115E+02_JPRB,0.11307E+02_JPRB,0.11562E+02_JPRB,0.11879E+02_JPRB /)  
KB(:,18, 3) = (/ &
 & 0.10992E+02_JPRB,0.11132E+02_JPRB,0.11331E+02_JPRB,0.11592E+02_JPRB,0.11915E+02_JPRB /)  
KB(:,19, 3) = (/ &
 & 0.11003E+02_JPRB,0.11149E+02_JPRB,0.11354E+02_JPRB,0.11622E+02_JPRB,0.11951E+02_JPRB /)  
KB(:,20, 3) = (/ &
 & 0.11017E+02_JPRB,0.11170E+02_JPRB,0.11382E+02_JPRB,0.11657E+02_JPRB,0.11994E+02_JPRB /)  
KB(:,21, 3) = (/ &
 & 0.11031E+02_JPRB,0.11192E+02_JPRB,0.11412E+02_JPRB,0.11694E+02_JPRB,0.12038E+02_JPRB /)  
KB(:,22, 3) = (/ &
 & 0.11056E+02_JPRB,0.11228E+02_JPRB,0.11460E+02_JPRB,0.11754E+02_JPRB,0.12109E+02_JPRB /)  
KB(:,23, 3) = (/ &
 & 0.11085E+02_JPRB,0.11267E+02_JPRB,0.11511E+02_JPRB,0.11817E+02_JPRB,0.12184E+02_JPRB /)  
KB(:,24, 3) = (/ &
 & 0.11118E+02_JPRB,0.11312E+02_JPRB,0.11568E+02_JPRB,0.11886E+02_JPRB,0.12266E+02_JPRB /)  
KB(:,25, 3) = (/ &
 & 0.11154E+02_JPRB,0.11361E+02_JPRB,0.11630E+02_JPRB,0.11962E+02_JPRB,0.12354E+02_JPRB /)  
KB(:,26, 3) = (/ &
 & 0.11196E+02_JPRB,0.11418E+02_JPRB,0.11702E+02_JPRB,0.12048E+02_JPRB,0.12455E+02_JPRB /)  
KB(:,27, 3) = (/ &
 & 0.11243E+02_JPRB,0.11480E+02_JPRB,0.11778E+02_JPRB,0.12138E+02_JPRB,0.12560E+02_JPRB /)  
KB(:,28, 3) = (/ &
 & 0.11294E+02_JPRB,0.11545E+02_JPRB,0.11859E+02_JPRB,0.12234E+02_JPRB,0.12670E+02_JPRB /)  
KB(:,29, 3) = (/ &
 & 0.11351E+02_JPRB,0.11617E+02_JPRB,0.11946E+02_JPRB,0.12336E+02_JPRB,0.12788E+02_JPRB /)  
KB(:,30, 3) = (/ &
 & 0.11411E+02_JPRB,0.11694E+02_JPRB,0.12038E+02_JPRB,0.12443E+02_JPRB,0.12910E+02_JPRB /)  
KB(:,31, 3) = (/ &
 & 0.11478E+02_JPRB,0.11776E+02_JPRB,0.12136E+02_JPRB,0.12557E+02_JPRB,0.13040E+02_JPRB /)  
KB(:,32, 3) = (/ &
 & 0.11549E+02_JPRB,0.11864E+02_JPRB,0.12239E+02_JPRB,0.12677E+02_JPRB,0.13175E+02_JPRB /)  
KB(:,33, 3) = (/ &
 & 0.11626E+02_JPRB,0.11956E+02_JPRB,0.12348E+02_JPRB,0.12801E+02_JPRB,0.13316E+02_JPRB /)  
KB(:,34, 3) = (/ &
 & 0.11695E+02_JPRB,0.12040E+02_JPRB,0.12446E+02_JPRB,0.12913E+02_JPRB,0.13442E+02_JPRB /)  
KB(:,35, 3) = (/ &
 & 0.11737E+02_JPRB,0.12089E+02_JPRB,0.12503E+02_JPRB,0.12979E+02_JPRB,0.13515E+02_JPRB /)  
KB(:,36, 3) = (/ &
 & 0.11744E+02_JPRB,0.12098E+02_JPRB,0.12513E+02_JPRB,0.12989E+02_JPRB,0.13528E+02_JPRB /)  
KB(:,37, 3) = (/ &
 & 0.11702E+02_JPRB,0.12048E+02_JPRB,0.12455E+02_JPRB,0.12924E+02_JPRB,0.13454E+02_JPRB /)  
KB(:,38, 3) = (/ &
 & 0.11659E+02_JPRB,0.11996E+02_JPRB,0.12395E+02_JPRB,0.12855E+02_JPRB,0.13376E+02_JPRB /)  
KB(:,39, 3) = (/ &
 & 0.11617E+02_JPRB,0.11946E+02_JPRB,0.12336E+02_JPRB,0.12787E+02_JPRB,0.13300E+02_JPRB /)  
KB(:,40, 3) = (/ &
 & 0.11547E+02_JPRB,0.11861E+02_JPRB,0.12236E+02_JPRB,0.12673E+02_JPRB,0.13171E+02_JPRB /)  
KB(:,41, 3) = (/ &
 & 0.11477E+02_JPRB,0.11775E+02_JPRB,0.12134E+02_JPRB,0.12555E+02_JPRB,0.13038E+02_JPRB /)  
KB(:,42, 3) = (/ &
 & 0.11411E+02_JPRB,0.11693E+02_JPRB,0.12037E+02_JPRB,0.12442E+02_JPRB,0.12909E+02_JPRB /)  
KB(:,43, 3) = (/ &
 & 0.11335E+02_JPRB,0.11598E+02_JPRB,0.11923E+02_JPRB,0.12309E+02_JPRB,0.12757E+02_JPRB /)  
KB(:,44, 3) = (/ &
 & 0.11261E+02_JPRB,0.11503E+02_JPRB,0.11807E+02_JPRB,0.12172E+02_JPRB,0.12599E+02_JPRB /)  
KB(:,45, 3) = (/ &
 & 0.11193E+02_JPRB,0.11414E+02_JPRB,0.11697E+02_JPRB,0.12042E+02_JPRB,0.12448E+02_JPRB /)  
KB(:,46, 3) = (/ &
 & 0.11129E+02_JPRB,0.11328E+02_JPRB,0.11588E+02_JPRB,0.11911E+02_JPRB,0.12295E+02_JPRB /)  
KB(:,47, 3) = (/ &
 & 0.11065E+02_JPRB,0.11240E+02_JPRB,0.11476E+02_JPRB,0.11774E+02_JPRB,0.12133E+02_JPRB /)  
KB(:,48, 3) = (/ &
 & 0.11012E+02_JPRB,0.11163E+02_JPRB,0.11374E+02_JPRB,0.11647E+02_JPRB,0.11981E+02_JPRB /)  
KB(:,49, 3) = (/ &
 & 0.10969E+02_JPRB,0.11095E+02_JPRB,0.11282E+02_JPRB,0.11530E+02_JPRB,0.11839E+02_JPRB /)  
KB(:,50, 3) = (/ &
 & 0.10938E+02_JPRB,0.11040E+02_JPRB,0.11204E+02_JPRB,0.11429E+02_JPRB,0.11715E+02_JPRB /)  
KB(:,51, 3) = (/ &
 & 0.10916E+02_JPRB,0.10996E+02_JPRB,0.11138E+02_JPRB,0.11340E+02_JPRB,0.11604E+02_JPRB /)  
KB(:,52, 3) = (/ &
 & 0.10900E+02_JPRB,0.10960E+02_JPRB,0.11079E+02_JPRB,0.11259E+02_JPRB,0.11500E+02_JPRB /)  
KB(:,53, 3) = (/ &
 & 0.10894E+02_JPRB,0.10932E+02_JPRB,0.11028E+02_JPRB,0.11186E+02_JPRB,0.11405E+02_JPRB /)  
KB(:,54, 3) = (/ &
 & 0.10895E+02_JPRB,0.10912E+02_JPRB,0.10989E+02_JPRB,0.11127E+02_JPRB,0.11325E+02_JPRB /)  
KB(:,55, 3) = (/ &
 & 0.10903E+02_JPRB,0.10900E+02_JPRB,0.10958E+02_JPRB,0.11075E+02_JPRB,0.11255E+02_JPRB /)  
KB(:,56, 3) = (/ &
 & 0.10921E+02_JPRB,0.10894E+02_JPRB,0.10933E+02_JPRB,0.11031E+02_JPRB,0.11191E+02_JPRB /)  
KB(:,57, 3) = (/ &
 & 0.10944E+02_JPRB,0.10894E+02_JPRB,0.10914E+02_JPRB,0.10993E+02_JPRB,0.11134E+02_JPRB /)  
KB(:,58, 3) = (/ &
 & 0.10972E+02_JPRB,0.10901E+02_JPRB,0.10902E+02_JPRB,0.10963E+02_JPRB,0.11084E+02_JPRB /)  
KB(:,59, 3) = (/ &
 & 0.10984E+02_JPRB,0.10906E+02_JPRB,0.10898E+02_JPRB,0.10952E+02_JPRB,0.11066E+02_JPRB /)  
KB(:,13, 4) = (/ &
 & 0.51563E+02_JPRB,0.51946E+02_JPRB,0.52464E+02_JPRB,0.53116E+02_JPRB,0.53902E+02_JPRB /)  
KB(:,14, 4) = (/ &
 & 0.51593E+02_JPRB,0.51987E+02_JPRB,0.52517E+02_JPRB,0.53182E+02_JPRB,0.53980E+02_JPRB /)  
KB(:,15, 4) = (/ &
 & 0.51626E+02_JPRB,0.52035E+02_JPRB,0.52579E+02_JPRB,0.53256E+02_JPRB,0.54069E+02_JPRB /)  
KB(:,16, 4) = (/ &
 & 0.51664E+02_JPRB,0.52087E+02_JPRB,0.52644E+02_JPRB,0.53337E+02_JPRB,0.54163E+02_JPRB /)  
KB(:,17, 4) = (/ &
 & 0.51701E+02_JPRB,0.52138E+02_JPRB,0.52710E+02_JPRB,0.53416E+02_JPRB,0.54257E+02_JPRB /)  
KB(:,18, 4) = (/ &
 & 0.51740E+02_JPRB,0.52191E+02_JPRB,0.52776E+02_JPRB,0.53496E+02_JPRB,0.54351E+02_JPRB /)  
KB(:,19, 4) = (/ &
 & 0.51779E+02_JPRB,0.52244E+02_JPRB,0.52843E+02_JPRB,0.53576E+02_JPRB,0.54444E+02_JPRB /)  
KB(:,20, 4) = (/ &
 & 0.51827E+02_JPRB,0.52307E+02_JPRB,0.52922E+02_JPRB,0.53671E+02_JPRB,0.54555E+02_JPRB /)  
KB(:,21, 4) = (/ &
 & 0.51877E+02_JPRB,0.52373E+02_JPRB,0.53004E+02_JPRB,0.53770E+02_JPRB,0.54669E+02_JPRB /)  
KB(:,22, 4) = (/ &
 & 0.51959E+02_JPRB,0.52481E+02_JPRB,0.53136E+02_JPRB,0.53927E+02_JPRB,0.54851E+02_JPRB /)  
KB(:,23, 4) = (/ &
 & 0.52049E+02_JPRB,0.52596E+02_JPRB,0.53278E+02_JPRB,0.54094E+02_JPRB,0.55044E+02_JPRB /)  
KB(:,24, 4) = (/ &
 & 0.52148E+02_JPRB,0.52723E+02_JPRB,0.53431E+02_JPRB,0.54274E+02_JPRB,0.55252E+02_JPRB /)  
KB(:,25, 4) = (/ &
 & 0.52259E+02_JPRB,0.52862E+02_JPRB,0.53599E+02_JPRB,0.54471E+02_JPRB,0.55477E+02_JPRB /)  
KB(:,26, 4) = (/ &
 & 0.52387E+02_JPRB,0.53022E+02_JPRB,0.53790E+02_JPRB,0.54693E+02_JPRB,0.55730E+02_JPRB /)  
KB(:,27, 4) = (/ &
 & 0.52525E+02_JPRB,0.53191E+02_JPRB,0.53992E+02_JPRB,0.54926E+02_JPRB,0.55995E+02_JPRB /)  
KB(:,28, 4) = (/ &
 & 0.52672E+02_JPRB,0.53371E+02_JPRB,0.54203E+02_JPRB,0.55170E+02_JPRB,0.56271E+02_JPRB /)  
KB(:,29, 4) = (/ &
 & 0.52833E+02_JPRB,0.53565E+02_JPRB,0.54430E+02_JPRB,0.55430E+02_JPRB,0.56565E+02_JPRB /)  
KB(:,30, 4) = (/ &
 & 0.53003E+02_JPRB,0.53768E+02_JPRB,0.54668E+02_JPRB,0.55702E+02_JPRB,0.56870E+02_JPRB /)  
KB(:,31, 4) = (/ &
 & 0.53186E+02_JPRB,0.53986E+02_JPRB,0.54920E+02_JPRB,0.55988E+02_JPRB,0.57190E+02_JPRB /)  
KB(:,32, 4) = (/ &
 & 0.53381E+02_JPRB,0.54216E+02_JPRB,0.55184E+02_JPRB,0.56287E+02_JPRB,0.57525E+02_JPRB /)  
KB(:,33, 4) = (/ &
 & 0.53587E+02_JPRB,0.54457E+02_JPRB,0.55460E+02_JPRB,0.56599E+02_JPRB,0.57871E+02_JPRB /)  
KB(:,34, 4) = (/ &
 & 0.53773E+02_JPRB,0.54673E+02_JPRB,0.55707E+02_JPRB,0.56876E+02_JPRB,0.58179E+02_JPRB /)  
KB(:,35, 4) = (/ &
 & 0.53883E+02_JPRB,0.54800E+02_JPRB,0.55852E+02_JPRB,0.57039E+02_JPRB,0.58359E+02_JPRB /)  
KB(:,36, 4) = (/ &
 & 0.53901E+02_JPRB,0.54822E+02_JPRB,0.55876E+02_JPRB,0.57066E+02_JPRB,0.58389E+02_JPRB /)  
KB(:,37, 4) = (/ &
 & 0.53791E+02_JPRB,0.54694E+02_JPRB,0.55731E+02_JPRB,0.56903E+02_JPRB,0.58208E+02_JPRB /)  
KB(:,38, 4) = (/ &
 & 0.53676E+02_JPRB,0.54560E+02_JPRB,0.55578E+02_JPRB,0.56731E+02_JPRB,0.58018E+02_JPRB /)  
KB(:,39, 4) = (/ &
 & 0.53563E+02_JPRB,0.54429E+02_JPRB,0.55429E+02_JPRB,0.56563E+02_JPRB,0.57832E+02_JPRB /)  
KB(:,40, 4) = (/ &
 & 0.53375E+02_JPRB,0.54208E+02_JPRB,0.55175E+02_JPRB,0.56277E+02_JPRB,0.57513E+02_JPRB /)  
KB(:,41, 4) = (/ &
 & 0.53184E+02_JPRB,0.53983E+02_JPRB,0.54916E+02_JPRB,0.55984E+02_JPRB,0.57186E+02_JPRB /)  
KB(:,42, 4) = (/ &
 & 0.53001E+02_JPRB,0.53766E+02_JPRB,0.54665E+02_JPRB,0.55699E+02_JPRB,0.56866E+02_JPRB /)  
KB(:,43, 4) = (/ &
 & 0.52790E+02_JPRB,0.53513E+02_JPRB,0.54370E+02_JPRB,0.55362E+02_JPRB,0.56488E+02_JPRB /)  
KB(:,44, 4) = (/ &
 & 0.52577E+02_JPRB,0.53254E+02_JPRB,0.54066E+02_JPRB,0.55012E+02_JPRB,0.56093E+02_JPRB /)  
KB(:,45, 4) = (/ &
 & 0.52379E+02_JPRB,0.53011E+02_JPRB,0.53777E+02_JPRB,0.54678E+02_JPRB,0.55713E+02_JPRB /)  
KB(:,46, 4) = (/ &
 & 0.52184E+02_JPRB,0.52768E+02_JPRB,0.53486E+02_JPRB,0.54339E+02_JPRB,0.55326E+02_JPRB /)  
KB(:,47, 4) = (/ &
 & 0.51987E+02_JPRB,0.52517E+02_JPRB,0.53182E+02_JPRB,0.53980E+02_JPRB,0.54913E+02_JPRB /)  
KB(:,48, 4) = (/ &
 & 0.51812E+02_JPRB,0.52288E+02_JPRB,0.52898E+02_JPRB,0.53643E+02_JPRB,0.54522E+02_JPRB /)  
KB(:,49, 4) = (/ &
 & 0.51659E+02_JPRB,0.52081E+02_JPRB,0.52637E+02_JPRB,0.53327E+02_JPRB,0.54152E+02_JPRB /)  
KB(:,50, 4) = (/ &
 & 0.51535E+02_JPRB,0.51906E+02_JPRB,0.52412E+02_JPRB,0.53052E+02_JPRB,0.53826E+02_JPRB /)  
KB(:,51, 4) = (/ &
 & 0.51433E+02_JPRB,0.51755E+02_JPRB,0.52211E+02_JPRB,0.52802E+02_JPRB,0.53527E+02_JPRB /)  
KB(:,52, 4) = (/ &
 & 0.51349E+02_JPRB,0.51622E+02_JPRB,0.52029E+02_JPRB,0.52571E+02_JPRB,0.53247E+02_JPRB /)  
KB(:,53, 4) = (/ &
 & 0.51285E+02_JPRB,0.51507E+02_JPRB,0.51865E+02_JPRB,0.52358E+02_JPRB,0.52985E+02_JPRB /)  
KB(:,54, 4) = (/ &
 & 0.51240E+02_JPRB,0.51417E+02_JPRB,0.51730E+02_JPRB,0.52178E+02_JPRB,0.52760E+02_JPRB /)  
KB(:,55, 4) = (/ &
 & 0.51211E+02_JPRB,0.51346E+02_JPRB,0.51615E+02_JPRB,0.52020E+02_JPRB,0.52559E+02_JPRB /)  
KB(:,56, 4) = (/ &
 & 0.51194E+02_JPRB,0.51288E+02_JPRB,0.51514E+02_JPRB,0.51875E+02_JPRB,0.52371E+02_JPRB /)  
KB(:,57, 4) = (/ &
 & 0.51190E+02_JPRB,0.51245E+02_JPRB,0.51426E+02_JPRB,0.51746E+02_JPRB,0.52198E+02_JPRB /)  
KB(:,58, 4) = (/ &
 & 0.51200E+02_JPRB,0.51216E+02_JPRB,0.51357E+02_JPRB,0.51635E+02_JPRB,0.52046E+02_JPRB /)  
KB(:,59, 4) = (/ &
 & 0.51207E+02_JPRB,0.51207E+02_JPRB,0.51333E+02_JPRB,0.51594E+02_JPRB,0.51989E+02_JPRB /)  
KB(:,13, 5) = (/ &
 & 0.17051E+03_JPRB,0.17168E+03_JPRB,0.17297E+03_JPRB,0.17437E+03_JPRB,0.17590E+03_JPRB /)  
KB(:,14, 5) = (/ &
 & 0.17061E+03_JPRB,0.17179E+03_JPRB,0.17309E+03_JPRB,0.17451E+03_JPRB,0.17604E+03_JPRB /)  
KB(:,15, 5) = (/ &
 & 0.17073E+03_JPRB,0.17192E+03_JPRB,0.17323E+03_JPRB,0.17466E+03_JPRB,0.17621E+03_JPRB /)  
KB(:,16, 5) = (/ &
 & 0.17085E+03_JPRB,0.17205E+03_JPRB,0.17338E+03_JPRB,0.17482E+03_JPRB,0.17638E+03_JPRB /)  
KB(:,17, 5) = (/ &
 & 0.17097E+03_JPRB,0.17218E+03_JPRB,0.17352E+03_JPRB,0.17497E+03_JPRB,0.17655E+03_JPRB /)  
KB(:,18, 5) = (/ &
 & 0.17109E+03_JPRB,0.17232E+03_JPRB,0.17366E+03_JPRB,0.17513E+03_JPRB,0.17671E+03_JPRB /)  
KB(:,19, 5) = (/ &
 & 0.17121E+03_JPRB,0.17245E+03_JPRB,0.17381E+03_JPRB,0.17528E+03_JPRB,0.17688E+03_JPRB /)  
KB(:,20, 5) = (/ &
 & 0.17134E+03_JPRB,0.17260E+03_JPRB,0.17397E+03_JPRB,0.17547E+03_JPRB,0.17708E+03_JPRB /)  
KB(:,21, 5) = (/ &
 & 0.17149E+03_JPRB,0.17276E+03_JPRB,0.17415E+03_JPRB,0.17565E+03_JPRB,0.17728E+03_JPRB /)  
KB(:,22, 5) = (/ &
 & 0.17172E+03_JPRB,0.17301E+03_JPRB,0.17442E+03_JPRB,0.17594E+03_JPRB,0.17759E+03_JPRB /)  
KB(:,23, 5) = (/ &
 & 0.17195E+03_JPRB,0.17327E+03_JPRB,0.17470E+03_JPRB,0.17625E+03_JPRB,0.17792E+03_JPRB /)  
KB(:,24, 5) = (/ &
 & 0.17221E+03_JPRB,0.17355E+03_JPRB,0.17500E+03_JPRB,0.17658E+03_JPRB,0.17827E+03_JPRB /)  
KB(:,25, 5) = (/ &
 & 0.17248E+03_JPRB,0.17385E+03_JPRB,0.17533E+03_JPRB,0.17693E+03_JPRB,0.17865E+03_JPRB /)  
KB(:,26, 5) = (/ &
 & 0.17279E+03_JPRB,0.17418E+03_JPRB,0.17569E+03_JPRB,0.17732E+03_JPRB,0.17906E+03_JPRB /)  
KB(:,27, 5) = (/ &
 & 0.17311E+03_JPRB,0.17453E+03_JPRB,0.17606E+03_JPRB,0.17772E+03_JPRB,0.17949E+03_JPRB /)  
KB(:,28, 5) = (/ &
 & 0.17344E+03_JPRB,0.17488E+03_JPRB,0.17645E+03_JPRB,0.17813E+03_JPRB,0.17994E+03_JPRB /)  
KB(:,29, 5) = (/ &
 & 0.17379E+03_JPRB,0.17526E+03_JPRB,0.17686E+03_JPRB,0.17857E+03_JPRB,0.18040E+03_JPRB /)  
KB(:,30, 5) = (/ &
 & 0.17414E+03_JPRB,0.17565E+03_JPRB,0.17727E+03_JPRB,0.17902E+03_JPRB,0.18088E+03_JPRB /)  
KB(:,31, 5) = (/ &
 & 0.17452E+03_JPRB,0.17605E+03_JPRB,0.17771E+03_JPRB,0.17948E+03_JPRB,0.18137E+03_JPRB /)  
KB(:,32, 5) = (/ &
 & 0.17491E+03_JPRB,0.17647E+03_JPRB,0.17816E+03_JPRB,0.17996E+03_JPRB,0.18188E+03_JPRB /)  
KB(:,33, 5) = (/ &
 & 0.17531E+03_JPRB,0.17690E+03_JPRB,0.17862E+03_JPRB,0.18045E+03_JPRB,0.18241E+03_JPRB /)  
KB(:,34, 5) = (/ &
 & 0.17566E+03_JPRB,0.17728E+03_JPRB,0.17903E+03_JPRB,0.18089E+03_JPRB,0.18287E+03_JPRB /)  
KB(:,35, 5) = (/ &
 & 0.17586E+03_JPRB,0.17750E+03_JPRB,0.17926E+03_JPRB,0.18114E+03_JPRB,0.18313E+03_JPRB /)  
KB(:,36, 5) = (/ &
 & 0.17590E+03_JPRB,0.17754E+03_JPRB,0.17930E+03_JPRB,0.18118E+03_JPRB,0.18318E+03_JPRB /)  
KB(:,37, 5) = (/ &
 & 0.17569E+03_JPRB,0.17732E+03_JPRB,0.17906E+03_JPRB,0.18093E+03_JPRB,0.18291E+03_JPRB /)  
KB(:,38, 5) = (/ &
 & 0.17547E+03_JPRB,0.17708E+03_JPRB,0.17881E+03_JPRB,0.18066E+03_JPRB,0.18263E+03_JPRB /)  
KB(:,39, 5) = (/ &
 & 0.17526E+03_JPRB,0.17685E+03_JPRB,0.17857E+03_JPRB,0.18040E+03_JPRB,0.18235E+03_JPRB /)  
KB(:,40, 5) = (/ &
 & 0.17489E+03_JPRB,0.17646E+03_JPRB,0.17814E+03_JPRB,0.17995E+03_JPRB,0.18187E+03_JPRB /)  
KB(:,41, 5) = (/ &
 & 0.17451E+03_JPRB,0.17605E+03_JPRB,0.17770E+03_JPRB,0.17948E+03_JPRB,0.18137E+03_JPRB /)  
KB(:,42, 5) = (/ &
 & 0.17414E+03_JPRB,0.17565E+03_JPRB,0.17727E+03_JPRB,0.17901E+03_JPRB,0.18087E+03_JPRB /)  
KB(:,43, 5) = (/ &
 & 0.17369E+03_JPRB,0.17516E+03_JPRB,0.17675E+03_JPRB,0.17846E+03_JPRB,0.18028E+03_JPRB /)  
KB(:,44, 5) = (/ &
 & 0.17323E+03_JPRB,0.17465E+03_JPRB,0.17620E+03_JPRB,0.17787E+03_JPRB,0.17965E+03_JPRB /)  
KB(:,45, 5) = (/ &
 & 0.17277E+03_JPRB,0.17416E+03_JPRB,0.17567E+03_JPRB,0.17729E+03_JPRB,0.17904E+03_JPRB /)  
KB(:,46, 5) = (/ &
 & 0.17230E+03_JPRB,0.17365E+03_JPRB,0.17511E+03_JPRB,0.17669E+03_JPRB,0.17840E+03_JPRB /)  
KB(:,47, 5) = (/ &
 & 0.17179E+03_JPRB,0.17309E+03_JPRB,0.17451E+03_JPRB,0.17604E+03_JPRB,0.17770E+03_JPRB /)  
KB(:,48, 5) = (/ &
 & 0.17130E+03_JPRB,0.17255E+03_JPRB,0.17392E+03_JPRB,0.17541E+03_JPRB,0.17702E+03_JPRB /)  
KB(:,49, 5) = (/ &
 & 0.17083E+03_JPRB,0.17204E+03_JPRB,0.17336E+03_JPRB,0.17480E+03_JPRB,0.17636E+03_JPRB /)  
KB(:,50, 5) = (/ &
 & 0.17041E+03_JPRB,0.17157E+03_JPRB,0.17285E+03_JPRB,0.17424E+03_JPRB,0.17576E+03_JPRB /)  
KB(:,51, 5) = (/ &
 & 0.17002E+03_JPRB,0.17113E+03_JPRB,0.17237E+03_JPRB,0.17372E+03_JPRB,0.17519E+03_JPRB /)  
KB(:,52, 5) = (/ &
 & 0.16964E+03_JPRB,0.17071E+03_JPRB,0.17190E+03_JPRB,0.17321E+03_JPRB,0.17464E+03_JPRB /)  
KB(:,53, 5) = (/ &
 & 0.16927E+03_JPRB,0.17031E+03_JPRB,0.17145E+03_JPRB,0.17272E+03_JPRB,0.17411E+03_JPRB /)  
KB(:,54, 5) = (/ &
 & 0.16896E+03_JPRB,0.16995E+03_JPRB,0.17106E+03_JPRB,0.17228E+03_JPRB,0.17363E+03_JPRB /)  
KB(:,55, 5) = (/ &
 & 0.16866E+03_JPRB,0.16962E+03_JPRB,0.17069E+03_JPRB,0.17188E+03_JPRB,0.17318E+03_JPRB /)  
KB(:,56, 5) = (/ &
 & 0.16839E+03_JPRB,0.16930E+03_JPRB,0.17033E+03_JPRB,0.17148E+03_JPRB,0.17275E+03_JPRB /)  
KB(:,57, 5) = (/ &
 & 0.16812E+03_JPRB,0.16899E+03_JPRB,0.16999E+03_JPRB,0.17110E+03_JPRB,0.17233E+03_JPRB /)  
KB(:,58, 5) = (/ &
 & 0.16788E+03_JPRB,0.16871E+03_JPRB,0.16968E+03_JPRB,0.17075E+03_JPRB,0.17195E+03_JPRB /)  
KB(:,59, 5) = (/ &
 & 0.16779E+03_JPRB,0.16861E+03_JPRB,0.16955E+03_JPRB,0.17062E+03_JPRB,0.17180E+03_JPRB /)  
KB(:,13, 6) = (/ &
 & 0.38122E+03_JPRB,0.38406E+03_JPRB,0.38668E+03_JPRB,0.38908E+03_JPRB,0.39125E+03_JPRB /)  
KB(:,14, 6) = (/ &
 & 0.38148E+03_JPRB,0.38431E+03_JPRB,0.38691E+03_JPRB,0.38929E+03_JPRB,0.39144E+03_JPRB /)  
KB(:,15, 6) = (/ &
 & 0.38178E+03_JPRB,0.38458E+03_JPRB,0.38716E+03_JPRB,0.38951E+03_JPRB,0.39164E+03_JPRB /)  
KB(:,16, 6) = (/ &
 & 0.38209E+03_JPRB,0.38487E+03_JPRB,0.38742E+03_JPRB,0.38975E+03_JPRB,0.39186E+03_JPRB /)  
KB(:,17, 6) = (/ &
 & 0.38239E+03_JPRB,0.38514E+03_JPRB,0.38767E+03_JPRB,0.38998E+03_JPRB,0.39206E+03_JPRB /)  
KB(:,18, 6) = (/ &
 & 0.38268E+03_JPRB,0.38541E+03_JPRB,0.38792E+03_JPRB,0.39020E+03_JPRB,0.39226E+03_JPRB /)  
KB(:,19, 6) = (/ &
 & 0.38297E+03_JPRB,0.38568E+03_JPRB,0.38816E+03_JPRB,0.39042E+03_JPRB,0.39246E+03_JPRB /)  
KB(:,20, 6) = (/ &
 & 0.38330E+03_JPRB,0.38598E+03_JPRB,0.38844E+03_JPRB,0.39067E+03_JPRB,0.39268E+03_JPRB /)  
KB(:,21, 6) = (/ &
 & 0.38363E+03_JPRB,0.38629E+03_JPRB,0.38872E+03_JPRB,0.39092E+03_JPRB,0.39291E+03_JPRB /)  
KB(:,22, 6) = (/ &
 & 0.38414E+03_JPRB,0.38675E+03_JPRB,0.38914E+03_JPRB,0.39131E+03_JPRB,0.39325E+03_JPRB /)  
KB(:,23, 6) = (/ &
 & 0.38466E+03_JPRB,0.38723E+03_JPRB,0.38958E+03_JPRB,0.39170E+03_JPRB,0.39360E+03_JPRB /)  
KB(:,24, 6) = (/ &
 & 0.38520E+03_JPRB,0.38772E+03_JPRB,0.39002E+03_JPRB,0.39210E+03_JPRB,0.39395E+03_JPRB /)  
KB(:,25, 6) = (/ &
 & 0.38575E+03_JPRB,0.38823E+03_JPRB,0.39048E+03_JPRB,0.39251E+03_JPRB,0.39432E+03_JPRB /)  
KB(:,26, 6) = (/ &
 & 0.38635E+03_JPRB,0.38877E+03_JPRB,0.39098E+03_JPRB,0.39295E+03_JPRB,0.39470E+03_JPRB /)  
KB(:,27, 6) = (/ &
 & 0.38694E+03_JPRB,0.38932E+03_JPRB,0.39146E+03_JPRB,0.39339E+03_JPRB,0.39509E+03_JPRB /)  
KB(:,28, 6) = (/ &
 & 0.38753E+03_JPRB,0.38985E+03_JPRB,0.39194E+03_JPRB,0.39381E+03_JPRB,0.39546E+03_JPRB /)  
KB(:,29, 6) = (/ &
 & 0.38813E+03_JPRB,0.39039E+03_JPRB,0.39243E+03_JPRB,0.39424E+03_JPRB,0.39583E+03_JPRB /)  
KB(:,30, 6) = (/ &
 & 0.38871E+03_JPRB,0.39092E+03_JPRB,0.39290E+03_JPRB,0.39466E+03_JPRB,0.39620E+03_JPRB /)  
KB(:,31, 6) = (/ &
 & 0.38930E+03_JPRB,0.39145E+03_JPRB,0.39338E+03_JPRB,0.39508E+03_JPRB,0.39655E+03_JPRB /)  
KB(:,32, 6) = (/ &
 & 0.38988E+03_JPRB,0.39197E+03_JPRB,0.39384E+03_JPRB,0.39548E+03_JPRB,0.39690E+03_JPRB /)  
KB(:,33, 6) = (/ &
 & 0.39045E+03_JPRB,0.39248E+03_JPRB,0.39429E+03_JPRB,0.39587E+03_JPRB,0.39723E+03_JPRB /)  
KB(:,34, 6) = (/ &
 & 0.39093E+03_JPRB,0.39291E+03_JPRB,0.39467E+03_JPRB,0.39620E+03_JPRB,0.39751E+03_JPRB /)  
KB(:,35, 6) = (/ &
 & 0.39120E+03_JPRB,0.39316E+03_JPRB,0.39488E+03_JPRB,0.39639E+03_JPRB,0.39766E+03_JPRB /)  
KB(:,36, 6) = (/ &
 & 0.39125E+03_JPRB,0.39320E+03_JPRB,0.39492E+03_JPRB,0.39642E+03_JPRB,0.39769E+03_JPRB /)  
KB(:,37, 6) = (/ &
 & 0.39098E+03_JPRB,0.39295E+03_JPRB,0.39471E+03_JPRB,0.39623E+03_JPRB,0.39754E+03_JPRB /)  
KB(:,38, 6) = (/ &
 & 0.39068E+03_JPRB,0.39269E+03_JPRB,0.39447E+03_JPRB,0.39603E+03_JPRB,0.39737E+03_JPRB /)  
KB(:,39, 6) = (/ &
 & 0.39039E+03_JPRB,0.39243E+03_JPRB,0.39424E+03_JPRB,0.39583E+03_JPRB,0.39720E+03_JPRB /)  
KB(:,40, 6) = (/ &
 & 0.38986E+03_JPRB,0.39196E+03_JPRB,0.39382E+03_JPRB,0.39547E+03_JPRB,0.39689E+03_JPRB /)  
KB(:,41, 6) = (/ &
 & 0.38929E+03_JPRB,0.39144E+03_JPRB,0.39337E+03_JPRB,0.39507E+03_JPRB,0.39655E+03_JPRB /)  
KB(:,42, 6) = (/ &
 & 0.38871E+03_JPRB,0.39092E+03_JPRB,0.39290E+03_JPRB,0.39466E+03_JPRB,0.39619E+03_JPRB /)  
KB(:,43, 6) = (/ &
 & 0.38797E+03_JPRB,0.39025E+03_JPRB,0.39230E+03_JPRB,0.39413E+03_JPRB,0.39574E+03_JPRB /)  
KB(:,44, 6) = (/ &
 & 0.38715E+03_JPRB,0.38951E+03_JPRB,0.39164E+03_JPRB,0.39354E+03_JPRB,0.39522E+03_JPRB /)  
KB(:,45, 6) = (/ &
 & 0.38631E+03_JPRB,0.38874E+03_JPRB,0.39094E+03_JPRB,0.39292E+03_JPRB,0.39468E+03_JPRB /)  
KB(:,46, 6) = (/ &
 & 0.38538E+03_JPRB,0.38789E+03_JPRB,0.39018E+03_JPRB,0.39224E+03_JPRB,0.39407E+03_JPRB /)  
KB(:,47, 6) = (/ &
 & 0.38431E+03_JPRB,0.38691E+03_JPRB,0.38929E+03_JPRB,0.39144E+03_JPRB,0.39336E+03_JPRB /)  
KB(:,48, 6) = (/ &
 & 0.38320E+03_JPRB,0.38589E+03_JPRB,0.38836E+03_JPRB,0.39060E+03_JPRB,0.39262E+03_JPRB /)  
KB(:,49, 6) = (/ &
 & 0.38206E+03_JPRB,0.38484E+03_JPRB,0.38739E+03_JPRB,0.38972E+03_JPRB,0.39183E+03_JPRB /)  
KB(:,50, 6) = (/ &
 & 0.38095E+03_JPRB,0.38382E+03_JPRB,0.38646E+03_JPRB,0.38887E+03_JPRB,0.39106E+03_JPRB /)  
KB(:,51, 6) = (/ &
 & 0.37985E+03_JPRB,0.38279E+03_JPRB,0.38552E+03_JPRB,0.38802E+03_JPRB,0.39029E+03_JPRB /)  
KB(:,52, 6) = (/ &
 & 0.37873E+03_JPRB,0.38175E+03_JPRB,0.38455E+03_JPRB,0.38713E+03_JPRB,0.38949E+03_JPRB /)  
KB(:,53, 6) = (/ &
 & 0.37762E+03_JPRB,0.38067E+03_JPRB,0.38355E+03_JPRB,0.38621E+03_JPRB,0.38865E+03_JPRB /)  
KB(:,54, 6) = (/ &
 & 0.37661E+03_JPRB,0.37965E+03_JPRB,0.38261E+03_JPRB,0.38535E+03_JPRB,0.38786E+03_JPRB /)  
KB(:,55, 6) = (/ &
 & 0.37559E+03_JPRB,0.37867E+03_JPRB,0.38169E+03_JPRB,0.38450E+03_JPRB,0.38708E+03_JPRB /)  
KB(:,56, 6) = (/ &
 & 0.37459E+03_JPRB,0.37768E+03_JPRB,0.38074E+03_JPRB,0.38362E+03_JPRB,0.38628E+03_JPRB /)  
KB(:,57, 6) = (/ &
 & 0.37353E+03_JPRB,0.37673E+03_JPRB,0.37977E+03_JPRB,0.38272E+03_JPRB,0.38545E+03_JPRB /)  
KB(:,58, 6) = (/ &
 & 0.37251E+03_JPRB,0.37577E+03_JPRB,0.37885E+03_JPRB,0.38185E+03_JPRB,0.38465E+03_JPRB /)  
KB(:,59, 6) = (/ &
 & 0.37212E+03_JPRB,0.37539E+03_JPRB,0.37847E+03_JPRB,0.38150E+03_JPRB,0.38432E+03_JPRB /)  
KB(:,13, 7) = (/ &
 & 0.62583E+03_JPRB,0.62623E+03_JPRB,0.62691E+03_JPRB,0.62787E+03_JPRB,0.62909E+03_JPRB /)  
KB(:,14, 7) = (/ &
 & 0.62586E+03_JPRB,0.62628E+03_JPRB,0.62699E+03_JPRB,0.62797E+03_JPRB,0.62921E+03_JPRB /)  
KB(:,15, 7) = (/ &
 & 0.62589E+03_JPRB,0.62634E+03_JPRB,0.62708E+03_JPRB,0.62809E+03_JPRB,0.62935E+03_JPRB /)  
KB(:,16, 7) = (/ &
 & 0.62593E+03_JPRB,0.62640E+03_JPRB,0.62717E+03_JPRB,0.62821E+03_JPRB,0.62950E+03_JPRB /)  
KB(:,17, 7) = (/ &
 & 0.62597E+03_JPRB,0.62647E+03_JPRB,0.62727E+03_JPRB,0.62833E+03_JPRB,0.62965E+03_JPRB /)  
KB(:,18, 7) = (/ &
 & 0.62601E+03_JPRB,0.62654E+03_JPRB,0.62737E+03_JPRB,0.62846E+03_JPRB,0.62980E+03_JPRB /)  
KB(:,19, 7) = (/ &
 & 0.62605E+03_JPRB,0.62661E+03_JPRB,0.62746E+03_JPRB,0.62858E+03_JPRB,0.62995E+03_JPRB /)  
KB(:,20, 7) = (/ &
 & 0.62610E+03_JPRB,0.62670E+03_JPRB,0.62758E+03_JPRB,0.62873E+03_JPRB,0.63012E+03_JPRB /)  
KB(:,21, 7) = (/ &
 & 0.62615E+03_JPRB,0.62679E+03_JPRB,0.62770E+03_JPRB,0.62888E+03_JPRB,0.63031E+03_JPRB /)  
KB(:,22, 7) = (/ &
 & 0.62625E+03_JPRB,0.62694E+03_JPRB,0.62790E+03_JPRB,0.62913E+03_JPRB,0.63060E+03_JPRB /)  
KB(:,23, 7) = (/ &
 & 0.62636E+03_JPRB,0.62710E+03_JPRB,0.62812E+03_JPRB,0.62939E+03_JPRB,0.63091E+03_JPRB /)  
KB(:,24, 7) = (/ &
 & 0.62648E+03_JPRB,0.62729E+03_JPRB,0.62835E+03_JPRB,0.62968E+03_JPRB,0.63125E+03_JPRB /)  
KB(:,25, 7) = (/ &
 & 0.62663E+03_JPRB,0.62749E+03_JPRB,0.62861E+03_JPRB,0.62999E+03_JPRB,0.63162E+03_JPRB /)  
KB(:,26, 7) = (/ &
 & 0.62681E+03_JPRB,0.62773E+03_JPRB,0.62891E+03_JPRB,0.63035E+03_JPRB,0.63203E+03_JPRB /)  
KB(:,27, 7) = (/ &
 & 0.62700E+03_JPRB,0.62799E+03_JPRB,0.62923E+03_JPRB,0.63072E+03_JPRB,0.63247E+03_JPRB /)  
KB(:,28, 7) = (/ &
 & 0.62721E+03_JPRB,0.62826E+03_JPRB,0.62956E+03_JPRB,0.63112E+03_JPRB,0.63292E+03_JPRB /)  
KB(:,29, 7) = (/ &
 & 0.62745E+03_JPRB,0.62856E+03_JPRB,0.62993E+03_JPRB,0.63154E+03_JPRB,0.63341E+03_JPRB /)  
KB(:,30, 7) = (/ &
 & 0.62770E+03_JPRB,0.62888E+03_JPRB,0.63031E+03_JPRB,0.63198E+03_JPRB,0.63392E+03_JPRB /)  
KB(:,31, 7) = (/ &
 & 0.62798E+03_JPRB,0.62922E+03_JPRB,0.63071E+03_JPRB,0.63245E+03_JPRB,0.63446E+03_JPRB /)  
KB(:,32, 7) = (/ &
 & 0.62828E+03_JPRB,0.62958E+03_JPRB,0.63114E+03_JPRB,0.63295E+03_JPRB,0.63503E+03_JPRB /)  
KB(:,33, 7) = (/ &
 & 0.62860E+03_JPRB,0.62997E+03_JPRB,0.63159E+03_JPRB,0.63347E+03_JPRB,0.63562E+03_JPRB /)  
KB(:,34, 7) = (/ &
 & 0.62889E+03_JPRB,0.63031E+03_JPRB,0.63199E+03_JPRB,0.63393E+03_JPRB,0.63614E+03_JPRB /)  
KB(:,35, 7) = (/ &
 & 0.62906E+03_JPRB,0.63052E+03_JPRB,0.63223E+03_JPRB,0.63421E+03_JPRB,0.63644E+03_JPRB /)  
KB(:,36, 7) = (/ &
 & 0.62909E+03_JPRB,0.63055E+03_JPRB,0.63227E+03_JPRB,0.63425E+03_JPRB,0.63649E+03_JPRB /)  
KB(:,37, 7) = (/ &
 & 0.62891E+03_JPRB,0.63035E+03_JPRB,0.63203E+03_JPRB,0.63397E+03_JPRB,0.63619E+03_JPRB /)  
KB(:,38, 7) = (/ &
 & 0.62873E+03_JPRB,0.63013E+03_JPRB,0.63178E+03_JPRB,0.63369E+03_JPRB,0.63586E+03_JPRB /)  
KB(:,39, 7) = (/ &
 & 0.62856E+03_JPRB,0.62992E+03_JPRB,0.63154E+03_JPRB,0.63341E+03_JPRB,0.63555E+03_JPRB /)  
KB(:,40, 7) = (/ &
 & 0.62827E+03_JPRB,0.62957E+03_JPRB,0.63113E+03_JPRB,0.63293E+03_JPRB,0.63501E+03_JPRB /)  
KB(:,41, 7) = (/ &
 & 0.62798E+03_JPRB,0.62922E+03_JPRB,0.63071E+03_JPRB,0.63245E+03_JPRB,0.63445E+03_JPRB /)  
KB(:,42, 7) = (/ &
 & 0.62770E+03_JPRB,0.62887E+03_JPRB,0.63030E+03_JPRB,0.63198E+03_JPRB,0.63391E+03_JPRB /)  
KB(:,43, 7) = (/ &
 & 0.62739E+03_JPRB,0.62848E+03_JPRB,0.62983E+03_JPRB,0.63143E+03_JPRB,0.63328E+03_JPRB /)  
KB(:,44, 7) = (/ &
 & 0.62708E+03_JPRB,0.62808E+03_JPRB,0.62935E+03_JPRB,0.63086E+03_JPRB,0.63263E+03_JPRB /)  
KB(:,45, 7) = (/ &
 & 0.62679E+03_JPRB,0.62771E+03_JPRB,0.62889E+03_JPRB,0.63032E+03_JPRB,0.63200E+03_JPRB /)  
KB(:,46, 7) = (/ &
 & 0.62653E+03_JPRB,0.62735E+03_JPRB,0.62844E+03_JPRB,0.62978E+03_JPRB,0.63137E+03_JPRB /)  
KB(:,47, 7) = (/ &
 & 0.62629E+03_JPRB,0.62699E+03_JPRB,0.62797E+03_JPRB,0.62921E+03_JPRB,0.63070E+03_JPRB /)  
KB(:,48, 7) = (/ &
 & 0.62608E+03_JPRB,0.62667E+03_JPRB,0.62755E+03_JPRB,0.62868E+03_JPRB,0.63007E+03_JPRB /)  
KB(:,49, 7) = (/ &
 & 0.62592E+03_JPRB,0.62640E+03_JPRB,0.62716E+03_JPRB,0.62820E+03_JPRB,0.62948E+03_JPRB /)  
KB(:,50, 7) = (/ &
 & 0.62580E+03_JPRB,0.62619E+03_JPRB,0.62684E+03_JPRB,0.62778E+03_JPRB,0.62897E+03_JPRB /)  
KB(:,51, 7) = (/ &
 & 0.62580E+03_JPRB,0.62602E+03_JPRB,0.62657E+03_JPRB,0.62741E+03_JPRB,0.62850E+03_JPRB /)  
KB(:,52, 7) = (/ &
 & 0.62578E+03_JPRB,0.62589E+03_JPRB,0.62633E+03_JPRB,0.62707E+03_JPRB,0.62807E+03_JPRB /)  
KB(:,53, 7) = (/ &
 & 0.62574E+03_JPRB,0.62578E+03_JPRB,0.62614E+03_JPRB,0.62677E+03_JPRB,0.62768E+03_JPRB /)  
KB(:,54, 7) = (/ &
 & 0.62576E+03_JPRB,0.62580E+03_JPRB,0.62600E+03_JPRB,0.62652E+03_JPRB,0.62734E+03_JPRB /)  
KB(:,55, 7) = (/ &
 & 0.62585E+03_JPRB,0.62578E+03_JPRB,0.62588E+03_JPRB,0.62632E+03_JPRB,0.62705E+03_JPRB /)  
KB(:,56, 7) = (/ &
 & 0.62587E+03_JPRB,0.62576E+03_JPRB,0.62579E+03_JPRB,0.62615E+03_JPRB,0.62678E+03_JPRB /)  
KB(:,57, 7) = (/ &
 & 0.62591E+03_JPRB,0.62574E+03_JPRB,0.62580E+03_JPRB,0.62601E+03_JPRB,0.62655E+03_JPRB /)  
KB(:,58, 7) = (/ &
 & 0.62591E+03_JPRB,0.62583E+03_JPRB,0.62578E+03_JPRB,0.62590E+03_JPRB,0.62636E+03_JPRB /)  
KB(:,59, 7) = (/ &
 & 0.62590E+03_JPRB,0.62586E+03_JPRB,0.62578E+03_JPRB,0.62586E+03_JPRB,0.62628E+03_JPRB /)  
KB(:,13, 8) = (/ &
 & 0.81821E+03_JPRB,0.81877E+03_JPRB,0.81935E+03_JPRB,0.81999E+03_JPRB,0.82074E+03_JPRB /)  
KB(:,14, 8) = (/ &
 & 0.81826E+03_JPRB,0.81882E+03_JPRB,0.81939E+03_JPRB,0.82006E+03_JPRB,0.82081E+03_JPRB /)  
KB(:,15, 8) = (/ &
 & 0.81831E+03_JPRB,0.81888E+03_JPRB,0.81946E+03_JPRB,0.82012E+03_JPRB,0.82089E+03_JPRB /)  
KB(:,16, 8) = (/ &
 & 0.81836E+03_JPRB,0.81895E+03_JPRB,0.81952E+03_JPRB,0.82021E+03_JPRB,0.82098E+03_JPRB /)  
KB(:,17, 8) = (/ &
 & 0.81842E+03_JPRB,0.81901E+03_JPRB,0.81959E+03_JPRB,0.82028E+03_JPRB,0.82106E+03_JPRB /)  
KB(:,18, 8) = (/ &
 & 0.81847E+03_JPRB,0.81907E+03_JPRB,0.81965E+03_JPRB,0.82036E+03_JPRB,0.82116E+03_JPRB /)  
KB(:,19, 8) = (/ &
 & 0.81853E+03_JPRB,0.81913E+03_JPRB,0.81972E+03_JPRB,0.82043E+03_JPRB,0.82123E+03_JPRB /)  
KB(:,20, 8) = (/ &
 & 0.81860E+03_JPRB,0.81919E+03_JPRB,0.81980E+03_JPRB,0.82052E+03_JPRB,0.82133E+03_JPRB /)  
KB(:,21, 8) = (/ &
 & 0.81868E+03_JPRB,0.81925E+03_JPRB,0.81988E+03_JPRB,0.82061E+03_JPRB,0.82143E+03_JPRB /)  
KB(:,22, 8) = (/ &
 & 0.81879E+03_JPRB,0.81936E+03_JPRB,0.82001E+03_JPRB,0.82076E+03_JPRB,0.82160E+03_JPRB /)  
KB(:,23, 8) = (/ &
 & 0.81889E+03_JPRB,0.81947E+03_JPRB,0.82015E+03_JPRB,0.82091E+03_JPRB,0.82177E+03_JPRB /)  
KB(:,24, 8) = (/ &
 & 0.81902E+03_JPRB,0.81960E+03_JPRB,0.82030E+03_JPRB,0.82108E+03_JPRB,0.82195E+03_JPRB /)  
KB(:,25, 8) = (/ &
 & 0.81914E+03_JPRB,0.81974E+03_JPRB,0.82046E+03_JPRB,0.82126E+03_JPRB,0.82214E+03_JPRB /)  
KB(:,26, 8) = (/ &
 & 0.81927E+03_JPRB,0.81990E+03_JPRB,0.82063E+03_JPRB,0.82145E+03_JPRB,0.82236E+03_JPRB /)  
KB(:,27, 8) = (/ &
 & 0.81941E+03_JPRB,0.82006E+03_JPRB,0.82082E+03_JPRB,0.82166E+03_JPRB,0.82258E+03_JPRB /)  
KB(:,28, 8) = (/ &
 & 0.81957E+03_JPRB,0.82024E+03_JPRB,0.82101E+03_JPRB,0.82188E+03_JPRB,0.82281E+03_JPRB /)  
KB(:,29, 8) = (/ &
 & 0.81971E+03_JPRB,0.82042E+03_JPRB,0.82122E+03_JPRB,0.82210E+03_JPRB,0.82305E+03_JPRB /)  
KB(:,30, 8) = (/ &
 & 0.81988E+03_JPRB,0.82061E+03_JPRB,0.82143E+03_JPRB,0.82233E+03_JPRB,0.82330E+03_JPRB /)  
KB(:,31, 8) = (/ &
 & 0.82006E+03_JPRB,0.82081E+03_JPRB,0.82166E+03_JPRB,0.82258E+03_JPRB,0.82355E+03_JPRB /)  
KB(:,32, 8) = (/ &
 & 0.82025E+03_JPRB,0.82103E+03_JPRB,0.82189E+03_JPRB,0.82283E+03_JPRB,0.82380E+03_JPRB /)  
KB(:,33, 8) = (/ &
 & 0.82044E+03_JPRB,0.82124E+03_JPRB,0.82213E+03_JPRB,0.82308E+03_JPRB,0.82408E+03_JPRB /)  
KB(:,34, 8) = (/ &
 & 0.82062E+03_JPRB,0.82144E+03_JPRB,0.82234E+03_JPRB,0.82330E+03_JPRB,0.82432E+03_JPRB /)  
KB(:,35, 8) = (/ &
 & 0.82072E+03_JPRB,0.82155E+03_JPRB,0.82246E+03_JPRB,0.82342E+03_JPRB,0.82446E+03_JPRB /)  
KB(:,36, 8) = (/ &
 & 0.82074E+03_JPRB,0.82157E+03_JPRB,0.82248E+03_JPRB,0.82345E+03_JPRB,0.82448E+03_JPRB /)  
KB(:,37, 8) = (/ &
 & 0.82063E+03_JPRB,0.82146E+03_JPRB,0.82236E+03_JPRB,0.82332E+03_JPRB,0.82434E+03_JPRB /)  
KB(:,38, 8) = (/ &
 & 0.82053E+03_JPRB,0.82134E+03_JPRB,0.82223E+03_JPRB,0.82319E+03_JPRB,0.82419E+03_JPRB /)  
KB(:,39, 8) = (/ &
 & 0.82042E+03_JPRB,0.82122E+03_JPRB,0.82210E+03_JPRB,0.82305E+03_JPRB,0.82405E+03_JPRB /)  
KB(:,40, 8) = (/ &
 & 0.82024E+03_JPRB,0.82102E+03_JPRB,0.82188E+03_JPRB,0.82282E+03_JPRB,0.82380E+03_JPRB /)  
KB(:,41, 8) = (/ &
 & 0.82006E+03_JPRB,0.82081E+03_JPRB,0.82165E+03_JPRB,0.82257E+03_JPRB,0.82354E+03_JPRB /)  
KB(:,42, 8) = (/ &
 & 0.81988E+03_JPRB,0.82061E+03_JPRB,0.82143E+03_JPRB,0.82233E+03_JPRB,0.82329E+03_JPRB /)  
KB(:,43, 8) = (/ &
 & 0.81967E+03_JPRB,0.82037E+03_JPRB,0.82117E+03_JPRB,0.82204E+03_JPRB,0.82299E+03_JPRB /)  
KB(:,44, 8) = (/ &
 & 0.81946E+03_JPRB,0.82013E+03_JPRB,0.82089E+03_JPRB,0.82174E+03_JPRB,0.82267E+03_JPRB /)  
KB(:,45, 8) = (/ &
 & 0.81926E+03_JPRB,0.81989E+03_JPRB,0.82062E+03_JPRB,0.82144E+03_JPRB,0.82234E+03_JPRB /)  
KB(:,46, 8) = (/ &
 & 0.81907E+03_JPRB,0.81965E+03_JPRB,0.82034E+03_JPRB,0.82114E+03_JPRB,0.82201E+03_JPRB /)  
KB(:,47, 8) = (/ &
 & 0.81882E+03_JPRB,0.81939E+03_JPRB,0.82006E+03_JPRB,0.82081E+03_JPRB,0.82165E+03_JPRB /)  
KB(:,48, 8) = (/ &
 & 0.81858E+03_JPRB,0.81917E+03_JPRB,0.81978E+03_JPRB,0.82050E+03_JPRB,0.82130E+03_JPRB /)  
KB(:,49, 8) = (/ &
 & 0.81836E+03_JPRB,0.81894E+03_JPRB,0.81953E+03_JPRB,0.82019E+03_JPRB,0.82097E+03_JPRB /)  
KB(:,50, 8) = (/ &
 & 0.81817E+03_JPRB,0.81871E+03_JPRB,0.81929E+03_JPRB,0.81993E+03_JPRB,0.82067E+03_JPRB /)  
KB(:,51, 8) = (/ &
 & 0.81790E+03_JPRB,0.81850E+03_JPRB,0.81910E+03_JPRB,0.81967E+03_JPRB,0.82039E+03_JPRB /)  
KB(:,52, 8) = (/ &
 & 0.81779E+03_JPRB,0.81830E+03_JPRB,0.81888E+03_JPRB,0.81945E+03_JPRB,0.82012E+03_JPRB /)  
KB(:,53, 8) = (/ &
 & 0.81766E+03_JPRB,0.81812E+03_JPRB,0.81866E+03_JPRB,0.81924E+03_JPRB,0.81986E+03_JPRB /)  
KB(:,54, 8) = (/ &
 & 0.81744E+03_JPRB,0.81785E+03_JPRB,0.81846E+03_JPRB,0.81906E+03_JPRB,0.81964E+03_JPRB /)  
KB(:,55, 8) = (/ &
 & 0.81733E+03_JPRB,0.81777E+03_JPRB,0.81829E+03_JPRB,0.81886E+03_JPRB,0.81944E+03_JPRB /)  
KB(:,56, 8) = (/ &
 & 0.81741E+03_JPRB,0.81767E+03_JPRB,0.81813E+03_JPRB,0.81867E+03_JPRB,0.81925E+03_JPRB /)  
KB(:,57, 8) = (/ &
 & 0.81785E+03_JPRB,0.81749E+03_JPRB,0.81788E+03_JPRB,0.81848E+03_JPRB,0.81908E+03_JPRB /)  
KB(:,58, 8) = (/ &
 & 0.81817E+03_JPRB,0.81731E+03_JPRB,0.81779E+03_JPRB,0.81832E+03_JPRB,0.81889E+03_JPRB /)  
KB(:,59, 8) = (/ &
 & 0.81824E+03_JPRB,0.81736E+03_JPRB,0.81776E+03_JPRB,0.81826E+03_JPRB,0.81883E+03_JPRB /)  
KB(:,13, 9) = (/ &
 & 0.94133E+03_JPRB,0.94438E+03_JPRB,0.94687E+03_JPRB,0.94883E+03_JPRB,0.95021E+03_JPRB /)  
KB(:,14, 9) = (/ &
 & 0.94163E+03_JPRB,0.94463E+03_JPRB,0.94708E+03_JPRB,0.94898E+03_JPRB,0.95031E+03_JPRB /)  
KB(:,15, 9) = (/ &
 & 0.94195E+03_JPRB,0.94490E+03_JPRB,0.94731E+03_JPRB,0.94914E+03_JPRB,0.95042E+03_JPRB /)  
KB(:,16, 9) = (/ &
 & 0.94229E+03_JPRB,0.94518E+03_JPRB,0.94753E+03_JPRB,0.94930E+03_JPRB,0.95052E+03_JPRB /)  
KB(:,17, 9) = (/ &
 & 0.94262E+03_JPRB,0.94544E+03_JPRB,0.94774E+03_JPRB,0.94946E+03_JPRB,0.95061E+03_JPRB /)  
KB(:,18, 9) = (/ &
 & 0.94293E+03_JPRB,0.94570E+03_JPRB,0.94795E+03_JPRB,0.94960E+03_JPRB,0.95069E+03_JPRB /)  
KB(:,19, 9) = (/ &
 & 0.94323E+03_JPRB,0.94595E+03_JPRB,0.94814E+03_JPRB,0.94974E+03_JPRB,0.95078E+03_JPRB /)  
KB(:,20, 9) = (/ &
 & 0.94357E+03_JPRB,0.94624E+03_JPRB,0.94835E+03_JPRB,0.94989E+03_JPRB,0.95087E+03_JPRB /)  
KB(:,21, 9) = (/ &
 & 0.94393E+03_JPRB,0.94654E+03_JPRB,0.94857E+03_JPRB,0.95003E+03_JPRB,0.95096E+03_JPRB /)  
KB(:,22, 9) = (/ &
 & 0.94445E+03_JPRB,0.94695E+03_JPRB,0.94888E+03_JPRB,0.95025E+03_JPRB,0.95105E+03_JPRB /)  
KB(:,23, 9) = (/ &
 & 0.94499E+03_JPRB,0.94737E+03_JPRB,0.94919E+03_JPRB,0.95045E+03_JPRB,0.95113E+03_JPRB /)  
KB(:,24, 9) = (/ &
 & 0.94549E+03_JPRB,0.94778E+03_JPRB,0.94948E+03_JPRB,0.95063E+03_JPRB,0.95120E+03_JPRB /)  
KB(:,25, 9) = (/ &
 & 0.94602E+03_JPRB,0.94819E+03_JPRB,0.94978E+03_JPRB,0.95082E+03_JPRB,0.95125E+03_JPRB /)  
KB(:,26, 9) = (/ &
 & 0.94658E+03_JPRB,0.94861E+03_JPRB,0.95006E+03_JPRB,0.95096E+03_JPRB,0.95127E+03_JPRB /)  
KB(:,27, 9) = (/ &
 & 0.94710E+03_JPRB,0.94900E+03_JPRB,0.95033E+03_JPRB,0.95109E+03_JPRB,0.95126E+03_JPRB /)  
KB(:,28, 9) = (/ &
 & 0.94759E+03_JPRB,0.94937E+03_JPRB,0.95056E+03_JPRB,0.95118E+03_JPRB,0.95123E+03_JPRB /)  
KB(:,29, 9) = (/ &
 & 0.94811E+03_JPRB,0.94973E+03_JPRB,0.95077E+03_JPRB,0.95124E+03_JPRB,0.95116E+03_JPRB /)  
KB(:,30, 9) = (/ &
 & 0.94856E+03_JPRB,0.95003E+03_JPRB,0.95095E+03_JPRB,0.95127E+03_JPRB,0.95105E+03_JPRB /)  
KB(:,31, 9) = (/ &
 & 0.94901E+03_JPRB,0.95032E+03_JPRB,0.95108E+03_JPRB,0.95127E+03_JPRB,0.95090E+03_JPRB /)  
KB(:,32, 9) = (/ &
 & 0.94939E+03_JPRB,0.95057E+03_JPRB,0.95118E+03_JPRB,0.95121E+03_JPRB,0.95071E+03_JPRB /)  
KB(:,33, 9) = (/ &
 & 0.94975E+03_JPRB,0.95079E+03_JPRB,0.95125E+03_JPRB,0.95115E+03_JPRB,0.95050E+03_JPRB /)  
KB(:,34, 9) = (/ &
 & 0.95004E+03_JPRB,0.95095E+03_JPRB,0.95128E+03_JPRB,0.95105E+03_JPRB,0.95030E+03_JPRB /)  
KB(:,35, 9) = (/ &
 & 0.95020E+03_JPRB,0.95102E+03_JPRB,0.95127E+03_JPRB,0.95098E+03_JPRB,0.95016E+03_JPRB /)  
KB(:,36, 9) = (/ &
 & 0.95021E+03_JPRB,0.95103E+03_JPRB,0.95127E+03_JPRB,0.95096E+03_JPRB,0.95023E+03_JPRB /)  
KB(:,37, 9) = (/ &
 & 0.95006E+03_JPRB,0.95096E+03_JPRB,0.95127E+03_JPRB,0.95104E+03_JPRB,0.95027E+03_JPRB /)  
KB(:,38, 9) = (/ &
 & 0.94990E+03_JPRB,0.95087E+03_JPRB,0.95126E+03_JPRB,0.95110E+03_JPRB,0.95040E+03_JPRB /)  
KB(:,39, 9) = (/ &
 & 0.94972E+03_JPRB,0.95077E+03_JPRB,0.95124E+03_JPRB,0.95117E+03_JPRB,0.95053E+03_JPRB /)  
KB(:,40, 9) = (/ &
 & 0.94939E+03_JPRB,0.95057E+03_JPRB,0.95118E+03_JPRB,0.95123E+03_JPRB,0.95072E+03_JPRB /)  
KB(:,41, 9) = (/ &
 & 0.94899E+03_JPRB,0.95032E+03_JPRB,0.95108E+03_JPRB,0.95127E+03_JPRB,0.95090E+03_JPRB /)  
KB(:,42, 9) = (/ &
 & 0.94856E+03_JPRB,0.95004E+03_JPRB,0.95094E+03_JPRB,0.95127E+03_JPRB,0.95105E+03_JPRB /)  
KB(:,43, 9) = (/ &
 & 0.94799E+03_JPRB,0.94963E+03_JPRB,0.95073E+03_JPRB,0.95123E+03_JPRB,0.95118E+03_JPRB /)  
KB(:,44, 9) = (/ &
 & 0.94729E+03_JPRB,0.94914E+03_JPRB,0.95041E+03_JPRB,0.95112E+03_JPRB,0.95126E+03_JPRB /)  
KB(:,45, 9) = (/ &
 & 0.94655E+03_JPRB,0.94858E+03_JPRB,0.95004E+03_JPRB,0.95095E+03_JPRB,0.95127E+03_JPRB /)  
KB(:,46, 9) = (/ &
 & 0.94568E+03_JPRB,0.94792E+03_JPRB,0.94958E+03_JPRB,0.95070E+03_JPRB,0.95122E+03_JPRB /)  
KB(:,47, 9) = (/ &
 & 0.94463E+03_JPRB,0.94708E+03_JPRB,0.94898E+03_JPRB,0.95031E+03_JPRB,0.95108E+03_JPRB /)  
KB(:,48, 9) = (/ &
 & 0.94348E+03_JPRB,0.94616E+03_JPRB,0.94829E+03_JPRB,0.94984E+03_JPRB,0.95084E+03_JPRB /)  
KB(:,49, 9) = (/ &
 & 0.94226E+03_JPRB,0.94515E+03_JPRB,0.94748E+03_JPRB,0.94928E+03_JPRB,0.95051E+03_JPRB /)  
KB(:,50, 9) = (/ &
 & 0.94103E+03_JPRB,0.94413E+03_JPRB,0.94669E+03_JPRB,0.94868E+03_JPRB,0.95011E+03_JPRB /)  
KB(:,51, 9) = (/ &
 & 0.93978E+03_JPRB,0.94307E+03_JPRB,0.94580E+03_JPRB,0.94802E+03_JPRB,0.94965E+03_JPRB /)  
KB(:,52, 9) = (/ &
 & 0.93828E+03_JPRB,0.94192E+03_JPRB,0.94488E+03_JPRB,0.94728E+03_JPRB,0.94912E+03_JPRB /)  
KB(:,53, 9) = (/ &
 & 0.93678E+03_JPRB,0.94072E+03_JPRB,0.94388E+03_JPRB,0.94646E+03_JPRB,0.94851E+03_JPRB /)  
KB(:,54, 9) = (/ &
 & 0.93537E+03_JPRB,0.93955E+03_JPRB,0.94287E+03_JPRB,0.94565E+03_JPRB,0.94789E+03_JPRB /)  
KB(:,55, 9) = (/ &
 & 0.93380E+03_JPRB,0.93820E+03_JPRB,0.94186E+03_JPRB,0.94483E+03_JPRB,0.94722E+03_JPRB /)  
KB(:,56, 9) = (/ &
 & 0.93205E+03_JPRB,0.93688E+03_JPRB,0.94080E+03_JPRB,0.94394E+03_JPRB,0.94652E+03_JPRB /)  
KB(:,57, 9) = (/ &
 & 0.92997E+03_JPRB,0.93554E+03_JPRB,0.93969E+03_JPRB,0.94299E+03_JPRB,0.94574E+03_JPRB /)  
KB(:,58, 9) = (/ &
 & 0.92808E+03_JPRB,0.93414E+03_JPRB,0.93844E+03_JPRB,0.94204E+03_JPRB,0.94498E+03_JPRB /)  
KB(:,59, 9) = (/ &
 & 0.92793E+03_JPRB,0.93341E+03_JPRB,0.93792E+03_JPRB,0.94165E+03_JPRB,0.94465E+03_JPRB /)  
KB(:,13,10) = (/ &
 & 0.98036E+03_JPRB,0.98526E+03_JPRB,0.98973E+03_JPRB,0.99279E+03_JPRB,0.99468E+03_JPRB /)  
KB(:,14,10) = (/ &
 & 0.98067E+03_JPRB,0.98568E+03_JPRB,0.99005E+03_JPRB,0.99301E+03_JPRB,0.99477E+03_JPRB /)  
KB(:,15,10) = (/ &
 & 0.98125E+03_JPRB,0.98614E+03_JPRB,0.99040E+03_JPRB,0.99324E+03_JPRB,0.99485E+03_JPRB /)  
KB(:,16,10) = (/ &
 & 0.98185E+03_JPRB,0.98662E+03_JPRB,0.99076E+03_JPRB,0.99348E+03_JPRB,0.99493E+03_JPRB /)  
KB(:,17,10) = (/ &
 & 0.98242E+03_JPRB,0.98721E+03_JPRB,0.99109E+03_JPRB,0.99369E+03_JPRB,0.99498E+03_JPRB /)  
KB(:,18,10) = (/ &
 & 0.98296E+03_JPRB,0.98755E+03_JPRB,0.99141E+03_JPRB,0.99390E+03_JPRB,0.99502E+03_JPRB /)  
KB(:,19,10) = (/ &
 & 0.98350E+03_JPRB,0.98800E+03_JPRB,0.99172E+03_JPRB,0.99408E+03_JPRB,0.99505E+03_JPRB /)  
KB(:,20,10) = (/ &
 & 0.98411E+03_JPRB,0.98852E+03_JPRB,0.99205E+03_JPRB,0.99428E+03_JPRB,0.99507E+03_JPRB /)  
KB(:,21,10) = (/ &
 & 0.98464E+03_JPRB,0.98894E+03_JPRB,0.99238E+03_JPRB,0.99447E+03_JPRB,0.99496E+03_JPRB /)  
KB(:,22,10) = (/ &
 & 0.98547E+03_JPRB,0.98983E+03_JPRB,0.99286E+03_JPRB,0.99470E+03_JPRB,0.99509E+03_JPRB /)  
KB(:,23,10) = (/ &
 & 0.98617E+03_JPRB,0.99062E+03_JPRB,0.99331E+03_JPRB,0.99487E+03_JPRB,0.99508E+03_JPRB /)  
KB(:,24,10) = (/ &
 & 0.98718E+03_JPRB,0.99115E+03_JPRB,0.99373E+03_JPRB,0.99499E+03_JPRB,0.99503E+03_JPRB /)  
KB(:,25,10) = (/ &
 & 0.98813E+03_JPRB,0.99180E+03_JPRB,0.99413E+03_JPRB,0.99494E+03_JPRB,0.99492E+03_JPRB /)  
KB(:,26,10) = (/ &
 & 0.98918E+03_JPRB,0.99244E+03_JPRB,0.99450E+03_JPRB,0.99508E+03_JPRB,0.99475E+03_JPRB /)  
KB(:,27,10) = (/ &
 & 0.99010E+03_JPRB,0.99304E+03_JPRB,0.99478E+03_JPRB,0.99509E+03_JPRB,0.99499E+03_JPRB /)  
KB(:,28,10) = (/ &
 & 0.99090E+03_JPRB,0.99357E+03_JPRB,0.99495E+03_JPRB,0.99505E+03_JPRB,0.99433E+03_JPRB /)  
KB(:,29,10) = (/ &
 & 0.99167E+03_JPRB,0.99393E+03_JPRB,0.99505E+03_JPRB,0.99495E+03_JPRB,0.99385E+03_JPRB /)  
KB(:,30,10) = (/ &
 & 0.99249E+03_JPRB,0.99447E+03_JPRB,0.99508E+03_JPRB,0.99477E+03_JPRB,0.99348E+03_JPRB /)  
KB(:,31,10) = (/ &
 & 0.99290E+03_JPRB,0.99477E+03_JPRB,0.99509E+03_JPRB,0.99452E+03_JPRB,0.99326E+03_JPRB /)  
KB(:,32,10) = (/ &
 & 0.99360E+03_JPRB,0.99496E+03_JPRB,0.99505E+03_JPRB,0.99419E+03_JPRB,0.99287E+03_JPRB /)  
KB(:,33,10) = (/ &
 & 0.99410E+03_JPRB,0.99506E+03_JPRB,0.99493E+03_JPRB,0.99381E+03_JPRB,0.99210E+03_JPRB /)  
KB(:,34,10) = (/ &
 & 0.99447E+03_JPRB,0.99508E+03_JPRB,0.99465E+03_JPRB,0.99347E+03_JPRB,0.99121E+03_JPRB /)  
KB(:,35,10) = (/ &
 & 0.99453E+03_JPRB,0.99509E+03_JPRB,0.99465E+03_JPRB,0.99330E+03_JPRB,0.99083E+03_JPRB /)  
KB(:,36,10) = (/ &
 & 0.99467E+03_JPRB,0.99509E+03_JPRB,0.99463E+03_JPRB,0.99327E+03_JPRB,0.98992E+03_JPRB /)  
KB(:,37,10) = (/ &
 & 0.99451E+03_JPRB,0.99508E+03_JPRB,0.99475E+03_JPRB,0.99344E+03_JPRB,0.99124E+03_JPRB /)  
KB(:,38,10) = (/ &
 & 0.99429E+03_JPRB,0.99507E+03_JPRB,0.99486E+03_JPRB,0.99365E+03_JPRB,0.99174E+03_JPRB /)  
KB(:,39,10) = (/ &
 & 0.99405E+03_JPRB,0.99505E+03_JPRB,0.99495E+03_JPRB,0.99373E+03_JPRB,0.99219E+03_JPRB /)  
KB(:,40,10) = (/ &
 & 0.99347E+03_JPRB,0.99496E+03_JPRB,0.99505E+03_JPRB,0.99420E+03_JPRB,0.99289E+03_JPRB /)  
KB(:,41,10) = (/ &
 & 0.99302E+03_JPRB,0.99477E+03_JPRB,0.99509E+03_JPRB,0.99452E+03_JPRB,0.99315E+03_JPRB /)  
KB(:,42,10) = (/ &
 & 0.99237E+03_JPRB,0.99435E+03_JPRB,0.99508E+03_JPRB,0.99477E+03_JPRB,0.99348E+03_JPRB /)  
KB(:,43,10) = (/ &
 & 0.99148E+03_JPRB,0.99394E+03_JPRB,0.99491E+03_JPRB,0.99498E+03_JPRB,0.99395E+03_JPRB /)  
KB(:,44,10) = (/ &
 & 0.99040E+03_JPRB,0.99324E+03_JPRB,0.99485E+03_JPRB,0.99508E+03_JPRB,0.99453E+03_JPRB /)  
KB(:,45,10) = (/ &
 & 0.98910E+03_JPRB,0.99241E+03_JPRB,0.99449E+03_JPRB,0.99508E+03_JPRB,0.99476E+03_JPRB /)  
KB(:,46,10) = (/ &
 & 0.98735E+03_JPRB,0.99138E+03_JPRB,0.99388E+03_JPRB,0.99490E+03_JPRB,0.99500E+03_JPRB /)  
KB(:,47,10) = (/ &
 & 0.98565E+03_JPRB,0.99006E+03_JPRB,0.99301E+03_JPRB,0.99477E+03_JPRB,0.99509E+03_JPRB /)  
KB(:,48,10) = (/ &
 & 0.98383E+03_JPRB,0.98834E+03_JPRB,0.99196E+03_JPRB,0.99423E+03_JPRB,0.99507E+03_JPRB /)  
KB(:,49,10) = (/ &
 & 0.98174E+03_JPRB,0.98651E+03_JPRB,0.99073E+03_JPRB,0.99346E+03_JPRB,0.99492E+03_JPRB /)  
KB(:,50,10) = (/ &
 & 0.97955E+03_JPRB,0.98480E+03_JPRB,0.98924E+03_JPRB,0.99257E+03_JPRB,0.99470E+03_JPRB /)  
KB(:,51,10) = (/ &
 & 0.97755E+03_JPRB,0.98298E+03_JPRB,0.98767E+03_JPRB,0.99154E+03_JPRB,0.99399E+03_JPRB /)  
KB(:,52,10) = (/ &
 & 0.97554E+03_JPRB,0.98111E+03_JPRB,0.98597E+03_JPRB,0.99036E+03_JPRB,0.99323E+03_JPRB /)  
KB(:,53,10) = (/ &
 & 0.97320E+03_JPRB,0.97892E+03_JPRB,0.98413E+03_JPRB,0.98888E+03_JPRB,0.99232E+03_JPRB /)  
KB(:,54,10) = (/ &
 & 0.97086E+03_JPRB,0.97720E+03_JPRB,0.98263E+03_JPRB,0.98733E+03_JPRB,0.99135E+03_JPRB /)  
KB(:,55,10) = (/ &
 & 0.96881E+03_JPRB,0.97539E+03_JPRB,0.98096E+03_JPRB,0.98583E+03_JPRB,0.99029E+03_JPRB /)  
KB(:,56,10) = (/ &
 & 0.96735E+03_JPRB,0.97336E+03_JPRB,0.97906E+03_JPRB,0.98435E+03_JPRB,0.98900E+03_JPRB /)  
KB(:,57,10) = (/ &
 & 0.96407E+03_JPRB,0.97115E+03_JPRB,0.97740E+03_JPRB,0.98282E+03_JPRB,0.98752E+03_JPRB /)  
KB(:,58,10) = (/ &
 & 0.96154E+03_JPRB,0.96893E+03_JPRB,0.97574E+03_JPRB,0.98129E+03_JPRB,0.98611E+03_JPRB /)  
KB(:,59,10) = (/ &
 & 0.95571E+03_JPRB,0.96861E+03_JPRB,0.97503E+03_JPRB,0.98063E+03_JPRB,0.98557E+03_JPRB /)  
KB(:,13,11) = (/ &
 & 0.98771E+03_JPRB,0.99296E+03_JPRB,0.99655E+03_JPRB,0.99859E+03_JPRB,0.99936E+03_JPRB /)  
KB(:,14,11) = (/ &
 & 0.98850E+03_JPRB,0.99335E+03_JPRB,0.99679E+03_JPRB,0.99871E+03_JPRB,0.99939E+03_JPRB /)  
KB(:,15,11) = (/ &
 & 0.98905E+03_JPRB,0.99377E+03_JPRB,0.99705E+03_JPRB,0.99882E+03_JPRB,0.99942E+03_JPRB /)  
KB(:,16,11) = (/ &
 & 0.98962E+03_JPRB,0.99419E+03_JPRB,0.99730E+03_JPRB,0.99893E+03_JPRB,0.99945E+03_JPRB /)  
KB(:,17,11) = (/ &
 & 0.99016E+03_JPRB,0.99444E+03_JPRB,0.99754E+03_JPRB,0.99903E+03_JPRB,0.99947E+03_JPRB /)  
KB(:,18,11) = (/ &
 & 0.99067E+03_JPRB,0.99497E+03_JPRB,0.99775E+03_JPRB,0.99911E+03_JPRB,0.99948E+03_JPRB /)  
KB(:,19,11) = (/ &
 & 0.99117E+03_JPRB,0.99532E+03_JPRB,0.99795E+03_JPRB,0.99918E+03_JPRB,0.99949E+03_JPRB /)  
KB(:,20,11) = (/ &
 & 0.99173E+03_JPRB,0.99572E+03_JPRB,0.99816E+03_JPRB,0.99924E+03_JPRB,0.99949E+03_JPRB /)  
KB(:,21,11) = (/ &
 & 0.99228E+03_JPRB,0.99610E+03_JPRB,0.99835E+03_JPRB,0.99929E+03_JPRB,0.99946E+03_JPRB /)  
KB(:,22,11) = (/ &
 & 0.99309E+03_JPRB,0.99663E+03_JPRB,0.99862E+03_JPRB,0.99936E+03_JPRB,0.99953E+03_JPRB /)  
KB(:,23,11) = (/ &
 & 0.99388E+03_JPRB,0.99698E+03_JPRB,0.99900E+03_JPRB,0.99942E+03_JPRB,0.99925E+03_JPRB /)  
KB(:,24,11) = (/ &
 & 0.99466E+03_JPRB,0.99758E+03_JPRB,0.99904E+03_JPRB,0.99947E+03_JPRB,0.99905E+03_JPRB /)  
KB(:,25,11) = (/ &
 & 0.99542E+03_JPRB,0.99800E+03_JPRB,0.99919E+03_JPRB,0.99963E+03_JPRB,0.99878E+03_JPRB /)  
KB(:,26,11) = (/ &
 & 0.99618E+03_JPRB,0.99839E+03_JPRB,0.99930E+03_JPRB,0.99945E+03_JPRB,0.99847E+03_JPRB /)  
KB(:,27,11) = (/ &
 & 0.99683E+03_JPRB,0.99872E+03_JPRB,0.99939E+03_JPRB,0.99934E+03_JPRB,0.99751E+03_JPRB /)  
KB(:,28,11) = (/ &
 & 0.99741E+03_JPRB,0.99897E+03_JPRB,0.99946E+03_JPRB,0.99913E+03_JPRB,0.99749E+03_JPRB /)  
KB(:,29,11) = (/ &
 & 0.99792E+03_JPRB,0.99917E+03_JPRB,0.99949E+03_JPRB,0.99884E+03_JPRB,0.99707E+03_JPRB /)  
KB(:,30,11) = (/ &
 & 0.99821E+03_JPRB,0.99929E+03_JPRB,0.99946E+03_JPRB,0.99850E+03_JPRB,0.99637E+03_JPRB /)  
KB(:,31,11) = (/ &
 & 0.99871E+03_JPRB,0.99938E+03_JPRB,0.99949E+03_JPRB,0.99810E+03_JPRB,0.99532E+03_JPRB /)  
KB(:,32,11) = (/ &
 & 0.99899E+03_JPRB,0.99961E+03_JPRB,0.99926E+03_JPRB,0.99761E+03_JPRB,0.99460E+03_JPRB /)  
KB(:,33,11) = (/ &
 & 0.99918E+03_JPRB,0.99949E+03_JPRB,0.99880E+03_JPRB,0.99700E+03_JPRB,0.99413E+03_JPRB /)  
KB(:,34,11) = (/ &
 & 0.99929E+03_JPRB,0.99946E+03_JPRB,0.99850E+03_JPRB,0.99635E+03_JPRB,0.99329E+03_JPRB /)  
KB(:,35,11) = (/ &
 & 0.99934E+03_JPRB,0.99941E+03_JPRB,0.99830E+03_JPRB,0.99590E+03_JPRB,0.99292E+03_JPRB /)  
KB(:,36,11) = (/ &
 & 0.99935E+03_JPRB,0.99940E+03_JPRB,0.99826E+03_JPRB,0.99583E+03_JPRB,0.99287E+03_JPRB /)  
KB(:,37,11) = (/ &
 & 0.99930E+03_JPRB,0.99946E+03_JPRB,0.99846E+03_JPRB,0.99628E+03_JPRB,0.99327E+03_JPRB /)  
KB(:,38,11) = (/ &
 & 0.99924E+03_JPRB,0.99949E+03_JPRB,0.99866E+03_JPRB,0.99670E+03_JPRB,0.99350E+03_JPRB /)  
KB(:,39,11) = (/ &
 & 0.99917E+03_JPRB,0.99949E+03_JPRB,0.99899E+03_JPRB,0.99707E+03_JPRB,0.99451E+03_JPRB /)  
KB(:,40,11) = (/ &
 & 0.99898E+03_JPRB,0.99946E+03_JPRB,0.99913E+03_JPRB,0.99777E+03_JPRB,0.99505E+03_JPRB /)  
KB(:,41,11) = (/ &
 & 0.99871E+03_JPRB,0.99939E+03_JPRB,0.99935E+03_JPRB,0.99810E+03_JPRB,0.99546E+03_JPRB /)  
KB(:,42,11) = (/ &
 & 0.99835E+03_JPRB,0.99929E+03_JPRB,0.99947E+03_JPRB,0.99851E+03_JPRB,0.99637E+03_JPRB /)  
KB(:,43,11) = (/ &
 & 0.99780E+03_JPRB,0.99913E+03_JPRB,0.99949E+03_JPRB,0.99893E+03_JPRB,0.99722E+03_JPRB /)  
KB(:,44,11) = (/ &
 & 0.99704E+03_JPRB,0.99882E+03_JPRB,0.99942E+03_JPRB,0.99928E+03_JPRB,0.99778E+03_JPRB /)  
KB(:,45,11) = (/ &
 & 0.99613E+03_JPRB,0.99837E+03_JPRB,0.99930E+03_JPRB,0.99947E+03_JPRB,0.99849E+03_JPRB /)  
KB(:,46,11) = (/ &
 & 0.99492E+03_JPRB,0.99787E+03_JPRB,0.99911E+03_JPRB,0.99949E+03_JPRB,0.99897E+03_JPRB /)  
KB(:,47,11) = (/ &
 & 0.99335E+03_JPRB,0.99679E+03_JPRB,0.99871E+03_JPRB,0.99939E+03_JPRB,0.99936E+03_JPRB /)  
KB(:,48,11) = (/ &
 & 0.99156E+03_JPRB,0.99560E+03_JPRB,0.99810E+03_JPRB,0.99923E+03_JPRB,0.99951E+03_JPRB /)  
KB(:,49,11) = (/ &
 & 0.98955E+03_JPRB,0.99414E+03_JPRB,0.99727E+03_JPRB,0.99894E+03_JPRB,0.99946E+03_JPRB /)  
KB(:,50,11) = (/ &
 & 0.98749E+03_JPRB,0.99256E+03_JPRB,0.99630E+03_JPRB,0.99847E+03_JPRB,0.99918E+03_JPRB /)  
KB(:,51,11) = (/ &
 & 0.98496E+03_JPRB,0.99085E+03_JPRB,0.99509E+03_JPRB,0.99784E+03_JPRB,0.99916E+03_JPRB /)  
KB(:,52,11) = (/ &
 & 0.98304E+03_JPRB,0.98897E+03_JPRB,0.99370E+03_JPRB,0.99701E+03_JPRB,0.99883E+03_JPRB /)  
KB(:,53,11) = (/ &
 & 0.98104E+03_JPRB,0.98693E+03_JPRB,0.99213E+03_JPRB,0.99600E+03_JPRB,0.99833E+03_JPRB /)  
KB(:,54,11) = (/ &
 & 0.97906E+03_JPRB,0.98440E+03_JPRB,0.99053E+03_JPRB,0.99485E+03_JPRB,0.99771E+03_JPRB /)  
KB(:,55,11) = (/ &
 & 0.97789E+03_JPRB,0.98286E+03_JPRB,0.98886E+03_JPRB,0.99361E+03_JPRB,0.99696E+03_JPRB /)  
KB(:,56,11) = (/ &
 & 0.97514E+03_JPRB,0.98117E+03_JPRB,0.98708E+03_JPRB,0.99224E+03_JPRB,0.99622E+03_JPRB /)  
KB(:,57,11) = (/ &
 & 0.97242E+03_JPRB,0.97945E+03_JPRB,0.98472E+03_JPRB,0.99072E+03_JPRB,0.99500E+03_JPRB /)  
KB(:,58,11) = (/ &
 & 0.96969E+03_JPRB,0.97814E+03_JPRB,0.98316E+03_JPRB,0.98916E+03_JPRB,0.99384E+03_JPRB /)  
KB(:,59,11) = (/ &
 & 0.96859E+03_JPRB,0.97725E+03_JPRB,0.98261E+03_JPRB,0.98851E+03_JPRB,0.99335E+03_JPRB /)  
KB(:,13,12) = (/ &
 & 0.99768E+03_JPRB,0.99984E+03_JPRB,0.10010E+04_JPRB,0.10024E+04_JPRB,0.10029E+04_JPRB /)  
KB(:,14,12) = (/ &
 & 0.99795E+03_JPRB,0.99992E+03_JPRB,0.10011E+04_JPRB,0.10025E+04_JPRB,0.10029E+04_JPRB /)  
KB(:,15,12) = (/ &
 & 0.99880E+03_JPRB,0.99996E+03_JPRB,0.10013E+04_JPRB,0.10026E+04_JPRB,0.10031E+04_JPRB /)  
KB(:,16,12) = (/ &
 & 0.99852E+03_JPRB,0.10003E+04_JPRB,0.10015E+04_JPRB,0.10028E+04_JPRB,0.10029E+04_JPRB /)  
KB(:,17,12) = (/ &
 & 0.99876E+03_JPRB,0.10000E+04_JPRB,0.10016E+04_JPRB,0.10027E+04_JPRB,0.10029E+04_JPRB /)  
KB(:,18,12) = (/ &
 & 0.99898E+03_JPRB,0.10001E+04_JPRB,0.10018E+04_JPRB,0.10028E+04_JPRB,0.10028E+04_JPRB /)  
KB(:,19,12) = (/ &
 & 0.99918E+03_JPRB,0.10003E+04_JPRB,0.10021E+04_JPRB,0.10028E+04_JPRB,0.10028E+04_JPRB /)  
KB(:,20,12) = (/ &
 & 0.99940E+03_JPRB,0.10005E+04_JPRB,0.10026E+04_JPRB,0.10029E+04_JPRB,0.10031E+04_JPRB /)  
KB(:,21,12) = (/ &
 & 0.99959E+03_JPRB,0.10007E+04_JPRB,0.10022E+04_JPRB,0.10029E+04_JPRB,0.10026E+04_JPRB /)  
KB(:,22,12) = (/ &
 & 0.99984E+03_JPRB,0.10010E+04_JPRB,0.10024E+04_JPRB,0.10030E+04_JPRB,0.10023E+04_JPRB /)  
KB(:,23,12) = (/ &
 & 0.99996E+03_JPRB,0.10013E+04_JPRB,0.10024E+04_JPRB,0.10029E+04_JPRB,0.10025E+04_JPRB /)  
KB(:,24,12) = (/ &
 & 0.10000E+04_JPRB,0.10016E+04_JPRB,0.10029E+04_JPRB,0.10029E+04_JPRB,0.10023E+04_JPRB /)  
KB(:,25,12) = (/ &
 & 0.10003E+04_JPRB,0.10023E+04_JPRB,0.10029E+04_JPRB,0.10026E+04_JPRB,0.10019E+04_JPRB /)  
KB(:,26,12) = (/ &
 & 0.10007E+04_JPRB,0.10022E+04_JPRB,0.10029E+04_JPRB,0.10026E+04_JPRB,0.10015E+04_JPRB /)  
KB(:,27,12) = (/ &
 & 0.10012E+04_JPRB,0.10025E+04_JPRB,0.10031E+04_JPRB,0.10024E+04_JPRB,0.10010E+04_JPRB /)  
KB(:,28,12) = (/ &
 & 0.10015E+04_JPRB,0.10027E+04_JPRB,0.10029E+04_JPRB,0.10022E+04_JPRB,0.10005E+04_JPRB /)  
KB(:,29,12) = (/ &
 & 0.10019E+04_JPRB,0.10028E+04_JPRB,0.10028E+04_JPRB,0.10019E+04_JPRB,0.99992E+03_JPRB /)  
KB(:,30,12) = (/ &
 & 0.10022E+04_JPRB,0.10029E+04_JPRB,0.10026E+04_JPRB,0.10017E+04_JPRB,0.99965E+03_JPRB /)  
KB(:,31,12) = (/ &
 & 0.10025E+04_JPRB,0.10030E+04_JPRB,0.10022E+04_JPRB,0.10011E+04_JPRB,0.99843E+03_JPRB /)  
KB(:,32,12) = (/ &
 & 0.10027E+04_JPRB,0.10029E+04_JPRB,0.10020E+04_JPRB,0.10007E+04_JPRB,0.99748E+03_JPRB /)  
KB(:,33,12) = (/ &
 & 0.10029E+04_JPRB,0.10028E+04_JPRB,0.10021E+04_JPRB,0.10000E+04_JPRB,0.99658E+03_JPRB /)  
KB(:,34,12) = (/ &
 & 0.10031E+04_JPRB,0.10026E+04_JPRB,0.10017E+04_JPRB,0.99945E+03_JPRB,0.99563E+03_JPRB /)  
KB(:,35,12) = (/ &
 & 0.10030E+04_JPRB,0.10025E+04_JPRB,0.10031E+04_JPRB,0.99888E+03_JPRB,0.99496E+03_JPRB /)  
KB(:,36,12) = (/ &
 & 0.10030E+04_JPRB,0.10025E+04_JPRB,0.10020E+04_JPRB,0.99880E+03_JPRB,0.99482E+03_JPRB /)  
KB(:,37,12) = (/ &
 & 0.10029E+04_JPRB,0.10026E+04_JPRB,0.10015E+04_JPRB,0.99939E+03_JPRB,0.99547E+03_JPRB /)  
KB(:,38,12) = (/ &
 & 0.10029E+04_JPRB,0.10027E+04_JPRB,0.10017E+04_JPRB,0.99958E+03_JPRB,0.99634E+03_JPRB /)  
KB(:,39,12) = (/ &
 & 0.10028E+04_JPRB,0.10028E+04_JPRB,0.10017E+04_JPRB,0.99993E+03_JPRB,0.99613E+03_JPRB /)  
KB(:,40,12) = (/ &
 & 0.10027E+04_JPRB,0.10029E+04_JPRB,0.10022E+04_JPRB,0.10003E+04_JPRB,0.99696E+03_JPRB /)  
KB(:,41,12) = (/ &
 & 0.10027E+04_JPRB,0.10029E+04_JPRB,0.10024E+04_JPRB,0.10013E+04_JPRB,0.99857E+03_JPRB /)  
KB(:,42,12) = (/ &
 & 0.10022E+04_JPRB,0.10029E+04_JPRB,0.10028E+04_JPRB,0.10021E+04_JPRB,0.99929E+03_JPRB /)  
KB(:,43,12) = (/ &
 & 0.10018E+04_JPRB,0.10028E+04_JPRB,0.10028E+04_JPRB,0.10020E+04_JPRB,0.10001E+04_JPRB /)  
KB(:,44,12) = (/ &
 & 0.10013E+04_JPRB,0.10026E+04_JPRB,0.10029E+04_JPRB,0.10023E+04_JPRB,0.10016E+04_JPRB /)  
KB(:,45,12) = (/ &
 & 0.10007E+04_JPRB,0.10022E+04_JPRB,0.10029E+04_JPRB,0.10026E+04_JPRB,0.10015E+04_JPRB /)  
KB(:,46,12) = (/ &
 & 0.10014E+04_JPRB,0.10016E+04_JPRB,0.10028E+04_JPRB,0.10028E+04_JPRB,0.10020E+04_JPRB /)  
KB(:,47,12) = (/ &
 & 0.99993E+03_JPRB,0.10012E+04_JPRB,0.10025E+04_JPRB,0.10029E+04_JPRB,0.10024E+04_JPRB /)  
KB(:,48,12) = (/ &
 & 0.99937E+03_JPRB,0.10005E+04_JPRB,0.10022E+04_JPRB,0.10029E+04_JPRB,0.10027E+04_JPRB /)  
KB(:,49,12) = (/ &
 & 0.99853E+03_JPRB,0.10002E+04_JPRB,0.10015E+04_JPRB,0.10026E+04_JPRB,0.10029E+04_JPRB /)  
KB(:,50,12) = (/ &
 & 0.99741E+03_JPRB,0.99993E+03_JPRB,0.10008E+04_JPRB,0.10023E+04_JPRB,0.10029E+04_JPRB /)  
KB(:,51,12) = (/ &
 & 0.99665E+03_JPRB,0.99912E+03_JPRB,0.10002E+04_JPRB,0.10018E+04_JPRB,0.10028E+04_JPRB /)  
KB(:,52,12) = (/ &
 & 0.99385E+03_JPRB,0.99826E+03_JPRB,0.10000E+04_JPRB,0.10013E+04_JPRB,0.10025E+04_JPRB /)  
KB(:,53,12) = (/ &
 & 0.99099E+03_JPRB,0.99714E+03_JPRB,0.99965E+03_JPRB,0.10007E+04_JPRB,0.10022E+04_JPRB /)  
KB(:,54,12) = (/ &
 & 0.98826E+03_JPRB,0.99612E+03_JPRB,0.99903E+03_JPRB,0.10002E+04_JPRB,0.10018E+04_JPRB /)  
KB(:,55,12) = (/ &
 & 0.98397E+03_JPRB,0.99379E+03_JPRB,0.99822E+03_JPRB,0.10000E+04_JPRB,0.10013E+04_JPRB /)  
KB(:,56,12) = (/ &
 & 0.98006E+03_JPRB,0.99120E+03_JPRB,0.99722E+03_JPRB,0.99969E+03_JPRB,0.10006E+04_JPRB /)  
KB(:,57,12) = (/ &
 & 0.97631E+03_JPRB,0.98840E+03_JPRB,0.99624E+03_JPRB,0.99911E+03_JPRB,0.10002E+04_JPRB /)  
KB(:,58,12) = (/ &
 & 0.97279E+03_JPRB,0.98508E+03_JPRB,0.99422E+03_JPRB,0.99838E+03_JPRB,0.10001E+04_JPRB /)  
KB(:,59,12) = (/ &
 & 0.97171E+03_JPRB,0.98327E+03_JPRB,0.99315E+03_JPRB,0.99818E+03_JPRB,0.99997E+03_JPRB /)  
KB(:,13,13) = (/ &
 & 0.99623E+03_JPRB,0.99978E+03_JPRB,0.10034E+04_JPRB,0.10050E+04_JPRB,0.10054E+04_JPRB /)  
KB(:,14,13) = (/ &
 & 0.99674E+03_JPRB,0.10002E+04_JPRB,0.10034E+04_JPRB,0.10050E+04_JPRB,0.10053E+04_JPRB /)  
KB(:,15,13) = (/ &
 & 0.99652E+03_JPRB,0.10007E+04_JPRB,0.10036E+04_JPRB,0.10051E+04_JPRB,0.10051E+04_JPRB /)  
KB(:,16,13) = (/ &
 & 0.99785E+03_JPRB,0.10007E+04_JPRB,0.10039E+04_JPRB,0.10049E+04_JPRB,0.10053E+04_JPRB /)  
KB(:,17,13) = (/ &
 & 0.99816E+03_JPRB,0.10017E+04_JPRB,0.10043E+04_JPRB,0.10052E+04_JPRB,0.10052E+04_JPRB /)  
KB(:,18,13) = (/ &
 & 0.99792E+03_JPRB,0.10021E+04_JPRB,0.10042E+04_JPRB,0.10053E+04_JPRB,0.10051E+04_JPRB /)  
KB(:,19,13) = (/ &
 & 0.99826E+03_JPRB,0.10023E+04_JPRB,0.10042E+04_JPRB,0.10053E+04_JPRB,0.10051E+04_JPRB /)  
KB(:,20,13) = (/ &
 & 0.99869E+03_JPRB,0.10028E+04_JPRB,0.10038E+04_JPRB,0.10053E+04_JPRB,0.10044E+04_JPRB /)  
KB(:,21,13) = (/ &
 & 0.99914E+03_JPRB,0.10028E+04_JPRB,0.10048E+04_JPRB,0.10054E+04_JPRB,0.10048E+04_JPRB /)  
KB(:,22,13) = (/ &
 & 0.99989E+03_JPRB,0.10035E+04_JPRB,0.10050E+04_JPRB,0.10053E+04_JPRB,0.10046E+04_JPRB /)  
KB(:,23,13) = (/ &
 & 0.10011E+04_JPRB,0.10037E+04_JPRB,0.10051E+04_JPRB,0.10053E+04_JPRB,0.10041E+04_JPRB /)  
KB(:,24,13) = (/ &
 & 0.10018E+04_JPRB,0.10041E+04_JPRB,0.10050E+04_JPRB,0.10052E+04_JPRB,0.10037E+04_JPRB /)  
KB(:,25,13) = (/ &
 & 0.10026E+04_JPRB,0.10040E+04_JPRB,0.10056E+04_JPRB,0.10050E+04_JPRB,0.10036E+04_JPRB /)  
KB(:,26,13) = (/ &
 & 0.10031E+04_JPRB,0.10048E+04_JPRB,0.10054E+04_JPRB,0.10050E+04_JPRB,0.10030E+04_JPRB /)  
KB(:,27,13) = (/ &
 & 0.10047E+04_JPRB,0.10050E+04_JPRB,0.10051E+04_JPRB,0.10045E+04_JPRB,0.10025E+04_JPRB /)  
KB(:,28,13) = (/ &
 & 0.10039E+04_JPRB,0.10052E+04_JPRB,0.10052E+04_JPRB,0.10041E+04_JPRB,0.10018E+04_JPRB /)  
KB(:,29,13) = (/ &
 & 0.10044E+04_JPRB,0.10053E+04_JPRB,0.10051E+04_JPRB,0.10037E+04_JPRB,0.10011E+04_JPRB /)  
KB(:,30,13) = (/ &
 & 0.10048E+04_JPRB,0.10054E+04_JPRB,0.10048E+04_JPRB,0.10029E+04_JPRB,0.99977E+03_JPRB /)  
KB(:,31,13) = (/ &
 & 0.10050E+04_JPRB,0.10053E+04_JPRB,0.10045E+04_JPRB,0.10025E+04_JPRB,0.99968E+03_JPRB /)  
KB(:,32,13) = (/ &
 & 0.10052E+04_JPRB,0.10050E+04_JPRB,0.10041E+04_JPRB,0.10015E+04_JPRB,0.99880E+03_JPRB /)  
KB(:,33,13) = (/ &
 & 0.10053E+04_JPRB,0.10050E+04_JPRB,0.10033E+04_JPRB,0.10008E+04_JPRB,0.99675E+03_JPRB /)  
KB(:,34,13) = (/ &
 & 0.10051E+04_JPRB,0.10048E+04_JPRB,0.10028E+04_JPRB,0.10000E+04_JPRB,0.99529E+03_JPRB /)  
KB(:,35,13) = (/ &
 & 0.10054E+04_JPRB,0.10047E+04_JPRB,0.10003E+04_JPRB,0.99992E+03_JPRB,0.99481E+03_JPRB /)  
KB(:,36,13) = (/ &
 & 0.10054E+04_JPRB,0.10046E+04_JPRB,0.10017E+04_JPRB,0.99987E+03_JPRB,0.99445E+03_JPRB /)  
KB(:,37,13) = (/ &
 & 0.10054E+04_JPRB,0.10048E+04_JPRB,0.10030E+04_JPRB,0.99995E+03_JPRB,0.99517E+03_JPRB /)  
KB(:,38,13) = (/ &
 & 0.10054E+04_JPRB,0.10049E+04_JPRB,0.10034E+04_JPRB,0.10006E+04_JPRB,0.99603E+03_JPRB /)  
KB(:,39,13) = (/ &
 & 0.10053E+04_JPRB,0.10051E+04_JPRB,0.10037E+04_JPRB,0.10011E+04_JPRB,0.99693E+03_JPRB /)  
KB(:,40,13) = (/ &
 & 0.10052E+04_JPRB,0.10052E+04_JPRB,0.10041E+04_JPRB,0.10018E+04_JPRB,0.99860E+03_JPRB /)  
KB(:,41,13) = (/ &
 & 0.10048E+04_JPRB,0.10053E+04_JPRB,0.10045E+04_JPRB,0.10023E+04_JPRB,0.99951E+03_JPRB /)  
KB(:,42,13) = (/ &
 & 0.10048E+04_JPRB,0.10054E+04_JPRB,0.10046E+04_JPRB,0.10024E+04_JPRB,0.10003E+04_JPRB /)  
KB(:,43,13) = (/ &
 & 0.10043E+04_JPRB,0.10053E+04_JPRB,0.10051E+04_JPRB,0.10038E+04_JPRB,0.10013E+04_JPRB /)  
KB(:,44,13) = (/ &
 & 0.10036E+04_JPRB,0.10051E+04_JPRB,0.10053E+04_JPRB,0.10044E+04_JPRB,0.10012E+04_JPRB /)  
KB(:,45,13) = (/ &
 & 0.10028E+04_JPRB,0.10048E+04_JPRB,0.10054E+04_JPRB,0.10048E+04_JPRB,0.10031E+04_JPRB /)  
KB(:,46,13) = (/ &
 & 0.10008E+04_JPRB,0.10042E+04_JPRB,0.10053E+04_JPRB,0.10052E+04_JPRB,0.10038E+04_JPRB /)  
KB(:,47,13) = (/ &
 & 0.10002E+04_JPRB,0.10039E+04_JPRB,0.10050E+04_JPRB,0.10053E+04_JPRB,0.10045E+04_JPRB /)  
KB(:,48,13) = (/ &
 & 0.99859E+03_JPRB,0.10025E+04_JPRB,0.10043E+04_JPRB,0.10054E+04_JPRB,0.10050E+04_JPRB /)  
KB(:,49,13) = (/ &
 & 0.99776E+03_JPRB,0.10009E+04_JPRB,0.10041E+04_JPRB,0.10052E+04_JPRB,0.10053E+04_JPRB /)  
KB(:,50,13) = (/ &
 & 0.99565E+03_JPRB,0.99944E+03_JPRB,0.10034E+04_JPRB,0.10049E+04_JPRB,0.10054E+04_JPRB /)  
KB(:,51,13) = (/ &
 & 0.99271E+03_JPRB,0.99811E+03_JPRB,0.10022E+04_JPRB,0.10043E+04_JPRB,0.10053E+04_JPRB /)  
KB(:,52,13) = (/ &
 & 0.99056E+03_JPRB,0.99717E+03_JPRB,0.10006E+04_JPRB,0.10036E+04_JPRB,0.10051E+04_JPRB /)  
KB(:,53,13) = (/ &
 & 0.98830E+03_JPRB,0.99502E+03_JPRB,0.99909E+03_JPRB,0.10028E+04_JPRB,0.10048E+04_JPRB /)  
KB(:,54,13) = (/ &
 & 0.98610E+03_JPRB,0.99275E+03_JPRB,0.99821E+03_JPRB,0.10021E+04_JPRB,0.10042E+04_JPRB /)  
KB(:,55,13) = (/ &
 & 0.98386E+03_JPRB,0.99045E+03_JPRB,0.99729E+03_JPRB,0.10008E+04_JPRB,0.10038E+04_JPRB /)  
KB(:,56,13) = (/ &
 & 0.98150E+03_JPRB,0.98846E+03_JPRB,0.99517E+03_JPRB,0.99919E+03_JPRB,0.10028E+04_JPRB /)  
KB(:,57,13) = (/ &
 & 0.97902E+03_JPRB,0.98636E+03_JPRB,0.99303E+03_JPRB,0.99832E+03_JPRB,0.10022E+04_JPRB /)  
KB(:,58,13) = (/ &
 & 0.97656E+03_JPRB,0.98426E+03_JPRB,0.99079E+03_JPRB,0.99735E+03_JPRB,0.10008E+04_JPRB /)  
KB(:,59,13) = (/ &
 & 0.97503E+03_JPRB,0.98337E+03_JPRB,0.99004E+03_JPRB,0.99647E+03_JPRB,0.10002E+04_JPRB /)  
KB(:,13,14) = (/ &
 & 0.99596E+03_JPRB,0.10023E+04_JPRB,0.10047E+04_JPRB,0.10067E+04_JPRB,0.10072E+04_JPRB /)  
KB(:,14,14) = (/ &
 & 0.99625E+03_JPRB,0.10024E+04_JPRB,0.10052E+04_JPRB,0.10068E+04_JPRB,0.10071E+04_JPRB /)  
KB(:,15,14) = (/ &
 & 0.99662E+03_JPRB,0.10025E+04_JPRB,0.10054E+04_JPRB,0.10069E+04_JPRB,0.10071E+04_JPRB /)  
KB(:,16,14) = (/ &
 & 0.99703E+03_JPRB,0.10026E+04_JPRB,0.10056E+04_JPRB,0.10070E+04_JPRB,0.10070E+04_JPRB /)  
KB(:,17,14) = (/ &
 & 0.99784E+03_JPRB,0.10032E+04_JPRB,0.10054E+04_JPRB,0.10071E+04_JPRB,0.10070E+04_JPRB /)  
KB(:,18,14) = (/ &
 & 0.99947E+03_JPRB,0.10032E+04_JPRB,0.10060E+04_JPRB,0.10071E+04_JPRB,0.10069E+04_JPRB /)  
KB(:,19,14) = (/ &
 & 0.10001E+04_JPRB,0.10036E+04_JPRB,0.10062E+04_JPRB,0.10071E+04_JPRB,0.10068E+04_JPRB /)  
KB(:,20,14) = (/ &
 & 0.10009E+04_JPRB,0.10037E+04_JPRB,0.10064E+04_JPRB,0.10076E+04_JPRB,0.10067E+04_JPRB /)  
KB(:,21,14) = (/ &
 & 0.10015E+04_JPRB,0.10046E+04_JPRB,0.10065E+04_JPRB,0.10072E+04_JPRB,0.10065E+04_JPRB /)  
KB(:,22,14) = (/ &
 & 0.10023E+04_JPRB,0.10047E+04_JPRB,0.10068E+04_JPRB,0.10071E+04_JPRB,0.10063E+04_JPRB /)  
KB(:,23,14) = (/ &
 & 0.10021E+04_JPRB,0.10055E+04_JPRB,0.10069E+04_JPRB,0.10071E+04_JPRB,0.10060E+04_JPRB /)  
KB(:,24,14) = (/ &
 & 0.10028E+04_JPRB,0.10059E+04_JPRB,0.10071E+04_JPRB,0.10069E+04_JPRB,0.10057E+04_JPRB /)  
KB(:,25,14) = (/ &
 & 0.10033E+04_JPRB,0.10062E+04_JPRB,0.10068E+04_JPRB,0.10068E+04_JPRB,0.10052E+04_JPRB /)  
KB(:,26,14) = (/ &
 & 0.10043E+04_JPRB,0.10066E+04_JPRB,0.10072E+04_JPRB,0.10061E+04_JPRB,0.10047E+04_JPRB /)  
KB(:,27,14) = (/ &
 & 0.10033E+04_JPRB,0.10068E+04_JPRB,0.10071E+04_JPRB,0.10062E+04_JPRB,0.10042E+04_JPRB /)  
KB(:,28,14) = (/ &
 & 0.10057E+04_JPRB,0.10070E+04_JPRB,0.10070E+04_JPRB,0.10058E+04_JPRB,0.10036E+04_JPRB /)  
KB(:,29,14) = (/ &
 & 0.10062E+04_JPRB,0.10075E+04_JPRB,0.10068E+04_JPRB,0.10053E+04_JPRB,0.10030E+04_JPRB /)  
KB(:,30,14) = (/ &
 & 0.10065E+04_JPRB,0.10072E+04_JPRB,0.10069E+04_JPRB,0.10048E+04_JPRB,0.10022E+04_JPRB /)  
KB(:,31,14) = (/ &
 & 0.10068E+04_JPRB,0.10071E+04_JPRB,0.10062E+04_JPRB,0.10042E+04_JPRB,0.10014E+04_JPRB /)  
KB(:,32,14) = (/ &
 & 0.10070E+04_JPRB,0.10070E+04_JPRB,0.10058E+04_JPRB,0.10035E+04_JPRB,0.99925E+03_JPRB /)  
KB(:,33,14) = (/ &
 & 0.10071E+04_JPRB,0.10068E+04_JPRB,0.10053E+04_JPRB,0.10029E+04_JPRB,0.99808E+03_JPRB /)  
KB(:,34,14) = (/ &
 & 0.10072E+04_JPRB,0.10065E+04_JPRB,0.10048E+04_JPRB,0.10021E+04_JPRB,0.99788E+03_JPRB /)  
KB(:,35,14) = (/ &
 & 0.10072E+04_JPRB,0.10064E+04_JPRB,0.10045E+04_JPRB,0.10016E+04_JPRB,0.99700E+03_JPRB /)  
KB(:,36,14) = (/ &
 & 0.10072E+04_JPRB,0.10063E+04_JPRB,0.10044E+04_JPRB,0.10015E+04_JPRB,0.99731E+03_JPRB /)  
KB(:,37,14) = (/ &
 & 0.10072E+04_JPRB,0.10065E+04_JPRB,0.10047E+04_JPRB,0.10021E+04_JPRB,0.99778E+03_JPRB /)  
KB(:,38,14) = (/ &
 & 0.10072E+04_JPRB,0.10067E+04_JPRB,0.10050E+04_JPRB,0.10026E+04_JPRB,0.99820E+03_JPRB /)  
KB(:,39,14) = (/ &
 & 0.10071E+04_JPRB,0.10068E+04_JPRB,0.10053E+04_JPRB,0.10030E+04_JPRB,0.99855E+03_JPRB /)  
KB(:,40,14) = (/ &
 & 0.10070E+04_JPRB,0.10070E+04_JPRB,0.10058E+04_JPRB,0.10036E+04_JPRB,0.99965E+03_JPRB /)  
KB(:,41,14) = (/ &
 & 0.10068E+04_JPRB,0.10071E+04_JPRB,0.10062E+04_JPRB,0.10042E+04_JPRB,0.10010E+04_JPRB /)  
KB(:,42,14) = (/ &
 & 0.10065E+04_JPRB,0.10072E+04_JPRB,0.10065E+04_JPRB,0.10048E+04_JPRB,0.10022E+04_JPRB /)  
KB(:,43,14) = (/ &
 & 0.10061E+04_JPRB,0.10071E+04_JPRB,0.10069E+04_JPRB,0.10055E+04_JPRB,0.10031E+04_JPRB /)  
KB(:,44,14) = (/ &
 & 0.10054E+04_JPRB,0.10069E+04_JPRB,0.10071E+04_JPRB,0.10061E+04_JPRB,0.10039E+04_JPRB /)  
KB(:,45,14) = (/ &
 & 0.10046E+04_JPRB,0.10066E+04_JPRB,0.10072E+04_JPRB,0.10065E+04_JPRB,0.10048E+04_JPRB /)  
KB(:,46,14) = (/ &
 & 0.10023E+04_JPRB,0.10060E+04_JPRB,0.10075E+04_JPRB,0.10069E+04_JPRB,0.10055E+04_JPRB /)  
KB(:,47,14) = (/ &
 & 0.10024E+04_JPRB,0.10044E+04_JPRB,0.10068E+04_JPRB,0.10071E+04_JPRB,0.10062E+04_JPRB /)  
KB(:,48,14) = (/ &
 & 0.10006E+04_JPRB,0.10039E+04_JPRB,0.10063E+04_JPRB,0.10072E+04_JPRB,0.10067E+04_JPRB /)  
KB(:,49,14) = (/ &
 & 0.99705E+03_JPRB,0.10026E+04_JPRB,0.10052E+04_JPRB,0.10070E+04_JPRB,0.10070E+04_JPRB /)  
KB(:,50,14) = (/ &
 & 0.99574E+03_JPRB,0.10014E+04_JPRB,0.10040E+04_JPRB,0.10066E+04_JPRB,0.10072E+04_JPRB /)  
KB(:,51,14) = (/ &
 & 0.99447E+03_JPRB,0.99966E+03_JPRB,0.10033E+04_JPRB,0.10065E+04_JPRB,0.10071E+04_JPRB /)  
KB(:,52,14) = (/ &
 & 0.99299E+03_JPRB,0.99670E+03_JPRB,0.10025E+04_JPRB,0.10054E+04_JPRB,0.10069E+04_JPRB /)  
KB(:,53,14) = (/ &
 & 0.99138E+03_JPRB,0.99552E+03_JPRB,0.10013E+04_JPRB,0.10044E+04_JPRB,0.10065E+04_JPRB /)  
KB(:,54,14) = (/ &
 & 0.98979E+03_JPRB,0.99462E+03_JPRB,0.99874E+03_JPRB,0.10030E+04_JPRB,0.10060E+04_JPRB /)  
KB(:,55,14) = (/ &
 & 0.98814E+03_JPRB,0.99291E+03_JPRB,0.99630E+03_JPRB,0.10029E+04_JPRB,0.10050E+04_JPRB /)  
KB(:,56,14) = (/ &
 & 0.98639E+03_JPRB,0.99150E+03_JPRB,0.99562E+03_JPRB,0.10014E+04_JPRB,0.10045E+04_JPRB /)  
KB(:,57,14) = (/ &
 & 0.98454E+03_JPRB,0.98998E+03_JPRB,0.99438E+03_JPRB,0.99904E+03_JPRB,0.10032E+04_JPRB /)  
KB(:,58,14) = (/ &
 & 0.98268E+03_JPRB,0.98844E+03_JPRB,0.99315E+03_JPRB,0.99688E+03_JPRB,0.10025E+04_JPRB /)  
KB(:,59,14) = (/ &
 & 0.98190E+03_JPRB,0.98779E+03_JPRB,0.99262E+03_JPRB,0.99638E+03_JPRB,0.10024E+04_JPRB /)  
KB(:,13,15) = (/ &
 & 0.99739E+03_JPRB,0.10017E+04_JPRB,0.10064E+04_JPRB,0.10076E+04_JPRB,0.10080E+04_JPRB /)  
KB(:,14,15) = (/ &
 & 0.99781E+03_JPRB,0.10021E+04_JPRB,0.10065E+04_JPRB,0.10077E+04_JPRB,0.10090E+04_JPRB /)  
KB(:,15,15) = (/ &
 & 0.99827E+03_JPRB,0.10029E+04_JPRB,0.10067E+04_JPRB,0.10077E+04_JPRB,0.10079E+04_JPRB /)  
KB(:,16,15) = (/ &
 & 0.99875E+03_JPRB,0.10040E+04_JPRB,0.10068E+04_JPRB,0.10078E+04_JPRB,0.10089E+04_JPRB /)  
KB(:,17,15) = (/ &
 & 0.99816E+03_JPRB,0.10041E+04_JPRB,0.10080E+04_JPRB,0.10079E+04_JPRB,0.10078E+04_JPRB /)  
KB(:,18,15) = (/ &
 & 0.99861E+03_JPRB,0.10065E+04_JPRB,0.10071E+04_JPRB,0.10090E+04_JPRB,0.10078E+04_JPRB /)  
KB(:,19,15) = (/ &
 & 0.10001E+04_JPRB,0.10056E+04_JPRB,0.10072E+04_JPRB,0.10079E+04_JPRB,0.10077E+04_JPRB /)  
KB(:,20,15) = (/ &
 & 0.99952E+03_JPRB,0.10059E+04_JPRB,0.10074E+04_JPRB,0.10090E+04_JPRB,0.10087E+04_JPRB /)  
KB(:,21,15) = (/ &
 & 0.10000E+04_JPRB,0.10061E+04_JPRB,0.10085E+04_JPRB,0.10080E+04_JPRB,0.10085E+04_JPRB /)  
KB(:,22,15) = (/ &
 & 0.10012E+04_JPRB,0.10064E+04_JPRB,0.10076E+04_JPRB,0.10090E+04_JPRB,0.10073E+04_JPRB /)  
KB(:,23,15) = (/ &
 & 0.10032E+04_JPRB,0.10067E+04_JPRB,0.10088E+04_JPRB,0.10079E+04_JPRB,0.10070E+04_JPRB /)  
KB(:,24,15) = (/ &
 & 0.10052E+04_JPRB,0.10070E+04_JPRB,0.10079E+04_JPRB,0.10089E+04_JPRB,0.10067E+04_JPRB /)  
KB(:,25,15) = (/ &
 & 0.10057E+04_JPRB,0.10083E+04_JPRB,0.10079E+04_JPRB,0.10098E+04_JPRB,0.10062E+04_JPRB /)  
KB(:,26,15) = (/ &
 & 0.10061E+04_JPRB,0.10085E+04_JPRB,0.10080E+04_JPRB,0.10075E+04_JPRB,0.10068E+04_JPRB /)  
KB(:,27,15) = (/ &
 & 0.10066E+04_JPRB,0.10087E+04_JPRB,0.10111E+04_JPRB,0.10072E+04_JPRB,0.10051E+04_JPRB /)  
KB(:,28,15) = (/ &
 & 0.10069E+04_JPRB,0.10089E+04_JPRB,0.10079E+04_JPRB,0.10068E+04_JPRB,0.10054E+04_JPRB /)  
KB(:,29,15) = (/ &
 & 0.10072E+04_JPRB,0.10069E+04_JPRB,0.10077E+04_JPRB,0.10063E+04_JPRB,0.10034E+04_JPRB /)  
KB(:,30,15) = (/ &
 & 0.10075E+04_JPRB,0.10111E+04_JPRB,0.10075E+04_JPRB,0.10068E+04_JPRB,0.10088E+04_JPRB /)  
KB(:,31,15) = (/ &
 & 0.10077E+04_JPRB,0.10080E+04_JPRB,0.10072E+04_JPRB,0.10061E+04_JPRB,0.10007E+04_JPRB /)  
KB(:,32,15) = (/ &
 & 0.10078E+04_JPRB,0.10089E+04_JPRB,0.10068E+04_JPRB,0.10043E+04_JPRB,0.10013E+04_JPRB /)  
KB(:,33,15) = (/ &
 & 0.10079E+04_JPRB,0.10077E+04_JPRB,0.10063E+04_JPRB,0.10044E+04_JPRB,0.10009E+04_JPRB /)  
KB(:,34,15) = (/ &
 & 0.10090E+04_JPRB,0.10075E+04_JPRB,0.10058E+04_JPRB,0.10025E+04_JPRB,0.10002E+04_JPRB /)  
KB(:,35,15) = (/ &
 & 0.10080E+04_JPRB,0.10073E+04_JPRB,0.10054E+04_JPRB,0.10021E+04_JPRB,0.99972E+03_JPRB /)  
KB(:,36,15) = (/ &
 & 0.10090E+04_JPRB,0.10073E+04_JPRB,0.10054E+04_JPRB,0.10020E+04_JPRB,0.99964E+03_JPRB /)  
KB(:,37,15) = (/ &
 & 0.10080E+04_JPRB,0.10075E+04_JPRB,0.10057E+04_JPRB,0.10024E+04_JPRB,0.10001E+04_JPRB /)  
KB(:,38,15) = (/ &
 & 0.10090E+04_JPRB,0.10076E+04_JPRB,0.10060E+04_JPRB,0.10040E+04_JPRB,0.10006E+04_JPRB /)  
KB(:,39,15) = (/ &
 & 0.10079E+04_JPRB,0.10077E+04_JPRB,0.10063E+04_JPRB,0.10034E+04_JPRB,0.10010E+04_JPRB /)  
KB(:,40,15) = (/ &
 & 0.10089E+04_JPRB,0.10089E+04_JPRB,0.10068E+04_JPRB,0.10054E+04_JPRB,0.10014E+04_JPRB /)  
KB(:,41,15) = (/ &
 & 0.10087E+04_JPRB,0.10090E+04_JPRB,0.10082E+04_JPRB,0.10051E+04_JPRB,0.10018E+04_JPRB /)  
KB(:,42,15) = (/ &
 & 0.10085E+04_JPRB,0.10090E+04_JPRB,0.10075E+04_JPRB,0.10058E+04_JPRB,0.10025E+04_JPRB /)  
KB(:,43,15) = (/ &
 & 0.10071E+04_JPRB,0.10079E+04_JPRB,0.10078E+04_JPRB,0.10086E+04_JPRB,0.10037E+04_JPRB /)  
KB(:,44,15) = (/ &
 & 0.10067E+04_JPRB,0.10088E+04_JPRB,0.10079E+04_JPRB,0.10071E+04_JPRB,0.10048E+04_JPRB /)  
KB(:,45,15) = (/ &
 & 0.10061E+04_JPRB,0.10075E+04_JPRB,0.10090E+04_JPRB,0.10096E+04_JPRB,0.10057E+04_JPRB /)  
KB(:,46,15) = (/ &
 & 0.10054E+04_JPRB,0.10071E+04_JPRB,0.10068E+04_JPRB,0.10078E+04_JPRB,0.10065E+04_JPRB /)  
KB(:,47,15) = (/ &
 & 0.10020E+04_JPRB,0.10065E+04_JPRB,0.10087E+04_JPRB,0.10079E+04_JPRB,0.10093E+04_JPRB /)  
KB(:,48,15) = (/ &
 & 0.99938E+03_JPRB,0.10058E+04_JPRB,0.10073E+04_JPRB,0.10079E+04_JPRB,0.10087E+04_JPRB /)  
KB(:,49,15) = (/ &
 & 0.99869E+03_JPRB,0.10038E+04_JPRB,0.10079E+04_JPRB,0.10099E+04_JPRB,0.10089E+04_JPRB /)  
KB(:,50,15) = (/ &
 & 0.99593E+03_JPRB,0.10003E+04_JPRB,0.10062E+04_JPRB,0.10075E+04_JPRB,0.10090E+04_JPRB /)  
KB(:,51,15) = (/ &
 & 0.99417E+03_JPRB,0.99877E+03_JPRB,0.10055E+04_JPRB,0.10061E+04_JPRB,0.10090E+04_JPRB /)  
KB(:,52,15) = (/ &
 & 0.99334E+03_JPRB,0.99717E+03_JPRB,0.10030E+04_JPRB,0.10077E+04_JPRB,0.10077E+04_JPRB /)  
KB(:,53,15) = (/ &
 & 0.99034E+03_JPRB,0.99548E+03_JPRB,0.99989E+03_JPRB,0.10071E+04_JPRB,0.10085E+04_JPRB /)  
KB(:,54,15) = (/ &
 & 0.98844E+03_JPRB,0.99385E+03_JPRB,0.99849E+03_JPRB,0.10064E+04_JPRB,0.10081E+04_JPRB /)  
KB(:,55,15) = (/ &
 & 0.98654E+03_JPRB,0.99323E+03_JPRB,0.99708E+03_JPRB,0.10005E+04_JPRB,0.10066E+04_JPRB /)  
KB(:,56,15) = (/ &
 & 0.98558E+03_JPRB,0.99048E+03_JPRB,0.99560E+03_JPRB,0.99999E+03_JPRB,0.10071E+04_JPRB /)  
KB(:,57,15) = (/ &
 & 0.98349E+03_JPRB,0.98867E+03_JPRB,0.99404E+03_JPRB,0.99866E+03_JPRB,0.10054E+04_JPRB /)  
KB(:,58,15) = (/ &
 & 0.98039E+03_JPRB,0.98688E+03_JPRB,0.99250E+03_JPRB,0.99837E+03_JPRB,0.10028E+04_JPRB /)  
KB(:,59,15) = (/ &
 & 0.97954E+03_JPRB,0.98614E+03_JPRB,0.99186E+03_JPRB,0.99679E+03_JPRB,0.10019E+04_JPRB /)  
KB(:,13,16) = (/ &
 & 0.98905E+03_JPRB,0.99319E+03_JPRB,0.10065E+04_JPRB,0.10075E+04_JPRB,0.10080E+04_JPRB /)  
KB(:,14,16) = (/ &
 & 0.98947E+03_JPRB,0.10009E+04_JPRB,0.10067E+04_JPRB,0.10076E+04_JPRB,0.10005E+04_JPRB /)  
KB(:,15,16) = (/ &
 & 0.98993E+03_JPRB,0.10052E+04_JPRB,0.10068E+04_JPRB,0.10076E+04_JPRB,0.10080E+04_JPRB /)  
KB(:,16,16) = (/ &
 & 0.99040E+03_JPRB,0.10054E+04_JPRB,0.10069E+04_JPRB,0.10077E+04_JPRB,0.10005E+04_JPRB /)  
KB(:,17,16) = (/ &
 & 0.99823E+03_JPRB,0.10056E+04_JPRB,0.99955E+03_JPRB,0.10078E+04_JPRB,0.10080E+04_JPRB /)  
KB(:,18,16) = (/ &
 & 0.99867E+03_JPRB,0.99832E+03_JPRB,0.10071E+04_JPRB,0.10003E+04_JPRB,0.10079E+04_JPRB /)  
KB(:,19,16) = (/ &
 & 0.99168E+03_JPRB,0.10059E+04_JPRB,0.10072E+04_JPRB,0.10078E+04_JPRB,0.10079E+04_JPRB /)  
KB(:,20,16) = (/ &
 & 0.99955E+03_JPRB,0.10061E+04_JPRB,0.10073E+04_JPRB,0.99297E+03_JPRB,0.10003E+04_JPRB /)  
KB(:,21,16) = (/ &
 & 0.10000E+04_JPRB,0.10063E+04_JPRB,0.99994E+03_JPRB,0.10079E+04_JPRB,0.10002E+04_JPRB /)  
KB(:,22,16) = (/ &
 & 0.10007E+04_JPRB,0.10066E+04_JPRB,0.10075E+04_JPRB,0.10005E+04_JPRB,0.10075E+04_JPRB /)  
KB(:,23,16) = (/ &
 & 0.10052E+04_JPRB,0.10068E+04_JPRB,0.10002E+04_JPRB,0.10080E+04_JPRB,0.10072E+04_JPRB /)  
KB(:,24,16) = (/ &
 & 0.10056E+04_JPRB,0.10070E+04_JPRB,0.10078E+04_JPRB,0.10005E+04_JPRB,0.10068E+04_JPRB /)  
KB(:,25,16) = (/ &
 & 0.10060E+04_JPRB,0.99977E+03_JPRB,0.10079E+04_JPRB,0.99294E+03_JPRB,0.10064E+04_JPRB /)  
KB(:,26,16) = (/ &
 & 0.10064E+04_JPRB,0.99996E+03_JPRB,0.10080E+04_JPRB,0.10077E+04_JPRB,0.99839E+03_JPRB /)  
KB(:,27,16) = (/ &
 & 0.10067E+04_JPRB,0.10001E+04_JPRB,0.98561E+03_JPRB,0.10074E+04_JPRB,0.10052E+04_JPRB /)  
KB(:,28,16) = (/ &
 & 0.10069E+04_JPRB,0.10003E+04_JPRB,0.10080E+04_JPRB,0.10070E+04_JPRB,0.99700E+03_JPRB /)  
KB(:,29,16) = (/ &
 & 0.10072E+04_JPRB,0.10078E+04_JPRB,0.10079E+04_JPRB,0.10065E+04_JPRB,0.10036E+04_JPRB /)  
KB(:,30,16) = (/ &
 & 0.10074E+04_JPRB,0.98555E+03_JPRB,0.10002E+04_JPRB,0.99845E+03_JPRB,0.95900E+03_JPRB /)  
KB(:,31,16) = (/ &
 & 0.10076E+04_JPRB,0.10080E+04_JPRB,0.10074E+04_JPRB,0.99776E+03_JPRB,0.10037E+04_JPRB /)  
KB(:,32,16) = (/ &
 & 0.10077E+04_JPRB,0.10005E+04_JPRB,0.10070E+04_JPRB,0.10044E+04_JPRB,0.10038E+04_JPRB /)  
KB(:,33,16) = (/ &
 & 0.10079E+04_JPRB,0.10079E+04_JPRB,0.10064E+04_JPRB,0.99602E+03_JPRB,0.10038E+04_JPRB /)  
KB(:,34,16) = (/ &
 & 0.10005E+04_JPRB,0.10077E+04_JPRB,0.10059E+04_JPRB,0.10036E+04_JPRB,0.10037E+04_JPRB /)  
KB(:,35,16) = (/ &
 & 0.10080E+04_JPRB,0.10075E+04_JPRB,0.10055E+04_JPRB,0.10037E+04_JPRB,0.10036E+04_JPRB /)  
KB(:,36,16) = (/ &
 & 0.10005E+04_JPRB,0.10075E+04_JPRB,0.10055E+04_JPRB,0.10037E+04_JPRB,0.10036E+04_JPRB /)  
KB(:,37,16) = (/ &
 & 0.10080E+04_JPRB,0.10077E+04_JPRB,0.10058E+04_JPRB,0.10037E+04_JPRB,0.10037E+04_JPRB /)  
KB(:,38,16) = (/ &
 & 0.10004E+04_JPRB,0.10078E+04_JPRB,0.10062E+04_JPRB,0.99569E+03_JPRB,0.10037E+04_JPRB /)  
KB(:,39,16) = (/ &
 & 0.10078E+04_JPRB,0.10079E+04_JPRB,0.10065E+04_JPRB,0.10036E+04_JPRB,0.10038E+04_JPRB /)  
KB(:,40,16) = (/ &
 & 0.10003E+04_JPRB,0.10005E+04_JPRB,0.10070E+04_JPRB,0.99698E+03_JPRB,0.10038E+04_JPRB /)  
KB(:,41,16) = (/ &
 & 0.10001E+04_JPRB,0.10005E+04_JPRB,0.99992E+03_JPRB,0.10052E+04_JPRB,0.10037E+04_JPRB /)  
KB(:,42,16) = (/ &
 & 0.99994E+03_JPRB,0.10005E+04_JPRB,0.10077E+04_JPRB,0.10059E+04_JPRB,0.10036E+04_JPRB /)  
KB(:,43,16) = (/ &
 & 0.10071E+04_JPRB,0.10078E+04_JPRB,0.10079E+04_JPRB,0.99172E+03_JPRB,0.10038E+04_JPRB /)  
KB(:,44,16) = (/ &
 & 0.10068E+04_JPRB,0.10002E+04_JPRB,0.10080E+04_JPRB,0.10072E+04_JPRB,0.10049E+04_JPRB /)  
KB(:,45,16) = (/ &
 & 0.10063E+04_JPRB,0.10074E+04_JPRB,0.10005E+04_JPRB,0.99276E+03_JPRB,0.10059E+04_JPRB /)  
KB(:,46,16) = (/ &
 & 0.10057E+04_JPRB,0.10071E+04_JPRB,0.10078E+04_JPRB,0.10079E+04_JPRB,0.10067E+04_JPRB /)  
KB(:,47,16) = (/ &
 & 0.10009E+04_JPRB,0.10067E+04_JPRB,0.10001E+04_JPRB,0.10080E+04_JPRB,0.99247E+03_JPRB /)  
KB(:,48,16) = (/ &
 & 0.99941E+03_JPRB,0.10061E+04_JPRB,0.10073E+04_JPRB,0.10079E+04_JPRB,0.10004E+04_JPRB /)  
KB(:,49,16) = (/ &
 & 0.99034E+03_JPRB,0.10054E+04_JPRB,0.99943E+03_JPRB,0.99276E+03_JPRB,0.10005E+04_JPRB /)  
KB(:,50,16) = (/ &
 & 0.99601E+03_JPRB,0.10003E+04_JPRB,0.10064E+04_JPRB,0.10074E+04_JPRB,0.10005E+04_JPRB /)  
KB(:,51,16) = (/ &
 & 0.99422E+03_JPRB,0.99882E+03_JPRB,0.10058E+04_JPRB,0.10071E+04_JPRB,0.10003E+04_JPRB /)  
KB(:,52,16) = (/ &
 & 0.98496E+03_JPRB,0.99726E+03_JPRB,0.10013E+04_JPRB,0.99930E+03_JPRB,0.10076E+04_JPRB /)  
KB(:,53,16) = (/ &
 & 0.99030E+03_JPRB,0.99555E+03_JPRB,0.99990E+03_JPRB,0.99882E+03_JPRB,0.99991E+03_JPRB /)  
KB(:,54,16) = (/ &
 & 0.98836E+03_JPRB,0.98653E+03_JPRB,0.99856E+03_JPRB,0.99827E+03_JPRB,0.99962E+03_JPRB /)  
KB(:,55,16) = (/ &
 & 0.98643E+03_JPRB,0.98485E+03_JPRB,0.99716E+03_JPRB,0.10012E+04_JPRB,0.10067E+04_JPRB /)  
KB(:,56,16) = (/ &
 & 0.97714E+03_JPRB,0.99044E+03_JPRB,0.99567E+03_JPRB,0.99999E+03_JPRB,0.99885E+03_JPRB /)  
KB(:,57,16) = (/ &
 & 0.97511E+03_JPRB,0.98860E+03_JPRB,0.99409E+03_JPRB,0.99872E+03_JPRB,0.10058E+04_JPRB /)  
KB(:,58,16) = (/ &
 & 0.98036E+03_JPRB,0.98678E+03_JPRB,0.99251E+03_JPRB,0.99003E+03_JPRB,0.10052E+04_JPRB /)  
KB(:,59,16) = (/ &
 & 0.97953E+03_JPRB,0.98603E+03_JPRB,0.99185E+03_JPRB,0.99687E+03_JPRB,0.10009E+04_JPRB /)  
     
!     -----------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('SRTM_KGB27',1,ZHOOK_HANDLE)
END SUBROUTINE SRTM_KGB27

