!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif
!pgi$r opt=0 
SUBROUTINE RRTM_KGB16

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 16:  2600-3000 cm-1 (low - H2O,CH4; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOERRTO16, ONLY : KAO     ,SELFREFO   ,FRACREFAO
USE YOERRTA16, ONLY : STRRAT

!     ------------------------------------------------------------------

IMPLICIT NONE
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('RRTM_KGB16',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2
CALL PART3
CALL PART4
CALL PART5
CALL PART6
CALL PART7
CALL PART8
CALL PART9
CALL PART10
CALL PART11
CALL PART12

IF (LHOOK) CALL DR_HOOK('RRTM_KGB16',1,ZHOOK_HANDLE)

!     -----------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART1',0,ZHOOK_HANDLE)


STRRAT = 830.411_JPRB

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
 & 1.9384E-05_JPRB,2.9898E-05_JPRB,3.4062E-05_JPRB,3.6004E-05_JPRB,3.6430E-05_JPRB,3.5549E-05_JPRB,&
 & 3.3320E-05_JPRB,2.9615E-05_JPRB,2.3873E-05_JPRB/)  
KAO( :, 2, 1, 1) = (/&
 & 1.9436E-05_JPRB,2.9740E-05_JPRB,3.3708E-05_JPRB,3.5476E-05_JPRB,3.5843E-05_JPRB,3.5033E-05_JPRB,&
 & 3.2962E-05_JPRB,2.9462E-05_JPRB,2.4055E-05_JPRB/)  
KAO( :, 3, 1, 1) = (/&
 & 1.9464E-05_JPRB,2.9570E-05_JPRB,3.3324E-05_JPRB,3.4974E-05_JPRB,3.5304E-05_JPRB,3.4544E-05_JPRB,&
 & 3.2637E-05_JPRB,2.9289E-05_JPRB,2.4237E-05_JPRB/)  
KAO( :, 4, 1, 1) = (/&
 & 1.9302E-05_JPRB,2.9247E-05_JPRB,3.2832E-05_JPRB,3.4416E-05_JPRB,3.4737E-05_JPRB,3.4031E-05_JPRB,&
 & 3.2272E-05_JPRB,2.9080E-05_JPRB,2.4364E-05_JPRB/)  
KAO( :, 5, 1, 1) = (/&
 & 1.9123E-05_JPRB,2.8885E-05_JPRB,3.2360E-05_JPRB,3.3877E-05_JPRB,3.4211E-05_JPRB,3.3554E-05_JPRB,&
 & 3.1880E-05_JPRB,2.8883E-05_JPRB,2.4458E-05_JPRB/)  
KAO( :, 1, 2, 1) = (/&
 & 1.6583E-05_JPRB,2.6012E-05_JPRB,2.9608E-05_JPRB,3.1154E-05_JPRB,3.1427E-05_JPRB,3.0616E-05_JPRB,&
 & 2.8665E-05_JPRB,2.5368E-05_JPRB,2.0615E-05_JPRB/)  
KAO( :, 2, 2, 1) = (/&
 & 1.6630E-05_JPRB,2.5863E-05_JPRB,2.9249E-05_JPRB,3.0678E-05_JPRB,3.0941E-05_JPRB,3.0197E-05_JPRB,&
 & 2.8392E-05_JPRB,2.5270E-05_JPRB,2.0786E-05_JPRB/)  
KAO( :, 3, 2, 1) = (/&
 & 1.6647E-05_JPRB,2.5697E-05_JPRB,2.8891E-05_JPRB,3.0222E-05_JPRB,3.0484E-05_JPRB,2.9802E-05_JPRB,&
 & 2.8138E-05_JPRB,2.5165E-05_JPRB,2.0933E-05_JPRB/)  
KAO( :, 4, 2, 1) = (/&
 & 1.6540E-05_JPRB,2.5405E-05_JPRB,2.8466E-05_JPRB,2.9745E-05_JPRB,3.0011E-05_JPRB,2.9400E-05_JPRB,&
 & 2.7847E-05_JPRB,2.5027E-05_JPRB,2.1051E-05_JPRB/)  
KAO( :, 5, 2, 1) = (/&
 & 1.6324E-05_JPRB,2.5032E-05_JPRB,2.7991E-05_JPRB,2.9251E-05_JPRB,2.9530E-05_JPRB,2.8984E-05_JPRB,&
 & 2.7519E-05_JPRB,2.4864E-05_JPRB,2.1134E-05_JPRB/)  
KAO( :, 1, 3, 1) = (/&
 & 1.4086E-05_JPRB,2.2526E-05_JPRB,2.5577E-05_JPRB,2.6862E-05_JPRB,2.7021E-05_JPRB,2.6302E-05_JPRB,&
 & 2.4576E-05_JPRB,2.1643E-05_JPRB,1.8751E-05_JPRB/)  
KAO( :, 2, 3, 1) = (/&
 & 1.4131E-05_JPRB,2.2392E-05_JPRB,2.5264E-05_JPRB,2.6452E-05_JPRB,2.6617E-05_JPRB,2.5964E-05_JPRB,&
 & 2.4370E-05_JPRB,2.1595E-05_JPRB,1.8898E-05_JPRB/)  
KAO( :, 3, 3, 1) = (/&
 & 1.4113E-05_JPRB,2.2191E-05_JPRB,2.4900E-05_JPRB,2.6018E-05_JPRB,2.6215E-05_JPRB,2.5621E-05_JPRB,&
 & 2.4158E-05_JPRB,2.1540E-05_JPRB,1.9048E-05_JPRB/)  
KAO( :, 4, 3, 1) = (/&
 & 1.4058E-05_JPRB,2.1961E-05_JPRB,2.4548E-05_JPRB,2.5623E-05_JPRB,2.5838E-05_JPRB,2.5312E-05_JPRB,&
 & 2.3952E-05_JPRB,2.1469E-05_JPRB,1.9182E-05_JPRB/)  
KAO( :, 5, 3, 1) = (/&
 & 1.3863E-05_JPRB,2.1619E-05_JPRB,2.4113E-05_JPRB,2.5184E-05_JPRB,2.5419E-05_JPRB,2.4957E-05_JPRB,&
 & 2.3697E-05_JPRB,2.1357E-05_JPRB,1.9265E-05_JPRB/)  
KAO( :, 1, 4, 1) = (/&
 & 1.1900E-05_JPRB,1.9396E-05_JPRB,2.1993E-05_JPRB,2.3049E-05_JPRB,2.3163E-05_JPRB,2.2508E-05_JPRB,&
 & 2.0982E-05_JPRB,1.8407E-05_JPRB,1.7094E-05_JPRB/)  
KAO( :, 2, 4, 1) = (/&
 & 1.1936E-05_JPRB,1.9289E-05_JPRB,2.1740E-05_JPRB,2.2712E-05_JPRB,2.2827E-05_JPRB,2.2234E-05_JPRB,&
 & 2.0833E-05_JPRB,1.8390E-05_JPRB,1.7367E-05_JPRB/)  
KAO( :, 3, 4, 1) = (/&
 & 1.1914E-05_JPRB,1.9113E-05_JPRB,2.1420E-05_JPRB,2.2348E-05_JPRB,2.2488E-05_JPRB,2.1958E-05_JPRB,&
 & 2.0668E-05_JPRB,1.8368E-05_JPRB,1.7624E-05_JPRB/)  
KAO( :, 4, 4, 1) = (/&
 & 1.1850E-05_JPRB,1.8882E-05_JPRB,2.1069E-05_JPRB,2.1971E-05_JPRB,2.2145E-05_JPRB,2.1684E-05_JPRB,&
 & 2.0493E-05_JPRB,1.8332E-05_JPRB,1.7862E-05_JPRB/)  
KAO( :, 5, 4, 1) = (/&
 & 1.1744E-05_JPRB,1.8626E-05_JPRB,2.0733E-05_JPRB,2.1634E-05_JPRB,2.1819E-05_JPRB,2.1414E-05_JPRB,&
 & 2.0321E-05_JPRB,1.8279E-05_JPRB,1.8065E-05_JPRB/)  
KAO( :, 1, 5, 1) = (/&
 & 1.0007E-05_JPRB,1.6633E-05_JPRB,1.8846E-05_JPRB,1.9714E-05_JPRB,1.9792E-05_JPRB,1.9192E-05_JPRB,&
 & 1.7849E-05_JPRB,1.5620E-05_JPRB,1.4831E-05_JPRB/)  
KAO( :, 2, 5, 1) = (/&
 & 1.0036E-05_JPRB,1.6537E-05_JPRB,1.8619E-05_JPRB,1.9430E-05_JPRB,1.9510E-05_JPRB,1.8974E-05_JPRB,&
 & 1.7727E-05_JPRB,1.5597E-05_JPRB,1.5243E-05_JPRB/)  
KAO( :, 3, 5, 1) = (/&
 & 1.0020E-05_JPRB,1.6382E-05_JPRB,1.8357E-05_JPRB,1.9125E-05_JPRB,1.9225E-05_JPRB,1.8747E-05_JPRB,&
 & 1.7610E-05_JPRB,1.5596E-05_JPRB,1.5694E-05_JPRB/)  
KAO( :, 4, 5, 1) = (/&
 & 9.9655E-06_JPRB,1.6185E-05_JPRB,1.8047E-05_JPRB,1.8806E-05_JPRB,1.8930E-05_JPRB,1.8511E-05_JPRB,&
 & 1.7475E-05_JPRB,1.5592E-05_JPRB,1.6134E-05_JPRB/)  
KAO( :, 5, 5, 1) = (/&
 & 9.8924E-06_JPRB,1.5961E-05_JPRB,1.7750E-05_JPRB,1.8511E-05_JPRB,1.8653E-05_JPRB,1.8287E-05_JPRB,&
 & 1.7340E-05_JPRB,1.5571E-05_JPRB,1.6528E-05_JPRB/)  
KAO( :, 1, 6, 1) = (/&
 & 8.3773E-06_JPRB,1.4205E-05_JPRB,1.6091E-05_JPRB,1.6810E-05_JPRB,1.6854E-05_JPRB,1.6312E-05_JPRB,&
 & 1.5134E-05_JPRB,1.3227E-05_JPRB,1.2806E-05_JPRB/)  
KAO( :, 2, 6, 1) = (/&
 & 8.4040E-06_JPRB,1.4116E-05_JPRB,1.5890E-05_JPRB,1.6565E-05_JPRB,1.6618E-05_JPRB,1.6134E-05_JPRB,&
 & 1.5030E-05_JPRB,1.3175E-05_JPRB,1.3188E-05_JPRB/)  
KAO( :, 3, 6, 1) = (/&
 & 8.3967E-06_JPRB,1.3982E-05_JPRB,1.5670E-05_JPRB,1.6315E-05_JPRB,1.6378E-05_JPRB,1.5948E-05_JPRB,&
 & 1.4938E-05_JPRB,1.3181E-05_JPRB,1.3640E-05_JPRB/)  
KAO( :, 4, 6, 1) = (/&
 & 8.3520E-06_JPRB,1.3808E-05_JPRB,1.5410E-05_JPRB,1.6041E-05_JPRB,1.6129E-05_JPRB,1.5748E-05_JPRB,&
 & 1.4840E-05_JPRB,1.3187E-05_JPRB,1.4105E-05_JPRB/)  
KAO( :, 5, 6, 1) = (/&
 & 8.2808E-06_JPRB,1.3600E-05_JPRB,1.5125E-05_JPRB,1.5766E-05_JPRB,1.5873E-05_JPRB,1.5546E-05_JPRB,&
 & 1.4725E-05_JPRB,1.3184E-05_JPRB,1.4585E-05_JPRB/)  
KAO( :, 1, 7, 1) = (/&
 & 6.9702E-06_JPRB,1.2049E-05_JPRB,1.3655E-05_JPRB,1.4254E-05_JPRB,1.4272E-05_JPRB,1.3786E-05_JPRB,&
 & 1.2775E-05_JPRB,1.1193E-05_JPRB,1.1151E-05_JPRB/)  
KAO( :, 2, 7, 1) = (/&
 & 6.9954E-06_JPRB,1.1967E-05_JPRB,1.3478E-05_JPRB,1.4043E-05_JPRB,1.4073E-05_JPRB,1.3643E-05_JPRB,&
 & 1.2677E-05_JPRB,1.1085E-05_JPRB,1.1514E-05_JPRB/)  
KAO( :, 3, 7, 1) = (/&
 & 6.9926E-06_JPRB,1.1851E-05_JPRB,1.3284E-05_JPRB,1.3826E-05_JPRB,1.3871E-05_JPRB,1.3488E-05_JPRB,&
 & 1.2600E-05_JPRB,1.1081E-05_JPRB,1.1911E-05_JPRB/)  
KAO( :, 4, 7, 1) = (/&
 & 6.9597E-06_JPRB,1.1700E-05_JPRB,1.3068E-05_JPRB,1.3600E-05_JPRB,1.3659E-05_JPRB,1.3321E-05_JPRB,&
 & 1.2522E-05_JPRB,1.1091E-05_JPRB,1.2356E-05_JPRB/)  
KAO( :, 5, 7, 1) = (/&
 & 6.9051E-06_JPRB,1.1522E-05_JPRB,1.2825E-05_JPRB,1.3359E-05_JPRB,1.3444E-05_JPRB,1.3151E-05_JPRB,&
 & 1.2435E-05_JPRB,1.1100E-05_JPRB,1.2847E-05_JPRB/)  
KAO( :, 1, 8, 1) = (/&
 & 5.8087E-06_JPRB,1.0208E-05_JPRB,1.1579E-05_JPRB,1.2087E-05_JPRB,1.2081E-05_JPRB,1.1640E-05_JPRB,&
 & 1.0763E-05_JPRB,9.5182E-06_JPRB,9.7914E-06_JPRB/)  
KAO( :, 2, 8, 1) = (/&
 & 5.8314E-06_JPRB,1.0134E-05_JPRB,1.1429E-05_JPRB,1.1911E-05_JPRB,1.1918E-05_JPRB,1.1522E-05_JPRB,&
 & 1.0685E-05_JPRB,9.3144E-06_JPRB,1.0107E-05_JPRB/)  
KAO( :, 3, 8, 1) = (/&
 & 5.8306E-06_JPRB,1.0039E-05_JPRB,1.1263E-05_JPRB,1.1721E-05_JPRB,1.1741E-05_JPRB,1.1392E-05_JPRB,&
 & 1.0611E-05_JPRB,9.2970E-06_JPRB,1.0491E-05_JPRB/)  
KAO( :, 4, 8, 1) = (/&
 & 5.8084E-06_JPRB,9.9094E-06_JPRB,1.1082E-05_JPRB,1.1528E-05_JPRB,1.1564E-05_JPRB,1.1253E-05_JPRB,&
 & 1.0543E-05_JPRB,9.3028E-06_JPRB,1.0943E-05_JPRB/)  
KAO( :, 5, 8, 1) = (/&
 & 5.7671E-06_JPRB,9.7597E-06_JPRB,1.0878E-05_JPRB,1.1322E-05_JPRB,1.1380E-05_JPRB,1.1112E-05_JPRB,&
 & 1.0475E-05_JPRB,9.3153E-06_JPRB,1.1451E-05_JPRB/)  
KAO( :, 1, 9, 1) = (/&
 & 4.8301E-06_JPRB,8.6067E-06_JPRB,9.7714E-06_JPRB,1.0210E-05_JPRB,1.0192E-05_JPRB,9.7977E-06_JPRB,&
 & 9.0505E-06_JPRB,8.2004E-06_JPRB,9.1168E-06_JPRB/)  
KAO( :, 2, 9, 1) = (/&
 & 4.8495E-06_JPRB,8.5468E-06_JPRB,9.6571E-06_JPRB,1.0063E-05_JPRB,1.0051E-05_JPRB,9.6903E-06_JPRB,&
 & 8.9660E-06_JPRB,7.8251E-06_JPRB,9.4876E-06_JPRB/)  
KAO( :, 3, 9, 1) = (/&
 & 4.8497E-06_JPRB,8.4643E-06_JPRB,9.5144E-06_JPRB,9.9014E-06_JPRB,9.9028E-06_JPRB,9.5821E-06_JPRB,&
 & 8.9043E-06_JPRB,7.7718E-06_JPRB,9.9373E-06_JPRB/)  
KAO( :, 4, 9, 1) = (/&
 & 4.8347E-06_JPRB,8.3597E-06_JPRB,9.3601E-06_JPRB,9.7348E-06_JPRB,9.7523E-06_JPRB,9.4691E-06_JPRB,&
 & 8.8479E-06_JPRB,7.7751E-06_JPRB,1.0480E-05_JPRB/)  
KAO( :, 5, 9, 1) = (/&
 & 4.8060E-06_JPRB,8.2344E-06_JPRB,9.1913E-06_JPRB,9.5624E-06_JPRB,9.5965E-06_JPRB,9.3522E-06_JPRB,&
 & 8.7881E-06_JPRB,7.7833E-06_JPRB,1.1108E-05_JPRB/)  
KAO( :, 1,10, 1) = (/&
 & 4.0064E-06_JPRB,7.2194E-06_JPRB,8.1998E-06_JPRB,8.5791E-06_JPRB,8.5570E-06_JPRB,8.2127E-06_JPRB,&
 & 7.5956E-06_JPRB,7.1868E-06_JPRB,1.0453E-05_JPRB/)  
KAO( :, 2,10, 1) = (/&
 & 4.0197E-06_JPRB,7.1679E-06_JPRB,8.1105E-06_JPRB,8.4531E-06_JPRB,8.4331E-06_JPRB,8.1149E-06_JPRB,&
 & 7.4918E-06_JPRB,6.5776E-06_JPRB,1.0520E-05_JPRB/)  
KAO( :, 3,10, 1) = (/&
 & 4.0198E-06_JPRB,7.0974E-06_JPRB,7.9934E-06_JPRB,8.3195E-06_JPRB,8.3088E-06_JPRB,8.0216E-06_JPRB,&
 & 7.4367E-06_JPRB,6.4788E-06_JPRB,1.0711E-05_JPRB/)  
KAO( :, 4,10, 1) = (/&
 & 4.0097E-06_JPRB,7.0130E-06_JPRB,7.8610E-06_JPRB,8.1737E-06_JPRB,8.1778E-06_JPRB,7.9289E-06_JPRB,&
 & 7.3886E-06_JPRB,6.4723E-06_JPRB,1.1047E-05_JPRB/)  
KAO( :, 5,10, 1) = (/&
 & 3.9884E-06_JPRB,6.9092E-06_JPRB,7.7198E-06_JPRB,8.0283E-06_JPRB,8.0487E-06_JPRB,7.8282E-06_JPRB,&
 & 7.3394E-06_JPRB,6.4785E-06_JPRB,1.1524E-05_JPRB/)  
KAO( :, 1,11, 1) = (/&
 & 3.3235E-06_JPRB,6.0184E-06_JPRB,6.8284E-06_JPRB,7.1399E-06_JPRB,7.1176E-06_JPRB,6.8268E-06_JPRB,&
 & 6.3069E-06_JPRB,5.9015E-06_JPRB,1.0775E-05_JPRB/)  
KAO( :, 2,11, 1) = (/&
 & 3.3290E-06_JPRB,5.9691E-06_JPRB,6.7492E-06_JPRB,7.0301E-06_JPRB,7.0090E-06_JPRB,6.7423E-06_JPRB,&
 & 6.2217E-06_JPRB,5.4471E-06_JPRB,1.0671E-05_JPRB/)  
KAO( :, 3,11, 1) = (/&
 & 3.3251E-06_JPRB,5.9052E-06_JPRB,6.6470E-06_JPRB,6.9153E-06_JPRB,6.9027E-06_JPRB,6.6631E-06_JPRB,&
 & 6.1768E-06_JPRB,5.3794E-06_JPRB,1.0714E-05_JPRB/)  
KAO( :, 4,11, 1) = (/&
 & 3.3144E-06_JPRB,5.8297E-06_JPRB,6.5309E-06_JPRB,6.7910E-06_JPRB,6.7926E-06_JPRB,6.5831E-06_JPRB,&
 & 6.1358E-06_JPRB,5.3736E-06_JPRB,1.0902E-05_JPRB/)  
KAO( :, 5,11, 1) = (/&
 & 3.2953E-06_JPRB,5.7419E-06_JPRB,6.4131E-06_JPRB,6.6688E-06_JPRB,6.6812E-06_JPRB,6.4951E-06_JPRB,&
 & 6.0888E-06_JPRB,5.3759E-06_JPRB,1.1211E-05_JPRB/)  
KAO( :, 1,12, 1) = (/&
 & 2.7539E-06_JPRB,5.0055E-06_JPRB,5.6748E-06_JPRB,5.9323E-06_JPRB,5.9106E-06_JPRB,5.6659E-06_JPRB,&
 & 5.2301E-06_JPRB,4.8410E-06_JPRB,1.0041E-05_JPRB/)  
KAO( :, 2,12, 1) = (/&
 & 2.7540E-06_JPRB,4.9609E-06_JPRB,5.6055E-06_JPRB,5.8388E-06_JPRB,5.8173E-06_JPRB,5.5933E-06_JPRB,&
 & 5.1585E-06_JPRB,4.5035E-06_JPRB,9.8783E-06_JPRB/)  
KAO( :, 3,12, 1) = (/&
 & 2.7488E-06_JPRB,4.9048E-06_JPRB,5.5190E-06_JPRB,5.7407E-06_JPRB,5.7275E-06_JPRB,5.5257E-06_JPRB,&
 & 5.1201E-06_JPRB,4.4556E-06_JPRB,9.8584E-06_JPRB/)  
KAO( :, 4,12, 1) = (/&
 & 2.7385E-06_JPRB,4.8395E-06_JPRB,5.4207E-06_JPRB,5.6356E-06_JPRB,5.6337E-06_JPRB,5.4559E-06_JPRB,&
 & 5.0826E-06_JPRB,4.4482E-06_JPRB,9.9631E-06_JPRB/)  
KAO( :, 5,12, 1) = (/&
 & 2.7214E-06_JPRB,4.7654E-06_JPRB,5.3225E-06_JPRB,5.5318E-06_JPRB,5.5373E-06_JPRB,5.3782E-06_JPRB,&
 & 5.0386E-06_JPRB,4.4476E-06_JPRB,1.0178E-05_JPRB/)  
KAO( :, 1,13, 1) = (/&
 & 2.2801E-06_JPRB,4.1555E-06_JPRB,4.7093E-06_JPRB,4.9224E-06_JPRB,4.9034E-06_JPRB,4.6982E-06_JPRB,&
 & 4.3297E-06_JPRB,3.9733E-06_JPRB,8.4129E-06_JPRB/)  
KAO( :, 2,13, 1) = (/&
 & 2.2770E-06_JPRB,4.1173E-06_JPRB,4.6509E-06_JPRB,4.8443E-06_JPRB,4.8245E-06_JPRB,4.6351E-06_JPRB,&
 & 4.2708E-06_JPRB,3.7196E-06_JPRB,8.2708E-06_JPRB/)  
KAO( :, 3,13, 1) = (/&
 & 2.2712E-06_JPRB,4.0679E-06_JPRB,4.5774E-06_JPRB,4.7613E-06_JPRB,4.7480E-06_JPRB,4.5771E-06_JPRB,&
 & 4.2377E-06_JPRB,3.6828E-06_JPRB,8.2482E-06_JPRB/)  
KAO( :, 4,13, 1) = (/&
 & 2.2616E-06_JPRB,4.0128E-06_JPRB,4.4962E-06_JPRB,4.6740E-06_JPRB,4.6674E-06_JPRB,4.5144E-06_JPRB,&
 & 4.2021E-06_JPRB,3.6746E-06_JPRB,8.3289E-06_JPRB/)  
KAO( :, 5,13, 1) = (/&
 & 2.2466E-06_JPRB,3.9523E-06_JPRB,4.4147E-06_JPRB,4.5851E-06_JPRB,4.5844E-06_JPRB,4.4468E-06_JPRB,&
 & 4.1612E-06_JPRB,3.6696E-06_JPRB,8.4982E-06_JPRB/)  
KAO( :, 1, 1, 2) = (/&
 & 4.5009E-05_JPRB,5.8537E-05_JPRB,6.2677E-05_JPRB,6.4420E-05_JPRB,6.4899E-05_JPRB,6.4046E-05_JPRB,&
 & 6.1758E-05_JPRB,5.7308E-05_JPRB,4.4974E-05_JPRB/)  
KAO( :, 2, 1, 2) = (/&
 & 4.4639E-05_JPRB,5.7851E-05_JPRB,6.2018E-05_JPRB,6.3985E-05_JPRB,6.4709E-05_JPRB,6.3972E-05_JPRB,&
 & 6.1776E-05_JPRB,5.7584E-05_JPRB,4.6032E-05_JPRB/)  
KAO( :, 3, 1, 2) = (/&
 & 4.4183E-05_JPRB,5.7134E-05_JPRB,6.1429E-05_JPRB,6.3594E-05_JPRB,6.4467E-05_JPRB,6.3906E-05_JPRB,&
 & 6.1866E-05_JPRB,5.7909E-05_JPRB,4.7065E-05_JPRB/)  
KAO( :, 4, 1, 2) = (/&
 & 4.3603E-05_JPRB,5.6311E-05_JPRB,6.0747E-05_JPRB,6.3098E-05_JPRB,6.4110E-05_JPRB,6.3723E-05_JPRB,&
 & 6.1859E-05_JPRB,5.8107E-05_JPRB,4.8038E-05_JPRB/)  
KAO( :, 5, 1, 2) = (/&
 & 4.3016E-05_JPRB,5.5575E-05_JPRB,6.0089E-05_JPRB,6.2604E-05_JPRB,6.3758E-05_JPRB,6.3526E-05_JPRB,&
 & 6.1825E-05_JPRB,5.8256E-05_JPRB,4.8937E-05_JPRB/)  
KAO( :, 1, 2, 2) = (/&
 & 3.8991E-05_JPRB,5.1237E-05_JPRB,5.5073E-05_JPRB,5.6912E-05_JPRB,5.7291E-05_JPRB,5.6357E-05_JPRB,&
 & 5.4136E-05_JPRB,4.9871E-05_JPRB,3.8345E-05_JPRB/)  
KAO( :, 2, 2, 2) = (/&
 & 3.8628E-05_JPRB,5.0611E-05_JPRB,5.4618E-05_JPRB,5.6670E-05_JPRB,5.7177E-05_JPRB,5.6367E-05_JPRB,&
 & 5.4237E-05_JPRB,5.0203E-05_JPRB,3.9241E-05_JPRB/)  
KAO( :, 3, 2, 2) = (/&
 & 3.8218E-05_JPRB,5.0047E-05_JPRB,5.4219E-05_JPRB,5.6458E-05_JPRB,5.7088E-05_JPRB,5.6414E-05_JPRB,&
 & 5.4375E-05_JPRB,5.0554E-05_JPRB,4.0182E-05_JPRB/)  
KAO( :, 4, 2, 2) = (/&
 & 3.7696E-05_JPRB,4.9413E-05_JPRB,5.3740E-05_JPRB,5.6131E-05_JPRB,5.6939E-05_JPRB,5.6393E-05_JPRB,&
 & 5.4506E-05_JPRB,5.0827E-05_JPRB,4.1063E-05_JPRB/)  
KAO( :, 5, 2, 2) = (/&
 & 3.7087E-05_JPRB,4.8772E-05_JPRB,5.3212E-05_JPRB,5.5737E-05_JPRB,5.6714E-05_JPRB,5.6323E-05_JPRB,&
 & 5.4580E-05_JPRB,5.1064E-05_JPRB,4.1833E-05_JPRB/)  
KAO( :, 1, 3, 2) = (/&
 & 3.3664E-05_JPRB,4.4718E-05_JPRB,4.8316E-05_JPRB,5.0054E-05_JPRB,5.0316E-05_JPRB,4.9337E-05_JPRB,&
 & 4.7131E-05_JPRB,4.3067E-05_JPRB,3.3821E-05_JPRB/)  
KAO( :, 2, 3, 2) = (/&
 & 3.3332E-05_JPRB,4.4193E-05_JPRB,4.7982E-05_JPRB,4.9921E-05_JPRB,5.0286E-05_JPRB,4.9400E-05_JPRB,&
 & 4.7278E-05_JPRB,4.3395E-05_JPRB,3.4508E-05_JPRB/)  
KAO( :, 3, 3, 2) = (/&
 & 3.2912E-05_JPRB,4.3709E-05_JPRB,4.7689E-05_JPRB,4.9796E-05_JPRB,5.0261E-05_JPRB,4.9490E-05_JPRB,&
 & 4.7455E-05_JPRB,4.3769E-05_JPRB,3.5275E-05_JPRB/)  
KAO( :, 4, 3, 2) = (/&
 & 3.2477E-05_JPRB,4.3262E-05_JPRB,4.7404E-05_JPRB,4.9658E-05_JPRB,5.0286E-05_JPRB,4.9612E-05_JPRB,&
 & 4.7676E-05_JPRB,4.4119E-05_JPRB,3.6032E-05_JPRB/)  
KAO( :, 5, 3, 2) = (/&
 & 3.1897E-05_JPRB,4.2732E-05_JPRB,4.7020E-05_JPRB,4.9397E-05_JPRB,5.0209E-05_JPRB,4.9662E-05_JPRB,&
 & 4.7863E-05_JPRB,4.4408E-05_JPRB,3.6739E-05_JPRB/)  
KAO( :, 1, 4, 2) = (/&
 & 2.9034E-05_JPRB,3.9020E-05_JPRB,4.2255E-05_JPRB,4.3779E-05_JPRB,4.3941E-05_JPRB,4.2940E-05_JPRB,&
 & 4.0749E-05_JPRB,3.6991E-05_JPRB,3.2231E-05_JPRB/)  
KAO( :, 2, 4, 2) = (/&
 & 2.8733E-05_JPRB,3.8566E-05_JPRB,4.1993E-05_JPRB,4.3688E-05_JPRB,4.3978E-05_JPRB,4.3065E-05_JPRB,&
 & 4.0955E-05_JPRB,3.7298E-05_JPRB,3.2530E-05_JPRB/)  
KAO( :, 3, 4, 2) = (/&
 & 2.8365E-05_JPRB,3.8166E-05_JPRB,4.1800E-05_JPRB,4.3640E-05_JPRB,4.4034E-05_JPRB,4.3186E-05_JPRB,&
 & 4.1171E-05_JPRB,3.7663E-05_JPRB,3.3003E-05_JPRB/)  
KAO( :, 4, 4, 2) = (/&
 & 2.7906E-05_JPRB,3.7772E-05_JPRB,4.1598E-05_JPRB,4.3582E-05_JPRB,4.4101E-05_JPRB,4.3335E-05_JPRB,&
 & 4.1429E-05_JPRB,3.8018E-05_JPRB,3.3543E-05_JPRB/)  
KAO( :, 5, 4, 2) = (/&
 & 2.7464E-05_JPRB,3.7412E-05_JPRB,4.1395E-05_JPRB,4.3505E-05_JPRB,4.4180E-05_JPRB,4.3547E-05_JPRB,&
 & 4.1708E-05_JPRB,3.8366E-05_JPRB,3.4090E-05_JPRB/)  
KAO( :, 1, 5, 2) = (/&
 & 2.5046E-05_JPRB,3.4030E-05_JPRB,3.6841E-05_JPRB,3.8123E-05_JPRB,3.8161E-05_JPRB,3.7165E-05_JPRB,&
 & 3.5069E-05_JPRB,3.1597E-05_JPRB,3.1884E-05_JPRB/)  
KAO( :, 2, 5, 2) = (/&
 & 2.4766E-05_JPRB,3.3630E-05_JPRB,3.6644E-05_JPRB,3.8042E-05_JPRB,3.8206E-05_JPRB,3.7320E-05_JPRB,&
 & 3.5335E-05_JPRB,3.1911E-05_JPRB,3.2055E-05_JPRB/)  
KAO( :, 3, 5, 2) = (/&
 & 2.4433E-05_JPRB,3.3294E-05_JPRB,3.6479E-05_JPRB,3.8027E-05_JPRB,3.8311E-05_JPRB,3.7468E-05_JPRB,&
 & 3.5564E-05_JPRB,3.2236E-05_JPRB,3.2305E-05_JPRB/)  
KAO( :, 4, 5, 2) = (/&
 & 2.4018E-05_JPRB,3.2959E-05_JPRB,3.6349E-05_JPRB,3.8027E-05_JPRB,3.8418E-05_JPRB,3.7650E-05_JPRB,&
 & 3.5828E-05_JPRB,3.2583E-05_JPRB,3.2642E-05_JPRB/)  
KAO( :, 5, 5, 2) = (/&
 & 2.3591E-05_JPRB,3.2668E-05_JPRB,3.6232E-05_JPRB,3.8051E-05_JPRB,3.8551E-05_JPRB,3.7905E-05_JPRB,&
 & 3.6128E-05_JPRB,3.2939E-05_JPRB,3.3008E-05_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART2',0,ZHOOK_HANDLE)


KAO( :, 1, 6, 2) = (/&
 & 2.1579E-05_JPRB,2.9591E-05_JPRB,3.1991E-05_JPRB,3.3013E-05_JPRB,3.2936E-05_JPRB,3.1944E-05_JPRB,&
 & 3.0025E-05_JPRB,2.6876E-05_JPRB,2.9999E-05_JPRB/)  
KAO( :, 2, 6, 2) = (/&
 & 2.1317E-05_JPRB,2.9255E-05_JPRB,3.1830E-05_JPRB,3.2965E-05_JPRB,3.2983E-05_JPRB,3.2102E-05_JPRB,&
 & 3.0272E-05_JPRB,2.7170E-05_JPRB,3.0568E-05_JPRB/)  
KAO( :, 3, 6, 2) = (/&
 & 2.1011E-05_JPRB,2.8952E-05_JPRB,3.1684E-05_JPRB,3.2945E-05_JPRB,3.3093E-05_JPRB,3.2263E-05_JPRB,&
 & 3.0533E-05_JPRB,2.7474E-05_JPRB,3.1151E-05_JPRB/)  
KAO( :, 4, 6, 2) = (/&
 & 2.0627E-05_JPRB,2.8670E-05_JPRB,3.1569E-05_JPRB,3.2960E-05_JPRB,3.3217E-05_JPRB,3.2461E-05_JPRB,&
 & 3.0780E-05_JPRB,2.7789E-05_JPRB,3.1790E-05_JPRB/)  
KAO( :, 5, 6, 2) = (/&
 & 2.0182E-05_JPRB,2.8368E-05_JPRB,3.1449E-05_JPRB,3.2969E-05_JPRB,3.3342E-05_JPRB,3.2673E-05_JPRB,&
 & 3.1052E-05_JPRB,2.8119E-05_JPRB,3.2386E-05_JPRB/)  
KAO( :, 1, 7, 2) = (/&
 & 1.8452E-05_JPRB,2.5532E-05_JPRB,2.7551E-05_JPRB,2.8351E-05_JPRB,2.8204E-05_JPRB,2.7262E-05_JPRB,&
 & 2.5546E-05_JPRB,2.2740E-05_JPRB,2.8091E-05_JPRB/)  
KAO( :, 2, 7, 2) = (/&
 & 1.8215E-05_JPRB,2.5256E-05_JPRB,2.7416E-05_JPRB,2.8318E-05_JPRB,2.8249E-05_JPRB,2.7395E-05_JPRB,&
 & 2.5765E-05_JPRB,2.3002E-05_JPRB,2.8720E-05_JPRB/)  
KAO( :, 3, 7, 2) = (/&
 & 1.7931E-05_JPRB,2.4972E-05_JPRB,2.7294E-05_JPRB,2.8314E-05_JPRB,2.8348E-05_JPRB,2.7572E-05_JPRB,&
 & 2.6008E-05_JPRB,2.3291E-05_JPRB,2.9431E-05_JPRB/)  
KAO( :, 4, 7, 2) = (/&
 & 1.7583E-05_JPRB,2.4714E-05_JPRB,2.7183E-05_JPRB,2.8322E-05_JPRB,2.8484E-05_JPRB,2.7765E-05_JPRB,&
 & 2.6265E-05_JPRB,2.3586E-05_JPRB,3.0235E-05_JPRB/)  
KAO( :, 5, 7, 2) = (/&
 & 1.7179E-05_JPRB,2.4453E-05_JPRB,2.7076E-05_JPRB,2.8339E-05_JPRB,2.8609E-05_JPRB,2.7972E-05_JPRB,&
 & 2.6510E-05_JPRB,2.3882E-05_JPRB,3.1083E-05_JPRB/)  
KAO( :, 1, 8, 2) = (/&
 & 1.5794E-05_JPRB,2.2020E-05_JPRB,2.3670E-05_JPRB,2.4259E-05_JPRB,2.4056E-05_JPRB,2.3178E-05_JPRB,&
 & 2.1635E-05_JPRB,1.9134E-05_JPRB,2.7582E-05_JPRB/)  
KAO( :, 2, 8, 2) = (/&
 & 1.5579E-05_JPRB,2.1775E-05_JPRB,2.3546E-05_JPRB,2.4231E-05_JPRB,2.4092E-05_JPRB,2.3297E-05_JPRB,&
 & 2.1816E-05_JPRB,1.9397E-05_JPRB,2.8313E-05_JPRB/)  
KAO( :, 3, 8, 2) = (/&
 & 1.5328E-05_JPRB,2.1517E-05_JPRB,2.3429E-05_JPRB,2.4220E-05_JPRB,2.4175E-05_JPRB,2.3443E-05_JPRB,&
 & 2.2039E-05_JPRB,1.9642E-05_JPRB,2.9205E-05_JPRB/)  
KAO( :, 4, 8, 2) = (/&
 & 1.5023E-05_JPRB,2.1268E-05_JPRB,2.3319E-05_JPRB,2.4225E-05_JPRB,2.4291E-05_JPRB,2.3637E-05_JPRB,&
 & 2.2285E-05_JPRB,1.9922E-05_JPRB,3.0174E-05_JPRB/)  
KAO( :, 5, 8, 2) = (/&
 & 1.4668E-05_JPRB,2.1020E-05_JPRB,2.3208E-05_JPRB,2.4227E-05_JPRB,2.4407E-05_JPRB,2.3824E-05_JPRB,&
 & 2.2528E-05_JPRB,2.0191E-05_JPRB,3.1226E-05_JPRB/)  
KAO( :, 1, 9, 2) = (/&
 & 1.3453E-05_JPRB,1.8874E-05_JPRB,2.0200E-05_JPRB,2.0614E-05_JPRB,2.0394E-05_JPRB,1.9585E-05_JPRB,&
 & 1.8218E-05_JPRB,1.5952E-05_JPRB,3.1081E-05_JPRB/)  
KAO( :, 2, 9, 2) = (/&
 & 1.3262E-05_JPRB,1.8651E-05_JPRB,2.0085E-05_JPRB,2.0598E-05_JPRB,2.0424E-05_JPRB,1.9696E-05_JPRB,&
 & 1.8380E-05_JPRB,1.6281E-05_JPRB,3.2467E-05_JPRB/)  
KAO( :, 3, 9, 2) = (/&
 & 1.3038E-05_JPRB,1.8418E-05_JPRB,1.9972E-05_JPRB,2.0581E-05_JPRB,2.0487E-05_JPRB,1.9824E-05_JPRB,&
 & 1.8572E-05_JPRB,1.6491E-05_JPRB,3.3986E-05_JPRB/)  
KAO( :, 4, 9, 2) = (/&
 & 1.2776E-05_JPRB,1.8181E-05_JPRB,1.9859E-05_JPRB,2.0572E-05_JPRB,2.0585E-05_JPRB,1.9985E-05_JPRB,&
 & 1.8794E-05_JPRB,1.6733E-05_JPRB,3.5607E-05_JPRB/)  
KAO( :, 5, 9, 2) = (/&
 & 1.2471E-05_JPRB,1.7952E-05_JPRB,1.9753E-05_JPRB,2.0569E-05_JPRB,2.0679E-05_JPRB,2.0158E-05_JPRB,&
 & 1.9021E-05_JPRB,1.6980E-05_JPRB,3.7340E-05_JPRB/)  
KAO( :, 1,10, 2) = (/&
 & 1.1374E-05_JPRB,1.6047E-05_JPRB,1.7111E-05_JPRB,1.7393E-05_JPRB,1.7165E-05_JPRB,1.6451E-05_JPRB,&
 & 1.5255E-05_JPRB,1.3140E-05_JPRB,3.4787E-05_JPRB/)  
KAO( :, 2,10, 2) = (/&
 & 1.1208E-05_JPRB,1.5847E-05_JPRB,1.6997E-05_JPRB,1.7386E-05_JPRB,1.7209E-05_JPRB,1.6555E-05_JPRB,&
 & 1.5407E-05_JPRB,1.3598E-05_JPRB,3.7476E-05_JPRB/)  
KAO( :, 3,10, 2) = (/&
 & 1.1010E-05_JPRB,1.5634E-05_JPRB,1.6890E-05_JPRB,1.7366E-05_JPRB,1.7258E-05_JPRB,1.6670E-05_JPRB,&
 & 1.5570E-05_JPRB,1.3793E-05_JPRB,4.0426E-05_JPRB/)  
KAO( :, 4,10, 2) = (/&
 & 1.0782E-05_JPRB,1.5423E-05_JPRB,1.6783E-05_JPRB,1.7341E-05_JPRB,1.7331E-05_JPRB,1.6806E-05_JPRB,&
 & 1.5764E-05_JPRB,1.4000E-05_JPRB,4.3679E-05_JPRB/)  
KAO( :, 5,10, 2) = (/&
 & 1.0524E-05_JPRB,1.5209E-05_JPRB,1.6680E-05_JPRB,1.7333E-05_JPRB,1.7403E-05_JPRB,1.6952E-05_JPRB,&
 & 1.5975E-05_JPRB,1.4224E-05_JPRB,4.7059E-05_JPRB/)  
KAO( :, 1,11, 2) = (/&
 & 9.5209E-06_JPRB,1.3499E-05_JPRB,1.4375E-05_JPRB,1.4600E-05_JPRB,1.4393E-05_JPRB,1.3793E-05_JPRB,&
 & 1.2781E-05_JPRB,1.1038E-05_JPRB,3.2865E-05_JPRB/)  
KAO( :, 2,11, 2) = (/&
 & 9.3637E-06_JPRB,1.3313E-05_JPRB,1.4267E-05_JPRB,1.4592E-05_JPRB,1.4440E-05_JPRB,1.3889E-05_JPRB,&
 & 1.2920E-05_JPRB,1.1404E-05_JPRB,3.5445E-05_JPRB/)  
KAO( :, 3,11, 2) = (/&
 & 9.1833E-06_JPRB,1.3123E-05_JPRB,1.4166E-05_JPRB,1.4568E-05_JPRB,1.4482E-05_JPRB,1.3996E-05_JPRB,&
 & 1.3070E-05_JPRB,1.1568E-05_JPRB,3.8218E-05_JPRB/)  
KAO( :, 4,11, 2) = (/&
 & 8.9761E-06_JPRB,1.2932E-05_JPRB,1.4072E-05_JPRB,1.4544E-05_JPRB,1.4541E-05_JPRB,1.4107E-05_JPRB,&
 & 1.3243E-05_JPRB,1.1758E-05_JPRB,4.1117E-05_JPRB/)  
KAO( :, 5,11, 2) = (/&
 & 8.7519E-06_JPRB,1.2738E-05_JPRB,1.3974E-05_JPRB,1.4523E-05_JPRB,1.4594E-05_JPRB,1.4232E-05_JPRB,&
 & 1.3426E-05_JPRB,1.1955E-05_JPRB,4.4210E-05_JPRB/)  
KAO( :, 1,12, 2) = (/&
 & 7.9463E-06_JPRB,1.1314E-05_JPRB,1.2032E-05_JPRB,1.2211E-05_JPRB,1.2025E-05_JPRB,1.1526E-05_JPRB,&
 & 1.0676E-05_JPRB,9.2413E-06_JPRB,2.9106E-05_JPRB/)  
KAO( :, 2,12, 2) = (/&
 & 7.8042E-06_JPRB,1.1141E-05_JPRB,1.1931E-05_JPRB,1.2198E-05_JPRB,1.2069E-05_JPRB,1.1610E-05_JPRB,&
 & 1.0799E-05_JPRB,9.5264E-06_JPRB,3.1349E-05_JPRB/)  
KAO( :, 3,12, 2) = (/&
 & 7.6428E-06_JPRB,1.0975E-05_JPRB,1.1841E-05_JPRB,1.2172E-05_JPRB,1.2102E-05_JPRB,1.1694E-05_JPRB,&
 & 1.0928E-05_JPRB,9.6721E-06_JPRB,3.3866E-05_JPRB/)  
KAO( :, 4,12, 2) = (/&
 & 7.4623E-06_JPRB,1.0806E-05_JPRB,1.1756E-05_JPRB,1.2145E-05_JPRB,1.2145E-05_JPRB,1.1788E-05_JPRB,&
 & 1.1076E-05_JPRB,9.8394E-06_JPRB,3.6457E-05_JPRB/)  
KAO( :, 5,12, 2) = (/&
 & 7.2711E-06_JPRB,1.0633E-05_JPRB,1.1656E-05_JPRB,1.2115E-05_JPRB,1.2181E-05_JPRB,1.1891E-05_JPRB,&
 & 1.1228E-05_JPRB,1.0010E-05_JPRB,3.9156E-05_JPRB/)  
KAO( :, 1,13, 2) = (/&
 & 6.6184E-06_JPRB,9.4565E-06_JPRB,1.0043E-05_JPRB,1.0182E-05_JPRB,1.0021E-05_JPRB,9.6035E-06_JPRB,&
 & 8.8893E-06_JPRB,7.7053E-06_JPRB,2.4435E-05_JPRB/)  
KAO( :, 2,13, 2) = (/&
 & 6.4936E-06_JPRB,9.3020E-06_JPRB,9.9506E-06_JPRB,1.0164E-05_JPRB,1.0053E-05_JPRB,9.6688E-06_JPRB,&
 & 8.9931E-06_JPRB,7.9311E-06_JPRB,2.6318E-05_JPRB/)  
KAO( :, 3,13, 2) = (/&
 & 6.3517E-06_JPRB,9.1558E-06_JPRB,9.8692E-06_JPRB,1.0135E-05_JPRB,1.0076E-05_JPRB,9.7347E-06_JPRB,&
 & 9.1027E-06_JPRB,8.0612E-06_JPRB,2.8419E-05_JPRB/)  
KAO( :, 4,13, 2) = (/&
 & 6.1987E-06_JPRB,9.0085E-06_JPRB,9.7873E-06_JPRB,1.0106E-05_JPRB,1.0104E-05_JPRB,9.8108E-06_JPRB,&
 & 9.2254E-06_JPRB,8.2025E-06_JPRB,3.0596E-05_JPRB/)  
KAO( :, 5,13, 2) = (/&
 & 6.0390E-06_JPRB,8.8585E-06_JPRB,9.6966E-06_JPRB,1.0071E-05_JPRB,1.0127E-05_JPRB,9.8907E-06_JPRB,&
 & 9.3441E-06_JPRB,8.3431E-06_JPRB,3.2866E-05_JPRB/)  
KAO( :, 1, 1, 3) = (/&
 & 7.0753E-05_JPRB,8.7371E-05_JPRB,9.5172E-05_JPRB,9.9390E-05_JPRB,1.0056E-04_JPRB,9.9494E-05_JPRB,&
 & 9.5837E-05_JPRB,8.9326E-05_JPRB,7.4323E-05_JPRB/)  
KAO( :, 2, 1, 3) = (/&
 & 6.9795E-05_JPRB,8.7509E-05_JPRB,9.5691E-05_JPRB,9.9950E-05_JPRB,1.0125E-04_JPRB,1.0041E-04_JPRB,&
 & 9.7011E-05_JPRB,9.0609E-05_JPRB,7.5641E-05_JPRB/)  
KAO( :, 3, 1, 3) = (/&
 & 6.9131E-05_JPRB,8.7916E-05_JPRB,9.6468E-05_JPRB,1.0076E-04_JPRB,1.0214E-04_JPRB,1.0141E-04_JPRB,&
 & 9.8247E-05_JPRB,9.2085E-05_JPRB,7.7357E-05_JPRB/)  
KAO( :, 4, 1, 3) = (/&
 & 6.8482E-05_JPRB,8.8338E-05_JPRB,9.7157E-05_JPRB,1.0153E-04_JPRB,1.0307E-04_JPRB,1.0249E-04_JPRB,&
 & 9.9530E-05_JPRB,9.3696E-05_JPRB,7.9379E-05_JPRB/)  
KAO( :, 5, 1, 3) = (/&
 & 6.7880E-05_JPRB,8.8892E-05_JPRB,9.7857E-05_JPRB,1.0242E-04_JPRB,1.0411E-04_JPRB,1.0366E-04_JPRB,&
 & 1.0077E-04_JPRB,9.5333E-05_JPRB,8.1423E-05_JPRB/)  
KAO( :, 1, 2, 3) = (/&
 & 6.2276E-05_JPRB,7.8469E-05_JPRB,8.5472E-05_JPRB,8.8868E-05_JPRB,8.9888E-05_JPRB,8.8903E-05_JPRB,&
 & 8.5409E-05_JPRB,7.9146E-05_JPRB,6.4309E-05_JPRB/)  
KAO( :, 2, 2, 3) = (/&
 & 6.1522E-05_JPRB,7.8775E-05_JPRB,8.6027E-05_JPRB,8.9487E-05_JPRB,9.0686E-05_JPRB,8.9927E-05_JPRB,&
 & 8.6540E-05_JPRB,8.0293E-05_JPRB,6.5447E-05_JPRB/)  
KAO( :, 3, 2, 3) = (/&
 & 6.1045E-05_JPRB,7.9281E-05_JPRB,8.6793E-05_JPRB,9.0368E-05_JPRB,9.1669E-05_JPRB,9.0966E-05_JPRB,&
 & 8.7713E-05_JPRB,8.1579E-05_JPRB,6.6858E-05_JPRB/)  
KAO( :, 4, 2, 3) = (/&
 & 6.0651E-05_JPRB,7.9924E-05_JPRB,8.7586E-05_JPRB,9.1281E-05_JPRB,9.2660E-05_JPRB,9.2033E-05_JPRB,&
 & 8.8973E-05_JPRB,8.3100E-05_JPRB,6.8552E-05_JPRB/)  
KAO( :, 5, 2, 3) = (/&
 & 6.0196E-05_JPRB,8.0517E-05_JPRB,8.8362E-05_JPRB,9.2181E-05_JPRB,9.3655E-05_JPRB,9.3124E-05_JPRB,&
 & 9.0231E-05_JPRB,8.4620E-05_JPRB,7.0321E-05_JPRB/)  
KAO( :, 1, 3, 3) = (/&
 & 5.4594E-05_JPRB,7.0140E-05_JPRB,7.6291E-05_JPRB,7.9103E-05_JPRB,7.9908E-05_JPRB,7.8825E-05_JPRB,&
 & 7.5557E-05_JPRB,6.9638E-05_JPRB,5.6129E-05_JPRB/)  
KAO( :, 2, 3, 3) = (/&
 & 5.3987E-05_JPRB,7.0481E-05_JPRB,7.6809E-05_JPRB,7.9722E-05_JPRB,8.0799E-05_JPRB,7.9847E-05_JPRB,&
 & 7.6636E-05_JPRB,7.0746E-05_JPRB,5.7083E-05_JPRB/)  
KAO( :, 3, 3, 3) = (/&
 & 5.3598E-05_JPRB,7.0935E-05_JPRB,7.7478E-05_JPRB,8.0559E-05_JPRB,8.1742E-05_JPRB,8.0926E-05_JPRB,&
 & 7.7718E-05_JPRB,7.1792E-05_JPRB,5.8231E-05_JPRB/)  
KAO( :, 4, 3, 3) = (/&
 & 5.3419E-05_JPRB,7.1650E-05_JPRB,7.8342E-05_JPRB,8.1570E-05_JPRB,8.2791E-05_JPRB,8.1991E-05_JPRB,&
 & 7.8849E-05_JPRB,7.3062E-05_JPRB,5.9633E-05_JPRB/)  
KAO( :, 5, 3, 3) = (/&
 & 5.3129E-05_JPRB,7.2273E-05_JPRB,7.9178E-05_JPRB,8.2486E-05_JPRB,8.3759E-05_JPRB,8.3022E-05_JPRB,&
 & 8.0014E-05_JPRB,7.4467E-05_JPRB,6.1152E-05_JPRB/)  
KAO( :, 1, 4, 3) = (/&
 & 4.7696E-05_JPRB,6.2286E-05_JPRB,6.7749E-05_JPRB,7.0181E-05_JPRB,7.0624E-05_JPRB,6.9456E-05_JPRB,&
 & 6.6381E-05_JPRB,6.0701E-05_JPRB,5.1576E-05_JPRB/)  
KAO( :, 2, 4, 3) = (/&
 & 4.7208E-05_JPRB,6.2637E-05_JPRB,6.8240E-05_JPRB,7.0849E-05_JPRB,7.1530E-05_JPRB,7.0423E-05_JPRB,&
 & 6.7425E-05_JPRB,6.1760E-05_JPRB,5.2349E-05_JPRB/)  
KAO( :, 3, 4, 3) = (/&
 & 4.6920E-05_JPRB,6.3058E-05_JPRB,6.8836E-05_JPRB,7.1607E-05_JPRB,7.2463E-05_JPRB,7.1509E-05_JPRB,&
 & 6.8509E-05_JPRB,6.2750E-05_JPRB,5.3224E-05_JPRB/)  
KAO( :, 4, 4, 3) = (/&
 & 4.6776E-05_JPRB,6.3606E-05_JPRB,6.9601E-05_JPRB,7.2517E-05_JPRB,7.3446E-05_JPRB,7.2570E-05_JPRB,&
 & 6.9521E-05_JPRB,6.3786E-05_JPRB,5.4286E-05_JPRB/)  
KAO( :, 5, 4, 3) = (/&
 & 4.6682E-05_JPRB,6.4343E-05_JPRB,7.0568E-05_JPRB,7.3573E-05_JPRB,7.4545E-05_JPRB,7.3619E-05_JPRB,&
 & 7.0604E-05_JPRB,6.5003E-05_JPRB,5.5521E-05_JPRB/)  
KAO( :, 1, 5, 3) = (/&
 & 4.1581E-05_JPRB,5.4899E-05_JPRB,5.9799E-05_JPRB,6.1832E-05_JPRB,6.2136E-05_JPRB,6.0898E-05_JPRB,&
 & 5.7964E-05_JPRB,5.2516E-05_JPRB,5.0115E-05_JPRB/)  
KAO( :, 2, 5, 3) = (/&
 & 4.1165E-05_JPRB,5.5257E-05_JPRB,6.0251E-05_JPRB,6.2555E-05_JPRB,6.3007E-05_JPRB,6.1795E-05_JPRB,&
 & 5.8864E-05_JPRB,5.3500E-05_JPRB,5.0524E-05_JPRB/)  
KAO( :, 3, 5, 3) = (/&
 & 4.0905E-05_JPRB,5.5656E-05_JPRB,6.0839E-05_JPRB,6.3322E-05_JPRB,6.3891E-05_JPRB,6.2840E-05_JPRB,&
 & 5.9887E-05_JPRB,5.4446E-05_JPRB,5.1001E-05_JPRB/)  
KAO( :, 4, 5, 3) = (/&
 & 4.0790E-05_JPRB,5.6129E-05_JPRB,6.1526E-05_JPRB,6.4146E-05_JPRB,6.4873E-05_JPRB,6.3880E-05_JPRB,&
 & 6.0934E-05_JPRB,5.5421E-05_JPRB,5.1576E-05_JPRB/)  
KAO( :, 5, 5, 3) = (/&
 & 4.0741E-05_JPRB,5.6811E-05_JPRB,6.2419E-05_JPRB,6.5146E-05_JPRB,6.5947E-05_JPRB,6.4915E-05_JPRB,&
 & 6.1966E-05_JPRB,5.6459E-05_JPRB,5.2345E-05_JPRB/)  
KAO( :, 1, 6, 3) = (/&
 & 3.6128E-05_JPRB,4.8074E-05_JPRB,5.2303E-05_JPRB,5.4088E-05_JPRB,5.4305E-05_JPRB,5.3072E-05_JPRB,&
 & 5.0232E-05_JPRB,4.5105E-05_JPRB,5.1680E-05_JPRB/)  
KAO( :, 2, 6, 3) = (/&
 & 3.5776E-05_JPRB,4.8378E-05_JPRB,5.2790E-05_JPRB,5.4763E-05_JPRB,5.5146E-05_JPRB,5.3920E-05_JPRB,&
 & 5.1041E-05_JPRB,4.6023E-05_JPRB,5.1519E-05_JPRB/)  
KAO( :, 3, 6, 3) = (/&
 & 3.5527E-05_JPRB,4.8788E-05_JPRB,5.3350E-05_JPRB,5.5505E-05_JPRB,5.5990E-05_JPRB,5.4859E-05_JPRB,&
 & 5.1952E-05_JPRB,4.6910E-05_JPRB,5.1451E-05_JPRB/)  
KAO( :, 4, 6, 3) = (/&
 & 3.5393E-05_JPRB,4.9227E-05_JPRB,5.4029E-05_JPRB,5.6316E-05_JPRB,5.6902E-05_JPRB,5.5852E-05_JPRB,&
 & 5.2950E-05_JPRB,4.7839E-05_JPRB,5.1463E-05_JPRB/)  
KAO( :, 5, 6, 3) = (/&
 & 3.5279E-05_JPRB,4.9738E-05_JPRB,5.4773E-05_JPRB,5.7200E-05_JPRB,5.7864E-05_JPRB,5.6831E-05_JPRB,&
 & 5.3962E-05_JPRB,4.8775E-05_JPRB,5.1664E-05_JPRB/)  
KAO( :, 1, 7, 3) = (/&
 & 3.1175E-05_JPRB,4.1797E-05_JPRB,4.5353E-05_JPRB,4.6878E-05_JPRB,4.7045E-05_JPRB,4.5914E-05_JPRB,&
 & 4.3260E-05_JPRB,3.8528E-05_JPRB,5.5034E-05_JPRB/)  
KAO( :, 2, 7, 3) = (/&
 & 3.0861E-05_JPRB,4.2063E-05_JPRB,4.5864E-05_JPRB,4.7535E-05_JPRB,4.7827E-05_JPRB,4.6677E-05_JPRB,&
 & 4.3974E-05_JPRB,3.9350E-05_JPRB,5.5182E-05_JPRB/)  
KAO( :, 3, 7, 3) = (/&
 & 3.0632E-05_JPRB,4.2441E-05_JPRB,4.6427E-05_JPRB,4.8241E-05_JPRB,4.8620E-05_JPRB,4.7526E-05_JPRB,&
 & 4.4793E-05_JPRB,4.0140E-05_JPRB,5.5398E-05_JPRB/)  
KAO( :, 4, 7, 3) = (/&
 & 3.0475E-05_JPRB,4.2876E-05_JPRB,4.7039E-05_JPRB,4.9018E-05_JPRB,4.9446E-05_JPRB,4.8432E-05_JPRB,&
 & 4.5701E-05_JPRB,4.0986E-05_JPRB,5.5585E-05_JPRB/)  
KAO( :, 5, 7, 3) = (/&
 & 3.0340E-05_JPRB,4.3333E-05_JPRB,4.7753E-05_JPRB,4.9874E-05_JPRB,5.0366E-05_JPRB,4.9368E-05_JPRB,&
 & 4.6641E-05_JPRB,4.1870E-05_JPRB,5.5728E-05_JPRB/)  
KAO( :, 1, 8, 3) = (/&
 & 2.6882E-05_JPRB,3.6181E-05_JPRB,3.9159E-05_JPRB,4.0385E-05_JPRB,4.0472E-05_JPRB,3.9467E-05_JPRB,&
 & 3.7068E-05_JPRB,3.2787E-05_JPRB,6.0191E-05_JPRB/)  
KAO( :, 2, 8, 3) = (/&
 & 2.6577E-05_JPRB,3.6420E-05_JPRB,3.9630E-05_JPRB,4.1005E-05_JPRB,4.1190E-05_JPRB,4.0154E-05_JPRB,&
 & 3.7711E-05_JPRB,3.3501E-05_JPRB,6.0976E-05_JPRB/)  
KAO( :, 3, 8, 3) = (/&
 & 2.6344E-05_JPRB,3.6733E-05_JPRB,4.0183E-05_JPRB,4.1714E-05_JPRB,4.1930E-05_JPRB,4.0908E-05_JPRB,&
 & 3.8425E-05_JPRB,3.4195E-05_JPRB,6.1747E-05_JPRB/)  
KAO( :, 4, 8, 3) = (/&
 & 2.6154E-05_JPRB,3.7129E-05_JPRB,4.0772E-05_JPRB,4.2424E-05_JPRB,4.2698E-05_JPRB,4.1708E-05_JPRB,&
 & 3.9208E-05_JPRB,3.4923E-05_JPRB,6.2436E-05_JPRB/)  
KAO( :, 5, 8, 3) = (/&
 & 2.5969E-05_JPRB,3.7541E-05_JPRB,4.1396E-05_JPRB,4.3205E-05_JPRB,4.3544E-05_JPRB,4.2561E-05_JPRB,&
 & 4.0066E-05_JPRB,3.5716E-05_JPRB,6.2996E-05_JPRB/)  
KAO( :, 1, 9, 3) = (/&
 & 2.3030E-05_JPRB,3.1081E-05_JPRB,3.3574E-05_JPRB,3.4578E-05_JPRB,3.4594E-05_JPRB,3.3680E-05_JPRB,&
 & 3.1564E-05_JPRB,2.7753E-05_JPRB,8.2972E-05_JPRB/)  
KAO( :, 2, 9, 3) = (/&
 & 2.2745E-05_JPRB,3.1301E-05_JPRB,3.4001E-05_JPRB,3.5099E-05_JPRB,3.5210E-05_JPRB,3.4293E-05_JPRB,&
 & 3.2147E-05_JPRB,2.8418E-05_JPRB,8.5573E-05_JPRB/)  
KAO( :, 3, 9, 3) = (/&
 & 2.2504E-05_JPRB,3.1575E-05_JPRB,3.4507E-05_JPRB,3.5759E-05_JPRB,3.5892E-05_JPRB,3.4957E-05_JPRB,&
 & 3.2777E-05_JPRB,2.9021E-05_JPRB,8.7692E-05_JPRB/)  
KAO( :, 4, 9, 3) = (/&
 & 2.2288E-05_JPRB,3.1903E-05_JPRB,3.5055E-05_JPRB,3.6460E-05_JPRB,3.6616E-05_JPRB,3.5667E-05_JPRB,&
 & 3.3440E-05_JPRB,2.9641E-05_JPRB,8.9596E-05_JPRB/)  
KAO( :, 5, 9, 3) = (/&
 & 2.2076E-05_JPRB,3.2254E-05_JPRB,3.5612E-05_JPRB,3.7158E-05_JPRB,3.7379E-05_JPRB,3.6426E-05_JPRB,&
 & 3.4185E-05_JPRB,3.0329E-05_JPRB,9.1172E-05_JPRB/)  
KAO( :, 1,10, 3) = (/&
 & 1.9573E-05_JPRB,2.6501E-05_JPRB,2.8604E-05_JPRB,2.9434E-05_JPRB,2.9415E-05_JPRB,2.8586E-05_JPRB,&
 & 2.6756E-05_JPRB,2.3398E-05_JPRB,1.1831E-04_JPRB/)  
KAO( :, 2,10, 3) = (/&
 & 1.9311E-05_JPRB,2.6696E-05_JPRB,2.8987E-05_JPRB,2.9871E-05_JPRB,2.9930E-05_JPRB,2.9131E-05_JPRB,&
 & 2.7291E-05_JPRB,2.4061E-05_JPRB,1.2413E-04_JPRB/)  
KAO( :, 3,10, 3) = (/&
 & 1.9064E-05_JPRB,2.6931E-05_JPRB,2.9433E-05_JPRB,3.0442E-05_JPRB,3.0524E-05_JPRB,2.9723E-05_JPRB,&
 & 2.7830E-05_JPRB,2.4575E-05_JPRB,1.2968E-04_JPRB/)  
KAO( :, 4,10, 3) = (/&
 & 1.8838E-05_JPRB,2.7200E-05_JPRB,2.9911E-05_JPRB,3.1092E-05_JPRB,3.1189E-05_JPRB,3.0347E-05_JPRB,&
 & 2.8402E-05_JPRB,2.5111E-05_JPRB,1.3500E-04_JPRB/)  
KAO( :, 5,10, 3) = (/&
 & 1.8619E-05_JPRB,2.7473E-05_JPRB,3.0391E-05_JPRB,3.1737E-05_JPRB,3.1883E-05_JPRB,3.1020E-05_JPRB,&
 & 2.9042E-05_JPRB,2.5702E-05_JPRB,1.4050E-04_JPRB/)  
KAO( :, 1,11, 3) = (/&
 & 1.6456E-05_JPRB,2.2515E-05_JPRB,2.4353E-05_JPRB,2.5062E-05_JPRB,2.5054E-05_JPRB,2.4348E-05_JPRB,&
 & 2.2780E-05_JPRB,1.9929E-05_JPRB,1.2447E-04_JPRB/)  
KAO( :, 2,11, 3) = (/&
 & 1.6210E-05_JPRB,2.2705E-05_JPRB,2.4709E-05_JPRB,2.5473E-05_JPRB,2.5515E-05_JPRB,2.4826E-05_JPRB,&
 & 2.3259E-05_JPRB,2.0482E-05_JPRB,1.3150E-04_JPRB/)  
KAO( :, 3,11, 3) = (/&
 & 1.5971E-05_JPRB,2.2902E-05_JPRB,2.5095E-05_JPRB,2.5990E-05_JPRB,2.6068E-05_JPRB,2.5361E-05_JPRB,&
 & 2.3741E-05_JPRB,2.0933E-05_JPRB,1.3833E-04_JPRB/)  
KAO( :, 4,11, 3) = (/&
 & 1.5752E-05_JPRB,2.3106E-05_JPRB,2.5493E-05_JPRB,2.6568E-05_JPRB,2.6674E-05_JPRB,2.5935E-05_JPRB,&
 & 2.4259E-05_JPRB,2.1401E-05_JPRB,1.4470E-04_JPRB/)  
KAO( :, 5,11, 3) = (/&
 & 1.5528E-05_JPRB,2.3318E-05_JPRB,2.5901E-05_JPRB,2.7141E-05_JPRB,2.7302E-05_JPRB,2.6558E-05_JPRB,&
 & 2.4843E-05_JPRB,2.1914E-05_JPRB,1.5074E-04_JPRB/)  
KAO( :, 1,12, 3) = (/&
 & 1.3780E-05_JPRB,1.9033E-05_JPRB,2.0619E-05_JPRB,2.1228E-05_JPRB,2.1226E-05_JPRB,2.0621E-05_JPRB,&
 & 1.9294E-05_JPRB,1.6882E-05_JPRB,1.1649E-04_JPRB/)  
KAO( :, 2,12, 3) = (/&
 & 1.3548E-05_JPRB,1.9199E-05_JPRB,2.0913E-05_JPRB,2.1600E-05_JPRB,2.1645E-05_JPRB,2.1053E-05_JPRB,&
 & 1.9719E-05_JPRB,1.7352E-05_JPRB,1.2368E-04_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


SUBROUTINE PART3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART3',0,ZHOOK_HANDLE)


KAO( :, 3,12, 3) = (/&
 & 1.3324E-05_JPRB,1.9341E-05_JPRB,2.1240E-05_JPRB,2.2050E-05_JPRB,2.2132E-05_JPRB,2.1536E-05_JPRB,&
 & 2.0156E-05_JPRB,1.7750E-05_JPRB,1.3017E-04_JPRB/)  
KAO( :, 4,12, 3) = (/&
 & 1.3111E-05_JPRB,1.9487E-05_JPRB,2.1558E-05_JPRB,2.2533E-05_JPRB,2.2665E-05_JPRB,2.2056E-05_JPRB,&
 & 2.0628E-05_JPRB,1.8158E-05_JPRB,1.3659E-04_JPRB/)  
KAO( :, 5,12, 3) = (/&
 & 1.2895E-05_JPRB,1.9642E-05_JPRB,2.1889E-05_JPRB,2.3011E-05_JPRB,2.3210E-05_JPRB,2.2606E-05_JPRB,&
 & 2.1150E-05_JPRB,1.8610E-05_JPRB,1.4251E-04_JPRB/)  
KAO( :, 1,13, 3) = (/&
 & 1.1500E-05_JPRB,1.6003E-05_JPRB,1.7357E-05_JPRB,1.7889E-05_JPRB,1.7884E-05_JPRB,1.7367E-05_JPRB,&
 & 1.6254E-05_JPRB,1.4227E-05_JPRB,9.8757E-05_JPRB/)  
KAO( :, 2,13, 3) = (/&
 & 1.1286E-05_JPRB,1.6126E-05_JPRB,1.7594E-05_JPRB,1.8210E-05_JPRB,1.8252E-05_JPRB,1.7751E-05_JPRB,&
 & 1.6632E-05_JPRB,1.4641E-05_JPRB,1.0488E-04_JPRB/)  
KAO( :, 3,13, 3) = (/&
 & 1.1079E-05_JPRB,1.6225E-05_JPRB,1.7843E-05_JPRB,1.8579E-05_JPRB,1.8672E-05_JPRB,1.8176E-05_JPRB,&
 & 1.7024E-05_JPRB,1.4980E-05_JPRB,1.1036E-04_JPRB/)  
KAO( :, 4,13, 3) = (/&
 & 1.0876E-05_JPRB,1.6327E-05_JPRB,1.8099E-05_JPRB,1.8965E-05_JPRB,1.9122E-05_JPRB,1.8629E-05_JPRB,&
 & 1.7445E-05_JPRB,1.5339E-05_JPRB,1.1580E-04_JPRB/)  
KAO( :, 5,13, 3) = (/&
 & 1.0678E-05_JPRB,1.6434E-05_JPRB,1.8360E-05_JPRB,1.9355E-05_JPRB,1.9573E-05_JPRB,1.9100E-05_JPRB,&
 & 1.7895E-05_JPRB,1.5734E-05_JPRB,1.2071E-04_JPRB/)  
KAO( :, 1, 1, 4) = (/&
 & 1.0452E-04_JPRB,1.3483E-04_JPRB,1.4507E-04_JPRB,1.5035E-04_JPRB,1.5233E-04_JPRB,1.5098E-04_JPRB,&
 & 1.4623E-04_JPRB,1.3688E-04_JPRB,1.1596E-04_JPRB/)  
KAO( :, 2, 1, 4) = (/&
 & 1.0431E-04_JPRB,1.3598E-04_JPRB,1.4693E-04_JPRB,1.5285E-04_JPRB,1.5505E-04_JPRB,1.5376E-04_JPRB,&
 & 1.4899E-04_JPRB,1.4010E-04_JPRB,1.1898E-04_JPRB/)  
KAO( :, 3, 1, 4) = (/&
 & 1.0452E-04_JPRB,1.3748E-04_JPRB,1.4911E-04_JPRB,1.5568E-04_JPRB,1.5820E-04_JPRB,1.5701E-04_JPRB,&
 & 1.5204E-04_JPRB,1.4309E-04_JPRB,1.2195E-04_JPRB/)  
KAO( :, 4, 1, 4) = (/&
 & 1.0446E-04_JPRB,1.3898E-04_JPRB,1.5142E-04_JPRB,1.5876E-04_JPRB,1.6160E-04_JPRB,1.6033E-04_JPRB,&
 & 1.5519E-04_JPRB,1.4614E-04_JPRB,1.2504E-04_JPRB/)  
KAO( :, 5, 1, 4) = (/&
 & 1.0490E-04_JPRB,1.4072E-04_JPRB,1.5426E-04_JPRB,1.6221E-04_JPRB,1.6521E-04_JPRB,1.6398E-04_JPRB,&
 & 1.5900E-04_JPRB,1.4986E-04_JPRB,1.2878E-04_JPRB/)  
KAO( :, 1, 2, 4) = (/&
 & 9.4204E-05_JPRB,1.2226E-04_JPRB,1.3172E-04_JPRB,1.3677E-04_JPRB,1.3845E-04_JPRB,1.3676E-04_JPRB,&
 & 1.3184E-04_JPRB,1.2295E-04_JPRB,1.0190E-04_JPRB/)  
KAO( :, 2, 2, 4) = (/&
 & 9.4074E-05_JPRB,1.2351E-04_JPRB,1.3361E-04_JPRB,1.3908E-04_JPRB,1.4094E-04_JPRB,1.3921E-04_JPRB,&
 & 1.3441E-04_JPRB,1.2595E-04_JPRB,1.0466E-04_JPRB/)  
KAO( :, 3, 2, 4) = (/&
 & 9.4344E-05_JPRB,1.2509E-04_JPRB,1.3579E-04_JPRB,1.4166E-04_JPRB,1.4376E-04_JPRB,1.4219E-04_JPRB,&
 & 1.3731E-04_JPRB,1.2889E-04_JPRB,1.0736E-04_JPRB/)  
KAO( :, 4, 2, 4) = (/&
 & 9.4551E-05_JPRB,1.2662E-04_JPRB,1.3810E-04_JPRB,1.4452E-04_JPRB,1.4685E-04_JPRB,1.4532E-04_JPRB,&
 & 1.4026E-04_JPRB,1.3156E-04_JPRB,1.1005E-04_JPRB/)  
KAO( :, 5, 2, 4) = (/&
 & 9.4911E-05_JPRB,1.2828E-04_JPRB,1.4068E-04_JPRB,1.4753E-04_JPRB,1.5017E-04_JPRB,1.4865E-04_JPRB,&
 & 1.4353E-04_JPRB,1.3462E-04_JPRB,1.1332E-04_JPRB/)  
KAO( :, 1, 3, 4) = (/&
 & 8.4477E-05_JPRB,1.0977E-04_JPRB,1.1875E-04_JPRB,1.2346E-04_JPRB,1.2481E-04_JPRB,1.2312E-04_JPRB,&
 & 1.1833E-04_JPRB,1.0957E-04_JPRB,8.9535E-05_JPRB/)  
KAO( :, 2, 3, 4) = (/&
 & 8.4379E-05_JPRB,1.1105E-04_JPRB,1.2059E-04_JPRB,1.2560E-04_JPRB,1.2700E-04_JPRB,1.2527E-04_JPRB,&
 & 1.2063E-04_JPRB,1.1208E-04_JPRB,9.1925E-05_JPRB/)  
KAO( :, 3, 3, 4) = (/&
 & 8.4459E-05_JPRB,1.1263E-04_JPRB,1.2255E-04_JPRB,1.2789E-04_JPRB,1.2949E-04_JPRB,1.2788E-04_JPRB,&
 & 1.2327E-04_JPRB,1.1489E-04_JPRB,9.4307E-05_JPRB/)  
KAO( :, 4, 3, 4) = (/&
 & 8.4957E-05_JPRB,1.1436E-04_JPRB,1.2477E-04_JPRB,1.3051E-04_JPRB,1.3225E-04_JPRB,1.3075E-04_JPRB,&
 & 1.2605E-04_JPRB,1.1763E-04_JPRB,9.6664E-05_JPRB/)  
KAO( :, 5, 3, 4) = (/&
 & 8.5267E-05_JPRB,1.1603E-04_JPRB,1.2711E-04_JPRB,1.3323E-04_JPRB,1.3522E-04_JPRB,1.3376E-04_JPRB,&
 & 1.2892E-04_JPRB,1.2027E-04_JPRB,9.9423E-05_JPRB/)  
KAO( :, 1, 4, 4) = (/&
 & 7.5106E-05_JPRB,9.8023E-05_JPRB,1.0634E-04_JPRB,1.1074E-04_JPRB,1.1207E-04_JPRB,1.1047E-04_JPRB,&
 & 1.0566E-04_JPRB,9.7179E-05_JPRB,8.0970E-05_JPRB/)  
KAO( :, 2, 4, 4) = (/&
 & 7.5068E-05_JPRB,9.9316E-05_JPRB,1.0818E-04_JPRB,1.1273E-04_JPRB,1.1400E-04_JPRB,1.1240E-04_JPRB,&
 & 1.0763E-04_JPRB,9.9160E-05_JPRB,8.2847E-05_JPRB/)  
KAO( :, 3, 4, 4) = (/&
 & 7.5176E-05_JPRB,1.0088E-04_JPRB,1.1012E-04_JPRB,1.1492E-04_JPRB,1.1630E-04_JPRB,1.1469E-04_JPRB,&
 & 1.0990E-04_JPRB,1.0156E-04_JPRB,8.4919E-05_JPRB/)  
KAO( :, 4, 4, 4) = (/&
 & 7.5441E-05_JPRB,1.0260E-04_JPRB,1.1218E-04_JPRB,1.1722E-04_JPRB,1.1877E-04_JPRB,1.1722E-04_JPRB,&
 & 1.1247E-04_JPRB,1.0418E-04_JPRB,8.7047E-05_JPRB/)  
KAO( :, 5, 4, 4) = (/&
 & 7.6234E-05_JPRB,1.0451E-04_JPRB,1.1445E-04_JPRB,1.1978E-04_JPRB,1.2144E-04_JPRB,1.1995E-04_JPRB,&
 & 1.1523E-04_JPRB,1.0678E-04_JPRB,8.9379E-05_JPRB/)  
KAO( :, 1, 5, 4) = (/&
 & 6.6160E-05_JPRB,8.7240E-05_JPRB,9.4827E-05_JPRB,9.8971E-05_JPRB,1.0023E-04_JPRB,9.8598E-05_JPRB,&
 & 9.3977E-05_JPRB,8.6015E-05_JPRB,7.7683E-05_JPRB/)  
KAO( :, 2, 5, 4) = (/&
 & 6.6183E-05_JPRB,8.8517E-05_JPRB,9.6624E-05_JPRB,1.0080E-04_JPRB,1.0196E-04_JPRB,1.0036E-04_JPRB,&
 & 9.5737E-05_JPRB,8.7609E-05_JPRB,7.8892E-05_JPRB/)  
KAO( :, 3, 5, 4) = (/&
 & 6.6375E-05_JPRB,9.0052E-05_JPRB,9.8476E-05_JPRB,1.0284E-04_JPRB,1.0408E-04_JPRB,1.0241E-04_JPRB,&
 & 9.7689E-05_JPRB,8.9585E-05_JPRB,8.0494E-05_JPRB/)  
KAO( :, 4, 5, 4) = (/&
 & 6.6706E-05_JPRB,9.1731E-05_JPRB,1.0049E-04_JPRB,1.0501E-04_JPRB,1.0639E-04_JPRB,1.0469E-04_JPRB,&
 & 9.9852E-05_JPRB,9.1849E-05_JPRB,8.2317E-05_JPRB/)  
KAO( :, 5, 5, 4) = (/&
 & 6.7530E-05_JPRB,9.3541E-05_JPRB,1.0261E-04_JPRB,1.0728E-04_JPRB,1.0881E-04_JPRB,1.0721E-04_JPRB,&
 & 1.0236E-04_JPRB,9.4247E-05_JPRB,8.4311E-05_JPRB/)  
KAO( :, 1, 6, 4) = (/&
 & 5.7820E-05_JPRB,7.7124E-05_JPRB,8.4195E-05_JPRB,8.7927E-05_JPRB,8.8972E-05_JPRB,8.7430E-05_JPRB,&
 & 8.3132E-05_JPRB,7.5650E-05_JPRB,7.8327E-05_JPRB/)  
KAO( :, 2, 6, 4) = (/&
 & 5.7858E-05_JPRB,7.8413E-05_JPRB,8.5775E-05_JPRB,8.9605E-05_JPRB,9.0590E-05_JPRB,8.9122E-05_JPRB,&
 & 8.4773E-05_JPRB,7.7051E-05_JPRB,7.8482E-05_JPRB/)  
KAO( :, 3, 6, 4) = (/&
 & 5.8124E-05_JPRB,7.9824E-05_JPRB,8.7576E-05_JPRB,9.1549E-05_JPRB,9.2483E-05_JPRB,9.0882E-05_JPRB,&
 & 8.6480E-05_JPRB,7.8637E-05_JPRB,7.9105E-05_JPRB/)  
KAO( :, 4, 6, 4) = (/&
 & 5.8563E-05_JPRB,8.1362E-05_JPRB,8.9405E-05_JPRB,9.3593E-05_JPRB,9.4634E-05_JPRB,9.2868E-05_JPRB,&
 & 8.8337E-05_JPRB,8.0467E-05_JPRB,8.0117E-05_JPRB/)  
KAO( :, 5, 6, 4) = (/&
 & 5.9163E-05_JPRB,8.2947E-05_JPRB,9.1328E-05_JPRB,9.5614E-05_JPRB,9.6868E-05_JPRB,9.5118E-05_JPRB,&
 & 9.0461E-05_JPRB,8.2517E-05_JPRB,8.1395E-05_JPRB/)  
KAO( :, 1, 7, 4) = (/&
 & 5.0089E-05_JPRB,6.7496E-05_JPRB,7.4227E-05_JPRB,7.7520E-05_JPRB,7.8410E-05_JPRB,7.6863E-05_JPRB,&
 & 7.2879E-05_JPRB,6.5963E-05_JPRB,8.6270E-05_JPRB/)  
KAO( :, 2, 7, 4) = (/&
 & 5.0200E-05_JPRB,6.8721E-05_JPRB,7.5605E-05_JPRB,7.9011E-05_JPRB,7.9876E-05_JPRB,7.8434E-05_JPRB,&
 & 7.4469E-05_JPRB,6.7323E-05_JPRB,8.5543E-05_JPRB/)  
KAO( :, 3, 7, 4) = (/&
 & 5.0465E-05_JPRB,7.0073E-05_JPRB,7.7198E-05_JPRB,8.0725E-05_JPRB,8.1573E-05_JPRB,8.0081E-05_JPRB,&
 & 7.6049E-05_JPRB,6.8699E-05_JPRB,8.4940E-05_JPRB/)  
KAO( :, 4, 7, 4) = (/&
 & 5.0935E-05_JPRB,7.1437E-05_JPRB,7.8942E-05_JPRB,8.2653E-05_JPRB,8.3546E-05_JPRB,8.1849E-05_JPRB,&
 & 7.7644E-05_JPRB,7.0190E-05_JPRB,8.4597E-05_JPRB/)  
KAO( :, 5, 7, 4) = (/&
 & 5.1558E-05_JPRB,7.2909E-05_JPRB,8.0657E-05_JPRB,8.4558E-05_JPRB,8.5533E-05_JPRB,8.3860E-05_JPRB,&
 & 7.9445E-05_JPRB,7.1873E-05_JPRB,8.4633E-05_JPRB/)  
KAO( :, 1, 8, 4) = (/&
 & 4.3241E-05_JPRB,5.8715E-05_JPRB,6.4907E-05_JPRB,6.7818E-05_JPRB,6.8520E-05_JPRB,6.7059E-05_JPRB,&
 & 6.3436E-05_JPRB,5.7025E-05_JPRB,1.0556E-04_JPRB/)  
KAO( :, 2, 8, 4) = (/&
 & 4.3396E-05_JPRB,5.9829E-05_JPRB,6.6154E-05_JPRB,6.9172E-05_JPRB,6.9903E-05_JPRB,6.8506E-05_JPRB,&
 & 6.4888E-05_JPRB,5.8346E-05_JPRB,1.0621E-04_JPRB/)  
KAO( :, 3, 8, 4) = (/&
 & 4.3671E-05_JPRB,6.1116E-05_JPRB,6.7537E-05_JPRB,7.0639E-05_JPRB,7.1418E-05_JPRB,7.0005E-05_JPRB,&
 & 6.6322E-05_JPRB,5.9628E-05_JPRB,1.0623E-04_JPRB/)  
KAO( :, 4, 8, 4) = (/&
 & 4.4098E-05_JPRB,6.2393E-05_JPRB,6.9085E-05_JPRB,7.2351E-05_JPRB,7.3148E-05_JPRB,7.1679E-05_JPRB,&
 & 6.7759E-05_JPRB,6.0926E-05_JPRB,1.0598E-04_JPRB/)  
KAO( :, 5, 8, 4) = (/&
 & 4.4692E-05_JPRB,6.3732E-05_JPRB,7.0698E-05_JPRB,7.4137E-05_JPRB,7.4984E-05_JPRB,7.3462E-05_JPRB,&
 & 6.9302E-05_JPRB,6.2346E-05_JPRB,1.0567E-04_JPRB/)  
KAO( :, 1, 9, 4) = (/&
 & 3.7132E-05_JPRB,5.0817E-05_JPRB,5.6256E-05_JPRB,5.8754E-05_JPRB,5.9255E-05_JPRB,5.8002E-05_JPRB,&
 & 5.4741E-05_JPRB,4.8907E-05_JPRB,1.5932E-04_JPRB/)  
KAO( :, 2, 9, 4) = (/&
 & 3.7275E-05_JPRB,5.1787E-05_JPRB,5.7392E-05_JPRB,6.0022E-05_JPRB,6.0595E-05_JPRB,5.9356E-05_JPRB,&
 & 5.6080E-05_JPRB,5.0176E-05_JPRB,1.6074E-04_JPRB/)  
KAO( :, 3, 9, 4) = (/&
 & 3.7562E-05_JPRB,5.2932E-05_JPRB,5.8629E-05_JPRB,6.1314E-05_JPRB,6.1975E-05_JPRB,6.0718E-05_JPRB,&
 & 5.7380E-05_JPRB,5.1383E-05_JPRB,1.6208E-04_JPRB/)  
KAO( :, 4, 9, 4) = (/&
 & 3.7959E-05_JPRB,5.4161E-05_JPRB,5.9989E-05_JPRB,6.2778E-05_JPRB,6.3464E-05_JPRB,6.2208E-05_JPRB,&
 & 5.8730E-05_JPRB,5.2572E-05_JPRB,1.6367E-04_JPRB/)  
KAO( :, 5, 9, 4) = (/&
 & 3.8474E-05_JPRB,5.5413E-05_JPRB,6.1478E-05_JPRB,6.4374E-05_JPRB,6.5107E-05_JPRB,6.3821E-05_JPRB,&
 & 6.0122E-05_JPRB,5.3780E-05_JPRB,1.6576E-04_JPRB/)  
KAO( :, 1,10, 4) = (/&
 & 3.1661E-05_JPRB,4.3721E-05_JPRB,4.8375E-05_JPRB,5.0533E-05_JPRB,5.0884E-05_JPRB,4.9757E-05_JPRB,&
 & 4.6933E-05_JPRB,4.1760E-05_JPRB,3.3288E-04_JPRB/)  
KAO( :, 2,10, 4) = (/&
 & 3.1799E-05_JPRB,4.4567E-05_JPRB,4.9444E-05_JPRB,5.1711E-05_JPRB,5.2132E-05_JPRB,5.1037E-05_JPRB,&
 & 4.8202E-05_JPRB,4.2932E-05_JPRB,3.3259E-04_JPRB/)  
KAO( :, 3,10, 4) = (/&
 & 3.2076E-05_JPRB,4.5598E-05_JPRB,5.0572E-05_JPRB,5.2901E-05_JPRB,5.3401E-05_JPRB,5.2274E-05_JPRB,&
 & 4.9410E-05_JPRB,4.4046E-05_JPRB,3.3116E-04_JPRB/)  
KAO( :, 4,10, 4) = (/&
 & 3.2432E-05_JPRB,4.6745E-05_JPRB,5.1822E-05_JPRB,5.4161E-05_JPRB,5.4721E-05_JPRB,5.3605E-05_JPRB,&
 & 5.0657E-05_JPRB,4.5130E-05_JPRB,3.2908E-04_JPRB/)  
KAO( :, 5,10, 4) = (/&
 & 3.2849E-05_JPRB,4.7929E-05_JPRB,5.3191E-05_JPRB,5.5555E-05_JPRB,5.6151E-05_JPRB,5.5034E-05_JPRB,&
 & 5.1913E-05_JPRB,4.6196E-05_JPRB,3.2646E-04_JPRB/)  
KAO( :, 1,11, 4) = (/&
 & 2.6856E-05_JPRB,3.7683E-05_JPRB,4.1693E-05_JPRB,4.3606E-05_JPRB,4.3883E-05_JPRB,4.2891E-05_JPRB,&
 & 4.0459E-05_JPRB,3.5912E-05_JPRB,4.0077E-04_JPRB/)  
KAO( :, 2,11, 4) = (/&
 & 2.7039E-05_JPRB,3.8497E-05_JPRB,4.2726E-05_JPRB,4.4727E-05_JPRB,4.5037E-05_JPRB,4.4055E-05_JPRB,&
 & 4.1621E-05_JPRB,3.6978E-05_JPRB,3.9949E-04_JPRB/)  
KAO( :, 3,11, 4) = (/&
 & 2.7307E-05_JPRB,3.9484E-05_JPRB,4.3818E-05_JPRB,4.5808E-05_JPRB,4.6194E-05_JPRB,4.5211E-05_JPRB,&
 & 4.2730E-05_JPRB,3.7986E-05_JPRB,3.9696E-04_JPRB/)  
KAO( :, 4,11, 4) = (/&
 & 2.7612E-05_JPRB,4.0551E-05_JPRB,4.5021E-05_JPRB,4.6980E-05_JPRB,4.7421E-05_JPRB,4.6420E-05_JPRB,&
 & 4.3860E-05_JPRB,3.8943E-05_JPRB,3.9400E-04_JPRB/)  
KAO( :, 5,11, 4) = (/&
 & 2.7944E-05_JPRB,4.1639E-05_JPRB,4.6278E-05_JPRB,4.8247E-05_JPRB,4.8726E-05_JPRB,4.7717E-05_JPRB,&
 & 4.5010E-05_JPRB,3.9912E-05_JPRB,3.9021E-04_JPRB/)  
KAO( :, 1,12, 4) = (/&
 & 2.2674E-05_JPRB,3.2256E-05_JPRB,3.5706E-05_JPRB,3.7375E-05_JPRB,3.7620E-05_JPRB,3.6748E-05_JPRB,&
 & 3.4672E-05_JPRB,3.0753E-05_JPRB,3.9801E-04_JPRB/)  
KAO( :, 2,12, 4) = (/&
 & 2.2856E-05_JPRB,3.3035E-05_JPRB,3.6681E-05_JPRB,3.8389E-05_JPRB,3.8658E-05_JPRB,3.7799E-05_JPRB,&
 & 3.5709E-05_JPRB,3.1711E-05_JPRB,3.9549E-04_JPRB/)  
KAO( :, 3,12, 4) = (/&
 & 2.3070E-05_JPRB,3.3949E-05_JPRB,3.7724E-05_JPRB,3.9400E-05_JPRB,3.9718E-05_JPRB,3.8860E-05_JPRB,&
 & 3.6712E-05_JPRB,3.2588E-05_JPRB,3.9241E-04_JPRB/)  
KAO( :, 4,12, 4) = (/&
 & 2.3301E-05_JPRB,3.4905E-05_JPRB,3.8836E-05_JPRB,4.0484E-05_JPRB,4.0838E-05_JPRB,3.9966E-05_JPRB,&
 & 3.7706E-05_JPRB,3.3447E-05_JPRB,3.8870E-04_JPRB/)  
KAO( :, 5,12, 4) = (/&
 & 2.3543E-05_JPRB,3.5840E-05_JPRB,3.9948E-05_JPRB,4.1657E-05_JPRB,4.2028E-05_JPRB,4.1130E-05_JPRB,&
 & 3.8770E-05_JPRB,3.4320E-05_JPRB,3.8474E-04_JPRB/)  
KAO( :, 1,13, 4) = (/&
 & 1.9048E-05_JPRB,2.7433E-05_JPRB,3.0355E-05_JPRB,3.1781E-05_JPRB,3.2020E-05_JPRB,3.1297E-05_JPRB,&
 & 2.9545E-05_JPRB,2.6213E-05_JPRB,3.3572E-04_JPRB/)  
KAO( :, 2,13, 4) = (/&
 & 1.9186E-05_JPRB,2.8151E-05_JPRB,3.1249E-05_JPRB,3.2687E-05_JPRB,3.2953E-05_JPRB,3.2236E-05_JPRB,&
 & 3.0464E-05_JPRB,2.7042E-05_JPRB,3.3299E-04_JPRB/)  
KAO( :, 3,13, 4) = (/&
 & 1.9336E-05_JPRB,2.8946E-05_JPRB,3.2213E-05_JPRB,3.3632E-05_JPRB,3.3925E-05_JPRB,3.3202E-05_JPRB,&
 & 3.1346E-05_JPRB,2.7832E-05_JPRB,3.2995E-04_JPRB/)  
KAO( :, 4,13, 4) = (/&
 & 1.9500E-05_JPRB,2.9752E-05_JPRB,3.3189E-05_JPRB,3.4641E-05_JPRB,3.4936E-05_JPRB,3.4186E-05_JPRB,&
 & 3.2242E-05_JPRB,2.8586E-05_JPRB,3.2636E-04_JPRB/)  
KAO( :, 5,13, 4) = (/&
 & 1.9647E-05_JPRB,3.0517E-05_JPRB,3.4157E-05_JPRB,3.5690E-05_JPRB,3.6009E-05_JPRB,3.5240E-05_JPRB,&
 & 3.3224E-05_JPRB,2.9383E-05_JPRB,3.2302E-04_JPRB/)  
KAO( :, 1, 1, 5) = (/&
 & 1.5710E-04_JPRB,2.0320E-04_JPRB,2.2809E-04_JPRB,2.4127E-04_JPRB,2.4664E-04_JPRB,2.4637E-04_JPRB,&
 & 2.3954E-04_JPRB,2.2558E-04_JPRB,1.9226E-04_JPRB/)  
KAO( :, 2, 1, 5) = (/&
 & 1.5763E-04_JPRB,2.0602E-04_JPRB,2.3252E-04_JPRB,2.4654E-04_JPRB,2.5266E-04_JPRB,2.5275E-04_JPRB,&
 & 2.4636E-04_JPRB,2.3254E-04_JPRB,1.9836E-04_JPRB/)  
KAO( :, 3, 1, 5) = (/&
 & 1.5885E-04_JPRB,2.0936E-04_JPRB,2.3726E-04_JPRB,2.5211E-04_JPRB,2.5917E-04_JPRB,2.5987E-04_JPRB,&
 & 2.5423E-04_JPRB,2.4110E-04_JPRB,2.0597E-04_JPRB/)  
KAO( :, 4, 1, 5) = (/&
 & 1.6010E-04_JPRB,2.1292E-04_JPRB,2.4195E-04_JPRB,2.5773E-04_JPRB,2.6599E-04_JPRB,2.6801E-04_JPRB,&
 & 2.6343E-04_JPRB,2.5079E-04_JPRB,2.1448E-04_JPRB/)  
KAO( :, 5, 1, 5) = (/&
 & 1.6183E-04_JPRB,2.1689E-04_JPRB,2.4710E-04_JPRB,2.6390E-04_JPRB,2.7349E-04_JPRB,2.7678E-04_JPRB,&
 & 2.7286E-04_JPRB,2.6055E-04_JPRB,2.2334E-04_JPRB/)  
KAO( :, 1, 2, 5) = (/&
 & 1.4264E-04_JPRB,1.8747E-04_JPRB,2.0916E-04_JPRB,2.2048E-04_JPRB,2.2542E-04_JPRB,2.2467E-04_JPRB,&
 & 2.1833E-04_JPRB,2.0428E-04_JPRB,1.7002E-04_JPRB/)  
KAO( :, 2, 2, 5) = (/&
 & 1.4357E-04_JPRB,1.9029E-04_JPRB,2.1342E-04_JPRB,2.2542E-04_JPRB,2.3082E-04_JPRB,2.3044E-04_JPRB,&
 & 2.2413E-04_JPRB,2.1022E-04_JPRB,1.7510E-04_JPRB/)  
KAO( :, 3, 2, 5) = (/&
 & 1.4512E-04_JPRB,1.9354E-04_JPRB,2.1804E-04_JPRB,2.3071E-04_JPRB,2.3662E-04_JPRB,2.3677E-04_JPRB,&
 & 2.3090E-04_JPRB,2.1760E-04_JPRB,1.8164E-04_JPRB/)  
KAO( :, 4, 2, 5) = (/&
 & 1.4675E-04_JPRB,1.9716E-04_JPRB,2.2262E-04_JPRB,2.3622E-04_JPRB,2.4303E-04_JPRB,2.4400E-04_JPRB,&
 & 2.3876E-04_JPRB,2.2602E-04_JPRB,1.8905E-04_JPRB/)  
KAO( :, 5, 2, 5) = (/&
 & 1.4825E-04_JPRB,2.0084E-04_JPRB,2.2744E-04_JPRB,2.4214E-04_JPRB,2.4980E-04_JPRB,2.5170E-04_JPRB,&
 & 2.4697E-04_JPRB,2.3468E-04_JPRB,1.9668E-04_JPRB/)  
KAO( :, 1, 3, 5) = (/&
 & 1.2913E-04_JPRB,1.7105E-04_JPRB,1.8962E-04_JPRB,1.9927E-04_JPRB,2.0344E-04_JPRB,2.0263E-04_JPRB,&
 & 1.9648E-04_JPRB,1.8374E-04_JPRB,1.5154E-04_JPRB/)  
KAO( :, 2, 3, 5) = (/&
 & 1.3034E-04_JPRB,1.7385E-04_JPRB,1.9352E-04_JPRB,2.0379E-04_JPRB,2.0816E-04_JPRB,2.0767E-04_JPRB,&
 & 2.0141E-04_JPRB,1.8880E-04_JPRB,1.5543E-04_JPRB/)  
KAO( :, 3, 3, 5) = (/&
 & 1.3189E-04_JPRB,1.7683E-04_JPRB,1.9785E-04_JPRB,2.0858E-04_JPRB,2.1306E-04_JPRB,2.1289E-04_JPRB,&
 & 2.0705E-04_JPRB,1.9450E-04_JPRB,1.6042E-04_JPRB/)  
KAO( :, 4, 3, 5) = (/&
 & 1.3375E-04_JPRB,1.8038E-04_JPRB,2.0233E-04_JPRB,2.1375E-04_JPRB,2.1890E-04_JPRB,2.1897E-04_JPRB,&
 & 2.1362E-04_JPRB,2.0111E-04_JPRB,1.6638E-04_JPRB/)  
KAO( :, 5, 3, 5) = (/&
 & 1.3531E-04_JPRB,1.8393E-04_JPRB,2.0677E-04_JPRB,2.1903E-04_JPRB,2.2516E-04_JPRB,2.2557E-04_JPRB,&
 & 2.2073E-04_JPRB,2.0849E-04_JPRB,1.7278E-04_JPRB/)  
KAO( :, 1, 4, 5) = (/&
 & 1.1675E-04_JPRB,1.5471E-04_JPRB,1.7086E-04_JPRB,1.7907E-04_JPRB,1.8234E-04_JPRB,1.8104E-04_JPRB,&
 & 1.7606E-04_JPRB,1.6488E-04_JPRB,1.3686E-04_JPRB/)  
KAO( :, 2, 4, 5) = (/&
 & 1.1811E-04_JPRB,1.5738E-04_JPRB,1.7430E-04_JPRB,1.8299E-04_JPRB,1.8662E-04_JPRB,1.8551E-04_JPRB,&
 & 1.8028E-04_JPRB,1.6914E-04_JPRB,1.4021E-04_JPRB/)  
KAO( :, 3, 4, 5) = (/&
 & 1.1971E-04_JPRB,1.6033E-04_JPRB,1.7826E-04_JPRB,1.8706E-04_JPRB,1.9073E-04_JPRB,1.9003E-04_JPRB,&
 & 1.8491E-04_JPRB,1.7381E-04_JPRB,1.4440E-04_JPRB/)  
KAO( :, 4, 4, 5) = (/&
 & 1.2145E-04_JPRB,1.6360E-04_JPRB,1.8232E-04_JPRB,1.9160E-04_JPRB,1.9546E-04_JPRB,1.9520E-04_JPRB,&
 & 1.9032E-04_JPRB,1.7913E-04_JPRB,1.4919E-04_JPRB/)  
KAO( :, 5, 4, 5) = (/&
 & 1.2345E-04_JPRB,1.6734E-04_JPRB,1.8679E-04_JPRB,1.9667E-04_JPRB,2.0102E-04_JPRB,2.0119E-04_JPRB,&
 & 1.9631E-04_JPRB,1.8511E-04_JPRB,1.5453E-04_JPRB/)  
KAO( :, 1, 5, 5) = (/&
 & 1.0534E-04_JPRB,1.3892E-04_JPRB,1.5318E-04_JPRB,1.6013E-04_JPRB,1.6249E-04_JPRB,1.6140E-04_JPRB,&
 & 1.5677E-04_JPRB,1.4673E-04_JPRB,1.2734E-04_JPRB/)  
KAO( :, 2, 5, 5) = (/&
 & 1.0682E-04_JPRB,1.4149E-04_JPRB,1.5615E-04_JPRB,1.6351E-04_JPRB,1.6643E-04_JPRB,1.6536E-04_JPRB,&
 & 1.6060E-04_JPRB,1.5077E-04_JPRB,1.3032E-04_JPRB/)  
KAO( :, 3, 5, 5) = (/&
 & 1.0832E-04_JPRB,1.4437E-04_JPRB,1.5968E-04_JPRB,1.6719E-04_JPRB,1.7007E-04_JPRB,1.6925E-04_JPRB,&
 & 1.6475E-04_JPRB,1.5487E-04_JPRB,1.3383E-04_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART3',1,ZHOOK_HANDLE)
END SUBROUTINE PART3


SUBROUTINE PART4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART4',0,ZHOOK_HANDLE)


KAO( :, 4, 5, 5) = (/&
 & 1.0998E-04_JPRB,1.4759E-04_JPRB,1.6348E-04_JPRB,1.7115E-04_JPRB,1.7411E-04_JPRB,1.7355E-04_JPRB,&
 & 1.6947E-04_JPRB,1.5945E-04_JPRB,1.3787E-04_JPRB/)  
KAO( :, 5, 5, 5) = (/&
 & 1.1196E-04_JPRB,1.5129E-04_JPRB,1.6770E-04_JPRB,1.7586E-04_JPRB,1.7902E-04_JPRB,1.7859E-04_JPRB,&
 & 1.7456E-04_JPRB,1.6452E-04_JPRB,1.4233E-04_JPRB/)  
KAO( :, 1, 6, 5) = (/&
 & 9.4514E-05_JPRB,1.2412E-04_JPRB,1.3657E-04_JPRB,1.4247E-04_JPRB,1.4441E-04_JPRB,1.4315E-04_JPRB,&
 & 1.3838E-04_JPRB,1.2929E-04_JPRB,1.2327E-04_JPRB/)  
KAO( :, 2, 6, 5) = (/&
 & 9.5941E-05_JPRB,1.2645E-04_JPRB,1.3931E-04_JPRB,1.4558E-04_JPRB,1.4789E-04_JPRB,1.4670E-04_JPRB,&
 & 1.4200E-04_JPRB,1.3303E-04_JPRB,1.2601E-04_JPRB/)  
KAO( :, 3, 6, 5) = (/&
 & 9.7365E-05_JPRB,1.2920E-04_JPRB,1.4235E-04_JPRB,1.4876E-04_JPRB,1.5129E-04_JPRB,1.5035E-04_JPRB,&
 & 1.4574E-04_JPRB,1.3687E-04_JPRB,1.2924E-04_JPRB/)  
KAO( :, 4, 6, 5) = (/&
 & 9.8894E-05_JPRB,1.3238E-04_JPRB,1.4586E-04_JPRB,1.5224E-04_JPRB,1.5484E-04_JPRB,1.5423E-04_JPRB,&
 & 1.4989E-04_JPRB,1.4089E-04_JPRB,1.3292E-04_JPRB/)  
KAO( :, 5, 6, 5) = (/&
 & 1.0059E-04_JPRB,1.3577E-04_JPRB,1.4967E-04_JPRB,1.5644E-04_JPRB,1.5902E-04_JPRB,1.5844E-04_JPRB,&
 & 1.5428E-04_JPRB,1.4522E-04_JPRB,1.3684E-04_JPRB/)  
KAO( :, 1, 7, 5) = (/&
 & 8.3817E-05_JPRB,1.1024E-04_JPRB,1.2069E-04_JPRB,1.2606E-04_JPRB,1.2762E-04_JPRB,1.2601E-04_JPRB,&
 & 1.2142E-04_JPRB,1.1275E-04_JPRB,1.2580E-04_JPRB/)  
KAO( :, 2, 7, 5) = (/&
 & 8.5049E-05_JPRB,1.1240E-04_JPRB,1.2345E-04_JPRB,1.2908E-04_JPRB,1.3088E-04_JPRB,1.2946E-04_JPRB,&
 & 1.2489E-04_JPRB,1.1643E-04_JPRB,1.2769E-04_JPRB/)  
KAO( :, 3, 7, 5) = (/&
 & 8.6443E-05_JPRB,1.1489E-04_JPRB,1.2631E-04_JPRB,1.3210E-04_JPRB,1.3408E-04_JPRB,1.3284E-04_JPRB,&
 & 1.2822E-04_JPRB,1.1996E-04_JPRB,1.3009E-04_JPRB/)  
KAO( :, 4, 7, 5) = (/&
 & 8.7868E-05_JPRB,1.1787E-04_JPRB,1.2952E-04_JPRB,1.3521E-04_JPRB,1.3734E-04_JPRB,1.3637E-04_JPRB,&
 & 1.3189E-04_JPRB,1.2366E-04_JPRB,1.3307E-04_JPRB/)  
KAO( :, 5, 7, 5) = (/&
 & 8.9520E-05_JPRB,1.2113E-04_JPRB,1.3311E-04_JPRB,1.3890E-04_JPRB,1.4111E-04_JPRB,1.4019E-04_JPRB,&
 & 1.3574E-04_JPRB,1.2746E-04_JPRB,1.3629E-04_JPRB/)  
KAO( :, 1, 8, 5) = (/&
 & 7.3739E-05_JPRB,9.7315E-05_JPRB,1.0630E-04_JPRB,1.1091E-04_JPRB,1.1210E-04_JPRB,1.1034E-04_JPRB,&
 & 1.0576E-04_JPRB,9.7435E-05_JPRB,1.5219E-04_JPRB/)  
KAO( :, 2, 8, 5) = (/&
 & 7.4739E-05_JPRB,9.9339E-05_JPRB,1.0888E-04_JPRB,1.1385E-04_JPRB,1.1515E-04_JPRB,1.1361E-04_JPRB,&
 & 1.0914E-04_JPRB,1.0091E-04_JPRB,1.5078E-04_JPRB/)  
KAO( :, 3, 8, 5) = (/&
 & 7.5979E-05_JPRB,1.0158E-04_JPRB,1.1168E-04_JPRB,1.1676E-04_JPRB,1.1825E-04_JPRB,1.1684E-04_JPRB,&
 & 1.1240E-04_JPRB,1.0417E-04_JPRB,1.5044E-04_JPRB/)  
KAO( :, 4, 8, 5) = (/&
 & 7.7389E-05_JPRB,1.0425E-04_JPRB,1.1460E-04_JPRB,1.1977E-04_JPRB,1.2131E-04_JPRB,1.2000E-04_JPRB,&
 & 1.1564E-04_JPRB,1.0754E-04_JPRB,1.5083E-04_JPRB/)  
KAO( :, 5, 8, 5) = (/&
 & 7.8988E-05_JPRB,1.0719E-04_JPRB,1.1787E-04_JPRB,1.2308E-04_JPRB,1.2465E-04_JPRB,1.2345E-04_JPRB,&
 & 1.1918E-04_JPRB,1.1099E-04_JPRB,1.5186E-04_JPRB/)  
KAO( :, 1, 9, 5) = (/&
 & 6.4327E-05_JPRB,8.5194E-05_JPRB,9.3124E-05_JPRB,9.6906E-05_JPRB,9.7902E-05_JPRB,9.6087E-05_JPRB,&
 & 9.1486E-05_JPRB,8.3530E-05_JPRB,3.0559E-04_JPRB/)  
KAO( :, 2, 9, 5) = (/&
 & 6.5169E-05_JPRB,8.7114E-05_JPRB,9.5498E-05_JPRB,9.9699E-05_JPRB,1.0078E-04_JPRB,9.9075E-05_JPRB,&
 & 9.4585E-05_JPRB,8.6649E-05_JPRB,3.0376E-04_JPRB/)  
KAO( :, 3, 9, 5) = (/&
 & 6.6228E-05_JPRB,8.9174E-05_JPRB,9.8080E-05_JPRB,1.0257E-04_JPRB,1.0373E-04_JPRB,1.0212E-04_JPRB,&
 & 9.7761E-05_JPRB,8.9715E-05_JPRB,3.0205E-04_JPRB/)  
KAO( :, 4, 9, 5) = (/&
 & 6.7560E-05_JPRB,9.1493E-05_JPRB,1.0085E-04_JPRB,1.0546E-04_JPRB,1.0670E-04_JPRB,1.0511E-04_JPRB,&
 & 1.0078E-04_JPRB,9.2773E-05_JPRB,2.9925E-04_JPRB/)  
KAO( :, 5, 9, 5) = (/&
 & 6.9090E-05_JPRB,9.4108E-05_JPRB,1.0377E-04_JPRB,1.0852E-04_JPRB,1.0981E-04_JPRB,1.0822E-04_JPRB,&
 & 1.0396E-04_JPRB,9.5948E-05_JPRB,2.9560E-04_JPRB/)  
KAO( :, 1,10, 5) = (/&
 & 5.5732E-05_JPRB,7.4195E-05_JPRB,8.1092E-05_JPRB,8.4263E-05_JPRB,8.5004E-05_JPRB,8.3260E-05_JPRB,&
 & 7.8896E-05_JPRB,7.1326E-05_JPRB,7.3141E-04_JPRB/)  
KAO( :, 2,10, 5) = (/&
 & 5.6464E-05_JPRB,7.5996E-05_JPRB,8.3306E-05_JPRB,8.6877E-05_JPRB,8.7776E-05_JPRB,8.6058E-05_JPRB,&
 & 8.1636E-05_JPRB,7.4082E-05_JPRB,7.1679E-04_JPRB/)  
KAO( :, 3,10, 5) = (/&
 & 5.7403E-05_JPRB,7.7891E-05_JPRB,8.5666E-05_JPRB,8.9585E-05_JPRB,9.0592E-05_JPRB,8.8875E-05_JPRB,&
 & 8.4523E-05_JPRB,7.6897E-05_JPRB,7.0421E-04_JPRB/)  
KAO( :, 4,10, 5) = (/&
 & 5.8620E-05_JPRB,7.9933E-05_JPRB,8.8213E-05_JPRB,9.2386E-05_JPRB,9.3433E-05_JPRB,9.1667E-05_JPRB,&
 & 8.7388E-05_JPRB,7.9742E-05_JPRB,6.9385E-04_JPRB/)  
KAO( :, 5,10, 5) = (/&
 & 6.0067E-05_JPRB,8.2256E-05_JPRB,9.0893E-05_JPRB,9.5273E-05_JPRB,9.6366E-05_JPRB,9.4596E-05_JPRB,&
 & 9.0298E-05_JPRB,8.2632E-05_JPRB,6.8465E-04_JPRB/)  
KAO( :, 1,11, 5) = (/&
 & 4.8186E-05_JPRB,6.4983E-05_JPRB,7.1108E-05_JPRB,7.3858E-05_JPRB,7.4401E-05_JPRB,7.2817E-05_JPRB,&
 & 6.8716E-05_JPRB,6.1721E-05_JPRB,9.3137E-04_JPRB/)  
KAO( :, 2,11, 5) = (/&
 & 4.8927E-05_JPRB,6.6681E-05_JPRB,7.3165E-05_JPRB,7.6242E-05_JPRB,7.7034E-05_JPRB,7.5453E-05_JPRB,&
 & 7.1255E-05_JPRB,6.4142E-05_JPRB,9.0283E-04_JPRB/)  
KAO( :, 3,11, 5) = (/&
 & 4.9906E-05_JPRB,6.8442E-05_JPRB,7.5379E-05_JPRB,7.8833E-05_JPRB,7.9706E-05_JPRB,7.8052E-05_JPRB,&
 & 7.3833E-05_JPRB,6.6698E-05_JPRB,8.7896E-04_JPRB/)  
KAO( :, 4,11, 5) = (/&
 & 5.1140E-05_JPRB,7.0403E-05_JPRB,7.7738E-05_JPRB,8.1490E-05_JPRB,8.2392E-05_JPRB,8.0715E-05_JPRB,&
 & 7.6507E-05_JPRB,6.9333E-05_JPRB,8.5877E-04_JPRB/)  
KAO( :, 5,11, 5) = (/&
 & 5.2547E-05_JPRB,7.2595E-05_JPRB,8.0310E-05_JPRB,8.4272E-05_JPRB,8.5190E-05_JPRB,8.3479E-05_JPRB,&
 & 7.9204E-05_JPRB,7.1956E-05_JPRB,8.4129E-04_JPRB/)  
KAO( :, 1,12, 5) = (/&
 & 4.1357E-05_JPRB,5.6591E-05_JPRB,6.2004E-05_JPRB,6.4335E-05_JPRB,6.4718E-05_JPRB,6.3255E-05_JPRB,&
 & 5.9536E-05_JPRB,5.3170E-05_JPRB,9.4628E-04_JPRB/)  
KAO( :, 2,12, 5) = (/&
 & 4.2117E-05_JPRB,5.8142E-05_JPRB,6.3912E-05_JPRB,6.6563E-05_JPRB,6.7175E-05_JPRB,6.5721E-05_JPRB,&
 & 6.1864E-05_JPRB,5.5283E-05_JPRB,9.1448E-04_JPRB/)  
KAO( :, 3,12, 5) = (/&
 & 4.3123E-05_JPRB,5.9831E-05_JPRB,6.5955E-05_JPRB,6.8956E-05_JPRB,6.9677E-05_JPRB,6.8113E-05_JPRB,&
 & 6.4202E-05_JPRB,5.7597E-05_JPRB,8.8738E-04_JPRB/)  
KAO( :, 4,12, 5) = (/&
 & 4.4308E-05_JPRB,6.1719E-05_JPRB,6.8165E-05_JPRB,7.1448E-05_JPRB,7.2209E-05_JPRB,7.0617E-05_JPRB,&
 & 6.6651E-05_JPRB,5.9974E-05_JPRB,8.6370E-04_JPRB/)  
KAO( :, 5,12, 5) = (/&
 & 4.5586E-05_JPRB,6.3825E-05_JPRB,7.0651E-05_JPRB,7.4074E-05_JPRB,7.4824E-05_JPRB,7.3199E-05_JPRB,&
 & 6.9129E-05_JPRB,6.2368E-05_JPRB,8.4394E-04_JPRB/)  
KAO( :, 1,13, 5) = (/&
 & 3.5199E-05_JPRB,4.8904E-05_JPRB,5.3685E-05_JPRB,5.5708E-05_JPRB,5.5958E-05_JPRB,5.4602E-05_JPRB,&
 & 5.1289E-05_JPRB,4.5544E-05_JPRB,7.9844E-04_JPRB/)  
KAO( :, 2,13, 5) = (/&
 & 3.5968E-05_JPRB,5.0359E-05_JPRB,5.5441E-05_JPRB,5.7776E-05_JPRB,5.8210E-05_JPRB,5.6833E-05_JPRB,&
 & 5.3406E-05_JPRB,4.7437E-05_JPRB,7.7225E-04_JPRB/)  
KAO( :, 3,13, 5) = (/&
 & 3.6919E-05_JPRB,5.1978E-05_JPRB,5.7339E-05_JPRB,5.9942E-05_JPRB,6.0487E-05_JPRB,5.9061E-05_JPRB,&
 & 5.5548E-05_JPRB,4.9491E-05_JPRB,7.4964E-04_JPRB/)  
KAO( :, 4,13, 5) = (/&
 & 3.7983E-05_JPRB,5.3790E-05_JPRB,5.9444E-05_JPRB,6.2256E-05_JPRB,6.2844E-05_JPRB,6.1377E-05_JPRB,&
 & 5.7755E-05_JPRB,5.1611E-05_JPRB,7.3016E-04_JPRB/)  
KAO( :, 5,13, 5) = (/&
 & 3.9071E-05_JPRB,5.5803E-05_JPRB,6.1798E-05_JPRB,6.4723E-05_JPRB,6.5302E-05_JPRB,6.3732E-05_JPRB,&
 & 5.9993E-05_JPRB,5.3748E-05_JPRB,7.1404E-04_JPRB/)  
KAO( :, 1, 1, 6) = (/&
 & 2.5660E-04_JPRB,3.1807E-04_JPRB,3.6094E-04_JPRB,3.8920E-04_JPRB,4.0736E-04_JPRB,4.1545E-04_JPRB,&
 & 4.1386E-04_JPRB,4.0633E-04_JPRB,3.6193E-04_JPRB/)  
KAO( :, 2, 1, 6) = (/&
 & 2.5865E-04_JPRB,3.2319E-04_JPRB,3.6764E-04_JPRB,3.9762E-04_JPRB,4.1800E-04_JPRB,4.2858E-04_JPRB,&
 & 4.2847E-04_JPRB,4.2235E-04_JPRB,3.7675E-04_JPRB/)  
KAO( :, 3, 1, 6) = (/&
 & 2.6137E-04_JPRB,3.2915E-04_JPRB,3.7535E-04_JPRB,4.0750E-04_JPRB,4.2970E-04_JPRB,4.4147E-04_JPRB,&
 & 4.4293E-04_JPRB,4.3843E-04_JPRB,3.9233E-04_JPRB/)  
KAO( :, 4, 1, 6) = (/&
 & 2.6360E-04_JPRB,3.3488E-04_JPRB,3.8404E-04_JPRB,4.1788E-04_JPRB,4.4114E-04_JPRB,4.5427E-04_JPRB,&
 & 4.5738E-04_JPRB,4.5544E-04_JPRB,4.1003E-04_JPRB/)  
KAO( :, 5, 1, 6) = (/&
 & 2.6660E-04_JPRB,3.4173E-04_JPRB,3.9350E-04_JPRB,4.2919E-04_JPRB,4.5400E-04_JPRB,4.6894E-04_JPRB,&
 & 4.7415E-04_JPRB,4.7523E-04_JPRB,4.3058E-04_JPRB/)  
KAO( :, 1, 2, 6) = (/&
 & 2.3631E-04_JPRB,2.9631E-04_JPRB,3.3525E-04_JPRB,3.5919E-04_JPRB,3.7267E-04_JPRB,3.7835E-04_JPRB,&
 & 3.7529E-04_JPRB,3.6555E-04_JPRB,3.2111E-04_JPRB/)  
KAO( :, 2, 2, 6) = (/&
 & 2.3829E-04_JPRB,3.0128E-04_JPRB,3.4159E-04_JPRB,3.6758E-04_JPRB,3.8290E-04_JPRB,3.9019E-04_JPRB,&
 & 3.8891E-04_JPRB,3.7964E-04_JPRB,3.3378E-04_JPRB/)  
KAO( :, 3, 2, 6) = (/&
 & 2.4092E-04_JPRB,3.0698E-04_JPRB,3.4893E-04_JPRB,3.7703E-04_JPRB,3.9429E-04_JPRB,4.0240E-04_JPRB,&
 & 4.0189E-04_JPRB,3.9363E-04_JPRB,3.4730E-04_JPRB/)  
KAO( :, 4, 2, 6) = (/&
 & 2.4353E-04_JPRB,3.1280E-04_JPRB,3.5757E-04_JPRB,3.8697E-04_JPRB,4.0550E-04_JPRB,4.1447E-04_JPRB,&
 & 4.1496E-04_JPRB,4.0890E-04_JPRB,3.6318E-04_JPRB/)  
KAO( :, 5, 2, 6) = (/&
 & 2.4646E-04_JPRB,3.1930E-04_JPRB,3.6666E-04_JPRB,3.9774E-04_JPRB,4.1741E-04_JPRB,4.2801E-04_JPRB,&
 & 4.2988E-04_JPRB,4.2637E-04_JPRB,3.8102E-04_JPRB/)  
KAO( :, 1, 3, 6) = (/&
 & 2.1702E-04_JPRB,2.7392E-04_JPRB,3.0713E-04_JPRB,3.2661E-04_JPRB,3.3701E-04_JPRB,3.4012E-04_JPRB,&
 & 3.3574E-04_JPRB,3.2367E-04_JPRB,2.7953E-04_JPRB/)  
KAO( :, 2, 3, 6) = (/&
 & 2.1882E-04_JPRB,2.7874E-04_JPRB,3.1368E-04_JPRB,3.3483E-04_JPRB,3.4655E-04_JPRB,3.5089E-04_JPRB,&
 & 3.4836E-04_JPRB,3.3662E-04_JPRB,2.9075E-04_JPRB/)  
KAO( :, 3, 3, 6) = (/&
 & 2.2093E-04_JPRB,2.8379E-04_JPRB,3.2031E-04_JPRB,3.4355E-04_JPRB,3.5690E-04_JPRB,3.6196E-04_JPRB,&
 & 3.6029E-04_JPRB,3.4924E-04_JPRB,3.0255E-04_JPRB/)  
KAO( :, 4, 3, 6) = (/&
 & 2.2391E-04_JPRB,2.8964E-04_JPRB,3.2857E-04_JPRB,3.5322E-04_JPRB,3.6741E-04_JPRB,3.7364E-04_JPRB,&
 & 3.7227E-04_JPRB,3.6287E-04_JPRB,3.1610E-04_JPRB/)  
KAO( :, 5, 3, 6) = (/&
 & 2.2678E-04_JPRB,2.9569E-04_JPRB,3.3712E-04_JPRB,3.6314E-04_JPRB,3.7839E-04_JPRB,3.8589E-04_JPRB,&
 & 3.8538E-04_JPRB,3.7808E-04_JPRB,3.3103E-04_JPRB/)  
KAO( :, 1, 4, 6) = (/&
 & 1.9893E-04_JPRB,2.5184E-04_JPRB,2.7904E-04_JPRB,2.9424E-04_JPRB,3.0215E-04_JPRB,3.0353E-04_JPRB,&
 & 2.9750E-04_JPRB,2.8367E-04_JPRB,2.4378E-04_JPRB/)  
KAO( :, 2, 4, 6) = (/&
 & 2.0039E-04_JPRB,2.5636E-04_JPRB,2.8551E-04_JPRB,3.0218E-04_JPRB,3.1138E-04_JPRB,3.1364E-04_JPRB,&
 & 3.0933E-04_JPRB,2.9596E-04_JPRB,2.5360E-04_JPRB/)  
KAO( :, 3, 4, 6) = (/&
 & 2.0244E-04_JPRB,2.6111E-04_JPRB,2.9172E-04_JPRB,3.1073E-04_JPRB,3.2138E-04_JPRB,3.2408E-04_JPRB,&
 & 3.2030E-04_JPRB,3.0766E-04_JPRB,2.6380E-04_JPRB/)  
KAO( :, 4, 4, 6) = (/&
 & 2.0501E-04_JPRB,2.6640E-04_JPRB,2.9889E-04_JPRB,3.1956E-04_JPRB,3.3116E-04_JPRB,3.3435E-04_JPRB,&
 & 3.3120E-04_JPRB,3.1983E-04_JPRB,2.7551E-04_JPRB/)  
KAO( :, 5, 4, 6) = (/&
 & 2.0836E-04_JPRB,2.7264E-04_JPRB,3.0721E-04_JPRB,3.2917E-04_JPRB,3.4139E-04_JPRB,3.4585E-04_JPRB,&
 & 3.4342E-04_JPRB,3.3321E-04_JPRB,2.8833E-04_JPRB/)  
KAO( :, 1, 5, 6) = (/&
 & 1.8177E-04_JPRB,2.3005E-04_JPRB,2.5216E-04_JPRB,2.6400E-04_JPRB,2.6980E-04_JPRB,2.6977E-04_JPRB,&
 & 2.6270E-04_JPRB,2.4807E-04_JPRB,2.1566E-04_JPRB/)  
KAO( :, 2, 5, 6) = (/&
 & 1.8288E-04_JPRB,2.3456E-04_JPRB,2.5850E-04_JPRB,2.7178E-04_JPRB,2.7838E-04_JPRB,2.7918E-04_JPRB,&
 & 2.7326E-04_JPRB,2.5893E-04_JPRB,2.2464E-04_JPRB/)  
KAO( :, 3, 5, 6) = (/&
 & 1.8495E-04_JPRB,2.3899E-04_JPRB,2.6446E-04_JPRB,2.7972E-04_JPRB,2.8778E-04_JPRB,2.8887E-04_JPRB,&
 & 2.8352E-04_JPRB,2.6965E-04_JPRB,2.3371E-04_JPRB/)  
KAO( :, 4, 5, 6) = (/&
 & 1.8757E-04_JPRB,2.4389E-04_JPRB,2.7104E-04_JPRB,2.8807E-04_JPRB,2.9709E-04_JPRB,2.9855E-04_JPRB,&
 & 2.9335E-04_JPRB,2.8065E-04_JPRB,2.4386E-04_JPRB/)  
KAO( :, 5, 5, 6) = (/&
 & 1.9089E-04_JPRB,2.4987E-04_JPRB,2.7871E-04_JPRB,2.9704E-04_JPRB,3.0660E-04_JPRB,3.0888E-04_JPRB,&
 & 3.0414E-04_JPRB,2.9240E-04_JPRB,2.5489E-04_JPRB/)  
KAO( :, 1, 6, 6) = (/&
 & 1.6548E-04_JPRB,2.0845E-04_JPRB,2.2667E-04_JPRB,2.3621E-04_JPRB,2.3998E-04_JPRB,2.3852E-04_JPRB,&
 & 2.3181E-04_JPRB,2.1713E-04_JPRB,1.9774E-04_JPRB/)  
KAO( :, 2, 6, 6) = (/&
 & 1.6647E-04_JPRB,2.1295E-04_JPRB,2.3285E-04_JPRB,2.4356E-04_JPRB,2.4798E-04_JPRB,2.4711E-04_JPRB,&
 & 2.4086E-04_JPRB,2.2656E-04_JPRB,2.0619E-04_JPRB/)  
KAO( :, 3, 6, 6) = (/&
 & 1.6832E-04_JPRB,2.1735E-04_JPRB,2.3897E-04_JPRB,2.5101E-04_JPRB,2.5638E-04_JPRB,2.5608E-04_JPRB,&
 & 2.5005E-04_JPRB,2.3612E-04_JPRB,2.1472E-04_JPRB/)  
KAO( :, 4, 6, 6) = (/&
 & 1.7090E-04_JPRB,2.2192E-04_JPRB,2.4527E-04_JPRB,2.5863E-04_JPRB,2.6479E-04_JPRB,2.6498E-04_JPRB,&
 & 2.5909E-04_JPRB,2.4595E-04_JPRB,2.2382E-04_JPRB/)  
KAO( :, 5, 6, 6) = (/&
 & 1.7392E-04_JPRB,2.2728E-04_JPRB,2.5204E-04_JPRB,2.6653E-04_JPRB,2.7329E-04_JPRB,2.7417E-04_JPRB,&
 & 2.6871E-04_JPRB,2.5622E-04_JPRB,2.3379E-04_JPRB/)  
KAO( :, 1, 7, 6) = (/&
 & 1.4974E-04_JPRB,1.8746E-04_JPRB,2.0303E-04_JPRB,2.1075E-04_JPRB,2.1306E-04_JPRB,2.1110E-04_JPRB,&
 & 2.0431E-04_JPRB,1.8998E-04_JPRB,1.9358E-04_JPRB/)  
KAO( :, 2, 7, 6) = (/&
 & 1.5089E-04_JPRB,1.9183E-04_JPRB,2.0895E-04_JPRB,2.1750E-04_JPRB,2.2044E-04_JPRB,2.1873E-04_JPRB,&
 & 2.1228E-04_JPRB,1.9808E-04_JPRB,2.0012E-04_JPRB/)  
KAO( :, 3, 7, 6) = (/&
 & 1.5257E-04_JPRB,1.9611E-04_JPRB,2.1478E-04_JPRB,2.2448E-04_JPRB,2.2805E-04_JPRB,2.2660E-04_JPRB,&
 & 2.2066E-04_JPRB,2.0672E-04_JPRB,2.0775E-04_JPRB/)  
KAO( :, 4, 7, 6) = (/&
 & 1.5493E-04_JPRB,2.0056E-04_JPRB,2.2076E-04_JPRB,2.3152E-04_JPRB,2.3569E-04_JPRB,2.3461E-04_JPRB,&
 & 2.2897E-04_JPRB,2.1559E-04_JPRB,2.1605E-04_JPRB/)  
KAO( :, 5, 7, 6) = (/&
 & 1.5774E-04_JPRB,2.0562E-04_JPRB,2.2715E-04_JPRB,2.3878E-04_JPRB,2.4330E-04_JPRB,2.4290E-04_JPRB,&
 & 2.3768E-04_JPRB,2.2474E-04_JPRB,2.2537E-04_JPRB/)  
KAO( :, 1, 8, 6) = (/&
 & 1.3469E-04_JPRB,1.6768E-04_JPRB,1.8125E-04_JPRB,1.8765E-04_JPRB,1.8912E-04_JPRB,1.8647E-04_JPRB,&
 & 1.7925E-04_JPRB,1.6551E-04_JPRB,2.2549E-04_JPRB/)  
KAO( :, 2, 8, 6) = (/&
 & 1.3601E-04_JPRB,1.7179E-04_JPRB,1.8676E-04_JPRB,1.9388E-04_JPRB,1.9601E-04_JPRB,1.9365E-04_JPRB,&
 & 1.8651E-04_JPRB,1.7268E-04_JPRB,2.2728E-04_JPRB/)  
KAO( :, 3, 8, 6) = (/&
 & 1.3770E-04_JPRB,1.7606E-04_JPRB,1.9214E-04_JPRB,2.0024E-04_JPRB,2.0294E-04_JPRB,2.0077E-04_JPRB,&
 & 1.9394E-04_JPRB,1.8025E-04_JPRB,2.3037E-04_JPRB/)  
KAO( :, 4, 8, 6) = (/&
 & 1.3980E-04_JPRB,1.8052E-04_JPRB,1.9782E-04_JPRB,2.0667E-04_JPRB,2.0985E-04_JPRB,2.0804E-04_JPRB,&
 & 2.0170E-04_JPRB,1.8820E-04_JPRB,2.3502E-04_JPRB/)  
KAO( :, 5, 8, 6) = (/&
 & 1.4234E-04_JPRB,1.8549E-04_JPRB,2.0378E-04_JPRB,2.1326E-04_JPRB,2.1685E-04_JPRB,2.1554E-04_JPRB,&
 & 2.0965E-04_JPRB,1.9644E-04_JPRB,2.4136E-04_JPRB/)  
KAO( :, 1, 9, 6) = (/&
 & 1.1992E-04_JPRB,1.4933E-04_JPRB,1.6105E-04_JPRB,1.6671E-04_JPRB,1.6730E-04_JPRB,1.6393E-04_JPRB,&
 & 1.5666E-04_JPRB,1.4342E-04_JPRB,4.8653E-04_JPRB/)  
KAO( :, 2, 9, 6) = (/&
 & 1.2149E-04_JPRB,1.5326E-04_JPRB,1.6624E-04_JPRB,1.7247E-04_JPRB,1.7376E-04_JPRB,1.7057E-04_JPRB,&
 & 1.6339E-04_JPRB,1.5015E-04_JPRB,4.7263E-04_JPRB/)  
KAO( :, 3, 9, 6) = (/&
 & 1.2314E-04_JPRB,1.5738E-04_JPRB,1.7131E-04_JPRB,1.7818E-04_JPRB,1.8004E-04_JPRB,1.7724E-04_JPRB,&
 & 1.6998E-04_JPRB,1.5688E-04_JPRB,4.6122E-04_JPRB/)  
KAO( :, 4, 9, 6) = (/&
 & 1.2514E-04_JPRB,1.6177E-04_JPRB,1.7650E-04_JPRB,1.8400E-04_JPRB,1.8641E-04_JPRB,1.8403E-04_JPRB,&
 & 1.7684E-04_JPRB,1.6385E-04_JPRB,4.5149E-04_JPRB/)  
KAO( :, 5, 9, 6) = (/&
 & 1.2748E-04_JPRB,1.6660E-04_JPRB,1.8214E-04_JPRB,1.9005E-04_JPRB,1.9284E-04_JPRB,1.9097E-04_JPRB,&
 & 1.8405E-04_JPRB,1.7111E-04_JPRB,4.4363E-04_JPRB/)  
KAO( :, 1,10, 6) = (/&
 & 1.0584E-04_JPRB,1.3236E-04_JPRB,1.4288E-04_JPRB,1.4761E-04_JPRB,1.4780E-04_JPRB,1.4423E-04_JPRB,&
 & 1.3667E-04_JPRB,1.2400E-04_JPRB,1.5407E-03_JPRB/)  
KAO( :, 2,10, 6) = (/&
 & 1.0748E-04_JPRB,1.3619E-04_JPRB,1.4771E-04_JPRB,1.5305E-04_JPRB,1.5361E-04_JPRB,1.5017E-04_JPRB,&
 & 1.4291E-04_JPRB,1.3024E-04_JPRB,1.4707E-03_JPRB/)  
KAO( :, 3,10, 6) = (/&
 & 1.0916E-04_JPRB,1.4012E-04_JPRB,1.5258E-04_JPRB,1.5840E-04_JPRB,1.5929E-04_JPRB,1.5625E-04_JPRB,&
 & 1.4913E-04_JPRB,1.3639E-04_JPRB,1.4078E-03_JPRB/)  
KAO( :, 4,10, 6) = (/&
 & 1.1108E-04_JPRB,1.4432E-04_JPRB,1.5744E-04_JPRB,1.6378E-04_JPRB,1.6514E-04_JPRB,1.6251E-04_JPRB,&
 & 1.5541E-04_JPRB,1.4254E-04_JPRB,1.3501E-03_JPRB/)  
KAO( :, 5,10, 6) = (/&
 & 1.1328E-04_JPRB,1.4893E-04_JPRB,1.6265E-04_JPRB,1.6934E-04_JPRB,1.7119E-04_JPRB,1.6880E-04_JPRB,&
 & 1.6190E-04_JPRB,1.4900E-04_JPRB,1.2982E-03_JPRB/)  
KAO( :, 1,11, 6) = (/&
 & 9.3489E-05_JPRB,1.1825E-04_JPRB,1.2805E-04_JPRB,1.3224E-04_JPRB,1.3232E-04_JPRB,1.2873E-04_JPRB,&
 & 1.2131E-04_JPRB,1.0918E-04_JPRB,2.0757E-03_JPRB/)  
KAO( :, 2,11, 6) = (/&
 & 9.5099E-05_JPRB,1.2195E-04_JPRB,1.3268E-04_JPRB,1.3732E-04_JPRB,1.3748E-04_JPRB,1.3414E-04_JPRB,&
 & 1.2695E-04_JPRB,1.1489E-04_JPRB,1.9797E-03_JPRB/)  
KAO( :, 3,11, 6) = (/&
 & 9.6804E-05_JPRB,1.2575E-04_JPRB,1.3731E-04_JPRB,1.4230E-04_JPRB,1.4278E-04_JPRB,1.3973E-04_JPRB,&
 & 1.3283E-04_JPRB,1.2047E-04_JPRB,1.8901E-03_JPRB/)  
KAO( :, 4,11, 6) = (/&
 & 9.8710E-05_JPRB,1.2986E-04_JPRB,1.4205E-04_JPRB,1.4740E-04_JPRB,1.4826E-04_JPRB,1.4548E-04_JPRB,&
 & 1.3868E-04_JPRB,1.2603E-04_JPRB,1.8079E-03_JPRB/)  
KAO( :, 5,11, 6) = (/&
 & 1.0095E-04_JPRB,1.3435E-04_JPRB,1.4704E-04_JPRB,1.5275E-04_JPRB,1.5397E-04_JPRB,1.5141E-04_JPRB,&
 & 1.4471E-04_JPRB,1.3186E-04_JPRB,1.7340E-03_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART4',1,ZHOOK_HANDLE)
END SUBROUTINE PART4


SUBROUTINE PART5

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART5',0,ZHOOK_HANDLE)


KAO( :, 1,12, 6) = (/&
 & 8.2093E-05_JPRB,1.0522E-04_JPRB,1.1410E-04_JPRB,1.1782E-04_JPRB,1.1761E-04_JPRB,1.1416E-04_JPRB,&
 & 1.0724E-04_JPRB,9.5735E-05_JPRB,2.1586E-03_JPRB/)  
KAO( :, 2,12, 6) = (/&
 & 8.3669E-05_JPRB,1.0871E-04_JPRB,1.1846E-04_JPRB,1.2251E-04_JPRB,1.2240E-04_JPRB,1.1908E-04_JPRB,&
 & 1.1234E-04_JPRB,1.0091E-04_JPRB,2.0547E-03_JPRB/)  
KAO( :, 3,12, 6) = (/&
 & 8.5301E-05_JPRB,1.1235E-04_JPRB,1.2282E-04_JPRB,1.2721E-04_JPRB,1.2738E-04_JPRB,1.2431E-04_JPRB,&
 & 1.1770E-04_JPRB,1.0601E-04_JPRB,1.9599E-03_JPRB/)  
KAO( :, 4,12, 6) = (/&
 & 8.7242E-05_JPRB,1.1626E-04_JPRB,1.2740E-04_JPRB,1.3207E-04_JPRB,1.3252E-04_JPRB,1.2966E-04_JPRB,&
 & 1.2318E-04_JPRB,1.1105E-04_JPRB,1.8736E-03_JPRB/)  
KAO( :, 5,12, 6) = (/&
 & 8.9569E-05_JPRB,1.2041E-04_JPRB,1.3214E-04_JPRB,1.3715E-04_JPRB,1.3802E-04_JPRB,1.3533E-04_JPRB,&
 & 1.2876E-04_JPRB,1.1627E-04_JPRB,1.7949E-03_JPRB/)  
KAO( :, 1,13, 6) = (/&
 & 7.1569E-05_JPRB,9.3060E-05_JPRB,1.0102E-04_JPRB,1.0423E-04_JPRB,1.0388E-04_JPRB,1.0052E-04_JPRB,&
 & 9.4174E-05_JPRB,8.3531E-05_JPRB,1.8351E-03_JPRB/)  
KAO( :, 2,13, 6) = (/&
 & 7.3011E-05_JPRB,9.6373E-05_JPRB,1.0503E-04_JPRB,1.0856E-04_JPRB,1.0834E-04_JPRB,1.0508E-04_JPRB,&
 & 9.8836E-05_JPRB,8.8176E-05_JPRB,1.7459E-03_JPRB/)  
KAO( :, 3,13, 6) = (/&
 & 7.4663E-05_JPRB,9.9794E-05_JPRB,1.0913E-04_JPRB,1.1298E-04_JPRB,1.1299E-04_JPRB,1.0991E-04_JPRB,&
 & 1.0372E-04_JPRB,9.2787E-05_JPRB,1.6660E-03_JPRB/)  
KAO( :, 4,13, 6) = (/&
 & 7.6630E-05_JPRB,1.0344E-04_JPRB,1.1345E-04_JPRB,1.1756E-04_JPRB,1.1782E-04_JPRB,1.1495E-04_JPRB,&
 & 1.0877E-04_JPRB,9.7412E-05_JPRB,1.5932E-03_JPRB/)  
KAO( :, 5,13, 6) = (/&
 & 7.9007E-05_JPRB,1.0733E-04_JPRB,1.1787E-04_JPRB,1.2235E-04_JPRB,1.2303E-04_JPRB,1.2033E-04_JPRB,&
 & 1.1390E-04_JPRB,1.0206E-04_JPRB,1.5265E-03_JPRB/)  
KAO( :, 1, 1, 7) = (/&
 & 4.6305E-04_JPRB,5.4556E-04_JPRB,6.0200E-04_JPRB,6.4863E-04_JPRB,6.8107E-04_JPRB,7.0420E-04_JPRB,&
 & 7.2199E-04_JPRB,7.3085E-04_JPRB,6.7646E-04_JPRB/)  
KAO( :, 2, 1, 7) = (/&
 & 4.6301E-04_JPRB,5.5700E-04_JPRB,6.1674E-04_JPRB,6.6918E-04_JPRB,7.0683E-04_JPRB,7.3382E-04_JPRB,&
 & 7.5720E-04_JPRB,7.6870E-04_JPRB,7.1353E-04_JPRB/)  
KAO( :, 3, 1, 7) = (/&
 & 4.6454E-04_JPRB,5.7050E-04_JPRB,6.3324E-04_JPRB,6.9016E-04_JPRB,7.3249E-04_JPRB,7.6632E-04_JPRB,&
 & 7.9567E-04_JPRB,8.0915E-04_JPRB,7.5224E-04_JPRB/)  
KAO( :, 4, 1, 7) = (/&
 & 4.6651E-04_JPRB,5.8405E-04_JPRB,6.4895E-04_JPRB,7.1069E-04_JPRB,7.5837E-04_JPRB,7.9949E-04_JPRB,&
 & 8.3506E-04_JPRB,8.5087E-04_JPRB,7.9164E-04_JPRB/)  
KAO( :, 5, 1, 7) = (/&
 & 4.7034E-04_JPRB,5.9930E-04_JPRB,6.6683E-04_JPRB,7.3355E-04_JPRB,7.8609E-04_JPRB,8.3312E-04_JPRB,&
 & 8.7517E-04_JPRB,8.9333E-04_JPRB,8.3199E-04_JPRB/)  
KAO( :, 1, 2, 7) = (/&
 & 4.3178E-04_JPRB,5.0967E-04_JPRB,5.7208E-04_JPRB,6.1793E-04_JPRB,6.4678E-04_JPRB,6.6138E-04_JPRB,&
 & 6.6815E-04_JPRB,6.6568E-04_JPRB,5.9744E-04_JPRB/)  
KAO( :, 2, 2, 7) = (/&
 & 4.3227E-04_JPRB,5.2067E-04_JPRB,5.8785E-04_JPRB,6.3795E-04_JPRB,6.7133E-04_JPRB,6.9007E-04_JPRB,&
 & 7.0100E-04_JPRB,7.0211E-04_JPRB,6.3355E-04_JPRB/)  
KAO( :, 3, 2, 7) = (/&
 & 4.3414E-04_JPRB,5.3362E-04_JPRB,6.0473E-04_JPRB,6.5841E-04_JPRB,6.9567E-04_JPRB,7.2097E-04_JPRB,&
 & 7.3754E-04_JPRB,7.4189E-04_JPRB,6.7066E-04_JPRB/)  
KAO( :, 4, 2, 7) = (/&
 & 4.3688E-04_JPRB,5.4677E-04_JPRB,6.2106E-04_JPRB,6.7900E-04_JPRB,7.2053E-04_JPRB,7.5255E-04_JPRB,&
 & 7.7596E-04_JPRB,7.8317E-04_JPRB,7.0771E-04_JPRB/)  
KAO( :, 5, 2, 7) = (/&
 & 4.4026E-04_JPRB,5.6009E-04_JPRB,6.3723E-04_JPRB,6.9996E-04_JPRB,7.4621E-04_JPRB,7.8382E-04_JPRB,&
 & 8.1411E-04_JPRB,8.2479E-04_JPRB,7.4663E-04_JPRB/)  
KAO( :, 1, 3, 7) = (/&
 & 4.0042E-04_JPRB,4.7588E-04_JPRB,5.3737E-04_JPRB,5.7848E-04_JPRB,6.0266E-04_JPRB,6.1092E-04_JPRB,&
 & 6.0756E-04_JPRB,5.9389E-04_JPRB,5.1726E-04_JPRB/)  
KAO( :, 2, 3, 7) = (/&
 & 4.0139E-04_JPRB,4.8636E-04_JPRB,5.5256E-04_JPRB,5.9842E-04_JPRB,6.2668E-04_JPRB,6.3795E-04_JPRB,&
 & 6.3723E-04_JPRB,6.2673E-04_JPRB,5.4890E-04_JPRB/)  
KAO( :, 3, 3, 7) = (/&
 & 4.0264E-04_JPRB,4.9818E-04_JPRB,5.6878E-04_JPRB,6.1775E-04_JPRB,6.4985E-04_JPRB,6.6625E-04_JPRB,&
 & 6.6960E-04_JPRB,6.6297E-04_JPRB,5.8203E-04_JPRB/)  
KAO( :, 4, 3, 7) = (/&
 & 4.0594E-04_JPRB,5.1098E-04_JPRB,5.8559E-04_JPRB,6.3812E-04_JPRB,6.7417E-04_JPRB,6.9560E-04_JPRB,&
 & 7.0436E-04_JPRB,7.0139E-04_JPRB,6.1550E-04_JPRB/)  
KAO( :, 5, 3, 7) = (/&
 & 4.0942E-04_JPRB,5.2279E-04_JPRB,6.0106E-04_JPRB,6.5810E-04_JPRB,6.9804E-04_JPRB,7.2431E-04_JPRB,&
 & 7.3907E-04_JPRB,7.3980E-04_JPRB,6.5087E-04_JPRB/)  
KAO( :, 1, 4, 7) = (/&
 & 3.6954E-04_JPRB,4.4390E-04_JPRB,4.9967E-04_JPRB,5.3490E-04_JPRB,5.5341E-04_JPRB,5.5728E-04_JPRB,&
 & 5.4744E-04_JPRB,5.2585E-04_JPRB,4.5076E-04_JPRB/)  
KAO( :, 2, 4, 7) = (/&
 & 3.7099E-04_JPRB,4.5452E-04_JPRB,5.1452E-04_JPRB,5.5410E-04_JPRB,5.7617E-04_JPRB,5.8227E-04_JPRB,&
 & 5.7394E-04_JPRB,5.5446E-04_JPRB,4.7750E-04_JPRB/)  
KAO( :, 3, 4, 7) = (/&
 & 3.7261E-04_JPRB,4.6594E-04_JPRB,5.3039E-04_JPRB,5.7264E-04_JPRB,5.9783E-04_JPRB,6.0838E-04_JPRB,&
 & 6.0270E-04_JPRB,5.8596E-04_JPRB,5.0606E-04_JPRB/)  
KAO( :, 4, 4, 7) = (/&
 & 3.7542E-04_JPRB,4.7733E-04_JPRB,5.4631E-04_JPRB,5.9142E-04_JPRB,6.2021E-04_JPRB,6.3532E-04_JPRB,&
 & 6.3302E-04_JPRB,6.1929E-04_JPRB,5.3494E-04_JPRB/)  
KAO( :, 5, 4, 7) = (/&
 & 3.7994E-04_JPRB,4.8922E-04_JPRB,5.6238E-04_JPRB,6.1134E-04_JPRB,6.4405E-04_JPRB,6.6206E-04_JPRB,&
 & 6.6409E-04_JPRB,6.5333E-04_JPRB,5.6564E-04_JPRB/)  
KAO( :, 1, 5, 7) = (/&
 & 3.4061E-04_JPRB,4.1228E-04_JPRB,4.6040E-04_JPRB,4.8986E-04_JPRB,5.0320E-04_JPRB,5.0314E-04_JPRB,&
 & 4.9155E-04_JPRB,4.6563E-04_JPRB,3.9708E-04_JPRB/)  
KAO( :, 2, 5, 7) = (/&
 & 3.4265E-04_JPRB,4.2238E-04_JPRB,4.7497E-04_JPRB,5.0787E-04_JPRB,5.2436E-04_JPRB,5.2638E-04_JPRB,&
 & 5.1586E-04_JPRB,4.9074E-04_JPRB,4.1980E-04_JPRB/)  
KAO( :, 3, 5, 7) = (/&
 & 3.4457E-04_JPRB,4.3316E-04_JPRB,4.9022E-04_JPRB,5.2547E-04_JPRB,5.4476E-04_JPRB,5.5018E-04_JPRB,&
 & 5.4131E-04_JPRB,5.1767E-04_JPRB,4.4445E-04_JPRB/)  
KAO( :, 4, 5, 7) = (/&
 & 3.4732E-04_JPRB,4.4421E-04_JPRB,5.0540E-04_JPRB,5.4314E-04_JPRB,5.6518E-04_JPRB,5.7439E-04_JPRB,&
 & 5.6831E-04_JPRB,5.4593E-04_JPRB,4.6962E-04_JPRB/)  
KAO( :, 5, 5, 7) = (/&
 & 3.5182E-04_JPRB,4.5580E-04_JPRB,5.2093E-04_JPRB,5.6187E-04_JPRB,5.8688E-04_JPRB,5.9917E-04_JPRB,&
 & 5.9551E-04_JPRB,5.7498E-04_JPRB,4.9655E-04_JPRB/)  
KAO( :, 1, 6, 7) = (/&
 & 3.1397E-04_JPRB,3.8099E-04_JPRB,4.2085E-04_JPRB,4.4392E-04_JPRB,4.5344E-04_JPRB,4.5128E-04_JPRB,&
 & 4.3795E-04_JPRB,4.1046E-04_JPRB,3.5811E-04_JPRB/)  
KAO( :, 2, 6, 7) = (/&
 & 3.1655E-04_JPRB,3.9053E-04_JPRB,4.3489E-04_JPRB,4.6069E-04_JPRB,4.7295E-04_JPRB,4.7284E-04_JPRB,&
 & 4.6063E-04_JPRB,4.3290E-04_JPRB,3.7673E-04_JPRB/)  
KAO( :, 3, 6, 7) = (/&
 & 3.1898E-04_JPRB,4.0060E-04_JPRB,4.4896E-04_JPRB,4.7714E-04_JPRB,4.9199E-04_JPRB,4.9458E-04_JPRB,&
 & 4.8353E-04_JPRB,4.5629E-04_JPRB,3.9672E-04_JPRB/)  
KAO( :, 4, 6, 7) = (/&
 & 3.2158E-04_JPRB,4.1129E-04_JPRB,4.6291E-04_JPRB,4.9376E-04_JPRB,5.1129E-04_JPRB,5.1624E-04_JPRB,&
 & 5.0719E-04_JPRB,4.8049E-04_JPRB,4.1801E-04_JPRB/)  
KAO( :, 5, 6, 7) = (/&
 & 3.2502E-04_JPRB,4.2183E-04_JPRB,4.7677E-04_JPRB,5.1073E-04_JPRB,5.3095E-04_JPRB,5.3777E-04_JPRB,&
 & 5.3107E-04_JPRB,5.0560E-04_JPRB,4.4095E-04_JPRB/)  
KAO( :, 1, 7, 7) = (/&
 & 2.8858E-04_JPRB,3.5072E-04_JPRB,3.8244E-04_JPRB,3.9969E-04_JPRB,4.0628E-04_JPRB,4.0266E-04_JPRB,&
 & 3.8820E-04_JPRB,3.6095E-04_JPRB,3.4917E-04_JPRB/)  
KAO( :, 2, 7, 7) = (/&
 & 2.9154E-04_JPRB,3.5995E-04_JPRB,3.9513E-04_JPRB,4.1562E-04_JPRB,4.2428E-04_JPRB,4.2225E-04_JPRB,&
 & 4.0848E-04_JPRB,3.8100E-04_JPRB,3.6556E-04_JPRB/)  
KAO( :, 3, 7, 7) = (/&
 & 2.9427E-04_JPRB,3.6955E-04_JPRB,4.0818E-04_JPRB,4.3070E-04_JPRB,4.4206E-04_JPRB,4.4209E-04_JPRB,&
 & 4.2902E-04_JPRB,4.0153E-04_JPRB,3.8273E-04_JPRB/)  
KAO( :, 4, 7, 7) = (/&
 & 2.9693E-04_JPRB,3.7937E-04_JPRB,4.2130E-04_JPRB,4.4602E-04_JPRB,4.5975E-04_JPRB,4.6189E-04_JPRB,&
 & 4.5029E-04_JPRB,4.2249E-04_JPRB,4.0122E-04_JPRB/)  
KAO( :, 5, 7, 7) = (/&
 & 3.0032E-04_JPRB,3.8893E-04_JPRB,4.3431E-04_JPRB,4.6164E-04_JPRB,4.7805E-04_JPRB,4.8151E-04_JPRB,&
 & 4.7139E-04_JPRB,4.4430E-04_JPRB,4.2113E-04_JPRB/)  
KAO( :, 1, 8, 7) = (/&
 & 2.6433E-04_JPRB,3.2164E-04_JPRB,3.4678E-04_JPRB,3.5895E-04_JPRB,3.6313E-04_JPRB,3.5828E-04_JPRB,&
 & 3.4379E-04_JPRB,3.1784E-04_JPRB,3.8325E-04_JPRB/)  
KAO( :, 2, 8, 7) = (/&
 & 2.6764E-04_JPRB,3.3079E-04_JPRB,3.5818E-04_JPRB,3.7326E-04_JPRB,3.7969E-04_JPRB,3.7570E-04_JPRB,&
 & 3.6173E-04_JPRB,3.3531E-04_JPRB,3.9627E-04_JPRB/)  
KAO( :, 3, 8, 7) = (/&
 & 2.7049E-04_JPRB,3.3967E-04_JPRB,3.6984E-04_JPRB,3.8764E-04_JPRB,3.9567E-04_JPRB,3.9347E-04_JPRB,&
 & 3.7992E-04_JPRB,3.5345E-04_JPRB,4.1157E-04_JPRB/)  
KAO( :, 4, 8, 7) = (/&
 & 2.7332E-04_JPRB,3.4840E-04_JPRB,3.8188E-04_JPRB,4.0186E-04_JPRB,4.1166E-04_JPRB,4.1115E-04_JPRB,&
 & 3.9867E-04_JPRB,3.7201E-04_JPRB,4.2882E-04_JPRB/)  
KAO( :, 5, 8, 7) = (/&
 & 2.7670E-04_JPRB,3.5697E-04_JPRB,3.9392E-04_JPRB,4.1633E-04_JPRB,4.2814E-04_JPRB,4.2877E-04_JPRB,&
 & 4.1760E-04_JPRB,3.9091E-04_JPRB,4.4711E-04_JPRB/)  
KAO( :, 1, 9, 7) = (/&
 & 2.4137E-04_JPRB,2.9350E-04_JPRB,3.1375E-04_JPRB,3.2233E-04_JPRB,3.2400E-04_JPRB,3.1859E-04_JPRB,&
 & 3.0441E-04_JPRB,2.7946E-04_JPRB,7.4112E-04_JPRB/)  
KAO( :, 2, 9, 7) = (/&
 & 2.4480E-04_JPRB,3.0210E-04_JPRB,3.2420E-04_JPRB,3.3517E-04_JPRB,3.3871E-04_JPRB,3.3414E-04_JPRB,&
 & 3.2021E-04_JPRB,2.9498E-04_JPRB,7.2877E-04_JPRB/)  
KAO( :, 3, 9, 7) = (/&
 & 2.4785E-04_JPRB,3.1022E-04_JPRB,3.3497E-04_JPRB,3.4812E-04_JPRB,3.5338E-04_JPRB,3.4970E-04_JPRB,&
 & 3.3648E-04_JPRB,3.1095E-04_JPRB,7.2183E-04_JPRB/)  
KAO( :, 4, 9, 7) = (/&
 & 2.5068E-04_JPRB,3.1830E-04_JPRB,3.4602E-04_JPRB,3.6150E-04_JPRB,3.6764E-04_JPRB,3.6525E-04_JPRB,&
 & 3.5301E-04_JPRB,3.2741E-04_JPRB,7.2069E-04_JPRB/)  
KAO( :, 5, 9, 7) = (/&
 & 2.5395E-04_JPRB,3.2629E-04_JPRB,3.5706E-04_JPRB,3.7496E-04_JPRB,3.8230E-04_JPRB,3.8101E-04_JPRB,&
 & 3.6964E-04_JPRB,3.4426E-04_JPRB,7.2393E-04_JPRB/)  
KAO( :, 1,10, 7) = (/&
 & 2.1916E-04_JPRB,2.6728E-04_JPRB,2.8357E-04_JPRB,2.9003E-04_JPRB,2.9019E-04_JPRB,2.8394E-04_JPRB,&
 & 2.6987E-04_JPRB,2.4557E-04_JPRB,2.2951E-03_JPRB/)  
KAO( :, 2,10, 7) = (/&
 & 2.2269E-04_JPRB,2.7508E-04_JPRB,2.9328E-04_JPRB,3.0170E-04_JPRB,3.0330E-04_JPRB,2.9810E-04_JPRB,&
 & 2.8439E-04_JPRB,2.5963E-04_JPRB,2.1937E-03_JPRB/)  
KAO( :, 3,10, 7) = (/&
 & 2.2592E-04_JPRB,2.8247E-04_JPRB,3.0321E-04_JPRB,3.1354E-04_JPRB,3.1659E-04_JPRB,3.1208E-04_JPRB,&
 & 2.9880E-04_JPRB,2.7415E-04_JPRB,2.1089E-03_JPRB/)  
KAO( :, 4,10, 7) = (/&
 & 2.2891E-04_JPRB,2.8992E-04_JPRB,3.1332E-04_JPRB,3.2558E-04_JPRB,3.2968E-04_JPRB,3.2576E-04_JPRB,&
 & 3.1353E-04_JPRB,2.8898E-04_JPRB,2.0353E-03_JPRB/)  
KAO( :, 5,10, 7) = (/&
 & 2.3224E-04_JPRB,2.9740E-04_JPRB,3.2354E-04_JPRB,3.3796E-04_JPRB,3.4280E-04_JPRB,3.3971E-04_JPRB,&
 & 3.2827E-04_JPRB,3.0414E-04_JPRB,1.9694E-03_JPRB/)  
KAO( :, 1,11, 7) = (/&
 & 1.9917E-04_JPRB,2.4536E-04_JPRB,2.5993E-04_JPRB,2.6557E-04_JPRB,2.6515E-04_JPRB,2.5837E-04_JPRB,&
 & 2.4462E-04_JPRB,2.2066E-04_JPRB,3.1341E-03_JPRB/)  
KAO( :, 2,11, 7) = (/&
 & 2.0264E-04_JPRB,2.5224E-04_JPRB,2.6895E-04_JPRB,2.7632E-04_JPRB,2.7737E-04_JPRB,2.7142E-04_JPRB,&
 & 2.5767E-04_JPRB,2.3346E-04_JPRB,2.9845E-03_JPRB/)  
KAO( :, 3,11, 7) = (/&
 & 2.0597E-04_JPRB,2.5913E-04_JPRB,2.7799E-04_JPRB,2.8723E-04_JPRB,2.8930E-04_JPRB,2.8411E-04_JPRB,&
 & 2.7068E-04_JPRB,2.4666E-04_JPRB,2.8531E-03_JPRB/)  
KAO( :, 4,11, 7) = (/&
 & 2.0923E-04_JPRB,2.6606E-04_JPRB,2.8717E-04_JPRB,2.9817E-04_JPRB,3.0130E-04_JPRB,2.9662E-04_JPRB,&
 & 2.8382E-04_JPRB,2.6011E-04_JPRB,2.7344E-03_JPRB/)  
KAO( :, 5,11, 7) = (/&
 & 2.1283E-04_JPRB,2.7325E-04_JPRB,2.9677E-04_JPRB,3.0938E-04_JPRB,3.1326E-04_JPRB,3.0919E-04_JPRB,&
 & 2.9712E-04_JPRB,2.7384E-04_JPRB,2.6277E-03_JPRB/)  
KAO( :, 1,12, 7) = (/&
 & 1.7936E-04_JPRB,2.2328E-04_JPRB,2.3724E-04_JPRB,2.4243E-04_JPRB,2.4172E-04_JPRB,2.3478E-04_JPRB,&
 & 2.2093E-04_JPRB,1.9737E-04_JPRB,3.2835E-03_JPRB/)  
KAO( :, 2,12, 7) = (/&
 & 1.8285E-04_JPRB,2.2978E-04_JPRB,2.4543E-04_JPRB,2.5241E-04_JPRB,2.5294E-04_JPRB,2.4651E-04_JPRB,&
 & 2.3266E-04_JPRB,2.0912E-04_JPRB,3.1216E-03_JPRB/)  
KAO( :, 3,12, 7) = (/&
 & 1.8634E-04_JPRB,2.3640E-04_JPRB,2.5382E-04_JPRB,2.6232E-04_JPRB,2.6378E-04_JPRB,2.5795E-04_JPRB,&
 & 2.4444E-04_JPRB,2.2095E-04_JPRB,2.9752E-03_JPRB/)  
KAO( :, 4,12, 7) = (/&
 & 1.8978E-04_JPRB,2.4319E-04_JPRB,2.6232E-04_JPRB,2.7232E-04_JPRB,2.7477E-04_JPRB,2.6960E-04_JPRB,&
 & 2.5603E-04_JPRB,2.3306E-04_JPRB,2.8433E-03_JPRB/)  
KAO( :, 5,12, 7) = (/&
 & 1.9368E-04_JPRB,2.5043E-04_JPRB,2.7137E-04_JPRB,2.8261E-04_JPRB,2.8588E-04_JPRB,2.8109E-04_JPRB,&
 & 2.6784E-04_JPRB,2.4548E-04_JPRB,2.7264E-03_JPRB/)  
KAO( :, 1,13, 7) = (/&
 & 1.6014E-04_JPRB,2.0144E-04_JPRB,2.1482E-04_JPRB,2.1993E-04_JPRB,2.1918E-04_JPRB,2.1245E-04_JPRB,&
 & 1.9850E-04_JPRB,1.7572E-04_JPRB,2.8014E-03_JPRB/)  
KAO( :, 2,13, 7) = (/&
 & 1.6372E-04_JPRB,2.0772E-04_JPRB,2.2263E-04_JPRB,2.2918E-04_JPRB,2.2929E-04_JPRB,2.2295E-04_JPRB,&
 & 2.0909E-04_JPRB,1.8627E-04_JPRB,2.6597E-03_JPRB/)  
KAO( :, 3,13, 7) = (/&
 & 1.6711E-04_JPRB,2.1423E-04_JPRB,2.3053E-04_JPRB,2.3833E-04_JPRB,2.3922E-04_JPRB,2.3334E-04_JPRB,&
 & 2.1968E-04_JPRB,1.9695E-04_JPRB,2.5327E-03_JPRB/)  
KAO( :, 4,13, 7) = (/&
 & 1.7075E-04_JPRB,2.2099E-04_JPRB,2.3863E-04_JPRB,2.4766E-04_JPRB,2.4941E-04_JPRB,2.4382E-04_JPRB,&
 & 2.3022E-04_JPRB,2.0776E-04_JPRB,2.4204E-03_JPRB/)  
KAO( :, 5,13, 7) = (/&
 & 1.7481E-04_JPRB,2.2827E-04_JPRB,2.4735E-04_JPRB,2.5731E-04_JPRB,2.5972E-04_JPRB,2.5434E-04_JPRB,&
 & 2.4101E-04_JPRB,2.1916E-04_JPRB,2.3207E-03_JPRB/)  
KAO( :, 1, 1, 8) = (/&
 & 9.5608E-04_JPRB,1.1137E-03_JPRB,1.1928E-03_JPRB,1.2676E-03_JPRB,1.3453E-03_JPRB,1.4201E-03_JPRB,&
 & 1.4858E-03_JPRB,1.4985E-03_JPRB,1.3296E-03_JPRB/)  
KAO( :, 2, 1, 8) = (/&
 & 9.5994E-04_JPRB,1.1580E-03_JPRB,1.2586E-03_JPRB,1.3444E-03_JPRB,1.4304E-03_JPRB,1.5065E-03_JPRB,&
 & 1.5698E-03_JPRB,1.5822E-03_JPRB,1.4127E-03_JPRB/)  
KAO( :, 3, 1, 8) = (/&
 & 9.6434E-04_JPRB,1.2039E-03_JPRB,1.3295E-03_JPRB,1.4283E-03_JPRB,1.5240E-03_JPRB,1.6021E-03_JPRB,&
 & 1.6610E-03_JPRB,1.6690E-03_JPRB,1.4964E-03_JPRB/)  
KAO( :, 4, 1, 8) = (/&
 & 9.6594E-04_JPRB,1.2459E-03_JPRB,1.3992E-03_JPRB,1.5151E-03_JPRB,1.6213E-03_JPRB,1.7037E-03_JPRB,&
 & 1.7586E-03_JPRB,1.7581E-03_JPRB,1.5822E-03_JPRB/)  
KAO( :, 5, 1, 8) = (/&
 & 9.7112E-04_JPRB,1.2922E-03_JPRB,1.4733E-03_JPRB,1.6088E-03_JPRB,1.7251E-03_JPRB,1.8137E-03_JPRB,&
 & 1.8637E-03_JPRB,1.8544E-03_JPRB,1.6729E-03_JPRB/)  
KAO( :, 1, 2, 8) = (/&
 & 9.2093E-04_JPRB,1.0546E-03_JPRB,1.1184E-03_JPRB,1.1877E-03_JPRB,1.2677E-03_JPRB,1.3451E-03_JPRB,&
 & 1.4085E-03_JPRB,1.4282E-03_JPRB,1.2587E-03_JPRB/)  
KAO( :, 2, 2, 8) = (/&
 & 9.2391E-04_JPRB,1.0934E-03_JPRB,1.1705E-03_JPRB,1.2485E-03_JPRB,1.3345E-03_JPRB,1.4205E-03_JPRB,&
 & 1.4904E-03_JPRB,1.5108E-03_JPRB,1.3375E-03_JPRB/)  
KAO( :, 3, 2, 8) = (/&
 & 9.2775E-04_JPRB,1.1328E-03_JPRB,1.2272E-03_JPRB,1.3169E-03_JPRB,1.4101E-03_JPRB,1.5006E-03_JPRB,&
 & 1.5743E-03_JPRB,1.5928E-03_JPRB,1.4152E-03_JPRB/)  
KAO( :, 4, 2, 8) = (/&
 & 9.3033E-04_JPRB,1.1705E-03_JPRB,1.2842E-03_JPRB,1.3889E-03_JPRB,1.4909E-03_JPRB,1.5847E-03_JPRB,&
 & 1.6559E-03_JPRB,1.6749E-03_JPRB,1.4953E-03_JPRB/)  
KAO( :, 5, 2, 8) = (/&
 & 9.3350E-04_JPRB,1.2078E-03_JPRB,1.3426E-03_JPRB,1.4642E-03_JPRB,1.5755E-03_JPRB,1.6738E-03_JPRB,&
 & 1.7416E-03_JPRB,1.7599E-03_JPRB,1.5794E-03_JPRB/)  
KAO( :, 1, 3, 8) = (/&
 & 8.8225E-04_JPRB,9.9524E-04_JPRB,1.0564E-03_JPRB,1.1307E-03_JPRB,1.2003E-03_JPRB,1.2591E-03_JPRB,&
 & 1.3108E-03_JPRB,1.3309E-03_JPRB,1.1549E-03_JPRB/)  
KAO( :, 2, 3, 8) = (/&
 & 8.8537E-04_JPRB,1.0284E-03_JPRB,1.0990E-03_JPRB,1.1784E-03_JPRB,1.2595E-03_JPRB,1.3310E-03_JPRB,&
 & 1.3892E-03_JPRB,1.4138E-03_JPRB,1.2306E-03_JPRB/)  
KAO( :, 3, 3, 8) = (/&
 & 8.8781E-04_JPRB,1.0600E-03_JPRB,1.1442E-03_JPRB,1.2314E-03_JPRB,1.3222E-03_JPRB,1.4061E-03_JPRB,&
 & 1.4693E-03_JPRB,1.4932E-03_JPRB,1.3048E-03_JPRB/)  
KAO( :, 4, 3, 8) = (/&
 & 8.9189E-04_JPRB,1.0939E-03_JPRB,1.1921E-03_JPRB,1.2907E-03_JPRB,1.3886E-03_JPRB,1.4820E-03_JPRB,&
 & 1.5492E-03_JPRB,1.5703E-03_JPRB,1.3811E-03_JPRB/)  
KAO( :, 5, 3, 8) = (/&
 & 8.9438E-04_JPRB,1.1258E-03_JPRB,1.2397E-03_JPRB,1.3504E-03_JPRB,1.4556E-03_JPRB,1.5581E-03_JPRB,&
 & 1.6301E-03_JPRB,1.6498E-03_JPRB,1.4607E-03_JPRB/)  
KAO( :, 1, 4, 8) = (/&
 & 8.3849E-04_JPRB,9.3566E-04_JPRB,1.0099E-03_JPRB,1.0816E-03_JPRB,1.1344E-03_JPRB,1.1752E-03_JPRB,&
 & 1.2048E-03_JPRB,1.2139E-03_JPRB,1.0399E-03_JPRB/)  
KAO( :, 2, 4, 8) = (/&
 & 8.4244E-04_JPRB,9.6570E-04_JPRB,1.0454E-03_JPRB,1.1259E-03_JPRB,1.1888E-03_JPRB,1.2423E-03_JPRB,&
 & 1.2800E-03_JPRB,1.2943E-03_JPRB,1.1122E-03_JPRB/)  
KAO( :, 3, 4, 8) = (/&
 & 8.4472E-04_JPRB,9.9456E-04_JPRB,1.0829E-03_JPRB,1.1722E-03_JPRB,1.2472E-03_JPRB,1.3102E-03_JPRB,&
 & 1.3565E-03_JPRB,1.3722E-03_JPRB,1.1831E-03_JPRB/)  
KAO( :, 4, 4, 8) = (/&
 & 8.4703E-04_JPRB,1.0229E-03_JPRB,1.1215E-03_JPRB,1.2221E-03_JPRB,1.3077E-03_JPRB,1.3778E-03_JPRB,&
 & 1.4318E-03_JPRB,1.4488E-03_JPRB,1.2549E-03_JPRB/)  
KAO( :, 5, 4, 8) = (/&
 & 8.5239E-04_JPRB,1.0541E-03_JPRB,1.1634E-03_JPRB,1.2735E-03_JPRB,1.3695E-03_JPRB,1.4485E-03_JPRB,&
 & 1.5090E-03_JPRB,1.5277E-03_JPRB,1.3292E-03_JPRB/)  
KAO( :, 1, 5, 8) = (/&
 & 7.9083E-04_JPRB,8.8170E-04_JPRB,9.6674E-04_JPRB,1.0299E-03_JPRB,1.0698E-03_JPRB,1.0915E-03_JPRB,&
 & 1.0968E-03_JPRB,1.0912E-03_JPRB,9.3090E-04_JPRB/)  
KAO( :, 2, 5, 8) = (/&
 & 7.9562E-04_JPRB,9.0868E-04_JPRB,9.9995E-04_JPRB,1.0720E-03_JPRB,1.1213E-03_JPRB,1.1526E-03_JPRB,&
 & 1.1662E-03_JPRB,1.1662E-03_JPRB,9.9625E-04_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART5',1,ZHOOK_HANDLE)
END SUBROUTINE PART5


SUBROUTINE PART6

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART6',0,ZHOOK_HANDLE)


KAO( :, 3, 5, 8) = (/&
 & 7.9829E-04_JPRB,9.3547E-04_JPRB,1.0342E-03_JPRB,1.1161E-03_JPRB,1.1759E-03_JPRB,1.2152E-03_JPRB,&
 & 1.2368E-03_JPRB,1.2405E-03_JPRB,1.0609E-03_JPRB/)  
KAO( :, 4, 5, 8) = (/&
 & 8.0091E-04_JPRB,9.6089E-04_JPRB,1.0686E-03_JPRB,1.1624E-03_JPRB,1.2313E-03_JPRB,1.2778E-03_JPRB,&
 & 1.3076E-03_JPRB,1.3141E-03_JPRB,1.1274E-03_JPRB/)  
KAO( :, 5, 5, 8) = (/&
 & 8.0636E-04_JPRB,9.8796E-04_JPRB,1.1047E-03_JPRB,1.2088E-03_JPRB,1.2883E-03_JPRB,1.3425E-03_JPRB,&
 & 1.3805E-03_JPRB,1.3900E-03_JPRB,1.1960E-03_JPRB/)  
KAO( :, 1, 6, 8) = (/&
 & 7.4042E-04_JPRB,8.3357E-04_JPRB,9.1717E-04_JPRB,9.7114E-04_JPRB,1.0002E-03_JPRB,1.0057E-03_JPRB,&
 & 9.9270E-04_JPRB,9.6792E-04_JPRB,8.3659E-04_JPRB/)  
KAO( :, 2, 6, 8) = (/&
 & 7.4565E-04_JPRB,8.5743E-04_JPRB,9.4912E-04_JPRB,1.0119E-03_JPRB,1.0480E-03_JPRB,1.0602E-03_JPRB,&
 & 1.0545E-03_JPRB,1.0369E-03_JPRB,8.9582E-04_JPRB/)  
KAO( :, 3, 6, 8) = (/&
 & 7.4922E-04_JPRB,8.8128E-04_JPRB,9.8142E-04_JPRB,1.0542E-03_JPRB,1.0980E-03_JPRB,1.1167E-03_JPRB,&
 & 1.1185E-03_JPRB,1.1056E-03_JPRB,9.5443E-04_JPRB/)  
KAO( :, 4, 6, 8) = (/&
 & 7.5232E-04_JPRB,9.0308E-04_JPRB,1.0141E-03_JPRB,1.0981E-03_JPRB,1.1486E-03_JPRB,1.1744E-03_JPRB,&
 & 1.1833E-03_JPRB,1.1741E-03_JPRB,1.0132E-03_JPRB/)  
KAO( :, 5, 6, 8) = (/&
 & 7.5627E-04_JPRB,9.2523E-04_JPRB,1.0466E-03_JPRB,1.1406E-03_JPRB,1.2001E-03_JPRB,1.2335E-03_JPRB,&
 & 1.2490E-03_JPRB,1.2439E-03_JPRB,1.0736E-03_JPRB/)  
KAO( :, 1, 7, 8) = (/&
 & 6.8964E-04_JPRB,7.8723E-04_JPRB,8.6407E-04_JPRB,9.0570E-04_JPRB,9.2461E-04_JPRB,9.2134E-04_JPRB,&
 & 8.9655E-04_JPRB,8.5470E-04_JPRB,7.7227E-04_JPRB/)  
KAO( :, 2, 7, 8) = (/&
 & 6.9565E-04_JPRB,8.0904E-04_JPRB,8.9444E-04_JPRB,9.4366E-04_JPRB,9.6915E-04_JPRB,9.7063E-04_JPRB,&
 & 9.5066E-04_JPRB,9.1508E-04_JPRB,8.2464E-04_JPRB/)  
KAO( :, 3, 7, 8) = (/&
 & 7.0042E-04_JPRB,8.3032E-04_JPRB,9.2461E-04_JPRB,9.8296E-04_JPRB,1.0152E-03_JPRB,1.0214E-03_JPRB,&
 & 1.0076E-03_JPRB,9.7640E-04_JPRB,8.7766E-04_JPRB/)  
KAO( :, 4, 7, 8) = (/&
 & 7.0426E-04_JPRB,8.4981E-04_JPRB,9.5485E-04_JPRB,1.0240E-03_JPRB,1.0623E-03_JPRB,1.0734E-03_JPRB,&
 & 1.0651E-03_JPRB,1.0378E-03_JPRB,9.3187E-04_JPRB/)  
KAO( :, 5, 7, 8) = (/&
 & 7.0821E-04_JPRB,8.6946E-04_JPRB,9.8537E-04_JPRB,1.0646E-03_JPRB,1.1098E-03_JPRB,1.1263E-03_JPRB,&
 & 1.1245E-03_JPRB,1.1007E-03_JPRB,9.8663E-04_JPRB/)  
KAO( :, 1, 8, 8) = (/&
 & 6.4047E-04_JPRB,7.3858E-04_JPRB,8.0453E-04_JPRB,8.3694E-04_JPRB,8.4619E-04_JPRB,8.3765E-04_JPRB,&
 & 8.0766E-04_JPRB,7.5466E-04_JPRB,8.2781E-04_JPRB/)  
KAO( :, 2, 8, 8) = (/&
 & 6.4742E-04_JPRB,7.5904E-04_JPRB,8.3405E-04_JPRB,8.7266E-04_JPRB,8.8676E-04_JPRB,8.8236E-04_JPRB,&
 & 8.5570E-04_JPRB,8.0688E-04_JPRB,8.7433E-04_JPRB/)  
KAO( :, 3, 8, 8) = (/&
 & 6.5283E-04_JPRB,7.7980E-04_JPRB,8.6316E-04_JPRB,9.0850E-04_JPRB,9.2898E-04_JPRB,9.2841E-04_JPRB,&
 & 9.0551E-04_JPRB,8.6048E-04_JPRB,9.2376E-04_JPRB/)  
KAO( :, 4, 8, 8) = (/&
 & 6.5707E-04_JPRB,7.9894E-04_JPRB,8.9224E-04_JPRB,9.4602E-04_JPRB,9.7258E-04_JPRB,9.7562E-04_JPRB,&
 & 9.5565E-04_JPRB,9.1442E-04_JPRB,9.7371E-04_JPRB/)  
KAO( :, 5, 8, 8) = (/&
 & 6.6119E-04_JPRB,8.1764E-04_JPRB,9.2118E-04_JPRB,9.8357E-04_JPRB,1.0164E-03_JPRB,1.0233E-03_JPRB,&
 & 1.0075E-03_JPRB,9.7011E-04_JPRB,1.0250E-03_JPRB/)  
KAO( :, 1, 9, 8) = (/&
 & 5.9304E-04_JPRB,6.8835E-04_JPRB,7.4179E-04_JPRB,7.6634E-04_JPRB,7.7050E-04_JPRB,7.5604E-04_JPRB,&
 & 7.2393E-04_JPRB,6.6767E-04_JPRB,1.3527E-03_JPRB/)  
KAO( :, 2, 9, 8) = (/&
 & 6.0061E-04_JPRB,7.0826E-04_JPRB,7.7005E-04_JPRB,7.9970E-04_JPRB,8.0682E-04_JPRB,7.9622E-04_JPRB,&
 & 7.6713E-04_JPRB,7.1229E-04_JPRB,1.3810E-03_JPRB/)  
KAO( :, 3, 9, 8) = (/&
 & 6.0690E-04_JPRB,7.2826E-04_JPRB,7.9782E-04_JPRB,8.3277E-04_JPRB,8.4414E-04_JPRB,8.3763E-04_JPRB,&
 & 8.1182E-04_JPRB,7.5863E-04_JPRB,1.4228E-03_JPRB/)  
KAO( :, 4, 9, 8) = (/&
 & 6.1167E-04_JPRB,7.4710E-04_JPRB,8.2533E-04_JPRB,8.6687E-04_JPRB,8.8342E-04_JPRB,8.8028E-04_JPRB,&
 & 8.5678E-04_JPRB,8.0590E-04_JPRB,1.4759E-03_JPRB/)  
KAO( :, 5, 9, 8) = (/&
 & 6.1627E-04_JPRB,7.6539E-04_JPRB,8.5255E-04_JPRB,9.0125E-04_JPRB,9.2320E-04_JPRB,9.2321E-04_JPRB,&
 & 9.0266E-04_JPRB,8.5442E-04_JPRB,1.5365E-03_JPRB/)  
KAO( :, 1,10, 8) = (/&
 & 5.4825E-04_JPRB,6.3891E-04_JPRB,6.8254E-04_JPRB,7.0037E-04_JPRB,6.9928E-04_JPRB,6.8268E-04_JPRB,&
 & 6.4957E-04_JPRB,5.9476E-04_JPRB,3.8180E-03_JPRB/)  
KAO( :, 2,10, 8) = (/&
 & 5.5676E-04_JPRB,6.5829E-04_JPRB,7.0890E-04_JPRB,7.3100E-04_JPRB,7.3257E-04_JPRB,7.1817E-04_JPRB,&
 & 6.8748E-04_JPRB,6.3344E-04_JPRB,3.7319E-03_JPRB/)  
KAO( :, 3,10, 8) = (/&
 & 5.6387E-04_JPRB,6.7778E-04_JPRB,7.3493E-04_JPRB,7.6099E-04_JPRB,7.6595E-04_JPRB,7.5519E-04_JPRB,&
 & 7.2717E-04_JPRB,6.7342E-04_JPRB,3.6841E-03_JPRB/)  
KAO( :, 4,10, 8) = (/&
 & 5.6965E-04_JPRB,6.9628E-04_JPRB,7.6095E-04_JPRB,7.9168E-04_JPRB,8.0061E-04_JPRB,7.9369E-04_JPRB,&
 & 7.6769E-04_JPRB,7.1402E-04_JPRB,3.6718E-03_JPRB/)  
KAO( :, 5,10, 8) = (/&
 & 5.7483E-04_JPRB,7.1426E-04_JPRB,7.8640E-04_JPRB,8.2247E-04_JPRB,8.3634E-04_JPRB,8.3289E-04_JPRB,&
 & 8.0894E-04_JPRB,7.5561E-04_JPRB,3.6884E-03_JPRB/)  
KAO( :, 1,11, 8) = (/&
 & 5.0971E-04_JPRB,5.9908E-04_JPRB,6.3716E-04_JPRB,6.5075E-04_JPRB,6.4646E-04_JPRB,6.2883E-04_JPRB,&
 & 5.9611E-04_JPRB,5.4516E-04_JPRB,5.2044E-03_JPRB/)  
KAO( :, 2,11, 8) = (/&
 & 5.1851E-04_JPRB,6.1830E-04_JPRB,6.6103E-04_JPRB,6.7814E-04_JPRB,6.7644E-04_JPRB,6.6100E-04_JPRB,&
 & 6.3054E-04_JPRB,5.7922E-04_JPRB,5.0472E-03_JPRB/)  
KAO( :, 3,11, 8) = (/&
 & 5.2576E-04_JPRB,6.3685E-04_JPRB,6.8508E-04_JPRB,7.0561E-04_JPRB,7.0702E-04_JPRB,6.9454E-04_JPRB,&
 & 6.6622E-04_JPRB,6.1448E-04_JPRB,4.9485E-03_JPRB/)  
KAO( :, 4,11, 8) = (/&
 & 5.3230E-04_JPRB,6.5426E-04_JPRB,7.0906E-04_JPRB,7.3336E-04_JPRB,7.3854E-04_JPRB,7.2917E-04_JPRB,&
 & 7.0247E-04_JPRB,6.5031E-04_JPRB,4.8945E-03_JPRB/)  
KAO( :, 5,11, 8) = (/&
 & 5.3825E-04_JPRB,6.7152E-04_JPRB,7.3265E-04_JPRB,7.6088E-04_JPRB,7.7057E-04_JPRB,7.6479E-04_JPRB,&
 & 7.3945E-04_JPRB,6.8664E-04_JPRB,4.8718E-03_JPRB/)  
KAO( :, 1,12, 8) = (/&
 & 4.7268E-04_JPRB,5.5911E-04_JPRB,5.9221E-04_JPRB,6.0202E-04_JPRB,5.9599E-04_JPRB,5.7673E-04_JPRB,&
 & 5.4567E-04_JPRB,4.9766E-04_JPRB,5.4784E-03_JPRB/)  
KAO( :, 2,12, 8) = (/&
 & 4.8142E-04_JPRB,5.7788E-04_JPRB,6.1435E-04_JPRB,6.2655E-04_JPRB,6.2325E-04_JPRB,6.0670E-04_JPRB,&
 & 5.7673E-04_JPRB,5.2800E-04_JPRB,5.3059E-03_JPRB/)  
KAO( :, 3,12, 8) = (/&
 & 4.8905E-04_JPRB,5.9521E-04_JPRB,6.3638E-04_JPRB,6.5188E-04_JPRB,6.5138E-04_JPRB,6.3718E-04_JPRB,&
 & 6.0852E-04_JPRB,5.5928E-04_JPRB,5.1929E-03_JPRB/)  
KAO( :, 4,12, 8) = (/&
 & 4.9586E-04_JPRB,6.1204E-04_JPRB,6.5810E-04_JPRB,6.7725E-04_JPRB,6.7983E-04_JPRB,6.6800E-04_JPRB,&
 & 6.4102E-04_JPRB,5.9098E-04_JPRB,5.1181E-03_JPRB/)  
KAO( :, 5,12, 8) = (/&
 & 5.0219E-04_JPRB,6.2893E-04_JPRB,6.7933E-04_JPRB,7.0239E-04_JPRB,7.0829E-04_JPRB,6.9992E-04_JPRB,&
 & 6.7457E-04_JPRB,6.2315E-04_JPRB,5.0659E-03_JPRB/)  
KAO( :, 1,13, 8) = (/&
 & 4.3613E-04_JPRB,5.1896E-04_JPRB,5.4757E-04_JPRB,5.5450E-04_JPRB,5.4716E-04_JPRB,5.2848E-04_JPRB,&
 & 4.9828E-04_JPRB,4.5179E-04_JPRB,4.7039E-03_JPRB/)  
KAO( :, 2,13, 8) = (/&
 & 4.4480E-04_JPRB,5.3652E-04_JPRB,5.6828E-04_JPRB,5.7733E-04_JPRB,5.7232E-04_JPRB,5.5571E-04_JPRB,&
 & 5.2643E-04_JPRB,4.7940E-04_JPRB,4.5588E-03_JPRB/)  
KAO( :, 3,13, 8) = (/&
 & 4.5255E-04_JPRB,5.5296E-04_JPRB,5.8851E-04_JPRB,6.0068E-04_JPRB,5.9826E-04_JPRB,5.8320E-04_JPRB,&
 & 5.5480E-04_JPRB,5.0729E-04_JPRB,4.4582E-03_JPRB/)  
KAO( :, 4,13, 8) = (/&
 & 4.5948E-04_JPRB,5.6913E-04_JPRB,6.0860E-04_JPRB,6.2380E-04_JPRB,6.2384E-04_JPRB,6.1098E-04_JPRB,&
 & 5.8363E-04_JPRB,5.3555E-04_JPRB,4.3840E-03_JPRB/)  
KAO( :, 5,13, 8) = (/&
 & 4.6648E-04_JPRB,5.8526E-04_JPRB,6.2843E-04_JPRB,6.4682E-04_JPRB,6.4977E-04_JPRB,6.3953E-04_JPRB,&
 & 6.1349E-04_JPRB,5.6436E-04_JPRB,4.3301E-03_JPRB/)  
KAO( :, 1, 1, 9) = (/&
 & 4.2634E-03_JPRB,4.4619E-03_JPRB,4.8277E-03_JPRB,5.0574E-03_JPRB,5.1432E-03_JPRB,5.0824E-03_JPRB,&
 & 4.7995E-03_JPRB,4.2519E-03_JPRB,3.6751E-03_JPRB/)  
KAO( :, 2, 1, 9) = (/&
 & 4.3896E-03_JPRB,4.7056E-03_JPRB,5.1713E-03_JPRB,5.4539E-03_JPRB,5.5796E-03_JPRB,5.5445E-03_JPRB,&
 & 5.2467E-03_JPRB,4.6622E-03_JPRB,4.1226E-03_JPRB/)  
KAO( :, 3, 1, 9) = (/&
 & 4.5152E-03_JPRB,4.9543E-03_JPRB,5.5160E-03_JPRB,5.8544E-03_JPRB,6.0168E-03_JPRB,5.9967E-03_JPRB,&
 & 5.6895E-03_JPRB,5.0855E-03_JPRB,4.6113E-03_JPRB/)  
KAO( :, 4, 1, 9) = (/&
 & 4.6230E-03_JPRB,5.1933E-03_JPRB,5.8501E-03_JPRB,6.2450E-03_JPRB,6.4433E-03_JPRB,6.4316E-03_JPRB,&
 & 6.1283E-03_JPRB,5.5148E-03_JPRB,5.1307E-03_JPRB/)  
KAO( :, 5, 1, 9) = (/&
 & 4.7302E-03_JPRB,5.4309E-03_JPRB,6.1815E-03_JPRB,6.6303E-03_JPRB,6.8597E-03_JPRB,6.8605E-03_JPRB,&
 & 6.5693E-03_JPRB,5.9487E-03_JPRB,5.6753E-03_JPRB/)  
KAO( :, 1, 2, 9) = (/&
 & 3.9323E-03_JPRB,4.1568E-03_JPRB,4.4806E-03_JPRB,4.6618E-03_JPRB,4.7304E-03_JPRB,4.6715E-03_JPRB,&
 & 4.4161E-03_JPRB,3.9503E-03_JPRB,3.3395E-03_JPRB/)  
KAO( :, 2, 2, 9) = (/&
 & 4.0500E-03_JPRB,4.3934E-03_JPRB,4.8123E-03_JPRB,5.0480E-03_JPRB,5.1574E-03_JPRB,5.1013E-03_JPRB,&
 & 4.8274E-03_JPRB,4.3142E-03_JPRB,3.7073E-03_JPRB/)  
KAO( :, 3, 2, 9) = (/&
 & 4.1698E-03_JPRB,4.6359E-03_JPRB,5.1475E-03_JPRB,5.4370E-03_JPRB,5.5831E-03_JPRB,5.5288E-03_JPRB,&
 & 5.2416E-03_JPRB,4.6953E-03_JPRB,4.1146E-03_JPRB/)  
KAO( :, 4, 2, 9) = (/&
 & 4.2783E-03_JPRB,4.8739E-03_JPRB,5.4745E-03_JPRB,5.8228E-03_JPRB,5.9955E-03_JPRB,5.9514E-03_JPRB,&
 & 5.6672E-03_JPRB,5.0790E-03_JPRB,4.5488E-03_JPRB/)  
KAO( :, 5, 2, 9) = (/&
 & 4.3743E-03_JPRB,5.1081E-03_JPRB,5.7929E-03_JPRB,6.1965E-03_JPRB,6.3958E-03_JPRB,6.3715E-03_JPRB,&
 & 6.0950E-03_JPRB,5.4684E-03_JPRB,5.0068E-03_JPRB/)  
KAO( :, 1, 3, 9) = (/&
 & 3.6113E-03_JPRB,3.8183E-03_JPRB,4.0778E-03_JPRB,4.1984E-03_JPRB,4.2534E-03_JPRB,4.2158E-03_JPRB,&
 & 4.0193E-03_JPRB,3.6415E-03_JPRB,3.0570E-03_JPRB/)  
KAO( :, 2, 3, 9) = (/&
 & 3.7209E-03_JPRB,4.0412E-03_JPRB,4.3896E-03_JPRB,4.5667E-03_JPRB,4.6475E-03_JPRB,4.5983E-03_JPRB,&
 & 4.3872E-03_JPRB,3.9635E-03_JPRB,3.3466E-03_JPRB/)  
KAO( :, 3, 3, 9) = (/&
 & 3.8298E-03_JPRB,4.2704E-03_JPRB,4.6995E-03_JPRB,4.9388E-03_JPRB,5.0426E-03_JPRB,4.9845E-03_JPRB,&
 & 4.7617E-03_JPRB,4.3009E-03_JPRB,3.6653E-03_JPRB/)  
KAO( :, 4, 3, 9) = (/&
 & 3.9362E-03_JPRB,4.5071E-03_JPRB,5.0123E-03_JPRB,5.3097E-03_JPRB,5.4362E-03_JPRB,5.3784E-03_JPRB,&
 & 5.1527E-03_JPRB,4.6419E-03_JPRB,4.0116E-03_JPRB/)  
KAO( :, 5, 3, 9) = (/&
 & 4.0246E-03_JPRB,4.7366E-03_JPRB,5.3187E-03_JPRB,5.6677E-03_JPRB,5.8209E-03_JPRB,5.7784E-03_JPRB,&
 & 5.5482E-03_JPRB,4.9812E-03_JPRB,4.3840E-03_JPRB/)  
KAO( :, 1, 4, 9) = (/&
 & 3.3284E-03_JPRB,3.4973E-03_JPRB,3.6827E-03_JPRB,3.7696E-03_JPRB,3.8145E-03_JPRB,3.7973E-03_JPRB,&
 & 3.6757E-03_JPRB,3.3953E-03_JPRB,2.8711E-03_JPRB/)  
KAO( :, 2, 4, 9) = (/&
 & 3.4305E-03_JPRB,3.7049E-03_JPRB,3.9652E-03_JPRB,4.1049E-03_JPRB,4.1671E-03_JPRB,4.1383E-03_JPRB,&
 & 3.9965E-03_JPRB,3.6722E-03_JPRB,3.0945E-03_JPRB/)  
KAO( :, 3, 4, 9) = (/&
 & 3.5295E-03_JPRB,3.9206E-03_JPRB,4.2522E-03_JPRB,4.4452E-03_JPRB,4.5189E-03_JPRB,4.4874E-03_JPRB,&
 & 4.3285E-03_JPRB,3.9676E-03_JPRB,3.3441E-03_JPRB/)  
KAO( :, 4, 4, 9) = (/&
 & 3.6215E-03_JPRB,4.1396E-03_JPRB,4.5422E-03_JPRB,4.7812E-03_JPRB,4.8736E-03_JPRB,4.8440E-03_JPRB,&
 & 4.6768E-03_JPRB,4.2674E-03_JPRB,3.6212E-03_JPRB/)  
KAO( :, 5, 4, 9) = (/&
 & 3.7121E-03_JPRB,4.3594E-03_JPRB,4.8380E-03_JPRB,5.1176E-03_JPRB,5.2295E-03_JPRB,5.2140E-03_JPRB,&
 & 5.0347E-03_JPRB,4.5696E-03_JPRB,3.9241E-03_JPRB/)  
KAO( :, 1, 5, 9) = (/&
 & 3.0937E-03_JPRB,3.2190E-03_JPRB,3.3382E-03_JPRB,3.4069E-03_JPRB,3.4508E-03_JPRB,3.4576E-03_JPRB,&
 & 3.4038E-03_JPRB,3.2121E-03_JPRB,2.7159E-03_JPRB/)  
KAO( :, 2, 5, 9) = (/&
 & 3.1841E-03_JPRB,3.4102E-03_JPRB,3.5885E-03_JPRB,3.6988E-03_JPRB,3.7561E-03_JPRB,3.7570E-03_JPRB,&
 & 3.6806E-03_JPRB,3.4524E-03_JPRB,2.9248E-03_JPRB/)  
KAO( :, 3, 5, 9) = (/&
 & 3.2704E-03_JPRB,3.6051E-03_JPRB,3.8485E-03_JPRB,3.9980E-03_JPRB,4.0672E-03_JPRB,4.0649E-03_JPRB,&
 & 3.9688E-03_JPRB,3.7070E-03_JPRB,3.1394E-03_JPRB/)  
KAO( :, 4, 5, 9) = (/&
 & 3.3530E-03_JPRB,3.8023E-03_JPRB,4.1127E-03_JPRB,4.2944E-03_JPRB,4.3822E-03_JPRB,4.3830E-03_JPRB,&
 & 4.2728E-03_JPRB,3.9665E-03_JPRB,3.3644E-03_JPRB/)  
KAO( :, 5, 5, 9) = (/&
 & 3.4386E-03_JPRB,4.0026E-03_JPRB,4.3842E-03_JPRB,4.5975E-03_JPRB,4.7014E-03_JPRB,4.7133E-03_JPRB,&
 & 4.5874E-03_JPRB,4.2339E-03_JPRB,3.6103E-03_JPRB/)  
KAO( :, 1, 6, 9) = (/&
 & 2.9009E-03_JPRB,2.9757E-03_JPRB,3.0499E-03_JPRB,3.1038E-03_JPRB,3.1541E-03_JPRB,3.1847E-03_JPRB,&
 & 3.1836E-03_JPRB,3.0557E-03_JPRB,2.5583E-03_JPRB/)  
KAO( :, 2, 6, 9) = (/&
 & 2.9774E-03_JPRB,3.1460E-03_JPRB,3.2679E-03_JPRB,3.3537E-03_JPRB,3.4147E-03_JPRB,3.4421E-03_JPRB,&
 & 3.4203E-03_JPRB,3.2723E-03_JPRB,2.7519E-03_JPRB/)  
KAO( :, 3, 6, 9) = (/&
 & 3.0522E-03_JPRB,3.3185E-03_JPRB,3.4964E-03_JPRB,3.6100E-03_JPRB,3.6827E-03_JPRB,3.7087E-03_JPRB,&
 & 3.6668E-03_JPRB,3.4927E-03_JPRB,2.9536E-03_JPRB/)  
KAO( :, 4, 6, 9) = (/&
 & 3.1282E-03_JPRB,3.4957E-03_JPRB,3.7291E-03_JPRB,3.8695E-03_JPRB,3.9556E-03_JPRB,3.9847E-03_JPRB,&
 & 3.9266E-03_JPRB,3.7176E-03_JPRB,3.1650E-03_JPRB/)  
KAO( :, 5, 6, 9) = (/&
 & 3.1999E-03_JPRB,3.6746E-03_JPRB,3.9646E-03_JPRB,4.1331E-03_JPRB,4.2341E-03_JPRB,4.2712E-03_JPRB,&
 & 4.1979E-03_JPRB,3.9512E-03_JPRB,3.3876E-03_JPRB/)  
KAO( :, 1, 7, 9) = (/&
 & 2.7415E-03_JPRB,2.7746E-03_JPRB,2.8210E-03_JPRB,2.8741E-03_JPRB,2.9327E-03_JPRB,2.9829E-03_JPRB,&
 & 2.9928E-03_JPRB,2.8802E-03_JPRB,2.4517E-03_JPRB/)  
KAO( :, 2, 7, 9) = (/&
 & 2.8079E-03_JPRB,2.9223E-03_JPRB,3.0084E-03_JPRB,3.0853E-03_JPRB,3.1485E-03_JPRB,3.1999E-03_JPRB,&
 & 3.2078E-03_JPRB,3.0910E-03_JPRB,2.6310E-03_JPRB/)  
KAO( :, 3, 7, 9) = (/&
 & 2.8746E-03_JPRB,3.0732E-03_JPRB,3.2043E-03_JPRB,3.3040E-03_JPRB,3.3751E-03_JPRB,3.4239E-03_JPRB,&
 & 3.4236E-03_JPRB,3.2999E-03_JPRB,2.8151E-03_JPRB/)  
KAO( :, 4, 7, 9) = (/&
 & 2.9412E-03_JPRB,3.2304E-03_JPRB,3.4053E-03_JPRB,3.5266E-03_JPRB,3.6086E-03_JPRB,3.6573E-03_JPRB,&
 & 3.6460E-03_JPRB,3.5085E-03_JPRB,3.0037E-03_JPRB/)  
KAO( :, 5, 7, 9) = (/&
 & 3.0012E-03_JPRB,3.3903E-03_JPRB,3.6088E-03_JPRB,3.7519E-03_JPRB,3.8465E-03_JPRB,3.9004E-03_JPRB,&
 & 3.8789E-03_JPRB,3.7197E-03_JPRB,3.2035E-03_JPRB/)  
KAO( :, 1, 8, 9) = (/&
 & 2.6011E-03_JPRB,2.6087E-03_JPRB,2.6505E-03_JPRB,2.7115E-03_JPRB,2.7795E-03_JPRB,2.8145E-03_JPRB,&
 & 2.7964E-03_JPRB,2.6829E-03_JPRB,2.5124E-03_JPRB/)  
KAO( :, 2, 8, 9) = (/&
 & 2.6605E-03_JPRB,2.7384E-03_JPRB,2.8102E-03_JPRB,2.8876E-03_JPRB,2.9588E-03_JPRB,3.0106E-03_JPRB,&
 & 2.9995E-03_JPRB,2.8886E-03_JPRB,2.6866E-03_JPRB/)  
KAO( :, 3, 8, 9) = (/&
 & 2.7221E-03_JPRB,2.8708E-03_JPRB,2.9770E-03_JPRB,3.0697E-03_JPRB,3.1469E-03_JPRB,3.2045E-03_JPRB,&
 & 3.2054E-03_JPRB,3.0872E-03_JPRB,2.8608E-03_JPRB/)  
KAO( :, 4, 8, 9) = (/&
 & 2.7814E-03_JPRB,3.0087E-03_JPRB,3.1469E-03_JPRB,3.2564E-03_JPRB,3.3407E-03_JPRB,3.4007E-03_JPRB,&
 & 3.4134E-03_JPRB,3.2854E-03_JPRB,3.0367E-03_JPRB/)  
KAO( :, 5, 8, 9) = (/&
 & 2.8334E-03_JPRB,3.1463E-03_JPRB,3.3224E-03_JPRB,3.4471E-03_JPRB,3.5390E-03_JPRB,3.6049E-03_JPRB,&
 & 3.6218E-03_JPRB,3.4862E-03_JPRB,3.2148E-03_JPRB/)  
KAO( :, 1, 9, 9) = (/&
 & 2.4681E-03_JPRB,2.4670E-03_JPRB,2.5193E-03_JPRB,2.5927E-03_JPRB,2.6437E-03_JPRB,2.6462E-03_JPRB,&
 & 2.5937E-03_JPRB,2.4688E-03_JPRB,4.0106E-03_JPRB/)  
KAO( :, 2, 9, 9) = (/&
 & 2.5243E-03_JPRB,2.5823E-03_JPRB,2.6553E-03_JPRB,2.7401E-03_JPRB,2.8086E-03_JPRB,2.8274E-03_JPRB,&
 & 2.7863E-03_JPRB,2.6637E-03_JPRB,4.1870E-03_JPRB/)  
KAO( :, 3, 9, 9) = (/&
 & 2.5817E-03_JPRB,2.6985E-03_JPRB,2.7975E-03_JPRB,2.8934E-03_JPRB,2.9743E-03_JPRB,3.0076E-03_JPRB,&
 & 2.9804E-03_JPRB,2.8541E-03_JPRB,4.3637E-03_JPRB/)  
KAO( :, 4, 9, 9) = (/&
 & 2.6357E-03_JPRB,2.8178E-03_JPRB,2.9439E-03_JPRB,3.0496E-03_JPRB,3.1384E-03_JPRB,3.1881E-03_JPRB,&
 & 3.1729E-03_JPRB,3.0435E-03_JPRB,4.5427E-03_JPRB/)  
KAO( :, 5, 9, 9) = (/&
 & 2.6826E-03_JPRB,2.9379E-03_JPRB,3.0923E-03_JPRB,3.2096E-03_JPRB,3.3016E-03_JPRB,3.3682E-03_JPRB,&
 & 3.3659E-03_JPRB,3.2338E-03_JPRB,4.7326E-03_JPRB/)  
KAO( :, 1,10, 9) = (/&
 & 2.3365E-03_JPRB,2.3445E-03_JPRB,2.4180E-03_JPRB,2.4933E-03_JPRB,2.5143E-03_JPRB,2.4864E-03_JPRB,&
 & 2.4076E-03_JPRB,2.2631E-03_JPRB,1.0002E-02_JPRB/)  
KAO( :, 2,10, 9) = (/&
 & 2.3916E-03_JPRB,2.4482E-03_JPRB,2.5366E-03_JPRB,2.6275E-03_JPRB,2.6688E-03_JPRB,2.6554E-03_JPRB,&
 & 2.5866E-03_JPRB,2.4438E-03_JPRB,1.0188E-02_JPRB/)  
KAO( :, 3,10, 9) = (/&
 & 2.4458E-03_JPRB,2.5525E-03_JPRB,2.6602E-03_JPRB,2.7640E-03_JPRB,2.8222E-03_JPRB,2.8241E-03_JPRB,&
 & 2.7676E-03_JPRB,2.6219E-03_JPRB,1.0447E-02_JPRB/)  
KAO( :, 4,10, 9) = (/&
 & 2.4945E-03_JPRB,2.6579E-03_JPRB,2.7873E-03_JPRB,2.8998E-03_JPRB,2.9729E-03_JPRB,2.9898E-03_JPRB,&
 & 2.9465E-03_JPRB,2.7998E-03_JPRB,1.0769E-02_JPRB/)  
KAO( :, 5,10, 9) = (/&
 & 2.5382E-03_JPRB,2.7637E-03_JPRB,2.9128E-03_JPRB,3.0348E-03_JPRB,3.1210E-03_JPRB,3.1536E-03_JPRB,&
 & 3.1245E-03_JPRB,2.9806E-03_JPRB,1.1144E-02_JPRB/)  
KAO( :, 1,11, 9) = (/&
 & 2.2189E-03_JPRB,2.2637E-03_JPRB,2.3663E-03_JPRB,2.4375E-03_JPRB,2.4436E-03_JPRB,2.3971E-03_JPRB,&
 & 2.2998E-03_JPRB,2.1349E-03_JPRB,1.4165E-02_JPRB/)  
KAO( :, 2,11, 9) = (/&
 & 2.2725E-03_JPRB,2.3594E-03_JPRB,2.4775E-03_JPRB,2.5648E-03_JPRB,2.5873E-03_JPRB,2.5525E-03_JPRB,&
 & 2.4655E-03_JPRB,2.2999E-03_JPRB,1.4362E-02_JPRB/)  
KAO( :, 3,11, 9) = (/&
 & 2.3225E-03_JPRB,2.4563E-03_JPRB,2.5905E-03_JPRB,2.6905E-03_JPRB,2.7282E-03_JPRB,2.7081E-03_JPRB,&
 & 2.6314E-03_JPRB,2.4622E-03_JPRB,1.4689E-02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART6',1,ZHOOK_HANDLE)
END SUBROUTINE PART6


SUBROUTINE PART7

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART7',0,ZHOOK_HANDLE)


KAO( :, 4,11, 9) = (/&
 & 2.3671E-03_JPRB,2.5537E-03_JPRB,2.7011E-03_JPRB,2.8153E-03_JPRB,2.8667E-03_JPRB,2.8616E-03_JPRB,&
 & 2.7947E-03_JPRB,2.6271E-03_JPRB,1.5129E-02_JPRB/)  
KAO( :, 5,11, 9) = (/&
 & 2.4082E-03_JPRB,2.6482E-03_JPRB,2.8083E-03_JPRB,2.9363E-03_JPRB,3.0040E-03_JPRB,3.0155E-03_JPRB,&
 & 2.9597E-03_JPRB,2.7977E-03_JPRB,1.5652E-02_JPRB/)  
KAO( :, 1,12, 9) = (/&
 & 2.0910E-03_JPRB,2.1698E-03_JPRB,2.2939E-03_JPRB,2.3579E-03_JPRB,2.3558E-03_JPRB,2.2934E-03_JPRB,&
 & 2.1816E-03_JPRB,2.0022E-03_JPRB,1.5828E-02_JPRB/)  
KAO( :, 2,12, 9) = (/&
 & 2.1414E-03_JPRB,2.2595E-03_JPRB,2.4019E-03_JPRB,2.4797E-03_JPRB,2.4872E-03_JPRB,2.4364E-03_JPRB,&
 & 2.3325E-03_JPRB,2.1497E-03_JPRB,1.6052E-02_JPRB/)  
KAO( :, 3,12, 9) = (/&
 & 2.1876E-03_JPRB,2.3512E-03_JPRB,2.5089E-03_JPRB,2.5983E-03_JPRB,2.6170E-03_JPRB,2.5791E-03_JPRB,&
 & 2.4816E-03_JPRB,2.2977E-03_JPRB,1.6424E-02_JPRB/)  
KAO( :, 4,12, 9) = (/&
 & 2.2305E-03_JPRB,2.4411E-03_JPRB,2.6103E-03_JPRB,2.7123E-03_JPRB,2.7468E-03_JPRB,2.7221E-03_JPRB,&
 & 2.6302E-03_JPRB,2.4491E-03_JPRB,1.6928E-02_JPRB/)  
KAO( :, 5,12, 9) = (/&
 & 2.2685E-03_JPRB,2.5264E-03_JPRB,2.7071E-03_JPRB,2.8237E-03_JPRB,2.8760E-03_JPRB,2.8651E-03_JPRB,&
 & 2.7812E-03_JPRB,2.6061E-03_JPRB,1.7523E-02_JPRB/)  
KAO( :, 1,13, 9) = (/&
 & 1.9577E-03_JPRB,2.0704E-03_JPRB,2.2038E-03_JPRB,2.2584E-03_JPRB,2.2491E-03_JPRB,2.1789E-03_JPRB,&
 & 2.0585E-03_JPRB,1.8702E-03_JPRB,1.4483E-02_JPRB/)  
KAO( :, 2,13, 9) = (/&
 & 2.0058E-03_JPRB,2.1546E-03_JPRB,2.3069E-03_JPRB,2.3735E-03_JPRB,2.3721E-03_JPRB,2.3101E-03_JPRB,&
 & 2.1933E-03_JPRB,2.0001E-03_JPRB,1.4716E-02_JPRB/)  
KAO( :, 3,13, 9) = (/&
 & 2.0506E-03_JPRB,2.2392E-03_JPRB,2.4060E-03_JPRB,2.4864E-03_JPRB,2.4932E-03_JPRB,2.4402E-03_JPRB,&
 & 2.3277E-03_JPRB,2.1324E-03_JPRB,1.5081E-02_JPRB/)  
KAO( :, 4,13, 9) = (/&
 & 2.0915E-03_JPRB,2.3209E-03_JPRB,2.5015E-03_JPRB,2.5952E-03_JPRB,2.6152E-03_JPRB,2.5711E-03_JPRB,&
 & 2.4622E-03_JPRB,2.2684E-03_JPRB,1.5556E-02_JPRB/)  
KAO( :, 5,13, 9) = (/&
 & 2.1275E-03_JPRB,2.3984E-03_JPRB,2.5936E-03_JPRB,2.7019E-03_JPRB,2.7369E-03_JPRB,2.7034E-03_JPRB,&
 & 2.5998E-03_JPRB,2.4103E-03_JPRB,1.6100E-02_JPRB/)  
KAO( :, 1, 1,10) = (/&
 & 1.7685E-02_JPRB,1.5886E-02_JPRB,1.5286E-02_JPRB,1.4910E-02_JPRB,1.4213E-02_JPRB,1.2872E-02_JPRB,&
 & 1.1554E-02_JPRB,9.7299E-03_JPRB,9.7670E-03_JPRB/)  
KAO( :, 2, 1,10) = (/&
 & 1.7924E-02_JPRB,1.6198E-02_JPRB,1.5800E-02_JPRB,1.5762E-02_JPRB,1.5013E-02_JPRB,1.3648E-02_JPRB,&
 & 1.2502E-02_JPRB,1.0682E-02_JPRB,1.1264E-02_JPRB/)  
KAO( :, 3, 1,10) = (/&
 & 1.8162E-02_JPRB,1.6493E-02_JPRB,1.6320E-02_JPRB,1.6501E-02_JPRB,1.5785E-02_JPRB,1.4461E-02_JPRB,&
 & 1.3394E-02_JPRB,1.1688E-02_JPRB,1.2766E-02_JPRB/)  
KAO( :, 4, 1,10) = (/&
 & 1.8373E-02_JPRB,1.6799E-02_JPRB,1.6869E-02_JPRB,1.7132E-02_JPRB,1.6537E-02_JPRB,1.5302E-02_JPRB,&
 & 1.4231E-02_JPRB,1.2873E-02_JPRB,1.4298E-02_JPRB/)  
KAO( :, 5, 1,10) = (/&
 & 1.8575E-02_JPRB,1.7109E-02_JPRB,1.7449E-02_JPRB,1.7721E-02_JPRB,1.7274E-02_JPRB,1.6125E-02_JPRB,&
 & 1.4995E-02_JPRB,1.4230E-02_JPRB,1.5931E-02_JPRB/)  
KAO( :, 1, 2,10) = (/&
 & 1.6873E-02_JPRB,1.5273E-02_JPRB,1.4928E-02_JPRB,1.4779E-02_JPRB,1.3931E-02_JPRB,1.2662E-02_JPRB,&
 & 1.1382E-02_JPRB,9.2864E-03_JPRB,8.6917E-03_JPRB/)  
KAO( :, 2, 2,10) = (/&
 & 1.7158E-02_JPRB,1.5636E-02_JPRB,1.5517E-02_JPRB,1.5568E-02_JPRB,1.4735E-02_JPRB,1.3617E-02_JPRB,&
 & 1.2343E-02_JPRB,1.0165E-02_JPRB,1.0091E-02_JPRB/)  
KAO( :, 3, 2,10) = (/&
 & 1.7424E-02_JPRB,1.6018E-02_JPRB,1.6130E-02_JPRB,1.6288E-02_JPRB,1.5522E-02_JPRB,1.4562E-02_JPRB,&
 & 1.3276E-02_JPRB,1.1047E-02_JPRB,1.1539E-02_JPRB/)  
KAO( :, 4, 2,10) = (/&
 & 1.7705E-02_JPRB,1.6391E-02_JPRB,1.6775E-02_JPRB,1.6913E-02_JPRB,1.6383E-02_JPRB,1.5440E-02_JPRB,&
 & 1.4111E-02_JPRB,1.2115E-02_JPRB,1.3109E-02_JPRB/)  
KAO( :, 5, 2,10) = (/&
 & 1.7946E-02_JPRB,1.6730E-02_JPRB,1.7389E-02_JPRB,1.7560E-02_JPRB,1.7230E-02_JPRB,1.6260E-02_JPRB,&
 & 1.4862E-02_JPRB,1.3377E-02_JPRB,1.4792E-02_JPRB/)  
KAO( :, 1, 3,10) = (/&
 & 1.5798E-02_JPRB,1.4431E-02_JPRB,1.4230E-02_JPRB,1.4159E-02_JPRB,1.3349E-02_JPRB,1.2204E-02_JPRB,&
 & 1.0867E-02_JPRB,8.8000E-03_JPRB,7.4513E-03_JPRB/)  
KAO( :, 2, 3,10) = (/&
 & 1.6121E-02_JPRB,1.4897E-02_JPRB,1.4916E-02_JPRB,1.4922E-02_JPRB,1.4162E-02_JPRB,1.3251E-02_JPRB,&
 & 1.1847E-02_JPRB,9.5823E-03_JPRB,8.7330E-03_JPRB/)  
KAO( :, 3, 3,10) = (/&
 & 1.6462E-02_JPRB,1.5342E-02_JPRB,1.5618E-02_JPRB,1.5620E-02_JPRB,1.5015E-02_JPRB,1.4282E-02_JPRB,&
 & 1.2797E-02_JPRB,1.0384E-02_JPRB,1.0179E-02_JPRB/)  
KAO( :, 4, 3,10) = (/&
 & 1.6798E-02_JPRB,1.5765E-02_JPRB,1.6290E-02_JPRB,1.6289E-02_JPRB,1.5973E-02_JPRB,1.5269E-02_JPRB,&
 & 1.3672E-02_JPRB,1.1383E-02_JPRB,1.1725E-02_JPRB/)  
KAO( :, 5, 3,10) = (/&
 & 1.7062E-02_JPRB,1.6131E-02_JPRB,1.6868E-02_JPRB,1.7006E-02_JPRB,1.6890E-02_JPRB,1.6143E-02_JPRB,&
 & 1.4482E-02_JPRB,1.2538E-02_JPRB,1.3312E-02_JPRB/)  
KAO( :, 1, 4,10) = (/&
 & 1.4564E-02_JPRB,1.3497E-02_JPRB,1.3366E-02_JPRB,1.3251E-02_JPRB,1.2600E-02_JPRB,1.1517E-02_JPRB,&
 & 1.0115E-02_JPRB,8.2572E-03_JPRB,6.3788E-03_JPRB/)  
KAO( :, 2, 4,10) = (/&
 & 1.4956E-02_JPRB,1.4021E-02_JPRB,1.4143E-02_JPRB,1.3989E-02_JPRB,1.3446E-02_JPRB,1.2579E-02_JPRB,&
 & 1.1185E-02_JPRB,9.0656E-03_JPRB,7.4847E-03_JPRB/)  
KAO( :, 3, 4,10) = (/&
 & 1.5366E-02_JPRB,1.4523E-02_JPRB,1.4865E-02_JPRB,1.4686E-02_JPRB,1.4396E-02_JPRB,1.3630E-02_JPRB,&
 & 1.2209E-02_JPRB,9.8300E-03_JPRB,8.7484E-03_JPRB/)  
KAO( :, 4, 4,10) = (/&
 & 1.5673E-02_JPRB,1.4963E-02_JPRB,1.5538E-02_JPRB,1.5419E-02_JPRB,1.5384E-02_JPRB,1.4661E-02_JPRB,&
 & 1.3123E-02_JPRB,1.0681E-02_JPRB,1.0095E-02_JPRB/)  
KAO( :, 5, 4,10) = (/&
 & 1.5927E-02_JPRB,1.5374E-02_JPRB,1.6106E-02_JPRB,1.6246E-02_JPRB,1.6331E-02_JPRB,1.5570E-02_JPRB,&
 & 1.3997E-02_JPRB,1.1612E-02_JPRB,1.1475E-02_JPRB/)  
KAO( :, 1, 5,10) = (/&
 & 1.3266E-02_JPRB,1.2466E-02_JPRB,1.2400E-02_JPRB,1.2242E-02_JPRB,1.1629E-02_JPRB,1.0628E-02_JPRB,&
 & 9.2898E-03_JPRB,7.6240E-03_JPRB,5.9670E-03_JPRB/)  
KAO( :, 2, 5,10) = (/&
 & 1.3732E-02_JPRB,1.3052E-02_JPRB,1.3208E-02_JPRB,1.3005E-02_JPRB,1.2522E-02_JPRB,1.1685E-02_JPRB,&
 & 1.0389E-02_JPRB,8.4463E-03_JPRB,6.6100E-03_JPRB/)  
KAO( :, 3, 5,10) = (/&
 & 1.4084E-02_JPRB,1.3547E-02_JPRB,1.3938E-02_JPRB,1.3750E-02_JPRB,1.3484E-02_JPRB,1.2725E-02_JPRB,&
 & 1.1484E-02_JPRB,9.2095E-03_JPRB,7.5100E-03_JPRB/)  
KAO( :, 4, 5,10) = (/&
 & 1.4380E-02_JPRB,1.4005E-02_JPRB,1.4577E-02_JPRB,1.4581E-02_JPRB,1.4467E-02_JPRB,1.3764E-02_JPRB,&
 & 1.2436E-02_JPRB,1.0053E-02_JPRB,8.5649E-03_JPRB/)  
KAO( :, 5, 5,10) = (/&
 & 1.4640E-02_JPRB,1.4480E-02_JPRB,1.5153E-02_JPRB,1.5470E-02_JPRB,1.5438E-02_JPRB,1.4721E-02_JPRB,&
 & 1.3356E-02_JPRB,1.0839E-02_JPRB,9.6988E-03_JPRB/)  
KAO( :, 1, 6,10) = (/&
 & 1.1942E-02_JPRB,1.1353E-02_JPRB,1.1339E-02_JPRB,1.1150E-02_JPRB,1.0468E-02_JPRB,9.5854E-03_JPRB,&
 & 8.3811E-03_JPRB,7.0885E-03_JPRB,5.8798E-03_JPRB/)  
KAO( :, 2, 6,10) = (/&
 & 1.2358E-02_JPRB,1.1922E-02_JPRB,1.2141E-02_JPRB,1.1920E-02_JPRB,1.1378E-02_JPRB,1.0610E-02_JPRB,&
 & 9.4501E-03_JPRB,7.7713E-03_JPRB,6.4066E-03_JPRB/)  
KAO( :, 3, 6,10) = (/&
 & 1.2698E-02_JPRB,1.2427E-02_JPRB,1.2838E-02_JPRB,1.2735E-02_JPRB,1.2366E-02_JPRB,1.1633E-02_JPRB,&
 & 1.0517E-02_JPRB,8.4962E-03_JPRB,6.9615E-03_JPRB/)  
KAO( :, 4, 6,10) = (/&
 & 1.2998E-02_JPRB,1.2956E-02_JPRB,1.3432E-02_JPRB,1.3603E-02_JPRB,1.3351E-02_JPRB,1.2693E-02_JPRB,&
 & 1.1517E-02_JPRB,9.2932E-03_JPRB,7.5694E-03_JPRB/)  
KAO( :, 5, 6,10) = (/&
 & 1.3245E-02_JPRB,1.3459E-02_JPRB,1.4045E-02_JPRB,1.4501E-02_JPRB,1.4340E-02_JPRB,1.3672E-02_JPRB,&
 & 1.2434E-02_JPRB,1.0037E-02_JPRB,8.3088E-03_JPRB/)  
KAO( :, 1, 7,10) = (/&
 & 1.0635E-02_JPRB,1.0181E-02_JPRB,1.0247E-02_JPRB,9.9535E-03_JPRB,9.2688E-03_JPRB,8.4744E-03_JPRB,&
 & 7.6731E-03_JPRB,6.9595E-03_JPRB,5.7767E-03_JPRB/)  
KAO( :, 2, 7,10) = (/&
 & 1.1001E-02_JPRB,1.0731E-02_JPRB,1.1001E-02_JPRB,1.0727E-02_JPRB,1.0196E-02_JPRB,9.4273E-03_JPRB,&
 & 8.5283E-03_JPRB,7.4633E-03_JPRB,6.2551E-03_JPRB/)  
KAO( :, 3, 7,10) = (/&
 & 1.1326E-02_JPRB,1.1289E-02_JPRB,1.1647E-02_JPRB,1.1559E-02_JPRB,1.1156E-02_JPRB,1.0455E-02_JPRB,&
 & 9.4847E-03_JPRB,7.9997E-03_JPRB,6.7556E-03_JPRB/)  
KAO( :, 4, 7,10) = (/&
 & 1.1605E-02_JPRB,1.1840E-02_JPRB,1.2266E-02_JPRB,1.2419E-02_JPRB,1.2130E-02_JPRB,1.1514E-02_JPRB,&
 & 1.0422E-02_JPRB,8.6046E-03_JPRB,7.2812E-03_JPRB/)  
KAO( :, 5, 7,10) = (/&
 & 1.1846E-02_JPRB,1.2301E-02_JPRB,1.2939E-02_JPRB,1.3278E-02_JPRB,1.3141E-02_JPRB,1.2520E-02_JPRB,&
 & 1.1309E-02_JPRB,9.2291E-03_JPRB,7.8135E-03_JPRB/)  
KAO( :, 1, 8,10) = (/&
 & 9.5318E-03_JPRB,9.1400E-03_JPRB,9.1541E-03_JPRB,8.7469E-03_JPRB,8.1107E-03_JPRB,7.6844E-03_JPRB,&
 & 7.4790E-03_JPRB,6.8560E-03_JPRB,6.1100E-03_JPRB/)  
KAO( :, 2, 8,10) = (/&
 & 9.8513E-03_JPRB,9.6543E-03_JPRB,9.8221E-03_JPRB,9.4930E-03_JPRB,8.9990E-03_JPRB,8.4087E-03_JPRB,&
 & 8.1002E-03_JPRB,7.3297E-03_JPRB,6.5036E-03_JPRB/)  
KAO( :, 3, 8,10) = (/&
 & 1.0121E-02_JPRB,1.0183E-02_JPRB,1.0429E-02_JPRB,1.0295E-02_JPRB,9.9219E-03_JPRB,9.3052E-03_JPRB,&
 & 8.7495E-03_JPRB,7.8409E-03_JPRB,6.8133E-03_JPRB/)  
KAO( :, 4, 8,10) = (/&
 & 1.0342E-02_JPRB,1.0668E-02_JPRB,1.1072E-02_JPRB,1.1128E-02_JPRB,1.0881E-02_JPRB,1.0314E-02_JPRB,&
 & 9.4319E-03_JPRB,8.3379E-03_JPRB,7.1719E-03_JPRB/)  
KAO( :, 5, 8,10) = (/&
 & 1.0574E-02_JPRB,1.1111E-02_JPRB,1.1730E-02_JPRB,1.1969E-02_JPRB,1.1864E-02_JPRB,1.1283E-02_JPRB,&
 & 1.0148E-02_JPRB,8.8068E-03_JPRB,7.6246E-03_JPRB/)  
KAO( :, 1, 9,10) = (/&
 & 8.6979E-03_JPRB,8.3079E-03_JPRB,8.1722E-03_JPRB,7.6777E-03_JPRB,7.3529E-03_JPRB,7.3690E-03_JPRB,&
 & 7.3422E-03_JPRB,6.6830E-03_JPRB,8.5832E-03_JPRB/)  
KAO( :, 2, 9,10) = (/&
 & 8.9724E-03_JPRB,8.7731E-03_JPRB,8.7419E-03_JPRB,8.3348E-03_JPRB,7.9939E-03_JPRB,7.9020E-03_JPRB,&
 & 7.8887E-03_JPRB,7.1655E-03_JPRB,9.0283E-03_JPRB/)  
KAO( :, 3, 9,10) = (/&
 & 9.1636E-03_JPRB,9.2350E-03_JPRB,9.2903E-03_JPRB,9.0718E-03_JPRB,8.7389E-03_JPRB,8.5612E-03_JPRB,&
 & 8.4201E-03_JPRB,7.6462E-03_JPRB,9.4969E-03_JPRB/)  
KAO( :, 4, 9,10) = (/&
 & 9.3430E-03_JPRB,9.6411E-03_JPRB,9.8735E-03_JPRB,9.8458E-03_JPRB,9.5925E-03_JPRB,9.3082E-03_JPRB,&
 & 8.9479E-03_JPRB,8.0999E-03_JPRB,9.9701E-03_JPRB/)  
KAO( :, 5, 9,10) = (/&
 & 9.5543E-03_JPRB,1.0034E-02_JPRB,1.0504E-02_JPRB,1.0652E-02_JPRB,1.0546E-02_JPRB,1.0105E-02_JPRB,&
 & 9.4548E-03_JPRB,8.5503E-03_JPRB,1.0439E-02_JPRB/)  
KAO( :, 1,10,10) = (/&
 & 8.1157E-03_JPRB,7.6953E-03_JPRB,7.3856E-03_JPRB,7.0143E-03_JPRB,7.0934E-03_JPRB,7.1592E-03_JPRB,&
 & 7.1366E-03_JPRB,6.4736E-03_JPRB,2.5288E-02_JPRB/)  
KAO( :, 2,10,10) = (/&
 & 8.3228E-03_JPRB,8.1050E-03_JPRB,7.8899E-03_JPRB,7.5150E-03_JPRB,7.5383E-03_JPRB,7.6577E-03_JPRB,&
 & 7.6569E-03_JPRB,6.9536E-03_JPRB,2.5969E-02_JPRB/)  
KAO( :, 3,10,10) = (/&
 & 8.4638E-03_JPRB,8.4927E-03_JPRB,8.3732E-03_JPRB,8.1065E-03_JPRB,8.0674E-03_JPRB,8.2304E-03_JPRB,&
 & 8.1217E-03_JPRB,7.4527E-03_JPRB,2.6813E-02_JPRB/)  
KAO( :, 4,10,10) = (/&
 & 8.6251E-03_JPRB,8.8393E-03_JPRB,8.8777E-03_JPRB,8.7542E-03_JPRB,8.7078E-03_JPRB,8.8286E-03_JPRB,&
 & 8.6165E-03_JPRB,7.9058E-03_JPRB,2.7708E-02_JPRB/)  
KAO( :, 5,10,10) = (/&
 & 8.7883E-03_JPRB,9.2004E-03_JPRB,9.4445E-03_JPRB,9.4717E-03_JPRB,9.4479E-03_JPRB,9.4125E-03_JPRB,&
 & 9.0956E-03_JPRB,8.3203E-03_JPRB,2.8653E-02_JPRB/)  
KAO( :, 1,11,10) = (/&
 & 7.8501E-03_JPRB,7.4452E-03_JPRB,7.0342E-03_JPRB,6.9004E-03_JPRB,7.0570E-03_JPRB,7.1201E-03_JPRB,&
 & 7.0476E-03_JPRB,6.4243E-03_JPRB,4.0572E-02_JPRB/)  
KAO( :, 2,11,10) = (/&
 & 7.9753E-03_JPRB,7.7749E-03_JPRB,7.4240E-03_JPRB,7.3009E-03_JPRB,7.4854E-03_JPRB,7.6408E-03_JPRB,&
 & 7.5205E-03_JPRB,6.9049E-03_JPRB,4.1441E-02_JPRB/)  
KAO( :, 3,11,10) = (/&
 & 8.0806E-03_JPRB,8.0563E-03_JPRB,7.8316E-03_JPRB,7.7518E-03_JPRB,7.9930E-03_JPRB,8.1574E-03_JPRB,&
 & 7.9957E-03_JPRB,7.3976E-03_JPRB,4.2222E-02_JPRB/)  
KAO( :, 4,11,10) = (/&
 & 8.1992E-03_JPRB,8.3401E-03_JPRB,8.2986E-03_JPRB,8.2629E-03_JPRB,8.5167E-03_JPRB,8.6635E-03_JPRB,&
 & 8.4735E-03_JPRB,7.8541E-03_JPRB,4.3187E-02_JPRB/)  
KAO( :, 5,11,10) = (/&
 & 8.2878E-03_JPRB,8.6780E-03_JPRB,8.8506E-03_JPRB,8.8633E-03_JPRB,9.0484E-03_JPRB,9.1413E-03_JPRB,&
 & 8.9084E-03_JPRB,8.2746E-03_JPRB,4.4361E-02_JPRB/)  
KAO( :, 1,12,10) = (/&
 & 7.6139E-03_JPRB,7.2726E-03_JPRB,6.8850E-03_JPRB,6.9089E-03_JPRB,6.9663E-03_JPRB,7.0443E-03_JPRB,&
 & 6.8750E-03_JPRB,6.2469E-03_JPRB,4.8797E-02_JPRB/)  
KAO( :, 2,12,10) = (/&
 & 7.7194E-03_JPRB,7.5180E-03_JPRB,7.1615E-03_JPRB,7.2509E-03_JPRB,7.4345E-03_JPRB,7.5251E-03_JPRB,&
 & 7.3302E-03_JPRB,6.7269E-03_JPRB,4.9597E-02_JPRB/)  
KAO( :, 3,12,10) = (/&
 & 7.8184E-03_JPRB,7.7399E-03_JPRB,7.4810E-03_JPRB,7.6258E-03_JPRB,7.9008E-03_JPRB,7.9967E-03_JPRB,&
 & 7.8018E-03_JPRB,7.1947E-03_JPRB,5.0339E-02_JPRB/)  
KAO( :, 4,12,10) = (/&
 & 7.8914E-03_JPRB,7.9922E-03_JPRB,7.8923E-03_JPRB,8.0511E-03_JPRB,8.3449E-03_JPRB,8.4240E-03_JPRB,&
 & 8.2687E-03_JPRB,7.6521E-03_JPRB,5.1350E-02_JPRB/)  
KAO( :, 5,12,10) = (/&
 & 7.9507E-03_JPRB,8.2886E-03_JPRB,8.3628E-03_JPRB,8.5321E-03_JPRB,8.7647E-03_JPRB,8.8141E-03_JPRB,&
 & 8.7116E-03_JPRB,8.0986E-03_JPRB,5.2764E-02_JPRB/)  
KAO( :, 1,13,10) = (/&
 & 7.3158E-03_JPRB,7.0328E-03_JPRB,6.8235E-03_JPRB,6.9230E-03_JPRB,6.9064E-03_JPRB,6.8869E-03_JPRB,&
 & 6.6102E-03_JPRB,5.9534E-03_JPRB,4.6027E-02_JPRB/)  
KAO( :, 2,13,10) = (/&
 & 7.4278E-03_JPRB,7.2607E-03_JPRB,7.0591E-03_JPRB,7.2420E-03_JPRB,7.3482E-03_JPRB,7.3254E-03_JPRB,&
 & 7.0547E-03_JPRB,6.4187E-03_JPRB,4.6671E-02_JPRB/)  
KAO( :, 3,13,10) = (/&
 & 7.5295E-03_JPRB,7.4924E-03_JPRB,7.3494E-03_JPRB,7.5754E-03_JPRB,7.7630E-03_JPRB,7.7638E-03_JPRB,&
 & 7.4975E-03_JPRB,6.8755E-03_JPRB,4.7440E-02_JPRB/)  
KAO( :, 4,13,10) = (/&
 & 7.6080E-03_JPRB,7.7470E-03_JPRB,7.6819E-03_JPRB,7.9565E-03_JPRB,8.1173E-03_JPRB,8.1428E-03_JPRB,&
 & 7.9589E-03_JPRB,7.3493E-03_JPRB,4.8497E-02_JPRB/)  
KAO( :, 5,13,10) = (/&
 & 7.6817E-03_JPRB,8.0217E-03_JPRB,8.0425E-03_JPRB,8.3061E-03_JPRB,8.4701E-03_JPRB,8.5085E-03_JPRB,&
 & 8.3860E-03_JPRB,7.8301E-03_JPRB,4.9971E-02_JPRB/)  
KAO( :, 1, 1,11) = (/&
 & 2.7764E-02_JPRB,2.4426E-02_JPRB,2.1973E-02_JPRB,2.0093E-02_JPRB,1.8666E-02_JPRB,1.7278E-02_JPRB,&
 & 1.5087E-02_JPRB,1.3103E-02_JPRB,1.4300E-02_JPRB/)  
KAO( :, 2, 1,11) = (/&
 & 2.7963E-02_JPRB,2.4667E-02_JPRB,2.2450E-02_JPRB,2.0789E-02_JPRB,1.9549E-02_JPRB,1.8247E-02_JPRB,&
 & 1.6059E-02_JPRB,1.4781E-02_JPRB,1.6422E-02_JPRB/)  
KAO( :, 3, 1,11) = (/&
 & 2.8032E-02_JPRB,2.4854E-02_JPRB,2.2829E-02_JPRB,2.1504E-02_JPRB,2.0423E-02_JPRB,1.9213E-02_JPRB,&
 & 1.7147E-02_JPRB,1.6580E-02_JPRB,1.8603E-02_JPRB/)  
KAO( :, 4, 1,11) = (/&
 & 2.7908E-02_JPRB,2.4878E-02_JPRB,2.3088E-02_JPRB,2.2255E-02_JPRB,2.1236E-02_JPRB,2.0204E-02_JPRB,&
 & 1.8256E-02_JPRB,1.8454E-02_JPRB,2.0859E-02_JPRB/)  
KAO( :, 5, 1,11) = (/&
 & 2.7693E-02_JPRB,2.4833E-02_JPRB,2.3283E-02_JPRB,2.2953E-02_JPRB,2.2107E-02_JPRB,2.1010E-02_JPRB,&
 & 1.9343E-02_JPRB,2.0385E-02_JPRB,2.3144E-02_JPRB/)  
KAO( :, 1, 2,11) = (/&
 & 2.7646E-02_JPRB,2.4332E-02_JPRB,2.2092E-02_JPRB,2.0298E-02_JPRB,1.9042E-02_JPRB,1.7440E-02_JPRB,&
 & 1.5349E-02_JPRB,1.2664E-02_JPRB,1.3386E-02_JPRB/)  
KAO( :, 2, 2,11) = (/&
 & 2.7909E-02_JPRB,2.4672E-02_JPRB,2.2646E-02_JPRB,2.1214E-02_JPRB,2.0006E-02_JPRB,1.8412E-02_JPRB,&
 & 1.6391E-02_JPRB,1.4178E-02_JPRB,1.5546E-02_JPRB/)  
KAO( :, 3, 2,11) = (/&
 & 2.7965E-02_JPRB,2.4859E-02_JPRB,2.3085E-02_JPRB,2.2119E-02_JPRB,2.0910E-02_JPRB,1.9436E-02_JPRB,&
 & 1.7350E-02_JPRB,1.5867E-02_JPRB,1.7743E-02_JPRB/)  
KAO( :, 4, 2,11) = (/&
 & 2.7851E-02_JPRB,2.4932E-02_JPRB,2.3473E-02_JPRB,2.2951E-02_JPRB,2.1773E-02_JPRB,2.0509E-02_JPRB,&
 & 1.8306E-02_JPRB,1.7658E-02_JPRB,1.9938E-02_JPRB/)  
KAO( :, 5, 2,11) = (/&
 & 2.7716E-02_JPRB,2.4986E-02_JPRB,2.3872E-02_JPRB,2.3624E-02_JPRB,2.2685E-02_JPRB,2.1385E-02_JPRB,&
 & 1.9339E-02_JPRB,1.9475E-02_JPRB,2.2096E-02_JPRB/)  
KAO( :, 1, 3,11) = (/&
 & 2.7136E-02_JPRB,2.3913E-02_JPRB,2.1898E-02_JPRB,2.0239E-02_JPRB,1.8943E-02_JPRB,1.7255E-02_JPRB,&
 & 1.5286E-02_JPRB,1.1962E-02_JPRB,1.1731E-02_JPRB/)  
KAO( :, 2, 3,11) = (/&
 & 2.7384E-02_JPRB,2.4261E-02_JPRB,2.2497E-02_JPRB,2.1296E-02_JPRB,2.0064E-02_JPRB,1.8265E-02_JPRB,&
 & 1.6402E-02_JPRB,1.3201E-02_JPRB,1.3756E-02_JPRB/)  
KAO( :, 3, 3,11) = (/&
 & 2.7424E-02_JPRB,2.4494E-02_JPRB,2.3027E-02_JPRB,2.2286E-02_JPRB,2.1084E-02_JPRB,1.9295E-02_JPRB,&
 & 1.7402E-02_JPRB,1.4625E-02_JPRB,1.5844E-02_JPRB/)  
KAO( :, 4, 3,11) = (/&
 & 2.7396E-02_JPRB,2.4666E-02_JPRB,2.3610E-02_JPRB,2.3218E-02_JPRB,2.1991E-02_JPRB,2.0436E-02_JPRB,&
 & 1.8232E-02_JPRB,1.6186E-02_JPRB,1.7976E-02_JPRB/)  
KAO( :, 5, 3,11) = (/&
 & 2.7396E-02_JPRB,2.4863E-02_JPRB,2.4263E-02_JPRB,2.4003E-02_JPRB,2.2894E-02_JPRB,2.1428E-02_JPRB,&
 & 1.9099E-02_JPRB,1.7923E-02_JPRB,2.0191E-02_JPRB/)  
KAO( :, 1, 4,11) = (/&
 & 2.6120E-02_JPRB,2.3055E-02_JPRB,2.1334E-02_JPRB,1.9874E-02_JPRB,1.8554E-02_JPRB,1.6913E-02_JPRB,&
 & 1.4849E-02_JPRB,1.1247E-02_JPRB,9.9817E-03_JPRB/)  
KAO( :, 2, 4,11) = (/&
 & 2.6346E-02_JPRB,2.3452E-02_JPRB,2.1987E-02_JPRB,2.1036E-02_JPRB,1.9768E-02_JPRB,1.8034E-02_JPRB,&
 & 1.5969E-02_JPRB,1.2323E-02_JPRB,1.1891E-02_JPRB/)  
KAO( :, 3, 4,11) = (/&
 & 2.6444E-02_JPRB,2.3743E-02_JPRB,2.2663E-02_JPRB,2.2134E-02_JPRB,2.0858E-02_JPRB,1.9164E-02_JPRB,&
 & 1.7004E-02_JPRB,1.3536E-02_JPRB,1.3883E-02_JPRB/)  
KAO( :, 4, 4,11) = (/&
 & 2.6615E-02_JPRB,2.4091E-02_JPRB,2.3417E-02_JPRB,2.3175E-02_JPRB,2.1815E-02_JPRB,2.0352E-02_JPRB,&
 & 1.7938E-02_JPRB,1.4897E-02_JPRB,1.5955E-02_JPRB/)  
KAO( :, 5, 4,11) = (/&
 & 2.6757E-02_JPRB,2.4467E-02_JPRB,2.4289E-02_JPRB,2.4064E-02_JPRB,2.2838E-02_JPRB,2.1378E-02_JPRB,&
 & 1.8780E-02_JPRB,1.6458E-02_JPRB,1.8170E-02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART7',1,ZHOOK_HANDLE)
END SUBROUTINE PART7


SUBROUTINE PART8

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART8',0,ZHOOK_HANDLE)


KAO( :, 1, 5,11) = (/&
 & 2.4649E-02_JPRB,2.1845E-02_JPRB,2.0397E-02_JPRB,1.9200E-02_JPRB,1.7986E-02_JPRB,1.6354E-02_JPRB,&
 & 1.4106E-02_JPRB,1.0659E-02_JPRB,8.5296E-03_JPRB/)  
KAO( :, 2, 5,11) = (/&
 & 2.4915E-02_JPRB,2.2302E-02_JPRB,2.1150E-02_JPRB,2.0451E-02_JPRB,1.9259E-02_JPRB,1.7581E-02_JPRB,&
 & 1.5270E-02_JPRB,1.1646E-02_JPRB,1.0194E-02_JPRB/)  
KAO( :, 3, 5,11) = (/&
 & 2.5218E-02_JPRB,2.2788E-02_JPRB,2.1977E-02_JPRB,2.1628E-02_JPRB,2.0422E-02_JPRB,1.8826E-02_JPRB,&
 & 1.6327E-02_JPRB,1.2719E-02_JPRB,1.2019E-02_JPRB/)  
KAO( :, 4, 5,11) = (/&
 & 2.5482E-02_JPRB,2.3305E-02_JPRB,2.2941E-02_JPRB,2.2718E-02_JPRB,2.1512E-02_JPRB,2.0034E-02_JPRB,&
 & 1.7375E-02_JPRB,1.3885E-02_JPRB,1.4041E-02_JPRB/)  
KAO( :, 5, 5,11) = (/&
 & 2.5726E-02_JPRB,2.3793E-02_JPRB,2.3951E-02_JPRB,2.3636E-02_JPRB,2.2618E-02_JPRB,2.1077E-02_JPRB,&
 & 1.8363E-02_JPRB,1.5350E-02_JPRB,1.6202E-02_JPRB/)  
KAO( :, 1, 6,11) = (/&
 & 2.2851E-02_JPRB,2.0373E-02_JPRB,1.9153E-02_JPRB,1.8191E-02_JPRB,1.7169E-02_JPRB,1.5447E-02_JPRB,&
 & 1.3127E-02_JPRB,9.9268E-03_JPRB,7.8128E-03_JPRB/)  
KAO( :, 2, 6,11) = (/&
 & 2.3274E-02_JPRB,2.0974E-02_JPRB,2.0039E-02_JPRB,1.9515E-02_JPRB,1.8501E-02_JPRB,1.6740E-02_JPRB,&
 & 1.4344E-02_JPRB,1.0951E-02_JPRB,8.8752E-03_JPRB/)  
KAO( :, 3, 6,11) = (/&
 & 2.3672E-02_JPRB,2.1617E-02_JPRB,2.1050E-02_JPRB,2.0731E-02_JPRB,1.9672E-02_JPRB,1.8067E-02_JPRB,&
 & 1.5465E-02_JPRB,1.2013E-02_JPRB,1.0301E-02_JPRB/)  
KAO( :, 4, 6,11) = (/&
 & 2.4031E-02_JPRB,2.2215E-02_JPRB,2.2188E-02_JPRB,2.1796E-02_JPRB,2.0865E-02_JPRB,1.9256E-02_JPRB,&
 & 1.6602E-02_JPRB,1.3087E-02_JPRB,1.2045E-02_JPRB/)  
KAO( :, 5, 6,11) = (/&
 & 2.4424E-02_JPRB,2.2835E-02_JPRB,2.3262E-02_JPRB,2.2762E-02_JPRB,2.2024E-02_JPRB,2.0317E-02_JPRB,&
 & 1.7726E-02_JPRB,1.4330E-02_JPRB,1.3970E-02_JPRB/)  
KAO( :, 1, 7,11) = (/&
 & 2.0897E-02_JPRB,1.8755E-02_JPRB,1.7733E-02_JPRB,1.7022E-02_JPRB,1.6054E-02_JPRB,1.4311E-02_JPRB,&
 & 1.2008E-02_JPRB,9.2731E-03_JPRB,7.7437E-03_JPRB/)  
KAO( :, 2, 7,11) = (/&
 & 2.1410E-02_JPRB,1.9491E-02_JPRB,1.8752E-02_JPRB,1.8362E-02_JPRB,1.7373E-02_JPRB,1.5636E-02_JPRB,&
 & 1.3285E-02_JPRB,1.0177E-02_JPRB,8.5051E-03_JPRB/)  
KAO( :, 3, 7,11) = (/&
 & 2.1887E-02_JPRB,2.0202E-02_JPRB,1.9920E-02_JPRB,1.9593E-02_JPRB,1.8568E-02_JPRB,1.6958E-02_JPRB,&
 & 1.4466E-02_JPRB,1.1212E-02_JPRB,9.3670E-03_JPRB/)  
KAO( :, 4, 7,11) = (/&
 & 2.2392E-02_JPRB,2.0930E-02_JPRB,2.1140E-02_JPRB,2.0643E-02_JPRB,1.9778E-02_JPRB,1.8147E-02_JPRB,&
 & 1.5692E-02_JPRB,1.2278E-02_JPRB,1.0489E-02_JPRB/)  
KAO( :, 5, 7,11) = (/&
 & 2.2888E-02_JPRB,2.1742E-02_JPRB,2.2178E-02_JPRB,2.1714E-02_JPRB,2.0936E-02_JPRB,1.9278E-02_JPRB,&
 & 1.6882E-02_JPRB,1.3452E-02_JPRB,1.1897E-02_JPRB/)  
KAO( :, 1, 8,11) = (/&
 & 1.8841E-02_JPRB,1.7056E-02_JPRB,1.6222E-02_JPRB,1.5693E-02_JPRB,1.4689E-02_JPRB,1.2994E-02_JPRB,&
 & 1.0918E-02_JPRB,9.1547E-03_JPRB,7.9124E-03_JPRB/)  
KAO( :, 2, 8,11) = (/&
 & 1.9409E-02_JPRB,1.7855E-02_JPRB,1.7363E-02_JPRB,1.7024E-02_JPRB,1.5955E-02_JPRB,1.4305E-02_JPRB,&
 & 1.2087E-02_JPRB,9.7905E-03_JPRB,8.4826E-03_JPRB/)  
KAO( :, 3, 8,11) = (/&
 & 1.9993E-02_JPRB,1.8663E-02_JPRB,1.8622E-02_JPRB,1.8244E-02_JPRB,1.7158E-02_JPRB,1.5610E-02_JPRB,&
 & 1.3302E-02_JPRB,1.0551E-02_JPRB,9.2336E-03_JPRB/)  
KAO( :, 4, 8,11) = (/&
 & 2.0602E-02_JPRB,1.9539E-02_JPRB,1.9827E-02_JPRB,1.9347E-02_JPRB,1.8357E-02_JPRB,1.6779E-02_JPRB,&
 & 1.4567E-02_JPRB,1.1467E-02_JPRB,9.9909E-03_JPRB/)  
KAO( :, 5, 8,11) = (/&
 & 2.1064E-02_JPRB,2.0402E-02_JPRB,2.0838E-02_JPRB,2.0466E-02_JPRB,1.9507E-02_JPRB,1.7959E-02_JPRB,&
 & 1.5824E-02_JPRB,1.2520E-02_JPRB,1.0807E-02_JPRB/)  
KAO( :, 1, 9,11) = (/&
 & 1.6824E-02_JPRB,1.5334E-02_JPRB,1.4694E-02_JPRB,1.4181E-02_JPRB,1.3143E-02_JPRB,1.1680E-02_JPRB,&
 & 1.0334E-02_JPRB,9.1831E-03_JPRB,1.1053E-02_JPRB/)  
KAO( :, 2, 9,11) = (/&
 & 1.7417E-02_JPRB,1.6144E-02_JPRB,1.5897E-02_JPRB,1.5487E-02_JPRB,1.4380E-02_JPRB,1.2867E-02_JPRB,&
 & 1.1184E-02_JPRB,9.7551E-03_JPRB,1.1728E-02_JPRB/)  
KAO( :, 3, 9,11) = (/&
 & 1.8068E-02_JPRB,1.7042E-02_JPRB,1.7161E-02_JPRB,1.6678E-02_JPRB,1.5557E-02_JPRB,1.4093E-02_JPRB,&
 & 1.2184E-02_JPRB,1.0404E-02_JPRB,1.2483E-02_JPRB/)  
KAO( :, 4, 9,11) = (/&
 & 1.8632E-02_JPRB,1.7983E-02_JPRB,1.8323E-02_JPRB,1.7788E-02_JPRB,1.6784E-02_JPRB,1.5260E-02_JPRB,&
 & 1.3324E-02_JPRB,1.1123E-02_JPRB,1.3280E-02_JPRB/)  
KAO( :, 5, 9,11) = (/&
 & 1.9073E-02_JPRB,1.8843E-02_JPRB,1.9281E-02_JPRB,1.8905E-02_JPRB,1.7900E-02_JPRB,1.6447E-02_JPRB,&
 & 1.4515E-02_JPRB,1.1877E-02_JPRB,1.4077E-02_JPRB/)  
KAO( :, 1,10,11) = (/&
 & 1.5121E-02_JPRB,1.3838E-02_JPRB,1.3365E-02_JPRB,1.2721E-02_JPRB,1.1737E-02_JPRB,1.0953E-02_JPRB,&
 & 1.0213E-02_JPRB,9.1916E-03_JPRB,3.5198E-02_JPRB/)  
KAO( :, 2,10,11) = (/&
 & 1.5710E-02_JPRB,1.4640E-02_JPRB,1.4492E-02_JPRB,1.3911E-02_JPRB,1.2838E-02_JPRB,1.1818E-02_JPRB,&
 & 1.0924E-02_JPRB,9.7376E-03_JPRB,3.6361E-02_JPRB/)  
KAO( :, 3,10,11) = (/&
 & 1.6286E-02_JPRB,1.5525E-02_JPRB,1.5683E-02_JPRB,1.5045E-02_JPRB,1.3992E-02_JPRB,1.2769E-02_JPRB,&
 & 1.1723E-02_JPRB,1.0342E-02_JPRB,3.7359E-02_JPRB/)  
KAO( :, 4,10,11) = (/&
 & 1.6782E-02_JPRB,1.6440E-02_JPRB,1.6745E-02_JPRB,1.6156E-02_JPRB,1.5181E-02_JPRB,1.3811E-02_JPRB,&
 & 1.2551E-02_JPRB,1.1044E-02_JPRB,3.8551E-02_JPRB/)  
KAO( :, 5,10,11) = (/&
 & 1.7221E-02_JPRB,1.7284E-02_JPRB,1.7650E-02_JPRB,1.7276E-02_JPRB,1.6297E-02_JPRB,1.4958E-02_JPRB,&
 & 1.3449E-02_JPRB,1.1753E-02_JPRB,3.9714E-02_JPRB/)  
KAO( :, 1,11,11) = (/&
 & 1.4019E-02_JPRB,1.2957E-02_JPRB,1.2611E-02_JPRB,1.1869E-02_JPRB,1.1221E-02_JPRB,1.0951E-02_JPRB,&
 & 1.0419E-02_JPRB,9.2574E-03_JPRB,5.9295E-02_JPRB/)  
KAO( :, 2,11,11) = (/&
 & 1.4514E-02_JPRB,1.3729E-02_JPRB,1.3655E-02_JPRB,1.2913E-02_JPRB,1.2091E-02_JPRB,1.1604E-02_JPRB,&
 & 1.1118E-02_JPRB,9.8828E-03_JPRB,6.0862E-02_JPRB/)  
KAO( :, 3,11,11) = (/&
 & 1.4986E-02_JPRB,1.4596E-02_JPRB,1.4648E-02_JPRB,1.3931E-02_JPRB,1.3062E-02_JPRB,1.2353E-02_JPRB,&
 & 1.1821E-02_JPRB,1.0518E-02_JPRB,6.2214E-02_JPRB/)  
KAO( :, 4,11,11) = (/&
 & 1.5398E-02_JPRB,1.5423E-02_JPRB,1.5511E-02_JPRB,1.4991E-02_JPRB,1.4093E-02_JPRB,1.3225E-02_JPRB,&
 & 1.2498E-02_JPRB,1.1195E-02_JPRB,6.3269E-02_JPRB/)  
KAO( :, 5,11,11) = (/&
 & 1.5718E-02_JPRB,1.6102E-02_JPRB,1.6332E-02_JPRB,1.5968E-02_JPRB,1.5171E-02_JPRB,1.4160E-02_JPRB,&
 & 1.3209E-02_JPRB,1.1891E-02_JPRB,6.4542E-02_JPRB/)  
KAO( :, 1,12,11) = (/&
 & 1.3164E-02_JPRB,1.2292E-02_JPRB,1.1927E-02_JPRB,1.1265E-02_JPRB,1.1057E-02_JPRB,1.0913E-02_JPRB,&
 & 1.0445E-02_JPRB,9.2736E-03_JPRB,7.4756E-02_JPRB/)  
KAO( :, 2,12,11) = (/&
 & 1.3602E-02_JPRB,1.3075E-02_JPRB,1.2792E-02_JPRB,1.2052E-02_JPRB,1.1692E-02_JPRB,1.1536E-02_JPRB,&
 & 1.1126E-02_JPRB,9.9170E-03_JPRB,7.6306E-02_JPRB/)  
KAO( :, 3,12,11) = (/&
 & 1.3977E-02_JPRB,1.3830E-02_JPRB,1.3590E-02_JPRB,1.2927E-02_JPRB,1.2424E-02_JPRB,1.2227E-02_JPRB,&
 & 1.1745E-02_JPRB,1.0613E-02_JPRB,7.7655E-02_JPRB/)  
KAO( :, 4,12,11) = (/&
 & 1.4251E-02_JPRB,1.4432E-02_JPRB,1.4329E-02_JPRB,1.3821E-02_JPRB,1.3256E-02_JPRB,1.2933E-02_JPRB,&
 & 1.2386E-02_JPRB,1.1303E-02_JPRB,7.8663E-02_JPRB/)  
KAO( :, 5,12,11) = (/&
 & 1.4497E-02_JPRB,1.4939E-02_JPRB,1.5040E-02_JPRB,1.4676E-02_JPRB,1.4122E-02_JPRB,1.3675E-02_JPRB,&
 & 1.3045E-02_JPRB,1.1981E-02_JPRB,7.9879E-02_JPRB/)  
KAO( :, 1,13,11) = (/&
 & 1.2616E-02_JPRB,1.1893E-02_JPRB,1.1313E-02_JPRB,1.0907E-02_JPRB,1.0966E-02_JPRB,1.0790E-02_JPRB,&
 & 1.0280E-02_JPRB,9.1949E-03_JPRB,7.3725E-02_JPRB/)  
KAO( :, 2,13,11) = (/&
 & 1.2957E-02_JPRB,1.2555E-02_JPRB,1.2016E-02_JPRB,1.1533E-02_JPRB,1.1499E-02_JPRB,1.1400E-02_JPRB,&
 & 1.0924E-02_JPRB,9.8797E-03_JPRB,7.4996E-02_JPRB/)  
KAO( :, 3,13,11) = (/&
 & 1.3172E-02_JPRB,1.3071E-02_JPRB,1.2663E-02_JPRB,1.2207E-02_JPRB,1.2117E-02_JPRB,1.2009E-02_JPRB,&
 & 1.1575E-02_JPRB,1.0610E-02_JPRB,7.6038E-02_JPRB/)  
KAO( :, 4,13,11) = (/&
 & 1.3348E-02_JPRB,1.3517E-02_JPRB,1.3285E-02_JPRB,1.2851E-02_JPRB,1.2762E-02_JPRB,1.2671E-02_JPRB,&
 & 1.2190E-02_JPRB,1.1315E-02_JPRB,7.7063E-02_JPRB/)  
KAO( :, 5,13,11) = (/&
 & 1.3524E-02_JPRB,1.3946E-02_JPRB,1.3887E-02_JPRB,1.3540E-02_JPRB,1.3388E-02_JPRB,1.3305E-02_JPRB,&
 & 1.2841E-02_JPRB,1.2009E-02_JPRB,7.8468E-02_JPRB/)  
KAO( :, 1, 1,12) = (/&
 & 3.9522E-02_JPRB,3.4695E-02_JPRB,3.0393E-02_JPRB,2.7444E-02_JPRB,2.4701E-02_JPRB,2.2430E-02_JPRB,&
 & 1.9690E-02_JPRB,1.9007E-02_JPRB,2.1357E-02_JPRB/)  
KAO( :, 2, 1,12) = (/&
 & 3.9055E-02_JPRB,3.4293E-02_JPRB,3.0365E-02_JPRB,2.7692E-02_JPRB,2.5619E-02_JPRB,2.3505E-02_JPRB,&
 & 2.1002E-02_JPRB,2.1723E-02_JPRB,2.4548E-02_JPRB/)  
KAO( :, 3, 1,12) = (/&
 & 3.8771E-02_JPRB,3.4045E-02_JPRB,3.0558E-02_JPRB,2.8122E-02_JPRB,2.6598E-02_JPRB,2.4455E-02_JPRB,&
 & 2.2524E-02_JPRB,2.4725E-02_JPRB,2.7978E-02_JPRB/)  
KAO( :, 4, 1,12) = (/&
 & 3.8655E-02_JPRB,3.3972E-02_JPRB,3.0813E-02_JPRB,2.8575E-02_JPRB,2.7403E-02_JPRB,2.5405E-02_JPRB,&
 & 2.4525E-02_JPRB,2.7903E-02_JPRB,3.1582E-02_JPRB/)  
KAO( :, 5, 1,12) = (/&
 & 3.8581E-02_JPRB,3.4020E-02_JPRB,3.1105E-02_JPRB,2.9186E-02_JPRB,2.7932E-02_JPRB,2.6686E-02_JPRB,&
 & 2.7056E-02_JPRB,3.1213E-02_JPRB,3.5341E-02_JPRB/)  
KAO( :, 1, 2,12) = (/&
 & 4.0900E-02_JPRB,3.5882E-02_JPRB,3.1540E-02_JPRB,2.8648E-02_JPRB,2.5916E-02_JPRB,2.3479E-02_JPRB,&
 & 1.9842E-02_JPRB,1.8172E-02_JPRB,2.0462E-02_JPRB/)  
KAO( :, 2, 2,12) = (/&
 & 4.0629E-02_JPRB,3.5647E-02_JPRB,3.1749E-02_JPRB,2.9079E-02_JPRB,2.7038E-02_JPRB,2.4448E-02_JPRB,&
 & 2.0997E-02_JPRB,2.0801E-02_JPRB,2.3586E-02_JPRB/)  
KAO( :, 3, 2,12) = (/&
 & 4.0634E-02_JPRB,3.5666E-02_JPRB,3.2165E-02_JPRB,2.9630E-02_JPRB,2.8090E-02_JPRB,2.5205E-02_JPRB,&
 & 2.2483E-02_JPRB,2.3756E-02_JPRB,2.6981E-02_JPRB/)  
KAO( :, 4, 2,12) = (/&
 & 4.0680E-02_JPRB,3.5804E-02_JPRB,3.2512E-02_JPRB,3.0271E-02_JPRB,2.8844E-02_JPRB,2.6048E-02_JPRB,&
 & 2.4362E-02_JPRB,2.6965E-02_JPRB,3.0664E-02_JPRB/)  
KAO( :, 5, 2,12) = (/&
 & 4.0551E-02_JPRB,3.5850E-02_JPRB,3.2760E-02_JPRB,3.1085E-02_JPRB,2.9377E-02_JPRB,2.7302E-02_JPRB,&
 & 2.6614E-02_JPRB,3.0323E-02_JPRB,3.4512E-02_JPRB/)  
KAO( :, 1, 3,12) = (/&
 & 4.2297E-02_JPRB,3.7083E-02_JPRB,3.2675E-02_JPRB,2.9696E-02_JPRB,2.6819E-02_JPRB,2.4251E-02_JPRB,&
 & 1.9800E-02_JPRB,1.7013E-02_JPRB,1.8998E-02_JPRB/)  
KAO( :, 2, 3,12) = (/&
 & 4.2345E-02_JPRB,3.7129E-02_JPRB,3.3126E-02_JPRB,3.0221E-02_JPRB,2.7989E-02_JPRB,2.5268E-02_JPRB,&
 & 2.0870E-02_JPRB,1.9534E-02_JPRB,2.2175E-02_JPRB/)  
KAO( :, 3, 3,12) = (/&
 & 4.2503E-02_JPRB,3.7329E-02_JPRB,3.3705E-02_JPRB,3.0884E-02_JPRB,2.9095E-02_JPRB,2.6012E-02_JPRB,&
 & 2.2274E-02_JPRB,2.2409E-02_JPRB,2.5549E-02_JPRB/)  
KAO( :, 4, 3,12) = (/&
 & 4.2563E-02_JPRB,3.7513E-02_JPRB,3.4118E-02_JPRB,3.1719E-02_JPRB,2.9991E-02_JPRB,2.6648E-02_JPRB,&
 & 2.4107E-02_JPRB,2.5501E-02_JPRB,2.9091E-02_JPRB/)  
KAO( :, 5, 3,12) = (/&
 & 4.2352E-02_JPRB,3.7494E-02_JPRB,3.4375E-02_JPRB,3.2625E-02_JPRB,3.0646E-02_JPRB,2.7653E-02_JPRB,&
 & 2.6034E-02_JPRB,2.8674E-02_JPRB,3.2704E-02_JPRB/)  
KAO( :, 1, 4,12) = (/&
 & 4.3449E-02_JPRB,3.8071E-02_JPRB,3.3569E-02_JPRB,3.0433E-02_JPRB,2.7408E-02_JPRB,2.4611E-02_JPRB,&
 & 2.0108E-02_JPRB,1.5832E-02_JPRB,1.6869E-02_JPRB/)  
KAO( :, 2, 4,12) = (/&
 & 4.3754E-02_JPRB,3.8357E-02_JPRB,3.4350E-02_JPRB,3.1115E-02_JPRB,2.8679E-02_JPRB,2.5625E-02_JPRB,&
 & 2.1066E-02_JPRB,1.8077E-02_JPRB,2.0082E-02_JPRB/)  
KAO( :, 3, 4,12) = (/&
 & 4.3973E-02_JPRB,3.8656E-02_JPRB,3.5023E-02_JPRB,3.2006E-02_JPRB,2.9792E-02_JPRB,2.6458E-02_JPRB,&
 & 2.2328E-02_JPRB,2.0812E-02_JPRB,2.3540E-02_JPRB/)  
KAO( :, 4, 4,12) = (/&
 & 4.3938E-02_JPRB,3.8773E-02_JPRB,3.5454E-02_JPRB,3.2980E-02_JPRB,3.0747E-02_JPRB,2.7193E-02_JPRB,&
 & 2.3978E-02_JPRB,2.3783E-02_JPRB,2.7070E-02_JPRB/)  
KAO( :, 5, 4,12) = (/&
 & 4.3814E-02_JPRB,3.8836E-02_JPRB,3.5796E-02_JPRB,3.3909E-02_JPRB,3.1572E-02_JPRB,2.8214E-02_JPRB,&
 & 2.5779E-02_JPRB,2.6823E-02_JPRB,3.0560E-02_JPRB/)  
KAO( :, 1, 5,12) = (/&
 & 4.3987E-02_JPRB,3.8530E-02_JPRB,3.4139E-02_JPRB,3.0809E-02_JPRB,2.7641E-02_JPRB,2.4664E-02_JPRB,&
 & 2.0281E-02_JPRB,1.4828E-02_JPRB,1.4596E-02_JPRB/)  
KAO( :, 2, 5,12) = (/&
 & 4.4423E-02_JPRB,3.8965E-02_JPRB,3.5098E-02_JPRB,3.1717E-02_JPRB,2.9032E-02_JPRB,2.5717E-02_JPRB,&
 & 2.1306E-02_JPRB,1.6792E-02_JPRB,1.7692E-02_JPRB/)  
KAO( :, 3, 5,12) = (/&
 & 4.4740E-02_JPRB,3.9368E-02_JPRB,3.5854E-02_JPRB,3.2800E-02_JPRB,3.0202E-02_JPRB,2.6633E-02_JPRB,&
 & 2.2521E-02_JPRB,1.9130E-02_JPRB,2.0967E-02_JPRB/)  
KAO( :, 4, 5,12) = (/&
 & 4.4784E-02_JPRB,3.9578E-02_JPRB,3.6349E-02_JPRB,3.3852E-02_JPRB,3.1212E-02_JPRB,2.7594E-02_JPRB,&
 & 2.3985E-02_JPRB,2.1768E-02_JPRB,2.4335E-02_JPRB/)  
KAO( :, 5, 5,12) = (/&
 & 4.4634E-02_JPRB,3.9684E-02_JPRB,3.6716E-02_JPRB,3.4783E-02_JPRB,3.2166E-02_JPRB,2.8840E-02_JPRB,&
 & 2.5566E-02_JPRB,2.4589E-02_JPRB,2.7780E-02_JPRB/)  
KAO( :, 1, 6,12) = (/&
 & 4.3652E-02_JPRB,3.8230E-02_JPRB,3.4067E-02_JPRB,3.0633E-02_JPRB,2.7394E-02_JPRB,2.4357E-02_JPRB,&
 & 2.0018E-02_JPRB,1.4129E-02_JPRB,1.2309E-02_JPRB/)  
KAO( :, 2, 6,12) = (/&
 & 4.4319E-02_JPRB,3.8893E-02_JPRB,3.5172E-02_JPRB,3.1745E-02_JPRB,2.8902E-02_JPRB,2.5570E-02_JPRB,&
 & 2.1093E-02_JPRB,1.5716E-02_JPRB,1.5104E-02_JPRB/)  
KAO( :, 3, 6,12) = (/&
 & 4.4786E-02_JPRB,3.9451E-02_JPRB,3.6064E-02_JPRB,3.2991E-02_JPRB,3.0223E-02_JPRB,2.6609E-02_JPRB,&
 & 2.2435E-02_JPRB,1.7637E-02_JPRB,1.8165E-02_JPRB/)  
KAO( :, 4, 6,12) = (/&
 & 4.4788E-02_JPRB,3.9699E-02_JPRB,3.6561E-02_JPRB,3.4163E-02_JPRB,3.1314E-02_JPRB,2.7788E-02_JPRB,&
 & 2.3906E-02_JPRB,1.9877E-02_JPRB,2.1395E-02_JPRB/)  
KAO( :, 5, 6,12) = (/&
 & 4.4447E-02_JPRB,3.9668E-02_JPRB,3.6988E-02_JPRB,3.5173E-02_JPRB,3.2361E-02_JPRB,2.9209E-02_JPRB,&
 & 2.5326E-02_JPRB,2.2392E-02_JPRB,2.4740E-02_JPRB/)  
KAO( :, 1, 7,12) = (/&
 & 4.2520E-02_JPRB,3.7241E-02_JPRB,3.3313E-02_JPRB,2.9817E-02_JPRB,2.6724E-02_JPRB,2.3713E-02_JPRB,&
 & 1.9392E-02_JPRB,1.3514E-02_JPRB,1.0779E-02_JPRB/)  
KAO( :, 2, 7,12) = (/&
 & 4.3342E-02_JPRB,3.8062E-02_JPRB,3.4549E-02_JPRB,3.1204E-02_JPRB,2.8393E-02_JPRB,2.5083E-02_JPRB,&
 & 2.0539E-02_JPRB,1.4970E-02_JPRB,1.2835E-02_JPRB/)  
KAO( :, 3, 7,12) = (/&
 & 4.3790E-02_JPRB,3.8673E-02_JPRB,3.5497E-02_JPRB,3.2592E-02_JPRB,2.9885E-02_JPRB,2.6278E-02_JPRB,&
 & 2.1950E-02_JPRB,1.6561E-02_JPRB,1.5528E-02_JPRB/)  
KAO( :, 4, 7,12) = (/&
 & 4.3699E-02_JPRB,3.8889E-02_JPRB,3.6038E-02_JPRB,3.3992E-02_JPRB,3.1096E-02_JPRB,2.7610E-02_JPRB,&
 & 2.3462E-02_JPRB,1.8494E-02_JPRB,1.8561E-02_JPRB/)  
KAO( :, 5, 7,12) = (/&
 & 4.3391E-02_JPRB,3.8899E-02_JPRB,3.6695E-02_JPRB,3.5094E-02_JPRB,3.2242E-02_JPRB,2.9127E-02_JPRB,&
 & 2.4986E-02_JPRB,2.0683E-02_JPRB,2.1759E-02_JPRB/)  
KAO( :, 1, 8,12) = (/&
 & 4.0705E-02_JPRB,3.5661E-02_JPRB,3.2044E-02_JPRB,2.8588E-02_JPRB,2.5730E-02_JPRB,2.2651E-02_JPRB,&
 & 1.8403E-02_JPRB,1.2786E-02_JPRB,1.0617E-02_JPRB/)  
KAO( :, 2, 8,12) = (/&
 & 4.1513E-02_JPRB,3.6523E-02_JPRB,3.3287E-02_JPRB,3.0168E-02_JPRB,2.7518E-02_JPRB,2.4185E-02_JPRB,&
 & 1.9645E-02_JPRB,1.4186E-02_JPRB,1.1770E-02_JPRB/)  
KAO( :, 3, 8,12) = (/&
 & 4.1918E-02_JPRB,3.7171E-02_JPRB,3.4241E-02_JPRB,3.1699E-02_JPRB,2.9124E-02_JPRB,2.5489E-02_JPRB,&
 & 2.1120E-02_JPRB,1.5769E-02_JPRB,1.3550E-02_JPRB/)  
KAO( :, 4, 8,12) = (/&
 & 4.1853E-02_JPRB,3.7439E-02_JPRB,3.4958E-02_JPRB,3.3201E-02_JPRB,3.0465E-02_JPRB,2.6939E-02_JPRB,&
 & 2.2712E-02_JPRB,1.7517E-02_JPRB,1.5986E-02_JPRB/)  
KAO( :, 5, 8,12) = (/&
 & 4.1733E-02_JPRB,3.7668E-02_JPRB,3.5839E-02_JPRB,3.4355E-02_JPRB,3.1760E-02_JPRB,2.8542E-02_JPRB,&
 & 2.4348E-02_JPRB,1.9402E-02_JPRB,1.8887E-02_JPRB/)  
KAO( :, 1, 9,12) = (/&
 & 3.8179E-02_JPRB,3.3470E-02_JPRB,3.0206E-02_JPRB,2.7054E-02_JPRB,2.4424E-02_JPRB,2.1213E-02_JPRB,&
 & 1.7112E-02_JPRB,1.2467E-02_JPRB,1.5003E-02_JPRB/)  
KAO( :, 2, 9,12) = (/&
 & 3.9010E-02_JPRB,3.4434E-02_JPRB,3.1441E-02_JPRB,2.8741E-02_JPRB,2.6231E-02_JPRB,2.2823E-02_JPRB,&
 & 1.8428E-02_JPRB,1.3530E-02_JPRB,1.6372E-02_JPRB/)  
KAO( :, 3, 9,12) = (/&
 & 3.9453E-02_JPRB,3.5166E-02_JPRB,3.2518E-02_JPRB,3.0394E-02_JPRB,2.7907E-02_JPRB,2.4225E-02_JPRB,&
 & 1.9954E-02_JPRB,1.4900E-02_JPRB,1.8039E-02_JPRB/)  
KAO( :, 4, 9,12) = (/&
 & 3.9552E-02_JPRB,3.5595E-02_JPRB,3.3460E-02_JPRB,3.1929E-02_JPRB,2.9264E-02_JPRB,2.5769E-02_JPRB,&
 & 2.1600E-02_JPRB,1.6537E-02_JPRB,1.9903E-02_JPRB/)  
KAO( :, 5, 9,12) = (/&
 & 3.9456E-02_JPRB,3.5940E-02_JPRB,3.4560E-02_JPRB,3.3060E-02_JPRB,3.0675E-02_JPRB,2.7481E-02_JPRB,&
 & 2.3382E-02_JPRB,1.8398E-02_JPRB,2.1739E-02_JPRB/)  
KAO( :, 1,10,12) = (/&
 & 3.5238E-02_JPRB,3.0971E-02_JPRB,2.8042E-02_JPRB,2.5331E-02_JPRB,2.2876E-02_JPRB,1.9632E-02_JPRB,&
 & 1.5965E-02_JPRB,1.2700E-02_JPRB,4.7338E-02_JPRB/)  
KAO( :, 2,10,12) = (/&
 & 3.6134E-02_JPRB,3.2062E-02_JPRB,2.9356E-02_JPRB,2.7135E-02_JPRB,2.4639E-02_JPRB,2.1263E-02_JPRB,&
 & 1.7126E-02_JPRB,1.3564E-02_JPRB,4.9352E-02_JPRB/)  
KAO( :, 3,10,12) = (/&
 & 3.6647E-02_JPRB,3.2881E-02_JPRB,3.0571E-02_JPRB,2.8822E-02_JPRB,2.6275E-02_JPRB,2.2691E-02_JPRB,&
 & 1.8634E-02_JPRB,1.4609E-02_JPRB,5.1163E-02_JPRB/)  
KAO( :, 4,10,12) = (/&
 & 3.6732E-02_JPRB,3.3352E-02_JPRB,3.1697E-02_JPRB,3.0299E-02_JPRB,2.7653E-02_JPRB,2.4298E-02_JPRB,&
 & 2.0355E-02_JPRB,1.5925E-02_JPRB,5.2665E-02_JPRB/)  
KAO( :, 5,10,12) = (/&
 & 3.6735E-02_JPRB,3.3801E-02_JPRB,3.2857E-02_JPRB,3.1401E-02_JPRB,2.9116E-02_JPRB,2.6070E-02_JPRB,&
 & 2.2245E-02_JPRB,1.7479E-02_JPRB,5.4548E-02_JPRB/)  
KAO( :, 1,11,12) = (/&
 & 3.2545E-02_JPRB,2.8854E-02_JPRB,2.6358E-02_JPRB,2.4300E-02_JPRB,2.1804E-02_JPRB,1.8684E-02_JPRB,&
 & 1.5775E-02_JPRB,1.3392E-02_JPRB,8.3440E-02_JPRB/)  
KAO( :, 2,11,12) = (/&
 & 3.3300E-02_JPRB,2.9905E-02_JPRB,2.7758E-02_JPRB,2.6019E-02_JPRB,2.3465E-02_JPRB,2.0097E-02_JPRB,&
 & 1.6793E-02_JPRB,1.4249E-02_JPRB,8.5867E-02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART8',1,ZHOOK_HANDLE)
END SUBROUTINE PART8


SUBROUTINE PART9

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART9',0,ZHOOK_HANDLE)


KAO( :, 3,11,12) = (/&
 & 3.3558E-02_JPRB,3.0525E-02_JPRB,2.8985E-02_JPRB,2.7554E-02_JPRB,2.4920E-02_JPRB,2.1636E-02_JPRB,&
 & 1.8144E-02_JPRB,1.5281E-02_JPRB,8.8098E-02_JPRB/)  
KAO( :, 4,11,12) = (/&
 & 3.3710E-02_JPRB,3.1080E-02_JPRB,3.0218E-02_JPRB,2.8753E-02_JPRB,2.6347E-02_JPRB,2.3365E-02_JPRB,&
 & 1.9836E-02_JPRB,1.6406E-02_JPRB,9.0071E-02_JPRB/)  
KAO( :, 5,11,12) = (/&
 & 3.3928E-02_JPRB,3.1726E-02_JPRB,3.1326E-02_JPRB,2.9966E-02_JPRB,2.7916E-02_JPRB,2.5204E-02_JPRB,&
 & 2.1753E-02_JPRB,1.7712E-02_JPRB,9.1519E-02_JPRB/)  
KAO( :, 1,12,12) = (/&
 & 2.9830E-02_JPRB,2.6721E-02_JPRB,2.4676E-02_JPRB,2.2938E-02_JPRB,2.0448E-02_JPRB,1.7882E-02_JPRB,&
 & 1.5923E-02_JPRB,1.3970E-02_JPRB,1.1086E-01_JPRB/)  
KAO( :, 2,12,12) = (/&
 & 3.0231E-02_JPRB,2.7476E-02_JPRB,2.6007E-02_JPRB,2.4462E-02_JPRB,2.1935E-02_JPRB,1.9103E-02_JPRB,&
 & 1.6840E-02_JPRB,1.4875E-02_JPRB,1.1330E-01_JPRB/)  
KAO( :, 3,12,12) = (/&
 & 3.0491E-02_JPRB,2.8099E-02_JPRB,2.7260E-02_JPRB,2.5711E-02_JPRB,2.3307E-02_JPRB,2.0562E-02_JPRB,&
 & 1.8077E-02_JPRB,1.5918E-02_JPRB,1.1557E-01_JPRB/)  
KAO( :, 4,12,12) = (/&
 & 3.0757E-02_JPRB,2.8842E-02_JPRB,2.8411E-02_JPRB,2.6924E-02_JPRB,2.4803E-02_JPRB,2.2253E-02_JPRB,&
 & 1.9581E-02_JPRB,1.7012E-02_JPRB,1.1765E-01_JPRB/)  
KAO( :, 5,12,12) = (/&
 & 3.0918E-02_JPRB,2.9599E-02_JPRB,2.9489E-02_JPRB,2.8288E-02_JPRB,2.6494E-02_JPRB,2.4129E-02_JPRB,&
 & 2.1275E-02_JPRB,1.8143E-02_JPRB,1.1909E-01_JPRB/)  
KAO( :, 1,13,12) = (/&
 & 2.7094E-02_JPRB,2.4532E-02_JPRB,2.3049E-02_JPRB,2.1309E-02_JPRB,1.9154E-02_JPRB,1.7486E-02_JPRB,&
 & 1.6144E-02_JPRB,1.4353E-02_JPRB,1.1524E-01_JPRB/)  
KAO( :, 2,13,12) = (/&
 & 2.7412E-02_JPRB,2.5168E-02_JPRB,2.4223E-02_JPRB,2.2514E-02_JPRB,2.0316E-02_JPRB,1.8507E-02_JPRB,&
 & 1.7150E-02_JPRB,1.5366E-02_JPRB,1.1754E-01_JPRB/)  
KAO( :, 3,13,12) = (/&
 & 2.7677E-02_JPRB,2.5904E-02_JPRB,2.5334E-02_JPRB,2.3685E-02_JPRB,2.1617E-02_JPRB,1.9773E-02_JPRB,&
 & 1.8343E-02_JPRB,1.6413E-02_JPRB,1.1954E-01_JPRB/)  
KAO( :, 4,13,12) = (/&
 & 2.7872E-02_JPRB,2.6672E-02_JPRB,2.6384E-02_JPRB,2.5015E-02_JPRB,2.3188E-02_JPRB,2.1278E-02_JPRB,&
 & 1.9644E-02_JPRB,1.7533E-02_JPRB,1.2118E-01_JPRB/)  
KAO( :, 5,13,12) = (/&
 & 2.7954E-02_JPRB,2.7488E-02_JPRB,2.7495E-02_JPRB,2.6532E-02_JPRB,2.4977E-02_JPRB,2.3012E-02_JPRB,&
 & 2.1088E-02_JPRB,1.8595E-02_JPRB,1.2230E-01_JPRB/)  
KAO( :, 1, 1,13) = (/&
 & 5.6053E-02_JPRB,4.9173E-02_JPRB,4.2351E-02_JPRB,3.6619E-02_JPRB,3.1919E-02_JPRB,2.7549E-02_JPRB,&
 & 2.5709E-02_JPRB,2.8817E-02_JPRB,3.2228E-02_JPRB/)  
KAO( :, 2, 1,13) = (/&
 & 5.5104E-02_JPRB,4.8363E-02_JPRB,4.1989E-02_JPRB,3.6731E-02_JPRB,3.2283E-02_JPRB,2.9042E-02_JPRB,&
 & 2.9013E-02_JPRB,3.3235E-02_JPRB,3.7260E-02_JPRB/)  
KAO( :, 3, 1,13) = (/&
 & 5.3995E-02_JPRB,4.7411E-02_JPRB,4.1385E-02_JPRB,3.6532E-02_JPRB,3.2764E-02_JPRB,3.0737E-02_JPRB,&
 & 3.2896E-02_JPRB,3.7808E-02_JPRB,4.2479E-02_JPRB/)  
KAO( :, 4, 1,13) = (/&
 & 5.2736E-02_JPRB,4.6336E-02_JPRB,4.0785E-02_JPRB,3.6489E-02_JPRB,3.3723E-02_JPRB,3.2658E-02_JPRB,&
 & 3.6921E-02_JPRB,4.2523E-02_JPRB,4.7856E-02_JPRB/)  
KAO( :, 5, 1,13) = (/&
 & 5.1501E-02_JPRB,4.5267E-02_JPRB,4.0254E-02_JPRB,3.6460E-02_JPRB,3.5114E-02_JPRB,3.5037E-02_JPRB,&
 & 4.0972E-02_JPRB,4.7260E-02_JPRB,5.3261E-02_JPRB/)  
KAO( :, 1, 2,13) = (/&
 & 6.0681E-02_JPRB,5.3202E-02_JPRB,4.5845E-02_JPRB,3.9636E-02_JPRB,3.4042E-02_JPRB,2.9064E-02_JPRB,&
 & 2.6532E-02_JPRB,2.9036E-02_JPRB,3.2832E-02_JPRB/)  
KAO( :, 2, 2,13) = (/&
 & 5.9591E-02_JPRB,5.2263E-02_JPRB,4.5381E-02_JPRB,3.9598E-02_JPRB,3.4216E-02_JPRB,3.0746E-02_JPRB,&
 & 2.9570E-02_JPRB,3.3591E-02_JPRB,3.8065E-02_JPRB/)  
KAO( :, 3, 2,13) = (/&
 & 5.8268E-02_JPRB,5.1123E-02_JPRB,4.4655E-02_JPRB,3.9364E-02_JPRB,3.4820E-02_JPRB,3.2584E-02_JPRB,&
 & 3.3306E-02_JPRB,3.8344E-02_JPRB,4.3514E-02_JPRB/)  
KAO( :, 4, 2,13) = (/&
 & 5.6859E-02_JPRB,4.9908E-02_JPRB,4.4073E-02_JPRB,3.9320E-02_JPRB,3.5951E-02_JPRB,3.4443E-02_JPRB,&
 & 3.7381E-02_JPRB,4.3145E-02_JPRB,4.9018E-02_JPRB/)  
KAO( :, 5, 2,13) = (/&
 & 5.5606E-02_JPRB,4.8809E-02_JPRB,4.3641E-02_JPRB,3.9295E-02_JPRB,3.7457E-02_JPRB,3.6510E-02_JPRB,&
 & 4.1577E-02_JPRB,4.8053E-02_JPRB,5.4636E-02_JPRB/)  
KAO( :, 1, 3,13) = (/&
 & 6.5281E-02_JPRB,5.7202E-02_JPRB,4.9259E-02_JPRB,4.2481E-02_JPRB,3.6242E-02_JPRB,3.0257E-02_JPRB,&
 & 2.6947E-02_JPRB,2.7850E-02_JPRB,3.1754E-02_JPRB/)  
KAO( :, 2, 3,13) = (/&
 & 6.4026E-02_JPRB,5.6115E-02_JPRB,4.8709E-02_JPRB,4.2529E-02_JPRB,3.6413E-02_JPRB,3.1975E-02_JPRB,&
 & 2.9537E-02_JPRB,3.2421E-02_JPRB,3.6975E-02_JPRB/)  
KAO( :, 3, 3,13) = (/&
 & 6.2582E-02_JPRB,5.4864E-02_JPRB,4.7944E-02_JPRB,4.2387E-02_JPRB,3.6942E-02_JPRB,3.3882E-02_JPRB,&
 & 3.2746E-02_JPRB,3.7152E-02_JPRB,4.2391E-02_JPRB/)  
KAO( :, 4, 3,13) = (/&
 & 6.1252E-02_JPRB,5.3699E-02_JPRB,4.7471E-02_JPRB,4.2276E-02_JPRB,3.8007E-02_JPRB,3.5845E-02_JPRB,&
 & 3.6492E-02_JPRB,4.2063E-02_JPRB,4.8049E-02_JPRB/)  
KAO( :, 5, 3,13) = (/&
 & 6.0092E-02_JPRB,5.2697E-02_JPRB,4.7050E-02_JPRB,4.2178E-02_JPRB,3.9419E-02_JPRB,3.7791E-02_JPRB,&
 & 4.0791E-02_JPRB,4.7197E-02_JPRB,5.3978E-02_JPRB/)  
KAO( :, 1, 4,13) = (/&
 & 6.9156E-02_JPRB,6.0580E-02_JPRB,5.2151E-02_JPRB,4.4993E-02_JPRB,3.8321E-02_JPRB,3.1681E-02_JPRB,&
 & 2.7066E-02_JPRB,2.6200E-02_JPRB,2.9938E-02_JPRB/)  
KAO( :, 2, 4,13) = (/&
 & 6.7721E-02_JPRB,5.9333E-02_JPRB,5.1460E-02_JPRB,4.5174E-02_JPRB,3.8672E-02_JPRB,3.3341E-02_JPRB,&
 & 2.9463E-02_JPRB,3.0601E-02_JPRB,3.4960E-02_JPRB/)  
KAO( :, 3, 4,13) = (/&
 & 6.6317E-02_JPRB,5.8105E-02_JPRB,5.0834E-02_JPRB,4.5138E-02_JPRB,3.9401E-02_JPRB,3.5131E-02_JPRB,&
 & 3.2153E-02_JPRB,3.5157E-02_JPRB,4.0204E-02_JPRB/)  
KAO( :, 4, 4,13) = (/&
 & 6.5137E-02_JPRB,5.7074E-02_JPRB,5.0526E-02_JPRB,4.5041E-02_JPRB,4.0452E-02_JPRB,3.6956E-02_JPRB,&
 & 3.5433E-02_JPRB,4.0097E-02_JPRB,4.5914E-02_JPRB/)  
KAO( :, 5, 4,13) = (/&
 & 6.4115E-02_JPRB,5.6230E-02_JPRB,5.0276E-02_JPRB,4.5144E-02_JPRB,4.1609E-02_JPRB,3.8932E-02_JPRB,&
 & 3.9448E-02_JPRB,4.5417E-02_JPRB,5.2017E-02_JPRB/)  
KAO( :, 1, 5,13) = (/&
 & 7.2400E-02_JPRB,6.3404E-02_JPRB,5.4540E-02_JPRB,4.7112E-02_JPRB,4.0185E-02_JPRB,3.3245E-02_JPRB,&
 & 2.7454E-02_JPRB,2.4538E-02_JPRB,2.7637E-02_JPRB/)  
KAO( :, 2, 5,13) = (/&
 & 7.1034E-02_JPRB,6.2212E-02_JPRB,5.3950E-02_JPRB,4.7421E-02_JPRB,4.0716E-02_JPRB,3.5033E-02_JPRB,&
 & 2.9541E-02_JPRB,2.8475E-02_JPRB,3.2456E-02_JPRB/)  
KAO( :, 3, 5,13) = (/&
 & 6.9683E-02_JPRB,6.1033E-02_JPRB,5.3449E-02_JPRB,4.7487E-02_JPRB,4.1776E-02_JPRB,3.6647E-02_JPRB,&
 & 3.1941E-02_JPRB,3.2964E-02_JPRB,3.7708E-02_JPRB/)  
KAO( :, 4, 5,13) = (/&
 & 6.8593E-02_JPRB,6.0082E-02_JPRB,5.3255E-02_JPRB,4.7581E-02_JPRB,4.2936E-02_JPRB,3.8247E-02_JPRB,&
 & 3.4793E-02_JPRB,3.7940E-02_JPRB,4.3452E-02_JPRB/)  
KAO( :, 5, 5,13) = (/&
 & 6.7660E-02_JPRB,5.9367E-02_JPRB,5.3230E-02_JPRB,4.8095E-02_JPRB,4.3998E-02_JPRB,4.0012E-02_JPRB,&
 & 3.8369E-02_JPRB,4.3216E-02_JPRB,4.9502E-02_JPRB/)  
KAO( :, 1, 6,13) = (/&
 & 7.5282E-02_JPRB,6.5913E-02_JPRB,5.6672E-02_JPRB,4.9038E-02_JPRB,4.1667E-02_JPRB,3.4580E-02_JPRB,&
 & 2.8084E-02_JPRB,2.2885E-02_JPRB,2.4729E-02_JPRB/)  
KAO( :, 2, 6,13) = (/&
 & 7.3954E-02_JPRB,6.4757E-02_JPRB,5.6182E-02_JPRB,4.9451E-02_JPRB,4.2376E-02_JPRB,3.6480E-02_JPRB,&
 & 3.0034E-02_JPRB,2.6432E-02_JPRB,2.9602E-02_JPRB/)  
KAO( :, 3, 6,13) = (/&
 & 7.2618E-02_JPRB,6.3591E-02_JPRB,5.5752E-02_JPRB,4.9591E-02_JPRB,4.3630E-02_JPRB,3.8182E-02_JPRB,&
 & 3.2101E-02_JPRB,3.0615E-02_JPRB,3.4863E-02_JPRB/)  
KAO( :, 4, 6,13) = (/&
 & 7.1650E-02_JPRB,6.2766E-02_JPRB,5.5838E-02_JPRB,4.9867E-02_JPRB,4.5071E-02_JPRB,3.9626E-02_JPRB,&
 & 3.4633E-02_JPRB,3.5415E-02_JPRB,4.0513E-02_JPRB/)  
KAO( :, 5, 6,13) = (/&
 & 7.0928E-02_JPRB,6.2275E-02_JPRB,5.5944E-02_JPRB,5.0656E-02_JPRB,4.6360E-02_JPRB,4.1240E-02_JPRB,&
 & 3.7820E-02_JPRB,4.0601E-02_JPRB,4.6473E-02_JPRB/)  
KAO( :, 1, 7,13) = (/&
 & 7.7231E-02_JPRB,6.7608E-02_JPRB,5.8137E-02_JPRB,5.0496E-02_JPRB,4.2780E-02_JPRB,3.5440E-02_JPRB,&
 & 2.8711E-02_JPRB,2.1532E-02_JPRB,2.1358E-02_JPRB/)  
KAO( :, 2, 7,13) = (/&
 & 7.6126E-02_JPRB,6.6645E-02_JPRB,5.7867E-02_JPRB,5.0956E-02_JPRB,4.3638E-02_JPRB,3.7441E-02_JPRB,&
 & 3.0756E-02_JPRB,2.4515E-02_JPRB,2.6150E-02_JPRB/)  
KAO( :, 3, 7,13) = (/&
 & 7.4977E-02_JPRB,6.5643E-02_JPRB,5.7692E-02_JPRB,5.1264E-02_JPRB,4.5058E-02_JPRB,3.9385E-02_JPRB,&
 & 3.2638E-02_JPRB,2.8375E-02_JPRB,3.1403E-02_JPRB/)  
KAO( :, 4, 7,13) = (/&
 & 7.4190E-02_JPRB,6.5005E-02_JPRB,5.7989E-02_JPRB,5.1738E-02_JPRB,4.6795E-02_JPRB,4.1075E-02_JPRB,&
 & 3.4915E-02_JPRB,3.2892E-02_JPRB,3.7110E-02_JPRB/)  
KAO( :, 5, 7,13) = (/&
 & 7.3624E-02_JPRB,6.4678E-02_JPRB,5.8242E-02_JPRB,5.2839E-02_JPRB,4.8405E-02_JPRB,4.2696E-02_JPRB,&
 & 3.7814E-02_JPRB,3.7869E-02_JPRB,4.3186E-02_JPRB/)  
KAO( :, 1, 8,13) = (/&
 & 7.8000E-02_JPRB,6.8274E-02_JPRB,5.8718E-02_JPRB,5.1101E-02_JPRB,4.3121E-02_JPRB,3.5929E-02_JPRB,&
 & 2.8945E-02_JPRB,2.0591E-02_JPRB,1.8045E-02_JPRB/)  
KAO( :, 2, 8,13) = (/&
 & 7.7193E-02_JPRB,6.7571E-02_JPRB,5.8739E-02_JPRB,5.1625E-02_JPRB,4.4291E-02_JPRB,3.8058E-02_JPRB,&
 & 3.1224E-02_JPRB,2.3099E-02_JPRB,2.2474E-02_JPRB/)  
KAO( :, 3, 8,13) = (/&
 & 7.6273E-02_JPRB,6.6769E-02_JPRB,5.8915E-02_JPRB,5.2274E-02_JPRB,4.5989E-02_JPRB,4.0273E-02_JPRB,&
 & 3.3241E-02_JPRB,2.6350E-02_JPRB,2.7546E-02_JPRB/)  
KAO( :, 4, 8,13) = (/&
 & 7.5688E-02_JPRB,6.6346E-02_JPRB,5.9396E-02_JPRB,5.3087E-02_JPRB,4.8066E-02_JPRB,4.2222E-02_JPRB,&
 & 3.5406E-02_JPRB,3.0325E-02_JPRB,3.3143E-02_JPRB/)  
KAO( :, 5, 8,13) = (/&
 & 7.5270E-02_JPRB,6.6169E-02_JPRB,5.9886E-02_JPRB,5.4558E-02_JPRB,5.0013E-02_JPRB,4.4073E-02_JPRB,&
 & 3.8032E-02_JPRB,3.5067E-02_JPRB,3.9209E-02_JPRB/)  
KAO( :, 1, 9,13) = (/&
 & 7.7473E-02_JPRB,6.7808E-02_JPRB,5.8332E-02_JPRB,5.0781E-02_JPRB,4.2784E-02_JPRB,3.5895E-02_JPRB,&
 & 2.8746E-02_JPRB,1.9977E-02_JPRB,2.5516E-02_JPRB/)  
KAO( :, 2, 9,13) = (/&
 & 7.6914E-02_JPRB,6.7321E-02_JPRB,5.8710E-02_JPRB,5.1554E-02_JPRB,4.4348E-02_JPRB,3.8188E-02_JPRB,&
 & 3.1209E-02_JPRB,2.2143E-02_JPRB,2.7211E-02_JPRB/)  
KAO( :, 3, 9,13) = (/&
 & 7.6348E-02_JPRB,6.6831E-02_JPRB,5.9238E-02_JPRB,5.2455E-02_JPRB,4.6359E-02_JPRB,4.0690E-02_JPRB,&
 & 3.3365E-02_JPRB,2.4927E-02_JPRB,2.8892E-02_JPRB/)  
KAO( :, 4, 9,13) = (/&
 & 7.6078E-02_JPRB,6.6718E-02_JPRB,5.9965E-02_JPRB,5.3687E-02_JPRB,4.8782E-02_JPRB,4.2963E-02_JPRB,&
 & 3.5682E-02_JPRB,2.8422E-02_JPRB,3.1640E-02_JPRB/)  
KAO( :, 5, 9,13) = (/&
 & 7.5933E-02_JPRB,6.6835E-02_JPRB,6.0758E-02_JPRB,5.5666E-02_JPRB,5.1075E-02_JPRB,4.5007E-02_JPRB,&
 & 3.8345E-02_JPRB,3.2458E-02_JPRB,3.5657E-02_JPRB/)  
KAO( :, 1,10,13) = (/&
 & 7.5495E-02_JPRB,6.6073E-02_JPRB,5.6962E-02_JPRB,4.9669E-02_JPRB,4.1944E-02_JPRB,3.5433E-02_JPRB,&
 & 2.8273E-02_JPRB,1.9547E-02_JPRB,6.8270E-02_JPRB/)  
KAO( :, 2,10,13) = (/&
 & 7.5127E-02_JPRB,6.5753E-02_JPRB,5.7655E-02_JPRB,5.0612E-02_JPRB,4.3966E-02_JPRB,3.7985E-02_JPRB,&
 & 3.0798E-02_JPRB,2.1586E-02_JPRB,7.2556E-02_JPRB/)  
KAO( :, 3,10,13) = (/&
 & 7.4986E-02_JPRB,6.5658E-02_JPRB,5.8530E-02_JPRB,5.1941E-02_JPRB,4.6351E-02_JPRB,4.0729E-02_JPRB,&
 & 3.3154E-02_JPRB,2.4145E-02_JPRB,7.6901E-02_JPRB/)  
KAO( :, 4,10,13) = (/&
 & 7.5261E-02_JPRB,6.6078E-02_JPRB,5.9658E-02_JPRB,5.3761E-02_JPRB,4.9061E-02_JPRB,4.3256E-02_JPRB,&
 & 3.5593E-02_JPRB,2.7205E-02_JPRB,8.0949E-02_JPRB/)  
KAO( :, 5,10,13) = (/&
 & 7.5310E-02_JPRB,6.6484E-02_JPRB,6.0891E-02_JPRB,5.6203E-02_JPRB,5.1608E-02_JPRB,4.5631E-02_JPRB,&
 & 3.8393E-02_JPRB,3.0810E-02_JPRB,8.3946E-02_JPRB/)  
KAO( :, 1,11,13) = (/&
 & 7.2145E-02_JPRB,6.3140E-02_JPRB,5.5079E-02_JPRB,4.8199E-02_JPRB,4.1552E-02_JPRB,3.5607E-02_JPRB,&
 & 2.8410E-02_JPRB,2.0333E-02_JPRB,1.1722E-01_JPRB/)  
KAO( :, 2,11,13) = (/&
 & 7.2308E-02_JPRB,6.3289E-02_JPRB,5.6229E-02_JPRB,4.9646E-02_JPRB,4.4153E-02_JPRB,3.8471E-02_JPRB,&
 & 3.1024E-02_JPRB,2.2227E-02_JPRB,1.2017E-01_JPRB/)  
KAO( :, 3,11,13) = (/&
 & 7.2843E-02_JPRB,6.3926E-02_JPRB,5.7644E-02_JPRB,5.1784E-02_JPRB,4.7031E-02_JPRB,4.1323E-02_JPRB,&
 & 3.3588E-02_JPRB,2.4733E-02_JPRB,1.2387E-01_JPRB/)  
KAO( :, 4,11,13) = (/&
 & 7.3135E-02_JPRB,6.4581E-02_JPRB,5.9101E-02_JPRB,5.4448E-02_JPRB,4.9988E-02_JPRB,4.3915E-02_JPRB,&
 & 3.6387E-02_JPRB,2.7718E-02_JPRB,1.2773E-01_JPRB/)  
KAO( :, 5,11,13) = (/&
 & 7.3317E-02_JPRB,6.5357E-02_JPRB,6.0772E-02_JPRB,5.7257E-02_JPRB,5.2643E-02_JPRB,4.6647E-02_JPRB,&
 & 3.9495E-02_JPRB,3.1088E-02_JPRB,1.3117E-01_JPRB/)  
KAO( :, 1,12,13) = (/&
 & 6.8339E-02_JPRB,5.9807E-02_JPRB,5.2868E-02_JPRB,4.6514E-02_JPRB,4.1030E-02_JPRB,3.5325E-02_JPRB,&
 & 2.8259E-02_JPRB,2.1368E-02_JPRB,1.5845E-01_JPRB/)  
KAO( :, 2,12,13) = (/&
 & 6.9028E-02_JPRB,6.0544E-02_JPRB,5.4494E-02_JPRB,4.8800E-02_JPRB,4.4025E-02_JPRB,3.8260E-02_JPRB,&
 & 3.0917E-02_JPRB,2.3169E-02_JPRB,1.6072E-01_JPRB/)  
KAO( :, 3,12,13) = (/&
 & 6.9564E-02_JPRB,6.1451E-02_JPRB,5.6107E-02_JPRB,5.1605E-02_JPRB,4.7233E-02_JPRB,4.1139E-02_JPRB,&
 & 3.3727E-02_JPRB,2.5462E-02_JPRB,1.6379E-01_JPRB/)  
KAO( :, 4,12,13) = (/&
 & 7.0110E-02_JPRB,6.2544E-02_JPRB,5.8080E-02_JPRB,5.4612E-02_JPRB,5.0269E-02_JPRB,4.4060E-02_JPRB,&
 & 3.6850E-02_JPRB,2.8277E-02_JPRB,1.6703E-01_JPRB/)  
KAO( :, 5,12,13) = (/&
 & 7.0812E-02_JPRB,6.3874E-02_JPRB,6.0361E-02_JPRB,5.7551E-02_JPRB,5.3132E-02_JPRB,4.7188E-02_JPRB,&
 & 4.0179E-02_JPRB,3.1468E-02_JPRB,1.7022E-01_JPRB/)  
KAO( :, 1,13,13) = (/&
 & 6.4142E-02_JPRB,5.6225E-02_JPRB,5.0394E-02_JPRB,4.4947E-02_JPRB,4.0201E-02_JPRB,3.4418E-02_JPRB,&
 & 2.8158E-02_JPRB,2.2746E-02_JPRB,1.7050E-01_JPRB/)  
KAO( :, 2,13,13) = (/&
 & 6.4886E-02_JPRB,5.7309E-02_JPRB,5.2171E-02_JPRB,4.7818E-02_JPRB,4.3432E-02_JPRB,3.7455E-02_JPRB,&
 & 3.0630E-02_JPRB,2.4364E-02_JPRB,1.7276E-01_JPRB/)  
KAO( :, 3,13,13) = (/&
 & 6.5727E-02_JPRB,5.8652E-02_JPRB,5.4299E-02_JPRB,5.0937E-02_JPRB,4.6609E-02_JPRB,4.0612E-02_JPRB,&
 & 3.3484E-02_JPRB,2.6453E-02_JPRB,1.7566E-01_JPRB/)  
KAO( :, 4,13,13) = (/&
 & 6.6753E-02_JPRB,6.0302E-02_JPRB,5.6875E-02_JPRB,5.4053E-02_JPRB,4.9735E-02_JPRB,4.3858E-02_JPRB,&
 & 3.6837E-02_JPRB,2.8969E-02_JPRB,1.7832E-01_JPRB/)  
KAO( :, 5,13,13) = (/&
 & 6.7695E-02_JPRB,6.1869E-02_JPRB,5.9620E-02_JPRB,5.7064E-02_JPRB,5.2850E-02_JPRB,4.7362E-02_JPRB,&
 & 4.0382E-02_JPRB,3.1936E-02_JPRB,1.8057E-01_JPRB/)  
KAO( :, 1, 1,14) = (/&
 & 7.1125E-02_JPRB,6.2447E-02_JPRB,5.3777E-02_JPRB,4.6002E-02_JPRB,3.9919E-02_JPRB,3.6099E-02_JPRB,&
 & 4.0006E-02_JPRB,4.6122E-02_JPRB,5.1833E-02_JPRB/)  
KAO( :, 2, 1,14) = (/&
 & 6.9870E-02_JPRB,6.1342E-02_JPRB,5.2827E-02_JPRB,4.5922E-02_JPRB,4.0565E-02_JPRB,3.9007E-02_JPRB,&
 & 4.5679E-02_JPRB,5.2643E-02_JPRB,5.9148E-02_JPRB/)  
KAO( :, 3, 1,14) = (/&
 & 6.8757E-02_JPRB,6.0364E-02_JPRB,5.2393E-02_JPRB,4.6480E-02_JPRB,4.1375E-02_JPRB,4.3228E-02_JPRB,&
 & 5.1554E-02_JPRB,5.9415E-02_JPRB,6.6727E-02_JPRB/)  
KAO( :, 4, 1,14) = (/&
 & 6.7713E-02_JPRB,5.9439E-02_JPRB,5.2158E-02_JPRB,4.6803E-02_JPRB,4.2633E-02_JPRB,4.8201E-02_JPRB,&
 & 5.7539E-02_JPRB,6.6348E-02_JPRB,7.4536E-02_JPRB/)  
KAO( :, 5, 1,14) = (/&
 & 6.6600E-02_JPRB,5.8466E-02_JPRB,5.1820E-02_JPRB,4.7055E-02_JPRB,4.4661E-02_JPRB,5.3325E-02_JPRB,&
 & 6.3678E-02_JPRB,7.3404E-02_JPRB,8.2448E-02_JPRB/)  
KAO( :, 1, 2,14) = (/&
 & 7.7042E-02_JPRB,6.7550E-02_JPRB,5.8058E-02_JPRB,4.9570E-02_JPRB,4.3264E-02_JPRB,3.8479E-02_JPRB,&
 & 4.1328E-02_JPRB,4.7688E-02_JPRB,5.4228E-02_JPRB/)  
KAO( :, 2, 2,14) = (/&
 & 7.5776E-02_JPRB,6.6451E-02_JPRB,5.7187E-02_JPRB,4.9780E-02_JPRB,4.4125E-02_JPRB,4.1352E-02_JPRB,&
 & 4.7706E-02_JPRB,5.5037E-02_JPRB,6.2579E-02_JPRB/)  
KAO( :, 3, 2,14) = (/&
 & 7.4669E-02_JPRB,6.5491E-02_JPRB,5.6847E-02_JPRB,5.0512E-02_JPRB,4.5218E-02_JPRB,4.5782E-02_JPRB,&
 & 5.4332E-02_JPRB,6.2645E-02_JPRB,7.1228E-02_JPRB/)  
KAO( :, 4, 2,14) = (/&
 & 7.3494E-02_JPRB,6.4459E-02_JPRB,5.6471E-02_JPRB,5.0688E-02_JPRB,4.6511E-02_JPRB,5.1170E-02_JPRB,&
 & 6.1095E-02_JPRB,7.0411E-02_JPRB,8.0040E-02_JPRB/)  
KAO( :, 5, 2,14) = (/&
 & 7.2133E-02_JPRB,6.3274E-02_JPRB,5.5909E-02_JPRB,5.0987E-02_JPRB,4.8402E-02_JPRB,5.6911E-02_JPRB,&
 & 6.7954E-02_JPRB,7.8300E-02_JPRB,8.9007E-02_JPRB/)  
KAO( :, 1, 3,14) = (/&
 & 8.3277E-02_JPRB,7.2971E-02_JPRB,6.2667E-02_JPRB,5.3474E-02_JPRB,4.6645E-02_JPRB,4.0581E-02_JPRB,&
 & 4.0951E-02_JPRB,4.7132E-02_JPRB,5.4097E-02_JPRB/)  
KAO( :, 2, 3,14) = (/&
 & 8.2055E-02_JPRB,7.1904E-02_JPRB,6.1829E-02_JPRB,5.3750E-02_JPRB,4.7688E-02_JPRB,4.3144E-02_JPRB,&
 & 4.7845E-02_JPRB,5.5169E-02_JPRB,6.3384E-02_JPRB/)  
KAO( :, 3, 3,14) = (/&
 & 8.0862E-02_JPRB,7.0861E-02_JPRB,6.1457E-02_JPRB,5.4455E-02_JPRB,4.8823E-02_JPRB,4.7333E-02_JPRB,&
 & 5.5190E-02_JPRB,6.3675E-02_JPRB,7.3215E-02_JPRB/)  
KAO( :, 4, 3,14) = (/&
 & 7.9537E-02_JPRB,6.9705E-02_JPRB,6.0972E-02_JPRB,5.4811E-02_JPRB,5.0281E-02_JPRB,5.2809E-02_JPRB,&
 & 6.2782E-02_JPRB,7.2454E-02_JPRB,8.3349E-02_JPRB/)  
KAO( :, 5, 3,14) = (/&
 & 7.8064E-02_JPRB,6.8419E-02_JPRB,6.0465E-02_JPRB,5.5324E-02_JPRB,5.2307E-02_JPRB,5.9034E-02_JPRB,&
 & 7.0524E-02_JPRB,8.1382E-02_JPRB,9.3638E-02_JPRB/)  
KAO( :, 1, 4,14) = (/&
 & 9.0845E-02_JPRB,7.9564E-02_JPRB,6.8284E-02_JPRB,5.7995E-02_JPRB,5.0071E-02_JPRB,4.2766E-02_JPRB,&
 & 4.0354E-02_JPRB,4.5834E-02_JPRB,5.2848E-02_JPRB/)  
KAO( :, 2, 4,14) = (/&
 & 8.9552E-02_JPRB,7.8435E-02_JPRB,6.7367E-02_JPRB,5.8123E-02_JPRB,5.1123E-02_JPRB,4.5183E-02_JPRB,&
 & 4.7218E-02_JPRB,5.4390E-02_JPRB,6.2802E-02_JPRB/)  
KAO( :, 3, 4,14) = (/&
 & 8.8242E-02_JPRB,7.7291E-02_JPRB,6.6872E-02_JPRB,5.8721E-02_JPRB,5.2277E-02_JPRB,4.9062E-02_JPRB,&
 & 5.5104E-02_JPRB,6.3535E-02_JPRB,7.3415E-02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART9',1,ZHOOK_HANDLE)
END SUBROUTINE PART9


SUBROUTINE PART10

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART10',0,ZHOOK_HANDLE)


KAO( :, 4, 4,14) = (/&
 & 8.6759E-02_JPRB,7.5998E-02_JPRB,6.6249E-02_JPRB,5.9144E-02_JPRB,5.4005E-02_JPRB,5.4305E-02_JPRB,&
 & 6.3297E-02_JPRB,7.3031E-02_JPRB,8.4384E-02_JPRB/)  
KAO( :, 5, 4,14) = (/&
 & 8.5264E-02_JPRB,7.4691E-02_JPRB,6.5716E-02_JPRB,5.9851E-02_JPRB,5.6460E-02_JPRB,6.0471E-02_JPRB,&
 & 7.1720E-02_JPRB,8.2783E-02_JPRB,9.5664E-02_JPRB/)  
KAO( :, 1, 5,14) = (/&
 & 9.9315E-02_JPRB,8.6956E-02_JPRB,7.4597E-02_JPRB,6.3098E-02_JPRB,5.3822E-02_JPRB,4.5087E-02_JPRB,&
 & 4.0285E-02_JPRB,4.4268E-02_JPRB,5.1127E-02_JPRB/)  
KAO( :, 2, 5,14) = (/&
 & 9.7906E-02_JPRB,8.5725E-02_JPRB,7.3576E-02_JPRB,6.3138E-02_JPRB,5.4941E-02_JPRB,4.7422E-02_JPRB,&
 & 4.6902E-02_JPRB,5.3385E-02_JPRB,6.1752E-02_JPRB/)  
KAO( :, 3, 5,14) = (/&
 & 9.6528E-02_JPRB,8.4522E-02_JPRB,7.2985E-02_JPRB,6.3691E-02_JPRB,5.5941E-02_JPRB,5.1390E-02_JPRB,&
 & 5.4800E-02_JPRB,6.3141E-02_JPRB,7.3064E-02_JPRB/)  
KAO( :, 4, 5,14) = (/&
 & 9.5030E-02_JPRB,8.3215E-02_JPRB,7.2382E-02_JPRB,6.4248E-02_JPRB,5.7876E-02_JPRB,5.6367E-02_JPRB,&
 & 6.3403E-02_JPRB,7.3204E-02_JPRB,8.4675E-02_JPRB/)  
KAO( :, 5, 5,14) = (/&
 & 9.3519E-02_JPRB,8.1896E-02_JPRB,7.1942E-02_JPRB,6.4913E-02_JPRB,6.0750E-02_JPRB,6.2288E-02_JPRB,&
 & 7.2363E-02_JPRB,8.3574E-02_JPRB,9.6711E-02_JPRB/)  
KAO( :, 1, 6,14) = (/&
 & 1.0848E-01_JPRB,9.4964E-02_JPRB,8.1446E-02_JPRB,6.8624E-02_JPRB,5.8073E-02_JPRB,4.7733E-02_JPRB,&
 & 4.0794E-02_JPRB,4.2233E-02_JPRB,4.8838E-02_JPRB/)  
KAO( :, 2, 6,14) = (/&
 & 1.0700E-01_JPRB,9.3665E-02_JPRB,8.0341E-02_JPRB,6.8687E-02_JPRB,5.9287E-02_JPRB,4.9965E-02_JPRB,&
 & 4.6801E-02_JPRB,5.1522E-02_JPRB,5.9571E-02_JPRB/)  
KAO( :, 3, 6,14) = (/&
 & 1.0569E-01_JPRB,9.2526E-02_JPRB,7.9786E-02_JPRB,6.9323E-02_JPRB,6.0296E-02_JPRB,5.3850E-02_JPRB,&
 & 5.4326E-02_JPRB,6.1617E-02_JPRB,7.1174E-02_JPRB/)  
KAO( :, 4, 6,14) = (/&
 & 1.0422E-01_JPRB,9.1243E-02_JPRB,7.9257E-02_JPRB,7.0200E-02_JPRB,6.2110E-02_JPRB,5.8890E-02_JPRB,&
 & 6.2697E-02_JPRB,7.2186E-02_JPRB,8.3411E-02_JPRB/)  
KAO( :, 5, 6,14) = (/&
 & 1.0274E-01_JPRB,8.9945E-02_JPRB,7.8955E-02_JPRB,7.0870E-02_JPRB,6.5007E-02_JPRB,6.4538E-02_JPRB,&
 & 7.1962E-02_JPRB,8.3225E-02_JPRB,9.6184E-02_JPRB/)  
KAO( :, 1, 7,14) = (/&
 & 1.1805E-01_JPRB,1.0333E-01_JPRB,8.8604E-02_JPRB,7.4383E-02_JPRB,6.2795E-02_JPRB,5.0938E-02_JPRB,&
 & 4.1734E-02_JPRB,4.0173E-02_JPRB,4.6320E-02_JPRB/)  
KAO( :, 2, 7,14) = (/&
 & 1.1659E-01_JPRB,1.0206E-01_JPRB,8.7517E-02_JPRB,7.4746E-02_JPRB,6.4050E-02_JPRB,5.3141E-02_JPRB,&
 & 4.7155E-02_JPRB,4.9297E-02_JPRB,5.6966E-02_JPRB/)  
KAO( :, 3, 7,14) = (/&
 & 1.1548E-01_JPRB,1.0108E-01_JPRB,8.7065E-02_JPRB,7.5639E-02_JPRB,6.5270E-02_JPRB,5.6793E-02_JPRB,&
 & 5.4049E-02_JPRB,5.9341E-02_JPRB,6.8535E-02_JPRB/)  
KAO( :, 4, 7,14) = (/&
 & 1.1421E-01_JPRB,9.9974E-02_JPRB,8.6788E-02_JPRB,7.6683E-02_JPRB,6.6954E-02_JPRB,6.1718E-02_JPRB,&
 & 6.2059E-02_JPRB,7.0009E-02_JPRB,8.0835E-02_JPRB/)  
KAO( :, 5, 7,14) = (/&
 & 1.1283E-01_JPRB,9.8769E-02_JPRB,8.6621E-02_JPRB,7.7418E-02_JPRB,6.9776E-02_JPRB,6.7214E-02_JPRB,&
 & 7.0897E-02_JPRB,8.1280E-02_JPRB,9.3717E-02_JPRB/)  
KAO( :, 1, 8,14) = (/&
 & 1.2760E-01_JPRB,1.1168E-01_JPRB,9.5756E-02_JPRB,8.0242E-02_JPRB,6.7771E-02_JPRB,5.4512E-02_JPRB,&
 & 4.3297E-02_JPRB,3.8468E-02_JPRB,4.3412E-02_JPRB/)  
KAO( :, 2, 8,14) = (/&
 & 1.2647E-01_JPRB,1.1069E-01_JPRB,9.4911E-02_JPRB,8.1080E-02_JPRB,6.9303E-02_JPRB,5.6801E-02_JPRB,&
 & 4.8262E-02_JPRB,4.7089E-02_JPRB,5.4046E-02_JPRB/)  
KAO( :, 3, 8,14) = (/&
 & 1.2554E-01_JPRB,1.0988E-01_JPRB,9.4556E-02_JPRB,8.2231E-02_JPRB,7.0704E-02_JPRB,6.0253E-02_JPRB,&
 & 5.4589E-02_JPRB,5.6872E-02_JPRB,6.5560E-02_JPRB/)  
KAO( :, 4, 8,14) = (/&
 & 1.2457E-01_JPRB,1.0903E-01_JPRB,9.4616E-02_JPRB,8.3457E-02_JPRB,7.2396E-02_JPRB,6.4980E-02_JPRB,&
 & 6.1867E-02_JPRB,6.7548E-02_JPRB,7.7808E-02_JPRB/)  
KAO( :, 5, 8,14) = (/&
 & 1.2330E-01_JPRB,1.0792E-01_JPRB,9.4626E-02_JPRB,8.4389E-02_JPRB,7.5157E-02_JPRB,7.0416E-02_JPRB,&
 & 7.0105E-02_JPRB,7.8665E-02_JPRB,9.0560E-02_JPRB/)  
KAO( :, 1, 9,14) = (/&
 & 1.3720E-01_JPRB,1.2007E-01_JPRB,1.0294E-01_JPRB,8.6103E-02_JPRB,7.2470E-02_JPRB,5.8097E-02_JPRB,&
 & 4.5389E-02_JPRB,3.6904E-02_JPRB,4.1799E-02_JPRB/)  
KAO( :, 2, 9,14) = (/&
 & 1.3628E-01_JPRB,1.1927E-01_JPRB,1.0226E-01_JPRB,8.7181E-02_JPRB,7.4343E-02_JPRB,6.0740E-02_JPRB,&
 & 4.9959E-02_JPRB,4.4876E-02_JPRB,5.0393E-02_JPRB/)  
KAO( :, 3, 9,14) = (/&
 & 1.3535E-01_JPRB,1.1846E-01_JPRB,1.0188E-01_JPRB,8.8693E-02_JPRB,7.6184E-02_JPRB,6.4206E-02_JPRB,&
 & 5.5907E-02_JPRB,5.4085E-02_JPRB,6.1556E-02_JPRB/)  
KAO( :, 4, 9,14) = (/&
 & 1.3444E-01_JPRB,1.1766E-01_JPRB,1.0208E-01_JPRB,9.0218E-02_JPRB,7.8130E-02_JPRB,6.8528E-02_JPRB,&
 & 6.2619E-02_JPRB,6.4323E-02_JPRB,7.3797E-02_JPRB/)  
KAO( :, 5, 9,14) = (/&
 & 1.3348E-01_JPRB,1.1683E-01_JPRB,1.0242E-01_JPRB,9.1503E-02_JPRB,8.0977E-02_JPRB,7.3855E-02_JPRB,&
 & 6.9865E-02_JPRB,7.5417E-02_JPRB,8.6747E-02_JPRB/)  
KAO( :, 1,10,14) = (/&
 & 1.4622E-01_JPRB,1.2796E-01_JPRB,1.0970E-01_JPRB,9.1694E-02_JPRB,7.6915E-02_JPRB,6.1594E-02_JPRB,&
 & 4.7802E-02_JPRB,3.6372E-02_JPRB,1.2782E-01_JPRB/)  
KAO( :, 2,10,14) = (/&
 & 1.4558E-01_JPRB,1.2740E-01_JPRB,1.0923E-01_JPRB,9.3107E-02_JPRB,7.9235E-02_JPRB,6.4561E-02_JPRB,&
 & 5.2530E-02_JPRB,4.3432E-02_JPRB,1.2805E-01_JPRB/)  
KAO( :, 3,10,14) = (/&
 & 1.4478E-01_JPRB,1.2670E-01_JPRB,1.0897E-01_JPRB,9.4925E-02_JPRB,8.1357E-02_JPRB,6.8532E-02_JPRB,&
 & 5.8051E-02_JPRB,5.1858E-02_JPRB,1.2910E-01_JPRB/)  
KAO( :, 4,10,14) = (/&
 & 1.4390E-01_JPRB,1.2594E-01_JPRB,1.0930E-01_JPRB,9.6640E-02_JPRB,8.3903E-02_JPRB,7.3006E-02_JPRB,&
 & 6.4450E-02_JPRB,6.1593E-02_JPRB,1.3078E-01_JPRB/)  
KAO( :, 5,10,14) = (/&
 & 1.4315E-01_JPRB,1.2528E-01_JPRB,1.1004E-01_JPRB,9.8357E-02_JPRB,8.7154E-02_JPRB,7.8009E-02_JPRB,&
 & 7.1120E-02_JPRB,7.2455E-02_JPRB,1.3316E-01_JPRB/)  
KAO( :, 1,11,14) = (/&
 & 1.5395E-01_JPRB,1.3473E-01_JPRB,1.1550E-01_JPRB,9.7315E-02_JPRB,8.2228E-02_JPRB,6.6162E-02_JPRB,&
 & 5.2338E-02_JPRB,3.8889E-02_JPRB,2.0928E-01_JPRB/)  
KAO( :, 2,11,14) = (/&
 & 1.5355E-01_JPRB,1.3437E-01_JPRB,1.1530E-01_JPRB,9.9444E-02_JPRB,8.4668E-02_JPRB,7.0074E-02_JPRB,&
 & 5.7545E-02_JPRB,4.5714E-02_JPRB,2.1031E-01_JPRB/)  
KAO( :, 3,11,14) = (/&
 & 1.5306E-01_JPRB,1.3395E-01_JPRB,1.1569E-01_JPRB,1.0160E-01_JPRB,8.7341E-02_JPRB,7.4791E-02_JPRB,&
 & 6.3171E-02_JPRB,5.3818E-02_JPRB,2.0902E-01_JPRB/)  
KAO( :, 4,11,14) = (/&
 & 1.5264E-01_JPRB,1.3359E-01_JPRB,1.1675E-01_JPRB,1.0361E-01_JPRB,9.0695E-02_JPRB,7.9958E-02_JPRB,&
 & 6.9362E-02_JPRB,6.3424E-02_JPRB,2.0832E-01_JPRB/)  
KAO( :, 5,11,14) = (/&
 & 1.5211E-01_JPRB,1.3312E-01_JPRB,1.1800E-01_JPRB,1.0575E-01_JPRB,9.4915E-02_JPRB,8.5107E-02_JPRB,&
 & 7.5798E-02_JPRB,7.4229E-02_JPRB,2.0949E-01_JPRB/)  
KAO( :, 1,12,14) = (/&
 & 1.6007E-01_JPRB,1.4008E-01_JPRB,1.2008E-01_JPRB,1.0232E-01_JPRB,8.6761E-02_JPRB,7.0740E-02_JPRB,&
 & 5.6718E-02_JPRB,4.1250E-02_JPRB,2.6518E-01_JPRB/)  
KAO( :, 2,12,14) = (/&
 & 1.6020E-01_JPRB,1.4019E-01_JPRB,1.2063E-01_JPRB,1.0501E-01_JPRB,8.9744E-02_JPRB,7.5616E-02_JPRB,&
 & 6.2355E-02_JPRB,4.7922E-02_JPRB,2.6549E-01_JPRB/)  
KAO( :, 3,12,14) = (/&
 & 1.6044E-01_JPRB,1.4040E-01_JPRB,1.2209E-01_JPRB,1.0775E-01_JPRB,9.3316E-02_JPRB,8.1050E-02_JPRB,&
 & 6.8087E-02_JPRB,5.5672E-02_JPRB,2.6354E-01_JPRB/)  
KAO( :, 4,12,14) = (/&
 & 1.6037E-01_JPRB,1.4035E-01_JPRB,1.2384E-01_JPRB,1.1034E-01_JPRB,9.7597E-02_JPRB,8.6743E-02_JPRB,&
 & 7.4072E-02_JPRB,6.4868E-02_JPRB,2.6219E-01_JPRB/)  
KAO( :, 5,12,14) = (/&
 & 1.6003E-01_JPRB,1.4017E-01_JPRB,1.2549E-01_JPRB,1.1310E-01_JPRB,1.0250E-01_JPRB,9.1994E-02_JPRB,&
 & 8.0439E-02_JPRB,7.5469E-02_JPRB,2.6239E-01_JPRB/)  
KAO( :, 1,13,14) = (/&
 & 1.6469E-01_JPRB,1.4412E-01_JPRB,1.2368E-01_JPRB,1.0640E-01_JPRB,9.0617E-02_JPRB,7.5149E-02_JPRB,&
 & 6.0781E-02_JPRB,4.3348E-02_JPRB,2.6721E-01_JPRB/)  
KAO( :, 2,13,14) = (/&
 & 1.6562E-01_JPRB,1.4493E-01_JPRB,1.2548E-01_JPRB,1.0990E-01_JPRB,9.4570E-02_JPRB,8.0925E-02_JPRB,&
 & 6.6783E-02_JPRB,4.9779E-02_JPRB,2.6700E-01_JPRB/)  
KAO( :, 3,13,14) = (/&
 & 1.6629E-01_JPRB,1.4552E-01_JPRB,1.2768E-01_JPRB,1.1332E-01_JPRB,9.9317E-02_JPRB,8.6925E-02_JPRB,&
 & 7.2626E-02_JPRB,5.7255E-02_JPRB,2.6579E-01_JPRB/)  
KAO( :, 4,13,14) = (/&
 & 1.6653E-01_JPRB,1.4581E-01_JPRB,1.2999E-01_JPRB,1.1666E-01_JPRB,1.0451E-01_JPRB,9.2915E-02_JPRB,&
 & 7.8534E-02_JPRB,6.6130E-02_JPRB,2.6675E-01_JPRB/)  
KAO( :, 5,13,14) = (/&
 & 1.6684E-01_JPRB,1.4632E-01_JPRB,1.3221E-01_JPRB,1.2027E-01_JPRB,1.0991E-01_JPRB,9.8357E-02_JPRB,&
 & 8.4972E-02_JPRB,7.6473E-02_JPRB,2.6996E-01_JPRB/)  
KAO( :, 1, 1,15) = (/&
 & 8.6335E-02_JPRB,7.5626E-02_JPRB,6.4917E-02_JPRB,5.5295E-02_JPRB,5.0812E-02_JPRB,5.9948E-02_JPRB,&
 & 7.1505E-02_JPRB,8.2180E-02_JPRB,9.1859E-02_JPRB/)  
KAO( :, 2, 1,15) = (/&
 & 8.4567E-02_JPRB,7.4086E-02_JPRB,6.3604E-02_JPRB,5.5283E-02_JPRB,5.6490E-02_JPRB,6.9672E-02_JPRB,&
 & 8.3123E-02_JPRB,9.5602E-02_JPRB,1.0689E-01_JPRB/)  
KAO( :, 3, 1,15) = (/&
 & 8.2946E-02_JPRB,7.2675E-02_JPRB,6.2405E-02_JPRB,5.5773E-02_JPRB,6.3940E-02_JPRB,7.9639E-02_JPRB,&
 & 9.5049E-02_JPRB,1.0933E-01_JPRB,1.2237E-01_JPRB/)  
KAO( :, 4, 1,15) = (/&
 & 8.1353E-02_JPRB,7.1286E-02_JPRB,6.1452E-02_JPRB,5.8032E-02_JPRB,7.2168E-02_JPRB,8.9901E-02_JPRB,&
 & 1.0730E-01_JPRB,1.2343E-01_JPRB,1.3810E-01_JPRB/)  
KAO( :, 5, 1,15) = (/&
 & 8.0306E-02_JPRB,7.0375E-02_JPRB,6.1401E-02_JPRB,6.2088E-02_JPRB,8.0744E-02_JPRB,1.0061E-01_JPRB,&
 & 1.2011E-01_JPRB,1.3812E-01_JPRB,1.5455E-01_JPRB/)  
KAO( :, 1, 2,15) = (/&
 & 9.5589E-02_JPRB,8.3777E-02_JPRB,7.1976E-02_JPRB,6.1258E-02_JPRB,5.5368E-02_JPRB,6.4085E-02_JPRB,&
 & 7.6446E-02_JPRB,8.7825E-02_JPRB,9.9724E-02_JPRB/)  
KAO( :, 2, 2,15) = (/&
 & 9.3570E-02_JPRB,8.1988E-02_JPRB,7.0421E-02_JPRB,6.1059E-02_JPRB,6.1189E-02_JPRB,7.4507E-02_JPRB,&
 & 8.8919E-02_JPRB,1.0224E-01_JPRB,1.1610E-01_JPRB/)  
KAO( :, 3, 2,15) = (/&
 & 9.1829E-02_JPRB,8.0436E-02_JPRB,6.9070E-02_JPRB,6.1314E-02_JPRB,6.8582E-02_JPRB,8.5238E-02_JPRB,&
 & 1.0175E-01_JPRB,1.1706E-01_JPRB,1.3301E-01_JPRB/)  
KAO( :, 4, 2,15) = (/&
 & 9.0487E-02_JPRB,7.9254E-02_JPRB,6.8526E-02_JPRB,6.4228E-02_JPRB,7.7434E-02_JPRB,9.6498E-02_JPRB,&
 & 1.1522E-01_JPRB,1.3267E-01_JPRB,1.5077E-01_JPRB/)  
KAO( :, 5, 2,15) = (/&
 & 8.9669E-02_JPRB,7.8542E-02_JPRB,6.8954E-02_JPRB,6.8451E-02_JPRB,8.6910E-02_JPRB,1.0835E-01_JPRB,&
 & 1.2939E-01_JPRB,1.4902E-01_JPRB,1.6935E-01_JPRB/)  
KAO( :, 1, 3,15) = (/&
 & 1.0676E-01_JPRB,9.3553E-02_JPRB,8.0347E-02_JPRB,6.7838E-02_JPRB,5.9827E-02_JPRB,6.6522E-02_JPRB,&
 & 7.9363E-02_JPRB,9.1189E-02_JPRB,1.0525E-01_JPRB/)  
KAO( :, 2, 3,15) = (/&
 & 1.0446E-01_JPRB,9.1534E-02_JPRB,7.8612E-02_JPRB,6.7925E-02_JPRB,6.5040E-02_JPRB,7.7741E-02_JPRB,&
 & 9.2778E-02_JPRB,1.0667E-01_JPRB,1.2309E-01_JPRB/)  
KAO( :, 3, 3,15) = (/&
 & 1.0249E-01_JPRB,8.9809E-02_JPRB,7.7136E-02_JPRB,6.8091E-02_JPRB,7.2454E-02_JPRB,8.9300E-02_JPRB,&
 & 1.0660E-01_JPRB,1.2265E-01_JPRB,1.4148E-01_JPRB/)  
KAO( :, 4, 3,15) = (/&
 & 1.0145E-01_JPRB,8.8891E-02_JPRB,7.6929E-02_JPRB,7.0768E-02_JPRB,8.1305E-02_JPRB,1.0131E-01_JPRB,&
 & 1.2096E-01_JPRB,1.3918E-01_JPRB,1.6053E-01_JPRB/)  
KAO( :, 5, 3,15) = (/&
 & 1.0070E-01_JPRB,8.8241E-02_JPRB,7.7594E-02_JPRB,7.4852E-02_JPRB,9.1339E-02_JPRB,1.1386E-01_JPRB,&
 & 1.3595E-01_JPRB,1.5652E-01_JPRB,1.8047E-01_JPRB/)  
KAO( :, 1, 4,15) = (/&
 & 1.1948E-01_JPRB,1.0466E-01_JPRB,8.9846E-02_JPRB,7.5435E-02_JPRB,6.5653E-02_JPRB,6.8395E-02_JPRB,&
 & 8.1117E-02_JPRB,9.3286E-02_JPRB,1.0845E-01_JPRB/)  
KAO( :, 2, 4,15) = (/&
 & 1.1744E-01_JPRB,1.0288E-01_JPRB,8.8326E-02_JPRB,7.6088E-02_JPRB,7.0000E-02_JPRB,8.0045E-02_JPRB,&
 & 9.5565E-02_JPRB,1.0996E-01_JPRB,1.2777E-01_JPRB/)  
KAO( :, 3, 4,15) = (/&
 & 1.1572E-01_JPRB,1.0138E-01_JPRB,8.7035E-02_JPRB,7.6536E-02_JPRB,7.6949E-02_JPRB,9.2508E-02_JPRB,&
 & 1.1046E-01_JPRB,1.2718E-01_JPRB,1.4769E-01_JPRB/)  
KAO( :, 4, 4,15) = (/&
 & 1.1457E-01_JPRB,1.0037E-01_JPRB,8.6743E-02_JPRB,7.8791E-02_JPRB,8.5479E-02_JPRB,1.0549E-01_JPRB,&
 & 1.2598E-01_JPRB,1.4506E-01_JPRB,1.6844E-01_JPRB/)  
KAO( :, 5, 4,15) = (/&
 & 1.1371E-01_JPRB,9.9614E-02_JPRB,8.7543E-02_JPRB,8.2406E-02_JPRB,9.5523E-02_JPRB,1.1901E-01_JPRB,&
 & 1.4214E-01_JPRB,1.6372E-01_JPRB,1.9001E-01_JPRB/)  
KAO( :, 1, 5,15) = (/&
 & 1.3435E-01_JPRB,1.1765E-01_JPRB,1.0095E-01_JPRB,8.4469E-02_JPRB,7.2853E-02_JPRB,7.1272E-02_JPRB,&
 & 8.1960E-02_JPRB,9.4385E-02_JPRB,1.0990E-01_JPRB/)  
KAO( :, 2, 5,15) = (/&
 & 1.3249E-01_JPRB,1.1603E-01_JPRB,9.9565E-02_JPRB,8.5291E-02_JPRB,7.6670E-02_JPRB,8.2310E-02_JPRB,&
 & 9.7448E-02_JPRB,1.1228E-01_JPRB,1.3064E-01_JPRB/)  
KAO( :, 3, 5,15) = (/&
 & 1.3078E-01_JPRB,1.1453E-01_JPRB,9.8289E-02_JPRB,8.6209E-02_JPRB,8.3093E-02_JPRB,9.5057E-02_JPRB,&
 & 1.1357E-01_JPRB,1.3082E-01_JPRB,1.5225E-01_JPRB/)  
KAO( :, 4, 5,15) = (/&
 & 1.2949E-01_JPRB,1.1340E-01_JPRB,9.7892E-02_JPRB,8.8436E-02_JPRB,9.1112E-02_JPRB,1.0924E-01_JPRB,&
 & 1.3047E-01_JPRB,1.5034E-01_JPRB,1.7498E-01_JPRB/)  
KAO( :, 5, 5,15) = (/&
 & 1.2852E-01_JPRB,1.1256E-01_JPRB,9.8533E-02_JPRB,9.1755E-02_JPRB,1.0068E-01_JPRB,1.2400E-01_JPRB,&
 & 1.4814E-01_JPRB,1.7069E-01_JPRB,1.9863E-01_JPRB/)  
KAO( :, 1, 6,15) = (/&
 & 1.5076E-01_JPRB,1.3198E-01_JPRB,1.1320E-01_JPRB,9.4463E-02_JPRB,8.0666E-02_JPRB,7.5054E-02_JPRB,&
 & 8.0871E-02_JPRB,9.3264E-02_JPRB,1.0849E-01_JPRB/)  
KAO( :, 2, 6,15) = (/&
 & 1.4906E-01_JPRB,1.3049E-01_JPRB,1.1193E-01_JPRB,9.5115E-02_JPRB,8.4634E-02_JPRB,8.5281E-02_JPRB,&
 & 9.7599E-02_JPRB,1.1257E-01_JPRB,1.3098E-01_JPRB/)  
KAO( :, 3, 6,15) = (/&
 & 1.4751E-01_JPRB,1.2914E-01_JPRB,1.1077E-01_JPRB,9.6775E-02_JPRB,9.0721E-02_JPRB,9.7408E-02_JPRB,&
 & 1.1514E-01_JPRB,1.3281E-01_JPRB,1.5454E-01_JPRB/)  
KAO( :, 4, 6,15) = (/&
 & 1.4640E-01_JPRB,1.2818E-01_JPRB,1.1040E-01_JPRB,9.8990E-02_JPRB,9.8328E-02_JPRB,1.1180E-01_JPRB,&
 & 1.3358E-01_JPRB,1.5404E-01_JPRB,1.7929E-01_JPRB/)  
KAO( :, 5, 6,15) = (/&
 & 1.4534E-01_JPRB,1.2726E-01_JPRB,1.1100E-01_JPRB,1.0247E-01_JPRB,1.0712E-01_JPRB,1.2780E-01_JPRB,&
 & 1.5274E-01_JPRB,1.7614E-01_JPRB,2.0503E-01_JPRB/)  
KAO( :, 1, 7,15) = (/&
 & 1.7017E-01_JPRB,1.4895E-01_JPRB,1.2773E-01_JPRB,1.0651E-01_JPRB,8.8726E-02_JPRB,8.0014E-02_JPRB,&
 & 7.9958E-02_JPRB,9.0777E-02_JPRB,1.0558E-01_JPRB/)  
KAO( :, 2, 7,15) = (/&
 & 1.6840E-01_JPRB,1.4740E-01_JPRB,1.2641E-01_JPRB,1.0633E-01_JPRB,9.3561E-02_JPRB,8.9399E-02_JPRB,&
 & 9.6654E-02_JPRB,1.1154E-01_JPRB,1.2974E-01_JPRB/)  
KAO( :, 3, 7,15) = (/&
 & 1.6683E-01_JPRB,1.4603E-01_JPRB,1.2523E-01_JPRB,1.0816E-01_JPRB,9.9523E-02_JPRB,1.0085E-01_JPRB,&
 & 1.1565E-01_JPRB,1.3349E-01_JPRB,1.5523E-01_JPRB/)  
KAO( :, 4, 7,15) = (/&
 & 1.6579E-01_JPRB,1.4512E-01_JPRB,1.2467E-01_JPRB,1.1069E-01_JPRB,1.0674E-01_JPRB,1.1452E-01_JPRB,&
 & 1.3558E-01_JPRB,1.5645E-01_JPRB,1.8200E-01_JPRB/)  
KAO( :, 5, 7,15) = (/&
 & 1.6467E-01_JPRB,1.4415E-01_JPRB,1.2512E-01_JPRB,1.1428E-01_JPRB,1.1515E-01_JPRB,1.3096E-01_JPRB,&
 & 1.5653E-01_JPRB,1.8061E-01_JPRB,2.1020E-01_JPRB/)  
KAO( :, 1, 8,15) = (/&
 & 1.9300E-01_JPRB,1.6891E-01_JPRB,1.4482E-01_JPRB,1.2074E-01_JPRB,9.8428E-02_JPRB,8.6453E-02_JPRB,&
 & 8.0104E-02_JPRB,8.7414E-02_JPRB,1.0158E-01_JPRB/)  
KAO( :, 2, 8,15) = (/&
 & 1.9118E-01_JPRB,1.6732E-01_JPRB,1.4346E-01_JPRB,1.1993E-01_JPRB,1.0330E-01_JPRB,9.4785E-02_JPRB,&
 & 9.5939E-02_JPRB,1.0927E-01_JPRB,1.2693E-01_JPRB/)  
KAO( :, 3, 8,15) = (/&
 & 1.8966E-01_JPRB,1.6599E-01_JPRB,1.4233E-01_JPRB,1.2111E-01_JPRB,1.0944E-01_JPRB,1.0556E-01_JPRB,&
 & 1.1490E-01_JPRB,1.3272E-01_JPRB,1.5419E-01_JPRB/)  
KAO( :, 4, 8,15) = (/&
 & 1.8827E-01_JPRB,1.6478E-01_JPRB,1.4129E-01_JPRB,1.2410E-01_JPRB,1.1628E-01_JPRB,1.1877E-01_JPRB,&
 & 1.3648E-01_JPRB,1.5764E-01_JPRB,1.8319E-01_JPRB/)  
KAO( :, 5, 8,15) = (/&
 & 1.8700E-01_JPRB,1.6367E-01_JPRB,1.4137E-01_JPRB,1.2760E-01_JPRB,1.2425E-01_JPRB,1.3451E-01_JPRB,&
 & 1.5950E-01_JPRB,1.8417E-01_JPRB,2.1419E-01_JPRB/)  
KAO( :, 1, 9,15) = (/&
 & 2.1903E-01_JPRB,1.9168E-01_JPRB,1.6432E-01_JPRB,1.3697E-01_JPRB,1.1022E-01_JPRB,9.3381E-02_JPRB,&
 & 8.1173E-02_JPRB,8.3378E-02_JPRB,9.6854E-02_JPRB/)  
KAO( :, 2, 9,15) = (/&
 & 2.1750E-01_JPRB,1.9034E-01_JPRB,1.6318E-01_JPRB,1.3602E-01_JPRB,1.1431E-01_JPRB,1.0171E-01_JPRB,&
 & 9.6008E-02_JPRB,1.0601E-01_JPRB,1.2308E-01_JPRB/)  
KAO( :, 3, 9,15) = (/&
 & 2.1621E-01_JPRB,1.8921E-01_JPRB,1.6222E-01_JPRB,1.3665E-01_JPRB,1.2052E-01_JPRB,1.1120E-01_JPRB,&
 & 1.1434E-01_JPRB,1.3077E-01_JPRB,1.5182E-01_JPRB/)  
KAO( :, 4, 9,15) = (/&
 & 2.1461E-01_JPRB,1.8782E-01_JPRB,1.6103E-01_JPRB,1.3944E-01_JPRB,1.2758E-01_JPRB,1.2410E-01_JPRB,&
 & 1.3607E-01_JPRB,1.5728E-01_JPRB,1.8262E-01_JPRB/)  
KAO( :, 5, 9,15) = (/&
 & 2.1295E-01_JPRB,1.8637E-01_JPRB,1.6039E-01_JPRB,1.4274E-01_JPRB,1.3480E-01_JPRB,1.3933E-01_JPRB,&
 & 1.6084E-01_JPRB,1.8591E-01_JPRB,2.1587E-01_JPRB/)  
KAO( :, 1,10,15) = (/&
 & 2.4831E-01_JPRB,2.1729E-01_JPRB,1.8627E-01_JPRB,1.5526E-01_JPRB,1.2434E-01_JPRB,1.0185E-01_JPRB,&
 & 8.4815E-02_JPRB,8.0841E-02_JPRB,1.7532E-01_JPRB/)  
KAO( :, 2,10,15) = (/&
 & 2.4704E-01_JPRB,2.1618E-01_JPRB,1.8532E-01_JPRB,1.5447E-01_JPRB,1.2750E-01_JPRB,1.1098E-01_JPRB,&
 & 9.8299E-02_JPRB,1.0410E-01_JPRB,1.7367E-01_JPRB/)  
KAO( :, 3,10,15) = (/&
 & 2.4585E-01_JPRB,2.1514E-01_JPRB,1.8444E-01_JPRB,1.5466E-01_JPRB,1.3408E-01_JPRB,1.1953E-01_JPRB,&
 & 1.1633E-01_JPRB,1.3023E-01_JPRB,1.7996E-01_JPRB/)  
KAO( :, 4,10,15) = (/&
 & 2.4402E-01_JPRB,2.1354E-01_JPRB,1.8307E-01_JPRB,1.5695E-01_JPRB,1.4115E-01_JPRB,1.3126E-01_JPRB,&
 & 1.3793E-01_JPRB,1.5846E-01_JPRB,1.9548E-01_JPRB/)  
KAO( :, 5,10,15) = (/&
 & 2.4208E-01_JPRB,2.1185E-01_JPRB,1.8198E-01_JPRB,1.6040E-01_JPRB,1.4820E-01_JPRB,1.4650E-01_JPRB,&
 & 1.6334E-01_JPRB,1.8884E-01_JPRB,2.2082E-01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART10',1,ZHOOK_HANDLE)
END SUBROUTINE PART10


SUBROUTINE PART11

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART11',0,ZHOOK_HANDLE)


KAO( :, 1,11,15) = (/&
 & 2.8046E-01_JPRB,2.4542E-01_JPRB,2.1039E-01_JPRB,1.7535E-01_JPRB,1.4072E-01_JPRB,1.1602E-01_JPRB,&
 & 9.4756E-02_JPRB,8.8842E-02_JPRB,3.0507E-01_JPRB/)  
KAO( :, 2,11,15) = (/&
 & 2.7918E-01_JPRB,2.4430E-01_JPRB,2.0943E-01_JPRB,1.7456E-01_JPRB,1.4537E-01_JPRB,1.2533E-01_JPRB,&
 & 1.0891E-01_JPRB,1.1392E-01_JPRB,2.9566E-01_JPRB/)  
KAO( :, 3,11,15) = (/&
 & 2.7735E-01_JPRB,2.4270E-01_JPRB,2.0805E-01_JPRB,1.7500E-01_JPRB,1.5257E-01_JPRB,1.3417E-01_JPRB,&
 & 1.2847E-01_JPRB,1.4223E-01_JPRB,2.9322E-01_JPRB/)  
KAO( :, 4,11,15) = (/&
 & 2.7527E-01_JPRB,2.4088E-01_JPRB,2.0649E-01_JPRB,1.7781E-01_JPRB,1.5979E-01_JPRB,1.4614E-01_JPRB,&
 & 1.5179E-01_JPRB,1.7334E-01_JPRB,2.9538E-01_JPRB/)  
KAO( :, 5,11,15) = (/&
 & 2.7287E-01_JPRB,2.3878E-01_JPRB,2.0537E-01_JPRB,1.8183E-01_JPRB,1.6671E-01_JPRB,1.6236E-01_JPRB,&
 & 1.7904E-01_JPRB,2.0699E-01_JPRB,3.0432E-01_JPRB/)  
KAO( :, 1,12,15) = (/&
 & 3.1597E-01_JPRB,2.7649E-01_JPRB,2.3701E-01_JPRB,1.9754E-01_JPRB,1.5924E-01_JPRB,1.3168E-01_JPRB,&
 & 1.0585E-01_JPRB,9.7375E-02_JPRB,4.0358E-01_JPRB/)  
KAO( :, 2,12,15) = (/&
 & 3.1432E-01_JPRB,2.7505E-01_JPRB,2.3578E-01_JPRB,1.9654E-01_JPRB,1.6498E-01_JPRB,1.4094E-01_JPRB,&
 & 1.2051E-01_JPRB,1.2392E-01_JPRB,3.9336E-01_JPRB/)  
KAO( :, 3,12,15) = (/&
 & 3.1171E-01_JPRB,2.7277E-01_JPRB,2.3383E-01_JPRB,1.9721E-01_JPRB,1.7246E-01_JPRB,1.5023E-01_JPRB,&
 & 1.4122E-01_JPRB,1.5462E-01_JPRB,3.9393E-01_JPRB/)  
KAO( :, 4,12,15) = (/&
 & 3.0880E-01_JPRB,2.7022E-01_JPRB,2.3164E-01_JPRB,2.0058E-01_JPRB,1.7964E-01_JPRB,1.6232E-01_JPRB,&
 & 1.6619E-01_JPRB,1.8839E-01_JPRB,3.9596E-01_JPRB/)  
KAO( :, 5,12,15) = (/&
 & 3.0525E-01_JPRB,2.6711E-01_JPRB,2.3006E-01_JPRB,2.0488E-01_JPRB,1.8690E-01_JPRB,1.7940E-01_JPRB,&
 & 1.9528E-01_JPRB,2.2516E-01_JPRB,4.0079E-01_JPRB/)  
KAO( :, 1,13,15) = (/&
 & 3.5411E-01_JPRB,3.0986E-01_JPRB,2.6562E-01_JPRB,2.2137E-01_JPRB,1.7962E-01_JPRB,1.4841E-01_JPRB,&
 & 1.1804E-01_JPRB,1.0632E-01_JPRB,4.1876E-01_JPRB/)  
KAO( :, 2,13,15) = (/&
 & 3.5164E-01_JPRB,3.0771E-01_JPRB,2.6377E-01_JPRB,2.2010E-01_JPRB,1.8598E-01_JPRB,1.5750E-01_JPRB,&
 & 1.3321E-01_JPRB,1.3429E-01_JPRB,4.1787E-01_JPRB/)  
KAO( :, 3,13,15) = (/&
 & 3.4820E-01_JPRB,3.0469E-01_JPRB,2.6119E-01_JPRB,2.2112E-01_JPRB,1.9338E-01_JPRB,1.6728E-01_JPRB,&
 & 1.5455E-01_JPRB,1.6711E-01_JPRB,4.2377E-01_JPRB/)  
KAO( :, 4,13,15) = (/&
 & 3.4395E-01_JPRB,3.0097E-01_JPRB,2.5812E-01_JPRB,2.2469E-01_JPRB,2.0035E-01_JPRB,1.7975E-01_JPRB,&
 & 1.8098E-01_JPRB,2.0337E-01_JPRB,4.2831E-01_JPRB/)  
KAO( :, 5,13,15) = (/&
 & 3.3896E-01_JPRB,2.9661E-01_JPRB,2.5572E-01_JPRB,2.2897E-01_JPRB,2.0809E-01_JPRB,1.9725E-01_JPRB,&
 & 2.1144E-01_JPRB,2.4250E-01_JPRB,4.3491E-01_JPRB/)  
KAO( :, 1, 1,16) = (/&
 & 9.7171E-02_JPRB,8.5148E-02_JPRB,7.3125E-02_JPRB,6.1102E-02_JPRB,7.6485E-02_JPRB,9.5172E-02_JPRB,&
 & 1.1335E-01_JPRB,1.2955E-01_JPRB,1.4355E-01_JPRB/)  
KAO( :, 2, 1,16) = (/&
 & 9.4236E-02_JPRB,8.2602E-02_JPRB,7.0968E-02_JPRB,6.8035E-02_JPRB,9.0374E-02_JPRB,1.1244E-01_JPRB,&
 & 1.3393E-01_JPRB,1.5311E-01_JPRB,1.6974E-01_JPRB/)  
KAO( :, 3, 1,16) = (/&
 & 9.1543E-02_JPRB,8.0273E-02_JPRB,6.9003E-02_JPRB,7.8791E-02_JPRB,1.0469E-01_JPRB,1.3025E-01_JPRB,&
 & 1.5519E-01_JPRB,1.7738E-01_JPRB,1.9670E-01_JPRB/)  
KAO( :, 4, 1,16) = (/&
 & 8.8644E-02_JPRB,7.7768E-02_JPRB,6.6893E-02_JPRB,8.9756E-02_JPRB,1.1926E-01_JPRB,1.4844E-01_JPRB,&
 & 1.7683E-01_JPRB,2.0215E-01_JPRB,2.2416E-01_JPRB/)  
KAO( :, 5, 1,16) = (/&
 & 8.6144E-02_JPRB,7.5584E-02_JPRB,6.7875E-02_JPRB,1.0078E-01_JPRB,1.3394E-01_JPRB,1.6670E-01_JPRB,&
 & 1.9859E-01_JPRB,2.2714E-01_JPRB,2.5185E-01_JPRB/)  
KAO( :, 1, 2,16) = (/&
 & 1.1053E-01_JPRB,9.6812E-02_JPRB,8.3097E-02_JPRB,6.9381E-02_JPRB,8.5062E-02_JPRB,1.0587E-01_JPRB,&
 & 1.2610E-01_JPRB,1.4420E-01_JPRB,1.6344E-01_JPRB/)  
KAO( :, 2, 2,16) = (/&
 & 1.0742E-01_JPRB,9.4110E-02_JPRB,8.0803E-02_JPRB,7.6274E-02_JPRB,1.0134E-01_JPRB,1.2610E-01_JPRB,&
 & 1.5024E-01_JPRB,1.7183E-01_JPRB,1.9478E-01_JPRB/)  
KAO( :, 3, 2,16) = (/&
 & 1.0452E-01_JPRB,9.1604E-02_JPRB,7.8683E-02_JPRB,8.8937E-02_JPRB,1.1819E-01_JPRB,1.4709E-01_JPRB,&
 & 1.7526E-01_JPRB,2.0044E-01_JPRB,2.2725E-01_JPRB/)  
KAO( :, 4, 2,16) = (/&
 & 1.0156E-01_JPRB,8.9034E-02_JPRB,7.6513E-02_JPRB,1.0188E-01_JPRB,1.3537E-01_JPRB,1.6848E-01_JPRB,&
 & 2.0078E-01_JPRB,2.2973E-01_JPRB,2.6038E-01_JPRB/)  
KAO( :, 5, 2,16) = (/&
 & 9.9221E-02_JPRB,8.6974E-02_JPRB,7.8015E-02_JPRB,1.1491E-01_JPRB,1.5271E-01_JPRB,1.9010E-01_JPRB,&
 & 2.2653E-01_JPRB,2.5922E-01_JPRB,2.9391E-01_JPRB/)  
KAO( :, 1, 3,16) = (/&
 & 1.2741E-01_JPRB,1.1157E-01_JPRB,9.5716E-02_JPRB,7.9867E-02_JPRB,9.0261E-02_JPRB,1.1233E-01_JPRB,&
 & 1.3379E-01_JPRB,1.5315E-01_JPRB,1.7733E-01_JPRB/)  
KAO( :, 2, 3,16) = (/&
 & 1.2407E-01_JPRB,1.0865E-01_JPRB,9.3240E-02_JPRB,8.3066E-02_JPRB,1.0895E-01_JPRB,1.3559E-01_JPRB,&
 & 1.6159E-01_JPRB,1.8497E-01_JPRB,2.1412E-01_JPRB/)  
KAO( :, 3, 3,16) = (/&
 & 1.2077E-01_JPRB,1.0579E-01_JPRB,9.0806E-02_JPRB,9.6664E-02_JPRB,1.2848E-01_JPRB,1.5988E-01_JPRB,&
 & 1.9057E-01_JPRB,2.1812E-01_JPRB,2.5248E-01_JPRB/)  
KAO( :, 4, 3,16) = (/&
 & 1.1796E-01_JPRB,1.0334E-01_JPRB,8.8711E-02_JPRB,1.1167E-01_JPRB,1.4847E-01_JPRB,1.8483E-01_JPRB,&
 & 2.2029E-01_JPRB,2.5232E-01_JPRB,2.9201E-01_JPRB/)  
KAO( :, 5, 3,16) = (/&
 & 1.1579E-01_JPRB,1.0144E-01_JPRB,8.8938E-02_JPRB,1.2695E-01_JPRB,1.6868E-01_JPRB,2.1009E-01_JPRB,&
 & 2.5050E-01_JPRB,2.8682E-01_JPRB,3.3195E-01_JPRB/)  
KAO( :, 1, 4,16) = (/&
 & 1.4795E-01_JPRB,1.2951E-01_JPRB,1.1108E-01_JPRB,9.2642E-02_JPRB,9.3362E-02_JPRB,1.1620E-01_JPRB,&
 & 1.3849E-01_JPRB,1.5859E-01_JPRB,1.8531E-01_JPRB/)  
KAO( :, 2, 4,16) = (/&
 & 1.4437E-01_JPRB,1.2639E-01_JPRB,1.0842E-01_JPRB,9.2423E-02_JPRB,1.1442E-01_JPRB,1.4252E-01_JPRB,&
 & 1.6987E-01_JPRB,1.9459E-01_JPRB,2.2738E-01_JPRB/)  
KAO( :, 3, 4,16) = (/&
 & 1.4082E-01_JPRB,1.2330E-01_JPRB,1.0578E-01_JPRB,1.0327E-01_JPRB,1.3669E-01_JPRB,1.7021E-01_JPRB,&
 & 2.0291E-01_JPRB,2.3254E-01_JPRB,2.7168E-01_JPRB/)  
KAO( :, 4, 4,16) = (/&
 & 1.3812E-01_JPRB,1.2094E-01_JPRB,1.0376E-01_JPRB,1.2016E-01_JPRB,1.5971E-01_JPRB,1.9884E-01_JPRB,&
 & 2.3712E-01_JPRB,2.7173E-01_JPRB,3.1737E-01_JPRB/)  
KAO( :, 5, 4,16) = (/&
 & 1.3617E-01_JPRB,1.1924E-01_JPRB,1.0266E-01_JPRB,1.3775E-01_JPRB,1.8312E-01_JPRB,2.2801E-01_JPRB,&
 & 2.7185E-01_JPRB,3.1180E-01_JPRB,3.6388E-01_JPRB/)  
KAO( :, 1, 5,16) = (/&
 & 1.7254E-01_JPRB,1.5104E-01_JPRB,1.2954E-01_JPRB,1.0804E-01_JPRB,9.7033E-02_JPRB,1.1821E-01_JPRB,&
 & 1.4096E-01_JPRB,1.6165E-01_JPRB,1.8940E-01_JPRB/)  
KAO( :, 2, 5,16) = (/&
 & 1.6864E-01_JPRB,1.4763E-01_JPRB,1.2663E-01_JPRB,1.0583E-01_JPRB,1.1845E-01_JPRB,1.4755E-01_JPRB,&
 & 1.7593E-01_JPRB,2.0174E-01_JPRB,2.3625E-01_JPRB/)  
KAO( :, 3, 5,16) = (/&
 & 1.6515E-01_JPRB,1.4456E-01_JPRB,1.2397E-01_JPRB,1.1290E-01_JPRB,1.4346E-01_JPRB,1.7861E-01_JPRB,&
 & 2.1302E-01_JPRB,2.4445E-01_JPRB,2.8621E-01_JPRB/)  
KAO( :, 4, 5,16) = (/&
 & 1.6266E-01_JPRB,1.4239E-01_JPRB,1.2212E-01_JPRB,1.2793E-01_JPRB,1.6939E-01_JPRB,2.1102E-01_JPRB,&
 & 2.5177E-01_JPRB,2.8892E-01_JPRB,3.3809E-01_JPRB/)  
KAO( :, 5, 5,16) = (/&
 & 1.6070E-01_JPRB,1.4068E-01_JPRB,1.2066E-01_JPRB,1.4743E-01_JPRB,1.9603E-01_JPRB,2.4421E-01_JPRB,&
 & 2.9142E-01_JPRB,3.3457E-01_JPRB,3.9133E-01_JPRB/)  
KAO( :, 1, 6,16) = (/&
 & 2.0388E-01_JPRB,1.7849E-01_JPRB,1.5310E-01_JPRB,1.2771E-01_JPRB,1.0526E-01_JPRB,1.1860E-01_JPRB,&
 & 1.4142E-01_JPRB,1.6203E-01_JPRB,1.9043E-01_JPRB/)  
KAO( :, 2, 6,16) = (/&
 & 1.9953E-01_JPRB,1.7470E-01_JPRB,1.4986E-01_JPRB,1.2501E-01_JPRB,1.2166E-01_JPRB,1.5016E-01_JPRB,&
 & 1.7907E-01_JPRB,2.0547E-01_JPRB,2.4111E-01_JPRB/)  
KAO( :, 3, 6,16) = (/&
 & 1.9494E-01_JPRB,1.7068E-01_JPRB,1.4642E-01_JPRB,1.2626E-01_JPRB,1.4789E-01_JPRB,1.8422E-01_JPRB,&
 & 2.1980E-01_JPRB,2.5220E-01_JPRB,2.9578E-01_JPRB/)  
KAO( :, 4, 6,16) = (/&
 & 1.9206E-01_JPRB,1.6810E-01_JPRB,1.4414E-01_JPRB,1.3841E-01_JPRB,1.7663E-01_JPRB,2.1999E-01_JPRB,&
 & 2.6255E-01_JPRB,3.0157E-01_JPRB,3.5331E-01_JPRB/)  
KAO( :, 5, 6,16) = (/&
 & 1.9005E-01_JPRB,1.6635E-01_JPRB,1.4264E-01_JPRB,1.5606E-01_JPRB,2.0643E-01_JPRB,2.5713E-01_JPRB,&
 & 3.0687E-01_JPRB,3.5252E-01_JPRB,4.1278E-01_JPRB/)  
KAO( :, 1, 7,16) = (/&
 & 2.4312E-01_JPRB,2.1282E-01_JPRB,1.8252E-01_JPRB,1.5222E-01_JPRB,1.2192E-01_JPRB,1.1888E-01_JPRB,&
 & 1.4174E-01_JPRB,1.6248E-01_JPRB,1.9115E-01_JPRB/)  
KAO( :, 2, 7,16) = (/&
 & 2.3797E-01_JPRB,2.0832E-01_JPRB,1.7867E-01_JPRB,1.4904E-01_JPRB,1.2994E-01_JPRB,1.5302E-01_JPRB,&
 & 1.8249E-01_JPRB,2.0929E-01_JPRB,2.4599E-01_JPRB/)  
KAO( :, 3, 7,16) = (/&
 & 2.3255E-01_JPRB,2.0359E-01_JPRB,1.7463E-01_JPRB,1.4575E-01_JPRB,1.5275E-01_JPRB,1.9023E-01_JPRB,&
 & 2.2691E-01_JPRB,2.6041E-01_JPRB,3.0584E-01_JPRB/)  
KAO( :, 4, 7,16) = (/&
 & 2.2807E-01_JPRB,1.9965E-01_JPRB,1.7122E-01_JPRB,1.5317E-01_JPRB,1.8432E-01_JPRB,2.2969E-01_JPRB,&
 & 2.7402E-01_JPRB,3.1471E-01_JPRB,3.6920E-01_JPRB/)  
KAO( :, 5, 7,16) = (/&
 & 2.2498E-01_JPRB,1.9692E-01_JPRB,1.6887E-01_JPRB,1.6865E-01_JPRB,2.1725E-01_JPRB,2.7068E-01_JPRB,&
 & 3.2308E-01_JPRB,3.7116E-01_JPRB,4.3516E-01_JPRB/)  
KAO( :, 1, 8,16) = (/&
 & 2.9068E-01_JPRB,2.5442E-01_JPRB,2.1816E-01_JPRB,1.8190E-01_JPRB,1.4564E-01_JPRB,1.2041E-01_JPRB,&
 & 1.4177E-01_JPRB,1.6257E-01_JPRB,1.9124E-01_JPRB/)  
KAO( :, 2, 8,16) = (/&
 & 2.8457E-01_JPRB,2.4908E-01_JPRB,2.1359E-01_JPRB,1.7807E-01_JPRB,1.4515E-01_JPRB,1.5579E-01_JPRB,&
 & 1.8584E-01_JPRB,2.1331E-01_JPRB,2.5071E-01_JPRB/)  
KAO( :, 3, 8,16) = (/&
 & 2.7790E-01_JPRB,2.4325E-01_JPRB,2.0861E-01_JPRB,1.7396E-01_JPRB,1.6105E-01_JPRB,1.9656E-01_JPRB,&
 & 2.3447E-01_JPRB,2.6926E-01_JPRB,3.1620E-01_JPRB/)  
KAO( :, 4, 8,16) = (/&
 & 2.7204E-01_JPRB,2.3812E-01_JPRB,2.0420E-01_JPRB,1.7391E-01_JPRB,1.9266E-01_JPRB,2.4008E-01_JPRB,&
 & 2.8658E-01_JPRB,3.2922E-01_JPRB,3.8634E-01_JPRB/)  
KAO( :, 5, 8,16) = (/&
 & 2.6773E-01_JPRB,2.3434E-01_JPRB,2.0095E-01_JPRB,1.8582E-01_JPRB,2.2918E-01_JPRB,2.8567E-01_JPRB,&
 & 3.4098E-01_JPRB,3.9189E-01_JPRB,4.5943E-01_JPRB/)  
KAO( :, 1, 9,16) = (/&
 & 3.4732E-01_JPRB,3.0397E-01_JPRB,2.6061E-01_JPRB,2.1726E-01_JPRB,1.7390E-01_JPRB,1.3271E-01_JPRB,&
 & 1.4035E-01_JPRB,1.6109E-01_JPRB,1.8937E-01_JPRB/)  
KAO( :, 2, 9,16) = (/&
 & 3.3981E-01_JPRB,2.9740E-01_JPRB,2.5499E-01_JPRB,2.1257E-01_JPRB,1.7017E-01_JPRB,1.5746E-01_JPRB,&
 & 1.8783E-01_JPRB,2.1574E-01_JPRB,2.5330E-01_JPRB/)  
KAO( :, 3, 9,16) = (/&
 & 3.3164E-01_JPRB,2.9026E-01_JPRB,2.4888E-01_JPRB,2.0750E-01_JPRB,1.7718E-01_JPRB,2.0179E-01_JPRB,&
 & 2.4086E-01_JPRB,2.7675E-01_JPRB,3.2472E-01_JPRB/)  
KAO( :, 4, 9,16) = (/&
 & 3.2434E-01_JPRB,2.8387E-01_JPRB,2.4340E-01_JPRB,2.0299E-01_JPRB,2.0166E-01_JPRB,2.4979E-01_JPRB,&
 & 2.9816E-01_JPRB,3.4279E-01_JPRB,4.0187E-01_JPRB/)  
KAO( :, 5, 9,16) = (/&
 & 3.1856E-01_JPRB,2.7881E-01_JPRB,2.3907E-01_JPRB,2.0909E-01_JPRB,2.4079E-01_JPRB,3.0025E-01_JPRB,&
 & 3.5852E-01_JPRB,4.1238E-01_JPRB,4.8294E-01_JPRB/)  
KAO( :, 1,10,16) = (/&
 & 4.1296E-01_JPRB,3.6138E-01_JPRB,3.0981E-01_JPRB,2.5823E-01_JPRB,2.0667E-01_JPRB,1.5510E-01_JPRB,&
 & 1.4272E-01_JPRB,1.6382E-01_JPRB,1.9375E-01_JPRB/)  
KAO( :, 2,10,16) = (/&
 & 4.0355E-01_JPRB,3.5316E-01_JPRB,3.0277E-01_JPRB,2.5237E-01_JPRB,2.0198E-01_JPRB,1.6688E-01_JPRB,&
 & 1.9258E-01_JPRB,2.2130E-01_JPRB,2.5965E-01_JPRB/)  
KAO( :, 3,10,16) = (/&
 & 3.9334E-01_JPRB,3.4423E-01_JPRB,2.9512E-01_JPRB,2.4601E-01_JPRB,2.0198E-01_JPRB,2.0922E-01_JPRB,&
 & 2.4978E-01_JPRB,2.8734E-01_JPRB,3.3649E-01_JPRB/)  
KAO( :, 4,10,16) = (/&
 & 3.8468E-01_JPRB,3.3665E-01_JPRB,2.8862E-01_JPRB,2.4064E-01_JPRB,2.1892E-01_JPRB,2.6187E-01_JPRB,&
 & 3.1276E-01_JPRB,3.6003E-01_JPRB,4.2127E-01_JPRB/)  
KAO( :, 5,10,16) = (/&
 & 3.7732E-01_JPRB,3.3021E-01_JPRB,2.8310E-01_JPRB,2.4052E-01_JPRB,2.5525E-01_JPRB,3.1772E-01_JPRB,&
 & 3.7953E-01_JPRB,4.3694E-01_JPRB,5.1089E-01_JPRB/)  
KAO( :, 1,11,16) = (/&
 & 4.8302E-01_JPRB,4.2268E-01_JPRB,3.6234E-01_JPRB,3.0200E-01_JPRB,2.4165E-01_JPRB,1.8151E-01_JPRB,&
 & 1.6877E-01_JPRB,1.9388E-01_JPRB,3.3421E-01_JPRB/)  
KAO( :, 2,11,16) = (/&
 & 4.7050E-01_JPRB,4.1173E-01_JPRB,3.5296E-01_JPRB,2.9420E-01_JPRB,2.3543E-01_JPRB,1.9660E-01_JPRB,&
 & 2.2543E-01_JPRB,2.5921E-01_JPRB,3.3179E-01_JPRB/)  
KAO( :, 3,11,16) = (/&
 & 4.5896E-01_JPRB,4.0163E-01_JPRB,3.4431E-01_JPRB,2.8698E-01_JPRB,2.3627E-01_JPRB,2.4234E-01_JPRB,&
 & 2.8945E-01_JPRB,3.3305E-01_JPRB,3.8992E-01_JPRB/)  
KAO( :, 4,11,16) = (/&
 & 4.4916E-01_JPRB,3.9306E-01_JPRB,3.3696E-01_JPRB,2.8088E-01_JPRB,2.5515E-01_JPRB,3.0073E-01_JPRB,&
 & 3.5922E-01_JPRB,4.1373E-01_JPRB,4.8361E-01_JPRB/)  
KAO( :, 5,11,16) = (/&
 & 4.3990E-01_JPRB,3.8496E-01_JPRB,3.3001E-01_JPRB,2.8070E-01_JPRB,2.9324E-01_JPRB,3.6251E-01_JPRB,&
 & 4.3320E-01_JPRB,4.9939E-01_JPRB,5.8288E-01_JPRB/)  
KAO( :, 1,12,16) = (/&
 & 5.5949E-01_JPRB,4.8959E-01_JPRB,4.1968E-01_JPRB,3.4978E-01_JPRB,2.7990E-01_JPRB,2.1117E-01_JPRB,&
 & 1.9846E-01_JPRB,2.2823E-01_JPRB,4.6485E-01_JPRB/)  
KAO( :, 2,12,16) = (/&
 & 5.4466E-01_JPRB,4.7661E-01_JPRB,4.0856E-01_JPRB,3.4053E-01_JPRB,2.7248E-01_JPRB,2.3023E-01_JPRB,&
 & 2.6289E-01_JPRB,3.0262E-01_JPRB,4.5843E-01_JPRB/)  
KAO( :, 3,12,16) = (/&
 & 5.3198E-01_JPRB,4.6551E-01_JPRB,3.9905E-01_JPRB,3.3259E-01_JPRB,2.7378E-01_JPRB,2.8016E-01_JPRB,&
 & 3.3471E-01_JPRB,3.8547E-01_JPRB,4.7894E-01_JPRB/)  
KAO( :, 4,12,16) = (/&
 & 5.2001E-01_JPRB,4.5505E-01_JPRB,3.9008E-01_JPRB,3.2510E-01_JPRB,2.9551E-01_JPRB,3.4473E-01_JPRB,&
 & 4.1193E-01_JPRB,4.7482E-01_JPRB,5.5483E-01_JPRB/)  
KAO( :, 5,12,16) = (/&
 & 5.0915E-01_JPRB,4.4554E-01_JPRB,3.8193E-01_JPRB,3.2460E-01_JPRB,3.3469E-01_JPRB,4.1244E-01_JPRB,&
 & 4.9294E-01_JPRB,5.6854E-01_JPRB,6.6308E-01_JPRB/)  
KAO( :, 1,13,16) = (/&
 & 6.4209E-01_JPRB,5.6185E-01_JPRB,4.8161E-01_JPRB,4.0138E-01_JPRB,3.2111E-01_JPRB,2.4405E-01_JPRB,&
 & 2.3126E-01_JPRB,2.6629E-01_JPRB,5.1031E-01_JPRB/)  
KAO( :, 2,13,16) = (/&
 & 6.2605E-01_JPRB,5.4782E-01_JPRB,4.6959E-01_JPRB,3.9135E-01_JPRB,3.1312E-01_JPRB,2.6752E-01_JPRB,&
 & 3.0417E-01_JPRB,3.5056E-01_JPRB,5.0701E-01_JPRB/)  
KAO( :, 3,13,16) = (/&
 & 6.1094E-01_JPRB,5.3460E-01_JPRB,4.5826E-01_JPRB,3.8192E-01_JPRB,3.1501E-01_JPRB,3.2162E-01_JPRB,&
 & 3.8441E-01_JPRB,4.4331E-01_JPRB,5.4185E-01_JPRB/)  
KAO( :, 4,13,16) = (/&
 & 5.9718E-01_JPRB,5.2256E-01_JPRB,4.4794E-01_JPRB,3.7327E-01_JPRB,3.3928E-01_JPRB,3.9296E-01_JPRB,&
 & 4.6976E-01_JPRB,5.4198E-01_JPRB,6.3180E-01_JPRB/)  
KAO( :, 5,13,16) = (/&
 & 5.8381E-01_JPRB,5.1086E-01_JPRB,4.3791E-01_JPRB,3.7153E-01_JPRB,3.7939E-01_JPRB,4.6700E-01_JPRB,&
 & 5.5841E-01_JPRB,6.4458E-01_JPRB,7.5053E-01_JPRB/)  

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
 & 1.26476E-03_JPRB, 1.04962E-03_JPRB, 8.71080E-04_JPRB, 7.22907E-04_JPRB, 5.99939E-04_JPRB,&
 & 4.97888E-04_JPRB, 4.13197E-04_JPRB, 3.42911E-04_JPRB, 2.84581E-04_JPRB, 2.36173E-04_JPRB/)  
SELFREFO( :, 2) = (/&
 & 1.27380E-03_JPRB, 1.05867E-03_JPRB, 8.79870E-04_JPRB, 7.31270E-04_JPRB, 6.07767E-04_JPRB,&
 & 5.05121E-04_JPRB, 4.19812E-04_JPRB, 3.48911E-04_JPRB, 2.89983E-04_JPRB, 2.41008E-04_JPRB/)  
SELFREFO( :, 3) = (/&
 & 1.26332E-03_JPRB, 1.05867E-03_JPRB, 8.87172E-04_JPRB, 7.43454E-04_JPRB, 6.23018E-04_JPRB,&
 & 5.22092E-04_JPRB, 4.37515E-04_JPRB, 3.66640E-04_JPRB, 3.07246E-04_JPRB, 2.57474E-04_JPRB/)  
SELFREFO( :, 4) = (/&
 & 1.28078E-03_JPRB, 1.07802E-03_JPRB, 9.07363E-04_JPRB, 7.63722E-04_JPRB, 6.42820E-04_JPRB,&
 & 5.41057E-04_JPRB, 4.55404E-04_JPRB, 3.83311E-04_JPRB, 3.22630E-04_JPRB, 2.71556E-04_JPRB/)  
SELFREFO( :, 5) = (/&
 & 1.61188E-03_JPRB, 1.32375E-03_JPRB, 1.08712E-03_JPRB, 8.92794E-04_JPRB, 7.33203E-04_JPRB,&
 & 6.02140E-04_JPRB, 4.94505E-04_JPRB, 4.06110E-04_JPRB, 3.33516E-04_JPRB, 2.73898E-04_JPRB/)  
SELFREFO( :, 6) = (/&
 & 1.42549E-03_JPRB, 1.25964E-03_JPRB, 1.11309E-03_JPRB, 9.83595E-04_JPRB, 8.69162E-04_JPRB,&
 & 7.68043E-04_JPRB, 6.78688E-04_JPRB, 5.99728E-04_JPRB, 5.29955E-04_JPRB, 4.68299E-04_JPRB/)  
SELFREFO( :, 7) = (/&
 & 1.43253E-03_JPRB, 1.28535E-03_JPRB, 1.15330E-03_JPRB, 1.03480E-03_JPRB, 9.28488E-04_JPRB,&
 & 8.33094E-04_JPRB, 7.47501E-04_JPRB, 6.70702E-04_JPRB, 6.01794E-04_JPRB, 5.39965E-04_JPRB/)  
SELFREFO( :, 8) = (/&
 & 1.48973E-03_JPRB, 1.33348E-03_JPRB, 1.19363E-03_JPRB, 1.06844E-03_JPRB, 9.56378E-04_JPRB,&
 & 8.56072E-04_JPRB, 7.66286E-04_JPRB, 6.85918E-04_JPRB, 6.13978E-04_JPRB, 5.49583E-04_JPRB/)  
SELFREFO( :, 9) = (/&
 & 1.53002E-03_JPRB, 1.44607E-03_JPRB, 1.36674E-03_JPRB, 1.29175E-03_JPRB, 1.22088E-03_JPRB,&
 & 1.15390E-03_JPRB, 1.09059E-03_JPRB, 1.03076E-03_JPRB, 9.74209E-04_JPRB, 9.20760E-04_JPRB/)  
SELFREFO( :,10) = (/&
 & 1.78480E-03_JPRB, 1.68865E-03_JPRB, 1.59768E-03_JPRB, 1.51161E-03_JPRB, 1.43018E-03_JPRB,&
 & 1.35313E-03_JPRB, 1.28023E-03_JPRB, 1.21126E-03_JPRB, 1.14601E-03_JPRB, 1.08427E-03_JPRB/)  
SELFREFO( :,11) = (/&
 & 1.85121E-03_JPRB, 1.73903E-03_JPRB, 1.63364E-03_JPRB, 1.53464E-03_JPRB, 1.44164E-03_JPRB,&
 & 1.35427E-03_JPRB, 1.27220E-03_JPRB, 1.19510E-03_JPRB, 1.12268E-03_JPRB, 1.05464E-03_JPRB/)  
SELFREFO( :,12) = (/&
 & 2.10772E-03_JPRB, 1.96994E-03_JPRB, 1.84118E-03_JPRB, 1.72082E-03_JPRB, 1.60834E-03_JPRB,&
 & 1.50321E-03_JPRB, 1.40495E-03_JPRB, 1.31311E-03_JPRB, 1.22728E-03_JPRB, 1.14705E-03_JPRB/)  
SELFREFO( :,13) = (/&
 & 1.99323E-03_JPRB, 1.89279E-03_JPRB, 1.79741E-03_JPRB, 1.70684E-03_JPRB, 1.62083E-03_JPRB,&
 & 1.53915E-03_JPRB, 1.46159E-03_JPRB, 1.38794E-03_JPRB, 1.31800E-03_JPRB, 1.25159E-03_JPRB/)  
SELFREFO( :,14) = (/&
 & 2.05835E-03_JPRB, 1.93301E-03_JPRB, 1.81529E-03_JPRB, 1.70475E-03_JPRB, 1.60093E-03_JPRB,&
 & 1.50344E-03_JPRB, 1.41189E-03_JPRB, 1.32591E-03_JPRB, 1.24516E-03_JPRB, 1.16934E-03_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART11',1,ZHOOK_HANDLE)
END SUBROUTINE PART11


SUBROUTINE PART12

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART12',0,ZHOOK_HANDLE)


SELFREFO( :,15) = (/&
 & 2.34120E-03_JPRB, 2.20012E-03_JPRB, 2.06754E-03_JPRB, 1.94295E-03_JPRB, 1.82587E-03_JPRB,&
 & 1.71585E-03_JPRB, 1.61245E-03_JPRB, 1.51529E-03_JPRB, 1.42398E-03_JPRB, 1.33817E-03_JPRB/)  
SELFREFO( :,16) = (/&
 & 3.03559E-03_JPRB, 2.80023E-03_JPRB, 2.58312E-03_JPRB, 2.38284E-03_JPRB, 2.19809E-03_JPRB,&
 & 2.02767E-03_JPRB, 1.87045E-03_JPRB, 1.72543E-03_JPRB, 1.59165E-03_JPRB, 1.46825E-03_JPRB/)  

FRACREFAO( :, 1) = (/&
 !     From P = 862.6 mb.
 & 0.17356300_JPRB,0.18880001_JPRB,0.17704099_JPRB,0.13661300_JPRB,&
 & 0.10691600_JPRB,0.08222480_JPRB,0.05939860_JPRB,0.04230810_JPRB,&
 & 0.02526330_JPRB,0.00244532_JPRB,0.00193541_JPRB,0.00150415_JPRB,&
 & 0.00103528_JPRB,0.00067068_JPRB,0.00024951_JPRB,0.00003348_JPRB/)  
FRACREFAO( :, 2) = (/&
 & 0.17779499_JPRB,0.19837400_JPRB,0.16557600_JPRB,0.13470000_JPRB,&
 & 0.11013600_JPRB,0.08342720_JPRB,0.05987030_JPRB,0.03938700_JPRB,&
 & 0.02293650_JPRB,0.00238849_JPRB,0.00192400_JPRB,0.00149921_JPRB,&
 & 0.00103539_JPRB,0.00067150_JPRB,0.00024822_JPRB,0.00003348_JPRB/)  
FRACREFAO( :, 3) = (/&
 & 0.18535601_JPRB,0.19407199_JPRB,0.16053200_JPRB,0.13300700_JPRB,&
 & 0.10779000_JPRB,0.08408500_JPRB,0.06480450_JPRB,0.04070160_JPRB,&
 & 0.02203590_JPRB,0.00227779_JPRB,0.00189074_JPRB,0.00146888_JPRB,&
 & 0.00103147_JPRB,0.00066770_JPRB,0.00024751_JPRB,0.00003348_JPRB/)  
FRACREFAO( :, 4) = (/&
 & 0.19139200_JPRB,0.18917400_JPRB,0.15748601_JPRB,0.13240699_JPRB,&
 & 0.10557300_JPRB,0.08383260_JPRB,0.06724060_JPRB,0.04364450_JPRB,&
 & 0.02175820_JPRB,0.00225436_JPRB,0.00184421_JPRB,0.00143153_JPRB,&
 & 0.00103027_JPRB,0.00066066_JPRB,0.00024222_JPRB,0.00003148_JPRB/)  
FRACREFAO( :, 5) = (/&
 & 0.19547801_JPRB,0.18539500_JPRB,0.15442000_JPRB,0.13114899_JPRB,&
 & 0.10515600_JPRB,0.08350350_JPRB,0.06909780_JPRB,0.04671630_JPRB,&
 & 0.02168820_JPRB,0.00224400_JPRB,0.00182009_JPRB,0.00139098_JPRB,&
 & 0.00102582_JPRB,0.00065367_JPRB,0.00023202_JPRB,0.00003148_JPRB/)  
FRACREFAO( :, 6) = (/&
 & 0.19757500_JPRB,0.18266800_JPRB,0.15208900_JPRB,0.12897800_JPRB,&
 & 0.10637200_JPRB,0.08391220_JPRB,0.06989830_JPRB,0.04964120_JPRB,&
 & 0.02155800_JPRB,0.00224310_JPRB,0.00177358_JPRB,0.00138184_JPRB,&
 & 0.00101538_JPRB,0.00063370_JPRB,0.00023227_JPRB,0.00003148_JPRB/)  
FRACREFAO( :, 7) = (/&
 & 0.20145500_JPRB,0.17692900_JPRB,0.14940600_JPRB,0.12690400_JPRB,&
 & 0.10828800_JPRB,0.08553720_JPRB,0.07004940_JPRB,0.05153430_JPRB,&
 & 0.02268740_JPRB,0.00216943_JPRB,0.00178603_JPRB,0.00137754_JPRB,&
 & 0.00098344_JPRB,0.00063165_JPRB,0.00023218_JPRB,0.00003148_JPRB/)  
FRACREFAO( :, 8) = (/&
 & 0.20383500_JPRB,0.17047501_JPRB,0.14570600_JPRB,0.12679300_JPRB,&
 & 0.11043100_JPRB,0.08719150_JPRB,0.07045440_JPRB,0.05345420_JPRB,&
 & 0.02448340_JPRB,0.00215839_JPRB,0.00175893_JPRB,0.00138296_JPRB,&
 & 0.00098318_JPRB,0.00063188_JPRB,0.00023199_JPRB,0.00003148_JPRB/)  
FRACREFAO( :, 9) = (/&
 & 0.18680701_JPRB,0.15961801_JPRB,0.15092900_JPRB,0.13049100_JPRB,&
 & 0.11418400_JPRB,0.09380540_JPRB,0.07093450_JPRB,0.05664280_JPRB,&
 & 0.02938410_JPRB,0.00217751_JPRB,0.00176766_JPRB,0.00138275_JPRB,&
 & 0.00098377_JPRB,0.00063181_JPRB,0.00023193_JPRB,0.00003148_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB16:PART12',1,ZHOOK_HANDLE)
END SUBROUTINE PART12


END SUBROUTINE RRTM_KGB16
