!----------------------------------------------------------------------------
SUBROUTINE RRTM_TAUMOL7 (KLEV,P_TAU,&
 & P_TAUAERL,P_FAC00,P_FAC01,P_FAC10,P_FAC11,K_JP,K_JT,K_JT1,P_ONEMINUS,&
 & P_COLH2O,P_COLO3,P_CO2MULT,K_LAYTROP,P_SELFFAC,P_SELFFRAC,K_INDSELF,PFRAC)  

!     BAND 7:  980-1080 cm-1 (low - H2O,O3; high - O3)

! Modifications
!        M.Hamrud      01-Oct-2003 CY28 Cleaning

!     D Salmond 2000-05-15 speed-up

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE PARRRTM  , ONLY : JPLAY  ,JPBAND ,JPGPT  ,NG7   ,NGS6
USE YOERRTWN , ONLY :      NSPA   ,NSPB
USE YOERRTA7 , ONLY : ABSA   ,ABSB   ,ABSCO2 ,FRACREFA ,FRACREFB,SELFREF,STRRAT

!  Input
!#include "yoeratm.h"

!      REAL TAUAER(JPLAY)

IMPLICIT NONE

!  Output
INTEGER(KIND=JPIM),INTENT(IN)    :: KLEV 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: P_TAU(JPGPT,JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_TAUAERL(JPLAY,JPBAND) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC00(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC01(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC10(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC11(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JP(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT1(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_ONEMINUS 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLH2O(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLO3(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_CO2MULT(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_LAYTROP 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFAC(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFRAC(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_INDSELF(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRAC(JPGPT,JPLAY) 
!- from AER
!- from INTFAC      
!- from INTIND
!- from PRECISE             
!- from PROFDATA             
!- from SELF             
!- from SP             
INTEGER(KIND=JPIM) :: IJS(JPLAY)
REAL(KIND=JPRB) :: ZFS(JPLAY),Z_SPECCOMB(JPLAY)
INTEGER(KIND=JPIM) :: IND0(JPLAY),IND1(JPLAY),INDS(JPLAY)

INTEGER(KIND=JPIM) :: IG, JS, I_LAY

REAL(KIND=JPRB) :: Z_FAC000, Z_FAC001, Z_FAC010, Z_FAC011, Z_FAC100, Z_FAC101,&
 & Z_FAC110, Z_FAC111, Z_FS, Z_SPECMULT, Z_SPECPARM  
REAL(KIND=JPRB) :: ZHOOK_HANDLE

!      EQUIVALENCE (TAUAERL(1,7),TAUAER)

!     Compute the optical depth by interpolating in ln(pressure), 
!     temperature, and appropriate species.  Below LAYTROP, the water
!     vapor self-continuum is interpolated (in temperature) separately.
  
IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL7',0,ZHOOK_HANDLE)
DO I_LAY = 1, K_LAYTROP
  Z_SPECCOMB(I_LAY) = P_COLH2O(I_LAY) + STRRAT*P_COLO3(I_LAY)
  Z_SPECPARM = P_COLH2O(I_LAY)/Z_SPECCOMB(I_LAY)
  Z_SPECPARM=MIN(P_ONEMINUS,Z_SPECPARM)
  Z_SPECMULT = 8._JPRB*Z_SPECPARM
  JS = 1 + INT(Z_SPECMULT)
  Z_FS = MOD(Z_SPECMULT,1.0_JPRB)
  IND0(I_LAY) = ((K_JP(I_LAY)-1)*5+(K_JT(I_LAY)-1))*NSPA(7) + JS
  IND1(I_LAY) = (K_JP(I_LAY)*5+(K_JT1(I_LAY)-1))*NSPA(7) + JS
  INDS(I_LAY) = K_INDSELF(I_LAY)
  ZFS(I_LAY)=Z_FS
  IJS(I_LAY)=JS

ENDDO

!-- DS_000515
DO IG = 1, NG7
  DO I_LAY = 1, K_LAYTROP
!-- DS_000515

    Z_FS=ZFS(I_LAY)
    JS=IJS(I_LAY)
!---jjm        
!    FAC000 = (_ONE_ - FS) * FAC00(LAY)
!    FAC010 = (_ONE_ - FS) * FAC10(LAY)
!    FAC100 = FS * FAC00(LAY)
!    FAC110 = FS * FAC10(LAY)
!    FAC001 = (_ONE_ - FS) * FAC01(LAY)
!    FAC011 = (_ONE_ - FS) * FAC11(LAY)
!    FAC101 = FS * FAC01(LAY)
!    FAC111 = FS * FAC11(LAY)
!-----

    P_TAU (NGS6+IG,I_LAY) = Z_SPECCOMB(I_LAY) *&
     !-- DS_000515
     !     &(Z_FAC000 * ABSA(IND0(I_LAY)   ,IG) +&
     !     & Z_FAC100 * ABSA(IND0(I_LAY)+ 1,IG) +&
     !     & Z_FAC010 * ABSA(IND0(I_LAY)+ 9,IG) +&
     !     & Z_FAC110 * ABSA(IND0(I_LAY)+10,IG) +&
     !     & Z_FAC001 * ABSA(IND1(I_LAY)   ,IG) +&
     !     & Z_FAC101 * ABSA(IND1(I_LAY)+ 1,IG) +&
     !     & Z_FAC011 * ABSA(IND1(I_LAY)+ 9,IG) +&
     !     & Z_FAC111 * ABSA(IND1(I_LAY)+10,IG))+&
     & ( (1. - Z_FS) *(P_FAC00(I_LAY) * ABSA(IND0(I_LAY)   ,IG) +   &
     & P_FAC10(I_LAY) * ABSA(IND0(I_LAY)+ 9,IG) +   &
     & P_FAC01(I_LAY) * ABSA(IND1(I_LAY)   ,IG) +    &
     & P_FAC11(I_LAY) * ABSA(IND1(I_LAY)+ 9,IG))+   &
     & Z_FS     *(P_FAC00(I_LAY) * ABSA(IND0(I_LAY)+ 1,IG) +   &
     & P_FAC10(I_LAY) * ABSA(IND0(I_LAY)+10,IG) +   &
     & P_FAC01(I_LAY) * ABSA(IND1(I_LAY)+ 1,IG) +   &
     & P_FAC11(I_LAY) * ABSA(IND1(I_LAY)+10,IG))) + &
     !-- DS_000515
     & P_COLH2O(I_LAY) * &
     & P_SELFFAC(I_LAY) * (SELFREF(INDS(I_LAY),IG) + &
     & P_SELFFRAC(I_LAY) *&
     & (SELFREF(INDS(I_LAY)+1,IG) - SELFREF(INDS(I_LAY),IG)))&
     & + P_CO2MULT(I_LAY) * ABSCO2(IG)&
     & + P_TAUAERL(I_LAY,7)  
    PFRAC(NGS6+IG,I_LAY) = FRACREFA(IG,JS) + Z_FS *&
     & (FRACREFA(IG,JS+1) - FRACREFA(IG,JS))  
  ENDDO
ENDDO

DO I_LAY = K_LAYTROP+1, KLEV
  IND0(I_LAY) = ((K_JP(I_LAY)-13)*5+(K_JT(I_LAY)-1))*NSPB(7) + 1
  IND1(I_LAY) = ((K_JP(I_LAY)-12)*5+(K_JT1(I_LAY)-1))*NSPB(7) + 1
ENDDO

!-- JJM_000517
DO IG = 1, NG7
  DO I_LAY = K_LAYTROP+1, KLEV
!-- JJM_000517
    P_TAU (NGS6+IG,I_LAY) = P_COLO3(I_LAY) *&
     & (P_FAC00(I_LAY) * ABSB(IND0(I_LAY)  ,IG) +&
     & P_FAC10(I_LAY) * ABSB(IND0(I_LAY)+1,IG) +&
     & P_FAC01(I_LAY) * ABSB(IND1(I_LAY)  ,IG) +&
     & P_FAC11(I_LAY) * ABSB(IND1(I_LAY)+1,IG))&
     & + P_CO2MULT(I_LAY) * ABSCO2(IG)&
     & + P_TAUAERL(I_LAY,7)  
    PFRAC(NGS6+IG,I_LAY) = FRACREFB(IG)
  ENDDO
ENDDO

IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL7',1,ZHOOK_HANDLE)
END SUBROUTINE RRTM_TAUMOL7
