!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif
!pgi$r opt=0 
SUBROUTINE RRTM_KGB10

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 10:  1390-1480 cm-1 (low - H2O; high - H2O)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOERRTO10, ONLY : KAO     ,KBO      ,FRACREFAO   ,FRACREFBO

!     ------------------------------------------------------------------

IMPLICIT NONE
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('RRTM_KGB10',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2
CALL PART3
CALL PART4
CALL PART5
CALL PART6
CALL PART7

IF (LHOOK) CALL DR_HOOK('RRTM_KGB10',1,ZHOOK_HANDLE)

!     -----------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB10:PART1',0,ZHOOK_HANDLE)


FRACREFAO( :) = (/&
 !     From P = 473 mb.
 & 0.16271301_JPRB,0.15141940_JPRB,0.14065412_JPRB,0.12899506_JPRB,&
 & 0.11607002_JPRB,0.10142808_JPRB,0.08116794_JPRB,0.06104711_JPRB,&
 & 0.04146209_JPRB,0.00447386_JPRB,0.00372902_JPRB,0.00287258_JPRB,&
 & 0.00206028_JPRB,0.00134634_JPRB,0.00049232_JPRB,0.00006927_JPRB/)  

FRACREFBO( :) = (/&
 !     From P = 1.17 mb.
 & 0.16571465_JPRB,0.15262246_JPRB,0.14036226_JPRB,0.12620729_JPRB,&
 & 0.11477834_JPRB,0.09967982_JPRB,0.08155201_JPRB,0.06159503_JPRB,&
 & 0.04196607_JPRB,0.00453940_JPRB,0.00376881_JPRB,0.00300437_JPRB,&
 & 0.00223034_JPRB,0.00139432_JPRB,0.00051516_JPRB,0.00007095_JPRB/)  

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.

KAO( :, 1, 1) = (/&
 & 4.3436E-02_JPRB,4.4287E-02_JPRB,4.5209E-02_JPRB,4.6235E-02_JPRB,4.7373E-02_JPRB/)  
KAO( :, 2, 1) = (/&
 & 3.3904E-02_JPRB,3.4737E-02_JPRB,3.5589E-02_JPRB,3.6523E-02_JPRB,3.7507E-02_JPRB/)  
KAO( :, 3, 1) = (/&
 & 2.6121E-02_JPRB,2.6913E-02_JPRB,2.7706E-02_JPRB,2.8545E-02_JPRB,2.9408E-02_JPRB/)  
KAO( :, 4, 1) = (/&
 & 2.0504E-02_JPRB,2.1226E-02_JPRB,2.1920E-02_JPRB,2.2632E-02_JPRB,2.3375E-02_JPRB/)  
KAO( :, 5, 1) = (/&
 & 1.6329E-02_JPRB,1.6959E-02_JPRB,1.7565E-02_JPRB,1.8162E-02_JPRB,1.8767E-02_JPRB/)  
KAO( :, 6, 1) = (/&
 & 1.3082E-02_JPRB,1.3618E-02_JPRB,1.4143E-02_JPRB,1.4651E-02_JPRB,1.5156E-02_JPRB/)  
KAO( :, 7, 1) = (/&
 & 1.0505E-02_JPRB,1.0980E-02_JPRB,1.1432E-02_JPRB,1.1872E-02_JPRB,1.2303E-02_JPRB/)  
KAO( :, 8, 1) = (/&
 & 8.4782E-03_JPRB,8.9309E-03_JPRB,9.3409E-03_JPRB,9.7321E-03_JPRB,1.0116E-02_JPRB/)  
KAO( :, 9, 1) = (/&
 & 7.0083E-03_JPRB,7.5470E-03_JPRB,8.0513E-03_JPRB,8.5154E-03_JPRB,8.9405E-03_JPRB/)  
KAO( :,10, 1) = (/&
 & 6.2679E-03_JPRB,6.8607E-03_JPRB,7.4696E-03_JPRB,8.0836E-03_JPRB,8.7113E-03_JPRB/)  
KAO( :,11, 1) = (/&
 & 5.5738E-03_JPRB,6.1775E-03_JPRB,6.7768E-03_JPRB,7.3796E-03_JPRB,7.9869E-03_JPRB/)  
KAO( :,12, 1) = (/&
 & 4.8170E-03_JPRB,5.3653E-03_JPRB,5.9132E-03_JPRB,6.4615E-03_JPRB,6.9965E-03_JPRB/)  
KAO( :,13, 1) = (/&
 & 4.0124E-03_JPRB,4.4686E-03_JPRB,4.9254E-03_JPRB,5.3837E-03_JPRB,5.8220E-03_JPRB/)  
KAO( :, 1, 2) = (/&
 & 7.6052E-02_JPRB,7.8155E-02_JPRB,8.0398E-02_JPRB,8.2890E-02_JPRB,8.5349E-02_JPRB/)  
KAO( :, 2, 2) = (/&
 & 5.9857E-02_JPRB,6.1820E-02_JPRB,6.3993E-02_JPRB,6.6271E-02_JPRB,6.8386E-02_JPRB/)  
KAO( :, 3, 2) = (/&
 & 4.6547E-02_JPRB,4.8389E-02_JPRB,5.0377E-02_JPRB,5.2388E-02_JPRB,5.4300E-02_JPRB/)  
KAO( :, 4, 2) = (/&
 & 3.6687E-02_JPRB,3.8357E-02_JPRB,4.0103E-02_JPRB,4.1837E-02_JPRB,4.3530E-02_JPRB/)  
KAO( :, 5, 2) = (/&
 & 2.9237E-02_JPRB,3.0733E-02_JPRB,3.2226E-02_JPRB,3.3703E-02_JPRB,3.5156E-02_JPRB/)  
KAO( :, 6, 2) = (/&
 & 2.3348E-02_JPRB,2.4684E-02_JPRB,2.5978E-02_JPRB,2.7223E-02_JPRB,2.8447E-02_JPRB/)  
KAO( :, 7, 2) = (/&
 & 1.8712E-02_JPRB,1.9885E-02_JPRB,2.1023E-02_JPRB,2.2089E-02_JPRB,2.3117E-02_JPRB/)  
KAO( :, 8, 2) = (/&
 & 1.5248E-02_JPRB,1.6226E-02_JPRB,1.7260E-02_JPRB,1.8206E-02_JPRB,1.9081E-02_JPRB/)  
KAO( :, 9, 2) = (/&
 & 1.3662E-02_JPRB,1.4539E-02_JPRB,1.5452E-02_JPRB,1.6398E-02_JPRB,1.7332E-02_JPRB/)  
KAO( :,10, 2) = (/&
 & 1.5758E-02_JPRB,1.7065E-02_JPRB,1.8351E-02_JPRB,1.9608E-02_JPRB,2.0713E-02_JPRB/)  
KAO( :,11, 2) = (/&
 & 1.5809E-02_JPRB,1.7330E-02_JPRB,1.8795E-02_JPRB,2.0165E-02_JPRB,2.1363E-02_JPRB/)  
KAO( :,12, 2) = (/&
 & 1.4427E-02_JPRB,1.5923E-02_JPRB,1.7365E-02_JPRB,1.8668E-02_JPRB,1.9829E-02_JPRB/)  
KAO( :,13, 2) = (/&
 & 1.2159E-02_JPRB,1.3438E-02_JPRB,1.4645E-02_JPRB,1.5727E-02_JPRB,1.6711E-02_JPRB/)  
KAO( :, 1, 3) = (/&
 & 1.1941E-01_JPRB,1.2154E-01_JPRB,1.2325E-01_JPRB,1.2478E-01_JPRB,1.2668E-01_JPRB/)  
KAO( :, 2, 3) = (/&
 & 9.4949E-02_JPRB,9.7174E-02_JPRB,9.8951E-02_JPRB,1.0048E-01_JPRB,1.0239E-01_JPRB/)  
KAO( :, 3, 3) = (/&
 & 7.4601E-02_JPRB,7.6873E-02_JPRB,7.8765E-02_JPRB,8.0479E-02_JPRB,8.2213E-02_JPRB/)  
KAO( :, 4, 3) = (/&
 & 5.9324E-02_JPRB,6.1532E-02_JPRB,6.3434E-02_JPRB,6.5160E-02_JPRB,6.6762E-02_JPRB/)  
KAO( :, 5, 3) = (/&
 & 4.7627E-02_JPRB,4.9624E-02_JPRB,5.1388E-02_JPRB,5.3000E-02_JPRB,5.4460E-02_JPRB/)  
KAO( :, 6, 3) = (/&
 & 3.8325E-02_JPRB,4.0081E-02_JPRB,4.1660E-02_JPRB,4.3161E-02_JPRB,4.4493E-02_JPRB/)  
KAO( :, 7, 3) = (/&
 & 3.1008E-02_JPRB,3.2491E-02_JPRB,3.3918E-02_JPRB,3.5275E-02_JPRB,3.6482E-02_JPRB/)  
KAO( :, 8, 3) = (/&
 & 2.5375E-02_JPRB,2.6683E-02_JPRB,2.7918E-02_JPRB,2.9119E-02_JPRB,3.0227E-02_JPRB/)  
KAO( :, 9, 3) = (/&
 & 2.2773E-02_JPRB,2.4067E-02_JPRB,2.5227E-02_JPRB,2.6300E-02_JPRB,2.7274E-02_JPRB/)  
KAO( :,10, 3) = (/&
 & 2.5056E-02_JPRB,2.7108E-02_JPRB,2.9103E-02_JPRB,3.1105E-02_JPRB,3.2910E-02_JPRB/)  
KAO( :,11, 3) = (/&
 & 2.5964E-02_JPRB,2.7973E-02_JPRB,2.9944E-02_JPRB,3.1965E-02_JPRB,3.4025E-02_JPRB/)  
KAO( :,12, 3) = (/&
 & 2.4537E-02_JPRB,2.6383E-02_JPRB,2.8189E-02_JPRB,3.0029E-02_JPRB,3.1820E-02_JPRB/)  
KAO( :,13, 3) = (/&
 & 2.0785E-02_JPRB,2.2351E-02_JPRB,2.3915E-02_JPRB,2.5481E-02_JPRB,2.6957E-02_JPRB/)  
KAO( :, 1, 4) = (/&
 & 1.7062E-01_JPRB,1.7437E-01_JPRB,1.7838E-01_JPRB,1.8288E-01_JPRB,1.8787E-01_JPRB/)  
KAO( :, 2, 4) = (/&
 & 1.3654E-01_JPRB,1.4010E-01_JPRB,1.4403E-01_JPRB,1.4850E-01_JPRB,1.5295E-01_JPRB/)  
KAO( :, 3, 4) = (/&
 & 1.0835E-01_JPRB,1.1169E-01_JPRB,1.1522E-01_JPRB,1.1900E-01_JPRB,1.2314E-01_JPRB/)  
KAO( :, 4, 4) = (/&
 & 8.6891E-02_JPRB,8.9909E-02_JPRB,9.2966E-02_JPRB,9.6155E-02_JPRB,9.9768E-02_JPRB/)  
KAO( :, 5, 4) = (/&
 & 7.0296E-02_JPRB,7.2932E-02_JPRB,7.5596E-02_JPRB,7.8371E-02_JPRB,8.1518E-02_JPRB/)  
KAO( :, 6, 4) = (/&
 & 5.7106E-02_JPRB,5.9401E-02_JPRB,6.1747E-02_JPRB,6.4154E-02_JPRB,6.6823E-02_JPRB/)  
KAO( :, 7, 4) = (/&
 & 4.6442E-02_JPRB,4.8507E-02_JPRB,5.0535E-02_JPRB,5.2614E-02_JPRB,5.4880E-02_JPRB/)  
KAO( :, 8, 4) = (/&
 & 3.8129E-02_JPRB,3.9923E-02_JPRB,4.1657E-02_JPRB,4.3454E-02_JPRB,4.5387E-02_JPRB/)  
KAO( :, 9, 4) = (/&
 & 3.3848E-02_JPRB,3.5287E-02_JPRB,3.6775E-02_JPRB,3.8335E-02_JPRB,4.0012E-02_JPRB/)  
KAO( :,10, 4) = (/&
 & 4.0975E-02_JPRB,4.3174E-02_JPRB,4.4060E-02_JPRB,4.4660E-02_JPRB,4.5678E-02_JPRB/)  
KAO( :,11, 4) = (/&
 & 4.1946E-02_JPRB,4.4641E-02_JPRB,4.6896E-02_JPRB,4.7962E-02_JPRB,4.8832E-02_JPRB/)  
KAO( :,12, 4) = (/&
 & 3.9213E-02_JPRB,4.1960E-02_JPRB,4.4202E-02_JPRB,4.5849E-02_JPRB,4.6828E-02_JPRB/)  
KAO( :,13, 4) = (/&
 & 3.3349E-02_JPRB,3.5638E-02_JPRB,3.7527E-02_JPRB,3.8919E-02_JPRB,3.9723E-02_JPRB/)  
KAO( :, 1, 5) = (/&
 & 2.9031E-01_JPRB,3.0033E-01_JPRB,3.0967E-01_JPRB,3.1844E-01_JPRB,3.2668E-01_JPRB/)  
KAO( :, 2, 5) = (/&
 & 2.3357E-01_JPRB,2.4199E-01_JPRB,2.5006E-01_JPRB,2.5762E-01_JPRB,2.6525E-01_JPRB/)  
KAO( :, 3, 5) = (/&
 & 1.8503E-01_JPRB,1.9252E-01_JPRB,1.9961E-01_JPRB,2.0653E-01_JPRB,2.1345E-01_JPRB/)  
KAO( :, 4, 5) = (/&
 & 1.4814E-01_JPRB,1.5482E-01_JPRB,1.6122E-01_JPRB,1.6737E-01_JPRB,1.7343E-01_JPRB/)  
KAO( :, 5, 5) = (/&
 & 1.1942E-01_JPRB,1.2535E-01_JPRB,1.3092E-01_JPRB,1.3637E-01_JPRB,1.4171E-01_JPRB/)  
KAO( :, 6, 5) = (/&
 & 9.6108E-02_JPRB,1.0135E-01_JPRB,1.0623E-01_JPRB,1.1100E-01_JPRB,1.1566E-01_JPRB/)  
KAO( :, 7, 5) = (/&
 & 7.7384E-02_JPRB,8.2024E-02_JPRB,8.6286E-02_JPRB,9.0422E-02_JPRB,9.4500E-02_JPRB/)  
KAO( :, 8, 5) = (/&
 & 6.2754E-02_JPRB,6.6850E-02_JPRB,7.0634E-02_JPRB,7.4249E-02_JPRB,7.7804E-02_JPRB/)  
KAO( :, 9, 5) = (/&
 & 5.3581E-02_JPRB,5.7247E-02_JPRB,6.0673E-02_JPRB,6.3910E-02_JPRB,6.7155E-02_JPRB/)  
KAO( :,10, 5) = (/&
 & 5.9240E-02_JPRB,6.0661E-02_JPRB,6.3351E-02_JPRB,6.6308E-02_JPRB,6.9274E-02_JPRB/)  
KAO( :,11, 5) = (/&
 & 6.3231E-02_JPRB,6.3689E-02_JPRB,6.4470E-02_JPRB,6.6608E-02_JPRB,6.9366E-02_JPRB/)  
KAO( :,12, 5) = (/&
 & 6.0132E-02_JPRB,6.0508E-02_JPRB,6.1046E-02_JPRB,6.2310E-02_JPRB,6.4789E-02_JPRB/)  
KAO( :,13, 5) = (/&
 & 5.1121E-02_JPRB,5.1506E-02_JPRB,5.2003E-02_JPRB,5.3196E-02_JPRB,5.5479E-02_JPRB/)  
KAO( :, 1, 6) = (/&
 & 6.0412E-01_JPRB,6.3664E-01_JPRB,6.6664E-01_JPRB,6.9440E-01_JPRB,7.1921E-01_JPRB/)  
KAO( :, 2, 6) = (/&
 & 4.9197E-01_JPRB,5.2036E-01_JPRB,5.4668E-01_JPRB,5.6991E-01_JPRB,5.8959E-01_JPRB/)  
KAO( :, 3, 6) = (/&
 & 3.9398E-01_JPRB,4.1866E-01_JPRB,4.4086E-01_JPRB,4.6020E-01_JPRB,4.7687E-01_JPRB/)  
KAO( :, 4, 6) = (/&
 & 3.1559E-01_JPRB,3.3697E-01_JPRB,3.5576E-01_JPRB,3.7272E-01_JPRB,3.8759E-01_JPRB/)  
KAO( :, 5, 6) = (/&
 & 2.5260E-01_JPRB,2.7101E-01_JPRB,2.8744E-01_JPRB,3.0238E-01_JPRB,3.1591E-01_JPRB/)  
KAO( :, 6, 6) = (/&
 & 2.0091E-01_JPRB,2.1697E-01_JPRB,2.3138E-01_JPRB,2.4461E-01_JPRB,2.5682E-01_JPRB/)  
KAO( :, 7, 6) = (/&
 & 1.5940E-01_JPRB,1.7343E-01_JPRB,1.8618E-01_JPRB,1.9790E-01_JPRB,2.0866E-01_JPRB/)  
KAO( :, 8, 6) = (/&
 & 1.2672E-01_JPRB,1.3889E-01_JPRB,1.5007E-01_JPRB,1.6032E-01_JPRB,1.6978E-01_JPRB/)  
KAO( :, 9, 6) = (/&
 & 1.0353E-01_JPRB,1.1398E-01_JPRB,1.2372E-01_JPRB,1.3277E-01_JPRB,1.4111E-01_JPRB/)  
KAO( :,10, 6) = (/&
 & 9.9695E-02_JPRB,1.0872E-01_JPRB,1.1790E-01_JPRB,1.2674E-01_JPRB,1.3501E-01_JPRB/)  
KAO( :,11, 6) = (/&
 & 9.7426E-02_JPRB,1.0472E-01_JPRB,1.1248E-01_JPRB,1.2011E-01_JPRB,1.2749E-01_JPRB/)  
KAO( :,12, 6) = (/&
 & 9.0482E-02_JPRB,9.5993E-02_JPRB,1.0239E-01_JPRB,1.0916E-01_JPRB,1.1593E-01_JPRB/)  
KAO( :,13, 6) = (/&
 & 7.7446E-02_JPRB,8.2236E-02_JPRB,8.7832E-02_JPRB,9.3763E-02_JPRB,9.9783E-02_JPRB/)  
KAO( :, 1, 7) = (/&
 & 1.4493E+00_JPRB,1.5125E+00_JPRB,1.5653E+00_JPRB,1.6113E+00_JPRB,1.6505E+00_JPRB/)  
KAO( :, 2, 7) = (/&
 & 1.2048E+00_JPRB,1.2601E+00_JPRB,1.3081E+00_JPRB,1.3501E+00_JPRB,1.3864E+00_JPRB/)  
KAO( :, 3, 7) = (/&
 & 9.7872E-01_JPRB,1.0273E+00_JPRB,1.0705E+00_JPRB,1.1100E+00_JPRB,1.1448E+00_JPRB/)  
KAO( :, 4, 7) = (/&
 & 7.9188E-01_JPRB,8.3582E-01_JPRB,8.7697E-01_JPRB,9.1358E-01_JPRB,9.4568E-01_JPRB/)  
KAO( :, 5, 7) = (/&
 & 6.4056E-01_JPRB,6.8141E-01_JPRB,7.1898E-01_JPRB,7.5224E-01_JPRB,7.8089E-01_JPRB/)  
KAO( :, 6, 7) = (/&
 & 5.1630E-01_JPRB,5.5324E-01_JPRB,5.8683E-01_JPRB,6.1659E-01_JPRB,6.4131E-01_JPRB/)  
KAO( :, 7, 7) = (/&
 & 4.1372E-01_JPRB,4.4648E-01_JPRB,4.7630E-01_JPRB,5.0239E-01_JPRB,5.2429E-01_JPRB/)  
KAO( :, 8, 7) = (/&
 & 3.2974E-01_JPRB,3.5852E-01_JPRB,3.8490E-01_JPRB,4.0778E-01_JPRB,4.2741E-01_JPRB/)  
KAO( :, 9, 7) = (/&
 & 2.6388E-01_JPRB,2.8902E-01_JPRB,3.1205E-01_JPRB,3.3216E-01_JPRB,3.4989E-01_JPRB/)  
KAO( :,10, 7) = (/&
 & 2.2852E-01_JPRB,2.5006E-01_JPRB,2.6982E-01_JPRB,2.8757E-01_JPRB,3.0387E-01_JPRB/)  
KAO( :,11, 7) = (/&
 & 2.0865E-01_JPRB,2.2711E-01_JPRB,2.4426E-01_JPRB,2.6021E-01_JPRB,2.7515E-01_JPRB/)  
KAO( :,12, 7) = (/&
 & 1.8470E-01_JPRB,2.0063E-01_JPRB,2.1568E-01_JPRB,2.2975E-01_JPRB,2.4284E-01_JPRB/)  
KAO( :,13, 7) = (/&
 & 1.5719E-01_JPRB,1.7078E-01_JPRB,1.8355E-01_JPRB,1.9562E-01_JPRB,2.0694E-01_JPRB/)  
KAO( :, 1, 8) = (/&
 & 3.6048E+00_JPRB,3.7864E+00_JPRB,3.9572E+00_JPRB,4.1208E+00_JPRB,4.2621E+00_JPRB/)  
KAO( :, 2, 8) = (/&
 & 3.2220E+00_JPRB,3.3940E+00_JPRB,3.5604E+00_JPRB,3.7122E+00_JPRB,3.8478E+00_JPRB/)  
KAO( :, 3, 8) = (/&
 & 2.7870E+00_JPRB,2.9546E+00_JPRB,3.1086E+00_JPRB,3.2475E+00_JPRB,3.3673E+00_JPRB/)  
KAO( :, 4, 8) = (/&
 & 2.3680E+00_JPRB,2.5226E+00_JPRB,2.6640E+00_JPRB,2.7896E+00_JPRB,2.9005E+00_JPRB/)  
KAO( :, 5, 8) = (/&
 & 1.9804E+00_JPRB,2.1208E+00_JPRB,2.2489E+00_JPRB,2.3642E+00_JPRB,2.4671E+00_JPRB/)  
KAO( :, 6, 8) = (/&
 & 1.6272E+00_JPRB,1.7543E+00_JPRB,1.8719E+00_JPRB,1.9790E+00_JPRB,2.0761E+00_JPRB/)  
KAO( :, 7, 8) = (/&
 & 1.3207E+00_JPRB,1.4367E+00_JPRB,1.5433E+00_JPRB,1.6406E+00_JPRB,1.7283E+00_JPRB/)  
KAO( :, 8, 8) = (/&
 & 1.0622E+00_JPRB,1.1672E+00_JPRB,1.2628E+00_JPRB,1.3495E+00_JPRB,1.4288E+00_JPRB/)  
KAO( :, 9, 8) = (/&
 & 8.5006E-01_JPRB,9.4334E-01_JPRB,1.0274E+00_JPRB,1.1050E+00_JPRB,1.1774E+00_JPRB/)  
KAO( :,10, 8) = (/&
 & 6.9534E-01_JPRB,7.7588E-01_JPRB,8.4968E-01_JPRB,9.1816E-01_JPRB,9.8186E-01_JPRB/)  
KAO( :,11, 8) = (/&
 & 6.0417E-01_JPRB,6.7126E-01_JPRB,7.3436E-01_JPRB,7.9325E-01_JPRB,8.4784E-01_JPRB/)  
KAO( :,12, 8) = (/&
 & 5.2502E-01_JPRB,5.8268E-01_JPRB,6.3773E-01_JPRB,6.8892E-01_JPRB,7.3666E-01_JPRB/)  
KAO( :,13, 8) = (/&
 & 4.4795E-01_JPRB,4.9759E-01_JPRB,5.4478E-01_JPRB,5.8860E-01_JPRB,6.2907E-01_JPRB/)  
KAO( :, 1, 9) = (/&
 & 1.0325E+01_JPRB,1.0910E+01_JPRB,1.1448E+01_JPRB,1.1915E+01_JPRB,1.2359E+01_JPRB/)  
KAO( :, 2, 9) = (/&
 & 1.0216E+01_JPRB,1.0824E+01_JPRB,1.1398E+01_JPRB,1.1919E+01_JPRB,1.2397E+01_JPRB/)  
KAO( :, 3, 9) = (/&
 & 9.7874E+00_JPRB,1.0437E+01_JPRB,1.1041E+01_JPRB,1.1612E+01_JPRB,1.2113E+01_JPRB/)  
KAO( :, 4, 9) = (/&
 & 9.1882E+00_JPRB,9.8563E+00_JPRB,1.0485E+01_JPRB,1.1057E+01_JPRB,1.1572E+01_JPRB/)  
KAO( :, 5, 9) = (/&
 & 8.4385E+00_JPRB,9.1197E+00_JPRB,9.7493E+00_JPRB,1.0327E+01_JPRB,1.0868E+01_JPRB/)  
KAO( :, 6, 9) = (/&
 & 7.5691E+00_JPRB,8.2477E+00_JPRB,8.8854E+00_JPRB,9.4650E+00_JPRB,9.9983E+00_JPRB/)  
KAO( :, 7, 9) = (/&
 & 6.6646E+00_JPRB,7.3353E+00_JPRB,7.9606E+00_JPRB,8.5227E+00_JPRB,9.0234E+00_JPRB/)  
KAO( :, 8, 9) = (/&
 & 5.7671E+00_JPRB,6.4061E+00_JPRB,6.9962E+00_JPRB,7.5311E+00_JPRB,8.0050E+00_JPRB/)  
KAO( :, 9, 9) = (/&
 & 4.9062E+00_JPRB,5.4976E+00_JPRB,6.0386E+00_JPRB,6.5346E+00_JPRB,6.9797E+00_JPRB/)  
KAO( :,10, 9) = (/&
 & 4.1414E+00_JPRB,4.6741E+00_JPRB,5.1658E+00_JPRB,5.6197E+00_JPRB,6.0353E+00_JPRB/)  
KAO( :,11, 9) = (/&
 & 3.6507E+00_JPRB,4.1155E+00_JPRB,4.5422E+00_JPRB,4.9433E+00_JPRB,5.3072E+00_JPRB/)  
KAO( :,12, 9) = (/&
 & 3.1807E+00_JPRB,3.5811E+00_JPRB,3.9600E+00_JPRB,4.3005E+00_JPRB,4.6110E+00_JPRB/)  
KAO( :,13, 9) = (/&
 & 2.7426E+00_JPRB,3.0911E+00_JPRB,3.4116E+00_JPRB,3.6974E+00_JPRB,3.9613E+00_JPRB/)  
KAO( :, 1,10) = (/&
 & 1.9502E+01_JPRB,2.0541E+01_JPRB,2.1654E+01_JPRB,2.2558E+01_JPRB,2.3382E+01_JPRB/)  
KAO( :, 2,10) = (/&
 & 2.0339E+01_JPRB,2.1542E+01_JPRB,2.2723E+01_JPRB,2.3677E+01_JPRB,2.4384E+01_JPRB/)  
KAO( :, 3,10) = (/&
 & 2.0653E+01_JPRB,2.1896E+01_JPRB,2.3069E+01_JPRB,2.4110E+01_JPRB,2.5101E+01_JPRB/)  
KAO( :, 4,10) = (/&
 & 2.0148E+01_JPRB,2.1653E+01_JPRB,2.3150E+01_JPRB,2.4435E+01_JPRB,2.5600E+01_JPRB/)  
KAO( :, 5,10) = (/&
 & 1.9857E+01_JPRB,2.1600E+01_JPRB,2.3190E+01_JPRB,2.4486E+01_JPRB,2.5655E+01_JPRB/)  
KAO( :, 6,10) = (/&
 & 1.9401E+01_JPRB,2.1152E+01_JPRB,2.2655E+01_JPRB,2.3968E+01_JPRB,2.5347E+01_JPRB/)  
KAO( :, 7,10) = (/&
 & 1.8259E+01_JPRB,1.9961E+01_JPRB,2.1523E+01_JPRB,2.3098E+01_JPRB,2.4731E+01_JPRB/)  
KAO( :, 8,10) = (/&
 & 1.6748E+01_JPRB,1.8504E+01_JPRB,2.0269E+01_JPRB,2.2106E+01_JPRB,2.3862E+01_JPRB/)  
KAO( :, 9,10) = (/&
 & 1.5105E+01_JPRB,1.7003E+01_JPRB,1.8953E+01_JPRB,2.0882E+01_JPRB,2.2601E+01_JPRB/)  
KAO( :,10,10) = (/&
 & 1.3610E+01_JPRB,1.5598E+01_JPRB,1.7574E+01_JPRB,1.9412E+01_JPRB,2.0955E+01_JPRB/)  
KAO( :,11,10) = (/&
 & 1.3112E+01_JPRB,1.5038E+01_JPRB,1.6757E+01_JPRB,1.8284E+01_JPRB,1.9636E+01_JPRB/)  
KAO( :,12,10) = (/&
 & 1.2298E+01_JPRB,1.3933E+01_JPRB,1.5418E+01_JPRB,1.6787E+01_JPRB,1.8202E+01_JPRB/)  
KAO( :,13,10) = (/&
 & 1.1121E+01_JPRB,1.2535E+01_JPRB,1.3895E+01_JPRB,1.5262E+01_JPRB,1.6521E+01_JPRB/)  
KAO( :, 1,11) = (/&
 & 2.3585E+01_JPRB,2.4605E+01_JPRB,2.5501E+01_JPRB,2.6482E+01_JPRB,2.7552E+01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB10:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB10:PART2',0,ZHOOK_HANDLE)


KAO( :, 2,11) = (/&
 & 2.5370E+01_JPRB,2.6451E+01_JPRB,2.7573E+01_JPRB,2.8778E+01_JPRB,2.9736E+01_JPRB/)  
KAO( :, 3,11) = (/&
 & 2.6353E+01_JPRB,2.7678E+01_JPRB,2.9066E+01_JPRB,3.0456E+01_JPRB,3.1588E+01_JPRB/)  
KAO( :, 4,11) = (/&
 & 2.6933E+01_JPRB,2.8519E+01_JPRB,3.0105E+01_JPRB,3.1590E+01_JPRB,3.2868E+01_JPRB/)  
KAO( :, 5,11) = (/&
 & 2.6708E+01_JPRB,2.8629E+01_JPRB,3.0424E+01_JPRB,3.2298E+01_JPRB,3.3849E+01_JPRB/)  
KAO( :, 6,11) = (/&
 & 2.5912E+01_JPRB,2.8223E+01_JPRB,3.0549E+01_JPRB,3.2673E+01_JPRB,3.4542E+01_JPRB/)  
KAO( :, 7,11) = (/&
 & 2.5158E+01_JPRB,2.7915E+01_JPRB,3.0571E+01_JPRB,3.2861E+01_JPRB,3.4743E+01_JPRB/)  
KAO( :, 8,11) = (/&
 & 2.4390E+01_JPRB,2.7375E+01_JPRB,3.0000E+01_JPRB,3.2144E+01_JPRB,3.4135E+01_JPRB/)  
KAO( :, 9,11) = (/&
 & 2.3045E+01_JPRB,2.5927E+01_JPRB,2.8454E+01_JPRB,3.0669E+01_JPRB,3.2987E+01_JPRB/)  
KAO( :,10,11) = (/&
 & 2.1314E+01_JPRB,2.4114E+01_JPRB,2.6618E+01_JPRB,2.9130E+01_JPRB,3.1810E+01_JPRB/)  
KAO( :,11,11) = (/&
 & 2.0509E+01_JPRB,2.3271E+01_JPRB,2.6048E+01_JPRB,2.8884E+01_JPRB,3.1559E+01_JPRB/)  
KAO( :,12,11) = (/&
 & 1.9750E+01_JPRB,2.2592E+01_JPRB,2.5456E+01_JPRB,2.8124E+01_JPRB,3.0408E+01_JPRB/)  
KAO( :,13,11) = (/&
 & 1.8985E+01_JPRB,2.1757E+01_JPRB,2.4278E+01_JPRB,2.6507E+01_JPRB,2.8545E+01_JPRB/)  
KAO( :, 1,12) = (/&
 & 2.7620E+01_JPRB,2.9109E+01_JPRB,3.0583E+01_JPRB,3.1779E+01_JPRB,3.2904E+01_JPRB/)  
KAO( :, 2,12) = (/&
 & 3.0792E+01_JPRB,3.2479E+01_JPRB,3.3920E+01_JPRB,3.5408E+01_JPRB,3.6645E+01_JPRB/)  
KAO( :, 3,12) = (/&
 & 3.3732E+01_JPRB,3.5632E+01_JPRB,3.7155E+01_JPRB,3.8664E+01_JPRB,4.0176E+01_JPRB/)  
KAO( :, 4,12) = (/&
 & 3.6062E+01_JPRB,3.8172E+01_JPRB,3.9899E+01_JPRB,4.1650E+01_JPRB,4.3354E+01_JPRB/)  
KAO( :, 5,12) = (/&
 & 3.7489E+01_JPRB,3.9900E+01_JPRB,4.2014E+01_JPRB,4.4198E+01_JPRB,4.6166E+01_JPRB/)  
KAO( :, 6,12) = (/&
 & 3.8225E+01_JPRB,4.1024E+01_JPRB,4.3423E+01_JPRB,4.5937E+01_JPRB,4.7978E+01_JPRB/)  
KAO( :, 7,12) = (/&
 & 3.8206E+01_JPRB,4.1095E+01_JPRB,4.3824E+01_JPRB,4.6668E+01_JPRB,4.9398E+01_JPRB/)  
KAO( :, 8,12) = (/&
 & 3.6912E+01_JPRB,4.0130E+01_JPRB,4.3546E+01_JPRB,4.7024E+01_JPRB,5.0224E+01_JPRB/)  
KAO( :, 9,12) = (/&
 & 3.5011E+01_JPRB,3.8952E+01_JPRB,4.3085E+01_JPRB,4.6961E+01_JPRB,5.0773E+01_JPRB/)  
KAO( :,10,12) = (/&
 & 3.3435E+01_JPRB,3.8068E+01_JPRB,4.2569E+01_JPRB,4.6931E+01_JPRB,5.0777E+01_JPRB/)  
KAO( :,11,12) = (/&
 & 3.4126E+01_JPRB,3.9013E+01_JPRB,4.3484E+01_JPRB,4.7491E+01_JPRB,5.1057E+01_JPRB/)  
KAO( :,12,12) = (/&
 & 3.4318E+01_JPRB,3.8949E+01_JPRB,4.3070E+01_JPRB,4.6988E+01_JPRB,5.0849E+01_JPRB/)  
KAO( :,13,12) = (/&
 & 3.3457E+01_JPRB,3.7874E+01_JPRB,4.2090E+01_JPRB,4.6382E+01_JPRB,5.0526E+01_JPRB/)  
KAO( :, 1,13) = (/&
 & 3.2081E+01_JPRB,3.3951E+01_JPRB,3.5976E+01_JPRB,3.7442E+01_JPRB,3.9187E+01_JPRB/)  
KAO( :, 2,13) = (/&
 & 3.6410E+01_JPRB,3.8639E+01_JPRB,4.0837E+01_JPRB,4.2715E+01_JPRB,4.4604E+01_JPRB/)  
KAO( :, 3,13) = (/&
 & 4.1117E+01_JPRB,4.3836E+01_JPRB,4.6286E+01_JPRB,4.8485E+01_JPRB,5.0635E+01_JPRB/)  
KAO( :, 4,13) = (/&
 & 4.5894E+01_JPRB,4.8808E+01_JPRB,5.1561E+01_JPRB,5.4122E+01_JPRB,5.6665E+01_JPRB/)  
KAO( :, 5,13) = (/&
 & 5.0469E+01_JPRB,5.3828E+01_JPRB,5.7025E+01_JPRB,5.9732E+01_JPRB,6.2393E+01_JPRB/)  
KAO( :, 6,13) = (/&
 & 5.4490E+01_JPRB,5.8263E+01_JPRB,6.1693E+01_JPRB,6.4893E+01_JPRB,6.8000E+01_JPRB/)  
KAO( :, 7,13) = (/&
 & 5.7509E+01_JPRB,6.1997E+01_JPRB,6.5932E+01_JPRB,6.9593E+01_JPRB,7.3010E+01_JPRB/)  
KAO( :, 8,13) = (/&
 & 5.9554E+01_JPRB,6.4679E+01_JPRB,6.9084E+01_JPRB,7.3440E+01_JPRB,7.7536E+01_JPRB/)  
KAO( :, 9,13) = (/&
 & 6.0329E+01_JPRB,6.5898E+01_JPRB,7.0895E+01_JPRB,7.5993E+01_JPRB,8.0372E+01_JPRB/)  
KAO( :,10,13) = (/&
 & 6.0280E+01_JPRB,6.6133E+01_JPRB,7.1850E+01_JPRB,7.7277E+01_JPRB,8.2310E+01_JPRB/)  
KAO( :,11,13) = (/&
 & 6.1417E+01_JPRB,6.8046E+01_JPRB,7.4182E+01_JPRB,8.0392E+01_JPRB,8.6582E+01_JPRB/)  
KAO( :,12,13) = (/&
 & 6.2068E+01_JPRB,6.9536E+01_JPRB,7.6455E+01_JPRB,8.3609E+01_JPRB,9.0395E+01_JPRB/)  
KAO( :,13,13) = (/&
 & 6.2814E+01_JPRB,7.0863E+01_JPRB,7.8689E+01_JPRB,8.6158E+01_JPRB,9.3125E+01_JPRB/)  
KAO( :, 1,14) = (/&
 & 4.1518E+01_JPRB,4.3146E+01_JPRB,4.5346E+01_JPRB,4.6853E+01_JPRB,4.8598E+01_JPRB/)  
KAO( :, 2,14) = (/&
 & 4.6781E+01_JPRB,4.8970E+01_JPRB,5.1880E+01_JPRB,5.4105E+01_JPRB,5.6522E+01_JPRB/)  
KAO( :, 3,14) = (/&
 & 5.1825E+01_JPRB,5.5318E+01_JPRB,5.8975E+01_JPRB,6.1521E+01_JPRB,6.4785E+01_JPRB/)  
KAO( :, 4,14) = (/&
 & 5.7018E+01_JPRB,6.1165E+01_JPRB,6.5581E+01_JPRB,6.9138E+01_JPRB,7.3301E+01_JPRB/)  
KAO( :, 5,14) = (/&
 & 6.2559E+01_JPRB,6.7532E+01_JPRB,7.2921E+01_JPRB,7.7434E+01_JPRB,8.2255E+01_JPRB/)  
KAO( :, 6,14) = (/&
 & 6.8405E+01_JPRB,7.4630E+01_JPRB,8.0801E+01_JPRB,8.6601E+01_JPRB,9.2153E+01_JPRB/)  
KAO( :, 7,14) = (/&
 & 7.4932E+01_JPRB,8.2383E+01_JPRB,8.9625E+01_JPRB,9.6790E+01_JPRB,1.0268E+02_JPRB/)  
KAO( :, 8,14) = (/&
 & 8.2763E+01_JPRB,9.1560E+01_JPRB,9.9722E+01_JPRB,1.0772E+02_JPRB,1.1418E+02_JPRB/)  
KAO( :, 9,14) = (/&
 & 9.0637E+01_JPRB,1.0061E+02_JPRB,1.1013E+02_JPRB,1.1911E+02_JPRB,1.2622E+02_JPRB/)  
KAO( :,10,14) = (/&
 & 9.8104E+01_JPRB,1.0968E+02_JPRB,1.2088E+02_JPRB,1.3085E+02_JPRB,1.3916E+02_JPRB/)  
KAO( :,11,14) = (/&
 & 1.1038E+02_JPRB,1.2405E+02_JPRB,1.3571E+02_JPRB,1.4612E+02_JPRB,1.5567E+02_JPRB/)  
KAO( :,12,14) = (/&
 & 1.2285E+02_JPRB,1.3772E+02_JPRB,1.4999E+02_JPRB,1.6146E+02_JPRB,1.7128E+02_JPRB/)  
KAO( :,13,14) = (/&
 & 1.3421E+02_JPRB,1.4967E+02_JPRB,1.6247E+02_JPRB,1.7507E+02_JPRB,1.8543E+02_JPRB/)  
KAO( :, 1,15) = (/&
 & 5.1285E+01_JPRB,5.3369E+01_JPRB,5.5201E+01_JPRB,5.6834E+01_JPRB,5.8171E+01_JPRB/)  
KAO( :, 2,15) = (/&
 & 6.1486E+01_JPRB,6.4224E+01_JPRB,6.6483E+01_JPRB,6.8385E+01_JPRB,7.0263E+01_JPRB/)  
KAO( :, 3,15) = (/&
 & 7.2996E+01_JPRB,7.6763E+01_JPRB,7.9527E+01_JPRB,8.1282E+01_JPRB,8.3483E+01_JPRB/)  
KAO( :, 4,15) = (/&
 & 8.5243E+01_JPRB,8.9543E+01_JPRB,9.2811E+01_JPRB,9.4927E+01_JPRB,9.7733E+01_JPRB/)  
KAO( :, 5,15) = (/&
 & 9.7960E+01_JPRB,1.0251E+02_JPRB,1.0689E+02_JPRB,1.0988E+02_JPRB,1.1399E+02_JPRB/)  
KAO( :, 6,15) = (/&
 & 1.1053E+02_JPRB,1.1600E+02_JPRB,1.1928E+02_JPRB,1.2539E+02_JPRB,1.3116E+02_JPRB/)  
KAO( :, 7,15) = (/&
 & 1.1978E+02_JPRB,1.2735E+02_JPRB,1.3342E+02_JPRB,1.4289E+02_JPRB,1.4830E+02_JPRB/)  
KAO( :, 8,15) = (/&
 & 1.3066E+02_JPRB,1.3994E+02_JPRB,1.4782E+02_JPRB,1.6007E+02_JPRB,1.6737E+02_JPRB/)  
KAO( :, 9,15) = (/&
 & 1.4352E+02_JPRB,1.5439E+02_JPRB,1.6271E+02_JPRB,1.7712E+02_JPRB,1.8796E+02_JPRB/)  
KAO( :,10,15) = (/&
 & 1.5667E+02_JPRB,1.6982E+02_JPRB,1.8206E+02_JPRB,1.9739E+02_JPRB,2.1049E+02_JPRB/)  
KAO( :,11,15) = (/&
 & 1.7812E+02_JPRB,1.9349E+02_JPRB,2.0867E+02_JPRB,2.2613E+02_JPRB,2.4362E+02_JPRB/)  
KAO( :,12,15) = (/&
 & 2.0254E+02_JPRB,2.2124E+02_JPRB,2.3990E+02_JPRB,2.6100E+02_JPRB,2.8038E+02_JPRB/)  
KAO( :,13,15) = (/&
 & 2.3108E+02_JPRB,2.5315E+02_JPRB,2.7665E+02_JPRB,3.0075E+02_JPRB,3.2274E+02_JPRB/)  
KAO( :, 1,16) = (/&
 & 5.2777E+01_JPRB,5.4993E+01_JPRB,5.6841E+01_JPRB,5.8609E+01_JPRB,6.0050E+01_JPRB/)  
KAO( :, 2,16) = (/&
 & 6.3981E+01_JPRB,6.6669E+01_JPRB,6.9358E+01_JPRB,7.1554E+01_JPRB,7.3336E+01_JPRB/)  
KAO( :, 3,16) = (/&
 & 7.7059E+01_JPRB,8.0904E+01_JPRB,8.4188E+01_JPRB,8.7082E+01_JPRB,8.9526E+01_JPRB/)  
KAO( :, 4,16) = (/&
 & 9.1463E+01_JPRB,9.6542E+01_JPRB,1.0088E+02_JPRB,1.0476E+02_JPRB,1.0800E+02_JPRB/)  
KAO( :, 5,16) = (/&
 & 1.0757E+02_JPRB,1.1414E+02_JPRB,1.1997E+02_JPRB,1.2530E+02_JPRB,1.2942E+02_JPRB/)  
KAO( :, 6,16) = (/&
 & 1.2556E+02_JPRB,1.3416E+02_JPRB,1.4146E+02_JPRB,1.4899E+02_JPRB,1.5433E+02_JPRB/)  
KAO( :, 7,16) = (/&
 & 1.4547E+02_JPRB,1.5695E+02_JPRB,1.6648E+02_JPRB,1.7621E+02_JPRB,1.8397E+02_JPRB/)  
KAO( :, 8,16) = (/&
 & 1.6809E+02_JPRB,1.8302E+02_JPRB,1.9611E+02_JPRB,2.0827E+02_JPRB,2.1845E+02_JPRB/)  
KAO( :, 9,16) = (/&
 & 1.9340E+02_JPRB,2.1273E+02_JPRB,2.2936E+02_JPRB,2.4529E+02_JPRB,2.5864E+02_JPRB/)  
KAO( :,10,16) = (/&
 & 2.2291E+02_JPRB,2.4754E+02_JPRB,2.6870E+02_JPRB,2.8931E+02_JPRB,3.0639E+02_JPRB/)  
KAO( :,11,16) = (/&
 & 2.7009E+02_JPRB,2.9993E+02_JPRB,3.2506E+02_JPRB,3.4949E+02_JPRB,3.6996E+02_JPRB/)  
KAO( :,12,16) = (/&
 & 3.2630E+02_JPRB,3.6087E+02_JPRB,3.9287E+02_JPRB,4.2005E+02_JPRB,4.4424E+02_JPRB/)  
KAO( :,13,16) = (/&
 & 3.9266E+02_JPRB,4.3453E+02_JPRB,4.7167E+02_JPRB,5.0330E+02_JPRB,5.3095E+02_JPRB/)  

!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KBO( :,13, 1) = (/&
 & 4.0127E-03_JPRB,4.4687E-03_JPRB,4.9253E-03_JPRB,5.3836E-03_JPRB,5.8217E-03_JPRB/)  
KBO( :,14, 1) = (/&
 & 3.3542E-03_JPRB,3.7289E-03_JPRB,4.1053E-03_JPRB,4.4790E-03_JPRB,4.8344E-03_JPRB/)  
KBO( :,15, 1) = (/&
 & 2.7756E-03_JPRB,3.0771E-03_JPRB,3.3799E-03_JPRB,3.6798E-03_JPRB,3.9637E-03_JPRB/)  
KBO( :,16, 1) = (/&
 & 2.2794E-03_JPRB,2.5195E-03_JPRB,2.7599E-03_JPRB,2.9987E-03_JPRB,3.2238E-03_JPRB/)  
KBO( :,17, 1) = (/&
 & 1.8616E-03_JPRB,2.0514E-03_JPRB,2.2420E-03_JPRB,2.4313E-03_JPRB,2.6094E-03_JPRB/)  
KBO( :,18, 1) = (/&
 & 1.5125E-03_JPRB,1.6613E-03_JPRB,1.8116E-03_JPRB,1.9607E-03_JPRB,2.1007E-03_JPRB/)  
KBO( :,19, 1) = (/&
 & 1.2313E-03_JPRB,1.3491E-03_JPRB,1.4681E-03_JPRB,1.5860E-03_JPRB,1.6968E-03_JPRB/)  
KBO( :,20, 1) = (/&
 & 1.0110E-03_JPRB,1.1056E-03_JPRB,1.2012E-03_JPRB,1.2955E-03_JPRB,1.3844E-03_JPRB/)  
KBO( :,21, 1) = (/&
 & 8.3158E-04_JPRB,9.0796E-04_JPRB,9.8512E-04_JPRB,1.0609E-03_JPRB,1.1323E-03_JPRB/)  
KBO( :,22, 1) = (/&
 & 6.8798E-04_JPRB,7.4987E-04_JPRB,8.1214E-04_JPRB,8.7287E-04_JPRB,9.3028E-04_JPRB/)  
KBO( :,23, 1) = (/&
 & 5.6933E-04_JPRB,6.1950E-04_JPRB,6.6971E-04_JPRB,7.1844E-04_JPRB,7.6466E-04_JPRB/)  
KBO( :,24, 1) = (/&
 & 4.7205E-04_JPRB,5.1270E-04_JPRB,5.5326E-04_JPRB,5.9246E-04_JPRB,6.2965E-04_JPRB/)  
KBO( :,25, 1) = (/&
 & 3.9177E-04_JPRB,4.2473E-04_JPRB,4.5751E-04_JPRB,4.8901E-04_JPRB,5.1899E-04_JPRB/)  
KBO( :,26, 1) = (/&
 & 3.2582E-04_JPRB,3.5264E-04_JPRB,3.7910E-04_JPRB,4.0446E-04_JPRB,4.2868E-04_JPRB/)  
KBO( :,27, 1) = (/&
 & 2.7103E-04_JPRB,2.9280E-04_JPRB,3.1418E-04_JPRB,3.3460E-04_JPRB,3.5420E-04_JPRB/)  
KBO( :,28, 1) = (/&
 & 2.2547E-04_JPRB,2.4309E-04_JPRB,2.6039E-04_JPRB,2.7684E-04_JPRB,2.9269E-04_JPRB/)  
KBO( :,29, 1) = (/&
 & 1.8743E-04_JPRB,2.0170E-04_JPRB,2.1564E-04_JPRB,2.2888E-04_JPRB,2.4168E-04_JPRB/)  
KBO( :,30, 1) = (/&
 & 1.5564E-04_JPRB,1.6721E-04_JPRB,1.7844E-04_JPRB,1.8907E-04_JPRB,1.9939E-04_JPRB/)  
KBO( :,31, 1) = (/&
 & 1.2905E-04_JPRB,1.3840E-04_JPRB,1.4740E-04_JPRB,1.5595E-04_JPRB,1.6423E-04_JPRB/)  
KBO( :,32, 1) = (/&
 & 1.0702E-04_JPRB,1.1456E-04_JPRB,1.2177E-04_JPRB,1.2865E-04_JPRB,1.3529E-04_JPRB/)  
KBO( :,33, 1) = (/&
 & 8.8739E-05_JPRB,9.4805E-05_JPRB,1.0060E-04_JPRB,1.0612E-04_JPRB,1.1146E-04_JPRB/)  
KBO( :,34, 1) = (/&
 & 7.3484E-05_JPRB,7.8377E-05_JPRB,8.3031E-05_JPRB,8.7477E-05_JPRB,9.1774E-05_JPRB/)  
KBO( :,35, 1) = (/&
 & 6.0456E-05_JPRB,6.4420E-05_JPRB,6.8176E-05_JPRB,7.1769E-05_JPRB,7.5241E-05_JPRB/)  
KBO( :,36, 1) = (/&
 & 4.9390E-05_JPRB,5.2616E-05_JPRB,5.5665E-05_JPRB,5.8580E-05_JPRB,6.1393E-05_JPRB/)  
KBO( :,37, 1) = (/&
 & 4.0090E-05_JPRB,4.2739E-05_JPRB,4.5249E-05_JPRB,4.7640E-05_JPRB,4.9946E-05_JPRB/)  
KBO( :,38, 1) = (/&
 & 3.2525E-05_JPRB,3.4701E-05_JPRB,3.6769E-05_JPRB,3.8731E-05_JPRB,4.0622E-05_JPRB/)  
KBO( :,39, 1) = (/&
 & 2.6387E-05_JPRB,2.8171E-05_JPRB,2.9873E-05_JPRB,3.1484E-05_JPRB,3.3034E-05_JPRB/)  
KBO( :,40, 1) = (/&
 & 2.1316E-05_JPRB,2.2785E-05_JPRB,2.4198E-05_JPRB,2.5534E-05_JPRB,2.6814E-05_JPRB/)  
KBO( :,41, 1) = (/&
 & 1.7206E-05_JPRB,1.8415E-05_JPRB,1.9590E-05_JPRB,2.0699E-05_JPRB,2.1759E-05_JPRB/)  
KBO( :,42, 1) = (/&
 & 1.3884E-05_JPRB,1.4880E-05_JPRB,1.5854E-05_JPRB,1.6776E-05_JPRB,1.7653E-05_JPRB/)  
KBO( :,43, 1) = (/&
 & 1.1169E-05_JPRB,1.1994E-05_JPRB,1.2804E-05_JPRB,1.3575E-05_JPRB,1.4303E-05_JPRB/)  
KBO( :,44, 1) = (/&
 & 8.9694E-06_JPRB,9.6558E-06_JPRB,1.0326E-05_JPRB,1.0973E-05_JPRB,1.1582E-05_JPRB/)  
KBO( :,45, 1) = (/&
 & 7.1970E-06_JPRB,7.7692E-06_JPRB,8.3256E-06_JPRB,8.8667E-06_JPRB,9.3774E-06_JPRB/)  
KBO( :,46, 1) = (/&
 & 5.7603E-06_JPRB,6.2374E-06_JPRB,6.7026E-06_JPRB,7.1541E-06_JPRB,7.5833E-06_JPRB/)  
KBO( :,47, 1) = (/&
 & 4.5904E-06_JPRB,4.9886E-06_JPRB,5.3792E-06_JPRB,5.7558E-06_JPRB,6.1172E-06_JPRB/)  
KBO( :,48, 1) = (/&
 & 3.6534E-06_JPRB,3.9855E-06_JPRB,4.3124E-06_JPRB,4.6286E-06_JPRB,4.9326E-06_JPRB/)  
KBO( :,49, 1) = (/&
 & 2.9034E-06_JPRB,3.1805E-06_JPRB,3.4538E-06_JPRB,3.7207E-06_JPRB,3.9759E-06_JPRB/)  
KBO( :,50, 1) = (/&
 & 2.3065E-06_JPRB,2.5402E-06_JPRB,2.7688E-06_JPRB,2.9931E-06_JPRB,3.2082E-06_JPRB/)  
KBO( :,51, 1) = (/&
 & 1.8310E-06_JPRB,2.0285E-06_JPRB,2.2198E-06_JPRB,2.4080E-06_JPRB,2.5898E-06_JPRB/)  
KBO( :,52, 1) = (/&
 & 1.4543E-06_JPRB,1.6160E-06_JPRB,1.7779E-06_JPRB,1.9362E-06_JPRB,2.0898E-06_JPRB/)  
KBO( :,53, 1) = (/&
 & 1.1560E-06_JPRB,1.2848E-06_JPRB,1.4229E-06_JPRB,1.5555E-06_JPRB,1.6854E-06_JPRB/)  
KBO( :,54, 1) = (/&
 & 9.2302E-07_JPRB,1.0251E-06_JPRB,1.1393E-06_JPRB,1.2519E-06_JPRB,1.3618E-06_JPRB/)  
KBO( :,55, 1) = (/&
 & 7.3926E-07_JPRB,8.1986E-07_JPRB,9.1193E-07_JPRB,1.0087E-06_JPRB,1.1013E-06_JPRB/)  
KBO( :,56, 1) = (/&
 & 5.9333E-07_JPRB,6.5666E-07_JPRB,7.3046E-07_JPRB,8.1142E-07_JPRB,8.9049E-07_JPRB/)  
KBO( :,57, 1) = (/&
 & 4.7736E-07_JPRB,5.2694E-07_JPRB,5.8578E-07_JPRB,6.5161E-07_JPRB,7.2007E-07_JPRB/)  
KBO( :,58, 1) = (/&
 & 3.8567E-07_JPRB,4.2438E-07_JPRB,4.7128E-07_JPRB,5.2459E-07_JPRB,5.8203E-07_JPRB/)  
KBO( :,59, 1) = (/&
 & 3.1642E-07_JPRB,3.4778E-07_JPRB,3.8612E-07_JPRB,4.2992E-07_JPRB,4.7734E-07_JPRB/)  
KBO( :,13, 2) = (/&
 & 1.2160E-02_JPRB,1.3438E-02_JPRB,1.4645E-02_JPRB,1.5727E-02_JPRB,1.6711E-02_JPRB/)  
KBO( :,14, 2) = (/&
 & 1.0225E-02_JPRB,1.1288E-02_JPRB,1.2265E-02_JPRB,1.3154E-02_JPRB,1.3956E-02_JPRB/)  
KBO( :,15, 2) = (/&
 & 8.4456E-03_JPRB,9.2918E-03_JPRB,1.0065E-02_JPRB,1.0768E-02_JPRB,1.1393E-02_JPRB/)  
KBO( :,16, 2) = (/&
 & 6.8924E-03_JPRB,7.5463E-03_JPRB,8.1481E-03_JPRB,8.6924E-03_JPRB,9.1710E-03_JPRB/)  
KBO( :,17, 2) = (/&
 & 5.5778E-03_JPRB,6.0832E-03_JPRB,6.5471E-03_JPRB,6.9629E-03_JPRB,7.3305E-03_JPRB/)  
KBO( :,18, 2) = (/&
 & 4.4688E-03_JPRB,4.8540E-03_JPRB,5.2070E-03_JPRB,5.5215E-03_JPRB,5.8036E-03_JPRB/)  
KBO( :,19, 2) = (/&
 & 3.5967E-03_JPRB,3.8949E-03_JPRB,4.1669E-03_JPRB,4.4096E-03_JPRB,4.6280E-03_JPRB/)  
KBO( :,20, 2) = (/&
 & 2.9298E-03_JPRB,3.1646E-03_JPRB,3.3779E-03_JPRB,3.5694E-03_JPRB,3.7401E-03_JPRB/)  
KBO( :,21, 2) = (/&
 & 2.3932E-03_JPRB,2.5790E-03_JPRB,2.7477E-03_JPRB,2.8993E-03_JPRB,3.0338E-03_JPRB/)  
KBO( :,22, 2) = (/&
 & 1.9643E-03_JPRB,2.1105E-03_JPRB,2.2434E-03_JPRB,2.3626E-03_JPRB,2.4679E-03_JPRB/)  
KBO( :,23, 2) = (/&
 & 1.6125E-03_JPRB,1.7277E-03_JPRB,1.8326E-03_JPRB,1.9262E-03_JPRB,2.0085E-03_JPRB/)  
KBO( :,24, 2) = (/&
 & 1.3282E-03_JPRB,1.4199E-03_JPRB,1.5028E-03_JPRB,1.5765E-03_JPRB,1.6410E-03_JPRB/)  
KBO( :,25, 2) = (/&
 & 1.0951E-03_JPRB,1.1683E-03_JPRB,1.2337E-03_JPRB,1.2916E-03_JPRB,1.3424E-03_JPRB/)  
KBO( :,26, 2) = (/&
 & 9.0567E-04_JPRB,9.6375E-04_JPRB,1.0153E-03_JPRB,1.0609E-03_JPRB,1.1006E-03_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB10:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


SUBROUTINE PART3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB10:PART3',0,ZHOOK_HANDLE)


KBO( :,27, 2) = (/&
 & 7.4971E-04_JPRB,7.9563E-04_JPRB,8.3627E-04_JPRB,8.7231E-04_JPRB,9.0333E-04_JPRB/)  
KBO( :,28, 2) = (/&
 & 6.2083E-04_JPRB,6.5706E-04_JPRB,6.8919E-04_JPRB,7.1762E-04_JPRB,7.4183E-04_JPRB/)  
KBO( :,29, 2) = (/&
 & 5.1283E-04_JPRB,5.4134E-04_JPRB,5.6668E-04_JPRB,5.8892E-04_JPRB,6.0775E-04_JPRB/)  
KBO( :,30, 2) = (/&
 & 4.2274E-04_JPRB,4.4513E-04_JPRB,4.6510E-04_JPRB,4.8244E-04_JPRB,4.9704E-04_JPRB/)  
KBO( :,31, 2) = (/&
 & 3.4700E-04_JPRB,3.6458E-04_JPRB,3.8019E-04_JPRB,3.9360E-04_JPRB,4.0492E-04_JPRB/)  
KBO( :,32, 2) = (/&
 & 2.8510E-04_JPRB,2.9895E-04_JPRB,3.1110E-04_JPRB,3.2149E-04_JPRB,3.3026E-04_JPRB/)  
KBO( :,33, 2) = (/&
 & 2.3440E-04_JPRB,2.4528E-04_JPRB,2.5470E-04_JPRB,2.6280E-04_JPRB,2.6955E-04_JPRB/)  
KBO( :,34, 2) = (/&
 & 1.9316E-04_JPRB,2.0175E-04_JPRB,2.0916E-04_JPRB,2.1548E-04_JPRB,2.2075E-04_JPRB/)  
KBO( :,35, 2) = (/&
 & 1.5858E-04_JPRB,1.6542E-04_JPRB,1.7135E-04_JPRB,1.7637E-04_JPRB,1.8056E-04_JPRB/)  
KBO( :,36, 2) = (/&
 & 1.2966E-04_JPRB,1.3522E-04_JPRB,1.4003E-04_JPRB,1.4410E-04_JPRB,1.4751E-04_JPRB/)  
KBO( :,37, 2) = (/&
 & 1.0583E-04_JPRB,1.1047E-04_JPRB,1.1450E-04_JPRB,1.1791E-04_JPRB,1.2077E-04_JPRB/)  
KBO( :,38, 2) = (/&
 & 8.6354E-05_JPRB,9.0236E-05_JPRB,9.3617E-05_JPRB,9.6482E-05_JPRB,9.8878E-05_JPRB/)  
KBO( :,39, 2) = (/&
 & 7.0455E-05_JPRB,7.3698E-05_JPRB,7.6539E-05_JPRB,7.8943E-05_JPRB,8.0950E-05_JPRB/)  
KBO( :,40, 2) = (/&
 & 5.7475E-05_JPRB,6.0235E-05_JPRB,6.2673E-05_JPRB,6.4741E-05_JPRB,6.6460E-05_JPRB/)  
KBO( :,41, 2) = (/&
 & 4.6872E-05_JPRB,4.9225E-05_JPRB,5.1315E-05_JPRB,5.3102E-05_JPRB,5.4585E-05_JPRB/)  
KBO( :,42, 2) = (/&
 & 3.8212E-05_JPRB,4.0216E-05_JPRB,4.1999E-05_JPRB,4.3546E-05_JPRB,4.4830E-05_JPRB/)  
KBO( :,43, 2) = (/&
 & 3.1158E-05_JPRB,3.2889E-05_JPRB,3.4429E-05_JPRB,3.5779E-05_JPRB,3.6907E-05_JPRB/)  
KBO( :,44, 2) = (/&
 & 2.5395E-05_JPRB,2.6902E-05_JPRB,2.8242E-05_JPRB,2.9418E-05_JPRB,3.0418E-05_JPRB/)  
KBO( :,45, 2) = (/&
 & 2.0690E-05_JPRB,2.1996E-05_JPRB,2.3163E-05_JPRB,2.4189E-05_JPRB,2.5065E-05_JPRB/)  
KBO( :,46, 2) = (/&
 & 1.6831E-05_JPRB,1.7958E-05_JPRB,1.8979E-05_JPRB,1.9882E-05_JPRB,2.0651E-05_JPRB/)  
KBO( :,47, 2) = (/&
 & 1.3652E-05_JPRB,1.4627E-05_JPRB,1.5521E-05_JPRB,1.6321E-05_JPRB,1.7007E-05_JPRB/)  
KBO( :,48, 2) = (/&
 & 1.1060E-05_JPRB,1.1904E-05_JPRB,1.2686E-05_JPRB,1.3393E-05_JPRB,1.4006E-05_JPRB/)  
KBO( :,49, 2) = (/&
 & 8.9492E-06_JPRB,9.6804E-06_JPRB,1.0363E-05_JPRB,1.0983E-05_JPRB,1.1533E-05_JPRB/)  
KBO( :,50, 2) = (/&
 & 7.2405E-06_JPRB,7.8785E-06_JPRB,8.4705E-06_JPRB,9.0129E-06_JPRB,9.5008E-06_JPRB/)  
KBO( :,51, 2) = (/&
 & 5.8460E-06_JPRB,6.4101E-06_JPRB,6.9248E-06_JPRB,7.3984E-06_JPRB,7.8284E-06_JPRB/)  
KBO( :,52, 2) = (/&
 & 4.6997E-06_JPRB,5.2070E-06_JPRB,5.6596E-06_JPRB,6.0736E-06_JPRB,6.4507E-06_JPRB/)  
KBO( :,53, 2) = (/&
 & 3.7614E-06_JPRB,4.2159E-06_JPRB,4.6210E-06_JPRB,4.9854E-06_JPRB,5.3156E-06_JPRB/)  
KBO( :,54, 2) = (/&
 & 3.0075E-06_JPRB,3.4121E-06_JPRB,3.7745E-06_JPRB,4.1002E-06_JPRB,4.3906E-06_JPRB/)  
KBO( :,55, 2) = (/&
 & 2.4043E-06_JPRB,2.7566E-06_JPRB,3.0802E-06_JPRB,3.3721E-06_JPRB,3.6314E-06_JPRB/)  
KBO( :,56, 2) = (/&
 & 1.9210E-06_JPRB,2.2197E-06_JPRB,2.5091E-06_JPRB,2.7692E-06_JPRB,3.0032E-06_JPRB/)  
KBO( :,57, 2) = (/&
 & 1.5317E-06_JPRB,1.7871E-06_JPRB,2.0379E-06_JPRB,2.2717E-06_JPRB,2.4826E-06_JPRB/)  
KBO( :,58, 2) = (/&
 & 1.2206E-06_JPRB,1.4418E-06_JPRB,1.6546E-06_JPRB,1.8628E-06_JPRB,2.0522E-06_JPRB/)  
KBO( :,59, 2) = (/&
 & 9.9907E-07_JPRB,1.1883E-06_JPRB,1.3690E-06_JPRB,1.5455E-06_JPRB,1.7114E-06_JPRB/)  
KBO( :,13, 3) = (/&
 & 2.0786E-02_JPRB,2.2351E-02_JPRB,2.3914E-02_JPRB,2.5482E-02_JPRB,2.6955E-02_JPRB/)  
KBO( :,14, 3) = (/&
 & 1.7451E-02_JPRB,1.8772E-02_JPRB,2.0114E-02_JPRB,2.1398E-02_JPRB,2.2623E-02_JPRB/)  
KBO( :,15, 3) = (/&
 & 1.4302E-02_JPRB,1.5409E-02_JPRB,1.6505E-02_JPRB,1.7555E-02_JPRB,1.8558E-02_JPRB/)  
KBO( :,16, 3) = (/&
 & 1.1560E-02_JPRB,1.2473E-02_JPRB,1.3359E-02_JPRB,1.4211E-02_JPRB,1.4998E-02_JPRB/)  
KBO( :,17, 3) = (/&
 & 9.2944E-03_JPRB,1.0027E-02_JPRB,1.0736E-02_JPRB,1.1417E-02_JPRB,1.2019E-02_JPRB/)  
KBO( :,18, 3) = (/&
 & 7.4021E-03_JPRB,7.9861E-03_JPRB,8.5472E-03_JPRB,9.0743E-03_JPRB,9.5344E-03_JPRB/)  
KBO( :,19, 3) = (/&
 & 5.9440E-03_JPRB,6.4084E-03_JPRB,6.8519E-03_JPRB,7.2597E-03_JPRB,7.6128E-03_JPRB/)  
KBO( :,20, 3) = (/&
 & 4.8413E-03_JPRB,5.2128E-03_JPRB,5.5678E-03_JPRB,5.8851E-03_JPRB,6.1565E-03_JPRB/)  
KBO( :,21, 3) = (/&
 & 3.9554E-03_JPRB,4.2547E-03_JPRB,4.5379E-03_JPRB,4.7882E-03_JPRB,4.9942E-03_JPRB/)  
KBO( :,22, 3) = (/&
 & 3.2474E-03_JPRB,3.4884E-03_JPRB,3.7113E-03_JPRB,3.9077E-03_JPRB,4.0588E-03_JPRB/)  
KBO( :,23, 3) = (/&
 & 2.6676E-03_JPRB,2.8612E-03_JPRB,3.0356E-03_JPRB,3.1862E-03_JPRB,3.2997E-03_JPRB/)  
KBO( :,24, 3) = (/&
 & 2.2001E-03_JPRB,2.3544E-03_JPRB,2.4920E-03_JPRB,2.6064E-03_JPRB,2.6941E-03_JPRB/)  
KBO( :,25, 3) = (/&
 & 1.8169E-03_JPRB,1.9393E-03_JPRB,2.0482E-03_JPRB,2.1336E-03_JPRB,2.2024E-03_JPRB/)  
KBO( :,26, 3) = (/&
 & 1.5047E-03_JPRB,1.6016E-03_JPRB,1.6869E-03_JPRB,1.7502E-03_JPRB,1.8053E-03_JPRB/)  
KBO( :,27, 3) = (/&
 & 1.2468E-03_JPRB,1.3235E-03_JPRB,1.3890E-03_JPRB,1.4372E-03_JPRB,1.4821E-03_JPRB/)  
KBO( :,28, 3) = (/&
 & 1.0331E-03_JPRB,1.0942E-03_JPRB,1.1434E-03_JPRB,1.1812E-03_JPRB,1.2183E-03_JPRB/)  
KBO( :,29, 3) = (/&
 & 8.5445E-04_JPRB,9.0249E-04_JPRB,9.3879E-04_JPRB,9.6890E-04_JPRB,9.9940E-04_JPRB/)  
KBO( :,30, 3) = (/&
 & 7.0538E-04_JPRB,7.4243E-04_JPRB,7.6932E-04_JPRB,7.9375E-04_JPRB,8.1874E-04_JPRB/)  
KBO( :,31, 3) = (/&
 & 5.8013E-04_JPRB,6.0755E-04_JPRB,6.2805E-04_JPRB,6.4789E-04_JPRB,6.6815E-04_JPRB/)  
KBO( :,32, 3) = (/&
 & 4.7748E-04_JPRB,4.9738E-04_JPRB,5.1357E-04_JPRB,5.2976E-04_JPRB,5.4616E-04_JPRB/)  
KBO( :,33, 3) = (/&
 & 3.9283E-04_JPRB,4.0745E-04_JPRB,4.2047E-04_JPRB,4.3362E-04_JPRB,4.4699E-04_JPRB/)  
KBO( :,34, 3) = (/&
 & 3.2354E-04_JPRB,3.3493E-04_JPRB,3.4555E-04_JPRB,3.5630E-04_JPRB,3.6722E-04_JPRB/)  
KBO( :,35, 3) = (/&
 & 2.6563E-04_JPRB,2.7479E-04_JPRB,2.8346E-04_JPRB,2.9224E-04_JPRB,3.0115E-04_JPRB/)  
KBO( :,36, 3) = (/&
 & 2.1746E-04_JPRB,2.2496E-04_JPRB,2.3205E-04_JPRB,2.3922E-04_JPRB,2.4648E-04_JPRB/)  
KBO( :,37, 3) = (/&
 & 1.7790E-04_JPRB,1.8421E-04_JPRB,1.9005E-04_JPRB,1.9594E-04_JPRB,2.0188E-04_JPRB/)  
KBO( :,38, 3) = (/&
 & 1.4546E-04_JPRB,1.5084E-04_JPRB,1.5564E-04_JPRB,1.6048E-04_JPRB,1.6535E-04_JPRB/)  
KBO( :,39, 3) = (/&
 & 1.1888E-04_JPRB,1.2350E-04_JPRB,1.2746E-04_JPRB,1.3144E-04_JPRB,1.3545E-04_JPRB/)  
KBO( :,40, 3) = (/&
 & 9.7055E-05_JPRB,1.0127E-04_JPRB,1.0459E-04_JPRB,1.0789E-04_JPRB,1.1120E-04_JPRB/)  
KBO( :,41, 3) = (/&
 & 7.9154E-05_JPRB,8.3014E-05_JPRB,8.5866E-05_JPRB,8.8590E-05_JPRB,9.1337E-05_JPRB/)  
KBO( :,42, 3) = (/&
 & 6.4516E-05_JPRB,6.7988E-05_JPRB,7.0503E-05_JPRB,7.2755E-05_JPRB,7.5027E-05_JPRB/)  
KBO( :,43, 3) = (/&
 & 5.2586E-05_JPRB,5.5638E-05_JPRB,5.8012E-05_JPRB,5.9918E-05_JPRB,6.1807E-05_JPRB/)  
KBO( :,44, 3) = (/&
 & 4.2846E-05_JPRB,4.5469E-05_JPRB,4.7752E-05_JPRB,4.9435E-05_JPRB,5.1007E-05_JPRB/)  
KBO( :,45, 3) = (/&
 & 3.4876E-05_JPRB,3.7158E-05_JPRB,3.9219E-05_JPRB,4.0798E-05_JPRB,4.2133E-05_JPRB/)  
KBO( :,46, 3) = (/&
 & 2.8345E-05_JPRB,3.0331E-05_JPRB,3.2109E-05_JPRB,3.3641E-05_JPRB,3.4818E-05_JPRB/)  
KBO( :,47, 3) = (/&
 & 2.2997E-05_JPRB,2.4688E-05_JPRB,2.6250E-05_JPRB,2.7649E-05_JPRB,2.8769E-05_JPRB/)  
KBO( :,48, 3) = (/&
 & 1.8671E-05_JPRB,2.0088E-05_JPRB,2.1457E-05_JPRB,2.2672E-05_JPRB,2.3753E-05_JPRB/)  
KBO( :,49, 3) = (/&
 & 1.5172E-05_JPRB,1.6362E-05_JPRB,1.7526E-05_JPRB,1.8600E-05_JPRB,1.9566E-05_JPRB/)  
KBO( :,50, 3) = (/&
 & 1.2371E-05_JPRB,1.3362E-05_JPRB,1.4334E-05_JPRB,1.5278E-05_JPRB,1.6112E-05_JPRB/)  
KBO( :,51, 3) = (/&
 & 1.0118E-05_JPRB,1.0936E-05_JPRB,1.1749E-05_JPRB,1.2556E-05_JPRB,1.3289E-05_JPRB/)  
KBO( :,52, 3) = (/&
 & 8.2966E-06_JPRB,8.9718E-06_JPRB,9.6516E-06_JPRB,1.0325E-05_JPRB,1.0972E-05_JPRB/)  
KBO( :,53, 3) = (/&
 & 6.8197E-06_JPRB,7.3847E-06_JPRB,7.9459E-06_JPRB,8.5100E-06_JPRB,9.0658E-06_JPRB/)  
KBO( :,54, 3) = (/&
 & 5.6318E-06_JPRB,6.1106E-06_JPRB,6.5789E-06_JPRB,7.0470E-06_JPRB,7.5143E-06_JPRB/)  
KBO( :,55, 3) = (/&
 & 4.6648E-06_JPRB,5.0803E-06_JPRB,5.4755E-06_JPRB,5.8623E-06_JPRB,6.2545E-06_JPRB/)  
KBO( :,56, 3) = (/&
 & 3.8708E-06_JPRB,4.2378E-06_JPRB,4.5762E-06_JPRB,4.9013E-06_JPRB,5.2284E-06_JPRB/)  
KBO( :,57, 3) = (/&
 & 3.2206E-06_JPRB,3.5441E-06_JPRB,3.8440E-06_JPRB,4.1208E-06_JPRB,4.3930E-06_JPRB/)  
KBO( :,58, 3) = (/&
 & 2.6894E-06_JPRB,2.9742E-06_JPRB,3.2435E-06_JPRB,3.4859E-06_JPRB,3.7158E-06_JPRB/)  
KBO( :,59, 3) = (/&
 & 2.2697E-06_JPRB,2.5173E-06_JPRB,2.7510E-06_JPRB,2.9640E-06_JPRB,3.1586E-06_JPRB/)  
KBO( :,13, 4) = (/&
 & 3.3348E-02_JPRB,3.5638E-02_JPRB,3.7527E-02_JPRB,3.8919E-02_JPRB,3.9722E-02_JPRB/)  
KBO( :,14, 4) = (/&
 & 2.8133E-02_JPRB,2.9965E-02_JPRB,3.1537E-02_JPRB,3.2552E-02_JPRB,3.3172E-02_JPRB/)  
KBO( :,15, 4) = (/&
 & 2.3195E-02_JPRB,2.4631E-02_JPRB,2.5882E-02_JPRB,2.6505E-02_JPRB,2.6995E-02_JPRB/)  
KBO( :,16, 4) = (/&
 & 1.8840E-02_JPRB,1.9967E-02_JPRB,2.0839E-02_JPRB,2.1232E-02_JPRB,2.1643E-02_JPRB/)  
KBO( :,17, 4) = (/&
 & 1.5191E-02_JPRB,1.6076E-02_JPRB,1.6629E-02_JPRB,1.6911E-02_JPRB,1.7254E-02_JPRB/)  
KBO( :,18, 4) = (/&
 & 1.2129E-02_JPRB,1.2801E-02_JPRB,1.3112E-02_JPRB,1.3338E-02_JPRB,1.3606E-02_JPRB/)  
KBO( :,19, 4) = (/&
 & 9.7476E-03_JPRB,1.0232E-02_JPRB,1.0428E-02_JPRB,1.0608E-02_JPRB,1.0828E-02_JPRB/)  
KBO( :,20, 4) = (/&
 & 7.9368E-03_JPRB,8.2717E-03_JPRB,8.4067E-03_JPRB,8.5556E-03_JPRB,8.7467E-03_JPRB/)  
KBO( :,21, 4) = (/&
 & 6.4875E-03_JPRB,6.7006E-03_JPRB,6.8050E-03_JPRB,6.9274E-03_JPRB,7.0981E-03_JPRB/)  
KBO( :,22, 4) = (/&
 & 5.3123E-03_JPRB,5.4283E-03_JPRB,5.5157E-03_JPRB,5.6201E-03_JPRB,5.7769E-03_JPRB/)  
KBO( :,23, 4) = (/&
 & 4.3285E-03_JPRB,4.4003E-03_JPRB,4.4749E-03_JPRB,4.5691E-03_JPRB,4.7070E-03_JPRB/)  
KBO( :,24, 4) = (/&
 & 3.5319E-03_JPRB,3.5856E-03_JPRB,3.6485E-03_JPRB,3.7338E-03_JPRB,3.8516E-03_JPRB/)  
KBO( :,25, 4) = (/&
 & 2.8812E-03_JPRB,2.9257E-03_JPRB,2.9788E-03_JPRB,3.0577E-03_JPRB,3.1571E-03_JPRB/)  
KBO( :,26, 4) = (/&
 & 2.3549E-03_JPRB,2.3931E-03_JPRB,2.4398E-03_JPRB,2.5120E-03_JPRB,2.5956E-03_JPRB/)  
KBO( :,27, 4) = (/&
 & 1.9281E-03_JPRB,1.9612E-03_JPRB,2.0042E-03_JPRB,2.0672E-03_JPRB,2.1371E-03_JPRB/)  
KBO( :,28, 4) = (/&
 & 1.5812E-03_JPRB,1.6092E-03_JPRB,1.6493E-03_JPRB,1.7029E-03_JPRB,1.7614E-03_JPRB/)  
KBO( :,29, 4) = (/&
 & 1.2934E-03_JPRB,1.3182E-03_JPRB,1.3554E-03_JPRB,1.4008E-03_JPRB,1.4497E-03_JPRB/)  
KBO( :,30, 4) = (/&
 & 1.0569E-03_JPRB,1.0795E-03_JPRB,1.1129E-03_JPRB,1.1513E-03_JPRB,1.1924E-03_JPRB/)  
KBO( :,31, 4) = (/&
 & 8.6072E-04_JPRB,8.8192E-04_JPRB,9.1116E-04_JPRB,9.4362E-04_JPRB,9.7860E-04_JPRB/)  
KBO( :,32, 4) = (/&
 & 7.0258E-04_JPRB,7.2255E-04_JPRB,7.4782E-04_JPRB,7.7514E-04_JPRB,8.0493E-04_JPRB/)  
KBO( :,33, 4) = (/&
 & 5.7482E-04_JPRB,5.9318E-04_JPRB,6.1484E-04_JPRB,6.3779E-04_JPRB,6.6313E-04_JPRB/)  
KBO( :,34, 4) = (/&
 & 4.7271E-04_JPRB,4.8878E-04_JPRB,5.0702E-04_JPRB,5.2638E-04_JPRB,5.4786E-04_JPRB/)  
KBO( :,35, 4) = (/&
 & 3.8824E-04_JPRB,4.0194E-04_JPRB,4.1715E-04_JPRB,4.3337E-04_JPRB,4.5133E-04_JPRB/)  
KBO( :,36, 4) = (/&
 & 3.1820E-04_JPRB,3.2965E-04_JPRB,3.4225E-04_JPRB,3.5569E-04_JPRB,3.7045E-04_JPRB/)  
KBO( :,37, 4) = (/&
 & 2.6087E-04_JPRB,2.7015E-04_JPRB,2.8055E-04_JPRB,2.9152E-04_JPRB,3.0353E-04_JPRB/)  
KBO( :,38, 4) = (/&
 & 2.1395E-04_JPRB,2.2142E-04_JPRB,2.2996E-04_JPRB,2.3892E-04_JPRB,2.4870E-04_JPRB/)  
KBO( :,39, 4) = (/&
 & 1.7555E-04_JPRB,1.8151E-04_JPRB,1.8852E-04_JPRB,1.9581E-04_JPRB,2.0378E-04_JPRB/)  
KBO( :,40, 4) = (/&
 & 1.4448E-04_JPRB,1.4897E-04_JPRB,1.5464E-04_JPRB,1.6057E-04_JPRB,1.6703E-04_JPRB/)  
KBO( :,41, 4) = (/&
 & 1.1907E-04_JPRB,1.2237E-04_JPRB,1.2690E-04_JPRB,1.3173E-04_JPRB,1.3696E-04_JPRB/)  
KBO( :,42, 4) = (/&
 & 9.8189E-05_JPRB,1.0062E-04_JPRB,1.0417E-04_JPRB,1.0812E-04_JPRB,1.1234E-04_JPRB/)  
KBO( :,43, 4) = (/&
 & 8.1285E-05_JPRB,8.3104E-05_JPRB,8.5710E-05_JPRB,8.8901E-05_JPRB,9.2309E-05_JPRB/)  
KBO( :,44, 4) = (/&
 & 6.7490E-05_JPRB,6.8895E-05_JPRB,7.0708E-05_JPRB,7.3224E-05_JPRB,7.5980E-05_JPRB/)  
KBO( :,45, 4) = (/&
 & 5.6130E-05_JPRB,5.7190E-05_JPRB,5.8518E-05_JPRB,6.0401E-05_JPRB,6.2619E-05_JPRB/)  
KBO( :,46, 4) = (/&
 & 4.6746E-05_JPRB,4.7563E-05_JPRB,4.8588E-05_JPRB,4.9905E-05_JPRB,5.1654E-05_JPRB/)  
KBO( :,47, 4) = (/&
 & 3.8886E-05_JPRB,3.9651E-05_JPRB,4.0414E-05_JPRB,4.1369E-05_JPRB,4.2661E-05_JPRB/)  
KBO( :,48, 4) = (/&
 & 3.2050E-05_JPRB,3.3124E-05_JPRB,3.3698E-05_JPRB,3.4432E-05_JPRB,3.5333E-05_JPRB/)  
KBO( :,49, 4) = (/&
 & 2.6226E-05_JPRB,2.7647E-05_JPRB,2.8176E-05_JPRB,2.8720E-05_JPRB,2.9390E-05_JPRB/)  
KBO( :,50, 4) = (/&
 & 2.1474E-05_JPRB,2.2897E-05_JPRB,2.3616E-05_JPRB,2.4028E-05_JPRB,2.4549E-05_JPRB/)  
KBO( :,51, 4) = (/&
 & 1.7587E-05_JPRB,1.8848E-05_JPRB,1.9798E-05_JPRB,2.0162E-05_JPRB,2.0554E-05_JPRB/)  
KBO( :,52, 4) = (/&
 & 1.4397E-05_JPRB,1.5513E-05_JPRB,1.6498E-05_JPRB,1.6964E-05_JPRB,1.7266E-05_JPRB/)  
KBO( :,53, 4) = (/&
 & 1.1772E-05_JPRB,1.2776E-05_JPRB,1.3653E-05_JPRB,1.4290E-05_JPRB,1.4555E-05_JPRB/)  
KBO( :,54, 4) = (/&
 & 9.6285E-06_JPRB,1.0547E-05_JPRB,1.1325E-05_JPRB,1.1997E-05_JPRB,1.2314E-05_JPRB/)  
KBO( :,55, 4) = (/&
 & 7.8686E-06_JPRB,8.7205E-06_JPRB,9.4148E-06_JPRB,1.0021E-05_JPRB,1.0444E-05_JPRB/)  
KBO( :,56, 4) = (/&
 & 6.4474E-06_JPRB,7.2044E-06_JPRB,7.8377E-06_JPRB,8.3851E-06_JPRB,8.8446E-06_JPRB/)  
KBO( :,57, 4) = (/&
 & 5.3026E-06_JPRB,5.9425E-06_JPRB,6.5385E-06_JPRB,7.0305E-06_JPRB,7.4552E-06_JPRB/)  
KBO( :,58, 4) = (/&
 & 4.3875E-06_JPRB,4.9223E-06_JPRB,5.4609E-06_JPRB,5.9117E-06_JPRB,6.2971E-06_JPRB/)  
KBO( :,59, 4) = (/&
 & 3.6889E-06_JPRB,4.1378E-06_JPRB,4.5957E-06_JPRB,4.9992E-06_JPRB,5.3354E-06_JPRB/)  
KBO( :,13, 5) = (/&
 & 5.1121E-02_JPRB,5.1507E-02_JPRB,5.2004E-02_JPRB,5.3195E-02_JPRB,5.5478E-02_JPRB/)  
KBO( :,14, 5) = (/&
 & 4.2903E-02_JPRB,4.3219E-02_JPRB,4.3663E-02_JPRB,4.5005E-02_JPRB,4.7060E-02_JPRB/)  
KBO( :,15, 5) = (/&
 & 3.5068E-02_JPRB,3.5353E-02_JPRB,3.5864E-02_JPRB,3.7306E-02_JPRB,3.9103E-02_JPRB/)  
KBO( :,16, 5) = (/&
 & 2.8258E-02_JPRB,2.8536E-02_JPRB,2.9205E-02_JPRB,3.0568E-02_JPRB,3.2105E-02_JPRB/)  
KBO( :,17, 5) = (/&
 & 2.2642E-02_JPRB,2.2932E-02_JPRB,2.3698E-02_JPRB,2.4891E-02_JPRB,2.6185E-02_JPRB/)  
KBO( :,18, 5) = (/&
 & 1.7964E-02_JPRB,1.8281E-02_JPRB,1.9084E-02_JPRB,2.0096E-02_JPRB,2.1180E-02_JPRB/)  
KBO( :,19, 5) = (/&
 & 1.4384E-02_JPRB,1.4732E-02_JPRB,1.5474E-02_JPRB,1.6321E-02_JPRB,1.7214E-02_JPRB/)  
KBO( :,20, 5) = (/&
 & 1.1675E-02_JPRB,1.2051E-02_JPRB,1.2712E-02_JPRB,1.3419E-02_JPRB,1.4150E-02_JPRB/)  
KBO( :,21, 5) = (/&
 & 9.5108E-03_JPRB,9.9043E-03_JPRB,1.0466E-02_JPRB,1.1048E-02_JPRB,1.1656E-02_JPRB/)  
KBO( :,22, 5) = (/&
 & 7.7720E-03_JPRB,8.1751E-03_JPRB,8.6406E-03_JPRB,9.1253E-03_JPRB,9.6344E-03_JPRB/)  
KBO( :,23, 5) = (/&
 & 6.3846E-03_JPRB,6.7498E-03_JPRB,7.1331E-03_JPRB,7.5377E-03_JPRB,7.9653E-03_JPRB/)  
KBO( :,24, 5) = (/&
 & 5.2771E-03_JPRB,5.5862E-03_JPRB,5.9043E-03_JPRB,6.2445E-03_JPRB,6.6015E-03_JPRB/)  
KBO( :,25, 5) = (/&
 & 4.3695E-03_JPRB,4.6259E-03_JPRB,4.8938E-03_JPRB,5.1786E-03_JPRB,5.4764E-03_JPRB/)  
KBO( :,26, 5) = (/&
 & 3.6280E-03_JPRB,3.8403E-03_JPRB,4.0669E-03_JPRB,4.3054E-03_JPRB,4.5535E-03_JPRB/)  
KBO( :,27, 5) = (/&
 & 3.0145E-03_JPRB,3.1918E-03_JPRB,3.3815E-03_JPRB,3.5819E-03_JPRB,3.7878E-03_JPRB/)  
KBO( :,28, 5) = (/&
 & 2.5051E-03_JPRB,2.6547E-03_JPRB,2.8145E-03_JPRB,2.9821E-03_JPRB,3.1545E-03_JPRB/)  
KBO( :,29, 5) = (/&
 & 2.0801E-03_JPRB,2.2062E-03_JPRB,2.3413E-03_JPRB,2.4808E-03_JPRB,2.6265E-03_JPRB/)  
KBO( :,30, 5) = (/&
 & 1.7263E-03_JPRB,1.8332E-03_JPRB,1.9470E-03_JPRB,2.0638E-03_JPRB,2.1862E-03_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB10:PART3',1,ZHOOK_HANDLE)
END SUBROUTINE PART3


SUBROUTINE PART4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB10:PART4',0,ZHOOK_HANDLE)


KBO( :,31, 5) = (/&
 & 1.4306E-03_JPRB,1.5217E-03_JPRB,1.6165E-03_JPRB,1.7146E-03_JPRB,1.8178E-03_JPRB/)  
KBO( :,32, 5) = (/&
 & 1.1879E-03_JPRB,1.2650E-03_JPRB,1.3439E-03_JPRB,1.4268E-03_JPRB,1.5142E-03_JPRB/)  
KBO( :,33, 5) = (/&
 & 9.8791E-04_JPRB,1.0524E-03_JPRB,1.1186E-03_JPRB,1.1891E-03_JPRB,1.2634E-03_JPRB/)  
KBO( :,34, 5) = (/&
 & 8.2253E-04_JPRB,8.7618E-04_JPRB,9.3221E-04_JPRB,9.9230E-04_JPRB,1.0553E-03_JPRB/)  
KBO( :,35, 5) = (/&
 & 6.8111E-04_JPRB,7.2574E-04_JPRB,7.7324E-04_JPRB,8.2413E-04_JPRB,8.7761E-04_JPRB/)  
KBO( :,36, 5) = (/&
 & 5.6044E-04_JPRB,5.9769E-04_JPRB,6.3770E-04_JPRB,6.8068E-04_JPRB,7.2574E-04_JPRB/)  
KBO( :,37, 5) = (/&
 & 4.5897E-04_JPRB,4.9003E-04_JPRB,5.2346E-04_JPRB,5.5953E-04_JPRB,5.9740E-04_JPRB/)  
KBO( :,38, 5) = (/&
 & 3.7569E-04_JPRB,4.0153E-04_JPRB,4.2953E-04_JPRB,4.5975E-04_JPRB,4.9160E-04_JPRB/)  
KBO( :,39, 5) = (/&
 & 3.0744E-04_JPRB,3.2897E-04_JPRB,3.5240E-04_JPRB,3.7773E-04_JPRB,4.0452E-04_JPRB/)  
KBO( :,40, 5) = (/&
 & 2.5088E-04_JPRB,2.6871E-04_JPRB,2.8819E-04_JPRB,3.0931E-04_JPRB,3.3175E-04_JPRB/)  
KBO( :,41, 5) = (/&
 & 2.0462E-04_JPRB,2.1937E-04_JPRB,2.3556E-04_JPRB,2.5314E-04_JPRB,2.7185E-04_JPRB/)  
KBO( :,42, 5) = (/&
 & 1.6686E-04_JPRB,1.7907E-04_JPRB,1.9249E-04_JPRB,2.0708E-04_JPRB,2.2271E-04_JPRB/)  
KBO( :,43, 5) = (/&
 & 1.3590E-04_JPRB,1.4594E-04_JPRB,1.5698E-04_JPRB,1.6901E-04_JPRB,1.8205E-04_JPRB/)  
KBO( :,44, 5) = (/&
 & 1.1067E-04_JPRB,1.1887E-04_JPRB,1.2791E-04_JPRB,1.3780E-04_JPRB,1.4862E-04_JPRB/)  
KBO( :,45, 5) = (/&
 & 9.0208E-05_JPRB,9.6857E-05_JPRB,1.0424E-04_JPRB,1.1235E-04_JPRB,1.2129E-04_JPRB/)  
KBO( :,46, 5) = (/&
 & 7.3529E-05_JPRB,7.8854E-05_JPRB,8.4864E-05_JPRB,9.1484E-05_JPRB,9.8816E-05_JPRB/)  
KBO( :,47, 5) = (/&
 & 6.0013E-05_JPRB,6.4106E-05_JPRB,6.8939E-05_JPRB,7.4314E-05_JPRB,8.0262E-05_JPRB/)  
KBO( :,48, 5) = (/&
 & 4.9475E-05_JPRB,5.2215E-05_JPRB,5.6060E-05_JPRB,6.0396E-05_JPRB,6.5219E-05_JPRB/)  
KBO( :,49, 5) = (/&
 & 4.1161E-05_JPRB,4.2705E-05_JPRB,4.5656E-05_JPRB,4.9133E-05_JPRB,5.3026E-05_JPRB/)  
KBO( :,50, 5) = (/&
 & 3.4418E-05_JPRB,3.5307E-05_JPRB,3.7317E-05_JPRB,4.0090E-05_JPRB,4.3229E-05_JPRB/)  
KBO( :,51, 5) = (/&
 & 2.8922E-05_JPRB,2.9472E-05_JPRB,3.0638E-05_JPRB,3.2797E-05_JPRB,3.5318E-05_JPRB/)  
KBO( :,52, 5) = (/&
 & 2.4424E-05_JPRB,2.4734E-05_JPRB,2.5383E-05_JPRB,2.6898E-05_JPRB,2.8901E-05_JPRB/)  
KBO( :,53, 5) = (/&
 & 2.0598E-05_JPRB,2.0869E-05_JPRB,2.1258E-05_JPRB,2.2148E-05_JPRB,2.3706E-05_JPRB/)  
KBO( :,54, 5) = (/&
 & 1.7186E-05_JPRB,1.7712E-05_JPRB,1.7923E-05_JPRB,1.8433E-05_JPRB,1.9552E-05_JPRB/)  
KBO( :,55, 5) = (/&
 & 1.4224E-05_JPRB,1.5080E-05_JPRB,1.5208E-05_JPRB,1.5518E-05_JPRB,1.6207E-05_JPRB/)  
KBO( :,56, 5) = (/&
 & 1.1740E-05_JPRB,1.2734E-05_JPRB,1.2993E-05_JPRB,1.3155E-05_JPRB,1.3546E-05_JPRB/)  
KBO( :,57, 5) = (/&
 & 9.7276E-06_JPRB,1.0657E-05_JPRB,1.1168E-05_JPRB,1.1239E-05_JPRB,1.1467E-05_JPRB/)  
KBO( :,58, 5) = (/&
 & 8.1077E-06_JPRB,8.9005E-06_JPRB,9.5538E-06_JPRB,9.6723E-06_JPRB,9.7928E-06_JPRB/)  
KBO( :,59, 5) = (/&
 & 6.8383E-06_JPRB,7.5009E-06_JPRB,8.1193E-06_JPRB,8.2851E-06_JPRB,8.3569E-06_JPRB/)  
KBO( :,13, 6) = (/&
 & 7.7444E-02_JPRB,8.2236E-02_JPRB,8.7838E-02_JPRB,9.3753E-02_JPRB,9.9786E-02_JPRB/)  
KBO( :,14, 6) = (/&
 & 6.5845E-02_JPRB,7.0239E-02_JPRB,7.5214E-02_JPRB,8.0372E-02_JPRB,8.5713E-02_JPRB/)  
KBO( :,15, 6) = (/&
 & 5.5227E-02_JPRB,5.9200E-02_JPRB,6.3504E-02_JPRB,6.7983E-02_JPRB,7.2630E-02_JPRB/)  
KBO( :,16, 6) = (/&
 & 4.5844E-02_JPRB,4.9349E-02_JPRB,5.3056E-02_JPRB,5.6921E-02_JPRB,6.0814E-02_JPRB/)  
KBO( :,17, 6) = (/&
 & 3.7783E-02_JPRB,4.0819E-02_JPRB,4.4007E-02_JPRB,4.7268E-02_JPRB,5.0508E-02_JPRB/)  
KBO( :,18, 6) = (/&
 & 3.0896E-02_JPRB,3.3488E-02_JPRB,3.6191E-02_JPRB,3.8886E-02_JPRB,4.1550E-02_JPRB/)  
KBO( :,19, 6) = (/&
 & 2.5364E-02_JPRB,2.7572E-02_JPRB,2.9829E-02_JPRB,3.2058E-02_JPRB,3.4260E-02_JPRB/)  
KBO( :,20, 6) = (/&
 & 2.1100E-02_JPRB,2.2979E-02_JPRB,2.4877E-02_JPRB,2.6754E-02_JPRB,2.8602E-02_JPRB/)  
KBO( :,21, 6) = (/&
 & 1.7607E-02_JPRB,1.9203E-02_JPRB,2.0798E-02_JPRB,2.2390E-02_JPRB,2.3916E-02_JPRB/)  
KBO( :,22, 6) = (/&
 & 1.4783E-02_JPRB,1.6131E-02_JPRB,1.7478E-02_JPRB,1.8806E-02_JPRB,2.0049E-02_JPRB/)  
KBO( :,23, 6) = (/&
 & 1.2411E-02_JPRB,1.3542E-02_JPRB,1.4674E-02_JPRB,1.5762E-02_JPRB,1.6774E-02_JPRB/)  
KBO( :,24, 6) = (/&
 & 1.0438E-02_JPRB,1.1384E-02_JPRB,1.2322E-02_JPRB,1.3209E-02_JPRB,1.4046E-02_JPRB/)  
KBO( :,25, 6) = (/&
 & 8.7842E-03_JPRB,9.5736E-03_JPRB,1.0349E-02_JPRB,1.1074E-02_JPRB,1.1769E-02_JPRB/)  
KBO( :,26, 6) = (/&
 & 7.4110E-03_JPRB,8.0713E-03_JPRB,8.7058E-03_JPRB,9.3054E-03_JPRB,9.8871E-03_JPRB/)  
KBO( :,27, 6) = (/&
 & 6.2558E-03_JPRB,6.8061E-03_JPRB,7.3256E-03_JPRB,7.8243E-03_JPRB,8.3130E-03_JPRB/)  
KBO( :,28, 6) = (/&
 & 5.2801E-03_JPRB,5.7341E-03_JPRB,6.1638E-03_JPRB,6.5800E-03_JPRB,6.9900E-03_JPRB/)  
KBO( :,29, 6) = (/&
 & 4.4527E-03_JPRB,4.8252E-03_JPRB,5.1813E-03_JPRB,5.5298E-03_JPRB,5.8731E-03_JPRB/)  
KBO( :,30, 6) = (/&
 & 3.7503E-03_JPRB,4.0566E-03_JPRB,4.3519E-03_JPRB,4.6440E-03_JPRB,4.9327E-03_JPRB/)  
KBO( :,31, 6) = (/&
 & 3.1521E-03_JPRB,3.4037E-03_JPRB,3.6510E-03_JPRB,3.8964E-03_JPRB,4.1394E-03_JPRB/)  
KBO( :,32, 6) = (/&
 & 2.6499E-03_JPRB,2.8587E-03_JPRB,3.0669E-03_JPRB,3.2733E-03_JPRB,3.4804E-03_JPRB/)  
KBO( :,33, 6) = (/&
 & 2.2285E-03_JPRB,2.4036E-03_JPRB,2.5790E-03_JPRB,2.7532E-03_JPRB,2.9305E-03_JPRB/)  
KBO( :,34, 6) = (/&
 & 1.8728E-03_JPRB,2.0206E-03_JPRB,2.1684E-03_JPRB,2.3169E-03_JPRB,2.4685E-03_JPRB/)  
KBO( :,35, 6) = (/&
 & 1.5635E-03_JPRB,1.6884E-03_JPRB,1.8131E-03_JPRB,1.9393E-03_JPRB,2.0686E-03_JPRB/)  
KBO( :,36, 6) = (/&
 & 1.2949E-03_JPRB,1.4000E-03_JPRB,1.5055E-03_JPRB,1.6126E-03_JPRB,1.7231E-03_JPRB/)  
KBO( :,37, 6) = (/&
 & 1.0650E-03_JPRB,1.1540E-03_JPRB,1.2435E-03_JPRB,1.3349E-03_JPRB,1.4294E-03_JPRB/)  
KBO( :,38, 6) = (/&
 & 8.7519E-04_JPRB,9.5059E-04_JPRB,1.0265E-03_JPRB,1.1043E-03_JPRB,1.1854E-03_JPRB/)  
KBO( :,39, 6) = (/&
 & 7.1904E-04_JPRB,7.8281E-04_JPRB,8.4716E-04_JPRB,9.1345E-04_JPRB,9.8297E-04_JPRB/)  
KBO( :,40, 6) = (/&
 & 5.8756E-04_JPRB,6.4152E-04_JPRB,6.9608E-04_JPRB,7.5269E-04_JPRB,8.1218E-04_JPRB/)  
KBO( :,41, 6) = (/&
 & 4.7943E-04_JPRB,5.2501E-04_JPRB,5.7132E-04_JPRB,6.1957E-04_JPRB,6.7045E-04_JPRB/)  
KBO( :,42, 6) = (/&
 & 3.9089E-04_JPRB,4.2934E-04_JPRB,4.6858E-04_JPRB,5.0963E-04_JPRB,5.5304E-04_JPRB/)  
KBO( :,43, 6) = (/&
 & 3.1717E-04_JPRB,3.4955E-04_JPRB,3.8275E-04_JPRB,4.1759E-04_JPRB,4.5458E-04_JPRB/)  
KBO( :,44, 6) = (/&
 & 2.5660E-04_JPRB,2.8381E-04_JPRB,3.1180E-04_JPRB,3.4130E-04_JPRB,3.7266E-04_JPRB/)  
KBO( :,45, 6) = (/&
 & 2.0734E-04_JPRB,2.3011E-04_JPRB,2.5370E-04_JPRB,2.7860E-04_JPRB,3.0513E-04_JPRB/)  
KBO( :,46, 6) = (/&
 & 1.6698E-04_JPRB,1.8599E-04_JPRB,2.0575E-04_JPRB,2.2669E-04_JPRB,2.4909E-04_JPRB/)  
KBO( :,47, 6) = (/&
 & 1.3369E-04_JPRB,1.4948E-04_JPRB,1.6598E-04_JPRB,1.8350E-04_JPRB,2.0231E-04_JPRB/)  
KBO( :,48, 6) = (/&
 & 1.0692E-04_JPRB,1.1997E-04_JPRB,1.3372E-04_JPRB,1.4834E-04_JPRB,1.6409E-04_JPRB/)  
KBO( :,49, 6) = (/&
 & 8.5441E-05_JPRB,9.6159E-05_JPRB,1.0757E-04_JPRB,1.1975E-04_JPRB,1.3290E-04_JPRB/)  
KBO( :,50, 6) = (/&
 & 6.8463E-05_JPRB,7.7220E-05_JPRB,8.6669E-05_JPRB,9.6779E-05_JPRB,1.0774E-04_JPRB/)  
KBO( :,51, 6) = (/&
 & 5.4963E-05_JPRB,6.2053E-05_JPRB,6.9849E-05_JPRB,7.8222E-05_JPRB,8.7346E-05_JPRB/)  
KBO( :,52, 6) = (/&
 & 4.4218E-05_JPRB,4.9878E-05_JPRB,5.6264E-05_JPRB,6.3175E-05_JPRB,7.0755E-05_JPRB/)  
KBO( :,53, 6) = (/&
 & 3.5855E-05_JPRB,4.0139E-05_JPRB,4.5314E-05_JPRB,5.0998E-05_JPRB,5.7267E-05_JPRB/)  
KBO( :,54, 6) = (/&
 & 2.9695E-05_JPRB,3.2492E-05_JPRB,3.6654E-05_JPRB,4.1299E-05_JPRB,4.6492E-05_JPRB/)  
KBO( :,55, 6) = (/&
 & 2.5066E-05_JPRB,2.6500E-05_JPRB,2.9735E-05_JPRB,3.3517E-05_JPRB,3.7804E-05_JPRB/)  
KBO( :,56, 6) = (/&
 & 2.1455E-05_JPRB,2.1969E-05_JPRB,2.4192E-05_JPRB,2.7229E-05_JPRB,3.0752E-05_JPRB/)  
KBO( :,57, 6) = (/&
 & 1.8563E-05_JPRB,1.8584E-05_JPRB,1.9785E-05_JPRB,2.2171E-05_JPRB,2.5035E-05_JPRB/)  
KBO( :,58, 6) = (/&
 & 1.6189E-05_JPRB,1.5969E-05_JPRB,1.6446E-05_JPRB,1.8150E-05_JPRB,2.0451E-05_JPRB/)  
KBO( :,59, 6) = (/&
 & 1.3883E-05_JPRB,1.3701E-05_JPRB,1.3912E-05_JPRB,1.5148E-05_JPRB,1.7050E-05_JPRB/)  
KBO( :,13, 7) = (/&
 & 1.5712E-01_JPRB,1.7077E-01_JPRB,1.8355E-01_JPRB,1.9563E-01_JPRB,2.0695E-01_JPRB/)  
KBO( :,14, 7) = (/&
 & 1.3457E-01_JPRB,1.4585E-01_JPRB,1.5670E-01_JPRB,1.6701E-01_JPRB,1.7684E-01_JPRB/)  
KBO( :,15, 7) = (/&
 & 1.1408E-01_JPRB,1.2355E-01_JPRB,1.3267E-01_JPRB,1.4142E-01_JPRB,1.5007E-01_JPRB/)  
KBO( :,16, 7) = (/&
 & 9.6177E-02_JPRB,1.0414E-01_JPRB,1.1181E-01_JPRB,1.1927E-01_JPRB,1.2686E-01_JPRB/)  
KBO( :,17, 7) = (/&
 & 8.0695E-02_JPRB,8.7374E-02_JPRB,9.3807E-02_JPRB,1.0015E-01_JPRB,1.0671E-01_JPRB/)  
KBO( :,18, 7) = (/&
 & 6.7227E-02_JPRB,7.2774E-02_JPRB,7.8173E-02_JPRB,8.3614E-02_JPRB,8.9191E-02_JPRB/)  
KBO( :,19, 7) = (/&
 & 5.5951E-02_JPRB,6.0594E-02_JPRB,6.5183E-02_JPRB,6.9851E-02_JPRB,7.4565E-02_JPRB/)  
KBO( :,20, 7) = (/&
 & 4.7003E-02_JPRB,5.0964E-02_JPRB,5.4960E-02_JPRB,5.9008E-02_JPRB,6.3089E-02_JPRB/)  
KBO( :,21, 7) = (/&
 & 3.9571E-02_JPRB,4.2979E-02_JPRB,4.6449E-02_JPRB,4.9946E-02_JPRB,5.3508E-02_JPRB/)  
KBO( :,22, 7) = (/&
 & 3.3519E-02_JPRB,3.6474E-02_JPRB,3.9467E-02_JPRB,4.2489E-02_JPRB,4.5580E-02_JPRB/)  
KBO( :,23, 7) = (/&
 & 2.8427E-02_JPRB,3.0972E-02_JPRB,3.3547E-02_JPRB,3.6170E-02_JPRB,3.8855E-02_JPRB/)  
KBO( :,24, 7) = (/&
 & 2.4149E-02_JPRB,2.6342E-02_JPRB,2.8570E-02_JPRB,3.0859E-02_JPRB,3.3200E-02_JPRB/)  
KBO( :,25, 7) = (/&
 & 2.0558E-02_JPRB,2.2456E-02_JPRB,2.4392E-02_JPRB,2.6381E-02_JPRB,2.8422E-02_JPRB/)  
KBO( :,26, 7) = (/&
 & 1.7573E-02_JPRB,1.9221E-02_JPRB,2.0907E-02_JPRB,2.2636E-02_JPRB,2.4397E-02_JPRB/)  
KBO( :,27, 7) = (/&
 & 1.5044E-02_JPRB,1.6466E-02_JPRB,1.7926E-02_JPRB,1.9419E-02_JPRB,2.0934E-02_JPRB/)  
KBO( :,28, 7) = (/&
 & 1.2886E-02_JPRB,1.4109E-02_JPRB,1.5370E-02_JPRB,1.6664E-02_JPRB,1.7968E-02_JPRB/)  
KBO( :,29, 7) = (/&
 & 1.1030E-02_JPRB,1.2088E-02_JPRB,1.3180E-02_JPRB,1.4300E-02_JPRB,1.5425E-02_JPRB/)  
KBO( :,30, 7) = (/&
 & 9.4386E-03_JPRB,1.0357E-02_JPRB,1.1303E-02_JPRB,1.2268E-02_JPRB,1.3245E-02_JPRB/)  
KBO( :,31, 7) = (/&
 & 8.0733E-03_JPRB,8.8677E-03_JPRB,9.6883E-03_JPRB,1.0518E-02_JPRB,1.1366E-02_JPRB/)  
KBO( :,32, 7) = (/&
 & 6.9177E-03_JPRB,7.6069E-03_JPRB,8.3126E-03_JPRB,9.0312E-03_JPRB,9.7643E-03_JPRB/)  
KBO( :,33, 7) = (/&
 & 5.9333E-03_JPRB,6.5312E-03_JPRB,7.1390E-03_JPRB,7.7622E-03_JPRB,8.3990E-03_JPRB/)  
KBO( :,34, 7) = (/&
 & 5.0834E-03_JPRB,5.6003E-03_JPRB,6.1274E-03_JPRB,6.6689E-03_JPRB,7.2266E-03_JPRB/)  
KBO( :,35, 7) = (/&
 & 4.3170E-03_JPRB,4.7611E-03_JPRB,5.2173E-03_JPRB,5.6888E-03_JPRB,6.1769E-03_JPRB/)  
KBO( :,36, 7) = (/&
 & 3.6248E-03_JPRB,4.0060E-03_JPRB,4.3997E-03_JPRB,4.8092E-03_JPRB,5.2371E-03_JPRB/)  
KBO( :,37, 7) = (/&
 & 3.0276E-03_JPRB,3.3587E-03_JPRB,3.7027E-03_JPRB,4.0632E-03_JPRB,4.4411E-03_JPRB/)  
KBO( :,38, 7) = (/&
 & 2.5258E-03_JPRB,2.8131E-03_JPRB,3.1144E-03_JPRB,3.4319E-03_JPRB,3.7659E-03_JPRB/)  
KBO( :,39, 7) = (/&
 & 2.1056E-03_JPRB,2.3549E-03_JPRB,2.6188E-03_JPRB,2.8979E-03_JPRB,3.1925E-03_JPRB/)  
KBO( :,40, 7) = (/&
 & 1.7476E-03_JPRB,1.9653E-03_JPRB,2.1979E-03_JPRB,2.4447E-03_JPRB,2.7070E-03_JPRB/)  
KBO( :,41, 7) = (/&
 & 1.4476E-03_JPRB,1.6380E-03_JPRB,1.8422E-03_JPRB,2.0603E-03_JPRB,2.2939E-03_JPRB/)  
KBO( :,42, 7) = (/&
 & 1.1969E-03_JPRB,1.3628E-03_JPRB,1.5418E-03_JPRB,1.7341E-03_JPRB,1.9416E-03_JPRB/)  
KBO( :,43, 7) = (/&
 & 9.8263E-04_JPRB,1.1265E-03_JPRB,1.2827E-03_JPRB,1.4514E-03_JPRB,1.6351E-03_JPRB/)  
KBO( :,44, 7) = (/&
 & 8.0249E-04_JPRB,9.2668E-04_JPRB,1.0625E-03_JPRB,1.2096E-03_JPRB,1.3707E-03_JPRB/)  
KBO( :,45, 7) = (/&
 & 6.5298E-04_JPRB,7.5994E-04_JPRB,8.7728E-04_JPRB,1.0055E-03_JPRB,1.1461E-03_JPRB/)  
KBO( :,46, 7) = (/&
 & 5.2766E-04_JPRB,6.1908E-04_JPRB,7.1997E-04_JPRB,8.3119E-04_JPRB,9.5370E-04_JPRB/)  
KBO( :,47, 7) = (/&
 & 4.2190E-04_JPRB,4.9924E-04_JPRB,5.8514E-04_JPRB,6.8083E-04_JPRB,7.8680E-04_JPRB/)  
KBO( :,48, 7) = (/&
 & 3.3585E-04_JPRB,4.0081E-04_JPRB,4.7372E-04_JPRB,5.5558E-04_JPRB,6.4689E-04_JPRB/)  
KBO( :,49, 7) = (/&
 & 2.6612E-04_JPRB,3.2038E-04_JPRB,3.8190E-04_JPRB,4.5171E-04_JPRB,5.3004E-04_JPRB/)  
KBO( :,50, 7) = (/&
 & 2.1101E-04_JPRB,2.5616E-04_JPRB,3.0801E-04_JPRB,3.6730E-04_JPRB,4.3443E-04_JPRB/)  
KBO( :,51, 7) = (/&
 & 1.6702E-04_JPRB,2.0440E-04_JPRB,2.4803E-04_JPRB,2.9825E-04_JPRB,3.5552E-04_JPRB/)  
KBO( :,52, 7) = (/&
 & 1.3173E-04_JPRB,1.6253E-04_JPRB,1.9899E-04_JPRB,2.4139E-04_JPRB,2.9010E-04_JPRB/)  
KBO( :,53, 7) = (/&
 & 1.0353E-04_JPRB,1.2873E-04_JPRB,1.5900E-04_JPRB,1.9462E-04_JPRB,2.3588E-04_JPRB/)  
KBO( :,54, 7) = (/&
 & 8.1672E-05_JPRB,1.0229E-04_JPRB,1.2738E-04_JPRB,1.5734E-04_JPRB,1.9225E-04_JPRB/)  
KBO( :,55, 7) = (/&
 & 6.4500E-05_JPRB,8.1316E-05_JPRB,1.0205E-04_JPRB,1.2719E-04_JPRB,1.5669E-04_JPRB/)  
KBO( :,56, 7) = (/&
 & 5.0893E-05_JPRB,6.4506E-05_JPRB,8.1571E-05_JPRB,1.0252E-04_JPRB,1.2738E-04_JPRB/)  
KBO( :,57, 7) = (/&
 & 4.0182E-05_JPRB,5.1082E-05_JPRB,6.5020E-05_JPRB,8.2415E-05_JPRB,1.0329E-04_JPRB/)  
KBO( :,58, 7) = (/&
 & 3.1954E-05_JPRB,4.0565E-05_JPRB,5.1914E-05_JPRB,6.6302E-05_JPRB,8.3823E-05_JPRB/)  
KBO( :,59, 7) = (/&
 & 2.6572E-05_JPRB,3.3591E-05_JPRB,4.3211E-05_JPRB,5.5528E-05_JPRB,7.0676E-05_JPRB/)  
KBO( :,13, 8) = (/&
 & 4.4787E-01_JPRB,4.9751E-01_JPRB,5.4470E-01_JPRB,5.8862E-01_JPRB,6.2908E-01_JPRB/)  
KBO( :,14, 8) = (/&
 & 3.8445E-01_JPRB,4.2715E-01_JPRB,4.6742E-01_JPRB,5.0464E-01_JPRB,5.3938E-01_JPRB/)  
KBO( :,15, 8) = (/&
 & 3.2779E-01_JPRB,3.6397E-01_JPRB,3.9785E-01_JPRB,4.2935E-01_JPRB,4.5890E-01_JPRB/)  
KBO( :,16, 8) = (/&
 & 2.7790E-01_JPRB,3.0790E-01_JPRB,3.3600E-01_JPRB,3.6256E-01_JPRB,3.8746E-01_JPRB/)  
KBO( :,17, 8) = (/&
 & 2.3458E-01_JPRB,2.5937E-01_JPRB,2.8268E-01_JPRB,3.0493E-01_JPRB,3.2595E-01_JPRB/)  
KBO( :,18, 8) = (/&
 & 1.9764E-01_JPRB,2.1801E-01_JPRB,2.3742E-01_JPRB,2.5590E-01_JPRB,2.7378E-01_JPRB/)  
KBO( :,19, 8) = (/&
 & 1.6729E-01_JPRB,1.8411E-01_JPRB,2.0019E-01_JPRB,2.1556E-01_JPRB,2.3089E-01_JPRB/)  
KBO( :,20, 8) = (/&
 & 1.4346E-01_JPRB,1.5764E-01_JPRB,1.7106E-01_JPRB,1.8428E-01_JPRB,1.9747E-01_JPRB/)  
KBO( :,21, 8) = (/&
 & 1.2344E-01_JPRB,1.3538E-01_JPRB,1.4684E-01_JPRB,1.5826E-01_JPRB,1.6972E-01_JPRB/)  
KBO( :,22, 8) = (/&
 & 1.0677E-01_JPRB,1.1691E-01_JPRB,1.2686E-01_JPRB,1.3681E-01_JPRB,1.4681E-01_JPRB/)  
KBO( :,23, 8) = (/&
 & 9.2153E-02_JPRB,1.0099E-01_JPRB,1.0971E-01_JPRB,1.1847E-01_JPRB,1.2717E-01_JPRB/)  
KBO( :,24, 8) = (/&
 & 7.9606E-02_JPRB,8.7367E-02_JPRB,9.5083E-02_JPRB,1.0275E-01_JPRB,1.1037E-01_JPRB/)  
KBO( :,25, 8) = (/&
 & 6.8847E-02_JPRB,7.5684E-02_JPRB,8.2485E-02_JPRB,8.9220E-02_JPRB,9.5941E-02_JPRB/)  
KBO( :,26, 8) = (/&
 & 5.9776E-02_JPRB,6.5803E-02_JPRB,7.1776E-02_JPRB,7.7759E-02_JPRB,8.3752E-02_JPRB/)  
KBO( :,27, 8) = (/&
 & 5.1998E-02_JPRB,5.7305E-02_JPRB,6.2592E-02_JPRB,6.7931E-02_JPRB,7.3284E-02_JPRB/)  
KBO( :,28, 8) = (/&
 & 4.5335E-02_JPRB,5.0017E-02_JPRB,5.4715E-02_JPRB,5.9468E-02_JPRB,6.4255E-02_JPRB/)  
KBO( :,29, 8) = (/&
 & 3.9576E-02_JPRB,4.3721E-02_JPRB,4.7903E-02_JPRB,5.2114E-02_JPRB,5.6419E-02_JPRB/)  
KBO( :,30, 8) = (/&
 & 3.4575E-02_JPRB,3.8250E-02_JPRB,4.1958E-02_JPRB,4.5723E-02_JPRB,4.9573E-02_JPRB/)  
KBO( :,31, 8) = (/&
 & 3.0216E-02_JPRB,3.3461E-02_JPRB,3.6737E-02_JPRB,4.0102E-02_JPRB,4.3522E-02_JPRB/)  
KBO( :,32, 8) = (/&
 & 2.6463E-02_JPRB,2.9325E-02_JPRB,3.2235E-02_JPRB,3.5225E-02_JPRB,3.8255E-02_JPRB/)  
KBO( :,33, 8) = (/&
 & 2.3214E-02_JPRB,2.5730E-02_JPRB,2.8315E-02_JPRB,3.0956E-02_JPRB,3.3645E-02_JPRB/)  
KBO( :,34, 8) = (/&
 & 2.0354E-02_JPRB,2.2577E-02_JPRB,2.4858E-02_JPRB,2.7195E-02_JPRB,2.9569E-02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB10:PART4',1,ZHOOK_HANDLE)
END SUBROUTINE PART4


SUBROUTINE PART5

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB10:PART5',0,ZHOOK_HANDLE)


KBO( :,35, 8) = (/&
 & 1.7652E-02_JPRB,1.9611E-02_JPRB,2.1620E-02_JPRB,2.3679E-02_JPRB,2.5793E-02_JPRB/)  
KBO( :,36, 8) = (/&
 & 1.5121E-02_JPRB,1.6837E-02_JPRB,1.8603E-02_JPRB,2.0413E-02_JPRB,2.2284E-02_JPRB/)  
KBO( :,37, 8) = (/&
 & 1.2910E-02_JPRB,1.4438E-02_JPRB,1.6023E-02_JPRB,1.7651E-02_JPRB,1.9335E-02_JPRB/)  
KBO( :,38, 8) = (/&
 & 1.1016E-02_JPRB,1.2377E-02_JPRB,1.3800E-02_JPRB,1.5264E-02_JPRB,1.6785E-02_JPRB/)  
KBO( :,39, 8) = (/&
 & 9.3971E-03_JPRB,1.0610E-02_JPRB,1.1882E-02_JPRB,1.3195E-02_JPRB,1.4575E-02_JPRB/)  
KBO( :,40, 8) = (/&
 & 8.0032E-03_JPRB,9.0996E-03_JPRB,1.0249E-02_JPRB,1.1449E-02_JPRB,1.2715E-02_JPRB/)  
KBO( :,41, 8) = (/&
 & 6.8143E-03_JPRB,7.8019E-03_JPRB,8.8465E-03_JPRB,9.9478E-03_JPRB,1.1108E-02_JPRB/)  
KBO( :,42, 8) = (/&
 & 5.7987E-03_JPRB,6.6880E-03_JPRB,7.6360E-03_JPRB,8.6473E-03_JPRB,9.7138E-03_JPRB/)  
KBO( :,43, 8) = (/&
 & 4.9102E-03_JPRB,5.7128E-03_JPRB,6.5767E-03_JPRB,7.5054E-03_JPRB,8.4907E-03_JPRB/)  
KBO( :,44, 8) = (/&
 & 4.1435E-03_JPRB,4.8687E-03_JPRB,5.6557E-03_JPRB,6.5117E-03_JPRB,7.4261E-03_JPRB/)  
KBO( :,45, 8) = (/&
 & 3.4889E-03_JPRB,4.1453E-03_JPRB,4.8619E-03_JPRB,5.6491E-03_JPRB,6.4985E-03_JPRB/)  
KBO( :,46, 8) = (/&
 & 2.9183E-03_JPRB,3.5111E-03_JPRB,4.1627E-03_JPRB,4.8843E-03_JPRB,5.6717E-03_JPRB/)  
KBO( :,47, 8) = (/&
 & 2.4091E-03_JPRB,2.9412E-03_JPRB,3.5329E-03_JPRB,4.1906E-03_JPRB,4.9179E-03_JPRB/)  
KBO( :,48, 8) = (/&
 & 1.9761E-03_JPRB,2.4516E-03_JPRB,2.9867E-03_JPRB,3.5873E-03_JPRB,4.2592E-03_JPRB/)  
KBO( :,49, 8) = (/&
 & 1.6100E-03_JPRB,2.0311E-03_JPRB,2.5133E-03_JPRB,3.0616E-03_JPRB,3.6821E-03_JPRB/)  
KBO( :,50, 8) = (/&
 & 1.3098E-03_JPRB,1.6814E-03_JPRB,2.1143E-03_JPRB,2.6145E-03_JPRB,3.1877E-03_JPRB/)  
KBO( :,51, 8) = (/&
 & 1.0616E-03_JPRB,1.3873E-03_JPRB,1.7732E-03_JPRB,2.2275E-03_JPRB,2.7552E-03_JPRB/)  
KBO( :,52, 8) = (/&
 & 8.5431E-04_JPRB,1.1375E-03_JPRB,1.4802E-03_JPRB,1.8899E-03_JPRB,2.3744E-03_JPRB/)  
KBO( :,53, 8) = (/&
 & 6.8250E-04_JPRB,9.2625E-04_JPRB,1.2281E-03_JPRB,1.5967E-03_JPRB,2.0393E-03_JPRB/)  
KBO( :,54, 8) = (/&
 & 5.4646E-04_JPRB,7.5582E-04_JPRB,1.0218E-03_JPRB,1.3535E-03_JPRB,1.7581E-03_JPRB/)  
KBO( :,55, 8) = (/&
 & 4.3631E-04_JPRB,6.1609E-04_JPRB,8.4963E-04_JPRB,1.1470E-03_JPRB,1.5165E-03_JPRB/)  
KBO( :,56, 8) = (/&
 & 3.4597E-04_JPRB,4.9939E-04_JPRB,7.0303E-04_JPRB,9.6849E-04_JPRB,1.3045E-03_JPRB/)  
KBO( :,57, 8) = (/&
 & 2.7231E-04_JPRB,4.0225E-04_JPRB,5.7843E-04_JPRB,8.1401E-04_JPRB,1.1188E-03_JPRB/)  
KBO( :,58, 8) = (/&
 & 2.1404E-04_JPRB,3.2388E-04_JPRB,4.7635E-04_JPRB,6.8490E-04_JPRB,9.6152E-04_JPRB/)  
KBO( :,59, 8) = (/&
 & 1.8077E-04_JPRB,2.7867E-04_JPRB,4.1775E-04_JPRB,6.1150E-04_JPRB,8.7266E-04_JPRB/)  
KBO( :,13, 9) = (/&
 & 2.7435E+00_JPRB,3.0906E+00_JPRB,3.4108E+00_JPRB,3.6982E+00_JPRB,3.9627E+00_JPRB/)  
KBO( :,14, 9) = (/&
 & 2.3802E+00_JPRB,2.6705E+00_JPRB,2.9382E+00_JPRB,3.1823E+00_JPRB,3.4042E+00_JPRB/)  
KBO( :,15, 9) = (/&
 & 2.0515E+00_JPRB,2.2949E+00_JPRB,2.5214E+00_JPRB,2.7256E+00_JPRB,2.9082E+00_JPRB/)  
KBO( :,16, 9) = (/&
 & 1.7616E+00_JPRB,1.9678E+00_JPRB,2.1547E+00_JPRB,2.3237E+00_JPRB,2.4783E+00_JPRB/)  
KBO( :,17, 9) = (/&
 & 1.5089E+00_JPRB,1.6786E+00_JPRB,1.8334E+00_JPRB,1.9756E+00_JPRB,2.1052E+00_JPRB/)  
KBO( :,18, 9) = (/&
 & 1.2832E+00_JPRB,1.4238E+00_JPRB,1.5536E+00_JPRB,1.6726E+00_JPRB,1.7800E+00_JPRB/)  
KBO( :,19, 9) = (/&
 & 1.0879E+00_JPRB,1.2054E+00_JPRB,1.3138E+00_JPRB,1.4118E+00_JPRB,1.5002E+00_JPRB/)  
KBO( :,20, 9) = (/&
 & 9.2520E-01_JPRB,1.0230E+00_JPRB,1.1126E+00_JPRB,1.1933E+00_JPRB,1.2674E+00_JPRB/)  
KBO( :,21, 9) = (/&
 & 7.8791E-01_JPRB,8.6885E-01_JPRB,9.4260E-01_JPRB,1.0104E+00_JPRB,1.0727E+00_JPRB/)  
KBO( :,22, 9) = (/&
 & 6.7633E-01_JPRB,7.4273E-01_JPRB,8.0382E-01_JPRB,8.6005E-01_JPRB,9.1295E-01_JPRB/)  
KBO( :,23, 9) = (/&
 & 5.8122E-01_JPRB,6.3601E-01_JPRB,6.8664E-01_JPRB,7.3416E-01_JPRB,7.7931E-01_JPRB/)  
KBO( :,24, 9) = (/&
 & 5.0026E-01_JPRB,5.4576E-01_JPRB,5.8810E-01_JPRB,6.2834E-01_JPRB,6.6798E-01_JPRB/)  
KBO( :,25, 9) = (/&
 & 4.3213E-01_JPRB,4.6996E-01_JPRB,5.0587E-01_JPRB,5.4068E-01_JPRB,5.7579E-01_JPRB/)  
KBO( :,26, 9) = (/&
 & 3.7530E-01_JPRB,4.0715E-01_JPRB,4.3791E-01_JPRB,4.6854E-01_JPRB,5.0040E-01_JPRB/)  
KBO( :,27, 9) = (/&
 & 3.2720E-01_JPRB,3.5436E-01_JPRB,3.8108E-01_JPRB,4.0857E-01_JPRB,4.3759E-01_JPRB/)  
KBO( :,28, 9) = (/&
 & 2.8625E-01_JPRB,3.0981E-01_JPRB,3.3353E-01_JPRB,3.5864E-01_JPRB,3.8484E-01_JPRB/)  
KBO( :,29, 9) = (/&
 & 2.5143E-01_JPRB,2.7201E-01_JPRB,2.9352E-01_JPRB,3.1618E-01_JPRB,3.4020E-01_JPRB/)  
KBO( :,30, 9) = (/&
 & 2.2172E-01_JPRB,2.4013E-01_JPRB,2.5952E-01_JPRB,2.8016E-01_JPRB,3.0172E-01_JPRB/)  
KBO( :,31, 9) = (/&
 & 1.9610E-01_JPRB,2.1281E-01_JPRB,2.3037E-01_JPRB,2.4895E-01_JPRB,2.6850E-01_JPRB/)  
KBO( :,32, 9) = (/&
 & 1.7415E-01_JPRB,1.8930E-01_JPRB,2.0532E-01_JPRB,2.2216E-01_JPRB,2.3994E-01_JPRB/)  
KBO( :,33, 9) = (/&
 & 1.5516E-01_JPRB,1.6907E-01_JPRB,1.8355E-01_JPRB,1.9888E-01_JPRB,2.1515E-01_JPRB/)  
KBO( :,34, 9) = (/&
 & 1.3857E-01_JPRB,1.5131E-01_JPRB,1.6462E-01_JPRB,1.7854E-01_JPRB,1.9347E-01_JPRB/)  
KBO( :,35, 9) = (/&
 & 1.2324E-01_JPRB,1.3480E-01_JPRB,1.4696E-01_JPRB,1.5978E-01_JPRB,1.7337E-01_JPRB/)  
KBO( :,36, 9) = (/&
 & 1.0878E-01_JPRB,1.1937E-01_JPRB,1.3043E-01_JPRB,1.4217E-01_JPRB,1.5452E-01_JPRB/)  
KBO( :,37, 9) = (/&
 & 9.5776E-02_JPRB,1.0563E-01_JPRB,1.1583E-01_JPRB,1.2665E-01_JPRB,1.3805E-01_JPRB/)  
KBO( :,38, 9) = (/&
 & 8.4466E-02_JPRB,9.3612E-02_JPRB,1.0315E-01_JPRB,1.1317E-01_JPRB,1.2370E-01_JPRB/)  
KBO( :,39, 9) = (/&
 & 7.4614E-02_JPRB,8.3124E-02_JPRB,9.2043E-02_JPRB,1.0145E-01_JPRB,1.1118E-01_JPRB/)  
KBO( :,40, 9) = (/&
 & 6.5857E-02_JPRB,7.3870E-02_JPRB,8.2261E-02_JPRB,9.1193E-02_JPRB,1.0040E-01_JPRB/)  
KBO( :,41, 9) = (/&
 & 5.8183E-02_JPRB,6.5774E-02_JPRB,7.3720E-02_JPRB,8.2197E-02_JPRB,9.1007E-02_JPRB/)  
KBO( :,42, 9) = (/&
 & 5.1461E-02_JPRB,5.8649E-02_JPRB,6.6221E-02_JPRB,7.4278E-02_JPRB,8.2751E-02_JPRB/)  
KBO( :,43, 9) = (/&
 & 4.5392E-02_JPRB,5.2200E-02_JPRB,5.9437E-02_JPRB,6.7121E-02_JPRB,7.5296E-02_JPRB/)  
KBO( :,44, 9) = (/&
 & 4.0017E-02_JPRB,4.6452E-02_JPRB,5.3355E-02_JPRB,6.0754E-02_JPRB,6.8643E-02_JPRB/)  
KBO( :,45, 9) = (/&
 & 3.5304E-02_JPRB,4.1396E-02_JPRB,4.7987E-02_JPRB,5.5092E-02_JPRB,6.2720E-02_JPRB/)  
KBO( :,46, 9) = (/&
 & 3.1075E-02_JPRB,3.6822E-02_JPRB,4.3097E-02_JPRB,4.9898E-02_JPRB,5.7283E-02_JPRB/)  
KBO( :,47, 9) = (/&
 & 2.7177E-02_JPRB,3.2558E-02_JPRB,3.8513E-02_JPRB,4.5021E-02_JPRB,5.2127E-02_JPRB/)  
KBO( :,48, 9) = (/&
 & 2.3744E-02_JPRB,2.8781E-02_JPRB,3.4434E-02_JPRB,4.0680E-02_JPRB,4.7484E-02_JPRB/)  
KBO( :,49, 9) = (/&
 & 2.0728E-02_JPRB,2.5421E-02_JPRB,3.0794E-02_JPRB,3.6770E-02_JPRB,4.3357E-02_JPRB/)  
KBO( :,50, 9) = (/&
 & 1.8168E-02_JPRB,2.2568E-02_JPRB,2.7658E-02_JPRB,3.3413E-02_JPRB,3.9781E-02_JPRB/)  
KBO( :,51, 9) = (/&
 & 1.5961E-02_JPRB,2.0091E-02_JPRB,2.4921E-02_JPRB,3.0460E-02_JPRB,3.6640E-02_JPRB/)  
KBO( :,52, 9) = (/&
 & 1.4012E-02_JPRB,1.7898E-02_JPRB,2.2474E-02_JPRB,2.7799E-02_JPRB,3.3804E-02_JPRB/)  
KBO( :,53, 9) = (/&
 & 1.2274E-02_JPRB,1.5954E-02_JPRB,2.0286E-02_JPRB,2.5396E-02_JPRB,3.1223E-02_JPRB/)  
KBO( :,54, 9) = (/&
 & 1.0807E-02_JPRB,1.4326E-02_JPRB,1.8466E-02_JPRB,2.3375E-02_JPRB,2.9075E-02_JPRB/)  
KBO( :,55, 9) = (/&
 & 9.5319E-03_JPRB,1.2915E-02_JPRB,1.6895E-02_JPRB,2.1632E-02_JPRB,2.7210E-02_JPRB/)  
KBO( :,56, 9) = (/&
 & 8.3912E-03_JPRB,1.1632E-02_JPRB,1.5477E-02_JPRB,2.0079E-02_JPRB,2.5547E-02_JPRB/)  
KBO( :,57, 9) = (/&
 & 7.3723E-03_JPRB,1.0474E-02_JPRB,1.4207E-02_JPRB,1.8687E-02_JPRB,2.4063E-02_JPRB/)  
KBO( :,58, 9) = (/&
 & 6.4991E-03_JPRB,9.4761E-03_JPRB,1.3112E-02_JPRB,1.7511E-02_JPRB,2.2815E-02_JPRB/)  
KBO( :,59, 9) = (/&
 & 6.1473E-03_JPRB,9.1090E-03_JPRB,1.2767E-02_JPRB,1.7218E-02_JPRB,2.2606E-02_JPRB/)  
KBO( :,13,10) = (/&
 & 1.1116E+01_JPRB,1.2524E+01_JPRB,1.3896E+01_JPRB,1.5268E+01_JPRB,1.6536E+01_JPRB/)  
KBO( :,14,10) = (/&
 & 9.9682E+00_JPRB,1.1262E+01_JPRB,1.2560E+01_JPRB,1.3723E+01_JPRB,1.4792E+01_JPRB/)  
KBO( :,15,10) = (/&
 & 8.8893E+00_JPRB,1.0059E+01_JPRB,1.1121E+01_JPRB,1.2116E+01_JPRB,1.3075E+01_JPRB/)  
KBO( :,16,10) = (/&
 & 7.8467E+00_JPRB,8.8032E+00_JPRB,9.7316E+00_JPRB,1.0625E+01_JPRB,1.1425E+01_JPRB/)  
KBO( :,17,10) = (/&
 & 6.8078E+00_JPRB,7.6463E+00_JPRB,8.4707E+00_JPRB,9.1981E+00_JPRB,9.8604E+00_JPRB/)  
KBO( :,18,10) = (/&
 & 5.9071E+00_JPRB,6.6462E+00_JPRB,7.3087E+00_JPRB,7.9162E+00_JPRB,8.4956E+00_JPRB/)  
KBO( :,19,10) = (/&
 & 5.1307E+00_JPRB,5.7208E+00_JPRB,6.2833E+00_JPRB,6.8158E+00_JPRB,7.3233E+00_JPRB/)  
KBO( :,20,10) = (/&
 & 4.4064E+00_JPRB,4.9086E+00_JPRB,5.4011E+00_JPRB,5.8668E+00_JPRB,6.2919E+00_JPRB/)  
KBO( :,21,10) = (/&
 & 3.7746E+00_JPRB,4.2108E+00_JPRB,4.6377E+00_JPRB,5.0222E+00_JPRB,5.3698E+00_JPRB/)  
KBO( :,22,10) = (/&
 & 3.2585E+00_JPRB,3.6369E+00_JPRB,3.9831E+00_JPRB,4.2976E+00_JPRB,4.5905E+00_JPRB/)  
KBO( :,23,10) = (/&
 & 2.8213E+00_JPRB,3.1329E+00_JPRB,3.4129E+00_JPRB,3.6764E+00_JPRB,3.9234E+00_JPRB/)  
KBO( :,24,10) = (/&
 & 2.4431E+00_JPRB,2.6958E+00_JPRB,2.9321E+00_JPRB,3.1552E+00_JPRB,3.3597E+00_JPRB/)  
KBO( :,25,10) = (/&
 & 2.1126E+00_JPRB,2.3241E+00_JPRB,2.5221E+00_JPRB,2.7073E+00_JPRB,2.8751E+00_JPRB/)  
KBO( :,26,10) = (/&
 & 1.8249E+00_JPRB,2.0037E+00_JPRB,2.1706E+00_JPRB,2.3266E+00_JPRB,2.4674E+00_JPRB/)  
KBO( :,27,10) = (/&
 & 1.5746E+00_JPRB,1.7247E+00_JPRB,1.8648E+00_JPRB,1.9941E+00_JPRB,2.1217E+00_JPRB/)  
KBO( :,28,10) = (/&
 & 1.3617E+00_JPRB,1.4866E+00_JPRB,1.6031E+00_JPRB,1.7154E+00_JPRB,1.8338E+00_JPRB/)  
KBO( :,29,10) = (/&
 & 1.1807E+00_JPRB,1.2866E+00_JPRB,1.3847E+00_JPRB,1.4869E+00_JPRB,1.6014E+00_JPRB/)  
KBO( :,30,10) = (/&
 & 1.0269E+00_JPRB,1.1156E+00_JPRB,1.2031E+00_JPRB,1.3007E+00_JPRB,1.4104E+00_JPRB/)  
KBO( :,31,10) = (/&
 & 8.9671E-01_JPRB,9.7234E-01_JPRB,1.0534E+00_JPRB,1.1474E+00_JPRB,1.2536E+00_JPRB/)  
KBO( :,32,10) = (/&
 & 7.8677E-01_JPRB,8.5519E-01_JPRB,9.3281E-01_JPRB,1.0217E+00_JPRB,1.1241E+00_JPRB/)  
KBO( :,33,10) = (/&
 & 6.9580E-01_JPRB,7.5947E-01_JPRB,8.3338E-01_JPRB,9.2124E-01_JPRB,1.0172E+00_JPRB/)  
KBO( :,34,10) = (/&
 & 6.2020E-01_JPRB,6.7933E-01_JPRB,7.4919E-01_JPRB,8.3240E-01_JPRB,9.2556E-01_JPRB/)  
KBO( :,35,10) = (/&
 & 5.5258E-01_JPRB,6.0746E-01_JPRB,6.7338E-01_JPRB,7.4935E-01_JPRB,8.3904E-01_JPRB/)  
KBO( :,36,10) = (/&
 & 4.9155E-01_JPRB,5.4163E-01_JPRB,6.0187E-01_JPRB,6.7186E-01_JPRB,7.5578E-01_JPRB/)  
KBO( :,37,10) = (/&
 & 4.3530E-01_JPRB,4.8026E-01_JPRB,5.3386E-01_JPRB,5.9737E-01_JPRB,6.7325E-01_JPRB/)  
KBO( :,38,10) = (/&
 & 3.8752E-01_JPRB,4.2820E-01_JPRB,4.7540E-01_JPRB,5.3327E-01_JPRB,6.0315E-01_JPRB/)  
KBO( :,39,10) = (/&
 & 3.4711E-01_JPRB,3.8416E-01_JPRB,4.2683E-01_JPRB,4.7819E-01_JPRB,5.4308E-01_JPRB/)  
KBO( :,40,10) = (/&
 & 3.1156E-01_JPRB,3.4469E-01_JPRB,3.8303E-01_JPRB,4.2846E-01_JPRB,4.8625E-01_JPRB/)  
KBO( :,41,10) = (/&
 & 2.8072E-01_JPRB,3.1142E-01_JPRB,3.4605E-01_JPRB,3.8706E-01_JPRB,4.3793E-01_JPRB/)  
KBO( :,42,10) = (/&
 & 2.5421E-01_JPRB,2.8301E-01_JPRB,3.1501E-01_JPRB,3.5201E-01_JPRB,3.9774E-01_JPRB/)  
KBO( :,43,10) = (/&
 & 2.3024E-01_JPRB,2.5750E-01_JPRB,2.8768E-01_JPRB,3.2168E-01_JPRB,3.6246E-01_JPRB/)  
KBO( :,44,10) = (/&
 & 2.0882E-01_JPRB,2.3454E-01_JPRB,2.6350E-01_JPRB,2.9554E-01_JPRB,3.3285E-01_JPRB/)  
KBO( :,45,10) = (/&
 & 1.8997E-01_JPRB,2.1445E-01_JPRB,2.4251E-01_JPRB,2.7313E-01_JPRB,3.0812E-01_JPRB/)  
KBO( :,46,10) = (/&
 & 1.7240E-01_JPRB,1.9626E-01_JPRB,2.2342E-01_JPRB,2.5309E-01_JPRB,2.8552E-01_JPRB/)  
KBO( :,47,10) = (/&
 & 1.5588E-01_JPRB,1.7894E-01_JPRB,2.0504E-01_JPRB,2.3411E-01_JPRB,2.6565E-01_JPRB/)  
KBO( :,48,10) = (/&
 & 1.4123E-01_JPRB,1.6344E-01_JPRB,1.8846E-01_JPRB,2.1670E-01_JPRB,2.4797E-01_JPRB/)  
KBO( :,49,10) = (/&
 & 1.2790E-01_JPRB,1.4966E-01_JPRB,1.7367E-01_JPRB,2.0107E-01_JPRB,2.3131E-01_JPRB/)  
KBO( :,50,10) = (/&
 & 1.1631E-01_JPRB,1.3796E-01_JPRB,1.6097E-01_JPRB,1.8742E-01_JPRB,2.1727E-01_JPRB/)  
KBO( :,51,10) = (/&
 & 1.0575E-01_JPRB,1.2733E-01_JPRB,1.4991E-01_JPRB,1.7544E-01_JPRB,2.0476E-01_JPRB/)  
KBO( :,52,10) = (/&
 & 9.6036E-02_JPRB,1.1774E-01_JPRB,1.4002E-01_JPRB,1.6481E-01_JPRB,1.9345E-01_JPRB/)  
KBO( :,53,10) = (/&
 & 8.7304E-02_JPRB,1.0881E-01_JPRB,1.3107E-01_JPRB,1.5527E-01_JPRB,1.8336E-01_JPRB/)  
KBO( :,54,10) = (/&
 & 7.9875E-02_JPRB,1.0109E-01_JPRB,1.2361E-01_JPRB,1.4762E-01_JPRB,1.7497E-01_JPRB/)  
KBO( :,55,10) = (/&
 & 7.3300E-02_JPRB,9.4374E-02_JPRB,1.1713E-01_JPRB,1.4114E-01_JPRB,1.6800E-01_JPRB/)  
KBO( :,56,10) = (/&
 & 6.7351E-02_JPRB,8.8262E-02_JPRB,1.1132E-01_JPRB,1.3535E-01_JPRB,1.6204E-01_JPRB/)  
KBO( :,57,10) = (/&
 & 6.1746E-02_JPRB,8.2507E-02_JPRB,1.0564E-01_JPRB,1.3036E-01_JPRB,1.5696E-01_JPRB/)  
KBO( :,58,10) = (/&
 & 5.6716E-02_JPRB,7.7524E-02_JPRB,1.0086E-01_JPRB,1.2629E-01_JPRB,1.5285E-01_JPRB/)  
KBO( :,59,10) = (/&
 & 5.5147E-02_JPRB,7.6460E-02_JPRB,1.0042E-01_JPRB,1.2667E-01_JPRB,1.5391E-01_JPRB/)  
KBO( :,13,11) = (/&
 & 1.8957E+01_JPRB,2.1748E+01_JPRB,2.4276E+01_JPRB,2.6474E+01_JPRB,2.8529E+01_JPRB/)  
KBO( :,14,11) = (/&
 & 1.8017E+01_JPRB,2.0380E+01_JPRB,2.2545E+01_JPRB,2.4583E+01_JPRB,2.6571E+01_JPRB/)  
KBO( :,15,11) = (/&
 & 1.6510E+01_JPRB,1.8590E+01_JPRB,2.0569E+01_JPRB,2.2529E+01_JPRB,2.4350E+01_JPRB/)  
KBO( :,16,11) = (/&
 & 1.4872E+01_JPRB,1.6760E+01_JPRB,1.8614E+01_JPRB,2.0335E+01_JPRB,2.1912E+01_JPRB/)  
KBO( :,17,11) = (/&
 & 1.3279E+01_JPRB,1.4995E+01_JPRB,1.6568E+01_JPRB,1.8053E+01_JPRB,1.9485E+01_JPRB/)  
KBO( :,18,11) = (/&
 & 1.1753E+01_JPRB,1.3179E+01_JPRB,1.4580E+01_JPRB,1.5907E+01_JPRB,1.7114E+01_JPRB/)  
KBO( :,19,11) = (/&
 & 1.0231E+01_JPRB,1.1513E+01_JPRB,1.2740E+01_JPRB,1.3859E+01_JPRB,1.4884E+01_JPRB/)  
KBO( :,20,11) = (/&
 & 8.9451E+00_JPRB,1.0050E+01_JPRB,1.1073E+01_JPRB,1.1999E+01_JPRB,1.2912E+01_JPRB/)  
KBO( :,21,11) = (/&
 & 7.7987E+00_JPRB,8.7082E+00_JPRB,9.5625E+00_JPRB,1.0395E+01_JPRB,1.1226E+01_JPRB/)  
KBO( :,22,11) = (/&
 & 6.8043E+00_JPRB,7.5642E+00_JPRB,8.3187E+00_JPRB,9.0767E+00_JPRB,9.8017E+00_JPRB/)  
KBO( :,23,11) = (/&
 & 5.8859E+00_JPRB,6.5615E+00_JPRB,7.2498E+00_JPRB,7.9149E+00_JPRB,8.5372E+00_JPRB/)  
KBO( :,24,11) = (/&
 & 5.1134E+00_JPRB,5.7222E+00_JPRB,6.3175E+00_JPRB,6.8808E+00_JPRB,7.4024E+00_JPRB/)  
KBO( :,25,11) = (/&
 & 4.4669E+00_JPRB,4.9952E+00_JPRB,5.4997E+00_JPRB,5.9652E+00_JPRB,6.4204E+00_JPRB/)  
KBO( :,26,11) = (/&
 & 3.9220E+00_JPRB,4.3661E+00_JPRB,4.7791E+00_JPRB,5.1780E+00_JPRB,5.5750E+00_JPRB/)  
KBO( :,27,11) = (/&
 & 3.4424E+00_JPRB,3.8118E+00_JPRB,4.1663E+00_JPRB,4.5195E+00_JPRB,4.8555E+00_JPRB/)  
KBO( :,28,11) = (/&
 & 3.0179E+00_JPRB,3.3339E+00_JPRB,3.6464E+00_JPRB,3.9515E+00_JPRB,4.2432E+00_JPRB/)  
KBO( :,29,11) = (/&
 & 2.6509E+00_JPRB,2.9253E+00_JPRB,3.1964E+00_JPRB,3.4617E+00_JPRB,3.7117E+00_JPRB/)  
KBO( :,30,11) = (/&
 & 2.3307E+00_JPRB,2.5742E+00_JPRB,2.8104E+00_JPRB,3.0372E+00_JPRB,3.2705E+00_JPRB/)  
KBO( :,31,11) = (/&
 & 2.0517E+00_JPRB,2.2676E+00_JPRB,2.4784E+00_JPRB,2.6845E+00_JPRB,2.9117E+00_JPRB/)  
KBO( :,32,11) = (/&
 & 1.8127E+00_JPRB,2.0021E+00_JPRB,2.1892E+00_JPRB,2.3933E+00_JPRB,2.6228E+00_JPRB/)  
KBO( :,33,11) = (/&
 & 1.6070E+00_JPRB,1.7736E+00_JPRB,1.9506E+00_JPRB,2.1502E+00_JPRB,2.3904E+00_JPRB/)  
KBO( :,34,11) = (/&
 & 1.4245E+00_JPRB,1.5783E+00_JPRB,1.7496E+00_JPRB,1.9501E+00_JPRB,2.1946E+00_JPRB/)  
KBO( :,35,11) = (/&
 & 1.2566E+00_JPRB,1.4023E+00_JPRB,1.5672E+00_JPRB,1.7720E+00_JPRB,2.0104E+00_JPRB/)  
KBO( :,36,11) = (/&
 & 1.1042E+00_JPRB,1.2386E+00_JPRB,1.4007E+00_JPRB,1.6008E+00_JPRB,1.8331E+00_JPRB/)  
KBO( :,37,11) = (/&
 & 9.6207E-01_JPRB,1.0840E+00_JPRB,1.2374E+00_JPRB,1.4256E+00_JPRB,1.6496E+00_JPRB/)  
KBO( :,38,11) = (/&
 & 8.4455E-01_JPRB,9.5449E-01_JPRB,1.0990E+00_JPRB,1.2750E+00_JPRB,1.4911E+00_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB10:PART5',1,ZHOOK_HANDLE)
END SUBROUTINE PART5


SUBROUTINE PART6

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB10:PART6',0,ZHOOK_HANDLE)


KBO( :,39,11) = (/&
 & 7.4626E-01_JPRB,8.4779E-01_JPRB,9.8068E-01_JPRB,1.1482E+00_JPRB,1.3562E+00_JPRB/)  
KBO( :,40,11) = (/&
 & 6.5687E-01_JPRB,7.4696E-01_JPRB,8.6819E-01_JPRB,1.0227E+00_JPRB,1.2185E+00_JPRB/)  
KBO( :,41,11) = (/&
 & 5.8461E-01_JPRB,6.6225E-01_JPRB,7.7143E-01_JPRB,9.1274E-01_JPRB,1.0964E+00_JPRB/)  
KBO( :,42,11) = (/&
 & 5.2648E-01_JPRB,5.9347E-01_JPRB,6.8980E-01_JPRB,8.2031E-01_JPRB,9.9027E-01_JPRB/)  
KBO( :,43,11) = (/&
 & 4.7640E-01_JPRB,5.3372E-01_JPRB,6.1655E-01_JPRB,7.3335E-01_JPRB,8.8864E-01_JPRB/)  
KBO( :,44,11) = (/&
 & 4.3331E-01_JPRB,4.8509E-01_JPRB,5.5515E-01_JPRB,6.5677E-01_JPRB,7.9761E-01_JPRB/)  
KBO( :,45,11) = (/&
 & 3.9738E-01_JPRB,4.4505E-01_JPRB,5.0582E-01_JPRB,5.9392E-01_JPRB,7.1934E-01_JPRB/)  
KBO( :,46,11) = (/&
 & 3.6702E-01_JPRB,4.1005E-01_JPRB,4.6451E-01_JPRB,5.4011E-01_JPRB,6.5038E-01_JPRB/)  
KBO( :,47,11) = (/&
 & 3.3839E-01_JPRB,3.7909E-01_JPRB,4.2775E-01_JPRB,4.9390E-01_JPRB,5.8796E-01_JPRB/)  
KBO( :,48,11) = (/&
 & 3.1214E-01_JPRB,3.5328E-01_JPRB,3.9721E-01_JPRB,4.5625E-01_JPRB,5.3740E-01_JPRB/)  
KBO( :,49,11) = (/&
 & 2.8824E-01_JPRB,3.3045E-01_JPRB,3.7202E-01_JPRB,4.2475E-01_JPRB,4.9686E-01_JPRB/)  
KBO( :,50,11) = (/&
 & 2.6700E-01_JPRB,3.0926E-01_JPRB,3.5179E-01_JPRB,3.9959E-01_JPRB,4.6448E-01_JPRB/)  
KBO( :,51,11) = (/&
 & 2.4729E-01_JPRB,2.9050E-01_JPRB,3.3394E-01_JPRB,3.7954E-01_JPRB,4.3852E-01_JPRB/)  
KBO( :,52,11) = (/&
 & 2.2915E-01_JPRB,2.7331E-01_JPRB,3.1717E-01_JPRB,3.6223E-01_JPRB,4.1654E-01_JPRB/)  
KBO( :,53,11) = (/&
 & 2.1197E-01_JPRB,2.5644E-01_JPRB,3.0181E-01_JPRB,3.4764E-01_JPRB,3.9788E-01_JPRB/)  
KBO( :,54,11) = (/&
 & 1.9678E-01_JPRB,2.4209E-01_JPRB,2.8845E-01_JPRB,3.3563E-01_JPRB,3.8416E-01_JPRB/)  
KBO( :,55,11) = (/&
 & 1.8279E-01_JPRB,2.2890E-01_JPRB,2.7659E-01_JPRB,3.2457E-01_JPRB,3.7331E-01_JPRB/)  
KBO( :,56,11) = (/&
 & 1.6948E-01_JPRB,2.1660E-01_JPRB,2.6478E-01_JPRB,3.1391E-01_JPRB,3.6327E-01_JPRB/)  
KBO( :,57,11) = (/&
 & 1.5665E-01_JPRB,2.0505E-01_JPRB,2.5378E-01_JPRB,3.0423E-01_JPRB,3.5431E-01_JPRB/)  
KBO( :,58,11) = (/&
 & 1.4542E-01_JPRB,1.9412E-01_JPRB,2.4425E-01_JPRB,2.9539E-01_JPRB,3.4713E-01_JPRB/)  
KBO( :,59,11) = (/&
 & 1.4258E-01_JPRB,1.9210E-01_JPRB,2.4323E-01_JPRB,2.9526E-01_JPRB,3.4821E-01_JPRB/)  
KBO( :,13,12) = (/&
 & 3.3441E+01_JPRB,3.7821E+01_JPRB,4.2136E+01_JPRB,4.6394E+01_JPRB,5.0550E+01_JPRB/)  
KBO( :,14,12) = (/&
 & 3.2651E+01_JPRB,3.7152E+01_JPRB,4.1595E+01_JPRB,4.5890E+01_JPRB,4.9879E+01_JPRB/)  
KBO( :,15,12) = (/&
 & 3.1800E+01_JPRB,3.6293E+01_JPRB,4.0605E+01_JPRB,4.4452E+01_JPRB,4.7952E+01_JPRB/)  
KBO( :,16,12) = (/&
 & 3.0652E+01_JPRB,3.4834E+01_JPRB,3.8488E+01_JPRB,4.1902E+01_JPRB,4.5172E+01_JPRB/)  
KBO( :,17,12) = (/&
 & 2.8740E+01_JPRB,3.2239E+01_JPRB,3.5631E+01_JPRB,3.8859E+01_JPRB,4.1888E+01_JPRB/)  
KBO( :,18,12) = (/&
 & 2.6152E+01_JPRB,2.9383E+01_JPRB,3.2433E+01_JPRB,3.5444E+01_JPRB,3.8304E+01_JPRB/)  
KBO( :,19,12) = (/&
 & 2.3535E+01_JPRB,2.6428E+01_JPRB,2.9253E+01_JPRB,3.1986E+01_JPRB,3.4626E+01_JPRB/)  
KBO( :,20,12) = (/&
 & 2.1009E+01_JPRB,2.3665E+01_JPRB,2.6170E+01_JPRB,2.8648E+01_JPRB,3.1009E+01_JPRB/)  
KBO( :,21,12) = (/&
 & 1.8666E+01_JPRB,2.0970E+01_JPRB,2.3240E+01_JPRB,2.5449E+01_JPRB,2.7590E+01_JPRB/)  
KBO( :,22,12) = (/&
 & 1.6562E+01_JPRB,1.8637E+01_JPRB,2.0680E+01_JPRB,2.2664E+01_JPRB,2.4579E+01_JPRB/)  
KBO( :,23,12) = (/&
 & 1.4724E+01_JPRB,1.6583E+01_JPRB,1.8398E+01_JPRB,2.0130E+01_JPRB,2.1853E+01_JPRB/)  
KBO( :,24,12) = (/&
 & 1.3115E+01_JPRB,1.4740E+01_JPRB,1.6306E+01_JPRB,1.7839E+01_JPRB,1.9442E+01_JPRB/)  
KBO( :,25,12) = (/&
 & 1.1682E+01_JPRB,1.3060E+01_JPRB,1.4446E+01_JPRB,1.5890E+01_JPRB,1.7412E+01_JPRB/)  
KBO( :,26,12) = (/&
 & 1.0376E+01_JPRB,1.1606E+01_JPRB,1.2912E+01_JPRB,1.4282E+01_JPRB,1.5708E+01_JPRB/)  
KBO( :,27,12) = (/&
 & 9.2264E+00_JPRB,1.0375E+01_JPRB,1.1611E+01_JPRB,1.2892E+01_JPRB,1.4269E+01_JPRB/)  
KBO( :,28,12) = (/&
 & 8.2384E+00_JPRB,9.3278E+00_JPRB,1.0501E+01_JPRB,1.1713E+01_JPRB,1.3001E+01_JPRB/)  
KBO( :,29,12) = (/&
 & 7.4191E+00_JPRB,8.4528E+00_JPRB,9.5480E+00_JPRB,1.0688E+01_JPRB,1.1930E+01_JPRB/)  
KBO( :,30,12) = (/&
 & 6.7411E+00_JPRB,7.6959E+00_JPRB,8.7238E+00_JPRB,9.8332E+00_JPRB,1.1024E+01_JPRB/)  
KBO( :,31,12) = (/&
 & 6.1743E+00_JPRB,7.0565E+00_JPRB,8.0433E+00_JPRB,9.1146E+00_JPRB,1.0281E+01_JPRB/)  
KBO( :,32,12) = (/&
 & 5.6829E+00_JPRB,6.5368E+00_JPRB,7.4832E+00_JPRB,8.5285E+00_JPRB,9.6975E+00_JPRB/)  
KBO( :,33,12) = (/&
 & 5.2696E+00_JPRB,6.1016E+00_JPRB,7.0284E+00_JPRB,8.0819E+00_JPRB,9.2712E+00_JPRB/)  
KBO( :,34,12) = (/&
 & 4.9064E+00_JPRB,5.7181E+00_JPRB,6.6470E+00_JPRB,7.7097E+00_JPRB,8.9376E+00_JPRB/)  
KBO( :,35,12) = (/&
 & 4.5385E+00_JPRB,5.3339E+00_JPRB,6.2645E+00_JPRB,7.3393E+00_JPRB,8.6167E+00_JPRB/)  
KBO( :,36,12) = (/&
 & 4.1592E+00_JPRB,4.9372E+00_JPRB,5.8640E+00_JPRB,6.9463E+00_JPRB,8.2444E+00_JPRB/)  
KBO( :,37,12) = (/&
 & 3.7366E+00_JPRB,4.4851E+00_JPRB,5.3891E+00_JPRB,6.4562E+00_JPRB,7.7447E+00_JPRB/)  
KBO( :,38,12) = (/&
 & 3.3663E+00_JPRB,4.0921E+00_JPRB,4.9726E+00_JPRB,6.0256E+00_JPRB,7.2966E+00_JPRB/)  
KBO( :,39,12) = (/&
 & 3.0524E+00_JPRB,3.7541E+00_JPRB,4.6132E+00_JPRB,5.6531E+00_JPRB,6.9025E+00_JPRB/)  
KBO( :,40,12) = (/&
 & 2.7210E+00_JPRB,3.3890E+00_JPRB,4.2060E+00_JPRB,5.2106E+00_JPRB,6.4181E+00_JPRB/)  
KBO( :,41,12) = (/&
 & 2.4254E+00_JPRB,3.0563E+00_JPRB,3.8366E+00_JPRB,4.7969E+00_JPRB,5.9597E+00_JPRB/)  
KBO( :,42,12) = (/&
 & 2.1679E+00_JPRB,2.7607E+00_JPRB,3.5045E+00_JPRB,4.4213E+00_JPRB,5.5422E+00_JPRB/)  
KBO( :,43,12) = (/&
 & 1.9142E+00_JPRB,2.4659E+00_JPRB,3.1656E+00_JPRB,4.0260E+00_JPRB,5.0928E+00_JPRB/)  
KBO( :,44,12) = (/&
 & 1.6815E+00_JPRB,2.1897E+00_JPRB,2.8396E+00_JPRB,3.6424E+00_JPRB,4.6457E+00_JPRB/)  
KBO( :,45,12) = (/&
 & 1.4779E+00_JPRB,1.9464E+00_JPRB,2.5447E+00_JPRB,3.2950E+00_JPRB,4.2351E+00_JPRB/)  
KBO( :,46,12) = (/&
 & 1.2911E+00_JPRB,1.7201E+00_JPRB,2.2670E+00_JPRB,2.9688E+00_JPRB,3.8370E+00_JPRB/)  
KBO( :,47,12) = (/&
 & 1.1167E+00_JPRB,1.4998E+00_JPRB,1.9968E+00_JPRB,2.6327E+00_JPRB,3.4335E+00_JPRB/)  
KBO( :,48,12) = (/&
 & 9.7000E-01_JPRB,1.3056E+00_JPRB,1.7582E+00_JPRB,2.3318E+00_JPRB,3.0672E+00_JPRB/)  
KBO( :,49,12) = (/&
 & 8.4948E-01_JPRB,1.1387E+00_JPRB,1.5440E+00_JPRB,2.0638E+00_JPRB,2.7325E+00_JPRB/)  
KBO( :,50,12) = (/&
 & 7.5798E-01_JPRB,1.0046E+00_JPRB,1.3648E+00_JPRB,1.8406E+00_JPRB,2.4475E+00_JPRB/)  
KBO( :,51,12) = (/&
 & 6.8725E-01_JPRB,8.9444E-01_JPRB,1.2113E+00_JPRB,1.6439E+00_JPRB,2.1974E+00_JPRB/)  
KBO( :,52,12) = (/&
 & 6.3115E-01_JPRB,8.0296E-01_JPRB,1.0776E+00_JPRB,1.4683E+00_JPRB,1.9726E+00_JPRB/)  
KBO( :,53,12) = (/&
 & 5.8219E-01_JPRB,7.2999E-01_JPRB,9.6258E-01_JPRB,1.3098E+00_JPRB,1.7704E+00_JPRB/)  
KBO( :,54,12) = (/&
 & 5.4205E-01_JPRB,6.7503E-01_JPRB,8.7235E-01_JPRB,1.1796E+00_JPRB,1.6017E+00_JPRB/)  
KBO( :,55,12) = (/&
 & 5.0666E-01_JPRB,6.3248E-01_JPRB,8.0079E-01_JPRB,1.0716E+00_JPRB,1.4553E+00_JPRB/)  
KBO( :,56,12) = (/&
 & 4.7570E-01_JPRB,5.9469E-01_JPRB,7.4368E-01_JPRB,9.7802E-01_JPRB,1.3247E+00_JPRB/)  
KBO( :,57,12) = (/&
 & 4.4744E-01_JPRB,5.6112E-01_JPRB,6.9690E-01_JPRB,8.9836E-01_JPRB,1.2094E+00_JPRB/)  
KBO( :,58,12) = (/&
 & 4.2060E-01_JPRB,5.3249E-01_JPRB,6.6124E-01_JPRB,8.3779E-01_JPRB,1.1150E+00_JPRB/)  
KBO( :,59,12) = (/&
 & 4.1336E-01_JPRB,5.2583E-01_JPRB,6.5442E-01_JPRB,8.2324E-01_JPRB,1.0875E+00_JPRB/)  
KBO( :,13,13) = (/&
 & 6.2911E+01_JPRB,7.0866E+01_JPRB,7.8801E+01_JPRB,8.6317E+01_JPRB,9.3133E+01_JPRB/)  
KBO( :,14,13) = (/&
 & 6.4149E+01_JPRB,7.2816E+01_JPRB,8.0994E+01_JPRB,8.8794E+01_JPRB,9.5784E+01_JPRB/)  
KBO( :,15,13) = (/&
 & 6.5438E+01_JPRB,7.4262E+01_JPRB,8.2489E+01_JPRB,9.0124E+01_JPRB,9.7424E+01_JPRB/)  
KBO( :,16,13) = (/&
 & 6.5590E+01_JPRB,7.4146E+01_JPRB,8.2531E+01_JPRB,9.0209E+01_JPRB,9.7706E+01_JPRB/)  
KBO( :,17,13) = (/&
 & 6.4830E+01_JPRB,7.3370E+01_JPRB,8.1573E+01_JPRB,8.9511E+01_JPRB,9.7077E+01_JPRB/)  
KBO( :,18,13) = (/&
 & 6.3631E+01_JPRB,7.1937E+01_JPRB,8.0198E+01_JPRB,8.8105E+01_JPRB,9.5322E+01_JPRB/)  
KBO( :,19,13) = (/&
 & 6.1647E+01_JPRB,6.9823E+01_JPRB,7.7707E+01_JPRB,8.5203E+01_JPRB,9.2333E+01_JPRB/)  
KBO( :,20,13) = (/&
 & 5.9220E+01_JPRB,6.6886E+01_JPRB,7.4459E+01_JPRB,8.1516E+01_JPRB,8.8383E+01_JPRB/)  
KBO( :,21,13) = (/&
 & 5.5943E+01_JPRB,6.3222E+01_JPRB,7.0272E+01_JPRB,7.7027E+01_JPRB,8.3664E+01_JPRB/)  
KBO( :,22,13) = (/&
 & 5.2530E+01_JPRB,5.9289E+01_JPRB,6.5955E+01_JPRB,7.2675E+01_JPRB,7.9278E+01_JPRB/)  
KBO( :,23,13) = (/&
 & 4.8798E+01_JPRB,5.5211E+01_JPRB,6.1705E+01_JPRB,6.8359E+01_JPRB,7.5139E+01_JPRB/)  
KBO( :,24,13) = (/&
 & 4.5161E+01_JPRB,5.1397E+01_JPRB,5.7807E+01_JPRB,6.4502E+01_JPRB,7.1268E+01_JPRB/)  
KBO( :,25,13) = (/&
 & 4.1926E+01_JPRB,4.8095E+01_JPRB,5.4440E+01_JPRB,6.1093E+01_JPRB,6.7734E+01_JPRB/)  
KBO( :,26,13) = (/&
 & 3.9234E+01_JPRB,4.5282E+01_JPRB,5.1559E+01_JPRB,5.8099E+01_JPRB,6.4750E+01_JPRB/)  
KBO( :,27,13) = (/&
 & 3.7014E+01_JPRB,4.2942E+01_JPRB,4.9090E+01_JPRB,5.5651E+01_JPRB,6.2419E+01_JPRB/)  
KBO( :,28,13) = (/&
 & 3.5158E+01_JPRB,4.0969E+01_JPRB,4.7074E+01_JPRB,5.3764E+01_JPRB,6.0756E+01_JPRB/)  
KBO( :,29,13) = (/&
 & 3.3618E+01_JPRB,3.9411E+01_JPRB,4.5654E+01_JPRB,5.2544E+01_JPRB,5.9755E+01_JPRB/)  
KBO( :,30,13) = (/&
 & 3.2426E+01_JPRB,3.8339E+01_JPRB,4.4787E+01_JPRB,5.1833E+01_JPRB,5.9294E+01_JPRB/)  
KBO( :,31,13) = (/&
 & 3.1684E+01_JPRB,3.7780E+01_JPRB,4.4404E+01_JPRB,5.1653E+01_JPRB,5.9352E+01_JPRB/)  
KBO( :,32,13) = (/&
 & 3.1354E+01_JPRB,3.7669E+01_JPRB,4.4512E+01_JPRB,5.1974E+01_JPRB,5.9794E+01_JPRB/)  
KBO( :,33,13) = (/&
 & 3.1431E+01_JPRB,3.7960E+01_JPRB,4.5034E+01_JPRB,5.2659E+01_JPRB,6.0610E+01_JPRB/)  
KBO( :,34,13) = (/&
 & 3.1647E+01_JPRB,3.8355E+01_JPRB,4.5600E+01_JPRB,5.3397E+01_JPRB,6.1465E+01_JPRB/)  
KBO( :,35,13) = (/&
 & 3.1516E+01_JPRB,3.8346E+01_JPRB,4.5688E+01_JPRB,5.3575E+01_JPRB,6.1719E+01_JPRB/)  
KBO( :,36,13) = (/&
 & 3.0864E+01_JPRB,3.7754E+01_JPRB,4.5120E+01_JPRB,5.3052E+01_JPRB,6.1227E+01_JPRB/)  
KBO( :,37,13) = (/&
 & 2.9388E+01_JPRB,3.6192E+01_JPRB,4.3536E+01_JPRB,5.1439E+01_JPRB,5.9606E+01_JPRB/)  
KBO( :,38,13) = (/&
 & 2.7977E+01_JPRB,3.4812E+01_JPRB,4.2002E+01_JPRB,4.9861E+01_JPRB,5.8021E+01_JPRB/)  
KBO( :,39,13) = (/&
 & 2.6681E+01_JPRB,3.3428E+01_JPRB,4.0601E+01_JPRB,4.8374E+01_JPRB,5.6514E+01_JPRB/)  
KBO( :,40,13) = (/&
 & 2.4843E+01_JPRB,3.1428E+01_JPRB,3.8462E+01_JPRB,4.6157E+01_JPRB,5.4241E+01_JPRB/)  
KBO( :,41,13) = (/&
 & 2.3029E+01_JPRB,2.9429E+01_JPRB,3.6318E+01_JPRB,4.3916E+01_JPRB,5.1916E+01_JPRB/)  
KBO( :,42,13) = (/&
 & 2.1319E+01_JPRB,2.7525E+01_JPRB,3.4247E+01_JPRB,4.1738E+01_JPRB,4.9652E+01_JPRB/)  
KBO( :,43,13) = (/&
 & 1.9398E+01_JPRB,2.5350E+01_JPRB,3.1861E+01_JPRB,3.9204E+01_JPRB,4.6981E+01_JPRB/)  
KBO( :,44,13) = (/&
 & 1.7469E+01_JPRB,2.3129E+01_JPRB,2.9410E+01_JPRB,3.6561E+01_JPRB,4.4193E+01_JPRB/)  
KBO( :,45,13) = (/&
 & 1.5674E+01_JPRB,2.1025E+01_JPRB,2.7064E+01_JPRB,3.4000E+01_JPRB,4.1469E+01_JPRB/)  
KBO( :,46,13) = (/&
 & 1.3910E+01_JPRB,1.8921E+01_JPRB,2.4680E+01_JPRB,3.1376E+01_JPRB,3.8606E+01_JPRB/)  
KBO( :,47,13) = (/&
 & 1.2107E+01_JPRB,1.6739E+01_JPRB,2.2157E+01_JPRB,2.8551E+01_JPRB,3.5550E+01_JPRB/)  
KBO( :,48,13) = (/&
 & 1.0467E+01_JPRB,1.4727E+01_JPRB,1.9785E+01_JPRB,2.5861E+01_JPRB,3.2591E+01_JPRB/)  
KBO( :,49,13) = (/&
 & 8.9964E+00_JPRB,1.2871E+01_JPRB,1.7569E+01_JPRB,2.3303E+01_JPRB,2.9748E+01_JPRB/)  
KBO( :,50,13) = (/&
 & 7.7376E+00_JPRB,1.1272E+01_JPRB,1.5632E+01_JPRB,2.1029E+01_JPRB,2.7193E+01_JPRB/)  
KBO( :,51,13) = (/&
 & 6.6259E+00_JPRB,9.8500E+00_JPRB,1.3883E+01_JPRB,1.8950E+01_JPRB,2.4815E+01_JPRB/)  
KBO( :,52,13) = (/&
 & 5.6271E+00_JPRB,8.5555E+00_JPRB,1.2269E+01_JPRB,1.6994E+01_JPRB,2.2544E+01_JPRB/)  
KBO( :,53,13) = (/&
 & 4.7464E+00_JPRB,7.3819E+00_JPRB,1.0780E+01_JPRB,1.5159E+01_JPRB,2.0385E+01_JPRB/)  
KBO( :,54,13) = (/&
 & 4.0353E+00_JPRB,6.3931E+00_JPRB,9.5243E+00_JPRB,1.3591E+01_JPRB,1.8508E+01_JPRB/)  
KBO( :,55,13) = (/&
 & 3.4415E+00_JPRB,5.5338E+00_JPRB,8.4199E+00_JPRB,1.2188E+01_JPRB,1.6812E+01_JPRB/)  
KBO( :,56,13) = (/&
 & 2.9273E+00_JPRB,4.7696E+00_JPRB,7.4019E+00_JPRB,1.0887E+01_JPRB,1.5214E+01_JPRB/)  
KBO( :,57,13) = (/&
 & 2.4891E+00_JPRB,4.0887E+00_JPRB,6.4628E+00_JPRB,9.6770E+00_JPRB,1.3714E+01_JPRB/)  
KBO( :,58,13) = (/&
 & 2.1365E+00_JPRB,3.5240E+00_JPRB,5.6504E+00_JPRB,8.6145E+00_JPRB,1.2383E+01_JPRB/)  
KBO( :,59,13) = (/&
 & 2.0108E+00_JPRB,3.3183E+00_JPRB,5.3478E+00_JPRB,8.2077E+00_JPRB,1.1868E+01_JPRB/)  
KBO( :,13,14) = (/&
 & 1.3475E+02_JPRB,1.4982E+02_JPRB,1.6261E+02_JPRB,1.7487E+02_JPRB,1.8519E+02_JPRB/)  
KBO( :,14,14) = (/&
 & 1.4605E+02_JPRB,1.6065E+02_JPRB,1.7393E+02_JPRB,1.8700E+02_JPRB,1.9852E+02_JPRB/)  
KBO( :,15,14) = (/&
 & 1.5360E+02_JPRB,1.6964E+02_JPRB,1.8495E+02_JPRB,1.9863E+02_JPRB,2.1254E+02_JPRB/)  
KBO( :,16,14) = (/&
 & 1.6093E+02_JPRB,1.7838E+02_JPRB,1.9523E+02_JPRB,2.1044E+02_JPRB,2.2565E+02_JPRB/)  
KBO( :,17,14) = (/&
 & 1.6793E+02_JPRB,1.8625E+02_JPRB,2.0393E+02_JPRB,2.2116E+02_JPRB,2.3675E+02_JPRB/)  
KBO( :,18,14) = (/&
 & 1.7285E+02_JPRB,1.9238E+02_JPRB,2.1120E+02_JPRB,2.2923E+02_JPRB,2.4575E+02_JPRB/)  
KBO( :,19,14) = (/&
 & 1.7622E+02_JPRB,1.9702E+02_JPRB,2.1717E+02_JPRB,2.3603E+02_JPRB,2.5402E+02_JPRB/)  
KBO( :,20,14) = (/&
 & 1.7911E+02_JPRB,2.0088E+02_JPRB,2.2224E+02_JPRB,2.4259E+02_JPRB,2.6154E+02_JPRB/)  
KBO( :,21,14) = (/&
 & 1.8174E+02_JPRB,2.0471E+02_JPRB,2.2728E+02_JPRB,2.4849E+02_JPRB,2.6851E+02_JPRB/)  
KBO( :,22,14) = (/&
 & 1.8638E+02_JPRB,2.1059E+02_JPRB,2.3335E+02_JPRB,2.5504E+02_JPRB,2.7546E+02_JPRB/)  
KBO( :,23,14) = (/&
 & 1.9098E+02_JPRB,2.1549E+02_JPRB,2.3861E+02_JPRB,2.6061E+02_JPRB,2.8131E+02_JPRB/)  
KBO( :,24,14) = (/&
 & 1.9501E+02_JPRB,2.1999E+02_JPRB,2.4340E+02_JPRB,2.6590E+02_JPRB,2.8693E+02_JPRB/)  
KBO( :,25,14) = (/&
 & 1.9819E+02_JPRB,2.2397E+02_JPRB,2.4813E+02_JPRB,2.7104E+02_JPRB,2.9266E+02_JPRB/)  
KBO( :,26,14) = (/&
 & 2.0202E+02_JPRB,2.2842E+02_JPRB,2.5295E+02_JPRB,2.7657E+02_JPRB,2.9876E+02_JPRB/)  
KBO( :,27,14) = (/&
 & 2.0582E+02_JPRB,2.3283E+02_JPRB,2.5800E+02_JPRB,2.8203E+02_JPRB,3.0452E+02_JPRB/)  
KBO( :,28,14) = (/&
 & 2.1022E+02_JPRB,2.3779E+02_JPRB,2.6328E+02_JPRB,2.8767E+02_JPRB,3.1024E+02_JPRB/)  
KBO( :,29,14) = (/&
 & 2.1520E+02_JPRB,2.4340E+02_JPRB,2.6893E+02_JPRB,2.9346E+02_JPRB,3.1620E+02_JPRB/)  
KBO( :,30,14) = (/&
 & 2.2063E+02_JPRB,2.4918E+02_JPRB,2.7482E+02_JPRB,2.9948E+02_JPRB,3.2215E+02_JPRB/)  
KBO( :,31,14) = (/&
 & 2.2657E+02_JPRB,2.5536E+02_JPRB,2.8102E+02_JPRB,3.0571E+02_JPRB,3.2824E+02_JPRB/)  
KBO( :,32,14) = (/&
 & 2.3308E+02_JPRB,2.6187E+02_JPRB,2.8740E+02_JPRB,3.1199E+02_JPRB,3.3425E+02_JPRB/)  
KBO( :,33,14) = (/&
 & 2.3986E+02_JPRB,2.6855E+02_JPRB,2.9383E+02_JPRB,3.1826E+02_JPRB,3.4018E+02_JPRB/)  
KBO( :,34,14) = (/&
 & 2.4577E+02_JPRB,2.7438E+02_JPRB,2.9944E+02_JPRB,3.2357E+02_JPRB,3.4520E+02_JPRB/)  
KBO( :,35,14) = (/&
 & 2.4905E+02_JPRB,2.7766E+02_JPRB,3.0272E+02_JPRB,3.2667E+02_JPRB,3.4817E+02_JPRB/)  
KBO( :,36,14) = (/&
 & 2.4929E+02_JPRB,2.7807E+02_JPRB,3.0324E+02_JPRB,3.2723E+02_JPRB,3.4886E+02_JPRB/)  
KBO( :,37,14) = (/&
 & 2.4523E+02_JPRB,2.7437E+02_JPRB,2.9994E+02_JPRB,3.2429E+02_JPRB,3.4633E+02_JPRB/)  
KBO( :,38,14) = (/&
 & 2.4091E+02_JPRB,2.6959E+02_JPRB,2.9637E+02_JPRB,3.2107E+02_JPRB,3.4355E+02_JPRB/)  
KBO( :,39,14) = (/&
 & 2.3660E+02_JPRB,2.6566E+02_JPRB,2.9263E+02_JPRB,3.1774E+02_JPRB,3.4063E+02_JPRB/)  
KBO( :,40,14) = (/&
 & 2.2919E+02_JPRB,2.5872E+02_JPRB,2.8615E+02_JPRB,3.1182E+02_JPRB,3.3536E+02_JPRB/)  
KBO( :,41,14) = (/&
 & 2.2133E+02_JPRB,2.5130E+02_JPRB,2.7920E+02_JPRB,3.0540E+02_JPRB,3.2953E+02_JPRB/)  
KBO( :,42,14) = (/&
 & 2.1340E+02_JPRB,2.4374E+02_JPRB,2.7207E+02_JPRB,2.9884E+02_JPRB,3.2354E+02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB10:PART6',1,ZHOOK_HANDLE)
END SUBROUTINE PART6


SUBROUTINE PART7

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB10:PART7',0,ZHOOK_HANDLE)


KBO( :,43,14) = (/&
 & 2.0367E+02_JPRB,2.3438E+02_JPRB,2.6323E+02_JPRB,2.9066E+02_JPRB,3.1594E+02_JPRB/)  
KBO( :,44,14) = (/&
 & 1.9308E+02_JPRB,2.2419E+02_JPRB,2.5349E+02_JPRB,2.8159E+02_JPRB,3.0748E+02_JPRB/)  
KBO( :,45,14) = (/&
 & 1.8246E+02_JPRB,2.1385E+02_JPRB,2.4356E+02_JPRB,2.7233E+02_JPRB,2.9882E+02_JPRB/)  
KBO( :,46,14) = (/&
 & 1.7114E+02_JPRB,2.0272E+02_JPRB,2.3288E+02_JPRB,2.6301E+02_JPRB,2.8969E+02_JPRB/)  
KBO( :,47,14) = (/&
 & 1.5855E+02_JPRB,1.9020E+02_JPRB,2.2076E+02_JPRB,2.5136E+02_JPRB,2.7873E+02_JPRB/)  
KBO( :,48,14) = (/&
 & 1.4607E+02_JPRB,1.7757E+02_JPRB,2.0844E+02_JPRB,2.3948E+02_JPRB,2.6744E+02_JPRB/)  
KBO( :,49,14) = (/&
 & 1.3419E+02_JPRB,1.6492E+02_JPRB,1.9597E+02_JPRB,2.2733E+02_JPRB,2.5595E+02_JPRB/)  
KBO( :,50,14) = (/&
 & 1.2262E+02_JPRB,1.5312E+02_JPRB,1.8424E+02_JPRB,2.1573E+02_JPRB,2.4494E+02_JPRB/)  
KBO( :,51,14) = (/&
 & 1.1164E+02_JPRB,1.4176E+02_JPRB,1.7283E+02_JPRB,2.0437E+02_JPRB,2.3409E+02_JPRB/)  
KBO( :,52,14) = (/&
 & 1.0096E+02_JPRB,1.3046E+02_JPRB,1.6140E+02_JPRB,1.9297E+02_JPRB,2.2308E+02_JPRB/)  
KBO( :,53,14) = (/&
 & 9.0551E+01_JPRB,1.1931E+02_JPRB,1.4994E+02_JPRB,1.8152E+02_JPRB,2.1190E+02_JPRB/)  
KBO( :,54,14) = (/&
 & 8.1410E+01_JPRB,1.0953E+02_JPRB,1.3953E+02_JPRB,1.7100E+02_JPRB,2.0156E+02_JPRB/)  
KBO( :,55,14) = (/&
 & 7.2959E+01_JPRB,1.0018E+02_JPRB,1.2955E+02_JPRB,1.6095E+02_JPRB,1.9160E+02_JPRB/)  
KBO( :,56,14) = (/&
 & 6.4819E+01_JPRB,9.1140E+01_JPRB,1.1985E+02_JPRB,1.5098E+02_JPRB,1.8160E+02_JPRB/)  
KBO( :,57,14) = (/&
 & 5.7095E+01_JPRB,8.2366E+01_JPRB,1.1034E+02_JPRB,1.4102E+02_JPRB,1.7160E+02_JPRB/)  
KBO( :,58,14) = (/&
 & 5.0134E+01_JPRB,7.4344E+01_JPRB,1.0153E+02_JPRB,1.3164E+02_JPRB,1.6214E+02_JPRB/)  
KBO( :,59,14) = (/&
 & 4.7470E+01_JPRB,7.1199E+01_JPRB,9.8036E+01_JPRB,1.2792E+02_JPRB,1.5834E+02_JPRB/)  
KBO( :,13,15) = (/&
 & 2.3558E+02_JPRB,2.5344E+02_JPRB,2.7628E+02_JPRB,3.0031E+02_JPRB,3.2250E+02_JPRB/)  
KBO( :,14,15) = (/&
 & 2.7096E+02_JPRB,2.9360E+02_JPRB,3.2037E+02_JPRB,3.4774E+02_JPRB,3.7218E+02_JPRB/)  
KBO( :,15,15) = (/&
 & 3.0994E+02_JPRB,3.4303E+02_JPRB,3.7440E+02_JPRB,3.9962E+02_JPRB,4.2667E+02_JPRB/)  
KBO( :,16,15) = (/&
 & 3.5542E+02_JPRB,3.9314E+02_JPRB,4.2812E+02_JPRB,4.5543E+02_JPRB,4.8444E+02_JPRB/)  
KBO( :,17,15) = (/&
 & 4.0444E+02_JPRB,4.4528E+02_JPRB,4.7841E+02_JPRB,5.1608E+02_JPRB,5.4481E+02_JPRB/)  
KBO( :,18,15) = (/&
 & 4.5639E+02_JPRB,5.0053E+02_JPRB,5.3577E+02_JPRB,5.7622E+02_JPRB,6.0843E+02_JPRB/)  
KBO( :,19,15) = (/&
 & 5.0901E+02_JPRB,5.5503E+02_JPRB,5.9764E+02_JPRB,6.3637E+02_JPRB,6.7067E+02_JPRB/)  
KBO( :,20,15) = (/&
 & 5.6225E+02_JPRB,6.1156E+02_JPRB,6.5621E+02_JPRB,6.9717E+02_JPRB,7.3299E+02_JPRB/)  
KBO( :,21,15) = (/&
 & 6.1341E+02_JPRB,6.6505E+02_JPRB,7.1266E+02_JPRB,7.5506E+02_JPRB,7.9166E+02_JPRB/)  
KBO( :,22,15) = (/&
 & 6.6477E+02_JPRB,7.2026E+02_JPRB,7.6733E+02_JPRB,8.1180E+02_JPRB,8.4941E+02_JPRB/)  
KBO( :,23,15) = (/&
 & 7.1351E+02_JPRB,7.7168E+02_JPRB,8.2016E+02_JPRB,8.6518E+02_JPRB,9.0001E+02_JPRB/)  
KBO( :,24,15) = (/&
 & 7.6064E+02_JPRB,8.2095E+02_JPRB,8.7032E+02_JPRB,9.1500E+02_JPRB,9.4974E+02_JPRB/)  
KBO( :,25,15) = (/&
 & 8.0382E+02_JPRB,8.6818E+02_JPRB,9.1637E+02_JPRB,9.6097E+02_JPRB,9.9482E+02_JPRB/)  
KBO( :,26,15) = (/&
 & 8.4787E+02_JPRB,9.1216E+02_JPRB,9.5982E+02_JPRB,1.0033E+03_JPRB,1.0355E+03_JPRB/)  
KBO( :,27,15) = (/&
 & 8.8962E+02_JPRB,9.5330E+02_JPRB,9.9941E+02_JPRB,1.0412E+03_JPRB,1.0715E+03_JPRB/)  
KBO( :,28,15) = (/&
 & 9.2764E+02_JPRB,9.9055E+02_JPRB,1.0352E+03_JPRB,1.0749E+03_JPRB,1.1028E+03_JPRB/)  
KBO( :,29,15) = (/&
 & 9.6348E+02_JPRB,1.0242E+03_JPRB,1.0673E+03_JPRB,1.1051E+03_JPRB,1.1303E+03_JPRB/)  
KBO( :,30,15) = (/&
 & 9.9639E+02_JPRB,1.0551E+03_JPRB,1.0958E+03_JPRB,1.1311E+03_JPRB,1.1539E+03_JPRB/)  
KBO( :,31,15) = (/&
 & 1.0263E+03_JPRB,1.0827E+03_JPRB,1.1208E+03_JPRB,1.1537E+03_JPRB,1.1744E+03_JPRB/)  
KBO( :,32,15) = (/&
 & 1.0534E+03_JPRB,1.1075E+03_JPRB,1.1431E+03_JPRB,1.1732E+03_JPRB,1.1921E+03_JPRB/)  
KBO( :,33,15) = (/&
 & 1.0779E+03_JPRB,1.1295E+03_JPRB,1.1625E+03_JPRB,1.1902E+03_JPRB,1.2073E+03_JPRB/)  
KBO( :,34,15) = (/&
 & 1.0982E+03_JPRB,1.1477E+03_JPRB,1.1785E+03_JPRB,1.2044E+03_JPRB,1.2197E+03_JPRB/)  
KBO( :,35,15) = (/&
 & 1.1118E+03_JPRB,1.1603E+03_JPRB,1.1896E+03_JPRB,1.2145E+03_JPRB,1.2287E+03_JPRB/)  
KBO( :,36,15) = (/&
 & 1.1191E+03_JPRB,1.1674E+03_JPRB,1.1964E+03_JPRB,1.2211E+03_JPRB,1.2348E+03_JPRB/)  
KBO( :,37,15) = (/&
 & 1.1180E+03_JPRB,1.1678E+03_JPRB,1.1978E+03_JPRB,1.2234E+03_JPRB,1.2378E+03_JPRB/)  
KBO( :,38,15) = (/&
 & 1.1152E+03_JPRB,1.1644E+03_JPRB,1.1974E+03_JPRB,1.2244E+03_JPRB,1.2396E+03_JPRB/)  
KBO( :,39,15) = (/&
 & 1.1116E+03_JPRB,1.1623E+03_JPRB,1.1960E+03_JPRB,1.2249E+03_JPRB,1.2407E+03_JPRB/)  
KBO( :,40,15) = (/&
 & 1.1018E+03_JPRB,1.1551E+03_JPRB,1.1910E+03_JPRB,1.2221E+03_JPRB,1.2391E+03_JPRB/)  
KBO( :,41,15) = (/&
 & 1.0898E+03_JPRB,1.1461E+03_JPRB,1.1848E+03_JPRB,1.2178E+03_JPRB,1.2366E+03_JPRB/)  
KBO( :,42,15) = (/&
 & 1.0762E+03_JPRB,1.1359E+03_JPRB,1.1775E+03_JPRB,1.2126E+03_JPRB,1.2333E+03_JPRB/)  
KBO( :,43,15) = (/&
 & 1.0578E+03_JPRB,1.1216E+03_JPRB,1.1668E+03_JPRB,1.2048E+03_JPRB,1.2281E+03_JPRB/)  
KBO( :,44,15) = (/&
 & 1.0362E+03_JPRB,1.1044E+03_JPRB,1.1534E+03_JPRB,1.1947E+03_JPRB,1.2212E+03_JPRB/)  
KBO( :,45,15) = (/&
 & 1.0130E+03_JPRB,1.0854E+03_JPRB,1.1384E+03_JPRB,1.1833E+03_JPRB,1.2130E+03_JPRB/)  
KBO( :,46,15) = (/&
 & 9.8649E+02_JPRB,1.0633E+03_JPRB,1.1204E+03_JPRB,1.1664E+03_JPRB,1.2047E+03_JPRB/)  
KBO( :,47,15) = (/&
 & 9.5447E+02_JPRB,1.0363E+03_JPRB,1.0984E+03_JPRB,1.1495E+03_JPRB,1.1920E+03_JPRB/)  
KBO( :,48,15) = (/&
 & 9.1939E+02_JPRB,1.0072E+03_JPRB,1.0744E+03_JPRB,1.1303E+03_JPRB,1.1778E+03_JPRB/)  
KBO( :,49,15) = (/&
 & 8.8250E+02_JPRB,9.7585E+02_JPRB,1.0483E+03_JPRB,1.1094E+03_JPRB,1.1613E+03_JPRB/)  
KBO( :,50,15) = (/&
 & 8.4647E+02_JPRB,9.4477E+02_JPRB,1.0219E+03_JPRB,1.0877E+03_JPRB,1.1441E+03_JPRB/)  
KBO( :,51,15) = (/&
 & 8.1004E+02_JPRB,9.1259E+02_JPRB,9.9388E+02_JPRB,1.0648E+03_JPRB,1.1259E+03_JPRB/)  
KBO( :,52,15) = (/&
 & 7.7148E+02_JPRB,8.7865E+02_JPRB,9.6436E+02_JPRB,1.0402E+03_JPRB,1.1061E+03_JPRB/)  
KBO( :,53,15) = (/&
 & 7.3147E+02_JPRB,8.4306E+02_JPRB,9.3344E+02_JPRB,1.0140E+03_JPRB,1.0845E+03_JPRB/)  
KBO( :,54,15) = (/&
 & 6.9315E+02_JPRB,8.0891E+02_JPRB,9.0347E+02_JPRB,9.8850E+02_JPRB,1.0632E+03_JPRB/)  
KBO( :,55,15) = (/&
 & 6.5555E+02_JPRB,7.7476E+02_JPRB,8.7174E+02_JPRB,9.6242E+02_JPRB,1.0413E+03_JPRB/)  
KBO( :,56,15) = (/&
 & 6.1722E+02_JPRB,7.3961E+02_JPRB,8.4012E+02_JPRB,9.3483E+02_JPRB,1.0182E+03_JPRB/)  
KBO( :,57,15) = (/&
 & 5.7836E+02_JPRB,7.0324E+02_JPRB,8.0736E+02_JPRB,9.0611E+02_JPRB,9.9376E+02_JPRB/)  
KBO( :,58,15) = (/&
 & 5.4103E+02_JPRB,6.6804E+02_JPRB,7.7522E+02_JPRB,8.7787E+02_JPRB,9.6912E+02_JPRB/)  
KBO( :,59,15) = (/&
 & 5.2599E+02_JPRB,6.5379E+02_JPRB,7.6206E+02_JPRB,8.6623E+02_JPRB,9.5904E+02_JPRB/)  
KBO( :,13,16) = (/&
 & 3.9649E+02_JPRB,4.3420E+02_JPRB,4.7059E+02_JPRB,5.0417E+02_JPRB,5.3141E+02_JPRB/)  
KBO( :,14,16) = (/&
 & 4.8075E+02_JPRB,5.2232E+02_JPRB,5.6418E+02_JPRB,6.0325E+02_JPRB,6.3379E+02_JPRB/)  
KBO( :,15,16) = (/&
 & 5.7530E+02_JPRB,6.3245E+02_JPRB,6.8080E+02_JPRB,7.1352E+02_JPRB,7.4957E+02_JPRB/)  
KBO( :,16,16) = (/&
 & 6.8549E+02_JPRB,7.5045E+02_JPRB,8.0419E+02_JPRB,8.3617E+02_JPRB,8.7485E+02_JPRB/)  
KBO( :,17,16) = (/&
 & 8.0730E+02_JPRB,8.7949E+02_JPRB,9.2029E+02_JPRB,9.8275E+02_JPRB,1.0083E+03_JPRB/)  
KBO( :,18,16) = (/&
 & 9.3777E+02_JPRB,1.0165E+03_JPRB,1.0537E+03_JPRB,1.1246E+03_JPRB,1.1558E+03_JPRB/)  
KBO( :,19,16) = (/&
 & 1.0735E+03_JPRB,1.1454E+03_JPRB,1.2091E+03_JPRB,1.2558E+03_JPRB,1.3004E+03_JPRB/)  
KBO( :,20,16) = (/&
 & 1.2127E+03_JPRB,1.2868E+03_JPRB,1.3551E+03_JPRB,1.3975E+03_JPRB,1.4452E+03_JPRB/)  
KBO( :,21,16) = (/&
 & 1.3592E+03_JPRB,1.4356E+03_JPRB,1.5001E+03_JPRB,1.5456E+03_JPRB,1.5923E+03_JPRB/)  
KBO( :,22,16) = (/&
 & 1.5169E+03_JPRB,1.5965E+03_JPRB,1.6436E+03_JPRB,1.6935E+03_JPRB,1.7383E+03_JPRB/)  
KBO( :,23,16) = (/&
 & 1.6753E+03_JPRB,1.7518E+03_JPRB,1.7912E+03_JPRB,1.8444E+03_JPRB,1.8635E+03_JPRB/)  
KBO( :,24,16) = (/&
 & 1.8317E+03_JPRB,1.8968E+03_JPRB,1.9298E+03_JPRB,1.9801E+03_JPRB,1.9925E+03_JPRB/)  
KBO( :,25,16) = (/&
 & 1.9704E+03_JPRB,2.0341E+03_JPRB,2.0605E+03_JPRB,2.1039E+03_JPRB,2.1070E+03_JPRB/)  
KBO( :,26,16) = (/&
 & 2.1057E+03_JPRB,2.1630E+03_JPRB,2.1799E+03_JPRB,2.2140E+03_JPRB,2.2098E+03_JPRB/)  
KBO( :,27,16) = (/&
 & 2.2281E+03_JPRB,2.2763E+03_JPRB,2.2836E+03_JPRB,2.3113E+03_JPRB,2.2992E+03_JPRB/)  
KBO( :,28,16) = (/&
 & 2.3345E+03_JPRB,2.3737E+03_JPRB,2.3719E+03_JPRB,2.3935E+03_JPRB,2.3762E+03_JPRB/)  
KBO( :,29,16) = (/&
 & 2.4261E+03_JPRB,2.4570E+03_JPRB,2.4461E+03_JPRB,2.4611E+03_JPRB,2.4401E+03_JPRB/)  
KBO( :,30,16) = (/&
 & 2.5032E+03_JPRB,2.5264E+03_JPRB,2.5077E+03_JPRB,2.5178E+03_JPRB,2.4915E+03_JPRB/)  
KBO( :,31,16) = (/&
 & 2.5677E+03_JPRB,2.5833E+03_JPRB,2.5596E+03_JPRB,2.5650E+03_JPRB,2.5320E+03_JPRB/)  
KBO( :,32,16) = (/&
 & 2.6198E+03_JPRB,2.6282E+03_JPRB,2.6001E+03_JPRB,2.6017E+03_JPRB,2.5636E+03_JPRB/)  
KBO( :,33,16) = (/&
 & 2.6610E+03_JPRB,2.6631E+03_JPRB,2.6317E+03_JPRB,2.6296E+03_JPRB,2.5876E+03_JPRB/)  
KBO( :,34,16) = (/&
 & 2.6943E+03_JPRB,2.6908E+03_JPRB,2.6559E+03_JPRB,2.6515E+03_JPRB,2.6062E+03_JPRB/)  
KBO( :,35,16) = (/&
 & 2.7216E+03_JPRB,2.7136E+03_JPRB,2.6772E+03_JPRB,2.6701E+03_JPRB,2.6232E+03_JPRB/)  
KBO( :,36,16) = (/&
 & 2.7447E+03_JPRB,2.7345E+03_JPRB,2.6971E+03_JPRB,2.6885E+03_JPRB,2.6393E+03_JPRB/)  
KBO( :,37,16) = (/&
 & 2.7663E+03_JPRB,2.7556E+03_JPRB,2.7187E+03_JPRB,2.7089E+03_JPRB,2.6589E+03_JPRB/)  
KBO( :,38,16) = (/&
 & 2.7858E+03_JPRB,2.7874E+03_JPRB,2.7366E+03_JPRB,2.7269E+03_JPRB,2.6752E+03_JPRB/)  
KBO( :,39,16) = (/&
 & 2.8024E+03_JPRB,2.8038E+03_JPRB,2.7625E+03_JPRB,2.7421E+03_JPRB,2.6902E+03_JPRB/)  
KBO( :,40,16) = (/&
 & 2.8177E+03_JPRB,2.8195E+03_JPRB,2.7788E+03_JPRB,2.7591E+03_JPRB,2.7091E+03_JPRB/)  
KBO( :,41,16) = (/&
 & 2.8303E+03_JPRB,2.8352E+03_JPRB,2.7935E+03_JPRB,2.7758E+03_JPRB,2.7270E+03_JPRB/)  
KBO( :,42,16) = (/&
 & 2.8434E+03_JPRB,2.8482E+03_JPRB,2.8071E+03_JPRB,2.7922E+03_JPRB,2.7438E+03_JPRB/)  
KBO( :,43,16) = (/&
 & 2.8548E+03_JPRB,2.8612E+03_JPRB,2.8211E+03_JPRB,2.8082E+03_JPRB,2.7619E+03_JPRB/)  
KBO( :,44,16) = (/&
 & 2.8632E+03_JPRB,2.8731E+03_JPRB,2.8359E+03_JPRB,2.8241E+03_JPRB,2.7786E+03_JPRB/)  
KBO( :,45,16) = (/&
 & 2.8674E+03_JPRB,2.8836E+03_JPRB,2.8494E+03_JPRB,2.8388E+03_JPRB,2.7940E+03_JPRB/)  
KBO( :,46,16) = (/&
 & 2.8677E+03_JPRB,2.8925E+03_JPRB,2.8629E+03_JPRB,2.8226E+03_JPRB,2.8119E+03_JPRB/)  
KBO( :,47,16) = (/&
 & 2.8633E+03_JPRB,2.9002E+03_JPRB,2.8748E+03_JPRB,2.8361E+03_JPRB,2.8260E+03_JPRB/)  
KBO( :,48,16) = (/&
 & 2.8578E+03_JPRB,2.9030E+03_JPRB,2.8832E+03_JPRB,2.8487E+03_JPRB,2.8389E+03_JPRB/)  
KBO( :,49,16) = (/&
 & 2.8403E+03_JPRB,2.9008E+03_JPRB,2.8874E+03_JPRB,2.8585E+03_JPRB,2.8534E+03_JPRB/)  
KBO( :,50,16) = (/&
 & 2.8204E+03_JPRB,2.8937E+03_JPRB,2.8907E+03_JPRB,2.8681E+03_JPRB,2.8665E+03_JPRB/)  
KBO( :,51,16) = (/&
 & 2.7945E+03_JPRB,2.8834E+03_JPRB,2.8924E+03_JPRB,2.8761E+03_JPRB,2.8762E+03_JPRB/)  
KBO( :,52,16) = (/&
 & 2.7647E+03_JPRB,2.8693E+03_JPRB,2.8895E+03_JPRB,2.8805E+03_JPRB,2.8863E+03_JPRB/)  
KBO( :,53,16) = (/&
 & 2.7286E+03_JPRB,2.8496E+03_JPRB,2.8822E+03_JPRB,2.8814E+03_JPRB,2.8931E+03_JPRB/)  
KBO( :,54,16) = (/&
 & 2.6904E+03_JPRB,2.8223E+03_JPRB,2.8712E+03_JPRB,2.8790E+03_JPRB,2.8991E+03_JPRB/)  
KBO( :,55,16) = (/&
 & 2.6470E+03_JPRB,2.7955E+03_JPRB,2.8486E+03_JPRB,2.8755E+03_JPRB,2.9024E+03_JPRB/)  
KBO( :,56,16) = (/&
 & 2.5966E+03_JPRB,2.7630E+03_JPRB,2.8315E+03_JPRB,2.8687E+03_JPRB,2.9035E+03_JPRB/)  
KBO( :,57,16) = (/&
 & 2.5400E+03_JPRB,2.7247E+03_JPRB,2.8099E+03_JPRB,2.8582E+03_JPRB,2.9024E+03_JPRB/)  
KBO( :,58,16) = (/&
 & 2.4795E+03_JPRB,2.6821E+03_JPRB,2.7847E+03_JPRB,2.8441E+03_JPRB,2.8994E+03_JPRB/)  
KBO( :,59,16) = (/&
 & 2.4534E+03_JPRB,2.6638E+03_JPRB,2.7735E+03_JPRB,2.8383E+03_JPRB,2.8978E+03_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB10:PART7',1,ZHOOK_HANDLE)
END SUBROUTINE PART7


END SUBROUTINE RRTM_KGB10
