!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif 
!pgi$r opt=0
SUBROUTINE SRTM_KGB24

!     Originally by J.Delamere, Atmospheric & Environmental Research.
!     Revision: 2.4
!     BAND 24: 12850-16000 cm-1 (low - H2O,O2; high - O2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOESRTA24, ONLY : KA, KB, SELFREF, FORREF, SFLUXREF, RAYLA, RAYLB &
 & , ABSO3A, ABSO3B, STRRAT, LAYREFFR  

!     ------------------------------------------------------------------

IMPLICIT NONE

! KURUCZ
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2
CALL PART3
CALL PART4
CALL PART5
CALL PART6
CALL PART7
CALL PART8
CALL PART9
CALL PART10
CALL PART11
CALL PART12
CALL PART13
CALL PART14
CALL PART15
CALL PART16
CALL PART17

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24',1,ZHOOK_HANDLE)

!     -----------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART1',0,ZHOOK_HANDLE)


SFLUXREF(:,1) = (/ &
 & 34.3610_JPRB , 33.1240_JPRB, 31.3948_JPRB, 28.7248_JPRB, &
 & 24.7884_JPRB , 21.4892_JPRB, 17.3972_JPRB, 13.7928_JPRB, &
 & 9.54462_JPRB , 1.05002_JPRB,0.867332_JPRB,0.685753_JPRB, &
 & 0.504718_JPRB,0.323112_JPRB,0.122183_JPRB, 1.70288E-02_JPRB /)  
SFLUXREF(:,2) = (/ &
 & 34.2367_JPRB , 32.4327_JPRB, 30.0863_JPRB, 28.2085_JPRB,  &
 & 25.6533_JPRB , 22.3412_JPRB, 18.3112_JPRB, 13.8521_JPRB, &
 & 9.51035_JPRB , 1.04138_JPRB,0.863493_JPRB,0.682790_JPRB, &
 & 0.504721_JPRB,0.323102_JPRB,0.122193_JPRB, 1.70288E-02_JPRB /)  
SFLUXREF(:,3) = (/ &
 & 34.1883_JPRB , 32.2479_JPRB, 30.2650_JPRB, 28.2914_JPRB, &
 & 25.6626_JPRB , 22.3163_JPRB, 18.3327_JPRB, 13.8508_JPRB, &
 & 9.49190_JPRB , 1.03672_JPRB,0.858272_JPRB,0.681485_JPRB, &
 & 0.501363_JPRB,0.323110_JPRB,0.122183_JPRB, 1.70288E-02_JPRB /)  
SFLUXREF(:,4) = (/ &
 & 34.1365_JPRB , 32.2316_JPRB, 30.3325_JPRB, 28.3305_JPRB, &
 & 25.6420_JPRB , 22.3223_JPRB, 18.3411_JPRB, 13.8471_JPRB, &
 & 9.47492_JPRB , 1.03376_JPRB,0.855380_JPRB,0.679085_JPRB, &
 & 0.497998_JPRB,0.323053_JPRB,0.122183_JPRB, 1.70288E-02_JPRB /)  
SFLUXREF(:,5) = (/ &
 & 34.0460_JPRB , 32.2795_JPRB, 30.4147_JPRB, 28.3123_JPRB, &
 & 25.6438_JPRB , 22.3238_JPRB, 18.3441_JPRB, 13.8528_JPRB, &
 & 9.45222_JPRB , 1.03058_JPRB,0.854037_JPRB,0.675554_JPRB, &
 & 0.498344_JPRB,0.320072_JPRB,0.122193_JPRB, 1.70288E-02_JPRB /)  
SFLUXREF(:,6) = (/ &
 & 33.9909_JPRB , 32.3127_JPRB, 30.4854_JPRB, 28.3005_JPRB, &
 & 25.6310_JPRB , 22.3294_JPRB, 18.3459_JPRB, 13.8488_JPRB, &
 & 9.43336_JPRB , 1.02901_JPRB,0.852728_JPRB,0.672322_JPRB, &
 & 0.498056_JPRB,0.317753_JPRB,0.122183_JPRB, 1.70288E-02_JPRB /)  
SFLUXREF(:,7) = (/ &
 & 33.9225_JPRB , 32.4097_JPRB, 30.5125_JPRB, 28.2810_JPRB, &
 & 25.6387_JPRB , 22.3080_JPRB, 18.3715_JPRB, 13.8248_JPRB, &
 & 9.41834_JPRB , 1.02735_JPRB,0.850807_JPRB,0.671379_JPRB, &
 & 0.496975_JPRB,0.317158_JPRB,0.119297_JPRB, 1.70207E-02_JPRB /)  
SFLUXREF(:,8) = (/ &
 & 33.8940_JPRB , 32.4951_JPRB, 30.5494_JPRB, 28.2788_JPRB, &
 & 25.5975_JPRB , 22.3225_JPRB, 18.3358_JPRB, 13.8199_JPRB, &
 & 9.40283_JPRB , 1.02751_JPRB,0.850729_JPRB,0.670152_JPRB, &
 & 0.494294_JPRB,0.315829_JPRB,0.116195_JPRB, 1.64138E-02_JPRB /)  
SFLUXREF(:,9) = (/ &
 & 34.6501_JPRB , 32.6690_JPRB, 30.2872_JPRB, 28.0955_JPRB, &
 & 25.4662_JPRB , 22.1446_JPRB, 18.2754_JPRB, 13.7573_JPRB, &
 & 9.36645_JPRB , 1.02356_JPRB,0.847154_JPRB,0.668519_JPRB, &
 & 0.489186_JPRB,0.313790_JPRB,0.117074_JPRB, 1.60943E-02_JPRB /)  

!     Rayleigh extinction coefficient at all v
RAYLA(:,1) = (/ &
 & 1.28405E-07_JPRB,1.45501E-07_JPRB,1.67272E-07_JPRB,1.94856E-07_JPRB, &
 & 2.15248E-07_JPRB,2.34920E-07_JPRB,2.48558E-07_JPRB,1.80004E-07_JPRB, &
 & 1.46504E-07_JPRB,1.31355E-07_JPRB,1.33562E-07_JPRB,1.35618E-07_JPRB, &
 & 1.22412E-07_JPRB,1.19842E-07_JPRB,1.19924E-07_JPRB,1.20264E-07_JPRB /)  
RAYLA(:,2) = (/ &
 & 1.41622E-07_JPRB,1.93436E-07_JPRB,2.25057E-07_JPRB,2.01025E-07_JPRB, &
 & 1.85138E-07_JPRB,1.72672E-07_JPRB,1.64771E-07_JPRB,1.59312E-07_JPRB, &
 & 1.44961E-07_JPRB,1.37448E-07_JPRB,1.37506E-07_JPRB,1.38081E-07_JPRB, &
 & 1.22432E-07_JPRB,1.19844E-07_JPRB,1.19921E-07_JPRB,1.20287E-07_JPRB /)  
RAYLA(:,3) = (/ &
 & 1.45382E-07_JPRB,1.97020E-07_JPRB,2.22781E-07_JPRB,1.96062E-07_JPRB, &
 & 1.83495E-07_JPRB,1.72495E-07_JPRB,1.64910E-07_JPRB,1.58797E-07_JPRB, &
 & 1.46208E-07_JPRB,1.42274E-07_JPRB,1.40445E-07_JPRB,1.39496E-07_JPRB, &
 & 1.26940E-07_JPRB,1.19844E-07_JPRB,1.19921E-07_JPRB,1.20287E-07_JPRB /)  
RAYLA(:,4) = (/ &
 & 1.48247E-07_JPRB,1.99958E-07_JPRB,2.18048E-07_JPRB,1.93896E-07_JPRB, &
 & 1.83125E-07_JPRB,1.73244E-07_JPRB,1.64320E-07_JPRB,1.58298E-07_JPRB, &
 & 1.48428E-07_JPRB,1.44769E-07_JPRB,1.43704E-07_JPRB,1.38498E-07_JPRB, &
 & 1.31732E-07_JPRB,1.22299E-07_JPRB,1.19921E-07_JPRB,1.20287E-07_JPRB /)  
RAYLA(:,5) = (/ &
 & 1.51343E-07_JPRB,1.99621E-07_JPRB,2.14563E-07_JPRB,1.93824E-07_JPRB, &
 & 1.82992E-07_JPRB,1.73143E-07_JPRB,1.64587E-07_JPRB,1.57355E-07_JPRB, &
 & 1.51198E-07_JPRB,1.46373E-07_JPRB,1.45438E-07_JPRB,1.38095E-07_JPRB, &
 & 1.35026E-07_JPRB,1.27504E-07_JPRB,1.19921E-07_JPRB,1.20287E-07_JPRB /)  
RAYLA(:,6) = (/ &
 & 1.54462E-07_JPRB,1.97610E-07_JPRB,2.11992E-07_JPRB,1.93831E-07_JPRB, &
 & 1.83900E-07_JPRB,1.73125E-07_JPRB,1.64093E-07_JPRB,1.57651E-07_JPRB, &
 & 1.53158E-07_JPRB,1.46843E-07_JPRB,1.44733E-07_JPRB,1.40611E-07_JPRB, &
 & 1.37320E-07_JPRB,1.33932E-07_JPRB,1.20423E-07_JPRB,1.20287E-07_JPRB /)  
RAYLA(:,7) = (/ &
 & 1.59068E-07_JPRB,1.92757E-07_JPRB,2.09865E-07_JPRB,1.95132E-07_JPRB, &
 & 1.83641E-07_JPRB,1.73778E-07_JPRB,1.63215E-07_JPRB,1.59462E-07_JPRB, &
 & 1.54331E-07_JPRB,1.46177E-07_JPRB,1.45819E-07_JPRB,1.43177E-07_JPRB, &
 & 1.39797E-07_JPRB,1.36780E-07_JPRB,1.33385E-07_JPRB,1.20287E-07_JPRB /)  
RAYLA(:,8) = (/ &
 & 1.62066E-07_JPRB,1.87529E-07_JPRB,2.07191E-07_JPRB,1.97788E-07_JPRB, &
 & 1.84920E-07_JPRB,1.72951E-07_JPRB,1.65450E-07_JPRB,1.60344E-07_JPRB, &
 & 1.54403E-07_JPRB,1.47679E-07_JPRB,1.47287E-07_JPRB,1.44951E-07_JPRB, &
 & 1.42517E-07_JPRB,1.41107E-07_JPRB,1.48688E-07_JPRB,1.51127E-07_JPRB /)  
RAYLA(:,9) = (/ &
 & 1.19177E-07_JPRB,1.86522E-07_JPRB,2.20324E-07_JPRB,2.13543E-07_JPRB, &
 & 1.92198E-07_JPRB,1.81641E-07_JPRB,1.70092E-07_JPRB,1.65072E-07_JPRB, &
 & 1.59804E-07_JPRB,1.56745E-07_JPRB,1.51235E-07_JPRB,1.51400E-07_JPRB, &
 & 1.49635E-07_JPRB,1.48056E-07_JPRB,1.49046E-07_JPRB,1.51010E-07_JPRB /)  

RAYLB = (/ &
 & 1.23766E-07_JPRB,1.40524E-07_JPRB,1.61610E-07_JPRB,1.83232E-07_JPRB, &
 & 2.02951E-07_JPRB,2.21367E-07_JPRB,2.38367E-07_JPRB,2.53019E-07_JPRB, &
 & 2.12202E-07_JPRB,1.36977E-07_JPRB,1.39118E-07_JPRB,1.37097E-07_JPRB, &
 & 1.33223E-07_JPRB,1.38695E-07_JPRB,1.19868E-07_JPRB,1.20062E-07_JPRB /)  

ABSO3A = (/ &
 & 8.03067E-02_JPRB,0.180926_JPRB   ,0.227484_JPRB   ,0.168015_JPRB   , &
 & 0.138284_JPRB   ,0.114537_JPRB   ,9.50114E-02_JPRB,8.06816E-02_JPRB, &
 & 6.76406E-02_JPRB,5.69802E-02_JPRB,5.63283E-02_JPRB,4.57592E-02_JPRB, &
 & 4.21862E-02_JPRB,3.47949E-02_JPRB,2.65731E-02_JPRB,2.67628E-02_JPRB /)  

ABSO3B = (/ &
 & 2.94848E-02_JPRB,4.33642E-02_JPRB,6.70197E-02_JPRB,0.104990_JPRB   , &
 & 0.156180_JPRB   ,0.214638_JPRB   ,0.266281_JPRB   ,0.317941_JPRB   , &
 & 0.355327_JPRB   ,0.371241_JPRB   ,0.374396_JPRB   ,0.326847_JPRB   , &
 & 0.126497_JPRB   ,6.95264E-02_JPRB,2.58175E-02_JPRB,2.52862E-02_JPRB /)  

STRRAT = 0.124692_JPRB

LAYREFFR = 1

!     ------------------------------------------------------------------

!     The array KA contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KA(:, 1, 1, 1) = (/ &
 & 0.73110E-09_JPRB,0.95257E-08_JPRB,0.84454E-08_JPRB,0.69367E-08_JPRB,0.55267E-08_JPRB, &
 & 0.41107E-08_JPRB,0.32800E-08_JPRB,0.33548E-08_JPRB,0.22111E-08_JPRB /)  
KA(:, 2, 1, 1) = (/ &
 & 0.71850E-09_JPRB,0.98856E-08_JPRB,0.88084E-08_JPRB,0.72442E-08_JPRB,0.57586E-08_JPRB, &
 & 0.43475E-08_JPRB,0.34021E-08_JPRB,0.32425E-08_JPRB,0.21911E-08_JPRB /)  
KA(:, 3, 1, 1) = (/ &
 & 0.57048E-09_JPRB,0.11944E-07_JPRB,0.10693E-07_JPRB,0.91787E-08_JPRB,0.75423E-08_JPRB, &
 & 0.56949E-08_JPRB,0.43124E-08_JPRB,0.42335E-08_JPRB,0.57788E-08_JPRB /)  
KA(:, 4, 1, 1) = (/ &
 & 0.45283E-09_JPRB,0.10517E-07_JPRB,0.93142E-08_JPRB,0.77267E-08_JPRB,0.61927E-08_JPRB, &
 & 0.47485E-08_JPRB,0.34557E-08_JPRB,0.32691E-08_JPRB,0.21836E-08_JPRB /)  
KA(:, 5, 1, 1) = (/ &
 & 0.40037E-09_JPRB,0.10599E-07_JPRB,0.93529E-08_JPRB,0.78411E-08_JPRB,0.63421E-08_JPRB, &
 & 0.49082E-08_JPRB,0.36312E-08_JPRB,0.32874E-08_JPRB,0.21861E-08_JPRB /)  
KA(:, 1, 2, 1) = (/ &
 & 0.77671E-09_JPRB,0.11163E-07_JPRB,0.95032E-08_JPRB,0.79805E-08_JPRB,0.60721E-08_JPRB, &
 & 0.45440E-08_JPRB,0.31263E-08_JPRB,0.28631E-08_JPRB,0.19430E-08_JPRB /)  
KA(:, 2, 2, 1) = (/ &
 & 0.85527E-09_JPRB,0.11271E-07_JPRB,0.97269E-08_JPRB,0.82280E-08_JPRB,0.62706E-08_JPRB, &
 & 0.47926E-08_JPRB,0.32802E-08_JPRB,0.28152E-08_JPRB,0.19155E-08_JPRB /)  
KA(:, 3, 2, 1) = (/ &
 & 0.85773E-09_JPRB,0.13292E-07_JPRB,0.11943E-07_JPRB,0.10177E-07_JPRB,0.81637E-08_JPRB, &
 & 0.62054E-08_JPRB,0.44045E-08_JPRB,0.35504E-08_JPRB,0.48274E-08_JPRB /)  
KA(:, 4, 2, 1) = (/ &
 & 0.76956E-09_JPRB,0.13343E-07_JPRB,0.12140E-07_JPRB,0.10403E-07_JPRB,0.83916E-08_JPRB, &
 & 0.64414E-08_JPRB,0.46212E-08_JPRB,0.36611E-08_JPRB,0.46523E-08_JPRB /)  
KA(:, 5, 2, 1) = (/ &
 & 0.53187E-09_JPRB,0.11759E-07_JPRB,0.10564E-07_JPRB,0.89416E-08_JPRB,0.69566E-08_JPRB, &
 & 0.54336E-08_JPRB,0.36797E-08_JPRB,0.28238E-08_JPRB,0.18838E-08_JPRB /)  
KA(:, 1, 3, 1) = (/ &
 & 0.99065E-09_JPRB,0.13223E-07_JPRB,0.11222E-07_JPRB,0.94282E-08_JPRB,0.74664E-08_JPRB, &
 & 0.54084E-08_JPRB,0.35205E-08_JPRB,0.24806E-08_JPRB,0.20205E-08_JPRB /)  
KA(:, 2, 3, 1) = (/ &
 & 0.98793E-09_JPRB,0.13673E-07_JPRB,0.11444E-07_JPRB,0.96735E-08_JPRB,0.76364E-08_JPRB, &
 & 0.55809E-08_JPRB,0.37259E-08_JPRB,0.25419E-08_JPRB,0.20086E-08_JPRB /)  
KA(:, 3, 3, 1) = (/ &
 & 0.10274E-08_JPRB,0.14243E-07_JPRB,0.12051E-07_JPRB,0.10168E-07_JPRB,0.80110E-08_JPRB, &
 & 0.59129E-08_JPRB,0.38720E-08_JPRB,0.26806E-08_JPRB,0.19959E-08_JPRB /)  
KA(:, 4, 3, 1) = (/ &
 & 0.10879E-08_JPRB,0.15991E-07_JPRB,0.14290E-07_JPRB,0.12193E-07_JPRB,0.99943E-08_JPRB, &
 & 0.76411E-08_JPRB,0.49949E-08_JPRB,0.32117E-08_JPRB,0.45196E-08_JPRB /)  
KA(:, 5, 3, 1) = (/ &
 & 0.10733E-08_JPRB,0.14460E-07_JPRB,0.12483E-07_JPRB,0.10703E-07_JPRB,0.84924E-08_JPRB, &
 & 0.62896E-08_JPRB,0.42753E-08_JPRB,0.27408E-08_JPRB,0.19679E-08_JPRB /)  
KA(:, 1, 4, 1) = (/ &
 & 0.11948E-08_JPRB,0.15804E-07_JPRB,0.13423E-07_JPRB,0.10964E-07_JPRB,0.86345E-08_JPRB, &
 & 0.61421E-08_JPRB,0.39130E-08_JPRB,0.24271E-08_JPRB,0.26282E-08_JPRB /)  
KA(:, 2, 4, 1) = (/ &
 & 0.12796E-08_JPRB,0.16985E-07_JPRB,0.14121E-07_JPRB,0.11784E-07_JPRB,0.93415E-08_JPRB, &
 & 0.67310E-08_JPRB,0.43124E-08_JPRB,0.25170E-08_JPRB,0.26033E-08_JPRB /)  
KA(:, 3, 4, 1) = (/ &
 & 0.12903E-08_JPRB,0.17863E-07_JPRB,0.14703E-07_JPRB,0.12387E-07_JPRB,0.99243E-08_JPRB, &
 & 0.72283E-08_JPRB,0.46892E-08_JPRB,0.26092E-08_JPRB,0.25739E-08_JPRB /)  
KA(:, 4, 4, 1) = (/ &
 & 0.13030E-08_JPRB,0.17982E-07_JPRB,0.14488E-07_JPRB,0.12389E-07_JPRB,0.10284E-07_JPRB, &
 & 0.76192E-08_JPRB,0.50049E-08_JPRB,0.27184E-08_JPRB,0.25450E-08_JPRB /)  
KA(:, 5, 4, 1) = (/ &
 & 0.13295E-08_JPRB,0.20084E-07_JPRB,0.17213E-07_JPRB,0.15086E-07_JPRB,0.12255E-07_JPRB, &
 & 0.93192E-08_JPRB,0.61747E-08_JPRB,0.34151E-08_JPRB,0.50409E-08_JPRB /)  
KA(:, 1, 5, 1) = (/ &
 & 0.14930E-08_JPRB,0.19740E-07_JPRB,0.16353E-07_JPRB,0.13382E-07_JPRB,0.10370E-07_JPRB, &
 & 0.76167E-08_JPRB,0.46913E-08_JPRB,0.23740E-08_JPRB,0.37254E-08_JPRB /)  
KA(:, 2, 5, 1) = (/ &
 & 0.15750E-08_JPRB,0.20826E-07_JPRB,0.17352E-07_JPRB,0.14080E-07_JPRB,0.11109E-07_JPRB, &
 & 0.82293E-08_JPRB,0.51142E-08_JPRB,0.25900E-08_JPRB,0.36977E-08_JPRB /)  
KA(:, 3, 5, 1) = (/ &
 & 0.16427E-08_JPRB,0.22313E-07_JPRB,0.18005E-07_JPRB,0.14545E-07_JPRB,0.11545E-07_JPRB, &
 & 0.85987E-08_JPRB,0.53849E-08_JPRB,0.27523E-08_JPRB,0.36628E-08_JPRB /)  
KA(:, 4, 5, 1) = (/ &
 & 0.17106E-08_JPRB,0.23821E-07_JPRB,0.18882E-07_JPRB,0.15226E-07_JPRB,0.12313E-07_JPRB, &
 & 0.92367E-08_JPRB,0.58646E-08_JPRB,0.29020E-08_JPRB,0.36336E-08_JPRB /)  
KA(:, 5, 5, 1) = (/ &
 & 0.17465E-08_JPRB,0.26750E-07_JPRB,0.22103E-07_JPRB,0.18690E-07_JPRB,0.15320E-07_JPRB, &
 & 0.11508E-07_JPRB,0.77281E-08_JPRB,0.34929E-08_JPRB,0.69801E-08_JPRB /)  
KA(:, 1, 6, 1) = (/ &
 & 0.17561E-08_JPRB,0.17298E-07_JPRB,0.18888E-07_JPRB,0.16164E-07_JPRB,0.12676E-07_JPRB, &
 & 0.91128E-08_JPRB,0.57292E-08_JPRB,0.25945E-08_JPRB,0.52718E-08_JPRB /)  
KA(:, 2, 6, 1) = (/ &
 & 0.19997E-08_JPRB,0.20866E-07_JPRB,0.20612E-07_JPRB,0.17467E-07_JPRB,0.13431E-07_JPRB, &
 & 0.96178E-08_JPRB,0.60009E-08_JPRB,0.28959E-08_JPRB,0.52609E-08_JPRB /)  
KA(:, 3, 6, 1) = (/ &
 & 0.21808E-08_JPRB,0.24689E-07_JPRB,0.22590E-07_JPRB,0.18672E-07_JPRB,0.14573E-07_JPRB, &
 & 0.10599E-07_JPRB,0.66802E-08_JPRB,0.31104E-08_JPRB,0.52649E-08_JPRB /)  
KA(:, 4, 6, 1) = (/ &
 & 0.22321E-08_JPRB,0.28043E-07_JPRB,0.23802E-07_JPRB,0.19473E-07_JPRB,0.15182E-07_JPRB, &
 & 0.11372E-07_JPRB,0.73223E-08_JPRB,0.34820E-08_JPRB,0.52977E-08_JPRB /)  
KA(:, 5, 6, 1) = (/ &
 & 0.23033E-08_JPRB,0.30784E-07_JPRB,0.25188E-07_JPRB,0.20376E-07_JPRB,0.16019E-07_JPRB, &
 & 0.12009E-07_JPRB,0.77933E-08_JPRB,0.37322E-08_JPRB,0.52777E-08_JPRB /)  
KA(:, 1, 7, 1) = (/ &
 & 0.22679E-08_JPRB,0.13507E-07_JPRB,0.20320E-07_JPRB,0.19549E-07_JPRB,0.15905E-07_JPRB, &
 & 0.11277E-07_JPRB,0.68710E-08_JPRB,0.29328E-08_JPRB,0.79703E-08_JPRB /)  
KA(:, 2, 7, 1) = (/ &
 & 0.25718E-08_JPRB,0.16957E-07_JPRB,0.24375E-07_JPRB,0.21175E-07_JPRB,0.17080E-07_JPRB, &
 & 0.12233E-07_JPRB,0.77114E-08_JPRB,0.34113E-08_JPRB,0.79963E-08_JPRB /)  
KA(:, 3, 7, 1) = (/ &
 & 0.27598E-08_JPRB,0.19896E-07_JPRB,0.28092E-07_JPRB,0.23059E-07_JPRB,0.18272E-07_JPRB, &
 & 0.13117E-07_JPRB,0.84449E-08_JPRB,0.37817E-08_JPRB,0.79824E-08_JPRB /)  
KA(:, 4, 7, 1) = (/ &
 & 0.28979E-08_JPRB,0.22997E-07_JPRB,0.29556E-07_JPRB,0.24211E-07_JPRB,0.19134E-07_JPRB, &
 & 0.13799E-07_JPRB,0.90980E-08_JPRB,0.41849E-08_JPRB,0.79622E-08_JPRB /)  
KA(:, 5, 7, 1) = (/ &
 & 0.31158E-08_JPRB,0.26193E-07_JPRB,0.32426E-07_JPRB,0.25685E-07_JPRB,0.19970E-07_JPRB, &
 & 0.14504E-07_JPRB,0.96379E-08_JPRB,0.45034E-08_JPRB,0.78914E-08_JPRB /)  
KA(:, 1, 8, 1) = (/ &
 & 0.27286E-08_JPRB,0.10085E-07_JPRB,0.15014E-07_JPRB,0.19090E-07_JPRB,0.19831E-07_JPRB, &
 & 0.15054E-07_JPRB,0.91059E-08_JPRB,0.39324E-08_JPRB,0.14155E-07_JPRB /)  
KA(:, 2, 8, 1) = (/ &
 & 0.30146E-08_JPRB,0.12680E-07_JPRB,0.19259E-07_JPRB,0.23896E-07_JPRB,0.21584E-07_JPRB, &
 & 0.16217E-07_JPRB,0.99712E-08_JPRB,0.44108E-08_JPRB,0.14243E-07_JPRB /)  
KA(:, 3, 8, 1) = (/ &
 & 0.35571E-08_JPRB,0.15989E-07_JPRB,0.23328E-07_JPRB,0.28003E-07_JPRB,0.22999E-07_JPRB, &
 & 0.17316E-07_JPRB,0.10856E-07_JPRB,0.49279E-08_JPRB,0.13770E-07_JPRB /)  
KA(:, 4, 8, 1) = (/ &
 & 0.40065E-08_JPRB,0.19481E-07_JPRB,0.27247E-07_JPRB,0.30922E-07_JPRB,0.24592E-07_JPRB, &
 & 0.18005E-07_JPRB,0.11331E-07_JPRB,0.53242E-08_JPRB,0.13758E-07_JPRB /)  
KA(:, 5, 8, 1) = (/ &
 & 0.44047E-08_JPRB,0.23368E-07_JPRB,0.31337E-07_JPRB,0.33478E-07_JPRB,0.26467E-07_JPRB, &
 & 0.19093E-07_JPRB,0.12194E-07_JPRB,0.56088E-08_JPRB,0.13665E-07_JPRB /)  
KA(:, 1, 9, 1) = (/ &
 & 0.32692E-08_JPRB,0.79127E-08_JPRB,0.11108E-07_JPRB,0.13962E-07_JPRB,0.15949E-07_JPRB, &
 & 0.18125E-07_JPRB,0.12367E-07_JPRB,0.53666E-08_JPRB,0.28048E-07_JPRB /)  
KA(:, 2, 9, 1) = (/ &
 & 0.39872E-08_JPRB,0.10056E-07_JPRB,0.14185E-07_JPRB,0.17838E-07_JPRB,0.20262E-07_JPRB, &
 & 0.19824E-07_JPRB,0.13459E-07_JPRB,0.59111E-08_JPRB,0.29491E-07_JPRB /)  
KA(:, 3, 9, 1) = (/ &
 & 0.46117E-08_JPRB,0.12472E-07_JPRB,0.17902E-07_JPRB,0.22130E-07_JPRB,0.25362E-07_JPRB, &
 & 0.21745E-07_JPRB,0.14226E-07_JPRB,0.62741E-08_JPRB,0.30373E-07_JPRB /)  
KA(:, 4, 9, 1) = (/ &
 & 0.52024E-08_JPRB,0.15275E-07_JPRB,0.21923E-07_JPRB,0.27295E-07_JPRB,0.30210E-07_JPRB, &
 & 0.23240E-07_JPRB,0.15087E-07_JPRB,0.66869E-08_JPRB,0.31196E-07_JPRB /)  
KA(:, 5, 9, 1) = (/ &
 & 0.56198E-08_JPRB,0.17975E-07_JPRB,0.26684E-07_JPRB,0.30762E-07_JPRB,0.34012E-07_JPRB, &
 & 0.25509E-07_JPRB,0.16208E-07_JPRB,0.72951E-08_JPRB,0.31583E-07_JPRB /)  
KA(:, 1,10, 1) = (/ &
 & 0.48178E-08_JPRB,0.70531E-08_JPRB,0.93321E-08_JPRB,0.10834E-07_JPRB,0.12386E-07_JPRB, &
 & 0.13718E-07_JPRB,0.14795E-07_JPRB,0.73464E-08_JPRB,0.35934E-07_JPRB /)  
KA(:, 2,10, 1) = (/ &
 & 0.55752E-08_JPRB,0.86985E-08_JPRB,0.11492E-07_JPRB,0.13823E-07_JPRB,0.15291E-07_JPRB, &
 & 0.17278E-07_JPRB,0.18153E-07_JPRB,0.81439E-08_JPRB,0.37177E-07_JPRB /)  
KA(:, 3,10, 1) = (/ &
 & 0.63274E-08_JPRB,0.10735E-07_JPRB,0.13985E-07_JPRB,0.17136E-07_JPRB,0.19303E-07_JPRB, &
 & 0.20940E-07_JPRB,0.20044E-07_JPRB,0.88008E-08_JPRB,0.38431E-07_JPRB /)  
KA(:, 4,10, 1) = (/ &
 & 0.70007E-08_JPRB,0.12858E-07_JPRB,0.17195E-07_JPRB,0.20946E-07_JPRB,0.23543E-07_JPRB, &
 & 0.25732E-07_JPRB,0.21748E-07_JPRB,0.95846E-08_JPRB,0.39768E-07_JPRB /)  
KA(:, 5,10, 1) = (/ &
 & 0.75858E-08_JPRB,0.15576E-07_JPRB,0.20803E-07_JPRB,0.25331E-07_JPRB,0.28222E-07_JPRB, &
 & 0.30974E-07_JPRB,0.23346E-07_JPRB,0.10532E-07_JPRB,0.41126E-07_JPRB /)  
KA(:, 1,11, 1) = (/ &
 & 0.71066E-08_JPRB,0.91105E-08_JPRB,0.91823E-08_JPRB,0.10078E-07_JPRB,0.11080E-07_JPRB, &
 & 0.11808E-07_JPRB,0.12592E-07_JPRB,0.10585E-07_JPRB,0.36646E-07_JPRB /)  
KA(:, 2,11, 1) = (/ &
 & 0.75651E-08_JPRB,0.10196E-07_JPRB,0.11288E-07_JPRB,0.12341E-07_JPRB,0.13264E-07_JPRB, &
 & 0.14635E-07_JPRB,0.15304E-07_JPRB,0.12113E-07_JPRB,0.37821E-07_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART2',0,ZHOOK_HANDLE)


KA(:, 3,11, 1) = (/ &
 & 0.84521E-08_JPRB,0.11641E-07_JPRB,0.13494E-07_JPRB,0.15134E-07_JPRB,0.16494E-07_JPRB, &
 & 0.17667E-07_JPRB,0.18637E-07_JPRB,0.13998E-07_JPRB,0.39151E-07_JPRB /)  
KA(:, 4,11, 1) = (/ &
 & 0.96535E-08_JPRB,0.13091E-07_JPRB,0.16210E-07_JPRB,0.18132E-07_JPRB,0.20108E-07_JPRB, &
 & 0.21506E-07_JPRB,0.22578E-07_JPRB,0.15372E-07_JPRB,0.40534E-07_JPRB /)  
KA(:, 5,11, 1) = (/ &
 & 0.10866E-07_JPRB,0.15259E-07_JPRB,0.19222E-07_JPRB,0.21816E-07_JPRB,0.23808E-07_JPRB, &
 & 0.25779E-07_JPRB,0.26640E-07_JPRB,0.16560E-07_JPRB,0.41783E-07_JPRB /)  
KA(:, 1,12, 1) = (/ &
 & 0.80834E-08_JPRB,0.10420E-07_JPRB,0.92387E-08_JPRB,0.95448E-08_JPRB,0.10004E-07_JPRB, &
 & 0.10210E-07_JPRB,0.10715E-07_JPRB,0.12956E-07_JPRB,0.37307E-07_JPRB /)  
KA(:, 2,12, 1) = (/ &
 & 0.93300E-08_JPRB,0.11721E-07_JPRB,0.10935E-07_JPRB,0.11240E-07_JPRB,0.12099E-07_JPRB, &
 & 0.12529E-07_JPRB,0.12978E-07_JPRB,0.14968E-07_JPRB,0.38619E-07_JPRB /)  
KA(:, 3,12, 1) = (/ &
 & 0.10509E-07_JPRB,0.12830E-07_JPRB,0.12793E-07_JPRB,0.13649E-07_JPRB,0.14634E-07_JPRB, &
 & 0.15024E-07_JPRB,0.15635E-07_JPRB,0.17087E-07_JPRB,0.40001E-07_JPRB /)  
KA(:, 4,12, 1) = (/ &
 & 0.11973E-07_JPRB,0.14173E-07_JPRB,0.14811E-07_JPRB,0.16236E-07_JPRB,0.17652E-07_JPRB, &
 & 0.18139E-07_JPRB,0.18897E-07_JPRB,0.19167E-07_JPRB,0.41426E-07_JPRB /)  
KA(:, 5,12, 1) = (/ &
 & 0.13412E-07_JPRB,0.16145E-07_JPRB,0.17438E-07_JPRB,0.18946E-07_JPRB,0.20873E-07_JPRB, &
 & 0.21649E-07_JPRB,0.22446E-07_JPRB,0.20222E-07_JPRB,0.42866E-07_JPRB /)  
KA(:, 1,13, 1) = (/ &
 & 0.96752E-08_JPRB,0.12525E-07_JPRB,0.10944E-07_JPRB,0.96402E-08_JPRB,0.92613E-08_JPRB, &
 & 0.89183E-08_JPRB,0.91757E-08_JPRB,0.10962E-07_JPRB,0.37700E-07_JPRB /)  
KA(:, 2,13, 1) = (/ &
 & 0.10573E-07_JPRB,0.14013E-07_JPRB,0.12095E-07_JPRB,0.11243E-07_JPRB,0.11108E-07_JPRB, &
 & 0.10880E-07_JPRB,0.11099E-07_JPRB,0.12700E-07_JPRB,0.39054E-07_JPRB /)  
KA(:, 3,13, 1) = (/ &
 & 0.12096E-07_JPRB,0.15476E-07_JPRB,0.13719E-07_JPRB,0.13357E-07_JPRB,0.13060E-07_JPRB, &
 & 0.13122E-07_JPRB,0.13232E-07_JPRB,0.14320E-07_JPRB,0.40767E-07_JPRB /)  
KA(:, 4,13, 1) = (/ &
 & 0.13461E-07_JPRB,0.16674E-07_JPRB,0.15454E-07_JPRB,0.15611E-07_JPRB,0.15616E-07_JPRB, &
 & 0.15505E-07_JPRB,0.16233E-07_JPRB,0.16510E-07_JPRB,0.42192E-07_JPRB /)  
KA(:, 5,13, 1) = (/ &
 & 0.14863E-07_JPRB,0.17307E-07_JPRB,0.17245E-07_JPRB,0.18041E-07_JPRB,0.18314E-07_JPRB, &
 & 0.18445E-07_JPRB,0.19222E-07_JPRB,0.18635E-07_JPRB,0.43353E-07_JPRB /)  
KA(:, 1, 1, 2) = (/ &
 & 0.11698E-08_JPRB,0.30848E-07_JPRB,0.36454E-07_JPRB,0.38710E-07_JPRB,0.45901E-07_JPRB, &
 & 0.55227E-07_JPRB,0.66976E-07_JPRB,0.88407E-07_JPRB,0.23422E-07_JPRB /)  
KA(:, 2, 1, 2) = (/ &
 & 0.11855E-08_JPRB,0.31924E-07_JPRB,0.37139E-07_JPRB,0.40576E-07_JPRB,0.48515E-07_JPRB, &
 & 0.57453E-07_JPRB,0.68267E-07_JPRB,0.87661E-07_JPRB,0.23548E-07_JPRB /)  
KA(:, 3, 1, 2) = (/ &
 & 0.14595E-08_JPRB,0.39594E-07_JPRB,0.49562E-07_JPRB,0.62806E-07_JPRB,0.77187E-07_JPRB, &
 & 0.93412E-07_JPRB,0.11204E-06_JPRB,0.13944E-06_JPRB,0.36327E-07_JPRB /)  
KA(:, 4, 1, 2) = (/ &
 & 0.16033E-08_JPRB,0.32903E-07_JPRB,0.39616E-07_JPRB,0.43600E-07_JPRB,0.51878E-07_JPRB, &
 & 0.61189E-07_JPRB,0.71838E-07_JPRB,0.88579E-07_JPRB,0.23754E-07_JPRB /)  
KA(:, 5, 1, 2) = (/ &
 & 0.16713E-08_JPRB,0.33816E-07_JPRB,0.40271E-07_JPRB,0.44761E-07_JPRB,0.53112E-07_JPRB, &
 & 0.62817E-07_JPRB,0.73214E-07_JPRB,0.89918E-07_JPRB,0.23712E-07_JPRB /)  
KA(:, 1, 2, 2) = (/ &
 & 0.14413E-08_JPRB,0.29542E-07_JPRB,0.33672E-07_JPRB,0.38233E-07_JPRB,0.38429E-07_JPRB, &
 & 0.45175E-07_JPRB,0.55138E-07_JPRB,0.73579E-07_JPRB,0.25050E-07_JPRB /)  
KA(:, 2, 2, 2) = (/ &
 & 0.13819E-08_JPRB,0.33839E-07_JPRB,0.35660E-07_JPRB,0.39637E-07_JPRB,0.40862E-07_JPRB, &
 & 0.47496E-07_JPRB,0.56716E-07_JPRB,0.72256E-07_JPRB,0.25722E-07_JPRB /)  
KA(:, 3, 2, 2) = (/ &
 & 0.14034E-08_JPRB,0.38888E-07_JPRB,0.49224E-07_JPRB,0.54694E-07_JPRB,0.64529E-07_JPRB, &
 & 0.76758E-07_JPRB,0.91615E-07_JPRB,0.11521E-06_JPRB,0.39473E-07_JPRB /)  
KA(:, 4, 2, 2) = (/ &
 & 0.15427E-08_JPRB,0.40736E-07_JPRB,0.49562E-07_JPRB,0.55626E-07_JPRB,0.65520E-07_JPRB, &
 & 0.77421E-07_JPRB,0.92434E-07_JPRB,0.11487E-06_JPRB,0.39089E-07_JPRB /)  
KA(:, 5, 2, 2) = (/ &
 & 0.19146E-08_JPRB,0.37020E-07_JPRB,0.37998E-07_JPRB,0.40828E-07_JPRB,0.46417E-07_JPRB, &
 & 0.52511E-07_JPRB,0.60306E-07_JPRB,0.73583E-07_JPRB,0.26882E-07_JPRB /)  
KA(:, 1, 3, 2) = (/ &
 & 0.16720E-08_JPRB,0.23360E-07_JPRB,0.34106E-07_JPRB,0.35883E-07_JPRB,0.37371E-07_JPRB, &
 & 0.37719E-07_JPRB,0.44564E-07_JPRB,0.59521E-07_JPRB,0.60171E-07_JPRB /)  
KA(:, 2, 3, 2) = (/ &
 & 0.17699E-08_JPRB,0.26546E-07_JPRB,0.36000E-07_JPRB,0.36846E-07_JPRB,0.38381E-07_JPRB, &
 & 0.39667E-07_JPRB,0.46368E-07_JPRB,0.60306E-07_JPRB,0.60604E-07_JPRB /)  
KA(:, 3, 3, 2) = (/ &
 & 0.18009E-08_JPRB,0.29450E-07_JPRB,0.37614E-07_JPRB,0.38630E-07_JPRB,0.39041E-07_JPRB, &
 & 0.41600E-07_JPRB,0.48142E-07_JPRB,0.59638E-07_JPRB,0.61274E-07_JPRB /)  
KA(:, 4, 3, 2) = (/ &
 & 0.18222E-08_JPRB,0.39219E-07_JPRB,0.48109E-07_JPRB,0.53485E-07_JPRB,0.57150E-07_JPRB, &
 & 0.64444E-07_JPRB,0.75574E-07_JPRB,0.94813E-07_JPRB,0.76759E-07_JPRB /)  
KA(:, 5, 3, 2) = (/ &
 & 0.18210E-08_JPRB,0.34020E-07_JPRB,0.40366E-07_JPRB,0.41710E-07_JPRB,0.42164E-07_JPRB, &
 & 0.45001E-07_JPRB,0.49878E-07_JPRB,0.60009E-07_JPRB,0.61481E-07_JPRB /)  
KA(:, 1, 4, 2) = (/ &
 & 0.21152E-08_JPRB,0.23706E-07_JPRB,0.29784E-07_JPRB,0.35302E-07_JPRB,0.35282E-07_JPRB, &
 & 0.34361E-07_JPRB,0.35938E-07_JPRB,0.47065E-07_JPRB,0.17050E-06_JPRB /)  
KA(:, 2, 4, 2) = (/ &
 & 0.22014E-08_JPRB,0.24318E-07_JPRB,0.33239E-07_JPRB,0.37390E-07_JPRB,0.36975E-07_JPRB, &
 & 0.35774E-07_JPRB,0.38207E-07_JPRB,0.49025E-07_JPRB,0.17312E-06_JPRB /)  
KA(:, 3, 4, 2) = (/ &
 & 0.21940E-08_JPRB,0.26005E-07_JPRB,0.37067E-07_JPRB,0.38353E-07_JPRB,0.38894E-07_JPRB, &
 & 0.37527E-07_JPRB,0.40105E-07_JPRB,0.50082E-07_JPRB,0.17777E-06_JPRB /)  
KA(:, 4, 4, 2) = (/ &
 & 0.23140E-08_JPRB,0.28378E-07_JPRB,0.41743E-07_JPRB,0.40523E-07_JPRB,0.40492E-07_JPRB, &
 & 0.38652E-07_JPRB,0.40876E-07_JPRB,0.49640E-07_JPRB,0.18336E-06_JPRB /)  
KA(:, 5, 4, 2) = (/ &
 & 0.23213E-08_JPRB,0.34154E-07_JPRB,0.50461E-07_JPRB,0.52357E-07_JPRB,0.54187E-07_JPRB, &
 & 0.57113E-07_JPRB,0.62843E-07_JPRB,0.77605E-07_JPRB,0.21695E-06_JPRB /)  
KA(:, 1, 5, 2) = (/ &
 & 0.26738E-08_JPRB,0.26329E-07_JPRB,0.23971E-07_JPRB,0.31112E-07_JPRB,0.35671E-07_JPRB, &
 & 0.34087E-07_JPRB,0.29799E-07_JPRB,0.37789E-07_JPRB,0.52514E-06_JPRB /)  
KA(:, 2, 5, 2) = (/ &
 & 0.25455E-08_JPRB,0.28564E-07_JPRB,0.26376E-07_JPRB,0.34876E-07_JPRB,0.38195E-07_JPRB, &
 & 0.36126E-07_JPRB,0.31889E-07_JPRB,0.38787E-07_JPRB,0.53894E-06_JPRB /)  
KA(:, 3, 5, 2) = (/ &
 & 0.27955E-08_JPRB,0.30168E-07_JPRB,0.29598E-07_JPRB,0.39256E-07_JPRB,0.39488E-07_JPRB, &
 & 0.38121E-07_JPRB,0.34110E-07_JPRB,0.40225E-07_JPRB,0.55617E-06_JPRB /)  
KA(:, 4, 5, 2) = (/ &
 & 0.30518E-08_JPRB,0.31696E-07_JPRB,0.32642E-07_JPRB,0.43581E-07_JPRB,0.40810E-07_JPRB, &
 & 0.38887E-07_JPRB,0.35568E-07_JPRB,0.41837E-07_JPRB,0.57141E-06_JPRB /)  
KA(:, 5, 5, 2) = (/ &
 & 0.29545E-08_JPRB,0.34626E-07_JPRB,0.42873E-07_JPRB,0.52742E-07_JPRB,0.53043E-07_JPRB, &
 & 0.52428E-07_JPRB,0.54304E-07_JPRB,0.64247E-07_JPRB,0.63906E-06_JPRB /)  
KA(:, 1, 6, 2) = (/ &
 & 0.30127E-08_JPRB,0.42606E-07_JPRB,0.28980E-07_JPRB,0.24923E-07_JPRB,0.29265E-07_JPRB, &
 & 0.34534E-07_JPRB,0.31090E-07_JPRB,0.30814E-07_JPRB,0.12844E-05_JPRB /)  
KA(:, 2, 6, 2) = (/ &
 & 0.33504E-08_JPRB,0.42102E-07_JPRB,0.30491E-07_JPRB,0.27666E-07_JPRB,0.33477E-07_JPRB, &
 & 0.35643E-07_JPRB,0.33324E-07_JPRB,0.31448E-07_JPRB,0.13231E-05_JPRB /)  
KA(:, 3, 6, 2) = (/ &
 & 0.37714E-08_JPRB,0.40516E-07_JPRB,0.32080E-07_JPRB,0.30623E-07_JPRB,0.37391E-07_JPRB, &
 & 0.37255E-07_JPRB,0.35144E-07_JPRB,0.32296E-07_JPRB,0.13598E-05_JPRB /)  
KA(:, 4, 6, 2) = (/ &
 & 0.40809E-08_JPRB,0.41419E-07_JPRB,0.33638E-07_JPRB,0.33756E-07_JPRB,0.41072E-07_JPRB, &
 & 0.38814E-07_JPRB,0.36264E-07_JPRB,0.33664E-07_JPRB,0.13955E-05_JPRB /)  
KA(:, 5, 6, 2) = (/ &
 & 0.38112E-08_JPRB,0.42764E-07_JPRB,0.35694E-07_JPRB,0.36747E-07_JPRB,0.45193E-07_JPRB, &
 & 0.40460E-07_JPRB,0.37371E-07_JPRB,0.35107E-07_JPRB,0.14282E-05_JPRB /)  
KA(:, 1, 7, 2) = (/ &
 & 0.36577E-08_JPRB,0.64857E-07_JPRB,0.37268E-07_JPRB,0.28977E-07_JPRB,0.24480E-07_JPRB, &
 & 0.26864E-07_JPRB,0.30486E-07_JPRB,0.25122E-07_JPRB,0.20521E-05_JPRB /)  
KA(:, 2, 7, 2) = (/ &
 & 0.39427E-08_JPRB,0.65731E-07_JPRB,0.37248E-07_JPRB,0.30585E-07_JPRB,0.26773E-07_JPRB, &
 & 0.30114E-07_JPRB,0.31576E-07_JPRB,0.26187E-07_JPRB,0.21480E-05_JPRB /)  
KA(:, 3, 7, 2) = (/ &
 & 0.43811E-08_JPRB,0.66809E-07_JPRB,0.38170E-07_JPRB,0.32043E-07_JPRB,0.28837E-07_JPRB, &
 & 0.34005E-07_JPRB,0.32765E-07_JPRB,0.27322E-07_JPRB,0.22122E-05_JPRB /)  
KA(:, 4, 7, 2) = (/ &
 & 0.46591E-08_JPRB,0.68244E-07_JPRB,0.41020E-07_JPRB,0.34183E-07_JPRB,0.31347E-07_JPRB, &
 & 0.37946E-07_JPRB,0.34473E-07_JPRB,0.28264E-07_JPRB,0.22876E-05_JPRB /)  
KA(:, 5, 7, 2) = (/ &
 & 0.51635E-08_JPRB,0.69768E-07_JPRB,0.42241E-07_JPRB,0.36125E-07_JPRB,0.34689E-07_JPRB, &
 & 0.41422E-07_JPRB,0.36208E-07_JPRB,0.29319E-07_JPRB,0.23528E-05_JPRB /)  
KA(:, 1, 8, 2) = (/ &
 & 0.48063E-08_JPRB,0.99492E-07_JPRB,0.67977E-07_JPRB,0.40583E-07_JPRB,0.27462E-07_JPRB, &
 & 0.23261E-07_JPRB,0.24790E-07_JPRB,0.24175E-07_JPRB,0.34404E-05_JPRB /)  
KA(:, 2, 8, 2) = (/ &
 & 0.46794E-08_JPRB,0.10207E-06_JPRB,0.68838E-07_JPRB,0.41170E-07_JPRB,0.30068E-07_JPRB, &
 & 0.24536E-07_JPRB,0.27696E-07_JPRB,0.25318E-07_JPRB,0.35579E-05_JPRB /)  
KA(:, 3, 8, 2) = (/ &
 & 0.51560E-08_JPRB,0.10436E-06_JPRB,0.69782E-07_JPRB,0.42105E-07_JPRB,0.32065E-07_JPRB, &
 & 0.26776E-07_JPRB,0.30613E-07_JPRB,0.26859E-07_JPRB,0.36807E-05_JPRB /)  
KA(:, 4, 8, 2) = (/ &
 & 0.59944E-08_JPRB,0.10484E-06_JPRB,0.71027E-07_JPRB,0.44319E-07_JPRB,0.34843E-07_JPRB, &
 & 0.29788E-07_JPRB,0.33876E-07_JPRB,0.28922E-07_JPRB,0.37740E-05_JPRB /)  
KA(:, 5, 8, 2) = (/ &
 & 0.64682E-08_JPRB,0.10541E-06_JPRB,0.71736E-07_JPRB,0.46124E-07_JPRB,0.36934E-07_JPRB, &
 & 0.32173E-07_JPRB,0.36502E-07_JPRB,0.30991E-07_JPRB,0.38805E-05_JPRB /)  
KA(:, 1, 9, 2) = (/ &
 & 0.56433E-08_JPRB,0.13757E-06_JPRB,0.10641E-06_JPRB,0.72870E-07_JPRB,0.43453E-07_JPRB, &
 & 0.25530E-07_JPRB,0.19778E-07_JPRB,0.25383E-07_JPRB,0.95912E-05_JPRB /)  
KA(:, 2, 9, 2) = (/ &
 & 0.61882E-08_JPRB,0.14041E-06_JPRB,0.11046E-06_JPRB,0.75424E-07_JPRB,0.44204E-07_JPRB, &
 & 0.28513E-07_JPRB,0.22344E-07_JPRB,0.27258E-07_JPRB,0.98257E-05_JPRB /)  
KA(:, 3, 9, 2) = (/ &
 & 0.68724E-08_JPRB,0.14355E-06_JPRB,0.11272E-06_JPRB,0.76977E-07_JPRB,0.44934E-07_JPRB, &
 & 0.30972E-07_JPRB,0.24609E-07_JPRB,0.29074E-07_JPRB,0.10035E-04_JPRB /)  
KA(:, 4, 9, 2) = (/ &
 & 0.75288E-08_JPRB,0.14628E-06_JPRB,0.11397E-06_JPRB,0.77508E-07_JPRB,0.45913E-07_JPRB, &
 & 0.33498E-07_JPRB,0.27308E-07_JPRB,0.31237E-07_JPRB,0.10206E-04_JPRB /)  
KA(:, 5, 9, 2) = (/ &
 & 0.82361E-08_JPRB,0.14989E-06_JPRB,0.11575E-06_JPRB,0.78052E-07_JPRB,0.47282E-07_JPRB, &
 & 0.34986E-07_JPRB,0.29571E-07_JPRB,0.31933E-07_JPRB,0.10332E-04_JPRB /)  
KA(:, 1,10, 2) = (/ &
 & 0.80705E-08_JPRB,0.18916E-06_JPRB,0.16332E-06_JPRB,0.12182E-06_JPRB,0.80167E-07_JPRB, &
 & 0.44659E-07_JPRB,0.24027E-07_JPRB,0.20514E-07_JPRB,0.18076E-04_JPRB /)  
KA(:, 2,10, 2) = (/ &
 & 0.86522E-08_JPRB,0.19825E-06_JPRB,0.16839E-06_JPRB,0.12817E-06_JPRB,0.85984E-07_JPRB, &
 & 0.48117E-07_JPRB,0.24937E-07_JPRB,0.22855E-07_JPRB,0.18392E-04_JPRB /)  
KA(:, 3,10, 2) = (/ &
 & 0.93838E-08_JPRB,0.20474E-06_JPRB,0.17472E-06_JPRB,0.13185E-06_JPRB,0.89897E-07_JPRB, &
 & 0.50484E-07_JPRB,0.27069E-07_JPRB,0.24729E-07_JPRB,0.18827E-04_JPRB /)  
KA(:, 4,10, 2) = (/ &
 & 0.10442E-07_JPRB,0.21110E-06_JPRB,0.17958E-06_JPRB,0.13546E-06_JPRB,0.92462E-07_JPRB, &
 & 0.51368E-07_JPRB,0.29958E-07_JPRB,0.26382E-07_JPRB,0.19325E-04_JPRB /)  
KA(:, 5,10, 2) = (/ &
 & 0.11203E-07_JPRB,0.21676E-06_JPRB,0.18359E-06_JPRB,0.14012E-06_JPRB,0.94090E-07_JPRB, &
 & 0.51431E-07_JPRB,0.32637E-07_JPRB,0.27900E-07_JPRB,0.19654E-04_JPRB /)  
KA(:, 1,11, 2) = (/ &
 & 0.10898E-07_JPRB,0.20490E-06_JPRB,0.23352E-06_JPRB,0.18592E-06_JPRB,0.13108E-06_JPRB, &
 & 0.82594E-07_JPRB,0.41478E-07_JPRB,0.20359E-07_JPRB,0.24656E-04_JPRB /)  
KA(:, 2,11, 2) = (/ &
 & 0.12100E-07_JPRB,0.21595E-06_JPRB,0.24259E-06_JPRB,0.19598E-06_JPRB,0.14307E-06_JPRB, &
 & 0.90287E-07_JPRB,0.44897E-07_JPRB,0.21400E-07_JPRB,0.25439E-04_JPRB /)  
KA(:, 3,11, 2) = (/ &
 & 0.12997E-07_JPRB,0.22559E-06_JPRB,0.25028E-06_JPRB,0.20624E-06_JPRB,0.15074E-06_JPRB, &
 & 0.95763E-07_JPRB,0.46972E-07_JPRB,0.22656E-07_JPRB,0.26128E-04_JPRB /)  
KA(:, 4,11, 2) = (/ &
 & 0.12774E-07_JPRB,0.23494E-06_JPRB,0.26130E-06_JPRB,0.21398E-06_JPRB,0.15730E-06_JPRB, &
 & 0.98985E-07_JPRB,0.48309E-07_JPRB,0.24026E-07_JPRB,0.26834E-04_JPRB /)  
KA(:, 5,11, 2) = (/ &
 & 0.13184E-07_JPRB,0.24219E-06_JPRB,0.26811E-06_JPRB,0.22059E-06_JPRB,0.16314E-06_JPRB, &
 & 0.10271E-06_JPRB,0.49802E-07_JPRB,0.25441E-07_JPRB,0.27644E-04_JPRB /)  
KA(:, 1,12, 2) = (/ &
 & 0.11394E-07_JPRB,0.19172E-06_JPRB,0.27076E-06_JPRB,0.23579E-06_JPRB,0.17648E-06_JPRB, &
 & 0.11366E-06_JPRB,0.56463E-07_JPRB,0.20869E-07_JPRB,0.27151E-04_JPRB /)  
KA(:, 2,12, 2) = (/ &
 & 0.12908E-07_JPRB,0.20309E-06_JPRB,0.28462E-06_JPRB,0.24753E-06_JPRB,0.18719E-06_JPRB, &
 & 0.12033E-06_JPRB,0.60157E-07_JPRB,0.21646E-07_JPRB,0.27962E-04_JPRB /)  
KA(:, 3,12, 2) = (/ &
 & 0.13752E-07_JPRB,0.21619E-06_JPRB,0.29476E-06_JPRB,0.25594E-06_JPRB,0.19641E-06_JPRB, &
 & 0.12734E-06_JPRB,0.64272E-07_JPRB,0.22557E-07_JPRB,0.28912E-04_JPRB /)  
KA(:, 4,12, 2) = (/ &
 & 0.14906E-07_JPRB,0.22665E-06_JPRB,0.30298E-06_JPRB,0.26272E-06_JPRB,0.20331E-06_JPRB, &
 & 0.13316E-06_JPRB,0.68243E-07_JPRB,0.23417E-07_JPRB,0.29816E-04_JPRB /)  
KA(:, 5,12, 2) = (/ &
 & 0.15969E-07_JPRB,0.23477E-06_JPRB,0.31068E-06_JPRB,0.27029E-06_JPRB,0.20850E-06_JPRB, &
 & 0.13902E-06_JPRB,0.71857E-07_JPRB,0.25264E-07_JPRB,0.30765E-04_JPRB /)  
KA(:, 1,13, 2) = (/ &
 & 0.13593E-07_JPRB,0.19801E-06_JPRB,0.26490E-06_JPRB,0.27826E-06_JPRB,0.22531E-06_JPRB, &
 & 0.15112E-06_JPRB,0.78691E-07_JPRB,0.27273E-07_JPRB,0.28055E-04_JPRB /)  
KA(:, 2,13, 2) = (/ &
 & 0.15426E-07_JPRB,0.20839E-06_JPRB,0.27732E-06_JPRB,0.28785E-06_JPRB,0.23371E-06_JPRB, &
 & 0.16027E-06_JPRB,0.86131E-07_JPRB,0.29011E-07_JPRB,0.29165E-04_JPRB /)  
KA(:, 3,13, 2) = (/ &
 & 0.16638E-07_JPRB,0.21808E-06_JPRB,0.28896E-06_JPRB,0.29666E-06_JPRB,0.24201E-06_JPRB, &
 & 0.16845E-06_JPRB,0.91791E-07_JPRB,0.30670E-07_JPRB,0.30372E-04_JPRB /)  
KA(:, 4,13, 2) = (/ &
 & 0.17929E-07_JPRB,0.22577E-06_JPRB,0.29798E-06_JPRB,0.30533E-06_JPRB,0.24895E-06_JPRB, &
 & 0.17573E-06_JPRB,0.96085E-07_JPRB,0.31360E-07_JPRB,0.31437E-04_JPRB /)  
KA(:, 5,13, 2) = (/ &
 & 0.18861E-07_JPRB,0.23397E-06_JPRB,0.30715E-06_JPRB,0.31382E-06_JPRB,0.25665E-06_JPRB, &
 & 0.18246E-06_JPRB,0.10017E-06_JPRB,0.32454E-07_JPRB,0.32266E-04_JPRB /)  
KA(:, 1, 1, 3) = (/ &
 & 0.39751E-08_JPRB,0.10094E-06_JPRB,0.20247E-06_JPRB,0.30028E-06_JPRB,0.39102E-06_JPRB, &
 & 0.48711E-06_JPRB,0.59106E-06_JPRB,0.72709E-06_JPRB,0.20885E-06_JPRB /)  
KA(:, 2, 1, 3) = (/ &
 & 0.43080E-08_JPRB,0.10546E-06_JPRB,0.20982E-06_JPRB,0.31135E-06_JPRB,0.40303E-06_JPRB, &
 & 0.49632E-06_JPRB,0.59855E-06_JPRB,0.74477E-06_JPRB,0.21012E-06_JPRB /)  
KA(:, 3, 1, 3) = (/ &
 & 0.42986E-08_JPRB,0.15269E-06_JPRB,0.29890E-06_JPRB,0.43493E-06_JPRB,0.56429E-06_JPRB, &
 & 0.69336E-06_JPRB,0.83181E-06_JPRB,0.10423E-05_JPRB,0.36557E-06_JPRB /)  
KA(:, 4, 1, 3) = (/ &
 & 0.43554E-08_JPRB,0.11271E-06_JPRB,0.22069E-06_JPRB,0.32651E-06_JPRB,0.42391E-06_JPRB, &
 & 0.51393E-06_JPRB,0.61294E-06_JPRB,0.75229E-06_JPRB,0.20945E-06_JPRB /)  
KA(:, 5, 1, 3) = (/ &
 & 0.45047E-08_JPRB,0.11576E-06_JPRB,0.22657E-06_JPRB,0.33173E-06_JPRB,0.43142E-06_JPRB, &
 & 0.52151E-06_JPRB,0.61871E-06_JPRB,0.74980E-06_JPRB,0.20891E-06_JPRB /)  
KA(:, 1, 2, 3) = (/ &
 & 0.46065E-08_JPRB,0.81519E-07_JPRB,0.15960E-06_JPRB,0.23610E-06_JPRB,0.31656E-06_JPRB, &
 & 0.39839E-06_JPRB,0.48591E-06_JPRB,0.60182E-06_JPRB,0.18230E-06_JPRB /)  
KA(:, 2, 2, 3) = (/ &
 & 0.46837E-08_JPRB,0.82106E-07_JPRB,0.16429E-06_JPRB,0.24471E-06_JPRB,0.32626E-06_JPRB, &
 & 0.40531E-06_JPRB,0.49330E-06_JPRB,0.61810E-06_JPRB,0.18355E-06_JPRB /)  
KA(:, 3, 2, 3) = (/ &
 & 0.50163E-08_JPRB,0.12328E-06_JPRB,0.23602E-06_JPRB,0.35332E-06_JPRB,0.46387E-06_JPRB, &
 & 0.57515E-06_JPRB,0.69445E-06_JPRB,0.88167E-06_JPRB,0.30546E-06_JPRB /)  
KA(:, 4, 2, 3) = (/ &
 & 0.49809E-08_JPRB,0.12454E-06_JPRB,0.23839E-06_JPRB,0.35429E-06_JPRB,0.46515E-06_JPRB, &
 & 0.57491E-06_JPRB,0.69031E-06_JPRB,0.86630E-06_JPRB,0.29807E-06_JPRB /)  
KA(:, 5, 2, 3) = (/ &
 & 0.51988E-08_JPRB,0.91291E-07_JPRB,0.17869E-06_JPRB,0.26485E-06_JPRB,0.34907E-06_JPRB, &
 & 0.42509E-06_JPRB,0.50894E-06_JPRB,0.62361E-06_JPRB,0.18234E-06_JPRB /)  
KA(:, 1, 3, 3) = (/ &
 & 0.51916E-08_JPRB,0.88867E-07_JPRB,0.12220E-06_JPRB,0.18411E-06_JPRB,0.24720E-06_JPRB, &
 & 0.32303E-06_JPRB,0.39526E-06_JPRB,0.49595E-06_JPRB,0.27125E-06_JPRB /)  
KA(:, 2, 3, 3) = (/ &
 & 0.56319E-08_JPRB,0.87189E-07_JPRB,0.12678E-06_JPRB,0.19176E-06_JPRB,0.25624E-06_JPRB, &
 & 0.32740E-06_JPRB,0.40564E-06_JPRB,0.50601E-06_JPRB,0.28010E-06_JPRB /)  
KA(:, 3, 3, 3) = (/ &
 & 0.59026E-08_JPRB,0.86017E-07_JPRB,0.13043E-06_JPRB,0.19649E-06_JPRB,0.26497E-06_JPRB, &
 & 0.33305E-06_JPRB,0.40679E-06_JPRB,0.51963E-06_JPRB,0.28660E-06_JPRB /)  
KA(:, 4, 3, 3) = (/ &
 & 0.59909E-08_JPRB,0.10759E-06_JPRB,0.18790E-06_JPRB,0.28104E-06_JPRB,0.37702E-06_JPRB, &
 & 0.47222E-06_JPRB,0.57322E-06_JPRB,0.72906E-06_JPRB,0.37657E-06_JPRB /)  
KA(:, 5, 3, 3) = (/ &
 & 0.64422E-08_JPRB,0.89472E-07_JPRB,0.13687E-06_JPRB,0.20453E-06_JPRB,0.27802E-06_JPRB, &
 & 0.34266E-06_JPRB,0.41565E-06_JPRB,0.51746E-06_JPRB,0.29675E-06_JPRB /)  
KA(:, 1, 4, 3) = (/ &
 & 0.62298E-08_JPRB,0.99509E-07_JPRB,0.10306E-06_JPRB,0.14232E-06_JPRB,0.19390E-06_JPRB, &
 & 0.25435E-06_JPRB,0.31764E-06_JPRB,0.40578E-06_JPRB,0.49031E-06_JPRB /)  
KA(:, 2, 4, 3) = (/ &
 & 0.68419E-08_JPRB,0.10415E-06_JPRB,0.10349E-06_JPRB,0.14672E-06_JPRB,0.19860E-06_JPRB, &
 & 0.26012E-06_JPRB,0.32720E-06_JPRB,0.41327E-06_JPRB,0.51522E-06_JPRB /)  
KA(:, 3, 4, 3) = (/ &
 & 0.71418E-08_JPRB,0.10626E-06_JPRB,0.10522E-06_JPRB,0.15175E-06_JPRB,0.20471E-06_JPRB, &
 & 0.26435E-06_JPRB,0.33148E-06_JPRB,0.42294E-06_JPRB,0.53456E-06_JPRB /)  
KA(:, 4, 4, 3) = (/ &
 & 0.72470E-08_JPRB,0.10891E-06_JPRB,0.10648E-06_JPRB,0.15457E-06_JPRB,0.21007E-06_JPRB, &
 & 0.26937E-06_JPRB,0.33376E-06_JPRB,0.42939E-06_JPRB,0.55207E-06_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


SUBROUTINE PART3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART3',0,ZHOOK_HANDLE)


KA(:, 5, 4, 3) = (/ &
 & 0.77585E-08_JPRB,0.12954E-06_JPRB,0.14999E-06_JPRB,0.22224E-06_JPRB,0.29994E-06_JPRB, &
 & 0.38053E-06_JPRB,0.47027E-06_JPRB,0.60032E-06_JPRB,0.76592E-06_JPRB /)  
KA(:, 1, 5, 3) = (/ &
 & 0.68852E-08_JPRB,0.11288E-06_JPRB,0.11969E-06_JPRB,0.11689E-06_JPRB,0.14994E-06_JPRB, &
 & 0.19637E-06_JPRB,0.25309E-06_JPRB,0.33018E-06_JPRB,0.84551E-06_JPRB /)  
KA(:, 2, 5, 3) = (/ &
 & 0.75119E-08_JPRB,0.11838E-06_JPRB,0.12255E-06_JPRB,0.11926E-06_JPRB,0.15341E-06_JPRB, &
 & 0.20169E-06_JPRB,0.26231E-06_JPRB,0.33745E-06_JPRB,0.85714E-06_JPRB /)  
KA(:, 3, 5, 3) = (/ &
 & 0.84416E-08_JPRB,0.12128E-06_JPRB,0.12324E-06_JPRB,0.12015E-06_JPRB,0.15812E-06_JPRB, &
 & 0.20463E-06_JPRB,0.26808E-06_JPRB,0.34461E-06_JPRB,0.86734E-06_JPRB /)  
KA(:, 4, 5, 3) = (/ &
 & 0.92293E-08_JPRB,0.12493E-06_JPRB,0.12330E-06_JPRB,0.12093E-06_JPRB,0.16146E-06_JPRB, &
 & 0.20899E-06_JPRB,0.26904E-06_JPRB,0.35101E-06_JPRB,0.88204E-06_JPRB /)  
KA(:, 5, 5, 3) = (/ &
 & 0.10279E-07_JPRB,0.14631E-06_JPRB,0.14078E-06_JPRB,0.17511E-06_JPRB,0.23546E-06_JPRB, &
 & 0.30442E-06_JPRB,0.38374E-06_JPRB,0.50000E-06_JPRB,0.10431E-05_JPRB /)  
KA(:, 1, 6, 3) = (/ &
 & 0.51921E-08_JPRB,0.14437E-06_JPRB,0.12917E-06_JPRB,0.11673E-06_JPRB,0.12444E-06_JPRB, &
 & 0.14966E-06_JPRB,0.19338E-06_JPRB,0.26674E-06_JPRB,0.16987E-05_JPRB /)  
KA(:, 2, 6, 3) = (/ &
 & 0.69052E-08_JPRB,0.14822E-06_JPRB,0.13564E-06_JPRB,0.12080E-06_JPRB,0.12884E-06_JPRB, &
 & 0.15616E-06_JPRB,0.20083E-06_JPRB,0.27373E-06_JPRB,0.17147E-05_JPRB /)  
KA(:, 3, 6, 3) = (/ &
 & 0.93932E-08_JPRB,0.15309E-06_JPRB,0.13785E-06_JPRB,0.12361E-06_JPRB,0.12904E-06_JPRB, &
 & 0.16004E-06_JPRB,0.20790E-06_JPRB,0.27928E-06_JPRB,0.17384E-05_JPRB /)  
KA(:, 4, 6, 3) = (/ &
 & 0.10364E-07_JPRB,0.15577E-06_JPRB,0.14281E-06_JPRB,0.12445E-06_JPRB,0.13032E-06_JPRB, &
 & 0.16178E-06_JPRB,0.21225E-06_JPRB,0.28499E-06_JPRB,0.17733E-05_JPRB /)  
KA(:, 5, 6, 3) = (/ &
 & 0.10950E-07_JPRB,0.15768E-06_JPRB,0.14728E-06_JPRB,0.12674E-06_JPRB,0.12961E-06_JPRB, &
 & 0.16455E-06_JPRB,0.21080E-06_JPRB,0.28744E-06_JPRB,0.17869E-05_JPRB /)  
KA(:, 1, 7, 3) = (/ &
 & 0.51527E-08_JPRB,0.13331E-06_JPRB,0.15220E-06_JPRB,0.13781E-06_JPRB,0.11791E-06_JPRB, &
 & 0.12291E-06_JPRB,0.14839E-06_JPRB,0.21430E-06_JPRB,0.45802E-05_JPRB /)  
KA(:, 2, 7, 3) = (/ &
 & 0.52409E-08_JPRB,0.14109E-06_JPRB,0.15809E-06_JPRB,0.14393E-06_JPRB,0.12362E-06_JPRB, &
 & 0.12831E-06_JPRB,0.15572E-06_JPRB,0.22059E-06_JPRB,0.46088E-05_JPRB /)  
KA(:, 3, 7, 3) = (/ &
 & 0.66901E-08_JPRB,0.14833E-06_JPRB,0.16524E-06_JPRB,0.14893E-06_JPRB,0.12670E-06_JPRB, &
 & 0.13152E-06_JPRB,0.16110E-06_JPRB,0.22404E-06_JPRB,0.46200E-05_JPRB /)  
KA(:, 4, 7, 3) = (/ &
 & 0.90836E-08_JPRB,0.15267E-06_JPRB,0.17113E-06_JPRB,0.15541E-06_JPRB,0.12966E-06_JPRB, &
 & 0.13240E-06_JPRB,0.16410E-06_JPRB,0.22868E-06_JPRB,0.45999E-05_JPRB /)  
KA(:, 5, 7, 3) = (/ &
 & 0.11721E-07_JPRB,0.15605E-06_JPRB,0.17580E-06_JPRB,0.16064E-06_JPRB,0.13194E-06_JPRB, &
 & 0.13127E-06_JPRB,0.16676E-06_JPRB,0.23245E-06_JPRB,0.46103E-05_JPRB /)  
KA(:, 1, 8, 3) = (/ &
 & 0.53770E-08_JPRB,0.12906E-06_JPRB,0.19117E-06_JPRB,0.16928E-06_JPRB,0.14454E-06_JPRB, &
 & 0.11318E-06_JPRB,0.12091E-06_JPRB,0.16771E-06_JPRB,0.10838E-04_JPRB /)  
KA(:, 2, 8, 3) = (/ &
 & 0.71217E-08_JPRB,0.13171E-06_JPRB,0.20115E-06_JPRB,0.17525E-06_JPRB,0.15189E-06_JPRB, &
 & 0.11980E-06_JPRB,0.12589E-06_JPRB,0.17247E-06_JPRB,0.10844E-04_JPRB /)  
KA(:, 3, 8, 3) = (/ &
 & 0.76051E-08_JPRB,0.13463E-06_JPRB,0.20837E-06_JPRB,0.18092E-06_JPRB,0.15831E-06_JPRB, &
 & 0.12491E-06_JPRB,0.12782E-06_JPRB,0.17568E-06_JPRB,0.10855E-04_JPRB /)  
KA(:, 4, 8, 3) = (/ &
 & 0.87276E-08_JPRB,0.14002E-06_JPRB,0.21488E-06_JPRB,0.18616E-06_JPRB,0.16272E-06_JPRB, &
 & 0.12991E-06_JPRB,0.13139E-06_JPRB,0.17775E-06_JPRB,0.10873E-04_JPRB /)  
KA(:, 5, 8, 3) = (/ &
 & 0.98102E-08_JPRB,0.14390E-06_JPRB,0.21715E-06_JPRB,0.19383E-06_JPRB,0.16843E-06_JPRB, &
 & 0.13102E-06_JPRB,0.13320E-06_JPRB,0.18001E-06_JPRB,0.10883E-04_JPRB /)  
KA(:, 1, 9, 3) = (/ &
 & 0.78846E-08_JPRB,0.14921E-06_JPRB,0.16266E-06_JPRB,0.21810E-06_JPRB,0.17257E-06_JPRB, &
 & 0.13914E-06_JPRB,0.10621E-06_JPRB,0.13009E-06_JPRB,0.22193E-04_JPRB /)  
KA(:, 2, 9, 3) = (/ &
 & 0.87670E-08_JPRB,0.15667E-06_JPRB,0.17179E-06_JPRB,0.22870E-06_JPRB,0.18453E-06_JPRB, &
 & 0.14806E-06_JPRB,0.11198E-06_JPRB,0.13228E-06_JPRB,0.22470E-04_JPRB /)  
KA(:, 3, 9, 3) = (/ &
 & 0.94042E-08_JPRB,0.16331E-06_JPRB,0.17929E-06_JPRB,0.23732E-06_JPRB,0.19309E-06_JPRB, &
 & 0.15669E-06_JPRB,0.11769E-06_JPRB,0.13462E-06_JPRB,0.22759E-04_JPRB /)  
KA(:, 4, 9, 3) = (/ &
 & 0.10052E-07_JPRB,0.16738E-06_JPRB,0.18654E-06_JPRB,0.24428E-06_JPRB,0.19714E-06_JPRB, &
 & 0.16469E-06_JPRB,0.12194E-06_JPRB,0.13694E-06_JPRB,0.23037E-04_JPRB /)  
KA(:, 5, 9, 3) = (/ &
 & 0.99609E-08_JPRB,0.16974E-06_JPRB,0.19096E-06_JPRB,0.25212E-06_JPRB,0.20604E-06_JPRB, &
 & 0.17005E-06_JPRB,0.12529E-06_JPRB,0.13965E-06_JPRB,0.23331E-04_JPRB /)  
KA(:, 1,10, 3) = (/ &
 & 0.10600E-07_JPRB,0.19194E-06_JPRB,0.19694E-06_JPRB,0.19228E-06_JPRB,0.23306E-06_JPRB, &
 & 0.18017E-06_JPRB,0.13563E-06_JPRB,0.11106E-06_JPRB,0.57833E-04_JPRB /)  
KA(:, 2,10, 3) = (/ &
 & 0.11513E-07_JPRB,0.19670E-06_JPRB,0.20600E-06_JPRB,0.20153E-06_JPRB,0.24712E-06_JPRB, &
 & 0.19420E-06_JPRB,0.14374E-06_JPRB,0.11223E-06_JPRB,0.59252E-04_JPRB /)  
KA(:, 3,10, 3) = (/ &
 & 0.12267E-07_JPRB,0.20052E-06_JPRB,0.21125E-06_JPRB,0.21502E-06_JPRB,0.25879E-06_JPRB, &
 & 0.20809E-06_JPRB,0.15257E-06_JPRB,0.11412E-06_JPRB,0.60474E-04_JPRB /)  
KA(:, 4,10, 3) = (/ &
 & 0.11377E-07_JPRB,0.20485E-06_JPRB,0.21479E-06_JPRB,0.22527E-06_JPRB,0.26884E-06_JPRB, &
 & 0.21723E-06_JPRB,0.15872E-06_JPRB,0.11733E-06_JPRB,0.61380E-04_JPRB /)  
KA(:, 5,10, 3) = (/ &
 & 0.12141E-07_JPRB,0.20611E-06_JPRB,0.22439E-06_JPRB,0.22986E-06_JPRB,0.27411E-06_JPRB, &
 & 0.22402E-06_JPRB,0.16342E-06_JPRB,0.11916E-06_JPRB,0.62353E-04_JPRB /)  
KA(:, 1,11, 3) = (/ &
 & 0.12251E-07_JPRB,0.29022E-06_JPRB,0.24496E-06_JPRB,0.24059E-06_JPRB,0.21631E-06_JPRB, &
 & 0.23923E-06_JPRB,0.16597E-06_JPRB,0.10842E-06_JPRB,0.80074E-04_JPRB /)  
KA(:, 2,11, 3) = (/ &
 & 0.12224E-07_JPRB,0.29680E-06_JPRB,0.25368E-06_JPRB,0.24691E-06_JPRB,0.22294E-06_JPRB, &
 & 0.24912E-06_JPRB,0.17747E-06_JPRB,0.10969E-06_JPRB,0.81125E-04_JPRB /)  
KA(:, 3,11, 3) = (/ &
 & 0.14264E-07_JPRB,0.29886E-06_JPRB,0.26040E-06_JPRB,0.25256E-06_JPRB,0.23184E-06_JPRB, &
 & 0.25957E-06_JPRB,0.18845E-06_JPRB,0.11123E-06_JPRB,0.82960E-04_JPRB /)  
KA(:, 4,11, 3) = (/ &
 & 0.16608E-07_JPRB,0.30056E-06_JPRB,0.26198E-06_JPRB,0.25724E-06_JPRB,0.23897E-06_JPRB, &
 & 0.26977E-06_JPRB,0.19716E-06_JPRB,0.11521E-06_JPRB,0.84911E-04_JPRB /)  
KA(:, 5,11, 3) = (/ &
 & 0.18982E-07_JPRB,0.30200E-06_JPRB,0.26559E-06_JPRB,0.26090E-06_JPRB,0.24427E-06_JPRB, &
 & 0.27763E-06_JPRB,0.20825E-06_JPRB,0.11858E-06_JPRB,0.86586E-04_JPRB /)  
KA(:, 1,12, 3) = (/ &
 & 0.16186E-07_JPRB,0.36864E-06_JPRB,0.27735E-06_JPRB,0.24475E-06_JPRB,0.23659E-06_JPRB, &
 & 0.20178E-06_JPRB,0.20651E-06_JPRB,0.11504E-06_JPRB,0.90323E-04_JPRB /)  
KA(:, 2,12, 3) = (/ &
 & 0.16900E-07_JPRB,0.36903E-06_JPRB,0.27865E-06_JPRB,0.25015E-06_JPRB,0.24279E-06_JPRB, &
 & 0.21379E-06_JPRB,0.22149E-06_JPRB,0.12739E-06_JPRB,0.92788E-04_JPRB /)  
KA(:, 3,12, 3) = (/ &
 & 0.18900E-07_JPRB,0.36546E-06_JPRB,0.28369E-06_JPRB,0.25919E-06_JPRB,0.24650E-06_JPRB, &
 & 0.22349E-06_JPRB,0.23741E-06_JPRB,0.13455E-06_JPRB,0.94381E-04_JPRB /)  
KA(:, 4,12, 3) = (/ &
 & 0.24666E-07_JPRB,0.36289E-06_JPRB,0.28992E-06_JPRB,0.26755E-06_JPRB,0.25261E-06_JPRB, &
 & 0.23012E-06_JPRB,0.24862E-06_JPRB,0.14012E-06_JPRB,0.95689E-04_JPRB /)  
KA(:, 5,12, 3) = (/ &
 & 0.28047E-07_JPRB,0.36144E-06_JPRB,0.29439E-06_JPRB,0.27280E-06_JPRB,0.25910E-06_JPRB, &
 & 0.23527E-06_JPRB,0.25804E-06_JPRB,0.14441E-06_JPRB,0.97273E-04_JPRB /)  
KA(:, 1,13, 3) = (/ &
 & 0.27099E-07_JPRB,0.42452E-06_JPRB,0.36469E-06_JPRB,0.28012E-06_JPRB,0.24206E-06_JPRB, &
 & 0.21452E-06_JPRB,0.19737E-06_JPRB,0.12552E-06_JPRB,0.93221E-04_JPRB /)  
KA(:, 2,13, 3) = (/ &
 & 0.30641E-07_JPRB,0.42348E-06_JPRB,0.36821E-06_JPRB,0.29049E-06_JPRB,0.25191E-06_JPRB, &
 & 0.22447E-06_JPRB,0.20459E-06_JPRB,0.13174E-06_JPRB,0.95326E-04_JPRB /)  
KA(:, 3,13, 3) = (/ &
 & 0.31538E-07_JPRB,0.42218E-06_JPRB,0.36978E-06_JPRB,0.29801E-06_JPRB,0.26042E-06_JPRB, &
 & 0.23413E-06_JPRB,0.21354E-06_JPRB,0.13999E-06_JPRB,0.97244E-04_JPRB /)  
KA(:, 4,13, 3) = (/ &
 & 0.33087E-07_JPRB,0.42233E-06_JPRB,0.36980E-06_JPRB,0.30223E-06_JPRB,0.26697E-06_JPRB, &
 & 0.24077E-06_JPRB,0.22289E-06_JPRB,0.14849E-06_JPRB,0.99282E-04_JPRB /)  
KA(:, 5,13, 3) = (/ &
 & 0.35771E-07_JPRB,0.42124E-06_JPRB,0.36949E-06_JPRB,0.30814E-06_JPRB,0.27423E-06_JPRB, &
 & 0.24510E-06_JPRB,0.22998E-06_JPRB,0.15431E-06_JPRB,0.10189E-03_JPRB /)  
KA(:, 1, 1, 4) = (/ &
 & 0.60599E-08_JPRB,0.49839E-06_JPRB,0.90796E-06_JPRB,0.12825E-05_JPRB,0.16387E-05_JPRB, &
 & 0.20000E-05_JPRB,0.24097E-05_JPRB,0.30198E-05_JPRB,0.14012E-05_JPRB /)  
KA(:, 2, 1, 4) = (/ &
 & 0.57361E-08_JPRB,0.51373E-06_JPRB,0.93344E-06_JPRB,0.13150E-05_JPRB,0.16776E-05_JPRB, &
 & 0.20412E-05_JPRB,0.24476E-05_JPRB,0.30155E-05_JPRB,0.14079E-05_JPRB /)  
KA(:, 3, 1, 4) = (/ &
 & 0.61895E-08_JPRB,0.64074E-06_JPRB,0.11706E-05_JPRB,0.16523E-05_JPRB,0.21138E-05_JPRB, &
 & 0.25765E-05_JPRB,0.30714E-05_JPRB,0.37148E-05_JPRB,0.20046E-05_JPRB /)  
KA(:, 4, 1, 4) = (/ &
 & 0.63590E-08_JPRB,0.53918E-06_JPRB,0.97233E-06_JPRB,0.13614E-05_JPRB,0.17274E-05_JPRB, &
 & 0.21018E-05_JPRB,0.24992E-05_JPRB,0.30391E-05_JPRB,0.14106E-05_JPRB /)  
KA(:, 5, 1, 4) = (/ &
 & 0.66907E-08_JPRB,0.54769E-06_JPRB,0.98459E-06_JPRB,0.13756E-05_JPRB,0.17428E-05_JPRB, &
 & 0.21216E-05_JPRB,0.25190E-05_JPRB,0.30528E-05_JPRB,0.14057E-05_JPRB /)  
KA(:, 1, 2, 4) = (/ &
 & 0.63247E-08_JPRB,0.40976E-06_JPRB,0.75743E-06_JPRB,0.10729E-05_JPRB,0.13776E-05_JPRB, &
 & 0.16847E-05_JPRB,0.20386E-05_JPRB,0.25923E-05_JPRB,0.11016E-05_JPRB /)  
KA(:, 2, 2, 4) = (/ &
 & 0.71971E-08_JPRB,0.42277E-06_JPRB,0.77866E-06_JPRB,0.11006E-05_JPRB,0.14075E-05_JPRB, &
 & 0.17208E-05_JPRB,0.20689E-05_JPRB,0.25842E-05_JPRB,0.11093E-05_JPRB /)  
KA(:, 3, 2, 4) = (/ &
 & 0.68862E-08_JPRB,0.54111E-06_JPRB,0.99924E-06_JPRB,0.14135E-05_JPRB,0.18137E-05_JPRB, &
 & 0.22190E-05_JPRB,0.26613E-05_JPRB,0.32636E-05_JPRB,0.16377E-05_JPRB /)  
KA(:, 4, 2, 4) = (/ &
 & 0.74570E-08_JPRB,0.54374E-06_JPRB,0.10016E-05_JPRB,0.14142E-05_JPRB,0.18118E-05_JPRB, &
 & 0.22093E-05_JPRB,0.26451E-05_JPRB,0.32306E-05_JPRB,0.16062E-05_JPRB /)  
KA(:, 5, 2, 4) = (/ &
 & 0.76975E-08_JPRB,0.44890E-06_JPRB,0.82016E-06_JPRB,0.11488E-05_JPRB,0.14591E-05_JPRB, &
 & 0.17814E-05_JPRB,0.21241E-05_JPRB,0.26089E-05_JPRB,0.11145E-05_JPRB /)  
KA(:, 1, 3, 4) = (/ &
 & 0.83656E-08_JPRB,0.31311E-06_JPRB,0.61949E-06_JPRB,0.88176E-06_JPRB,0.11379E-05_JPRB, &
 & 0.13977E-05_JPRB,0.17043E-05_JPRB,0.22078E-05_JPRB,0.73836E-06_JPRB /)  
KA(:, 2, 3, 4) = (/ &
 & 0.85171E-08_JPRB,0.32573E-06_JPRB,0.63573E-06_JPRB,0.90517E-06_JPRB,0.11641E-05_JPRB, &
 & 0.14286E-05_JPRB,0.17247E-05_JPRB,0.21938E-05_JPRB,0.74285E-06_JPRB /)  
KA(:, 3, 3, 4) = (/ &
 & 0.78702E-08_JPRB,0.33673E-06_JPRB,0.64948E-06_JPRB,0.92347E-06_JPRB,0.11844E-05_JPRB, &
 & 0.14525E-05_JPRB,0.17473E-05_JPRB,0.21823E-05_JPRB,0.74417E-06_JPRB /)  
KA(:, 4, 3, 4) = (/ &
 & 0.88135E-08_JPRB,0.44484E-06_JPRB,0.84006E-06_JPRB,0.11924E-05_JPRB,0.15326E-05_JPRB, &
 & 0.18766E-05_JPRB,0.22592E-05_JPRB,0.27980E-05_JPRB,0.11629E-05_JPRB /)  
KA(:, 5, 3, 4) = (/ &
 & 0.83594E-08_JPRB,0.34852E-06_JPRB,0.67171E-06_JPRB,0.94786E-06_JPRB,0.12080E-05_JPRB, &
 & 0.14818E-05_JPRB,0.17721E-05_JPRB,0.22017E-05_JPRB,0.74162E-06_JPRB /)  
KA(:, 1, 4, 4) = (/ &
 & 0.82233E-08_JPRB,0.22714E-06_JPRB,0.49574E-06_JPRB,0.71618E-06_JPRB,0.92897E-06_JPRB, &
 & 0.11522E-05_JPRB,0.14150E-05_JPRB,0.18749E-05_JPRB,0.10829E-05_JPRB /)  
KA(:, 2, 4, 4) = (/ &
 & 0.90906E-08_JPRB,0.23281E-06_JPRB,0.51082E-06_JPRB,0.73615E-06_JPRB,0.95322E-06_JPRB, &
 & 0.11749E-05_JPRB,0.14287E-05_JPRB,0.18456E-05_JPRB,0.10964E-05_JPRB /)  
KA(:, 3, 4, 4) = (/ &
 & 0.10403E-07_JPRB,0.23873E-06_JPRB,0.52083E-06_JPRB,0.75142E-06_JPRB,0.97057E-06_JPRB, &
 & 0.11959E-05_JPRB,0.14456E-05_JPRB,0.18299E-05_JPRB,0.11024E-05_JPRB /)  
KA(:, 4, 4, 4) = (/ &
 & 0.11681E-07_JPRB,0.24287E-06_JPRB,0.52982E-06_JPRB,0.76518E-06_JPRB,0.98418E-06_JPRB, &
 & 0.12105E-05_JPRB,0.14593E-05_JPRB,0.18314E-05_JPRB,0.11002E-05_JPRB /)  
KA(:, 5, 4, 4) = (/ &
 & 0.11781E-07_JPRB,0.32919E-06_JPRB,0.69041E-06_JPRB,0.99008E-06_JPRB,0.12781E-05_JPRB, &
 & 0.15684E-05_JPRB,0.18900E-05_JPRB,0.23626E-05_JPRB,0.11507E-05_JPRB /)  
KA(:, 1, 5, 4) = (/ &
 & 0.10746E-07_JPRB,0.16960E-06_JPRB,0.36271E-06_JPRB,0.57393E-06_JPRB,0.75088E-06_JPRB, &
 & 0.94078E-06_JPRB,0.11700E-05_JPRB,0.15610E-05_JPRB,0.23060E-05_JPRB /)  
KA(:, 2, 5, 4) = (/ &
 & 0.12322E-07_JPRB,0.17145E-06_JPRB,0.37466E-06_JPRB,0.58975E-06_JPRB,0.77156E-06_JPRB, &
 & 0.96051E-06_JPRB,0.11773E-05_JPRB,0.15431E-05_JPRB,0.23550E-05_JPRB /)  
KA(:, 3, 5, 4) = (/ &
 & 0.12362E-07_JPRB,0.17491E-06_JPRB,0.38517E-06_JPRB,0.60273E-06_JPRB,0.78779E-06_JPRB, &
 & 0.97831E-06_JPRB,0.11895E-05_JPRB,0.15264E-05_JPRB,0.23946E-05_JPRB /)  
KA(:, 4, 5, 4) = (/ &
 & 0.11932E-07_JPRB,0.17603E-06_JPRB,0.39310E-06_JPRB,0.61276E-06_JPRB,0.80198E-06_JPRB, &
 & 0.99168E-06_JPRB,0.12014E-05_JPRB,0.15209E-05_JPRB,0.24122E-05_JPRB /)  
KA(:, 5, 5, 4) = (/ &
 & 0.12827E-07_JPRB,0.23797E-06_JPRB,0.54915E-06_JPRB,0.81314E-06_JPRB,0.10605E-05_JPRB, &
 & 0.13079E-05_JPRB,0.15848E-05_JPRB,0.19982E-05_JPRB,0.26265E-05_JPRB /)  
KA(:, 1, 6, 4) = (/ &
 & 0.16887E-07_JPRB,0.16918E-06_JPRB,0.26182E-06_JPRB,0.43955E-06_JPRB,0.59876E-06_JPRB, &
 & 0.76220E-06_JPRB,0.96205E-06_JPRB,0.12977E-05_JPRB,0.30196E-05_JPRB /)  
KA(:, 2, 6, 4) = (/ &
 & 0.16463E-07_JPRB,0.17256E-06_JPRB,0.26723E-06_JPRB,0.45266E-06_JPRB,0.61330E-06_JPRB, &
 & 0.77949E-06_JPRB,0.96881E-06_JPRB,0.12938E-05_JPRB,0.31027E-05_JPRB /)  
KA(:, 3, 6, 4) = (/ &
 & 0.14297E-07_JPRB,0.17174E-06_JPRB,0.27626E-06_JPRB,0.46141E-06_JPRB,0.62873E-06_JPRB, &
 & 0.79335E-06_JPRB,0.97523E-06_JPRB,0.12716E-05_JPRB,0.31487E-05_JPRB /)  
KA(:, 4, 6, 4) = (/ &
 & 0.15984E-07_JPRB,0.17093E-06_JPRB,0.27951E-06_JPRB,0.46972E-06_JPRB,0.64062E-06_JPRB, &
 & 0.80616E-06_JPRB,0.98183E-06_JPRB,0.12602E-05_JPRB,0.31591E-05_JPRB /)  
KA(:, 5, 6, 4) = (/ &
 & 0.17832E-07_JPRB,0.17197E-06_JPRB,0.28124E-06_JPRB,0.47610E-06_JPRB,0.64900E-06_JPRB, &
 & 0.81537E-06_JPRB,0.99403E-06_JPRB,0.12613E-05_JPRB,0.32001E-05_JPRB /)  
KA(:, 1, 7, 4) = (/ &
 & 0.19543E-07_JPRB,0.20424E-06_JPRB,0.20827E-06_JPRB,0.30613E-06_JPRB,0.46038E-06_JPRB, &
 & 0.61052E-06_JPRB,0.78796E-06_JPRB,0.10769E-05_JPRB,0.53495E-05_JPRB /)  
KA(:, 2, 7, 4) = (/ &
 & 0.21943E-07_JPRB,0.20486E-06_JPRB,0.21292E-06_JPRB,0.31650E-06_JPRB,0.47369E-06_JPRB, &
 & 0.62546E-06_JPRB,0.78997E-06_JPRB,0.10696E-05_JPRB,0.53612E-05_JPRB /)  
KA(:, 3, 7, 4) = (/ &
 & 0.23096E-07_JPRB,0.20519E-06_JPRB,0.21260E-06_JPRB,0.32419E-06_JPRB,0.48522E-06_JPRB, &
 & 0.63494E-06_JPRB,0.79556E-06_JPRB,0.10562E-05_JPRB,0.54125E-05_JPRB /)  
KA(:, 4, 7, 4) = (/ &
 & 0.23811E-07_JPRB,0.20761E-06_JPRB,0.21334E-06_JPRB,0.32752E-06_JPRB,0.49467E-06_JPRB, &
 & 0.64456E-06_JPRB,0.80411E-06_JPRB,0.10435E-05_JPRB,0.54920E-05_JPRB /)  
KA(:, 5, 7, 4) = (/ &
 & 0.23502E-07_JPRB,0.20918E-06_JPRB,0.21430E-06_JPRB,0.32878E-06_JPRB,0.50037E-06_JPRB, &
 & 0.65413E-06_JPRB,0.80879E-06_JPRB,0.10409E-05_JPRB,0.55076E-05_JPRB /)  
KA(:, 1, 8, 4) = (/ &
 & 0.28818E-07_JPRB,0.26386E-06_JPRB,0.23322E-06_JPRB,0.23394E-06_JPRB,0.31766E-06_JPRB, &
 & 0.47372E-06_JPRB,0.64268E-06_JPRB,0.89272E-06_JPRB,0.10691E-04_JPRB /)  
KA(:, 2, 8, 4) = (/ &
 & 0.30094E-07_JPRB,0.27235E-06_JPRB,0.23524E-06_JPRB,0.24245E-06_JPRB,0.32636E-06_JPRB, &
 & 0.48411E-06_JPRB,0.63773E-06_JPRB,0.88040E-06_JPRB,0.10770E-04_JPRB /)  
KA(:, 3, 8, 4) = (/ &
 & 0.32474E-07_JPRB,0.27799E-06_JPRB,0.23717E-06_JPRB,0.24789E-06_JPRB,0.33554E-06_JPRB, &
 & 0.49304E-06_JPRB,0.64255E-06_JPRB,0.87788E-06_JPRB,0.10799E-04_JPRB /)  
KA(:, 4, 8, 4) = (/ &
 & 0.33631E-07_JPRB,0.28020E-06_JPRB,0.23819E-06_JPRB,0.25000E-06_JPRB,0.34187E-06_JPRB, &
 & 0.49874E-06_JPRB,0.64803E-06_JPRB,0.86373E-06_JPRB,0.10824E-04_JPRB /)  
KA(:, 5, 8, 4) = (/ &
 & 0.34597E-07_JPRB,0.28107E-06_JPRB,0.24266E-06_JPRB,0.24933E-06_JPRB,0.34607E-06_JPRB, &
 & 0.50692E-06_JPRB,0.65081E-06_JPRB,0.85686E-06_JPRB,0.10819E-04_JPRB /)  
KA(:, 1, 9, 4) = (/ &
 & 0.37049E-07_JPRB,0.33070E-06_JPRB,0.32147E-06_JPRB,0.25828E-06_JPRB,0.24460E-06_JPRB, &
 & 0.33057E-06_JPRB,0.51182E-06_JPRB,0.72970E-06_JPRB,0.32667E-04_JPRB /)  
KA(:, 2, 9, 4) = (/ &
 & 0.39634E-07_JPRB,0.34282E-06_JPRB,0.32875E-06_JPRB,0.26785E-06_JPRB,0.25757E-06_JPRB, &
 & 0.33579E-06_JPRB,0.50462E-06_JPRB,0.72240E-06_JPRB,0.32638E-04_JPRB /)  
KA(:, 3, 9, 4) = (/ &
 & 0.42012E-07_JPRB,0.34998E-06_JPRB,0.33495E-06_JPRB,0.27514E-06_JPRB,0.26581E-06_JPRB, &
 & 0.33988E-06_JPRB,0.50360E-06_JPRB,0.72105E-06_JPRB,0.32828E-04_JPRB /)  
KA(:, 4, 9, 4) = (/ &
 & 0.43216E-07_JPRB,0.35061E-06_JPRB,0.33953E-06_JPRB,0.28140E-06_JPRB,0.27172E-06_JPRB, &
 & 0.34266E-06_JPRB,0.50914E-06_JPRB,0.70829E-06_JPRB,0.32970E-04_JPRB /)  
KA(:, 5, 9, 4) = (/ &
 & 0.43838E-07_JPRB,0.35447E-06_JPRB,0.34674E-06_JPRB,0.28252E-06_JPRB,0.27122E-06_JPRB, &
 & 0.34740E-06_JPRB,0.51058E-06_JPRB,0.70194E-06_JPRB,0.33023E-04_JPRB /)  
KA(:, 1,10, 4) = (/ &
 & 0.46492E-07_JPRB,0.34673E-06_JPRB,0.43959E-06_JPRB,0.39620E-06_JPRB,0.30969E-06_JPRB, &
 & 0.25359E-06_JPRB,0.35579E-06_JPRB,0.58999E-06_JPRB,0.75308E-04_JPRB /)  
KA(:, 2,10, 4) = (/ &
 & 0.51642E-07_JPRB,0.35814E-06_JPRB,0.45251E-06_JPRB,0.40694E-06_JPRB,0.31643E-06_JPRB, &
 & 0.25658E-06_JPRB,0.34700E-06_JPRB,0.58340E-06_JPRB,0.75445E-04_JPRB /)  
KA(:, 3,10, 4) = (/ &
 & 0.55139E-07_JPRB,0.36959E-06_JPRB,0.46273E-06_JPRB,0.41592E-06_JPRB,0.32168E-06_JPRB, &
 & 0.26320E-06_JPRB,0.34598E-06_JPRB,0.57972E-06_JPRB,0.75796E-04_JPRB /)  
KA(:, 4,10, 4) = (/ &
 & 0.58094E-07_JPRB,0.37731E-06_JPRB,0.47160E-06_JPRB,0.41969E-06_JPRB,0.32536E-06_JPRB, &
 & 0.27186E-06_JPRB,0.34692E-06_JPRB,0.57173E-06_JPRB,0.76680E-04_JPRB /)  
KA(:, 5,10, 4) = (/ &
 & 0.62665E-07_JPRB,0.38529E-06_JPRB,0.47122E-06_JPRB,0.42322E-06_JPRB,0.32990E-06_JPRB, &
 & 0.28125E-06_JPRB,0.34920E-06_JPRB,0.56204E-06_JPRB,0.77515E-04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART3',1,ZHOOK_HANDLE)
END SUBROUTINE PART3


SUBROUTINE PART4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART4',0,ZHOOK_HANDLE)


KA(:, 1,11, 4) = (/ &
 & 0.71997E-07_JPRB,0.39039E-06_JPRB,0.48930E-06_JPRB,0.52037E-06_JPRB,0.44835E-06_JPRB, &
 & 0.32920E-06_JPRB,0.25424E-06_JPRB,0.45719E-06_JPRB,0.97599E-04_JPRB /)  
KA(:, 2,11, 4) = (/ &
 & 0.84174E-07_JPRB,0.39220E-06_JPRB,0.49753E-06_JPRB,0.53466E-06_JPRB,0.46035E-06_JPRB, &
 & 0.34028E-06_JPRB,0.25580E-06_JPRB,0.44804E-06_JPRB,0.98017E-04_JPRB /)  
KA(:, 3,11, 4) = (/ &
 & 0.88241E-07_JPRB,0.39809E-06_JPRB,0.50514E-06_JPRB,0.54464E-06_JPRB,0.47069E-06_JPRB, &
 & 0.34919E-06_JPRB,0.25830E-06_JPRB,0.44783E-06_JPRB,0.97609E-04_JPRB /)  
KA(:, 4,11, 4) = (/ &
 & 0.93462E-07_JPRB,0.40271E-06_JPRB,0.51216E-06_JPRB,0.55531E-06_JPRB,0.48178E-06_JPRB, &
 & 0.35530E-06_JPRB,0.26505E-06_JPRB,0.43524E-06_JPRB,0.97099E-04_JPRB /)  
KA(:, 5,11, 4) = (/ &
 & 0.96966E-07_JPRB,0.40660E-06_JPRB,0.51682E-06_JPRB,0.56367E-06_JPRB,0.48662E-06_JPRB, &
 & 0.35706E-06_JPRB,0.26903E-06_JPRB,0.42986E-06_JPRB,0.97653E-04_JPRB /)  
KA(:, 1,12, 4) = (/ &
 & 0.99102E-07_JPRB,0.42179E-06_JPRB,0.46920E-06_JPRB,0.54974E-06_JPRB,0.50699E-06_JPRB, &
 & 0.41543E-06_JPRB,0.26692E-06_JPRB,0.34287E-06_JPRB,0.10692E-03_JPRB /)  
KA(:, 2,12, 4) = (/ &
 & 0.10220E-06_JPRB,0.42343E-06_JPRB,0.48263E-06_JPRB,0.56179E-06_JPRB,0.52088E-06_JPRB, &
 & 0.42826E-06_JPRB,0.27416E-06_JPRB,0.32165E-06_JPRB,0.10849E-03_JPRB /)  
KA(:, 3,12, 4) = (/ &
 & 0.10736E-06_JPRB,0.42994E-06_JPRB,0.49237E-06_JPRB,0.56848E-06_JPRB,0.53837E-06_JPRB, &
 & 0.43862E-06_JPRB,0.28070E-06_JPRB,0.31402E-06_JPRB,0.10890E-03_JPRB /)  
KA(:, 4,12, 4) = (/ &
 & 0.10535E-06_JPRB,0.42853E-06_JPRB,0.49830E-06_JPRB,0.57259E-06_JPRB,0.55337E-06_JPRB, &
 & 0.45117E-06_JPRB,0.28964E-06_JPRB,0.30229E-06_JPRB,0.11005E-03_JPRB /)  
KA(:, 5,12, 4) = (/ &
 & 0.10635E-06_JPRB,0.42826E-06_JPRB,0.50038E-06_JPRB,0.57688E-06_JPRB,0.56182E-06_JPRB, &
 & 0.45862E-06_JPRB,0.29473E-06_JPRB,0.29904E-06_JPRB,0.11056E-03_JPRB /)  
KA(:, 1,13, 4) = (/ &
 & 0.11521E-06_JPRB,0.43118E-06_JPRB,0.49222E-06_JPRB,0.52624E-06_JPRB,0.55771E-06_JPRB, &
 & 0.47186E-06_JPRB,0.32691E-06_JPRB,0.24833E-06_JPRB,0.10886E-03_JPRB /)  
KA(:, 2,13, 4) = (/ &
 & 0.11730E-06_JPRB,0.43904E-06_JPRB,0.49350E-06_JPRB,0.54164E-06_JPRB,0.56845E-06_JPRB, &
 & 0.49098E-06_JPRB,0.34261E-06_JPRB,0.23938E-06_JPRB,0.11077E-03_JPRB /)  
KA(:, 3,13, 4) = (/ &
 & 0.11952E-06_JPRB,0.44327E-06_JPRB,0.50284E-06_JPRB,0.55816E-06_JPRB,0.58198E-06_JPRB, &
 & 0.50372E-06_JPRB,0.35861E-06_JPRB,0.22850E-06_JPRB,0.11296E-03_JPRB /)  
KA(:, 4,13, 4) = (/ &
 & 0.11965E-06_JPRB,0.44664E-06_JPRB,0.51058E-06_JPRB,0.56661E-06_JPRB,0.59093E-06_JPRB, &
 & 0.51146E-06_JPRB,0.36596E-06_JPRB,0.22349E-06_JPRB,0.11560E-03_JPRB /)  
KA(:, 5,13, 4) = (/ &
 & 0.12171E-06_JPRB,0.45566E-06_JPRB,0.52364E-06_JPRB,0.57439E-06_JPRB,0.59010E-06_JPRB, &
 & 0.52011E-06_JPRB,0.37200E-06_JPRB,0.22417E-06_JPRB,0.11598E-03_JPRB /)  
KA(:, 1, 1, 5) = (/ &
 & 0.64393E-08_JPRB,0.14477E-05_JPRB,0.26383E-05_JPRB,0.37578E-05_JPRB,0.48497E-05_JPRB, &
 & 0.58771E-05_JPRB,0.69748E-05_JPRB,0.83337E-05_JPRB,0.52972E-05_JPRB /)  
KA(:, 2, 1, 5) = (/ &
 & 0.74788E-08_JPRB,0.14813E-05_JPRB,0.26820E-05_JPRB,0.38123E-05_JPRB,0.49043E-05_JPRB, &
 & 0.59719E-05_JPRB,0.70794E-05_JPRB,0.84777E-05_JPRB,0.53686E-05_JPRB /)  
KA(:, 3, 1, 5) = (/ &
 & 0.70698E-08_JPRB,0.17381E-05_JPRB,0.31521E-05_JPRB,0.44815E-05_JPRB,0.57370E-05_JPRB, &
 & 0.69696E-05_JPRB,0.82426E-05_JPRB,0.98195E-05_JPRB,0.67445E-05_JPRB /)  
KA(:, 4, 1, 5) = (/ &
 & 0.75728E-08_JPRB,0.15363E-05_JPRB,0.27544E-05_JPRB,0.38956E-05_JPRB,0.49855E-05_JPRB, &
 & 0.60556E-05_JPRB,0.72284E-05_JPRB,0.86770E-05_JPRB,0.54442E-05_JPRB /)  
KA(:, 5, 1, 5) = (/ &
 & 0.72646E-08_JPRB,0.15573E-05_JPRB,0.27840E-05_JPRB,0.39266E-05_JPRB,0.50091E-05_JPRB, &
 & 0.60781E-05_JPRB,0.72327E-05_JPRB,0.87344E-05_JPRB,0.54537E-05_JPRB /)  
KA(:, 1, 2, 5) = (/ &
 & 0.91682E-08_JPRB,0.12471E-05_JPRB,0.22727E-05_JPRB,0.32462E-05_JPRB,0.42007E-05_JPRB, &
 & 0.51012E-05_JPRB,0.60761E-05_JPRB,0.73379E-05_JPRB,0.44448E-05_JPRB /)  
KA(:, 2, 2, 5) = (/ &
 & 0.78841E-08_JPRB,0.12745E-05_JPRB,0.23098E-05_JPRB,0.32938E-05_JPRB,0.42384E-05_JPRB, &
 & 0.51817E-05_JPRB,0.61658E-05_JPRB,0.74615E-05_JPRB,0.44925E-05_JPRB /)  
KA(:, 3, 2, 5) = (/ &
 & 0.88457E-08_JPRB,0.15305E-05_JPRB,0.27824E-05_JPRB,0.39573E-05_JPRB,0.50820E-05_JPRB, &
 & 0.61863E-05_JPRB,0.73547E-05_JPRB,0.88186E-05_JPRB,0.58192E-05_JPRB /)  
KA(:, 4, 2, 5) = (/ &
 & 0.81699E-08_JPRB,0.15379E-05_JPRB,0.27884E-05_JPRB,0.39554E-05_JPRB,0.50640E-05_JPRB, &
 & 0.61598E-05_JPRB,0.73260E-05_JPRB,0.88047E-05_JPRB,0.57596E-05_JPRB /)  
KA(:, 5, 2, 5) = (/ &
 & 0.81267E-08_JPRB,0.13345E-05_JPRB,0.23941E-05_JPRB,0.33760E-05_JPRB,0.43121E-05_JPRB, &
 & 0.52406E-05_JPRB,0.62663E-05_JPRB,0.76657E-05_JPRB,0.45393E-05_JPRB /)  
KA(:, 1, 3, 5) = (/ &
 & 0.91717E-08_JPRB,0.10541E-05_JPRB,0.19313E-05_JPRB,0.27682E-05_JPRB,0.35915E-05_JPRB, &
 & 0.43666E-05_JPRB,0.52222E-05_JPRB,0.63759E-05_JPRB,0.36110E-05_JPRB /)  
KA(:, 2, 3, 5) = (/ &
 & 0.10331E-07_JPRB,0.10789E-05_JPRB,0.19645E-05_JPRB,0.28075E-05_JPRB,0.36240E-05_JPRB, &
 & 0.44392E-05_JPRB,0.52990E-05_JPRB,0.64883E-05_JPRB,0.36530E-05_JPRB /)  
KA(:, 3, 3, 5) = (/ &
 & 0.12324E-07_JPRB,0.10988E-05_JPRB,0.19944E-05_JPRB,0.28363E-05_JPRB,0.36532E-05_JPRB, &
 & 0.44650E-05_JPRB,0.53622E-05_JPRB,0.65761E-05_JPRB,0.36791E-05_JPRB /)  
KA(:, 4, 3, 5) = (/ &
 & 0.11596E-07_JPRB,0.13389E-05_JPRB,0.24365E-05_JPRB,0.34597E-05_JPRB,0.44354E-05_JPRB, &
 & 0.54167E-05_JPRB,0.64681E-05_JPRB,0.78697E-05_JPRB,0.48568E-05_JPRB /)  
KA(:, 5, 3, 5) = (/ &
 & 0.11476E-07_JPRB,0.11282E-05_JPRB,0.20370E-05_JPRB,0.28768E-05_JPRB,0.36785E-05_JPRB, &
 & 0.44764E-05_JPRB,0.53828E-05_JPRB,0.66660E-05_JPRB,0.36841E-05_JPRB /)  
KA(:, 1, 4, 5) = (/ &
 & 0.12942E-07_JPRB,0.87057E-06_JPRB,0.16185E-05_JPRB,0.23328E-05_JPRB,0.30327E-05_JPRB, &
 & 0.36939E-05_JPRB,0.44351E-05_JPRB,0.54720E-05_JPRB,0.21271E-05_JPRB /)  
KA(:, 2, 4, 5) = (/ &
 & 0.12911E-07_JPRB,0.89351E-06_JPRB,0.16491E-05_JPRB,0.23657E-05_JPRB,0.30660E-05_JPRB, &
 & 0.37589E-05_JPRB,0.45049E-05_JPRB,0.55808E-05_JPRB,0.21315E-05_JPRB /)  
KA(:, 3, 4, 5) = (/ &
 & 0.11919E-07_JPRB,0.91285E-06_JPRB,0.16762E-05_JPRB,0.23907E-05_JPRB,0.30911E-05_JPRB, &
 & 0.37889E-05_JPRB,0.45584E-05_JPRB,0.56554E-05_JPRB,0.21302E-05_JPRB /)  
KA(:, 4, 4, 5) = (/ &
 & 0.12644E-07_JPRB,0.92680E-06_JPRB,0.16966E-05_JPRB,0.24115E-05_JPRB,0.31023E-05_JPRB, &
 & 0.37973E-05_JPRB,0.46002E-05_JPRB,0.57029E-05_JPRB,0.21090E-05_JPRB /)  
KA(:, 5, 4, 5) = (/ &
 & 0.14252E-07_JPRB,0.11501E-05_JPRB,0.21042E-05_JPRB,0.29827E-05_JPRB,0.38200E-05_JPRB, &
 & 0.46680E-05_JPRB,0.55977E-05_JPRB,0.69211E-05_JPRB,0.32123E-05_JPRB /)  
KA(:, 1, 5, 5) = (/ &
 & 0.14457E-07_JPRB,0.68848E-06_JPRB,0.13403E-05_JPRB,0.19448E-05_JPRB,0.25364E-05_JPRB, &
 & 0.30956E-05_JPRB,0.37236E-05_JPRB,0.46561E-05_JPRB,0.23476E-05_JPRB /)  
KA(:, 2, 5, 5) = (/ &
 & 0.13664E-07_JPRB,0.70724E-06_JPRB,0.13666E-05_JPRB,0.19744E-05_JPRB,0.25701E-05_JPRB, &
 & 0.31515E-05_JPRB,0.37903E-05_JPRB,0.47386E-05_JPRB,0.23292E-05_JPRB /)  
KA(:, 3, 5, 5) = (/ &
 & 0.16363E-07_JPRB,0.72382E-06_JPRB,0.13894E-05_JPRB,0.19966E-05_JPRB,0.25908E-05_JPRB, &
 & 0.31942E-05_JPRB,0.38380E-05_JPRB,0.48063E-05_JPRB,0.23210E-05_JPRB /)  
KA(:, 4, 5, 5) = (/ &
 & 0.18854E-07_JPRB,0.73645E-06_JPRB,0.14075E-05_JPRB,0.20143E-05_JPRB,0.25995E-05_JPRB, &
 & 0.31924E-05_JPRB,0.38751E-05_JPRB,0.48509E-05_JPRB,0.23084E-05_JPRB /)  
KA(:, 5, 5, 5) = (/ &
 & 0.19502E-07_JPRB,0.95711E-06_JPRB,0.17948E-05_JPRB,0.25536E-05_JPRB,0.32756E-05_JPRB, &
 & 0.40127E-05_JPRB,0.48356E-05_JPRB,0.60502E-05_JPRB,0.26522E-05_JPRB /)  
KA(:, 1, 6, 5) = (/ &
 & 0.20265E-07_JPRB,0.45716E-06_JPRB,0.10840E-05_JPRB,0.16034E-05_JPRB,0.20999E-05_JPRB, &
 & 0.25681E-05_JPRB,0.30977E-05_JPRB,0.39107E-05_JPRB,0.52450E-05_JPRB /)  
KA(:, 2, 6, 5) = (/ &
 & 0.21598E-07_JPRB,0.47132E-06_JPRB,0.11079E-05_JPRB,0.16263E-05_JPRB,0.21396E-05_JPRB, &
 & 0.26164E-05_JPRB,0.31577E-05_JPRB,0.39701E-05_JPRB,0.52182E-05_JPRB /)  
KA(:, 3, 6, 5) = (/ &
 & 0.24575E-07_JPRB,0.48601E-06_JPRB,0.11257E-05_JPRB,0.16486E-05_JPRB,0.21513E-05_JPRB, &
 & 0.26585E-05_JPRB,0.32022E-05_JPRB,0.40354E-05_JPRB,0.51968E-05_JPRB /)  
KA(:, 4, 6, 5) = (/ &
 & 0.24397E-07_JPRB,0.49804E-06_JPRB,0.11416E-05_JPRB,0.16645E-05_JPRB,0.21605E-05_JPRB, &
 & 0.26639E-05_JPRB,0.32353E-05_JPRB,0.40822E-05_JPRB,0.51575E-05_JPRB /)  
KA(:, 5, 6, 5) = (/ &
 & 0.24456E-07_JPRB,0.50499E-06_JPRB,0.11522E-05_JPRB,0.16738E-05_JPRB,0.21632E-05_JPRB, &
 & 0.26629E-05_JPRB,0.32463E-05_JPRB,0.41051E-05_JPRB,0.51085E-05_JPRB /)  
KA(:, 1, 7, 5) = (/ &
 & 0.28039E-07_JPRB,0.29800E-06_JPRB,0.81783E-06_JPRB,0.13008E-05_JPRB,0.17226E-05_JPRB, &
 & 0.21163E-05_JPRB,0.25578E-05_JPRB,0.32519E-05_JPRB,0.82307E-05_JPRB /)  
KA(:, 2, 7, 5) = (/ &
 & 0.29388E-07_JPRB,0.30492E-06_JPRB,0.83771E-06_JPRB,0.13192E-05_JPRB,0.17591E-05_JPRB, &
 & 0.21563E-05_JPRB,0.26128E-05_JPRB,0.33130E-05_JPRB,0.81908E-05_JPRB /)  
KA(:, 3, 7, 5) = (/ &
 & 0.29556E-07_JPRB,0.30866E-06_JPRB,0.85444E-06_JPRB,0.13376E-05_JPRB,0.17722E-05_JPRB, &
 & 0.21943E-05_JPRB,0.26541E-05_JPRB,0.33584E-05_JPRB,0.81819E-05_JPRB /)  
KA(:, 4, 7, 5) = (/ &
 & 0.26709E-07_JPRB,0.30951E-06_JPRB,0.86739E-06_JPRB,0.13505E-05_JPRB,0.17805E-05_JPRB, &
 & 0.22093E-05_JPRB,0.26812E-05_JPRB,0.34009E-05_JPRB,0.81017E-05_JPRB /)  
KA(:, 5, 7, 5) = (/ &
 & 0.27877E-07_JPRB,0.31158E-06_JPRB,0.87645E-06_JPRB,0.13597E-05_JPRB,0.17817E-05_JPRB, &
 & 0.22083E-05_JPRB,0.26996E-05_JPRB,0.34240E-05_JPRB,0.80774E-05_JPRB /)  
KA(:, 1, 8, 5) = (/ &
 & 0.34498E-07_JPRB,0.30504E-06_JPRB,0.50025E-06_JPRB,0.99104E-06_JPRB,0.13907E-05_JPRB, &
 & 0.17284E-05_JPRB,0.20950E-05_JPRB,0.26875E-05_JPRB,0.12492E-04_JPRB /)  
KA(:, 2, 8, 5) = (/ &
 & 0.34468E-07_JPRB,0.31253E-06_JPRB,0.51376E-06_JPRB,0.10029E-05_JPRB,0.14233E-05_JPRB, &
 & 0.17665E-05_JPRB,0.21486E-05_JPRB,0.27439E-05_JPRB,0.12811E-04_JPRB /)  
KA(:, 3, 8, 5) = (/ &
 & 0.33481E-07_JPRB,0.31885E-06_JPRB,0.52532E-06_JPRB,0.10176E-05_JPRB,0.14361E-05_JPRB, &
 & 0.18000E-05_JPRB,0.21864E-05_JPRB,0.27713E-05_JPRB,0.12979E-04_JPRB /)  
KA(:, 4, 8, 5) = (/ &
 & 0.35023E-07_JPRB,0.32212E-06_JPRB,0.53171E-06_JPRB,0.10292E-05_JPRB,0.14414E-05_JPRB, &
 & 0.18222E-05_JPRB,0.22113E-05_JPRB,0.28111E-05_JPRB,0.13061E-04_JPRB /)  
KA(:, 5, 8, 5) = (/ &
 & 0.38480E-07_JPRB,0.32386E-06_JPRB,0.53818E-06_JPRB,0.10355E-05_JPRB,0.14400E-05_JPRB, &
 & 0.18162E-05_JPRB,0.22298E-05_JPRB,0.28367E-05_JPRB,0.13100E-04_JPRB /)  
KA(:, 1, 9, 5) = (/ &
 & 0.41152E-07_JPRB,0.31870E-06_JPRB,0.36402E-06_JPRB,0.61613E-06_JPRB,0.10619E-05_JPRB, &
 & 0.13940E-05_JPRB,0.17098E-05_JPRB,0.22173E-05_JPRB,0.27198E-04_JPRB /)  
KA(:, 2, 9, 5) = (/ &
 & 0.47020E-07_JPRB,0.31765E-06_JPRB,0.37312E-06_JPRB,0.61961E-06_JPRB,0.10763E-05_JPRB, &
 & 0.14273E-05_JPRB,0.17555E-05_JPRB,0.22573E-05_JPRB,0.28218E-04_JPRB /)  
KA(:, 3, 9, 5) = (/ &
 & 0.48171E-07_JPRB,0.31526E-06_JPRB,0.38468E-06_JPRB,0.62540E-06_JPRB,0.10803E-05_JPRB, &
 & 0.14543E-05_JPRB,0.17919E-05_JPRB,0.22822E-05_JPRB,0.28600E-04_JPRB /)  
KA(:, 4, 9, 5) = (/ &
 & 0.52826E-07_JPRB,0.32481E-06_JPRB,0.38733E-06_JPRB,0.62721E-06_JPRB,0.10854E-05_JPRB, &
 & 0.14750E-05_JPRB,0.18124E-05_JPRB,0.23140E-05_JPRB,0.29051E-04_JPRB /)  
KA(:, 5, 9, 5) = (/ &
 & 0.56456E-07_JPRB,0.32727E-06_JPRB,0.38424E-06_JPRB,0.63178E-06_JPRB,0.10853E-05_JPRB, &
 & 0.14692E-05_JPRB,0.18309E-05_JPRB,0.23369E-05_JPRB,0.29958E-04_JPRB /)  
KA(:, 1,10, 5) = (/ &
 & 0.62033E-07_JPRB,0.45418E-06_JPRB,0.43247E-06_JPRB,0.44775E-06_JPRB,0.62834E-06_JPRB, &
 & 0.10534E-05_JPRB,0.13865E-05_JPRB,0.18301E-05_JPRB,0.47779E-04_JPRB /)  
KA(:, 2,10, 5) = (/ &
 & 0.66259E-07_JPRB,0.45321E-06_JPRB,0.43983E-06_JPRB,0.45223E-06_JPRB,0.63440E-06_JPRB, &
 & 0.10746E-05_JPRB,0.14253E-05_JPRB,0.18534E-05_JPRB,0.48468E-04_JPRB /)  
KA(:, 3,10, 5) = (/ &
 & 0.78966E-07_JPRB,0.45246E-06_JPRB,0.44780E-06_JPRB,0.45868E-06_JPRB,0.63026E-06_JPRB, &
 & 0.10842E-05_JPRB,0.14519E-05_JPRB,0.18794E-05_JPRB,0.49251E-04_JPRB /)  
KA(:, 4,10, 5) = (/ &
 & 0.87881E-07_JPRB,0.44642E-06_JPRB,0.45426E-06_JPRB,0.46583E-06_JPRB,0.63116E-06_JPRB, &
 & 0.10925E-05_JPRB,0.14710E-05_JPRB,0.18965E-05_JPRB,0.49742E-04_JPRB /)  
KA(:, 5,10, 5) = (/ &
 & 0.92572E-07_JPRB,0.44310E-06_JPRB,0.45326E-06_JPRB,0.47005E-06_JPRB,0.63094E-06_JPRB, &
 & 0.10763E-05_JPRB,0.14843E-05_JPRB,0.19214E-05_JPRB,0.50457E-04_JPRB /)  
KA(:, 1,11, 5) = (/ &
 & 0.10522E-06_JPRB,0.58600E-06_JPRB,0.57473E-06_JPRB,0.52150E-06_JPRB,0.51202E-06_JPRB, &
 & 0.62383E-06_JPRB,0.10987E-05_JPRB,0.15032E-05_JPRB,0.50557E-04_JPRB /)  
KA(:, 2,11, 5) = (/ &
 & 0.98332E-07_JPRB,0.58669E-06_JPRB,0.57910E-06_JPRB,0.52997E-06_JPRB,0.52591E-06_JPRB, &
 & 0.62992E-06_JPRB,0.11144E-05_JPRB,0.15271E-05_JPRB,0.52915E-04_JPRB /)  
KA(:, 3,11, 5) = (/ &
 & 0.10383E-06_JPRB,0.58976E-06_JPRB,0.58650E-06_JPRB,0.53573E-06_JPRB,0.53394E-06_JPRB, &
 & 0.63743E-06_JPRB,0.11251E-05_JPRB,0.15415E-05_JPRB,0.55206E-04_JPRB /)  
KA(:, 4,11, 5) = (/ &
 & 0.10626E-06_JPRB,0.58622E-06_JPRB,0.58747E-06_JPRB,0.53868E-06_JPRB,0.53891E-06_JPRB, &
 & 0.62645E-06_JPRB,0.11296E-05_JPRB,0.15628E-05_JPRB,0.58020E-04_JPRB /)  
KA(:, 5,11, 5) = (/ &
 & 0.10795E-06_JPRB,0.57800E-06_JPRB,0.58664E-06_JPRB,0.53883E-06_JPRB,0.54784E-06_JPRB, &
 & 0.62145E-06_JPRB,0.11279E-05_JPRB,0.15782E-05_JPRB,0.60369E-04_JPRB /)  
KA(:, 1,12, 5) = (/ &
 & 0.11905E-06_JPRB,0.60759E-06_JPRB,0.68611E-06_JPRB,0.59318E-06_JPRB,0.53805E-06_JPRB, &
 & 0.44962E-06_JPRB,0.74828E-06_JPRB,0.12279E-05_JPRB,0.57098E-04_JPRB /)  
KA(:, 2,12, 5) = (/ &
 & 0.12660E-06_JPRB,0.61695E-06_JPRB,0.68094E-06_JPRB,0.60079E-06_JPRB,0.55064E-06_JPRB, &
 & 0.44953E-06_JPRB,0.74858E-06_JPRB,0.12489E-05_JPRB,0.55969E-04_JPRB /)  
KA(:, 3,12, 5) = (/ &
 & 0.12824E-06_JPRB,0.61561E-06_JPRB,0.67586E-06_JPRB,0.61662E-06_JPRB,0.55533E-06_JPRB, &
 & 0.46796E-06_JPRB,0.74406E-06_JPRB,0.12615E-05_JPRB,0.57249E-04_JPRB /)  
KA(:, 4,12, 5) = (/ &
 & 0.12834E-06_JPRB,0.62554E-06_JPRB,0.67923E-06_JPRB,0.62343E-06_JPRB,0.55964E-06_JPRB, &
 & 0.48091E-06_JPRB,0.73622E-06_JPRB,0.12795E-05_JPRB,0.58462E-04_JPRB /)  
KA(:, 5,12, 5) = (/ &
 & 0.13022E-06_JPRB,0.63206E-06_JPRB,0.68726E-06_JPRB,0.62663E-06_JPRB,0.56231E-06_JPRB, &
 & 0.48008E-06_JPRB,0.72942E-06_JPRB,0.12885E-05_JPRB,0.57642E-04_JPRB /)  
KA(:, 1,13, 5) = (/ &
 & 0.15325E-06_JPRB,0.60909E-06_JPRB,0.76952E-06_JPRB,0.71232E-06_JPRB,0.57983E-06_JPRB, &
 & 0.50489E-06_JPRB,0.48627E-06_JPRB,0.99183E-06_JPRB,0.58778E-04_JPRB /)  
KA(:, 2,13, 5) = (/ &
 & 0.15519E-06_JPRB,0.62152E-06_JPRB,0.78639E-06_JPRB,0.71888E-06_JPRB,0.59866E-06_JPRB, &
 & 0.50930E-06_JPRB,0.48247E-06_JPRB,0.10069E-05_JPRB,0.57959E-04_JPRB /)  
KA(:, 3,13, 5) = (/ &
 & 0.17242E-06_JPRB,0.64099E-06_JPRB,0.78686E-06_JPRB,0.71502E-06_JPRB,0.60678E-06_JPRB, &
 & 0.51633E-06_JPRB,0.47220E-06_JPRB,0.10180E-05_JPRB,0.56844E-04_JPRB /)  
KA(:, 4,13, 5) = (/ &
 & 0.18585E-06_JPRB,0.65002E-06_JPRB,0.78368E-06_JPRB,0.71421E-06_JPRB,0.61538E-06_JPRB, &
 & 0.52650E-06_JPRB,0.46857E-06_JPRB,0.10263E-05_JPRB,0.55757E-04_JPRB /)  
KA(:, 5,13, 5) = (/ &
 & 0.19235E-06_JPRB,0.64166E-06_JPRB,0.76203E-06_JPRB,0.70622E-06_JPRB,0.61837E-06_JPRB, &
 & 0.53042E-06_JPRB,0.45529E-06_JPRB,0.10275E-05_JPRB,0.55475E-04_JPRB /)  
KA(:, 1, 1, 6) = (/ &
 & 0.95617E-08_JPRB,0.36774E-05_JPRB,0.65849E-05_JPRB,0.92221E-05_JPRB,0.11700E-04_JPRB, &
 & 0.14161E-04_JPRB,0.16732E-04_JPRB,0.20350E-04_JPRB,0.14554E-04_JPRB /)  
KA(:, 2, 1, 6) = (/ &
 & 0.93327E-08_JPRB,0.37537E-05_JPRB,0.66916E-05_JPRB,0.93495E-05_JPRB,0.11842E-04_JPRB, &
 & 0.14289E-04_JPRB,0.16848E-04_JPRB,0.20318E-04_JPRB,0.14747E-04_JPRB /)  
KA(:, 3, 1, 6) = (/ &
 & 0.98298E-08_JPRB,0.41944E-05_JPRB,0.75022E-05_JPRB,0.10503E-04_JPRB,0.13381E-04_JPRB, &
 & 0.16104E-04_JPRB,0.19004E-04_JPRB,0.22601E-04_JPRB,0.17337E-04_JPRB /)  
KA(:, 4, 1, 6) = (/ &
 & 0.92318E-08_JPRB,0.38872E-05_JPRB,0.68816E-05_JPRB,0.95784E-05_JPRB,0.12112E-04_JPRB, &
 & 0.14510E-04_JPRB,0.17052E-04_JPRB,0.20522E-04_JPRB,0.14967E-04_JPRB /)  
KA(:, 5, 1, 6) = (/ &
 & 0.98053E-08_JPRB,0.39438E-05_JPRB,0.69574E-05_JPRB,0.96665E-05_JPRB,0.12218E-04_JPRB, &
 & 0.14607E-04_JPRB,0.17135E-04_JPRB,0.20557E-04_JPRB,0.15005E-04_JPRB /)  
KA(:, 1, 2, 6) = (/ &
 & 0.99669E-08_JPRB,0.32456E-05_JPRB,0.58216E-05_JPRB,0.81575E-05_JPRB,0.10349E-04_JPRB, &
 & 0.12573E-04_JPRB,0.14901E-04_JPRB,0.18163E-04_JPRB,0.12615E-04_JPRB /)  
KA(:, 2, 2, 6) = (/ &
 & 0.12231E-07_JPRB,0.33138E-05_JPRB,0.59221E-05_JPRB,0.82752E-05_JPRB,0.10501E-04_JPRB, &
 & 0.12666E-04_JPRB,0.15004E-04_JPRB,0.18147E-04_JPRB,0.12797E-04_JPRB /)  
KA(:, 3, 2, 6) = (/ &
 & 0.10745E-07_JPRB,0.37581E-05_JPRB,0.67327E-05_JPRB,0.94426E-05_JPRB,0.12044E-04_JPRB, &
 & 0.14533E-04_JPRB,0.17181E-04_JPRB,0.20503E-04_JPRB,0.15464E-04_JPRB /)  
KA(:, 4, 2, 6) = (/ &
 & 0.11723E-07_JPRB,0.37897E-05_JPRB,0.67581E-05_JPRB,0.94584E-05_JPRB,0.12035E-04_JPRB, &
 & 0.14508E-04_JPRB,0.17115E-04_JPRB,0.20450E-04_JPRB,0.15378E-04_JPRB /)  
KA(:, 5, 2, 6) = (/ &
 & 0.10775E-07_JPRB,0.34864E-05_JPRB,0.61478E-05_JPRB,0.85479E-05_JPRB,0.10823E-04_JPRB, &
 & 0.12985E-04_JPRB,0.15273E-04_JPRB,0.18381E-04_JPRB,0.12972E-04_JPRB /)  
KA(:, 1, 3, 6) = (/ &
 & 0.12159E-07_JPRB,0.28311E-05_JPRB,0.50923E-05_JPRB,0.71433E-05_JPRB,0.90735E-05_JPRB, &
 & 0.11042E-04_JPRB,0.13160E-04_JPRB,0.16141E-04_JPRB,0.10790E-04_JPRB /)  
KA(:, 2, 3, 6) = (/ &
 & 0.11403E-07_JPRB,0.28950E-05_JPRB,0.51829E-05_JPRB,0.72481E-05_JPRB,0.92149E-05_JPRB, &
 & 0.11135E-04_JPRB,0.13267E-04_JPRB,0.16084E-04_JPRB,0.10912E-04_JPRB /)  
KA(:, 3, 3, 6) = (/ &
 & 0.12436E-07_JPRB,0.29531E-05_JPRB,0.52642E-05_JPRB,0.73461E-05_JPRB,0.93337E-05_JPRB, &
 & 0.11250E-04_JPRB,0.13358E-04_JPRB,0.16208E-04_JPRB,0.10995E-04_JPRB /)  
KA(:, 4, 3, 6) = (/ &
 & 0.14856E-07_JPRB,0.33723E-05_JPRB,0.60342E-05_JPRB,0.84579E-05_JPRB,0.10776E-04_JPRB, &
 & 0.13025E-04_JPRB,0.15434E-04_JPRB,0.18466E-04_JPRB,0.13550E-04_JPRB /)  
KA(:, 5, 3, 6) = (/ &
 & 0.16537E-07_JPRB,0.30506E-05_JPRB,0.53821E-05_JPRB,0.74897E-05_JPRB,0.94861E-05_JPRB, &
 & 0.11421E-04_JPRB,0.13503E-04_JPRB,0.16308E-04_JPRB,0.11045E-04_JPRB /)  
KA(:, 1, 4, 6) = (/ &
 & 0.13114E-07_JPRB,0.24467E-05_JPRB,0.44159E-05_JPRB,0.61941E-05_JPRB,0.78845E-05_JPRB, &
 & 0.96031E-05_JPRB,0.11513E-04_JPRB,0.14234E-04_JPRB,0.89642E-05_JPRB /)  
KA(:, 2, 4, 6) = (/ &
 & 0.15028E-07_JPRB,0.25040E-05_JPRB,0.44954E-05_JPRB,0.62931E-05_JPRB,0.80050E-05_JPRB, &
 & 0.97056E-05_JPRB,0.11618E-04_JPRB,0.14175E-04_JPRB,0.90802E-05_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART4',1,ZHOOK_HANDLE)
END SUBROUTINE PART4


SUBROUTINE PART5

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART5',0,ZHOOK_HANDLE)


KA(:, 3, 4, 6) = (/ &
 & 0.18213E-07_JPRB,0.25556E-05_JPRB,0.45678E-05_JPRB,0.63789E-05_JPRB,0.81071E-05_JPRB, &
 & 0.98077E-05_JPRB,0.11694E-04_JPRB,0.14301E-04_JPRB,0.91538E-05_JPRB /)  
KA(:, 4, 4, 6) = (/ &
 & 0.19097E-07_JPRB,0.26037E-05_JPRB,0.46288E-05_JPRB,0.64476E-05_JPRB,0.81897E-05_JPRB, &
 & 0.98941E-05_JPRB,0.11740E-04_JPRB,0.14344E-04_JPRB,0.91968E-05_JPRB /)  
KA(:, 5, 4, 6) = (/ &
 & 0.18014E-07_JPRB,0.29993E-05_JPRB,0.53622E-05_JPRB,0.75209E-05_JPRB,0.95686E-05_JPRB, &
 & 0.11571E-04_JPRB,0.13783E-04_JPRB,0.16522E-04_JPRB,0.11644E-04_JPRB /)  
KA(:, 1, 5, 6) = (/ &
 & 0.21237E-07_JPRB,0.20921E-05_JPRB,0.37961E-05_JPRB,0.53264E-05_JPRB,0.67905E-05_JPRB, &
 & 0.82846E-05_JPRB,0.99803E-05_JPRB,0.12512E-04_JPRB,0.44075E-05_JPRB /)  
KA(:, 2, 5, 6) = (/ &
 & 0.23885E-07_JPRB,0.21444E-05_JPRB,0.38676E-05_JPRB,0.54146E-05_JPRB,0.68931E-05_JPRB, &
 & 0.83832E-05_JPRB,0.10077E-04_JPRB,0.12417E-04_JPRB,0.44982E-05_JPRB /)  
KA(:, 3, 5, 6) = (/ &
 & 0.20851E-07_JPRB,0.21906E-05_JPRB,0.39301E-05_JPRB,0.54900E-05_JPRB,0.69833E-05_JPRB, &
 & 0.84513E-05_JPRB,0.10145E-04_JPRB,0.12513E-04_JPRB,0.45299E-05_JPRB /)  
KA(:, 4, 5, 6) = (/ &
 & 0.22487E-07_JPRB,0.22322E-05_JPRB,0.39843E-05_JPRB,0.55506E-05_JPRB,0.70502E-05_JPRB, &
 & 0.85357E-05_JPRB,0.10189E-04_JPRB,0.12546E-04_JPRB,0.45220E-05_JPRB /)  
KA(:, 5, 5, 6) = (/ &
 & 0.23015E-07_JPRB,0.26442E-05_JPRB,0.47363E-05_JPRB,0.66520E-05_JPRB,0.84676E-05_JPRB, &
 & 0.10272E-04_JPRB,0.12268E-04_JPRB,0.14801E-04_JPRB,0.72945E-05_JPRB /)  
KA(:, 1, 6, 6) = (/ &
 & 0.22693E-07_JPRB,0.17592E-05_JPRB,0.32289E-05_JPRB,0.45327E-05_JPRB,0.57876E-05_JPRB, &
 & 0.70822E-05_JPRB,0.85643E-05_JPRB,0.10966E-04_JPRB,0.53375E-05_JPRB /)  
KA(:, 2, 6, 6) = (/ &
 & 0.22407E-07_JPRB,0.18081E-05_JPRB,0.32912E-05_JPRB,0.46136E-05_JPRB,0.58716E-05_JPRB, &
 & 0.71710E-05_JPRB,0.86530E-05_JPRB,0.10805E-04_JPRB,0.53845E-05_JPRB /)  
KA(:, 3, 6, 6) = (/ &
 & 0.22705E-07_JPRB,0.18504E-05_JPRB,0.33475E-05_JPRB,0.46786E-05_JPRB,0.59585E-05_JPRB, &
 & 0.72252E-05_JPRB,0.87123E-05_JPRB,0.10876E-04_JPRB,0.53808E-05_JPRB /)  
KA(:, 4, 6, 6) = (/ &
 & 0.23941E-07_JPRB,0.18862E-05_JPRB,0.33938E-05_JPRB,0.47325E-05_JPRB,0.60159E-05_JPRB, &
 & 0.72910E-05_JPRB,0.87573E-05_JPRB,0.10893E-04_JPRB,0.53357E-05_JPRB /)  
KA(:, 5, 6, 6) = (/ &
 & 0.27004E-07_JPRB,0.19136E-05_JPRB,0.34294E-05_JPRB,0.47766E-05_JPRB,0.60573E-05_JPRB, &
 & 0.73309E-05_JPRB,0.87892E-05_JPRB,0.10892E-04_JPRB,0.52484E-05_JPRB /)  
KA(:, 1, 7, 6) = (/ &
 & 0.27131E-07_JPRB,0.14236E-05_JPRB,0.27128E-05_JPRB,0.38203E-05_JPRB,0.48870E-05_JPRB, &
 & 0.59983E-05_JPRB,0.72827E-05_JPRB,0.94729E-05_JPRB,0.86942E-05_JPRB /)  
KA(:, 2, 7, 6) = (/ &
 & 0.26214E-07_JPRB,0.14673E-05_JPRB,0.27677E-05_JPRB,0.38940E-05_JPRB,0.49627E-05_JPRB, &
 & 0.60727E-05_JPRB,0.73587E-05_JPRB,0.93332E-05_JPRB,0.87651E-05_JPRB /)  
KA(:, 3, 7, 6) = (/ &
 & 0.29249E-07_JPRB,0.15085E-05_JPRB,0.28175E-05_JPRB,0.39503E-05_JPRB,0.50362E-05_JPRB, &
 & 0.61230E-05_JPRB,0.74095E-05_JPRB,0.93608E-05_JPRB,0.87497E-05_JPRB /)  
KA(:, 4, 7, 6) = (/ &
 & 0.35846E-07_JPRB,0.15423E-05_JPRB,0.28570E-05_JPRB,0.39988E-05_JPRB,0.50875E-05_JPRB, &
 & 0.61709E-05_JPRB,0.74491E-05_JPRB,0.93691E-05_JPRB,0.88300E-05_JPRB /)  
KA(:, 5, 7, 6) = (/ &
 & 0.36255E-07_JPRB,0.15665E-05_JPRB,0.28868E-05_JPRB,0.40378E-05_JPRB,0.51248E-05_JPRB, &
 & 0.62083E-05_JPRB,0.74689E-05_JPRB,0.93597E-05_JPRB,0.88065E-05_JPRB /)  
KA(:, 1, 8, 6) = (/ &
 & 0.37619E-07_JPRB,0.92017E-06_JPRB,0.22295E-05_JPRB,0.31821E-05_JPRB,0.40883E-05_JPRB, &
 & 0.50331E-05_JPRB,0.61447E-05_JPRB,0.80461E-05_JPRB,0.15512E-04_JPRB /)  
KA(:, 2, 8, 6) = (/ &
 & 0.43015E-07_JPRB,0.95048E-06_JPRB,0.22782E-05_JPRB,0.32493E-05_JPRB,0.41585E-05_JPRB, &
 & 0.50968E-05_JPRB,0.61995E-05_JPRB,0.80232E-05_JPRB,0.15472E-04_JPRB /)  
KA(:, 3, 8, 6) = (/ &
 & 0.47635E-07_JPRB,0.97934E-06_JPRB,0.23207E-05_JPRB,0.33002E-05_JPRB,0.42181E-05_JPRB, &
 & 0.51430E-05_JPRB,0.62468E-05_JPRB,0.79821E-05_JPRB,0.15652E-04_JPRB /)  
KA(:, 4, 8, 6) = (/ &
 & 0.48140E-07_JPRB,0.10026E-05_JPRB,0.23582E-05_JPRB,0.33416E-05_JPRB,0.42650E-05_JPRB, &
 & 0.51734E-05_JPRB,0.62779E-05_JPRB,0.79833E-05_JPRB,0.15762E-04_JPRB /)  
KA(:, 5, 8, 6) = (/ &
 & 0.45231E-07_JPRB,0.10212E-05_JPRB,0.23819E-05_JPRB,0.33754E-05_JPRB,0.42991E-05_JPRB, &
 & 0.52146E-05_JPRB,0.62945E-05_JPRB,0.79701E-05_JPRB,0.15840E-04_JPRB /)  
KA(:, 1, 9, 6) = (/ &
 & 0.48601E-07_JPRB,0.49350E-06_JPRB,0.16585E-05_JPRB,0.26009E-05_JPRB,0.33796E-05_JPRB, &
 & 0.41888E-05_JPRB,0.51434E-05_JPRB,0.67867E-05_JPRB,0.26875E-04_JPRB /)  
KA(:, 2, 9, 6) = (/ &
 & 0.49825E-07_JPRB,0.51680E-06_JPRB,0.16935E-05_JPRB,0.26607E-05_JPRB,0.34457E-05_JPRB, &
 & 0.42434E-05_JPRB,0.51839E-05_JPRB,0.68587E-05_JPRB,0.27475E-04_JPRB /)  
KA(:, 3, 9, 6) = (/ &
 & 0.52843E-07_JPRB,0.53573E-06_JPRB,0.17199E-05_JPRB,0.27038E-05_JPRB,0.35027E-05_JPRB, &
 & 0.42858E-05_JPRB,0.52233E-05_JPRB,0.67410E-05_JPRB,0.28097E-04_JPRB /)  
KA(:, 4, 9, 6) = (/ &
 & 0.49841E-07_JPRB,0.54248E-06_JPRB,0.17493E-05_JPRB,0.27418E-05_JPRB,0.35427E-05_JPRB, &
 & 0.43127E-05_JPRB,0.52517E-05_JPRB,0.67418E-05_JPRB,0.28632E-04_JPRB /)  
KA(:, 5, 9, 6) = (/ &
 & 0.50649E-07_JPRB,0.54940E-06_JPRB,0.17700E-05_JPRB,0.27695E-05_JPRB,0.35712E-05_JPRB, &
 & 0.43482E-05_JPRB,0.52645E-05_JPRB,0.67282E-05_JPRB,0.28662E-04_JPRB /)  
KA(:, 1,10, 6) = (/ &
 & 0.82685E-07_JPRB,0.54022E-06_JPRB,0.87761E-06_JPRB,0.18752E-05_JPRB,0.27293E-05_JPRB, &
 & 0.34506E-05_JPRB,0.42821E-05_JPRB,0.56501E-05_JPRB,0.44067E-04_JPRB /)  
KA(:, 2,10, 6) = (/ &
 & 0.87011E-07_JPRB,0.54017E-06_JPRB,0.89732E-06_JPRB,0.19208E-05_JPRB,0.27945E-05_JPRB, &
 & 0.35005E-05_JPRB,0.43124E-05_JPRB,0.57881E-05_JPRB,0.45858E-04_JPRB /)  
KA(:, 3,10, 6) = (/ &
 & 0.79909E-07_JPRB,0.55355E-06_JPRB,0.90995E-06_JPRB,0.19451E-05_JPRB,0.28460E-05_JPRB, &
 & 0.35425E-05_JPRB,0.43438E-05_JPRB,0.56593E-05_JPRB,0.45805E-04_JPRB /)  
KA(:, 4,10, 6) = (/ &
 & 0.75533E-07_JPRB,0.55705E-06_JPRB,0.92147E-06_JPRB,0.19661E-05_JPRB,0.28785E-05_JPRB, &
 & 0.35628E-05_JPRB,0.43635E-05_JPRB,0.56526E-05_JPRB,0.46295E-04_JPRB /)  
KA(:, 5,10, 6) = (/ &
 & 0.76631E-07_JPRB,0.55159E-06_JPRB,0.93362E-06_JPRB,0.19832E-05_JPRB,0.29003E-05_JPRB, &
 & 0.35965E-05_JPRB,0.43731E-05_JPRB,0.56385E-05_JPRB,0.46720E-04_JPRB /)  
KA(:, 1,11, 6) = (/ &
 & 0.11164E-06_JPRB,0.57710E-06_JPRB,0.71279E-06_JPRB,0.10003E-05_JPRB,0.19253E-05_JPRB, &
 & 0.28027E-05_JPRB,0.35523E-05_JPRB,0.47607E-05_JPRB,0.51144E-04_JPRB /)  
KA(:, 2,11, 6) = (/ &
 & 0.11484E-06_JPRB,0.58649E-06_JPRB,0.71918E-06_JPRB,0.10167E-05_JPRB,0.19538E-05_JPRB, &
 & 0.28431E-05_JPRB,0.35713E-05_JPRB,0.48333E-05_JPRB,0.49887E-04_JPRB /)  
KA(:, 3,11, 6) = (/ &
 & 0.11442E-06_JPRB,0.58483E-06_JPRB,0.70503E-06_JPRB,0.10320E-05_JPRB,0.19684E-05_JPRB, &
 & 0.28674E-05_JPRB,0.35911E-05_JPRB,0.47191E-05_JPRB,0.50222E-04_JPRB /)  
KA(:, 4,11, 6) = (/ &
 & 0.11737E-06_JPRB,0.58895E-06_JPRB,0.70242E-06_JPRB,0.10442E-05_JPRB,0.19738E-05_JPRB, &
 & 0.28962E-05_JPRB,0.36035E-05_JPRB,0.47045E-05_JPRB,0.48754E-04_JPRB /)  
KA(:, 5,11, 6) = (/ &
 & 0.12314E-06_JPRB,0.59299E-06_JPRB,0.70874E-06_JPRB,0.10470E-05_JPRB,0.19736E-05_JPRB, &
 & 0.29100E-05_JPRB,0.36075E-05_JPRB,0.46813E-05_JPRB,0.45986E-04_JPRB /)  
KA(:, 1,12, 6) = (/ &
 & 0.14446E-06_JPRB,0.57459E-06_JPRB,0.72800E-06_JPRB,0.69912E-06_JPRB,0.11693E-05_JPRB, &
 & 0.21457E-05_JPRB,0.29151E-05_JPRB,0.39683E-05_JPRB,0.42970E-04_JPRB /)  
KA(:, 2,12, 6) = (/ &
 & 0.14738E-06_JPRB,0.58568E-06_JPRB,0.75374E-06_JPRB,0.69814E-06_JPRB,0.11797E-05_JPRB, &
 & 0.21759E-05_JPRB,0.29287E-05_JPRB,0.39942E-05_JPRB,0.41434E-04_JPRB /)  
KA(:, 3,12, 6) = (/ &
 & 0.15006E-06_JPRB,0.60144E-06_JPRB,0.75420E-06_JPRB,0.70559E-06_JPRB,0.11849E-05_JPRB, &
 & 0.21718E-05_JPRB,0.29383E-05_JPRB,0.39185E-05_JPRB,0.42909E-04_JPRB /)  
KA(:, 4,12, 6) = (/ &
 & 0.15745E-06_JPRB,0.60776E-06_JPRB,0.75984E-06_JPRB,0.71270E-06_JPRB,0.11804E-05_JPRB, &
 & 0.21578E-05_JPRB,0.29477E-05_JPRB,0.38939E-05_JPRB,0.41761E-04_JPRB /)  
KA(:, 5,12, 6) = (/ &
 & 0.16583E-06_JPRB,0.62207E-06_JPRB,0.74591E-06_JPRB,0.69746E-06_JPRB,0.11751E-05_JPRB, &
 & 0.21552E-05_JPRB,0.29514E-05_JPRB,0.38695E-05_JPRB,0.45252E-04_JPRB /)  
KA(:, 1,13, 6) = (/ &
 & 0.18492E-06_JPRB,0.65841E-06_JPRB,0.74904E-06_JPRB,0.82698E-06_JPRB,0.69790E-06_JPRB, &
 & 0.13356E-05_JPRB,0.23333E-05_JPRB,0.33010E-05_JPRB,0.43502E-04_JPRB /)  
KA(:, 2,13, 6) = (/ &
 & 0.18447E-06_JPRB,0.66115E-06_JPRB,0.74200E-06_JPRB,0.80748E-06_JPRB,0.68676E-06_JPRB, &
 & 0.13419E-05_JPRB,0.23369E-05_JPRB,0.32873E-05_JPRB,0.44908E-04_JPRB /)  
KA(:, 3,13, 6) = (/ &
 & 0.20107E-06_JPRB,0.65387E-06_JPRB,0.73155E-06_JPRB,0.79291E-06_JPRB,0.67848E-06_JPRB, &
 & 0.13368E-05_JPRB,0.23434E-05_JPRB,0.32337E-05_JPRB,0.47417E-04_JPRB /)  
KA(:, 4,13, 6) = (/ &
 & 0.20493E-06_JPRB,0.66191E-06_JPRB,0.72707E-06_JPRB,0.79839E-06_JPRB,0.67208E-06_JPRB, &
 & 0.13273E-05_JPRB,0.23466E-05_JPRB,0.32075E-05_JPRB,0.48703E-04_JPRB /)  
KA(:, 5,13, 6) = (/ &
 & 0.20003E-06_JPRB,0.66753E-06_JPRB,0.73390E-06_JPRB,0.79794E-06_JPRB,0.66936E-06_JPRB, &
 & 0.13150E-05_JPRB,0.23558E-05_JPRB,0.31828E-05_JPRB,0.50012E-04_JPRB /)  
KA(:, 1, 1, 7) = (/ &
 & 0.45955E-07_JPRB,0.96988E-05_JPRB,0.16766E-04_JPRB,0.23073E-04_JPRB,0.28829E-04_JPRB, &
 & 0.34350E-04_JPRB,0.39744E-04_JPRB,0.45071E-04_JPRB,0.36783E-04_JPRB /)  
KA(:, 2, 1, 7) = (/ &
 & 0.57268E-07_JPRB,0.98413E-05_JPRB,0.16970E-04_JPRB,0.23311E-04_JPRB,0.29149E-04_JPRB, &
 & 0.34726E-04_JPRB,0.40229E-04_JPRB,0.45682E-04_JPRB,0.37190E-04_JPRB /)  
KA(:, 3, 1, 7) = (/ &
 & 0.70060E-07_JPRB,0.10517E-04_JPRB,0.18168E-04_JPRB,0.24965E-04_JPRB,0.31264E-04_JPRB, &
 & 0.37439E-04_JPRB,0.43299E-04_JPRB,0.49335E-04_JPRB,0.41254E-04_JPRB /)  
KA(:, 4, 1, 7) = (/ &
 & 0.84370E-07_JPRB,0.10120E-04_JPRB,0.17302E-04_JPRB,0.23633E-04_JPRB,0.29544E-04_JPRB, &
 & 0.35368E-04_JPRB,0.40885E-04_JPRB,0.46535E-04_JPRB,0.37819E-04_JPRB /)  
KA(:, 5, 1, 7) = (/ &
 & 0.97346E-07_JPRB,0.10254E-04_JPRB,0.17458E-04_JPRB,0.23773E-04_JPRB,0.29672E-04_JPRB, &
 & 0.35542E-04_JPRB,0.41140E-04_JPRB,0.46864E-04_JPRB,0.38054E-04_JPRB /)  
KA(:, 1, 2, 7) = (/ &
 & 0.27937E-07_JPRB,0.87332E-05_JPRB,0.15102E-04_JPRB,0.20785E-04_JPRB,0.26002E-04_JPRB, &
 & 0.30993E-04_JPRB,0.35918E-04_JPRB,0.41124E-04_JPRB,0.32692E-04_JPRB /)  
KA(:, 2, 2, 7) = (/ &
 & 0.34502E-07_JPRB,0.88655E-05_JPRB,0.15279E-04_JPRB,0.20992E-04_JPRB,0.26281E-04_JPRB, &
 & 0.31393E-04_JPRB,0.36363E-04_JPRB,0.41768E-04_JPRB,0.33047E-04_JPRB /)  
KA(:, 3, 2, 7) = (/ &
 & 0.45243E-07_JPRB,0.95567E-05_JPRB,0.16535E-04_JPRB,0.22740E-04_JPRB,0.28503E-04_JPRB, &
 & 0.34161E-04_JPRB,0.39521E-04_JPRB,0.45509E-04_JPRB,0.37184E-04_JPRB /)  
KA(:, 4, 2, 7) = (/ &
 & 0.56029E-07_JPRB,0.96404E-05_JPRB,0.16599E-04_JPRB,0.22759E-04_JPRB,0.28526E-04_JPRB, &
 & 0.34207E-04_JPRB,0.39586E-04_JPRB,0.45601E-04_JPRB,0.37152E-04_JPRB /)  
KA(:, 5, 2, 7) = (/ &
 & 0.67453E-07_JPRB,0.92372E-05_JPRB,0.15744E-04_JPRB,0.21435E-04_JPRB,0.26769E-04_JPRB, &
 & 0.32085E-04_JPRB,0.37228E-04_JPRB,0.42908E-04_JPRB,0.33841E-04_JPRB /)  
KA(:, 1, 3, 7) = (/ &
 & 0.21909E-07_JPRB,0.77821E-05_JPRB,0.13457E-04_JPRB,0.18525E-04_JPRB,0.23194E-04_JPRB, &
 & 0.27662E-04_JPRB,0.32086E-04_JPRB,0.37089E-04_JPRB,0.28700E-04_JPRB /)  
KA(:, 2, 3, 7) = (/ &
 & 0.25816E-07_JPRB,0.78998E-05_JPRB,0.13627E-04_JPRB,0.18723E-04_JPRB,0.23459E-04_JPRB, &
 & 0.28049E-04_JPRB,0.32494E-04_JPRB,0.37775E-04_JPRB,0.29060E-04_JPRB /)  
KA(:, 3, 3, 7) = (/ &
 & 0.28009E-07_JPRB,0.80177E-05_JPRB,0.13778E-04_JPRB,0.18883E-04_JPRB,0.23652E-04_JPRB, &
 & 0.28348E-04_JPRB,0.32831E-04_JPRB,0.38183E-04_JPRB,0.29363E-04_JPRB /)  
KA(:, 4, 3, 7) = (/ &
 & 0.32250E-07_JPRB,0.87000E-05_JPRB,0.14997E-04_JPRB,0.20591E-04_JPRB,0.25858E-04_JPRB, &
 & 0.30984E-04_JPRB,0.35855E-04_JPRB,0.41716E-04_JPRB,0.33352E-04_JPRB /)  
KA(:, 5, 3, 7) = (/ &
 & 0.38565E-07_JPRB,0.82442E-05_JPRB,0.14048E-04_JPRB,0.19147E-04_JPRB,0.23963E-04_JPRB, &
 & 0.28712E-04_JPRB,0.33322E-04_JPRB,0.38841E-04_JPRB,0.29827E-04_JPRB /)  
KA(:, 1, 4, 7) = (/ &
 & 0.27845E-07_JPRB,0.68782E-05_JPRB,0.11887E-04_JPRB,0.16370E-04_JPRB,0.20522E-04_JPRB, &
 & 0.24507E-04_JPRB,0.28445E-04_JPRB,0.33146E-04_JPRB,0.25091E-04_JPRB /)  
KA(:, 2, 4, 7) = (/ &
 & 0.30162E-07_JPRB,0.69860E-05_JPRB,0.12053E-04_JPRB,0.16569E-04_JPRB,0.20786E-04_JPRB, &
 & 0.24863E-04_JPRB,0.28833E-04_JPRB,0.33823E-04_JPRB,0.25439E-04_JPRB /)  
KA(:, 3, 4, 7) = (/ &
 & 0.31547E-07_JPRB,0.70934E-05_JPRB,0.12196E-04_JPRB,0.16734E-04_JPRB,0.20984E-04_JPRB, &
 & 0.25140E-04_JPRB,0.29167E-04_JPRB,0.34188E-04_JPRB,0.25743E-04_JPRB /)  
KA(:, 4, 4, 7) = (/ &
 & 0.30733E-07_JPRB,0.72009E-05_JPRB,0.12319E-04_JPRB,0.16870E-04_JPRB,0.21150E-04_JPRB, &
 & 0.25350E-04_JPRB,0.29432E-04_JPRB,0.34551E-04_JPRB,0.26011E-04_JPRB /)  
KA(:, 5, 4, 7) = (/ &
 & 0.33104E-07_JPRB,0.78742E-05_JPRB,0.13511E-04_JPRB,0.18536E-04_JPRB,0.23314E-04_JPRB, &
 & 0.27934E-04_JPRB,0.32284E-04_JPRB,0.37983E-04_JPRB,0.29911E-04_JPRB /)  
KA(:, 1, 5, 7) = (/ &
 & 0.31453E-07_JPRB,0.60344E-05_JPRB,0.10431E-04_JPRB,0.14360E-04_JPRB,0.18025E-04_JPRB, &
 & 0.21556E-04_JPRB,0.25057E-04_JPRB,0.29352E-04_JPRB,0.21244E-04_JPRB /)  
KA(:, 2, 5, 7) = (/ &
 & 0.32645E-07_JPRB,0.61373E-05_JPRB,0.10589E-04_JPRB,0.14561E-04_JPRB,0.18288E-04_JPRB, &
 & 0.21896E-04_JPRB,0.25427E-04_JPRB,0.30041E-04_JPRB,0.21582E-04_JPRB /)  
KA(:, 3, 5, 7) = (/ &
 & 0.36285E-07_JPRB,0.62371E-05_JPRB,0.10724E-04_JPRB,0.14730E-04_JPRB,0.18494E-04_JPRB, &
 & 0.22175E-04_JPRB,0.25749E-04_JPRB,0.30401E-04_JPRB,0.21875E-04_JPRB /)  
KA(:, 4, 5, 7) = (/ &
 & 0.35840E-07_JPRB,0.63361E-05_JPRB,0.10841E-04_JPRB,0.14872E-04_JPRB,0.18672E-04_JPRB, &
 & 0.22386E-04_JPRB,0.26001E-04_JPRB,0.30772E-04_JPRB,0.22136E-04_JPRB /)  
KA(:, 5, 5, 7) = (/ &
 & 0.34391E-07_JPRB,0.70384E-05_JPRB,0.12100E-04_JPRB,0.16639E-04_JPRB,0.20967E-04_JPRB, &
 & 0.25106E-04_JPRB,0.29033E-04_JPRB,0.34382E-04_JPRB,0.26458E-04_JPRB /)  
KA(:, 1, 6, 7) = (/ &
 & 0.38317E-07_JPRB,0.52554E-05_JPRB,0.90847E-05_JPRB,0.12506E-04_JPRB,0.15706E-04_JPRB, &
 & 0.18802E-04_JPRB,0.21926E-04_JPRB,0.25721E-04_JPRB,0.82786E-05_JPRB /)  
KA(:, 2, 6, 7) = (/ &
 & 0.42993E-07_JPRB,0.53521E-05_JPRB,0.92425E-05_JPRB,0.12708E-04_JPRB,0.15965E-04_JPRB, &
 & 0.19131E-04_JPRB,0.22269E-04_JPRB,0.26449E-04_JPRB,0.85145E-05_JPRB /)  
KA(:, 3, 6, 7) = (/ &
 & 0.43612E-07_JPRB,0.54474E-05_JPRB,0.93707E-05_JPRB,0.12875E-04_JPRB,0.16176E-04_JPRB, &
 & 0.19407E-04_JPRB,0.22575E-04_JPRB,0.26830E-04_JPRB,0.87594E-05_JPRB /)  
KA(:, 4, 6, 7) = (/ &
 & 0.42757E-07_JPRB,0.55405E-05_JPRB,0.94823E-05_JPRB,0.13019E-04_JPRB,0.16363E-04_JPRB, &
 & 0.19625E-04_JPRB,0.22815E-04_JPRB,0.27200E-04_JPRB,0.90170E-05_JPRB /)  
KA(:, 5, 6, 7) = (/ &
 & 0.43664E-07_JPRB,0.56274E-05_JPRB,0.95923E-05_JPRB,0.13140E-04_JPRB,0.16520E-04_JPRB, &
 & 0.19797E-04_JPRB,0.22995E-04_JPRB,0.27528E-04_JPRB,0.91836E-05_JPRB /)  
KA(:, 1, 7, 7) = (/ &
 & 0.39995E-07_JPRB,0.45414E-05_JPRB,0.78502E-05_JPRB,0.10801E-04_JPRB,0.13562E-04_JPRB, &
 & 0.16248E-04_JPRB,0.19009E-04_JPRB,0.22439E-04_JPRB,0.93804E-05_JPRB /)  
KA(:, 2, 7, 7) = (/ &
 & 0.43614E-07_JPRB,0.46331E-05_JPRB,0.80059E-05_JPRB,0.11000E-04_JPRB,0.13813E-04_JPRB, &
 & 0.16577E-04_JPRB,0.19346E-04_JPRB,0.23103E-04_JPRB,0.95334E-05_JPRB /)  
KA(:, 3, 7, 7) = (/ &
 & 0.45687E-07_JPRB,0.47201E-05_JPRB,0.81316E-05_JPRB,0.11167E-04_JPRB,0.14031E-04_JPRB, &
 & 0.16844E-04_JPRB,0.19646E-04_JPRB,0.23513E-04_JPRB,0.96503E-05_JPRB /)  
KA(:, 4, 7, 7) = (/ &
 & 0.48386E-07_JPRB,0.48081E-05_JPRB,0.82413E-05_JPRB,0.11310E-04_JPRB,0.14223E-04_JPRB, &
 & 0.17063E-04_JPRB,0.19885E-04_JPRB,0.23881E-04_JPRB,0.95360E-05_JPRB /)  
KA(:, 5, 7, 7) = (/ &
 & 0.54287E-07_JPRB,0.48899E-05_JPRB,0.83473E-05_JPRB,0.11434E-04_JPRB,0.14383E-04_JPRB, &
 & 0.17240E-04_JPRB,0.20064E-04_JPRB,0.24201E-04_JPRB,0.94267E-05_JPRB /)  
KA(:, 1, 8, 7) = (/ &
 & 0.45720E-07_JPRB,0.38685E-05_JPRB,0.67269E-05_JPRB,0.92537E-05_JPRB,0.11613E-04_JPRB, &
 & 0.13930E-04_JPRB,0.16333E-04_JPRB,0.19500E-04_JPRB,0.15537E-04_JPRB /)  
KA(:, 2, 8, 7) = (/ &
 & 0.46817E-07_JPRB,0.39568E-05_JPRB,0.68775E-05_JPRB,0.94493E-05_JPRB,0.11857E-04_JPRB, &
 & 0.14250E-04_JPRB,0.16679E-04_JPRB,0.19983E-04_JPRB,0.15822E-04_JPRB /)  
KA(:, 3, 8, 7) = (/ &
 & 0.48700E-07_JPRB,0.40362E-05_JPRB,0.70012E-05_JPRB,0.96148E-05_JPRB,0.12076E-04_JPRB, &
 & 0.14508E-04_JPRB,0.16969E-04_JPRB,0.20440E-04_JPRB,0.15878E-04_JPRB /)  
KA(:, 4, 8, 7) = (/ &
 & 0.54460E-07_JPRB,0.41199E-05_JPRB,0.71098E-05_JPRB,0.97580E-05_JPRB,0.12268E-04_JPRB, &
 & 0.14725E-04_JPRB,0.17206E-04_JPRB,0.20805E-04_JPRB,0.16014E-04_JPRB /)  
KA(:, 5, 8, 7) = (/ &
 & 0.59565E-07_JPRB,0.42000E-05_JPRB,0.72128E-05_JPRB,0.98789E-05_JPRB,0.12424E-04_JPRB, &
 & 0.14896E-04_JPRB,0.17382E-04_JPRB,0.21113E-04_JPRB,0.15894E-04_JPRB /)  
KA(:, 1, 9, 7) = (/ &
 & 0.60502E-07_JPRB,0.31758E-05_JPRB,0.57011E-05_JPRB,0.78602E-05_JPRB,0.98646E-05_JPRB, &
 & 0.11842E-04_JPRB,0.13914E-04_JPRB,0.16812E-04_JPRB,0.32738E-04_JPRB /)  
KA(:, 2, 9, 7) = (/ &
 & 0.61920E-07_JPRB,0.32583E-05_JPRB,0.58474E-05_JPRB,0.80501E-05_JPRB,0.10097E-04_JPRB, &
 & 0.12150E-04_JPRB,0.14260E-04_JPRB,0.17128E-04_JPRB,0.32707E-04_JPRB /)  
KA(:, 3, 9, 7) = (/ &
 & 0.66102E-07_JPRB,0.33410E-05_JPRB,0.59686E-05_JPRB,0.82148E-05_JPRB,0.10310E-04_JPRB, &
 & 0.12398E-04_JPRB,0.14542E-04_JPRB,0.17650E-04_JPRB,0.33629E-04_JPRB /)  
KA(:, 4, 9, 7) = (/ &
 & 0.86168E-07_JPRB,0.34261E-05_JPRB,0.60763E-05_JPRB,0.83539E-05_JPRB,0.10496E-04_JPRB, &
 & 0.12604E-04_JPRB,0.14773E-04_JPRB,0.17994E-04_JPRB,0.33878E-04_JPRB /)  
KA(:, 5, 9, 7) = (/ &
 & 0.91586E-07_JPRB,0.35057E-05_JPRB,0.61764E-05_JPRB,0.84703E-05_JPRB,0.10646E-04_JPRB, &
 & 0.12765E-04_JPRB,0.14939E-04_JPRB,0.18282E-04_JPRB,0.33645E-04_JPRB /)  
KA(:, 1,10, 7) = (/ &
 & 0.96997E-07_JPRB,0.19211E-05_JPRB,0.47098E-05_JPRB,0.66155E-05_JPRB,0.83225E-05_JPRB, &
 & 0.10005E-04_JPRB,0.11773E-04_JPRB,0.14404E-04_JPRB,0.53631E-04_JPRB /)  
KA(:, 2,10, 7) = (/ &
 & 0.96064E-07_JPRB,0.20141E-05_JPRB,0.48491E-05_JPRB,0.67941E-05_JPRB,0.85382E-05_JPRB, &
 & 0.10290E-04_JPRB,0.12102E-04_JPRB,0.14626E-04_JPRB,0.54289E-04_JPRB /)  
KA(:, 3,10, 7) = (/ &
 & 0.10431E-06_JPRB,0.20834E-05_JPRB,0.49690E-05_JPRB,0.69520E-05_JPRB,0.87398E-05_JPRB, &
 & 0.10520E-04_JPRB,0.12369E-04_JPRB,0.15124E-04_JPRB,0.55603E-04_JPRB /)  
KA(:, 4,10, 7) = (/ &
 & 0.11432E-06_JPRB,0.21653E-05_JPRB,0.50755E-05_JPRB,0.70852E-05_JPRB,0.89148E-05_JPRB, &
 & 0.10714E-04_JPRB,0.12591E-04_JPRB,0.15457E-04_JPRB,0.56630E-04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART5',1,ZHOOK_HANDLE)
END SUBROUTINE PART5


SUBROUTINE PART6

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART6',0,ZHOOK_HANDLE)


KA(:, 5,10, 7) = (/ &
 & 0.11074E-06_JPRB,0.22480E-05_JPRB,0.51732E-05_JPRB,0.71951E-05_JPRB,0.90530E-05_JPRB, &
 & 0.10860E-04_JPRB,0.12745E-04_JPRB,0.15721E-04_JPRB,0.54963E-04_JPRB /)  
KA(:, 1,11, 7) = (/ &
 & 0.15854E-06_JPRB,0.91297E-06_JPRB,0.32555E-05_JPRB,0.55113E-05_JPRB,0.70464E-05_JPRB, &
 & 0.85121E-05_JPRB,0.10027E-04_JPRB,0.12303E-04_JPRB,0.52607E-04_JPRB /)  
KA(:, 2,11, 7) = (/ &
 & 0.16751E-06_JPRB,0.96634E-06_JPRB,0.33790E-05_JPRB,0.56722E-05_JPRB,0.72351E-05_JPRB, &
 & 0.87519E-05_JPRB,0.10311E-04_JPRB,0.12547E-04_JPRB,0.52883E-04_JPRB /)  
KA(:, 3,11, 7) = (/ &
 & 0.16741E-06_JPRB,0.10318E-05_JPRB,0.35064E-05_JPRB,0.58058E-05_JPRB,0.74099E-05_JPRB, &
 & 0.89413E-05_JPRB,0.10546E-04_JPRB,0.12998E-04_JPRB,0.52407E-04_JPRB /)  
KA(:, 4,11, 7) = (/ &
 & 0.16708E-06_JPRB,0.10925E-05_JPRB,0.36064E-05_JPRB,0.59145E-05_JPRB,0.75531E-05_JPRB, &
 & 0.90996E-05_JPRB,0.10715E-04_JPRB,0.13285E-04_JPRB,0.53203E-04_JPRB /)  
KA(:, 5,11, 7) = (/ &
 & 0.16578E-06_JPRB,0.11490E-05_JPRB,0.36852E-05_JPRB,0.60104E-05_JPRB,0.76652E-05_JPRB, &
 & 0.92182E-05_JPRB,0.10838E-04_JPRB,0.13496E-04_JPRB,0.54467E-04_JPRB /)  
KA(:, 1,12, 7) = (/ &
 & 0.17287E-06_JPRB,0.67222E-06_JPRB,0.20177E-05_JPRB,0.42045E-05_JPRB,0.58863E-05_JPRB, &
 & 0.71911E-05_JPRB,0.84904E-05_JPRB,0.10467E-04_JPRB,0.53824E-04_JPRB /)  
KA(:, 2,12, 7) = (/ &
 & 0.17534E-06_JPRB,0.66930E-06_JPRB,0.20902E-05_JPRB,0.43510E-05_JPRB,0.60518E-05_JPRB, &
 & 0.73834E-05_JPRB,0.87285E-05_JPRB,0.10723E-04_JPRB,0.57713E-04_JPRB /)  
KA(:, 3,12, 7) = (/ &
 & 0.19862E-06_JPRB,0.69271E-06_JPRB,0.21807E-05_JPRB,0.44473E-05_JPRB,0.61938E-05_JPRB, &
 & 0.75395E-05_JPRB,0.89230E-05_JPRB,0.11082E-04_JPRB,0.58727E-04_JPRB /)  
KA(:, 4,12, 7) = (/ &
 & 0.20481E-06_JPRB,0.70155E-06_JPRB,0.22437E-05_JPRB,0.45330E-05_JPRB,0.63072E-05_JPRB, &
 & 0.76639E-05_JPRB,0.90515E-05_JPRB,0.11316E-04_JPRB,0.62478E-04_JPRB /)  
KA(:, 5,12, 7) = (/ &
 & 0.22362E-06_JPRB,0.66686E-06_JPRB,0.23107E-05_JPRB,0.46277E-05_JPRB,0.64004E-05_JPRB, &
 & 0.77560E-05_JPRB,0.91460E-05_JPRB,0.11480E-04_JPRB,0.61459E-04_JPRB /)  
KA(:, 1,13, 7) = (/ &
 & 0.24394E-06_JPRB,0.78850E-06_JPRB,0.10005E-05_JPRB,0.25869E-05_JPRB,0.46671E-05_JPRB, &
 & 0.60110E-05_JPRB,0.71462E-05_JPRB,0.88357E-05_JPRB,0.59707E-04_JPRB /)  
KA(:, 2,13, 7) = (/ &
 & 0.25387E-06_JPRB,0.77656E-06_JPRB,0.10565E-05_JPRB,0.27093E-05_JPRB,0.48105E-05_JPRB, &
 & 0.61610E-05_JPRB,0.73436E-05_JPRB,0.90989E-05_JPRB,0.60151E-04_JPRB /)  
KA(:, 3,13, 7) = (/ &
 & 0.22260E-06_JPRB,0.76604E-06_JPRB,0.11188E-05_JPRB,0.28168E-05_JPRB,0.49259E-05_JPRB, &
 & 0.62864E-05_JPRB,0.74912E-05_JPRB,0.93777E-05_JPRB,0.58560E-04_JPRB /)  
KA(:, 4,13, 7) = (/ &
 & 0.22499E-06_JPRB,0.75979E-06_JPRB,0.11746E-05_JPRB,0.28869E-05_JPRB,0.50154E-05_JPRB, &
 & 0.63819E-05_JPRB,0.75933E-05_JPRB,0.95633E-05_JPRB,0.61656E-04_JPRB /)  
KA(:, 5,13, 7) = (/ &
 & 0.22527E-06_JPRB,0.74699E-06_JPRB,0.12195E-05_JPRB,0.29526E-05_JPRB,0.50915E-05_JPRB, &
 & 0.64528E-05_JPRB,0.76669E-05_JPRB,0.96909E-05_JPRB,0.60588E-04_JPRB /)  
KA(:, 1, 1, 8) = (/ &
 & 0.29788E-05_JPRB,0.29380E-04_JPRB,0.47103E-04_JPRB,0.62484E-04_JPRB,0.75923E-04_JPRB, &
 & 0.86945E-04_JPRB,0.96459E-04_JPRB,0.10727E-03_JPRB,0.95715E-04_JPRB /)  
KA(:, 2, 1, 8) = (/ &
 & 0.31829E-05_JPRB,0.29542E-04_JPRB,0.47406E-04_JPRB,0.62987E-04_JPRB,0.76500E-04_JPRB, &
 & 0.87575E-04_JPRB,0.97244E-04_JPRB,0.10847E-03_JPRB,0.96769E-04_JPRB /)  
KA(:, 3, 1, 8) = (/ &
 & 0.34017E-05_JPRB,0.30451E-04_JPRB,0.49181E-04_JPRB,0.65673E-04_JPRB,0.79848E-04_JPRB, &
 & 0.91475E-04_JPRB,0.10206E-03_JPRB,0.11418E-03_JPRB,0.10339E-03_JPRB /)  
KA(:, 4, 1, 8) = (/ &
 & 0.36204E-05_JPRB,0.29858E-04_JPRB,0.47964E-04_JPRB,0.63849E-04_JPRB,0.77416E-04_JPRB, &
 & 0.88495E-04_JPRB,0.98624E-04_JPRB,0.11030E-03_JPRB,0.98665E-04_JPRB /)  
KA(:, 5, 1, 8) = (/ &
 & 0.38336E-05_JPRB,0.30032E-04_JPRB,0.48176E-04_JPRB,0.64174E-04_JPRB,0.77743E-04_JPRB, &
 & 0.88899E-04_JPRB,0.99219E-04_JPRB,0.11117E-03_JPRB,0.99410E-04_JPRB /)  
KA(:, 1, 2, 8) = (/ &
 & 0.24422E-05_JPRB,0.27039E-04_JPRB,0.43472E-04_JPRB,0.57657E-04_JPRB,0.69985E-04_JPRB, &
 & 0.80297E-04_JPRB,0.89716E-04_JPRB,0.10091E-03_JPRB,0.87814E-04_JPRB /)  
KA(:, 2, 2, 8) = (/ &
 & 0.26194E-05_JPRB,0.27224E-04_JPRB,0.43834E-04_JPRB,0.58227E-04_JPRB,0.70564E-04_JPRB, &
 & 0.80899E-04_JPRB,0.90555E-04_JPRB,0.10201E-03_JPRB,0.88900E-04_JPRB /)  
KA(:, 3, 2, 8) = (/ &
 & 0.28026E-05_JPRB,0.28185E-04_JPRB,0.45675E-04_JPRB,0.60941E-04_JPRB,0.73932E-04_JPRB, &
 & 0.84933E-04_JPRB,0.95539E-04_JPRB,0.10795E-03_JPRB,0.95932E-04_JPRB /)  
KA(:, 4, 2, 8) = (/ &
 & 0.29807E-05_JPRB,0.28297E-04_JPRB,0.45818E-04_JPRB,0.61151E-04_JPRB,0.74119E-04_JPRB, &
 & 0.85132E-04_JPRB,0.95905E-04_JPRB,0.10857E-03_JPRB,0.96316E-04_JPRB /)  
KA(:, 5, 2, 8) = (/ &
 & 0.31559E-05_JPRB,0.27777E-04_JPRB,0.44649E-04_JPRB,0.59431E-04_JPRB,0.71821E-04_JPRB, &
 & 0.82324E-04_JPRB,0.92537E-04_JPRB,0.10487E-03_JPRB,0.91446E-04_JPRB /)  
KA(:, 1, 3, 8) = (/ &
 & 0.19527E-05_JPRB,0.24728E-04_JPRB,0.39864E-04_JPRB,0.52777E-04_JPRB,0.63893E-04_JPRB, &
 & 0.73441E-04_JPRB,0.82582E-04_JPRB,0.93968E-04_JPRB,0.79571E-04_JPRB /)  
KA(:, 2, 3, 8) = (/ &
 & 0.21028E-05_JPRB,0.24948E-04_JPRB,0.40273E-04_JPRB,0.53366E-04_JPRB,0.64472E-04_JPRB, &
 & 0.74070E-04_JPRB,0.83496E-04_JPRB,0.95166E-04_JPRB,0.80711E-04_JPRB /)  
KA(:, 3, 3, 8) = (/ &
 & 0.22571E-05_JPRB,0.25146E-04_JPRB,0.40613E-04_JPRB,0.53873E-04_JPRB,0.64998E-04_JPRB, &
 & 0.74638E-04_JPRB,0.84298E-04_JPRB,0.96249E-04_JPRB,0.81670E-04_JPRB /)  
KA(:, 4, 3, 8) = (/ &
 & 0.24052E-05_JPRB,0.26082E-04_JPRB,0.42367E-04_JPRB,0.56407E-04_JPRB,0.68204E-04_JPRB, &
 & 0.78600E-04_JPRB,0.89199E-04_JPRB,0.10217E-03_JPRB,0.88502E-04_JPRB /)  
KA(:, 5, 3, 8) = (/ &
 & 0.25493E-05_JPRB,0.25521E-04_JPRB,0.41156E-04_JPRB,0.54597E-04_JPRB,0.65795E-04_JPRB, &
 & 0.75610E-04_JPRB,0.85600E-04_JPRB,0.98234E-04_JPRB,0.83132E-04_JPRB /)  
KA(:, 1, 4, 8) = (/ &
 & 0.15249E-05_JPRB,0.22458E-04_JPRB,0.36230E-04_JPRB,0.47832E-04_JPRB,0.57788E-04_JPRB, &
 & 0.66572E-04_JPRB,0.75267E-04_JPRB,0.86613E-04_JPRB,0.71765E-04_JPRB /)  
KA(:, 2, 4, 8) = (/ &
 & 0.16472E-05_JPRB,0.22706E-04_JPRB,0.36674E-04_JPRB,0.48420E-04_JPRB,0.58373E-04_JPRB, &
 & 0.67233E-04_JPRB,0.76205E-04_JPRB,0.87918E-04_JPRB,0.72872E-04_JPRB /)  
KA(:, 3, 4, 8) = (/ &
 & 0.17727E-05_JPRB,0.22924E-04_JPRB,0.37041E-04_JPRB,0.48925E-04_JPRB,0.58917E-04_JPRB, &
 & 0.67822E-04_JPRB,0.77056E-04_JPRB,0.89127E-04_JPRB,0.73812E-04_JPRB /)  
KA(:, 4, 4, 8) = (/ &
 & 0.18979E-05_JPRB,0.23116E-04_JPRB,0.37363E-04_JPRB,0.49353E-04_JPRB,0.59386E-04_JPRB, &
 & 0.68373E-04_JPRB,0.77816E-04_JPRB,0.90208E-04_JPRB,0.74597E-04_JPRB /)  
KA(:, 5, 4, 8) = (/ &
 & 0.20187E-05_JPRB,0.24032E-04_JPRB,0.39090E-04_JPRB,0.51784E-04_JPRB,0.62486E-04_JPRB, &
 & 0.72274E-04_JPRB,0.82652E-04_JPRB,0.95944E-04_JPRB,0.81360E-04_JPRB /)  
KA(:, 1, 5, 8) = (/ &
 & 0.11616E-05_JPRB,0.20230E-04_JPRB,0.32593E-04_JPRB,0.43015E-04_JPRB,0.51913E-04_JPRB, &
 & 0.59885E-04_JPRB,0.68041E-04_JPRB,0.79091E-04_JPRB,0.64237E-04_JPRB /)  
KA(:, 2, 5, 8) = (/ &
 & 0.12634E-05_JPRB,0.20493E-04_JPRB,0.33052E-04_JPRB,0.43575E-04_JPRB,0.52485E-04_JPRB, &
 & 0.60579E-04_JPRB,0.68993E-04_JPRB,0.80447E-04_JPRB,0.65308E-04_JPRB /)  
KA(:, 3, 5, 8) = (/ &
 & 0.13665E-05_JPRB,0.20722E-04_JPRB,0.33449E-04_JPRB,0.44078E-04_JPRB,0.53031E-04_JPRB, &
 & 0.61206E-04_JPRB,0.69878E-04_JPRB,0.81712E-04_JPRB,0.66219E-04_JPRB /)  
KA(:, 4, 5, 8) = (/ &
 & 0.14654E-05_JPRB,0.20926E-04_JPRB,0.33806E-04_JPRB,0.44507E-04_JPRB,0.53511E-04_JPRB, &
 & 0.61775E-04_JPRB,0.70644E-04_JPRB,0.82800E-04_JPRB,0.67010E-04_JPRB /)  
KA(:, 5, 5, 8) = (/ &
 & 0.15654E-05_JPRB,0.21919E-04_JPRB,0.35683E-04_JPRB,0.47135E-04_JPRB,0.56892E-04_JPRB, &
 & 0.66014E-04_JPRB,0.75901E-04_JPRB,0.88948E-04_JPRB,0.74367E-04_JPRB /)  
KA(:, 1, 6, 8) = (/ &
 & 0.85477E-06_JPRB,0.18056E-04_JPRB,0.29058E-04_JPRB,0.38374E-04_JPRB,0.46318E-04_JPRB, &
 & 0.53503E-04_JPRB,0.60983E-04_JPRB,0.71567E-04_JPRB,0.55220E-04_JPRB /)  
KA(:, 2, 6, 8) = (/ &
 & 0.93399E-06_JPRB,0.18333E-04_JPRB,0.29518E-04_JPRB,0.38924E-04_JPRB,0.46903E-04_JPRB, &
 & 0.54228E-04_JPRB,0.61990E-04_JPRB,0.72960E-04_JPRB,0.56327E-04_JPRB /)  
KA(:, 3, 6, 8) = (/ &
 & 0.10173E-05_JPRB,0.18568E-04_JPRB,0.29940E-04_JPRB,0.39430E-04_JPRB,0.47457E-04_JPRB, &
 & 0.54891E-04_JPRB,0.62912E-04_JPRB,0.74219E-04_JPRB,0.57262E-04_JPRB /)  
KA(:, 4, 6, 8) = (/ &
 & 0.10990E-05_JPRB,0.18773E-04_JPRB,0.30321E-04_JPRB,0.39858E-04_JPRB,0.47937E-04_JPRB, &
 & 0.55463E-04_JPRB,0.63685E-04_JPRB,0.75339E-04_JPRB,0.58060E-04_JPRB /)  
KA(:, 5, 6, 8) = (/ &
 & 0.11736E-05_JPRB,0.18980E-04_JPRB,0.30632E-04_JPRB,0.40210E-04_JPRB,0.48338E-04_JPRB, &
 & 0.55952E-04_JPRB,0.64349E-04_JPRB,0.76243E-04_JPRB,0.58787E-04_JPRB /)  
KA(:, 1, 7, 8) = (/ &
 & 0.60315E-06_JPRB,0.15982E-04_JPRB,0.25725E-04_JPRB,0.33991E-04_JPRB,0.41066E-04_JPRB, &
 & 0.47516E-04_JPRB,0.54302E-04_JPRB,0.64196E-04_JPRB,0.19175E-04_JPRB /)  
KA(:, 2, 7, 8) = (/ &
 & 0.66792E-06_JPRB,0.16270E-04_JPRB,0.26184E-04_JPRB,0.34534E-04_JPRB,0.41673E-04_JPRB, &
 & 0.48253E-04_JPRB,0.55322E-04_JPRB,0.65617E-04_JPRB,0.20214E-04_JPRB /)  
KA(:, 3, 7, 8) = (/ &
 & 0.72908E-06_JPRB,0.16517E-04_JPRB,0.26616E-04_JPRB,0.35037E-04_JPRB,0.42229E-04_JPRB, &
 & 0.48924E-04_JPRB,0.56239E-04_JPRB,0.66903E-04_JPRB,0.21171E-04_JPRB /)  
KA(:, 4, 7, 8) = (/ &
 & 0.78570E-06_JPRB,0.16735E-04_JPRB,0.27002E-04_JPRB,0.35463E-04_JPRB,0.42700E-04_JPRB, &
 & 0.49504E-04_JPRB,0.57015E-04_JPRB,0.68011E-04_JPRB,0.22118E-04_JPRB /)  
KA(:, 5, 7, 8) = (/ &
 & 0.83832E-06_JPRB,0.16948E-04_JPRB,0.27325E-04_JPRB,0.35815E-04_JPRB,0.43102E-04_JPRB, &
 & 0.50003E-04_JPRB,0.57693E-04_JPRB,0.68917E-04_JPRB,0.22989E-04_JPRB /)  
KA(:, 1, 8, 8) = (/ &
 & 0.37835E-06_JPRB,0.14042E-04_JPRB,0.22619E-04_JPRB,0.29906E-04_JPRB,0.36184E-04_JPRB, &
 & 0.41943E-04_JPRB,0.48058E-04_JPRB,0.57159E-04_JPRB,0.15030E-04_JPRB /)  
KA(:, 2, 8, 8) = (/ &
 & 0.42400E-06_JPRB,0.14336E-04_JPRB,0.23076E-04_JPRB,0.30441E-04_JPRB,0.36790E-04_JPRB, &
 & 0.42677E-04_JPRB,0.49055E-04_JPRB,0.58574E-04_JPRB,0.15267E-04_JPRB /)  
KA(:, 3, 8, 8) = (/ &
 & 0.47003E-06_JPRB,0.14598E-04_JPRB,0.23503E-04_JPRB,0.30926E-04_JPRB,0.37338E-04_JPRB, &
 & 0.43345E-04_JPRB,0.49944E-04_JPRB,0.59871E-04_JPRB,0.15168E-04_JPRB /)  
KA(:, 4, 8, 8) = (/ &
 & 0.50983E-06_JPRB,0.14832E-04_JPRB,0.23887E-04_JPRB,0.31342E-04_JPRB,0.37806E-04_JPRB, &
 & 0.43932E-04_JPRB,0.50714E-04_JPRB,0.60954E-04_JPRB,0.15479E-04_JPRB /)  
KA(:, 5, 8, 8) = (/ &
 & 0.55238E-06_JPRB,0.15050E-04_JPRB,0.24211E-04_JPRB,0.31698E-04_JPRB,0.38215E-04_JPRB, &
 & 0.44447E-04_JPRB,0.51404E-04_JPRB,0.61843E-04_JPRB,0.15864E-04_JPRB /)  
KA(:, 1, 9, 8) = (/ &
 & 0.20614E-06_JPRB,0.12247E-04_JPRB,0.19755E-04_JPRB,0.26136E-04_JPRB,0.31671E-04_JPRB, &
 & 0.36795E-04_JPRB,0.42267E-04_JPRB,0.50480E-04_JPRB,0.31415E-04_JPRB /)  
KA(:, 2, 9, 8) = (/ &
 & 0.22820E-06_JPRB,0.12543E-04_JPRB,0.20203E-04_JPRB,0.26660E-04_JPRB,0.32273E-04_JPRB, &
 & 0.37518E-04_JPRB,0.43228E-04_JPRB,0.51895E-04_JPRB,0.32257E-04_JPRB /)  
KA(:, 3, 9, 8) = (/ &
 & 0.25381E-06_JPRB,0.12814E-04_JPRB,0.20621E-04_JPRB,0.27129E-04_JPRB,0.32814E-04_JPRB, &
 & 0.38186E-04_JPRB,0.44095E-04_JPRB,0.53151E-04_JPRB,0.31766E-04_JPRB /)  
KA(:, 4, 9, 8) = (/ &
 & 0.26266E-06_JPRB,0.13056E-04_JPRB,0.20991E-04_JPRB,0.27538E-04_JPRB,0.33285E-04_JPRB, &
 & 0.38781E-04_JPRB,0.44859E-04_JPRB,0.54214E-04_JPRB,0.32184E-04_JPRB /)  
KA(:, 5, 9, 8) = (/ &
 & 0.28878E-06_JPRB,0.13277E-04_JPRB,0.21308E-04_JPRB,0.27899E-04_JPRB,0.33704E-04_JPRB, &
 & 0.39313E-04_JPRB,0.45556E-04_JPRB,0.55111E-04_JPRB,0.32436E-04_JPRB /)  
KA(:, 1,10, 8) = (/ &
 & 0.12421E-06_JPRB,0.10598E-04_JPRB,0.17170E-04_JPRB,0.22745E-04_JPRB,0.27597E-04_JPRB, &
 & 0.32129E-04_JPRB,0.37024E-04_JPRB,0.44410E-04_JPRB,0.36288E-04_JPRB /)  
KA(:, 2,10, 8) = (/ &
 & 0.11833E-06_JPRB,0.10888E-04_JPRB,0.17606E-04_JPRB,0.23251E-04_JPRB,0.28191E-04_JPRB, &
 & 0.32843E-04_JPRB,0.37957E-04_JPRB,0.45757E-04_JPRB,0.36706E-04_JPRB /)  
KA(:, 3,10, 8) = (/ &
 & 0.11564E-06_JPRB,0.11153E-04_JPRB,0.18009E-04_JPRB,0.23706E-04_JPRB,0.28726E-04_JPRB, &
 & 0.33507E-04_JPRB,0.38804E-04_JPRB,0.46971E-04_JPRB,0.39285E-04_JPRB /)  
KA(:, 4,10, 8) = (/ &
 & 0.11888E-06_JPRB,0.11400E-04_JPRB,0.18364E-04_JPRB,0.24104E-04_JPRB,0.29196E-04_JPRB, &
 & 0.34101E-04_JPRB,0.39555E-04_JPRB,0.47996E-04_JPRB,0.37765E-04_JPRB /)  
KA(:, 5,10, 8) = (/ &
 & 0.13250E-06_JPRB,0.11625E-04_JPRB,0.18671E-04_JPRB,0.24463E-04_JPRB,0.29622E-04_JPRB, &
 & 0.34646E-04_JPRB,0.40249E-04_JPRB,0.48876E-04_JPRB,0.41184E-04_JPRB /)  
KA(:, 1,11, 8) = (/ &
 & 0.17958E-06_JPRB,0.90757E-05_JPRB,0.15007E-04_JPRB,0.19889E-04_JPRB,0.24154E-04_JPRB, &
 & 0.28187E-04_JPRB,0.32636E-04_JPRB,0.39437E-04_JPRB,0.34162E-04_JPRB /)  
KA(:, 2,11, 8) = (/ &
 & 0.18139E-06_JPRB,0.93666E-05_JPRB,0.15418E-04_JPRB,0.20361E-04_JPRB,0.24716E-04_JPRB, &
 & 0.28864E-04_JPRB,0.33507E-04_JPRB,0.40680E-04_JPRB,0.35787E-04_JPRB /)  
KA(:, 3,11, 8) = (/ &
 & 0.18275E-06_JPRB,0.96291E-05_JPRB,0.15787E-04_JPRB,0.20786E-04_JPRB,0.25221E-04_JPRB, &
 & 0.29495E-04_JPRB,0.34295E-04_JPRB,0.41765E-04_JPRB,0.33878E-04_JPRB /)  
KA(:, 4,11, 8) = (/ &
 & 0.18574E-06_JPRB,0.98743E-05_JPRB,0.16117E-04_JPRB,0.21165E-04_JPRB,0.25673E-04_JPRB, &
 & 0.30069E-04_JPRB,0.35015E-04_JPRB,0.42686E-04_JPRB,0.32841E-04_JPRB /)  
KA(:, 5,11, 8) = (/ &
 & 0.20082E-06_JPRB,0.10102E-04_JPRB,0.16409E-04_JPRB,0.21512E-04_JPRB,0.26096E-04_JPRB, &
 & 0.30600E-04_JPRB,0.35678E-04_JPRB,0.43526E-04_JPRB,0.33904E-04_JPRB /)  
KA(:, 1,12, 8) = (/ &
 & 0.23860E-06_JPRB,0.72127E-05_JPRB,0.13015E-04_JPRB,0.17297E-04_JPRB,0.21033E-04_JPRB, &
 & 0.24600E-04_JPRB,0.28604E-04_JPRB,0.34818E-04_JPRB,0.40933E-04_JPRB /)  
KA(:, 2,12, 8) = (/ &
 & 0.23391E-06_JPRB,0.75352E-05_JPRB,0.13408E-04_JPRB,0.17740E-04_JPRB,0.21564E-04_JPRB, &
 & 0.25251E-04_JPRB,0.29426E-04_JPRB,0.35947E-04_JPRB,0.39399E-04_JPRB /)  
KA(:, 3,12, 8) = (/ &
 & 0.24701E-06_JPRB,0.78057E-05_JPRB,0.13760E-04_JPRB,0.18144E-04_JPRB,0.22045E-04_JPRB, &
 & 0.25844E-04_JPRB,0.30162E-04_JPRB,0.36924E-04_JPRB,0.38294E-04_JPRB /)  
KA(:, 4,12, 8) = (/ &
 & 0.26761E-06_JPRB,0.80774E-05_JPRB,0.14071E-04_JPRB,0.18509E-04_JPRB,0.22485E-04_JPRB, &
 & 0.26399E-04_JPRB,0.30850E-04_JPRB,0.37793E-04_JPRB,0.37310E-04_JPRB /)  
KA(:, 5,12, 8) = (/ &
 & 0.23665E-06_JPRB,0.83711E-05_JPRB,0.14360E-04_JPRB,0.18850E-04_JPRB,0.22903E-04_JPRB, &
 & 0.26918E-04_JPRB,0.31485E-04_JPRB,0.38601E-04_JPRB,0.34593E-04_JPRB /)  
KA(:, 1,13, 8) = (/ &
 & 0.27521E-06_JPRB,0.50755E-05_JPRB,0.11059E-04_JPRB,0.14942E-04_JPRB,0.18221E-04_JPRB, &
 & 0.21366E-04_JPRB,0.24941E-04_JPRB,0.30569E-04_JPRB,0.35909E-04_JPRB /)  
KA(:, 2,13, 8) = (/ &
 & 0.25317E-06_JPRB,0.53749E-05_JPRB,0.11450E-04_JPRB,0.15364E-04_JPRB,0.18725E-04_JPRB, &
 & 0.21982E-04_JPRB,0.25707E-04_JPRB,0.31598E-04_JPRB,0.37411E-04_JPRB /)  
KA(:, 3,13, 8) = (/ &
 & 0.23895E-06_JPRB,0.56684E-05_JPRB,0.11800E-04_JPRB,0.15745E-04_JPRB,0.19182E-04_JPRB, &
 & 0.22548E-04_JPRB,0.26403E-04_JPRB,0.32490E-04_JPRB,0.35715E-04_JPRB /)  
KA(:, 4,13, 8) = (/ &
 & 0.23323E-06_JPRB,0.59219E-05_JPRB,0.12110E-04_JPRB,0.16104E-04_JPRB,0.19621E-04_JPRB, &
 & 0.23090E-04_JPRB,0.27069E-04_JPRB,0.33309E-04_JPRB,0.26489E-04_JPRB /)  
KA(:, 5,13, 8) = (/ &
 & 0.23115E-06_JPRB,0.61949E-05_JPRB,0.12408E-04_JPRB,0.16438E-04_JPRB,0.20031E-04_JPRB, &
 & 0.23602E-04_JPRB,0.27683E-04_JPRB,0.34068E-04_JPRB,0.26612E-04_JPRB /)  
KA(:, 1, 1, 9) = (/ &
 & 0.91507E-04_JPRB,0.14710E-03_JPRB,0.19128E-03_JPRB,0.22605E-03_JPRB,0.25532E-03_JPRB, &
 & 0.28077E-03_JPRB,0.30345E-03_JPRB,0.32646E-03_JPRB,0.30807E-03_JPRB /)  
KA(:, 2, 1, 9) = (/ &
 & 0.91242E-04_JPRB,0.14642E-03_JPRB,0.19074E-03_JPRB,0.22564E-03_JPRB,0.25500E-03_JPRB, &
 & 0.28086E-03_JPRB,0.30369E-03_JPRB,0.32690E-03_JPRB,0.30957E-03_JPRB /)  
KA(:, 3, 1, 9) = (/ &
 & 0.90877E-04_JPRB,0.14692E-03_JPRB,0.19251E-03_JPRB,0.22869E-03_JPRB,0.25946E-03_JPRB, &
 & 0.28682E-03_JPRB,0.31087E-03_JPRB,0.33538E-03_JPRB,0.32011E-03_JPRB /)  
KA(:, 4, 1, 9) = (/ &
 & 0.90459E-04_JPRB,0.14494E-03_JPRB,0.18943E-03_JPRB,0.22459E-03_JPRB,0.25465E-03_JPRB, &
 & 0.28114E-03_JPRB,0.30414E-03_JPRB,0.32755E-03_JPRB,0.31196E-03_JPRB /)  
KA(:, 5, 1, 9) = (/ &
 & 0.89993E-04_JPRB,0.14416E-03_JPRB,0.18875E-03_JPRB,0.22408E-03_JPRB,0.25453E-03_JPRB, &
 & 0.28137E-03_JPRB,0.30449E-03_JPRB,0.32780E-03_JPRB,0.31307E-03_JPRB /)  
KA(:, 1, 2, 9) = (/ &
 & 0.77262E-04_JPRB,0.13432E-03_JPRB,0.17769E-03_JPRB,0.21240E-03_JPRB,0.24204E-03_JPRB, &
 & 0.26866E-03_JPRB,0.29235E-03_JPRB,0.31628E-03_JPRB,0.29582E-03_JPRB /)  
KA(:, 2, 2, 9) = (/ &
 & 0.77061E-04_JPRB,0.13375E-03_JPRB,0.17727E-03_JPRB,0.21210E-03_JPRB,0.24206E-03_JPRB, &
 & 0.26905E-03_JPRB,0.29288E-03_JPRB,0.31707E-03_JPRB,0.29754E-03_JPRB /)  
KA(:, 3, 2, 9) = (/ &
 & 0.76803E-04_JPRB,0.13443E-03_JPRB,0.17926E-03_JPRB,0.21557E-03_JPRB,0.24713E-03_JPRB, &
 & 0.27557E-03_JPRB,0.30072E-03_JPRB,0.32610E-03_JPRB,0.30880E-03_JPRB /)  
KA(:, 4, 2, 9) = (/ &
 & 0.76502E-04_JPRB,0.13372E-03_JPRB,0.17855E-03_JPRB,0.21503E-03_JPRB,0.24689E-03_JPRB, &
 & 0.27560E-03_JPRB,0.30084E-03_JPRB,0.32601E-03_JPRB,0.30963E-03_JPRB /)  
KA(:, 5, 2, 9) = (/ &
 & 0.76149E-04_JPRB,0.13198E-03_JPRB,0.17568E-03_JPRB,0.21133E-03_JPRB,0.24254E-03_JPRB, &
 & 0.27051E-03_JPRB,0.29485E-03_JPRB,0.31890E-03_JPRB,0.30223E-03_JPRB /)  
KA(:, 1, 3, 9) = (/ &
 & 0.65103E-04_JPRB,0.12258E-03_JPRB,0.16452E-03_JPRB,0.19865E-03_JPRB,0.22866E-03_JPRB, &
 & 0.25591E-03_JPRB,0.28055E-03_JPRB,0.30511E-03_JPRB,0.28178E-03_JPRB /)  
KA(:, 2, 3, 9) = (/ &
 & 0.64961E-04_JPRB,0.12216E-03_JPRB,0.16424E-03_JPRB,0.19863E-03_JPRB,0.22903E-03_JPRB, &
 & 0.25664E-03_JPRB,0.28152E-03_JPRB,0.30626E-03_JPRB,0.28379E-03_JPRB /)  
KA(:, 3, 3, 9) = (/ &
 & 0.64796E-04_JPRB,0.12170E-03_JPRB,0.16393E-03_JPRB,0.19861E-03_JPRB,0.22948E-03_JPRB, &
 & 0.25740E-03_JPRB,0.28253E-03_JPRB,0.30727E-03_JPRB,0.28578E-03_JPRB /)  
KA(:, 4, 3, 9) = (/ &
 & 0.64583E-04_JPRB,0.12248E-03_JPRB,0.16600E-03_JPRB,0.20227E-03_JPRB,0.23481E-03_JPRB, &
 & 0.26421E-03_JPRB,0.29055E-03_JPRB,0.31636E-03_JPRB,0.29736E-03_JPRB /)  
KA(:, 5, 3, 9) = (/ &
 & 0.64341E-04_JPRB,0.12081E-03_JPRB,0.16325E-03_JPRB,0.19869E-03_JPRB,0.23043E-03_JPRB, &
 & 0.25903E-03_JPRB,0.28445E-03_JPRB,0.30920E-03_JPRB,0.28976E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART6',1,ZHOOK_HANDLE)
END SUBROUTINE PART6


SUBROUTINE PART7

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART7',0,ZHOOK_HANDLE)


KA(:, 1, 4, 9) = (/ &
 & 0.54784E-04_JPRB,0.11174E-03_JPRB,0.15188E-03_JPRB,0.18523E-03_JPRB,0.21503E-03_JPRB, &
 & 0.24239E-03_JPRB,0.26770E-03_JPRB,0.29311E-03_JPRB,0.26685E-03_JPRB /)  
KA(:, 2, 4, 9) = (/ &
 & 0.54700E-04_JPRB,0.11144E-03_JPRB,0.15177E-03_JPRB,0.18550E-03_JPRB,0.21578E-03_JPRB, &
 & 0.24348E-03_JPRB,0.26903E-03_JPRB,0.29466E-03_JPRB,0.26928E-03_JPRB /)  
KA(:, 3, 4, 9) = (/ &
 & 0.54592E-04_JPRB,0.11111E-03_JPRB,0.15167E-03_JPRB,0.18578E-03_JPRB,0.21655E-03_JPRB, &
 & 0.24456E-03_JPRB,0.27029E-03_JPRB,0.29609E-03_JPRB,0.27162E-03_JPRB /)  
KA(:, 4, 4, 9) = (/ &
 & 0.54457E-04_JPRB,0.11078E-03_JPRB,0.15152E-03_JPRB,0.18607E-03_JPRB,0.21728E-03_JPRB, &
 & 0.24565E-03_JPRB,0.27151E-03_JPRB,0.29746E-03_JPRB,0.27399E-03_JPRB /)  
KA(:, 5, 4, 9) = (/ &
 & 0.54312E-04_JPRB,0.11162E-03_JPRB,0.15369E-03_JPRB,0.18993E-03_JPRB,0.22281E-03_JPRB, &
 & 0.25263E-03_JPRB,0.27972E-03_JPRB,0.30664E-03_JPRB,0.28593E-03_JPRB /)  
KA(:, 1, 5, 9) = (/ &
 & 0.46088E-04_JPRB,0.10164E-03_JPRB,0.13985E-03_JPRB,0.17192E-03_JPRB,0.20105E-03_JPRB, &
 & 0.22810E-03_JPRB,0.25365E-03_JPRB,0.28019E-03_JPRB,0.25169E-03_JPRB /)  
KA(:, 2, 5, 9) = (/ &
 & 0.46037E-04_JPRB,0.10150E-03_JPRB,0.13996E-03_JPRB,0.17251E-03_JPRB,0.20208E-03_JPRB, &
 & 0.22949E-03_JPRB,0.25532E-03_JPRB,0.28211E-03_JPRB,0.25438E-03_JPRB /)  
KA(:, 3, 5, 9) = (/ &
 & 0.45971E-04_JPRB,0.10129E-03_JPRB,0.14008E-03_JPRB,0.17302E-03_JPRB,0.20310E-03_JPRB, &
 & 0.23085E-03_JPRB,0.25690E-03_JPRB,0.28385E-03_JPRB,0.25702E-03_JPRB /)  
KA(:, 4, 5, 9) = (/ &
 & 0.45890E-04_JPRB,0.10111E-03_JPRB,0.14015E-03_JPRB,0.17355E-03_JPRB,0.20405E-03_JPRB, &
 & 0.23221E-03_JPRB,0.25843E-03_JPRB,0.28547E-03_JPRB,0.25970E-03_JPRB /)  
KA(:, 5, 5, 9) = (/ &
 & 0.45808E-04_JPRB,0.10210E-03_JPRB,0.14263E-03_JPRB,0.17783E-03_JPRB,0.21010E-03_JPRB, &
 & 0.23994E-03_JPRB,0.26750E-03_JPRB,0.29545E-03_JPRB,0.27288E-03_JPRB /)  
KA(:, 1, 6, 9) = (/ &
 & 0.38759E-04_JPRB,0.92287E-04_JPRB,0.12830E-03_JPRB,0.15873E-03_JPRB,0.18673E-03_JPRB, &
 & 0.21305E-03_JPRB,0.23858E-03_JPRB,0.26603E-03_JPRB,0.23576E-03_JPRB /)  
KA(:, 2, 6, 9) = (/ &
 & 0.38742E-04_JPRB,0.92285E-04_JPRB,0.12860E-03_JPRB,0.15956E-03_JPRB,0.18804E-03_JPRB, &
 & 0.21479E-03_JPRB,0.24061E-03_JPRB,0.26833E-03_JPRB,0.23876E-03_JPRB /)  
KA(:, 3, 6, 9) = (/ &
 & 0.38716E-04_JPRB,0.92248E-04_JPRB,0.12890E-03_JPRB,0.16031E-03_JPRB,0.18934E-03_JPRB, &
 & 0.21647E-03_JPRB,0.24252E-03_JPRB,0.27042E-03_JPRB,0.24167E-03_JPRB /)  
KA(:, 4, 6, 9) = (/ &
 & 0.38672E-04_JPRB,0.92189E-04_JPRB,0.12914E-03_JPRB,0.16108E-03_JPRB,0.19055E-03_JPRB, &
 & 0.21815E-03_JPRB,0.24441E-03_JPRB,0.27232E-03_JPRB,0.24468E-03_JPRB /)  
KA(:, 5, 6, 9) = (/ &
 & 0.38631E-04_JPRB,0.92110E-04_JPRB,0.12940E-03_JPRB,0.16181E-03_JPRB,0.19180E-03_JPRB, &
 & 0.21982E-03_JPRB,0.24634E-03_JPRB,0.27420E-03_JPRB,0.24778E-03_JPRB /)  
KA(:, 1, 7, 9) = (/ &
 & 0.32524E-04_JPRB,0.83578E-04_JPRB,0.11715E-03_JPRB,0.14581E-03_JPRB,0.17242E-03_JPRB, &
 & 0.19778E-03_JPRB,0.22289E-03_JPRB,0.25099E-03_JPRB,0.21544E-03_JPRB /)  
KA(:, 2, 7, 9) = (/ &
 & 0.32544E-04_JPRB,0.83724E-04_JPRB,0.11765E-03_JPRB,0.14685E-03_JPRB,0.17402E-03_JPRB, &
 & 0.19984E-03_JPRB,0.22531E-03_JPRB,0.25360E-03_JPRB,0.21897E-03_JPRB /)  
KA(:, 3, 7, 9) = (/ &
 & 0.32541E-04_JPRB,0.83837E-04_JPRB,0.11812E-03_JPRB,0.14785E-03_JPRB,0.17560E-03_JPRB, &
 & 0.20184E-03_JPRB,0.22764E-03_JPRB,0.25604E-03_JPRB,0.22234E-03_JPRB /)  
KA(:, 4, 7, 9) = (/ &
 & 0.32522E-04_JPRB,0.83911E-04_JPRB,0.11855E-03_JPRB,0.14886E-03_JPRB,0.17710E-03_JPRB, &
 & 0.20381E-03_JPRB,0.22989E-03_JPRB,0.25831E-03_JPRB,0.22586E-03_JPRB /)  
KA(:, 5, 7, 9) = (/ &
 & 0.32511E-04_JPRB,0.83972E-04_JPRB,0.11899E-03_JPRB,0.14985E-03_JPRB,0.17863E-03_JPRB, &
 & 0.20577E-03_JPRB,0.23212E-03_JPRB,0.26056E-03_JPRB,0.22930E-03_JPRB /)  
KA(:, 1, 8, 9) = (/ &
 & 0.27162E-04_JPRB,0.75477E-04_JPRB,0.10657E-03_JPRB,0.13337E-03_JPRB,0.15848E-03_JPRB, &
 & 0.18267E-03_JPRB,0.20707E-03_JPRB,0.23532E-03_JPRB,0.10685E-03_JPRB /)  
KA(:, 2, 8, 9) = (/ &
 & 0.27219E-04_JPRB,0.75747E-04_JPRB,0.10724E-03_JPRB,0.13464E-03_JPRB,0.16036E-03_JPRB, &
 & 0.18507E-03_JPRB,0.20988E-03_JPRB,0.23834E-03_JPRB,0.11049E-03_JPRB /)  
KA(:, 3, 8, 9) = (/ &
 & 0.27240E-04_JPRB,0.75981E-04_JPRB,0.10788E-03_JPRB,0.13591E-03_JPRB,0.16217E-03_JPRB, &
 & 0.18731E-03_JPRB,0.21250E-03_JPRB,0.24115E-03_JPRB,0.11463E-03_JPRB /)  
KA(:, 4, 8, 9) = (/ &
 & 0.27241E-04_JPRB,0.76175E-04_JPRB,0.10851E-03_JPRB,0.13715E-03_JPRB,0.16392E-03_JPRB, &
 & 0.18952E-03_JPRB,0.21504E-03_JPRB,0.24375E-03_JPRB,0.11830E-03_JPRB /)  
KA(:, 5, 8, 9) = (/ &
 & 0.27254E-04_JPRB,0.76338E-04_JPRB,0.10913E-03_JPRB,0.13836E-03_JPRB,0.16569E-03_JPRB, &
 & 0.19172E-03_JPRB,0.21755E-03_JPRB,0.24638E-03_JPRB,0.12227E-03_JPRB /)  
KA(:, 1, 9, 9) = (/ &
 & 0.22546E-04_JPRB,0.67903E-04_JPRB,0.96628E-04_JPRB,0.12150E-03_JPRB,0.14489E-03_JPRB, &
 & 0.16757E-03_JPRB,0.19095E-03_JPRB,0.21913E-03_JPRB,0.25626E-04_JPRB /)  
KA(:, 2, 9, 9) = (/ &
 & 0.22635E-04_JPRB,0.68268E-04_JPRB,0.97460E-04_JPRB,0.12301E-03_JPRB,0.14702E-03_JPRB, &
 & 0.17028E-03_JPRB,0.19411E-03_JPRB,0.22260E-03_JPRB,0.25839E-04_JPRB /)  
KA(:, 3, 9, 9) = (/ &
 & 0.22685E-04_JPRB,0.68616E-04_JPRB,0.98277E-04_JPRB,0.12450E-03_JPRB,0.14909E-03_JPRB, &
 & 0.17284E-03_JPRB,0.19709E-03_JPRB,0.22578E-03_JPRB,0.27443E-04_JPRB /)  
KA(:, 4, 9, 9) = (/ &
 & 0.22709E-04_JPRB,0.68929E-04_JPRB,0.99095E-04_JPRB,0.12593E-03_JPRB,0.15108E-03_JPRB, &
 & 0.17530E-03_JPRB,0.19995E-03_JPRB,0.22878E-03_JPRB,0.28531E-04_JPRB /)  
KA(:, 5, 9, 9) = (/ &
 & 0.22740E-04_JPRB,0.69227E-04_JPRB,0.99896E-04_JPRB,0.12734E-03_JPRB,0.15306E-03_JPRB, &
 & 0.17777E-03_JPRB,0.20277E-03_JPRB,0.23170E-03_JPRB,0.28894E-04_JPRB /)  
KA(:, 1,10, 9) = (/ &
 & 0.18403E-04_JPRB,0.60856E-04_JPRB,0.87340E-04_JPRB,0.11017E-03_JPRB,0.13174E-03_JPRB, &
 & 0.15284E-03_JPRB,0.17492E-03_JPRB,0.20267E-03_JPRB,0.31931E-04_JPRB /)  
KA(:, 2,10, 9) = (/ &
 & 0.18527E-04_JPRB,0.61329E-04_JPRB,0.88371E-04_JPRB,0.11191E-03_JPRB,0.13412E-03_JPRB, &
 & 0.15579E-03_JPRB,0.17838E-03_JPRB,0.20650E-03_JPRB,0.29084E-04_JPRB /)  
KA(:, 3,10, 9) = (/ &
 & 0.18600E-04_JPRB,0.61796E-04_JPRB,0.89354E-04_JPRB,0.11363E-03_JPRB,0.13643E-03_JPRB, &
 & 0.15861E-03_JPRB,0.18170E-03_JPRB,0.21009E-03_JPRB,0.27893E-04_JPRB /)  
KA(:, 4,10, 9) = (/ &
 & 0.18642E-04_JPRB,0.62226E-04_JPRB,0.90339E-04_JPRB,0.11526E-03_JPRB,0.13867E-03_JPRB, &
 & 0.16137E-03_JPRB,0.18486E-03_JPRB,0.21346E-03_JPRB,0.33895E-04_JPRB /)  
KA(:, 5,10, 9) = (/ &
 & 0.18688E-04_JPRB,0.62651E-04_JPRB,0.91302E-04_JPRB,0.11690E-03_JPRB,0.14093E-03_JPRB, &
 & 0.16416E-03_JPRB,0.18804E-03_JPRB,0.21676E-03_JPRB,0.31724E-04_JPRB /)  
KA(:, 1,11, 9) = (/ &
 & 0.14636E-04_JPRB,0.54588E-04_JPRB,0.79114E-04_JPRB,0.10030E-03_JPRB,0.12035E-03_JPRB, &
 & 0.14003E-03_JPRB,0.16089E-03_JPRB,0.18797E-03_JPRB,0.24886E-04_JPRB /)  
KA(:, 2,11, 9) = (/ &
 & 0.14721E-04_JPRB,0.55182E-04_JPRB,0.80295E-04_JPRB,0.10221E-03_JPRB,0.12288E-03_JPRB, &
 & 0.14315E-03_JPRB,0.16455E-03_JPRB,0.19200E-03_JPRB,0.28280E-04_JPRB /)  
KA(:, 3,11, 9) = (/ &
 & 0.14784E-04_JPRB,0.55751E-04_JPRB,0.81465E-04_JPRB,0.10405E-03_JPRB,0.12535E-03_JPRB, &
 & 0.14614E-03_JPRB,0.16802E-03_JPRB,0.19578E-03_JPRB,0.31405E-04_JPRB /)  
KA(:, 4,11, 9) = (/ &
 & 0.14831E-04_JPRB,0.56293E-04_JPRB,0.82611E-04_JPRB,0.10589E-03_JPRB,0.12782E-03_JPRB, &
 & 0.14918E-03_JPRB,0.17147E-03_JPRB,0.19942E-03_JPRB,0.34684E-04_JPRB /)  
KA(:, 5,11, 9) = (/ &
 & 0.14856E-04_JPRB,0.56829E-04_JPRB,0.83754E-04_JPRB,0.10776E-03_JPRB,0.13034E-03_JPRB, &
 & 0.15225E-03_JPRB,0.17499E-03_JPRB,0.20312E-03_JPRB,0.30970E-04_JPRB /)  
KA(:, 1,12, 9) = (/ &
 & 0.11572E-04_JPRB,0.48876E-04_JPRB,0.71553E-04_JPRB,0.91191E-04_JPRB,0.10973E-03_JPRB, &
 & 0.12799E-03_JPRB,0.14756E-03_JPRB,0.17351E-03_JPRB,0.30682E-04_JPRB /)  
KA(:, 2,12, 9) = (/ &
 & 0.11642E-04_JPRB,0.49592E-04_JPRB,0.72882E-04_JPRB,0.93233E-04_JPRB,0.11240E-03_JPRB, &
 & 0.13124E-03_JPRB,0.15132E-03_JPRB,0.17770E-03_JPRB,0.31240E-04_JPRB /)  
KA(:, 3,12, 9) = (/ &
 & 0.11629E-04_JPRB,0.50261E-04_JPRB,0.74205E-04_JPRB,0.95210E-04_JPRB,0.11505E-03_JPRB, &
 & 0.13447E-03_JPRB,0.15502E-03_JPRB,0.18170E-03_JPRB,0.31943E-04_JPRB /)  
KA(:, 4,12, 9) = (/ &
 & 0.11633E-04_JPRB,0.50925E-04_JPRB,0.75501E-04_JPRB,0.97246E-04_JPRB,0.11773E-03_JPRB, &
 & 0.13775E-03_JPRB,0.15878E-03_JPRB,0.18567E-03_JPRB,0.23441E-04_JPRB /)  
KA(:, 5,12, 9) = (/ &
 & 0.11677E-04_JPRB,0.51560E-04_JPRB,0.76851E-04_JPRB,0.99310E-04_JPRB,0.12044E-03_JPRB, &
 & 0.14103E-03_JPRB,0.16255E-03_JPRB,0.18968E-03_JPRB,0.23249E-04_JPRB /)  
KA(:, 1,13, 9) = (/ &
 & 0.88185E-05_JPRB,0.43709E-04_JPRB,0.64627E-04_JPRB,0.82824E-04_JPRB,0.99889E-04_JPRB, &
 & 0.11672E-03_JPRB,0.13488E-03_JPRB,0.15952E-03_JPRB,0.30903E-04_JPRB /)  
KA(:, 2,13, 9) = (/ &
 & 0.88986E-05_JPRB,0.44515E-04_JPRB,0.66093E-04_JPRB,0.84980E-04_JPRB,0.10270E-03_JPRB, &
 & 0.12016E-03_JPRB,0.13885E-03_JPRB,0.16386E-03_JPRB,0.25840E-04_JPRB /)  
KA(:, 3,13, 9) = (/ &
 & 0.89568E-05_JPRB,0.45280E-04_JPRB,0.67556E-04_JPRB,0.87134E-04_JPRB,0.10555E-03_JPRB, &
 & 0.12361E-03_JPRB,0.14282E-03_JPRB,0.16813E-03_JPRB,0.26878E-04_JPRB /)  
KA(:, 4,13, 9) = (/ &
 & 0.89829E-05_JPRB,0.46045E-04_JPRB,0.69040E-04_JPRB,0.89346E-04_JPRB,0.10842E-03_JPRB, &
 & 0.12710E-03_JPRB,0.14682E-03_JPRB,0.17243E-03_JPRB,0.28852E-04_JPRB /)  
KA(:, 5,13, 9) = (/ &
 & 0.90413E-05_JPRB,0.46787E-04_JPRB,0.70568E-04_JPRB,0.91561E-04_JPRB,0.11129E-03_JPRB, &
 & 0.13056E-03_JPRB,0.15080E-03_JPRB,0.17669E-03_JPRB,0.28623E-04_JPRB /)  
KA(:, 1, 1,10) = (/ &
 & 0.44112E-03_JPRB,0.47423E-03_JPRB,0.54876E-03_JPRB,0.61567E-03_JPRB,0.66971E-03_JPRB, &
 & 0.71699E-03_JPRB,0.76347E-03_JPRB,0.77814E-03_JPRB,0.77298E-03_JPRB /)  
KA(:, 2, 1,10) = (/ &
 & 0.43794E-03_JPRB,0.47285E-03_JPRB,0.54643E-03_JPRB,0.61370E-03_JPRB,0.66959E-03_JPRB, &
 & 0.71530E-03_JPRB,0.76226E-03_JPRB,0.77693E-03_JPRB,0.76966E-03_JPRB /)  
KA(:, 3, 1,10) = (/ &
 & 0.43480E-03_JPRB,0.47183E-03_JPRB,0.54721E-03_JPRB,0.61831E-03_JPRB,0.67726E-03_JPRB, &
 & 0.72423E-03_JPRB,0.77288E-03_JPRB,0.78901E-03_JPRB,0.78603E-03_JPRB /)  
KA(:, 4, 1,10) = (/ &
 & 0.43220E-03_JPRB,0.46825E-03_JPRB,0.54213E-03_JPRB,0.61349E-03_JPRB,0.66880E-03_JPRB, &
 & 0.71215E-03_JPRB,0.75938E-03_JPRB,0.77341E-03_JPRB,0.76775E-03_JPRB /)  
KA(:, 5, 1,10) = (/ &
 & 0.42987E-03_JPRB,0.46597E-03_JPRB,0.54025E-03_JPRB,0.61237E-03_JPRB,0.66800E-03_JPRB, &
 & 0.70968E-03_JPRB,0.75599E-03_JPRB,0.77132E-03_JPRB,0.76754E-03_JPRB /)  
KA(:, 1, 2,10) = (/ &
 & 0.37934E-03_JPRB,0.43540E-03_JPRB,0.51852E-03_JPRB,0.59327E-03_JPRB,0.65919E-03_JPRB, &
 & 0.71028E-03_JPRB,0.75523E-03_JPRB,0.78660E-03_JPRB,0.77018E-03_JPRB /)  
KA(:, 2, 2,10) = (/ &
 & 0.37616E-03_JPRB,0.43418E-03_JPRB,0.51743E-03_JPRB,0.59232E-03_JPRB,0.65869E-03_JPRB, &
 & 0.70879E-03_JPRB,0.75385E-03_JPRB,0.78506E-03_JPRB,0.76914E-03_JPRB /)  
KA(:, 3, 2,10) = (/ &
 & 0.37285E-03_JPRB,0.43338E-03_JPRB,0.51992E-03_JPRB,0.59796E-03_JPRB,0.66588E-03_JPRB, &
 & 0.71863E-03_JPRB,0.76525E-03_JPRB,0.79746E-03_JPRB,0.78726E-03_JPRB /)  
KA(:, 4, 2,10) = (/ &
 & 0.36993E-03_JPRB,0.43092E-03_JPRB,0.51858E-03_JPRB,0.59729E-03_JPRB,0.66425E-03_JPRB, &
 & 0.71582E-03_JPRB,0.76129E-03_JPRB,0.79428E-03_JPRB,0.78557E-03_JPRB /)  
KA(:, 5, 2,10) = (/ &
 & 0.36795E-03_JPRB,0.42667E-03_JPRB,0.51498E-03_JPRB,0.59125E-03_JPRB,0.65451E-03_JPRB, &
 & 0.70295E-03_JPRB,0.74646E-03_JPRB,0.77706E-03_JPRB,0.76846E-03_JPRB /)  
KA(:, 1, 3,10) = (/ &
 & 0.32398E-03_JPRB,0.39840E-03_JPRB,0.48910E-03_JPRB,0.57202E-03_JPRB,0.64247E-03_JPRB, &
 & 0.69920E-03_JPRB,0.74272E-03_JPRB,0.78560E-03_JPRB,0.76158E-03_JPRB /)  
KA(:, 2, 3,10) = (/ &
 & 0.32107E-03_JPRB,0.39683E-03_JPRB,0.48877E-03_JPRB,0.57106E-03_JPRB,0.64200E-03_JPRB, &
 & 0.69780E-03_JPRB,0.74068E-03_JPRB,0.78389E-03_JPRB,0.76255E-03_JPRB /)  
KA(:, 3, 3,10) = (/ &
 & 0.31808E-03_JPRB,0.39502E-03_JPRB,0.48851E-03_JPRB,0.57104E-03_JPRB,0.64052E-03_JPRB, &
 & 0.69677E-03_JPRB,0.73846E-03_JPRB,0.78156E-03_JPRB,0.76341E-03_JPRB /)  
KA(:, 4, 3,10) = (/ &
 & 0.31534E-03_JPRB,0.39419E-03_JPRB,0.49223E-03_JPRB,0.57621E-03_JPRB,0.64746E-03_JPRB, &
 & 0.70569E-03_JPRB,0.74986E-03_JPRB,0.79350E-03_JPRB,0.78192E-03_JPRB /)  
KA(:, 5, 3,10) = (/ &
 & 0.31343E-03_JPRB,0.39031E-03_JPRB,0.48789E-03_JPRB,0.56911E-03_JPRB,0.63804E-03_JPRB, &
 & 0.69322E-03_JPRB,0.73529E-03_JPRB,0.77554E-03_JPRB,0.76249E-03_JPRB /)  
KA(:, 1, 4,10) = (/ &
 & 0.27516E-03_JPRB,0.36405E-03_JPRB,0.46107E-03_JPRB,0.54790E-03_JPRB,0.62253E-03_JPRB, &
 & 0.68384E-03_JPRB,0.73057E-03_JPRB,0.77856E-03_JPRB,0.74793E-03_JPRB /)  
KA(:, 2, 4,10) = (/ &
 & 0.27272E-03_JPRB,0.36262E-03_JPRB,0.46080E-03_JPRB,0.54700E-03_JPRB,0.62201E-03_JPRB, &
 & 0.68300E-03_JPRB,0.72976E-03_JPRB,0.77591E-03_JPRB,0.74919E-03_JPRB /)  
KA(:, 3, 4,10) = (/ &
 & 0.26991E-03_JPRB,0.36139E-03_JPRB,0.46064E-03_JPRB,0.54673E-03_JPRB,0.62063E-03_JPRB, &
 & 0.68269E-03_JPRB,0.72862E-03_JPRB,0.77298E-03_JPRB,0.75070E-03_JPRB /)  
KA(:, 4, 4,10) = (/ &
 & 0.26757E-03_JPRB,0.35993E-03_JPRB,0.46053E-03_JPRB,0.54625E-03_JPRB,0.61982E-03_JPRB, &
 & 0.68167E-03_JPRB,0.72799E-03_JPRB,0.77005E-03_JPRB,0.75046E-03_JPRB /)  
KA(:, 5, 4,10) = (/ &
 & 0.26556E-03_JPRB,0.36025E-03_JPRB,0.46433E-03_JPRB,0.55132E-03_JPRB,0.62683E-03_JPRB, &
 & 0.69143E-03_JPRB,0.74137E-03_JPRB,0.78366E-03_JPRB,0.76845E-03_JPRB /)  
KA(:, 1, 5,10) = (/ &
 & 0.23277E-03_JPRB,0.33279E-03_JPRB,0.43313E-03_JPRB,0.52236E-03_JPRB,0.59970E-03_JPRB, &
 & 0.66464E-03_JPRB,0.71686E-03_JPRB,0.76626E-03_JPRB,0.72457E-03_JPRB /)  
KA(:, 2, 5,10) = (/ &
 & 0.23078E-03_JPRB,0.33167E-03_JPRB,0.43303E-03_JPRB,0.52181E-03_JPRB,0.60054E-03_JPRB, &
 & 0.66529E-03_JPRB,0.71807E-03_JPRB,0.76458E-03_JPRB,0.72852E-03_JPRB /)  
KA(:, 3, 5,10) = (/ &
 & 0.22839E-03_JPRB,0.33111E-03_JPRB,0.43245E-03_JPRB,0.52229E-03_JPRB,0.60068E-03_JPRB, &
 & 0.66640E-03_JPRB,0.71880E-03_JPRB,0.76367E-03_JPRB,0.73165E-03_JPRB /)  
KA(:, 4, 5,10) = (/ &
 & 0.22634E-03_JPRB,0.33010E-03_JPRB,0.43234E-03_JPRB,0.52220E-03_JPRB,0.60179E-03_JPRB, &
 & 0.66699E-03_JPRB,0.71996E-03_JPRB,0.76305E-03_JPRB,0.73316E-03_JPRB /)  
KA(:, 5, 5,10) = (/ &
 & 0.22442E-03_JPRB,0.33158E-03_JPRB,0.43680E-03_JPRB,0.52864E-03_JPRB,0.61018E-03_JPRB, &
 & 0.67770E-03_JPRB,0.73371E-03_JPRB,0.78031E-03_JPRB,0.75138E-03_JPRB /)  
KA(:, 1, 6,10) = (/ &
 & 0.19685E-03_JPRB,0.30442E-03_JPRB,0.40547E-03_JPRB,0.49610E-03_JPRB,0.57453E-03_JPRB, &
 & 0.64299E-03_JPRB,0.69899E-03_JPRB,0.74954E-03_JPRB,0.69460E-03_JPRB /)  
KA(:, 2, 6,10) = (/ &
 & 0.19517E-03_JPRB,0.30338E-03_JPRB,0.40585E-03_JPRB,0.49683E-03_JPRB,0.57671E-03_JPRB, &
 & 0.64425E-03_JPRB,0.70130E-03_JPRB,0.75004E-03_JPRB,0.70036E-03_JPRB /)  
KA(:, 3, 6,10) = (/ &
 & 0.19324E-03_JPRB,0.30268E-03_JPRB,0.40573E-03_JPRB,0.49834E-03_JPRB,0.57803E-03_JPRB, &
 & 0.64627E-03_JPRB,0.70310E-03_JPRB,0.75130E-03_JPRB,0.70596E-03_JPRB /)  
KA(:, 4, 6,10) = (/ &
 & 0.19132E-03_JPRB,0.30224E-03_JPRB,0.40644E-03_JPRB,0.49947E-03_JPRB,0.58014E-03_JPRB, &
 & 0.64741E-03_JPRB,0.70472E-03_JPRB,0.75293E-03_JPRB,0.70917E-03_JPRB /)  
KA(:, 5, 6,10) = (/ &
 & 0.18952E-03_JPRB,0.30177E-03_JPRB,0.40672E-03_JPRB,0.50101E-03_JPRB,0.58137E-03_JPRB, &
 & 0.64847E-03_JPRB,0.70602E-03_JPRB,0.75537E-03_JPRB,0.71121E-03_JPRB /)  
KA(:, 1, 7,10) = (/ &
 & 0.16684E-03_JPRB,0.27825E-03_JPRB,0.37860E-03_JPRB,0.46883E-03_JPRB,0.54680E-03_JPRB, &
 & 0.61510E-03_JPRB,0.67386E-03_JPRB,0.72824E-03_JPRB,0.66391E-03_JPRB /)  
KA(:, 2, 7,10) = (/ &
 & 0.16553E-03_JPRB,0.27719E-03_JPRB,0.37963E-03_JPRB,0.47077E-03_JPRB,0.54985E-03_JPRB, &
 & 0.61768E-03_JPRB,0.67717E-03_JPRB,0.73093E-03_JPRB,0.67156E-03_JPRB /)  
KA(:, 3, 7,10) = (/ &
 & 0.16397E-03_JPRB,0.27663E-03_JPRB,0.38054E-03_JPRB,0.47308E-03_JPRB,0.55166E-03_JPRB, &
 & 0.62067E-03_JPRB,0.67975E-03_JPRB,0.73342E-03_JPRB,0.67787E-03_JPRB /)  
KA(:, 4, 7,10) = (/ &
 & 0.16246E-03_JPRB,0.27634E-03_JPRB,0.38198E-03_JPRB,0.47489E-03_JPRB,0.55414E-03_JPRB, &
 & 0.62280E-03_JPRB,0.68232E-03_JPRB,0.73600E-03_JPRB,0.68175E-03_JPRB /)  
KA(:, 5, 7,10) = (/ &
 & 0.16089E-03_JPRB,0.27624E-03_JPRB,0.38314E-03_JPRB,0.47665E-03_JPRB,0.55585E-03_JPRB, &
 & 0.62443E-03_JPRB,0.68436E-03_JPRB,0.73852E-03_JPRB,0.68559E-03_JPRB /)  
KA(:, 1, 8,10) = (/ &
 & 0.14215E-03_JPRB,0.25407E-03_JPRB,0.35215E-03_JPRB,0.43863E-03_JPRB,0.51443E-03_JPRB, &
 & 0.58154E-03_JPRB,0.64180E-03_JPRB,0.70004E-03_JPRB,0.62276E-03_JPRB /)  
KA(:, 2, 8,10) = (/ &
 & 0.14104E-03_JPRB,0.25332E-03_JPRB,0.35394E-03_JPRB,0.44179E-03_JPRB,0.51810E-03_JPRB, &
 & 0.58508E-03_JPRB,0.64584E-03_JPRB,0.70407E-03_JPRB,0.63285E-03_JPRB /)  
KA(:, 3, 8,10) = (/ &
 & 0.13977E-03_JPRB,0.25313E-03_JPRB,0.35560E-03_JPRB,0.44458E-03_JPRB,0.52101E-03_JPRB, &
 & 0.58953E-03_JPRB,0.65037E-03_JPRB,0.70785E-03_JPRB,0.64108E-03_JPRB /)  
KA(:, 4, 8,10) = (/ &
 & 0.13869E-03_JPRB,0.25332E-03_JPRB,0.35744E-03_JPRB,0.44722E-03_JPRB,0.52464E-03_JPRB, &
 & 0.59336E-03_JPRB,0.65468E-03_JPRB,0.71201E-03_JPRB,0.64611E-03_JPRB /)  
KA(:, 5, 8,10) = (/ &
 & 0.13742E-03_JPRB,0.25367E-03_JPRB,0.35927E-03_JPRB,0.44959E-03_JPRB,0.52752E-03_JPRB, &
 & 0.59656E-03_JPRB,0.65824E-03_JPRB,0.71554E-03_JPRB,0.65066E-03_JPRB /)  
KA(:, 1, 9,10) = (/ &
 & 0.12109E-03_JPRB,0.23210E-03_JPRB,0.32446E-03_JPRB,0.40715E-03_JPRB,0.48065E-03_JPRB, &
 & 0.54715E-03_JPRB,0.60775E-03_JPRB,0.66825E-03_JPRB,0.18336E-04_JPRB /)  
KA(:, 2, 9,10) = (/ &
 & 0.12018E-03_JPRB,0.23207E-03_JPRB,0.32699E-03_JPRB,0.41058E-03_JPRB,0.48505E-03_JPRB, &
 & 0.55180E-03_JPRB,0.61323E-03_JPRB,0.67309E-03_JPRB,0.24327E-04_JPRB /)  
KA(:, 3, 9,10) = (/ &
 & 0.11917E-03_JPRB,0.23229E-03_JPRB,0.32956E-03_JPRB,0.41390E-03_JPRB,0.48910E-03_JPRB, &
 & 0.55710E-03_JPRB,0.61911E-03_JPRB,0.67851E-03_JPRB,0.23065E-04_JPRB /)  
KA(:, 4, 9,10) = (/ &
 & 0.11843E-03_JPRB,0.23292E-03_JPRB,0.33197E-03_JPRB,0.41764E-03_JPRB,0.49354E-03_JPRB, &
 & 0.56238E-03_JPRB,0.62497E-03_JPRB,0.68395E-03_JPRB,0.23680E-04_JPRB /)  
KA(:, 5, 9,10) = (/ &
 & 0.11748E-03_JPRB,0.23365E-03_JPRB,0.33458E-03_JPRB,0.42109E-03_JPRB,0.49774E-03_JPRB, &
 & 0.56667E-03_JPRB,0.62987E-03_JPRB,0.68909E-03_JPRB,0.25905E-04_JPRB /)  
KA(:, 1,10,10) = (/ &
 & 0.10273E-03_JPRB,0.21204E-03_JPRB,0.29794E-03_JPRB,0.37761E-03_JPRB,0.44937E-03_JPRB, &
 & 0.51495E-03_JPRB,0.57567E-03_JPRB,0.63761E-03_JPRB,0.19724E-04_JPRB /)  
KA(:, 2,10,10) = (/ &
 & 0.10190E-03_JPRB,0.21272E-03_JPRB,0.30059E-03_JPRB,0.38150E-03_JPRB,0.45434E-03_JPRB, &
 & 0.52089E-03_JPRB,0.58270E-03_JPRB,0.64346E-03_JPRB,0.24197E-04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART7',1,ZHOOK_HANDLE)
END SUBROUTINE PART7


SUBROUTINE PART8

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART8',0,ZHOOK_HANDLE)


KA(:, 3,10,10) = (/ &
 & 0.10112E-03_JPRB,0.21334E-03_JPRB,0.30377E-03_JPRB,0.38507E-03_JPRB,0.45917E-03_JPRB, &
 & 0.52739E-03_JPRB,0.58976E-03_JPRB,0.64941E-03_JPRB,0.34326E-04_JPRB /)  
KA(:, 4,10,10) = (/ &
 & 0.10061E-03_JPRB,0.21443E-03_JPRB,0.30659E-03_JPRB,0.38965E-03_JPRB,0.46453E-03_JPRB, &
 & 0.53354E-03_JPRB,0.59675E-03_JPRB,0.65639E-03_JPRB,0.33702E-04_JPRB /)  
KA(:, 5,10,10) = (/ &
 & 0.99890E-04_JPRB,0.21543E-03_JPRB,0.30998E-03_JPRB,0.39375E-03_JPRB,0.46925E-03_JPRB, &
 & 0.53804E-03_JPRB,0.60223E-03_JPRB,0.66255E-03_JPRB,0.31412E-04_JPRB /)  
KA(:, 1,11,10) = (/ &
 & 0.86338E-04_JPRB,0.19398E-03_JPRB,0.27516E-03_JPRB,0.35204E-03_JPRB,0.42116E-03_JPRB, &
 & 0.48556E-03_JPRB,0.54615E-03_JPRB,0.60927E-03_JPRB,0.19945E-04_JPRB /)  
KA(:, 2,11,10) = (/ &
 & 0.85730E-04_JPRB,0.19502E-03_JPRB,0.27834E-03_JPRB,0.35636E-03_JPRB,0.42792E-03_JPRB, &
 & 0.49403E-03_JPRB,0.55597E-03_JPRB,0.61737E-03_JPRB,0.90093E-05_JPRB /)  
KA(:, 3,11,10) = (/ &
 & 0.85275E-04_JPRB,0.19618E-03_JPRB,0.28168E-03_JPRB,0.36165E-03_JPRB,0.43438E-03_JPRB, &
 & 0.50224E-03_JPRB,0.56492E-03_JPRB,0.62614E-03_JPRB,0.37496E-04_JPRB /)  
KA(:, 4,11,10) = (/ &
 & 0.84865E-04_JPRB,0.19761E-03_JPRB,0.28526E-03_JPRB,0.36657E-03_JPRB,0.44042E-03_JPRB, &
 & 0.50863E-03_JPRB,0.57263E-03_JPRB,0.63413E-03_JPRB,0.15044E-04_JPRB /)  
KA(:, 5,11,10) = (/ &
 & 0.84443E-04_JPRB,0.19914E-03_JPRB,0.28886E-03_JPRB,0.37069E-03_JPRB,0.44492E-03_JPRB, &
 & 0.51377E-03_JPRB,0.57803E-03_JPRB,0.63993E-03_JPRB,0.48683E-04_JPRB /)  
KA(:, 1,12,10) = (/ &
 & 0.72237E-04_JPRB,0.17794E-03_JPRB,0.25491E-03_JPRB,0.32737E-03_JPRB,0.39376E-03_JPRB, &
 & 0.45690E-03_JPRB,0.51684E-03_JPRB,0.58057E-03_JPRB,0.10800E-04_JPRB /)  
KA(:, 2,12,10) = (/ &
 & 0.71846E-04_JPRB,0.17916E-03_JPRB,0.25896E-03_JPRB,0.33355E-03_JPRB,0.40234E-03_JPRB, &
 & 0.46708E-03_JPRB,0.52856E-03_JPRB,0.59174E-03_JPRB,0.37304E-04_JPRB /)  
KA(:, 3,12,10) = (/ &
 & 0.71641E-04_JPRB,0.18095E-03_JPRB,0.26291E-03_JPRB,0.34013E-03_JPRB,0.41022E-03_JPRB, &
 & 0.47645E-03_JPRB,0.53911E-03_JPRB,0.60240E-03_JPRB,0.20066E-04_JPRB /)  
KA(:, 4,12,10) = (/ &
 & 0.71337E-04_JPRB,0.18255E-03_JPRB,0.26698E-03_JPRB,0.34557E-03_JPRB,0.41722E-03_JPRB, &
 & 0.48390E-03_JPRB,0.54753E-03_JPRB,0.61134E-03_JPRB,0.20267E-04_JPRB /)  
KA(:, 5,12,10) = (/ &
 & 0.71187E-04_JPRB,0.18456E-03_JPRB,0.27032E-03_JPRB,0.35012E-03_JPRB,0.42265E-03_JPRB, &
 & 0.49079E-03_JPRB,0.55462E-03_JPRB,0.61760E-03_JPRB,0.29175E-04_JPRB /)  
KA(:, 1,13,10) = (/ &
 & 0.60308E-04_JPRB,0.16344E-03_JPRB,0.23674E-03_JPRB,0.30451E-03_JPRB,0.36859E-03_JPRB, &
 & 0.42973E-03_JPRB,0.48896E-03_JPRB,0.55265E-03_JPRB,0.35870E-04_JPRB /)  
KA(:, 2,13,10) = (/ &
 & 0.60075E-04_JPRB,0.16518E-03_JPRB,0.24182E-03_JPRB,0.31202E-03_JPRB,0.37817E-03_JPRB, &
 & 0.44097E-03_JPRB,0.50163E-03_JPRB,0.56563E-03_JPRB,0.24717E-04_JPRB /)  
KA(:, 3,13,10) = (/ &
 & 0.59963E-04_JPRB,0.16736E-03_JPRB,0.24636E-03_JPRB,0.31956E-03_JPRB,0.38717E-03_JPRB, &
 & 0.45122E-03_JPRB,0.51282E-03_JPRB,0.57786E-03_JPRB,0.24967E-04_JPRB /)  
KA(:, 4,13,10) = (/ &
 & 0.59808E-04_JPRB,0.16950E-03_JPRB,0.25081E-03_JPRB,0.32559E-03_JPRB,0.39488E-03_JPRB, &
 & 0.45992E-03_JPRB,0.52243E-03_JPRB,0.58716E-03_JPRB,0.25073E-04_JPRB /)  
KA(:, 5,13,10) = (/ &
 & 0.59738E-04_JPRB,0.17182E-03_JPRB,0.25430E-03_JPRB,0.33121E-03_JPRB,0.40220E-03_JPRB, &
 & 0.46925E-03_JPRB,0.53224E-03_JPRB,0.59573E-03_JPRB,0.14031E-04_JPRB /)  
KA(:, 1, 1,11) = (/ &
 & 0.79109E-03_JPRB,0.77354E-03_JPRB,0.84795E-03_JPRB,0.91837E-03_JPRB,0.98287E-03_JPRB, &
 & 0.10467E-02_JPRB,0.10876E-02_JPRB,0.10899E-02_JPRB,0.10918E-02_JPRB /)  
KA(:, 2, 1,11) = (/ &
 & 0.79035E-03_JPRB,0.76999E-03_JPRB,0.84502E-03_JPRB,0.91315E-03_JPRB,0.97569E-03_JPRB, &
 & 0.10420E-02_JPRB,0.10843E-02_JPRB,0.10840E-02_JPRB,0.10904E-02_JPRB /)  
KA(:, 3, 1,11) = (/ &
 & 0.79094E-03_JPRB,0.76969E-03_JPRB,0.84501E-03_JPRB,0.91212E-03_JPRB,0.97616E-03_JPRB, &
 & 0.10502E-02_JPRB,0.10978E-02_JPRB,0.10968E-02_JPRB,0.11098E-02_JPRB /)  
KA(:, 4, 1,11) = (/ &
 & 0.79012E-03_JPRB,0.76698E-03_JPRB,0.84052E-03_JPRB,0.90224E-03_JPRB,0.96448E-03_JPRB, &
 & 0.10367E-02_JPRB,0.10810E-02_JPRB,0.10798E-02_JPRB,0.10838E-02_JPRB /)  
KA(:, 5, 1,11) = (/ &
 & 0.78840E-03_JPRB,0.76416E-03_JPRB,0.83816E-03_JPRB,0.89971E-03_JPRB,0.96199E-03_JPRB, &
 & 0.10344E-02_JPRB,0.10796E-02_JPRB,0.10773E-02_JPRB,0.10800E-02_JPRB /)  
KA(:, 1, 2,11) = (/ &
 & 0.69789E-03_JPRB,0.72093E-03_JPRB,0.81475E-03_JPRB,0.89922E-03_JPRB,0.96655E-03_JPRB, &
 & 0.10286E-02_JPRB,0.10852E-02_JPRB,0.10968E-02_JPRB,0.10998E-02_JPRB /)  
KA(:, 2, 2,11) = (/ &
 & 0.69799E-03_JPRB,0.71831E-03_JPRB,0.81026E-03_JPRB,0.89390E-03_JPRB,0.96162E-03_JPRB, &
 & 0.10278E-02_JPRB,0.10853E-02_JPRB,0.10953E-02_JPRB,0.10980E-02_JPRB /)  
KA(:, 3, 2,11) = (/ &
 & 0.69849E-03_JPRB,0.71872E-03_JPRB,0.81039E-03_JPRB,0.89368E-03_JPRB,0.96713E-03_JPRB, &
 & 0.10387E-02_JPRB,0.11003E-02_JPRB,0.11139E-02_JPRB,0.11199E-02_JPRB /)  
KA(:, 4, 2,11) = (/ &
 & 0.69786E-03_JPRB,0.71702E-03_JPRB,0.80831E-03_JPRB,0.88926E-03_JPRB,0.96426E-03_JPRB, &
 & 0.10353E-02_JPRB,0.10976E-02_JPRB,0.11107E-02_JPRB,0.11152E-02_JPRB /)  
KA(:, 5, 2,11) = (/ &
 & 0.69639E-03_JPRB,0.71420E-03_JPRB,0.80246E-03_JPRB,0.88289E-03_JPRB,0.95515E-03_JPRB, &
 & 0.10226E-02_JPRB,0.10812E-02_JPRB,0.10915E-02_JPRB,0.10904E-02_JPRB /)  
KA(:, 1, 3,11) = (/ &
 & 0.60717E-03_JPRB,0.66595E-03_JPRB,0.77916E-03_JPRB,0.87509E-03_JPRB,0.95372E-03_JPRB, &
 & 0.10167E-02_JPRB,0.10820E-02_JPRB,0.11070E-02_JPRB,0.11005E-02_JPRB /)  
KA(:, 2, 3,11) = (/ &
 & 0.60740E-03_JPRB,0.66447E-03_JPRB,0.77425E-03_JPRB,0.87078E-03_JPRB,0.95087E-03_JPRB, &
 & 0.10164E-02_JPRB,0.10820E-02_JPRB,0.11070E-02_JPRB,0.10996E-02_JPRB /)  
KA(:, 3, 3,11) = (/ &
 & 0.60743E-03_JPRB,0.66421E-03_JPRB,0.77076E-03_JPRB,0.86668E-03_JPRB,0.94936E-03_JPRB, &
 & 0.10146E-02_JPRB,0.10809E-02_JPRB,0.11066E-02_JPRB,0.10979E-02_JPRB /)  
KA(:, 4, 3,11) = (/ &
 & 0.60721E-03_JPRB,0.66487E-03_JPRB,0.77207E-03_JPRB,0.87093E-03_JPRB,0.95679E-03_JPRB, &
 & 0.10247E-02_JPRB,0.10950E-02_JPRB,0.11248E-02_JPRB,0.11171E-02_JPRB /)  
KA(:, 5, 3,11) = (/ &
 & 0.60632E-03_JPRB,0.66259E-03_JPRB,0.76645E-03_JPRB,0.86469E-03_JPRB,0.94611E-03_JPRB, &
 & 0.10116E-02_JPRB,0.10778E-02_JPRB,0.11040E-02_JPRB,0.10953E-02_JPRB /)  
KA(:, 1, 4,11) = (/ &
 & 0.52196E-03_JPRB,0.61309E-03_JPRB,0.74127E-03_JPRB,0.84825E-03_JPRB,0.93805E-03_JPRB, &
 & 0.10078E-02_JPRB,0.10732E-02_JPRB,0.11156E-02_JPRB,0.10964E-02_JPRB /)  
KA(:, 2, 4,11) = (/ &
 & 0.52205E-03_JPRB,0.61209E-03_JPRB,0.73709E-03_JPRB,0.84586E-03_JPRB,0.93585E-03_JPRB, &
 & 0.10074E-02_JPRB,0.10727E-02_JPRB,0.11168E-02_JPRB,0.10976E-02_JPRB /)  
KA(:, 3, 4,11) = (/ &
 & 0.52218E-03_JPRB,0.61175E-03_JPRB,0.73426E-03_JPRB,0.84316E-03_JPRB,0.93485E-03_JPRB, &
 & 0.10055E-02_JPRB,0.10718E-02_JPRB,0.11162E-02_JPRB,0.10985E-02_JPRB /)  
KA(:, 4, 4,11) = (/ &
 & 0.52176E-03_JPRB,0.61131E-03_JPRB,0.73315E-03_JPRB,0.84162E-03_JPRB,0.93319E-03_JPRB, &
 & 0.10035E-02_JPRB,0.10709E-02_JPRB,0.11149E-02_JPRB,0.11000E-02_JPRB /)  
KA(:, 5, 4,11) = (/ &
 & 0.52100E-03_JPRB,0.61215E-03_JPRB,0.73639E-03_JPRB,0.84868E-03_JPRB,0.94102E-03_JPRB, &
 & 0.10132E-02_JPRB,0.10822E-02_JPRB,0.11303E-02_JPRB,0.11192E-02_JPRB /)  
KA(:, 1, 5,11) = (/ &
 & 0.44537E-03_JPRB,0.56415E-03_JPRB,0.70334E-03_JPRB,0.81986E-03_JPRB,0.91737E-03_JPRB, &
 & 0.99505E-03_JPRB,0.10590E-02_JPRB,0.11155E-02_JPRB,0.10855E-02_JPRB /)  
KA(:, 2, 5,11) = (/ &
 & 0.44499E-03_JPRB,0.56304E-03_JPRB,0.70021E-03_JPRB,0.81824E-03_JPRB,0.91496E-03_JPRB, &
 & 0.99465E-03_JPRB,0.10577E-02_JPRB,0.11163E-02_JPRB,0.10886E-02_JPRB /)  
KA(:, 3, 5,11) = (/ &
 & 0.44481E-03_JPRB,0.56231E-03_JPRB,0.69884E-03_JPRB,0.81557E-03_JPRB,0.91387E-03_JPRB, &
 & 0.99269E-03_JPRB,0.10566E-02_JPRB,0.11154E-02_JPRB,0.10925E-02_JPRB /)  
KA(:, 4, 5,11) = (/ &
 & 0.44459E-03_JPRB,0.56155E-03_JPRB,0.69827E-03_JPRB,0.81462E-03_JPRB,0.91145E-03_JPRB, &
 & 0.99105E-03_JPRB,0.10558E-02_JPRB,0.11141E-02_JPRB,0.10950E-02_JPRB /)  
KA(:, 5, 5,11) = (/ &
 & 0.44401E-03_JPRB,0.56266E-03_JPRB,0.70342E-03_JPRB,0.82262E-03_JPRB,0.92017E-03_JPRB, &
 & 0.10017E-02_JPRB,0.10686E-02_JPRB,0.11300E-02_JPRB,0.11166E-02_JPRB /)  
KA(:, 1, 6,11) = (/ &
 & 0.37714E-03_JPRB,0.51787E-03_JPRB,0.66544E-03_JPRB,0.78793E-03_JPRB,0.89178E-03_JPRB, &
 & 0.97506E-03_JPRB,0.10421E-02_JPRB,0.11072E-02_JPRB,0.10679E-02_JPRB /)  
KA(:, 2, 6,11) = (/ &
 & 0.37645E-03_JPRB,0.51719E-03_JPRB,0.66329E-03_JPRB,0.78619E-03_JPRB,0.88946E-03_JPRB, &
 & 0.97613E-03_JPRB,0.10421E-02_JPRB,0.11076E-02_JPRB,0.10727E-02_JPRB /)  
KA(:, 3, 6,11) = (/ &
 & 0.37621E-03_JPRB,0.51663E-03_JPRB,0.66248E-03_JPRB,0.78421E-03_JPRB,0.88840E-03_JPRB, &
 & 0.97530E-03_JPRB,0.10423E-02_JPRB,0.11074E-02_JPRB,0.10773E-02_JPRB /)  
KA(:, 4, 6,11) = (/ &
 & 0.37625E-03_JPRB,0.51591E-03_JPRB,0.66198E-03_JPRB,0.78342E-03_JPRB,0.88665E-03_JPRB, &
 & 0.97510E-03_JPRB,0.10427E-02_JPRB,0.11065E-02_JPRB,0.10807E-02_JPRB /)  
KA(:, 5, 6,11) = (/ &
 & 0.37578E-03_JPRB,0.51583E-03_JPRB,0.66231E-03_JPRB,0.78322E-03_JPRB,0.88597E-03_JPRB, &
 & 0.97458E-03_JPRB,0.10416E-02_JPRB,0.11045E-02_JPRB,0.10828E-02_JPRB /)  
KA(:, 1, 7,11) = (/ &
 & 0.31849E-03_JPRB,0.47598E-03_JPRB,0.62784E-03_JPRB,0.75245E-03_JPRB,0.86097E-03_JPRB, &
 & 0.95037E-03_JPRB,0.10228E-02_JPRB,0.10907E-02_JPRB,0.10381E-02_JPRB /)  
KA(:, 2, 7,11) = (/ &
 & 0.31748E-03_JPRB,0.47565E-03_JPRB,0.62625E-03_JPRB,0.75127E-03_JPRB,0.86016E-03_JPRB, &
 & 0.95292E-03_JPRB,0.10249E-02_JPRB,0.10924E-02_JPRB,0.10446E-02_JPRB /)  
KA(:, 3, 7,11) = (/ &
 & 0.31709E-03_JPRB,0.47527E-03_JPRB,0.62527E-03_JPRB,0.75044E-03_JPRB,0.86086E-03_JPRB, &
 & 0.95398E-03_JPRB,0.10272E-02_JPRB,0.10943E-02_JPRB,0.10513E-02_JPRB /)  
KA(:, 4, 7,11) = (/ &
 & 0.31690E-03_JPRB,0.47506E-03_JPRB,0.62534E-03_JPRB,0.75023E-03_JPRB,0.86098E-03_JPRB, &
 & 0.95576E-03_JPRB,0.10298E-02_JPRB,0.10956E-02_JPRB,0.10570E-02_JPRB /)  
KA(:, 5, 7,11) = (/ &
 & 0.31661E-03_JPRB,0.47556E-03_JPRB,0.62564E-03_JPRB,0.75129E-03_JPRB,0.86194E-03_JPRB, &
 & 0.95752E-03_JPRB,0.10312E-02_JPRB,0.10967E-02_JPRB,0.10605E-02_JPRB /)  
KA(:, 1, 8,11) = (/ &
 & 0.26920E-03_JPRB,0.43740E-03_JPRB,0.58907E-03_JPRB,0.71604E-03_JPRB,0.82585E-03_JPRB, &
 & 0.92017E-03_JPRB,0.99828E-03_JPRB,0.10677E-02_JPRB,0.99191E-03_JPRB /)  
KA(:, 2, 8,11) = (/ &
 & 0.26802E-03_JPRB,0.43738E-03_JPRB,0.58846E-03_JPRB,0.71590E-03_JPRB,0.82753E-03_JPRB, &
 & 0.92484E-03_JPRB,0.10036E-02_JPRB,0.10726E-02_JPRB,0.10010E-02_JPRB /)  
KA(:, 3, 8,11) = (/ &
 & 0.26738E-03_JPRB,0.43742E-03_JPRB,0.58827E-03_JPRB,0.71679E-03_JPRB,0.83051E-03_JPRB, &
 & 0.92821E-03_JPRB,0.10079E-02_JPRB,0.10772E-02_JPRB,0.10102E-02_JPRB /)  
KA(:, 4, 8,11) = (/ &
 & 0.26701E-03_JPRB,0.43751E-03_JPRB,0.58933E-03_JPRB,0.71793E-03_JPRB,0.83304E-03_JPRB, &
 & 0.93190E-03_JPRB,0.10124E-02_JPRB,0.10810E-02_JPRB,0.10188E-02_JPRB /)  
KA(:, 5, 8,11) = (/ &
 & 0.26686E-03_JPRB,0.43824E-03_JPRB,0.58999E-03_JPRB,0.72050E-03_JPRB,0.83607E-03_JPRB, &
 & 0.93581E-03_JPRB,0.10160E-02_JPRB,0.10848E-02_JPRB,0.10263E-02_JPRB /)  
KA(:, 1, 9,11) = (/ &
 & 0.22904E-03_JPRB,0.40123E-03_JPRB,0.55115E-03_JPRB,0.67712E-03_JPRB,0.78732E-03_JPRB, &
 & 0.88313E-03_JPRB,0.96568E-03_JPRB,0.10387E-02_JPRB,0.14403E-04_JPRB /)  
KA(:, 2, 9,11) = (/ &
 & 0.22775E-03_JPRB,0.40129E-03_JPRB,0.55155E-03_JPRB,0.67918E-03_JPRB,0.79168E-03_JPRB, &
 & 0.89045E-03_JPRB,0.97356E-03_JPRB,0.10468E-02_JPRB,0.17396E-04_JPRB /)  
KA(:, 3, 9,11) = (/ &
 & 0.22691E-03_JPRB,0.40187E-03_JPRB,0.55239E-03_JPRB,0.68238E-03_JPRB,0.79664E-03_JPRB, &
 & 0.89641E-03_JPRB,0.98013E-03_JPRB,0.10538E-02_JPRB,0.17983E-04_JPRB /)  
KA(:, 4, 9,11) = (/ &
 & 0.22637E-03_JPRB,0.40220E-03_JPRB,0.55452E-03_JPRB,0.68525E-03_JPRB,0.80145E-03_JPRB, &
 & 0.90223E-03_JPRB,0.98673E-03_JPRB,0.10599E-02_JPRB,0.14884E-04_JPRB /)  
KA(:, 5, 9,11) = (/ &
 & 0.22595E-03_JPRB,0.40316E-03_JPRB,0.55613E-03_JPRB,0.68950E-03_JPRB,0.80623E-03_JPRB, &
 & 0.90849E-03_JPRB,0.99244E-03_JPRB,0.10655E-02_JPRB,0.19485E-04_JPRB /)  
KA(:, 1,10,11) = (/ &
 & 0.19610E-03_JPRB,0.36707E-03_JPRB,0.51305E-03_JPRB,0.63612E-03_JPRB,0.74337E-03_JPRB, &
 & 0.83875E-03_JPRB,0.92458E-03_JPRB,0.10007E-02_JPRB,0.30583E-04_JPRB /)  
KA(:, 2,10,11) = (/ &
 & 0.19499E-03_JPRB,0.36759E-03_JPRB,0.51501E-03_JPRB,0.64066E-03_JPRB,0.75082E-03_JPRB, &
 & 0.84853E-03_JPRB,0.93443E-03_JPRB,0.10117E-02_JPRB,0.20484E-04_JPRB /)  
KA(:, 3,10,11) = (/ &
 & 0.19427E-03_JPRB,0.36886E-03_JPRB,0.51745E-03_JPRB,0.64625E-03_JPRB,0.75815E-03_JPRB, &
 & 0.85733E-03_JPRB,0.94303E-03_JPRB,0.10217E-02_JPRB,0.20784E-04_JPRB /)  
KA(:, 4,10,11) = (/ &
 & 0.19367E-03_JPRB,0.36958E-03_JPRB,0.52106E-03_JPRB,0.65093E-03_JPRB,0.76545E-03_JPRB, &
 & 0.86571E-03_JPRB,0.95244E-03_JPRB,0.10301E-02_JPRB,0.30511E-04_JPRB /)  
KA(:, 5,10,11) = (/ &
 & 0.19319E-03_JPRB,0.37098E-03_JPRB,0.52409E-03_JPRB,0.65675E-03_JPRB,0.77258E-03_JPRB, &
 & 0.87491E-03_JPRB,0.96110E-03_JPRB,0.10378E-02_JPRB,0.19883E-04_JPRB /)  
KA(:, 1,11,11) = (/ &
 & 0.16767E-03_JPRB,0.33624E-03_JPRB,0.47635E-03_JPRB,0.59543E-03_JPRB,0.70301E-03_JPRB, &
 & 0.79872E-03_JPRB,0.88652E-03_JPRB,0.96550E-03_JPRB,0.27483E-04_JPRB /)  
KA(:, 2,11,11) = (/ &
 & 0.16687E-03_JPRB,0.33764E-03_JPRB,0.48055E-03_JPRB,0.60283E-03_JPRB,0.71186E-03_JPRB, &
 & 0.80978E-03_JPRB,0.89673E-03_JPRB,0.97758E-03_JPRB,0.20639E-04_JPRB /)  
KA(:, 3,11,11) = (/ &
 & 0.16664E-03_JPRB,0.33942E-03_JPRB,0.48524E-03_JPRB,0.60962E-03_JPRB,0.72075E-03_JPRB, &
 & 0.81953E-03_JPRB,0.90753E-03_JPRB,0.98729E-03_JPRB,0.27689E-04_JPRB /)  
KA(:, 4,11,11) = (/ &
 & 0.16611E-03_JPRB,0.34104E-03_JPRB,0.48994E-03_JPRB,0.61708E-03_JPRB,0.72992E-03_JPRB, &
 & 0.83047E-03_JPRB,0.91898E-03_JPRB,0.99769E-03_JPRB,0.13719E-04_JPRB /)  
KA(:, 5,11,11) = (/ &
 & 0.16596E-03_JPRB,0.34313E-03_JPRB,0.49467E-03_JPRB,0.62538E-03_JPRB,0.73960E-03_JPRB, &
 & 0.84171E-03_JPRB,0.92999E-03_JPRB,0.10075E-02_JPRB,0.27137E-04_JPRB /)  
KA(:, 1,12,11) = (/ &
 & 0.14282E-03_JPRB,0.30890E-03_JPRB,0.44183E-03_JPRB,0.55831E-03_JPRB,0.66503E-03_JPRB, &
 & 0.76077E-03_JPRB,0.84890E-03_JPRB,0.93128E-03_JPRB,0.21228E-04_JPRB /)  
KA(:, 2,12,11) = (/ &
 & 0.14255E-03_JPRB,0.31125E-03_JPRB,0.44731E-03_JPRB,0.56685E-03_JPRB,0.67491E-03_JPRB, &
 & 0.77277E-03_JPRB,0.86092E-03_JPRB,0.94274E-03_JPRB,0.32331E-04_JPRB /)  
KA(:, 3,12,11) = (/ &
 & 0.14244E-03_JPRB,0.31334E-03_JPRB,0.45354E-03_JPRB,0.57479E-03_JPRB,0.68552E-03_JPRB, &
 & 0.78420E-03_JPRB,0.87396E-03_JPRB,0.95434E-03_JPRB,0.19978E-06_JPRB /)  
KA(:, 4,12,11) = (/ &
 & 0.14239E-03_JPRB,0.31614E-03_JPRB,0.45984E-03_JPRB,0.58419E-03_JPRB,0.69607E-03_JPRB, &
 & 0.79750E-03_JPRB,0.88765E-03_JPRB,0.96637E-03_JPRB,0.21475E-04_JPRB /)  
KA(:, 5,12,11) = (/ &
 & 0.14252E-03_JPRB,0.31876E-03_JPRB,0.46658E-03_JPRB,0.59385E-03_JPRB,0.70775E-03_JPRB, &
 & 0.80986E-03_JPRB,0.90037E-03_JPRB,0.97814E-03_JPRB,0.21476E-04_JPRB /)  
KA(:, 1,13,11) = (/ &
 & 0.12125E-03_JPRB,0.28444E-03_JPRB,0.41080E-03_JPRB,0.52444E-03_JPRB,0.62932E-03_JPRB, &
 & 0.72481E-03_JPRB,0.81245E-03_JPRB,0.89716E-03_JPRB,0.27405E-04_JPRB /)  
KA(:, 2,13,11) = (/ &
 & 0.12138E-03_JPRB,0.28788E-03_JPRB,0.41712E-03_JPRB,0.53396E-03_JPRB,0.64078E-03_JPRB, &
 & 0.73819E-03_JPRB,0.82737E-03_JPRB,0.91020E-03_JPRB,0.13699E-04_JPRB /)  
KA(:, 3,13,11) = (/ &
 & 0.12142E-03_JPRB,0.29086E-03_JPRB,0.42441E-03_JPRB,0.54338E-03_JPRB,0.65260E-03_JPRB, &
 & 0.75224E-03_JPRB,0.84352E-03_JPRB,0.92398E-03_JPRB,0.13820E-04_JPRB /)  
KA(:, 4,13,11) = (/ &
 & 0.12174E-03_JPRB,0.29430E-03_JPRB,0.43176E-03_JPRB,0.55440E-03_JPRB,0.66546E-03_JPRB, &
 & 0.76738E-03_JPRB,0.85914E-03_JPRB,0.93821E-03_JPRB,0.26505E-06_JPRB /)  
KA(:, 5,13,11) = (/ &
 & 0.12197E-03_JPRB,0.29750E-03_JPRB,0.43989E-03_JPRB,0.56500E-03_JPRB,0.67844E-03_JPRB, &
 & 0.78071E-03_JPRB,0.87280E-03_JPRB,0.95108E-03_JPRB,0.33764E-06_JPRB /)  
KA(:, 1, 1,12) = (/ &
 & 0.15537E-02_JPRB,0.13818E-02_JPRB,0.14273E-02_JPRB,0.15055E-02_JPRB,0.15786E-02_JPRB, &
 & 0.16339E-02_JPRB,0.16467E-02_JPRB,0.15800E-02_JPRB,0.16050E-02_JPRB /)  
KA(:, 2, 1,12) = (/ &
 & 0.15485E-02_JPRB,0.13765E-02_JPRB,0.14181E-02_JPRB,0.14978E-02_JPRB,0.15727E-02_JPRB, &
 & 0.16256E-02_JPRB,0.16371E-02_JPRB,0.15728E-02_JPRB,0.16005E-02_JPRB /)  
KA(:, 3, 1,12) = (/ &
 & 0.15437E-02_JPRB,0.13722E-02_JPRB,0.14122E-02_JPRB,0.14971E-02_JPRB,0.15752E-02_JPRB, &
 & 0.16261E-02_JPRB,0.16396E-02_JPRB,0.15797E-02_JPRB,0.16209E-02_JPRB /)  
KA(:, 4, 1,12) = (/ &
 & 0.15424E-02_JPRB,0.13691E-02_JPRB,0.14015E-02_JPRB,0.14839E-02_JPRB,0.15593E-02_JPRB, &
 & 0.16040E-02_JPRB,0.16150E-02_JPRB,0.15487E-02_JPRB,0.15957E-02_JPRB /)  
KA(:, 5, 1,12) = (/ &
 & 0.15425E-02_JPRB,0.13681E-02_JPRB,0.13961E-02_JPRB,0.14766E-02_JPRB,0.15502E-02_JPRB, &
 & 0.15943E-02_JPRB,0.16046E-02_JPRB,0.15376E-02_JPRB,0.15923E-02_JPRB /)  
KA(:, 1, 2,12) = (/ &
 & 0.14274E-02_JPRB,0.13101E-02_JPRB,0.13901E-02_JPRB,0.14665E-02_JPRB,0.15597E-02_JPRB, &
 & 0.16365E-02_JPRB,0.16682E-02_JPRB,0.16286E-02_JPRB,0.16381E-02_JPRB /)  
KA(:, 2, 2,12) = (/ &
 & 0.14223E-02_JPRB,0.13039E-02_JPRB,0.13828E-02_JPRB,0.14629E-02_JPRB,0.15522E-02_JPRB, &
 & 0.16256E-02_JPRB,0.16567E-02_JPRB,0.16183E-02_JPRB,0.16362E-02_JPRB /)  
KA(:, 3, 2,12) = (/ &
 & 0.14195E-02_JPRB,0.12999E-02_JPRB,0.13791E-02_JPRB,0.14641E-02_JPRB,0.15538E-02_JPRB, &
 & 0.16259E-02_JPRB,0.16605E-02_JPRB,0.16235E-02_JPRB,0.16585E-02_JPRB /)  
KA(:, 4, 2,12) = (/ &
 & 0.14181E-02_JPRB,0.12958E-02_JPRB,0.13726E-02_JPRB,0.14576E-02_JPRB,0.15447E-02_JPRB, &
 & 0.16149E-02_JPRB,0.16487E-02_JPRB,0.16101E-02_JPRB,0.16540E-02_JPRB /)  
KA(:, 5, 2,12) = (/ &
 & 0.14191E-02_JPRB,0.12933E-02_JPRB,0.13650E-02_JPRB,0.14448E-02_JPRB,0.15270E-02_JPRB, &
 & 0.15959E-02_JPRB,0.16273E-02_JPRB,0.15850E-02_JPRB,0.16279E-02_JPRB /)  
KA(:, 1, 3,12) = (/ &
 & 0.12975E-02_JPRB,0.12495E-02_JPRB,0.13516E-02_JPRB,0.14440E-02_JPRB,0.15390E-02_JPRB, &
 & 0.16298E-02_JPRB,0.16807E-02_JPRB,0.16634E-02_JPRB,0.16697E-02_JPRB /)  
KA(:, 2, 3,12) = (/ &
 & 0.12938E-02_JPRB,0.12434E-02_JPRB,0.13457E-02_JPRB,0.14406E-02_JPRB,0.15301E-02_JPRB, &
 & 0.16196E-02_JPRB,0.16709E-02_JPRB,0.16534E-02_JPRB,0.16671E-02_JPRB /)  
KA(:, 3, 3,12) = (/ &
 & 0.12920E-02_JPRB,0.12378E-02_JPRB,0.13412E-02_JPRB,0.14340E-02_JPRB,0.15221E-02_JPRB, &
 & 0.16094E-02_JPRB,0.16610E-02_JPRB,0.16426E-02_JPRB,0.16655E-02_JPRB /)  
KA(:, 4, 3,12) = (/ &
 & 0.12905E-02_JPRB,0.12343E-02_JPRB,0.13399E-02_JPRB,0.14335E-02_JPRB,0.15224E-02_JPRB, &
 & 0.16137E-02_JPRB,0.16692E-02_JPRB,0.16519E-02_JPRB,0.16891E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART8',1,ZHOOK_HANDLE)
END SUBROUTINE PART8


SUBROUTINE PART9

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART9',0,ZHOOK_HANDLE)


KA(:, 5, 3,12) = (/ &
 & 0.12916E-02_JPRB,0.12305E-02_JPRB,0.13333E-02_JPRB,0.14197E-02_JPRB,0.15049E-02_JPRB, &
 & 0.15945E-02_JPRB,0.16481E-02_JPRB,0.16282E-02_JPRB,0.16593E-02_JPRB /)  
KA(:, 1, 4,12) = (/ &
 & 0.11586E-02_JPRB,0.11791E-02_JPRB,0.13059E-02_JPRB,0.14246E-02_JPRB,0.15191E-02_JPRB, &
 & 0.16155E-02_JPRB,0.16888E-02_JPRB,0.16884E-02_JPRB,0.16900E-02_JPRB /)  
KA(:, 2, 4,12) = (/ &
 & 0.11563E-02_JPRB,0.11735E-02_JPRB,0.13020E-02_JPRB,0.14191E-02_JPRB,0.15117E-02_JPRB, &
 & 0.16067E-02_JPRB,0.16804E-02_JPRB,0.16804E-02_JPRB,0.16885E-02_JPRB /)  
KA(:, 3, 4,12) = (/ &
 & 0.11547E-02_JPRB,0.11684E-02_JPRB,0.12989E-02_JPRB,0.14121E-02_JPRB,0.15049E-02_JPRB, &
 & 0.15986E-02_JPRB,0.16736E-02_JPRB,0.16742E-02_JPRB,0.16864E-02_JPRB /)  
KA(:, 4, 4,12) = (/ &
 & 0.11549E-02_JPRB,0.11640E-02_JPRB,0.12947E-02_JPRB,0.14053E-02_JPRB,0.14971E-02_JPRB, &
 & 0.15940E-02_JPRB,0.16690E-02_JPRB,0.16701E-02_JPRB,0.16826E-02_JPRB /)  
KA(:, 5, 4,12) = (/ &
 & 0.11568E-02_JPRB,0.11629E-02_JPRB,0.12947E-02_JPRB,0.14048E-02_JPRB,0.15017E-02_JPRB, &
 & 0.16054E-02_JPRB,0.16836E-02_JPRB,0.16886E-02_JPRB,0.17044E-02_JPRB /)  
KA(:, 1, 5,12) = (/ &
 & 0.10197E-02_JPRB,0.11002E-02_JPRB,0.12563E-02_JPRB,0.13948E-02_JPRB,0.15048E-02_JPRB, &
 & 0.16026E-02_JPRB,0.16898E-02_JPRB,0.17082E-02_JPRB,0.17013E-02_JPRB /)  
KA(:, 2, 5,12) = (/ &
 & 0.10187E-02_JPRB,0.10963E-02_JPRB,0.12532E-02_JPRB,0.13909E-02_JPRB,0.14993E-02_JPRB, &
 & 0.15953E-02_JPRB,0.16843E-02_JPRB,0.17040E-02_JPRB,0.16991E-02_JPRB /)  
KA(:, 3, 5,12) = (/ &
 & 0.10179E-02_JPRB,0.10925E-02_JPRB,0.12502E-02_JPRB,0.13858E-02_JPRB,0.14932E-02_JPRB, &
 & 0.15900E-02_JPRB,0.16803E-02_JPRB,0.17019E-02_JPRB,0.16952E-02_JPRB /)  
KA(:, 4, 5,12) = (/ &
 & 0.10188E-02_JPRB,0.10896E-02_JPRB,0.12461E-02_JPRB,0.13806E-02_JPRB,0.14878E-02_JPRB, &
 & 0.15873E-02_JPRB,0.16767E-02_JPRB,0.17001E-02_JPRB,0.16925E-02_JPRB /)  
KA(:, 5, 5,12) = (/ &
 & 0.10211E-02_JPRB,0.10901E-02_JPRB,0.12464E-02_JPRB,0.13834E-02_JPRB,0.14970E-02_JPRB, &
 & 0.16026E-02_JPRB,0.16952E-02_JPRB,0.17210E-02_JPRB,0.17180E-02_JPRB /)  
KA(:, 1, 6,12) = (/ &
 & 0.88455E-03_JPRB,0.10185E-02_JPRB,0.12021E-02_JPRB,0.13605E-02_JPRB,0.14894E-02_JPRB, &
 & 0.15922E-02_JPRB,0.16870E-02_JPRB,0.17277E-02_JPRB,0.17006E-02_JPRB /)  
KA(:, 2, 6,12) = (/ &
 & 0.88487E-03_JPRB,0.10158E-02_JPRB,0.12001E-02_JPRB,0.13587E-02_JPRB,0.14854E-02_JPRB, &
 & 0.15856E-02_JPRB,0.16819E-02_JPRB,0.17253E-02_JPRB,0.17001E-02_JPRB /)  
KA(:, 3, 6,12) = (/ &
 & 0.88512E-03_JPRB,0.10136E-02_JPRB,0.11981E-02_JPRB,0.13544E-02_JPRB,0.14820E-02_JPRB, &
 & 0.15811E-02_JPRB,0.16785E-02_JPRB,0.17233E-02_JPRB,0.16989E-02_JPRB /)  
KA(:, 4, 6,12) = (/ &
 & 0.88698E-03_JPRB,0.10127E-02_JPRB,0.11948E-02_JPRB,0.13505E-02_JPRB,0.14784E-02_JPRB, &
 & 0.15789E-02_JPRB,0.16749E-02_JPRB,0.17211E-02_JPRB,0.16988E-02_JPRB /)  
KA(:, 5, 6,12) = (/ &
 & 0.88923E-03_JPRB,0.10128E-02_JPRB,0.11919E-02_JPRB,0.13468E-02_JPRB,0.14756E-02_JPRB, &
 & 0.15764E-02_JPRB,0.16734E-02_JPRB,0.17190E-02_JPRB,0.16990E-02_JPRB /)  
KA(:, 1, 7,12) = (/ &
 & 0.75937E-03_JPRB,0.93876E-03_JPRB,0.11443E-02_JPRB,0.13228E-02_JPRB,0.14681E-02_JPRB, &
 & 0.15807E-02_JPRB,0.16771E-02_JPRB,0.17403E-02_JPRB,0.16920E-02_JPRB /)  
KA(:, 2, 7,12) = (/ &
 & 0.75998E-03_JPRB,0.93770E-03_JPRB,0.11447E-02_JPRB,0.13222E-02_JPRB,0.14656E-02_JPRB, &
 & 0.15751E-02_JPRB,0.16722E-02_JPRB,0.17374E-02_JPRB,0.16943E-02_JPRB /)  
KA(:, 3, 7,12) = (/ &
 & 0.76057E-03_JPRB,0.93698E-03_JPRB,0.11442E-02_JPRB,0.13192E-02_JPRB,0.14630E-02_JPRB, &
 & 0.15711E-02_JPRB,0.16684E-02_JPRB,0.17351E-02_JPRB,0.16966E-02_JPRB /)  
KA(:, 4, 7,12) = (/ &
 & 0.76306E-03_JPRB,0.93700E-03_JPRB,0.11417E-02_JPRB,0.13175E-02_JPRB,0.14605E-02_JPRB, &
 & 0.15679E-02_JPRB,0.16649E-02_JPRB,0.17327E-02_JPRB,0.16998E-02_JPRB /)  
KA(:, 5, 7,12) = (/ &
 & 0.76563E-03_JPRB,0.93740E-03_JPRB,0.11401E-02_JPRB,0.13155E-02_JPRB,0.14583E-02_JPRB, &
 & 0.15655E-02_JPRB,0.16637E-02_JPRB,0.17306E-02_JPRB,0.17045E-02_JPRB /)  
KA(:, 1, 8,12) = (/ &
 & 0.64586E-03_JPRB,0.86421E-03_JPRB,0.10884E-02_JPRB,0.12806E-02_JPRB,0.14383E-02_JPRB, &
 & 0.15636E-02_JPRB,0.16605E-02_JPRB,0.17434E-02_JPRB,0.16711E-02_JPRB /)  
KA(:, 2, 8,12) = (/ &
 & 0.64665E-03_JPRB,0.86473E-03_JPRB,0.10896E-02_JPRB,0.12820E-02_JPRB,0.14363E-02_JPRB, &
 & 0.15592E-02_JPRB,0.16561E-02_JPRB,0.17403E-02_JPRB,0.16771E-02_JPRB /)  
KA(:, 3, 8,12) = (/ &
 & 0.64816E-03_JPRB,0.86506E-03_JPRB,0.10903E-02_JPRB,0.12802E-02_JPRB,0.14357E-02_JPRB, &
 & 0.15554E-02_JPRB,0.16529E-02_JPRB,0.17367E-02_JPRB,0.16846E-02_JPRB /)  
KA(:, 4, 8,12) = (/ &
 & 0.65115E-03_JPRB,0.86561E-03_JPRB,0.10893E-02_JPRB,0.12797E-02_JPRB,0.14336E-02_JPRB, &
 & 0.15533E-02_JPRB,0.16505E-02_JPRB,0.17349E-02_JPRB,0.16920E-02_JPRB /)  
KA(:, 5, 8,12) = (/ &
 & 0.65335E-03_JPRB,0.86692E-03_JPRB,0.10897E-02_JPRB,0.12788E-02_JPRB,0.14323E-02_JPRB, &
 & 0.15519E-02_JPRB,0.16494E-02_JPRB,0.17328E-02_JPRB,0.17005E-02_JPRB /)  
KA(:, 1, 9,12) = (/ &
 & 0.54495E-03_JPRB,0.79374E-03_JPRB,0.10331E-02_JPRB,0.12325E-02_JPRB,0.13999E-02_JPRB, &
 & 0.15343E-02_JPRB,0.16359E-02_JPRB,0.17304E-02_JPRB,0.88289E-03_JPRB /)  
KA(:, 2, 9,12) = (/ &
 & 0.54631E-03_JPRB,0.79621E-03_JPRB,0.10351E-02_JPRB,0.12356E-02_JPRB,0.13999E-02_JPRB, &
 & 0.15332E-02_JPRB,0.16343E-02_JPRB,0.17287E-02_JPRB,0.90009E-03_JPRB /)  
KA(:, 3, 9,12) = (/ &
 & 0.54838E-03_JPRB,0.79738E-03_JPRB,0.10366E-02_JPRB,0.12358E-02_JPRB,0.14008E-02_JPRB, &
 & 0.15312E-02_JPRB,0.16325E-02_JPRB,0.17267E-02_JPRB,0.91715E-03_JPRB /)  
KA(:, 4, 9,12) = (/ &
 & 0.55103E-03_JPRB,0.79925E-03_JPRB,0.10373E-02_JPRB,0.12370E-02_JPRB,0.14003E-02_JPRB, &
 & 0.15313E-02_JPRB,0.16317E-02_JPRB,0.17265E-02_JPRB,0.93948E-03_JPRB /)  
KA(:, 5, 9,12) = (/ &
 & 0.55358E-03_JPRB,0.80158E-03_JPRB,0.10391E-02_JPRB,0.12370E-02_JPRB,0.14008E-02_JPRB, &
 & 0.15320E-02_JPRB,0.16328E-02_JPRB,0.17271E-02_JPRB,0.97099E-03_JPRB /)  
KA(:, 1,10,12) = (/ &
 & 0.45828E-03_JPRB,0.73128E-03_JPRB,0.97725E-03_JPRB,0.11801E-02_JPRB,0.13541E-02_JPRB, &
 & 0.14966E-02_JPRB,0.16059E-02_JPRB,0.17081E-02_JPRB,0.25261E-04_JPRB /)  
KA(:, 2,10,12) = (/ &
 & 0.45994E-03_JPRB,0.73433E-03_JPRB,0.98047E-03_JPRB,0.11852E-02_JPRB,0.13571E-02_JPRB, &
 & 0.14993E-02_JPRB,0.16071E-02_JPRB,0.17093E-02_JPRB,0.32778E-04_JPRB /)  
KA(:, 3,10,12) = (/ &
 & 0.46172E-03_JPRB,0.73698E-03_JPRB,0.98332E-03_JPRB,0.11877E-02_JPRB,0.13607E-02_JPRB, &
 & 0.15001E-02_JPRB,0.16089E-02_JPRB,0.17098E-02_JPRB,0.30108E-04_JPRB /)  
KA(:, 4,10,12) = (/ &
 & 0.46419E-03_JPRB,0.73967E-03_JPRB,0.98568E-03_JPRB,0.11903E-02_JPRB,0.13620E-02_JPRB, &
 & 0.15042E-02_JPRB,0.16117E-02_JPRB,0.17131E-02_JPRB,0.14814E-04_JPRB /)  
KA(:, 5,10,12) = (/ &
 & 0.46710E-03_JPRB,0.74287E-03_JPRB,0.98852E-03_JPRB,0.11927E-02_JPRB,0.13653E-02_JPRB, &
 & 0.15080E-02_JPRB,0.16153E-02_JPRB,0.17174E-02_JPRB,0.18206E-04_JPRB /)  
KA(:, 1,11,12) = (/ &
 & 0.38711E-03_JPRB,0.67660E-03_JPRB,0.92352E-03_JPRB,0.11285E-02_JPRB,0.13042E-02_JPRB, &
 & 0.14533E-02_JPRB,0.15680E-02_JPRB,0.16768E-02_JPRB,0.35375E-04_JPRB /)  
KA(:, 2,11,12) = (/ &
 & 0.38827E-03_JPRB,0.68076E-03_JPRB,0.92811E-03_JPRB,0.11355E-02_JPRB,0.13110E-02_JPRB, &
 & 0.14578E-02_JPRB,0.15732E-02_JPRB,0.16802E-02_JPRB,0.17785E-04_JPRB /)  
KA(:, 3,11,12) = (/ &
 & 0.39017E-03_JPRB,0.68339E-03_JPRB,0.93243E-03_JPRB,0.11404E-02_JPRB,0.13179E-02_JPRB, &
 & 0.14648E-02_JPRB,0.15809E-02_JPRB,0.16870E-02_JPRB,0.17310E-04_JPRB /)  
KA(:, 4,11,12) = (/ &
 & 0.39259E-03_JPRB,0.68706E-03_JPRB,0.93609E-03_JPRB,0.11451E-02_JPRB,0.13243E-02_JPRB, &
 & 0.14746E-02_JPRB,0.15892E-02_JPRB,0.16958E-02_JPRB,0.17795E-04_JPRB /)  
KA(:, 5,11,12) = (/ &
 & 0.39544E-03_JPRB,0.69011E-03_JPRB,0.94016E-03_JPRB,0.11496E-02_JPRB,0.13318E-02_JPRB, &
 & 0.14825E-02_JPRB,0.15980E-02_JPRB,0.17052E-02_JPRB,0.87581E-05_JPRB /)  
KA(:, 1,12,12) = (/ &
 & 0.32882E-03_JPRB,0.62658E-03_JPRB,0.87124E-03_JPRB,0.10770E-02_JPRB,0.12526E-02_JPRB, &
 & 0.14042E-02_JPRB,0.15246E-02_JPRB,0.16367E-02_JPRB,0.13823E-04_JPRB /)  
KA(:, 2,12,12) = (/ &
 & 0.33008E-03_JPRB,0.63068E-03_JPRB,0.87790E-03_JPRB,0.10857E-02_JPRB,0.12638E-02_JPRB, &
 & 0.14155E-02_JPRB,0.15376E-02_JPRB,0.16473E-02_JPRB,0.27356E-04_JPRB /)  
KA(:, 3,12,12) = (/ &
 & 0.33191E-03_JPRB,0.63479E-03_JPRB,0.88401E-03_JPRB,0.10939E-02_JPRB,0.12749E-02_JPRB, &
 & 0.14298E-02_JPRB,0.15521E-02_JPRB,0.16615E-02_JPRB,0.26924E-04_JPRB /)  
KA(:, 4,12,12) = (/ &
 & 0.33384E-03_JPRB,0.63914E-03_JPRB,0.88945E-03_JPRB,0.11023E-02_JPRB,0.12871E-02_JPRB, &
 & 0.14439E-02_JPRB,0.15651E-02_JPRB,0.16755E-02_JPRB,0.13486E-04_JPRB /)  
KA(:, 5,12,12) = (/ &
 & 0.33630E-03_JPRB,0.64288E-03_JPRB,0.89554E-03_JPRB,0.11106E-02_JPRB,0.12985E-02_JPRB, &
 & 0.14567E-02_JPRB,0.15792E-02_JPRB,0.16910E-02_JPRB,0.54470E-04_JPRB /)  
KA(:, 1,13,12) = (/ &
 & 0.28179E-03_JPRB,0.58039E-03_JPRB,0.82131E-03_JPRB,0.10258E-02_JPRB,0.12001E-02_JPRB, &
 & 0.13522E-02_JPRB,0.14762E-02_JPRB,0.15892E-02_JPRB,0.17365E-04_JPRB /)  
KA(:, 2,13,12) = (/ &
 & 0.28322E-03_JPRB,0.58517E-03_JPRB,0.83048E-03_JPRB,0.10376E-02_JPRB,0.12180E-02_JPRB, &
 & 0.13721E-02_JPRB,0.14980E-02_JPRB,0.16092E-02_JPRB,0.19167E-10_JPRB /)  
KA(:, 3,13,12) = (/ &
 & 0.28449E-03_JPRB,0.59004E-03_JPRB,0.83867E-03_JPRB,0.10495E-02_JPRB,0.12349E-02_JPRB, &
 & 0.13937E-02_JPRB,0.15189E-02_JPRB,0.16302E-02_JPRB,0.17686E-04_JPRB /)  
KA(:, 4,13,12) = (/ &
 & 0.28623E-03_JPRB,0.59506E-03_JPRB,0.84661E-03_JPRB,0.10616E-02_JPRB,0.12511E-02_JPRB, &
 & 0.14124E-02_JPRB,0.15380E-02_JPRB,0.16505E-02_JPRB,0.27174E-10_JPRB /)  
KA(:, 5,13,12) = (/ &
 & 0.28834E-03_JPRB,0.60000E-03_JPRB,0.85510E-03_JPRB,0.10735E-02_JPRB,0.12664E-02_JPRB, &
 & 0.14298E-02_JPRB,0.15583E-02_JPRB,0.16724E-02_JPRB,0.30930E-10_JPRB /)  
KA(:, 1, 1,13) = (/ &
 & 0.39229E-02_JPRB,0.34326E-02_JPRB,0.30162E-02_JPRB,0.28699E-02_JPRB,0.28381E-02_JPRB, &
 & 0.27734E-02_JPRB,0.26260E-02_JPRB,0.23062E-02_JPRB,0.25522E-02_JPRB /)  
KA(:, 2, 1,13) = (/ &
 & 0.39213E-02_JPRB,0.34310E-02_JPRB,0.30108E-02_JPRB,0.28565E-02_JPRB,0.28216E-02_JPRB, &
 & 0.27552E-02_JPRB,0.26075E-02_JPRB,0.22956E-02_JPRB,0.25296E-02_JPRB /)  
KA(:, 3, 1,13) = (/ &
 & 0.39180E-02_JPRB,0.34283E-02_JPRB,0.30095E-02_JPRB,0.28490E-02_JPRB,0.28140E-02_JPRB, &
 & 0.27516E-02_JPRB,0.26057E-02_JPRB,0.23031E-02_JPRB,0.25320E-02_JPRB /)  
KA(:, 4, 1,13) = (/ &
 & 0.39161E-02_JPRB,0.34265E-02_JPRB,0.30039E-02_JPRB,0.28320E-02_JPRB,0.27864E-02_JPRB, &
 & 0.27263E-02_JPRB,0.25779E-02_JPRB,0.22767E-02_JPRB,0.24834E-02_JPRB /)  
KA(:, 5, 1,13) = (/ &
 & 0.39129E-02_JPRB,0.34239E-02_JPRB,0.29985E-02_JPRB,0.28202E-02_JPRB,0.27725E-02_JPRB, &
 & 0.27107E-02_JPRB,0.25647E-02_JPRB,0.22654E-02_JPRB,0.24632E-02_JPRB /)  
KA(:, 1, 2,13) = (/ &
 & 0.35717E-02_JPRB,0.31250E-02_JPRB,0.28583E-02_JPRB,0.28716E-02_JPRB,0.28885E-02_JPRB, &
 & 0.28569E-02_JPRB,0.27419E-02_JPRB,0.24528E-02_JPRB,0.26589E-02_JPRB /)  
KA(:, 2, 2,13) = (/ &
 & 0.35704E-02_JPRB,0.31241E-02_JPRB,0.28509E-02_JPRB,0.28521E-02_JPRB,0.28717E-02_JPRB, &
 & 0.28411E-02_JPRB,0.27277E-02_JPRB,0.24440E-02_JPRB,0.26352E-02_JPRB /)  
KA(:, 3, 2,13) = (/ &
 & 0.35692E-02_JPRB,0.31228E-02_JPRB,0.28479E-02_JPRB,0.28438E-02_JPRB,0.28636E-02_JPRB, &
 & 0.28419E-02_JPRB,0.27327E-02_JPRB,0.24542E-02_JPRB,0.26382E-02_JPRB /)  
KA(:, 4, 2,13) = (/ &
 & 0.35651E-02_JPRB,0.31194E-02_JPRB,0.28382E-02_JPRB,0.28288E-02_JPRB,0.28472E-02_JPRB, &
 & 0.28288E-02_JPRB,0.27211E-02_JPRB,0.24428E-02_JPRB,0.26140E-02_JPRB /)  
KA(:, 5, 2,13) = (/ &
 & 0.35614E-02_JPRB,0.31162E-02_JPRB,0.28280E-02_JPRB,0.28080E-02_JPRB,0.28270E-02_JPRB, &
 & 0.28018E-02_JPRB,0.26919E-02_JPRB,0.24122E-02_JPRB,0.25721E-02_JPRB /)  
KA(:, 1, 3,13) = (/ &
 & 0.32370E-02_JPRB,0.28408E-02_JPRB,0.27429E-02_JPRB,0.28459E-02_JPRB,0.29107E-02_JPRB, &
 & 0.29163E-02_JPRB,0.28452E-02_JPRB,0.26013E-02_JPRB,0.27589E-02_JPRB /)  
KA(:, 2, 3,13) = (/ &
 & 0.32378E-02_JPRB,0.28409E-02_JPRB,0.27346E-02_JPRB,0.28282E-02_JPRB,0.28967E-02_JPRB, &
 & 0.29036E-02_JPRB,0.28357E-02_JPRB,0.25912E-02_JPRB,0.27381E-02_JPRB /)  
KA(:, 3, 3,13) = (/ &
 & 0.32344E-02_JPRB,0.28366E-02_JPRB,0.27224E-02_JPRB,0.28159E-02_JPRB,0.28824E-02_JPRB, &
 & 0.28940E-02_JPRB,0.28268E-02_JPRB,0.25801E-02_JPRB,0.27164E-02_JPRB /)  
KA(:, 4, 3,13) = (/ &
 & 0.32328E-02_JPRB,0.28349E-02_JPRB,0.27139E-02_JPRB,0.28071E-02_JPRB,0.28820E-02_JPRB, &
 & 0.28985E-02_JPRB,0.28328E-02_JPRB,0.25870E-02_JPRB,0.27280E-02_JPRB /)  
KA(:, 5, 3,13) = (/ &
 & 0.32337E-02_JPRB,0.28348E-02_JPRB,0.27027E-02_JPRB,0.27877E-02_JPRB,0.28613E-02_JPRB, &
 & 0.28723E-02_JPRB,0.28004E-02_JPRB,0.25498E-02_JPRB,0.26848E-02_JPRB /)  
KA(:, 1, 4,13) = (/ &
 & 0.29442E-02_JPRB,0.26158E-02_JPRB,0.26686E-02_JPRB,0.28002E-02_JPRB,0.29074E-02_JPRB, &
 & 0.29569E-02_JPRB,0.29354E-02_JPRB,0.27381E-02_JPRB,0.28491E-02_JPRB /)  
KA(:, 2, 4,13) = (/ &
 & 0.29416E-02_JPRB,0.26110E-02_JPRB,0.26570E-02_JPRB,0.27866E-02_JPRB,0.28959E-02_JPRB, &
 & 0.29477E-02_JPRB,0.29295E-02_JPRB,0.27262E-02_JPRB,0.28287E-02_JPRB /)  
KA(:, 3, 4,13) = (/ &
 & 0.29392E-02_JPRB,0.26064E-02_JPRB,0.26421E-02_JPRB,0.27765E-02_JPRB,0.28845E-02_JPRB, &
 & 0.29406E-02_JPRB,0.29202E-02_JPRB,0.27107E-02_JPRB,0.28099E-02_JPRB /)  
KA(:, 4, 4,13) = (/ &
 & 0.29406E-02_JPRB,0.26055E-02_JPRB,0.26309E-02_JPRB,0.27645E-02_JPRB,0.28769E-02_JPRB, &
 & 0.29312E-02_JPRB,0.29057E-02_JPRB,0.26928E-02_JPRB,0.27972E-02_JPRB /)  
KA(:, 5, 4,13) = (/ &
 & 0.29379E-02_JPRB,0.26016E-02_JPRB,0.26230E-02_JPRB,0.27605E-02_JPRB,0.28772E-02_JPRB, &
 & 0.29338E-02_JPRB,0.29114E-02_JPRB,0.26956E-02_JPRB,0.28225E-02_JPRB /)  
KA(:, 1, 5,13) = (/ &
 & 0.26861E-02_JPRB,0.24510E-02_JPRB,0.26014E-02_JPRB,0.27478E-02_JPRB,0.28811E-02_JPRB, &
 & 0.29878E-02_JPRB,0.30091E-02_JPRB,0.28610E-02_JPRB,0.29320E-02_JPRB /)  
KA(:, 2, 5,13) = (/ &
 & 0.26822E-02_JPRB,0.24426E-02_JPRB,0.25898E-02_JPRB,0.27369E-02_JPRB,0.28725E-02_JPRB, &
 & 0.29815E-02_JPRB,0.30039E-02_JPRB,0.28485E-02_JPRB,0.29157E-02_JPRB /)  
KA(:, 3, 5,13) = (/ &
 & 0.26829E-02_JPRB,0.24377E-02_JPRB,0.25766E-02_JPRB,0.27289E-02_JPRB,0.28648E-02_JPRB, &
 & 0.29741E-02_JPRB,0.29940E-02_JPRB,0.28292E-02_JPRB,0.29014E-02_JPRB /)  
KA(:, 4, 5,13) = (/ &
 & 0.26816E-02_JPRB,0.24329E-02_JPRB,0.25674E-02_JPRB,0.27192E-02_JPRB,0.28602E-02_JPRB, &
 & 0.29643E-02_JPRB,0.29808E-02_JPRB,0.28105E-02_JPRB,0.28911E-02_JPRB /)  
KA(:, 5, 5,13) = (/ &
 & 0.26776E-02_JPRB,0.24242E-02_JPRB,0.25584E-02_JPRB,0.27174E-02_JPRB,0.28631E-02_JPRB, &
 & 0.29690E-02_JPRB,0.29916E-02_JPRB,0.28176E-02_JPRB,0.29253E-02_JPRB /)  
KA(:, 1, 6,13) = (/ &
 & 0.24590E-02_JPRB,0.23376E-02_JPRB,0.25355E-02_JPRB,0.26945E-02_JPRB,0.28553E-02_JPRB, &
 & 0.29996E-02_JPRB,0.30574E-02_JPRB,0.29544E-02_JPRB,0.30033E-02_JPRB /)  
KA(:, 2, 6,13) = (/ &
 & 0.24565E-02_JPRB,0.23281E-02_JPRB,0.25242E-02_JPRB,0.26862E-02_JPRB,0.28495E-02_JPRB, &
 & 0.29966E-02_JPRB,0.30559E-02_JPRB,0.29459E-02_JPRB,0.29901E-02_JPRB /)  
KA(:, 3, 6,13) = (/ &
 & 0.24594E-02_JPRB,0.23224E-02_JPRB,0.25135E-02_JPRB,0.26796E-02_JPRB,0.28441E-02_JPRB, &
 & 0.29914E-02_JPRB,0.30494E-02_JPRB,0.29315E-02_JPRB,0.29796E-02_JPRB /)  
KA(:, 4, 6,13) = (/ &
 & 0.24561E-02_JPRB,0.23120E-02_JPRB,0.25070E-02_JPRB,0.26723E-02_JPRB,0.28398E-02_JPRB, &
 & 0.29830E-02_JPRB,0.30431E-02_JPRB,0.29165E-02_JPRB,0.29718E-02_JPRB /)  
KA(:, 5, 6,13) = (/ &
 & 0.24544E-02_JPRB,0.23009E-02_JPRB,0.24971E-02_JPRB,0.26678E-02_JPRB,0.28335E-02_JPRB, &
 & 0.29758E-02_JPRB,0.30342E-02_JPRB,0.29019E-02_JPRB,0.29654E-02_JPRB /)  
KA(:, 1, 7,13) = (/ &
 & 0.22277E-02_JPRB,0.22296E-02_JPRB,0.24669E-02_JPRB,0.26497E-02_JPRB,0.28285E-02_JPRB, &
 & 0.29885E-02_JPRB,0.30855E-02_JPRB,0.30292E-02_JPRB,0.30616E-02_JPRB /)  
KA(:, 2, 7,13) = (/ &
 & 0.22293E-02_JPRB,0.22219E-02_JPRB,0.24569E-02_JPRB,0.26437E-02_JPRB,0.28247E-02_JPRB, &
 & 0.29924E-02_JPRB,0.30879E-02_JPRB,0.30266E-02_JPRB,0.30510E-02_JPRB /)  
KA(:, 3, 7,13) = (/ &
 & 0.22351E-02_JPRB,0.22176E-02_JPRB,0.24495E-02_JPRB,0.26382E-02_JPRB,0.28222E-02_JPRB, &
 & 0.29913E-02_JPRB,0.30877E-02_JPRB,0.30175E-02_JPRB,0.30415E-02_JPRB /)  
KA(:, 4, 7,13) = (/ &
 & 0.22344E-02_JPRB,0.22079E-02_JPRB,0.24453E-02_JPRB,0.26324E-02_JPRB,0.28192E-02_JPRB, &
 & 0.29887E-02_JPRB,0.30862E-02_JPRB,0.30074E-02_JPRB,0.30342E-02_JPRB /)  
KA(:, 5, 7,13) = (/ &
 & 0.22361E-02_JPRB,0.21982E-02_JPRB,0.24378E-02_JPRB,0.26291E-02_JPRB,0.28143E-02_JPRB, &
 & 0.29850E-02_JPRB,0.30822E-02_JPRB,0.29969E-02_JPRB,0.30270E-02_JPRB /)  
KA(:, 1, 8,13) = (/ &
 & 0.19878E-02_JPRB,0.21080E-02_JPRB,0.23886E-02_JPRB,0.26087E-02_JPRB,0.27952E-02_JPRB, &
 & 0.29676E-02_JPRB,0.31003E-02_JPRB,0.30904E-02_JPRB,0.31018E-02_JPRB /)  
KA(:, 2, 8,13) = (/ &
 & 0.19936E-02_JPRB,0.21034E-02_JPRB,0.23825E-02_JPRB,0.26049E-02_JPRB,0.27978E-02_JPRB, &
 & 0.29755E-02_JPRB,0.31107E-02_JPRB,0.30954E-02_JPRB,0.30940E-02_JPRB /)  
KA(:, 3, 8,13) = (/ &
 & 0.20012E-02_JPRB,0.21016E-02_JPRB,0.23778E-02_JPRB,0.26010E-02_JPRB,0.27982E-02_JPRB, &
 & 0.29815E-02_JPRB,0.31166E-02_JPRB,0.30929E-02_JPRB,0.30865E-02_JPRB /)  
KA(:, 4, 8,13) = (/ &
 & 0.20034E-02_JPRB,0.20960E-02_JPRB,0.23764E-02_JPRB,0.25979E-02_JPRB,0.27992E-02_JPRB, &
 & 0.29823E-02_JPRB,0.31192E-02_JPRB,0.30868E-02_JPRB,0.30812E-02_JPRB /)  
KA(:, 5, 8,13) = (/ &
 & 0.20095E-02_JPRB,0.20891E-02_JPRB,0.23711E-02_JPRB,0.25960E-02_JPRB,0.27964E-02_JPRB, &
 & 0.29828E-02_JPRB,0.31181E-02_JPRB,0.30806E-02_JPRB,0.30733E-02_JPRB /)  
KA(:, 1, 9,13) = (/ &
 & 0.17523E-02_JPRB,0.19789E-02_JPRB,0.23024E-02_JPRB,0.25572E-02_JPRB,0.27629E-02_JPRB, &
 & 0.29479E-02_JPRB,0.31085E-02_JPRB,0.31444E-02_JPRB,0.30417E-02_JPRB /)  
KA(:, 2, 9,13) = (/ &
 & 0.17607E-02_JPRB,0.19777E-02_JPRB,0.23013E-02_JPRB,0.25587E-02_JPRB,0.27691E-02_JPRB, &
 & 0.29613E-02_JPRB,0.31227E-02_JPRB,0.31535E-02_JPRB,0.30346E-02_JPRB /)  
KA(:, 3, 9,13) = (/ &
 & 0.17693E-02_JPRB,0.19800E-02_JPRB,0.23011E-02_JPRB,0.25605E-02_JPRB,0.27739E-02_JPRB, &
 & 0.29714E-02_JPRB,0.31329E-02_JPRB,0.31549E-02_JPRB,0.30299E-02_JPRB /)  
KA(:, 4, 9,13) = (/ &
 & 0.17751E-02_JPRB,0.19773E-02_JPRB,0.23025E-02_JPRB,0.25606E-02_JPRB,0.27770E-02_JPRB, &
 & 0.29770E-02_JPRB,0.31405E-02_JPRB,0.31532E-02_JPRB,0.30280E-02_JPRB /)  
KA(:, 5, 9,13) = (/ &
 & 0.17845E-02_JPRB,0.19738E-02_JPRB,0.23006E-02_JPRB,0.25633E-02_JPRB,0.27766E-02_JPRB, &
 & 0.29802E-02_JPRB,0.31452E-02_JPRB,0.31517E-02_JPRB,0.30317E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART9',1,ZHOOK_HANDLE)
END SUBROUTINE PART9


SUBROUTINE PART10

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART10',0,ZHOOK_HANDLE)


KA(:, 1,10,13) = (/ &
 & 0.15244E-02_JPRB,0.18437E-02_JPRB,0.22100E-02_JPRB,0.24972E-02_JPRB,0.27331E-02_JPRB, &
 & 0.29304E-02_JPRB,0.31059E-02_JPRB,0.31844E-02_JPRB,0.23817E-04_JPRB /)  
KA(:, 2,10,13) = (/ &
 & 0.15360E-02_JPRB,0.18467E-02_JPRB,0.22145E-02_JPRB,0.25068E-02_JPRB,0.27437E-02_JPRB, &
 & 0.29473E-02_JPRB,0.31260E-02_JPRB,0.31986E-02_JPRB,0.12454E-04_JPRB /)  
KA(:, 3,10,13) = (/ &
 & 0.15476E-02_JPRB,0.18512E-02_JPRB,0.22181E-02_JPRB,0.25119E-02_JPRB,0.27538E-02_JPRB, &
 & 0.29593E-02_JPRB,0.31389E-02_JPRB,0.32042E-02_JPRB,0.30814E-04_JPRB /)  
KA(:, 4,10,13) = (/ &
 & 0.15571E-02_JPRB,0.18528E-02_JPRB,0.22235E-02_JPRB,0.25174E-02_JPRB,0.27591E-02_JPRB, &
 & 0.29666E-02_JPRB,0.31497E-02_JPRB,0.32063E-02_JPRB,0.11698E-04_JPRB /)  
KA(:, 5,10,13) = (/ &
 & 0.15695E-02_JPRB,0.18534E-02_JPRB,0.22262E-02_JPRB,0.25236E-02_JPRB,0.27611E-02_JPRB, &
 & 0.29733E-02_JPRB,0.31600E-02_JPRB,0.32093E-02_JPRB,0.22330E-04_JPRB /)  
KA(:, 1,11,13) = (/ &
 & 0.13188E-02_JPRB,0.17123E-02_JPRB,0.21150E-02_JPRB,0.24398E-02_JPRB,0.27060E-02_JPRB, &
 & 0.29190E-02_JPRB,0.31061E-02_JPRB,0.32197E-02_JPRB,0.11689E-04_JPRB /)  
KA(:, 2,11,13) = (/ &
 & 0.13341E-02_JPRB,0.17189E-02_JPRB,0.21240E-02_JPRB,0.24532E-02_JPRB,0.27222E-02_JPRB, &
 & 0.29371E-02_JPRB,0.31262E-02_JPRB,0.32338E-02_JPRB,0.11845E-04_JPRB /)  
KA(:, 3,11,13) = (/ &
 & 0.13447E-02_JPRB,0.17274E-02_JPRB,0.21339E-02_JPRB,0.24651E-02_JPRB,0.27343E-02_JPRB, &
 & 0.29498E-02_JPRB,0.31430E-02_JPRB,0.32440E-02_JPRB,0.24255E-04_JPRB /)  
KA(:, 4,11,13) = (/ &
 & 0.13578E-02_JPRB,0.17324E-02_JPRB,0.21454E-02_JPRB,0.24765E-02_JPRB,0.27400E-02_JPRB, &
 & 0.29585E-02_JPRB,0.31579E-02_JPRB,0.32502E-02_JPRB,0.35648E-04_JPRB /)  
KA(:, 5,11,13) = (/ &
 & 0.13715E-02_JPRB,0.17394E-02_JPRB,0.21518E-02_JPRB,0.24842E-02_JPRB,0.27436E-02_JPRB, &
 & 0.29689E-02_JPRB,0.31719E-02_JPRB,0.32570E-02_JPRB,0.48216E-04_JPRB /)  
KA(:, 1,12,13) = (/ &
 & 0.11367E-02_JPRB,0.15942E-02_JPRB,0.20255E-02_JPRB,0.23827E-02_JPRB,0.26757E-02_JPRB, &
 & 0.29001E-02_JPRB,0.30944E-02_JPRB,0.32386E-02_JPRB,0.48616E-12_JPRB /)  
KA(:, 2,12,13) = (/ &
 & 0.11495E-02_JPRB,0.16057E-02_JPRB,0.20405E-02_JPRB,0.24019E-02_JPRB,0.26965E-02_JPRB, &
 & 0.29177E-02_JPRB,0.31160E-02_JPRB,0.32553E-02_JPRB,0.63803E-12_JPRB /)  
KA(:, 3,12,13) = (/ &
 & 0.11626E-02_JPRB,0.16147E-02_JPRB,0.20558E-02_JPRB,0.24193E-02_JPRB,0.27102E-02_JPRB, &
 & 0.29330E-02_JPRB,0.31363E-02_JPRB,0.32673E-02_JPRB,0.18451E-04_JPRB /)  
KA(:, 4,12,13) = (/ &
 & 0.11784E-02_JPRB,0.16224E-02_JPRB,0.20681E-02_JPRB,0.24334E-02_JPRB,0.27187E-02_JPRB, &
 & 0.29473E-02_JPRB,0.31560E-02_JPRB,0.32789E-02_JPRB,0.93725E-12_JPRB /)  
KA(:, 5,12,13) = (/ &
 & 0.11935E-02_JPRB,0.16327E-02_JPRB,0.20790E-02_JPRB,0.24438E-02_JPRB,0.27275E-02_JPRB, &
 & 0.29614E-02_JPRB,0.31756E-02_JPRB,0.32901E-02_JPRB,0.36773E-04_JPRB /)  
KA(:, 1,13,13) = (/ &
 & 0.97386E-03_JPRB,0.14865E-02_JPRB,0.19422E-02_JPRB,0.23265E-02_JPRB,0.26377E-02_JPRB, &
 & 0.28742E-02_JPRB,0.30758E-02_JPRB,0.32440E-02_JPRB,0.42838E-12_JPRB /)  
KA(:, 2,13,13) = (/ &
 & 0.98704E-03_JPRB,0.15018E-02_JPRB,0.19617E-02_JPRB,0.23518E-02_JPRB,0.26608E-02_JPRB, &
 & 0.28955E-02_JPRB,0.31025E-02_JPRB,0.32660E-02_JPRB,0.54956E-12_JPRB /)  
KA(:, 3,13,13) = (/ &
 & 0.10034E-02_JPRB,0.15127E-02_JPRB,0.19822E-02_JPRB,0.23722E-02_JPRB,0.26791E-02_JPRB, &
 & 0.29131E-02_JPRB,0.31272E-02_JPRB,0.32827E-02_JPRB,0.68281E-12_JPRB /)  
KA(:, 4,13,13) = (/ &
 & 0.10185E-02_JPRB,0.15248E-02_JPRB,0.19990E-02_JPRB,0.23896E-02_JPRB,0.26942E-02_JPRB, &
 & 0.29331E-02_JPRB,0.31525E-02_JPRB,0.33003E-02_JPRB,0.47348E-04_JPRB /)  
KA(:, 5,13,13) = (/ &
 & 0.10353E-02_JPRB,0.15370E-02_JPRB,0.20122E-02_JPRB,0.24032E-02_JPRB,0.27096E-02_JPRB, &
 & 0.29526E-02_JPRB,0.31774E-02_JPRB,0.33154E-02_JPRB,0.94094E-12_JPRB /)  
KA(:, 1, 1,14) = (/ &
 & 0.11127E-01_JPRB,0.97365E-02_JPRB,0.83450E-02_JPRB,0.69546E-02_JPRB,0.57518E-02_JPRB, &
 & 0.48972E-02_JPRB,0.42517E-02_JPRB,0.34771E-02_JPRB,0.44616E-02_JPRB /)  
KA(:, 2, 1,14) = (/ &
 & 0.11168E-01_JPRB,0.97719E-02_JPRB,0.83762E-02_JPRB,0.69801E-02_JPRB,0.57613E-02_JPRB, &
 & 0.48914E-02_JPRB,0.42324E-02_JPRB,0.34356E-02_JPRB,0.44183E-02_JPRB /)  
KA(:, 3, 1,14) = (/ &
 & 0.11206E-01_JPRB,0.98061E-02_JPRB,0.84051E-02_JPRB,0.70040E-02_JPRB,0.57786E-02_JPRB, &
 & 0.48973E-02_JPRB,0.42300E-02_JPRB,0.34167E-02_JPRB,0.44088E-02_JPRB /)  
KA(:, 4, 1,14) = (/ &
 & 0.11230E-01_JPRB,0.98265E-02_JPRB,0.84228E-02_JPRB,0.70190E-02_JPRB,0.57794E-02_JPRB, &
 & 0.48702E-02_JPRB,0.41927E-02_JPRB,0.33658E-02_JPRB,0.43365E-02_JPRB /)  
KA(:, 5, 1,14) = (/ &
 & 0.11247E-01_JPRB,0.98411E-02_JPRB,0.84348E-02_JPRB,0.70292E-02_JPRB,0.57800E-02_JPRB, &
 & 0.48600E-02_JPRB,0.41735E-02_JPRB,0.33367E-02_JPRB,0.43003E-02_JPRB /)  
KA(:, 1, 2,14) = (/ &
 & 0.11360E-01_JPRB,0.99403E-02_JPRB,0.85204E-02_JPRB,0.71449E-02_JPRB,0.60754E-02_JPRB, &
 & 0.53678E-02_JPRB,0.47333E-02_JPRB,0.38804E-02_JPRB,0.48459E-02_JPRB /)  
KA(:, 2, 2,14) = (/ &
 & 0.11402E-01_JPRB,0.99768E-02_JPRB,0.85517E-02_JPRB,0.71687E-02_JPRB,0.60816E-02_JPRB, &
 & 0.53522E-02_JPRB,0.47062E-02_JPRB,0.38343E-02_JPRB,0.48034E-02_JPRB /)  
KA(:, 3, 2,14) = (/ &
 & 0.11432E-01_JPRB,0.10003E-01_JPRB,0.85744E-02_JPRB,0.71872E-02_JPRB,0.60934E-02_JPRB, &
 & 0.53498E-02_JPRB,0.46968E-02_JPRB,0.38177E-02_JPRB,0.48004E-02_JPRB /)  
KA(:, 4, 2,14) = (/ &
 & 0.11460E-01_JPRB,0.10028E-01_JPRB,0.85956E-02_JPRB,0.72000E-02_JPRB,0.60909E-02_JPRB, &
 & 0.53282E-02_JPRB,0.46686E-02_JPRB,0.37852E-02_JPRB,0.47598E-02_JPRB /)  
KA(:, 5, 2,14) = (/ &
 & 0.11484E-01_JPRB,0.10049E-01_JPRB,0.86132E-02_JPRB,0.72108E-02_JPRB,0.60794E-02_JPRB, &
 & 0.52951E-02_JPRB,0.46284E-02_JPRB,0.37347E-02_JPRB,0.46895E-02_JPRB /)  
KA(:, 1, 3,14) = (/ &
 & 0.11375E-01_JPRB,0.99535E-02_JPRB,0.85318E-02_JPRB,0.72748E-02_JPRB,0.63965E-02_JPRB, &
 & 0.58374E-02_JPRB,0.52215E-02_JPRB,0.43002E-02_JPRB,0.52258E-02_JPRB /)  
KA(:, 2, 3,14) = (/ &
 & 0.11412E-01_JPRB,0.99855E-02_JPRB,0.85592E-02_JPRB,0.72909E-02_JPRB,0.63926E-02_JPRB, &
 & 0.58142E-02_JPRB,0.51838E-02_JPRB,0.42530E-02_JPRB,0.51857E-02_JPRB /)  
KA(:, 3, 3,14) = (/ &
 & 0.11451E-01_JPRB,0.10019E-01_JPRB,0.85873E-02_JPRB,0.73027E-02_JPRB,0.63856E-02_JPRB, &
 & 0.57886E-02_JPRB,0.51485E-02_JPRB,0.42153E-02_JPRB,0.51479E-02_JPRB /)  
KA(:, 4, 3,14) = (/ &
 & 0.11483E-01_JPRB,0.10047E-01_JPRB,0.86122E-02_JPRB,0.73190E-02_JPRB,0.63840E-02_JPRB, &
 & 0.57742E-02_JPRB,0.51342E-02_JPRB,0.42027E-02_JPRB,0.51482E-02_JPRB /)  
KA(:, 5, 3,14) = (/ &
 & 0.11512E-01_JPRB,0.10073E-01_JPRB,0.86339E-02_JPRB,0.73301E-02_JPRB,0.63706E-02_JPRB, &
 & 0.57344E-02_JPRB,0.50899E-02_JPRB,0.41496E-02_JPRB,0.50782E-02_JPRB /)  
KA(:, 1, 4,14) = (/ &
 & 0.11149E-01_JPRB,0.97560E-02_JPRB,0.83906E-02_JPRB,0.73568E-02_JPRB,0.67050E-02_JPRB, &
 & 0.62789E-02_JPRB,0.56809E-02_JPRB,0.47244E-02_JPRB,0.55742E-02_JPRB /)  
KA(:, 2, 4,14) = (/ &
 & 0.11201E-01_JPRB,0.98016E-02_JPRB,0.84237E-02_JPRB,0.73684E-02_JPRB,0.66927E-02_JPRB, &
 & 0.62506E-02_JPRB,0.56398E-02_JPRB,0.46775E-02_JPRB,0.55381E-02_JPRB /)  
KA(:, 3, 4,14) = (/ &
 & 0.11250E-01_JPRB,0.98437E-02_JPRB,0.84576E-02_JPRB,0.73794E-02_JPRB,0.66793E-02_JPRB, &
 & 0.62192E-02_JPRB,0.56018E-02_JPRB,0.46402E-02_JPRB,0.55028E-02_JPRB /)  
KA(:, 4, 4,14) = (/ &
 & 0.11293E-01_JPRB,0.98814E-02_JPRB,0.84883E-02_JPRB,0.73928E-02_JPRB,0.66658E-02_JPRB, &
 & 0.61879E-02_JPRB,0.55699E-02_JPRB,0.46073E-02_JPRB,0.54669E-02_JPRB /)  
KA(:, 5, 4,14) = (/ &
 & 0.11341E-01_JPRB,0.99237E-02_JPRB,0.85206E-02_JPRB,0.74085E-02_JPRB,0.66636E-02_JPRB, &
 & 0.61710E-02_JPRB,0.55548E-02_JPRB,0.45934E-02_JPRB,0.54646E-02_JPRB /)  
KA(:, 1, 5,14) = (/ &
 & 0.10704E-01_JPRB,0.93660E-02_JPRB,0.81568E-02_JPRB,0.74021E-02_JPRB,0.69945E-02_JPRB, &
 & 0.66654E-02_JPRB,0.61172E-02_JPRB,0.51470E-02_JPRB,0.58967E-02_JPRB /)  
KA(:, 2, 5,14) = (/ &
 & 0.10771E-01_JPRB,0.94250E-02_JPRB,0.81953E-02_JPRB,0.74101E-02_JPRB,0.69769E-02_JPRB, &
 & 0.66347E-02_JPRB,0.60743E-02_JPRB,0.50992E-02_JPRB,0.58616E-02_JPRB /)  
KA(:, 3, 5,14) = (/ &
 & 0.10834E-01_JPRB,0.94795E-02_JPRB,0.82348E-02_JPRB,0.74202E-02_JPRB,0.69586E-02_JPRB, &
 & 0.66047E-02_JPRB,0.60376E-02_JPRB,0.50623E-02_JPRB,0.58279E-02_JPRB /)  
KA(:, 4, 5,14) = (/ &
 & 0.10899E-01_JPRB,0.95365E-02_JPRB,0.82726E-02_JPRB,0.74343E-02_JPRB,0.69400E-02_JPRB, &
 & 0.65760E-02_JPRB,0.60076E-02_JPRB,0.50289E-02_JPRB,0.57953E-02_JPRB /)  
KA(:, 5, 5,14) = (/ &
 & 0.10965E-01_JPRB,0.95941E-02_JPRB,0.83123E-02_JPRB,0.74464E-02_JPRB,0.69292E-02_JPRB, &
 & 0.65626E-02_JPRB,0.59940E-02_JPRB,0.50178E-02_JPRB,0.57938E-02_JPRB /)  
KA(:, 1, 6,14) = (/ &
 & 0.10078E-01_JPRB,0.88178E-02_JPRB,0.78666E-02_JPRB,0.74112E-02_JPRB,0.72308E-02_JPRB, &
 & 0.70100E-02_JPRB,0.65312E-02_JPRB,0.55779E-02_JPRB,0.62140E-02_JPRB /)  
KA(:, 2, 6,14) = (/ &
 & 0.10161E-01_JPRB,0.88906E-02_JPRB,0.79113E-02_JPRB,0.74185E-02_JPRB,0.72160E-02_JPRB, &
 & 0.69843E-02_JPRB,0.64888E-02_JPRB,0.55247E-02_JPRB,0.61818E-02_JPRB /)  
KA(:, 3, 6,14) = (/ &
 & 0.10243E-01_JPRB,0.89616E-02_JPRB,0.79583E-02_JPRB,0.74318E-02_JPRB,0.71999E-02_JPRB, &
 & 0.69579E-02_JPRB,0.64523E-02_JPRB,0.54833E-02_JPRB,0.61492E-02_JPRB /)  
KA(:, 4, 6,14) = (/ &
 & 0.10327E-01_JPRB,0.90374E-02_JPRB,0.79989E-02_JPRB,0.74443E-02_JPRB,0.71832E-02_JPRB, &
 & 0.69350E-02_JPRB,0.64210E-02_JPRB,0.54479E-02_JPRB,0.61172E-02_JPRB /)  
KA(:, 5, 6,14) = (/ &
 & 0.10409E-01_JPRB,0.91075E-02_JPRB,0.80421E-02_JPRB,0.74489E-02_JPRB,0.71645E-02_JPRB, &
 & 0.69118E-02_JPRB,0.63952E-02_JPRB,0.54129E-02_JPRB,0.60849E-02_JPRB /)  
KA(:, 1, 7,14) = (/ &
 & 0.93799E-02_JPRB,0.82246E-02_JPRB,0.75645E-02_JPRB,0.73983E-02_JPRB,0.74124E-02_JPRB, &
 & 0.73054E-02_JPRB,0.69103E-02_JPRB,0.59986E-02_JPRB,0.65205E-02_JPRB /)  
KA(:, 2, 7,14) = (/ &
 & 0.94746E-02_JPRB,0.83048E-02_JPRB,0.76105E-02_JPRB,0.74041E-02_JPRB,0.74008E-02_JPRB, &
 & 0.72835E-02_JPRB,0.68745E-02_JPRB,0.59435E-02_JPRB,0.64911E-02_JPRB /)  
KA(:, 3, 7,14) = (/ &
 & 0.95665E-02_JPRB,0.83814E-02_JPRB,0.76560E-02_JPRB,0.74150E-02_JPRB,0.73885E-02_JPRB, &
 & 0.72645E-02_JPRB,0.68399E-02_JPRB,0.59000E-02_JPRB,0.64612E-02_JPRB /)  
KA(:, 4, 7,14) = (/ &
 & 0.96610E-02_JPRB,0.84615E-02_JPRB,0.76953E-02_JPRB,0.74218E-02_JPRB,0.73786E-02_JPRB, &
 & 0.72467E-02_JPRB,0.68110E-02_JPRB,0.58618E-02_JPRB,0.64309E-02_JPRB /)  
KA(:, 5, 7,14) = (/ &
 & 0.97576E-02_JPRB,0.85445E-02_JPRB,0.77428E-02_JPRB,0.74271E-02_JPRB,0.73666E-02_JPRB, &
 & 0.72295E-02_JPRB,0.67856E-02_JPRB,0.58248E-02_JPRB,0.64018E-02_JPRB /)  
KA(:, 1, 8,14) = (/ &
 & 0.86695E-02_JPRB,0.76539E-02_JPRB,0.72832E-02_JPRB,0.73811E-02_JPRB,0.75539E-02_JPRB, &
 & 0.75395E-02_JPRB,0.72391E-02_JPRB,0.63979E-02_JPRB,0.68067E-02_JPRB /)  
KA(:, 2, 8,14) = (/ &
 & 0.87714E-02_JPRB,0.77350E-02_JPRB,0.73260E-02_JPRB,0.73889E-02_JPRB,0.75481E-02_JPRB, &
 & 0.75307E-02_JPRB,0.72059E-02_JPRB,0.63386E-02_JPRB,0.67797E-02_JPRB /)  
KA(:, 3, 8,14) = (/ &
 & 0.88648E-02_JPRB,0.78065E-02_JPRB,0.73635E-02_JPRB,0.73928E-02_JPRB,0.75428E-02_JPRB, &
 & 0.75176E-02_JPRB,0.71786E-02_JPRB,0.62948E-02_JPRB,0.67512E-02_JPRB /)  
KA(:, 4, 8,14) = (/ &
 & 0.89696E-02_JPRB,0.78903E-02_JPRB,0.74008E-02_JPRB,0.73947E-02_JPRB,0.75364E-02_JPRB, &
 & 0.75091E-02_JPRB,0.71562E-02_JPRB,0.62573E-02_JPRB,0.67249E-02_JPRB /)  
KA(:, 5, 8,14) = (/ &
 & 0.90827E-02_JPRB,0.79827E-02_JPRB,0.74524E-02_JPRB,0.74004E-02_JPRB,0.75307E-02_JPRB, &
 & 0.75004E-02_JPRB,0.71406E-02_JPRB,0.62196E-02_JPRB,0.66995E-02_JPRB /)  
KA(:, 1, 9,14) = (/ &
 & 0.79522E-02_JPRB,0.71197E-02_JPRB,0.70358E-02_JPRB,0.73522E-02_JPRB,0.76328E-02_JPRB, &
 & 0.77097E-02_JPRB,0.75175E-02_JPRB,0.67703E-02_JPRB,0.70524E-02_JPRB /)  
KA(:, 2, 9,14) = (/ &
 & 0.80598E-02_JPRB,0.71969E-02_JPRB,0.70715E-02_JPRB,0.73653E-02_JPRB,0.76374E-02_JPRB, &
 & 0.77113E-02_JPRB,0.74908E-02_JPRB,0.67151E-02_JPRB,0.70338E-02_JPRB /)  
KA(:, 3, 9,14) = (/ &
 & 0.81632E-02_JPRB,0.72678E-02_JPRB,0.71027E-02_JPRB,0.73712E-02_JPRB,0.76458E-02_JPRB, &
 & 0.77123E-02_JPRB,0.74742E-02_JPRB,0.66728E-02_JPRB,0.70182E-02_JPRB /)  
KA(:, 4, 9,14) = (/ &
 & 0.82823E-02_JPRB,0.73561E-02_JPRB,0.71392E-02_JPRB,0.73768E-02_JPRB,0.76576E-02_JPRB, &
 & 0.77143E-02_JPRB,0.74622E-02_JPRB,0.66357E-02_JPRB,0.69991E-02_JPRB /)  
KA(:, 5, 9,14) = (/ &
 & 0.84105E-02_JPRB,0.74558E-02_JPRB,0.71910E-02_JPRB,0.73874E-02_JPRB,0.76648E-02_JPRB, &
 & 0.77180E-02_JPRB,0.74509E-02_JPRB,0.65977E-02_JPRB,0.69736E-02_JPRB /)  
KA(:, 1,10,14) = (/ &
 & 0.72630E-02_JPRB,0.66377E-02_JPRB,0.68373E-02_JPRB,0.72984E-02_JPRB,0.76509E-02_JPRB, &
 & 0.78294E-02_JPRB,0.77460E-02_JPRB,0.71207E-02_JPRB,0.20344E-04_JPRB /)  
KA(:, 2,10,14) = (/ &
 & 0.73671E-02_JPRB,0.67055E-02_JPRB,0.68587E-02_JPRB,0.73198E-02_JPRB,0.76710E-02_JPRB, &
 & 0.78437E-02_JPRB,0.77323E-02_JPRB,0.70655E-02_JPRB,0.20564E-04_JPRB /)  
KA(:, 3,10,14) = (/ &
 & 0.74810E-02_JPRB,0.67793E-02_JPRB,0.68858E-02_JPRB,0.73353E-02_JPRB,0.76947E-02_JPRB, &
 & 0.78590E-02_JPRB,0.77307E-02_JPRB,0.70272E-02_JPRB,0.37563E-05_JPRB /)  
KA(:, 4,10,14) = (/ &
 & 0.76171E-02_JPRB,0.68754E-02_JPRB,0.69230E-02_JPRB,0.73502E-02_JPRB,0.77241E-02_JPRB, &
 & 0.78765E-02_JPRB,0.77271E-02_JPRB,0.69915E-02_JPRB,0.47236E-05_JPRB /)  
KA(:, 5,10,14) = (/ &
 & 0.77608E-02_JPRB,0.69811E-02_JPRB,0.69732E-02_JPRB,0.73676E-02_JPRB,0.77455E-02_JPRB, &
 & 0.78941E-02_JPRB,0.77236E-02_JPRB,0.69531E-02_JPRB,0.26047E-04_JPRB /)  
KA(:, 1,11,14) = (/ &
 & 0.66493E-02_JPRB,0.62366E-02_JPRB,0.66807E-02_JPRB,0.72344E-02_JPRB,0.76404E-02_JPRB, &
 & 0.79217E-02_JPRB,0.79405E-02_JPRB,0.74097E-02_JPRB,0.00000E+00_JPRB /)  
KA(:, 2,11,14) = (/ &
 & 0.67616E-02_JPRB,0.63044E-02_JPRB,0.67053E-02_JPRB,0.72656E-02_JPRB,0.76819E-02_JPRB, &
 & 0.79515E-02_JPRB,0.79506E-02_JPRB,0.73718E-02_JPRB,0.18408E-04_JPRB /)  
KA(:, 3,11,14) = (/ &
 & 0.69005E-02_JPRB,0.63894E-02_JPRB,0.67349E-02_JPRB,0.72931E-02_JPRB,0.77291E-02_JPRB, &
 & 0.79845E-02_JPRB,0.79576E-02_JPRB,0.73388E-02_JPRB,0.37607E-04_JPRB /)  
KA(:, 4,11,14) = (/ &
 & 0.70530E-02_JPRB,0.64912E-02_JPRB,0.67712E-02_JPRB,0.73223E-02_JPRB,0.77726E-02_JPRB, &
 & 0.80170E-02_JPRB,0.79618E-02_JPRB,0.73054E-02_JPRB,0.56367E-04_JPRB /)  
KA(:, 5,11,14) = (/ &
 & 0.72039E-02_JPRB,0.65911E-02_JPRB,0.68118E-02_JPRB,0.73572E-02_JPRB,0.78096E-02_JPRB, &
 & 0.80477E-02_JPRB,0.79648E-02_JPRB,0.72708E-02_JPRB,0.00000E+00_JPRB /)  
KA(:, 1,12,14) = (/ &
 & 0.60858E-02_JPRB,0.58916E-02_JPRB,0.65335E-02_JPRB,0.71525E-02_JPRB,0.76284E-02_JPRB, &
 & 0.80006E-02_JPRB,0.81294E-02_JPRB,0.76675E-02_JPRB,0.58588E-04_JPRB /)  
KA(:, 2,12,14) = (/ &
 & 0.62191E-02_JPRB,0.59612E-02_JPRB,0.65675E-02_JPRB,0.71998E-02_JPRB,0.76898E-02_JPRB, &
 & 0.80500E-02_JPRB,0.81534E-02_JPRB,0.76479E-02_JPRB,0.00000E+00_JPRB /)  
KA(:, 3,12,14) = (/ &
 & 0.63725E-02_JPRB,0.60546E-02_JPRB,0.66095E-02_JPRB,0.72445E-02_JPRB,0.77558E-02_JPRB, &
 & 0.80973E-02_JPRB,0.81695E-02_JPRB,0.76255E-02_JPRB,0.29841E-04_JPRB /)  
KA(:, 4,12,14) = (/ &
 & 0.65241E-02_JPRB,0.61494E-02_JPRB,0.66519E-02_JPRB,0.72916E-02_JPRB,0.78126E-02_JPRB, &
 & 0.81445E-02_JPRB,0.81839E-02_JPRB,0.75955E-02_JPRB,0.00000E+00_JPRB /)  
KA(:, 5,12,14) = (/ &
 & 0.66908E-02_JPRB,0.62534E-02_JPRB,0.66904E-02_JPRB,0.73429E-02_JPRB,0.78615E-02_JPRB, &
 & 0.81879E-02_JPRB,0.81898E-02_JPRB,0.75652E-02_JPRB,0.00000E+00_JPRB /)  
KA(:, 1,13,14) = (/ &
 & 0.55891E-02_JPRB,0.56116E-02_JPRB,0.63936E-02_JPRB,0.70621E-02_JPRB,0.76241E-02_JPRB, &
 & 0.80837E-02_JPRB,0.82964E-02_JPRB,0.79007E-02_JPRB,0.00000E+00_JPRB /)  
KA(:, 2,13,14) = (/ &
 & 0.57354E-02_JPRB,0.56825E-02_JPRB,0.64439E-02_JPRB,0.71280E-02_JPRB,0.77039E-02_JPRB, &
 & 0.81460E-02_JPRB,0.83322E-02_JPRB,0.78896E-02_JPRB,0.38090E-04_JPRB /)  
KA(:, 3,13,14) = (/ &
 & 0.58847E-02_JPRB,0.57651E-02_JPRB,0.64971E-02_JPRB,0.71963E-02_JPRB,0.77792E-02_JPRB, &
 & 0.82047E-02_JPRB,0.83632E-02_JPRB,0.78746E-02_JPRB,0.00000E+00_JPRB /)  
KA(:, 4,13,14) = (/ &
 & 0.60503E-02_JPRB,0.58579E-02_JPRB,0.65448E-02_JPRB,0.72663E-02_JPRB,0.78467E-02_JPRB, &
 & 0.82617E-02_JPRB,0.83886E-02_JPRB,0.78555E-02_JPRB,0.00000E+00_JPRB /)  
KA(:, 5,13,14) = (/ &
 & 0.62326E-02_JPRB,0.59678E-02_JPRB,0.65939E-02_JPRB,0.73313E-02_JPRB,0.79071E-02_JPRB, &
 & 0.83133E-02_JPRB,0.83975E-02_JPRB,0.78294E-02_JPRB,0.00000E+00_JPRB /)  
KA(:, 1, 1,15) = (/ &
 & 0.22784E-01_JPRB,0.19937E-01_JPRB,0.17089E-01_JPRB,0.14240E-01_JPRB,0.11393E-01_JPRB, &
 & 0.85439E-02_JPRB,0.62360E-02_JPRB,0.50515E-02_JPRB,0.76952E-02_JPRB /)  
KA(:, 2, 1,15) = (/ &
 & 0.22781E-01_JPRB,0.19933E-01_JPRB,0.17085E-01_JPRB,0.14238E-01_JPRB,0.11390E-01_JPRB, &
 & 0.85426E-02_JPRB,0.62118E-02_JPRB,0.49990E-02_JPRB,0.75953E-02_JPRB /)  
KA(:, 3, 1,15) = (/ &
 & 0.22781E-01_JPRB,0.19934E-01_JPRB,0.17086E-01_JPRB,0.14239E-01_JPRB,0.11390E-01_JPRB, &
 & 0.85428E-02_JPRB,0.62149E-02_JPRB,0.49913E-02_JPRB,0.75531E-02_JPRB /)  
KA(:, 4, 1,15) = (/ &
 & 0.22807E-01_JPRB,0.19955E-01_JPRB,0.17104E-01_JPRB,0.14253E-01_JPRB,0.11403E-01_JPRB, &
 & 0.85521E-02_JPRB,0.61662E-02_JPRB,0.48921E-02_JPRB,0.74213E-02_JPRB /)  
KA(:, 5, 1,15) = (/ &
 & 0.22846E-01_JPRB,0.19991E-01_JPRB,0.17134E-01_JPRB,0.14278E-01_JPRB,0.11422E-01_JPRB, &
 & 0.85672E-02_JPRB,0.61477E-02_JPRB,0.48442E-02_JPRB,0.73437E-02_JPRB /)  
KA(:, 1, 2,15) = (/ &
 & 0.25963E-01_JPRB,0.22716E-01_JPRB,0.19471E-01_JPRB,0.16227E-01_JPRB,0.12981E-01_JPRB, &
 & 0.97432E-02_JPRB,0.72799E-02_JPRB,0.58913E-02_JPRB,0.89930E-02_JPRB /)  
KA(:, 2, 2,15) = (/ &
 & 0.25957E-01_JPRB,0.22712E-01_JPRB,0.19468E-01_JPRB,0.16223E-01_JPRB,0.12978E-01_JPRB, &
 & 0.97376E-02_JPRB,0.72409E-02_JPRB,0.58243E-02_JPRB,0.88738E-02_JPRB /)  
KA(:, 3, 2,15) = (/ &
 & 0.25967E-01_JPRB,0.22721E-01_JPRB,0.19475E-01_JPRB,0.16229E-01_JPRB,0.12984E-01_JPRB, &
 & 0.97376E-02_JPRB,0.72294E-02_JPRB,0.57970E-02_JPRB,0.88082E-02_JPRB /)  
KA(:, 4, 2,15) = (/ &
 & 0.25991E-01_JPRB,0.22741E-01_JPRB,0.19493E-01_JPRB,0.16243E-01_JPRB,0.12995E-01_JPRB, &
 & 0.97464E-02_JPRB,0.71939E-02_JPRB,0.57194E-02_JPRB,0.86974E-02_JPRB /)  
KA(:, 5, 2,15) = (/ &
 & 0.26012E-01_JPRB,0.22759E-01_JPRB,0.19508E-01_JPRB,0.16256E-01_JPRB,0.13005E-01_JPRB, &
 & 0.97539E-02_JPRB,0.71378E-02_JPRB,0.56167E-02_JPRB,0.85506E-02_JPRB /)  
KA(:, 1, 3,15) = (/ &
 & 0.29273E-01_JPRB,0.25614E-01_JPRB,0.21954E-01_JPRB,0.18296E-01_JPRB,0.14638E-01_JPRB, &
 & 0.11059E-01_JPRB,0.84536E-02_JPRB,0.68488E-02_JPRB,0.10453E-01_JPRB /)  
KA(:, 2, 3,15) = (/ &
 & 0.29273E-01_JPRB,0.25613E-01_JPRB,0.21954E-01_JPRB,0.18296E-01_JPRB,0.14636E-01_JPRB, &
 & 0.11040E-01_JPRB,0.84006E-02_JPRB,0.67671E-02_JPRB,0.10308E-01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART10',1,ZHOOK_HANDLE)
END SUBROUTINE PART10


SUBROUTINE PART11

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART11',0,ZHOOK_HANDLE)


KA(:, 3, 3,15) = (/ &
 & 0.29281E-01_JPRB,0.25620E-01_JPRB,0.21957E-01_JPRB,0.18299E-01_JPRB,0.14639E-01_JPRB, &
 & 0.11029E-01_JPRB,0.83532E-02_JPRB,0.66803E-02_JPRB,0.10170E-01_JPRB /)  
KA(:, 4, 3,15) = (/ &
 & 0.29284E-01_JPRB,0.25622E-01_JPRB,0.21963E-01_JPRB,0.18303E-01_JPRB,0.14642E-01_JPRB, &
 & 0.11027E-01_JPRB,0.83265E-02_JPRB,0.66328E-02_JPRB,0.10072E-01_JPRB /)  
KA(:, 5, 3,15) = (/ &
 & 0.29273E-01_JPRB,0.25615E-01_JPRB,0.21955E-01_JPRB,0.18297E-01_JPRB,0.14636E-01_JPRB, &
 & 0.11016E-01_JPRB,0.82524E-02_JPRB,0.65141E-02_JPRB,0.98927E-02_JPRB /)  
KA(:, 1, 4,15) = (/ &
 & 0.32689E-01_JPRB,0.28601E-01_JPRB,0.24517E-01_JPRB,0.20431E-01_JPRB,0.16343E-01_JPRB, &
 & 0.12498E-01_JPRB,0.97860E-02_JPRB,0.79359E-02_JPRB,0.11964E-01_JPRB /)  
KA(:, 2, 4,15) = (/ &
 & 0.32673E-01_JPRB,0.28590E-01_JPRB,0.24505E-01_JPRB,0.20420E-01_JPRB,0.16336E-01_JPRB, &
 & 0.12462E-01_JPRB,0.97090E-02_JPRB,0.78356E-02_JPRB,0.11793E-01_JPRB /)  
KA(:, 3, 4,15) = (/ &
 & 0.32657E-01_JPRB,0.28575E-01_JPRB,0.24494E-01_JPRB,0.20410E-01_JPRB,0.16330E-01_JPRB, &
 & 0.12434E-01_JPRB,0.96384E-02_JPRB,0.77321E-02_JPRB,0.11625E-01_JPRB /)  
KA(:, 4, 4,15) = (/ &
 & 0.32631E-01_JPRB,0.28553E-01_JPRB,0.24473E-01_JPRB,0.20396E-01_JPRB,0.16316E-01_JPRB, &
 & 0.12404E-01_JPRB,0.95671E-02_JPRB,0.76286E-02_JPRB,0.11457E-01_JPRB /)  
KA(:, 5, 4,15) = (/ &
 & 0.32595E-01_JPRB,0.28521E-01_JPRB,0.24445E-01_JPRB,0.20372E-01_JPRB,0.16297E-01_JPRB, &
 & 0.12376E-01_JPRB,0.95137E-02_JPRB,0.75694E-02_JPRB,0.11318E-01_JPRB /)  
KA(:, 1, 5,15) = (/ &
 & 0.36129E-01_JPRB,0.31613E-01_JPRB,0.27097E-01_JPRB,0.22582E-01_JPRB,0.18065E-01_JPRB, &
 & 0.14059E-01_JPRB,0.11253E-01_JPRB,0.91497E-02_JPRB,0.13513E-01_JPRB /)  
KA(:, 2, 5,15) = (/ &
 & 0.36091E-01_JPRB,0.31580E-01_JPRB,0.27068E-01_JPRB,0.22557E-01_JPRB,0.18046E-01_JPRB, &
 & 0.13996E-01_JPRB,0.11159E-01_JPRB,0.90273E-02_JPRB,0.13314E-01_JPRB /)  
KA(:, 3, 5,15) = (/ &
 & 0.36050E-01_JPRB,0.31543E-01_JPRB,0.27038E-01_JPRB,0.22530E-01_JPRB,0.18025E-01_JPRB, &
 & 0.13938E-01_JPRB,0.11057E-01_JPRB,0.89022E-02_JPRB,0.13117E-01_JPRB /)  
KA(:, 4, 5,15) = (/ &
 & 0.35994E-01_JPRB,0.31496E-01_JPRB,0.26994E-01_JPRB,0.22495E-01_JPRB,0.17996E-01_JPRB, &
 & 0.13877E-01_JPRB,0.10953E-01_JPRB,0.87755E-02_JPRB,0.12914E-01_JPRB /)  
KA(:, 5, 5,15) = (/ &
 & 0.35944E-01_JPRB,0.31450E-01_JPRB,0.26957E-01_JPRB,0.22466E-01_JPRB,0.17973E-01_JPRB, &
 & 0.13819E-01_JPRB,0.10863E-01_JPRB,0.86942E-02_JPRB,0.12744E-01_JPRB /)  
KA(:, 1, 6,15) = (/ &
 & 0.39506E-01_JPRB,0.34566E-01_JPRB,0.29627E-01_JPRB,0.24691E-01_JPRB,0.19819E-01_JPRB, &
 & 0.15734E-01_JPRB,0.12852E-01_JPRB,0.10482E-01_JPRB,0.15100E-01_JPRB /)  
KA(:, 2, 6,15) = (/ &
 & 0.39438E-01_JPRB,0.34510E-01_JPRB,0.29581E-01_JPRB,0.24651E-01_JPRB,0.19767E-01_JPRB, &
 & 0.15626E-01_JPRB,0.12723E-01_JPRB,0.10339E-01_JPRB,0.14869E-01_JPRB /)  
KA(:, 3, 6,15) = (/ &
 & 0.39363E-01_JPRB,0.34443E-01_JPRB,0.29524E-01_JPRB,0.24601E-01_JPRB,0.19714E-01_JPRB, &
 & 0.15531E-01_JPRB,0.12593E-01_JPRB,0.10189E-01_JPRB,0.14636E-01_JPRB /)  
KA(:, 4, 6,15) = (/ &
 & 0.39295E-01_JPRB,0.34380E-01_JPRB,0.29468E-01_JPRB,0.24559E-01_JPRB,0.19663E-01_JPRB, &
 & 0.15432E-01_JPRB,0.12453E-01_JPRB,0.10038E-01_JPRB,0.14402E-01_JPRB /)  
KA(:, 5, 6,15) = (/ &
 & 0.39232E-01_JPRB,0.34326E-01_JPRB,0.29423E-01_JPRB,0.24518E-01_JPRB,0.19622E-01_JPRB, &
 & 0.15336E-01_JPRB,0.12308E-01_JPRB,0.98939E-02_JPRB,0.14172E-01_JPRB /)  
KA(:, 1, 7,15) = (/ &
 & 0.42642E-01_JPRB,0.37314E-01_JPRB,0.31983E-01_JPRB,0.26652E-01_JPRB,0.21609E-01_JPRB, &
 & 0.17542E-01_JPRB,0.14584E-01_JPRB,0.11924E-01_JPRB,0.16714E-01_JPRB /)  
KA(:, 2, 7,15) = (/ &
 & 0.42588E-01_JPRB,0.37267E-01_JPRB,0.31942E-01_JPRB,0.26620E-01_JPRB,0.21537E-01_JPRB, &
 & 0.17385E-01_JPRB,0.14405E-01_JPRB,0.11750E-01_JPRB,0.16453E-01_JPRB /)  
KA(:, 3, 7,15) = (/ &
 & 0.42519E-01_JPRB,0.37203E-01_JPRB,0.31888E-01_JPRB,0.26575E-01_JPRB,0.21450E-01_JPRB, &
 & 0.17237E-01_JPRB,0.14233E-01_JPRB,0.11569E-01_JPRB,0.16190E-01_JPRB /)  
KA(:, 4, 7,15) = (/ &
 & 0.42450E-01_JPRB,0.37145E-01_JPRB,0.31837E-01_JPRB,0.26531E-01_JPRB,0.21364E-01_JPRB, &
 & 0.17089E-01_JPRB,0.14051E-01_JPRB,0.11390E-01_JPRB,0.15924E-01_JPRB /)  
KA(:, 5, 7,15) = (/ &
 & 0.42372E-01_JPRB,0.37075E-01_JPRB,0.31780E-01_JPRB,0.26482E-01_JPRB,0.21293E-01_JPRB, &
 & 0.16947E-01_JPRB,0.13866E-01_JPRB,0.11216E-01_JPRB,0.15662E-01_JPRB /)  
KA(:, 1, 8,15) = (/ &
 & 0.45438E-01_JPRB,0.39757E-01_JPRB,0.34077E-01_JPRB,0.28427E-01_JPRB,0.23418E-01_JPRB, &
 & 0.19456E-01_JPRB,0.16427E-01_JPRB,0.13456E-01_JPRB,0.18359E-01_JPRB /)  
KA(:, 2, 8,15) = (/ &
 & 0.45420E-01_JPRB,0.39742E-01_JPRB,0.34065E-01_JPRB,0.28396E-01_JPRB,0.23308E-01_JPRB, &
 & 0.19242E-01_JPRB,0.16196E-01_JPRB,0.13253E-01_JPRB,0.18076E-01_JPRB /)  
KA(:, 3, 8,15) = (/ &
 & 0.45404E-01_JPRB,0.39728E-01_JPRB,0.34054E-01_JPRB,0.28379E-01_JPRB,0.23190E-01_JPRB, &
 & 0.19044E-01_JPRB,0.15968E-01_JPRB,0.13036E-01_JPRB,0.17789E-01_JPRB /)  
KA(:, 4, 8,15) = (/ &
 & 0.45355E-01_JPRB,0.39684E-01_JPRB,0.34015E-01_JPRB,0.28348E-01_JPRB,0.23074E-01_JPRB, &
 & 0.18841E-01_JPRB,0.15735E-01_JPRB,0.12818E-01_JPRB,0.17487E-01_JPRB /)  
KA(:, 5, 8,15) = (/ &
 & 0.45268E-01_JPRB,0.39604E-01_JPRB,0.33951E-01_JPRB,0.28294E-01_JPRB,0.22964E-01_JPRB, &
 & 0.18639E-01_JPRB,0.15495E-01_JPRB,0.12608E-01_JPRB,0.17187E-01_JPRB /)  
KA(:, 1, 9,15) = (/ &
 & 0.47828E-01_JPRB,0.41848E-01_JPRB,0.35870E-01_JPRB,0.30096E-01_JPRB,0.25238E-01_JPRB, &
 & 0.21453E-01_JPRB,0.18348E-01_JPRB,0.15048E-01_JPRB,0.20030E-01_JPRB /)  
KA(:, 2, 9,15) = (/ &
 & 0.47883E-01_JPRB,0.41899E-01_JPRB,0.35911E-01_JPRB,0.30061E-01_JPRB,0.25102E-01_JPRB, &
 & 0.21178E-01_JPRB,0.18071E-01_JPRB,0.14812E-01_JPRB,0.19720E-01_JPRB /)  
KA(:, 3, 9,15) = (/ &
 & 0.47917E-01_JPRB,0.41930E-01_JPRB,0.35941E-01_JPRB,0.30033E-01_JPRB,0.24934E-01_JPRB, &
 & 0.20917E-01_JPRB,0.17786E-01_JPRB,0.14566E-01_JPRB,0.19396E-01_JPRB /)  
KA(:, 4, 9,15) = (/ &
 & 0.47914E-01_JPRB,0.41927E-01_JPRB,0.35936E-01_JPRB,0.29997E-01_JPRB,0.24771E-01_JPRB, &
 & 0.20657E-01_JPRB,0.17491E-01_JPRB,0.14311E-01_JPRB,0.19056E-01_JPRB /)  
KA(:, 5, 9,15) = (/ &
 & 0.47853E-01_JPRB,0.41872E-01_JPRB,0.35889E-01_JPRB,0.29935E-01_JPRB,0.24616E-01_JPRB, &
 & 0.20393E-01_JPRB,0.17196E-01_JPRB,0.14061E-01_JPRB,0.18721E-01_JPRB /)  
KA(:, 1,10,15) = (/ &
 & 0.49786E-01_JPRB,0.43562E-01_JPRB,0.37346E-01_JPRB,0.31673E-01_JPRB,0.27058E-01_JPRB, &
 & 0.23446E-01_JPRB,0.20298E-01_JPRB,0.16634E-01_JPRB,0.20401E-01_JPRB /)  
KA(:, 2,10,15) = (/ &
 & 0.49957E-01_JPRB,0.43713E-01_JPRB,0.37470E-01_JPRB,0.31624E-01_JPRB,0.26879E-01_JPRB, &
 & 0.23121E-01_JPRB,0.19962E-01_JPRB,0.16379E-01_JPRB,0.19980E-01_JPRB /)  
KA(:, 3,10,15) = (/ &
 & 0.50073E-01_JPRB,0.43811E-01_JPRB,0.37553E-01_JPRB,0.31591E-01_JPRB,0.26668E-01_JPRB, &
 & 0.22810E-01_JPRB,0.19616E-01_JPRB,0.16101E-01_JPRB,0.19150E-01_JPRB /)  
KA(:, 4,10,15) = (/ &
 & 0.50104E-01_JPRB,0.43839E-01_JPRB,0.37576E-01_JPRB,0.31542E-01_JPRB,0.26451E-01_JPRB, &
 & 0.22487E-01_JPRB,0.19263E-01_JPRB,0.15810E-01_JPRB,0.18309E-01_JPRB /)  
KA(:, 5,10,15) = (/ &
 & 0.50083E-01_JPRB,0.43821E-01_JPRB,0.37560E-01_JPRB,0.31463E-01_JPRB,0.26247E-01_JPRB, &
 & 0.22153E-01_JPRB,0.18906E-01_JPRB,0.15516E-01_JPRB,0.17790E-01_JPRB /)  
KA(:, 1,11,15) = (/ &
 & 0.51449E-01_JPRB,0.45016E-01_JPRB,0.38642E-01_JPRB,0.33136E-01_JPRB,0.28759E-01_JPRB, &
 & 0.25254E-01_JPRB,0.22053E-01_JPRB,0.18120E-01_JPRB,0.53897E-02_JPRB /)  
KA(:, 2,11,15) = (/ &
 & 0.51718E-01_JPRB,0.45255E-01_JPRB,0.38815E-01_JPRB,0.33090E-01_JPRB,0.28517E-01_JPRB, &
 & 0.24894E-01_JPRB,0.21659E-01_JPRB,0.17825E-01_JPRB,0.47196E-02_JPRB /)  
KA(:, 3,11,15) = (/ &
 & 0.51885E-01_JPRB,0.45397E-01_JPRB,0.38919E-01_JPRB,0.33034E-01_JPRB,0.28248E-01_JPRB, &
 & 0.24520E-01_JPRB,0.21252E-01_JPRB,0.17499E-01_JPRB,0.36639E-02_JPRB /)  
KA(:, 4,11,15) = (/ &
 & 0.51965E-01_JPRB,0.45468E-01_JPRB,0.38969E-01_JPRB,0.32946E-01_JPRB,0.27987E-01_JPRB, &
 & 0.24125E-01_JPRB,0.20834E-01_JPRB,0.17164E-01_JPRB,0.30436E-02_JPRB /)  
KA(:, 5,11,15) = (/ &
 & 0.52007E-01_JPRB,0.45508E-01_JPRB,0.39008E-01_JPRB,0.32828E-01_JPRB,0.27732E-01_JPRB, &
 & 0.23720E-01_JPRB,0.20415E-01_JPRB,0.16822E-01_JPRB,0.23024E-02_JPRB /)  
KA(:, 1,12,15) = (/ &
 & 0.52772E-01_JPRB,0.46179E-01_JPRB,0.39786E-01_JPRB,0.34518E-01_JPRB,0.30341E-01_JPRB, &
 & 0.26996E-01_JPRB,0.23719E-01_JPRB,0.19625E-01_JPRB,0.00000E+00_JPRB /)  
KA(:, 2,12,15) = (/ &
 & 0.53131E-01_JPRB,0.46489E-01_JPRB,0.39976E-01_JPRB,0.34451E-01_JPRB,0.30050E-01_JPRB, &
 & 0.26583E-01_JPRB,0.23271E-01_JPRB,0.19259E-01_JPRB,0.79250E-04_JPRB /)  
KA(:, 3,12,15) = (/ &
 & 0.53372E-01_JPRB,0.46707E-01_JPRB,0.40090E-01_JPRB,0.34369E-01_JPRB,0.29734E-01_JPRB, &
 & 0.26140E-01_JPRB,0.22802E-01_JPRB,0.18870E-01_JPRB,0.00000E+00_JPRB /)  
KA(:, 4,12,15) = (/ &
 & 0.53549E-01_JPRB,0.46855E-01_JPRB,0.40175E-01_JPRB,0.34238E-01_JPRB,0.29424E-01_JPRB, &
 & 0.25661E-01_JPRB,0.22318E-01_JPRB,0.18486E-01_JPRB,0.00000E+00_JPRB /)  
KA(:, 5,12,15) = (/ &
 & 0.53641E-01_JPRB,0.46944E-01_JPRB,0.40238E-01_JPRB,0.34087E-01_JPRB,0.29108E-01_JPRB, &
 & 0.25184E-01_JPRB,0.21836E-01_JPRB,0.18091E-01_JPRB,0.00000E+00_JPRB /)  
KA(:, 1,13,15) = (/ &
 & 0.53794E-01_JPRB,0.47070E-01_JPRB,0.40802E-01_JPRB,0.35804E-01_JPRB,0.31808E-01_JPRB, &
 & 0.28611E-01_JPRB,0.25317E-01_JPRB,0.21103E-01_JPRB,0.00000E+00_JPRB /)  
KA(:, 2,13,15) = (/ &
 & 0.54248E-01_JPRB,0.47468E-01_JPRB,0.40994E-01_JPRB,0.35717E-01_JPRB,0.31468E-01_JPRB, &
 & 0.28147E-01_JPRB,0.24800E-01_JPRB,0.20666E-01_JPRB,0.99549E-04_JPRB /)  
KA(:, 3,13,15) = (/ &
 & 0.54616E-01_JPRB,0.47795E-01_JPRB,0.41127E-01_JPRB,0.35591E-01_JPRB,0.31112E-01_JPRB, &
 & 0.27634E-01_JPRB,0.24251E-01_JPRB,0.20223E-01_JPRB,0.00000E+00_JPRB /)  
KA(:, 4,13,15) = (/ &
 & 0.54881E-01_JPRB,0.48017E-01_JPRB,0.41234E-01_JPRB,0.35410E-01_JPRB,0.30749E-01_JPRB, &
 & 0.27090E-01_JPRB,0.23692E-01_JPRB,0.19766E-01_JPRB,0.00000E+00_JPRB /)  
KA(:, 5,13,15) = (/ &
 & 0.55030E-01_JPRB,0.48150E-01_JPRB,0.41295E-01_JPRB,0.35229E-01_JPRB,0.30369E-01_JPRB, &
 & 0.26544E-01_JPRB,0.23150E-01_JPRB,0.19313E-01_JPRB,0.00000E+00_JPRB /)  
KA(:, 1, 1,16) = (/ &
 & 0.31412E-01_JPRB,0.27484E-01_JPRB,0.23556E-01_JPRB,0.19630E-01_JPRB,0.15703E-01_JPRB, &
 & 0.11777E-01_JPRB,0.78503E-02_JPRB,0.63859E-02_JPRB,0.10546E-01_JPRB /)  
KA(:, 2, 1,16) = (/ &
 & 0.31306E-01_JPRB,0.27393E-01_JPRB,0.23480E-01_JPRB,0.19566E-01_JPRB,0.15652E-01_JPRB, &
 & 0.11737E-01_JPRB,0.78244E-02_JPRB,0.64039E-02_JPRB,0.10543E-01_JPRB /)  
KA(:, 3, 1,16) = (/ &
 & 0.31189E-01_JPRB,0.27291E-01_JPRB,0.23390E-01_JPRB,0.19492E-01_JPRB,0.15594E-01_JPRB, &
 & 0.11694E-01_JPRB,0.77949E-02_JPRB,0.65607E-02_JPRB,0.10621E-01_JPRB /)  
KA(:, 4, 1,16) = (/ &
 & 0.31060E-01_JPRB,0.27175E-01_JPRB,0.23293E-01_JPRB,0.19412E-01_JPRB,0.15526E-01_JPRB, &
 & 0.11645E-01_JPRB,0.77621E-02_JPRB,0.64197E-02_JPRB,0.10470E-01_JPRB /)  
KA(:, 5, 1,16) = (/ &
 & 0.30934E-01_JPRB,0.27069E-01_JPRB,0.23201E-01_JPRB,0.19334E-01_JPRB,0.15466E-01_JPRB, &
 & 0.11599E-01_JPRB,0.77309E-02_JPRB,0.64181E-02_JPRB,0.10407E-01_JPRB /)  
KA(:, 1, 2,16) = (/ &
 & 0.37345E-01_JPRB,0.32673E-01_JPRB,0.28007E-01_JPRB,0.23341E-01_JPRB,0.18670E-01_JPRB, &
 & 0.14002E-01_JPRB,0.93330E-02_JPRB,0.76035E-02_JPRB,0.12759E-01_JPRB /)  
KA(:, 2, 2,16) = (/ &
 & 0.37160E-01_JPRB,0.32513E-01_JPRB,0.27871E-01_JPRB,0.23225E-01_JPRB,0.18579E-01_JPRB, &
 & 0.13933E-01_JPRB,0.92868E-02_JPRB,0.75902E-02_JPRB,0.12702E-01_JPRB /)  
KA(:, 3, 2,16) = (/ &
 & 0.36977E-01_JPRB,0.32353E-01_JPRB,0.27732E-01_JPRB,0.23111E-01_JPRB,0.18487E-01_JPRB, &
 & 0.13864E-01_JPRB,0.92415E-02_JPRB,0.77168E-02_JPRB,0.12729E-01_JPRB /)  
KA(:, 4, 2,16) = (/ &
 & 0.36807E-01_JPRB,0.32204E-01_JPRB,0.27602E-01_JPRB,0.23002E-01_JPRB,0.18402E-01_JPRB, &
 & 0.13798E-01_JPRB,0.91981E-02_JPRB,0.77023E-02_JPRB,0.12641E-01_JPRB /)  
KA(:, 5, 2,16) = (/ &
 & 0.36620E-01_JPRB,0.32046E-01_JPRB,0.27465E-01_JPRB,0.22887E-01_JPRB,0.18309E-01_JPRB, &
 & 0.13731E-01_JPRB,0.91527E-02_JPRB,0.75684E-02_JPRB,0.12457E-01_JPRB /)  
KA(:, 1, 3,16) = (/ &
 & 0.44232E-01_JPRB,0.38700E-01_JPRB,0.33173E-01_JPRB,0.27644E-01_JPRB,0.22114E-01_JPRB, &
 & 0.16581E-01_JPRB,0.11054E-01_JPRB,0.91028E-02_JPRB,0.15510E-01_JPRB /)  
KA(:, 2, 3,16) = (/ &
 & 0.43957E-01_JPRB,0.38463E-01_JPRB,0.32969E-01_JPRB,0.27474E-01_JPRB,0.21977E-01_JPRB, &
 & 0.16483E-01_JPRB,0.10987E-01_JPRB,0.90298E-02_JPRB,0.15354E-01_JPRB /)  
KA(:, 3, 3,16) = (/ &
 & 0.43680E-01_JPRB,0.38217E-01_JPRB,0.32756E-01_JPRB,0.27297E-01_JPRB,0.21838E-01_JPRB, &
 & 0.16376E-01_JPRB,0.10918E-01_JPRB,0.89896E-02_JPRB,0.15195E-01_JPRB /)  
KA(:, 4, 3,16) = (/ &
 & 0.43409E-01_JPRB,0.37982E-01_JPRB,0.32556E-01_JPRB,0.27128E-01_JPRB,0.21703E-01_JPRB, &
 & 0.16277E-01_JPRB,0.10849E-01_JPRB,0.90630E-02_JPRB,0.15090E-01_JPRB /)  
KA(:, 5, 3,16) = (/ &
 & 0.43148E-01_JPRB,0.37757E-01_JPRB,0.32362E-01_JPRB,0.26967E-01_JPRB,0.21574E-01_JPRB, &
 & 0.16179E-01_JPRB,0.10784E-01_JPRB,0.89323E-02_JPRB,0.14861E-01_JPRB /)  
KA(:, 1, 4,16) = (/ &
 & 0.52173E-01_JPRB,0.45650E-01_JPRB,0.39129E-01_JPRB,0.32609E-01_JPRB,0.26084E-01_JPRB, &
 & 0.19564E-01_JPRB,0.13063E-01_JPRB,0.10928E-01_JPRB,0.18665E-01_JPRB /)  
KA(:, 2, 4,16) = (/ &
 & 0.51767E-01_JPRB,0.45298E-01_JPRB,0.38824E-01_JPRB,0.32358E-01_JPRB,0.25882E-01_JPRB, &
 & 0.19411E-01_JPRB,0.12948E-01_JPRB,0.10795E-01_JPRB,0.18386E-01_JPRB /)  
KA(:, 3, 4,16) = (/ &
 & 0.51358E-01_JPRB,0.44935E-01_JPRB,0.38514E-01_JPRB,0.32093E-01_JPRB,0.25677E-01_JPRB, &
 & 0.19255E-01_JPRB,0.12843E-01_JPRB,0.10694E-01_JPRB,0.18120E-01_JPRB /)  
KA(:, 4, 4,16) = (/ &
 & 0.50955E-01_JPRB,0.44587E-01_JPRB,0.38218E-01_JPRB,0.31847E-01_JPRB,0.25475E-01_JPRB, &
 & 0.19107E-01_JPRB,0.12737E-01_JPRB,0.10607E-01_JPRB,0.17851E-01_JPRB /)  
KA(:, 5, 4,16) = (/ &
 & 0.50544E-01_JPRB,0.44227E-01_JPRB,0.37909E-01_JPRB,0.31588E-01_JPRB,0.25270E-01_JPRB, &
 & 0.18952E-01_JPRB,0.12634E-01_JPRB,0.10599E-01_JPRB,0.17618E-01_JPRB /)  
KA(:, 1, 5,16) = (/ &
 & 0.61214E-01_JPRB,0.53565E-01_JPRB,0.45917E-01_JPRB,0.38262E-01_JPRB,0.30607E-01_JPRB, &
 & 0.22954E-01_JPRB,0.15462E-01_JPRB,0.13125E-01_JPRB,0.22278E-01_JPRB /)  
KA(:, 2, 5,16) = (/ &
 & 0.60651E-01_JPRB,0.53068E-01_JPRB,0.45484E-01_JPRB,0.37903E-01_JPRB,0.30322E-01_JPRB, &
 & 0.22741E-01_JPRB,0.15244E-01_JPRB,0.12927E-01_JPRB,0.21870E-01_JPRB /)  
KA(:, 3, 5,16) = (/ &
 & 0.60040E-01_JPRB,0.52533E-01_JPRB,0.45028E-01_JPRB,0.37524E-01_JPRB,0.30019E-01_JPRB, &
 & 0.22514E-01_JPRB,0.15074E-01_JPRB,0.12758E-01_JPRB,0.21465E-01_JPRB /)  
KA(:, 4, 5,16) = (/ &
 & 0.59437E-01_JPRB,0.52006E-01_JPRB,0.44573E-01_JPRB,0.37145E-01_JPRB,0.29715E-01_JPRB, &
 & 0.22286E-01_JPRB,0.14911E-01_JPRB,0.12602E-01_JPRB,0.21062E-01_JPRB /)  
KA(:, 5, 5,16) = (/ &
 & 0.58809E-01_JPRB,0.51461E-01_JPRB,0.44106E-01_JPRB,0.36755E-01_JPRB,0.29405E-01_JPRB, &
 & 0.22053E-01_JPRB,0.14746E-01_JPRB,0.12499E-01_JPRB,0.20685E-01_JPRB /)  
KA(:, 1, 6,16) = (/ &
 & 0.71375E-01_JPRB,0.62451E-01_JPRB,0.53529E-01_JPRB,0.44607E-01_JPRB,0.35687E-01_JPRB, &
 & 0.26759E-01_JPRB,0.18273E-01_JPRB,0.15758E-01_JPRB,0.26378E-01_JPRB /)  
KA(:, 2, 6,16) = (/ &
 & 0.70571E-01_JPRB,0.61748E-01_JPRB,0.52933E-01_JPRB,0.44107E-01_JPRB,0.35285E-01_JPRB, &
 & 0.26462E-01_JPRB,0.17959E-01_JPRB,0.15470E-01_JPRB,0.25822E-01_JPRB /)  
KA(:, 3, 6,16) = (/ &
 & 0.69734E-01_JPRB,0.61022E-01_JPRB,0.52301E-01_JPRB,0.43583E-01_JPRB,0.34867E-01_JPRB, &
 & 0.26147E-01_JPRB,0.17660E-01_JPRB,0.15207E-01_JPRB,0.25265E-01_JPRB /)  
KA(:, 4, 6,16) = (/ &
 & 0.68870E-01_JPRB,0.60256E-01_JPRB,0.51654E-01_JPRB,0.43043E-01_JPRB,0.34432E-01_JPRB, &
 & 0.25826E-01_JPRB,0.17391E-01_JPRB,0.14968E-01_JPRB,0.24710E-01_JPRB /)  
KA(:, 5, 6,16) = (/ &
 & 0.67988E-01_JPRB,0.59482E-01_JPRB,0.50988E-01_JPRB,0.42488E-01_JPRB,0.33987E-01_JPRB, &
 & 0.25491E-01_JPRB,0.17159E-01_JPRB,0.14740E-01_JPRB,0.24148E-01_JPRB /)  
KA(:, 1, 7,16) = (/ &
 & 0.82705E-01_JPRB,0.72369E-01_JPRB,0.62031E-01_JPRB,0.51694E-01_JPRB,0.41353E-01_JPRB, &
 & 0.31012E-01_JPRB,0.21511E-01_JPRB,0.18843E-01_JPRB,0.31008E-01_JPRB /)  
KA(:, 2, 7,16) = (/ &
 & 0.81487E-01_JPRB,0.71304E-01_JPRB,0.61113E-01_JPRB,0.50924E-01_JPRB,0.40740E-01_JPRB, &
 & 0.30554E-01_JPRB,0.21074E-01_JPRB,0.18457E-01_JPRB,0.30235E-01_JPRB /)  
KA(:, 3, 7,16) = (/ &
 & 0.80318E-01_JPRB,0.70281E-01_JPRB,0.60235E-01_JPRB,0.50200E-01_JPRB,0.40157E-01_JPRB, &
 & 0.30117E-01_JPRB,0.20636E-01_JPRB,0.18102E-01_JPRB,0.29494E-01_JPRB /)  
KA(:, 4, 7,16) = (/ &
 & 0.79154E-01_JPRB,0.69255E-01_JPRB,0.59365E-01_JPRB,0.49470E-01_JPRB,0.39576E-01_JPRB, &
 & 0.29680E-01_JPRB,0.20228E-01_JPRB,0.17748E-01_JPRB,0.28759E-01_JPRB /)  
KA(:, 5, 7,16) = (/ &
 & 0.77937E-01_JPRB,0.68190E-01_JPRB,0.58450E-01_JPRB,0.48707E-01_JPRB,0.38965E-01_JPRB, &
 & 0.29223E-01_JPRB,0.19858E-01_JPRB,0.17406E-01_JPRB,0.28017E-01_JPRB /)  
KA(:, 1, 8,16) = (/ &
 & 0.95173E-01_JPRB,0.83270E-01_JPRB,0.71377E-01_JPRB,0.59480E-01_JPRB,0.47582E-01_JPRB, &
 & 0.35684E-01_JPRB,0.25169E-01_JPRB,0.22449E-01_JPRB,0.36274E-01_JPRB /)  
KA(:, 2, 8,16) = (/ &
 & 0.93409E-01_JPRB,0.81740E-01_JPRB,0.70058E-01_JPRB,0.58384E-01_JPRB,0.46709E-01_JPRB, &
 & 0.35028E-01_JPRB,0.24581E-01_JPRB,0.21893E-01_JPRB,0.35207E-01_JPRB /)  
KA(:, 3, 8,16) = (/ &
 & 0.91737E-01_JPRB,0.80263E-01_JPRB,0.68796E-01_JPRB,0.57330E-01_JPRB,0.45863E-01_JPRB, &
 & 0.34396E-01_JPRB,0.23987E-01_JPRB,0.21409E-01_JPRB,0.34174E-01_JPRB /)  
KA(:, 4, 8,16) = (/ &
 & 0.90113E-01_JPRB,0.78852E-01_JPRB,0.67585E-01_JPRB,0.56324E-01_JPRB,0.45060E-01_JPRB, &
 & 0.33794E-01_JPRB,0.23415E-01_JPRB,0.20940E-01_JPRB,0.33185E-01_JPRB /)  
KA(:, 5, 8,16) = (/ &
 & 0.88500E-01_JPRB,0.77445E-01_JPRB,0.66378E-01_JPRB,0.55317E-01_JPRB,0.44252E-01_JPRB, &
 & 0.33190E-01_JPRB,0.22890E-01_JPRB,0.20471E-01_JPRB,0.32236E-01_JPRB /)  
KA(:, 1, 9,16) = (/ &
 & 0.10878E+00_JPRB,0.95186E-01_JPRB,0.81587E-01_JPRB,0.67986E-01_JPRB,0.54386E-01_JPRB, &
 & 0.40792E-01_JPRB,0.29314E-01_JPRB,0.26669E-01_JPRB,0.42265E-01_JPRB /)  
KA(:, 2, 9,16) = (/ &
 & 0.10631E+00_JPRB,0.93021E-01_JPRB,0.79732E-01_JPRB,0.66444E-01_JPRB,0.53150E-01_JPRB, &
 & 0.39864E-01_JPRB,0.28508E-01_JPRB,0.25873E-01_JPRB,0.40792E-01_JPRB /)  
KA(:, 3, 9,16) = (/ &
 & 0.10400E+00_JPRB,0.91002E-01_JPRB,0.78003E-01_JPRB,0.64997E-01_JPRB,0.51997E-01_JPRB, &
 & 0.39001E-01_JPRB,0.27707E-01_JPRB,0.25186E-01_JPRB,0.39383E-01_JPRB /)  
KA(:, 4, 9,16) = (/ &
 & 0.10173E+00_JPRB,0.89018E-01_JPRB,0.76292E-01_JPRB,0.63582E-01_JPRB,0.50863E-01_JPRB, &
 & 0.38144E-01_JPRB,0.26926E-01_JPRB,0.24532E-01_JPRB,0.38084E-01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART11',1,ZHOOK_HANDLE)
END SUBROUTINE PART11


SUBROUTINE PART12

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART12',0,ZHOOK_HANDLE)


KA(:, 5, 9,16) = (/ &
 & 0.99555E-01_JPRB,0.87113E-01_JPRB,0.74666E-01_JPRB,0.62221E-01_JPRB,0.49774E-01_JPRB, &
 & 0.37334E-01_JPRB,0.26211E-01_JPRB,0.23902E-01_JPRB,0.36825E-01_JPRB /)  
KA(:, 1,10,16) = (/ &
 & 0.12320E+00_JPRB,0.10779E+00_JPRB,0.92400E-01_JPRB,0.76993E-01_JPRB,0.61601E-01_JPRB, &
 & 0.46197E-01_JPRB,0.33879E-01_JPRB,0.31475E-01_JPRB,0.48792E-01_JPRB /)  
KA(:, 2,10,16) = (/ &
 & 0.11986E+00_JPRB,0.10487E+00_JPRB,0.89890E-01_JPRB,0.74910E-01_JPRB,0.59927E-01_JPRB, &
 & 0.44946E-01_JPRB,0.32786E-01_JPRB,0.30373E-01_JPRB,0.46838E-01_JPRB /)  
KA(:, 3,10,16) = (/ &
 & 0.11671E+00_JPRB,0.10212E+00_JPRB,0.87531E-01_JPRB,0.72938E-01_JPRB,0.58350E-01_JPRB, &
 & 0.43767E-01_JPRB,0.31728E-01_JPRB,0.29415E-01_JPRB,0.45011E-01_JPRB /)  
KA(:, 4,10,16) = (/ &
 & 0.11373E+00_JPRB,0.99514E-01_JPRB,0.85291E-01_JPRB,0.71084E-01_JPRB,0.56859E-01_JPRB, &
 & 0.42648E-01_JPRB,0.30712E-01_JPRB,0.28518E-01_JPRB,0.43306E-01_JPRB /)  
KA(:, 5,10,16) = (/ &
 & 0.11086E+00_JPRB,0.97005E-01_JPRB,0.83130E-01_JPRB,0.69287E-01_JPRB,0.55428E-01_JPRB, &
 & 0.41573E-01_JPRB,0.29748E-01_JPRB,0.27669E-01_JPRB,0.41673E-01_JPRB /)  
KA(:, 1,11,16) = (/ &
 & 0.13635E+00_JPRB,0.11930E+00_JPRB,0.10226E+00_JPRB,0.85213E-01_JPRB,0.68170E-01_JPRB, &
 & 0.51126E-01_JPRB,0.38257E-01_JPRB,0.36212E-01_JPRB,0.54706E-01_JPRB /)  
KA(:, 2,11,16) = (/ &
 & 0.13203E+00_JPRB,0.11554E+00_JPRB,0.99030E-01_JPRB,0.82523E-01_JPRB,0.66019E-01_JPRB, &
 & 0.49513E-01_JPRB,0.36799E-01_JPRB,0.34833E-01_JPRB,0.52312E-01_JPRB /)  
KA(:, 3,11,16) = (/ &
 & 0.12805E+00_JPRB,0.11203E+00_JPRB,0.96022E-01_JPRB,0.80023E-01_JPRB,0.64019E-01_JPRB, &
 & 0.48015E-01_JPRB,0.35435E-01_JPRB,0.33591E-01_JPRB,0.50057E-01_JPRB /)  
KA(:, 4,11,16) = (/ &
 & 0.12432E+00_JPRB,0.10877E+00_JPRB,0.93237E-01_JPRB,0.77695E-01_JPRB,0.62158E-01_JPRB, &
 & 0.46618E-01_JPRB,0.34181E-01_JPRB,0.32427E-01_JPRB,0.47918E-01_JPRB /)  
KA(:, 5,11,16) = (/ &
 & 0.12077E+00_JPRB,0.10567E+00_JPRB,0.90572E-01_JPRB,0.75471E-01_JPRB,0.60381E-01_JPRB, &
 & 0.45284E-01_JPRB,0.32973E-01_JPRB,0.31331E-01_JPRB,0.45895E-01_JPRB /)  
KA(:, 1,12,16) = (/ &
 & 0.14909E+00_JPRB,0.13045E+00_JPRB,0.11182E+00_JPRB,0.93176E-01_JPRB,0.74537E-01_JPRB, &
 & 0.55927E-01_JPRB,0.42736E-01_JPRB,0.41194E-01_JPRB,0.43864E-01_JPRB /)  
KA(:, 2,12,16) = (/ &
 & 0.14380E+00_JPRB,0.12582E+00_JPRB,0.10785E+00_JPRB,0.89883E-01_JPRB,0.71900E-01_JPRB, &
 & 0.53925E-01_JPRB,0.40874E-01_JPRB,0.39509E-01_JPRB,0.34410E-01_JPRB /)  
KA(:, 3,12,16) = (/ &
 & 0.13887E+00_JPRB,0.12152E+00_JPRB,0.10414E+00_JPRB,0.86796E-01_JPRB,0.69431E-01_JPRB, &
 & 0.52073E-01_JPRB,0.39165E-01_JPRB,0.37950E-01_JPRB,0.27228E-01_JPRB /)  
KA(:, 4,12,16) = (/ &
 & 0.13436E+00_JPRB,0.11758E+00_JPRB,0.10078E+00_JPRB,0.83978E-01_JPRB,0.67186E-01_JPRB, &
 & 0.50383E-01_JPRB,0.37599E-01_JPRB,0.36473E-01_JPRB,0.23165E-01_JPRB /)  
KA(:, 5,12,16) = (/ &
 & 0.13007E+00_JPRB,0.11382E+00_JPRB,0.97560E-01_JPRB,0.81293E-01_JPRB,0.65042E-01_JPRB, &
 & 0.48775E-01_JPRB,0.36131E-01_JPRB,0.35083E-01_JPRB,0.14412E-01_JPRB /)  
KA(:, 1,13,16) = (/ &
 & 0.16113E+00_JPRB,0.14100E+00_JPRB,0.12085E+00_JPRB,0.10071E+00_JPRB,0.80563E-01_JPRB, &
 & 0.60580E-01_JPRB,0.47246E-01_JPRB,0.46365E-01_JPRB,0.26456E-01_JPRB /)  
KA(:, 2,13,16) = (/ &
 & 0.15486E+00_JPRB,0.13550E+00_JPRB,0.11616E+00_JPRB,0.96791E-01_JPRB,0.77431E-01_JPRB, &
 & 0.58082E-01_JPRB,0.44915E-01_JPRB,0.44314E-01_JPRB,0.19340E-01_JPRB /)  
KA(:, 3,13,16) = (/ &
 & 0.14906E+00_JPRB,0.13042E+00_JPRB,0.11179E+00_JPRB,0.93156E-01_JPRB,0.74526E-01_JPRB, &
 & 0.55893E-01_JPRB,0.42831E-01_JPRB,0.42380E-01_JPRB,0.11993E-01_JPRB /)  
KA(:, 4,13,16) = (/ &
 & 0.14369E+00_JPRB,0.12574E+00_JPRB,0.10777E+00_JPRB,0.89817E-01_JPRB,0.71849E-01_JPRB, &
 & 0.53884E-01_JPRB,0.40915E-01_JPRB,0.40556E-01_JPRB,0.50486E-02_JPRB /)  
KA(:, 5,13,16) = (/ &
 & 0.13868E+00_JPRB,0.12134E+00_JPRB,0.10400E+00_JPRB,0.86669E-01_JPRB,0.69338E-01_JPRB, &
 & 0.52006E-01_JPRB,0.39136E-01_JPRB,0.38851E-01_JPRB,0.00000E+00_JPRB /)  
  
!     -----------------------------------------------------------------
!     The array KB contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KB(:,13, 1) = (/ &
 & 0.12158E-08_JPRB,0.13238E-08_JPRB,0.15146E-08_JPRB,0.16862E-08_JPRB,0.18609E-08_JPRB /)  
KB(:,14, 1) = (/ &
 & 0.16931E-08_JPRB,0.20047E-08_JPRB,0.23006E-08_JPRB,0.25636E-08_JPRB,0.28912E-08_JPRB /)  
KB(:,15, 1) = (/ &
 & 0.31521E-08_JPRB,0.36963E-08_JPRB,0.41550E-08_JPRB,0.46365E-08_JPRB,0.50834E-08_JPRB /)  
KB(:,16, 1) = (/ &
 & 0.46152E-08_JPRB,0.50173E-08_JPRB,0.55381E-08_JPRB,0.60748E-08_JPRB,0.66355E-08_JPRB /)  
KB(:,17, 1) = (/ &
 & 0.62662E-08_JPRB,0.67518E-08_JPRB,0.71765E-08_JPRB,0.80302E-08_JPRB,0.89056E-08_JPRB /)  
KB(:,18, 1) = (/ &
 & 0.81764E-08_JPRB,0.91818E-08_JPRB,0.10385E-07_JPRB,0.11708E-07_JPRB,0.12536E-07_JPRB /)  
KB(:,19, 1) = (/ &
 & 0.12946E-07_JPRB,0.13631E-07_JPRB,0.14453E-07_JPRB,0.15133E-07_JPRB,0.15911E-07_JPRB /)  
KB(:,20, 1) = (/ &
 & 0.15868E-07_JPRB,0.16654E-07_JPRB,0.17281E-07_JPRB,0.17857E-07_JPRB,0.18383E-07_JPRB /)  
KB(:,21, 1) = (/ &
 & 0.18151E-07_JPRB,0.19056E-07_JPRB,0.20057E-07_JPRB,0.20708E-07_JPRB,0.21229E-07_JPRB /)  
KB(:,22, 1) = (/ &
 & 0.20234E-07_JPRB,0.21482E-07_JPRB,0.22599E-07_JPRB,0.23778E-07_JPRB,0.25115E-07_JPRB /)  
KB(:,23, 1) = (/ &
 & 0.23827E-07_JPRB,0.25405E-07_JPRB,0.26545E-07_JPRB,0.27716E-07_JPRB,0.28422E-07_JPRB /)  
KB(:,24, 1) = (/ &
 & 0.27638E-07_JPRB,0.28518E-07_JPRB,0.29101E-07_JPRB,0.29639E-07_JPRB,0.30077E-07_JPRB /)  
KB(:,25, 1) = (/ &
 & 0.28942E-07_JPRB,0.29436E-07_JPRB,0.29831E-07_JPRB,0.30066E-07_JPRB,0.30242E-07_JPRB /)  
KB(:,26, 1) = (/ &
 & 0.28774E-07_JPRB,0.29004E-07_JPRB,0.29272E-07_JPRB,0.29431E-07_JPRB,0.29616E-07_JPRB /)  
KB(:,27, 1) = (/ &
 & 0.27317E-07_JPRB,0.27462E-07_JPRB,0.27698E-07_JPRB,0.27835E-07_JPRB,0.27843E-07_JPRB /)  
KB(:,28, 1) = (/ &
 & 0.25463E-07_JPRB,0.25523E-07_JPRB,0.25678E-07_JPRB,0.25658E-07_JPRB,0.25687E-07_JPRB /)  
KB(:,29, 1) = (/ &
 & 0.22603E-07_JPRB,0.22672E-07_JPRB,0.22704E-07_JPRB,0.22668E-07_JPRB,0.22698E-07_JPRB /)  
KB(:,30, 1) = (/ &
 & 0.19657E-07_JPRB,0.19747E-07_JPRB,0.19687E-07_JPRB,0.19659E-07_JPRB,0.19680E-07_JPRB /)  
KB(:,31, 1) = (/ &
 & 0.16553E-07_JPRB,0.16571E-07_JPRB,0.16522E-07_JPRB,0.16545E-07_JPRB,0.16563E-07_JPRB /)  
KB(:,32, 1) = (/ &
 & 0.13867E-07_JPRB,0.13795E-07_JPRB,0.13808E-07_JPRB,0.13815E-07_JPRB,0.13799E-07_JPRB /)  
KB(:,33, 1) = (/ &
 & 0.11414E-07_JPRB,0.11409E-07_JPRB,0.11395E-07_JPRB,0.11384E-07_JPRB,0.11416E-07_JPRB /)  
KB(:,34, 1) = (/ &
 & 0.95639E-08_JPRB,0.95514E-08_JPRB,0.95251E-08_JPRB,0.95607E-08_JPRB,0.95767E-08_JPRB /)  
KB(:,35, 1) = (/ &
 & 0.80018E-08_JPRB,0.79882E-08_JPRB,0.79720E-08_JPRB,0.79934E-08_JPRB,0.79942E-08_JPRB /)  
KB(:,36, 1) = (/ &
 & 0.67279E-08_JPRB,0.67135E-08_JPRB,0.67089E-08_JPRB,0.67131E-08_JPRB,0.67290E-08_JPRB /)  
KB(:,37, 1) = (/ &
 & 0.57292E-08_JPRB,0.57278E-08_JPRB,0.57247E-08_JPRB,0.57298E-08_JPRB,0.57269E-08_JPRB /)  
KB(:,38, 1) = (/ &
 & 0.48406E-08_JPRB,0.48461E-08_JPRB,0.48394E-08_JPRB,0.48468E-08_JPRB,0.48401E-08_JPRB /)  
KB(:,39, 1) = (/ &
 & 0.40368E-08_JPRB,0.40419E-08_JPRB,0.40353E-08_JPRB,0.40432E-08_JPRB,0.40267E-08_JPRB /)  
KB(:,40, 1) = (/ &
 & 0.34875E-08_JPRB,0.34931E-08_JPRB,0.34872E-08_JPRB,0.34940E-08_JPRB,0.34782E-08_JPRB /)  
KB(:,41, 1) = (/ &
 & 0.30195E-08_JPRB,0.30243E-08_JPRB,0.30129E-08_JPRB,0.30148E-08_JPRB,0.30016E-08_JPRB /)  
KB(:,42, 1) = (/ &
 & 0.25993E-08_JPRB,0.25924E-08_JPRB,0.25861E-08_JPRB,0.25841E-08_JPRB,0.25734E-08_JPRB /)  
KB(:,43, 1) = (/ &
 & 0.22290E-08_JPRB,0.22166E-08_JPRB,0.22080E-08_JPRB,0.22067E-08_JPRB,0.21992E-08_JPRB /)  
KB(:,44, 1) = (/ &
 & 0.18916E-08_JPRB,0.18847E-08_JPRB,0.18733E-08_JPRB,0.18685E-08_JPRB,0.18685E-08_JPRB /)  
KB(:,45, 1) = (/ &
 & 0.15840E-08_JPRB,0.15787E-08_JPRB,0.15719E-08_JPRB,0.15641E-08_JPRB,0.15644E-08_JPRB /)  
KB(:,46, 1) = (/ &
 & 0.13197E-08_JPRB,0.13138E-08_JPRB,0.13098E-08_JPRB,0.13024E-08_JPRB,0.13049E-08_JPRB /)  
KB(:,47, 1) = (/ &
 & 0.11052E-08_JPRB,0.11003E-08_JPRB,0.10954E-08_JPRB,0.10927E-08_JPRB,0.10941E-08_JPRB /)  
KB(:,48, 1) = (/ &
 & 0.91115E-09_JPRB,0.90837E-09_JPRB,0.90520E-09_JPRB,0.90009E-09_JPRB,0.90047E-09_JPRB /)  
KB(:,49, 1) = (/ &
 & 0.73101E-09_JPRB,0.73246E-09_JPRB,0.73006E-09_JPRB,0.72687E-09_JPRB,0.72508E-09_JPRB /)  
KB(:,50, 1) = (/ &
 & 0.60565E-09_JPRB,0.60526E-09_JPRB,0.60121E-09_JPRB,0.60117E-09_JPRB,0.60056E-09_JPRB /)  
KB(:,51, 1) = (/ &
 & 0.50736E-09_JPRB,0.50750E-09_JPRB,0.50421E-09_JPRB,0.50378E-09_JPRB,0.50259E-09_JPRB /)  
KB(:,52, 1) = (/ &
 & 0.41843E-09_JPRB,0.41856E-09_JPRB,0.41499E-09_JPRB,0.41535E-09_JPRB,0.41353E-09_JPRB /)  
KB(:,53, 1) = (/ &
 & 0.33766E-09_JPRB,0.33794E-09_JPRB,0.33511E-09_JPRB,0.33405E-09_JPRB,0.33405E-09_JPRB /)  
KB(:,54, 1) = (/ &
 & 0.29473E-09_JPRB,0.29448E-09_JPRB,0.29284E-09_JPRB,0.29146E-09_JPRB,0.29053E-09_JPRB /)  
KB(:,55, 1) = (/ &
 & 0.26948E-09_JPRB,0.27034E-09_JPRB,0.27016E-09_JPRB,0.26799E-09_JPRB,0.26580E-09_JPRB /)  
KB(:,56, 1) = (/ &
 & 0.24773E-09_JPRB,0.24784E-09_JPRB,0.24734E-09_JPRB,0.24436E-09_JPRB,0.24377E-09_JPRB /)  
KB(:,57, 1) = (/ &
 & 0.22707E-09_JPRB,0.22765E-09_JPRB,0.22683E-09_JPRB,0.22503E-09_JPRB,0.22447E-09_JPRB /)  
KB(:,58, 1) = (/ &
 & 0.21180E-09_JPRB,0.21264E-09_JPRB,0.21254E-09_JPRB,0.21338E-09_JPRB,0.21089E-09_JPRB /)  
KB(:,59, 1) = (/ &
 & 0.22898E-09_JPRB,0.23089E-09_JPRB,0.23471E-09_JPRB,0.23606E-09_JPRB,0.23388E-09_JPRB /)  
KB(:,13, 2) = (/ &
 & 0.18001E-08_JPRB,0.19945E-08_JPRB,0.21612E-08_JPRB,0.23316E-08_JPRB,0.25983E-08_JPRB /)  
KB(:,14, 2) = (/ &
 & 0.39853E-08_JPRB,0.42632E-08_JPRB,0.44602E-08_JPRB,0.46784E-08_JPRB,0.48071E-08_JPRB /)  
KB(:,15, 2) = (/ &
 & 0.60848E-08_JPRB,0.61494E-08_JPRB,0.61069E-08_JPRB,0.61295E-08_JPRB,0.65707E-08_JPRB /)  
KB(:,16, 2) = (/ &
 & 0.75494E-08_JPRB,0.85999E-08_JPRB,0.91057E-08_JPRB,0.10175E-07_JPRB,0.10943E-07_JPRB /)  
KB(:,17, 2) = (/ &
 & 0.12037E-07_JPRB,0.12753E-07_JPRB,0.13314E-07_JPRB,0.13239E-07_JPRB,0.13306E-07_JPRB /)  
KB(:,18, 2) = (/ &
 & 0.15519E-07_JPRB,0.15517E-07_JPRB,0.15097E-07_JPRB,0.14435E-07_JPRB,0.13983E-07_JPRB /)  
KB(:,19, 2) = (/ &
 & 0.16420E-07_JPRB,0.17025E-07_JPRB,0.17639E-07_JPRB,0.17633E-07_JPRB,0.17513E-07_JPRB /)  
KB(:,20, 2) = (/ &
 & 0.18021E-07_JPRB,0.19301E-07_JPRB,0.20621E-07_JPRB,0.22238E-07_JPRB,0.23351E-07_JPRB /)  
KB(:,21, 2) = (/ &
 & 0.22378E-07_JPRB,0.23582E-07_JPRB,0.24409E-07_JPRB,0.24915E-07_JPRB,0.25516E-07_JPRB /)  
KB(:,22, 2) = (/ &
 & 0.24712E-07_JPRB,0.24864E-07_JPRB,0.24556E-07_JPRB,0.23953E-07_JPRB,0.23424E-07_JPRB /)  
KB(:,23, 2) = (/ &
 & 0.22545E-07_JPRB,0.22002E-07_JPRB,0.21325E-07_JPRB,0.20492E-07_JPRB,0.20022E-07_JPRB /)  
KB(:,24, 2) = (/ &
 & 0.18798E-07_JPRB,0.18566E-07_JPRB,0.18366E-07_JPRB,0.18099E-07_JPRB,0.17971E-07_JPRB /)  
KB(:,25, 2) = (/ &
 & 0.16773E-07_JPRB,0.16803E-07_JPRB,0.16541E-07_JPRB,0.16450E-07_JPRB,0.16482E-07_JPRB /)  
KB(:,26, 2) = (/ &
 & 0.15222E-07_JPRB,0.15398E-07_JPRB,0.15177E-07_JPRB,0.15147E-07_JPRB,0.14951E-07_JPRB /)  
KB(:,27, 2) = (/ &
 & 0.13792E-07_JPRB,0.13944E-07_JPRB,0.13534E-07_JPRB,0.13546E-07_JPRB,0.13516E-07_JPRB /)  
KB(:,28, 2) = (/ &
 & 0.12157E-07_JPRB,0.12221E-07_JPRB,0.11930E-07_JPRB,0.12115E-07_JPRB,0.12027E-07_JPRB /)  
KB(:,29, 2) = (/ &
 & 0.10487E-07_JPRB,0.10393E-07_JPRB,0.10366E-07_JPRB,0.10455E-07_JPRB,0.10269E-07_JPRB /)  
KB(:,30, 2) = (/ &
 & 0.90084E-08_JPRB,0.88590E-08_JPRB,0.90055E-08_JPRB,0.88655E-08_JPRB,0.87392E-08_JPRB /)  
KB(:,31, 2) = (/ &
 & 0.74765E-08_JPRB,0.74889E-08_JPRB,0.73915E-08_JPRB,0.73289E-08_JPRB,0.72219E-08_JPRB /)  
KB(:,32, 2) = (/ &
 & 0.62311E-08_JPRB,0.62461E-08_JPRB,0.61378E-08_JPRB,0.59795E-08_JPRB,0.60309E-08_JPRB /)  
KB(:,33, 2) = (/ &
 & 0.51421E-08_JPRB,0.50519E-08_JPRB,0.50031E-08_JPRB,0.49630E-08_JPRB,0.49489E-08_JPRB /)  
KB(:,34, 2) = (/ &
 & 0.42880E-08_JPRB,0.42042E-08_JPRB,0.41366E-08_JPRB,0.41198E-08_JPRB,0.41265E-08_JPRB /)  
KB(:,35, 2) = (/ &
 & 0.35718E-08_JPRB,0.34728E-08_JPRB,0.34599E-08_JPRB,0.34385E-08_JPRB,0.34695E-08_JPRB /)  
KB(:,36, 2) = (/ &
 & 0.29713E-08_JPRB,0.29023E-08_JPRB,0.28707E-08_JPRB,0.28790E-08_JPRB,0.28873E-08_JPRB /)  
KB(:,37, 2) = (/ &
 & 0.25246E-08_JPRB,0.24463E-08_JPRB,0.24323E-08_JPRB,0.24308E-08_JPRB,0.24753E-08_JPRB /)  
KB(:,38, 2) = (/ &
 & 0.21159E-08_JPRB,0.20527E-08_JPRB,0.20532E-08_JPRB,0.20325E-08_JPRB,0.20615E-08_JPRB /)  
KB(:,39, 2) = (/ &
 & 0.17631E-08_JPRB,0.17097E-08_JPRB,0.17043E-08_JPRB,0.16987E-08_JPRB,0.17298E-08_JPRB /)  
KB(:,40, 2) = (/ &
 & 0.15260E-08_JPRB,0.14757E-08_JPRB,0.14566E-08_JPRB,0.14513E-08_JPRB,0.14651E-08_JPRB /)  
KB(:,41, 2) = (/ &
 & 0.13009E-08_JPRB,0.12457E-08_JPRB,0.12523E-08_JPRB,0.12490E-08_JPRB,0.12671E-08_JPRB /)  
KB(:,42, 2) = (/ &
 & 0.10990E-08_JPRB,0.10789E-08_JPRB,0.10741E-08_JPRB,0.10762E-08_JPRB,0.10873E-08_JPRB /)  
KB(:,43, 2) = (/ &
 & 0.94313E-09_JPRB,0.92236E-09_JPRB,0.92369E-09_JPRB,0.91495E-09_JPRB,0.92405E-09_JPRB /)  
KB(:,44, 2) = (/ &
 & 0.80746E-09_JPRB,0.78453E-09_JPRB,0.77646E-09_JPRB,0.77477E-09_JPRB,0.77888E-09_JPRB /)  
KB(:,45, 2) = (/ &
 & 0.67944E-09_JPRB,0.66381E-09_JPRB,0.65747E-09_JPRB,0.65286E-09_JPRB,0.65668E-09_JPRB /)  
KB(:,46, 2) = (/ &
 & 0.56677E-09_JPRB,0.55682E-09_JPRB,0.54825E-09_JPRB,0.54623E-09_JPRB,0.54843E-09_JPRB /)  
KB(:,47, 2) = (/ &
 & 0.47375E-09_JPRB,0.47120E-09_JPRB,0.45836E-09_JPRB,0.45709E-09_JPRB,0.45689E-09_JPRB /)  
KB(:,48, 2) = (/ &
 & 0.39797E-09_JPRB,0.39204E-09_JPRB,0.37735E-09_JPRB,0.37505E-09_JPRB,0.37687E-09_JPRB /)  
KB(:,49, 2) = (/ &
 & 0.32772E-09_JPRB,0.31857E-09_JPRB,0.30808E-09_JPRB,0.30232E-09_JPRB,0.30140E-09_JPRB /)  
KB(:,50, 2) = (/ &
 & 0.27300E-09_JPRB,0.26581E-09_JPRB,0.26125E-09_JPRB,0.24922E-09_JPRB,0.25029E-09_JPRB /)  
KB(:,51, 2) = (/ &
 & 0.23073E-09_JPRB,0.22159E-09_JPRB,0.21979E-09_JPRB,0.20969E-09_JPRB,0.21117E-09_JPRB /)  
KB(:,52, 2) = (/ &
 & 0.18868E-09_JPRB,0.18466E-09_JPRB,0.18517E-09_JPRB,0.17470E-09_JPRB,0.17469E-09_JPRB /)  
KB(:,53, 2) = (/ &
 & 0.15290E-09_JPRB,0.14970E-09_JPRB,0.15032E-09_JPRB,0.14201E-09_JPRB,0.14053E-09_JPRB /)  
KB(:,54, 2) = (/ &
 & 0.13616E-09_JPRB,0.13340E-09_JPRB,0.13256E-09_JPRB,0.12713E-09_JPRB,0.12621E-09_JPRB /)  
KB(:,55, 2) = (/ &
 & 0.12605E-09_JPRB,0.12524E-09_JPRB,0.12106E-09_JPRB,0.11994E-09_JPRB,0.11735E-09_JPRB /)  
KB(:,56, 2) = (/ &
 & 0.11625E-09_JPRB,0.11350E-09_JPRB,0.11287E-09_JPRB,0.11534E-09_JPRB,0.10942E-09_JPRB /)  
KB(:,57, 2) = (/ &
 & 0.10168E-09_JPRB,0.10628E-09_JPRB,0.10684E-09_JPRB,0.10799E-09_JPRB,0.10313E-09_JPRB /)  
KB(:,58, 2) = (/ &
 & 0.92659E-10_JPRB,0.10050E-09_JPRB,0.10168E-09_JPRB,0.97877E-10_JPRB,0.97971E-10_JPRB /)  
KB(:,59, 2) = (/ &
 & 0.10198E-09_JPRB,0.11632E-09_JPRB,0.11127E-09_JPRB,0.10947E-09_JPRB,0.11000E-09_JPRB /)  
KB(:,13, 3) = (/ &
 & 0.33788E-08_JPRB,0.38685E-08_JPRB,0.40059E-08_JPRB,0.41301E-08_JPRB,0.43316E-08_JPRB /)  
KB(:,14, 3) = (/ &
 & 0.54022E-08_JPRB,0.55644E-08_JPRB,0.55814E-08_JPRB,0.55195E-08_JPRB,0.57708E-08_JPRB /)  
KB(:,15, 3) = (/ &
 & 0.95769E-08_JPRB,0.10205E-07_JPRB,0.12445E-07_JPRB,0.13419E-07_JPRB,0.13357E-07_JPRB /)  
KB(:,16, 3) = (/ &
 & 0.17233E-07_JPRB,0.16177E-07_JPRB,0.16092E-07_JPRB,0.15590E-07_JPRB,0.15068E-07_JPRB /)  
KB(:,17, 3) = (/ &
 & 0.19731E-07_JPRB,0.19947E-07_JPRB,0.20278E-07_JPRB,0.20235E-07_JPRB,0.20699E-07_JPRB /)  
KB(:,18, 3) = (/ &
 & 0.23168E-07_JPRB,0.23970E-07_JPRB,0.25507E-07_JPRB,0.27034E-07_JPRB,0.29135E-07_JPRB /)  
KB(:,19, 3) = (/ &
 & 0.33749E-07_JPRB,0.35374E-07_JPRB,0.37333E-07_JPRB,0.38730E-07_JPRB,0.39816E-07_JPRB /)  
KB(:,20, 3) = (/ &
 & 0.39844E-07_JPRB,0.39698E-07_JPRB,0.39651E-07_JPRB,0.38618E-07_JPRB,0.37699E-07_JPRB /)  
KB(:,21, 3) = (/ &
 & 0.37013E-07_JPRB,0.35923E-07_JPRB,0.35560E-07_JPRB,0.35217E-07_JPRB,0.34594E-07_JPRB /)  
KB(:,22, 3) = (/ &
 & 0.32381E-07_JPRB,0.31844E-07_JPRB,0.32272E-07_JPRB,0.32430E-07_JPRB,0.31922E-07_JPRB /)  
KB(:,23, 3) = (/ &
 & 0.29924E-07_JPRB,0.29834E-07_JPRB,0.30537E-07_JPRB,0.30494E-07_JPRB,0.30313E-07_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART12',1,ZHOOK_HANDLE)
END SUBROUTINE PART12


SUBROUTINE PART13

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART13',0,ZHOOK_HANDLE)


KB(:,24, 3) = (/ &
 & 0.27849E-07_JPRB,0.28147E-07_JPRB,0.29005E-07_JPRB,0.29081E-07_JPRB,0.28673E-07_JPRB /)  
KB(:,25, 3) = (/ &
 & 0.25534E-07_JPRB,0.25854E-07_JPRB,0.26978E-07_JPRB,0.27173E-07_JPRB,0.27116E-07_JPRB /)  
KB(:,26, 3) = (/ &
 & 0.23413E-07_JPRB,0.24124E-07_JPRB,0.25341E-07_JPRB,0.25322E-07_JPRB,0.25266E-07_JPRB /)  
KB(:,27, 3) = (/ &
 & 0.21218E-07_JPRB,0.22105E-07_JPRB,0.23470E-07_JPRB,0.23280E-07_JPRB,0.23250E-07_JPRB /)  
KB(:,28, 3) = (/ &
 & 0.19002E-07_JPRB,0.20309E-07_JPRB,0.21106E-07_JPRB,0.20908E-07_JPRB,0.21199E-07_JPRB /)  
KB(:,29, 3) = (/ &
 & 0.16901E-07_JPRB,0.18244E-07_JPRB,0.18426E-07_JPRB,0.18398E-07_JPRB,0.18708E-07_JPRB /)  
KB(:,30, 3) = (/ &
 & 0.15065E-07_JPRB,0.15814E-07_JPRB,0.15711E-07_JPRB,0.16012E-07_JPRB,0.16145E-07_JPRB /)  
KB(:,31, 3) = (/ &
 & 0.13100E-07_JPRB,0.13194E-07_JPRB,0.13385E-07_JPRB,0.13455E-07_JPRB,0.13435E-07_JPRB /)  
KB(:,32, 3) = (/ &
 & 0.10972E-07_JPRB,0.10986E-07_JPRB,0.11085E-07_JPRB,0.11182E-07_JPRB,0.11030E-07_JPRB /)  
KB(:,33, 3) = (/ &
 & 0.90750E-08_JPRB,0.90832E-08_JPRB,0.91769E-08_JPRB,0.89877E-08_JPRB,0.89513E-08_JPRB /)  
KB(:,34, 3) = (/ &
 & 0.75008E-08_JPRB,0.76569E-08_JPRB,0.76237E-08_JPRB,0.74547E-08_JPRB,0.74719E-08_JPRB /)  
KB(:,35, 3) = (/ &
 & 0.63063E-08_JPRB,0.64050E-08_JPRB,0.62067E-08_JPRB,0.61836E-08_JPRB,0.61775E-08_JPRB /)  
KB(:,36, 3) = (/ &
 & 0.53250E-08_JPRB,0.52712E-08_JPRB,0.52454E-08_JPRB,0.51153E-08_JPRB,0.51657E-08_JPRB /)  
KB(:,37, 3) = (/ &
 & 0.45450E-08_JPRB,0.45358E-08_JPRB,0.44274E-08_JPRB,0.43893E-08_JPRB,0.43616E-08_JPRB /)  
KB(:,38, 3) = (/ &
 & 0.38039E-08_JPRB,0.38254E-08_JPRB,0.37172E-08_JPRB,0.37203E-08_JPRB,0.37278E-08_JPRB /)  
KB(:,39, 3) = (/ &
 & 0.31821E-08_JPRB,0.31632E-08_JPRB,0.30774E-08_JPRB,0.30626E-08_JPRB,0.30979E-08_JPRB /)  
KB(:,40, 3) = (/ &
 & 0.27339E-08_JPRB,0.27443E-08_JPRB,0.26754E-08_JPRB,0.26505E-08_JPRB,0.27022E-08_JPRB /)  
KB(:,41, 3) = (/ &
 & 0.23939E-08_JPRB,0.24228E-08_JPRB,0.23415E-08_JPRB,0.23287E-08_JPRB,0.23327E-08_JPRB /)  
KB(:,42, 3) = (/ &
 & 0.20895E-08_JPRB,0.20874E-08_JPRB,0.20298E-08_JPRB,0.20180E-08_JPRB,0.19876E-08_JPRB /)  
KB(:,43, 3) = (/ &
 & 0.17869E-08_JPRB,0.17800E-08_JPRB,0.17392E-08_JPRB,0.17376E-08_JPRB,0.16927E-08_JPRB /)  
KB(:,44, 3) = (/ &
 & 0.15169E-08_JPRB,0.15335E-08_JPRB,0.14778E-08_JPRB,0.14668E-08_JPRB,0.14407E-08_JPRB /)  
KB(:,45, 3) = (/ &
 & 0.12692E-08_JPRB,0.12902E-08_JPRB,0.12439E-08_JPRB,0.12324E-08_JPRB,0.11996E-08_JPRB /)  
KB(:,46, 3) = (/ &
 & 0.10611E-08_JPRB,0.10656E-08_JPRB,0.10472E-08_JPRB,0.10282E-08_JPRB,0.10015E-08_JPRB /)  
KB(:,47, 3) = (/ &
 & 0.90394E-09_JPRB,0.88143E-09_JPRB,0.87958E-09_JPRB,0.84984E-09_JPRB,0.85121E-09_JPRB /)  
KB(:,48, 3) = (/ &
 & 0.73451E-09_JPRB,0.71978E-09_JPRB,0.73014E-09_JPRB,0.70436E-09_JPRB,0.69840E-09_JPRB /)  
KB(:,49, 3) = (/ &
 & 0.58678E-09_JPRB,0.58259E-09_JPRB,0.58316E-09_JPRB,0.55960E-09_JPRB,0.56079E-09_JPRB /)  
KB(:,50, 3) = (/ &
 & 0.48502E-09_JPRB,0.47984E-09_JPRB,0.48693E-09_JPRB,0.47265E-09_JPRB,0.46016E-09_JPRB /)  
KB(:,51, 3) = (/ &
 & 0.40704E-09_JPRB,0.40367E-09_JPRB,0.41046E-09_JPRB,0.39764E-09_JPRB,0.38714E-09_JPRB /)  
KB(:,52, 3) = (/ &
 & 0.33771E-09_JPRB,0.33070E-09_JPRB,0.32984E-09_JPRB,0.33231E-09_JPRB,0.32299E-09_JPRB /)  
KB(:,53, 3) = (/ &
 & 0.27062E-09_JPRB,0.27028E-09_JPRB,0.26516E-09_JPRB,0.26816E-09_JPRB,0.25661E-09_JPRB /)  
KB(:,54, 3) = (/ &
 & 0.23501E-09_JPRB,0.23579E-09_JPRB,0.23460E-09_JPRB,0.23532E-09_JPRB,0.22777E-09_JPRB /)  
KB(:,55, 3) = (/ &
 & 0.20561E-09_JPRB,0.21843E-09_JPRB,0.22171E-09_JPRB,0.22358E-09_JPRB,0.21702E-09_JPRB /)  
KB(:,56, 3) = (/ &
 & 0.18557E-09_JPRB,0.20864E-09_JPRB,0.21196E-09_JPRB,0.20646E-09_JPRB,0.20759E-09_JPRB /)  
KB(:,57, 3) = (/ &
 & 0.17099E-09_JPRB,0.19489E-09_JPRB,0.19486E-09_JPRB,0.19102E-09_JPRB,0.19124E-09_JPRB /)  
KB(:,58, 3) = (/ &
 & 0.16535E-09_JPRB,0.16955E-09_JPRB,0.18769E-09_JPRB,0.18586E-09_JPRB,0.18358E-09_JPRB /)  
KB(:,59, 3) = (/ &
 & 0.18472E-09_JPRB,0.17614E-09_JPRB,0.20835E-09_JPRB,0.19900E-09_JPRB,0.17587E-09_JPRB /)  
KB(:,13, 4) = (/ &
 & 0.14276E-07_JPRB,0.14530E-07_JPRB,0.14762E-07_JPRB,0.14823E-07_JPRB,0.15070E-07_JPRB /)  
KB(:,14, 4) = (/ &
 & 0.22710E-07_JPRB,0.23419E-07_JPRB,0.26577E-07_JPRB,0.28008E-07_JPRB,0.28298E-07_JPRB /)  
KB(:,15, 4) = (/ &
 & 0.40218E-07_JPRB,0.40306E-07_JPRB,0.38786E-07_JPRB,0.38421E-07_JPRB,0.37982E-07_JPRB /)  
KB(:,16, 4) = (/ &
 & 0.46010E-07_JPRB,0.46709E-07_JPRB,0.48658E-07_JPRB,0.49166E-07_JPRB,0.49018E-07_JPRB /)  
KB(:,17, 4) = (/ &
 & 0.57896E-07_JPRB,0.59606E-07_JPRB,0.62582E-07_JPRB,0.65981E-07_JPRB,0.66467E-07_JPRB /)  
KB(:,18, 4) = (/ &
 & 0.74731E-07_JPRB,0.75116E-07_JPRB,0.75181E-07_JPRB,0.74922E-07_JPRB,0.73535E-07_JPRB /)  
KB(:,19, 4) = (/ &
 & 0.76222E-07_JPRB,0.73788E-07_JPRB,0.71345E-07_JPRB,0.70864E-07_JPRB,0.69839E-07_JPRB /)  
KB(:,20, 4) = (/ &
 & 0.69638E-07_JPRB,0.67680E-07_JPRB,0.66694E-07_JPRB,0.67021E-07_JPRB,0.67066E-07_JPRB /)  
KB(:,21, 4) = (/ &
 & 0.65779E-07_JPRB,0.64200E-07_JPRB,0.63508E-07_JPRB,0.64106E-07_JPRB,0.64461E-07_JPRB /)  
KB(:,22, 4) = (/ &
 & 0.61488E-07_JPRB,0.60248E-07_JPRB,0.59719E-07_JPRB,0.60704E-07_JPRB,0.61392E-07_JPRB /)  
KB(:,23, 4) = (/ &
 & 0.56738E-07_JPRB,0.55143E-07_JPRB,0.55071E-07_JPRB,0.56796E-07_JPRB,0.58031E-07_JPRB /)  
KB(:,24, 4) = (/ &
 & 0.53299E-07_JPRB,0.52091E-07_JPRB,0.52308E-07_JPRB,0.54157E-07_JPRB,0.55094E-07_JPRB /)  
KB(:,25, 4) = (/ &
 & 0.49763E-07_JPRB,0.48954E-07_JPRB,0.49068E-07_JPRB,0.51533E-07_JPRB,0.52367E-07_JPRB /)  
KB(:,26, 4) = (/ &
 & 0.46006E-07_JPRB,0.45410E-07_JPRB,0.45860E-07_JPRB,0.48840E-07_JPRB,0.49788E-07_JPRB /)  
KB(:,27, 4) = (/ &
 & 0.42208E-07_JPRB,0.41876E-07_JPRB,0.43006E-07_JPRB,0.46350E-07_JPRB,0.47032E-07_JPRB /)  
KB(:,28, 4) = (/ &
 & 0.38508E-07_JPRB,0.38430E-07_JPRB,0.40481E-07_JPRB,0.43465E-07_JPRB,0.43170E-07_JPRB /)  
KB(:,29, 4) = (/ &
 & 0.33913E-07_JPRB,0.34466E-07_JPRB,0.37202E-07_JPRB,0.38288E-07_JPRB,0.38327E-07_JPRB /)  
KB(:,30, 4) = (/ &
 & 0.29454E-07_JPRB,0.30842E-07_JPRB,0.33204E-07_JPRB,0.33354E-07_JPRB,0.33727E-07_JPRB /)  
KB(:,31, 4) = (/ &
 & 0.25253E-07_JPRB,0.27183E-07_JPRB,0.28228E-07_JPRB,0.27946E-07_JPRB,0.28495E-07_JPRB /)  
KB(:,32, 4) = (/ &
 & 0.21784E-07_JPRB,0.23351E-07_JPRB,0.23372E-07_JPRB,0.23449E-07_JPRB,0.23246E-07_JPRB /)  
KB(:,33, 4) = (/ &
 & 0.18910E-07_JPRB,0.19134E-07_JPRB,0.18984E-07_JPRB,0.19294E-07_JPRB,0.18955E-07_JPRB /)  
KB(:,34, 4) = (/ &
 & 0.15933E-07_JPRB,0.15755E-07_JPRB,0.16059E-07_JPRB,0.15913E-07_JPRB,0.15386E-07_JPRB /)  
KB(:,35, 4) = (/ &
 & 0.13356E-07_JPRB,0.13247E-07_JPRB,0.13429E-07_JPRB,0.13202E-07_JPRB,0.12675E-07_JPRB /)  
KB(:,36, 4) = (/ &
 & 0.11207E-07_JPRB,0.11196E-07_JPRB,0.11048E-07_JPRB,0.10870E-07_JPRB,0.10431E-07_JPRB /)  
KB(:,37, 4) = (/ &
 & 0.95811E-08_JPRB,0.94647E-08_JPRB,0.93875E-08_JPRB,0.90968E-08_JPRB,0.88553E-08_JPRB /)  
KB(:,38, 4) = (/ &
 & 0.81243E-08_JPRB,0.80255E-08_JPRB,0.78559E-08_JPRB,0.75538E-08_JPRB,0.74057E-08_JPRB /)  
KB(:,39, 4) = (/ &
 & 0.66871E-08_JPRB,0.66553E-08_JPRB,0.65003E-08_JPRB,0.62809E-08_JPRB,0.60862E-08_JPRB /)  
KB(:,40, 4) = (/ &
 & 0.58254E-08_JPRB,0.57657E-08_JPRB,0.56185E-08_JPRB,0.54242E-08_JPRB,0.52135E-08_JPRB /)  
KB(:,41, 4) = (/ &
 & 0.50967E-08_JPRB,0.50027E-08_JPRB,0.48304E-08_JPRB,0.46813E-08_JPRB,0.44864E-08_JPRB /)  
KB(:,42, 4) = (/ &
 & 0.43731E-08_JPRB,0.43157E-08_JPRB,0.41432E-08_JPRB,0.39968E-08_JPRB,0.38854E-08_JPRB /)  
KB(:,43, 4) = (/ &
 & 0.37430E-08_JPRB,0.37088E-08_JPRB,0.35491E-08_JPRB,0.34012E-08_JPRB,0.33022E-08_JPRB /)  
KB(:,44, 4) = (/ &
 & 0.32207E-08_JPRB,0.31034E-08_JPRB,0.30690E-08_JPRB,0.29015E-08_JPRB,0.27644E-08_JPRB /)  
KB(:,45, 4) = (/ &
 & 0.27111E-08_JPRB,0.25582E-08_JPRB,0.26092E-08_JPRB,0.24352E-08_JPRB,0.23234E-08_JPRB /)  
KB(:,46, 4) = (/ &
 & 0.22675E-08_JPRB,0.21455E-08_JPRB,0.21930E-08_JPRB,0.20490E-08_JPRB,0.19277E-08_JPRB /)  
KB(:,47, 4) = (/ &
 & 0.18722E-08_JPRB,0.18163E-08_JPRB,0.18222E-08_JPRB,0.17256E-08_JPRB,0.16025E-08_JPRB /)  
KB(:,48, 4) = (/ &
 & 0.15670E-08_JPRB,0.15133E-08_JPRB,0.14751E-08_JPRB,0.14433E-08_JPRB,0.13269E-08_JPRB /)  
KB(:,49, 4) = (/ &
 & 0.12576E-08_JPRB,0.12106E-08_JPRB,0.11779E-08_JPRB,0.11664E-08_JPRB,0.10722E-08_JPRB /)  
KB(:,50, 4) = (/ &
 & 0.10308E-08_JPRB,0.10019E-08_JPRB,0.98151E-09_JPRB,0.96758E-09_JPRB,0.89739E-09_JPRB /)  
KB(:,51, 4) = (/ &
 & 0.84050E-09_JPRB,0.85047E-09_JPRB,0.83131E-09_JPRB,0.81346E-09_JPRB,0.77303E-09_JPRB /)  
KB(:,52, 4) = (/ &
 & 0.67669E-09_JPRB,0.70190E-09_JPRB,0.68695E-09_JPRB,0.66858E-09_JPRB,0.63719E-09_JPRB /)  
KB(:,53, 4) = (/ &
 & 0.52755E-09_JPRB,0.56097E-09_JPRB,0.54716E-09_JPRB,0.53877E-09_JPRB,0.51047E-09_JPRB /)  
KB(:,54, 4) = (/ &
 & 0.44864E-09_JPRB,0.48984E-09_JPRB,0.48831E-09_JPRB,0.46728E-09_JPRB,0.45462E-09_JPRB /)  
KB(:,55, 4) = (/ &
 & 0.40938E-09_JPRB,0.45501E-09_JPRB,0.45212E-09_JPRB,0.43586E-09_JPRB,0.42245E-09_JPRB /)  
KB(:,56, 4) = (/ &
 & 0.38293E-09_JPRB,0.40217E-09_JPRB,0.41760E-09_JPRB,0.39645E-09_JPRB,0.38652E-09_JPRB /)  
KB(:,57, 4) = (/ &
 & 0.35808E-09_JPRB,0.34306E-09_JPRB,0.38440E-09_JPRB,0.37442E-09_JPRB,0.33472E-09_JPRB /)  
KB(:,58, 4) = (/ &
 & 0.33278E-09_JPRB,0.31839E-09_JPRB,0.35327E-09_JPRB,0.33061E-09_JPRB,0.29093E-09_JPRB /)  
KB(:,59, 4) = (/ &
 & 0.32589E-09_JPRB,0.30766E-09_JPRB,0.30185E-09_JPRB,0.35182E-09_JPRB,0.34474E-09_JPRB /)  
KB(:,13, 5) = (/ &
 & 0.19090E-07_JPRB,0.19323E-07_JPRB,0.21491E-07_JPRB,0.23162E-07_JPRB,0.23970E-07_JPRB /)  
KB(:,14, 5) = (/ &
 & 0.37888E-07_JPRB,0.37108E-07_JPRB,0.33727E-07_JPRB,0.34146E-07_JPRB,0.33930E-07_JPRB /)  
KB(:,15, 5) = (/ &
 & 0.46395E-07_JPRB,0.47265E-07_JPRB,0.48201E-07_JPRB,0.50512E-07_JPRB,0.51101E-07_JPRB /)  
KB(:,16, 5) = (/ &
 & 0.60743E-07_JPRB,0.64371E-07_JPRB,0.67862E-07_JPRB,0.71479E-07_JPRB,0.74200E-07_JPRB /)  
KB(:,17, 5) = (/ &
 & 0.79052E-07_JPRB,0.79011E-07_JPRB,0.77558E-07_JPRB,0.75900E-07_JPRB,0.76450E-07_JPRB /)  
KB(:,18, 5) = (/ &
 & 0.75325E-07_JPRB,0.74009E-07_JPRB,0.72866E-07_JPRB,0.72803E-07_JPRB,0.73869E-07_JPRB /)  
KB(:,19, 5) = (/ &
 & 0.74009E-07_JPRB,0.74054E-07_JPRB,0.73970E-07_JPRB,0.73800E-07_JPRB,0.75638E-07_JPRB /)  
KB(:,20, 5) = (/ &
 & 0.73077E-07_JPRB,0.73306E-07_JPRB,0.72248E-07_JPRB,0.73120E-07_JPRB,0.74630E-07_JPRB /)  
KB(:,21, 5) = (/ &
 & 0.68928E-07_JPRB,0.70100E-07_JPRB,0.69203E-07_JPRB,0.69478E-07_JPRB,0.71860E-07_JPRB /)  
KB(:,22, 5) = (/ &
 & 0.65324E-07_JPRB,0.66570E-07_JPRB,0.66457E-07_JPRB,0.66345E-07_JPRB,0.68314E-07_JPRB /)  
KB(:,23, 5) = (/ &
 & 0.62411E-07_JPRB,0.63996E-07_JPRB,0.63443E-07_JPRB,0.63576E-07_JPRB,0.65766E-07_JPRB /)  
KB(:,24, 5) = (/ &
 & 0.60058E-07_JPRB,0.60956E-07_JPRB,0.60176E-07_JPRB,0.60222E-07_JPRB,0.63287E-07_JPRB /)  
KB(:,25, 5) = (/ &
 & 0.57223E-07_JPRB,0.58225E-07_JPRB,0.58348E-07_JPRB,0.58584E-07_JPRB,0.61933E-07_JPRB /)  
KB(:,26, 5) = (/ &
 & 0.55089E-07_JPRB,0.55723E-07_JPRB,0.55839E-07_JPRB,0.56337E-07_JPRB,0.60335E-07_JPRB /)  
KB(:,27, 5) = (/ &
 & 0.52294E-07_JPRB,0.51745E-07_JPRB,0.52750E-07_JPRB,0.52701E-07_JPRB,0.57676E-07_JPRB /)  
KB(:,28, 5) = (/ &
 & 0.48915E-07_JPRB,0.48234E-07_JPRB,0.48708E-07_JPRB,0.49873E-07_JPRB,0.54442E-07_JPRB /)  
KB(:,29, 5) = (/ &
 & 0.43357E-07_JPRB,0.43230E-07_JPRB,0.43679E-07_JPRB,0.47285E-07_JPRB,0.49519E-07_JPRB /)  
KB(:,30, 5) = (/ &
 & 0.37379E-07_JPRB,0.38427E-07_JPRB,0.39703E-07_JPRB,0.43492E-07_JPRB,0.43278E-07_JPRB /)  
KB(:,31, 5) = (/ &
 & 0.31354E-07_JPRB,0.32238E-07_JPRB,0.35376E-07_JPRB,0.37358E-07_JPRB,0.37130E-07_JPRB /)  
KB(:,32, 5) = (/ &
 & 0.26553E-07_JPRB,0.27801E-07_JPRB,0.30978E-07_JPRB,0.30698E-07_JPRB,0.31234E-07_JPRB /)  
KB(:,33, 5) = (/ &
 & 0.21542E-07_JPRB,0.24274E-07_JPRB,0.24944E-07_JPRB,0.25194E-07_JPRB,0.25415E-07_JPRB /)  
KB(:,34, 5) = (/ &
 & 0.19097E-07_JPRB,0.20582E-07_JPRB,0.20324E-07_JPRB,0.21006E-07_JPRB,0.20944E-07_JPRB /)  
KB(:,35, 5) = (/ &
 & 0.16377E-07_JPRB,0.16881E-07_JPRB,0.16957E-07_JPRB,0.16743E-07_JPRB,0.16958E-07_JPRB /)  
KB(:,36, 5) = (/ &
 & 0.13727E-07_JPRB,0.13834E-07_JPRB,0.13766E-07_JPRB,0.13776E-07_JPRB,0.13546E-07_JPRB /)  
KB(:,37, 5) = (/ &
 & 0.11550E-07_JPRB,0.11601E-07_JPRB,0.11757E-07_JPRB,0.11723E-07_JPRB,0.11413E-07_JPRB /)  
KB(:,38, 5) = (/ &
 & 0.98076E-08_JPRB,0.96320E-08_JPRB,0.10028E-07_JPRB,0.98197E-08_JPRB,0.91408E-08_JPRB /)  
KB(:,39, 5) = (/ &
 & 0.80861E-08_JPRB,0.80113E-08_JPRB,0.81586E-08_JPRB,0.80121E-08_JPRB,0.75021E-08_JPRB /)  
KB(:,40, 5) = (/ &
 & 0.70348E-08_JPRB,0.69980E-08_JPRB,0.71058E-08_JPRB,0.69171E-08_JPRB,0.64103E-08_JPRB /)  
KB(:,41, 5) = (/ &
 & 0.61395E-08_JPRB,0.60379E-08_JPRB,0.61651E-08_JPRB,0.59006E-08_JPRB,0.54433E-08_JPRB /)  
KB(:,42, 5) = (/ &
 & 0.51740E-08_JPRB,0.51391E-08_JPRB,0.53717E-08_JPRB,0.50506E-08_JPRB,0.46901E-08_JPRB /)  
KB(:,43, 5) = (/ &
 & 0.44374E-08_JPRB,0.44002E-08_JPRB,0.45405E-08_JPRB,0.42888E-08_JPRB,0.39390E-08_JPRB /)  
KB(:,44, 5) = (/ &
 & 0.36635E-08_JPRB,0.37555E-08_JPRB,0.37320E-08_JPRB,0.35598E-08_JPRB,0.33280E-08_JPRB /)  
KB(:,45, 5) = (/ &
 & 0.30833E-08_JPRB,0.31320E-08_JPRB,0.30264E-08_JPRB,0.29827E-08_JPRB,0.28298E-08_JPRB /)  
KB(:,46, 5) = (/ &
 & 0.25366E-08_JPRB,0.26077E-08_JPRB,0.24905E-08_JPRB,0.24281E-08_JPRB,0.22727E-08_JPRB /)  
KB(:,47, 5) = (/ &
 & 0.20576E-08_JPRB,0.22029E-08_JPRB,0.20905E-08_JPRB,0.21040E-08_JPRB,0.19027E-08_JPRB /)  
KB(:,48, 5) = (/ &
 & 0.16047E-08_JPRB,0.18190E-08_JPRB,0.17008E-08_JPRB,0.17298E-08_JPRB,0.16059E-08_JPRB /)  
KB(:,49, 5) = (/ &
 & 0.12276E-08_JPRB,0.14135E-08_JPRB,0.13565E-08_JPRB,0.13704E-08_JPRB,0.13029E-08_JPRB /)  
KB(:,50, 5) = (/ &
 & 0.98291E-09_JPRB,0.11837E-08_JPRB,0.11000E-08_JPRB,0.11342E-08_JPRB,0.10621E-08_JPRB /)  
KB(:,51, 5) = (/ &
 & 0.79374E-09_JPRB,0.97756E-09_JPRB,0.90252E-09_JPRB,0.90527E-09_JPRB,0.86815E-09_JPRB /)  
KB(:,52, 5) = (/ &
 & 0.64781E-09_JPRB,0.78454E-09_JPRB,0.75690E-09_JPRB,0.74124E-09_JPRB,0.73195E-09_JPRB /)  
KB(:,53, 5) = (/ &
 & 0.51536E-09_JPRB,0.61158E-09_JPRB,0.60936E-09_JPRB,0.59007E-09_JPRB,0.58458E-09_JPRB /)  
KB(:,54, 5) = (/ &
 & 0.46178E-09_JPRB,0.51944E-09_JPRB,0.52167E-09_JPRB,0.53965E-09_JPRB,0.50524E-09_JPRB /)  
KB(:,55, 5) = (/ &
 & 0.44467E-09_JPRB,0.42857E-09_JPRB,0.50799E-09_JPRB,0.47528E-09_JPRB,0.43900E-09_JPRB /)  
KB(:,56, 5) = (/ &
 & 0.39667E-09_JPRB,0.37862E-09_JPRB,0.45808E-09_JPRB,0.43270E-09_JPRB,0.38817E-09_JPRB /)  
KB(:,57, 5) = (/ &
 & 0.35926E-09_JPRB,0.35410E-09_JPRB,0.38962E-09_JPRB,0.37502E-09_JPRB,0.40935E-09_JPRB /)  
KB(:,58, 5) = (/ &
 & 0.31517E-09_JPRB,0.32964E-09_JPRB,0.29323E-09_JPRB,0.39945E-09_JPRB,0.40389E-09_JPRB /)  
KB(:,59, 5) = (/ &
 & 0.36198E-09_JPRB,0.38633E-09_JPRB,0.41096E-09_JPRB,0.53914E-09_JPRB,0.57631E-09_JPRB /)  
KB(:,13, 6) = (/ &
 & 0.23095E-07_JPRB,0.23025E-07_JPRB,0.25126E-07_JPRB,0.25618E-07_JPRB,0.24969E-07_JPRB /)  
KB(:,14, 6) = (/ &
 & 0.31573E-07_JPRB,0.32360E-07_JPRB,0.33220E-07_JPRB,0.32611E-07_JPRB,0.32150E-07_JPRB /)  
KB(:,15, 6) = (/ &
 & 0.45219E-07_JPRB,0.45787E-07_JPRB,0.47088E-07_JPRB,0.49543E-07_JPRB,0.54072E-07_JPRB /)  
KB(:,16, 6) = (/ &
 & 0.65293E-07_JPRB,0.67448E-07_JPRB,0.64557E-07_JPRB,0.63976E-07_JPRB,0.64905E-07_JPRB /)  
KB(:,17, 6) = (/ &
 & 0.64862E-07_JPRB,0.63259E-07_JPRB,0.62851E-07_JPRB,0.62500E-07_JPRB,0.63112E-07_JPRB /)  
KB(:,18, 6) = (/ &
 & 0.61849E-07_JPRB,0.62108E-07_JPRB,0.60565E-07_JPRB,0.60920E-07_JPRB,0.61810E-07_JPRB /)  
KB(:,19, 6) = (/ &
 & 0.63930E-07_JPRB,0.63195E-07_JPRB,0.62478E-07_JPRB,0.62282E-07_JPRB,0.62250E-07_JPRB /)  
KB(:,20, 6) = (/ &
 & 0.60100E-07_JPRB,0.60269E-07_JPRB,0.59919E-07_JPRB,0.57578E-07_JPRB,0.57933E-07_JPRB /)  
KB(:,21, 6) = (/ &
 & 0.56465E-07_JPRB,0.56674E-07_JPRB,0.56992E-07_JPRB,0.55969E-07_JPRB,0.54719E-07_JPRB /)  
KB(:,22, 6) = (/ &
 & 0.54280E-07_JPRB,0.53760E-07_JPRB,0.52615E-07_JPRB,0.52261E-07_JPRB,0.51523E-07_JPRB /)  
KB(:,23, 6) = (/ &
 & 0.49921E-07_JPRB,0.49472E-07_JPRB,0.49168E-07_JPRB,0.47959E-07_JPRB,0.47449E-07_JPRB /)  
KB(:,24, 6) = (/ &
 & 0.45803E-07_JPRB,0.46271E-07_JPRB,0.46322E-07_JPRB,0.46536E-07_JPRB,0.46494E-07_JPRB /)  
KB(:,25, 6) = (/ &
 & 0.43723E-07_JPRB,0.44225E-07_JPRB,0.44324E-07_JPRB,0.43726E-07_JPRB,0.43579E-07_JPRB /)  
KB(:,26, 6) = (/ &
 & 0.41617E-07_JPRB,0.42588E-07_JPRB,0.42306E-07_JPRB,0.41086E-07_JPRB,0.41943E-07_JPRB /)  
KB(:,27, 6) = (/ &
 & 0.38855E-07_JPRB,0.40231E-07_JPRB,0.39090E-07_JPRB,0.39461E-07_JPRB,0.39072E-07_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART13',1,ZHOOK_HANDLE)
END SUBROUTINE PART13


SUBROUTINE PART14

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART14',0,ZHOOK_HANDLE)


KB(:,28, 6) = (/ &
 & 0.35912E-07_JPRB,0.36691E-07_JPRB,0.35670E-07_JPRB,0.35644E-07_JPRB,0.38295E-07_JPRB /)  
KB(:,29, 6) = (/ &
 & 0.33357E-07_JPRB,0.33134E-07_JPRB,0.32394E-07_JPRB,0.32909E-07_JPRB,0.36234E-07_JPRB /)  
KB(:,30, 6) = (/ &
 & 0.30529E-07_JPRB,0.29196E-07_JPRB,0.29147E-07_JPRB,0.30292E-07_JPRB,0.33912E-07_JPRB /)  
KB(:,31, 6) = (/ &
 & 0.27228E-07_JPRB,0.27081E-07_JPRB,0.26630E-07_JPRB,0.30010E-07_JPRB,0.28781E-07_JPRB /)  
KB(:,32, 6) = (/ &
 & 0.24109E-07_JPRB,0.24388E-07_JPRB,0.25546E-07_JPRB,0.26823E-07_JPRB,0.26681E-07_JPRB /)  
KB(:,33, 6) = (/ &
 & 0.21402E-07_JPRB,0.22303E-07_JPRB,0.24668E-07_JPRB,0.24556E-07_JPRB,0.24369E-07_JPRB /)  
KB(:,34, 6) = (/ &
 & 0.18136E-07_JPRB,0.20944E-07_JPRB,0.21211E-07_JPRB,0.21286E-07_JPRB,0.21648E-07_JPRB /)  
KB(:,35, 6) = (/ &
 & 0.16306E-07_JPRB,0.17531E-07_JPRB,0.17744E-07_JPRB,0.18061E-07_JPRB,0.18282E-07_JPRB /)  
KB(:,36, 6) = (/ &
 & 0.13873E-07_JPRB,0.14963E-07_JPRB,0.15398E-07_JPRB,0.15527E-07_JPRB,0.15391E-07_JPRB /)  
KB(:,37, 6) = (/ &
 & 0.11948E-07_JPRB,0.12614E-07_JPRB,0.12946E-07_JPRB,0.12916E-07_JPRB,0.13085E-07_JPRB /)  
KB(:,38, 6) = (/ &
 & 0.98235E-08_JPRB,0.10612E-07_JPRB,0.10029E-07_JPRB,0.10618E-07_JPRB,0.10860E-07_JPRB /)  
KB(:,39, 6) = (/ &
 & 0.81514E-08_JPRB,0.84716E-08_JPRB,0.81123E-08_JPRB,0.83644E-08_JPRB,0.81668E-08_JPRB /)  
KB(:,40, 6) = (/ &
 & 0.68179E-08_JPRB,0.69030E-08_JPRB,0.69393E-08_JPRB,0.69969E-08_JPRB,0.71027E-08_JPRB /)  
KB(:,41, 6) = (/ &
 & 0.59350E-08_JPRB,0.60668E-08_JPRB,0.59026E-08_JPRB,0.60181E-08_JPRB,0.60779E-08_JPRB /)  
KB(:,42, 6) = (/ &
 & 0.51181E-08_JPRB,0.52127E-08_JPRB,0.48788E-08_JPRB,0.51397E-08_JPRB,0.50230E-08_JPRB /)  
KB(:,43, 6) = (/ &
 & 0.42653E-08_JPRB,0.44600E-08_JPRB,0.41100E-08_JPRB,0.44735E-08_JPRB,0.42607E-08_JPRB /)  
KB(:,44, 6) = (/ &
 & 0.34724E-08_JPRB,0.37628E-08_JPRB,0.35340E-08_JPRB,0.38309E-08_JPRB,0.36188E-08_JPRB /)  
KB(:,45, 6) = (/ &
 & 0.27994E-08_JPRB,0.31690E-08_JPRB,0.28599E-08_JPRB,0.30290E-08_JPRB,0.27730E-08_JPRB /)  
KB(:,46, 6) = (/ &
 & 0.22089E-08_JPRB,0.25761E-08_JPRB,0.23856E-08_JPRB,0.24874E-08_JPRB,0.23603E-08_JPRB /)  
KB(:,47, 6) = (/ &
 & 0.18078E-08_JPRB,0.20304E-08_JPRB,0.19457E-08_JPRB,0.19366E-08_JPRB,0.19286E-08_JPRB /)  
KB(:,48, 6) = (/ &
 & 0.14716E-08_JPRB,0.15703E-08_JPRB,0.17393E-08_JPRB,0.14836E-08_JPRB,0.15316E-08_JPRB /)  
KB(:,49, 6) = (/ &
 & 0.11334E-08_JPRB,0.12901E-08_JPRB,0.13556E-08_JPRB,0.11610E-08_JPRB,0.11617E-08_JPRB /)  
KB(:,50, 6) = (/ &
 & 0.90881E-09_JPRB,0.10323E-08_JPRB,0.11378E-08_JPRB,0.95509E-09_JPRB,0.96291E-09_JPRB /)  
KB(:,51, 6) = (/ &
 & 0.76751E-09_JPRB,0.81710E-09_JPRB,0.97432E-09_JPRB,0.82408E-09_JPRB,0.81205E-09_JPRB /)  
KB(:,52, 6) = (/ &
 & 0.62668E-09_JPRB,0.66223E-09_JPRB,0.76870E-09_JPRB,0.68347E-09_JPRB,0.65771E-09_JPRB /)  
KB(:,53, 6) = (/ &
 & 0.50547E-09_JPRB,0.49991E-09_JPRB,0.61494E-09_JPRB,0.55640E-09_JPRB,0.52803E-09_JPRB /)  
KB(:,54, 6) = (/ &
 & 0.42841E-09_JPRB,0.42678E-09_JPRB,0.51796E-09_JPRB,0.46340E-09_JPRB,0.44830E-09_JPRB /)  
KB(:,55, 6) = (/ &
 & 0.40234E-09_JPRB,0.40065E-09_JPRB,0.45944E-09_JPRB,0.42252E-09_JPRB,0.44365E-09_JPRB /)  
KB(:,56, 6) = (/ &
 & 0.36764E-09_JPRB,0.35937E-09_JPRB,0.36570E-09_JPRB,0.44631E-09_JPRB,0.45684E-09_JPRB /)  
KB(:,57, 6) = (/ &
 & 0.33321E-09_JPRB,0.29808E-09_JPRB,0.31056E-09_JPRB,0.44585E-09_JPRB,0.41122E-09_JPRB /)  
KB(:,58, 6) = (/ &
 & 0.31198E-09_JPRB,0.29542E-09_JPRB,0.33327E-09_JPRB,0.43871E-09_JPRB,0.45291E-09_JPRB /)  
KB(:,59, 6) = (/ &
 & 0.38710E-09_JPRB,0.42412E-09_JPRB,0.44197E-09_JPRB,0.49964E-09_JPRB,0.70387E-09_JPRB /)  
KB(:,13, 7) = (/ &
 & 0.30377E-07_JPRB,0.31586E-07_JPRB,0.27647E-07_JPRB,0.27937E-07_JPRB,0.28036E-07_JPRB /)  
KB(:,14, 7) = (/ &
 & 0.37766E-07_JPRB,0.39819E-07_JPRB,0.39822E-07_JPRB,0.40069E-07_JPRB,0.42091E-07_JPRB /)  
KB(:,15, 7) = (/ &
 & 0.57996E-07_JPRB,0.64474E-07_JPRB,0.69368E-07_JPRB,0.70909E-07_JPRB,0.70748E-07_JPRB /)  
KB(:,16, 7) = (/ &
 & 0.73220E-07_JPRB,0.70124E-07_JPRB,0.69135E-07_JPRB,0.68058E-07_JPRB,0.66524E-07_JPRB /)  
KB(:,17, 7) = (/ &
 & 0.66529E-07_JPRB,0.66306E-07_JPRB,0.63797E-07_JPRB,0.63551E-07_JPRB,0.63462E-07_JPRB /)  
KB(:,18, 7) = (/ &
 & 0.66492E-07_JPRB,0.65156E-07_JPRB,0.66323E-07_JPRB,0.64485E-07_JPRB,0.63285E-07_JPRB /)  
KB(:,19, 7) = (/ &
 & 0.62980E-07_JPRB,0.62900E-07_JPRB,0.62718E-07_JPRB,0.61114E-07_JPRB,0.59765E-07_JPRB /)  
KB(:,20, 7) = (/ &
 & 0.59754E-07_JPRB,0.58066E-07_JPRB,0.59540E-07_JPRB,0.58926E-07_JPRB,0.57835E-07_JPRB /)  
KB(:,21, 7) = (/ &
 & 0.57368E-07_JPRB,0.55161E-07_JPRB,0.55685E-07_JPRB,0.55360E-07_JPRB,0.53982E-07_JPRB /)  
KB(:,22, 7) = (/ &
 & 0.51435E-07_JPRB,0.49998E-07_JPRB,0.50952E-07_JPRB,0.50442E-07_JPRB,0.49717E-07_JPRB /)  
KB(:,23, 7) = (/ &
 & 0.47663E-07_JPRB,0.46845E-07_JPRB,0.47849E-07_JPRB,0.48876E-07_JPRB,0.48885E-07_JPRB /)  
KB(:,24, 7) = (/ &
 & 0.47926E-07_JPRB,0.45619E-07_JPRB,0.45793E-07_JPRB,0.46467E-07_JPRB,0.45938E-07_JPRB /)  
KB(:,25, 7) = (/ &
 & 0.44687E-07_JPRB,0.43904E-07_JPRB,0.44284E-07_JPRB,0.44176E-07_JPRB,0.45520E-07_JPRB /)  
KB(:,26, 7) = (/ &
 & 0.42751E-07_JPRB,0.41938E-07_JPRB,0.42889E-07_JPRB,0.42927E-07_JPRB,0.43868E-07_JPRB /)  
KB(:,27, 7) = (/ &
 & 0.40180E-07_JPRB,0.40529E-07_JPRB,0.40621E-07_JPRB,0.40949E-07_JPRB,0.41005E-07_JPRB /)  
KB(:,28, 7) = (/ &
 & 0.35890E-07_JPRB,0.36716E-07_JPRB,0.37875E-07_JPRB,0.38308E-07_JPRB,0.37626E-07_JPRB /)  
KB(:,29, 7) = (/ &
 & 0.31499E-07_JPRB,0.33284E-07_JPRB,0.32725E-07_JPRB,0.32493E-07_JPRB,0.35018E-07_JPRB /)  
KB(:,30, 7) = (/ &
 & 0.29364E-07_JPRB,0.28675E-07_JPRB,0.28942E-07_JPRB,0.28761E-07_JPRB,0.33960E-07_JPRB /)  
KB(:,31, 7) = (/ &
 & 0.25558E-07_JPRB,0.23679E-07_JPRB,0.24292E-07_JPRB,0.26053E-07_JPRB,0.29211E-07_JPRB /)  
KB(:,32, 7) = (/ &
 & 0.20860E-07_JPRB,0.21491E-07_JPRB,0.20910E-07_JPRB,0.25598E-07_JPRB,0.24209E-07_JPRB /)  
KB(:,33, 7) = (/ &
 & 0.18874E-07_JPRB,0.18554E-07_JPRB,0.21206E-07_JPRB,0.20708E-07_JPRB,0.21100E-07_JPRB /)  
KB(:,34, 7) = (/ &
 & 0.18632E-07_JPRB,0.18625E-07_JPRB,0.20707E-07_JPRB,0.19570E-07_JPRB,0.18956E-07_JPRB /)  
KB(:,35, 7) = (/ &
 & 0.15958E-07_JPRB,0.19141E-07_JPRB,0.19004E-07_JPRB,0.19249E-07_JPRB,0.17793E-07_JPRB /)  
KB(:,36, 7) = (/ &
 & 0.14552E-07_JPRB,0.16561E-07_JPRB,0.16607E-07_JPRB,0.16784E-07_JPRB,0.16326E-07_JPRB /)  
KB(:,37, 7) = (/ &
 & 0.13127E-07_JPRB,0.14300E-07_JPRB,0.14021E-07_JPRB,0.14385E-07_JPRB,0.13328E-07_JPRB /)  
KB(:,38, 7) = (/ &
 & 0.11514E-07_JPRB,0.12356E-07_JPRB,0.12677E-07_JPRB,0.12181E-07_JPRB,0.11774E-07_JPRB /)  
KB(:,39, 7) = (/ &
 & 0.93434E-08_JPRB,0.10196E-07_JPRB,0.10605E-07_JPRB,0.10201E-07_JPRB,0.10584E-07_JPRB /)  
KB(:,40, 7) = (/ &
 & 0.81790E-08_JPRB,0.89000E-08_JPRB,0.85315E-08_JPRB,0.89663E-08_JPRB,0.91635E-08_JPRB /)  
KB(:,41, 7) = (/ &
 & 0.65541E-08_JPRB,0.74884E-08_JPRB,0.72364E-08_JPRB,0.72692E-08_JPRB,0.75649E-08_JPRB /)  
KB(:,42, 7) = (/ &
 & 0.54665E-08_JPRB,0.61796E-08_JPRB,0.61564E-08_JPRB,0.61304E-08_JPRB,0.64285E-08_JPRB /)  
KB(:,43, 7) = (/ &
 & 0.43531E-08_JPRB,0.47798E-08_JPRB,0.51393E-08_JPRB,0.49135E-08_JPRB,0.53520E-08_JPRB /)  
KB(:,44, 7) = (/ &
 & 0.35872E-08_JPRB,0.38233E-08_JPRB,0.42659E-08_JPRB,0.39384E-08_JPRB,0.44541E-08_JPRB /)  
KB(:,45, 7) = (/ &
 & 0.28156E-08_JPRB,0.32775E-08_JPRB,0.36262E-08_JPRB,0.32518E-08_JPRB,0.36805E-08_JPRB /)  
KB(:,46, 7) = (/ &
 & 0.23879E-08_JPRB,0.26299E-08_JPRB,0.28972E-08_JPRB,0.27379E-08_JPRB,0.30333E-08_JPRB /)  
KB(:,47, 7) = (/ &
 & 0.19282E-08_JPRB,0.22066E-08_JPRB,0.23812E-08_JPRB,0.23512E-08_JPRB,0.23794E-08_JPRB /)  
KB(:,48, 7) = (/ &
 & 0.15092E-08_JPRB,0.18255E-08_JPRB,0.17414E-08_JPRB,0.19322E-08_JPRB,0.19399E-08_JPRB /)  
KB(:,49, 7) = (/ &
 & 0.11905E-08_JPRB,0.13964E-08_JPRB,0.14306E-08_JPRB,0.14791E-08_JPRB,0.14939E-08_JPRB /)  
KB(:,50, 7) = (/ &
 & 0.98537E-09_JPRB,0.10687E-08_JPRB,0.11753E-08_JPRB,0.11334E-08_JPRB,0.13178E-08_JPRB /)  
KB(:,51, 7) = (/ &
 & 0.84255E-09_JPRB,0.88069E-09_JPRB,0.95073E-09_JPRB,0.92632E-09_JPRB,0.10457E-08_JPRB /)  
KB(:,52, 7) = (/ &
 & 0.68238E-09_JPRB,0.70376E-09_JPRB,0.74795E-09_JPRB,0.75152E-09_JPRB,0.78131E-09_JPRB /)  
KB(:,53, 7) = (/ &
 & 0.56271E-09_JPRB,0.58527E-09_JPRB,0.61397E-09_JPRB,0.56343E-09_JPRB,0.61138E-09_JPRB /)  
KB(:,54, 7) = (/ &
 & 0.52493E-09_JPRB,0.46040E-09_JPRB,0.53769E-09_JPRB,0.51459E-09_JPRB,0.52912E-09_JPRB /)  
KB(:,55, 7) = (/ &
 & 0.40372E-09_JPRB,0.38720E-09_JPRB,0.40004E-09_JPRB,0.56294E-09_JPRB,0.55844E-09_JPRB /)  
KB(:,56, 7) = (/ &
 & 0.37372E-09_JPRB,0.35358E-09_JPRB,0.39920E-09_JPRB,0.52819E-09_JPRB,0.50147E-09_JPRB /)  
KB(:,57, 7) = (/ &
 & 0.31149E-09_JPRB,0.39454E-09_JPRB,0.38951E-09_JPRB,0.52086E-09_JPRB,0.54542E-09_JPRB /)  
KB(:,58, 7) = (/ &
 & 0.30564E-09_JPRB,0.36251E-09_JPRB,0.38551E-09_JPRB,0.43845E-09_JPRB,0.61772E-09_JPRB /)  
KB(:,59, 7) = (/ &
 & 0.46934E-09_JPRB,0.57639E-09_JPRB,0.58591E-09_JPRB,0.63021E-09_JPRB,0.71158E-09_JPRB /)  
KB(:,13, 8) = (/ &
 & 0.34320E-07_JPRB,0.31607E-07_JPRB,0.29840E-07_JPRB,0.29114E-07_JPRB,0.28831E-07_JPRB /)  
KB(:,14, 8) = (/ &
 & 0.38157E-07_JPRB,0.37907E-07_JPRB,0.40351E-07_JPRB,0.45015E-07_JPRB,0.44786E-07_JPRB /)  
KB(:,15, 8) = (/ &
 & 0.71231E-07_JPRB,0.71647E-07_JPRB,0.71034E-07_JPRB,0.71647E-07_JPRB,0.71755E-07_JPRB /)  
KB(:,16, 8) = (/ &
 & 0.72049E-07_JPRB,0.69075E-07_JPRB,0.67707E-07_JPRB,0.67019E-07_JPRB,0.66780E-07_JPRB /)  
KB(:,17, 8) = (/ &
 & 0.69751E-07_JPRB,0.66211E-07_JPRB,0.66017E-07_JPRB,0.63095E-07_JPRB,0.63343E-07_JPRB /)  
KB(:,18, 8) = (/ &
 & 0.67728E-07_JPRB,0.66581E-07_JPRB,0.64787E-07_JPRB,0.62981E-07_JPRB,0.62245E-07_JPRB /)  
KB(:,19, 8) = (/ &
 & 0.65864E-07_JPRB,0.63789E-07_JPRB,0.62712E-07_JPRB,0.62065E-07_JPRB,0.61005E-07_JPRB /)  
KB(:,20, 8) = (/ &
 & 0.61816E-07_JPRB,0.63755E-07_JPRB,0.63424E-07_JPRB,0.61945E-07_JPRB,0.58720E-07_JPRB /)  
KB(:,21, 8) = (/ &
 & 0.59112E-07_JPRB,0.58061E-07_JPRB,0.57019E-07_JPRB,0.54795E-07_JPRB,0.56069E-07_JPRB /)  
KB(:,22, 8) = (/ &
 & 0.56217E-07_JPRB,0.53887E-07_JPRB,0.54812E-07_JPRB,0.52500E-07_JPRB,0.53303E-07_JPRB /)  
KB(:,23, 8) = (/ &
 & 0.54428E-07_JPRB,0.52930E-07_JPRB,0.53278E-07_JPRB,0.52797E-07_JPRB,0.51840E-07_JPRB /)  
KB(:,24, 8) = (/ &
 & 0.51236E-07_JPRB,0.52532E-07_JPRB,0.53348E-07_JPRB,0.51715E-07_JPRB,0.53224E-07_JPRB /)  
KB(:,25, 8) = (/ &
 & 0.49989E-07_JPRB,0.50872E-07_JPRB,0.49932E-07_JPRB,0.52702E-07_JPRB,0.51493E-07_JPRB /)  
KB(:,26, 8) = (/ &
 & 0.49845E-07_JPRB,0.48733E-07_JPRB,0.48348E-07_JPRB,0.51346E-07_JPRB,0.51109E-07_JPRB /)  
KB(:,27, 8) = (/ &
 & 0.43883E-07_JPRB,0.43853E-07_JPRB,0.46523E-07_JPRB,0.47281E-07_JPRB,0.47292E-07_JPRB /)  
KB(:,28, 8) = (/ &
 & 0.41424E-07_JPRB,0.42057E-07_JPRB,0.43773E-07_JPRB,0.43422E-07_JPRB,0.41438E-07_JPRB /)  
KB(:,29, 8) = (/ &
 & 0.37736E-07_JPRB,0.34915E-07_JPRB,0.37971E-07_JPRB,0.38437E-07_JPRB,0.38122E-07_JPRB /)  
KB(:,30, 8) = (/ &
 & 0.30209E-07_JPRB,0.32936E-07_JPRB,0.31853E-07_JPRB,0.30285E-07_JPRB,0.31746E-07_JPRB /)  
KB(:,31, 8) = (/ &
 & 0.25886E-07_JPRB,0.26990E-07_JPRB,0.27039E-07_JPRB,0.26019E-07_JPRB,0.34246E-07_JPRB /)  
KB(:,32, 8) = (/ &
 & 0.24750E-07_JPRB,0.20653E-07_JPRB,0.21921E-07_JPRB,0.25087E-07_JPRB,0.25874E-07_JPRB /)  
KB(:,33, 8) = (/ &
 & 0.19410E-07_JPRB,0.18820E-07_JPRB,0.18768E-07_JPRB,0.23223E-07_JPRB,0.20942E-07_JPRB /)  
KB(:,34, 8) = (/ &
 & 0.16037E-07_JPRB,0.16060E-07_JPRB,0.19012E-07_JPRB,0.17686E-07_JPRB,0.18319E-07_JPRB /)  
KB(:,35, 8) = (/ &
 & 0.16085E-07_JPRB,0.15072E-07_JPRB,0.16472E-07_JPRB,0.15719E-07_JPRB,0.16406E-07_JPRB /)  
KB(:,36, 8) = (/ &
 & 0.15014E-07_JPRB,0.17144E-07_JPRB,0.16353E-07_JPRB,0.15223E-07_JPRB,0.14884E-07_JPRB /)  
KB(:,37, 8) = (/ &
 & 0.12909E-07_JPRB,0.15628E-07_JPRB,0.16086E-07_JPRB,0.15318E-07_JPRB,0.15605E-07_JPRB /)  
KB(:,38, 8) = (/ &
 & 0.11803E-07_JPRB,0.12970E-07_JPRB,0.13587E-07_JPRB,0.13257E-07_JPRB,0.13920E-07_JPRB /)  
KB(:,39, 8) = (/ &
 & 0.10299E-07_JPRB,0.10951E-07_JPRB,0.11006E-07_JPRB,0.11507E-07_JPRB,0.10553E-07_JPRB /)  
KB(:,40, 8) = (/ &
 & 0.87605E-08_JPRB,0.10094E-07_JPRB,0.10641E-07_JPRB,0.94199E-08_JPRB,0.97115E-08_JPRB /)  
KB(:,41, 8) = (/ &
 & 0.69747E-08_JPRB,0.82105E-08_JPRB,0.93516E-08_JPRB,0.90234E-08_JPRB,0.91657E-08_JPRB /)  
KB(:,42, 8) = (/ &
 & 0.60201E-08_JPRB,0.73523E-08_JPRB,0.76249E-08_JPRB,0.76962E-08_JPRB,0.80489E-08_JPRB /)  
KB(:,43, 8) = (/ &
 & 0.50249E-08_JPRB,0.64035E-08_JPRB,0.62997E-08_JPRB,0.63745E-08_JPRB,0.65773E-08_JPRB /)  
KB(:,44, 8) = (/ &
 & 0.43021E-08_JPRB,0.55682E-08_JPRB,0.52391E-08_JPRB,0.55432E-08_JPRB,0.53417E-08_JPRB /)  
KB(:,45, 8) = (/ &
 & 0.34659E-08_JPRB,0.41011E-08_JPRB,0.41998E-08_JPRB,0.45328E-08_JPRB,0.45452E-08_JPRB /)  
KB(:,46, 8) = (/ &
 & 0.26629E-08_JPRB,0.30573E-08_JPRB,0.34050E-08_JPRB,0.36018E-08_JPRB,0.38146E-08_JPRB /)  
KB(:,47, 8) = (/ &
 & 0.20352E-08_JPRB,0.25120E-08_JPRB,0.29668E-08_JPRB,0.27818E-08_JPRB,0.34015E-08_JPRB /)  
KB(:,48, 8) = (/ &
 & 0.16537E-08_JPRB,0.17568E-08_JPRB,0.23894E-08_JPRB,0.22154E-08_JPRB,0.25802E-08_JPRB /)  
KB(:,49, 8) = (/ &
 & 0.13981E-08_JPRB,0.14349E-08_JPRB,0.17246E-08_JPRB,0.17767E-08_JPRB,0.19090E-08_JPRB /)  
KB(:,50, 8) = (/ &
 & 0.10918E-08_JPRB,0.11356E-08_JPRB,0.12258E-08_JPRB,0.14996E-08_JPRB,0.12493E-08_JPRB /)  
KB(:,51, 8) = (/ &
 & 0.96204E-09_JPRB,0.88786E-09_JPRB,0.10061E-08_JPRB,0.12415E-08_JPRB,0.10774E-08_JPRB /)  
KB(:,52, 8) = (/ &
 & 0.79848E-09_JPRB,0.70289E-09_JPRB,0.84515E-09_JPRB,0.10143E-08_JPRB,0.85552E-09_JPRB /)  
KB(:,53, 8) = (/ &
 & 0.60435E-09_JPRB,0.54746E-09_JPRB,0.63806E-09_JPRB,0.74615E-09_JPRB,0.64507E-09_JPRB /)  
KB(:,54, 8) = (/ &
 & 0.47378E-09_JPRB,0.48059E-09_JPRB,0.54886E-09_JPRB,0.73215E-09_JPRB,0.65721E-09_JPRB /)  
KB(:,55, 8) = (/ &
 & 0.45346E-09_JPRB,0.46291E-09_JPRB,0.55380E-09_JPRB,0.67829E-09_JPRB,0.56756E-09_JPRB /)  
KB(:,56, 8) = (/ &
 & 0.43938E-09_JPRB,0.46043E-09_JPRB,0.50980E-09_JPRB,0.62685E-09_JPRB,0.70094E-09_JPRB /)  
KB(:,57, 8) = (/ &
 & 0.42587E-09_JPRB,0.43184E-09_JPRB,0.47819E-09_JPRB,0.57152E-09_JPRB,0.76528E-09_JPRB /)  
KB(:,58, 8) = (/ &
 & 0.47403E-09_JPRB,0.46387E-09_JPRB,0.50904E-09_JPRB,0.58886E-09_JPRB,0.70162E-09_JPRB /)  
KB(:,59, 8) = (/ &
 & 0.54448E-09_JPRB,0.50172E-09_JPRB,0.65155E-09_JPRB,0.65748E-09_JPRB,0.98321E-09_JPRB /)  
KB(:,13, 9) = (/ &
 & 0.10995E-05_JPRB,0.11095E-05_JPRB,0.11168E-05_JPRB,0.11200E-05_JPRB,0.11274E-05_JPRB /)  
KB(:,14, 9) = (/ &
 & 0.73340E-06_JPRB,0.73567E-06_JPRB,0.73740E-06_JPRB,0.73330E-06_JPRB,0.73919E-06_JPRB /)  
KB(:,15, 9) = (/ &
 & 0.32510E-06_JPRB,0.31252E-06_JPRB,0.30243E-06_JPRB,0.29146E-06_JPRB,0.28830E-06_JPRB /)  
KB(:,16, 9) = (/ &
 & 0.61567E-07_JPRB,0.60590E-07_JPRB,0.61057E-07_JPRB,0.58821E-07_JPRB,0.58536E-07_JPRB /)  
KB(:,17, 9) = (/ &
 & 0.60009E-07_JPRB,0.60924E-07_JPRB,0.61205E-07_JPRB,0.63591E-07_JPRB,0.59950E-07_JPRB /)  
KB(:,18, 9) = (/ &
 & 0.61458E-07_JPRB,0.61692E-07_JPRB,0.60339E-07_JPRB,0.59878E-07_JPRB,0.58575E-07_JPRB /)  
KB(:,19, 9) = (/ &
 & 0.57878E-07_JPRB,0.60299E-07_JPRB,0.60236E-07_JPRB,0.59512E-07_JPRB,0.58126E-07_JPRB /)  
KB(:,20, 9) = (/ &
 & 0.58329E-07_JPRB,0.57451E-07_JPRB,0.54760E-07_JPRB,0.57082E-07_JPRB,0.56805E-07_JPRB /)  
KB(:,21, 9) = (/ &
 & 0.53092E-07_JPRB,0.51700E-07_JPRB,0.51833E-07_JPRB,0.52853E-07_JPRB,0.52467E-07_JPRB /)  
KB(:,22, 9) = (/ &
 & 0.47591E-07_JPRB,0.51357E-07_JPRB,0.49075E-07_JPRB,0.53548E-07_JPRB,0.55924E-07_JPRB /)  
KB(:,23, 9) = (/ &
 & 0.49724E-07_JPRB,0.51803E-07_JPRB,0.51793E-07_JPRB,0.49922E-07_JPRB,0.52665E-07_JPRB /)  
KB(:,24, 9) = (/ &
 & 0.47737E-07_JPRB,0.49279E-07_JPRB,0.51207E-07_JPRB,0.49000E-07_JPRB,0.51613E-07_JPRB /)  
KB(:,25, 9) = (/ &
 & 0.49014E-07_JPRB,0.50174E-07_JPRB,0.54886E-07_JPRB,0.47520E-07_JPRB,0.49798E-07_JPRB /)  
KB(:,26, 9) = (/ &
 & 0.42783E-07_JPRB,0.51200E-07_JPRB,0.50600E-07_JPRB,0.47620E-07_JPRB,0.43709E-07_JPRB /)  
KB(:,27, 9) = (/ &
 & 0.42685E-07_JPRB,0.50611E-07_JPRB,0.42800E-07_JPRB,0.43026E-07_JPRB,0.46518E-07_JPRB /)  
KB(:,28, 9) = (/ &
 & 0.40023E-07_JPRB,0.44433E-07_JPRB,0.38380E-07_JPRB,0.40945E-07_JPRB,0.42005E-07_JPRB /)  
KB(:,29, 9) = (/ &
 & 0.34641E-07_JPRB,0.38943E-07_JPRB,0.36153E-07_JPRB,0.36773E-07_JPRB,0.32051E-07_JPRB /)  
KB(:,30, 9) = (/ &
 & 0.31936E-07_JPRB,0.28774E-07_JPRB,0.32629E-07_JPRB,0.32074E-07_JPRB,0.31547E-07_JPRB /)  
KB(:,31, 9) = (/ &
 & 0.25468E-07_JPRB,0.25946E-07_JPRB,0.23671E-07_JPRB,0.23770E-07_JPRB,0.28704E-07_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART14',1,ZHOOK_HANDLE)
END SUBROUTINE PART14


SUBROUTINE PART15

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART15',0,ZHOOK_HANDLE)


KB(:,32, 9) = (/ &
 & 0.18317E-07_JPRB,0.22069E-07_JPRB,0.20055E-07_JPRB,0.21665E-07_JPRB,0.25653E-07_JPRB /)  
KB(:,33, 9) = (/ &
 & 0.18319E-07_JPRB,0.17920E-07_JPRB,0.16523E-07_JPRB,0.20049E-07_JPRB,0.19951E-07_JPRB /)  
KB(:,34, 9) = (/ &
 & 0.15127E-07_JPRB,0.13546E-07_JPRB,0.16257E-07_JPRB,0.16818E-07_JPRB,0.15661E-07_JPRB /)  
KB(:,35, 9) = (/ &
 & 0.12192E-07_JPRB,0.13829E-07_JPRB,0.15792E-07_JPRB,0.15440E-07_JPRB,0.14596E-07_JPRB /)  
KB(:,36, 9) = (/ &
 & 0.11593E-07_JPRB,0.10509E-07_JPRB,0.13211E-07_JPRB,0.13026E-07_JPRB,0.13917E-07_JPRB /)  
KB(:,37, 9) = (/ &
 & 0.12302E-07_JPRB,0.13196E-07_JPRB,0.12558E-07_JPRB,0.11760E-07_JPRB,0.12490E-07_JPRB /)  
KB(:,38, 9) = (/ &
 & 0.10116E-07_JPRB,0.12498E-07_JPRB,0.12546E-07_JPRB,0.12890E-07_JPRB,0.12908E-07_JPRB /)  
KB(:,39, 9) = (/ &
 & 0.88258E-08_JPRB,0.10400E-07_JPRB,0.11293E-07_JPRB,0.11361E-07_JPRB,0.11468E-07_JPRB /)  
KB(:,40, 9) = (/ &
 & 0.70753E-08_JPRB,0.81481E-08_JPRB,0.94292E-08_JPRB,0.10943E-07_JPRB,0.90300E-08_JPRB /)  
KB(:,41, 9) = (/ &
 & 0.71994E-08_JPRB,0.84394E-08_JPRB,0.89108E-08_JPRB,0.89407E-08_JPRB,0.87875E-08_JPRB /)  
KB(:,42, 9) = (/ &
 & 0.55536E-08_JPRB,0.66846E-08_JPRB,0.83965E-08_JPRB,0.80560E-08_JPRB,0.79305E-08_JPRB /)  
KB(:,43, 9) = (/ &
 & 0.50223E-08_JPRB,0.59958E-08_JPRB,0.69583E-08_JPRB,0.70648E-08_JPRB,0.76990E-08_JPRB /)  
KB(:,44, 9) = (/ &
 & 0.40990E-08_JPRB,0.43884E-08_JPRB,0.50706E-08_JPRB,0.56081E-08_JPRB,0.62414E-08_JPRB /)  
KB(:,45, 9) = (/ &
 & 0.35590E-08_JPRB,0.38731E-08_JPRB,0.41923E-08_JPRB,0.44278E-08_JPRB,0.44950E-08_JPRB /)  
KB(:,46, 9) = (/ &
 & 0.26814E-08_JPRB,0.33691E-08_JPRB,0.34101E-08_JPRB,0.34324E-08_JPRB,0.35321E-08_JPRB /)  
KB(:,47, 9) = (/ &
 & 0.21424E-08_JPRB,0.21249E-08_JPRB,0.27532E-08_JPRB,0.28475E-08_JPRB,0.25748E-08_JPRB /)  
KB(:,48, 9) = (/ &
 & 0.16514E-08_JPRB,0.18931E-08_JPRB,0.22507E-08_JPRB,0.22575E-08_JPRB,0.21238E-08_JPRB /)  
KB(:,49, 9) = (/ &
 & 0.12235E-08_JPRB,0.12503E-08_JPRB,0.16643E-08_JPRB,0.16742E-08_JPRB,0.16438E-08_JPRB /)  
KB(:,50, 9) = (/ &
 & 0.11340E-08_JPRB,0.11248E-08_JPRB,0.13120E-08_JPRB,0.13854E-08_JPRB,0.13503E-08_JPRB /)  
KB(:,51, 9) = (/ &
 & 0.79176E-09_JPRB,0.91681E-09_JPRB,0.99908E-09_JPRB,0.13532E-08_JPRB,0.10405E-08_JPRB /)  
KB(:,52, 9) = (/ &
 & 0.64785E-09_JPRB,0.57185E-09_JPRB,0.84784E-09_JPRB,0.90912E-09_JPRB,0.87721E-09_JPRB /)  
KB(:,53, 9) = (/ &
 & 0.51330E-09_JPRB,0.43209E-09_JPRB,0.61659E-09_JPRB,0.79798E-09_JPRB,0.65017E-09_JPRB /)  
KB(:,54, 9) = (/ &
 & 0.40227E-09_JPRB,0.45562E-09_JPRB,0.54691E-09_JPRB,0.63160E-09_JPRB,0.62902E-09_JPRB /)  
KB(:,55, 9) = (/ &
 & 0.44280E-09_JPRB,0.43833E-09_JPRB,0.48132E-09_JPRB,0.55748E-09_JPRB,0.72672E-09_JPRB /)  
KB(:,56, 9) = (/ &
 & 0.33767E-09_JPRB,0.43448E-09_JPRB,0.42774E-09_JPRB,0.52401E-09_JPRB,0.66273E-09_JPRB /)  
KB(:,57, 9) = (/ &
 & 0.40113E-09_JPRB,0.38794E-09_JPRB,0.46286E-09_JPRB,0.57261E-09_JPRB,0.60773E-09_JPRB /)  
KB(:,58, 9) = (/ &
 & 0.36624E-09_JPRB,0.52965E-09_JPRB,0.49530E-09_JPRB,0.54114E-09_JPRB,0.65708E-09_JPRB /)  
KB(:,59, 9) = (/ &
 & 0.52598E-09_JPRB,0.55940E-09_JPRB,0.70094E-09_JPRB,0.71749E-09_JPRB,0.81086E-09_JPRB /)  
KB(:,13,10) = (/ &
 & 0.75197E-05_JPRB,0.74908E-05_JPRB,0.74768E-05_JPRB,0.74579E-05_JPRB,0.74485E-05_JPRB /)  
KB(:,14,10) = (/ &
 & 0.62427E-05_JPRB,0.62400E-05_JPRB,0.62314E-05_JPRB,0.62357E-05_JPRB,0.62230E-05_JPRB /)  
KB(:,15,10) = (/ &
 & 0.51235E-05_JPRB,0.51220E-05_JPRB,0.51270E-05_JPRB,0.51388E-05_JPRB,0.51377E-05_JPRB /)  
KB(:,16,10) = (/ &
 & 0.36653E-05_JPRB,0.36812E-05_JPRB,0.36844E-05_JPRB,0.36893E-05_JPRB,0.37175E-05_JPRB /)  
KB(:,17,10) = (/ &
 & 0.10067E-05_JPRB,0.10571E-05_JPRB,0.10948E-05_JPRB,0.11331E-05_JPRB,0.11791E-05_JPRB /)  
KB(:,18,10) = (/ &
 & 0.37963E-07_JPRB,0.35028E-07_JPRB,0.38085E-07_JPRB,0.36252E-07_JPRB,0.39741E-07_JPRB /)  
KB(:,19,10) = (/ &
 & 0.58861E-07_JPRB,0.39909E-07_JPRB,0.43872E-07_JPRB,0.52963E-07_JPRB,0.37762E-07_JPRB /)  
KB(:,20,10) = (/ &
 & 0.65438E-07_JPRB,0.43429E-07_JPRB,0.52709E-07_JPRB,0.35811E-07_JPRB,0.59833E-07_JPRB /)  
KB(:,21,10) = (/ &
 & 0.50452E-07_JPRB,0.50995E-07_JPRB,0.40371E-07_JPRB,0.51145E-07_JPRB,0.52725E-07_JPRB /)  
KB(:,22,10) = (/ &
 & 0.42139E-07_JPRB,0.45011E-07_JPRB,0.61867E-07_JPRB,0.41292E-07_JPRB,0.37916E-07_JPRB /)  
KB(:,23,10) = (/ &
 & 0.30176E-07_JPRB,0.29856E-07_JPRB,0.39637E-07_JPRB,0.38957E-07_JPRB,0.64896E-07_JPRB /)  
KB(:,24,10) = (/ &
 & 0.36010E-07_JPRB,0.42155E-07_JPRB,0.32787E-07_JPRB,0.46750E-07_JPRB,0.46940E-07_JPRB /)  
KB(:,25,10) = (/ &
 & 0.34802E-07_JPRB,0.41607E-07_JPRB,0.40854E-07_JPRB,0.61643E-07_JPRB,0.53762E-07_JPRB /)  
KB(:,26,10) = (/ &
 & 0.41295E-07_JPRB,0.39697E-07_JPRB,0.46005E-07_JPRB,0.46334E-07_JPRB,0.53334E-07_JPRB /)  
KB(:,27,10) = (/ &
 & 0.61711E-07_JPRB,0.29641E-07_JPRB,0.51823E-07_JPRB,0.42625E-07_JPRB,0.36336E-07_JPRB /)  
KB(:,28,10) = (/ &
 & 0.45196E-07_JPRB,0.56637E-07_JPRB,0.31716E-07_JPRB,0.38569E-07_JPRB,0.45693E-07_JPRB /)  
KB(:,29,10) = (/ &
 & 0.47349E-07_JPRB,0.38492E-07_JPRB,0.26330E-07_JPRB,0.30953E-07_JPRB,0.33330E-07_JPRB /)  
KB(:,30,10) = (/ &
 & 0.20700E-07_JPRB,0.24999E-07_JPRB,0.19626E-07_JPRB,0.33645E-07_JPRB,0.21883E-07_JPRB /)  
KB(:,31,10) = (/ &
 & 0.31879E-07_JPRB,0.26245E-07_JPRB,0.28697E-07_JPRB,0.26867E-07_JPRB,0.26801E-07_JPRB /)  
KB(:,32,10) = (/ &
 & 0.29616E-07_JPRB,0.18927E-07_JPRB,0.18903E-07_JPRB,0.14917E-07_JPRB,0.25602E-07_JPRB /)  
KB(:,33,10) = (/ &
 & 0.22437E-07_JPRB,0.26260E-07_JPRB,0.17262E-07_JPRB,0.13354E-07_JPRB,0.18413E-07_JPRB /)  
KB(:,34,10) = (/ &
 & 0.15957E-07_JPRB,0.11226E-07_JPRB,0.16852E-07_JPRB,0.11987E-07_JPRB,0.14358E-07_JPRB /)  
KB(:,35,10) = (/ &
 & 0.11233E-07_JPRB,0.90736E-08_JPRB,0.13960E-07_JPRB,0.76472E-08_JPRB,0.11733E-07_JPRB /)  
KB(:,36,10) = (/ &
 & 0.13919E-07_JPRB,0.10081E-07_JPRB,0.10035E-07_JPRB,0.10345E-07_JPRB,0.10622E-07_JPRB /)  
KB(:,37,10) = (/ &
 & 0.76780E-08_JPRB,0.12331E-07_JPRB,0.10794E-07_JPRB,0.16023E-07_JPRB,0.11524E-07_JPRB /)  
KB(:,38,10) = (/ &
 & 0.65416E-08_JPRB,0.97484E-08_JPRB,0.12132E-07_JPRB,0.10472E-07_JPRB,0.11363E-07_JPRB /)  
KB(:,39,10) = (/ &
 & 0.78511E-08_JPRB,0.70392E-08_JPRB,0.91444E-08_JPRB,0.84352E-08_JPRB,0.95946E-08_JPRB /)  
KB(:,40,10) = (/ &
 & 0.81878E-08_JPRB,0.94957E-08_JPRB,0.84996E-08_JPRB,0.11246E-07_JPRB,0.13024E-07_JPRB /)  
KB(:,41,10) = (/ &
 & 0.65901E-08_JPRB,0.80717E-08_JPRB,0.78357E-08_JPRB,0.67309E-08_JPRB,0.85966E-08_JPRB /)  
KB(:,42,10) = (/ &
 & 0.64210E-08_JPRB,0.59979E-08_JPRB,0.56936E-08_JPRB,0.70018E-08_JPRB,0.70433E-08_JPRB /)  
KB(:,43,10) = (/ &
 & 0.40388E-08_JPRB,0.71452E-08_JPRB,0.63548E-08_JPRB,0.84902E-08_JPRB,0.75828E-08_JPRB /)  
KB(:,44,10) = (/ &
 & 0.39142E-08_JPRB,0.55915E-08_JPRB,0.49863E-08_JPRB,0.52254E-08_JPRB,0.62790E-08_JPRB /)  
KB(:,45,10) = (/ &
 & 0.42931E-08_JPRB,0.31608E-08_JPRB,0.46572E-08_JPRB,0.47490E-08_JPRB,0.59912E-08_JPRB /)  
KB(:,46,10) = (/ &
 & 0.38722E-08_JPRB,0.16146E-08_JPRB,0.40010E-08_JPRB,0.24242E-08_JPRB,0.45711E-08_JPRB /)  
KB(:,47,10) = (/ &
 & 0.14942E-08_JPRB,0.28671E-08_JPRB,0.27168E-08_JPRB,0.40090E-08_JPRB,0.42343E-08_JPRB /)  
KB(:,48,10) = (/ &
 & 0.11911E-08_JPRB,0.13582E-08_JPRB,0.26580E-08_JPRB,0.29275E-08_JPRB,0.17855E-08_JPRB /)  
KB(:,49,10) = (/ &
 & 0.14130E-08_JPRB,0.10553E-08_JPRB,0.10543E-08_JPRB,0.11428E-08_JPRB,0.14141E-08_JPRB /)  
KB(:,50,10) = (/ &
 & 0.12182E-08_JPRB,0.14973E-08_JPRB,0.13182E-08_JPRB,0.84197E-09_JPRB,0.12115E-08_JPRB /)  
KB(:,51,10) = (/ &
 & 0.81227E-09_JPRB,0.90496E-09_JPRB,0.77903E-09_JPRB,0.83007E-09_JPRB,0.86051E-09_JPRB /)  
KB(:,52,10) = (/ &
 & 0.96715E-09_JPRB,0.52504E-09_JPRB,0.42702E-09_JPRB,0.99435E-09_JPRB,0.91829E-09_JPRB /)  
KB(:,53,10) = (/ &
 & 0.37232E-09_JPRB,0.22359E-09_JPRB,0.89279E-09_JPRB,0.85173E-09_JPRB,0.51790E-09_JPRB /)  
KB(:,54,10) = (/ &
 & 0.34402E-09_JPRB,0.40116E-09_JPRB,0.54696E-09_JPRB,0.50848E-09_JPRB,0.53123E-09_JPRB /)  
KB(:,55,10) = (/ &
 & 0.66100E-09_JPRB,0.65370E-09_JPRB,0.58427E-09_JPRB,0.74840E-09_JPRB,0.49778E-09_JPRB /)  
KB(:,56,10) = (/ &
 & 0.43138E-09_JPRB,0.39155E-09_JPRB,0.52944E-09_JPRB,0.58374E-09_JPRB,0.77481E-09_JPRB /)  
KB(:,57,10) = (/ &
 & 0.48190E-09_JPRB,0.37726E-09_JPRB,0.54783E-09_JPRB,0.43462E-09_JPRB,0.46295E-09_JPRB /)  
KB(:,58,10) = (/ &
 & 0.42276E-09_JPRB,0.62831E-09_JPRB,0.68493E-09_JPRB,0.49089E-09_JPRB,0.43799E-09_JPRB /)  
KB(:,59,10) = (/ &
 & 0.37023E-09_JPRB,0.90764E-09_JPRB,0.36527E-09_JPRB,0.99235E-09_JPRB,0.10719E-08_JPRB /)  
KB(:,13,11) = (/ &
 & 0.15119E-04_JPRB,0.15135E-04_JPRB,0.15140E-04_JPRB,0.15181E-04_JPRB,0.15209E-04_JPRB /)  
KB(:,14,11) = (/ &
 & 0.12807E-04_JPRB,0.12837E-04_JPRB,0.12873E-04_JPRB,0.12938E-04_JPRB,0.12999E-04_JPRB /)  
KB(:,15,11) = (/ &
 & 0.10789E-04_JPRB,0.10839E-04_JPRB,0.10921E-04_JPRB,0.10986E-04_JPRB,0.11078E-04_JPRB /)  
KB(:,16,11) = (/ &
 & 0.90472E-05_JPRB,0.91077E-05_JPRB,0.91930E-05_JPRB,0.92812E-05_JPRB,0.93959E-05_JPRB /)  
KB(:,17,11) = (/ &
 & 0.74085E-05_JPRB,0.75116E-05_JPRB,0.76103E-05_JPRB,0.77238E-05_JPRB,0.78364E-05_JPRB /)  
KB(:,18,11) = (/ &
 & 0.47863E-05_JPRB,0.49607E-05_JPRB,0.51634E-05_JPRB,0.53824E-05_JPRB,0.55724E-05_JPRB /)  
KB(:,19,11) = (/ &
 & 0.17849E-05_JPRB,0.19797E-05_JPRB,0.21641E-05_JPRB,0.23597E-05_JPRB,0.26015E-05_JPRB /)  
KB(:,20,11) = (/ &
 & 0.14011E-06_JPRB,0.26424E-06_JPRB,0.39902E-06_JPRB,0.56382E-06_JPRB,0.75666E-06_JPRB /)  
KB(:,21,11) = (/ &
 & 0.32681E-07_JPRB,0.30855E-07_JPRB,0.23688E-07_JPRB,0.28954E-07_JPRB,0.30262E-07_JPRB /)  
KB(:,22,11) = (/ &
 & 0.39000E-07_JPRB,0.34641E-07_JPRB,0.36220E-07_JPRB,0.29230E-07_JPRB,0.25365E-07_JPRB /)  
KB(:,23,11) = (/ &
 & 0.39936E-07_JPRB,0.40586E-07_JPRB,0.26460E-07_JPRB,0.13886E-07_JPRB,0.18108E-07_JPRB /)  
KB(:,24,11) = (/ &
 & 0.34546E-07_JPRB,0.30818E-07_JPRB,0.33243E-07_JPRB,0.31408E-07_JPRB,0.37755E-07_JPRB /)  
KB(:,25,11) = (/ &
 & 0.36078E-07_JPRB,0.45586E-07_JPRB,0.18117E-07_JPRB,0.20176E-07_JPRB,0.46256E-07_JPRB /)  
KB(:,26,11) = (/ &
 & 0.61382E-07_JPRB,0.31185E-07_JPRB,0.38578E-07_JPRB,0.18908E-07_JPRB,0.43919E-07_JPRB /)  
KB(:,27,11) = (/ &
 & 0.37585E-07_JPRB,0.28323E-07_JPRB,0.45638E-07_JPRB,0.34261E-07_JPRB,0.26227E-07_JPRB /)  
KB(:,28,11) = (/ &
 & 0.41226E-07_JPRB,0.24793E-07_JPRB,0.23296E-07_JPRB,0.20952E-07_JPRB,0.27899E-07_JPRB /)  
KB(:,29,11) = (/ &
 & 0.21318E-07_JPRB,0.23768E-07_JPRB,0.39220E-07_JPRB,0.28896E-07_JPRB,0.15703E-07_JPRB /)  
KB(:,30,11) = (/ &
 & 0.25522E-07_JPRB,0.29485E-07_JPRB,0.39326E-07_JPRB,0.29293E-07_JPRB,0.36529E-07_JPRB /)  
KB(:,31,11) = (/ &
 & 0.14494E-07_JPRB,0.25417E-07_JPRB,0.13732E-07_JPRB,0.97827E-08_JPRB,0.20014E-07_JPRB /)  
KB(:,32,11) = (/ &
 & 0.14101E-07_JPRB,0.26239E-07_JPRB,0.22312E-07_JPRB,0.10163E-07_JPRB,0.17547E-07_JPRB /)  
KB(:,33,11) = (/ &
 & 0.17347E-07_JPRB,0.17261E-07_JPRB,0.13014E-07_JPRB,0.21130E-07_JPRB,0.31576E-08_JPRB /)  
KB(:,34,11) = (/ &
 & 0.11923E-07_JPRB,0.13818E-07_JPRB,0.14692E-07_JPRB,0.14120E-07_JPRB,0.12000E-07_JPRB /)  
KB(:,35,11) = (/ &
 & 0.86917E-08_JPRB,0.10083E-07_JPRB,0.11872E-07_JPRB,0.58578E-08_JPRB,0.13194E-07_JPRB /)  
KB(:,36,11) = (/ &
 & 0.74538E-08_JPRB,0.94606E-08_JPRB,0.85633E-08_JPRB,0.15394E-07_JPRB,0.81997E-08_JPRB /)  
KB(:,37,11) = (/ &
 & 0.59982E-08_JPRB,0.58805E-08_JPRB,0.92255E-08_JPRB,0.69472E-08_JPRB,0.63632E-08_JPRB /)  
KB(:,38,11) = (/ &
 & 0.75481E-08_JPRB,0.82094E-08_JPRB,0.10405E-07_JPRB,0.62921E-08_JPRB,0.70021E-08_JPRB /)  
KB(:,39,11) = (/ &
 & 0.65770E-08_JPRB,0.73715E-08_JPRB,0.70899E-08_JPRB,0.49884E-08_JPRB,0.73567E-08_JPRB /)  
KB(:,40,11) = (/ &
 & 0.62200E-08_JPRB,0.79227E-08_JPRB,0.65710E-08_JPRB,0.35793E-08_JPRB,0.48653E-08_JPRB /)  
KB(:,41,11) = (/ &
 & 0.67810E-08_JPRB,0.64933E-08_JPRB,0.26651E-08_JPRB,0.71067E-08_JPRB,0.42136E-08_JPRB /)  
KB(:,42,11) = (/ &
 & 0.32351E-08_JPRB,0.79993E-08_JPRB,0.25727E-08_JPRB,0.70581E-08_JPRB,0.58932E-08_JPRB /)  
KB(:,43,11) = (/ &
 & 0.54331E-08_JPRB,0.21653E-08_JPRB,0.69372E-08_JPRB,0.30142E-08_JPRB,0.23071E-07_JPRB /)  
KB(:,44,11) = (/ &
 & 0.26834E-08_JPRB,0.43047E-08_JPRB,0.44246E-08_JPRB,0.29474E-08_JPRB,0.52315E-07_JPRB /)  
KB(:,45,11) = (/ &
 & 0.22521E-08_JPRB,0.21920E-08_JPRB,0.35952E-08_JPRB,0.29799E-08_JPRB,0.81164E-07_JPRB /)  
KB(:,46,11) = (/ &
 & 0.28580E-08_JPRB,0.12605E-08_JPRB,0.64390E-09_JPRB,0.24255E-07_JPRB,0.96879E-07_JPRB /)  
KB(:,47,11) = (/ &
 & 0.13005E-08_JPRB,0.17967E-08_JPRB,0.21618E-08_JPRB,0.30225E-07_JPRB,0.10319E-06_JPRB /)  
KB(:,48,11) = (/ &
 & 0.13676E-08_JPRB,0.96043E-09_JPRB,0.14275E-08_JPRB,0.39735E-07_JPRB,0.11261E-06_JPRB /)  
KB(:,49,11) = (/ &
 & 0.79619E-09_JPRB,0.85338E-09_JPRB,0.14300E-08_JPRB,0.51821E-07_JPRB,0.12169E-06_JPRB /)  
KB(:,50,11) = (/ &
 & 0.49284E-09_JPRB,0.21801E-09_JPRB,0.75017E-08_JPRB,0.50308E-07_JPRB,0.11953E-06_JPRB /)  
KB(:,51,11) = (/ &
 & 0.51956E-09_JPRB,0.59927E-09_JPRB,0.87276E-08_JPRB,0.45028E-07_JPRB,0.11141E-06_JPRB /)  
KB(:,52,11) = (/ &
 & 0.35814E-09_JPRB,0.78982E-09_JPRB,0.10205E-07_JPRB,0.45574E-07_JPRB,0.10332E-06_JPRB /)  
KB(:,53,11) = (/ &
 & 0.69729E-09_JPRB,0.23757E-09_JPRB,0.11741E-07_JPRB,0.45086E-07_JPRB,0.98023E-07_JPRB /)  
KB(:,54,11) = (/ &
 & 0.38203E-09_JPRB,0.28792E-09_JPRB,0.72239E-08_JPRB,0.35770E-07_JPRB,0.80771E-07_JPRB /)  
KB(:,55,11) = (/ &
 & 0.33870E-09_JPRB,0.39698E-09_JPRB,0.15883E-08_JPRB,0.22568E-07_JPRB,0.61465E-07_JPRB /)  
KB(:,56,11) = (/ &
 & 0.50424E-09_JPRB,0.25383E-09_JPRB,0.46226E-09_JPRB,0.12214E-07_JPRB,0.43776E-07_JPRB /)  
KB(:,57,11) = (/ &
 & 0.18824E-09_JPRB,0.14340E-09_JPRB,0.96547E-10_JPRB,0.36771E-08_JPRB,0.28437E-07_JPRB /)  
KB(:,58,11) = (/ &
 & 0.53960E-09_JPRB,0.71198E-09_JPRB,0.40290E-09_JPRB,0.38600E-09_JPRB,0.14449E-07_JPRB /)  
KB(:,59,11) = (/ &
 & 0.64570E-09_JPRB,0.80856E-09_JPRB,0.54439E-09_JPRB,0.66021E-09_JPRB,0.28306E-09_JPRB /)  
KB(:,13,12) = (/ &
 & 0.35137E-04_JPRB,0.35315E-04_JPRB,0.35473E-04_JPRB,0.35691E-04_JPRB,0.35953E-04_JPRB /)  
KB(:,14,12) = (/ &
 & 0.30387E-04_JPRB,0.30535E-04_JPRB,0.30693E-04_JPRB,0.30906E-04_JPRB,0.31121E-04_JPRB /)  
KB(:,15,12) = (/ &
 & 0.26404E-04_JPRB,0.26560E-04_JPRB,0.26776E-04_JPRB,0.26963E-04_JPRB,0.27157E-04_JPRB /)  
KB(:,16,12) = (/ &
 & 0.22908E-04_JPRB,0.23161E-04_JPRB,0.23420E-04_JPRB,0.23636E-04_JPRB,0.23864E-04_JPRB /)  
KB(:,17,12) = (/ &
 & 0.19849E-04_JPRB,0.20170E-04_JPRB,0.20453E-04_JPRB,0.20723E-04_JPRB,0.21011E-04_JPRB /)  
KB(:,18,12) = (/ &
 & 0.17158E-04_JPRB,0.17516E-04_JPRB,0.17820E-04_JPRB,0.18149E-04_JPRB,0.18467E-04_JPRB /)  
KB(:,19,12) = (/ &
 & 0.14706E-04_JPRB,0.15074E-04_JPRB,0.15426E-04_JPRB,0.15809E-04_JPRB,0.16128E-04_JPRB /)  
KB(:,20,12) = (/ &
 & 0.12200E-04_JPRB,0.12654E-04_JPRB,0.13122E-04_JPRB,0.13561E-04_JPRB,0.13942E-04_JPRB /)  
KB(:,21,12) = (/ &
 & 0.88744E-05_JPRB,0.95294E-05_JPRB,0.10194E-04_JPRB,0.10811E-04_JPRB,0.11447E-04_JPRB /)  
KB(:,22,12) = (/ &
 & 0.63063E-05_JPRB,0.69160E-05_JPRB,0.75170E-05_JPRB,0.81696E-05_JPRB,0.87829E-05_JPRB /)  
KB(:,23,12) = (/ &
 & 0.42549E-05_JPRB,0.48576E-05_JPRB,0.54224E-05_JPRB,0.60649E-05_JPRB,0.65852E-05_JPRB /)  
KB(:,24,12) = (/ &
 & 0.26155E-05_JPRB,0.31537E-05_JPRB,0.36816E-05_JPRB,0.42795E-05_JPRB,0.47356E-05_JPRB /)  
KB(:,25,12) = (/ &
 & 0.14576E-05_JPRB,0.18762E-05_JPRB,0.23875E-05_JPRB,0.29308E-05_JPRB,0.33846E-05_JPRB /)  
KB(:,26,12) = (/ &
 & 0.67369E-06_JPRB,0.10096E-05_JPRB,0.14730E-05_JPRB,0.19592E-05_JPRB,0.24356E-05_JPRB /)  
KB(:,27,12) = (/ &
 & 0.27240E-06_JPRB,0.59733E-06_JPRB,0.98553E-06_JPRB,0.13968E-05_JPRB,0.18466E-05_JPRB /)  
KB(:,28,12) = (/ &
 & 0.81179E-07_JPRB,0.35063E-06_JPRB,0.74692E-06_JPRB,0.11081E-05_JPRB,0.15613E-05_JPRB /)  
KB(:,29,12) = (/ &
 & 0.94800E-07_JPRB,0.40513E-06_JPRB,0.73547E-06_JPRB,0.10914E-05_JPRB,0.16188E-05_JPRB /)  
KB(:,30,12) = (/ &
 & 0.19045E-06_JPRB,0.51192E-06_JPRB,0.80594E-06_JPRB,0.12694E-05_JPRB,0.16954E-05_JPRB /)  
KB(:,31,12) = (/ &
 & 0.38493E-06_JPRB,0.71230E-06_JPRB,0.11392E-05_JPRB,0.15875E-05_JPRB,0.20565E-05_JPRB /)  
KB(:,32,12) = (/ &
 & 0.61444E-06_JPRB,0.97779E-06_JPRB,0.14257E-05_JPRB,0.18883E-05_JPRB,0.26649E-05_JPRB /)  
KB(:,33,12) = (/ &
 & 0.84230E-06_JPRB,0.12390E-05_JPRB,0.17304E-05_JPRB,0.23322E-05_JPRB,0.32859E-05_JPRB /)  
KB(:,34,12) = (/ &
 & 0.10458E-05_JPRB,0.14709E-05_JPRB,0.19634E-05_JPRB,0.28004E-05_JPRB,0.37724E-05_JPRB /)  
KB(:,35,12) = (/ &
 & 0.11901E-05_JPRB,0.16306E-05_JPRB,0.22411E-05_JPRB,0.31089E-05_JPRB,0.41007E-05_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART15',1,ZHOOK_HANDLE)
END SUBROUTINE PART15


SUBROUTINE PART16

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART16',0,ZHOOK_HANDLE)


KB(:,36,12) = (/ &
 & 0.12859E-05_JPRB,0.17604E-05_JPRB,0.24414E-05_JPRB,0.32964E-05_JPRB,0.43267E-05_JPRB /)  
KB(:,37,12) = (/ &
 & 0.13015E-05_JPRB,0.17577E-05_JPRB,0.24562E-05_JPRB,0.33117E-05_JPRB,0.43238E-05_JPRB /)  
KB(:,38,12) = (/ &
 & 0.13522E-05_JPRB,0.18247E-05_JPRB,0.25116E-05_JPRB,0.33483E-05_JPRB,0.43352E-05_JPRB /)  
KB(:,39,12) = (/ &
 & 0.14322E-05_JPRB,0.19336E-05_JPRB,0.26107E-05_JPRB,0.34258E-05_JPRB,0.44158E-05_JPRB /)  
KB(:,40,12) = (/ &
 & 0.14006E-05_JPRB,0.18728E-05_JPRB,0.25304E-05_JPRB,0.33179E-05_JPRB,0.42738E-05_JPRB /)  
KB(:,41,12) = (/ &
 & 0.13551E-05_JPRB,0.18012E-05_JPRB,0.24357E-05_JPRB,0.32084E-05_JPRB,0.41141E-05_JPRB /)  
KB(:,42,12) = (/ &
 & 0.13297E-05_JPRB,0.17512E-05_JPRB,0.23561E-05_JPRB,0.30946E-05_JPRB,0.39665E-05_JPRB /)  
KB(:,43,12) = (/ &
 & 0.12687E-05_JPRB,0.16768E-05_JPRB,0.22464E-05_JPRB,0.29540E-05_JPRB,0.37527E-05_JPRB /)  
KB(:,44,12) = (/ &
 & 0.12099E-05_JPRB,0.15968E-05_JPRB,0.21385E-05_JPRB,0.28006E-05_JPRB,0.35240E-05_JPRB /)  
KB(:,45,12) = (/ &
 & 0.11534E-05_JPRB,0.15243E-05_JPRB,0.20279E-05_JPRB,0.26581E-05_JPRB,0.33062E-05_JPRB /)  
KB(:,46,12) = (/ &
 & 0.10898E-05_JPRB,0.14434E-05_JPRB,0.19097E-05_JPRB,0.24739E-05_JPRB,0.30807E-05_JPRB /)  
KB(:,47,12) = (/ &
 & 0.10111E-05_JPRB,0.13412E-05_JPRB,0.17607E-05_JPRB,0.22724E-05_JPRB,0.28391E-05_JPRB /)  
KB(:,48,12) = (/ &
 & 0.92540E-06_JPRB,0.12447E-05_JPRB,0.16295E-05_JPRB,0.20863E-05_JPRB,0.26097E-05_JPRB /)  
KB(:,49,12) = (/ &
 & 0.84684E-06_JPRB,0.11506E-05_JPRB,0.15141E-05_JPRB,0.19160E-05_JPRB,0.23957E-05_JPRB /)  
KB(:,50,12) = (/ &
 & 0.76391E-06_JPRB,0.10519E-05_JPRB,0.13910E-05_JPRB,0.17635E-05_JPRB,0.22060E-05_JPRB /)  
KB(:,51,12) = (/ &
 & 0.68139E-06_JPRB,0.95640E-06_JPRB,0.12771E-05_JPRB,0.16252E-05_JPRB,0.20363E-05_JPRB /)  
KB(:,52,12) = (/ &
 & 0.60392E-06_JPRB,0.86706E-06_JPRB,0.11671E-05_JPRB,0.14940E-05_JPRB,0.18793E-05_JPRB /)  
KB(:,53,12) = (/ &
 & 0.53856E-06_JPRB,0.78259E-06_JPRB,0.10620E-05_JPRB,0.13737E-05_JPRB,0.17330E-05_JPRB /)  
KB(:,54,12) = (/ &
 & 0.46919E-06_JPRB,0.69589E-06_JPRB,0.96582E-06_JPRB,0.12666E-05_JPRB,0.16070E-05_JPRB /)  
KB(:,55,12) = (/ &
 & 0.40013E-06_JPRB,0.61215E-06_JPRB,0.87450E-06_JPRB,0.11663E-05_JPRB,0.14929E-05_JPRB /)  
KB(:,56,12) = (/ &
 & 0.33987E-06_JPRB,0.53286E-06_JPRB,0.78520E-06_JPRB,0.10697E-05_JPRB,0.13857E-05_JPRB /)  
KB(:,57,12) = (/ &
 & 0.28415E-06_JPRB,0.45936E-06_JPRB,0.69784E-06_JPRB,0.97544E-06_JPRB,0.12829E-05_JPRB /)  
KB(:,58,12) = (/ &
 & 0.23457E-06_JPRB,0.39019E-06_JPRB,0.61528E-06_JPRB,0.88439E-06_JPRB,0.11866E-05_JPRB /)  
KB(:,59,12) = (/ &
 & 0.19576E-06_JPRB,0.34385E-06_JPRB,0.56055E-06_JPRB,0.82347E-06_JPRB,0.11274E-05_JPRB /)  
KB(:,13,13) = (/ &
 & 0.12143E-03_JPRB,0.12308E-03_JPRB,0.12512E-03_JPRB,0.12699E-03_JPRB,0.12910E-03_JPRB /)  
KB(:,14,13) = (/ &
 & 0.10385E-03_JPRB,0.10569E-03_JPRB,0.10770E-03_JPRB,0.10972E-03_JPRB,0.11214E-03_JPRB /)  
KB(:,15,13) = (/ &
 & 0.88944E-04_JPRB,0.90837E-04_JPRB,0.92688E-04_JPRB,0.94910E-04_JPRB,0.97472E-04_JPRB /)  
KB(:,16,13) = (/ &
 & 0.76542E-04_JPRB,0.78268E-04_JPRB,0.80179E-04_JPRB,0.82469E-04_JPRB,0.84734E-04_JPRB /)  
KB(:,17,13) = (/ &
 & 0.66332E-04_JPRB,0.67885E-04_JPRB,0.69742E-04_JPRB,0.71831E-04_JPRB,0.74034E-04_JPRB /)  
KB(:,18,13) = (/ &
 & 0.57811E-04_JPRB,0.59251E-04_JPRB,0.61096E-04_JPRB,0.62954E-04_JPRB,0.65175E-04_JPRB /)  
KB(:,19,13) = (/ &
 & 0.50669E-04_JPRB,0.52124E-04_JPRB,0.53790E-04_JPRB,0.55608E-04_JPRB,0.57861E-04_JPRB /)  
KB(:,20,13) = (/ &
 & 0.44810E-04_JPRB,0.46258E-04_JPRB,0.47774E-04_JPRB,0.49573E-04_JPRB,0.51715E-04_JPRB /)  
KB(:,21,13) = (/ &
 & 0.40009E-04_JPRB,0.41361E-04_JPRB,0.42755E-04_JPRB,0.44560E-04_JPRB,0.46559E-04_JPRB /)  
KB(:,22,13) = (/ &
 & 0.36116E-04_JPRB,0.37297E-04_JPRB,0.38718E-04_JPRB,0.40472E-04_JPRB,0.42441E-04_JPRB /)  
KB(:,23,13) = (/ &
 & 0.32736E-04_JPRB,0.33861E-04_JPRB,0.35361E-04_JPRB,0.37075E-04_JPRB,0.39134E-04_JPRB /)  
KB(:,24,13) = (/ &
 & 0.29883E-04_JPRB,0.31056E-04_JPRB,0.32552E-04_JPRB,0.34296E-04_JPRB,0.36499E-04_JPRB /)  
KB(:,25,13) = (/ &
 & 0.27373E-04_JPRB,0.28693E-04_JPRB,0.30179E-04_JPRB,0.32033E-04_JPRB,0.34358E-04_JPRB /)  
KB(:,26,13) = (/ &
 & 0.25273E-04_JPRB,0.26749E-04_JPRB,0.28306E-04_JPRB,0.30341E-04_JPRB,0.32793E-04_JPRB /)  
KB(:,27,13) = (/ &
 & 0.23652E-04_JPRB,0.25175E-04_JPRB,0.26905E-04_JPRB,0.29145E-04_JPRB,0.31814E-04_JPRB /)  
KB(:,28,13) = (/ &
 & 0.22453E-04_JPRB,0.24077E-04_JPRB,0.26031E-04_JPRB,0.28419E-04_JPRB,0.31259E-04_JPRB /)  
KB(:,29,13) = (/ &
 & 0.21794E-04_JPRB,0.23553E-04_JPRB,0.25672E-04_JPRB,0.28266E-04_JPRB,0.31243E-04_JPRB /)  
KB(:,30,13) = (/ &
 & 0.21501E-04_JPRB,0.23414E-04_JPRB,0.25687E-04_JPRB,0.28389E-04_JPRB,0.31547E-04_JPRB /)  
KB(:,31,13) = (/ &
 & 0.21532E-04_JPRB,0.23577E-04_JPRB,0.25947E-04_JPRB,0.28793E-04_JPRB,0.32070E-04_JPRB /)  
KB(:,32,13) = (/ &
 & 0.21702E-04_JPRB,0.23850E-04_JPRB,0.26365E-04_JPRB,0.29337E-04_JPRB,0.32730E-04_JPRB /)  
KB(:,33,13) = (/ &
 & 0.21999E-04_JPRB,0.24243E-04_JPRB,0.26895E-04_JPRB,0.29970E-04_JPRB,0.33492E-04_JPRB /)  
KB(:,34,13) = (/ &
 & 0.22272E-04_JPRB,0.24615E-04_JPRB,0.27365E-04_JPRB,0.30535E-04_JPRB,0.34149E-04_JPRB /)  
KB(:,35,13) = (/ &
 & 0.22408E-04_JPRB,0.24786E-04_JPRB,0.27609E-04_JPRB,0.30838E-04_JPRB,0.34518E-04_JPRB /)  
KB(:,36,13) = (/ &
 & 0.22324E-04_JPRB,0.24717E-04_JPRB,0.27535E-04_JPRB,0.30781E-04_JPRB,0.34466E-04_JPRB /)  
KB(:,37,13) = (/ &
 & 0.21914E-04_JPRB,0.24278E-04_JPRB,0.27037E-04_JPRB,0.30223E-04_JPRB,0.33847E-04_JPRB /)  
KB(:,38,13) = (/ &
 & 0.21518E-04_JPRB,0.23846E-04_JPRB,0.26529E-04_JPRB,0.29664E-04_JPRB,0.33219E-04_JPRB /)  
KB(:,39,13) = (/ &
 & 0.21138E-04_JPRB,0.23443E-04_JPRB,0.26064E-04_JPRB,0.29132E-04_JPRB,0.32628E-04_JPRB /)  
KB(:,40,13) = (/ &
 & 0.20535E-04_JPRB,0.22813E-04_JPRB,0.25328E-04_JPRB,0.28289E-04_JPRB,0.31682E-04_JPRB /)  
KB(:,41,13) = (/ &
 & 0.19918E-04_JPRB,0.22174E-04_JPRB,0.24598E-04_JPRB,0.27447E-04_JPRB,0.30722E-04_JPRB /)  
KB(:,42,13) = (/ &
 & 0.19309E-04_JPRB,0.21550E-04_JPRB,0.23909E-04_JPRB,0.26639E-04_JPRB,0.29801E-04_JPRB /)  
KB(:,43,13) = (/ &
 & 0.18566E-04_JPRB,0.20812E-04_JPRB,0.23112E-04_JPRB,0.25700E-04_JPRB,0.28732E-04_JPRB /)  
KB(:,44,13) = (/ &
 & 0.17767E-04_JPRB,0.20035E-04_JPRB,0.22299E-04_JPRB,0.24756E-04_JPRB,0.27639E-04_JPRB /)  
KB(:,45,13) = (/ &
 & 0.16962E-04_JPRB,0.19260E-04_JPRB,0.21500E-04_JPRB,0.23864E-04_JPRB,0.26597E-04_JPRB /)  
KB(:,46,13) = (/ &
 & 0.16086E-04_JPRB,0.18421E-04_JPRB,0.20671E-04_JPRB,0.22972E-04_JPRB,0.25545E-04_JPRB /)  
KB(:,47,13) = (/ &
 & 0.15115E-04_JPRB,0.17481E-04_JPRB,0.19766E-04_JPRB,0.22019E-04_JPRB,0.24442E-04_JPRB /)  
KB(:,48,13) = (/ &
 & 0.14158E-04_JPRB,0.16526E-04_JPRB,0.18843E-04_JPRB,0.21088E-04_JPRB,0.23419E-04_JPRB /)  
KB(:,49,13) = (/ &
 & 0.13195E-04_JPRB,0.15552E-04_JPRB,0.17911E-04_JPRB,0.20179E-04_JPRB,0.22454E-04_JPRB /)  
KB(:,50,13) = (/ &
 & 0.12314E-04_JPRB,0.14653E-04_JPRB,0.17032E-04_JPRB,0.19326E-04_JPRB,0.21576E-04_JPRB /)  
KB(:,51,13) = (/ &
 & 0.11480E-04_JPRB,0.13788E-04_JPRB,0.16154E-04_JPRB,0.18484E-04_JPRB,0.20739E-04_JPRB /)  
KB(:,52,13) = (/ &
 & 0.10629E-04_JPRB,0.12922E-04_JPRB,0.15279E-04_JPRB,0.17642E-04_JPRB,0.19921E-04_JPRB /)  
KB(:,53,13) = (/ &
 & 0.97710E-05_JPRB,0.12082E-04_JPRB,0.14410E-04_JPRB,0.16788E-04_JPRB,0.19091E-04_JPRB /)  
KB(:,54,13) = (/ &
 & 0.90074E-05_JPRB,0.11316E-04_JPRB,0.13617E-04_JPRB,0.15981E-04_JPRB,0.18321E-04_JPRB /)  
KB(:,55,13) = (/ &
 & 0.83042E-05_JPRB,0.10569E-04_JPRB,0.12859E-04_JPRB,0.15214E-04_JPRB,0.17581E-04_JPRB /)  
KB(:,56,13) = (/ &
 & 0.76202E-05_JPRB,0.98296E-05_JPRB,0.12125E-04_JPRB,0.14457E-04_JPRB,0.16835E-04_JPRB /)  
KB(:,57,13) = (/ &
 & 0.69561E-05_JPRB,0.91024E-05_JPRB,0.11398E-04_JPRB,0.13700E-04_JPRB,0.16068E-04_JPRB /)  
KB(:,58,13) = (/ &
 & 0.63426E-05_JPRB,0.84347E-05_JPRB,0.10695E-04_JPRB,0.12984E-04_JPRB,0.15340E-04_JPRB /)  
KB(:,59,13) = (/ &
 & 0.61056E-05_JPRB,0.81719E-05_JPRB,0.10410E-04_JPRB,0.12698E-04_JPRB,0.15054E-04_JPRB /)  
KB(:,13,14) = (/ &
 & 0.69692E-03_JPRB,0.71516E-03_JPRB,0.73378E-03_JPRB,0.75443E-03_JPRB,0.77716E-03_JPRB /)  
KB(:,14,14) = (/ &
 & 0.64436E-03_JPRB,0.66211E-03_JPRB,0.68199E-03_JPRB,0.70460E-03_JPRB,0.72891E-03_JPRB /)  
KB(:,15,14) = (/ &
 & 0.59775E-03_JPRB,0.61618E-03_JPRB,0.63785E-03_JPRB,0.66198E-03_JPRB,0.68803E-03_JPRB /)  
KB(:,16,14) = (/ &
 & 0.55668E-03_JPRB,0.57752E-03_JPRB,0.60052E-03_JPRB,0.62615E-03_JPRB,0.65391E-03_JPRB /)  
KB(:,17,14) = (/ &
 & 0.52104E-03_JPRB,0.54458E-03_JPRB,0.56934E-03_JPRB,0.59627E-03_JPRB,0.62539E-03_JPRB /)  
KB(:,18,14) = (/ &
 & 0.49086E-03_JPRB,0.51685E-03_JPRB,0.54337E-03_JPRB,0.57147E-03_JPRB,0.60182E-03_JPRB /)  
KB(:,19,14) = (/ &
 & 0.46544E-03_JPRB,0.49373E-03_JPRB,0.52192E-03_JPRB,0.55124E-03_JPRB,0.58277E-03_JPRB /)  
KB(:,20,14) = (/ &
 & 0.44496E-03_JPRB,0.47526E-03_JPRB,0.50494E-03_JPRB,0.53564E-03_JPRB,0.56857E-03_JPRB /)  
KB(:,21,14) = (/ &
 & 0.42855E-03_JPRB,0.46070E-03_JPRB,0.49202E-03_JPRB,0.52375E-03_JPRB,0.55795E-03_JPRB /)  
KB(:,22,14) = (/ &
 & 0.41783E-03_JPRB,0.45160E-03_JPRB,0.48421E-03_JPRB,0.51739E-03_JPRB,0.55269E-03_JPRB /)  
KB(:,23,14) = (/ &
 & 0.41085E-03_JPRB,0.44564E-03_JPRB,0.47947E-03_JPRB,0.51389E-03_JPRB,0.55016E-03_JPRB /)  
KB(:,24,14) = (/ &
 & 0.40699E-03_JPRB,0.44263E-03_JPRB,0.47766E-03_JPRB,0.51290E-03_JPRB,0.55008E-03_JPRB /)  
KB(:,25,14) = (/ &
 & 0.40592E-03_JPRB,0.44215E-03_JPRB,0.47812E-03_JPRB,0.51419E-03_JPRB,0.55216E-03_JPRB /)  
KB(:,26,14) = (/ &
 & 0.40741E-03_JPRB,0.44425E-03_JPRB,0.48085E-03_JPRB,0.51770E-03_JPRB,0.55654E-03_JPRB /)  
KB(:,27,14) = (/ &
 & 0.41074E-03_JPRB,0.44811E-03_JPRB,0.48506E-03_JPRB,0.52264E-03_JPRB,0.56211E-03_JPRB /)  
KB(:,28,14) = (/ &
 & 0.41538E-03_JPRB,0.45333E-03_JPRB,0.49042E-03_JPRB,0.52868E-03_JPRB,0.56877E-03_JPRB /)  
KB(:,29,14) = (/ &
 & 0.42139E-03_JPRB,0.45956E-03_JPRB,0.49700E-03_JPRB,0.53588E-03_JPRB,0.57647E-03_JPRB /)  
KB(:,30,14) = (/ &
 & 0.42836E-03_JPRB,0.46659E-03_JPRB,0.50435E-03_JPRB,0.54377E-03_JPRB,0.58489E-03_JPRB /)  
KB(:,31,14) = (/ &
 & 0.43618E-03_JPRB,0.47431E-03_JPRB,0.51248E-03_JPRB,0.55256E-03_JPRB,0.59401E-03_JPRB /)  
KB(:,32,14) = (/ &
 & 0.44466E-03_JPRB,0.48256E-03_JPRB,0.52138E-03_JPRB,0.56187E-03_JPRB,0.60364E-03_JPRB /)  
KB(:,33,14) = (/ &
 & 0.45349E-03_JPRB,0.49137E-03_JPRB,0.53076E-03_JPRB,0.57166E-03_JPRB,0.61359E-03_JPRB /)  
KB(:,34,14) = (/ &
 & 0.46108E-03_JPRB,0.49922E-03_JPRB,0.53902E-03_JPRB,0.58028E-03_JPRB,0.62237E-03_JPRB /)  
KB(:,35,14) = (/ &
 & 0.46528E-03_JPRB,0.50354E-03_JPRB,0.54368E-03_JPRB,0.58501E-03_JPRB,0.62724E-03_JPRB /)  
KB(:,36,14) = (/ &
 & 0.46539E-03_JPRB,0.50375E-03_JPRB,0.54391E-03_JPRB,0.58538E-03_JPRB,0.62763E-03_JPRB /)  
KB(:,37,14) = (/ &
 & 0.45984E-03_JPRB,0.49817E-03_JPRB,0.53806E-03_JPRB,0.57948E-03_JPRB,0.62153E-03_JPRB /)  
KB(:,38,14) = (/ &
 & 0.45408E-03_JPRB,0.49229E-03_JPRB,0.53205E-03_JPRB,0.57322E-03_JPRB,0.61533E-03_JPRB /)  
KB(:,39,14) = (/ &
 & 0.44837E-03_JPRB,0.48652E-03_JPRB,0.52604E-03_JPRB,0.56712E-03_JPRB,0.60916E-03_JPRB /)  
KB(:,40,14) = (/ &
 & 0.43865E-03_JPRB,0.47705E-03_JPRB,0.51607E-03_JPRB,0.55678E-03_JPRB,0.59870E-03_JPRB /)  
KB(:,41,14) = (/ &
 & 0.42850E-03_JPRB,0.46708E-03_JPRB,0.50578E-03_JPRB,0.54611E-03_JPRB,0.58790E-03_JPRB /)  
KB(:,42,14) = (/ &
 & 0.41832E-03_JPRB,0.45718E-03_JPRB,0.49552E-03_JPRB,0.53551E-03_JPRB,0.57688E-03_JPRB /)  
KB(:,43,14) = (/ &
 & 0.40611E-03_JPRB,0.44501E-03_JPRB,0.48328E-03_JPRB,0.52271E-03_JPRB,0.56375E-03_JPRB /)  
KB(:,44,14) = (/ &
 & 0.39281E-03_JPRB,0.43169E-03_JPRB,0.47025E-03_JPRB,0.50904E-03_JPRB,0.54960E-03_JPRB /)  
KB(:,45,14) = (/ &
 & 0.37939E-03_JPRB,0.41841E-03_JPRB,0.45722E-03_JPRB,0.49565E-03_JPRB,0.53564E-03_JPRB /)  
KB(:,46,14) = (/ &
 & 0.36481E-03_JPRB,0.40443E-03_JPRB,0.44334E-03_JPRB,0.48171E-03_JPRB,0.52104E-03_JPRB /)  
KB(:,47,14) = (/ &
 & 0.34813E-03_JPRB,0.38867E-03_JPRB,0.42754E-03_JPRB,0.46626E-03_JPRB,0.50489E-03_JPRB /)  
KB(:,48,14) = (/ &
 & 0.33101E-03_JPRB,0.37257E-03_JPRB,0.41188E-03_JPRB,0.45078E-03_JPRB,0.48906E-03_JPRB /)  
KB(:,49,14) = (/ &
 & 0.31369E-03_JPRB,0.35613E-03_JPRB,0.39621E-03_JPRB,0.43508E-03_JPRB,0.47354E-03_JPRB /)  
KB(:,50,14) = (/ &
 & 0.29739E-03_JPRB,0.34030E-03_JPRB,0.38132E-03_JPRB,0.42035E-03_JPRB,0.45918E-03_JPRB /)  
KB(:,51,14) = (/ &
 & 0.28140E-03_JPRB,0.32461E-03_JPRB,0.36662E-03_JPRB,0.40619E-03_JPRB,0.44511E-03_JPRB /)  
KB(:,52,14) = (/ &
 & 0.26563E-03_JPRB,0.30898E-03_JPRB,0.35161E-03_JPRB,0.39193E-03_JPRB,0.43080E-03_JPRB /)  
KB(:,53,14) = (/ &
 & 0.24997E-03_JPRB,0.29311E-03_JPRB,0.33618E-03_JPRB,0.37741E-03_JPRB,0.41655E-03_JPRB /)  
KB(:,54,14) = (/ &
 & 0.23534E-03_JPRB,0.27846E-03_JPRB,0.32175E-03_JPRB,0.36391E-03_JPRB,0.40359E-03_JPRB /)  
KB(:,55,14) = (/ &
 & 0.22140E-03_JPRB,0.26468E-03_JPRB,0.30799E-03_JPRB,0.35062E-03_JPRB,0.39107E-03_JPRB /)  
KB(:,56,14) = (/ &
 & 0.20748E-03_JPRB,0.25097E-03_JPRB,0.29409E-03_JPRB,0.33714E-03_JPRB,0.37835E-03_JPRB /)  
KB(:,57,14) = (/ &
 & 0.19363E-03_JPRB,0.23702E-03_JPRB,0.28013E-03_JPRB,0.32339E-03_JPRB,0.36545E-03_JPRB /)  
KB(:,58,14) = (/ &
 & 0.18066E-03_JPRB,0.22379E-03_JPRB,0.26710E-03_JPRB,0.31040E-03_JPRB,0.35295E-03_JPRB /)  
KB(:,59,14) = (/ &
 & 0.17550E-03_JPRB,0.21855E-03_JPRB,0.26188E-03_JPRB,0.30515E-03_JPRB,0.34793E-03_JPRB /)  
KB(:,13,15) = (/ &
 & 0.67077E-02_JPRB,0.67643E-02_JPRB,0.68102E-02_JPRB,0.68432E-02_JPRB,0.68617E-02_JPRB /)  
KB(:,14,15) = (/ &
 & 0.68112E-02_JPRB,0.68842E-02_JPRB,0.69413E-02_JPRB,0.69806E-02_JPRB,0.70063E-02_JPRB /)  
KB(:,15,15) = (/ &
 & 0.68961E-02_JPRB,0.69833E-02_JPRB,0.70488E-02_JPRB,0.70965E-02_JPRB,0.71269E-02_JPRB /)  
KB(:,16,15) = (/ &
 & 0.69706E-02_JPRB,0.70648E-02_JPRB,0.71387E-02_JPRB,0.71925E-02_JPRB,0.72279E-02_JPRB /)  
KB(:,17,15) = (/ &
 & 0.70342E-02_JPRB,0.71339E-02_JPRB,0.72130E-02_JPRB,0.72737E-02_JPRB,0.73138E-02_JPRB /)  
KB(:,18,15) = (/ &
 & 0.70890E-02_JPRB,0.71933E-02_JPRB,0.72776E-02_JPRB,0.73426E-02_JPRB,0.73856E-02_JPRB /)  
KB(:,19,15) = (/ &
 & 0.71380E-02_JPRB,0.72441E-02_JPRB,0.73326E-02_JPRB,0.74006E-02_JPRB,0.74464E-02_JPRB /)  
KB(:,20,15) = (/ &
 & 0.71838E-02_JPRB,0.72907E-02_JPRB,0.73816E-02_JPRB,0.74514E-02_JPRB,0.74969E-02_JPRB /)  
KB(:,21,15) = (/ &
 & 0.72239E-02_JPRB,0.73326E-02_JPRB,0.74235E-02_JPRB,0.74941E-02_JPRB,0.75405E-02_JPRB /)  
KB(:,22,15) = (/ &
 & 0.72699E-02_JPRB,0.73767E-02_JPRB,0.74650E-02_JPRB,0.75340E-02_JPRB,0.75785E-02_JPRB /)  
KB(:,23,15) = (/ &
 & 0.73111E-02_JPRB,0.74172E-02_JPRB,0.75033E-02_JPRB,0.75687E-02_JPRB,0.76113E-02_JPRB /)  
KB(:,24,15) = (/ &
 & 0.73510E-02_JPRB,0.74537E-02_JPRB,0.75371E-02_JPRB,0.76008E-02_JPRB,0.76395E-02_JPRB /)  
KB(:,25,15) = (/ &
 & 0.73875E-02_JPRB,0.74885E-02_JPRB,0.75684E-02_JPRB,0.76282E-02_JPRB,0.76634E-02_JPRB /)  
KB(:,26,15) = (/ &
 & 0.74256E-02_JPRB,0.75226E-02_JPRB,0.75985E-02_JPRB,0.76530E-02_JPRB,0.76835E-02_JPRB /)  
KB(:,27,15) = (/ &
 & 0.74605E-02_JPRB,0.75517E-02_JPRB,0.76248E-02_JPRB,0.76742E-02_JPRB,0.77008E-02_JPRB /)  
KB(:,28,15) = (/ &
 & 0.74927E-02_JPRB,0.75800E-02_JPRB,0.76483E-02_JPRB,0.76927E-02_JPRB,0.77139E-02_JPRB /)  
KB(:,29,15) = (/ &
 & 0.75244E-02_JPRB,0.76057E-02_JPRB,0.76690E-02_JPRB,0.77086E-02_JPRB,0.77249E-02_JPRB /)  
KB(:,30,15) = (/ &
 & 0.75518E-02_JPRB,0.76303E-02_JPRB,0.76877E-02_JPRB,0.77209E-02_JPRB,0.77334E-02_JPRB /)  
KB(:,31,15) = (/ &
 & 0.75781E-02_JPRB,0.76519E-02_JPRB,0.77036E-02_JPRB,0.77320E-02_JPRB,0.77395E-02_JPRB /)  
KB(:,32,15) = (/ &
 & 0.76025E-02_JPRB,0.76727E-02_JPRB,0.77178E-02_JPRB,0.77409E-02_JPRB,0.77439E-02_JPRB /)  
KB(:,33,15) = (/ &
 & 0.76266E-02_JPRB,0.76908E-02_JPRB,0.77289E-02_JPRB,0.77461E-02_JPRB,0.77464E-02_JPRB /)  
KB(:,34,15) = (/ &
 & 0.76450E-02_JPRB,0.77038E-02_JPRB,0.77387E-02_JPRB,0.77507E-02_JPRB,0.77465E-02_JPRB /)  
KB(:,35,15) = (/ &
 & 0.76558E-02_JPRB,0.77117E-02_JPRB,0.77433E-02_JPRB,0.77536E-02_JPRB,0.77475E-02_JPRB /)  
KB(:,36,15) = (/ &
 & 0.76587E-02_JPRB,0.77150E-02_JPRB,0.77452E-02_JPRB,0.77564E-02_JPRB,0.77495E-02_JPRB /)  
KB(:,37,15) = (/ &
 & 0.76522E-02_JPRB,0.77109E-02_JPRB,0.77439E-02_JPRB,0.77579E-02_JPRB,0.77534E-02_JPRB /)  
KB(:,38,15) = (/ &
 & 0.76429E-02_JPRB,0.77056E-02_JPRB,0.77426E-02_JPRB,0.77582E-02_JPRB,0.77560E-02_JPRB /)  
KB(:,39,15) = (/ &
 & 0.76339E-02_JPRB,0.76993E-02_JPRB,0.77402E-02_JPRB,0.77587E-02_JPRB,0.77588E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART16',1,ZHOOK_HANDLE)
END SUBROUTINE PART16


SUBROUTINE PART17

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART17',0,ZHOOK_HANDLE)


KB(:,40,15) = (/ &
 & 0.76166E-02_JPRB,0.76865E-02_JPRB,0.77335E-02_JPRB,0.77564E-02_JPRB,0.77613E-02_JPRB /)  
KB(:,41,15) = (/ &
 & 0.75961E-02_JPRB,0.76706E-02_JPRB,0.77239E-02_JPRB,0.77534E-02_JPRB,0.77621E-02_JPRB /)  
KB(:,42,15) = (/ &
 & 0.75752E-02_JPRB,0.76537E-02_JPRB,0.77143E-02_JPRB,0.77487E-02_JPRB,0.77622E-02_JPRB /)  
KB(:,43,15) = (/ &
 & 0.75459E-02_JPRB,0.76317E-02_JPRB,0.76988E-02_JPRB,0.77406E-02_JPRB,0.77602E-02_JPRB /)  
KB(:,44,15) = (/ &
 & 0.75134E-02_JPRB,0.76061E-02_JPRB,0.76788E-02_JPRB,0.77299E-02_JPRB,0.77567E-02_JPRB /)  
KB(:,45,15) = (/ &
 & 0.74772E-02_JPRB,0.75773E-02_JPRB,0.76562E-02_JPRB,0.77161E-02_JPRB,0.77502E-02_JPRB /)  
KB(:,46,15) = (/ &
 & 0.74372E-02_JPRB,0.75438E-02_JPRB,0.76298E-02_JPRB,0.76975E-02_JPRB,0.77405E-02_JPRB /)  
KB(:,47,15) = (/ &
 & 0.73875E-02_JPRB,0.75032E-02_JPRB,0.75980E-02_JPRB,0.76724E-02_JPRB,0.77261E-02_JPRB /)  
KB(:,48,15) = (/ &
 & 0.73358E-02_JPRB,0.74597E-02_JPRB,0.75632E-02_JPRB,0.76453E-02_JPRB,0.77080E-02_JPRB /)  
KB(:,49,15) = (/ &
 & 0.72811E-02_JPRB,0.74117E-02_JPRB,0.75238E-02_JPRB,0.76147E-02_JPRB,0.76865E-02_JPRB /)  
KB(:,50,15) = (/ &
 & 0.72248E-02_JPRB,0.73656E-02_JPRB,0.74842E-02_JPRB,0.75831E-02_JPRB,0.76614E-02_JPRB /)  
KB(:,51,15) = (/ &
 & 0.71662E-02_JPRB,0.73174E-02_JPRB,0.74427E-02_JPRB,0.75493E-02_JPRB,0.76342E-02_JPRB /)  
KB(:,52,15) = (/ &
 & 0.71006E-02_JPRB,0.72655E-02_JPRB,0.73997E-02_JPRB,0.75133E-02_JPRB,0.76064E-02_JPRB /)  
KB(:,53,15) = (/ &
 & 0.70300E-02_JPRB,0.72101E-02_JPRB,0.73531E-02_JPRB,0.74734E-02_JPRB,0.75745E-02_JPRB /)  
KB(:,54,15) = (/ &
 & 0.69596E-02_JPRB,0.71548E-02_JPRB,0.73082E-02_JPRB,0.74357E-02_JPRB,0.75431E-02_JPRB /)  
KB(:,55,15) = (/ &
 & 0.68873E-02_JPRB,0.70968E-02_JPRB,0.72620E-02_JPRB,0.73967E-02_JPRB,0.75110E-02_JPRB /)  
KB(:,56,15) = (/ &
 & 0.68089E-02_JPRB,0.70345E-02_JPRB,0.72141E-02_JPRB,0.73575E-02_JPRB,0.74766E-02_JPRB /)  
KB(:,57,15) = (/ &
 & 0.67241E-02_JPRB,0.69678E-02_JPRB,0.71623E-02_JPRB,0.73141E-02_JPRB,0.74401E-02_JPRB /)  
KB(:,58,15) = (/ &
 & 0.66371E-02_JPRB,0.69009E-02_JPRB,0.71063E-02_JPRB,0.72699E-02_JPRB,0.74044E-02_JPRB /)  
KB(:,59,15) = (/ &
 & 0.66009E-02_JPRB,0.68723E-02_JPRB,0.70852E-02_JPRB,0.72532E-02_JPRB,0.73888E-02_JPRB /)  
KB(:,13,16) = (/ &
 & 0.20091E-01_JPRB,0.19310E-01_JPRB,0.18586E-01_JPRB,0.17917E-01_JPRB,0.17293E-01_JPRB /)  
KB(:,14,16) = (/ &
 & 0.21405E-01_JPRB,0.20507E-01_JPRB,0.19679E-01_JPRB,0.18912E-01_JPRB,0.18201E-01_JPRB /)  
KB(:,15,16) = (/ &
 & 0.22567E-01_JPRB,0.21555E-01_JPRB,0.20633E-01_JPRB,0.19775E-01_JPRB,0.18992E-01_JPRB /)  
KB(:,16,16) = (/ &
 & 0.23562E-01_JPRB,0.22456E-01_JPRB,0.21445E-01_JPRB,0.20508E-01_JPRB,0.19661E-01_JPRB /)  
KB(:,17,16) = (/ &
 & 0.24411E-01_JPRB,0.23217E-01_JPRB,0.22126E-01_JPRB,0.21126E-01_JPRB,0.20220E-01_JPRB /)  
KB(:,18,16) = (/ &
 & 0.25116E-01_JPRB,0.23847E-01_JPRB,0.22688E-01_JPRB,0.21635E-01_JPRB,0.20680E-01_JPRB /)  
KB(:,19,16) = (/ &
 & 0.25693E-01_JPRB,0.24361E-01_JPRB,0.23149E-01_JPRB,0.22047E-01_JPRB,0.21053E-01_JPRB /)  
KB(:,20,16) = (/ &
 & 0.26126E-01_JPRB,0.24747E-01_JPRB,0.23489E-01_JPRB,0.22355E-01_JPRB,0.21332E-01_JPRB /)  
KB(:,21,16) = (/ &
 & 0.26457E-01_JPRB,0.25034E-01_JPRB,0.23751E-01_JPRB,0.22588E-01_JPRB,0.21537E-01_JPRB /)  
KB(:,22,16) = (/ &
 & 0.26586E-01_JPRB,0.25153E-01_JPRB,0.23857E-01_JPRB,0.22677E-01_JPRB,0.21621E-01_JPRB /)  
KB(:,23,16) = (/ &
 & 0.26640E-01_JPRB,0.25191E-01_JPRB,0.23890E-01_JPRB,0.22706E-01_JPRB,0.21649E-01_JPRB /)  
KB(:,24,16) = (/ &
 & 0.26616E-01_JPRB,0.25160E-01_JPRB,0.23861E-01_JPRB,0.22680E-01_JPRB,0.21622E-01_JPRB /)  
KB(:,25,16) = (/ &
 & 0.26518E-01_JPRB,0.25075E-01_JPRB,0.23777E-01_JPRB,0.22603E-01_JPRB,0.21555E-01_JPRB /)  
KB(:,26,16) = (/ &
 & 0.26348E-01_JPRB,0.24922E-01_JPRB,0.23637E-01_JPRB,0.22478E-01_JPRB,0.21437E-01_JPRB /)  
KB(:,27,16) = (/ &
 & 0.26138E-01_JPRB,0.24737E-01_JPRB,0.23465E-01_JPRB,0.22328E-01_JPRB,0.21299E-01_JPRB /)  
KB(:,28,16) = (/ &
 & 0.25904E-01_JPRB,0.24526E-01_JPRB,0.23272E-01_JPRB,0.22156E-01_JPRB,0.21140E-01_JPRB /)  
KB(:,29,16) = (/ &
 & 0.25645E-01_JPRB,0.24289E-01_JPRB,0.23059E-01_JPRB,0.21960E-01_JPRB,0.20965E-01_JPRB /)  
KB(:,30,16) = (/ &
 & 0.25364E-01_JPRB,0.24034E-01_JPRB,0.22831E-01_JPRB,0.21758E-01_JPRB,0.20776E-01_JPRB /)  
KB(:,31,16) = (/ &
 & 0.25075E-01_JPRB,0.23766E-01_JPRB,0.22595E-01_JPRB,0.21541E-01_JPRB,0.20581E-01_JPRB /)  
KB(:,32,16) = (/ &
 & 0.24769E-01_JPRB,0.23490E-01_JPRB,0.22348E-01_JPRB,0.21316E-01_JPRB,0.20377E-01_JPRB /)  
KB(:,33,16) = (/ &
 & 0.24460E-01_JPRB,0.23211E-01_JPRB,0.22098E-01_JPRB,0.21090E-01_JPRB,0.20170E-01_JPRB /)  
KB(:,34,16) = (/ &
 & 0.24193E-01_JPRB,0.22975E-01_JPRB,0.21887E-01_JPRB,0.20894E-01_JPRB,0.19994E-01_JPRB /)  
KB(:,35,16) = (/ &
 & 0.24050E-01_JPRB,0.22849E-01_JPRB,0.21770E-01_JPRB,0.20789E-01_JPRB,0.19901E-01_JPRB /)  
KB(:,36,16) = (/ &
 & 0.24043E-01_JPRB,0.22842E-01_JPRB,0.21764E-01_JPRB,0.20784E-01_JPRB,0.19894E-01_JPRB /)  
KB(:,37,16) = (/ &
 & 0.24229E-01_JPRB,0.23006E-01_JPRB,0.21915E-01_JPRB,0.20918E-01_JPRB,0.20018E-01_JPRB /)  
KB(:,38,16) = (/ &
 & 0.24421E-01_JPRB,0.23180E-01_JPRB,0.22070E-01_JPRB,0.21062E-01_JPRB,0.20144E-01_JPRB /)  
KB(:,39,16) = (/ &
 & 0.24617E-01_JPRB,0.23352E-01_JPRB,0.22226E-01_JPRB,0.21205E-01_JPRB,0.20274E-01_JPRB /)  
KB(:,40,16) = (/ &
 & 0.24953E-01_JPRB,0.23654E-01_JPRB,0.22496E-01_JPRB,0.21449E-01_JPRB,0.20495E-01_JPRB /)  
KB(:,41,16) = (/ &
 & 0.25312E-01_JPRB,0.23980E-01_JPRB,0.22786E-01_JPRB,0.21712E-01_JPRB,0.20738E-01_JPRB /)  
KB(:,42,16) = (/ &
 & 0.25679E-01_JPRB,0.24315E-01_JPRB,0.23082E-01_JPRB,0.21982E-01_JPRB,0.20981E-01_JPRB /)  
KB(:,43,16) = (/ &
 & 0.26140E-01_JPRB,0.24730E-01_JPRB,0.23454E-01_JPRB,0.22317E-01_JPRB,0.21287E-01_JPRB /)  
KB(:,44,16) = (/ &
 & 0.26653E-01_JPRB,0.25200E-01_JPRB,0.23871E-01_JPRB,0.22691E-01_JPRB,0.21628E-01_JPRB /)  
KB(:,45,16) = (/ &
 & 0.27190E-01_JPRB,0.25674E-01_JPRB,0.24311E-01_JPRB,0.23078E-01_JPRB,0.21977E-01_JPRB /)  
KB(:,46,16) = (/ &
 & 0.27783E-01_JPRB,0.26205E-01_JPRB,0.24787E-01_JPRB,0.23504E-01_JPRB,0.22362E-01_JPRB /)  
KB(:,47,16) = (/ &
 & 0.28471E-01_JPRB,0.26819E-01_JPRB,0.25343E-01_JPRB,0.24006E-01_JPRB,0.22809E-01_JPRB /)  
KB(:,48,16) = (/ &
 & 0.29185E-01_JPRB,0.27464E-01_JPRB,0.25918E-01_JPRB,0.24532E-01_JPRB,0.23275E-01_JPRB /)  
KB(:,49,16) = (/ &
 & 0.29935E-01_JPRB,0.28138E-01_JPRB,0.26520E-01_JPRB,0.25074E-01_JPRB,0.23762E-01_JPRB /)  
KB(:,50,16) = (/ &
 & 0.30661E-01_JPRB,0.28793E-01_JPRB,0.27111E-01_JPRB,0.25603E-01_JPRB,0.24243E-01_JPRB /)  
KB(:,51,16) = (/ &
 & 0.31401E-01_JPRB,0.29455E-01_JPRB,0.27706E-01_JPRB,0.26135E-01_JPRB,0.24726E-01_JPRB /)  
KB(:,52,16) = (/ &
 & 0.32182E-01_JPRB,0.30140E-01_JPRB,0.28322E-01_JPRB,0.26686E-01_JPRB,0.25224E-01_JPRB /)  
KB(:,53,16) = (/ &
 & 0.33002E-01_JPRB,0.30856E-01_JPRB,0.28966E-01_JPRB,0.27268E-01_JPRB,0.25738E-01_JPRB /)  
KB(:,54,16) = (/ &
 & 0.33792E-01_JPRB,0.31541E-01_JPRB,0.29577E-01_JPRB,0.27816E-01_JPRB,0.26234E-01_JPRB /)  
KB(:,55,16) = (/ &
 & 0.34581E-01_JPRB,0.32233E-01_JPRB,0.30182E-01_JPRB,0.28363E-01_JPRB,0.26721E-01_JPRB /)  
KB(:,56,16) = (/ &
 & 0.35416E-01_JPRB,0.32947E-01_JPRB,0.30807E-01_JPRB,0.28926E-01_JPRB,0.27227E-01_JPRB /)  
KB(:,57,16) = (/ &
 & 0.36291E-01_JPRB,0.33701E-01_JPRB,0.31460E-01_JPRB,0.29510E-01_JPRB,0.27750E-01_JPRB /)  
KB(:,58,16) = (/ &
 & 0.37161E-01_JPRB,0.34436E-01_JPRB,0.32106E-01_JPRB,0.30077E-01_JPRB,0.28264E-01_JPRB /)  
KB(:,59,16) = (/ &
 & 0.37521E-01_JPRB,0.34750E-01_JPRB,0.32373E-01_JPRB,0.30309E-01_JPRB,0.28477E-01_JPRB /)  

!     -----------------------------------------------------------------

FORREF(:, 1) = (/ 0.515619E-08_JPRB, 0.131078E-06_JPRB, 0.349038E-06_JPRB /)
FORREF(:, 2) = (/ 0.329605E-07_JPRB, 0.430497E-06_JPRB, 0.458569E-05_JPRB /)
FORREF(:, 3) = (/ 0.188244E-06_JPRB, 0.792931E-06_JPRB, 0.267176E-05_JPRB /)
FORREF(:, 4) = (/ 0.611237E-06_JPRB, 0.798868E-06_JPRB, 0.411583E-06_JPRB /)
FORREF(:, 5) = (/ 0.111903E-05_JPRB, 0.914895E-06_JPRB, 0.444828E-06_JPRB /)
FORREF(:, 6) = (/ 0.235399E-05_JPRB, 0.269099E-05_JPRB, 0.739855E-06_JPRB /)
FORREF(:, 7) = (/ 0.400131E-05_JPRB, 0.378135E-05_JPRB, 0.231265E-06_JPRB /)
FORREF(:, 8) = (/ 0.464257E-05_JPRB, 0.371927E-05_JPRB, 0.460611E-06_JPRB /)
FORREF(:, 9) = (/ 0.476792E-05_JPRB, 0.311841E-05_JPRB, 0.934811E-06_JPRB /)
FORREF(:,10) = (/ 0.555683E-05_JPRB, 0.238129E-05_JPRB, 0.400334E-07_JPRB /)
FORREF(:,11) = (/ 0.569068E-05_JPRB, 0.196039E-05_JPRB, 0.374476E-07_JPRB /)
FORREF(:,12) = (/ 0.554154E-05_JPRB, 0.131724E-05_JPRB, 0.399720E-07_JPRB /)
FORREF(:,13) = (/ 0.462684E-05_JPRB, 0.238826E-07_JPRB, 0.325793E-07_JPRB /)
FORREF(:,14) = (/ 0.808644E-06_JPRB, 0.105126E-11_JPRB, 0.148691E-07_JPRB /)
FORREF(:,15) = (/ 0.865024E-12_JPRB, 0.822434E-12_JPRB, 0.825756E-12_JPRB /)
FORREF(:,16) = (/ 0.945747E-12_JPRB, 0.802065E-12_JPRB, 0.724732E-12_JPRB /)

!     -----------------------------------------------------------------
!     The array SELFREF contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREF(:, 1) = (/ &
 & 0.637755E-05_JPRB, 0.403921E-05_JPRB, 0.255823E-05_JPRB, 0.162025E-05_JPRB, 0.102618E-05_JPRB, &
 & 0.649930E-06_JPRB, 0.411632E-06_JPRB, 0.260707E-06_JPRB, 0.165118E-06_JPRB, 0.104577E-06_JPRB /)  
SELFREF(:, 2) = (/ &
 & 0.180887E-04_JPRB, 0.108890E-04_JPRB, 0.655493E-05_JPRB, 0.394592E-05_JPRB, 0.237536E-05_JPRB, &
 & 0.142991E-05_JPRB, 0.860774E-06_JPRB, 0.518167E-06_JPRB, 0.311925E-06_JPRB, 0.187772E-06_JPRB /)  
SELFREF(:, 3) = (/ &
 & 0.212261E-04_JPRB, 0.150697E-04_JPRB, 0.106989E-04_JPRB, 0.759581E-05_JPRB, 0.539274E-05_JPRB, &
 & 0.382864E-05_JPRB, 0.271819E-05_JPRB, 0.192981E-05_JPRB, 0.137009E-05_JPRB, 0.972711E-06_JPRB /)  
SELFREF(:, 4) = (/ &
 & 0.132497E-04_JPRB, 0.118071E-04_JPRB, 0.105216E-04_JPRB, 0.937599E-05_JPRB, 0.835516E-05_JPRB, &
 & 0.744547E-05_JPRB, 0.663482E-05_JPRB, 0.591243E-05_JPRB, 0.526870E-05_JPRB, 0.469506E-05_JPRB /)  
SELFREF(:, 5) = (/ &
 & 0.124069E-04_JPRB, 0.120785E-04_JPRB, 0.117589E-04_JPRB, 0.114477E-04_JPRB, 0.111447E-04_JPRB, &
 & 0.108498E-04_JPRB, 0.105626E-04_JPRB, 0.102831E-04_JPRB, 0.100109E-04_JPRB, 0.974601E-05_JPRB /)  
SELFREF(:, 6) = (/ &
 & 0.411994E-04_JPRB, 0.372560E-04_JPRB, 0.336901E-04_JPRB, 0.304654E-04_JPRB, 0.275494E-04_JPRB, &
 & 0.249126E-04_JPRB, 0.225281E-04_JPRB, 0.203718E-04_JPRB, 0.184219E-04_JPRB, 0.166587E-04_JPRB /)  
SELFREF(:, 7) = (/ &
 & 0.537376E-04_JPRB, 0.501002E-04_JPRB, 0.467090E-04_JPRB, 0.435473E-04_JPRB, 0.405996E-04_JPRB, &
 & 0.378515E-04_JPRB, 0.352893E-04_JPRB, 0.329006E-04_JPRB, 0.306736E-04_JPRB, 0.285974E-04_JPRB /)  
SELFREF(:, 8) = (/ &
 & 0.494279E-04_JPRB, 0.475365E-04_JPRB, 0.457175E-04_JPRB, 0.439681E-04_JPRB, 0.422857E-04_JPRB, &
 & 0.406676E-04_JPRB, 0.391114E-04_JPRB, 0.376148E-04_JPRB, 0.361755E-04_JPRB, 0.347912E-04_JPRB /)  
SELFREF(:, 9) = (/ &
 & 0.377444E-04_JPRB, 0.378199E-04_JPRB, 0.378956E-04_JPRB, 0.379715E-04_JPRB, 0.380475E-04_JPRB, &
 & 0.381236E-04_JPRB, 0.381999E-04_JPRB, 0.382763E-04_JPRB, 0.383529E-04_JPRB, 0.384297E-04_JPRB /)  
SELFREF(:,10) = (/ &
 & 0.245916E-04_JPRB, 0.267183E-04_JPRB, 0.290289E-04_JPRB, 0.315394E-04_JPRB, 0.342669E-04_JPRB, &
 & 0.372304E-04_JPRB, 0.404501E-04_JPRB, 0.439483E-04_JPRB, 0.477490E-04_JPRB, 0.518784E-04_JPRB /)  
SELFREF(:,11) = (/ &
 & 0.186528E-04_JPRB, 0.211417E-04_JPRB, 0.239628E-04_JPRB, 0.271603E-04_JPRB, 0.307845E-04_JPRB, &
 & 0.348923E-04_JPRB, 0.395482E-04_JPRB, 0.448254E-04_JPRB, 0.508068E-04_JPRB, 0.575863E-04_JPRB /)  
SELFREF(:,12) = (/ &
 & 0.109896E-04_JPRB, 0.133794E-04_JPRB, 0.162890E-04_JPRB, 0.198312E-04_JPRB, 0.241438E-04_JPRB, &
 & 0.293942E-04_JPRB, 0.357864E-04_JPRB, 0.435686E-04_JPRB, 0.530432E-04_JPRB, 0.645781E-04_JPRB /)  
SELFREF(:,13) = (/ &
 & 0.183885E-06_JPRB, 0.391019E-06_JPRB, 0.831472E-06_JPRB, 0.176806E-05_JPRB, 0.375966E-05_JPRB, &
 & 0.799463E-05_JPRB, 0.170000E-04_JPRB, 0.361492E-04_JPRB, 0.768686E-04_JPRB, 0.163455E-03_JPRB /)  
SELFREF(:,14) = (/ &
 & 0.466057E-07_JPRB, 0.937419E-07_JPRB, 0.188551E-06_JPRB, 0.379248E-06_JPRB, 0.762813E-06_JPRB, &
 & 0.153431E-05_JPRB, 0.308608E-05_JPRB, 0.620729E-05_JPRB, 0.124852E-04_JPRB, 0.251126E-04_JPRB /)  
SELFREF(:,15) = (/ &
 & 0.248961E-06_JPRB, 0.216780E-06_JPRB, 0.188758E-06_JPRB, 0.164358E-06_JPRB, 0.143113E-06_JPRB, &
 & 0.124613E-06_JPRB, 0.108505E-06_JPRB, 0.944795E-07_JPRB, 0.822667E-07_JPRB, 0.716326E-07_JPRB /)  
SELFREF(:,16) = (/ &
 & 0.252246E-06_JPRB, 0.220335E-06_JPRB, 0.192462E-06_JPRB, 0.168114E-06_JPRB, 0.146847E-06_JPRB, &
 & 0.128270E-06_JPRB, 0.112043E-06_JPRB, 0.978688E-07_JPRB, 0.854878E-07_JPRB, 0.746731E-07_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB24:PART17',1,ZHOOK_HANDLE)
END SUBROUTINE PART17


END SUBROUTINE SRTM_KGB24

