!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif 
!pgi$r opt=0
SUBROUTINE SRTM_KGB22

!     Originally by J.Delamere, Atmospheric & Environmental Research.
!     Revision: 2.4
!     BAND 16:  7700-8050 cm-1 (low - H2O,O2; high - O2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOESRTA22, ONLY : KA, KB, SELFREF, FORREF, SFLUXREF, RAYL, STRRAT &
 & , LAYREFFR  

!     ------------------------------------------------------------------

IMPLICIT NONE

! KURUCZ
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2
CALL PART3
CALL PART4
CALL PART5
CALL PART6
CALL PART7
CALL PART8
CALL PART9
CALL PART10
CALL PART11
CALL PART12
CALL PART13
CALL PART14
CALL PART15
CALL PART16
CALL PART17

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22',1,ZHOOK_HANDLE)

!     -----------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART1',0,ZHOOK_HANDLE)


SFLUXREF(:, 1) = (/ &
 & 3.71641_JPRB    ,3.63190_JPRB    ,3.44795_JPRB    ,3.17936_JPRB    , &
 & 2.86071_JPRB    ,2.48490_JPRB    ,2.02471_JPRB    ,1.52475_JPRB    , &
 & 1.03811_JPRB    ,0.113272_JPRB   ,9.37115E-02_JPRB,7.38969E-02_JPRB, &
 & 5.44713E-02_JPRB,3.45905E-02_JPRB,1.30293E-02_JPRB,1.84198E-03_JPRB /)  
SFLUXREF(:, 2) = (/ &
 & 3.73933_JPRB    ,3.60360_JPRB    ,3.43370_JPRB    ,3.19749_JPRB    ,  &
 & 2.87747_JPRB    ,2.47926_JPRB    ,2.02175_JPRB    ,1.52010_JPRB    , &
 & 1.03612_JPRB    ,0.113265_JPRB   ,9.37145E-02_JPRB,7.38951E-02_JPRB, &
 & 5.44714E-02_JPRB,3.45906E-02_JPRB,1.30293E-02_JPRB,1.84198E-03_JPRB /)  
SFLUXREF(:, 3) = (/ &
 & 3.73889_JPRB    ,3.60279_JPRB    ,3.43404_JPRB    ,3.20560_JPRB    , &
 & 2.87367_JPRB    ,2.47515_JPRB    ,2.02412_JPRB    ,1.52315_JPRB    , &
 & 1.03146_JPRB    ,0.113272_JPRB   ,9.36707E-02_JPRB,7.39080E-02_JPRB, &
 & 5.44598E-02_JPRB,3.45906E-02_JPRB,1.30293E-02_JPRB,1.84198E-03_JPRB /)  
SFLUXREF(:, 4) = (/ &
 & 3.73801_JPRB    ,3.60530_JPRB    ,3.43659_JPRB    ,3.20640_JPRB    , &
 & 2.87039_JPRB    ,2.47330_JPRB    ,2.02428_JPRB    ,1.52509_JPRB    , &
 & 1.03037_JPRB    ,0.112553_JPRB   ,9.35352E-02_JPRB,7.39675E-02_JPRB, &
 & 5.43951E-02_JPRB,3.45669E-02_JPRB,1.30292E-02_JPRB,1.84198E-03_JPRB /)  
SFLUXREF(:, 5) = (/ &
 & 3.73809_JPRB    ,3.60996_JPRB    ,3.43602_JPRB    ,3.20364_JPRB    , &
 & 2.87005_JPRB    ,2.47343_JPRB    ,2.02353_JPRB    ,1.52617_JPRB    , &
 & 1.03138_JPRB    ,0.111172_JPRB   ,9.29885E-02_JPRB,7.35034E-02_JPRB, &
 & 5.42427E-02_JPRB,3.45732E-02_JPRB,1.30169E-02_JPRB,1.84550E-03_JPRB /)  
SFLUXREF(:, 6) = (/ &
 & 3.73872_JPRB    ,3.62054_JPRB    ,3.42934_JPRB    ,3.20110_JPRB    , &
 & 2.86886_JPRB    ,2.47379_JPRB    ,2.02237_JPRB    ,1.52754_JPRB    ,  &
 & 1.03228_JPRB    ,0.111597_JPRB   ,9.12252E-02_JPRB,7.33115E-02_JPRB, &
 & 5.35600E-02_JPRB,3.45187E-02_JPRB,1.30184E-02_JPRB,1.84551E-03_JPRB /)  
SFLUXREF(:, 7) = (/ &
 & 3.73969_JPRB    ,3.65461_JPRB    ,3.40646_JPRB    ,3.19082_JPRB    , &
 & 2.86919_JPRB    ,2.47289_JPRB    ,2.02312_JPRB    ,1.52629_JPRB    , &
 & 1.03329_JPRB    ,0.111611_JPRB   ,9.16275E-02_JPRB,7.14731E-02_JPRB, &
 & 5.31771E-02_JPRB,3.44980E-02_JPRB,1.30190E-02_JPRB,1.84551E-03_JPRB /)  
SFLUXREF(:, 8) = (/ &
 & 3.73995_JPRB    ,3.65348_JPRB    ,3.43707_JPRB    ,3.16351_JPRB    , &
 & 2.87003_JPRB    ,2.47392_JPRB    ,2.02114_JPRB    ,1.52548_JPRB    ,  &
 & 1.03306_JPRB    ,0.111088_JPRB   ,9.12422E-02_JPRB,7.11146E-02_JPRB, &
 & 5.31333E-02_JPRB,3.45302E-02_JPRB,1.30209E-02_JPRB,1.84554E-03_JPRB /)  
SFLUXREF(:, 9) = (/ &
 & 3.73788_JPRB    ,3.65004_JPRB    ,3.46938_JPRB    ,3.15236_JPRB    , &
 & 2.86381_JPRB    ,2.47393_JPRB    ,2.01715_JPRB    ,1.52134_JPRB    , &
 & 1.03163_JPRB    ,0.111259_JPRB   ,9.12948E-02_JPRB,7.09999E-02_JPRB, &
 & 5.31792E-02_JPRB,3.44955E-02_JPRB,1.30189E-02_JPRB,1.84551E-03_JPRB /)  

!     Rayleigh extinction coefficient at v = 8000 cm-1.
RAYL = 1.54E-08_JPRB

STRRAT = 0.022708_JPRB

LAYREFFR = 2

!     ------------------------------------------------------------------

!     The array KA contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KA(:, 1, 1, 1) = (/ &
 & 0.14658E-08_JPRB,0.32044E-07_JPRB,0.36289E-07_JPRB,0.38717E-07_JPRB,0.40590E-07_JPRB, &
 & 0.43330E-07_JPRB,0.46916E-07_JPRB,0.56519E-07_JPRB,0.42446E-07_JPRB /)  
KA(:, 2, 1, 1) = (/ &
 & 0.17883E-08_JPRB,0.36129E-07_JPRB,0.40724E-07_JPRB,0.43498E-07_JPRB,0.45371E-07_JPRB, &
 & 0.47093E-07_JPRB,0.51195E-07_JPRB,0.58562E-07_JPRB,0.44474E-07_JPRB /)  
KA(:, 3, 1, 1) = (/ &
 & 0.21286E-08_JPRB,0.46092E-07_JPRB,0.53991E-07_JPRB,0.59439E-07_JPRB,0.63497E-07_JPRB, &
 & 0.66730E-07_JPRB,0.70296E-07_JPRB,0.83990E-07_JPRB,0.65058E-07_JPRB /)  
KA(:, 4, 1, 1) = (/ &
 & 0.24816E-08_JPRB,0.43399E-07_JPRB,0.49167E-07_JPRB,0.52969E-07_JPRB,0.55586E-07_JPRB, &
 & 0.57260E-07_JPRB,0.58809E-07_JPRB,0.64046E-07_JPRB,0.48780E-07_JPRB /)  
KA(:, 5, 1, 1) = (/ &
 & 0.28409E-08_JPRB,0.46683E-07_JPRB,0.53128E-07_JPRB,0.57526E-07_JPRB,0.60605E-07_JPRB, &
 & 0.62715E-07_JPRB,0.64284E-07_JPRB,0.67579E-07_JPRB,0.52346E-07_JPRB /)  
KA(:, 1, 2, 1) = (/ &
 & 0.10965E-08_JPRB,0.24934E-07_JPRB,0.28268E-07_JPRB,0.30156E-07_JPRB,0.31820E-07_JPRB, &
 & 0.34498E-07_JPRB,0.36563E-07_JPRB,0.46609E-07_JPRB,0.30202E-07_JPRB /)  
KA(:, 2, 2, 1) = (/ &
 & 0.13538E-08_JPRB,0.28338E-07_JPRB,0.31923E-07_JPRB,0.34048E-07_JPRB,0.35529E-07_JPRB, &
 & 0.37136E-07_JPRB,0.41583E-07_JPRB,0.46831E-07_JPRB,0.32817E-07_JPRB /)  
KA(:, 3, 2, 1) = (/ &
 & 0.16260E-08_JPRB,0.36648E-07_JPRB,0.42882E-07_JPRB,0.47128E-07_JPRB,0.50288E-07_JPRB, &
 & 0.52851E-07_JPRB,0.56093E-07_JPRB,0.70511E-07_JPRB,0.48182E-07_JPRB /)  
KA(:, 4, 2, 1) = (/ &
 & 0.19102E-08_JPRB,0.39471E-07_JPRB,0.46225E-07_JPRB,0.50974E-07_JPRB,0.54565E-07_JPRB, &
 & 0.57380E-07_JPRB,0.60079E-07_JPRB,0.67707E-07_JPRB,0.50168E-07_JPRB /)  
KA(:, 5, 2, 1) = (/ &
 & 0.22030E-08_JPRB,0.37203E-07_JPRB,0.42234E-07_JPRB,0.45622E-07_JPRB,0.47990E-07_JPRB, &
 & 0.49546E-07_JPRB,0.50777E-07_JPRB,0.53867E-07_JPRB,0.39769E-07_JPRB /)  
KA(:, 1, 3, 1) = (/ &
 & 0.77844E-09_JPRB,0.18777E-07_JPRB,0.21347E-07_JPRB,0.22946E-07_JPRB,0.24368E-07_JPRB, &
 & 0.25870E-07_JPRB,0.28084E-07_JPRB,0.39197E-07_JPRB,0.20196E-07_JPRB /)  
KA(:, 2, 3, 1) = (/ &
 & 0.97891E-09_JPRB,0.21591E-07_JPRB,0.24379E-07_JPRB,0.25974E-07_JPRB,0.27213E-07_JPRB, &
 & 0.29039E-07_JPRB,0.31487E-07_JPRB,0.37725E-07_JPRB,0.23228E-07_JPRB /)  
KA(:, 3, 3, 1) = (/ &
 & 0.11949E-08_JPRB,0.24305E-07_JPRB,0.27342E-07_JPRB,0.29177E-07_JPRB,0.30428E-07_JPRB, &
 & 0.31562E-07_JPRB,0.34299E-07_JPRB,0.39267E-07_JPRB,0.23943E-07_JPRB /)  
KA(:, 4, 3, 1) = (/ &
 & 0.14225E-08_JPRB,0.30991E-07_JPRB,0.36244E-07_JPRB,0.39880E-07_JPRB,0.42596E-07_JPRB, &
 & 0.44752E-07_JPRB,0.47132E-07_JPRB,0.56253E-07_JPRB,0.37250E-07_JPRB /)  
KA(:, 5, 3, 1) = (/ &
 & 0.16586E-08_JPRB,0.29152E-07_JPRB,0.32988E-07_JPRB,0.35508E-07_JPRB,0.37264E-07_JPRB, &
 & 0.38387E-07_JPRB,0.39417E-07_JPRB,0.42936E-07_JPRB,0.29439E-07_JPRB /)  
KA(:, 1, 4, 1) = (/ &
 & 0.53935E-09_JPRB,0.13922E-07_JPRB,0.15779E-07_JPRB,0.16979E-07_JPRB,0.18157E-07_JPRB, &
 & 0.19199E-07_JPRB,0.22168E-07_JPRB,0.31060E-07_JPRB,0.13772E-07_JPRB /)  
KA(:, 2, 4, 1) = (/ &
 & 0.69404E-09_JPRB,0.16220E-07_JPRB,0.18381E-07_JPRB,0.19646E-07_JPRB,0.20841E-07_JPRB, &
 & 0.22407E-07_JPRB,0.23846E-07_JPRB,0.31992E-07_JPRB,0.15532E-07_JPRB /)  
KA(:, 3, 4, 1) = (/ &
 & 0.86327E-09_JPRB,0.18514E-07_JPRB,0.20845E-07_JPRB,0.22209E-07_JPRB,0.23196E-07_JPRB, &
 & 0.24396E-07_JPRB,0.27026E-07_JPRB,0.31067E-07_JPRB,0.17116E-07_JPRB /)  
KA(:, 4, 4, 1) = (/ &
 & 0.10436E-08_JPRB,0.20666E-07_JPRB,0.23248E-07_JPRB,0.24835E-07_JPRB,0.25904E-07_JPRB, &
 & 0.26757E-07_JPRB,0.28384E-07_JPRB,0.33085E-07_JPRB,0.19320E-07_JPRB /)  
KA(:, 5, 4, 1) = (/ &
 & 0.12327E-08_JPRB,0.26056E-07_JPRB,0.30481E-07_JPRB,0.33580E-07_JPRB,0.35908E-07_JPRB, &
 & 0.37744E-07_JPRB,0.39586E-07_JPRB,0.45434E-07_JPRB,0.29787E-07_JPRB /)  
KA(:, 1, 5, 1) = (/ &
 & 0.36905E-09_JPRB,0.10245E-07_JPRB,0.11596E-07_JPRB,0.12576E-07_JPRB,0.13293E-07_JPRB, &
 & 0.14477E-07_JPRB,0.18355E-07_JPRB,0.25395E-07_JPRB,0.95950E-08_JPRB /)  
KA(:, 2, 5, 1) = (/ &
 & 0.48708E-09_JPRB,0.12119E-07_JPRB,0.13746E-07_JPRB,0.14791E-07_JPRB,0.15718E-07_JPRB, &
 & 0.16646E-07_JPRB,0.18396E-07_JPRB,0.25737E-07_JPRB,0.10793E-07_JPRB /)  
KA(:, 3, 5, 1) = (/ &
 & 0.61847E-09_JPRB,0.13998E-07_JPRB,0.15813E-07_JPRB,0.16851E-07_JPRB,0.17722E-07_JPRB, &
 & 0.19232E-07_JPRB,0.20414E-07_JPRB,0.25223E-07_JPRB,0.12354E-07_JPRB /)  
KA(:, 4, 5, 1) = (/ &
 & 0.76052E-09_JPRB,0.15846E-07_JPRB,0.17816E-07_JPRB,0.18991E-07_JPRB,0.19806E-07_JPRB, &
 & 0.20628E-07_JPRB,0.23016E-07_JPRB,0.25874E-07_JPRB,0.14269E-07_JPRB /)  
KA(:, 5, 5, 1) = (/ &
 & 0.91109E-09_JPRB,0.20382E-07_JPRB,0.23823E-07_JPRB,0.26180E-07_JPRB,0.27929E-07_JPRB, &
 & 0.29345E-07_JPRB,0.31039E-07_JPRB,0.38471E-07_JPRB,0.22626E-07_JPRB /)  
KA(:, 1, 6, 1) = (/ &
 & 0.24637E-09_JPRB,0.74144E-08_JPRB,0.83997E-08_JPRB,0.90789E-08_JPRB,0.97769E-08_JPRB, &
 & 0.11308E-07_JPRB,0.14223E-07_JPRB,0.20837E-07_JPRB,0.66398E-08_JPRB /)  
KA(:, 2, 6, 1) = (/ &
 & 0.33527E-09_JPRB,0.89450E-08_JPRB,0.10119E-07_JPRB,0.10892E-07_JPRB,0.11613E-07_JPRB, &
 & 0.12382E-07_JPRB,0.14900E-07_JPRB,0.20638E-07_JPRB,0.76422E-08_JPRB /)  
KA(:, 3, 6, 1) = (/ &
 & 0.43587E-09_JPRB,0.10479E-07_JPRB,0.11902E-07_JPRB,0.12737E-07_JPRB,0.13564E-07_JPRB, &
 & 0.14416E-07_JPRB,0.15545E-07_JPRB,0.21677E-07_JPRB,0.89455E-08_JPRB /)  
KA(:, 4, 6, 1) = (/ &
 & 0.54672E-09_JPRB,0.12017E-07_JPRB,0.13540E-07_JPRB,0.14423E-07_JPRB,0.15090E-07_JPRB, &
 & 0.16030E-07_JPRB,0.17496E-07_JPRB,0.20678E-07_JPRB,0.10490E-07_JPRB /)  
KA(:, 5, 6, 1) = (/ &
 & 0.66579E-09_JPRB,0.13493E-07_JPRB,0.15163E-07_JPRB,0.16178E-07_JPRB,0.16873E-07_JPRB, &
 & 0.17474E-07_JPRB,0.18852E-07_JPRB,0.21699E-07_JPRB,0.12216E-07_JPRB /)  
KA(:, 1, 7, 1) = (/ &
 & 0.16149E-09_JPRB,0.53201E-08_JPRB,0.60079E-08_JPRB,0.65349E-08_JPRB,0.72837E-08_JPRB, &
 & 0.90792E-08_JPRB,0.11028E-07_JPRB,0.15917E-07_JPRB,0.45574E-08_JPRB /)  
KA(:, 2, 7, 1) = (/ &
 & 0.22765E-09_JPRB,0.65457E-08_JPRB,0.74143E-08_JPRB,0.80126E-08_JPRB,0.85152E-08_JPRB, &
 & 0.94934E-08_JPRB,0.12210E-07_JPRB,0.16917E-07_JPRB,0.54301E-08_JPRB /)  
KA(:, 3, 7, 1) = (/ &
 & 0.30418E-09_JPRB,0.77971E-08_JPRB,0.88287E-08_JPRB,0.94927E-08_JPRB,0.10154E-07_JPRB, &
 & 0.10712E-07_JPRB,0.12099E-07_JPRB,0.16996E-07_JPRB,0.64594E-08_JPRB /)  
KA(:, 4, 7, 1) = (/ &
 & 0.38990E-09_JPRB,0.90563E-08_JPRB,0.10243E-07_JPRB,0.10928E-07_JPRB,0.11554E-07_JPRB, &
 & 0.12512E-07_JPRB,0.13254E-07_JPRB,0.17320E-07_JPRB,0.76835E-08_JPRB /)  
KA(:, 5, 7, 1) = (/ &
 & 0.48334E-09_JPRB,0.10307E-07_JPRB,0.11588E-07_JPRB,0.12345E-07_JPRB,0.12884E-07_JPRB, &
 & 0.13512E-07_JPRB,0.15051E-07_JPRB,0.17108E-07_JPRB,0.90662E-08_JPRB /)  
KA(:, 1, 8, 1) = (/ &
 & 0.10442E-09_JPRB,0.37895E-08_JPRB,0.42781E-08_JPRB,0.47285E-08_JPRB,0.55672E-08_JPRB, &
 & 0.67246E-08_JPRB,0.87615E-08_JPRB,0.12496E-07_JPRB,0.31063E-08_JPRB /)  
KA(:, 2, 8, 1) = (/ &
 & 0.15294E-09_JPRB,0.47545E-08_JPRB,0.53771E-08_JPRB,0.58176E-08_JPRB,0.63249E-08_JPRB, &
 & 0.74935E-08_JPRB,0.93024E-08_JPRB,0.13484E-07_JPRB,0.38514E-08_JPRB /)  
KA(:, 3, 8, 1) = (/ &
 & 0.21056E-09_JPRB,0.57727E-08_JPRB,0.65270E-08_JPRB,0.70416E-08_JPRB,0.74786E-08_JPRB, &
 & 0.80475E-08_JPRB,0.10012E-07_JPRB,0.13784E-07_JPRB,0.46496E-08_JPRB /)  
KA(:, 4, 8, 1) = (/ &
 & 0.27636E-09_JPRB,0.67987E-08_JPRB,0.77111E-08_JPRB,0.82983E-08_JPRB,0.87947E-08_JPRB, &
 & 0.93313E-08_JPRB,0.10204E-07_JPRB,0.14244E-07_JPRB,0.56141E-08_JPRB /)  
KA(:, 5, 8, 1) = (/ &
 & 0.34924E-09_JPRB,0.78297E-08_JPRB,0.88319E-08_JPRB,0.94055E-08_JPRB,0.98667E-08_JPRB, &
 & 0.10620E-07_JPRB,0.11396E-07_JPRB,0.13825E-07_JPRB,0.67139E-08_JPRB /)  
KA(:, 1, 9, 1) = (/ &
 & 0.66385E-10_JPRB,0.26743E-08_JPRB,0.30313E-08_JPRB,0.34595E-08_JPRB,0.42156E-08_JPRB, &
 & 0.50940E-08_JPRB,0.66728E-08_JPRB,0.10021E-07_JPRB,0.20965E-08_JPRB /)  
KA(:, 2, 9, 1) = (/ &
 & 0.10109E-09_JPRB,0.34278E-08_JPRB,0.38685E-08_JPRB,0.42217E-08_JPRB,0.47673E-08_JPRB, &
 & 0.59120E-08_JPRB,0.72992E-08_JPRB,0.10438E-07_JPRB,0.27321E-08_JPRB /)  
KA(:, 3, 9, 1) = (/ &
 & 0.14405E-09_JPRB,0.42386E-08_JPRB,0.48029E-08_JPRB,0.51840E-08_JPRB,0.55416E-08_JPRB, &
 & 0.62759E-08_JPRB,0.79851E-08_JPRB,0.11314E-07_JPRB,0.33332E-08_JPRB /)  
KA(:, 4, 9, 1) = (/ &
 & 0.19414E-09_JPRB,0.50774E-08_JPRB,0.57440E-08_JPRB,0.61764E-08_JPRB,0.66005E-08_JPRB, &
 & 0.69887E-08_JPRB,0.81552E-08_JPRB,0.11319E-07_JPRB,0.40828E-08_JPRB /)  
KA(:, 5, 9, 1) = (/ &
 & 0.25056E-09_JPRB,0.59198E-08_JPRB,0.67025E-08_JPRB,0.71627E-08_JPRB,0.76155E-08_JPRB, &
 & 0.81557E-08_JPRB,0.87035E-08_JPRB,0.11788E-07_JPRB,0.49512E-08_JPRB /)  
KA(:, 1,10, 1) = (/ &
 & 0.43147E-10_JPRB,0.19136E-08_JPRB,0.21883E-08_JPRB,0.26153E-08_JPRB,0.31055E-08_JPRB, &
 & 0.39720E-08_JPRB,0.51107E-08_JPRB,0.84498E-08_JPRB,0.15100E-08_JPRB /)  
KA(:, 2,10, 1) = (/ &
 & 0.68069E-10_JPRB,0.25012E-08_JPRB,0.28230E-08_JPRB,0.31278E-08_JPRB,0.37084E-08_JPRB, &
 & 0.44577E-08_JPRB,0.58316E-08_JPRB,0.82732E-08_JPRB,0.20294E-08_JPRB /)  
KA(:, 3,10, 1) = (/ &
 & 0.10013E-09_JPRB,0.31445E-08_JPRB,0.35530E-08_JPRB,0.38466E-08_JPRB,0.41961E-08_JPRB, &
 & 0.50063E-08_JPRB,0.61960E-08_JPRB,0.89421E-08_JPRB,0.24447E-08_JPRB /)  
KA(:, 4,10, 1) = (/ &
 & 0.13837E-09_JPRB,0.38258E-08_JPRB,0.43236E-08_JPRB,0.46732E-08_JPRB,0.49545E-08_JPRB, &
 & 0.53447E-08_JPRB,0.67172E-08_JPRB,0.92217E-08_JPRB,0.30274E-08_JPRB /)  
KA(:, 5,10, 1) = (/ &
 & 0.18212E-09_JPRB,0.45123E-08_JPRB,0.51146E-08_JPRB,0.55026E-08_JPRB,0.58368E-08_JPRB, &
 & 0.61896E-08_JPRB,0.67974E-08_JPRB,0.94910E-08_JPRB,0.36975E-08_JPRB /)  
KA(:, 1,11, 1) = (/ &
 & 0.35238E-10_JPRB,0.15650E-08_JPRB,0.17900E-08_JPRB,0.21398E-08_JPRB,0.25395E-08_JPRB, &
 & 0.32442E-08_JPRB,0.41684E-08_JPRB,0.68456E-08_JPRB,0.12890E-08_JPRB /)  
KA(:, 2,11, 1) = (/ &
 & 0.55588E-10_JPRB,0.20451E-08_JPRB,0.23079E-08_JPRB,0.25570E-08_JPRB,0.30342E-08_JPRB, &
 & 0.36465E-08_JPRB,0.47717E-08_JPRB,0.67353E-08_JPRB,0.16499E-08_JPRB /)  
KA(:, 3,11, 1) = (/ &
 & 0.81825E-10_JPRB,0.25719E-08_JPRB,0.29058E-08_JPRB,0.31458E-08_JPRB,0.34324E-08_JPRB, &
 & 0.40982E-08_JPRB,0.50669E-08_JPRB,0.73083E-08_JPRB,0.20031E-08_JPRB /)  
KA(:, 4,11, 1) = (/ &
 & 0.11311E-09_JPRB,0.31293E-08_JPRB,0.35365E-08_JPRB,0.38229E-08_JPRB,0.40518E-08_JPRB, &
 & 0.43730E-08_JPRB,0.54993E-08_JPRB,0.75470E-08_JPRB,0.24754E-08_JPRB /)  
KA(:, 5,11, 1) = (/ &
 & 0.14891E-09_JPRB,0.36915E-08_JPRB,0.41839E-08_JPRB,0.45010E-08_JPRB,0.47744E-08_JPRB, &
 & 0.50622E-08_JPRB,0.55621E-08_JPRB,0.77689E-08_JPRB,0.30237E-08_JPRB /)  
KA(:, 1,12, 1) = (/ &
 & 0.28851E-10_JPRB,0.12816E-08_JPRB,0.14656E-08_JPRB,0.17508E-08_JPRB,0.20791E-08_JPRB, &
 & 0.26542E-08_JPRB,0.34061E-08_JPRB,0.55940E-08_JPRB,0.10876E-08_JPRB /)  
KA(:, 2,12, 1) = (/ &
 & 0.45511E-10_JPRB,0.16747E-08_JPRB,0.18898E-08_JPRB,0.20935E-08_JPRB,0.24841E-08_JPRB, &
 & 0.29844E-08_JPRB,0.39040E-08_JPRB,0.54988E-08_JPRB,0.13569E-08_JPRB /)  
KA(:, 3,12, 1) = (/ &
 & 0.66972E-10_JPRB,0.21053E-08_JPRB,0.23788E-08_JPRB,0.25750E-08_JPRB,0.28091E-08_JPRB, &
 & 0.33541E-08_JPRB,0.41474E-08_JPRB,0.59783E-08_JPRB,0.16488E-08_JPRB /)  
KA(:, 4,12, 1) = (/ &
 & 0.92606E-10_JPRB,0.25620E-08_JPRB,0.28952E-08_JPRB,0.31304E-08_JPRB,0.33162E-08_JPRB, &
 & 0.35801E-08_JPRB,0.45003E-08_JPRB,0.61789E-08_JPRB,0.20293E-08_JPRB /)  
KA(:, 5,12, 1) = (/ &
 & 0.12192E-09_JPRB,0.30226E-08_JPRB,0.34255E-08_JPRB,0.36843E-08_JPRB,0.39084E-08_JPRB, &
 & 0.41445E-08_JPRB,0.45524E-08_JPRB,0.63605E-08_JPRB,0.24756E-08_JPRB /)  
KA(:, 1,13, 1) = (/ &
 & 0.23621E-10_JPRB,0.10494E-08_JPRB,0.11996E-08_JPRB,0.14331E-08_JPRB,0.17023E-08_JPRB, &
 & 0.21711E-08_JPRB,0.27844E-08_JPRB,0.45532E-08_JPRB,0.89489E-09_JPRB /)  
KA(:, 2,13, 1) = (/ &
 & 0.37261E-10_JPRB,0.13712E-08_JPRB,0.15471E-08_JPRB,0.17138E-08_JPRB,0.20333E-08_JPRB, &
 & 0.24433E-08_JPRB,0.31958E-08_JPRB,0.44925E-08_JPRB,0.11124E-08_JPRB /)  
KA(:, 3,13, 1) = (/ &
 & 0.54831E-10_JPRB,0.17238E-08_JPRB,0.19475E-08_JPRB,0.21082E-08_JPRB,0.23003E-08_JPRB, &
 & 0.27446E-08_JPRB,0.33959E-08_JPRB,0.48947E-08_JPRB,0.13514E-08_JPRB /)  
KA(:, 4,13, 1) = (/ &
 & 0.75799E-10_JPRB,0.20971E-08_JPRB,0.23698E-08_JPRB,0.25624E-08_JPRB,0.27143E-08_JPRB, &
 & 0.29304E-08_JPRB,0.36822E-08_JPRB,0.50589E-08_JPRB,0.16628E-08_JPRB /)  
KA(:, 5,13, 1) = (/ &
 & 0.99820E-10_JPRB,0.24745E-08_JPRB,0.28041E-08_JPRB,0.30159E-08_JPRB,0.31995E-08_JPRB, &
 & 0.33924E-08_JPRB,0.37279E-08_JPRB,0.52074E-08_JPRB,0.20270E-08_JPRB /)  
KA(:, 1, 1, 2) = (/ &
 & 0.13785E-07_JPRB,0.24738E-06_JPRB,0.32984E-06_JPRB,0.38970E-06_JPRB,0.43737E-06_JPRB, &
 & 0.50889E-06_JPRB,0.56985E-06_JPRB,0.52821E-06_JPRB,0.22857E-06_JPRB /)  
KA(:, 2, 1, 2) = (/ &
 & 0.15768E-07_JPRB,0.27583E-06_JPRB,0.36371E-06_JPRB,0.42333E-06_JPRB,0.46175E-06_JPRB, &
 & 0.50608E-06_JPRB,0.57108E-06_JPRB,0.57199E-06_JPRB,0.21992E-06_JPRB /)  
KA(:, 3, 1, 2) = (/ &
 & 0.17740E-07_JPRB,0.31295E-06_JPRB,0.41668E-06_JPRB,0.48111E-06_JPRB,0.52105E-06_JPRB, &
 & 0.56257E-06_JPRB,0.61638E-06_JPRB,0.64253E-06_JPRB,0.25630E-06_JPRB /)  
KA(:, 4, 1, 2) = (/ &
 & 0.19676E-07_JPRB,0.33378E-06_JPRB,0.43874E-06_JPRB,0.50021E-06_JPRB,0.53506E-06_JPRB, &
 & 0.56909E-06_JPRB,0.60800E-06_JPRB,0.63155E-06_JPRB,0.24206E-06_JPRB /)  
KA(:, 5, 1, 2) = (/ &
 & 0.21537E-07_JPRB,0.36160E-06_JPRB,0.47596E-06_JPRB,0.54056E-06_JPRB,0.57557E-06_JPRB, &
 & 0.60002E-06_JPRB,0.61606E-06_JPRB,0.61827E-06_JPRB,0.25207E-06_JPRB /)  
KA(:, 1, 2, 2) = (/ &
 & 0.10621E-07_JPRB,0.19636E-06_JPRB,0.26336E-06_JPRB,0.31062E-06_JPRB,0.35012E-06_JPRB, &
 & 0.41219E-06_JPRB,0.46827E-06_JPRB,0.42345E-06_JPRB,0.16044E-06_JPRB /)  
KA(:, 2, 2, 2) = (/ &
 & 0.12238E-07_JPRB,0.21970E-06_JPRB,0.28920E-06_JPRB,0.33755E-06_JPRB,0.37073E-06_JPRB, &
 & 0.41004E-06_JPRB,0.46315E-06_JPRB,0.45777E-06_JPRB,0.15877E-06_JPRB /)  
KA(:, 3, 2, 2) = (/ &
 & 0.13863E-07_JPRB,0.24955E-06_JPRB,0.33252E-06_JPRB,0.38359E-06_JPRB,0.41679E-06_JPRB, &
 & 0.45237E-06_JPRB,0.50277E-06_JPRB,0.51752E-06_JPRB,0.18617E-06_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART2',0,ZHOOK_HANDLE)


KA(:, 4, 2, 2) = (/ &
 & 0.15467E-07_JPRB,0.27294E-06_JPRB,0.36292E-06_JPRB,0.41560E-06_JPRB,0.44818E-06_JPRB, &
 & 0.47909E-06_JPRB,0.51811E-06_JPRB,0.54528E-06_JPRB,0.19311E-06_JPRB /)  
KA(:, 5, 2, 2) = (/ &
 & 0.17013E-07_JPRB,0.28946E-06_JPRB,0.38040E-06_JPRB,0.43177E-06_JPRB,0.46055E-06_JPRB, &
 & 0.48627E-06_JPRB,0.50036E-06_JPRB,0.50711E-06_JPRB,0.19056E-06_JPRB /)  
KA(:, 1, 3, 2) = (/ &
 & 0.79041E-08_JPRB,0.15193E-06_JPRB,0.20367E-06_JPRB,0.24255E-06_JPRB,0.27584E-06_JPRB, &
 & 0.33106E-06_JPRB,0.39018E-06_JPRB,0.33367E-06_JPRB,0.10147E-06_JPRB /)  
KA(:, 2, 3, 2) = (/ &
 & 0.92256E-08_JPRB,0.17005E-06_JPRB,0.22457E-06_JPRB,0.26442E-06_JPRB,0.29755E-06_JPRB, &
 & 0.33937E-06_JPRB,0.38659E-06_JPRB,0.36019E-06_JPRB,0.10982E-06_JPRB /)  
KA(:, 3, 3, 2) = (/ &
 & 0.10548E-07_JPRB,0.18874E-06_JPRB,0.24827E-06_JPRB,0.28648E-06_JPRB,0.31109E-06_JPRB, &
 & 0.33996E-06_JPRB,0.38319E-06_JPRB,0.38934E-06_JPRB,0.11953E-06_JPRB /)  
KA(:, 4, 3, 2) = (/ &
 & 0.11869E-07_JPRB,0.21314E-06_JPRB,0.28402E-06_JPRB,0.32565E-06_JPRB,0.35249E-06_JPRB, &
 & 0.38039E-06_JPRB,0.41637E-06_JPRB,0.43423E-06_JPRB,0.13779E-06_JPRB /)  
KA(:, 5, 3, 2) = (/ &
 & 0.13170E-07_JPRB,0.22682E-06_JPRB,0.29805E-06_JPRB,0.33849E-06_JPRB,0.36193E-06_JPRB, &
 & 0.38387E-06_JPRB,0.41078E-06_JPRB,0.42298E-06_JPRB,0.13819E-06_JPRB /)  
KA(:, 1, 4, 2) = (/ &
 & 0.57872E-08_JPRB,0.11704E-06_JPRB,0.15599E-06_JPRB,0.19092E-06_JPRB,0.22043E-06_JPRB, &
 & 0.26778E-06_JPRB,0.30128E-06_JPRB,0.25769E-06_JPRB,0.68111E-07_JPRB /)  
KA(:, 2, 4, 2) = (/ &
 & 0.68505E-08_JPRB,0.13037E-06_JPRB,0.17389E-06_JPRB,0.20556E-06_JPRB,0.23194E-06_JPRB, &
 & 0.27485E-06_JPRB,0.31447E-06_JPRB,0.28139E-06_JPRB,0.78259E-07_JPRB /)  
KA(:, 3, 4, 2) = (/ &
 & 0.79353E-08_JPRB,0.14574E-06_JPRB,0.19135E-06_JPRB,0.22328E-06_JPRB,0.24623E-06_JPRB, &
 & 0.27497E-06_JPRB,0.31125E-06_JPRB,0.30440E-06_JPRB,0.85397E-07_JPRB /)  
KA(:, 4, 4, 2) = (/ &
 & 0.90207E-08_JPRB,0.16075E-06_JPRB,0.21140E-06_JPRB,0.24210E-06_JPRB,0.26199E-06_JPRB, &
 & 0.28412E-06_JPRB,0.31832E-06_JPRB,0.32424E-06_JPRB,0.93374E-07_JPRB /)  
KA(:, 5, 4, 2) = (/ &
 & 0.10099E-07_JPRB,0.18068E-06_JPRB,0.24072E-06_JPRB,0.27515E-06_JPRB,0.29704E-06_JPRB, &
 & 0.31830E-06_JPRB,0.34575E-06_JPRB,0.36301E-06_JPRB,0.10959E-06_JPRB /)  
KA(:, 1, 5, 2) = (/ &
 & 0.42071E-08_JPRB,0.88799E-07_JPRB,0.11974E-06_JPRB,0.15503E-06_JPRB,0.18473E-06_JPRB, &
 & 0.21750E-06_JPRB,0.23111E-06_JPRB,0.19568E-06_JPRB,0.47645E-07_JPRB /)  
KA(:, 2, 5, 2) = (/ &
 & 0.50589E-08_JPRB,0.10003E-06_JPRB,0.13353E-06_JPRB,0.15994E-06_JPRB,0.18265E-06_JPRB, &
 & 0.22030E-06_JPRB,0.25851E-06_JPRB,0.22196E-06_JPRB,0.56400E-07_JPRB /)  
KA(:, 3, 5, 2) = (/ &
 & 0.59363E-08_JPRB,0.11183E-06_JPRB,0.14743E-06_JPRB,0.17446E-06_JPRB,0.19617E-06_JPRB, &
 & 0.22887E-06_JPRB,0.25813E-06_JPRB,0.23893E-06_JPRB,0.62471E-07_JPRB /)  
KA(:, 4, 5, 2) = (/ &
 & 0.68265E-08_JPRB,0.12408E-06_JPRB,0.16316E-06_JPRB,0.18879E-06_JPRB,0.20540E-06_JPRB, &
 & 0.22681E-06_JPRB,0.25640E-06_JPRB,0.25817E-06_JPRB,0.69233E-07_JPRB /)  
KA(:, 5, 5, 2) = (/ &
 & 0.77164E-08_JPRB,0.14022E-06_JPRB,0.18715E-06_JPRB,0.21470E-06_JPRB,0.23265E-06_JPRB, &
 & 0.25223E-06_JPRB,0.27783E-06_JPRB,0.28837E-06_JPRB,0.82855E-07_JPRB /)  
KA(:, 1, 6, 2) = (/ &
 & 0.30108E-08_JPRB,0.66997E-07_JPRB,0.92811E-07_JPRB,0.12074E-06_JPRB,0.15295E-06_JPRB, &
 & 0.17839E-06_JPRB,0.17246E-06_JPRB,0.14892E-06_JPRB,0.33739E-07_JPRB /)  
KA(:, 2, 6, 2) = (/ &
 & 0.36900E-08_JPRB,0.76605E-07_JPRB,0.10196E-06_JPRB,0.12672E-06_JPRB,0.14857E-06_JPRB, &
 & 0.17805E-06_JPRB,0.19825E-06_JPRB,0.16899E-06_JPRB,0.40438E-07_JPRB /)  
KA(:, 3, 6, 2) = (/ &
 & 0.43974E-08_JPRB,0.85358E-07_JPRB,0.11411E-06_JPRB,0.13507E-06_JPRB,0.15283E-06_JPRB, &
 & 0.18257E-06_JPRB,0.21172E-06_JPRB,0.18597E-06_JPRB,0.46134E-07_JPRB /)  
KA(:, 4, 6, 2) = (/ &
 & 0.51213E-08_JPRB,0.95538E-07_JPRB,0.12544E-06_JPRB,0.14691E-06_JPRB,0.16455E-06_JPRB, &
 & 0.18481E-06_JPRB,0.20979E-06_JPRB,0.20070E-06_JPRB,0.51618E-07_JPRB /)  
KA(:, 5, 6, 2) = (/ &
 & 0.58500E-08_JPRB,0.10543E-06_JPRB,0.13870E-06_JPRB,0.15918E-06_JPRB,0.17259E-06_JPRB, &
 & 0.18830E-06_JPRB,0.21165E-06_JPRB,0.21507E-06_JPRB,0.58184E-07_JPRB /)  
KA(:, 1, 7, 2) = (/ &
 & 0.21343E-08_JPRB,0.50731E-07_JPRB,0.73677E-07_JPRB,0.95876E-07_JPRB,0.12180E-06_JPRB, &
 & 0.14539E-06_JPRB,0.12792E-06_JPRB,0.11548E-06_JPRB,0.24049E-07_JPRB /)  
KA(:, 2, 7, 2) = (/ &
 & 0.26695E-08_JPRB,0.57886E-07_JPRB,0.78431E-07_JPRB,0.10179E-06_JPRB,0.12404E-06_JPRB, &
 & 0.14498E-06_JPRB,0.15075E-06_JPRB,0.12789E-06_JPRB,0.28929E-07_JPRB /)  
KA(:, 3, 7, 2) = (/ &
 & 0.32350E-08_JPRB,0.65356E-07_JPRB,0.87120E-07_JPRB,0.10537E-06_JPRB,0.12108E-06_JPRB, &
 & 0.14722E-06_JPRB,0.16980E-06_JPRB,0.14529E-06_JPRB,0.34426E-07_JPRB /)  
KA(:, 4, 7, 2) = (/ &
 & 0.38202E-08_JPRB,0.73009E-07_JPRB,0.96634E-07_JPRB,0.11454E-06_JPRB,0.12893E-06_JPRB, &
 & 0.15239E-06_JPRB,0.17280E-06_JPRB,0.15699E-06_JPRB,0.38936E-07_JPRB /)  
KA(:, 5, 7, 2) = (/ &
 & 0.44151E-08_JPRB,0.81203E-07_JPRB,0.10676E-06_JPRB,0.12425E-06_JPRB,0.13576E-06_JPRB, &
 & 0.15119E-06_JPRB,0.17122E-06_JPRB,0.16974E-06_JPRB,0.43692E-07_JPRB /)  
KA(:, 1, 8, 2) = (/ &
 & 0.15010E-08_JPRB,0.38595E-07_JPRB,0.58295E-07_JPRB,0.77729E-07_JPRB,0.98683E-07_JPRB, &
 & 0.10992E-06_JPRB,0.95145E-07_JPRB,0.92252E-07_JPRB,0.17319E-07_JPRB /)  
KA(:, 2, 8, 2) = (/ &
 & 0.19201E-08_JPRB,0.43791E-07_JPRB,0.61750E-07_JPRB,0.79921E-07_JPRB,0.10136E-06_JPRB, &
 & 0.11894E-06_JPRB,0.11276E-06_JPRB,0.97846E-07_JPRB,0.20720E-07_JPRB /)  
KA(:, 3, 8, 2) = (/ &
 & 0.23693E-08_JPRB,0.50071E-07_JPRB,0.66873E-07_JPRB,0.85063E-07_JPRB,0.10052E-06_JPRB, &
 & 0.11892E-06_JPRB,0.13009E-06_JPRB,0.11045E-06_JPRB,0.25527E-07_JPRB /)  
KA(:, 4, 8, 2) = (/ &
 & 0.28395E-08_JPRB,0.55947E-07_JPRB,0.74757E-07_JPRB,0.88934E-07_JPRB,0.10114E-06_JPRB, &
 & 0.12142E-06_JPRB,0.14341E-06_JPRB,0.12281E-06_JPRB,0.28938E-07_JPRB /)  
KA(:, 5, 8, 2) = (/ &
 & 0.33227E-08_JPRB,0.62620E-07_JPRB,0.82343E-07_JPRB,0.96807E-07_JPRB,0.10922E-06_JPRB, &
 & 0.12542E-06_JPRB,0.14247E-06_JPRB,0.13252E-06_JPRB,0.32804E-07_JPRB /)  
KA(:, 1, 9, 2) = (/ &
 & 0.10437E-08_JPRB,0.30107E-07_JPRB,0.47694E-07_JPRB,0.63218E-07_JPRB,0.80199E-07_JPRB, &
 & 0.81465E-07_JPRB,0.70748E-07_JPRB,0.72461E-07_JPRB,0.12620E-07_JPRB /)  
KA(:, 2, 9, 2) = (/ &
 & 0.13691E-08_JPRB,0.33315E-07_JPRB,0.48674E-07_JPRB,0.63756E-07_JPRB,0.81165E-07_JPRB, &
 & 0.96892E-07_JPRB,0.83814E-07_JPRB,0.76311E-07_JPRB,0.14799E-07_JPRB /)  
KA(:, 3, 9, 2) = (/ &
 & 0.17229E-08_JPRB,0.37985E-07_JPRB,0.51777E-07_JPRB,0.67272E-07_JPRB,0.83770E-07_JPRB, &
 & 0.97220E-07_JPRB,0.98951E-07_JPRB,0.84136E-07_JPRB,0.18369E-07_JPRB /)  
KA(:, 4, 9, 2) = (/ &
 & 0.20990E-08_JPRB,0.43091E-07_JPRB,0.57320E-07_JPRB,0.69933E-07_JPRB,0.81214E-07_JPRB, &
 & 0.98518E-07_JPRB,0.11188E-06_JPRB,0.95453E-07_JPRB,0.21724E-07_JPRB /)  
KA(:, 5, 9, 2) = (/ &
 & 0.24895E-08_JPRB,0.48030E-07_JPRB,0.63808E-07_JPRB,0.75595E-07_JPRB,0.85237E-07_JPRB, &
 & 0.10122E-06_JPRB,0.11598E-06_JPRB,0.10350E-06_JPRB,0.24792E-07_JPRB /)  
KA(:, 1,10, 2) = (/ &
 & 0.73565E-09_JPRB,0.23201E-07_JPRB,0.38192E-07_JPRB,0.51890E-07_JPRB,0.66677E-07_JPRB, &
 & 0.60941E-07_JPRB,0.53794E-07_JPRB,0.57060E-07_JPRB,0.95538E-08_JPRB /)  
KA(:, 2,10, 2) = (/ &
 & 0.98838E-09_JPRB,0.25706E-07_JPRB,0.38945E-07_JPRB,0.51950E-07_JPRB,0.65881E-07_JPRB, &
 & 0.73501E-07_JPRB,0.63459E-07_JPRB,0.61276E-07_JPRB,0.10909E-07_JPRB /)  
KA(:, 3,10, 2) = (/ &
 & 0.12675E-08_JPRB,0.29153E-07_JPRB,0.41180E-07_JPRB,0.53354E-07_JPRB,0.67729E-07_JPRB, &
 & 0.79616E-07_JPRB,0.75117E-07_JPRB,0.65122E-07_JPRB,0.13531E-07_JPRB /)  
KA(:, 4,10, 2) = (/ &
 & 0.15675E-08_JPRB,0.33329E-07_JPRB,0.44560E-07_JPRB,0.57066E-07_JPRB,0.67627E-07_JPRB, &
 & 0.79638E-07_JPRB,0.86678E-07_JPRB,0.73448E-07_JPRB,0.16804E-07_JPRB /)  
KA(:, 5,10, 2) = (/ &
 & 0.18817E-08_JPRB,0.37257E-07_JPRB,0.49746E-07_JPRB,0.59306E-07_JPRB,0.67554E-07_JPRB, &
 & 0.81218E-07_JPRB,0.96337E-07_JPRB,0.82154E-07_JPRB,0.18958E-07_JPRB /)  
KA(:, 1,11, 2) = (/ &
 & 0.60140E-09_JPRB,0.19007E-07_JPRB,0.31253E-07_JPRB,0.42433E-07_JPRB,0.54566E-07_JPRB, &
 & 0.50044E-07_JPRB,0.44177E-07_JPRB,0.46695E-07_JPRB,0.77009E-08_JPRB /)  
KA(:, 2,11, 2) = (/ &
 & 0.80782E-09_JPRB,0.21033E-07_JPRB,0.31865E-07_JPRB,0.42505E-07_JPRB,0.53930E-07_JPRB, &
 & 0.60271E-07_JPRB,0.51969E-07_JPRB,0.49836E-07_JPRB,0.88971E-08_JPRB /)  
KA(:, 3,11, 2) = (/ &
 & 0.10365E-08_JPRB,0.23860E-07_JPRB,0.33711E-07_JPRB,0.43668E-07_JPRB,0.55447E-07_JPRB, &
 & 0.65129E-07_JPRB,0.61514E-07_JPRB,0.53242E-07_JPRB,0.11044E-07_JPRB /)  
KA(:, 4,11, 2) = (/ &
 & 0.12819E-08_JPRB,0.27278E-07_JPRB,0.36477E-07_JPRB,0.46671E-07_JPRB,0.55334E-07_JPRB, &
 & 0.65191E-07_JPRB,0.70955E-07_JPRB,0.60123E-07_JPRB,0.13732E-07_JPRB /)  
KA(:, 5,11, 2) = (/ &
 & 0.15394E-08_JPRB,0.30488E-07_JPRB,0.40723E-07_JPRB,0.48551E-07_JPRB,0.55301E-07_JPRB, &
 & 0.66490E-07_JPRB,0.78877E-07_JPRB,0.67264E-07_JPRB,0.15488E-07_JPRB /)  
KA(:, 1,12, 2) = (/ &
 & 0.49234E-09_JPRB,0.15554E-07_JPRB,0.25575E-07_JPRB,0.34616E-07_JPRB,0.44615E-07_JPRB, &
 & 0.41056E-07_JPRB,0.36097E-07_JPRB,0.38091E-07_JPRB,0.62448E-08_JPRB /)  
KA(:, 2,12, 2) = (/ &
 & 0.66141E-09_JPRB,0.17225E-07_JPRB,0.26080E-07_JPRB,0.34787E-07_JPRB,0.44118E-07_JPRB, &
 & 0.49432E-07_JPRB,0.42531E-07_JPRB,0.40718E-07_JPRB,0.72624E-08_JPRB /)  
KA(:, 3,12, 2) = (/ &
 & 0.84839E-09_JPRB,0.19539E-07_JPRB,0.27604E-07_JPRB,0.35754E-07_JPRB,0.45370E-07_JPRB, &
 & 0.53306E-07_JPRB,0.50418E-07_JPRB,0.43565E-07_JPRB,0.90256E-08_JPRB /)  
KA(:, 4,12, 2) = (/ &
 & 0.10495E-08_JPRB,0.22342E-07_JPRB,0.29867E-07_JPRB,0.38196E-07_JPRB,0.45322E-07_JPRB, &
 & 0.53368E-07_JPRB,0.58112E-07_JPRB,0.49244E-07_JPRB,0.11197E-07_JPRB /)  
KA(:, 5,12, 2) = (/ &
 & 0.12604E-08_JPRB,0.24969E-07_JPRB,0.33348E-07_JPRB,0.39742E-07_JPRB,0.45269E-07_JPRB, &
 & 0.54454E-07_JPRB,0.64580E-07_JPRB,0.55079E-07_JPRB,0.12657E-07_JPRB /)  
KA(:, 1,13, 2) = (/ &
 & 0.40306E-09_JPRB,0.12738E-07_JPRB,0.20936E-07_JPRB,0.28312E-07_JPRB,0.36505E-07_JPRB, &
 & 0.33674E-07_JPRB,0.29525E-07_JPRB,0.31139E-07_JPRB,0.51040E-08_JPRB /)  
KA(:, 2,13, 2) = (/ &
 & 0.54151E-09_JPRB,0.14106E-07_JPRB,0.21346E-07_JPRB,0.28471E-07_JPRB,0.36139E-07_JPRB, &
 & 0.40516E-07_JPRB,0.34830E-07_JPRB,0.33325E-07_JPRB,0.59425E-08_JPRB /)  
KA(:, 3,13, 2) = (/ &
 & 0.69468E-09_JPRB,0.15999E-07_JPRB,0.22600E-07_JPRB,0.29268E-07_JPRB,0.37150E-07_JPRB, &
 & 0.43635E-07_JPRB,0.41297E-07_JPRB,0.35646E-07_JPRB,0.73862E-08_JPRB /)  
KA(:, 4,13, 2) = (/ &
 & 0.85913E-09_JPRB,0.18290E-07_JPRB,0.24452E-07_JPRB,0.31282E-07_JPRB,0.37096E-07_JPRB, &
 & 0.43709E-07_JPRB,0.47585E-07_JPRB,0.40319E-07_JPRB,0.91581E-08_JPRB /)  
KA(:, 5,13, 2) = (/ &
 & 0.10319E-08_JPRB,0.20440E-07_JPRB,0.27299E-07_JPRB,0.32532E-07_JPRB,0.37047E-07_JPRB, &
 & 0.44575E-07_JPRB,0.52880E-07_JPRB,0.45086E-07_JPRB,0.10367E-07_JPRB /)  
KA(:, 1, 1, 3) = (/ &
 & 0.77542E-07_JPRB,0.72331E-06_JPRB,0.98561E-06_JPRB,0.11860E-05_JPRB,0.13497E-05_JPRB, &
 & 0.13448E-05_JPRB,0.13214E-05_JPRB,0.14401E-05_JPRB,0.51217E-06_JPRB /)  
KA(:, 2, 1, 3) = (/ &
 & 0.83965E-07_JPRB,0.81202E-06_JPRB,0.11096E-05_JPRB,0.13150E-05_JPRB,0.14966E-05_JPRB, &
 & 0.14837E-05_JPRB,0.13715E-05_JPRB,0.14446E-05_JPRB,0.53558E-06_JPRB /)  
KA(:, 3, 1, 3) = (/ &
 & 0.89893E-07_JPRB,0.91147E-06_JPRB,0.12494E-05_JPRB,0.14817E-05_JPRB,0.16581E-05_JPRB, &
 & 0.16379E-05_JPRB,0.14913E-05_JPRB,0.13540E-05_JPRB,0.57527E-06_JPRB /)  
KA(:, 4, 1, 3) = (/ &
 & 0.95336E-07_JPRB,0.98977E-06_JPRB,0.13580E-05_JPRB,0.16044E-05_JPRB,0.17602E-05_JPRB, &
 & 0.17289E-05_JPRB,0.15601E-05_JPRB,0.13435E-05_JPRB,0.60153E-06_JPRB /)  
KA(:, 5, 1, 3) = (/ &
 & 0.10024E-06_JPRB,0.10817E-05_JPRB,0.14820E-05_JPRB,0.17354E-05_JPRB,0.18806E-05_JPRB, &
 & 0.18468E-05_JPRB,0.16817E-05_JPRB,0.14550E-05_JPRB,0.63092E-06_JPRB /)  
KA(:, 1, 2, 3) = (/ &
 & 0.61222E-07_JPRB,0.57382E-06_JPRB,0.78272E-06_JPRB,0.94950E-06_JPRB,0.10796E-05_JPRB, &
 & 0.10829E-05_JPRB,0.10794E-05_JPRB,0.12292E-05_JPRB,0.35440E-06_JPRB /)  
KA(:, 2, 2, 3) = (/ &
 & 0.66652E-07_JPRB,0.64604E-06_JPRB,0.88511E-06_JPRB,0.10523E-05_JPRB,0.12028E-05_JPRB, &
 & 0.11924E-05_JPRB,0.11103E-05_JPRB,0.11987E-05_JPRB,0.38232E-06_JPRB /)  
KA(:, 3, 2, 3) = (/ &
 & 0.71672E-07_JPRB,0.73084E-06_JPRB,0.10012E-05_JPRB,0.11880E-05_JPRB,0.13384E-05_JPRB, &
 & 0.13220E-05_JPRB,0.12030E-05_JPRB,0.11381E-05_JPRB,0.43262E-06_JPRB /)  
KA(:, 4, 2, 3) = (/ &
 & 0.76301E-07_JPRB,0.80259E-06_JPRB,0.11033E-05_JPRB,0.13071E-05_JPRB,0.14343E-05_JPRB, &
 & 0.14171E-05_JPRB,0.12785E-05_JPRB,0.11080E-05_JPRB,0.46030E-06_JPRB /)  
KA(:, 5, 2, 3) = (/ &
 & 0.80500E-07_JPRB,0.87105E-06_JPRB,0.11939E-05_JPRB,0.14005E-05_JPRB,0.15153E-05_JPRB, &
 & 0.14864E-05_JPRB,0.13529E-05_JPRB,0.11688E-05_JPRB,0.48117E-06_JPRB /)  
KA(:, 1, 3, 3) = (/ &
 & 0.47304E-07_JPRB,0.44051E-06_JPRB,0.60584E-06_JPRB,0.74769E-06_JPRB,0.84468E-06_JPRB, &
 & 0.85077E-06_JPRB,0.85665E-06_JPRB,0.10494E-05_JPRB,0.24668E-06_JPRB /)  
KA(:, 2, 3, 3) = (/ &
 & 0.51943E-07_JPRB,0.50181E-06_JPRB,0.68762E-06_JPRB,0.82034E-06_JPRB,0.93657E-06_JPRB, &
 & 0.92789E-06_JPRB,0.88766E-06_JPRB,0.99297E-06_JPRB,0.26836E-06_JPRB /)  
KA(:, 3, 3, 3) = (/ &
 & 0.56252E-07_JPRB,0.56363E-06_JPRB,0.77259E-06_JPRB,0.91469E-06_JPRB,0.10403E-05_JPRB, &
 & 0.10243E-05_JPRB,0.93713E-06_JPRB,0.99098E-06_JPRB,0.29882E-06_JPRB /)  
KA(:, 4, 3, 3) = (/ &
 & 0.60224E-07_JPRB,0.63130E-06_JPRB,0.86724E-06_JPRB,0.10288E-05_JPRB,0.11344E-05_JPRB, &
 & 0.11222E-05_JPRB,0.10162E-05_JPRB,0.91320E-06_JPRB,0.33854E-06_JPRB /)  
KA(:, 5, 3, 3) = (/ &
 & 0.63868E-07_JPRB,0.68673E-06_JPRB,0.94084E-06_JPRB,0.11069E-05_JPRB,0.12001E-05_JPRB, &
 & 0.11819E-05_JPRB,0.10625E-05_JPRB,0.91639E-06_JPRB,0.36042E-06_JPRB /)  
KA(:, 1, 4, 3) = (/ &
 & 0.36151E-07_JPRB,0.33292E-06_JPRB,0.46957E-06_JPRB,0.57176E-06_JPRB,0.64965E-06_JPRB, &
 & 0.66578E-06_JPRB,0.71030E-06_JPRB,0.90686E-06_JPRB,0.17407E-06_JPRB /)  
KA(:, 2, 4, 3) = (/ &
 & 0.40107E-07_JPRB,0.38424E-06_JPRB,0.52571E-06_JPRB,0.63554E-06_JPRB,0.72553E-06_JPRB, &
 & 0.72856E-06_JPRB,0.72697E-06_JPRB,0.84339E-06_JPRB,0.19253E-06_JPRB /)  
KA(:, 3, 4, 3) = (/ &
 & 0.43816E-07_JPRB,0.43401E-06_JPRB,0.59546E-06_JPRB,0.70644E-06_JPRB,0.80752E-06_JPRB, &
 & 0.79519E-06_JPRB,0.74520E-06_JPRB,0.81506E-06_JPRB,0.21830E-06_JPRB /)  
KA(:, 4, 4, 3) = (/ &
 & 0.47242E-07_JPRB,0.48695E-06_JPRB,0.66577E-06_JPRB,0.78531E-06_JPRB,0.87970E-06_JPRB, &
 & 0.86799E-06_JPRB,0.78705E-06_JPRB,0.76812E-06_JPRB,0.24161E-06_JPRB /)  
KA(:, 5, 4, 3) = (/ &
 & 0.50394E-07_JPRB,0.54183E-06_JPRB,0.74240E-06_JPRB,0.87572E-06_JPRB,0.95669E-06_JPRB, &
 & 0.94640E-06_JPRB,0.85379E-06_JPRB,0.74722E-06_JPRB,0.28102E-06_JPRB /)  
KA(:, 1, 5, 3) = (/ &
 & 0.27462E-07_JPRB,0.25134E-06_JPRB,0.35698E-06_JPRB,0.43146E-06_JPRB,0.48552E-06_JPRB, &
 & 0.53177E-06_JPRB,0.62976E-06_JPRB,0.75904E-06_JPRB,0.12452E-06_JPRB /)  
KA(:, 2, 5, 3) = (/ &
 & 0.30835E-07_JPRB,0.29261E-06_JPRB,0.40164E-06_JPRB,0.49701E-06_JPRB,0.56250E-06_JPRB, &
 & 0.56722E-06_JPRB,0.57761E-06_JPRB,0.72004E-06_JPRB,0.13996E-06_JPRB /)  
KA(:, 3, 5, 3) = (/ &
 & 0.33997E-07_JPRB,0.33394E-06_JPRB,0.45684E-06_JPRB,0.54380E-06_JPRB,0.62140E-06_JPRB, &
 & 0.61241E-06_JPRB,0.60037E-06_JPRB,0.67265E-06_JPRB,0.16106E-06_JPRB /)  
KA(:, 4, 5, 3) = (/ &
 & 0.36946E-07_JPRB,0.37590E-06_JPRB,0.51390E-06_JPRB,0.60628E-06_JPRB,0.69027E-06_JPRB, &
 & 0.67692E-06_JPRB,0.62237E-06_JPRB,0.67035E-06_JPRB,0.18128E-06_JPRB /)  
KA(:, 5, 5, 3) = (/ &
 & 0.39670E-07_JPRB,0.42211E-06_JPRB,0.57710E-06_JPRB,0.68190E-06_JPRB,0.75209E-06_JPRB, &
 & 0.74450E-06_JPRB,0.67496E-06_JPRB,0.61709E-06_JPRB,0.21416E-06_JPRB /)  
KA(:, 1, 6, 3) = (/ &
 & 0.20602E-07_JPRB,0.18703E-06_JPRB,0.26972E-06_JPRB,0.33456E-06_JPRB,0.36532E-06_JPRB, &
 & 0.42767E-06_JPRB,0.56721E-06_JPRB,0.66482E-06_JPRB,0.87936E-07_JPRB /)  
KA(:, 2, 6, 3) = (/ &
 & 0.23484E-07_JPRB,0.21971E-06_JPRB,0.30953E-06_JPRB,0.37643E-06_JPRB,0.42627E-06_JPRB, &
 & 0.44517E-06_JPRB,0.48560E-06_JPRB,0.61604E-06_JPRB,0.10185E-06_JPRB /)  
KA(:, 3, 6, 3) = (/ &
 & 0.26181E-07_JPRB,0.25382E-06_JPRB,0.34607E-06_JPRB,0.41971E-06_JPRB,0.47851E-06_JPRB, &
 & 0.48129E-06_JPRB,0.48156E-06_JPRB,0.56916E-06_JPRB,0.11864E-06_JPRB /)  
KA(:, 4, 6, 3) = (/ &
 & 0.28705E-07_JPRB,0.28735E-06_JPRB,0.39181E-06_JPRB,0.46499E-06_JPRB,0.52971E-06_JPRB, &
 & 0.52262E-06_JPRB,0.49397E-06_JPRB,0.54792E-06_JPRB,0.13605E-06_JPRB /)  
KA(:, 5, 6, 3) = (/ &
 & 0.31065E-07_JPRB,0.32265E-06_JPRB,0.43948E-06_JPRB,0.51712E-06_JPRB,0.58131E-06_JPRB, &
 & 0.57275E-06_JPRB,0.52154E-06_JPRB,0.53300E-06_JPRB,0.15326E-06_JPRB /)  
KA(:, 1, 7, 3) = (/ &
 & 0.15315E-07_JPRB,0.13867E-06_JPRB,0.20497E-06_JPRB,0.25791E-06_JPRB,0.28251E-06_JPRB, &
 & 0.36209E-06_JPRB,0.48615E-06_JPRB,0.57617E-06_JPRB,0.62083E-07_JPRB /)  
KA(:, 2, 7, 3) = (/ &
 & 0.17770E-07_JPRB,0.16467E-06_JPRB,0.23430E-06_JPRB,0.28445E-06_JPRB,0.31749E-06_JPRB, &
 & 0.35373E-06_JPRB,0.43530E-06_JPRB,0.51750E-06_JPRB,0.74598E-07_JPRB /)  
KA(:, 3, 7, 3) = (/ &
 & 0.20071E-07_JPRB,0.19194E-06_JPRB,0.26349E-06_JPRB,0.32575E-06_JPRB,0.37090E-06_JPRB, &
 & 0.37391E-06_JPRB,0.38838E-06_JPRB,0.49613E-06_JPRB,0.88392E-07_JPRB /)  
KA(:, 4, 7, 3) = (/ &
 & 0.22230E-07_JPRB,0.21953E-06_JPRB,0.29840E-06_JPRB,0.35680E-06_JPRB,0.40841E-06_JPRB, &
 & 0.40516E-06_JPRB,0.40513E-06_JPRB,0.45518E-06_JPRB,0.10149E-06_JPRB /)  
KA(:, 5, 7, 3) = (/ &
 & 0.24244E-07_JPRB,0.24730E-06_JPRB,0.33583E-06_JPRB,0.39740E-06_JPRB,0.45364E-06_JPRB, &
 & 0.44496E-06_JPRB,0.41471E-06_JPRB,0.45022E-06_JPRB,0.11554E-06_JPRB /)  
KA(:, 1, 8, 3) = (/ &
 & 0.11318E-07_JPRB,0.10309E-06_JPRB,0.15679E-06_JPRB,0.19765E-06_JPRB,0.22300E-06_JPRB, &
 & 0.30242E-06_JPRB,0.40824E-06_JPRB,0.49442E-06_JPRB,0.44061E-07_JPRB /)  
KA(:, 2, 8, 3) = (/ &
 & 0.13358E-07_JPRB,0.12273E-06_JPRB,0.17705E-06_JPRB,0.22062E-06_JPRB,0.24115E-06_JPRB, &
 & 0.28999E-06_JPRB,0.39012E-06_JPRB,0.45451E-06_JPRB,0.54847E-07_JPRB /)  
KA(:, 3, 8, 3) = (/ &
 & 0.15323E-07_JPRB,0.14448E-06_JPRB,0.20316E-06_JPRB,0.24566E-06_JPRB,0.27787E-06_JPRB, &
 & 0.29655E-06_JPRB,0.33237E-06_JPRB,0.41480E-06_JPRB,0.64157E-07_JPRB /)  
KA(:, 4, 8, 3) = (/ &
 & 0.17158E-07_JPRB,0.16673E-06_JPRB,0.22673E-06_JPRB,0.27760E-06_JPRB,0.31491E-06_JPRB, &
 & 0.31778E-06_JPRB,0.31818E-06_JPRB,0.38422E-06_JPRB,0.75698E-07_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


SUBROUTINE PART3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART3',0,ZHOOK_HANDLE)


KA(:, 5, 8, 3) = (/ &
 & 0.18880E-07_JPRB,0.18905E-06_JPRB,0.25711E-06_JPRB,0.30558E-06_JPRB,0.34820E-06_JPRB, &
 & 0.34226E-06_JPRB,0.32757E-06_JPRB,0.36903E-06_JPRB,0.87559E-07_JPRB /)  
KA(:, 1, 9, 3) = (/ &
 & 0.83060E-08_JPRB,0.76710E-07_JPRB,0.11565E-06_JPRB,0.14764E-06_JPRB,0.17329E-06_JPRB, &
 & 0.25783E-06_JPRB,0.35957E-06_JPRB,0.41243E-06_JPRB,0.31797E-07_JPRB /)  
KA(:, 2, 9, 3) = (/ &
 & 0.99651E-08_JPRB,0.91242E-07_JPRB,0.13632E-06_JPRB,0.17065E-06_JPRB,0.18967E-06_JPRB, &
 & 0.24393E-06_JPRB,0.32914E-06_JPRB,0.39160E-06_JPRB,0.39225E-07_JPRB /)  
KA(:, 3, 9, 3) = (/ &
 & 0.11621E-07_JPRB,0.10845E-06_JPRB,0.15426E-06_JPRB,0.18813E-06_JPRB,0.20803E-06_JPRB, &
 & 0.23565E-06_JPRB,0.29600E-06_JPRB,0.35083E-06_JPRB,0.47417E-07_JPRB /)  
KA(:, 4, 9, 3) = (/ &
 & 0.13182E-07_JPRB,0.12617E-06_JPRB,0.17363E-06_JPRB,0.21434E-06_JPRB,0.24338E-06_JPRB, &
 & 0.24767E-06_JPRB,0.26174E-06_JPRB,0.33967E-06_JPRB,0.56851E-07_JPRB /)  
KA(:, 5, 9, 3) = (/ &
 & 0.14647E-07_JPRB,0.14462E-06_JPRB,0.19609E-06_JPRB,0.23554E-06_JPRB,0.26966E-06_JPRB, &
 & 0.27000E-06_JPRB,0.26860E-06_JPRB,0.30941E-06_JPRB,0.65848E-07_JPRB /)  
KA(:, 1,10, 3) = (/ &
 & 0.61513E-08_JPRB,0.59201E-07_JPRB,0.89564E-07_JPRB,0.11096E-06_JPRB,0.13963E-06_JPRB, &
 & 0.22868E-06_JPRB,0.30519E-06_JPRB,0.34949E-06_JPRB,0.23910E-07_JPRB /)  
KA(:, 2,10, 3) = (/ &
 & 0.74969E-08_JPRB,0.68921E-07_JPRB,0.10513E-06_JPRB,0.13256E-06_JPRB,0.14959E-06_JPRB, &
 & 0.20339E-06_JPRB,0.27500E-06_JPRB,0.33281E-06_JPRB,0.28611E-07_JPRB /)  
KA(:, 3,10, 3) = (/ &
 & 0.88625E-08_JPRB,0.82016E-07_JPRB,0.11818E-06_JPRB,0.14725E-06_JPRB,0.16097E-06_JPRB, &
 & 0.19608E-06_JPRB,0.26185E-06_JPRB,0.30530E-06_JPRB,0.35935E-07_JPRB /)  
KA(:, 4,10, 3) = (/ &
 & 0.10184E-07_JPRB,0.96432E-07_JPRB,0.13542E-06_JPRB,0.16348E-06_JPRB,0.18477E-06_JPRB, &
 & 0.19886E-06_JPRB,0.22449E-06_JPRB,0.27787E-06_JPRB,0.42133E-07_JPRB /)  
KA(:, 5,10, 3) = (/ &
 & 0.11421E-07_JPRB,0.11117E-06_JPRB,0.15107E-06_JPRB,0.18528E-06_JPRB,0.21005E-06_JPRB, &
 & 0.21209E-06_JPRB,0.21257E-06_JPRB,0.25796E-06_JPRB,0.49988E-07_JPRB /)  
KA(:, 1,11, 3) = (/ &
 & 0.50310E-08_JPRB,0.48563E-07_JPRB,0.73473E-07_JPRB,0.91094E-07_JPRB,0.11455E-06_JPRB, &
 & 0.18734E-06_JPRB,0.24995E-06_JPRB,0.28620E-06_JPRB,0.19440E-07_JPRB /)  
KA(:, 2,11, 3) = (/ &
 & 0.61304E-08_JPRB,0.56532E-07_JPRB,0.86340E-07_JPRB,0.10878E-06_JPRB,0.12244E-06_JPRB, &
 & 0.16646E-06_JPRB,0.22541E-06_JPRB,0.27316E-06_JPRB,0.23338E-07_JPRB /)  
KA(:, 3,11, 3) = (/ &
 & 0.72491E-08_JPRB,0.67226E-07_JPRB,0.96798E-07_JPRB,0.12061E-06_JPRB,0.13181E-06_JPRB, &
 & 0.16043E-06_JPRB,0.21436E-06_JPRB,0.24928E-06_JPRB,0.29352E-07_JPRB /)  
KA(:, 4,11, 3) = (/ &
 & 0.83326E-08_JPRB,0.78998E-07_JPRB,0.11085E-06_JPRB,0.13391E-06_JPRB,0.15135E-06_JPRB, &
 & 0.16281E-06_JPRB,0.18360E-06_JPRB,0.22741E-06_JPRB,0.34425E-07_JPRB /)  
KA(:, 5,11, 3) = (/ &
 & 0.93458E-08_JPRB,0.91055E-07_JPRB,0.12364E-06_JPRB,0.15181E-06_JPRB,0.17196E-06_JPRB, &
 & 0.17367E-06_JPRB,0.17400E-06_JPRB,0.21108E-06_JPRB,0.40855E-07_JPRB /)  
KA(:, 1,12, 3) = (/ &
 & 0.41189E-08_JPRB,0.39856E-07_JPRB,0.60140E-07_JPRB,0.74963E-07_JPRB,0.94012E-07_JPRB, &
 & 0.15333E-06_JPRB,0.20441E-06_JPRB,0.23474E-06_JPRB,0.15853E-07_JPRB /)  
KA(:, 2,12, 3) = (/ &
 & 0.50193E-08_JPRB,0.46348E-07_JPRB,0.70855E-07_JPRB,0.89301E-07_JPRB,0.10040E-06_JPRB, &
 & 0.13626E-06_JPRB,0.18429E-06_JPRB,0.22399E-06_JPRB,0.19078E-07_JPRB /)  
KA(:, 3,12, 3) = (/ &
 & 0.59344E-08_JPRB,0.55100E-07_JPRB,0.79255E-07_JPRB,0.98783E-07_JPRB,0.10799E-06_JPRB, &
 & 0.13125E-06_JPRB,0.17544E-06_JPRB,0.20357E-06_JPRB,0.24013E-07_JPRB /)  
KA(:, 4,12, 3) = (/ &
 & 0.68228E-08_JPRB,0.64743E-07_JPRB,0.90843E-07_JPRB,0.10971E-06_JPRB,0.12396E-06_JPRB, &
 & 0.13321E-06_JPRB,0.15026E-06_JPRB,0.18611E-06_JPRB,0.28198E-07_JPRB /)  
KA(:, 5,12, 3) = (/ &
 & 0.76512E-08_JPRB,0.74591E-07_JPRB,0.10123E-06_JPRB,0.12433E-06_JPRB,0.14085E-06_JPRB, &
 & 0.14222E-06_JPRB,0.14246E-06_JPRB,0.17276E-06_JPRB,0.33441E-07_JPRB /)  
KA(:, 1,13, 3) = (/ &
 & 0.33724E-08_JPRB,0.32680E-07_JPRB,0.49222E-07_JPRB,0.61513E-07_JPRB,0.77133E-07_JPRB, &
 & 0.12555E-06_JPRB,0.16713E-06_JPRB,0.19233E-06_JPRB,0.12966E-07_JPRB /)  
KA(:, 2,13, 3) = (/ &
 & 0.41100E-08_JPRB,0.37987E-07_JPRB,0.58121E-07_JPRB,0.73233E-07_JPRB,0.82218E-07_JPRB, &
 & 0.11156E-06_JPRB,0.15077E-06_JPRB,0.18269E-06_JPRB,0.15614E-07_JPRB /)  
KA(:, 3,13, 3) = (/ &
 & 0.48589E-08_JPRB,0.45157E-07_JPRB,0.64912E-07_JPRB,0.80902E-07_JPRB,0.88466E-07_JPRB, &
 & 0.10747E-06_JPRB,0.14360E-06_JPRB,0.16616E-06_JPRB,0.19653E-07_JPRB /)  
KA(:, 4,13, 3) = (/ &
 & 0.55845E-08_JPRB,0.53032E-07_JPRB,0.74357E-07_JPRB,0.89835E-07_JPRB,0.10150E-06_JPRB, &
 & 0.10902E-06_JPRB,0.12309E-06_JPRB,0.15231E-06_JPRB,0.23083E-07_JPRB /)  
KA(:, 5,13, 3) = (/ &
 & 0.62642E-08_JPRB,0.61086E-07_JPRB,0.82886E-07_JPRB,0.10172E-06_JPRB,0.11529E-06_JPRB, &
 & 0.11645E-06_JPRB,0.11667E-06_JPRB,0.14140E-06_JPRB,0.27368E-07_JPRB /)  
KA(:, 1, 1, 4) = (/ &
 & 0.38523E-06_JPRB,0.18405E-05_JPRB,0.24561E-05_JPRB,0.26688E-05_JPRB,0.26627E-05_JPRB, &
 & 0.26678E-05_JPRB,0.26221E-05_JPRB,0.23434E-05_JPRB,0.10243E-05_JPRB /)  
KA(:, 2, 1, 4) = (/ &
 & 0.41258E-06_JPRB,0.20340E-05_JPRB,0.26799E-05_JPRB,0.29289E-05_JPRB,0.29138E-05_JPRB, &
 & 0.29293E-05_JPRB,0.29106E-05_JPRB,0.25138E-05_JPRB,0.11179E-05_JPRB /)  
KA(:, 3, 1, 4) = (/ &
 & 0.43826E-06_JPRB,0.22391E-05_JPRB,0.29055E-05_JPRB,0.31733E-05_JPRB,0.31848E-05_JPRB, &
 & 0.32210E-05_JPRB,0.31726E-05_JPRB,0.29277E-05_JPRB,0.13122E-05_JPRB /)  
KA(:, 4, 1, 4) = (/ &
 & 0.46214E-06_JPRB,0.24098E-05_JPRB,0.30735E-05_JPRB,0.33543E-05_JPRB,0.34157E-05_JPRB, &
 & 0.34436E-05_JPRB,0.34008E-05_JPRB,0.32157E-05_JPRB,0.14111E-05_JPRB /)  
KA(:, 5, 1, 4) = (/ &
 & 0.48360E-06_JPRB,0.25684E-05_JPRB,0.32470E-05_JPRB,0.35527E-05_JPRB,0.36650E-05_JPRB, &
 & 0.37054E-05_JPRB,0.36463E-05_JPRB,0.35130E-05_JPRB,0.16128E-05_JPRB /)  
KA(:, 1, 2, 4) = (/ &
 & 0.30632E-06_JPRB,0.14811E-05_JPRB,0.19813E-05_JPRB,0.21525E-05_JPRB,0.21480E-05_JPRB, &
 & 0.21651E-05_JPRB,0.21352E-05_JPRB,0.19097E-05_JPRB,0.76078E-06_JPRB /)  
KA(:, 2, 2, 4) = (/ &
 & 0.32924E-06_JPRB,0.16454E-05_JPRB,0.21736E-05_JPRB,0.23701E-05_JPRB,0.23496E-05_JPRB, &
 & 0.23721E-05_JPRB,0.23664E-05_JPRB,0.20501E-05_JPRB,0.85884E-06_JPRB /)  
KA(:, 3, 2, 4) = (/ &
 & 0.35084E-06_JPRB,0.18164E-05_JPRB,0.23625E-05_JPRB,0.25754E-05_JPRB,0.25799E-05_JPRB, &
 & 0.26089E-05_JPRB,0.25758E-05_JPRB,0.23569E-05_JPRB,0.98156E-06_JPRB /)  
KA(:, 4, 2, 4) = (/ &
 & 0.37092E-06_JPRB,0.19724E-05_JPRB,0.25182E-05_JPRB,0.27461E-05_JPRB,0.27987E-05_JPRB, &
 & 0.28122E-05_JPRB,0.27766E-05_JPRB,0.26535E-05_JPRB,0.11297E-05_JPRB /)  
KA(:, 5, 2, 4) = (/ &
 & 0.38936E-06_JPRB,0.20952E-05_JPRB,0.26519E-05_JPRB,0.29005E-05_JPRB,0.29889E-05_JPRB, &
 & 0.30120E-05_JPRB,0.29564E-05_JPRB,0.28641E-05_JPRB,0.12488E-05_JPRB /)  
KA(:, 1, 3, 4) = (/ &
 & 0.23924E-06_JPRB,0.11590E-05_JPRB,0.15536E-05_JPRB,0.16834E-05_JPRB,0.16891E-05_JPRB, &
 & 0.17668E-05_JPRB,0.16904E-05_JPRB,0.15951E-05_JPRB,0.52632E-06_JPRB /)  
KA(:, 2, 3, 4) = (/ &
 & 0.25864E-06_JPRB,0.12971E-05_JPRB,0.17221E-05_JPRB,0.18731E-05_JPRB,0.18563E-05_JPRB, &
 & 0.18804E-05_JPRB,0.18628E-05_JPRB,0.16576E-05_JPRB,0.62738E-06_JPRB /)  
KA(:, 3, 3, 4) = (/ &
 & 0.27696E-06_JPRB,0.14325E-05_JPRB,0.18710E-05_JPRB,0.20345E-05_JPRB,0.20276E-05_JPRB, &
 & 0.20548E-05_JPRB,0.20259E-05_JPRB,0.17837E-05_JPRB,0.70461E-06_JPRB /)  
KA(:, 4, 3, 4) = (/ &
 & 0.29413E-06_JPRB,0.15757E-05_JPRB,0.20191E-05_JPRB,0.22050E-05_JPRB,0.22319E-05_JPRB, &
 & 0.22354E-05_JPRB,0.22195E-05_JPRB,0.20885E-05_JPRB,0.84521E-06_JPRB /)  
KA(:, 5, 3, 4) = (/ &
 & 0.31013E-06_JPRB,0.16829E-05_JPRB,0.21333E-05_JPRB,0.23274E-05_JPRB,0.23871E-05_JPRB, &
 & 0.23939E-05_JPRB,0.23475E-05_JPRB,0.22805E-05_JPRB,0.93762E-06_JPRB /)  
KA(:, 1, 4, 4) = (/ &
 & 0.18537E-06_JPRB,0.89469E-06_JPRB,0.11953E-05_JPRB,0.13099E-05_JPRB,0.13271E-05_JPRB, &
 & 0.13910E-05_JPRB,0.13233E-05_JPRB,0.12842E-05_JPRB,0.37595E-06_JPRB /)  
KA(:, 2, 4, 4) = (/ &
 & 0.20178E-06_JPRB,0.10096E-05_JPRB,0.13476E-05_JPRB,0.14636E-05_JPRB,0.14567E-05_JPRB, &
 & 0.14730E-05_JPRB,0.14642E-05_JPRB,0.13131E-05_JPRB,0.45273E-06_JPRB /)  
KA(:, 3, 4, 4) = (/ &
 & 0.21732E-06_JPRB,0.11251E-05_JPRB,0.14779E-05_JPRB,0.16107E-05_JPRB,0.15945E-05_JPRB, &
 & 0.16194E-05_JPRB,0.16016E-05_JPRB,0.14026E-05_JPRB,0.52023E-06_JPRB /)  
KA(:, 4, 4, 4) = (/ &
 & 0.23198E-06_JPRB,0.12348E-05_JPRB,0.15955E-05_JPRB,0.17391E-05_JPRB,0.17432E-05_JPRB, &
 & 0.17515E-05_JPRB,0.17226E-05_JPRB,0.15707E-05_JPRB,0.60921E-06_JPRB /)  
KA(:, 5, 4, 4) = (/ &
 & 0.24566E-06_JPRB,0.13471E-05_JPRB,0.17138E-05_JPRB,0.18677E-05_JPRB,0.19071E-05_JPRB, &
 & 0.19021E-05_JPRB,0.18647E-05_JPRB,0.18054E-05_JPRB,0.72437E-06_JPRB /)  
KA(:, 1, 5, 4) = (/ &
 & 0.14315E-06_JPRB,0.68654E-06_JPRB,0.91703E-06_JPRB,0.10136E-05_JPRB,0.10640E-05_JPRB, &
 & 0.10899E-05_JPRB,0.10066E-05_JPRB,0.10387E-05_JPRB,0.27115E-06_JPRB /)  
KA(:, 2, 5, 4) = (/ &
 & 0.15693E-06_JPRB,0.78124E-06_JPRB,0.10460E-05_JPRB,0.11319E-05_JPRB,0.11350E-05_JPRB, &
 & 0.11836E-05_JPRB,0.11463E-05_JPRB,0.10954E-05_JPRB,0.33462E-06_JPRB /)  
KA(:, 3, 5, 4) = (/ &
 & 0.17013E-06_JPRB,0.87619E-06_JPRB,0.11607E-05_JPRB,0.12633E-05_JPRB,0.12502E-05_JPRB, &
 & 0.12683E-05_JPRB,0.12476E-05_JPRB,0.11184E-05_JPRB,0.38421E-06_JPRB /)  
KA(:, 4, 5, 4) = (/ &
 & 0.18255E-06_JPRB,0.96990E-06_JPRB,0.12617E-05_JPRB,0.13726E-05_JPRB,0.13641E-05_JPRB, &
 & 0.13787E-05_JPRB,0.13521E-05_JPRB,0.11952E-05_JPRB,0.45446E-06_JPRB /)  
KA(:, 5, 5, 4) = (/ &
 & 0.19427E-06_JPRB,0.10668E-05_JPRB,0.13642E-05_JPRB,0.14869E-05_JPRB,0.15021E-05_JPRB, &
 & 0.14945E-05_JPRB,0.14801E-05_JPRB,0.13920E-05_JPRB,0.54371E-06_JPRB /)  
KA(:, 1, 6, 4) = (/ &
 & 0.10978E-06_JPRB,0.52395E-06_JPRB,0.69476E-06_JPRB,0.76850E-06_JPRB,0.83675E-06_JPRB, &
 & 0.86491E-06_JPRB,0.77625E-06_JPRB,0.85871E-06_JPRB,0.19533E-06_JPRB /)  
KA(:, 2, 6, 4) = (/ &
 & 0.12132E-06_JPRB,0.59825E-06_JPRB,0.79672E-06_JPRB,0.87685E-06_JPRB,0.88945E-06_JPRB, &
 & 0.93176E-06_JPRB,0.88241E-06_JPRB,0.87959E-06_JPRB,0.24185E-06_JPRB /)  
KA(:, 3, 6, 4) = (/ &
 & 0.13245E-06_JPRB,0.67730E-06_JPRB,0.90458E-06_JPRB,0.97978E-06_JPRB,0.97457E-06_JPRB, &
 & 0.98659E-06_JPRB,0.98199E-06_JPRB,0.88654E-06_JPRB,0.28188E-06_JPRB /)  
KA(:, 4, 6, 4) = (/ &
 & 0.14304E-06_JPRB,0.75520E-06_JPRB,0.99285E-06_JPRB,0.10803E-05_JPRB,0.10647E-05_JPRB, &
 & 0.10764E-05_JPRB,0.10623E-05_JPRB,0.93315E-06_JPRB,0.33738E-06_JPRB /)  
KA(:, 5, 6, 4) = (/ &
 & 0.15298E-06_JPRB,0.83133E-06_JPRB,0.10714E-05_JPRB,0.11654E-05_JPRB,0.11612E-05_JPRB, &
 & 0.11628E-05_JPRB,0.11409E-05_JPRB,0.10211E-05_JPRB,0.39343E-06_JPRB /)  
KA(:, 1, 7, 4) = (/ &
 & 0.83795E-07_JPRB,0.39583E-06_JPRB,0.52221E-06_JPRB,0.57623E-06_JPRB,0.66801E-06_JPRB, &
 & 0.68350E-06_JPRB,0.61427E-06_JPRB,0.74508E-06_JPRB,0.14027E-06_JPRB /)  
KA(:, 2, 7, 4) = (/ &
 & 0.93456E-07_JPRB,0.45651E-06_JPRB,0.60707E-06_JPRB,0.67267E-06_JPRB,0.70886E-06_JPRB, &
 & 0.72875E-06_JPRB,0.66655E-06_JPRB,0.70837E-06_JPRB,0.17333E-06_JPRB /)  
KA(:, 3, 7, 4) = (/ &
 & 0.10278E-06_JPRB,0.52065E-06_JPRB,0.69548E-06_JPRB,0.75346E-06_JPRB,0.75243E-06_JPRB, &
 & 0.79752E-06_JPRB,0.76130E-06_JPRB,0.73768E-06_JPRB,0.20746E-06_JPRB /)  
KA(:, 4, 7, 4) = (/ &
 & 0.11172E-06_JPRB,0.58539E-06_JPRB,0.77614E-06_JPRB,0.84147E-06_JPRB,0.82956E-06_JPRB, &
 & 0.83892E-06_JPRB,0.81830E-06_JPRB,0.74649E-06_JPRB,0.24711E-06_JPRB /)  
KA(:, 5, 7, 4) = (/ &
 & 0.12020E-06_JPRB,0.64890E-06_JPRB,0.84430E-06_JPRB,0.91375E-06_JPRB,0.90365E-06_JPRB, &
 & 0.91211E-06_JPRB,0.89073E-06_JPRB,0.78796E-06_JPRB,0.29290E-06_JPRB /)  
KA(:, 1, 8, 4) = (/ &
 & 0.63771E-07_JPRB,0.29724E-06_JPRB,0.38901E-06_JPRB,0.42952E-06_JPRB,0.53569E-06_JPRB, &
 & 0.52739E-06_JPRB,0.51421E-06_JPRB,0.65416E-06_JPRB,0.10106E-06_JPRB /)  
KA(:, 2, 8, 4) = (/ &
 & 0.71835E-07_JPRB,0.34855E-06_JPRB,0.45895E-06_JPRB,0.50927E-06_JPRB,0.55878E-06_JPRB, &
 & 0.57413E-06_JPRB,0.51386E-06_JPRB,0.58703E-06_JPRB,0.12396E-06_JPRB /)  
KA(:, 3, 8, 4) = (/ &
 & 0.79626E-07_JPRB,0.39836E-06_JPRB,0.52930E-06_JPRB,0.58238E-06_JPRB,0.59321E-06_JPRB, &
 & 0.61917E-06_JPRB,0.58275E-06_JPRB,0.59574E-06_JPRB,0.15556E-06_JPRB /)  
KA(:, 4, 8, 4) = (/ &
 & 0.87141E-07_JPRB,0.45236E-06_JPRB,0.60287E-06_JPRB,0.64978E-06_JPRB,0.64621E-06_JPRB, &
 & 0.65548E-06_JPRB,0.65037E-06_JPRB,0.59243E-06_JPRB,0.18170E-06_JPRB /)  
KA(:, 5, 8, 4) = (/ &
 & 0.94308E-07_JPRB,0.50478E-06_JPRB,0.66216E-06_JPRB,0.71791E-06_JPRB,0.70542E-06_JPRB, &
 & 0.71265E-06_JPRB,0.70440E-06_JPRB,0.61750E-06_JPRB,0.21806E-06_JPRB /)  
KA(:, 1, 9, 4) = (/ &
 & 0.48334E-07_JPRB,0.22150E-06_JPRB,0.29066E-06_JPRB,0.32650E-06_JPRB,0.41774E-06_JPRB, &
 & 0.40737E-06_JPRB,0.44502E-06_JPRB,0.56524E-06_JPRB,0.72879E-07_JPRB /)  
KA(:, 2, 9, 4) = (/ &
 & 0.54994E-07_JPRB,0.26340E-06_JPRB,0.34441E-06_JPRB,0.38160E-06_JPRB,0.44410E-06_JPRB, &
 & 0.45746E-06_JPRB,0.41390E-06_JPRB,0.50482E-06_JPRB,0.89924E-07_JPRB /)  
KA(:, 3, 9, 4) = (/ &
 & 0.61501E-07_JPRB,0.30416E-06_JPRB,0.40299E-06_JPRB,0.44693E-06_JPRB,0.47253E-06_JPRB, &
 & 0.48623E-06_JPRB,0.44624E-06_JPRB,0.47646E-06_JPRB,0.11220E-06_JPRB /)  
KA(:, 4, 9, 4) = (/ &
 & 0.67792E-07_JPRB,0.34758E-06_JPRB,0.46191E-06_JPRB,0.50102E-06_JPRB,0.50055E-06_JPRB, &
 & 0.52975E-06_JPRB,0.50335E-06_JPRB,0.48665E-06_JPRB,0.13456E-06_JPRB /)  
KA(:, 5, 9, 4) = (/ &
 & 0.73830E-07_JPRB,0.39095E-06_JPRB,0.51738E-06_JPRB,0.55894E-06_JPRB,0.55048E-06_JPRB, &
 & 0.55492E-06_JPRB,0.54317E-06_JPRB,0.49144E-06_JPRB,0.16088E-06_JPRB /)  
KA(:, 1,10, 4) = (/ &
 & 0.36931E-07_JPRB,0.16614E-06_JPRB,0.21895E-06_JPRB,0.26116E-06_JPRB,0.33023E-06_JPRB, &
 & 0.31438E-06_JPRB,0.35810E-06_JPRB,0.46819E-06_JPRB,0.53649E-07_JPRB /)  
KA(:, 2,10, 4) = (/ &
 & 0.42386E-07_JPRB,0.20028E-06_JPRB,0.26120E-06_JPRB,0.28858E-06_JPRB,0.36090E-06_JPRB, &
 & 0.35506E-06_JPRB,0.34639E-06_JPRB,0.43640E-06_JPRB,0.66551E-07_JPRB /)  
KA(:, 3,10, 4) = (/ &
 & 0.47801E-07_JPRB,0.23474E-06_JPRB,0.30842E-06_JPRB,0.34242E-06_JPRB,0.37552E-06_JPRB, &
 & 0.38348E-06_JPRB,0.34637E-06_JPRB,0.39519E-06_JPRB,0.81897E-07_JPRB /)  
KA(:, 4,10, 4) = (/ &
 & 0.53030E-07_JPRB,0.26856E-06_JPRB,0.35532E-06_JPRB,0.39019E-06_JPRB,0.39727E-06_JPRB, &
 & 0.41391E-06_JPRB,0.38815E-06_JPRB,0.39845E-06_JPRB,0.10316E-06_JPRB /)  
KA(:, 5,10, 4) = (/ &
 & 0.58073E-07_JPRB,0.30468E-06_JPRB,0.40415E-06_JPRB,0.43508E-06_JPRB,0.43212E-06_JPRB, &
 & 0.43860E-06_JPRB,0.43462E-06_JPRB,0.39513E-06_JPRB,0.12065E-06_JPRB /)  
KA(:, 1,11, 4) = (/ &
 & 0.30210E-07_JPRB,0.13672E-06_JPRB,0.18028E-06_JPRB,0.21388E-06_JPRB,0.27067E-06_JPRB, &
 & 0.25748E-06_JPRB,0.29347E-06_JPRB,0.38486E-06_JPRB,0.43992E-07_JPRB /)  
KA(:, 2,11, 4) = (/ &
 & 0.34676E-07_JPRB,0.16480E-06_JPRB,0.21447E-06_JPRB,0.23703E-06_JPRB,0.29658E-06_JPRB, &
 & 0.29189E-06_JPRB,0.28346E-06_JPRB,0.35425E-06_JPRB,0.54558E-07_JPRB /)  
KA(:, 3,11, 4) = (/ &
 & 0.39112E-07_JPRB,0.19301E-06_JPRB,0.25343E-06_JPRB,0.28112E-06_JPRB,0.30767E-06_JPRB, &
 & 0.31424E-06_JPRB,0.28354E-06_JPRB,0.32323E-06_JPRB,0.67060E-07_JPRB /)  
KA(:, 4,11, 4) = (/ &
 & 0.43392E-07_JPRB,0.22069E-06_JPRB,0.29158E-06_JPRB,0.31987E-06_JPRB,0.32514E-06_JPRB, &
 & 0.33920E-06_JPRB,0.31782E-06_JPRB,0.32572E-06_JPRB,0.84444E-07_JPRB /)  
KA(:, 5,11, 4) = (/ &
 & 0.47520E-07_JPRB,0.25011E-06_JPRB,0.33134E-06_JPRB,0.35641E-06_JPRB,0.35390E-06_JPRB, &
 & 0.35921E-06_JPRB,0.35594E-06_JPRB,0.32298E-06_JPRB,0.98845E-07_JPRB /)  
KA(:, 1,12, 4) = (/ &
 & 0.24733E-07_JPRB,0.11230E-06_JPRB,0.14856E-06_JPRB,0.17472E-06_JPRB,0.22197E-06_JPRB, &
 & 0.21118E-06_JPRB,0.24122E-06_JPRB,0.31477E-06_JPRB,0.36119E-07_JPRB /)  
KA(:, 2,12, 4) = (/ &
 & 0.28389E-07_JPRB,0.13551E-06_JPRB,0.17612E-06_JPRB,0.19468E-06_JPRB,0.24363E-06_JPRB, &
 & 0.23963E-06_JPRB,0.23290E-06_JPRB,0.28830E-06_JPRB,0.44709E-07_JPRB /)  
KA(:, 3,12, 4) = (/ &
 & 0.32017E-07_JPRB,0.15859E-06_JPRB,0.20791E-06_JPRB,0.23074E-06_JPRB,0.25230E-06_JPRB, &
 & 0.25771E-06_JPRB,0.23238E-06_JPRB,0.26334E-06_JPRB,0.54941E-07_JPRB /)  
KA(:, 4,12, 4) = (/ &
 & 0.35526E-07_JPRB,0.18123E-06_JPRB,0.23912E-06_JPRB,0.26228E-06_JPRB,0.26637E-06_JPRB, &
 & 0.27804E-06_JPRB,0.26039E-06_JPRB,0.26652E-06_JPRB,0.69162E-07_JPRB /)  
KA(:, 5,12, 4) = (/ &
 & 0.38912E-07_JPRB,0.20524E-06_JPRB,0.27165E-06_JPRB,0.29207E-06_JPRB,0.28991E-06_JPRB, &
 & 0.29419E-06_JPRB,0.29154E-06_JPRB,0.26412E-06_JPRB,0.80995E-07_JPRB /)  
KA(:, 1,13, 4) = (/ &
 & 0.20250E-07_JPRB,0.92231E-07_JPRB,0.12203E-06_JPRB,0.14275E-06_JPRB,0.18179E-06_JPRB, &
 & 0.17279E-06_JPRB,0.19796E-06_JPRB,0.25817E-06_JPRB,0.29574E-07_JPRB /)  
KA(:, 2,13, 4) = (/ &
 & 0.23243E-07_JPRB,0.11133E-06_JPRB,0.14442E-06_JPRB,0.15980E-06_JPRB,0.20001E-06_JPRB, &
 & 0.19638E-06_JPRB,0.19075E-06_JPRB,0.23541E-06_JPRB,0.36618E-07_JPRB /)  
KA(:, 3,13, 4) = (/ &
 & 0.26215E-07_JPRB,0.13018E-06_JPRB,0.17053E-06_JPRB,0.18925E-06_JPRB,0.20654E-06_JPRB, &
 & 0.21104E-06_JPRB,0.19040E-06_JPRB,0.21495E-06_JPRB,0.44987E-07_JPRB /)  
KA(:, 4,13, 4) = (/ &
 & 0.29082E-07_JPRB,0.14865E-06_JPRB,0.19601E-06_JPRB,0.21490E-06_JPRB,0.21820E-06_JPRB, &
 & 0.22779E-06_JPRB,0.21313E-06_JPRB,0.21809E-06_JPRB,0.56635E-07_JPRB /)  
KA(:, 5,13, 4) = (/ &
 & 0.31856E-07_JPRB,0.16826E-06_JPRB,0.22260E-06_JPRB,0.23930E-06_JPRB,0.23753E-06_JPRB, &
 & 0.24098E-06_JPRB,0.23875E-06_JPRB,0.21605E-06_JPRB,0.66316E-07_JPRB /)  
KA(:, 1, 1, 5) = (/ &
 & 0.17059E-05_JPRB,0.38862E-05_JPRB,0.46330E-05_JPRB,0.51258E-05_JPRB,0.53516E-05_JPRB, &
 & 0.52890E-05_JPRB,0.49050E-05_JPRB,0.49561E-05_JPRB,0.24914E-05_JPRB /)  
KA(:, 2, 1, 5) = (/ &
 & 0.17702E-05_JPRB,0.41613E-05_JPRB,0.49979E-05_JPRB,0.55352E-05_JPRB,0.58535E-05_JPRB, &
 & 0.58620E-05_JPRB,0.55540E-05_JPRB,0.53944E-05_JPRB,0.30111E-05_JPRB /)  
KA(:, 3, 1, 5) = (/ &
 & 0.18268E-05_JPRB,0.44218E-05_JPRB,0.53631E-05_JPRB,0.59894E-05_JPRB,0.63892E-05_JPRB, &
 & 0.64888E-05_JPRB,0.63488E-05_JPRB,0.59957E-05_JPRB,0.35253E-05_JPRB /)  
KA(:, 4, 1, 5) = (/ &
 & 0.18763E-05_JPRB,0.46467E-05_JPRB,0.56969E-05_JPRB,0.64112E-05_JPRB,0.68701E-05_JPRB, &
 & 0.70687E-05_JPRB,0.69575E-05_JPRB,0.65330E-05_JPRB,0.40117E-05_JPRB /)  
KA(:, 5, 1, 5) = (/ &
 & 0.19168E-05_JPRB,0.48702E-05_JPRB,0.60413E-05_JPRB,0.68595E-05_JPRB,0.73828E-05_JPRB, &
 & 0.76555E-05_JPRB,0.76620E-05_JPRB,0.72236E-05_JPRB,0.44814E-05_JPRB /)  
KA(:, 1, 2, 5) = (/ &
 & 0.13807E-05_JPRB,0.32052E-05_JPRB,0.37981E-05_JPRB,0.41868E-05_JPRB,0.43666E-05_JPRB, &
 & 0.42966E-05_JPRB,0.39397E-05_JPRB,0.40523E-05_JPRB,0.19972E-05_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART3',1,ZHOOK_HANDLE)
END SUBROUTINE PART3


SUBROUTINE PART4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART4',0,ZHOOK_HANDLE)


KA(:, 2, 2, 5) = (/ &
 & 0.14355E-05_JPRB,0.34375E-05_JPRB,0.40968E-05_JPRB,0.45345E-05_JPRB,0.47869E-05_JPRB, &
 & 0.47900E-05_JPRB,0.45121E-05_JPRB,0.44176E-05_JPRB,0.23759E-05_JPRB /)  
KA(:, 3, 2, 5) = (/ &
 & 0.14839E-05_JPRB,0.36628E-05_JPRB,0.44128E-05_JPRB,0.49223E-05_JPRB,0.52399E-05_JPRB, &
 & 0.53302E-05_JPRB,0.51982E-05_JPRB,0.49130E-05_JPRB,0.28052E-05_JPRB /)  
KA(:, 4, 2, 5) = (/ &
 & 0.15261E-05_JPRB,0.38551E-05_JPRB,0.47116E-05_JPRB,0.52947E-05_JPRB,0.56758E-05_JPRB, &
 & 0.58601E-05_JPRB,0.57606E-05_JPRB,0.54224E-05_JPRB,0.31665E-05_JPRB /)  
KA(:, 5, 2, 5) = (/ &
 & 0.15621E-05_JPRB,0.40345E-05_JPRB,0.49797E-05_JPRB,0.56344E-05_JPRB,0.60672E-05_JPRB, &
 & 0.63079E-05_JPRB,0.63076E-05_JPRB,0.59671E-05_JPRB,0.35368E-05_JPRB /)  
KA(:, 1, 3, 5) = (/ &
 & 0.11048E-05_JPRB,0.25908E-05_JPRB,0.30458E-05_JPRB,0.33480E-05_JPRB,0.34767E-05_JPRB, &
 & 0.33444E-05_JPRB,0.30982E-05_JPRB,0.31520E-05_JPRB,0.14943E-05_JPRB /)  
KA(:, 2, 3, 5) = (/ &
 & 0.11526E-05_JPRB,0.27857E-05_JPRB,0.32915E-05_JPRB,0.36364E-05_JPRB,0.38272E-05_JPRB, &
 & 0.38169E-05_JPRB,0.35492E-05_JPRB,0.35141E-05_JPRB,0.17575E-05_JPRB /)  
KA(:, 3, 3, 5) = (/ &
 & 0.11948E-05_JPRB,0.29688E-05_JPRB,0.35427E-05_JPRB,0.39401E-05_JPRB,0.41747E-05_JPRB, &
 & 0.42239E-05_JPRB,0.40766E-05_JPRB,0.39111E-05_JPRB,0.20688E-05_JPRB /)  
KA(:, 4, 3, 5) = (/ &
 & 0.12319E-05_JPRB,0.31426E-05_JPRB,0.38135E-05_JPRB,0.42625E-05_JPRB,0.45635E-05_JPRB, &
 & 0.47062E-05_JPRB,0.46027E-05_JPRB,0.43389E-05_JPRB,0.23873E-05_JPRB /)  
KA(:, 5, 3, 5) = (/ &
 & 0.12642E-05_JPRB,0.32923E-05_JPRB,0.40402E-05_JPRB,0.45497E-05_JPRB,0.48934E-05_JPRB, &
 & 0.50814E-05_JPRB,0.50577E-05_JPRB,0.47614E-05_JPRB,0.26860E-05_JPRB /)  
KA(:, 1, 4, 5) = (/ &
 & 0.87810E-06_JPRB,0.20726E-05_JPRB,0.24188E-05_JPRB,0.26498E-05_JPRB,0.27201E-05_JPRB, &
 & 0.25966E-05_JPRB,0.24215E-05_JPRB,0.25596E-05_JPRB,0.10910E-05_JPRB /)  
KA(:, 2, 4, 5) = (/ &
 & 0.92113E-06_JPRB,0.22378E-05_JPRB,0.26243E-05_JPRB,0.28859E-05_JPRB,0.30228E-05_JPRB, &
 & 0.29855E-05_JPRB,0.27257E-05_JPRB,0.28497E-05_JPRB,0.12952E-05_JPRB /)  
KA(:, 3, 4, 5) = (/ &
 & 0.95847E-06_JPRB,0.23927E-05_JPRB,0.28323E-05_JPRB,0.31308E-05_JPRB,0.33238E-05_JPRB, &
 & 0.33287E-05_JPRB,0.31597E-05_JPRB,0.31032E-05_JPRB,0.15368E-05_JPRB /)  
KA(:, 4, 4, 5) = (/ &
 & 0.99115E-06_JPRB,0.25350E-05_JPRB,0.30423E-05_JPRB,0.33883E-05_JPRB,0.36085E-05_JPRB, &
 & 0.36829E-05_JPRB,0.35850E-05_JPRB,0.33993E-05_JPRB,0.17502E-05_JPRB /)  
KA(:, 5, 4, 5) = (/ &
 & 0.10199E-05_JPRB,0.26768E-05_JPRB,0.32656E-05_JPRB,0.36641E-05_JPRB,0.39303E-05_JPRB, &
 & 0.40820E-05_JPRB,0.40444E-05_JPRB,0.38038E-05_JPRB,0.20588E-05_JPRB /)  
KA(:, 1, 5, 5) = (/ &
 & 0.69521E-06_JPRB,0.16480E-05_JPRB,0.19136E-05_JPRB,0.20758E-05_JPRB,0.21053E-05_JPRB, &
 & 0.19983E-05_JPRB,0.19384E-05_JPRB,0.21119E-05_JPRB,0.79759E-06_JPRB /)  
KA(:, 2, 5, 5) = (/ &
 & 0.73399E-06_JPRB,0.17885E-05_JPRB,0.20863E-05_JPRB,0.22802E-05_JPRB,0.23681E-05_JPRB, &
 & 0.23078E-05_JPRB,0.21093E-05_JPRB,0.21684E-05_JPRB,0.95048E-06_JPRB /)  
KA(:, 3, 5, 5) = (/ &
 & 0.76704E-06_JPRB,0.19210E-05_JPRB,0.22551E-05_JPRB,0.24823E-05_JPRB,0.26201E-05_JPRB, &
 & 0.26181E-05_JPRB,0.24369E-05_JPRB,0.24387E-05_JPRB,0.11396E-05_JPRB /)  
KA(:, 4, 5, 5) = (/ &
 & 0.79598E-06_JPRB,0.20422E-05_JPRB,0.24305E-05_JPRB,0.26936E-05_JPRB,0.28610E-05_JPRB, &
 & 0.28938E-05_JPRB,0.28032E-05_JPRB,0.26848E-05_JPRB,0.13054E-05_JPRB /)  
KA(:, 5, 5, 5) = (/ &
 & 0.82146E-06_JPRB,0.21630E-05_JPRB,0.26149E-05_JPRB,0.29202E-05_JPRB,0.31281E-05_JPRB, &
 & 0.32364E-05_JPRB,0.31639E-05_JPRB,0.29903E-05_JPRB,0.15503E-05_JPRB /)  
KA(:, 1, 6, 5) = (/ &
 & 0.54790E-06_JPRB,0.12968E-05_JPRB,0.14998E-05_JPRB,0.16199E-05_JPRB,0.16168E-05_JPRB, &
 & 0.15151E-05_JPRB,0.14932E-05_JPRB,0.16380E-05_JPRB,0.58437E-06_JPRB /)  
KA(:, 2, 6, 5) = (/ &
 & 0.58180E-06_JPRB,0.14204E-05_JPRB,0.16474E-05_JPRB,0.17877E-05_JPRB,0.18382E-05_JPRB, &
 & 0.17645E-05_JPRB,0.16359E-05_JPRB,0.17414E-05_JPRB,0.70191E-06_JPRB /)  
KA(:, 3, 6, 5) = (/ &
 & 0.61169E-06_JPRB,0.15332E-05_JPRB,0.17837E-05_JPRB,0.19554E-05_JPRB,0.20462E-05_JPRB, &
 & 0.20343E-05_JPRB,0.18483E-05_JPRB,0.19670E-05_JPRB,0.83824E-06_JPRB /)  
KA(:, 4, 6, 5) = (/ &
 & 0.63729E-06_JPRB,0.16375E-05_JPRB,0.19280E-05_JPRB,0.21247E-05_JPRB,0.22559E-05_JPRB, &
 & 0.22588E-05_JPRB,0.21468E-05_JPRB,0.21190E-05_JPRB,0.96829E-06_JPRB /)  
KA(:, 5, 6, 5) = (/ &
 & 0.65987E-06_JPRB,0.17326E-05_JPRB,0.20710E-05_JPRB,0.23017E-05_JPRB,0.24525E-05_JPRB, &
 & 0.25042E-05_JPRB,0.24377E-05_JPRB,0.23029E-05_JPRB,0.11330E-05_JPRB /)  
KA(:, 1, 7, 5) = (/ &
 & 0.43067E-06_JPRB,0.10147E-05_JPRB,0.11663E-05_JPRB,0.12622E-05_JPRB,0.12316E-05_JPRB, &
 & 0.11186E-05_JPRB,0.12227E-05_JPRB,0.12153E-05_JPRB,0.41960E-06_JPRB /)  
KA(:, 2, 7, 5) = (/ &
 & 0.45965E-06_JPRB,0.11216E-05_JPRB,0.12929E-05_JPRB,0.13935E-05_JPRB,0.14129E-05_JPRB, &
 & 0.13426E-05_JPRB,0.12944E-05_JPRB,0.14463E-05_JPRB,0.51416E-06_JPRB /)  
KA(:, 3, 7, 5) = (/ &
 & 0.48636E-06_JPRB,0.12186E-05_JPRB,0.14109E-05_JPRB,0.15331E-05_JPRB,0.15936E-05_JPRB, &
 & 0.15473E-05_JPRB,0.14164E-05_JPRB,0.14707E-05_JPRB,0.61314E-06_JPRB /)  
KA(:, 4, 7, 5) = (/ &
 & 0.50928E-06_JPRB,0.13071E-05_JPRB,0.15237E-05_JPRB,0.16740E-05_JPRB,0.17644E-05_JPRB, &
 & 0.17562E-05_JPRB,0.16373E-05_JPRB,0.16431E-05_JPRB,0.72862E-06_JPRB /)  
KA(:, 5, 7, 5) = (/ &
 & 0.52919E-06_JPRB,0.13890E-05_JPRB,0.16443E-05_JPRB,0.18186E-05_JPRB,0.19296E-05_JPRB, &
 & 0.19451E-05_JPRB,0.18786E-05_JPRB,0.17942E-05_JPRB,0.84235E-06_JPRB /)  
KA(:, 1, 8, 5) = (/ &
 & 0.33792E-06_JPRB,0.78856E-06_JPRB,0.90464E-06_JPRB,0.98317E-06_JPRB,0.92848E-06_JPRB, &
 & 0.86387E-06_JPRB,0.95438E-06_JPRB,0.90887E-06_JPRB,0.29529E-06_JPRB /)  
KA(:, 2, 8, 5) = (/ &
 & 0.36263E-06_JPRB,0.88071E-06_JPRB,0.10121E-05_JPRB,0.10878E-05_JPRB,0.10817E-05_JPRB, &
 & 0.10133E-05_JPRB,0.10031E-05_JPRB,0.11161E-05_JPRB,0.37413E-06_JPRB /)  
KA(:, 3, 8, 5) = (/ &
 & 0.38563E-06_JPRB,0.96560E-06_JPRB,0.11116E-05_JPRB,0.12011E-05_JPRB,0.12324E-05_JPRB, &
 & 0.11848E-05_JPRB,0.10927E-05_JPRB,0.11776E-05_JPRB,0.44987E-06_JPRB /)  
KA(:, 4, 8, 5) = (/ &
 & 0.40622E-06_JPRB,0.10407E-05_JPRB,0.12047E-05_JPRB,0.13138E-05_JPRB,0.13745E-05_JPRB, &
 & 0.13598E-05_JPRB,0.12356E-05_JPRB,0.13203E-05_JPRB,0.54288E-06_JPRB /)  
KA(:, 5, 8, 5) = (/ &
 & 0.42386E-06_JPRB,0.11111E-05_JPRB,0.13019E-05_JPRB,0.14302E-05_JPRB,0.15146E-05_JPRB, &
 & 0.15112E-05_JPRB,0.14255E-05_JPRB,0.14090E-05_JPRB,0.62729E-06_JPRB /)  
KA(:, 1, 9, 5) = (/ &
 & 0.26432E-06_JPRB,0.60726E-06_JPRB,0.70036E-06_JPRB,0.76229E-06_JPRB,0.71577E-06_JPRB, &
 & 0.69749E-06_JPRB,0.70164E-06_JPRB,0.72668E-06_JPRB,0.20659E-06_JPRB /)  
KA(:, 2, 9, 5) = (/ &
 & 0.28549E-06_JPRB,0.68848E-06_JPRB,0.78705E-06_JPRB,0.84862E-06_JPRB,0.82241E-06_JPRB, &
 & 0.74707E-06_JPRB,0.82519E-06_JPRB,0.82938E-06_JPRB,0.27449E-06_JPRB /)  
KA(:, 3, 9, 5) = (/ &
 & 0.30511E-06_JPRB,0.76168E-06_JPRB,0.87199E-06_JPRB,0.93359E-06_JPRB,0.94531E-06_JPRB, &
 & 0.89794E-06_JPRB,0.85947E-06_JPRB,0.97111E-06_JPRB,0.33410E-06_JPRB /)  
KA(:, 4, 9, 5) = (/ &
 & 0.32329E-06_JPRB,0.82660E-06_JPRB,0.95163E-06_JPRB,0.10287E-05_JPRB,0.10680E-05_JPRB, &
 & 0.10381E-05_JPRB,0.94558E-06_JPRB,0.98374E-06_JPRB,0.39896E-06_JPRB /)  
KA(:, 5, 9, 5) = (/ &
 & 0.33897E-06_JPRB,0.88614E-06_JPRB,0.10276E-05_JPRB,0.11239E-05_JPRB,0.11817E-05_JPRB, &
 & 0.11723E-05_JPRB,0.10892E-05_JPRB,0.10943E-05_JPRB,0.47438E-06_JPRB /)  
KA(:, 1,10, 5) = (/ &
 & 0.20748E-06_JPRB,0.47023E-06_JPRB,0.54165E-06_JPRB,0.58159E-06_JPRB,0.54422E-06_JPRB, &
 & 0.55116E-06_JPRB,0.57712E-06_JPRB,0.60571E-06_JPRB,0.14752E-06_JPRB /)  
KA(:, 2,10, 5) = (/ &
 & 0.22561E-06_JPRB,0.54027E-06_JPRB,0.61555E-06_JPRB,0.66550E-06_JPRB,0.62550E-06_JPRB, &
 & 0.58306E-06_JPRB,0.64781E-06_JPRB,0.63365E-06_JPRB,0.19821E-06_JPRB /)  
KA(:, 3,10, 5) = (/ &
 & 0.24219E-06_JPRB,0.60251E-06_JPRB,0.68703E-06_JPRB,0.73412E-06_JPRB,0.72965E-06_JPRB, &
 & 0.68255E-06_JPRB,0.67291E-06_JPRB,0.76422E-06_JPRB,0.24874E-06_JPRB /)  
KA(:, 4,10, 5) = (/ &
 & 0.25766E-06_JPRB,0.65861E-06_JPRB,0.75375E-06_JPRB,0.81214E-06_JPRB,0.83171E-06_JPRB, &
 & 0.80129E-06_JPRB,0.73385E-06_JPRB,0.78864E-06_JPRB,0.29867E-06_JPRB /)  
KA(:, 5,10, 5) = (/ &
 & 0.27157E-06_JPRB,0.70870E-06_JPRB,0.81638E-06_JPRB,0.88593E-06_JPRB,0.92651E-06_JPRB, &
 & 0.91449E-06_JPRB,0.83048E-06_JPRB,0.88651E-06_JPRB,0.36087E-06_JPRB /)  
KA(:, 1,11, 5) = (/ &
 & 0.16984E-06_JPRB,0.38981E-06_JPRB,0.44742E-06_JPRB,0.48022E-06_JPRB,0.44950E-06_JPRB, &
 & 0.45173E-06_JPRB,0.47333E-06_JPRB,0.50203E-06_JPRB,0.12166E-06_JPRB /)  
KA(:, 2,11, 5) = (/ &
 & 0.18466E-06_JPRB,0.44753E-06_JPRB,0.50754E-06_JPRB,0.54744E-06_JPRB,0.51342E-06_JPRB, &
 & 0.47893E-06_JPRB,0.53296E-06_JPRB,0.51992E-06_JPRB,0.16283E-06_JPRB /)  
KA(:, 3,11, 5) = (/ &
 & 0.19826E-06_JPRB,0.49803E-06_JPRB,0.56578E-06_JPRB,0.60333E-06_JPRB,0.60031E-06_JPRB, &
 & 0.56085E-06_JPRB,0.55152E-06_JPRB,0.63442E-06_JPRB,0.20412E-06_JPRB /)  
KA(:, 4,11, 5) = (/ &
 & 0.21087E-06_JPRB,0.54349E-06_JPRB,0.62058E-06_JPRB,0.66722E-06_JPRB,0.68339E-06_JPRB, &
 & 0.65819E-06_JPRB,0.60140E-06_JPRB,0.64555E-06_JPRB,0.24501E-06_JPRB /)  
KA(:, 5,11, 5) = (/ &
 & 0.22228E-06_JPRB,0.58430E-06_JPRB,0.67139E-06_JPRB,0.72733E-06_JPRB,0.76067E-06_JPRB, &
 & 0.75025E-06_JPRB,0.68133E-06_JPRB,0.72307E-06_JPRB,0.29566E-06_JPRB /)  
KA(:, 1,12, 5) = (/ &
 & 0.13908E-06_JPRB,0.32322E-06_JPRB,0.36926E-06_JPRB,0.39668E-06_JPRB,0.37094E-06_JPRB, &
 & 0.37104E-06_JPRB,0.38736E-06_JPRB,0.41059E-06_JPRB,0.10018E-06_JPRB /)  
KA(:, 2,12, 5) = (/ &
 & 0.15119E-06_JPRB,0.37037E-06_JPRB,0.41804E-06_JPRB,0.44988E-06_JPRB,0.42138E-06_JPRB, &
 & 0.39334E-06_JPRB,0.43800E-06_JPRB,0.42649E-06_JPRB,0.13384E-06_JPRB /)  
KA(:, 3,12, 5) = (/ &
 & 0.16232E-06_JPRB,0.41107E-06_JPRB,0.46554E-06_JPRB,0.49568E-06_JPRB,0.49349E-06_JPRB, &
 & 0.46062E-06_JPRB,0.45205E-06_JPRB,0.52165E-06_JPRB,0.16749E-06_JPRB /)  
KA(:, 4,12, 5) = (/ &
 & 0.17268E-06_JPRB,0.44802E-06_JPRB,0.51028E-06_JPRB,0.54757E-06_JPRB,0.56096E-06_JPRB, &
 & 0.54041E-06_JPRB,0.49303E-06_JPRB,0.52723E-06_JPRB,0.20095E-06_JPRB /)  
KA(:, 5,12, 5) = (/ &
 & 0.18199E-06_JPRB,0.48092E-06_JPRB,0.55149E-06_JPRB,0.59694E-06_JPRB,0.62405E-06_JPRB, &
 & 0.61534E-06_JPRB,0.55851E-06_JPRB,0.58926E-06_JPRB,0.24228E-06_JPRB /)  
KA(:, 1,13, 5) = (/ &
 & 0.11387E-06_JPRB,0.26741E-06_JPRB,0.30441E-06_JPRB,0.32687E-06_JPRB,0.30479E-06_JPRB, &
 & 0.30477E-06_JPRB,0.31768E-06_JPRB,0.33316E-06_JPRB,0.82090E-07_JPRB /)  
KA(:, 2,13, 5) = (/ &
 & 0.12381E-06_JPRB,0.30579E-06_JPRB,0.34391E-06_JPRB,0.36935E-06_JPRB,0.34578E-06_JPRB, &
 & 0.32317E-06_JPRB,0.35995E-06_JPRB,0.35099E-06_JPRB,0.10981E-06_JPRB /)  
KA(:, 3,13, 5) = (/ &
 & 0.13290E-06_JPRB,0.33871E-06_JPRB,0.38265E-06_JPRB,0.40672E-06_JPRB,0.40511E-06_JPRB, &
 & 0.37796E-06_JPRB,0.36986E-06_JPRB,0.42813E-06_JPRB,0.13721E-06_JPRB /)  
KA(:, 4,13, 5) = (/ &
 & 0.14135E-06_JPRB,0.36878E-06_JPRB,0.41898E-06_JPRB,0.44916E-06_JPRB,0.46012E-06_JPRB, &
 & 0.44348E-06_JPRB,0.40383E-06_JPRB,0.43087E-06_JPRB,0.16460E-06_JPRB /)  
KA(:, 5,13, 5) = (/ &
 & 0.14898E-06_JPRB,0.39524E-06_JPRB,0.45245E-06_JPRB,0.48939E-06_JPRB,0.51148E-06_JPRB, &
 & 0.50420E-06_JPRB,0.45753E-06_JPRB,0.48088E-06_JPRB,0.19843E-06_JPRB /)  
KA(:, 1, 1, 6) = (/ &
 & 0.49835E-05_JPRB,0.73512E-05_JPRB,0.88016E-05_JPRB,0.97115E-05_JPRB,0.10342E-04_JPRB, &
 & 0.10688E-04_JPRB,0.10747E-04_JPRB,0.97587E-05_JPRB,0.57353E-05_JPRB /)  
KA(:, 2, 1, 6) = (/ &
 & 0.49823E-05_JPRB,0.77944E-05_JPRB,0.95403E-05_JPRB,0.10739E-04_JPRB,0.11522E-04_JPRB, &
 & 0.11974E-04_JPRB,0.12019E-04_JPRB,0.11200E-04_JPRB,0.69362E-05_JPRB /)  
KA(:, 3, 1, 6) = (/ &
 & 0.49638E-05_JPRB,0.82513E-05_JPRB,0.10343E-04_JPRB,0.11836E-04_JPRB,0.12804E-04_JPRB, &
 & 0.13375E-04_JPRB,0.13427E-04_JPRB,0.12807E-04_JPRB,0.83325E-05_JPRB /)  
KA(:, 4, 1, 6) = (/ &
 & 0.49300E-05_JPRB,0.87230E-05_JPRB,0.11131E-04_JPRB,0.12834E-04_JPRB,0.13980E-04_JPRB, &
 & 0.14660E-04_JPRB,0.14790E-04_JPRB,0.14186E-04_JPRB,0.94893E-05_JPRB /)  
KA(:, 5, 1, 6) = (/ &
 & 0.48886E-05_JPRB,0.92046E-05_JPRB,0.11933E-04_JPRB,0.13885E-04_JPRB,0.15255E-04_JPRB, &
 & 0.16071E-04_JPRB,0.16239E-04_JPRB,0.15605E-04_JPRB,0.10917E-04_JPRB /)  
KA(:, 1, 2, 6) = (/ &
 & 0.41174E-05_JPRB,0.62362E-05_JPRB,0.73897E-05_JPRB,0.81161E-05_JPRB,0.86061E-05_JPRB, &
 & 0.88364E-05_JPRB,0.89272E-05_JPRB,0.81534E-05_JPRB,0.45187E-05_JPRB /)  
KA(:, 2, 2, 6) = (/ &
 & 0.41154E-05_JPRB,0.66112E-05_JPRB,0.80274E-05_JPRB,0.90030E-05_JPRB,0.96264E-05_JPRB, &
 & 0.99529E-05_JPRB,0.10004E-04_JPRB,0.93836E-05_JPRB,0.55300E-05_JPRB /)  
KA(:, 3, 2, 6) = (/ &
 & 0.40999E-05_JPRB,0.69972E-05_JPRB,0.87232E-05_JPRB,0.99464E-05_JPRB,0.10738E-04_JPRB, &
 & 0.11186E-04_JPRB,0.11235E-04_JPRB,0.10760E-04_JPRB,0.66656E-05_JPRB /)  
KA(:, 4, 2, 6) = (/ &
 & 0.40728E-05_JPRB,0.73933E-05_JPRB,0.94032E-05_JPRB,0.10842E-04_JPRB,0.11807E-04_JPRB, &
 & 0.12371E-04_JPRB,0.12495E-04_JPRB,0.12016E-04_JPRB,0.78073E-05_JPRB /)  
KA(:, 5, 2, 6) = (/ &
 & 0.40371E-05_JPRB,0.77954E-05_JPRB,0.10060E-04_JPRB,0.11710E-04_JPRB,0.12855E-04_JPRB, &
 & 0.13529E-04_JPRB,0.13658E-04_JPRB,0.13169E-04_JPRB,0.88462E-05_JPRB /)  
KA(:, 1, 3, 6) = (/ &
 & 0.33911E-05_JPRB,0.51807E-05_JPRB,0.60524E-05_JPRB,0.65745E-05_JPRB,0.69209E-05_JPRB, &
 & 0.70496E-05_JPRB,0.71376E-05_JPRB,0.64864E-05_JPRB,0.34232E-05_JPRB /)  
KA(:, 2, 3, 6) = (/ &
 & 0.33916E-05_JPRB,0.54910E-05_JPRB,0.65875E-05_JPRB,0.73243E-05_JPRB,0.77878E-05_JPRB, &
 & 0.79847E-05_JPRB,0.80332E-05_JPRB,0.75309E-05_JPRB,0.42228E-05_JPRB /)  
KA(:, 3, 3, 6) = (/ &
 & 0.33813E-05_JPRB,0.58057E-05_JPRB,0.71503E-05_JPRB,0.80869E-05_JPRB,0.86798E-05_JPRB, &
 & 0.89845E-05_JPRB,0.90042E-05_JPRB,0.85938E-05_JPRB,0.50519E-05_JPRB /)  
KA(:, 4, 3, 6) = (/ &
 & 0.33618E-05_JPRB,0.61503E-05_JPRB,0.77470E-05_JPRB,0.88947E-05_JPRB,0.96421E-05_JPRB, &
 & 0.10056E-04_JPRB,0.10131E-04_JPRB,0.97836E-05_JPRB,0.60817E-05_JPRB /)  
KA(:, 5, 3, 6) = (/ &
 & 0.33346E-05_JPRB,0.64834E-05_JPRB,0.82992E-05_JPRB,0.96266E-05_JPRB,0.10527E-04_JPRB, &
 & 0.11042E-04_JPRB,0.11154E-04_JPRB,0.10788E-04_JPRB,0.69208E-05_JPRB /)  
KA(:, 1, 4, 6) = (/ &
 & 0.27862E-05_JPRB,0.42534E-05_JPRB,0.48987E-05_JPRB,0.52435E-05_JPRB,0.54733E-05_JPRB, &
 & 0.55364E-05_JPRB,0.55872E-05_JPRB,0.49226E-05_JPRB,0.25436E-05_JPRB /)  
KA(:, 2, 4, 6) = (/ &
 & 0.27893E-05_JPRB,0.45093E-05_JPRB,0.53394E-05_JPRB,0.58691E-05_JPRB,0.61855E-05_JPRB, &
 & 0.63070E-05_JPRB,0.63399E-05_JPRB,0.58599E-05_JPRB,0.31726E-05_JPRB /)  
KA(:, 3, 4, 6) = (/ &
 & 0.27843E-05_JPRB,0.47714E-05_JPRB,0.58075E-05_JPRB,0.65048E-05_JPRB,0.69158E-05_JPRB, &
 & 0.71341E-05_JPRB,0.71529E-05_JPRB,0.67578E-05_JPRB,0.38485E-05_JPRB /)  
KA(:, 4, 4, 6) = (/ &
 & 0.27713E-05_JPRB,0.50491E-05_JPRB,0.62824E-05_JPRB,0.71451E-05_JPRB,0.76931E-05_JPRB, &
 & 0.79968E-05_JPRB,0.80403E-05_JPRB,0.77391E-05_JPRB,0.46093E-05_JPRB /)  
KA(:, 5, 4, 6) = (/ &
 & 0.27517E-05_JPRB,0.53526E-05_JPRB,0.67897E-05_JPRB,0.78357E-05_JPRB,0.85357E-05_JPRB, &
 & 0.89260E-05_JPRB,0.90160E-05_JPRB,0.87287E-05_JPRB,0.54226E-05_JPRB /)  
KA(:, 1, 5, 6) = (/ &
 & 0.22852E-05_JPRB,0.34704E-05_JPRB,0.39351E-05_JPRB,0.41626E-05_JPRB,0.42797E-05_JPRB, &
 & 0.43078E-05_JPRB,0.42289E-05_JPRB,0.36572E-05_JPRB,0.18725E-05_JPRB /)  
KA(:, 2, 5, 6) = (/ &
 & 0.22904E-05_JPRB,0.36828E-05_JPRB,0.42969E-05_JPRB,0.46636E-05_JPRB,0.48818E-05_JPRB, &
 & 0.49227E-05_JPRB,0.49640E-05_JPRB,0.45776E-05_JPRB,0.23620E-05_JPRB /)  
KA(:, 3, 5, 6) = (/ &
 & 0.22883E-05_JPRB,0.38995E-05_JPRB,0.46830E-05_JPRB,0.51887E-05_JPRB,0.54814E-05_JPRB, &
 & 0.56039E-05_JPRB,0.56350E-05_JPRB,0.52624E-05_JPRB,0.29139E-05_JPRB /)  
KA(:, 4, 5, 6) = (/ &
 & 0.22808E-05_JPRB,0.41317E-05_JPRB,0.50763E-05_JPRB,0.57196E-05_JPRB,0.61208E-05_JPRB, &
 & 0.63389E-05_JPRB,0.63549E-05_JPRB,0.60859E-05_JPRB,0.35219E-05_JPRB /)  
KA(:, 5, 5, 6) = (/ &
 & 0.22671E-05_JPRB,0.43851E-05_JPRB,0.54991E-05_JPRB,0.62948E-05_JPRB,0.68249E-05_JPRB, &
 & 0.71098E-05_JPRB,0.71755E-05_JPRB,0.69558E-05_JPRB,0.41900E-05_JPRB /)  
KA(:, 1, 6, 6) = (/ &
 & 0.18699E-05_JPRB,0.28114E-05_JPRB,0.31400E-05_JPRB,0.32683E-05_JPRB,0.33153E-05_JPRB, &
 & 0.33008E-05_JPRB,0.31920E-05_JPRB,0.27860E-05_JPRB,0.13420E-05_JPRB /)  
KA(:, 2, 6, 6) = (/ &
 & 0.18773E-05_JPRB,0.29859E-05_JPRB,0.34309E-05_JPRB,0.36695E-05_JPRB,0.38007E-05_JPRB, &
 & 0.38091E-05_JPRB,0.38180E-05_JPRB,0.34314E-05_JPRB,0.17179E-05_JPRB /)  
KA(:, 3, 6, 6) = (/ &
 & 0.18783E-05_JPRB,0.31642E-05_JPRB,0.37448E-05_JPRB,0.40997E-05_JPRB,0.43019E-05_JPRB, &
 & 0.43546E-05_JPRB,0.43740E-05_JPRB,0.40084E-05_JPRB,0.21605E-05_JPRB /)  
KA(:, 4, 6, 6) = (/ &
 & 0.18743E-05_JPRB,0.33566E-05_JPRB,0.40684E-05_JPRB,0.45371E-05_JPRB,0.48151E-05_JPRB, &
 & 0.49624E-05_JPRB,0.49624E-05_JPRB,0.47228E-05_JPRB,0.26431E-05_JPRB /)  
KA(:, 5, 6, 6) = (/ &
 & 0.18657E-05_JPRB,0.35541E-05_JPRB,0.43955E-05_JPRB,0.49826E-05_JPRB,0.53649E-05_JPRB, &
 & 0.55694E-05_JPRB,0.55990E-05_JPRB,0.54328E-05_JPRB,0.31359E-05_JPRB /)  
KA(:, 1, 7, 6) = (/ &
 & 0.15270E-05_JPRB,0.22681E-05_JPRB,0.24953E-05_JPRB,0.25538E-05_JPRB,0.25397E-05_JPRB, &
 & 0.25315E-05_JPRB,0.23299E-05_JPRB,0.21035E-05_JPRB,0.95748E-06_JPRB /)  
KA(:, 2, 7, 6) = (/ &
 & 0.15365E-05_JPRB,0.24113E-05_JPRB,0.27304E-05_JPRB,0.28767E-05_JPRB,0.29339E-05_JPRB, &
 & 0.29290E-05_JPRB,0.28728E-05_JPRB,0.24852E-05_JPRB,0.12383E-05_JPRB /)  
KA(:, 3, 7, 6) = (/ &
 & 0.15398E-05_JPRB,0.25576E-05_JPRB,0.29821E-05_JPRB,0.32226E-05_JPRB,0.33508E-05_JPRB, &
 & 0.33584E-05_JPRB,0.33733E-05_JPRB,0.31044E-05_JPRB,0.15900E-05_JPRB /)  
KA(:, 4, 7, 6) = (/ &
 & 0.15385E-05_JPRB,0.27150E-05_JPRB,0.32458E-05_JPRB,0.35802E-05_JPRB,0.37697E-05_JPRB, &
 & 0.38500E-05_JPRB,0.38510E-05_JPRB,0.36169E-05_JPRB,0.19605E-05_JPRB /)  
KA(:, 5, 7, 6) = (/ &
 & 0.15336E-05_JPRB,0.28792E-05_JPRB,0.35139E-05_JPRB,0.39460E-05_JPRB,0.42149E-05_JPRB, &
 & 0.43622E-05_JPRB,0.43664E-05_JPRB,0.42187E-05_JPRB,0.23523E-05_JPRB /)  
KA(:, 1, 8, 6) = (/ &
 & 0.12444E-05_JPRB,0.18266E-05_JPRB,0.19784E-05_JPRB,0.19900E-05_JPRB,0.19390E-05_JPRB, &
 & 0.19235E-05_JPRB,0.17231E-05_JPRB,0.16995E-05_JPRB,0.68590E-06_JPRB /)  
KA(:, 2, 8, 6) = (/ &
 & 0.12557E-05_JPRB,0.19427E-05_JPRB,0.21667E-05_JPRB,0.22465E-05_JPRB,0.22625E-05_JPRB, &
 & 0.22377E-05_JPRB,0.21596E-05_JPRB,0.18759E-05_JPRB,0.89490E-06_JPRB /)  
KA(:, 3, 8, 6) = (/ &
 & 0.12608E-05_JPRB,0.20627E-05_JPRB,0.23694E-05_JPRB,0.25224E-05_JPRB,0.25961E-05_JPRB, &
 & 0.25892E-05_JPRB,0.25887E-05_JPRB,0.23400E-05_JPRB,0.11490E-05_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART4',1,ZHOOK_HANDLE)
END SUBROUTINE PART4


SUBROUTINE PART5

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART5',0,ZHOOK_HANDLE)


KA(:, 4, 8, 6) = (/ &
 & 0.12616E-05_JPRB,0.21916E-05_JPRB,0.25816E-05_JPRB,0.28156E-05_JPRB,0.29418E-05_JPRB, &
 & 0.29759E-05_JPRB,0.29788E-05_JPRB,0.27379E-05_JPRB,0.14416E-05_JPRB /)  
KA(:, 5, 8, 6) = (/ &
 & 0.12590E-05_JPRB,0.23261E-05_JPRB,0.28013E-05_JPRB,0.31131E-05_JPRB,0.32990E-05_JPRB, &
 & 0.33976E-05_JPRB,0.33946E-05_JPRB,0.32600E-05_JPRB,0.17529E-05_JPRB /)  
KA(:, 1, 9, 6) = (/ &
 & 0.10123E-05_JPRB,0.14681E-05_JPRB,0.15612E-05_JPRB,0.15411E-05_JPRB,0.14778E-05_JPRB, &
 & 0.14343E-05_JPRB,0.12992E-05_JPRB,0.13172E-05_JPRB,0.49290E-06_JPRB /)  
KA(:, 2, 9, 6) = (/ &
 & 0.10245E-05_JPRB,0.15617E-05_JPRB,0.17149E-05_JPRB,0.17499E-05_JPRB,0.17312E-05_JPRB, &
 & 0.17144E-05_JPRB,0.15772E-05_JPRB,0.14382E-05_JPRB,0.63132E-06_JPRB /)  
KA(:, 3, 9, 6) = (/ &
 & 0.10311E-05_JPRB,0.16600E-05_JPRB,0.18786E-05_JPRB,0.19738E-05_JPRB,0.20017E-05_JPRB, &
 & 0.19859E-05_JPRB,0.19416E-05_JPRB,0.17139E-05_JPRB,0.82278E-06_JPRB /)  
KA(:, 4, 9, 6) = (/ &
 & 0.10334E-05_JPRB,0.17639E-05_JPRB,0.20493E-05_JPRB,0.22069E-05_JPRB,0.22845E-05_JPRB, &
 & 0.22769E-05_JPRB,0.22855E-05_JPRB,0.21115E-05_JPRB,0.10531E-05_JPRB /)  
KA(:, 5, 9, 6) = (/ &
 & 0.10328E-05_JPRB,0.18738E-05_JPRB,0.22265E-05_JPRB,0.24495E-05_JPRB,0.25737E-05_JPRB, &
 & 0.26232E-05_JPRB,0.26173E-05_JPRB,0.24699E-05_JPRB,0.12950E-05_JPRB /)  
KA(:, 1,10, 6) = (/ &
 & 0.82261E-06_JPRB,0.11811E-05_JPRB,0.12403E-05_JPRB,0.12060E-05_JPRB,0.11493E-05_JPRB, &
 & 0.10907E-05_JPRB,0.98035E-06_JPRB,0.10980E-05_JPRB,0.37316E-06_JPRB /)  
KA(:, 2,10, 6) = (/ &
 & 0.83528E-06_JPRB,0.12595E-05_JPRB,0.13646E-05_JPRB,0.13745E-05_JPRB,0.13365E-05_JPRB, &
 & 0.13172E-05_JPRB,0.11846E-05_JPRB,0.11491E-05_JPRB,0.46158E-06_JPRB /)  
KA(:, 3,10, 6) = (/ &
 & 0.84255E-06_JPRB,0.13392E-05_JPRB,0.14968E-05_JPRB,0.15528E-05_JPRB,0.15573E-05_JPRB, &
 & 0.15339E-05_JPRB,0.14802E-05_JPRB,0.12811E-05_JPRB,0.60300E-06_JPRB /)  
KA(:, 4,10, 6) = (/ &
 & 0.84587E-06_JPRB,0.14245E-05_JPRB,0.16355E-05_JPRB,0.17381E-05_JPRB,0.17835E-05_JPRB, &
 & 0.17693E-05_JPRB,0.17683E-05_JPRB,0.16097E-05_JPRB,0.77730E-06_JPRB /)  
KA(:, 5,10, 6) = (/ &
 & 0.84627E-06_JPRB,0.15137E-05_JPRB,0.17779E-05_JPRB,0.19378E-05_JPRB,0.20192E-05_JPRB, &
 & 0.20387E-05_JPRB,0.20340E-05_JPRB,0.18636E-05_JPRB,0.96863E-06_JPRB /)  
KA(:, 1,11, 6) = (/ &
 & 0.67388E-06_JPRB,0.97942E-06_JPRB,0.10286E-05_JPRB,0.10023E-05_JPRB,0.95317E-06_JPRB, &
 & 0.90847E-06_JPRB,0.81776E-06_JPRB,0.89345E-06_JPRB,0.30408E-06_JPRB /)  
KA(:, 2,11, 6) = (/ &
 & 0.68407E-06_JPRB,0.10438E-05_JPRB,0.11334E-05_JPRB,0.11425E-05_JPRB,0.11096E-05_JPRB, &
 & 0.10886E-05_JPRB,0.98240E-06_JPRB,0.94798E-06_JPRB,0.38086E-06_JPRB /)  
KA(:, 3,11, 6) = (/ &
 & 0.69000E-06_JPRB,0.11106E-05_JPRB,0.12435E-05_JPRB,0.12890E-05_JPRB,0.12895E-05_JPRB, &
 & 0.12679E-05_JPRB,0.12202E-05_JPRB,0.10522E-05_JPRB,0.49623E-06_JPRB /)  
KA(:, 4,11, 6) = (/ &
 & 0.69276E-06_JPRB,0.11824E-05_JPRB,0.13564E-05_JPRB,0.14402E-05_JPRB,0.14763E-05_JPRB, &
 & 0.14628E-05_JPRB,0.14599E-05_JPRB,0.13328E-05_JPRB,0.63979E-06_JPRB /)  
KA(:, 5,11, 6) = (/ &
 & 0.69302E-06_JPRB,0.12555E-05_JPRB,0.14740E-05_JPRB,0.16049E-05_JPRB,0.16694E-05_JPRB, &
 & 0.16839E-05_JPRB,0.16772E-05_JPRB,0.15421E-05_JPRB,0.79514E-06_JPRB /)  
KA(:, 1,12, 6) = (/ &
 & 0.55214E-06_JPRB,0.81079E-06_JPRB,0.85249E-06_JPRB,0.83175E-06_JPRB,0.78783E-06_JPRB, &
 & 0.75281E-06_JPRB,0.67567E-06_JPRB,0.74075E-06_JPRB,0.24910E-06_JPRB /)  
KA(:, 2,12, 6) = (/ &
 & 0.56029E-06_JPRB,0.86391E-06_JPRB,0.94032E-06_JPRB,0.94758E-06_JPRB,0.91883E-06_JPRB, &
 & 0.89834E-06_JPRB,0.81189E-06_JPRB,0.77883E-06_JPRB,0.31399E-06_JPRB /)  
KA(:, 3,12, 6) = (/ &
 & 0.56504E-06_JPRB,0.92066E-06_JPRB,0.10308E-05_JPRB,0.10667E-05_JPRB,0.10655E-05_JPRB, &
 & 0.10460E-05_JPRB,0.10067E-05_JPRB,0.87150E-06_JPRB,0.40815E-06_JPRB /)  
KA(:, 4,12, 6) = (/ &
 & 0.56721E-06_JPRB,0.97985E-06_JPRB,0.11224E-05_JPRB,0.11915E-05_JPRB,0.12197E-05_JPRB, &
 & 0.12063E-05_JPRB,0.12014E-05_JPRB,0.10950E-05_JPRB,0.52630E-06_JPRB /)  
KA(:, 5,12, 6) = (/ &
 & 0.56742E-06_JPRB,0.10399E-05_JPRB,0.12195E-05_JPRB,0.13255E-05_JPRB,0.13771E-05_JPRB, &
 & 0.13876E-05_JPRB,0.13807E-05_JPRB,0.12724E-05_JPRB,0.65264E-06_JPRB /)  
KA(:, 1,13, 6) = (/ &
 & 0.45223E-06_JPRB,0.67006E-06_JPRB,0.70582E-06_JPRB,0.68873E-06_JPRB,0.65038E-06_JPRB, &
 & 0.62084E-06_JPRB,0.55442E-06_JPRB,0.60996E-06_JPRB,0.20428E-06_JPRB /)  
KA(:, 2,13, 6) = (/ &
 & 0.45880E-06_JPRB,0.71490E-06_JPRB,0.77859E-06_JPRB,0.78376E-06_JPRB,0.75834E-06_JPRB, &
 & 0.73987E-06_JPRB,0.66959E-06_JPRB,0.63711E-06_JPRB,0.25817E-06_JPRB /)  
KA(:, 3,13, 6) = (/ &
 & 0.46276E-06_JPRB,0.76231E-06_JPRB,0.85214E-06_JPRB,0.88098E-06_JPRB,0.87867E-06_JPRB, &
 & 0.86188E-06_JPRB,0.83033E-06_JPRB,0.72166E-06_JPRB,0.33548E-06_JPRB /)  
KA(:, 4,13, 6) = (/ &
 & 0.46442E-06_JPRB,0.81043E-06_JPRB,0.92714E-06_JPRB,0.98329E-06_JPRB,0.10050E-05_JPRB, &
 & 0.99247E-06_JPRB,0.98770E-06_JPRB,0.89931E-06_JPRB,0.43220E-06_JPRB /)  
KA(:, 5,13, 6) = (/ &
 & 0.46456E-06_JPRB,0.86048E-06_JPRB,0.10065E-05_JPRB,0.10920E-05_JPRB,0.11333E-05_JPRB, &
 & 0.11411E-05_JPRB,0.11342E-05_JPRB,0.10473E-05_JPRB,0.53527E-06_JPRB /)  
KA(:, 1, 1, 7) = (/ &
 & 0.12335E-04_JPRB,0.15987E-04_JPRB,0.18565E-04_JPRB,0.20406E-04_JPRB,0.21636E-04_JPRB, &
 & 0.22077E-04_JPRB,0.21364E-04_JPRB,0.19544E-04_JPRB,0.14733E-04_JPRB /)  
KA(:, 2, 1, 7) = (/ &
 & 0.12351E-04_JPRB,0.17014E-04_JPRB,0.20216E-04_JPRB,0.22480E-04_JPRB,0.24098E-04_JPRB, &
 & 0.24791E-04_JPRB,0.24379E-04_JPRB,0.22600E-04_JPRB,0.17292E-04_JPRB /)  
KA(:, 3, 1, 7) = (/ &
 & 0.12364E-04_JPRB,0.18152E-04_JPRB,0.21907E-04_JPRB,0.24643E-04_JPRB,0.26659E-04_JPRB, &
 & 0.27630E-04_JPRB,0.27512E-04_JPRB,0.25730E-04_JPRB,0.20236E-04_JPRB /)  
KA(:, 4, 1, 7) = (/ &
 & 0.12365E-04_JPRB,0.19320E-04_JPRB,0.23679E-04_JPRB,0.26885E-04_JPRB,0.29225E-04_JPRB, &
 & 0.30430E-04_JPRB,0.30461E-04_JPRB,0.28726E-04_JPRB,0.23208E-04_JPRB /)  
KA(:, 5, 1, 7) = (/ &
 & 0.12355E-04_JPRB,0.20495E-04_JPRB,0.25505E-04_JPRB,0.29189E-04_JPRB,0.31816E-04_JPRB, &
 & 0.33308E-04_JPRB,0.33478E-04_JPRB,0.31898E-04_JPRB,0.26469E-04_JPRB /)  
KA(:, 1, 2, 7) = (/ &
 & 0.10350E-04_JPRB,0.13753E-04_JPRB,0.16101E-04_JPRB,0.17726E-04_JPRB,0.18733E-04_JPRB, &
 & 0.19034E-04_JPRB,0.18319E-04_JPRB,0.16594E-04_JPRB,0.11961E-04_JPRB /)  
KA(:, 2, 2, 7) = (/ &
 & 0.10365E-04_JPRB,0.14706E-04_JPRB,0.17542E-04_JPRB,0.19561E-04_JPRB,0.20895E-04_JPRB, &
 & 0.21420E-04_JPRB,0.21012E-04_JPRB,0.19409E-04_JPRB,0.14130E-04_JPRB /)  
KA(:, 3, 2, 7) = (/ &
 & 0.10364E-04_JPRB,0.15733E-04_JPRB,0.19081E-04_JPRB,0.21505E-04_JPRB,0.23181E-04_JPRB, &
 & 0.23958E-04_JPRB,0.23844E-04_JPRB,0.22334E-04_JPRB,0.16750E-04_JPRB /)  
KA(:, 4, 2, 7) = (/ &
 & 0.10354E-04_JPRB,0.16759E-04_JPRB,0.20670E-04_JPRB,0.23471E-04_JPRB,0.25440E-04_JPRB, &
 & 0.26474E-04_JPRB,0.26560E-04_JPRB,0.25188E-04_JPRB,0.19386E-04_JPRB /)  
KA(:, 5, 2, 7) = (/ &
 & 0.10329E-04_JPRB,0.17823E-04_JPRB,0.22292E-04_JPRB,0.25488E-04_JPRB,0.27703E-04_JPRB, &
 & 0.28957E-04_JPRB,0.29205E-04_JPRB,0.27936E-04_JPRB,0.22026E-04_JPRB /)  
KA(:, 1, 3, 7) = (/ &
 & 0.86408E-05_JPRB,0.11607E-04_JPRB,0.13624E-04_JPRB,0.14928E-04_JPRB,0.15622E-04_JPRB, &
 & 0.15768E-04_JPRB,0.15034E-04_JPRB,0.13540E-04_JPRB,0.91950E-05_JPRB /)  
KA(:, 2, 3, 7) = (/ &
 & 0.86478E-05_JPRB,0.12463E-04_JPRB,0.14889E-04_JPRB,0.16508E-04_JPRB,0.17482E-04_JPRB, &
 & 0.17819E-04_JPRB,0.17439E-04_JPRB,0.15994E-04_JPRB,0.11026E-04_JPRB /)  
KA(:, 3, 3, 7) = (/ &
 & 0.86444E-05_JPRB,0.13354E-04_JPRB,0.16234E-04_JPRB,0.18159E-04_JPRB,0.19394E-04_JPRB, &
 & 0.19962E-04_JPRB,0.19837E-04_JPRB,0.18485E-04_JPRB,0.13087E-04_JPRB /)  
KA(:, 4, 3, 7) = (/ &
 & 0.86273E-05_JPRB,0.14262E-04_JPRB,0.17647E-04_JPRB,0.19921E-04_JPRB,0.21457E-04_JPRB, &
 & 0.22290E-04_JPRB,0.22338E-04_JPRB,0.21203E-04_JPRB,0.15397E-04_JPRB /)  
KA(:, 5, 3, 7) = (/ &
 & 0.85960E-05_JPRB,0.15200E-04_JPRB,0.19031E-04_JPRB,0.21649E-04_JPRB,0.23415E-04_JPRB, &
 & 0.24453E-04_JPRB,0.24660E-04_JPRB,0.23666E-04_JPRB,0.17582E-04_JPRB /)  
KA(:, 1, 4, 7) = (/ &
 & 0.71803E-05_JPRB,0.97101E-05_JPRB,0.11373E-04_JPRB,0.12321E-04_JPRB,0.12789E-04_JPRB, &
 & 0.12803E-04_JPRB,0.12062E-04_JPRB,0.10784E-04_JPRB,0.69624E-05_JPRB /)  
KA(:, 2, 4, 7) = (/ &
 & 0.71855E-05_JPRB,0.10459E-04_JPRB,0.12456E-04_JPRB,0.13673E-04_JPRB,0.14371E-04_JPRB, &
 & 0.14569E-04_JPRB,0.14153E-04_JPRB,0.12788E-04_JPRB,0.84564E-05_JPRB /)  
KA(:, 3, 4, 7) = (/ &
 & 0.71795E-05_JPRB,0.11229E-04_JPRB,0.13608E-04_JPRB,0.15091E-04_JPRB,0.16013E-04_JPRB, &
 & 0.16409E-04_JPRB,0.16232E-04_JPRB,0.15085E-04_JPRB,0.10120E-04_JPRB /)  
KA(:, 4, 4, 7) = (/ &
 & 0.71584E-05_JPRB,0.12023E-04_JPRB,0.14800E-04_JPRB,0.16568E-04_JPRB,0.17732E-04_JPRB, &
 & 0.18336E-04_JPRB,0.18317E-04_JPRB,0.17347E-04_JPRB,0.11917E-04_JPRB /)  
KA(:, 5, 4, 7) = (/ &
 & 0.71267E-05_JPRB,0.12845E-04_JPRB,0.16058E-04_JPRB,0.18162E-04_JPRB,0.19580E-04_JPRB, &
 & 0.20399E-04_JPRB,0.20543E-04_JPRB,0.19767E-04_JPRB,0.13958E-04_JPRB /)  
KA(:, 1, 5, 7) = (/ &
 & 0.59442E-05_JPRB,0.80861E-05_JPRB,0.93878E-05_JPRB,0.10066E-04_JPRB,0.10362E-04_JPRB, &
 & 0.10281E-04_JPRB,0.95734E-05_JPRB,0.84778E-05_JPRB,0.52204E-05_JPRB /)  
KA(:, 2, 5, 7) = (/ &
 & 0.59498E-05_JPRB,0.87281E-05_JPRB,0.10301E-04_JPRB,0.11210E-04_JPRB,0.11702E-04_JPRB, &
 & 0.11782E-04_JPRB,0.11315E-04_JPRB,0.10068E-04_JPRB,0.64302E-05_JPRB /)  
KA(:, 3, 5, 7) = (/ &
 & 0.59430E-05_JPRB,0.93925E-05_JPRB,0.11277E-04_JPRB,0.12419E-04_JPRB,0.13099E-04_JPRB, &
 & 0.13351E-04_JPRB,0.13104E-04_JPRB,0.12095E-04_JPRB,0.77633E-05_JPRB /)  
KA(:, 4, 5, 7) = (/ &
 & 0.59217E-05_JPRB,0.10078E-04_JPRB,0.12288E-04_JPRB,0.13686E-04_JPRB,0.14573E-04_JPRB, &
 & 0.14994E-04_JPRB,0.14908E-04_JPRB,0.14023E-04_JPRB,0.92337E-05_JPRB /)  
KA(:, 5, 5, 7) = (/ &
 & 0.58935E-05_JPRB,0.10789E-04_JPRB,0.13390E-04_JPRB,0.15066E-04_JPRB,0.16172E-04_JPRB, &
 & 0.16788E-04_JPRB,0.16832E-04_JPRB,0.16140E-04_JPRB,0.10913E-04_JPRB /)  
KA(:, 1, 6, 7) = (/ &
 & 0.49077E-05_JPRB,0.66672E-05_JPRB,0.76412E-05_JPRB,0.81181E-05_JPRB,0.82831E-05_JPRB, &
 & 0.81137E-05_JPRB,0.74381E-05_JPRB,0.64600E-05_JPRB,0.38540E-05_JPRB /)  
KA(:, 2, 6, 7) = (/ &
 & 0.49136E-05_JPRB,0.72093E-05_JPRB,0.84100E-05_JPRB,0.90761E-05_JPRB,0.94026E-05_JPRB, &
 & 0.93849E-05_JPRB,0.88761E-05_JPRB,0.77852E-05_JPRB,0.48097E-05_JPRB /)  
KA(:, 3, 6, 7) = (/ &
 & 0.49088E-05_JPRB,0.77732E-05_JPRB,0.92304E-05_JPRB,0.10089E-04_JPRB,0.10581E-04_JPRB, &
 & 0.10707E-04_JPRB,0.10412E-04_JPRB,0.94217E-05_JPRB,0.58741E-05_JPRB /)  
KA(:, 4, 6, 7) = (/ &
 & 0.48919E-05_JPRB,0.83551E-05_JPRB,0.10086E-04_JPRB,0.11166E-04_JPRB,0.11831E-04_JPRB, &
 & 0.12095E-04_JPRB,0.11941E-04_JPRB,0.11106E-04_JPRB,0.70559E-05_JPRB /)  
KA(:, 5, 6, 7) = (/ &
 & 0.48652E-05_JPRB,0.89412E-05_JPRB,0.10983E-04_JPRB,0.12289E-04_JPRB,0.13118E-04_JPRB, &
 & 0.13538E-04_JPRB,0.13477E-04_JPRB,0.12811E-04_JPRB,0.83378E-05_JPRB /)  
KA(:, 1, 7, 7) = (/ &
 & 0.40428E-05_JPRB,0.54588E-05_JPRB,0.61687E-05_JPRB,0.64926E-05_JPRB,0.65568E-05_JPRB, &
 & 0.63259E-05_JPRB,0.56948E-05_JPRB,0.49607E-05_JPRB,0.28237E-05_JPRB /)  
KA(:, 2, 7, 7) = (/ &
 & 0.40484E-05_JPRB,0.59019E-05_JPRB,0.68052E-05_JPRB,0.72891E-05_JPRB,0.74881E-05_JPRB, &
 & 0.73951E-05_JPRB,0.68736E-05_JPRB,0.59771E-05_JPRB,0.35700E-05_JPRB /)  
KA(:, 3, 7, 7) = (/ &
 & 0.40443E-05_JPRB,0.63719E-05_JPRB,0.74936E-05_JPRB,0.81309E-05_JPRB,0.84699E-05_JPRB, &
 & 0.84975E-05_JPRB,0.81643E-05_JPRB,0.72224E-05_JPRB,0.43995E-05_JPRB /)  
KA(:, 4, 7, 7) = (/ &
 & 0.40304E-05_JPRB,0.68636E-05_JPRB,0.82100E-05_JPRB,0.90329E-05_JPRB,0.95142E-05_JPRB, &
 & 0.96616E-05_JPRB,0.94576E-05_JPRB,0.86932E-05_JPRB,0.53385E-05_JPRB /)  
KA(:, 5, 7, 7) = (/ &
 & 0.40097E-05_JPRB,0.73587E-05_JPRB,0.89665E-05_JPRB,0.99825E-05_JPRB,0.10592E-04_JPRB, &
 & 0.10860E-04_JPRB,0.10751E-04_JPRB,0.10114E-04_JPRB,0.63905E-05_JPRB /)  
KA(:, 1, 8, 7) = (/ &
 & 0.33247E-05_JPRB,0.44437E-05_JPRB,0.49476E-05_JPRB,0.51623E-05_JPRB,0.51521E-05_JPRB, &
 & 0.48927E-05_JPRB,0.43130E-05_JPRB,0.36508E-05_JPRB,0.20433E-05_JPRB /)  
KA(:, 2, 8, 7) = (/ &
 & 0.33302E-05_JPRB,0.48035E-05_JPRB,0.54757E-05_JPRB,0.58129E-05_JPRB,0.59219E-05_JPRB, &
 & 0.57796E-05_JPRB,0.52788E-05_JPRB,0.45081E-05_JPRB,0.26233E-05_JPRB /)  
KA(:, 3, 8, 7) = (/ &
 & 0.33275E-05_JPRB,0.51944E-05_JPRB,0.60436E-05_JPRB,0.65119E-05_JPRB,0.67329E-05_JPRB, &
 & 0.66992E-05_JPRB,0.63336E-05_JPRB,0.54989E-05_JPRB,0.32839E-05_JPRB /)  
KA(:, 4, 8, 7) = (/ &
 & 0.33167E-05_JPRB,0.56042E-05_JPRB,0.66425E-05_JPRB,0.72606E-05_JPRB,0.75965E-05_JPRB, &
 & 0.76619E-05_JPRB,0.74319E-05_JPRB,0.66922E-05_JPRB,0.40228E-05_JPRB /)  
KA(:, 5, 8, 7) = (/ &
 & 0.33014E-05_JPRB,0.60212E-05_JPRB,0.72748E-05_JPRB,0.80496E-05_JPRB,0.84940E-05_JPRB, &
 & 0.86532E-05_JPRB,0.85181E-05_JPRB,0.78992E-05_JPRB,0.48672E-05_JPRB /)  
KA(:, 1, 9, 7) = (/ &
 & 0.27310E-05_JPRB,0.35992E-05_JPRB,0.39468E-05_JPRB,0.40831E-05_JPRB,0.40161E-05_JPRB, &
 & 0.37266E-05_JPRB,0.32070E-05_JPRB,0.27591E-05_JPRB,0.14628E-05_JPRB /)  
KA(:, 2, 9, 7) = (/ &
 & 0.27361E-05_JPRB,0.38904E-05_JPRB,0.43781E-05_JPRB,0.46075E-05_JPRB,0.46475E-05_JPRB, &
 & 0.44710E-05_JPRB,0.39993E-05_JPRB,0.33922E-05_JPRB,0.19203E-05_JPRB /)  
KA(:, 3, 9, 7) = (/ &
 & 0.27349E-05_JPRB,0.42103E-05_JPRB,0.48448E-05_JPRB,0.51814E-05_JPRB,0.53150E-05_JPRB, &
 & 0.52403E-05_JPRB,0.48712E-05_JPRB,0.41669E-05_JPRB,0.24268E-05_JPRB /)  
KA(:, 4, 9, 7) = (/ &
 & 0.27270E-05_JPRB,0.45504E-05_JPRB,0.53414E-05_JPRB,0.57970E-05_JPRB,0.60255E-05_JPRB, &
 & 0.60359E-05_JPRB,0.57915E-05_JPRB,0.51016E-05_JPRB,0.30070E-05_JPRB /)  
KA(:, 5, 9, 7) = (/ &
 & 0.27146E-05_JPRB,0.48994E-05_JPRB,0.58660E-05_JPRB,0.64467E-05_JPRB,0.67684E-05_JPRB, &
 & 0.68529E-05_JPRB,0.66981E-05_JPRB,0.61431E-05_JPRB,0.36677E-05_JPRB /)  
KA(:, 1,10, 7) = (/ &
 & 0.22419E-05_JPRB,0.29237E-05_JPRB,0.31619E-05_JPRB,0.32419E-05_JPRB,0.31445E-05_JPRB, &
 & 0.28618E-05_JPRB,0.23945E-05_JPRB,0.20454E-05_JPRB,0.10493E-05_JPRB /)  
KA(:, 2,10, 7) = (/ &
 & 0.22458E-05_JPRB,0.31578E-05_JPRB,0.35134E-05_JPRB,0.36703E-05_JPRB,0.36665E-05_JPRB, &
 & 0.34835E-05_JPRB,0.30593E-05_JPRB,0.25559E-05_JPRB,0.14125E-05_JPRB /)  
KA(:, 3,10, 7) = (/ &
 & 0.22450E-05_JPRB,0.34192E-05_JPRB,0.38967E-05_JPRB,0.41378E-05_JPRB,0.42160E-05_JPRB, &
 & 0.41184E-05_JPRB,0.37724E-05_JPRB,0.31954E-05_JPRB,0.18099E-05_JPRB /)  
KA(:, 4,10, 7) = (/ &
 & 0.22393E-05_JPRB,0.36988E-05_JPRB,0.43039E-05_JPRB,0.46449E-05_JPRB,0.48027E-05_JPRB, &
 & 0.47756E-05_JPRB,0.45281E-05_JPRB,0.39284E-05_JPRB,0.22652E-05_JPRB /)  
KA(:, 5,10, 7) = (/ &
 & 0.22295E-05_JPRB,0.39888E-05_JPRB,0.47391E-05_JPRB,0.51827E-05_JPRB,0.54135E-05_JPRB, &
 & 0.54517E-05_JPRB,0.52919E-05_JPRB,0.47894E-05_JPRB,0.27859E-05_JPRB /)  
KA(:, 1,11, 7) = (/ &
 & 0.18412E-05_JPRB,0.24512E-05_JPRB,0.26550E-05_JPRB,0.27210E-05_JPRB,0.26438E-05_JPRB, &
 & 0.24068E-05_JPRB,0.20134E-05_JPRB,0.16980E-05_JPRB,0.87310E-06_JPRB /)  
KA(:, 2,11, 7) = (/ &
 & 0.18429E-05_JPRB,0.26525E-05_JPRB,0.29507E-05_JPRB,0.30835E-05_JPRB,0.30829E-05_JPRB, &
 & 0.29354E-05_JPRB,0.25810E-05_JPRB,0.21539E-05_JPRB,0.11715E-05_JPRB /)  
KA(:, 3,11, 7) = (/ &
 & 0.18405E-05_JPRB,0.28725E-05_JPRB,0.32735E-05_JPRB,0.34815E-05_JPRB,0.35507E-05_JPRB, &
 & 0.34733E-05_JPRB,0.31901E-05_JPRB,0.26957E-05_JPRB,0.15018E-05_JPRB /)  
KA(:, 4,11, 7) = (/ &
 & 0.18348E-05_JPRB,0.31060E-05_JPRB,0.36191E-05_JPRB,0.39123E-05_JPRB,0.40426E-05_JPRB, &
 & 0.40206E-05_JPRB,0.38184E-05_JPRB,0.33125E-05_JPRB,0.18804E-05_JPRB /)  
KA(:, 5,11, 7) = (/ &
 & 0.18263E-05_JPRB,0.33539E-05_JPRB,0.39862E-05_JPRB,0.43590E-05_JPRB,0.45516E-05_JPRB, &
 & 0.45841E-05_JPRB,0.44525E-05_JPRB,0.40371E-05_JPRB,0.23130E-05_JPRB /)  
KA(:, 1,12, 7) = (/ &
 & 0.15111E-05_JPRB,0.20512E-05_JPRB,0.22220E-05_JPRB,0.22783E-05_JPRB,0.22181E-05_JPRB, &
 & 0.20219E-05_JPRB,0.16992E-05_JPRB,0.14085E-05_JPRB,0.72438E-06_JPRB /)  
KA(:, 2,12, 7) = (/ &
 & 0.15111E-05_JPRB,0.22209E-05_JPRB,0.24719E-05_JPRB,0.25841E-05_JPRB,0.25877E-05_JPRB, &
 & 0.24700E-05_JPRB,0.21742E-05_JPRB,0.18087E-05_JPRB,0.96963E-06_JPRB /)  
KA(:, 3,12, 7) = (/ &
 & 0.15082E-05_JPRB,0.24051E-05_JPRB,0.27419E-05_JPRB,0.29223E-05_JPRB,0.29832E-05_JPRB, &
 & 0.29201E-05_JPRB,0.26833E-05_JPRB,0.22609E-05_JPRB,0.12444E-05_JPRB /)  
KA(:, 4,12, 7) = (/ &
 & 0.15029E-05_JPRB,0.26018E-05_JPRB,0.30364E-05_JPRB,0.32843E-05_JPRB,0.33933E-05_JPRB, &
 & 0.33730E-05_JPRB,0.32057E-05_JPRB,0.27875E-05_JPRB,0.15571E-05_JPRB /)  
KA(:, 5,12, 7) = (/ &
 & 0.14954E-05_JPRB,0.28127E-05_JPRB,0.33443E-05_JPRB,0.36551E-05_JPRB,0.38145E-05_JPRB, &
 & 0.38425E-05_JPRB,0.37317E-05_JPRB,0.33866E-05_JPRB,0.19133E-05_JPRB /)  
KA(:, 1,13, 7) = (/ &
 & 0.12390E-05_JPRB,0.17127E-05_JPRB,0.18553E-05_JPRB,0.19025E-05_JPRB,0.18568E-05_JPRB, &
 & 0.16968E-05_JPRB,0.14297E-05_JPRB,0.11813E-05_JPRB,0.59950E-06_JPRB /)  
KA(:, 2,13, 7) = (/ &
 & 0.12381E-05_JPRB,0.18537E-05_JPRB,0.20641E-05_JPRB,0.21603E-05_JPRB,0.21689E-05_JPRB, &
 & 0.20712E-05_JPRB,0.18216E-05_JPRB,0.15132E-05_JPRB,0.80096E-06_JPRB /)  
KA(:, 3,13, 7) = (/ &
 & 0.12352E-05_JPRB,0.20080E-05_JPRB,0.22929E-05_JPRB,0.24467E-05_JPRB,0.24992E-05_JPRB, &
 & 0.24434E-05_JPRB,0.22447E-05_JPRB,0.18839E-05_JPRB,0.10290E-05_JPRB /)  
KA(:, 4,13, 7) = (/ &
 & 0.12307E-05_JPRB,0.21754E-05_JPRB,0.25409E-05_JPRB,0.27489E-05_JPRB,0.28366E-05_JPRB, &
 & 0.28171E-05_JPRB,0.26776E-05_JPRB,0.23303E-05_JPRB,0.12853E-05_JPRB /)  
KA(:, 5,13, 7) = (/ &
 & 0.12246E-05_JPRB,0.23532E-05_JPRB,0.27977E-05_JPRB,0.30556E-05_JPRB,0.31857E-05_JPRB, &
 & 0.32077E-05_JPRB,0.31127E-05_JPRB,0.28260E-05_JPRB,0.15788E-05_JPRB /)  
KA(:, 1, 1, 8) = (/ &
 & 0.43566E-04_JPRB,0.45402E-04_JPRB,0.48829E-04_JPRB,0.50194E-04_JPRB,0.49978E-04_JPRB, &
 & 0.48581E-04_JPRB,0.45902E-04_JPRB,0.40781E-04_JPRB,0.34170E-04_JPRB /)  
KA(:, 2, 1, 8) = (/ &
 & 0.43974E-04_JPRB,0.47415E-04_JPRB,0.52012E-04_JPRB,0.54325E-04_JPRB,0.54921E-04_JPRB, &
 & 0.53975E-04_JPRB,0.51279E-04_JPRB,0.46650E-04_JPRB,0.40945E-04_JPRB /)  
KA(:, 3, 1, 8) = (/ &
 & 0.44333E-04_JPRB,0.49545E-04_JPRB,0.55453E-04_JPRB,0.58909E-04_JPRB,0.60094E-04_JPRB, &
 & 0.59376E-04_JPRB,0.56940E-04_JPRB,0.52843E-04_JPRB,0.48266E-04_JPRB /)  
KA(:, 4, 1, 8) = (/ &
 & 0.44647E-04_JPRB,0.51771E-04_JPRB,0.59155E-04_JPRB,0.63607E-04_JPRB,0.65306E-04_JPRB, &
 & 0.64935E-04_JPRB,0.62961E-04_JPRB,0.59262E-04_JPRB,0.55812E-04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART5',1,ZHOOK_HANDLE)
END SUBROUTINE PART5


SUBROUTINE PART6

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART6',0,ZHOOK_HANDLE)


KA(:, 5, 1, 8) = (/ &
 & 0.44938E-04_JPRB,0.54202E-04_JPRB,0.63063E-04_JPRB,0.68229E-04_JPRB,0.70615E-04_JPRB, &
 & 0.70683E-04_JPRB,0.69315E-04_JPRB,0.65992E-04_JPRB,0.63855E-04_JPRB /)  
KA(:, 1, 2, 8) = (/ &
 & 0.37849E-04_JPRB,0.40606E-04_JPRB,0.43836E-04_JPRB,0.45171E-04_JPRB,0.45318E-04_JPRB, &
 & 0.44251E-04_JPRB,0.41853E-04_JPRB,0.37247E-04_JPRB,0.29303E-04_JPRB /)  
KA(:, 2, 2, 8) = (/ &
 & 0.38202E-04_JPRB,0.42545E-04_JPRB,0.46901E-04_JPRB,0.49156E-04_JPRB,0.50002E-04_JPRB, &
 & 0.49256E-04_JPRB,0.46845E-04_JPRB,0.42755E-04_JPRB,0.35187E-04_JPRB /)  
KA(:, 3, 2, 8) = (/ &
 & 0.38525E-04_JPRB,0.44570E-04_JPRB,0.50219E-04_JPRB,0.53465E-04_JPRB,0.54833E-04_JPRB, &
 & 0.54348E-04_JPRB,0.52176E-04_JPRB,0.48578E-04_JPRB,0.41697E-04_JPRB /)  
KA(:, 4, 2, 8) = (/ &
 & 0.38828E-04_JPRB,0.46787E-04_JPRB,0.53767E-04_JPRB,0.57818E-04_JPRB,0.59705E-04_JPRB, &
 & 0.59611E-04_JPRB,0.57787E-04_JPRB,0.54523E-04_JPRB,0.48350E-04_JPRB /)  
KA(:, 5, 2, 8) = (/ &
 & 0.39076E-04_JPRB,0.49105E-04_JPRB,0.57380E-04_JPRB,0.62144E-04_JPRB,0.64743E-04_JPRB, &
 & 0.65049E-04_JPRB,0.63700E-04_JPRB,0.60747E-04_JPRB,0.55348E-04_JPRB /)  
KA(:, 1, 3, 8) = (/ &
 & 0.32392E-04_JPRB,0.35504E-04_JPRB,0.38232E-04_JPRB,0.39483E-04_JPRB,0.39809E-04_JPRB, &
 & 0.39031E-04_JPRB,0.36901E-04_JPRB,0.32585E-04_JPRB,0.23735E-04_JPRB /)  
KA(:, 2, 3, 8) = (/ &
 & 0.32715E-04_JPRB,0.37303E-04_JPRB,0.41039E-04_JPRB,0.43202E-04_JPRB,0.44102E-04_JPRB, &
 & 0.43582E-04_JPRB,0.41484E-04_JPRB,0.37593E-04_JPRB,0.28689E-04_JPRB /)  
KA(:, 3, 3, 8) = (/ &
 & 0.33011E-04_JPRB,0.39216E-04_JPRB,0.44127E-04_JPRB,0.47180E-04_JPRB,0.48515E-04_JPRB, &
 & 0.48269E-04_JPRB,0.46352E-04_JPRB,0.42866E-04_JPRB,0.34062E-04_JPRB /)  
KA(:, 4, 3, 8) = (/ &
 & 0.33271E-04_JPRB,0.41283E-04_JPRB,0.47451E-04_JPRB,0.51158E-04_JPRB,0.53031E-04_JPRB, &
 & 0.53191E-04_JPRB,0.51599E-04_JPRB,0.48489E-04_JPRB,0.40122E-04_JPRB /)  
KA(:, 5, 3, 8) = (/ &
 & 0.33495E-04_JPRB,0.43439E-04_JPRB,0.50779E-04_JPRB,0.55143E-04_JPRB,0.57687E-04_JPRB, &
 & 0.58208E-04_JPRB,0.56935E-04_JPRB,0.54138E-04_JPRB,0.46109E-04_JPRB /)  
KA(:, 1, 4, 8) = (/ &
 & 0.27415E-04_JPRB,0.30543E-04_JPRB,0.32764E-04_JPRB,0.33940E-04_JPRB,0.34340E-04_JPRB, &
 & 0.33775E-04_JPRB,0.31812E-04_JPRB,0.27722E-04_JPRB,0.18770E-04_JPRB /)  
KA(:, 2, 4, 8) = (/ &
 & 0.27715E-04_JPRB,0.32169E-04_JPRB,0.35304E-04_JPRB,0.37332E-04_JPRB,0.38224E-04_JPRB, &
 & 0.37868E-04_JPRB,0.35986E-04_JPRB,0.32265E-04_JPRB,0.22928E-04_JPRB /)  
KA(:, 3, 4, 8) = (/ &
 & 0.27982E-04_JPRB,0.33932E-04_JPRB,0.38141E-04_JPRB,0.40925E-04_JPRB,0.42223E-04_JPRB, &
 & 0.42122E-04_JPRB,0.40409E-04_JPRB,0.37026E-04_JPRB,0.27474E-04_JPRB /)  
KA(:, 4, 4, 8) = (/ &
 & 0.28215E-04_JPRB,0.35808E-04_JPRB,0.41184E-04_JPRB,0.44532E-04_JPRB,0.46320E-04_JPRB, &
 & 0.46554E-04_JPRB,0.45091E-04_JPRB,0.41998E-04_JPRB,0.32462E-04_JPRB /)  
KA(:, 5, 4, 8) = (/ &
 & 0.28437E-04_JPRB,0.37809E-04_JPRB,0.44202E-04_JPRB,0.48199E-04_JPRB,0.50577E-04_JPRB, &
 & 0.51211E-04_JPRB,0.50186E-04_JPRB,0.47427E-04_JPRB,0.38088E-04_JPRB /)  
KA(:, 1, 5, 8) = (/ &
 & 0.23010E-04_JPRB,0.25978E-04_JPRB,0.27838E-04_JPRB,0.28899E-04_JPRB,0.29286E-04_JPRB, &
 & 0.28721E-04_JPRB,0.26945E-04_JPRB,0.23196E-04_JPRB,0.14687E-04_JPRB /)  
KA(:, 2, 5, 8) = (/ &
 & 0.23283E-04_JPRB,0.27434E-04_JPRB,0.30115E-04_JPRB,0.31931E-04_JPRB,0.32743E-04_JPRB, &
 & 0.32398E-04_JPRB,0.30674E-04_JPRB,0.27269E-04_JPRB,0.18140E-04_JPRB /)  
KA(:, 3, 5, 8) = (/ &
 & 0.23522E-04_JPRB,0.29002E-04_JPRB,0.32686E-04_JPRB,0.35125E-04_JPRB,0.36325E-04_JPRB, &
 & 0.36232E-04_JPRB,0.34626E-04_JPRB,0.31511E-04_JPRB,0.21987E-04_JPRB /)  
KA(:, 4, 5, 8) = (/ &
 & 0.23738E-04_JPRB,0.30687E-04_JPRB,0.35404E-04_JPRB,0.38366E-04_JPRB,0.40013E-04_JPRB, &
 & 0.40198E-04_JPRB,0.38830E-04_JPRB,0.35973E-04_JPRB,0.26236E-04_JPRB /)  
KA(:, 5, 5, 8) = (/ &
 & 0.23936E-04_JPRB,0.32534E-04_JPRB,0.38093E-04_JPRB,0.41748E-04_JPRB,0.43875E-04_JPRB, &
 & 0.44440E-04_JPRB,0.43519E-04_JPRB,0.40954E-04_JPRB,0.31086E-04_JPRB /)  
KA(:, 1, 6, 8) = (/ &
 & 0.19172E-04_JPRB,0.21867E-04_JPRB,0.23409E-04_JPRB,0.24321E-04_JPRB,0.24529E-04_JPRB, &
 & 0.23927E-04_JPRB,0.22333E-04_JPRB,0.18955E-04_JPRB,0.11218E-04_JPRB /)  
KA(:, 2, 6, 8) = (/ &
 & 0.19419E-04_JPRB,0.23150E-04_JPRB,0.25412E-04_JPRB,0.26974E-04_JPRB,0.27574E-04_JPRB, &
 & 0.27129E-04_JPRB,0.25625E-04_JPRB,0.22590E-04_JPRB,0.14082E-04_JPRB /)  
KA(:, 3, 6, 8) = (/ &
 & 0.19636E-04_JPRB,0.24533E-04_JPRB,0.27708E-04_JPRB,0.29785E-04_JPRB,0.30733E-04_JPRB, &
 & 0.30517E-04_JPRB,0.29114E-04_JPRB,0.26329E-04_JPRB,0.17293E-04_JPRB /)  
KA(:, 4, 6, 8) = (/ &
 & 0.19836E-04_JPRB,0.26054E-04_JPRB,0.30093E-04_JPRB,0.32660E-04_JPRB,0.34002E-04_JPRB, &
 & 0.34049E-04_JPRB,0.32819E-04_JPRB,0.30271E-04_JPRB,0.20869E-04_JPRB /)  
KA(:, 5, 6, 8) = (/ &
 & 0.20002E-04_JPRB,0.27734E-04_JPRB,0.32461E-04_JPRB,0.35638E-04_JPRB,0.37355E-04_JPRB, &
 & 0.37686E-04_JPRB,0.36788E-04_JPRB,0.34519E-04_JPRB,0.24769E-04_JPRB /)  
KA(:, 1, 7, 8) = (/ &
 & 0.15886E-04_JPRB,0.18280E-04_JPRB,0.19557E-04_JPRB,0.20235E-04_JPRB,0.20297E-04_JPRB, &
 & 0.19642E-04_JPRB,0.18202E-04_JPRB,0.15130E-04_JPRB,0.84335E-05_JPRB /)  
KA(:, 2, 7, 8) = (/ &
 & 0.16105E-04_JPRB,0.19408E-04_JPRB,0.21322E-04_JPRB,0.22532E-04_JPRB,0.22888E-04_JPRB, &
 & 0.22409E-04_JPRB,0.21064E-04_JPRB,0.18396E-04_JPRB,0.10766E-04_JPRB /)  
KA(:, 3, 7, 8) = (/ &
 & 0.16304E-04_JPRB,0.20629E-04_JPRB,0.23329E-04_JPRB,0.24999E-04_JPRB,0.25612E-04_JPRB, &
 & 0.25350E-04_JPRB,0.24115E-04_JPRB,0.21685E-04_JPRB,0.13408E-04_JPRB /)  
KA(:, 4, 7, 8) = (/ &
 & 0.16482E-04_JPRB,0.21985E-04_JPRB,0.25409E-04_JPRB,0.27506E-04_JPRB,0.28475E-04_JPRB, &
 & 0.28447E-04_JPRB,0.27347E-04_JPRB,0.25116E-04_JPRB,0.16377E-04_JPRB /)  
KA(:, 5, 7, 8) = (/ &
 & 0.16621E-04_JPRB,0.23483E-04_JPRB,0.27507E-04_JPRB,0.30111E-04_JPRB,0.31449E-04_JPRB, &
 & 0.31651E-04_JPRB,0.30823E-04_JPRB,0.28853E-04_JPRB,0.19647E-04_JPRB /)  
KA(:, 1, 8, 8) = (/ &
 & 0.13104E-04_JPRB,0.15202E-04_JPRB,0.16227E-04_JPRB,0.16675E-04_JPRB,0.16618E-04_JPRB, &
 & 0.15949E-04_JPRB,0.14642E-04_JPRB,0.11862E-04_JPRB,0.62741E-05_JPRB /)  
KA(:, 2, 8, 8) = (/ &
 & 0.13296E-04_JPRB,0.16183E-04_JPRB,0.17762E-04_JPRB,0.18645E-04_JPRB,0.18799E-04_JPRB, &
 & 0.18302E-04_JPRB,0.17108E-04_JPRB,0.14749E-04_JPRB,0.81431E-05_JPRB /)  
KA(:, 3, 8, 8) = (/ &
 & 0.13475E-04_JPRB,0.17250E-04_JPRB,0.19501E-04_JPRB,0.20748E-04_JPRB,0.21144E-04_JPRB, &
 & 0.20825E-04_JPRB,0.19726E-04_JPRB,0.17623E-04_JPRB,0.10291E-04_JPRB /)  
KA(:, 4, 8, 8) = (/ &
 & 0.13631E-04_JPRB,0.18462E-04_JPRB,0.21319E-04_JPRB,0.22916E-04_JPRB,0.23622E-04_JPRB, &
 & 0.23509E-04_JPRB,0.22509E-04_JPRB,0.20604E-04_JPRB,0.12727E-04_JPRB /)  
KA(:, 5, 8, 8) = (/ &
 & 0.13752E-04_JPRB,0.19773E-04_JPRB,0.23162E-04_JPRB,0.25182E-04_JPRB,0.26210E-04_JPRB, &
 & 0.26298E-04_JPRB,0.25526E-04_JPRB,0.23837E-04_JPRB,0.15433E-04_JPRB /)  
KA(:, 1, 9, 8) = (/ &
 & 0.10771E-04_JPRB,0.12580E-04_JPRB,0.13349E-04_JPRB,0.13617E-04_JPRB,0.13459E-04_JPRB, &
 & 0.12816E-04_JPRB,0.11635E-04_JPRB,0.90636E-05_JPRB,0.45849E-05_JPRB /)  
KA(:, 2, 9, 8) = (/ &
 & 0.10937E-04_JPRB,0.13431E-04_JPRB,0.14667E-04_JPRB,0.15270E-04_JPRB,0.15289E-04_JPRB, &
 & 0.14786E-04_JPRB,0.13720E-04_JPRB,0.11614E-04_JPRB,0.60707E-05_JPRB /)  
KA(:, 3, 9, 8) = (/ &
 & 0.11095E-04_JPRB,0.14367E-04_JPRB,0.16153E-04_JPRB,0.17055E-04_JPRB,0.17287E-04_JPRB, &
 & 0.16925E-04_JPRB,0.15948E-04_JPRB,0.14098E-04_JPRB,0.78037E-05_JPRB /)  
KA(:, 4, 9, 8) = (/ &
 & 0.11230E-04_JPRB,0.15436E-04_JPRB,0.17715E-04_JPRB,0.18921E-04_JPRB,0.19404E-04_JPRB, &
 & 0.19208E-04_JPRB,0.18318E-04_JPRB,0.16668E-04_JPRB,0.97810E-05_JPRB /)  
KA(:, 5, 9, 8) = (/ &
 & 0.11337E-04_JPRB,0.16572E-04_JPRB,0.19310E-04_JPRB,0.20882E-04_JPRB,0.21623E-04_JPRB, &
 & 0.21621E-04_JPRB,0.20902E-04_JPRB,0.19439E-04_JPRB,0.11994E-04_JPRB /)  
KA(:, 1,10, 8) = (/ &
 & 0.88397E-05_JPRB,0.10407E-04_JPRB,0.10992E-04_JPRB,0.11130E-04_JPRB,0.10914E-04_JPRB, &
 & 0.10319E-04_JPRB,0.92746E-05_JPRB,0.69230E-05_JPRB,0.33878E-05_JPRB /)  
KA(:, 2,10, 8) = (/ &
 & 0.89820E-05_JPRB,0.11148E-04_JPRB,0.12114E-04_JPRB,0.12509E-04_JPRB,0.12455E-04_JPRB, &
 & 0.11973E-04_JPRB,0.11026E-04_JPRB,0.91303E-05_JPRB,0.45777E-05_JPRB /)  
KA(:, 3,10, 8) = (/ &
 & 0.91201E-05_JPRB,0.11975E-04_JPRB,0.13369E-04_JPRB,0.14032E-04_JPRB,0.14150E-04_JPRB, &
 & 0.13774E-04_JPRB,0.12899E-04_JPRB,0.11289E-04_JPRB,0.59718E-05_JPRB /)  
KA(:, 4,10, 8) = (/ &
 & 0.92338E-05_JPRB,0.12910E-04_JPRB,0.14708E-04_JPRB,0.15633E-04_JPRB,0.15947E-04_JPRB, &
 & 0.15711E-04_JPRB,0.14916E-04_JPRB,0.13483E-04_JPRB,0.75778E-05_JPRB /)  
KA(:, 5,10, 8) = (/ &
 & 0.93270E-05_JPRB,0.13899E-04_JPRB,0.16089E-04_JPRB,0.17313E-04_JPRB,0.17838E-04_JPRB, &
 & 0.17779E-04_JPRB,0.17126E-04_JPRB,0.15852E-04_JPRB,0.93849E-05_JPRB /)  
KA(:, 1,11, 8) = (/ &
 & 0.72957E-05_JPRB,0.88518E-05_JPRB,0.94180E-05_JPRB,0.95477E-05_JPRB,0.93627E-05_JPRB, &
 & 0.88681E-05_JPRB,0.79846E-05_JPRB,0.60665E-05_JPRB,0.28938E-05_JPRB /)  
KA(:, 2,11, 8) = (/ &
 & 0.74164E-05_JPRB,0.95244E-05_JPRB,0.10413E-04_JPRB,0.10760E-04_JPRB,0.10725E-04_JPRB, &
 & 0.10300E-04_JPRB,0.94914E-05_JPRB,0.79265E-05_JPRB,0.39145E-05_JPRB /)  
KA(:, 3,11, 8) = (/ &
 & 0.75267E-05_JPRB,0.10290E-04_JPRB,0.11516E-04_JPRB,0.12091E-04_JPRB,0.12186E-04_JPRB, &
 & 0.11866E-04_JPRB,0.11116E-04_JPRB,0.97843E-05_JPRB,0.51152E-05_JPRB /)  
KA(:, 4,11, 8) = (/ &
 & 0.76165E-05_JPRB,0.11127E-04_JPRB,0.12682E-04_JPRB,0.13483E-04_JPRB,0.13746E-04_JPRB, &
 & 0.13546E-04_JPRB,0.12885E-04_JPRB,0.11704E-04_JPRB,0.64876E-05_JPRB /)  
KA(:, 5,11, 8) = (/ &
 & 0.76866E-05_JPRB,0.11972E-04_JPRB,0.13896E-04_JPRB,0.14938E-04_JPRB,0.15405E-04_JPRB, &
 & 0.15374E-04_JPRB,0.14838E-04_JPRB,0.13790E-04_JPRB,0.80319E-05_JPRB /)  
KA(:, 1,12, 8) = (/ &
 & 0.60137E-05_JPRB,0.75193E-05_JPRB,0.80348E-05_JPRB,0.81538E-05_JPRB,0.80064E-05_JPRB, &
 & 0.75822E-05_JPRB,0.68354E-05_JPRB,0.52502E-05_JPRB,0.24674E-05_JPRB /)  
KA(:, 2,12, 8) = (/ &
 & 0.61150E-05_JPRB,0.81325E-05_JPRB,0.89089E-05_JPRB,0.92208E-05_JPRB,0.91831E-05_JPRB, &
 & 0.88171E-05_JPRB,0.81283E-05_JPRB,0.68396E-05_JPRB,0.33429E-05_JPRB /)  
KA(:, 3,12, 8) = (/ &
 & 0.62020E-05_JPRB,0.88113E-05_JPRB,0.98818E-05_JPRB,0.10369E-04_JPRB,0.10440E-04_JPRB, &
 & 0.10164E-04_JPRB,0.95355E-05_JPRB,0.84372E-05_JPRB,0.43683E-05_JPRB /)  
KA(:, 4,12, 8) = (/ &
 & 0.62729E-05_JPRB,0.95382E-05_JPRB,0.10890E-04_JPRB,0.11569E-04_JPRB,0.11793E-04_JPRB, &
 & 0.11630E-04_JPRB,0.11082E-04_JPRB,0.10108E-04_JPRB,0.55358E-05_JPRB /)  
KA(:, 5,12, 8) = (/ &
 & 0.63199E-05_JPRB,0.10271E-04_JPRB,0.11934E-04_JPRB,0.12838E-04_JPRB,0.13254E-04_JPRB, &
 & 0.13231E-04_JPRB,0.12796E-04_JPRB,0.11934E-04_JPRB,0.68492E-05_JPRB /)  
KA(:, 1,13, 8) = (/ &
 & 0.49517E-05_JPRB,0.63774E-05_JPRB,0.68261E-05_JPRB,0.69411E-05_JPRB,0.68151E-05_JPRB, &
 & 0.64513E-05_JPRB,0.58220E-05_JPRB,0.45056E-05_JPRB,0.20980E-05_JPRB /)  
KA(:, 2,13, 8) = (/ &
 & 0.50331E-05_JPRB,0.69207E-05_JPRB,0.75990E-05_JPRB,0.78660E-05_JPRB,0.78231E-05_JPRB, &
 & 0.75119E-05_JPRB,0.69333E-05_JPRB,0.58688E-05_JPRB,0.28426E-05_JPRB /)  
KA(:, 3,13, 8) = (/ &
 & 0.51036E-05_JPRB,0.75155E-05_JPRB,0.84393E-05_JPRB,0.88490E-05_JPRB,0.89047E-05_JPRB, &
 & 0.86720E-05_JPRB,0.81449E-05_JPRB,0.72410E-05_JPRB,0.37114E-05_JPRB /)  
KA(:, 4,13, 8) = (/ &
 & 0.51548E-05_JPRB,0.81445E-05_JPRB,0.93105E-05_JPRB,0.98793E-05_JPRB,0.10078E-04_JPRB, &
 & 0.99535E-05_JPRB,0.94951E-05_JPRB,0.86973E-05_JPRB,0.47002E-05_JPRB /)  
KA(:, 5,13, 8) = (/ &
 & 0.51867E-05_JPRB,0.87857E-05_JPRB,0.10211E-04_JPRB,0.10992E-04_JPRB,0.11352E-04_JPRB, &
 & 0.11351E-04_JPRB,0.10990E-04_JPRB,0.10277E-04_JPRB,0.58153E-05_JPRB /)  
KA(:, 1, 1, 9) = (/ &
 & 0.18292E-03_JPRB,0.16357E-03_JPRB,0.15341E-03_JPRB,0.14585E-03_JPRB,0.13797E-03_JPRB, &
 & 0.12826E-03_JPRB,0.11477E-03_JPRB,0.99322E-04_JPRB,0.99311E-04_JPRB /)  
KA(:, 2, 1, 9) = (/ &
 & 0.18277E-03_JPRB,0.16502E-03_JPRB,0.15805E-03_JPRB,0.15290E-03_JPRB,0.14696E-03_JPRB, &
 & 0.13850E-03_JPRB,0.12664E-03_JPRB,0.11419E-03_JPRB,0.11887E-03_JPRB /)  
KA(:, 3, 1, 9) = (/ &
 & 0.18261E-03_JPRB,0.16694E-03_JPRB,0.16322E-03_JPRB,0.16061E-03_JPRB,0.15658E-03_JPRB, &
 & 0.14997E-03_JPRB,0.14010E-03_JPRB,0.13154E-03_JPRB,0.14123E-03_JPRB /)  
KA(:, 4, 1, 9) = (/ &
 & 0.18244E-03_JPRB,0.16952E-03_JPRB,0.16897E-03_JPRB,0.16909E-03_JPRB,0.16740E-03_JPRB, &
 & 0.16268E-03_JPRB,0.15556E-03_JPRB,0.15163E-03_JPRB,0.16610E-03_JPRB /)  
KA(:, 5, 1, 9) = (/ &
 & 0.18218E-03_JPRB,0.17247E-03_JPRB,0.17521E-03_JPRB,0.17844E-03_JPRB,0.17911E-03_JPRB, &
 & 0.17696E-03_JPRB,0.17241E-03_JPRB,0.17370E-03_JPRB,0.19290E-03_JPRB /)  
KA(:, 1, 2, 9) = (/ &
 & 0.17473E-03_JPRB,0.15735E-03_JPRB,0.14910E-03_JPRB,0.14227E-03_JPRB,0.13471E-03_JPRB, &
 & 0.12515E-03_JPRB,0.11200E-03_JPRB,0.94986E-04_JPRB,0.89520E-04_JPRB /)  
KA(:, 2, 2, 9) = (/ &
 & 0.17467E-03_JPRB,0.15907E-03_JPRB,0.15401E-03_JPRB,0.14953E-03_JPRB,0.14402E-03_JPRB, &
 & 0.13581E-03_JPRB,0.12401E-03_JPRB,0.10893E-03_JPRB,0.10811E-03_JPRB /)  
KA(:, 3, 2, 9) = (/ &
 & 0.17463E-03_JPRB,0.16142E-03_JPRB,0.15942E-03_JPRB,0.15773E-03_JPRB,0.15417E-03_JPRB, &
 & 0.14769E-03_JPRB,0.13747E-03_JPRB,0.12528E-03_JPRB,0.12924E-03_JPRB /)  
KA(:, 4, 2, 9) = (/ &
 & 0.17449E-03_JPRB,0.16426E-03_JPRB,0.16549E-03_JPRB,0.16671E-03_JPRB,0.16541E-03_JPRB, &
 & 0.16085E-03_JPRB,0.15263E-03_JPRB,0.14389E-03_JPRB,0.15270E-03_JPRB /)  
KA(:, 5, 2, 9) = (/ &
 & 0.17439E-03_JPRB,0.16753E-03_JPRB,0.17238E-03_JPRB,0.17658E-03_JPRB,0.17759E-03_JPRB, &
 & 0.17537E-03_JPRB,0.16910E-03_JPRB,0.16442E-03_JPRB,0.17796E-03_JPRB /)  
KA(:, 1, 3, 9) = (/ &
 & 0.16429E-03_JPRB,0.14895E-03_JPRB,0.14201E-03_JPRB,0.13557E-03_JPRB,0.12797E-03_JPRB, &
 & 0.11829E-03_JPRB,0.10548E-03_JPRB,0.88188E-04_JPRB,0.77280E-04_JPRB /)  
KA(:, 2, 3, 9) = (/ &
 & 0.16436E-03_JPRB,0.15092E-03_JPRB,0.14708E-03_JPRB,0.14277E-03_JPRB,0.13731E-03_JPRB, &
 & 0.12899E-03_JPRB,0.11719E-03_JPRB,0.10108E-03_JPRB,0.94071E-04_JPRB /)  
KA(:, 3, 3, 9) = (/ &
 & 0.16438E-03_JPRB,0.15344E-03_JPRB,0.15259E-03_JPRB,0.15105E-03_JPRB,0.14760E-03_JPRB, &
 & 0.14078E-03_JPRB,0.13037E-03_JPRB,0.11602E-03_JPRB,0.11331E-03_JPRB /)  
KA(:, 4, 3, 9) = (/ &
 & 0.16440E-03_JPRB,0.15651E-03_JPRB,0.15877E-03_JPRB,0.16021E-03_JPRB,0.15883E-03_JPRB, &
 & 0.15394E-03_JPRB,0.14519E-03_JPRB,0.13303E-03_JPRB,0.13463E-03_JPRB /)  
KA(:, 5, 3, 9) = (/ &
 & 0.16444E-03_JPRB,0.16001E-03_JPRB,0.16595E-03_JPRB,0.17023E-03_JPRB,0.17105E-03_JPRB, &
 & 0.16855E-03_JPRB,0.16116E-03_JPRB,0.15159E-03_JPRB,0.15764E-03_JPRB /)  
KA(:, 1, 4, 9) = (/ &
 & 0.15195E-03_JPRB,0.13883E-03_JPRB,0.13294E-03_JPRB,0.12699E-03_JPRB,0.11928E-03_JPRB, &
 & 0.10948E-03_JPRB,0.97355E-04_JPRB,0.80985E-04_JPRB,0.65303E-04_JPRB /)  
KA(:, 2, 4, 9) = (/ &
 & 0.15212E-03_JPRB,0.14097E-03_JPRB,0.13802E-03_JPRB,0.13404E-03_JPRB,0.12836E-03_JPRB, &
 & 0.11996E-03_JPRB,0.10855E-03_JPRB,0.92884E-04_JPRB,0.80285E-04_JPRB /)  
KA(:, 3, 4, 9) = (/ &
 & 0.15229E-03_JPRB,0.14364E-03_JPRB,0.14356E-03_JPRB,0.14222E-03_JPRB,0.13844E-03_JPRB, &
 & 0.13147E-03_JPRB,0.12124E-03_JPRB,0.10661E-03_JPRB,0.97473E-04_JPRB /)  
KA(:, 4, 4, 9) = (/ &
 & 0.15247E-03_JPRB,0.14694E-03_JPRB,0.14987E-03_JPRB,0.15132E-03_JPRB,0.14947E-03_JPRB, &
 & 0.14428E-03_JPRB,0.13562E-03_JPRB,0.12218E-03_JPRB,0.11647E-03_JPRB /)  
KA(:, 5, 4, 9) = (/ &
 & 0.15268E-03_JPRB,0.15064E-03_JPRB,0.15719E-03_JPRB,0.16126E-03_JPRB,0.16162E-03_JPRB, &
 & 0.15869E-03_JPRB,0.15101E-03_JPRB,0.13904E-03_JPRB,0.13733E-03_JPRB /)  
KA(:, 1, 5, 9) = (/ &
 & 0.13846E-03_JPRB,0.12761E-03_JPRB,0.12265E-03_JPRB,0.11713E-03_JPRB,0.10945E-03_JPRB, &
 & 0.10011E-03_JPRB,0.88713E-04_JPRB,0.73647E-04_JPRB,0.54834E-04_JPRB /)  
KA(:, 2, 5, 9) = (/ &
 & 0.13872E-03_JPRB,0.12987E-03_JPRB,0.12766E-03_JPRB,0.12392E-03_JPRB,0.11814E-03_JPRB, &
 & 0.11013E-03_JPRB,0.99375E-04_JPRB,0.84759E-04_JPRB,0.68007E-04_JPRB /)  
KA(:, 3, 5, 9) = (/ &
 & 0.13899E-03_JPRB,0.13272E-03_JPRB,0.13319E-03_JPRB,0.13187E-03_JPRB,0.12795E-03_JPRB, &
 & 0.12108E-03_JPRB,0.11145E-03_JPRB,0.97499E-04_JPRB,0.83096E-04_JPRB /)  
KA(:, 4, 5, 9) = (/ &
 & 0.13930E-03_JPRB,0.13617E-03_JPRB,0.13955E-03_JPRB,0.14081E-03_JPRB,0.13862E-03_JPRB, &
 & 0.13340E-03_JPRB,0.12522E-03_JPRB,0.11183E-03_JPRB,0.99891E-04_JPRB /)  
KA(:, 5, 5, 9) = (/ &
 & 0.13961E-03_JPRB,0.13997E-03_JPRB,0.14692E-03_JPRB,0.15049E-03_JPRB,0.15045E-03_JPRB, &
 & 0.14736E-03_JPRB,0.14024E-03_JPRB,0.12733E-03_JPRB,0.11865E-03_JPRB /)  
KA(:, 1, 6, 9) = (/ &
 & 0.12419E-03_JPRB,0.11551E-03_JPRB,0.11132E-03_JPRB,0.10604E-03_JPRB,0.98912E-04_JPRB, &
 & 0.90174E-04_JPRB,0.79553E-04_JPRB,0.65781E-04_JPRB,0.45228E-04_JPRB /)  
KA(:, 2, 6, 9) = (/ &
 & 0.12454E-03_JPRB,0.11786E-03_JPRB,0.11619E-03_JPRB,0.11259E-03_JPRB,0.10704E-03_JPRB, &
 & 0.99552E-04_JPRB,0.89546E-04_JPRB,0.76061E-04_JPRB,0.56748E-04_JPRB /)  
KA(:, 3, 6, 9) = (/ &
 & 0.12490E-03_JPRB,0.12081E-03_JPRB,0.12161E-03_JPRB,0.12024E-03_JPRB,0.11632E-03_JPRB, &
 & 0.10988E-03_JPRB,0.10081E-03_JPRB,0.87950E-04_JPRB,0.69901E-04_JPRB /)  
KA(:, 4, 6, 9) = (/ &
 & 0.12528E-03_JPRB,0.12425E-03_JPRB,0.12796E-03_JPRB,0.12887E-03_JPRB,0.12649E-03_JPRB, &
 & 0.12150E-03_JPRB,0.11381E-03_JPRB,0.10130E-03_JPRB,0.84575E-04_JPRB /)  
KA(:, 5, 6, 9) = (/ &
 & 0.12568E-03_JPRB,0.12811E-03_JPRB,0.13519E-03_JPRB,0.13816E-03_JPRB,0.13780E-03_JPRB, &
 & 0.13476E-03_JPRB,0.12819E-03_JPRB,0.11553E-03_JPRB,0.10091E-03_JPRB /)  
KA(:, 1, 7, 9) = (/ &
 & 0.10978E-03_JPRB,0.10308E-03_JPRB,0.99508E-04_JPRB,0.94571E-04_JPRB,0.88120E-04_JPRB, &
 & 0.80226E-04_JPRB,0.70492E-04_JPRB,0.57993E-04_JPRB,0.36699E-04_JPRB /)  
KA(:, 2, 7, 9) = (/ &
 & 0.11018E-03_JPRB,0.10544E-03_JPRB,0.10415E-03_JPRB,0.10080E-03_JPRB,0.95769E-04_JPRB, &
 & 0.88865E-04_JPRB,0.79698E-04_JPRB,0.67450E-04_JPRB,0.46683E-04_JPRB /)  
KA(:, 3, 7, 9) = (/ &
 & 0.11058E-03_JPRB,0.10837E-03_JPRB,0.10936E-03_JPRB,0.10807E-03_JPRB,0.10453E-03_JPRB, &
 & 0.98497E-04_JPRB,0.90104E-04_JPRB,0.78443E-04_JPRB,0.58212E-04_JPRB /)  
KA(:, 4, 7, 9) = (/ &
 & 0.11104E-03_JPRB,0.11179E-03_JPRB,0.11551E-03_JPRB,0.11629E-03_JPRB,0.11409E-03_JPRB, &
 & 0.10934E-03_JPRB,0.10217E-03_JPRB,0.90913E-04_JPRB,0.71131E-04_JPRB /)  
KA(:, 5, 7, 9) = (/ &
 & 0.11149E-03_JPRB,0.11560E-03_JPRB,0.12257E-03_JPRB,0.12521E-03_JPRB,0.12472E-03_JPRB, &
 & 0.12180E-03_JPRB,0.11572E-03_JPRB,0.10421E-03_JPRB,0.85542E-04_JPRB /)  
KA(:, 1, 8, 9) = (/ &
 & 0.95759E-04_JPRB,0.90773E-04_JPRB,0.87806E-04_JPRB,0.83290E-04_JPRB,0.77515E-04_JPRB, &
 & 0.70528E-04_JPRB,0.61795E-04_JPRB,0.50465E-04_JPRB,0.29380E-04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART6',1,ZHOOK_HANDLE)
END SUBROUTINE PART6


SUBROUTINE PART7

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART7',0,ZHOOK_HANDLE)


KA(:, 2, 8, 9) = (/ &
 & 0.96189E-04_JPRB,0.93120E-04_JPRB,0.92132E-04_JPRB,0.89103E-04_JPRB,0.84653E-04_JPRB, &
 & 0.78456E-04_JPRB,0.70159E-04_JPRB,0.59177E-04_JPRB,0.37867E-04_JPRB /)  
KA(:, 3, 8, 9) = (/ &
 & 0.96665E-04_JPRB,0.96018E-04_JPRB,0.97008E-04_JPRB,0.95975E-04_JPRB,0.92760E-04_JPRB, &
 & 0.87379E-04_JPRB,0.79687E-04_JPRB,0.69248E-04_JPRB,0.47855E-04_JPRB /)  
KA(:, 4, 8, 9) = (/ &
 & 0.97168E-04_JPRB,0.99322E-04_JPRB,0.10289E-03_JPRB,0.10373E-03_JPRB,0.10169E-03_JPRB, &
 & 0.97397E-04_JPRB,0.90796E-04_JPRB,0.80805E-04_JPRB,0.59240E-04_JPRB /)  
KA(:, 5, 8, 9) = (/ &
 & 0.97641E-04_JPRB,0.10302E-03_JPRB,0.10967E-03_JPRB,0.11218E-03_JPRB,0.11166E-03_JPRB, &
 & 0.10896E-03_JPRB,0.10343E-03_JPRB,0.93210E-04_JPRB,0.71998E-04_JPRB /)  
KA(:, 1, 9, 9) = (/ &
 & 0.82482E-04_JPRB,0.78941E-04_JPRB,0.76398E-04_JPRB,0.72429E-04_JPRB,0.67369E-04_JPRB, &
 & 0.61188E-04_JPRB,0.53486E-04_JPRB,0.43219E-04_JPRB,0.23144E-04_JPRB /)  
KA(:, 2, 9, 9) = (/ &
 & 0.82941E-04_JPRB,0.81194E-04_JPRB,0.80391E-04_JPRB,0.77783E-04_JPRB,0.73924E-04_JPRB, &
 & 0.68383E-04_JPRB,0.61055E-04_JPRB,0.51145E-04_JPRB,0.30235E-04_JPRB /)  
KA(:, 3, 9, 9) = (/ &
 & 0.83462E-04_JPRB,0.83998E-04_JPRB,0.84977E-04_JPRB,0.84161E-04_JPRB,0.81323E-04_JPRB, &
 & 0.76538E-04_JPRB,0.69739E-04_JPRB,0.60350E-04_JPRB,0.38714E-04_JPRB /)  
KA(:, 4, 9, 9) = (/ &
 & 0.83976E-04_JPRB,0.87153E-04_JPRB,0.90583E-04_JPRB,0.91413E-04_JPRB,0.89589E-04_JPRB, &
 & 0.85741E-04_JPRB,0.79900E-04_JPRB,0.70947E-04_JPRB,0.48553E-04_JPRB /)  
KA(:, 5, 9, 9) = (/ &
 & 0.84461E-04_JPRB,0.90734E-04_JPRB,0.96938E-04_JPRB,0.99296E-04_JPRB,0.98864E-04_JPRB, &
 & 0.96399E-04_JPRB,0.91511E-04_JPRB,0.82490E-04_JPRB,0.59777E-04_JPRB /)  
KA(:, 1,10, 9) = (/ &
 & 0.70371E-04_JPRB,0.68110E-04_JPRB,0.65986E-04_JPRB,0.62636E-04_JPRB,0.58303E-04_JPRB, &
 & 0.52961E-04_JPRB,0.46122E-04_JPRB,0.37036E-04_JPRB,0.18341E-04_JPRB /)  
KA(:, 2,10, 9) = (/ &
 & 0.70853E-04_JPRB,0.70288E-04_JPRB,0.69669E-04_JPRB,0.67543E-04_JPRB,0.64271E-04_JPRB, &
 & 0.59496E-04_JPRB,0.53052E-04_JPRB,0.44224E-04_JPRB,0.24306E-04_JPRB /)  
KA(:, 3,10, 9) = (/ &
 & 0.71373E-04_JPRB,0.72956E-04_JPRB,0.74034E-04_JPRB,0.73423E-04_JPRB,0.71076E-04_JPRB, &
 & 0.66934E-04_JPRB,0.61048E-04_JPRB,0.52623E-04_JPRB,0.31537E-04_JPRB /)  
KA(:, 4,10, 9) = (/ &
 & 0.71862E-04_JPRB,0.75946E-04_JPRB,0.79283E-04_JPRB,0.80149E-04_JPRB,0.78712E-04_JPRB, &
 & 0.75412E-04_JPRB,0.70399E-04_JPRB,0.62323E-04_JPRB,0.40041E-04_JPRB /)  
KA(:, 5,10, 9) = (/ &
 & 0.72376E-04_JPRB,0.79405E-04_JPRB,0.85220E-04_JPRB,0.87544E-04_JPRB,0.87332E-04_JPRB, &
 & 0.85268E-04_JPRB,0.81104E-04_JPRB,0.73085E-04_JPRB,0.49845E-04_JPRB /)  
KA(:, 1,11, 9) = (/ &
 & 0.59776E-04_JPRB,0.59155E-04_JPRB,0.57996E-04_JPRB,0.55642E-04_JPRB,0.52323E-04_JPRB, &
 & 0.47930E-04_JPRB,0.42036E-04_JPRB,0.34179E-04_JPRB,0.16514E-04_JPRB /)  
KA(:, 2,11, 9) = (/ &
 & 0.60275E-04_JPRB,0.61436E-04_JPRB,0.61654E-04_JPRB,0.60490E-04_JPRB,0.58055E-04_JPRB, &
 & 0.54242E-04_JPRB,0.48750E-04_JPRB,0.41144E-04_JPRB,0.21987E-04_JPRB /)  
KA(:, 3,11, 9) = (/ &
 & 0.60746E-04_JPRB,0.64075E-04_JPRB,0.66078E-04_JPRB,0.66233E-04_JPRB,0.64629E-04_JPRB, &
 & 0.61455E-04_JPRB,0.56611E-04_JPRB,0.49290E-04_JPRB,0.28648E-04_JPRB /)  
KA(:, 4,11, 9) = (/ &
 & 0.61244E-04_JPRB,0.67066E-04_JPRB,0.71217E-04_JPRB,0.72696E-04_JPRB,0.72050E-04_JPRB, &
 & 0.69816E-04_JPRB,0.65797E-04_JPRB,0.58590E-04_JPRB,0.36515E-04_JPRB /)  
KA(:, 5,11, 9) = (/ &
 & 0.61769E-04_JPRB,0.70693E-04_JPRB,0.76979E-04_JPRB,0.79872E-04_JPRB,0.80561E-04_JPRB, &
 & 0.79478E-04_JPRB,0.76089E-04_JPRB,0.68898E-04_JPRB,0.45628E-04_JPRB /)  
KA(:, 1,12, 9) = (/ &
 & 0.50518E-04_JPRB,0.51187E-04_JPRB,0.50822E-04_JPRB,0.49284E-04_JPRB,0.46769E-04_JPRB, &
 & 0.43097E-04_JPRB,0.38110E-04_JPRB,0.31379E-04_JPRB,0.14783E-04_JPRB /)  
KA(:, 2,12, 9) = (/ &
 & 0.50964E-04_JPRB,0.53463E-04_JPRB,0.54457E-04_JPRB,0.54020E-04_JPRB,0.52266E-04_JPRB, &
 & 0.49174E-04_JPRB,0.44595E-04_JPRB,0.38042E-04_JPRB,0.19796E-04_JPRB /)  
KA(:, 3,12, 9) = (/ &
 & 0.51421E-04_JPRB,0.56033E-04_JPRB,0.58762E-04_JPRB,0.59481E-04_JPRB,0.58578E-04_JPRB, &
 & 0.56207E-04_JPRB,0.52260E-04_JPRB,0.45820E-04_JPRB,0.25919E-04_JPRB /)  
KA(:, 4,12, 9) = (/ &
 & 0.51920E-04_JPRB,0.59121E-04_JPRB,0.63731E-04_JPRB,0.65674E-04_JPRB,0.65806E-04_JPRB, &
 & 0.64464E-04_JPRB,0.61120E-04_JPRB,0.54677E-04_JPRB,0.33164E-04_JPRB /)  
KA(:, 5,12, 9) = (/ &
 & 0.52396E-04_JPRB,0.62780E-04_JPRB,0.69274E-04_JPRB,0.72637E-04_JPRB,0.74145E-04_JPRB, &
 & 0.73831E-04_JPRB,0.71039E-04_JPRB,0.64514E-04_JPRB,0.41597E-04_JPRB /)  
KA(:, 1,13, 9) = (/ &
 & 0.42486E-04_JPRB,0.44174E-04_JPRB,0.44463E-04_JPRB,0.43555E-04_JPRB,0.41568E-04_JPRB, &
 & 0.38563E-04_JPRB,0.34384E-04_JPRB,0.28625E-04_JPRB,0.13171E-04_JPRB /)  
KA(:, 2,13, 9) = (/ &
 & 0.42904E-04_JPRB,0.46376E-04_JPRB,0.47979E-04_JPRB,0.48065E-04_JPRB,0.46867E-04_JPRB, &
 & 0.44391E-04_JPRB,0.40615E-04_JPRB,0.34938E-04_JPRB,0.17746E-04_JPRB /)  
KA(:, 3,13, 9) = (/ &
 & 0.43349E-04_JPRB,0.48965E-04_JPRB,0.52137E-04_JPRB,0.53262E-04_JPRB,0.52962E-04_JPRB, &
 & 0.51246E-04_JPRB,0.47996E-04_JPRB,0.42282E-04_JPRB,0.23342E-04_JPRB /)  
KA(:, 4,13, 9) = (/ &
 & 0.43790E-04_JPRB,0.52076E-04_JPRB,0.56889E-04_JPRB,0.59186E-04_JPRB,0.60002E-04_JPRB, &
 & 0.59254E-04_JPRB,0.56460E-04_JPRB,0.50705E-04_JPRB,0.29999E-04_JPRB /)  
KA(:, 5,13, 9) = (/ &
 & 0.44254E-04_JPRB,0.55629E-04_JPRB,0.62209E-04_JPRB,0.65993E-04_JPRB,0.68105E-04_JPRB, &
 & 0.68270E-04_JPRB,0.65941E-04_JPRB,0.60145E-04_JPRB,0.37728E-04_JPRB /)  
KA(:, 1, 1,10) = (/ &
 & 0.42864E-03_JPRB,0.37538E-03_JPRB,0.32907E-03_JPRB,0.29701E-03_JPRB,0.26399E-03_JPRB, &
 & 0.23587E-03_JPRB,0.21519E-03_JPRB,0.20736E-03_JPRB,0.23690E-03_JPRB /)  
KA(:, 2, 1,10) = (/ &
 & 0.42770E-03_JPRB,0.37463E-03_JPRB,0.33468E-03_JPRB,0.30443E-03_JPRB,0.27635E-03_JPRB, &
 & 0.25424E-03_JPRB,0.24068E-03_JPRB,0.24289E-03_JPRB,0.27885E-03_JPRB /)  
KA(:, 3, 1,10) = (/ &
 & 0.42742E-03_JPRB,0.37444E-03_JPRB,0.34109E-03_JPRB,0.31378E-03_JPRB,0.29265E-03_JPRB, &
 & 0.27618E-03_JPRB,0.26729E-03_JPRB,0.27967E-03_JPRB,0.32090E-03_JPRB /)  
KA(:, 4, 1,10) = (/ &
 & 0.42756E-03_JPRB,0.37461E-03_JPRB,0.34714E-03_JPRB,0.32647E-03_JPRB,0.30721E-03_JPRB, &
 & 0.29888E-03_JPRB,0.29503E-03_JPRB,0.31853E-03_JPRB,0.36629E-03_JPRB /)  
KA(:, 5, 1,10) = (/ &
 & 0.42817E-03_JPRB,0.37676E-03_JPRB,0.35506E-03_JPRB,0.34027E-03_JPRB,0.32593E-03_JPRB, &
 & 0.32117E-03_JPRB,0.33159E-03_JPRB,0.36650E-03_JPRB,0.42307E-03_JPRB /)  
KA(:, 1, 2,10) = (/ &
 & 0.44647E-03_JPRB,0.39099E-03_JPRB,0.34399E-03_JPRB,0.31315E-03_JPRB,0.27681E-03_JPRB, &
 & 0.24757E-03_JPRB,0.21977E-03_JPRB,0.20260E-03_JPRB,0.22465E-03_JPRB /)  
KA(:, 2, 2,10) = (/ &
 & 0.44675E-03_JPRB,0.39126E-03_JPRB,0.35094E-03_JPRB,0.32069E-03_JPRB,0.29009E-03_JPRB, &
 & 0.26696E-03_JPRB,0.24338E-03_JPRB,0.23431E-03_JPRB,0.26448E-03_JPRB /)  
KA(:, 3, 2,10) = (/ &
 & 0.44728E-03_JPRB,0.39176E-03_JPRB,0.35848E-03_JPRB,0.33002E-03_JPRB,0.30752E-03_JPRB, &
 & 0.28763E-03_JPRB,0.26835E-03_JPRB,0.26923E-03_JPRB,0.30805E-03_JPRB /)  
KA(:, 4, 2,10) = (/ &
 & 0.44805E-03_JPRB,0.39321E-03_JPRB,0.36547E-03_JPRB,0.34473E-03_JPRB,0.32431E-03_JPRB, &
 & 0.30833E-03_JPRB,0.29659E-03_JPRB,0.31021E-03_JPRB,0.35789E-03_JPRB /)  
KA(:, 5, 2,10) = (/ &
 & 0.44833E-03_JPRB,0.39641E-03_JPRB,0.37373E-03_JPRB,0.35955E-03_JPRB,0.34286E-03_JPRB, &
 & 0.33059E-03_JPRB,0.33253E-03_JPRB,0.36056E-03_JPRB,0.41785E-03_JPRB /)  
KA(:, 1, 3,10) = (/ &
 & 0.45575E-03_JPRB,0.39903E-03_JPRB,0.35239E-03_JPRB,0.32061E-03_JPRB,0.28610E-03_JPRB, &
 & 0.25358E-03_JPRB,0.22160E-03_JPRB,0.19044E-03_JPRB,0.19754E-03_JPRB /)  
KA(:, 2, 3,10) = (/ &
 & 0.45658E-03_JPRB,0.39983E-03_JPRB,0.35980E-03_JPRB,0.32984E-03_JPRB,0.29898E-03_JPRB, &
 & 0.27505E-03_JPRB,0.24328E-03_JPRB,0.21905E-03_JPRB,0.23515E-03_JPRB /)  
KA(:, 3, 3,10) = (/ &
 & 0.45737E-03_JPRB,0.40126E-03_JPRB,0.36866E-03_JPRB,0.34025E-03_JPRB,0.31808E-03_JPRB, &
 & 0.29648E-03_JPRB,0.26565E-03_JPRB,0.25100E-03_JPRB,0.27824E-03_JPRB /)  
KA(:, 4, 3,10) = (/ &
 & 0.45822E-03_JPRB,0.40344E-03_JPRB,0.37727E-03_JPRB,0.35639E-03_JPRB,0.33753E-03_JPRB, &
 & 0.31544E-03_JPRB,0.29107E-03_JPRB,0.29011E-03_JPRB,0.33040E-03_JPRB /)  
KA(:, 5, 3,10) = (/ &
 & 0.45803E-03_JPRB,0.40724E-03_JPRB,0.38685E-03_JPRB,0.37303E-03_JPRB,0.35804E-03_JPRB, &
 & 0.33477E-03_JPRB,0.32542E-03_JPRB,0.34063E-03_JPRB,0.39188E-03_JPRB /)  
KA(:, 1, 4,10) = (/ &
 & 0.45696E-03_JPRB,0.40009E-03_JPRB,0.35533E-03_JPRB,0.32134E-03_JPRB,0.28977E-03_JPRB, &
 & 0.25642E-03_JPRB,0.22005E-03_JPRB,0.17825E-03_JPRB,0.16960E-03_JPRB /)  
KA(:, 2, 4,10) = (/ &
 & 0.45799E-03_JPRB,0.40164E-03_JPRB,0.36303E-03_JPRB,0.33235E-03_JPRB,0.30343E-03_JPRB, &
 & 0.27796E-03_JPRB,0.24341E-03_JPRB,0.20303E-03_JPRB,0.20347E-03_JPRB /)  
KA(:, 3, 4,10) = (/ &
 & 0.45889E-03_JPRB,0.40391E-03_JPRB,0.37251E-03_JPRB,0.34409E-03_JPRB,0.32396E-03_JPRB, &
 & 0.30068E-03_JPRB,0.26403E-03_JPRB,0.23112E-03_JPRB,0.24434E-03_JPRB /)  
KA(:, 4, 4,10) = (/ &
 & 0.45955E-03_JPRB,0.40640E-03_JPRB,0.38203E-03_JPRB,0.36158E-03_JPRB,0.34561E-03_JPRB, &
 & 0.32162E-03_JPRB,0.28613E-03_JPRB,0.26715E-03_JPRB,0.29513E-03_JPRB /)  
KA(:, 5, 4,10) = (/ &
 & 0.45899E-03_JPRB,0.41016E-03_JPRB,0.39290E-03_JPRB,0.38024E-03_JPRB,0.36719E-03_JPRB, &
 & 0.34183E-03_JPRB,0.31736E-03_JPRB,0.31348E-03_JPRB,0.35430E-03_JPRB /)  
KA(:, 1, 5,10) = (/ &
 & 0.44860E-03_JPRB,0.39309E-03_JPRB,0.35143E-03_JPRB,0.31765E-03_JPRB,0.28887E-03_JPRB, &
 & 0.25439E-03_JPRB,0.21652E-03_JPRB,0.16876E-03_JPRB,0.14333E-03_JPRB /)  
KA(:, 2, 5,10) = (/ &
 & 0.45003E-03_JPRB,0.39579E-03_JPRB,0.35959E-03_JPRB,0.33075E-03_JPRB,0.30371E-03_JPRB, &
 & 0.27559E-03_JPRB,0.24058E-03_JPRB,0.19058E-03_JPRB,0.17442E-03_JPRB /)  
KA(:, 3, 5,10) = (/ &
 & 0.45146E-03_JPRB,0.39890E-03_JPRB,0.36951E-03_JPRB,0.34437E-03_JPRB,0.32442E-03_JPRB, &
 & 0.30040E-03_JPRB,0.26223E-03_JPRB,0.21520E-03_JPRB,0.21295E-03_JPRB /)  
KA(:, 4, 5,10) = (/ &
 & 0.45218E-03_JPRB,0.40151E-03_JPRB,0.38022E-03_JPRB,0.36228E-03_JPRB,0.34802E-03_JPRB, &
 & 0.32336E-03_JPRB,0.28327E-03_JPRB,0.24766E-03_JPRB,0.26132E-03_JPRB /)  
KA(:, 5, 5,10) = (/ &
 & 0.45207E-03_JPRB,0.40582E-03_JPRB,0.39175E-03_JPRB,0.38293E-03_JPRB,0.37072E-03_JPRB, &
 & 0.34500E-03_JPRB,0.31037E-03_JPRB,0.29012E-03_JPRB,0.31661E-03_JPRB /)  
KA(:, 1, 6,10) = (/ &
 & 0.43374E-03_JPRB,0.38081E-03_JPRB,0.34182E-03_JPRB,0.31060E-03_JPRB,0.28045E-03_JPRB, &
 & 0.24697E-03_JPRB,0.20889E-03_JPRB,0.16055E-03_JPRB,0.12036E-03_JPRB /)  
KA(:, 2, 6,10) = (/ &
 & 0.43531E-03_JPRB,0.38407E-03_JPRB,0.35000E-03_JPRB,0.32358E-03_JPRB,0.29721E-03_JPRB, &
 & 0.26821E-03_JPRB,0.23298E-03_JPRB,0.18104E-03_JPRB,0.14668E-03_JPRB /)  
KA(:, 3, 6,10) = (/ &
 & 0.43706E-03_JPRB,0.38738E-03_JPRB,0.35982E-03_JPRB,0.33840E-03_JPRB,0.31879E-03_JPRB, &
 & 0.29390E-03_JPRB,0.25605E-03_JPRB,0.20200E-03_JPRB,0.18191E-03_JPRB /)  
KA(:, 4, 6,10) = (/ &
 & 0.43807E-03_JPRB,0.39050E-03_JPRB,0.37037E-03_JPRB,0.35740E-03_JPRB,0.34372E-03_JPRB, &
 & 0.31863E-03_JPRB,0.27734E-03_JPRB,0.23003E-03_JPRB,0.22665E-03_JPRB /)  
KA(:, 5, 6,10) = (/ &
 & 0.43877E-03_JPRB,0.39551E-03_JPRB,0.38302E-03_JPRB,0.38004E-03_JPRB,0.36796E-03_JPRB, &
 & 0.34140E-03_JPRB,0.30328E-03_JPRB,0.26832E-03_JPRB,0.27676E-03_JPRB /)  
KA(:, 1, 7,10) = (/ &
 & 0.41256E-03_JPRB,0.36341E-03_JPRB,0.32806E-03_JPRB,0.30023E-03_JPRB,0.26855E-03_JPRB, &
 & 0.23444E-03_JPRB,0.19788E-03_JPRB,0.15062E-03_JPRB,0.10262E-03_JPRB /)  
KA(:, 2, 7,10) = (/ &
 & 0.41482E-03_JPRB,0.36772E-03_JPRB,0.33624E-03_JPRB,0.31297E-03_JPRB,0.28556E-03_JPRB, &
 & 0.25627E-03_JPRB,0.22127E-03_JPRB,0.17072E-03_JPRB,0.12601E-03_JPRB /)  
KA(:, 3, 7,10) = (/ &
 & 0.41718E-03_JPRB,0.37142E-03_JPRB,0.34661E-03_JPRB,0.32744E-03_JPRB,0.30719E-03_JPRB, &
 & 0.28254E-03_JPRB,0.24553E-03_JPRB,0.19044E-03_JPRB,0.15628E-03_JPRB /)  
KA(:, 4, 7,10) = (/ &
 & 0.41872E-03_JPRB,0.37555E-03_JPRB,0.35755E-03_JPRB,0.34713E-03_JPRB,0.33306E-03_JPRB, &
 & 0.30832E-03_JPRB,0.26791E-03_JPRB,0.21481E-03_JPRB,0.19464E-03_JPRB /)  
KA(:, 5, 7,10) = (/ &
 & 0.42048E-03_JPRB,0.38195E-03_JPRB,0.37042E-03_JPRB,0.37076E-03_JPRB,0.35893E-03_JPRB, &
 & 0.33177E-03_JPRB,0.29351E-03_JPRB,0.24858E-03_JPRB,0.23890E-03_JPRB /)  
KA(:, 1, 8,10) = (/ &
 & 0.38528E-03_JPRB,0.34132E-03_JPRB,0.30950E-03_JPRB,0.28435E-03_JPRB,0.25387E-03_JPRB, &
 & 0.21998E-03_JPRB,0.18381E-03_JPRB,0.13995E-03_JPRB,0.86291E-04_JPRB /)  
KA(:, 2, 8,10) = (/ &
 & 0.38813E-03_JPRB,0.34604E-03_JPRB,0.31840E-03_JPRB,0.29716E-03_JPRB,0.26994E-03_JPRB, &
 & 0.24125E-03_JPRB,0.20696E-03_JPRB,0.15919E-03_JPRB,0.10863E-03_JPRB /)  
KA(:, 3, 8,10) = (/ &
 & 0.39073E-03_JPRB,0.35038E-03_JPRB,0.33010E-03_JPRB,0.31128E-03_JPRB,0.29227E-03_JPRB, &
 & 0.26641E-03_JPRB,0.23195E-03_JPRB,0.17813E-03_JPRB,0.13616E-03_JPRB /)  
KA(:, 4, 8,10) = (/ &
 & 0.39281E-03_JPRB,0.35556E-03_JPRB,0.34140E-03_JPRB,0.33132E-03_JPRB,0.31814E-03_JPRB, &
 & 0.29308E-03_JPRB,0.25493E-03_JPRB,0.20064E-03_JPRB,0.16931E-03_JPRB /)  
KA(:, 5, 8,10) = (/ &
 & 0.39565E-03_JPRB,0.36362E-03_JPRB,0.35480E-03_JPRB,0.35632E-03_JPRB,0.34483E-03_JPRB, &
 & 0.31779E-03_JPRB,0.27994E-03_JPRB,0.23183E-03_JPRB,0.20721E-03_JPRB /)  
KA(:, 1, 9,10) = (/ &
 & 0.35353E-03_JPRB,0.31534E-03_JPRB,0.28844E-03_JPRB,0.26382E-03_JPRB,0.23534E-03_JPRB, &
 & 0.20347E-03_JPRB,0.16850E-03_JPRB,0.12923E-03_JPRB,0.71856E-04_JPRB /)  
KA(:, 2, 9,10) = (/ &
 & 0.35704E-03_JPRB,0.32078E-03_JPRB,0.29797E-03_JPRB,0.27689E-03_JPRB,0.25047E-03_JPRB, &
 & 0.22397E-03_JPRB,0.19066E-03_JPRB,0.14773E-03_JPRB,0.92561E-04_JPRB /)  
KA(:, 3, 9,10) = (/ &
 & 0.36000E-03_JPRB,0.32561E-03_JPRB,0.31012E-03_JPRB,0.29082E-03_JPRB,0.27253E-03_JPRB, &
 & 0.24851E-03_JPRB,0.21457E-03_JPRB,0.16607E-03_JPRB,0.11811E-03_JPRB /)  
KA(:, 4, 9,10) = (/ &
 & 0.36298E-03_JPRB,0.33189E-03_JPRB,0.32100E-03_JPRB,0.31077E-03_JPRB,0.29911E-03_JPRB, &
 & 0.27480E-03_JPRB,0.23785E-03_JPRB,0.18730E-03_JPRB,0.14849E-03_JPRB /)  
KA(:, 5, 9,10) = (/ &
 & 0.36645E-03_JPRB,0.34041E-03_JPRB,0.33535E-03_JPRB,0.33583E-03_JPRB,0.32646E-03_JPRB, &
 & 0.29975E-03_JPRB,0.26277E-03_JPRB,0.21618E-03_JPRB,0.18220E-03_JPRB /)  
KA(:, 1,10,10) = (/ &
 & 0.31882E-03_JPRB,0.28657E-03_JPRB,0.26462E-03_JPRB,0.24132E-03_JPRB,0.21534E-03_JPRB, &
 & 0.18636E-03_JPRB,0.15549E-03_JPRB,0.11817E-03_JPRB,0.60706E-04_JPRB /)  
KA(:, 2,10,10) = (/ &
 & 0.32301E-03_JPRB,0.29267E-03_JPRB,0.27519E-03_JPRB,0.25478E-03_JPRB,0.23046E-03_JPRB, &
 & 0.20560E-03_JPRB,0.17582E-03_JPRB,0.13638E-03_JPRB,0.79531E-04_JPRB /)  
KA(:, 3,10,10) = (/ &
 & 0.32639E-03_JPRB,0.29816E-03_JPRB,0.28709E-03_JPRB,0.26927E-03_JPRB,0.25170E-03_JPRB, &
 & 0.23027E-03_JPRB,0.19794E-03_JPRB,0.15520E-03_JPRB,0.10253E-03_JPRB /)  
KA(:, 4,10,10) = (/ &
 & 0.33008E-03_JPRB,0.30559E-03_JPRB,0.29823E-03_JPRB,0.28948E-03_JPRB,0.27786E-03_JPRB, &
 & 0.25639E-03_JPRB,0.22020E-03_JPRB,0.17621E-03_JPRB,0.13035E-03_JPRB /)  
KA(:, 5,10,10) = (/ &
 & 0.33429E-03_JPRB,0.31481E-03_JPRB,0.31383E-03_JPRB,0.31396E-03_JPRB,0.30544E-03_JPRB, &
 & 0.28143E-03_JPRB,0.24487E-03_JPRB,0.20336E-03_JPRB,0.16246E-03_JPRB /)  
KA(:, 1,11,10) = (/ &
 & 0.28433E-03_JPRB,0.25922E-03_JPRB,0.24227E-03_JPRB,0.22327E-03_JPRB,0.20067E-03_JPRB, &
 & 0.17618E-03_JPRB,0.15050E-03_JPRB,0.11425E-03_JPRB,0.57921E-04_JPRB /)  
KA(:, 2,11,10) = (/ &
 & 0.28828E-03_JPRB,0.26532E-03_JPRB,0.25425E-03_JPRB,0.23723E-03_JPRB,0.21797E-03_JPRB, &
 & 0.19695E-03_JPRB,0.17056E-03_JPRB,0.13252E-03_JPRB,0.76361E-04_JPRB /)  
KA(:, 3,11,10) = (/ &
 & 0.29236E-03_JPRB,0.27228E-03_JPRB,0.26588E-03_JPRB,0.25415E-03_JPRB,0.24099E-03_JPRB, &
 & 0.22135E-03_JPRB,0.19174E-03_JPRB,0.15232E-03_JPRB,0.98360E-04_JPRB /)  
KA(:, 4,11,10) = (/ &
 & 0.29717E-03_JPRB,0.28209E-03_JPRB,0.27970E-03_JPRB,0.27650E-03_JPRB,0.26714E-03_JPRB, &
 & 0.24681E-03_JPRB,0.21371E-03_JPRB,0.17631E-03_JPRB,0.12518E-03_JPRB /)  
KA(:, 5,11,10) = (/ &
 & 0.30177E-03_JPRB,0.29180E-03_JPRB,0.29905E-03_JPRB,0.30274E-03_JPRB,0.29362E-03_JPRB, &
 & 0.27208E-03_JPRB,0.24087E-03_JPRB,0.20461E-03_JPRB,0.15616E-03_JPRB /)  
KA(:, 1,12,10) = (/ &
 & 0.24998E-03_JPRB,0.23220E-03_JPRB,0.21962E-03_JPRB,0.20418E-03_JPRB,0.18598E-03_JPRB, &
 & 0.16635E-03_JPRB,0.14319E-03_JPRB,0.11002E-03_JPRB,0.54657E-04_JPRB /)  
KA(:, 2,12,10) = (/ &
 & 0.25422E-03_JPRB,0.23880E-03_JPRB,0.23171E-03_JPRB,0.21907E-03_JPRB,0.20484E-03_JPRB, &
 & 0.18724E-03_JPRB,0.16371E-03_JPRB,0.12837E-03_JPRB,0.72183E-04_JPRB /)  
KA(:, 3,12,10) = (/ &
 & 0.25909E-03_JPRB,0.24827E-03_JPRB,0.24443E-03_JPRB,0.23867E-03_JPRB,0.22868E-03_JPRB, &
 & 0.21084E-03_JPRB,0.18482E-03_JPRB,0.14974E-03_JPRB,0.93395E-04_JPRB /)  
KA(:, 4,12,10) = (/ &
 & 0.26399E-03_JPRB,0.25851E-03_JPRB,0.26208E-03_JPRB,0.26298E-03_JPRB,0.25438E-03_JPRB, &
 & 0.23482E-03_JPRB,0.20834E-03_JPRB,0.17589E-03_JPRB,0.11924E-03_JPRB /)  
KA(:, 5,12,10) = (/ &
 & 0.26914E-03_JPRB,0.26866E-03_JPRB,0.28401E-03_JPRB,0.28945E-03_JPRB,0.28022E-03_JPRB, &
 & 0.26150E-03_JPRB,0.23750E-03_JPRB,0.20542E-03_JPRB,0.14923E-03_JPRB /)  
KA(:, 1,13,10) = (/ &
 & 0.21751E-03_JPRB,0.20608E-03_JPRB,0.19731E-03_JPRB,0.18540E-03_JPRB,0.17208E-03_JPRB, &
 & 0.15624E-03_JPRB,0.13474E-03_JPRB,0.10527E-03_JPRB,0.50953E-04_JPRB /)  
KA(:, 2,13,10) = (/ &
 & 0.22228E-03_JPRB,0.21439E-03_JPRB,0.20968E-03_JPRB,0.20158E-03_JPRB,0.19151E-03_JPRB, &
 & 0.17720E-03_JPRB,0.15564E-03_JPRB,0.12461E-03_JPRB,0.67516E-04_JPRB /)  
KA(:, 3,13,10) = (/ &
 & 0.22727E-03_JPRB,0.22462E-03_JPRB,0.22474E-03_JPRB,0.22318E-03_JPRB,0.21469E-03_JPRB, &
 & 0.19989E-03_JPRB,0.17790E-03_JPRB,0.14782E-03_JPRB,0.88180E-04_JPRB /)  
KA(:, 4,13,10) = (/ &
 & 0.23242E-03_JPRB,0.23488E-03_JPRB,0.24462E-03_JPRB,0.24805E-03_JPRB,0.24003E-03_JPRB, &
 & 0.22364E-03_JPRB,0.20382E-03_JPRB,0.17470E-03_JPRB,0.11335E-03_JPRB /)  
KA(:, 5,13,10) = (/ &
 & 0.23819E-03_JPRB,0.24692E-03_JPRB,0.26797E-03_JPRB,0.27413E-03_JPRB,0.26611E-03_JPRB, &
 & 0.25207E-03_JPRB,0.23456E-03_JPRB,0.20493E-03_JPRB,0.14302E-03_JPRB /)  
KA(:, 1, 1,11) = (/ &
 & 0.54188E-03_JPRB,0.47438E-03_JPRB,0.41220E-03_JPRB,0.36319E-03_JPRB,0.32177E-03_JPRB, &
 & 0.28178E-03_JPRB,0.26195E-03_JPRB,0.26768E-03_JPRB,0.30988E-03_JPRB /)  
KA(:, 2, 1,11) = (/ &
 & 0.53863E-03_JPRB,0.47157E-03_JPRB,0.41235E-03_JPRB,0.37142E-03_JPRB,0.33314E-03_JPRB, &
 & 0.30667E-03_JPRB,0.29622E-03_JPRB,0.31573E-03_JPRB,0.36594E-03_JPRB /)  
KA(:, 3, 1,11) = (/ &
 & 0.53537E-03_JPRB,0.46873E-03_JPRB,0.41881E-03_JPRB,0.37881E-03_JPRB,0.35190E-03_JPRB, &
 & 0.33275E-03_JPRB,0.33720E-03_JPRB,0.36928E-03_JPRB,0.42810E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART7',1,ZHOOK_HANDLE)
END SUBROUTINE PART7


SUBROUTINE PART8

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART8',0,ZHOOK_HANDLE)


KA(:, 4, 1,11) = (/ &
 & 0.53255E-03_JPRB,0.46630E-03_JPRB,0.42443E-03_JPRB,0.38945E-03_JPRB,0.37640E-03_JPRB, &
 & 0.36424E-03_JPRB,0.38086E-03_JPRB,0.42782E-03_JPRB,0.49486E-03_JPRB /)  
KA(:, 5, 1,11) = (/ &
 & 0.53016E-03_JPRB,0.46423E-03_JPRB,0.43029E-03_JPRB,0.40524E-03_JPRB,0.39835E-03_JPRB, &
 & 0.40134E-03_JPRB,0.42785E-03_JPRB,0.48998E-03_JPRB,0.56469E-03_JPRB /)  
KA(:, 1, 2,11) = (/ &
 & 0.58031E-03_JPRB,0.50799E-03_JPRB,0.44209E-03_JPRB,0.39038E-03_JPRB,0.34592E-03_JPRB, &
 & 0.30091E-03_JPRB,0.27060E-03_JPRB,0.26179E-03_JPRB,0.30262E-03_JPRB /)  
KA(:, 2, 2,11) = (/ &
 & 0.57783E-03_JPRB,0.50583E-03_JPRB,0.44303E-03_JPRB,0.40158E-03_JPRB,0.35771E-03_JPRB, &
 & 0.32458E-03_JPRB,0.30412E-03_JPRB,0.31051E-03_JPRB,0.36041E-03_JPRB /)  
KA(:, 3, 2,11) = (/ &
 & 0.57540E-03_JPRB,0.50373E-03_JPRB,0.45070E-03_JPRB,0.41078E-03_JPRB,0.37604E-03_JPRB, &
 & 0.34973E-03_JPRB,0.34205E-03_JPRB,0.36376E-03_JPRB,0.42111E-03_JPRB /)  
KA(:, 4, 2,11) = (/ &
 & 0.57390E-03_JPRB,0.50246E-03_JPRB,0.45850E-03_JPRB,0.42273E-03_JPRB,0.40005E-03_JPRB, &
 & 0.37925E-03_JPRB,0.38380E-03_JPRB,0.42075E-03_JPRB,0.48570E-03_JPRB /)  
KA(:, 5, 2,11) = (/ &
 & 0.57251E-03_JPRB,0.50128E-03_JPRB,0.46686E-03_JPRB,0.44000E-03_JPRB,0.42177E-03_JPRB, &
 & 0.41338E-03_JPRB,0.42764E-03_JPRB,0.47996E-03_JPRB,0.55489E-03_JPRB /)  
KA(:, 1, 3,11) = (/ &
 & 0.61606E-03_JPRB,0.53921E-03_JPRB,0.46963E-03_JPRB,0.41409E-03_JPRB,0.36561E-03_JPRB, &
 & 0.31888E-03_JPRB,0.27397E-03_JPRB,0.24837E-03_JPRB,0.28056E-03_JPRB /)  
KA(:, 2, 3,11) = (/ &
 & 0.61406E-03_JPRB,0.53752E-03_JPRB,0.47091E-03_JPRB,0.42713E-03_JPRB,0.37975E-03_JPRB, &
 & 0.33844E-03_JPRB,0.30659E-03_JPRB,0.29320E-03_JPRB,0.33782E-03_JPRB /)  
KA(:, 3, 3,11) = (/ &
 & 0.61257E-03_JPRB,0.53626E-03_JPRB,0.47829E-03_JPRB,0.43902E-03_JPRB,0.39761E-03_JPRB, &
 & 0.36364E-03_JPRB,0.34206E-03_JPRB,0.34371E-03_JPRB,0.39648E-03_JPRB /)  
KA(:, 4, 3,11) = (/ &
 & 0.61154E-03_JPRB,0.53538E-03_JPRB,0.48822E-03_JPRB,0.45223E-03_JPRB,0.42130E-03_JPRB, &
 & 0.39347E-03_JPRB,0.37907E-03_JPRB,0.39708E-03_JPRB,0.45765E-03_JPRB /)  
KA(:, 5, 3,11) = (/ &
 & 0.61140E-03_JPRB,0.53529E-03_JPRB,0.49797E-03_JPRB,0.47117E-03_JPRB,0.44115E-03_JPRB, &
 & 0.42497E-03_JPRB,0.41979E-03_JPRB,0.45564E-03_JPRB,0.52659E-03_JPRB /)  
KA(:, 1, 4,11) = (/ &
 & 0.64443E-03_JPRB,0.56411E-03_JPRB,0.49232E-03_JPRB,0.43467E-03_JPRB,0.38190E-03_JPRB, &
 & 0.33277E-03_JPRB,0.27825E-03_JPRB,0.23501E-03_JPRB,0.25182E-03_JPRB /)  
KA(:, 2, 4,11) = (/ &
 & 0.64292E-03_JPRB,0.56277E-03_JPRB,0.49409E-03_JPRB,0.44787E-03_JPRB,0.39817E-03_JPRB, &
 & 0.35161E-03_JPRB,0.30747E-03_JPRB,0.27717E-03_JPRB,0.30629E-03_JPRB /)  
KA(:, 3, 4,11) = (/ &
 & 0.64243E-03_JPRB,0.56236E-03_JPRB,0.50119E-03_JPRB,0.46200E-03_JPRB,0.41580E-03_JPRB, &
 & 0.37809E-03_JPRB,0.34162E-03_JPRB,0.32168E-03_JPRB,0.36251E-03_JPRB /)  
KA(:, 4, 4,11) = (/ &
 & 0.64248E-03_JPRB,0.56245E-03_JPRB,0.51257E-03_JPRB,0.47612E-03_JPRB,0.44107E-03_JPRB, &
 & 0.40610E-03_JPRB,0.37659E-03_JPRB,0.36992E-03_JPRB,0.42339E-03_JPRB /)  
KA(:, 5, 4,11) = (/ &
 & 0.64345E-03_JPRB,0.56414E-03_JPRB,0.52333E-03_JPRB,0.49621E-03_JPRB,0.46345E-03_JPRB, &
 & 0.43530E-03_JPRB,0.41388E-03_JPRB,0.42704E-03_JPRB,0.49356E-03_JPRB /)  
KA(:, 1, 5,11) = (/ &
 & 0.66205E-03_JPRB,0.57941E-03_JPRB,0.50732E-03_JPRB,0.44788E-03_JPRB,0.39504E-03_JPRB, &
 & 0.34261E-03_JPRB,0.28274E-03_JPRB,0.22440E-03_JPRB,0.22048E-03_JPRB /)  
KA(:, 2, 5,11) = (/ &
 & 0.66163E-03_JPRB,0.57912E-03_JPRB,0.51033E-03_JPRB,0.46104E-03_JPRB,0.41289E-03_JPRB, &
 & 0.36220E-03_JPRB,0.30969E-03_JPRB,0.26291E-03_JPRB,0.27073E-03_JPRB /)  
KA(:, 3, 5,11) = (/ &
 & 0.66197E-03_JPRB,0.57946E-03_JPRB,0.51799E-03_JPRB,0.47594E-03_JPRB,0.43132E-03_JPRB, &
 & 0.39012E-03_JPRB,0.34192E-03_JPRB,0.30335E-03_JPRB,0.32369E-03_JPRB /)  
KA(:, 4, 5,11) = (/ &
 & 0.66310E-03_JPRB,0.58124E-03_JPRB,0.52962E-03_JPRB,0.49191E-03_JPRB,0.45677E-03_JPRB, &
 & 0.42022E-03_JPRB,0.37529E-03_JPRB,0.34603E-03_JPRB,0.38247E-03_JPRB /)  
KA(:, 5, 5,11) = (/ &
 & 0.66411E-03_JPRB,0.58365E-03_JPRB,0.54225E-03_JPRB,0.51373E-03_JPRB,0.48391E-03_JPRB, &
 & 0.44802E-03_JPRB,0.41016E-03_JPRB,0.39855E-03_JPRB,0.45388E-03_JPRB /)  
KA(:, 1, 6,11) = (/ &
 & 0.66761E-03_JPRB,0.58431E-03_JPRB,0.51405E-03_JPRB,0.45280E-03_JPRB,0.40155E-03_JPRB, &
 & 0.34610E-03_JPRB,0.28249E-03_JPRB,0.21395E-03_JPRB,0.18888E-03_JPRB /)  
KA(:, 2, 6,11) = (/ &
 & 0.66804E-03_JPRB,0.58472E-03_JPRB,0.51807E-03_JPRB,0.46619E-03_JPRB,0.41922E-03_JPRB, &
 & 0.36797E-03_JPRB,0.30908E-03_JPRB,0.24851E-03_JPRB,0.23408E-03_JPRB /)  
KA(:, 3, 6,11) = (/ &
 & 0.66946E-03_JPRB,0.58664E-03_JPRB,0.52673E-03_JPRB,0.48103E-03_JPRB,0.43940E-03_JPRB, &
 & 0.39605E-03_JPRB,0.34204E-03_JPRB,0.28507E-03_JPRB,0.28224E-03_JPRB /)  
KA(:, 4, 6,11) = (/ &
 & 0.67150E-03_JPRB,0.59004E-03_JPRB,0.53959E-03_JPRB,0.49825E-03_JPRB,0.46612E-03_JPRB, &
 & 0.42814E-03_JPRB,0.37432E-03_JPRB,0.32325E-03_JPRB,0.33817E-03_JPRB /)  
KA(:, 5, 6,11) = (/ &
 & 0.67315E-03_JPRB,0.59352E-03_JPRB,0.55351E-03_JPRB,0.52125E-03_JPRB,0.49748E-03_JPRB, &
 & 0.45943E-03_JPRB,0.40603E-03_JPRB,0.37064E-03_JPRB,0.40786E-03_JPRB /)  
KA(:, 1, 7,11) = (/ &
 & 0.65825E-03_JPRB,0.57610E-03_JPRB,0.50973E-03_JPRB,0.44919E-03_JPRB,0.40091E-03_JPRB, &
 & 0.34393E-03_JPRB,0.27863E-03_JPRB,0.20584E-03_JPRB,0.15896E-03_JPRB /)  
KA(:, 2, 7,11) = (/ &
 & 0.66067E-03_JPRB,0.57854E-03_JPRB,0.51604E-03_JPRB,0.46345E-03_JPRB,0.41921E-03_JPRB, &
 & 0.36628E-03_JPRB,0.30597E-03_JPRB,0.23625E-03_JPRB,0.19866E-03_JPRB /)  
KA(:, 3, 7,11) = (/ &
 & 0.66419E-03_JPRB,0.58318E-03_JPRB,0.52599E-03_JPRB,0.48043E-03_JPRB,0.43994E-03_JPRB, &
 & 0.39562E-03_JPRB,0.33865E-03_JPRB,0.26970E-03_JPRB,0.24286E-03_JPRB /)  
KA(:, 4, 7,11) = (/ &
 & 0.66717E-03_JPRB,0.58792E-03_JPRB,0.54016E-03_JPRB,0.49893E-03_JPRB,0.46857E-03_JPRB, &
 & 0.43005E-03_JPRB,0.37266E-03_JPRB,0.30411E-03_JPRB,0.29541E-03_JPRB /)  
KA(:, 5, 7,11) = (/ &
 & 0.67024E-03_JPRB,0.59309E-03_JPRB,0.55482E-03_JPRB,0.52246E-03_JPRB,0.50380E-03_JPRB, &
 & 0.46446E-03_JPRB,0.40297E-03_JPRB,0.34641E-03_JPRB,0.36121E-03_JPRB /)  
KA(:, 1, 8,11) = (/ &
 & 0.63858E-03_JPRB,0.55888E-03_JPRB,0.49736E-03_JPRB,0.43942E-03_JPRB,0.39082E-03_JPRB, &
 & 0.33512E-03_JPRB,0.27058E-03_JPRB,0.19736E-03_JPRB,0.13589E-03_JPRB /)  
KA(:, 2, 8,11) = (/ &
 & 0.64324E-03_JPRB,0.56410E-03_JPRB,0.50530E-03_JPRB,0.45504E-03_JPRB,0.41149E-03_JPRB, &
 & 0.35701E-03_JPRB,0.29879E-03_JPRB,0.22618E-03_JPRB,0.16884E-03_JPRB /)  
KA(:, 3, 8,11) = (/ &
 & 0.64790E-03_JPRB,0.57033E-03_JPRB,0.51640E-03_JPRB,0.47474E-03_JPRB,0.43226E-03_JPRB, &
 & 0.38846E-03_JPRB,0.33154E-03_JPRB,0.25769E-03_JPRB,0.20679E-03_JPRB /)  
KA(:, 4, 8,11) = (/ &
 & 0.65242E-03_JPRB,0.57688E-03_JPRB,0.53191E-03_JPRB,0.49447E-03_JPRB,0.46234E-03_JPRB, &
 & 0.42468E-03_JPRB,0.36669E-03_JPRB,0.28907E-03_JPRB,0.25449E-03_JPRB /)  
KA(:, 5, 8,11) = (/ &
 & 0.65716E-03_JPRB,0.58346E-03_JPRB,0.54799E-03_JPRB,0.51859E-03_JPRB,0.49982E-03_JPRB, &
 & 0.46218E-03_JPRB,0.39875E-03_JPRB,0.32573E-03_JPRB,0.31655E-03_JPRB /)  
KA(:, 1, 9,11) = (/ &
 & 0.61155E-03_JPRB,0.53549E-03_JPRB,0.47878E-03_JPRB,0.42579E-03_JPRB,0.37499E-03_JPRB, &
 & 0.31961E-03_JPRB,0.25793E-03_JPRB,0.18655E-03_JPRB,0.11490E-03_JPRB /)  
KA(:, 2, 9,11) = (/ &
 & 0.61794E-03_JPRB,0.54314E-03_JPRB,0.48878E-03_JPRB,0.44250E-03_JPRB,0.39687E-03_JPRB, &
 & 0.34151E-03_JPRB,0.28569E-03_JPRB,0.21436E-03_JPRB,0.14511E-03_JPRB /)  
KA(:, 3, 9,11) = (/ &
 & 0.62338E-03_JPRB,0.55078E-03_JPRB,0.50083E-03_JPRB,0.46354E-03_JPRB,0.41796E-03_JPRB, &
 & 0.37306E-03_JPRB,0.31954E-03_JPRB,0.24508E-03_JPRB,0.17854E-03_JPRB /)  
KA(:, 4, 9,11) = (/ &
 & 0.62936E-03_JPRB,0.55894E-03_JPRB,0.51722E-03_JPRB,0.48335E-03_JPRB,0.44775E-03_JPRB, &
 & 0.41130E-03_JPRB,0.35579E-03_JPRB,0.27533E-03_JPRB,0.21988E-03_JPRB /)  
KA(:, 5, 9,11) = (/ &
 & 0.63545E-03_JPRB,0.56698E-03_JPRB,0.53473E-03_JPRB,0.50887E-03_JPRB,0.48603E-03_JPRB, &
 & 0.45259E-03_JPRB,0.39001E-03_JPRB,0.30792E-03_JPRB,0.27464E-03_JPRB /)  
KA(:, 1,10,11) = (/ &
 & 0.57726E-03_JPRB,0.50676E-03_JPRB,0.45606E-03_JPRB,0.40779E-03_JPRB,0.35629E-03_JPRB, &
 & 0.30220E-03_JPRB,0.24273E-03_JPRB,0.17731E-03_JPRB,0.97262E-04_JPRB /)  
KA(:, 2,10,11) = (/ &
 & 0.58382E-03_JPRB,0.51548E-03_JPRB,0.46729E-03_JPRB,0.42570E-03_JPRB,0.37915E-03_JPRB, &
 & 0.32497E-03_JPRB,0.26965E-03_JPRB,0.20381E-03_JPRB,0.12529E-03_JPRB /)  
KA(:, 3,10,11) = (/ &
 & 0.59071E-03_JPRB,0.52512E-03_JPRB,0.48044E-03_JPRB,0.44753E-03_JPRB,0.40142E-03_JPRB, &
 & 0.35504E-03_JPRB,0.30526E-03_JPRB,0.23284E-03_JPRB,0.15783E-03_JPRB /)  
KA(:, 4,10,11) = (/ &
 & 0.59829E-03_JPRB,0.53444E-03_JPRB,0.49886E-03_JPRB,0.46810E-03_JPRB,0.43172E-03_JPRB, &
 & 0.39380E-03_JPRB,0.34313E-03_JPRB,0.26284E-03_JPRB,0.19647E-03_JPRB /)  
KA(:, 5,10,11) = (/ &
 & 0.60558E-03_JPRB,0.54444E-03_JPRB,0.51788E-03_JPRB,0.49497E-03_JPRB,0.47022E-03_JPRB, &
 & 0.43733E-03_JPRB,0.37954E-03_JPRB,0.29404E-03_JPRB,0.24439E-03_JPRB /)  
KA(:, 1,11,11) = (/ &
 & 0.53880E-03_JPRB,0.47669E-03_JPRB,0.43422E-03_JPRB,0.39066E-03_JPRB,0.34441E-03_JPRB, &
 & 0.29300E-03_JPRB,0.23722E-03_JPRB,0.17846E-03_JPRB,0.93053E-04_JPRB /)  
KA(:, 2,11,11) = (/ &
 & 0.54672E-03_JPRB,0.48762E-03_JPRB,0.44694E-03_JPRB,0.41155E-03_JPRB,0.36791E-03_JPRB, &
 & 0.31854E-03_JPRB,0.26663E-03_JPRB,0.20551E-03_JPRB,0.12100E-03_JPRB /)  
KA(:, 3,11,11) = (/ &
 & 0.55543E-03_JPRB,0.49853E-03_JPRB,0.46450E-03_JPRB,0.43411E-03_JPRB,0.39364E-03_JPRB, &
 & 0.35233E-03_JPRB,0.30378E-03_JPRB,0.23442E-03_JPRB,0.15474E-03_JPRB /)  
KA(:, 4,11,11) = (/ &
 & 0.56418E-03_JPRB,0.50955E-03_JPRB,0.48543E-03_JPRB,0.45785E-03_JPRB,0.42947E-03_JPRB, &
 & 0.39274E-03_JPRB,0.34329E-03_JPRB,0.26304E-03_JPRB,0.19545E-03_JPRB /)  
KA(:, 5,11,11) = (/ &
 & 0.57281E-03_JPRB,0.52221E-03_JPRB,0.50507E-03_JPRB,0.49044E-03_JPRB,0.47093E-03_JPRB, &
 & 0.43647E-03_JPRB,0.38057E-03_JPRB,0.29685E-03_JPRB,0.24345E-03_JPRB /)  
KA(:, 1,12,11) = (/ &
 & 0.49534E-03_JPRB,0.44336E-03_JPRB,0.40843E-03_JPRB,0.37029E-03_JPRB,0.32924E-03_JPRB, &
 & 0.28268E-03_JPRB,0.23204E-03_JPRB,0.17692E-03_JPRB,0.89557E-04_JPRB /)  
KA(:, 2,12,11) = (/ &
 & 0.50529E-03_JPRB,0.45586E-03_JPRB,0.42428E-03_JPRB,0.39360E-03_JPRB,0.35384E-03_JPRB, &
 & 0.31099E-03_JPRB,0.26296E-03_JPRB,0.20575E-03_JPRB,0.11779E-03_JPRB /)  
KA(:, 3,12,11) = (/ &
 & 0.51591E-03_JPRB,0.46841E-03_JPRB,0.44557E-03_JPRB,0.41710E-03_JPRB,0.38396E-03_JPRB, &
 & 0.34779E-03_JPRB,0.29981E-03_JPRB,0.23475E-03_JPRB,0.15231E-03_JPRB /)  
KA(:, 4,12,11) = (/ &
 & 0.52638E-03_JPRB,0.48189E-03_JPRB,0.46689E-03_JPRB,0.44567E-03_JPRB,0.42354E-03_JPRB, &
 & 0.38951E-03_JPRB,0.33959E-03_JPRB,0.26406E-03_JPRB,0.19354E-03_JPRB /)  
KA(:, 5,12,11) = (/ &
 & 0.53740E-03_JPRB,0.49847E-03_JPRB,0.48961E-03_JPRB,0.48352E-03_JPRB,0.46848E-03_JPRB, &
 & 0.43322E-03_JPRB,0.37807E-03_JPRB,0.30031E-03_JPRB,0.24179E-03_JPRB /)  
KA(:, 1,13,11) = (/ &
 & 0.44967E-03_JPRB,0.40765E-03_JPRB,0.37964E-03_JPRB,0.34767E-03_JPRB,0.31190E-03_JPRB, &
 & 0.27110E-03_JPRB,0.22687E-03_JPRB,0.17331E-03_JPRB,0.86456E-04_JPRB /)  
KA(:, 2,13,11) = (/ &
 & 0.46197E-03_JPRB,0.42196E-03_JPRB,0.40010E-03_JPRB,0.37282E-03_JPRB,0.33881E-03_JPRB, &
 & 0.30170E-03_JPRB,0.25812E-03_JPRB,0.20314E-03_JPRB,0.11471E-03_JPRB /)  
KA(:, 3,13,11) = (/ &
 & 0.47416E-03_JPRB,0.43662E-03_JPRB,0.42347E-03_JPRB,0.39902E-03_JPRB,0.37341E-03_JPRB, &
 & 0.34073E-03_JPRB,0.29426E-03_JPRB,0.23321E-03_JPRB,0.14921E-03_JPRB /)  
KA(:, 4,13,11) = (/ &
 & 0.48670E-03_JPRB,0.45348E-03_JPRB,0.44656E-03_JPRB,0.43321E-03_JPRB,0.41603E-03_JPRB, &
 & 0.38366E-03_JPRB,0.33328E-03_JPRB,0.26489E-03_JPRB,0.19032E-03_JPRB /)  
KA(:, 5,13,11) = (/ &
 & 0.49941E-03_JPRB,0.47298E-03_JPRB,0.47361E-03_JPRB,0.47457E-03_JPRB,0.46263E-03_JPRB, &
 & 0.42791E-03_JPRB,0.37404E-03_JPRB,0.30319E-03_JPRB,0.23864E-03_JPRB /)  
KA(:, 1, 1,12) = (/ &
 & 0.67194E-03_JPRB,0.58821E-03_JPRB,0.50483E-03_JPRB,0.44022E-03_JPRB,0.39428E-03_JPRB, &
 & 0.35001E-03_JPRB,0.32802E-03_JPRB,0.34712E-03_JPRB,0.40424E-03_JPRB /)  
KA(:, 2, 1,12) = (/ &
 & 0.66779E-03_JPRB,0.58462E-03_JPRB,0.50560E-03_JPRB,0.45370E-03_JPRB,0.41018E-03_JPRB, &
 & 0.37788E-03_JPRB,0.37804E-03_JPRB,0.41641E-03_JPRB,0.48433E-03_JPRB /)  
KA(:, 3, 1,12) = (/ &
 & 0.66375E-03_JPRB,0.58112E-03_JPRB,0.50831E-03_JPRB,0.46547E-03_JPRB,0.43045E-03_JPRB, &
 & 0.42028E-03_JPRB,0.43766E-03_JPRB,0.49681E-03_JPRB,0.57585E-03_JPRB /)  
KA(:, 4, 1,12) = (/ &
 & 0.65976E-03_JPRB,0.57768E-03_JPRB,0.51951E-03_JPRB,0.47941E-03_JPRB,0.45883E-03_JPRB, &
 & 0.47280E-03_JPRB,0.50926E-03_JPRB,0.58385E-03_JPRB,0.67578E-03_JPRB /)  
KA(:, 5, 1,12) = (/ &
 & 0.65493E-03_JPRB,0.57349E-03_JPRB,0.52976E-03_JPRB,0.49649E-03_JPRB,0.49872E-03_JPRB, &
 & 0.52477E-03_JPRB,0.58910E-03_JPRB,0.67477E-03_JPRB,0.78177E-03_JPRB /)  
KA(:, 1, 2,12) = (/ &
 & 0.74429E-03_JPRB,0.65147E-03_JPRB,0.55958E-03_JPRB,0.48439E-03_JPRB,0.43163E-03_JPRB, &
 & 0.37450E-03_JPRB,0.34047E-03_JPRB,0.34702E-03_JPRB,0.40780E-03_JPRB /)  
KA(:, 2, 2,12) = (/ &
 & 0.73897E-03_JPRB,0.64685E-03_JPRB,0.56004E-03_JPRB,0.49710E-03_JPRB,0.44831E-03_JPRB, &
 & 0.39986E-03_JPRB,0.38897E-03_JPRB,0.41601E-03_JPRB,0.48800E-03_JPRB /)  
KA(:, 3, 2,12) = (/ &
 & 0.73423E-03_JPRB,0.64274E-03_JPRB,0.56120E-03_JPRB,0.51084E-03_JPRB,0.46668E-03_JPRB, &
 & 0.44211E-03_JPRB,0.44391E-03_JPRB,0.49187E-03_JPRB,0.57573E-03_JPRB /)  
KA(:, 4, 2,12) = (/ &
 & 0.72906E-03_JPRB,0.63825E-03_JPRB,0.57090E-03_JPRB,0.52414E-03_JPRB,0.49429E-03_JPRB, &
 & 0.48962E-03_JPRB,0.50615E-03_JPRB,0.57487E-03_JPRB,0.67078E-03_JPRB /)  
KA(:, 5, 2,12) = (/ &
 & 0.72487E-03_JPRB,0.63461E-03_JPRB,0.58043E-03_JPRB,0.54078E-03_JPRB,0.53373E-03_JPRB, &
 & 0.54010E-03_JPRB,0.58187E-03_JPRB,0.66737E-03_JPRB,0.77655E-03_JPRB /)  
KA(:, 1, 3,12) = (/ &
 & 0.81958E-03_JPRB,0.71735E-03_JPRB,0.61664E-03_JPRB,0.53266E-03_JPRB,0.46619E-03_JPRB, &
 & 0.39818E-03_JPRB,0.35035E-03_JPRB,0.33455E-03_JPRB,0.39417E-03_JPRB /)  
KA(:, 2, 3,12) = (/ &
 & 0.81517E-03_JPRB,0.71349E-03_JPRB,0.61778E-03_JPRB,0.54292E-03_JPRB,0.48245E-03_JPRB, &
 & 0.42187E-03_JPRB,0.39187E-03_JPRB,0.40203E-03_JPRB,0.47500E-03_JPRB /)  
KA(:, 3, 3,12) = (/ &
 & 0.81131E-03_JPRB,0.71014E-03_JPRB,0.61887E-03_JPRB,0.55563E-03_JPRB,0.49928E-03_JPRB, &
 & 0.45852E-03_JPRB,0.44599E-03_JPRB,0.47656E-03_JPRB,0.56304E-03_JPRB /)  
KA(:, 4, 3,12) = (/ &
 & 0.80684E-03_JPRB,0.70624E-03_JPRB,0.62502E-03_JPRB,0.56854E-03_JPRB,0.52516E-03_JPRB, &
 & 0.50282E-03_JPRB,0.50405E-03_JPRB,0.55674E-03_JPRB,0.65701E-03_JPRB /)  
KA(:, 5, 3,12) = (/ &
 & 0.80277E-03_JPRB,0.70271E-03_JPRB,0.63387E-03_JPRB,0.58439E-03_JPRB,0.56394E-03_JPRB, &
 & 0.54984E-03_JPRB,0.57036E-03_JPRB,0.64435E-03_JPRB,0.75883E-03_JPRB /)  
KA(:, 1, 4,12) = (/ &
 & 0.88962E-03_JPRB,0.77859E-03_JPRB,0.66931E-03_JPRB,0.57740E-03_JPRB,0.50138E-03_JPRB, &
 & 0.42396E-03_JPRB,0.36076E-03_JPRB,0.31901E-03_JPRB,0.36723E-03_JPRB /)  
KA(:, 2, 4,12) = (/ &
 & 0.88665E-03_JPRB,0.77601E-03_JPRB,0.67190E-03_JPRB,0.58651E-03_JPRB,0.51766E-03_JPRB, &
 & 0.44641E-03_JPRB,0.39755E-03_JPRB,0.38137E-03_JPRB,0.44921E-03_JPRB /)  
KA(:, 3, 4,12) = (/ &
 & 0.88362E-03_JPRB,0.77338E-03_JPRB,0.67394E-03_JPRB,0.60034E-03_JPRB,0.53406E-03_JPRB, &
 & 0.47716E-03_JPRB,0.44855E-03_JPRB,0.45695E-03_JPRB,0.53953E-03_JPRB /)  
KA(:, 4, 4,12) = (/ &
 & 0.87936E-03_JPRB,0.76967E-03_JPRB,0.67789E-03_JPRB,0.61530E-03_JPRB,0.55605E-03_JPRB, &
 & 0.52026E-03_JPRB,0.50535E-03_JPRB,0.53746E-03_JPRB,0.63432E-03_JPRB /)  
KA(:, 5, 4,12) = (/ &
 & 0.87542E-03_JPRB,0.76625E-03_JPRB,0.68901E-03_JPRB,0.63085E-03_JPRB,0.59283E-03_JPRB, &
 & 0.56499E-03_JPRB,0.56855E-03_JPRB,0.62330E-03_JPRB,0.73477E-03_JPRB /)  
KA(:, 1, 5,12) = (/ &
 & 0.95206E-03_JPRB,0.83319E-03_JPRB,0.71670E-03_JPRB,0.61887E-03_JPRB,0.53098E-03_JPRB, &
 & 0.45065E-03_JPRB,0.37161E-03_JPRB,0.30790E-03_JPRB,0.33661E-03_JPRB /)  
KA(:, 2, 5,12) = (/ &
 & 0.95024E-03_JPRB,0.83163E-03_JPRB,0.72052E-03_JPRB,0.62686E-03_JPRB,0.54899E-03_JPRB, &
 & 0.47363E-03_JPRB,0.40570E-03_JPRB,0.36303E-03_JPRB,0.41611E-03_JPRB /)  
KA(:, 3, 5,12) = (/ &
 & 0.94830E-03_JPRB,0.82995E-03_JPRB,0.72350E-03_JPRB,0.64294E-03_JPRB,0.56882E-03_JPRB, &
 & 0.49923E-03_JPRB,0.45370E-03_JPRB,0.43446E-03_JPRB,0.50740E-03_JPRB /)  
KA(:, 4, 5,12) = (/ &
 & 0.94590E-03_JPRB,0.82788E-03_JPRB,0.72796E-03_JPRB,0.66075E-03_JPRB,0.59106E-03_JPRB, &
 & 0.53960E-03_JPRB,0.50922E-03_JPRB,0.51449E-03_JPRB,0.60347E-03_JPRB /)  
KA(:, 5, 5,12) = (/ &
 & 0.94431E-03_JPRB,0.82652E-03_JPRB,0.73985E-03_JPRB,0.67685E-03_JPRB,0.62406E-03_JPRB, &
 & 0.58535E-03_JPRB,0.56960E-03_JPRB,0.60003E-03_JPRB,0.70205E-03_JPRB /)  
KA(:, 1, 6,12) = (/ &
 & 0.10063E-02_JPRB,0.88067E-03_JPRB,0.75816E-03_JPRB,0.65590E-03_JPRB,0.55704E-03_JPRB, &
 & 0.47312E-03_JPRB,0.38218E-03_JPRB,0.29812E-03_JPRB,0.29923E-03_JPRB /)  
KA(:, 2, 6,12) = (/ &
 & 0.10075E-02_JPRB,0.88171E-03_JPRB,0.76490E-03_JPRB,0.66447E-03_JPRB,0.57639E-03_JPRB, &
 & 0.49685E-03_JPRB,0.41345E-03_JPRB,0.34724E-03_JPRB,0.37557E-03_JPRB /)  
KA(:, 3, 6,12) = (/ &
 & 0.10072E-02_JPRB,0.88152E-03_JPRB,0.76915E-03_JPRB,0.68176E-03_JPRB,0.59750E-03_JPRB, &
 & 0.52339E-03_JPRB,0.45689E-03_JPRB,0.41130E-03_JPRB,0.46505E-03_JPRB /)  
KA(:, 4, 6,12) = (/ &
 & 0.10060E-02_JPRB,0.88049E-03_JPRB,0.77394E-03_JPRB,0.69974E-03_JPRB,0.62189E-03_JPRB, &
 & 0.55958E-03_JPRB,0.51188E-03_JPRB,0.48580E-03_JPRB,0.55924E-03_JPRB /)  
KA(:, 5, 6,12) = (/ &
 & 0.10051E-02_JPRB,0.87967E-03_JPRB,0.78569E-03_JPRB,0.71720E-03_JPRB,0.65527E-03_JPRB, &
 & 0.60501E-03_JPRB,0.57082E-03_JPRB,0.56756E-03_JPRB,0.65737E-03_JPRB /)  
KA(:, 1, 7,12) = (/ &
 & 0.10487E-02_JPRB,0.91773E-03_JPRB,0.79062E-03_JPRB,0.68516E-03_JPRB,0.57878E-03_JPRB, &
 & 0.49035E-03_JPRB,0.39066E-03_JPRB,0.28990E-03_JPRB,0.26192E-03_JPRB /)  
KA(:, 2, 7,12) = (/ &
 & 0.10509E-02_JPRB,0.91972E-03_JPRB,0.79894E-03_JPRB,0.69452E-03_JPRB,0.59953E-03_JPRB, &
 & 0.51487E-03_JPRB,0.42128E-03_JPRB,0.33451E-03_JPRB,0.33284E-03_JPRB /)  
KA(:, 3, 7,12) = (/ &
 & 0.10507E-02_JPRB,0.91957E-03_JPRB,0.80398E-03_JPRB,0.71157E-03_JPRB,0.62221E-03_JPRB, &
 & 0.54150E-03_JPRB,0.46197E-03_JPRB,0.39208E-03_JPRB,0.41685E-03_JPRB /)  
KA(:, 4, 7,12) = (/ &
 & 0.10509E-02_JPRB,0.91973E-03_JPRB,0.80950E-03_JPRB,0.73042E-03_JPRB,0.64659E-03_JPRB, &
 & 0.57916E-03_JPRB,0.51360E-03_JPRB,0.46065E-03_JPRB,0.50813E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART8',1,ZHOOK_HANDLE)
END SUBROUTINE PART8


SUBROUTINE PART9

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART9',0,ZHOOK_HANDLE)


KA(:, 5, 7,12) = (/ &
 & 0.10509E-02_JPRB,0.91978E-03_JPRB,0.82196E-03_JPRB,0.75027E-03_JPRB,0.67740E-03_JPRB, &
 & 0.62606E-03_JPRB,0.57168E-03_JPRB,0.53418E-03_JPRB,0.60461E-03_JPRB /)  
KA(:, 1, 8,12) = (/ &
 & 0.10710E-02_JPRB,0.93729E-03_JPRB,0.80929E-03_JPRB,0.70366E-03_JPRB,0.59621E-03_JPRB, &
 & 0.50074E-03_JPRB,0.39602E-03_JPRB,0.28309E-03_JPRB,0.22630E-03_JPRB /)  
KA(:, 2, 8,12) = (/ &
 & 0.10749E-02_JPRB,0.94069E-03_JPRB,0.82032E-03_JPRB,0.71447E-03_JPRB,0.61694E-03_JPRB, &
 & 0.52833E-03_JPRB,0.42406E-03_JPRB,0.32400E-03_JPRB,0.29100E-03_JPRB /)  
KA(:, 3, 8,12) = (/ &
 & 0.10773E-02_JPRB,0.94281E-03_JPRB,0.82736E-03_JPRB,0.73051E-03_JPRB,0.64296E-03_JPRB, &
 & 0.55298E-03_JPRB,0.46605E-03_JPRB,0.37591E-03_JPRB,0.36869E-03_JPRB /)  
KA(:, 4, 8,12) = (/ &
 & 0.10796E-02_JPRB,0.94487E-03_JPRB,0.83459E-03_JPRB,0.75111E-03_JPRB,0.66786E-03_JPRB, &
 & 0.59048E-03_JPRB,0.51603E-03_JPRB,0.43920E-03_JPRB,0.45502E-03_JPRB /)  
KA(:, 5, 8,12) = (/ &
 & 0.10814E-02_JPRB,0.94726E-03_JPRB,0.84809E-03_JPRB,0.77185E-03_JPRB,0.69811E-03_JPRB, &
 & 0.64090E-03_JPRB,0.57338E-03_JPRB,0.50692E-03_JPRB,0.54643E-03_JPRB /)  
KA(:, 1, 9,12) = (/ &
 & 0.10730E-02_JPRB,0.93903E-03_JPRB,0.81373E-03_JPRB,0.70878E-03_JPRB,0.60523E-03_JPRB, &
 & 0.50463E-03_JPRB,0.39690E-03_JPRB,0.27640E-03_JPRB,0.19492E-03_JPRB /)  
KA(:, 2, 9,12) = (/ &
 & 0.10796E-02_JPRB,0.94482E-03_JPRB,0.82740E-03_JPRB,0.72216E-03_JPRB,0.62667E-03_JPRB, &
 & 0.53533E-03_JPRB,0.42406E-03_JPRB,0.31368E-03_JPRB,0.25100E-03_JPRB /)  
KA(:, 3, 9,12) = (/ &
 & 0.10853E-02_JPRB,0.94982E-03_JPRB,0.83742E-03_JPRB,0.73904E-03_JPRB,0.65592E-03_JPRB, &
 & 0.56092E-03_JPRB,0.46365E-03_JPRB,0.36183E-03_JPRB,0.32022E-03_JPRB /)  
KA(:, 4, 9,12) = (/ &
 & 0.10900E-02_JPRB,0.95441E-03_JPRB,0.84774E-03_JPRB,0.76272E-03_JPRB,0.68162E-03_JPRB, &
 & 0.59735E-03_JPRB,0.51414E-03_JPRB,0.41927E-03_JPRB,0.39972E-03_JPRB /)  
KA(:, 5, 9,12) = (/ &
 & 0.10952E-02_JPRB,0.96081E-03_JPRB,0.86364E-03_JPRB,0.78596E-03_JPRB,0.71341E-03_JPRB, &
 & 0.64539E-03_JPRB,0.57286E-03_JPRB,0.48249E-03_JPRB,0.48653E-03_JPRB /)  
KA(:, 1,10,12) = (/ &
 & 0.10558E-02_JPRB,0.92391E-03_JPRB,0.80426E-03_JPRB,0.70294E-03_JPRB,0.60555E-03_JPRB, &
 & 0.50218E-03_JPRB,0.39384E-03_JPRB,0.27052E-03_JPRB,0.17175E-03_JPRB /)  
KA(:, 2,10,12) = (/ &
 & 0.10672E-02_JPRB,0.93391E-03_JPRB,0.82187E-03_JPRB,0.72055E-03_JPRB,0.62861E-03_JPRB, &
 & 0.53517E-03_JPRB,0.42394E-03_JPRB,0.30520E-03_JPRB,0.22066E-03_JPRB /)  
KA(:, 3,10,12) = (/ &
 & 0.10767E-02_JPRB,0.94234E-03_JPRB,0.83636E-03_JPRB,0.73971E-03_JPRB,0.66074E-03_JPRB, &
 & 0.56459E-03_JPRB,0.46058E-03_JPRB,0.35232E-03_JPRB,0.28101E-03_JPRB /)  
KA(:, 4,10,12) = (/ &
 & 0.10858E-02_JPRB,0.95208E-03_JPRB,0.85075E-03_JPRB,0.76653E-03_JPRB,0.68963E-03_JPRB, &
 & 0.60125E-03_JPRB,0.51089E-03_JPRB,0.40664E-03_JPRB,0.35284E-03_JPRB /)  
KA(:, 5,10,12) = (/ &
 & 0.10953E-02_JPRB,0.96285E-03_JPRB,0.86971E-03_JPRB,0.79369E-03_JPRB,0.72347E-03_JPRB, &
 & 0.65043E-03_JPRB,0.57028E-03_JPRB,0.46529E-03_JPRB,0.43428E-03_JPRB /)  
KA(:, 1,11,12) = (/ &
 & 0.10314E-02_JPRB,0.90258E-03_JPRB,0.79467E-03_JPRB,0.69943E-03_JPRB,0.60546E-03_JPRB, &
 & 0.50625E-03_JPRB,0.39977E-03_JPRB,0.27736E-03_JPRB,0.16855E-03_JPRB /)  
KA(:, 2,11,12) = (/ &
 & 0.10451E-02_JPRB,0.91471E-03_JPRB,0.81404E-03_JPRB,0.71994E-03_JPRB,0.63569E-03_JPRB, &
 & 0.54231E-03_JPRB,0.43348E-03_JPRB,0.31480E-03_JPRB,0.21751E-03_JPRB /)  
KA(:, 3,11,12) = (/ &
 & 0.10591E-02_JPRB,0.92888E-03_JPRB,0.83171E-03_JPRB,0.74582E-03_JPRB,0.67129E-03_JPRB, &
 & 0.57545E-03_JPRB,0.47649E-03_JPRB,0.36327E-03_JPRB,0.27482E-03_JPRB /)  
KA(:, 4,11,12) = (/ &
 & 0.10732E-02_JPRB,0.94400E-03_JPRB,0.85133E-03_JPRB,0.77904E-03_JPRB,0.70324E-03_JPRB, &
 & 0.62021E-03_JPRB,0.53030E-03_JPRB,0.41771E-03_JPRB,0.34284E-03_JPRB /)  
KA(:, 5,11,12) = (/ &
 & 0.10880E-02_JPRB,0.96010E-03_JPRB,0.87843E-03_JPRB,0.80902E-03_JPRB,0.74479E-03_JPRB, &
 & 0.67711E-03_JPRB,0.59146E-03_JPRB,0.47518E-03_JPRB,0.42405E-03_JPRB /)  
KA(:, 1,12,12) = (/ &
 & 0.99800E-03_JPRB,0.87344E-03_JPRB,0.77838E-03_JPRB,0.69077E-03_JPRB,0.60021E-03_JPRB, &
 & 0.50540E-03_JPRB,0.40237E-03_JPRB,0.28326E-03_JPRB,0.16340E-03_JPRB /)  
KA(:, 2,12,12) = (/ &
 & 0.10163E-02_JPRB,0.89149E-03_JPRB,0.80050E-03_JPRB,0.71513E-03_JPRB,0.63616E-03_JPRB, &
 & 0.54455E-03_JPRB,0.44056E-03_JPRB,0.32235E-03_JPRB,0.21276E-03_JPRB /)  
KA(:, 3,12,12) = (/ &
 & 0.10345E-02_JPRB,0.91067E-03_JPRB,0.82237E-03_JPRB,0.74899E-03_JPRB,0.67503E-03_JPRB, &
 & 0.58381E-03_JPRB,0.48916E-03_JPRB,0.37171E-03_JPRB,0.26817E-03_JPRB /)  
KA(:, 4,12,12) = (/ &
 & 0.10541E-02_JPRB,0.93146E-03_JPRB,0.84943E-03_JPRB,0.78581E-03_JPRB,0.71327E-03_JPRB, &
 & 0.63724E-03_JPRB,0.54703E-03_JPRB,0.42621E-03_JPRB,0.33361E-03_JPRB /)  
KA(:, 5,12,12) = (/ &
 & 0.10724E-02_JPRB,0.95127E-03_JPRB,0.88178E-03_JPRB,0.82065E-03_JPRB,0.76248E-03_JPRB, &
 & 0.70028E-03_JPRB,0.60892E-03_JPRB,0.48179E-03_JPRB,0.41458E-03_JPRB /)  
KA(:, 1,13,12) = (/ &
 & 0.95912E-03_JPRB,0.84178E-03_JPRB,0.75778E-03_JPRB,0.67765E-03_JPRB,0.59123E-03_JPRB, &
 & 0.50112E-03_JPRB,0.40170E-03_JPRB,0.28784E-03_JPRB,0.15761E-03_JPRB /)  
KA(:, 2,13,12) = (/ &
 & 0.98187E-03_JPRB,0.86541E-03_JPRB,0.78344E-03_JPRB,0.70851E-03_JPRB,0.63200E-03_JPRB, &
 & 0.54351E-03_JPRB,0.44541E-03_JPRB,0.32864E-03_JPRB,0.20682E-03_JPRB /)  
KA(:, 3,13,12) = (/ &
 & 0.10063E-02_JPRB,0.89078E-03_JPRB,0.81111E-03_JPRB,0.74766E-03_JPRB,0.67473E-03_JPRB, &
 & 0.58963E-03_JPRB,0.49872E-03_JPRB,0.37736E-03_JPRB,0.26208E-03_JPRB /)  
KA(:, 4,13,12) = (/ &
 & 0.10299E-02_JPRB,0.91565E-03_JPRB,0.84455E-03_JPRB,0.78769E-03_JPRB,0.71894E-03_JPRB, &
 & 0.65012E-03_JPRB,0.55995E-03_JPRB,0.43170E-03_JPRB,0.32660E-03_JPRB /)  
KA(:, 5,13,12) = (/ &
 & 0.10525E-02_JPRB,0.93912E-03_JPRB,0.88061E-03_JPRB,0.82863E-03_JPRB,0.77810E-03_JPRB, &
 & 0.71766E-03_JPRB,0.62330E-03_JPRB,0.48589E-03_JPRB,0.40661E-03_JPRB /)  
KA(:, 1, 1,13) = (/ &
 & 0.84224E-03_JPRB,0.73740E-03_JPRB,0.63257E-03_JPRB,0.54853E-03_JPRB,0.48911E-03_JPRB, &
 & 0.46139E-03_JPRB,0.45309E-03_JPRB,0.51018E-03_JPRB,0.59300E-03_JPRB /)  
KA(:, 2, 1,13) = (/ &
 & 0.83841E-03_JPRB,0.73411E-03_JPRB,0.62983E-03_JPRB,0.55802E-03_JPRB,0.51855E-03_JPRB, &
 & 0.50261E-03_JPRB,0.52209E-03_JPRB,0.59394E-03_JPRB,0.69158E-03_JPRB /)  
KA(:, 3, 1,13) = (/ &
 & 0.83593E-03_JPRB,0.73202E-03_JPRB,0.62914E-03_JPRB,0.58596E-03_JPRB,0.54957E-03_JPRB, &
 & 0.55151E-03_JPRB,0.60969E-03_JPRB,0.69097E-03_JPRB,0.80707E-03_JPRB /)  
KA(:, 4, 1,13) = (/ &
 & 0.83246E-03_JPRB,0.72902E-03_JPRB,0.63274E-03_JPRB,0.60961E-03_JPRB,0.59022E-03_JPRB, &
 & 0.61063E-03_JPRB,0.70961E-03_JPRB,0.80207E-03_JPRB,0.93855E-03_JPRB /)  
KA(:, 5, 1,13) = (/ &
 & 0.82958E-03_JPRB,0.72654E-03_JPRB,0.65011E-03_JPRB,0.63711E-03_JPRB,0.63941E-03_JPRB, &
 & 0.69313E-03_JPRB,0.82070E-03_JPRB,0.92941E-03_JPRB,0.10860E-02_JPRB /)  
KA(:, 1, 2,13) = (/ &
 & 0.94737E-03_JPRB,0.82928E-03_JPRB,0.71121E-03_JPRB,0.61292E-03_JPRB,0.53888E-03_JPRB, &
 & 0.49608E-03_JPRB,0.46449E-03_JPRB,0.50895E-03_JPRB,0.59638E-03_JPRB /)  
KA(:, 2, 2,13) = (/ &
 & 0.94309E-03_JPRB,0.82559E-03_JPRB,0.70809E-03_JPRB,0.61981E-03_JPRB,0.56880E-03_JPRB, &
 & 0.53738E-03_JPRB,0.52906E-03_JPRB,0.59714E-03_JPRB,0.70098E-03_JPRB /)  
KA(:, 3, 2,13) = (/ &
 & 0.93813E-03_JPRB,0.82131E-03_JPRB,0.70667E-03_JPRB,0.64442E-03_JPRB,0.60095E-03_JPRB, &
 & 0.58581E-03_JPRB,0.62140E-03_JPRB,0.70455E-03_JPRB,0.83109E-03_JPRB /)  
KA(:, 4, 2,13) = (/ &
 & 0.93357E-03_JPRB,0.81735E-03_JPRB,0.70879E-03_JPRB,0.66885E-03_JPRB,0.63704E-03_JPRB, &
 & 0.64975E-03_JPRB,0.73250E-03_JPRB,0.82836E-03_JPRB,0.97995E-03_JPRB /)  
KA(:, 5, 2,13) = (/ &
 & 0.92926E-03_JPRB,0.81362E-03_JPRB,0.72487E-03_JPRB,0.69759E-03_JPRB,0.68443E-03_JPRB, &
 & 0.72989E-03_JPRB,0.85114E-03_JPRB,0.96045E-03_JPRB,0.11390E-02_JPRB /)  
KA(:, 1, 3,13) = (/ &
 & 0.10589E-02_JPRB,0.92685E-03_JPRB,0.79478E-03_JPRB,0.68185E-03_JPRB,0.58961E-03_JPRB, &
 & 0.52592E-03_JPRB,0.47382E-03_JPRB,0.49304E-03_JPRB,0.58474E-03_JPRB /)  
KA(:, 2, 3,13) = (/ &
 & 0.10532E-02_JPRB,0.92189E-03_JPRB,0.79057E-03_JPRB,0.68536E-03_JPRB,0.61794E-03_JPRB, &
 & 0.56535E-03_JPRB,0.53040E-03_JPRB,0.57934E-03_JPRB,0.68761E-03_JPRB /)  
KA(:, 3, 3,13) = (/ &
 & 0.10466E-02_JPRB,0.91613E-03_JPRB,0.78805E-03_JPRB,0.70517E-03_JPRB,0.65240E-03_JPRB, &
 & 0.61071E-03_JPRB,0.61067E-03_JPRB,0.68776E-03_JPRB,0.81827E-03_JPRB /)  
KA(:, 4, 3,13) = (/ &
 & 0.10406E-02_JPRB,0.91088E-03_JPRB,0.78949E-03_JPRB,0.73011E-03_JPRB,0.68643E-03_JPRB, &
 & 0.67486E-03_JPRB,0.72316E-03_JPRB,0.82048E-03_JPRB,0.97591E-03_JPRB /)  
KA(:, 5, 3,13) = (/ &
 & 0.10350E-02_JPRB,0.90609E-03_JPRB,0.80184E-03_JPRB,0.75651E-03_JPRB,0.73102E-03_JPRB, &
 & 0.75672E-03_JPRB,0.85035E-03_JPRB,0.96398E-03_JPRB,0.11483E-02_JPRB /)  
KA(:, 1, 4,13) = (/ &
 & 0.11788E-02_JPRB,0.10317E-02_JPRB,0.88462E-03_JPRB,0.75562E-03_JPRB,0.64370E-03_JPRB, &
 & 0.55868E-03_JPRB,0.48899E-03_JPRB,0.48008E-03_JPRB,0.57112E-03_JPRB /)  
KA(:, 2, 4,13) = (/ &
 & 0.11725E-02_JPRB,0.10263E-02_JPRB,0.87998E-03_JPRB,0.75781E-03_JPRB,0.66989E-03_JPRB, &
 & 0.59814E-03_JPRB,0.54177E-03_JPRB,0.56164E-03_JPRB,0.66999E-03_JPRB /)  
KA(:, 3, 4,13) = (/ &
 & 0.11654E-02_JPRB,0.10201E-02_JPRB,0.87720E-03_JPRB,0.76990E-03_JPRB,0.70381E-03_JPRB, &
 & 0.63928E-03_JPRB,0.60787E-03_JPRB,0.66447E-03_JPRB,0.79300E-03_JPRB /)  
KA(:, 4, 4,13) = (/ &
 & 0.11592E-02_JPRB,0.10147E-02_JPRB,0.87854E-03_JPRB,0.79340E-03_JPRB,0.73787E-03_JPRB, &
 & 0.69602E-03_JPRB,0.70539E-03_JPRB,0.79266E-03_JPRB,0.94522E-03_JPRB /)  
KA(:, 5, 4,13) = (/ &
 & 0.11532E-02_JPRB,0.10094E-02_JPRB,0.88452E-03_JPRB,0.81797E-03_JPRB,0.78065E-03_JPRB, &
 & 0.77762E-03_JPRB,0.82734E-03_JPRB,0.94053E-03_JPRB,0.11199E-02_JPRB /)  
KA(:, 1, 5,13) = (/ &
 & 0.13090E-02_JPRB,0.11455E-02_JPRB,0.98213E-03_JPRB,0.83571E-03_JPRB,0.70447E-03_JPRB, &
 & 0.59736E-03_JPRB,0.51100E-03_JPRB,0.46541E-03_JPRB,0.54756E-03_JPRB /)  
KA(:, 2, 5,13) = (/ &
 & 0.13011E-02_JPRB,0.11387E-02_JPRB,0.97633E-03_JPRB,0.83818E-03_JPRB,0.72563E-03_JPRB, &
 & 0.63146E-03_JPRB,0.56040E-03_JPRB,0.54671E-03_JPRB,0.65045E-03_JPRB /)  
KA(:, 3, 5,13) = (/ &
 & 0.12919E-02_JPRB,0.11307E-02_JPRB,0.97249E-03_JPRB,0.84355E-03_JPRB,0.75615E-03_JPRB, &
 & 0.67456E-03_JPRB,0.62106E-03_JPRB,0.64503E-03_JPRB,0.77294E-03_JPRB /)  
KA(:, 4, 5,13) = (/ &
 & 0.12834E-02_JPRB,0.11233E-02_JPRB,0.97228E-03_JPRB,0.86290E-03_JPRB,0.79001E-03_JPRB, &
 & 0.72644E-03_JPRB,0.70406E-03_JPRB,0.76742E-03_JPRB,0.92034E-03_JPRB /)  
KA(:, 5, 5,13) = (/ &
 & 0.12754E-02_JPRB,0.11163E-02_JPRB,0.97447E-03_JPRB,0.88787E-03_JPRB,0.82956E-03_JPRB, &
 & 0.80041E-03_JPRB,0.81433E-03_JPRB,0.91302E-03_JPRB,0.10923E-02_JPRB /)  
KA(:, 1, 6,13) = (/ &
 & 0.14384E-02_JPRB,0.12588E-02_JPRB,0.10791E-02_JPRB,0.91745E-03_JPRB,0.77222E-03_JPRB, &
 & 0.63777E-03_JPRB,0.53552E-03_JPRB,0.44917E-03_JPRB,0.50804E-03_JPRB /)  
KA(:, 2, 6,13) = (/ &
 & 0.14296E-02_JPRB,0.12511E-02_JPRB,0.10726E-02_JPRB,0.92106E-03_JPRB,0.78721E-03_JPRB, &
 & 0.67056E-03_JPRB,0.58135E-03_JPRB,0.52600E-03_JPRB,0.61657E-03_JPRB /)  
KA(:, 3, 6,13) = (/ &
 & 0.14197E-02_JPRB,0.12425E-02_JPRB,0.10687E-02_JPRB,0.92311E-03_JPRB,0.81466E-03_JPRB, &
 & 0.70925E-03_JPRB,0.63651E-03_JPRB,0.62263E-03_JPRB,0.74116E-03_JPRB /)  
KA(:, 4, 6,13) = (/ &
 & 0.14113E-02_JPRB,0.12351E-02_JPRB,0.10686E-02_JPRB,0.93888E-03_JPRB,0.84557E-03_JPRB, &
 & 0.75721E-03_JPRB,0.71295E-03_JPRB,0.74435E-03_JPRB,0.88914E-03_JPRB /)  
KA(:, 5, 6,13) = (/ &
 & 0.14033E-02_JPRB,0.12282E-02_JPRB,0.10694E-02_JPRB,0.96147E-03_JPRB,0.87768E-03_JPRB, &
 & 0.82519E-03_JPRB,0.81219E-03_JPRB,0.88552E-03_JPRB,0.10599E-02_JPRB /)  
KA(:, 1, 7,13) = (/ &
 & 0.15646E-02_JPRB,0.13692E-02_JPRB,0.11737E-02_JPRB,0.99670E-03_JPRB,0.83910E-03_JPRB, &
 & 0.68337E-03_JPRB,0.56133E-03_JPRB,0.43784E-03_JPRB,0.46053E-03_JPRB /)  
KA(:, 2, 7,13) = (/ &
 & 0.15575E-02_JPRB,0.13630E-02_JPRB,0.11685E-02_JPRB,0.10035E-02_JPRB,0.85062E-03_JPRB, &
 & 0.71436E-03_JPRB,0.60284E-03_JPRB,0.50378E-03_JPRB,0.56665E-03_JPRB /)  
KA(:, 3, 7,13) = (/ &
 & 0.15495E-02_JPRB,0.13560E-02_JPRB,0.11666E-02_JPRB,0.10059E-02_JPRB,0.87670E-03_JPRB, &
 & 0.74963E-03_JPRB,0.65339E-03_JPRB,0.59583E-03_JPRB,0.69467E-03_JPRB /)  
KA(:, 4, 7,13) = (/ &
 & 0.15420E-02_JPRB,0.13494E-02_JPRB,0.11678E-02_JPRB,0.10189E-02_JPRB,0.90417E-03_JPRB, &
 & 0.79237E-03_JPRB,0.72265E-03_JPRB,0.71412E-03_JPRB,0.84581E-03_JPRB /)  
KA(:, 5, 7,13) = (/ &
 & 0.15345E-02_JPRB,0.13429E-02_JPRB,0.11695E-02_JPRB,0.10414E-02_JPRB,0.93588E-03_JPRB, &
 & 0.84978E-03_JPRB,0.81799E-03_JPRB,0.85682E-03_JPRB,0.10184E-02_JPRB /)  
KA(:, 1, 8,13) = (/ &
 & 0.16856E-02_JPRB,0.14750E-02_JPRB,0.12645E-02_JPRB,0.10725E-02_JPRB,0.90201E-03_JPRB, &
 & 0.73159E-03_JPRB,0.58478E-03_JPRB,0.43268E-03_JPRB,0.41101E-03_JPRB /)  
KA(:, 2, 8,13) = (/ &
 & 0.16806E-02_JPRB,0.14706E-02_JPRB,0.12609E-02_JPRB,0.10836E-02_JPRB,0.91363E-03_JPRB, &
 & 0.76033E-03_JPRB,0.62810E-03_JPRB,0.48786E-03_JPRB,0.51346E-03_JPRB /)  
KA(:, 3, 8,13) = (/ &
 & 0.16744E-02_JPRB,0.14652E-02_JPRB,0.12612E-02_JPRB,0.10887E-02_JPRB,0.93599E-03_JPRB, &
 & 0.79815E-03_JPRB,0.66916E-03_JPRB,0.56926E-03_JPRB,0.63978E-03_JPRB /)  
KA(:, 4, 8,13) = (/ &
 & 0.16684E-02_JPRB,0.14601E-02_JPRB,0.12641E-02_JPRB,0.11000E-02_JPRB,0.96490E-03_JPRB, &
 & 0.83543E-03_JPRB,0.73243E-03_JPRB,0.67845E-03_JPRB,0.78892E-03_JPRB /)  
KA(:, 5, 8,13) = (/ &
 & 0.16618E-02_JPRB,0.14543E-02_JPRB,0.12671E-02_JPRB,0.11238E-02_JPRB,0.99451E-03_JPRB, &
 & 0.88426E-03_JPRB,0.81935E-03_JPRB,0.81741E-03_JPRB,0.96330E-03_JPRB /)  
KA(:, 1, 9,13) = (/ &
 & 0.17934E-02_JPRB,0.15694E-02_JPRB,0.13453E-02_JPRB,0.11410E-02_JPRB,0.95885E-03_JPRB, &
 & 0.77818E-03_JPRB,0.60653E-03_JPRB,0.43079E-03_JPRB,0.36156E-03_JPRB /)  
KA(:, 2, 9,13) = (/ &
 & 0.17902E-02_JPRB,0.15666E-02_JPRB,0.13435E-02_JPRB,0.11557E-02_JPRB,0.97291E-03_JPRB, &
 & 0.80328E-03_JPRB,0.65101E-03_JPRB,0.47930E-03_JPRB,0.45791E-03_JPRB /)  
KA(:, 3, 9,13) = (/ &
 & 0.17870E-02_JPRB,0.15637E-02_JPRB,0.13465E-02_JPRB,0.11644E-02_JPRB,0.99290E-03_JPRB, &
 & 0.84365E-03_JPRB,0.69043E-03_JPRB,0.54887E-03_JPRB,0.58027E-03_JPRB /)  
KA(:, 4, 9,13) = (/ &
 & 0.17836E-02_JPRB,0.15608E-02_JPRB,0.13520E-02_JPRB,0.11761E-02_JPRB,0.10245E-02_JPRB, &
 & 0.87956E-03_JPRB,0.74487E-03_JPRB,0.64626E-03_JPRB,0.72649E-03_JPRB /)  
KA(:, 5, 9,13) = (/ &
 & 0.17784E-02_JPRB,0.15563E-02_JPRB,0.13567E-02_JPRB,0.11994E-02_JPRB,0.10543E-02_JPRB, &
 & 0.92517E-03_JPRB,0.82194E-03_JPRB,0.77306E-03_JPRB,0.89652E-03_JPRB /)  
KA(:, 1,10,13) = (/ &
 & 0.18870E-02_JPRB,0.16513E-02_JPRB,0.14155E-02_JPRB,0.12026E-02_JPRB,0.10094E-02_JPRB, &
 & 0.82157E-03_JPRB,0.62812E-03_JPRB,0.43279E-03_JPRB,0.32100E-03_JPRB /)  
KA(:, 2,10,13) = (/ &
 & 0.18874E-02_JPRB,0.16516E-02_JPRB,0.14168E-02_JPRB,0.12199E-02_JPRB,0.10267E-02_JPRB, &
 & 0.84527E-03_JPRB,0.67192E-03_JPRB,0.47951E-03_JPRB,0.41207E-03_JPRB /)  
KA(:, 3,10,13) = (/ &
 & 0.18869E-02_JPRB,0.16512E-02_JPRB,0.14226E-02_JPRB,0.12326E-02_JPRB,0.10456E-02_JPRB, &
 & 0.88603E-03_JPRB,0.71450E-03_JPRB,0.53998E-03_JPRB,0.52708E-03_JPRB /)  
KA(:, 4,10,13) = (/ &
 & 0.18844E-02_JPRB,0.16490E-02_JPRB,0.14297E-02_JPRB,0.12452E-02_JPRB,0.10784E-02_JPRB, &
 & 0.92565E-03_JPRB,0.76291E-03_JPRB,0.62910E-03_JPRB,0.66842E-03_JPRB /)  
KA(:, 5,10,13) = (/ &
 & 0.18812E-02_JPRB,0.16463E-02_JPRB,0.14369E-02_JPRB,0.12677E-02_JPRB,0.11133E-02_JPRB, &
 & 0.96733E-03_JPRB,0.83676E-03_JPRB,0.74378E-03_JPRB,0.83514E-03_JPRB /)  
KA(:, 1,11,13) = (/ &
 & 0.19652E-02_JPRB,0.17197E-02_JPRB,0.14741E-02_JPRB,0.12638E-02_JPRB,0.10628E-02_JPRB, &
 & 0.86832E-03_JPRB,0.66314E-03_JPRB,0.45418E-03_JPRB,0.32052E-03_JPRB /)  
KA(:, 2,11,13) = (/ &
 & 0.19706E-02_JPRB,0.17244E-02_JPRB,0.14828E-02_JPRB,0.12836E-02_JPRB,0.10826E-02_JPRB, &
 & 0.89693E-03_JPRB,0.71120E-03_JPRB,0.50274E-03_JPRB,0.41269E-03_JPRB /)  
KA(:, 3,11,13) = (/ &
 & 0.19727E-02_JPRB,0.17263E-02_JPRB,0.14935E-02_JPRB,0.12979E-02_JPRB,0.11060E-02_JPRB, &
 & 0.94341E-03_JPRB,0.75411E-03_JPRB,0.56772E-03_JPRB,0.53374E-03_JPRB /)  
KA(:, 4,11,13) = (/ &
 & 0.19726E-02_JPRB,0.17262E-02_JPRB,0.15047E-02_JPRB,0.13132E-02_JPRB,0.11439E-02_JPRB, &
 & 0.98450E-03_JPRB,0.80814E-03_JPRB,0.66163E-03_JPRB,0.68012E-03_JPRB /)  
KA(:, 5,11,13) = (/ &
 & 0.19717E-02_JPRB,0.17254E-02_JPRB,0.15111E-02_JPRB,0.13415E-02_JPRB,0.11812E-02_JPRB, &
 & 0.10302E-02_JPRB,0.88976E-03_JPRB,0.77856E-03_JPRB,0.85217E-03_JPRB /)  
KA(:, 1,12,13) = (/ &
 & 0.20238E-02_JPRB,0.17709E-02_JPRB,0.15209E-02_JPRB,0.13140E-02_JPRB,0.11103E-02_JPRB, &
 & 0.90805E-03_JPRB,0.69487E-03_JPRB,0.47365E-03_JPRB,0.32170E-03_JPRB /)  
KA(:, 2,12,13) = (/ &
 & 0.20339E-02_JPRB,0.17798E-02_JPRB,0.15376E-02_JPRB,0.13369E-02_JPRB,0.11339E-02_JPRB, &
 & 0.94414E-03_JPRB,0.74487E-03_JPRB,0.52470E-03_JPRB,0.41340E-03_JPRB /)  
KA(:, 3,12,13) = (/ &
 & 0.20400E-02_JPRB,0.17851E-02_JPRB,0.15537E-02_JPRB,0.13538E-02_JPRB,0.11634E-02_JPRB, &
 & 0.99316E-03_JPRB,0.79139E-03_JPRB,0.59483E-03_JPRB,0.53800E-03_JPRB /)  
KA(:, 4,12,13) = (/ &
 & 0.20440E-02_JPRB,0.17887E-02_JPRB,0.15672E-02_JPRB,0.13751E-02_JPRB,0.12054E-02_JPRB, &
 & 0.10358E-02_JPRB,0.85239E-03_JPRB,0.69118E-03_JPRB,0.69062E-03_JPRB /)  
KA(:, 5,12,13) = (/ &
 & 0.20478E-02_JPRB,0.17920E-02_JPRB,0.15770E-02_JPRB,0.14084E-02_JPRB,0.12434E-02_JPRB, &
 & 0.10883E-02_JPRB,0.94102E-03_JPRB,0.81111E-03_JPRB,0.86624E-03_JPRB /)  
KA(:, 1,13,13) = (/ &
 & 0.20618E-02_JPRB,0.18042E-02_JPRB,0.15564E-02_JPRB,0.13520E-02_JPRB,0.11495E-02_JPRB, &
 & 0.94146E-03_JPRB,0.72197E-03_JPRB,0.49143E-03_JPRB,0.32080E-03_JPRB /)  
KA(:, 2,13,13) = (/ &
 & 0.20769E-02_JPRB,0.18174E-02_JPRB,0.15793E-02_JPRB,0.13781E-02_JPRB,0.11781E-02_JPRB, &
 & 0.98504E-03_JPRB,0.77410E-03_JPRB,0.54584E-03_JPRB,0.41409E-03_JPRB /)  
KA(:, 3,13,13) = (/ &
 & 0.20884E-02_JPRB,0.18274E-02_JPRB,0.16007E-02_JPRB,0.14008E-02_JPRB,0.12152E-02_JPRB, &
 & 0.10359E-02_JPRB,0.82528E-03_JPRB,0.62085E-03_JPRB,0.53970E-03_JPRB /)  
KA(:, 4,13,13) = (/ &
 & 0.21000E-02_JPRB,0.18376E-02_JPRB,0.16180E-02_JPRB,0.14292E-02_JPRB,0.12615E-02_JPRB, &
 & 0.10817E-02_JPRB,0.89457E-03_JPRB,0.71909E-03_JPRB,0.69474E-03_JPRB /)  
KA(:, 5,13,13) = (/ &
 & 0.21077E-02_JPRB,0.18456E-02_JPRB,0.16335E-02_JPRB,0.14673E-02_JPRB,0.12995E-02_JPRB, &
 & 0.11413E-02_JPRB,0.98821E-03_JPRB,0.84127E-03_JPRB,0.87402E-03_JPRB /)  
KA(:, 1, 1,14) = (/ &
 & 0.11199E-02_JPRB,0.98039E-03_JPRB,0.84084E-03_JPRB,0.70943E-03_JPRB,0.63603E-03_JPRB, &
 & 0.60649E-03_JPRB,0.68312E-03_JPRB,0.76350E-03_JPRB,0.90110E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART9',1,ZHOOK_HANDLE)
END SUBROUTINE PART9


SUBROUTINE PART10

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART10',0,ZHOOK_HANDLE)


KA(:, 2, 1,14) = (/ &
 & 0.11157E-02_JPRB,0.97670E-03_JPRB,0.83773E-03_JPRB,0.72395E-03_JPRB,0.68641E-03_JPRB, &
 & 0.69858E-03_JPRB,0.81907E-03_JPRB,0.92056E-03_JPRB,0.10823E-02_JPRB /)  
KA(:, 3, 1,14) = (/ &
 & 0.11108E-02_JPRB,0.97243E-03_JPRB,0.83426E-03_JPRB,0.74791E-03_JPRB,0.75340E-03_JPRB, &
 & 0.82026E-03_JPRB,0.97233E-03_JPRB,0.10968E-02_JPRB,0.12857E-02_JPRB /)  
KA(:, 4, 1,14) = (/ &
 & 0.11077E-02_JPRB,0.96981E-03_JPRB,0.83196E-03_JPRB,0.80006E-03_JPRB,0.82593E-03_JPRB, &
 & 0.96481E-03_JPRB,0.11451E-02_JPRB,0.12942E-02_JPRB,0.15153E-02_JPRB /)  
KA(:, 5, 1,14) = (/ &
 & 0.11057E-02_JPRB,0.96811E-03_JPRB,0.83287E-03_JPRB,0.85771E-03_JPRB,0.92243E-03_JPRB, &
 & 0.11291E-02_JPRB,0.13401E-02_JPRB,0.15139E-02_JPRB,0.17730E-02_JPRB /)  
KA(:, 1, 2,14) = (/ &
 & 0.12618E-02_JPRB,0.11045E-02_JPRB,0.94731E-03_JPRB,0.80059E-03_JPRB,0.70460E-03_JPRB, &
 & 0.66164E-03_JPRB,0.71798E-03_JPRB,0.80280E-03_JPRB,0.96182E-03_JPRB /)  
KA(:, 2, 2,14) = (/ &
 & 0.12573E-02_JPRB,0.11007E-02_JPRB,0.94415E-03_JPRB,0.81463E-03_JPRB,0.74844E-03_JPRB, &
 & 0.74157E-03_JPRB,0.85097E-03_JPRB,0.95625E-03_JPRB,0.11395E-02_JPRB /)  
KA(:, 3, 2,14) = (/ &
 & 0.12537E-02_JPRB,0.10976E-02_JPRB,0.94166E-03_JPRB,0.83421E-03_JPRB,0.81760E-03_JPRB, &
 & 0.85124E-03_JPRB,0.10029E-02_JPRB,0.11319E-02_JPRB,0.13421E-02_JPRB /)  
KA(:, 4, 2,14) = (/ &
 & 0.12517E-02_JPRB,0.10959E-02_JPRB,0.94019E-03_JPRB,0.88029E-03_JPRB,0.88890E-03_JPRB, &
 & 0.98937E-03_JPRB,0.11747E-02_JPRB,0.13301E-02_JPRB,0.15715E-02_JPRB /)  
KA(:, 5, 2,14) = (/ &
 & 0.12484E-02_JPRB,0.10932E-02_JPRB,0.93873E-03_JPRB,0.93946E-03_JPRB,0.97784E-03_JPRB, &
 & 0.11555E-02_JPRB,0.13735E-02_JPRB,0.15606E-02_JPRB,0.18367E-02_JPRB /)  
KA(:, 1, 3,14) = (/ &
 & 0.14334E-02_JPRB,0.12547E-02_JPRB,0.10760E-02_JPRB,0.90369E-03_JPRB,0.78163E-03_JPRB, &
 & 0.71064E-03_JPRB,0.72074E-03_JPRB,0.81006E-03_JPRB,0.97636E-03_JPRB /)  
KA(:, 2, 3,14) = (/ &
 & 0.14266E-02_JPRB,0.12488E-02_JPRB,0.10711E-02_JPRB,0.91657E-03_JPRB,0.81392E-03_JPRB, &
 & 0.78379E-03_JPRB,0.85758E-03_JPRB,0.96540E-03_JPRB,0.11622E-02_JPRB /)  
KA(:, 3, 3,14) = (/ &
 & 0.14223E-02_JPRB,0.12452E-02_JPRB,0.10680E-02_JPRB,0.93146E-03_JPRB,0.87510E-03_JPRB, &
 & 0.87756E-03_JPRB,0.10059E-02_JPRB,0.11359E-02_JPRB,0.13619E-02_JPRB /)  
KA(:, 4, 3,14) = (/ &
 & 0.14175E-02_JPRB,0.12411E-02_JPRB,0.10646E-02_JPRB,0.96483E-03_JPRB,0.94572E-03_JPRB, &
 & 0.99384E-03_JPRB,0.11710E-02_JPRB,0.13256E-02_JPRB,0.15838E-02_JPRB /)  
KA(:, 5, 3,14) = (/ &
 & 0.14120E-02_JPRB,0.12363E-02_JPRB,0.10614E-02_JPRB,0.10223E-02_JPRB,0.10225E-02_JPRB, &
 & 0.11461E-02_JPRB,0.13616E-02_JPRB,0.15455E-02_JPRB,0.18394E-02_JPRB /)  
KA(:, 1, 4,14) = (/ &
 & 0.16334E-02_JPRB,0.14296E-02_JPRB,0.12259E-02_JPRB,0.10262E-02_JPRB,0.87529E-03_JPRB, &
 & 0.76396E-03_JPRB,0.72119E-03_JPRB,0.79306E-03_JPRB,0.95651E-03_JPRB /)  
KA(:, 2, 4,14) = (/ &
 & 0.16232E-02_JPRB,0.14208E-02_JPRB,0.12185E-02_JPRB,0.10348E-02_JPRB,0.89367E-03_JPRB, &
 & 0.83199E-03_JPRB,0.84657E-03_JPRB,0.95561E-03_JPRB,0.11474E-02_JPRB /)  
KA(:, 3, 4,14) = (/ &
 & 0.16152E-02_JPRB,0.14140E-02_JPRB,0.12127E-02_JPRB,0.10485E-02_JPRB,0.94236E-03_JPRB, &
 & 0.91572E-03_JPRB,0.99902E-03_JPRB,0.11299E-02_JPRB,0.13583E-02_JPRB /)  
KA(:, 4, 4,14) = (/ &
 & 0.16069E-02_JPRB,0.14067E-02_JPRB,0.12065E-02_JPRB,0.10685E-02_JPRB,0.10126E-02_JPRB, &
 & 0.10172E-02_JPRB,0.11639E-02_JPRB,0.13179E-02_JPRB,0.15822E-02_JPRB /)  
KA(:, 5, 4,14) = (/ &
 & 0.15986E-02_JPRB,0.13996E-02_JPRB,0.12009E-02_JPRB,0.11161E-02_JPRB,0.10822E-02_JPRB, &
 & 0.11448E-02_JPRB,0.13482E-02_JPRB,0.15289E-02_JPRB,0.18307E-02_JPRB /)  
KA(:, 1, 5,14) = (/ &
 & 0.18523E-02_JPRB,0.16211E-02_JPRB,0.13900E-02_JPRB,0.11617E-02_JPRB,0.98609E-03_JPRB, &
 & 0.83071E-03_JPRB,0.73506E-03_JPRB,0.77421E-03_JPRB,0.93359E-03_JPRB /)  
KA(:, 2, 5,14) = (/ &
 & 0.18399E-02_JPRB,0.16104E-02_JPRB,0.13808E-02_JPRB,0.11680E-02_JPRB,0.99824E-03_JPRB, &
 & 0.89112E-03_JPRB,0.84383E-03_JPRB,0.93250E-03_JPRB,0.11210E-02_JPRB /)  
KA(:, 3, 5,14) = (/ &
 & 0.18296E-02_JPRB,0.16015E-02_JPRB,0.13734E-02_JPRB,0.11806E-02_JPRB,0.10315E-02_JPRB, &
 & 0.96812E-03_JPRB,0.98130E-03_JPRB,0.11095E-02_JPRB,0.13275E-02_JPRB /)  
KA(:, 4, 5,14) = (/ &
 & 0.18179E-02_JPRB,0.15913E-02_JPRB,0.13647E-02_JPRB,0.11924E-02_JPRB,0.10905E-02_JPRB, &
 & 0.10578E-02_JPRB,0.11513E-02_JPRB,0.13088E-02_JPRB,0.15638E-02_JPRB /)  
KA(:, 5, 5,14) = (/ &
 & 0.18067E-02_JPRB,0.15816E-02_JPRB,0.13575E-02_JPRB,0.12252E-02_JPRB,0.11627E-02_JPRB, &
 & 0.11690E-02_JPRB,0.13357E-02_JPRB,0.15168E-02_JPRB,0.18162E-02_JPRB /)  
KA(:, 1, 6,14) = (/ &
 & 0.20925E-02_JPRB,0.18312E-02_JPRB,0.15700E-02_JPRB,0.13095E-02_JPRB,0.11041E-02_JPRB, &
 & 0.91669E-03_JPRB,0.76437E-03_JPRB,0.75155E-03_JPRB,0.90862E-03_JPRB /)  
KA(:, 2, 6,14) = (/ &
 & 0.20749E-02_JPRB,0.18159E-02_JPRB,0.15569E-02_JPRB,0.13117E-02_JPRB,0.11170E-02_JPRB, &
 & 0.95740E-03_JPRB,0.85349E-03_JPRB,0.90211E-03_JPRB,0.10843E-02_JPRB /)  
KA(:, 3, 6,14) = (/ &
 & 0.20605E-02_JPRB,0.18034E-02_JPRB,0.15463E-02_JPRB,0.13221E-02_JPRB,0.11384E-02_JPRB, &
 & 0.10293E-02_JPRB,0.97333E-03_JPRB,0.10765E-02_JPRB,0.12853E-02_JPRB /)  
KA(:, 4, 6,14) = (/ &
 & 0.20459E-02_JPRB,0.17907E-02_JPRB,0.15355E-02_JPRB,0.13321E-02_JPRB,0.11878E-02_JPRB, &
 & 0.11138E-02_JPRB,0.11236E-02_JPRB,0.12716E-02_JPRB,0.15170E-02_JPRB /)  
KA(:, 5, 6,14) = (/ &
 & 0.20310E-02_JPRB,0.17778E-02_JPRB,0.15259E-02_JPRB,0.13542E-02_JPRB,0.12517E-02_JPRB, &
 & 0.12095E-02_JPRB,0.13081E-02_JPRB,0.14898E-02_JPRB,0.17755E-02_JPRB /)  
KA(:, 1, 7,14) = (/ &
 & 0.23595E-02_JPRB,0.20648E-02_JPRB,0.17701E-02_JPRB,0.14754E-02_JPRB,0.12323E-02_JPRB, &
 & 0.10132E-02_JPRB,0.80835E-03_JPRB,0.73377E-03_JPRB,0.88458E-03_JPRB /)  
KA(:, 2, 7,14) = (/ &
 & 0.23333E-02_JPRB,0.20420E-02_JPRB,0.17506E-02_JPRB,0.14700E-02_JPRB,0.12449E-02_JPRB, &
 & 0.10427E-02_JPRB,0.88482E-03_JPRB,0.87865E-03_JPRB,0.10548E-02_JPRB /)  
KA(:, 3, 7,14) = (/ &
 & 0.23118E-02_JPRB,0.20232E-02_JPRB,0.17345E-02_JPRB,0.14754E-02_JPRB,0.12581E-02_JPRB, &
 & 0.11040E-02_JPRB,0.98425E-03_JPRB,0.10425E-02_JPRB,0.12451E-02_JPRB /)  
KA(:, 4, 7,14) = (/ &
 & 0.22911E-02_JPRB,0.20052E-02_JPRB,0.17193E-02_JPRB,0.14831E-02_JPRB,0.12996E-02_JPRB, &
 & 0.11778E-02_JPRB,0.11137E-02_JPRB,0.12310E-02_JPRB,0.14656E-02_JPRB /)  
KA(:, 5, 7,14) = (/ &
 & 0.22715E-02_JPRB,0.19881E-02_JPRB,0.17061E-02_JPRB,0.14949E-02_JPRB,0.13595E-02_JPRB, &
 & 0.12702E-02_JPRB,0.12792E-02_JPRB,0.14480E-02_JPRB,0.17220E-02_JPRB /)  
KA(:, 1, 8,14) = (/ &
 & 0.26465E-02_JPRB,0.23159E-02_JPRB,0.19853E-02_JPRB,0.16547E-02_JPRB,0.13704E-02_JPRB, &
 & 0.11161E-02_JPRB,0.87227E-03_JPRB,0.72579E-03_JPRB,0.85316E-03_JPRB /)  
KA(:, 2, 8,14) = (/ &
 & 0.26139E-02_JPRB,0.22874E-02_JPRB,0.19609E-02_JPRB,0.16420E-02_JPRB,0.13837E-02_JPRB, &
 & 0.11377E-02_JPRB,0.93183E-03_JPRB,0.85926E-03_JPRB,0.10245E-02_JPRB /)  
KA(:, 3, 8,14) = (/ &
 & 0.25857E-02_JPRB,0.22628E-02_JPRB,0.19400E-02_JPRB,0.16425E-02_JPRB,0.13917E-02_JPRB, &
 & 0.11859E-02_JPRB,0.10228E-02_JPRB,0.10157E-02_JPRB,0.12103E-02_JPRB /)  
KA(:, 4, 8,14) = (/ &
 & 0.25573E-02_JPRB,0.22380E-02_JPRB,0.19187E-02_JPRB,0.16463E-02_JPRB,0.14196E-02_JPRB, &
 & 0.12582E-02_JPRB,0.11286E-02_JPRB,0.11958E-02_JPRB,0.14229E-02_JPRB /)  
KA(:, 5, 8,14) = (/ &
 & 0.25310E-02_JPRB,0.22151E-02_JPRB,0.19006E-02_JPRB,0.16478E-02_JPRB,0.14771E-02_JPRB, &
 & 0.13382E-02_JPRB,0.12711E-02_JPRB,0.14043E-02_JPRB,0.16688E-02_JPRB /)  
KA(:, 1, 9,14) = (/ &
 & 0.29437E-02_JPRB,0.25759E-02_JPRB,0.22081E-02_JPRB,0.18403E-02_JPRB,0.15126E-02_JPRB, &
 & 0.12266E-02_JPRB,0.94502E-03_JPRB,0.72553E-03_JPRB,0.80872E-03_JPRB /)  
KA(:, 2, 9,14) = (/ &
 & 0.29059E-02_JPRB,0.25428E-02_JPRB,0.21798E-02_JPRB,0.18221E-02_JPRB,0.15299E-02_JPRB, &
 & 0.12446E-02_JPRB,0.99114E-03_JPRB,0.84495E-03_JPRB,0.98123E-03_JPRB /)  
KA(:, 3, 9,14) = (/ &
 & 0.28735E-02_JPRB,0.25146E-02_JPRB,0.21557E-02_JPRB,0.18193E-02_JPRB,0.15373E-02_JPRB, &
 & 0.12770E-02_JPRB,0.10730E-02_JPRB,0.99151E-03_JPRB,0.11701E-02_JPRB /)  
KA(:, 4, 9,14) = (/ &
 & 0.28399E-02_JPRB,0.24853E-02_JPRB,0.21306E-02_JPRB,0.18209E-02_JPRB,0.15526E-02_JPRB, &
 & 0.13434E-02_JPRB,0.11682E-02_JPRB,0.11617E-02_JPRB,0.13773E-02_JPRB /)  
KA(:, 5, 9,14) = (/ &
 & 0.28070E-02_JPRB,0.24565E-02_JPRB,0.21073E-02_JPRB,0.18175E-02_JPRB,0.15973E-02_JPRB, &
 & 0.14179E-02_JPRB,0.12830E-02_JPRB,0.13638E-02_JPRB,0.16173E-02_JPRB /)  
KA(:, 1,10,14) = (/ &
 & 0.32399E-02_JPRB,0.28350E-02_JPRB,0.24302E-02_JPRB,0.20252E-02_JPRB,0.16589E-02_JPRB, &
 & 0.13407E-02_JPRB,0.10274E-02_JPRB,0.73986E-03_JPRB,0.76203E-03_JPRB /)  
KA(:, 2,10,14) = (/ &
 & 0.31965E-02_JPRB,0.27971E-02_JPRB,0.23977E-02_JPRB,0.20029E-02_JPRB,0.16776E-02_JPRB, &
 & 0.13600E-02_JPRB,0.10652E-02_JPRB,0.84551E-03_JPRB,0.93841E-03_JPRB /)  
KA(:, 3,10,14) = (/ &
 & 0.31601E-02_JPRB,0.27653E-02_JPRB,0.23707E-02_JPRB,0.19975E-02_JPRB,0.16883E-02_JPRB, &
 & 0.13843E-02_JPRB,0.11385E-02_JPRB,0.98230E-03_JPRB,0.11352E-02_JPRB /)  
KA(:, 4,10,14) = (/ &
 & 0.31230E-02_JPRB,0.27329E-02_JPRB,0.23428E-02_JPRB,0.19986E-02_JPRB,0.16986E-02_JPRB, &
 & 0.14381E-02_JPRB,0.12318E-02_JPRB,0.11431E-02_JPRB,0.13466E-02_JPRB /)  
KA(:, 5,10,14) = (/ &
 & 0.30838E-02_JPRB,0.26986E-02_JPRB,0.23157E-02_JPRB,0.19957E-02_JPRB,0.17285E-02_JPRB, &
 & 0.15111E-02_JPRB,0.13270E-02_JPRB,0.13396E-02_JPRB,0.15853E-02_JPRB /)  
KA(:, 1,11,14) = (/ &
 & 0.35110E-02_JPRB,0.30722E-02_JPRB,0.26335E-02_JPRB,0.21948E-02_JPRB,0.18129E-02_JPRB, &
 & 0.14641E-02_JPRB,0.11256E-02_JPRB,0.79561E-03_JPRB,0.78300E-03_JPRB /)  
KA(:, 2,11,14) = (/ &
 & 0.34682E-02_JPRB,0.30349E-02_JPRB,0.26015E-02_JPRB,0.21788E-02_JPRB,0.18300E-02_JPRB, &
 & 0.14846E-02_JPRB,0.11655E-02_JPRB,0.90541E-03_JPRB,0.97352E-03_JPRB /)  
KA(:, 3,11,14) = (/ &
 & 0.34263E-02_JPRB,0.29982E-02_JPRB,0.25700E-02_JPRB,0.21750E-02_JPRB,0.18411E-02_JPRB, &
 & 0.15104E-02_JPRB,0.12444E-02_JPRB,0.10462E-02_JPRB,0.11863E-02_JPRB /)  
KA(:, 4,11,14) = (/ &
 & 0.33817E-02_JPRB,0.29592E-02_JPRB,0.25369E-02_JPRB,0.21760E-02_JPRB,0.18525E-02_JPRB, &
 & 0.15666E-02_JPRB,0.13382E-02_JPRB,0.12088E-02_JPRB,0.14124E-02_JPRB /)  
KA(:, 5,11,14) = (/ &
 & 0.33351E-02_JPRB,0.29184E-02_JPRB,0.25088E-02_JPRB,0.21673E-02_JPRB,0.18858E-02_JPRB, &
 & 0.16404E-02_JPRB,0.14339E-02_JPRB,0.14160E-02_JPRB,0.16713E-02_JPRB /)  
KA(:, 1,12,14) = (/ &
 & 0.37813E-02_JPRB,0.33087E-02_JPRB,0.28362E-02_JPRB,0.23654E-02_JPRB,0.19642E-02_JPRB, &
 & 0.15868E-02_JPRB,0.12220E-02_JPRB,0.85134E-03_JPRB,0.79810E-03_JPRB /)  
KA(:, 2,12,14) = (/ &
 & 0.37337E-02_JPRB,0.32671E-02_JPRB,0.28006E-02_JPRB,0.23535E-02_JPRB,0.19812E-02_JPRB, &
 & 0.16073E-02_JPRB,0.12646E-02_JPRB,0.96230E-03_JPRB,0.10021E-02_JPRB /)  
KA(:, 3,12,14) = (/ &
 & 0.36838E-02_JPRB,0.32235E-02_JPRB,0.27633E-02_JPRB,0.23494E-02_JPRB,0.19898E-02_JPRB, &
 & 0.16363E-02_JPRB,0.13472E-02_JPRB,0.11056E-02_JPRB,0.12297E-02_JPRB /)  
KA(:, 4,12,14) = (/ &
 & 0.36315E-02_JPRB,0.31778E-02_JPRB,0.27268E-02_JPRB,0.23457E-02_JPRB,0.20010E-02_JPRB, &
 & 0.16953E-02_JPRB,0.14396E-02_JPRB,0.12736E-02_JPRB,0.14737E-02_JPRB /)  
KA(:, 5,12,14) = (/ &
 & 0.35780E-02_JPRB,0.31310E-02_JPRB,0.26962E-02_JPRB,0.23324E-02_JPRB,0.20383E-02_JPRB, &
 & 0.17680E-02_JPRB,0.15379E-02_JPRB,0.14913E-02_JPRB,0.17515E-02_JPRB /)  
KA(:, 1,13,14) = (/ &
 & 0.40401E-02_JPRB,0.35352E-02_JPRB,0.30303E-02_JPRB,0.25331E-02_JPRB,0.21125E-02_JPRB, &
 & 0.17061E-02_JPRB,0.13144E-02_JPRB,0.90469E-03_JPRB,0.81129E-03_JPRB /)  
KA(:, 2,13,14) = (/ &
 & 0.39897E-02_JPRB,0.34912E-02_JPRB,0.29926E-02_JPRB,0.25245E-02_JPRB,0.21272E-02_JPRB, &
 & 0.17273E-02_JPRB,0.13608E-02_JPRB,0.10148E-02_JPRB,0.10248E-02_JPRB /)  
KA(:, 3,13,14) = (/ &
 & 0.39313E-02_JPRB,0.34401E-02_JPRB,0.29487E-02_JPRB,0.25178E-02_JPRB,0.21303E-02_JPRB, &
 & 0.17587E-02_JPRB,0.14454E-02_JPRB,0.11592E-02_JPRB,0.12656E-02_JPRB /)  
KA(:, 4,13,14) = (/ &
 & 0.38694E-02_JPRB,0.33859E-02_JPRB,0.29093E-02_JPRB,0.25068E-02_JPRB,0.21412E-02_JPRB, &
 & 0.18203E-02_JPRB,0.15361E-02_JPRB,0.13357E-02_JPRB,0.15298E-02_JPRB /)  
KA(:, 5,13,14) = (/ &
 & 0.38109E-02_JPRB,0.33347E-02_JPRB,0.28761E-02_JPRB,0.24907E-02_JPRB,0.21821E-02_JPRB, &
 & 0.18916E-02_JPRB,0.16371E-02_JPRB,0.15629E-02_JPRB,0.18275E-02_JPRB /)  
KA(:, 1, 1,15) = (/ &
 & 0.15071E-02_JPRB,0.13191E-02_JPRB,0.11311E-02_JPRB,0.94313E-03_JPRB,0.82178E-03_JPRB, &
 & 0.90230E-03_JPRB,0.10652E-02_JPRB,0.11879E-02_JPRB,0.14045E-02_JPRB /)  
KA(:, 2, 1,15) = (/ &
 & 0.15053E-02_JPRB,0.13176E-02_JPRB,0.11298E-02_JPRB,0.94210E-03_JPRB,0.87562E-03_JPRB, &
 & 0.10432E-02_JPRB,0.12302E-02_JPRB,0.13664E-02_JPRB,0.16201E-02_JPRB /)  
KA(:, 3, 1,15) = (/ &
 & 0.15019E-02_JPRB,0.13147E-02_JPRB,0.11275E-02_JPRB,0.94187E-03_JPRB,0.97652E-03_JPRB, &
 & 0.12093E-02_JPRB,0.14252E-02_JPRB,0.15816E-02_JPRB,0.18766E-02_JPRB /)  
KA(:, 4, 1,15) = (/ &
 & 0.14976E-02_JPRB,0.13109E-02_JPRB,0.11243E-02_JPRB,0.96063E-03_JPRB,0.11391E-02_JPRB, &
 & 0.14106E-02_JPRB,0.16622E-02_JPRB,0.18446E-02_JPRB,0.21889E-02_JPRB /)  
KA(:, 5, 1,15) = (/ &
 & 0.14918E-02_JPRB,0.13060E-02_JPRB,0.11201E-02_JPRB,0.10256E-02_JPRB,0.13135E-02_JPRB, &
 & 0.16256E-02_JPRB,0.19138E-02_JPRB,0.21174E-02_JPRB,0.25177E-02_JPRB /)  
KA(:, 1, 2,15) = (/ &
 & 0.17368E-02_JPRB,0.15199E-02_JPRB,0.13031E-02_JPRB,0.10865E-02_JPRB,0.93589E-03_JPRB, &
 & 0.95913E-03_JPRB,0.11327E-02_JPRB,0.12643E-02_JPRB,0.15179E-02_JPRB /)  
KA(:, 2, 2,15) = (/ &
 & 0.17347E-02_JPRB,0.15183E-02_JPRB,0.13018E-02_JPRB,0.10853E-02_JPRB,0.98162E-03_JPRB, &
 & 0.11204E-02_JPRB,0.13214E-02_JPRB,0.14695E-02_JPRB,0.17719E-02_JPRB /)  
KA(:, 3, 2,15) = (/ &
 & 0.17301E-02_JPRB,0.15143E-02_JPRB,0.12982E-02_JPRB,0.10867E-02_JPRB,0.10624E-02_JPRB, &
 & 0.13058E-02_JPRB,0.15388E-02_JPRB,0.17088E-02_JPRB,0.20640E-02_JPRB /)  
KA(:, 4, 2,15) = (/ &
 & 0.17235E-02_JPRB,0.15085E-02_JPRB,0.12935E-02_JPRB,0.11059E-02_JPRB,0.12337E-02_JPRB, &
 & 0.15285E-02_JPRB,0.18009E-02_JPRB,0.19982E-02_JPRB,0.24152E-02_JPRB /)  
KA(:, 5, 2,15) = (/ &
 & 0.17181E-02_JPRB,0.15038E-02_JPRB,0.12895E-02_JPRB,0.11598E-02_JPRB,0.14379E-02_JPRB, &
 & 0.17807E-02_JPRB,0.20976E-02_JPRB,0.23230E-02_JPRB,0.28132E-02_JPRB /)  
KA(:, 1, 3,15) = (/ &
 & 0.19949E-02_JPRB,0.17458E-02_JPRB,0.14967E-02_JPRB,0.12475E-02_JPRB,0.10641E-02_JPRB, &
 & 0.10100E-02_JPRB,0.11774E-02_JPRB,0.13116E-02_JPRB,0.16051E-02_JPRB /)  
KA(:, 2, 3,15) = (/ &
 & 0.19910E-02_JPRB,0.17424E-02_JPRB,0.14939E-02_JPRB,0.12453E-02_JPRB,0.11049E-02_JPRB, &
 & 0.11564E-02_JPRB,0.13657E-02_JPRB,0.15222E-02_JPRB,0.18601E-02_JPRB /)  
KA(:, 3, 3,15) = (/ &
 & 0.19848E-02_JPRB,0.17370E-02_JPRB,0.14892E-02_JPRB,0.12476E-02_JPRB,0.11571E-02_JPRB, &
 & 0.13573E-02_JPRB,0.16014E-02_JPRB,0.17817E-02_JPRB,0.21839E-02_JPRB /)  
KA(:, 4, 3,15) = (/ &
 & 0.19813E-02_JPRB,0.17340E-02_JPRB,0.14867E-02_JPRB,0.12671E-02_JPRB,0.12941E-02_JPRB, &
 & 0.15954E-02_JPRB,0.18821E-02_JPRB,0.20919E-02_JPRB,0.25670E-02_JPRB /)  
KA(:, 5, 3,15) = (/ &
 & 0.19771E-02_JPRB,0.17304E-02_JPRB,0.14836E-02_JPRB,0.13013E-02_JPRB,0.15091E-02_JPRB, &
 & 0.18697E-02_JPRB,0.22058E-02_JPRB,0.24525E-02_JPRB,0.30084E-02_JPRB /)  
KA(:, 1, 4,15) = (/ &
 & 0.23002E-02_JPRB,0.20126E-02_JPRB,0.17253E-02_JPRB,0.14382E-02_JPRB,0.12005E-02_JPRB, &
 & 0.10932E-02_JPRB,0.12228E-02_JPRB,0.13639E-02_JPRB,0.16798E-02_JPRB /)  
KA(:, 2, 4,15) = (/ &
 & 0.22929E-02_JPRB,0.20065E-02_JPRB,0.17201E-02_JPRB,0.14337E-02_JPRB,0.12491E-02_JPRB, &
 & 0.11967E-02_JPRB,0.14046E-02_JPRB,0.15632E-02_JPRB,0.19322E-02_JPRB /)  
KA(:, 3, 4,15) = (/ &
 & 0.22828E-02_JPRB,0.19977E-02_JPRB,0.17127E-02_JPRB,0.14287E-02_JPRB,0.12914E-02_JPRB, &
 & 0.13860E-02_JPRB,0.16360E-02_JPRB,0.18240E-02_JPRB,0.22487E-02_JPRB /)  
KA(:, 4, 4,15) = (/ &
 & 0.22757E-02_JPRB,0.19915E-02_JPRB,0.17074E-02_JPRB,0.14457E-02_JPRB,0.13800E-02_JPRB, &
 & 0.16339E-02_JPRB,0.19297E-02_JPRB,0.21519E-02_JPRB,0.26493E-02_JPRB /)  
KA(:, 5, 4,15) = (/ &
 & 0.22684E-02_JPRB,0.19852E-02_JPRB,0.17019E-02_JPRB,0.14754E-02_JPRB,0.15614E-02_JPRB, &
 & 0.19242E-02_JPRB,0.22727E-02_JPRB,0.25341E-02_JPRB,0.31196E-02_JPRB /)  
KA(:, 1, 5,15) = (/ &
 & 0.26562E-02_JPRB,0.23246E-02_JPRB,0.19929E-02_JPRB,0.16611E-02_JPRB,0.13598E-02_JPRB, &
 & 0.11996E-02_JPRB,0.12698E-02_JPRB,0.14174E-02_JPRB,0.17501E-02_JPRB /)  
KA(:, 2, 5,15) = (/ &
 & 0.26415E-02_JPRB,0.23116E-02_JPRB,0.19818E-02_JPRB,0.16521E-02_JPRB,0.14129E-02_JPRB, &
 & 0.12866E-02_JPRB,0.14524E-02_JPRB,0.16197E-02_JPRB,0.20022E-02_JPRB /)  
KA(:, 3, 5,15) = (/ &
 & 0.26277E-02_JPRB,0.22994E-02_JPRB,0.19710E-02_JPRB,0.16428E-02_JPRB,0.14513E-02_JPRB, &
 & 0.14339E-02_JPRB,0.16856E-02_JPRB,0.18777E-02_JPRB,0.23236E-02_JPRB /)  
KA(:, 4, 5,15) = (/ &
 & 0.26179E-02_JPRB,0.22909E-02_JPRB,0.19639E-02_JPRB,0.16526E-02_JPRB,0.15154E-02_JPRB, &
 & 0.16607E-02_JPRB,0.19618E-02_JPRB,0.21909E-02_JPRB,0.27021E-02_JPRB /)  
KA(:, 5, 5,15) = (/ &
 & 0.26074E-02_JPRB,0.22818E-02_JPRB,0.19561E-02_JPRB,0.16780E-02_JPRB,0.16497E-02_JPRB, &
 & 0.19592E-02_JPRB,0.23163E-02_JPRB,0.25915E-02_JPRB,0.31846E-02_JPRB /)  
KA(:, 1, 6,15) = (/ &
 & 0.30676E-02_JPRB,0.26845E-02_JPRB,0.23014E-02_JPRB,0.19182E-02_JPRB,0.15508E-02_JPRB, &
 & 0.13265E-02_JPRB,0.13165E-02_JPRB,0.14712E-02_JPRB,0.18123E-02_JPRB /)  
KA(:, 2, 6,15) = (/ &
 & 0.30472E-02_JPRB,0.26667E-02_JPRB,0.22862E-02_JPRB,0.19057E-02_JPRB,0.15947E-02_JPRB, &
 & 0.14067E-02_JPRB,0.15004E-02_JPRB,0.16750E-02_JPRB,0.20695E-02_JPRB /)  
KA(:, 3, 6,15) = (/ &
 & 0.30255E-02_JPRB,0.26477E-02_JPRB,0.22705E-02_JPRB,0.18926E-02_JPRB,0.16408E-02_JPRB, &
 & 0.15149E-02_JPRB,0.17276E-02_JPRB,0.19275E-02_JPRB,0.23847E-02_JPRB /)  
KA(:, 4, 6,15) = (/ &
 & 0.30083E-02_JPRB,0.26326E-02_JPRB,0.22569E-02_JPRB,0.18906E-02_JPRB,0.16765E-02_JPRB, &
 & 0.17066E-02_JPRB,0.20035E-02_JPRB,0.22386E-02_JPRB,0.27616E-02_JPRB /)  
KA(:, 5, 6,15) = (/ &
 & 0.29915E-02_JPRB,0.26179E-02_JPRB,0.22443E-02_JPRB,0.19114E-02_JPRB,0.17836E-02_JPRB, &
 & 0.19800E-02_JPRB,0.23411E-02_JPRB,0.26194E-02_JPRB,0.32234E-02_JPRB /)  
KA(:, 1, 7,15) = (/ &
 & 0.35311E-02_JPRB,0.30900E-02_JPRB,0.26490E-02_JPRB,0.22082E-02_JPRB,0.17722E-02_JPRB, &
 & 0.14850E-02_JPRB,0.13781E-02_JPRB,0.15158E-02_JPRB,0.18578E-02_JPRB /)  
KA(:, 2, 7,15) = (/ &
 & 0.35031E-02_JPRB,0.30656E-02_JPRB,0.26281E-02_JPRB,0.21907E-02_JPRB,0.18048E-02_JPRB, &
 & 0.15528E-02_JPRB,0.15481E-02_JPRB,0.17322E-02_JPRB,0.21307E-02_JPRB /)  
KA(:, 3, 7,15) = (/ &
 & 0.34762E-02_JPRB,0.30421E-02_JPRB,0.26077E-02_JPRB,0.21737E-02_JPRB,0.18550E-02_JPRB, &
 & 0.16362E-02_JPRB,0.17771E-02_JPRB,0.19863E-02_JPRB,0.24506E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART10',1,ZHOOK_HANDLE)
END SUBROUTINE PART10


SUBROUTINE PART11

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART11',0,ZHOOK_HANDLE)


KA(:, 4, 7,15) = (/ &
 & 0.34506E-02_JPRB,0.30197E-02_JPRB,0.25888E-02_JPRB,0.21628E-02_JPRB,0.18864E-02_JPRB, &
 & 0.17891E-02_JPRB,0.20527E-02_JPRB,0.22948E-02_JPRB,0.28308E-02_JPRB /)  
KA(:, 5, 7,15) = (/ &
 & 0.34242E-02_JPRB,0.29966E-02_JPRB,0.25690E-02_JPRB,0.21752E-02_JPRB,0.19463E-02_JPRB, &
 & 0.20224E-02_JPRB,0.23798E-02_JPRB,0.26659E-02_JPRB,0.32785E-02_JPRB /)  
KA(:, 1, 8,15) = (/ &
 & 0.40545E-02_JPRB,0.35480E-02_JPRB,0.30415E-02_JPRB,0.25348E-02_JPRB,0.20284E-02_JPRB, &
 & 0.16698E-02_JPRB,0.14585E-02_JPRB,0.15473E-02_JPRB,0.18938E-02_JPRB /)  
KA(:, 2, 8,15) = (/ &
 & 0.40094E-02_JPRB,0.35086E-02_JPRB,0.30078E-02_JPRB,0.25070E-02_JPRB,0.20421E-02_JPRB, &
 & 0.17325E-02_JPRB,0.16159E-02_JPRB,0.17783E-02_JPRB,0.21732E-02_JPRB /)  
KA(:, 3, 8,15) = (/ &
 & 0.39679E-02_JPRB,0.34723E-02_JPRB,0.29772E-02_JPRB,0.24816E-02_JPRB,0.20882E-02_JPRB, &
 & 0.17972E-02_JPRB,0.18217E-02_JPRB,0.20430E-02_JPRB,0.25042E-02_JPRB /)  
KA(:, 4, 8,15) = (/ &
 & 0.39321E-02_JPRB,0.34411E-02_JPRB,0.29500E-02_JPRB,0.24630E-02_JPRB,0.21284E-02_JPRB, &
 & 0.19080E-02_JPRB,0.21043E-02_JPRB,0.23586E-02_JPRB,0.28966E-02_JPRB /)  
KA(:, 5, 8,15) = (/ &
 & 0.38953E-02_JPRB,0.34088E-02_JPRB,0.29224E-02_JPRB,0.24683E-02_JPRB,0.21576E-02_JPRB, &
 & 0.21070E-02_JPRB,0.24382E-02_JPRB,0.27335E-02_JPRB,0.33549E-02_JPRB /)  
KA(:, 1, 9,15) = (/ &
 & 0.46508E-02_JPRB,0.40697E-02_JPRB,0.34886E-02_JPRB,0.29075E-02_JPRB,0.23264E-02_JPRB, &
 & 0.18591E-02_JPRB,0.15578E-02_JPRB,0.15738E-02_JPRB,0.19224E-02_JPRB /)  
KA(:, 2, 9,15) = (/ &
 & 0.45823E-02_JPRB,0.40098E-02_JPRB,0.34374E-02_JPRB,0.28649E-02_JPRB,0.23092E-02_JPRB, &
 & 0.19366E-02_JPRB,0.17051E-02_JPRB,0.18133E-02_JPRB,0.22104E-02_JPRB /)  
KA(:, 3, 9,15) = (/ &
 & 0.45166E-02_JPRB,0.39524E-02_JPRB,0.33880E-02_JPRB,0.28238E-02_JPRB,0.23394E-02_JPRB, &
 & 0.19917E-02_JPRB,0.18843E-02_JPRB,0.20815E-02_JPRB,0.25365E-02_JPRB /)  
KA(:, 4, 9,15) = (/ &
 & 0.44602E-02_JPRB,0.39031E-02_JPRB,0.33460E-02_JPRB,0.27890E-02_JPRB,0.23856E-02_JPRB, &
 & 0.20682E-02_JPRB,0.21419E-02_JPRB,0.24093E-02_JPRB,0.29396E-02_JPRB /)  
KA(:, 5, 9,15) = (/ &
 & 0.44050E-02_JPRB,0.38549E-02_JPRB,0.33047E-02_JPRB,0.27817E-02_JPRB,0.24123E-02_JPRB, &
 & 0.22258E-02_JPRB,0.24850E-02_JPRB,0.27956E-02_JPRB,0.34119E-02_JPRB /)  
KA(:, 1,10,15) = (/ &
 & 0.53098E-02_JPRB,0.46463E-02_JPRB,0.39828E-02_JPRB,0.33194E-02_JPRB,0.26559E-02_JPRB, &
 & 0.20766E-02_JPRB,0.16840E-02_JPRB,0.16129E-02_JPRB,0.19635E-02_JPRB /)  
KA(:, 2,10,15) = (/ &
 & 0.52134E-02_JPRB,0.45620E-02_JPRB,0.39106E-02_JPRB,0.32592E-02_JPRB,0.26145E-02_JPRB, &
 & 0.21601E-02_JPRB,0.18269E-02_JPRB,0.18690E-02_JPRB,0.22681E-02_JPRB /)  
KA(:, 3,10,15) = (/ &
 & 0.51182E-02_JPRB,0.44788E-02_JPRB,0.38392E-02_JPRB,0.31998E-02_JPRB,0.26226E-02_JPRB, &
 & 0.22138E-02_JPRB,0.19824E-02_JPRB,0.21416E-02_JPRB,0.25956E-02_JPRB /)  
KA(:, 4,10,15) = (/ &
 & 0.50344E-02_JPRB,0.44054E-02_JPRB,0.37765E-02_JPRB,0.31477E-02_JPRB,0.26616E-02_JPRB, &
 & 0.22709E-02_JPRB,0.22099E-02_JPRB,0.24682E-02_JPRB,0.29962E-02_JPRB /)  
KA(:, 5,10,15) = (/ &
 & 0.49550E-02_JPRB,0.43361E-02_JPRB,0.37172E-02_JPRB,0.31183E-02_JPRB,0.26883E-02_JPRB, &
 & 0.23873E-02_JPRB,0.25425E-02_JPRB,0.28708E-02_JPRB,0.34790E-02_JPRB /)  
KA(:, 1,11,15) = (/ &
 & 0.59619E-02_JPRB,0.52169E-02_JPRB,0.44719E-02_JPRB,0.37267E-02_JPRB,0.29817E-02_JPRB, &
 & 0.23525E-02_JPRB,0.18854E-02_JPRB,0.17723E-02_JPRB,0.21445E-02_JPRB /)  
KA(:, 2,11,15) = (/ &
 & 0.58318E-02_JPRB,0.51031E-02_JPRB,0.43744E-02_JPRB,0.36457E-02_JPRB,0.29351E-02_JPRB, &
 & 0.24253E-02_JPRB,0.20278E-02_JPRB,0.20449E-02_JPRB,0.24715E-02_JPRB /)  
KA(:, 3,11,15) = (/ &
 & 0.57112E-02_JPRB,0.49976E-02_JPRB,0.42840E-02_JPRB,0.35704E-02_JPRB,0.29381E-02_JPRB, &
 & 0.24724E-02_JPRB,0.21871E-02_JPRB,0.23372E-02_JPRB,0.28231E-02_JPRB /)  
KA(:, 4,11,15) = (/ &
 & 0.56008E-02_JPRB,0.49010E-02_JPRB,0.42013E-02_JPRB,0.35025E-02_JPRB,0.29677E-02_JPRB, &
 & 0.25269E-02_JPRB,0.24222E-02_JPRB,0.27009E-02_JPRB,0.32614E-02_JPRB /)  
KA(:, 5,11,15) = (/ &
 & 0.54961E-02_JPRB,0.48096E-02_JPRB,0.41230E-02_JPRB,0.34666E-02_JPRB,0.29811E-02_JPRB, &
 & 0.26438E-02_JPRB,0.27691E-02_JPRB,0.31324E-02_JPRB,0.37747E-02_JPRB /)  
KA(:, 1,12,15) = (/ &
 & 0.66218E-02_JPRB,0.57942E-02_JPRB,0.49667E-02_JPRB,0.41391E-02_JPRB,0.33116E-02_JPRB, &
 & 0.26382E-02_JPRB,0.20922E-02_JPRB,0.19344E-02_JPRB,0.23267E-02_JPRB /)  
KA(:, 2,12,15) = (/ &
 & 0.64584E-02_JPRB,0.56513E-02_JPRB,0.48443E-02_JPRB,0.40372E-02_JPRB,0.32618E-02_JPRB, &
 & 0.26974E-02_JPRB,0.22343E-02_JPRB,0.22270E-02_JPRB,0.26783E-02_JPRB /)  
KA(:, 3,12,15) = (/ &
 & 0.63097E-02_JPRB,0.55213E-02_JPRB,0.47331E-02_JPRB,0.39445E-02_JPRB,0.32599E-02_JPRB, &
 & 0.27357E-02_JPRB,0.23983E-02_JPRB,0.25418E-02_JPRB,0.30577E-02_JPRB /)  
KA(:, 4,12,15) = (/ &
 & 0.61694E-02_JPRB,0.53986E-02_JPRB,0.46278E-02_JPRB,0.38631E-02_JPRB,0.32772E-02_JPRB, &
 & 0.27857E-02_JPRB,0.26412E-02_JPRB,0.29352E-02_JPRB,0.35233E-02_JPRB /)  
KA(:, 5,12,15) = (/ &
 & 0.60360E-02_JPRB,0.52820E-02_JPRB,0.45279E-02_JPRB,0.38177E-02_JPRB,0.32735E-02_JPRB, &
 & 0.29011E-02_JPRB,0.29998E-02_JPRB,0.33948E-02_JPRB,0.40685E-02_JPRB /)  
KA(:, 1,13,15) = (/ &
 & 0.72856E-02_JPRB,0.63751E-02_JPRB,0.54646E-02_JPRB,0.45539E-02_JPRB,0.36434E-02_JPRB, &
 & 0.29246E-02_JPRB,0.23024E-02_JPRB,0.20968E-02_JPRB,0.25004E-02_JPRB /)  
KA(:, 2,13,15) = (/ &
 & 0.70792E-02_JPRB,0.61945E-02_JPRB,0.53099E-02_JPRB,0.44252E-02_JPRB,0.35875E-02_JPRB, &
 & 0.29681E-02_JPRB,0.24397E-02_JPRB,0.24073E-02_JPRB,0.28787E-02_JPRB /)  
KA(:, 3,13,15) = (/ &
 & 0.68966E-02_JPRB,0.60348E-02_JPRB,0.51733E-02_JPRB,0.43112E-02_JPRB,0.35811E-02_JPRB, &
 & 0.29976E-02_JPRB,0.26071E-02_JPRB,0.27479E-02_JPRB,0.32886E-02_JPRB /)  
KA(:, 4,13,15) = (/ &
 & 0.67258E-02_JPRB,0.58855E-02_JPRB,0.50451E-02_JPRB,0.42204E-02_JPRB,0.35830E-02_JPRB, &
 & 0.30400E-02_JPRB,0.28573E-02_JPRB,0.31625E-02_JPRB,0.37791E-02_JPRB /)  
KA(:, 5,13,15) = (/ &
 & 0.65607E-02_JPRB,0.57411E-02_JPRB,0.49214E-02_JPRB,0.41617E-02_JPRB,0.35593E-02_JPRB, &
 & 0.31530E-02_JPRB,0.32258E-02_JPRB,0.36487E-02_JPRB,0.43508E-02_JPRB /)  
KA(:, 1, 1,16) = (/ &
 & 0.16712E-02_JPRB,0.14631E-02_JPRB,0.12550E-02_JPRB,0.10468E-02_JPRB,0.92082E-03_JPRB, &
 & 0.11371E-02_JPRB,0.13321E-02_JPRB,0.14544E-02_JPRB,0.17472E-02_JPRB /)  
KA(:, 2, 1,16) = (/ &
 & 0.16787E-02_JPRB,0.14701E-02_JPRB,0.12615E-02_JPRB,0.10530E-02_JPRB,0.10440E-02_JPRB, &
 & 0.12893E-02_JPRB,0.15114E-02_JPRB,0.16524E-02_JPRB,0.19826E-02_JPRB /)  
KA(:, 3, 1,16) = (/ &
 & 0.16875E-02_JPRB,0.14779E-02_JPRB,0.12683E-02_JPRB,0.10588E-02_JPRB,0.11676E-02_JPRB, &
 & 0.14424E-02_JPRB,0.16914E-02_JPRB,0.18523E-02_JPRB,0.22202E-02_JPRB /)  
KA(:, 4, 1,16) = (/ &
 & 0.16926E-02_JPRB,0.14826E-02_JPRB,0.12725E-02_JPRB,0.10626E-02_JPRB,0.12909E-02_JPRB, &
 & 0.15950E-02_JPRB,0.18720E-02_JPRB,0.20532E-02_JPRB,0.24579E-02_JPRB /)  
KA(:, 5, 1,16) = (/ &
 & 0.16942E-02_JPRB,0.14841E-02_JPRB,0.12739E-02_JPRB,0.11419E-02_JPRB,0.15149E-02_JPRB, &
 & 0.18796E-02_JPRB,0.22246E-02_JPRB,0.24968E-02_JPRB,0.29379E-02_JPRB /)  
KA(:, 1, 2,16) = (/ &
 & 0.19607E-02_JPRB,0.17158E-02_JPRB,0.14714E-02_JPRB,0.12274E-02_JPRB,0.10440E-02_JPRB, &
 & 0.12890E-02_JPRB,0.15097E-02_JPRB,0.16471E-02_JPRB,0.20285E-02_JPRB /)  
KA(:, 2, 2,16) = (/ &
 & 0.19666E-02_JPRB,0.17216E-02_JPRB,0.14767E-02_JPRB,0.12314E-02_JPRB,0.11872E-02_JPRB, &
 & 0.14659E-02_JPRB,0.17177E-02_JPRB,0.18761E-02_JPRB,0.23077E-02_JPRB /)  
KA(:, 3, 2,16) = (/ &
 & 0.19740E-02_JPRB,0.17284E-02_JPRB,0.14830E-02_JPRB,0.12374E-02_JPRB,0.13301E-02_JPRB, &
 & 0.16429E-02_JPRB,0.19255E-02_JPRB,0.21058E-02_JPRB,0.25866E-02_JPRB /)  
KA(:, 4, 2,16) = (/ &
 & 0.19796E-02_JPRB,0.17334E-02_JPRB,0.14872E-02_JPRB,0.12416E-02_JPRB,0.14717E-02_JPRB, &
 & 0.18182E-02_JPRB,0.21321E-02_JPRB,0.23342E-02_JPRB,0.28637E-02_JPRB /)  
KA(:, 5, 2,16) = (/ &
 & 0.19818E-02_JPRB,0.17354E-02_JPRB,0.14891E-02_JPRB,0.12544E-02_JPRB,0.16318E-02_JPRB, &
 & 0.20217E-02_JPRB,0.23832E-02_JPRB,0.26470E-02_JPRB,0.31951E-02_JPRB /)  
KA(:, 1, 3,16) = (/ &
 & 0.23039E-02_JPRB,0.20168E-02_JPRB,0.17292E-02_JPRB,0.14410E-02_JPRB,0.11614E-02_JPRB, &
 & 0.14213E-02_JPRB,0.16646E-02_JPRB,0.18149E-02_JPRB,0.22923E-02_JPRB /)  
KA(:, 2, 3,16) = (/ &
 & 0.23064E-02_JPRB,0.20187E-02_JPRB,0.17311E-02_JPRB,0.14440E-02_JPRB,0.13190E-02_JPRB, &
 & 0.16288E-02_JPRB,0.19083E-02_JPRB,0.20825E-02_JPRB,0.26267E-02_JPRB /)  
KA(:, 3, 3,16) = (/ &
 & 0.23119E-02_JPRB,0.20237E-02_JPRB,0.17351E-02_JPRB,0.14470E-02_JPRB,0.14864E-02_JPRB, &
 & 0.18354E-02_JPRB,0.21515E-02_JPRB,0.23501E-02_JPRB,0.29596E-02_JPRB /)  
KA(:, 4, 3,16) = (/ &
 & 0.23154E-02_JPRB,0.20269E-02_JPRB,0.17385E-02_JPRB,0.14496E-02_JPRB,0.16513E-02_JPRB, &
 & 0.20395E-02_JPRB,0.23915E-02_JPRB,0.26154E-02_JPRB,0.32883E-02_JPRB /)  
KA(:, 5, 3,16) = (/ &
 & 0.23212E-02_JPRB,0.20321E-02_JPRB,0.17430E-02_JPRB,0.14536E-02_JPRB,0.18129E-02_JPRB, &
 & 0.22398E-02_JPRB,0.26272E-02_JPRB,0.28760E-02_JPRB,0.36101E-02_JPRB /)  
KA(:, 1, 4,16) = (/ &
 & 0.27129E-02_JPRB,0.23736E-02_JPRB,0.20348E-02_JPRB,0.16965E-02_JPRB,0.13577E-02_JPRB, &
 & 0.15487E-02_JPRB,0.18138E-02_JPRB,0.19776E-02_JPRB,0.25289E-02_JPRB /)  
KA(:, 2, 4,16) = (/ &
 & 0.27133E-02_JPRB,0.23745E-02_JPRB,0.20358E-02_JPRB,0.16966E-02_JPRB,0.14516E-02_JPRB, &
 & 0.17925E-02_JPRB,0.21002E-02_JPRB,0.22917E-02_JPRB,0.29262E-02_JPRB /)  
KA(:, 3, 4,16) = (/ &
 & 0.27155E-02_JPRB,0.23766E-02_JPRB,0.20379E-02_JPRB,0.16990E-02_JPRB,0.16483E-02_JPRB, &
 & 0.20360E-02_JPRB,0.23858E-02_JPRB,0.26061E-02_JPRB,0.33224E-02_JPRB /)  
KA(:, 4, 4,16) = (/ &
 & 0.27175E-02_JPRB,0.23784E-02_JPRB,0.20394E-02_JPRB,0.17007E-02_JPRB,0.18426E-02_JPRB, &
 & 0.22757E-02_JPRB,0.26681E-02_JPRB,0.29171E-02_JPRB,0.37132E-02_JPRB /)  
KA(:, 5, 4,16) = (/ &
 & 0.27186E-02_JPRB,0.23796E-02_JPRB,0.20406E-02_JPRB,0.17019E-02_JPRB,0.20320E-02_JPRB, &
 & 0.25101E-02_JPRB,0.29443E-02_JPRB,0.32220E-02_JPRB,0.40947E-02_JPRB /)  
KA(:, 1, 5,16) = (/ &
 & 0.32119E-02_JPRB,0.28114E-02_JPRB,0.24099E-02_JPRB,0.20078E-02_JPRB,0.16065E-02_JPRB, &
 & 0.16767E-02_JPRB,0.19643E-02_JPRB,0.21431E-02_JPRB,0.27523E-02_JPRB /)  
KA(:, 2, 5,16) = (/ &
 & 0.32085E-02_JPRB,0.28077E-02_JPRB,0.24069E-02_JPRB,0.20064E-02_JPRB,0.16195E-02_JPRB, &
 & 0.19633E-02_JPRB,0.23007E-02_JPRB,0.25120E-02_JPRB,0.32215E-02_JPRB /)  
KA(:, 3, 5,16) = (/ &
 & 0.32085E-02_JPRB,0.28078E-02_JPRB,0.24068E-02_JPRB,0.20061E-02_JPRB,0.18214E-02_JPRB, &
 & 0.22501E-02_JPRB,0.26375E-02_JPRB,0.28827E-02_JPRB,0.36897E-02_JPRB /)  
KA(:, 4, 5,16) = (/ &
 & 0.32059E-02_JPRB,0.28056E-02_JPRB,0.24053E-02_JPRB,0.20050E-02_JPRB,0.20501E-02_JPRB, &
 & 0.25321E-02_JPRB,0.29699E-02_JPRB,0.32491E-02_JPRB,0.41521E-02_JPRB /)  
KA(:, 5, 5,16) = (/ &
 & 0.31984E-02_JPRB,0.27990E-02_JPRB,0.23997E-02_JPRB,0.20000E-02_JPRB,0.22727E-02_JPRB, &
 & 0.28084E-02_JPRB,0.32949E-02_JPRB,0.36079E-02_JPRB,0.46028E-02_JPRB /)  
KA(:, 1, 6,16) = (/ &
 & 0.38076E-02_JPRB,0.33317E-02_JPRB,0.28559E-02_JPRB,0.23799E-02_JPRB,0.19041E-02_JPRB, &
 & 0.17889E-02_JPRB,0.20969E-02_JPRB,0.22903E-02_JPRB,0.29420E-02_JPRB /)  
KA(:, 2, 6,16) = (/ &
 & 0.37964E-02_JPRB,0.33220E-02_JPRB,0.28476E-02_JPRB,0.23732E-02_JPRB,0.18989E-02_JPRB, &
 & 0.21234E-02_JPRB,0.24900E-02_JPRB,0.27226E-02_JPRB,0.34908E-02_JPRB /)  
KA(:, 3, 6,16) = (/ &
 & 0.37877E-02_JPRB,0.33145E-02_JPRB,0.28416E-02_JPRB,0.23683E-02_JPRB,0.19985E-02_JPRB, &
 & 0.24600E-02_JPRB,0.28851E-02_JPRB,0.31576E-02_JPRB,0.40421E-02_JPRB /)  
KA(:, 4, 6,16) = (/ &
 & 0.37785E-02_JPRB,0.33065E-02_JPRB,0.28344E-02_JPRB,0.23627E-02_JPRB,0.22594E-02_JPRB, &
 & 0.27919E-02_JPRB,0.32761E-02_JPRB,0.35889E-02_JPRB,0.45855E-02_JPRB /)  
KA(:, 5, 6,16) = (/ &
 & 0.37630E-02_JPRB,0.32929E-02_JPRB,0.28229E-02_JPRB,0.23532E-02_JPRB,0.25213E-02_JPRB, &
 & 0.31161E-02_JPRB,0.36579E-02_JPRB,0.40115E-02_JPRB,0.51155E-02_JPRB /)  
KA(:, 1, 7,16) = (/ &
 & 0.45014E-02_JPRB,0.39388E-02_JPRB,0.33762E-02_JPRB,0.28135E-02_JPRB,0.22509E-02_JPRB, &
 & 0.18859E-02_JPRB,0.22117E-02_JPRB,0.24208E-02_JPRB,0.31038E-02_JPRB /)  
KA(:, 2, 7,16) = (/ &
 & 0.44788E-02_JPRB,0.39190E-02_JPRB,0.33593E-02_JPRB,0.27996E-02_JPRB,0.22399E-02_JPRB, &
 & 0.22735E-02_JPRB,0.26677E-02_JPRB,0.29222E-02_JPRB,0.37394E-02_JPRB /)  
KA(:, 3, 7,16) = (/ &
 & 0.44593E-02_JPRB,0.39020E-02_JPRB,0.33439E-02_JPRB,0.27867E-02_JPRB,0.22518E-02_JPRB, &
 & 0.26648E-02_JPRB,0.31283E-02_JPRB,0.34304E-02_JPRB,0.43806E-02_JPRB /)  
KA(:, 4, 7,16) = (/ &
 & 0.44374E-02_JPRB,0.38829E-02_JPRB,0.33284E-02_JPRB,0.27732E-02_JPRB,0.24705E-02_JPRB, &
 & 0.30533E-02_JPRB,0.35850E-02_JPRB,0.39361E-02_JPRB,0.50160E-02_JPRB /)  
KA(:, 5, 7,16) = (/ &
 & 0.44113E-02_JPRB,0.38601E-02_JPRB,0.33089E-02_JPRB,0.27567E-02_JPRB,0.27756E-02_JPRB, &
 & 0.34321E-02_JPRB,0.40324E-02_JPRB,0.44314E-02_JPRB,0.56359E-02_JPRB /)  
KA(:, 1, 8,16) = (/ &
 & 0.53031E-02_JPRB,0.46403E-02_JPRB,0.39774E-02_JPRB,0.33149E-02_JPRB,0.26520E-02_JPRB, &
 & 0.20316E-02_JPRB,0.23080E-02_JPRB,0.25314E-02_JPRB,0.32334E-02_JPRB /)  
KA(:, 2, 8,16) = (/ &
 & 0.52648E-02_JPRB,0.46067E-02_JPRB,0.39487E-02_JPRB,0.32907E-02_JPRB,0.26325E-02_JPRB, &
 & 0.24096E-02_JPRB,0.28298E-02_JPRB,0.31081E-02_JPRB,0.39611E-02_JPRB /)  
KA(:, 3, 8,16) = (/ &
 & 0.52246E-02_JPRB,0.45716E-02_JPRB,0.39189E-02_JPRB,0.32659E-02_JPRB,0.26125E-02_JPRB, &
 & 0.28611E-02_JPRB,0.33614E-02_JPRB,0.36958E-02_JPRB,0.47006E-02_JPRB /)  
KA(:, 4, 8,16) = (/ &
 & 0.51821E-02_JPRB,0.45344E-02_JPRB,0.38868E-02_JPRB,0.32390E-02_JPRB,0.27289E-02_JPRB, &
 & 0.33103E-02_JPRB,0.38912E-02_JPRB,0.42829E-02_JPRB,0.54355E-02_JPRB /)  
KA(:, 5, 8,16) = (/ &
 & 0.51356E-02_JPRB,0.44938E-02_JPRB,0.38520E-02_JPRB,0.32108E-02_JPRB,0.30299E-02_JPRB, &
 & 0.37493E-02_JPRB,0.44090E-02_JPRB,0.48604E-02_JPRB,0.61537E-02_JPRB /)  
KA(:, 1, 9,16) = (/ &
 & 0.62116E-02_JPRB,0.54352E-02_JPRB,0.46587E-02_JPRB,0.38825E-02_JPRB,0.31060E-02_JPRB, &
 & 0.23296E-02_JPRB,0.23830E-02_JPRB,0.26152E-02_JPRB,0.33400E-02_JPRB /)  
KA(:, 2, 9,16) = (/ &
 & 0.61510E-02_JPRB,0.53822E-02_JPRB,0.46134E-02_JPRB,0.38445E-02_JPRB,0.30756E-02_JPRB, &
 & 0.25421E-02_JPRB,0.29622E-02_JPRB,0.32625E-02_JPRB,0.41372E-02_JPRB /)  
KA(:, 3, 9,16) = (/ &
 & 0.60862E-02_JPRB,0.53255E-02_JPRB,0.45651E-02_JPRB,0.38044E-02_JPRB,0.30427E-02_JPRB, &
 & 0.30332E-02_JPRB,0.35680E-02_JPRB,0.39355E-02_JPRB,0.49777E-02_JPRB /)  
KA(:, 4, 9,16) = (/ &
 & 0.60169E-02_JPRB,0.52649E-02_JPRB,0.45129E-02_JPRB,0.37608E-02_JPRB,0.30629E-02_JPRB, &
 & 0.35468E-02_JPRB,0.41747E-02_JPRB,0.46107E-02_JPRB,0.58172E-02_JPRB /)  
KA(:, 5, 9,16) = (/ &
 & 0.59428E-02_JPRB,0.52001E-02_JPRB,0.44573E-02_JPRB,0.37148E-02_JPRB,0.33039E-02_JPRB, &
 & 0.40510E-02_JPRB,0.47683E-02_JPRB,0.52747E-02_JPRB,0.66403E-02_JPRB /)  
KA(:, 1,10,16) = (/ &
 & 0.72226E-02_JPRB,0.63198E-02_JPRB,0.54170E-02_JPRB,0.45138E-02_JPRB,0.36111E-02_JPRB, &
 & 0.27087E-02_JPRB,0.25246E-02_JPRB,0.27733E-02_JPRB,0.35348E-02_JPRB /)  
KA(:, 2,10,16) = (/ &
 & 0.71308E-02_JPRB,0.62395E-02_JPRB,0.53482E-02_JPRB,0.44569E-02_JPRB,0.35656E-02_JPRB, &
 & 0.27737E-02_JPRB,0.31148E-02_JPRB,0.34380E-02_JPRB,0.43453E-02_JPRB /)  
KA(:, 3,10,16) = (/ &
 & 0.70337E-02_JPRB,0.61546E-02_JPRB,0.52755E-02_JPRB,0.43963E-02_JPRB,0.35178E-02_JPRB, &
 & 0.32195E-02_JPRB,0.37898E-02_JPRB,0.41956E-02_JPRB,0.52718E-02_JPRB /)  
KA(:, 4,10,16) = (/ &
 & 0.69308E-02_JPRB,0.60645E-02_JPRB,0.51982E-02_JPRB,0.43312E-02_JPRB,0.34725E-02_JPRB, &
 & 0.37977E-02_JPRB,0.44773E-02_JPRB,0.49627E-02_JPRB,0.62190E-02_JPRB /)  
KA(:, 5,10,16) = (/ &
 & 0.68213E-02_JPRB,0.59687E-02_JPRB,0.51162E-02_JPRB,0.42630E-02_JPRB,0.36577E-02_JPRB, &
 & 0.43690E-02_JPRB,0.51523E-02_JPRB,0.57195E-02_JPRB,0.71486E-02_JPRB /)  
KA(:, 1,11,16) = (/ &
 & 0.82729E-02_JPRB,0.72388E-02_JPRB,0.62047E-02_JPRB,0.51704E-02_JPRB,0.41364E-02_JPRB, &
 & 0.31022E-02_JPRB,0.29450E-02_JPRB,0.32481E-02_JPRB,0.41092E-02_JPRB /)  
KA(:, 2,11,16) = (/ &
 & 0.81377E-02_JPRB,0.71207E-02_JPRB,0.61034E-02_JPRB,0.50862E-02_JPRB,0.40694E-02_JPRB, &
 & 0.32023E-02_JPRB,0.35972E-02_JPRB,0.39817E-02_JPRB,0.50045E-02_JPRB /)  
KA(:, 3,11,16) = (/ &
 & 0.79927E-02_JPRB,0.69937E-02_JPRB,0.59945E-02_JPRB,0.49955E-02_JPRB,0.39980E-02_JPRB, &
 & 0.36849E-02_JPRB,0.43305E-02_JPRB,0.48162E-02_JPRB,0.60016E-02_JPRB /)  
KA(:, 4,11,16) = (/ &
 & 0.78435E-02_JPRB,0.68631E-02_JPRB,0.58827E-02_JPRB,0.49014E-02_JPRB,0.39530E-02_JPRB, &
 & 0.43152E-02_JPRB,0.50942E-02_JPRB,0.56750E-02_JPRB,0.70494E-02_JPRB /)  
KA(:, 5,11,16) = (/ &
 & 0.76868E-02_JPRB,0.67260E-02_JPRB,0.57653E-02_JPRB,0.48045E-02_JPRB,0.41698E-02_JPRB, &
 & 0.49442E-02_JPRB,0.58408E-02_JPRB,0.65151E-02_JPRB,0.80731E-02_JPRB /)  
KA(:, 1,12,16) = (/ &
 & 0.93677E-02_JPRB,0.81967E-02_JPRB,0.70258E-02_JPRB,0.58546E-02_JPRB,0.46837E-02_JPRB, &
 & 0.35124E-02_JPRB,0.33991E-02_JPRB,0.37659E-02_JPRB,0.47255E-02_JPRB /)  
KA(:, 2,12,16) = (/ &
 & 0.91725E-02_JPRB,0.80259E-02_JPRB,0.68794E-02_JPRB,0.57329E-02_JPRB,0.45871E-02_JPRB, &
 & 0.36555E-02_JPRB,0.41158E-02_JPRB,0.45739E-02_JPRB,0.57058E-02_JPRB /)  
KA(:, 3,12,16) = (/ &
 & 0.89743E-02_JPRB,0.78526E-02_JPRB,0.67312E-02_JPRB,0.56083E-02_JPRB,0.44874E-02_JPRB, &
 & 0.41738E-02_JPRB,0.49000E-02_JPRB,0.54681E-02_JPRB,0.67707E-02_JPRB /)  
KA(:, 4,12,16) = (/ &
 & 0.87651E-02_JPRB,0.76695E-02_JPRB,0.65740E-02_JPRB,0.54780E-02_JPRB,0.44541E-02_JPRB, &
 & 0.48422E-02_JPRB,0.57276E-02_JPRB,0.64103E-02_JPRB,0.78928E-02_JPRB /)  
KA(:, 5,12,16) = (/ &
 & 0.85557E-02_JPRB,0.74863E-02_JPRB,0.64169E-02_JPRB,0.53471E-02_JPRB,0.46965E-02_JPRB, &
 & 0.55261E-02_JPRB,0.65398E-02_JPRB,0.73300E-02_JPRB,0.90026E-02_JPRB /)  
KA(:, 1,13,16) = (/ &
 & 0.10484E-01_JPRB,0.91737E-02_JPRB,0.78632E-02_JPRB,0.65525E-02_JPRB,0.52420E-02_JPRB, &
 & 0.39330E-02_JPRB,0.38753E-02_JPRB,0.43130E-02_JPRB,0.53655E-02_JPRB /)  
KA(:, 2,13,16) = (/ &
 & 0.10212E-01_JPRB,0.89352E-02_JPRB,0.76588E-02_JPRB,0.63823E-02_JPRB,0.51063E-02_JPRB, &
 & 0.41214E-02_JPRB,0.46538E-02_JPRB,0.51962E-02_JPRB,0.64287E-02_JPRB /)  
KA(:, 3,13,16) = (/ &
 & 0.99472E-02_JPRB,0.87039E-02_JPRB,0.74620E-02_JPRB,0.62164E-02_JPRB,0.49733E-02_JPRB, &
 & 0.46683E-02_JPRB,0.54886E-02_JPRB,0.61482E-02_JPRB,0.75590E-02_JPRB /)  
KA(:, 4,13,16) = (/ &
 & 0.96776E-02_JPRB,0.84679E-02_JPRB,0.72583E-02_JPRB,0.60495E-02_JPRB,0.49611E-02_JPRB, &
 & 0.53643E-02_JPRB,0.63558E-02_JPRB,0.71458E-02_JPRB,0.87290E-02_JPRB /)  
KA(:, 5,13,16) = (/ &
 & 0.94084E-02_JPRB,0.82324E-02_JPRB,0.70564E-02_JPRB,0.58807E-02_JPRB,0.52210E-02_JPRB, &
 & 0.60971E-02_JPRB,0.72271E-02_JPRB,0.81397E-02_JPRB,0.99102E-02_JPRB /)  
  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART11',1,ZHOOK_HANDLE)
END SUBROUTINE PART11


SUBROUTINE PART12

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART12',0,ZHOOK_HANDLE)


!     -----------------------------------------------------------------
!     The array KB contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KB(:,13, 1) = (/ &
 & 0.33062E-11_JPRB,0.42306E-11_JPRB,0.53172E-11_JPRB,0.65673E-11_JPRB,0.78335E-11_JPRB /)  
KB(:,14, 1) = (/ &
 & 0.27467E-11_JPRB,0.35252E-11_JPRB,0.44160E-11_JPRB,0.54171E-11_JPRB,0.64630E-11_JPRB /)  
KB(:,15, 1) = (/ &
 & 0.23431E-11_JPRB,0.29962E-11_JPRB,0.37507E-11_JPRB,0.46179E-11_JPRB,0.54790E-11_JPRB /)  
KB(:,16, 1) = (/ &
 & 0.20178E-11_JPRB,0.25698E-11_JPRB,0.32330E-11_JPRB,0.40024E-11_JPRB,0.46899E-11_JPRB /)  
KB(:,17, 1) = (/ &
 & 0.17389E-11_JPRB,0.22126E-11_JPRB,0.27864E-11_JPRB,0.34615E-11_JPRB,0.40184E-11_JPRB /)  
KB(:,18, 1) = (/ &
 & 0.15164E-11_JPRB,0.19304E-11_JPRB,0.24263E-11_JPRB,0.29918E-11_JPRB,0.34734E-11_JPRB /)  
KB(:,19, 1) = (/ &
 & 0.13194E-11_JPRB,0.16684E-11_JPRB,0.20851E-11_JPRB,0.25471E-11_JPRB,0.29992E-11_JPRB /)  
KB(:,20, 1) = (/ &
 & 0.11345E-11_JPRB,0.14317E-11_JPRB,0.17813E-11_JPRB,0.21686E-11_JPRB,0.25523E-11_JPRB /)  
KB(:,21, 1) = (/ &
 & 0.97614E-12_JPRB,0.12233E-11_JPRB,0.15124E-11_JPRB,0.18436E-11_JPRB,0.21624E-11_JPRB /)  
KB(:,22, 1) = (/ &
 & 0.84972E-12_JPRB,0.10604E-11_JPRB,0.13001E-11_JPRB,0.15853E-11_JPRB,0.18511E-11_JPRB /)  
KB(:,23, 1) = (/ &
 & 0.73919E-12_JPRB,0.91863E-12_JPRB,0.11179E-11_JPRB,0.13612E-11_JPRB,0.15791E-11_JPRB /)  
KB(:,24, 1) = (/ &
 & 0.63952E-12_JPRB,0.79203E-12_JPRB,0.96272E-12_JPRB,0.11643E-11_JPRB,0.13384E-11_JPRB /)  
KB(:,25, 1) = (/ &
 & 0.55198E-12_JPRB,0.68176E-12_JPRB,0.82782E-12_JPRB,0.99347E-12_JPRB,0.11342E-11_JPRB /)  
KB(:,26, 1) = (/ &
 & 0.47648E-12_JPRB,0.58395E-12_JPRB,0.71214E-12_JPRB,0.84565E-12_JPRB,0.96146E-12_JPRB /)  
KB(:,27, 1) = (/ &
 & 0.41185E-12_JPRB,0.50403E-12_JPRB,0.61156E-12_JPRB,0.71539E-12_JPRB,0.81410E-12_JPRB /)  
KB(:,28, 1) = (/ &
 & 0.35568E-12_JPRB,0.43404E-12_JPRB,0.52441E-12_JPRB,0.60652E-12_JPRB,0.68860E-12_JPRB /)  
KB(:,29, 1) = (/ &
 & 0.30863E-12_JPRB,0.37487E-12_JPRB,0.45120E-12_JPRB,0.51591E-12_JPRB,0.58367E-12_JPRB /)  
KB(:,30, 1) = (/ &
 & 0.26804E-12_JPRB,0.32390E-12_JPRB,0.38615E-12_JPRB,0.43956E-12_JPRB,0.49890E-12_JPRB /)  
KB(:,31, 1) = (/ &
 & 0.23316E-12_JPRB,0.28106E-12_JPRB,0.33068E-12_JPRB,0.37478E-12_JPRB,0.42377E-12_JPRB /)  
KB(:,32, 1) = (/ &
 & 0.20255E-12_JPRB,0.24397E-12_JPRB,0.28293E-12_JPRB,0.31878E-12_JPRB,0.36224E-12_JPRB /)  
KB(:,33, 1) = (/ &
 & 0.17541E-12_JPRB,0.21018E-12_JPRB,0.24052E-12_JPRB,0.27083E-12_JPRB,0.30963E-12_JPRB /)  
KB(:,34, 1) = (/ &
 & 0.15014E-12_JPRB,0.17890E-12_JPRB,0.20293E-12_JPRB,0.23058E-12_JPRB,0.26131E-12_JPRB /)  
KB(:,35, 1) = (/ &
 & 0.12610E-12_JPRB,0.14972E-12_JPRB,0.16906E-12_JPRB,0.19250E-12_JPRB,0.21752E-12_JPRB /)  
KB(:,36, 1) = (/ &
 & 0.10365E-12_JPRB,0.12301E-12_JPRB,0.13878E-12_JPRB,0.15810E-12_JPRB,0.17856E-12_JPRB /)  
KB(:,37, 1) = (/ &
 & 0.82572E-13_JPRB,0.98388E-13_JPRB,0.11143E-12_JPRB,0.12645E-12_JPRB,0.14343E-12_JPRB /)  
KB(:,38, 1) = (/ &
 & 0.65632E-13_JPRB,0.78531E-13_JPRB,0.89359E-13_JPRB,0.10135E-12_JPRB,0.11495E-12_JPRB /)  
KB(:,39, 1) = (/ &
 & 0.52174E-13_JPRB,0.62607E-13_JPRB,0.71650E-13_JPRB,0.80738E-13_JPRB,0.92112E-13_JPRB /)  
KB(:,40, 1) = (/ &
 & 0.40434E-13_JPRB,0.48683E-13_JPRB,0.56479E-13_JPRB,0.63806E-13_JPRB,0.72155E-13_JPRB /)  
KB(:,41, 1) = (/ &
 & 0.31179E-13_JPRB,0.37691E-13_JPRB,0.44339E-13_JPRB,0.50247E-13_JPRB,0.56982E-13_JPRB /)  
KB(:,42, 1) = (/ &
 & 0.24040E-13_JPRB,0.29161E-13_JPRB,0.34731E-13_JPRB,0.39467E-13_JPRB,0.44922E-13_JPRB /)  
KB(:,43, 1) = (/ &
 & 0.18259E-13_JPRB,0.22185E-13_JPRB,0.26753E-13_JPRB,0.30617E-13_JPRB,0.34721E-13_JPRB /)  
KB(:,44, 1) = (/ &
 & 0.13667E-13_JPRB,0.16662E-13_JPRB,0.20308E-13_JPRB,0.23577E-13_JPRB,0.26865E-13_JPRB /)  
KB(:,45, 1) = (/ &
 & 0.10182E-13_JPRB,0.12571E-13_JPRB,0.15345E-13_JPRB,0.18028E-13_JPRB,0.20725E-13_JPRB /)  
KB(:,46, 1) = (/ &
 & 0.75196E-14_JPRB,0.94092E-14_JPRB,0.11475E-13_JPRB,0.13704E-13_JPRB,0.15878E-13_JPRB /)  
KB(:,47, 1) = (/ &
 & 0.54721E-14_JPRB,0.69523E-14_JPRB,0.85280E-14_JPRB,0.10311E-13_JPRB,0.11952E-13_JPRB /)  
KB(:,48, 1) = (/ &
 & 0.39619E-14_JPRB,0.50439E-14_JPRB,0.62896E-14_JPRB,0.77193E-14_JPRB,0.89282E-14_JPRB /)  
KB(:,49, 1) = (/ &
 & 0.28508E-14_JPRB,0.36419E-14_JPRB,0.46044E-14_JPRB,0.57276E-14_JPRB,0.66866E-14_JPRB /)  
KB(:,50, 1) = (/ &
 & 0.20973E-14_JPRB,0.26588E-14_JPRB,0.33754E-14_JPRB,0.42404E-14_JPRB,0.50338E-14_JPRB /)  
KB(:,51, 1) = (/ &
 & 0.15010E-14_JPRB,0.19461E-14_JPRB,0.24807E-14_JPRB,0.31095E-14_JPRB,0.37789E-14_JPRB /)  
KB(:,52, 1) = (/ &
 & 0.10686E-14_JPRB,0.14205E-14_JPRB,0.18164E-14_JPRB,0.22651E-14_JPRB,0.27790E-14_JPRB /)  
KB(:,53, 1) = (/ &
 & 0.75469E-15_JPRB,0.10279E-14_JPRB,0.13211E-14_JPRB,0.16657E-14_JPRB,0.20344E-14_JPRB /)  
KB(:,54, 1) = (/ &
 & 0.53837E-15_JPRB,0.75440E-15_JPRB,0.97064E-15_JPRB,0.12260E-14_JPRB,0.15156E-14_JPRB /)  
KB(:,55, 1) = (/ &
 & 0.38620E-15_JPRB,0.54750E-15_JPRB,0.71223E-15_JPRB,0.90921E-15_JPRB,0.11265E-14_JPRB /)  
KB(:,56, 1) = (/ &
 & 0.27852E-15_JPRB,0.39135E-15_JPRB,0.51858E-15_JPRB,0.66760E-15_JPRB,0.83486E-15_JPRB /)  
KB(:,57, 1) = (/ &
 & 0.20280E-15_JPRB,0.27940E-15_JPRB,0.37558E-15_JPRB,0.48656E-15_JPRB,0.61658E-15_JPRB /)  
KB(:,58, 1) = (/ &
 & 0.14586E-15_JPRB,0.19788E-15_JPRB,0.27273E-15_JPRB,0.35391E-15_JPRB,0.45250E-15_JPRB /)  
KB(:,59, 1) = (/ &
 & 0.11164E-15_JPRB,0.15082E-15_JPRB,0.20804E-15_JPRB,0.27081E-15_JPRB,0.49339E-15_JPRB /)  
KB(:,13, 2) = (/ &
 & 0.15800E-10_JPRB,0.20781E-10_JPRB,0.26154E-10_JPRB,0.31936E-10_JPRB,0.38062E-10_JPRB /)  
KB(:,14, 2) = (/ &
 & 0.13333E-10_JPRB,0.17459E-10_JPRB,0.21881E-10_JPRB,0.26666E-10_JPRB,0.31696E-10_JPRB /)  
KB(:,15, 2) = (/ &
 & 0.11381E-10_JPRB,0.14784E-10_JPRB,0.18449E-10_JPRB,0.22397E-10_JPRB,0.26533E-10_JPRB /)  
KB(:,16, 2) = (/ &
 & 0.97593E-11_JPRB,0.12591E-10_JPRB,0.15641E-10_JPRB,0.18845E-10_JPRB,0.22503E-10_JPRB /)  
KB(:,17, 2) = (/ &
 & 0.83473E-11_JPRB,0.10709E-10_JPRB,0.13261E-10_JPRB,0.15857E-10_JPRB,0.19052E-10_JPRB /)  
KB(:,18, 2) = (/ &
 & 0.71523E-11_JPRB,0.91255E-11_JPRB,0.11229E-10_JPRB,0.13436E-10_JPRB,0.16145E-10_JPRB /)  
KB(:,19, 2) = (/ &
 & 0.60777E-11_JPRB,0.77489E-11_JPRB,0.94796E-11_JPRB,0.11415E-10_JPRB,0.13591E-10_JPRB /)  
KB(:,20, 2) = (/ &
 & 0.51693E-11_JPRB,0.65609E-11_JPRB,0.80124E-11_JPRB,0.96944E-11_JPRB,0.11427E-10_JPRB /)  
KB(:,21, 2) = (/ &
 & 0.43931E-11_JPRB,0.55492E-11_JPRB,0.67698E-11_JPRB,0.81825E-11_JPRB,0.95836E-11_JPRB /)  
KB(:,22, 2) = (/ &
 & 0.37967E-11_JPRB,0.47515E-11_JPRB,0.57759E-11_JPRB,0.69676E-11_JPRB,0.81090E-11_JPRB /)  
KB(:,23, 2) = (/ &
 & 0.32747E-11_JPRB,0.40830E-11_JPRB,0.49616E-11_JPRB,0.59280E-11_JPRB,0.68614E-11_JPRB /)  
KB(:,24, 2) = (/ &
 & 0.28215E-11_JPRB,0.34976E-11_JPRB,0.42532E-11_JPRB,0.50228E-11_JPRB,0.57971E-11_JPRB /)  
KB(:,25, 2) = (/ &
 & 0.24334E-11_JPRB,0.29960E-11_JPRB,0.36396E-11_JPRB,0.42606E-11_JPRB,0.49056E-11_JPRB /)  
KB(:,26, 2) = (/ &
 & 0.21117E-11_JPRB,0.25752E-11_JPRB,0.31134E-11_JPRB,0.36244E-11_JPRB,0.41489E-11_JPRB /)  
KB(:,27, 2) = (/ &
 & 0.18253E-11_JPRB,0.22243E-11_JPRB,0.26576E-11_JPRB,0.30793E-11_JPRB,0.35048E-11_JPRB /)  
KB(:,28, 2) = (/ &
 & 0.15682E-11_JPRB,0.19141E-11_JPRB,0.22636E-11_JPRB,0.26109E-11_JPRB,0.29589E-11_JPRB /)  
KB(:,29, 2) = (/ &
 & 0.13535E-11_JPRB,0.16466E-11_JPRB,0.19296E-11_JPRB,0.22145E-11_JPRB,0.25005E-11_JPRB /)  
KB(:,30, 2) = (/ &
 & 0.11709E-11_JPRB,0.14136E-11_JPRB,0.16432E-11_JPRB,0.18792E-11_JPRB,0.21240E-11_JPRB /)  
KB(:,31, 2) = (/ &
 & 0.10216E-11_JPRB,0.12142E-11_JPRB,0.14045E-11_JPRB,0.15978E-11_JPRB,0.18001E-11_JPRB /)  
KB(:,32, 2) = (/ &
 & 0.88417E-12_JPRB,0.10400E-11_JPRB,0.11973E-11_JPRB,0.13566E-11_JPRB,0.15303E-11_JPRB /)  
KB(:,33, 2) = (/ &
 & 0.76210E-12_JPRB,0.89004E-12_JPRB,0.10199E-11_JPRB,0.11509E-11_JPRB,0.12984E-11_JPRB /)  
KB(:,34, 2) = (/ &
 & 0.64910E-12_JPRB,0.75460E-12_JPRB,0.86122E-12_JPRB,0.97227E-12_JPRB,0.10908E-11_JPRB /)  
KB(:,35, 2) = (/ &
 & 0.54374E-12_JPRB,0.63015E-12_JPRB,0.71745E-12_JPRB,0.80944E-12_JPRB,0.90628E-12_JPRB /)  
KB(:,36, 2) = (/ &
 & 0.44718E-12_JPRB,0.51791E-12_JPRB,0.58946E-12_JPRB,0.66527E-12_JPRB,0.74411E-12_JPRB /)  
KB(:,37, 2) = (/ &
 & 0.35793E-12_JPRB,0.41591E-12_JPRB,0.47443E-12_JPRB,0.53549E-12_JPRB,0.60041E-12_JPRB /)  
KB(:,38, 2) = (/ &
 & 0.28618E-12_JPRB,0.33345E-12_JPRB,0.38124E-12_JPRB,0.43139E-12_JPRB,0.48394E-12_JPRB /)  
KB(:,39, 2) = (/ &
 & 0.22858E-12_JPRB,0.26729E-12_JPRB,0.30628E-12_JPRB,0.34554E-12_JPRB,0.38998E-12_JPRB /)  
KB(:,40, 2) = (/ &
 & 0.17867E-12_JPRB,0.21032E-12_JPRB,0.24207E-12_JPRB,0.27407E-12_JPRB,0.30925E-12_JPRB /)  
KB(:,41, 2) = (/ &
 & 0.13875E-12_JPRB,0.16498E-12_JPRB,0.19072E-12_JPRB,0.21688E-12_JPRB,0.24410E-12_JPRB /)  
KB(:,42, 2) = (/ &
 & 0.10714E-12_JPRB,0.12915E-12_JPRB,0.14999E-12_JPRB,0.17156E-12_JPRB,0.19364E-12_JPRB /)  
KB(:,43, 2) = (/ &
 & 0.81856E-13_JPRB,0.99592E-13_JPRB,0.11661E-12_JPRB,0.13414E-12_JPRB,0.15145E-12_JPRB /)  
KB(:,44, 2) = (/ &
 & 0.62221E-13_JPRB,0.75886E-13_JPRB,0.90106E-13_JPRB,0.10425E-12_JPRB,0.11838E-12_JPRB /)  
KB(:,45, 2) = (/ &
 & 0.47139E-13_JPRB,0.57421E-13_JPRB,0.69401E-13_JPRB,0.80830E-13_JPRB,0.92462E-13_JPRB /)  
KB(:,46, 2) = (/ &
 & 0.35469E-13_JPRB,0.43603E-13_JPRB,0.52913E-13_JPRB,0.62345E-13_JPRB,0.71769E-13_JPRB /)  
KB(:,47, 2) = (/ &
 & 0.26308E-13_JPRB,0.32606E-13_JPRB,0.39610E-13_JPRB,0.47505E-13_JPRB,0.55354E-13_JPRB /)  
KB(:,48, 2) = (/ &
 & 0.19388E-13_JPRB,0.24430E-13_JPRB,0.29903E-13_JPRB,0.35902E-13_JPRB,0.42540E-13_JPRB /)  
KB(:,49, 2) = (/ &
 & 0.14144E-13_JPRB,0.18180E-13_JPRB,0.22467E-13_JPRB,0.26985E-13_JPRB,0.32471E-13_JPRB /)  
KB(:,50, 2) = (/ &
 & 0.10280E-13_JPRB,0.13471E-13_JPRB,0.16900E-13_JPRB,0.20465E-13_JPRB,0.24665E-13_JPRB /)  
KB(:,51, 2) = (/ &
 & 0.74898E-14_JPRB,0.99392E-14_JPRB,0.12674E-13_JPRB,0.15571E-13_JPRB,0.18663E-13_JPRB /)  
KB(:,52, 2) = (/ &
 & 0.54214E-14_JPRB,0.72917E-14_JPRB,0.94517E-14_JPRB,0.11816E-13_JPRB,0.14256E-13_JPRB /)  
KB(:,53, 2) = (/ &
 & 0.38970E-14_JPRB,0.53165E-14_JPRB,0.69989E-14_JPRB,0.88828E-14_JPRB,0.10862E-13_JPRB /)  
KB(:,54, 2) = (/ &
 & 0.27972E-14_JPRB,0.38775E-14_JPRB,0.51927E-14_JPRB,0.66775E-14_JPRB,0.82659E-14_JPRB /)  
KB(:,55, 2) = (/ &
 & 0.19962E-14_JPRB,0.28257E-14_JPRB,0.38491E-14_JPRB,0.50059E-14_JPRB,0.62864E-14_JPRB /)  
KB(:,56, 2) = (/ &
 & 0.14049E-14_JPRB,0.20447E-14_JPRB,0.28389E-14_JPRB,0.37444E-14_JPRB,0.47474E-14_JPRB /)  
KB(:,57, 2) = (/ &
 & 0.97467E-15_JPRB,0.14635E-14_JPRB,0.20787E-14_JPRB,0.27878E-14_JPRB,0.35737E-14_JPRB /)  
KB(:,58, 2) = (/ &
 & 0.67770E-15_JPRB,0.10398E-14_JPRB,0.15169E-14_JPRB,0.20739E-14_JPRB,0.26951E-14_JPRB /)  
KB(:,59, 2) = (/ &
 & 0.50857E-15_JPRB,0.79496E-15_JPRB,0.11749E-14_JPRB,0.16262E-14_JPRB,0.21270E-14_JPRB /)  
KB(:,13, 3) = (/ &
 & 0.93671E-10_JPRB,0.11591E-09_JPRB,0.13715E-09_JPRB,0.15779E-09_JPRB,0.17870E-09_JPRB /)  
KB(:,14, 3) = (/ &
 & 0.78883E-10_JPRB,0.96971E-10_JPRB,0.11437E-09_JPRB,0.13160E-09_JPRB,0.14863E-09_JPRB /)  
KB(:,15, 3) = (/ &
 & 0.66900E-10_JPRB,0.81568E-10_JPRB,0.96052E-10_JPRB,0.11028E-09_JPRB,0.12439E-09_JPRB /)  
KB(:,16, 3) = (/ &
 & 0.56737E-10_JPRB,0.68853E-10_JPRB,0.80870E-10_JPRB,0.92769E-10_JPRB,0.10422E-09_JPRB /)  
KB(:,17, 3) = (/ &
 & 0.48148E-10_JPRB,0.58209E-10_JPRB,0.68168E-10_JPRB,0.78006E-10_JPRB,0.87308E-10_JPRB /)  
KB(:,18, 3) = (/ &
 & 0.40874E-10_JPRB,0.49268E-10_JPRB,0.57591E-10_JPRB,0.65627E-10_JPRB,0.73296E-10_JPRB /)  
KB(:,19, 3) = (/ &
 & 0.34619E-10_JPRB,0.41578E-10_JPRB,0.48414E-10_JPRB,0.55049E-10_JPRB,0.61235E-10_JPRB /)  
KB(:,20, 3) = (/ &
 & 0.29370E-10_JPRB,0.35034E-10_JPRB,0.40682E-10_JPRB,0.46014E-10_JPRB,0.51115E-10_JPRB /)  
KB(:,21, 3) = (/ &
 & 0.24821E-10_JPRB,0.29490E-10_JPRB,0.34141E-10_JPRB,0.38423E-10_JPRB,0.42621E-10_JPRB /)  
KB(:,22, 3) = (/ &
 & 0.21204E-10_JPRB,0.25041E-10_JPRB,0.28846E-10_JPRB,0.32305E-10_JPRB,0.35757E-10_JPRB /)  
KB(:,23, 3) = (/ &
 & 0.18107E-10_JPRB,0.21244E-10_JPRB,0.24304E-10_JPRB,0.27144E-10_JPRB,0.30005E-10_JPRB /)  
KB(:,24, 3) = (/ &
 & 0.15432E-10_JPRB,0.18015E-10_JPRB,0.20470E-10_JPRB,0.22803E-10_JPRB,0.25180E-10_JPRB /)  
KB(:,25, 3) = (/ &
 & 0.13155E-10_JPRB,0.15266E-10_JPRB,0.17234E-10_JPRB,0.19170E-10_JPRB,0.21096E-10_JPRB /)  
KB(:,26, 3) = (/ &
 & 0.11220E-10_JPRB,0.12944E-10_JPRB,0.14527E-10_JPRB,0.16132E-10_JPRB,0.17690E-10_JPRB /)  
KB(:,27, 3) = (/ &
 & 0.95562E-11_JPRB,0.10942E-10_JPRB,0.12242E-10_JPRB,0.13560E-10_JPRB,0.14820E-10_JPRB /)  
KB(:,28, 3) = (/ &
 & 0.81359E-11_JPRB,0.92394E-11_JPRB,0.10309E-10_JPRB,0.11386E-10_JPRB,0.12407E-10_JPRB /)  
KB(:,29, 3) = (/ &
 & 0.69193E-11_JPRB,0.78077E-11_JPRB,0.87009E-11_JPRB,0.95682E-11_JPRB,0.10386E-10_JPRB /)  
KB(:,30, 3) = (/ &
 & 0.58737E-11_JPRB,0.65956E-11_JPRB,0.73381E-11_JPRB,0.80325E-11_JPRB,0.87147E-11_JPRB /)  
KB(:,31, 3) = (/ &
 & 0.49782E-11_JPRB,0.55816E-11_JPRB,0.61826E-11_JPRB,0.67463E-11_JPRB,0.73000E-11_JPRB /)  
KB(:,32, 3) = (/ &
 & 0.42202E-11_JPRB,0.47232E-11_JPRB,0.52043E-11_JPRB,0.56623E-11_JPRB,0.61016E-11_JPRB /)  
KB(:,33, 3) = (/ &
 & 0.35744E-11_JPRB,0.39897E-11_JPRB,0.43757E-11_JPRB,0.47465E-11_JPRB,0.50931E-11_JPRB /)  
KB(:,34, 3) = (/ &
 & 0.30127E-11_JPRB,0.33496E-11_JPRB,0.36630E-11_JPRB,0.39738E-11_JPRB,0.42413E-11_JPRB /)  
KB(:,35, 3) = (/ &
 & 0.25098E-11_JPRB,0.27837E-11_JPRB,0.30393E-11_JPRB,0.32916E-11_JPRB,0.35093E-11_JPRB /)  
KB(:,36, 3) = (/ &
 & 0.20644E-11_JPRB,0.22886E-11_JPRB,0.24982E-11_JPRB,0.27043E-11_JPRB,0.28833E-11_JPRB /)  
KB(:,37, 3) = (/ &
 & 0.16684E-11_JPRB,0.18536E-11_JPRB,0.20259E-11_JPRB,0.21979E-11_JPRB,0.23456E-11_JPRB /)  
KB(:,38, 3) = (/ &
 & 0.13466E-11_JPRB,0.14996E-11_JPRB,0.16425E-11_JPRB,0.17834E-11_JPRB,0.19065E-11_JPRB /)  
KB(:,39, 3) = (/ &
 & 0.10861E-11_JPRB,0.12130E-11_JPRB,0.13309E-11_JPRB,0.14440E-11_JPRB,0.15498E-11_JPRB /)  
KB(:,40, 3) = (/ &
 & 0.86498E-12_JPRB,0.96921E-12_JPRB,0.10678E-11_JPRB,0.11601E-11_JPRB,0.12509E-11_JPRB /)  
KB(:,41, 3) = (/ &
 & 0.68788E-12_JPRB,0.77191E-12_JPRB,0.85472E-12_JPRB,0.93133E-12_JPRB,0.10084E-11_JPRB /)  
KB(:,42, 3) = (/ &
 & 0.54661E-12_JPRB,0.61437E-12_JPRB,0.68360E-12_JPRB,0.74699E-12_JPRB,0.81088E-12_JPRB /)  
KB(:,43, 3) = (/ &
 & 0.42920E-12_JPRB,0.48515E-12_JPRB,0.54174E-12_JPRB,0.59564E-12_JPRB,0.64658E-12_JPRB /)  
KB(:,44, 3) = (/ &
 & 0.33491E-12_JPRB,0.38198E-12_JPRB,0.42756E-12_JPRB,0.47274E-12_JPRB,0.51490E-12_JPRB /)  
KB(:,45, 3) = (/ &
 & 0.26072E-12_JPRB,0.29981E-12_JPRB,0.33699E-12_JPRB,0.37442E-12_JPRB,0.40968E-12_JPRB /)  
KB(:,46, 3) = (/ &
 & 0.20167E-12_JPRB,0.23370E-12_JPRB,0.26473E-12_JPRB,0.29535E-12_JPRB,0.32495E-12_JPRB /)  
KB(:,47, 3) = (/ &
 & 0.15427E-12_JPRB,0.18070E-12_JPRB,0.20644E-12_JPRB,0.23129E-12_JPRB,0.25612E-12_JPRB /)  
KB(:,48, 3) = (/ &
 & 0.11746E-12_JPRB,0.13905E-12_JPRB,0.16032E-12_JPRB,0.18088E-12_JPRB,0.20125E-12_JPRB /)  
KB(:,49, 3) = (/ &
 & 0.88976E-13_JPRB,0.10661E-12_JPRB,0.12415E-12_JPRB,0.14128E-12_JPRB,0.15777E-12_JPRB /)  
KB(:,50, 3) = (/ &
 & 0.67378E-13_JPRB,0.81791E-13_JPRB,0.96162E-13_JPRB,0.11029E-12_JPRB,0.12384E-12_JPRB /)  
KB(:,51, 3) = (/ &
 & 0.50786E-13_JPRB,0.62576E-13_JPRB,0.74348E-13_JPRB,0.85995E-13_JPRB,0.97345E-13_JPRB /)  
KB(:,52, 3) = (/ &
 & 0.37951E-13_JPRB,0.47645E-13_JPRB,0.57250E-13_JPRB,0.66805E-13_JPRB,0.76257E-13_JPRB /)  
KB(:,53, 3) = (/ &
 & 0.28159E-13_JPRB,0.36102E-13_JPRB,0.43964E-13_JPRB,0.51774E-13_JPRB,0.59583E-13_JPRB /)  
KB(:,54, 3) = (/ &
 & 0.21004E-13_JPRB,0.27366E-13_JPRB,0.33776E-13_JPRB,0.40177E-13_JPRB,0.46583E-13_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART12',1,ZHOOK_HANDLE)
END SUBROUTINE PART12


SUBROUTINE PART13

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART13',0,ZHOOK_HANDLE)


KB(:,55, 3) = (/ &
 & 0.15637E-13_JPRB,0.20632E-13_JPRB,0.25941E-13_JPRB,0.31184E-13_JPRB,0.36409E-13_JPRB /)  
KB(:,56, 3) = (/ &
 & 0.11581E-13_JPRB,0.15522E-13_JPRB,0.19844E-13_JPRB,0.24130E-13_JPRB,0.28399E-13_JPRB /)  
KB(:,57, 3) = (/ &
 & 0.85125E-14_JPRB,0.11631E-13_JPRB,0.15093E-13_JPRB,0.18610E-13_JPRB,0.22102E-13_JPRB /)  
KB(:,58, 3) = (/ &
 & 0.62435E-14_JPRB,0.87193E-14_JPRB,0.11437E-13_JPRB,0.14347E-13_JPRB,0.17208E-13_JPRB /)  
KB(:,59, 3) = (/ &
 & 0.48886E-14_JPRB,0.68810E-14_JPRB,0.90777E-14_JPRB,0.11450E-13_JPRB,0.13800E-13_JPRB /)  
KB(:,13, 4) = (/ &
 & 0.49769E-09_JPRB,0.57573E-09_JPRB,0.65456E-09_JPRB,0.73233E-09_JPRB,0.81030E-09_JPRB /)  
KB(:,14, 4) = (/ &
 & 0.41687E-09_JPRB,0.48070E-09_JPRB,0.54629E-09_JPRB,0.61156E-09_JPRB,0.67509E-09_JPRB /)  
KB(:,15, 4) = (/ &
 & 0.35004E-09_JPRB,0.40346E-09_JPRB,0.45778E-09_JPRB,0.51155E-09_JPRB,0.56442E-09_JPRB /)  
KB(:,16, 4) = (/ &
 & 0.29428E-09_JPRB,0.33893E-09_JPRB,0.38370E-09_JPRB,0.42831E-09_JPRB,0.47172E-09_JPRB /)  
KB(:,17, 4) = (/ &
 & 0.24736E-09_JPRB,0.28447E-09_JPRB,0.32184E-09_JPRB,0.35882E-09_JPRB,0.39576E-09_JPRB /)  
KB(:,18, 4) = (/ &
 & 0.20799E-09_JPRB,0.23913E-09_JPRB,0.26980E-09_JPRB,0.30118E-09_JPRB,0.33239E-09_JPRB /)  
KB(:,19, 4) = (/ &
 & 0.17474E-09_JPRB,0.20037E-09_JPRB,0.22650E-09_JPRB,0.25275E-09_JPRB,0.27848E-09_JPRB /)  
KB(:,20, 4) = (/ &
 & 0.14678E-09_JPRB,0.16826E-09_JPRB,0.19015E-09_JPRB,0.21182E-09_JPRB,0.23321E-09_JPRB /)  
KB(:,21, 4) = (/ &
 & 0.12329E-09_JPRB,0.14137E-09_JPRB,0.15951E-09_JPRB,0.17762E-09_JPRB,0.19539E-09_JPRB /)  
KB(:,22, 4) = (/ &
 & 0.10475E-09_JPRB,0.11989E-09_JPRB,0.13488E-09_JPRB,0.14993E-09_JPRB,0.16481E-09_JPRB /)  
KB(:,23, 4) = (/ &
 & 0.89090E-10_JPRB,0.10156E-09_JPRB,0.11416E-09_JPRB,0.12661E-09_JPRB,0.13928E-09_JPRB /)  
KB(:,24, 4) = (/ &
 & 0.75648E-10_JPRB,0.86094E-10_JPRB,0.96530E-10_JPRB,0.10692E-09_JPRB,0.11716E-09_JPRB /)  
KB(:,25, 4) = (/ &
 & 0.64419E-10_JPRB,0.73036E-10_JPRB,0.81659E-10_JPRB,0.90142E-10_JPRB,0.98524E-10_JPRB /)  
KB(:,26, 4) = (/ &
 & 0.54857E-10_JPRB,0.61972E-10_JPRB,0.69147E-10_JPRB,0.76125E-10_JPRB,0.82778E-10_JPRB /)  
KB(:,27, 4) = (/ &
 & 0.46656E-10_JPRB,0.52591E-10_JPRB,0.58413E-10_JPRB,0.64168E-10_JPRB,0.69451E-10_JPRB /)  
KB(:,28, 4) = (/ &
 & 0.39665E-10_JPRB,0.44561E-10_JPRB,0.49317E-10_JPRB,0.53971E-10_JPRB,0.58228E-10_JPRB /)  
KB(:,29, 4) = (/ &
 & 0.33755E-10_JPRB,0.37736E-10_JPRB,0.41652E-10_JPRB,0.45382E-10_JPRB,0.48825E-10_JPRB /)  
KB(:,30, 4) = (/ &
 & 0.28671E-10_JPRB,0.31949E-10_JPRB,0.35144E-10_JPRB,0.38141E-10_JPRB,0.41003E-10_JPRB /)  
KB(:,31, 4) = (/ &
 & 0.24360E-10_JPRB,0.27027E-10_JPRB,0.29632E-10_JPRB,0.32038E-10_JPRB,0.34391E-10_JPRB /)  
KB(:,32, 4) = (/ &
 & 0.20671E-10_JPRB,0.22852E-10_JPRB,0.24963E-10_JPRB,0.26903E-10_JPRB,0.28818E-10_JPRB /)  
KB(:,33, 4) = (/ &
 & 0.17515E-10_JPRB,0.19306E-10_JPRB,0.20998E-10_JPRB,0.22562E-10_JPRB,0.24113E-10_JPRB /)  
KB(:,34, 4) = (/ &
 & 0.14755E-10_JPRB,0.16223E-10_JPRB,0.17588E-10_JPRB,0.18905E-10_JPRB,0.20105E-10_JPRB /)  
KB(:,35, 4) = (/ &
 & 0.12305E-10_JPRB,0.13505E-10_JPRB,0.14616E-10_JPRB,0.15703E-10_JPRB,0.16661E-10_JPRB /)  
KB(:,36, 4) = (/ &
 & 0.10152E-10_JPRB,0.11132E-10_JPRB,0.12046E-10_JPRB,0.12938E-10_JPRB,0.13718E-10_JPRB /)  
KB(:,37, 4) = (/ &
 & 0.82437E-11_JPRB,0.90546E-11_JPRB,0.98101E-11_JPRB,0.10549E-10_JPRB,0.11200E-10_JPRB /)  
KB(:,38, 4) = (/ &
 & 0.66891E-11_JPRB,0.73572E-11_JPRB,0.79832E-11_JPRB,0.85923E-11_JPRB,0.91388E-11_JPRB /)  
KB(:,39, 4) = (/ &
 & 0.54271E-11_JPRB,0.59789E-11_JPRB,0.64946E-11_JPRB,0.69804E-11_JPRB,0.74536E-11_JPRB /)  
KB(:,40, 4) = (/ &
 & 0.43504E-11_JPRB,0.48077E-11_JPRB,0.52359E-11_JPRB,0.56420E-11_JPRB,0.60390E-11_JPRB /)  
KB(:,41, 4) = (/ &
 & 0.34805E-11_JPRB,0.38570E-11_JPRB,0.42158E-11_JPRB,0.45532E-11_JPRB,0.48856E-11_JPRB /)  
KB(:,42, 4) = (/ &
 & 0.27817E-11_JPRB,0.30896E-11_JPRB,0.33906E-11_JPRB,0.36712E-11_JPRB,0.39504E-11_JPRB /)  
KB(:,43, 4) = (/ &
 & 0.22059E-11_JPRB,0.24603E-11_JPRB,0.27112E-11_JPRB,0.29449E-11_JPRB,0.31673E-11_JPRB /)  
KB(:,44, 4) = (/ &
 & 0.17407E-11_JPRB,0.19508E-11_JPRB,0.21593E-11_JPRB,0.23549E-11_JPRB,0.25394E-11_JPRB /)  
KB(:,45, 4) = (/ &
 & 0.13717E-11_JPRB,0.15444E-11_JPRB,0.17149E-11_JPRB,0.18808E-11_JPRB,0.20349E-11_JPRB /)  
KB(:,46, 4) = (/ &
 & 0.10758E-11_JPRB,0.12178E-11_JPRB,0.13582E-11_JPRB,0.14973E-11_JPRB,0.16264E-11_JPRB /)  
KB(:,47, 4) = (/ &
 & 0.83623E-12_JPRB,0.95326E-12_JPRB,0.10692E-11_JPRB,0.11850E-11_JPRB,0.12934E-11_JPRB /)  
KB(:,48, 4) = (/ &
 & 0.64811E-12_JPRB,0.74426E-12_JPRB,0.84002E-12_JPRB,0.93446E-12_JPRB,0.10270E-11_JPRB /)  
KB(:,49, 4) = (/ &
 & 0.50093E-12_JPRB,0.57976E-12_JPRB,0.65824E-12_JPRB,0.73652E-12_JPRB,0.81364E-12_JPRB /)  
KB(:,50, 4) = (/ &
 & 0.38740E-12_JPRB,0.45167E-12_JPRB,0.51620E-12_JPRB,0.58084E-12_JPRB,0.64495E-12_JPRB /)  
KB(:,51, 4) = (/ &
 & 0.29910E-12_JPRB,0.35149E-12_JPRB,0.40454E-12_JPRB,0.45768E-12_JPRB,0.51010E-12_JPRB /)  
KB(:,52, 4) = (/ &
 & 0.23004E-12_JPRB,0.27291E-12_JPRB,0.31637E-12_JPRB,0.35993E-12_JPRB,0.40313E-12_JPRB /)  
KB(:,53, 4) = (/ &
 & 0.17654E-12_JPRB,0.21129E-12_JPRB,0.24667E-12_JPRB,0.28251E-12_JPRB,0.31798E-12_JPRB /)  
KB(:,54, 4) = (/ &
 & 0.13566E-12_JPRB,0.16388E-12_JPRB,0.19277E-12_JPRB,0.22203E-12_JPRB,0.25140E-12_JPRB /)  
KB(:,55, 4) = (/ &
 & 0.10414E-12_JPRB,0.12705E-12_JPRB,0.15062E-12_JPRB,0.17458E-12_JPRB,0.19863E-12_JPRB /)  
KB(:,56, 4) = (/ &
 & 0.79695E-13_JPRB,0.98154E-13_JPRB,0.11737E-12_JPRB,0.13696E-12_JPRB,0.15674E-12_JPRB /)  
KB(:,57, 4) = (/ &
 & 0.60735E-13_JPRB,0.75667E-13_JPRB,0.91265E-13_JPRB,0.10718E-12_JPRB,0.12346E-12_JPRB /)  
KB(:,58, 4) = (/ &
 & 0.46331E-13_JPRB,0.58316E-13_JPRB,0.71018E-13_JPRB,0.83950E-13_JPRB,0.97215E-13_JPRB /)  
KB(:,59, 4) = (/ &
 & 0.36896E-13_JPRB,0.46643E-13_JPRB,0.57036E-13_JPRB,0.67613E-13_JPRB,0.78545E-13_JPRB /)  
KB(:,13, 5) = (/ &
 & 0.26254E-08_JPRB,0.28627E-08_JPRB,0.30909E-08_JPRB,0.33000E-08_JPRB,0.34892E-08_JPRB /)  
KB(:,14, 5) = (/ &
 & 0.21830E-08_JPRB,0.23794E-08_JPRB,0.25635E-08_JPRB,0.27354E-08_JPRB,0.28987E-08_JPRB /)  
KB(:,15, 5) = (/ &
 & 0.18164E-08_JPRB,0.19772E-08_JPRB,0.21299E-08_JPRB,0.22819E-08_JPRB,0.24177E-08_JPRB /)  
KB(:,16, 5) = (/ &
 & 0.15141E-08_JPRB,0.16500E-08_JPRB,0.17819E-08_JPRB,0.19057E-08_JPRB,0.20139E-08_JPRB /)  
KB(:,17, 5) = (/ &
 & 0.12644E-08_JPRB,0.13791E-08_JPRB,0.14854E-08_JPRB,0.15868E-08_JPRB,0.16779E-08_JPRB /)  
KB(:,18, 5) = (/ &
 & 0.10569E-08_JPRB,0.11490E-08_JPRB,0.12387E-08_JPRB,0.13249E-08_JPRB,0.14004E-08_JPRB /)  
KB(:,19, 5) = (/ &
 & 0.88077E-09_JPRB,0.95771E-09_JPRB,0.10342E-08_JPRB,0.11045E-08_JPRB,0.11654E-08_JPRB /)  
KB(:,20, 5) = (/ &
 & 0.73433E-09_JPRB,0.79954E-09_JPRB,0.86343E-09_JPRB,0.92049E-09_JPRB,0.97111E-09_JPRB /)  
KB(:,21, 5) = (/ &
 & 0.61317E-09_JPRB,0.66751E-09_JPRB,0.72065E-09_JPRB,0.76613E-09_JPRB,0.80891E-09_JPRB /)  
KB(:,22, 5) = (/ &
 & 0.51519E-09_JPRB,0.56066E-09_JPRB,0.60290E-09_JPRB,0.64113E-09_JPRB,0.67719E-09_JPRB /)  
KB(:,23, 5) = (/ &
 & 0.43331E-09_JPRB,0.47103E-09_JPRB,0.50532E-09_JPRB,0.53747E-09_JPRB,0.56589E-09_JPRB /)  
KB(:,24, 5) = (/ &
 & 0.36478E-09_JPRB,0.39531E-09_JPRB,0.42421E-09_JPRB,0.45023E-09_JPRB,0.47333E-09_JPRB /)  
KB(:,25, 5) = (/ &
 & 0.30661E-09_JPRB,0.33249E-09_JPRB,0.35642E-09_JPRB,0.37711E-09_JPRB,0.39645E-09_JPRB /)  
KB(:,26, 5) = (/ &
 & 0.25851E-09_JPRB,0.28030E-09_JPRB,0.29893E-09_JPRB,0.31621E-09_JPRB,0.33249E-09_JPRB /)  
KB(:,27, 5) = (/ &
 & 0.21849E-09_JPRB,0.23581E-09_JPRB,0.25124E-09_JPRB,0.26548E-09_JPRB,0.27889E-09_JPRB /)  
KB(:,28, 5) = (/ &
 & 0.18476E-09_JPRB,0.19866E-09_JPRB,0.21115E-09_JPRB,0.22285E-09_JPRB,0.23419E-09_JPRB /)  
KB(:,29, 5) = (/ &
 & 0.15608E-09_JPRB,0.16725E-09_JPRB,0.17764E-09_JPRB,0.18744E-09_JPRB,0.19627E-09_JPRB /)  
KB(:,30, 5) = (/ &
 & 0.13180E-09_JPRB,0.14084E-09_JPRB,0.14944E-09_JPRB,0.15734E-09_JPRB,0.16419E-09_JPRB /)  
KB(:,31, 5) = (/ &
 & 0.11122E-09_JPRB,0.11878E-09_JPRB,0.12548E-09_JPRB,0.13183E-09_JPRB,0.13690E-09_JPRB /)  
KB(:,32, 5) = (/ &
 & 0.93806E-10_JPRB,0.99909E-10_JPRB,0.10547E-09_JPRB,0.11013E-09_JPRB,0.11393E-09_JPRB /)  
KB(:,33, 5) = (/ &
 & 0.79057E-10_JPRB,0.83869E-10_JPRB,0.88337E-10_JPRB,0.91833E-10_JPRB,0.94728E-10_JPRB /)  
KB(:,34, 5) = (/ &
 & 0.66383E-10_JPRB,0.70216E-10_JPRB,0.73644E-10_JPRB,0.76467E-10_JPRB,0.78589E-10_JPRB /)  
KB(:,35, 5) = (/ &
 & 0.55303E-10_JPRB,0.58435E-10_JPRB,0.61122E-10_JPRB,0.63317E-10_JPRB,0.64984E-10_JPRB /)  
KB(:,36, 5) = (/ &
 & 0.45788E-10_JPRB,0.48318E-10_JPRB,0.50463E-10_JPRB,0.52237E-10_JPRB,0.53589E-10_JPRB /)  
KB(:,37, 5) = (/ &
 & 0.37517E-10_JPRB,0.39593E-10_JPRB,0.41407E-10_JPRB,0.42883E-10_JPRB,0.44012E-10_JPRB /)  
KB(:,38, 5) = (/ &
 & 0.30717E-10_JPRB,0.32436E-10_JPRB,0.33950E-10_JPRB,0.35197E-10_JPRB,0.36146E-10_JPRB /)  
KB(:,39, 5) = (/ &
 & 0.25129E-10_JPRB,0.26560E-10_JPRB,0.27827E-10_JPRB,0.28835E-10_JPRB,0.29676E-10_JPRB /)  
KB(:,40, 5) = (/ &
 & 0.20420E-10_JPRB,0.21620E-10_JPRB,0.22699E-10_JPRB,0.23564E-10_JPRB,0.24290E-10_JPRB /)  
KB(:,41, 5) = (/ &
 & 0.16561E-10_JPRB,0.17583E-10_JPRB,0.18496E-10_JPRB,0.19245E-10_JPRB,0.19868E-10_JPRB /)  
KB(:,42, 5) = (/ &
 & 0.13418E-10_JPRB,0.14291E-10_JPRB,0.15059E-10_JPRB,0.15706E-10_JPRB,0.16243E-10_JPRB /)  
KB(:,43, 5) = (/ &
 & 0.10810E-10_JPRB,0.11562E-10_JPRB,0.12210E-10_JPRB,0.12774E-10_JPRB,0.13223E-10_JPRB /)  
KB(:,44, 5) = (/ &
 & 0.86843E-11_JPRB,0.93265E-11_JPRB,0.98789E-11_JPRB,0.10369E-10_JPRB,0.10770E-10_JPRB /)  
KB(:,45, 5) = (/ &
 & 0.69593E-11_JPRB,0.75111E-11_JPRB,0.79891E-11_JPRB,0.84084E-11_JPRB,0.87638E-11_JPRB /)  
KB(:,46, 5) = (/ &
 & 0.55576E-11_JPRB,0.60308E-11_JPRB,0.64400E-11_JPRB,0.68030E-11_JPRB,0.71149E-11_JPRB /)  
KB(:,47, 5) = (/ &
 & 0.44097E-11_JPRB,0.48155E-11_JPRB,0.51709E-11_JPRB,0.54794E-11_JPRB,0.57570E-11_JPRB /)  
KB(:,48, 5) = (/ &
 & 0.34877E-11_JPRB,0.38384E-11_JPRB,0.41433E-11_JPRB,0.44120E-11_JPRB,0.46521E-11_JPRB /)  
KB(:,49, 5) = (/ &
 & 0.27512E-11_JPRB,0.30491E-11_JPRB,0.33123E-11_JPRB,0.35456E-11_JPRB,0.37509E-11_JPRB /)  
KB(:,50, 5) = (/ &
 & 0.21734E-11_JPRB,0.24185E-11_JPRB,0.26481E-11_JPRB,0.28485E-11_JPRB,0.30236E-11_JPRB /)  
KB(:,51, 5) = (/ &
 & 0.17150E-11_JPRB,0.19185E-11_JPRB,0.21147E-11_JPRB,0.22857E-11_JPRB,0.24371E-11_JPRB /)  
KB(:,52, 5) = (/ &
 & 0.13499E-11_JPRB,0.15196E-11_JPRB,0.16853E-11_JPRB,0.18315E-11_JPRB,0.19613E-11_JPRB /)  
KB(:,53, 5) = (/ &
 & 0.10590E-11_JPRB,0.11989E-11_JPRB,0.13374E-11_JPRB,0.14641E-11_JPRB,0.15756E-11_JPRB /)  
KB(:,54, 5) = (/ &
 & 0.83182E-12_JPRB,0.94832E-12_JPRB,0.10625E-11_JPRB,0.11713E-11_JPRB,0.12669E-11_JPRB /)  
KB(:,55, 5) = (/ &
 & 0.65257E-12_JPRB,0.74992E-12_JPRB,0.84445E-12_JPRB,0.93664E-12_JPRB,0.10175E-11_JPRB /)  
KB(:,56, 5) = (/ &
 & 0.51109E-12_JPRB,0.59162E-12_JPRB,0.67030E-12_JPRB,0.74706E-12_JPRB,0.81634E-12_JPRB /)  
KB(:,57, 5) = (/ &
 & 0.39868E-12_JPRB,0.46532E-12_JPRB,0.53042E-12_JPRB,0.59449E-12_JPRB,0.65374E-12_JPRB /)  
KB(:,58, 5) = (/ &
 & 0.31062E-12_JPRB,0.36629E-12_JPRB,0.42009E-12_JPRB,0.47298E-12_JPRB,0.52357E-12_JPRB /)  
KB(:,59, 5) = (/ &
 & 0.24996E-12_JPRB,0.29597E-12_JPRB,0.34052E-12_JPRB,0.38403E-12_JPRB,0.42584E-12_JPRB /)  
KB(:,13, 6) = (/ &
 & 0.10275E-07_JPRB,0.10425E-07_JPRB,0.10505E-07_JPRB,0.10571E-07_JPRB,0.10619E-07_JPRB /)  
KB(:,14, 6) = (/ &
 & 0.84309E-08_JPRB,0.85528E-08_JPRB,0.86280E-08_JPRB,0.86935E-08_JPRB,0.87236E-08_JPRB /)  
KB(:,15, 6) = (/ &
 & 0.69259E-08_JPRB,0.70218E-08_JPRB,0.71031E-08_JPRB,0.71419E-08_JPRB,0.71430E-08_JPRB /)  
KB(:,16, 6) = (/ &
 & 0.56933E-08_JPRB,0.57765E-08_JPRB,0.58298E-08_JPRB,0.58527E-08_JPRB,0.58704E-08_JPRB /)  
KB(:,17, 6) = (/ &
 & 0.46880E-08_JPRB,0.47555E-08_JPRB,0.47985E-08_JPRB,0.48270E-08_JPRB,0.48471E-08_JPRB /)  
KB(:,18, 6) = (/ &
 & 0.38628E-08_JPRB,0.39183E-08_JPRB,0.39591E-08_JPRB,0.39923E-08_JPRB,0.40106E-08_JPRB /)  
KB(:,19, 6) = (/ &
 & 0.31833E-08_JPRB,0.32370E-08_JPRB,0.32750E-08_JPRB,0.32992E-08_JPRB,0.33139E-08_JPRB /)  
KB(:,20, 6) = (/ &
 & 0.26315E-08_JPRB,0.26765E-08_JPRB,0.27033E-08_JPRB,0.27208E-08_JPRB,0.27412E-08_JPRB /)  
KB(:,21, 6) = (/ &
 & 0.21768E-08_JPRB,0.22074E-08_JPRB,0.22281E-08_JPRB,0.22492E-08_JPRB,0.22648E-08_JPRB /)  
KB(:,22, 6) = (/ &
 & 0.17970E-08_JPRB,0.18204E-08_JPRB,0.18421E-08_JPRB,0.18603E-08_JPRB,0.18697E-08_JPRB /)  
KB(:,23, 6) = (/ &
 & 0.14828E-08_JPRB,0.15043E-08_JPRB,0.15235E-08_JPRB,0.15373E-08_JPRB,0.15469E-08_JPRB /)  
KB(:,24, 6) = (/ &
 & 0.12265E-08_JPRB,0.12457E-08_JPRB,0.12602E-08_JPRB,0.12704E-08_JPRB,0.12795E-08_JPRB /)  
KB(:,25, 6) = (/ &
 & 0.10153E-08_JPRB,0.10303E-08_JPRB,0.10406E-08_JPRB,0.10511E-08_JPRB,0.10591E-08_JPRB /)  
KB(:,26, 6) = (/ &
 & 0.84067E-09_JPRB,0.85220E-09_JPRB,0.86139E-09_JPRB,0.87145E-09_JPRB,0.87606E-09_JPRB /)  
KB(:,27, 6) = (/ &
 & 0.69556E-09_JPRB,0.70441E-09_JPRB,0.71396E-09_JPRB,0.72098E-09_JPRB,0.72486E-09_JPRB /)  
KB(:,28, 6) = (/ &
 & 0.57505E-09_JPRB,0.58326E-09_JPRB,0.59186E-09_JPRB,0.59662E-09_JPRB,0.60056E-09_JPRB /)  
KB(:,29, 6) = (/ &
 & 0.47621E-09_JPRB,0.48459E-09_JPRB,0.49079E-09_JPRB,0.49432E-09_JPRB,0.49717E-09_JPRB /)  
KB(:,30, 6) = (/ &
 & 0.39513E-09_JPRB,0.40232E-09_JPRB,0.40640E-09_JPRB,0.40995E-09_JPRB,0.41263E-09_JPRB /)  
KB(:,31, 6) = (/ &
 & 0.32890E-09_JPRB,0.33390E-09_JPRB,0.33797E-09_JPRB,0.34036E-09_JPRB,0.34440E-09_JPRB /)  
KB(:,32, 6) = (/ &
 & 0.27372E-09_JPRB,0.27757E-09_JPRB,0.28057E-09_JPRB,0.28360E-09_JPRB,0.28668E-09_JPRB /)  
KB(:,33, 6) = (/ &
 & 0.22771E-09_JPRB,0.23074E-09_JPRB,0.23349E-09_JPRB,0.23595E-09_JPRB,0.23797E-09_JPRB /)  
KB(:,34, 6) = (/ &
 & 0.18899E-09_JPRB,0.19179E-09_JPRB,0.19391E-09_JPRB,0.19591E-09_JPRB,0.19720E-09_JPRB /)  
KB(:,35, 6) = (/ &
 & 0.15677E-09_JPRB,0.15897E-09_JPRB,0.16075E-09_JPRB,0.16219E-09_JPRB,0.16318E-09_JPRB /)  
KB(:,36, 6) = (/ &
 & 0.12972E-09_JPRB,0.13147E-09_JPRB,0.13291E-09_JPRB,0.13412E-09_JPRB,0.13484E-09_JPRB /)  
KB(:,37, 6) = (/ &
 & 0.10704E-09_JPRB,0.10855E-09_JPRB,0.10970E-09_JPRB,0.11065E-09_JPRB,0.11129E-09_JPRB /)  
KB(:,38, 6) = (/ &
 & 0.88219E-10_JPRB,0.89571E-10_JPRB,0.90489E-10_JPRB,0.91263E-10_JPRB,0.91821E-10_JPRB /)  
KB(:,39, 6) = (/ &
 & 0.72709E-10_JPRB,0.73884E-10_JPRB,0.74615E-10_JPRB,0.75144E-10_JPRB,0.75719E-10_JPRB /)  
KB(:,40, 6) = (/ &
 & 0.59779E-10_JPRB,0.60793E-10_JPRB,0.61424E-10_JPRB,0.61873E-10_JPRB,0.62379E-10_JPRB /)  
KB(:,41, 6) = (/ &
 & 0.49104E-10_JPRB,0.49999E-10_JPRB,0.50541E-10_JPRB,0.50924E-10_JPRB,0.51369E-10_JPRB /)  
KB(:,42, 6) = (/ &
 & 0.40324E-10_JPRB,0.41079E-10_JPRB,0.41584E-10_JPRB,0.41914E-10_JPRB,0.42279E-10_JPRB /)  
KB(:,43, 6) = (/ &
 & 0.33050E-10_JPRB,0.33695E-10_JPRB,0.34173E-10_JPRB,0.34462E-10_JPRB,0.34716E-10_JPRB /)  
KB(:,44, 6) = (/ &
 & 0.27054E-10_JPRB,0.27604E-10_JPRB,0.28056E-10_JPRB,0.28313E-10_JPRB,0.28542E-10_JPRB /)  
KB(:,45, 6) = (/ &
 & 0.22112E-10_JPRB,0.22613E-10_JPRB,0.23018E-10_JPRB,0.23255E-10_JPRB,0.23441E-10_JPRB /)  
KB(:,46, 6) = (/ &
 & 0.18060E-10_JPRB,0.18501E-10_JPRB,0.18867E-10_JPRB,0.19082E-10_JPRB,0.19252E-10_JPRB /)  
KB(:,47, 6) = (/ &
 & 0.14722E-10_JPRB,0.15111E-10_JPRB,0.15432E-10_JPRB,0.15658E-10_JPRB,0.15802E-10_JPRB /)  
KB(:,48, 6) = (/ &
 & 0.11985E-10_JPRB,0.12318E-10_JPRB,0.12624E-10_JPRB,0.12826E-10_JPRB,0.12965E-10_JPRB /)  
KB(:,49, 6) = (/ &
 & 0.97421E-11_JPRB,0.10040E-10_JPRB,0.10306E-10_JPRB,0.10499E-10_JPRB,0.10630E-10_JPRB /)  
KB(:,50, 6) = (/ &
 & 0.79055E-11_JPRB,0.81823E-11_JPRB,0.84121E-11_JPRB,0.85902E-11_JPRB,0.87163E-11_JPRB /)  
KB(:,51, 6) = (/ &
 & 0.64164E-11_JPRB,0.66612E-11_JPRB,0.68621E-11_JPRB,0.70240E-11_JPRB,0.71428E-11_JPRB /)  
KB(:,52, 6) = (/ &
 & 0.51935E-11_JPRB,0.54159E-11_JPRB,0.55861E-11_JPRB,0.57406E-11_JPRB,0.58465E-11_JPRB /)  
KB(:,53, 6) = (/ &
 & 0.42017E-11_JPRB,0.43985E-11_JPRB,0.45525E-11_JPRB,0.46862E-11_JPRB,0.47817E-11_JPRB /)  
KB(:,54, 6) = (/ &
 & 0.33953E-11_JPRB,0.35701E-11_JPRB,0.37080E-11_JPRB,0.38204E-11_JPRB,0.39118E-11_JPRB /)  
KB(:,55, 6) = (/ &
 & 0.27420E-11_JPRB,0.28948E-11_JPRB,0.30166E-11_JPRB,0.31148E-11_JPRB,0.31981E-11_JPRB /)  
KB(:,56, 6) = (/ &
 & 0.22097E-11_JPRB,0.23440E-11_JPRB,0.24518E-11_JPRB,0.25378E-11_JPRB,0.26122E-11_JPRB /)  
KB(:,57, 6) = (/ &
 & 0.17765E-11_JPRB,0.18968E-11_JPRB,0.19913E-11_JPRB,0.20659E-11_JPRB,0.21319E-11_JPRB /)  
KB(:,58, 6) = (/ &
 & 0.14264E-11_JPRB,0.15324E-11_JPRB,0.16166E-11_JPRB,0.16816E-11_JPRB,0.17374E-11_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART13',1,ZHOOK_HANDLE)
END SUBROUTINE PART13


SUBROUTINE PART14

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART14',0,ZHOOK_HANDLE)


KB(:,59, 6) = (/ &
 & 0.11621E-11_JPRB,0.12515E-11_JPRB,0.13230E-11_JPRB,0.13773E-11_JPRB,0.14240E-11_JPRB /)  
KB(:,13, 7) = (/ &
 & 0.28079E-07_JPRB,0.28035E-07_JPRB,0.27949E-07_JPRB,0.27835E-07_JPRB,0.27661E-07_JPRB /)  
KB(:,14, 7) = (/ &
 & 0.23041E-07_JPRB,0.22982E-07_JPRB,0.22914E-07_JPRB,0.22814E-07_JPRB,0.22653E-07_JPRB /)  
KB(:,15, 7) = (/ &
 & 0.18899E-07_JPRB,0.18860E-07_JPRB,0.18790E-07_JPRB,0.18675E-07_JPRB,0.18596E-07_JPRB /)  
KB(:,16, 7) = (/ &
 & 0.15489E-07_JPRB,0.15457E-07_JPRB,0.15389E-07_JPRB,0.15337E-07_JPRB,0.15329E-07_JPRB /)  
KB(:,17, 7) = (/ &
 & 0.12699E-07_JPRB,0.12665E-07_JPRB,0.12634E-07_JPRB,0.12640E-07_JPRB,0.12612E-07_JPRB /)  
KB(:,18, 7) = (/ &
 & 0.10409E-07_JPRB,0.10397E-07_JPRB,0.10401E-07_JPRB,0.10391E-07_JPRB,0.10368E-07_JPRB /)  
KB(:,19, 7) = (/ &
 & 0.85482E-08_JPRB,0.85403E-08_JPRB,0.85408E-08_JPRB,0.85379E-08_JPRB,0.85325E-08_JPRB /)  
KB(:,20, 7) = (/ &
 & 0.70183E-08_JPRB,0.70212E-08_JPRB,0.70225E-08_JPRB,0.70232E-08_JPRB,0.70243E-08_JPRB /)  
KB(:,21, 7) = (/ &
 & 0.57704E-08_JPRB,0.57836E-08_JPRB,0.57919E-08_JPRB,0.57990E-08_JPRB,0.58135E-08_JPRB /)  
KB(:,22, 7) = (/ &
 & 0.47522E-08_JPRB,0.47673E-08_JPRB,0.47834E-08_JPRB,0.48084E-08_JPRB,0.48239E-08_JPRB /)  
KB(:,23, 7) = (/ &
 & 0.39186E-08_JPRB,0.39439E-08_JPRB,0.39679E-08_JPRB,0.39863E-08_JPRB,0.40063E-08_JPRB /)  
KB(:,24, 7) = (/ &
 & 0.32407E-08_JPRB,0.32645E-08_JPRB,0.32840E-08_JPRB,0.33039E-08_JPRB,0.33353E-08_JPRB /)  
KB(:,25, 7) = (/ &
 & 0.26846E-08_JPRB,0.27012E-08_JPRB,0.27199E-08_JPRB,0.27477E-08_JPRB,0.27761E-08_JPRB /)  
KB(:,26, 7) = (/ &
 & 0.22196E-08_JPRB,0.22367E-08_JPRB,0.22646E-08_JPRB,0.22896E-08_JPRB,0.23141E-08_JPRB /)  
KB(:,27, 7) = (/ &
 & 0.18370E-08_JPRB,0.18616E-08_JPRB,0.18864E-08_JPRB,0.19087E-08_JPRB,0.19319E-08_JPRB /)  
KB(:,28, 7) = (/ &
 & 0.15259E-08_JPRB,0.15495E-08_JPRB,0.15695E-08_JPRB,0.15912E-08_JPRB,0.16152E-08_JPRB /)  
KB(:,29, 7) = (/ &
 & 0.12717E-08_JPRB,0.12907E-08_JPRB,0.13087E-08_JPRB,0.13304E-08_JPRB,0.13523E-08_JPRB /)  
KB(:,30, 7) = (/ &
 & 0.10599E-08_JPRB,0.10765E-08_JPRB,0.10939E-08_JPRB,0.11139E-08_JPRB,0.11374E-08_JPRB /)  
KB(:,31, 7) = (/ &
 & 0.88411E-09_JPRB,0.89833E-09_JPRB,0.91628E-09_JPRB,0.93662E-09_JPRB,0.95540E-09_JPRB /)  
KB(:,32, 7) = (/ &
 & 0.73723E-09_JPRB,0.75198E-09_JPRB,0.77042E-09_JPRB,0.78608E-09_JPRB,0.80601E-09_JPRB /)  
KB(:,33, 7) = (/ &
 & 0.61511E-09_JPRB,0.63161E-09_JPRB,0.64646E-09_JPRB,0.66232E-09_JPRB,0.68095E-09_JPRB /)  
KB(:,34, 7) = (/ &
 & 0.51621E-09_JPRB,0.53001E-09_JPRB,0.54332E-09_JPRB,0.55986E-09_JPRB,0.57326E-09_JPRB /)  
KB(:,35, 7) = (/ &
 & 0.43217E-09_JPRB,0.44439E-09_JPRB,0.45713E-09_JPRB,0.47103E-09_JPRB,0.48242E-09_JPRB /)  
KB(:,36, 7) = (/ &
 & 0.36090E-09_JPRB,0.37166E-09_JPRB,0.38311E-09_JPRB,0.39461E-09_JPRB,0.40545E-09_JPRB /)  
KB(:,37, 7) = (/ &
 & 0.29990E-09_JPRB,0.30916E-09_JPRB,0.31937E-09_JPRB,0.32943E-09_JPRB,0.34038E-09_JPRB /)  
KB(:,38, 7) = (/ &
 & 0.24927E-09_JPRB,0.25737E-09_JPRB,0.26638E-09_JPRB,0.27543E-09_JPRB,0.28596E-09_JPRB /)  
KB(:,39, 7) = (/ &
 & 0.20718E-09_JPRB,0.21434E-09_JPRB,0.22203E-09_JPRB,0.23026E-09_JPRB,0.23966E-09_JPRB /)  
KB(:,40, 7) = (/ &
 & 0.17122E-09_JPRB,0.17745E-09_JPRB,0.18425E-09_JPRB,0.19138E-09_JPRB,0.19937E-09_JPRB /)  
KB(:,41, 7) = (/ &
 & 0.14145E-09_JPRB,0.14673E-09_JPRB,0.15273E-09_JPRB,0.15885E-09_JPRB,0.16544E-09_JPRB /)  
KB(:,42, 7) = (/ &
 & 0.11673E-09_JPRB,0.12130E-09_JPRB,0.12626E-09_JPRB,0.13156E-09_JPRB,0.13718E-09_JPRB /)  
KB(:,43, 7) = (/ &
 & 0.95979E-10_JPRB,0.99773E-10_JPRB,0.10407E-09_JPRB,0.10848E-09_JPRB,0.11289E-09_JPRB /)  
KB(:,44, 7) = (/ &
 & 0.78684E-10_JPRB,0.81894E-10_JPRB,0.85476E-10_JPRB,0.89249E-10_JPRB,0.92971E-10_JPRB /)  
KB(:,45, 7) = (/ &
 & 0.64482E-10_JPRB,0.67161E-10_JPRB,0.70163E-10_JPRB,0.73315E-10_JPRB,0.76486E-10_JPRB /)  
KB(:,46, 7) = (/ &
 & 0.52720E-10_JPRB,0.54998E-10_JPRB,0.57509E-10_JPRB,0.60128E-10_JPRB,0.62787E-10_JPRB /)  
KB(:,47, 7) = (/ &
 & 0.42902E-10_JPRB,0.44887E-10_JPRB,0.46948E-10_JPRB,0.49098E-10_JPRB,0.51392E-10_JPRB /)  
KB(:,48, 7) = (/ &
 & 0.34914E-10_JPRB,0.36612E-10_JPRB,0.38268E-10_JPRB,0.40114E-10_JPRB,0.41998E-10_JPRB /)  
KB(:,49, 7) = (/ &
 & 0.28363E-10_JPRB,0.29830E-10_JPRB,0.31160E-10_JPRB,0.32712E-10_JPRB,0.34278E-10_JPRB /)  
KB(:,50, 7) = (/ &
 & 0.23044E-10_JPRB,0.24298E-10_JPRB,0.25411E-10_JPRB,0.26663E-10_JPRB,0.27956E-10_JPRB /)  
KB(:,51, 7) = (/ &
 & 0.18719E-10_JPRB,0.19762E-10_JPRB,0.20717E-10_JPRB,0.21748E-10_JPRB,0.22834E-10_JPRB /)  
KB(:,52, 7) = (/ &
 & 0.15214E-10_JPRB,0.16060E-10_JPRB,0.16882E-10_JPRB,0.17722E-10_JPRB,0.18609E-10_JPRB /)  
KB(:,53, 7) = (/ &
 & 0.12339E-10_JPRB,0.13039E-10_JPRB,0.13738E-10_JPRB,0.14413E-10_JPRB,0.15144E-10_JPRB /)  
KB(:,54, 7) = (/ &
 & 0.10028E-10_JPRB,0.10589E-10_JPRB,0.11176E-10_JPRB,0.11743E-10_JPRB,0.12340E-10_JPRB /)  
KB(:,55, 7) = (/ &
 & 0.81332E-11_JPRB,0.85988E-11_JPRB,0.90904E-11_JPRB,0.95545E-11_JPRB,0.10057E-10_JPRB /)  
KB(:,56, 7) = (/ &
 & 0.66047E-11_JPRB,0.69777E-11_JPRB,0.73796E-11_JPRB,0.77755E-11_JPRB,0.81880E-11_JPRB /)  
KB(:,57, 7) = (/ &
 & 0.53536E-11_JPRB,0.56554E-11_JPRB,0.59940E-11_JPRB,0.63232E-11_JPRB,0.66612E-11_JPRB /)  
KB(:,58, 7) = (/ &
 & 0.43329E-11_JPRB,0.45903E-11_JPRB,0.48661E-11_JPRB,0.51412E-11_JPRB,0.54200E-11_JPRB /)  
KB(:,59, 7) = (/ &
 & 0.35522E-11_JPRB,0.37646E-11_JPRB,0.39940E-11_JPRB,0.42211E-11_JPRB,0.44525E-11_JPRB /)  
KB(:,13, 8) = (/ &
 & 0.11230E-06_JPRB,0.11409E-06_JPRB,0.11566E-06_JPRB,0.11672E-06_JPRB,0.11734E-06_JPRB /)  
KB(:,14, 8) = (/ &
 & 0.92428E-07_JPRB,0.93878E-07_JPRB,0.95014E-07_JPRB,0.95711E-07_JPRB,0.96110E-07_JPRB /)  
KB(:,15, 8) = (/ &
 & 0.76021E-07_JPRB,0.77148E-07_JPRB,0.77913E-07_JPRB,0.78505E-07_JPRB,0.78756E-07_JPRB /)  
KB(:,16, 8) = (/ &
 & 0.62512E-07_JPRB,0.63402E-07_JPRB,0.63979E-07_JPRB,0.64292E-07_JPRB,0.64352E-07_JPRB /)  
KB(:,17, 8) = (/ &
 & 0.51480E-07_JPRB,0.52099E-07_JPRB,0.52465E-07_JPRB,0.52634E-07_JPRB,0.52753E-07_JPRB /)  
KB(:,18, 8) = (/ &
 & 0.42336E-07_JPRB,0.42773E-07_JPRB,0.43015E-07_JPRB,0.43145E-07_JPRB,0.43290E-07_JPRB /)  
KB(:,19, 8) = (/ &
 & 0.34820E-07_JPRB,0.35138E-07_JPRB,0.35326E-07_JPRB,0.35465E-07_JPRB,0.35546E-07_JPRB /)  
KB(:,20, 8) = (/ &
 & 0.28634E-07_JPRB,0.28882E-07_JPRB,0.29099E-07_JPRB,0.29190E-07_JPRB,0.29248E-07_JPRB /)  
KB(:,21, 8) = (/ &
 & 0.23527E-07_JPRB,0.23767E-07_JPRB,0.23879E-07_JPRB,0.24001E-07_JPRB,0.24136E-07_JPRB /)  
KB(:,22, 8) = (/ &
 & 0.19380E-07_JPRB,0.19526E-07_JPRB,0.19668E-07_JPRB,0.19823E-07_JPRB,0.20000E-07_JPRB /)  
KB(:,23, 8) = (/ &
 & 0.15955E-07_JPRB,0.16103E-07_JPRB,0.16252E-07_JPRB,0.16425E-07_JPRB,0.16561E-07_JPRB /)  
KB(:,24, 8) = (/ &
 & 0.13163E-07_JPRB,0.13294E-07_JPRB,0.13466E-07_JPRB,0.13609E-07_JPRB,0.13701E-07_JPRB /)  
KB(:,25, 8) = (/ &
 & 0.10863E-07_JPRB,0.11029E-07_JPRB,0.11155E-07_JPRB,0.11256E-07_JPRB,0.11368E-07_JPRB /)  
KB(:,26, 8) = (/ &
 & 0.90043E-08_JPRB,0.91173E-08_JPRB,0.92226E-08_JPRB,0.93261E-08_JPRB,0.94322E-08_JPRB /)  
KB(:,27, 8) = (/ &
 & 0.74604E-08_JPRB,0.75548E-08_JPRB,0.76410E-08_JPRB,0.77390E-08_JPRB,0.78488E-08_JPRB /)  
KB(:,28, 8) = (/ &
 & 0.61944E-08_JPRB,0.62754E-08_JPRB,0.63658E-08_JPRB,0.64728E-08_JPRB,0.65523E-08_JPRB /)  
KB(:,29, 8) = (/ &
 & 0.51553E-08_JPRB,0.52390E-08_JPRB,0.53444E-08_JPRB,0.54244E-08_JPRB,0.55104E-08_JPRB /)  
KB(:,30, 8) = (/ &
 & 0.43022E-08_JPRB,0.44056E-08_JPRB,0.44906E-08_JPRB,0.45753E-08_JPRB,0.46815E-08_JPRB /)  
KB(:,31, 8) = (/ &
 & 0.36260E-08_JPRB,0.37147E-08_JPRB,0.37854E-08_JPRB,0.38857E-08_JPRB,0.39725E-08_JPRB /)  
KB(:,32, 8) = (/ &
 & 0.30574E-08_JPRB,0.31222E-08_JPRB,0.32149E-08_JPRB,0.32959E-08_JPRB,0.33679E-08_JPRB /)  
KB(:,33, 8) = (/ &
 & 0.25690E-08_JPRB,0.26475E-08_JPRB,0.27306E-08_JPRB,0.27942E-08_JPRB,0.28607E-08_JPRB /)  
KB(:,34, 8) = (/ &
 & 0.21739E-08_JPRB,0.22522E-08_JPRB,0.23131E-08_JPRB,0.23724E-08_JPRB,0.24398E-08_JPRB /)  
KB(:,35, 8) = (/ &
 & 0.18403E-08_JPRB,0.19033E-08_JPRB,0.19580E-08_JPRB,0.20191E-08_JPRB,0.20792E-08_JPRB /)  
KB(:,36, 8) = (/ &
 & 0.15538E-08_JPRB,0.16068E-08_JPRB,0.16535E-08_JPRB,0.17159E-08_JPRB,0.17681E-08_JPRB /)  
KB(:,37, 8) = (/ &
 & 0.13002E-08_JPRB,0.13483E-08_JPRB,0.13923E-08_JPRB,0.14493E-08_JPRB,0.14927E-08_JPRB /)  
KB(:,38, 8) = (/ &
 & 0.10893E-08_JPRB,0.11319E-08_JPRB,0.11765E-08_JPRB,0.12253E-08_JPRB,0.12624E-08_JPRB /)  
KB(:,39, 8) = (/ &
 & 0.91348E-09_JPRB,0.95067E-09_JPRB,0.99134E-09_JPRB,0.10293E-08_JPRB,0.10668E-08_JPRB /)  
KB(:,40, 8) = (/ &
 & 0.76170E-09_JPRB,0.79404E-09_JPRB,0.82953E-09_JPRB,0.86548E-09_JPRB,0.90041E-09_JPRB /)  
KB(:,41, 8) = (/ &
 & 0.63292E-09_JPRB,0.66170E-09_JPRB,0.69363E-09_JPRB,0.72573E-09_JPRB,0.75710E-09_JPRB /)  
KB(:,42, 8) = (/ &
 & 0.52609E-09_JPRB,0.55120E-09_JPRB,0.57974E-09_JPRB,0.60803E-09_JPRB,0.63636E-09_JPRB /)  
KB(:,43, 8) = (/ &
 & 0.43444E-09_JPRB,0.45674E-09_JPRB,0.48206E-09_JPRB,0.50747E-09_JPRB,0.53053E-09_JPRB /)  
KB(:,44, 8) = (/ &
 & 0.35755E-09_JPRB,0.37758E-09_JPRB,0.39965E-09_JPRB,0.42169E-09_JPRB,0.44276E-09_JPRB /)  
KB(:,45, 8) = (/ &
 & 0.29410E-09_JPRB,0.31126E-09_JPRB,0.33079E-09_JPRB,0.35014E-09_JPRB,0.36874E-09_JPRB /)  
KB(:,46, 8) = (/ &
 & 0.24113E-09_JPRB,0.25605E-09_JPRB,0.27273E-09_JPRB,0.28962E-09_JPRB,0.30646E-09_JPRB /)  
KB(:,47, 8) = (/ &
 & 0.19675E-09_JPRB,0.20937E-09_JPRB,0.22390E-09_JPRB,0.23865E-09_JPRB,0.25330E-09_JPRB /)  
KB(:,48, 8) = (/ &
 & 0.16029E-09_JPRB,0.17125E-09_JPRB,0.18339E-09_JPRB,0.19620E-09_JPRB,0.20918E-09_JPRB /)  
KB(:,49, 8) = (/ &
 & 0.13018E-09_JPRB,0.13961E-09_JPRB,0.15020E-09_JPRB,0.16108E-09_JPRB,0.17231E-09_JPRB /)  
KB(:,50, 8) = (/ &
 & 0.10559E-09_JPRB,0.11394E-09_JPRB,0.12271E-09_JPRB,0.13208E-09_JPRB,0.14200E-09_JPRB /)  
KB(:,51, 8) = (/ &
 & 0.85569E-10_JPRB,0.92775E-10_JPRB,0.10011E-09_JPRB,0.10818E-09_JPRB,0.11665E-09_JPRB /)  
KB(:,52, 8) = (/ &
 & 0.69342E-10_JPRB,0.75341E-10_JPRB,0.81596E-10_JPRB,0.88527E-10_JPRB,0.95876E-10_JPRB /)  
KB(:,53, 8) = (/ &
 & 0.56003E-10_JPRB,0.61203E-10_JPRB,0.66389E-10_JPRB,0.72376E-10_JPRB,0.78642E-10_JPRB /)  
KB(:,54, 8) = (/ &
 & 0.45380E-10_JPRB,0.49599E-10_JPRB,0.54006E-10_JPRB,0.59069E-10_JPRB,0.64380E-10_JPRB /)  
KB(:,55, 8) = (/ &
 & 0.36637E-10_JPRB,0.40078E-10_JPRB,0.43990E-10_JPRB,0.48279E-10_JPRB,0.52815E-10_JPRB /)  
KB(:,56, 8) = (/ &
 & 0.29596E-10_JPRB,0.32455E-10_JPRB,0.35694E-10_JPRB,0.39315E-10_JPRB,0.43169E-10_JPRB /)  
KB(:,57, 8) = (/ &
 & 0.23911E-10_JPRB,0.26268E-10_JPRB,0.28916E-10_JPRB,0.31929E-10_JPRB,0.35182E-10_JPRB /)  
KB(:,58, 8) = (/ &
 & 0.19299E-10_JPRB,0.21198E-10_JPRB,0.23407E-10_JPRB,0.25936E-10_JPRB,0.28689E-10_JPRB /)  
KB(:,59, 8) = (/ &
 & 0.15839E-10_JPRB,0.17448E-10_JPRB,0.19334E-10_JPRB,0.21469E-10_JPRB,0.23829E-10_JPRB /)  
KB(:,13, 9) = (/ &
 & 0.96471E-06_JPRB,0.97408E-06_JPRB,0.98436E-06_JPRB,0.99439E-06_JPRB,0.10050E-05_JPRB /)  
KB(:,14, 9) = (/ &
 & 0.80904E-06_JPRB,0.81838E-06_JPRB,0.82742E-06_JPRB,0.83703E-06_JPRB,0.84742E-06_JPRB /)  
KB(:,15, 9) = (/ &
 & 0.67733E-06_JPRB,0.68563E-06_JPRB,0.69403E-06_JPRB,0.70345E-06_JPRB,0.71287E-06_JPRB /)  
KB(:,16, 9) = (/ &
 & 0.56582E-06_JPRB,0.57313E-06_JPRB,0.58159E-06_JPRB,0.59012E-06_JPRB,0.59880E-06_JPRB /)  
KB(:,17, 9) = (/ &
 & 0.47164E-06_JPRB,0.47892E-06_JPRB,0.48671E-06_JPRB,0.49436E-06_JPRB,0.50258E-06_JPRB /)  
KB(:,18, 9) = (/ &
 & 0.39308E-06_JPRB,0.39992E-06_JPRB,0.40685E-06_JPRB,0.41415E-06_JPRB,0.42143E-06_JPRB /)  
KB(:,19, 9) = (/ &
 & 0.32764E-06_JPRB,0.33370E-06_JPRB,0.34000E-06_JPRB,0.34660E-06_JPRB,0.35294E-06_JPRB /)  
KB(:,20, 9) = (/ &
 & 0.27304E-06_JPRB,0.27855E-06_JPRB,0.28433E-06_JPRB,0.29002E-06_JPRB,0.29550E-06_JPRB /)  
KB(:,21, 9) = (/ &
 & 0.22762E-06_JPRB,0.23263E-06_JPRB,0.23776E-06_JPRB,0.24264E-06_JPRB,0.24751E-06_JPRB /)  
KB(:,22, 9) = (/ &
 & 0.19016E-06_JPRB,0.19467E-06_JPRB,0.19902E-06_JPRB,0.20331E-06_JPRB,0.20743E-06_JPRB /)  
KB(:,23, 9) = (/ &
 & 0.15902E-06_JPRB,0.16285E-06_JPRB,0.16664E-06_JPRB,0.17032E-06_JPRB,0.17381E-06_JPRB /)  
KB(:,24, 9) = (/ &
 & 0.13300E-06_JPRB,0.13639E-06_JPRB,0.13965E-06_JPRB,0.14271E-06_JPRB,0.14575E-06_JPRB /)  
KB(:,25, 9) = (/ &
 & 0.11136E-06_JPRB,0.11428E-06_JPRB,0.11705E-06_JPRB,0.11966E-06_JPRB,0.12234E-06_JPRB /)  
KB(:,26, 9) = (/ &
 & 0.93355E-07_JPRB,0.95870E-07_JPRB,0.98179E-07_JPRB,0.10046E-06_JPRB,0.10295E-06_JPRB /)  
KB(:,27, 9) = (/ &
 & 0.78546E-07_JPRB,0.80656E-07_JPRB,0.82694E-07_JPRB,0.84793E-07_JPRB,0.87129E-07_JPRB /)  
KB(:,28, 9) = (/ &
 & 0.65991E-07_JPRB,0.67786E-07_JPRB,0.69602E-07_JPRB,0.71624E-07_JPRB,0.74063E-07_JPRB /)  
KB(:,29, 9) = (/ &
 & 0.55459E-07_JPRB,0.56995E-07_JPRB,0.58695E-07_JPRB,0.60741E-07_JPRB,0.63281E-07_JPRB /)  
KB(:,30, 9) = (/ &
 & 0.46750E-07_JPRB,0.48054E-07_JPRB,0.49703E-07_JPRB,0.51793E-07_JPRB,0.54403E-07_JPRB /)  
KB(:,31, 9) = (/ &
 & 0.39452E-07_JPRB,0.40727E-07_JPRB,0.42319E-07_JPRB,0.44486E-07_JPRB,0.47323E-07_JPRB /)  
KB(:,32, 9) = (/ &
 & 0.33473E-07_JPRB,0.34884E-07_JPRB,0.36502E-07_JPRB,0.38781E-07_JPRB,0.41735E-07_JPRB /)  
KB(:,33, 9) = (/ &
 & 0.28581E-07_JPRB,0.30008E-07_JPRB,0.31748E-07_JPRB,0.34217E-07_JPRB,0.37511E-07_JPRB /)  
KB(:,34, 9) = (/ &
 & 0.24450E-07_JPRB,0.25951E-07_JPRB,0.27867E-07_JPRB,0.30565E-07_JPRB,0.34125E-07_JPRB /)  
KB(:,35, 9) = (/ &
 & 0.20942E-07_JPRB,0.22554E-07_JPRB,0.24574E-07_JPRB,0.27409E-07_JPRB,0.31159E-07_JPRB /)  
KB(:,36, 9) = (/ &
 & 0.18081E-07_JPRB,0.19648E-07_JPRB,0.21657E-07_JPRB,0.24573E-07_JPRB,0.28429E-07_JPRB /)  
KB(:,37, 9) = (/ &
 & 0.15436E-07_JPRB,0.16978E-07_JPRB,0.19037E-07_JPRB,0.21710E-07_JPRB,0.25509E-07_JPRB /)  
KB(:,38, 9) = (/ &
 & 0.13187E-07_JPRB,0.14690E-07_JPRB,0.16738E-07_JPRB,0.19257E-07_JPRB,0.22992E-07_JPRB /)  
KB(:,39, 9) = (/ &
 & 0.11282E-07_JPRB,0.12751E-07_JPRB,0.14794E-07_JPRB,0.17292E-07_JPRB,0.20852E-07_JPRB /)  
KB(:,40, 9) = (/ &
 & 0.96293E-08_JPRB,0.10973E-07_JPRB,0.12917E-07_JPRB,0.15272E-07_JPRB,0.18582E-07_JPRB /)  
KB(:,41, 9) = (/ &
 & 0.81770E-08_JPRB,0.94352E-08_JPRB,0.11220E-07_JPRB,0.13516E-07_JPRB,0.16546E-07_JPRB /)  
KB(:,42, 9) = (/ &
 & 0.69323E-08_JPRB,0.80750E-08_JPRB,0.97479E-08_JPRB,0.11964E-07_JPRB,0.14736E-07_JPRB /)  
KB(:,43, 9) = (/ &
 & 0.58312E-08_JPRB,0.68571E-08_JPRB,0.83595E-08_JPRB,0.10414E-07_JPRB,0.12928E-07_JPRB /)  
KB(:,44, 9) = (/ &
 & 0.48754E-08_JPRB,0.58128E-08_JPRB,0.71504E-08_JPRB,0.90270E-08_JPRB,0.11362E-07_JPRB /)  
KB(:,45, 9) = (/ &
 & 0.40522E-08_JPRB,0.48841E-08_JPRB,0.60765E-08_JPRB,0.77697E-08_JPRB,0.99439E-08_JPRB /)  
KB(:,46, 9) = (/ &
 & 0.33429E-08_JPRB,0.40820E-08_JPRB,0.51038E-08_JPRB,0.66237E-08_JPRB,0.86427E-08_JPRB /)  
KB(:,47, 9) = (/ &
 & 0.27297E-08_JPRB,0.33571E-08_JPRB,0.42806E-08_JPRB,0.55863E-08_JPRB,0.73605E-08_JPRB /)  
KB(:,48, 9) = (/ &
 & 0.22143E-08_JPRB,0.27445E-08_JPRB,0.35414E-08_JPRB,0.46711E-08_JPRB,0.62204E-08_JPRB /)  
KB(:,49, 9) = (/ &
 & 0.18030E-08_JPRB,0.22208E-08_JPRB,0.28995E-08_JPRB,0.38639E-08_JPRB,0.52216E-08_JPRB /)  
KB(:,50, 9) = (/ &
 & 0.14670E-08_JPRB,0.18085E-08_JPRB,0.23853E-08_JPRB,0.32522E-08_JPRB,0.44284E-08_JPRB /)  
KB(:,51, 9) = (/ &
 & 0.11873E-08_JPRB,0.14637E-08_JPRB,0.19592E-08_JPRB,0.27073E-08_JPRB,0.37306E-08_JPRB /)  
KB(:,52, 9) = (/ &
 & 0.96876E-09_JPRB,0.11883E-08_JPRB,0.15881E-08_JPRB,0.22316E-08_JPRB,0.31252E-08_JPRB /)  
KB(:,53, 9) = (/ &
 & 0.79526E-09_JPRB,0.95443E-09_JPRB,0.12843E-08_JPRB,0.18180E-08_JPRB,0.25992E-08_JPRB /)  
KB(:,54, 9) = (/ &
 & 0.65045E-09_JPRB,0.77197E-09_JPRB,0.10500E-08_JPRB,0.14963E-08_JPRB,0.21953E-08_JPRB /)  
KB(:,55, 9) = (/ &
 & 0.53001E-09_JPRB,0.62144E-09_JPRB,0.84441E-09_JPRB,0.12265E-08_JPRB,0.18415E-08_JPRB /)  
KB(:,56, 9) = (/ &
 & 0.43274E-09_JPRB,0.50433E-09_JPRB,0.67633E-09_JPRB,0.10051E-08_JPRB,0.15294E-08_JPRB /)  
KB(:,57, 9) = (/ &
 & 0.35151E-09_JPRB,0.40652E-09_JPRB,0.53819E-09_JPRB,0.80840E-09_JPRB,0.12530E-08_JPRB /)  
KB(:,58, 9) = (/ &
 & 0.28511E-09_JPRB,0.33047E-09_JPRB,0.42809E-09_JPRB,0.65584E-09_JPRB,0.10383E-08_JPRB /)  
KB(:,59, 9) = (/ &
 & 0.23557E-09_JPRB,0.27695E-09_JPRB,0.36588E-09_JPRB,0.57468E-09_JPRB,0.92796E-09_JPRB /)  
KB(:,13,10) = (/ &
 & 0.49379E-05_JPRB,0.50469E-05_JPRB,0.51595E-05_JPRB,0.52778E-05_JPRB,0.54099E-05_JPRB /)  
KB(:,14,10) = (/ &
 & 0.42812E-05_JPRB,0.43888E-05_JPRB,0.45022E-05_JPRB,0.46302E-05_JPRB,0.47669E-05_JPRB /)  
KB(:,15,10) = (/ &
 & 0.36929E-05_JPRB,0.37965E-05_JPRB,0.39164E-05_JPRB,0.40454E-05_JPRB,0.41827E-05_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART14',1,ZHOOK_HANDLE)
END SUBROUTINE PART14


SUBROUTINE PART15

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART15',0,ZHOOK_HANDLE)


KB(:,16,10) = (/ &
 & 0.31721E-05_JPRB,0.32791E-05_JPRB,0.33975E-05_JPRB,0.35246E-05_JPRB,0.36634E-05_JPRB /)  
KB(:,17,10) = (/ &
 & 0.27212E-05_JPRB,0.28264E-05_JPRB,0.29414E-05_JPRB,0.30666E-05_JPRB,0.32085E-05_JPRB /)  
KB(:,18,10) = (/ &
 & 0.23339E-05_JPRB,0.24330E-05_JPRB,0.25438E-05_JPRB,0.26711E-05_JPRB,0.28184E-05_JPRB /)  
KB(:,19,10) = (/ &
 & 0.19987E-05_JPRB,0.20932E-05_JPRB,0.22036E-05_JPRB,0.23332E-05_JPRB,0.24834E-05_JPRB /)  
KB(:,20,10) = (/ &
 & 0.17132E-05_JPRB,0.18061E-05_JPRB,0.19176E-05_JPRB,0.20491E-05_JPRB,0.21989E-05_JPRB /)  
KB(:,21,10) = (/ &
 & 0.14710E-05_JPRB,0.15640E-05_JPRB,0.16759E-05_JPRB,0.18061E-05_JPRB,0.19600E-05_JPRB /)  
KB(:,22,10) = (/ &
 & 0.12737E-05_JPRB,0.13668E-05_JPRB,0.14788E-05_JPRB,0.16132E-05_JPRB,0.17763E-05_JPRB /)  
KB(:,23,10) = (/ &
 & 0.11088E-05_JPRB,0.12015E-05_JPRB,0.13166E-05_JPRB,0.14583E-05_JPRB,0.16304E-05_JPRB /)  
KB(:,24,10) = (/ &
 & 0.97145E-06_JPRB,0.10662E-05_JPRB,0.11867E-05_JPRB,0.13370E-05_JPRB,0.15170E-05_JPRB /)  
KB(:,25,10) = (/ &
 & 0.85857E-06_JPRB,0.95791E-06_JPRB,0.10855E-05_JPRB,0.12438E-05_JPRB,0.14327E-05_JPRB /)  
KB(:,26,10) = (/ &
 & 0.76914E-06_JPRB,0.87488E-06_JPRB,0.10107E-05_JPRB,0.11782E-05_JPRB,0.13762E-05_JPRB /)  
KB(:,27,10) = (/ &
 & 0.69709E-06_JPRB,0.81000E-06_JPRB,0.95427E-06_JPRB,0.11311E-05_JPRB,0.13395E-05_JPRB /)  
KB(:,28,10) = (/ &
 & 0.64352E-06_JPRB,0.76453E-06_JPRB,0.91846E-06_JPRB,0.11047E-05_JPRB,0.13225E-05_JPRB /)  
KB(:,29,10) = (/ &
 & 0.60601E-06_JPRB,0.73668E-06_JPRB,0.90033E-06_JPRB,0.10967E-05_JPRB,0.13241E-05_JPRB /)  
KB(:,30,10) = (/ &
 & 0.58144E-06_JPRB,0.72277E-06_JPRB,0.89681E-06_JPRB,0.11031E-05_JPRB,0.13400E-05_JPRB /)  
KB(:,31,10) = (/ &
 & 0.57013E-06_JPRB,0.72161E-06_JPRB,0.90691E-06_JPRB,0.11230E-05_JPRB,0.13684E-05_JPRB /)  
KB(:,32,10) = (/ &
 & 0.57021E-06_JPRB,0.73098E-06_JPRB,0.92629E-06_JPRB,0.11521E-05_JPRB,0.14071E-05_JPRB /)  
KB(:,33,10) = (/ &
 & 0.58025E-06_JPRB,0.75106E-06_JPRB,0.95601E-06_JPRB,0.11909E-05_JPRB,0.14530E-05_JPRB /)  
KB(:,34,10) = (/ &
 & 0.59352E-06_JPRB,0.77298E-06_JPRB,0.98581E-06_JPRB,0.12280E-05_JPRB,0.14964E-05_JPRB /)  
KB(:,35,10) = (/ &
 & 0.59731E-06_JPRB,0.78147E-06_JPRB,0.99919E-06_JPRB,0.12457E-05_JPRB,0.15176E-05_JPRB /)  
KB(:,36,10) = (/ &
 & 0.58516E-06_JPRB,0.77138E-06_JPRB,0.99076E-06_JPRB,0.12378E-05_JPRB,0.15105E-05_JPRB /)  
KB(:,37,10) = (/ &
 & 0.55140E-06_JPRB,0.73346E-06_JPRB,0.94817E-06_JPRB,0.11937E-05_JPRB,0.14631E-05_JPRB /)  
KB(:,38,10) = (/ &
 & 0.51916E-06_JPRB,0.69705E-06_JPRB,0.90723E-06_JPRB,0.11496E-05_JPRB,0.14156E-05_JPRB /)  
KB(:,39,10) = (/ &
 & 0.48960E-06_JPRB,0.66318E-06_JPRB,0.86863E-06_JPRB,0.11068E-05_JPRB,0.13701E-05_JPRB /)  
KB(:,40,10) = (/ &
 & 0.44595E-06_JPRB,0.61209E-06_JPRB,0.81011E-06_JPRB,0.10412E-05_JPRB,0.12987E-05_JPRB /)  
KB(:,41,10) = (/ &
 & 0.40399E-06_JPRB,0.56185E-06_JPRB,0.75199E-06_JPRB,0.97449E-06_JPRB,0.12265E-05_JPRB /)  
KB(:,42,10) = (/ &
 & 0.36503E-06_JPRB,0.51494E-06_JPRB,0.69685E-06_JPRB,0.91108E-06_JPRB,0.11565E-05_JPRB /)  
KB(:,43,10) = (/ &
 & 0.32174E-06_JPRB,0.46170E-06_JPRB,0.63377E-06_JPRB,0.83820E-06_JPRB,0.10749E-05_JPRB /)  
KB(:,44,10) = (/ &
 & 0.27930E-06_JPRB,0.40829E-06_JPRB,0.56968E-06_JPRB,0.76331E-06_JPRB,0.98961E-06_JPRB /)  
KB(:,45,10) = (/ &
 & 0.24096E-06_JPRB,0.35938E-06_JPRB,0.50997E-06_JPRB,0.69291E-06_JPRB,0.90837E-06_JPRB /)  
KB(:,46,10) = (/ &
 & 0.20431E-06_JPRB,0.31166E-06_JPRB,0.45096E-06_JPRB,0.62224E-06_JPRB,0.82595E-06_JPRB /)  
KB(:,47,10) = (/ &
 & 0.16816E-06_JPRB,0.26359E-06_JPRB,0.38972E-06_JPRB,0.54827E-06_JPRB,0.73938E-06_JPRB /)  
KB(:,48,10) = (/ &
 & 0.13670E-06_JPRB,0.22070E-06_JPRB,0.33435E-06_JPRB,0.47996E-06_JPRB,0.65830E-06_JPRB /)  
KB(:,49,10) = (/ &
 & 0.10953E-06_JPRB,0.18282E-06_JPRB,0.28430E-06_JPRB,0.41725E-06_JPRB,0.58243E-06_JPRB /)  
KB(:,50,10) = (/ &
 & 0.88267E-07_JPRB,0.15143E-06_JPRB,0.24199E-06_JPRB,0.36271E-06_JPRB,0.51595E-06_JPRB /)  
KB(:,51,10) = (/ &
 & 0.70298E-07_JPRB,0.12484E-06_JPRB,0.20511E-06_JPRB,0.31462E-06_JPRB,0.45605E-06_JPRB /)  
KB(:,52,10) = (/ &
 & 0.55131E-07_JPRB,0.10217E-06_JPRB,0.17234E-06_JPRB,0.27088E-06_JPRB,0.40072E-06_JPRB /)  
KB(:,53,10) = (/ &
 & 0.43153E-07_JPRB,0.82195E-07_JPRB,0.14318E-06_JPRB,0.23139E-06_JPRB,0.34955E-06_JPRB /)  
KB(:,54,10) = (/ &
 & 0.33903E-07_JPRB,0.66466E-07_JPRB,0.12020E-06_JPRB,0.19856E-06_JPRB,0.30630E-06_JPRB /)  
KB(:,55,10) = (/ &
 & 0.26416E-07_JPRB,0.53605E-07_JPRB,0.10034E-06_JPRB,0.17017E-06_JPRB,0.26833E-06_JPRB /)  
KB(:,56,10) = (/ &
 & 0.20206E-07_JPRB,0.42611E-07_JPRB,0.82928E-07_JPRB,0.14532E-06_JPRB,0.23365E-06_JPRB /)  
KB(:,57,10) = (/ &
 & 0.15310E-07_JPRB,0.33413E-07_JPRB,0.67820E-07_JPRB,0.12262E-06_JPRB,0.20213E-06_JPRB /)  
KB(:,58,10) = (/ &
 & 0.11722E-07_JPRB,0.26420E-07_JPRB,0.55414E-07_JPRB,0.10347E-06_JPRB,0.17567E-06_JPRB /)  
KB(:,59,10) = (/ &
 & 0.10312E-07_JPRB,0.23851E-07_JPRB,0.50918E-07_JPRB,0.96421E-07_JPRB,0.16547E-06_JPRB /)  
KB(:,13,11) = (/ &
 & 0.10213E-04_JPRB,0.10492E-04_JPRB,0.10768E-04_JPRB,0.11052E-04_JPRB,0.11341E-04_JPRB /)  
KB(:,14,11) = (/ &
 & 0.92065E-05_JPRB,0.95170E-05_JPRB,0.98374E-05_JPRB,0.10166E-04_JPRB,0.10515E-04_JPRB /)  
KB(:,15,11) = (/ &
 & 0.82447E-05_JPRB,0.85845E-05_JPRB,0.89388E-05_JPRB,0.93243E-05_JPRB,0.97313E-05_JPRB /)  
KB(:,16,11) = (/ &
 & 0.73562E-05_JPRB,0.77204E-05_JPRB,0.81177E-05_JPRB,0.85472E-05_JPRB,0.89941E-05_JPRB /)  
KB(:,17,11) = (/ &
 & 0.65534E-05_JPRB,0.69440E-05_JPRB,0.73753E-05_JPRB,0.78408E-05_JPRB,0.83202E-05_JPRB /)  
KB(:,18,11) = (/ &
 & 0.58421E-05_JPRB,0.62603E-05_JPRB,0.67231E-05_JPRB,0.72105E-05_JPRB,0.77276E-05_JPRB /)  
KB(:,19,11) = (/ &
 & 0.52249E-05_JPRB,0.56681E-05_JPRB,0.61484E-05_JPRB,0.66668E-05_JPRB,0.72285E-05_JPRB /)  
KB(:,20,11) = (/ &
 & 0.47032E-05_JPRB,0.51617E-05_JPRB,0.56660E-05_JPRB,0.62226E-05_JPRB,0.68302E-05_JPRB /)  
KB(:,21,11) = (/ &
 & 0.42601E-05_JPRB,0.47338E-05_JPRB,0.52698E-05_JPRB,0.58670E-05_JPRB,0.65065E-05_JPRB /)  
KB(:,22,11) = (/ &
 & 0.39167E-05_JPRB,0.44205E-05_JPRB,0.49953E-05_JPRB,0.56267E-05_JPRB,0.62956E-05_JPRB /)  
KB(:,23,11) = (/ &
 & 0.36499E-05_JPRB,0.41883E-05_JPRB,0.47965E-05_JPRB,0.54568E-05_JPRB,0.61529E-05_JPRB /)  
KB(:,24,11) = (/ &
 & 0.34565E-05_JPRB,0.40283E-05_JPRB,0.46653E-05_JPRB,0.53526E-05_JPRB,0.60723E-05_JPRB /)  
KB(:,25,11) = (/ &
 & 0.33292E-05_JPRB,0.39315E-05_JPRB,0.45958E-05_JPRB,0.53082E-05_JPRB,0.60473E-05_JPRB /)  
KB(:,26,11) = (/ &
 & 0.32653E-05_JPRB,0.38970E-05_JPRB,0.45879E-05_JPRB,0.53204E-05_JPRB,0.60776E-05_JPRB /)  
KB(:,27,11) = (/ &
 & 0.32497E-05_JPRB,0.39083E-05_JPRB,0.46221E-05_JPRB,0.53722E-05_JPRB,0.61437E-05_JPRB /)  
KB(:,28,11) = (/ &
 & 0.32741E-05_JPRB,0.39580E-05_JPRB,0.46902E-05_JPRB,0.54541E-05_JPRB,0.62354E-05_JPRB /)  
KB(:,29,11) = (/ &
 & 0.33369E-05_JPRB,0.40429E-05_JPRB,0.47902E-05_JPRB,0.55664E-05_JPRB,0.63553E-05_JPRB /)  
KB(:,30,11) = (/ &
 & 0.34283E-05_JPRB,0.41504E-05_JPRB,0.49124E-05_JPRB,0.56972E-05_JPRB,0.64922E-05_JPRB /)  
KB(:,31,11) = (/ &
 & 0.35444E-05_JPRB,0.42823E-05_JPRB,0.50547E-05_JPRB,0.58477E-05_JPRB,0.66477E-05_JPRB /)  
KB(:,32,11) = (/ &
 & 0.36801E-05_JPRB,0.44317E-05_JPRB,0.52138E-05_JPRB,0.60136E-05_JPRB,0.68176E-05_JPRB /)  
KB(:,33,11) = (/ &
 & 0.38318E-05_JPRB,0.45951E-05_JPRB,0.53855E-05_JPRB,0.61901E-05_JPRB,0.69963E-05_JPRB /)  
KB(:,34,11) = (/ &
 & 0.39692E-05_JPRB,0.47416E-05_JPRB,0.55387E-05_JPRB,0.63463E-05_JPRB,0.71529E-05_JPRB /)  
KB(:,35,11) = (/ &
 & 0.40413E-05_JPRB,0.48197E-05_JPRB,0.56200E-05_JPRB,0.64302E-05_JPRB,0.72378E-05_JPRB /)  
KB(:,36,11) = (/ &
 & 0.40356E-05_JPRB,0.48162E-05_JPRB,0.56178E-05_JPRB,0.64290E-05_JPRB,0.72385E-05_JPRB /)  
KB(:,37,11) = (/ &
 & 0.39181E-05_JPRB,0.46953E-05_JPRB,0.54967E-05_JPRB,0.63083E-05_JPRB,0.71198E-05_JPRB /)  
KB(:,38,11) = (/ &
 & 0.37977E-05_JPRB,0.45715E-05_JPRB,0.53704E-05_JPRB,0.61820E-05_JPRB,0.69964E-05_JPRB /)  
KB(:,39,11) = (/ &
 & 0.36811E-05_JPRB,0.44507E-05_JPRB,0.52481E-05_JPRB,0.60593E-05_JPRB,0.68739E-05_JPRB /)  
KB(:,40,11) = (/ &
 & 0.34909E-05_JPRB,0.42522E-05_JPRB,0.50444E-05_JPRB,0.58543E-05_JPRB,0.66697E-05_JPRB /)  
KB(:,41,11) = (/ &
 & 0.32953E-05_JPRB,0.40465E-05_JPRB,0.48326E-05_JPRB,0.56401E-05_JPRB,0.64551E-05_JPRB /)  
KB(:,42,11) = (/ &
 & 0.31040E-05_JPRB,0.38444E-05_JPRB,0.46230E-05_JPRB,0.54267E-05_JPRB,0.62419E-05_JPRB /)  
KB(:,43,11) = (/ &
 & 0.28773E-05_JPRB,0.36028E-05_JPRB,0.43716E-05_JPRB,0.51693E-05_JPRB,0.59825E-05_JPRB /)  
KB(:,44,11) = (/ &
 & 0.26404E-05_JPRB,0.33480E-05_JPRB,0.41036E-05_JPRB,0.48939E-05_JPRB,0.57034E-05_JPRB /)  
KB(:,45,11) = (/ &
 & 0.24120E-05_JPRB,0.30991E-05_JPRB,0.38405E-05_JPRB,0.46208E-05_JPRB,0.54260E-05_JPRB /)  
KB(:,46,11) = (/ &
 & 0.21786E-05_JPRB,0.28418E-05_JPRB,0.35659E-05_JPRB,0.43343E-05_JPRB,0.51318E-05_JPRB /)  
KB(:,47,11) = (/ &
 & 0.19311E-05_JPRB,0.25641E-05_JPRB,0.32660E-05_JPRB,0.40180E-05_JPRB,0.48060E-05_JPRB /)  
KB(:,48,11) = (/ &
 & 0.16967E-05_JPRB,0.22980E-05_JPRB,0.29746E-05_JPRB,0.37093E-05_JPRB,0.44842E-05_JPRB /)  
KB(:,49,11) = (/ &
 & 0.14774E-05_JPRB,0.20448E-05_JPRB,0.26926E-05_JPRB,0.34064E-05_JPRB,0.41668E-05_JPRB /)  
KB(:,50,11) = (/ &
 & 0.12873E-05_JPRB,0.18193E-05_JPRB,0.24384E-05_JPRB,0.31296E-05_JPRB,0.38742E-05_JPRB /)  
KB(:,51,11) = (/ &
 & 0.11146E-05_JPRB,0.16126E-05_JPRB,0.22020E-05_JPRB,0.28686E-05_JPRB,0.35959E-05_JPRB /)  
KB(:,52,11) = (/ &
 & 0.95604E-06_JPRB,0.14200E-05_JPRB,0.19761E-05_JPRB,0.26163E-05_JPRB,0.33236E-05_JPRB /)  
KB(:,53,11) = (/ &
 & 0.80966E-06_JPRB,0.12381E-05_JPRB,0.17610E-05_JPRB,0.23732E-05_JPRB,0.30580E-05_JPRB /)  
KB(:,54,11) = (/ &
 & 0.68766E-06_JPRB,0.10830E-05_JPRB,0.15763E-05_JPRB,0.21583E-05_JPRB,0.28207E-05_JPRB /)  
KB(:,55,11) = (/ &
 & 0.58212E-06_JPRB,0.94518E-06_JPRB,0.14071E-05_JPRB,0.19616E-05_JPRB,0.26001E-05_JPRB /)  
KB(:,56,11) = (/ &
 & 0.48769E-06_JPRB,0.81784E-06_JPRB,0.12480E-05_JPRB,0.17754E-05_JPRB,0.23872E-05_JPRB /)  
KB(:,57,11) = (/ &
 & 0.40334E-06_JPRB,0.70099E-06_JPRB,0.10993E-05_JPRB,0.15960E-05_JPRB,0.21818E-05_JPRB /)  
KB(:,58,11) = (/ &
 & 0.33254E-06_JPRB,0.59979E-06_JPRB,0.96749E-06_JPRB,0.14348E-05_JPRB,0.19961E-05_JPRB /)  
KB(:,59,11) = (/ &
 & 0.30667E-06_JPRB,0.56182E-06_JPRB,0.91722E-06_JPRB,0.13728E-05_JPRB,0.19233E-05_JPRB /)  
KB(:,13,12) = (/ &
 & 0.21780E-04_JPRB,0.22297E-04_JPRB,0.22851E-04_JPRB,0.23387E-04_JPRB,0.23897E-04_JPRB /)  
KB(:,14,12) = (/ &
 & 0.20875E-04_JPRB,0.21531E-04_JPRB,0.22189E-04_JPRB,0.22823E-04_JPRB,0.23424E-04_JPRB /)  
KB(:,15,12) = (/ &
 & 0.19941E-04_JPRB,0.20728E-04_JPRB,0.21492E-04_JPRB,0.22225E-04_JPRB,0.22948E-04_JPRB /)  
KB(:,16,12) = (/ &
 & 0.19013E-04_JPRB,0.19918E-04_JPRB,0.20796E-04_JPRB,0.21654E-04_JPRB,0.22503E-04_JPRB /)  
KB(:,17,12) = (/ &
 & 0.18129E-04_JPRB,0.19150E-04_JPRB,0.20149E-04_JPRB,0.21144E-04_JPRB,0.22094E-04_JPRB /)  
KB(:,18,12) = (/ &
 & 0.17308E-04_JPRB,0.18451E-04_JPRB,0.19578E-04_JPRB,0.20689E-04_JPRB,0.21728E-04_JPRB /)  
KB(:,19,12) = (/ &
 & 0.16581E-04_JPRB,0.17835E-04_JPRB,0.19087E-04_JPRB,0.20285E-04_JPRB,0.21402E-04_JPRB /)  
KB(:,20,12) = (/ &
 & 0.15978E-04_JPRB,0.17349E-04_JPRB,0.18704E-04_JPRB,0.19972E-04_JPRB,0.21143E-04_JPRB /)  
KB(:,21,12) = (/ &
 & 0.15496E-04_JPRB,0.16976E-04_JPRB,0.18403E-04_JPRB,0.19724E-04_JPRB,0.20952E-04_JPRB /)  
KB(:,22,12) = (/ &
 & 0.15240E-04_JPRB,0.16798E-04_JPRB,0.18272E-04_JPRB,0.19635E-04_JPRB,0.20901E-04_JPRB /)  
KB(:,23,12) = (/ &
 & 0.15105E-04_JPRB,0.16716E-04_JPRB,0.18220E-04_JPRB,0.19617E-04_JPRB,0.20916E-04_JPRB /)  
KB(:,24,12) = (/ &
 & 0.15076E-04_JPRB,0.16719E-04_JPRB,0.18249E-04_JPRB,0.19672E-04_JPRB,0.20991E-04_JPRB /)  
KB(:,25,12) = (/ &
 & 0.15141E-04_JPRB,0.16802E-04_JPRB,0.18352E-04_JPRB,0.19786E-04_JPRB,0.21116E-04_JPRB /)  
KB(:,26,12) = (/ &
 & 0.15306E-04_JPRB,0.16974E-04_JPRB,0.18529E-04_JPRB,0.19965E-04_JPRB,0.21296E-04_JPRB /)  
KB(:,27,12) = (/ &
 & 0.15522E-04_JPRB,0.17192E-04_JPRB,0.18747E-04_JPRB,0.20182E-04_JPRB,0.21501E-04_JPRB /)  
KB(:,28,12) = (/ &
 & 0.15784E-04_JPRB,0.17449E-04_JPRB,0.18996E-04_JPRB,0.20419E-04_JPRB,0.21733E-04_JPRB /)  
KB(:,29,12) = (/ &
 & 0.16090E-04_JPRB,0.17744E-04_JPRB,0.19276E-04_JPRB,0.20687E-04_JPRB,0.21987E-04_JPRB /)  
KB(:,30,12) = (/ &
 & 0.16419E-04_JPRB,0.18062E-04_JPRB,0.19575E-04_JPRB,0.20970E-04_JPRB,0.22248E-04_JPRB /)  
KB(:,31,12) = (/ &
 & 0.16777E-04_JPRB,0.18399E-04_JPRB,0.19892E-04_JPRB,0.21268E-04_JPRB,0.22521E-04_JPRB /)  
KB(:,32,12) = (/ &
 & 0.17152E-04_JPRB,0.18750E-04_JPRB,0.20222E-04_JPRB,0.21573E-04_JPRB,0.22802E-04_JPRB /)  
KB(:,33,12) = (/ &
 & 0.17537E-04_JPRB,0.19109E-04_JPRB,0.20556E-04_JPRB,0.21883E-04_JPRB,0.23082E-04_JPRB /)  
KB(:,34,12) = (/ &
 & 0.17871E-04_JPRB,0.19418E-04_JPRB,0.20844E-04_JPRB,0.22147E-04_JPRB,0.23322E-04_JPRB /)  
KB(:,35,12) = (/ &
 & 0.18052E-04_JPRB,0.19587E-04_JPRB,0.21002E-04_JPRB,0.22291E-04_JPRB,0.23455E-04_JPRB /)  
KB(:,36,12) = (/ &
 & 0.18063E-04_JPRB,0.19601E-04_JPRB,0.21016E-04_JPRB,0.22306E-04_JPRB,0.23468E-04_JPRB /)  
KB(:,37,12) = (/ &
 & 0.17833E-04_JPRB,0.19389E-04_JPRB,0.20824E-04_JPRB,0.22132E-04_JPRB,0.23314E-04_JPRB /)  
KB(:,38,12) = (/ &
 & 0.17587E-04_JPRB,0.19167E-04_JPRB,0.20623E-04_JPRB,0.21950E-04_JPRB,0.23152E-04_JPRB /)  
KB(:,39,12) = (/ &
 & 0.17343E-04_JPRB,0.18945E-04_JPRB,0.20418E-04_JPRB,0.21765E-04_JPRB,0.22984E-04_JPRB /)  
KB(:,40,12) = (/ &
 & 0.16926E-04_JPRB,0.18563E-04_JPRB,0.20065E-04_JPRB,0.21446E-04_JPRB,0.22697E-04_JPRB /)  
KB(:,41,12) = (/ &
 & 0.16478E-04_JPRB,0.18152E-04_JPRB,0.19687E-04_JPRB,0.21101E-04_JPRB,0.22388E-04_JPRB /)  
KB(:,42,12) = (/ &
 & 0.16023E-04_JPRB,0.17729E-04_JPRB,0.19301E-04_JPRB,0.20748E-04_JPRB,0.22068E-04_JPRB /)  
KB(:,43,12) = (/ &
 & 0.15458E-04_JPRB,0.17203E-04_JPRB,0.18821E-04_JPRB,0.20305E-04_JPRB,0.21667E-04_JPRB /)  
KB(:,44,12) = (/ &
 & 0.14831E-04_JPRB,0.16623E-04_JPRB,0.18287E-04_JPRB,0.19814E-04_JPRB,0.21219E-04_JPRB /)  
KB(:,45,12) = (/ &
 & 0.14192E-04_JPRB,0.16029E-04_JPRB,0.17735E-04_JPRB,0.19308E-04_JPRB,0.20757E-04_JPRB /)  
KB(:,46,12) = (/ &
 & 0.13493E-04_JPRB,0.15380E-04_JPRB,0.17134E-04_JPRB,0.18756E-04_JPRB,0.20247E-04_JPRB /)  
KB(:,47,12) = (/ &
 & 0.12693E-04_JPRB,0.14634E-04_JPRB,0.16440E-04_JPRB,0.18118E-04_JPRB,0.19661E-04_JPRB /)  
KB(:,48,12) = (/ &
 & 0.11878E-04_JPRB,0.13868E-04_JPRB,0.15729E-04_JPRB,0.17458E-04_JPRB,0.19054E-04_JPRB /)  
KB(:,49,12) = (/ &
 & 0.11052E-04_JPRB,0.13077E-04_JPRB,0.14993E-04_JPRB,0.16776E-04_JPRB,0.18429E-04_JPRB /)  
KB(:,50,12) = (/ &
 & 0.10274E-04_JPRB,0.12322E-04_JPRB,0.14286E-04_JPRB,0.16119E-04_JPRB,0.17820E-04_JPRB /)  
KB(:,51,12) = (/ &
 & 0.95165E-05_JPRB,0.11577E-04_JPRB,0.13581E-04_JPRB,0.15463E-04_JPRB,0.17211E-04_JPRB /)  
KB(:,52,12) = (/ &
 & 0.87654E-05_JPRB,0.10825E-04_JPRB,0.12859E-04_JPRB,0.14791E-04_JPRB,0.16589E-04_JPRB /)  
KB(:,53,12) = (/ &
 & 0.80213E-05_JPRB,0.10071E-04_JPRB,0.12124E-04_JPRB,0.14102E-04_JPRB,0.15949E-04_JPRB /)  
KB(:,54,12) = (/ &
 & 0.73473E-05_JPRB,0.93776E-05_JPRB,0.11439E-04_JPRB,0.13452E-04_JPRB,0.15344E-04_JPRB /)  
KB(:,55,12) = (/ &
 & 0.67127E-05_JPRB,0.87188E-05_JPRB,0.10780E-04_JPRB,0.12816E-04_JPRB,0.14751E-04_JPRB /)  
KB(:,56,12) = (/ &
 & 0.60935E-05_JPRB,0.80668E-05_JPRB,0.10118E-04_JPRB,0.12169E-04_JPRB,0.14148E-04_JPRB /)  
KB(:,57,12) = (/ &
 & 0.54908E-05_JPRB,0.74223E-05_JPRB,0.94571E-05_JPRB,0.11517E-04_JPRB,0.13528E-04_JPRB /)  
KB(:,58,12) = (/ &
 & 0.49372E-05_JPRB,0.68201E-05_JPRB,0.88324E-05_JPRB,0.10894E-04_JPRB,0.12926E-04_JPRB /)  
KB(:,59,12) = (/ &
 & 0.47213E-05_JPRB,0.65842E-05_JPRB,0.85835E-05_JPRB,0.10644E-04_JPRB,0.12683E-04_JPRB /)  
KB(:,13,13) = (/ &
 & 0.46820E-04_JPRB,0.47158E-04_JPRB,0.47420E-04_JPRB,0.47688E-04_JPRB,0.47860E-04_JPRB /)  
KB(:,14,13) = (/ &
 & 0.47343E-04_JPRB,0.47824E-04_JPRB,0.48275E-04_JPRB,0.48677E-04_JPRB,0.48937E-04_JPRB /)  
KB(:,15,13) = (/ &
 & 0.47643E-04_JPRB,0.48345E-04_JPRB,0.48980E-04_JPRB,0.49469E-04_JPRB,0.49813E-04_JPRB /)  
KB(:,16,13) = (/ &
 & 0.47844E-04_JPRB,0.48762E-04_JPRB,0.49536E-04_JPRB,0.50120E-04_JPRB,0.50548E-04_JPRB /)  
KB(:,17,13) = (/ &
 & 0.47956E-04_JPRB,0.49079E-04_JPRB,0.49982E-04_JPRB,0.50640E-04_JPRB,0.51155E-04_JPRB /)  
KB(:,18,13) = (/ &
 & 0.48046E-04_JPRB,0.49334E-04_JPRB,0.50343E-04_JPRB,0.51068E-04_JPRB,0.51673E-04_JPRB /)  
KB(:,19,13) = (/ &
 & 0.48132E-04_JPRB,0.49550E-04_JPRB,0.50630E-04_JPRB,0.51453E-04_JPRB,0.52124E-04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART15',1,ZHOOK_HANDLE)
END SUBROUTINE PART15


SUBROUTINE PART16

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART16',0,ZHOOK_HANDLE)


KB(:,20,13) = (/ &
 & 0.48262E-04_JPRB,0.49765E-04_JPRB,0.50907E-04_JPRB,0.51808E-04_JPRB,0.52533E-04_JPRB /)  
KB(:,21,13) = (/ &
 & 0.48402E-04_JPRB,0.49959E-04_JPRB,0.51170E-04_JPRB,0.52136E-04_JPRB,0.52894E-04_JPRB /)  
KB(:,22,13) = (/ &
 & 0.48671E-04_JPRB,0.50243E-04_JPRB,0.51485E-04_JPRB,0.52481E-04_JPRB,0.53256E-04_JPRB /)  
KB(:,23,13) = (/ &
 & 0.48954E-04_JPRB,0.50544E-04_JPRB,0.51806E-04_JPRB,0.52811E-04_JPRB,0.53587E-04_JPRB /)  
KB(:,24,13) = (/ &
 & 0.49272E-04_JPRB,0.50858E-04_JPRB,0.52128E-04_JPRB,0.53125E-04_JPRB,0.53892E-04_JPRB /)  
KB(:,25,13) = (/ &
 & 0.49616E-04_JPRB,0.51186E-04_JPRB,0.52450E-04_JPRB,0.53425E-04_JPRB,0.54174E-04_JPRB /)  
KB(:,26,13) = (/ &
 & 0.50001E-04_JPRB,0.51551E-04_JPRB,0.52773E-04_JPRB,0.53723E-04_JPRB,0.54445E-04_JPRB /)  
KB(:,27,13) = (/ &
 & 0.50406E-04_JPRB,0.51904E-04_JPRB,0.53086E-04_JPRB,0.54001E-04_JPRB,0.54687E-04_JPRB /)  
KB(:,28,13) = (/ &
 & 0.50802E-04_JPRB,0.52248E-04_JPRB,0.53391E-04_JPRB,0.54260E-04_JPRB,0.54906E-04_JPRB /)  
KB(:,29,13) = (/ &
 & 0.51204E-04_JPRB,0.52593E-04_JPRB,0.53683E-04_JPRB,0.54507E-04_JPRB,0.55109E-04_JPRB /)  
KB(:,30,13) = (/ &
 & 0.51608E-04_JPRB,0.52928E-04_JPRB,0.53956E-04_JPRB,0.54730E-04_JPRB,0.55285E-04_JPRB /)  
KB(:,31,13) = (/ &
 & 0.51993E-04_JPRB,0.53249E-04_JPRB,0.54213E-04_JPRB,0.54939E-04_JPRB,0.55442E-04_JPRB /)  
KB(:,32,13) = (/ &
 & 0.52364E-04_JPRB,0.53549E-04_JPRB,0.54461E-04_JPRB,0.55127E-04_JPRB,0.55583E-04_JPRB /)  
KB(:,33,13) = (/ &
 & 0.52722E-04_JPRB,0.53841E-04_JPRB,0.54688E-04_JPRB,0.55301E-04_JPRB,0.55705E-04_JPRB /)  
KB(:,34,13) = (/ &
 & 0.53018E-04_JPRB,0.54074E-04_JPRB,0.54867E-04_JPRB,0.55434E-04_JPRB,0.55799E-04_JPRB /)  
KB(:,35,13) = (/ &
 & 0.53187E-04_JPRB,0.54211E-04_JPRB,0.54980E-04_JPRB,0.55515E-04_JPRB,0.55855E-04_JPRB /)  
KB(:,36,13) = (/ &
 & 0.53222E-04_JPRB,0.54242E-04_JPRB,0.55009E-04_JPRB,0.55544E-04_JPRB,0.55878E-04_JPRB /)  
KB(:,37,13) = (/ &
 & 0.53077E-04_JPRB,0.54137E-04_JPRB,0.54934E-04_JPRB,0.55495E-04_JPRB,0.55862E-04_JPRB /)  
KB(:,38,13) = (/ &
 & 0.52907E-04_JPRB,0.54013E-04_JPRB,0.54850E-04_JPRB,0.55445E-04_JPRB,0.55837E-04_JPRB /)  
KB(:,39,13) = (/ &
 & 0.52736E-04_JPRB,0.53884E-04_JPRB,0.54754E-04_JPRB,0.55383E-04_JPRB,0.55805E-04_JPRB /)  
KB(:,40,13) = (/ &
 & 0.52415E-04_JPRB,0.53638E-04_JPRB,0.54576E-04_JPRB,0.55258E-04_JPRB,0.55727E-04_JPRB /)  
KB(:,41,13) = (/ &
 & 0.52053E-04_JPRB,0.53364E-04_JPRB,0.54368E-04_JPRB,0.55117E-04_JPRB,0.55636E-04_JPRB /)  
KB(:,42,13) = (/ &
 & 0.51661E-04_JPRB,0.53061E-04_JPRB,0.54142E-04_JPRB,0.54952E-04_JPRB,0.55527E-04_JPRB /)  
KB(:,43,13) = (/ &
 & 0.51150E-04_JPRB,0.52667E-04_JPRB,0.53836E-04_JPRB,0.54732E-04_JPRB,0.55377E-04_JPRB /)  
KB(:,44,13) = (/ &
 & 0.50559E-04_JPRB,0.52194E-04_JPRB,0.53480E-04_JPRB,0.54465E-04_JPRB,0.55186E-04_JPRB /)  
KB(:,45,13) = (/ &
 & 0.49921E-04_JPRB,0.51684E-04_JPRB,0.53086E-04_JPRB,0.54162E-04_JPRB,0.54971E-04_JPRB /)  
KB(:,46,13) = (/ &
 & 0.49197E-04_JPRB,0.51093E-04_JPRB,0.52628E-04_JPRB,0.53809E-04_JPRB,0.54714E-04_JPRB /)  
KB(:,47,13) = (/ &
 & 0.48328E-04_JPRB,0.50372E-04_JPRB,0.52058E-04_JPRB,0.53374E-04_JPRB,0.54380E-04_JPRB /)  
KB(:,48,13) = (/ &
 & 0.47381E-04_JPRB,0.49603E-04_JPRB,0.51420E-04_JPRB,0.52887E-04_JPRB,0.54013E-04_JPRB /)  
KB(:,49,13) = (/ &
 & 0.46342E-04_JPRB,0.48755E-04_JPRB,0.50735E-04_JPRB,0.52347E-04_JPRB,0.53594E-04_JPRB /)  
KB(:,50,13) = (/ &
 & 0.45266E-04_JPRB,0.47911E-04_JPRB,0.50033E-04_JPRB,0.51782E-04_JPRB,0.53163E-04_JPRB /)  
KB(:,51,13) = (/ &
 & 0.44139E-04_JPRB,0.47021E-04_JPRB,0.49310E-04_JPRB,0.51184E-04_JPRB,0.52699E-04_JPRB /)  
KB(:,52,13) = (/ &
 & 0.42930E-04_JPRB,0.46044E-04_JPRB,0.48523E-04_JPRB,0.50540E-04_JPRB,0.52191E-04_JPRB /)  
KB(:,53,13) = (/ &
 & 0.41632E-04_JPRB,0.44983E-04_JPRB,0.47688E-04_JPRB,0.49847E-04_JPRB,0.51629E-04_JPRB /)  
KB(:,54,13) = (/ &
 & 0.40359E-04_JPRB,0.43928E-04_JPRB,0.46843E-04_JPRB,0.49172E-04_JPRB,0.51075E-04_JPRB /)  
KB(:,55,13) = (/ &
 & 0.39074E-04_JPRB,0.42858E-04_JPRB,0.45984E-04_JPRB,0.48480E-04_JPRB,0.50508E-04_JPRB /)  
KB(:,56,13) = (/ &
 & 0.37728E-04_JPRB,0.41722E-04_JPRB,0.45056E-04_JPRB,0.47740E-04_JPRB,0.49900E-04_JPRB /)  
KB(:,57,13) = (/ &
 & 0.36320E-04_JPRB,0.40515E-04_JPRB,0.44055E-04_JPRB,0.46942E-04_JPRB,0.49258E-04_JPRB /)  
KB(:,58,13) = (/ &
 & 0.34927E-04_JPRB,0.39308E-04_JPRB,0.43052E-04_JPRB,0.46141E-04_JPRB,0.48596E-04_JPRB /)  
KB(:,59,13) = (/ &
 & 0.34349E-04_JPRB,0.38808E-04_JPRB,0.42631E-04_JPRB,0.45802E-04_JPRB,0.48325E-04_JPRB /)  
KB(:,13,14) = (/ &
 & 0.91739E-04_JPRB,0.90588E-04_JPRB,0.89270E-04_JPRB,0.87862E-04_JPRB,0.86541E-04_JPRB /)  
KB(:,14,14) = (/ &
 & 0.97111E-04_JPRB,0.95879E-04_JPRB,0.94382E-04_JPRB,0.92799E-04_JPRB,0.91344E-04_JPRB /)  
KB(:,15,14) = (/ &
 & 0.10201E-03_JPRB,0.10059E-03_JPRB,0.98963E-04_JPRB,0.97297E-04_JPRB,0.95661E-04_JPRB /)  
KB(:,16,14) = (/ &
 & 0.10632E-03_JPRB,0.10477E-03_JPRB,0.10303E-03_JPRB,0.10127E-03_JPRB,0.99489E-04_JPRB /)  
KB(:,17,14) = (/ &
 & 0.11011E-03_JPRB,0.10842E-03_JPRB,0.10659E-03_JPRB,0.10474E-03_JPRB,0.10285E-03_JPRB /)  
KB(:,18,14) = (/ &
 & 0.11338E-03_JPRB,0.11158E-03_JPRB,0.10968E-03_JPRB,0.10773E-03_JPRB,0.10569E-03_JPRB /)  
KB(:,19,14) = (/ &
 & 0.11615E-03_JPRB,0.11428E-03_JPRB,0.11231E-03_JPRB,0.11026E-03_JPRB,0.10810E-03_JPRB /)  
KB(:,20,14) = (/ &
 & 0.11847E-03_JPRB,0.11653E-03_JPRB,0.11450E-03_JPRB,0.11235E-03_JPRB,0.11005E-03_JPRB /)  
KB(:,21,14) = (/ &
 & 0.12039E-03_JPRB,0.11839E-03_JPRB,0.11628E-03_JPRB,0.11404E-03_JPRB,0.11166E-03_JPRB /)  
KB(:,22,14) = (/ &
 & 0.12185E-03_JPRB,0.11978E-03_JPRB,0.11759E-03_JPRB,0.11525E-03_JPRB,0.11275E-03_JPRB /)  
KB(:,23,14) = (/ &
 & 0.12298E-03_JPRB,0.12085E-03_JPRB,0.11858E-03_JPRB,0.11615E-03_JPRB,0.11356E-03_JPRB /)  
KB(:,24,14) = (/ &
 & 0.12384E-03_JPRB,0.12163E-03_JPRB,0.11927E-03_JPRB,0.11676E-03_JPRB,0.11410E-03_JPRB /)  
KB(:,25,14) = (/ &
 & 0.12445E-03_JPRB,0.12216E-03_JPRB,0.11972E-03_JPRB,0.11712E-03_JPRB,0.11440E-03_JPRB /)  
KB(:,26,14) = (/ &
 & 0.12480E-03_JPRB,0.12244E-03_JPRB,0.11993E-03_JPRB,0.11725E-03_JPRB,0.11449E-03_JPRB /)  
KB(:,27,14) = (/ &
 & 0.12497E-03_JPRB,0.12254E-03_JPRB,0.11997E-03_JPRB,0.11723E-03_JPRB,0.11442E-03_JPRB /)  
KB(:,28,14) = (/ &
 & 0.12498E-03_JPRB,0.12249E-03_JPRB,0.11986E-03_JPRB,0.11707E-03_JPRB,0.11425E-03_JPRB /)  
KB(:,29,14) = (/ &
 & 0.12486E-03_JPRB,0.12231E-03_JPRB,0.11961E-03_JPRB,0.11677E-03_JPRB,0.11393E-03_JPRB /)  
KB(:,30,14) = (/ &
 & 0.12462E-03_JPRB,0.12202E-03_JPRB,0.11925E-03_JPRB,0.11640E-03_JPRB,0.11355E-03_JPRB /)  
KB(:,31,14) = (/ &
 & 0.12428E-03_JPRB,0.12163E-03_JPRB,0.11882E-03_JPRB,0.11594E-03_JPRB,0.11310E-03_JPRB /)  
KB(:,32,14) = (/ &
 & 0.12387E-03_JPRB,0.12116E-03_JPRB,0.11831E-03_JPRB,0.11542E-03_JPRB,0.11260E-03_JPRB /)  
KB(:,33,14) = (/ &
 & 0.12338E-03_JPRB,0.12061E-03_JPRB,0.11773E-03_JPRB,0.11485E-03_JPRB,0.11205E-03_JPRB /)  
KB(:,34,14) = (/ &
 & 0.12293E-03_JPRB,0.12013E-03_JPRB,0.11722E-03_JPRB,0.11434E-03_JPRB,0.11156E-03_JPRB /)  
KB(:,35,14) = (/ &
 & 0.12271E-03_JPRB,0.11987E-03_JPRB,0.11696E-03_JPRB,0.11408E-03_JPRB,0.11132E-03_JPRB /)  
KB(:,36,14) = (/ &
 & 0.12276E-03_JPRB,0.11992E-03_JPRB,0.11700E-03_JPRB,0.11412E-03_JPRB,0.11135E-03_JPRB /)  
KB(:,37,14) = (/ &
 & 0.12321E-03_JPRB,0.12039E-03_JPRB,0.11748E-03_JPRB,0.11457E-03_JPRB,0.11178E-03_JPRB /)  
KB(:,38,14) = (/ &
 & 0.12368E-03_JPRB,0.12086E-03_JPRB,0.11795E-03_JPRB,0.11504E-03_JPRB,0.11223E-03_JPRB /)  
KB(:,39,14) = (/ &
 & 0.12412E-03_JPRB,0.12132E-03_JPRB,0.11841E-03_JPRB,0.11549E-03_JPRB,0.11266E-03_JPRB /)  
KB(:,40,14) = (/ &
 & 0.12481E-03_JPRB,0.12205E-03_JPRB,0.11917E-03_JPRB,0.11624E-03_JPRB,0.11338E-03_JPRB /)  
KB(:,41,14) = (/ &
 & 0.12552E-03_JPRB,0.12282E-03_JPRB,0.11995E-03_JPRB,0.11701E-03_JPRB,0.11413E-03_JPRB /)  
KB(:,42,14) = (/ &
 & 0.12624E-03_JPRB,0.12356E-03_JPRB,0.12073E-03_JPRB,0.11779E-03_JPRB,0.11489E-03_JPRB /)  
KB(:,43,14) = (/ &
 & 0.12708E-03_JPRB,0.12444E-03_JPRB,0.12166E-03_JPRB,0.11873E-03_JPRB,0.11581E-03_JPRB /)  
KB(:,44,14) = (/ &
 & 0.12796E-03_JPRB,0.12537E-03_JPRB,0.12263E-03_JPRB,0.11974E-03_JPRB,0.11681E-03_JPRB /)  
KB(:,45,14) = (/ &
 & 0.12882E-03_JPRB,0.12627E-03_JPRB,0.12360E-03_JPRB,0.12075E-03_JPRB,0.11782E-03_JPRB /)  
KB(:,46,14) = (/ &
 & 0.12968E-03_JPRB,0.12723E-03_JPRB,0.12459E-03_JPRB,0.12181E-03_JPRB,0.11889E-03_JPRB /)  
KB(:,47,14) = (/ &
 & 0.13062E-03_JPRB,0.12827E-03_JPRB,0.12567E-03_JPRB,0.12295E-03_JPRB,0.12008E-03_JPRB /)  
KB(:,48,14) = (/ &
 & 0.13150E-03_JPRB,0.12926E-03_JPRB,0.12675E-03_JPRB,0.12408E-03_JPRB,0.12126E-03_JPRB /)  
KB(:,49,14) = (/ &
 & 0.13233E-03_JPRB,0.13021E-03_JPRB,0.12780E-03_JPRB,0.12517E-03_JPRB,0.12242E-03_JPRB /)  
KB(:,50,14) = (/ &
 & 0.13307E-03_JPRB,0.13105E-03_JPRB,0.12874E-03_JPRB,0.12618E-03_JPRB,0.12349E-03_JPRB /)  
KB(:,51,14) = (/ &
 & 0.13374E-03_JPRB,0.13183E-03_JPRB,0.12963E-03_JPRB,0.12715E-03_JPRB,0.12449E-03_JPRB /)  
KB(:,52,14) = (/ &
 & 0.13431E-03_JPRB,0.13255E-03_JPRB,0.13046E-03_JPRB,0.12807E-03_JPRB,0.12548E-03_JPRB /)  
KB(:,53,14) = (/ &
 & 0.13479E-03_JPRB,0.13325E-03_JPRB,0.13127E-03_JPRB,0.12898E-03_JPRB,0.12645E-03_JPRB /)  
KB(:,54,14) = (/ &
 & 0.13511E-03_JPRB,0.13385E-03_JPRB,0.13196E-03_JPRB,0.12979E-03_JPRB,0.12732E-03_JPRB /)  
KB(:,55,14) = (/ &
 & 0.13533E-03_JPRB,0.13436E-03_JPRB,0.13261E-03_JPRB,0.13052E-03_JPRB,0.12814E-03_JPRB /)  
KB(:,56,14) = (/ &
 & 0.13543E-03_JPRB,0.13477E-03_JPRB,0.13321E-03_JPRB,0.13121E-03_JPRB,0.12893E-03_JPRB /)  
KB(:,57,14) = (/ &
 & 0.13540E-03_JPRB,0.13509E-03_JPRB,0.13379E-03_JPRB,0.13190E-03_JPRB,0.12969E-03_JPRB /)  
KB(:,58,14) = (/ &
 & 0.13520E-03_JPRB,0.13532E-03_JPRB,0.13428E-03_JPRB,0.13250E-03_JPRB,0.13039E-03_JPRB /)  
KB(:,59,14) = (/ &
 & 0.13510E-03_JPRB,0.13536E-03_JPRB,0.13445E-03_JPRB,0.13273E-03_JPRB,0.13066E-03_JPRB /)  
KB(:,13,15) = (/ &
 & 0.16545E-03_JPRB,0.16076E-03_JPRB,0.15662E-03_JPRB,0.15273E-03_JPRB,0.14899E-03_JPRB /)  
KB(:,14,15) = (/ &
 & 0.17968E-03_JPRB,0.17402E-03_JPRB,0.16899E-03_JPRB,0.16434E-03_JPRB,0.15984E-03_JPRB /)  
KB(:,15,15) = (/ &
 & 0.19299E-03_JPRB,0.18634E-03_JPRB,0.18041E-03_JPRB,0.17491E-03_JPRB,0.16965E-03_JPRB /)  
KB(:,16,15) = (/ &
 & 0.20519E-03_JPRB,0.19756E-03_JPRB,0.19072E-03_JPRB,0.18435E-03_JPRB,0.17834E-03_JPRB /)  
KB(:,17,15) = (/ &
 & 0.21616E-03_JPRB,0.20753E-03_JPRB,0.19981E-03_JPRB,0.19268E-03_JPRB,0.18599E-03_JPRB /)  
KB(:,18,15) = (/ &
 & 0.22578E-03_JPRB,0.21627E-03_JPRB,0.20768E-03_JPRB,0.19983E-03_JPRB,0.19254E-03_JPRB /)  
KB(:,19,15) = (/ &
 & 0.23404E-03_JPRB,0.22371E-03_JPRB,0.21439E-03_JPRB,0.20593E-03_JPRB,0.19813E-03_JPRB /)  
KB(:,20,15) = (/ &
 & 0.24079E-03_JPRB,0.22975E-03_JPRB,0.21986E-03_JPRB,0.21084E-03_JPRB,0.20261E-03_JPRB /)  
KB(:,21,15) = (/ &
 & 0.24629E-03_JPRB,0.23467E-03_JPRB,0.22423E-03_JPRB,0.21475E-03_JPRB,0.20622E-03_JPRB /)  
KB(:,22,15) = (/ &
 & 0.24979E-03_JPRB,0.23775E-03_JPRB,0.22702E-03_JPRB,0.21724E-03_JPRB,0.20849E-03_JPRB /)  
KB(:,23,15) = (/ &
 & 0.25216E-03_JPRB,0.23989E-03_JPRB,0.22890E-03_JPRB,0.21892E-03_JPRB,0.21005E-03_JPRB /)  
KB(:,24,15) = (/ &
 & 0.25355E-03_JPRB,0.24109E-03_JPRB,0.22997E-03_JPRB,0.21990E-03_JPRB,0.21094E-03_JPRB /)  
KB(:,25,15) = (/ &
 & 0.25401E-03_JPRB,0.24151E-03_JPRB,0.23030E-03_JPRB,0.22024E-03_JPRB,0.21125E-03_JPRB /)  
KB(:,26,15) = (/ &
 & 0.25359E-03_JPRB,0.24114E-03_JPRB,0.22993E-03_JPRB,0.21995E-03_JPRB,0.21097E-03_JPRB /)  
KB(:,27,15) = (/ &
 & 0.25262E-03_JPRB,0.24030E-03_JPRB,0.22913E-03_JPRB,0.21926E-03_JPRB,0.21037E-03_JPRB /)  
KB(:,28,15) = (/ &
 & 0.25126E-03_JPRB,0.23904E-03_JPRB,0.22801E-03_JPRB,0.21831E-03_JPRB,0.20948E-03_JPRB /)  
KB(:,29,15) = (/ &
 & 0.24948E-03_JPRB,0.23745E-03_JPRB,0.22663E-03_JPRB,0.21704E-03_JPRB,0.20834E-03_JPRB /)  
KB(:,30,15) = (/ &
 & 0.24748E-03_JPRB,0.23558E-03_JPRB,0.22502E-03_JPRB,0.21558E-03_JPRB,0.20699E-03_JPRB /)  
KB(:,31,15) = (/ &
 & 0.24521E-03_JPRB,0.23353E-03_JPRB,0.22323E-03_JPRB,0.21394E-03_JPRB,0.20549E-03_JPRB /)  
KB(:,32,15) = (/ &
 & 0.24273E-03_JPRB,0.23132E-03_JPRB,0.22129E-03_JPRB,0.21221E-03_JPRB,0.20387E-03_JPRB /)  
KB(:,33,15) = (/ &
 & 0.24020E-03_JPRB,0.22911E-03_JPRB,0.21929E-03_JPRB,0.21039E-03_JPRB,0.20217E-03_JPRB /)  
KB(:,34,15) = (/ &
 & 0.23799E-03_JPRB,0.22719E-03_JPRB,0.21754E-03_JPRB,0.20880E-03_JPRB,0.20071E-03_JPRB /)  
KB(:,35,15) = (/ &
 & 0.23687E-03_JPRB,0.22619E-03_JPRB,0.21668E-03_JPRB,0.20798E-03_JPRB,0.19994E-03_JPRB /)  
KB(:,36,15) = (/ &
 & 0.23693E-03_JPRB,0.22624E-03_JPRB,0.21673E-03_JPRB,0.20802E-03_JPRB,0.19997E-03_JPRB /)  
KB(:,37,15) = (/ &
 & 0.23866E-03_JPRB,0.22780E-03_JPRB,0.21810E-03_JPRB,0.20930E-03_JPRB,0.20116E-03_JPRB /)  
KB(:,38,15) = (/ &
 & 0.24049E-03_JPRB,0.22941E-03_JPRB,0.21958E-03_JPRB,0.21064E-03_JPRB,0.20240E-03_JPRB /)  
KB(:,39,15) = (/ &
 & 0.24235E-03_JPRB,0.23100E-03_JPRB,0.22101E-03_JPRB,0.21195E-03_JPRB,0.20362E-03_JPRB /)  
KB(:,40,15) = (/ &
 & 0.24544E-03_JPRB,0.23374E-03_JPRB,0.22344E-03_JPRB,0.21416E-03_JPRB,0.20567E-03_JPRB /)  
KB(:,41,15) = (/ &
 & 0.24874E-03_JPRB,0.23671E-03_JPRB,0.22606E-03_JPRB,0.21653E-03_JPRB,0.20786E-03_JPRB /)  
KB(:,42,15) = (/ &
 & 0.25214E-03_JPRB,0.23974E-03_JPRB,0.22874E-03_JPRB,0.21892E-03_JPRB,0.21007E-03_JPRB /)  
KB(:,43,15) = (/ &
 & 0.25633E-03_JPRB,0.24355E-03_JPRB,0.23207E-03_JPRB,0.22195E-03_JPRB,0.21281E-03_JPRB /)  
KB(:,44,15) = (/ &
 & 0.26108E-03_JPRB,0.24779E-03_JPRB,0.23584E-03_JPRB,0.22529E-03_JPRB,0.21581E-03_JPRB /)  
KB(:,45,15) = (/ &
 & 0.26596E-03_JPRB,0.25216E-03_JPRB,0.23977E-03_JPRB,0.22875E-03_JPRB,0.21897E-03_JPRB /)  
KB(:,46,15) = (/ &
 & 0.27137E-03_JPRB,0.25699E-03_JPRB,0.24413E-03_JPRB,0.23258E-03_JPRB,0.22240E-03_JPRB /)  
KB(:,47,15) = (/ &
 & 0.27767E-03_JPRB,0.26264E-03_JPRB,0.24919E-03_JPRB,0.23707E-03_JPRB,0.22639E-03_JPRB /)  
KB(:,48,15) = (/ &
 & 0.28422E-03_JPRB,0.26851E-03_JPRB,0.25443E-03_JPRB,0.24179E-03_JPRB,0.23054E-03_JPRB /)  
KB(:,49,15) = (/ &
 & 0.29109E-03_JPRB,0.27465E-03_JPRB,0.25993E-03_JPRB,0.24676E-03_JPRB,0.23489E-03_JPRB /)  
KB(:,50,15) = (/ &
 & 0.29784E-03_JPRB,0.28066E-03_JPRB,0.26532E-03_JPRB,0.25156E-03_JPRB,0.23921E-03_JPRB /)  
KB(:,51,15) = (/ &
 & 0.30464E-03_JPRB,0.28674E-03_JPRB,0.27072E-03_JPRB,0.25642E-03_JPRB,0.24358E-03_JPRB /)  
KB(:,52,15) = (/ &
 & 0.31175E-03_JPRB,0.29305E-03_JPRB,0.27640E-03_JPRB,0.26149E-03_JPRB,0.24813E-03_JPRB /)  
KB(:,53,15) = (/ &
 & 0.31921E-03_JPRB,0.29964E-03_JPRB,0.28229E-03_JPRB,0.26674E-03_JPRB,0.25282E-03_JPRB /)  
KB(:,54,15) = (/ &
 & 0.32632E-03_JPRB,0.30596E-03_JPRB,0.28789E-03_JPRB,0.27174E-03_JPRB,0.25731E-03_JPRB /)  
KB(:,55,15) = (/ &
 & 0.33342E-03_JPRB,0.31218E-03_JPRB,0.29344E-03_JPRB,0.27674E-03_JPRB,0.26179E-03_JPRB /)  
KB(:,56,15) = (/ &
 & 0.34053E-03_JPRB,0.31870E-03_JPRB,0.29920E-03_JPRB,0.28191E-03_JPRB,0.26637E-03_JPRB /)  
KB(:,57,15) = (/ &
 & 0.34801E-03_JPRB,0.32554E-03_JPRB,0.30518E-03_JPRB,0.28726E-03_JPRB,0.27114E-03_JPRB /)  
KB(:,58,15) = (/ &
 & 0.35537E-03_JPRB,0.33214E-03_JPRB,0.31109E-03_JPRB,0.29248E-03_JPRB,0.27588E-03_JPRB /)  
KB(:,59,15) = (/ &
 & 0.35841E-03_JPRB,0.33487E-03_JPRB,0.31352E-03_JPRB,0.29463E-03_JPRB,0.27781E-03_JPRB /)  
KB(:,13,16) = (/ &
 & 0.23817E-03_JPRB,0.23193E-03_JPRB,0.22589E-03_JPRB,0.21979E-03_JPRB,0.21365E-03_JPRB /)  
KB(:,14,16) = (/ &
 & 0.26266E-03_JPRB,0.25442E-03_JPRB,0.24663E-03_JPRB,0.23897E-03_JPRB,0.23152E-03_JPRB /)  
KB(:,15,16) = (/ &
 & 0.28586E-03_JPRB,0.27559E-03_JPRB,0.26587E-03_JPRB,0.25663E-03_JPRB,0.24800E-03_JPRB /)  
KB(:,16,16) = (/ &
 & 0.30726E-03_JPRB,0.29496E-03_JPRB,0.28337E-03_JPRB,0.27251E-03_JPRB,0.26278E-03_JPRB /)  
KB(:,17,16) = (/ &
 & 0.32665E-03_JPRB,0.31224E-03_JPRB,0.29895E-03_JPRB,0.28665E-03_JPRB,0.27581E-03_JPRB /)  
KB(:,18,16) = (/ &
 & 0.34367E-03_JPRB,0.32749E-03_JPRB,0.31249E-03_JPRB,0.29896E-03_JPRB,0.28707E-03_JPRB /)  
KB(:,19,16) = (/ &
 & 0.35833E-03_JPRB,0.34046E-03_JPRB,0.32413E-03_JPRB,0.30949E-03_JPRB,0.29662E-03_JPRB /)  
KB(:,20,16) = (/ &
 & 0.37032E-03_JPRB,0.35107E-03_JPRB,0.33355E-03_JPRB,0.31795E-03_JPRB,0.30443E-03_JPRB /)  
KB(:,21,16) = (/ &
 & 0.38004E-03_JPRB,0.35962E-03_JPRB,0.34106E-03_JPRB,0.32482E-03_JPRB,0.31071E-03_JPRB /)  
KB(:,22,16) = (/ &
 & 0.38628E-03_JPRB,0.36502E-03_JPRB,0.34582E-03_JPRB,0.32929E-03_JPRB,0.31473E-03_JPRB /)  
KB(:,23,16) = (/ &
 & 0.39046E-03_JPRB,0.36870E-03_JPRB,0.34902E-03_JPRB,0.33239E-03_JPRB,0.31753E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART16',1,ZHOOK_HANDLE)
END SUBROUTINE PART16


SUBROUTINE PART17

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART17',0,ZHOOK_HANDLE)


KB(:,24,16) = (/ &
 & 0.39290E-03_JPRB,0.37079E-03_JPRB,0.35085E-03_JPRB,0.33417E-03_JPRB,0.31909E-03_JPRB /)  
KB(:,25,16) = (/ &
 & 0.39368E-03_JPRB,0.37132E-03_JPRB,0.35155E-03_JPRB,0.33489E-03_JPRB,0.31974E-03_JPRB /)  
KB(:,26,16) = (/ &
 & 0.39288E-03_JPRB,0.37052E-03_JPRB,0.35111E-03_JPRB,0.33452E-03_JPRB,0.31938E-03_JPRB /)  
KB(:,27,16) = (/ &
 & 0.39120E-03_JPRB,0.36896E-03_JPRB,0.34999E-03_JPRB,0.33347E-03_JPRB,0.31836E-03_JPRB /)  
KB(:,28,16) = (/ &
 & 0.38862E-03_JPRB,0.36669E-03_JPRB,0.34828E-03_JPRB,0.33189E-03_JPRB,0.31693E-03_JPRB /)  
KB(:,29,16) = (/ &
 & 0.38540E-03_JPRB,0.36396E-03_JPRB,0.34596E-03_JPRB,0.32975E-03_JPRB,0.31502E-03_JPRB /)  
KB(:,30,16) = (/ &
 & 0.38165E-03_JPRB,0.36095E-03_JPRB,0.34333E-03_JPRB,0.32738E-03_JPRB,0.31277E-03_JPRB /)  
KB(:,31,16) = (/ &
 & 0.37756E-03_JPRB,0.35762E-03_JPRB,0.34034E-03_JPRB,0.32467E-03_JPRB,0.31030E-03_JPRB /)  
KB(:,32,16) = (/ &
 & 0.37323E-03_JPRB,0.35410E-03_JPRB,0.33709E-03_JPRB,0.32164E-03_JPRB,0.30764E-03_JPRB /)  
KB(:,33,16) = (/ &
 & 0.36881E-03_JPRB,0.35033E-03_JPRB,0.33368E-03_JPRB,0.31855E-03_JPRB,0.30481E-03_JPRB /)  
KB(:,34,16) = (/ &
 & 0.36518E-03_JPRB,0.34710E-03_JPRB,0.33080E-03_JPRB,0.31589E-03_JPRB,0.30241E-03_JPRB /)  
KB(:,35,16) = (/ &
 & 0.36331E-03_JPRB,0.34548E-03_JPRB,0.32924E-03_JPRB,0.31455E-03_JPRB,0.30119E-03_JPRB /)  
KB(:,36,16) = (/ &
 & 0.36345E-03_JPRB,0.34559E-03_JPRB,0.32934E-03_JPRB,0.31463E-03_JPRB,0.30125E-03_JPRB /)  
KB(:,37,16) = (/ &
 & 0.36636E-03_JPRB,0.34821E-03_JPRB,0.33175E-03_JPRB,0.31676E-03_JPRB,0.30324E-03_JPRB /)  
KB(:,38,16) = (/ &
 & 0.36948E-03_JPRB,0.35092E-03_JPRB,0.33423E-03_JPRB,0.31902E-03_JPRB,0.30527E-03_JPRB /)  
KB(:,39,16) = (/ &
 & 0.37259E-03_JPRB,0.35368E-03_JPRB,0.33668E-03_JPRB,0.32128E-03_JPRB,0.30727E-03_JPRB /)  
KB(:,40,16) = (/ &
 & 0.37795E-03_JPRB,0.35829E-03_JPRB,0.34085E-03_JPRB,0.32505E-03_JPRB,0.31069E-03_JPRB /)  
KB(:,41,16) = (/ &
 & 0.38379E-03_JPRB,0.36312E-03_JPRB,0.34529E-03_JPRB,0.32908E-03_JPRB,0.31437E-03_JPRB /)  
KB(:,42,16) = (/ &
 & 0.38990E-03_JPRB,0.36819E-03_JPRB,0.34980E-03_JPRB,0.33322E-03_JPRB,0.31806E-03_JPRB /)  
KB(:,43,16) = (/ &
 & 0.39755E-03_JPRB,0.37469E-03_JPRB,0.35548E-03_JPRB,0.33833E-03_JPRB,0.32274E-03_JPRB /)  
KB(:,44,16) = (/ &
 & 0.40604E-03_JPRB,0.38206E-03_JPRB,0.36178E-03_JPRB,0.34404E-03_JPRB,0.32793E-03_JPRB /)  
KB(:,45,16) = (/ &
 & 0.41497E-03_JPRB,0.38998E-03_JPRB,0.36828E-03_JPRB,0.34986E-03_JPRB,0.33329E-03_JPRB /)  
KB(:,46,16) = (/ &
 & 0.42497E-03_JPRB,0.39871E-03_JPRB,0.37566E-03_JPRB,0.35633E-03_JPRB,0.33909E-03_JPRB /)  
KB(:,47,16) = (/ &
 & 0.43684E-03_JPRB,0.40880E-03_JPRB,0.38451E-03_JPRB,0.36380E-03_JPRB,0.34586E-03_JPRB /)  
KB(:,48,16) = (/ &
 & 0.44932E-03_JPRB,0.41960E-03_JPRB,0.39404E-03_JPRB,0.37171E-03_JPRB,0.35286E-03_JPRB /)  
KB(:,49,16) = (/ &
 & 0.46270E-03_JPRB,0.43113E-03_JPRB,0.40397E-03_JPRB,0.38027E-03_JPRB,0.36021E-03_JPRB /)  
KB(:,50,16) = (/ &
 & 0.47605E-03_JPRB,0.44249E-03_JPRB,0.41370E-03_JPRB,0.38887E-03_JPRB,0.36733E-03_JPRB /)  
KB(:,51,16) = (/ &
 & 0.48981E-03_JPRB,0.45414E-03_JPRB,0.42376E-03_JPRB,0.39765E-03_JPRB,0.37477E-03_JPRB /)  
KB(:,52,16) = (/ &
 & 0.50430E-03_JPRB,0.46661E-03_JPRB,0.43437E-03_JPRB,0.40673E-03_JPRB,0.38268E-03_JPRB /)  
KB(:,53,16) = (/ &
 & 0.51980E-03_JPRB,0.47970E-03_JPRB,0.44558E-03_JPRB,0.41639E-03_JPRB,0.39115E-03_JPRB /)  
KB(:,54,16) = (/ &
 & 0.53506E-03_JPRB,0.49244E-03_JPRB,0.45647E-03_JPRB,0.42564E-03_JPRB,0.39926E-03_JPRB /)  
KB(:,55,16) = (/ &
 & 0.55131E-03_JPRB,0.50528E-03_JPRB,0.46739E-03_JPRB,0.43505E-03_JPRB,0.40730E-03_JPRB /)  
KB(:,56,16) = (/ &
 & 0.56909E-03_JPRB,0.51883E-03_JPRB,0.47884E-03_JPRB,0.44497E-03_JPRB,0.41571E-03_JPRB /)  
KB(:,57,16) = (/ &
 & 0.58824E-03_JPRB,0.53334E-03_JPRB,0.49097E-03_JPRB,0.45523E-03_JPRB,0.42457E-03_JPRB /)  
KB(:,58,16) = (/ &
 & 0.60745E-03_JPRB,0.54837E-03_JPRB,0.50301E-03_JPRB,0.46546E-03_JPRB,0.43352E-03_JPRB /)  
KB(:,59,16) = (/ &
 & 0.61557E-03_JPRB,0.55493E-03_JPRB,0.50805E-03_JPRB,0.46962E-03_JPRB,0.43716E-03_JPRB /)  

!     -----------------------------------------------------------------

FORREF(:, 1) = (/ 0.351362E-07_JPRB, 0.341136E-07_JPRB, 0.181317E-06_JPRB /)
FORREF(:, 2) = (/ 0.109648E-06_JPRB, 0.344240E-06_JPRB, 0.139709E-05_JPRB /)
FORREF(:, 3) = (/ 0.374823E-06_JPRB, 0.103424E-05_JPRB, 0.188717E-05_JPRB /)
FORREF(:, 4) = (/ 0.580041E-06_JPRB, 0.116876E-05_JPRB, 0.121183E-05_JPRB /)
FORREF(:, 5) = (/ 0.115608E-05_JPRB, 0.148110E-05_JPRB, 0.836083E-06_JPRB /)
FORREF(:, 6) = (/ 0.181460E-05_JPRB, 0.133313E-05_JPRB, 0.500167E-06_JPRB /)
FORREF(:, 7) = (/ 0.199096E-05_JPRB, 0.115276E-05_JPRB, 0.432994E-06_JPRB /)
FORREF(:, 8) = (/ 0.183730E-05_JPRB, 0.122260E-05_JPRB, 0.433248E-06_JPRB /)
FORREF(:, 9) = (/ 0.198386E-05_JPRB, 0.100130E-05_JPRB, 0.269712E-06_JPRB /)
FORREF(:,10) = (/ 0.276382E-05_JPRB, 0.749215E-06_JPRB, 0.236919E-06_JPRB /)
FORREF(:,11) = (/ 0.298202E-05_JPRB, 0.629688E-06_JPRB, 0.228388E-06_JPRB /)
FORREF(:,12) = (/ 0.364604E-05_JPRB, 0.455336E-06_JPRB, 0.206130E-06_JPRB /)
FORREF(:,13) = (/ 0.373339E-05_JPRB, 0.245210E-06_JPRB, 0.201987E-06_JPRB /)
FORREF(:,14) = (/ 0.480378E-05_JPRB, 0.177591E-06_JPRB, 0.171458E-06_JPRB /)
FORREF(:,15) = (/ 0.521700E-05_JPRB, 0.203358E-06_JPRB, 0.189559E-06_JPRB /)
FORREF(:,16) = (/ 0.542717E-05_JPRB, 0.219022E-06_JPRB, 0.218271E-06_JPRB /)

!     -----------------------------------------------------------------
!     The array SELFREF contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREF(:, 1) = (/ &
 & 0.538526E-04_JPRB, 0.464603E-04_JPRB, 0.400828E-04_JPRB, 0.345807E-04_JPRB, 0.298339E-04_JPRB, &
 & 0.257386E-04_JPRB, 0.222055E-04_JPRB, 0.191574E-04_JPRB, 0.165277E-04_JPRB, 0.142590E-04_JPRB /)  
SELFREF(:, 2) = (/ &
 & 0.162409E-03_JPRB, 0.128347E-03_JPRB, 0.101430E-03_JPRB, 0.801571E-04_JPRB, 0.633460E-04_JPRB, &
 & 0.500607E-04_JPRB, 0.395616E-04_JPRB, 0.312645E-04_JPRB, 0.247075E-04_JPRB, 0.195257E-04_JPRB /)  
SELFREF(:, 3) = (/ &
 & 0.262882E-03_JPRB, 0.212793E-03_JPRB, 0.172247E-03_JPRB, 0.139427E-03_JPRB, 0.112860E-03_JPRB, &
 & 0.913557E-04_JPRB, 0.739487E-04_JPRB, 0.598584E-04_JPRB, 0.484529E-04_JPRB, 0.392206E-04_JPRB /)  
SELFREF(:, 4) = (/ &
 & 0.242873E-03_JPRB, 0.204225E-03_JPRB, 0.171726E-03_JPRB, 0.144399E-03_JPRB, 0.121421E-03_JPRB, &
 & 0.102099E-03_JPRB, 0.858516E-04_JPRB, 0.721899E-04_JPRB, 0.607022E-04_JPRB, 0.510426E-04_JPRB /)  
SELFREF(:, 5) = (/ &
 & 0.235614E-03_JPRB, 0.207814E-03_JPRB, 0.183293E-03_JPRB, 0.161666E-03_JPRB, 0.142591E-03_JPRB, &
 & 0.125766E-03_JPRB, 0.110927E-03_JPRB, 0.978381E-04_JPRB, 0.862939E-04_JPRB, 0.761119E-04_JPRB /)  
SELFREF(:, 6) = (/ &
 & 0.205508E-03_JPRB, 0.190174E-03_JPRB, 0.175985E-03_JPRB, 0.162854E-03_JPRB, 0.150702E-03_JPRB, &
 & 0.139458E-03_JPRB, 0.129052E-03_JPRB, 0.119423E-03_JPRB, 0.110513E-03_JPRB, 0.102267E-03_JPRB /)  
SELFREF(:, 7) = (/ &
 & 0.185027E-03_JPRB, 0.175148E-03_JPRB, 0.165796E-03_JPRB, 0.156944E-03_JPRB, 0.148565E-03_JPRB, &
 & 0.140633E-03_JPRB, 0.133124E-03_JPRB, 0.126016E-03_JPRB, 0.119288E-03_JPRB, 0.112919E-03_JPRB /)  
SELFREF(:, 8) = (/ &
 & 0.192634E-03_JPRB, 0.180192E-03_JPRB, 0.168554E-03_JPRB, 0.157668E-03_JPRB, 0.147484E-03_JPRB, &
 & 0.137959E-03_JPRB, 0.129048E-03_JPRB, 0.120713E-03_JPRB, 0.112917E-03_JPRB, 0.105624E-03_JPRB /)  
SELFREF(:, 9) = (/ &
 & 0.161632E-03_JPRB, 0.155919E-03_JPRB, 0.150408E-03_JPRB, 0.145092E-03_JPRB, 0.139963E-03_JPRB, &
 & 0.135016E-03_JPRB, 0.130244E-03_JPRB, 0.125640E-03_JPRB, 0.121199E-03_JPRB, 0.116915E-03_JPRB /)  
SELFREF(:,10) = (/ &
 & 0.120880E-03_JPRB, 0.125265E-03_JPRB, 0.129810E-03_JPRB, 0.134520E-03_JPRB, 0.139400E-03_JPRB, &
 & 0.144458E-03_JPRB, 0.149699E-03_JPRB, 0.155130E-03_JPRB, 0.160758E-03_JPRB, 0.166591E-03_JPRB /)  
SELFREF(:,11) = (/ &
 & 0.104705E-03_JPRB, 0.111761E-03_JPRB, 0.119291E-03_JPRB, 0.127330E-03_JPRB, 0.135910E-03_JPRB, &
 & 0.145068E-03_JPRB, 0.154843E-03_JPRB, 0.165277E-03_JPRB, 0.176414E-03_JPRB, 0.188302E-03_JPRB /)  
SELFREF(:,12) = (/ &
 & 0.846335E-04_JPRB, 0.951236E-04_JPRB, 0.106914E-03_JPRB, 0.120166E-03_JPRB, 0.135060E-03_JPRB, &
 & 0.151800E-03_JPRB, 0.170616E-03_JPRB, 0.191763E-03_JPRB, 0.215532E-03_JPRB, 0.242246E-03_JPRB /)  
SELFREF(:,13) = (/ &
 & 0.669754E-04_JPRB, 0.781902E-04_JPRB, 0.912829E-04_JPRB, 0.106568E-03_JPRB, 0.124413E-03_JPRB, &
 & 0.145245E-03_JPRB, 0.169566E-03_JPRB, 0.197959E-03_JPRB, 0.231107E-03_JPRB, 0.269805E-03_JPRB /)  
SELFREF(:,14) = (/ &
 & 0.597091E-04_JPRB, 0.722265E-04_JPRB, 0.873679E-04_JPRB, 0.105684E-03_JPRB, 0.127839E-03_JPRB, &
 & 0.154639E-03_JPRB, 0.187057E-03_JPRB, 0.226272E-03_JPRB, 0.273707E-03_JPRB, 0.331087E-03_JPRB /)  
SELFREF(:,15) = (/ &
 & 0.640410E-04_JPRB, 0.771879E-04_JPRB, 0.930338E-04_JPRB, 0.112133E-03_JPRB, 0.135152E-03_JPRB, &
 & 0.162897E-03_JPRB, 0.196338E-03_JPRB, 0.236644E-03_JPRB, 0.285225E-03_JPRB, 0.343778E-03_JPRB /)  
SELFREF(:,16) = (/ &
 & 0.666420E-04_JPRB, 0.801056E-04_JPRB, 0.962892E-04_JPRB, 0.115742E-03_JPRB, 0.139126E-03_JPRB, &
 & 0.167233E-03_JPRB, 0.201019E-03_JPRB, 0.241630E-03_JPRB, 0.290446E-03_JPRB, 0.349125E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB22:PART17',1,ZHOOK_HANDLE)
END SUBROUTINE PART17


END SUBROUTINE SRTM_KGB22

