MODULE chemistry_cycle_mod

!=======================================================================
!   Authors: Anne Cozic and Thibaut Lurton
!
!  Purpose and description:
!  -----------------------
! Control module for the chemistry  tracers :
!   - Definition of fluxes to be exchanged with Pisces and Inca 
!
!=======================================================================


  IMPLICIT NONE

! Variables read from parmeter file physiq.def
  LOGICAL, SAVE, PUBLIC :: dms_cycle_cpl       ! Coupling of DMS fluxes between INCA and PISCES 
!$OMP THREADPRIVATE(dms_cycle_cpl)   

  LOGICAL, SAVE, PUBLIC :: n2o_cycle_cpl       ! Coupling of N2O fluxes between INCA and PISCES / PISCES and INCA 
!$OMP THREADPRIVATE(n2o_cycle_cpl)   

  LOGICAL, SAVE, PUBLIC :: ndp_cycle_cpl       ! Coupling of N deposition between INCA and PISCES
!$OMP THREADPRIVATE(ndp_cycle_cpl)

  LOGICAL, SAVE, PUBLIC :: nh3_cycle_cpl       ! Coupling of NH3 fluxes between PISCES and INCA
!$OMP THREADPRIVATE(nh3_cycle_cpl)
  
END MODULE chemistry_cycle_mod
