!
! $Header$
!
SUBROUTINE geopot (ngrid, teta, pk, pks, phis, phi )
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
  USE paramet_mod_h

IMPLICIT NONE

  !=======================================================================
  !
  !   Auteur:  P. Le Van
  !   -------
  !
  !   Objet:
  !   ------
  !
  !    *******************************************************************
  !    ....   calcul du geopotentiel aux milieux des couches    .....
  !    *******************************************************************
  !
  ! ....   l'integration se fait de bas en haut  ....
  !
  ! .. ngrid,teta,pk,pks,phis sont des argum. d'entree pour le s-pg ..
  !          phi               est un  argum. de sortie pour le s-pg .
  !
  !=======================================================================
  !-----------------------------------------------------------------------
  !   Declarations:
  !   -------------

  !   Arguments:
  !   ----------

  INTEGER :: ngrid
  REAL :: teta(ngrid,llm),pks(ngrid),phis(ngrid),pk(ngrid,llm) , &
        phi(ngrid,llm)


  !   Local:
  !   ------

  INTEGER :: l, ij


  !-----------------------------------------------------------------------
  ! calcul de phi au niveau 1 pres du sol  .....

  DO  ij  = 1, ngrid
  phi( ij,1 ) = phis( ij ) + teta(ij,1) * ( pks(ij) - pk(ij,1) )
  END DO

  ! calcul de phi aux niveaux superieurs  .......

  DO  l = 2,llm
    DO  ij    = 1,ngrid
    phi(ij,l) = phi(ij,l-1) + 0.5 * ( teta(ij,l)  + teta(ij,l-1) ) &
          *   (  pk(ij,l-1) -  pk(ij,l)    )
    ENDDO
  ENDDO

  RETURN
END SUBROUTINE geopot
