SUBROUTINE add_wake_tend(zddeltat, zddeltaq, zds, zdas, zddensw, zddensaw, zoccur, text, abortphy &
#ifdef ISO
        , zddeltaxt &
#endif
        )
!===================================================================
! Ajoute les tendances lies aux diverses parametrisations physiques aux
! variables d'etat des poches froides.
!===================================================================
!======================================================================
! Declarations
!======================================================================

USE dimphy, ONLY: klon, klev
USE phys_state_var_mod, ONLY: wake_deltat, wake_deltaq, wake_s, awake_s,  &
                              wake_dens, awake_dens

USE print_control_mod, ONLY: prt_level
#ifdef ISO
    USE infotrac_phy, ONLY: ntiso    
    USE phys_state_var_mod, ONLY:  wake_deltaxt   
#endif
IMPLICIT none

! Arguments :
!------------
  REAL, DIMENSION(klon, klev),   INTENT (IN)         :: zddeltat, zddeltaq
  REAL, DIMENSION(klon),         INTENT (IN)         :: zds, zdas, zddensw, zddensaw
  INTEGER, DIMENSION(klon),      INTENT (IN)         :: zoccur
  CHARACTER*(*),                 INTENT (IN)         :: text
  INTEGER,                       INTENT (IN)         :: abortphy
#ifdef ISO
  REAL, DIMENSION(ntiso, klon, klev), INTENT (IN)    :: zddeltaxt
#endif

! Local :
!--------

INTEGER                                              :: i, l
#ifdef ISO
INTEGER                                              :: ixt
#endif



     IF (prt_level >= 5) then
        write (*,*) "In add_wake_tend, after ",text
        call flush
     end if

     IF (abortphy==1) RETURN ! on n ajoute pas les tendance si le modele
                              ! a deja plante.

!======================================================================
!    Add tendencies to wake state variables
!======================================================================
         DO l = 1, klev
           DO i = 1, klon
             IF (zoccur(i) .GE. 1) THEN
               wake_deltat(i, l) = wake_deltat(i, l) + zddeltat(i,l)
               wake_deltaq(i, l) = wake_deltaq(i, l) + zddeltaq(i,l)
#ifdef ISO
               do ixt=1,ntiso
                 wake_deltaxt(ixt,i, l) = wake_deltaxt(ixt,i, l) + zddeltaxt(ixt,i,l)
               enddo
#endif
             ELSE
               wake_deltat(i, l) = 0.
               wake_deltaq(i, l) = 0.
#ifdef ISO
               do ixt=1,ntiso
                 wake_deltaxt(ixt,i, l) = 0.0
               enddo
#endif
             ENDIF   ! (zoccur(i) .GE. 1)
           END DO
         END DO
         DO i = 1, klon
           IF (zoccur(i) .GE. 1) THEN
             wake_s(i)     = wake_s(i)    + zds(i)
             awake_s(i)    = awake_s(i)    + zdas(i)
             wake_dens(i)  = wake_dens(i) + zddensw(i)
             awake_dens(i) = awake_dens(i) + zddensaw(i)
           ELSE
             wake_s(i)     = 0.
             awake_s(i)    = 0.
             wake_dens(i)  = 0.
             awake_dens(i) = 0.
           ENDIF   ! (zoccur(i) .GE. 1)
         END DO

RETURN
END
