SUBROUTINE SUGFL

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOMLUN , ONLY :  NULOUT
USE YOM_YGFL , ONLY : YGFL,YGFLC,YL, YI, YA, YS, YR, YG, YTKE,&
 & YO3, YSRC, YEXT, YQ, YCVGQ, JPGFL,YQVA, &
 & YL_NL, YI_NL, YA_NL, YO3_NL, YSRC_NL, YEXT_NL, YQ_NL,YQVA_NL, &
 & YS_NL, YR_NL, YG_NL, YTKE_NL,YCVGQ_NL,NGFL_EXT,&
 & YCPF , YSPF ,YCPF_NL, YSPF_NL, YAERO, YAERO_NL, NAERO, YGRG, YGRG_NL, NGRG,&
 & YSDSAT, YCVV, YSDSAT_NL, YCVV_NL, YFORC, YFORC_NL, NGFL_FORC,&
 & YEZDIAG, YEZDIAG_NL, NGFL_EZDIAG, &
 & YGHG, YGHG_NL, NGHG, YTRAC, YTRAC_NL, NTRAC, &
 & YUOM     ,YUAL     ,YDOM     ,YDAL     ,YUEN     ,YUNEBH, &
 & YUOM_NL  ,YUAL_NL  ,YDOM_NL  ,YDAL_NL  ,YUEN_NL  ,YUNEBH_NL
USE GFL_SUBS ,ONLY : DEFINE_GFL_COMP 
USE YOMDIM , ONLY : LADER
USE YOMCST   , ONLY : RV       ,RCPV     ,RCW      ,RCS
USE YOMGRB , ONLY : NGRBQ, NGRBO3, NGRBCLWC, NGRBCIWC,&
 & NGRBCC, NGRB149
USE YOMCT0   , ONLY : LFPART2,NCONF
USE YOMFA  , ONLY : YFAQ     ,YFAL     ,YFAI     ,YFAO3    ,&
 & YFAS     ,YFAR     ,YFAG     ,YFATKE   ,&
 & YFACPF, YFASPF, YFACLF,YFASRC, YFACVGQ, YFASDSAT, YFACVV ,&
 & YFAQVA, &
 & YFAUOM, YFAUAL, YFADOM, YFADAL, YFAUEN, YFAUNEBH

!**** *SUGFL*  - Initialize definition of unified_treatment grid_point fields

!     Purpose.
!     --------
!           Initialize definition of unified_treatment fields (GFL)
!           The GFL ordering in this routine is the ordering for "t" and
!           "t+dt" values of the GFL in grid-point arrays (GFL and GFLT1),
!           and also the ordering in the spectral array SPGFL.

!**   Interface.
!     ----------
!        *CALL* *SUGFL

!        Explicit arguments :
!        --------------------

!        Implicit arguments :
!        --------------------
!        MODULE YOM_YGFL

!     Method.
!     -------
!        See documentation

!     Externals.
!     ----------
!        None

!     Reference.
!     ----------
!        ECMWF Research Department documentation of the IFS

!     Author.
!     -------
!        Mats Hamrud  *ECMWF*

!     Modifications.
!     --------------
!        Original : 2002-03-11
!        M.Hamrud : 2002-08-01 Extensive mods
!        R. El Khatib : 2003-08-19 ARPEGE field names
!        M.Hamrud      01-Oct-2003 CY28 Cleaning
!        M. Tudor : 2003-10-17 introduce YCPF and YSPF in GFL
!        A. Untch : 2005-03-11 introduce aerosols
!        J. Flemming : 2005-04-11 replace aerosols with GRG
!        Y. Seity  : 2004-11-16 AROME GFL fields
!        C. Fischer: 23-May-2005 No Ozone in the Meteo-France control variable
!        Y. Bouteloup: 13-Oct-2005 introduce YCVGQ (Moisture convergence for French physics)
!        J. Haseler : 2005-10-11 introduce LTRAJIO
!        JJMorcrette  20060512 GEMS variables in cy31
!        S. Serrar    20060907 tracers used for diagnostics only (in GFL between GHG and GRG)
!        A. Alias : 2006-10-13 introduction of YSDSAT and YCVV
!        B. Sass :  HIRLAM pseudo-prognostic field YQVA
!        M. Bellus : 27-Sep-2006 introduce YUOM, YUAL, YDOM, YDAL, YUEN and
!                    YUNEBH (ALARO-0 prognostic convection) + spotted/corrected bug
!                    in index incrementation after YO3
!     ------------------------------------------------------------------

IMPLICIT NONE

INTEGER(KIND=JPIM) :: JGFL,IGFLPTR,INCR
LOGICAL   :: LLDERS,LLT1,LL5
REAL(KIND=JPRB) :: ZHOOK_HANDLE

!-------------------------------------------------------------------------

#include "abor1.intfb.h"

!-------------------------------------------------------------------------

IF (LHOOK) CALL DR_HOOK('SUGFL',0,ZHOOK_HANDLE)

!-------------------------------------------------------------------------

IF( .NOT.LFPART2) THEN

!      1.   CASE LFPART2=F
!
!      1.1  Initial settings.

  YGFL%NUMFLDS=0

  LL5=NCONF/100 == 1.OR.NCONF == 801.OR.NCONF == 601.OR. &
   & NCONF == 401.OR.NCONF == 501  
  LLT1=.TRUE.
  ! All gridpoint fields have to be set up before the spectral ones
  !  (i.e. part 1.2 SHOULD be done before part 1.3)
  LLDERS=.FALSE.
  ! * Simple GFL variables:
  !   (order should be the same in parts 1.1, 1.2 and 1.3).
  INCR=0 
  YQ    => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YL    => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YI    => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YS    => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YR    => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YG    => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YTKE  => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YA    => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YO3   => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YCPF  => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YSPF  => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YSRC  => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YCVGQ => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YSDSAT => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YCVV  => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YQVA  => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YUOM => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YUAL => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YDOM => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YDAL => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YUEN => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  YUNEBH => YGFLC(JPGFL-INCR)
  INCR=INCR+1
  ! * Groups of multiple GFL variables:
  !   (order should be the same in parts 1.1, 1.2 and 1.3).
  IF (NGFL_EXT == 0) THEN
    YEXT => YGFLC(JPGFL-INCR:JPGFL-INCR)
    INCR=INCR+1
  ENDIF
  IF (NGFL_FORC == 0) THEN
    YFORC => YGFLC(JPGFL-INCR:JPGFL-INCR)
    INCR=INCR+1
  ENDIF
  IF (NGFL_EZDIAG == 0) THEN
    YEZDIAG => YGFLC(JPGFL-INCR:JPGFL-INCR)
    INCR=INCR+1
  ENDIF
  IF (NGHG == 0) THEN
    YGHG => YGFLC(JPGFL-INCR:JPGFL-INCR)
    INCR=INCR+1
  ENDIF
  IF (NTRAC == 0) THEN
    YTRAC => YGFLC(JPGFL-INCR:JPGFL-INCR)
    INCR=INCR+1
  ENDIF
  IF (NGRG == 0) THEN
    YGRG => YGFLC(JPGFL-INCR:JPGFL-INCR)
    INCR=INCR+1
  ENDIF
  IF (NAERO == 0) THEN
    YAERO => YGFLC(JPGFL-INCR:JPGFL-INCR)
    INCR=INCR+1
  ENDIF

!      1.2  Grid-point GFL.

  IF(YQ_NL%LGP) THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YQ=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YQ ,CDNAME=YFAQ%CLNAME,KGRIB=NGRBQ,LDGP=.TRUE.,&
     & KREQIN=YQ_NL%NREQIN, &
     & PREFVALI=YQ_NL%REFVALI,LDREQOUT=YQ_NL%LREQOUT,LDERS=LLDERS,LD5=LL5,&
     & LDT1=LLT1,LDGPINGP=YQ_NL%LGPINGP, &
     & LDTRAJIO=YQ_NL%LTRAJIO,LDTHERMACT=.TRUE.,PR=RV,PRCP=RCPV)
  ENDIF
  IF(YL_NL%LGP) THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YL=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YL ,CDNAME=YFAL%CLNAME,KGRIB=NGRBCLWC, &
     & LDGP=.TRUE.,KREQIN=YL_NL%NREQIN, &
     & PREFVALI=YL_NL%REFVALI,LDREQOUT=YL_NL%LREQOUT,LDERS=LLDERS,LD5=LL5, &
     & LDT1=LLT1,LDTHERMACT=.TRUE.,PR=0.0_JPRB,PRCP=RCW)
  ENDIF
  IF(YI_NL%LGP) THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YI=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YI ,CDNAME=YFAI%CLNAME,KGRIB=NGRBCIWC,&
     & LDGP=.TRUE.,KREQIN=YI_NL%NREQIN, &
     & PREFVALI=YI_NL%REFVALI,LDREQOUT=YI_NL%LREQOUT,LDERS=LLDERS,LD5=LL5, &
     & LDT1=LLT1,LDTHERMACT=.TRUE.,PR=0.0_JPRB,PRCP=RCS)
  ENDIF
  IF(YS_NL%LGP) THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YS=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YS ,CDNAME=YFAS%CLNAME,KGRIB=NGRB149, &
     & LDGP=.TRUE.,KREQIN=YS_NL%NREQIN, &
     & PREFVALI=YS_NL%REFVALI,LDREQOUT=YS_NL%LREQOUT,LDERS=LLDERS,LD5=LL5, &
     & LDT1=LLT1,LDTHERMACT=.TRUE.,PR=0.0_JPRB,PRCP=RCS)
  ENDIF
  IF(YR_NL%LGP) THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YR=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YR ,CDNAME=YFAR%CLNAME,KGRIB=NGRB149,&
     & LDGP=.TRUE.,KREQIN=YR_NL%NREQIN, &
     & PREFVALI=YR_NL%REFVALI,LDREQOUT=YR_NL%LREQOUT,LDERS=LLDERS,LD5=LL5, &
     & LDT1=LLT1,LDTHERMACT=.TRUE.,PR=0.0_JPRB,PRCP=RCW)
  ENDIF
  IF(YG_NL%LGP) THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YG=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YG ,CDNAME=YFAG%CLNAME,KGRIB=NGRB149,&
     & LDGP=.TRUE.,KREQIN=YG_NL%NREQIN, &
     & PREFVALI=YG_NL%REFVALI,LDREQOUT=YG_NL%LREQOUT,LDERS=LLDERS,LD5=LL5, &
     & LDT1=LLT1,LDTHERMACT=.TRUE.,PR=0.0_JPRB,PRCP=RCS)
  ENDIF
  IF(YTKE_NL%LGP) THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YTKE=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YTKE ,CDNAME=YFATKE%CLNAME,KGRIB=NGRB149,&
     & LDGP=.TRUE.,KREQIN=YTKE_NL%NREQIN, &
     & PREFVALI=YTKE_NL%REFVALI,LDREQOUT=YTKE_NL%LREQOUT,LDERS=LLDERS,LD5=LL5,&
     & LDT1=LLT1)
  ENDIF
  IF(YA_NL%LGP)THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YA=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YA ,CDNAME=YFACLF%CLNAME,KGRIB=NGRBCC,&
     & LDGP=.TRUE.,KREQIN=YA_NL%NREQIN, &
     & PREFVALI=YA_NL%REFVALI,LDREQOUT=YA_NL%LREQOUT,LDERS=LLDERS,LD5=LL5,&
     & LDT1=LLT1)
  ENDIF
  IF(YO3_NL%LGP)THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YO3=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YO3,CDNAME=YFAO3%CLNAME,KGRIB=NGRBO3,&
     & LDGP=.TRUE.,KREQIN=YO3_NL%NREQIN, &
     & PREFVALI=YO3_NL%REFVALI,LDREQOUT=YO3_NL%LREQOUT,LDERS=LLDERS,LD5=LL5,&
     & LDT1=LLT1,LDGPINGP=YO3_NL%LGPINGP, &
     & LDTRAJIO=YO3_NL%LTRAJIO)
  ENDIF
  IF(YCPF_NL%LGP)THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YCPF=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YCPF,CDNAME=YFACPF%CLNAME,&
     & KGRIB=YCPF_NL%IGRBCODE,LDGP=.TRUE., &
     & KREQIN=YCPF_NL%NREQIN,PREFVALI= YCPF_NL%REFVALI,&
     & LDREQOUT=YCPF_NL%LREQOUT,LDERS=.FALSE.,LD5=LL5, &
     & LDT1=LLT1,LDGPINGP=.TRUE.)
  ENDIF
  IF(YSPF_NL%LGP)THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YSPF=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YSPF,CDNAME=YFASPF%CLNAME,&
     & KGRIB=YSPF_NL%IGRBCODE,LDGP=.TRUE., &
     & KREQIN=YSPF_NL%NREQIN, PREFVALI=YSPF_NL%REFVALI,&
     & LDREQOUT=YSPF_NL%LREQOUT,LDERS=.FALSE.,LD5=LL5, &
     & LDT1=LLT1,LDGPINGP=.TRUE.)
  ENDIF
  IF(YSRC_NL%LGP) THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YSRC=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YSRC ,CDNAME=YFASRC%CLNAME,KGRIB=NGRB149,&
     & LDGP=.TRUE.,KREQIN=YSRC_NL%NREQIN, &
     & PREFVALI=YSRC_NL%REFVALI,LDREQOUT=YSRC_NL%LREQOUT,LDERS=LLDERS,&
     & LD5=LL5,LDT1=LLT1)
  ENDIF
  IF(YCVGQ_NL%LGP) THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YCVGQ=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YCVGQ ,CDNAME=YFACVGQ%CLNAME,KGRIB=NGRB149,&
     & LDGP=.TRUE.,KREQIN=YCVGQ_NL%NREQIN, &
     & PREFVALI=YCVGQ_NL%REFVALI, LDREQOUT=YCVGQ_NL%LREQOUT,LDERS=LLDERS,&
     & LD5=LL5,LDT1=LLT1)
  ENDIF
  IF(YSDSAT_NL%LGP) THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YSDSAT=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YSDSAT,CDNAME=YFASDSAT%CLNAME,KGRIB=NGRB149,&
     & LDGP=.TRUE.,KREQIN=YSDSAT_NL%NREQIN, &
     & PREFVALI=YSDSAT_NL%REFVALI, LDREQOUT=YSDSAT_NL%LREQOUT,LDERS=LLDERS,&
     & LD5=LL5,LDT1=LLT1)
  ENDIF
  IF(YCVV_NL%LGP) THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YCVV=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YCVV,CDNAME=YFACVV%CLNAME,KGRIB=NGRB149,&
     & LDGP=.TRUE.,KREQIN=YCVV_NL%NREQIN, &
     & PREFVALI=YCVV_NL%REFVALI, LDREQOUT=YCVV_NL%LREQOUT,LDERS=LLDERS,&
     & LD5=LL5,LDT1=LLT1)
  ENDIF
  IF(YQVA_NL%LGP) THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YQVA=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YQVA,CDNAME=YFAQVA%CLNAME,&
     & KGRIB=YQVA_NL%IGRBCODE,LDGP=.TRUE., &
     & KREQIN=YQVA_NL%NREQIN, PREFVALI=YQVA_NL%REFVALI,&
     & LDREQOUT=YQVA_NL%LREQOUT,LDERS=.FALSE.,LD5=LL5, &
     & LDT1=LLT1,LDGPINGP=.TRUE.)
  ENDIF
  IF(YUOM_NL%LGP)THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YUOM=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YUOM,CDNAME=YFAUOM%CLNAME,&
     & KGRIB=YUOM_NL%IGRBCODE,LDGP=.TRUE., &
     & KREQIN=YUOM_NL%NREQIN,&
     & PREFVALI=YUOM_NL%REFVALI,LDREQOUT=YUOM_NL%LREQOUT,&
     & LDERS=.FALSE.,LD5=LL5,LDT1=LLT1,LDGPINGP=.TRUE.)
  ENDIF
  IF(YUAL_NL%LGP)THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YUAL=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YUAL,CDNAME=YFAUAL%CLNAME,&
     & KGRIB=YUAL_NL%IGRBCODE,LDGP=.TRUE., &
     & KREQIN=YUAL_NL%NREQIN,&
     & PREFVALI=YUAL_NL%REFVALI,LDREQOUT=YUAL_NL%LREQOUT,&
     & LDERS=.FALSE.,LD5=LL5,LDT1=LLT1,LDGPINGP=.TRUE.)
  ENDIF
  IF(YDOM_NL%LGP)THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YDOM=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YDOM,CDNAME=YFADOM%CLNAME,&
     & KGRIB=YDOM_NL%IGRBCODE,LDGP=.TRUE., &
     & KREQIN=YDOM_NL%NREQIN,&
     & PREFVALI=YDOM_NL%REFVALI,LDREQOUT=YDOM_NL%LREQOUT,&
     & LDERS=.FALSE.,LD5=LL5,LDT1=LLT1,LDGPINGP=.TRUE.)
  ENDIF
  IF(YDAL_NL%LGP)THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YDAL=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YDAL,CDNAME=YFADAL%CLNAME,&
     & KGRIB=YDAL_NL%IGRBCODE,LDGP=.TRUE., &
     & KREQIN=YDAL_NL%NREQIN,&
     & PREFVALI=YDAL_NL%REFVALI,LDREQOUT=YDAL_NL%LREQOUT,&
     & LDERS=.FALSE.,LD5=LL5,LDT1=LLT1,LDGPINGP=.TRUE.)
  ENDIF
  IF(YUEN_NL%LGP)THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YUEN=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YUEN,CDNAME=YFAUEN%CLNAME,&
     & KGRIB=YUEN_NL%IGRBCODE,LDGP=.TRUE., & 
     & KREQIN=YUEN_NL%NREQIN,&
     & PREFVALI=YUEN_NL%REFVALI,LDREQOUT=YUEN_NL%LREQOUT,&
     & LDERS=.FALSE.,LD5=LL5,LDT1=LLT1,LDGPINGP=.TRUE.)
  ENDIF
  IF(YUNEBH_NL%LGP)THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YUNEBH=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YUNEBH,CDNAME=YFAUNEBH%CLNAME,&
     & KGRIB=YUNEBH_NL%IGRBCODE,LDGP=.TRUE., &
     & KREQIN=YUNEBH_NL%NREQIN,&
     & PREFVALI=YUNEBH_NL%REFVALI,LDREQOUT=YUNEBH_NL%LREQOUT,&
     & LDERS=.FALSE.,LD5=LL5,LDT1=LLT1,LDGPINGP=.TRUE.)
  ENDIF

  ! Extra GFL variables
  ! - do a preliminary test to see if, when there are extra-GFL and when at
  !   least one of them is a grid-point one, there is no extra-GFL which is
  !   a spectral one (not allowed):
  !   in this case all the extra-GFL must be grid-point ones.
  IF (NGFL_EXT > 1) THEN
   IF(ANY(YEXT_NL(1:NGFL_EXT)%LGP)) THEN
    DO JGFL=1,NGFL_EXT
      IF (YEXT_NL(JGFL)%LSP) CALL ABOR1&
       & ('SUGFL:EXTRA GFL FIELDS HAVE TO BE ALL EITHER SPECTRAL OR GRIDPOINT')
    ENDDO
   ENDIF
  ENDIF
  ! - define the GFL components (all the extra-GFL are grid-point ones).
  DO JGFL=1,NGFL_EXT
    IF(YEXT_NL(JGFL)%LGP) THEN
      IF(JGFL == 1) THEN
        IGFLPTR=YGFL%NUMFLDS+1
        YEXT=>YGFLC(IGFLPTR:IGFLPTR+NGFL_EXT-1)
      ENDIF
      CALL DEFINE_GFL_COMP(YDGFLC=YEXT(JGFL),CDNAME=YEXT_NL(JGFL)%CNAME ,&
       & KGRIB=YEXT_NL(JGFL)%IGRBCODE,LDGP=.TRUE.,KREQIN=YEXT_NL(JGFL)%NREQIN,&
       & PREFVALI=YEXT_NL(JGFL)%REFVALI, LDREQOUT=YEXT_NL(JGFL)%LREQOUT ,&
       & LDERS=LLDERS, LD5=LL5, LDT1=LLT1,LDGPINGP=YEXT_NL(JGFL)%LGPINGP, &
       & LDTRAJIO=YEXT_NL(JGFL)%LTRAJIO)
    ENDIF
  ENDDO

  ! Forcings
  DO JGFL=1,NGFL_FORC
    IF(YFORC_NL(JGFL)%LGP) THEN
      IF(JGFL == 1) THEN
        IGFLPTR=YGFL%NUMFLDS+1
        YFORC=>YGFLC(IGFLPTR:IGFLPTR+NGFL_FORC-1)
      ENDIF
      CALL DEFINE_GFL_COMP(YDGFLC=YFORC(JGFL),CDNAME=YFORC_NL(JGFL)%CNAME ,&
       & KGRIB=YFORC_NL(JGFL)%IGRBCODE,LDGP=.TRUE.,KREQIN=YFORC_NL(JGFL)%NREQIN,&
       & PREFVALI=YFORC_NL(JGFL)%REFVALI, LDREQOUT=YFORC_NL(JGFL)%LREQOUT ,&
       & LDERS=LLDERS, LD5=LL5, LDT1=LLT1,LDGPINGP=YFORC_NL(JGFL)%LGPINGP, &
       & LDTRAJIO=YFORC_NL(JGFL)%LTRAJIO)
    ENDIF
  ENDDO

  ! Easy diagnostics
  DO JGFL=1,NGFL_EZDIAG
    IF(YEZDIAG_NL(JGFL)%LGP) THEN
      IF(JGFL == 1) THEN
        IGFLPTR=YGFL%NUMFLDS+1
        YEZDIAG=>YGFLC(IGFLPTR:IGFLPTR+NGFL_EZDIAG-1)
      ENDIF
      CALL DEFINE_GFL_COMP(YDGFLC=YEZDIAG(JGFL),CDNAME=YEZDIAG_NL(JGFL)%CNAME ,&
       & KGRIB=YEZDIAG_NL(JGFL)%IGRBCODE,LDGP=.TRUE.,KREQIN=YEZDIAG_NL(JGFL)%NREQIN,&
       & PREFVALI=YEZDIAG_NL(JGFL)%REFVALI, LDREQOUT=YEZDIAG_NL(JGFL)%LREQOUT ,&
       & LDERS=LLDERS, LD5=LL5, LDT1=LLT1,LDGPINGP=YEZDIAG_NL(JGFL)%LGPINGP, &
       & LDTRAJIO=YEZDIAG_NL(JGFL)%LTRAJIO)
    ENDIF
  ENDDO

!-- Greenhouse Gases
  DO JGFL=1,NGHG
    IF(YGHG_NL(JGFL)%LGP) THEN
      IF(JGFL == 1) THEN
        IGFLPTR=YGFL%NUMFLDS+1
        YGHG=>YGFLC(IGFLPTR:IGFLPTR+NGHG-1)
      ENDIF
      CALL DEFINE_GFL_COMP(YDGFLC=YGHG(JGFL),CDNAME=YGHG_NL(JGFL)%CNAME ,&
       & KGRIB=YGHG_NL(JGFL)%IGRBCODE, LDGP=.TRUE.,  KREQIN=YGHG_NL(JGFL)%NREQIN ,&
       & PREFVALI=YGHG_NL(JGFL)%REFVALI, LDREQOUT=YGHG_NL(JGFL)%LREQOUT ,&
       & LDERS=LLDERS, LD5=LL5, LDT1=LLT1,LDGPINGP=YGHG_NL(JGFL)%LGPINGP, &
       & LDTRAJIO=YGHG_NL(JGFL)%LTRAJIO)
    ENDIF
  ENDDO

!--  Diagnostic tracers
  DO JGFL=1,NTRAC
    IF(YTRAC_NL(JGFL)%LGP) THEN
      IF(JGFL == 1) THEN
        IGFLPTR=YGFL%NUMFLDS+1
        YTRAC=>YGFLC(IGFLPTR:IGFLPTR+NTRAC-1)
      ENDIF
      CALL DEFINE_GFL_COMP(YDGFLC=YTRAC(JGFL),CDNAME=YTRAC_NL(JGFL)%CNAME ,&
       & KGRIB=YTRAC_NL(JGFL)%IGRBCODE, LDGP=.TRUE.,  KREQIN=YTRAC_NL(JGFL)%NREQIN ,&
       & PREFVALI=YTRAC_NL(JGFL)%REFVALI, LDREQOUT=YTRAC_NL(JGFL)%LREQOUT ,&
       & LDERS=LLDERS, LD5=LL5, LDT1=LLT1,LDGPINGP=YTRAC_NL(JGFL)%LGPINGP, &
       & LDTRAJIO=YTRAC_NL(JGFL)%LTRAJIO)
    ENDIF
  ENDDO

!-- Reactive Gases
  DO JGFL=1,NGRG
    IF(YGRG_NL(JGFL)%LGP) THEN
      IF(JGFL == 1) THEN
        IGFLPTR=YGFL%NUMFLDS+1
        YGRG=>YGFLC(IGFLPTR:IGFLPTR+NGRG-1)
      ENDIF
      CALL DEFINE_GFL_COMP(YDGFLC=YGRG(JGFL),CDNAME=YGRG_NL(JGFL)%CNAME ,&
       & KGRIB=YGRG_NL(JGFL)%IGRBCODE, LDGP=.TRUE.,  KREQIN=YGRG_NL(JGFL)%NREQIN ,&
       & PREFVALI=YGRG_NL(JGFL)%REFVALI, LDREQOUT=YGRG_NL(JGFL)%LREQOUT ,&
       & LDERS=LLDERS, LD5=LL5, LDT1=LLT1,LDGPINGP=YGRG_NL(JGFL)%LGPINGP, &
       & LDTRAJIO=YGRG_NL(JGFL)%LTRAJIO)
    ENDIF
  ENDDO
    
!-- Aerosols
  DO JGFL=1,NAERO
    IF(YAERO_NL(JGFL)%LGP) THEN
      IF(JGFL == 1) THEN
        IGFLPTR=YGFL%NUMFLDS+1
        YAERO=>YGFLC(IGFLPTR:IGFLPTR+NAERO-1)
      ENDIF
      CALL DEFINE_GFL_COMP(YDGFLC=YAERO(JGFL),CDNAME=YAERO_NL(JGFL)%CNAME ,&
       & KGRIB=YAERO_NL(JGFL)%IGRBCODE, LDGP=.TRUE.,  KREQIN=YAERO_NL(JGFL)%NREQIN ,&
       & PREFVALI=YAERO_NL(JGFL)%REFVALI, LDREQOUT=YAERO_NL(JGFL)%LREQOUT ,&
       & LDERS=LLDERS, LD5=LL5, LDT1=LLT1,LDGPINGP=YAERO_NL(JGFL)%LGPINGP, &
       & LDTRAJIO=YAERO_NL(JGFL)%LTRAJIO)
    ENDIF
  ENDDO

!      1.3  Spectral GFL.
  
  IF(YQ_NL%LSP) THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YQ=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YQ ,CDNAME=YFAQ%CLNAME,KGRIB=NGRBQ,&
     & LDGP=.FALSE.,KREQIN=YQ_NL%NREQIN, & 
     & PREFVALI=YQ_NL%REFVALI, LDREQOUT=YQ_NL%LREQOUT, LDERS=LADER,LD5=LL5, &
     & LDT1=LLT1,LDTHERMACT=.TRUE.,PR=RV,PRCP=RCPV)
  ENDIF
  IF(YL_NL%LSP) THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YL=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YL ,CDNAME=YFAL%CLNAME,KGRIB=NGRBCLWC,&
     & LDGP=.FALSE.,KREQIN=YL_NL%NREQIN, &
     & PREFVALI=YL_NL%REFVALI, LDREQOUT=YL_NL%LREQOUT, LDERS=LADER,LD5=LL5, &
     & LDT1=LLT1,LDTHERMACT=.TRUE.,PR=0.0_JPRB,PRCP=RCW)
  ENDIF
  IF(YI_NL%LSP)THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YI=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YI ,CDNAME=YFAI%CLNAME,KGRIB=NGRBCIWC,&
     & LDGP=.FALSE.,KREQIN=YI_NL%NREQIN, &
     & PREFVALI=YI_NL%REFVALI, LDREQOUT=YI_NL%LREQOUT, LDERS=LADER,LD5=LL5, &
     & LDT1=LLT1,LDTHERMACT=.TRUE.,PR=0.0_JPRB,PRCP=RCS)
  ENDIF
  IF(YS_NL%LSP)THEN
    CALL ABOR1('SUGFL: spectral snow not coded ')
  ENDIF
  IF(YR_NL%LSP)THEN
    CALL ABOR1('SUGFL: spectral rain not coded ')
  ENDIF
  IF(YG_NL%LSP)THEN
    CALL ABOR1('SUGFL: spectral graupels not coded ')
  ENDIF
  IF(YTKE_NL%LSP)THEN
    CALL ABOR1('SUGFL: spectral TKE not coded ')
  ENDIF
  IF(YA_NL%LSP)THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YA=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YA ,CDNAME=YFACLF%CLNAME,KGRIB=NGRBCC,&
     & LDGP=.FALSE.,KREQIN=YA_NL%NREQIN, &
     & PREFVALI=YA_NL%REFVALI, LDREQOUT=YA_NL%LREQOUT, LDERS=LADER,LD5=LL5,&
     & LDT1=LLT1)
  ENDIF
  IF(YO3_NL%LSP)THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YO3=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YO3,CDNAME=YFAO3%CLNAME,KGRIB=NGRBO3,&
     & LDGP=.FALSE.,KREQIN=YO3_NL%NREQIN, & 
     & PREFVALI=YO3_NL%REFVALI, LDREQOUT=YO3_NL%LREQOUT, LDERS=LADER,LD5=LL5,&
     & LDT1=LLT1)
  ENDIF
  IF(YCPF_NL%LSP)THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YCPF=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YCPF,CDNAME=YFACPF%CLNAME,&
     & KGRIB=YCPF_NL%IGRBCODE, LDGP=.FALSE., &
     & KREQIN=YCPF_NL%NREQIN,PREFVALI=YCPF_NL%REFVALI,LDREQOUT=YCPF_NL%LREQOUT,&
     & LDERS=.FALSE.,LD5=.FALSE., &
     & LDT1=LLT1)
  ENDIF
  IF(YSPF_NL%LSP)THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YSPF=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YSPF,CDNAME=YFASPF%CLNAME,&
     & KGRIB=YSPF_NL%IGRBCODE,LDGP= .FALSE., &
     & KREQIN=YSPF_NL%NREQIN,PREFVALI=YSPF_NL%REFVALI,LDREQOUT=YSPF_NL%LREQOUT,&
     & LDERS=.FALSE.,LD5=.FALSE., &
     & LDT1=LLT1)
  ENDIF
  IF(YSRC_NL%LSP)THEN
    CALL ABOR1('SUGFL: spectral SRC not coded ')
  ENDIF
  IF(YCVGQ_NL%LSP)THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YCVGQ=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YCVGQ,CDNAME=YFACVGQ%CLNAME,&
     & KGRIB=YCVGQ_NL%IGRBCODE,LDGP= .FALSE., &
     & KREQIN=YCVGQ_NL%NREQIN,PREFVALI=YCVGQ_NL%REFVALI,&
     & LDREQOUT=YCVGQ_NL%LREQOUT,LDERS= .TRUE.,LD5=.FALSE., & 
     & LDT1=LLT1)
  ENDIF
  IF(YSDSAT_NL%LSP)THEN
    CALL ABOR1('SUGFL: spectral SDSAT not coded ')
  ENDIF
  IF(YCVV_NL%LSP)THEN
    CALL ABOR1('SUGFL: spectral CVV not coded ')
  ENDIF
  IF(YQVA_NL%LSP) THEN
    IGFLPTR=YGFL%NUMFLDS+1
    YQVA=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YQVA,CDNAME=YFAQVA%CLNAME,&
     & KGRIB=YQVA_NL%IGRBCODE, LDGP=.FALSE., &
     & KREQIN=YQVA_NL%NREQIN,PREFVALI=YQVA_NL%REFVALI,LDREQOUT=YQVA_NL%LREQOUT,&
     & LDERS=.FALSE.,LD5=.FALSE., &
     & LDT1=LLT1)
  ENDIF
  IF(YUOM_NL%LSP)THEN
    CALL ABOR1('SUGFL: spectral UOM not coded ')
    ! ----------------------------------------------------------------------
    ! what is below must be checked when UOM will be coded!
    IGFLPTR=YGFL%NUMFLDS+1
    YUOM=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YUOM,CDNAME=YFAUOM%CLNAME,&
     & KGRIB=YUOM_NL%IGRBCODE,LDGP=.FALSE., &
     & KREQIN=YUOM_NL%NREQIN,&
     & PREFVALI=YUOM_NL%REFVALI,LDREQOUT=YUOM_NL%LREQOUT,&
     & LDERS=.FALSE.,LD5=.FALSE.,LDT1=LLT1)
    ! ----------------------------------------------------------------------
  ENDIF
  IF(YUAL_NL%LSP)THEN
    CALL ABOR1('SUGFL: spectral UAL not coded ')
    ! ----------------------------------------------------------------------
    ! what is below must be checked when UAL will be coded!
    IGFLPTR=YGFL%NUMFLDS+1
    YUAL=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YUAL,CDNAME=YFAUAL%CLNAME,&
     & KGRIB=YUAL_NL%IGRBCODE,LDGP=.FALSE., &
     & KREQIN=YUAL_NL%NREQIN,&
     & PREFVALI=YUAL_NL%REFVALI,LDREQOUT=YUAL_NL%LREQOUT,&
     & LDERS=.FALSE.,LD5=.FALSE.,LDT1=LLT1)
    ! ----------------------------------------------------------------------
  ENDIF
  IF(YDOM_NL%LSP)THEN
    CALL ABOR1('SUGFL: spectral DOM not coded ')
    ! ----------------------------------------------------------------------
    ! what is below must be checked when DOM will be coded!
    IGFLPTR=YGFL%NUMFLDS+1
    YDOM=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YDOM,CDNAME=YFADOM%CLNAME,&
     & KGRIB=YDOM_NL%IGRBCODE,LDGP=.FALSE., &
     & KREQIN=YDOM_NL%NREQIN,&
     & PREFVALI=YDOM_NL%REFVALI,LDREQOUT=YDOM_NL%LREQOUT,&
     & LDERS=.FALSE.,LD5=.FALSE.,LDT1=LLT1)
    ! ----------------------------------------------------------------------
  ENDIF
  IF(YDAL_NL%LSP)THEN
    CALL ABOR1('SUGFL: spectral DAL not coded ')
    ! ----------------------------------------------------------------------
    ! what is below must be checked when DAL will be coded!
    IGFLPTR=YGFL%NUMFLDS+1
    YDAL=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YDAL,CDNAME=YFADAL%CLNAME,&
     & KGRIB=YDAL_NL%IGRBCODE,LDGP=.FALSE., & 
     & KREQIN=YDAL_NL%NREQIN,&
     & PREFVALI=YDAL_NL%REFVALI,LDREQOUT=YDOM_NL%LREQOUT,&
     & LDERS=.FALSE.,LD5=.FALSE.,LDT1=LLT1)
    ! ----------------------------------------------------------------------
  ENDIF
  IF(YUEN_NL%LSP)THEN
    CALL ABOR1('SUGFL: spectral UEN not coded ')
    ! ----------------------------------------------------------------------
    ! what is below must be checked when UEN will be coded!
    IGFLPTR=YGFL%NUMFLDS+1
    YUEN=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YUEN,CDNAME=YFAUEN%CLNAME,&
     & KGRIB=YUEN_NL%IGRBCODE,LDGP=.FALSE., &
     & KREQIN=YUEN_NL%NREQIN,&
     & PREFVALI=YUEN_NL%REFVALI,LDREQOUT=YUEN_NL%LREQOUT,&
     & LDERS=.FALSE.,LD5=.FALSE.,LDT1=LLT1)
    ! ----------------------------------------------------------------------
  ENDIF
  IF(YUNEBH_NL%LSP)THEN
    CALL ABOR1('SUGFL: spectral UNEBH not coded ')
    ! ----------------------------------------------------------------------
    ! what is below must be checked when UNEBH will be coded!
    IGFLPTR=YGFL%NUMFLDS+1
    YUNEBH=>YGFLC(IGFLPTR)
    CALL DEFINE_GFL_COMP(YDGFLC=YUNEBH,CDNAME=YFAUNEBH%CLNAME,&
     & KGRIB=YUNEBH_NL%IGRBCODE,LDGP=.FALSE., &
     & KREQIN=YUNEBH_NL%NREQIN,&
     & PREFVALI=YUNEBH_NL%REFVALI,LDREQOUT=YUNEBH_NL%LREQOUT,&
     & LDERS=.FALSE.,LD5=.FALSE.,LDT1=LLT1)
    ! ----------------------------------------------------------------------
  ENDIF

  ! Extra GFL variables (assumed to be all spectral in this piece of code)
  DO JGFL=1,NGFL_EXT
    IF(YEXT_NL(JGFL)%LSP) THEN
      IF(JGFL == 1) THEN
        IGFLPTR=YGFL%NUMFLDS+1
        YEXT=>YGFLC(IGFLPTR:IGFLPTR+NGFL_EXT-1)
      ENDIF
      CALL DEFINE_GFL_COMP(YDGFLC=YEXT(JGFL),CDNAME=YEXT_NL(JGFL)%CNAME ,&
       & KGRIB=YEXT_NL(JGFL)%IGRBCODE,LDGP=.FALSE.,KREQIN=YEXT_NL(JGFL)%NREQIN,&
       & PREFVALI=YEXT_NL(JGFL)%REFVALI, LDREQOUT=YEXT_NL(JGFL)%LREQOUT ,&
       & LDERS=LADER, LD5=LL5, LDT1=LLT1)
    ENDIF
  ENDDO

  ! Forcings
  DO JGFL=1,NGFL_FORC
    IF(YFORC_NL(JGFL)%LSP) THEN
      CALL ABOR1('SUGFL: FORCINGS HAVE TO BE GRIDPOINT FIELDS')
      ! ----------------------------------------------------------------------
      ! what is below must be checked when spectral forcings will be coded!
      IF(JGFL == 1) THEN
        IGFLPTR=YGFL%NUMFLDS+1
        YFORC=>YGFLC(IGFLPTR:IGFLPTR+NGFL_FORC-1)
      ENDIF
      CALL DEFINE_GFL_COMP(YDGFLC=YFORC(JGFL),CDNAME=YFORC_NL(JGFL)%CNAME,&
       & KGRIB=YFORC_NL(JGFL)%IGRBCODE,LDGP=.FALSE.,KREQIN=YFORC_NL(JGFL)%NREQIN,&
       & PREFVALI=YFORC_NL(JGFL)%REFVALI, LDREQOUT=YFORC_NL(JGFL)%LREQOUT, &
       & LDERS=.FALSE.,LD5=.FALSE.,LDT1=.FALSE.)
      ! ----------------------------------------------------------------------
    ENDIF
  ENDDO

  ! Easy diagnostics
  DO JGFL=1,NGFL_EZDIAG
    IF(YEZDIAG_NL(JGFL)%LSP) THEN
      CALL ABOR1('SUGFL: EZDIAG HAVE TO BE GRIDPOINT FIELDS')
      ! ----------------------------------------------------------------------
      ! what is below must be checked when spectral easy diag. will be coded!
      IF(JGFL == 1) THEN
        IGFLPTR=YGFL%NUMFLDS+1
        YEZDIAG=>YGFLC(IGFLPTR:IGFLPTR+NGFL_EZDIAG-1)
      ENDIF
      CALL DEFINE_GFL_COMP(YDGFLC=YEZDIAG(JGFL),CDNAME=YEZDIAG_NL(JGFL)%CNAME,&
       & KGRIB=YEZDIAG_NL(JGFL)%IGRBCODE,LDGP=.FALSE.,&
       & KREQIN=YEZDIAG_NL(JGFL)%NREQIN,&
       & PREFVALI=YEZDIAG_NL(JGFL)%REFVALI, LDREQOUT=YEZDIAG_NL(JGFL)%LREQOUT, &
       & LDERS=.FALSE.,LD5=.FALSE.,LDT1=.FALSE.)
      ! ----------------------------------------------------------------------
    ENDIF
  ENDDO

!Greenhouse Gases
  DO JGFL=1,NGHG
    IF(YGHG_NL(JGFL)%LSP) THEN
      IF(JGFL == 1) THEN
        IGFLPTR=YGFL%NUMFLDS+1
        YGHG=>YGFLC(IGFLPTR:IGFLPTR+NGHG-1)
      ENDIF
      CALL DEFINE_GFL_COMP(YDGFLC=YGHG(JGFL),CDNAME=YGHG_NL(JGFL)%CNAME ,&
       & KGRIB=YGHG_NL(JGFL)%IGRBCODE, LDGP=.FALSE.,  KREQIN=YGHG_NL(JGFL)%NREQIN ,&
       & PREFVALI=YGHG_NL(JGFL)%REFVALI, LDREQOUT=YGHG_NL(JGFL)%LREQOUT ,&
       & LDERS=LADER, LD5=LL5, LDT1=LLT1)
    ENDIF
  ENDDO

!Diagnostic tracers
  DO JGFL=1,NTRAC
    IF(YTRAC_NL(JGFL)%LSP) THEN
      IF(JGFL == 1) THEN
        IGFLPTR=YGFL%NUMFLDS+1
        YTRAC=>YGFLC(IGFLPTR:IGFLPTR+NTRAC-1)
      ENDIF
      CALL DEFINE_GFL_COMP(YDGFLC=YTRAC(JGFL),CDNAME=YTRAC_NL(JGFL)%CNAME ,&
       & KGRIB=YTRAC_NL(JGFL)%IGRBCODE, LDGP=.FALSE.,  KREQIN=YTRAC_NL(JGFL)%NREQIN ,&
       & PREFVALI=YTRAC_NL(JGFL)%REFVALI, LDREQOUT=YTRAC_NL(JGFL)%LREQOUT ,&
       & LDERS=LADER, LD5=LL5, LDT1=LLT1)
    ENDIF
  ENDDO

!Reactive Gases
  DO JGFL=1,NGRG
    IF(YGRG_NL(JGFL)%LSP) THEN
      IF(JGFL == 1) THEN
        IGFLPTR=YGFL%NUMFLDS+1
        YGRG=>YGFLC(IGFLPTR:IGFLPTR+NGRG-1)
      ENDIF
      CALL DEFINE_GFL_COMP(YDGFLC=YGRG(JGFL),CDNAME=YGRG_NL(JGFL)%CNAME ,&
       & KGRIB=YGRG_NL(JGFL)%IGRBCODE, LDGP=.FALSE.,  KREQIN=YGRG_NL(JGFL)%NREQIN ,&
       & PREFVALI=YGRG_NL(JGFL)%REFVALI, LDREQOUT=YGRG_NL(JGFL)%LREQOUT ,&
       & LDERS=LADER, LD5=LL5, LDT1=LLT1)
    ENDIF
  ENDDO

!Aerosols
  DO JGFL=1,NAERO
    IF(YAERO_NL(JGFL)%LSP) THEN
      IF(JGFL == 1) THEN
        IGFLPTR=YGFL%NUMFLDS+1
        YAERO=>YGFLC(IGFLPTR:IGFLPTR+NAERO-1)
      ENDIF
      CALL DEFINE_GFL_COMP(YDGFLC=YAERO(JGFL),CDNAME=YAERO_NL(JGFL)%CNAME ,&
       & KGRIB=YAERO_NL(JGFL)%IGRBCODE, LDGP=.FALSE.,  KREQIN=YAERO_NL(JGFL)%NREQIN ,&
       & PREFVALI=YAERO_NL(JGFL)%REFVALI, LDREQOUT=YAERO_NL(JGFL)%LREQOUT ,&
       & LDERS=LADER, LD5=LL5, LDT1=LLT1)
    ENDIF
  ENDDO

ELSE

!      2.   CASE LFPART2=T

  WRITE(NULOUT,*) ' SUGFL, LFPART2, YGFL%NUMFLDS=',YGFL%NUMFLDS
ENDIF

!-------------------------------------------------------------------------

IF (LHOOK) CALL DR_HOOK('SUGFL',1,ZHOOK_HANDLE)
END SUBROUTINE SUGFL
