!
! $Id$
!
MODULE ioipsl_getin_p_mod
! To use getin in a parallel context
!---------------------------------------------------------------------
USE ioipsl, ONLY: getin
USE strings_mod, ONLY: num2str, strStack, msg
USE mod_phys_lmdz_para, ONLY: is_master
USE mod_phys_lmdz_transfert_para, ONLY : bcast
!-
IMPLICIT NONE
!-
PRIVATE
PUBLIC :: getin_p
!-
INTERFACE getin_p

  MODULE PROCEDURE getinrs_p, getinr1d_p, getinr2d_p, &
 &                 getinis_p, getini1d_p, getini2d_p, &
 &                 getincs_p, 		              &
 &                 getinls_p, getinl1d_p, getinl2d_p
END INTERFACE
!-
CONTAINS


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!   Definition des getin -> bcast      !!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!! -- Les chaines de caracteres -- !!
  
SUBROUTINE getincs_p(VarIn, VarOut, VarDef, lDisp)
  IMPLICIT NONE
  CHARACTER(LEN=*),           INTENT(IN)    :: VarIn
  CHARACTER(LEN=*),           INTENT(INOUT) :: VarOut
  CHARACTER(LEN=*), OPTIONAL, INTENT(IN)    :: VarDef
  LOGICAL,          OPTIONAL, INTENT(IN)    :: lDisp
  LOGICAL :: lD
!$OMP BARRIER
  IF(is_master) THEN
     lD = .TRUE.; IF(PRESENT(lDisp)) lD = lDisp
     IF(PRESENT(VarDef)) VarOut = VarDef
     CALL getin(VarIn,VarOut)
     IF(lD) CALL msg(TRIM(VarIn)//' = '//TRIM(VarOut))
  END IF
  CALL bcast(VarOut)
END SUBROUTINE getincs_p

!! -- Les entiers -- !!
  
SUBROUTINE getinis_p(VarIn, VarOut, VarDef, lDisp)
  IMPLICIT NONE
  CHARACTER(LEN=*),  INTENT(IN)    :: VarIn
  INTEGER,           INTENT(INOUT) :: VarOut
  INTEGER, OPTIONAL, INTENT(IN)    :: VarDef
  LOGICAL, OPTIONAL, INTENT(IN)    :: lDisp
  LOGICAL :: lD
!$OMP BARRIER
  IF(is_master) THEN
     lD = .TRUE.; IF(PRESENT(lDisp)) lD = lDisp
     IF(PRESENT(VarDef)) VarOut = VarDef
     CALL getin(VarIn,VarOut)
     IF(lD) CALL msg(TRIM(VarIn)//' = '//TRIM(num2str(VarOut)))
  END IF
  CALL bcast(VarOut)
  END SUBROUTINE getinis_p

  SUBROUTINE getini1d_p(VarIn, VarOut, VarDef, lDisp)
  IMPLICIT NONE
  CHARACTER(LEN=*),  INTENT(IN)    :: VarIn
  INTEGER,           INTENT(INOUT) :: VarOut(:)
  INTEGER, OPTIONAL, INTENT(IN)    :: VarDef
  LOGICAL, OPTIONAL, INTENT(IN)    :: lDisp
  LOGICAL :: lD
!$OMP BARRIER
  IF(is_master) THEN
     lD = .TRUE.; IF(PRESENT(lDisp)) lD = lDisp
     IF(PRESENT(VarDef)) VarOut = VarDef
     CALL getin(VarIn,VarOut)
     IF(lD) CALL msg(TRIM(VarIn)//' = '//TRIM(strStack(num2str(VarOut))))
  END IF
  CALL bcast(VarOut)
  END SUBROUTINE getini1d_p

  SUBROUTINE getini2d_p(VarIn, VarOut, VarDef)
  IMPLICIT NONE
  CHARACTER(LEN=*),  INTENT(IN)    :: VarIn
  INTEGER,           INTENT(INOUT) :: VarOut(:,:)
  INTEGER, OPTIONAL, INTENT(IN)    :: VarDef
!$OMP BARRIER
  IF(is_master) THEN
     IF(PRESENT(VarDef)) VarOut = VarDef
     CALL getin(VarIn,VarOut)
  END IF
  CALL bcast(VarOut)
  END SUBROUTINE getini2d_p

!! -- Les flottants -- !!
  
  SUBROUTINE getinrs_p(VarIn, VarOut, VarDef, lDisp)
  IMPLICIT NONE
  CHARACTER(LEN=*),  INTENT(IN)    :: VarIn
  REAL,              INTENT(INOUT) :: VarOut
  REAL,    OPTIONAL, INTENT(IN)    :: VarDef
  LOGICAL, OPTIONAL, INTENT(IN)    :: lDisp
  LOGICAL :: lD
!$OMP BARRIER
  IF(is_master) THEN
     lD = .TRUE.; IF(PRESENT(lDisp)) lD = lDisp
     IF(PRESENT(VarDef)) VarOut = VarDef
     CALL getin(VarIn,VarOut)
     IF(lD) CALL msg(TRIM(VarIn)//' = '//TRIM(num2str(VarOut)))
  END IF
  CALL bcast(VarOut)
  END SUBROUTINE getinrs_p

  SUBROUTINE getinr1d_p(VarIn, VarOut, VarDef, lDisp)
  IMPLICIT NONE
  CHARACTER(LEN=*),  INTENT(IN)    :: VarIn
  REAL,              INTENT(INOUT) :: VarOut(:)
  REAL,    OPTIONAL, INTENT(IN)    :: VarDef
  LOGICAL, OPTIONAL, INTENT(IN)    :: lDisp
  LOGICAL :: lD
!$OMP BARRIER
  IF(is_master) THEN
     lD = .TRUE.; IF(PRESENT(lDisp)) lD = lDisp
     IF(PRESENT(VarDef)) VarOut = VarDef
     CALL getin(VarIn,VarOut)
     IF(lD) CALL msg(TRIM(VarIn)//' = '//TRIM(strStack(num2str(VarOut))))
  END IF
  CALL bcast(VarOut)
  END SUBROUTINE getinr1d_p

  SUBROUTINE getinr2d_p(VarIn, VarOut, VarDef)
  IMPLICIT NONE
  CHARACTER(LEN=*),  INTENT(IN)    :: VarIn
  REAL,              INTENT(INOUT) :: VarOut(:,:)
  REAL,    OPTIONAL, INTENT(IN)    :: VarDef
!$OMP BARRIER
  IF(is_master) THEN
     IF(PRESENT(VarDef)) VarOut = VarDef
     CALL getin(VarIn,VarOut)
  END IF
  CALL bcast(VarOut)
  END SUBROUTINE getinr2d_p

!! -- Les Booleens -- !!
  
  SUBROUTINE getinls_p(VarIn, VarOut, VarDef, lDisp)
  IMPLICIT NONE
  CHARACTER(LEN=*),  INTENT(IN)    :: VarIn
  LOGICAL,           INTENT(INOUT) :: VarOut
  LOGICAL, OPTIONAL, INTENT(IN)    :: VarDef
  LOGICAL, OPTIONAL, INTENT(IN)    :: lDisp
  LOGICAL :: lD
!$OMP BARRIER
  IF(is_master) THEN
     lD = .TRUE.; IF(PRESENT(lDisp)) lD = lDisp
     IF(PRESENT(VarDef)) VarOut = VarDef
     CALL getin(VarIn,VarOut)
     IF(lD) CALL msg(TRIM(VarIn)//' = '//TRIM(num2str(VarOut)))
  END IF
  CALL bcast(VarOut)
  END SUBROUTINE getinls_p

  SUBROUTINE getinl1d_p(VarIn, VarOut, VarDef, lDisp)
  IMPLICIT NONE
  CHARACTER(LEN=*),  INTENT(IN)    :: VarIn
  LOGICAL,           INTENT(INOUT) :: VarOut(:)
  LOGICAL, OPTIONAL, INTENT(IN)    :: VarDef
  LOGICAL, OPTIONAL, INTENT(IN)    :: lDisp
  LOGICAL :: lD
!$OMP BARRIER
  IF(is_master) THEN
     lD = .TRUE.; IF(PRESENT(lDisp)) lD = lDisp
     IF(PRESENT(VarDef)) VarOut = VarDef
     CALL getin(VarIn,VarOut)
     IF(lD) CALL msg(TRIM(VarIn)//' = '//TRIM(strStack(num2str(VarOut))))
  END IF
  CALL bcast(VarOut)
  END SUBROUTINE getinl1d_p

  SUBROUTINE getinl2d_p(VarIn, VarOut, VarDef)
  IMPLICIT NONE
  CHARACTER(LEN=*),  INTENT(IN)    :: VarIn
  LOGICAL,           INTENT(INOUT) :: VarOut(:,:)
  LOGICAL, OPTIONAL, INTENT(IN)    :: VarDef
!$OMP BARRIER
  IF(is_master) THEN
     IF(PRESENT(VarDef)) VarOut = VarDef
     CALL getin(VarIn,VarOut)
  END IF
  CALL bcast(VarOut)
  END SUBROUTINE getinl2d_p
!-
!-----------------------------
!-----------------------------
!-----------------------------

END MODULE ioipsl_getin_p_mod

