! Subroutine that calculates the effect of precipitation in scavenging
! BELOW the cloud, for large scale as well as convective precipitation
SUBROUTINE blcloud_scav(lminmax,qmin,qmax,pdtphys,prfl,psfl, &
        pmflxr,pmflxs,zdz,alpha_r,alpha_s,masse, &
        his_dhbclsc,his_dhbccon,tr_seri)

USE chem_mod_h
    USE dimphy
  USE indice_sol_mod
  USE infotrac_phy, ONLY: nbtr
!USE paramet_mod_h
USE yomcst_mod_h
IMPLICIT NONE





  !============================= INPUT ===================================
  REAL :: qmin,qmax
  REAL :: pdtphys  ! pas d'integration pour la physique (seconde)
   ! REAL prfl(klon,klev),   psfl(klon,klev)     !--large-scale
   ! REAL pmflxr(klon,klev), pmflxs(klon,klev)   !--convection
  REAL :: alpha_r(nbtr)!--coefficient d'impaction pour la pluie
  REAL :: alpha_s(nbtr)!--coefficient d'impaction pour la neige
  REAL :: masse(nbtr)
  LOGICAL :: lminmax
  REAL :: zdz(klon,klev)
  REAL :: prfl(klon,klev+1),   psfl(klon,klev+1)     !--large-scale  ! Titane
  REAL :: pmflxr(klon,klev+1), pmflxs(klon,klev+1)   !--convection   ! Titane
  !============================= OUTPUT ==================================
  REAL :: tr_seri(klon,klev,nbtr) ! traceur
  REAL :: aux_var1(klon,klev) ! traceur
  REAL :: aux_var2(klon,klev) ! traceur
  REAL :: his_dhbclsc(klon,nbtr), his_dhbccon(klon,nbtr)
  !========================= LOCAL VARIABLES =============================
  INTEGER :: it, k, i, j
  REAL :: d_tr(klon,klev,nbtr)

  EXTERNAL minmaxqfi, bcscav_spl

  DO it=1, nbtr
  !
  DO j=1,klev
  DO i=1,klon
    aux_var1(i,j)=tr_seri(i,j,it)
    aux_var2(i,j)=d_tr(i,j,it)
  ENDDO
  ENDDO
  !
  !nhl      CALL bcscav_spl(pdtphys,prfl,psfl,alpha_r(it),alpha_s(it),
  !nhl     .                tr_seri(1,1,it),d_tr(1,1,it))
  CALL bcscav_spl(pdtphys,prfl,psfl,alpha_r(it),alpha_s(it), &
        aux_var1,aux_var2)
  !
  DO j=1,klev
  DO i=1,klon
    tr_seri(i,j,it)=aux_var1(i,j)
    d_tr(i,j,it)=aux_var2(i,j)
  ENDDO
  ENDDO
  DO k = 1, klev
  DO i = 1, klon
     tr_seri(i,k,it) = tr_seri(i,k,it) + d_tr(i,k,it)
     his_dhbclsc(i,it)=his_dhbclsc(i,it)-d_tr(i,k,it)/RNAVO* &
           masse(it)*1.e3*1.e6*zdz(i,k)/pdtphys  !--mgS/m2/s

  ENDDO
  ENDDO
  !
  DO i=1,klon
  DO j=1,klev
    aux_var1(i,j)=tr_seri(i,j,it)
    aux_var2(i,j)=d_tr(i,j,it)
  ENDDO
  ENDDO
  !
  IF (lminmax) THEN
    CALL minmaxqfi(aux_var1,qmin,qmax,'depot humide bc lsc')
  !nhl      CALL minmaxqfi(tr_seri(1,1,it),qmin,qmax,'depot humide bc lsc')
  ENDIF
  !
  !-scheme for convective scavenging
  !
  !nhl      CALL bcscav_spl(pdtphys,pmflxr,pmflxs,alpha_r(it),alpha_s(it),
  !nhl     .                tr_seri(1,1,it),d_tr(1,1,it))


  CALL bcscav_spl(pdtphys,pmflxr,pmflxs,alpha_r(it),alpha_s(it), &
        aux_var1,aux_var2)


  !
  DO i=1,klon
  DO j=1,klev
    tr_seri(i,j,it)=aux_var1(i,j)
    d_tr(i,j,it)=aux_var2(i,j)
  ENDDO
  ENDDO
  !
  DO k = 1, klev
  DO i = 1, klon
     tr_seri(i,k,it) = tr_seri(i,k,it) + d_tr(i,k,it)
     his_dhbccon(i,it)=his_dhbccon(i,it)-d_tr(i,k,it)/RNAVO* &
           masse(it)*1.e3*1.e6*zdz(i,k)/pdtphys    !--mgS/m2/s
  ENDDO
  ENDDO
  !
  IF (lminmax) THEN
    DO j=1,klev
    DO i=1,klon
      aux_var1(i,j)=tr_seri(i,j,it)
    ENDDO
    ENDDO
    CALL minmaxqfi(aux_var1,qmin,qmax,'depot humide bc con')
  !nhl      CALL minmaxqfi(tr_seri(1,1,it),qmin,qmax,'depot humide bc con')
    DO j=1,klev
    DO i=1,klon
      tr_seri(i,j,it)=aux_var1(i,j)
    ENDDO
    ENDDO
  ENDIF
  !
  !
  ENDDO !--boucle sur it
  !
END SUBROUTINE blcloud_scav
