MODULE YOMPHY0

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!*
!     ------------------------------------------------------------------
!     CONSTANTES PHYSIQUES REGLABLES PROPRES A L'ATMOSPHERE :
!     ------------------------------------------------------------------
!       A0ML_AU : CONSTANTE POUR LE CALCUL DE LA LONGUEUR DE MELANGE.
!               : PARAMETER FOR THE INTERACTIVE MIXING LENGTH.
!       A0ML_AT : CONSTANTE POUR LE CALCUL DE LA LONGUEUR DE MELANGE.
!               : PARAMETER FOR THE INTERACTIVE MIXING LENGTH.
!       A0ML_BU : CONSTANTE POUR LE CALCUL DE LA LONGUEUR DE MELANGE.
!               : PARAMETER FOR THE INTERACTIVE MIXING LENGTH.
!       A0ML_BT : CONSTANTE POUR LE CALCUL DE LA LONGUEUR DE MELANGE.
!               : PARAMETER FOR THE INTERACTIVE MIXING LENGTH.
!       ACG     : CONSTANTE POUR LE CALCUL DU CONTRE-GRADIENT (ECT).
!               : PARAMETER FOR THE CONTER-GRADIENT.
!       ADISE   : CONSTANTE DE DISSIPATION PARTIE EXPLICITE (ECT).
!               : DISSIPATIVE PARAMETER FOR EXPLICIT PART.
!       ADISI   : CONSTANTE DE DISSIPATION PARTIE IMPLICITE (ECT).
!               : DISSIPATIVE PARAMETER FOR IMPLICIT PART.
!       AECLS3  : CONSTANTE POUR LE CALCUL DE ECT DANS LA CLS.
!               : PARAMETER FOR THE TKE CALCULATION IN TH PBL.
!       AECLS4  : CONSTANTE POUR LE CALCUL DE ECT DANS LA CLS.
!               : PARAMETER FOR THE TKE CALCULATION IN TH PBL.
!       AERCS1  : PREMIER COEFF. DE LA FONCTION DE LA COORD. SIGMA
!                 DEFINISSANT PDAER(KLEV).
!               : FIRST COEFFICIENT IN THE SIGMA COORD.'S FUNCTION
!                 DEFINING PDAER(KLEV).
!       AERCS3  : DEUXIEME COEFF. DE LA FONCTION DE LA COORD. SIGMA
!                 DEFINISSANT PDAER(KLEV).
!               : SECOND COEFFICIENT IN THE SIGMA COORD.'S FUNCTION
!                 DEFINING PDAER(KLEV).
!       AERCS5  : TROISIEME COEFF. DE LA FONCTION DE LA COORD. SIGMA
!                 DEFINISSANT PDAER(KLEV).
!               : THIRD COEFFICIENT IN THE SIGMA COORD.'S FUNCTION
!                 DEFINING PDAER(KLEV).
!       AHCLPV  : HAUTEUR DE LA COUCHE LIMITE POUR LONGUEUR DE MELANGE
!                 PBL HEIGHT FOR MIXING LENGTH PROFILE COMPUTATION
!       AKN     : CONSTANTE POUR LE CALCUL DES COEFF. D'ECHANGE (ECT)
!               : PARAMETER FOR THE EXCHANGE COEFF. CALCULATION.
!       ALD     : CONSTANTE POUR LE CALCUL DE LA LONGUEUR DE DISSIPATION (ECT)
!               : PARAMETER FOR THE DISSIPATION LENGTH CALCULATION.
!       ALMAV   : LONGUEUR DE MELANGE ASYMPTOTIQUE POUR LE VENT.
!               : MOMENTUM EXCHANGE ASYMPTOTIC MIXING LENGTH.
!       ALPHAE  : CONSTANTE POUR LE CALCUL DES COEFF. D'ECHANGE (ECT).
!               : PARAMETER FOR THE EXCHANGE COEFF. CALCULATION.
!       ALPHAT  : CONSTANTE POUR LE CALCUL DES COEFF. D'ECHANGE (ECT).
!               : PARAMETER FOR THE EXCHANGE COEFF. CALCULATION.
!       BEDIFV  : COEFFICIENT DE FORME POUR LE PROFIL DE DIF. VERTICALE.
!               : FORM COEFFICIENT FOR THE VERTICAL DIFFUSION PROFILE.
!       ECMNP   : EPAISSEUR CRITIQUE MINIMUM DU NUAGE PRECIPITANT.
!               : MINIMUM CRITICAL THICKNESS FOR PRECIPITATING CLOUDS.
!       ECTMIN  : PARAMETRE POUR ECT
!               : PARAMETER FOR TKE
!       EDB     : DETERMINE CD ET CH AU VOISINAGE DE LA NEUTRALITE.
!               : DETERMINES CD AND CH NEAR THE NEUTRAL REGIME.
!       EDC     : DETERMINE CD ET CH EN REGIME ASYMPTOTIQUE INSTABLE.
!               : DETERMINES CD AND CH IN THE ASYMPTOTIC UNST. REGIME.
!       EDD     : DETERMINE CD ET CH EN REGIME ASYMPTOTIQUE STABLE.
!               : DETERMINES CD AND CH IN THE ASYMPTOTIC STABLE REGIME.
!       EDK     : DETERMINE CD ET CH EN REGIME STABLE.
!               : DETERMINES CD AND CH IN THE STABLE REGIME.
!       EPS     : DISSIPATION PARTIE IMPLICITE PARTIE EXPLICITE (ECT).
!               : DISSIPATIVE PARAMETER
!       ETACUT  : PARAMETRE DU SCHEMA DE CONVECTION EN PENTE
!               : LIMITATION OF VORTICITY IN SHEAR-LINKED CONVECTION SCHEME
!       EVAP    : CONSTANTE D'EVAPORATION DES PRECIPITATIONS.
!               : PARAMETER FOR THE EVAPORATION OF PRECIPITATIONS.
!       FONT    : CONSTANTE DE FONTE DES PRECIPITATIONS.
!               : PARAMETER FOR THE MELTING OF PRECIPITATIONS.
!       GALP    : COEFFICIENT DE GALPERING (SCHEMA STAT. DE NUAGE).
!               : GALPERING COEFFICIENT (STATISTICAL CLOUD SCHEME).
!       GCISMIN : CISAILLEMENT MINIMAL UTILISE DANS LES CALCULS TURBULENTS.
!               : MINIMUM VALUE OF SHEAR USED IN TURBULENT COMPUTATIONS.
!       GCCSV   : CHOIX DU CRITERE DE STABILITE VERTICALE.
!               : VERTICAL STABILITY CRITERIA CHOICE.
!       GCOMOD  : EXPOSANT MODULATION DE LA CONVERGENCE D'HUMIDITE
!                 ET DE LA CONSOMMATION CAPE (CONVECTION PROFONDE)
!               : EXPONENT USED IN MODULATION OF MOISTURE CONVERGENCE
!                 AND CAPE CONSUMPTION (DEEP CONVECTION)
!       GCVALFA : COEFFICIENT RELIANT LA FLOTTABILITE NUAGEUSE
!                 AU TAUX D'ENTRAINEMENT.
!               : COEFFICIENT TO COMPUTE ENTRAINMENT RATE FROM CLOUD BUOYANCY.
!       GCVADS  : COEFFICIENT PERMETTANT DE PASSER D'UN CALCUL D'ADIABATIQUE
!                 SATUREE EN EQUIPRESSION A UN CALCUL EN EQUIGEOPOTENTIEL.
!               : COEFFICIENT TO SWITCH FROM AN EQUIPRESSURE ADIABAT COMPUTATION
!                 TO AN EQUIGEOPOTENTIAL ONE.
!       GCVBETA : FRACTION DE LA DIVERGENCE DU FLUX DE MASSE CONVECTIF
!                 ENTRANT DANS LE DETRAINEMENT.
!               : FRACTION OF CONVECTIVE MASS FLUX DIVERGENCY
!                 USED IN DETRAINMENT COMPUTATIONS.
!       GCVMLT  : COEFFICIENT D'HYSTERESIS DE FONTE/GEL DES PRECIPITATIONS CONVECTIVES.
!               : PARAMETER FOR THE HYSTERESIS OF CONVECTIVE PRECIPITATIONS MELTING/FREEZING.
!       GCVNU   : ENTRAINEMENT UTILISE POUR LE CALCUL DE LA FRACTION DE FLOTTABILITE.
!               : ENTRAINMENT RATE TO COMPUTE DILUTE PLUME BUOYANCY.
!       GCVPSI  : COEFFICIENT ADIMENSIONNEL FAISANT
!                 PASSER D'UNE PRISE EN COMPTE LOCALE DES FLUX TURBULENTS (SI 1)
!                 A UNE PRISE EN COMPTE INTEGRALE (SI 0).
!               : ADIMENSIONAL COEFFICIENT TO GO FROM
!                 A LOCAL USE OF TURBULENT FLUXES (IF 1)
!                 TO AN INTEGRAL ONE (IF 0).
!       GCVPSIE : PRESSURE EXPONENT IN THE MULTIPLICATION FACTOR OF PQSAT IN
!                 THE NORMALIZATION INTEGRAL OF TURBULENT FLUXES, UNDER LCVLIS
!                 SWITCH (IF 0 => PQSAT IS USED, IF 1 => PQSAT*P**GCVPSIE)
!       GDDEVA  : DOWNDRAFTS: FRACTION DES PRECIPITATIONS EVAPOREES.
!               : DOWNDRAFTS: PRECIPITATIONS EVAPORATION FRACTION.
!       GDDSDE  : DOWNDRAFTS: EXPOSANT CONTROLANT LES COURANTS DESCENDANTS EN SURFACE.
!               : DOWNDRAFTS: SURFACE DESCENDING FLOW EXPONENT.
!       GPBLHK0 : COEFFICIENT KHI0 UTILISE DANS LE CALCUL DE HAUTEUR DE CLA.
!               : KHI0 COEFFICIENT FOR USE IN THE PBL HEIGHT COMPUTATION.
!       GPBLHRA : RAPPORT KHI0/KHI1 UTILISE DANS LE CALCUL DE HAUTEUR DE CLA.
!               : RATIO KHI0/KHI1 FOR USE IN THE PBL HEIGHT COMPUTATION.
!       GRCVPP  : COEFFICIENT DE REDUCTION DE CVPP (ACCOEFK).
!               : REDUCTION COEFFICIENT FOR SHALLOW-CONVECTION (ACCOEFK).
!       GRCVPP  : COEFFICIENT DE REDUCTION DE CVPP (ACCOEFK).
!               : REDUCTION COEFFICIENT FOR SHALLOW-CONVECTION (ACCOEFK).
!       GWDAMP  : COEFFICIENT DE RESONANCE POUR LE G.W.D..
!               : RESONNANCE COEFFICIENT FOR THE G.W.D..
!       GWDBC   : INVERSE DE LA HAUTEUR CRITIQUE POUR LE G.W.D..
!               : INVERSE CRITICAL HEIGHT FOR THE G.W.D..
!       GWDCCO  : COEFFICIENT DU G.W.D CONVECTIF..
!               : COEFFICIENT FOR THE CONVECTIVE G.W.D..
!       GWDCD   : COEFFICIENT DE FROTTEMENT POUR LE G.W.D. DE SURFACE.
!               : DRAG COEFFICIENT FOR FOR THE LOW LEVEL G.W.D..
!       GWDLT   : COEFFICIENT DE SOULEVEMENT AU SOL POUR LE G.W.D..
!               : SURFACE LIFT COEFF. FOR THE G.W.D..
!       GWDSE   : COEFFICIENT DE FORME DU SOL POUR LE G.W.D..
!               : ASPECT RATIO TYPE COEFF. AT THE SURF. FOR THE G.W.D..
!       GWDPROF : COEFF DEFINISSANT LA FORME DE LA MONTAGNE POUR LE G.W.D..
!               : MOUNTAIN SHAPE COEFF. FOR THE G.W.D..
!       GWDVALI : COEFF DEFINISSANT L'ISOLEMENT DES VALLEES POUR LE G.W.D..
!               : VALLEYS DECOUPLING COEFF. FOR THE G.W.D..
!       HOBST   : MULTIPLICATEUR DE L'E. T. REL. POUR OBSTACLE G.W.D..
!               : FACTOR FOR THE ST. DEV. OF OROG. FOR G.W.D. "WALL".
!       HUCOE   : PREMIER COEFF. DE LA FONCTION DE LA COORD. SIGMA
!                 DEFINISSANT PHUC(KLEV).
!               : FIRST COEFFICIENT IN THE SIGMA COORD.'S FUNCTION
!                 DEFINING PHUC(KLEV).
!       HUCOE2  : COEFF. DE LA FONCTION DE LA COORD. SIGMA
!                 DEFINISSANT PHUC2(KLEV).
!               : COEFFICIENT IN THE SIGMA COORD.'S FUNCTION
!                 DEFINING PHUC2(KLEV).
!       HUTIL   : DEUXIEME COEFF. DE LA FONCTION DE LA COORD. SIGMA
!                 DEFINISSANT PHUC(KLEV).
!               : SECOND COEFFICIENT IN THE SIGMA COORD.'S FUNCTION
!                 DEFINING PHUC(KLEV).
!       HUTIL1  : DEUXIEME COEFF. DE LA FONCTION DE LA COORD. SIGMA
!                 DEFINISSANT NOUVEAU PHUC(KLEV).
!               : SECOND COEFFICIENT IN THE SIGMA COORD.'S FUNCTION
!                 DEFINING NEW PHUC(KLEV).
!       HUTIL2  : TROISIEME COEFF. DE LA FONCTION DE LA COORD. SIGMA
!                 DEFINISSANT NOUVEAU PHUC(KLEV).
!               : THIRD COEFFICIENT IN THE SIGMA COORD.'S FUNCTION
!                 DEFINING NEW PHUC(KLEV).
!       NPCLO1  : PREMIER EXPOST. DE LA FONCTION DE LA COORD. SIGMA
!                 DEFINISSANT PHUC(KLEV).
!               : FIRST EXPONENT IN THE SIGMA COORD.'S FUNCTION
!                 DEFINING PHUC(KLEV).
!       NPCLO2  : DEUXIEME EXPOST. DE LA FONCTION DE LA COORD. SIGMA
!                 DEFINISSANT PHUC(KLEV).
!               : SECOND EXPONENT IN THE SIGMA COORD.'S FUNCTION
!                 DEFINING PHUC(KLEV).
!       QSSC    : ECART D'ENERGIE STATIQUE SECHE AUTORISE LORS DU CALCUL
!                 DE LA NEBULOSITE PEU PROFONDE.
!                 DRY STATIC ENERGY THRESHOLD FOR SHALLOW CONVECTION COMPUTATIONS.
!       QSMIN   : RAPPORT DE MELANGE MINIMUM POUR LE SCHEMA DE NEBULOSITE STAT.
!               : MINIMUM MIXING RATIO FOR THE STATISTICAL CLOUD SCHEME
!       QSNEBC  : FACTEUR RELIANT L'EAU CONDENSEE A LA NEBULOSITE CONVECTIVE.
!               : DEFINING CONVECTIVE CLOUDINESS FROM CONDENSATED WATER.
!       QSNEBS  : FACTEUR RELIANT L'EAU CONDENSEE A LA NEBULOSITE STRATIFORME.
!               : DEFINING STRATIFORM CLOUDINESS FROM CONDENSATED WATER.
!       QSSUSC  : FACTEUR RELIANT L'EAU CONDENSEE AUX PRECIPITATIONS CONVECTIVES.
!               : DEFINING CONDENSATED WATER FROM CONVECTIVE PRECIPITATION.
!       QSSUSS  : FACTEUR RELIANT L'EAU CONDENSEE A LA SURSATURATION.
!               : DEFINING CONDENSATED WATER FROM SUPERSATURATION.
!       QSSUSV  : FACTEUR RELIANT L'EAU CONDENSEE A LA SURSATURATION.
!               : DEFINING CONDENSATED WATER FROM SUPERSATURATION.
!       QSUSXC  : QL+QI MAXIMUM A L'ECHELLE DU POINT DE GRILLE MODELE,
!                 PARTIE CONVECTION PROFONDE.
!               : MAXIMUM QL+QI AT THE GRID-POINT SCALE,
!                 DEEP CONVECTION PART.
!       QSUSXS  : QL+QI MAXIMUM A L'ECHELLE DU POINT DE GRILLE MODELE,
!                 PARTIES RESOLUE ET DE CONVECTION PEU PROFONDE.
!               : MAXIMUM QL+QI AT THE GRID-POINT SCALE, 
!                 RESOLVED AND SHALLOW CONVECTION PART.
!       RPHI0   : REGLAGE DE REFROIDISSEMENT DANS L'INVERSION POUR LE
!                 CALCUL DE STRATUS BAS
!                 TUNING OF THE COOLING INSIDE AN INVERSION FOR COMPUTATION
!                 OF LOW-LEVEL STRATUS CLOUDINESS
!       RPHIR   : REGLAGE DE LA PROFONDEUR D'INVERSION THERMIQUE POUR LE
!                 CALCUL DE STRATUS
!                 TUNING OF THE INVERSION THICKNESS FOR COMPUTATION
!                 OF LOW-LEVEL STRATUS CLOUDINESS
!               : XU ET RANDALL CLOUDINESS COMPUTATION (ACNEBXR).
!       QXRAL   : CALCUL DE LA NEBULOSITE XU ET RANDALL (ACNEBXR).
!               : XU ET RANDALL CLOUDINESS COMPUTATION (ACNEBXR).
!       QXRDEL  : CALCUL DE LA NEBULOSITE XU ET RANDALL (ACNEBXR).
!               : XU ET RANDALL CLOUDINESS COMPUTATION (ACNEBXR).
!       QXRHX   : CALCUL DE LA NEBULOSITE XU ET RANDALL (ACNEBXR).
!               : XU ET RANDALL CLOUDINESS COMPUTATION (ACNEBXR).
!       QXRR    : CALCUL DE LA NEBULOSITE XU ET RANDALL (ACNEBXR).
!               : XU ET RANDALL CLOUDINESS COMPUTATION (ACNEBXR).
!       QXRTGH  : CALCUL DE LA NEBULOSITE XU ET RANDALL (ACNEBXR).
!               : XU ET RANDALL CLOUDINESS COMPUTATION (ACNEBXR).
!       TENTRX  : TAUX D'ENTRAINEMENT MAXIMUM DU NUAGE CONVECTIF.
!               : MAXIMUM CONVECTIVE UPDRAFT'S ENTRAINMENT RATE.
!       RCIN    : MODULATION DANS LE CALCUL DU PROFIL NUAGEUX CONVECTIF
!               : MODULATION IN THE CONVECTIVE CLOUD PROFILE COMPUTATION
!       RCVEVAP : FACTEUR DE MODULATION DE L'EVAPORATION CONVECTIVE SOUS-NUAGEUSE
!               : MODULATION FACTOR FOR CONVECTIVE EVAPORATION
!       RDTFAC  : FACTEUR MULTIPLICATIF DE "RDT" DANS LA FONCTION "FONICE".
!               : MODULATION FACTOR OF "RDT" IN "FONICE" FUNCTION.
!       REVGSL  : RAPPORT DES VITESSES D'EVAP. DES PRECIP. "GLACE/LIQ.".
!               : RATIO OF THE SPEED OF EVAP. OF PRECIP. "ICE/WATER".
!       RICRLM  : NOMBRE DE RICHARDSON CRITIQUE POUR LONGUEUR DE MELANGE.
!               : CRITICAL RICHARDSON NUMBER FOR MIXING LENGTH.
!       RRGAMMA : EXPOSANT DANS LE CALCUL DE "RAFALE HUMIDE".
!                 EXPONENT IN "MOIST GUSTINESS" COMPUTATION.
!       RRSCALE : TAUX DE PRECIPITATION CARACTERISTIQUE DANS LE CALCUL DE "RAFALE HUMIDE".
!                 SCALING RAINFALL RATE IN "MOIST GUSTINESS" COMPUTATION.
!       RTCAPE  : TEMPS CARACTERISTIQUE POUR "CONSOMMER" LA CAPE.
!                 CHARACTERISTICS TIME TO DECREASE THE CAPE CLOSURE.
!       SCO     : SEUIL EN DESSOUS DUQUEL LES PRECIPITATIONS CONVECTIVES
!                 NE SONT PAS PRISES EN COMPTE (SCHEMA STATISTIQUE DE NUAGES)
!               : THRESHOLD FOR THE CONVECTIVE PRECIPITATION (STATISTICAL
!                 CLOUD SCHEME)
!       SENSL   : COEFFICIENT DE SENSIBILITE DE LA LONGUEUR DE MELANGE.
!               : SENSITIVITY TO MIXING LENGTH (STAT. CLOUD SCHEME).
!       SNNBCO  : VALEUR MINIMALE DE LA NEBULOSITE CONVECTIVE.
!               : MINIMUM VALUE OF CONVECTIVE CLOUDINESS.
!       SPNBCO  : PENTE "NEBULOSITE CONV./PRECIPITATION CONV.".
!               : SLOPE "CONV. CLOUDINESS/CONV. PRECIPITATION".
!       SXNBCO  : VALEUR MAXIMALE DE LA NEBULOSITE CONVECTIVE
!               : MAXIMUM VALUE OF CONVECTIVE CLOUDINESS.
!       TCA     : CONSTANTE D'ACCRETION.
!               : ACCRETION CONSTANT (STAT. CLOUD SCHEME).
!       TCT     : AUTOCONV. DES GOUTTELETTES NUAGEUSES EN PRECIP..
!               : DROPLET SELFCONVERSION (STAT. CLOUD SCHEME).
!       TCW     : CONSTANTE DE LIMITATION DE LA CONVERSION DE L'EAU
!                 LIQUIDE NUAGEUSE EN PRECIPITATIONS.
!               : LIMITATION OF LIQUID WATER CONVERSION (STAT. CLOUD
!                 SCHEME).
!       TENTR   : TAUX D'ENTRAINEMENT DU NUAGE CONVECTIF.
!               : CONVECTIVE UPDRAFT'S ENTRAINMENT RATE.
!       TENTRX  : TAUX D'ENTRAINEMENT MAXIMUM DU NUAGE CONVECTIF.
!               : MAXIMUM CONVECTIVE UPDRAFT'S ENTRAINMENT RATE.
!       TDDGP   : Parametrisation grad p horizontal dans le downdraught
!                 (Kershaw & Gregory)
!                 Downdraught Horizontal Grad p  effect coefficient
!       TUDGP   : Parametrisation du grad p horizontal dans l'updraught
!                 (Kershaw & Gregory)
!                 Updraught Horizontal Grad p  effect coefficient
!       TURB    : TURBULENCE RESIDUELLE.
!               : RESIDUAL TURBULENCE (STAT. CLOUD SCHEME).
!       TVF     : VITESSE DE PRECIPITATION DE L'EAU SOLIDE NUAGEUSE.
!               : SOLID PRECIPITATION SPEED (STAT. CLOUD SCHEME).
!       TYM(5)  : TABLEAU DES COEFFICIENTS DU MODELE DE NIVEAU 2.5
!                 DE YAMADA ET MELLOR (SCHEMA STATISTIQUE DE NUAGES).
!               : YAMADA AND MELLOR COEFFICIENTS FOR THE LEVEL 2.5
!                 SCHEME (STAT. CLOUD SCHEME).
!       UHDIFV  : INVERSE DE L'ECHELLE DE DECROISSANCE VERTIC. DE ALMAV.
!               : INVERSE SCALE HEIGHT FOR THE DECREASE OF ALMAV.
!       UNTIER  : CONSTANTE POUR LE CALCUL DE ECT DANS LA CLS.
!               : PARAMETER FOR THE TKE CALCULATION IN TH PBL.
!       USDMLT  : INVERSE DE L'ECHELLE DE FUSION DES PRECIP. CONVEC..
!               : INVERSE SCALE OF THE MELTING DEPTH OF CONVEC. PRECIP..
!       USUPRC  : INVERSE DES PRECIPITATIONS CRITIQUES POUR L'INTERCETION
!               : INVERSE CRITICAL RAINFALL FOR VEGETATION INTERCEPTION
!       USURIC  : INVERSE DU NOMBRE DE RICHARDSON CRITIQUE
!               : INVERSE CRITICAL RICHARDSON NUMBER
!       USURID  : INVERSE DU NOMBRE DE RICHARDSON DE TRANSITION POUR LE CALCUL DE L'ORDRE DE CONVERGENCE
!                 DU NOMBRE DE RICHARDSON VERS LE NOMBRE DE RICHARDSON CRITIQUE.
!               : INVERSE TRANSITION RICHARDSON NUMBER TO COMPUTE THE CONVERGENCE ORDER
!                 OF THE RICHARDSON NUMBER TO THE CRITICAL RICHARDSON NUMBER.
!       USURICE : EXPOSANT DE L'ALTITUDE INTERVENANT DANS LE CALCUL
!                 DU NOMBRE DE RICHARDSON CRITIQUE.
!               : HEIGHT EXPONENT IN RICHARDSON NUMBER COMPUTATION.
!       USURICL : COEFFICIENT MULTIPLICATEUR INTERVENANT DANS LE CALCUL
!                 DU NOMBRE DE RICHARDSON CRITIQUE EN FONCTION DE L'ALTITUDE.
!               : COEFFICIENT RELATING RICHARDSON NUMBER COMPUTATION TO HEIGHT.
!       USURID  : INVERSE DU NOMBRE DE RICHARDSON DE TRANSITION POUR LE CALCUL DE L'ORDRE DE CONVERGENCE
!                 DU NOMBRE DE RICHARDSON VERS LE NOMBRE DE RICHARDSON CRITIQUE.
!               : INVERSE TRANSITION RICHARDSON NUMBER TO COMPUTE THE CONVERGENCE ORDER
!                 OF THE RICHARDSON NUMBER TO THE CRITICAL RICHARDSON NUMBER.
!       USURIDE : EXPOSANT DANS LE CALCUL DU NOMBRE DE RICHARDSON CRITIQUE LOCAL.
!                 EXPONENT IN THE COMPUTATION OF THE LOCAL CRITICAL RICHARDSON NUMBER.
!       UTILGUST: VITESSE CARACTERISTIQUE DANS LE CALCUL DE "RAFALE HUMIDE".
!                 CHARACTERISTIC SPEED IN "MOIST GUSTINESS" COMPUTATION.
!       VCHRNK  : CONSTANTE DE CHARNOCK.
!               : CHARNOCK'S CONSTANT.
!       VKARMN  : CONSTANTE DE KARMAN.
!               : KARMAN'S CONSTANT.
!       VZ0CM   : LONGUEUR DE RUGOSITE (NEUTRE) MINIMALE SUR MER.
!               : (NEUTRAL) MINIMUM ROUGHNESS LENGTH OVER THE OCEAN.
!       VZIUSTAR0 : VITESSE DE RUGOSITE INVERSE DE NORMALISATION.
!                 : SCALING INVERSE ROUGHNESS VELOCITY.
!       XBLM    : COEFFICIENT POUR LONGUEUR DE MELANGE.
!               : COEFFICIENT FOR MIXING LENGTH.
!       XKLM    : COEFFICIENT POUR LONGUEUR DE MELANGE (0<XKLM<1).
!               : COEFFICIENT FOR MIXING LENGTH (0<XKLM<1).
!       XMAXLM  : HAUTEUR MAXI DE LA CLP (POUR LONGUEUR DE MELANGE).
!               : MAX HEIGHT OF THE PBL (FOR MIXING LENGTH).
!       XMINLM  : HAUTEUR MINI DE LA CLP (POUR LONGUEUR DE MELANGE).
!               : MIN HEIGHT OF THE PBL (FOR MIXING LENGTH).
!       XNBMAX  : NEBULOSITE MAXIMUM PAR COUCHE.
!               : MAXIMUM CLOUDINESS IN A LAYER.
!       XWSALM  : CONSTANTE 1 DU SCHEMA TROEN-MAHRT (POUR LONGUEUR DE MELANGE).
!               : CONSTANT 1 FOR TROEN-MAHRT SCHEME (FOR MIXING LENGTH).
!       XWSBLM  : CONSTANTE 2 DU SCHEMA TROEN-MAHRT (POUR LONGUEUR DE MELANGE).
!               : CONSTANT 2 FOR TROEN-MAHRT SCHEME (FOR MIXING LENGTH).

!*   Variables pour la microphysique dite de Lopez 
! ------------------------------------------------------------------
!    RAUTEFR  : EFFICIENCY FOR AUTOCONVERSION OF WATER->RAIN. 
!    RAUTEFS  : EFFICIENCY FOR AUTOCONVERSION OF ICE->SNOW. 
!    RAUTSBET : "BETA" EFFICIENCY PARAMETER FOR AUTOCONV ICE->SNOW.
!    RHEVAP   : MODIFICATION OF RELATIVE HUMIDITY IN EVAPORATION 
!               FORMULATION OF LOPEZ MICROPHYSICS.
!    RNINTR   : INTERCEPT PARAMETER FOR RAIN.
!    RNINTS   : INTERCEPT PARAMETER FOR ICE.
!    RQLCR    : CRITICAL LIQUID WATER CONTENT FOR AUTOCONVERSION OF
!               STRATIFORM CLOUD WATER.
!    RQICRMAX : MAXIMUM CRITICAL ICE CONTENT FOR AUTOCONVERSION OF
!               STRATIFORM ICE.
!    RQICRMIN : MINIMUM CRITICAL ICE CONTENT FOR AUTOCONVERSION OF
!               STRATIFORM ICE.
!    RQLCV    : CRITICAL LIQUID WATER CONTENT FOR AUTOCONVERSION OF
!               CONVECTIVE CLOUD WATER.
!    RQICVMAX : MAXIMUM CRITICAL ICE CONTENT FOR AUTOCONVERSION OF
!               CONVECTIVE CLOUD ICE.
!    RQICVMIN : MINIMUM CRITICAL ICE CONTENT FOR AUTOCONVERSION OF
!               CONVECTIVE CLOUD ICE.
!    RQICRT1  : TUNING COEFF FOR AUTOCONVERSION OF STRATIFORM ICE.
!    RQICRT2  : TUNING COEFF FOR AUTOCONVERSION OF STRATIFORM ICE.
!    RQICRSN  : MULTIPLICATIVE FACTOR OF CRITICAL ICE CONTENT FOR
!               AUTOCONVERSION OF STRATIFORM ICE OVER SNOW AND SEA ICE.
!    RQCRNS   : TUNING COEFF FOR AUTOCONVERSION NEAR THE SURFACE.
!    RACCEF   : ACCRETION EFFICIENCY.
!    RAGGEF   : AGGREGATION EFFICIENCY.
!    RRIMEF   : RIMING AND AGGREGATION EFFICIENCY.
!    RHCRIT1  : CRITICAL RELATIVE HUMIDITY FOR SMITH SCHEME (UPPER LEVELS).
!    RHCRIT2  : CRITICAL RELATIVE HUMIDITY FOR SMITH SCHEME (SURFACE).
!    RETAMIN  : MODEL ETA LEVEL WHERE CRITICAL RELATIVE HUMIDITY IS MINIMUM.
!    RFACNSM  : MULTIPLICATVE FACTOR OF SMITH CLOUDINESS COMPUTATION.
!    TFVR     : VITESSE DE CHUTE DES PRECIPITATIONS LIQUIDES.
!    TFVS     : VITESSE DE CHUTE DES PRECIPITATIONS SOLIDES.
!    GRHCMOD  : MODULATION IN CRITICAL RELATIVE HUMIDITY COMPUTATION.
!
! Pseudo prognostic TKE scheme
!    NUPTKE   : TUNABLE VALUE FOR PSEUDO TKE SCHEME FOLLOWING
!               REDELSBERGER, MAHE & CARLOTTI (2001) EQUAL TO
!               ( C_k * C_{epsilon} )^{1/4}
!    GAMTKE   : GAMMA FUNCTION DEFINING THE PROPORTION BETWEEN
!               K_n AND K_m TO COMPUTE K_E
!     RCOLL   : COLLECTION PARAMETER
!     RFALLL  : SPEED OF FALL (ACPLUIE_PROG)
! Prognostic convection scheme
!     TUDBU   : UPDRAUGHT VIRTUAL MASS PARAMETER
!     TUDFR   : UPDRAUGHT DISSIPATION COEFFICIENT
!     TDDBU   : DOWNDRAUGHT VIRTUAL MASS PARAMETER
!     TDDFR   : DOWNDRAUGHT DISSIPATION COEFFICIENT
!     GCVACHI : Activity History, absolute minimum draught advected
!               velocity to declare continued activity whichever be ZKUO
!     GCVBEE  : IMPACT OF ACCELERATION on ENTRAINMENT
!     GCVEEX  : EXPONENT FOR impact of accel on entr
!   GCVADMW 0 : Advect  ABSOLUTE UD VELOCITY*DT
!           1 : ADVECT DEPARTURE FROM PVERVEL*DT

!   GCVALMX   : MAXIMUM ACCEPTABLE VALUE FOR TOTAL MESH FRACTION
!
!              Ascent properties
!      ECMNPI : ECMNP for ice, the original ECMNP being kept for liquid.
!      GFRIC  : INVERSE OF CHARACTERISTIC TIME for ICE CONDENSATION in ud.
!
!              Squeezing:
!   GCVSQDN   : threshold value of sigma_d*q_cd*dp
!   GCVSQDR   : fraction of the max to consider for squeezing
!   GCVSQDCX  : maximum acceptable compression (<1)
!
!              Downdraught:
!   GDDWPF    : Influence of rain fall velocity on downdraught
!   GDDEVF    : for acmodo, cfr GDDEVA in accvimp
!   GDDBETA   : DOWNDRAUGHT EXPLICIT DETRAINMENT COEFFICIENT
!   TENTRD    : DOWNDRAUGHT ENTRAINMENT RATE (S^2/M^2)
!
!              Intensive Precipitation:
!   GRRMINA   : MINIMUM REALISTIC PRECIPITATING MESH FRACTION
!   GRRINTE   : MAXIMUM VALUE OF THE PRECIPITATION INTENSIFICATION FACTOR
! ------------------------------------------------------------------

REAL(KIND=JPRB) :: TYM(5)
INTEGER(KIND=JPIM) :: NPCLO1
INTEGER(KIND=JPIM) :: NPCLO2
REAL(KIND=JPRB) :: A0ML_AU
REAL(KIND=JPRB) :: A0ML_AT
REAL(KIND=JPRB) :: A0ML_BU
REAL(KIND=JPRB) :: A0ML_BT
REAL(KIND=JPRB) :: AERCS1
REAL(KIND=JPRB) :: AERCS3
REAL(KIND=JPRB) :: AERCS5
REAL(KIND=JPRB) :: ALMAV
REAL(KIND=JPRB) :: BEDIFV
REAL(KIND=JPRB) :: ECMNP
REAL(KIND=JPRB) :: EDB
REAL(KIND=JPRB) :: EDC
REAL(KIND=JPRB) :: EDD
REAL(KIND=JPRB) :: EVAP
REAL(KIND=JPRB) :: FONT
REAL(KIND=JPRB) :: GALP
REAL(KIND=JPRB) :: GCISMIN
REAL(KIND=JPRB) :: GCCSV
REAL(KIND=JPRB) :: GCOMOD
REAL(KIND=JPRB) :: GCVADS
REAL(KIND=JPRB) :: GCVBETA
REAL(KIND=JPRB) :: GDDEVA
REAL(KIND=JPRB) :: GDDSDE
REAL(KIND=JPRB) :: GRCVPP
REAL(KIND=JPRB) :: GWDAMP
REAL(KIND=JPRB) :: GWDBC
REAL(KIND=JPRB) :: GWDCCO
REAL(KIND=JPRB) :: GWDCD
REAL(KIND=JPRB) :: GWDLT
REAL(KIND=JPRB) :: GWDSE
REAL(KIND=JPRB) :: GWDPROF
REAL(KIND=JPRB) :: GWDVALI
REAL(KIND=JPRB) :: HOBST
REAL(KIND=JPRB) :: HUCOE
REAL(KIND=JPRB) :: HUCOE2
REAL(KIND=JPRB) :: HUTIL
REAL(KIND=JPRB) :: HUTIL1
REAL(KIND=JPRB) :: HUTIL2
REAL(KIND=JPRB) :: QSMIN
REAL(KIND=JPRB) :: QSNEBC
REAL(KIND=JPRB) :: QSNEBS
REAL(KIND=JPRB) :: QSSUSC
REAL(KIND=JPRB) :: QSSUSS
REAL(KIND=JPRB) :: QSSUSV
REAL(KIND=JPRB) :: QSUSXC
REAL(KIND=JPRB) :: QSUSXS
REAL(KIND=JPRB) :: RPHI0 
REAL(KIND=JPRB) :: RPHIR 
REAL(KIND=JPRB) :: QXRAL
REAL(KIND=JPRB) :: QXRDEL
REAL(KIND=JPRB) :: QXRHX
REAL(KIND=JPRB) :: QXRR
REAL(KIND=JPRB) :: QXRTGH
REAL(KIND=JPRB) :: RCIN
REAL(KIND=JPRB) :: RCVEVAP
REAL(KIND=JPRB) :: RDTFAC
REAL(KIND=JPRB) :: REVGSL
REAL(KIND=JPRB) :: RTCAPE
REAL(KIND=JPRB) :: SCO
REAL(KIND=JPRB) :: SENSL
REAL(KIND=JPRB) :: SNNBCO
REAL(KIND=JPRB) :: SPNBCO
REAL(KIND=JPRB) :: SXNBCO
REAL(KIND=JPRB) :: TCA
REAL(KIND=JPRB) :: TCT
REAL(KIND=JPRB) :: TCW
REAL(KIND=JPRB) :: TENTR
REAL(KIND=JPRB) :: TENTRX
REAL(KIND=JPRB) :: TUDGP
REAL(KIND=JPRB) :: TDDGP
REAL(KIND=JPRB) :: TURB
REAL(KIND=JPRB) :: TVF
REAL(KIND=JPRB) :: UHDIFV
REAL(KIND=JPRB) :: USDMLT
REAL(KIND=JPRB) :: USUPRC
REAL(KIND=JPRB) :: USURIC
REAL(KIND=JPRB) :: VCHRNK
REAL(KIND=JPRB) :: VKARMN
REAL(KIND=JPRB) :: VZ0CM
REAL(KIND=JPRB) :: VZIUSTAR0
REAL(KIND=JPRB) :: XNBMAX
REAL(KIND=JPRB) :: AECLS3
REAL(KIND=JPRB) :: AECLS4
REAL(KIND=JPRB) :: ACG
REAL(KIND=JPRB) :: ALD
REAL(KIND=JPRB) :: AKN
REAL(KIND=JPRB) :: ALPHAT
REAL(KIND=JPRB) :: ALPHAE
REAL(KIND=JPRB) :: EPS
REAL(KIND=JPRB) :: ETACUT
REAL(KIND=JPRB) :: ADISI
REAL(KIND=JPRB) :: ADISE
REAL(KIND=JPRB) :: ECTMIN
REAL(KIND=JPRB) :: UNTIER
REAL(KIND=JPRB) :: AHCLPV
REAL(KIND=JPRB) :: RICRLM
REAL(KIND=JPRB) :: XBLM
REAL(KIND=JPRB) :: XMINLM
REAL(KIND=JPRB) :: XMAXLM
REAL(KIND=JPRB) :: XWSALM
REAL(KIND=JPRB) :: XWSBLM
REAL(KIND=JPRB) :: GCVALFA
REAL(KIND=JPRB) :: GCVPSI
REAL(KIND=JPRB) :: GCVPSIE
REAL(KIND=JPRB) :: USURICE
REAL(KIND=JPRB) :: USURICL
REAL(KIND=JPRB) :: QSSC
REAL(KIND=JPRB) :: USURID
REAL(KIND=JPRB) :: GCVNU
REAL(KIND=JPRB) :: USURIDE
REAL(KIND=JPRB) :: GCVMLT
REAL(KIND=JPRB) :: UTILGUST
REAL(KIND=JPRB) :: RRGAMMA
REAL(KIND=JPRB) :: RRSCALE
REAL(KIND=JPRB) :: GPBLHK0
REAL(KIND=JPRB) :: GPBLHRA

REAL(KIND=JPRB) :: ACBRPHIM
REAL(KIND=JPRB) :: AGREKE
REAL(KIND=JPRB) :: ALMAVE
REAL(KIND=JPRB) :: ARSCH
REAL(KIND=JPRB) :: ARSCQ
REAL(KIND=JPRB) :: ARSC1
REAL(KIND=JPRB) :: ARSB2
REAL(KIND=JPRB) :: RICRET
REAL(KIND=JPRB) :: STTBMIN
REAL(KIND=JPRB) :: UCWSTAR
REAL(KIND=JPRB) :: UDECT
REAL(KIND=JPRB) :: UPRETMIN
REAL(KIND=JPRB) :: UPRETMAX
REAL(KIND=JPRB) :: USHEARM

!*   Variables pour la microphysique dite de Lopez 
REAL(KIND=JPRB) :: RAUTEFR
REAL(KIND=JPRB) :: RAUTEFS 
REAL(KIND=JPRB) :: RAUTSBET 
REAL(KIND=JPRB) :: RHEVAP
REAL(KIND=JPRB) :: RNINTR  
REAL(KIND=JPRB) :: RNINTS  
REAL(KIND=JPRB) :: RQLCR
REAL(KIND=JPRB) :: RQICRMAX
REAL(KIND=JPRB) :: RQICRMIN
REAL(KIND=JPRB) :: RQLCV
REAL(KIND=JPRB) :: RQICVMAX
REAL(KIND=JPRB) :: RQICVMIN
REAL(KIND=JPRB) :: RQICRT1
REAL(KIND=JPRB) :: RQICRT2
REAL(KIND=JPRB) :: RQICRSN
REAL(KIND=JPRB) :: RQCRNS
REAL(KIND=JPRB) :: RACCEF  
REAL(KIND=JPRB) :: RAGGEF
REAL(KIND=JPRB) :: RRIMEF  
REAL(KIND=JPRB) :: RHCRIT1 
REAL(KIND=JPRB) :: RHCRIT2 
REAL(KIND=JPRB) :: RETAMIN
REAL(KIND=JPRB) :: RFACNSM
REAL(KIND=JPRB) :: TFVR
REAL(KIND=JPRB) :: TFVS
REAL(KIND=JPRB) :: GRHCMOD
REAL(KIND=JPRB) :: NUPTKE
REAL(KIND=JPRB) :: GAMTKE
REAL(KIND=JPRB) :: RCOLL
REAL(KIND=JPRB) :: RFALLL
!*   Variables pour la convection pronostique 
REAL (KIND=JPRB) :: TUDBU, TDDBU
REAL (KIND=JPRB) :: TUDFR, TDDFR
REAL (KIND=JPRB) :: GCVALMX
REAL (KIND=JPRB) :: GCVACHI
REAL (KIND=JPRB) :: GCVADMW
REAL (KIND=JPRB) :: GCVBEE,GCVEEX
REAL (KIND=JPRB) :: ECMNPI
REAL (KIND=JPRB) :: GFRIC
REAL (KIND=JPRB) :: GCVSQDN, GCVSQDR, GCVSQDCX
REAL (KIND=JPRB) :: GRRINTE, GRRMINA
! Downdraught:
REAL (KIND=JPRB) :: GDDBETA, GDDWPF,GDDEVF
REAL (KIND=JPRB) :: TENTRD

!*
!     ------------------------------------------------------------------
!     CONSTANTES PHYSIQUES REGLABLES PROPRES A L'ATMOSPHERE 
!     DANS LA PHYSIQUE SIMPLIFIEE SEULEMENT:
!     ------------------------------------------------------------------
! RNEGAT    : first Pisvejc's constant in ACQWLSR and TL/AD
! RNLCURV   : second Pisvejc's constant in ACQWLSR and TL/AD
REAL(KIND=JPRB) :: RNEGAT
REAL(KIND=JPRB) :: RNLCURV
!     EDK : NOUVEAU PARAMETRE POUR LES FONCTIONS DE LOUIS EN CAS STABLE.
!     XKLM : PARAMETRE POUR L UTILSATION DE HCLP POUR LE CALCUL DE L.
REAL(KIND=JPRB) :: EDK
REAL(KIND=JPRB) :: XKLM
!     PARAMETRE POUR LE TKE AVEC LPBLE (Top-entrainment).
REAL(KIND=JPRB) :: AGRE1
REAL(KIND=JPRB) :: AGRERICR
REAL(KIND=JPRB) :: AJBUMIN
REAL(KIND=JPRB) :: RCOFLM


!*
!     ------------------------------------------------------------------
!     PARAMETRES POUR LA PHYSIQUE
!     ------------------------------------------------------------------

! TRENTRV : Taux Relatif d'ENTRainement du Vent.
! TRENTRV : RELATIVE WIND'S ENTRAINMENT RATE.

! TENTRVL : TAUX D'ENTRAINEMENT V. Lorant
! TENTRVL : V. Lorant ENTRAINMENT RATE.

!*
!     ------------------------------------------------------------------
!     For old ACCVIMP :
!     ------------------------------------------------------------------
REAL(KIND=JPRB) :: TENTRVL
REAL(KIND=JPRB) :: TRENTRV

!*
!     ------------------------------------------------------------------
!     For TKE scheme :
!     ------------------------------------------------------------------
REAL(KIND=JPRB) :: UETEPS
REAL(KIND=JPRB) :: UPRECLP
REAL(KIND=JPRB) :: ARSC2
REAL(KIND=JPRB) :: ARSCT

!*
!     ------------------------------------------------------------------
!     For Grenier (2000) top-PBL entrainment scheme :
!     ------------------------------------------------------------------
REAL(KIND=JPRB) :: AGRE2
REAL(KIND=JPRB) :: AGREF

!*
!     ------------------------------------------------------------------
!     For dry conv. adjustment scheme :
!     ------------------------------------------------------------------
REAL(KIND=JPRB)    :: AJ1MEPS
REAL(KIND=JPRB)    :: AJ1PEPS
INTEGER(KIND=JPIM) :: NAJITER

!*
!     ------------------------------------------------------------------
!     For ACCVIMPGY :
!     ------------------------------------------------------------------
! ALFX    : FRACTION D'ASCENDANCE CONVECTIVE MAXIMUM
! TCTC    : PARAMETRE POUR LE SCHEMA DE PRECIPITATIONS CONVECTIVES
! TVFC    : PARAMETRE POUR LE SCHEMA DE PRECIPITATIONS CONVECTIVES
! GAMAP1  : PARAMETRE DE MASSE VIRTUELLE + 1.
! RKDN    : COEFFICIENT DE RESISTANCE MINIMUM
! VVN     : VITESSE VERTICALE MIN POUR L'ENTRAINEMENT TURBULENT.
! VVX     : VITESSE VERTICALE MAX POUR L'ENTRAINEMENT TURBULENT.
! FENTRT  : FACTEUR DE L'ENTRAINEMENT TURBULENT POUR NIVEAU DE DETRAINEMENT.
! HCMIN   : HAUTEUR CONVECTIVE MINIMALE.
! FQLIC   : FACTEUR DE L'EAU LIQUIDE CONVECTIVE
! FNEBC   : FACTEUR DE LA NEBULOSITE CONVECTIVE
! FEVAPC  : FACTEUR D'EVAPAPORATION DES PRECIPITATIONS
REAL(KIND=JPRB)    :: ALFX
REAL(KIND=JPRB)    :: TCTC
REAL(KIND=JPRB)    :: TVFC
REAL(KIND=JPRB)    :: GAMAP1
REAL(KIND=JPRB)    :: RKDN
REAL(KIND=JPRB)    :: VVN
REAL(KIND=JPRB)    :: VVX
REAL(KIND=JPRB)    :: FENTRT
REAL(KIND=JPRB)    :: HCMIN
REAL(KIND=JPRB)    :: FQLIC
REAL(KIND=JPRB)    :: FNEBC
REAL(KIND=JPRB)    :: FEVAPC

!*
!     ------------------------------------------------------------------
!     For ALARO-0 :
!     ------------------------------------------------------------------
!
! RDPHIC   : REFERENCE GEOPOTENTIAL FOR CLOUDINESS ADJUSTMENT.
! GWBFAUT  : GAIN FOR THE WEGENER BERGERON FINDEISEN PROCESS IN ACAUTO
! RWBF1    : FIRST TUNING CONSTANT FOR BERGERON FINDEISEN PROCESS
! RWBF2    : SECOND TUNING CONSTANT FOR BERGERON FINDEISEN PROCESS
!               IN ACPLUIE_PROG
!
! RAUITN   : TEMPERATURE LEVELS FOR RQICRMIN
! RAUITX   : TEMPERATURE LEVELS FOR RQICRMAX
! RAUIUSTE : INVERSE OF CHARACTERISTIC DTEMPER. FOR RAUTEFS
! RSMDNEBX : MAX CLOUDINESS VERTICAL INCREMENT ALLOWED
!            IF MSMDNEB=2 (ACSMI1)
! RSMDTX   : MAX TEMPERATURE INCREMENT IN 1 TIME STEP
!            ALLOWED FROM RESOLVED CONDENSATION (ACQMESM)
! NSMTPA   : NUMBER OF LEVELS BELOW Tt LEVEL FOR LSMTPS SMOOTHING
! NSMTPB   : NUMBER OF LEVELS ABOVE Tt LEVEL FOR LSMTPS SMOOTHING
!
! ------------------------------------------------------------------
!
REAL(KIND=JPRB) :: RDPHIC
REAL(KIND=JPRB) :: GWBFAUT
REAL(KIND=JPRB) :: RWBF1
REAL(KIND=JPRB) :: RWBF2
REAL(KIND=JPRB) :: RAUITN
REAL(KIND=JPRB) :: RAUITX
REAL(KIND=JPRB) :: RAUIUSTE
REAL(KIND=JPRB) :: RSMDNEBX
REAL(KIND=JPRB) :: RSMDTX
INTEGER (KIND=JPIM) :: NSMTPA
INTEGER (KIND=JPIM) :: NSMTPB

REAL(KIND=JPRB),ALLOCATABLE :: RHCRI(:)
INTEGER (KIND=JPIM) :: NRHCRI

!     ------------------------------------------------------------------
!$OMP THREADPRIVATE(a0ml_at,a0ml_au,a0ml_bt,a0ml_bu,acbrphim,acg,adise,adisi,aecls3,aecls4,aercs1,aercs3,aercs5)
!$OMP THREADPRIVATE(agre1,agre2,agref,agreke,agrericr,ahclpv,aj1meps,aj1peps,ajbumin,akn,ald,alfx,almav,almave)
!$OMP THREADPRIVATE(alphae,alphat,arsb2,arsc1,arsc2,arsch,arscq,arsct,bedifv,ecmnp,ecmnpi,ectmin,edb,edc,edd,edk)
!$OMP THREADPRIVATE(eps,etacut,evap,fentrt,fevapc,fnebc,font,fqlic,galp,gamap1,gamtke,gccsv,gcismin,gcomod,gcvachi)
!$OMP THREADPRIVATE(gcvadmw,gcvads,gcvalfa,gcvalmx,gcvbee,gcvbeta,gcveex,gcvmlt,gcvnu,gcvpsi,gcvpsie,gcvsqdcx)
!$OMP THREADPRIVATE(gcvsqdn,gcvsqdr,gddbeta,gddeva,gddevf,gddsde,gddwpf,gfric,gpblhk0,gpblhra,grcvpp,grhcmod,grrinte)
!$OMP THREADPRIVATE(grrmina,gwbfaut,gwdamp,gwdbc,gwdcco,gwdcd,gwdlt,gwdprof,gwdse,gwdvali,hcmin,hobst,hucoe,hucoe2)
!$OMP THREADPRIVATE(hutil,hutil1,hutil2,najiter,npclo1,npclo2,nrhcri,nsmtpa,nsmtpb,nuptke,qsmin,qsnebc,qsnebs,qssc)
!$OMP THREADPRIVATE(qssusc,qssuss,qssusv,qsusxc,qsusxs,qxral,qxrdel,qxrhx,qxrr,qxrtgh,raccef,raggef,rauitn,rauitx)
!$OMP THREADPRIVATE(rauiuste,rautefr,rautefs,rautsbet,rcin,rcoflm,rcoll,rcvevap,rdphic,rdtfac,retamin,revgsl,rfacnsm)
!$OMP THREADPRIVATE(rfalll,rhcrit1,rhcrit2,rhevap,ricret,ricrlm,rkdn,rnegat,rnintr,rnints,rnlcurv,rphi0,rphir,rqcrns)
!$OMP THREADPRIVATE(rqicrmax,rqicrmin,rqicrsn,rqicrt1,rqicrt2,rqicvmax,rqicvmin,rqlcr,rqlcv,rrgamma,rrimef,rrscale)
!$OMP THREADPRIVATE(rsmdnebx,rsmdtx,rtcape,rwbf1,rwbf2,sco,sensl,snnbco,spnbco,sttbmin,sxnbco,tca,tct,tctc,tcw,tddbu)
!$OMP THREADPRIVATE(tddfr,tddgp,tentr,tentrd,tentrvl,tentrx,tfvr,tfvs,trentrv,tudbu,tudfr,tudgp,turb,tvf,tvfc,tym)
!$OMP THREADPRIVATE(ucwstar,udect,ueteps,uhdifv,untier,upreclp,upretmax,upretmin,usdmlt,ushearm,usuprc,usuric,usurice)
!$OMP THREADPRIVATE(usuricl,usurid,usuride,utilgust,vchrnk,vkarmn,vvn,vvx,vz0cm,vziustar0,xblm,xklm,xmaxlm,xminlm)
!$OMP THREADPRIVATE(xnbmax,xwsalm,xwsblm)
!$OMP THREADPRIVATE(rhcri)
END MODULE YOMPHY0
