SUBROUTINE RRTM_KGB12

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 12:  1800-2080 cm-1 (low - H2O,CO2; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.
!     G.Mozdzynski March 2011 read constants from files
!     T. Wilhelmsson and K. Yessad (Oct 2013) Geometry and setup refactoring.
!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE YOMLUN    ,ONLY : NULRAD
USE YOMMP0    , ONLY : NPROC, MYPROC
USE MPL_MODULE,ONLY : MPL_BROADCAST
USE YOMTAG    ,ONLY : MTAGRAD

USE YOERRTO12, ONLY : KAO     ,KAO_D,SELFREFO,FORREFO   ,FRACREFAO

!     ------------------------------------------------------------------

IMPLICIT NONE
REAL(KIND=JPRB) :: ZHOOK_HANDLE


#include "abor1.intfb.h"

IF (LHOOK) CALL DR_HOOK('RRTM_KGB12',0,ZHOOK_HANDLE)

IF( MYPROC==1 )THEN
  READ(NULRAD,ERR=1001) KAO_D
  KAO = REAL(KAO_D,JPRB)
ENDIF
IF( NPROC>1 )THEN
  CALL MPL_BROADCAST (KAO,MTAGRAD,1,CDSTRING='RRTM_KGB12:')
ENDIF

! Planck fraction mapping level : P = 174.1640 mbar, T= 215.78 K
      FRACREFAO(:, 1) = (/ &
     &  1.3984E-01_JPRB,1.6809E-01_JPRB,1.8072E-01_JPRB,1.5400E-01_JPRB,1.2613E-01_JPRB,9.6959E-02_JPRB, &
     &  5.9713E-02_JPRB,3.8631E-02_JPRB,2.6937E-02_JPRB,3.1711E-03_JPRB,2.3458E-03_JPRB,1.4653E-03_JPRB, &
     &  1.0567E-03_JPRB,6.6504E-04_JPRB,2.4957E-04_JPRB,3.5172E-05_JPRB/)
      FRACREFAO(:, 2) = (/ &
     &  1.2745E-01_JPRB,1.6107E-01_JPRB,1.6568E-01_JPRB,1.5436E-01_JPRB,1.3183E-01_JPRB,1.0166E-01_JPRB, &
     &  6.4506E-02_JPRB,4.7756E-02_JPRB,3.4472E-02_JPRB,3.7189E-03_JPRB,2.9349E-03_JPRB,2.1469E-03_JPRB, &
     &  1.3746E-03_JPRB,7.1691E-04_JPRB,2.8057E-04_JPRB,5.6242E-05_JPRB/)
      FRACREFAO(:, 3) = (/ &
     &  1.2181E-01_JPRB,1.5404E-01_JPRB,1.6540E-01_JPRB,1.5255E-01_JPRB,1.3736E-01_JPRB,9.8856E-02_JPRB, &
     &  6.8927E-02_JPRB,5.1385E-02_JPRB,3.7046E-02_JPRB,4.0302E-03_JPRB,3.0949E-03_JPRB,2.3772E-03_JPRB, &
     &  1.6538E-03_JPRB,8.9641E-04_JPRB,4.6991E-04_JPRB,1.1251E-04_JPRB/)
      FRACREFAO(:, 4) = (/ &
     &  1.1794E-01_JPRB,1.4864E-01_JPRB,1.6316E-01_JPRB,1.5341E-01_JPRB,1.3986E-01_JPRB,9.6656E-02_JPRB, &
     &  7.2478E-02_JPRB,5.5061E-02_JPRB,3.8886E-02_JPRB,4.3398E-03_JPRB,3.3576E-03_JPRB,2.4891E-03_JPRB, &
     &  1.7674E-03_JPRB,1.0764E-03_JPRB,7.7689E-04_JPRB,1.1251E-04_JPRB/)
      FRACREFAO(:, 5) = (/ &
     &  1.1635E-01_JPRB,1.4342E-01_JPRB,1.5924E-01_JPRB,1.5670E-01_JPRB,1.3740E-01_JPRB,9.7087E-02_JPRB, &
     &  7.6250E-02_JPRB,5.7802E-02_JPRB,4.0808E-02_JPRB,4.4113E-03_JPRB,3.6035E-03_JPRB,2.6269E-03_JPRB, &
     &  1.7586E-03_JPRB,1.6498E-03_JPRB,7.7689E-04_JPRB,1.1251E-04_JPRB/)
      FRACREFAO(:, 6) = (/ &
     &  1.1497E-01_JPRB,1.3751E-01_JPRB,1.5587E-01_JPRB,1.5904E-01_JPRB,1.3140E-01_JPRB,1.0159E-01_JPRB, &
     &  7.9729E-02_JPRB,6.1475E-02_JPRB,4.2382E-02_JPRB,4.5291E-03_JPRB,3.8161E-03_JPRB,2.7683E-03_JPRB, &
     &  1.9899E-03_JPRB,2.0395E-03_JPRB,7.7720E-04_JPRB,1.1251E-04_JPRB/)
      FRACREFAO(:, 7) = (/ &
     &  1.1331E-01_JPRB,1.3015E-01_JPRB,1.5574E-01_JPRB,1.5489E-01_JPRB,1.2697E-01_JPRB,1.0746E-01_JPRB, &
     &  8.4777E-02_JPRB,6.5145E-02_JPRB,4.4293E-02_JPRB,4.7426E-03_JPRB,3.8383E-03_JPRB,2.9065E-03_JPRB, &
     &  2.8430E-03_JPRB,2.0401E-03_JPRB,7.7689E-04_JPRB,1.1251E-04_JPRB/)
      FRACREFAO(:, 8) = (/ &
     &  1.0993E-01_JPRB,1.2320E-01_JPRB,1.4893E-01_JPRB,1.4573E-01_JPRB,1.3174E-01_JPRB,1.1149E-01_JPRB, &
     &  9.3326E-02_JPRB,6.9942E-02_JPRB,4.6762E-02_JPRB,4.9309E-03_JPRB,3.8583E-03_JPRB,4.1889E-03_JPRB, &
     &  3.0415E-03_JPRB,2.0406E-03_JPRB,7.7720E-04_JPRB,1.1251E-04_JPRB/)
      FRACREFAO(:, 9) = (/ &
     &  1.2028E-01_JPRB,1.2091E-01_JPRB,1.3098E-01_JPRB,1.3442E-01_JPRB,1.3574E-01_JPRB,1.1739E-01_JPRB, &
     &  9.5343E-02_JPRB,7.0224E-02_JPRB,5.3456E-02_JPRB,6.0206E-03_JPRB,5.0758E-03_JPRB,4.1906E-03_JPRB, &
     &  3.0431E-03_JPRB,2.0400E-03_JPRB,7.7689E-04_JPRB,1.1251E-04_JPRB/)


!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.


!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      FORREFO(1,:) = (/ &
     &1.4739E-04_JPRB,3.1686E-04_JPRB,8.5973E-04_JPRB,1.9039E-03_JPRB,3.1820E-03_JPRB,3.6596E-03_JPRB, &
     &3.8724E-03_JPRB,3.6785E-03_JPRB,3.7141E-03_JPRB,3.7646E-03_JPRB,4.2955E-03_JPRB,4.6343E-03_JPRB, &
     &5.0612E-03_JPRB,4.0227E-03_JPRB,4.2966E-03_JPRB,4.6622E-03_JPRB/)
      FORREFO(2,:) = (/ &
     &1.9397E-04_JPRB,3.6322E-04_JPRB,8.9797E-04_JPRB,2.1001E-03_JPRB,3.0307E-03_JPRB,3.5563E-03_JPRB, &
     &3.8498E-03_JPRB,3.5741E-03_JPRB,3.5914E-03_JPRB,3.7658E-03_JPRB,3.8895E-03_JPRB,4.4072E-03_JPRB, &
     &4.7112E-03_JPRB,4.2230E-03_JPRB,4.2666E-03_JPRB,4.6634E-03_JPRB/)
      FORREFO(3,:) = (/ &
     &3.1506E-04_JPRB,7.3687E-04_JPRB,1.9678E-03_JPRB,2.5531E-03_JPRB,2.8345E-03_JPRB,2.7809E-03_JPRB, &
     &2.9124E-03_JPRB,2.7125E-03_JPRB,2.6644E-03_JPRB,2.4907E-03_JPRB,2.7032E-03_JPRB,4.0967E-03_JPRB, &
     &4.1971E-03_JPRB,4.4507E-03_JPRB,4.2293E-03_JPRB,4.6633E-03_JPRB/)
      FORREFO(4,:) = (/ &
     &8.8196E-04_JPRB,2.1125E-03_JPRB,2.8042E-03_JPRB,2.8891E-03_JPRB,2.4362E-03_JPRB,1.8733E-03_JPRB, &
     &1.4078E-03_JPRB,1.1987E-03_JPRB,1.2808E-03_JPRB,8.9050E-04_JPRB,9.4375E-04_JPRB,7.8351E-04_JPRB, &
     &1.0756E-03_JPRB,1.6586E-03_JPRB,1.7511E-03_JPRB,4.7803E-03_JPRB/)


!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      SELFREFO(:, 1) = (/ &
     & 2.37879E-02_JPRB, 2.10719E-02_JPRB, 1.86660E-02_JPRB, 1.65348E-02_JPRB, 1.46469E-02_JPRB, &
     & 1.29746E-02_JPRB, 1.14932E-02_JPRB, 1.01810E-02_JPRB, 9.01858E-03_JPRB, 7.98888E-03_JPRB/)
      SELFREFO(:, 2) = (/ &
     & 3.10625E-02_JPRB, 2.82664E-02_JPRB, 2.57220E-02_JPRB, 2.34066E-02_JPRB, 2.12997E-02_JPRB, &
     & 1.93824E-02_JPRB, 1.76377E-02_JPRB, 1.60500E-02_JPRB, 1.46053E-02_JPRB, 1.32906E-02_JPRB/)
      SELFREFO(:, 3) = (/ &
     & 5.19103E-02_JPRB, 4.80004E-02_JPRB, 4.43850E-02_JPRB, 4.10419E-02_JPRB, 3.79506E-02_JPRB, &
     & 3.50922E-02_JPRB, 3.24491E-02_JPRB, 3.00050E-02_JPRB, 2.77450E-02_JPRB, 2.56553E-02_JPRB/)
      SELFREFO(:, 4) = (/ &
     & 9.12444E-02_JPRB, 8.38675E-02_JPRB, 7.70870E-02_JPRB, 7.08547E-02_JPRB, 6.51263E-02_JPRB, &
     & 5.98610E-02_JPRB, 5.50214E-02_JPRB, 5.05730E-02_JPRB, 4.64843E-02_JPRB, 4.27262E-02_JPRB/)
      SELFREFO(:, 5) = (/ &
     & 1.11323E-01_JPRB, 1.04217E-01_JPRB, 9.75650E-02_JPRB, 9.13376E-02_JPRB, 8.55076E-02_JPRB, &
     & 8.00498E-02_JPRB, 7.49403E-02_JPRB, 7.01570E-02_JPRB, 6.56790E-02_JPRB, 6.14868E-02_JPRB/)
      SELFREFO(:, 6) = (/ &
     & 1.25301E-01_JPRB, 1.16877E-01_JPRB, 1.09020E-01_JPRB, 1.01691E-01_JPRB, 9.48543E-02_JPRB, &
     & 8.84774E-02_JPRB, 8.25293E-02_JPRB, 7.69810E-02_JPRB, 7.18057E-02_JPRB, 6.69784E-02_JPRB/)
      SELFREFO(:, 7) = (/ &
     & 1.34063E-01_JPRB, 1.24662E-01_JPRB, 1.15920E-01_JPRB, 1.07791E-01_JPRB, 1.00232E-01_JPRB, &
     & 9.32035E-02_JPRB, 8.66676E-02_JPRB, 8.05900E-02_JPRB, 7.49386E-02_JPRB, 6.96836E-02_JPRB/)
      SELFREFO(:, 8) = (/ &
     & 1.26997E-01_JPRB, 1.18306E-01_JPRB, 1.10210E-01_JPRB, 1.02668E-01_JPRB, 9.56417E-02_JPRB, &
     & 8.90964E-02_JPRB, 8.29991E-02_JPRB, 7.73190E-02_JPRB, 7.20276E-02_JPRB, 6.70984E-02_JPRB/)
      SELFREFO(:, 9) = (/ &
     & 1.28823E-01_JPRB, 1.20235E-01_JPRB, 1.12220E-01_JPRB, 1.04739E-01_JPRB, 9.77569E-02_JPRB, &
     & 9.12402E-02_JPRB, 8.51579E-02_JPRB, 7.94810E-02_JPRB, 7.41826E-02_JPRB, 6.92374E-02_JPRB/)
      SELFREFO(:,10) = (/ &
     & 1.35802E-01_JPRB, 1.25981E-01_JPRB, 1.16870E-01_JPRB, 1.08418E-01_JPRB, 1.00577E-01_JPRB, &
     & 9.33034E-02_JPRB, 8.65557E-02_JPRB, 8.02960E-02_JPRB, 7.44890E-02_JPRB, 6.91020E-02_JPRB/)
      SELFREFO(:,11) = (/ &
     & 1.35475E-01_JPRB, 1.27572E-01_JPRB, 1.20130E-01_JPRB, 1.13122E-01_JPRB, 1.06523E-01_JPRB, &
     & 1.00309E-01_JPRB, 9.44573E-02_JPRB, 8.89470E-02_JPRB, 8.37582E-02_JPRB, 7.88721E-02_JPRB/)
      SELFREFO(:,12) = (/ &
     & 1.51195E-01_JPRB, 1.41159E-01_JPRB, 1.31790E-01_JPRB, 1.23043E-01_JPRB, 1.14876E-01_JPRB, &
     & 1.07251E-01_JPRB, 1.00132E-01_JPRB, 9.34860E-02_JPRB, 8.72809E-02_JPRB, 8.14877E-02_JPRB/)
      SELFREFO(:,13) = (/ &
     & 1.57538E-01_JPRB, 1.47974E-01_JPRB, 1.38990E-01_JPRB, 1.30552E-01_JPRB, 1.22626E-01_JPRB, &
     & 1.15181E-01_JPRB, 1.08188E-01_JPRB, 1.01620E-01_JPRB, 9.54505E-02_JPRB, 8.96556E-02_JPRB/)
      SELFREFO(:,14) = (/ &
     & 1.53567E-01_JPRB, 1.41564E-01_JPRB, 1.30500E-01_JPRB, 1.20300E-01_JPRB, 1.10898E-01_JPRB, &
     & 1.02231E-01_JPRB, 9.42406E-02_JPRB, 8.68750E-02_JPRB, 8.00851E-02_JPRB, 7.38259E-02_JPRB/)
      SELFREFO(:,15) = (/ &
     & 1.53687E-01_JPRB, 1.42981E-01_JPRB, 1.33020E-01_JPRB, 1.23753E-01_JPRB, 1.15132E-01_JPRB, &
     & 1.07112E-01_JPRB, 9.96500E-02_JPRB, 9.27080E-02_JPRB, 8.62496E-02_JPRB, 8.02412E-02_JPRB/)
      SELFREFO(:,16) = (/ &
     & 1.65129E-01_JPRB, 1.53285E-01_JPRB, 1.42290E-01_JPRB, 1.32084E-01_JPRB, 1.22610E-01_JPRB, &
     & 1.13815E-01_JPRB, 1.05651E-01_JPRB, 9.80730E-02_JPRB, 9.10384E-02_JPRB, 8.45083E-02_JPRB/)

IF (LHOOK) CALL DR_HOOK('RRTM_KGB12',1,ZHOOK_HANDLE)
RETURN

1001 CONTINUE
CALL ABOR1("RRTM_KGB12:ERROR READING FILE RADRRTM")

END SUBROUTINE RRTM_KGB12
