!
! $Header$
!
SUBROUTINE gr_u_scal_loc(nx,x_u,x_scal)
  !%W%    %G%
  !=======================================================================
  !
  !   Author:    Frederic Hourdin      original: 11/11/92
  !   -------
  !
  !   Subject:
  !   ------
  !
  !   Method:
  !   --------
  !
  !   Interface:
  !   ----------
  !
  !  Input:
  !  ------
  !
  !  Output:
  !  -------
  !
  !=======================================================================
  USE comgeom_mod_h
  USE parallel_lmdz
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h
IMPLICIT NONE
  !-----------------------------------------------------------------------
  !   Declararations:
  !   ---------------




  !   Arguments:
  !   ----------

  INTEGER :: nx
  REAL :: x_u(ijb_u:ije_u,nx),x_scal(ijb_u:ije_u,nx)

  !   Local:
  !   ------

  INTEGER :: l,ij
  INTEGER :: ijb,ije

  !-----------------------------------------------------------------------
  ijb=ij_begin
  ije=ij_end

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO l=1,nx
     DO ij=ijb+1,ije
        x_scal(ij,l)= &
              (aireu(ij)*x_u(ij,l)+aireu(ij-1)*x_u(ij-1,l)) &
              /(aireu(ij)+aireu(ij-1))
     ENDDO
  ENDDO
!$OMP ENDDO NOWAIT

  ijb=ij_begin
  ije=ij_end

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO l=1,nx
     DO ij=ijb,ije-iip1+1,iip1
       x_scal(ij,l)=x_scal(ij+iip1-1,l)
     ENDDO
  ENDDO
!$OMP ENDDO NOWAIT
  RETURN

END SUBROUTINE gr_u_scal_loc
