!
! $Header$
!
SUBROUTINE psextbar ( ps, psexbarxy )
  USE comgeom_mod_h
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
  USE paramet_mod_h
IMPLICIT NONE

  !=======================================================================
  !
  !   Auteur:  P. Le Van
  !   -------
  !
  !   Objet:
  !   ------
  !
  ! **********************************************************************
  ! calcul des moyennes en x et en y de (pression au sol*aire variable) ..
  ! **********************************************************************
  !
  !     ps          est un  argum. d'entree  pour le s-pg ..
  !     psexbarxy   est un  argum. de sortie pour le s-pg ..
  !
  !   Methode:
  !   --------
  !
  !    A chaque point scalaire P (i,j) est affecte 4 coefficients d'aires
  !   alpha1(i,j)  calcule  au point ( i+1/4,j-1/4 )
  !   alpha2(i,j)  calcule  au point ( i+1/4,j+1/4 )
  !   alpha3(i,j)  calcule  au point ( i-1/4,j+1/4 )
  !   alpha4(i,j)  calcule  au point ( i-1/4,j-1/4 )
  !
  !    Avec  alpha1(i,j) = aire(i+1/4,j-1/4)/ aire(i,j)
  !
  !    N.B .  Pour plus de details, voir s-pg  ...  iniconst ...
  !
  !
  !
  !   alpha4 .         . alpha1    . alpha4
  !    (i,j)             (i,j)       (i+1,j)
  !
  !         P .        U .          . P
  !       (i,j)       (i,j)         (i+1,j)
  !
  !   alpha3 .         . alpha2    .alpha3
  !    (i,j)              (i,j)     (i+1,j)
  !
  !         V .        Z .          . V
  !       (i,j)
  !
  !   alpha4 .         . alpha1    .alpha4
  !   (i,j+1)            (i,j+1)   (i+1,j+1)
  !
  !         P .        U .          . P
  !      (i,j+1)                    (i+1,j+1)
  !
  !
  !
  !
  !                   On  a :
  !
  !    pbarx(i,j) = Pext(i  ,j) * ( alpha1(i  ,j) + alpha2(i,j))      +
  !             Pext(i+1,j) * ( alpha3(i+1,j) + alpha4(i+1,j) )
  ! localise  au point  ... U (i,j) ...
  !
  !    pbary(i,j) = Pext(i,j  ) * ( alpha2(i,j  ) + alpha3(i,j  )     +
  !             Pext(i,j+1) * ( alpha1(i,j+1) + alpha4(i,j+1)
  ! localise  au point  ... V (i,j) ...
  !
  !  pbarxy(i,j)= Pext(i,j) *alpha2(i,j) + Pext(i+1,j) *alpha3(i+1,j) +
  !           Pext(i,j+1)*alpha1(i,j+1)+ Pext(i+1,j+1)*alpha4(i+1,j+1)
  ! localise  au point  ... Z (i,j) ...
  !
  !
  !
  !=======================================================================

  REAL :: ps( ip1jmp1 ), psexbarxy ( ip1jm ), pext( ip1jmp1 )

  INTEGER :: l, ij
  !

  DO ij = 1, ip1jmp1
   pext(ij) = ps(ij) * aire(ij)
  ENDDO


  DO     ij = 1, ip1jm - 1
  psexbarxy( ij ) = pext(ij)*alpha2(ij) + pext(ij+1)*alpha3(ij+1) + &
        pext(ij+iip1)*alpha1(ij+iip1) + pext(ij+iip2)*alpha4(ij+iip2)
  END DO


  !    ....  correction pour     psexbarxy( iip1,j )  ........

  !DIR$ IVDEP

  DO ij = iip1, ip1jm, iip1
  psexbarxy( ij ) = psexbarxy( ij - iim )
  END DO


  RETURN
END SUBROUTINE psextbar
