MODULE lmdz_ratqs_ini

IMPLICIT NONE

integer :: lunout

INTEGER, SAVE, PROTECTED :: nbsrf,is_lic,is_ter
REAL, SAVE, PROTECTED :: RG,RV,RD,RCPD,RLSTT,RLVTT,RTT
REAL, SAVE, PROTECTED :: a_ratqs_cv
REAL, SAVE, PROTECTED :: tau_var
REAL, SAVE, PROTECTED :: fac_tau
REAL, SAVE, PROTECTED :: tau_cumul
REAL, SAVE, PROTECTED :: a_ratqs_wake
INTEGER, SAVE, PROTECTED :: dqimpl

real, allocatable, SAVE :: povariance(:,:)
!$OMP THREADPRIVATE(povariance)
real, allocatable, SAVE :: var_conv(:,:)
!$OMP THREADPRIVATE(var_conv)

!$OMP THREADPRIVATE(nbsrf,is_lic,is_ter,RG,RV,RD,RCPD,RLSTT,RLVTT,RTT)
!$OMP THREADPRIVATE(a_ratqs_cv,tau_var,fac_tau,tau_cumul,a_ratqs_wake,dqimpl)


CONTAINS
SUBROUTINE ratqs_ini(klon,klev,iflag_thermals,lunout_in,nbsrf_in,is_lic_in,is_ter_in,RG_in,RV_in,RD_in,RCPD_in,RLSTT_in,RLVTT_in,RTT_in)

   USE ioipsl_getin_p_mod, ONLY : getin_p

integer, intent(in) :: klon,klev,iflag_thermals,lunout_in
integer, intent(in) :: nbsrf_in,is_lic_in,is_ter_in
real, intent(in) :: RG_in,RV_in,RD_in,RCPD_in,RLSTT_in,RLVTT_in,RTT_in

integer :: i,k

nbsrf   =nbsrf_in
is_lic  =is_lic_in
is_ter  =is_ter_in
RG      =RG_in    
RV      =RV_in
RD      =RD_in
RCPD    =RCPD_in
RLSTT   =RLSTT_in
RLVTT   =RLVTT_in
RTT     =RTT_in

print*,'ratqs_ini'
if (iflag_thermals==15.or.iflag_thermals==16) then
   dqimpl=-1
else
   dqimpl=1
endif
lunout=lunout_in

allocate(povariance(klon,klev))
allocate(var_conv(klon,klev))


tau_var = 700. ! temps de relaxation de la variabilit?? pour les thermiques
fac_tau = 2. 
tau_cumul = 1000 
a_ratqs_wake = 3.    ! param??tre pilotant l'importance du terme d??pendant des poches froides
a_ratqs_cv = 1.
CALL getin_p('tau_var', tau_var)
CALL getin_p('fac_tau', fac_tau)
CALL getin_p('tau_cumul', tau_cumul)
CALL getin_p('a_ratqs_wake', a_ratqs_wake) 
CALL getin_p('a_ratqs_cv', a_ratqs_cv)

!--------------------------------------------------------
! Initialisation des variances pour la param??trisation
! pronostique des variances de Louis.
! Ne marche pour le moment qu'en 1D en forcant une 
! initialisation des variances ?? une valeur constante.
! A terme la variance doit devenir une variable d'etat
! passee en argument
!--------------------------------------------------------

if (klon.eq.1) then
    do k=1,klev
      do i=1,klon 
          povariance(i,k) = 0.00000000001
          var_conv(i,k) = 0.00000000001
      enddo
    enddo
else
    print*, 'conserver la variance dans les restarts'
endif
!--------------------------------------------------------

 RETURN

END SUBROUTINE ratqs_ini
END MODULE lmdz_ratqs_ini
