SUBROUTINE RRTM_KGB5

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 5:  700-820 cm-1 (low - H2O,CO2; high - O3,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation
!     G.Mozdzynski March 2011 read constants from files
!     ABozzo 201306 updated to rrtmg v4.85
!     T. Wilhelmsson and K. Yessad (Oct 2013) Geometry and setup refactoring.
!      F. Vana  05-Mar-2015  Support for single precision
!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK, JPHOOK
USE YOMLUN    ,ONLY : NULRAD
USE MPL_MODULE,ONLY : MPL_BROADCAST
USE YOMTAG    ,ONLY : MTAGRAD

USE YOERRTO5 , ONLY : KAO     ,KBO     ,SELFREFO   ,FORREFO, FRACREFAO  ,&
 & FRACREFBO, CCL4O  , KAO_MO3, KAO_D, KBO_D

USE YOMMP0    , ONLY : NPROC, MYPROC

!     ------------------------------------------------------------------

IMPLICIT NONE
REAL(KIND=JPHOOK) :: ZHOOK_HANDLE

#include "abor1.intfb.h"

IF (LHOOK) CALL DR_HOOK('RRTM_KGB5',0,ZHOOK_HANDLE)

IF( MYPROC==1 )THEN
  READ(NULRAD,ERR=1001) KAO_D,KBO_D
  KAO = REAL(KAO_D,JPRB)
  KBO = REAL(KBO_D,JPRB)
ENDIF
IF( NPROC>1 )THEN
  CALL MPL_BROADCAST (KAO,MTAGRAD,1,CDSTRING='RRTM_KGB5:')
  CALL MPL_BROADCAST (KBO,MTAGRAD,1,CDSTRING='RRTM_KGB5:')
ENDIF


! Planck fraction mapping level : P = 473.42 mb, T = 259.83
      FRACREFAO(:, 1) = (/ &
       & 1.4111E-01_JPRB,1.4222E-01_JPRB,1.3802E-01_JPRB,1.3101E-01_JPRB,1.2244E-01_JPRB,1.0691E-01_JPRB, &
       & 8.8703E-02_JPRB,6.7130E-02_JPRB,4.5509E-02_JPRB,4.9866E-03_JPRB,4.1214E-03_JPRB,3.2557E-03_JPRB, &
       & 2.3805E-03_JPRB,1.5450E-03_JPRB,5.8423E-04_JPRB,8.2275E-05_JPRB/)
      FRACREFAO(:, 2) = (/ &
       & 1.4152E-01_JPRB,1.4271E-01_JPRB,1.3784E-01_JPRB,1.3075E-01_JPRB,1.2215E-01_JPRB,1.0674E-01_JPRB, &
       & 8.8686E-02_JPRB,6.7135E-02_JPRB,4.5508E-02_JPRB,4.9866E-03_JPRB,4.1214E-03_JPRB,3.2558E-03_JPRB, &
       & 2.3805E-03_JPRB,1.5450E-03_JPRB,5.8423E-04_JPRB,8.2275E-05_JPRB/)
      FRACREFAO(:, 3) = (/ &
       & 1.4159E-01_JPRB,1.4300E-01_JPRB,1.3781E-01_JPRB,1.3094E-01_JPRB,1.2192E-01_JPRB,1.0661E-01_JPRB, &
       & 8.8529E-02_JPRB,6.7127E-02_JPRB,4.5511E-02_JPRB,4.9877E-03_JPRB,4.1214E-03_JPRB,3.2558E-03_JPRB, &
       & 2.3805E-03_JPRB,1.5450E-03_JPRB,5.8423E-04_JPRB,8.2275E-05_JPRB/)
      FRACREFAO(:, 4) = (/ &
       & 1.4162E-01_JPRB,1.4337E-01_JPRB,1.3774E-01_JPRB,1.3122E-01_JPRB,1.2172E-01_JPRB,1.0641E-01_JPRB, &
       & 8.8384E-02_JPRB,6.7056E-02_JPRB,4.5514E-02_JPRB,4.9880E-03_JPRB,4.1214E-03_JPRB,3.2557E-03_JPRB, &
       & 2.3805E-03_JPRB,1.5450E-03_JPRB,5.8423E-04_JPRB,8.2275E-05_JPRB/)
      FRACREFAO(:, 5) = (/ &
       & 1.4161E-01_JPRB,1.4370E-01_JPRB,1.3770E-01_JPRB,1.3143E-01_JPRB,1.2173E-01_JPRB,1.0613E-01_JPRB, &
       & 8.8357E-02_JPRB,6.6874E-02_JPRB,4.5509E-02_JPRB,4.9883E-03_JPRB,4.1214E-03_JPRB,3.2558E-03_JPRB, &
       & 2.3804E-03_JPRB,1.5450E-03_JPRB,5.8423E-04_JPRB,8.2275E-05_JPRB/)
      FRACREFAO(:, 6) = (/ &
       & 1.4154E-01_JPRB,1.4405E-01_JPRB,1.3771E-01_JPRB,1.3169E-01_JPRB,1.2166E-01_JPRB,1.0603E-01_JPRB, &
       & 8.8193E-02_JPRB,6.6705E-02_JPRB,4.5469E-02_JPRB,4.9902E-03_JPRB,4.1214E-03_JPRB,3.2558E-03_JPRB, &
       & 2.3804E-03_JPRB,1.5450E-03_JPRB,5.8423E-04_JPRB,8.2275E-05_JPRB/)
      FRACREFAO(:, 7) = (/ &
       & 1.4126E-01_JPRB,1.4440E-01_JPRB,1.3790E-01_JPRB,1.3214E-01_JPRB,1.2153E-01_JPRB,1.0603E-01_JPRB, &
       & 8.7908E-02_JPRB,6.6612E-02_JPRB,4.5269E-02_JPRB,4.9900E-03_JPRB,4.1256E-03_JPRB,3.2558E-03_JPRB, &
       & 2.3804E-03_JPRB,1.5451E-03_JPRB,5.8423E-04_JPRB,8.2275E-05_JPRB/)
      FRACREFAO(:, 8) = (/ &
       & 1.4076E-01_JPRB,1.4415E-01_JPRB,1.3885E-01_JPRB,1.3286E-01_JPRB,1.2147E-01_JPRB,1.0612E-01_JPRB, &
       & 8.7579E-02_JPRB,6.6280E-02_JPRB,4.4977E-02_JPRB,4.9782E-03_JPRB,4.1200E-03_JPRB,3.2620E-03_JPRB, &
       & 2.3820E-03_JPRB,1.5452E-03_JPRB,5.8423E-04_JPRB,8.2275E-05_JPRB/)
      FRACREFAO(:, 9) = (/ &
       & 1.4205E-01_JPRB,1.4496E-01_JPRB,1.4337E-01_JPRB,1.3504E-01_JPRB,1.2260E-01_JPRB,1.0428E-01_JPRB, &
       & 8.4946E-02_JPRB,6.3625E-02_JPRB,4.2951E-02_JPRB,4.7313E-03_JPRB,3.9157E-03_JPRB,3.0879E-03_JPRB, &
       & 2.2666E-03_JPRB,1.5193E-03_JPRB,5.7469E-04_JPRB,8.1674E-05_JPRB/)

! Planck fraction mapping level : P = 0.2369280 mbar, T = 253.60 K
      FRACREFBO(:, 1) = (/ &
       & 1.4075E-01_JPRB,1.4196E-01_JPRB,1.3833E-01_JPRB,1.3345E-01_JPRB,1.2234E-01_JPRB,1.0718E-01_JPRB, &
       & 8.8004E-02_JPRB,6.6308E-02_JPRB,4.5028E-02_JPRB,4.9029E-03_JPRB,4.0377E-03_JPRB,3.1870E-03_JPRB, &
       & 2.3503E-03_JPRB,1.5146E-03_JPRB,5.7165E-04_JPRB,8.2371E-05_JPRB/)
      FRACREFBO(:, 2) = (/ &
       & 1.4081E-01_JPRB,1.4225E-01_JPRB,1.3890E-01_JPRB,1.3410E-01_JPRB,1.2254E-01_JPRB,1.0680E-01_JPRB, &
       & 8.7391E-02_JPRB,6.5819E-02_JPRB,4.4725E-02_JPRB,4.9121E-03_JPRB,4.0420E-03_JPRB,3.1869E-03_JPRB, &
       & 2.3504E-03_JPRB,1.5146E-03_JPRB,5.7165E-04_JPRB,8.2371E-05_JPRB/)
      FRACREFBO(:, 3) = (/ &
       & 1.4087E-01_JPRB,1.4227E-01_JPRB,1.3920E-01_JPRB,1.3395E-01_JPRB,1.2270E-01_JPRB,1.0694E-01_JPRB, &
       & 8.7229E-02_JPRB,6.5653E-02_JPRB,4.4554E-02_JPRB,4.8797E-03_JPRB,4.0460E-03_JPRB,3.1939E-03_JPRB, &
       & 2.3505E-03_JPRB,1.5146E-03_JPRB,5.7165E-04_JPRB,8.1910E-05_JPRB/)
      FRACREFBO(:, 4) = (/ &
       & 1.4089E-01_JPRB,1.4238E-01_JPRB,1.3956E-01_JPRB,1.3379E-01_JPRB,1.2284E-01_JPRB,1.0688E-01_JPRB, &
       & 8.7192E-02_JPRB,6.5490E-02_JPRB,4.4390E-02_JPRB,4.8395E-03_JPRB,4.0173E-03_JPRB,3.2070E-03_JPRB, &
       & 2.3559E-03_JPRB,1.5146E-03_JPRB,5.7165E-04_JPRB,8.2371E-05_JPRB/)
      FRACREFBO(:, 5) = (/ &
       & 1.4091E-01_JPRB,1.4417E-01_JPRB,1.4194E-01_JPRB,1.3457E-01_JPRB,1.2167E-01_JPRB,1.0551E-01_JPRB, &
       & 8.6450E-02_JPRB,6.4889E-02_JPRB,4.3584E-02_JPRB,4.7551E-03_JPRB,3.9509E-03_JPRB,3.1374E-03_JPRB, &
       & 2.3226E-03_JPRB,1.4942E-03_JPRB,5.7545E-04_JPRB,8.0887E-05_JPRB/)



CCL4O( :) = (/&
 & 26.1407_JPRB,  53.9776_JPRB,  63.8085_JPRB,  36.1701_JPRB,&
 & 15.4099_JPRB, 10.23116_JPRB,  4.82948_JPRB,  5.03836_JPRB,&
 & 1.75558_JPRB,  0.0_JPRB     ,  0.0_JPRB     ,  0.0_JPRB     ,&
 & 0.0_JPRB     ,  0.0_JPRB     ,  0.0_JPRB     ,  0.0_JPRB      /)  


!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 9 and corresponds to different water vapor to CO2 ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = h2o/(h20 + (rat) * co2), where rat is the ratio of the integrated
!     line strength in the band of co2 to that of h2o.  For instance,
!     JS=1 refers to dry air (eta = 0), JS = 9 corresponds to eta = 1.0.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature TREF-15, 
!     JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.



!     The array KB contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of O3 to CO2.  The first index in the array, JS, runs from 1 to 5, 
!     and corresponds to different O3 to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = O3/(O3+RAT*CO2), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of co2 to that of O3.  For instance, JS=1 refers to no O3 (eta = 0) 
!     and JS = 5 corresponds to eta = 1.0.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.



!     The array KAO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.  The second index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
!     runs over the g-channel (1 to 16).

      KAO_MO3( 1, :, 1) = (/ &
     & 9.31040E-03_JPRB, 1.01286E-02_JPRB, 1.10186E-02_JPRB, 1.19869E-02_JPRB, 1.30403E-02_JPRB, &
     & 1.41862E-02_JPRB, 1.54328E-02_JPRB, 1.67890E-02_JPRB, 1.82644E-02_JPRB, 1.98694E-02_JPRB, &
     & 2.16154E-02_JPRB, 2.35149E-02_JPRB, 2.55813E-02_JPRB, 2.78293E-02_JPRB, 3.02749E-02_JPRB, &
     & 3.29353E-02_JPRB, 3.58295E-02_JPRB, 3.89781E-02_JPRB, 4.24034E-02_JPRB/)
      KAO_MO3( 2, :, 1) = (/ &
     & 1.11200E-02_JPRB, 1.20461E-02_JPRB, 1.30493E-02_JPRB, 1.41360E-02_JPRB, 1.53133E-02_JPRB, &
     & 1.65886E-02_JPRB, 1.79701E-02_JPRB, 1.94666E-02_JPRB, 2.10878E-02_JPRB, 2.28440E-02_JPRB, &
     & 2.47465E-02_JPRB, 2.68074E-02_JPRB, 2.90399E-02_JPRB, 3.14583E-02_JPRB, 3.40782E-02_JPRB, &
     & 3.69162E-02_JPRB, 3.99907E-02_JPRB, 4.33211E-02_JPRB, 4.69289E-02_JPRB/)
      KAO_MO3( 3, :, 1) = (/ &
     & 1.21630E-02_JPRB, 1.31401E-02_JPRB, 1.41956E-02_JPRB, 1.53359E-02_JPRB, 1.65679E-02_JPRB, &
     & 1.78988E-02_JPRB, 1.93366E-02_JPRB, 2.08899E-02_JPRB, 2.25680E-02_JPRB, 2.43808E-02_JPRB, &
     & 2.63394E-02_JPRB, 2.84552E-02_JPRB, 3.07410E-02_JPRB, 3.32104E-02_JPRB, 3.58782E-02_JPRB, &
     & 3.87603E-02_JPRB, 4.18739E-02_JPRB, 4.52377E-02_JPRB, 4.88716E-02_JPRB/)
      KAO_MO3( 4, :, 1) = (/ &
     & 1.26231E-02_JPRB, 1.36243E-02_JPRB, 1.47049E-02_JPRB, 1.58713E-02_JPRB, 1.71301E-02_JPRB, &
     & 1.84888E-02_JPRB, 1.99553E-02_JPRB, 2.15380E-02_JPRB, 2.32463E-02_JPRB, 2.50901E-02_JPRB, &
     & 2.70801E-02_JPRB, 2.92280E-02_JPRB, 3.15463E-02_JPRB, 3.40484E-02_JPRB, 3.67489E-02_JPRB, &
     & 3.96637E-02_JPRB, 4.28097E-02_JPRB, 4.62051E-02_JPRB, 4.98699E-02_JPRB/)
      KAO_MO3( 5, :, 1) = (/ &
     & 1.33345E-02_JPRB, 1.43736E-02_JPRB, 1.54938E-02_JPRB, 1.67012E-02_JPRB, 1.80027E-02_JPRB, &
     & 1.94057E-02_JPRB, 2.09180E-02_JPRB, 2.25481E-02_JPRB, 2.43053E-02_JPRB, 2.61994E-02_JPRB, &
     & 2.82411E-02_JPRB, 3.04419E-02_JPRB, 3.28142E-02_JPRB, 3.53714E-02_JPRB, 3.81279E-02_JPRB, &
     & 4.10992E-02_JPRB, 4.43021E-02_JPRB, 4.77545E-02_JPRB, 5.14760E-02_JPRB/)
      KAO_MO3( 6, :, 1) = (/ &
     & 1.43294E-02_JPRB, 1.54133E-02_JPRB, 1.65791E-02_JPRB, 1.78331E-02_JPRB, 1.91819E-02_JPRB, &
     & 2.06328E-02_JPRB, 2.21935E-02_JPRB, 2.38721E-02_JPRB, 2.56778E-02_JPRB, 2.76200E-02_JPRB, &
     & 2.97091E-02_JPRB, 3.19562E-02_JPRB, 3.43733E-02_JPRB, 3.69732E-02_JPRB, 3.97698E-02_JPRB, &
     & 4.27779E-02_JPRB, 4.60136E-02_JPRB, 4.94939E-02_JPRB, 5.32375E-02_JPRB/)
      KAO_MO3( 7, :, 1) = (/ &
     & 1.48298E-02_JPRB, 1.59503E-02_JPRB, 1.71554E-02_JPRB, 1.84517E-02_JPRB, 1.98458E-02_JPRB, &
     & 2.13453E-02_JPRB, 2.29581E-02_JPRB, 2.46928E-02_JPRB, 2.65585E-02_JPRB, 2.85652E-02_JPRB, &
     & 3.07235E-02_JPRB, 3.30449E-02_JPRB, 3.55417E-02_JPRB, 3.82272E-02_JPRB, 4.11155E-02_JPRB, &
     & 4.42221E-02_JPRB, 4.75634E-02_JPRB, 5.11572E-02_JPRB, 5.50225E-02_JPRB/)
      KAO_MO3( 8, :, 1) = (/ &
     & 1.41792E-02_JPRB, 1.53141E-02_JPRB, 1.65398E-02_JPRB, 1.78637E-02_JPRB, 1.92935E-02_JPRB, &
     & 2.08378E-02_JPRB, 2.25057E-02_JPRB, 2.43071E-02_JPRB, 2.62526E-02_JPRB, 2.83539E-02_JPRB, &
     & 3.06234E-02_JPRB, 3.30745E-02_JPRB, 3.57218E-02_JPRB, 3.85810E-02_JPRB, 4.16690E-02_JPRB, &
     & 4.50042E-02_JPRB, 4.86064E-02_JPRB, 5.24969E-02_JPRB, 5.66988E-02_JPRB/)
      KAO_MO3( 9, :, 1) = (/ &
     & 8.82784E-03_JPRB, 9.48321E-03_JPRB, 1.01872E-02_JPRB, 1.09435E-02_JPRB, 1.17560E-02_JPRB, &
     & 1.26287E-02_JPRB, 1.35662E-02_JPRB, 1.45734E-02_JPRB, 1.56553E-02_JPRB, 1.68175E-02_JPRB, &
     & 1.80660E-02_JPRB, 1.94072E-02_JPRB, 2.08480E-02_JPRB, 2.23958E-02_JPRB, 2.40584E-02_JPRB, &
     & 2.58445E-02_JPRB, 2.77631E-02_JPRB, 2.98242E-02_JPRB, 3.20383E-02_JPRB/)
      KAO_MO3( 1, :, 2) = (/ &
     & 4.28238E-02_JPRB, 4.51015E-02_JPRB, 4.75003E-02_JPRB, 5.00266E-02_JPRB, 5.26873E-02_JPRB, &
     & 5.54896E-02_JPRB, 5.84409E-02_JPRB, 6.15491E-02_JPRB, 6.48227E-02_JPRB, 6.82704E-02_JPRB, &
     & 7.19014E-02_JPRB, 7.57256E-02_JPRB, 7.97532E-02_JPRB, 8.39949E-02_JPRB, 8.84623E-02_JPRB, &
     & 9.31673E-02_JPRB, 9.81225E-02_JPRB, 1.03341E-01_JPRB, 1.08838E-01_JPRB/)
      KAO_MO3( 2, :, 2) = (/ &
     & 4.83672E-02_JPRB, 5.07219E-02_JPRB, 5.31911E-02_JPRB, 5.57806E-02_JPRB, 5.84962E-02_JPRB, &
     & 6.13440E-02_JPRB, 6.43303E-02_JPRB, 6.74621E-02_JPRB, 7.07464E-02_JPRB, 7.41905E-02_JPRB, &
     & 7.78023E-02_JPRB, 8.15899E-02_JPRB, 8.55619E-02_JPRB, 8.97273E-02_JPRB, 9.40955E-02_JPRB, &
     & 9.86763E-02_JPRB, 1.03480E-01_JPRB, 1.08518E-01_JPRB, 1.13801E-01_JPRB/)
      KAO_MO3( 3, :, 2) = (/ &
     & 5.24315E-02_JPRB, 5.48650E-02_JPRB, 5.74115E-02_JPRB, 6.00762E-02_JPRB, 6.28645E-02_JPRB, &
     & 6.57822E-02_JPRB, 6.88354E-02_JPRB, 7.20302E-02_JPRB, 7.53734E-02_JPRB, 7.88717E-02_JPRB, &
     & 8.25324E-02_JPRB, 8.63630E-02_JPRB, 9.03714E-02_JPRB, 9.45658E-02_JPRB, 9.89549E-02_JPRB, &
     & 1.03548E-01_JPRB, 1.08354E-01_JPRB, 1.13383E-01_JPRB, 1.18645E-01_JPRB/)
      KAO_MO3( 4, :, 2) = (/ &
     & 5.65191E-02_JPRB, 5.90383E-02_JPRB, 6.16699E-02_JPRB, 6.44187E-02_JPRB, 6.72901E-02_JPRB, &
     & 7.02894E-02_JPRB, 7.34224E-02_JPRB, 7.66951E-02_JPRB, 8.01137E-02_JPRB, 8.36846E-02_JPRB, &
     & 8.74147E-02_JPRB, 9.13111E-02_JPRB, 9.53812E-02_JPRB, 9.96326E-02_JPRB, 1.04074E-01_JPRB, &
     & 1.08712E-01_JPRB, 1.13558E-01_JPRB, 1.18620E-01_JPRB, 1.23907E-01_JPRB/)
      KAO_MO3( 5, :, 2) = (/ &
     & 6.03171E-02_JPRB, 6.29114E-02_JPRB, 6.56172E-02_JPRB, 6.84394E-02_JPRB, 7.13830E-02_JPRB, &
     & 7.44532E-02_JPRB, 7.76555E-02_JPRB, 8.09955E-02_JPRB, 8.44791E-02_JPRB, 8.81125E-02_JPRB, &
     & 9.19023E-02_JPRB, 9.58550E-02_JPRB, 9.99778E-02_JPRB, 1.04278E-01_JPRB, 1.08763E-01_JPRB, &
     & 1.13441E-01_JPRB, 1.18320E-01_JPRB, 1.23409E-01_JPRB, 1.28717E-01_JPRB/)
      KAO_MO3( 6, :, 2) = (/ &
     & 6.51092E-02_JPRB, 6.77827E-02_JPRB, 7.05660E-02_JPRB, 7.34635E-02_JPRB, 7.64801E-02_JPRB, &
     & 7.96204E-02_JPRB, 8.28898E-02_JPRB, 8.62934E-02_JPRB, 8.98367E-02_JPRB, 9.35255E-02_JPRB, &
     & 9.73658E-02_JPRB, 1.01364E-01_JPRB, 1.05526E-01_JPRB, 1.09859E-01_JPRB, 1.14370E-01_JPRB, &
     & 1.19066E-01_JPRB, 1.23955E-01_JPRB, 1.29045E-01_JPRB, 1.34344E-01_JPRB/)
      KAO_MO3( 7, :, 2) = (/ &
     & 7.09653E-02_JPRB, 7.37378E-02_JPRB, 7.66187E-02_JPRB, 7.96121E-02_JPRB, 8.27225E-02_JPRB, &
     & 8.59543E-02_JPRB, 8.93125E-02_JPRB, 9.28018E-02_JPRB, 9.64275E-02_JPRB, 1.00195E-01_JPRB, &
     & 1.04109E-01_JPRB, 1.08177E-01_JPRB, 1.12403E-01_JPRB, 1.16795E-01_JPRB, 1.21358E-01_JPRB, &
     & 1.26099E-01_JPRB, 1.31026E-01_JPRB, 1.36145E-01_JPRB, 1.41464E-01_JPRB/)
      KAO_MO3( 8, :, 2) = (/ &
     & 7.69193E-02_JPRB, 7.97926E-02_JPRB, 8.27733E-02_JPRB, 8.58653E-02_JPRB, 8.90728E-02_JPRB, &
     & 9.24002E-02_JPRB, 9.58518E-02_JPRB, 9.94324E-02_JPRB, 1.03147E-01_JPRB, 1.07000E-01_JPRB, &
     & 1.10997E-01_JPRB, 1.15143E-01_JPRB, 1.19444E-01_JPRB, 1.23906E-01_JPRB, 1.28535E-01_JPRB, &
     & 1.33336E-01_JPRB, 1.38317E-01_JPRB, 1.43484E-01_JPRB, 1.48844E-01_JPRB/)
      KAO_MO3( 9, :, 2) = (/ &
     & 4.57962E-02_JPRB, 4.76027E-02_JPRB, 4.94805E-02_JPRB, 5.14323E-02_JPRB, 5.34611E-02_JPRB, &
     & 5.55700E-02_JPRB, 5.77620E-02_JPRB, 6.00405E-02_JPRB, 6.24089E-02_JPRB, 6.48707E-02_JPRB, &
     & 6.74296E-02_JPRB, 7.00895E-02_JPRB, 7.28542E-02_JPRB, 7.57281E-02_JPRB, 7.87153E-02_JPRB, &
     & 8.18203E-02_JPRB, 8.50478E-02_JPRB, 8.84027E-02_JPRB, 9.18898E-02_JPRB/)
      KAO_MO3( 1, :, 3) = (/ &
     & 1.12607E-01_JPRB, 1.16047E-01_JPRB, 1.19591E-01_JPRB, 1.23244E-01_JPRB, 1.27009E-01_JPRB, &
     & 1.30888E-01_JPRB, 1.34886E-01_JPRB, 1.39006E-01_JPRB, 1.43252E-01_JPRB, 1.47628E-01_JPRB, &
     & 1.52137E-01_JPRB, 1.56785E-01_JPRB, 1.61574E-01_JPRB, 1.66509E-01_JPRB, 1.71595E-01_JPRB, &
     & 1.76836E-01_JPRB, 1.82238E-01_JPRB, 1.87804E-01_JPRB, 1.93541E-01_JPRB/)
      KAO_MO3( 2, :, 3) = (/ &
     & 1.14531E-01_JPRB, 1.17850E-01_JPRB, 1.21266E-01_JPRB, 1.24781E-01_JPRB, 1.28397E-01_JPRB, &
     & 1.32119E-01_JPRB, 1.35948E-01_JPRB, 1.39888E-01_JPRB, 1.43943E-01_JPRB, 1.48115E-01_JPRB, &
     & 1.52407E-01_JPRB, 1.56825E-01_JPRB, 1.61370E-01_JPRB, 1.66047E-01_JPRB, 1.70860E-01_JPRB, &
     & 1.75812E-01_JPRB, 1.80907E-01_JPRB, 1.86150E-01_JPRB, 1.91546E-01_JPRB/)
      KAO_MO3( 3, :, 3) = (/ &
     & 1.13986E-01_JPRB, 1.17222E-01_JPRB, 1.20551E-01_JPRB, 1.23974E-01_JPRB, 1.27494E-01_JPRB, &
     & 1.31114E-01_JPRB, 1.34837E-01_JPRB, 1.38666E-01_JPRB, 1.42604E-01_JPRB, 1.46653E-01_JPRB, &
     & 1.50817E-01_JPRB, 1.55099E-01_JPRB, 1.59503E-01_JPRB, 1.64032E-01_JPRB, 1.68690E-01_JPRB, &
     & 1.73480E-01_JPRB, 1.78406E-01_JPRB, 1.83472E-01_JPRB, 1.88682E-01_JPRB/)
      KAO_MO3( 4, :, 3) = (/ &
     & 1.13713E-01_JPRB, 1.16892E-01_JPRB, 1.20160E-01_JPRB, 1.23519E-01_JPRB, 1.26972E-01_JPRB, &
     & 1.30522E-01_JPRB, 1.34171E-01_JPRB, 1.37922E-01_JPRB, 1.41778E-01_JPRB, 1.45742E-01_JPRB, &
     & 1.49817E-01_JPRB, 1.54005E-01_JPRB, 1.58311E-01_JPRB, 1.62737E-01_JPRB, 1.67287E-01_JPRB, &
     & 1.71964E-01_JPRB, 1.76771E-01_JPRB, 1.81714E-01_JPRB, 1.86794E-01_JPRB/)
      KAO_MO3( 5, :, 3) = (/ &
     & 1.12321E-01_JPRB, 1.15413E-01_JPRB, 1.18591E-01_JPRB, 1.21856E-01_JPRB, 1.25211E-01_JPRB, &
     & 1.28658E-01_JPRB, 1.32200E-01_JPRB, 1.35840E-01_JPRB, 1.39580E-01_JPRB, 1.43423E-01_JPRB, &
     & 1.47372E-01_JPRB, 1.51429E-01_JPRB, 1.55599E-01_JPRB, 1.59883E-01_JPRB, 1.64284E-01_JPRB, &
     & 1.68808E-01_JPRB, 1.73455E-01_JPRB, 1.78231E-01_JPRB, 1.83138E-01_JPRB/)
      KAO_MO3( 6, :, 3) = (/ &
     & 1.14158E-01_JPRB, 1.17218E-01_JPRB, 1.20360E-01_JPRB, 1.23586E-01_JPRB, 1.26899E-01_JPRB, &
     & 1.30300E-01_JPRB, 1.33793E-01_JPRB, 1.37379E-01_JPRB, 1.41061E-01_JPRB, 1.44842E-01_JPRB, &
     & 1.48724E-01_JPRB, 1.52711E-01_JPRB, 1.56804E-01_JPRB, 1.61007E-01_JPRB, 1.65322E-01_JPRB, &
     & 1.69754E-01_JPRB, 1.74304E-01_JPRB, 1.78976E-01_JPRB, 1.83773E-01_JPRB/)
      KAO_MO3( 7, :, 3) = (/ &
     & 1.21015E-01_JPRB, 1.23989E-01_JPRB, 1.27036E-01_JPRB, 1.30157E-01_JPRB, 1.33355E-01_JPRB, &
     & 1.36632E-01_JPRB, 1.39990E-01_JPRB, 1.43429E-01_JPRB, 1.46954E-01_JPRB, 1.50565E-01_JPRB, &
     & 1.54264E-01_JPRB, 1.58055E-01_JPRB, 1.61939E-01_JPRB, 1.65918E-01_JPRB, 1.69995E-01_JPRB, &
     & 1.74172E-01_JPRB, 1.78452E-01_JPRB, 1.82836E-01_JPRB, 1.87329E-01_JPRB/)
      KAO_MO3( 8, :, 3) = (/ &
     & 1.33952E-01_JPRB, 1.36939E-01_JPRB, 1.39992E-01_JPRB, 1.43114E-01_JPRB, 1.46305E-01_JPRB, &
     & 1.49567E-01_JPRB, 1.52902E-01_JPRB, 1.56311E-01_JPRB, 1.59797E-01_JPRB, 1.63360E-01_JPRB, &
     & 1.67002E-01_JPRB, 1.70726E-01_JPRB, 1.74533E-01_JPRB, 1.78424E-01_JPRB, 1.82403E-01_JPRB, &
     & 1.86470E-01_JPRB, 1.90627E-01_JPRB, 1.94878E-01_JPRB, 1.99223E-01_JPRB/)
      KAO_MO3( 9, :, 3) = (/ &
     & 1.01003E-01_JPRB, 1.03713E-01_JPRB, 1.06495E-01_JPRB, 1.09352E-01_JPRB, 1.12285E-01_JPRB, &
     & 1.15297E-01_JPRB, 1.18390E-01_JPRB, 1.21566E-01_JPRB, 1.24827E-01_JPRB, 1.28176E-01_JPRB, &
     & 1.31614E-01_JPRB, 1.35145E-01_JPRB, 1.38770E-01_JPRB, 1.42493E-01_JPRB, 1.46315E-01_JPRB, &
     & 1.50240E-01_JPRB, 1.54271E-01_JPRB, 1.58409E-01_JPRB, 1.62659E-01_JPRB/)
      KAO_MO3( 1, :, 4) = (/ &
     & 2.35597E-01_JPRB, 2.37975E-01_JPRB, 2.40376E-01_JPRB, 2.42802E-01_JPRB, 2.45253E-01_JPRB, &
     & 2.47728E-01_JPRB, 2.50228E-01_JPRB, 2.52753E-01_JPRB, 2.55304E-01_JPRB, 2.57881E-01_JPRB, &
     & 2.60483E-01_JPRB, 2.63112E-01_JPRB, 2.65767E-01_JPRB, 2.68450E-01_JPRB, 2.71159E-01_JPRB, &
     & 2.73895E-01_JPRB, 2.76660E-01_JPRB, 2.79452E-01_JPRB, 2.82272E-01_JPRB/)
      KAO_MO3( 2, :, 4) = (/ &
     & 2.27965E-01_JPRB, 2.30334E-01_JPRB, 2.32728E-01_JPRB, 2.35146E-01_JPRB, 2.37590E-01_JPRB, &
     & 2.40059E-01_JPRB, 2.42554E-01_JPRB, 2.45075E-01_JPRB, 2.47621E-01_JPRB, 2.50195E-01_JPRB, &
     & 2.52795E-01_JPRB, 2.55422E-01_JPRB, 2.58077E-01_JPRB, 2.60759E-01_JPRB, 2.63468E-01_JPRB, &
     & 2.66206E-01_JPRB, 2.68973E-01_JPRB, 2.71768E-01_JPRB, 2.74593E-01_JPRB/)
      KAO_MO3( 3, :, 4) = (/ &
     & 2.25956E-01_JPRB, 2.28277E-01_JPRB, 2.30622E-01_JPRB, 2.32991E-01_JPRB, 2.35384E-01_JPRB, &
     & 2.37802E-01_JPRB, 2.40244E-01_JPRB, 2.42712E-01_JPRB, 2.45205E-01_JPRB, 2.47724E-01_JPRB, &
     & 2.50268E-01_JPRB, 2.52839E-01_JPRB, 2.55436E-01_JPRB, 2.58060E-01_JPRB, 2.60711E-01_JPRB, &
     & 2.63389E-01_JPRB, 2.66094E-01_JPRB, 2.68827E-01_JPRB, 2.71589E-01_JPRB/)
      KAO_MO3( 4, :, 4) = (/ &
     & 2.28371E-01_JPRB, 2.30595E-01_JPRB, 2.32840E-01_JPRB, 2.35107E-01_JPRB, 2.37397E-01_JPRB, &
     & 2.39708E-01_JPRB, 2.42042E-01_JPRB, 2.44399E-01_JPRB, 2.46779E-01_JPRB, 2.49182E-01_JPRB, &
     & 2.51608E-01_JPRB, 2.54058E-01_JPRB, 2.56532E-01_JPRB, 2.59030E-01_JPRB, 2.61552E-01_JPRB, &
     & 2.64099E-01_JPRB, 2.66671E-01_JPRB, 2.69267E-01_JPRB, 2.71889E-01_JPRB/)
      KAO_MO3( 5, :, 4) = (/ &
     & 2.42563E-01_JPRB, 2.44620E-01_JPRB, 2.46695E-01_JPRB, 2.48787E-01_JPRB, 2.50897E-01_JPRB, &
     & 2.53024E-01_JPRB, 2.55170E-01_JPRB, 2.57334E-01_JPRB, 2.59516E-01_JPRB, 2.61717E-01_JPRB, &
     & 2.63936E-01_JPRB, 2.66174E-01_JPRB, 2.68431E-01_JPRB, 2.70708E-01_JPRB, 2.73003E-01_JPRB, &
     & 2.75318E-01_JPRB, 2.77653E-01_JPRB, 2.80008E-01_JPRB, 2.82382E-01_JPRB/)
      KAO_MO3( 6, :, 4) = (/ &
     & 2.54052E-01_JPRB, 2.56017E-01_JPRB, 2.57997E-01_JPRB, 2.59992E-01_JPRB, 2.62003E-01_JPRB, &
     & 2.64029E-01_JPRB, 2.66071E-01_JPRB, 2.68129E-01_JPRB, 2.70203E-01_JPRB, 2.72293E-01_JPRB, &
     & 2.74398E-01_JPRB, 2.76521E-01_JPRB, 2.78659E-01_JPRB, 2.80814E-01_JPRB, 2.82986E-01_JPRB, &
     & 2.85175E-01_JPRB, 2.87380E-01_JPRB, 2.89603E-01_JPRB, 2.91842E-01_JPRB/)
      KAO_MO3( 7, :, 4) = (/ &
     & 2.54061E-01_JPRB, 2.55982E-01_JPRB, 2.57917E-01_JPRB, 2.59867E-01_JPRB, 2.61832E-01_JPRB, &
     & 2.63811E-01_JPRB, 2.65806E-01_JPRB, 2.67815E-01_JPRB, 2.69840E-01_JPRB, 2.71880E-01_JPRB, &
     & 2.73936E-01_JPRB, 2.76007E-01_JPRB, 2.78093E-01_JPRB, 2.80196E-01_JPRB, 2.82314E-01_JPRB, &
     & 2.84449E-01_JPRB, 2.86599E-01_JPRB, 2.88766E-01_JPRB, 2.90949E-01_JPRB/)
      KAO_MO3( 8, :, 4) = (/ &
     & 2.72482E-01_JPRB, 2.73916E-01_JPRB, 2.75358E-01_JPRB, 2.76807E-01_JPRB, 2.78264E-01_JPRB, &
     & 2.79729E-01_JPRB, 2.81201E-01_JPRB, 2.82681E-01_JPRB, 2.84169E-01_JPRB, 2.85665E-01_JPRB, &
     & 2.87168E-01_JPRB, 2.88680E-01_JPRB, 2.90199E-01_JPRB, 2.91726E-01_JPRB, 2.93262E-01_JPRB, &
     & 2.94805E-01_JPRB, 2.96357E-01_JPRB, 2.97917E-01_JPRB, 2.99485E-01_JPRB/)
      KAO_MO3( 9, :, 4) = (/ &
     & 1.93414E-01_JPRB, 1.95498E-01_JPRB, 1.97605E-01_JPRB, 1.99734E-01_JPRB, 2.01886E-01_JPRB, &
     & 2.04062E-01_JPRB, 2.06261E-01_JPRB, 2.08483E-01_JPRB, 2.10730E-01_JPRB, 2.13001E-01_JPRB, &
     & 2.15296E-01_JPRB, 2.17616E-01_JPRB, 2.19961E-01_JPRB, 2.22331E-01_JPRB, 2.24727E-01_JPRB, &
     & 2.27148E-01_JPRB, 2.29596E-01_JPRB, 2.32070E-01_JPRB, 2.34571E-01_JPRB/)
      KAO_MO3( 1, :, 5) = (/ &
     & 5.30785E-01_JPRB, 5.30477E-01_JPRB, 5.30169E-01_JPRB, 5.29861E-01_JPRB, 5.29553E-01_JPRB, &
     & 5.29246E-01_JPRB, 5.28938E-01_JPRB, 5.28631E-01_JPRB, 5.28324E-01_JPRB, 5.28017E-01_JPRB, &
     & 5.27711E-01_JPRB, 5.27404E-01_JPRB, 5.27098E-01_JPRB, 5.26792E-01_JPRB, 5.26486E-01_JPRB, &
     & 5.26180E-01_JPRB, 5.25875E-01_JPRB, 5.25569E-01_JPRB, 5.25264E-01_JPRB/)
      KAO_MO3( 2, :, 5) = (/ &
     & 5.33406E-01_JPRB, 5.32997E-01_JPRB, 5.32587E-01_JPRB, 5.32178E-01_JPRB, 5.31769E-01_JPRB, &
     & 5.31360E-01_JPRB, 5.30952E-01_JPRB, 5.30544E-01_JPRB, 5.30137E-01_JPRB, 5.29729E-01_JPRB, &
     & 5.29322E-01_JPRB, 5.28916E-01_JPRB, 5.28509E-01_JPRB, 5.28103E-01_JPRB, 5.27697E-01_JPRB, &
     & 5.27292E-01_JPRB, 5.26887E-01_JPRB, 5.26482E-01_JPRB, 5.26077E-01_JPRB/)
      KAO_MO3( 3, :, 5) = (/ &
     & 5.39814E-01_JPRB, 5.39234E-01_JPRB, 5.38655E-01_JPRB, 5.38077E-01_JPRB, 5.37499E-01_JPRB, &
     & 5.36922E-01_JPRB, 5.36345E-01_JPRB, 5.35769E-01_JPRB, 5.35194E-01_JPRB, 5.34620E-01_JPRB, &
     & 5.34045E-01_JPRB, 5.33472E-01_JPRB, 5.32899E-01_JPRB, 5.32327E-01_JPRB, 5.31756E-01_JPRB, &
     & 5.31185E-01_JPRB, 5.30614E-01_JPRB, 5.30045E-01_JPRB, 5.29475E-01_JPRB/)
      KAO_MO3( 4, :, 5) = (/ &
     & 5.39054E-01_JPRB, 5.38348E-01_JPRB, 5.37643E-01_JPRB, 5.36938E-01_JPRB, 5.36235E-01_JPRB, &
     & 5.35532E-01_JPRB, 5.34831E-01_JPRB, 5.34130E-01_JPRB, 5.33431E-01_JPRB, 5.32732E-01_JPRB, &
     & 5.32034E-01_JPRB, 5.31337E-01_JPRB, 5.30641E-01_JPRB, 5.29946E-01_JPRB, 5.29252E-01_JPRB, &
     & 5.28559E-01_JPRB, 5.27866E-01_JPRB, 5.27175E-01_JPRB, 5.26484E-01_JPRB/)
      KAO_MO3( 5, :, 5) = (/ &
     & 5.29240E-01_JPRB, 5.28475E-01_JPRB, 5.27711E-01_JPRB, 5.26949E-01_JPRB, 5.26187E-01_JPRB, &
     & 5.25427E-01_JPRB, 5.24668E-01_JPRB, 5.23909E-01_JPRB, 5.23152E-01_JPRB, 5.22396E-01_JPRB, &
     & 5.21641E-01_JPRB, 5.20888E-01_JPRB, 5.20135E-01_JPRB, 5.19383E-01_JPRB, 5.18633E-01_JPRB, &
     & 5.17883E-01_JPRB, 5.17135E-01_JPRB, 5.16388E-01_JPRB, 5.15642E-01_JPRB/)
      KAO_MO3( 6, :, 5) = (/ &
     & 5.21746E-01_JPRB, 5.20815E-01_JPRB, 5.19886E-01_JPRB, 5.18958E-01_JPRB, 5.18032E-01_JPRB, &
     & 5.17107E-01_JPRB, 5.16184E-01_JPRB, 5.15263E-01_JPRB, 5.14343E-01_JPRB, 5.13425E-01_JPRB, &
     & 5.12509E-01_JPRB, 5.11594E-01_JPRB, 5.10681E-01_JPRB, 5.09770E-01_JPRB, 5.08860E-01_JPRB, &
     & 5.07952E-01_JPRB, 5.07045E-01_JPRB, 5.06140E-01_JPRB, 5.05237E-01_JPRB/)
      KAO_MO3( 7, :, 5) = (/ &
     & 5.26752E-01_JPRB, 5.25550E-01_JPRB, 5.24352E-01_JPRB, 5.23156E-01_JPRB, 5.21963E-01_JPRB, &
     & 5.20772E-01_JPRB, 5.19584E-01_JPRB, 5.18399E-01_JPRB, 5.17217E-01_JPRB, 5.16038E-01_JPRB, &
     & 5.14861E-01_JPRB, 5.13686E-01_JPRB, 5.12515E-01_JPRB, 5.11346E-01_JPRB, 5.10180E-01_JPRB, &
     & 5.09016E-01_JPRB, 5.07855E-01_JPRB, 5.06697E-01_JPRB, 5.05541E-01_JPRB/)
      KAO_MO3( 8, :, 5) = (/ &
     & 5.23581E-01_JPRB, 5.22513E-01_JPRB, 5.21446E-01_JPRB, 5.20382E-01_JPRB, 5.19320E-01_JPRB, &
     & 5.18260E-01_JPRB, 5.17203E-01_JPRB, 5.16147E-01_JPRB, 5.15094E-01_JPRB, 5.14042E-01_JPRB, &
     & 5.12993E-01_JPRB, 5.11946E-01_JPRB, 5.10901E-01_JPRB, 5.09859E-01_JPRB, 5.08818E-01_JPRB, &
     & 5.07780E-01_JPRB, 5.06743E-01_JPRB, 5.05709E-01_JPRB, 5.04677E-01_JPRB/)
      KAO_MO3( 9, :, 5) = (/ &
     & 3.80393E-01_JPRB, 3.80680E-01_JPRB, 3.80967E-01_JPRB, 3.81254E-01_JPRB, 3.81542E-01_JPRB, &
     & 3.81829E-01_JPRB, 3.82117E-01_JPRB, 3.82405E-01_JPRB, 3.82693E-01_JPRB, 3.82982E-01_JPRB, &
     & 3.83271E-01_JPRB, 3.83559E-01_JPRB, 3.83849E-01_JPRB, 3.84138E-01_JPRB, 3.84428E-01_JPRB, &
     & 3.84717E-01_JPRB, 3.85007E-01_JPRB, 3.85298E-01_JPRB, 3.85588E-01_JPRB/)
      KAO_MO3( 1, :, 6) = (/ &
     & 6.14818E-01_JPRB, 6.10664E-01_JPRB, 6.06539E-01_JPRB, 6.02441E-01_JPRB, 5.98372E-01_JPRB, &
     & 5.94330E-01_JPRB, 5.90315E-01_JPRB, 5.86327E-01_JPRB, 5.82366E-01_JPRB, 5.78432E-01_JPRB, &
     & 5.74524E-01_JPRB, 5.70643E-01_JPRB, 5.66788E-01_JPRB, 5.62959E-01_JPRB, 5.59156E-01_JPRB, &
     & 5.55379E-01_JPRB, 5.51627E-01_JPRB, 5.47901E-01_JPRB, 5.44199E-01_JPRB/)
      KAO_MO3( 2, :, 6) = (/ &
     & 6.10199E-01_JPRB, 6.06143E-01_JPRB, 6.02114E-01_JPRB, 5.98112E-01_JPRB, 5.94136E-01_JPRB, &
     & 5.90187E-01_JPRB, 5.86264E-01_JPRB, 5.82367E-01_JPRB, 5.78496E-01_JPRB, 5.74651E-01_JPRB, &
     & 5.70831E-01_JPRB, 5.67037E-01_JPRB, 5.63268E-01_JPRB, 5.59524E-01_JPRB, 5.55805E-01_JPRB, &
     & 5.52110E-01_JPRB, 5.48440E-01_JPRB, 5.44795E-01_JPRB, 5.41174E-01_JPRB/)
      KAO_MO3( 3, :, 6) = (/ &
     & 6.02949E-01_JPRB, 5.99057E-01_JPRB, 5.95190E-01_JPRB, 5.91348E-01_JPRB, 5.87531E-01_JPRB, &
     & 5.83739E-01_JPRB, 5.79971E-01_JPRB, 5.76227E-01_JPRB, 5.72508E-01_JPRB, 5.68812E-01_JPRB, &
     & 5.65140E-01_JPRB, 5.61493E-01_JPRB, 5.57868E-01_JPRB, 5.54267E-01_JPRB, 5.50690E-01_JPRB, &
     & 5.47135E-01_JPRB, 5.43603E-01_JPRB, 5.40094E-01_JPRB, 5.36608E-01_JPRB/)
      KAO_MO3( 4, :, 6) = (/ &
     & 6.05047E-01_JPRB, 6.01155E-01_JPRB, 5.97289E-01_JPRB, 5.93448E-01_JPRB, 5.89631E-01_JPRB, &
     & 5.85838E-01_JPRB, 5.82071E-01_JPRB, 5.78327E-01_JPRB, 5.74607E-01_JPRB, 5.70912E-01_JPRB, &
     & 5.67240E-01_JPRB, 5.63592E-01_JPRB, 5.59967E-01_JPRB, 5.56365E-01_JPRB, 5.52787E-01_JPRB, &
     & 5.49232E-01_JPRB, 5.45699E-01_JPRB, 5.42190E-01_JPRB, 5.38703E-01_JPRB/)
      KAO_MO3( 5, :, 6) = (/ &
     & 6.03593E-01_JPRB, 5.99867E-01_JPRB, 5.96164E-01_JPRB, 5.92483E-01_JPRB, 5.88825E-01_JPRB, &
     & 5.85190E-01_JPRB, 5.81577E-01_JPRB, 5.77987E-01_JPRB, 5.74419E-01_JPRB, 5.70872E-01_JPRB, &
     & 5.67348E-01_JPRB, 5.63846E-01_JPRB, 5.60365E-01_JPRB, 5.56905E-01_JPRB, 5.53467E-01_JPRB, &
     & 5.50050E-01_JPRB, 5.46654E-01_JPRB, 5.43279E-01_JPRB, 5.39926E-01_JPRB/)
      KAO_MO3( 6, :, 6) = (/ &
     & 6.03940E-01_JPRB, 6.00224E-01_JPRB, 5.96531E-01_JPRB, 5.92861E-01_JPRB, 5.89213E-01_JPRB, &
     & 5.85588E-01_JPRB, 5.81985E-01_JPRB, 5.78404E-01_JPRB, 5.74845E-01_JPRB, 5.71308E-01_JPRB, &
     & 5.67793E-01_JPRB, 5.64299E-01_JPRB, 5.60827E-01_JPRB, 5.57377E-01_JPRB, 5.53947E-01_JPRB, &
     & 5.50539E-01_JPRB, 5.47151E-01_JPRB, 5.43785E-01_JPRB, 5.40439E-01_JPRB/)
      KAO_MO3( 7, :, 6) = (/ &
     & 6.06242E-01_JPRB, 6.02257E-01_JPRB, 5.98299E-01_JPRB, 5.94367E-01_JPRB, 5.90461E-01_JPRB, &
     & 5.86580E-01_JPRB, 5.82725E-01_JPRB, 5.78895E-01_JPRB, 5.75090E-01_JPRB, 5.71311E-01_JPRB, &
     & 5.67556E-01_JPRB, 5.63826E-01_JPRB, 5.60120E-01_JPRB, 5.56439E-01_JPRB, 5.52782E-01_JPRB, &
     & 5.49149E-01_JPRB, 5.45540E-01_JPRB, 5.41954E-01_JPRB, 5.38393E-01_JPRB/)
      KAO_MO3( 8, :, 6) = (/ &
     & 6.11929E-01_JPRB, 6.07173E-01_JPRB, 6.02454E-01_JPRB, 5.97773E-01_JPRB, 5.93127E-01_JPRB, &
     & 5.88518E-01_JPRB, 5.83944E-01_JPRB, 5.79406E-01_JPRB, 5.74903E-01_JPRB, 5.70436E-01_JPRB, &
     & 5.66002E-01_JPRB, 5.61604E-01_JPRB, 5.57239E-01_JPRB, 5.52909E-01_JPRB, 5.48612E-01_JPRB, &
     & 5.44349E-01_JPRB, 5.40118E-01_JPRB, 5.35921E-01_JPRB, 5.31756E-01_JPRB/)
      KAO_MO3( 9, :, 6) = (/ &
     & 6.21189E-01_JPRB, 6.17338E-01_JPRB, 6.13511E-01_JPRB, 6.09707E-01_JPRB, 6.05927E-01_JPRB, &
     & 6.02170E-01_JPRB, 5.98437E-01_JPRB, 5.94726E-01_JPRB, 5.91039E-01_JPRB, 5.87375E-01_JPRB, &
     & 5.83733E-01_JPRB, 5.80114E-01_JPRB, 5.76517E-01_JPRB, 5.72943E-01_JPRB, 5.69390E-01_JPRB, &
     & 5.65860E-01_JPRB, 5.62352E-01_JPRB, 5.58865E-01_JPRB, 5.55400E-01_JPRB/)
      KAO_MO3( 1, :, 7) = (/ &
     & 7.41310E-01_JPRB, 7.30108E-01_JPRB, 7.19075E-01_JPRB, 7.08209E-01_JPRB, 6.97507E-01_JPRB, &
     & 6.86967E-01_JPRB, 6.76586E-01_JPRB, 6.66362E-01_JPRB, 6.56292E-01_JPRB, 6.46374E-01_JPRB, &
     & 6.36607E-01_JPRB, 6.26987E-01_JPRB, 6.17512E-01_JPRB, 6.08181E-01_JPRB, 5.98990E-01_JPRB, &
     & 5.89939E-01_JPRB, 5.81024E-01_JPRB, 5.72244E-01_JPRB, 5.63597E-01_JPRB/)
      KAO_MO3( 2, :, 7) = (/ &
     & 7.38780E-01_JPRB, 7.27631E-01_JPRB, 7.16651E-01_JPRB, 7.05836E-01_JPRB, 6.95185E-01_JPRB, &
     & 6.84695E-01_JPRB, 6.74362E-01_JPRB, 6.64186E-01_JPRB, 6.54163E-01_JPRB, 6.44292E-01_JPRB, &
     & 6.34569E-01_JPRB, 6.24993E-01_JPRB, 6.15562E-01_JPRB, 6.06273E-01_JPRB, 5.97124E-01_JPRB, &
     & 5.88113E-01_JPRB, 5.79238E-01_JPRB, 5.70498E-01_JPRB, 5.61889E-01_JPRB/)
      KAO_MO3( 3, :, 7) = (/ &
     & 7.33846E-01_JPRB, 7.22799E-01_JPRB, 7.11919E-01_JPRB, 7.01203E-01_JPRB, 6.90648E-01_JPRB, &
     & 6.80252E-01_JPRB, 6.70012E-01_JPRB, 6.59927E-01_JPRB, 6.49993E-01_JPRB, 6.40209E-01_JPRB, &
     & 6.30572E-01_JPRB, 6.21080E-01_JPRB, 6.11731E-01_JPRB, 6.02523E-01_JPRB, 5.93453E-01_JPRB, &
     & 5.84520E-01_JPRB, 5.75721E-01_JPRB, 5.67055E-01_JPRB, 5.58519E-01_JPRB/)
      KAO_MO3( 4, :, 7) = (/ &
     & 7.21218E-01_JPRB, 7.10492E-01_JPRB, 6.99926E-01_JPRB, 6.89517E-01_JPRB, 6.79262E-01_JPRB, &
     & 6.69160E-01_JPRB, 6.59209E-01_JPRB, 6.49405E-01_JPRB, 6.39747E-01_JPRB, 6.30233E-01_JPRB, &
     & 6.20860E-01_JPRB, 6.11627E-01_JPRB, 6.02531E-01_JPRB, 5.93570E-01_JPRB, 5.84743E-01_JPRB, &
     & 5.76047E-01_JPRB, 5.67480E-01_JPRB, 5.59040E-01_JPRB, 5.50726E-01_JPRB/)
      KAO_MO3( 5, :, 7) = (/ &
     & 7.10588E-01_JPRB, 7.00014E-01_JPRB, 6.89596E-01_JPRB, 6.79334E-01_JPRB, 6.69225E-01_JPRB, &
     & 6.59266E-01_JPRB, 6.49455E-01_JPRB, 6.39790E-01_JPRB, 6.30269E-01_JPRB, 6.20889E-01_JPRB, &
     & 6.11650E-01_JPRB, 6.02547E-01_JPRB, 5.93581E-01_JPRB, 5.84747E-01_JPRB, 5.76045E-01_JPRB, &
     & 5.67473E-01_JPRB, 5.59028E-01_JPRB, 5.50709E-01_JPRB, 5.42513E-01_JPRB/)
      KAO_MO3( 6, :, 7) = (/ &
     & 6.98166E-01_JPRB, 6.87706E-01_JPRB, 6.77402E-01_JPRB, 6.67253E-01_JPRB, 6.57256E-01_JPRB, &
     & 6.47408E-01_JPRB, 6.37708E-01_JPRB, 6.28154E-01_JPRB, 6.18742E-01_JPRB, 6.09472E-01_JPRB, &
     & 6.00340E-01_JPRB, 5.91346E-01_JPRB, 5.82486E-01_JPRB, 5.73758E-01_JPRB, 5.65162E-01_JPRB, &
     & 5.56694E-01_JPRB, 5.48353E-01_JPRB, 5.40138E-01_JPRB, 5.32045E-01_JPRB/)
      KAO_MO3( 7, :, 7) = (/ &
     & 6.76974E-01_JPRB, 6.67034E-01_JPRB, 6.57240E-01_JPRB, 6.47590E-01_JPRB, 6.38081E-01_JPRB, &
     & 6.28712E-01_JPRB, 6.19481E-01_JPRB, 6.10385E-01_JPRB, 6.01422E-01_JPRB, 5.92592E-01_JPRB, &
     & 5.83891E-01_JPRB, 5.75317E-01_JPRB, 5.66870E-01_JPRB, 5.58547E-01_JPRB, 5.50345E-01_JPRB, &
     & 5.42265E-01_JPRB, 5.34303E-01_JPRB, 5.26457E-01_JPRB, 5.18727E-01_JPRB/)
      KAO_MO3( 8, :, 7) = (/ &
     & 6.30061E-01_JPRB, 6.21017E-01_JPRB, 6.12102E-01_JPRB, 6.03316E-01_JPRB, 5.94656E-01_JPRB, &
     & 5.86120E-01_JPRB, 5.77706E-01_JPRB, 5.69414E-01_JPRB, 5.61240E-01_JPRB, 5.53184E-01_JPRB, &
     & 5.45243E-01_JPRB, 5.37416E-01_JPRB, 5.29702E-01_JPRB, 5.22098E-01_JPRB, 5.14604E-01_JPRB, &
     & 5.07217E-01_JPRB, 4.99936E-01_JPRB, 4.92760E-01_JPRB, 4.85687E-01_JPRB/)
      KAO_MO3( 9, :, 7) = (/ &
     & 8.97633E-01_JPRB, 8.87307E-01_JPRB, 8.77100E-01_JPRB, 8.67010E-01_JPRB, 8.57036E-01_JPRB, &
     & 8.47176E-01_JPRB, 8.37431E-01_JPRB, 8.27797E-01_JPRB, 8.18274E-01_JPRB, 8.08861E-01_JPRB, &
     & 7.99555E-01_JPRB, 7.90357E-01_JPRB, 7.81265E-01_JPRB, 7.72278E-01_JPRB, 7.63393E-01_JPRB, &
     & 7.54611E-01_JPRB, 7.45930E-01_JPRB, 7.37349E-01_JPRB, 7.28867E-01_JPRB/)
      KAO_MO3( 1, :, 8) = (/ &
     & 4.87356E-01_JPRB, 4.80743E-01_JPRB, 4.74220E-01_JPRB, 4.67785E-01_JPRB, 4.61437E-01_JPRB, &
     & 4.55176E-01_JPRB, 4.49000E-01_JPRB, 4.42907E-01_JPRB, 4.36897E-01_JPRB, 4.30969E-01_JPRB, &
     & 4.25121E-01_JPRB, 4.19353E-01_JPRB, 4.13663E-01_JPRB, 4.08049E-01_JPRB, 4.02513E-01_JPRB, &
     & 3.97051E-01_JPRB, 3.91663E-01_JPRB, 3.86349E-01_JPRB, 3.81106E-01_JPRB/)
      KAO_MO3( 2, :, 8) = (/ &
     & 4.86776E-01_JPRB, 4.80157E-01_JPRB, 4.73627E-01_JPRB, 4.67187E-01_JPRB, 4.60834E-01_JPRB, &
     & 4.54567E-01_JPRB, 4.48386E-01_JPRB, 4.42289E-01_JPRB, 4.36274E-01_JPRB, 4.30342E-01_JPRB, &
     & 4.24490E-01_JPRB, 4.18718E-01_JPRB, 4.13024E-01_JPRB, 4.07407E-01_JPRB, 4.01867E-01_JPRB, &
     & 3.96403E-01_JPRB, 3.91012E-01_JPRB, 3.85695E-01_JPRB, 3.80450E-01_JPRB/)
      KAO_MO3( 3, :, 8) = (/ &
     & 4.86111E-01_JPRB, 4.79496E-01_JPRB, 4.72972E-01_JPRB, 4.66536E-01_JPRB, 4.60188E-01_JPRB, &
     & 4.53926E-01_JPRB, 4.47750E-01_JPRB, 4.41657E-01_JPRB, 4.35648E-01_JPRB, 4.29720E-01_JPRB, &
     & 4.23873E-01_JPRB, 4.18105E-01_JPRB, 4.12416E-01_JPRB, 4.06804E-01_JPRB, 4.01269E-01_JPRB, &
     & 3.95809E-01_JPRB, 3.90423E-01_JPRB, 3.85111E-01_JPRB, 3.79871E-01_JPRB/)
      KAO_MO3( 4, :, 8) = (/ &
     & 4.85501E-01_JPRB, 4.78880E-01_JPRB, 4.72350E-01_JPRB, 4.65908E-01_JPRB, 4.59554E-01_JPRB, &
     & 4.53288E-01_JPRB, 4.47106E-01_JPRB, 4.41009E-01_JPRB, 4.34995E-01_JPRB, 4.29063E-01_JPRB, &
     & 4.23211E-01_JPRB, 4.17440E-01_JPRB, 4.11747E-01_JPRB, 4.06132E-01_JPRB, 4.00594E-01_JPRB, &
     & 3.95131E-01_JPRB, 3.89743E-01_JPRB, 3.84428E-01_JPRB, 3.79185E-01_JPRB/)
      KAO_MO3( 5, :, 8) = (/ &
     & 4.83679E-01_JPRB, 4.77140E-01_JPRB, 4.70691E-01_JPRB, 4.64328E-01_JPRB, 4.58051E-01_JPRB, &
     & 4.51859E-01_JPRB, 4.45751E-01_JPRB, 4.39726E-01_JPRB, 4.33781E-01_JPRB, 4.27918E-01_JPRB, &
     & 4.22133E-01_JPRB, 4.16427E-01_JPRB, 4.10798E-01_JPRB, 4.05245E-01_JPRB, 3.99767E-01_JPRB, &
     & 3.94363E-01_JPRB, 3.89032E-01_JPRB, 3.83773E-01_JPRB, 3.78585E-01_JPRB/)
      KAO_MO3( 6, :, 8) = (/ &
     & 4.72120E-01_JPRB, 4.65834E-01_JPRB, 4.59630E-01_JPRB, 4.53510E-01_JPRB, 4.47471E-01_JPRB, &
     & 4.41513E-01_JPRB, 4.35633E-01_JPRB, 4.29833E-01_JPRB, 4.24109E-01_JPRB, 4.18461E-01_JPRB, &
     & 4.12889E-01_JPRB, 4.07391E-01_JPRB, 4.01966E-01_JPRB, 3.96614E-01_JPRB, 3.91332E-01_JPRB, &
     & 3.86122E-01_JPRB, 3.80980E-01_JPRB, 3.75907E-01_JPRB, 3.70901E-01_JPRB/)
      KAO_MO3( 7, :, 8) = (/ &
     & 4.58683E-01_JPRB, 4.52758E-01_JPRB, 4.46909E-01_JPRB, 4.41135E-01_JPRB, 4.35437E-01_JPRB, &
     & 4.29812E-01_JPRB, 4.24259E-01_JPRB, 4.18779E-01_JPRB, 4.13369E-01_JPRB, 4.08029E-01_JPRB, &
     & 4.02758E-01_JPRB, 3.97555E-01_JPRB, 3.92419E-01_JPRB, 3.87350E-01_JPRB, 3.82346E-01_JPRB, &
     & 3.77406E-01_JPRB, 3.72531E-01_JPRB, 3.67719E-01_JPRB, 3.62968E-01_JPRB/)
      KAO_MO3( 8, :, 8) = (/ &
     & 4.56091E-01_JPRB, 4.50481E-01_JPRB, 4.44940E-01_JPRB, 4.39467E-01_JPRB, 4.34062E-01_JPRB, &
     & 4.28722E-01_JPRB, 4.23449E-01_JPRB, 4.18240E-01_JPRB, 4.13096E-01_JPRB, 4.08015E-01_JPRB, &
     & 4.02996E-01_JPRB, 3.98039E-01_JPRB, 3.93143E-01_JPRB, 3.88307E-01_JPRB, 3.83531E-01_JPRB, &
     & 3.78813E-01_JPRB, 3.74154E-01_JPRB, 3.69552E-01_JPRB, 3.65006E-01_JPRB/)
      KAO_MO3( 9, :, 8) = (/ &
     & 9.11213E-01_JPRB, 9.03270E-01_JPRB, 8.95396E-01_JPRB, 8.87591E-01_JPRB, 8.79855E-01_JPRB, &
     & 8.72185E-01_JPRB, 8.64583E-01_JPRB, 8.57046E-01_JPRB, 8.49576E-01_JPRB, 8.42170E-01_JPRB, &
     & 8.34829E-01_JPRB, 8.27552E-01_JPRB, 8.20339E-01_JPRB, 8.13188E-01_JPRB, 8.06100E-01_JPRB, &
     & 7.99073E-01_JPRB, 7.92108E-01_JPRB, 7.85204E-01_JPRB, 7.78359E-01_JPRB/)
      KAO_MO3( 1, :, 9) = (/ &
     & 5.56194E-01_JPRB, 5.48595E-01_JPRB, 5.41100E-01_JPRB, 5.33707E-01_JPRB, 5.26415E-01_JPRB, &
     & 5.19223E-01_JPRB, 5.12129E-01_JPRB, 5.05132E-01_JPRB, 4.98231E-01_JPRB, 4.91424E-01_JPRB, &
     & 4.84710E-01_JPRB, 4.78087E-01_JPRB, 4.71556E-01_JPRB, 4.65113E-01_JPRB, 4.58758E-01_JPRB, &
     & 4.52491E-01_JPRB, 4.46309E-01_JPRB, 4.40211E-01_JPRB, 4.34197E-01_JPRB/)
      KAO_MO3( 2, :, 9) = (/ &
     & 5.56174E-01_JPRB, 5.48575E-01_JPRB, 5.41079E-01_JPRB, 5.33687E-01_JPRB, 5.26395E-01_JPRB, &
     & 5.19203E-01_JPRB, 5.12109E-01_JPRB, 5.05112E-01_JPRB, 4.98211E-01_JPRB, 4.91404E-01_JPRB, &
     & 4.84690E-01_JPRB, 4.78068E-01_JPRB, 4.71536E-01_JPRB, 4.65093E-01_JPRB, 4.58739E-01_JPRB, &
     & 4.52471E-01_JPRB, 4.46289E-01_JPRB, 4.40191E-01_JPRB, 4.34177E-01_JPRB/)
      KAO_MO3( 3, :, 9) = (/ &
     & 5.55996E-01_JPRB, 5.48403E-01_JPRB, 5.40913E-01_JPRB, 5.33526E-01_JPRB, 5.26239E-01_JPRB, &
     & 5.19052E-01_JPRB, 5.11963E-01_JPRB, 5.04971E-01_JPRB, 4.98074E-01_JPRB, 4.91272E-01_JPRB, &
     & 4.84562E-01_JPRB, 4.77944E-01_JPRB, 4.71417E-01_JPRB, 4.64978E-01_JPRB, 4.58628E-01_JPRB, &
     & 4.52364E-01_JPRB, 4.46186E-01_JPRB, 4.40092E-01_JPRB, 4.34081E-01_JPRB/)
      KAO_MO3( 4, :, 9) = (/ &
     & 5.55859E-01_JPRB, 5.48271E-01_JPRB, 5.40786E-01_JPRB, 5.33404E-01_JPRB, 5.26123E-01_JPRB, &
     & 5.18941E-01_JPRB, 5.11856E-01_JPRB, 5.04869E-01_JPRB, 4.97977E-01_JPRB, 4.91179E-01_JPRB, &
     & 4.84474E-01_JPRB, 4.77861E-01_JPRB, 4.71337E-01_JPRB, 4.64903E-01_JPRB, 4.58557E-01_JPRB, &
     & 4.52297E-01_JPRB, 4.46123E-01_JPRB, 4.40033E-01_JPRB, 4.34026E-01_JPRB/)
      KAO_MO3( 5, :, 9) = (/ &
     & 5.54550E-01_JPRB, 5.46921E-01_JPRB, 5.39397E-01_JPRB, 5.31976E-01_JPRB, 5.24657E-01_JPRB, &
     & 5.17439E-01_JPRB, 5.10320E-01_JPRB, 5.03300E-01_JPRB, 4.96376E-01_JPRB, 4.89547E-01_JPRB, &
     & 4.82812E-01_JPRB, 4.76170E-01_JPRB, 4.69619E-01_JPRB, 4.63158E-01_JPRB, 4.56786E-01_JPRB, &
     & 4.50502E-01_JPRB, 4.44304E-01_JPRB, 4.38192E-01_JPRB, 4.32163E-01_JPRB/)
      KAO_MO3( 6, :, 9) = (/ &
     & 5.53514E-01_JPRB, 5.45883E-01_JPRB, 5.38358E-01_JPRB, 5.30937E-01_JPRB, 5.23618E-01_JPRB, &
     & 5.16399E-01_JPRB, 5.09280E-01_JPRB, 5.02260E-01_JPRB, 4.95336E-01_JPRB, 4.88507E-01_JPRB, &
     & 4.81773E-01_JPRB, 4.75132E-01_JPRB, 4.68582E-01_JPRB, 4.62122E-01_JPRB, 4.55752E-01_JPRB, &
     & 4.49469E-01_JPRB, 4.43273E-01_JPRB, 4.37162E-01_JPRB, 4.31136E-01_JPRB/)
      KAO_MO3( 7, :, 9) = (/ &
     & 5.49865E-01_JPRB, 5.42303E-01_JPRB, 5.34846E-01_JPRB, 5.27491E-01_JPRB, 5.20237E-01_JPRB, &
     & 5.13084E-01_JPRB, 5.06028E-01_JPRB, 4.99070E-01_JPRB, 4.92207E-01_JPRB, 4.85438E-01_JPRB, &
     & 4.78763E-01_JPRB, 4.72179E-01_JPRB, 4.65686E-01_JPRB, 4.59282E-01_JPRB, 4.52967E-01_JPRB, &
     & 4.46738E-01_JPRB, 4.40595E-01_JPRB, 4.34536E-01_JPRB, 4.28561E-01_JPRB/)
      KAO_MO3( 8, :, 9) = (/ &
     & 5.25435E-01_JPRB, 5.18437E-01_JPRB, 5.11533E-01_JPRB, 5.04721E-01_JPRB, 4.97999E-01_JPRB, &
     & 4.91367E-01_JPRB, 4.84823E-01_JPRB, 4.78366E-01_JPRB, 4.71996E-01_JPRB, 4.65710E-01_JPRB, &
     & 4.59508E-01_JPRB, 4.53388E-01_JPRB, 4.47350E-01_JPRB, 4.41393E-01_JPRB, 4.35515E-01_JPRB, &
     & 4.29715E-01_JPRB, 4.23992E-01_JPRB, 4.18345E-01_JPRB, 4.12774E-01_JPRB/)
      KAO_MO3( 9, :, 9) = (/ &
     & 3.48228E-01_JPRB, 3.45949E-01_JPRB, 3.43686E-01_JPRB, 3.41437E-01_JPRB, 3.39203E-01_JPRB, &
     & 3.36983E-01_JPRB, 3.34778E-01_JPRB, 3.32588E-01_JPRB, 3.30412E-01_JPRB, 3.28250E-01_JPRB, &
     & 3.26102E-01_JPRB, 3.23968E-01_JPRB, 3.21848E-01_JPRB, 3.19742E-01_JPRB, 3.17650E-01_JPRB, &
     & 3.15572E-01_JPRB, 3.13507E-01_JPRB, 3.11456E-01_JPRB, 3.09418E-01_JPRB/)
      KAO_MO3( 1, :,10) = (/ &
     & 8.34107E-01_JPRB, 8.27276E-01_JPRB, 8.20501E-01_JPRB, 8.13781E-01_JPRB, 8.07117E-01_JPRB, &
     & 8.00507E-01_JPRB, 7.93951E-01_JPRB, 7.87449E-01_JPRB, 7.81000E-01_JPRB, 7.74604E-01_JPRB, &
     & 7.68260E-01_JPRB, 7.61968E-01_JPRB, 7.55728E-01_JPRB, 7.49539E-01_JPRB, 7.43400E-01_JPRB, &
     & 7.37312E-01_JPRB, 7.31274E-01_JPRB, 7.25285E-01_JPRB, 7.19345E-01_JPRB/)
      KAO_MO3( 2, :,10) = (/ &
     & 8.32838E-01_JPRB, 8.26022E-01_JPRB, 8.19263E-01_JPRB, 8.12558E-01_JPRB, 8.05908E-01_JPRB, &
     & 7.99313E-01_JPRB, 7.92772E-01_JPRB, 7.86284E-01_JPRB, 7.79849E-01_JPRB, 7.73467E-01_JPRB, &
     & 7.67137E-01_JPRB, 7.60859E-01_JPRB, 7.54633E-01_JPRB, 7.48457E-01_JPRB, 7.42332E-01_JPRB, &
     & 7.36257E-01_JPRB, 7.30232E-01_JPRB, 7.24256E-01_JPRB, 7.18329E-01_JPRB/)
      KAO_MO3( 3, :,10) = (/ &
     & 8.31167E-01_JPRB, 8.24361E-01_JPRB, 8.17611E-01_JPRB, 8.10916E-01_JPRB, 8.04276E-01_JPRB, &
     & 7.97691E-01_JPRB, 7.91159E-01_JPRB, 7.84681E-01_JPRB, 7.78256E-01_JPRB, 7.71883E-01_JPRB, &
     & 7.65563E-01_JPRB, 7.59294E-01_JPRB, 7.53077E-01_JPRB, 7.46910E-01_JPRB, 7.40795E-01_JPRB, &
     & 7.34729E-01_JPRB, 7.28713E-01_JPRB, 7.22746E-01_JPRB, 7.16828E-01_JPRB/)
      KAO_MO3( 4, :,10) = (/ &
     & 8.29026E-01_JPRB, 8.22246E-01_JPRB, 8.15521E-01_JPRB, 8.08851E-01_JPRB, 8.02236E-01_JPRB, &
     & 7.95675E-01_JPRB, 7.89167E-01_JPRB, 7.82713E-01_JPRB, 7.76312E-01_JPRB, 7.69962E-01_JPRB, &
     & 7.63665E-01_JPRB, 7.57419E-01_JPRB, 7.51225E-01_JPRB, 7.45081E-01_JPRB, 7.38987E-01_JPRB, &
     & 7.32943E-01_JPRB, 7.26949E-01_JPRB, 7.21003E-01_JPRB, 7.15107E-01_JPRB/)
      KAO_MO3( 5, :,10) = (/ &
     & 8.26226E-01_JPRB, 8.19471E-01_JPRB, 8.12771E-01_JPRB, 8.06126E-01_JPRB, 7.99536E-01_JPRB, &
     & 7.92999E-01_JPRB, 7.86515E-01_JPRB, 7.80085E-01_JPRB, 7.73707E-01_JPRB, 7.67382E-01_JPRB, &
     & 7.61108E-01_JPRB, 7.54885E-01_JPRB, 7.48714E-01_JPRB, 7.42592E-01_JPRB, 7.36521E-01_JPRB, &
     & 7.30500E-01_JPRB, 7.24527E-01_JPRB, 7.18604E-01_JPRB, 7.12729E-01_JPRB/)
      KAO_MO3( 6, :,10) = (/ &
     & 8.33246E-01_JPRB, 8.26510E-01_JPRB, 8.19828E-01_JPRB, 8.13200E-01_JPRB, 8.06626E-01_JPRB, &
     & 8.00105E-01_JPRB, 7.93637E-01_JPRB, 7.87221E-01_JPRB, 7.80856E-01_JPRB, 7.74544E-01_JPRB, &
     & 7.68282E-01_JPRB, 7.62071E-01_JPRB, 7.55910E-01_JPRB, 7.49799E-01_JPRB, 7.43737E-01_JPRB, &
     & 7.37725E-01_JPRB, 7.31760E-01_JPRB, 7.25845E-01_JPRB, 7.19977E-01_JPRB/)
      KAO_MO3( 7, :,10) = (/ &
     & 8.45693E-01_JPRB, 8.38967E-01_JPRB, 8.32295E-01_JPRB, 8.25675E-01_JPRB, 8.19108E-01_JPRB, &
     & 8.12594E-01_JPRB, 8.06131E-01_JPRB, 7.99719E-01_JPRB, 7.93359E-01_JPRB, 7.87049E-01_JPRB, &
     & 7.80789E-01_JPRB, 7.74579E-01_JPRB, 7.68419E-01_JPRB, 7.62307E-01_JPRB, 7.56244E-01_JPRB, &
     & 7.50230E-01_JPRB, 7.44263E-01_JPRB, 7.38343E-01_JPRB, 7.32471E-01_JPRB/)
      KAO_MO3( 8, :,10) = (/ &
     & 8.32139E-01_JPRB, 8.25565E-01_JPRB, 8.19044E-01_JPRB, 8.12574E-01_JPRB, 8.06156E-01_JPRB, &
     & 7.99788E-01_JPRB, 7.93470E-01_JPRB, 7.87202E-01_JPRB, 7.80984E-01_JPRB, 7.74815E-01_JPRB, &
     & 7.68694E-01_JPRB, 7.62622E-01_JPRB, 7.56598E-01_JPRB, 7.50622E-01_JPRB, 7.44692E-01_JPRB, &
     & 7.38810E-01_JPRB, 7.32974E-01_JPRB, 7.27184E-01_JPRB, 7.21440E-01_JPRB/)
      KAO_MO3( 9, :,10) = (/ &
     & 2.34258E-01_JPRB, 2.35247E-01_JPRB, 2.36239E-01_JPRB, 2.37236E-01_JPRB, 2.38237E-01_JPRB, &
     & 2.39242E-01_JPRB, 2.40252E-01_JPRB, 2.41265E-01_JPRB, 2.42283E-01_JPRB, 2.43306E-01_JPRB, &
     & 2.44332E-01_JPRB, 2.45363E-01_JPRB, 2.46398E-01_JPRB, 2.47438E-01_JPRB, 2.48482E-01_JPRB, &
     & 2.49531E-01_JPRB, 2.50583E-01_JPRB, 2.51641E-01_JPRB, 2.52702E-01_JPRB/)
      KAO_MO3( 1, :,11) = (/ &
     & 8.31308E-01_JPRB, 8.22153E-01_JPRB, 8.13098E-01_JPRB, 8.04143E-01_JPRB, 7.95287E-01_JPRB, &
     & 7.86528E-01_JPRB, 7.77866E-01_JPRB, 7.69299E-01_JPRB, 7.60827E-01_JPRB, 7.52448E-01_JPRB, &
     & 7.44161E-01_JPRB, 7.35965E-01_JPRB, 7.27860E-01_JPRB, 7.19844E-01_JPRB, 7.11916E-01_JPRB, &
     & 7.04075E-01_JPRB, 6.96321E-01_JPRB, 6.88652E-01_JPRB, 6.81068E-01_JPRB/)
      KAO_MO3( 2, :,11) = (/ &
     & 8.31577E-01_JPRB, 8.22400E-01_JPRB, 8.13324E-01_JPRB, 8.04349E-01_JPRB, 7.95472E-01_JPRB, &
     & 7.86693E-01_JPRB, 7.78011E-01_JPRB, 7.69425E-01_JPRB, 7.60934E-01_JPRB, 7.52537E-01_JPRB, &
     & 7.44232E-01_JPRB, 7.36019E-01_JPRB, 7.27896E-01_JPRB, 7.19863E-01_JPRB, 7.11919E-01_JPRB, &
     & 7.04062E-01_JPRB, 6.96292E-01_JPRB, 6.88608E-01_JPRB, 6.81009E-01_JPRB/)
      KAO_MO3( 3, :,11) = (/ &
     & 8.31578E-01_JPRB, 8.22422E-01_JPRB, 8.13368E-01_JPRB, 8.04413E-01_JPRB, 7.95557E-01_JPRB, &
     & 7.86798E-01_JPRB, 7.78136E-01_JPRB, 7.69569E-01_JPRB, 7.61097E-01_JPRB, 7.52717E-01_JPRB, &
     & 7.44430E-01_JPRB, 7.36235E-01_JPRB, 7.28129E-01_JPRB, 7.20113E-01_JPRB, 7.12185E-01_JPRB, &
     & 7.04344E-01_JPRB, 6.96589E-01_JPRB, 6.88920E-01_JPRB, 6.81336E-01_JPRB/)
      KAO_MO3( 4, :,11) = (/ &
     & 8.31261E-01_JPRB, 8.22111E-01_JPRB, 8.13062E-01_JPRB, 8.04112E-01_JPRB, 7.95261E-01_JPRB, &
     & 7.86507E-01_JPRB, 7.77850E-01_JPRB, 7.69288E-01_JPRB, 7.60820E-01_JPRB, 7.52445E-01_JPRB, &
     & 7.44163E-01_JPRB, 7.35971E-01_JPRB, 7.27870E-01_JPRB, 7.19858E-01_JPRB, 7.11935E-01_JPRB, &
     & 7.04098E-01_JPRB, 6.96348E-01_JPRB, 6.88683E-01_JPRB, 6.81102E-01_JPRB/)
      KAO_MO3( 5, :,11) = (/ &
     & 8.31565E-01_JPRB, 8.22404E-01_JPRB, 8.13344E-01_JPRB, 8.04384E-01_JPRB, 7.95523E-01_JPRB, &
     & 7.86760E-01_JPRB, 7.78092E-01_JPRB, 7.69521E-01_JPRB, 7.61044E-01_JPRB, 7.52660E-01_JPRB, &
     & 7.44368E-01_JPRB, 7.36168E-01_JPRB, 7.28058E-01_JPRB, 7.20038E-01_JPRB, 7.12106E-01_JPRB, &
     & 7.04261E-01_JPRB, 6.96503E-01_JPRB, 6.88830E-01_JPRB, 6.81242E-01_JPRB/)
      KAO_MO3( 6, :,11) = (/ &
     & 8.17636E-01_JPRB, 8.08497E-01_JPRB, 7.99461E-01_JPRB, 7.90525E-01_JPRB, 7.81690E-01_JPRB, &
     & 7.72953E-01_JPRB, 7.64314E-01_JPRB, 7.55771E-01_JPRB, 7.47324E-01_JPRB, 7.38971E-01_JPRB, &
     & 7.30712E-01_JPRB, 7.22545E-01_JPRB, 7.14469E-01_JPRB, 7.06483E-01_JPRB, 6.98587E-01_JPRB, &
     & 6.90779E-01_JPRB, 6.83058E-01_JPRB, 6.75424E-01_JPRB, 6.67875E-01_JPRB/)
      KAO_MO3( 7, :,11) = (/ &
     & 7.95247E-01_JPRB, 7.86140E-01_JPRB, 7.77137E-01_JPRB, 7.68238E-01_JPRB, 7.59440E-01_JPRB, &
     & 7.50743E-01_JPRB, 7.42145E-01_JPRB, 7.33646E-01_JPRB, 7.25245E-01_JPRB, 7.16939E-01_JPRB, &
     & 7.08729E-01_JPRB, 7.00612E-01_JPRB, 6.92589E-01_JPRB, 6.84658E-01_JPRB, 6.76817E-01_JPRB, &
     & 6.69066E-01_JPRB, 6.61404E-01_JPRB, 6.53830E-01_JPRB, 6.46342E-01_JPRB/)
      KAO_MO3( 8, :,11) = (/ &
     & 7.63069E-01_JPRB, 7.54006E-01_JPRB, 7.45051E-01_JPRB, 7.36202E-01_JPRB, 7.27458E-01_JPRB, &
     & 7.18818E-01_JPRB, 7.10281E-01_JPRB, 7.01845E-01_JPRB, 6.93509E-01_JPRB, 6.85272E-01_JPRB, &
     & 6.77133E-01_JPRB, 6.69091E-01_JPRB, 6.61144E-01_JPRB, 6.53292E-01_JPRB, 6.45533E-01_JPRB, &
     & 6.37866E-01_JPRB, 6.30290E-01_JPRB, 6.22804E-01_JPRB, 6.15407E-01_JPRB/)
      KAO_MO3( 9, :,11) = (/ &
     & 2.03255E-01_JPRB, 2.03004E-01_JPRB, 2.02753E-01_JPRB, 2.02502E-01_JPRB, 2.02252E-01_JPRB, &
     & 2.02001E-01_JPRB, 2.01752E-01_JPRB, 2.01502E-01_JPRB, 2.01253E-01_JPRB, 2.01004E-01_JPRB, &
     & 2.00755E-01_JPRB, 2.00507E-01_JPRB, 2.00259E-01_JPRB, 2.00011E-01_JPRB, 1.99764E-01_JPRB, &
     & 1.99517E-01_JPRB, 1.99270E-01_JPRB, 1.99024E-01_JPRB, 1.98777E-01_JPRB/)
      KAO_MO3( 1, :,12) = (/ &
     & 4.13201E-01_JPRB, 4.05258E-01_JPRB, 3.97468E-01_JPRB, 3.89828E-01_JPRB, 3.82334E-01_JPRB, &
     & 3.74985E-01_JPRB, 3.67777E-01_JPRB, 3.60707E-01_JPRB, 3.53774E-01_JPRB, 3.46973E-01_JPRB, &
     & 3.40303E-01_JPRB, 3.33762E-01_JPRB, 3.27346E-01_JPRB, 3.21054E-01_JPRB, 3.14882E-01_JPRB, &
     & 3.08829E-01_JPRB, 3.02893E-01_JPRB, 2.97071E-01_JPRB, 2.91360E-01_JPRB/)
      KAO_MO3( 2, :,12) = (/ &
     & 4.12835E-01_JPRB, 4.04897E-01_JPRB, 3.97112E-01_JPRB, 3.89477E-01_JPRB, 3.81988E-01_JPRB, &
     & 3.74644E-01_JPRB, 3.67440E-01_JPRB, 3.60376E-01_JPRB, 3.53447E-01_JPRB, 3.46651E-01_JPRB, &
     & 3.39986E-01_JPRB, 3.33449E-01_JPRB, 3.27038E-01_JPRB, 3.20750E-01_JPRB, 3.14582E-01_JPRB, &
     & 3.08534E-01_JPRB, 3.02602E-01_JPRB, 2.96784E-01_JPRB, 2.91077E-01_JPRB/)
      KAO_MO3( 3, :,12) = (/ &
     & 4.13023E-01_JPRB, 4.05079E-01_JPRB, 3.97289E-01_JPRB, 3.89648E-01_JPRB, 3.82155E-01_JPRB, &
     & 3.74805E-01_JPRB, 3.67597E-01_JPRB, 3.60527E-01_JPRB, 3.53594E-01_JPRB, 3.46793E-01_JPRB, &
     & 3.40124E-01_JPRB, 3.33583E-01_JPRB, 3.27167E-01_JPRB, 3.20875E-01_JPRB, 3.14704E-01_JPRB, &
     & 3.08652E-01_JPRB, 3.02716E-01_JPRB, 2.96894E-01_JPRB, 2.91184E-01_JPRB/)
      KAO_MO3( 4, :,12) = (/ &
     & 4.13397E-01_JPRB, 4.05437E-01_JPRB, 3.97630E-01_JPRB, 3.89973E-01_JPRB, 3.82463E-01_JPRB, &
     & 3.75099E-01_JPRB, 3.67876E-01_JPRB, 3.60792E-01_JPRB, 3.53844E-01_JPRB, 3.47031E-01_JPRB, &
     & 3.40348E-01_JPRB, 3.33794E-01_JPRB, 3.27367E-01_JPRB, 3.21063E-01_JPRB, 3.14880E-01_JPRB, &
     & 3.08817E-01_JPRB, 3.02870E-01_JPRB, 2.97038E-01_JPRB, 2.91318E-01_JPRB/)
      KAO_MO3( 5, :,12) = (/ &
     & 4.13043E-01_JPRB, 4.05106E-01_JPRB, 3.97321E-01_JPRB, 3.89686E-01_JPRB, 3.82198E-01_JPRB, &
     & 3.74854E-01_JPRB, 3.67651E-01_JPRB, 3.60586E-01_JPRB, 3.53657E-01_JPRB, 3.46861E-01_JPRB, &
     & 3.40195E-01_JPRB, 3.33658E-01_JPRB, 3.27246E-01_JPRB, 3.20958E-01_JPRB, 3.14790E-01_JPRB, &
     & 3.08741E-01_JPRB, 3.02808E-01_JPRB, 2.96990E-01_JPRB, 2.91283E-01_JPRB/)
      KAO_MO3( 6, :,12) = (/ &
     & 4.13151E-01_JPRB, 4.05202E-01_JPRB, 3.97406E-01_JPRB, 3.89760E-01_JPRB, 3.82261E-01_JPRB, &
     & 3.74906E-01_JPRB, 3.67693E-01_JPRB, 3.60619E-01_JPRB, 3.53680E-01_JPRB, 3.46876E-01_JPRB, &
     & 3.40202E-01_JPRB, 3.33656E-01_JPRB, 3.27237E-01_JPRB, 3.20941E-01_JPRB, 3.14766E-01_JPRB, &
     & 3.08710E-01_JPRB, 3.02770E-01_JPRB, 2.96945E-01_JPRB, 2.91232E-01_JPRB/)
      KAO_MO3( 7, :,12) = (/ &
     & 4.13052E-01_JPRB, 4.05109E-01_JPRB, 3.97319E-01_JPRB, 3.89678E-01_JPRB, 3.82185E-01_JPRB, &
     & 3.74835E-01_JPRB, 3.67627E-01_JPRB, 3.60557E-01_JPRB, 3.53624E-01_JPRB, 3.46823E-01_JPRB, &
     & 3.40154E-01_JPRB, 3.33612E-01_JPRB, 3.27197E-01_JPRB, 3.20905E-01_JPRB, 3.14734E-01_JPRB, &
     & 3.08681E-01_JPRB, 3.02745E-01_JPRB, 2.96923E-01_JPRB, 2.91213E-01_JPRB/)
      KAO_MO3( 8, :,12) = (/ &
     & 4.13152E-01_JPRB, 4.05209E-01_JPRB, 3.97418E-01_JPRB, 3.89778E-01_JPRB, 3.82284E-01_JPRB, &
     & 3.74935E-01_JPRB, 3.67727E-01_JPRB, 3.60657E-01_JPRB, 3.53723E-01_JPRB, 3.46923E-01_JPRB, &
     & 3.40253E-01_JPRB, 3.33712E-01_JPRB, 3.27296E-01_JPRB, 3.21004E-01_JPRB, 3.14833E-01_JPRB, &
     & 3.08780E-01_JPRB, 3.02844E-01_JPRB, 2.97021E-01_JPRB, 2.91311E-01_JPRB/)
      KAO_MO3( 9, :,12) = (/ &
     & 1.31008E-01_JPRB, 1.30607E-01_JPRB, 1.30208E-01_JPRB, 1.29810E-01_JPRB, 1.29413E-01_JPRB, &
     & 1.29017E-01_JPRB, 1.28623E-01_JPRB, 1.28229E-01_JPRB, 1.27837E-01_JPRB, 1.27446E-01_JPRB, &
     & 1.27056E-01_JPRB, 1.26668E-01_JPRB, 1.26280E-01_JPRB, 1.25894E-01_JPRB, 1.25509E-01_JPRB, &
     & 1.25125E-01_JPRB, 1.24743E-01_JPRB, 1.24361E-01_JPRB, 1.23981E-01_JPRB/)
      KAO_MO3( 1, :,13) = (/ &
     & 4.66826E-01_JPRB, 4.71437E-01_JPRB, 4.76094E-01_JPRB, 4.80798E-01_JPRB, 4.85547E-01_JPRB, &
     & 4.90344E-01_JPRB, 4.95187E-01_JPRB, 5.00079E-01_JPRB, 5.05019E-01_JPRB, 5.10008E-01_JPRB, &
     & 5.15046E-01_JPRB, 5.20134E-01_JPRB, 5.25272E-01_JPRB, 5.30461E-01_JPRB, 5.35701E-01_JPRB, &
     & 5.40993E-01_JPRB, 5.46338E-01_JPRB, 5.51735E-01_JPRB, 5.57185E-01_JPRB/)
      KAO_MO3( 2, :,13) = (/ &
     & 4.66579E-01_JPRB, 4.71199E-01_JPRB, 4.75865E-01_JPRB, 4.80577E-01_JPRB, 4.85336E-01_JPRB, &
     & 4.90141E-01_JPRB, 4.94995E-01_JPRB, 4.99896E-01_JPRB, 5.04846E-01_JPRB, 5.09845E-01_JPRB, &
     & 5.14893E-01_JPRB, 5.19992E-01_JPRB, 5.25141E-01_JPRB, 5.30340E-01_JPRB, 5.35592E-01_JPRB, &
     & 5.40895E-01_JPRB, 5.46251E-01_JPRB, 5.51660E-01_JPRB, 5.57122E-01_JPRB/)
      KAO_MO3( 3, :,13) = (/ &
     & 4.66956E-01_JPRB, 4.71567E-01_JPRB, 4.76224E-01_JPRB, 4.80927E-01_JPRB, 4.85677E-01_JPRB, &
     & 4.90474E-01_JPRB, 4.95318E-01_JPRB, 5.00209E-01_JPRB, 5.05149E-01_JPRB, 5.10138E-01_JPRB, &
     & 5.15176E-01_JPRB, 5.20264E-01_JPRB, 5.25402E-01_JPRB, 5.30591E-01_JPRB, 5.35831E-01_JPRB, &
     & 5.41123E-01_JPRB, 5.46467E-01_JPRB, 5.51864E-01_JPRB, 5.57314E-01_JPRB/)
      KAO_MO3( 4, :,13) = (/ &
     & 4.66456E-01_JPRB, 4.71080E-01_JPRB, 4.75750E-01_JPRB, 4.80467E-01_JPRB, 4.85230E-01_JPRB, &
     & 4.90040E-01_JPRB, 4.94898E-01_JPRB, 4.99804E-01_JPRB, 5.04759E-01_JPRB, 5.09763E-01_JPRB, &
     & 5.14817E-01_JPRB, 5.19920E-01_JPRB, 5.25075E-01_JPRB, 5.30280E-01_JPRB, 5.35537E-01_JPRB, &
     & 5.40846E-01_JPRB, 5.46208E-01_JPRB, 5.51622E-01_JPRB, 5.57091E-01_JPRB/)
      KAO_MO3( 5, :,13) = (/ &
     & 4.66853E-01_JPRB, 4.71456E-01_JPRB, 4.76104E-01_JPRB, 4.80798E-01_JPRB, 4.85539E-01_JPRB, &
     & 4.90326E-01_JPRB, 4.95160E-01_JPRB, 5.00042E-01_JPRB, 5.04973E-01_JPRB, 5.09952E-01_JPRB, &
     & 5.14979E-01_JPRB, 5.20057E-01_JPRB, 5.25185E-01_JPRB, 5.30363E-01_JPRB, 5.35592E-01_JPRB, &
     & 5.40873E-01_JPRB, 5.46205E-01_JPRB, 5.51591E-01_JPRB, 5.57029E-01_JPRB/)
      KAO_MO3( 6, :,13) = (/ &
     & 4.66832E-01_JPRB, 4.71448E-01_JPRB, 4.76110E-01_JPRB, 4.80817E-01_JPRB, 4.85571E-01_JPRB, &
     & 4.90372E-01_JPRB, 4.95221E-01_JPRB, 5.00118E-01_JPRB, 5.05063E-01_JPRB, 5.10056E-01_JPRB, &
     & 5.15100E-01_JPRB, 5.20193E-01_JPRB, 5.25336E-01_JPRB, 5.30531E-01_JPRB, 5.35776E-01_JPRB, &
     & 5.41074E-01_JPRB, 5.46424E-01_JPRB, 5.51826E-01_JPRB, 5.57283E-01_JPRB/)
      KAO_MO3( 7, :,13) = (/ &
     & 4.66679E-01_JPRB, 4.71299E-01_JPRB, 4.75965E-01_JPRB, 4.80677E-01_JPRB, 4.85436E-01_JPRB, &
     & 4.90241E-01_JPRB, 4.95095E-01_JPRB, 4.99996E-01_JPRB, 5.04946E-01_JPRB, 5.09945E-01_JPRB, &
     & 5.14993E-01_JPRB, 5.20092E-01_JPRB, 5.25240E-01_JPRB, 5.30440E-01_JPRB, 5.35692E-01_JPRB, &
     & 5.40995E-01_JPRB, 5.46351E-01_JPRB, 5.51759E-01_JPRB, 5.57222E-01_JPRB/)
      KAO_MO3( 8, :,13) = (/ &
     & 4.66982E-01_JPRB, 4.71598E-01_JPRB, 4.76260E-01_JPRB, 4.80967E-01_JPRB, 4.85721E-01_JPRB, &
     & 4.90522E-01_JPRB, 4.95371E-01_JPRB, 5.00268E-01_JPRB, 5.05213E-01_JPRB, 5.10206E-01_JPRB, &
     & 5.15250E-01_JPRB, 5.20343E-01_JPRB, 5.25486E-01_JPRB, 5.30680E-01_JPRB, 5.35926E-01_JPRB, &
     & 5.41223E-01_JPRB, 5.46573E-01_JPRB, 5.51976E-01_JPRB, 5.57432E-01_JPRB/)
      KAO_MO3( 9, :,13) = (/ &
     & 1.13709E-01_JPRB, 1.13141E-01_JPRB, 1.12576E-01_JPRB, 1.12013E-01_JPRB, 1.11453E-01_JPRB, &
     & 1.10897E-01_JPRB, 1.10342E-01_JPRB, 1.09791E-01_JPRB, 1.09242E-01_JPRB, 1.08696E-01_JPRB, &
     & 1.08153E-01_JPRB, 1.07613E-01_JPRB, 1.07075E-01_JPRB, 1.06540E-01_JPRB, 1.06007E-01_JPRB, &
     & 1.05478E-01_JPRB, 1.04951E-01_JPRB, 1.04426E-01_JPRB, 1.03904E-01_JPRB/)
      KAO_MO3( 1, :,14) = (/ &
     & 5.67608E-01_JPRB, 5.55796E-01_JPRB, 5.44230E-01_JPRB, 5.32904E-01_JPRB, 5.21814E-01_JPRB, &
     & 5.10955E-01_JPRB, 5.00322E-01_JPRB, 4.89910E-01_JPRB, 4.79714E-01_JPRB, 4.69731E-01_JPRB, &
     & 4.59956E-01_JPRB, 4.50384E-01_JPRB, 4.41011E-01_JPRB, 4.31834E-01_JPRB, 4.22847E-01_JPRB, &
     & 4.14048E-01_JPRB, 4.05431E-01_JPRB, 3.96994E-01_JPRB, 3.88732E-01_JPRB/)
      KAO_MO3( 2, :,14) = (/ &
     & 5.67766E-01_JPRB, 5.55948E-01_JPRB, 5.44376E-01_JPRB, 5.33045E-01_JPRB, 5.21950E-01_JPRB, &
     & 5.11086E-01_JPRB, 5.00448E-01_JPRB, 4.90031E-01_JPRB, 4.79831E-01_JPRB, 4.69844E-01_JPRB, &
     & 4.60064E-01_JPRB, 4.50488E-01_JPRB, 4.41111E-01_JPRB, 4.31930E-01_JPRB, 4.22939E-01_JPRB, &
     & 4.14136E-01_JPRB, 4.05516E-01_JPRB, 3.97075E-01_JPRB, 3.88810E-01_JPRB/)
      KAO_MO3( 3, :,14) = (/ &
     & 5.67460E-01_JPRB, 5.55647E-01_JPRB, 5.44080E-01_JPRB, 5.32754E-01_JPRB, 5.21664E-01_JPRB, &
     & 5.10805E-01_JPRB, 5.00172E-01_JPRB, 4.89760E-01_JPRB, 4.79564E-01_JPRB, 4.69582E-01_JPRB, &
     & 4.59806E-01_JPRB, 4.50235E-01_JPRB, 4.40862E-01_JPRB, 4.31685E-01_JPRB, 4.22699E-01_JPRB, &
     & 4.13900E-01_JPRB, 4.05284E-01_JPRB, 3.96847E-01_JPRB, 3.88586E-01_JPRB/)
      KAO_MO3( 4, :,14) = (/ &
     & 5.67925E-01_JPRB, 5.56107E-01_JPRB, 5.44536E-01_JPRB, 5.33205E-01_JPRB, 5.22110E-01_JPRB, &
     & 5.11246E-01_JPRB, 5.00608E-01_JPRB, 4.90191E-01_JPRB, 4.79991E-01_JPRB, 4.70004E-01_JPRB, &
     & 4.60224E-01_JPRB, 4.50647E-01_JPRB, 4.41270E-01_JPRB, 4.32088E-01_JPRB, 4.23097E-01_JPRB, &
     & 4.14293E-01_JPRB, 4.05673E-01_JPRB, 3.97231E-01_JPRB, 3.88966E-01_JPRB/)
      KAO_MO3( 5, :,14) = (/ &
     & 5.67520E-01_JPRB, 5.55733E-01_JPRB, 5.44190E-01_JPRB, 5.32887E-01_JPRB, 5.21818E-01_JPRB, &
     & 5.10980E-01_JPRB, 5.00366E-01_JPRB, 4.89974E-01_JPRB, 4.79797E-01_JPRB, 4.69831E-01_JPRB, &
     & 4.60072E-01_JPRB, 4.50516E-01_JPRB, 4.41159E-01_JPRB, 4.31996E-01_JPRB, 4.23023E-01_JPRB, &
     & 4.14236E-01_JPRB, 4.05633E-01_JPRB, 3.97207E-01_JPRB, 3.88957E-01_JPRB/)
      KAO_MO3( 6, :,14) = (/ &
     & 5.67549E-01_JPRB, 5.55749E-01_JPRB, 5.44195E-01_JPRB, 5.32880E-01_JPRB, 5.21801E-01_JPRB, &
     & 5.10952E-01_JPRB, 5.00329E-01_JPRB, 4.89927E-01_JPRB, 4.79740E-01_JPRB, 4.69766E-01_JPRB, &
     & 4.59999E-01_JPRB, 4.50435E-01_JPRB, 4.41070E-01_JPRB, 4.31900E-01_JPRB, 4.22920E-01_JPRB, &
     & 4.14127E-01_JPRB, 4.05517E-01_JPRB, 3.97086E-01_JPRB, 3.88830E-01_JPRB/)
      KAO_MO3( 7, :,14) = (/ &
     & 5.67727E-01_JPRB, 5.55909E-01_JPRB, 5.44337E-01_JPRB, 5.33005E-01_JPRB, 5.21910E-01_JPRB, &
     & 5.11046E-01_JPRB, 5.00408E-01_JPRB, 4.89991E-01_JPRB, 4.79791E-01_JPRB, 4.69804E-01_JPRB, &
     & 4.60024E-01_JPRB, 4.50448E-01_JPRB, 4.41071E-01_JPRB, 4.31890E-01_JPRB, 4.22900E-01_JPRB, &
     & 4.14096E-01_JPRB, 4.05476E-01_JPRB, 3.97036E-01_JPRB, 3.88771E-01_JPRB/)
      KAO_MO3( 8, :,14) = (/ &
     & 5.67795E-01_JPRB, 5.55965E-01_JPRB, 5.44381E-01_JPRB, 5.33039E-01_JPRB, 5.21933E-01_JPRB, &
     & 5.11058E-01_JPRB, 5.00410E-01_JPRB, 4.89984E-01_JPRB, 4.79775E-01_JPRB, 4.69779E-01_JPRB, &
     & 4.59991E-01_JPRB, 4.50407E-01_JPRB, 4.41023E-01_JPRB, 4.31834E-01_JPRB, 4.22836E-01_JPRB, &
     & 4.14026E-01_JPRB, 4.05400E-01_JPRB, 3.96953E-01_JPRB, 3.88683E-01_JPRB/)
      KAO_MO3( 9, :,14) = (/ &
     & 1.32957E-01_JPRB, 1.31737E-01_JPRB, 1.30528E-01_JPRB, 1.29330E-01_JPRB, 1.28143E-01_JPRB, &
     & 1.26967E-01_JPRB, 1.25802E-01_JPRB, 1.24648E-01_JPRB, 1.23504E-01_JPRB, 1.22370E-01_JPRB, &
     & 1.21247E-01_JPRB, 1.20135E-01_JPRB, 1.19032E-01_JPRB, 1.17940E-01_JPRB, 1.16857E-01_JPRB, &
     & 1.15785E-01_JPRB, 1.14722E-01_JPRB, 1.13669E-01_JPRB, 1.12626E-01_JPRB/)
      KAO_MO3( 1, :,15) = (/ &
     & 1.51281E-01_JPRB, 1.53439E-01_JPRB, 1.55628E-01_JPRB, 1.57848E-01_JPRB, 1.60100E-01_JPRB, &
     & 1.62384E-01_JPRB, 1.64700E-01_JPRB, 1.67049E-01_JPRB, 1.69432E-01_JPRB, 1.71849E-01_JPRB, &
     & 1.74301E-01_JPRB, 1.76787E-01_JPRB, 1.79309E-01_JPRB, 1.81866E-01_JPRB, 1.84461E-01_JPRB, &
     & 1.87092E-01_JPRB, 1.89761E-01_JPRB, 1.92468E-01_JPRB, 1.95213E-01_JPRB/)
      KAO_MO3( 2, :,15) = (/ &
     & 1.51431E-01_JPRB, 1.53589E-01_JPRB, 1.55778E-01_JPRB, 1.57998E-01_JPRB, 1.60250E-01_JPRB, &
     & 1.62534E-01_JPRB, 1.64850E-01_JPRB, 1.67199E-01_JPRB, 1.69582E-01_JPRB, 1.71999E-01_JPRB, &
     & 1.74450E-01_JPRB, 1.76937E-01_JPRB, 1.79458E-01_JPRB, 1.82016E-01_JPRB, 1.84610E-01_JPRB, &
     & 1.87241E-01_JPRB, 1.89909E-01_JPRB, 1.92616E-01_JPRB, 1.95361E-01_JPRB/)
      KAO_MO3( 3, :,15) = (/ &
     & 1.51299E-01_JPRB, 1.53461E-01_JPRB, 1.55654E-01_JPRB, 1.57878E-01_JPRB, 1.60134E-01_JPRB, &
     & 1.62422E-01_JPRB, 1.64744E-01_JPRB, 1.67098E-01_JPRB, 1.69486E-01_JPRB, 1.71908E-01_JPRB, &
     & 1.74364E-01_JPRB, 1.76856E-01_JPRB, 1.79383E-01_JPRB, 1.81947E-01_JPRB, 1.84547E-01_JPRB, &
     & 1.87184E-01_JPRB, 1.89859E-01_JPRB, 1.92572E-01_JPRB, 1.95324E-01_JPRB/)
      KAO_MO3( 4, :,15) = (/ &
     & 1.51281E-01_JPRB, 1.53439E-01_JPRB, 1.55628E-01_JPRB, 1.57848E-01_JPRB, 1.60100E-01_JPRB, &
     & 1.62384E-01_JPRB, 1.64700E-01_JPRB, 1.67049E-01_JPRB, 1.69432E-01_JPRB, 1.71849E-01_JPRB, &
     & 1.74301E-01_JPRB, 1.76787E-01_JPRB, 1.79309E-01_JPRB, 1.81866E-01_JPRB, 1.84461E-01_JPRB, &
     & 1.87092E-01_JPRB, 1.89761E-01_JPRB, 1.92468E-01_JPRB, 1.95213E-01_JPRB/)
      KAO_MO3( 5, :,15) = (/ &
     & 1.51281E-01_JPRB, 1.53439E-01_JPRB, 1.55628E-01_JPRB, 1.57848E-01_JPRB, 1.60100E-01_JPRB, &
     & 1.62384E-01_JPRB, 1.64700E-01_JPRB, 1.67049E-01_JPRB, 1.69432E-01_JPRB, 1.71849E-01_JPRB, &
     & 1.74301E-01_JPRB, 1.76787E-01_JPRB, 1.79309E-01_JPRB, 1.81866E-01_JPRB, 1.84461E-01_JPRB, &
     & 1.87092E-01_JPRB, 1.89761E-01_JPRB, 1.92468E-01_JPRB, 1.95213E-01_JPRB/)
      KAO_MO3( 6, :,15) = (/ &
     & 1.51299E-01_JPRB, 1.53461E-01_JPRB, 1.55654E-01_JPRB, 1.57878E-01_JPRB, 1.60134E-01_JPRB, &
     & 1.62422E-01_JPRB, 1.64744E-01_JPRB, 1.67098E-01_JPRB, 1.69486E-01_JPRB, 1.71908E-01_JPRB, &
     & 1.74364E-01_JPRB, 1.76856E-01_JPRB, 1.79383E-01_JPRB, 1.81947E-01_JPRB, 1.84547E-01_JPRB, &
     & 1.87184E-01_JPRB, 1.89859E-01_JPRB, 1.92572E-01_JPRB, 1.95324E-01_JPRB/)
      KAO_MO3( 7, :,15) = (/ &
     & 1.51299E-01_JPRB, 1.53461E-01_JPRB, 1.55654E-01_JPRB, 1.57878E-01_JPRB, 1.60134E-01_JPRB, &
     & 1.62422E-01_JPRB, 1.64744E-01_JPRB, 1.67098E-01_JPRB, 1.69486E-01_JPRB, 1.71908E-01_JPRB, &
     & 1.74364E-01_JPRB, 1.76856E-01_JPRB, 1.79383E-01_JPRB, 1.81947E-01_JPRB, 1.84547E-01_JPRB, &
     & 1.87184E-01_JPRB, 1.89859E-01_JPRB, 1.92572E-01_JPRB, 1.95324E-01_JPRB/)
      KAO_MO3( 8, :,15) = (/ &
     & 1.51281E-01_JPRB, 1.53439E-01_JPRB, 1.55628E-01_JPRB, 1.57848E-01_JPRB, 1.60100E-01_JPRB, &
     & 1.62384E-01_JPRB, 1.64700E-01_JPRB, 1.67049E-01_JPRB, 1.69432E-01_JPRB, 1.71849E-01_JPRB, &
     & 1.74301E-01_JPRB, 1.76787E-01_JPRB, 1.79309E-01_JPRB, 1.81866E-01_JPRB, 1.84461E-01_JPRB, &
     & 1.87092E-01_JPRB, 1.89761E-01_JPRB, 1.92468E-01_JPRB, 1.95213E-01_JPRB/)
      KAO_MO3( 9, :,15) = (/ &
     & 2.44180E-01_JPRB, 2.35686E-01_JPRB, 2.27487E-01_JPRB, 2.19574E-01_JPRB, 2.11935E-01_JPRB, &
     & 2.04563E-01_JPRB, 1.97447E-01_JPRB, 1.90578E-01_JPRB, 1.83949E-01_JPRB, 1.77550E-01_JPRB, &
     & 1.71373E-01_JPRB, 1.65412E-01_JPRB, 1.59658E-01_JPRB, 1.54104E-01_JPRB, 1.48743E-01_JPRB, &
     & 1.43569E-01_JPRB, 1.38574E-01_JPRB, 1.33754E-01_JPRB, 1.29101E-01_JPRB/)
      KAO_MO3( 1, :,16) = (/ &
     & 1.02934E-01_JPRB, 1.04369E-01_JPRB, 1.05825E-01_JPRB, 1.07300E-01_JPRB, 1.08797E-01_JPRB, &
     & 1.10314E-01_JPRB, 1.11852E-01_JPRB, 1.13412E-01_JPRB, 1.14993E-01_JPRB, 1.16597E-01_JPRB, &
     & 1.18223E-01_JPRB, 1.19871E-01_JPRB, 1.21543E-01_JPRB, 1.23238E-01_JPRB, 1.24956E-01_JPRB, &
     & 1.26699E-01_JPRB, 1.28466E-01_JPRB, 1.30257E-01_JPRB, 1.32073E-01_JPRB/)
      KAO_MO3( 2, :,16) = (/ &
     & 1.02934E-01_JPRB, 1.04369E-01_JPRB, 1.05825E-01_JPRB, 1.07300E-01_JPRB, 1.08797E-01_JPRB, &
     & 1.10314E-01_JPRB, 1.11852E-01_JPRB, 1.13412E-01_JPRB, 1.14993E-01_JPRB, 1.16597E-01_JPRB, &
     & 1.18223E-01_JPRB, 1.19871E-01_JPRB, 1.21543E-01_JPRB, 1.23238E-01_JPRB, 1.24956E-01_JPRB, &
     & 1.26699E-01_JPRB, 1.28466E-01_JPRB, 1.30257E-01_JPRB, 1.32073E-01_JPRB/)
      KAO_MO3( 3, :,16) = (/ &
     & 1.02934E-01_JPRB, 1.04369E-01_JPRB, 1.05825E-01_JPRB, 1.07300E-01_JPRB, 1.08797E-01_JPRB, &
     & 1.10314E-01_JPRB, 1.11852E-01_JPRB, 1.13412E-01_JPRB, 1.14993E-01_JPRB, 1.16597E-01_JPRB, &
     & 1.18223E-01_JPRB, 1.19871E-01_JPRB, 1.21543E-01_JPRB, 1.23238E-01_JPRB, 1.24956E-01_JPRB, &
     & 1.26699E-01_JPRB, 1.28466E-01_JPRB, 1.30257E-01_JPRB, 1.32073E-01_JPRB/)
      KAO_MO3( 4, :,16) = (/ &
     & 1.02934E-01_JPRB, 1.04369E-01_JPRB, 1.05825E-01_JPRB, 1.07300E-01_JPRB, 1.08797E-01_JPRB, &
     & 1.10314E-01_JPRB, 1.11852E-01_JPRB, 1.13412E-01_JPRB, 1.14993E-01_JPRB, 1.16597E-01_JPRB, &
     & 1.18223E-01_JPRB, 1.19871E-01_JPRB, 1.21543E-01_JPRB, 1.23238E-01_JPRB, 1.24956E-01_JPRB, &
     & 1.26699E-01_JPRB, 1.28466E-01_JPRB, 1.30257E-01_JPRB, 1.32073E-01_JPRB/)
      KAO_MO3( 5, :,16) = (/ &
     & 1.02934E-01_JPRB, 1.04369E-01_JPRB, 1.05825E-01_JPRB, 1.07300E-01_JPRB, 1.08797E-01_JPRB, &
     & 1.10314E-01_JPRB, 1.11852E-01_JPRB, 1.13412E-01_JPRB, 1.14993E-01_JPRB, 1.16597E-01_JPRB, &
     & 1.18223E-01_JPRB, 1.19871E-01_JPRB, 1.21543E-01_JPRB, 1.23238E-01_JPRB, 1.24956E-01_JPRB, &
     & 1.26699E-01_JPRB, 1.28466E-01_JPRB, 1.30257E-01_JPRB, 1.32073E-01_JPRB/)
      KAO_MO3( 6, :,16) = (/ &
     & 1.02934E-01_JPRB, 1.04369E-01_JPRB, 1.05825E-01_JPRB, 1.07300E-01_JPRB, 1.08797E-01_JPRB, &
     & 1.10314E-01_JPRB, 1.11852E-01_JPRB, 1.13412E-01_JPRB, 1.14993E-01_JPRB, 1.16597E-01_JPRB, &
     & 1.18223E-01_JPRB, 1.19871E-01_JPRB, 1.21543E-01_JPRB, 1.23238E-01_JPRB, 1.24956E-01_JPRB, &
     & 1.26699E-01_JPRB, 1.28466E-01_JPRB, 1.30257E-01_JPRB, 1.32073E-01_JPRB/)
      KAO_MO3( 7, :,16) = (/ &
     & 1.02934E-01_JPRB, 1.04369E-01_JPRB, 1.05825E-01_JPRB, 1.07300E-01_JPRB, 1.08797E-01_JPRB, &
     & 1.10314E-01_JPRB, 1.11852E-01_JPRB, 1.13412E-01_JPRB, 1.14993E-01_JPRB, 1.16597E-01_JPRB, &
     & 1.18223E-01_JPRB, 1.19871E-01_JPRB, 1.21543E-01_JPRB, 1.23238E-01_JPRB, 1.24956E-01_JPRB, &
     & 1.26699E-01_JPRB, 1.28466E-01_JPRB, 1.30257E-01_JPRB, 1.32073E-01_JPRB/)
      KAO_MO3( 8, :,16) = (/ &
     & 1.02934E-01_JPRB, 1.04369E-01_JPRB, 1.05825E-01_JPRB, 1.07300E-01_JPRB, 1.08797E-01_JPRB, &
     & 1.10314E-01_JPRB, 1.11852E-01_JPRB, 1.13412E-01_JPRB, 1.14993E-01_JPRB, 1.16597E-01_JPRB, &
     & 1.18223E-01_JPRB, 1.19871E-01_JPRB, 1.21543E-01_JPRB, 1.23238E-01_JPRB, 1.24956E-01_JPRB, &
     & 1.26699E-01_JPRB, 1.28466E-01_JPRB, 1.30257E-01_JPRB, 1.32073E-01_JPRB/)
      KAO_MO3( 9, :,16) = (/ &
     & 3.91531E-01_JPRB, 3.78978E-01_JPRB, 3.66827E-01_JPRB, 3.55067E-01_JPRB, 3.43683E-01_JPRB, &
     & 3.32664E-01_JPRB, 3.21999E-01_JPRB, 3.11675E-01_JPRB, 3.01683E-01_JPRB, 2.92011E-01_JPRB, &
     & 2.82648E-01_JPRB, 2.73586E-01_JPRB, 2.64815E-01_JPRB, 2.56325E-01_JPRB, 2.48107E-01_JPRB, &
     & 2.40152E-01_JPRB, 2.32453E-01_JPRB, 2.25000E-01_JPRB, 2.17787E-01_JPRB/)


!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      FORREFO(1,:) = (/ &
     &1.0689E-05_JPRB,1.6987E-05_JPRB,1.8993E-05_JPRB,3.4470E-05_JPRB,4.0873E-05_JPRB,4.8275E-05_JPRB, &
     &6.1178E-05_JPRB,6.4035E-05_JPRB,6.6253E-05_JPRB,7.8914E-05_JPRB,8.1640E-05_JPRB,7.9738E-05_JPRB, &
     &7.8492E-05_JPRB,9.1565E-05_JPRB,1.0262E-04_JPRB,1.0368E-04_JPRB/)
      FORREFO(2,:) = (/ &
     &1.1194E-05_JPRB,1.6128E-05_JPRB,1.7213E-05_JPRB,2.6845E-05_JPRB,4.1361E-05_JPRB,5.1508E-05_JPRB, &
     &6.8245E-05_JPRB,7.4063E-05_JPRB,7.6273E-05_JPRB,8.4061E-05_JPRB,8.2492E-05_JPRB,8.1720E-05_JPRB, &
     &7.7626E-05_JPRB,1.0096E-04_JPRB,1.0519E-04_JPRB,1.0631E-04_JPRB/)
      FORREFO(3,:) = (/ &
     &1.0891E-05_JPRB,1.4933E-05_JPRB,1.7964E-05_JPRB,2.2577E-05_JPRB,4.4290E-05_JPRB,5.4675E-05_JPRB, &
     &7.2494E-05_JPRB,7.8410E-05_JPRB,7.6948E-05_JPRB,7.5742E-05_JPRB,7.7654E-05_JPRB,8.2760E-05_JPRB, &
     &7.8443E-05_JPRB,9.8384E-05_JPRB,1.0634E-04_JPRB,1.0838E-04_JPRB/)
      FORREFO(4,:) = (/ &
     &1.1316E-05_JPRB,1.5470E-05_JPRB,2.1246E-05_JPRB,3.3349E-05_JPRB,4.8704E-05_JPRB,5.6424E-05_JPRB, &
     &5.8569E-05_JPRB,5.8780E-05_JPRB,6.0358E-05_JPRB,6.1586E-05_JPRB,6.4281E-05_JPRB,6.9333E-05_JPRB, &
     &7.2763E-05_JPRB,7.2675E-05_JPRB,7.3754E-05_JPRB,1.0131E-04_JPRB/)


!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).
      SELFREFO(:, 1) = (/ &
     & 1.27686E-01_JPRB, 1.09347E-01_JPRB, 9.36410E-02_JPRB, 8.01912E-02_JPRB, 6.86732E-02_JPRB, &
     & 5.88096E-02_JPRB, 5.03627E-02_JPRB, 4.31290E-02_JPRB, 3.69343E-02_JPRB, 3.16294E-02_JPRB/)
      SELFREFO(:, 2) = (/ &
     & 1.40051E-01_JPRB, 1.20785E-01_JPRB, 1.04170E-01_JPRB, 8.98402E-02_JPRB, 7.74816E-02_JPRB, &
     & 6.68231E-02_JPRB, 5.76308E-02_JPRB, 4.97030E-02_JPRB, 4.28658E-02_JPRB, 3.69691E-02_JPRB/)
      SELFREFO(:, 3) = (/ &
     & 1.42322E-01_JPRB, 1.22872E-01_JPRB, 1.06080E-01_JPRB, 9.15829E-02_JPRB, 7.90671E-02_JPRB, &
     & 6.82616E-02_JPRB, 5.89329E-02_JPRB, 5.08790E-02_JPRB, 4.39258E-02_JPRB, 3.79228E-02_JPRB/)
      SELFREFO(:, 4) = (/ &
     & 1.53244E-01_JPRB, 1.33057E-01_JPRB, 1.15530E-01_JPRB, 1.00311E-01_JPRB, 8.70977E-02_JPRB, &
     & 7.56244E-02_JPRB, 6.56626E-02_JPRB, 5.70130E-02_JPRB, 4.95028E-02_JPRB, 4.29819E-02_JPRB/)
      SELFREFO(:, 5) = (/ &
     & 1.71011E-01_JPRB, 1.46680E-01_JPRB, 1.25810E-01_JPRB, 1.07910E-01_JPRB, 9.25563E-02_JPRB, &
     & 7.93874E-02_JPRB, 6.80922E-02_JPRB, 5.84040E-02_JPRB, 5.00943E-02_JPRB, 4.29669E-02_JPRB/)
      SELFREFO(:, 6) = (/ &
     & 1.76012E-01_JPRB, 1.51010E-01_JPRB, 1.29560E-01_JPRB, 1.11157E-01_JPRB, 9.53672E-02_JPRB, &
     & 8.18207E-02_JPRB, 7.01984E-02_JPRB, 6.02270E-02_JPRB, 5.16720E-02_JPRB, 4.43322E-02_JPRB/)
      SELFREFO(:, 7) = (/ &
     & 1.85600E-01_JPRB, 1.59051E-01_JPRB, 1.36300E-01_JPRB, 1.16803E-01_JPRB, 1.00095E-01_JPRB, &
     & 8.57776E-02_JPRB, 7.35077E-02_JPRB, 6.29930E-02_JPRB, 5.39823E-02_JPRB, 4.62606E-02_JPRB/)
      SELFREFO(:, 8) = (/ &
     & 1.88931E-01_JPRB, 1.61727E-01_JPRB, 1.38440E-01_JPRB, 1.18506E-01_JPRB, 1.01442E-01_JPRB, &
     & 8.68356E-02_JPRB, 7.43321E-02_JPRB, 6.36290E-02_JPRB, 5.44670E-02_JPRB, 4.66243E-02_JPRB/)
      SELFREFO(:, 9) = (/ &
     & 1.91122E-01_JPRB, 1.63407E-01_JPRB, 1.39710E-01_JPRB, 1.19450E-01_JPRB, 1.02128E-01_JPRB, &
     & 8.73176E-02_JPRB, 7.46552E-02_JPRB, 6.38290E-02_JPRB, 5.45728E-02_JPRB, 4.66589E-02_JPRB/)
      SELFREFO(:,10) = (/ &
     & 1.91334E-01_JPRB, 1.64872E-01_JPRB, 1.42070E-01_JPRB, 1.22421E-01_JPRB, 1.05490E-01_JPRB, &
     & 9.09008E-02_JPRB, 7.83291E-02_JPRB, 6.74960E-02_JPRB, 5.81612E-02_JPRB, 5.01174E-02_JPRB/)
      SELFREFO(:,11) = (/ &
     & 1.89858E-01_JPRB, 1.63934E-01_JPRB, 1.41550E-01_JPRB, 1.22222E-01_JPRB, 1.05534E-01_JPRB, &
     & 9.11237E-02_JPRB, 7.86814E-02_JPRB, 6.79380E-02_JPRB, 5.86615E-02_JPRB, 5.06517E-02_JPRB/)
      SELFREFO(:,12) = (/ &
     & 1.89783E-01_JPRB, 1.63757E-01_JPRB, 1.41300E-01_JPRB, 1.21923E-01_JPRB, 1.05203E-01_JPRB, &
     & 9.07760E-02_JPRB, 7.83274E-02_JPRB, 6.75860E-02_JPRB, 5.83176E-02_JPRB, 5.03202E-02_JPRB/)
      SELFREFO(:,13) = (/ &
     & 1.87534E-01_JPRB, 1.62016E-01_JPRB, 1.39970E-01_JPRB, 1.20924E-01_JPRB, 1.04470E-01_JPRB, &
     & 9.02541E-02_JPRB, 7.79730E-02_JPRB, 6.73630E-02_JPRB, 5.81967E-02_JPRB, 5.02778E-02_JPRB/)
      SELFREFO(:,14) = (/ &
     & 1.99128E-01_JPRB, 1.71410E-01_JPRB, 1.47550E-01_JPRB, 1.27011E-01_JPRB, 1.09332E-01_JPRB, &
     & 9.41131E-02_JPRB, 8.10128E-02_JPRB, 6.97360E-02_JPRB, 6.00289E-02_JPRB, 5.16731E-02_JPRB/)
      SELFREFO(:,15) = (/ &
     & 1.99460E-01_JPRB, 1.72342E-01_JPRB, 1.48910E-01_JPRB, 1.28664E-01_JPRB, 1.11171E-01_JPRB, &
     & 9.60560E-02_JPRB, 8.29962E-02_JPRB, 7.17120E-02_JPRB, 6.19620E-02_JPRB, 5.35376E-02_JPRB/)
      SELFREFO(:,16) = (/ &
     & 1.99906E-01_JPRB, 1.72737E-01_JPRB, 1.49260E-01_JPRB, 1.28974E-01_JPRB, 1.11445E-01_JPRB, &
     & 9.62982E-02_JPRB, 8.32102E-02_JPRB, 7.19010E-02_JPRB, 6.21288E-02_JPRB, 5.36848E-02_JPRB/)

IF (LHOOK) CALL DR_HOOK('RRTM_KGB5',1,ZHOOK_HANDLE)
RETURN

1001 CONTINUE
CALL ABOR1("RRTM_KGB5:ERROR READING FILE RADRRTM")

END SUBROUTINE RRTM_KGB5
