#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif
!OCL SCALAR
!pgi$r opt=0 
SUBROUTINE RRTM_KGB2

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 2:  250-500 cm-1 (low - H2O; high - H2O)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOERRTO2 , ONLY : KAO     ,KBO     ,SELFREFO   ,FRACREFAO  ,&
 & FRACREFBO  ,FORREFO  
USE YOERRTA2 , ONLY : REFPARAM

!     ------------------------------------------------------------------

IMPLICIT NONE
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('RRTM_KGB2',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2
CALL PART3
CALL PART4
CALL PART5
CALL PART6
CALL PART7
CALL PART8

IF (LHOOK) CALL DR_HOOK('RRTM_KGB2',1,ZHOOK_HANDLE)

!     -----------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB2:PART1',0,ZHOOK_HANDLE)


FRACREFBO( :) = (/&
 !     From P = 0.432 mb.
 & 0.17444289_JPRB,0.16467269_JPRB,0.15021490_JPRB,0.12460902_JPRB,&
 & 0.10400643_JPRB,0.09481928_JPRB,0.07590704_JPRB,0.05752856_JPRB,&
 & 0.03931715_JPRB,0.00428572_JPRB,0.00349352_JPRB,0.00278938_JPRB,&
 & 0.00203448_JPRB,0.00130037_JPRB,0.00051560_JPRB,0.00006255_JPRB/)  

FORREFO( :) = (/&
 & -2.34550E-03_JPRB,-8.42698E-03_JPRB,-2.01816E-02_JPRB,-5.66701E-02_JPRB,&
 & -8.93189E-02_JPRB,-6.37487E-02_JPRB,-4.56455E-02_JPRB,-4.41417E-02_JPRB,&
 & -4.48605E-02_JPRB,-4.74696E-02_JPRB,-5.16648E-02_JPRB,-5.63099E-02_JPRB,&
 & -4.74781E-02_JPRB,-3.84704E-02_JPRB,-2.49905E-02_JPRB, 2.02114E-03_JPRB/)  

!     The following are parameters related to the reference water vapor
!     mixing ratios by REFPARAM(I) = REFH2O(I) / (.002+REFH2O(I)).
!     These parameters are used for the Planck function interpolation.
REFPARAM( :) = (/&
 & 0.903661_JPRB   , 0.859386_JPRB   , 0.746542_JPRB   , 0.580496_JPRB   , 0.412889_JPRB   ,&
 & 0.275283_JPRB   , 0.162745_JPRB   , 7.63929E-02_JPRB, 1.82553E-02_JPRB, 3.72432E-03_JPRB, &
 & 2.14946E-03_JPRB, 1.66320E-03_JPRB, 1.59940E-03_JPRB/)  

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.

KAO( :, 1, 1) = (/&
 & 1.4400E-02_JPRB,1.5554E-02_JPRB,1.6739E-02_JPRB,1.7961E-02_JPRB,1.9379E-02_JPRB/)  
KAO( :, 2, 1) = (/&
 & 1.1452E-02_JPRB,1.2288E-02_JPRB,1.3232E-02_JPRB,1.4190E-02_JPRB,1.5277E-02_JPRB/)  
KAO( :, 3, 1) = (/&
 & 8.9989E-03_JPRB,9.5960E-03_JPRB,1.0327E-02_JPRB,1.1068E-02_JPRB,1.1889E-02_JPRB/)  
KAO( :, 4, 1) = (/&
 & 7.1078E-03_JPRB,7.5424E-03_JPRB,8.0710E-03_JPRB,8.6639E-03_JPRB,9.2920E-03_JPRB/)  
KAO( :, 5, 1) = (/&
 & 5.6632E-03_JPRB,5.9616E-03_JPRB,6.3421E-03_JPRB,6.8076E-03_JPRB,7.2949E-03_JPRB/)  
KAO( :, 6, 1) = (/&
 & 4.5348E-03_JPRB,4.7267E-03_JPRB,5.0015E-03_JPRB,5.3391E-03_JPRB,5.7317E-03_JPRB/)  
KAO( :, 7, 1) = (/&
 & 3.6484E-03_JPRB,3.7737E-03_JPRB,3.9583E-03_JPRB,4.2050E-03_JPRB,4.5069E-03_JPRB/)  
KAO( :, 8, 1) = (/&
 & 2.9485E-03_JPRB,3.0305E-03_JPRB,3.1509E-03_JPRB,3.3270E-03_JPRB,3.5470E-03_JPRB/)  
KAO( :, 9, 1) = (/&
 & 2.4028E-03_JPRB,2.4476E-03_JPRB,2.5272E-03_JPRB,2.6456E-03_JPRB,2.8089E-03_JPRB/)  
KAO( :,10, 1) = (/&
 & 1.9899E-03_JPRB,2.0047E-03_JPRB,2.0583E-03_JPRB,2.1403E-03_JPRB,2.2643E-03_JPRB/)  
KAO( :,11, 1) = (/&
 & 1.6478E-03_JPRB,1.6593E-03_JPRB,1.7036E-03_JPRB,1.7737E-03_JPRB,1.8823E-03_JPRB/)  
KAO( :,12, 1) = (/&
 & 1.3599E-03_JPRB,1.3694E-03_JPRB,1.4067E-03_JPRB,1.4672E-03_JPRB,1.5617E-03_JPRB/)  
KAO( :,13, 1) = (/&
 & 1.1157E-03_JPRB,1.1241E-03_JPRB,1.1555E-03_JPRB,1.2073E-03_JPRB,1.2864E-03_JPRB/)  
KAO( :, 1, 2) = (/&
 & 3.8905E-02_JPRB,4.2429E-02_JPRB,4.6513E-02_JPRB,5.0588E-02_JPRB,5.5021E-02_JPRB/)  
KAO( :, 2, 2) = (/&
 & 3.0803E-02_JPRB,3.3461E-02_JPRB,3.6546E-02_JPRB,3.9922E-02_JPRB,4.3440E-02_JPRB/)  
KAO( :, 3, 2) = (/&
 & 2.4144E-02_JPRB,2.6019E-02_JPRB,2.8287E-02_JPRB,3.0953E-02_JPRB,3.3739E-02_JPRB/)  
KAO( :, 4, 2) = (/&
 & 1.9082E-02_JPRB,2.0371E-02_JPRB,2.2034E-02_JPRB,2.4014E-02_JPRB,2.6250E-02_JPRB/)  
KAO( :, 5, 2) = (/&
 & 1.5203E-02_JPRB,1.6092E-02_JPRB,1.7271E-02_JPRB,1.8721E-02_JPRB,2.0471E-02_JPRB/)  
KAO( :, 6, 2) = (/&
 & 1.2164E-02_JPRB,1.2769E-02_JPRB,1.3578E-02_JPRB,1.4643E-02_JPRB,1.5928E-02_JPRB/)  
KAO( :, 7, 2) = (/&
 & 9.7815E-03_JPRB,1.0186E-02_JPRB,1.0740E-02_JPRB,1.1487E-02_JPRB,1.2435E-02_JPRB/)  
KAO( :, 8, 2) = (/&
 & 7.9245E-03_JPRB,8.1687E-03_JPRB,8.5497E-03_JPRB,9.0644E-03_JPRB,9.7618E-03_JPRB/)  
KAO( :, 9, 2) = (/&
 & 6.4727E-03_JPRB,6.5836E-03_JPRB,6.8391E-03_JPRB,7.1947E-03_JPRB,7.6826E-03_JPRB/)  
KAO( :,10, 2) = (/&
 & 5.3240E-03_JPRB,5.3575E-03_JPRB,5.5193E-03_JPRB,5.7706E-03_JPRB,6.1166E-03_JPRB/)  
KAO( :,11, 2) = (/&
 & 4.3783E-03_JPRB,4.4065E-03_JPRB,4.5391E-03_JPRB,4.7453E-03_JPRB,5.0313E-03_JPRB/)  
KAO( :,12, 2) = (/&
 & 3.5968E-03_JPRB,3.6203E-03_JPRB,3.7298E-03_JPRB,3.8998E-03_JPRB,4.1378E-03_JPRB/)  
KAO( :,13, 2) = (/&
 & 2.9507E-03_JPRB,2.9704E-03_JPRB,3.0611E-03_JPRB,3.2015E-03_JPRB,3.4012E-03_JPRB/)  
KAO( :, 1, 3) = (/&
 & 1.0636E-01_JPRB,1.1680E-01_JPRB,1.2824E-01_JPRB,1.4017E-01_JPRB,1.5266E-01_JPRB/)  
KAO( :, 2, 3) = (/&
 & 8.4443E-02_JPRB,9.2480E-02_JPRB,1.0148E-01_JPRB,1.1092E-01_JPRB,1.2100E-01_JPRB/)  
KAO( :, 3, 3) = (/&
 & 6.5959E-02_JPRB,7.1869E-02_JPRB,7.8770E-02_JPRB,8.6250E-02_JPRB,9.4058E-02_JPRB/)  
KAO( :, 4, 3) = (/&
 & 5.1681E-02_JPRB,5.6029E-02_JPRB,6.1207E-02_JPRB,6.7088E-02_JPRB,7.3195E-02_JPRB/)  
KAO( :, 5, 3) = (/&
 & 4.0734E-02_JPRB,4.3938E-02_JPRB,4.7777E-02_JPRB,5.2288E-02_JPRB,5.7243E-02_JPRB/)  
KAO( :, 6, 3) = (/&
 & 3.2248E-02_JPRB,3.4534E-02_JPRB,3.7344E-02_JPRB,4.0738E-02_JPRB,4.4673E-02_JPRB/)  
KAO( :, 7, 3) = (/&
 & 2.5731E-02_JPRB,2.7244E-02_JPRB,2.9333E-02_JPRB,3.1849E-02_JPRB,3.4861E-02_JPRB/)  
KAO( :, 8, 3) = (/&
 & 2.0693E-02_JPRB,2.1657E-02_JPRB,2.3154E-02_JPRB,2.5012E-02_JPRB,2.7268E-02_JPRB/)  
KAO( :, 9, 3) = (/&
 & 1.6730E-02_JPRB,1.7346E-02_JPRB,1.8327E-02_JPRB,1.9716E-02_JPRB,2.1381E-02_JPRB/)  
KAO( :,10, 3) = (/&
 & 1.3588E-02_JPRB,1.4015E-02_JPRB,1.4658E-02_JPRB,1.5680E-02_JPRB,1.6936E-02_JPRB/)  
KAO( :,11, 3) = (/&
 & 1.1180E-02_JPRB,1.1528E-02_JPRB,1.2063E-02_JPRB,1.2917E-02_JPRB,1.3959E-02_JPRB/)  
KAO( :,12, 3) = (/&
 & 9.1920E-03_JPRB,9.4766E-03_JPRB,9.9244E-03_JPRB,1.0636E-02_JPRB,1.1502E-02_JPRB/)  
KAO( :,13, 3) = (/&
 & 7.5517E-03_JPRB,7.7861E-03_JPRB,8.1602E-03_JPRB,8.7504E-03_JPRB,9.4682E-03_JPRB/)  
KAO( :, 1, 4) = (/&
 & 2.6559E-01_JPRB,2.7778E-01_JPRB,2.8983E-01_JPRB,3.0112E-01_JPRB,3.1151E-01_JPRB/)  
KAO( :, 2, 4) = (/&
 & 2.1415E-01_JPRB,2.2376E-01_JPRB,2.3372E-01_JPRB,2.4291E-01_JPRB,2.5148E-01_JPRB/)  
KAO( :, 3, 4) = (/&
 & 1.7113E-01_JPRB,1.7864E-01_JPRB,1.8679E-01_JPRB,1.9418E-01_JPRB,2.0158E-01_JPRB/)  
KAO( :, 4, 4) = (/&
 & 1.3689E-01_JPRB,1.4305E-01_JPRB,1.4933E-01_JPRB,1.5577E-01_JPRB,1.6212E-01_JPRB/)  
KAO( :, 5, 4) = (/&
 & 1.0951E-01_JPRB,1.1484E-01_JPRB,1.1993E-01_JPRB,1.2527E-01_JPRB,1.3048E-01_JPRB/)  
KAO( :, 6, 4) = (/&
 & 8.7678E-02_JPRB,9.2013E-02_JPRB,9.6292E-02_JPRB,1.0052E-01_JPRB,1.0492E-01_JPRB/)  
KAO( :, 7, 4) = (/&
 & 7.0271E-02_JPRB,7.3646E-02_JPRB,7.7252E-02_JPRB,8.0679E-02_JPRB,8.4295E-02_JPRB/)  
KAO( :, 8, 4) = (/&
 & 5.6292E-02_JPRB,5.9027E-02_JPRB,6.1915E-02_JPRB,6.4784E-02_JPRB,6.7662E-02_JPRB/)  
KAO( :, 9, 4) = (/&
 & 4.5045E-02_JPRB,4.7308E-02_JPRB,4.9593E-02_JPRB,5.1992E-02_JPRB,5.4350E-02_JPRB/)  
KAO( :,10, 4) = (/&
 & 3.6083E-02_JPRB,3.8037E-02_JPRB,3.9928E-02_JPRB,4.1868E-02_JPRB,4.3827E-02_JPRB/)  
KAO( :,11, 4) = (/&
 & 2.9684E-02_JPRB,3.1305E-02_JPRB,3.2869E-02_JPRB,3.4458E-02_JPRB,3.6069E-02_JPRB/)  
KAO( :,12, 4) = (/&
 & 2.4428E-02_JPRB,2.5760E-02_JPRB,2.7039E-02_JPRB,2.8345E-02_JPRB,2.9671E-02_JPRB/)  
KAO( :,13, 4) = (/&
 & 2.0094E-02_JPRB,2.1179E-02_JPRB,2.2224E-02_JPRB,2.3304E-02_JPRB,2.4394E-02_JPRB/)  
KAO( :, 1, 5) = (/&
 & 4.7290E-01_JPRB,4.8928E-01_JPRB,5.0887E-01_JPRB,5.3328E-01_JPRB,5.6216E-01_JPRB/)  
KAO( :, 2, 5) = (/&
 & 3.8475E-01_JPRB,3.9762E-01_JPRB,4.1280E-01_JPRB,4.3219E-01_JPRB,4.5473E-01_JPRB/)  
KAO( :, 3, 5) = (/&
 & 3.0979E-01_JPRB,3.1996E-01_JPRB,3.3105E-01_JPRB,3.4530E-01_JPRB,3.6216E-01_JPRB/)  
KAO( :, 4, 5) = (/&
 & 2.5002E-01_JPRB,2.5800E-01_JPRB,2.6674E-01_JPRB,2.7709E-01_JPRB,2.8946E-01_JPRB/)  
KAO( :, 5, 5) = (/&
 & 2.0218E-01_JPRB,2.0847E-01_JPRB,2.1546E-01_JPRB,2.2311E-01_JPRB,2.3239E-01_JPRB/)  
KAO( :, 6, 5) = (/&
 & 1.6286E-01_JPRB,1.6840E-01_JPRB,1.7397E-01_JPRB,1.7996E-01_JPRB,1.8683E-01_JPRB/)  
KAO( :, 7, 5) = (/&
 & 1.3055E-01_JPRB,1.3602E-01_JPRB,1.4050E-01_JPRB,1.4524E-01_JPRB,1.5047E-01_JPRB/)  
KAO( :, 8, 5) = (/&
 & 1.0442E-01_JPRB,1.0954E-01_JPRB,1.1353E-01_JPRB,1.1737E-01_JPRB,1.2143E-01_JPRB/)  
KAO( :, 9, 5) = (/&
 & 8.3388E-02_JPRB,8.7841E-02_JPRB,9.1682E-02_JPRB,9.4816E-02_JPRB,9.8050E-02_JPRB/)  
KAO( :,10, 5) = (/&
 & 6.7010E-02_JPRB,7.0598E-02_JPRB,7.4015E-02_JPRB,7.6769E-02_JPRB,7.9372E-02_JPRB/)  
KAO( :,11, 5) = (/&
 & 5.5118E-02_JPRB,5.8051E-02_JPRB,6.0869E-02_JPRB,6.3114E-02_JPRB,6.5294E-02_JPRB/)  
KAO( :,12, 5) = (/&
 & 4.5300E-02_JPRB,4.7721E-02_JPRB,5.0049E-02_JPRB,5.1890E-02_JPRB,5.3682E-02_JPRB/)  
KAO( :,13, 5) = (/&
 & 3.7225E-02_JPRB,3.9236E-02_JPRB,4.1133E-02_JPRB,4.2631E-02_JPRB,4.4126E-02_JPRB/)  
KAO( :, 1, 6) = (/&
 & 8.4224E-01_JPRB,9.2264E-01_JPRB,1.0073E+00_JPRB,1.0930E+00_JPRB,1.1793E+00_JPRB/)  
KAO( :, 2, 6) = (/&
 & 6.7595E-01_JPRB,7.4232E-01_JPRB,8.1248E-01_JPRB,8.8302E-01_JPRB,9.5616E-01_JPRB/)  
KAO( :, 3, 6) = (/&
 & 5.2904E-01_JPRB,5.8048E-01_JPRB,6.3751E-01_JPRB,6.9642E-01_JPRB,7.5721E-01_JPRB/)  
KAO( :, 4, 6) = (/&
 & 4.1315E-01_JPRB,4.5407E-01_JPRB,4.9971E-01_JPRB,5.4886E-01_JPRB,5.9964E-01_JPRB/)  
KAO( :, 5, 6) = (/&
 & 3.2467E-01_JPRB,3.5531E-01_JPRB,3.9159E-01_JPRB,4.3161E-01_JPRB,4.7423E-01_JPRB/)  
KAO( :, 6, 6) = (/&
 & 2.5574E-01_JPRB,2.7784E-01_JPRB,3.0579E-01_JPRB,3.3817E-01_JPRB,3.7278E-01_JPRB/)  
KAO( :, 7, 6) = (/&
 & 2.0313E-01_JPRB,2.1792E-01_JPRB,2.3876E-01_JPRB,2.6386E-01_JPRB,2.9205E-01_JPRB/)  
KAO( :, 8, 6) = (/&
 & 1.6285E-01_JPRB,1.7201E-01_JPRB,1.8675E-01_JPRB,2.0598E-01_JPRB,2.2843E-01_JPRB/)  
KAO( :, 9, 6) = (/&
 & 1.3178E-01_JPRB,1.3687E-01_JPRB,1.4670E-01_JPRB,1.6087E-01_JPRB,1.7827E-01_JPRB/)  
KAO( :,10, 6) = (/&
 & 1.0760E-01_JPRB,1.1022E-01_JPRB,1.1661E-01_JPRB,1.2690E-01_JPRB,1.4033E-01_JPRB/)  
KAO( :,11, 6) = (/&
 & 8.8471E-02_JPRB,9.0742E-02_JPRB,9.6088E-02_JPRB,1.0477E-01_JPRB,1.1601E-01_JPRB/)  
KAO( :,12, 6) = (/&
 & 7.2724E-02_JPRB,7.4645E-02_JPRB,7.9165E-02_JPRB,8.6464E-02_JPRB,9.5844E-02_JPRB/)  
KAO( :,13, 6) = (/&
 & 5.9719E-02_JPRB,6.1350E-02_JPRB,6.5177E-02_JPRB,7.1301E-02_JPRB,7.9088E-02_JPRB/)  
KAO( :, 1, 7) = (/&
 & 1.8416E+00_JPRB,2.0377E+00_JPRB,2.2351E+00_JPRB,2.4351E+00_JPRB,2.6357E+00_JPRB/)  
KAO( :, 2, 7) = (/&
 & 1.5057E+00_JPRB,1.6691E+00_JPRB,1.8342E+00_JPRB,2.0031E+00_JPRB,2.1705E+00_JPRB/)  
KAO( :, 3, 7) = (/&
 & 1.1980E+00_JPRB,1.3329E+00_JPRB,1.4704E+00_JPRB,1.6099E+00_JPRB,1.7488E+00_JPRB/)  
KAO( :, 4, 7) = (/&
 & 9.4408E-01_JPRB,1.0566E+00_JPRB,1.1708E+00_JPRB,1.2874E+00_JPRB,1.4014E+00_JPRB/)  
KAO( :, 5, 7) = (/&
 & 7.4052E-01_JPRB,8.3332E-01_JPRB,9.3007E-01_JPRB,1.0263E+00_JPRB,1.1221E+00_JPRB/)  
KAO( :, 6, 7) = (/&
 & 5.7502E-01_JPRB,6.5145E-01_JPRB,7.3102E-01_JPRB,8.1228E-01_JPRB,8.9283E-01_JPRB/)  
KAO( :, 7, 7) = (/&
 & 4.4413E-01_JPRB,5.0565E-01_JPRB,5.7113E-01_JPRB,6.3832E-01_JPRB,7.0636E-01_JPRB/)  
KAO( :, 8, 7) = (/&
 & 3.4215E-01_JPRB,3.9125E-01_JPRB,4.4414E-01_JPRB,4.9963E-01_JPRB,5.5600E-01_JPRB/)  
KAO( :, 9, 7) = (/&
 & 2.6278E-01_JPRB,3.0155E-01_JPRB,3.4409E-01_JPRB,3.8940E-01_JPRB,4.3634E-01_JPRB/)  
KAO( :,10, 7) = (/&
 & 2.0399E-01_JPRB,2.3450E-01_JPRB,2.6863E-01_JPRB,3.0559E-01_JPRB,3.4410E-01_JPRB/)  
KAO( :,11, 7) = (/&
 & 1.6899E-01_JPRB,1.9452E-01_JPRB,2.2306E-01_JPRB,2.5367E-01_JPRB,2.8600E-01_JPRB/)  
KAO( :,12, 7) = (/&
 & 1.4000E-01_JPRB,1.6132E-01_JPRB,1.8504E-01_JPRB,2.1049E-01_JPRB,2.3736E-01_JPRB/)  
KAO( :,13, 7) = (/&
 & 1.1587E-01_JPRB,1.3364E-01_JPRB,1.5332E-01_JPRB,1.7448E-01_JPRB,1.9695E-01_JPRB/)  
KAO( :, 1, 8) = (/&
 & 4.7751E+00_JPRB,5.2791E+00_JPRB,5.7933E+00_JPRB,6.3083E+00_JPRB,6.8326E+00_JPRB/)  
KAO( :, 2, 8) = (/&
 & 4.0048E+00_JPRB,4.4443E+00_JPRB,4.8940E+00_JPRB,5.3580E+00_JPRB,5.8267E+00_JPRB/)  
KAO( :, 3, 8) = (/&
 & 3.2400E+00_JPRB,3.6253E+00_JPRB,4.0207E+00_JPRB,4.4230E+00_JPRB,4.8210E+00_JPRB/)  
KAO( :, 4, 8) = (/&
 & 2.5883E+00_JPRB,2.9210E+00_JPRB,3.2656E+00_JPRB,3.6154E+00_JPRB,3.9641E+00_JPRB/)  
KAO( :, 5, 8) = (/&
 & 2.0550E+00_JPRB,2.3390E+00_JPRB,2.6351E+00_JPRB,2.9336E+00_JPRB,3.2370E+00_JPRB/)  
KAO( :, 6, 8) = (/&
 & 1.6130E+00_JPRB,1.8538E+00_JPRB,2.1027E+00_JPRB,2.3582E+00_JPRB,2.6184E+00_JPRB/)  
KAO( :, 7, 8) = (/&
 & 1.2548E+00_JPRB,1.4567E+00_JPRB,1.6664E+00_JPRB,1.8820E+00_JPRB,2.1036E+00_JPRB/)  
KAO( :, 8, 8) = (/&
 & 9.6687E-01_JPRB,1.1348E+00_JPRB,1.3110E+00_JPRB,1.4930E+00_JPRB,1.6805E+00_JPRB/)  
KAO( :, 9, 8) = (/&
 & 7.3847E-01_JPRB,8.7593E-01_JPRB,1.0221E+00_JPRB,1.1741E+00_JPRB,1.3319E+00_JPRB/)  
KAO( :,10, 8) = (/&
 & 5.6776E-01_JPRB,6.8017E-01_JPRB,8.0059E-01_JPRB,9.2750E-01_JPRB,1.0593E+00_JPRB/)  
KAO( :,11, 8) = (/&
 & 4.7511E-01_JPRB,5.6972E-01_JPRB,6.7118E-01_JPRB,7.7840E-01_JPRB,8.8949E-01_JPRB/)  
KAO( :,12, 8) = (/&
 & 3.9658E-01_JPRB,4.7593E-01_JPRB,5.6128E-01_JPRB,6.5124E-01_JPRB,7.4417E-01_JPRB/)  
KAO( :,13, 8) = (/&
 & 3.3005E-01_JPRB,3.9650E-01_JPRB,4.6807E-01_JPRB,5.4357E-01_JPRB,6.2155E-01_JPRB/)  
KAO( :, 1, 9) = (/&
 & 1.7831E+01_JPRB,1.9823E+01_JPRB,2.1884E+01_JPRB,2.3937E+01_JPRB,2.5904E+01_JPRB/)  
KAO( :, 2, 9) = (/&
 & 1.5983E+01_JPRB,1.7908E+01_JPRB,1.9844E+01_JPRB,2.1750E+01_JPRB,2.3639E+01_JPRB/)  
KAO( :, 3, 9) = (/&
 & 1.3838E+01_JPRB,1.5652E+01_JPRB,1.7428E+01_JPRB,1.9195E+01_JPRB,2.0946E+01_JPRB/)  
KAO( :, 4, 9) = (/&
 & 1.1707E+01_JPRB,1.3372E+01_JPRB,1.5018E+01_JPRB,1.6675E+01_JPRB,1.8330E+01_JPRB/)  
KAO( :, 5, 9) = (/&
 & 9.7619E+00_JPRB,1.1244E+01_JPRB,1.2752E+01_JPRB,1.4279E+01_JPRB,1.5837E+01_JPRB/)  
KAO( :, 6, 9) = (/&
 & 7.9817E+00_JPRB,9.2988E+00_JPRB,1.0650E+01_JPRB,1.2029E+01_JPRB,1.3449E+01_JPRB/)  
KAO( :, 7, 9) = (/&
 & 6.4478E+00_JPRB,7.5864E+00_JPRB,8.7717E+00_JPRB,1.0008E+01_JPRB,1.1289E+01_JPRB/)  
KAO( :, 8, 9) = (/&
 & 5.1550E+00_JPRB,6.1381E+00_JPRB,7.1667E+00_JPRB,8.2567E+00_JPRB,9.3759E+00_JPRB/)  
KAO( :, 9, 9) = (/&
 & 4.0462E+00_JPRB,4.8924E+00_JPRB,5.7944E+00_JPRB,6.7466E+00_JPRB,7.7100E+00_JPRB/)  
KAO( :,10, 9) = (/&
 & 3.1920E+00_JPRB,3.9133E+00_JPRB,4.6912E+00_JPRB,5.5091E+00_JPRB,6.3432E+00_JPRB/)  
KAO( :,11, 9) = (/&
 & 2.7717E+00_JPRB,3.4039E+00_JPRB,4.0800E+00_JPRB,4.7818E+00_JPRB,5.5081E+00_JPRB/)  
KAO( :,12, 9) = (/&
 & 2.3978E+00_JPRB,2.9436E+00_JPRB,3.5235E+00_JPRB,4.1293E+00_JPRB,4.7600E+00_JPRB/)  
KAO( :,13, 9) = (/&
 & 2.0575E+00_JPRB,2.5263E+00_JPRB,3.0244E+00_JPRB,3.5477E+00_JPRB,4.0896E+00_JPRB/)  
KAO( :, 1,10) = (/&
 & 4.9748E+01_JPRB,5.5112E+01_JPRB,5.9938E+01_JPRB,6.5023E+01_JPRB,7.0458E+01_JPRB/)  
KAO( :, 2,10) = (/&
 & 4.6588E+01_JPRB,5.1661E+01_JPRB,5.6901E+01_JPRB,6.2463E+01_JPRB,6.8487E+01_JPRB/)  
KAO( :, 3,10) = (/&
 & 4.1628E+01_JPRB,4.6699E+01_JPRB,5.2314E+01_JPRB,5.8353E+01_JPRB,6.4458E+01_JPRB/)  
KAO( :, 4,10) = (/&
 & 3.7456E+01_JPRB,4.2469E+01_JPRB,4.7867E+01_JPRB,5.3384E+01_JPRB,5.9111E+01_JPRB/)  
KAO( :, 5,10) = (/&
 & 3.3436E+01_JPRB,3.8793E+01_JPRB,4.3992E+01_JPRB,4.9077E+01_JPRB,5.4046E+01_JPRB/)  
KAO( :, 6,10) = (/&
 & 2.8948E+01_JPRB,3.4066E+01_JPRB,3.9093E+01_JPRB,4.3943E+01_JPRB,4.8577E+01_JPRB/)  
KAO( :, 7,10) = (/&
 & 2.4411E+01_JPRB,2.9169E+01_JPRB,3.3772E+01_JPRB,3.8328E+01_JPRB,4.2674E+01_JPRB/)  
KAO( :, 8,10) = (/&
 & 2.0213E+01_JPRB,2.4379E+01_JPRB,2.8547E+01_JPRB,3.2632E+01_JPRB,3.6717E+01_JPRB/)  
KAO( :, 9,10) = (/&
 & 1.6770E+01_JPRB,2.0275E+01_JPRB,2.3726E+01_JPRB,2.7289E+01_JPRB,3.1149E+01_JPRB/)  
KAO( :,10,10) = (/&
 & 1.3740E+01_JPRB,1.6814E+01_JPRB,1.9874E+01_JPRB,2.3039E+01_JPRB,2.6529E+01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB2:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB2:PART2',0,ZHOOK_HANDLE)


KAO( :,11,10) = (/&
 & 1.2161E+01_JPRB,1.4820E+01_JPRB,1.7667E+01_JPRB,2.0767E+01_JPRB,2.3948E+01_JPRB/)  
KAO( :,12,10) = (/&
 & 1.0666E+01_JPRB,1.3093E+01_JPRB,1.5727E+01_JPRB,1.8473E+01_JPRB,2.1195E+01_JPRB/)  
KAO( :,13,10) = (/&
 & 9.3915E+00_JPRB,1.1557E+01_JPRB,1.3847E+01_JPRB,1.6172E+01_JPRB,1.8558E+01_JPRB/)  
KAO( :, 1,11) = (/&
 & 7.2842E+01_JPRB,8.2127E+01_JPRB,9.1751E+01_JPRB,1.0081E+02_JPRB,1.0868E+02_JPRB/)  
KAO( :, 2,11) = (/&
 & 7.0912E+01_JPRB,8.0211E+01_JPRB,8.9133E+01_JPRB,9.7767E+01_JPRB,1.0537E+02_JPRB/)  
KAO( :, 3,11) = (/&
 & 6.7169E+01_JPRB,7.5895E+01_JPRB,8.3957E+01_JPRB,9.1467E+01_JPRB,9.8740E+01_JPRB/)  
KAO( :, 4,11) = (/&
 & 6.1046E+01_JPRB,6.9086E+01_JPRB,7.7071E+01_JPRB,8.4625E+01_JPRB,9.2325E+01_JPRB/)  
KAO( :, 5,11) = (/&
 & 5.4291E+01_JPRB,6.1624E+01_JPRB,6.9146E+01_JPRB,7.6916E+01_JPRB,8.5050E+01_JPRB/)  
KAO( :, 6,11) = (/&
 & 4.7940E+01_JPRB,5.4754E+01_JPRB,6.1943E+01_JPRB,6.9739E+01_JPRB,7.7765E+01_JPRB/)  
KAO( :, 7,11) = (/&
 & 4.1424E+01_JPRB,4.8323E+01_JPRB,5.5884E+01_JPRB,6.3434E+01_JPRB,7.1064E+01_JPRB/)  
KAO( :, 8,11) = (/&
 & 3.4808E+01_JPRB,4.1718E+01_JPRB,4.9240E+01_JPRB,5.6728E+01_JPRB,6.4032E+01_JPRB/)  
KAO( :, 9,11) = (/&
 & 2.8724E+01_JPRB,3.5333E+01_JPRB,4.2395E+01_JPRB,4.9372E+01_JPRB,5.6186E+01_JPRB/)  
KAO( :,10,11) = (/&
 & 2.4060E+01_JPRB,2.9886E+01_JPRB,3.6171E+01_JPRB,4.2511E+01_JPRB,4.8855E+01_JPRB/)  
KAO( :,11,11) = (/&
 & 2.2466E+01_JPRB,2.7842E+01_JPRB,3.3276E+01_JPRB,3.8707E+01_JPRB,4.4411E+01_JPRB/)  
KAO( :,12,11) = (/&
 & 2.0635E+01_JPRB,2.5402E+01_JPRB,3.0130E+01_JPRB,3.5065E+01_JPRB,4.0456E+01_JPRB/)  
KAO( :,13,11) = (/&
 & 1.8375E+01_JPRB,2.2528E+01_JPRB,2.6944E+01_JPRB,3.1721E+01_JPRB,3.6642E+01_JPRB/)  
KAO( :, 1,12) = (/&
 & 1.2814E+02_JPRB,1.3938E+02_JPRB,1.4994E+02_JPRB,1.6150E+02_JPRB,1.7273E+02_JPRB/)  
KAO( :, 2,12) = (/&
 & 1.2028E+02_JPRB,1.3171E+02_JPRB,1.4381E+02_JPRB,1.5628E+02_JPRB,1.6936E+02_JPRB/)  
KAO( :, 3,12) = (/&
 & 1.0908E+02_JPRB,1.2221E+02_JPRB,1.3662E+02_JPRB,1.5108E+02_JPRB,1.6591E+02_JPRB/)  
KAO( :, 4,12) = (/&
 & 9.9689E+01_JPRB,1.1393E+02_JPRB,1.2899E+02_JPRB,1.4446E+02_JPRB,1.5932E+02_JPRB/)  
KAO( :, 5,12) = (/&
 & 9.1574E+01_JPRB,1.0647E+02_JPRB,1.2179E+02_JPRB,1.3681E+02_JPRB,1.5090E+02_JPRB/)  
KAO( :, 6,12) = (/&
 & 8.3159E+01_JPRB,9.8372E+01_JPRB,1.1370E+02_JPRB,1.2787E+02_JPRB,1.4184E+02_JPRB/)  
KAO( :, 7,12) = (/&
 & 7.5130E+01_JPRB,8.9279E+01_JPRB,1.0335E+02_JPRB,1.1696E+02_JPRB,1.3088E+02_JPRB/)  
KAO( :, 8,12) = (/&
 & 6.6942E+01_JPRB,7.9719E+01_JPRB,9.2547E+01_JPRB,1.0530E+02_JPRB,1.1887E+02_JPRB/)  
KAO( :, 9,12) = (/&
 & 5.7722E+01_JPRB,6.9837E+01_JPRB,8.2082E+01_JPRB,9.4593E+01_JPRB,1.0770E+02_JPRB/)  
KAO( :,10,12) = (/&
 & 4.9040E+01_JPRB,6.0620E+01_JPRB,7.2577E+01_JPRB,8.5187E+01_JPRB,9.7844E+01_JPRB/)  
KAO( :,11,12) = (/&
 & 4.5433E+01_JPRB,5.6352E+01_JPRB,6.8223E+01_JPRB,8.0499E+01_JPRB,9.2512E+01_JPRB/)  
KAO( :,12,12) = (/&
 & 4.1971E+01_JPRB,5.2467E+01_JPRB,6.3533E+01_JPRB,7.4543E+01_JPRB,8.5084E+01_JPRB/)  
KAO( :,13,12) = (/&
 & 3.9013E+01_JPRB,4.8568E+01_JPRB,5.8272E+01_JPRB,6.7741E+01_JPRB,7.7194E+01_JPRB/)  
KAO( :, 1,13) = (/&
 & 2.2210E+02_JPRB,2.4767E+02_JPRB,2.7177E+02_JPRB,2.9506E+02_JPRB,3.1428E+02_JPRB/)  
KAO( :, 2,13) = (/&
 & 2.2387E+02_JPRB,2.5269E+02_JPRB,2.7872E+02_JPRB,2.9937E+02_JPRB,3.1679E+02_JPRB/)  
KAO( :, 3,13) = (/&
 & 2.1746E+02_JPRB,2.4620E+02_JPRB,2.7168E+02_JPRB,2.9352E+02_JPRB,3.1488E+02_JPRB/)  
KAO( :, 4,13) = (/&
 & 2.0527E+02_JPRB,2.3513E+02_JPRB,2.5998E+02_JPRB,2.8303E+02_JPRB,3.0506E+02_JPRB/)  
KAO( :, 5,13) = (/&
 & 1.8964E+02_JPRB,2.1890E+02_JPRB,2.4311E+02_JPRB,2.6810E+02_JPRB,2.9248E+02_JPRB/)  
KAO( :, 6,13) = (/&
 & 1.7090E+02_JPRB,1.9758E+02_JPRB,2.2284E+02_JPRB,2.4839E+02_JPRB,2.7463E+02_JPRB/)  
KAO( :, 7,13) = (/&
 & 1.5109E+02_JPRB,1.7710E+02_JPRB,2.0295E+02_JPRB,2.2932E+02_JPRB,2.5634E+02_JPRB/)  
KAO( :, 8,13) = (/&
 & 1.3270E+02_JPRB,1.5826E+02_JPRB,1.8450E+02_JPRB,2.1121E+02_JPRB,2.3873E+02_JPRB/)  
KAO( :, 9,13) = (/&
 & 1.1570E+02_JPRB,1.4021E+02_JPRB,1.6653E+02_JPRB,1.9389E+02_JPRB,2.2105E+02_JPRB/)  
KAO( :,10,13) = (/&
 & 1.0259E+02_JPRB,1.2584E+02_JPRB,1.5091E+02_JPRB,1.7718E+02_JPRB,2.0281E+02_JPRB/)  
KAO( :,11,13) = (/&
 & 1.0076E+02_JPRB,1.2370E+02_JPRB,1.4756E+02_JPRB,1.7147E+02_JPRB,1.9575E+02_JPRB/)  
KAO( :,12,13) = (/&
 & 9.7325E+01_JPRB,1.1939E+02_JPRB,1.4174E+02_JPRB,1.6449E+02_JPRB,1.8836E+02_JPRB/)  
KAO( :,13,13) = (/&
 & 9.2070E+01_JPRB,1.1299E+02_JPRB,1.3489E+02_JPRB,1.5734E+02_JPRB,1.8036E+02_JPRB/)  
KAO( :, 1,14) = (/&
 & 4.2241E+02_JPRB,4.5820E+02_JPRB,4.8815E+02_JPRB,5.1730E+02_JPRB,5.4765E+02_JPRB/)  
KAO( :, 2,14) = (/&
 & 4.2461E+02_JPRB,4.6681E+02_JPRB,4.9982E+02_JPRB,5.3726E+02_JPRB,5.6640E+02_JPRB/)  
KAO( :, 3,14) = (/&
 & 4.1742E+02_JPRB,4.5924E+02_JPRB,4.9930E+02_JPRB,5.3630E+02_JPRB,5.8090E+02_JPRB/)  
KAO( :, 4,14) = (/&
 & 3.9739E+02_JPRB,4.4336E+02_JPRB,4.8832E+02_JPRB,5.2886E+02_JPRB,5.8035E+02_JPRB/)  
KAO( :, 5,14) = (/&
 & 3.7398E+02_JPRB,4.2048E+02_JPRB,4.7438E+02_JPRB,5.2486E+02_JPRB,5.7134E+02_JPRB/)  
KAO( :, 6,14) = (/&
 & 3.4725E+02_JPRB,3.9940E+02_JPRB,4.5648E+02_JPRB,5.1230E+02_JPRB,5.6617E+02_JPRB/)  
KAO( :, 7,14) = (/&
 & 3.2072E+02_JPRB,3.7728E+02_JPRB,4.3646E+02_JPRB,4.9362E+02_JPRB,5.5200E+02_JPRB/)  
KAO( :, 8,14) = (/&
 & 2.9404E+02_JPRB,3.5487E+02_JPRB,4.1802E+02_JPRB,4.7825E+02_JPRB,5.4076E+02_JPRB/)  
KAO( :, 9,14) = (/&
 & 2.7034E+02_JPRB,3.3232E+02_JPRB,3.9722E+02_JPRB,4.5997E+02_JPRB,5.2290E+02_JPRB/)  
KAO( :,10,14) = (/&
 & 2.5045E+02_JPRB,3.1309E+02_JPRB,3.7582E+02_JPRB,4.4096E+02_JPRB,5.0588E+02_JPRB/)  
KAO( :,11,14) = (/&
 & 2.5624E+02_JPRB,3.1911E+02_JPRB,3.8269E+02_JPRB,4.5034E+02_JPRB,5.1713E+02_JPRB/)  
KAO( :,12,14) = (/&
 & 2.6046E+02_JPRB,3.2208E+02_JPRB,3.8851E+02_JPRB,4.5644E+02_JPRB,5.2468E+02_JPRB/)  
KAO( :,13,14) = (/&
 & 2.6376E+02_JPRB,3.2552E+02_JPRB,3.9097E+02_JPRB,4.5804E+02_JPRB,5.2614E+02_JPRB/)  
KAO( :, 1,15) = (/&
 & 8.5706E+02_JPRB,9.2142E+02_JPRB,9.6878E+02_JPRB,1.0281E+03_JPRB,1.0795E+03_JPRB/)  
KAO( :, 2,15) = (/&
 & 9.5189E+02_JPRB,1.0335E+03_JPRB,1.0913E+03_JPRB,1.1632E+03_JPRB,1.2011E+03_JPRB/)  
KAO( :, 3,15) = (/&
 & 1.0232E+03_JPRB,1.0861E+03_JPRB,1.1646E+03_JPRB,1.2285E+03_JPRB,1.3057E+03_JPRB/)  
KAO( :, 4,15) = (/&
 & 1.0392E+03_JPRB,1.1356E+03_JPRB,1.2544E+03_JPRB,1.3115E+03_JPRB,1.4338E+03_JPRB/)  
KAO( :, 5,15) = (/&
 & 1.0616E+03_JPRB,1.1713E+03_JPRB,1.3147E+03_JPRB,1.4146E+03_JPRB,1.4989E+03_JPRB/)  
KAO( :, 6,15) = (/&
 & 1.0788E+03_JPRB,1.1886E+03_JPRB,1.3302E+03_JPRB,1.4680E+03_JPRB,1.5638E+03_JPRB/)  
KAO( :, 7,15) = (/&
 & 1.0593E+03_JPRB,1.1909E+03_JPRB,1.3423E+03_JPRB,1.4840E+03_JPRB,1.6000E+03_JPRB/)  
KAO( :, 8,15) = (/&
 & 9.9873E+02_JPRB,1.1655E+03_JPRB,1.3439E+03_JPRB,1.4887E+03_JPRB,1.6318E+03_JPRB/)  
KAO( :, 9,15) = (/&
 & 9.4071E+02_JPRB,1.1173E+03_JPRB,1.3103E+03_JPRB,1.4801E+03_JPRB,1.6507E+03_JPRB/)  
KAO( :,10,15) = (/&
 & 8.8647E+02_JPRB,1.0727E+03_JPRB,1.2703E+03_JPRB,1.4721E+03_JPRB,1.6711E+03_JPRB/)  
KAO( :,11,15) = (/&
 & 9.2131E+02_JPRB,1.1303E+03_JPRB,1.3379E+03_JPRB,1.5675E+03_JPRB,1.7706E+03_JPRB/)  
KAO( :,12,15) = (/&
 & 9.6245E+02_JPRB,1.1976E+03_JPRB,1.4205E+03_JPRB,1.6577E+03_JPRB,1.8724E+03_JPRB/)  
KAO( :,13,15) = (/&
 & 1.0149E+03_JPRB,1.2514E+03_JPRB,1.4928E+03_JPRB,1.7376E+03_JPRB,1.9688E+03_JPRB/)  
KAO( :, 1,16) = (/&
 & 1.1893E+03_JPRB,1.2688E+03_JPRB,1.3351E+03_JPRB,1.3959E+03_JPRB,1.4433E+03_JPRB/)  
KAO( :, 2,16) = (/&
 & 1.4043E+03_JPRB,1.5015E+03_JPRB,1.5933E+03_JPRB,1.6702E+03_JPRB,1.7343E+03_JPRB/)  
KAO( :, 3,16) = (/&
 & 1.6203E+03_JPRB,1.7272E+03_JPRB,1.8338E+03_JPRB,1.9414E+03_JPRB,2.0288E+03_JPRB/)  
KAO( :, 4,16) = (/&
 & 1.7997E+03_JPRB,1.9426E+03_JPRB,2.1186E+03_JPRB,2.2171E+03_JPRB,2.3429E+03_JPRB/)  
KAO( :, 5,16) = (/&
 & 1.9840E+03_JPRB,2.1906E+03_JPRB,2.3875E+03_JPRB,2.5360E+03_JPRB,2.6578E+03_JPRB/)  
KAO( :, 6,16) = (/&
 & 2.1706E+03_JPRB,2.4031E+03_JPRB,2.6185E+03_JPRB,2.8410E+03_JPRB,2.9858E+03_JPRB/)  
KAO( :, 7,16) = (/&
 & 2.3367E+03_JPRB,2.6044E+03_JPRB,2.8764E+03_JPRB,3.1365E+03_JPRB,3.3254E+03_JPRB/)  
KAO( :, 8,16) = (/&
 & 2.4353E+03_JPRB,2.7922E+03_JPRB,3.1601E+03_JPRB,3.4455E+03_JPRB,3.6918E+03_JPRB/)  
KAO( :, 9,16) = (/&
 & 2.5375E+03_JPRB,2.9571E+03_JPRB,3.4043E+03_JPRB,3.7567E+03_JPRB,4.0876E+03_JPRB/)  
KAO( :,10,16) = (/&
 & 2.6751E+03_JPRB,3.1240E+03_JPRB,3.6015E+03_JPRB,4.0631E+03_JPRB,4.4658E+03_JPRB/)  
KAO( :,11,16) = (/&
 & 3.0220E+03_JPRB,3.5297E+03_JPRB,4.0306E+03_JPRB,4.6185E+03_JPRB,5.0516E+03_JPRB/)  
KAO( :,12,16) = (/&
 & 3.3138E+03_JPRB,4.0094E+03_JPRB,4.5368E+03_JPRB,5.2030E+03_JPRB,5.7257E+03_JPRB/)  
KAO( :,13,16) = (/&
 & 3.6770E+03_JPRB,4.3534E+03_JPRB,5.0748E+03_JPRB,5.8067E+03_JPRB,6.4888E+03_JPRB/)  

!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KBO( :,13, 1) = (/&
 & 1.1165E-03_JPRB,1.1247E-03_JPRB,1.1560E-03_JPRB,1.2076E-03_JPRB,1.2869E-03_JPRB/)  
KBO( :,14, 1) = (/&
 & 9.1499E-04_JPRB,9.2417E-04_JPRB,9.5214E-04_JPRB,9.9793E-04_JPRB,1.0647E-03_JPRB/)  
KBO( :,15, 1) = (/&
 & 7.4895E-04_JPRB,7.5885E-04_JPRB,7.8398E-04_JPRB,8.2364E-04_JPRB,8.7934E-04_JPRB/)  
KBO( :,16, 1) = (/&
 & 6.1285E-04_JPRB,6.2301E-04_JPRB,6.4528E-04_JPRB,6.7919E-04_JPRB,7.2561E-04_JPRB/)  
KBO( :,17, 1) = (/&
 & 5.0161E-04_JPRB,5.1162E-04_JPRB,5.3088E-04_JPRB,5.5956E-04_JPRB,5.9827E-04_JPRB/)  
KBO( :,18, 1) = (/&
 & 4.1059E-04_JPRB,4.2007E-04_JPRB,4.3635E-04_JPRB,4.6069E-04_JPRB,4.9285E-04_JPRB/)  
KBO( :,19, 1) = (/&
 & 3.3641E-04_JPRB,3.4500E-04_JPRB,3.5879E-04_JPRB,3.7929E-04_JPRB,4.0616E-04_JPRB/)  
KBO( :,20, 1) = (/&
 & 2.7603E-04_JPRB,2.8363E-04_JPRB,2.9537E-04_JPRB,3.1276E-04_JPRB,3.3531E-04_JPRB/)  
KBO( :,21, 1) = (/&
 & 2.2659E-04_JPRB,2.3317E-04_JPRB,2.4324E-04_JPRB,2.5796E-04_JPRB,2.7695E-04_JPRB/)  
KBO( :,22, 1) = (/&
 & 1.8631E-04_JPRB,1.9217E-04_JPRB,2.0103E-04_JPRB,2.1374E-04_JPRB,2.2994E-04_JPRB/)  
KBO( :,23, 1) = (/&
 & 1.5327E-04_JPRB,1.5846E-04_JPRB,1.6631E-04_JPRB,1.7723E-04_JPRB,1.9096E-04_JPRB/)  
KBO( :,24, 1) = (/&
 & 1.2620E-04_JPRB,1.3080E-04_JPRB,1.3778E-04_JPRB,1.4714E-04_JPRB,1.5867E-04_JPRB/)  
KBO( :,25, 1) = (/&
 & 1.0400E-04_JPRB,1.0810E-04_JPRB,1.1426E-04_JPRB,1.2231E-04_JPRB,1.3192E-04_JPRB/)  
KBO( :,26, 1) = (/&
 & 8.5812E-05_JPRB,8.9507E-05_JPRB,9.4927E-05_JPRB,1.0190E-04_JPRB,1.0982E-04_JPRB/)  
KBO( :,27, 1) = (/&
 & 7.0859E-05_JPRB,7.4205E-05_JPRB,7.8939E-05_JPRB,8.4957E-05_JPRB,9.1449E-05_JPRB/)  
KBO( :,28, 1) = (/&
 & 5.8569E-05_JPRB,6.1594E-05_JPRB,6.5700E-05_JPRB,7.0820E-05_JPRB,7.6191E-05_JPRB/)  
KBO( :,29, 1) = (/&
 & 4.8465E-05_JPRB,5.1177E-05_JPRB,5.4745E-05_JPRB,5.9040E-05_JPRB,6.3532E-05_JPRB/)  
KBO( :,30, 1) = (/&
 & 4.0147E-05_JPRB,4.2553E-05_JPRB,4.5653E-05_JPRB,4.9207E-05_JPRB,5.2981E-05_JPRB/)  
KBO( :,31, 1) = (/&
 & 3.3300E-05_JPRB,3.5414E-05_JPRB,3.8102E-05_JPRB,4.1014E-05_JPRB,4.4195E-05_JPRB/)  
KBO( :,32, 1) = (/&
 & 2.7662E-05_JPRB,2.9504E-05_JPRB,3.1798E-05_JPRB,3.4208E-05_JPRB,3.6892E-05_JPRB/)  
KBO( :,33, 1) = (/&
 & 2.3000E-05_JPRB,2.4605E-05_JPRB,2.6531E-05_JPRB,2.8549E-05_JPRB,3.0814E-05_JPRB/)  
KBO( :,34, 1) = (/&
 & 1.9101E-05_JPRB,2.0488E-05_JPRB,2.2081E-05_JPRB,2.3773E-05_JPRB,2.5683E-05_JPRB/)  
KBO( :,35, 1) = (/&
 & 1.5772E-05_JPRB,1.6945E-05_JPRB,1.8248E-05_JPRB,1.9654E-05_JPRB,2.1248E-05_JPRB/)  
KBO( :,36, 1) = (/&
 & 1.2932E-05_JPRB,1.3897E-05_JPRB,1.4964E-05_JPRB,1.6118E-05_JPRB,1.7427E-05_JPRB/)  
KBO( :,37, 1) = (/&
 & 1.0500E-05_JPRB,1.1266E-05_JPRB,1.2140E-05_JPRB,1.3070E-05_JPRB,1.4122E-05_JPRB/)  
KBO( :,38, 1) = (/&
 & 8.5232E-06_JPRB,9.1293E-06_JPRB,9.8424E-06_JPRB,1.0593E-05_JPRB,1.1438E-05_JPRB/)  
KBO( :,39, 1) = (/&
 & 6.9199E-06_JPRB,7.4001E-06_JPRB,7.9793E-06_JPRB,8.5851E-06_JPRB,9.2651E-06_JPRB/)  
KBO( :,40, 1) = (/&
 & 5.5869E-06_JPRB,5.9579E-06_JPRB,6.4208E-06_JPRB,6.9067E-06_JPRB,7.4490E-06_JPRB/)  
KBO( :,41, 1) = (/&
 & 4.5102E-06_JPRB,4.7959E-06_JPRB,5.1598E-06_JPRB,5.5535E-06_JPRB,5.9845E-06_JPRB/)  
KBO( :,42, 1) = (/&
 & 3.6455E-06_JPRB,3.8634E-06_JPRB,4.1445E-06_JPRB,4.4666E-06_JPRB,4.8093E-06_JPRB/)  
KBO( :,43, 1) = (/&
 & 2.9434E-06_JPRB,3.1045E-06_JPRB,3.3181E-06_JPRB,3.5779E-06_JPRB,3.8500E-06_JPRB/)  
KBO( :,44, 1) = (/&
 & 2.3784E-06_JPRB,2.4940E-06_JPRB,2.6554E-06_JPRB,2.8596E-06_JPRB,3.0773E-06_JPRB/)  
KBO( :,45, 1) = (/&
 & 1.9254E-06_JPRB,2.0073E-06_JPRB,2.1280E-06_JPRB,2.2840E-06_JPRB,2.4615E-06_JPRB/)  
KBO( :,46, 1) = (/&
 & 1.5599E-06_JPRB,1.6176E-06_JPRB,1.7055E-06_JPRB,1.8226E-06_JPRB,1.9656E-06_JPRB/)  
KBO( :,47, 1) = (/&
 & 1.2647E-06_JPRB,1.3045E-06_JPRB,1.3657E-06_JPRB,1.4527E-06_JPRB,1.5636E-06_JPRB/)  
KBO( :,48, 1) = (/&
 & 1.0280E-06_JPRB,1.0546E-06_JPRB,1.0967E-06_JPRB,1.1602E-06_JPRB,1.2430E-06_JPRB/)  
KBO( :,49, 1) = (/&
 & 8.3899E-07_JPRB,8.5435E-07_JPRB,8.8348E-07_JPRB,9.2841E-07_JPRB,9.8990E-07_JPRB/)  
KBO( :,50, 1) = (/&
 & 6.8758E-07_JPRB,6.9417E-07_JPRB,7.1424E-07_JPRB,7.4551E-07_JPRB,7.9125E-07_JPRB/)  
KBO( :,51, 1) = (/&
 & 5.6525E-07_JPRB,5.6564E-07_JPRB,5.7879E-07_JPRB,6.0067E-07_JPRB,6.3406E-07_JPRB/)  
KBO( :,52, 1) = (/&
 & 4.6614E-07_JPRB,4.6262E-07_JPRB,4.6991E-07_JPRB,4.8521E-07_JPRB,5.0895E-07_JPRB/)  
KBO( :,53, 1) = (/&
 & 3.8583E-07_JPRB,3.7971E-07_JPRB,3.8237E-07_JPRB,3.9285E-07_JPRB,4.0940E-07_JPRB/)  
KBO( :,54, 1) = (/&
 & 3.1998E-07_JPRB,3.1249E-07_JPRB,3.1214E-07_JPRB,3.1896E-07_JPRB,3.3069E-07_JPRB/)  
KBO( :,55, 1) = (/&
 & 2.6585E-07_JPRB,2.5784E-07_JPRB,2.5568E-07_JPRB,2.5953E-07_JPRB,2.6785E-07_JPRB/)  
KBO( :,56, 1) = (/&
 & 2.2137E-07_JPRB,2.1341E-07_JPRB,2.1005E-07_JPRB,2.1159E-07_JPRB,2.1739E-07_JPRB/)  
KBO( :,57, 1) = (/&
 & 1.8477E-07_JPRB,1.7712E-07_JPRB,1.7304E-07_JPRB,1.7292E-07_JPRB,1.7676E-07_JPRB/)  
KBO( :,58, 1) = (/&
 & 1.5448E-07_JPRB,1.4728E-07_JPRB,1.4291E-07_JPRB,1.4181E-07_JPRB,1.4406E-07_JPRB/)  
KBO( :,59, 1) = (/&
 & 1.2795E-07_JPRB,1.2169E-07_JPRB,1.1777E-07_JPRB,1.1651E-07_JPRB,1.1802E-07_JPRB/)  
KBO( :,13, 2) = (/&
 & 2.9516E-03_JPRB,2.9713E-03_JPRB,3.0616E-03_JPRB,3.2019E-03_JPRB,3.4017E-03_JPRB/)  
KBO( :,14, 2) = (/&
 & 2.4197E-03_JPRB,2.4414E-03_JPRB,2.5207E-03_JPRB,2.6407E-03_JPRB,2.8167E-03_JPRB/)  
KBO( :,15, 2) = (/&
 & 1.9831E-03_JPRB,2.0063E-03_JPRB,2.0755E-03_JPRB,2.1800E-03_JPRB,2.3342E-03_JPRB/)  
KBO( :,16, 2) = (/&
 & 1.6252E-03_JPRB,1.6492E-03_JPRB,1.7097E-03_JPRB,1.8014E-03_JPRB,1.9341E-03_JPRB/)  
KBO( :,17, 2) = (/&
 & 1.3321E-03_JPRB,1.3556E-03_JPRB,1.4086E-03_JPRB,1.4882E-03_JPRB,1.6017E-03_JPRB/)  
KBO( :,18, 2) = (/&
 & 1.0920E-03_JPRB,1.1148E-03_JPRB,1.1610E-03_JPRB,1.2292E-03_JPRB,1.3248E-03_JPRB/)  
KBO( :,19, 2) = (/&
 & 8.9534E-04_JPRB,9.1690E-04_JPRB,9.5709E-04_JPRB,1.0148E-03_JPRB,1.0951E-03_JPRB/)  
KBO( :,20, 2) = (/&
 & 7.3445E-04_JPRB,7.5503E-04_JPRB,7.8958E-04_JPRB,8.3863E-04_JPRB,9.0600E-04_JPRB/)  
KBO( :,21, 2) = (/&
 & 6.0290E-04_JPRB,6.2180E-04_JPRB,6.5148E-04_JPRB,6.9308E-04_JPRB,7.4966E-04_JPRB/)  
KBO( :,22, 2) = (/&
 & 4.9595E-04_JPRB,5.1353E-04_JPRB,5.3937E-04_JPRB,5.7561E-04_JPRB,6.2348E-04_JPRB/)  
KBO( :,23, 2) = (/&
 & 4.0855E-04_JPRB,4.2434E-04_JPRB,4.4677E-04_JPRB,4.7846E-04_JPRB,5.1897E-04_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB2:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


SUBROUTINE PART3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB2:PART3',0,ZHOOK_HANDLE)


KBO( :,24, 2) = (/&
 & 3.3704E-04_JPRB,3.5087E-04_JPRB,3.7041E-04_JPRB,3.9825E-04_JPRB,4.3254E-04_JPRB/)  
KBO( :,25, 2) = (/&
 & 2.7823E-04_JPRB,2.9034E-04_JPRB,3.0756E-04_JPRB,3.3176E-04_JPRB,3.6108E-04_JPRB/)  
KBO( :,26, 2) = (/&
 & 2.2988E-04_JPRB,2.4065E-04_JPRB,2.5599E-04_JPRB,2.7689E-04_JPRB,3.0218E-04_JPRB/)  
KBO( :,27, 2) = (/&
 & 1.9008E-04_JPRB,1.9966E-04_JPRB,2.1335E-04_JPRB,2.3118E-04_JPRB,2.5287E-04_JPRB/)  
KBO( :,28, 2) = (/&
 & 1.5729E-04_JPRB,1.6582E-04_JPRB,1.7804E-04_JPRB,1.9321E-04_JPRB,2.1158E-04_JPRB/)  
KBO( :,29, 2) = (/&
 & 1.3030E-04_JPRB,1.3794E-04_JPRB,1.4870E-04_JPRB,1.6172E-04_JPRB,1.7712E-04_JPRB/)  
KBO( :,30, 2) = (/&
 & 1.0807E-04_JPRB,1.1491E-04_JPRB,1.2423E-04_JPRB,1.3552E-04_JPRB,1.4830E-04_JPRB/)  
KBO( :,31, 2) = (/&
 & 8.9737E-05_JPRB,9.5873E-05_JPRB,1.0385E-04_JPRB,1.1357E-04_JPRB,1.2422E-04_JPRB/)  
KBO( :,32, 2) = (/&
 & 7.4607E-05_JPRB,8.0114E-05_JPRB,8.6925E-05_JPRB,9.5160E-05_JPRB,1.0409E-04_JPRB/)  
KBO( :,33, 2) = (/&
 & 6.2115E-05_JPRB,6.6976E-05_JPRB,7.2842E-05_JPRB,7.9749E-05_JPRB,8.7261E-05_JPRB/)  
KBO( :,34, 2) = (/&
 & 5.1667E-05_JPRB,5.5854E-05_JPRB,6.0911E-05_JPRB,6.6641E-05_JPRB,7.2945E-05_JPRB/)  
KBO( :,35, 2) = (/&
 & 4.2714E-05_JPRB,4.6224E-05_JPRB,5.0476E-05_JPRB,5.5207E-05_JPRB,6.0446E-05_JPRB/)  
KBO( :,36, 2) = (/&
 & 3.5033E-05_JPRB,3.7916E-05_JPRB,4.1413E-05_JPRB,4.5290E-05_JPRB,4.9590E-05_JPRB/)  
KBO( :,37, 2) = (/&
 & 2.8417E-05_JPRB,3.0724E-05_JPRB,3.3511E-05_JPRB,3.6656E-05_JPRB,4.0123E-05_JPRB/)  
KBO( :,38, 2) = (/&
 & 2.3044E-05_JPRB,2.4879E-05_JPRB,2.7091E-05_JPRB,2.9646E-05_JPRB,3.2440E-05_JPRB/)  
KBO( :,39, 2) = (/&
 & 1.8696E-05_JPRB,2.0150E-05_JPRB,2.1905E-05_JPRB,2.3977E-05_JPRB,2.6231E-05_JPRB/)  
KBO( :,40, 2) = (/&
 & 1.5079E-05_JPRB,1.6190E-05_JPRB,1.7561E-05_JPRB,1.9219E-05_JPRB,2.1019E-05_JPRB/)  
KBO( :,41, 2) = (/&
 & 1.2166E-05_JPRB,1.2998E-05_JPRB,1.4076E-05_JPRB,1.5387E-05_JPRB,1.6826E-05_JPRB/)  
KBO( :,42, 2) = (/&
 & 9.8245E-06_JPRB,1.0447E-05_JPRB,1.1292E-05_JPRB,1.2314E-05_JPRB,1.3470E-05_JPRB/)  
KBO( :,43, 2) = (/&
 & 7.9207E-06_JPRB,8.3766E-06_JPRB,9.0212E-06_JPRB,9.8015E-06_JPRB,1.0730E-05_JPRB/)  
KBO( :,44, 2) = (/&
 & 6.3891E-06_JPRB,6.7204E-06_JPRB,7.1950E-06_JPRB,7.7968E-06_JPRB,8.5295E-06_JPRB/)  
KBO( :,45, 2) = (/&
 & 5.1614E-06_JPRB,5.4018E-06_JPRB,5.7463E-06_JPRB,6.2126E-06_JPRB,6.7779E-06_JPRB/)  
KBO( :,46, 2) = (/&
 & 4.1735E-06_JPRB,4.3451E-06_JPRB,4.5931E-06_JPRB,4.9450E-06_JPRB,5.3724E-06_JPRB/)  
KBO( :,47, 2) = (/&
 & 3.3750E-06_JPRB,3.4959E-06_JPRB,3.6722E-06_JPRB,3.9247E-06_JPRB,4.2513E-06_JPRB/)  
KBO( :,48, 2) = (/&
 & 2.7418E-06_JPRB,2.8192E-06_JPRB,2.9434E-06_JPRB,3.1225E-06_JPRB,3.3711E-06_JPRB/)  
KBO( :,49, 2) = (/&
 & 2.2371E-06_JPRB,2.2775E-06_JPRB,2.3656E-06_JPRB,2.4925E-06_JPRB,2.6750E-06_JPRB/)  
KBO( :,50, 2) = (/&
 & 1.8317E-06_JPRB,1.8465E-06_JPRB,1.9073E-06_JPRB,1.9984E-06_JPRB,2.1290E-06_JPRB/)  
KBO( :,51, 2) = (/&
 & 1.5036E-06_JPRB,1.5039E-06_JPRB,1.5416E-06_JPRB,1.6065E-06_JPRB,1.7002E-06_JPRB/)  
KBO( :,52, 2) = (/&
 & 1.2365E-06_JPRB,1.2289E-06_JPRB,1.2476E-06_JPRB,1.2944E-06_JPRB,1.3617E-06_JPRB/)  
KBO( :,53, 2) = (/&
 & 1.0180E-06_JPRB,1.0070E-06_JPRB,1.0130E-06_JPRB,1.0447E-06_JPRB,1.0931E-06_JPRB/)  
KBO( :,54, 2) = (/&
 & 8.3881E-07_JPRB,8.2694E-07_JPRB,8.2607E-07_JPRB,8.4574E-07_JPRB,8.8059E-07_JPRB/)  
KBO( :,55, 2) = (/&
 & 6.9195E-07_JPRB,6.7987E-07_JPRB,6.7548E-07_JPRB,6.8562E-07_JPRB,7.1114E-07_JPRB/)  
KBO( :,56, 2) = (/&
 & 5.7173E-07_JPRB,5.5948E-07_JPRB,5.5356E-07_JPRB,5.5733E-07_JPRB,5.7508E-07_JPRB/)  
KBO( :,57, 2) = (/&
 & 4.7316E-07_JPRB,4.6096E-07_JPRB,4.5452E-07_JPRB,4.5448E-07_JPRB,4.6581E-07_JPRB/)  
KBO( :,58, 2) = (/&
 & 3.9189E-07_JPRB,3.8013E-07_JPRB,3.7366E-07_JPRB,3.7160E-07_JPRB,3.7785E-07_JPRB/)  
KBO( :,59, 2) = (/&
 & 3.2262E-07_JPRB,3.1241E-07_JPRB,3.0663E-07_JPRB,3.0438E-07_JPRB,3.0850E-07_JPRB/)  
KBO( :,13, 3) = (/&
 & 7.5527E-03_JPRB,7.7875E-03_JPRB,8.1613E-03_JPRB,8.7500E-03_JPRB,9.4693E-03_JPRB/)  
KBO( :,14, 3) = (/&
 & 6.2162E-03_JPRB,6.4179E-03_JPRB,6.7443E-03_JPRB,7.2436E-03_JPRB,7.8488E-03_JPRB/)  
KBO( :,15, 3) = (/&
 & 5.1154E-03_JPRB,5.2899E-03_JPRB,5.5758E-03_JPRB,5.9977E-03_JPRB,6.5097E-03_JPRB/)  
KBO( :,16, 3) = (/&
 & 4.2091E-03_JPRB,4.3598E-03_JPRB,4.6108E-03_JPRB,4.9662E-03_JPRB,5.4041E-03_JPRB/)  
KBO( :,17, 3) = (/&
 & 3.4624E-03_JPRB,3.5931E-03_JPRB,3.8125E-03_JPRB,4.1118E-03_JPRB,4.4867E-03_JPRB/)  
KBO( :,18, 3) = (/&
 & 2.8478E-03_JPRB,2.9611E-03_JPRB,3.1513E-03_JPRB,3.4056E-03_JPRB,3.7227E-03_JPRB/)  
KBO( :,19, 3) = (/&
 & 2.3424E-03_JPRB,2.4403E-03_JPRB,2.6050E-03_JPRB,2.8205E-03_JPRB,3.0875E-03_JPRB/)  
KBO( :,20, 3) = (/&
 & 1.9279E-03_JPRB,2.0136E-03_JPRB,2.1568E-03_JPRB,2.3394E-03_JPRB,2.5633E-03_JPRB/)  
KBO( :,21, 3) = (/&
 & 1.5868E-03_JPRB,1.6625E-03_JPRB,1.7866E-03_JPRB,1.9403E-03_JPRB,2.1279E-03_JPRB/)  
KBO( :,22, 3) = (/&
 & 1.3095E-03_JPRB,1.3798E-03_JPRB,1.4873E-03_JPRB,1.6185E-03_JPRB,1.7762E-03_JPRB/)  
KBO( :,23, 3) = (/&
 & 1.0820E-03_JPRB,1.1470E-03_JPRB,1.2388E-03_JPRB,1.3506E-03_JPRB,1.4828E-03_JPRB/)  
KBO( :,24, 3) = (/&
 & 8.9533E-04_JPRB,9.5480E-04_JPRB,1.0325E-03_JPRB,1.1273E-03_JPRB,1.2391E-03_JPRB/)  
KBO( :,25, 3) = (/&
 & 7.4229E-04_JPRB,7.9534E-04_JPRB,8.6151E-04_JPRB,9.4186E-04_JPRB,1.0361E-03_JPRB/)  
KBO( :,26, 3) = (/&
 & 6.1705E-04_JPRB,6.6349E-04_JPRB,7.2018E-04_JPRB,7.8870E-04_JPRB,8.6741E-04_JPRB/)  
KBO( :,27, 3) = (/&
 & 5.1373E-04_JPRB,5.5377E-04_JPRB,6.0259E-04_JPRB,6.6085E-04_JPRB,7.2640E-04_JPRB/)  
KBO( :,28, 3) = (/&
 & 4.2826E-04_JPRB,4.6245E-04_JPRB,5.0434E-04_JPRB,5.5405E-04_JPRB,6.0850E-04_JPRB/)  
KBO( :,29, 3) = (/&
 & 3.5730E-04_JPRB,3.8667E-04_JPRB,4.2255E-04_JPRB,4.6475E-04_JPRB,5.1008E-04_JPRB/)  
KBO( :,30, 3) = (/&
 & 2.9823E-04_JPRB,3.2356E-04_JPRB,3.5427E-04_JPRB,3.8963E-04_JPRB,4.2762E-04_JPRB/)  
KBO( :,31, 3) = (/&
 & 2.4915E-04_JPRB,2.7111E-04_JPRB,2.9730E-04_JPRB,3.2676E-04_JPRB,3.5853E-04_JPRB/)  
KBO( :,32, 3) = (/&
 & 2.0835E-04_JPRB,2.2726E-04_JPRB,2.4969E-04_JPRB,2.7415E-04_JPRB,3.0052E-04_JPRB/)  
KBO( :,33, 3) = (/&
 & 1.7440E-04_JPRB,1.9063E-04_JPRB,2.0966E-04_JPRB,2.3004E-04_JPRB,2.5180E-04_JPRB/)  
KBO( :,34, 3) = (/&
 & 1.4566E-04_JPRB,1.5949E-04_JPRB,1.7537E-04_JPRB,1.9242E-04_JPRB,2.1028E-04_JPRB/)  
KBO( :,35, 3) = (/&
 & 1.2069E-04_JPRB,1.3227E-04_JPRB,1.4538E-04_JPRB,1.5949E-04_JPRB,1.7412E-04_JPRB/)  
KBO( :,36, 3) = (/&
 & 9.9043E-05_JPRB,1.0856E-04_JPRB,1.1931E-04_JPRB,1.3088E-04_JPRB,1.4285E-04_JPRB/)  
KBO( :,37, 3) = (/&
 & 8.0192E-05_JPRB,8.7828E-05_JPRB,9.6552E-05_JPRB,1.0592E-04_JPRB,1.1571E-04_JPRB/)  
KBO( :,38, 3) = (/&
 & 6.4895E-05_JPRB,7.1006E-05_JPRB,7.8078E-05_JPRB,8.5641E-05_JPRB,9.3649E-05_JPRB/)  
KBO( :,39, 3) = (/&
 & 5.2529E-05_JPRB,5.7417E-05_JPRB,6.3137E-05_JPRB,6.9248E-05_JPRB,7.5786E-05_JPRB/)  
KBO( :,40, 3) = (/&
 & 4.2172E-05_JPRB,4.6011E-05_JPRB,5.0550E-05_JPRB,5.5469E-05_JPRB,6.0782E-05_JPRB/)  
KBO( :,41, 3) = (/&
 & 3.3845E-05_JPRB,3.6843E-05_JPRB,4.0405E-05_JPRB,4.4378E-05_JPRB,4.8669E-05_JPRB/)  
KBO( :,42, 3) = (/&
 & 2.7178E-05_JPRB,2.9499E-05_JPRB,3.2305E-05_JPRB,3.5507E-05_JPRB,3.8948E-05_JPRB/)  
KBO( :,43, 3) = (/&
 & 2.1748E-05_JPRB,2.3526E-05_JPRB,2.5707E-05_JPRB,2.8262E-05_JPRB,3.0999E-05_JPRB/)  
KBO( :,44, 3) = (/&
 & 1.7386E-05_JPRB,1.8745E-05_JPRB,2.0430E-05_JPRB,2.2420E-05_JPRB,2.4615E-05_JPRB/)  
KBO( :,45, 3) = (/&
 & 1.3919E-05_JPRB,1.4955E-05_JPRB,1.6239E-05_JPRB,1.7786E-05_JPRB,1.9548E-05_JPRB/)  
KBO( :,46, 3) = (/&
 & 1.1164E-05_JPRB,1.1925E-05_JPRB,1.2898E-05_JPRB,1.4092E-05_JPRB,1.5493E-05_JPRB/)  
KBO( :,47, 3) = (/&
 & 8.9724E-06_JPRB,9.4906E-06_JPRB,1.0225E-05_JPRB,1.1136E-05_JPRB,1.2214E-05_JPRB/)  
KBO( :,48, 3) = (/&
 & 7.2294E-06_JPRB,7.5737E-06_JPRB,8.1199E-06_JPRB,8.8033E-06_JPRB,9.6335E-06_JPRB/)  
KBO( :,49, 3) = (/&
 & 5.8381E-06_JPRB,6.0726E-06_JPRB,6.4582E-06_JPRB,6.9718E-06_JPRB,7.6076E-06_JPRB/)  
KBO( :,50, 3) = (/&
 & 4.7296E-06_JPRB,4.8930E-06_JPRB,5.1532E-06_JPRB,5.5428E-06_JPRB,6.0261E-06_JPRB/)  
KBO( :,51, 3) = (/&
 & 3.8399E-06_JPRB,3.9514E-06_JPRB,4.1284E-06_JPRB,4.4168E-06_JPRB,4.7822E-06_JPRB/)  
KBO( :,52, 3) = (/&
 & 3.1245E-06_JPRB,3.1973E-06_JPRB,3.3211E-06_JPRB,3.5239E-06_JPRB,3.8012E-06_JPRB/)  
KBO( :,53, 3) = (/&
 & 2.5471E-06_JPRB,2.5925E-06_JPRB,2.6785E-06_JPRB,2.8158E-06_JPRB,3.0258E-06_JPRB/)  
KBO( :,54, 3) = (/&
 & 2.0814E-06_JPRB,2.1073E-06_JPRB,2.1664E-06_JPRB,2.2617E-06_JPRB,2.4173E-06_JPRB/)  
KBO( :,55, 3) = (/&
 & 1.7028E-06_JPRB,1.7165E-06_JPRB,1.7558E-06_JPRB,1.8239E-06_JPRB,1.9350E-06_JPRB/)  
KBO( :,56, 3) = (/&
 & 1.3936E-06_JPRB,1.4001E-06_JPRB,1.4255E-06_JPRB,1.4737E-06_JPRB,1.5508E-06_JPRB/)  
KBO( :,57, 3) = (/&
 & 1.1409E-06_JPRB,1.1442E-06_JPRB,1.1589E-06_JPRB,1.1924E-06_JPRB,1.2461E-06_JPRB/)  
KBO( :,58, 3) = (/&
 & 9.3532E-07_JPRB,9.3617E-07_JPRB,9.4415E-07_JPRB,9.6677E-07_JPRB,1.0053E-06_JPRB/)  
KBO( :,59, 3) = (/&
 & 7.6716E-07_JPRB,7.6655E-07_JPRB,7.7193E-07_JPRB,7.8900E-07_JPRB,8.1899E-07_JPRB/)  
KBO( :,13, 4) = (/&
 & 2.0095E-02_JPRB,2.1182E-02_JPRB,2.2225E-02_JPRB,2.3304E-02_JPRB,2.4394E-02_JPRB/)  
KBO( :,14, 4) = (/&
 & 1.6601E-02_JPRB,1.7480E-02_JPRB,1.8338E-02_JPRB,1.9231E-02_JPRB,2.0128E-02_JPRB/)  
KBO( :,15, 4) = (/&
 & 1.3711E-02_JPRB,1.4425E-02_JPRB,1.5134E-02_JPRB,1.5868E-02_JPRB,1.6611E-02_JPRB/)  
KBO( :,16, 4) = (/&
 & 1.1319E-02_JPRB,1.1903E-02_JPRB,1.2490E-02_JPRB,1.3094E-02_JPRB,1.3700E-02_JPRB/)  
KBO( :,17, 4) = (/&
 & 9.3377E-03_JPRB,9.8166E-03_JPRB,1.0301E-02_JPRB,1.0797E-02_JPRB,1.1296E-02_JPRB/)  
KBO( :,18, 4) = (/&
 & 7.6994E-03_JPRB,8.0931E-03_JPRB,8.4951E-03_JPRB,8.8986E-03_JPRB,9.3140E-03_JPRB/)  
KBO( :,19, 4) = (/&
 & 6.3454E-03_JPRB,6.6690E-03_JPRB,7.0019E-03_JPRB,7.3313E-03_JPRB,7.6829E-03_JPRB/)  
KBO( :,20, 4) = (/&
 & 5.2328E-03_JPRB,5.5001E-03_JPRB,5.7724E-03_JPRB,6.0469E-03_JPRB,6.3413E-03_JPRB/)  
KBO( :,21, 4) = (/&
 & 4.3150E-03_JPRB,4.5344E-03_JPRB,4.7593E-03_JPRB,4.9881E-03_JPRB,5.2336E-03_JPRB/)  
KBO( :,22, 4) = (/&
 & 3.5703E-03_JPRB,3.7499E-03_JPRB,3.9366E-03_JPRB,4.1268E-03_JPRB,4.3318E-03_JPRB/)  
KBO( :,23, 4) = (/&
 & 2.9547E-03_JPRB,3.1024E-03_JPRB,3.2576E-03_JPRB,3.4140E-03_JPRB,3.5849E-03_JPRB/)  
KBO( :,24, 4) = (/&
 & 2.4452E-03_JPRB,2.5697E-03_JPRB,2.6961E-03_JPRB,2.8259E-03_JPRB,2.9642E-03_JPRB/)  
KBO( :,25, 4) = (/&
 & 2.0245E-03_JPRB,2.1288E-03_JPRB,2.2320E-03_JPRB,2.3397E-03_JPRB,2.4511E-03_JPRB/)  
KBO( :,26, 4) = (/&
 & 1.6785E-03_JPRB,1.7643E-03_JPRB,1.8488E-03_JPRB,1.9387E-03_JPRB,2.0283E-03_JPRB/)  
KBO( :,27, 4) = (/&
 & 1.3920E-03_JPRB,1.4619E-03_JPRB,1.5313E-03_JPRB,1.6067E-03_JPRB,1.6789E-03_JPRB/)  
KBO( :,28, 4) = (/&
 & 1.1548E-03_JPRB,1.2112E-03_JPRB,1.2686E-03_JPRB,1.3305E-03_JPRB,1.3899E-03_JPRB/)  
KBO( :,29, 4) = (/&
 & 9.5779E-04_JPRB,1.0036E-03_JPRB,1.0515E-03_JPRB,1.1016E-03_JPRB,1.1501E-03_JPRB/)  
KBO( :,30, 4) = (/&
 & 7.9398E-04_JPRB,8.3159E-04_JPRB,8.7176E-04_JPRB,9.1222E-04_JPRB,9.5119E-04_JPRB/)  
KBO( :,31, 4) = (/&
 & 6.5813E-04_JPRB,6.8913E-04_JPRB,7.2305E-04_JPRB,7.5559E-04_JPRB,7.8680E-04_JPRB/)  
KBO( :,32, 4) = (/&
 & 5.4557E-04_JPRB,5.7133E-04_JPRB,5.9920E-04_JPRB,6.2591E-04_JPRB,6.5094E-04_JPRB/)  
KBO( :,33, 4) = (/&
 & 4.5225E-04_JPRB,4.7384E-04_JPRB,4.9635E-04_JPRB,5.1810E-04_JPRB,5.3850E-04_JPRB/)  
KBO( :,34, 4) = (/&
 & 3.7429E-04_JPRB,3.9240E-04_JPRB,4.1057E-04_JPRB,4.2811E-04_JPRB,4.4483E-04_JPRB/)  
KBO( :,35, 4) = (/&
 & 3.0841E-04_JPRB,3.2350E-04_JPRB,3.3821E-04_JPRB,3.5240E-04_JPRB,3.6608E-04_JPRB/)  
KBO( :,36, 4) = (/&
 & 2.5285E-04_JPRB,2.6525E-04_JPRB,2.7729E-04_JPRB,2.8885E-04_JPRB,3.0006E-04_JPRB/)  
KBO( :,37, 4) = (/&
 & 2.0586E-04_JPRB,2.1585E-04_JPRB,2.2582E-04_JPRB,2.3540E-04_JPRB,2.4457E-04_JPRB/)  
KBO( :,38, 4) = (/&
 & 1.6753E-04_JPRB,1.7559E-04_JPRB,1.8384E-04_JPRB,1.9177E-04_JPRB,1.9927E-04_JPRB/)  
KBO( :,39, 4) = (/&
 & 1.3635E-04_JPRB,1.4286E-04_JPRB,1.4968E-04_JPRB,1.5622E-04_JPRB,1.6235E-04_JPRB/)  
KBO( :,40, 4) = (/&
 & 1.1045E-04_JPRB,1.1567E-04_JPRB,1.2132E-04_JPRB,1.2672E-04_JPRB,1.3176E-04_JPRB/)  
KBO( :,41, 4) = (/&
 & 8.9410E-05_JPRB,9.3610E-05_JPRB,9.8241E-05_JPRB,1.0266E-04_JPRB,1.0686E-04_JPRB/)  
KBO( :,42, 4) = (/&
 & 7.2378E-05_JPRB,7.5781E-05_JPRB,7.9465E-05_JPRB,8.3145E-05_JPRB,8.6672E-05_JPRB/)  
KBO( :,43, 4) = (/&
 & 5.8424E-05_JPRB,6.1188E-05_JPRB,6.4107E-05_JPRB,6.7188E-05_JPRB,7.0140E-05_JPRB/)  
KBO( :,44, 4) = (/&
 & 4.7058E-05_JPRB,4.9346E-05_JPRB,5.1671E-05_JPRB,5.4230E-05_JPRB,5.6657E-05_JPRB/)  
KBO( :,45, 4) = (/&
 & 3.7899E-05_JPRB,3.9798E-05_JPRB,4.1669E-05_JPRB,4.3706E-05_JPRB,4.5724E-05_JPRB/)  
KBO( :,46, 4) = (/&
 & 3.0497E-05_JPRB,3.2055E-05_JPRB,3.3572E-05_JPRB,3.5176E-05_JPRB,3.6873E-05_JPRB/)  
KBO( :,47, 4) = (/&
 & 2.4479E-05_JPRB,2.5732E-05_JPRB,2.6995E-05_JPRB,2.8267E-05_JPRB,2.9671E-05_JPRB/)  
KBO( :,48, 4) = (/&
 & 1.9635E-05_JPRB,2.0659E-05_JPRB,2.1706E-05_JPRB,2.2729E-05_JPRB,2.3830E-05_JPRB/)  
KBO( :,49, 4) = (/&
 & 1.5750E-05_JPRB,1.6588E-05_JPRB,1.7438E-05_JPRB,1.8276E-05_JPRB,1.9144E-05_JPRB/)  
KBO( :,50, 4) = (/&
 & 1.2638E-05_JPRB,1.3327E-05_JPRB,1.4014E-05_JPRB,1.4713E-05_JPRB,1.5408E-05_JPRB/)  
KBO( :,51, 4) = (/&
 & 1.0134E-05_JPRB,1.0710E-05_JPRB,1.1273E-05_JPRB,1.1849E-05_JPRB,1.2410E-05_JPRB/)  
KBO( :,52, 4) = (/&
 & 8.1350E-06_JPRB,8.6070E-06_JPRB,9.0666E-06_JPRB,9.5314E-06_JPRB,9.9961E-06_JPRB/)  
KBO( :,53, 4) = (/&
 & 6.5268E-06_JPRB,6.9077E-06_JPRB,7.2874E-06_JPRB,7.6647E-06_JPRB,8.0514E-06_JPRB/)  
KBO( :,54, 4) = (/&
 & 5.2400E-06_JPRB,5.5504E-06_JPRB,5.8662E-06_JPRB,6.1754E-06_JPRB,6.4922E-06_JPRB/)  
KBO( :,55, 4) = (/&
 & 4.2244E-06_JPRB,4.4665E-06_JPRB,4.7250E-06_JPRB,4.9775E-06_JPRB,5.2331E-06_JPRB/)  
KBO( :,56, 4) = (/&
 & 3.4163E-06_JPRB,3.5930E-06_JPRB,3.8023E-06_JPRB,4.0104E-06_JPRB,4.2175E-06_JPRB/)  
KBO( :,57, 4) = (/&
 & 2.7693E-06_JPRB,2.8867E-06_JPRB,3.0575E-06_JPRB,3.2307E-06_JPRB,3.4003E-06_JPRB/)  
KBO( :,58, 4) = (/&
 & 2.2500E-06_JPRB,2.3279E-06_JPRB,2.4627E-06_JPRB,2.6048E-06_JPRB,2.7433E-06_JPRB/)  
KBO( :,59, 4) = (/&
 & 1.8386E-06_JPRB,1.8966E-06_JPRB,2.0040E-06_JPRB,2.1199E-06_JPRB,2.2332E-06_JPRB/)  
KBO( :,13, 5) = (/&
 & 3.7227E-02_JPRB,3.9236E-02_JPRB,4.1136E-02_JPRB,4.2635E-02_JPRB,4.4125E-02_JPRB/)  
KBO( :,14, 5) = (/&
 & 3.0731E-02_JPRB,3.2386E-02_JPRB,3.3908E-02_JPRB,3.5126E-02_JPRB,3.6383E-02_JPRB/)  
KBO( :,15, 5) = (/&
 & 2.5378E-02_JPRB,2.6727E-02_JPRB,2.7941E-02_JPRB,2.8947E-02_JPRB,3.0002E-02_JPRB/)  
KBO( :,16, 5) = (/&
 & 2.0959E-02_JPRB,2.2046E-02_JPRB,2.3014E-02_JPRB,2.3851E-02_JPRB,2.4734E-02_JPRB/)  
KBO( :,17, 5) = (/&
 & 1.7294E-02_JPRB,1.8176E-02_JPRB,1.8952E-02_JPRB,1.9643E-02_JPRB,2.0380E-02_JPRB/)  
KBO( :,18, 5) = (/&
 & 1.4261E-02_JPRB,1.4983E-02_JPRB,1.5597E-02_JPRB,1.6174E-02_JPRB,1.6784E-02_JPRB/)  
KBO( :,19, 5) = (/&
 & 1.1754E-02_JPRB,1.2342E-02_JPRB,1.2837E-02_JPRB,1.3312E-02_JPRB,1.3820E-02_JPRB/)  
KBO( :,20, 5) = (/&
 & 9.6940E-03_JPRB,1.0172E-02_JPRB,1.0569E-02_JPRB,1.0962E-02_JPRB,1.1389E-02_JPRB/)  
KBO( :,21, 5) = (/&
 & 7.9935E-03_JPRB,8.3804E-03_JPRB,8.7019E-03_JPRB,9.0256E-03_JPRB,9.3917E-03_JPRB/)  
KBO( :,22, 5) = (/&
 & 6.6098E-03_JPRB,6.9213E-03_JPRB,7.1802E-03_JPRB,7.4552E-03_JPRB,7.7626E-03_JPRB/)  
KBO( :,23, 5) = (/&
 & 5.4675E-03_JPRB,5.7122E-03_JPRB,5.9276E-03_JPRB,6.1590E-03_JPRB,6.4177E-03_JPRB/)  
KBO( :,24, 5) = (/&
 & 4.5248E-03_JPRB,4.7145E-03_JPRB,4.8956E-03_JPRB,5.0905E-03_JPRB,5.3103E-03_JPRB/)  
KBO( :,25, 5) = (/&
 & 3.7436E-03_JPRB,3.8938E-03_JPRB,4.0451E-03_JPRB,4.2083E-03_JPRB,4.3977E-03_JPRB/)  
KBO( :,26, 5) = (/&
 & 3.0980E-03_JPRB,3.2193E-03_JPRB,3.3446E-03_JPRB,3.4820E-03_JPRB,3.6461E-03_JPRB/)  
KBO( :,27, 5) = (/&
 & 2.5629E-03_JPRB,2.6621E-03_JPRB,2.7660E-03_JPRB,2.8810E-03_JPRB,3.0242E-03_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB2:PART3',1,ZHOOK_HANDLE)
END SUBROUTINE PART3


SUBROUTINE PART4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB2:PART4',0,ZHOOK_HANDLE)


KBO( :,28, 5) = (/&
 & 2.1185E-03_JPRB,2.2012E-03_JPRB,2.2881E-03_JPRB,2.3854E-03_JPRB,2.5100E-03_JPRB/)  
KBO( :,29, 5) = (/&
 & 1.7520E-03_JPRB,1.8201E-03_JPRB,1.8933E-03_JPRB,1.9774E-03_JPRB,2.0861E-03_JPRB/)  
KBO( :,30, 5) = (/&
 & 1.4490E-03_JPRB,1.5053E-03_JPRB,1.5668E-03_JPRB,1.6405E-03_JPRB,1.7353E-03_JPRB/)  
KBO( :,31, 5) = (/&
 & 1.1987E-03_JPRB,1.2454E-03_JPRB,1.2970E-03_JPRB,1.3620E-03_JPRB,1.4446E-03_JPRB/)  
KBO( :,32, 5) = (/&
 & 9.9162E-04_JPRB,1.0307E-03_JPRB,1.0749E-03_JPRB,1.1317E-03_JPRB,1.2036E-03_JPRB/)  
KBO( :,33, 5) = (/&
 & 8.2024E-04_JPRB,8.5336E-04_JPRB,8.9176E-04_JPRB,9.4137E-04_JPRB,1.0034E-03_JPRB/)  
KBO( :,34, 5) = (/&
 & 6.7773E-04_JPRB,7.0554E-04_JPRB,7.3898E-04_JPRB,7.8201E-04_JPRB,8.3490E-04_JPRB/)  
KBO( :,35, 5) = (/&
 & 5.5797E-04_JPRB,5.8103E-04_JPRB,6.0950E-04_JPRB,6.4595E-04_JPRB,6.9024E-04_JPRB/)  
KBO( :,36, 5) = (/&
 & 4.5741E-04_JPRB,4.7636E-04_JPRB,4.9987E-04_JPRB,5.2994E-04_JPRB,5.6634E-04_JPRB/)  
KBO( :,37, 5) = (/&
 & 3.7275E-04_JPRB,3.8812E-04_JPRB,4.0671E-04_JPRB,4.3063E-04_JPRB,4.5983E-04_JPRB/)  
KBO( :,38, 5) = (/&
 & 3.0368E-04_JPRB,3.1612E-04_JPRB,3.3079E-04_JPRB,3.4977E-04_JPRB,3.7316E-04_JPRB/)  
KBO( :,39, 5) = (/&
 & 2.4743E-04_JPRB,2.5746E-04_JPRB,2.6909E-04_JPRB,2.8414E-04_JPRB,3.0287E-04_JPRB/)  
KBO( :,40, 5) = (/&
 & 2.0083E-04_JPRB,2.0881E-04_JPRB,2.1786E-04_JPRB,2.2950E-04_JPRB,2.4422E-04_JPRB/)  
KBO( :,41, 5) = (/&
 & 1.6290E-04_JPRB,1.6930E-04_JPRB,1.7640E-04_JPRB,1.8539E-04_JPRB,1.9681E-04_JPRB/)  
KBO( :,42, 5) = (/&
 & 1.3212E-04_JPRB,1.3729E-04_JPRB,1.4297E-04_JPRB,1.4983E-04_JPRB,1.5865E-04_JPRB/)  
KBO( :,43, 5) = (/&
 & 1.0692E-04_JPRB,1.1111E-04_JPRB,1.1561E-04_JPRB,1.2081E-04_JPRB,1.2752E-04_JPRB/)  
KBO( :,44, 5) = (/&
 & 8.6484E-05_JPRB,8.9851E-05_JPRB,9.3401E-05_JPRB,9.7384E-05_JPRB,1.0246E-04_JPRB/)  
KBO( :,45, 5) = (/&
 & 6.9902E-05_JPRB,7.2641E-05_JPRB,7.5491E-05_JPRB,7.8632E-05_JPRB,8.2438E-05_JPRB/)  
KBO( :,46, 5) = (/&
 & 5.6357E-05_JPRB,5.8678E-05_JPRB,6.0987E-05_JPRB,6.3456E-05_JPRB,6.6309E-05_JPRB/)  
KBO( :,47, 5) = (/&
 & 4.5246E-05_JPRB,4.7351E-05_JPRB,4.9188E-05_JPRB,5.1132E-05_JPRB,5.3302E-05_JPRB/)  
KBO( :,48, 5) = (/&
 & 3.6331E-05_JPRB,3.8149E-05_JPRB,3.9667E-05_JPRB,4.1226E-05_JPRB,4.2932E-05_JPRB/)  
KBO( :,49, 5) = (/&
 & 2.9150E-05_JPRB,3.0662E-05_JPRB,3.1997E-05_JPRB,3.3254E-05_JPRB,3.4583E-05_JPRB/)  
KBO( :,50, 5) = (/&
 & 2.3393E-05_JPRB,2.4645E-05_JPRB,2.5835E-05_JPRB,2.6842E-05_JPRB,2.7903E-05_JPRB/)  
KBO( :,51, 5) = (/&
 & 1.8850E-05_JPRB,1.9822E-05_JPRB,2.0830E-05_JPRB,2.1675E-05_JPRB,2.2533E-05_JPRB/)  
KBO( :,52, 5) = (/&
 & 1.5259E-05_JPRB,1.5932E-05_JPRB,1.6760E-05_JPRB,1.7514E-05_JPRB,1.8199E-05_JPRB/)  
KBO( :,53, 5) = (/&
 & 1.2418E-05_JPRB,1.2796E-05_JPRB,1.3482E-05_JPRB,1.4141E-05_JPRB,1.4696E-05_JPRB/)  
KBO( :,54, 5) = (/&
 & 1.0153E-05_JPRB,1.0334E-05_JPRB,1.0859E-05_JPRB,1.1414E-05_JPRB,1.1882E-05_JPRB/)  
KBO( :,55, 5) = (/&
 & 8.3134E-06_JPRB,8.3805E-06_JPRB,8.7476E-06_JPRB,9.2016E-06_JPRB,9.6168E-06_JPRB/)  
KBO( :,56, 5) = (/&
 & 6.8128E-06_JPRB,6.8250E-06_JPRB,7.0422E-06_JPRB,7.4184E-06_JPRB,7.7786E-06_JPRB/)  
KBO( :,57, 5) = (/&
 & 5.5871E-06_JPRB,5.5794E-06_JPRB,5.6879E-06_JPRB,5.9805E-06_JPRB,6.2836E-06_JPRB/)  
KBO( :,58, 5) = (/&
 & 4.5833E-06_JPRB,4.5677E-06_JPRB,4.6123E-06_JPRB,4.8228E-06_JPRB,5.0715E-06_JPRB/)  
KBO( :,59, 5) = (/&
 & 3.7554E-06_JPRB,3.7413E-06_JPRB,3.7664E-06_JPRB,3.9250E-06_JPRB,4.1286E-06_JPRB/)  
KBO( :,13, 6) = (/&
 & 5.9721E-02_JPRB,6.1354E-02_JPRB,6.5184E-02_JPRB,7.1296E-02_JPRB,7.9076E-02_JPRB/)  
KBO( :,14, 6) = (/&
 & 4.9090E-02_JPRB,5.0657E-02_JPRB,5.4055E-02_JPRB,5.9268E-02_JPRB,6.5784E-02_JPRB/)  
KBO( :,15, 6) = (/&
 & 4.0373E-02_JPRB,4.1857E-02_JPRB,4.4839E-02_JPRB,4.9265E-02_JPRB,5.4749E-02_JPRB/)  
KBO( :,16, 6) = (/&
 & 3.3205E-02_JPRB,3.4589E-02_JPRB,3.7200E-02_JPRB,4.0963E-02_JPRB,4.5588E-02_JPRB/)  
KBO( :,17, 6) = (/&
 & 2.7321E-02_JPRB,2.8572E-02_JPRB,3.0844E-02_JPRB,3.4044E-02_JPRB,3.7943E-02_JPRB/)  
KBO( :,18, 6) = (/&
 & 2.2479E-02_JPRB,2.3595E-02_JPRB,2.5570E-02_JPRB,2.8293E-02_JPRB,3.1545E-02_JPRB/)  
KBO( :,19, 6) = (/&
 & 1.8500E-02_JPRB,1.9491E-02_JPRB,2.1196E-02_JPRB,2.3496E-02_JPRB,2.6203E-02_JPRB/)  
KBO( :,20, 6) = (/&
 & 1.5238E-02_JPRB,1.6125E-02_JPRB,1.7598E-02_JPRB,1.9543E-02_JPRB,2.1792E-02_JPRB/)  
KBO( :,21, 6) = (/&
 & 1.2557E-02_JPRB,1.3343E-02_JPRB,1.4614E-02_JPRB,1.6252E-02_JPRB,1.8124E-02_JPRB/)  
KBO( :,22, 6) = (/&
 & 1.0384E-02_JPRB,1.1107E-02_JPRB,1.2217E-02_JPRB,1.3612E-02_JPRB,1.5187E-02_JPRB/)  
KBO( :,23, 6) = (/&
 & 8.6014E-03_JPRB,9.2602E-03_JPRB,1.0223E-02_JPRB,1.1410E-02_JPRB,1.2737E-02_JPRB/)  
KBO( :,24, 6) = (/&
 & 7.1344E-03_JPRB,7.7349E-03_JPRB,8.5670E-03_JPRB,9.5773E-03_JPRB,1.0688E-02_JPRB/)  
KBO( :,25, 6) = (/&
 & 5.9318E-03_JPRB,6.4720E-03_JPRB,7.1956E-03_JPRB,8.0463E-03_JPRB,8.9744E-03_JPRB/)  
KBO( :,26, 6) = (/&
 & 4.9484E-03_JPRB,5.4321E-03_JPRB,6.0595E-03_JPRB,6.7732E-03_JPRB,7.5465E-03_JPRB/)  
KBO( :,27, 6) = (/&
 & 4.1359E-03_JPRB,4.5660E-03_JPRB,5.1046E-03_JPRB,5.7011E-03_JPRB,6.3447E-03_JPRB/)  
KBO( :,28, 6) = (/&
 & 3.4651E-03_JPRB,3.8427E-03_JPRB,4.2986E-03_JPRB,4.7976E-03_JPRB,5.3324E-03_JPRB/)  
KBO( :,29, 6) = (/&
 & 2.9102E-03_JPRB,3.2386E-03_JPRB,3.6218E-03_JPRB,4.0393E-03_JPRB,4.4830E-03_JPRB/)  
KBO( :,30, 6) = (/&
 & 2.4470E-03_JPRB,2.7307E-03_JPRB,3.0520E-03_JPRB,3.4007E-03_JPRB,3.7682E-03_JPRB/)  
KBO( :,31, 6) = (/&
 & 2.0606E-03_JPRB,2.3037E-03_JPRB,2.5728E-03_JPRB,2.8636E-03_JPRB,3.1684E-03_JPRB/)  
KBO( :,32, 6) = (/&
 & 1.7372E-03_JPRB,1.9434E-03_JPRB,2.1690E-03_JPRB,2.4112E-03_JPRB,2.6643E-03_JPRB/)  
KBO( :,33, 6) = (/&
 & 1.4660E-03_JPRB,1.6395E-03_JPRB,1.8287E-03_JPRB,2.0301E-03_JPRB,2.2400E-03_JPRB/)  
KBO( :,34, 6) = (/&
 & 1.2328E-03_JPRB,1.3780E-03_JPRB,1.5359E-03_JPRB,1.7027E-03_JPRB,1.8761E-03_JPRB/)  
KBO( :,35, 6) = (/&
 & 1.0255E-03_JPRB,1.1459E-03_JPRB,1.2766E-03_JPRB,1.4142E-03_JPRB,1.5568E-03_JPRB/)  
KBO( :,36, 6) = (/&
 & 8.4246E-04_JPRB,9.4144E-04_JPRB,1.0489E-03_JPRB,1.1618E-03_JPRB,1.2788E-03_JPRB/)  
KBO( :,37, 6) = (/&
 & 6.8032E-04_JPRB,7.6059E-04_JPRB,8.4800E-04_JPRB,9.4011E-04_JPRB,1.0358E-03_JPRB/)  
KBO( :,38, 6) = (/&
 & 5.4877E-04_JPRB,6.1380E-04_JPRB,6.8481E-04_JPRB,7.5996E-04_JPRB,8.3820E-04_JPRB/)  
KBO( :,39, 6) = (/&
 & 4.4270E-04_JPRB,4.9539E-04_JPRB,5.5302E-04_JPRB,6.1429E-04_JPRB,6.7818E-04_JPRB/)  
KBO( :,40, 6) = (/&
 & 3.5308E-04_JPRB,3.9528E-04_JPRB,4.4159E-04_JPRB,4.9127E-04_JPRB,5.4322E-04_JPRB/)  
KBO( :,41, 6) = (/&
 & 2.8136E-04_JPRB,3.1489E-04_JPRB,3.5201E-04_JPRB,3.9219E-04_JPRB,4.3434E-04_JPRB/)  
KBO( :,42, 6) = (/&
 & 2.2435E-04_JPRB,2.5074E-04_JPRB,2.8049E-04_JPRB,3.1292E-04_JPRB,3.4710E-04_JPRB/)  
KBO( :,43, 6) = (/&
 & 1.7802E-04_JPRB,1.9831E-04_JPRB,2.2204E-04_JPRB,2.4800E-04_JPRB,2.7568E-04_JPRB/)  
KBO( :,44, 6) = (/&
 & 1.4111E-04_JPRB,1.5650E-04_JPRB,1.7526E-04_JPRB,1.9592E-04_JPRB,2.1824E-04_JPRB/)  
KBO( :,45, 6) = (/&
 & 1.1219E-04_JPRB,1.2365E-04_JPRB,1.3828E-04_JPRB,1.5471E-04_JPRB,1.7263E-04_JPRB/)  
KBO( :,46, 6) = (/&
 & 8.9353E-05_JPRB,9.7626E-05_JPRB,1.0876E-04_JPRB,1.2182E-04_JPRB,1.3611E-04_JPRB/)  
KBO( :,47, 6) = (/&
 & 7.1331E-05_JPRB,7.6923E-05_JPRB,8.5223E-05_JPRB,9.5443E-05_JPRB,1.0675E-04_JPRB/)  
KBO( :,48, 6) = (/&
 & 5.7219E-05_JPRB,6.0885E-05_JPRB,6.6897E-05_JPRB,7.4726E-05_JPRB,8.3664E-05_JPRB/)  
KBO( :,49, 6) = (/&
 & 4.6157E-05_JPRB,4.8450E-05_JPRB,5.2634E-05_JPRB,5.8499E-05_JPRB,6.5552E-05_JPRB/)  
KBO( :,50, 6) = (/&
 & 3.7497E-05_JPRB,3.8822E-05_JPRB,4.1643E-05_JPRB,4.5997E-05_JPRB,5.1490E-05_JPRB/)  
KBO( :,51, 6) = (/&
 & 3.0548E-05_JPRB,3.1258E-05_JPRB,3.3116E-05_JPRB,3.6272E-05_JPRB,4.0468E-05_JPRB/)  
KBO( :,52, 6) = (/&
 & 2.4904E-05_JPRB,2.5290E-05_JPRB,2.6467E-05_JPRB,2.8662E-05_JPRB,3.1824E-05_JPRB/)  
KBO( :,53, 6) = (/&
 & 2.0318E-05_JPRB,2.0573E-05_JPRB,2.1239E-05_JPRB,2.2721E-05_JPRB,2.5059E-05_JPRB/)  
KBO( :,54, 6) = (/&
 & 1.6597E-05_JPRB,1.6771E-05_JPRB,1.7139E-05_JPRB,1.8127E-05_JPRB,1.9830E-05_JPRB/)  
KBO( :,55, 6) = (/&
 & 1.3561E-05_JPRB,1.3681E-05_JPRB,1.3892E-05_JPRB,1.4536E-05_JPRB,1.5739E-05_JPRB/)  
KBO( :,56, 6) = (/&
 & 1.1086E-05_JPRB,1.1167E-05_JPRB,1.1310E-05_JPRB,1.1693E-05_JPRB,1.2526E-05_JPRB/)  
KBO( :,57, 6) = (/&
 & 9.0628E-06_JPRB,9.1225E-06_JPRB,9.2203E-06_JPRB,9.4367E-06_JPRB,9.9993E-06_JPRB/)  
KBO( :,58, 6) = (/&
 & 7.4303E-06_JPRB,7.4548E-06_JPRB,7.5223E-06_JPRB,7.6481E-06_JPRB,8.0215E-06_JPRB/)  
KBO( :,59, 6) = (/&
 & 6.0935E-06_JPRB,6.1009E-06_JPRB,6.1525E-06_JPRB,6.2448E-06_JPRB,6.5226E-06_JPRB/)  
KBO( :,13, 7) = (/&
 & 1.1588E-01_JPRB,1.3365E-01_JPRB,1.5332E-01_JPRB,1.7451E-01_JPRB,1.9690E-01_JPRB/)  
KBO( :,14, 7) = (/&
 & 9.7055E-02_JPRB,1.1196E-01_JPRB,1.2839E-01_JPRB,1.4612E-01_JPRB,1.6488E-01_JPRB/)  
KBO( :,15, 7) = (/&
 & 8.1294E-02_JPRB,9.3772E-02_JPRB,1.0756E-01_JPRB,1.2240E-01_JPRB,1.3809E-01_JPRB/)  
KBO( :,16, 7) = (/&
 & 6.8061E-02_JPRB,7.8545E-02_JPRB,9.0101E-02_JPRB,1.0250E-01_JPRB,1.1550E-01_JPRB/)  
KBO( :,17, 7) = (/&
 & 5.6952E-02_JPRB,6.5739E-02_JPRB,7.5393E-02_JPRB,8.5665E-02_JPRB,9.6436E-02_JPRB/)  
KBO( :,18, 7) = (/&
 & 4.7617E-02_JPRB,5.4966E-02_JPRB,6.2979E-02_JPRB,7.1480E-02_JPRB,8.0409E-02_JPRB/)  
KBO( :,19, 7) = (/&
 & 3.9773E-02_JPRB,4.5894E-02_JPRB,5.2544E-02_JPRB,5.9585E-02_JPRB,6.7003E-02_JPRB/)  
KBO( :,20, 7) = (/&
 & 3.3266E-02_JPRB,3.8381E-02_JPRB,4.3891E-02_JPRB,4.9742E-02_JPRB,5.5899E-02_JPRB/)  
KBO( :,21, 7) = (/&
 & 2.7821E-02_JPRB,3.2077E-02_JPRB,3.6647E-02_JPRB,4.1505E-02_JPRB,4.6608E-02_JPRB/)  
KBO( :,22, 7) = (/&
 & 2.3478E-02_JPRB,2.7039E-02_JPRB,3.0839E-02_JPRB,3.4879E-02_JPRB,3.9103E-02_JPRB/)  
KBO( :,23, 7) = (/&
 & 1.9822E-02_JPRB,2.2790E-02_JPRB,2.5960E-02_JPRB,2.9305E-02_JPRB,3.2804E-02_JPRB/)  
KBO( :,24, 7) = (/&
 & 1.6745E-02_JPRB,1.9225E-02_JPRB,2.1856E-02_JPRB,2.4636E-02_JPRB,2.7545E-02_JPRB/)  
KBO( :,25, 7) = (/&
 & 1.4161E-02_JPRB,1.6225E-02_JPRB,1.8415E-02_JPRB,2.0732E-02_JPRB,2.3157E-02_JPRB/)  
KBO( :,26, 7) = (/&
 & 1.2003E-02_JPRB,1.3719E-02_JPRB,1.5547E-02_JPRB,1.7489E-02_JPRB,1.9498E-02_JPRB/)  
KBO( :,27, 7) = (/&
 & 1.0171E-02_JPRB,1.1602E-02_JPRB,1.3133E-02_JPRB,1.4753E-02_JPRB,1.6413E-02_JPRB/)  
KBO( :,28, 7) = (/&
 & 8.6151E-03_JPRB,9.8138E-03_JPRB,1.1097E-02_JPRB,1.2440E-02_JPRB,1.3808E-02_JPRB/)  
KBO( :,29, 7) = (/&
 & 7.3031E-03_JPRB,8.3100E-03_JPRB,9.3806E-03_JPRB,1.0489E-02_JPRB,1.1614E-02_JPRB/)  
KBO( :,30, 7) = (/&
 & 6.1924E-03_JPRB,7.0350E-03_JPRB,7.9243E-03_JPRB,8.8379E-03_JPRB,9.7615E-03_JPRB/)  
KBO( :,31, 7) = (/&
 & 5.2533E-03_JPRB,5.9562E-03_JPRB,6.6929E-03_JPRB,7.4442E-03_JPRB,8.2040E-03_JPRB/)  
KBO( :,32, 7) = (/&
 & 4.4571E-03_JPRB,5.0422E-03_JPRB,5.6504E-03_JPRB,6.2688E-03_JPRB,6.8946E-03_JPRB/)  
KBO( :,33, 7) = (/&
 & 3.7800E-03_JPRB,4.2660E-03_JPRB,4.7678E-03_JPRB,5.2772E-03_JPRB,5.7931E-03_JPRB/)  
KBO( :,34, 7) = (/&
 & 3.1899E-03_JPRB,3.5923E-03_JPRB,4.0058E-03_JPRB,4.4259E-03_JPRB,4.8520E-03_JPRB/)  
KBO( :,35, 7) = (/&
 & 2.6588E-03_JPRB,2.9911E-03_JPRB,3.3311E-03_JPRB,3.6773E-03_JPRB,4.0289E-03_JPRB/)  
KBO( :,36, 7) = (/&
 & 2.1867E-03_JPRB,2.4598E-03_JPRB,2.7392E-03_JPRB,3.0239E-03_JPRB,3.3135E-03_JPRB/)  
KBO( :,37, 7) = (/&
 & 1.7654E-03_JPRB,1.9884E-03_JPRB,2.2175E-03_JPRB,2.4512E-03_JPRB,2.6886E-03_JPRB/)  
KBO( :,38, 7) = (/&
 & 1.4235E-03_JPRB,1.6055E-03_JPRB,1.7932E-03_JPRB,1.9849E-03_JPRB,2.1796E-03_JPRB/)  
KBO( :,39, 7) = (/&
 & 1.1477E-03_JPRB,1.2961E-03_JPRB,1.4499E-03_JPRB,1.6071E-03_JPRB,1.7668E-03_JPRB/)  
KBO( :,40, 7) = (/&
 & 9.1302E-04_JPRB,1.0335E-03_JPRB,1.1591E-03_JPRB,1.2877E-03_JPRB,1.4185E-03_JPRB/)  
KBO( :,41, 7) = (/&
 & 7.2467E-04_JPRB,8.2221E-04_JPRB,9.2464E-04_JPRB,1.0298E-03_JPRB,1.1370E-03_JPRB/)  
KBO( :,42, 7) = (/&
 & 5.7474E-04_JPRB,6.5369E-04_JPRB,7.3701E-04_JPRB,8.2293E-04_JPRB,9.1070E-04_JPRB/)  
KBO( :,43, 7) = (/&
 & 4.5204E-04_JPRB,5.1571E-04_JPRB,5.8312E-04_JPRB,6.5322E-04_JPRB,7.2492E-04_JPRB/)  
KBO( :,44, 7) = (/&
 & 3.5397E-04_JPRB,4.0509E-04_JPRB,4.5944E-04_JPRB,5.1651E-04_JPRB,5.7502E-04_JPRB/)  
KBO( :,45, 7) = (/&
 & 2.7677E-04_JPRB,3.1783E-04_JPRB,3.6162E-04_JPRB,4.0793E-04_JPRB,4.5562E-04_JPRB/)  
KBO( :,46, 7) = (/&
 & 2.1540E-04_JPRB,2.4835E-04_JPRB,2.8358E-04_JPRB,3.2093E-04_JPRB,3.5979E-04_JPRB/)  
KBO( :,47, 7) = (/&
 & 1.6633E-04_JPRB,1.9266E-04_JPRB,2.2081E-04_JPRB,2.5080E-04_JPRB,2.8236E-04_JPRB/)  
KBO( :,48, 7) = (/&
 & 1.2830E-04_JPRB,1.4914E-04_JPRB,1.7167E-04_JPRB,1.9573E-04_JPRB,2.2121E-04_JPRB/)  
KBO( :,49, 7) = (/&
 & 9.8900E-05_JPRB,1.1524E-04_JPRB,1.3325E-04_JPRB,1.5252E-04_JPRB,1.7300E-04_JPRB/)  
KBO( :,50, 7) = (/&
 & 7.6523E-05_JPRB,8.9264E-05_JPRB,1.0363E-04_JPRB,1.1906E-04_JPRB,1.3550E-04_JPRB/)  
KBO( :,51, 7) = (/&
 & 5.9350E-05_JPRB,6.9204E-05_JPRB,8.0571E-05_JPRB,9.2952E-05_JPRB,1.0617E-04_JPRB/)  
KBO( :,52, 7) = (/&
 & 4.6110E-05_JPRB,5.3638E-05_JPRB,6.2565E-05_JPRB,7.2480E-05_JPRB,8.3081E-05_JPRB/)  
KBO( :,53, 7) = (/&
 & 3.5907E-05_JPRB,4.1572E-05_JPRB,4.8523E-05_JPRB,5.6421E-05_JPRB,6.4919E-05_JPRB/)  
KBO( :,54, 7) = (/&
 & 2.8169E-05_JPRB,3.2394E-05_JPRB,3.7786E-05_JPRB,4.4047E-05_JPRB,5.0874E-05_JPRB/)  
KBO( :,55, 7) = (/&
 & 2.2244E-05_JPRB,2.5332E-05_JPRB,2.9480E-05_JPRB,3.4420E-05_JPRB,3.9903E-05_JPRB/)  
KBO( :,56, 7) = (/&
 & 1.7661E-05_JPRB,1.9848E-05_JPRB,2.3004E-05_JPRB,2.6875E-05_JPRB,3.1261E-05_JPRB/)  
KBO( :,57, 7) = (/&
 & 1.4116E-05_JPRB,1.5590E-05_JPRB,1.7962E-05_JPRB,2.0972E-05_JPRB,2.4457E-05_JPRB/)  
KBO( :,58, 7) = (/&
 & 1.1342E-05_JPRB,1.2323E-05_JPRB,1.4076E-05_JPRB,1.6403E-05_JPRB,1.9161E-05_JPRB/)  
KBO( :,59, 7) = (/&
 & 9.2282E-06_JPRB,9.9669E-06_JPRB,1.1338E-05_JPRB,1.3199E-05_JPRB,1.5427E-05_JPRB/)  
KBO( :,13, 8) = (/&
 & 3.3007E-01_JPRB,3.9651E-01_JPRB,4.6809E-01_JPRB,5.4357E-01_JPRB,6.2157E-01_JPRB/)  
KBO( :,14, 8) = (/&
 & 2.7899E-01_JPRB,3.3507E-01_JPRB,3.9534E-01_JPRB,4.5851E-01_JPRB,5.2383E-01_JPRB/)  
KBO( :,15, 8) = (/&
 & 2.3603E-01_JPRB,2.8320E-01_JPRB,3.3377E-01_JPRB,3.8669E-01_JPRB,4.4137E-01_JPRB/)  
KBO( :,16, 8) = (/&
 & 1.9959E-01_JPRB,2.3926E-01_JPRB,2.8155E-01_JPRB,3.2567E-01_JPRB,3.7161E-01_JPRB/)  
KBO( :,17, 8) = (/&
 & 1.6854E-01_JPRB,2.0171E-01_JPRB,2.3696E-01_JPRB,2.7391E-01_JPRB,3.1236E-01_JPRB/)  
KBO( :,18, 8) = (/&
 & 1.4209E-01_JPRB,1.6977E-01_JPRB,1.9918E-01_JPRB,2.3009E-01_JPRB,2.6229E-01_JPRB/)  
KBO( :,19, 8) = (/&
 & 1.1954E-01_JPRB,1.4262E-01_JPRB,1.6719E-01_JPRB,1.9301E-01_JPRB,2.1984E-01_JPRB/)  
KBO( :,20, 8) = (/&
 & 1.0077E-01_JPRB,1.2005E-01_JPRB,1.4054E-01_JPRB,1.6208E-01_JPRB,1.8429E-01_JPRB/)  
KBO( :,21, 8) = (/&
 & 8.4914E-02_JPRB,1.0100E-01_JPRB,1.1806E-01_JPRB,1.3588E-01_JPRB,1.5437E-01_JPRB/)  
KBO( :,22, 8) = (/&
 & 7.2355E-02_JPRB,8.5791E-02_JPRB,9.9982E-02_JPRB,1.1481E-01_JPRB,1.3020E-01_JPRB/)  
KBO( :,23, 8) = (/&
 & 6.1637E-02_JPRB,7.2833E-02_JPRB,8.4658E-02_JPRB,9.6984E-02_JPRB,1.0981E-01_JPRB/)  
KBO( :,24, 8) = (/&
 & 5.2514E-02_JPRB,6.1860E-02_JPRB,7.1701E-02_JPRB,8.1967E-02_JPRB,9.2596E-02_JPRB/)  
KBO( :,25, 8) = (/&
 & 4.4769E-02_JPRB,5.2568E-02_JPRB,6.0763E-02_JPRB,6.9296E-02_JPRB,7.8120E-02_JPRB/)  
KBO( :,26, 8) = (/&
 & 3.8253E-02_JPRB,4.4756E-02_JPRB,5.1578E-02_JPRB,5.8670E-02_JPRB,6.6013E-02_JPRB/)  
KBO( :,27, 8) = (/&
 & 3.2667E-02_JPRB,3.8088E-02_JPRB,4.3757E-02_JPRB,4.9656E-02_JPRB,5.5793E-02_JPRB/)  
KBO( :,28, 8) = (/&
 & 2.7877E-02_JPRB,3.2393E-02_JPRB,3.7109E-02_JPRB,4.2030E-02_JPRB,4.7179E-02_JPRB/)  
KBO( :,29, 8) = (/&
 & 2.3797E-02_JPRB,2.7555E-02_JPRB,3.1491E-02_JPRB,3.5617E-02_JPRB,3.9923E-02_JPRB/)  
KBO( :,30, 8) = (/&
 & 2.0298E-02_JPRB,2.3432E-02_JPRB,2.6727E-02_JPRB,3.0189E-02_JPRB,3.3773E-02_JPRB/)  
KBO( :,31, 8) = (/&
 & 1.7314E-02_JPRB,1.9936E-02_JPRB,2.2701E-02_JPRB,2.5587E-02_JPRB,2.8571E-02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB2:PART4',1,ZHOOK_HANDLE)
END SUBROUTINE PART4


SUBROUTINE PART5

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB2:PART5',0,ZHOOK_HANDLE)


KBO( :,32, 8) = (/&
 & 1.4770E-02_JPRB,1.6972E-02_JPRB,1.9281E-02_JPRB,2.1688E-02_JPRB,2.4162E-02_JPRB/)  
KBO( :,33, 8) = (/&
 & 1.2600E-02_JPRB,1.4446E-02_JPRB,1.6373E-02_JPRB,1.8374E-02_JPRB,2.0424E-02_JPRB/)  
KBO( :,34, 8) = (/&
 & 1.0696E-02_JPRB,1.2236E-02_JPRB,1.3839E-02_JPRB,1.5497E-02_JPRB,1.7194E-02_JPRB/)  
KBO( :,35, 8) = (/&
 & 8.9555E-03_JPRB,1.0232E-02_JPRB,1.1559E-02_JPRB,1.2931E-02_JPRB,1.4335E-02_JPRB/)  
KBO( :,36, 8) = (/&
 & 7.3846E-03_JPRB,8.4373E-03_JPRB,9.5325E-03_JPRB,1.0662E-02_JPRB,1.1822E-02_JPRB/)  
KBO( :,37, 8) = (/&
 & 5.9606E-03_JPRB,6.8233E-03_JPRB,7.7209E-03_JPRB,8.6487E-03_JPRB,9.6041E-03_JPRB/)  
KBO( :,38, 8) = (/&
 & 4.8037E-03_JPRB,5.5105E-03_JPRB,6.2459E-03_JPRB,7.0079E-03_JPRB,7.7943E-03_JPRB/)  
KBO( :,39, 8) = (/&
 & 3.8706E-03_JPRB,4.4491E-03_JPRB,5.0519E-03_JPRB,5.6779E-03_JPRB,6.3251E-03_JPRB/)  
KBO( :,40, 8) = (/&
 & 3.0705E-03_JPRB,3.5417E-03_JPRB,4.0336E-03_JPRB,4.5461E-03_JPRB,5.0773E-03_JPRB/)  
KBO( :,41, 8) = (/&
 & 2.4285E-03_JPRB,2.8118E-03_JPRB,3.2129E-03_JPRB,3.6318E-03_JPRB,4.0673E-03_JPRB/)  
KBO( :,42, 8) = (/&
 & 1.9184E-03_JPRB,2.2300E-03_JPRB,2.5570E-03_JPRB,2.8991E-03_JPRB,3.2561E-03_JPRB/)  
KBO( :,43, 8) = (/&
 & 1.4999E-03_JPRB,1.7522E-03_JPRB,2.0180E-03_JPRB,2.2966E-03_JPRB,2.5881E-03_JPRB/)  
KBO( :,44, 8) = (/&
 & 1.1655E-03_JPRB,1.3694E-03_JPRB,1.5849E-03_JPRB,1.8113E-03_JPRB,2.0488E-03_JPRB/)  
KBO( :,45, 8) = (/&
 & 9.0376E-04_JPRB,1.0682E-03_JPRB,1.2427E-03_JPRB,1.4266E-03_JPRB,1.6199E-03_JPRB/)  
KBO( :,46, 8) = (/&
 & 6.9650E-04_JPRB,8.2858E-04_JPRB,9.6950E-04_JPRB,1.1186E-03_JPRB,1.2755E-03_JPRB/)  
KBO( :,47, 8) = (/&
 & 5.3108E-04_JPRB,6.3643E-04_JPRB,7.4984E-04_JPRB,8.7018E-04_JPRB,9.9721E-04_JPRB/)  
KBO( :,48, 8) = (/&
 & 4.0361E-04_JPRB,4.8742E-04_JPRB,5.7833E-04_JPRB,6.7534E-04_JPRB,7.7807E-04_JPRB/)  
KBO( :,49, 8) = (/&
 & 3.0566E-04_JPRB,3.7215E-04_JPRB,4.4475E-04_JPRB,5.2279E-04_JPRB,6.0579E-04_JPRB/)  
KBO( :,50, 8) = (/&
 & 2.3193E-04_JPRB,2.8459E-04_JPRB,3.4251E-04_JPRB,4.0526E-04_JPRB,4.7230E-04_JPRB/)  
KBO( :,51, 8) = (/&
 & 1.7590E-04_JPRB,2.1748E-04_JPRB,2.6361E-04_JPRB,3.1395E-04_JPRB,3.6804E-04_JPRB/)  
KBO( :,52, 8) = (/&
 & 1.3304E-04_JPRB,1.6573E-04_JPRB,2.0240E-04_JPRB,2.4265E-04_JPRB,2.8621E-04_JPRB/)  
KBO( :,53, 8) = (/&
 & 1.0033E-04_JPRB,1.2590E-04_JPRB,1.5496E-04_JPRB,1.8704E-04_JPRB,2.2201E-04_JPRB/)  
KBO( :,54, 8) = (/&
 & 7.6043E-05_JPRB,9.6033E-05_JPRB,1.1903E-04_JPRB,1.4464E-04_JPRB,1.7271E-04_JPRB/)  
KBO( :,55, 8) = (/&
 & 5.7725E-05_JPRB,7.3309E-05_JPRB,9.1482E-05_JPRB,1.1190E-04_JPRB,1.3439E-04_JPRB/)  
KBO( :,56, 8) = (/&
 & 4.3773E-05_JPRB,5.5845E-05_JPRB,7.0155E-05_JPRB,8.6401E-05_JPRB,1.0439E-04_JPRB/)  
KBO( :,57, 8) = (/&
 & 3.3178E-05_JPRB,4.2466E-05_JPRB,5.3677E-05_JPRB,6.6562E-05_JPRB,8.0932E-05_JPRB/)  
KBO( :,58, 8) = (/&
 & 2.5276E-05_JPRB,3.2365E-05_JPRB,4.1133E-05_JPRB,5.1343E-05_JPRB,6.2815E-05_JPRB/)  
KBO( :,59, 8) = (/&
 & 2.0138E-05_JPRB,2.5779E-05_JPRB,3.2836E-05_JPRB,4.1105E-05_JPRB,5.0433E-05_JPRB/)  
KBO( :,13, 9) = (/&
 & 2.0575E+00_JPRB,2.5259E+00_JPRB,3.0234E+00_JPRB,3.5471E+00_JPRB,4.0892E+00_JPRB/)  
KBO( :,14, 9) = (/&
 & 1.7896E+00_JPRB,2.1936E+00_JPRB,2.6243E+00_JPRB,3.0754E+00_JPRB,3.5357E+00_JPRB/)  
KBO( :,15, 9) = (/&
 & 1.5532E+00_JPRB,1.9005E+00_JPRB,2.2698E+00_JPRB,2.6534E+00_JPRB,3.0460E+00_JPRB/)  
KBO( :,16, 9) = (/&
 & 1.3431E+00_JPRB,1.6399E+00_JPRB,1.9542E+00_JPRB,2.2801E+00_JPRB,2.6154E+00_JPRB/)  
KBO( :,17, 9) = (/&
 & 1.1564E+00_JPRB,1.4091E+00_JPRB,1.6750E+00_JPRB,1.9517E+00_JPRB,2.2353E+00_JPRB/)  
KBO( :,18, 9) = (/&
 & 9.9261E-01_JPRB,1.2059E+00_JPRB,1.4303E+00_JPRB,1.6635E+00_JPRB,1.9029E+00_JPRB/)  
KBO( :,19, 9) = (/&
 & 8.4829E-01_JPRB,1.0283E+00_JPRB,1.2171E+00_JPRB,1.4131E+00_JPRB,1.6142E+00_JPRB/)  
KBO( :,20, 9) = (/&
 & 7.2551E-01_JPRB,8.7689E-01_JPRB,1.0360E+00_JPRB,1.2012E+00_JPRB,1.3703E+00_JPRB/)  
KBO( :,21, 9) = (/&
 & 6.1932E-01_JPRB,7.4645E-01_JPRB,8.8019E-01_JPRB,1.0189E+00_JPRB,1.1616E+00_JPRB/)  
KBO( :,22, 9) = (/&
 & 5.3436E-01_JPRB,6.4171E-01_JPRB,7.5441E-01_JPRB,8.7104E-01_JPRB,9.9107E-01_JPRB/)  
KBO( :,23, 9) = (/&
 & 4.6064E-01_JPRB,5.5112E-01_JPRB,6.4570E-01_JPRB,7.4365E-01_JPRB,8.4436E-01_JPRB/)  
KBO( :,24, 9) = (/&
 & 3.9696E-01_JPRB,4.7292E-01_JPRB,5.5220E-01_JPRB,6.3452E-01_JPRB,7.1905E-01_JPRB/)  
KBO( :,25, 9) = (/&
 & 3.4206E-01_JPRB,4.0576E-01_JPRB,4.7240E-01_JPRB,5.4144E-01_JPRB,6.1253E-01_JPRB/)  
KBO( :,26, 9) = (/&
 & 2.9509E-01_JPRB,3.4866E-01_JPRB,4.0462E-01_JPRB,4.6255E-01_JPRB,5.2212E-01_JPRB/)  
KBO( :,27, 9) = (/&
 & 2.5432E-01_JPRB,2.9938E-01_JPRB,3.4636E-01_JPRB,3.9487E-01_JPRB,4.4473E-01_JPRB/)  
KBO( :,28, 9) = (/&
 & 2.1897E-01_JPRB,2.5686E-01_JPRB,2.9621E-01_JPRB,3.3690E-01_JPRB,3.7871E-01_JPRB/)  
KBO( :,29, 9) = (/&
 & 1.8863E-01_JPRB,2.2035E-01_JPRB,2.5338E-01_JPRB,2.8746E-01_JPRB,3.2276E-01_JPRB/)  
KBO( :,30, 9) = (/&
 & 1.6227E-01_JPRB,1.8891E-01_JPRB,2.1659E-01_JPRB,2.4532E-01_JPRB,2.7508E-01_JPRB/)  
KBO( :,31, 9) = (/&
 & 1.3961E-01_JPRB,1.6197E-01_JPRB,1.8522E-01_JPRB,2.0946E-01_JPRB,2.3451E-01_JPRB/)  
KBO( :,32, 9) = (/&
 & 1.2009E-01_JPRB,1.3886E-01_JPRB,1.5848E-01_JPRB,1.7888E-01_JPRB,2.0001E-01_JPRB/)  
KBO( :,33, 9) = (/&
 & 1.0324E-01_JPRB,1.1904E-01_JPRB,1.3559E-01_JPRB,1.5281E-01_JPRB,1.7071E-01_JPRB/)  
KBO( :,34, 9) = (/&
 & 8.8245E-02_JPRB,1.0156E-01_JPRB,1.1550E-01_JPRB,1.3006E-01_JPRB,1.4528E-01_JPRB/)  
KBO( :,35, 9) = (/&
 & 7.4373E-02_JPRB,8.5551E-02_JPRB,9.7297E-02_JPRB,1.0957E-01_JPRB,1.2251E-01_JPRB/)  
KBO( :,36, 9) = (/&
 & 6.1704E-02_JPRB,7.1049E-02_JPRB,8.0900E-02_JPRB,9.1251E-02_JPRB,1.0221E-01_JPRB/)  
KBO( :,37, 9) = (/&
 & 5.0060E-02_JPRB,5.7820E-02_JPRB,6.6024E-02_JPRB,7.4701E-02_JPRB,8.3923E-02_JPRB/)  
KBO( :,38, 9) = (/&
 & 4.0550E-02_JPRB,4.6991E-02_JPRB,5.3826E-02_JPRB,6.1105E-02_JPRB,6.8864E-02_JPRB/)  
KBO( :,39, 9) = (/&
 & 3.2845E-02_JPRB,3.8185E-02_JPRB,4.3883E-02_JPRB,4.9990E-02_JPRB,5.6512E-02_JPRB/)  
KBO( :,40, 9) = (/&
 & 2.6159E-02_JPRB,3.0559E-02_JPRB,3.5279E-02_JPRB,4.0364E-02_JPRB,4.5803E-02_JPRB/)  
KBO( :,41, 9) = (/&
 & 2.0762E-02_JPRB,2.4380E-02_JPRB,2.8285E-02_JPRB,3.2514E-02_JPRB,3.7041E-02_JPRB/)  
KBO( :,42, 9) = (/&
 & 1.6454E-02_JPRB,1.9426E-02_JPRB,2.2652E-02_JPRB,2.6163E-02_JPRB,2.9929E-02_JPRB/)  
KBO( :,43, 9) = (/&
 & 1.2889E-02_JPRB,1.5316E-02_JPRB,1.7969E-02_JPRB,2.0865E-02_JPRB,2.3986E-02_JPRB/)  
KBO( :,44, 9) = (/&
 & 1.0025E-02_JPRB,1.2000E-02_JPRB,1.4172E-02_JPRB,1.6553E-02_JPRB,1.9131E-02_JPRB/)  
KBO( :,45, 9) = (/&
 & 7.7746E-03_JPRB,9.3784E-03_JPRB,1.1153E-02_JPRB,1.3107E-02_JPRB,1.5232E-02_JPRB/)  
KBO( :,46, 9) = (/&
 & 5.9839E-03_JPRB,7.2803E-03_JPRB,8.7236E-03_JPRB,1.0320E-02_JPRB,1.2066E-02_JPRB/)  
KBO( :,47, 9) = (/&
 & 4.5469E-03_JPRB,5.5872E-03_JPRB,6.7527E-03_JPRB,8.0490E-03_JPRB,9.4737E-03_JPRB/)  
KBO( :,48, 9) = (/&
 & 3.4387E-03_JPRB,4.2707E-03_JPRB,5.2081E-03_JPRB,6.2578E-03_JPRB,7.4170E-03_JPRB/)  
KBO( :,49, 9) = (/&
 & 2.5872E-03_JPRB,3.2502E-03_JPRB,4.0014E-03_JPRB,4.8487E-03_JPRB,5.7896E-03_JPRB/)  
KBO( :,50, 9) = (/&
 & 1.9484E-03_JPRB,2.4763E-03_JPRB,3.0782E-03_JPRB,3.7619E-03_JPRB,4.5255E-03_JPRB/)  
KBO( :,51, 9) = (/&
 & 1.4641E-03_JPRB,1.8833E-03_JPRB,2.3642E-03_JPRB,2.9156E-03_JPRB,3.5343E-03_JPRB/)  
KBO( :,52, 9) = (/&
 & 1.0947E-03_JPRB,1.4260E-03_JPRB,1.8092E-03_JPRB,2.2525E-03_JPRB,2.7523E-03_JPRB/)  
KBO( :,53, 9) = (/&
 & 8.1385E-04_JPRB,1.0744E-03_JPRB,1.3788E-03_JPRB,1.7335E-03_JPRB,2.1363E-03_JPRB/)  
KBO( :,54, 9) = (/&
 & 6.0727E-04_JPRB,8.1227E-04_JPRB,1.0543E-03_JPRB,1.3383E-03_JPRB,1.6634E-03_JPRB/)  
KBO( :,55, 9) = (/&
 & 4.5272E-04_JPRB,6.1374E-04_JPRB,8.0589E-04_JPRB,1.0331E-03_JPRB,1.2952E-03_JPRB/)  
KBO( :,56, 9) = (/&
 & 3.3583E-04_JPRB,4.6181E-04_JPRB,6.1377E-04_JPRB,7.9508E-04_JPRB,1.0057E-03_JPRB/)  
KBO( :,57, 9) = (/&
 & 2.4776E-04_JPRB,3.4590E-04_JPRB,4.6559E-04_JPRB,6.0978E-04_JPRB,7.7861E-04_JPRB/)  
KBO( :,58, 9) = (/&
 & 1.8283E-04_JPRB,2.5924E-04_JPRB,3.5338E-04_JPRB,4.6808E-04_JPRB,6.0340E-04_JPRB/)  
KBO( :,59, 9) = (/&
 & 1.4394E-04_JPRB,2.0565E-04_JPRB,2.8231E-04_JPRB,3.7641E-04_JPRB,4.8766E-04_JPRB/)  
KBO( :,13,10) = (/&
 & 9.3904E+00_JPRB,1.1558E+01_JPRB,1.3845E+01_JPRB,1.6163E+01_JPRB,1.8555E+01_JPRB/)  
KBO( :,14,10) = (/&
 & 8.3973E+00_JPRB,1.0270E+01_JPRB,1.2209E+01_JPRB,1.4231E+01_JPRB,1.6403E+01_JPRB/)  
KBO( :,15,10) = (/&
 & 7.4227E+00_JPRB,9.0328E+00_JPRB,1.0725E+01_JPRB,1.2539E+01_JPRB,1.4424E+01_JPRB/)  
KBO( :,16,10) = (/&
 & 6.5205E+00_JPRB,7.9257E+00_JPRB,9.4310E+00_JPRB,1.1012E+01_JPRB,1.2602E+01_JPRB/)  
KBO( :,17,10) = (/&
 & 5.6968E+00_JPRB,6.9236E+00_JPRB,8.2313E+00_JPRB,9.5792E+00_JPRB,1.0956E+01_JPRB/)  
KBO( :,18,10) = (/&
 & 4.9471E+00_JPRB,6.0161E+00_JPRB,7.1339E+00_JPRB,8.2948E+00_JPRB,9.4857E+00_JPRB/)  
KBO( :,19,10) = (/&
 & 4.2895E+00_JPRB,5.2029E+00_JPRB,6.1642E+00_JPRB,7.1527E+00_JPRB,8.1730E+00_JPRB/)  
KBO( :,20,10) = (/&
 & 3.7147E+00_JPRB,4.4929E+00_JPRB,5.3068E+00_JPRB,6.1474E+00_JPRB,7.0078E+00_JPRB/)  
KBO( :,21,10) = (/&
 & 3.2024E+00_JPRB,3.8631E+00_JPRB,4.5499E+00_JPRB,5.2596E+00_JPRB,5.9867E+00_JPRB/)  
KBO( :,22,10) = (/&
 & 2.7881E+00_JPRB,3.3462E+00_JPRB,3.9291E+00_JPRB,4.5332E+00_JPRB,5.1516E+00_JPRB/)  
KBO( :,23,10) = (/&
 & 2.4221E+00_JPRB,2.8934E+00_JPRB,3.3888E+00_JPRB,3.9007E+00_JPRB,4.4296E+00_JPRB/)  
KBO( :,24,10) = (/&
 & 2.1012E+00_JPRB,2.5042E+00_JPRB,2.9257E+00_JPRB,3.3605E+00_JPRB,3.8099E+00_JPRB/)  
KBO( :,25,10) = (/&
 & 1.8234E+00_JPRB,2.1683E+00_JPRB,2.5234E+00_JPRB,2.8940E+00_JPRB,3.2740E+00_JPRB/)  
KBO( :,26,10) = (/&
 & 1.5880E+00_JPRB,1.8773E+00_JPRB,2.1781E+00_JPRB,2.4921E+00_JPRB,2.8182E+00_JPRB/)  
KBO( :,27,10) = (/&
 & 1.3795E+00_JPRB,1.6233E+00_JPRB,1.8790E+00_JPRB,2.1463E+00_JPRB,2.4246E+00_JPRB/)  
KBO( :,28,10) = (/&
 & 1.1952E+00_JPRB,1.4020E+00_JPRB,1.6204E+00_JPRB,1.8473E+00_JPRB,2.0818E+00_JPRB/)  
KBO( :,29,10) = (/&
 & 1.0353E+00_JPRB,1.2126E+00_JPRB,1.3974E+00_JPRB,1.5895E+00_JPRB,1.7854E+00_JPRB/)  
KBO( :,30,10) = (/&
 & 8.9710E-01_JPRB,1.0479E+00_JPRB,1.2046E+00_JPRB,1.3665E+00_JPRB,1.5321E+00_JPRB/)  
KBO( :,31,10) = (/&
 & 7.7817E-01_JPRB,9.0519E-01_JPRB,1.0386E+00_JPRB,1.1754E+00_JPRB,1.3182E+00_JPRB/)  
KBO( :,32,10) = (/&
 & 6.7399E-01_JPRB,7.8251E-01_JPRB,8.9515E-01_JPRB,1.0127E+00_JPRB,1.1369E+00_JPRB/)  
KBO( :,33,10) = (/&
 & 5.8405E-01_JPRB,6.7622E-01_JPRB,7.7236E-01_JPRB,8.7403E-01_JPRB,9.7956E-01_JPRB/)  
KBO( :,34,10) = (/&
 & 5.0357E-01_JPRB,5.8182E-01_JPRB,6.6452E-01_JPRB,7.5151E-01_JPRB,8.4035E-01_JPRB/)  
KBO( :,35,10) = (/&
 & 4.2779E-01_JPRB,4.9440E-01_JPRB,5.6491E-01_JPRB,6.3892E-01_JPRB,7.1333E-01_JPRB/)  
KBO( :,36,10) = (/&
 & 3.5777E-01_JPRB,4.1421E-01_JPRB,4.7387E-01_JPRB,5.3617E-01_JPRB,5.9900E-01_JPRB/)  
KBO( :,37,10) = (/&
 & 2.9234E-01_JPRB,3.3963E-01_JPRB,3.8973E-01_JPRB,4.4194E-01_JPRB,4.9508E-01_JPRB/)  
KBO( :,38,10) = (/&
 & 2.3845E-01_JPRB,2.7804E-01_JPRB,3.2014E-01_JPRB,3.6393E-01_JPRB,4.0887E-01_JPRB/)  
KBO( :,39,10) = (/&
 & 1.9449E-01_JPRB,2.2762E-01_JPRB,2.6303E-01_JPRB,2.9987E-01_JPRB,3.3808E-01_JPRB/)  
KBO( :,40,10) = (/&
 & 1.5581E-01_JPRB,1.8338E-01_JPRB,2.1298E-01_JPRB,2.4388E-01_JPRB,2.7640E-01_JPRB/)  
KBO( :,41,10) = (/&
 & 1.2437E-01_JPRB,1.4728E-01_JPRB,1.7198E-01_JPRB,1.9790E-01_JPRB,2.2561E-01_JPRB/)  
KBO( :,42,10) = (/&
 & 9.9114E-02_JPRB,1.1814E-01_JPRB,1.3871E-01_JPRB,1.6049E-01_JPRB,1.8409E-01_JPRB/)  
KBO( :,43,10) = (/&
 & 7.8014E-02_JPRB,9.3699E-02_JPRB,1.1072E-01_JPRB,1.2897E-01_JPRB,1.4893E-01_JPRB/)  
KBO( :,44,10) = (/&
 & 6.0930E-02_JPRB,7.3813E-02_JPRB,8.7829E-02_JPRB,1.0306E-01_JPRB,1.1990E-01_JPRB/)  
KBO( :,45,10) = (/&
 & 4.7439E-02_JPRB,5.7963E-02_JPRB,6.9524E-02_JPRB,8.2179E-02_JPRB,9.6377E-02_JPRB/)  
KBO( :,46,10) = (/&
 & 3.6628E-02_JPRB,4.5189E-02_JPRB,5.4663E-02_JPRB,6.5139E-02_JPRB,7.7031E-02_JPRB/)  
KBO( :,47,10) = (/&
 & 2.7890E-02_JPRB,3.4787E-02_JPRB,4.2493E-02_JPRB,5.1096E-02_JPRB,6.0965E-02_JPRB/)  
KBO( :,48,10) = (/&
 & 2.1119E-02_JPRB,2.6645E-02_JPRB,3.2896E-02_JPRB,3.9921E-02_JPRB,4.8089E-02_JPRB/)  
KBO( :,49,10) = (/&
 & 1.5900E-02_JPRB,2.0307E-02_JPRB,2.5351E-02_JPRB,3.1064E-02_JPRB,3.7792E-02_JPRB/)  
KBO( :,50,10) = (/&
 & 1.1982E-02_JPRB,1.5486E-02_JPRB,1.9553E-02_JPRB,2.4196E-02_JPRB,2.9727E-02_JPRB/)  
KBO( :,51,10) = (/&
 & 9.0056E-03_JPRB,1.1788E-02_JPRB,1.5051E-02_JPRB,1.8815E-02_JPRB,2.3348E-02_JPRB/)  
KBO( :,52,10) = (/&
 & 6.7287E-03_JPRB,8.9323E-03_JPRB,1.1543E-02_JPRB,1.4581E-02_JPRB,1.8277E-02_JPRB/)  
KBO( :,53,10) = (/&
 & 4.9917E-03_JPRB,6.7318E-03_JPRB,8.8095E-03_JPRB,1.1255E-02_JPRB,1.4250E-02_JPRB/)  
KBO( :,54,10) = (/&
 & 3.7166E-03_JPRB,5.0897E-03_JPRB,6.7438E-03_JPRB,8.7155E-03_JPRB,1.1147E-02_JPRB/)  
KBO( :,55,10) = (/&
 & 2.7631E-03_JPRB,3.8456E-03_JPRB,5.1593E-03_JPRB,6.7476E-03_JPRB,8.7195E-03_JPRB/)  
KBO( :,56,10) = (/&
 & 2.0411E-03_JPRB,2.8905E-03_JPRB,3.9308E-03_JPRB,5.2031E-03_JPRB,6.7949E-03_JPRB/)  
KBO( :,57,10) = (/&
 & 1.4978E-03_JPRB,2.1598E-03_JPRB,2.9807E-03_JPRB,3.9948E-03_JPRB,5.2752E-03_JPRB/)  
KBO( :,58,10) = (/&
 & 1.0985E-03_JPRB,1.6142E-03_JPRB,2.2613E-03_JPRB,3.0687E-03_JPRB,4.0986E-03_JPRB/)  
KBO( :,59,10) = (/&
 & 8.6500E-04_JPRB,1.2833E-03_JPRB,1.8127E-03_JPRB,2.4817E-03_JPRB,3.3443E-03_JPRB/)  
KBO( :,13,11) = (/&
 & 1.8372E+01_JPRB,2.2531E+01_JPRB,2.6942E+01_JPRB,3.1721E+01_JPRB,3.6666E+01_JPRB/)  
KBO( :,14,11) = (/&
 & 1.6476E+01_JPRB,2.0266E+01_JPRB,2.4375E+01_JPRB,2.8673E+01_JPRB,3.2960E+01_JPRB/)  
KBO( :,15,11) = (/&
 & 1.4838E+01_JPRB,1.8258E+01_JPRB,2.1874E+01_JPRB,2.5540E+01_JPRB,2.9299E+01_JPRB/)  
KBO( :,16,11) = (/&
 & 1.3322E+01_JPRB,1.6282E+01_JPRB,1.9361E+01_JPRB,2.2553E+01_JPRB,2.5938E+01_JPRB/)  
KBO( :,17,11) = (/&
 & 1.1797E+01_JPRB,1.4340E+01_JPRB,1.7022E+01_JPRB,1.9865E+01_JPRB,2.2805E+01_JPRB/)  
KBO( :,18,11) = (/&
 & 1.0354E+01_JPRB,1.2576E+01_JPRB,1.4945E+01_JPRB,1.7409E+01_JPRB,1.9880E+01_JPRB/)  
KBO( :,19,11) = (/&
 & 9.0365E+00_JPRB,1.0980E+01_JPRB,1.3039E+01_JPRB,1.5152E+01_JPRB,1.7258E+01_JPRB/)  
KBO( :,20,11) = (/&
 & 7.8834E+00_JPRB,9.5695E+00_JPRB,1.1327E+01_JPRB,1.3132E+01_JPRB,1.4932E+01_JPRB/)  
KBO( :,21,11) = (/&
 & 6.8550E+00_JPRB,8.2970E+00_JPRB,9.8119E+00_JPRB,1.1335E+01_JPRB,1.2856E+01_JPRB/)  
KBO( :,22,11) = (/&
 & 6.0199E+00_JPRB,7.2562E+00_JPRB,8.5326E+00_JPRB,9.8104E+00_JPRB,1.1086E+01_JPRB/)  
KBO( :,23,11) = (/&
 & 5.2655E+00_JPRB,6.3155E+00_JPRB,7.3813E+00_JPRB,8.4546E+00_JPRB,9.5205E+00_JPRB/)  
KBO( :,24,11) = (/&
 & 4.5968E+00_JPRB,5.4765E+00_JPRB,6.3717E+00_JPRB,7.2772E+00_JPRB,8.1752E+00_JPRB/)  
KBO( :,25,11) = (/&
 & 4.0046E+00_JPRB,4.7437E+00_JPRB,5.5012E+00_JPRB,6.2582E+00_JPRB,7.0243E+00_JPRB/)  
KBO( :,26,11) = (/&
 & 3.4899E+00_JPRB,4.1156E+00_JPRB,4.7544E+00_JPRB,5.3978E+00_JPRB,6.0478E+00_JPRB/)  
KBO( :,27,11) = (/&
 & 3.0370E+00_JPRB,3.5704E+00_JPRB,4.1083E+00_JPRB,4.6559E+00_JPRB,5.2026E+00_JPRB/)  
KBO( :,28,11) = (/&
 & 2.6441E+00_JPRB,3.0908E+00_JPRB,3.5452E+00_JPRB,4.0092E+00_JPRB,4.4774E+00_JPRB/)  
KBO( :,29,11) = (/&
 & 2.2991E+00_JPRB,2.6744E+00_JPRB,3.0609E+00_JPRB,3.4545E+00_JPRB,3.8571E+00_JPRB/)  
KBO( :,30,11) = (/&
 & 1.9952E+00_JPRB,2.3130E+00_JPRB,2.6436E+00_JPRB,2.9785E+00_JPRB,3.3224E+00_JPRB/)  
KBO( :,31,11) = (/&
 & 1.7303E+00_JPRB,2.0035E+00_JPRB,2.2828E+00_JPRB,2.5698E+00_JPRB,2.8597E+00_JPRB/)  
KBO( :,32,11) = (/&
 & 1.5021E+00_JPRB,1.7349E+00_JPRB,1.9723E+00_JPRB,2.2162E+00_JPRB,2.4607E+00_JPRB/)  
KBO( :,33,11) = (/&
 & 1.3048E+00_JPRB,1.5022E+00_JPRB,1.7054E+00_JPRB,1.9112E+00_JPRB,2.1255E+00_JPRB/)  
KBO( :,34,11) = (/&
 & 1.1267E+00_JPRB,1.2952E+00_JPRB,1.4682E+00_JPRB,1.6457E+00_JPRB,1.8352E+00_JPRB/)  
KBO( :,35,11) = (/&
 & 9.5958E-01_JPRB,1.1033E+00_JPRB,1.2514E+00_JPRB,1.4063E+00_JPRB,1.5730E+00_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB2:PART5',1,ZHOOK_HANDLE)
END SUBROUTINE PART5


SUBROUTINE PART6

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB2:PART6',0,ZHOOK_HANDLE)


KBO( :,36,11) = (/&
 & 8.0543E-01_JPRB,9.2728E-01_JPRB,1.0546E+00_JPRB,1.1895E+00_JPRB,1.3346E+00_JPRB/)  
KBO( :,37,11) = (/&
 & 6.6117E-01_JPRB,7.6429E-01_JPRB,8.7311E-01_JPRB,9.8956E-01_JPRB,1.1138E+00_JPRB/)  
KBO( :,38,11) = (/&
 & 5.4219E-01_JPRB,6.2915E-01_JPRB,7.2220E-01_JPRB,8.2189E-01_JPRB,9.2832E-01_JPRB/)  
KBO( :,39,11) = (/&
 & 4.4474E-01_JPRB,5.1851E-01_JPRB,5.9758E-01_JPRB,6.8269E-01_JPRB,7.7379E-01_JPRB/)  
KBO( :,40,11) = (/&
 & 3.5874E-01_JPRB,4.2077E-01_JPRB,4.8738E-01_JPRB,5.5930E-01_JPRB,6.3666E-01_JPRB/)  
KBO( :,41,11) = (/&
 & 2.8809E-01_JPRB,3.4018E-01_JPRB,3.9623E-01_JPRB,4.5702E-01_JPRB,5.2265E-01_JPRB/)  
KBO( :,42,11) = (/&
 & 2.3093E-01_JPRB,2.7453E-01_JPRB,3.2175E-01_JPRB,3.7304E-01_JPRB,4.2866E-01_JPRB/)  
KBO( :,43,11) = (/&
 & 1.8286E-01_JPRB,2.1908E-01_JPRB,2.5860E-01_JPRB,3.0169E-01_JPRB,3.4866E-01_JPRB/)  
KBO( :,44,11) = (/&
 & 1.4371E-01_JPRB,1.7364E-01_JPRB,2.0655E-01_JPRB,2.4258E-01_JPRB,2.8218E-01_JPRB/)  
KBO( :,45,11) = (/&
 & 1.1254E-01_JPRB,1.3724E-01_JPRB,1.6458E-01_JPRB,1.9466E-01_JPRB,2.2800E-01_JPRB/)  
KBO( :,46,11) = (/&
 & 8.7419E-02_JPRB,1.0769E-01_JPRB,1.3029E-01_JPRB,1.5534E-01_JPRB,1.8325E-01_JPRB/)  
KBO( :,47,11) = (/&
 & 6.6946E-02_JPRB,8.3455E-02_JPRB,1.0198E-01_JPRB,1.2266E-01_JPRB,1.4588E-01_JPRB/)  
KBO( :,48,11) = (/&
 & 5.0941E-02_JPRB,6.4338E-02_JPRB,7.9485E-02_JPRB,9.6523E-02_JPRB,1.1573E-01_JPRB/)  
KBO( :,49,11) = (/&
 & 3.8506E-02_JPRB,4.9326E-02_JPRB,6.1662E-02_JPRB,7.5682E-02_JPRB,9.1536E-02_JPRB/)  
KBO( :,50,11) = (/&
 & 2.9103E-02_JPRB,3.7840E-02_JPRB,4.7868E-02_JPRB,5.9376E-02_JPRB,7.2482E-02_JPRB/)  
KBO( :,51,11) = (/&
 & 2.1916E-02_JPRB,2.8951E-02_JPRB,3.7067E-02_JPRB,4.6499E-02_JPRB,5.7317E-02_JPRB/)  
KBO( :,52,11) = (/&
 & 1.6392E-02_JPRB,2.2020E-02_JPRB,2.8575E-02_JPRB,3.6268E-02_JPRB,4.5169E-02_JPRB/)  
KBO( :,53,11) = (/&
 & 1.2172E-02_JPRB,1.6642E-02_JPRB,2.1908E-02_JPRB,2.8155E-02_JPRB,3.5457E-02_JPRB/)  
KBO( :,54,11) = (/&
 & 9.0658E-03_JPRB,1.2613E-02_JPRB,1.6847E-02_JPRB,2.1915E-02_JPRB,2.7906E-02_JPRB/)  
KBO( :,55,11) = (/&
 & 6.7444E-03_JPRB,9.5483E-03_JPRB,1.2947E-02_JPRB,1.7041E-02_JPRB,2.1954E-02_JPRB/)  
KBO( :,56,11) = (/&
 & 4.9837E-03_JPRB,7.1893E-03_JPRB,9.9031E-03_JPRB,1.3201E-02_JPRB,1.7215E-02_JPRB/)  
KBO( :,57,11) = (/&
 & 3.6555E-03_JPRB,5.3797E-03_JPRB,7.5345E-03_JPRB,1.0185E-02_JPRB,1.3448E-02_JPRB/)  
KBO( :,58,11) = (/&
 & 2.6798E-03_JPRB,4.0234E-03_JPRB,5.7322E-03_JPRB,7.8591E-03_JPRB,1.0509E-02_JPRB/)  
KBO( :,59,11) = (/&
 & 2.1174E-03_JPRB,3.2126E-03_JPRB,4.6178E-03_JPRB,6.3890E-03_JPRB,8.6307E-03_JPRB/)  
KBO( :,13,12) = (/&
 & 3.9037E+01_JPRB,4.8595E+01_JPRB,5.8290E+01_JPRB,6.7743E+01_JPRB,7.7175E+01_JPRB/)  
KBO( :,14,12) = (/&
 & 3.6731E+01_JPRB,4.5143E+01_JPRB,5.3367E+01_JPRB,6.1735E+01_JPRB,7.0266E+01_JPRB/)  
KBO( :,15,12) = (/&
 & 3.3782E+01_JPRB,4.1053E+01_JPRB,4.8465E+01_JPRB,5.6101E+01_JPRB,6.4046E+01_JPRB/)  
KBO( :,16,12) = (/&
 & 3.0361E+01_JPRB,3.6837E+01_JPRB,4.3692E+01_JPRB,5.0749E+01_JPRB,5.7770E+01_JPRB/)  
KBO( :,17,12) = (/&
 & 2.7181E+01_JPRB,3.3037E+01_JPRB,3.9122E+01_JPRB,4.5236E+01_JPRB,5.1302E+01_JPRB/)  
KBO( :,18,12) = (/&
 & 2.4289E+01_JPRB,2.9373E+01_JPRB,3.4573E+01_JPRB,3.9820E+01_JPRB,4.5254E+01_JPRB/)  
KBO( :,19,12) = (/&
 & 2.1489E+01_JPRB,2.5832E+01_JPRB,3.0286E+01_JPRB,3.4895E+01_JPRB,3.9728E+01_JPRB/)  
KBO( :,20,12) = (/&
 & 1.8889E+01_JPRB,2.2626E+01_JPRB,2.6516E+01_JPRB,3.0573E+01_JPRB,3.4729E+01_JPRB/)  
KBO( :,21,12) = (/&
 & 1.6499E+01_JPRB,1.9772E+01_JPRB,2.3169E+01_JPRB,2.6668E+01_JPRB,3.0247E+01_JPRB/)  
KBO( :,22,12) = (/&
 & 1.4564E+01_JPRB,1.7397E+01_JPRB,2.0332E+01_JPRB,2.3375E+01_JPRB,2.6482E+01_JPRB/)  
KBO( :,23,12) = (/&
 & 1.2811E+01_JPRB,1.5254E+01_JPRB,1.7803E+01_JPRB,2.0436E+01_JPRB,2.3110E+01_JPRB/)  
KBO( :,24,12) = (/&
 & 1.1250E+01_JPRB,1.3354E+01_JPRB,1.5549E+01_JPRB,1.7797E+01_JPRB,2.0094E+01_JPRB/)  
KBO( :,25,12) = (/&
 & 9.8597E+00_JPRB,1.1670E+01_JPRB,1.3537E+01_JPRB,1.5466E+01_JPRB,1.7423E+01_JPRB/)  
KBO( :,26,12) = (/&
 & 8.6447E+00_JPRB,1.0181E+01_JPRB,1.1779E+01_JPRB,1.3417E+01_JPRB,1.5081E+01_JPRB/)  
KBO( :,27,12) = (/&
 & 7.5594E+00_JPRB,8.8642E+00_JPRB,1.0226E+01_JPRB,1.1630E+01_JPRB,1.3058E+01_JPRB/)  
KBO( :,28,12) = (/&
 & 6.5925E+00_JPRB,7.7161E+00_JPRB,8.8897E+00_JPRB,1.0087E+01_JPRB,1.1327E+01_JPRB/)  
KBO( :,29,12) = (/&
 & 5.7565E+00_JPRB,6.7240E+00_JPRB,7.7268E+00_JPRB,8.7632E+00_JPRB,9.8409E+00_JPRB/)  
KBO( :,30,12) = (/&
 & 5.0290E+00_JPRB,5.8636E+00_JPRB,6.7247E+00_JPRB,7.6290E+00_JPRB,8.5599E+00_JPRB/)  
KBO( :,31,12) = (/&
 & 4.4035E+00_JPRB,5.1182E+00_JPRB,5.8680E+00_JPRB,6.6555E+00_JPRB,7.4665E+00_JPRB/)  
KBO( :,32,12) = (/&
 & 3.8578E+00_JPRB,4.4752E+00_JPRB,5.1308E+00_JPRB,5.8151E+00_JPRB,6.5278E+00_JPRB/)  
KBO( :,33,12) = (/&
 & 3.3794E+00_JPRB,3.9167E+00_JPRB,4.4904E+00_JPRB,5.0880E+00_JPRB,5.7148E+00_JPRB/)  
KBO( :,34,12) = (/&
 & 2.9486E+00_JPRB,3.4193E+00_JPRB,3.9167E+00_JPRB,4.4410E+00_JPRB,4.9898E+00_JPRB/)  
KBO( :,35,12) = (/&
 & 2.5384E+00_JPRB,2.9485E+00_JPRB,3.3806E+00_JPRB,3.8382E+00_JPRB,4.3138E+00_JPRB/)  
KBO( :,36,12) = (/&
 & 2.1524E+00_JPRB,2.5062E+00_JPRB,2.8802E+00_JPRB,3.2776E+00_JPRB,3.6933E+00_JPRB/)  
KBO( :,37,12) = (/&
 & 1.7833E+00_JPRB,2.0847E+00_JPRB,2.4072E+00_JPRB,2.7505E+00_JPRB,3.1124E+00_JPRB/)  
KBO( :,38,12) = (/&
 & 1.4749E+00_JPRB,1.7326E+00_JPRB,2.0108E+00_JPRB,2.3067E+00_JPRB,2.6244E+00_JPRB/)  
KBO( :,39,12) = (/&
 & 1.2194E+00_JPRB,1.4403E+00_JPRB,1.6807E+00_JPRB,1.9373E+00_JPRB,2.2164E+00_JPRB/)  
KBO( :,40,12) = (/&
 & 9.9010E-01_JPRB,1.1776E+00_JPRB,1.3838E+00_JPRB,1.6055E+00_JPRB,1.8489E+00_JPRB/)  
KBO( :,41,12) = (/&
 & 8.0150E-01_JPRB,9.6002E-01_JPRB,1.1360E+00_JPRB,1.3281E+00_JPRB,1.5396E+00_JPRB/)  
KBO( :,42,12) = (/&
 & 6.4778E-01_JPRB,7.8194E-01_JPRB,9.3223E-01_JPRB,1.0980E+00_JPRB,1.2824E+00_JPRB/)  
KBO( :,43,12) = (/&
 & 5.1676E-01_JPRB,6.2955E-01_JPRB,7.5710E-01_JPRB,8.9908E-01_JPRB,1.0583E+00_JPRB/)  
KBO( :,44,12) = (/&
 & 4.0901E-01_JPRB,5.0320E-01_JPRB,6.1071E-01_JPRB,7.3181E-01_JPRB,8.6848E-01_JPRB/)  
KBO( :,45,12) = (/&
 & 3.2265E-01_JPRB,4.0131E-01_JPRB,4.9147E-01_JPRB,5.9412E-01_JPRB,7.1124E-01_JPRB/)  
KBO( :,46,12) = (/&
 & 2.5210E-01_JPRB,3.1747E-01_JPRB,3.9284E-01_JPRB,4.7937E-01_JPRB,5.7886E-01_JPRB/)  
KBO( :,47,12) = (/&
 & 1.9387E-01_JPRB,2.4750E-01_JPRB,3.1014E-01_JPRB,3.8262E-01_JPRB,4.6634E-01_JPRB/)  
KBO( :,48,12) = (/&
 & 1.4828E-01_JPRB,1.9192E-01_JPRB,2.4351E-01_JPRB,3.0403E-01_JPRB,3.7442E-01_JPRB/)  
KBO( :,49,12) = (/&
 & 1.1268E-01_JPRB,1.4796E-01_JPRB,1.9021E-01_JPRB,2.4026E-01_JPRB,2.9934E-01_JPRB/)  
KBO( :,50,12) = (/&
 & 8.5692E-02_JPRB,1.1419E-01_JPRB,1.4876E-01_JPRB,1.9007E-01_JPRB,2.3948E-01_JPRB/)  
KBO( :,51,12) = (/&
 & 6.4968E-02_JPRB,8.7898E-02_JPRB,1.1604E-01_JPRB,1.5016E-01_JPRB,1.9137E-01_JPRB/)  
KBO( :,52,12) = (/&
 & 4.8913E-02_JPRB,6.7280E-02_JPRB,9.0117E-02_JPRB,1.1814E-01_JPRB,1.5238E-01_JPRB/)  
KBO( :,53,12) = (/&
 & 3.6537E-02_JPRB,5.1125E-02_JPRB,6.9609E-02_JPRB,9.2472E-02_JPRB,1.2076E-01_JPRB/)  
KBO( :,54,12) = (/&
 & 2.7389E-02_JPRB,3.8999E-02_JPRB,5.3932E-02_JPRB,7.2676E-02_JPRB,9.6049E-02_JPRB/)  
KBO( :,55,12) = (/&
 & 2.0487E-02_JPRB,2.9701E-02_JPRB,4.1725E-02_JPRB,5.7075E-02_JPRB,7.6390E-02_JPRB/)  
KBO( :,56,12) = (/&
 & 1.5211E-02_JPRB,2.2473E-02_JPRB,3.2096E-02_JPRB,4.4552E-02_JPRB,6.0534E-02_JPRB/)  
KBO( :,57,12) = (/&
 & 1.1206E-02_JPRB,1.6892E-02_JPRB,2.4543E-02_JPRB,3.4596E-02_JPRB,4.7689E-02_JPRB/)  
KBO( :,58,12) = (/&
 & 8.2520E-03_JPRB,1.2686E-02_JPRB,1.8758E-02_JPRB,2.6873E-02_JPRB,3.7588E-02_JPRB/)  
KBO( :,59,12) = (/&
 & 6.5700E-03_JPRB,1.0221E-02_JPRB,1.5297E-02_JPRB,2.2161E-02_JPRB,3.1343E-02_JPRB/)  
KBO( :,13,13) = (/&
 & 9.2129E+01_JPRB,1.1302E+02_JPRB,1.3488E+02_JPRB,1.5732E+02_JPRB,1.8023E+02_JPRB/)  
KBO( :,14,13) = (/&
 & 8.7183E+01_JPRB,1.0718E+02_JPRB,1.2873E+02_JPRB,1.5116E+02_JPRB,1.7346E+02_JPRB/)  
KBO( :,15,13) = (/&
 & 8.2328E+01_JPRB,1.0157E+02_JPRB,1.2222E+02_JPRB,1.4315E+02_JPRB,1.6347E+02_JPRB/)  
KBO( :,16,13) = (/&
 & 7.8040E+01_JPRB,9.6014E+01_JPRB,1.1471E+02_JPRB,1.3306E+02_JPRB,1.5181E+02_JPRB/)  
KBO( :,17,13) = (/&
 & 7.3174E+01_JPRB,8.9440E+01_JPRB,1.0586E+02_JPRB,1.2255E+02_JPRB,1.3976E+02_JPRB/)  
KBO( :,18,13) = (/&
 & 6.7948E+01_JPRB,8.2226E+01_JPRB,9.6794E+01_JPRB,1.1202E+02_JPRB,1.2767E+02_JPRB/)  
KBO( :,19,13) = (/&
 & 6.1809E+01_JPRB,7.4613E+01_JPRB,8.7919E+01_JPRB,1.0172E+02_JPRB,1.1585E+02_JPRB/)  
KBO( :,20,13) = (/&
 & 5.5733E+01_JPRB,6.7276E+01_JPRB,7.9378E+01_JPRB,9.1765E+01_JPRB,1.0432E+02_JPRB/)  
KBO( :,21,13) = (/&
 & 5.0119E+01_JPRB,6.0399E+01_JPRB,7.1023E+01_JPRB,8.1955E+01_JPRB,9.3098E+01_JPRB/)  
KBO( :,22,13) = (/&
 & 4.5387E+01_JPRB,5.4362E+01_JPRB,6.3623E+01_JPRB,7.3263E+01_JPRB,8.3176E+01_JPRB/)  
KBO( :,23,13) = (/&
 & 4.0785E+01_JPRB,4.8586E+01_JPRB,5.6740E+01_JPRB,6.5256E+01_JPRB,7.4004E+01_JPRB/)  
KBO( :,24,13) = (/&
 & 3.6418E+01_JPRB,4.3297E+01_JPRB,5.0491E+01_JPRB,5.7972E+01_JPRB,6.5666E+01_JPRB/)  
KBO( :,25,13) = (/&
 & 3.2482E+01_JPRB,3.8561E+01_JPRB,4.4879E+01_JPRB,5.1407E+01_JPRB,5.8182E+01_JPRB/)  
KBO( :,26,13) = (/&
 & 2.9006E+01_JPRB,3.4335E+01_JPRB,3.9885E+01_JPRB,4.5662E+01_JPRB,5.1599E+01_JPRB/)  
KBO( :,27,13) = (/&
 & 2.5837E+01_JPRB,3.0498E+01_JPRB,3.5383E+01_JPRB,4.0444E+01_JPRB,4.5658E+01_JPRB/)  
KBO( :,28,13) = (/&
 & 2.2962E+01_JPRB,2.7037E+01_JPRB,3.1320E+01_JPRB,3.5758E+01_JPRB,4.0290E+01_JPRB/)  
KBO( :,29,13) = (/&
 & 2.0397E+01_JPRB,2.3995E+01_JPRB,2.7731E+01_JPRB,3.1631E+01_JPRB,3.5578E+01_JPRB/)  
KBO( :,30,13) = (/&
 & 1.8112E+01_JPRB,2.1250E+01_JPRB,2.4540E+01_JPRB,2.7936E+01_JPRB,3.1421E+01_JPRB/)  
KBO( :,31,13) = (/&
 & 1.6067E+01_JPRB,1.8811E+01_JPRB,2.1703E+01_JPRB,2.4693E+01_JPRB,2.7776E+01_JPRB/)  
KBO( :,32,13) = (/&
 & 1.4258E+01_JPRB,1.6681E+01_JPRB,1.9216E+01_JPRB,2.1851E+01_JPRB,2.4609E+01_JPRB/)  
KBO( :,33,13) = (/&
 & 1.2678E+01_JPRB,1.4812E+01_JPRB,1.7059E+01_JPRB,1.9407E+01_JPRB,2.1877E+01_JPRB/)  
KBO( :,34,13) = (/&
 & 1.1234E+01_JPRB,1.3124E+01_JPRB,1.5116E+01_JPRB,1.7220E+01_JPRB,1.9477E+01_JPRB/)  
KBO( :,35,13) = (/&
 & 9.8183E+00_JPRB,1.1494E+01_JPRB,1.3264E+01_JPRB,1.5165E+01_JPRB,1.7217E+01_JPRB/)  
KBO( :,36,13) = (/&
 & 8.4512E+00_JPRB,9.9248E+00_JPRB,1.1505E+01_JPRB,1.3215E+01_JPRB,1.5066E+01_JPRB/)  
KBO( :,37,13) = (/&
 & 7.1046E+00_JPRB,8.3927E+00_JPRB,9.7872E+00_JPRB,1.1310E+01_JPRB,1.2976E+01_JPRB/)  
KBO( :,38,13) = (/&
 & 5.9713E+00_JPRB,7.0990E+00_JPRB,8.3334E+00_JPRB,9.6940E+00_JPRB,1.1182E+01_JPRB/)  
KBO( :,39,13) = (/&
 & 5.0257E+00_JPRB,6.0152E+00_JPRB,7.1078E+00_JPRB,8.3261E+00_JPRB,9.6615E+00_JPRB/)  
KBO( :,40,13) = (/&
 & 4.1523E+00_JPRB,5.0116E+00_JPRB,5.9715E+00_JPRB,7.0484E+00_JPRB,8.2344E+00_JPRB/)  
KBO( :,41,13) = (/&
 & 3.4206E+00_JPRB,4.1640E+00_JPRB,5.0022E+00_JPRB,5.9574E+00_JPRB,7.0137E+00_JPRB/)  
KBO( :,42,13) = (/&
 & 2.8151E+00_JPRB,3.4582E+00_JPRB,4.1916E+00_JPRB,5.0330E+00_JPRB,5.9745E+00_JPRB/)  
KBO( :,43,13) = (/&
 & 2.2836E+00_JPRB,2.8346E+00_JPRB,3.4702E+00_JPRB,4.2076E+00_JPRB,5.0392E+00_JPRB/)  
KBO( :,44,13) = (/&
 & 1.8358E+00_JPRB,2.3065E+00_JPRB,2.8540E+00_JPRB,3.4947E+00_JPRB,4.2292E+00_JPRB/)  
KBO( :,45,13) = (/&
 & 1.4699E+00_JPRB,1.8708E+00_JPRB,2.3414E+00_JPRB,2.8971E+00_JPRB,3.5454E+00_JPRB/)  
KBO( :,46,13) = (/&
 & 1.1650E+00_JPRB,1.5043E+00_JPRB,1.9061E+00_JPRB,2.3856E+00_JPRB,2.9537E+00_JPRB/)  
KBO( :,47,13) = (/&
 & 9.0755E-01_JPRB,1.1912E+00_JPRB,1.5311E+00_JPRB,1.9396E+00_JPRB,2.4325E+00_JPRB/)  
KBO( :,48,13) = (/&
 & 7.0184E-01_JPRB,9.3709E-01_JPRB,1.2239E+00_JPRB,1.5710E+00_JPRB,1.9958E+00_JPRB/)  
KBO( :,49,13) = (/&
 & 5.3970E-01_JPRB,7.3243E-01_JPRB,9.7194E-01_JPRB,1.2677E+00_JPRB,1.6307E+00_JPRB/)  
KBO( :,50,13) = (/&
 & 4.1584E-01_JPRB,5.7380E-01_JPRB,7.7303E-01_JPRB,1.0235E+00_JPRB,1.3360E+00_JPRB/)  
KBO( :,51,13) = (/&
 & 3.1970E-01_JPRB,4.4857E-01_JPRB,6.1406E-01_JPRB,8.2493E-01_JPRB,1.0932E+00_JPRB/)  
KBO( :,52,13) = (/&
 & 2.4403E-01_JPRB,3.4872E-01_JPRB,4.8565E-01_JPRB,6.6228E-01_JPRB,8.9043E-01_JPRB/)  
KBO( :,53,13) = (/&
 & 1.8461E-01_JPRB,2.6942E-01_JPRB,3.8200E-01_JPRB,5.2938E-01_JPRB,7.2205E-01_JPRB/)  
KBO( :,54,13) = (/&
 & 1.4016E-01_JPRB,2.0879E-01_JPRB,3.0199E-01_JPRB,4.2537E-01_JPRB,5.8863E-01_JPRB/)  
KBO( :,55,13) = (/&
 & 1.0627E-01_JPRB,1.6160E-01_JPRB,2.3840E-01_JPRB,3.4179E-01_JPRB,4.8036E-01_JPRB/)  
KBO( :,56,13) = (/&
 & 7.9975E-02_JPRB,1.2430E-01_JPRB,1.8699E-01_JPRB,2.7356E-01_JPRB,3.9081E-01_JPRB/)  
KBO( :,57,13) = (/&
 & 5.9672E-02_JPRB,9.4998E-02_JPRB,1.4581E-01_JPRB,2.1774E-01_JPRB,3.1655E-01_JPRB/)  
KBO( :,58,13) = (/&
 & 4.4475E-02_JPRB,7.2566E-02_JPRB,1.1372E-01_JPRB,1.7325E-01_JPRB,2.5698E-01_JPRB/)  
KBO( :,59,13) = (/&
 & 3.6215E-02_JPRB,6.0132E-02_JPRB,9.5691E-02_JPRB,1.4806E-01_JPRB,2.2323E-01_JPRB/)  
KBO( :,13,14) = (/&
 & 2.6336E+02_JPRB,3.2548E+02_JPRB,3.9074E+02_JPRB,4.5756E+02_JPRB,5.2579E+02_JPRB/)  
KBO( :,14,14) = (/&
 & 2.7039E+02_JPRB,3.3171E+02_JPRB,3.9551E+02_JPRB,4.6127E+02_JPRB,5.2944E+02_JPRB/)  
KBO( :,15,14) = (/&
 & 2.7394E+02_JPRB,3.3456E+02_JPRB,3.9772E+02_JPRB,4.6386E+02_JPRB,5.3259E+02_JPRB/)  
KBO( :,16,14) = (/&
 & 2.7489E+02_JPRB,3.3472E+02_JPRB,3.9868E+02_JPRB,4.6474E+02_JPRB,5.3170E+02_JPRB/)  
KBO( :,17,14) = (/&
 & 2.7361E+02_JPRB,3.3269E+02_JPRB,3.9532E+02_JPRB,4.5778E+02_JPRB,5.2000E+02_JPRB/)  
KBO( :,18,14) = (/&
 & 2.6867E+02_JPRB,3.2519E+02_JPRB,3.8389E+02_JPRB,4.4282E+02_JPRB,5.0150E+02_JPRB/)  
KBO( :,19,14) = (/&
 & 2.5965E+02_JPRB,3.1265E+02_JPRB,3.6765E+02_JPRB,4.2321E+02_JPRB,4.7874E+02_JPRB/)  
KBO( :,20,14) = (/&
 & 2.4734E+02_JPRB,2.9762E+02_JPRB,3.4946E+02_JPRB,4.0232E+02_JPRB,4.5540E+02_JPRB/)  
KBO( :,21,14) = (/&
 & 2.3283E+02_JPRB,2.7966E+02_JPRB,3.2877E+02_JPRB,3.7834E+02_JPRB,4.2789E+02_JPRB/)  
KBO( :,22,14) = (/&
 & 2.2036E+02_JPRB,2.6406E+02_JPRB,3.0915E+02_JPRB,3.5433E+02_JPRB,3.9946E+02_JPRB/)  
KBO( :,23,14) = (/&
 & 2.0698E+02_JPRB,2.4687E+02_JPRB,2.8731E+02_JPRB,3.2870E+02_JPRB,3.7050E+02_JPRB/)  
KBO( :,24,14) = (/&
 & 1.9330E+02_JPRB,2.2881E+02_JPRB,2.6520E+02_JPRB,3.0278E+02_JPRB,3.4148E+02_JPRB/)  
KBO( :,25,14) = (/&
 & 1.7915E+02_JPRB,2.1082E+02_JPRB,2.4386E+02_JPRB,2.7843E+02_JPRB,3.1413E+02_JPRB/)  
KBO( :,26,14) = (/&
 & 1.6500E+02_JPRB,1.9389E+02_JPRB,2.2412E+02_JPRB,2.5557E+02_JPRB,2.8754E+02_JPRB/)  
KBO( :,27,14) = (/&
 & 1.5126E+02_JPRB,1.7765E+02_JPRB,2.0524E+02_JPRB,2.3351E+02_JPRB,2.6284E+02_JPRB/)  
KBO( :,28,14) = (/&
 & 1.3836E+02_JPRB,1.6228E+02_JPRB,1.8728E+02_JPRB,2.1350E+02_JPRB,2.4088E+02_JPRB/)  
KBO( :,29,14) = (/&
 & 1.2669E+02_JPRB,1.4825E+02_JPRB,1.7120E+02_JPRB,1.9571E+02_JPRB,2.2144E+02_JPRB/)  
KBO( :,30,14) = (/&
 & 1.1586E+02_JPRB,1.3560E+02_JPRB,1.5706E+02_JPRB,1.7985E+02_JPRB,2.0425E+02_JPRB/)  
KBO( :,31,14) = (/&
 & 1.0606E+02_JPRB,1.2445E+02_JPRB,1.4457E+02_JPRB,1.6605E+02_JPRB,1.8909E+02_JPRB/)  
KBO( :,32,14) = (/&
 & 9.7506E+01_JPRB,1.1472E+02_JPRB,1.3364E+02_JPRB,1.5393E+02_JPRB,1.7576E+02_JPRB/)  
KBO( :,33,14) = (/&
 & 9.0128E+01_JPRB,1.0634E+02_JPRB,1.2404E+02_JPRB,1.4330E+02_JPRB,1.6431E+02_JPRB/)  
KBO( :,34,14) = (/&
 & 8.3269E+01_JPRB,9.8432E+01_JPRB,1.1521E+02_JPRB,1.3353E+02_JPRB,1.5390E+02_JPRB/)  
KBO( :,35,14) = (/&
 & 7.5995E+01_JPRB,9.0208E+01_JPRB,1.0603E+02_JPRB,1.2357E+02_JPRB,1.4330E+02_JPRB/)  
KBO( :,36,14) = (/&
 & 6.8313E+01_JPRB,8.1602E+01_JPRB,9.6446E+01_JPRB,1.1317E+02_JPRB,1.3204E+02_JPRB/)  
KBO( :,37,14) = (/&
 & 5.9886E+01_JPRB,7.2145E+01_JPRB,8.5923E+01_JPRB,1.0161E+02_JPRB,1.1943E+02_JPRB/)  
KBO( :,38,14) = (/&
 & 5.2518E+01_JPRB,6.3836E+01_JPRB,7.6674E+01_JPRB,9.1446E+01_JPRB,1.0826E+02_JPRB/)  
KBO( :,39,14) = (/&
 & 4.6141E+01_JPRB,5.6624E+01_JPRB,6.8640E+01_JPRB,8.2585E+01_JPRB,9.8545E+01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB2:PART6',1,ZHOOK_HANDLE)
END SUBROUTINE PART6


SUBROUTINE PART7

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB2:PART7',0,ZHOOK_HANDLE)


KBO( :,40,14) = (/&
 & 3.9743E+01_JPRB,4.9296E+01_JPRB,6.0431E+01_JPRB,7.3425E+01_JPRB,8.8431E+01_JPRB/)  
KBO( :,41,14) = (/&
 & 3.4132E+01_JPRB,4.2840E+01_JPRB,5.3118E+01_JPRB,6.5214E+01_JPRB,7.9338E+01_JPRB/)  
KBO( :,42,14) = (/&
 & 2.9302E+01_JPRB,3.7264E+01_JPRB,4.6737E+01_JPRB,5.8014E+01_JPRB,7.1287E+01_JPRB/)  
KBO( :,43,14) = (/&
 & 2.4764E+01_JPRB,3.1960E+01_JPRB,4.0612E+01_JPRB,5.1039E+01_JPRB,6.3433E+01_JPRB/)  
KBO( :,44,14) = (/&
 & 2.0724E+01_JPRB,2.7192E+01_JPRB,3.5067E+01_JPRB,4.4640E+01_JPRB,5.6164E+01_JPRB/)  
KBO( :,45,14) = (/&
 & 1.7302E+01_JPRB,2.3086E+01_JPRB,3.0232E+01_JPRB,3.8995E+01_JPRB,4.9699E+01_JPRB/)  
KBO( :,46,14) = (/&
 & 1.4294E+01_JPRB,1.9412E+01_JPRB,2.5856E+01_JPRB,3.3850E+01_JPRB,4.3695E+01_JPRB/)  
KBO( :,47,14) = (/&
 & 1.1576E+01_JPRB,1.6045E+01_JPRB,2.1765E+01_JPRB,2.8969E+01_JPRB,3.7957E+01_JPRB/)  
KBO( :,48,14) = (/&
 & 9.3047E+00_JPRB,1.3187E+01_JPRB,1.8238E+01_JPRB,2.4704E+01_JPRB,3.2846E+01_JPRB/)  
KBO( :,49,14) = (/&
 & 7.4233E+00_JPRB,1.0766E+01_JPRB,1.5205E+01_JPRB,2.0973E+01_JPRB,2.8303E+01_JPRB/)  
KBO( :,50,14) = (/&
 & 5.9319E+00_JPRB,8.8036E+00_JPRB,1.2699E+01_JPRB,1.7857E+01_JPRB,2.4492E+01_JPRB/)  
KBO( :,51,14) = (/&
 & 4.7353E+00_JPRB,7.1869E+00_JPRB,1.0601E+01_JPRB,1.5199E+01_JPRB,2.1205E+01_JPRB/)  
KBO( :,52,14) = (/&
 & 3.7469E+00_JPRB,5.8275E+00_JPRB,8.7938E+00_JPRB,1.2866E+01_JPRB,1.8302E+01_JPRB/)  
KBO( :,53,14) = (/&
 & 2.9368E+00_JPRB,4.6957E+00_JPRB,7.2478E+00_JPRB,1.0838E+01_JPRB,1.5721E+01_JPRB/)  
KBO( :,54,14) = (/&
 & 2.3156E+00_JPRB,3.8057E+00_JPRB,6.0167E+00_JPRB,9.1925E+00_JPRB,1.3590E+01_JPRB/)  
KBO( :,55,14) = (/&
 & 1.8252E+00_JPRB,3.0811E+00_JPRB,5.0017E+00_JPRB,7.8029E+00_JPRB,1.1764E+01_JPRB/)  
KBO( :,56,14) = (/&
 & 1.4272E+00_JPRB,2.4767E+00_JPRB,4.1376E+00_JPRB,6.5946E+00_JPRB,1.0136E+01_JPRB/)  
KBO( :,57,14) = (/&
 & 1.1086E+00_JPRB,1.9781E+00_JPRB,3.3958E+00_JPRB,5.5471E+00_JPRB,8.7031E+00_JPRB/)  
KBO( :,58,14) = (/&
 & 8.6140E-01_JPRB,1.5824E+00_JPRB,2.7911E+00_JPRB,4.6768E+00_JPRB,7.4888E+00_JPRB/)  
KBO( :,59,14) = (/&
 & 7.4828E-01_JPRB,1.4056E+00_JPRB,2.5265E+00_JPRB,4.3052E+00_JPRB,6.9802E+00_JPRB/)  
KBO( :,13,15) = (/&
 & 1.0111E+03_JPRB,1.2570E+03_JPRB,1.4901E+03_JPRB,1.7375E+03_JPRB,1.9647E+03_JPRB/)  
KBO( :,14,15) = (/&
 & 1.0798E+03_JPRB,1.3354E+03_JPRB,1.5807E+03_JPRB,1.8253E+03_JPRB,2.0644E+03_JPRB/)  
KBO( :,15,15) = (/&
 & 1.1550E+03_JPRB,1.4096E+03_JPRB,1.6671E+03_JPRB,1.9146E+03_JPRB,2.1680E+03_JPRB/)  
KBO( :,16,15) = (/&
 & 1.2133E+03_JPRB,1.4796E+03_JPRB,1.7458E+03_JPRB,1.9980E+03_JPRB,2.2730E+03_JPRB/)  
KBO( :,17,15) = (/&
 & 1.2650E+03_JPRB,1.5359E+03_JPRB,1.8049E+03_JPRB,2.0803E+03_JPRB,2.3678E+03_JPRB/)  
KBO( :,18,15) = (/&
 & 1.3114E+03_JPRB,1.5935E+03_JPRB,1.8807E+03_JPRB,2.1759E+03_JPRB,2.4722E+03_JPRB/)  
KBO( :,19,15) = (/&
 & 1.3601E+03_JPRB,1.6562E+03_JPRB,1.9621E+03_JPRB,2.2640E+03_JPRB,2.5731E+03_JPRB/)  
KBO( :,20,15) = (/&
 & 1.4219E+03_JPRB,1.7257E+03_JPRB,2.0357E+03_JPRB,2.3424E+03_JPRB,2.6494E+03_JPRB/)  
KBO( :,21,15) = (/&
 & 1.4797E+03_JPRB,1.7824E+03_JPRB,2.0872E+03_JPRB,2.4001E+03_JPRB,2.7105E+03_JPRB/)  
KBO( :,22,15) = (/&
 & 1.5335E+03_JPRB,1.8378E+03_JPRB,2.1448E+03_JPRB,2.4560E+03_JPRB,2.7714E+03_JPRB/)  
KBO( :,23,15) = (/&
 & 1.5773E+03_JPRB,1.8793E+03_JPRB,2.1836E+03_JPRB,2.4946E+03_JPRB,2.8114E+03_JPRB/)  
KBO( :,24,15) = (/&
 & 1.6080E+03_JPRB,1.9047E+03_JPRB,2.2086E+03_JPRB,2.5288E+03_JPRB,2.8346E+03_JPRB/)  
KBO( :,25,15) = (/&
 & 1.6263E+03_JPRB,1.9189E+03_JPRB,2.2269E+03_JPRB,2.5372E+03_JPRB,2.8437E+03_JPRB/)  
KBO( :,26,15) = (/&
 & 1.6402E+03_JPRB,1.9311E+03_JPRB,2.2342E+03_JPRB,2.5429E+03_JPRB,2.8526E+03_JPRB/)  
KBO( :,27,15) = (/&
 & 1.6484E+03_JPRB,1.9393E+03_JPRB,2.2378E+03_JPRB,2.5479E+03_JPRB,2.8584E+03_JPRB/)  
KBO( :,28,15) = (/&
 & 1.6552E+03_JPRB,1.9438E+03_JPRB,2.2426E+03_JPRB,2.5488E+03_JPRB,2.8513E+03_JPRB/)  
KBO( :,29,15) = (/&
 & 1.6623E+03_JPRB,1.9469E+03_JPRB,2.2435E+03_JPRB,2.5469E+03_JPRB,2.8487E+03_JPRB/)  
KBO( :,30,15) = (/&
 & 1.6645E+03_JPRB,1.9461E+03_JPRB,2.2408E+03_JPRB,2.5383E+03_JPRB,2.8471E+03_JPRB/)  
KBO( :,31,15) = (/&
 & 1.6666E+03_JPRB,1.9464E+03_JPRB,2.2424E+03_JPRB,2.5437E+03_JPRB,2.8541E+03_JPRB/)  
KBO( :,32,15) = (/&
 & 1.6715E+03_JPRB,1.9532E+03_JPRB,2.2512E+03_JPRB,2.5534E+03_JPRB,2.8676E+03_JPRB/)  
KBO( :,33,15) = (/&
 & 1.6819E+03_JPRB,1.9666E+03_JPRB,2.2688E+03_JPRB,2.5748E+03_JPRB,2.8918E+03_JPRB/)  
KBO( :,34,15) = (/&
 & 1.6895E+03_JPRB,1.9778E+03_JPRB,2.2816E+03_JPRB,2.5925E+03_JPRB,2.9158E+03_JPRB/)  
KBO( :,35,15) = (/&
 & 1.6762E+03_JPRB,1.9659E+03_JPRB,2.2723E+03_JPRB,2.5875E+03_JPRB,2.9156E+03_JPRB/)  
KBO( :,36,15) = (/&
 & 1.6393E+03_JPRB,1.9297E+03_JPRB,2.2372E+03_JPRB,2.5554E+03_JPRB,2.8869E+03_JPRB/)  
KBO( :,37,15) = (/&
 & 1.5657E+03_JPRB,1.8547E+03_JPRB,2.1621E+03_JPRB,2.4812E+03_JPRB,2.8134E+03_JPRB/)  
KBO( :,38,15) = (/&
 & 1.4959E+03_JPRB,1.7834E+03_JPRB,2.0905E+03_JPRB,2.4085E+03_JPRB,2.7423E+03_JPRB/)  
KBO( :,39,15) = (/&
 & 1.4312E+03_JPRB,1.7180E+03_JPRB,2.0231E+03_JPRB,2.3408E+03_JPRB,2.6756E+03_JPRB/)  
KBO( :,40,15) = (/&
 & 1.3437E+03_JPRB,1.6273E+03_JPRB,1.9282E+03_JPRB,2.2440E+03_JPRB,2.5841E+03_JPRB/)  
KBO( :,41,15) = (/&
 & 1.2581E+03_JPRB,1.5370E+03_JPRB,1.8334E+03_JPRB,2.1461E+03_JPRB,2.4843E+03_JPRB/)  
KBO( :,42,15) = (/&
 & 1.1774E+03_JPRB,1.4499E+03_JPRB,1.7425E+03_JPRB,2.0516E+03_JPRB,2.3873E+03_JPRB/)  
KBO( :,43,15) = (/&
 & 1.0861E+03_JPRB,1.3512E+03_JPRB,1.6377E+03_JPRB,1.9415E+03_JPRB,2.2734E+03_JPRB/)  
KBO( :,44,15) = (/&
 & 9.9323E+02_JPRB,1.2501E+03_JPRB,1.5289E+03_JPRB,1.8275E+03_JPRB,2.1544E+03_JPRB/)  
KBO( :,45,15) = (/&
 & 9.0550E+02_JPRB,1.1536E+03_JPRB,1.4239E+03_JPRB,1.7214E+03_JPRB,2.0382E+03_JPRB/)  
KBO( :,46,15) = (/&
 & 8.1702E+02_JPRB,1.0558E+03_JPRB,1.3173E+03_JPRB,1.6071E+03_JPRB,1.9180E+03_JPRB/)  
KBO( :,47,15) = (/&
 & 7.2488E+02_JPRB,9.5181E+02_JPRB,1.2036E+03_JPRB,1.4836E+03_JPRB,1.7874E+03_JPRB/)  
KBO( :,48,15) = (/&
 & 6.3986E+02_JPRB,8.5318E+02_JPRB,1.0938E+03_JPRB,1.3648E+03_JPRB,1.6602E+03_JPRB/)  
KBO( :,49,15) = (/&
 & 5.5978E+02_JPRB,7.6064E+02_JPRB,9.8918E+02_JPRB,1.2514E+03_JPRB,1.5371E+03_JPRB/)  
KBO( :,50,15) = (/&
 & 4.9043E+02_JPRB,6.7832E+02_JPRB,8.9646E+02_JPRB,1.1489E+03_JPRB,1.4252E+03_JPRB/)  
KBO( :,51,15) = (/&
 & 4.2854E+02_JPRB,6.0344E+02_JPRB,8.1294E+02_JPRB,1.0522E+03_JPRB,1.3193E+03_JPRB/)  
KBO( :,52,15) = (/&
 & 3.7247E+02_JPRB,5.3364E+02_JPRB,7.3121E+02_JPRB,9.5966E+02_JPRB,1.2181E+03_JPRB/)  
KBO( :,53,15) = (/&
 & 3.2147E+02_JPRB,4.6899E+02_JPRB,6.5393E+02_JPRB,8.7133E+02_JPRB,1.1199E+03_JPRB/)  
KBO( :,54,15) = (/&
 & 2.7925E+02_JPRB,4.1444E+02_JPRB,5.8692E+02_JPRB,7.9382E+02_JPRB,1.0327E+03_JPRB/)  
KBO( :,55,15) = (/&
 & 2.4236E+02_JPRB,3.6648E+02_JPRB,5.2661E+02_JPRB,7.2283E+02_JPRB,9.5269E+02_JPRB/)  
KBO( :,56,15) = (/&
 & 2.0878E+02_JPRB,3.2240E+02_JPRB,4.7042E+02_JPRB,6.5558E+02_JPRB,8.7457E+02_JPRB/)  
KBO( :,57,15) = (/&
 & 1.7832E+02_JPRB,2.8217E+02_JPRB,4.1844E+02_JPRB,5.9173E+02_JPRB,8.0081E+02_JPRB/)  
KBO( :,58,15) = (/&
 & 1.5222E+02_JPRB,2.4706E+02_JPRB,3.7269E+02_JPRB,5.3459E+02_JPRB,7.3370E+02_JPRB/)  
KBO( :,59,15) = (/&
 & 1.4227E+02_JPRB,2.3374E+02_JPRB,3.5521E+02_JPRB,5.1259E+02_JPRB,7.0748E+02_JPRB/)  
KBO( :,13,16) = (/&
 & 3.6681E+03_JPRB,4.4146E+03_JPRB,5.0601E+03_JPRB,5.8217E+03_JPRB,6.4602E+03_JPRB/)  
KBO( :,14,16) = (/&
 & 4.1383E+03_JPRB,5.0055E+03_JPRB,5.7969E+03_JPRB,6.5815E+03_JPRB,7.3466E+03_JPRB/)  
KBO( :,15,16) = (/&
 & 4.7877E+03_JPRB,5.7010E+03_JPRB,6.6308E+03_JPRB,7.5076E+03_JPRB,8.4346E+03_JPRB/)  
KBO( :,16,16) = (/&
 & 5.4281E+03_JPRB,6.5150E+03_JPRB,7.5529E+03_JPRB,8.5202E+03_JPRB,9.5967E+03_JPRB/)  
KBO( :,17,16) = (/&
 & 6.1845E+03_JPRB,7.4144E+03_JPRB,8.5274E+03_JPRB,9.6391E+03_JPRB,1.0752E+04_JPRB/)  
KBO( :,18,16) = (/&
 & 7.0091E+03_JPRB,8.3702E+03_JPRB,9.5741E+03_JPRB,1.0846E+04_JPRB,1.1981E+04_JPRB/)  
KBO( :,19,16) = (/&
 & 7.8177E+03_JPRB,9.3538E+03_JPRB,1.0755E+04_JPRB,1.2016E+04_JPRB,1.3317E+04_JPRB/)  
KBO( :,20,16) = (/&
 & 8.7063E+03_JPRB,1.0319E+04_JPRB,1.1914E+04_JPRB,1.3366E+04_JPRB,1.4769E+04_JPRB/)  
KBO( :,21,16) = (/&
 & 9.6583E+03_JPRB,1.1430E+04_JPRB,1.3099E+04_JPRB,1.4798E+04_JPRB,1.6351E+04_JPRB/)  
KBO( :,22,16) = (/&
 & 1.0855E+04_JPRB,1.2791E+04_JPRB,1.4609E+04_JPRB,1.6400E+04_JPRB,1.8171E+04_JPRB/)  
KBO( :,23,16) = (/&
 & 1.2201E+04_JPRB,1.4278E+04_JPRB,1.6275E+04_JPRB,1.8206E+04_JPRB,2.0113E+04_JPRB/)  
KBO( :,24,16) = (/&
 & 1.3628E+04_JPRB,1.5860E+04_JPRB,1.8039E+04_JPRB,2.0176E+04_JPRB,2.2137E+04_JPRB/)  
KBO( :,25,16) = (/&
 & 1.5188E+04_JPRB,1.7579E+04_JPRB,1.9918E+04_JPRB,2.2170E+04_JPRB,2.4222E+04_JPRB/)  
KBO( :,26,16) = (/&
 & 1.6826E+04_JPRB,1.9365E+04_JPRB,2.1844E+04_JPRB,2.4184E+04_JPRB,2.6322E+04_JPRB/)  
KBO( :,27,16) = (/&
 & 1.8524E+04_JPRB,2.1162E+04_JPRB,2.3751E+04_JPRB,2.6170E+04_JPRB,2.8371E+04_JPRB/)  
KBO( :,28,16) = (/&
 & 2.0216E+04_JPRB,2.2951E+04_JPRB,2.5589E+04_JPRB,2.8116E+04_JPRB,3.0326E+04_JPRB/)  
KBO( :,29,16) = (/&
 & 2.1910E+04_JPRB,2.4742E+04_JPRB,2.7452E+04_JPRB,3.0040E+04_JPRB,3.2278E+04_JPRB/)  
KBO( :,30,16) = (/&
 & 2.3613E+04_JPRB,2.6515E+04_JPRB,2.9278E+04_JPRB,3.1815E+04_JPRB,3.4145E+04_JPRB/)  
KBO( :,31,16) = (/&
 & 2.5314E+04_JPRB,2.8268E+04_JPRB,3.1043E+04_JPRB,3.3568E+04_JPRB,3.5897E+04_JPRB/)  
KBO( :,32,16) = (/&
 & 2.6975E+04_JPRB,2.9937E+04_JPRB,3.2719E+04_JPRB,3.5244E+04_JPRB,3.7549E+04_JPRB/)  
KBO( :,33,16) = (/&
 & 2.8572E+04_JPRB,3.1529E+04_JPRB,3.4290E+04_JPRB,3.6787E+04_JPRB,3.9063E+04_JPRB/)  
KBO( :,34,16) = (/&
 & 2.9977E+04_JPRB,3.2921E+04_JPRB,3.5678E+04_JPRB,3.8134E+04_JPRB,4.0357E+04_JPRB/)  
KBO( :,35,16) = (/&
 & 3.0980E+04_JPRB,3.3963E+04_JPRB,3.6707E+04_JPRB,3.9142E+04_JPRB,4.1334E+04_JPRB/)  
KBO( :,36,16) = (/&
 & 3.1578E+04_JPRB,3.4586E+04_JPRB,3.7314E+04_JPRB,3.9783E+04_JPRB,4.1980E+04_JPRB/)  
KBO( :,37,16) = (/&
 & 3.1622E+04_JPRB,3.4683E+04_JPRB,3.7456E+04_JPRB,3.9972E+04_JPRB,4.2211E+04_JPRB/)  
KBO( :,38,16) = (/&
 & 3.1560E+04_JPRB,3.4667E+04_JPRB,3.7489E+04_JPRB,4.0060E+04_JPRB,4.2344E+04_JPRB/)  
KBO( :,39,16) = (/&
 & 3.1432E+04_JPRB,3.4581E+04_JPRB,3.7452E+04_JPRB,4.0068E+04_JPRB,4.2389E+04_JPRB/)  
KBO( :,40,16) = (/&
 & 3.0900E+04_JPRB,3.4111E+04_JPRB,3.7067E+04_JPRB,3.9756E+04_JPRB,4.2232E+04_JPRB/)  
KBO( :,41,16) = (/&
 & 3.0258E+04_JPRB,3.3539E+04_JPRB,3.6571E+04_JPRB,3.9344E+04_JPRB,4.1895E+04_JPRB/)  
KBO( :,42,16) = (/&
 & 2.9543E+04_JPRB,3.2906E+04_JPRB,3.6015E+04_JPRB,3.8861E+04_JPRB,4.1489E+04_JPRB/)  
KBO( :,43,16) = (/&
 & 2.8595E+04_JPRB,3.2035E+04_JPRB,3.5232E+04_JPRB,3.8174E+04_JPRB,4.0894E+04_JPRB/)  
KBO( :,44,16) = (/&
 & 2.7503E+04_JPRB,3.1021E+04_JPRB,3.4315E+04_JPRB,3.7350E+04_JPRB,4.0170E+04_JPRB/)  
KBO( :,45,16) = (/&
 & 2.6360E+04_JPRB,2.9953E+04_JPRB,3.3340E+04_JPRB,3.6512E+04_JPRB,3.9389E+04_JPRB/)  
KBO( :,46,16) = (/&
 & 2.5097E+04_JPRB,2.8760E+04_JPRB,3.2236E+04_JPRB,3.5509E+04_JPRB,3.8490E+04_JPRB/)  
KBO( :,47,16) = (/&
 & 2.3642E+04_JPRB,2.7372E+04_JPRB,3.0938E+04_JPRB,3.4319E+04_JPRB,3.7409E+04_JPRB/)  
KBO( :,48,16) = (/&
 & 2.2183E+04_JPRB,2.5937E+04_JPRB,2.9591E+04_JPRB,3.3067E+04_JPRB,3.6272E+04_JPRB/)  
KBO( :,49,16) = (/&
 & 2.0670E+04_JPRB,2.4507E+04_JPRB,2.8195E+04_JPRB,3.1753E+04_JPRB,3.5074E+04_JPRB/)  
KBO( :,50,16) = (/&
 & 1.9238E+04_JPRB,2.3103E+04_JPRB,2.6846E+04_JPRB,3.0481E+04_JPRB,3.3904E+04_JPRB/)  
KBO( :,51,16) = (/&
 & 1.7844E+04_JPRB,2.1722E+04_JPRB,2.5514E+04_JPRB,2.9217E+04_JPRB,3.2732E+04_JPRB/)  
KBO( :,52,16) = (/&
 & 1.6449E+04_JPRB,2.0331E+04_JPRB,2.4157E+04_JPRB,2.7921E+04_JPRB,3.1511E+04_JPRB/)  
KBO( :,53,16) = (/&
 & 1.5063E+04_JPRB,1.8925E+04_JPRB,2.2776E+04_JPRB,2.6593E+04_JPRB,3.0255E+04_JPRB/)  
KBO( :,54,16) = (/&
 & 1.3809E+04_JPRB,1.7636E+04_JPRB,2.1500E+04_JPRB,2.5353E+04_JPRB,2.9077E+04_JPRB/)  
KBO( :,55,16) = (/&
 & 1.2629E+04_JPRB,1.6403E+04_JPRB,2.0265E+04_JPRB,2.4149E+04_JPRB,2.7924E+04_JPRB/)  
KBO( :,56,16) = (/&
 & 1.1481E+04_JPRB,1.5182E+04_JPRB,1.9032E+04_JPRB,2.2931E+04_JPRB,2.6738E+04_JPRB/)  
KBO( :,57,16) = (/&
 & 1.0369E+04_JPRB,1.3975E+04_JPRB,1.7793E+04_JPRB,2.1704E+04_JPRB,2.5546E+04_JPRB/)  
KBO( :,58,16) = (/&
 & 9.3525E+03_JPRB,1.2853E+04_JPRB,1.6624E+04_JPRB,2.0533E+04_JPRB,2.4399E+04_JPRB/)  
KBO( :,59,16) = (/&
 & 8.9578E+03_JPRB,1.2412E+04_JPRB,1.6161E+04_JPRB,2.0067E+04_JPRB,2.3943E+04_JPRB/)  

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
 & 7.54232E-01_JPRB, 6.87231E-01_JPRB, 6.26181E-01_JPRB, 5.70555E-01_JPRB, 5.19870E-01_JPRB,&
 & 4.73688E-01_JPRB, 4.31608E-01_JPRB, 3.93266E-01_JPRB, 3.58331E-01_JPRB, 3.26499E-01_JPRB/)  
SELFREFO( :, 2) = (/&
 & 1.01377E+00_JPRB, 9.30266E-01_JPRB, 8.53637E-01_JPRB, 7.83320E-01_JPRB, 7.18796E-01_JPRB,&
 & 6.59587E-01_JPRB, 6.05254E-01_JPRB, 5.55398E-01_JPRB, 5.09648E-01_JPRB, 4.67667E-01_JPRB/)  
SELFREFO( :, 3) = (/&
 & 1.31954E+00_JPRB, 1.22523E+00_JPRB, 1.13766E+00_JPRB, 1.05635E+00_JPRB, 9.80853E-01_JPRB,&
 & 9.10749E-01_JPRB, 8.45656E-01_JPRB, 7.85215E-01_JPRB, 7.29095E-01_JPRB, 6.76985E-01_JPRB/)  
SELFREFO( :, 4) = (/&
 & 2.18726E+00_JPRB, 2.05960E+00_JPRB, 1.93940E+00_JPRB, 1.82621E+00_JPRB, 1.71962E+00_JPRB,&
 & 1.61926E+00_JPRB, 1.52476E+00_JPRB, 1.43577E+00_JPRB, 1.35197E+00_JPRB, 1.27306E+00_JPRB/)  
SELFREFO( :, 5) = (/&
 & 3.17440E+00_JPRB, 2.92794E+00_JPRB, 2.70061E+00_JPRB, 2.49094E+00_JPRB, 2.29754E+00_JPRB,&
 & 2.11916E+00_JPRB, 1.95463E+00_JPRB, 1.80287E+00_JPRB, 1.66290E+00_JPRB, 1.53379E+00_JPRB/)  
SELFREFO( :, 6) = (/&
 & 2.69705E+00_JPRB, 2.48684E+00_JPRB, 2.29302E+00_JPRB, 2.11431E+00_JPRB, 1.94952E+00_JPRB,&
 & 1.79758E+00_JPRB, 1.65748E+00_JPRB, 1.52830E+00_JPRB, 1.40919E+00_JPRB, 1.29936E+00_JPRB/)  
SELFREFO( :, 7) = (/&
 & 2.91893E+00_JPRB, 2.68371E+00_JPRB, 2.46745E+00_JPRB, 2.26862E+00_JPRB, 2.08581E+00_JPRB,&
 & 1.91773E+00_JPRB, 1.76319E+00_JPRB, 1.62111E+00_JPRB, 1.49048E+00_JPRB, 1.37037E+00_JPRB/)  
SELFREFO( :, 8) = (/&
 & 2.91847E+00_JPRB, 2.69138E+00_JPRB, 2.48195E+00_JPRB, 2.28883E+00_JPRB, 2.11073E+00_JPRB,&
 & 1.94648E+00_JPRB, 1.79502E+00_JPRB, 1.65535E+00_JPRB, 1.52654E+00_JPRB, 1.40776E+00_JPRB/)  
SELFREFO( :, 9) = (/&
 & 2.73994E+00_JPRB, 2.54834E+00_JPRB, 2.37014E+00_JPRB, 2.20440E+00_JPRB, 2.05026E+00_JPRB,&
 & 1.90689E+00_JPRB, 1.77354E+00_JPRB, 1.64952E+00_JPRB, 1.53418E+00_JPRB, 1.42690E+00_JPRB/)  
SELFREFO( :,10) = (/&
 & 2.81902E+00_JPRB, 2.66010E+00_JPRB, 2.51014E+00_JPRB, 2.36863E+00_JPRB, 2.23510E+00_JPRB,&
 & 2.10909E+00_JPRB, 1.99020E+00_JPRB, 1.87800E+00_JPRB, 1.77213E+00_JPRB, 1.67222E+00_JPRB/)  
SELFREFO( :,11) = (/&
 & 3.19430E+00_JPRB, 2.97671E+00_JPRB, 2.77395E+00_JPRB, 2.58500E+00_JPRB, 2.40891E+00_JPRB,&
 & 2.24483E+00_JPRB, 2.09192E+00_JPRB, 1.94942E+00_JPRB, 1.81663E+00_JPRB, 1.69289E+00_JPRB/)  
SELFREFO( :,12) = (/&
 & 3.24778E+00_JPRB, 3.04535E+00_JPRB, 2.85553E+00_JPRB, 2.67755E+00_JPRB, 2.51066E+00_JPRB,&
 & 2.35417E+00_JPRB, 2.20744E+00_JPRB, 2.06985E+00_JPRB, 1.94084E+00_JPRB, 1.81987E+00_JPRB/)  
SELFREFO( :,13) = (/&
 & 3.67142E+00_JPRB, 3.39875E+00_JPRB, 3.14634E+00_JPRB, 2.91267E+00_JPRB, 2.69636E+00_JPRB,&
 & 2.49611E+00_JPRB, 2.31073E+00_JPRB, 2.13913E+00_JPRB, 1.98026E+00_JPRB, 1.83319E+00_JPRB/)  
SELFREFO( :,14) = (/&
 & 3.73679E+00_JPRB, 3.49113E+00_JPRB, 3.26162E+00_JPRB, 3.04719E+00_JPRB, 2.84686E+00_JPRB,&
 & 2.65970E+00_JPRB, 2.48485E+00_JPRB, 2.32149E+00_JPRB, 2.16887E+00_JPRB, 2.02628E+00_JPRB/)  
SELFREFO( :,15) = (/&
 & 4.25684E+00_JPRB, 3.95885E+00_JPRB, 3.68171E+00_JPRB, 3.42397E+00_JPRB, 3.18428E+00_JPRB,&
 & 2.96137E+00_JPRB, 2.75406E+00_JPRB, 2.56126E+00_JPRB, 2.38196E+00_JPRB, 2.21521E+00_JPRB/)  
SELFREFO( :,16) = (/&
 & 4.97048E+00_JPRB, 4.59255E+00_JPRB, 4.24336E+00_JPRB, 3.92072E+00_JPRB, 3.62261E+00_JPRB,&
 & 3.34717E+00_JPRB, 3.09267E+00_JPRB, 2.85752E+00_JPRB, 2.64025E+00_JPRB, 2.43950E+00_JPRB/)  

!     The ith set of reference fractions are from the ith reference
!     pressure level.
FRACREFAO( :, 1) = (/&
 & 0.18068060_JPRB,0.16803175_JPRB,0.15140158_JPRB,0.12221480_JPRB,&
 & 0.10240850_JPRB,0.09330297_JPRB,0.07518960_JPRB,0.05611294_JPRB,&
 & 0.03781487_JPRB,0.00387192_JPRB,0.00321285_JPRB,0.00244440_JPRB,&
 & 0.00179546_JPRB,0.00107704_JPRB,0.00038798_JPRB,0.00005060_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB2:PART7',1,ZHOOK_HANDLE)
END SUBROUTINE PART7


SUBROUTINE PART8

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB2:PART8',0,ZHOOK_HANDLE)


FRACREFAO( :, 2) = (/&
 & 0.17927621_JPRB,0.16731168_JPRB,0.15129538_JPRB,0.12328085_JPRB,&
 & 0.10243484_JPRB,0.09354796_JPRB,0.07538418_JPRB,0.05633071_JPRB,&
 & 0.03810832_JPRB,0.00398347_JPRB,0.00320262_JPRB,0.00250029_JPRB,&
 & 0.00178666_JPRB,0.00111127_JPRB,0.00039438_JPRB,0.00005169_JPRB/)  
FRACREFAO( :, 3) = (/&
 & 0.17762886_JPRB,0.16638555_JPRB,0.15115446_JPRB,0.12470623_JPRB,&
 & 0.10253213_JPRB,0.09383459_JPRB,0.07560240_JPRB,0.05646568_JPRB,&
 & 0.03844077_JPRB,0.00409142_JPRB,0.00322521_JPRB,0.00254918_JPRB,&
 & 0.00179296_JPRB,0.00113652_JPRB,0.00040169_JPRB,0.00005259_JPRB/)  
FRACREFAO( :, 4) = (/&
 & 0.17566043_JPRB,0.16539773_JPRB,0.15092199_JPRB,0.12571971_JPRB,&
 & 0.10340609_JPRB,0.09426189_JPRB,0.07559051_JPRB,0.05678188_JPRB,&
 & 0.03881499_JPRB,0.00414102_JPRB,0.00328551_JPRB,0.00258795_JPRB,&
 & 0.00181648_JPRB,0.00115145_JPRB,0.00040969_JPRB,0.00005357_JPRB/)  
FRACREFAO( :, 5) = (/&
 & 0.17335825_JPRB,0.16442548_JPRB,0.15070701_JPRB,0.12667464_JPRB,&
 & 0.10452303_JPRB,0.09450833_JPRB,0.07599410_JPRB,0.05706393_JPRB,&
 & 0.03910370_JPRB,0.00417880_JPRB,0.00335256_JPRB,0.00261708_JPRB,&
 & 0.00185491_JPRB,0.00116627_JPRB,0.00041759_JPRB,0.00005464_JPRB/)  
FRACREFAO( :, 6) = (/&
 & 0.17082544_JPRB,0.16321516_JPRB,0.15044247_JPRB,0.12797612_JPRB,&
 & 0.10574646_JPRB,0.09470057_JPRB,0.07647423_JPRB,0.05738756_JPRB,&
 & 0.03935621_JPRB,0.00423789_JPRB,0.00342651_JPRB,0.00264549_JPRB,&
 & 0.00190188_JPRB,0.00118281_JPRB,0.00042592_JPRB,0.00005583_JPRB/)  
FRACREFAO( :, 7) = (/&
 & 0.16809277_JPRB,0.16193336_JPRB,0.15013184_JPRB,0.12937409_JPRB,&
 & 0.10720784_JPRB,0.09485368_JPRB,0.07692636_JPRB,0.05771774_JPRB,&
 & 0.03966988_JPRB,0.00427754_JPRB,0.00349696_JPRB,0.00268946_JPRB,&
 & 0.00193536_JPRB,0.00120222_JPRB,0.00043462_JPRB,0.00005712_JPRB/)  
FRACREFAO( :, 8) = (/&
 & 0.16517997_JPRB,0.16059248_JPRB,0.14984852_JPRB,0.13079269_JPRB,&
 & 0.10865030_JPRB,0.09492947_JPRB,0.07759736_JPRB,0.05812201_JPRB,&
 & 0.03997169_JPRB,0.00432356_JPRB,0.00355308_JPRB,0.00274031_JPRB,&
 & 0.00197243_JPRB,0.00122401_JPRB,0.00044359_JPRB,0.00005849_JPRB/)  
FRACREFAO( :, 9) = (/&
 & 0.16209179_JPRB,0.15912023_JPRB,0.14938223_JPRB,0.13198245_JPRB,&
 & 0.11077233_JPRB,0.09487948_JPRB,0.07831636_JPRB,0.05863440_JPRB,&
 & 0.04028239_JPRB,0.00436804_JPRB,0.00360407_JPRB,0.00279885_JPRB,&
 & 0.00200364_JPRB,0.00124861_JPRB,0.00045521_JPRB,0.00005996_JPRB/)  
FRACREFAO( :,10) = (/&
 & 0.15962425_JPRB,0.15789343_JPRB,0.14898103_JPRB,0.13275230_JPRB,&
 & 0.11253940_JPRB,0.09503502_JPRB,0.07884382_JPRB,0.05908009_JPRB,&
 & 0.04053524_JPRB,0.00439971_JPRB,0.00364269_JPRB,0.00284965_JPRB,&
 & 0.00202758_JPRB,0.00127076_JPRB,0.00046408_JPRB,0.00006114_JPRB/)  
FRACREFAO( :,11) = (/&
 & 0.15926200_JPRB,0.15770932_JPRB,0.14891729_JPRB,0.13283882_JPRB,&
 & 0.11276010_JPRB,0.09507311_JPRB,0.07892222_JPRB,0.05919230_JPRB,&
 & 0.04054824_JPRB,0.00440833_JPRB,0.00365575_JPRB,0.00286459_JPRB,&
 & 0.00203786_JPRB,0.00128405_JPRB,0.00046504_JPRB,0.00006146_JPRB/)  
FRACREFAO( :,12) = (/&
 & 0.15926351_JPRB,0.15770483_JPRB,0.14891177_JPRB,0.13279966_JPRB,&
 & 0.11268171_JPRB,0.09515216_JPRB,0.07890341_JPRB,0.05924807_JPRB,&
 & 0.04052851_JPRB,0.00440870_JPRB,0.00365425_JPRB,0.00286878_JPRB,&
 & 0.00205747_JPRB,0.00128916_JPRB,0.00046589_JPRB,0.00006221_JPRB/)  
FRACREFAO( :,13) = (/&
 & 0.15937765_JPRB,0.15775780_JPRB,0.14892603_JPRB,0.13273248_JPRB,&
 & 0.11252731_JPRB,0.09521657_JPRB,0.07885858_JPRB,0.05927679_JPRB,&
 & 0.04050184_JPRB,0.00440285_JPRB,0.00365748_JPRB,0.00286791_JPRB,&
 & 0.00207507_JPRB,0.00129193_JPRB,0.00046679_JPRB,0.00006308_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB2:PART8',1,ZHOOK_HANDLE)
END SUBROUTINE PART8


END SUBROUTINE RRTM_KGB2
