!
! $Header$
!
SUBROUTINE convflu( xflu,yflu,nbniv,convfl )
  !
  !  P. Le Van
  !
  !
  !    *******************************************************************
  !  ... calcule la (convergence horiz. * aire locale)du flux ayant pour
  !  composantes xflu et yflu ,variables extensives .  ......
  !    *******************************************************************
  !  xflu , yflu et nbniv sont des arguments d'entree pour le s-pg ..
  !  convfl                est  un argument de sortie pour le s-pg .
  !
  ! njxflu  est le nombre de lignes de latitude de xflu,
  ! ( = jjm ou jjp1 )
  ! nbniv   est le nombre de niveaux vert. de  xflu et de yflu .
  !
  USE comgeom_mod_h
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h
IMPLICIT NONE
  !


  REAL :: xflu,yflu,convfl,convpn,convps
  INTEGER :: l,ij,nbniv
  DIMENSION  xflu( ip1jmp1,nbniv ),yflu( ip1jm,nbniv ) , &
        convfl( ip1jmp1,nbniv )
  !
  REAL :: SSUM
  !
  !
  !
  DO l = 1,nbniv
  !
  DO  ij = iip2, ip1jm - 1
  convfl( ij + 1,l ) =  xflu(   ij,l ) - xflu( ij +  1,l )   + &
        yflu(ij +1,l ) - yflu( ij -iim,l )
  END DO
  !
  !

  ! ....  correction pour  convfl( 1,j,l)  ......
  ! ....   convfl(1,j,l)= convfl(iip1,j,l) ...
  !
  !DIR$ IVDEP
  DO ij = iip2,ip1jm,iip1
  convfl( ij,l ) = convfl( ij + iim,l )
  END DO
  !
  ! ......  calcul aux poles  .......
  !
  convpn =   SSUM( iim, yflu(     1    ,l ),  1 )
  convps = - SSUM( iim, yflu( ip1jm-iim,l ),  1 )
  DO ij = 1,iip1
  convfl(     ij   ,l ) = convpn * aire(   ij     ) / apoln
  convfl( ij+ ip1jm,l ) = convps * aire( ij+ ip1jm) / apols
  END DO
  !
  END DO
  RETURN
END SUBROUTINE convflu
