!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif 
!pgi$r opt=0
SUBROUTINE SRTM_KGB17

!     Originally by J.Delamere, Atmospheric & Environmental Research.
!     Revision: 2.4
!     BAND 17:  3250-4000 cm-1 (low - H2O,CO2; high - H2O, CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOESRTA17, ONLY : KA, KB, SELFREF, FORREF, SFLUXREF, RAYL, STRRAT &
 & , LAYREFFR  

!     ------------------------------------------------------------------

IMPLICIT NONE

! KURUCZ
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2
CALL PART3
CALL PART4
CALL PART5
CALL PART6
CALL PART7
CALL PART8
CALL PART9
CALL PART10
CALL PART11
CALL PART12
CALL PART13
CALL PART14
CALL PART15
CALL PART16
CALL PART17
CALL PART18
CALL PART19
CALL PART20
CALL PART21
CALL PART22
CALL PART23
CALL PART24
CALL PART25
CALL PART26
CALL PART27
CALL PART28
CALL PART29
CALL PART30
CALL PART31
CALL PART32
CALL PART33
CALL PART34
CALL PART35
CALL PART36
CALL PART37
CALL PART38

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17',1,ZHOOK_HANDLE)

!     -----------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART1',0,ZHOOK_HANDLE)


SFLUXREF(:,1) = (/ &
 & 3.15613_JPRB  ,  3.03449_JPRB  ,  2.92069_JPRB  ,  2.63874_JPRB   , &
 & 2.34581_JPRB  ,  2.06999_JPRB  ,  1.70906_JPRB  ,  1.29085_JPRB   , &
 & 0.874851_JPRB ,  0.0955392_JPRB,  0.0787813_JPRB,  0.0621951_JPRB , &
 & 0.0459076_JPRB,  0.0294129_JPRB,  0.0110387_JPRB,  0.00159668_JPRB /)  
  
SFLUXREF(:,2) = (/ &
 & 2.83147_JPRB  ,  2.95919_JPRB  ,  2.96674_JPRB  ,  2.77677_JPRB   , &
 & 2.46826_JPRB  ,  2.11481_JPRB  ,  1.73243_JPRB  ,  1.30279_JPRB   , &
 & 0.882714_JPRB ,  0.0962350_JPRB,  0.0802122_JPRB,  0.0636194_JPRB , &
 & 0.0472620_JPRB,  0.0299051_JPRB,  0.0110785_JPRB,  0.00159668_JPRB /)  
  
SFLUXREF(:,3) = (/ &
 & 2.82300_JPRB  ,  2.94845_JPRB  ,  2.95887_JPRB  ,  2.77593_JPRB   , &
 & 2.47096_JPRB  ,  2.12596_JPRB  ,  1.73847_JPRB  ,  1.30796_JPRB   , &
 & 0.884395_JPRB ,  0.0966936_JPRB,  0.0801996_JPRB,  0.0640199_JPRB , &
 & 0.0472803_JPRB,  0.0300515_JPRB,  0.0112366_JPRB,  0.00160814_JPRB /)  
  
SFLUXREF(:,4) = (/ &
 & 2.81715_JPRB  ,  2.93789_JPRB  ,  2.95091_JPRB  ,  2.77046_JPRB   , &
 & 2.47716_JPRB  ,  2.13591_JPRB  ,  1.74365_JPRB  ,  1.31277_JPRB   , &
 & 0.887443_JPRB ,  0.0967016_JPRB,  0.0803391_JPRB,  0.0642442_JPRB , &
 & 0.0472909_JPRB,  0.0300720_JPRB,  0.0114817_JPRB,  0.00161875_JPRB /)  
  
SFLUXREF(:,5) = (/ &
 & 2.82335_JPRB  ,  2.93168_JPRB  ,  2.91455_JPRB  ,  2.75213_JPRB   , &
 & 2.49168_JPRB  ,  2.14408_JPRB  ,  1.75726_JPRB  ,  1.32401_JPRB   , &
 & 0.893644_JPRB ,  0.0969523_JPRB,  0.0805197_JPRB,  0.0639936_JPRB , &
 & 0.0475099_JPRB,  0.0305667_JPRB,  0.0115372_JPRB,  0.00161875_JPRB /)  
     
!     Rayleigh extinction coefficient at v = 3625 cm-1.
RAYL = 6.86E-10_JPRB

STRRAT = 0.364641_JPRB

LAYREFFR = 30

!     ------------------------------------------------------------------

!     The array KA contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KA(:, 1, 1, 1) = (/ &
 & 0.11134E-05_JPRB,0.32092E-03_JPRB,0.55663E-03_JPRB,0.78227E-03_JPRB,0.99421E-03_JPRB, &
 & 0.12045E-02_JPRB,0.14116E-02_JPRB,0.16069E-02_JPRB,0.19330E-02_JPRB /)  
KA(:, 2, 1, 1) = (/ &
 & 0.10544E-05_JPRB,0.35434E-03_JPRB,0.61480E-03_JPRB,0.86424E-03_JPRB,0.11055E-02_JPRB, &
 & 0.13431E-02_JPRB,0.15754E-02_JPRB,0.17951E-02_JPRB,0.21280E-02_JPRB /)  
KA(:, 3, 1, 1) = (/ &
 & 0.98345E-06_JPRB,0.38989E-03_JPRB,0.67747E-03_JPRB,0.95289E-03_JPRB,0.12196E-02_JPRB, &
 & 0.14864E-02_JPRB,0.17449E-02_JPRB,0.19897E-02_JPRB,0.23564E-02_JPRB /)  
KA(:, 4, 1, 1) = (/ &
 & 0.95017E-06_JPRB,0.42582E-03_JPRB,0.74419E-03_JPRB,0.10463E-02_JPRB,0.13424E-02_JPRB, &
 & 0.16353E-02_JPRB,0.19215E-02_JPRB,0.21939E-02_JPRB,0.25993E-02_JPRB /)  
KA(:, 5, 1, 1) = (/ &
 & 0.91870E-06_JPRB,0.46371E-03_JPRB,0.81394E-03_JPRB,0.11464E-02_JPRB,0.14715E-02_JPRB, &
 & 0.17937E-02_JPRB,0.21072E-02_JPRB,0.24077E-02_JPRB,0.28540E-02_JPRB /)  
KA(:, 1, 2, 1) = (/ &
 & 0.94184E-06_JPRB,0.26532E-03_JPRB,0.46157E-03_JPRB,0.63776E-03_JPRB,0.81087E-03_JPRB, &
 & 0.97728E-03_JPRB,0.11419E-02_JPRB,0.12991E-02_JPRB,0.15121E-02_JPRB /)  
KA(:, 2, 2, 1) = (/ &
 & 0.89060E-06_JPRB,0.29417E-03_JPRB,0.50967E-03_JPRB,0.70759E-03_JPRB,0.90203E-03_JPRB, &
 & 0.10920E-02_JPRB,0.12764E-02_JPRB,0.14544E-02_JPRB,0.16795E-02_JPRB /)  
KA(:, 3, 2, 1) = (/ &
 & 0.82720E-06_JPRB,0.32361E-03_JPRB,0.56124E-03_JPRB,0.78299E-03_JPRB,0.99718E-03_JPRB, &
 & 0.12094E-02_JPRB,0.14172E-02_JPRB,0.16165E-02_JPRB,0.18637E-02_JPRB /)  
KA(:, 4, 2, 1) = (/ &
 & 0.78842E-06_JPRB,0.35495E-03_JPRB,0.61684E-03_JPRB,0.86176E-03_JPRB,0.10995E-02_JPRB, &
 & 0.13345E-02_JPRB,0.15652E-02_JPRB,0.17856E-02_JPRB,0.20621E-02_JPRB /)  
KA(:, 5, 2, 1) = (/ &
 & 0.76610E-06_JPRB,0.38728E-03_JPRB,0.67538E-03_JPRB,0.94613E-03_JPRB,0.12082E-02_JPRB, &
 & 0.14675E-02_JPRB,0.17206E-02_JPRB,0.19640E-02_JPRB,0.22720E-02_JPRB /)  
KA(:, 1, 3, 1) = (/ &
 & 0.79663E-06_JPRB,0.21369E-03_JPRB,0.37088E-03_JPRB,0.51222E-03_JPRB,0.64549E-03_JPRB, &
 & 0.77322E-03_JPRB,0.89939E-03_JPRB,0.10205E-02_JPRB,0.11568E-02_JPRB /)  
KA(:, 2, 3, 1) = (/ &
 & 0.75955E-06_JPRB,0.23780E-03_JPRB,0.41153E-03_JPRB,0.56901E-03_JPRB,0.72009E-03_JPRB, &
 & 0.86735E-03_JPRB,0.10092E-02_JPRB,0.11476E-02_JPRB,0.12913E-02_JPRB /)  
KA(:, 3, 3, 1) = (/ &
 & 0.71692E-06_JPRB,0.26276E-03_JPRB,0.45488E-03_JPRB,0.62922E-03_JPRB,0.79836E-03_JPRB, &
 & 0.96259E-03_JPRB,0.11236E-02_JPRB,0.12796E-02_JPRB,0.14398E-02_JPRB /)  
KA(:, 4, 3, 1) = (/ &
 & 0.66348E-06_JPRB,0.28896E-03_JPRB,0.50221E-03_JPRB,0.69411E-03_JPRB,0.88226E-03_JPRB, &
 & 0.10658E-02_JPRB,0.12456E-02_JPRB,0.14191E-02_JPRB,0.15991E-02_JPRB /)  
KA(:, 5, 3, 1) = (/ &
 & 0.64013E-06_JPRB,0.31643E-03_JPRB,0.55166E-03_JPRB,0.76434E-03_JPRB,0.97216E-03_JPRB, &
 & 0.11745E-02_JPRB,0.13731E-02_JPRB,0.15657E-02_JPRB,0.17671E-02_JPRB /)  
KA(:, 1, 4, 1) = (/ &
 & 0.66217E-06_JPRB,0.16966E-03_JPRB,0.29358E-03_JPRB,0.40688E-03_JPRB,0.51114E-03_JPRB, &
 & 0.60739E-03_JPRB,0.70191E-03_JPRB,0.79446E-03_JPRB,0.88832E-03_JPRB /)  
KA(:, 2, 4, 1) = (/ &
 & 0.64111E-06_JPRB,0.18902E-03_JPRB,0.32742E-03_JPRB,0.45364E-03_JPRB,0.57086E-03_JPRB, &
 & 0.68401E-03_JPRB,0.79116E-03_JPRB,0.89507E-03_JPRB,0.99655E-03_JPRB /)  
KA(:, 3, 4, 1) = (/ &
 & 0.60729E-06_JPRB,0.21007E-03_JPRB,0.36354E-03_JPRB,0.50354E-03_JPRB,0.63459E-03_JPRB, &
 & 0.76113E-03_JPRB,0.88473E-03_JPRB,0.10035E-02_JPRB,0.11163E-02_JPRB /)  
KA(:, 4, 4, 1) = (/ &
 & 0.57250E-06_JPRB,0.23203E-03_JPRB,0.40245E-03_JPRB,0.55758E-03_JPRB,0.70295E-03_JPRB, &
 & 0.84515E-03_JPRB,0.98379E-03_JPRB,0.11165E-02_JPRB,0.12444E-02_JPRB /)  
KA(:, 5, 4, 1) = (/ &
 & 0.53524E-06_JPRB,0.25529E-03_JPRB,0.44399E-03_JPRB,0.61564E-03_JPRB,0.77626E-03_JPRB, &
 & 0.93405E-03_JPRB,0.10892E-02_JPRB,0.12369E-02_JPRB,0.13795E-02_JPRB /)  
KA(:, 1, 5, 1) = (/ &
 & 0.55112E-06_JPRB,0.13422E-03_JPRB,0.23166E-03_JPRB,0.32119E-03_JPRB,0.40265E-03_JPRB, &
 & 0.47812E-03_JPRB,0.54797E-03_JPRB,0.61873E-03_JPRB,0.68912E-03_JPRB /)  
KA(:, 2, 5, 1) = (/ &
 & 0.53669E-06_JPRB,0.14990E-03_JPRB,0.25949E-03_JPRB,0.35886E-03_JPRB,0.45239E-03_JPRB, &
 & 0.53936E-03_JPRB,0.61894E-03_JPRB,0.69718E-03_JPRB,0.77732E-03_JPRB /)  
KA(:, 3, 5, 1) = (/ &
 & 0.51495E-06_JPRB,0.16706E-03_JPRB,0.28960E-03_JPRB,0.40020E-03_JPRB,0.50461E-03_JPRB, &
 & 0.60249E-03_JPRB,0.69677E-03_JPRB,0.78464E-03_JPRB,0.87334E-03_JPRB /)  
KA(:, 4, 5, 1) = (/ &
 & 0.48633E-06_JPRB,0.18543E-03_JPRB,0.32159E-03_JPRB,0.44499E-03_JPRB,0.56095E-03_JPRB, &
 & 0.67055E-03_JPRB,0.77575E-03_JPRB,0.87717E-03_JPRB,0.97694E-03_JPRB /)  
KA(:, 5, 5, 1) = (/ &
 & 0.45162E-06_JPRB,0.20472E-03_JPRB,0.35591E-03_JPRB,0.49350E-03_JPRB,0.62163E-03_JPRB, &
 & 0.74253E-03_JPRB,0.86247E-03_JPRB,0.97518E-03_JPRB,0.10864E-02_JPRB /)  
KA(:, 1, 6, 1) = (/ &
 & 0.45055E-06_JPRB,0.10556E-03_JPRB,0.18176E-03_JPRB,0.25137E-03_JPRB,0.31438E-03_JPRB, &
 & 0.37363E-03_JPRB,0.42759E-03_JPRB,0.47883E-03_JPRB,0.53437E-03_JPRB /)  
KA(:, 2, 6, 1) = (/ &
 & 0.44502E-06_JPRB,0.11814E-03_JPRB,0.20383E-03_JPRB,0.28162E-03_JPRB,0.35547E-03_JPRB, &
 & 0.42261E-03_JPRB,0.48340E-03_JPRB,0.54066E-03_JPRB,0.60352E-03_JPRB /)  
KA(:, 3, 6, 1) = (/ &
 & 0.43066E-06_JPRB,0.13217E-03_JPRB,0.22836E-03_JPRB,0.31552E-03_JPRB,0.39762E-03_JPRB, &
 & 0.47493E-03_JPRB,0.54543E-03_JPRB,0.61066E-03_JPRB,0.68176E-03_JPRB /)  
KA(:, 4, 6, 1) = (/ &
 & 0.41116E-06_JPRB,0.14733E-03_JPRB,0.25472E-03_JPRB,0.35204E-03_JPRB,0.44334E-03_JPRB, &
 & 0.52997E-03_JPRB,0.60966E-03_JPRB,0.68622E-03_JPRB,0.76607E-03_JPRB /)  
KA(:, 5, 6, 1) = (/ &
 & 0.38748E-06_JPRB,0.16344E-03_JPRB,0.28281E-03_JPRB,0.39173E-03_JPRB,0.49305E-03_JPRB, &
 & 0.58880E-03_JPRB,0.67954E-03_JPRB,0.76485E-03_JPRB,0.85401E-03_JPRB /)  
KA(:, 1, 7, 1) = (/ &
 & 0.36582E-06_JPRB,0.82958E-04_JPRB,0.14210E-03_JPRB,0.19574E-03_JPRB,0.24440E-03_JPRB, &
 & 0.29039E-03_JPRB,0.33281E-03_JPRB,0.37177E-03_JPRB,0.42178E-03_JPRB /)  
KA(:, 2, 7, 1) = (/ &
 & 0.36707E-06_JPRB,0.92909E-04_JPRB,0.15977E-03_JPRB,0.22034E-03_JPRB,0.27742E-03_JPRB, &
 & 0.32955E-03_JPRB,0.37727E-03_JPRB,0.41956E-03_JPRB,0.47859E-03_JPRB /)  
KA(:, 3, 7, 1) = (/ &
 & 0.35787E-06_JPRB,0.10432E-03_JPRB,0.17930E-03_JPRB,0.24769E-03_JPRB,0.31155E-03_JPRB, &
 & 0.37242E-03_JPRB,0.42699E-03_JPRB,0.47474E-03_JPRB,0.54083E-03_JPRB /)  
KA(:, 4, 7, 1) = (/ &
 & 0.34482E-06_JPRB,0.11685E-03_JPRB,0.20055E-03_JPRB,0.27725E-03_JPRB,0.34866E-03_JPRB, &
 & 0.41677E-03_JPRB,0.47903E-03_JPRB,0.53518E-03_JPRB,0.60812E-03_JPRB /)  
KA(:, 5, 7, 1) = (/ &
 & 0.32598E-06_JPRB,0.13001E-03_JPRB,0.22341E-03_JPRB,0.30900E-03_JPRB,0.38919E-03_JPRB, &
 & 0.46465E-03_JPRB,0.53467E-03_JPRB,0.59926E-03_JPRB,0.67733E-03_JPRB /)  
KA(:, 1, 8, 1) = (/ &
 & 0.29834E-06_JPRB,0.65009E-04_JPRB,0.11183E-03_JPRB,0.15200E-03_JPRB,0.18969E-03_JPRB, &
 & 0.22517E-03_JPRB,0.25832E-03_JPRB,0.28730E-03_JPRB,0.33955E-03_JPRB /)  
KA(:, 2, 8, 1) = (/ &
 & 0.29745E-06_JPRB,0.72872E-04_JPRB,0.12482E-03_JPRB,0.17221E-03_JPRB,0.21583E-03_JPRB, &
 & 0.25596E-03_JPRB,0.29328E-03_JPRB,0.32520E-03_JPRB,0.38620E-03_JPRB /)  
KA(:, 3, 8, 1) = (/ &
 & 0.29421E-06_JPRB,0.82036E-04_JPRB,0.14010E-03_JPRB,0.19344E-03_JPRB,0.24362E-03_JPRB, &
 & 0.29071E-03_JPRB,0.33308E-03_JPRB,0.36867E-03_JPRB,0.43901E-03_JPRB /)  
KA(:, 4, 8, 1) = (/ &
 & 0.28596E-06_JPRB,0.92256E-04_JPRB,0.15738E-03_JPRB,0.21752E-03_JPRB,0.27325E-03_JPRB, &
 & 0.32643E-03_JPRB,0.37578E-03_JPRB,0.41710E-03_JPRB,0.49358E-03_JPRB /)  
KA(:, 5, 8, 1) = (/ &
 & 0.27296E-06_JPRB,0.10320E-03_JPRB,0.17598E-03_JPRB,0.24339E-03_JPRB,0.30591E-03_JPRB, &
 & 0.36505E-03_JPRB,0.42061E-03_JPRB,0.46872E-03_JPRB,0.54993E-03_JPRB /)  
KA(:, 1, 9, 1) = (/ &
 & 0.24259E-06_JPRB,0.50626E-04_JPRB,0.86945E-04_JPRB,0.11778E-03_JPRB,0.14692E-03_JPRB, &
 & 0.17431E-03_JPRB,0.20057E-03_JPRB,0.22131E-03_JPRB,0.29919E-03_JPRB /)  
KA(:, 2, 9, 1) = (/ &
 & 0.24058E-06_JPRB,0.56966E-04_JPRB,0.97467E-04_JPRB,0.13405E-03_JPRB,0.16750E-03_JPRB, &
 & 0.19814E-03_JPRB,0.22739E-03_JPRB,0.25281E-03_JPRB,0.34022E-03_JPRB /)  
KA(:, 3, 9, 1) = (/ &
 & 0.24091E-06_JPRB,0.64324E-04_JPRB,0.10971E-03_JPRB,0.15061E-03_JPRB,0.18996E-03_JPRB, &
 & 0.22580E-03_JPRB,0.25885E-03_JPRB,0.28694E-03_JPRB,0.38045E-03_JPRB /)  
KA(:, 4, 9, 1) = (/ &
 & 0.23550E-06_JPRB,0.72451E-04_JPRB,0.12345E-03_JPRB,0.16991E-03_JPRB,0.21362E-03_JPRB, &
 & 0.25484E-03_JPRB,0.29341E-03_JPRB,0.32523E-03_JPRB,0.42836E-03_JPRB /)  
KA(:, 5, 9, 1) = (/ &
 & 0.22696E-06_JPRB,0.81351E-04_JPRB,0.13839E-03_JPRB,0.19090E-03_JPRB,0.23986E-03_JPRB, &
 & 0.28608E-03_JPRB,0.32910E-03_JPRB,0.36639E-03_JPRB,0.47925E-03_JPRB /)  
KA(:, 1,10, 1) = (/ &
 & 0.19679E-06_JPRB,0.39760E-04_JPRB,0.68052E-04_JPRB,0.92295E-04_JPRB,0.11498E-03_JPRB, &
 & 0.13656E-03_JPRB,0.15604E-03_JPRB,0.17171E-03_JPRB,0.29679E-03_JPRB /)  
KA(:, 2,10, 1) = (/ &
 & 0.19567E-06_JPRB,0.44847E-04_JPRB,0.76829E-04_JPRB,0.10518E-03_JPRB,0.13102E-03_JPRB, &
 & 0.15509E-03_JPRB,0.17764E-03_JPRB,0.19843E-03_JPRB,0.32863E-03_JPRB /)  
KA(:, 3,10, 1) = (/ &
 & 0.19574E-06_JPRB,0.50565E-04_JPRB,0.86466E-04_JPRB,0.11878E-03_JPRB,0.14920E-03_JPRB, &
 & 0.17698E-03_JPRB,0.20258E-03_JPRB,0.22526E-03_JPRB,0.36959E-03_JPRB /)  
KA(:, 4,10, 1) = (/ &
 & 0.19262E-06_JPRB,0.57124E-04_JPRB,0.97546E-04_JPRB,0.13398E-03_JPRB,0.16803E-03_JPRB, &
 & 0.20046E-03_JPRB,0.23022E-03_JPRB,0.25578E-03_JPRB,0.41543E-03_JPRB /)  
KA(:, 5,10, 1) = (/ &
 & 0.18747E-06_JPRB,0.64264E-04_JPRB,0.10971E-03_JPRB,0.15086E-03_JPRB,0.18923E-03_JPRB, &
 & 0.22565E-03_JPRB,0.25934E-03_JPRB,0.28921E-03_JPRB,0.46463E-03_JPRB /)  
KA(:, 1,11, 1) = (/ &
 & 0.16015E-06_JPRB,0.33025E-04_JPRB,0.56562E-04_JPRB,0.76625E-04_JPRB,0.95645E-04_JPRB, &
 & 0.11358E-03_JPRB,0.12955E-03_JPRB,0.14269E-03_JPRB,0.27545E-03_JPRB /)  
KA(:, 2,11, 1) = (/ &
 & 0.15918E-06_JPRB,0.37148E-04_JPRB,0.63775E-04_JPRB,0.87600E-04_JPRB,0.10897E-03_JPRB, &
 & 0.12893E-03_JPRB,0.14756E-03_JPRB,0.16465E-03_JPRB,0.30799E-03_JPRB /)  
KA(:, 3,11, 1) = (/ &
 & 0.15897E-06_JPRB,0.41993E-04_JPRB,0.72040E-04_JPRB,0.98928E-04_JPRB,0.12433E-03_JPRB, &
 & 0.14733E-03_JPRB,0.16824E-03_JPRB,0.18694E-03_JPRB,0.34340E-03_JPRB /)  
KA(:, 4,11, 1) = (/ &
 & 0.15578E-06_JPRB,0.47441E-04_JPRB,0.81426E-04_JPRB,0.11165E-03_JPRB,0.13985E-03_JPRB, &
 & 0.16673E-03_JPRB,0.19156E-03_JPRB,0.21268E-03_JPRB,0.38176E-03_JPRB /)  
KA(:, 5,11, 1) = (/ &
 & 0.15210E-06_JPRB,0.53398E-04_JPRB,0.91657E-04_JPRB,0.12592E-03_JPRB,0.15769E-03_JPRB, &
 & 0.18781E-03_JPRB,0.21569E-03_JPRB,0.24069E-03_JPRB,0.42228E-03_JPRB /)  
KA(:, 1,12, 1) = (/ &
 & 0.13021E-06_JPRB,0.27272E-04_JPRB,0.46832E-04_JPRB,0.63511E-04_JPRB,0.79205E-04_JPRB, &
 & 0.93949E-04_JPRB,0.10719E-03_JPRB,0.11827E-03_JPRB,0.23944E-03_JPRB /)  
KA(:, 2,12, 1) = (/ &
 & 0.12930E-06_JPRB,0.30686E-04_JPRB,0.52925E-04_JPRB,0.72782E-04_JPRB,0.90527E-04_JPRB, &
 & 0.10708E-03_JPRB,0.12236E-03_JPRB,0.13620E-03_JPRB,0.27121E-03_JPRB /)  
KA(:, 3,12, 1) = (/ &
 & 0.12900E-06_JPRB,0.34723E-04_JPRB,0.59867E-04_JPRB,0.82205E-04_JPRB,0.10326E-03_JPRB, &
 & 0.12238E-03_JPRB,0.13958E-03_JPRB,0.15498E-03_JPRB,0.29930E-03_JPRB /)  
KA(:, 4,12, 1) = (/ &
 & 0.12648E-06_JPRB,0.39252E-04_JPRB,0.67618E-04_JPRB,0.92949E-04_JPRB,0.11636E-03_JPRB, &
 & 0.13835E-03_JPRB,0.15924E-03_JPRB,0.17653E-03_JPRB,0.33050E-03_JPRB /)  
KA(:, 5,12, 1) = (/ &
 & 0.12299E-06_JPRB,0.44213E-04_JPRB,0.76244E-04_JPRB,0.10488E-03_JPRB,0.13135E-03_JPRB, &
 & 0.15601E-03_JPRB,0.17902E-03_JPRB,0.19976E-03_JPRB,0.36579E-03_JPRB /)  
KA(:, 1,13, 1) = (/ &
 & 0.10554E-06_JPRB,0.22388E-04_JPRB,0.38597E-04_JPRB,0.52378E-04_JPRB,0.65404E-04_JPRB, &
 & 0.77567E-04_JPRB,0.88543E-04_JPRB,0.97801E-04_JPRB,0.19599E-03_JPRB /)  
KA(:, 2,13, 1) = (/ &
 & 0.10480E-06_JPRB,0.25181E-04_JPRB,0.43670E-04_JPRB,0.60205E-04_JPRB,0.74883E-04_JPRB, &
 & 0.88605E-04_JPRB,0.10117E-03_JPRB,0.11242E-03_JPRB,0.22146E-03_JPRB /)  
KA(:, 3,13, 1) = (/ &
 & 0.10429E-06_JPRB,0.28530E-04_JPRB,0.49422E-04_JPRB,0.68039E-04_JPRB,0.85435E-04_JPRB, &
 & 0.10136E-03_JPRB,0.11557E-03_JPRB,0.12828E-03_JPRB,0.24447E-03_JPRB /)  
KA(:, 4,13, 1) = (/ &
 & 0.10232E-06_JPRB,0.32301E-04_JPRB,0.55797E-04_JPRB,0.76948E-04_JPRB,0.96447E-04_JPRB, &
 & 0.11462E-03_JPRB,0.13166E-03_JPRB,0.14616E-03_JPRB,0.26999E-03_JPRB /)  
KA(:, 5,13, 1) = (/ &
 & 0.99014E-07_JPRB,0.36394E-04_JPRB,0.62994E-04_JPRB,0.86946E-04_JPRB,0.10900E-03_JPRB, &
 & 0.12937E-03_JPRB,0.14833E-03_JPRB,0.16540E-03_JPRB,0.29916E-03_JPRB /)  
KA(:, 1, 1, 2) = (/ &
 & 0.23488E-04_JPRB,0.16684E-02_JPRB,0.29575E-02_JPRB,0.40083E-02_JPRB,0.49953E-02_JPRB, &
 & 0.59021E-02_JPRB,0.67446E-02_JPRB,0.76008E-02_JPRB,0.87032E-02_JPRB /)  
KA(:, 2, 1, 2) = (/ &
 & 0.25156E-04_JPRB,0.18462E-02_JPRB,0.32711E-02_JPRB,0.45008E-02_JPRB,0.56182E-02_JPRB, &
 & 0.66287E-02_JPRB,0.75909E-02_JPRB,0.85558E-02_JPRB,0.97543E-02_JPRB /)  
KA(:, 3, 1, 2) = (/ &
 & 0.27084E-04_JPRB,0.20325E-02_JPRB,0.36034E-02_JPRB,0.49992E-02_JPRB,0.62796E-02_JPRB, &
 & 0.74134E-02_JPRB,0.84994E-02_JPRB,0.95694E-02_JPRB,0.10847E-01_JPRB /)  
KA(:, 4, 1, 2) = (/ &
 & 0.28147E-04_JPRB,0.22347E-02_JPRB,0.39628E-02_JPRB,0.55005E-02_JPRB,0.69453E-02_JPRB, &
 & 0.82429E-02_JPRB,0.94699E-02_JPRB,0.10660E-01_JPRB,0.11991E-01_JPRB /)  
KA(:, 5, 1, 2) = (/ &
 & 0.28719E-04_JPRB,0.24475E-02_JPRB,0.43369E-02_JPRB,0.60360E-02_JPRB,0.76183E-02_JPRB, &
 & 0.90878E-02_JPRB,0.10493E-01_JPRB,0.11805E-01_JPRB,0.13204E-01_JPRB /)  
KA(:, 1, 2, 2) = (/ &
 & 0.20947E-04_JPRB,0.14015E-02_JPRB,0.24728E-02_JPRB,0.33676E-02_JPRB,0.41801E-02_JPRB, &
 & 0.49244E-02_JPRB,0.55787E-02_JPRB,0.62206E-02_JPRB,0.69741E-02_JPRB /)  
KA(:, 2, 2, 2) = (/ &
 & 0.22352E-04_JPRB,0.15535E-02_JPRB,0.27396E-02_JPRB,0.37870E-02_JPRB,0.47121E-02_JPRB, &
 & 0.55571E-02_JPRB,0.62892E-02_JPRB,0.70132E-02_JPRB,0.78092E-02_JPRB /)  
KA(:, 3, 2, 2) = (/ &
 & 0.23882E-04_JPRB,0.17213E-02_JPRB,0.30345E-02_JPRB,0.42020E-02_JPRB,0.52782E-02_JPRB, &
 & 0.62285E-02_JPRB,0.70556E-02_JPRB,0.78819E-02_JPRB,0.87330E-02_JPRB /)  
KA(:, 4, 2, 2) = (/ &
 & 0.24650E-04_JPRB,0.18954E-02_JPRB,0.33384E-02_JPRB,0.46336E-02_JPRB,0.58333E-02_JPRB, &
 & 0.69311E-02_JPRB,0.78751E-02_JPRB,0.88149E-02_JPRB,0.96911E-02_JPRB /)  
KA(:, 5, 2, 2) = (/ &
 & 0.25136E-04_JPRB,0.20806E-02_JPRB,0.36641E-02_JPRB,0.50966E-02_JPRB,0.64193E-02_JPRB, &
 & 0.76281E-02_JPRB,0.87403E-02_JPRB,0.97943E-02_JPRB,0.10704E-01_JPRB /)  
KA(:, 1, 3, 2) = (/ &
 & 0.17720E-04_JPRB,0.11414E-02_JPRB,0.20045E-02_JPRB,0.27288E-02_JPRB,0.33891E-02_JPRB, &
 & 0.39755E-02_JPRB,0.44967E-02_JPRB,0.49389E-02_JPRB,0.53858E-02_JPRB /)  
KA(:, 2, 3, 2) = (/ &
 & 0.19087E-04_JPRB,0.12745E-02_JPRB,0.22336E-02_JPRB,0.30841E-02_JPRB,0.38333E-02_JPRB, &
 & 0.44983E-02_JPRB,0.50895E-02_JPRB,0.55930E-02_JPRB,0.60666E-02_JPRB /)  
KA(:, 3, 3, 2) = (/ &
 & 0.20125E-04_JPRB,0.14178E-02_JPRB,0.24795E-02_JPRB,0.34278E-02_JPRB,0.43106E-02_JPRB, &
 & 0.50607E-02_JPRB,0.57280E-02_JPRB,0.63092E-02_JPRB,0.68285E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART2',0,ZHOOK_HANDLE)


KA(:, 4, 3, 2) = (/ &
 & 0.20895E-04_JPRB,0.15666E-02_JPRB,0.27348E-02_JPRB,0.37934E-02_JPRB,0.47769E-02_JPRB, &
 & 0.56621E-02_JPRB,0.64046E-02_JPRB,0.70864E-02_JPRB,0.76026E-02_JPRB /)  
KA(:, 5, 3, 2) = (/ &
 & 0.21508E-04_JPRB,0.17251E-02_JPRB,0.30153E-02_JPRB,0.41809E-02_JPRB,0.52689E-02_JPRB, &
 & 0.62462E-02_JPRB,0.71125E-02_JPRB,0.79104E-02_JPRB,0.84389E-02_JPRB /)  
KA(:, 1, 4, 2) = (/ &
 & 0.14661E-04_JPRB,0.92261E-03_JPRB,0.16088E-02_JPRB,0.21788E-02_JPRB,0.26956E-02_JPRB, &
 & 0.31612E-02_JPRB,0.35626E-02_JPRB,0.38878E-02_JPRB,0.41525E-02_JPRB /)  
KA(:, 2, 4, 2) = (/ &
 & 0.15607E-04_JPRB,0.10329E-02_JPRB,0.17973E-02_JPRB,0.24735E-02_JPRB,0.30696E-02_JPRB, &
 & 0.35953E-02_JPRB,0.40511E-02_JPRB,0.44162E-02_JPRB,0.46990E-02_JPRB /)  
KA(:, 3, 4, 2) = (/ &
 & 0.16559E-04_JPRB,0.11550E-02_JPRB,0.20019E-02_JPRB,0.27577E-02_JPRB,0.34625E-02_JPRB, &
 & 0.40662E-02_JPRB,0.45831E-02_JPRB,0.49995E-02_JPRB,0.53073E-02_JPRB /)  
KA(:, 4, 4, 2) = (/ &
 & 0.17263E-04_JPRB,0.12794E-02_JPRB,0.22184E-02_JPRB,0.30614E-02_JPRB,0.38510E-02_JPRB, &
 & 0.45664E-02_JPRB,0.51532E-02_JPRB,0.56290E-02_JPRB,0.59436E-02_JPRB /)  
KA(:, 5, 4, 2) = (/ &
 & 0.17895E-04_JPRB,0.14130E-02_JPRB,0.24526E-02_JPRB,0.33805E-02_JPRB,0.42622E-02_JPRB, &
 & 0.50556E-02_JPRB,0.57489E-02_JPRB,0.63094E-02_JPRB,0.66256E-02_JPRB /)  
KA(:, 1, 5, 2) = (/ &
 & 0.11885E-04_JPRB,0.74888E-03_JPRB,0.12826E-02_JPRB,0.17258E-02_JPRB,0.21346E-02_JPRB, &
 & 0.24972E-02_JPRB,0.28046E-02_JPRB,0.30606E-02_JPRB,0.32323E-02_JPRB /)  
KA(:, 2, 5, 2) = (/ &
 & 0.12452E-04_JPRB,0.84084E-03_JPRB,0.14380E-02_JPRB,0.19698E-02_JPRB,0.24386E-02_JPRB, &
 & 0.28536E-02_JPRB,0.32075E-02_JPRB,0.34937E-02_JPRB,0.36562E-02_JPRB /)  
KA(:, 3, 5, 2) = (/ &
 & 0.13439E-04_JPRB,0.94272E-03_JPRB,0.16065E-02_JPRB,0.22079E-02_JPRB,0.27660E-02_JPRB, &
 & 0.32389E-02_JPRB,0.36440E-02_JPRB,0.39673E-02_JPRB,0.41393E-02_JPRB /)  
KA(:, 4, 5, 2) = (/ &
 & 0.14053E-04_JPRB,0.10473E-02_JPRB,0.17899E-02_JPRB,0.24603E-02_JPRB,0.30861E-02_JPRB, &
 & 0.36521E-02_JPRB,0.41156E-02_JPRB,0.44825E-02_JPRB,0.46529E-02_JPRB /)  
KA(:, 5, 5, 2) = (/ &
 & 0.14586E-04_JPRB,0.11585E-02_JPRB,0.19886E-02_JPRB,0.27257E-02_JPRB,0.34272E-02_JPRB, &
 & 0.40599E-02_JPRB,0.46115E-02_JPRB,0.50286E-02_JPRB,0.52085E-02_JPRB /)  
KA(:, 1, 6, 2) = (/ &
 & 0.94872E-05_JPRB,0.59793E-03_JPRB,0.10210E-02_JPRB,0.13572E-02_JPRB,0.16716E-02_JPRB, &
 & 0.19512E-02_JPRB,0.21890E-02_JPRB,0.23827E-02_JPRB,0.25347E-02_JPRB /)  
KA(:, 2, 6, 2) = (/ &
 & 0.10060E-04_JPRB,0.67400E-03_JPRB,0.11432E-02_JPRB,0.15564E-02_JPRB,0.19188E-02_JPRB, &
 & 0.22389E-02_JPRB,0.25161E-02_JPRB,0.27308E-02_JPRB,0.28770E-02_JPRB /)  
KA(:, 3, 6, 2) = (/ &
 & 0.10743E-04_JPRB,0.75948E-03_JPRB,0.12806E-02_JPRB,0.17551E-02_JPRB,0.21862E-02_JPRB, &
 & 0.25545E-02_JPRB,0.28729E-02_JPRB,0.31149E-02_JPRB,0.32716E-02_JPRB /)  
KA(:, 4, 6, 2) = (/ &
 & 0.11322E-04_JPRB,0.85134E-03_JPRB,0.14320E-02_JPRB,0.19630E-02_JPRB,0.24514E-02_JPRB, &
 & 0.28930E-02_JPRB,0.32578E-02_JPRB,0.35375E-02_JPRB,0.36912E-02_JPRB /)  
KA(:, 5, 6, 2) = (/ &
 & 0.11755E-04_JPRB,0.94611E-03_JPRB,0.15986E-02_JPRB,0.21804E-02_JPRB,0.27291E-02_JPRB, &
 & 0.32306E-02_JPRB,0.36695E-02_JPRB,0.39913E-02_JPRB,0.41439E-02_JPRB /)  
KA(:, 1, 7, 2) = (/ &
 & 0.75931E-05_JPRB,0.47130E-03_JPRB,0.81211E-03_JPRB,0.10658E-02_JPRB,0.13004E-02_JPRB, &
 & 0.15175E-02_JPRB,0.17002E-02_JPRB,0.18473E-02_JPRB,0.19861E-02_JPRB /)  
KA(:, 2, 7, 2) = (/ &
 & 0.80724E-05_JPRB,0.53358E-03_JPRB,0.91163E-03_JPRB,0.12261E-02_JPRB,0.15014E-02_JPRB, &
 & 0.17483E-02_JPRB,0.19612E-02_JPRB,0.21201E-02_JPRB,0.22591E-02_JPRB /)  
KA(:, 3, 7, 2) = (/ &
 & 0.84404E-05_JPRB,0.60517E-03_JPRB,0.10236E-02_JPRB,0.13887E-02_JPRB,0.17204E-02_JPRB, &
 & 0.20031E-02_JPRB,0.22497E-02_JPRB,0.24321E-02_JPRB,0.25823E-02_JPRB /)  
KA(:, 4, 7, 2) = (/ &
 & 0.90511E-05_JPRB,0.68037E-03_JPRB,0.11475E-02_JPRB,0.15596E-02_JPRB,0.19402E-02_JPRB, &
 & 0.22789E-02_JPRB,0.25633E-02_JPRB,0.27753E-02_JPRB,0.29247E-02_JPRB /)  
KA(:, 5, 7, 2) = (/ &
 & 0.94405E-05_JPRB,0.76103E-03_JPRB,0.12836E-02_JPRB,0.17422E-02_JPRB,0.21698E-02_JPRB, &
 & 0.25585E-02_JPRB,0.28989E-02_JPRB,0.31444E-02_JPRB,0.33016E-02_JPRB /)  
KA(:, 1, 8, 2) = (/ &
 & 0.58080E-05_JPRB,0.36782E-03_JPRB,0.63516E-03_JPRB,0.83799E-03_JPRB,0.10119E-02_JPRB, &
 & 0.11754E-02_JPRB,0.13161E-02_JPRB,0.14382E-02_JPRB,0.15837E-02_JPRB /)  
KA(:, 2, 8, 2) = (/ &
 & 0.63156E-05_JPRB,0.41909E-03_JPRB,0.71974E-03_JPRB,0.96952E-03_JPRB,0.11711E-02_JPRB, &
 & 0.13617E-02_JPRB,0.15234E-02_JPRB,0.16441E-02_JPRB,0.18118E-02_JPRB /)  
KA(:, 3, 8, 2) = (/ &
 & 0.66776E-05_JPRB,0.47829E-03_JPRB,0.81150E-03_JPRB,0.11056E-02_JPRB,0.13493E-02_JPRB, &
 & 0.15646E-02_JPRB,0.17524E-02_JPRB,0.18937E-02_JPRB,0.20698E-02_JPRB /)  
KA(:, 4, 8, 2) = (/ &
 & 0.70582E-05_JPRB,0.54017E-03_JPRB,0.91330E-03_JPRB,0.12434E-02_JPRB,0.15411E-02_JPRB, &
 & 0.17884E-02_JPRB,0.20057E-02_JPRB,0.21704E-02_JPRB,0.23548E-02_JPRB /)  
KA(:, 5, 8, 2) = (/ &
 & 0.74902E-05_JPRB,0.60717E-03_JPRB,0.10267E-02_JPRB,0.13908E-02_JPRB,0.17231E-02_JPRB, &
 & 0.20285E-02_JPRB,0.22810E-02_JPRB,0.24710E-02_JPRB,0.26631E-02_JPRB /)  
KA(:, 1, 9, 2) = (/ &
 & 0.45061E-05_JPRB,0.28626E-03_JPRB,0.49448E-03_JPRB,0.65317E-03_JPRB,0.79081E-03_JPRB, &
 & 0.91066E-03_JPRB,0.10182E-02_JPRB,0.11107E-02_JPRB,0.14592E-02_JPRB /)  
KA(:, 2, 9, 2) = (/ &
 & 0.49392E-05_JPRB,0.32734E-03_JPRB,0.56558E-03_JPRB,0.76077E-03_JPRB,0.91846E-03_JPRB, &
 & 0.10578E-02_JPRB,0.11776E-02_JPRB,0.12720E-02_JPRB,0.16778E-02_JPRB /)  
KA(:, 3, 9, 2) = (/ &
 & 0.52580E-05_JPRB,0.37522E-03_JPRB,0.63845E-03_JPRB,0.87805E-03_JPRB,0.10619E-02_JPRB, &
 & 0.12194E-02_JPRB,0.13606E-02_JPRB,0.14680E-02_JPRB,0.19259E-02_JPRB /)  
KA(:, 4, 9, 2) = (/ &
 & 0.54991E-05_JPRB,0.42659E-03_JPRB,0.72103E-03_JPRB,0.98756E-03_JPRB,0.12163E-02_JPRB, &
 & 0.14007E-02_JPRB,0.15647E-02_JPRB,0.16900E-02_JPRB,0.21772E-02_JPRB /)  
KA(:, 5, 9, 2) = (/ &
 & 0.58769E-05_JPRB,0.48199E-03_JPRB,0.81466E-03_JPRB,0.11072E-02_JPRB,0.13684E-02_JPRB, &
 & 0.15984E-02_JPRB,0.17887E-02_JPRB,0.19333E-02_JPRB,0.24331E-02_JPRB /)  
KA(:, 1,10, 2) = (/ &
 & 0.34154E-05_JPRB,0.22534E-03_JPRB,0.38788E-03_JPRB,0.51113E-03_JPRB,0.62194E-03_JPRB, &
 & 0.71432E-03_JPRB,0.79743E-03_JPRB,0.86289E-03_JPRB,0.14758E-02_JPRB /)  
KA(:, 2,10, 2) = (/ &
 & 0.38085E-05_JPRB,0.25832E-03_JPRB,0.44748E-03_JPRB,0.59835E-03_JPRB,0.72514E-03_JPRB, &
 & 0.83284E-03_JPRB,0.91941E-03_JPRB,0.99583E-03_JPRB,0.17358E-02_JPRB /)  
KA(:, 3,10, 2) = (/ &
 & 0.41578E-05_JPRB,0.29655E-03_JPRB,0.50553E-03_JPRB,0.69511E-03_JPRB,0.84107E-03_JPRB, &
 & 0.96374E-03_JPRB,0.10666E-02_JPRB,0.11478E-02_JPRB,0.19625E-02_JPRB /)  
KA(:, 4,10, 2) = (/ &
 & 0.43917E-05_JPRB,0.33908E-03_JPRB,0.57351E-03_JPRB,0.78640E-03_JPRB,0.96862E-03_JPRB, &
 & 0.11109E-02_JPRB,0.12309E-02_JPRB,0.13266E-02_JPRB,0.22103E-02_JPRB /)  
KA(:, 5,10, 2) = (/ &
 & 0.45446E-05_JPRB,0.38548E-03_JPRB,0.64883E-03_JPRB,0.88401E-03_JPRB,0.10952E-02_JPRB, &
 & 0.12706E-02_JPRB,0.14136E-02_JPRB,0.15239E-02_JPRB,0.24754E-02_JPRB /)  
KA(:, 1,11, 2) = (/ &
 & 0.27604E-05_JPRB,0.18848E-03_JPRB,0.32532E-03_JPRB,0.42949E-03_JPRB,0.52350E-03_JPRB, &
 & 0.60084E-03_JPRB,0.66640E-03_JPRB,0.72070E-03_JPRB,0.13692E-02_JPRB /)  
KA(:, 2,11, 2) = (/ &
 & 0.30908E-05_JPRB,0.21679E-03_JPRB,0.37259E-03_JPRB,0.50366E-03_JPRB,0.61074E-03_JPRB, &
 & 0.70158E-03_JPRB,0.77271E-03_JPRB,0.83037E-03_JPRB,0.15689E-02_JPRB /)  
KA(:, 3,11, 2) = (/ &
 & 0.33674E-05_JPRB,0.24965E-03_JPRB,0.42244E-03_JPRB,0.58353E-03_JPRB,0.70923E-03_JPRB, &
 & 0.81330E-03_JPRB,0.89750E-03_JPRB,0.96131E-03_JPRB,0.17971E-02_JPRB /)  
KA(:, 4,11, 2) = (/ &
 & 0.35568E-05_JPRB,0.28602E-03_JPRB,0.48044E-03_JPRB,0.65868E-03_JPRB,0.81816E-03_JPRB, &
 & 0.93857E-03_JPRB,0.10357E-02_JPRB,0.11119E-02_JPRB,0.20509E-02_JPRB /)  
KA(:, 5,11, 2) = (/ &
 & 0.36921E-05_JPRB,0.32484E-03_JPRB,0.54623E-03_JPRB,0.74475E-03_JPRB,0.92307E-03_JPRB, &
 & 0.10758E-02_JPRB,0.11895E-02_JPRB,0.12777E-02_JPRB,0.23253E-02_JPRB /)  
KA(:, 1,12, 2) = (/ &
 & 0.22272E-05_JPRB,0.15807E-03_JPRB,0.27163E-03_JPRB,0.35935E-03_JPRB,0.43781E-03_JPRB, &
 & 0.50321E-03_JPRB,0.55776E-03_JPRB,0.60046E-03_JPRB,0.11852E-02_JPRB /)  
KA(:, 2,12, 2) = (/ &
 & 0.24898E-05_JPRB,0.18201E-03_JPRB,0.31004E-03_JPRB,0.42206E-03_JPRB,0.51226E-03_JPRB, &
 & 0.58824E-03_JPRB,0.64919E-03_JPRB,0.69291E-03_JPRB,0.13623E-02_JPRB /)  
KA(:, 3,12, 2) = (/ &
 & 0.27021E-05_JPRB,0.20958E-03_JPRB,0.35322E-03_JPRB,0.48676E-03_JPRB,0.59587E-03_JPRB, &
 & 0.68364E-03_JPRB,0.75527E-03_JPRB,0.80436E-03_JPRB,0.15654E-02_JPRB /)  
KA(:, 4,12, 2) = (/ &
 & 0.28526E-05_JPRB,0.24038E-03_JPRB,0.40262E-03_JPRB,0.55096E-03_JPRB,0.68671E-03_JPRB, &
 & 0.79103E-03_JPRB,0.87211E-03_JPRB,0.93124E-03_JPRB,0.17898E-02_JPRB /)  
KA(:, 5,12, 2) = (/ &
 & 0.29899E-05_JPRB,0.27289E-03_JPRB,0.45904E-03_JPRB,0.62448E-03_JPRB,0.77496E-03_JPRB, &
 & 0.90212E-03_JPRB,0.10018E-02_JPRB,0.10706E-02_JPRB,0.20265E-02_JPRB /)  
KA(:, 1,13, 2) = (/ &
 & 0.17576E-05_JPRB,0.13151E-03_JPRB,0.22518E-03_JPRB,0.29890E-03_JPRB,0.36398E-03_JPRB, &
 & 0.41884E-03_JPRB,0.46505E-03_JPRB,0.50086E-03_JPRB,0.97916E-03_JPRB /)  
KA(:, 2,13, 2) = (/ &
 & 0.19524E-05_JPRB,0.15189E-03_JPRB,0.25686E-03_JPRB,0.35123E-03_JPRB,0.42723E-03_JPRB, &
 & 0.49061E-03_JPRB,0.54293E-03_JPRB,0.57815E-03_JPRB,0.11260E-02_JPRB /)  
KA(:, 3,13, 2) = (/ &
 & 0.21134E-05_JPRB,0.17558E-03_JPRB,0.29382E-03_JPRB,0.40457E-03_JPRB,0.49777E-03_JPRB, &
 & 0.57153E-03_JPRB,0.63185E-03_JPRB,0.67213E-03_JPRB,0.12960E-02_JPRB /)  
KA(:, 4,13, 2) = (/ &
 & 0.22681E-05_JPRB,0.20106E-03_JPRB,0.33583E-03_JPRB,0.45977E-03_JPRB,0.57094E-03_JPRB, &
 & 0.66275E-03_JPRB,0.73149E-03_JPRB,0.77799E-03_JPRB,0.14856E-02_JPRB /)  
KA(:, 5,13, 2) = (/ &
 & 0.23940E-05_JPRB,0.22853E-03_JPRB,0.38323E-03_JPRB,0.52126E-03_JPRB,0.64684E-03_JPRB, &
 & 0.75455E-03_JPRB,0.84115E-03_JPRB,0.89575E-03_JPRB,0.16816E-02_JPRB /)  
KA(:, 1, 1, 3) = (/ &
 & 0.87154E-04_JPRB,0.70456E-02_JPRB,0.11624E-01_JPRB,0.16007E-01_JPRB,0.20277E-01_JPRB, &
 & 0.24349E-01_JPRB,0.27902E-01_JPRB,0.30956E-01_JPRB,0.33159E-01_JPRB /)  
KA(:, 2, 1, 3) = (/ &
 & 0.92678E-04_JPRB,0.75324E-02_JPRB,0.12552E-01_JPRB,0.17444E-01_JPRB,0.21967E-01_JPRB, &
 & 0.26250E-01_JPRB,0.30241E-01_JPRB,0.33348E-01_JPRB,0.36164E-01_JPRB /)  
KA(:, 3, 1, 3) = (/ &
 & 0.97955E-04_JPRB,0.80153E-02_JPRB,0.13502E-01_JPRB,0.18812E-01_JPRB,0.23862E-01_JPRB, &
 & 0.28480E-01_JPRB,0.32511E-01_JPRB,0.35713E-01_JPRB,0.38349E-01_JPRB /)  
KA(:, 4, 1, 3) = (/ &
 & 0.10404E-03_JPRB,0.84724E-02_JPRB,0.14429E-01_JPRB,0.20136E-01_JPRB,0.25672E-01_JPRB, &
 & 0.30688E-01_JPRB,0.35011E-01_JPRB,0.38379E-01_JPRB,0.40673E-01_JPRB /)  
KA(:, 5, 1, 3) = (/ &
 & 0.11110E-03_JPRB,0.89123E-02_JPRB,0.15343E-01_JPRB,0.21479E-01_JPRB,0.27290E-01_JPRB, &
 & 0.32751E-01_JPRB,0.37455E-01_JPRB,0.40931E-01_JPRB,0.42463E-01_JPRB /)  
KA(:, 1, 2, 3) = (/ &
 & 0.73214E-04_JPRB,0.61410E-02_JPRB,0.10125E-01_JPRB,0.13650E-01_JPRB,0.17158E-01_JPRB, &
 & 0.20627E-01_JPRB,0.23628E-01_JPRB,0.26251E-01_JPRB,0.27481E-01_JPRB /)  
KA(:, 2, 2, 3) = (/ &
 & 0.77936E-04_JPRB,0.65751E-02_JPRB,0.10966E-01_JPRB,0.14877E-01_JPRB,0.18693E-01_JPRB, &
 & 0.22272E-01_JPRB,0.25630E-01_JPRB,0.28395E-01_JPRB,0.29894E-01_JPRB /)  
KA(:, 3, 2, 3) = (/ &
 & 0.83061E-04_JPRB,0.69828E-02_JPRB,0.11774E-01_JPRB,0.16068E-01_JPRB,0.20317E-01_JPRB, &
 & 0.24244E-01_JPRB,0.27748E-01_JPRB,0.30432E-01_JPRB,0.31851E-01_JPRB /)  
KA(:, 4, 2, 3) = (/ &
 & 0.88564E-04_JPRB,0.73985E-02_JPRB,0.12581E-01_JPRB,0.17226E-01_JPRB,0.21842E-01_JPRB, &
 & 0.26177E-01_JPRB,0.29969E-01_JPRB,0.32748E-01_JPRB,0.33805E-01_JPRB /)  
KA(:, 5, 2, 3) = (/ &
 & 0.94933E-04_JPRB,0.77988E-02_JPRB,0.13372E-01_JPRB,0.18367E-01_JPRB,0.23323E-01_JPRB, &
 & 0.27928E-01_JPRB,0.31964E-01_JPRB,0.35013E-01_JPRB,0.35327E-01_JPRB /)  
KA(:, 1, 3, 3) = (/ &
 & 0.60947E-04_JPRB,0.52436E-02_JPRB,0.86174E-02_JPRB,0.11520E-01_JPRB,0.14231E-01_JPRB, &
 & 0.17027E-01_JPRB,0.19469E-01_JPRB,0.21634E-01_JPRB,0.21981E-01_JPRB /)  
KA(:, 2, 3, 3) = (/ &
 & 0.64921E-04_JPRB,0.55975E-02_JPRB,0.93512E-02_JPRB,0.12526E-01_JPRB,0.15516E-01_JPRB, &
 & 0.18471E-01_JPRB,0.21270E-01_JPRB,0.23512E-01_JPRB,0.24114E-01_JPRB /)  
KA(:, 3, 3, 3) = (/ &
 & 0.69521E-04_JPRB,0.59648E-02_JPRB,0.10060E-01_JPRB,0.13582E-01_JPRB,0.16903E-01_JPRB, &
 & 0.20177E-01_JPRB,0.23055E-01_JPRB,0.25380E-01_JPRB,0.25822E-01_JPRB /)  
KA(:, 4, 3, 3) = (/ &
 & 0.74348E-04_JPRB,0.63104E-02_JPRB,0.10767E-01_JPRB,0.14599E-01_JPRB,0.18273E-01_JPRB, &
 & 0.21836E-01_JPRB,0.24984E-01_JPRB,0.27358E-01_JPRB,0.27450E-01_JPRB /)  
KA(:, 5, 3, 3) = (/ &
 & 0.79780E-04_JPRB,0.66671E-02_JPRB,0.11458E-01_JPRB,0.15590E-01_JPRB,0.19579E-01_JPRB, &
 & 0.23358E-01_JPRB,0.26806E-01_JPRB,0.29335E-01_JPRB,0.28786E-01_JPRB /)  
KA(:, 1, 4, 3) = (/ &
 & 0.50799E-04_JPRB,0.44148E-02_JPRB,0.72225E-02_JPRB,0.96483E-02_JPRB,0.11767E-01_JPRB, &
 & 0.13828E-01_JPRB,0.15844E-01_JPRB,0.17588E-01_JPRB,0.17391E-01_JPRB /)  
KA(:, 2, 4, 3) = (/ &
 & 0.54227E-04_JPRB,0.47231E-02_JPRB,0.78527E-02_JPRB,0.10493E-01_JPRB,0.12835E-01_JPRB, &
 & 0.15126E-01_JPRB,0.17466E-01_JPRB,0.19219E-01_JPRB,0.19351E-01_JPRB /)  
KA(:, 3, 4, 3) = (/ &
 & 0.58151E-04_JPRB,0.50277E-02_JPRB,0.84823E-02_JPRB,0.11418E-01_JPRB,0.13969E-01_JPRB, &
 & 0.16576E-01_JPRB,0.18903E-01_JPRB,0.20840E-01_JPRB,0.20853E-01_JPRB /)  
KA(:, 4, 4, 3) = (/ &
 & 0.62433E-04_JPRB,0.53372E-02_JPRB,0.90813E-02_JPRB,0.12325E-01_JPRB,0.15163E-01_JPRB, &
 & 0.17971E-01_JPRB,0.20590E-01_JPRB,0.22529E-01_JPRB,0.22273E-01_JPRB /)  
KA(:, 5, 4, 3) = (/ &
 & 0.66852E-04_JPRB,0.56429E-02_JPRB,0.96836E-02_JPRB,0.13189E-01_JPRB,0.16280E-01_JPRB, &
 & 0.19312E-01_JPRB,0.22136E-01_JPRB,0.24263E-01_JPRB,0.23466E-01_JPRB /)  
KA(:, 1, 5, 3) = (/ &
 & 0.42593E-04_JPRB,0.36760E-02_JPRB,0.59913E-02_JPRB,0.79812E-02_JPRB,0.97729E-02_JPRB, &
 & 0.11265E-01_JPRB,0.12874E-01_JPRB,0.14150E-01_JPRB,0.13651E-01_JPRB /)  
KA(:, 2, 5, 3) = (/ &
 & 0.45779E-04_JPRB,0.39344E-02_JPRB,0.65401E-02_JPRB,0.87030E-02_JPRB,0.10650E-01_JPRB, &
 & 0.12374E-01_JPRB,0.14135E-01_JPRB,0.15529E-01_JPRB,0.15507E-01_JPRB /)  
KA(:, 3, 5, 3) = (/ &
 & 0.48868E-04_JPRB,0.42013E-02_JPRB,0.70859E-02_JPRB,0.94912E-02_JPRB,0.11609E-01_JPRB, &
 & 0.13557E-01_JPRB,0.15381E-01_JPRB,0.16993E-01_JPRB,0.16785E-01_JPRB /)  
KA(:, 4, 5, 3) = (/ &
 & 0.52509E-04_JPRB,0.44674E-02_JPRB,0.76022E-02_JPRB,0.10271E-01_JPRB,0.12630E-01_JPRB, &
 & 0.14736E-01_JPRB,0.16830E-01_JPRB,0.18387E-01_JPRB,0.18040E-01_JPRB /)  
KA(:, 5, 5, 3) = (/ &
 & 0.56196E-04_JPRB,0.47381E-02_JPRB,0.81005E-02_JPRB,0.11026E-01_JPRB,0.13586E-01_JPRB, &
 & 0.15940E-01_JPRB,0.18160E-01_JPRB,0.19920E-01_JPRB,0.19092E-01_JPRB /)  
KA(:, 1, 6, 3) = (/ &
 & 0.36112E-04_JPRB,0.30316E-02_JPRB,0.49038E-02_JPRB,0.65325E-02_JPRB,0.79606E-02_JPRB, &
 & 0.91706E-02_JPRB,0.10285E-01_JPRB,0.11252E-01_JPRB,0.10556E-01_JPRB /)  
KA(:, 2, 6, 3) = (/ &
 & 0.38502E-04_JPRB,0.32575E-02_JPRB,0.53855E-02_JPRB,0.71302E-02_JPRB,0.87200E-02_JPRB, &
 & 0.10138E-01_JPRB,0.11319E-01_JPRB,0.12504E-01_JPRB,0.12109E-01_JPRB /)  
KA(:, 3, 6, 3) = (/ &
 & 0.41070E-04_JPRB,0.34869E-02_JPRB,0.58643E-02_JPRB,0.78020E-02_JPRB,0.95232E-02_JPRB, &
 & 0.11081E-01_JPRB,0.12413E-01_JPRB,0.13700E-01_JPRB,0.13350E-01_JPRB /)  
KA(:, 4, 6, 3) = (/ &
 & 0.44034E-04_JPRB,0.37142E-02_JPRB,0.62924E-02_JPRB,0.84867E-02_JPRB,0.10400E-01_JPRB, &
 & 0.12091E-01_JPRB,0.13614E-01_JPRB,0.14850E-01_JPRB,0.14396E-01_JPRB /)  
KA(:, 5, 6, 3) = (/ &
 & 0.47021E-04_JPRB,0.39387E-02_JPRB,0.67171E-02_JPRB,0.91319E-02_JPRB,0.11231E-01_JPRB, &
 & 0.13129E-01_JPRB,0.14745E-01_JPRB,0.16155E-01_JPRB,0.15392E-01_JPRB /)  
KA(:, 1, 7, 3) = (/ &
 & 0.30001E-04_JPRB,0.24884E-02_JPRB,0.39787E-02_JPRB,0.53262E-02_JPRB,0.64254E-02_JPRB, &
 & 0.74422E-02_JPRB,0.82418E-02_JPRB,0.87651E-02_JPRB,0.83241E-02_JPRB /)  
KA(:, 2, 7, 3) = (/ &
 & 0.32067E-04_JPRB,0.26831E-02_JPRB,0.43873E-02_JPRB,0.58009E-02_JPRB,0.70881E-02_JPRB, &
 & 0.82303E-02_JPRB,0.91115E-02_JPRB,0.99530E-02_JPRB,0.95843E-02_JPRB /)  
KA(:, 3, 7, 3) = (/ &
 & 0.34414E-04_JPRB,0.28762E-02_JPRB,0.47981E-02_JPRB,0.63650E-02_JPRB,0.77555E-02_JPRB, &
 & 0.90130E-02_JPRB,0.10051E-01_JPRB,0.10944E-01_JPRB,0.10687E-01_JPRB /)  
KA(:, 4, 7, 3) = (/ &
 & 0.36543E-04_JPRB,0.30749E-02_JPRB,0.51697E-02_JPRB,0.69549E-02_JPRB,0.84939E-02_JPRB, &
 & 0.98621E-02_JPRB,0.11012E-01_JPRB,0.11950E-01_JPRB,0.11596E-01_JPRB /)  
KA(:, 5, 7, 3) = (/ &
 & 0.38986E-04_JPRB,0.32672E-02_JPRB,0.55268E-02_JPRB,0.74950E-02_JPRB,0.92206E-02_JPRB, &
 & 0.10750E-01_JPRB,0.11970E-01_JPRB,0.13029E-01_JPRB,0.12461E-01_JPRB /)  
KA(:, 1, 8, 3) = (/ &
 & 0.24718E-04_JPRB,0.20304E-02_JPRB,0.32253E-02_JPRB,0.42957E-02_JPRB,0.51621E-02_JPRB, &
 & 0.59477E-02_JPRB,0.65543E-02_JPRB,0.67901E-02_JPRB,0.66578E-02_JPRB /)  
KA(:, 2, 8, 3) = (/ &
 & 0.26226E-04_JPRB,0.22027E-02_JPRB,0.35528E-02_JPRB,0.46844E-02_JPRB,0.57463E-02_JPRB, &
 & 0.66070E-02_JPRB,0.73566E-02_JPRB,0.79086E-02_JPRB,0.76807E-02_JPRB /)  
KA(:, 3, 8, 3) = (/ &
 & 0.28095E-04_JPRB,0.23614E-02_JPRB,0.38960E-02_JPRB,0.51529E-02_JPRB,0.62773E-02_JPRB, &
 & 0.72919E-02_JPRB,0.81475E-02_JPRB,0.87344E-02_JPRB,0.86509E-02_JPRB /)  
KA(:, 4, 8, 3) = (/ &
 & 0.29856E-04_JPRB,0.25346E-02_JPRB,0.42180E-02_JPRB,0.56507E-02_JPRB,0.68867E-02_JPRB, &
 & 0.79948E-02_JPRB,0.89169E-02_JPRB,0.96226E-02_JPRB,0.94212E-02_JPRB /)  
KA(:, 5, 8, 3) = (/ &
 & 0.31432E-04_JPRB,0.26989E-02_JPRB,0.45288E-02_JPRB,0.61158E-02_JPRB,0.75231E-02_JPRB, &
 & 0.87319E-02_JPRB,0.97447E-02_JPRB,0.10470E-01_JPRB,0.10172E-01_JPRB /)  
KA(:, 1, 9, 3) = (/ &
 & 0.20151E-04_JPRB,0.16622E-02_JPRB,0.26102E-02_JPRB,0.34345E-02_JPRB,0.41518E-02_JPRB, &
 & 0.47356E-02_JPRB,0.51198E-02_JPRB,0.52901E-02_JPRB,0.55608E-02_JPRB /)  
KA(:, 2, 9, 3) = (/ &
 & 0.21290E-04_JPRB,0.18112E-02_JPRB,0.28622E-02_JPRB,0.37770E-02_JPRB,0.46098E-02_JPRB, &
 & 0.52825E-02_JPRB,0.58719E-02_JPRB,0.62115E-02_JPRB,0.64287E-02_JPRB /)  
KA(:, 3, 9, 3) = (/ &
 & 0.22604E-04_JPRB,0.19483E-02_JPRB,0.31536E-02_JPRB,0.41418E-02_JPRB,0.50513E-02_JPRB, &
 & 0.58883E-02_JPRB,0.65199E-02_JPRB,0.70000E-02_JPRB,0.71641E-02_JPRB /)  
KA(:, 4, 9, 3) = (/ &
 & 0.24039E-04_JPRB,0.20909E-02_JPRB,0.34321E-02_JPRB,0.45633E-02_JPRB,0.55575E-02_JPRB, &
 & 0.64453E-02_JPRB,0.71800E-02_JPRB,0.77062E-02_JPRB,0.77821E-02_JPRB /)  
KA(:, 5, 9, 3) = (/ &
 & 0.25275E-04_JPRB,0.22325E-02_JPRB,0.36976E-02_JPRB,0.49727E-02_JPRB,0.60945E-02_JPRB, &
 & 0.70632E-02_JPRB,0.78696E-02_JPRB,0.84048E-02_JPRB,0.84571E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


SUBROUTINE PART3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART3',0,ZHOOK_HANDLE)


KA(:, 1,10, 3) = (/ &
 & 0.16520E-04_JPRB,0.13579E-02_JPRB,0.21217E-02_JPRB,0.27650E-02_JPRB,0.33209E-02_JPRB, &
 & 0.37657E-02_JPRB,0.40263E-02_JPRB,0.41632E-02_JPRB,0.59019E-02_JPRB /)  
KA(:, 2,10, 3) = (/ &
 & 0.17307E-04_JPRB,0.14868E-02_JPRB,0.23230E-02_JPRB,0.30616E-02_JPRB,0.37000E-02_JPRB, &
 & 0.42629E-02_JPRB,0.46958E-02_JPRB,0.48956E-02_JPRB,0.64729E-02_JPRB /)  
KA(:, 3,10, 3) = (/ &
 & 0.18210E-04_JPRB,0.16086E-02_JPRB,0.25635E-02_JPRB,0.33480E-02_JPRB,0.40827E-02_JPRB, &
 & 0.47590E-02_JPRB,0.52424E-02_JPRB,0.56088E-02_JPRB,0.71072E-02_JPRB /)  
KA(:, 4,10, 3) = (/ &
 & 0.19263E-04_JPRB,0.17308E-02_JPRB,0.28038E-02_JPRB,0.37016E-02_JPRB,0.44933E-02_JPRB, &
 & 0.52114E-02_JPRB,0.58224E-02_JPRB,0.62053E-02_JPRB,0.76445E-02_JPRB /)  
KA(:, 5,10, 3) = (/ &
 & 0.20450E-04_JPRB,0.18514E-02_JPRB,0.30286E-02_JPRB,0.40569E-02_JPRB,0.49417E-02_JPRB, &
 & 0.57292E-02_JPRB,0.63809E-02_JPRB,0.68162E-02_JPRB,0.81800E-02_JPRB /)  
KA(:, 1,11, 3) = (/ &
 & 0.13743E-04_JPRB,0.11544E-02_JPRB,0.18005E-02_JPRB,0.23380E-02_JPRB,0.28127E-02_JPRB, &
 & 0.32019E-02_JPRB,0.34184E-02_JPRB,0.35137E-02_JPRB,0.55132E-02_JPRB /)  
KA(:, 2,11, 3) = (/ &
 & 0.14314E-04_JPRB,0.12648E-02_JPRB,0.19811E-02_JPRB,0.25794E-02_JPRB,0.31283E-02_JPRB, &
 & 0.35835E-02_JPRB,0.39635E-02_JPRB,0.41524E-02_JPRB,0.60640E-02_JPRB /)  
KA(:, 3,11, 3) = (/ &
 & 0.14980E-04_JPRB,0.13667E-02_JPRB,0.21846E-02_JPRB,0.28316E-02_JPRB,0.34390E-02_JPRB, &
 & 0.40069E-02_JPRB,0.44283E-02_JPRB,0.47282E-02_JPRB,0.65662E-02_JPRB /)  
KA(:, 4,11, 3) = (/ &
 & 0.15843E-04_JPRB,0.14691E-02_JPRB,0.23844E-02_JPRB,0.31346E-02_JPRB,0.37915E-02_JPRB, &
 & 0.43926E-02_JPRB,0.49108E-02_JPRB,0.52431E-02_JPRB,0.70521E-02_JPRB /)  
KA(:, 5,11, 3) = (/ &
 & 0.16801E-04_JPRB,0.15709E-02_JPRB,0.25738E-02_JPRB,0.34250E-02_JPRB,0.41781E-02_JPRB, &
 & 0.48258E-02_JPRB,0.53776E-02_JPRB,0.57400E-02_JPRB,0.74913E-02_JPRB /)  
KA(:, 1,12, 3) = (/ &
 & 0.11265E-04_JPRB,0.97473E-03_JPRB,0.15190E-02_JPRB,0.19779E-02_JPRB,0.23708E-02_JPRB, &
 & 0.27002E-02_JPRB,0.28954E-02_JPRB,0.29689E-02_JPRB,0.49052E-02_JPRB /)  
KA(:, 2,12, 3) = (/ &
 & 0.11703E-04_JPRB,0.10660E-02_JPRB,0.16806E-02_JPRB,0.21742E-02_JPRB,0.26370E-02_JPRB, &
 & 0.30184E-02_JPRB,0.33461E-02_JPRB,0.35081E-02_JPRB,0.53515E-02_JPRB /)  
KA(:, 3,12, 3) = (/ &
 & 0.12275E-04_JPRB,0.11524E-02_JPRB,0.18532E-02_JPRB,0.24014E-02_JPRB,0.28932E-02_JPRB, &
 & 0.33615E-02_JPRB,0.37332E-02_JPRB,0.39759E-02_JPRB,0.57806E-02_JPRB /)  
KA(:, 4,12, 3) = (/ &
 & 0.12963E-04_JPRB,0.12405E-02_JPRB,0.20200E-02_JPRB,0.26573E-02_JPRB,0.31978E-02_JPRB, &
 & 0.36904E-02_JPRB,0.41225E-02_JPRB,0.44151E-02_JPRB,0.61956E-02_JPRB /)  
KA(:, 5,12, 3) = (/ &
 & 0.13696E-04_JPRB,0.13266E-02_JPRB,0.21814E-02_JPRB,0.28939E-02_JPRB,0.35284E-02_JPRB, &
 & 0.40629E-02_JPRB,0.45191E-02_JPRB,0.48283E-02_JPRB,0.65800E-02_JPRB /)  
KA(:, 1,13, 3) = (/ &
 & 0.91179E-05_JPRB,0.81531E-03_JPRB,0.12754E-02_JPRB,0.16598E-02_JPRB,0.19900E-02_JPRB, &
 & 0.22634E-02_JPRB,0.24441E-02_JPRB,0.24984E-02_JPRB,0.40576E-02_JPRB /)  
KA(:, 2,13, 3) = (/ &
 & 0.95039E-05_JPRB,0.89093E-03_JPRB,0.14150E-02_JPRB,0.18287E-02_JPRB,0.22143E-02_JPRB, &
 & 0.25329E-02_JPRB,0.28092E-02_JPRB,0.29546E-02_JPRB,0.44374E-02_JPRB /)  
KA(:, 3,13, 3) = (/ &
 & 0.99762E-05_JPRB,0.96494E-03_JPRB,0.15625E-02_JPRB,0.20288E-02_JPRB,0.24319E-02_JPRB, &
 & 0.28108E-02_JPRB,0.31373E-02_JPRB,0.33177E-02_JPRB,0.48094E-02_JPRB /)  
KA(:, 4,13, 3) = (/ &
 & 0.10509E-04_JPRB,0.10398E-02_JPRB,0.16996E-02_JPRB,0.22443E-02_JPRB,0.26925E-02_JPRB, &
 & 0.30942E-02_JPRB,0.34481E-02_JPRB,0.37003E-02_JPRB,0.51550E-02_JPRB /)  
KA(:, 5,13, 3) = (/ &
 & 0.11033E-04_JPRB,0.11134E-02_JPRB,0.18372E-02_JPRB,0.24408E-02_JPRB,0.29682E-02_JPRB, &
 & 0.34114E-02_JPRB,0.37859E-02_JPRB,0.40424E-02_JPRB,0.54893E-02_JPRB /)  
KA(:, 1, 1, 4) = (/ &
 & 0.25564E-03_JPRB,0.23940E-01_JPRB,0.41535E-01_JPRB,0.56276E-01_JPRB,0.68561E-01_JPRB, &
 & 0.78630E-01_JPRB,0.86993E-01_JPRB,0.91794E-01_JPRB,0.84229E-01_JPRB /)  
KA(:, 2, 1, 4) = (/ &
 & 0.29194E-03_JPRB,0.25170E-01_JPRB,0.43659E-01_JPRB,0.59016E-01_JPRB,0.72302E-01_JPRB, &
 & 0.83167E-01_JPRB,0.91739E-01_JPRB,0.96774E-01_JPRB,0.86838E-01_JPRB /)  
KA(:, 3, 1, 4) = (/ &
 & 0.33934E-03_JPRB,0.26430E-01_JPRB,0.45835E-01_JPRB,0.61922E-01_JPRB,0.75614E-01_JPRB, &
 & 0.87285E-01_JPRB,0.96606E-01_JPRB,0.10156E+00_JPRB,0.90084E-01_JPRB /)  
KA(:, 4, 1, 4) = (/ &
 & 0.38871E-03_JPRB,0.27733E-01_JPRB,0.48058E-01_JPRB,0.64973E-01_JPRB,0.79090E-01_JPRB, &
 & 0.91156E-01_JPRB,0.10084E+00_JPRB,0.10589E+00_JPRB,0.92583E-01_JPRB /)  
KA(:, 5, 1, 4) = (/ &
 & 0.44473E-03_JPRB,0.29028E-01_JPRB,0.50287E-01_JPRB,0.68010E-01_JPRB,0.82805E-01_JPRB, &
 & 0.95193E-01_JPRB,0.10492E+00_JPRB,0.10995E+00_JPRB,0.95419E-01_JPRB /)  
KA(:, 1, 2, 4) = (/ &
 & 0.23400E-03_JPRB,0.20753E-01_JPRB,0.35742E-01_JPRB,0.48709E-01_JPRB,0.59548E-01_JPRB, &
 & 0.68206E-01_JPRB,0.75045E-01_JPRB,0.78915E-01_JPRB,0.70180E-01_JPRB /)  
KA(:, 2, 2, 4) = (/ &
 & 0.26775E-03_JPRB,0.21832E-01_JPRB,0.37611E-01_JPRB,0.51156E-01_JPRB,0.62768E-01_JPRB, &
 & 0.72267E-01_JPRB,0.79422E-01_JPRB,0.83262E-01_JPRB,0.72735E-01_JPRB /)  
KA(:, 3, 2, 4) = (/ &
 & 0.30033E-03_JPRB,0.22961E-01_JPRB,0.39618E-01_JPRB,0.53774E-01_JPRB,0.65773E-01_JPRB, &
 & 0.75819E-01_JPRB,0.83532E-01_JPRB,0.87496E-01_JPRB,0.75459E-01_JPRB /)  
KA(:, 4, 2, 4) = (/ &
 & 0.34366E-03_JPRB,0.24116E-01_JPRB,0.41597E-01_JPRB,0.56506E-01_JPRB,0.68944E-01_JPRB, &
 & 0.79231E-01_JPRB,0.87245E-01_JPRB,0.91336E-01_JPRB,0.77669E-01_JPRB /)  
KA(:, 5, 2, 4) = (/ &
 & 0.39179E-03_JPRB,0.25289E-01_JPRB,0.43575E-01_JPRB,0.59282E-01_JPRB,0.72132E-01_JPRB, &
 & 0.82956E-01_JPRB,0.91038E-01_JPRB,0.94937E-01_JPRB,0.80272E-01_JPRB /)  
KA(:, 1, 3, 4) = (/ &
 & 0.20730E-03_JPRB,0.18044E-01_JPRB,0.30227E-01_JPRB,0.41206E-01_JPRB,0.50626E-01_JPRB, &
 & 0.58095E-01_JPRB,0.63725E-01_JPRB,0.66721E-01_JPRB,0.57780E-01_JPRB /)  
KA(:, 2, 3, 4) = (/ &
 & 0.24007E-03_JPRB,0.18972E-01_JPRB,0.31883E-01_JPRB,0.43486E-01_JPRB,0.53572E-01_JPRB, &
 & 0.61742E-01_JPRB,0.67489E-01_JPRB,0.70552E-01_JPRB,0.60009E-01_JPRB /)  
KA(:, 3, 3, 4) = (/ &
 & 0.26931E-03_JPRB,0.19934E-01_JPRB,0.33681E-01_JPRB,0.45775E-01_JPRB,0.56255E-01_JPRB, &
 & 0.64869E-01_JPRB,0.71254E-01_JPRB,0.74232E-01_JPRB,0.62350E-01_JPRB /)  
KA(:, 4, 3, 4) = (/ &
 & 0.30064E-03_JPRB,0.20965E-01_JPRB,0.35448E-01_JPRB,0.48199E-01_JPRB,0.59036E-01_JPRB, &
 & 0.67921E-01_JPRB,0.74594E-01_JPRB,0.77689E-01_JPRB,0.64410E-01_JPRB /)  
KA(:, 5, 3, 4) = (/ &
 & 0.33967E-03_JPRB,0.21972E-01_JPRB,0.37192E-01_JPRB,0.50676E-01_JPRB,0.61884E-01_JPRB, &
 & 0.71207E-01_JPRB,0.77888E-01_JPRB,0.80947E-01_JPRB,0.66667E-01_JPRB /)  
KA(:, 1, 4, 4) = (/ &
 & 0.18201E-03_JPRB,0.15595E-01_JPRB,0.25372E-01_JPRB,0.34431E-01_JPRB,0.42401E-01_JPRB, &
 & 0.48915E-01_JPRB,0.53613E-01_JPRB,0.55953E-01_JPRB,0.47727E-01_JPRB /)  
KA(:, 2, 4, 4) = (/ &
 & 0.20883E-03_JPRB,0.16422E-01_JPRB,0.26851E-01_JPRB,0.36481E-01_JPRB,0.45074E-01_JPRB, &
 & 0.52078E-01_JPRB,0.56860E-01_JPRB,0.59287E-01_JPRB,0.49553E-01_JPRB /)  
KA(:, 3, 4, 4) = (/ &
 & 0.23874E-03_JPRB,0.17285E-01_JPRB,0.28425E-01_JPRB,0.38514E-01_JPRB,0.47542E-01_JPRB, &
 & 0.54904E-01_JPRB,0.60284E-01_JPRB,0.62561E-01_JPRB,0.51595E-01_JPRB /)  
KA(:, 4, 4, 4) = (/ &
 & 0.26707E-03_JPRB,0.18200E-01_JPRB,0.30007E-01_JPRB,0.40613E-01_JPRB,0.49982E-01_JPRB, &
 & 0.57662E-01_JPRB,0.63231E-01_JPRB,0.65666E-01_JPRB,0.53450E-01_JPRB /)  
KA(:, 5, 4, 4) = (/ &
 & 0.30102E-03_JPRB,0.19113E-01_JPRB,0.31552E-01_JPRB,0.42805E-01_JPRB,0.52535E-01_JPRB, &
 & 0.60559E-01_JPRB,0.66195E-01_JPRB,0.68549E-01_JPRB,0.55415E-01_JPRB /)  
KA(:, 1, 5, 4) = (/ &
 & 0.15801E-03_JPRB,0.13295E-01_JPRB,0.21524E-01_JPRB,0.28666E-01_JPRB,0.35142E-01_JPRB, &
 & 0.40757E-01_JPRB,0.44715E-01_JPRB,0.46740E-01_JPRB,0.39384E-01_JPRB /)  
KA(:, 2, 5, 4) = (/ &
 & 0.17994E-03_JPRB,0.14057E-01_JPRB,0.22786E-01_JPRB,0.30487E-01_JPRB,0.37563E-01_JPRB, &
 & 0.43509E-01_JPRB,0.47676E-01_JPRB,0.49638E-01_JPRB,0.40849E-01_JPRB /)  
KA(:, 3, 5, 4) = (/ &
 & 0.20535E-03_JPRB,0.14811E-01_JPRB,0.24116E-01_JPRB,0.32266E-01_JPRB,0.39764E-01_JPRB, &
 & 0.46122E-01_JPRB,0.50669E-01_JPRB,0.52413E-01_JPRB,0.42683E-01_JPRB /)  
KA(:, 4, 5, 4) = (/ &
 & 0.23511E-03_JPRB,0.15598E-01_JPRB,0.25481E-01_JPRB,0.34103E-01_JPRB,0.41924E-01_JPRB, &
 & 0.48592E-01_JPRB,0.53283E-01_JPRB,0.55235E-01_JPRB,0.44335E-01_JPRB /)  
KA(:, 5, 5, 4) = (/ &
 & 0.26640E-03_JPRB,0.16402E-01_JPRB,0.26844E-01_JPRB,0.36000E-01_JPRB,0.44180E-01_JPRB, &
 & 0.51086E-01_JPRB,0.55918E-01_JPRB,0.57796E-01_JPRB,0.45991E-01_JPRB /)  
KA(:, 1, 6, 4) = (/ &
 & 0.13805E-03_JPRB,0.11222E-01_JPRB,0.18125E-01_JPRB,0.23877E-01_JPRB,0.28939E-01_JPRB, &
 & 0.33506E-01_JPRB,0.36944E-01_JPRB,0.38672E-01_JPRB,0.32335E-01_JPRB /)  
KA(:, 2, 6, 4) = (/ &
 & 0.15439E-03_JPRB,0.11883E-01_JPRB,0.19262E-01_JPRB,0.25521E-01_JPRB,0.31068E-01_JPRB, &
 & 0.35882E-01_JPRB,0.39589E-01_JPRB,0.41132E-01_JPRB,0.33684E-01_JPRB /)  
KA(:, 3, 6, 4) = (/ &
 & 0.17561E-03_JPRB,0.12558E-01_JPRB,0.20409E-01_JPRB,0.27033E-01_JPRB,0.33056E-01_JPRB, &
 & 0.38260E-01_JPRB,0.42155E-01_JPRB,0.43639E-01_JPRB,0.35175E-01_JPRB /)  
KA(:, 4, 6, 4) = (/ &
 & 0.19967E-03_JPRB,0.13236E-01_JPRB,0.21628E-01_JPRB,0.28554E-01_JPRB,0.34939E-01_JPRB, &
 & 0.40459E-01_JPRB,0.44550E-01_JPRB,0.46147E-01_JPRB,0.36643E-01_JPRB /)  
KA(:, 5, 6, 4) = (/ &
 & 0.23117E-03_JPRB,0.13936E-01_JPRB,0.22836E-01_JPRB,0.30183E-01_JPRB,0.36909E-01_JPRB, &
 & 0.42652E-01_JPRB,0.46864E-01_JPRB,0.48440E-01_JPRB,0.37992E-01_JPRB /)  
KA(:, 1, 7, 4) = (/ &
 & 0.11987E-03_JPRB,0.93983E-02_JPRB,0.15130E-01_JPRB,0.19808E-01_JPRB,0.23796E-01_JPRB, &
 & 0.27285E-01_JPRB,0.30176E-01_JPRB,0.31906E-01_JPRB,0.26193E-01_JPRB /)  
KA(:, 2, 7, 4) = (/ &
 & 0.13164E-03_JPRB,0.99743E-02_JPRB,0.16118E-01_JPRB,0.21319E-01_JPRB,0.25600E-01_JPRB, &
 & 0.29404E-01_JPRB,0.32485E-01_JPRB,0.33909E-01_JPRB,0.27439E-01_JPRB /)  
KA(:, 3, 7, 4) = (/ &
 & 0.14862E-03_JPRB,0.10559E-01_JPRB,0.17124E-01_JPRB,0.22674E-01_JPRB,0.27373E-01_JPRB, &
 & 0.31501E-01_JPRB,0.34705E-01_JPRB,0.36112E-01_JPRB,0.28667E-01_JPRB /)  
KA(:, 4, 7, 4) = (/ &
 & 0.16941E-03_JPRB,0.11142E-01_JPRB,0.18163E-01_JPRB,0.23992E-01_JPRB,0.29023E-01_JPRB, &
 & 0.33461E-01_JPRB,0.36882E-01_JPRB,0.38288E-01_JPRB,0.29990E-01_JPRB /)  
KA(:, 5, 7, 4) = (/ &
 & 0.19444E-03_JPRB,0.11740E-01_JPRB,0.19231E-01_JPRB,0.25410E-01_JPRB,0.30702E-01_JPRB, &
 & 0.35380E-01_JPRB,0.38933E-01_JPRB,0.40325E-01_JPRB,0.31163E-01_JPRB /)  
KA(:, 1, 8, 4) = (/ &
 & 0.10266E-03_JPRB,0.78132E-02_JPRB,0.12495E-01_JPRB,0.16294E-01_JPRB,0.19552E-01_JPRB, &
 & 0.22203E-01_JPRB,0.24522E-01_JPRB,0.26158E-01_JPRB,0.21477E-01_JPRB /)  
KA(:, 2, 8, 4) = (/ &
 & 0.11308E-03_JPRB,0.82996E-02_JPRB,0.13385E-01_JPRB,0.17650E-01_JPRB,0.21113E-01_JPRB, &
 & 0.24026E-01_JPRB,0.26424E-01_JPRB,0.27779E-01_JPRB,0.22661E-01_JPRB /)  
KA(:, 3, 8, 4) = (/ &
 & 0.12431E-03_JPRB,0.88118E-02_JPRB,0.14254E-01_JPRB,0.18852E-01_JPRB,0.22717E-01_JPRB, &
 & 0.25822E-01_JPRB,0.28352E-01_JPRB,0.29667E-01_JPRB,0.23674E-01_JPRB /)  
KA(:, 4, 8, 4) = (/ &
 & 0.14146E-03_JPRB,0.93080E-02_JPRB,0.15152E-01_JPRB,0.20013E-01_JPRB,0.24158E-01_JPRB, &
 & 0.27569E-01_JPRB,0.30306E-01_JPRB,0.31495E-01_JPRB,0.24838E-01_JPRB /)  
KA(:, 5, 8, 4) = (/ &
 & 0.16275E-03_JPRB,0.98287E-02_JPRB,0.16080E-01_JPRB,0.21227E-01_JPRB,0.25592E-01_JPRB, &
 & 0.29226E-01_JPRB,0.32075E-01_JPRB,0.33357E-01_JPRB,0.25887E-01_JPRB /)  
KA(:, 1, 9, 4) = (/ &
 & 0.85797E-04_JPRB,0.64412E-02_JPRB,0.10231E-01_JPRB,0.13327E-01_JPRB,0.15923E-01_JPRB, &
 & 0.18103E-01_JPRB,0.19903E-01_JPRB,0.21189E-01_JPRB,0.17975E-01_JPRB /)  
KA(:, 2, 9, 4) = (/ &
 & 0.94370E-04_JPRB,0.68514E-02_JPRB,0.11041E-01_JPRB,0.14472E-01_JPRB,0.17298E-01_JPRB, &
 & 0.19661E-01_JPRB,0.21421E-01_JPRB,0.22631E-01_JPRB,0.18990E-01_JPRB /)  
KA(:, 3, 9, 4) = (/ &
 & 0.10603E-03_JPRB,0.72870E-02_JPRB,0.11786E-01_JPRB,0.15570E-01_JPRB,0.18710E-01_JPRB, &
 & 0.21195E-01_JPRB,0.23092E-01_JPRB,0.24157E-01_JPRB,0.19934E-01_JPRB /)  
KA(:, 4, 9, 4) = (/ &
 & 0.11819E-03_JPRB,0.77217E-02_JPRB,0.12559E-01_JPRB,0.16589E-01_JPRB,0.19991E-01_JPRB, &
 & 0.22738E-01_JPRB,0.24769E-01_JPRB,0.25771E-01_JPRB,0.20946E-01_JPRB /)  
KA(:, 5, 9, 4) = (/ &
 & 0.13500E-03_JPRB,0.81624E-02_JPRB,0.13346E-01_JPRB,0.17610E-01_JPRB,0.21227E-01_JPRB, &
 & 0.24140E-01_JPRB,0.26339E-01_JPRB,0.27388E-01_JPRB,0.21819E-01_JPRB /)  
KA(:, 1,10, 4) = (/ &
 & 0.73275E-04_JPRB,0.53147E-02_JPRB,0.83832E-02_JPRB,0.10890E-01_JPRB,0.12998E-01_JPRB, &
 & 0.14772E-01_JPRB,0.16237E-01_JPRB,0.17165E-01_JPRB,0.15972E-01_JPRB /)  
KA(:, 2,10, 4) = (/ &
 & 0.80303E-04_JPRB,0.56594E-02_JPRB,0.90964E-02_JPRB,0.11869E-01_JPRB,0.14181E-01_JPRB, &
 & 0.16065E-01_JPRB,0.17493E-01_JPRB,0.18447E-01_JPRB,0.17075E-01_JPRB /)  
KA(:, 3,10, 4) = (/ &
 & 0.88821E-04_JPRB,0.60286E-02_JPRB,0.97491E-02_JPRB,0.12852E-01_JPRB,0.15387E-01_JPRB, &
 & 0.17394E-01_JPRB,0.18909E-01_JPRB,0.19708E-01_JPRB,0.18078E-01_JPRB /)  
KA(:, 4,10, 4) = (/ &
 & 0.10142E-03_JPRB,0.63962E-02_JPRB,0.10392E-01_JPRB,0.13730E-01_JPRB,0.16522E-01_JPRB, &
 & 0.18771E-01_JPRB,0.20308E-01_JPRB,0.21096E-01_JPRB,0.19037E-01_JPRB /)  
KA(:, 5,10, 4) = (/ &
 & 0.11405E-03_JPRB,0.67754E-02_JPRB,0.11065E-01_JPRB,0.14605E-01_JPRB,0.17581E-01_JPRB, &
 & 0.19991E-01_JPRB,0.21687E-01_JPRB,0.22458E-01_JPRB,0.19875E-01_JPRB /)  
KA(:, 1,11, 4) = (/ &
 & 0.64517E-04_JPRB,0.45135E-02_JPRB,0.71165E-02_JPRB,0.92384E-02_JPRB,0.10998E-01_JPRB, &
 & 0.12474E-01_JPRB,0.13700E-01_JPRB,0.14388E-01_JPRB,0.14631E-01_JPRB /)  
KA(:, 2,11, 4) = (/ &
 & 0.71535E-04_JPRB,0.48070E-02_JPRB,0.77137E-02_JPRB,0.10092E-01_JPRB,0.12023E-01_JPRB, &
 & 0.13623E-01_JPRB,0.14792E-01_JPRB,0.15449E-01_JPRB,0.15481E-01_JPRB /)  
KA(:, 3,11, 4) = (/ &
 & 0.79504E-04_JPRB,0.51199E-02_JPRB,0.82600E-02_JPRB,0.10911E-01_JPRB,0.13076E-01_JPRB, &
 & 0.14755E-01_JPRB,0.16002E-01_JPRB,0.16546E-01_JPRB,0.16298E-01_JPRB /)  
KA(:, 4,11, 4) = (/ &
 & 0.90433E-04_JPRB,0.54351E-02_JPRB,0.88101E-02_JPRB,0.11647E-01_JPRB,0.14018E-01_JPRB, &
 & 0.15922E-01_JPRB,0.17206E-01_JPRB,0.17715E-01_JPRB,0.16991E-01_JPRB /)  
KA(:, 5,11, 4) = (/ &
 & 0.10146E-03_JPRB,0.57596E-02_JPRB,0.93865E-02_JPRB,0.12407E-01_JPRB,0.14922E-01_JPRB, &
 & 0.16951E-01_JPRB,0.18384E-01_JPRB,0.18893E-01_JPRB,0.17666E-01_JPRB /)  
KA(:, 1,12, 4) = (/ &
 & 0.56913E-04_JPRB,0.38361E-02_JPRB,0.60238E-02_JPRB,0.78101E-02_JPRB,0.92943E-02_JPRB, &
 & 0.10515E-01_JPRB,0.11514E-01_JPRB,0.12051E-01_JPRB,0.12708E-01_JPRB /)  
KA(:, 2,12, 4) = (/ &
 & 0.62984E-04_JPRB,0.40886E-02_JPRB,0.65153E-02_JPRB,0.85464E-02_JPRB,0.10168E-01_JPRB, &
 & 0.11498E-01_JPRB,0.12452E-01_JPRB,0.12938E-01_JPRB,0.13473E-01_JPRB /)  
KA(:, 3,12, 4) = (/ &
 & 0.70588E-04_JPRB,0.43561E-02_JPRB,0.69761E-02_JPRB,0.92137E-02_JPRB,0.11068E-01_JPRB, &
 & 0.12482E-01_JPRB,0.13497E-01_JPRB,0.13892E-01_JPRB,0.14090E-01_JPRB /)  
KA(:, 4,12, 4) = (/ &
 & 0.79556E-04_JPRB,0.46222E-02_JPRB,0.74472E-02_JPRB,0.98382E-02_JPRB,0.11852E-01_JPRB, &
 & 0.13461E-01_JPRB,0.14539E-01_JPRB,0.14868E-01_JPRB,0.14684E-01_JPRB /)  
KA(:, 5,12, 4) = (/ &
 & 0.89330E-04_JPRB,0.49037E-02_JPRB,0.79332E-02_JPRB,0.10492E-01_JPRB,0.12613E-01_JPRB, &
 & 0.14331E-01_JPRB,0.15523E-01_JPRB,0.15867E-01_JPRB,0.15266E-01_JPRB /)  
KA(:, 1,13, 4) = (/ &
 & 0.49040E-04_JPRB,0.32470E-02_JPRB,0.50782E-02_JPRB,0.65813E-02_JPRB,0.78254E-02_JPRB, &
 & 0.88398E-02_JPRB,0.96483E-02_JPRB,0.10090E-01_JPRB,0.10614E-01_JPRB /)  
KA(:, 2,13, 4) = (/ &
 & 0.54225E-04_JPRB,0.34616E-02_JPRB,0.54906E-02_JPRB,0.71951E-02_JPRB,0.85711E-02_JPRB, &
 & 0.96781E-02_JPRB,0.10460E-01_JPRB,0.10840E-01_JPRB,0.11206E-01_JPRB /)  
KA(:, 3,13, 4) = (/ &
 & 0.61136E-04_JPRB,0.36878E-02_JPRB,0.58777E-02_JPRB,0.77458E-02_JPRB,0.93183E-02_JPRB, &
 & 0.10528E-01_JPRB,0.11347E-01_JPRB,0.11684E-01_JPRB,0.11730E-01_JPRB /)  
KA(:, 4,13, 4) = (/ &
 & 0.68788E-04_JPRB,0.39213E-02_JPRB,0.62791E-02_JPRB,0.82774E-02_JPRB,0.99761E-02_JPRB, &
 & 0.11332E-01_JPRB,0.12247E-01_JPRB,0.12495E-01_JPRB,0.12250E-01_JPRB /)  
KA(:, 5,13, 4) = (/ &
 & 0.77427E-04_JPRB,0.41640E-02_JPRB,0.66890E-02_JPRB,0.88358E-02_JPRB,0.10624E-01_JPRB, &
 & 0.12069E-01_JPRB,0.13064E-01_JPRB,0.13341E-01_JPRB,0.12730E-01_JPRB /)  
KA(:, 1, 1, 5) = (/ &
 & 0.69098E-02_JPRB,0.84650E-01_JPRB,0.13006E+00_JPRB,0.16652E+00_JPRB,0.19608E+00_JPRB, &
 & 0.21975E+00_JPRB,0.23496E+00_JPRB,0.23277E+00_JPRB,0.18007E+00_JPRB /)  
KA(:, 2, 1, 5) = (/ &
 & 0.78200E-02_JPRB,0.89279E-01_JPRB,0.13630E+00_JPRB,0.17409E+00_JPRB,0.20398E+00_JPRB, &
 & 0.22718E+00_JPRB,0.24129E+00_JPRB,0.23750E+00_JPRB,0.18438E+00_JPRB /)  
KA(:, 3, 1, 5) = (/ &
 & 0.89787E-02_JPRB,0.94428E-01_JPRB,0.14296E+00_JPRB,0.18170E+00_JPRB,0.21205E+00_JPRB, &
 & 0.23450E+00_JPRB,0.24726E+00_JPRB,0.24172E+00_JPRB,0.18878E+00_JPRB /)  
KA(:, 4, 1, 5) = (/ &
 & 0.10426E-01_JPRB,0.10003E+00_JPRB,0.15009E+00_JPRB,0.18943E+00_JPRB,0.22015E+00_JPRB, &
 & 0.24206E+00_JPRB,0.25341E+00_JPRB,0.24571E+00_JPRB,0.19325E+00_JPRB /)  
KA(:, 5, 1, 5) = (/ &
 & 0.12209E-01_JPRB,0.10603E+00_JPRB,0.15781E+00_JPRB,0.19756E+00_JPRB,0.22832E+00_JPRB, &
 & 0.24963E+00_JPRB,0.25957E+00_JPRB,0.24958E+00_JPRB,0.19748E+00_JPRB /)  
KA(:, 1, 2, 5) = (/ &
 & 0.64020E-02_JPRB,0.74597E-01_JPRB,0.11458E+00_JPRB,0.14581E+00_JPRB,0.17103E+00_JPRB, &
 & 0.19105E+00_JPRB,0.20412E+00_JPRB,0.20133E+00_JPRB,0.15242E+00_JPRB /)  
KA(:, 2, 2, 5) = (/ &
 & 0.72586E-02_JPRB,0.78857E-01_JPRB,0.12024E+00_JPRB,0.15257E+00_JPRB,0.17796E+00_JPRB, &
 & 0.19765E+00_JPRB,0.20972E+00_JPRB,0.20548E+00_JPRB,0.15620E+00_JPRB /)  
KA(:, 3, 2, 5) = (/ &
 & 0.82903E-02_JPRB,0.83602E-01_JPRB,0.12623E+00_JPRB,0.15931E+00_JPRB,0.18512E+00_JPRB, &
 & 0.20423E+00_JPRB,0.21503E+00_JPRB,0.20937E+00_JPRB,0.15993E+00_JPRB /)  
KA(:, 4, 2, 5) = (/ &
 & 0.94578E-02_JPRB,0.88668E-01_JPRB,0.13277E+00_JPRB,0.16635E+00_JPRB,0.19233E+00_JPRB, &
 & 0.21098E+00_JPRB,0.22050E+00_JPRB,0.21294E+00_JPRB,0.16397E+00_JPRB /)  
KA(:, 5, 2, 5) = (/ &
 & 0.10865E-01_JPRB,0.94113E-01_JPRB,0.13987E+00_JPRB,0.17375E+00_JPRB,0.19975E+00_JPRB, &
 & 0.21771E+00_JPRB,0.22592E+00_JPRB,0.21639E+00_JPRB,0.16745E+00_JPRB /)  
KA(:, 1, 3, 5) = (/ &
 & 0.56943E-02_JPRB,0.64084E-01_JPRB,0.99294E-01_JPRB,0.12614E+00_JPRB,0.14746E+00_JPRB, &
 & 0.16414E+00_JPRB,0.17503E+00_JPRB,0.17255E+00_JPRB,0.12738E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART3',1,ZHOOK_HANDLE)
END SUBROUTINE PART3


SUBROUTINE PART4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART4',0,ZHOOK_HANDLE)


KA(:, 2, 3, 5) = (/ &
 & 0.64702E-02_JPRB,0.67967E-01_JPRB,0.10427E+00_JPRB,0.13197E+00_JPRB,0.15350E+00_JPRB, &
 & 0.16985E+00_JPRB,0.18008E+00_JPRB,0.17631E+00_JPRB,0.13087E+00_JPRB /)  
KA(:, 3, 3, 5) = (/ &
 & 0.74200E-02_JPRB,0.72252E-01_JPRB,0.10956E+00_JPRB,0.13801E+00_JPRB,0.15978E+00_JPRB, &
 & 0.17567E+00_JPRB,0.18476E+00_JPRB,0.17977E+00_JPRB,0.13421E+00_JPRB /)  
KA(:, 4, 3, 5) = (/ &
 & 0.84907E-02_JPRB,0.76772E-01_JPRB,0.11539E+00_JPRB,0.14427E+00_JPRB,0.16615E+00_JPRB, &
 & 0.18168E+00_JPRB,0.18947E+00_JPRB,0.18300E+00_JPRB,0.13761E+00_JPRB /)  
KA(:, 5, 3, 5) = (/ &
 & 0.97078E-02_JPRB,0.81671E-01_JPRB,0.12172E+00_JPRB,0.15082E+00_JPRB,0.17277E+00_JPRB, &
 & 0.18769E+00_JPRB,0.19427E+00_JPRB,0.18608E+00_JPRB,0.14067E+00_JPRB /)  
KA(:, 1, 4, 5) = (/ &
 & 0.48829E-02_JPRB,0.54383E-01_JPRB,0.85075E-01_JPRB,0.10815E+00_JPRB,0.12638E+00_JPRB, &
 & 0.14020E+00_JPRB,0.14903E+00_JPRB,0.14670E+00_JPRB,0.10614E+00_JPRB /)  
KA(:, 2, 4, 5) = (/ &
 & 0.55740E-02_JPRB,0.57779E-01_JPRB,0.89436E-01_JPRB,0.11323E+00_JPRB,0.13160E+00_JPRB, &
 & 0.14514E+00_JPRB,0.15349E+00_JPRB,0.15027E+00_JPRB,0.10949E+00_JPRB /)  
KA(:, 3, 4, 5) = (/ &
 & 0.64015E-02_JPRB,0.61546E-01_JPRB,0.94139E-01_JPRB,0.11850E+00_JPRB,0.13701E+00_JPRB, &
 & 0.15017E+00_JPRB,0.15757E+00_JPRB,0.15344E+00_JPRB,0.11257E+00_JPRB /)  
KA(:, 4, 4, 5) = (/ &
 & 0.73719E-02_JPRB,0.65521E-01_JPRB,0.99232E-01_JPRB,0.12403E+00_JPRB,0.14259E+00_JPRB, &
 & 0.15541E+00_JPRB,0.16175E+00_JPRB,0.15634E+00_JPRB,0.11557E+00_JPRB /)  
KA(:, 5, 4, 5) = (/ &
 & 0.84789E-02_JPRB,0.69810E-01_JPRB,0.10478E+00_JPRB,0.12985E+00_JPRB,0.14840E+00_JPRB, &
 & 0.16071E+00_JPRB,0.16597E+00_JPRB,0.15910E+00_JPRB,0.11833E+00_JPRB /)  
KA(:, 1, 5, 5) = (/ &
 & 0.41357E-02_JPRB,0.45878E-01_JPRB,0.71866E-01_JPRB,0.92130E-01_JPRB,0.10772E+00_JPRB, &
 & 0.11935E+00_JPRB,0.12627E+00_JPRB,0.12382E+00_JPRB,0.88490E-01_JPRB /)  
KA(:, 2, 5, 5) = (/ &
 & 0.47278E-02_JPRB,0.48809E-01_JPRB,0.75724E-01_JPRB,0.96485E-01_JPRB,0.11218E+00_JPRB, &
 & 0.12363E+00_JPRB,0.13023E+00_JPRB,0.12723E+00_JPRB,0.91646E-01_JPRB /)  
KA(:, 3, 5, 5) = (/ &
 & 0.54234E-02_JPRB,0.52108E-01_JPRB,0.79925E-01_JPRB,0.10105E+00_JPRB,0.11684E+00_JPRB, &
 & 0.12795E+00_JPRB,0.13389E+00_JPRB,0.13024E+00_JPRB,0.94384E-01_JPRB /)  
KA(:, 4, 5, 5) = (/ &
 & 0.62672E-02_JPRB,0.55647E-01_JPRB,0.84438E-01_JPRB,0.10591E+00_JPRB,0.12167E+00_JPRB, &
 & 0.13255E+00_JPRB,0.13759E+00_JPRB,0.13288E+00_JPRB,0.97037E-01_JPRB /)  
KA(:, 5, 5, 5) = (/ &
 & 0.72387E-02_JPRB,0.59393E-01_JPRB,0.89326E-01_JPRB,0.11102E+00_JPRB,0.12680E+00_JPRB, &
 & 0.13723E+00_JPRB,0.14128E+00_JPRB,0.13530E+00_JPRB,0.99585E-01_JPRB /)  
KA(:, 1, 6, 5) = (/ &
 & 0.34820E-02_JPRB,0.38455E-01_JPRB,0.60106E-01_JPRB,0.77515E-01_JPRB,0.91143E-01_JPRB, &
 & 0.10094E+00_JPRB,0.10649E+00_JPRB,0.10403E+00_JPRB,0.73509E-01_JPRB /)  
KA(:, 2, 6, 5) = (/ &
 & 0.39507E-02_JPRB,0.40927E-01_JPRB,0.63402E-01_JPRB,0.81240E-01_JPRB,0.94968E-01_JPRB, &
 & 0.10469E+00_JPRB,0.11001E+00_JPRB,0.10717E+00_JPRB,0.76426E-01_JPRB /)  
KA(:, 3, 6, 5) = (/ &
 & 0.45266E-02_JPRB,0.43726E-01_JPRB,0.67041E-01_JPRB,0.85234E-01_JPRB,0.98911E-01_JPRB, &
 & 0.10845E+00_JPRB,0.11329E+00_JPRB,0.10996E+00_JPRB,0.78861E-01_JPRB /)  
KA(:, 4, 6, 5) = (/ &
 & 0.52242E-02_JPRB,0.46807E-01_JPRB,0.70939E-01_JPRB,0.89547E-01_JPRB,0.10312E+00_JPRB, &
 & 0.11247E+00_JPRB,0.11653E+00_JPRB,0.11237E+00_JPRB,0.81250E-01_JPRB /)  
KA(:, 5, 6, 5) = (/ &
 & 0.60449E-02_JPRB,0.50083E-01_JPRB,0.75175E-01_JPRB,0.94041E-01_JPRB,0.10760E+00_JPRB, &
 & 0.11657E+00_JPRB,0.11980E+00_JPRB,0.11449E+00_JPRB,0.83549E-01_JPRB /)  
KA(:, 1, 7, 5) = (/ &
 & 0.28711E-02_JPRB,0.32523E-01_JPRB,0.49971E-01_JPRB,0.64597E-01_JPRB,0.76360E-01_JPRB, &
 & 0.84918E-01_JPRB,0.89523E-01_JPRB,0.87200E-01_JPRB,0.60618E-01_JPRB /)  
KA(:, 2, 7, 5) = (/ &
 & 0.32550E-02_JPRB,0.34614E-01_JPRB,0.52803E-01_JPRB,0.67740E-01_JPRB,0.79713E-01_JPRB, &
 & 0.88207E-01_JPRB,0.92681E-01_JPRB,0.90060E-01_JPRB,0.63331E-01_JPRB /)  
KA(:, 3, 7, 5) = (/ &
 & 0.37263E-02_JPRB,0.36968E-01_JPRB,0.55904E-01_JPRB,0.71153E-01_JPRB,0.83143E-01_JPRB, &
 & 0.91509E-01_JPRB,0.95607E-01_JPRB,0.92564E-01_JPRB,0.65595E-01_JPRB /)  
KA(:, 4, 7, 5) = (/ &
 & 0.42953E-02_JPRB,0.39538E-01_JPRB,0.59281E-01_JPRB,0.74912E-01_JPRB,0.86822E-01_JPRB, &
 & 0.94956E-01_JPRB,0.98438E-01_JPRB,0.94728E-01_JPRB,0.67680E-01_JPRB /)  
KA(:, 5, 7, 5) = (/ &
 & 0.49788E-02_JPRB,0.42264E-01_JPRB,0.62953E-01_JPRB,0.78842E-01_JPRB,0.90742E-01_JPRB, &
 & 0.98510E-01_JPRB,0.10129E+00_JPRB,0.96641E-01_JPRB,0.69746E-01_JPRB /)  
KA(:, 1, 8, 5) = (/ &
 & 0.23480E-02_JPRB,0.27230E-01_JPRB,0.41671E-01_JPRB,0.53565E-01_JPRB,0.63436E-01_JPRB, &
 & 0.70999E-01_JPRB,0.75020E-01_JPRB,0.72906E-01_JPRB,0.49386E-01_JPRB /)  
KA(:, 2, 8, 5) = (/ &
 & 0.26517E-02_JPRB,0.29065E-01_JPRB,0.44017E-01_JPRB,0.56225E-01_JPRB,0.66341E-01_JPRB, &
 & 0.73935E-01_JPRB,0.77879E-01_JPRB,0.75468E-01_JPRB,0.51750E-01_JPRB /)  
KA(:, 3, 8, 5) = (/ &
 & 0.30285E-02_JPRB,0.31112E-01_JPRB,0.46598E-01_JPRB,0.59161E-01_JPRB,0.69302E-01_JPRB, &
 & 0.76809E-01_JPRB,0.80439E-01_JPRB,0.77729E-01_JPRB,0.53904E-01_JPRB /)  
KA(:, 4, 8, 5) = (/ &
 & 0.34816E-02_JPRB,0.33348E-01_JPRB,0.49448E-01_JPRB,0.62380E-01_JPRB,0.72502E-01_JPRB, &
 & 0.79786E-01_JPRB,0.82887E-01_JPRB,0.79683E-01_JPRB,0.55731E-01_JPRB /)  
KA(:, 5, 8, 5) = (/ &
 & 0.40444E-02_JPRB,0.35730E-01_JPRB,0.52545E-01_JPRB,0.65794E-01_JPRB,0.75878E-01_JPRB, &
 & 0.82889E-01_JPRB,0.85379E-01_JPRB,0.81391E-01_JPRB,0.57509E-01_JPRB /)  
KA(:, 1, 9, 5) = (/ &
 & 0.19247E-02_JPRB,0.22630E-01_JPRB,0.34752E-01_JPRB,0.44387E-01_JPRB,0.52455E-01_JPRB, &
 & 0.58833E-01_JPRB,0.62468E-01_JPRB,0.60719E-01_JPRB,0.41880E-01_JPRB /)  
KA(:, 2, 9, 5) = (/ &
 & 0.21557E-02_JPRB,0.24204E-01_JPRB,0.36750E-01_JPRB,0.46636E-01_JPRB,0.54976E-01_JPRB, &
 & 0.61421E-01_JPRB,0.65052E-01_JPRB,0.62994E-01_JPRB,0.44010E-01_JPRB /)  
KA(:, 3, 9, 5) = (/ &
 & 0.24477E-02_JPRB,0.25958E-01_JPRB,0.38981E-01_JPRB,0.49108E-01_JPRB,0.57526E-01_JPRB, &
 & 0.63907E-01_JPRB,0.67351E-01_JPRB,0.65038E-01_JPRB,0.45929E-01_JPRB /)  
KA(:, 4, 9, 5) = (/ &
 & 0.28196E-02_JPRB,0.27882E-01_JPRB,0.41431E-01_JPRB,0.51802E-01_JPRB,0.60249E-01_JPRB, &
 & 0.66480E-01_JPRB,0.69467E-01_JPRB,0.66788E-01_JPRB,0.47555E-01_JPRB /)  
KA(:, 5, 9, 5) = (/ &
 & 0.32654E-02_JPRB,0.29939E-01_JPRB,0.44072E-01_JPRB,0.54714E-01_JPRB,0.63163E-01_JPRB, &
 & 0.69207E-01_JPRB,0.71600E-01_JPRB,0.68328E-01_JPRB,0.49077E-01_JPRB /)  
KA(:, 1,10, 5) = (/ &
 & 0.16200E-02_JPRB,0.18814E-01_JPRB,0.28911E-01_JPRB,0.37025E-01_JPRB,0.43479E-01_JPRB, &
 & 0.48691E-01_JPRB,0.51767E-01_JPRB,0.50517E-01_JPRB,0.36565E-01_JPRB /)  
KA(:, 2,10, 5) = (/ &
 & 0.18031E-02_JPRB,0.20150E-01_JPRB,0.30632E-01_JPRB,0.38967E-01_JPRB,0.45609E-01_JPRB, &
 & 0.50940E-01_JPRB,0.54046E-01_JPRB,0.52515E-01_JPRB,0.38425E-01_JPRB /)  
KA(:, 3,10, 5) = (/ &
 & 0.20232E-02_JPRB,0.21640E-01_JPRB,0.32572E-01_JPRB,0.41079E-01_JPRB,0.47788E-01_JPRB, &
 & 0.53101E-01_JPRB,0.56114E-01_JPRB,0.54338E-01_JPRB,0.40162E-01_JPRB /)  
KA(:, 4,10, 5) = (/ &
 & 0.23038E-02_JPRB,0.23298E-01_JPRB,0.34703E-01_JPRB,0.43393E-01_JPRB,0.50110E-01_JPRB, &
 & 0.55298E-01_JPRB,0.57982E-01_JPRB,0.55873E-01_JPRB,0.41782E-01_JPRB /)  
KA(:, 5,10, 5) = (/ &
 & 0.26649E-02_JPRB,0.25073E-01_JPRB,0.36983E-01_JPRB,0.45868E-01_JPRB,0.52617E-01_JPRB, &
 & 0.57641E-01_JPRB,0.59833E-01_JPRB,0.57222E-01_JPRB,0.43243E-01_JPRB /)  
KA(:, 1,11, 5) = (/ &
 & 0.14241E-02_JPRB,0.16065E-01_JPRB,0.24586E-01_JPRB,0.31465E-01_JPRB,0.36963E-01_JPRB, &
 & 0.41093E-01_JPRB,0.43617E-01_JPRB,0.42673E-01_JPRB,0.32343E-01_JPRB /)  
KA(:, 2,11, 5) = (/ &
 & 0.15878E-02_JPRB,0.17268E-01_JPRB,0.26144E-01_JPRB,0.33169E-01_JPRB,0.38816E-01_JPRB, &
 & 0.42988E-01_JPRB,0.45546E-01_JPRB,0.44327E-01_JPRB,0.34054E-01_JPRB /)  
KA(:, 3,11, 5) = (/ &
 & 0.18003E-02_JPRB,0.18609E-01_JPRB,0.27888E-01_JPRB,0.35066E-01_JPRB,0.40717E-01_JPRB, &
 & 0.44861E-01_JPRB,0.47277E-01_JPRB,0.45845E-01_JPRB,0.35562E-01_JPRB /)  
KA(:, 4,11, 5) = (/ &
 & 0.20513E-02_JPRB,0.20069E-01_JPRB,0.29794E-01_JPRB,0.37147E-01_JPRB,0.42781E-01_JPRB, &
 & 0.46774E-01_JPRB,0.48869E-01_JPRB,0.47106E-01_JPRB,0.36881E-01_JPRB /)  
KA(:, 5,11, 5) = (/ &
 & 0.23610E-02_JPRB,0.21636E-01_JPRB,0.31786E-01_JPRB,0.39341E-01_JPRB,0.44964E-01_JPRB, &
 & 0.48832E-01_JPRB,0.50478E-01_JPRB,0.48237E-01_JPRB,0.38136E-01_JPRB /)  
KA(:, 1,12, 5) = (/ &
 & 0.12367E-02_JPRB,0.13664E-01_JPRB,0.20841E-01_JPRB,0.26619E-01_JPRB,0.31258E-01_JPRB, &
 & 0.34766E-01_JPRB,0.36665E-01_JPRB,0.35873E-01_JPRB,0.27811E-01_JPRB /)  
KA(:, 2,12, 5) = (/ &
 & 0.13898E-02_JPRB,0.14747E-01_JPRB,0.22238E-01_JPRB,0.28134E-01_JPRB,0.32876E-01_JPRB, &
 & 0.36392E-01_JPRB,0.38286E-01_JPRB,0.37257E-01_JPRB,0.29212E-01_JPRB /)  
KA(:, 3,12, 5) = (/ &
 & 0.15822E-02_JPRB,0.15920E-01_JPRB,0.23808E-01_JPRB,0.29830E-01_JPRB,0.34558E-01_JPRB, &
 & 0.38014E-01_JPRB,0.39728E-01_JPRB,0.38493E-01_JPRB,0.30517E-01_JPRB /)  
KA(:, 4,12, 5) = (/ &
 & 0.18117E-02_JPRB,0.17195E-01_JPRB,0.25479E-01_JPRB,0.31664E-01_JPRB,0.36378E-01_JPRB, &
 & 0.39675E-01_JPRB,0.41098E-01_JPRB,0.39553E-01_JPRB,0.31705E-01_JPRB /)  
KA(:, 5,12, 5) = (/ &
 & 0.20996E-02_JPRB,0.18567E-01_JPRB,0.27225E-01_JPRB,0.33571E-01_JPRB,0.38302E-01_JPRB, &
 & 0.41437E-01_JPRB,0.42501E-01_JPRB,0.40525E-01_JPRB,0.32748E-01_JPRB /)  
KA(:, 1,13, 5) = (/ &
 & 0.10606E-02_JPRB,0.11594E-01_JPRB,0.17616E-01_JPRB,0.22456E-01_JPRB,0.26337E-01_JPRB, &
 & 0.29282E-01_JPRB,0.30831E-01_JPRB,0.30037E-01_JPRB,0.23251E-01_JPRB /)  
KA(:, 2,13, 5) = (/ &
 & 0.11975E-02_JPRB,0.12541E-01_JPRB,0.18850E-01_JPRB,0.23795E-01_JPRB,0.27745E-01_JPRB, &
 & 0.30676E-01_JPRB,0.32191E-01_JPRB,0.31186E-01_JPRB,0.24461E-01_JPRB /)  
KA(:, 3,13, 5) = (/ &
 & 0.13686E-02_JPRB,0.13557E-01_JPRB,0.20236E-01_JPRB,0.25287E-01_JPRB,0.29224E-01_JPRB, &
 & 0.32085E-01_JPRB,0.33411E-01_JPRB,0.32190E-01_JPRB,0.25539E-01_JPRB /)  
KA(:, 4,13, 5) = (/ &
 & 0.15787E-02_JPRB,0.14655E-01_JPRB,0.21685E-01_JPRB,0.26887E-01_JPRB,0.30821E-01_JPRB, &
 & 0.33533E-01_JPRB,0.34581E-01_JPRB,0.33091E-01_JPRB,0.26483E-01_JPRB /)  
KA(:, 5,13, 5) = (/ &
 & 0.18422E-02_JPRB,0.15847E-01_JPRB,0.23201E-01_JPRB,0.28535E-01_JPRB,0.32486E-01_JPRB, &
 & 0.35059E-01_JPRB,0.35791E-01_JPRB,0.33942E-01_JPRB,0.27340E-01_JPRB /)  
KA(:, 1, 1, 6) = (/ &
 & 0.11257E+00_JPRB,0.31731E+00_JPRB,0.42139E+00_JPRB,0.49121E+00_JPRB,0.53179E+00_JPRB, &
 & 0.54416E+00_JPRB,0.52879E+00_JPRB,0.48565E+00_JPRB,0.38185E+00_JPRB /)  
KA(:, 2, 1, 6) = (/ &
 & 0.12995E+00_JPRB,0.33757E+00_JPRB,0.44079E+00_JPRB,0.50693E+00_JPRB,0.54374E+00_JPRB, &
 & 0.55231E+00_JPRB,0.53411E+00_JPRB,0.48973E+00_JPRB,0.38664E+00_JPRB /)  
KA(:, 3, 1, 6) = (/ &
 & 0.14899E+00_JPRB,0.35787E+00_JPRB,0.45940E+00_JPRB,0.52235E+00_JPRB,0.55490E+00_JPRB, &
 & 0.56009E+00_JPRB,0.53945E+00_JPRB,0.49411E+00_JPRB,0.39028E+00_JPRB /)  
KA(:, 4, 1, 6) = (/ &
 & 0.16946E+00_JPRB,0.37848E+00_JPRB,0.47747E+00_JPRB,0.53692E+00_JPRB,0.56497E+00_JPRB, &
 & 0.56760E+00_JPRB,0.54484E+00_JPRB,0.49832E+00_JPRB,0.39391E+00_JPRB /)  
KA(:, 5, 1, 6) = (/ &
 & 0.19143E+00_JPRB,0.39915E+00_JPRB,0.49476E+00_JPRB,0.55039E+00_JPRB,0.57468E+00_JPRB, &
 & 0.57486E+00_JPRB,0.55036E+00_JPRB,0.50307E+00_JPRB,0.39756E+00_JPRB /)  
KA(:, 1, 2, 6) = (/ &
 & 0.97091E-01_JPRB,0.28037E+00_JPRB,0.37054E+00_JPRB,0.43162E+00_JPRB,0.46715E+00_JPRB, &
 & 0.47740E+00_JPRB,0.46327E+00_JPRB,0.42557E+00_JPRB,0.32833E+00_JPRB /)  
KA(:, 2, 2, 6) = (/ &
 & 0.11208E+00_JPRB,0.29815E+00_JPRB,0.38764E+00_JPRB,0.44615E+00_JPRB,0.47841E+00_JPRB, &
 & 0.48513E+00_JPRB,0.46886E+00_JPRB,0.42998E+00_JPRB,0.33260E+00_JPRB /)  
KA(:, 3, 2, 6) = (/ &
 & 0.12856E+00_JPRB,0.31599E+00_JPRB,0.40420E+00_JPRB,0.45996E+00_JPRB,0.48848E+00_JPRB, &
 & 0.49285E+00_JPRB,0.47441E+00_JPRB,0.43431E+00_JPRB,0.33632E+00_JPRB /)  
KA(:, 4, 2, 6) = (/ &
 & 0.14648E+00_JPRB,0.33425E+00_JPRB,0.42020E+00_JPRB,0.47262E+00_JPRB,0.49778E+00_JPRB, &
 & 0.50015E+00_JPRB,0.47996E+00_JPRB,0.43890E+00_JPRB,0.33965E+00_JPRB /)  
KA(:, 5, 2, 6) = (/ &
 & 0.16579E+00_JPRB,0.35250E+00_JPRB,0.43554E+00_JPRB,0.48445E+00_JPRB,0.50655E+00_JPRB, &
 & 0.50702E+00_JPRB,0.48572E+00_JPRB,0.44375E+00_JPRB,0.34330E+00_JPRB /)  
KA(:, 1, 3, 6) = (/ &
 & 0.80654E-01_JPRB,0.24334E+00_JPRB,0.32145E+00_JPRB,0.37485E+00_JPRB,0.40615E+00_JPRB, &
 & 0.41488E+00_JPRB,0.40284E+00_JPRB,0.37005E+00_JPRB,0.27897E+00_JPRB /)  
KA(:, 2, 3, 6) = (/ &
 & 0.93334E-01_JPRB,0.25889E+00_JPRB,0.33665E+00_JPRB,0.38799E+00_JPRB,0.41628E+00_JPRB, &
 & 0.42254E+00_JPRB,0.40845E+00_JPRB,0.37420E+00_JPRB,0.28281E+00_JPRB /)  
KA(:, 3, 3, 6) = (/ &
 & 0.10735E+00_JPRB,0.27449E+00_JPRB,0.35143E+00_JPRB,0.40015E+00_JPRB,0.42551E+00_JPRB, &
 & 0.42981E+00_JPRB,0.41382E+00_JPRB,0.37871E+00_JPRB,0.28619E+00_JPRB /)  
KA(:, 4, 3, 6) = (/ &
 & 0.12265E+00_JPRB,0.29043E+00_JPRB,0.36548E+00_JPRB,0.41153E+00_JPRB,0.43393E+00_JPRB, &
 & 0.43649E+00_JPRB,0.41932E+00_JPRB,0.38340E+00_JPRB,0.28955E+00_JPRB /)  
KA(:, 5, 3, 6) = (/ &
 & 0.13925E+00_JPRB,0.30659E+00_JPRB,0.37895E+00_JPRB,0.42211E+00_JPRB,0.44187E+00_JPRB, &
 & 0.44276E+00_JPRB,0.42490E+00_JPRB,0.38830E+00_JPRB,0.29282E+00_JPRB /)  
KA(:, 1, 4, 6) = (/ &
 & 0.65986E-01_JPRB,0.20968E+00_JPRB,0.27746E+00_JPRB,0.32321E+00_JPRB,0.35021E+00_JPRB, &
 & 0.35817E+00_JPRB,0.34816E+00_JPRB,0.31914E+00_JPRB,0.23714E+00_JPRB /)  
KA(:, 2, 4, 6) = (/ &
 & 0.76550E-01_JPRB,0.22318E+00_JPRB,0.29094E+00_JPRB,0.33486E+00_JPRB,0.35941E+00_JPRB, &
 & 0.36546E+00_JPRB,0.35341E+00_JPRB,0.32318E+00_JPRB,0.24040E+00_JPRB /)  
KA(:, 3, 4, 6) = (/ &
 & 0.88349E-01_JPRB,0.23676E+00_JPRB,0.30387E+00_JPRB,0.34562E+00_JPRB,0.36786E+00_JPRB, &
 & 0.37204E+00_JPRB,0.35871E+00_JPRB,0.32765E+00_JPRB,0.24343E+00_JPRB /)  
KA(:, 4, 4, 6) = (/ &
 & 0.10129E+00_JPRB,0.25065E+00_JPRB,0.31610E+00_JPRB,0.35574E+00_JPRB,0.37546E+00_JPRB, &
 & 0.37811E+00_JPRB,0.36390E+00_JPRB,0.33220E+00_JPRB,0.24649E+00_JPRB /)  
KA(:, 5, 4, 6) = (/ &
 & 0.11540E+00_JPRB,0.26489E+00_JPRB,0.32784E+00_JPRB,0.36504E+00_JPRB,0.38250E+00_JPRB, &
 & 0.38387E+00_JPRB,0.36919E+00_JPRB,0.33697E+00_JPRB,0.24943E+00_JPRB /)  
KA(:, 1, 5, 6) = (/ &
 & 0.53393E-01_JPRB,0.18000E+00_JPRB,0.23883E+00_JPRB,0.27751E+00_JPRB,0.30053E+00_JPRB, &
 & 0.30742E+00_JPRB,0.29898E+00_JPRB,0.27383E+00_JPRB,0.20106E+00_JPRB /)  
KA(:, 2, 5, 6) = (/ &
 & 0.62233E-01_JPRB,0.19175E+00_JPRB,0.25050E+00_JPRB,0.28777E+00_JPRB,0.30898E+00_JPRB, &
 & 0.31400E+00_JPRB,0.30389E+00_JPRB,0.27769E+00_JPRB,0.20390E+00_JPRB /)  
KA(:, 3, 5, 6) = (/ &
 & 0.72177E-01_JPRB,0.20364E+00_JPRB,0.26165E+00_JPRB,0.29741E+00_JPRB,0.31640E+00_JPRB, &
 & 0.31996E+00_JPRB,0.30876E+00_JPRB,0.28174E+00_JPRB,0.20671E+00_JPRB /)  
KA(:, 4, 5, 6) = (/ &
 & 0.83134E-01_JPRB,0.21576E+00_JPRB,0.27227E+00_JPRB,0.30617E+00_JPRB,0.32319E+00_JPRB, &
 & 0.32542E+00_JPRB,0.31353E+00_JPRB,0.28599E+00_JPRB,0.20956E+00_JPRB /)  
KA(:, 5, 5, 6) = (/ &
 & 0.95090E-01_JPRB,0.22815E+00_JPRB,0.28259E+00_JPRB,0.31429E+00_JPRB,0.32943E+00_JPRB, &
 & 0.33059E+00_JPRB,0.31837E+00_JPRB,0.29043E+00_JPRB,0.21220E+00_JPRB /)  
KA(:, 1, 6, 6) = (/ &
 & 0.42433E-01_JPRB,0.15317E+00_JPRB,0.20425E+00_JPRB,0.23740E+00_JPRB,0.25663E+00_JPRB, &
 & 0.26234E+00_JPRB,0.25512E+00_JPRB,0.23364E+00_JPRB,0.16949E+00_JPRB /)  
KA(:, 2, 6, 6) = (/ &
 & 0.49749E-01_JPRB,0.16341E+00_JPRB,0.21435E+00_JPRB,0.24646E+00_JPRB,0.26413E+00_JPRB, &
 & 0.26825E+00_JPRB,0.25968E+00_JPRB,0.23716E+00_JPRB,0.17204E+00_JPRB /)  
KA(:, 3, 6, 6) = (/ &
 & 0.58017E-01_JPRB,0.17381E+00_JPRB,0.22409E+00_JPRB,0.25485E+00_JPRB,0.27073E+00_JPRB, &
 & 0.27356E+00_JPRB,0.26405E+00_JPRB,0.24070E+00_JPRB,0.17477E+00_JPRB /)  
KA(:, 4, 6, 6) = (/ &
 & 0.67231E-01_JPRB,0.18439E+00_JPRB,0.23345E+00_JPRB,0.26240E+00_JPRB,0.27677E+00_JPRB, &
 & 0.27839E+00_JPRB,0.26819E+00_JPRB,0.24459E+00_JPRB,0.17741E+00_JPRB /)  
KA(:, 5, 6, 6) = (/ &
 & 0.77316E-01_JPRB,0.19517E+00_JPRB,0.24253E+00_JPRB,0.26953E+00_JPRB,0.28221E+00_JPRB, &
 & 0.28296E+00_JPRB,0.27246E+00_JPRB,0.24867E+00_JPRB,0.17984E+00_JPRB /)  
KA(:, 1, 7, 6) = (/ &
 & 0.33835E-01_JPRB,0.12894E+00_JPRB,0.17377E+00_JPRB,0.20223E+00_JPRB,0.21858E+00_JPRB, &
 & 0.22305E+00_JPRB,0.21661E+00_JPRB,0.19799E+00_JPRB,0.14234E+00_JPRB /)  
KA(:, 2, 7, 6) = (/ &
 & 0.39495E-01_JPRB,0.13775E+00_JPRB,0.18255E+00_JPRB,0.21017E+00_JPRB,0.22506E+00_JPRB, &
 & 0.22828E+00_JPRB,0.22063E+00_JPRB,0.20115E+00_JPRB,0.14469E+00_JPRB /)  
KA(:, 3, 7, 6) = (/ &
 & 0.46213E-01_JPRB,0.14677E+00_JPRB,0.19104E+00_JPRB,0.21747E+00_JPRB,0.23085E+00_JPRB, &
 & 0.23293E+00_JPRB,0.22444E+00_JPRB,0.20438E+00_JPRB,0.14721E+00_JPRB /)  
KA(:, 4, 7, 6) = (/ &
 & 0.53881E-01_JPRB,0.15604E+00_JPRB,0.19912E+00_JPRB,0.22407E+00_JPRB,0.23606E+00_JPRB, &
 & 0.23711E+00_JPRB,0.22803E+00_JPRB,0.20793E+00_JPRB,0.14967E+00_JPRB /)  
KA(:, 5, 7, 6) = (/ &
 & 0.62313E-01_JPRB,0.16559E+00_JPRB,0.20703E+00_JPRB,0.23032E+00_JPRB,0.24086E+00_JPRB, &
 & 0.24109E+00_JPRB,0.23183E+00_JPRB,0.21164E+00_JPRB,0.15187E+00_JPRB /)  
KA(:, 1, 8, 6) = (/ &
 & 0.27294E-01_JPRB,0.10784E+00_JPRB,0.14673E+00_JPRB,0.17152E+00_JPRB,0.18541E+00_JPRB, &
 & 0.18896E+00_JPRB,0.18302E+00_JPRB,0.16686E+00_JPRB,0.11892E+00_JPRB /)  
KA(:, 2, 8, 6) = (/ &
 & 0.31945E-01_JPRB,0.11533E+00_JPRB,0.15437E+00_JPRB,0.17841E+00_JPRB,0.19097E+00_JPRB, &
 & 0.19348E+00_JPRB,0.18650E+00_JPRB,0.16969E+00_JPRB,0.12123E+00_JPRB /)  
KA(:, 3, 8, 6) = (/ &
 & 0.37290E-01_JPRB,0.12309E+00_JPRB,0.16174E+00_JPRB,0.18467E+00_JPRB,0.19597E+00_JPRB, &
 & 0.19753E+00_JPRB,0.18983E+00_JPRB,0.17262E+00_JPRB,0.12344E+00_JPRB /)  
KA(:, 4, 8, 6) = (/ &
 & 0.43331E-01_JPRB,0.13110E+00_JPRB,0.16878E+00_JPRB,0.19044E+00_JPRB,0.20053E+00_JPRB, &
 & 0.20117E+00_JPRB,0.19304E+00_JPRB,0.17581E+00_JPRB,0.12571E+00_JPRB /)  
KA(:, 5, 8, 6) = (/ &
 & 0.50086E-01_JPRB,0.13937E+00_JPRB,0.17577E+00_JPRB,0.19586E+00_JPRB,0.20476E+00_JPRB, &
 & 0.20472E+00_JPRB,0.19647E+00_JPRB,0.17915E+00_JPRB,0.12770E+00_JPRB /)  
KA(:, 1, 9, 6) = (/ &
 & 0.21763E-01_JPRB,0.89580E-01_JPRB,0.12270E+00_JPRB,0.14431E+00_JPRB,0.15639E+00_JPRB, &
 & 0.15936E+00_JPRB,0.15421E+00_JPRB,0.14030E+00_JPRB,0.10042E+00_JPRB /)  
KA(:, 2, 9, 6) = (/ &
 & 0.25609E-01_JPRB,0.95974E-01_JPRB,0.12925E+00_JPRB,0.15030E+00_JPRB,0.16119E+00_JPRB, &
 & 0.16326E+00_JPRB,0.15719E+00_JPRB,0.14283E+00_JPRB,0.10252E+00_JPRB /)  
KA(:, 3, 9, 6) = (/ &
 & 0.30067E-01_JPRB,0.10261E+00_JPRB,0.13551E+00_JPRB,0.15572E+00_JPRB,0.16552E+00_JPRB, &
 & 0.16675E+00_JPRB,0.16007E+00_JPRB,0.14539E+00_JPRB,0.10448E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART4',1,ZHOOK_HANDLE)
END SUBROUTINE PART4


SUBROUTINE PART5

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART5',0,ZHOOK_HANDLE)


KA(:, 4, 9, 6) = (/ &
 & 0.35097E-01_JPRB,0.10949E+00_JPRB,0.14161E+00_JPRB,0.16075E+00_JPRB,0.16947E+00_JPRB, &
 & 0.16997E+00_JPRB,0.16297E+00_JPRB,0.14823E+00_JPRB,0.10645E+00_JPRB /)  
KA(:, 5, 9, 6) = (/ &
 & 0.40711E-01_JPRB,0.11658E+00_JPRB,0.14773E+00_JPRB,0.16552E+00_JPRB,0.17324E+00_JPRB, &
 & 0.17317E+00_JPRB,0.16604E+00_JPRB,0.15112E+00_JPRB,0.10826E+00_JPRB /)  
KA(:, 1,10, 6) = (/ &
 & 0.17370E-01_JPRB,0.74466E-01_JPRB,0.10240E+00_JPRB,0.12053E+00_JPRB,0.13126E+00_JPRB, &
 & 0.13417E+00_JPRB,0.12989E+00_JPRB,0.11790E+00_JPRB,0.87103E-01_JPRB /)  
KA(:, 2,10, 6) = (/ &
 & 0.20536E-01_JPRB,0.79866E-01_JPRB,0.10796E+00_JPRB,0.12568E+00_JPRB,0.13547E+00_JPRB, &
 & 0.13755E+00_JPRB,0.13244E+00_JPRB,0.12017E+00_JPRB,0.88680E-01_JPRB /)  
KA(:, 3,10, 6) = (/ &
 & 0.24274E-01_JPRB,0.85524E-01_JPRB,0.11324E+00_JPRB,0.13036E+00_JPRB,0.13925E+00_JPRB, &
 & 0.14055E+00_JPRB,0.13491E+00_JPRB,0.12243E+00_JPRB,0.90062E-01_JPRB /)  
KA(:, 4,10, 6) = (/ &
 & 0.28508E-01_JPRB,0.91420E-01_JPRB,0.11852E+00_JPRB,0.13467E+00_JPRB,0.14267E+00_JPRB, &
 & 0.14339E+00_JPRB,0.13748E+00_JPRB,0.12487E+00_JPRB,0.91240E-01_JPRB /)  
KA(:, 5,10, 6) = (/ &
 & 0.33217E-01_JPRB,0.97522E-01_JPRB,0.12382E+00_JPRB,0.13886E+00_JPRB,0.14603E+00_JPRB, &
 & 0.14625E+00_JPRB,0.14015E+00_JPRB,0.12740E+00_JPRB,0.92631E-01_JPRB /)  
KA(:, 1,11, 6) = (/ &
 & 0.14918E-01_JPRB,0.64249E-01_JPRB,0.87193E-01_JPRB,0.10225E+00_JPRB,0.11107E+00_JPRB, &
 & 0.11380E+00_JPRB,0.11017E+00_JPRB,0.99775E-01_JPRB,0.75883E-01_JPRB /)  
KA(:, 2,11, 6) = (/ &
 & 0.17707E-01_JPRB,0.68887E-01_JPRB,0.91783E-01_JPRB,0.10653E+00_JPRB,0.11454E+00_JPRB, &
 & 0.11659E+00_JPRB,0.11231E+00_JPRB,0.10178E+00_JPRB,0.77400E-01_JPRB /)  
KA(:, 3,11, 6) = (/ &
 & 0.20985E-01_JPRB,0.73723E-01_JPRB,0.96290E-01_JPRB,0.11038E+00_JPRB,0.11765E+00_JPRB, &
 & 0.11911E+00_JPRB,0.11446E+00_JPRB,0.10377E+00_JPRB,0.78827E-01_JPRB /)  
KA(:, 4,11, 6) = (/ &
 & 0.24698E-01_JPRB,0.78820E-01_JPRB,0.10085E+00_JPRB,0.11403E+00_JPRB,0.12064E+00_JPRB, &
 & 0.12159E+00_JPRB,0.11674E+00_JPRB,0.10593E+00_JPRB,0.80678E-01_JPRB /)  
KA(:, 5,11, 6) = (/ &
 & 0.28798E-01_JPRB,0.84087E-01_JPRB,0.10545E+00_JPRB,0.11772E+00_JPRB,0.12367E+00_JPRB, &
 & 0.12416E+00_JPRB,0.11916E+00_JPRB,0.10818E+00_JPRB,0.82090E-01_JPRB /)  
KA(:, 1,12, 6) = (/ &
 & 0.12778E-01_JPRB,0.55028E-01_JPRB,0.74326E-01_JPRB,0.86458E-01_JPRB,0.93690E-01_JPRB, &
 & 0.95887E-01_JPRB,0.92996E-01_JPRB,0.84239E-01_JPRB,0.65531E-01_JPRB /)  
KA(:, 2,12, 6) = (/ &
 & 0.15226E-01_JPRB,0.59056E-01_JPRB,0.78180E-01_JPRB,0.90004E-01_JPRB,0.96562E-01_JPRB, &
 & 0.98210E-01_JPRB,0.94824E-01_JPRB,0.85996E-01_JPRB,0.67232E-01_JPRB /)  
KA(:, 3,12, 6) = (/ &
 & 0.18073E-01_JPRB,0.63328E-01_JPRB,0.81993E-01_JPRB,0.93245E-01_JPRB,0.99175E-01_JPRB, &
 & 0.10034E+00_JPRB,0.96751E-01_JPRB,0.87779E-01_JPRB,0.68728E-01_JPRB /)  
KA(:, 4,12, 6) = (/ &
 & 0.21287E-01_JPRB,0.67814E-01_JPRB,0.85944E-01_JPRB,0.96446E-01_JPRB,0.10181E+00_JPRB, &
 & 0.10253E+00_JPRB,0.98787E-01_JPRB,0.89700E-01_JPRB,0.70024E-01_JPRB /)  
KA(:, 5,12, 6) = (/ &
 & 0.24810E-01_JPRB,0.72405E-01_JPRB,0.89913E-01_JPRB,0.99700E-01_JPRB,0.10454E+00_JPRB, &
 & 0.10492E+00_JPRB,0.10099E+00_JPRB,0.91662E-01_JPRB,0.71222E-01_JPRB /)  
KA(:, 1,13, 6) = (/ &
 & 0.10897E-01_JPRB,0.46824E-01_JPRB,0.63070E-01_JPRB,0.73198E-01_JPRB,0.78826E-01_JPRB, &
 & 0.80547E-01_JPRB,0.78087E-01_JPRB,0.70945E-01_JPRB,0.55427E-01_JPRB /)  
KA(:, 2,13, 6) = (/ &
 & 0.13037E-01_JPRB,0.50331E-01_JPRB,0.66369E-01_JPRB,0.76169E-01_JPRB,0.81229E-01_JPRB, &
 & 0.82485E-01_JPRB,0.79688E-01_JPRB,0.72492E-01_JPRB,0.56776E-01_JPRB /)  
KA(:, 3,13, 6) = (/ &
 & 0.15498E-01_JPRB,0.54103E-01_JPRB,0.69687E-01_JPRB,0.78968E-01_JPRB,0.83486E-01_JPRB, &
 & 0.84334E-01_JPRB,0.81403E-01_JPRB,0.74109E-01_JPRB,0.57973E-01_JPRB /)  
KA(:, 4,13, 6) = (/ &
 & 0.18239E-01_JPRB,0.58007E-01_JPRB,0.73146E-01_JPRB,0.81751E-01_JPRB,0.85842E-01_JPRB, &
 & 0.86346E-01_JPRB,0.83244E-01_JPRB,0.75789E-01_JPRB,0.59123E-01_JPRB /)  
KA(:, 5,13, 6) = (/ &
 & 0.21231E-01_JPRB,0.61947E-01_JPRB,0.76584E-01_JPRB,0.84579E-01_JPRB,0.88268E-01_JPRB, &
 & 0.88508E-01_JPRB,0.85245E-01_JPRB,0.77486E-01_JPRB,0.60191E-01_JPRB /)  
KA(:, 1, 1, 7) = (/ &
 & 0.71609E+00_JPRB,0.10081E+01_JPRB,0.11118E+01_JPRB,0.11603E+01_JPRB,0.11765E+01_JPRB, &
 & 0.11643E+01_JPRB,0.11202E+01_JPRB,0.10296E+01_JPRB,0.82502E+00_JPRB /)  
KA(:, 2, 1, 7) = (/ &
 & 0.75920E+00_JPRB,0.10292E+01_JPRB,0.11252E+01_JPRB,0.11685E+01_JPRB,0.11822E+01_JPRB, &
 & 0.11684E+01_JPRB,0.11228E+01_JPRB,0.10318E+01_JPRB,0.83157E+00_JPRB /)  
KA(:, 3, 1, 7) = (/ &
 & 0.79807E+00_JPRB,0.10500E+01_JPRB,0.11397E+01_JPRB,0.11794E+01_JPRB,0.11904E+01_JPRB, &
 & 0.11740E+01_JPRB,0.11264E+01_JPRB,0.10343E+01_JPRB,0.83726E+00_JPRB /)  
KA(:, 4, 1, 7) = (/ &
 & 0.83183E+00_JPRB,0.10700E+01_JPRB,0.11548E+01_JPRB,0.11918E+01_JPRB,0.12010E+01_JPRB, &
 & 0.11815E+01_JPRB,0.11313E+01_JPRB,0.10364E+01_JPRB,0.84249E+00_JPRB /)  
KA(:, 5, 1, 7) = (/ &
 & 0.86161E+00_JPRB,0.10887E+01_JPRB,0.11706E+01_JPRB,0.12061E+01_JPRB,0.12126E+01_JPRB, &
 & 0.11904E+01_JPRB,0.11363E+01_JPRB,0.10383E+01_JPRB,0.84713E+00_JPRB /)  
KA(:, 1, 2, 7) = (/ &
 & 0.62079E+00_JPRB,0.89078E+00_JPRB,0.98349E+00_JPRB,0.10275E+01_JPRB,0.10413E+01_JPRB, &
 & 0.10318E+01_JPRB,0.99528E+00_JPRB,0.92037E+00_JPRB,0.72464E+00_JPRB /)  
KA(:, 2, 2, 7) = (/ &
 & 0.65800E+00_JPRB,0.91114E+00_JPRB,0.99789E+00_JPRB,0.10381E+01_JPRB,0.10488E+01_JPRB, &
 & 0.10378E+01_JPRB,0.99952E+00_JPRB,0.92364E+00_JPRB,0.73140E+00_JPRB /)  
KA(:, 3, 2, 7) = (/ &
 & 0.69092E+00_JPRB,0.93058E+00_JPRB,0.10122E+01_JPRB,0.10502E+01_JPRB,0.10590E+01_JPRB, &
 & 0.10454E+01_JPRB,0.10054E+01_JPRB,0.92699E+00_JPRB,0.73764E+00_JPRB /)  
KA(:, 4, 2, 7) = (/ &
 & 0.71970E+00_JPRB,0.94840E+00_JPRB,0.10270E+01_JPRB,0.10636E+01_JPRB,0.10709E+01_JPRB, &
 & 0.10547E+01_JPRB,0.10116E+01_JPRB,0.93021E+00_JPRB,0.74329E+00_JPRB /)  
KA(:, 5, 2, 7) = (/ &
 & 0.74579E+00_JPRB,0.96581E+00_JPRB,0.10421E+01_JPRB,0.10781E+01_JPRB,0.10844E+01_JPRB, &
 & 0.10644E+01_JPRB,0.10185E+01_JPRB,0.93369E+00_JPRB,0.74789E+00_JPRB /)  
KA(:, 1, 3, 7) = (/ &
 & 0.52823E+00_JPRB,0.77783E+00_JPRB,0.86297E+00_JPRB,0.90265E+00_JPRB,0.91464E+00_JPRB, &
 & 0.90839E+00_JPRB,0.87923E+00_JPRB,0.81632E+00_JPRB,0.63067E+00_JPRB /)  
KA(:, 2, 3, 7) = (/ &
 & 0.56021E+00_JPRB,0.79652E+00_JPRB,0.87677E+00_JPRB,0.91375E+00_JPRB,0.92363E+00_JPRB, &
 & 0.91571E+00_JPRB,0.88529E+00_JPRB,0.82096E+00_JPRB,0.63740E+00_JPRB /)  
KA(:, 3, 3, 7) = (/ &
 & 0.58848E+00_JPRB,0.81389E+00_JPRB,0.89039E+00_JPRB,0.92584E+00_JPRB,0.93460E+00_JPRB, &
 & 0.92486E+00_JPRB,0.89232E+00_JPRB,0.82527E+00_JPRB,0.64377E+00_JPRB /)  
KA(:, 4, 3, 7) = (/ &
 & 0.61369E+00_JPRB,0.83008E+00_JPRB,0.90459E+00_JPRB,0.93860E+00_JPRB,0.94727E+00_JPRB, &
 & 0.93485E+00_JPRB,0.89989E+00_JPRB,0.82959E+00_JPRB,0.64921E+00_JPRB /)  
KA(:, 5, 3, 7) = (/ &
 & 0.63687E+00_JPRB,0.84580E+00_JPRB,0.91897E+00_JPRB,0.95268E+00_JPRB,0.96085E+00_JPRB, &
 & 0.94565E+00_JPRB,0.90780E+00_JPRB,0.83380E+00_JPRB,0.65367E+00_JPRB /)  
KA(:, 1, 4, 7) = (/ &
 & 0.44508E+00_JPRB,0.67351E+00_JPRB,0.75154E+00_JPRB,0.78756E+00_JPRB,0.79977E+00_JPRB, &
 & 0.79563E+00_JPRB,0.77123E+00_JPRB,0.71868E+00_JPRB,0.54794E+00_JPRB /)  
KA(:, 2, 4, 7) = (/ &
 & 0.47271E+00_JPRB,0.69026E+00_JPRB,0.76424E+00_JPRB,0.79840E+00_JPRB,0.80928E+00_JPRB, &
 & 0.80400E+00_JPRB,0.77859E+00_JPRB,0.72416E+00_JPRB,0.55496E+00_JPRB /)  
KA(:, 3, 4, 7) = (/ &
 & 0.49708E+00_JPRB,0.70580E+00_JPRB,0.77670E+00_JPRB,0.80989E+00_JPRB,0.82043E+00_JPRB, &
 & 0.81421E+00_JPRB,0.78653E+00_JPRB,0.72918E+00_JPRB,0.56105E+00_JPRB /)  
KA(:, 4, 4, 7) = (/ &
 & 0.51921E+00_JPRB,0.72040E+00_JPRB,0.78970E+00_JPRB,0.82209E+00_JPRB,0.83296E+00_JPRB, &
 & 0.82477E+00_JPRB,0.79492E+00_JPRB,0.73435E+00_JPRB,0.56612E+00_JPRB /)  
KA(:, 5, 4, 7) = (/ &
 & 0.53991E+00_JPRB,0.73468E+00_JPRB,0.80284E+00_JPRB,0.83540E+00_JPRB,0.84599E+00_JPRB, &
 & 0.83588E+00_JPRB,0.80349E+00_JPRB,0.73920E+00_JPRB,0.57048E+00_JPRB /)  
KA(:, 1, 5, 7) = (/ &
 & 0.37413E+00_JPRB,0.58022E+00_JPRB,0.65026E+00_JPRB,0.68370E+00_JPRB,0.69632E+00_JPRB, &
 & 0.69319E+00_JPRB,0.67239E+00_JPRB,0.62755E+00_JPRB,0.47517E+00_JPRB /)  
KA(:, 2, 5, 7) = (/ &
 & 0.39785E+00_JPRB,0.59500E+00_JPRB,0.66160E+00_JPRB,0.69388E+00_JPRB,0.70581E+00_JPRB, &
 & 0.70224E+00_JPRB,0.68037E+00_JPRB,0.63372E+00_JPRB,0.48187E+00_JPRB /)  
KA(:, 3, 5, 7) = (/ &
 & 0.41894E+00_JPRB,0.60858E+00_JPRB,0.67282E+00_JPRB,0.70454E+00_JPRB,0.71693E+00_JPRB, &
 & 0.71249E+00_JPRB,0.68889E+00_JPRB,0.63962E+00_JPRB,0.48765E+00_JPRB /)  
KA(:, 4, 5, 7) = (/ &
 & 0.43810E+00_JPRB,0.62138E+00_JPRB,0.68416E+00_JPRB,0.71639E+00_JPRB,0.72873E+00_JPRB, &
 & 0.72302E+00_JPRB,0.69785E+00_JPRB,0.64510E+00_JPRB,0.49243E+00_JPRB /)  
KA(:, 5, 5, 7) = (/ &
 & 0.45627E+00_JPRB,0.63437E+00_JPRB,0.69610E+00_JPRB,0.72855E+00_JPRB,0.74096E+00_JPRB, &
 & 0.73385E+00_JPRB,0.70672E+00_JPRB,0.65052E+00_JPRB,0.49657E+00_JPRB /)  
KA(:, 1, 6, 7) = (/ &
 & 0.31382E+00_JPRB,0.49799E+00_JPRB,0.55977E+00_JPRB,0.58971E+00_JPRB,0.60230E+00_JPRB, &
 & 0.60065E+00_JPRB,0.58267E+00_JPRB,0.54392E+00_JPRB,0.40911E+00_JPRB /)  
KA(:, 2, 6, 7) = (/ &
 & 0.33427E+00_JPRB,0.51077E+00_JPRB,0.56976E+00_JPRB,0.59903E+00_JPRB,0.61148E+00_JPRB, &
 & 0.60961E+00_JPRB,0.59093E+00_JPRB,0.55057E+00_JPRB,0.41554E+00_JPRB /)  
KA(:, 3, 6, 7) = (/ &
 & 0.35247E+00_JPRB,0.52249E+00_JPRB,0.57948E+00_JPRB,0.60895E+00_JPRB,0.62185E+00_JPRB, &
 & 0.61942E+00_JPRB,0.59984E+00_JPRB,0.55707E+00_JPRB,0.42096E+00_JPRB /)  
KA(:, 4, 6, 7) = (/ &
 & 0.36909E+00_JPRB,0.53360E+00_JPRB,0.58950E+00_JPRB,0.61977E+00_JPRB,0.63265E+00_JPRB, &
 & 0.62957E+00_JPRB,0.60872E+00_JPRB,0.56306E+00_JPRB,0.42549E+00_JPRB /)  
KA(:, 5, 6, 7) = (/ &
 & 0.38489E+00_JPRB,0.54511E+00_JPRB,0.60025E+00_JPRB,0.63086E+00_JPRB,0.64395E+00_JPRB, &
 & 0.63979E+00_JPRB,0.61739E+00_JPRB,0.56897E+00_JPRB,0.42951E+00_JPRB /)  
KA(:, 1, 7, 7) = (/ &
 & 0.26224E+00_JPRB,0.42663E+00_JPRB,0.48031E+00_JPRB,0.50651E+00_JPRB,0.51797E+00_JPRB, &
 & 0.51738E+00_JPRB,0.50230E+00_JPRB,0.46824E+00_JPRB,0.34967E+00_JPRB /)  
KA(:, 2, 7, 7) = (/ &
 & 0.28013E+00_JPRB,0.43764E+00_JPRB,0.48906E+00_JPRB,0.51485E+00_JPRB,0.52656E+00_JPRB, &
 & 0.52602E+00_JPRB,0.51065E+00_JPRB,0.47517E+00_JPRB,0.35569E+00_JPRB /)  
KA(:, 3, 7, 7) = (/ &
 & 0.29592E+00_JPRB,0.44770E+00_JPRB,0.49758E+00_JPRB,0.52367E+00_JPRB,0.53583E+00_JPRB, &
 & 0.53525E+00_JPRB,0.51944E+00_JPRB,0.48175E+00_JPRB,0.36089E+00_JPRB /)  
KA(:, 4, 7, 7) = (/ &
 & 0.31035E+00_JPRB,0.45721E+00_JPRB,0.50658E+00_JPRB,0.53311E+00_JPRB,0.54562E+00_JPRB, &
 & 0.54468E+00_JPRB,0.52799E+00_JPRB,0.48800E+00_JPRB,0.36523E+00_JPRB /)  
KA(:, 5, 7, 7) = (/ &
 & 0.32410E+00_JPRB,0.46702E+00_JPRB,0.51628E+00_JPRB,0.54315E+00_JPRB,0.55572E+00_JPRB, &
 & 0.55402E+00_JPRB,0.53619E+00_JPRB,0.49402E+00_JPRB,0.36906E+00_JPRB /)  
KA(:, 1, 8, 7) = (/ &
 & 0.21802E+00_JPRB,0.36523E+00_JPRB,0.41109E+00_JPRB,0.43388E+00_JPRB,0.44363E+00_JPRB, &
 & 0.44316E+00_JPRB,0.43058E+00_JPRB,0.40065E+00_JPRB,0.29668E+00_JPRB /)  
KA(:, 2, 8, 7) = (/ &
 & 0.23315E+00_JPRB,0.37455E+00_JPRB,0.41894E+00_JPRB,0.44116E+00_JPRB,0.45154E+00_JPRB, &
 & 0.45134E+00_JPRB,0.43880E+00_JPRB,0.40751E+00_JPRB,0.30231E+00_JPRB /)  
KA(:, 3, 8, 7) = (/ &
 & 0.24686E+00_JPRB,0.38301E+00_JPRB,0.42637E+00_JPRB,0.44889E+00_JPRB,0.45978E+00_JPRB, &
 & 0.45969E+00_JPRB,0.44700E+00_JPRB,0.41408E+00_JPRB,0.30721E+00_JPRB /)  
KA(:, 4, 8, 7) = (/ &
 & 0.25967E+00_JPRB,0.39102E+00_JPRB,0.43427E+00_JPRB,0.45708E+00_JPRB,0.46833E+00_JPRB, &
 & 0.46819E+00_JPRB,0.45488E+00_JPRB,0.42031E+00_JPRB,0.31131E+00_JPRB /)  
KA(:, 5, 8, 7) = (/ &
 & 0.27188E+00_JPRB,0.39949E+00_JPRB,0.44272E+00_JPRB,0.46608E+00_JPRB,0.47706E+00_JPRB, &
 & 0.47653E+00_JPRB,0.46230E+00_JPRB,0.42618E+00_JPRB,0.31504E+00_JPRB /)  
KA(:, 1, 9, 7) = (/ &
 & 0.18022E+00_JPRB,0.31183E+00_JPRB,0.35120E+00_JPRB,0.37079E+00_JPRB,0.37884E+00_JPRB, &
 & 0.37804E+00_JPRB,0.36693E+00_JPRB,0.34063E+00_JPRB,0.24612E+00_JPRB /)  
KA(:, 2, 9, 7) = (/ &
 & 0.19307E+00_JPRB,0.31966E+00_JPRB,0.35801E+00_JPRB,0.37712E+00_JPRB,0.38585E+00_JPRB, &
 & 0.38558E+00_JPRB,0.37468E+00_JPRB,0.34716E+00_JPRB,0.25138E+00_JPRB /)  
KA(:, 3, 9, 7) = (/ &
 & 0.20463E+00_JPRB,0.32683E+00_JPRB,0.36444E+00_JPRB,0.38387E+00_JPRB,0.39308E+00_JPRB, &
 & 0.39294E+00_JPRB,0.38210E+00_JPRB,0.35364E+00_JPRB,0.25593E+00_JPRB /)  
KA(:, 4, 9, 7) = (/ &
 & 0.21550E+00_JPRB,0.33367E+00_JPRB,0.37119E+00_JPRB,0.39103E+00_JPRB,0.40042E+00_JPRB, &
 & 0.40039E+00_JPRB,0.38916E+00_JPRB,0.35964E+00_JPRB,0.25996E+00_JPRB /)  
KA(:, 5, 9, 7) = (/ &
 & 0.22607E+00_JPRB,0.34108E+00_JPRB,0.37860E+00_JPRB,0.39875E+00_JPRB,0.40805E+00_JPRB, &
 & 0.40762E+00_JPRB,0.39578E+00_JPRB,0.36518E+00_JPRB,0.26360E+00_JPRB /)  
KA(:, 1,10, 7) = (/ &
 & 0.14867E+00_JPRB,0.26554E+00_JPRB,0.29985E+00_JPRB,0.31657E+00_JPRB,0.32318E+00_JPRB, &
 & 0.32201E+00_JPRB,0.31162E+00_JPRB,0.28815E+00_JPRB,0.21732E+00_JPRB /)  
KA(:, 2,10, 7) = (/ &
 & 0.15961E+00_JPRB,0.27217E+00_JPRB,0.30555E+00_JPRB,0.32206E+00_JPRB,0.32938E+00_JPRB, &
 & 0.32864E+00_JPRB,0.31877E+00_JPRB,0.29424E+00_JPRB,0.22230E+00_JPRB /)  
KA(:, 3,10, 7) = (/ &
 & 0.16940E+00_JPRB,0.27829E+00_JPRB,0.31116E+00_JPRB,0.32786E+00_JPRB,0.33559E+00_JPRB, &
 & 0.33509E+00_JPRB,0.32534E+00_JPRB,0.30046E+00_JPRB,0.22643E+00_JPRB /)  
KA(:, 4,10, 7) = (/ &
 & 0.17863E+00_JPRB,0.28410E+00_JPRB,0.31692E+00_JPRB,0.33409E+00_JPRB,0.34189E+00_JPRB, &
 & 0.34154E+00_JPRB,0.33152E+00_JPRB,0.30607E+00_JPRB,0.23022E+00_JPRB /)  
KA(:, 5,10, 7) = (/ &
 & 0.18774E+00_JPRB,0.29050E+00_JPRB,0.32341E+00_JPRB,0.34075E+00_JPRB,0.34846E+00_JPRB, &
 & 0.34771E+00_JPRB,0.33731E+00_JPRB,0.31120E+00_JPRB,0.23340E+00_JPRB /)  
KA(:, 1,11, 7) = (/ &
 & 0.12627E+00_JPRB,0.22669E+00_JPRB,0.25719E+00_JPRB,0.27172E+00_JPRB,0.27732E+00_JPRB, &
 & 0.27601E+00_JPRB,0.26659E+00_JPRB,0.24512E+00_JPRB,0.18584E+00_JPRB /)  
KA(:, 2,11, 7) = (/ &
 & 0.13516E+00_JPRB,0.23214E+00_JPRB,0.26193E+00_JPRB,0.27653E+00_JPRB,0.28265E+00_JPRB, &
 & 0.28160E+00_JPRB,0.27265E+00_JPRB,0.25095E+00_JPRB,0.18968E+00_JPRB /)  
KA(:, 3,11, 7) = (/ &
 & 0.14321E+00_JPRB,0.23722E+00_JPRB,0.26679E+00_JPRB,0.28162E+00_JPRB,0.28797E+00_JPRB, &
 & 0.28724E+00_JPRB,0.27822E+00_JPRB,0.25645E+00_JPRB,0.19293E+00_JPRB /)  
KA(:, 4,11, 7) = (/ &
 & 0.15107E+00_JPRB,0.24247E+00_JPRB,0.27199E+00_JPRB,0.28706E+00_JPRB,0.29346E+00_JPRB, &
 & 0.29269E+00_JPRB,0.28343E+00_JPRB,0.26131E+00_JPRB,0.19541E+00_JPRB /)  
KA(:, 5,11, 7) = (/ &
 & 0.15896E+00_JPRB,0.24837E+00_JPRB,0.27786E+00_JPRB,0.29309E+00_JPRB,0.29929E+00_JPRB, &
 & 0.29804E+00_JPRB,0.28838E+00_JPRB,0.26594E+00_JPRB,0.19802E+00_JPRB /)  
KA(:, 1,12, 7) = (/ &
 & 0.10682E+00_JPRB,0.19256E+00_JPRB,0.21863E+00_JPRB,0.23192E+00_JPRB,0.23695E+00_JPRB, &
 & 0.23560E+00_JPRB,0.22744E+00_JPRB,0.20844E+00_JPRB,0.16014E+00_JPRB /)  
KA(:, 2,12, 7) = (/ &
 & 0.11409E+00_JPRB,0.19699E+00_JPRB,0.22274E+00_JPRB,0.23606E+00_JPRB,0.24149E+00_JPRB, &
 & 0.24040E+00_JPRB,0.23256E+00_JPRB,0.21367E+00_JPRB,0.16300E+00_JPRB /)  
KA(:, 3,12, 7) = (/ &
 & 0.12093E+00_JPRB,0.20128E+00_JPRB,0.22702E+00_JPRB,0.24050E+00_JPRB,0.24609E+00_JPRB, &
 & 0.24521E+00_JPRB,0.23721E+00_JPRB,0.21831E+00_JPRB,0.16579E+00_JPRB /)  
KA(:, 4,12, 7) = (/ &
 & 0.12767E+00_JPRB,0.20601E+00_JPRB,0.23174E+00_JPRB,0.24542E+00_JPRB,0.25091E+00_JPRB, &
 & 0.24990E+00_JPRB,0.24163E+00_JPRB,0.22258E+00_JPRB,0.16866E+00_JPRB /)  
KA(:, 5,12, 7) = (/ &
 & 0.13446E+00_JPRB,0.21151E+00_JPRB,0.23730E+00_JPRB,0.25089E+00_JPRB,0.25608E+00_JPRB, &
 & 0.25469E+00_JPRB,0.24607E+00_JPRB,0.22668E+00_JPRB,0.17141E+00_JPRB /)  
KA(:, 1,13, 7) = (/ &
 & 0.90556E-01_JPRB,0.16301E+00_JPRB,0.18506E+00_JPRB,0.19633E+00_JPRB,0.20124E+00_JPRB, &
 & 0.20042E+00_JPRB,0.19353E+00_JPRB,0.17713E+00_JPRB,0.13589E+00_JPRB /)  
KA(:, 2,13, 7) = (/ &
 & 0.96629E-01_JPRB,0.16667E+00_JPRB,0.18855E+00_JPRB,0.19991E+00_JPRB,0.20512E+00_JPRB, &
 & 0.20458E+00_JPRB,0.19781E+00_JPRB,0.18150E+00_JPRB,0.13866E+00_JPRB /)  
KA(:, 3,13, 7) = (/ &
 & 0.10246E+00_JPRB,0.17045E+00_JPRB,0.19232E+00_JPRB,0.20386E+00_JPRB,0.20916E+00_JPRB, &
 & 0.20868E+00_JPRB,0.20175E+00_JPRB,0.18546E+00_JPRB,0.14157E+00_JPRB /)  
KA(:, 4,13, 7) = (/ &
 & 0.10831E+00_JPRB,0.17481E+00_JPRB,0.19664E+00_JPRB,0.20827E+00_JPRB,0.21340E+00_JPRB, &
 & 0.21278E+00_JPRB,0.20565E+00_JPRB,0.18920E+00_JPRB,0.14421E+00_JPRB /)  
KA(:, 5,13, 7) = (/ &
 & 0.11418E+00_JPRB,0.17993E+00_JPRB,0.20190E+00_JPRB,0.21347E+00_JPRB,0.21830E+00_JPRB, &
 & 0.21718E+00_JPRB,0.20964E+00_JPRB,0.19280E+00_JPRB,0.14715E+00_JPRB /)  
KA(:, 1, 1, 8) = (/ &
 & 0.20844E+01_JPRB,0.23344E+01_JPRB,0.25576E+01_JPRB,0.26701E+01_JPRB,0.27010E+01_JPRB, &
 & 0.26681E+01_JPRB,0.25683E+01_JPRB,0.23655E+01_JPRB,0.20810E+01_JPRB /)  
KA(:, 2, 1, 8) = (/ &
 & 0.20807E+01_JPRB,0.23304E+01_JPRB,0.25489E+01_JPRB,0.26611E+01_JPRB,0.26920E+01_JPRB, &
 & 0.26609E+01_JPRB,0.25647E+01_JPRB,0.23645E+01_JPRB,0.20859E+01_JPRB /)  
KA(:, 3, 1, 8) = (/ &
 & 0.20877E+01_JPRB,0.23342E+01_JPRB,0.25477E+01_JPRB,0.26548E+01_JPRB,0.26843E+01_JPRB, &
 & 0.26541E+01_JPRB,0.25605E+01_JPRB,0.23637E+01_JPRB,0.20903E+01_JPRB /)  
KA(:, 4, 1, 8) = (/ &
 & 0.21052E+01_JPRB,0.23454E+01_JPRB,0.25520E+01_JPRB,0.26529E+01_JPRB,0.26778E+01_JPRB, &
 & 0.26478E+01_JPRB,0.25565E+01_JPRB,0.23630E+01_JPRB,0.20935E+01_JPRB /)  
KA(:, 5, 1, 8) = (/ &
 & 0.21303E+01_JPRB,0.23633E+01_JPRB,0.25619E+01_JPRB,0.26546E+01_JPRB,0.26749E+01_JPRB, &
 & 0.26429E+01_JPRB,0.25542E+01_JPRB,0.23619E+01_JPRB,0.20958E+01_JPRB /)  
KA(:, 1, 2, 8) = (/ &
 & 0.18120E+01_JPRB,0.21101E+01_JPRB,0.23204E+01_JPRB,0.24266E+01_JPRB,0.24657E+01_JPRB, &
 & 0.24469E+01_JPRB,0.23702E+01_JPRB,0.21931E+01_JPRB,0.18669E+01_JPRB /)  
KA(:, 2, 2, 8) = (/ &
 & 0.18187E+01_JPRB,0.21137E+01_JPRB,0.23188E+01_JPRB,0.24223E+01_JPRB,0.24620E+01_JPRB, &
 & 0.24436E+01_JPRB,0.23687E+01_JPRB,0.21944E+01_JPRB,0.18726E+01_JPRB /)  
KA(:, 3, 2, 8) = (/ &
 & 0.18356E+01_JPRB,0.21255E+01_JPRB,0.23256E+01_JPRB,0.24232E+01_JPRB,0.24590E+01_JPRB, &
 & 0.24407E+01_JPRB,0.23674E+01_JPRB,0.21960E+01_JPRB,0.18776E+01_JPRB /)  
KA(:, 4, 2, 8) = (/ &
 & 0.18614E+01_JPRB,0.21447E+01_JPRB,0.23386E+01_JPRB,0.24287E+01_JPRB,0.24595E+01_JPRB, &
 & 0.24387E+01_JPRB,0.23672E+01_JPRB,0.21970E+01_JPRB,0.18816E+01_JPRB /)  
KA(:, 5, 2, 8) = (/ &
 & 0.18927E+01_JPRB,0.21683E+01_JPRB,0.23579E+01_JPRB,0.24392E+01_JPRB,0.24636E+01_JPRB, &
 & 0.24407E+01_JPRB,0.23665E+01_JPRB,0.21974E+01_JPRB,0.18864E+01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART5',1,ZHOOK_HANDLE)
END SUBROUTINE PART5


SUBROUTINE PART6

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART6',0,ZHOOK_HANDLE)


KA(:, 1, 3, 8) = (/ &
 & 0.15702E+01_JPRB,0.18942E+01_JPRB,0.20837E+01_JPRB,0.21854E+01_JPRB,0.22324E+01_JPRB, &
 & 0.22266E+01_JPRB,0.21649E+01_JPRB,0.20134E+01_JPRB,0.16617E+01_JPRB /)  
KA(:, 2, 3, 8) = (/ &
 & 0.15827E+01_JPRB,0.19038E+01_JPRB,0.20886E+01_JPRB,0.21865E+01_JPRB,0.22329E+01_JPRB, &
 & 0.22266E+01_JPRB,0.21649E+01_JPRB,0.20167E+01_JPRB,0.16695E+01_JPRB /)  
KA(:, 3, 3, 8) = (/ &
 & 0.16046E+01_JPRB,0.19213E+01_JPRB,0.21019E+01_JPRB,0.21942E+01_JPRB,0.22360E+01_JPRB, &
 & 0.22271E+01_JPRB,0.21665E+01_JPRB,0.20195E+01_JPRB,0.16762E+01_JPRB /)  
KA(:, 4, 3, 8) = (/ &
 & 0.16329E+01_JPRB,0.19443E+01_JPRB,0.21213E+01_JPRB,0.22070E+01_JPRB,0.22424E+01_JPRB, &
 & 0.22311E+01_JPRB,0.21683E+01_JPRB,0.20214E+01_JPRB,0.16830E+01_JPRB /)  
KA(:, 5, 3, 8) = (/ &
 & 0.16658E+01_JPRB,0.19717E+01_JPRB,0.21452E+01_JPRB,0.22251E+01_JPRB,0.22530E+01_JPRB, &
 & 0.22371E+01_JPRB,0.21708E+01_JPRB,0.20238E+01_JPRB,0.16904E+01_JPRB /)  
KA(:, 1, 4, 8) = (/ &
 & 0.13564E+01_JPRB,0.16869E+01_JPRB,0.18550E+01_JPRB,0.19537E+01_JPRB,0.20049E+01_JPRB, &
 & 0.20085E+01_JPRB,0.19601E+01_JPRB,0.18287E+01_JPRB,0.14756E+01_JPRB /)  
KA(:, 2, 4, 8) = (/ &
 & 0.13720E+01_JPRB,0.17000E+01_JPRB,0.18655E+01_JPRB,0.19607E+01_JPRB,0.20100E+01_JPRB, &
 & 0.20105E+01_JPRB,0.19622E+01_JPRB,0.18339E+01_JPRB,0.14854E+01_JPRB /)  
KA(:, 3, 4, 8) = (/ &
 & 0.13952E+01_JPRB,0.17204E+01_JPRB,0.18837E+01_JPRB,0.19740E+01_JPRB,0.20182E+01_JPRB, &
 & 0.20154E+01_JPRB,0.19654E+01_JPRB,0.18384E+01_JPRB,0.14948E+01_JPRB /)  
KA(:, 4, 4, 8) = (/ &
 & 0.14229E+01_JPRB,0.17461E+01_JPRB,0.19072E+01_JPRB,0.19926E+01_JPRB,0.20303E+01_JPRB, &
 & 0.20234E+01_JPRB,0.19691E+01_JPRB,0.18420E+01_JPRB,0.15040E+01_JPRB /)  
KA(:, 5, 4, 8) = (/ &
 & 0.14534E+01_JPRB,0.17751E+01_JPRB,0.19345E+01_JPRB,0.20154E+01_JPRB,0.20467E+01_JPRB, &
 & 0.20337E+01_JPRB,0.19742E+01_JPRB,0.18465E+01_JPRB,0.15131E+01_JPRB /)  
KA(:, 1, 5, 8) = (/ &
 & 0.11675E+01_JPRB,0.14906E+01_JPRB,0.16422E+01_JPRB,0.17364E+01_JPRB,0.17875E+01_JPRB, &
 & 0.17970E+01_JPRB,0.17582E+01_JPRB,0.16459E+01_JPRB,0.13057E+01_JPRB /)  
KA(:, 2, 5, 8) = (/ &
 & 0.11839E+01_JPRB,0.15062E+01_JPRB,0.16573E+01_JPRB,0.17483E+01_JPRB,0.17956E+01_JPRB, &
 & 0.18020E+01_JPRB,0.17623E+01_JPRB,0.16529E+01_JPRB,0.13176E+01_JPRB /)  
KA(:, 3, 5, 8) = (/ &
 & 0.12061E+01_JPRB,0.15281E+01_JPRB,0.16790E+01_JPRB,0.17660E+01_JPRB,0.18082E+01_JPRB, &
 & 0.18106E+01_JPRB,0.17678E+01_JPRB,0.16587E+01_JPRB,0.13289E+01_JPRB /)  
KA(:, 4, 5, 8) = (/ &
 & 0.12311E+01_JPRB,0.15549E+01_JPRB,0.17048E+01_JPRB,0.17877E+01_JPRB,0.18250E+01_JPRB, &
 & 0.18222E+01_JPRB,0.17742E+01_JPRB,0.16644E+01_JPRB,0.13398E+01_JPRB /)  
KA(:, 5, 5, 8) = (/ &
 & 0.12582E+01_JPRB,0.15836E+01_JPRB,0.17338E+01_JPRB,0.18131E+01_JPRB,0.18457E+01_JPRB, &
 & 0.18359E+01_JPRB,0.17826E+01_JPRB,0.16710E+01_JPRB,0.13507E+01_JPRB /)  
KA(:, 1, 6, 8) = (/ &
 & 0.99981E+00_JPRB,0.13080E+01_JPRB,0.14477E+01_JPRB,0.15356E+01_JPRB,0.15829E+01_JPRB, &
 & 0.15936E+01_JPRB,0.15636E+01_JPRB,0.14683E+01_JPRB,0.11482E+01_JPRB /)  
KA(:, 2, 6, 8) = (/ &
 & 0.10151E+01_JPRB,0.13251E+01_JPRB,0.14655E+01_JPRB,0.15504E+01_JPRB,0.15941E+01_JPRB, &
 & 0.16015E+01_JPRB,0.15698E+01_JPRB,0.14767E+01_JPRB,0.11619E+01_JPRB /)  
KA(:, 3, 6, 8) = (/ &
 & 0.10344E+01_JPRB,0.13476E+01_JPRB,0.14887E+01_JPRB,0.15702E+01_JPRB,0.16097E+01_JPRB, &
 & 0.16130E+01_JPRB,0.15772E+01_JPRB,0.14847E+01_JPRB,0.11743E+01_JPRB /)  
KA(:, 4, 6, 8) = (/ &
 & 0.10560E+01_JPRB,0.13735E+01_JPRB,0.15155E+01_JPRB,0.15939E+01_JPRB,0.16293E+01_JPRB, &
 & 0.16276E+01_JPRB,0.15870E+01_JPRB,0.14924E+01_JPRB,0.11864E+01_JPRB /)  
KA(:, 5, 6, 8) = (/ &
 & 0.10794E+01_JPRB,0.13996E+01_JPRB,0.15438E+01_JPRB,0.16205E+01_JPRB,0.16521E+01_JPRB, &
 & 0.16451E+01_JPRB,0.15991E+01_JPRB,0.15003E+01_JPRB,0.11982E+01_JPRB /)  
KA(:, 1, 7, 8) = (/ &
 & 0.85239E+00_JPRB,0.11419E+01_JPRB,0.12714E+01_JPRB,0.13507E+01_JPRB,0.13930E+01_JPRB, &
 & 0.14039E+01_JPRB,0.13790E+01_JPRB,0.12971E+01_JPRB,0.10034E+01_JPRB /)  
KA(:, 2, 7, 8) = (/ &
 & 0.86542E+00_JPRB,0.11591E+01_JPRB,0.12898E+01_JPRB,0.13670E+01_JPRB,0.14062E+01_JPRB, &
 & 0.14139E+01_JPRB,0.13871E+01_JPRB,0.13072E+01_JPRB,0.10179E+01_JPRB /)  
KA(:, 3, 7, 8) = (/ &
 & 0.88108E+00_JPRB,0.11809E+01_JPRB,0.13130E+01_JPRB,0.13880E+01_JPRB,0.14241E+01_JPRB, &
 & 0.14278E+01_JPRB,0.13975E+01_JPRB,0.13172E+01_JPRB,0.10310E+01_JPRB /)  
KA(:, 4, 7, 8) = (/ &
 & 0.89900E+00_JPRB,0.12041E+01_JPRB,0.13390E+01_JPRB,0.14123E+01_JPRB,0.14455E+01_JPRB, &
 & 0.14453E+01_JPRB,0.14105E+01_JPRB,0.13266E+01_JPRB,0.10434E+01_JPRB /)  
KA(:, 5, 7, 8) = (/ &
 & 0.91862E+00_JPRB,0.12279E+01_JPRB,0.13649E+01_JPRB,0.14386E+01_JPRB,0.14692E+01_JPRB, &
 & 0.14664E+01_JPRB,0.14254E+01_JPRB,0.13367E+01_JPRB,0.10558E+01_JPRB /)  
KA(:, 1, 8, 8) = (/ &
 & 0.72497E+00_JPRB,0.99201E+00_JPRB,0.11107E+01_JPRB,0.11813E+01_JPRB,0.12195E+01_JPRB, &
 & 0.12285E+01_JPRB,0.12058E+01_JPRB,0.11359E+01_JPRB,0.87110E+00_JPRB /)  
KA(:, 2, 8, 8) = (/ &
 & 0.73517E+00_JPRB,0.10086E+01_JPRB,0.11285E+01_JPRB,0.11988E+01_JPRB,0.12342E+01_JPRB, &
 & 0.12405E+01_JPRB,0.12160E+01_JPRB,0.11479E+01_JPRB,0.88568E+00_JPRB /)  
KA(:, 3, 8, 8) = (/ &
 & 0.74752E+00_JPRB,0.10285E+01_JPRB,0.11507E+01_JPRB,0.12198E+01_JPRB,0.12532E+01_JPRB, &
 & 0.12570E+01_JPRB,0.12289E+01_JPRB,0.11589E+01_JPRB,0.89927E+00_JPRB /)  
KA(:, 4, 8, 8) = (/ &
 & 0.76213E+00_JPRB,0.10489E+01_JPRB,0.11747E+01_JPRB,0.12436E+01_JPRB,0.12757E+01_JPRB, &
 & 0.12769E+01_JPRB,0.12445E+01_JPRB,0.11700E+01_JPRB,0.91203E+00_JPRB /)  
KA(:, 5, 8, 8) = (/ &
 & 0.77854E+00_JPRB,0.10697E+01_JPRB,0.11980E+01_JPRB,0.12679E+01_JPRB,0.13002E+01_JPRB, &
 & 0.12994E+01_JPRB,0.12621E+01_JPRB,0.11816E+01_JPRB,0.92392E+00_JPRB /)  
KA(:, 1, 9, 8) = (/ &
 & 0.61682E+00_JPRB,0.85841E+00_JPRB,0.96403E+00_JPRB,0.10272E+01_JPRB,0.10606E+01_JPRB, &
 & 0.10679E+01_JPRB,0.10472E+01_JPRB,0.98715E+00_JPRB,0.74825E+00_JPRB /)  
KA(:, 2, 9, 8) = (/ &
 & 0.62415E+00_JPRB,0.87401E+00_JPRB,0.98140E+00_JPRB,0.10446E+01_JPRB,0.10763E+01_JPRB, &
 & 0.10811E+01_JPRB,0.10593E+01_JPRB,0.10003E+01_JPRB,0.76294E+00_JPRB /)  
KA(:, 3, 9, 8) = (/ &
 & 0.63387E+00_JPRB,0.89104E+00_JPRB,0.10022E+01_JPRB,0.10651E+01_JPRB,0.10962E+01_JPRB, &
 & 0.10997E+01_JPRB,0.10740E+01_JPRB,0.10120E+01_JPRB,0.77659E+00_JPRB /)  
KA(:, 4, 9, 8) = (/ &
 & 0.64542E+00_JPRB,0.90872E+00_JPRB,0.10230E+01_JPRB,0.10878E+01_JPRB,0.11188E+01_JPRB, &
 & 0.11207E+01_JPRB,0.10911E+01_JPRB,0.10243E+01_JPRB,0.78905E+00_JPRB /)  
KA(:, 5, 9, 8) = (/ &
 & 0.65900E+00_JPRB,0.92674E+00_JPRB,0.10436E+01_JPRB,0.11103E+01_JPRB,0.11424E+01_JPRB, &
 & 0.11435E+01_JPRB,0.11102E+01_JPRB,0.10375E+01_JPRB,0.80034E+00_JPRB /)  
KA(:, 1,10, 8) = (/ &
 & 0.52547E+00_JPRB,0.74220E+00_JPRB,0.83433E+00_JPRB,0.88890E+00_JPRB,0.91741E+00_JPRB, &
 & 0.92336E+00_JPRB,0.90538E+00_JPRB,0.85311E+00_JPRB,0.64696E+00_JPRB /)  
KA(:, 2,10, 8) = (/ &
 & 0.53064E+00_JPRB,0.75604E+00_JPRB,0.85107E+00_JPRB,0.90584E+00_JPRB,0.93361E+00_JPRB, &
 & 0.93836E+00_JPRB,0.91861E+00_JPRB,0.86626E+00_JPRB,0.66062E+00_JPRB /)  
KA(:, 3,10, 8) = (/ &
 & 0.53809E+00_JPRB,0.77037E+00_JPRB,0.86942E+00_JPRB,0.92562E+00_JPRB,0.95409E+00_JPRB, &
 & 0.95774E+00_JPRB,0.93423E+00_JPRB,0.87871E+00_JPRB,0.67391E+00_JPRB /)  
KA(:, 4,10, 8) = (/ &
 & 0.54734E+00_JPRB,0.78576E+00_JPRB,0.88734E+00_JPRB,0.94634E+00_JPRB,0.97611E+00_JPRB, &
 & 0.97890E+00_JPRB,0.95253E+00_JPRB,0.89191E+00_JPRB,0.68526E+00_JPRB /)  
KA(:, 5,10, 8) = (/ &
 & 0.55842E+00_JPRB,0.80129E+00_JPRB,0.90542E+00_JPRB,0.96675E+00_JPRB,0.99781E+00_JPRB, &
 & 0.10013E+01_JPRB,0.97253E+00_JPRB,0.90597E+00_JPRB,0.69583E+00_JPRB /)  
KA(:, 1,11, 8) = (/ &
 & 0.44902E+00_JPRB,0.64641E+00_JPRB,0.72682E+00_JPRB,0.77295E+00_JPRB,0.79679E+00_JPRB, &
 & 0.80095E+00_JPRB,0.78478E+00_JPRB,0.73880E+00_JPRB,0.57500E+00_JPRB /)  
KA(:, 2,11, 8) = (/ &
 & 0.45343E+00_JPRB,0.65819E+00_JPRB,0.74259E+00_JPRB,0.79030E+00_JPRB,0.81509E+00_JPRB, &
 & 0.81866E+00_JPRB,0.79960E+00_JPRB,0.75137E+00_JPRB,0.58784E+00_JPRB /)  
KA(:, 3,11, 8) = (/ &
 & 0.45968E+00_JPRB,0.67094E+00_JPRB,0.75812E+00_JPRB,0.80898E+00_JPRB,0.83522E+00_JPRB, &
 & 0.83854E+00_JPRB,0.81711E+00_JPRB,0.76461E+00_JPRB,0.59939E+00_JPRB /)  
KA(:, 4,11, 8) = (/ &
 & 0.46764E+00_JPRB,0.68418E+00_JPRB,0.77402E+00_JPRB,0.82711E+00_JPRB,0.85518E+00_JPRB, &
 & 0.85968E+00_JPRB,0.83634E+00_JPRB,0.77859E+00_JPRB,0.60954E+00_JPRB /)  
KA(:, 5,11, 8) = (/ &
 & 0.47750E+00_JPRB,0.69798E+00_JPRB,0.79021E+00_JPRB,0.84534E+00_JPRB,0.87480E+00_JPRB, &
 & 0.88011E+00_JPRB,0.85595E+00_JPRB,0.79269E+00_JPRB,0.61896E+00_JPRB /)  
KA(:, 1,12, 8) = (/ &
 & 0.38252E+00_JPRB,0.56123E+00_JPRB,0.63221E+00_JPRB,0.67207E+00_JPRB,0.69191E+00_JPRB, &
 & 0.69451E+00_JPRB,0.67853E+00_JPRB,0.63671E+00_JPRB,0.49624E+00_JPRB /)  
KA(:, 2,12, 8) = (/ &
 & 0.38610E+00_JPRB,0.57152E+00_JPRB,0.64559E+00_JPRB,0.68857E+00_JPRB,0.70992E+00_JPRB, &
 & 0.71250E+00_JPRB,0.69440E+00_JPRB,0.64948E+00_JPRB,0.50772E+00_JPRB /)  
KA(:, 3,12, 8) = (/ &
 & 0.39135E+00_JPRB,0.58251E+00_JPRB,0.65953E+00_JPRB,0.70459E+00_JPRB,0.72793E+00_JPRB, &
 & 0.73188E+00_JPRB,0.71251E+00_JPRB,0.66314E+00_JPRB,0.51771E+00_JPRB /)  
KA(:, 4,12, 8) = (/ &
 & 0.39838E+00_JPRB,0.59406E+00_JPRB,0.67357E+00_JPRB,0.72066E+00_JPRB,0.74570E+00_JPRB, &
 & 0.75075E+00_JPRB,0.73108E+00_JPRB,0.67696E+00_JPRB,0.52680E+00_JPRB /)  
KA(:, 5,12, 8) = (/ &
 & 0.40785E+00_JPRB,0.60628E+00_JPRB,0.68802E+00_JPRB,0.73685E+00_JPRB,0.76342E+00_JPRB, &
 & 0.76842E+00_JPRB,0.74857E+00_JPRB,0.69135E+00_JPRB,0.53408E+00_JPRB /)  
KA(:, 1,13, 8) = (/ &
 & 0.32297E+00_JPRB,0.48556E+00_JPRB,0.54760E+00_JPRB,0.58350E+00_JPRB,0.60079E+00_JPRB, &
 & 0.60116E+00_JPRB,0.58518E+00_JPRB,0.54699E+00_JPRB,0.42276E+00_JPRB /)  
KA(:, 2,13, 8) = (/ &
 & 0.32591E+00_JPRB,0.49445E+00_JPRB,0.55963E+00_JPRB,0.59764E+00_JPRB,0.61654E+00_JPRB, &
 & 0.61844E+00_JPRB,0.60149E+00_JPRB,0.55973E+00_JPRB,0.43280E+00_JPRB /)  
KA(:, 3,13, 8) = (/ &
 & 0.33057E+00_JPRB,0.50405E+00_JPRB,0.57184E+00_JPRB,0.61186E+00_JPRB,0.63239E+00_JPRB, &
 & 0.63557E+00_JPRB,0.61864E+00_JPRB,0.57305E+00_JPRB,0.44151E+00_JPRB /)  
KA(:, 4,13, 8) = (/ &
 & 0.33705E+00_JPRB,0.51427E+00_JPRB,0.58428E+00_JPRB,0.62614E+00_JPRB,0.64825E+00_JPRB, &
 & 0.65175E+00_JPRB,0.63492E+00_JPRB,0.58689E+00_JPRB,0.44893E+00_JPRB /)  
KA(:, 5,13, 8) = (/ &
 & 0.34636E+00_JPRB,0.52544E+00_JPRB,0.59740E+00_JPRB,0.64055E+00_JPRB,0.66342E+00_JPRB, &
 & 0.66736E+00_JPRB,0.65002E+00_JPRB,0.60055E+00_JPRB,0.45487E+00_JPRB /)  
KA(:, 1, 1, 9) = (/ &
 & 0.72991E+01_JPRB,0.69722E+01_JPRB,0.72863E+01_JPRB,0.75002E+01_JPRB,0.75688E+01_JPRB, &
 & 0.74622E+01_JPRB,0.71020E+01_JPRB,0.65825E+01_JPRB,0.69144E+01_JPRB /)  
KA(:, 2, 1, 9) = (/ &
 & 0.72210E+01_JPRB,0.69084E+01_JPRB,0.72319E+01_JPRB,0.74567E+01_JPRB,0.75409E+01_JPRB, &
 & 0.74459E+01_JPRB,0.71001E+01_JPRB,0.65930E+01_JPRB,0.69213E+01_JPRB /)  
KA(:, 3, 1, 9) = (/ &
 & 0.71481E+01_JPRB,0.68475E+01_JPRB,0.71760E+01_JPRB,0.74130E+01_JPRB,0.75097E+01_JPRB, &
 & 0.74266E+01_JPRB,0.70905E+01_JPRB,0.65992E+01_JPRB,0.69258E+01_JPRB /)  
KA(:, 4, 1, 9) = (/ &
 & 0.70810E+01_JPRB,0.67891E+01_JPRB,0.71222E+01_JPRB,0.73713E+01_JPRB,0.74785E+01_JPRB, &
 & 0.74023E+01_JPRB,0.70766E+01_JPRB,0.66037E+01_JPRB,0.69303E+01_JPRB /)  
KA(:, 5, 1, 9) = (/ &
 & 0.70205E+01_JPRB,0.67342E+01_JPRB,0.70686E+01_JPRB,0.73258E+01_JPRB,0.74436E+01_JPRB, &
 & 0.73740E+01_JPRB,0.70585E+01_JPRB,0.66060E+01_JPRB,0.69339E+01_JPRB /)  
KA(:, 1, 2, 9) = (/ &
 & 0.68023E+01_JPRB,0.66845E+01_JPRB,0.71435E+01_JPRB,0.74293E+01_JPRB,0.75528E+01_JPRB, &
 & 0.74805E+01_JPRB,0.71383E+01_JPRB,0.65087E+01_JPRB,0.66425E+01_JPRB /)  
KA(:, 2, 2, 9) = (/ &
 & 0.67309E+01_JPRB,0.66228E+01_JPRB,0.70899E+01_JPRB,0.73862E+01_JPRB,0.75243E+01_JPRB, &
 & 0.74671E+01_JPRB,0.71358E+01_JPRB,0.65240E+01_JPRB,0.66588E+01_JPRB /)  
KA(:, 3, 2, 9) = (/ &
 & 0.66680E+01_JPRB,0.65659E+01_JPRB,0.70365E+01_JPRB,0.73443E+01_JPRB,0.74954E+01_JPRB, &
 & 0.74486E+01_JPRB,0.71260E+01_JPRB,0.65367E+01_JPRB,0.66745E+01_JPRB /)  
KA(:, 4, 2, 9) = (/ &
 & 0.66136E+01_JPRB,0.65139E+01_JPRB,0.69841E+01_JPRB,0.73016E+01_JPRB,0.74627E+01_JPRB, &
 & 0.74252E+01_JPRB,0.71129E+01_JPRB,0.65455E+01_JPRB,0.66889E+01_JPRB /)  
KA(:, 5, 2, 9) = (/ &
 & 0.65687E+01_JPRB,0.64706E+01_JPRB,0.69322E+01_JPRB,0.72576E+01_JPRB,0.74266E+01_JPRB, &
 & 0.73967E+01_JPRB,0.70986E+01_JPRB,0.65510E+01_JPRB,0.67011E+01_JPRB /)  
KA(:, 1, 3, 9) = (/ &
 & 0.62554E+01_JPRB,0.63717E+01_JPRB,0.69259E+01_JPRB,0.72750E+01_JPRB,0.74339E+01_JPRB, &
 & 0.73812E+01_JPRB,0.70638E+01_JPRB,0.63830E+01_JPRB,0.62738E+01_JPRB /)  
KA(:, 2, 3, 9) = (/ &
 & 0.61935E+01_JPRB,0.63130E+01_JPRB,0.68741E+01_JPRB,0.72340E+01_JPRB,0.74081E+01_JPRB, &
 & 0.73723E+01_JPRB,0.70661E+01_JPRB,0.64055E+01_JPRB,0.63017E+01_JPRB /)  
KA(:, 3, 3, 9) = (/ &
 & 0.61417E+01_JPRB,0.62609E+01_JPRB,0.68234E+01_JPRB,0.71924E+01_JPRB,0.73793E+01_JPRB, &
 & 0.73559E+01_JPRB,0.70613E+01_JPRB,0.64217E+01_JPRB,0.63259E+01_JPRB /)  
KA(:, 4, 3, 9) = (/ &
 & 0.61027E+01_JPRB,0.62184E+01_JPRB,0.67754E+01_JPRB,0.71518E+01_JPRB,0.73493E+01_JPRB, &
 & 0.73341E+01_JPRB,0.70537E+01_JPRB,0.64352E+01_JPRB,0.63471E+01_JPRB /)  
KA(:, 5, 3, 9) = (/ &
 & 0.60751E+01_JPRB,0.61846E+01_JPRB,0.67335E+01_JPRB,0.71090E+01_JPRB,0.73143E+01_JPRB, &
 & 0.73100E+01_JPRB,0.70431E+01_JPRB,0.64459E+01_JPRB,0.63674E+01_JPRB /)  
KA(:, 1, 4, 9) = (/ &
 & 0.56712E+01_JPRB,0.60174E+01_JPRB,0.66407E+01_JPRB,0.70308E+01_JPRB,0.72054E+01_JPRB, &
 & 0.71700E+01_JPRB,0.68768E+01_JPRB,0.62076E+01_JPRB,0.58601E+01_JPRB /)  
KA(:, 2, 4, 9) = (/ &
 & 0.56177E+01_JPRB,0.59637E+01_JPRB,0.65912E+01_JPRB,0.69914E+01_JPRB,0.71823E+01_JPRB, &
 & 0.71644E+01_JPRB,0.68840E+01_JPRB,0.62360E+01_JPRB,0.58965E+01_JPRB /)  
KA(:, 3, 4, 9) = (/ &
 & 0.55798E+01_JPRB,0.59204E+01_JPRB,0.65459E+01_JPRB,0.69532E+01_JPRB,0.71589E+01_JPRB, &
 & 0.71503E+01_JPRB,0.68872E+01_JPRB,0.62571E+01_JPRB,0.59275E+01_JPRB /)  
KA(:, 4, 4, 9) = (/ &
 & 0.55576E+01_JPRB,0.58874E+01_JPRB,0.65057E+01_JPRB,0.69160E+01_JPRB,0.71305E+01_JPRB, &
 & 0.71327E+01_JPRB,0.68860E+01_JPRB,0.62738E+01_JPRB,0.59560E+01_JPRB /)  
KA(:, 5, 4, 9) = (/ &
 & 0.55509E+01_JPRB,0.58664E+01_JPRB,0.64735E+01_JPRB,0.68799E+01_JPRB,0.70989E+01_JPRB, &
 & 0.71129E+01_JPRB,0.68803E+01_JPRB,0.62864E+01_JPRB,0.59817E+01_JPRB /)  
KA(:, 1, 5, 9) = (/ &
 & 0.50748E+01_JPRB,0.56236E+01_JPRB,0.62897E+01_JPRB,0.66937E+01_JPRB,0.68773E+01_JPRB, &
 & 0.68583E+01_JPRB,0.65966E+01_JPRB,0.59739E+01_JPRB,0.54247E+01_JPRB /)  
KA(:, 2, 5, 9) = (/ &
 & 0.50332E+01_JPRB,0.55772E+01_JPRB,0.62435E+01_JPRB,0.66588E+01_JPRB,0.68602E+01_JPRB, &
 & 0.68553E+01_JPRB,0.66099E+01_JPRB,0.60056E+01_JPRB,0.54668E+01_JPRB /)  
KA(:, 3, 5, 9) = (/ &
 & 0.50094E+01_JPRB,0.55429E+01_JPRB,0.62032E+01_JPRB,0.66264E+01_JPRB,0.68392E+01_JPRB, &
 & 0.68457E+01_JPRB,0.66198E+01_JPRB,0.60291E+01_JPRB,0.55024E+01_JPRB /)  
KA(:, 4, 5, 9) = (/ &
 & 0.50054E+01_JPRB,0.55221E+01_JPRB,0.61728E+01_JPRB,0.65959E+01_JPRB,0.68138E+01_JPRB, &
 & 0.68347E+01_JPRB,0.66239E+01_JPRB,0.60504E+01_JPRB,0.55378E+01_JPRB /)  
KA(:, 5, 5, 9) = (/ &
 & 0.50196E+01_JPRB,0.55140E+01_JPRB,0.61502E+01_JPRB,0.65696E+01_JPRB,0.67880E+01_JPRB, &
 & 0.68224E+01_JPRB,0.66232E+01_JPRB,0.60661E+01_JPRB,0.55660E+01_JPRB /)  
KA(:, 1, 6, 9) = (/ &
 & 0.44929E+01_JPRB,0.51985E+01_JPRB,0.58791E+01_JPRB,0.62757E+01_JPRB,0.64716E+01_JPRB, &
 & 0.64669E+01_JPRB,0.62368E+01_JPRB,0.56853E+01_JPRB,0.49792E+01_JPRB /)  
KA(:, 2, 6, 9) = (/ &
 & 0.44612E+01_JPRB,0.51596E+01_JPRB,0.58385E+01_JPRB,0.62487E+01_JPRB,0.64570E+01_JPRB, &
 & 0.64678E+01_JPRB,0.62575E+01_JPRB,0.57196E+01_JPRB,0.50244E+01_JPRB /)  
KA(:, 3, 6, 9) = (/ &
 & 0.44521E+01_JPRB,0.51348E+01_JPRB,0.58071E+01_JPRB,0.62248E+01_JPRB,0.64383E+01_JPRB, &
 & 0.64639E+01_JPRB,0.62747E+01_JPRB,0.57459E+01_JPRB,0.50676E+01_JPRB /)  
KA(:, 4, 6, 9) = (/ &
 & 0.44651E+01_JPRB,0.51248E+01_JPRB,0.57862E+01_JPRB,0.62029E+01_JPRB,0.64206E+01_JPRB, &
 & 0.64594E+01_JPRB,0.62829E+01_JPRB,0.57703E+01_JPRB,0.51061E+01_JPRB /)  
KA(:, 5, 6, 9) = (/ &
 & 0.44974E+01_JPRB,0.51321E+01_JPRB,0.57769E+01_JPRB,0.61847E+01_JPRB,0.64045E+01_JPRB, &
 & 0.64518E+01_JPRB,0.62850E+01_JPRB,0.57880E+01_JPRB,0.51383E+01_JPRB /)  
KA(:, 1, 7, 9) = (/ &
 & 0.39405E+01_JPRB,0.47599E+01_JPRB,0.54183E+01_JPRB,0.58070E+01_JPRB,0.60002E+01_JPRB, &
 & 0.60137E+01_JPRB,0.58231E+01_JPRB,0.53430E+01_JPRB,0.45395E+01_JPRB /)  
KA(:, 2, 7, 9) = (/ &
 & 0.39200E+01_JPRB,0.47279E+01_JPRB,0.53865E+01_JPRB,0.57866E+01_JPRB,0.59900E+01_JPRB, &
 & 0.60178E+01_JPRB,0.58493E+01_JPRB,0.53803E+01_JPRB,0.45897E+01_JPRB /)  
KA(:, 3, 7, 9) = (/ &
 & 0.39243E+01_JPRB,0.47128E+01_JPRB,0.53651E+01_JPRB,0.57689E+01_JPRB,0.59779E+01_JPRB, &
 & 0.60210E+01_JPRB,0.58689E+01_JPRB,0.54093E+01_JPRB,0.46370E+01_JPRB /)  
KA(:, 4, 7, 9) = (/ &
 & 0.39509E+01_JPRB,0.47158E+01_JPRB,0.53566E+01_JPRB,0.57541E+01_JPRB,0.59686E+01_JPRB, &
 & 0.60221E+01_JPRB,0.58794E+01_JPRB,0.54360E+01_JPRB,0.46801E+01_JPRB /)  
KA(:, 5, 7, 9) = (/ &
 & 0.39997E+01_JPRB,0.47365E+01_JPRB,0.53625E+01_JPRB,0.57480E+01_JPRB,0.59641E+01_JPRB, &
 & 0.60191E+01_JPRB,0.58864E+01_JPRB,0.54567E+01_JPRB,0.47154E+01_JPRB /)  
KA(:, 1, 8, 9) = (/ &
 & 0.34277E+01_JPRB,0.43224E+01_JPRB,0.49312E+01_JPRB,0.53036E+01_JPRB,0.54930E+01_JPRB, &
 & 0.55228E+01_JPRB,0.53766E+01_JPRB,0.49651E+01_JPRB,0.41155E+01_JPRB /)  
KA(:, 2, 8, 9) = (/ &
 & 0.34174E+01_JPRB,0.42976E+01_JPRB,0.49104E+01_JPRB,0.52883E+01_JPRB,0.54862E+01_JPRB, &
 & 0.55322E+01_JPRB,0.54048E+01_JPRB,0.50049E+01_JPRB,0.41706E+01_JPRB /)  
KA(:, 3, 8, 9) = (/ &
 & 0.34328E+01_JPRB,0.42901E+01_JPRB,0.49000E+01_JPRB,0.52782E+01_JPRB,0.54821E+01_JPRB, &
 & 0.55409E+01_JPRB,0.54257E+01_JPRB,0.50383E+01_JPRB,0.42218E+01_JPRB /)  
KA(:, 4, 8, 9) = (/ &
 & 0.34724E+01_JPRB,0.43054E+01_JPRB,0.49030E+01_JPRB,0.52739E+01_JPRB,0.54825E+01_JPRB, &
 & 0.55468E+01_JPRB,0.54402E+01_JPRB,0.50678E+01_JPRB,0.42656E+01_JPRB /)  
KA(:, 5, 8, 9) = (/ &
 & 0.35331E+01_JPRB,0.43394E+01_JPRB,0.49199E+01_JPRB,0.52816E+01_JPRB,0.54871E+01_JPRB, &
 & 0.55512E+01_JPRB,0.54505E+01_JPRB,0.50918E+01_JPRB,0.43035E+01_JPRB /)  
KA(:, 1, 9, 9) = (/ &
 & 0.29643E+01_JPRB,0.38841E+01_JPRB,0.44459E+01_JPRB,0.47885E+01_JPRB,0.49734E+01_JPRB, &
 & 0.50221E+01_JPRB,0.49131E+01_JPRB,0.45659E+01_JPRB,0.37057E+01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART6',1,ZHOOK_HANDLE)
END SUBROUTINE PART6


SUBROUTINE PART7

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART7',0,ZHOOK_HANDLE)


KA(:, 2, 9, 9) = (/ &
 & 0.29616E+01_JPRB,0.38662E+01_JPRB,0.44298E+01_JPRB,0.47788E+01_JPRB,0.49743E+01_JPRB, &
 & 0.50365E+01_JPRB,0.49428E+01_JPRB,0.46088E+01_JPRB,0.37656E+01_JPRB /)  
KA(:, 3, 9, 9) = (/ &
 & 0.29848E+01_JPRB,0.38693E+01_JPRB,0.44274E+01_JPRB,0.47752E+01_JPRB,0.49768E+01_JPRB, &
 & 0.50477E+01_JPRB,0.49663E+01_JPRB,0.46464E+01_JPRB,0.38194E+01_JPRB /)  
KA(:, 4, 9, 9) = (/ &
 & 0.30329E+01_JPRB,0.38944E+01_JPRB,0.44404E+01_JPRB,0.47824E+01_JPRB,0.49850E+01_JPRB, &
 & 0.50582E+01_JPRB,0.49851E+01_JPRB,0.46790E+01_JPRB,0.38645E+01_JPRB /)  
KA(:, 5, 9, 9) = (/ &
 & 0.31033E+01_JPRB,0.39395E+01_JPRB,0.44689E+01_JPRB,0.48029E+01_JPRB,0.49990E+01_JPRB, &
 & 0.50689E+01_JPRB,0.50004E+01_JPRB,0.47030E+01_JPRB,0.39063E+01_JPRB /)  
KA(:, 1,10, 9) = (/ &
 & 0.25528E+01_JPRB,0.34541E+01_JPRB,0.39652E+01_JPRB,0.42831E+01_JPRB,0.44659E+01_JPRB, &
 & 0.45285E+01_JPRB,0.44509E+01_JPRB,0.41587E+01_JPRB,0.32612E+01_JPRB /)  
KA(:, 2,10, 9) = (/ &
 & 0.25575E+01_JPRB,0.34458E+01_JPRB,0.39558E+01_JPRB,0.42802E+01_JPRB,0.44723E+01_JPRB, &
 & 0.45451E+01_JPRB,0.44820E+01_JPRB,0.42051E+01_JPRB,0.33240E+01_JPRB /)  
KA(:, 3,10, 9) = (/ &
 & 0.25883E+01_JPRB,0.34607E+01_JPRB,0.39625E+01_JPRB,0.42854E+01_JPRB,0.44811E+01_JPRB, &
 & 0.45602E+01_JPRB,0.45090E+01_JPRB,0.42460E+01_JPRB,0.33785E+01_JPRB /)  
KA(:, 4,10, 9) = (/ &
 & 0.26435E+01_JPRB,0.34963E+01_JPRB,0.39867E+01_JPRB,0.43038E+01_JPRB,0.44956E+01_JPRB, &
 & 0.45761E+01_JPRB,0.45312E+01_JPRB,0.42799E+01_JPRB,0.34270E+01_JPRB /)  
KA(:, 5,10, 9) = (/ &
 & 0.27203E+01_JPRB,0.35517E+01_JPRB,0.40270E+01_JPRB,0.43344E+01_JPRB,0.45189E+01_JPRB, &
 & 0.45941E+01_JPRB,0.45504E+01_JPRB,0.43065E+01_JPRB,0.34705E+01_JPRB /)  
KA(:, 1,11, 9) = (/ &
 & 0.21958E+01_JPRB,0.30498E+01_JPRB,0.35059E+01_JPRB,0.38049E+01_JPRB,0.39876E+01_JPRB, &
 & 0.40622E+01_JPRB,0.40123E+01_JPRB,0.37729E+01_JPRB,0.28786E+01_JPRB /)  
KA(:, 2,11, 9) = (/ &
 & 0.22177E+01_JPRB,0.30598E+01_JPRB,0.35116E+01_JPRB,0.38116E+01_JPRB,0.39989E+01_JPRB, &
 & 0.40819E+01_JPRB,0.40442E+01_JPRB,0.38191E+01_JPRB,0.29389E+01_JPRB /)  
KA(:, 3,11, 9) = (/ &
 & 0.22647E+01_JPRB,0.30907E+01_JPRB,0.35359E+01_JPRB,0.38306E+01_JPRB,0.40167E+01_JPRB, &
 & 0.41020E+01_JPRB,0.40724E+01_JPRB,0.38578E+01_JPRB,0.29915E+01_JPRB /)  
KA(:, 4,11, 9) = (/ &
 & 0.23337E+01_JPRB,0.31425E+01_JPRB,0.35763E+01_JPRB,0.38632E+01_JPRB,0.40437E+01_JPRB, &
 & 0.41245E+01_JPRB,0.40973E+01_JPRB,0.38902E+01_JPRB,0.30386E+01_JPRB /)  
KA(:, 5,11, 9) = (/ &
 & 0.24135E+01_JPRB,0.32120E+01_JPRB,0.36330E+01_JPRB,0.39077E+01_JPRB,0.40797E+01_JPRB, &
 & 0.41526E+01_JPRB,0.41204E+01_JPRB,0.39195E+01_JPRB,0.30818E+01_JPRB /)  
KA(:, 1,12, 9) = (/ &
 & 0.18956E+01_JPRB,0.26861E+01_JPRB,0.30931E+01_JPRB,0.33674E+01_JPRB,0.35425E+01_JPRB, &
 & 0.36210E+01_JPRB,0.35899E+01_JPRB,0.33921E+01_JPRB,0.25824E+01_JPRB /)  
KA(:, 2,12, 9) = (/ &
 & 0.19314E+01_JPRB,0.27108E+01_JPRB,0.31141E+01_JPRB,0.33855E+01_JPRB,0.35620E+01_JPRB, &
 & 0.36450E+01_JPRB,0.36224E+01_JPRB,0.34362E+01_JPRB,0.26351E+01_JPRB /)  
KA(:, 3,12, 9) = (/ &
 & 0.19899E+01_JPRB,0.27565E+01_JPRB,0.31515E+01_JPRB,0.34177E+01_JPRB,0.35909E+01_JPRB, &
 & 0.36718E+01_JPRB,0.36517E+01_JPRB,0.34743E+01_JPRB,0.26837E+01_JPRB /)  
KA(:, 4,12, 9) = (/ &
 & 0.20599E+01_JPRB,0.28211E+01_JPRB,0.32055E+01_JPRB,0.34628E+01_JPRB,0.36291E+01_JPRB, &
 & 0.37038E+01_JPRB,0.36800E+01_JPRB,0.35081E+01_JPRB,0.27286E+01_JPRB /)  
KA(:, 5,12, 9) = (/ &
 & 0.21342E+01_JPRB,0.28994E+01_JPRB,0.32752E+01_JPRB,0.35201E+01_JPRB,0.36745E+01_JPRB, &
 & 0.37420E+01_JPRB,0.37112E+01_JPRB,0.35392E+01_JPRB,0.27703E+01_JPRB /)  
KA(:, 1,13, 9) = (/ &
 & 0.16403E+01_JPRB,0.23651E+01_JPRB,0.27290E+01_JPRB,0.29746E+01_JPRB,0.31326E+01_JPRB, &
 & 0.32080E+01_JPRB,0.31891E+01_JPRB,0.30274E+01_JPRB,0.23307E+01_JPRB /)  
KA(:, 2,13, 9) = (/ &
 & 0.16863E+01_JPRB,0.24025E+01_JPRB,0.27611E+01_JPRB,0.30044E+01_JPRB,0.31618E+01_JPRB, &
 & 0.32369E+01_JPRB,0.32226E+01_JPRB,0.30700E+01_JPRB,0.23815E+01_JPRB /)  
KA(:, 3,13, 9) = (/ &
 & 0.17455E+01_JPRB,0.24598E+01_JPRB,0.28102E+01_JPRB,0.30475E+01_JPRB,0.32007E+01_JPRB, &
 & 0.32722E+01_JPRB,0.32554E+01_JPRB,0.31073E+01_JPRB,0.24291E+01_JPRB /)  
KA(:, 4,13, 9) = (/ &
 & 0.18100E+01_JPRB,0.25311E+01_JPRB,0.28759E+01_JPRB,0.31035E+01_JPRB,0.32472E+01_JPRB, &
 & 0.33131E+01_JPRB,0.32901E+01_JPRB,0.31417E+01_JPRB,0.24730E+01_JPRB /)  
KA(:, 5,13, 9) = (/ &
 & 0.18736E+01_JPRB,0.26085E+01_JPRB,0.29527E+01_JPRB,0.31711E+01_JPRB,0.33027E+01_JPRB, &
 & 0.33589E+01_JPRB,0.33290E+01_JPRB,0.31763E+01_JPRB,0.25126E+01_JPRB /)  
KA(:, 1, 1,10) = (/ &
 & 0.19065E+02_JPRB,0.16899E+02_JPRB,0.15643E+02_JPRB,0.15578E+02_JPRB,0.15043E+02_JPRB, &
 & 0.14288E+02_JPRB,0.13684E+02_JPRB,0.14703E+02_JPRB,0.16312E+02_JPRB /)  
KA(:, 2, 1,10) = (/ &
 & 0.18912E+02_JPRB,0.16761E+02_JPRB,0.15514E+02_JPRB,0.15480E+02_JPRB,0.14973E+02_JPRB, &
 & 0.14273E+02_JPRB,0.13717E+02_JPRB,0.14749E+02_JPRB,0.16352E+02_JPRB /)  
KA(:, 3, 1,10) = (/ &
 & 0.18728E+02_JPRB,0.16596E+02_JPRB,0.15380E+02_JPRB,0.15367E+02_JPRB,0.14915E+02_JPRB, &
 & 0.14240E+02_JPRB,0.13761E+02_JPRB,0.14772E+02_JPRB,0.16373E+02_JPRB /)  
KA(:, 4, 1,10) = (/ &
 & 0.18544E+02_JPRB,0.16434E+02_JPRB,0.15250E+02_JPRB,0.15223E+02_JPRB,0.14839E+02_JPRB, &
 & 0.14214E+02_JPRB,0.13761E+02_JPRB,0.14749E+02_JPRB,0.16351E+02_JPRB /)  
KA(:, 5, 1,10) = (/ &
 & 0.18333E+02_JPRB,0.16256E+02_JPRB,0.15122E+02_JPRB,0.15098E+02_JPRB,0.14749E+02_JPRB, &
 & 0.14176E+02_JPRB,0.13735E+02_JPRB,0.14720E+02_JPRB,0.16309E+02_JPRB /)  
KA(:, 1, 2,10) = (/ &
 & 0.19359E+02_JPRB,0.17148E+02_JPRB,0.16419E+02_JPRB,0.16424E+02_JPRB,0.16006E+02_JPRB, &
 & 0.15375E+02_JPRB,0.14545E+02_JPRB,0.15202E+02_JPRB,0.16997E+02_JPRB /)  
KA(:, 2, 2,10) = (/ &
 & 0.19172E+02_JPRB,0.16980E+02_JPRB,0.16267E+02_JPRB,0.16317E+02_JPRB,0.15911E+02_JPRB, &
 & 0.15334E+02_JPRB,0.14618E+02_JPRB,0.15283E+02_JPRB,0.17084E+02_JPRB /)  
KA(:, 3, 2,10) = (/ &
 & 0.18973E+02_JPRB,0.16804E+02_JPRB,0.16126E+02_JPRB,0.16185E+02_JPRB,0.15827E+02_JPRB, &
 & 0.15302E+02_JPRB,0.14664E+02_JPRB,0.15280E+02_JPRB,0.17092E+02_JPRB /)  
KA(:, 4, 2,10) = (/ &
 & 0.18751E+02_JPRB,0.16617E+02_JPRB,0.15988E+02_JPRB,0.16055E+02_JPRB,0.15738E+02_JPRB, &
 & 0.15272E+02_JPRB,0.14654E+02_JPRB,0.15237E+02_JPRB,0.17035E+02_JPRB /)  
KA(:, 5, 2,10) = (/ &
 & 0.18520E+02_JPRB,0.16417E+02_JPRB,0.15855E+02_JPRB,0.15950E+02_JPRB,0.15639E+02_JPRB, &
 & 0.15219E+02_JPRB,0.14617E+02_JPRB,0.15192E+02_JPRB,0.16961E+02_JPRB /)  
KA(:, 1, 3,10) = (/ &
 & 0.19263E+02_JPRB,0.17075E+02_JPRB,0.17060E+02_JPRB,0.17120E+02_JPRB,0.16883E+02_JPRB, &
 & 0.16381E+02_JPRB,0.15414E+02_JPRB,0.15455E+02_JPRB,0.17398E+02_JPRB /)  
KA(:, 2, 3,10) = (/ &
 & 0.19059E+02_JPRB,0.16894E+02_JPRB,0.16898E+02_JPRB,0.17000E+02_JPRB,0.16773E+02_JPRB, &
 & 0.16323E+02_JPRB,0.15500E+02_JPRB,0.15491E+02_JPRB,0.17437E+02_JPRB /)  
KA(:, 3, 3,10) = (/ &
 & 0.18835E+02_JPRB,0.16708E+02_JPRB,0.16745E+02_JPRB,0.16865E+02_JPRB,0.16669E+02_JPRB, &
 & 0.16285E+02_JPRB,0.15530E+02_JPRB,0.15496E+02_JPRB,0.17423E+02_JPRB /)  
KA(:, 4, 3,10) = (/ &
 & 0.18600E+02_JPRB,0.16513E+02_JPRB,0.16588E+02_JPRB,0.16744E+02_JPRB,0.16560E+02_JPRB, &
 & 0.16244E+02_JPRB,0.15515E+02_JPRB,0.15476E+02_JPRB,0.17372E+02_JPRB /)  
KA(:, 5, 3,10) = (/ &
 & 0.18358E+02_JPRB,0.16312E+02_JPRB,0.16416E+02_JPRB,0.16627E+02_JPRB,0.16462E+02_JPRB, &
 & 0.16172E+02_JPRB,0.15490E+02_JPRB,0.15433E+02_JPRB,0.17293E+02_JPRB /)  
KA(:, 1, 4,10) = (/ &
 & 0.18801E+02_JPRB,0.16888E+02_JPRB,0.17351E+02_JPRB,0.17638E+02_JPRB,0.17654E+02_JPRB, &
 & 0.17241E+02_JPRB,0.16305E+02_JPRB,0.15458E+02_JPRB,0.17321E+02_JPRB /)  
KA(:, 2, 4,10) = (/ &
 & 0.18579E+02_JPRB,0.16692E+02_JPRB,0.17197E+02_JPRB,0.17496E+02_JPRB,0.17520E+02_JPRB, &
 & 0.17188E+02_JPRB,0.16384E+02_JPRB,0.15486E+02_JPRB,0.17346E+02_JPRB /)  
KA(:, 3, 4,10) = (/ &
 & 0.18342E+02_JPRB,0.16488E+02_JPRB,0.17035E+02_JPRB,0.17349E+02_JPRB,0.17380E+02_JPRB, &
 & 0.17158E+02_JPRB,0.16385E+02_JPRB,0.15526E+02_JPRB,0.17367E+02_JPRB /)  
KA(:, 4, 4,10) = (/ &
 & 0.18091E+02_JPRB,0.16279E+02_JPRB,0.16863E+02_JPRB,0.17208E+02_JPRB,0.17266E+02_JPRB, &
 & 0.17103E+02_JPRB,0.16355E+02_JPRB,0.15560E+02_JPRB,0.17358E+02_JPRB /)  
KA(:, 5, 4,10) = (/ &
 & 0.17836E+02_JPRB,0.16059E+02_JPRB,0.16677E+02_JPRB,0.17068E+02_JPRB,0.17166E+02_JPRB, &
 & 0.17011E+02_JPRB,0.16312E+02_JPRB,0.15578E+02_JPRB,0.17344E+02_JPRB /)  
KA(:, 1, 5,10) = (/ &
 & 0.17961E+02_JPRB,0.16659E+02_JPRB,0.17334E+02_JPRB,0.17976E+02_JPRB,0.18171E+02_JPRB, &
 & 0.17832E+02_JPRB,0.16966E+02_JPRB,0.15432E+02_JPRB,0.16855E+02_JPRB /)  
KA(:, 2, 5,10) = (/ &
 & 0.17714E+02_JPRB,0.16442E+02_JPRB,0.17178E+02_JPRB,0.17800E+02_JPRB,0.18030E+02_JPRB, &
 & 0.17804E+02_JPRB,0.17004E+02_JPRB,0.15487E+02_JPRB,0.16904E+02_JPRB /)  
KA(:, 3, 5,10) = (/ &
 & 0.17470E+02_JPRB,0.16231E+02_JPRB,0.17012E+02_JPRB,0.17636E+02_JPRB,0.17902E+02_JPRB, &
 & 0.17774E+02_JPRB,0.16959E+02_JPRB,0.15590E+02_JPRB,0.16987E+02_JPRB /)  
KA(:, 4, 5,10) = (/ &
 & 0.17221E+02_JPRB,0.16002E+02_JPRB,0.16835E+02_JPRB,0.17477E+02_JPRB,0.17804E+02_JPRB, &
 & 0.17680E+02_JPRB,0.16923E+02_JPRB,0.15646E+02_JPRB,0.17004E+02_JPRB /)  
KA(:, 5, 5,10) = (/ &
 & 0.16955E+02_JPRB,0.15778E+02_JPRB,0.16648E+02_JPRB,0.17325E+02_JPRB,0.17709E+02_JPRB, &
 & 0.17576E+02_JPRB,0.16895E+02_JPRB,0.15664E+02_JPRB,0.17027E+02_JPRB /)  
KA(:, 1, 6,10) = (/ &
 & 0.16796E+02_JPRB,0.16241E+02_JPRB,0.17123E+02_JPRB,0.18098E+02_JPRB,0.18345E+02_JPRB, &
 & 0.18145E+02_JPRB,0.17297E+02_JPRB,0.15317E+02_JPRB,0.16076E+02_JPRB /)  
KA(:, 2, 6,10) = (/ &
 & 0.16561E+02_JPRB,0.16019E+02_JPRB,0.16973E+02_JPRB,0.17901E+02_JPRB,0.18253E+02_JPRB, &
 & 0.18123E+02_JPRB,0.17284E+02_JPRB,0.15411E+02_JPRB,0.16194E+02_JPRB /)  
KA(:, 3, 6,10) = (/ &
 & 0.16307E+02_JPRB,0.15790E+02_JPRB,0.16801E+02_JPRB,0.17722E+02_JPRB,0.18189E+02_JPRB, &
 & 0.18068E+02_JPRB,0.17217E+02_JPRB,0.15556E+02_JPRB,0.16309E+02_JPRB /)  
KA(:, 4, 6,10) = (/ &
 & 0.16045E+02_JPRB,0.15571E+02_JPRB,0.16615E+02_JPRB,0.17565E+02_JPRB,0.18113E+02_JPRB, &
 & 0.17968E+02_JPRB,0.17201E+02_JPRB,0.15625E+02_JPRB,0.16374E+02_JPRB /)  
KA(:, 5, 6,10) = (/ &
 & 0.15792E+02_JPRB,0.15350E+02_JPRB,0.16424E+02_JPRB,0.17437E+02_JPRB,0.17997E+02_JPRB, &
 & 0.17869E+02_JPRB,0.17203E+02_JPRB,0.15664E+02_JPRB,0.16420E+02_JPRB /)  
KA(:, 1, 7,10) = (/ &
 & 0.15441E+02_JPRB,0.15555E+02_JPRB,0.16836E+02_JPRB,0.17857E+02_JPRB,0.18265E+02_JPRB, &
 & 0.18114E+02_JPRB,0.17249E+02_JPRB,0.15143E+02_JPRB,0.15078E+02_JPRB /)  
KA(:, 2, 7,10) = (/ &
 & 0.15190E+02_JPRB,0.15341E+02_JPRB,0.16649E+02_JPRB,0.17679E+02_JPRB,0.18211E+02_JPRB, &
 & 0.18098E+02_JPRB,0.17215E+02_JPRB,0.15278E+02_JPRB,0.15251E+02_JPRB /)  
KA(:, 3, 7,10) = (/ &
 & 0.14946E+02_JPRB,0.15122E+02_JPRB,0.16458E+02_JPRB,0.17534E+02_JPRB,0.18165E+02_JPRB, &
 & 0.18029E+02_JPRB,0.17165E+02_JPRB,0.15443E+02_JPRB,0.15389E+02_JPRB /)  
KA(:, 4, 7,10) = (/ &
 & 0.14700E+02_JPRB,0.14908E+02_JPRB,0.16252E+02_JPRB,0.17424E+02_JPRB,0.18072E+02_JPRB, &
 & 0.17929E+02_JPRB,0.17187E+02_JPRB,0.15518E+02_JPRB,0.15458E+02_JPRB /)  
KA(:, 5, 7,10) = (/ &
 & 0.14445E+02_JPRB,0.14710E+02_JPRB,0.16048E+02_JPRB,0.17304E+02_JPRB,0.17932E+02_JPRB, &
 & 0.17873E+02_JPRB,0.17206E+02_JPRB,0.15573E+02_JPRB,0.15541E+02_JPRB /)  
KA(:, 1, 8,10) = (/ &
 & 0.13963E+02_JPRB,0.14641E+02_JPRB,0.16339E+02_JPRB,0.17287E+02_JPRB,0.17853E+02_JPRB, &
 & 0.17712E+02_JPRB,0.16836E+02_JPRB,0.14867E+02_JPRB,0.13958E+02_JPRB /)  
KA(:, 2, 8,10) = (/ &
 & 0.13720E+02_JPRB,0.14441E+02_JPRB,0.16121E+02_JPRB,0.17175E+02_JPRB,0.17806E+02_JPRB, &
 & 0.17701E+02_JPRB,0.16817E+02_JPRB,0.15013E+02_JPRB,0.14139E+02_JPRB /)  
KA(:, 3, 8,10) = (/ &
 & 0.13475E+02_JPRB,0.14253E+02_JPRB,0.15918E+02_JPRB,0.17071E+02_JPRB,0.17741E+02_JPRB, &
 & 0.17634E+02_JPRB,0.16820E+02_JPRB,0.15155E+02_JPRB,0.14269E+02_JPRB /)  
KA(:, 4, 8,10) = (/ &
 & 0.13235E+02_JPRB,0.14056E+02_JPRB,0.15727E+02_JPRB,0.16983E+02_JPRB,0.17630E+02_JPRB, &
 & 0.17564E+02_JPRB,0.16869E+02_JPRB,0.15238E+02_JPRB,0.14383E+02_JPRB /)  
KA(:, 5, 8,10) = (/ &
 & 0.13009E+02_JPRB,0.13855E+02_JPRB,0.15556E+02_JPRB,0.16857E+02_JPRB,0.17508E+02_JPRB, &
 & 0.17529E+02_JPRB,0.16912E+02_JPRB,0.15302E+02_JPRB,0.14496E+02_JPRB /)  
KA(:, 1, 9,10) = (/ &
 & 0.12422E+02_JPRB,0.13743E+02_JPRB,0.15496E+02_JPRB,0.16530E+02_JPRB,0.17068E+02_JPRB, &
 & 0.16944E+02_JPRB,0.16119E+02_JPRB,0.14360E+02_JPRB,0.12852E+02_JPRB /)  
KA(:, 2, 9,10) = (/ &
 & 0.12195E+02_JPRB,0.13543E+02_JPRB,0.15328E+02_JPRB,0.16447E+02_JPRB,0.17000E+02_JPRB, &
 & 0.16934E+02_JPRB,0.16148E+02_JPRB,0.14484E+02_JPRB,0.13012E+02_JPRB /)  
KA(:, 3, 9,10) = (/ &
 & 0.11972E+02_JPRB,0.13354E+02_JPRB,0.15163E+02_JPRB,0.16359E+02_JPRB,0.16940E+02_JPRB, &
 & 0.16900E+02_JPRB,0.16191E+02_JPRB,0.14599E+02_JPRB,0.13152E+02_JPRB /)  
KA(:, 4, 9,10) = (/ &
 & 0.11752E+02_JPRB,0.13166E+02_JPRB,0.15011E+02_JPRB,0.16249E+02_JPRB,0.16842E+02_JPRB, &
 & 0.16880E+02_JPRB,0.16254E+02_JPRB,0.14688E+02_JPRB,0.13295E+02_JPRB /)  
KA(:, 5, 9,10) = (/ &
 & 0.11542E+02_JPRB,0.12972E+02_JPRB,0.14878E+02_JPRB,0.16107E+02_JPRB,0.16750E+02_JPRB, &
 & 0.16884E+02_JPRB,0.16301E+02_JPRB,0.14790E+02_JPRB,0.13417E+02_JPRB /)  
KA(:, 1,10,10) = (/ &
 & 0.10883E+02_JPRB,0.12799E+02_JPRB,0.14471E+02_JPRB,0.15523E+02_JPRB,0.15963E+02_JPRB, &
 & 0.15867E+02_JPRB,0.15188E+02_JPRB,0.13687E+02_JPRB,0.11830E+02_JPRB /)  
KA(:, 2,10,10) = (/ &
 & 0.10669E+02_JPRB,0.12615E+02_JPRB,0.14351E+02_JPRB,0.15423E+02_JPRB,0.15920E+02_JPRB, &
 & 0.15883E+02_JPRB,0.15251E+02_JPRB,0.13796E+02_JPRB,0.11997E+02_JPRB /)  
KA(:, 3,10,10) = (/ &
 & 0.10461E+02_JPRB,0.12417E+02_JPRB,0.14235E+02_JPRB,0.15340E+02_JPRB,0.15857E+02_JPRB, &
 & 0.15885E+02_JPRB,0.15315E+02_JPRB,0.13895E+02_JPRB,0.12154E+02_JPRB /)  
KA(:, 4,10,10) = (/ &
 & 0.10271E+02_JPRB,0.12218E+02_JPRB,0.14109E+02_JPRB,0.15234E+02_JPRB,0.15808E+02_JPRB, &
 & 0.15905E+02_JPRB,0.15383E+02_JPRB,0.14000E+02_JPRB,0.12311E+02_JPRB /)  
KA(:, 5,10,10) = (/ &
 & 0.10108E+02_JPRB,0.12035E+02_JPRB,0.13977E+02_JPRB,0.15117E+02_JPRB,0.15764E+02_JPRB, &
 & 0.15927E+02_JPRB,0.15450E+02_JPRB,0.14121E+02_JPRB,0.12430E+02_JPRB /)  
KA(:, 1,11,10) = (/ &
 & 0.93334E+01_JPRB,0.11625E+02_JPRB,0.13302E+02_JPRB,0.14226E+02_JPRB,0.14663E+02_JPRB, &
 & 0.14671E+02_JPRB,0.14179E+02_JPRB,0.12958E+02_JPRB,0.10939E+02_JPRB /)  
KA(:, 2,11,10) = (/ &
 & 0.91435E+01_JPRB,0.11452E+02_JPRB,0.13192E+02_JPRB,0.14163E+02_JPRB,0.14640E+02_JPRB, &
 & 0.14697E+02_JPRB,0.14256E+02_JPRB,0.13072E+02_JPRB,0.11104E+02_JPRB /)  
KA(:, 3,11,10) = (/ &
 & 0.89744E+01_JPRB,0.11286E+02_JPRB,0.13068E+02_JPRB,0.14085E+02_JPRB,0.14619E+02_JPRB, &
 & 0.14728E+02_JPRB,0.14326E+02_JPRB,0.13192E+02_JPRB,0.11276E+02_JPRB /)  
KA(:, 4,11,10) = (/ &
 & 0.88386E+01_JPRB,0.11134E+02_JPRB,0.12957E+02_JPRB,0.14008E+02_JPRB,0.14602E+02_JPRB, &
 & 0.14761E+02_JPRB,0.14404E+02_JPRB,0.13322E+02_JPRB,0.11423E+02_JPRB /)  
KA(:, 5,11,10) = (/ &
 & 0.88280E+01_JPRB,0.11011E+02_JPRB,0.12844E+02_JPRB,0.13942E+02_JPRB,0.14584E+02_JPRB, &
 & 0.14790E+02_JPRB,0.14494E+02_JPRB,0.13437E+02_JPRB,0.11537E+02_JPRB /)  
KA(:, 1,12,10) = (/ &
 & 0.79516E+01_JPRB,0.10418E+02_JPRB,0.11985E+02_JPRB,0.12856E+02_JPRB,0.13326E+02_JPRB, &
 & 0.13448E+02_JPRB,0.13142E+02_JPRB,0.12163E+02_JPRB,0.97408E+01_JPRB /)  
KA(:, 2,12,10) = (/ &
 & 0.78004E+01_JPRB,0.10286E+02_JPRB,0.11886E+02_JPRB,0.12812E+02_JPRB,0.13327E+02_JPRB, &
 & 0.13488E+02_JPRB,0.13229E+02_JPRB,0.12301E+02_JPRB,0.99474E+01_JPRB /)  
KA(:, 3,12,10) = (/ &
 & 0.76847E+01_JPRB,0.10169E+02_JPRB,0.11799E+02_JPRB,0.12768E+02_JPRB,0.13325E+02_JPRB, &
 & 0.13529E+02_JPRB,0.13323E+02_JPRB,0.12442E+02_JPRB,0.10130E+02_JPRB /)  
KA(:, 4,12,10) = (/ &
 & 0.76979E+01_JPRB,0.10072E+02_JPRB,0.11716E+02_JPRB,0.12735E+02_JPRB,0.13318E+02_JPRB, &
 & 0.13569E+02_JPRB,0.13422E+02_JPRB,0.12581E+02_JPRB,0.10272E+02_JPRB /)  
KA(:, 5,12,10) = (/ &
 & 0.78582E+01_JPRB,0.10030E+02_JPRB,0.11643E+02_JPRB,0.12707E+02_JPRB,0.13325E+02_JPRB, &
 & 0.13613E+02_JPRB,0.13505E+02_JPRB,0.12682E+02_JPRB,0.10410E+02_JPRB /)  
KA(:, 1,13,10) = (/ &
 & 0.68077E+01_JPRB,0.92695E+01_JPRB,0.10647E+02_JPRB,0.11513E+02_JPRB,0.12044E+02_JPRB, &
 & 0.12269E+02_JPRB,0.12092E+02_JPRB,0.11295E+02_JPRB,0.85103E+01_JPRB /)  
KA(:, 2,13,10) = (/ &
 & 0.67020E+01_JPRB,0.91675E+01_JPRB,0.10585E+02_JPRB,0.11489E+02_JPRB,0.12056E+02_JPRB, &
 & 0.12329E+02_JPRB,0.12198E+02_JPRB,0.11449E+02_JPRB,0.87111E+01_JPRB /)  
KA(:, 3,13,10) = (/ &
 & 0.67136E+01_JPRB,0.90765E+01_JPRB,0.10537E+02_JPRB,0.11473E+02_JPRB,0.12065E+02_JPRB, &
 & 0.12379E+02_JPRB,0.12312E+02_JPRB,0.11602E+02_JPRB,0.88718E+01_JPRB /)  
KA(:, 4,13,10) = (/ &
 & 0.68715E+01_JPRB,0.90508E+01_JPRB,0.10490E+02_JPRB,0.11454E+02_JPRB,0.12087E+02_JPRB, &
 & 0.12433E+02_JPRB,0.12413E+02_JPRB,0.11728E+02_JPRB,0.90172E+01_JPRB /)  
KA(:, 5,13,10) = (/ &
 & 0.71183E+01_JPRB,0.91466E+01_JPRB,0.10479E+02_JPRB,0.11436E+02_JPRB,0.12120E+02_JPRB, &
 & 0.12489E+02_JPRB,0.12478E+02_JPRB,0.11826E+02_JPRB,0.91846E+01_JPRB /)  
KA(:, 1, 1,11) = (/ &
 & 0.25290E+02_JPRB,0.22378E+02_JPRB,0.19682E+02_JPRB,0.19092E+02_JPRB,0.18401E+02_JPRB, &
 & 0.17330E+02_JPRB,0.17194E+02_JPRB,0.19513E+02_JPRB,0.21546E+02_JPRB /)  
KA(:, 2, 1,11) = (/ &
 & 0.25153E+02_JPRB,0.22251E+02_JPRB,0.19574E+02_JPRB,0.19002E+02_JPRB,0.18309E+02_JPRB, &
 & 0.17346E+02_JPRB,0.17168E+02_JPRB,0.19469E+02_JPRB,0.21516E+02_JPRB /)  
KA(:, 3, 1,11) = (/ &
 & 0.24990E+02_JPRB,0.22108E+02_JPRB,0.19457E+02_JPRB,0.18891E+02_JPRB,0.18197E+02_JPRB, &
 & 0.17344E+02_JPRB,0.17153E+02_JPRB,0.19435E+02_JPRB,0.21516E+02_JPRB /)  
KA(:, 4, 1,11) = (/ &
 & 0.24785E+02_JPRB,0.21926E+02_JPRB,0.19312E+02_JPRB,0.18774E+02_JPRB,0.18111E+02_JPRB, &
 & 0.17300E+02_JPRB,0.17168E+02_JPRB,0.19426E+02_JPRB,0.21524E+02_JPRB /)  
KA(:, 5, 1,11) = (/ &
 & 0.24562E+02_JPRB,0.21729E+02_JPRB,0.19145E+02_JPRB,0.18657E+02_JPRB,0.18043E+02_JPRB, &
 & 0.17239E+02_JPRB,0.17190E+02_JPRB,0.19400E+02_JPRB,0.21517E+02_JPRB /)  
KA(:, 1, 2,11) = (/ &
 & 0.26738E+02_JPRB,0.23635E+02_JPRB,0.21164E+02_JPRB,0.20882E+02_JPRB,0.20133E+02_JPRB, &
 & 0.18952E+02_JPRB,0.18391E+02_JPRB,0.20397E+02_JPRB,0.22752E+02_JPRB /)  
KA(:, 2, 2,11) = (/ &
 & 0.26579E+02_JPRB,0.23493E+02_JPRB,0.21026E+02_JPRB,0.20770E+02_JPRB,0.20046E+02_JPRB, &
 & 0.18924E+02_JPRB,0.18351E+02_JPRB,0.20302E+02_JPRB,0.22673E+02_JPRB /)  
KA(:, 3, 2,11) = (/ &
 & 0.26369E+02_JPRB,0.23304E+02_JPRB,0.20847E+02_JPRB,0.20634E+02_JPRB,0.19955E+02_JPRB, &
 & 0.18867E+02_JPRB,0.18355E+02_JPRB,0.20274E+02_JPRB,0.22643E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART7',1,ZHOOK_HANDLE)
END SUBROUTINE PART7


SUBROUTINE PART8

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART8',0,ZHOOK_HANDLE)


KA(:, 4, 2,11) = (/ &
 & 0.26147E+02_JPRB,0.23108E+02_JPRB,0.20663E+02_JPRB,0.20491E+02_JPRB,0.19870E+02_JPRB, &
 & 0.18790E+02_JPRB,0.18365E+02_JPRB,0.20271E+02_JPRB,0.22638E+02_JPRB /)  
KA(:, 5, 2,11) = (/ &
 & 0.25876E+02_JPRB,0.22867E+02_JPRB,0.20457E+02_JPRB,0.20308E+02_JPRB,0.19788E+02_JPRB, &
 & 0.18723E+02_JPRB,0.18359E+02_JPRB,0.20242E+02_JPRB,0.22612E+02_JPRB /)  
KA(:, 1, 3,11) = (/ &
 & 0.27801E+02_JPRB,0.24558E+02_JPRB,0.22625E+02_JPRB,0.22456E+02_JPRB,0.21766E+02_JPRB, &
 & 0.20723E+02_JPRB,0.19785E+02_JPRB,0.21193E+02_JPRB,0.23811E+02_JPRB /)  
KA(:, 2, 3,11) = (/ &
 & 0.27586E+02_JPRB,0.24366E+02_JPRB,0.22444E+02_JPRB,0.22341E+02_JPRB,0.21670E+02_JPRB, &
 & 0.20651E+02_JPRB,0.19732E+02_JPRB,0.21163E+02_JPRB,0.23778E+02_JPRB /)  
KA(:, 3, 3,11) = (/ &
 & 0.27362E+02_JPRB,0.24166E+02_JPRB,0.22236E+02_JPRB,0.22200E+02_JPRB,0.21575E+02_JPRB, &
 & 0.20557E+02_JPRB,0.19718E+02_JPRB,0.21155E+02_JPRB,0.23783E+02_JPRB /)  
KA(:, 4, 3,11) = (/ &
 & 0.27084E+02_JPRB,0.23919E+02_JPRB,0.22013E+02_JPRB,0.22018E+02_JPRB,0.21471E+02_JPRB, &
 & 0.20457E+02_JPRB,0.19708E+02_JPRB,0.21136E+02_JPRB,0.23769E+02_JPRB /)  
KA(:, 5, 3,11) = (/ &
 & 0.26795E+02_JPRB,0.23666E+02_JPRB,0.21794E+02_JPRB,0.21827E+02_JPRB,0.21355E+02_JPRB, &
 & 0.20374E+02_JPRB,0.19655E+02_JPRB,0.21092E+02_JPRB,0.23724E+02_JPRB /)  
KA(:, 1, 4,11) = (/ &
 & 0.28327E+02_JPRB,0.25026E+02_JPRB,0.23910E+02_JPRB,0.23720E+02_JPRB,0.23265E+02_JPRB, &
 & 0.22396E+02_JPRB,0.21086E+02_JPRB,0.21859E+02_JPRB,0.24649E+02_JPRB /)  
KA(:, 2, 4,11) = (/ &
 & 0.28095E+02_JPRB,0.24816E+02_JPRB,0.23683E+02_JPRB,0.23594E+02_JPRB,0.23156E+02_JPRB, &
 & 0.22304E+02_JPRB,0.21023E+02_JPRB,0.21873E+02_JPRB,0.24674E+02_JPRB /)  
KA(:, 3, 4,11) = (/ &
 & 0.27817E+02_JPRB,0.24569E+02_JPRB,0.23454E+02_JPRB,0.23446E+02_JPRB,0.23031E+02_JPRB, &
 & 0.22182E+02_JPRB,0.21022E+02_JPRB,0.21878E+02_JPRB,0.24680E+02_JPRB /)  
KA(:, 4, 4,11) = (/ &
 & 0.27525E+02_JPRB,0.24310E+02_JPRB,0.23220E+02_JPRB,0.23268E+02_JPRB,0.22908E+02_JPRB, &
 & 0.22090E+02_JPRB,0.21022E+02_JPRB,0.21824E+02_JPRB,0.24620E+02_JPRB /)  
KA(:, 5, 4,11) = (/ &
 & 0.27191E+02_JPRB,0.24023E+02_JPRB,0.22996E+02_JPRB,0.23072E+02_JPRB,0.22769E+02_JPRB, &
 & 0.22022E+02_JPRB,0.20982E+02_JPRB,0.21737E+02_JPRB,0.24514E+02_JPRB /)  
KA(:, 1, 5,11) = (/ &
 & 0.28259E+02_JPRB,0.25014E+02_JPRB,0.24907E+02_JPRB,0.24706E+02_JPRB,0.24642E+02_JPRB, &
 & 0.23918E+02_JPRB,0.22330E+02_JPRB,0.22219E+02_JPRB,0.25091E+02_JPRB /)  
KA(:, 2, 5,11) = (/ &
 & 0.27993E+02_JPRB,0.24771E+02_JPRB,0.24666E+02_JPRB,0.24596E+02_JPRB,0.24487E+02_JPRB, &
 & 0.23818E+02_JPRB,0.22348E+02_JPRB,0.22269E+02_JPRB,0.25149E+02_JPRB /)  
KA(:, 3, 5,11) = (/ &
 & 0.27691E+02_JPRB,0.24499E+02_JPRB,0.24421E+02_JPRB,0.24432E+02_JPRB,0.24340E+02_JPRB, &
 & 0.23705E+02_JPRB,0.22420E+02_JPRB,0.22242E+02_JPRB,0.25109E+02_JPRB /)  
KA(:, 4, 5,11) = (/ &
 & 0.27357E+02_JPRB,0.24214E+02_JPRB,0.24178E+02_JPRB,0.24253E+02_JPRB,0.24191E+02_JPRB, &
 & 0.23642E+02_JPRB,0.22422E+02_JPRB,0.22174E+02_JPRB,0.25030E+02_JPRB /)  
KA(:, 5, 5,11) = (/ &
 & 0.27008E+02_JPRB,0.23916E+02_JPRB,0.23935E+02_JPRB,0.24063E+02_JPRB,0.24020E+02_JPRB, &
 & 0.23572E+02_JPRB,0.22355E+02_JPRB,0.22132E+02_JPRB,0.24957E+02_JPRB /)  
KA(:, 1, 6,11) = (/ &
 & 0.27627E+02_JPRB,0.24841E+02_JPRB,0.25414E+02_JPRB,0.25513E+02_JPRB,0.25788E+02_JPRB, &
 & 0.25161E+02_JPRB,0.23567E+02_JPRB,0.22384E+02_JPRB,0.25091E+02_JPRB /)  
KA(:, 2, 6,11) = (/ &
 & 0.27317E+02_JPRB,0.24550E+02_JPRB,0.25165E+02_JPRB,0.25384E+02_JPRB,0.25578E+02_JPRB, &
 & 0.25083E+02_JPRB,0.23662E+02_JPRB,0.22423E+02_JPRB,0.25102E+02_JPRB /)  
KA(:, 3, 6,11) = (/ &
 & 0.26994E+02_JPRB,0.24259E+02_JPRB,0.24926E+02_JPRB,0.25206E+02_JPRB,0.25391E+02_JPRB, &
 & 0.25015E+02_JPRB,0.23758E+02_JPRB,0.22363E+02_JPRB,0.25025E+02_JPRB /)  
KA(:, 4, 6,11) = (/ &
 & 0.26640E+02_JPRB,0.23945E+02_JPRB,0.24692E+02_JPRB,0.25002E+02_JPRB,0.25193E+02_JPRB, &
 & 0.24973E+02_JPRB,0.23733E+02_JPRB,0.22328E+02_JPRB,0.24965E+02_JPRB /)  
KA(:, 5, 6,11) = (/ &
 & 0.26265E+02_JPRB,0.23625E+02_JPRB,0.24446E+02_JPRB,0.24785E+02_JPRB,0.25037E+02_JPRB, &
 & 0.24906E+02_JPRB,0.23659E+02_JPRB,0.22352E+02_JPRB,0.24965E+02_JPRB /)  
KA(:, 1, 7,11) = (/ &
 & 0.26430E+02_JPRB,0.24581E+02_JPRB,0.25439E+02_JPRB,0.26140E+02_JPRB,0.26524E+02_JPRB, &
 & 0.25974E+02_JPRB,0.24552E+02_JPRB,0.22441E+02_JPRB,0.24498E+02_JPRB /)  
KA(:, 2, 7,11) = (/ &
 & 0.26105E+02_JPRB,0.24263E+02_JPRB,0.25225E+02_JPRB,0.25974E+02_JPRB,0.26315E+02_JPRB, &
 & 0.25946E+02_JPRB,0.24677E+02_JPRB,0.22471E+02_JPRB,0.24490E+02_JPRB /)  
KA(:, 3, 7,11) = (/ &
 & 0.25752E+02_JPRB,0.23938E+02_JPRB,0.24996E+02_JPRB,0.25749E+02_JPRB,0.26113E+02_JPRB, &
 & 0.25925E+02_JPRB,0.24758E+02_JPRB,0.22442E+02_JPRB,0.24454E+02_JPRB /)  
KA(:, 4, 7,11) = (/ &
 & 0.25389E+02_JPRB,0.23609E+02_JPRB,0.24761E+02_JPRB,0.25499E+02_JPRB,0.25940E+02_JPRB, &
 & 0.25913E+02_JPRB,0.24720E+02_JPRB,0.22473E+02_JPRB,0.24475E+02_JPRB /)  
KA(:, 5, 7,11) = (/ &
 & 0.25010E+02_JPRB,0.23260E+02_JPRB,0.24510E+02_JPRB,0.25262E+02_JPRB,0.25804E+02_JPRB, &
 & 0.25811E+02_JPRB,0.24640E+02_JPRB,0.22547E+02_JPRB,0.24534E+02_JPRB /)  
KA(:, 1, 8,11) = (/ &
 & 0.24762E+02_JPRB,0.23997E+02_JPRB,0.25209E+02_JPRB,0.26467E+02_JPRB,0.26748E+02_JPRB, &
 & 0.26365E+02_JPRB,0.25094E+02_JPRB,0.22357E+02_JPRB,0.23406E+02_JPRB /)  
KA(:, 2, 8,11) = (/ &
 & 0.24421E+02_JPRB,0.23672E+02_JPRB,0.24981E+02_JPRB,0.26217E+02_JPRB,0.26595E+02_JPRB, &
 & 0.26375E+02_JPRB,0.25195E+02_JPRB,0.22435E+02_JPRB,0.23453E+02_JPRB /)  
KA(:, 3, 8,11) = (/ &
 & 0.24067E+02_JPRB,0.23336E+02_JPRB,0.24754E+02_JPRB,0.25956E+02_JPRB,0.26455E+02_JPRB, &
 & 0.26361E+02_JPRB,0.25241E+02_JPRB,0.22458E+02_JPRB,0.23475E+02_JPRB /)  
KA(:, 4, 8,11) = (/ &
 & 0.23691E+02_JPRB,0.22996E+02_JPRB,0.24502E+02_JPRB,0.25698E+02_JPRB,0.26330E+02_JPRB, &
 & 0.26343E+02_JPRB,0.25197E+02_JPRB,0.22533E+02_JPRB,0.23575E+02_JPRB /)  
KA(:, 5, 8,11) = (/ &
 & 0.23311E+02_JPRB,0.22660E+02_JPRB,0.24234E+02_JPRB,0.25450E+02_JPRB,0.26215E+02_JPRB, &
 & 0.26209E+02_JPRB,0.25123E+02_JPRB,0.22642E+02_JPRB,0.23709E+02_JPRB /)  
KA(:, 1, 9,11) = (/ &
 & 0.22800E+02_JPRB,0.23011E+02_JPRB,0.24799E+02_JPRB,0.26181E+02_JPRB,0.26533E+02_JPRB, &
 & 0.26301E+02_JPRB,0.25044E+02_JPRB,0.22077E+02_JPRB,0.21907E+02_JPRB /)  
KA(:, 2, 9,11) = (/ &
 & 0.22436E+02_JPRB,0.22697E+02_JPRB,0.24546E+02_JPRB,0.25945E+02_JPRB,0.26460E+02_JPRB, &
 & 0.26314E+02_JPRB,0.25122E+02_JPRB,0.22204E+02_JPRB,0.22029E+02_JPRB /)  
KA(:, 3, 9,11) = (/ &
 & 0.22079E+02_JPRB,0.22367E+02_JPRB,0.24295E+02_JPRB,0.25706E+02_JPRB,0.26370E+02_JPRB, &
 & 0.26288E+02_JPRB,0.25162E+02_JPRB,0.22314E+02_JPRB,0.22151E+02_JPRB /)  
KA(:, 4, 9,11) = (/ &
 & 0.21719E+02_JPRB,0.22029E+02_JPRB,0.24017E+02_JPRB,0.25487E+02_JPRB,0.26273E+02_JPRB, &
 & 0.26217E+02_JPRB,0.25110E+02_JPRB,0.22435E+02_JPRB,0.22334E+02_JPRB /)  
KA(:, 5, 9,11) = (/ &
 & 0.21341E+02_JPRB,0.21707E+02_JPRB,0.23702E+02_JPRB,0.25282E+02_JPRB,0.26159E+02_JPRB, &
 & 0.26086E+02_JPRB,0.25065E+02_JPRB,0.22578E+02_JPRB,0.22506E+02_JPRB /)  
KA(:, 1,10,11) = (/ &
 & 0.20601E+02_JPRB,0.21678E+02_JPRB,0.24058E+02_JPRB,0.25352E+02_JPRB,0.25931E+02_JPRB, &
 & 0.25718E+02_JPRB,0.24432E+02_JPRB,0.21607E+02_JPRB,0.20262E+02_JPRB /)  
KA(:, 2,10,11) = (/ &
 & 0.20254E+02_JPRB,0.21345E+02_JPRB,0.23796E+02_JPRB,0.25183E+02_JPRB,0.25875E+02_JPRB, &
 & 0.25691E+02_JPRB,0.24508E+02_JPRB,0.21774E+02_JPRB,0.20445E+02_JPRB /)  
KA(:, 3,10,11) = (/ &
 & 0.19899E+02_JPRB,0.21048E+02_JPRB,0.23494E+02_JPRB,0.25000E+02_JPRB,0.25800E+02_JPRB, &
 & 0.25662E+02_JPRB,0.24533E+02_JPRB,0.21922E+02_JPRB,0.20638E+02_JPRB /)  
KA(:, 4,10,11) = (/ &
 & 0.19544E+02_JPRB,0.20766E+02_JPRB,0.23207E+02_JPRB,0.24826E+02_JPRB,0.25686E+02_JPRB, &
 & 0.25593E+02_JPRB,0.24527E+02_JPRB,0.22085E+02_JPRB,0.20832E+02_JPRB /)  
KA(:, 5,10,11) = (/ &
 & 0.19193E+02_JPRB,0.20470E+02_JPRB,0.22936E+02_JPRB,0.24673E+02_JPRB,0.25544E+02_JPRB, &
 & 0.25480E+02_JPRB,0.24537E+02_JPRB,0.22218E+02_JPRB,0.21044E+02_JPRB /)  
KA(:, 1,11,11) = (/ &
 & 0.18170E+02_JPRB,0.20155E+02_JPRB,0.22721E+02_JPRB,0.24145E+02_JPRB,0.24798E+02_JPRB, &
 & 0.24559E+02_JPRB,0.23403E+02_JPRB,0.20895E+02_JPRB,0.18740E+02_JPRB /)  
KA(:, 2,11,11) = (/ &
 & 0.17830E+02_JPRB,0.19860E+02_JPRB,0.22479E+02_JPRB,0.24018E+02_JPRB,0.24721E+02_JPRB, &
 & 0.24556E+02_JPRB,0.23466E+02_JPRB,0.21069E+02_JPRB,0.18949E+02_JPRB /)  
KA(:, 3,11,11) = (/ &
 & 0.17496E+02_JPRB,0.19576E+02_JPRB,0.22242E+02_JPRB,0.23886E+02_JPRB,0.24621E+02_JPRB, &
 & 0.24529E+02_JPRB,0.23525E+02_JPRB,0.21231E+02_JPRB,0.19147E+02_JPRB /)  
KA(:, 4,11,11) = (/ &
 & 0.17168E+02_JPRB,0.19292E+02_JPRB,0.22005E+02_JPRB,0.23734E+02_JPRB,0.24514E+02_JPRB, &
 & 0.24476E+02_JPRB,0.23580E+02_JPRB,0.21376E+02_JPRB,0.19368E+02_JPRB /)  
KA(:, 5,11,11) = (/ &
 & 0.16844E+02_JPRB,0.19013E+02_JPRB,0.21771E+02_JPRB,0.23570E+02_JPRB,0.24390E+02_JPRB, &
 & 0.24440E+02_JPRB,0.23651E+02_JPRB,0.21517E+02_JPRB,0.19612E+02_JPRB /)  
KA(:, 1,12,11) = (/ &
 & 0.15762E+02_JPRB,0.18615E+02_JPRB,0.21133E+02_JPRB,0.22639E+02_JPRB,0.23214E+02_JPRB, &
 & 0.23022E+02_JPRB,0.22060E+02_JPRB,0.19958E+02_JPRB,0.17314E+02_JPRB /)  
KA(:, 2,12,11) = (/ &
 & 0.15455E+02_JPRB,0.18341E+02_JPRB,0.20944E+02_JPRB,0.22510E+02_JPRB,0.23148E+02_JPRB, &
 & 0.23042E+02_JPRB,0.22164E+02_JPRB,0.20127E+02_JPRB,0.17543E+02_JPRB /)  
KA(:, 3,12,11) = (/ &
 & 0.15156E+02_JPRB,0.18068E+02_JPRB,0.20768E+02_JPRB,0.22374E+02_JPRB,0.23084E+02_JPRB, &
 & 0.23060E+02_JPRB,0.22257E+02_JPRB,0.20275E+02_JPRB,0.17770E+02_JPRB /)  
KA(:, 4,12,11) = (/ &
 & 0.14865E+02_JPRB,0.17794E+02_JPRB,0.20582E+02_JPRB,0.22237E+02_JPRB,0.23018E+02_JPRB, &
 & 0.23079E+02_JPRB,0.22350E+02_JPRB,0.20427E+02_JPRB,0.18026E+02_JPRB /)  
KA(:, 5,12,11) = (/ &
 & 0.14612E+02_JPRB,0.17534E+02_JPRB,0.20399E+02_JPRB,0.22086E+02_JPRB,0.22956E+02_JPRB, &
 & 0.23112E+02_JPRB,0.22443E+02_JPRB,0.20607E+02_JPRB,0.18280E+02_JPRB /)  
KA(:, 1,13,11) = (/ &
 & 0.13517E+02_JPRB,0.16914E+02_JPRB,0.19425E+02_JPRB,0.20790E+02_JPRB,0.21367E+02_JPRB, &
 & 0.21315E+02_JPRB,0.20607E+02_JPRB,0.18871E+02_JPRB,0.15967E+02_JPRB /)  
KA(:, 2,13,11) = (/ &
 & 0.13249E+02_JPRB,0.16688E+02_JPRB,0.19279E+02_JPRB,0.20693E+02_JPRB,0.21344E+02_JPRB, &
 & 0.21372E+02_JPRB,0.20725E+02_JPRB,0.19043E+02_JPRB,0.16217E+02_JPRB /)  
KA(:, 3,13,11) = (/ &
 & 0.12994E+02_JPRB,0.16467E+02_JPRB,0.19108E+02_JPRB,0.20602E+02_JPRB,0.21343E+02_JPRB, &
 & 0.21436E+02_JPRB,0.20839E+02_JPRB,0.19212E+02_JPRB,0.16494E+02_JPRB /)  
KA(:, 4,13,11) = (/ &
 & 0.12784E+02_JPRB,0.16250E+02_JPRB,0.18951E+02_JPRB,0.20506E+02_JPRB,0.21335E+02_JPRB, &
 & 0.21503E+02_JPRB,0.20961E+02_JPRB,0.19415E+02_JPRB,0.16770E+02_JPRB /)  
KA(:, 5,13,11) = (/ &
 & 0.12734E+02_JPRB,0.16049E+02_JPRB,0.18819E+02_JPRB,0.20438E+02_JPRB,0.21329E+02_JPRB, &
 & 0.21573E+02_JPRB,0.21104E+02_JPRB,0.19623E+02_JPRB,0.16983E+02_JPRB /)  
KA(:, 1, 1,12) = (/ &
 & 0.32549E+02_JPRB,0.28774E+02_JPRB,0.25031E+02_JPRB,0.22926E+02_JPRB,0.22117E+02_JPRB, &
 & 0.21695E+02_JPRB,0.23417E+02_JPRB,0.26761E+02_JPRB,0.29694E+02_JPRB /)  
KA(:, 2, 1,12) = (/ &
 & 0.32499E+02_JPRB,0.28739E+02_JPRB,0.25006E+02_JPRB,0.22835E+02_JPRB,0.22088E+02_JPRB, &
 & 0.21560E+02_JPRB,0.23253E+02_JPRB,0.26542E+02_JPRB,0.29377E+02_JPRB /)  
KA(:, 3, 1,12) = (/ &
 & 0.32407E+02_JPRB,0.28660E+02_JPRB,0.24923E+02_JPRB,0.22714E+02_JPRB,0.22014E+02_JPRB, &
 & 0.21461E+02_JPRB,0.23148E+02_JPRB,0.26398E+02_JPRB,0.29117E+02_JPRB /)  
KA(:, 4, 1,12) = (/ &
 & 0.32260E+02_JPRB,0.28512E+02_JPRB,0.24788E+02_JPRB,0.22590E+02_JPRB,0.21881E+02_JPRB, &
 & 0.21430E+02_JPRB,0.23071E+02_JPRB,0.26295E+02_JPRB,0.28961E+02_JPRB /)  
KA(:, 5, 1,12) = (/ &
 & 0.32039E+02_JPRB,0.28307E+02_JPRB,0.24614E+02_JPRB,0.22444E+02_JPRB,0.21715E+02_JPRB, &
 & 0.21428E+02_JPRB,0.22979E+02_JPRB,0.26201E+02_JPRB,0.28821E+02_JPRB /)  
KA(:, 1, 2,12) = (/ &
 & 0.35951E+02_JPRB,0.31737E+02_JPRB,0.27558E+02_JPRB,0.25749E+02_JPRB,0.24746E+02_JPRB, &
 & 0.23905E+02_JPRB,0.24887E+02_JPRB,0.28459E+02_JPRB,0.31791E+02_JPRB /)  
KA(:, 2, 2,12) = (/ &
 & 0.35862E+02_JPRB,0.31672E+02_JPRB,0.27501E+02_JPRB,0.25642E+02_JPRB,0.24725E+02_JPRB, &
 & 0.23810E+02_JPRB,0.24734E+02_JPRB,0.28277E+02_JPRB,0.31526E+02_JPRB /)  
KA(:, 3, 2,12) = (/ &
 & 0.35737E+02_JPRB,0.31562E+02_JPRB,0.27401E+02_JPRB,0.25522E+02_JPRB,0.24641E+02_JPRB, &
 & 0.23751E+02_JPRB,0.24591E+02_JPRB,0.28127E+02_JPRB,0.31321E+02_JPRB /)  
KA(:, 4, 2,12) = (/ &
 & 0.35534E+02_JPRB,0.31380E+02_JPRB,0.27248E+02_JPRB,0.25379E+02_JPRB,0.24498E+02_JPRB, &
 & 0.23724E+02_JPRB,0.24485E+02_JPRB,0.28006E+02_JPRB,0.31168E+02_JPRB /)  
KA(:, 5, 2,12) = (/ &
 & 0.35285E+02_JPRB,0.31161E+02_JPRB,0.27065E+02_JPRB,0.25222E+02_JPRB,0.24328E+02_JPRB, &
 & 0.23689E+02_JPRB,0.24406E+02_JPRB,0.27908E+02_JPRB,0.31060E+02_JPRB /)  
KA(:, 1, 3,12) = (/ &
 & 0.39089E+02_JPRB,0.34457E+02_JPRB,0.30041E+02_JPRB,0.28724E+02_JPRB,0.27574E+02_JPRB, &
 & 0.26213E+02_JPRB,0.26498E+02_JPRB,0.30215E+02_JPRB,0.33960E+02_JPRB /)  
KA(:, 2, 3,12) = (/ &
 & 0.38998E+02_JPRB,0.34382E+02_JPRB,0.29952E+02_JPRB,0.28581E+02_JPRB,0.27562E+02_JPRB, &
 & 0.26150E+02_JPRB,0.26309E+02_JPRB,0.29980E+02_JPRB,0.33662E+02_JPRB /)  
KA(:, 3, 3,12) = (/ &
 & 0.38820E+02_JPRB,0.34217E+02_JPRB,0.29804E+02_JPRB,0.28424E+02_JPRB,0.27473E+02_JPRB, &
 & 0.26126E+02_JPRB,0.26176E+02_JPRB,0.29817E+02_JPRB,0.33458E+02_JPRB /)  
KA(:, 4, 3,12) = (/ &
 & 0.38594E+02_JPRB,0.34019E+02_JPRB,0.29631E+02_JPRB,0.28264E+02_JPRB,0.27343E+02_JPRB, &
 & 0.26103E+02_JPRB,0.26063E+02_JPRB,0.29657E+02_JPRB,0.33303E+02_JPRB /)  
KA(:, 5, 3,12) = (/ &
 & 0.38290E+02_JPRB,0.33755E+02_JPRB,0.29411E+02_JPRB,0.28094E+02_JPRB,0.27189E+02_JPRB, &
 & 0.26048E+02_JPRB,0.25993E+02_JPRB,0.29534E+02_JPRB,0.33212E+02_JPRB /)  
KA(:, 1, 4,12) = (/ &
 & 0.41846E+02_JPRB,0.36848E+02_JPRB,0.32642E+02_JPRB,0.31752E+02_JPRB,0.30348E+02_JPRB, &
 & 0.28783E+02_JPRB,0.28429E+02_JPRB,0.31940E+02_JPRB,0.36003E+02_JPRB /)  
KA(:, 2, 4,12) = (/ &
 & 0.41706E+02_JPRB,0.36722E+02_JPRB,0.32481E+02_JPRB,0.31589E+02_JPRB,0.30346E+02_JPRB, &
 & 0.28731E+02_JPRB,0.28275E+02_JPRB,0.31704E+02_JPRB,0.35716E+02_JPRB /)  
KA(:, 3, 4,12) = (/ &
 & 0.41502E+02_JPRB,0.36539E+02_JPRB,0.32269E+02_JPRB,0.31417E+02_JPRB,0.30279E+02_JPRB, &
 & 0.28696E+02_JPRB,0.28151E+02_JPRB,0.31470E+02_JPRB,0.35494E+02_JPRB /)  
KA(:, 4, 4,12) = (/ &
 & 0.41217E+02_JPRB,0.36286E+02_JPRB,0.32033E+02_JPRB,0.31226E+02_JPRB,0.30155E+02_JPRB, &
 & 0.28647E+02_JPRB,0.28039E+02_JPRB,0.31307E+02_JPRB,0.35368E+02_JPRB /)  
KA(:, 5, 4,12) = (/ &
 & 0.40876E+02_JPRB,0.35985E+02_JPRB,0.31743E+02_JPRB,0.31019E+02_JPRB,0.30013E+02_JPRB, &
 & 0.28553E+02_JPRB,0.27986E+02_JPRB,0.31205E+02_JPRB,0.35294E+02_JPRB /)  
KA(:, 1, 5,12) = (/ &
 & 0.43995E+02_JPRB,0.38706E+02_JPRB,0.35200E+02_JPRB,0.34595E+02_JPRB,0.33005E+02_JPRB, &
 & 0.31594E+02_JPRB,0.30727E+02_JPRB,0.33547E+02_JPRB,0.37840E+02_JPRB /)  
KA(:, 2, 5,12) = (/ &
 & 0.43792E+02_JPRB,0.38521E+02_JPRB,0.34965E+02_JPRB,0.34413E+02_JPRB,0.33017E+02_JPRB, &
 & 0.31523E+02_JPRB,0.30579E+02_JPRB,0.33292E+02_JPRB,0.37593E+02_JPRB /)  
KA(:, 3, 5,12) = (/ &
 & 0.43530E+02_JPRB,0.38288E+02_JPRB,0.34710E+02_JPRB,0.34215E+02_JPRB,0.32953E+02_JPRB, &
 & 0.31452E+02_JPRB,0.30422E+02_JPRB,0.33082E+02_JPRB,0.37437E+02_JPRB /)  
KA(:, 4, 5,12) = (/ &
 & 0.43192E+02_JPRB,0.37991E+02_JPRB,0.34400E+02_JPRB,0.33987E+02_JPRB,0.32832E+02_JPRB, &
 & 0.31362E+02_JPRB,0.30341E+02_JPRB,0.32970E+02_JPRB,0.37357E+02_JPRB /)  
KA(:, 5, 5,12) = (/ &
 & 0.42817E+02_JPRB,0.37661E+02_JPRB,0.34079E+02_JPRB,0.33725E+02_JPRB,0.32688E+02_JPRB, &
 & 0.31220E+02_JPRB,0.30292E+02_JPRB,0.32861E+02_JPRB,0.37270E+02_JPRB /)  
KA(:, 1, 6,12) = (/ &
 & 0.45371E+02_JPRB,0.39886E+02_JPRB,0.37563E+02_JPRB,0.36985E+02_JPRB,0.35582E+02_JPRB, &
 & 0.34395E+02_JPRB,0.32997E+02_JPRB,0.34724E+02_JPRB,0.39202E+02_JPRB /)  
KA(:, 2, 6,12) = (/ &
 & 0.45116E+02_JPRB,0.39656E+02_JPRB,0.37269E+02_JPRB,0.36794E+02_JPRB,0.35596E+02_JPRB, &
 & 0.34289E+02_JPRB,0.32827E+02_JPRB,0.34552E+02_JPRB,0.39098E+02_JPRB /)  
KA(:, 3, 6,12) = (/ &
 & 0.44794E+02_JPRB,0.39373E+02_JPRB,0.36959E+02_JPRB,0.36575E+02_JPRB,0.35485E+02_JPRB, &
 & 0.34189E+02_JPRB,0.32665E+02_JPRB,0.34424E+02_JPRB,0.39024E+02_JPRB /)  
KA(:, 4, 6,12) = (/ &
 & 0.44425E+02_JPRB,0.39049E+02_JPRB,0.36596E+02_JPRB,0.36352E+02_JPRB,0.35337E+02_JPRB, &
 & 0.34032E+02_JPRB,0.32591E+02_JPRB,0.34348E+02_JPRB,0.38980E+02_JPRB /)  
KA(:, 5, 6,12) = (/ &
 & 0.43987E+02_JPRB,0.38666E+02_JPRB,0.36218E+02_JPRB,0.36087E+02_JPRB,0.35122E+02_JPRB, &
 & 0.33853E+02_JPRB,0.32536E+02_JPRB,0.34232E+02_JPRB,0.38883E+02_JPRB /)  
KA(:, 1, 7,12) = (/ &
 & 0.45829E+02_JPRB,0.40296E+02_JPRB,0.39507E+02_JPRB,0.38911E+02_JPRB,0.38052E+02_JPRB, &
 & 0.37051E+02_JPRB,0.34926E+02_JPRB,0.35286E+02_JPRB,0.39874E+02_JPRB /)  
KA(:, 2, 7,12) = (/ &
 & 0.45523E+02_JPRB,0.40015E+02_JPRB,0.39164E+02_JPRB,0.38712E+02_JPRB,0.37995E+02_JPRB, &
 & 0.36879E+02_JPRB,0.34780E+02_JPRB,0.35237E+02_JPRB,0.39916E+02_JPRB /)  
KA(:, 3, 7,12) = (/ &
 & 0.45143E+02_JPRB,0.39672E+02_JPRB,0.38788E+02_JPRB,0.38484E+02_JPRB,0.37843E+02_JPRB, &
 & 0.36693E+02_JPRB,0.34674E+02_JPRB,0.35202E+02_JPRB,0.39935E+02_JPRB /)  
KA(:, 4, 7,12) = (/ &
 & 0.44711E+02_JPRB,0.39294E+02_JPRB,0.38380E+02_JPRB,0.38261E+02_JPRB,0.37608E+02_JPRB, &
 & 0.36475E+02_JPRB,0.34639E+02_JPRB,0.35181E+02_JPRB,0.39952E+02_JPRB /)  
KA(:, 5, 7,12) = (/ &
 & 0.44229E+02_JPRB,0.38875E+02_JPRB,0.37956E+02_JPRB,0.37973E+02_JPRB,0.37347E+02_JPRB, &
 & 0.36293E+02_JPRB,0.34620E+02_JPRB,0.35062E+02_JPRB,0.39846E+02_JPRB /)  
KA(:, 1, 8,12) = (/ &
 & 0.45335E+02_JPRB,0.40267E+02_JPRB,0.40744E+02_JPRB,0.40443E+02_JPRB,0.40247E+02_JPRB, &
 & 0.39223E+02_JPRB,0.36584E+02_JPRB,0.35367E+02_JPRB,0.39844E+02_JPRB /)  
KA(:, 2, 8,12) = (/ &
 & 0.44955E+02_JPRB,0.39893E+02_JPRB,0.40398E+02_JPRB,0.40216E+02_JPRB,0.40115E+02_JPRB, &
 & 0.39023E+02_JPRB,0.36582E+02_JPRB,0.35440E+02_JPRB,0.40008E+02_JPRB /)  
KA(:, 3, 8,12) = (/ &
 & 0.44529E+02_JPRB,0.39492E+02_JPRB,0.39985E+02_JPRB,0.39979E+02_JPRB,0.39873E+02_JPRB, &
 & 0.38831E+02_JPRB,0.36587E+02_JPRB,0.35498E+02_JPRB,0.40121E+02_JPRB /)  
KA(:, 4, 8,12) = (/ &
 & 0.44061E+02_JPRB,0.39061E+02_JPRB,0.39564E+02_JPRB,0.39715E+02_JPRB,0.39565E+02_JPRB, &
 & 0.38623E+02_JPRB,0.36619E+02_JPRB,0.35513E+02_JPRB,0.40138E+02_JPRB /)  
KA(:, 5, 8,12) = (/ &
 & 0.43543E+02_JPRB,0.38605E+02_JPRB,0.39136E+02_JPRB,0.39437E+02_JPRB,0.39265E+02_JPRB, &
 & 0.38474E+02_JPRB,0.36637E+02_JPRB,0.35396E+02_JPRB,0.40011E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART8',1,ZHOOK_HANDLE)
END SUBROUTINE PART8


SUBROUTINE PART9

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART9',0,ZHOOK_HANDLE)


KA(:, 1, 9,12) = (/ &
 & 0.43909E+02_JPRB,0.39954E+02_JPRB,0.41167E+02_JPRB,0.41626E+02_JPRB,0.41945E+02_JPRB, &
 & 0.40736E+02_JPRB,0.38077E+02_JPRB,0.35393E+02_JPRB,0.39221E+02_JPRB /)  
KA(:, 2, 9,12) = (/ &
 & 0.43480E+02_JPRB,0.39498E+02_JPRB,0.40786E+02_JPRB,0.41338E+02_JPRB,0.41733E+02_JPRB, &
 & 0.40609E+02_JPRB,0.38181E+02_JPRB,0.35523E+02_JPRB,0.39397E+02_JPRB /)  
KA(:, 3, 9,12) = (/ &
 & 0.43002E+02_JPRB,0.39038E+02_JPRB,0.40373E+02_JPRB,0.41094E+02_JPRB,0.41410E+02_JPRB, &
 & 0.40471E+02_JPRB,0.38255E+02_JPRB,0.35563E+02_JPRB,0.39462E+02_JPRB /)  
KA(:, 4, 9,12) = (/ &
 & 0.42479E+02_JPRB,0.38560E+02_JPRB,0.39995E+02_JPRB,0.40806E+02_JPRB,0.41101E+02_JPRB, &
 & 0.40341E+02_JPRB,0.38344E+02_JPRB,0.35573E+02_JPRB,0.39457E+02_JPRB /)  
KA(:, 5, 9,12) = (/ &
 & 0.41942E+02_JPRB,0.38060E+02_JPRB,0.39621E+02_JPRB,0.40473E+02_JPRB,0.40785E+02_JPRB, &
 & 0.40226E+02_JPRB,0.38369E+02_JPRB,0.35494E+02_JPRB,0.39400E+02_JPRB /)  
KA(:, 1,10,12) = (/ &
 & 0.41598E+02_JPRB,0.39277E+02_JPRB,0.40964E+02_JPRB,0.42358E+02_JPRB,0.42727E+02_JPRB, &
 & 0.41605E+02_JPRB,0.39147E+02_JPRB,0.35243E+02_JPRB,0.37755E+02_JPRB /)  
KA(:, 2,10,12) = (/ &
 & 0.41110E+02_JPRB,0.38804E+02_JPRB,0.40573E+02_JPRB,0.42061E+02_JPRB,0.42547E+02_JPRB, &
 & 0.41580E+02_JPRB,0.39298E+02_JPRB,0.35367E+02_JPRB,0.37893E+02_JPRB /)  
KA(:, 3,10,12) = (/ &
 & 0.40607E+02_JPRB,0.38301E+02_JPRB,0.40218E+02_JPRB,0.41774E+02_JPRB,0.42273E+02_JPRB, &
 & 0.41520E+02_JPRB,0.39406E+02_JPRB,0.35478E+02_JPRB,0.38009E+02_JPRB /)  
KA(:, 4,10,12) = (/ &
 & 0.40087E+02_JPRB,0.37793E+02_JPRB,0.39835E+02_JPRB,0.41418E+02_JPRB,0.42009E+02_JPRB, &
 & 0.41467E+02_JPRB,0.39471E+02_JPRB,0.35532E+02_JPRB,0.38110E+02_JPRB /)  
KA(:, 5,10,12) = (/ &
 & 0.39528E+02_JPRB,0.37276E+02_JPRB,0.39445E+02_JPRB,0.41009E+02_JPRB,0.41755E+02_JPRB, &
 & 0.41409E+02_JPRB,0.39460E+02_JPRB,0.35536E+02_JPRB,0.38153E+02_JPRB /)  
KA(:, 1,11,12) = (/ &
 & 0.38423E+02_JPRB,0.37785E+02_JPRB,0.40246E+02_JPRB,0.42229E+02_JPRB,0.42700E+02_JPRB, &
 & 0.41861E+02_JPRB,0.39594E+02_JPRB,0.34991E+02_JPRB,0.35642E+02_JPRB /)  
KA(:, 2,11,12) = (/ &
 & 0.37903E+02_JPRB,0.37296E+02_JPRB,0.39841E+02_JPRB,0.41927E+02_JPRB,0.42539E+02_JPRB, &
 & 0.41882E+02_JPRB,0.39751E+02_JPRB,0.35170E+02_JPRB,0.35883E+02_JPRB /)  
KA(:, 3,11,12) = (/ &
 & 0.37383E+02_JPRB,0.36809E+02_JPRB,0.39442E+02_JPRB,0.41575E+02_JPRB,0.42342E+02_JPRB, &
 & 0.41911E+02_JPRB,0.39809E+02_JPRB,0.35335E+02_JPRB,0.36101E+02_JPRB /)  
KA(:, 4,11,12) = (/ &
 & 0.36841E+02_JPRB,0.36301E+02_JPRB,0.39055E+02_JPRB,0.41199E+02_JPRB,0.42145E+02_JPRB, &
 & 0.41876E+02_JPRB,0.39854E+02_JPRB,0.35442E+02_JPRB,0.36276E+02_JPRB /)  
KA(:, 5,11,12) = (/ &
 & 0.36274E+02_JPRB,0.35783E+02_JPRB,0.38676E+02_JPRB,0.40833E+02_JPRB,0.41945E+02_JPRB, &
 & 0.41808E+02_JPRB,0.39839E+02_JPRB,0.35539E+02_JPRB,0.36455E+02_JPRB /)  
KA(:, 1,12,12) = (/ &
 & 0.34828E+02_JPRB,0.35770E+02_JPRB,0.39099E+02_JPRB,0.41221E+02_JPRB,0.41958E+02_JPRB, &
 & 0.41456E+02_JPRB,0.39253E+02_JPRB,0.34461E+02_JPRB,0.33246E+02_JPRB /)  
KA(:, 2,12,12) = (/ &
 & 0.34304E+02_JPRB,0.35295E+02_JPRB,0.38700E+02_JPRB,0.40987E+02_JPRB,0.41846E+02_JPRB, &
 & 0.41525E+02_JPRB,0.39359E+02_JPRB,0.34698E+02_JPRB,0.33560E+02_JPRB /)  
KA(:, 3,12,12) = (/ &
 & 0.33784E+02_JPRB,0.34798E+02_JPRB,0.38311E+02_JPRB,0.40707E+02_JPRB,0.41743E+02_JPRB, &
 & 0.41505E+02_JPRB,0.39465E+02_JPRB,0.34925E+02_JPRB,0.33882E+02_JPRB /)  
KA(:, 4,12,12) = (/ &
 & 0.33241E+02_JPRB,0.34324E+02_JPRB,0.37917E+02_JPRB,0.40393E+02_JPRB,0.41632E+02_JPRB, &
 & 0.41461E+02_JPRB,0.39554E+02_JPRB,0.35117E+02_JPRB,0.34172E+02_JPRB /)  
KA(:, 5,12,12) = (/ &
 & 0.32710E+02_JPRB,0.33867E+02_JPRB,0.37489E+02_JPRB,0.40112E+02_JPRB,0.41490E+02_JPRB, &
 & 0.41392E+02_JPRB,0.39590E+02_JPRB,0.35312E+02_JPRB,0.34501E+02_JPRB /)  
KA(:, 1,13,12) = (/ &
 & 0.30997E+02_JPRB,0.33431E+02_JPRB,0.37385E+02_JPRB,0.39653E+02_JPRB,0.40610E+02_JPRB, &
 & 0.40222E+02_JPRB,0.38101E+02_JPRB,0.33638E+02_JPRB,0.30845E+02_JPRB /)  
KA(:, 2,13,12) = (/ &
 & 0.30492E+02_JPRB,0.32952E+02_JPRB,0.37042E+02_JPRB,0.39451E+02_JPRB,0.40583E+02_JPRB, &
 & 0.40257E+02_JPRB,0.38272E+02_JPRB,0.33940E+02_JPRB,0.31245E+02_JPRB /)  
KA(:, 3,13,12) = (/ &
 & 0.29985E+02_JPRB,0.32520E+02_JPRB,0.36699E+02_JPRB,0.39235E+02_JPRB,0.40521E+02_JPRB, &
 & 0.40274E+02_JPRB,0.38447E+02_JPRB,0.34242E+02_JPRB,0.31622E+02_JPRB /)  
KA(:, 4,13,12) = (/ &
 & 0.29485E+02_JPRB,0.32102E+02_JPRB,0.36327E+02_JPRB,0.39047E+02_JPRB,0.40416E+02_JPRB, &
 & 0.40299E+02_JPRB,0.38596E+02_JPRB,0.34522E+02_JPRB,0.32000E+02_JPRB /)  
KA(:, 5,13,12) = (/ &
 & 0.29016E+02_JPRB,0.31685E+02_JPRB,0.35962E+02_JPRB,0.38852E+02_JPRB,0.40311E+02_JPRB, &
 & 0.40331E+02_JPRB,0.38749E+02_JPRB,0.34802E+02_JPRB,0.32433E+02_JPRB /)  
KA(:, 1, 1,13) = (/ &
 & 0.40414E+02_JPRB,0.35530E+02_JPRB,0.30727E+02_JPRB,0.26813E+02_JPRB,0.26498E+02_JPRB, &
 & 0.27724E+02_JPRB,0.32451E+02_JPRB,0.37296E+02_JPRB,0.40920E+02_JPRB /)  
KA(:, 2, 1,13) = (/ &
 & 0.40378E+02_JPRB,0.35506E+02_JPRB,0.30718E+02_JPRB,0.26787E+02_JPRB,0.26360E+02_JPRB, &
 & 0.27557E+02_JPRB,0.32109E+02_JPRB,0.36904E+02_JPRB,0.40512E+02_JPRB /)  
KA(:, 3, 1,13) = (/ &
 & 0.40288E+02_JPRB,0.35435E+02_JPRB,0.30689E+02_JPRB,0.26758E+02_JPRB,0.26294E+02_JPRB, &
 & 0.27365E+02_JPRB,0.31721E+02_JPRB,0.36448E+02_JPRB,0.40077E+02_JPRB /)  
KA(:, 4, 1,13) = (/ &
 & 0.40152E+02_JPRB,0.35337E+02_JPRB,0.30607E+02_JPRB,0.26666E+02_JPRB,0.26235E+02_JPRB, &
 & 0.27137E+02_JPRB,0.31350E+02_JPRB,0.36026E+02_JPRB,0.39605E+02_JPRB /)  
KA(:, 5, 1,13) = (/ &
 & 0.39996E+02_JPRB,0.35209E+02_JPRB,0.30500E+02_JPRB,0.26544E+02_JPRB,0.26176E+02_JPRB, &
 & 0.26906E+02_JPRB,0.31054E+02_JPRB,0.35676E+02_JPRB,0.39227E+02_JPRB /)  
KA(:, 1, 2,13) = (/ &
 & 0.46201E+02_JPRB,0.40631E+02_JPRB,0.35149E+02_JPRB,0.31004E+02_JPRB,0.30338E+02_JPRB, &
 & 0.30975E+02_JPRB,0.35648E+02_JPRB,0.41032E+02_JPRB,0.45728E+02_JPRB /)  
KA(:, 2, 2,13) = (/ &
 & 0.46189E+02_JPRB,0.40616E+02_JPRB,0.35151E+02_JPRB,0.30920E+02_JPRB,0.30181E+02_JPRB, &
 & 0.30854E+02_JPRB,0.35321E+02_JPRB,0.40601E+02_JPRB,0.45258E+02_JPRB /)  
KA(:, 3, 2,13) = (/ &
 & 0.46107E+02_JPRB,0.40548E+02_JPRB,0.35109E+02_JPRB,0.30814E+02_JPRB,0.30060E+02_JPRB, &
 & 0.30665E+02_JPRB,0.34964E+02_JPRB,0.40159E+02_JPRB,0.44756E+02_JPRB /)  
KA(:, 4, 2,13) = (/ &
 & 0.45964E+02_JPRB,0.40421E+02_JPRB,0.35002E+02_JPRB,0.30664E+02_JPRB,0.29967E+02_JPRB, &
 & 0.30436E+02_JPRB,0.34636E+02_JPRB,0.39757E+02_JPRB,0.44299E+02_JPRB /)  
KA(:, 5, 2,13) = (/ &
 & 0.45779E+02_JPRB,0.40257E+02_JPRB,0.34861E+02_JPRB,0.30500E+02_JPRB,0.29866E+02_JPRB, &
 & 0.30215E+02_JPRB,0.34343E+02_JPRB,0.39421E+02_JPRB,0.43898E+02_JPRB /)  
KA(:, 1, 3,13) = (/ &
 & 0.52493E+02_JPRB,0.46184E+02_JPRB,0.39933E+02_JPRB,0.35707E+02_JPRB,0.34547E+02_JPRB, &
 & 0.34524E+02_JPRB,0.38680E+02_JPRB,0.44581E+02_JPRB,0.50362E+02_JPRB /)  
KA(:, 2, 3,13) = (/ &
 & 0.52499E+02_JPRB,0.46190E+02_JPRB,0.39958E+02_JPRB,0.35613E+02_JPRB,0.34342E+02_JPRB, &
 & 0.34438E+02_JPRB,0.38422E+02_JPRB,0.44213E+02_JPRB,0.49916E+02_JPRB /)  
KA(:, 3, 3,13) = (/ &
 & 0.52430E+02_JPRB,0.46141E+02_JPRB,0.39924E+02_JPRB,0.35477E+02_JPRB,0.34202E+02_JPRB, &
 & 0.34294E+02_JPRB,0.38128E+02_JPRB,0.43804E+02_JPRB,0.49438E+02_JPRB /)  
KA(:, 4, 3,13) = (/ &
 & 0.52296E+02_JPRB,0.46021E+02_JPRB,0.39821E+02_JPRB,0.35288E+02_JPRB,0.34063E+02_JPRB, &
 & 0.34077E+02_JPRB,0.37857E+02_JPRB,0.43466E+02_JPRB,0.49020E+02_JPRB /)  
KA(:, 5, 3,13) = (/ &
 & 0.52087E+02_JPRB,0.45828E+02_JPRB,0.39654E+02_JPRB,0.35060E+02_JPRB,0.33889E+02_JPRB, &
 & 0.33876E+02_JPRB,0.37613E+02_JPRB,0.43182E+02_JPRB,0.48640E+02_JPRB /)  
KA(:, 1, 4,13) = (/ &
 & 0.58998E+02_JPRB,0.51894E+02_JPRB,0.44809E+02_JPRB,0.40767E+02_JPRB,0.39196E+02_JPRB, &
 & 0.38349E+02_JPRB,0.41490E+02_JPRB,0.47820E+02_JPRB,0.54353E+02_JPRB /)  
KA(:, 2, 4,13) = (/ &
 & 0.58998E+02_JPRB,0.51911E+02_JPRB,0.44850E+02_JPRB,0.40692E+02_JPRB,0.38973E+02_JPRB, &
 & 0.38281E+02_JPRB,0.41275E+02_JPRB,0.47479E+02_JPRB,0.53941E+02_JPRB /)  
KA(:, 3, 4,13) = (/ &
 & 0.58946E+02_JPRB,0.51872E+02_JPRB,0.44826E+02_JPRB,0.40545E+02_JPRB,0.38818E+02_JPRB, &
 & 0.38152E+02_JPRB,0.41007E+02_JPRB,0.47151E+02_JPRB,0.53507E+02_JPRB /)  
KA(:, 4, 4,13) = (/ &
 & 0.58797E+02_JPRB,0.51741E+02_JPRB,0.44719E+02_JPRB,0.40328E+02_JPRB,0.38647E+02_JPRB, &
 & 0.37950E+02_JPRB,0.40768E+02_JPRB,0.46871E+02_JPRB,0.53108E+02_JPRB /)  
KA(:, 5, 4,13) = (/ &
 & 0.58578E+02_JPRB,0.51549E+02_JPRB,0.44555E+02_JPRB,0.40074E+02_JPRB,0.38419E+02_JPRB, &
 & 0.37769E+02_JPRB,0.40542E+02_JPRB,0.46625E+02_JPRB,0.52790E+02_JPRB /)  
KA(:, 1, 5,13) = (/ &
 & 0.65454E+02_JPRB,0.57537E+02_JPRB,0.49631E+02_JPRB,0.46171E+02_JPRB,0.44093E+02_JPRB, &
 & 0.42375E+02_JPRB,0.44216E+02_JPRB,0.50929E+02_JPRB,0.58021E+02_JPRB /)  
KA(:, 2, 5,13) = (/ &
 & 0.65480E+02_JPRB,0.57591E+02_JPRB,0.49679E+02_JPRB,0.46047E+02_JPRB,0.43916E+02_JPRB, &
 & 0.42317E+02_JPRB,0.44023E+02_JPRB,0.50643E+02_JPRB,0.57621E+02_JPRB /)  
KA(:, 3, 5,13) = (/ &
 & 0.65404E+02_JPRB,0.57534E+02_JPRB,0.49633E+02_JPRB,0.45875E+02_JPRB,0.43765E+02_JPRB, &
 & 0.42200E+02_JPRB,0.43791E+02_JPRB,0.50364E+02_JPRB,0.57215E+02_JPRB /)  
KA(:, 4, 5,13) = (/ &
 & 0.65236E+02_JPRB,0.57393E+02_JPRB,0.49518E+02_JPRB,0.45648E+02_JPRB,0.43596E+02_JPRB, &
 & 0.42013E+02_JPRB,0.43533E+02_JPRB,0.50076E+02_JPRB,0.56838E+02_JPRB /)  
KA(:, 5, 5,13) = (/ &
 & 0.64960E+02_JPRB,0.57155E+02_JPRB,0.49326E+02_JPRB,0.45390E+02_JPRB,0.43392E+02_JPRB, &
 & 0.41855E+02_JPRB,0.43285E+02_JPRB,0.49832E+02_JPRB,0.56537E+02_JPRB /)  
KA(:, 1, 6,13) = (/ &
 & 0.71553E+02_JPRB,0.62830E+02_JPRB,0.54580E+02_JPRB,0.51897E+02_JPRB,0.49249E+02_JPRB, &
 & 0.46670E+02_JPRB,0.47221E+02_JPRB,0.54164E+02_JPRB,0.61741E+02_JPRB /)  
KA(:, 2, 6,13) = (/ &
 & 0.71559E+02_JPRB,0.62858E+02_JPRB,0.54547E+02_JPRB,0.51727E+02_JPRB,0.49114E+02_JPRB, &
 & 0.46626E+02_JPRB,0.47093E+02_JPRB,0.53907E+02_JPRB,0.61336E+02_JPRB /)  
KA(:, 3, 6,13) = (/ &
 & 0.71474E+02_JPRB,0.62796E+02_JPRB,0.54422E+02_JPRB,0.51491E+02_JPRB,0.49001E+02_JPRB, &
 & 0.46518E+02_JPRB,0.46873E+02_JPRB,0.53599E+02_JPRB,0.60908E+02_JPRB /)  
KA(:, 4, 6,13) = (/ &
 & 0.71253E+02_JPRB,0.62620E+02_JPRB,0.54248E+02_JPRB,0.51208E+02_JPRB,0.48873E+02_JPRB, &
 & 0.46377E+02_JPRB,0.46595E+02_JPRB,0.53243E+02_JPRB,0.60469E+02_JPRB /)  
KA(:, 5, 6,13) = (/ &
 & 0.70931E+02_JPRB,0.62354E+02_JPRB,0.53993E+02_JPRB,0.50888E+02_JPRB,0.48719E+02_JPRB, &
 & 0.46222E+02_JPRB,0.46318E+02_JPRB,0.52946E+02_JPRB,0.60113E+02_JPRB /)  
KA(:, 1, 7,13) = (/ &
 & 0.76995E+02_JPRB,0.67566E+02_JPRB,0.59542E+02_JPRB,0.57607E+02_JPRB,0.54461E+02_JPRB, &
 & 0.51316E+02_JPRB,0.50984E+02_JPRB,0.57643E+02_JPRB,0.65674E+02_JPRB /)  
KA(:, 2, 7,13) = (/ &
 & 0.76958E+02_JPRB,0.67548E+02_JPRB,0.59397E+02_JPRB,0.57376E+02_JPRB,0.54369E+02_JPRB, &
 & 0.51326E+02_JPRB,0.50889E+02_JPRB,0.57330E+02_JPRB,0.65196E+02_JPRB /)  
KA(:, 3, 7,13) = (/ &
 & 0.76815E+02_JPRB,0.67433E+02_JPRB,0.59207E+02_JPRB,0.57127E+02_JPRB,0.54289E+02_JPRB, &
 & 0.51287E+02_JPRB,0.50622E+02_JPRB,0.56904E+02_JPRB,0.64662E+02_JPRB /)  
KA(:, 4, 7,13) = (/ &
 & 0.76535E+02_JPRB,0.67198E+02_JPRB,0.58948E+02_JPRB,0.56779E+02_JPRB,0.54224E+02_JPRB, &
 & 0.51158E+02_JPRB,0.50286E+02_JPRB,0.56459E+02_JPRB,0.64124E+02_JPRB /)  
KA(:, 5, 7,13) = (/ &
 & 0.76156E+02_JPRB,0.66876E+02_JPRB,0.58634E+02_JPRB,0.56401E+02_JPRB,0.54096E+02_JPRB, &
 & 0.50976E+02_JPRB,0.49973E+02_JPRB,0.56129E+02_JPRB,0.63785E+02_JPRB /)  
KA(:, 1, 8,13) = (/ &
 & 0.81421E+02_JPRB,0.71418E+02_JPRB,0.64455E+02_JPRB,0.62977E+02_JPRB,0.59643E+02_JPRB, &
 & 0.56434E+02_JPRB,0.55164E+02_JPRB,0.60758E+02_JPRB,0.69127E+02_JPRB /)  
KA(:, 2, 8,13) = (/ &
 & 0.81348E+02_JPRB,0.71366E+02_JPRB,0.64215E+02_JPRB,0.62779E+02_JPRB,0.59582E+02_JPRB, &
 & 0.56462E+02_JPRB,0.55001E+02_JPRB,0.60346E+02_JPRB,0.68584E+02_JPRB /)  
KA(:, 3, 8,13) = (/ &
 & 0.81121E+02_JPRB,0.71177E+02_JPRB,0.63909E+02_JPRB,0.62467E+02_JPRB,0.59508E+02_JPRB, &
 & 0.56437E+02_JPRB,0.54668E+02_JPRB,0.59898E+02_JPRB,0.68043E+02_JPRB /)  
KA(:, 4, 8,13) = (/ &
 & 0.80795E+02_JPRB,0.70901E+02_JPRB,0.63558E+02_JPRB,0.62070E+02_JPRB,0.59450E+02_JPRB, &
 & 0.56283E+02_JPRB,0.54317E+02_JPRB,0.59470E+02_JPRB,0.67583E+02_JPRB /)  
KA(:, 5, 8,13) = (/ &
 & 0.80315E+02_JPRB,0.70489E+02_JPRB,0.63126E+02_JPRB,0.61649E+02_JPRB,0.59298E+02_JPRB, &
 & 0.56050E+02_JPRB,0.54007E+02_JPRB,0.59179E+02_JPRB,0.67330E+02_JPRB /)  
KA(:, 1, 9,13) = (/ &
 & 0.84526E+02_JPRB,0.74114E+02_JPRB,0.69139E+02_JPRB,0.67766E+02_JPRB,0.64700E+02_JPRB, &
 & 0.61791E+02_JPRB,0.59295E+02_JPRB,0.62885E+02_JPRB,0.71468E+02_JPRB /)  
KA(:, 2, 9,13) = (/ &
 & 0.84370E+02_JPRB,0.73989E+02_JPRB,0.68856E+02_JPRB,0.67565E+02_JPRB,0.64593E+02_JPRB, &
 & 0.61811E+02_JPRB,0.59181E+02_JPRB,0.62666E+02_JPRB,0.71181E+02_JPRB /)  
KA(:, 3, 9,13) = (/ &
 & 0.84053E+02_JPRB,0.73721E+02_JPRB,0.68457E+02_JPRB,0.67233E+02_JPRB,0.64524E+02_JPRB, &
 & 0.61778E+02_JPRB,0.58870E+02_JPRB,0.62384E+02_JPRB,0.70849E+02_JPRB /)  
KA(:, 4, 9,13) = (/ &
 & 0.83638E+02_JPRB,0.73367E+02_JPRB,0.67980E+02_JPRB,0.66820E+02_JPRB,0.64408E+02_JPRB, &
 & 0.61582E+02_JPRB,0.58561E+02_JPRB,0.62049E+02_JPRB,0.70550E+02_JPRB /)  
KA(:, 5, 9,13) = (/ &
 & 0.83125E+02_JPRB,0.72897E+02_JPRB,0.67415E+02_JPRB,0.66418E+02_JPRB,0.64238E+02_JPRB, &
 & 0.61304E+02_JPRB,0.58306E+02_JPRB,0.61805E+02_JPRB,0.70366E+02_JPRB /)  
KA(:, 1,10,13) = (/ &
 & 0.86099E+02_JPRB,0.75664E+02_JPRB,0.73052E+02_JPRB,0.71784E+02_JPRB,0.69581E+02_JPRB, &
 & 0.67013E+02_JPRB,0.63079E+02_JPRB,0.64019E+02_JPRB,0.72668E+02_JPRB /)  
KA(:, 2,10,13) = (/ &
 & 0.85793E+02_JPRB,0.75364E+02_JPRB,0.72621E+02_JPRB,0.71506E+02_JPRB,0.69364E+02_JPRB, &
 & 0.66992E+02_JPRB,0.63098E+02_JPRB,0.64105E+02_JPRB,0.72738E+02_JPRB /)  
KA(:, 3,10,13) = (/ &
 & 0.85391E+02_JPRB,0.74983E+02_JPRB,0.72119E+02_JPRB,0.71136E+02_JPRB,0.69201E+02_JPRB, &
 & 0.66897E+02_JPRB,0.62939E+02_JPRB,0.63964E+02_JPRB,0.72620E+02_JPRB /)  
KA(:, 4,10,13) = (/ &
 & 0.84829E+02_JPRB,0.74472E+02_JPRB,0.71563E+02_JPRB,0.70768E+02_JPRB,0.69027E+02_JPRB, &
 & 0.66600E+02_JPRB,0.62760E+02_JPRB,0.63750E+02_JPRB,0.72497E+02_JPRB /)  
KA(:, 5,10,13) = (/ &
 & 0.84210E+02_JPRB,0.73923E+02_JPRB,0.70963E+02_JPRB,0.70409E+02_JPRB,0.68788E+02_JPRB, &
 & 0.66285E+02_JPRB,0.62604E+02_JPRB,0.63643E+02_JPRB,0.72460E+02_JPRB /)  
KA(:, 1,11,13) = (/ &
 & 0.85661E+02_JPRB,0.75976E+02_JPRB,0.75616E+02_JPRB,0.74895E+02_JPRB,0.73796E+02_JPRB, &
 & 0.71450E+02_JPRB,0.66595E+02_JPRB,0.64723E+02_JPRB,0.72988E+02_JPRB /)  
KA(:, 2,11,13) = (/ &
 & 0.85212E+02_JPRB,0.75487E+02_JPRB,0.75133E+02_JPRB,0.74528E+02_JPRB,0.73552E+02_JPRB, &
 & 0.71413E+02_JPRB,0.66688E+02_JPRB,0.64835E+02_JPRB,0.73147E+02_JPRB /)  
KA(:, 3,11,13) = (/ &
 & 0.84633E+02_JPRB,0.74907E+02_JPRB,0.74581E+02_JPRB,0.74183E+02_JPRB,0.73356E+02_JPRB, &
 & 0.71194E+02_JPRB,0.66687E+02_JPRB,0.64831E+02_JPRB,0.73292E+02_JPRB /)  
KA(:, 4,11,13) = (/ &
 & 0.83975E+02_JPRB,0.74286E+02_JPRB,0.73943E+02_JPRB,0.73830E+02_JPRB,0.73088E+02_JPRB, &
 & 0.70916E+02_JPRB,0.66610E+02_JPRB,0.64920E+02_JPRB,0.73470E+02_JPRB /)  
KA(:, 5,11,13) = (/ &
 & 0.83246E+02_JPRB,0.73605E+02_JPRB,0.73209E+02_JPRB,0.73386E+02_JPRB,0.72735E+02_JPRB, &
 & 0.70587E+02_JPRB,0.66523E+02_JPRB,0.64950E+02_JPRB,0.73537E+02_JPRB /)  
KA(:, 1,12,13) = (/ &
 & 0.83352E+02_JPRB,0.75282E+02_JPRB,0.76925E+02_JPRB,0.77365E+02_JPRB,0.77206E+02_JPRB, &
 & 0.74850E+02_JPRB,0.69716E+02_JPRB,0.65048E+02_JPRB,0.72181E+02_JPRB /)  
KA(:, 2,12,13) = (/ &
 & 0.82736E+02_JPRB,0.74597E+02_JPRB,0.76403E+02_JPRB,0.76949E+02_JPRB,0.76971E+02_JPRB, &
 & 0.74863E+02_JPRB,0.69929E+02_JPRB,0.65330E+02_JPRB,0.72664E+02_JPRB /)  
KA(:, 3,12,13) = (/ &
 & 0.82054E+02_JPRB,0.73916E+02_JPRB,0.75743E+02_JPRB,0.76528E+02_JPRB,0.76666E+02_JPRB, &
 & 0.74738E+02_JPRB,0.70022E+02_JPRB,0.65629E+02_JPRB,0.73075E+02_JPRB /)  
KA(:, 4,12,13) = (/ &
 & 0.81316E+02_JPRB,0.73173E+02_JPRB,0.75030E+02_JPRB,0.76061E+02_JPRB,0.76286E+02_JPRB, &
 & 0.74512E+02_JPRB,0.70083E+02_JPRB,0.65825E+02_JPRB,0.73345E+02_JPRB /)  
KA(:, 5,12,13) = (/ &
 & 0.80516E+02_JPRB,0.72378E+02_JPRB,0.74331E+02_JPRB,0.75554E+02_JPRB,0.75785E+02_JPRB, &
 & 0.74233E+02_JPRB,0.70124E+02_JPRB,0.65929E+02_JPRB,0.73501E+02_JPRB /)  
KA(:, 1,13,13) = (/ &
 & 0.79408E+02_JPRB,0.73858E+02_JPRB,0.76980E+02_JPRB,0.78869E+02_JPRB,0.79397E+02_JPRB, &
 & 0.77263E+02_JPRB,0.72263E+02_JPRB,0.65338E+02_JPRB,0.70604E+02_JPRB /)  
KA(:, 2,13,13) = (/ &
 & 0.78716E+02_JPRB,0.73093E+02_JPRB,0.76326E+02_JPRB,0.78426E+02_JPRB,0.79146E+02_JPRB, &
 & 0.77408E+02_JPRB,0.72561E+02_JPRB,0.65807E+02_JPRB,0.71230E+02_JPRB /)  
KA(:, 3,13,13) = (/ &
 & 0.77962E+02_JPRB,0.72251E+02_JPRB,0.75686E+02_JPRB,0.77926E+02_JPRB,0.78867E+02_JPRB, &
 & 0.77356E+02_JPRB,0.72810E+02_JPRB,0.66137E+02_JPRB,0.71698E+02_JPRB /)  
KA(:, 4,13,13) = (/ &
 & 0.77177E+02_JPRB,0.71385E+02_JPRB,0.75042E+02_JPRB,0.77408E+02_JPRB,0.78464E+02_JPRB, &
 & 0.77172E+02_JPRB,0.73006E+02_JPRB,0.66333E+02_JPRB,0.72067E+02_JPRB /)  
KA(:, 5,13,13) = (/ &
 & 0.76340E+02_JPRB,0.70519E+02_JPRB,0.74355E+02_JPRB,0.76889E+02_JPRB,0.78015E+02_JPRB, &
 & 0.76988E+02_JPRB,0.73079E+02_JPRB,0.66485E+02_JPRB,0.72407E+02_JPRB /)  
KA(:, 1, 1,14) = (/ &
 & 0.51404E+02_JPRB,0.45212E+02_JPRB,0.39078E+02_JPRB,0.32978E+02_JPRB,0.31213E+02_JPRB, &
 & 0.35689E+02_JPRB,0.42239E+02_JPRB,0.49109E+02_JPRB,0.53555E+02_JPRB /)  
KA(:, 2, 1,14) = (/ &
 & 0.51456E+02_JPRB,0.45263E+02_JPRB,0.39085E+02_JPRB,0.32975E+02_JPRB,0.31034E+02_JPRB, &
 & 0.35237E+02_JPRB,0.41756E+02_JPRB,0.48531E+02_JPRB,0.52877E+02_JPRB /)  
KA(:, 3, 1,14) = (/ &
 & 0.51419E+02_JPRB,0.45226E+02_JPRB,0.39013E+02_JPRB,0.32932E+02_JPRB,0.30826E+02_JPRB, &
 & 0.34871E+02_JPRB,0.41372E+02_JPRB,0.48070E+02_JPRB,0.52319E+02_JPRB /)  
KA(:, 4, 1,14) = (/ &
 & 0.51315E+02_JPRB,0.45122E+02_JPRB,0.38925E+02_JPRB,0.32886E+02_JPRB,0.30643E+02_JPRB, &
 & 0.34565E+02_JPRB,0.41054E+02_JPRB,0.47690E+02_JPRB,0.51853E+02_JPRB /)  
KA(:, 5, 1,14) = (/ &
 & 0.51134E+02_JPRB,0.44958E+02_JPRB,0.38787E+02_JPRB,0.32819E+02_JPRB,0.30476E+02_JPRB, &
 & 0.34330E+02_JPRB,0.40799E+02_JPRB,0.47384E+02_JPRB,0.51513E+02_JPRB /)  
KA(:, 1, 2,14) = (/ &
 & 0.59575E+02_JPRB,0.52343E+02_JPRB,0.45168E+02_JPRB,0.38156E+02_JPRB,0.36549E+02_JPRB, &
 & 0.40798E+02_JPRB,0.48433E+02_JPRB,0.56320E+02_JPRB,0.62499E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART9',1,ZHOOK_HANDLE)
END SUBROUTINE PART9


SUBROUTINE PART10

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART10',0,ZHOOK_HANDLE)


KA(:, 2, 2,14) = (/ &
 & 0.59656E+02_JPRB,0.52415E+02_JPRB,0.45196E+02_JPRB,0.38159E+02_JPRB,0.36356E+02_JPRB, &
 & 0.40232E+02_JPRB,0.47806E+02_JPRB,0.55603E+02_JPRB,0.61692E+02_JPRB /)  
KA(:, 3, 2,14) = (/ &
 & 0.59635E+02_JPRB,0.52395E+02_JPRB,0.45146E+02_JPRB,0.38116E+02_JPRB,0.36139E+02_JPRB, &
 & 0.39805E+02_JPRB,0.47339E+02_JPRB,0.55046E+02_JPRB,0.61068E+02_JPRB /)  
KA(:, 4, 2,14) = (/ &
 & 0.59522E+02_JPRB,0.52285E+02_JPRB,0.45051E+02_JPRB,0.38066E+02_JPRB,0.35889E+02_JPRB, &
 & 0.39470E+02_JPRB,0.46981E+02_JPRB,0.54621E+02_JPRB,0.60592E+02_JPRB /)  
KA(:, 5, 2,14) = (/ &
 & 0.59307E+02_JPRB,0.52094E+02_JPRB,0.44889E+02_JPRB,0.37960E+02_JPRB,0.35677E+02_JPRB, &
 & 0.39216E+02_JPRB,0.46687E+02_JPRB,0.54268E+02_JPRB,0.60193E+02_JPRB /)  
KA(:, 1, 3,14) = (/ &
 & 0.68809E+02_JPRB,0.60397E+02_JPRB,0.52025E+02_JPRB,0.44161E+02_JPRB,0.42701E+02_JPRB, &
 & 0.46667E+02_JPRB,0.55520E+02_JPRB,0.64493E+02_JPRB,0.72669E+02_JPRB /)  
KA(:, 2, 3,14) = (/ &
 & 0.68924E+02_JPRB,0.60499E+02_JPRB,0.52098E+02_JPRB,0.44133E+02_JPRB,0.42521E+02_JPRB, &
 & 0.45966E+02_JPRB,0.54732E+02_JPRB,0.63594E+02_JPRB,0.71705E+02_JPRB /)  
KA(:, 3, 3,14) = (/ &
 & 0.68950E+02_JPRB,0.60531E+02_JPRB,0.52101E+02_JPRB,0.44100E+02_JPRB,0.42285E+02_JPRB, &
 & 0.45418E+02_JPRB,0.54095E+02_JPRB,0.62883E+02_JPRB,0.70919E+02_JPRB /)  
KA(:, 4, 3,14) = (/ &
 & 0.68857E+02_JPRB,0.60434E+02_JPRB,0.52014E+02_JPRB,0.44041E+02_JPRB,0.42031E+02_JPRB, &
 & 0.45005E+02_JPRB,0.53564E+02_JPRB,0.62291E+02_JPRB,0.70247E+02_JPRB /)  
KA(:, 5, 3,14) = (/ &
 & 0.68666E+02_JPRB,0.60265E+02_JPRB,0.51871E+02_JPRB,0.43942E+02_JPRB,0.41842E+02_JPRB, &
 & 0.44690E+02_JPRB,0.53134E+02_JPRB,0.61806E+02_JPRB,0.69686E+02_JPRB /)  
KA(:, 1, 4,14) = (/ &
 & 0.79311E+02_JPRB,0.69561E+02_JPRB,0.59881E+02_JPRB,0.51276E+02_JPRB,0.49761E+02_JPRB, &
 & 0.53193E+02_JPRB,0.63396E+02_JPRB,0.73656E+02_JPRB,0.83652E+02_JPRB /)  
KA(:, 2, 4,14) = (/ &
 & 0.79511E+02_JPRB,0.69736E+02_JPRB,0.60019E+02_JPRB,0.51173E+02_JPRB,0.49594E+02_JPRB, &
 & 0.52466E+02_JPRB,0.62461E+02_JPRB,0.72578E+02_JPRB,0.82426E+02_JPRB /)  
KA(:, 3, 4,14) = (/ &
 & 0.79562E+02_JPRB,0.69789E+02_JPRB,0.60043E+02_JPRB,0.51075E+02_JPRB,0.49346E+02_JPRB, &
 & 0.51847E+02_JPRB,0.61639E+02_JPRB,0.71632E+02_JPRB,0.81369E+02_JPRB /)  
KA(:, 4, 4,14) = (/ &
 & 0.79512E+02_JPRB,0.69733E+02_JPRB,0.59989E+02_JPRB,0.50979E+02_JPRB,0.49088E+02_JPRB, &
 & 0.51360E+02_JPRB,0.60947E+02_JPRB,0.70836E+02_JPRB,0.80468E+02_JPRB /)  
KA(:, 5, 4,14) = (/ &
 & 0.79325E+02_JPRB,0.69569E+02_JPRB,0.59854E+02_JPRB,0.50871E+02_JPRB,0.48882E+02_JPRB, &
 & 0.50991E+02_JPRB,0.60362E+02_JPRB,0.70161E+02_JPRB,0.79701E+02_JPRB /)  
KA(:, 1, 5,14) = (/ &
 & 0.91112E+02_JPRB,0.79892E+02_JPRB,0.68781E+02_JPRB,0.59496E+02_JPRB,0.57988E+02_JPRB, &
 & 0.60415E+02_JPRB,0.71595E+02_JPRB,0.83227E+02_JPRB,0.94854E+02_JPRB /)  
KA(:, 2, 5,14) = (/ &
 & 0.91447E+02_JPRB,0.80173E+02_JPRB,0.69023E+02_JPRB,0.59416E+02_JPRB,0.57743E+02_JPRB, &
 & 0.59673E+02_JPRB,0.70483E+02_JPRB,0.81942E+02_JPRB,0.93394E+02_JPRB /)  
KA(:, 3, 5,14) = (/ &
 & 0.91583E+02_JPRB,0.80288E+02_JPRB,0.69106E+02_JPRB,0.59276E+02_JPRB,0.57416E+02_JPRB, &
 & 0.59035E+02_JPRB,0.69528E+02_JPRB,0.80829E+02_JPRB,0.92131E+02_JPRB /)  
KA(:, 4, 5,14) = (/ &
 & 0.91566E+02_JPRB,0.80257E+02_JPRB,0.69073E+02_JPRB,0.59136E+02_JPRB,0.57092E+02_JPRB, &
 & 0.58527E+02_JPRB,0.68724E+02_JPRB,0.79885E+02_JPRB,0.91053E+02_JPRB /)  
KA(:, 5, 5,14) = (/ &
 & 0.91390E+02_JPRB,0.80104E+02_JPRB,0.68937E+02_JPRB,0.58973E+02_JPRB,0.56776E+02_JPRB, &
 & 0.58107E+02_JPRB,0.68079E+02_JPRB,0.79072E+02_JPRB,0.90122E+02_JPRB /)  
KA(:, 1, 6,14) = (/ &
 & 0.10419E+03_JPRB,0.91394E+02_JPRB,0.78656E+02_JPRB,0.68916E+02_JPRB,0.67128E+02_JPRB, &
 & 0.68461E+02_JPRB,0.79894E+02_JPRB,0.92926E+02_JPRB,0.10607E+03_JPRB /)  
KA(:, 2, 6,14) = (/ &
 & 0.10463E+03_JPRB,0.91782E+02_JPRB,0.79002E+02_JPRB,0.68819E+02_JPRB,0.66845E+02_JPRB, &
 & 0.67738E+02_JPRB,0.78628E+02_JPRB,0.91458E+02_JPRB,0.10440E+03_JPRB /)  
KA(:, 3, 6,14) = (/ &
 & 0.10486E+03_JPRB,0.91970E+02_JPRB,0.79156E+02_JPRB,0.68698E+02_JPRB,0.66470E+02_JPRB, &
 & 0.67066E+02_JPRB,0.77628E+02_JPRB,0.90242E+02_JPRB,0.10302E+03_JPRB /)  
KA(:, 4, 6,14) = (/ &
 & 0.10494E+03_JPRB,0.92025E+02_JPRB,0.79207E+02_JPRB,0.68555E+02_JPRB,0.66081E+02_JPRB, &
 & 0.66543E+02_JPRB,0.76843E+02_JPRB,0.89253E+02_JPRB,0.10189E+03_JPRB /)  
KA(:, 5, 6,14) = (/ &
 & 0.10481E+03_JPRB,0.91892E+02_JPRB,0.79105E+02_JPRB,0.68344E+02_JPRB,0.65668E+02_JPRB, &
 & 0.66109E+02_JPRB,0.76190E+02_JPRB,0.88386E+02_JPRB,0.10090E+03_JPRB /)  
KA(:, 1, 7,14) = (/ &
 & 0.11850E+03_JPRB,0.10394E+03_JPRB,0.89423E+02_JPRB,0.79509E+02_JPRB,0.77207E+02_JPRB, &
 & 0.77196E+02_JPRB,0.87943E+02_JPRB,0.10236E+03_JPRB,0.11694E+03_JPRB /)  
KA(:, 2, 7,14) = (/ &
 & 0.11905E+03_JPRB,0.10443E+03_JPRB,0.89864E+02_JPRB,0.79528E+02_JPRB,0.76905E+02_JPRB, &
 & 0.76494E+02_JPRB,0.86650E+02_JPRB,0.10078E+03_JPRB,0.11515E+03_JPRB /)  
KA(:, 3, 7,14) = (/ &
 & 0.11939E+03_JPRB,0.10473E+03_JPRB,0.90115E+02_JPRB,0.79401E+02_JPRB,0.76523E+02_JPRB, &
 & 0.75853E+02_JPRB,0.85715E+02_JPRB,0.99595E+02_JPRB,0.11380E+03_JPRB /)  
KA(:, 4, 7,14) = (/ &
 & 0.11951E+03_JPRB,0.10484E+03_JPRB,0.90222E+02_JPRB,0.79220E+02_JPRB,0.76090E+02_JPRB, &
 & 0.75405E+02_JPRB,0.85022E+02_JPRB,0.98653E+02_JPRB,0.11271E+03_JPRB /)  
KA(:, 5, 7,14) = (/ &
 & 0.11942E+03_JPRB,0.10476E+03_JPRB,0.90169E+02_JPRB,0.78976E+02_JPRB,0.75607E+02_JPRB, &
 & 0.75018E+02_JPRB,0.84352E+02_JPRB,0.97783E+02_JPRB,0.11167E+03_JPRB /)  
KA(:, 1, 8,14) = (/ &
 & 0.13381E+03_JPRB,0.11735E+03_JPRB,0.10095E+03_JPRB,0.91226E+02_JPRB,0.88188E+02_JPRB, &
 & 0.86379E+02_JPRB,0.95828E+02_JPRB,0.11155E+03_JPRB,0.12755E+03_JPRB /)  
KA(:, 2, 8,14) = (/ &
 & 0.13446E+03_JPRB,0.11794E+03_JPRB,0.10145E+03_JPRB,0.91271E+02_JPRB,0.87947E+02_JPRB, &
 & 0.85766E+02_JPRB,0.94652E+02_JPRB,0.11006E+03_JPRB,0.12583E+03_JPRB /)  
KA(:, 3, 8,14) = (/ &
 & 0.13492E+03_JPRB,0.11834E+03_JPRB,0.10180E+03_JPRB,0.91233E+02_JPRB,0.87619E+02_JPRB, &
 & 0.85228E+02_JPRB,0.93811E+02_JPRB,0.10892E+03_JPRB,0.12452E+03_JPRB /)  
KA(:, 4, 8,14) = (/ &
 & 0.13505E+03_JPRB,0.11846E+03_JPRB,0.10192E+03_JPRB,0.91090E+02_JPRB,0.87150E+02_JPRB, &
 & 0.84887E+02_JPRB,0.93111E+02_JPRB,0.10797E+03_JPRB,0.12337E+03_JPRB /)  
KA(:, 5, 8,14) = (/ &
 & 0.13500E+03_JPRB,0.11844E+03_JPRB,0.10192E+03_JPRB,0.90797E+02_JPRB,0.86626E+02_JPRB, &
 & 0.84570E+02_JPRB,0.92421E+02_JPRB,0.10710E+03_JPRB,0.12226E+03_JPRB /)  
KA(:, 1, 9,14) = (/ &
 & 0.14952E+03_JPRB,0.13110E+03_JPRB,0.11316E+03_JPRB,0.10410E+03_JPRB,0.99927E+02_JPRB, &
 & 0.96074E+02_JPRB,0.10374E+03_JPRB,0.12067E+03_JPRB,0.13801E+03_JPRB /)  
KA(:, 2, 9,14) = (/ &
 & 0.15028E+03_JPRB,0.13179E+03_JPRB,0.11360E+03_JPRB,0.10415E+03_JPRB,0.99870E+02_JPRB, &
 & 0.95589E+02_JPRB,0.10257E+03_JPRB,0.11912E+03_JPRB,0.13623E+03_JPRB /)  
KA(:, 3, 9,14) = (/ &
 & 0.15082E+03_JPRB,0.13227E+03_JPRB,0.11392E+03_JPRB,0.10405E+03_JPRB,0.99571E+02_JPRB, &
 & 0.95189E+02_JPRB,0.10182E+03_JPRB,0.11803E+03_JPRB,0.13496E+03_JPRB /)  
KA(:, 4, 9,14) = (/ &
 & 0.15103E+03_JPRB,0.13247E+03_JPRB,0.11403E+03_JPRB,0.10385E+03_JPRB,0.99126E+02_JPRB, &
 & 0.94980E+02_JPRB,0.10122E+03_JPRB,0.11720E+03_JPRB,0.13388E+03_JPRB /)  
KA(:, 5, 9,14) = (/ &
 & 0.15094E+03_JPRB,0.13245E+03_JPRB,0.11401E+03_JPRB,0.10348E+03_JPRB,0.98550E+02_JPRB, &
 & 0.94746E+02_JPRB,0.10055E+03_JPRB,0.11636E+03_JPRB,0.13276E+03_JPRB /)  
KA(:, 1,10,14) = (/ &
 & 0.16524E+03_JPRB,0.14486E+03_JPRB,0.12594E+03_JPRB,0.11785E+03_JPRB,0.11225E+03_JPRB, &
 & 0.10654E+03_JPRB,0.11202E+03_JPRB,0.12965E+03_JPRB,0.14829E+03_JPRB /)  
KA(:, 2,10,14) = (/ &
 & 0.16610E+03_JPRB,0.14564E+03_JPRB,0.12636E+03_JPRB,0.11787E+03_JPRB,0.11233E+03_JPRB, &
 & 0.10630E+03_JPRB,0.11093E+03_JPRB,0.12811E+03_JPRB,0.14653E+03_JPRB /)  
KA(:, 3,10,14) = (/ &
 & 0.16659E+03_JPRB,0.14608E+03_JPRB,0.12656E+03_JPRB,0.11769E+03_JPRB,0.11214E+03_JPRB, &
 & 0.10609E+03_JPRB,0.11032E+03_JPRB,0.12713E+03_JPRB,0.14532E+03_JPRB /)  
KA(:, 4,10,14) = (/ &
 & 0.16681E+03_JPRB,0.14630E+03_JPRB,0.12659E+03_JPRB,0.11736E+03_JPRB,0.11169E+03_JPRB, &
 & 0.10597E+03_JPRB,0.10973E+03_JPRB,0.12629E+03_JPRB,0.14416E+03_JPRB /)  
KA(:, 5,10,14) = (/ &
 & 0.16671E+03_JPRB,0.14623E+03_JPRB,0.12639E+03_JPRB,0.11688E+03_JPRB,0.11111E+03_JPRB, &
 & 0.10576E+03_JPRB,0.10909E+03_JPRB,0.12542E+03_JPRB,0.14303E+03_JPRB /)  
KA(:, 1,11,14) = (/ &
 & 0.18065E+03_JPRB,0.15832E+03_JPRB,0.13903E+03_JPRB,0.13201E+03_JPRB,0.12519E+03_JPRB, &
 & 0.11820E+03_JPRB,0.12047E+03_JPRB,0.13760E+03_JPRB,0.15739E+03_JPRB /)  
KA(:, 2,11,14) = (/ &
 & 0.18131E+03_JPRB,0.15893E+03_JPRB,0.13916E+03_JPRB,0.13183E+03_JPRB,0.12520E+03_JPRB, &
 & 0.11800E+03_JPRB,0.11979E+03_JPRB,0.13660E+03_JPRB,0.15612E+03_JPRB /)  
KA(:, 3,11,14) = (/ &
 & 0.18162E+03_JPRB,0.15925E+03_JPRB,0.13912E+03_JPRB,0.13145E+03_JPRB,0.12487E+03_JPRB, &
 & 0.11789E+03_JPRB,0.11922E+03_JPRB,0.13566E+03_JPRB,0.15481E+03_JPRB /)  
KA(:, 4,11,14) = (/ &
 & 0.18161E+03_JPRB,0.15927E+03_JPRB,0.13888E+03_JPRB,0.13091E+03_JPRB,0.12432E+03_JPRB, &
 & 0.11770E+03_JPRB,0.11858E+03_JPRB,0.13462E+03_JPRB,0.15350E+03_JPRB /)  
KA(:, 5,11,14) = (/ &
 & 0.18129E+03_JPRB,0.15901E+03_JPRB,0.13849E+03_JPRB,0.13027E+03_JPRB,0.12371E+03_JPRB, &
 & 0.11738E+03_JPRB,0.11800E+03_JPRB,0.13378E+03_JPRB,0.15248E+03_JPRB /)  
KA(:, 1,12,14) = (/ &
 & 0.19439E+03_JPRB,0.17031E+03_JPRB,0.15181E+03_JPRB,0.14577E+03_JPRB,0.13828E+03_JPRB, &
 & 0.13070E+03_JPRB,0.12972E+03_JPRB,0.14546E+03_JPRB,0.16618E+03_JPRB /)  
KA(:, 2,12,14) = (/ &
 & 0.19483E+03_JPRB,0.17073E+03_JPRB,0.15156E+03_JPRB,0.14543E+03_JPRB,0.13812E+03_JPRB, &
 & 0.13043E+03_JPRB,0.12913E+03_JPRB,0.14443E+03_JPRB,0.16476E+03_JPRB /)  
KA(:, 3,12,14) = (/ &
 & 0.19494E+03_JPRB,0.17087E+03_JPRB,0.15124E+03_JPRB,0.14493E+03_JPRB,0.13771E+03_JPRB, &
 & 0.13020E+03_JPRB,0.12847E+03_JPRB,0.14330E+03_JPRB,0.16335E+03_JPRB /)  
KA(:, 4,12,14) = (/ &
 & 0.19474E+03_JPRB,0.17073E+03_JPRB,0.15078E+03_JPRB,0.14425E+03_JPRB,0.13718E+03_JPRB, &
 & 0.12986E+03_JPRB,0.12779E+03_JPRB,0.14240E+03_JPRB,0.16229E+03_JPRB /)  
KA(:, 5,12,14) = (/ &
 & 0.19420E+03_JPRB,0.17029E+03_JPRB,0.15011E+03_JPRB,0.14337E+03_JPRB,0.13666E+03_JPRB, &
 & 0.12942E+03_JPRB,0.12725E+03_JPRB,0.14171E+03_JPRB,0.16147E+03_JPRB /)  
KA(:, 1,13,14) = (/ &
 & 0.20562E+03_JPRB,0.18014E+03_JPRB,0.16395E+03_JPRB,0.15885E+03_JPRB,0.15131E+03_JPRB, &
 & 0.14344E+03_JPRB,0.13928E+03_JPRB,0.15201E+03_JPRB,0.17336E+03_JPRB /)  
KA(:, 2,13,14) = (/ &
 & 0.20583E+03_JPRB,0.18034E+03_JPRB,0.16346E+03_JPRB,0.15844E+03_JPRB,0.15102E+03_JPRB, &
 & 0.14310E+03_JPRB,0.13867E+03_JPRB,0.15101E+03_JPRB,0.17210E+03_JPRB /)  
KA(:, 3,13,14) = (/ &
 & 0.20579E+03_JPRB,0.18034E+03_JPRB,0.16282E+03_JPRB,0.15782E+03_JPRB,0.15051E+03_JPRB, &
 & 0.14271E+03_JPRB,0.13803E+03_JPRB,0.15026E+03_JPRB,0.17119E+03_JPRB /)  
KA(:, 4,13,14) = (/ &
 & 0.20539E+03_JPRB,0.18002E+03_JPRB,0.16199E+03_JPRB,0.15696E+03_JPRB,0.15005E+03_JPRB, &
 & 0.14226E+03_JPRB,0.13746E+03_JPRB,0.14977E+03_JPRB,0.17061E+03_JPRB /)  
KA(:, 5,13,14) = (/ &
 & 0.20471E+03_JPRB,0.17946E+03_JPRB,0.16101E+03_JPRB,0.15580E+03_JPRB,0.14942E+03_JPRB, &
 & 0.14163E+03_JPRB,0.13685E+03_JPRB,0.14922E+03_JPRB,0.16998E+03_JPRB /)  
KA(:, 1, 1,15) = (/ &
 & 0.61110E+02_JPRB,0.53539E+02_JPRB,0.46005E+02_JPRB,0.38902E+02_JPRB,0.35970E+02_JPRB, &
 & 0.43986E+02_JPRB,0.52608E+02_JPRB,0.61157E+02_JPRB,0.65911E+02_JPRB /)  
KA(:, 2, 1,15) = (/ &
 & 0.61315E+02_JPRB,0.53717E+02_JPRB,0.46235E+02_JPRB,0.39083E+02_JPRB,0.35687E+02_JPRB, &
 & 0.43381E+02_JPRB,0.51871E+02_JPRB,0.60290E+02_JPRB,0.64963E+02_JPRB /)  
KA(:, 3, 1,15) = (/ &
 & 0.61422E+02_JPRB,0.53821E+02_JPRB,0.46411E+02_JPRB,0.39188E+02_JPRB,0.35438E+02_JPRB, &
 & 0.42839E+02_JPRB,0.51205E+02_JPRB,0.59514E+02_JPRB,0.64157E+02_JPRB /)  
KA(:, 4, 1,15) = (/ &
 & 0.61394E+02_JPRB,0.53877E+02_JPRB,0.46504E+02_JPRB,0.39222E+02_JPRB,0.35189E+02_JPRB, &
 & 0.42365E+02_JPRB,0.50625E+02_JPRB,0.58813E+02_JPRB,0.63464E+02_JPRB /)  
KA(:, 5, 1,15) = (/ &
 & 0.61322E+02_JPRB,0.53865E+02_JPRB,0.46511E+02_JPRB,0.39177E+02_JPRB,0.34939E+02_JPRB, &
 & 0.41926E+02_JPRB,0.50070E+02_JPRB,0.58152E+02_JPRB,0.62761E+02_JPRB /)  
KA(:, 1, 2,15) = (/ &
 & 0.73139E+02_JPRB,0.64054E+02_JPRB,0.54971E+02_JPRB,0.46172E+02_JPRB,0.42554E+02_JPRB, &
 & 0.52369E+02_JPRB,0.62683E+02_JPRB,0.72904E+02_JPRB,0.80226E+02_JPRB /)  
KA(:, 2, 2,15) = (/ &
 & 0.73363E+02_JPRB,0.64250E+02_JPRB,0.55203E+02_JPRB,0.46423E+02_JPRB,0.42168E+02_JPRB, &
 & 0.51668E+02_JPRB,0.61839E+02_JPRB,0.71917E+02_JPRB,0.79110E+02_JPRB /)  
KA(:, 3, 2,15) = (/ &
 & 0.73487E+02_JPRB,0.64383E+02_JPRB,0.55429E+02_JPRB,0.46632E+02_JPRB,0.41828E+02_JPRB, &
 & 0.50986E+02_JPRB,0.61016E+02_JPRB,0.70950E+02_JPRB,0.78048E+02_JPRB /)  
KA(:, 4, 2,15) = (/ &
 & 0.73536E+02_JPRB,0.64501E+02_JPRB,0.55558E+02_JPRB,0.46729E+02_JPRB,0.41557E+02_JPRB, &
 & 0.50314E+02_JPRB,0.60204E+02_JPRB,0.70005E+02_JPRB,0.77009E+02_JPRB /)  
KA(:, 5, 2,15) = (/ &
 & 0.73500E+02_JPRB,0.64509E+02_JPRB,0.55582E+02_JPRB,0.46709E+02_JPRB,0.41283E+02_JPRB, &
 & 0.49695E+02_JPRB,0.59450E+02_JPRB,0.69119E+02_JPRB,0.76024E+02_JPRB /)  
KA(:, 1, 3,15) = (/ &
 & 0.87361E+02_JPRB,0.76491E+02_JPRB,0.65621E+02_JPRB,0.54890E+02_JPRB,0.50598E+02_JPRB, &
 & 0.62297E+02_JPRB,0.74612E+02_JPRB,0.86825E+02_JPRB,0.97550E+02_JPRB /)  
KA(:, 2, 3,15) = (/ &
 & 0.87685E+02_JPRB,0.76774E+02_JPRB,0.65885E+02_JPRB,0.55188E+02_JPRB,0.50206E+02_JPRB, &
 & 0.61585E+02_JPRB,0.73754E+02_JPRB,0.85807E+02_JPRB,0.96409E+02_JPRB /)  
KA(:, 3, 3,15) = (/ &
 & 0.87844E+02_JPRB,0.76919E+02_JPRB,0.66106E+02_JPRB,0.55413E+02_JPRB,0.49812E+02_JPRB, &
 & 0.60785E+02_JPRB,0.72789E+02_JPRB,0.84689E+02_JPRB,0.95141E+02_JPRB /)  
KA(:, 4, 3,15) = (/ &
 & 0.87889E+02_JPRB,0.77037E+02_JPRB,0.66247E+02_JPRB,0.55541E+02_JPRB,0.49446E+02_JPRB, &
 & 0.60010E+02_JPRB,0.71857E+02_JPRB,0.83593E+02_JPRB,0.93898E+02_JPRB /)  
KA(:, 5, 3,15) = (/ &
 & 0.87858E+02_JPRB,0.77051E+02_JPRB,0.66285E+02_JPRB,0.55583E+02_JPRB,0.49097E+02_JPRB, &
 & 0.59241E+02_JPRB,0.70929E+02_JPRB,0.82513E+02_JPRB,0.92686E+02_JPRB /)  
KA(:, 1, 4,15) = (/ &
 & 0.10387E+03_JPRB,0.90929E+02_JPRB,0.77989E+02_JPRB,0.65095E+02_JPRB,0.60436E+02_JPRB, &
 & 0.74039E+02_JPRB,0.88717E+02_JPRB,0.10327E+03_JPRB,0.11725E+03_JPRB /)  
KA(:, 2, 4,15) = (/ &
 & 0.10441E+03_JPRB,0.91405E+02_JPRB,0.78408E+02_JPRB,0.65545E+02_JPRB,0.59926E+02_JPRB, &
 & 0.73070E+02_JPRB,0.87549E+02_JPRB,0.10190E+03_JPRB,0.11570E+03_JPRB /)  
KA(:, 3, 4,15) = (/ &
 & 0.10471E+03_JPRB,0.91680E+02_JPRB,0.78722E+02_JPRB,0.65845E+02_JPRB,0.59509E+02_JPRB, &
 & 0.72264E+02_JPRB,0.86581E+02_JPRB,0.10076E+03_JPRB,0.11440E+03_JPRB /)  
KA(:, 4, 4,15) = (/ &
 & 0.10486E+03_JPRB,0.91873E+02_JPRB,0.78926E+02_JPRB,0.66032E+02_JPRB,0.59086E+02_JPRB, &
 & 0.71381E+02_JPRB,0.85514E+02_JPRB,0.99526E+02_JPRB,0.11299E+03_JPRB /)  
KA(:, 5, 4,15) = (/ &
 & 0.10483E+03_JPRB,0.91879E+02_JPRB,0.78952E+02_JPRB,0.66063E+02_JPRB,0.58651E+02_JPRB, &
 & 0.70432E+02_JPRB,0.84377E+02_JPRB,0.98185E+02_JPRB,0.11148E+03_JPRB /)  
KA(:, 1, 5,15) = (/ &
 & 0.12314E+03_JPRB,0.10778E+03_JPRB,0.92429E+02_JPRB,0.77074E+02_JPRB,0.72086E+02_JPRB, &
 & 0.87688E+02_JPRB,0.10511E+03_JPRB,0.12238E+03_JPRB,0.13959E+03_JPRB /)  
KA(:, 2, 5,15) = (/ &
 & 0.12380E+03_JPRB,0.10836E+03_JPRB,0.92922E+02_JPRB,0.77571E+02_JPRB,0.71572E+02_JPRB, &
 & 0.86586E+02_JPRB,0.10378E+03_JPRB,0.12082E+03_JPRB,0.13782E+03_JPRB /)  
KA(:, 3, 5,15) = (/ &
 & 0.12423E+03_JPRB,0.10877E+03_JPRB,0.93351E+02_JPRB,0.77983E+02_JPRB,0.71097E+02_JPRB, &
 & 0.85507E+02_JPRB,0.10249E+03_JPRB,0.11931E+03_JPRB,0.13609E+03_JPRB /)  
KA(:, 4, 5,15) = (/ &
 & 0.12450E+03_JPRB,0.10905E+03_JPRB,0.93631E+02_JPRB,0.78238E+02_JPRB,0.70653E+02_JPRB, &
 & 0.84488E+02_JPRB,0.10126E+03_JPRB,0.11788E+03_JPRB,0.13445E+03_JPRB /)  
KA(:, 5, 5,15) = (/ &
 & 0.12453E+03_JPRB,0.10910E+03_JPRB,0.93684E+02_JPRB,0.78289E+02_JPRB,0.70179E+02_JPRB, &
 & 0.83403E+02_JPRB,0.99954E+02_JPRB,0.11636E+03_JPRB,0.13271E+03_JPRB /)  
KA(:, 1, 6,15) = (/ &
 & 0.14538E+03_JPRB,0.12724E+03_JPRB,0.10910E+03_JPRB,0.90962E+02_JPRB,0.85931E+02_JPRB, &
 & 0.10354E+03_JPRB,0.12413E+03_JPRB,0.14456E+03_JPRB,0.16524E+03_JPRB /)  
KA(:, 2, 6,15) = (/ &
 & 0.14625E+03_JPRB,0.12800E+03_JPRB,0.10975E+03_JPRB,0.91547E+02_JPRB,0.85303E+02_JPRB, &
 & 0.10223E+03_JPRB,0.12256E+03_JPRB,0.14271E+03_JPRB,0.16313E+03_JPRB /)  
KA(:, 3, 6,15) = (/ &
 & 0.14683E+03_JPRB,0.12855E+03_JPRB,0.11028E+03_JPRB,0.92053E+02_JPRB,0.84796E+02_JPRB, &
 & 0.10095E+03_JPRB,0.12102E+03_JPRB,0.14092E+03_JPRB,0.16108E+03_JPRB /)  
KA(:, 4, 6,15) = (/ &
 & 0.14716E+03_JPRB,0.12887E+03_JPRB,0.11059E+03_JPRB,0.92330E+02_JPRB,0.84296E+02_JPRB, &
 & 0.99657E+02_JPRB,0.11947E+03_JPRB,0.13910E+03_JPRB,0.15900E+03_JPRB /)  
KA(:, 5, 6,15) = (/ &
 & 0.14726E+03_JPRB,0.12897E+03_JPRB,0.11069E+03_JPRB,0.92414E+02_JPRB,0.83857E+02_JPRB, &
 & 0.98384E+02_JPRB,0.11794E+03_JPRB,0.13732E+03_JPRB,0.15696E+03_JPRB /)  
KA(:, 1, 7,15) = (/ &
 & 0.17053E+03_JPRB,0.14925E+03_JPRB,0.12796E+03_JPRB,0.10716E+03_JPRB,0.10213E+03_JPRB, &
 & 0.12188E+03_JPRB,0.14615E+03_JPRB,0.17020E+03_JPRB,0.19480E+03_JPRB /)  
KA(:, 2, 7,15) = (/ &
 & 0.17172E+03_JPRB,0.15029E+03_JPRB,0.12885E+03_JPRB,0.10758E+03_JPRB,0.10144E+03_JPRB, &
 & 0.12029E+03_JPRB,0.14423E+03_JPRB,0.16798E+03_JPRB,0.19224E+03_JPRB /)  
KA(:, 3, 7,15) = (/ &
 & 0.17251E+03_JPRB,0.15103E+03_JPRB,0.12955E+03_JPRB,0.10811E+03_JPRB,0.10086E+03_JPRB, &
 & 0.11869E+03_JPRB,0.14231E+03_JPRB,0.16572E+03_JPRB,0.18967E+03_JPRB /)  
KA(:, 4, 7,15) = (/ &
 & 0.17303E+03_JPRB,0.15150E+03_JPRB,0.12997E+03_JPRB,0.10845E+03_JPRB,0.10032E+03_JPRB, &
 & 0.11701E+03_JPRB,0.14029E+03_JPRB,0.16338E+03_JPRB,0.18697E+03_JPRB /)  
KA(:, 5, 7,15) = (/ &
 & 0.17326E+03_JPRB,0.15170E+03_JPRB,0.13015E+03_JPRB,0.10860E+03_JPRB,0.99828E+02_JPRB, &
 & 0.11540E+03_JPRB,0.13837E+03_JPRB,0.16114E+03_JPRB,0.18440E+03_JPRB /)  
KA(:, 1, 8,15) = (/ &
 & 0.19897E+03_JPRB,0.17412E+03_JPRB,0.14927E+03_JPRB,0.12609E+03_JPRB,0.12102E+03_JPRB, &
 & 0.14307E+03_JPRB,0.17149E+03_JPRB,0.19971E+03_JPRB,0.22868E+03_JPRB /)  
KA(:, 2, 8,15) = (/ &
 & 0.20045E+03_JPRB,0.17541E+03_JPRB,0.15039E+03_JPRB,0.12643E+03_JPRB,0.12014E+03_JPRB, &
 & 0.14095E+03_JPRB,0.16896E+03_JPRB,0.19679E+03_JPRB,0.22532E+03_JPRB /)  
KA(:, 3, 8,15) = (/ &
 & 0.20144E+03_JPRB,0.17633E+03_JPRB,0.15122E+03_JPRB,0.12673E+03_JPRB,0.11946E+03_JPRB, &
 & 0.13885E+03_JPRB,0.16646E+03_JPRB,0.19386E+03_JPRB,0.22200E+03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART10',1,ZHOOK_HANDLE)
END SUBROUTINE PART10


SUBROUTINE PART11

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART11',0,ZHOOK_HANDLE)


KA(:, 4, 8,15) = (/ &
 & 0.20212E+03_JPRB,0.17694E+03_JPRB,0.15175E+03_JPRB,0.12692E+03_JPRB,0.11890E+03_JPRB, &
 & 0.13670E+03_JPRB,0.16392E+03_JPRB,0.19092E+03_JPRB,0.21864E+03_JPRB /)  
KA(:, 5, 8,15) = (/ &
 & 0.20244E+03_JPRB,0.17722E+03_JPRB,0.15200E+03_JPRB,0.12703E+03_JPRB,0.11832E+03_JPRB, &
 & 0.13474E+03_JPRB,0.16157E+03_JPRB,0.18819E+03_JPRB,0.21551E+03_JPRB /)  
KA(:, 1, 9,15) = (/ &
 & 0.23120E+03_JPRB,0.20232E+03_JPRB,0.17344E+03_JPRB,0.14797E+03_JPRB,0.14299E+03_JPRB, &
 & 0.16694E+03_JPRB,0.20011E+03_JPRB,0.23304E+03_JPRB,0.26690E+03_JPRB /)  
KA(:, 2, 9,15) = (/ &
 & 0.23311E+03_JPRB,0.20399E+03_JPRB,0.17488E+03_JPRB,0.14825E+03_JPRB,0.14181E+03_JPRB, &
 & 0.16424E+03_JPRB,0.19689E+03_JPRB,0.22930E+03_JPRB,0.26259E+03_JPRB /)  
KA(:, 3, 9,15) = (/ &
 & 0.23434E+03_JPRB,0.20510E+03_JPRB,0.17587E+03_JPRB,0.14844E+03_JPRB,0.14100E+03_JPRB, &
 & 0.16150E+03_JPRB,0.19359E+03_JPRB,0.22546E+03_JPRB,0.25821E+03_JPRB /)  
KA(:, 4, 9,15) = (/ &
 & 0.23518E+03_JPRB,0.20584E+03_JPRB,0.17651E+03_JPRB,0.14849E+03_JPRB,0.14028E+03_JPRB, &
 & 0.15873E+03_JPRB,0.19031E+03_JPRB,0.22162E+03_JPRB,0.25383E+03_JPRB /)  
KA(:, 5, 9,15) = (/ &
 & 0.23553E+03_JPRB,0.20616E+03_JPRB,0.17678E+03_JPRB,0.14839E+03_JPRB,0.13959E+03_JPRB, &
 & 0.15626E+03_JPRB,0.18736E+03_JPRB,0.21823E+03_JPRB,0.24993E+03_JPRB /)  
KA(:, 1,10,15) = (/ &
 & 0.26766E+03_JPRB,0.23422E+03_JPRB,0.20086E+03_JPRB,0.17305E+03_JPRB,0.16820E+03_JPRB, &
 & 0.19275E+03_JPRB,0.23109E+03_JPRB,0.26916E+03_JPRB,0.30826E+03_JPRB /)  
KA(:, 2,10,15) = (/ &
 & 0.26991E+03_JPRB,0.23619E+03_JPRB,0.20254E+03_JPRB,0.17334E+03_JPRB,0.16673E+03_JPRB, &
 & 0.18936E+03_JPRB,0.22702E+03_JPRB,0.26442E+03_JPRB,0.30283E+03_JPRB /)  
KA(:, 3,10,15) = (/ &
 & 0.27155E+03_JPRB,0.23766E+03_JPRB,0.20381E+03_JPRB,0.17344E+03_JPRB,0.16570E+03_JPRB, &
 & 0.18588E+03_JPRB,0.22280E+03_JPRB,0.25950E+03_JPRB,0.29719E+03_JPRB /)  
KA(:, 4,10,15) = (/ &
 & 0.27254E+03_JPRB,0.23853E+03_JPRB,0.20456E+03_JPRB,0.17332E+03_JPRB,0.16480E+03_JPRB, &
 & 0.18267E+03_JPRB,0.21887E+03_JPRB,0.25495E+03_JPRB,0.29197E+03_JPRB /)  
KA(:, 5,10,15) = (/ &
 & 0.27304E+03_JPRB,0.23896E+03_JPRB,0.20491E+03_JPRB,0.17301E+03_JPRB,0.16390E+03_JPRB, &
 & 0.17979E+03_JPRB,0.21534E+03_JPRB,0.25082E+03_JPRB,0.28725E+03_JPRB /)  
KA(:, 1,11,15) = (/ &
 & 0.31010E+03_JPRB,0.27147E+03_JPRB,0.23291E+03_JPRB,0.20181E+03_JPRB,0.19592E+03_JPRB, &
 & 0.21861E+03_JPRB,0.26152E+03_JPRB,0.30466E+03_JPRB,0.34889E+03_JPRB /)  
KA(:, 2,11,15) = (/ &
 & 0.31237E+03_JPRB,0.27343E+03_JPRB,0.23463E+03_JPRB,0.20183E+03_JPRB,0.19444E+03_JPRB, &
 & 0.21467E+03_JPRB,0.25634E+03_JPRB,0.29864E+03_JPRB,0.34194E+03_JPRB /)  
KA(:, 3,11,15) = (/ &
 & 0.31396E+03_JPRB,0.27478E+03_JPRB,0.23578E+03_JPRB,0.20169E+03_JPRB,0.19320E+03_JPRB, &
 & 0.21082E+03_JPRB,0.25169E+03_JPRB,0.29321E+03_JPRB,0.33575E+03_JPRB /)  
KA(:, 4,11,15) = (/ &
 & 0.31491E+03_JPRB,0.27559E+03_JPRB,0.23646E+03_JPRB,0.20134E+03_JPRB,0.19199E+03_JPRB, &
 & 0.20744E+03_JPRB,0.24738E+03_JPRB,0.28820E+03_JPRB,0.33002E+03_JPRB /)  
KA(:, 5,11,15) = (/ &
 & 0.31516E+03_JPRB,0.27581E+03_JPRB,0.23662E+03_JPRB,0.20063E+03_JPRB,0.19065E+03_JPRB, &
 & 0.20428E+03_JPRB,0.24308E+03_JPRB,0.28319E+03_JPRB,0.32426E+03_JPRB /)  
KA(:, 1,12,15) = (/ &
 & 0.35746E+03_JPRB,0.31300E+03_JPRB,0.26858E+03_JPRB,0.23433E+03_JPRB,0.22701E+03_JPRB, &
 & 0.24649E+03_JPRB,0.29230E+03_JPRB,0.34058E+03_JPRB,0.38993E+03_JPRB /)  
KA(:, 2,12,15) = (/ &
 & 0.35965E+03_JPRB,0.31492E+03_JPRB,0.27026E+03_JPRB,0.23392E+03_JPRB,0.22536E+03_JPRB, &
 & 0.24218E+03_JPRB,0.28684E+03_JPRB,0.33421E+03_JPRB,0.38264E+03_JPRB /)  
KA(:, 3,12,15) = (/ &
 & 0.36096E+03_JPRB,0.31606E+03_JPRB,0.27127E+03_JPRB,0.23331E+03_JPRB,0.22367E+03_JPRB, &
 & 0.23821E+03_JPRB,0.28173E+03_JPRB,0.32828E+03_JPRB,0.37584E+03_JPRB /)  
KA(:, 4,12,15) = (/ &
 & 0.36159E+03_JPRB,0.31657E+03_JPRB,0.27171E+03_JPRB,0.23251E+03_JPRB,0.22182E+03_JPRB, &
 & 0.23456E+03_JPRB,0.27669E+03_JPRB,0.32238E+03_JPRB,0.36910E+03_JPRB /)  
KA(:, 5,12,15) = (/ &
 & 0.36141E+03_JPRB,0.31636E+03_JPRB,0.27153E+03_JPRB,0.23134E+03_JPRB,0.21976E+03_JPRB, &
 & 0.23095E+03_JPRB,0.27160E+03_JPRB,0.31644E+03_JPRB,0.36227E+03_JPRB /)  
KA(:, 1,13,15) = (/ &
 & 0.40931E+03_JPRB,0.35842E+03_JPRB,0.30758E+03_JPRB,0.27041E+03_JPRB,0.26133E+03_JPRB, &
 & 0.27679E+03_JPRB,0.32393E+03_JPRB,0.37751E+03_JPRB,0.43213E+03_JPRB /)  
KA(:, 2,13,15) = (/ &
 & 0.41124E+03_JPRB,0.36013E+03_JPRB,0.30908E+03_JPRB,0.26935E+03_JPRB,0.25923E+03_JPRB, &
 & 0.27218E+03_JPRB,0.31806E+03_JPRB,0.37065E+03_JPRB,0.42432E+03_JPRB /)  
KA(:, 3,13,15) = (/ &
 & 0.41214E+03_JPRB,0.36093E+03_JPRB,0.30979E+03_JPRB,0.26811E+03_JPRB,0.25684E+03_JPRB, &
 & 0.26794E+03_JPRB,0.31214E+03_JPRB,0.36375E+03_JPRB,0.41639E+03_JPRB /)  
KA(:, 4,13,15) = (/ &
 & 0.41225E+03_JPRB,0.36102E+03_JPRB,0.30989E+03_JPRB,0.26655E+03_JPRB,0.25418E+03_JPRB, &
 & 0.26378E+03_JPRB,0.30615E+03_JPRB,0.35676E+03_JPRB,0.40836E+03_JPRB /)  
KA(:, 5,13,15) = (/ &
 & 0.41130E+03_JPRB,0.36017E+03_JPRB,0.30917E+03_JPRB,0.26471E+03_JPRB,0.25127E+03_JPRB, &
 & 0.25962E+03_JPRB,0.30054E+03_JPRB,0.35018E+03_JPRB,0.40087E+03_JPRB /)  
KA(:, 1, 1,16) = (/ &
 & 0.66783E+02_JPRB,0.58494E+02_JPRB,0.50207E+02_JPRB,0.41922E+02_JPRB,0.39207E+02_JPRB, &
 & 0.48837E+02_JPRB,0.58441E+02_JPRB,0.67973E+02_JPRB,0.73684E+02_JPRB /)  
KA(:, 2, 1,16) = (/ &
 & 0.66987E+02_JPRB,0.58663E+02_JPRB,0.50340E+02_JPRB,0.42083E+02_JPRB,0.39992E+02_JPRB, &
 & 0.49756E+02_JPRB,0.59507E+02_JPRB,0.69167E+02_JPRB,0.75232E+02_JPRB /)  
KA(:, 3, 1,16) = (/ &
 & 0.67128E+02_JPRB,0.58776E+02_JPRB,0.50426E+02_JPRB,0.42412E+02_JPRB,0.40738E+02_JPRB, &
 & 0.50635E+02_JPRB,0.60514E+02_JPRB,0.70320E+02_JPRB,0.76487E+02_JPRB /)  
KA(:, 4, 1,16) = (/ &
 & 0.67159E+02_JPRB,0.58797E+02_JPRB,0.50435E+02_JPRB,0.42709E+02_JPRB,0.41336E+02_JPRB, &
 & 0.51345E+02_JPRB,0.61329E+02_JPRB,0.71239E+02_JPRB,0.77474E+02_JPRB /)  
KA(:, 5, 1,16) = (/ &
 & 0.67048E+02_JPRB,0.58698E+02_JPRB,0.50349E+02_JPRB,0.42916E+02_JPRB,0.41806E+02_JPRB, &
 & 0.51893E+02_JPRB,0.61955E+02_JPRB,0.71939E+02_JPRB,0.78212E+02_JPRB /)  
KA(:, 1, 2,16) = (/ &
 & 0.80817E+02_JPRB,0.70771E+02_JPRB,0.60724E+02_JPRB,0.50680E+02_JPRB,0.46121E+02_JPRB, &
 & 0.57561E+02_JPRB,0.68978E+02_JPRB,0.80276E+02_JPRB,0.88125E+02_JPRB /)  
KA(:, 2, 2,16) = (/ &
 & 0.81120E+02_JPRB,0.71031E+02_JPRB,0.60942E+02_JPRB,0.50856E+02_JPRB,0.46531E+02_JPRB, &
 & 0.58009E+02_JPRB,0.69466E+02_JPRB,0.80811E+02_JPRB,0.88902E+02_JPRB /)  
KA(:, 3, 2,16) = (/ &
 & 0.81295E+02_JPRB,0.71179E+02_JPRB,0.61065E+02_JPRB,0.50952E+02_JPRB,0.47046E+02_JPRB, &
 & 0.58603E+02_JPRB,0.70144E+02_JPRB,0.81568E+02_JPRB,0.89842E+02_JPRB /)  
KA(:, 4, 2,16) = (/ &
 & 0.81302E+02_JPRB,0.71181E+02_JPRB,0.61061E+02_JPRB,0.50998E+02_JPRB,0.47535E+02_JPRB, &
 & 0.59172E+02_JPRB,0.70788E+02_JPRB,0.82285E+02_JPRB,0.90723E+02_JPRB /)  
KA(:, 5, 2,16) = (/ &
 & 0.81254E+02_JPRB,0.71123E+02_JPRB,0.60992E+02_JPRB,0.51150E+02_JPRB,0.47959E+02_JPRB, &
 & 0.59657E+02_JPRB,0.71327E+02_JPRB,0.82908E+02_JPRB,0.91460E+02_JPRB /)  
KA(:, 1, 3,16) = (/ &
 & 0.97635E+02_JPRB,0.85483E+02_JPRB,0.73330E+02_JPRB,0.61179E+02_JPRB,0.56207E+02_JPRB, &
 & 0.70215E+02_JPRB,0.84188E+02_JPRB,0.98014E+02_JPRB,0.10988E+03_JPRB /)  
KA(:, 2, 3,16) = (/ &
 & 0.98163E+02_JPRB,0.85943E+02_JPRB,0.73724E+02_JPRB,0.61504E+02_JPRB,0.55633E+02_JPRB, &
 & 0.69472E+02_JPRB,0.83276E+02_JPRB,0.96935E+02_JPRB,0.10869E+03_JPRB /)  
KA(:, 3, 3,16) = (/ &
 & 0.98472E+02_JPRB,0.86211E+02_JPRB,0.73951E+02_JPRB,0.61693E+02_JPRB,0.55697E+02_JPRB, &
 & 0.69495E+02_JPRB,0.83260E+02_JPRB,0.96885E+02_JPRB,0.10871E+03_JPRB /)  
KA(:, 4, 3,16) = (/ &
 & 0.98535E+02_JPRB,0.86265E+02_JPRB,0.73995E+02_JPRB,0.61728E+02_JPRB,0.55937E+02_JPRB, &
 & 0.69749E+02_JPRB,0.83530E+02_JPRB,0.97171E+02_JPRB,0.10906E+03_JPRB /)  
KA(:, 5, 3,16) = (/ &
 & 0.98433E+02_JPRB,0.86165E+02_JPRB,0.73899E+02_JPRB,0.61635E+02_JPRB,0.56204E+02_JPRB, &
 & 0.70040E+02_JPRB,0.83840E+02_JPRB,0.97500E+02_JPRB,0.10946E+03_JPRB /)  
KA(:, 1, 4,16) = (/ &
 & 0.11801E+03_JPRB,0.10331E+03_JPRB,0.88600E+02_JPRB,0.73894E+02_JPRB,0.68841E+02_JPRB, &
 & 0.86008E+02_JPRB,0.10313E+03_JPRB,0.12007E+03_JPRB,0.13623E+03_JPRB /)  
KA(:, 2, 4,16) = (/ &
 & 0.11855E+03_JPRB,0.10378E+03_JPRB,0.89007E+02_JPRB,0.74235E+02_JPRB,0.68009E+02_JPRB, &
 & 0.84957E+02_JPRB,0.10186E+03_JPRB,0.11859E+03_JPRB,0.13456E+03_JPRB /)  
KA(:, 3, 4,16) = (/ &
 & 0.11911E+03_JPRB,0.10427E+03_JPRB,0.89430E+02_JPRB,0.74590E+02_JPRB,0.67220E+02_JPRB, &
 & 0.83955E+02_JPRB,0.10065E+03_JPRB,0.11716E+03_JPRB,0.13292E+03_JPRB /)  
KA(:, 4, 4,16) = (/ &
 & 0.11932E+03_JPRB,0.10446E+03_JPRB,0.89591E+02_JPRB,0.74725E+02_JPRB,0.66996E+02_JPRB, &
 & 0.83620E+02_JPRB,0.10020E+03_JPRB,0.11661E+03_JPRB,0.13231E+03_JPRB /)  
KA(:, 5, 4,16) = (/ &
 & 0.11933E+03_JPRB,0.10445E+03_JPRB,0.89579E+02_JPRB,0.74708E+02_JPRB,0.67016E+02_JPRB, &
 & 0.83607E+02_JPRB,0.10016E+03_JPRB,0.11655E+03_JPRB,0.13223E+03_JPRB /)  
KA(:, 1, 5,16) = (/ &
 & 0.14253E+03_JPRB,0.12475E+03_JPRB,0.10698E+03_JPRB,0.89200E+02_JPRB,0.84755E+02_JPRB, &
 & 0.10590E+03_JPRB,0.12699E+03_JPRB,0.14785E+03_JPRB,0.16865E+03_JPRB /)  
KA(:, 2, 5,16) = (/ &
 & 0.14325E+03_JPRB,0.12539E+03_JPRB,0.10752E+03_JPRB,0.89655E+02_JPRB,0.83145E+02_JPRB, &
 & 0.10388E+03_JPRB,0.12456E+03_JPRB,0.14501E+03_JPRB,0.16542E+03_JPRB /)  
KA(:, 3, 5,16) = (/ &
 & 0.14383E+03_JPRB,0.12589E+03_JPRB,0.10795E+03_JPRB,0.90019E+02_JPRB,0.82092E+02_JPRB, &
 & 0.10255E+03_JPRB,0.12296E+03_JPRB,0.14315E+03_JPRB,0.16327E+03_JPRB /)  
KA(:, 4, 5,16) = (/ &
 & 0.14418E+03_JPRB,0.12620E+03_JPRB,0.10822E+03_JPRB,0.90248E+02_JPRB,0.81037E+02_JPRB, &
 & 0.10121E+03_JPRB,0.12133E+03_JPRB,0.14124E+03_JPRB,0.16108E+03_JPRB /)  
KA(:, 5, 5,16) = (/ &
 & 0.14437E+03_JPRB,0.12637E+03_JPRB,0.10836E+03_JPRB,0.90358E+02_JPRB,0.80556E+02_JPRB, &
 & 0.10057E+03_JPRB,0.12052E+03_JPRB,0.14027E+03_JPRB,0.15994E+03_JPRB /)  
KA(:, 1, 6,16) = (/ &
 & 0.17174E+03_JPRB,0.15031E+03_JPRB,0.12887E+03_JPRB,0.10744E+03_JPRB,0.10459E+03_JPRB, &
 & 0.13069E+03_JPRB,0.15672E+03_JPRB,0.18250E+03_JPRB,0.20866E+03_JPRB /)  
KA(:, 2, 6,16) = (/ &
 & 0.17281E+03_JPRB,0.15124E+03_JPRB,0.12968E+03_JPRB,0.10811E+03_JPRB,0.10205E+03_JPRB, &
 & 0.12751E+03_JPRB,0.15290E+03_JPRB,0.17802E+03_JPRB,0.20356E+03_JPRB /)  
KA(:, 3, 6,16) = (/ &
 & 0.17366E+03_JPRB,0.15199E+03_JPRB,0.13032E+03_JPRB,0.10865E+03_JPRB,0.10020E+03_JPRB, &
 & 0.12519E+03_JPRB,0.15010E+03_JPRB,0.17475E+03_JPRB,0.19982E+03_JPRB /)  
KA(:, 4, 6,16) = (/ &
 & 0.17410E+03_JPRB,0.15237E+03_JPRB,0.13065E+03_JPRB,0.10893E+03_JPRB,0.98757E+02_JPRB, &
 & 0.12337E+03_JPRB,0.14792E+03_JPRB,0.17221E+03_JPRB,0.19689E+03_JPRB /)  
KA(:, 5, 6,16) = (/ &
 & 0.17426E+03_JPRB,0.15251E+03_JPRB,0.13077E+03_JPRB,0.10903E+03_JPRB,0.97456E+02_JPRB, &
 & 0.12171E+03_JPRB,0.14591E+03_JPRB,0.16984E+03_JPRB,0.19419E+03_JPRB /)  
KA(:, 1, 7,16) = (/ &
 & 0.20639E+03_JPRB,0.18062E+03_JPRB,0.15485E+03_JPRB,0.12907E+03_JPRB,0.12889E+03_JPRB, &
 & 0.16105E+03_JPRB,0.19314E+03_JPRB,0.22488E+03_JPRB,0.25751E+03_JPRB /)  
KA(:, 2, 7,16) = (/ &
 & 0.20793E+03_JPRB,0.18197E+03_JPRB,0.15600E+03_JPRB,0.13004E+03_JPRB,0.12536E+03_JPRB, &
 & 0.15664E+03_JPRB,0.18784E+03_JPRB,0.21870E+03_JPRB,0.25043E+03_JPRB /)  
KA(:, 3, 7,16) = (/ &
 & 0.20918E+03_JPRB,0.18307E+03_JPRB,0.15695E+03_JPRB,0.13084E+03_JPRB,0.12258E+03_JPRB, &
 & 0.15317E+03_JPRB,0.18368E+03_JPRB,0.21386E+03_JPRB,0.24487E+03_JPRB /)  
KA(:, 4, 7,16) = (/ &
 & 0.20994E+03_JPRB,0.18373E+03_JPRB,0.15753E+03_JPRB,0.13132E+03_JPRB,0.12024E+03_JPRB, &
 & 0.15023E+03_JPRB,0.18014E+03_JPRB,0.20974E+03_JPRB,0.24016E+03_JPRB /)  
KA(:, 5, 7,16) = (/ &
 & 0.21017E+03_JPRB,0.18393E+03_JPRB,0.15770E+03_JPRB,0.13147E+03_JPRB,0.11817E+03_JPRB, &
 & 0.14763E+03_JPRB,0.17700E+03_JPRB,0.20610E+03_JPRB,0.23592E+03_JPRB /)  
KA(:, 1, 8,16) = (/ &
 & 0.24808E+03_JPRB,0.21709E+03_JPRB,0.18610E+03_JPRB,0.15511E+03_JPRB,0.15824E+03_JPRB, &
 & 0.19773E+03_JPRB,0.23715E+03_JPRB,0.27617E+03_JPRB,0.31647E+03_JPRB /)  
KA(:, 2, 8,16) = (/ &
 & 0.24976E+03_JPRB,0.21856E+03_JPRB,0.18737E+03_JPRB,0.15617E+03_JPRB,0.15364E+03_JPRB, &
 & 0.19198E+03_JPRB,0.23024E+03_JPRB,0.26808E+03_JPRB,0.30723E+03_JPRB /)  
KA(:, 3, 8,16) = (/ &
 & 0.25153E+03_JPRB,0.22011E+03_JPRB,0.18870E+03_JPRB,0.15729E+03_JPRB,0.14986E+03_JPRB, &
 & 0.18726E+03_JPRB,0.22456E+03_JPRB,0.26146E+03_JPRB,0.29964E+03_JPRB /)  
KA(:, 4, 8,16) = (/ &
 & 0.25266E+03_JPRB,0.22111E+03_JPRB,0.18956E+03_JPRB,0.15801E+03_JPRB,0.14651E+03_JPRB, &
 & 0.18308E+03_JPRB,0.21955E+03_JPRB,0.25564E+03_JPRB,0.29297E+03_JPRB /)  
KA(:, 5, 8,16) = (/ &
 & 0.25306E+03_JPRB,0.22146E+03_JPRB,0.18986E+03_JPRB,0.15826E+03_JPRB,0.14346E+03_JPRB, &
 & 0.17924E+03_JPRB,0.21492E+03_JPRB,0.25024E+03_JPRB,0.28677E+03_JPRB /)  
KA(:, 1, 9,16) = (/ &
 & 0.29758E+03_JPRB,0.26040E+03_JPRB,0.22322E+03_JPRB,0.18603E+03_JPRB,0.19348E+03_JPRB, &
 & 0.24177E+03_JPRB,0.28996E+03_JPRB,0.33765E+03_JPRB,0.38707E+03_JPRB /)  
KA(:, 2, 9,16) = (/ &
 & 0.29980E+03_JPRB,0.26234E+03_JPRB,0.22489E+03_JPRB,0.18744E+03_JPRB,0.18763E+03_JPRB, &
 & 0.23446E+03_JPRB,0.28116E+03_JPRB,0.32742E+03_JPRB,0.37536E+03_JPRB /)  
KA(:, 3, 9,16) = (/ &
 & 0.30182E+03_JPRB,0.26412E+03_JPRB,0.22641E+03_JPRB,0.18871E+03_JPRB,0.18264E+03_JPRB, &
 & 0.22823E+03_JPRB,0.27370E+03_JPRB,0.31874E+03_JPRB,0.36539E+03_JPRB /)  
KA(:, 4, 9,16) = (/ &
 & 0.30335E+03_JPRB,0.26546E+03_JPRB,0.22757E+03_JPRB,0.18968E+03_JPRB,0.17814E+03_JPRB, &
 & 0.22260E+03_JPRB,0.26695E+03_JPRB,0.31086E+03_JPRB,0.35637E+03_JPRB /)  
KA(:, 5, 9,16) = (/ &
 & 0.30399E+03_JPRB,0.26602E+03_JPRB,0.22805E+03_JPRB,0.19008E+03_JPRB,0.17393E+03_JPRB, &
 & 0.21734E+03_JPRB,0.26062E+03_JPRB,0.30347E+03_JPRB,0.34789E+03_JPRB /)  
KA(:, 1,10,16) = (/ &
 & 0.35657E+03_JPRB,0.31201E+03_JPRB,0.26745E+03_JPRB,0.22289E+03_JPRB,0.23471E+03_JPRB, &
 & 0.29329E+03_JPRB,0.35175E+03_JPRB,0.40960E+03_JPRB,0.46960E+03_JPRB /)  
KA(:, 2,10,16) = (/ &
 & 0.35941E+03_JPRB,0.31450E+03_JPRB,0.26959E+03_JPRB,0.22468E+03_JPRB,0.22747E+03_JPRB, &
 & 0.28425E+03_JPRB,0.34089E+03_JPRB,0.39700E+03_JPRB,0.45514E+03_JPRB /)  
KA(:, 3,10,16) = (/ &
 & 0.36173E+03_JPRB,0.31654E+03_JPRB,0.27134E+03_JPRB,0.22614E+03_JPRB,0.22110E+03_JPRB, &
 & 0.27628E+03_JPRB,0.33132E+03_JPRB,0.38584E+03_JPRB,0.44234E+03_JPRB /)  
KA(:, 4,10,16) = (/ &
 & 0.36337E+03_JPRB,0.31797E+03_JPRB,0.27257E+03_JPRB,0.22717E+03_JPRB,0.21518E+03_JPRB, &
 & 0.26889E+03_JPRB,0.32246E+03_JPRB,0.37553E+03_JPRB,0.43052E+03_JPRB /)  
KA(:, 5,10,16) = (/ &
 & 0.36404E+03_JPRB,0.31855E+03_JPRB,0.27307E+03_JPRB,0.22759E+03_JPRB,0.20959E+03_JPRB, &
 & 0.26189E+03_JPRB,0.31406E+03_JPRB,0.36572E+03_JPRB,0.41925E+03_JPRB /)  
KA(:, 1,11,16) = (/ &
 & 0.42778E+03_JPRB,0.37432E+03_JPRB,0.32086E+03_JPRB,0.26740E+03_JPRB,0.27872E+03_JPRB, &
 & 0.34830E+03_JPRB,0.41771E+03_JPRB,0.48646E+03_JPRB,0.55765E+03_JPRB /)  
KA(:, 2,11,16) = (/ &
 & 0.43110E+03_JPRB,0.37723E+03_JPRB,0.32336E+03_JPRB,0.26948E+03_JPRB,0.27023E+03_JPRB, &
 & 0.33769E+03_JPRB,0.40499E+03_JPRB,0.47168E+03_JPRB,0.54065E+03_JPRB /)  
KA(:, 3,11,16) = (/ &
 & 0.43351E+03_JPRB,0.37933E+03_JPRB,0.32516E+03_JPRB,0.27099E+03_JPRB,0.26235E+03_JPRB, &
 & 0.32784E+03_JPRB,0.39315E+03_JPRB,0.45790E+03_JPRB,0.52488E+03_JPRB /)  
KA(:, 4,11,16) = (/ &
 & 0.43444E+03_JPRB,0.38015E+03_JPRB,0.32587E+03_JPRB,0.27158E+03_JPRB,0.25502E+03_JPRB, &
 & 0.31866E+03_JPRB,0.38217E+03_JPRB,0.44507E+03_JPRB,0.51019E+03_JPRB /)  
KA(:, 5,11,16) = (/ &
 & 0.43455E+03_JPRB,0.38025E+03_JPRB,0.32595E+03_JPRB,0.27165E+03_JPRB,0.24835E+03_JPRB, &
 & 0.31008E+03_JPRB,0.37185E+03_JPRB,0.43305E+03_JPRB,0.49635E+03_JPRB /)  
KA(:, 1,12,16) = (/ &
 & 0.51115E+03_JPRB,0.44727E+03_JPRB,0.38338E+03_JPRB,0.31950E+03_JPRB,0.32868E+03_JPRB, &
 & 0.41075E+03_JPRB,0.49264E+03_JPRB,0.57375E+03_JPRB,0.65765E+03_JPRB /)  
KA(:, 2,12,16) = (/ &
 & 0.51481E+03_JPRB,0.45047E+03_JPRB,0.38614E+03_JPRB,0.32180E+03_JPRB,0.31846E+03_JPRB, &
 & 0.39795E+03_JPRB,0.47726E+03_JPRB,0.55589E+03_JPRB,0.63715E+03_JPRB /)  
KA(:, 3,12,16) = (/ &
 & 0.51667E+03_JPRB,0.45210E+03_JPRB,0.38753E+03_JPRB,0.32296E+03_JPRB,0.30906E+03_JPRB, &
 & 0.38614E+03_JPRB,0.46310E+03_JPRB,0.53942E+03_JPRB,0.61825E+03_JPRB /)  
KA(:, 4,12,16) = (/ &
 & 0.51678E+03_JPRB,0.45219E+03_JPRB,0.38761E+03_JPRB,0.32303E+03_JPRB,0.30046E+03_JPRB, &
 & 0.37494E+03_JPRB,0.44968E+03_JPRB,0.52372E+03_JPRB,0.60018E+03_JPRB /)  
KA(:, 5,12,16) = (/ &
 & 0.51600E+03_JPRB,0.45151E+03_JPRB,0.38702E+03_JPRB,0.32254E+03_JPRB,0.29255E+03_JPRB, &
 & 0.36403E+03_JPRB,0.43655E+03_JPRB,0.50852E+03_JPRB,0.58277E+03_JPRB /)  
KA(:, 1,13,16) = (/ &
 & 0.60779E+03_JPRB,0.53183E+03_JPRB,0.45587E+03_JPRB,0.37990E+03_JPRB,0.38498E+03_JPRB, &
 & 0.48109E+03_JPRB,0.57702E+03_JPRB,0.67207E+03_JPRB,0.77032E+03_JPRB /)  
KA(:, 2,13,16) = (/ &
 & 0.61089E+03_JPRB,0.53454E+03_JPRB,0.45819E+03_JPRB,0.38184E+03_JPRB,0.37288E+03_JPRB, &
 & 0.46566E+03_JPRB,0.55850E+03_JPRB,0.65053E+03_JPRB,0.74557E+03_JPRB /)  
KA(:, 3,13,16) = (/ &
 & 0.61168E+03_JPRB,0.53523E+03_JPRB,0.45878E+03_JPRB,0.38233E+03_JPRB,0.36190E+03_JPRB, &
 & 0.45112E+03_JPRB,0.54103E+03_JPRB,0.63023E+03_JPRB,0.72223E+03_JPRB /)  
KA(:, 4,13,16) = (/ &
 & 0.61073E+03_JPRB,0.53440E+03_JPRB,0.45807E+03_JPRB,0.38174E+03_JPRB,0.35168E+03_JPRB, &
 & 0.43693E+03_JPRB,0.52405E+03_JPRB,0.61044E+03_JPRB,0.69951E+03_JPRB /)  
KA(:, 5,13,16) = (/ &
 & 0.60852E+03_JPRB,0.53247E+03_JPRB,0.45641E+03_JPRB,0.38036E+03_JPRB,0.34198E+03_JPRB, &
 & 0.42302E+03_JPRB,0.50734E+03_JPRB,0.59097E+03_JPRB,0.67714E+03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART11',1,ZHOOK_HANDLE)
END SUBROUTINE PART11


SUBROUTINE PART12

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART12',0,ZHOOK_HANDLE)


!     -----------------------------------------------------------------
!     The array KB contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KB(:, 1,13, 1) = (/ &
 & 0.10554E-06_JPRB,0.38596E-04_JPRB,0.65402E-04_JPRB,0.88540E-04_JPRB,0.19601E-03_JPRB /)  
KB(:, 2,13, 1) = (/ &
 & 0.10479E-06_JPRB,0.43672E-04_JPRB,0.74889E-04_JPRB,0.10118E-03_JPRB,0.22146E-03_JPRB /)  
KB(:, 3,13, 1) = (/ &
 & 0.10429E-06_JPRB,0.49418E-04_JPRB,0.85429E-04_JPRB,0.11557E-03_JPRB,0.24448E-03_JPRB /)  
KB(:, 4,13, 1) = (/ &
 & 0.10232E-06_JPRB,0.55802E-04_JPRB,0.96459E-04_JPRB,0.13167E-03_JPRB,0.27001E-03_JPRB /)  
KB(:, 5,13, 1) = (/ &
 & 0.99013E-07_JPRB,0.62996E-04_JPRB,0.10900E-03_JPRB,0.14834E-03_JPRB,0.29917E-03_JPRB /)  
KB(:, 1,14, 1) = (/ &
 & 0.85136E-07_JPRB,0.31943E-04_JPRB,0.54402E-04_JPRB,0.73887E-04_JPRB,0.15895E-03_JPRB /)  
KB(:, 2,14, 1) = (/ &
 & 0.84597E-07_JPRB,0.36196E-04_JPRB,0.62429E-04_JPRB,0.84479E-04_JPRB,0.17749E-03_JPRB /)  
KB(:, 3,14, 1) = (/ &
 & 0.83629E-07_JPRB,0.40982E-04_JPRB,0.71126E-04_JPRB,0.96573E-04_JPRB,0.19740E-03_JPRB /)  
KB(:, 4,14, 1) = (/ &
 & 0.82310E-07_JPRB,0.46344E-04_JPRB,0.80458E-04_JPRB,0.10984E-03_JPRB,0.21847E-03_JPRB /)  
KB(:, 5,14, 1) = (/ &
 & 0.78709E-07_JPRB,0.52252E-04_JPRB,0.90989E-04_JPRB,0.12394E-03_JPRB,0.24281E-03_JPRB /)  
KB(:, 1,15, 1) = (/ &
 & 0.68497E-07_JPRB,0.26393E-04_JPRB,0.45164E-04_JPRB,0.61570E-04_JPRB,0.12493E-03_JPRB /)  
KB(:, 2,15, 1) = (/ &
 & 0.68062E-07_JPRB,0.29936E-04_JPRB,0.51919E-04_JPRB,0.70387E-04_JPRB,0.13953E-03_JPRB /)  
KB(:, 3,15, 1) = (/ &
 & 0.66766E-07_JPRB,0.33863E-04_JPRB,0.59056E-04_JPRB,0.80693E-04_JPRB,0.15653E-03_JPRB /)  
KB(:, 4,15, 1) = (/ &
 & 0.65636E-07_JPRB,0.38294E-04_JPRB,0.66885E-04_JPRB,0.91555E-04_JPRB,0.17510E-03_JPRB /)  
KB(:, 5,15, 1) = (/ &
 & 0.62711E-07_JPRB,0.43189E-04_JPRB,0.75756E-04_JPRB,0.10355E-03_JPRB,0.19439E-03_JPRB /)  
KB(:, 1,16, 1) = (/ &
 & 0.55083E-07_JPRB,0.21761E-04_JPRB,0.37484E-04_JPRB,0.51301E-04_JPRB,0.97875E-04_JPRB /)  
KB(:, 2,16, 1) = (/ &
 & 0.54095E-07_JPRB,0.24670E-04_JPRB,0.43084E-04_JPRB,0.58639E-04_JPRB,0.10996E-03_JPRB /)  
KB(:, 3,16, 1) = (/ &
 & 0.53340E-07_JPRB,0.27925E-04_JPRB,0.48976E-04_JPRB,0.67234E-04_JPRB,0.12415E-03_JPRB /)  
KB(:, 4,16, 1) = (/ &
 & 0.51412E-07_JPRB,0.31588E-04_JPRB,0.55576E-04_JPRB,0.76352E-04_JPRB,0.13939E-03_JPRB /)  
KB(:, 5,16, 1) = (/ &
 & 0.49341E-07_JPRB,0.35677E-04_JPRB,0.62937E-04_JPRB,0.86363E-04_JPRB,0.15543E-03_JPRB /)  
KB(:, 1,17, 1) = (/ &
 & 0.44022E-07_JPRB,0.17963E-04_JPRB,0.31102E-04_JPRB,0.42604E-04_JPRB,0.78290E-04_JPRB /)  
KB(:, 2,17, 1) = (/ &
 & 0.43167E-07_JPRB,0.20382E-04_JPRB,0.35754E-04_JPRB,0.48875E-04_JPRB,0.87941E-04_JPRB /)  
KB(:, 3,17, 1) = (/ &
 & 0.42210E-07_JPRB,0.23091E-04_JPRB,0.40674E-04_JPRB,0.56059E-04_JPRB,0.99257E-04_JPRB /)  
KB(:, 4,17, 1) = (/ &
 & 0.40402E-07_JPRB,0.26125E-04_JPRB,0.46162E-04_JPRB,0.63586E-04_JPRB,0.11166E-03_JPRB /)  
KB(:, 5,17, 1) = (/ &
 & 0.38532E-07_JPRB,0.29494E-04_JPRB,0.52327E-04_JPRB,0.71960E-04_JPRB,0.12480E-03_JPRB /)  
KB(:, 1,18, 1) = (/ &
 & 0.34937E-07_JPRB,0.14903E-04_JPRB,0.25868E-04_JPRB,0.35503E-04_JPRB,0.63368E-04_JPRB /)  
KB(:, 2,18, 1) = (/ &
 & 0.34308E-07_JPRB,0.16923E-04_JPRB,0.29781E-04_JPRB,0.40789E-04_JPRB,0.71115E-04_JPRB /)  
KB(:, 3,18, 1) = (/ &
 & 0.32995E-07_JPRB,0.19171E-04_JPRB,0.33872E-04_JPRB,0.46810E-04_JPRB,0.80302E-04_JPRB /)  
KB(:, 4,18, 1) = (/ &
 & 0.31654E-07_JPRB,0.21679E-04_JPRB,0.38468E-04_JPRB,0.53048E-04_JPRB,0.90431E-04_JPRB /)  
KB(:, 5,18, 1) = (/ &
 & 0.30282E-07_JPRB,0.24491E-04_JPRB,0.43596E-04_JPRB,0.60078E-04_JPRB,0.10133E-03_JPRB /)  
KB(:, 1,19, 1) = (/ &
 & 0.27971E-07_JPRB,0.12385E-04_JPRB,0.21549E-04_JPRB,0.29618E-04_JPRB,0.51732E-04_JPRB /)  
KB(:, 2,19, 1) = (/ &
 & 0.27128E-07_JPRB,0.14042E-04_JPRB,0.24826E-04_JPRB,0.34047E-04_JPRB,0.58064E-04_JPRB /)  
KB(:, 3,19, 1) = (/ &
 & 0.26018E-07_JPRB,0.15920E-04_JPRB,0.28221E-04_JPRB,0.39072E-04_JPRB,0.65495E-04_JPRB /)  
KB(:, 4,19, 1) = (/ &
 & 0.24717E-07_JPRB,0.18017E-04_JPRB,0.32056E-04_JPRB,0.44285E-04_JPRB,0.73859E-04_JPRB /)  
KB(:, 5,19, 1) = (/ &
 & 0.23859E-07_JPRB,0.20360E-04_JPRB,0.36341E-04_JPRB,0.50170E-04_JPRB,0.82944E-04_JPRB /)  
KB(:, 1,20, 1) = (/ &
 & 0.22529E-07_JPRB,0.10336E-04_JPRB,0.17999E-04_JPRB,0.24776E-04_JPRB,0.42602E-04_JPRB /)  
KB(:, 2,20, 1) = (/ &
 & 0.21733E-07_JPRB,0.11685E-04_JPRB,0.20769E-04_JPRB,0.28503E-04_JPRB,0.47833E-04_JPRB /)  
KB(:, 3,20, 1) = (/ &
 & 0.20791E-07_JPRB,0.13280E-04_JPRB,0.23571E-04_JPRB,0.32654E-04_JPRB,0.53995E-04_JPRB /)  
KB(:, 4,20, 1) = (/ &
 & 0.19663E-07_JPRB,0.15029E-04_JPRB,0.26788E-04_JPRB,0.37066E-04_JPRB,0.60944E-04_JPRB /)  
KB(:, 5,20, 1) = (/ &
 & 0.19169E-07_JPRB,0.16975E-04_JPRB,0.30353E-04_JPRB,0.41996E-04_JPRB,0.68344E-04_JPRB /)  
KB(:, 1,21, 1) = (/ &
 & 0.18148E-07_JPRB,0.86039E-05_JPRB,0.15041E-04_JPRB,0.20717E-04_JPRB,0.35143E-04_JPRB /)  
KB(:, 2,21, 1) = (/ &
 & 0.17465E-07_JPRB,0.97287E-05_JPRB,0.17348E-04_JPRB,0.23862E-04_JPRB,0.39508E-04_JPRB /)  
KB(:, 3,21, 1) = (/ &
 & 0.16537E-07_JPRB,0.11073E-04_JPRB,0.19687E-04_JPRB,0.27271E-04_JPRB,0.44652E-04_JPRB /)  
KB(:, 4,21, 1) = (/ &
 & 0.15860E-07_JPRB,0.12526E-04_JPRB,0.22388E-04_JPRB,0.31015E-04_JPRB,0.50269E-04_JPRB /)  
KB(:, 5,21, 1) = (/ &
 & 0.15452E-07_JPRB,0.14158E-04_JPRB,0.25339E-04_JPRB,0.35141E-04_JPRB,0.56327E-04_JPRB /)  
KB(:, 1,22, 1) = (/ &
 & 0.14542E-07_JPRB,0.71807E-05_JPRB,0.12682E-04_JPRB,0.17473E-04_JPRB,0.29179E-04_JPRB /)  
KB(:, 2,22, 1) = (/ &
 & 0.13967E-07_JPRB,0.81574E-05_JPRB,0.14550E-04_JPRB,0.20147E-04_JPRB,0.32795E-04_JPRB /)  
KB(:, 3,22, 1) = (/ &
 & 0.13241E-07_JPRB,0.92839E-05_JPRB,0.16547E-04_JPRB,0.22971E-04_JPRB,0.37036E-04_JPRB /)  
KB(:, 4,22, 1) = (/ &
 & 0.12746E-07_JPRB,0.10522E-04_JPRB,0.18840E-04_JPRB,0.26114E-04_JPRB,0.41617E-04_JPRB /)  
KB(:, 5,22, 1) = (/ &
 & 0.12426E-07_JPRB,0.11886E-04_JPRB,0.21313E-04_JPRB,0.29604E-04_JPRB,0.46709E-04_JPRB /)  
KB(:, 1,23, 1) = (/ &
 & 0.11724E-07_JPRB,0.60196E-05_JPRB,0.10703E-04_JPRB,0.14753E-04_JPRB,0.24143E-04_JPRB /)  
KB(:, 2,23, 1) = (/ &
 & 0.11124E-07_JPRB,0.68499E-05_JPRB,0.12233E-04_JPRB,0.17009E-04_JPRB,0.27147E-04_JPRB /)  
KB(:, 3,23, 1) = (/ &
 & 0.10552E-07_JPRB,0.77897E-05_JPRB,0.13927E-04_JPRB,0.19362E-04_JPRB,0.30661E-04_JPRB /)  
KB(:, 4,23, 1) = (/ &
 & 0.10213E-07_JPRB,0.88398E-05_JPRB,0.15850E-04_JPRB,0.22024E-04_JPRB,0.34519E-04_JPRB /)  
KB(:, 5,23, 1) = (/ &
 & 0.99627E-08_JPRB,0.99755E-05_JPRB,0.17919E-04_JPRB,0.24944E-04_JPRB,0.38730E-04_JPRB /)  
KB(:, 1,24, 1) = (/ &
 & 0.93835E-08_JPRB,0.50505E-05_JPRB,0.90298E-05_JPRB,0.12450E-04_JPRB,0.19940E-04_JPRB /)  
KB(:, 2,24, 1) = (/ &
 & 0.88722E-08_JPRB,0.57494E-05_JPRB,0.10287E-04_JPRB,0.14351E-04_JPRB,0.22450E-04_JPRB /)  
KB(:, 3,24, 1) = (/ &
 & 0.84719E-08_JPRB,0.65374E-05_JPRB,0.11727E-04_JPRB,0.16329E-04_JPRB,0.25378E-04_JPRB /)  
KB(:, 4,24, 1) = (/ &
 & 0.81924E-08_JPRB,0.74186E-05_JPRB,0.13334E-04_JPRB,0.18567E-04_JPRB,0.28560E-04_JPRB /)  
KB(:, 5,24, 1) = (/ &
 & 0.79194E-08_JPRB,0.83719E-05_JPRB,0.15056E-04_JPRB,0.21003E-04_JPRB,0.31990E-04_JPRB /)  
KB(:, 1,25, 1) = (/ &
 & 0.74535E-08_JPRB,0.42437E-05_JPRB,0.76220E-05_JPRB,0.10523E-04_JPRB,0.16531E-04_JPRB /)  
KB(:, 2,25, 1) = (/ &
 & 0.70516E-08_JPRB,0.48300E-05_JPRB,0.86667E-05_JPRB,0.12089E-04_JPRB,0.18616E-04_JPRB /)  
KB(:, 3,25, 1) = (/ &
 & 0.67746E-08_JPRB,0.54941E-05_JPRB,0.98927E-05_JPRB,0.13790E-04_JPRB,0.21024E-04_JPRB /)  
KB(:, 4,25, 1) = (/ &
 & 0.65375E-08_JPRB,0.62357E-05_JPRB,0.11233E-04_JPRB,0.15662E-04_JPRB,0.23642E-04_JPRB /)  
KB(:, 5,25, 1) = (/ &
 & 0.63001E-08_JPRB,0.70282E-05_JPRB,0.12669E-04_JPRB,0.17695E-04_JPRB,0.26478E-04_JPRB /)  
KB(:, 1,26, 1) = (/ &
 & 0.59520E-08_JPRB,0.35739E-05_JPRB,0.64350E-05_JPRB,0.89330E-05_JPRB,0.13754E-04_JPRB /)  
KB(:, 2,26, 1) = (/ &
 & 0.56644E-08_JPRB,0.40797E-05_JPRB,0.73291E-05_JPRB,0.10228E-04_JPRB,0.15489E-04_JPRB /)  
KB(:, 3,26, 1) = (/ &
 & 0.54229E-08_JPRB,0.46366E-05_JPRB,0.83664E-05_JPRB,0.11659E-04_JPRB,0.17486E-04_JPRB /)  
KB(:, 4,26, 1) = (/ &
 & 0.52155E-08_JPRB,0.52546E-05_JPRB,0.94829E-05_JPRB,0.13246E-04_JPRB,0.19643E-04_JPRB /)  
KB(:, 5,26, 1) = (/ &
 & 0.50026E-08_JPRB,0.59134E-05_JPRB,0.10676E-04_JPRB,0.14933E-04_JPRB,0.21979E-04_JPRB /)  
KB(:, 1,27, 1) = (/ &
 & 0.47347E-08_JPRB,0.30117E-05_JPRB,0.54223E-05_JPRB,0.75810E-05_JPRB,0.11424E-04_JPRB /)  
KB(:, 2,27, 1) = (/ &
 & 0.45215E-08_JPRB,0.34421E-05_JPRB,0.61959E-05_JPRB,0.86619E-05_JPRB,0.12884E-04_JPRB /)  
KB(:, 3,27, 1) = (/ &
 & 0.43334E-08_JPRB,0.39143E-05_JPRB,0.70702E-05_JPRB,0.98761E-05_JPRB,0.14543E-04_JPRB /)  
KB(:, 4,27, 1) = (/ &
 & 0.41350E-08_JPRB,0.44275E-05_JPRB,0.80005E-05_JPRB,0.11195E-04_JPRB,0.16319E-04_JPRB /)  
KB(:, 5,27, 1) = (/ &
 & 0.39653E-08_JPRB,0.49769E-05_JPRB,0.89931E-05_JPRB,0.12598E-04_JPRB,0.18160E-04_JPRB /)  
KB(:, 1,28, 1) = (/ &
 & 0.37948E-08_JPRB,0.25415E-05_JPRB,0.45819E-05_JPRB,0.64336E-05_JPRB,0.94956E-05_JPRB /)  
KB(:, 2,28, 1) = (/ &
 & 0.36083E-08_JPRB,0.29038E-05_JPRB,0.52426E-05_JPRB,0.73400E-05_JPRB,0.10719E-04_JPRB /)  
KB(:, 3,28, 1) = (/ &
 & 0.34418E-08_JPRB,0.33017E-05_JPRB,0.59733E-05_JPRB,0.83575E-05_JPRB,0.12066E-04_JPRB /)  
KB(:, 4,28, 1) = (/ &
 & 0.32636E-08_JPRB,0.37297E-05_JPRB,0.67493E-05_JPRB,0.94558E-05_JPRB,0.13468E-04_JPRB /)  
KB(:, 5,28, 1) = (/ &
 & 0.31340E-08_JPRB,0.41873E-05_JPRB,0.75759E-05_JPRB,0.10620E-04_JPRB,0.14953E-04_JPRB /)  
KB(:, 1,29, 1) = (/ &
 & 0.30121E-08_JPRB,0.21536E-05_JPRB,0.38841E-05_JPRB,0.54491E-05_JPRB,0.79090E-05_JPRB /)  
KB(:, 2,29, 1) = (/ &
 & 0.28775E-08_JPRB,0.24557E-05_JPRB,0.44467E-05_JPRB,0.62247E-05_JPRB,0.89148E-05_JPRB /)  
KB(:, 3,29, 1) = (/ &
 & 0.27196E-08_JPRB,0.27900E-05_JPRB,0.50543E-05_JPRB,0.70782E-05_JPRB,0.99943E-05_JPRB /)  
KB(:, 4,29, 1) = (/ &
 & 0.25798E-08_JPRB,0.31473E-05_JPRB,0.57011E-05_JPRB,0.79936E-05_JPRB,0.11135E-04_JPRB /)  
KB(:, 5,29, 1) = (/ &
 & 0.24785E-08_JPRB,0.35287E-05_JPRB,0.63894E-05_JPRB,0.89624E-05_JPRB,0.12357E-04_JPRB /)  
KB(:, 1,30, 1) = (/ &
 & 0.24034E-08_JPRB,0.18231E-05_JPRB,0.32945E-05_JPRB,0.46183E-05_JPRB,0.65837E-05_JPRB /)  
KB(:, 2,30, 1) = (/ &
 & 0.22702E-08_JPRB,0.20766E-05_JPRB,0.37671E-05_JPRB,0.52735E-05_JPRB,0.73875E-05_JPRB /)  
KB(:, 3,30, 1) = (/ &
 & 0.21551E-08_JPRB,0.23559E-05_JPRB,0.42744E-05_JPRB,0.59932E-05_JPRB,0.82665E-05_JPRB /)  
KB(:, 4,30, 1) = (/ &
 & 0.20397E-08_JPRB,0.26541E-05_JPRB,0.48137E-05_JPRB,0.67549E-05_JPRB,0.92071E-05_JPRB /)  
KB(:, 5,30, 1) = (/ &
 & 0.19208E-08_JPRB,0.29711E-05_JPRB,0.53880E-05_JPRB,0.75598E-05_JPRB,0.10211E-04_JPRB /)  
KB(:, 1,31, 1) = (/ &
 & 0.19116E-08_JPRB,0.15454E-05_JPRB,0.27957E-05_JPRB,0.39228E-05_JPRB,0.54664E-05_JPRB /)  
KB(:, 2,31, 1) = (/ &
 & 0.18045E-08_JPRB,0.17579E-05_JPRB,0.31938E-05_JPRB,0.44780E-05_JPRB,0.61205E-05_JPRB /)  
KB(:, 3,31, 1) = (/ &
 & 0.17015E-08_JPRB,0.19911E-05_JPRB,0.36167E-05_JPRB,0.50753E-05_JPRB,0.68523E-05_JPRB /)  
KB(:, 4,31, 1) = (/ &
 & 0.16042E-08_JPRB,0.22393E-05_JPRB,0.40666E-05_JPRB,0.57094E-05_JPRB,0.76260E-05_JPRB /)  
KB(:, 5,31, 1) = (/ &
 & 0.15189E-08_JPRB,0.25035E-05_JPRB,0.45439E-05_JPRB,0.63785E-05_JPRB,0.84562E-05_JPRB /)  
KB(:, 1,32, 1) = (/ &
 & 0.15134E-08_JPRB,0.13080E-05_JPRB,0.23763E-05_JPRB,0.33360E-05_JPRB,0.45382E-05_JPRB /)  
KB(:, 2,32, 1) = (/ &
 & 0.14254E-08_JPRB,0.14886E-05_JPRB,0.27086E-05_JPRB,0.37995E-05_JPRB,0.50938E-05_JPRB /)  
KB(:, 3,32, 1) = (/ &
 & 0.13478E-08_JPRB,0.16831E-05_JPRB,0.30605E-05_JPRB,0.42971E-05_JPRB,0.56933E-05_JPRB /)  
KB(:, 4,32, 1) = (/ &
 & 0.12726E-08_JPRB,0.18904E-05_JPRB,0.34353E-05_JPRB,0.48247E-05_JPRB,0.63353E-05_JPRB /)  
KB(:, 5,32, 1) = (/ &
 & 0.12027E-08_JPRB,0.21098E-05_JPRB,0.38318E-05_JPRB,0.53809E-05_JPRB,0.70302E-05_JPRB /)  
KB(:, 1,33, 1) = (/ &
 & 0.12024E-08_JPRB,0.11084E-05_JPRB,0.20193E-05_JPRB,0.28310E-05_JPRB,0.37849E-05_JPRB /)  
KB(:, 2,33, 1) = (/ &
 & 0.11338E-08_JPRB,0.12605E-05_JPRB,0.22949E-05_JPRB,0.32221E-05_JPRB,0.42458E-05_JPRB /)  
KB(:, 3,33, 1) = (/ &
 & 0.10678E-08_JPRB,0.14231E-05_JPRB,0.25881E-05_JPRB,0.36365E-05_JPRB,0.47460E-05_JPRB /)  
KB(:, 4,33, 1) = (/ &
 & 0.10052E-08_JPRB,0.15963E-05_JPRB,0.29010E-05_JPRB,0.40728E-05_JPRB,0.52804E-05_JPRB /)  
KB(:, 5,33, 1) = (/ &
 & 0.95946E-09_JPRB,0.17779E-05_JPRB,0.32301E-05_JPRB,0.45381E-05_JPRB,0.58547E-05_JPRB /)  
KB(:, 1,34, 1) = (/ &
 & 0.95750E-09_JPRB,0.93665E-06_JPRB,0.17068E-05_JPRB,0.23954E-05_JPRB,0.31611E-05_JPRB /)  
KB(:, 2,34, 1) = (/ &
 & 0.89991E-09_JPRB,0.10636E-05_JPRB,0.19366E-05_JPRB,0.27209E-05_JPRB,0.35440E-05_JPRB /)  
KB(:, 3,34, 1) = (/ &
 & 0.84944E-09_JPRB,0.11994E-05_JPRB,0.21804E-05_JPRB,0.30651E-05_JPRB,0.39600E-05_JPRB /)  
KB(:, 4,34, 1) = (/ &
 & 0.80863E-09_JPRB,0.13431E-05_JPRB,0.24406E-05_JPRB,0.34285E-05_JPRB,0.44045E-05_JPRB /)  
KB(:, 5,34, 1) = (/ &
 & 0.76697E-09_JPRB,0.14937E-05_JPRB,0.27138E-05_JPRB,0.38153E-05_JPRB,0.48739E-05_JPRB /)  
KB(:, 1,35, 1) = (/ &
 & 0.76931E-09_JPRB,0.78145E-06_JPRB,0.14243E-05_JPRB,0.20004E-05_JPRB,0.26088E-05_JPRB /)  
KB(:, 2,35, 1) = (/ &
 & 0.72554E-09_JPRB,0.88652E-06_JPRB,0.16140E-05_JPRB,0.22684E-05_JPRB,0.29255E-05_JPRB /)  
KB(:, 3,35, 1) = (/ &
 & 0.68677E-09_JPRB,0.99872E-06_JPRB,0.18159E-05_JPRB,0.25537E-05_JPRB,0.32672E-05_JPRB /)  
KB(:, 4,35, 1) = (/ &
 & 0.64986E-09_JPRB,0.11178E-05_JPRB,0.20312E-05_JPRB,0.28542E-05_JPRB,0.36304E-05_JPRB /)  
KB(:, 5,35, 1) = (/ &
 & 0.62177E-09_JPRB,0.12420E-05_JPRB,0.22566E-05_JPRB,0.31737E-05_JPRB,0.40187E-05_JPRB /)  
KB(:, 1,36, 1) = (/ &
 & 0.62245E-09_JPRB,0.64235E-06_JPRB,0.11709E-05_JPRB,0.16445E-05_JPRB,0.21213E-05_JPRB /)  
KB(:, 2,36, 1) = (/ &
 & 0.58696E-09_JPRB,0.72876E-06_JPRB,0.13266E-05_JPRB,0.18646E-05_JPRB,0.23798E-05_JPRB /)  
KB(:, 3,36, 1) = (/ &
 & 0.55693E-09_JPRB,0.82089E-06_JPRB,0.14927E-05_JPRB,0.20991E-05_JPRB,0.26600E-05_JPRB /)  
KB(:, 4,36, 1) = (/ &
 & 0.52934E-09_JPRB,0.91874E-06_JPRB,0.16695E-05_JPRB,0.23457E-05_JPRB,0.29575E-05_JPRB /)  
KB(:, 5,36, 1) = (/ &
 & 0.50585E-09_JPRB,0.10210E-05_JPRB,0.18549E-05_JPRB,0.26085E-05_JPRB,0.32758E-05_JPRB /)  
KB(:, 1,37, 1) = (/ &
 & 0.51156E-09_JPRB,0.51872E-06_JPRB,0.94550E-06_JPRB,0.13287E-05_JPRB,0.17089E-05_JPRB /)  
KB(:, 2,37, 1) = (/ &
 & 0.48258E-09_JPRB,0.58908E-06_JPRB,0.10722E-05_JPRB,0.15079E-05_JPRB,0.19187E-05_JPRB /)  
KB(:, 3,37, 1) = (/ &
 & 0.45694E-09_JPRB,0.66421E-06_JPRB,0.12078E-05_JPRB,0.16992E-05_JPRB,0.21456E-05_JPRB /)  
KB(:, 4,37, 1) = (/ &
 & 0.43502E-09_JPRB,0.74408E-06_JPRB,0.13520E-05_JPRB,0.19000E-05_JPRB,0.23876E-05_JPRB /)  
KB(:, 5,37, 1) = (/ &
 & 0.41517E-09_JPRB,0.82758E-06_JPRB,0.15034E-05_JPRB,0.21146E-05_JPRB,0.26473E-05_JPRB /)  
KB(:, 1,38, 1) = (/ &
 & 0.42094E-09_JPRB,0.41837E-06_JPRB,0.76260E-06_JPRB,0.10719E-05_JPRB,0.13756E-05_JPRB /)  
KB(:, 2,38, 1) = (/ &
 & 0.39700E-09_JPRB,0.47557E-06_JPRB,0.86572E-06_JPRB,0.12180E-05_JPRB,0.15462E-05_JPRB /)  
KB(:, 3,38, 1) = (/ &
 & 0.37563E-09_JPRB,0.53684E-06_JPRB,0.97613E-06_JPRB,0.13738E-05_JPRB,0.17289E-05_JPRB /)  
KB(:, 4,38, 1) = (/ &
 & 0.35783E-09_JPRB,0.60193E-06_JPRB,0.10936E-05_JPRB,0.15374E-05_JPRB,0.19252E-05_JPRB /)  
KB(:, 5,38, 1) = (/ &
 & 0.34107E-09_JPRB,0.67014E-06_JPRB,0.12173E-05_JPRB,0.17127E-05_JPRB,0.21369E-05_JPRB /)  
KB(:, 1,39, 1) = (/ &
 & 0.34635E-09_JPRB,0.33732E-06_JPRB,0.61492E-06_JPRB,0.86447E-06_JPRB,0.11055E-05_JPRB /)  
KB(:, 2,39, 1) = (/ &
 & 0.32654E-09_JPRB,0.38383E-06_JPRB,0.69869E-06_JPRB,0.98355E-06_JPRB,0.12440E-05_JPRB /)  
KB(:, 3,39, 1) = (/ &
 & 0.30909E-09_JPRB,0.43371E-06_JPRB,0.78869E-06_JPRB,0.11105E-05_JPRB,0.13924E-05_JPRB /)  
KB(:, 4,39, 1) = (/ &
 & 0.29425E-09_JPRB,0.48681E-06_JPRB,0.88446E-06_JPRB,0.12433E-05_JPRB,0.15526E-05_JPRB /)  
KB(:, 5,39, 1) = (/ &
 & 0.28000E-09_JPRB,0.54256E-06_JPRB,0.98550E-06_JPRB,0.13868E-05_JPRB,0.17238E-05_JPRB /)  
KB(:, 1,40, 1) = (/ &
 & 0.28731E-09_JPRB,0.26843E-06_JPRB,0.48915E-06_JPRB,0.68810E-06_JPRB,0.87867E-06_JPRB /)  
KB(:, 2,40, 1) = (/ &
 & 0.27089E-09_JPRB,0.30600E-06_JPRB,0.55698E-06_JPRB,0.78430E-06_JPRB,0.99075E-06_JPRB /)  
KB(:, 3,40, 1) = (/ &
 & 0.25607E-09_JPRB,0.34624E-06_JPRB,0.62966E-06_JPRB,0.88677E-06_JPRB,0.11107E-05_JPRB /)  
KB(:, 4,40, 1) = (/ &
 & 0.24372E-09_JPRB,0.38926E-06_JPRB,0.70732E-06_JPRB,0.99430E-06_JPRB,0.12402E-05_JPRB /)  
KB(:, 5,40, 1) = (/ &
 & 0.23176E-09_JPRB,0.43465E-06_JPRB,0.78943E-06_JPRB,0.11107E-05_JPRB,0.13787E-05_JPRB /)  
KB(:, 1,41, 1) = (/ &
 & 0.23903E-09_JPRB,0.21323E-06_JPRB,0.38855E-06_JPRB,0.54701E-06_JPRB,0.69781E-06_JPRB /)  
KB(:, 2,41, 1) = (/ &
 & 0.22487E-09_JPRB,0.24332E-06_JPRB,0.44328E-06_JPRB,0.62397E-06_JPRB,0.78774E-06_JPRB /)  
KB(:, 3,41, 1) = (/ &
 & 0.21236E-09_JPRB,0.27581E-06_JPRB,0.50170E-06_JPRB,0.70664E-06_JPRB,0.88427E-06_JPRB /)  
KB(:, 4,41, 1) = (/ &
 & 0.20204E-09_JPRB,0.31066E-06_JPRB,0.56435E-06_JPRB,0.79384E-06_JPRB,0.98899E-06_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART12',1,ZHOOK_HANDLE)
END SUBROUTINE PART12


SUBROUTINE PART13

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART13',0,ZHOOK_HANDLE)


KB(:, 5,41, 1) = (/ &
 & 0.19209E-09_JPRB,0.34753E-06_JPRB,0.63119E-06_JPRB,0.88787E-06_JPRB,0.11007E-05_JPRB /)  
KB(:, 1,42, 1) = (/ &
 & 0.19868E-09_JPRB,0.16950E-06_JPRB,0.30885E-06_JPRB,0.43426E-06_JPRB,0.55336E-06_JPRB /)  
KB(:, 2,42, 1) = (/ &
 & 0.18681E-09_JPRB,0.19338E-06_JPRB,0.35250E-06_JPRB,0.49622E-06_JPRB,0.62628E-06_JPRB /)  
KB(:, 3,42, 1) = (/ &
 & 0.17649E-09_JPRB,0.21963E-06_JPRB,0.39950E-06_JPRB,0.56269E-06_JPRB,0.70396E-06_JPRB /)  
KB(:, 4,42, 1) = (/ &
 & 0.16753E-09_JPRB,0.24778E-06_JPRB,0.45013E-06_JPRB,0.63342E-06_JPRB,0.78770E-06_JPRB /)  
KB(:, 5,42, 1) = (/ &
 & 0.15930E-09_JPRB,0.27772E-06_JPRB,0.50439E-06_JPRB,0.70945E-06_JPRB,0.87783E-06_JPRB /)  
KB(:, 1,43, 1) = (/ &
 & 0.16577E-09_JPRB,0.13332E-06_JPRB,0.24323E-06_JPRB,0.34184E-06_JPRB,0.43594E-06_JPRB /)  
KB(:, 2,43, 1) = (/ &
 & 0.15597E-09_JPRB,0.15245E-06_JPRB,0.27801E-06_JPRB,0.39130E-06_JPRB,0.49460E-06_JPRB /)  
KB(:, 3,43, 1) = (/ &
 & 0.14721E-09_JPRB,0.17354E-06_JPRB,0.31584E-06_JPRB,0.44499E-06_JPRB,0.55705E-06_JPRB /)  
KB(:, 4,43, 1) = (/ &
 & 0.13936E-09_JPRB,0.19625E-06_JPRB,0.35661E-06_JPRB,0.50189E-06_JPRB,0.62398E-06_JPRB /)  
KB(:, 5,43, 1) = (/ &
 & 0.13255E-09_JPRB,0.22044E-06_JPRB,0.40034E-06_JPRB,0.56308E-06_JPRB,0.69634E-06_JPRB /)  
KB(:, 1,44, 1) = (/ &
 & 0.13861E-09_JPRB,0.10445E-06_JPRB,0.19058E-06_JPRB,0.26841E-06_JPRB,0.34233E-06_JPRB /)  
KB(:, 2,44, 1) = (/ &
 & 0.13027E-09_JPRB,0.11974E-06_JPRB,0.21836E-06_JPRB,0.30744E-06_JPRB,0.38897E-06_JPRB /)  
KB(:, 3,44, 1) = (/ &
 & 0.12290E-09_JPRB,0.13662E-06_JPRB,0.24864E-06_JPRB,0.35065E-06_JPRB,0.43916E-06_JPRB /)  
KB(:, 4,44, 1) = (/ &
 & 0.11611E-09_JPRB,0.15484E-06_JPRB,0.28155E-06_JPRB,0.39627E-06_JPRB,0.49273E-06_JPRB /)  
KB(:, 5,44, 1) = (/ &
 & 0.11042E-09_JPRB,0.17431E-06_JPRB,0.31666E-06_JPRB,0.44540E-06_JPRB,0.55087E-06_JPRB /)  
KB(:, 1,45, 1) = (/ &
 & 0.11581E-09_JPRB,0.81915E-07_JPRB,0.14915E-06_JPRB,0.21140E-06_JPRB,0.26987E-06_JPRB /)  
KB(:, 2,45, 1) = (/ &
 & 0.10906E-09_JPRB,0.94077E-07_JPRB,0.17143E-06_JPRB,0.24173E-06_JPRB,0.30586E-06_JPRB /)  
KB(:, 3,45, 1) = (/ &
 & 0.10254E-09_JPRB,0.10745E-06_JPRB,0.19582E-06_JPRB,0.27606E-06_JPRB,0.34593E-06_JPRB /)  
KB(:, 4,45, 1) = (/ &
 & 0.96757E-10_JPRB,0.12205E-06_JPRB,0.22201E-06_JPRB,0.31271E-06_JPRB,0.38876E-06_JPRB /)  
KB(:, 5,45, 1) = (/ &
 & 0.91979E-10_JPRB,0.13772E-06_JPRB,0.25015E-06_JPRB,0.35208E-06_JPRB,0.43561E-06_JPRB /)  
KB(:, 1,46, 1) = (/ &
 & 0.96889E-10_JPRB,0.64116E-07_JPRB,0.11708E-06_JPRB,0.16455E-06_JPRB,0.21036E-06_JPRB /)  
KB(:, 2,46, 1) = (/ &
 & 0.91281E-10_JPRB,0.73641E-07_JPRB,0.13436E-06_JPRB,0.18895E-06_JPRB,0.23951E-06_JPRB /)  
KB(:, 3,46, 1) = (/ &
 & 0.85830E-10_JPRB,0.84161E-07_JPRB,0.15360E-06_JPRB,0.21643E-06_JPRB,0.27176E-06_JPRB /)  
KB(:, 4,46, 1) = (/ &
 & 0.81048E-10_JPRB,0.95867E-07_JPRB,0.17447E-06_JPRB,0.24582E-06_JPRB,0.30613E-06_JPRB /)  
KB(:, 5,46, 1) = (/ &
 & 0.76712E-10_JPRB,0.10844E-06_JPRB,0.19706E-06_JPRB,0.27743E-06_JPRB,0.34329E-06_JPRB /)  
KB(:, 1,47, 1) = (/ &
 & 0.81516E-10_JPRB,0.49698E-07_JPRB,0.90596E-07_JPRB,0.12727E-06_JPRB,0.16313E-06_JPRB /)  
KB(:, 2,47, 1) = (/ &
 & 0.76609E-10_JPRB,0.57132E-07_JPRB,0.10433E-06_JPRB,0.14694E-06_JPRB,0.18672E-06_JPRB /)  
KB(:, 3,47, 1) = (/ &
 & 0.71975E-10_JPRB,0.65534E-07_JPRB,0.11955E-06_JPRB,0.16850E-06_JPRB,0.21215E-06_JPRB /)  
KB(:, 4,47, 1) = (/ &
 & 0.67908E-10_JPRB,0.74829E-07_JPRB,0.13619E-06_JPRB,0.19209E-06_JPRB,0.23959E-06_JPRB /)  
KB(:, 5,47, 1) = (/ &
 & 0.64117E-10_JPRB,0.84872E-07_JPRB,0.15433E-06_JPRB,0.21733E-06_JPRB,0.26915E-06_JPRB /)  
KB(:, 1,48, 1) = (/ &
 & 0.68429E-10_JPRB,0.38715E-07_JPRB,0.69854E-07_JPRB,0.98377E-07_JPRB,0.12619E-06_JPRB /)  
KB(:, 2,48, 1) = (/ &
 & 0.64236E-10_JPRB,0.44375E-07_JPRB,0.80895E-07_JPRB,0.11471E-06_JPRB,0.14604E-06_JPRB /)  
KB(:, 3,48, 1) = (/ &
 & 0.60510E-10_JPRB,0.51025E-07_JPRB,0.92977E-07_JPRB,0.13123E-06_JPRB,0.16542E-06_JPRB /)  
KB(:, 4,48, 1) = (/ &
 & 0.56851E-10_JPRB,0.58345E-07_JPRB,0.10633E-06_JPRB,0.14991E-06_JPRB,0.18745E-06_JPRB /)  
KB(:, 5,48, 1) = (/ &
 & 0.53674E-10_JPRB,0.66346E-07_JPRB,0.12070E-06_JPRB,0.17001E-06_JPRB,0.21095E-06_JPRB /)  
KB(:, 1,49, 1) = (/ &
 & 0.57387E-10_JPRB,0.29800E-07_JPRB,0.53817E-07_JPRB,0.75906E-07_JPRB,0.97710E-07_JPRB /)  
KB(:, 2,49, 1) = (/ &
 & 0.53960E-10_JPRB,0.34500E-07_JPRB,0.63205E-07_JPRB,0.88655E-07_JPRB,0.11310E-06_JPRB /)  
KB(:, 3,49, 1) = (/ &
 & 0.50740E-10_JPRB,0.39684E-07_JPRB,0.72502E-07_JPRB,0.10193E-06_JPRB,0.12892E-06_JPRB /)  
KB(:, 4,49, 1) = (/ &
 & 0.47710E-10_JPRB,0.45418E-07_JPRB,0.82941E-07_JPRB,0.11692E-06_JPRB,0.14649E-06_JPRB /)  
KB(:, 5,49, 1) = (/ &
 & 0.45050E-10_JPRB,0.51797E-07_JPRB,0.94320E-07_JPRB,0.13296E-06_JPRB,0.16526E-06_JPRB /)  
KB(:, 1,50, 1) = (/ &
 & 0.48010E-10_JPRB,0.22999E-07_JPRB,0.41682E-07_JPRB,0.58975E-07_JPRB,0.75898E-07_JPRB /)  
KB(:, 2,50, 1) = (/ &
 & 0.45282E-10_JPRB,0.26917E-07_JPRB,0.48929E-07_JPRB,0.68765E-07_JPRB,0.87983E-07_JPRB /)  
KB(:, 3,50, 1) = (/ &
 & 0.42531E-10_JPRB,0.30879E-07_JPRB,0.56406E-07_JPRB,0.79593E-07_JPRB,0.10109E-06_JPRB /)  
KB(:, 4,50, 1) = (/ &
 & 0.40002E-10_JPRB,0.35470E-07_JPRB,0.64706E-07_JPRB,0.91312E-07_JPRB,0.11473E-06_JPRB /)  
KB(:, 5,50, 1) = (/ &
 & 0.37674E-10_JPRB,0.40542E-07_JPRB,0.73834E-07_JPRB,0.10412E-06_JPRB,0.12967E-06_JPRB /)  
KB(:, 1,51, 1) = (/ &
 & 0.40094E-10_JPRB,0.17810E-07_JPRB,0.32412E-07_JPRB,0.45985E-07_JPRB,0.59041E-07_JPRB /)  
KB(:, 2,51, 1) = (/ &
 & 0.37901E-10_JPRB,0.21013E-07_JPRB,0.37921E-07_JPRB,0.53479E-07_JPRB,0.68479E-07_JPRB /)  
KB(:, 3,51, 1) = (/ &
 & 0.35584E-10_JPRB,0.24100E-07_JPRB,0.43988E-07_JPRB,0.62409E-07_JPRB,0.79311E-07_JPRB /)  
KB(:, 4,51, 1) = (/ &
 & 0.33516E-10_JPRB,0.27737E-07_JPRB,0.50544E-07_JPRB,0.71436E-07_JPRB,0.89912E-07_JPRB /)  
KB(:, 5,51, 1) = (/ &
 & 0.31503E-10_JPRB,0.31738E-07_JPRB,0.57889E-07_JPRB,0.81591E-07_JPRB,0.10195E-06_JPRB /)  
KB(:, 1,52, 1) = (/ &
 & 0.33462E-10_JPRB,0.13829E-07_JPRB,0.25227E-07_JPRB,0.35498E-07_JPRB,0.45793E-07_JPRB /)  
KB(:, 2,52, 1) = (/ &
 & 0.31703E-10_JPRB,0.16272E-07_JPRB,0.29393E-07_JPRB,0.41476E-07_JPRB,0.53340E-07_JPRB /)  
KB(:, 3,52, 1) = (/ &
 & 0.29856E-10_JPRB,0.18836E-07_JPRB,0.34537E-07_JPRB,0.48490E-07_JPRB,0.61791E-07_JPRB /)  
KB(:, 4,52, 1) = (/ &
 & 0.28038E-10_JPRB,0.21684E-07_JPRB,0.39578E-07_JPRB,0.55751E-07_JPRB,0.70422E-07_JPRB /)  
KB(:, 5,52, 1) = (/ &
 & 0.26375E-10_JPRB,0.24824E-07_JPRB,0.45389E-07_JPRB,0.63898E-07_JPRB,0.80071E-07_JPRB /)  
KB(:, 1,53, 1) = (/ &
 & 0.27859E-10_JPRB,0.10757E-07_JPRB,0.19436E-07_JPRB,0.27368E-07_JPRB,0.35401E-07_JPRB /)  
KB(:, 2,53, 1) = (/ &
 & 0.26482E-10_JPRB,0.12575E-07_JPRB,0.22786E-07_JPRB,0.32275E-07_JPRB,0.41504E-07_JPRB /)  
KB(:, 3,53, 1) = (/ &
 & 0.25013E-10_JPRB,0.14718E-07_JPRB,0.26786E-07_JPRB,0.37657E-07_JPRB,0.48150E-07_JPRB /)  
KB(:, 4,53, 1) = (/ &
 & 0.23481E-10_JPRB,0.16890E-07_JPRB,0.30875E-07_JPRB,0.43561E-07_JPRB,0.55284E-07_JPRB /)  
KB(:, 5,53, 1) = (/ &
 & 0.22103E-10_JPRB,0.19405E-07_JPRB,0.35435E-07_JPRB,0.50046E-07_JPRB,0.62824E-07_JPRB /)  
KB(:, 1,54, 1) = (/ &
 & 0.23262E-10_JPRB,0.83534E-08_JPRB,0.15033E-07_JPRB,0.21142E-07_JPRB,0.27491E-07_JPRB /)  
KB(:, 2,54, 1) = (/ &
 & 0.22075E-10_JPRB,0.97821E-08_JPRB,0.17791E-07_JPRB,0.25298E-07_JPRB,0.32447E-07_JPRB /)  
KB(:, 3,54, 1) = (/ &
 & 0.20887E-10_JPRB,0.11541E-07_JPRB,0.20852E-07_JPRB,0.29392E-07_JPRB,0.37643E-07_JPRB /)  
KB(:, 4,54, 1) = (/ &
 & 0.19629E-10_JPRB,0.13228E-07_JPRB,0.24164E-07_JPRB,0.34330E-07_JPRB,0.43622E-07_JPRB /)  
KB(:, 5,54, 1) = (/ &
 & 0.18475E-10_JPRB,0.15233E-07_JPRB,0.27779E-07_JPRB,0.39304E-07_JPRB,0.49432E-07_JPRB /)  
KB(:, 1,55, 1) = (/ &
 & 0.19360E-10_JPRB,0.64888E-08_JPRB,0.11644E-07_JPRB,0.16387E-07_JPRB,0.21340E-07_JPRB /)  
KB(:, 2,55, 1) = (/ &
 & 0.18372E-10_JPRB,0.76367E-08_JPRB,0.13947E-07_JPRB,0.19672E-07_JPRB,0.25401E-07_JPRB /)  
KB(:, 3,55, 1) = (/ &
 & 0.17421E-10_JPRB,0.90083E-08_JPRB,0.16275E-07_JPRB,0.22971E-07_JPRB,0.29522E-07_JPRB /)  
KB(:, 4,55, 1) = (/ &
 & 0.16413E-10_JPRB,0.10402E-07_JPRB,0.19081E-07_JPRB,0.26854E-07_JPRB,0.34233E-07_JPRB /)  
KB(:, 5,55, 1) = (/ &
 & 0.15417E-10_JPRB,0.11984E-07_JPRB,0.21835E-07_JPRB,0.30856E-07_JPRB,0.38954E-07_JPRB /)  
KB(:, 1,56, 1) = (/ &
 & 0.16094E-10_JPRB,0.50174E-08_JPRB,0.90283E-08_JPRB,0.12718E-07_JPRB,0.16576E-07_JPRB /)  
KB(:, 2,56, 1) = (/ &
 & 0.15265E-10_JPRB,0.59747E-08_JPRB,0.10850E-07_JPRB,0.15297E-07_JPRB,0.19783E-07_JPRB /)  
KB(:, 3,56, 1) = (/ &
 & 0.14515E-10_JPRB,0.70142E-08_JPRB,0.12699E-07_JPRB,0.17960E-07_JPRB,0.23171E-07_JPRB /)  
KB(:, 4,56, 1) = (/ &
 & 0.13715E-10_JPRB,0.81626E-08_JPRB,0.14940E-07_JPRB,0.20994E-07_JPRB,0.26865E-07_JPRB /)  
KB(:, 5,56, 1) = (/ &
 & 0.12880E-10_JPRB,0.94054E-08_JPRB,0.17206E-07_JPRB,0.24221E-07_JPRB,0.30739E-07_JPRB /)  
KB(:, 1,57, 1) = (/ &
 & 0.13368E-10_JPRB,0.38838E-08_JPRB,0.69991E-08_JPRB,0.98372E-08_JPRB,0.12821E-07_JPRB /)  
KB(:, 2,57, 1) = (/ &
 & 0.12743E-10_JPRB,0.46751E-08_JPRB,0.84243E-08_JPRB,0.11856E-07_JPRB,0.15406E-07_JPRB /)  
KB(:, 3,57, 1) = (/ &
 & 0.12087E-10_JPRB,0.54642E-08_JPRB,0.99295E-08_JPRB,0.14069E-07_JPRB,0.18144E-07_JPRB /)  
KB(:, 4,57, 1) = (/ &
 & 0.11442E-10_JPRB,0.64461E-08_JPRB,0.11657E-07_JPRB,0.16407E-07_JPRB,0.21072E-07_JPRB /)  
KB(:, 5,57, 1) = (/ &
 & 0.10759E-10_JPRB,0.73711E-08_JPRB,0.13478E-07_JPRB,0.19106E-07_JPRB,0.24314E-07_JPRB /)  
KB(:, 1,58, 1) = (/ &
 & 0.11081E-10_JPRB,0.30148E-08_JPRB,0.54165E-08_JPRB,0.76421E-08_JPRB,0.99496E-08_JPRB /)  
KB(:, 2,58, 1) = (/ &
 & 0.10598E-10_JPRB,0.36337E-08_JPRB,0.65375E-08_JPRB,0.92041E-08_JPRB,0.12025E-07_JPRB /)  
KB(:, 3,58, 1) = (/ &
 & 0.10052E-10_JPRB,0.42712E-08_JPRB,0.77841E-08_JPRB,0.11053E-07_JPRB,0.14306E-07_JPRB /)  
KB(:, 4,58, 1) = (/ &
 & 0.95308E-11_JPRB,0.50429E-08_JPRB,0.91133E-08_JPRB,0.12865E-07_JPRB,0.16554E-07_JPRB /)  
KB(:, 5,58, 1) = (/ &
 & 0.89795E-11_JPRB,0.57979E-08_JPRB,0.10615E-07_JPRB,0.15051E-07_JPRB,0.19216E-07_JPRB /)  
KB(:, 1,59, 1) = (/ &
 & 0.91194E-11_JPRB,0.24214E-08_JPRB,0.43496E-08_JPRB,0.61531E-08_JPRB,0.80136E-08_JPRB /)  
KB(:, 2,59, 1) = (/ &
 & 0.87287E-11_JPRB,0.29232E-08_JPRB,0.52535E-08_JPRB,0.73966E-08_JPRB,0.96830E-08_JPRB /)  
KB(:, 3,59, 1) = (/ &
 & 0.82765E-11_JPRB,0.34412E-08_JPRB,0.62788E-08_JPRB,0.88992E-08_JPRB,0.11534E-07_JPRB /)  
KB(:, 4,59, 1) = (/ &
 & 0.78605E-11_JPRB,0.40632E-08_JPRB,0.73454E-08_JPRB,0.10382E-07_JPRB,0.13372E-07_JPRB /)  
KB(:, 5,59, 1) = (/ &
 & 0.74127E-11_JPRB,0.46801E-08_JPRB,0.85910E-08_JPRB,0.12137E-07_JPRB,0.15530E-07_JPRB /)  
KB(:, 1,13, 2) = (/ &
 & 0.17576E-05_JPRB,0.22518E-03_JPRB,0.36398E-03_JPRB,0.46505E-03_JPRB,0.97920E-03_JPRB /)  
KB(:, 2,13, 2) = (/ &
 & 0.19522E-05_JPRB,0.25688E-03_JPRB,0.42724E-03_JPRB,0.54293E-03_JPRB,0.11261E-02_JPRB /)  
KB(:, 3,13, 2) = (/ &
 & 0.21134E-05_JPRB,0.29382E-03_JPRB,0.49778E-03_JPRB,0.63186E-03_JPRB,0.12961E-02_JPRB /)  
KB(:, 4,13, 2) = (/ &
 & 0.22680E-05_JPRB,0.33585E-03_JPRB,0.57095E-03_JPRB,0.73149E-03_JPRB,0.14857E-02_JPRB /)  
KB(:, 5,13, 2) = (/ &
 & 0.23939E-05_JPRB,0.38326E-03_JPRB,0.64688E-03_JPRB,0.84120E-03_JPRB,0.16815E-02_JPRB /)  
KB(:, 1,14, 2) = (/ &
 & 0.13866E-05_JPRB,0.18816E-03_JPRB,0.30541E-03_JPRB,0.39082E-03_JPRB,0.80614E-03_JPRB /)  
KB(:, 2,14, 2) = (/ &
 & 0.14825E-05_JPRB,0.21525E-03_JPRB,0.35906E-03_JPRB,0.45772E-03_JPRB,0.92976E-03_JPRB /)  
KB(:, 3,14, 2) = (/ &
 & 0.16428E-05_JPRB,0.24664E-03_JPRB,0.41891E-03_JPRB,0.53341E-03_JPRB,0.10689E-02_JPRB /)  
KB(:, 4,14, 2) = (/ &
 & 0.17807E-05_JPRB,0.28218E-03_JPRB,0.48021E-03_JPRB,0.61861E-03_JPRB,0.12236E-02_JPRB /)  
KB(:, 5,14, 2) = (/ &
 & 0.18685E-05_JPRB,0.32204E-03_JPRB,0.54385E-03_JPRB,0.71223E-03_JPRB,0.13844E-02_JPRB /)  
KB(:, 1,15, 2) = (/ &
 & 0.10483E-05_JPRB,0.15699E-03_JPRB,0.25571E-03_JPRB,0.32803E-03_JPRB,0.65873E-03_JPRB /)  
KB(:, 2,15, 2) = (/ &
 & 0.11310E-05_JPRB,0.18016E-03_JPRB,0.30071E-03_JPRB,0.38534E-03_JPRB,0.75916E-03_JPRB /)  
KB(:, 3,15, 2) = (/ &
 & 0.12330E-05_JPRB,0.20672E-03_JPRB,0.35181E-03_JPRB,0.44940E-03_JPRB,0.87041E-03_JPRB /)  
KB(:, 4,15, 2) = (/ &
 & 0.13426E-05_JPRB,0.23650E-03_JPRB,0.40292E-03_JPRB,0.52246E-03_JPRB,0.99445E-03_JPRB /)  
KB(:, 5,15, 2) = (/ &
 & 0.14514E-05_JPRB,0.26979E-03_JPRB,0.45684E-03_JPRB,0.60195E-03_JPRB,0.11173E-02_JPRB /)  
KB(:, 1,16, 2) = (/ &
 & 0.80663E-06_JPRB,0.13098E-03_JPRB,0.21382E-03_JPRB,0.27539E-03_JPRB,0.53727E-03_JPRB /)  
KB(:, 2,16, 2) = (/ &
 & 0.85747E-06_JPRB,0.15058E-03_JPRB,0.25201E-03_JPRB,0.32406E-03_JPRB,0.61573E-03_JPRB /)  
KB(:, 3,16, 2) = (/ &
 & 0.92435E-06_JPRB,0.17283E-03_JPRB,0.29542E-03_JPRB,0.37879E-03_JPRB,0.70140E-03_JPRB /)  
KB(:, 4,16, 2) = (/ &
 & 0.99747E-06_JPRB,0.19793E-03_JPRB,0.33807E-03_JPRB,0.44076E-03_JPRB,0.79468E-03_JPRB /)  
KB(:, 5,16, 2) = (/ &
 & 0.10819E-05_JPRB,0.22582E-03_JPRB,0.38354E-03_JPRB,0.50663E-03_JPRB,0.88980E-03_JPRB /)  
KB(:, 1,17, 2) = (/ &
 & 0.61772E-06_JPRB,0.10941E-03_JPRB,0.17926E-03_JPRB,0.23144E-03_JPRB,0.43554E-03_JPRB /)  
KB(:, 2,17, 2) = (/ &
 & 0.65718E-06_JPRB,0.12576E-03_JPRB,0.21174E-03_JPRB,0.27275E-03_JPRB,0.49750E-03_JPRB /)  
KB(:, 3,17, 2) = (/ &
 & 0.69949E-06_JPRB,0.14461E-03_JPRB,0.24852E-03_JPRB,0.31937E-03_JPRB,0.56462E-03_JPRB /)  
KB(:, 4,17, 2) = (/ &
 & 0.75387E-06_JPRB,0.16580E-03_JPRB,0.28374E-03_JPRB,0.37213E-03_JPRB,0.63507E-03_JPRB /)  
KB(:, 5,17, 2) = (/ &
 & 0.79715E-06_JPRB,0.18926E-03_JPRB,0.32236E-03_JPRB,0.42588E-03_JPRB,0.70728E-03_JPRB /)  
KB(:, 1,18, 2) = (/ &
 & 0.47188E-06_JPRB,0.91952E-04_JPRB,0.15100E-03_JPRB,0.19495E-03_JPRB,0.35543E-03_JPRB /)  
KB(:, 2,18, 2) = (/ &
 & 0.50937E-06_JPRB,0.10513E-03_JPRB,0.17852E-03_JPRB,0.22999E-03_JPRB,0.40250E-03_JPRB /)  
KB(:, 3,18, 2) = (/ &
 & 0.54206E-06_JPRB,0.12130E-03_JPRB,0.20959E-03_JPRB,0.26979E-03_JPRB,0.45662E-03_JPRB /)  
KB(:, 4,18, 2) = (/ &
 & 0.57328E-06_JPRB,0.13936E-03_JPRB,0.23815E-03_JPRB,0.31451E-03_JPRB,0.51113E-03_JPRB /)  
KB(:, 5,18, 2) = (/ &
 & 0.61077E-06_JPRB,0.15916E-03_JPRB,0.27075E-03_JPRB,0.35967E-03_JPRB,0.57076E-03_JPRB /)  
KB(:, 1,19, 2) = (/ &
 & 0.36005E-06_JPRB,0.76984E-04_JPRB,0.12743E-03_JPRB,0.16422E-03_JPRB,0.28885E-03_JPRB /)  
KB(:, 2,19, 2) = (/ &
 & 0.38988E-06_JPRB,0.88029E-04_JPRB,0.15067E-03_JPRB,0.19396E-03_JPRB,0.32854E-03_JPRB /)  
KB(:, 3,19, 2) = (/ &
 & 0.41989E-06_JPRB,0.10172E-03_JPRB,0.17539E-03_JPRB,0.22784E-03_JPRB,0.37045E-03_JPRB /)  
KB(:, 4,19, 2) = (/ &
 & 0.44092E-06_JPRB,0.11727E-03_JPRB,0.20004E-03_JPRB,0.26592E-03_JPRB,0.41598E-03_JPRB /)  
KB(:, 5,19, 2) = (/ &
 & 0.46883E-06_JPRB,0.13386E-03_JPRB,0.22769E-03_JPRB,0.30285E-03_JPRB,0.46550E-03_JPRB /)  
KB(:, 1,20, 2) = (/ &
 & 0.27908E-06_JPRB,0.64450E-04_JPRB,0.10795E-03_JPRB,0.13889E-03_JPRB,0.23878E-03_JPRB /)  
KB(:, 2,20, 2) = (/ &
 & 0.30934E-06_JPRB,0.74187E-04_JPRB,0.12773E-03_JPRB,0.16417E-03_JPRB,0.27017E-03_JPRB /)  
KB(:, 3,20, 2) = (/ &
 & 0.33086E-06_JPRB,0.85801E-04_JPRB,0.14782E-03_JPRB,0.19307E-03_JPRB,0.30508E-03_JPRB /)  
KB(:, 4,20, 2) = (/ &
 & 0.35058E-06_JPRB,0.98861E-04_JPRB,0.16868E-03_JPRB,0.22508E-03_JPRB,0.34249E-03_JPRB /)  
KB(:, 5,20, 2) = (/ &
 & 0.37069E-06_JPRB,0.11306E-03_JPRB,0.19188E-03_JPRB,0.25601E-03_JPRB,0.38519E-03_JPRB /)  
KB(:, 1,21, 2) = (/ &
 & 0.22418E-06_JPRB,0.54095E-04_JPRB,0.91414E-04_JPRB,0.11757E-03_JPRB,0.19697E-03_JPRB /)  
KB(:, 2,21, 2) = (/ &
 & 0.24559E-06_JPRB,0.62567E-04_JPRB,0.10819E-03_JPRB,0.13908E-03_JPRB,0.22284E-03_JPRB /)  
KB(:, 3,21, 2) = (/ &
 & 0.26169E-06_JPRB,0.72383E-04_JPRB,0.12481E-03_JPRB,0.16368E-03_JPRB,0.25205E-03_JPRB /)  
KB(:, 4,21, 2) = (/ &
 & 0.27885E-06_JPRB,0.83446E-04_JPRB,0.14258E-03_JPRB,0.18910E-03_JPRB,0.28386E-03_JPRB /)  
KB(:, 5,21, 2) = (/ &
 & 0.29344E-06_JPRB,0.95540E-04_JPRB,0.16198E-03_JPRB,0.21609E-03_JPRB,0.31947E-03_JPRB /)  
KB(:, 1,22, 2) = (/ &
 & 0.17941E-06_JPRB,0.45830E-04_JPRB,0.78176E-04_JPRB,0.10061E-03_JPRB,0.16313E-03_JPRB /)  
KB(:, 2,22, 2) = (/ &
 & 0.19397E-06_JPRB,0.53139E-04_JPRB,0.92556E-04_JPRB,0.11901E-03_JPRB,0.18482E-03_JPRB /)  
KB(:, 3,22, 2) = (/ &
 & 0.20707E-06_JPRB,0.61593E-04_JPRB,0.10579E-03_JPRB,0.14008E-03_JPRB,0.20965E-03_JPRB /)  
KB(:, 4,22, 2) = (/ &
 & 0.22071E-06_JPRB,0.71016E-04_JPRB,0.12100E-03_JPRB,0.16128E-03_JPRB,0.23661E-03_JPRB /)  
KB(:, 5,22, 2) = (/ &
 & 0.23148E-06_JPRB,0.81286E-04_JPRB,0.13795E-03_JPRB,0.18401E-03_JPRB,0.26580E-03_JPRB /)  
KB(:, 1,23, 2) = (/ &
 & 0.14291E-06_JPRB,0.38825E-04_JPRB,0.66866E-04_JPRB,0.86140E-04_JPRB,0.13511E-03_JPRB /)  
KB(:, 2,23, 2) = (/ &
 & 0.15179E-06_JPRB,0.45135E-04_JPRB,0.78450E-04_JPRB,0.10194E-03_JPRB,0.15369E-03_JPRB /)  
KB(:, 3,23, 2) = (/ &
 & 0.16326E-06_JPRB,0.52399E-04_JPRB,0.89919E-04_JPRB,0.12001E-03_JPRB,0.17441E-03_JPRB /)  
KB(:, 4,23, 2) = (/ &
 & 0.17307E-06_JPRB,0.60440E-04_JPRB,0.10293E-03_JPRB,0.13735E-03_JPRB,0.19668E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART13',1,ZHOOK_HANDLE)
END SUBROUTINE PART13


SUBROUTINE PART14

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART14',0,ZHOOK_HANDLE)


KB(:, 5,23, 2) = (/ &
 & 0.18137E-06_JPRB,0.69189E-04_JPRB,0.11759E-03_JPRB,0.15651E-03_JPRB,0.21998E-03_JPRB /)  
KB(:, 1,24, 2) = (/ &
 & 0.11245E-06_JPRB,0.32862E-04_JPRB,0.57166E-04_JPRB,0.73828E-04_JPRB,0.11185E-03_JPRB /)  
KB(:, 2,24, 2) = (/ &
 & 0.11958E-06_JPRB,0.38281E-04_JPRB,0.66635E-04_JPRB,0.87390E-04_JPRB,0.12740E-03_JPRB /)  
KB(:, 3,24, 2) = (/ &
 & 0.12702E-06_JPRB,0.44519E-04_JPRB,0.76606E-04_JPRB,0.10190E-03_JPRB,0.14418E-03_JPRB /)  
KB(:, 4,24, 2) = (/ &
 & 0.13467E-06_JPRB,0.51373E-04_JPRB,0.87622E-04_JPRB,0.11700E-03_JPRB,0.16205E-03_JPRB /)  
KB(:, 5,24, 2) = (/ &
 & 0.14120E-06_JPRB,0.58874E-04_JPRB,0.10019E-03_JPRB,0.13348E-03_JPRB,0.18188E-03_JPRB /)  
KB(:, 1,25, 2) = (/ &
 & 0.88242E-07_JPRB,0.27950E-04_JPRB,0.49010E-04_JPRB,0.63434E-04_JPRB,0.92877E-04_JPRB /)  
KB(:, 2,25, 2) = (/ &
 & 0.94383E-07_JPRB,0.32610E-04_JPRB,0.56690E-04_JPRB,0.75114E-04_JPRB,0.10531E-03_JPRB /)  
KB(:, 3,25, 2) = (/ &
 & 0.99712E-07_JPRB,0.37929E-04_JPRB,0.65204E-04_JPRB,0.87113E-04_JPRB,0.11931E-03_JPRB /)  
KB(:, 4,25, 2) = (/ &
 & 0.10473E-06_JPRB,0.43778E-04_JPRB,0.74805E-04_JPRB,0.99950E-04_JPRB,0.13427E-03_JPRB /)  
KB(:, 5,25, 2) = (/ &
 & 0.10988E-06_JPRB,0.50229E-04_JPRB,0.85598E-04_JPRB,0.11406E-03_JPRB,0.15050E-03_JPRB /)  
KB(:, 1,26, 2) = (/ &
 & 0.69696E-07_JPRB,0.23895E-04_JPRB,0.42166E-04_JPRB,0.54733E-04_JPRB,0.77146E-04_JPRB /)  
KB(:, 2,26, 2) = (/ &
 & 0.74390E-07_JPRB,0.27921E-04_JPRB,0.48387E-04_JPRB,0.64817E-04_JPRB,0.87607E-04_JPRB /)  
KB(:, 3,26, 2) = (/ &
 & 0.78856E-07_JPRB,0.32497E-04_JPRB,0.55692E-04_JPRB,0.74691E-04_JPRB,0.99387E-04_JPRB /)  
KB(:, 4,26, 2) = (/ &
 & 0.83253E-07_JPRB,0.37491E-04_JPRB,0.64130E-04_JPRB,0.85609E-04_JPRB,0.11193E-03_JPRB /)  
KB(:, 5,26, 2) = (/ &
 & 0.87675E-07_JPRB,0.43011E-04_JPRB,0.73398E-04_JPRB,0.97828E-04_JPRB,0.12574E-03_JPRB /)  
KB(:, 1,27, 2) = (/ &
 & 0.54619E-07_JPRB,0.20469E-04_JPRB,0.35869E-04_JPRB,0.47259E-04_JPRB,0.64151E-04_JPRB /)  
KB(:, 2,27, 2) = (/ &
 & 0.58657E-07_JPRB,0.23925E-04_JPRB,0.41468E-04_JPRB,0.55499E-04_JPRB,0.72911E-04_JPRB /)  
KB(:, 3,27, 2) = (/ &
 & 0.62532E-07_JPRB,0.27839E-04_JPRB,0.47735E-04_JPRB,0.63985E-04_JPRB,0.82955E-04_JPRB /)  
KB(:, 4,27, 2) = (/ &
 & 0.66184E-07_JPRB,0.32141E-04_JPRB,0.55001E-04_JPRB,0.73456E-04_JPRB,0.93567E-04_JPRB /)  
KB(:, 5,27, 2) = (/ &
 & 0.69305E-07_JPRB,0.36605E-04_JPRB,0.62968E-04_JPRB,0.83938E-04_JPRB,0.10517E-03_JPRB /)  
KB(:, 1,28, 2) = (/ &
 & 0.43348E-07_JPRB,0.17476E-04_JPRB,0.30692E-04_JPRB,0.40803E-04_JPRB,0.53271E-04_JPRB /)  
KB(:, 2,28, 2) = (/ &
 & 0.46348E-07_JPRB,0.20496E-04_JPRB,0.35498E-04_JPRB,0.47629E-04_JPRB,0.60809E-04_JPRB /)  
KB(:, 3,28, 2) = (/ &
 & 0.49507E-07_JPRB,0.23857E-04_JPRB,0.40974E-04_JPRB,0.54947E-04_JPRB,0.69222E-04_JPRB /)  
KB(:, 4,28, 2) = (/ &
 & 0.52419E-07_JPRB,0.27560E-04_JPRB,0.47205E-04_JPRB,0.63044E-04_JPRB,0.78123E-04_JPRB /)  
KB(:, 5,28, 2) = (/ &
 & 0.54842E-07_JPRB,0.31094E-04_JPRB,0.54028E-04_JPRB,0.72116E-04_JPRB,0.87834E-04_JPRB /)  
KB(:, 1,29, 2) = (/ &
 & 0.34480E-07_JPRB,0.15027E-04_JPRB,0.26268E-04_JPRB,0.35358E-04_JPRB,0.44711E-04_JPRB /)  
KB(:, 2,29, 2) = (/ &
 & 0.36985E-07_JPRB,0.17638E-04_JPRB,0.30405E-04_JPRB,0.40938E-04_JPRB,0.51054E-04_JPRB /)  
KB(:, 3,29, 2) = (/ &
 & 0.39476E-07_JPRB,0.20512E-04_JPRB,0.35237E-04_JPRB,0.47207E-04_JPRB,0.58034E-04_JPRB /)  
KB(:, 4,29, 2) = (/ &
 & 0.41650E-07_JPRB,0.23694E-04_JPRB,0.40586E-04_JPRB,0.54286E-04_JPRB,0.65708E-04_JPRB /)  
KB(:, 5,29, 2) = (/ &
 & 0.43693E-07_JPRB,0.26438E-04_JPRB,0.46467E-04_JPRB,0.62035E-04_JPRB,0.73872E-04_JPRB /)  
KB(:, 1,30, 2) = (/ &
 & 0.27402E-07_JPRB,0.12932E-04_JPRB,0.22585E-04_JPRB,0.30365E-04_JPRB,0.37471E-04_JPRB /)  
KB(:, 2,30, 2) = (/ &
 & 0.29377E-07_JPRB,0.15183E-04_JPRB,0.26158E-04_JPRB,0.35195E-04_JPRB,0.42867E-04_JPRB /)  
KB(:, 3,30, 2) = (/ &
 & 0.31353E-07_JPRB,0.17658E-04_JPRB,0.30343E-04_JPRB,0.40606E-04_JPRB,0.48858E-04_JPRB /)  
KB(:, 4,30, 2) = (/ &
 & 0.33056E-07_JPRB,0.20286E-04_JPRB,0.34924E-04_JPRB,0.46735E-04_JPRB,0.55329E-04_JPRB /)  
KB(:, 5,30, 2) = (/ &
 & 0.34673E-07_JPRB,0.22451E-04_JPRB,0.39717E-04_JPRB,0.53329E-04_JPRB,0.62151E-04_JPRB /)  
KB(:, 1,31, 2) = (/ &
 & 0.21716E-07_JPRB,0.11156E-04_JPRB,0.19427E-04_JPRB,0.26169E-04_JPRB,0.31512E-04_JPRB /)  
KB(:, 2,31, 2) = (/ &
 & 0.23313E-07_JPRB,0.13091E-04_JPRB,0.22568E-04_JPRB,0.30377E-04_JPRB,0.36216E-04_JPRB /)  
KB(:, 3,31, 2) = (/ &
 & 0.24803E-07_JPRB,0.15221E-04_JPRB,0.26157E-04_JPRB,0.35050E-04_JPRB,0.41256E-04_JPRB /)  
KB(:, 4,31, 2) = (/ &
 & 0.26260E-07_JPRB,0.17277E-04_JPRB,0.30091E-04_JPRB,0.40288E-04_JPRB,0.46693E-04_JPRB /)  
KB(:, 5,31, 2) = (/ &
 & 0.27334E-07_JPRB,0.19159E-04_JPRB,0.33773E-04_JPRB,0.45892E-04_JPRB,0.52314E-04_JPRB /)  
KB(:, 1,32, 2) = (/ &
 & 0.17123E-07_JPRB,0.96453E-05_JPRB,0.16688E-04_JPRB,0.22528E-04_JPRB,0.26648E-04_JPRB /)  
KB(:, 2,32, 2) = (/ &
 & 0.18489E-07_JPRB,0.11305E-04_JPRB,0.19464E-04_JPRB,0.26137E-04_JPRB,0.30617E-04_JPRB /)  
KB(:, 3,32, 2) = (/ &
 & 0.19621E-07_JPRB,0.13143E-04_JPRB,0.22554E-04_JPRB,0.30238E-04_JPRB,0.34876E-04_JPRB /)  
KB(:, 4,32, 2) = (/ &
 & 0.20653E-07_JPRB,0.14698E-04_JPRB,0.25928E-04_JPRB,0.34712E-04_JPRB,0.39398E-04_JPRB /)  
KB(:, 5,32, 2) = (/ &
 & 0.21500E-07_JPRB,0.16315E-04_JPRB,0.28651E-04_JPRB,0.39302E-04_JPRB,0.44097E-04_JPRB /)  
KB(:, 1,33, 2) = (/ &
 & 0.13414E-07_JPRB,0.83355E-05_JPRB,0.14409E-04_JPRB,0.19461E-04_JPRB,0.22582E-04_JPRB /)  
KB(:, 2,33, 2) = (/ &
 & 0.14456E-07_JPRB,0.97647E-05_JPRB,0.16818E-04_JPRB,0.22578E-04_JPRB,0.25923E-04_JPRB /)  
KB(:, 3,33, 2) = (/ &
 & 0.15416E-07_JPRB,0.11250E-04_JPRB,0.19451E-04_JPRB,0.26119E-04_JPRB,0.29482E-04_JPRB /)  
KB(:, 4,33, 2) = (/ &
 & 0.16184E-07_JPRB,0.12520E-04_JPRB,0.22064E-04_JPRB,0.29911E-04_JPRB,0.33230E-04_JPRB /)  
KB(:, 5,33, 2) = (/ &
 & 0.16861E-07_JPRB,0.13810E-04_JPRB,0.24332E-04_JPRB,0.33363E-04_JPRB,0.37135E-04_JPRB /)  
KB(:, 1,34, 2) = (/ &
 & 0.10575E-07_JPRB,0.71786E-05_JPRB,0.12407E-04_JPRB,0.16719E-04_JPRB,0.19158E-04_JPRB /)  
KB(:, 2,34, 2) = (/ &
 & 0.11328E-07_JPRB,0.84093E-05_JPRB,0.14457E-04_JPRB,0.19433E-04_JPRB,0.21940E-04_JPRB /)  
KB(:, 3,34, 2) = (/ &
 & 0.12049E-07_JPRB,0.95860E-05_JPRB,0.16718E-04_JPRB,0.22425E-04_JPRB,0.24932E-04_JPRB /)  
KB(:, 4,34, 2) = (/ &
 & 0.12689E-07_JPRB,0.10655E-04_JPRB,0.18771E-04_JPRB,0.25647E-04_JPRB,0.28065E-04_JPRB /)  
KB(:, 5,34, 2) = (/ &
 & 0.13241E-07_JPRB,0.11703E-04_JPRB,0.20628E-04_JPRB,0.28184E-04_JPRB,0.31323E-04_JPRB /)  
KB(:, 1,35, 2) = (/ &
 & 0.82489E-08_JPRB,0.60850E-05_JPRB,0.10505E-04_JPRB,0.14140E-04_JPRB,0.16004E-04_JPRB /)  
KB(:, 2,35, 2) = (/ &
 & 0.88532E-08_JPRB,0.71306E-05_JPRB,0.12250E-04_JPRB,0.16463E-04_JPRB,0.18333E-04_JPRB /)  
KB(:, 3,35, 2) = (/ &
 & 0.93468E-08_JPRB,0.80269E-05_JPRB,0.14158E-04_JPRB,0.18989E-04_JPRB,0.20835E-04_JPRB /)  
KB(:, 4,35, 2) = (/ &
 & 0.98478E-08_JPRB,0.89450E-05_JPRB,0.15691E-04_JPRB,0.21576E-04_JPRB,0.23428E-04_JPRB /)  
KB(:, 5,35, 2) = (/ &
 & 0.10332E-07_JPRB,0.98354E-05_JPRB,0.17293E-04_JPRB,0.23618E-04_JPRB,0.26128E-04_JPRB /)  
KB(:, 1,36, 2) = (/ &
 & 0.63951E-08_JPRB,0.50545E-05_JPRB,0.87378E-05_JPRB,0.11778E-04_JPRB,0.13176E-04_JPRB /)  
KB(:, 2,36, 2) = (/ &
 & 0.68252E-08_JPRB,0.59348E-05_JPRB,0.10193E-04_JPRB,0.13730E-04_JPRB,0.15104E-04_JPRB /)  
KB(:, 3,36, 2) = (/ &
 & 0.72445E-08_JPRB,0.66480E-05_JPRB,0.11783E-04_JPRB,0.15832E-04_JPRB,0.17160E-04_JPRB /)  
KB(:, 4,36, 2) = (/ &
 & 0.75871E-08_JPRB,0.73960E-05_JPRB,0.13005E-04_JPRB,0.17866E-04_JPRB,0.19295E-04_JPRB /)  
KB(:, 5,36, 2) = (/ &
 & 0.79075E-08_JPRB,0.81558E-05_JPRB,0.14306E-04_JPRB,0.19617E-04_JPRB,0.21532E-04_JPRB /)  
KB(:, 1,37, 2) = (/ &
 & 0.50574E-08_JPRB,0.41215E-05_JPRB,0.71249E-05_JPRB,0.95923E-05_JPRB,0.10686E-04_JPRB /)  
KB(:, 2,37, 2) = (/ &
 & 0.53967E-08_JPRB,0.48518E-05_JPRB,0.83286E-05_JPRB,0.11206E-04_JPRB,0.12269E-04_JPRB /)  
KB(:, 3,37, 2) = (/ &
 & 0.57517E-08_JPRB,0.54411E-05_JPRB,0.96383E-05_JPRB,0.12942E-04_JPRB,0.13958E-04_JPRB /)  
KB(:, 4,37, 2) = (/ &
 & 0.60273E-08_JPRB,0.60590E-05_JPRB,0.10644E-04_JPRB,0.14619E-04_JPRB,0.15714E-04_JPRB /)  
KB(:, 5,37, 2) = (/ &
 & 0.62775E-08_JPRB,0.66900E-05_JPRB,0.11723E-04_JPRB,0.16077E-04_JPRB,0.17560E-04_JPRB /)  
KB(:, 1,38, 2) = (/ &
 & 0.39948E-08_JPRB,0.33535E-05_JPRB,0.57976E-05_JPRB,0.77989E-05_JPRB,0.86548E-05_JPRB /)  
KB(:, 2,38, 2) = (/ &
 & 0.42642E-08_JPRB,0.39584E-05_JPRB,0.67932E-05_JPRB,0.91290E-05_JPRB,0.99507E-05_JPRB /)  
KB(:, 3,38, 2) = (/ &
 & 0.45529E-08_JPRB,0.44478E-05_JPRB,0.78746E-05_JPRB,0.10563E-04_JPRB,0.11338E-04_JPRB /)  
KB(:, 4,38, 2) = (/ &
 & 0.47911E-08_JPRB,0.49592E-05_JPRB,0.87019E-05_JPRB,0.11950E-04_JPRB,0.12783E-04_JPRB /)  
KB(:, 5,38, 2) = (/ &
 & 0.49959E-08_JPRB,0.54820E-05_JPRB,0.95964E-05_JPRB,0.13155E-04_JPRB,0.14308E-04_JPRB /)  
KB(:, 1,39, 2) = (/ &
 & 0.31607E-08_JPRB,0.27260E-05_JPRB,0.47143E-05_JPRB,0.63381E-05_JPRB,0.70094E-05_JPRB /)  
KB(:, 2,39, 2) = (/ &
 & 0.33771E-08_JPRB,0.32263E-05_JPRB,0.55352E-05_JPRB,0.74322E-05_JPRB,0.80695E-05_JPRB /)  
KB(:, 3,39, 2) = (/ &
 & 0.35907E-08_JPRB,0.36316E-05_JPRB,0.64256E-05_JPRB,0.86133E-05_JPRB,0.92019E-05_JPRB /)  
KB(:, 4,39, 2) = (/ &
 & 0.37920E-08_JPRB,0.40555E-05_JPRB,0.71128E-05_JPRB,0.97677E-05_JPRB,0.10392E-04_JPRB /)  
KB(:, 5,39, 2) = (/ &
 & 0.39687E-08_JPRB,0.44882E-05_JPRB,0.78499E-05_JPRB,0.10753E-04_JPRB,0.11647E-04_JPRB /)  
KB(:, 1,40, 2) = (/ &
 & 0.25137E-08_JPRB,0.21782E-05_JPRB,0.37700E-05_JPRB,0.50636E-05_JPRB,0.55872E-05_JPRB /)  
KB(:, 2,40, 2) = (/ &
 & 0.26953E-08_JPRB,0.25872E-05_JPRB,0.44411E-05_JPRB,0.59538E-05_JPRB,0.64693E-05_JPRB /)  
KB(:, 3,40, 2) = (/ &
 & 0.28738E-08_JPRB,0.29415E-05_JPRB,0.51697E-05_JPRB,0.69217E-05_JPRB,0.73806E-05_JPRB /)  
KB(:, 4,40, 2) = (/ &
 & 0.30365E-08_JPRB,0.32887E-05_JPRB,0.57574E-05_JPRB,0.79115E-05_JPRB,0.83547E-05_JPRB /)  
KB(:, 5,40, 2) = (/ &
 & 0.31827E-08_JPRB,0.36391E-05_JPRB,0.63730E-05_JPRB,0.87114E-05_JPRB,0.93854E-05_JPRB /)  
KB(:, 1,41, 2) = (/ &
 & 0.20049E-08_JPRB,0.17350E-05_JPRB,0.30089E-05_JPRB,0.40342E-05_JPRB,0.44437E-05_JPRB /)  
KB(:, 2,41, 2) = (/ &
 & 0.21522E-08_JPRB,0.20685E-05_JPRB,0.35532E-05_JPRB,0.47542E-05_JPRB,0.51577E-05_JPRB /)  
KB(:, 3,41, 2) = (/ &
 & 0.22978E-08_JPRB,0.23716E-05_JPRB,0.41490E-05_JPRB,0.55459E-05_JPRB,0.59029E-05_JPRB /)  
KB(:, 4,41, 2) = (/ &
 & 0.24277E-08_JPRB,0.26608E-05_JPRB,0.46585E-05_JPRB,0.63928E-05_JPRB,0.67015E-05_JPRB /)  
KB(:, 5,41, 2) = (/ &
 & 0.25592E-08_JPRB,0.29434E-05_JPRB,0.51614E-05_JPRB,0.70376E-05_JPRB,0.75472E-05_JPRB /)  
KB(:, 1,42, 2) = (/ &
 & 0.16007E-08_JPRB,0.13793E-05_JPRB,0.23939E-05_JPRB,0.32203E-05_JPRB,0.35347E-05_JPRB /)  
KB(:, 2,42, 2) = (/ &
 & 0.17182E-08_JPRB,0.16509E-05_JPRB,0.28388E-05_JPRB,0.37950E-05_JPRB,0.41069E-05_JPRB /)  
KB(:, 3,42, 2) = (/ &
 & 0.18364E-08_JPRB,0.19058E-05_JPRB,0.33250E-05_JPRB,0.44386E-05_JPRB,0.47169E-05_JPRB /)  
KB(:, 4,42, 2) = (/ &
 & 0.19459E-08_JPRB,0.21436E-05_JPRB,0.37676E-05_JPRB,0.51389E-05_JPRB,0.53710E-05_JPRB /)  
KB(:, 5,42, 2) = (/ &
 & 0.20555E-08_JPRB,0.23781E-05_JPRB,0.41722E-05_JPRB,0.56915E-05_JPRB,0.60613E-05_JPRB /)  
KB(:, 1,43, 2) = (/ &
 & 0.12763E-08_JPRB,0.10855E-05_JPRB,0.18842E-05_JPRB,0.25355E-05_JPRB,0.27894E-05_JPRB /)  
KB(:, 2,43, 2) = (/ &
 & 0.13693E-08_JPRB,0.13038E-05_JPRB,0.22434E-05_JPRB,0.29991E-05_JPRB,0.32452E-05_JPRB /)  
KB(:, 3,43, 2) = (/ &
 & 0.14669E-08_JPRB,0.15227E-05_JPRB,0.26394E-05_JPRB,0.35195E-05_JPRB,0.37403E-05_JPRB /)  
KB(:, 4,43, 2) = (/ &
 & 0.15621E-08_JPRB,0.17145E-05_JPRB,0.30188E-05_JPRB,0.40881E-05_JPRB,0.42757E-05_JPRB /)  
KB(:, 5,43, 2) = (/ &
 & 0.16467E-08_JPRB,0.19093E-05_JPRB,0.33481E-05_JPRB,0.45768E-05_JPRB,0.48357E-05_JPRB /)  
KB(:, 1,44, 2) = (/ &
 & 0.10164E-08_JPRB,0.84908E-06_JPRB,0.14741E-05_JPRB,0.19864E-05_JPRB,0.21744E-05_JPRB /)  
KB(:, 2,44, 2) = (/ &
 & 0.10926E-08_JPRB,0.10232E-05_JPRB,0.17642E-05_JPRB,0.23536E-05_JPRB,0.25562E-05_JPRB /)  
KB(:, 3,44, 2) = (/ &
 & 0.11717E-08_JPRB,0.12156E-05_JPRB,0.20836E-05_JPRB,0.27750E-05_JPRB,0.29547E-05_JPRB /)  
KB(:, 4,44, 2) = (/ &
 & 0.12502E-08_JPRB,0.13671E-05_JPRB,0.24149E-05_JPRB,0.32374E-05_JPRB,0.33856E-05_JPRB /)  
KB(:, 5,44, 2) = (/ &
 & 0.13204E-08_JPRB,0.15290E-05_JPRB,0.26801E-05_JPRB,0.36631E-05_JPRB,0.38430E-05_JPRB /)  
KB(:, 1,45, 2) = (/ &
 & 0.80967E-09_JPRB,0.66247E-06_JPRB,0.11525E-05_JPRB,0.15557E-05_JPRB,0.16911E-05_JPRB /)  
KB(:, 2,45, 2) = (/ &
 & 0.87091E-09_JPRB,0.80114E-06_JPRB,0.13838E-05_JPRB,0.18457E-05_JPRB,0.20071E-05_JPRB /)  
KB(:, 3,45, 2) = (/ &
 & 0.93471E-09_JPRB,0.96063E-06_JPRB,0.16414E-05_JPRB,0.21862E-05_JPRB,0.23357E-05_JPRB /)  
KB(:, 4,45, 2) = (/ &
 & 0.99996E-09_JPRB,0.10898E-05_JPRB,0.19287E-05_JPRB,0.25587E-05_JPRB,0.26765E-05_JPRB /)  
KB(:, 5,45, 2) = (/ &
 & 0.10594E-08_JPRB,0.12255E-05_JPRB,0.21437E-05_JPRB,0.29239E-05_JPRB,0.30491E-05_JPRB /)  
KB(:, 1,46, 2) = (/ &
 & 0.64438E-09_JPRB,0.51408E-06_JPRB,0.89692E-06_JPRB,0.12176E-05_JPRB,0.13094E-05_JPRB /)  
KB(:, 2,46, 2) = (/ &
 & 0.69338E-09_JPRB,0.62335E-06_JPRB,0.10783E-05_JPRB,0.14408E-05_JPRB,0.15697E-05_JPRB /)  
KB(:, 3,46, 2) = (/ &
 & 0.74249E-09_JPRB,0.75197E-06_JPRB,0.12859E-05_JPRB,0.17116E-05_JPRB,0.18286E-05_JPRB /)  
KB(:, 4,46, 2) = (/ &
 & 0.79710E-09_JPRB,0.86785E-06_JPRB,0.15182E-05_JPRB,0.20117E-05_JPRB,0.21072E-05_JPRB /)  
KB(:, 5,46, 2) = (/ &
 & 0.84966E-09_JPRB,0.97923E-06_JPRB,0.17156E-05_JPRB,0.23354E-05_JPRB,0.24096E-05_JPRB /)  
KB(:, 1,47, 2) = (/ &
 & 0.51236E-09_JPRB,0.39483E-06_JPRB,0.69100E-06_JPRB,0.94871E-06_JPRB,0.10050E-05_JPRB /)  
KB(:, 2,47, 2) = (/ &
 & 0.55075E-09_JPRB,0.48075E-06_JPRB,0.83326E-06_JPRB,0.11171E-05_JPRB,0.12169E-05_JPRB /)  
KB(:, 3,47, 2) = (/ &
 & 0.59153E-09_JPRB,0.58279E-06_JPRB,0.99922E-06_JPRB,0.13307E-05_JPRB,0.14227E-05_JPRB /)  
KB(:, 4,47, 2) = (/ &
 & 0.63485E-09_JPRB,0.68347E-06_JPRB,0.11845E-05_JPRB,0.15696E-05_JPRB,0.16474E-05_JPRB /)  
KB(:, 5,47, 2) = (/ &
 & 0.67833E-09_JPRB,0.77359E-06_JPRB,0.13593E-05_JPRB,0.18329E-05_JPRB,0.18933E-05_JPRB /)  
KB(:, 1,48, 2) = (/ &
 & 0.40749E-09_JPRB,0.30162E-06_JPRB,0.53408E-06_JPRB,0.72777E-06_JPRB,0.76768E-06_JPRB /)  
KB(:, 2,48, 2) = (/ &
 & 0.43682E-09_JPRB,0.36975E-06_JPRB,0.64201E-06_JPRB,0.86174E-06_JPRB,0.93334E-06_JPRB /)  
KB(:, 3,48, 2) = (/ &
 & 0.46981E-09_JPRB,0.45015E-06_JPRB,0.77460E-06_JPRB,0.10306E-05_JPRB,0.11092E-05_JPRB /)  
KB(:, 4,48, 2) = (/ &
 & 0.50302E-09_JPRB,0.53912E-06_JPRB,0.92171E-06_JPRB,0.12225E-05_JPRB,0.12874E-05_JPRB /)  
KB(:, 5,48, 2) = (/ &
 & 0.53999E-09_JPRB,0.61013E-06_JPRB,0.10790E-05_JPRB,0.14334E-05_JPRB,0.14828E-05_JPRB /)  
KB(:, 1,49, 2) = (/ &
 & 0.32288E-09_JPRB,0.23115E-06_JPRB,0.41625E-06_JPRB,0.55318E-06_JPRB,0.58476E-06_JPRB /)  
KB(:, 2,49, 2) = (/ &
 & 0.34731E-09_JPRB,0.28355E-06_JPRB,0.49493E-06_JPRB,0.66850E-06_JPRB,0.71600E-06_JPRB /)  
KB(:, 3,49, 2) = (/ &
 & 0.37310E-09_JPRB,0.34682E-06_JPRB,0.59820E-06_JPRB,0.79617E-06_JPRB,0.85985E-06_JPRB /)  
KB(:, 4,49, 2) = (/ &
 & 0.39975E-09_JPRB,0.42034E-06_JPRB,0.71527E-06_JPRB,0.95046E-06_JPRB,0.10041E-05_JPRB /)  
KB(:, 5,49, 2) = (/ &
 & 0.42970E-09_JPRB,0.48341E-06_JPRB,0.84829E-06_JPRB,0.11191E-05_JPRB,0.11582E-05_JPRB /)  
KB(:, 1,50, 2) = (/ &
 & 0.25646E-09_JPRB,0.17743E-06_JPRB,0.32423E-06_JPRB,0.42175E-06_JPRB,0.44754E-06_JPRB /)  
KB(:, 2,50, 2) = (/ &
 & 0.27669E-09_JPRB,0.21856E-06_JPRB,0.38220E-06_JPRB,0.52102E-06_JPRB,0.55141E-06_JPRB /)  
KB(:, 3,50, 2) = (/ &
 & 0.29654E-09_JPRB,0.26808E-06_JPRB,0.46375E-06_JPRB,0.61921E-06_JPRB,0.67025E-06_JPRB /)  
KB(:, 4,50, 2) = (/ &
 & 0.31872E-09_JPRB,0.32662E-06_JPRB,0.55687E-06_JPRB,0.73985E-06_JPRB,0.78291E-06_JPRB /)  
KB(:, 5,50, 2) = (/ &
 & 0.34198E-09_JPRB,0.38136E-06_JPRB,0.66385E-06_JPRB,0.87591E-06_JPRB,0.90771E-06_JPRB /)  
KB(:, 1,51, 2) = (/ &
 & 0.20472E-09_JPRB,0.13694E-06_JPRB,0.24726E-06_JPRB,0.32216E-06_JPRB,0.34229E-06_JPRB /)  
KB(:, 2,51, 2) = (/ &
 & 0.22054E-09_JPRB,0.16842E-06_JPRB,0.29646E-06_JPRB,0.40635E-06_JPRB,0.42402E-06_JPRB /)  
KB(:, 3,51, 2) = (/ &
 & 0.23653E-09_JPRB,0.20731E-06_JPRB,0.35913E-06_JPRB,0.48027E-06_JPRB,0.51714E-06_JPRB /)  
KB(:, 4,51, 2) = (/ &
 & 0.25402E-09_JPRB,0.25379E-06_JPRB,0.43377E-06_JPRB,0.57689E-06_JPRB,0.61228E-06_JPRB /)  
KB(:, 5,51, 2) = (/ &
 & 0.27233E-09_JPRB,0.30202E-06_JPRB,0.51940E-06_JPRB,0.68626E-06_JPRB,0.71146E-06_JPRB /)  
KB(:, 1,52, 2) = (/ &
 & 0.16428E-09_JPRB,0.10687E-06_JPRB,0.18803E-06_JPRB,0.24517E-06_JPRB,0.26090E-06_JPRB /)  
KB(:, 2,52, 2) = (/ &
 & 0.17520E-09_JPRB,0.12978E-06_JPRB,0.23025E-06_JPRB,0.31106E-06_JPRB,0.32512E-06_JPRB /)  
KB(:, 3,52, 2) = (/ &
 & 0.18865E-09_JPRB,0.15994E-06_JPRB,0.27726E-06_JPRB,0.37261E-06_JPRB,0.39888E-06_JPRB /)  
KB(:, 4,52, 2) = (/ &
 & 0.20265E-09_JPRB,0.19670E-06_JPRB,0.33708E-06_JPRB,0.44845E-06_JPRB,0.47779E-06_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART14',1,ZHOOK_HANDLE)
END SUBROUTINE PART14


SUBROUTINE PART15

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART15',0,ZHOOK_HANDLE)


KB(:, 5,52, 2) = (/ &
 & 0.21711E-09_JPRB,0.23739E-06_JPRB,0.40528E-06_JPRB,0.53668E-06_JPRB,0.55828E-06_JPRB /)  
KB(:, 1,53, 2) = (/ &
 & 0.13206E-09_JPRB,0.82677E-07_JPRB,0.14284E-06_JPRB,0.18640E-06_JPRB,0.19898E-06_JPRB /)  
KB(:, 2,53, 2) = (/ &
 & 0.13938E-09_JPRB,0.99597E-07_JPRB,0.18095E-06_JPRB,0.23725E-06_JPRB,0.24911E-06_JPRB /)  
KB(:, 3,53, 2) = (/ &
 & 0.15056E-09_JPRB,0.12309E-06_JPRB,0.21494E-06_JPRB,0.29026E-06_JPRB,0.30720E-06_JPRB /)  
KB(:, 4,53, 2) = (/ &
 & 0.16136E-09_JPRB,0.15205E-06_JPRB,0.26147E-06_JPRB,0.34774E-06_JPRB,0.37331E-06_JPRB /)  
KB(:, 5,53, 2) = (/ &
 & 0.17318E-09_JPRB,0.18547E-06_JPRB,0.31566E-06_JPRB,0.41857E-06_JPRB,0.43649E-06_JPRB /)  
KB(:, 1,54, 2) = (/ &
 & 0.10628E-09_JPRB,0.63529E-07_JPRB,0.10938E-06_JPRB,0.14285E-06_JPRB,0.15281E-06_JPRB /)  
KB(:, 2,54, 2) = (/ &
 & 0.11181E-09_JPRB,0.77068E-07_JPRB,0.14036E-06_JPRB,0.18201E-06_JPRB,0.19163E-06_JPRB /)  
KB(:, 3,54, 2) = (/ &
 & 0.11992E-09_JPRB,0.95387E-07_JPRB,0.16692E-06_JPRB,0.22878E-06_JPRB,0.23824E-06_JPRB /)  
KB(:, 4,54, 2) = (/ &
 & 0.12900E-09_JPRB,0.11809E-06_JPRB,0.20406E-06_JPRB,0.27163E-06_JPRB,0.29078E-06_JPRB /)  
KB(:, 5,54, 2) = (/ &
 & 0.13828E-09_JPRB,0.14510E-06_JPRB,0.24678E-06_JPRB,0.32753E-06_JPRB,0.34217E-06_JPRB /)  
KB(:, 1,55, 2) = (/ &
 & 0.85664E-10_JPRB,0.48444E-07_JPRB,0.83932E-07_JPRB,0.10950E-06_JPRB,0.11785E-06_JPRB /)  
KB(:, 2,55, 2) = (/ &
 & 0.89999E-10_JPRB,0.59885E-07_JPRB,0.10776E-06_JPRB,0.14023E-06_JPRB,0.14763E-06_JPRB /)  
KB(:, 3,55, 2) = (/ &
 & 0.95836E-10_JPRB,0.73941E-07_JPRB,0.13023E-06_JPRB,0.17876E-06_JPRB,0.18426E-06_JPRB /)  
KB(:, 4,55, 2) = (/ &
 & 0.10323E-09_JPRB,0.91791E-07_JPRB,0.15882E-06_JPRB,0.21202E-06_JPRB,0.22611E-06_JPRB /)  
KB(:, 5,55, 2) = (/ &
 & 0.11081E-09_JPRB,0.11336E-06_JPRB,0.19316E-06_JPRB,0.25647E-06_JPRB,0.26918E-06_JPRB /)  
KB(:, 1,56, 2) = (/ &
 & 0.69093E-10_JPRB,0.36832E-07_JPRB,0.64123E-07_JPRB,0.84030E-07_JPRB,0.90974E-07_JPRB /)  
KB(:, 2,56, 2) = (/ &
 & 0.72433E-10_JPRB,0.47084E-07_JPRB,0.82613E-07_JPRB,0.10758E-06_JPRB,0.11346E-06_JPRB /)  
KB(:, 3,56, 2) = (/ &
 & 0.76616E-10_JPRB,0.57388E-07_JPRB,0.10182E-06_JPRB,0.13768E-06_JPRB,0.14224E-06_JPRB /)  
KB(:, 4,56, 2) = (/ &
 & 0.82709E-10_JPRB,0.71294E-07_JPRB,0.12355E-06_JPRB,0.16530E-06_JPRB,0.17549E-06_JPRB /)  
KB(:, 5,56, 2) = (/ &
 & 0.88636E-10_JPRB,0.88445E-07_JPRB,0.15094E-06_JPRB,0.20067E-06_JPRB,0.21118E-06_JPRB /)  
KB(:, 1,57, 2) = (/ &
 & 0.55980E-10_JPRB,0.28018E-07_JPRB,0.48867E-07_JPRB,0.64857E-07_JPRB,0.70055E-07_JPRB /)  
KB(:, 2,57, 2) = (/ &
 & 0.58397E-10_JPRB,0.36620E-07_JPRB,0.63232E-07_JPRB,0.82428E-07_JPRB,0.87457E-07_JPRB /)  
KB(:, 3,57, 2) = (/ &
 & 0.61509E-10_JPRB,0.44446E-07_JPRB,0.80512E-07_JPRB,0.10580E-06_JPRB,0.10988E-06_JPRB /)  
KB(:, 4,57, 2) = (/ &
 & 0.66015E-10_JPRB,0.55222E-07_JPRB,0.96401E-07_JPRB,0.12935E-06_JPRB,0.13614E-06_JPRB /)  
KB(:, 5,57, 2) = (/ &
 & 0.70976E-10_JPRB,0.68821E-07_JPRB,0.11780E-06_JPRB,0.15632E-06_JPRB,0.16586E-06_JPRB /)  
KB(:, 1,58, 2) = (/ &
 & 0.45722E-10_JPRB,0.21506E-07_JPRB,0.37326E-07_JPRB,0.50333E-07_JPRB,0.54855E-07_JPRB /)  
KB(:, 2,58, 2) = (/ &
 & 0.47090E-10_JPRB,0.28249E-07_JPRB,0.48612E-07_JPRB,0.63442E-07_JPRB,0.67550E-07_JPRB /)  
KB(:, 3,58, 2) = (/ &
 & 0.49550E-10_JPRB,0.34430E-07_JPRB,0.62769E-07_JPRB,0.81509E-07_JPRB,0.84917E-07_JPRB /)  
KB(:, 4,58, 2) = (/ &
 & 0.52817E-10_JPRB,0.42958E-07_JPRB,0.75173E-07_JPRB,0.10204E-06_JPRB,0.10603E-06_JPRB /)  
KB(:, 5,58, 2) = (/ &
 & 0.56864E-10_JPRB,0.53637E-07_JPRB,0.92044E-07_JPRB,0.12229E-06_JPRB,0.13011E-06_JPRB /)  
KB(:, 1,59, 2) = (/ &
 & 0.37496E-10_JPRB,0.17255E-07_JPRB,0.29967E-07_JPRB,0.40394E-07_JPRB,0.44059E-07_JPRB /)  
KB(:, 2,59, 2) = (/ &
 & 0.38367E-10_JPRB,0.22782E-07_JPRB,0.39144E-07_JPRB,0.51019E-07_JPRB,0.54404E-07_JPRB /)  
KB(:, 3,59, 2) = (/ &
 & 0.40346E-10_JPRB,0.27842E-07_JPRB,0.50692E-07_JPRB,0.65716E-07_JPRB,0.68440E-07_JPRB /)  
KB(:, 4,59, 2) = (/ &
 & 0.42908E-10_JPRB,0.34761E-07_JPRB,0.60846E-07_JPRB,0.82834E-07_JPRB,0.85713E-07_JPRB /)  
KB(:, 5,59, 2) = (/ &
 & 0.46213E-10_JPRB,0.43467E-07_JPRB,0.74626E-07_JPRB,0.99144E-07_JPRB,0.10518E-06_JPRB /)  
KB(:, 1,13, 3) = (/ &
 & 0.91180E-05_JPRB,0.12754E-02_JPRB,0.19900E-02_JPRB,0.24440E-02_JPRB,0.40576E-02_JPRB /)  
KB(:, 2,13, 3) = (/ &
 & 0.95037E-05_JPRB,0.14150E-02_JPRB,0.22145E-02_JPRB,0.28094E-02_JPRB,0.44375E-02_JPRB /)  
KB(:, 3,13, 3) = (/ &
 & 0.99757E-05_JPRB,0.15626E-02_JPRB,0.24320E-02_JPRB,0.31375E-02_JPRB,0.48097E-02_JPRB /)  
KB(:, 4,13, 3) = (/ &
 & 0.10508E-04_JPRB,0.16997E-02_JPRB,0.26926E-02_JPRB,0.34483E-02_JPRB,0.51554E-02_JPRB /)  
KB(:, 5,13, 3) = (/ &
 & 0.11033E-04_JPRB,0.18373E-02_JPRB,0.29684E-02_JPRB,0.37861E-02_JPRB,0.54896E-02_JPRB /)  
KB(:, 1,14, 3) = (/ &
 & 0.73209E-05_JPRB,0.10727E-02_JPRB,0.16787E-02_JPRB,0.20881E-02_JPRB,0.33041E-02_JPRB /)  
KB(:, 2,14, 3) = (/ &
 & 0.76795E-05_JPRB,0.11937E-02_JPRB,0.18683E-02_JPRB,0.23616E-02_JPRB,0.36246E-02_JPRB /)  
KB(:, 3,14, 3) = (/ &
 & 0.80417E-05_JPRB,0.13177E-02_JPRB,0.20567E-02_JPRB,0.26465E-02_JPRB,0.39438E-02_JPRB /)  
KB(:, 4,14, 3) = (/ &
 & 0.84296E-05_JPRB,0.14317E-02_JPRB,0.22826E-02_JPRB,0.29022E-02_JPRB,0.42368E-02_JPRB /)  
KB(:, 5,14, 3) = (/ &
 & 0.88950E-05_JPRB,0.15495E-02_JPRB,0.25084E-02_JPRB,0.31901E-02_JPRB,0.44992E-02_JPRB /)  
KB(:, 1,15, 3) = (/ &
 & 0.58275E-05_JPRB,0.89895E-03_JPRB,0.14161E-02_JPRB,0.17760E-02_JPRB,0.26508E-02_JPRB /)  
KB(:, 2,15, 3) = (/ &
 & 0.61166E-05_JPRB,0.10025E-02_JPRB,0.15706E-02_JPRB,0.19893E-02_JPRB,0.29219E-02_JPRB /)  
KB(:, 3,15, 3) = (/ &
 & 0.64340E-05_JPRB,0.11055E-02_JPRB,0.17375E-02_JPRB,0.22237E-02_JPRB,0.31718E-02_JPRB /)  
KB(:, 4,15, 3) = (/ &
 & 0.67501E-05_JPRB,0.12028E-02_JPRB,0.19291E-02_JPRB,0.24433E-02_JPRB,0.34015E-02_JPRB /)  
KB(:, 5,15, 3) = (/ &
 & 0.70843E-05_JPRB,0.13034E-02_JPRB,0.21152E-02_JPRB,0.26892E-02_JPRB,0.36350E-02_JPRB /)  
KB(:, 1,16, 3) = (/ &
 & 0.45776E-05_JPRB,0.75233E-03_JPRB,0.11906E-02_JPRB,0.14957E-02_JPRB,0.21076E-02_JPRB /)  
KB(:, 2,16, 3) = (/ &
 & 0.48262E-05_JPRB,0.84051E-03_JPRB,0.13192E-02_JPRB,0.16780E-02_JPRB,0.23267E-02_JPRB /)  
KB(:, 3,16, 3) = (/ &
 & 0.51024E-05_JPRB,0.92603E-03_JPRB,0.14653E-02_JPRB,0.18671E-02_JPRB,0.25242E-02_JPRB /)  
KB(:, 4,16, 3) = (/ &
 & 0.53856E-05_JPRB,0.10093E-02_JPRB,0.16288E-02_JPRB,0.20599E-02_JPRB,0.27134E-02_JPRB /)  
KB(:, 5,16, 3) = (/ &
 & 0.56625E-05_JPRB,0.10939E-02_JPRB,0.17834E-02_JPRB,0.22693E-02_JPRB,0.29092E-02_JPRB /)  
KB(:, 1,17, 3) = (/ &
 & 0.35978E-05_JPRB,0.63055E-03_JPRB,0.10001E-02_JPRB,0.12618E-02_JPRB,0.16759E-02_JPRB /)  
KB(:, 2,17, 3) = (/ &
 & 0.38090E-05_JPRB,0.70519E-03_JPRB,0.11080E-02_JPRB,0.14142E-02_JPRB,0.18563E-02_JPRB /)  
KB(:, 3,17, 3) = (/ &
 & 0.40365E-05_JPRB,0.77593E-03_JPRB,0.12352E-02_JPRB,0.15692E-02_JPRB,0.20215E-02_JPRB /)  
KB(:, 4,17, 3) = (/ &
 & 0.42692E-05_JPRB,0.84648E-03_JPRB,0.13753E-02_JPRB,0.17361E-02_JPRB,0.21882E-02_JPRB /)  
KB(:, 5,17, 3) = (/ &
 & 0.45325E-05_JPRB,0.91815E-03_JPRB,0.15031E-02_JPRB,0.19156E-02_JPRB,0.23511E-02_JPRB /)  
KB(:, 1,18, 3) = (/ &
 & 0.28577E-05_JPRB,0.52923E-03_JPRB,0.84060E-03_JPRB,0.10641E-02_JPRB,0.13524E-02_JPRB /)  
KB(:, 2,18, 3) = (/ &
 & 0.30189E-05_JPRB,0.59275E-03_JPRB,0.93264E-03_JPRB,0.11925E-02_JPRB,0.15051E-02_JPRB /)  
KB(:, 3,18, 3) = (/ &
 & 0.31971E-05_JPRB,0.65140E-03_JPRB,0.10422E-02_JPRB,0.13174E-02_JPRB,0.16413E-02_JPRB /)  
KB(:, 4,18, 3) = (/ &
 & 0.33981E-05_JPRB,0.71144E-03_JPRB,0.11594E-02_JPRB,0.14613E-02_JPRB,0.17851E-02_JPRB /)  
KB(:, 5,18, 3) = (/ &
 & 0.36127E-05_JPRB,0.77200E-03_JPRB,0.12685E-02_JPRB,0.16164E-02_JPRB,0.19166E-02_JPRB /)  
KB(:, 1,19, 3) = (/ &
 & 0.22832E-05_JPRB,0.44489E-03_JPRB,0.70523E-03_JPRB,0.89150E-03_JPRB,0.11054E-02_JPRB /)  
KB(:, 2,19, 3) = (/ &
 & 0.24005E-05_JPRB,0.49860E-03_JPRB,0.78596E-03_JPRB,0.10033E-02_JPRB,0.12310E-02_JPRB /)  
KB(:, 3,19, 3) = (/ &
 & 0.25465E-05_JPRB,0.54746E-03_JPRB,0.88096E-03_JPRB,0.11084E-02_JPRB,0.13479E-02_JPRB /)  
KB(:, 4,19, 3) = (/ &
 & 0.27167E-05_JPRB,0.59760E-03_JPRB,0.97685E-03_JPRB,0.12305E-02_JPRB,0.14668E-02_JPRB /)  
KB(:, 5,19, 3) = (/ &
 & 0.28927E-05_JPRB,0.64844E-03_JPRB,0.10695E-02_JPRB,0.13632E-02_JPRB,0.15746E-02_JPRB /)  
KB(:, 1,20, 3) = (/ &
 & 0.18426E-05_JPRB,0.37567E-03_JPRB,0.59276E-03_JPRB,0.75002E-03_JPRB,0.91159E-03_JPRB /)  
KB(:, 2,20, 3) = (/ &
 & 0.19324E-05_JPRB,0.42049E-03_JPRB,0.66376E-03_JPRB,0.84304E-03_JPRB,0.10175E-02_JPRB /)  
KB(:, 3,20, 3) = (/ &
 & 0.20563E-05_JPRB,0.46104E-03_JPRB,0.74561E-03_JPRB,0.93568E-03_JPRB,0.11153E-02_JPRB /)  
KB(:, 4,20, 3) = (/ &
 & 0.21952E-05_JPRB,0.50302E-03_JPRB,0.82491E-03_JPRB,0.10410E-02_JPRB,0.12131E-02_JPRB /)  
KB(:, 5,20, 3) = (/ &
 & 0.23429E-05_JPRB,0.54570E-03_JPRB,0.90324E-03_JPRB,0.11512E-02_JPRB,0.13002E-02_JPRB /)  
KB(:, 1,21, 3) = (/ &
 & 0.14914E-05_JPRB,0.31727E-03_JPRB,0.49879E-03_JPRB,0.63141E-03_JPRB,0.75480E-03_JPRB /)  
KB(:, 2,21, 3) = (/ &
 & 0.15711E-05_JPRB,0.35367E-03_JPRB,0.56105E-03_JPRB,0.70859E-03_JPRB,0.84278E-03_JPRB /)  
KB(:, 3,21, 3) = (/ &
 & 0.16720E-05_JPRB,0.38776E-03_JPRB,0.63122E-03_JPRB,0.79066E-03_JPRB,0.92492E-03_JPRB /)  
KB(:, 4,21, 3) = (/ &
 & 0.17830E-05_JPRB,0.42327E-03_JPRB,0.69655E-03_JPRB,0.88311E-03_JPRB,0.10041E-02_JPRB /)  
KB(:, 5,21, 3) = (/ &
 & 0.19065E-05_JPRB,0.45905E-03_JPRB,0.76238E-03_JPRB,0.97320E-03_JPRB,0.10767E-02_JPRB /)  
KB(:, 1,22, 3) = (/ &
 & 0.12007E-05_JPRB,0.26976E-03_JPRB,0.42316E-03_JPRB,0.53750E-03_JPRB,0.62747E-03_JPRB /)  
KB(:, 2,22, 3) = (/ &
 & 0.12744E-05_JPRB,0.29880E-03_JPRB,0.47840E-03_JPRB,0.60094E-03_JPRB,0.70134E-03_JPRB /)  
KB(:, 3,22, 3) = (/ &
 & 0.13572E-05_JPRB,0.32813E-03_JPRB,0.53672E-03_JPRB,0.67341E-03_JPRB,0.76916E-03_JPRB /)  
KB(:, 4,22, 3) = (/ &
 & 0.14459E-05_JPRB,0.35761E-03_JPRB,0.59154E-03_JPRB,0.75421E-03_JPRB,0.83371E-03_JPRB /)  
KB(:, 5,22, 3) = (/ &
 & 0.15538E-05_JPRB,0.38792E-03_JPRB,0.64663E-03_JPRB,0.82877E-03_JPRB,0.89529E-03_JPRB /)  
KB(:, 1,23, 3) = (/ &
 & 0.96861E-06_JPRB,0.22918E-03_JPRB,0.36015E-03_JPRB,0.45719E-03_JPRB,0.52404E-03_JPRB /)  
KB(:, 2,23, 3) = (/ &
 & 0.10336E-05_JPRB,0.25321E-03_JPRB,0.40834E-03_JPRB,0.51161E-03_JPRB,0.58351E-03_JPRB /)  
KB(:, 3,23, 3) = (/ &
 & 0.10985E-05_JPRB,0.27767E-03_JPRB,0.45571E-03_JPRB,0.57459E-03_JPRB,0.63985E-03_JPRB /)  
KB(:, 4,23, 3) = (/ &
 & 0.11768E-05_JPRB,0.30252E-03_JPRB,0.50195E-03_JPRB,0.64190E-03_JPRB,0.69303E-03_JPRB /)  
KB(:, 5,23, 3) = (/ &
 & 0.12615E-05_JPRB,0.32794E-03_JPRB,0.54831E-03_JPRB,0.70579E-03_JPRB,0.74540E-03_JPRB /)  
KB(:, 1,24, 3) = (/ &
 & 0.77560E-06_JPRB,0.19437E-03_JPRB,0.30748E-03_JPRB,0.38828E-03_JPRB,0.43529E-03_JPRB /)  
KB(:, 2,24, 3) = (/ &
 & 0.82580E-06_JPRB,0.21438E-03_JPRB,0.34835E-03_JPRB,0.43617E-03_JPRB,0.48373E-03_JPRB /)  
KB(:, 3,24, 3) = (/ &
 & 0.88200E-06_JPRB,0.23492E-03_JPRB,0.38680E-03_JPRB,0.49169E-03_JPRB,0.53189E-03_JPRB /)  
KB(:, 4,24, 3) = (/ &
 & 0.94947E-06_JPRB,0.25573E-03_JPRB,0.42635E-03_JPRB,0.54641E-03_JPRB,0.57637E-03_JPRB /)  
KB(:, 5,24, 3) = (/ &
 & 0.10182E-05_JPRB,0.27745E-03_JPRB,0.46607E-03_JPRB,0.60046E-03_JPRB,0.61998E-03_JPRB /)  
KB(:, 1,25, 3) = (/ &
 & 0.61963E-06_JPRB,0.16454E-03_JPRB,0.26284E-03_JPRB,0.33016E-03_JPRB,0.36284E-03_JPRB /)  
KB(:, 2,25, 3) = (/ &
 & 0.66146E-06_JPRB,0.18162E-03_JPRB,0.29714E-03_JPRB,0.37315E-03_JPRB,0.40370E-03_JPRB /)  
KB(:, 3,25, 3) = (/ &
 & 0.71111E-06_JPRB,0.19882E-03_JPRB,0.32942E-03_JPRB,0.42130E-03_JPRB,0.44382E-03_JPRB /)  
KB(:, 4,25, 3) = (/ &
 & 0.76573E-06_JPRB,0.21663E-03_JPRB,0.36228E-03_JPRB,0.46640E-03_JPRB,0.48052E-03_JPRB /)  
KB(:, 5,25, 3) = (/ &
 & 0.82100E-06_JPRB,0.23503E-03_JPRB,0.39627E-03_JPRB,0.51132E-03_JPRB,0.51776E-03_JPRB /)  
KB(:, 1,26, 3) = (/ &
 & 0.49718E-06_JPRB,0.13982E-03_JPRB,0.22523E-03_JPRB,0.28275E-03_JPRB,0.30558E-03_JPRB /)  
KB(:, 2,26, 3) = (/ &
 & 0.53365E-06_JPRB,0.15431E-03_JPRB,0.25368E-03_JPRB,0.32044E-03_JPRB,0.33895E-03_JPRB /)  
KB(:, 3,26, 3) = (/ &
 & 0.57705E-06_JPRB,0.16884E-03_JPRB,0.28082E-03_JPRB,0.36019E-03_JPRB,0.37173E-03_JPRB /)  
KB(:, 4,26, 3) = (/ &
 & 0.62061E-06_JPRB,0.18393E-03_JPRB,0.30865E-03_JPRB,0.39866E-03_JPRB,0.40243E-03_JPRB /)  
KB(:, 5,26, 3) = (/ &
 & 0.66427E-06_JPRB,0.19968E-03_JPRB,0.33757E-03_JPRB,0.43663E-03_JPRB,0.43309E-03_JPRB /)  
KB(:, 1,27, 3) = (/ &
 & 0.39961E-06_JPRB,0.11889E-03_JPRB,0.19361E-03_JPRB,0.24270E-03_JPRB,0.25693E-03_JPRB /)  
KB(:, 2,27, 3) = (/ &
 & 0.43136E-06_JPRB,0.13100E-03_JPRB,0.21632E-03_JPRB,0.27591E-03_JPRB,0.28463E-03_JPRB /)  
KB(:, 3,27, 3) = (/ &
 & 0.46490E-06_JPRB,0.14333E-03_JPRB,0.23966E-03_JPRB,0.30849E-03_JPRB,0.31106E-03_JPRB /)  
KB(:, 4,27, 3) = (/ &
 & 0.50009E-06_JPRB,0.15630E-03_JPRB,0.26346E-03_JPRB,0.34083E-03_JPRB,0.33713E-03_JPRB /)  
KB(:, 5,27, 3) = (/ &
 & 0.53808E-06_JPRB,0.16999E-03_JPRB,0.28768E-03_JPRB,0.37323E-03_JPRB,0.36279E-03_JPRB /)  
KB(:, 1,28, 3) = (/ &
 & 0.31986E-06_JPRB,0.10106E-03_JPRB,0.16585E-03_JPRB,0.20891E-03_JPRB,0.21558E-03_JPRB /)  
KB(:, 2,28, 3) = (/ &
 & 0.34540E-06_JPRB,0.11119E-03_JPRB,0.18500E-03_JPRB,0.23760E-03_JPRB,0.23854E-03_JPRB /)  
KB(:, 3,28, 3) = (/ &
 & 0.37226E-06_JPRB,0.12183E-03_JPRB,0.20456E-03_JPRB,0.26419E-03_JPRB,0.26053E-03_JPRB /)  
KB(:, 4,28, 3) = (/ &
 & 0.40317E-06_JPRB,0.13290E-03_JPRB,0.22487E-03_JPRB,0.29156E-03_JPRB,0.28262E-03_JPRB /)  
KB(:, 5,28, 3) = (/ &
 & 0.43271E-06_JPRB,0.14482E-03_JPRB,0.24541E-03_JPRB,0.31934E-03_JPRB,0.30419E-03_JPRB /)  
KB(:, 1,29, 3) = (/ &
 & 0.25677E-06_JPRB,0.86060E-04_JPRB,0.14206E-03_JPRB,0.18023E-03_JPRB,0.18141E-03_JPRB /)  
KB(:, 2,29, 3) = (/ &
 & 0.27736E-06_JPRB,0.94677E-04_JPRB,0.15841E-03_JPRB,0.20378E-03_JPRB,0.20088E-03_JPRB /)  
KB(:, 3,29, 3) = (/ &
 & 0.30104E-06_JPRB,0.10372E-03_JPRB,0.17515E-03_JPRB,0.22663E-03_JPRB,0.21921E-03_JPRB /)  
KB(:, 4,29, 3) = (/ &
 & 0.32584E-06_JPRB,0.11340E-03_JPRB,0.19232E-03_JPRB,0.24953E-03_JPRB,0.23789E-03_JPRB /)  
KB(:, 5,29, 3) = (/ &
 & 0.34891E-06_JPRB,0.12368E-03_JPRB,0.20976E-03_JPRB,0.27364E-03_JPRB,0.25570E-03_JPRB /)  
KB(:, 1,30, 3) = (/ &
 & 0.20556E-06_JPRB,0.73274E-04_JPRB,0.12170E-03_JPRB,0.15588E-03_JPRB,0.15312E-03_JPRB /)  
KB(:, 2,30, 3) = (/ &
 & 0.22376E-06_JPRB,0.80651E-04_JPRB,0.13568E-03_JPRB,0.17524E-03_JPRB,0.16948E-03_JPRB /)  
KB(:, 3,30, 3) = (/ &
 & 0.24313E-06_JPRB,0.88481E-04_JPRB,0.14992E-03_JPRB,0.19447E-03_JPRB,0.18477E-03_JPRB /)  
KB(:, 4,30, 3) = (/ &
 & 0.26233E-06_JPRB,0.96824E-04_JPRB,0.16458E-03_JPRB,0.21409E-03_JPRB,0.20027E-03_JPRB /)  
KB(:, 5,30, 3) = (/ &
 & 0.28249E-06_JPRB,0.10580E-03_JPRB,0.17987E-03_JPRB,0.23435E-03_JPRB,0.21532E-03_JPRB /)  
KB(:, 1,31, 3) = (/ &
 & 0.16553E-06_JPRB,0.62536E-04_JPRB,0.10457E-03_JPRB,0.13443E-03_JPRB,0.12968E-03_JPRB /)  
KB(:, 2,31, 3) = (/ &
 & 0.18078E-06_JPRB,0.68863E-04_JPRB,0.11643E-03_JPRB,0.15060E-03_JPRB,0.14304E-03_JPRB /)  
KB(:, 3,31, 3) = (/ &
 & 0.19619E-06_JPRB,0.75670E-04_JPRB,0.12864E-03_JPRB,0.16681E-03_JPRB,0.15615E-03_JPRB /)  
KB(:, 4,31, 3) = (/ &
 & 0.21158E-06_JPRB,0.82899E-04_JPRB,0.14114E-03_JPRB,0.18385E-03_JPRB,0.16911E-03_JPRB /)  
KB(:, 5,31, 3) = (/ &
 & 0.22915E-06_JPRB,0.90629E-04_JPRB,0.15456E-03_JPRB,0.20099E-03_JPRB,0.18146E-03_JPRB /)  
KB(:, 1,32, 3) = (/ &
 & 0.13380E-06_JPRB,0.53407E-04_JPRB,0.89930E-04_JPRB,0.11591E-03_JPRB,0.11005E-03_JPRB /)  
KB(:, 2,32, 3) = (/ &
 & 0.14604E-06_JPRB,0.58887E-04_JPRB,0.10001E-03_JPRB,0.12963E-03_JPRB,0.12107E-03_JPRB /)  
KB(:, 3,32, 3) = (/ &
 & 0.15848E-06_JPRB,0.64790E-04_JPRB,0.11040E-03_JPRB,0.14349E-03_JPRB,0.13230E-03_JPRB /)  
KB(:, 4,32, 3) = (/ &
 & 0.17190E-06_JPRB,0.71169E-04_JPRB,0.12125E-03_JPRB,0.15792E-03_JPRB,0.14297E-03_JPRB /)  
KB(:, 5,32, 3) = (/ &
 & 0.18587E-06_JPRB,0.77792E-04_JPRB,0.13292E-03_JPRB,0.17265E-03_JPRB,0.15308E-03_JPRB /)  
KB(:, 1,33, 3) = (/ &
 & 0.10830E-06_JPRB,0.45686E-04_JPRB,0.77339E-04_JPRB,0.99867E-04_JPRB,0.93562E-04_JPRB /)  
KB(:, 2,33, 3) = (/ &
 & 0.11765E-06_JPRB,0.50526E-04_JPRB,0.85959E-04_JPRB,0.11153E-03_JPRB,0.10269E-03_JPRB /)  
KB(:, 3,33, 3) = (/ &
 & 0.12824E-06_JPRB,0.55627E-04_JPRB,0.94900E-04_JPRB,0.12354E-03_JPRB,0.11205E-03_JPRB /)  
KB(:, 4,33, 3) = (/ &
 & 0.13958E-06_JPRB,0.61158E-04_JPRB,0.10440E-03_JPRB,0.13573E-03_JPRB,0.12099E-03_JPRB /)  
KB(:, 5,33, 3) = (/ &
 & 0.15078E-06_JPRB,0.66909E-04_JPRB,0.11431E-03_JPRB,0.14861E-03_JPRB,0.12918E-03_JPRB /)  
KB(:, 1,34, 3) = (/ &
 & 0.87537E-07_JPRB,0.39073E-04_JPRB,0.66330E-04_JPRB,0.85860E-04_JPRB,0.79296E-04_JPRB /)  
KB(:, 2,34, 3) = (/ &
 & 0.95270E-07_JPRB,0.43282E-04_JPRB,0.73743E-04_JPRB,0.95733E-04_JPRB,0.87082E-04_JPRB /)  
KB(:, 3,34, 3) = (/ &
 & 0.10423E-06_JPRB,0.47701E-04_JPRB,0.81447E-04_JPRB,0.10609E-03_JPRB,0.94857E-04_JPRB /)  
KB(:, 4,34, 3) = (/ &
 & 0.11348E-06_JPRB,0.52484E-04_JPRB,0.89624E-04_JPRB,0.11638E-03_JPRB,0.10211E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART15',1,ZHOOK_HANDLE)
END SUBROUTINE PART15


SUBROUTINE PART16

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART16',0,ZHOOK_HANDLE)


KB(:, 5,34, 3) = (/ &
 & 0.12289E-06_JPRB,0.57431E-04_JPRB,0.98122E-04_JPRB,0.12760E-03_JPRB,0.10866E-03_JPRB /)  
KB(:, 1,35, 3) = (/ &
 & 0.69891E-07_JPRB,0.33129E-04_JPRB,0.56323E-04_JPRB,0.73036E-04_JPRB,0.66568E-04_JPRB /)  
KB(:, 2,35, 3) = (/ &
 & 0.76465E-07_JPRB,0.36724E-04_JPRB,0.62627E-04_JPRB,0.81520E-04_JPRB,0.73176E-04_JPRB /)  
KB(:, 3,35, 3) = (/ &
 & 0.83833E-07_JPRB,0.40619E-04_JPRB,0.69293E-04_JPRB,0.90161E-04_JPRB,0.79548E-04_JPRB /)  
KB(:, 4,35, 3) = (/ &
 & 0.91436E-07_JPRB,0.44671E-04_JPRB,0.76362E-04_JPRB,0.99075E-04_JPRB,0.85497E-04_JPRB /)  
KB(:, 5,35, 3) = (/ &
 & 0.99263E-07_JPRB,0.48886E-04_JPRB,0.83550E-04_JPRB,0.10849E-03_JPRB,0.90720E-04_JPRB /)  
KB(:, 1,36, 3) = (/ &
 & 0.55080E-07_JPRB,0.27796E-04_JPRB,0.47261E-04_JPRB,0.61299E-04_JPRB,0.55237E-04_JPRB /)  
KB(:, 2,36, 3) = (/ &
 & 0.60562E-07_JPRB,0.30850E-04_JPRB,0.52635E-04_JPRB,0.68515E-04_JPRB,0.60794E-04_JPRB /)  
KB(:, 3,36, 3) = (/ &
 & 0.66440E-07_JPRB,0.34200E-04_JPRB,0.58298E-04_JPRB,0.75847E-04_JPRB,0.66097E-04_JPRB /)  
KB(:, 4,36, 3) = (/ &
 & 0.72913E-07_JPRB,0.37650E-04_JPRB,0.64310E-04_JPRB,0.83530E-04_JPRB,0.71032E-04_JPRB /)  
KB(:, 5,36, 3) = (/ &
 & 0.79545E-07_JPRB,0.41216E-04_JPRB,0.70397E-04_JPRB,0.91304E-04_JPRB,0.75193E-04_JPRB /)  
KB(:, 1,37, 3) = (/ &
 & 0.43644E-07_JPRB,0.22997E-04_JPRB,0.39088E-04_JPRB,0.50714E-04_JPRB,0.45374E-04_JPRB /)  
KB(:, 2,37, 3) = (/ &
 & 0.48182E-07_JPRB,0.25585E-04_JPRB,0.43661E-04_JPRB,0.56813E-04_JPRB,0.50057E-04_JPRB /)  
KB(:, 3,37, 3) = (/ &
 & 0.53067E-07_JPRB,0.28429E-04_JPRB,0.48465E-04_JPRB,0.63020E-04_JPRB,0.54490E-04_JPRB /)  
KB(:, 4,37, 3) = (/ &
 & 0.58349E-07_JPRB,0.31365E-04_JPRB,0.53603E-04_JPRB,0.69516E-04_JPRB,0.58585E-04_JPRB /)  
KB(:, 5,37, 3) = (/ &
 & 0.63727E-07_JPRB,0.34398E-04_JPRB,0.58710E-04_JPRB,0.76032E-04_JPRB,0.62046E-04_JPRB /)  
KB(:, 1,38, 3) = (/ &
 & 0.34661E-07_JPRB,0.19003E-04_JPRB,0.32295E-04_JPRB,0.41898E-04_JPRB,0.37207E-04_JPRB /)  
KB(:, 2,38, 3) = (/ &
 & 0.38414E-07_JPRB,0.21200E-04_JPRB,0.36170E-04_JPRB,0.47045E-04_JPRB,0.41150E-04_JPRB /)  
KB(:, 3,38, 3) = (/ &
 & 0.42378E-07_JPRB,0.23605E-04_JPRB,0.40247E-04_JPRB,0.52306E-04_JPRB,0.44872E-04_JPRB /)  
KB(:, 4,38, 3) = (/ &
 & 0.46598E-07_JPRB,0.26110E-04_JPRB,0.44620E-04_JPRB,0.57800E-04_JPRB,0.48293E-04_JPRB /)  
KB(:, 5,38, 3) = (/ &
 & 0.50995E-07_JPRB,0.28683E-04_JPRB,0.48935E-04_JPRB,0.63250E-04_JPRB,0.51155E-04_JPRB /)  
KB(:, 1,39, 3) = (/ &
 & 0.27545E-07_JPRB,0.15700E-04_JPRB,0.26661E-04_JPRB,0.34603E-04_JPRB,0.30487E-04_JPRB /)  
KB(:, 2,39, 3) = (/ &
 & 0.30553E-07_JPRB,0.17568E-04_JPRB,0.29948E-04_JPRB,0.38935E-04_JPRB,0.33813E-04_JPRB /)  
KB(:, 3,39, 3) = (/ &
 & 0.33772E-07_JPRB,0.19601E-04_JPRB,0.33411E-04_JPRB,0.43403E-04_JPRB,0.36922E-04_JPRB /)  
KB(:, 4,39, 3) = (/ &
 & 0.37164E-07_JPRB,0.21726E-04_JPRB,0.37113E-04_JPRB,0.48030E-04_JPRB,0.39771E-04_JPRB /)  
KB(:, 5,39, 3) = (/ &
 & 0.40795E-07_JPRB,0.23901E-04_JPRB,0.40765E-04_JPRB,0.52607E-04_JPRB,0.42152E-04_JPRB /)  
KB(:, 1,40, 3) = (/ &
 & 0.21852E-07_JPRB,0.12819E-04_JPRB,0.21757E-04_JPRB,0.28221E-04_JPRB,0.24745E-04_JPRB /)  
KB(:, 2,40, 3) = (/ &
 & 0.24207E-07_JPRB,0.14395E-04_JPRB,0.24527E-04_JPRB,0.31867E-04_JPRB,0.27502E-04_JPRB /)  
KB(:, 3,40, 3) = (/ &
 & 0.26806E-07_JPRB,0.16092E-04_JPRB,0.27462E-04_JPRB,0.35646E-04_JPRB,0.30145E-04_JPRB /)  
KB(:, 4,40, 3) = (/ &
 & 0.29612E-07_JPRB,0.17894E-04_JPRB,0.30572E-04_JPRB,0.39527E-04_JPRB,0.32543E-04_JPRB /)  
KB(:, 5,40, 3) = (/ &
 & 0.32577E-07_JPRB,0.19746E-04_JPRB,0.33672E-04_JPRB,0.43399E-04_JPRB,0.34556E-04_JPRB /)  
KB(:, 1,41, 3) = (/ &
 & 0.17336E-07_JPRB,0.10441E-04_JPRB,0.17695E-04_JPRB,0.22954E-04_JPRB,0.20042E-04_JPRB /)  
KB(:, 2,41, 3) = (/ &
 & 0.19187E-07_JPRB,0.11771E-04_JPRB,0.20025E-04_JPRB,0.26029E-04_JPRB,0.22346E-04_JPRB /)  
KB(:, 3,41, 3) = (/ &
 & 0.21311E-07_JPRB,0.13190E-04_JPRB,0.22516E-04_JPRB,0.29201E-04_JPRB,0.24577E-04_JPRB /)  
KB(:, 4,41, 3) = (/ &
 & 0.23597E-07_JPRB,0.14712E-04_JPRB,0.25122E-04_JPRB,0.32466E-04_JPRB,0.26584E-04_JPRB /)  
KB(:, 5,41, 3) = (/ &
 & 0.25958E-07_JPRB,0.16280E-04_JPRB,0.27744E-04_JPRB,0.35762E-04_JPRB,0.28295E-04_JPRB /)  
KB(:, 1,42, 3) = (/ &
 & 0.13752E-07_JPRB,0.84970E-05_JPRB,0.14379E-04_JPRB,0.18640E-04_JPRB,0.16205E-04_JPRB /)  
KB(:, 2,42, 3) = (/ &
 & 0.15240E-07_JPRB,0.96082E-05_JPRB,0.16325E-04_JPRB,0.21225E-04_JPRB,0.18124E-04_JPRB /)  
KB(:, 3,42, 3) = (/ &
 & 0.16924E-07_JPRB,0.10802E-04_JPRB,0.18430E-04_JPRB,0.23896E-04_JPRB,0.20024E-04_JPRB /)  
KB(:, 4,42, 3) = (/ &
 & 0.18767E-07_JPRB,0.12087E-04_JPRB,0.20609E-04_JPRB,0.26651E-04_JPRB,0.21698E-04_JPRB /)  
KB(:, 5,42, 3) = (/ &
 & 0.20666E-07_JPRB,0.13409E-04_JPRB,0.22837E-04_JPRB,0.29427E-04_JPRB,0.23153E-04_JPRB /)  
KB(:, 1,43, 3) = (/ &
 & 0.10827E-07_JPRB,0.68624E-05_JPRB,0.11586E-04_JPRB,0.14999E-04_JPRB,0.12975E-04_JPRB /)  
KB(:, 2,43, 3) = (/ &
 & 0.12030E-07_JPRB,0.77847E-05_JPRB,0.13205E-04_JPRB,0.17164E-04_JPRB,0.14605E-04_JPRB /)  
KB(:, 3,43, 3) = (/ &
 & 0.13352E-07_JPRB,0.87779E-05_JPRB,0.14974E-04_JPRB,0.19410E-04_JPRB,0.16231E-04_JPRB /)  
KB(:, 4,43, 3) = (/ &
 & 0.14829E-07_JPRB,0.98620E-05_JPRB,0.16795E-04_JPRB,0.21751E-04_JPRB,0.17634E-04_JPRB /)  
KB(:, 5,43, 3) = (/ &
 & 0.16396E-07_JPRB,0.10975E-04_JPRB,0.18682E-04_JPRB,0.24066E-04_JPRB,0.18879E-04_JPRB /)  
KB(:, 1,44, 3) = (/ &
 & 0.85731E-08_JPRB,0.55132E-05_JPRB,0.92862E-05_JPRB,0.12000E-04_JPRB,0.10347E-04_JPRB /)  
KB(:, 2,44, 3) = (/ &
 & 0.95033E-08_JPRB,0.62816E-05_JPRB,0.10629E-04_JPRB,0.13817E-04_JPRB,0.11712E-04_JPRB /)  
KB(:, 3,44, 3) = (/ &
 & 0.10537E-07_JPRB,0.70964E-05_JPRB,0.12108E-04_JPRB,0.15700E-04_JPRB,0.13095E-04_JPRB /)  
KB(:, 4,44, 3) = (/ &
 & 0.11722E-07_JPRB,0.80120E-05_JPRB,0.13621E-04_JPRB,0.17679E-04_JPRB,0.14296E-04_JPRB /)  
KB(:, 5,44, 3) = (/ &
 & 0.12991E-07_JPRB,0.89457E-05_JPRB,0.15220E-04_JPRB,0.19614E-04_JPRB,0.15350E-04_JPRB /)  
KB(:, 1,45, 3) = (/ &
 & 0.67515E-08_JPRB,0.44212E-05_JPRB,0.74244E-05_JPRB,0.95776E-05_JPRB,0.82429E-05_JPRB /)  
KB(:, 2,45, 3) = (/ &
 & 0.74999E-08_JPRB,0.50603E-05_JPRB,0.85360E-05_JPRB,0.11095E-04_JPRB,0.93791E-05_JPRB /)  
KB(:, 3,45, 3) = (/ &
 & 0.83182E-08_JPRB,0.57411E-05_JPRB,0.97686E-05_JPRB,0.12667E-04_JPRB,0.10528E-04_JPRB /)  
KB(:, 4,45, 3) = (/ &
 & 0.92526E-08_JPRB,0.64942E-05_JPRB,0.11028E-04_JPRB,0.14328E-04_JPRB,0.11566E-04_JPRB /)  
KB(:, 5,45, 3) = (/ &
 & 0.10269E-07_JPRB,0.72769E-05_JPRB,0.12375E-04_JPRB,0.15964E-04_JPRB,0.12472E-04_JPRB /)  
KB(:, 1,46, 3) = (/ &
 & 0.53031E-08_JPRB,0.35301E-05_JPRB,0.59050E-05_JPRB,0.75965E-05_JPRB,0.65452E-05_JPRB /)  
KB(:, 2,46, 3) = (/ &
 & 0.58907E-08_JPRB,0.40561E-05_JPRB,0.68233E-05_JPRB,0.88621E-05_JPRB,0.74771E-05_JPRB /)  
KB(:, 3,46, 3) = (/ &
 & 0.65422E-08_JPRB,0.46270E-05_JPRB,0.78393E-05_JPRB,0.10169E-04_JPRB,0.84370E-05_JPRB /)  
KB(:, 4,46, 3) = (/ &
 & 0.72669E-08_JPRB,0.52433E-05_JPRB,0.89061E-05_JPRB,0.11563E-04_JPRB,0.93268E-05_JPRB /)  
KB(:, 5,46, 3) = (/ &
 & 0.80880E-08_JPRB,0.58967E-05_JPRB,0.10016E-04_JPRB,0.12930E-04_JPRB,0.10106E-04_JPRB /)  
KB(:, 1,47, 3) = (/ &
 & 0.41459E-08_JPRB,0.27965E-05_JPRB,0.46529E-05_JPRB,0.59648E-05_JPRB,0.51552E-05_JPRB /)  
KB(:, 2,47, 3) = (/ &
 & 0.46324E-08_JPRB,0.32253E-05_JPRB,0.54100E-05_JPRB,0.70094E-05_JPRB,0.59110E-05_JPRB /)  
KB(:, 3,47, 3) = (/ &
 & 0.51433E-08_JPRB,0.37014E-05_JPRB,0.62395E-05_JPRB,0.80976E-05_JPRB,0.67100E-05_JPRB /)  
KB(:, 4,47, 3) = (/ &
 & 0.57045E-08_JPRB,0.42091E-05_JPRB,0.71381E-05_JPRB,0.92537E-05_JPRB,0.74896E-05_JPRB /)  
KB(:, 5,47, 3) = (/ &
 & 0.63526E-08_JPRB,0.47541E-05_JPRB,0.80573E-05_JPRB,0.10428E-04_JPRB,0.81540E-05_JPRB /)  
KB(:, 1,48, 3) = (/ &
 & 0.32549E-08_JPRB,0.22089E-05_JPRB,0.36571E-05_JPRB,0.46663E-05_JPRB,0.40387E-05_JPRB /)  
KB(:, 2,48, 3) = (/ &
 & 0.36192E-08_JPRB,0.25581E-05_JPRB,0.42752E-05_JPRB,0.55265E-05_JPRB,0.46582E-05_JPRB /)  
KB(:, 3,48, 3) = (/ &
 & 0.40215E-08_JPRB,0.29515E-05_JPRB,0.49553E-05_JPRB,0.64327E-05_JPRB,0.53236E-05_JPRB /)  
KB(:, 4,48, 3) = (/ &
 & 0.44736E-08_JPRB,0.33690E-05_JPRB,0.57015E-05_JPRB,0.73859E-05_JPRB,0.59960E-05_JPRB /)  
KB(:, 5,48, 3) = (/ &
 & 0.49760E-08_JPRB,0.38276E-05_JPRB,0.64596E-05_JPRB,0.83844E-05_JPRB,0.65647E-05_JPRB /)  
KB(:, 1,49, 3) = (/ &
 & 0.25432E-08_JPRB,0.17390E-05_JPRB,0.28607E-05_JPRB,0.36438E-05_JPRB,0.31425E-05_JPRB /)  
KB(:, 2,49, 3) = (/ &
 & 0.28364E-08_JPRB,0.20219E-05_JPRB,0.33698E-05_JPRB,0.43412E-05_JPRB,0.36654E-05_JPRB /)  
KB(:, 3,49, 3) = (/ &
 & 0.31601E-08_JPRB,0.23472E-05_JPRB,0.39232E-05_JPRB,0.50964E-05_JPRB,0.42142E-05_JPRB /)  
KB(:, 4,49, 3) = (/ &
 & 0.35101E-08_JPRB,0.26948E-05_JPRB,0.45429E-05_JPRB,0.58797E-05_JPRB,0.47715E-05_JPRB /)  
KB(:, 5,49, 3) = (/ &
 & 0.38989E-08_JPRB,0.30718E-05_JPRB,0.51731E-05_JPRB,0.67190E-05_JPRB,0.52720E-05_JPRB /)  
KB(:, 1,50, 3) = (/ &
 & 0.20093E-08_JPRB,0.13704E-05_JPRB,0.22373E-05_JPRB,0.28375E-05_JPRB,0.24550E-05_JPRB /)  
KB(:, 2,50, 3) = (/ &
 & 0.22270E-08_JPRB,0.16020E-05_JPRB,0.26626E-05_JPRB,0.34144E-05_JPRB,0.28963E-05_JPRB /)  
KB(:, 3,50, 3) = (/ &
 & 0.24797E-08_JPRB,0.18686E-05_JPRB,0.31131E-05_JPRB,0.40348E-05_JPRB,0.33398E-05_JPRB /)  
KB(:, 4,50, 3) = (/ &
 & 0.27614E-08_JPRB,0.21593E-05_JPRB,0.36199E-05_JPRB,0.46856E-05_JPRB,0.38019E-05_JPRB /)  
KB(:, 5,50, 3) = (/ &
 & 0.30674E-08_JPRB,0.24699E-05_JPRB,0.41517E-05_JPRB,0.53844E-05_JPRB,0.42322E-05_JPRB /)  
KB(:, 1,51, 3) = (/ &
 & 0.15907E-08_JPRB,0.10803E-05_JPRB,0.17518E-05_JPRB,0.22064E-05_JPRB,0.19254E-05_JPRB /)  
KB(:, 2,51, 3) = (/ &
 & 0.17509E-08_JPRB,0.12691E-05_JPRB,0.21000E-05_JPRB,0.26794E-05_JPRB,0.22832E-05_JPRB /)  
KB(:, 3,51, 3) = (/ &
 & 0.19509E-08_JPRB,0.14861E-05_JPRB,0.24726E-05_JPRB,0.31957E-05_JPRB,0.26418E-05_JPRB /)  
KB(:, 4,51, 3) = (/ &
 & 0.21703E-08_JPRB,0.17284E-05_JPRB,0.28838E-05_JPRB,0.37325E-05_JPRB,0.30257E-05_JPRB /)  
KB(:, 5,51, 3) = (/ &
 & 0.24124E-08_JPRB,0.19844E-05_JPRB,0.33305E-05_JPRB,0.43128E-05_JPRB,0.34015E-05_JPRB /)  
KB(:, 1,52, 3) = (/ &
 & 0.12564E-08_JPRB,0.84669E-06_JPRB,0.13717E-05_JPRB,0.17147E-05_JPRB,0.14947E-05_JPRB /)  
KB(:, 2,52, 3) = (/ &
 & 0.13794E-08_JPRB,0.10024E-05_JPRB,0.16523E-05_JPRB,0.20993E-05_JPRB,0.17870E-05_JPRB /)  
KB(:, 3,52, 3) = (/ &
 & 0.15320E-08_JPRB,0.11790E-05_JPRB,0.19577E-05_JPRB,0.25220E-05_JPRB,0.20845E-05_JPRB /)  
KB(:, 4,52, 3) = (/ &
 & 0.17130E-08_JPRB,0.13791E-05_JPRB,0.22952E-05_JPRB,0.29677E-05_JPRB,0.24040E-05_JPRB /)  
KB(:, 5,52, 3) = (/ &
 & 0.19041E-08_JPRB,0.15914E-05_JPRB,0.26635E-05_JPRB,0.34439E-05_JPRB,0.27247E-05_JPRB /)  
KB(:, 1,53, 3) = (/ &
 & 0.99523E-09_JPRB,0.66219E-06_JPRB,0.10632E-05_JPRB,0.13341E-05_JPRB,0.11550E-05_JPRB /)  
KB(:, 2,53, 3) = (/ &
 & 0.10903E-08_JPRB,0.79022E-06_JPRB,0.12914E-05_JPRB,0.16401E-05_JPRB,0.13929E-05_JPRB /)  
KB(:, 3,53, 3) = (/ &
 & 0.12082E-08_JPRB,0.93266E-06_JPRB,0.15445E-05_JPRB,0.19841E-05_JPRB,0.16452E-05_JPRB /)  
KB(:, 4,53, 3) = (/ &
 & 0.13437E-08_JPRB,0.10969E-05_JPRB,0.18212E-05_JPRB,0.23517E-05_JPRB,0.19029E-05_JPRB /)  
KB(:, 5,53, 3) = (/ &
 & 0.14972E-08_JPRB,0.12734E-05_JPRB,0.21276E-05_JPRB,0.27431E-05_JPRB,0.21722E-05_JPRB /)  
KB(:, 1,54, 3) = (/ &
 & 0.78782E-09_JPRB,0.51993E-06_JPRB,0.82752E-06_JPRB,0.10421E-05_JPRB,0.88632E-06_JPRB /)  
KB(:, 2,54, 3) = (/ &
 & 0.86642E-09_JPRB,0.62440E-06_JPRB,0.10138E-05_JPRB,0.12820E-05_JPRB,0.10958E-05_JPRB /)  
KB(:, 3,54, 3) = (/ &
 & 0.95141E-09_JPRB,0.74051E-06_JPRB,0.12221E-05_JPRB,0.15626E-05_JPRB,0.13014E-05_JPRB /)  
KB(:, 4,54, 3) = (/ &
 & 0.10622E-08_JPRB,0.87438E-06_JPRB,0.14481E-05_JPRB,0.18675E-05_JPRB,0.15138E-05_JPRB /)  
KB(:, 5,54, 3) = (/ &
 & 0.11829E-08_JPRB,0.10217E-05_JPRB,0.17025E-05_JPRB,0.21900E-05_JPRB,0.17349E-05_JPRB /)  
KB(:, 1,55, 3) = (/ &
 & 0.62734E-09_JPRB,0.40844E-06_JPRB,0.64675E-06_JPRB,0.81168E-06_JPRB,0.68015E-06_JPRB /)  
KB(:, 2,55, 3) = (/ &
 & 0.68670E-09_JPRB,0.49437E-06_JPRB,0.79822E-06_JPRB,0.10031E-05_JPRB,0.85955E-06_JPRB /)  
KB(:, 3,55, 3) = (/ &
 & 0.75551E-09_JPRB,0.58813E-06_JPRB,0.96640E-06_JPRB,0.12305E-05_JPRB,0.10290E-05_JPRB /)  
KB(:, 4,55, 3) = (/ &
 & 0.83896E-09_JPRB,0.69762E-06_JPRB,0.11529E-05_JPRB,0.14845E-05_JPRB,0.12025E-05_JPRB /)  
KB(:, 5,55, 3) = (/ &
 & 0.93727E-09_JPRB,0.81992E-06_JPRB,0.13618E-05_JPRB,0.17489E-05_JPRB,0.13856E-05_JPRB /)  
KB(:, 1,56, 3) = (/ &
 & 0.50214E-09_JPRB,0.32028E-06_JPRB,0.50524E-06_JPRB,0.63147E-06_JPRB,0.51903E-06_JPRB /)  
KB(:, 2,56, 3) = (/ &
 & 0.54775E-09_JPRB,0.38841E-06_JPRB,0.62589E-06_JPRB,0.78445E-06_JPRB,0.67099E-06_JPRB /)  
KB(:, 3,56, 3) = (/ &
 & 0.59971E-09_JPRB,0.46602E-06_JPRB,0.76356E-06_JPRB,0.96978E-06_JPRB,0.80912E-06_JPRB /)  
KB(:, 4,56, 3) = (/ &
 & 0.66466E-09_JPRB,0.55509E-06_JPRB,0.91533E-06_JPRB,0.11766E-05_JPRB,0.95284E-06_JPRB /)  
KB(:, 5,56, 3) = (/ &
 & 0.73931E-09_JPRB,0.65625E-06_JPRB,0.10864E-05_JPRB,0.13946E-05_JPRB,0.11055E-05_JPRB /)  
KB(:, 1,57, 3) = (/ &
 & 0.40171E-09_JPRB,0.25009E-06_JPRB,0.39211E-06_JPRB,0.49250E-06_JPRB,0.39332E-06_JPRB /)  
KB(:, 2,57, 3) = (/ &
 & 0.43379E-09_JPRB,0.30473E-06_JPRB,0.48932E-06_JPRB,0.61342E-06_JPRB,0.52076E-06_JPRB /)  
KB(:, 3,57, 3) = (/ &
 & 0.47729E-09_JPRB,0.36874E-06_JPRB,0.59978E-06_JPRB,0.76246E-06_JPRB,0.63556E-06_JPRB /)  
KB(:, 4,57, 3) = (/ &
 & 0.52454E-09_JPRB,0.44075E-06_JPRB,0.72488E-06_JPRB,0.93079E-06_JPRB,0.75448E-06_JPRB /)  
KB(:, 5,57, 3) = (/ &
 & 0.58546E-09_JPRB,0.52389E-06_JPRB,0.86565E-06_JPRB,0.11107E-05_JPRB,0.87858E-06_JPRB /)  
KB(:, 1,58, 3) = (/ &
 & 0.32222E-09_JPRB,0.19536E-06_JPRB,0.30484E-06_JPRB,0.38123E-06_JPRB,0.29798E-06_JPRB /)  
KB(:, 2,58, 3) = (/ &
 & 0.34550E-09_JPRB,0.24003E-06_JPRB,0.38206E-06_JPRB,0.48033E-06_JPRB,0.40193E-06_JPRB /)  
KB(:, 3,58, 3) = (/ &
 & 0.37930E-09_JPRB,0.29179E-06_JPRB,0.47226E-06_JPRB,0.59938E-06_JPRB,0.50056E-06_JPRB /)  
KB(:, 4,58, 3) = (/ &
 & 0.41675E-09_JPRB,0.35035E-06_JPRB,0.57500E-06_JPRB,0.73642E-06_JPRB,0.59836E-06_JPRB /)  
KB(:, 5,58, 3) = (/ &
 & 0.46320E-09_JPRB,0.41854E-06_JPRB,0.69041E-06_JPRB,0.88548E-06_JPRB,0.70003E-06_JPRB /)  
KB(:, 1,59, 3) = (/ &
 & 0.26166E-09_JPRB,0.15868E-06_JPRB,0.24697E-06_JPRB,0.30892E-06_JPRB,0.23964E-06_JPRB /)  
KB(:, 2,59, 3) = (/ &
 & 0.28095E-09_JPRB,0.19552E-06_JPRB,0.31068E-06_JPRB,0.39037E-06_JPRB,0.32469E-06_JPRB /)  
KB(:, 3,59, 3) = (/ &
 & 0.30730E-09_JPRB,0.23856E-06_JPRB,0.38554E-06_JPRB,0.48902E-06_JPRB,0.40738E-06_JPRB /)  
KB(:, 4,59, 3) = (/ &
 & 0.33781E-09_JPRB,0.28749E-06_JPRB,0.47157E-06_JPRB,0.60286E-06_JPRB,0.48803E-06_JPRB /)  
KB(:, 5,59, 3) = (/ &
 & 0.37526E-09_JPRB,0.34439E-06_JPRB,0.56789E-06_JPRB,0.72742E-06_JPRB,0.57238E-06_JPRB /)  
KB(:, 1,13, 4) = (/ &
 & 0.49038E-04_JPRB,0.50781E-02_JPRB,0.78254E-02_JPRB,0.96484E-02_JPRB,0.10614E-01_JPRB /)  
KB(:, 2,13, 4) = (/ &
 & 0.54225E-04_JPRB,0.54905E-02_JPRB,0.85710E-02_JPRB,0.10460E-01_JPRB,0.11206E-01_JPRB /)  
KB(:, 3,13, 4) = (/ &
 & 0.61134E-04_JPRB,0.58773E-02_JPRB,0.93183E-02_JPRB,0.11347E-01_JPRB,0.11729E-01_JPRB /)  
KB(:, 4,13, 4) = (/ &
 & 0.68793E-04_JPRB,0.62794E-02_JPRB,0.99768E-02_JPRB,0.12248E-01_JPRB,0.12250E-01_JPRB /)  
KB(:, 5,13, 4) = (/ &
 & 0.77429E-04_JPRB,0.66893E-02_JPRB,0.10624E-01_JPRB,0.13064E-01_JPRB,0.12730E-01_JPRB /)  
KB(:, 1,14, 4) = (/ &
 & 0.40706E-04_JPRB,0.43045E-02_JPRB,0.66240E-02_JPRB,0.81227E-02_JPRB,0.87105E-02_JPRB /)  
KB(:, 2,14, 4) = (/ &
 & 0.45789E-04_JPRB,0.46404E-02_JPRB,0.72547E-02_JPRB,0.88508E-02_JPRB,0.92183E-02_JPRB /)  
KB(:, 3,14, 4) = (/ &
 & 0.51359E-04_JPRB,0.49670E-02_JPRB,0.78649E-02_JPRB,0.95928E-02_JPRB,0.96590E-02_JPRB /)  
KB(:, 4,14, 4) = (/ &
 & 0.58448E-04_JPRB,0.53112E-02_JPRB,0.84165E-02_JPRB,0.10356E-01_JPRB,0.10085E-01_JPRB /)  
KB(:, 5,14, 4) = (/ &
 & 0.66585E-04_JPRB,0.56590E-02_JPRB,0.89770E-02_JPRB,0.11022E-01_JPRB,0.10540E-01_JPRB /)  
KB(:, 1,15, 4) = (/ &
 & 0.33161E-04_JPRB,0.36374E-02_JPRB,0.56007E-02_JPRB,0.68408E-02_JPRB,0.70399E-02_JPRB /)  
KB(:, 2,15, 4) = (/ &
 & 0.37316E-04_JPRB,0.39145E-02_JPRB,0.61318E-02_JPRB,0.74812E-02_JPRB,0.74533E-02_JPRB /)  
KB(:, 3,15, 4) = (/ &
 & 0.42184E-04_JPRB,0.41949E-02_JPRB,0.66272E-02_JPRB,0.81097E-02_JPRB,0.78393E-02_JPRB /)  
KB(:, 4,15, 4) = (/ &
 & 0.48249E-04_JPRB,0.44861E-02_JPRB,0.70934E-02_JPRB,0.87330E-02_JPRB,0.82262E-02_JPRB /)  
KB(:, 5,15, 4) = (/ &
 & 0.54912E-04_JPRB,0.47829E-02_JPRB,0.75688E-02_JPRB,0.92830E-02_JPRB,0.86058E-02_JPRB /)  
KB(:, 1,16, 4) = (/ &
 & 0.26598E-04_JPRB,0.30649E-02_JPRB,0.47323E-02_JPRB,0.57742E-02_JPRB,0.56644E-02_JPRB /)  
KB(:, 2,16, 4) = (/ &
 & 0.30096E-04_JPRB,0.32950E-02_JPRB,0.51778E-02_JPRB,0.63145E-02_JPRB,0.60193E-02_JPRB /)  
KB(:, 3,16, 4) = (/ &
 & 0.34085E-04_JPRB,0.35350E-02_JPRB,0.55806E-02_JPRB,0.68447E-02_JPRB,0.63708E-02_JPRB /)  
KB(:, 4,16, 4) = (/ &
 & 0.38919E-04_JPRB,0.37831E-02_JPRB,0.59719E-02_JPRB,0.73465E-02_JPRB,0.67088E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART16',1,ZHOOK_HANDLE)
END SUBROUTINE PART16


SUBROUTINE PART17

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART17',0,ZHOOK_HANDLE)


KB(:, 5,16, 4) = (/ &
 & 0.44492E-04_JPRB,0.40393E-02_JPRB,0.63750E-02_JPRB,0.78120E-02_JPRB,0.70249E-02_JPRB /)  
KB(:, 1,17, 4) = (/ &
 & 0.21449E-04_JPRB,0.25756E-02_JPRB,0.39936E-02_JPRB,0.48662E-02_JPRB,0.46205E-02_JPRB /)  
KB(:, 2,17, 4) = (/ &
 & 0.24103E-04_JPRB,0.27706E-02_JPRB,0.43619E-02_JPRB,0.53164E-02_JPRB,0.49202E-02_JPRB /)  
KB(:, 3,17, 4) = (/ &
 & 0.27451E-04_JPRB,0.29765E-02_JPRB,0.46959E-02_JPRB,0.57632E-02_JPRB,0.52122E-02_JPRB /)  
KB(:, 4,17, 4) = (/ &
 & 0.31381E-04_JPRB,0.31884E-02_JPRB,0.50222E-02_JPRB,0.61735E-02_JPRB,0.54790E-02_JPRB /)  
KB(:, 5,17, 4) = (/ &
 & 0.35953E-04_JPRB,0.34099E-02_JPRB,0.53645E-02_JPRB,0.65659E-02_JPRB,0.57419E-02_JPRB /)  
KB(:, 1,18, 4) = (/ &
 & 0.17468E-04_JPRB,0.21642E-02_JPRB,0.33642E-02_JPRB,0.40972E-02_JPRB,0.37921E-02_JPRB /)  
KB(:, 2,18, 4) = (/ &
 & 0.19506E-04_JPRB,0.23308E-02_JPRB,0.36683E-02_JPRB,0.44696E-02_JPRB,0.40385E-02_JPRB /)  
KB(:, 3,18, 4) = (/ &
 & 0.22326E-04_JPRB,0.25072E-02_JPRB,0.39454E-02_JPRB,0.48507E-02_JPRB,0.42773E-02_JPRB /)  
KB(:, 4,18, 4) = (/ &
 & 0.25558E-04_JPRB,0.26901E-02_JPRB,0.42240E-02_JPRB,0.51855E-02_JPRB,0.45000E-02_JPRB /)  
KB(:, 5,18, 4) = (/ &
 & 0.29519E-04_JPRB,0.28816E-02_JPRB,0.45135E-02_JPRB,0.55168E-02_JPRB,0.47259E-02_JPRB /)  
KB(:, 1,19, 4) = (/ &
 & 0.14162E-04_JPRB,0.18165E-02_JPRB,0.28311E-02_JPRB,0.34491E-02_JPRB,0.31263E-02_JPRB /)  
KB(:, 2,19, 4) = (/ &
 & 0.15880E-04_JPRB,0.19594E-02_JPRB,0.30792E-02_JPRB,0.37577E-02_JPRB,0.33277E-02_JPRB /)  
KB(:, 3,19, 4) = (/ &
 & 0.18250E-04_JPRB,0.21124E-02_JPRB,0.33110E-02_JPRB,0.40717E-02_JPRB,0.35255E-02_JPRB /)  
KB(:, 4,19, 4) = (/ &
 & 0.20948E-04_JPRB,0.22711E-02_JPRB,0.35512E-02_JPRB,0.43541E-02_JPRB,0.37114E-02_JPRB /)  
KB(:, 5,19, 4) = (/ &
 & 0.24279E-04_JPRB,0.24360E-02_JPRB,0.37972E-02_JPRB,0.46336E-02_JPRB,0.39063E-02_JPRB /)  
KB(:, 1,20, 4) = (/ &
 & 0.11677E-04_JPRB,0.15268E-02_JPRB,0.23854E-02_JPRB,0.29054E-02_JPRB,0.25927E-02_JPRB /)  
KB(:, 2,20, 4) = (/ &
 & 0.13127E-04_JPRB,0.16502E-02_JPRB,0.25884E-02_JPRB,0.31642E-02_JPRB,0.27584E-02_JPRB /)  
KB(:, 3,20, 4) = (/ &
 & 0.15145E-04_JPRB,0.17827E-02_JPRB,0.27854E-02_JPRB,0.34198E-02_JPRB,0.29228E-02_JPRB /)  
KB(:, 4,20, 4) = (/ &
 & 0.17426E-04_JPRB,0.19208E-02_JPRB,0.29919E-02_JPRB,0.36563E-02_JPRB,0.30836E-02_JPRB /)  
KB(:, 5,20, 4) = (/ &
 & 0.20187E-04_JPRB,0.20638E-02_JPRB,0.32027E-02_JPRB,0.38955E-02_JPRB,0.32517E-02_JPRB /)  
KB(:, 1,21, 4) = (/ &
 & 0.96248E-05_JPRB,0.12839E-02_JPRB,0.20069E-02_JPRB,0.24439E-02_JPRB,0.21521E-02_JPRB /)  
KB(:, 2,21, 4) = (/ &
 & 0.10884E-04_JPRB,0.13905E-02_JPRB,0.21753E-02_JPRB,0.26634E-02_JPRB,0.22901E-02_JPRB /)  
KB(:, 3,21, 4) = (/ &
 & 0.12576E-04_JPRB,0.15057E-02_JPRB,0.23430E-02_JPRB,0.28714E-02_JPRB,0.24271E-02_JPRB /)  
KB(:, 4,21, 4) = (/ &
 & 0.14492E-04_JPRB,0.16245E-02_JPRB,0.25229E-02_JPRB,0.30709E-02_JPRB,0.25653E-02_JPRB /)  
KB(:, 5,21, 4) = (/ &
 & 0.16785E-04_JPRB,0.17487E-02_JPRB,0.27053E-02_JPRB,0.32769E-02_JPRB,0.27041E-02_JPRB /)  
KB(:, 1,22, 4) = (/ &
 & 0.78987E-05_JPRB,0.10841E-02_JPRB,0.16963E-02_JPRB,0.20646E-02_JPRB,0.17920E-02_JPRB /)  
KB(:, 2,22, 4) = (/ &
 & 0.90688E-05_JPRB,0.11783E-02_JPRB,0.18364E-02_JPRB,0.22523E-02_JPRB,0.19054E-02_JPRB /)  
KB(:, 3,22, 4) = (/ &
 & 0.10436E-04_JPRB,0.12776E-02_JPRB,0.19832E-02_JPRB,0.24220E-02_JPRB,0.20200E-02_JPRB /)  
KB(:, 4,22, 4) = (/ &
 & 0.12051E-04_JPRB,0.13800E-02_JPRB,0.21391E-02_JPRB,0.25904E-02_JPRB,0.21364E-02_JPRB /)  
KB(:, 5,22, 4) = (/ &
 & 0.13992E-04_JPRB,0.14877E-02_JPRB,0.22983E-02_JPRB,0.27690E-02_JPRB,0.22519E-02_JPRB /)  
KB(:, 1,23, 4) = (/ &
 & 0.65143E-05_JPRB,0.91629E-03_JPRB,0.14337E-02_JPRB,0.17468E-02_JPRB,0.14890E-02_JPRB /)  
KB(:, 2,23, 4) = (/ &
 & 0.75295E-05_JPRB,0.99880E-03_JPRB,0.15532E-02_JPRB,0.19017E-02_JPRB,0.15844E-02_JPRB /)  
KB(:, 3,23, 4) = (/ &
 & 0.86172E-05_JPRB,0.10843E-02_JPRB,0.16828E-02_JPRB,0.20454E-02_JPRB,0.16822E-02_JPRB /)  
KB(:, 4,23, 4) = (/ &
 & 0.10017E-04_JPRB,0.11729E-02_JPRB,0.18176E-02_JPRB,0.21912E-02_JPRB,0.17800E-02_JPRB /)  
KB(:, 5,23, 4) = (/ &
 & 0.11640E-04_JPRB,0.12668E-02_JPRB,0.19549E-02_JPRB,0.23447E-02_JPRB,0.18765E-02_JPRB /)  
KB(:, 1,24, 4) = (/ &
 & 0.53432E-05_JPRB,0.77571E-03_JPRB,0.12114E-02_JPRB,0.14805E-02_JPRB,0.12372E-02_JPRB /)  
KB(:, 2,24, 4) = (/ &
 & 0.61515E-05_JPRB,0.84718E-03_JPRB,0.13153E-02_JPRB,0.16078E-02_JPRB,0.13181E-02_JPRB /)  
KB(:, 3,24, 4) = (/ &
 & 0.70923E-05_JPRB,0.92024E-03_JPRB,0.14293E-02_JPRB,0.17300E-02_JPRB,0.13989E-02_JPRB /)  
KB(:, 4,24, 4) = (/ &
 & 0.82684E-05_JPRB,0.99740E-03_JPRB,0.15447E-02_JPRB,0.18573E-02_JPRB,0.14811E-02_JPRB /)  
KB(:, 5,24, 4) = (/ &
 & 0.96268E-05_JPRB,0.10789E-02_JPRB,0.16627E-02_JPRB,0.19892E-02_JPRB,0.15621E-02_JPRB /)  
KB(:, 1,25, 4) = (/ &
 & 0.43932E-05_JPRB,0.65898E-03_JPRB,0.10259E-02_JPRB,0.12568E-02_JPRB,0.10287E-02_JPRB /)  
KB(:, 2,25, 4) = (/ &
 & 0.50483E-05_JPRB,0.71973E-03_JPRB,0.11174E-02_JPRB,0.13610E-02_JPRB,0.10973E-02_JPRB /)  
KB(:, 3,25, 4) = (/ &
 & 0.58527E-05_JPRB,0.78269E-03_JPRB,0.12157E-02_JPRB,0.14658E-02_JPRB,0.11648E-02_JPRB /)  
KB(:, 4,25, 4) = (/ &
 & 0.68258E-05_JPRB,0.84968E-03_JPRB,0.13158E-02_JPRB,0.15774E-02_JPRB,0.12354E-02_JPRB /)  
KB(:, 5,25, 4) = (/ &
 & 0.79780E-05_JPRB,0.92093E-03_JPRB,0.14171E-02_JPRB,0.16917E-02_JPRB,0.13029E-02_JPRB /)  
KB(:, 1,26, 4) = (/ &
 & 0.36349E-05_JPRB,0.56139E-03_JPRB,0.87232E-03_JPRB,0.10671E-02_JPRB,0.85747E-03_JPRB /)  
KB(:, 2,26, 4) = (/ &
 & 0.41763E-05_JPRB,0.61307E-03_JPRB,0.95284E-03_JPRB,0.11559E-02_JPRB,0.91640E-03_JPRB /)  
KB(:, 3,26, 4) = (/ &
 & 0.48643E-05_JPRB,0.66769E-03_JPRB,0.10377E-02_JPRB,0.12480E-02_JPRB,0.97417E-03_JPRB /)  
KB(:, 4,26, 4) = (/ &
 & 0.56806E-05_JPRB,0.72618E-03_JPRB,0.11238E-02_JPRB,0.13443E-02_JPRB,0.10341E-02_JPRB /)  
KB(:, 5,26, 4) = (/ &
 & 0.66574E-05_JPRB,0.78791E-03_JPRB,0.12118E-02_JPRB,0.14426E-02_JPRB,0.10908E-02_JPRB /)  
KB(:, 1,27, 4) = (/ &
 & 0.29849E-05_JPRB,0.47845E-03_JPRB,0.74324E-03_JPRB,0.90695E-03_JPRB,0.71654E-03_JPRB /)  
KB(:, 2,27, 4) = (/ &
 & 0.34528E-05_JPRB,0.52305E-03_JPRB,0.81407E-03_JPRB,0.98348E-03_JPRB,0.76622E-03_JPRB /)  
KB(:, 3,27, 4) = (/ &
 & 0.40386E-05_JPRB,0.57067E-03_JPRB,0.88635E-03_JPRB,0.10643E-02_JPRB,0.81617E-03_JPRB /)  
KB(:, 4,27, 4) = (/ &
 & 0.47349E-05_JPRB,0.62159E-03_JPRB,0.96045E-03_JPRB,0.11476E-02_JPRB,0.86667E-03_JPRB /)  
KB(:, 5,27, 4) = (/ &
 & 0.55504E-05_JPRB,0.67486E-03_JPRB,0.10373E-02_JPRB,0.12327E-02_JPRB,0.91437E-03_JPRB /)  
KB(:, 1,28, 4) = (/ &
 & 0.24474E-05_JPRB,0.40819E-03_JPRB,0.63469E-03_JPRB,0.77184E-03_JPRB,0.59959E-03_JPRB /)  
KB(:, 2,28, 4) = (/ &
 & 0.28527E-05_JPRB,0.44694E-03_JPRB,0.69550E-03_JPRB,0.83809E-03_JPRB,0.64151E-03_JPRB /)  
KB(:, 3,28, 4) = (/ &
 & 0.33444E-05_JPRB,0.48804E-03_JPRB,0.75797E-03_JPRB,0.90921E-03_JPRB,0.68464E-03_JPRB /)  
KB(:, 4,28, 4) = (/ &
 & 0.39332E-05_JPRB,0.53229E-03_JPRB,0.82174E-03_JPRB,0.98103E-03_JPRB,0.72680E-03_JPRB /)  
KB(:, 5,28, 4) = (/ &
 & 0.46245E-05_JPRB,0.57864E-03_JPRB,0.88872E-03_JPRB,0.10544E-02_JPRB,0.76723E-03_JPRB /)  
KB(:, 1,29, 4) = (/ &
 & 0.20253E-05_JPRB,0.34921E-03_JPRB,0.54365E-03_JPRB,0.65865E-03_JPRB,0.50331E-03_JPRB /)  
KB(:, 2,29, 4) = (/ &
 & 0.23720E-05_JPRB,0.38278E-03_JPRB,0.59577E-03_JPRB,0.71729E-03_JPRB,0.53864E-03_JPRB /)  
KB(:, 3,29, 4) = (/ &
 & 0.27945E-05_JPRB,0.41887E-03_JPRB,0.64907E-03_JPRB,0.77823E-03_JPRB,0.57581E-03_JPRB /)  
KB(:, 4,29, 4) = (/ &
 & 0.32936E-05_JPRB,0.45699E-03_JPRB,0.70481E-03_JPRB,0.84074E-03_JPRB,0.61089E-03_JPRB /)  
KB(:, 5,29, 4) = (/ &
 & 0.38881E-05_JPRB,0.49757E-03_JPRB,0.76325E-03_JPRB,0.90356E-03_JPRB,0.64564E-03_JPRB /)  
KB(:, 1,30, 4) = (/ &
 & 0.16797E-05_JPRB,0.29918E-03_JPRB,0.46598E-03_JPRB,0.56316E-03_JPRB,0.42270E-03_JPRB /)  
KB(:, 2,30, 4) = (/ &
 & 0.19764E-05_JPRB,0.32839E-03_JPRB,0.51076E-03_JPRB,0.61439E-03_JPRB,0.45306E-03_JPRB /)  
KB(:, 3,30, 4) = (/ &
 & 0.23384E-05_JPRB,0.35985E-03_JPRB,0.55686E-03_JPRB,0.66712E-03_JPRB,0.48445E-03_JPRB /)  
KB(:, 4,30, 4) = (/ &
 & 0.27662E-05_JPRB,0.39302E-03_JPRB,0.60525E-03_JPRB,0.72092E-03_JPRB,0.51425E-03_JPRB /)  
KB(:, 5,30, 4) = (/ &
 & 0.32687E-05_JPRB,0.42837E-03_JPRB,0.65610E-03_JPRB,0.77570E-03_JPRB,0.54396E-03_JPRB /)  
KB(:, 1,31, 4) = (/ &
 & 0.13991E-05_JPRB,0.25687E-03_JPRB,0.39996E-03_JPRB,0.48307E-03_JPRB,0.35570E-03_JPRB /)  
KB(:, 2,31, 4) = (/ &
 & 0.16564E-05_JPRB,0.28246E-03_JPRB,0.43858E-03_JPRB,0.52743E-03_JPRB,0.38211E-03_JPRB /)  
KB(:, 3,31, 4) = (/ &
 & 0.19660E-05_JPRB,0.30971E-03_JPRB,0.47856E-03_JPRB,0.57309E-03_JPRB,0.40826E-03_JPRB /)  
KB(:, 4,31, 4) = (/ &
 & 0.23334E-05_JPRB,0.33881E-03_JPRB,0.52066E-03_JPRB,0.61919E-03_JPRB,0.43367E-03_JPRB /)  
KB(:, 5,31, 4) = (/ &
 & 0.27587E-05_JPRB,0.36964E-03_JPRB,0.56499E-03_JPRB,0.66660E-03_JPRB,0.45969E-03_JPRB /)  
KB(:, 1,32, 4) = (/ &
 & 0.11711E-05_JPRB,0.22102E-03_JPRB,0.34394E-03_JPRB,0.41512E-03_JPRB,0.29980E-03_JPRB /)  
KB(:, 2,32, 4) = (/ &
 & 0.13928E-05_JPRB,0.24337E-03_JPRB,0.37713E-03_JPRB,0.45351E-03_JPRB,0.32253E-03_JPRB /)  
KB(:, 3,32, 4) = (/ &
 & 0.16589E-05_JPRB,0.26704E-03_JPRB,0.41202E-03_JPRB,0.49272E-03_JPRB,0.34442E-03_JPRB /)  
KB(:, 4,32, 4) = (/ &
 & 0.19740E-05_JPRB,0.29261E-03_JPRB,0.44855E-03_JPRB,0.53274E-03_JPRB,0.36633E-03_JPRB /)  
KB(:, 5,32, 4) = (/ &
 & 0.23323E-05_JPRB,0.31973E-03_JPRB,0.48726E-03_JPRB,0.57383E-03_JPRB,0.38915E-03_JPRB /)  
KB(:, 1,33, 4) = (/ &
 & 0.98300E-06_JPRB,0.19047E-03_JPRB,0.29592E-03_JPRB,0.35739E-03_JPRB,0.25303E-03_JPRB /)  
KB(:, 2,33, 4) = (/ &
 & 0.11751E-05_JPRB,0.20983E-03_JPRB,0.32474E-03_JPRB,0.39043E-03_JPRB,0.27259E-03_JPRB /)  
KB(:, 3,33, 4) = (/ &
 & 0.14027E-05_JPRB,0.23065E-03_JPRB,0.35505E-03_JPRB,0.42405E-03_JPRB,0.29120E-03_JPRB /)  
KB(:, 4,33, 4) = (/ &
 & 0.16692E-05_JPRB,0.25302E-03_JPRB,0.38699E-03_JPRB,0.45888E-03_JPRB,0.31018E-03_JPRB /)  
KB(:, 5,33, 4) = (/ &
 & 0.19716E-05_JPRB,0.27715E-03_JPRB,0.42119E-03_JPRB,0.49468E-03_JPRB,0.32989E-03_JPRB /)  
KB(:, 1,34, 4) = (/ &
 & 0.82915E-06_JPRB,0.16396E-03_JPRB,0.25433E-03_JPRB,0.30700E-03_JPRB,0.21406E-03_JPRB /)  
KB(:, 2,34, 4) = (/ &
 & 0.99352E-06_JPRB,0.18083E-03_JPRB,0.27935E-03_JPRB,0.33552E-03_JPRB,0.23048E-03_JPRB /)  
KB(:, 3,34, 4) = (/ &
 & 0.11877E-05_JPRB,0.19915E-03_JPRB,0.30578E-03_JPRB,0.36455E-03_JPRB,0.24659E-03_JPRB /)  
KB(:, 4,34, 4) = (/ &
 & 0.14139E-05_JPRB,0.21886E-03_JPRB,0.33384E-03_JPRB,0.39476E-03_JPRB,0.26317E-03_JPRB /)  
KB(:, 5,34, 4) = (/ &
 & 0.16670E-05_JPRB,0.24021E-03_JPRB,0.36390E-03_JPRB,0.42603E-03_JPRB,0.28005E-03_JPRB /)  
KB(:, 1,35, 4) = (/ &
 & 0.68670E-06_JPRB,0.13979E-03_JPRB,0.21673E-03_JPRB,0.26161E-03_JPRB,0.17974E-03_JPRB /)  
KB(:, 2,35, 4) = (/ &
 & 0.82437E-06_JPRB,0.15448E-03_JPRB,0.23846E-03_JPRB,0.28611E-03_JPRB,0.19377E-03_JPRB /)  
KB(:, 3,35, 4) = (/ &
 & 0.98649E-06_JPRB,0.17044E-03_JPRB,0.26139E-03_JPRB,0.31132E-03_JPRB,0.20765E-03_JPRB /)  
KB(:, 4,35, 4) = (/ &
 & 0.11740E-05_JPRB,0.18773E-03_JPRB,0.28609E-03_JPRB,0.33740E-03_JPRB,0.22197E-03_JPRB /)  
KB(:, 5,35, 4) = (/ &
 & 0.13833E-05_JPRB,0.20652E-03_JPRB,0.31233E-03_JPRB,0.36449E-03_JPRB,0.23658E-03_JPRB /)  
KB(:, 1,36, 4) = (/ &
 & 0.55564E-06_JPRB,0.11786E-03_JPRB,0.18283E-03_JPRB,0.22089E-03_JPRB,0.14951E-03_JPRB /)  
KB(:, 2,36, 4) = (/ &
 & 0.66731E-06_JPRB,0.13053E-03_JPRB,0.20151E-03_JPRB,0.24189E-03_JPRB,0.16146E-03_JPRB /)  
KB(:, 3,36, 4) = (/ &
 & 0.80048E-06_JPRB,0.14432E-03_JPRB,0.22154E-03_JPRB,0.26364E-03_JPRB,0.17348E-03_JPRB /)  
KB(:, 4,36, 4) = (/ &
 & 0.95195E-06_JPRB,0.15937E-03_JPRB,0.24310E-03_JPRB,0.28609E-03_JPRB,0.18577E-03_JPRB /)  
KB(:, 5,36, 4) = (/ &
 & 0.11217E-05_JPRB,0.17580E-03_JPRB,0.26601E-03_JPRB,0.30949E-03_JPRB,0.19850E-03_JPRB /)  
KB(:, 1,37, 4) = (/ &
 & 0.44526E-06_JPRB,0.98334E-04_JPRB,0.15236E-03_JPRB,0.18395E-03_JPRB,0.12369E-03_JPRB /)  
KB(:, 2,37, 4) = (/ &
 & 0.53551E-06_JPRB,0.10927E-03_JPRB,0.16837E-03_JPRB,0.20194E-03_JPRB,0.13387E-03_JPRB /)  
KB(:, 3,37, 4) = (/ &
 & 0.64307E-06_JPRB,0.12110E-03_JPRB,0.18556E-03_JPRB,0.22059E-03_JPRB,0.14418E-03_JPRB /)  
KB(:, 4,37, 4) = (/ &
 & 0.76688E-06_JPRB,0.13411E-03_JPRB,0.20414E-03_JPRB,0.23985E-03_JPRB,0.15477E-03_JPRB /)  
KB(:, 5,37, 4) = (/ &
 & 0.90591E-06_JPRB,0.14842E-03_JPRB,0.22405E-03_JPRB,0.25996E-03_JPRB,0.16566E-03_JPRB /)  
KB(:, 1,38, 4) = (/ &
 & 0.35630E-06_JPRB,0.81991E-04_JPRB,0.12690E-03_JPRB,0.15312E-03_JPRB,0.10226E-03_JPRB /)  
KB(:, 2,38, 4) = (/ &
 & 0.42911E-06_JPRB,0.91391E-04_JPRB,0.14064E-03_JPRB,0.16849E-03_JPRB,0.11095E-03_JPRB /)  
KB(:, 3,38, 4) = (/ &
 & 0.51583E-06_JPRB,0.10163E-03_JPRB,0.15538E-03_JPRB,0.18448E-03_JPRB,0.11977E-03_JPRB /)  
KB(:, 4,38, 4) = (/ &
 & 0.61654E-06_JPRB,0.11287E-03_JPRB,0.17138E-03_JPRB,0.20101E-03_JPRB,0.12884E-03_JPRB /)  
KB(:, 5,38, 4) = (/ &
 & 0.73028E-06_JPRB,0.12530E-03_JPRB,0.18862E-03_JPRB,0.21826E-03_JPRB,0.13816E-03_JPRB /)  
KB(:, 1,39, 4) = (/ &
 & 0.28455E-06_JPRB,0.68362E-04_JPRB,0.10572E-03_JPRB,0.12747E-03_JPRB,0.84494E-04_JPRB /)  
KB(:, 2,39, 4) = (/ &
 & 0.34313E-06_JPRB,0.76413E-04_JPRB,0.11751E-03_JPRB,0.14060E-03_JPRB,0.91905E-04_JPRB /)  
KB(:, 3,39, 4) = (/ &
 & 0.41305E-06_JPRB,0.85299E-04_JPRB,0.13016E-03_JPRB,0.15431E-03_JPRB,0.99463E-04_JPRB /)  
KB(:, 4,39, 4) = (/ &
 & 0.49466E-06_JPRB,0.95047E-04_JPRB,0.14396E-03_JPRB,0.16851E-03_JPRB,0.10725E-03_JPRB /)  
KB(:, 5,39, 4) = (/ &
 & 0.58721E-06_JPRB,0.10583E-03_JPRB,0.15886E-03_JPRB,0.18332E-03_JPRB,0.11516E-03_JPRB /)  
KB(:, 1,40, 4) = (/ &
 & 0.22416E-06_JPRB,0.56451E-04_JPRB,0.87192E-04_JPRB,0.10503E-03_JPRB,0.69299E-04_JPRB /)  
KB(:, 2,40, 4) = (/ &
 & 0.27058E-06_JPRB,0.63325E-04_JPRB,0.97241E-04_JPRB,0.11625E-03_JPRB,0.75635E-04_JPRB /)  
KB(:, 3,40, 4) = (/ &
 & 0.32640E-06_JPRB,0.70942E-04_JPRB,0.10801E-03_JPRB,0.12792E-03_JPRB,0.82061E-04_JPRB /)  
KB(:, 4,40, 4) = (/ &
 & 0.39178E-06_JPRB,0.79381E-04_JPRB,0.11985E-03_JPRB,0.14005E-03_JPRB,0.88722E-04_JPRB /)  
KB(:, 5,40, 4) = (/ &
 & 0.46694E-06_JPRB,0.88673E-04_JPRB,0.13261E-03_JPRB,0.15274E-03_JPRB,0.95437E-04_JPRB /)  
KB(:, 1,41, 4) = (/ &
 & 0.17620E-06_JPRB,0.46495E-04_JPRB,0.71829E-04_JPRB,0.86351E-04_JPRB,0.56701E-04_JPRB /)  
KB(:, 2,41, 4) = (/ &
 & 0.21295E-06_JPRB,0.52383E-04_JPRB,0.80380E-04_JPRB,0.95937E-04_JPRB,0.62100E-04_JPRB /)  
KB(:, 3,41, 4) = (/ &
 & 0.25720E-06_JPRB,0.58900E-04_JPRB,0.89548E-04_JPRB,0.10594E-03_JPRB,0.67568E-04_JPRB /)  
KB(:, 4,41, 4) = (/ &
 & 0.30957E-06_JPRB,0.66136E-04_JPRB,0.99643E-04_JPRB,0.11623E-03_JPRB,0.73280E-04_JPRB /)  
KB(:, 5,41, 4) = (/ &
 & 0.37003E-06_JPRB,0.74203E-04_JPRB,0.11061E-03_JPRB,0.12707E-03_JPRB,0.78979E-04_JPRB /)  
KB(:, 1,42, 4) = (/ &
 & 0.13843E-06_JPRB,0.38238E-04_JPRB,0.59124E-04_JPRB,0.70982E-04_JPRB,0.46331E-04_JPRB /)  
KB(:, 2,42, 4) = (/ &
 & 0.16726E-06_JPRB,0.43269E-04_JPRB,0.66424E-04_JPRB,0.79125E-04_JPRB,0.50956E-04_JPRB /)  
KB(:, 3,42, 4) = (/ &
 & 0.20232E-06_JPRB,0.48870E-04_JPRB,0.74247E-04_JPRB,0.87661E-04_JPRB,0.55561E-04_JPRB /)  
KB(:, 4,42, 4) = (/ &
 & 0.24408E-06_JPRB,0.55119E-04_JPRB,0.82827E-04_JPRB,0.96453E-04_JPRB,0.60447E-04_JPRB /)  
KB(:, 5,42, 4) = (/ &
 & 0.29276E-06_JPRB,0.62028E-04_JPRB,0.92221E-04_JPRB,0.10570E-03_JPRB,0.65281E-04_JPRB /)  
KB(:, 1,43, 4) = (/ &
 & 0.10793E-06_JPRB,0.31191E-04_JPRB,0.48305E-04_JPRB,0.57948E-04_JPRB,0.37666E-04_JPRB /)  
KB(:, 2,43, 4) = (/ &
 & 0.13017E-06_JPRB,0.35465E-04_JPRB,0.54489E-04_JPRB,0.64841E-04_JPRB,0.41556E-04_JPRB /)  
KB(:, 3,43, 4) = (/ &
 & 0.15771E-06_JPRB,0.40235E-04_JPRB,0.61176E-04_JPRB,0.72082E-04_JPRB,0.45452E-04_JPRB /)  
KB(:, 4,43, 4) = (/ &
 & 0.19064E-06_JPRB,0.45599E-04_JPRB,0.68488E-04_JPRB,0.79576E-04_JPRB,0.49593E-04_JPRB /)  
KB(:, 5,43, 4) = (/ &
 & 0.22944E-06_JPRB,0.51552E-04_JPRB,0.76431E-04_JPRB,0.87462E-04_JPRB,0.53715E-04_JPRB /)  
KB(:, 1,44, 4) = (/ &
 & 0.83879E-07_JPRB,0.25325E-04_JPRB,0.39297E-04_JPRB,0.47118E-04_JPRB,0.30510E-04_JPRB /)  
KB(:, 2,44, 4) = (/ &
 & 0.10087E-06_JPRB,0.28920E-04_JPRB,0.44532E-04_JPRB,0.52929E-04_JPRB,0.33772E-04_JPRB /)  
KB(:, 3,44, 4) = (/ &
 & 0.12238E-06_JPRB,0.32977E-04_JPRB,0.50189E-04_JPRB,0.59075E-04_JPRB,0.37069E-04_JPRB /)  
KB(:, 4,44, 4) = (/ &
 & 0.14813E-06_JPRB,0.37556E-04_JPRB,0.56451E-04_JPRB,0.65448E-04_JPRB,0.40567E-04_JPRB /)  
KB(:, 5,44, 4) = (/ &
 & 0.17874E-06_JPRB,0.42672E-04_JPRB,0.63196E-04_JPRB,0.72159E-04_JPRB,0.44085E-04_JPRB /)  
KB(:, 1,45, 4) = (/ &
 & 0.65261E-07_JPRB,0.20516E-04_JPRB,0.31895E-04_JPRB,0.38279E-04_JPRB,0.24650E-04_JPRB /)  
KB(:, 2,45, 4) = (/ &
 & 0.78145E-07_JPRB,0.23540E-04_JPRB,0.36319E-04_JPRB,0.43161E-04_JPRB,0.27390E-04_JPRB /)  
KB(:, 3,45, 4) = (/ &
 & 0.94805E-07_JPRB,0.26962E-04_JPRB,0.41134E-04_JPRB,0.48357E-04_JPRB,0.30190E-04_JPRB /)  
KB(:, 4,45, 4) = (/ &
 & 0.11490E-06_JPRB,0.30858E-04_JPRB,0.46429E-04_JPRB,0.53785E-04_JPRB,0.33136E-04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART17',1,ZHOOK_HANDLE)
END SUBROUTINE PART17


SUBROUTINE PART18

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART18',0,ZHOOK_HANDLE)


KB(:, 5,45, 4) = (/ &
 & 0.13905E-06_JPRB,0.35210E-04_JPRB,0.52216E-04_JPRB,0.59482E-04_JPRB,0.36122E-04_JPRB /)  
KB(:, 1,46, 4) = (/ &
 & 0.50668E-07_JPRB,0.16526E-04_JPRB,0.25752E-04_JPRB,0.30954E-04_JPRB,0.19817E-04_JPRB /)  
KB(:, 2,46, 4) = (/ &
 & 0.60361E-07_JPRB,0.19058E-04_JPRB,0.29471E-04_JPRB,0.35060E-04_JPRB,0.22123E-04_JPRB /)  
KB(:, 3,46, 4) = (/ &
 & 0.73101E-07_JPRB,0.21937E-04_JPRB,0.33569E-04_JPRB,0.39461E-04_JPRB,0.24498E-04_JPRB /)  
KB(:, 4,46, 4) = (/ &
 & 0.88747E-07_JPRB,0.25222E-04_JPRB,0.38048E-04_JPRB,0.44039E-04_JPRB,0.26973E-04_JPRB /)  
KB(:, 5,46, 4) = (/ &
 & 0.10762E-06_JPRB,0.28932E-04_JPRB,0.42964E-04_JPRB,0.48871E-04_JPRB,0.29499E-04_JPRB /)  
KB(:, 1,47, 4) = (/ &
 & 0.39185E-07_JPRB,0.13207E-04_JPRB,0.20626E-04_JPRB,0.24835E-04_JPRB,0.15826E-04_JPRB /)  
KB(:, 2,47, 4) = (/ &
 & 0.46335E-07_JPRB,0.15303E-04_JPRB,0.23722E-04_JPRB,0.28277E-04_JPRB,0.17762E-04_JPRB /)  
KB(:, 3,47, 4) = (/ &
 & 0.55896E-07_JPRB,0.17703E-04_JPRB,0.27162E-04_JPRB,0.31976E-04_JPRB,0.19780E-04_JPRB /)  
KB(:, 4,47, 4) = (/ &
 & 0.67962E-07_JPRB,0.20451E-04_JPRB,0.30940E-04_JPRB,0.35867E-04_JPRB,0.21834E-04_JPRB /)  
KB(:, 5,47, 4) = (/ &
 & 0.82535E-07_JPRB,0.23583E-04_JPRB,0.35128E-04_JPRB,0.39933E-04_JPRB,0.23972E-04_JPRB /)  
KB(:, 1,48, 4) = (/ &
 & 0.30435E-07_JPRB,0.10528E-04_JPRB,0.16458E-04_JPRB,0.19871E-04_JPRB,0.12630E-04_JPRB /)  
KB(:, 2,48, 4) = (/ &
 & 0.35657E-07_JPRB,0.12255E-04_JPRB,0.19034E-04_JPRB,0.22757E-04_JPRB,0.14230E-04_JPRB /)  
KB(:, 3,48, 4) = (/ &
 & 0.42777E-07_JPRB,0.14241E-04_JPRB,0.21916E-04_JPRB,0.25856E-04_JPRB,0.15916E-04_JPRB /)  
KB(:, 4,48, 4) = (/ &
 & 0.51977E-07_JPRB,0.16531E-04_JPRB,0.25094E-04_JPRB,0.29142E-04_JPRB,0.17632E-04_JPRB /)  
KB(:, 5,48, 4) = (/ &
 & 0.63246E-07_JPRB,0.19162E-04_JPRB,0.28631E-04_JPRB,0.32586E-04_JPRB,0.19447E-04_JPRB /)  
KB(:, 1,49, 4) = (/ &
 & 0.23722E-07_JPRB,0.83656E-05_JPRB,0.13088E-04_JPRB,0.15834E-04_JPRB,0.10060E-04_JPRB /)  
KB(:, 2,49, 4) = (/ &
 & 0.27509E-07_JPRB,0.97869E-05_JPRB,0.15227E-04_JPRB,0.18252E-04_JPRB,0.11363E-04_JPRB /)  
KB(:, 3,49, 4) = (/ &
 & 0.32769E-07_JPRB,0.11426E-04_JPRB,0.17628E-04_JPRB,0.20853E-04_JPRB,0.12767E-04_JPRB /)  
KB(:, 4,49, 4) = (/ &
 & 0.39719E-07_JPRB,0.13326E-04_JPRB,0.20285E-04_JPRB,0.23637E-04_JPRB,0.14223E-04_JPRB /)  
KB(:, 5,49, 4) = (/ &
 & 0.48415E-07_JPRB,0.15524E-04_JPRB,0.23268E-04_JPRB,0.26530E-04_JPRB,0.15739E-04_JPRB /)  
KB(:, 1,50, 4) = (/ &
 & 0.18623E-07_JPRB,0.66620E-05_JPRB,0.10425E-04_JPRB,0.12634E-04_JPRB,0.80132E-05_JPRB /)  
KB(:, 2,50, 4) = (/ &
 & 0.21393E-07_JPRB,0.78264E-05_JPRB,0.12188E-04_JPRB,0.14643E-04_JPRB,0.90757E-05_JPRB /)  
KB(:, 3,50, 4) = (/ &
 & 0.25281E-07_JPRB,0.91787E-05_JPRB,0.14186E-04_JPRB,0.16825E-04_JPRB,0.10247E-04_JPRB /)  
KB(:, 4,50, 4) = (/ &
 & 0.30530E-07_JPRB,0.10758E-04_JPRB,0.16419E-04_JPRB,0.19178E-04_JPRB,0.11482E-04_JPRB /)  
KB(:, 5,50, 4) = (/ &
 & 0.37213E-07_JPRB,0.12593E-04_JPRB,0.18920E-04_JPRB,0.21643E-04_JPRB,0.12749E-04_JPRB /)  
KB(:, 1,51, 4) = (/ &
 & 0.14681E-07_JPRB,0.53043E-05_JPRB,0.82956E-05_JPRB,0.10064E-04_JPRB,0.63669E-05_JPRB /)  
KB(:, 2,51, 4) = (/ &
 & 0.16717E-07_JPRB,0.62508E-05_JPRB,0.97501E-05_JPRB,0.11737E-04_JPRB,0.72473E-05_JPRB /)  
KB(:, 3,51, 4) = (/ &
 & 0.19587E-07_JPRB,0.73643E-05_JPRB,0.11400E-04_JPRB,0.13558E-04_JPRB,0.82290E-05_JPRB /)  
KB(:, 4,51, 4) = (/ &
 & 0.23555E-07_JPRB,0.86748E-05_JPRB,0.13268E-04_JPRB,0.15537E-04_JPRB,0.92634E-05_JPRB /)  
KB(:, 5,51, 4) = (/ &
 & 0.28671E-07_JPRB,0.10209E-04_JPRB,0.15379E-04_JPRB,0.17635E-04_JPRB,0.10316E-04_JPRB /)  
KB(:, 1,52, 4) = (/ &
 & 0.11626E-07_JPRB,0.42149E-05_JPRB,0.65740E-05_JPRB,0.79835E-05_JPRB,0.50595E-05_JPRB /)  
KB(:, 2,52, 4) = (/ &
 & 0.13102E-07_JPRB,0.49884E-05_JPRB,0.77758E-05_JPRB,0.93846E-05_JPRB,0.57856E-05_JPRB /)  
KB(:, 3,52, 4) = (/ &
 & 0.15208E-07_JPRB,0.58955E-05_JPRB,0.91392E-05_JPRB,0.10898E-04_JPRB,0.65937E-05_JPRB /)  
KB(:, 4,52, 4) = (/ &
 & 0.18174E-07_JPRB,0.69758E-05_JPRB,0.10692E-04_JPRB,0.12554E-04_JPRB,0.74564E-05_JPRB /)  
KB(:, 5,52, 4) = (/ &
 & 0.22057E-07_JPRB,0.82505E-05_JPRB,0.12462E-04_JPRB,0.14331E-04_JPRB,0.83301E-05_JPRB /)  
KB(:, 1,53, 4) = (/ &
 & 0.92130E-08_JPRB,0.33378E-05_JPRB,0.51998E-05_JPRB,0.63006E-05_JPRB,0.40097E-05_JPRB /)  
KB(:, 2,53, 4) = (/ &
 & 0.10298E-07_JPRB,0.39704E-05_JPRB,0.61839E-05_JPRB,0.74775E-05_JPRB,0.46077E-05_JPRB /)  
KB(:, 3,53, 4) = (/ &
 & 0.11831E-07_JPRB,0.47088E-05_JPRB,0.73062E-05_JPRB,0.87345E-05_JPRB,0.52620E-05_JPRB /)  
KB(:, 4,53, 4) = (/ &
 & 0.14030E-07_JPRB,0.55942E-05_JPRB,0.85921E-05_JPRB,0.10119E-04_JPRB,0.59838E-05_JPRB /)  
KB(:, 5,53, 4) = (/ &
 & 0.16970E-07_JPRB,0.66447E-05_JPRB,0.10063E-04_JPRB,0.11620E-04_JPRB,0.67208E-05_JPRB /)  
KB(:, 1,54, 4) = (/ &
 & 0.73443E-08_JPRB,0.26498E-05_JPRB,0.41229E-05_JPRB,0.49788E-05_JPRB,0.31929E-05_JPRB /)  
KB(:, 2,54, 4) = (/ &
 & 0.81453E-08_JPRB,0.31689E-05_JPRB,0.49320E-05_JPRB,0.59701E-05_JPRB,0.36706E-05_JPRB /)  
KB(:, 3,54, 4) = (/ &
 & 0.92853E-08_JPRB,0.37746E-05_JPRB,0.58561E-05_JPRB,0.70139E-05_JPRB,0.42105E-05_JPRB /)  
KB(:, 4,54, 4) = (/ &
 & 0.10913E-07_JPRB,0.44986E-05_JPRB,0.69192E-05_JPRB,0.81733E-05_JPRB,0.48081E-05_JPRB /)  
KB(:, 5,54, 4) = (/ &
 & 0.13151E-07_JPRB,0.53689E-05_JPRB,0.81469E-05_JPRB,0.94377E-05_JPRB,0.54320E-05_JPRB /)  
KB(:, 1,55, 4) = (/ &
 & 0.58690E-08_JPRB,0.21056E-05_JPRB,0.32710E-05_JPRB,0.39362E-05_JPRB,0.25357E-05_JPRB /)  
KB(:, 2,55, 4) = (/ &
 & 0.64824E-08_JPRB,0.25292E-05_JPRB,0.39335E-05_JPRB,0.47652E-05_JPRB,0.29266E-05_JPRB /)  
KB(:, 3,55, 4) = (/ &
 & 0.73195E-08_JPRB,0.30260E-05_JPRB,0.46942E-05_JPRB,0.56346E-05_JPRB,0.33700E-05_JPRB /)  
KB(:, 4,55, 4) = (/ &
 & 0.85298E-08_JPRB,0.36216E-05_JPRB,0.55727E-05_JPRB,0.65990E-05_JPRB,0.38662E-05_JPRB /)  
KB(:, 5,55, 4) = (/ &
 & 0.10227E-07_JPRB,0.43366E-05_JPRB,0.65935E-05_JPRB,0.76627E-05_JPRB,0.43889E-05_JPRB /)  
KB(:, 1,56, 4) = (/ &
 & 0.46879E-08_JPRB,0.16674E-05_JPRB,0.25848E-05_JPRB,0.30992E-05_JPRB,0.20097E-05_JPRB /)  
KB(:, 2,56, 4) = (/ &
 & 0.51579E-08_JPRB,0.20145E-05_JPRB,0.31307E-05_JPRB,0.37875E-05_JPRB,0.23304E-05_JPRB /)  
KB(:, 3,56, 4) = (/ &
 & 0.57829E-08_JPRB,0.24199E-05_JPRB,0.37529E-05_JPRB,0.45119E-05_JPRB,0.26962E-05_JPRB /)  
KB(:, 4,56, 4) = (/ &
 & 0.66817E-08_JPRB,0.29092E-05_JPRB,0.44788E-05_JPRB,0.53142E-05_JPRB,0.31037E-05_JPRB /)  
KB(:, 5,56, 4) = (/ &
 & 0.79548E-08_JPRB,0.34985E-05_JPRB,0.53248E-05_JPRB,0.62066E-05_JPRB,0.35387E-05_JPRB /)  
KB(:, 1,57, 4) = (/ &
 & 0.37487E-08_JPRB,0.13177E-05_JPRB,0.20362E-05_JPRB,0.24278E-05_JPRB,0.15888E-05_JPRB /)  
KB(:, 2,57, 4) = (/ &
 & 0.41132E-08_JPRB,0.16006E-05_JPRB,0.24863E-05_JPRB,0.30001E-05_JPRB,0.18530E-05_JPRB /)  
KB(:, 3,57, 4) = (/ &
 & 0.45796E-08_JPRB,0.19301E-05_JPRB,0.29957E-05_JPRB,0.36053E-05_JPRB,0.21515E-05_JPRB /)  
KB(:, 4,57, 4) = (/ &
 & 0.52447E-08_JPRB,0.23301E-05_JPRB,0.35902E-05_JPRB,0.42690E-05_JPRB,0.24844E-05_JPRB /)  
KB(:, 5,57, 4) = (/ &
 & 0.61952E-08_JPRB,0.28175E-05_JPRB,0.42894E-05_JPRB,0.50133E-05_JPRB,0.28503E-05_JPRB /)  
KB(:, 1,58, 4) = (/ &
 & 0.30053E-08_JPRB,0.10419E-05_JPRB,0.16034E-05_JPRB,0.19071E-05_JPRB,0.12550E-05_JPRB /)  
KB(:, 2,58, 4) = (/ &
 & 0.32906E-08_JPRB,0.12717E-05_JPRB,0.19750E-05_JPRB,0.23751E-05_JPRB,0.14761E-05_JPRB /)  
KB(:, 3,58, 4) = (/ &
 & 0.36412E-08_JPRB,0.15413E-05_JPRB,0.23950E-05_JPRB,0.28817E-05_JPRB,0.17173E-05_JPRB /)  
KB(:, 4,58, 4) = (/ &
 & 0.41327E-08_JPRB,0.18673E-05_JPRB,0.28800E-05_JPRB,0.34301E-05_JPRB,0.19893E-05_JPRB /)  
KB(:, 5,58, 4) = (/ &
 & 0.48448E-08_JPRB,0.22699E-05_JPRB,0.34559E-05_JPRB,0.40496E-05_JPRB,0.22938E-05_JPRB /)  
KB(:, 1,59, 4) = (/ &
 & 0.24517E-08_JPRB,0.85367E-06_JPRB,0.13121E-05_JPRB,0.15587E-05_JPRB,0.10209E-05_JPRB /)  
KB(:, 2,59, 4) = (/ &
 & 0.26814E-08_JPRB,0.10459E-05_JPRB,0.16241E-05_JPRB,0.19505E-05_JPRB,0.12067E-05_JPRB /)  
KB(:, 3,59, 4) = (/ &
 & 0.29604E-08_JPRB,0.12726E-05_JPRB,0.19786E-05_JPRB,0.23765E-05_JPRB,0.14071E-05_JPRB /)  
KB(:, 4,59, 4) = (/ &
 & 0.33490E-08_JPRB,0.15486E-05_JPRB,0.23884E-05_JPRB,0.28393E-05_JPRB,0.16353E-05_JPRB /)  
KB(:, 5,59, 4) = (/ &
 & 0.39177E-08_JPRB,0.18923E-05_JPRB,0.28751E-05_JPRB,0.33648E-05_JPRB,0.18896E-05_JPRB /)  
KB(:, 1,13, 5) = (/ &
 & 0.10606E-02_JPRB,0.17616E-01_JPRB,0.26337E-01_JPRB,0.30832E-01_JPRB,0.23250E-01_JPRB /)  
KB(:, 2,13, 5) = (/ &
 & 0.11975E-02_JPRB,0.18851E-01_JPRB,0.27746E-01_JPRB,0.32191E-01_JPRB,0.24461E-01_JPRB /)  
KB(:, 3,13, 5) = (/ &
 & 0.13686E-02_JPRB,0.20236E-01_JPRB,0.29224E-01_JPRB,0.33409E-01_JPRB,0.25538E-01_JPRB /)  
KB(:, 4,13, 5) = (/ &
 & 0.15788E-02_JPRB,0.21686E-01_JPRB,0.30822E-01_JPRB,0.34581E-01_JPRB,0.26483E-01_JPRB /)  
KB(:, 5,13, 5) = (/ &
 & 0.18422E-02_JPRB,0.23201E-01_JPRB,0.32485E-01_JPRB,0.35791E-01_JPRB,0.27339E-01_JPRB /)  
KB(:, 1,14, 5) = (/ &
 & 0.90299E-03_JPRB,0.14939E-01_JPRB,0.22235E-01_JPRB,0.25969E-01_JPRB,0.19459E-01_JPRB /)  
KB(:, 2,14, 5) = (/ &
 & 0.10276E-02_JPRB,0.16043E-01_JPRB,0.23464E-01_JPRB,0.27102E-01_JPRB,0.20418E-01_JPRB /)  
KB(:, 3,14, 5) = (/ &
 & 0.11848E-02_JPRB,0.17244E-01_JPRB,0.24766E-01_JPRB,0.28137E-01_JPRB,0.21279E-01_JPRB /)  
KB(:, 4,14, 5) = (/ &
 & 0.13763E-02_JPRB,0.18494E-01_JPRB,0.26159E-01_JPRB,0.29141E-01_JPRB,0.22035E-01_JPRB /)  
KB(:, 5,14, 5) = (/ &
 & 0.16087E-02_JPRB,0.19801E-01_JPRB,0.27586E-01_JPRB,0.30208E-01_JPRB,0.22712E-01_JPRB /)  
KB(:, 1,15, 5) = (/ &
 & 0.76169E-03_JPRB,0.12657E-01_JPRB,0.18744E-01_JPRB,0.21807E-01_JPRB,0.16155E-01_JPRB /)  
KB(:, 2,15, 5) = (/ &
 & 0.87429E-03_JPRB,0.13622E-01_JPRB,0.19820E-01_JPRB,0.22753E-01_JPRB,0.16908E-01_JPRB /)  
KB(:, 3,15, 5) = (/ &
 & 0.10153E-02_JPRB,0.14650E-01_JPRB,0.20967E-01_JPRB,0.23637E-01_JPRB,0.17597E-01_JPRB /)  
KB(:, 4,15, 5) = (/ &
 & 0.11860E-02_JPRB,0.15728E-01_JPRB,0.22159E-01_JPRB,0.24521E-01_JPRB,0.18236E-01_JPRB /)  
KB(:, 5,15, 5) = (/ &
 & 0.13940E-02_JPRB,0.16855E-01_JPRB,0.23377E-01_JPRB,0.25442E-01_JPRB,0.18800E-01_JPRB /)  
KB(:, 1,16, 5) = (/ &
 & 0.63979E-03_JPRB,0.10716E-01_JPRB,0.15782E-01_JPRB,0.18280E-01_JPRB,0.13330E-01_JPRB /)  
KB(:, 2,16, 5) = (/ &
 & 0.73992E-03_JPRB,0.11550E-01_JPRB,0.16721E-01_JPRB,0.19074E-01_JPRB,0.13955E-01_JPRB /)  
KB(:, 3,16, 5) = (/ &
 & 0.86535E-03_JPRB,0.12432E-01_JPRB,0.17715E-01_JPRB,0.19835E-01_JPRB,0.14519E-01_JPRB /)  
KB(:, 4,16, 5) = (/ &
 & 0.10180E-02_JPRB,0.13358E-01_JPRB,0.18733E-01_JPRB,0.20612E-01_JPRB,0.15053E-01_JPRB /)  
KB(:, 5,16, 5) = (/ &
 & 0.12020E-02_JPRB,0.14330E-01_JPRB,0.19780E-01_JPRB,0.21390E-01_JPRB,0.15523E-01_JPRB /)  
KB(:, 1,17, 5) = (/ &
 & 0.53827E-03_JPRB,0.90675E-02_JPRB,0.13282E-01_JPRB,0.15310E-01_JPRB,0.11002E-01_JPRB /)  
KB(:, 2,17, 5) = (/ &
 & 0.62733E-03_JPRB,0.97818E-02_JPRB,0.14093E-01_JPRB,0.15985E-01_JPRB,0.11517E-01_JPRB /)  
KB(:, 3,17, 5) = (/ &
 & 0.73894E-03_JPRB,0.10536E-01_JPRB,0.14937E-01_JPRB,0.16642E-01_JPRB,0.11982E-01_JPRB /)  
KB(:, 4,17, 5) = (/ &
 & 0.87471E-03_JPRB,0.11329E-01_JPRB,0.15813E-01_JPRB,0.17308E-01_JPRB,0.12431E-01_JPRB /)  
KB(:, 5,17, 5) = (/ &
 & 0.10369E-02_JPRB,0.12167E-01_JPRB,0.16717E-01_JPRB,0.17966E-01_JPRB,0.12833E-01_JPRB /)  
KB(:, 1,18, 5) = (/ &
 & 0.45632E-03_JPRB,0.76631E-02_JPRB,0.11175E-01_JPRB,0.12821E-01_JPRB,0.91007E-02_JPRB /)  
KB(:, 2,18, 5) = (/ &
 & 0.53618E-03_JPRB,0.82741E-02_JPRB,0.11867E-01_JPRB,0.13402E-01_JPRB,0.95284E-02_JPRB /)  
KB(:, 3,18, 5) = (/ &
 & 0.63520E-03_JPRB,0.89179E-02_JPRB,0.12591E-01_JPRB,0.13960E-01_JPRB,0.99227E-02_JPRB /)  
KB(:, 4,18, 5) = (/ &
 & 0.75513E-03_JPRB,0.95966E-02_JPRB,0.13345E-01_JPRB,0.14529E-01_JPRB,0.10294E-01_JPRB /)  
KB(:, 5,18, 5) = (/ &
 & 0.89828E-03_JPRB,0.10325E-01_JPRB,0.14127E-01_JPRB,0.15082E-01_JPRB,0.10637E-01_JPRB /)  
KB(:, 1,19, 5) = (/ &
 & 0.38782E-03_JPRB,0.64686E-02_JPRB,0.93947E-02_JPRB,0.10738E-01_JPRB,0.75366E-02_JPRB /)  
KB(:, 2,19, 5) = (/ &
 & 0.45826E-03_JPRB,0.69872E-02_JPRB,0.99878E-02_JPRB,0.11230E-01_JPRB,0.78920E-02_JPRB /)  
KB(:, 3,19, 5) = (/ &
 & 0.54544E-03_JPRB,0.75386E-02_JPRB,0.10613E-01_JPRB,0.11706E-01_JPRB,0.82219E-02_JPRB /)  
KB(:, 4,19, 5) = (/ &
 & 0.65085E-03_JPRB,0.81243E-02_JPRB,0.11261E-01_JPRB,0.12183E-01_JPRB,0.85447E-02_JPRB /)  
KB(:, 5,19, 5) = (/ &
 & 0.77601E-03_JPRB,0.87598E-02_JPRB,0.11933E-01_JPRB,0.12660E-01_JPRB,0.88388E-02_JPRB /)  
KB(:, 1,20, 5) = (/ &
 & 0.33304E-03_JPRB,0.54623E-02_JPRB,0.79028E-02_JPRB,0.89960E-02_JPRB,0.62635E-02_JPRB /)  
KB(:, 2,20, 5) = (/ &
 & 0.39553E-03_JPRB,0.59055E-02_JPRB,0.84155E-02_JPRB,0.94111E-02_JPRB,0.65613E-02_JPRB /)  
KB(:, 3,20, 5) = (/ &
 & 0.47180E-03_JPRB,0.63779E-02_JPRB,0.89500E-02_JPRB,0.98172E-02_JPRB,0.68459E-02_JPRB /)  
KB(:, 4,20, 5) = (/ &
 & 0.56453E-03_JPRB,0.68862E-02_JPRB,0.95048E-02_JPRB,0.10225E-01_JPRB,0.71246E-02_JPRB /)  
KB(:, 5,20, 5) = (/ &
 & 0.67486E-03_JPRB,0.74411E-02_JPRB,0.10082E-01_JPRB,0.10637E-01_JPRB,0.73786E-02_JPRB /)  
KB(:, 1,21, 5) = (/ &
 & 0.28693E-03_JPRB,0.46180E-02_JPRB,0.66504E-02_JPRB,0.75379E-02_JPRB,0.52071E-02_JPRB /)  
KB(:, 2,21, 5) = (/ &
 & 0.34180E-03_JPRB,0.49948E-02_JPRB,0.70898E-02_JPRB,0.78866E-02_JPRB,0.54645E-02_JPRB /)  
KB(:, 3,21, 5) = (/ &
 & 0.40811E-03_JPRB,0.54006E-02_JPRB,0.75474E-02_JPRB,0.82331E-02_JPRB,0.57127E-02_JPRB /)  
KB(:, 4,21, 5) = (/ &
 & 0.48873E-03_JPRB,0.58434E-02_JPRB,0.80212E-02_JPRB,0.85844E-02_JPRB,0.59470E-02_JPRB /)  
KB(:, 5,21, 5) = (/ &
 & 0.58593E-03_JPRB,0.63260E-02_JPRB,0.85182E-02_JPRB,0.89408E-02_JPRB,0.61662E-02_JPRB /)  
KB(:, 1,22, 5) = (/ &
 & 0.24974E-03_JPRB,0.39240E-02_JPRB,0.56208E-02_JPRB,0.63345E-02_JPRB,0.43431E-02_JPRB /)  
KB(:, 2,22, 5) = (/ &
 & 0.29749E-03_JPRB,0.42526E-02_JPRB,0.59996E-02_JPRB,0.66266E-02_JPRB,0.45624E-02_JPRB /)  
KB(:, 3,22, 5) = (/ &
 & 0.35608E-03_JPRB,0.46047E-02_JPRB,0.63919E-02_JPRB,0.69259E-02_JPRB,0.47738E-02_JPRB /)  
KB(:, 4,22, 5) = (/ &
 & 0.42699E-03_JPRB,0.49920E-02_JPRB,0.67993E-02_JPRB,0.72276E-02_JPRB,0.49714E-02_JPRB /)  
KB(:, 5,22, 5) = (/ &
 & 0.51198E-03_JPRB,0.54166E-02_JPRB,0.72302E-02_JPRB,0.75387E-02_JPRB,0.51660E-02_JPRB /)  
KB(:, 1,23, 5) = (/ &
 & 0.21716E-03_JPRB,0.33375E-02_JPRB,0.47528E-02_JPRB,0.53238E-02_JPRB,0.36258E-02_JPRB /)  
KB(:, 2,23, 5) = (/ &
 & 0.25886E-03_JPRB,0.36243E-02_JPRB,0.50797E-02_JPRB,0.55740E-02_JPRB,0.38107E-02_JPRB /)  
KB(:, 3,23, 5) = (/ &
 & 0.31026E-03_JPRB,0.39353E-02_JPRB,0.54169E-02_JPRB,0.58309E-02_JPRB,0.39876E-02_JPRB /)  
KB(:, 4,23, 5) = (/ &
 & 0.37235E-03_JPRB,0.42757E-02_JPRB,0.57711E-02_JPRB,0.60911E-02_JPRB,0.41586E-02_JPRB /)  
KB(:, 5,23, 5) = (/ &
 & 0.44568E-03_JPRB,0.46463E-02_JPRB,0.61476E-02_JPRB,0.63633E-02_JPRB,0.43277E-02_JPRB /)  
KB(:, 1,24, 5) = (/ &
 & 0.18738E-03_JPRB,0.28412E-02_JPRB,0.40251E-02_JPRB,0.44754E-02_JPRB,0.30232E-02_JPRB /)  
KB(:, 2,24, 5) = (/ &
 & 0.22422E-03_JPRB,0.30930E-02_JPRB,0.43062E-02_JPRB,0.46921E-02_JPRB,0.31788E-02_JPRB /)  
KB(:, 3,24, 5) = (/ &
 & 0.26942E-03_JPRB,0.33694E-02_JPRB,0.45983E-02_JPRB,0.49126E-02_JPRB,0.33287E-02_JPRB /)  
KB(:, 4,24, 5) = (/ &
 & 0.32317E-03_JPRB,0.36702E-02_JPRB,0.49092E-02_JPRB,0.51393E-02_JPRB,0.34771E-02_JPRB /)  
KB(:, 5,24, 5) = (/ &
 & 0.38638E-03_JPRB,0.39951E-02_JPRB,0.52385E-02_JPRB,0.53815E-02_JPRB,0.36232E-02_JPRB /)  
KB(:, 1,25, 5) = (/ &
 & 0.16224E-03_JPRB,0.24232E-02_JPRB,0.34141E-02_JPRB,0.37661E-02_JPRB,0.25262E-02_JPRB /)  
KB(:, 2,25, 5) = (/ &
 & 0.19465E-03_JPRB,0.26463E-02_JPRB,0.36575E-02_JPRB,0.39541E-02_JPRB,0.26577E-02_JPRB /)  
KB(:, 3,25, 5) = (/ &
 & 0.23391E-03_JPRB,0.28936E-02_JPRB,0.39130E-02_JPRB,0.41446E-02_JPRB,0.27841E-02_JPRB /)  
KB(:, 4,25, 5) = (/ &
 & 0.28044E-03_JPRB,0.31598E-02_JPRB,0.41853E-02_JPRB,0.43442E-02_JPRB,0.29098E-02_JPRB /)  
KB(:, 5,25, 5) = (/ &
 & 0.33483E-03_JPRB,0.34437E-02_JPRB,0.44735E-02_JPRB,0.45625E-02_JPRB,0.30351E-02_JPRB /)  
KB(:, 1,26, 5) = (/ &
 & 0.14132E-03_JPRB,0.20737E-02_JPRB,0.29036E-02_JPRB,0.31762E-02_JPRB,0.21157E-02_JPRB /)  
KB(:, 2,26, 5) = (/ &
 & 0.16977E-03_JPRB,0.22743E-02_JPRB,0.31152E-02_JPRB,0.33382E-02_JPRB,0.22258E-02_JPRB /)  
KB(:, 3,26, 5) = (/ &
 & 0.20409E-03_JPRB,0.24947E-02_JPRB,0.33401E-02_JPRB,0.35048E-02_JPRB,0.23338E-02_JPRB /)  
KB(:, 4,26, 5) = (/ &
 & 0.24472E-03_JPRB,0.27297E-02_JPRB,0.35798E-02_JPRB,0.36835E-02_JPRB,0.24421E-02_JPRB /)  
KB(:, 5,26, 5) = (/ &
 & 0.29131E-03_JPRB,0.29804E-02_JPRB,0.38308E-02_JPRB,0.38797E-02_JPRB,0.25500E-02_JPRB /)  
KB(:, 1,27, 5) = (/ &
 & 0.12293E-03_JPRB,0.17797E-02_JPRB,0.24725E-02_JPRB,0.26822E-02_JPRB,0.17718E-02_JPRB /)  
KB(:, 2,27, 5) = (/ &
 & 0.14789E-03_JPRB,0.19595E-02_JPRB,0.26584E-02_JPRB,0.28222E-02_JPRB,0.18655E-02_JPRB /)  
KB(:, 3,27, 5) = (/ &
 & 0.17790E-03_JPRB,0.21552E-02_JPRB,0.28584E-02_JPRB,0.29695E-02_JPRB,0.19589E-02_JPRB /)  
KB(:, 4,27, 5) = (/ &
 & 0.21315E-03_JPRB,0.23624E-02_JPRB,0.30688E-02_JPRB,0.31309E-02_JPRB,0.20520E-02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART18',1,ZHOOK_HANDLE)
END SUBROUTINE PART18


SUBROUTINE PART19

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART19',0,ZHOOK_HANDLE)


KB(:, 5,27, 5) = (/ &
 & 0.25285E-03_JPRB,0.25825E-02_JPRB,0.32876E-02_JPRB,0.33068E-02_JPRB,0.21445E-02_JPRB /)  
KB(:, 1,28, 5) = (/ &
 & 0.10657E-03_JPRB,0.15319E-02_JPRB,0.21096E-02_JPRB,0.22678E-02_JPRB,0.14844E-02_JPRB /)  
KB(:, 2,28, 5) = (/ &
 & 0.12856E-03_JPRB,0.16920E-02_JPRB,0.22743E-02_JPRB,0.23899E-02_JPRB,0.15639E-02_JPRB /)  
KB(:, 3,28, 5) = (/ &
 & 0.15471E-03_JPRB,0.18636E-02_JPRB,0.24511E-02_JPRB,0.25221E-02_JPRB,0.16436E-02_JPRB /)  
KB(:, 4,28, 5) = (/ &
 & 0.18512E-03_JPRB,0.20472E-02_JPRB,0.26364E-02_JPRB,0.26681E-02_JPRB,0.17238E-02_JPRB /)  
KB(:, 5,28, 5) = (/ &
 & 0.21872E-03_JPRB,0.22411E-02_JPRB,0.28270E-02_JPRB,0.28260E-02_JPRB,0.18048E-02_JPRB /)  
KB(:, 1,29, 5) = (/ &
 & 0.92876E-04_JPRB,0.13237E-02_JPRB,0.18049E-02_JPRB,0.19214E-02_JPRB,0.12471E-02_JPRB /)  
KB(:, 2,29, 5) = (/ &
 & 0.11226E-03_JPRB,0.14659E-02_JPRB,0.19518E-02_JPRB,0.20295E-02_JPRB,0.13143E-02_JPRB /)  
KB(:, 3,29, 5) = (/ &
 & 0.13519E-03_JPRB,0.16171E-02_JPRB,0.21089E-02_JPRB,0.21498E-02_JPRB,0.13833E-02_JPRB /)  
KB(:, 4,29, 5) = (/ &
 & 0.16102E-03_JPRB,0.17778E-02_JPRB,0.22703E-02_JPRB,0.22810E-02_JPRB,0.14528E-02_JPRB /)  
KB(:, 5,29, 5) = (/ &
 & 0.18981E-03_JPRB,0.19484E-02_JPRB,0.24374E-02_JPRB,0.24249E-02_JPRB,0.15236E-02_JPRB /)  
KB(:, 1,30, 5) = (/ &
 & 0.80828E-04_JPRB,0.11471E-02_JPRB,0.15486E-02_JPRB,0.16307E-02_JPRB,0.10482E-02_JPRB /)  
KB(:, 2,30, 5) = (/ &
 & 0.98063E-04_JPRB,0.12718E-02_JPRB,0.16797E-02_JPRB,0.17287E-02_JPRB,0.11053E-02_JPRB /)  
KB(:, 3,30, 5) = (/ &
 & 0.11772E-03_JPRB,0.14050E-02_JPRB,0.18177E-02_JPRB,0.18379E-02_JPRB,0.11648E-02_JPRB /)  
KB(:, 4,30, 5) = (/ &
 & 0.13981E-03_JPRB,0.15469E-02_JPRB,0.19589E-02_JPRB,0.19565E-02_JPRB,0.12258E-02_JPRB /)  
KB(:, 5,30, 5) = (/ &
 & 0.16446E-03_JPRB,0.16947E-02_JPRB,0.21055E-02_JPRB,0.20874E-02_JPRB,0.12885E-02_JPRB /)  
KB(:, 1,31, 5) = (/ &
 & 0.70539E-04_JPRB,0.99621E-03_JPRB,0.13325E-02_JPRB,0.13879E-02_JPRB,0.88220E-03_JPRB /)  
KB(:, 2,31, 5) = (/ &
 & 0.85589E-04_JPRB,0.11063E-02_JPRB,0.14492E-02_JPRB,0.14776E-02_JPRB,0.93113E-03_JPRB /)  
KB(:, 3,31, 5) = (/ &
 & 0.10244E-03_JPRB,0.12240E-02_JPRB,0.15701E-02_JPRB,0.15764E-02_JPRB,0.98237E-03_JPRB /)  
KB(:, 4,31, 5) = (/ &
 & 0.12151E-03_JPRB,0.13488E-02_JPRB,0.16942E-02_JPRB,0.16846E-02_JPRB,0.10364E-02_JPRB /)  
KB(:, 5,31, 5) = (/ &
 & 0.14245E-03_JPRB,0.14753E-02_JPRB,0.18229E-02_JPRB,0.18042E-02_JPRB,0.10910E-02_JPRB /)  
KB(:, 1,32, 5) = (/ &
 & 0.61598E-04_JPRB,0.86708E-03_JPRB,0.11506E-02_JPRB,0.11857E-02_JPRB,0.74396E-03_JPRB /)  
KB(:, 2,32, 5) = (/ &
 & 0.74698E-04_JPRB,0.96443E-03_JPRB,0.12533E-02_JPRB,0.12673E-02_JPRB,0.78590E-03_JPRB /)  
KB(:, 3,32, 5) = (/ &
 & 0.89092E-04_JPRB,0.10684E-02_JPRB,0.13590E-02_JPRB,0.13571E-02_JPRB,0.83090E-03_JPRB /)  
KB(:, 4,32, 5) = (/ &
 & 0.10537E-03_JPRB,0.11766E-02_JPRB,0.14682E-02_JPRB,0.14560E-02_JPRB,0.87827E-03_JPRB /)  
KB(:, 5,32, 5) = (/ &
 & 0.12327E-03_JPRB,0.12850E-02_JPRB,0.15813E-02_JPRB,0.15643E-02_JPRB,0.92599E-03_JPRB /)  
KB(:, 1,33, 5) = (/ &
 & 0.53748E-04_JPRB,0.75629E-03_JPRB,0.99595E-03_JPRB,0.10163E-02_JPRB,0.62809E-03_JPRB /)  
KB(:, 2,33, 5) = (/ &
 & 0.64972E-04_JPRB,0.84265E-03_JPRB,0.10856E-02_JPRB,0.10908E-02_JPRB,0.66416E-03_JPRB /)  
KB(:, 3,33, 5) = (/ &
 & 0.77386E-04_JPRB,0.93397E-03_JPRB,0.11787E-02_JPRB,0.11727E-02_JPRB,0.70387E-03_JPRB /)  
KB(:, 4,33, 5) = (/ &
 & 0.91138E-04_JPRB,0.10266E-02_JPRB,0.12749E-02_JPRB,0.12630E-02_JPRB,0.74507E-03_JPRB /)  
KB(:, 5,33, 5) = (/ &
 & 0.10640E-03_JPRB,0.11189E-02_JPRB,0.13738E-02_JPRB,0.13608E-02_JPRB,0.78830E-03_JPRB /)  
KB(:, 1,34, 5) = (/ &
 & 0.46667E-04_JPRB,0.65884E-03_JPRB,0.86049E-03_JPRB,0.87214E-03_JPRB,0.53099E-03_JPRB /)  
KB(:, 2,34, 5) = (/ &
 & 0.56263E-04_JPRB,0.73490E-03_JPRB,0.93900E-03_JPRB,0.93946E-03_JPRB,0.56278E-03_JPRB /)  
KB(:, 3,34, 5) = (/ &
 & 0.66853E-04_JPRB,0.81383E-03_JPRB,0.10209E-02_JPRB,0.10142E-02_JPRB,0.59776E-03_JPRB /)  
KB(:, 4,34, 5) = (/ &
 & 0.78598E-04_JPRB,0.89314E-03_JPRB,0.11054E-02_JPRB,0.10963E-02_JPRB,0.63419E-03_JPRB /)  
KB(:, 5,34, 5) = (/ &
 & 0.91503E-04_JPRB,0.97193E-03_JPRB,0.11927E-02_JPRB,0.11840E-02_JPRB,0.67320E-03_JPRB /)  
KB(:, 1,35, 5) = (/ &
 & 0.39599E-04_JPRB,0.56866E-03_JPRB,0.73803E-03_JPRB,0.74491E-03_JPRB,0.44688E-03_JPRB /)  
KB(:, 2,35, 5) = (/ &
 & 0.47677E-04_JPRB,0.63490E-03_JPRB,0.80685E-03_JPRB,0.80540E-03_JPRB,0.47466E-03_JPRB /)  
KB(:, 3,35, 5) = (/ &
 & 0.56630E-04_JPRB,0.70279E-03_JPRB,0.87860E-03_JPRB,0.87332E-03_JPRB,0.50476E-03_JPRB /)  
KB(:, 4,35, 5) = (/ &
 & 0.66506E-04_JPRB,0.77061E-03_JPRB,0.95262E-03_JPRB,0.94676E-03_JPRB,0.53730E-03_JPRB /)  
KB(:, 5,35, 5) = (/ &
 & 0.77343E-04_JPRB,0.83870E-03_JPRB,0.10295E-02_JPRB,0.10250E-02_JPRB,0.57200E-03_JPRB /)  
KB(:, 1,36, 5) = (/ &
 & 0.32767E-04_JPRB,0.48523E-03_JPRB,0.62751E-03_JPRB,0.63183E-03_JPRB,0.37353E-03_JPRB /)  
KB(:, 2,36, 5) = (/ &
 & 0.39450E-04_JPRB,0.54261E-03_JPRB,0.68744E-03_JPRB,0.68587E-03_JPRB,0.39744E-03_JPRB /)  
KB(:, 3,36, 5) = (/ &
 & 0.46861E-04_JPRB,0.60093E-03_JPRB,0.74977E-03_JPRB,0.74623E-03_JPRB,0.42315E-03_JPRB /)  
KB(:, 4,36, 5) = (/ &
 & 0.54956E-04_JPRB,0.65916E-03_JPRB,0.81469E-03_JPRB,0.81158E-03_JPRB,0.45144E-03_JPRB /)  
KB(:, 5,36, 5) = (/ &
 & 0.63908E-04_JPRB,0.71820E-03_JPRB,0.88212E-03_JPRB,0.88103E-03_JPRB,0.48165E-03_JPRB /)  
KB(:, 1,37, 5) = (/ &
 & 0.26734E-04_JPRB,0.40754E-03_JPRB,0.52645E-03_JPRB,0.53014E-03_JPRB,0.31118E-03_JPRB /)  
KB(:, 2,37, 5) = (/ &
 & 0.32273E-04_JPRB,0.45661E-03_JPRB,0.57825E-03_JPRB,0.57766E-03_JPRB,0.33206E-03_JPRB /)  
KB(:, 3,37, 5) = (/ &
 & 0.38488E-04_JPRB,0.50697E-03_JPRB,0.63245E-03_JPRB,0.63058E-03_JPRB,0.35476E-03_JPRB /)  
KB(:, 4,37, 5) = (/ &
 & 0.45228E-04_JPRB,0.55706E-03_JPRB,0.68918E-03_JPRB,0.68809E-03_JPRB,0.37944E-03_JPRB /)  
KB(:, 5,37, 5) = (/ &
 & 0.52675E-04_JPRB,0.60808E-03_JPRB,0.74794E-03_JPRB,0.74934E-03_JPRB,0.40598E-03_JPRB /)  
KB(:, 1,38, 5) = (/ &
 & 0.21751E-04_JPRB,0.34209E-03_JPRB,0.44146E-03_JPRB,0.44458E-03_JPRB,0.25920E-03_JPRB /)  
KB(:, 2,38, 5) = (/ &
 & 0.26326E-04_JPRB,0.38415E-03_JPRB,0.48603E-03_JPRB,0.48632E-03_JPRB,0.27730E-03_JPRB /)  
KB(:, 3,38, 5) = (/ &
 & 0.31515E-04_JPRB,0.42736E-03_JPRB,0.53325E-03_JPRB,0.53262E-03_JPRB,0.29714E-03_JPRB /)  
KB(:, 4,38, 5) = (/ &
 & 0.37219E-04_JPRB,0.47064E-03_JPRB,0.58263E-03_JPRB,0.58321E-03_JPRB,0.31890E-03_JPRB /)  
KB(:, 5,38, 5) = (/ &
 & 0.43344E-04_JPRB,0.51493E-03_JPRB,0.63402E-03_JPRB,0.63729E-03_JPRB,0.34212E-03_JPRB /)  
KB(:, 1,39, 5) = (/ &
 & 0.17643E-04_JPRB,0.28717E-03_JPRB,0.37020E-03_JPRB,0.37288E-03_JPRB,0.21580E-03_JPRB /)  
KB(:, 2,39, 5) = (/ &
 & 0.21418E-04_JPRB,0.32343E-03_JPRB,0.40871E-03_JPRB,0.40953E-03_JPRB,0.23151E-03_JPRB /)  
KB(:, 3,39, 5) = (/ &
 & 0.25725E-04_JPRB,0.36044E-03_JPRB,0.44966E-03_JPRB,0.45005E-03_JPRB,0.24880E-03_JPRB /)  
KB(:, 4,39, 5) = (/ &
 & 0.30479E-04_JPRB,0.39785E-03_JPRB,0.49263E-03_JPRB,0.49445E-03_JPRB,0.26783E-03_JPRB /)  
KB(:, 5,39, 5) = (/ &
 & 0.35653E-04_JPRB,0.43646E-03_JPRB,0.53771E-03_JPRB,0.54230E-03_JPRB,0.28822E-03_JPRB /)  
KB(:, 1,40, 5) = (/ &
 & 0.14102E-04_JPRB,0.23814E-03_JPRB,0.30730E-03_JPRB,0.30981E-03_JPRB,0.17864E-03_JPRB /)  
KB(:, 2,40, 5) = (/ &
 & 0.17187E-04_JPRB,0.26934E-03_JPRB,0.34039E-03_JPRB,0.34146E-03_JPRB,0.19234E-03_JPRB /)  
KB(:, 3,40, 5) = (/ &
 & 0.20739E-04_JPRB,0.30130E-03_JPRB,0.37571E-03_JPRB,0.37672E-03_JPRB,0.20737E-03_JPRB /)  
KB(:, 4,40, 5) = (/ &
 & 0.24670E-04_JPRB,0.33333E-03_JPRB,0.41283E-03_JPRB,0.41538E-03_JPRB,0.22408E-03_JPRB /)  
KB(:, 5,40, 5) = (/ &
 & 0.29046E-04_JPRB,0.36694E-03_JPRB,0.45216E-03_JPRB,0.45729E-03_JPRB,0.24187E-03_JPRB /)  
KB(:, 1,41, 5) = (/ &
 & 0.11221E-04_JPRB,0.19710E-03_JPRB,0.25465E-03_JPRB,0.25696E-03_JPRB,0.14773E-03_JPRB /)  
KB(:, 2,41, 5) = (/ &
 & 0.13747E-04_JPRB,0.22390E-03_JPRB,0.28305E-03_JPRB,0.28413E-03_JPRB,0.15955E-03_JPRB /)  
KB(:, 3,41, 5) = (/ &
 & 0.16649E-04_JPRB,0.25145E-03_JPRB,0.31346E-03_JPRB,0.31467E-03_JPRB,0.17269E-03_JPRB /)  
KB(:, 4,41, 5) = (/ &
 & 0.19899E-04_JPRB,0.27935E-03_JPRB,0.34563E-03_JPRB,0.34845E-03_JPRB,0.18718E-03_JPRB /)  
KB(:, 5,41, 5) = (/ &
 & 0.23568E-04_JPRB,0.30830E-03_JPRB,0.37974E-03_JPRB,0.38512E-03_JPRB,0.20281E-03_JPRB /)  
KB(:, 1,42, 5) = (/ &
 & 0.89147E-05_JPRB,0.16314E-03_JPRB,0.21088E-03_JPRB,0.21294E-03_JPRB,0.12205E-03_JPRB /)  
KB(:, 2,42, 5) = (/ &
 & 0.10957E-04_JPRB,0.18596E-03_JPRB,0.23523E-03_JPRB,0.23628E-03_JPRB,0.13225E-03_JPRB /)  
KB(:, 3,42, 5) = (/ &
 & 0.13327E-04_JPRB,0.20974E-03_JPRB,0.26134E-03_JPRB,0.26263E-03_JPRB,0.14356E-03_JPRB /)  
KB(:, 4,42, 5) = (/ &
 & 0.16005E-04_JPRB,0.23378E-03_JPRB,0.28925E-03_JPRB,0.29202E-03_JPRB,0.15621E-03_JPRB /)  
KB(:, 5,42, 5) = (/ &
 & 0.19038E-04_JPRB,0.25914E-03_JPRB,0.31897E-03_JPRB,0.32415E-03_JPRB,0.16982E-03_JPRB /)  
KB(:, 1,43, 5) = (/ &
 & 0.69995E-05_JPRB,0.13405E-03_JPRB,0.17338E-03_JPRB,0.17535E-03_JPRB,0.10036E-03_JPRB /)  
KB(:, 2,43, 5) = (/ &
 & 0.86406E-05_JPRB,0.15345E-03_JPRB,0.19416E-03_JPRB,0.19514E-03_JPRB,0.10910E-03_JPRB /)  
KB(:, 3,43, 5) = (/ &
 & 0.10556E-04_JPRB,0.17373E-03_JPRB,0.21659E-03_JPRB,0.21767E-03_JPRB,0.11887E-03_JPRB /)  
KB(:, 4,43, 5) = (/ &
 & 0.12739E-04_JPRB,0.19445E-03_JPRB,0.24053E-03_JPRB,0.24311E-03_JPRB,0.12980E-03_JPRB /)  
KB(:, 5,43, 5) = (/ &
 & 0.15232E-04_JPRB,0.21640E-03_JPRB,0.26645E-03_JPRB,0.27107E-03_JPRB,0.14169E-03_JPRB /)  
KB(:, 1,44, 5) = (/ &
 & 0.54712E-05_JPRB,0.10970E-03_JPRB,0.14195E-03_JPRB,0.14386E-03_JPRB,0.82260E-04_JPRB /)  
KB(:, 2,44, 5) = (/ &
 & 0.67644E-05_JPRB,0.12612E-03_JPRB,0.15963E-03_JPRB,0.16061E-03_JPRB,0.89727E-04_JPRB /)  
KB(:, 3,44, 5) = (/ &
 & 0.82973E-05_JPRB,0.14348E-03_JPRB,0.17878E-03_JPRB,0.17975E-03_JPRB,0.98122E-04_JPRB /)  
KB(:, 4,44, 5) = (/ &
 & 0.10082E-04_JPRB,0.16132E-03_JPRB,0.19952E-03_JPRB,0.20155E-03_JPRB,0.10755E-03_JPRB /)  
KB(:, 5,44, 5) = (/ &
 & 0.12107E-04_JPRB,0.18008E-03_JPRB,0.22179E-03_JPRB,0.22576E-03_JPRB,0.11787E-03_JPRB /)  
KB(:, 1,45, 5) = (/ &
 & 0.42767E-05_JPRB,0.89680E-04_JPRB,0.11611E-03_JPRB,0.11781E-03_JPRB,0.67338E-04_JPRB /)  
KB(:, 2,45, 5) = (/ &
 & 0.52860E-05_JPRB,0.10360E-03_JPRB,0.13107E-03_JPRB,0.13203E-03_JPRB,0.73722E-04_JPRB /)  
KB(:, 3,45, 5) = (/ &
 & 0.65107E-05_JPRB,0.11838E-03_JPRB,0.14735E-03_JPRB,0.14829E-03_JPRB,0.80852E-04_JPRB /)  
KB(:, 4,45, 5) = (/ &
 & 0.79501E-05_JPRB,0.13374E-03_JPRB,0.16520E-03_JPRB,0.16693E-03_JPRB,0.88969E-04_JPRB /)  
KB(:, 5,45, 5) = (/ &
 & 0.95937E-05_JPRB,0.14993E-03_JPRB,0.18456E-03_JPRB,0.18781E-03_JPRB,0.97897E-04_JPRB /)  
KB(:, 1,46, 5) = (/ &
 & 0.33226E-05_JPRB,0.72918E-04_JPRB,0.94635E-04_JPRB,0.96069E-04_JPRB,0.54912E-04_JPRB /)  
KB(:, 2,46, 5) = (/ &
 & 0.41185E-05_JPRB,0.84705E-04_JPRB,0.10726E-03_JPRB,0.10809E-03_JPRB,0.60325E-04_JPRB /)  
KB(:, 3,46, 5) = (/ &
 & 0.50796E-05_JPRB,0.97414E-04_JPRB,0.12106E-03_JPRB,0.12184E-03_JPRB,0.66415E-04_JPRB /)  
KB(:, 4,46, 5) = (/ &
 & 0.62311E-05_JPRB,0.11055E-03_JPRB,0.13625E-03_JPRB,0.13772E-03_JPRB,0.73354E-04_JPRB /)  
KB(:, 5,46, 5) = (/ &
 & 0.75594E-05_JPRB,0.12439E-03_JPRB,0.15297E-03_JPRB,0.15569E-03_JPRB,0.80972E-04_JPRB /)  
KB(:, 1,47, 5) = (/ &
 & 0.25507E-05_JPRB,0.58753E-04_JPRB,0.76599E-04_JPRB,0.77798E-04_JPRB,0.44508E-04_JPRB /)  
KB(:, 2,47, 5) = (/ &
 & 0.31800E-05_JPRB,0.68679E-04_JPRB,0.87240E-04_JPRB,0.87843E-04_JPRB,0.49115E-04_JPRB /)  
KB(:, 3,47, 5) = (/ &
 & 0.39273E-05_JPRB,0.79497E-04_JPRB,0.98871E-04_JPRB,0.99421E-04_JPRB,0.54249E-04_JPRB /)  
KB(:, 4,47, 5) = (/ &
 & 0.48346E-05_JPRB,0.90782E-04_JPRB,0.11173E-03_JPRB,0.11282E-03_JPRB,0.60113E-04_JPRB /)  
KB(:, 5,47, 5) = (/ &
 & 0.58995E-05_JPRB,0.10267E-03_JPRB,0.12592E-03_JPRB,0.12815E-03_JPRB,0.66656E-04_JPRB /)  
KB(:, 1,48, 5) = (/ &
 & 0.19539E-05_JPRB,0.47174E-04_JPRB,0.61874E-04_JPRB,0.62916E-04_JPRB,0.35973E-04_JPRB /)  
KB(:, 2,48, 5) = (/ &
 & 0.24452E-05_JPRB,0.55575E-04_JPRB,0.70853E-04_JPRB,0.71238E-04_JPRB,0.39898E-04_JPRB /)  
KB(:, 3,48, 5) = (/ &
 & 0.30402E-05_JPRB,0.64783E-04_JPRB,0.80633E-04_JPRB,0.80921E-04_JPRB,0.44214E-04_JPRB /)  
KB(:, 4,48, 5) = (/ &
 & 0.37390E-05_JPRB,0.74439E-04_JPRB,0.91498E-04_JPRB,0.92208E-04_JPRB,0.49162E-04_JPRB /)  
KB(:, 5,48, 5) = (/ &
 & 0.45836E-05_JPRB,0.84608E-04_JPRB,0.10358E-03_JPRB,0.10531E-03_JPRB,0.54702E-04_JPRB /)  
KB(:, 1,49, 5) = (/ &
 & 0.14940E-05_JPRB,0.37716E-04_JPRB,0.49829E-04_JPRB,0.50804E-04_JPRB,0.28987E-04_JPRB /)  
KB(:, 2,49, 5) = (/ &
 & 0.18758E-05_JPRB,0.44777E-04_JPRB,0.57392E-04_JPRB,0.57697E-04_JPRB,0.32317E-04_JPRB /)  
KB(:, 3,49, 5) = (/ &
 & 0.23413E-05_JPRB,0.52604E-04_JPRB,0.65608E-04_JPRB,0.65748E-04_JPRB,0.35946E-04_JPRB /)  
KB(:, 4,49, 5) = (/ &
 & 0.28961E-05_JPRB,0.60891E-04_JPRB,0.74824E-04_JPRB,0.75182E-04_JPRB,0.40099E-04_JPRB /)  
KB(:, 5,49, 5) = (/ &
 & 0.35524E-05_JPRB,0.69587E-04_JPRB,0.85068E-04_JPRB,0.86295E-04_JPRB,0.44804E-04_JPRB /)  
KB(:, 1,50, 5) = (/ &
 & 0.11500E-05_JPRB,0.30169E-04_JPRB,0.40157E-04_JPRB,0.41069E-04_JPRB,0.23362E-04_JPRB /)  
KB(:, 2,50, 5) = (/ &
 & 0.14453E-05_JPRB,0.36089E-04_JPRB,0.46549E-04_JPRB,0.46799E-04_JPRB,0.26193E-04_JPRB /)  
KB(:, 3,50, 5) = (/ &
 & 0.18129E-05_JPRB,0.42735E-04_JPRB,0.53474E-04_JPRB,0.53514E-04_JPRB,0.29249E-04_JPRB /)  
KB(:, 4,50, 5) = (/ &
 & 0.22529E-05_JPRB,0.49843E-04_JPRB,0.61234E-04_JPRB,0.61404E-04_JPRB,0.32748E-04_JPRB /)  
KB(:, 5,50, 5) = (/ &
 & 0.27762E-05_JPRB,0.57328E-04_JPRB,0.70027E-04_JPRB,0.70783E-04_JPRB,0.36712E-04_JPRB /)  
KB(:, 1,51, 5) = (/ &
 & 0.88851E-06_JPRB,0.24095E-04_JPRB,0.32303E-04_JPRB,0.33210E-04_JPRB,0.18805E-04_JPRB /)  
KB(:, 2,51, 5) = (/ &
 & 0.11177E-05_JPRB,0.29082E-04_JPRB,0.37705E-04_JPRB,0.37944E-04_JPRB,0.21209E-04_JPRB /)  
KB(:, 3,51, 5) = (/ &
 & 0.14060E-05_JPRB,0.34667E-04_JPRB,0.43578E-04_JPRB,0.43570E-04_JPRB,0.23792E-04_JPRB /)  
KB(:, 4,51, 5) = (/ &
 & 0.17539E-05_JPRB,0.40739E-04_JPRB,0.50114E-04_JPRB,0.50172E-04_JPRB,0.26720E-04_JPRB /)  
KB(:, 5,51, 5) = (/ &
 & 0.21729E-05_JPRB,0.47224E-04_JPRB,0.57598E-04_JPRB,0.58070E-04_JPRB,0.30079E-04_JPRB /)  
KB(:, 1,52, 5) = (/ &
 & 0.68525E-06_JPRB,0.19178E-04_JPRB,0.25896E-04_JPRB,0.26809E-04_JPRB,0.15097E-04_JPRB /)  
KB(:, 2,52, 5) = (/ &
 & 0.86301E-06_JPRB,0.23336E-04_JPRB,0.30434E-04_JPRB,0.30713E-04_JPRB,0.17120E-04_JPRB /)  
KB(:, 3,52, 5) = (/ &
 & 0.10889E-05_JPRB,0.28028E-04_JPRB,0.35422E-04_JPRB,0.35397E-04_JPRB,0.19301E-04_JPRB /)  
KB(:, 4,52, 5) = (/ &
 & 0.13649E-05_JPRB,0.33187E-04_JPRB,0.40954E-04_JPRB,0.40921E-04_JPRB,0.21752E-04_JPRB /)  
KB(:, 5,52, 5) = (/ &
 & 0.16982E-05_JPRB,0.38747E-04_JPRB,0.47260E-04_JPRB,0.47557E-04_JPRB,0.24588E-04_JPRB /)  
KB(:, 1,53, 5) = (/ &
 & 0.52809E-06_JPRB,0.15206E-04_JPRB,0.20688E-04_JPRB,0.21592E-04_JPRB,0.12084E-04_JPRB /)  
KB(:, 2,53, 5) = (/ &
 & 0.66493E-06_JPRB,0.18647E-04_JPRB,0.24479E-04_JPRB,0.24819E-04_JPRB,0.13781E-04_JPRB /)  
KB(:, 3,53, 5) = (/ &
 & 0.84102E-06_JPRB,0.22574E-04_JPRB,0.28683E-04_JPRB,0.28690E-04_JPRB,0.15621E-04_JPRB /)  
KB(:, 4,53, 5) = (/ &
 & 0.10585E-05_JPRB,0.26955E-04_JPRB,0.33364E-04_JPRB,0.33298E-04_JPRB,0.17677E-04_JPRB /)  
KB(:, 5,53, 5) = (/ &
 & 0.13239E-05_JPRB,0.31710E-04_JPRB,0.38733E-04_JPRB,0.38864E-04_JPRB,0.20049E-04_JPRB /)  
KB(:, 1,54, 5) = (/ &
 & 0.40969E-06_JPRB,0.12093E-04_JPRB,0.16564E-04_JPRB,0.17421E-04_JPRB,0.96882E-05_JPRB /)  
KB(:, 2,54, 5) = (/ &
 & 0.51569E-06_JPRB,0.14937E-04_JPRB,0.19734E-04_JPRB,0.20094E-04_JPRB,0.11112E-04_JPRB /)  
KB(:, 3,54, 5) = (/ &
 & 0.65296E-06_JPRB,0.18229E-04_JPRB,0.23282E-04_JPRB,0.23321E-04_JPRB,0.12664E-04_JPRB /)  
KB(:, 4,54, 5) = (/ &
 & 0.82573E-06_JPRB,0.21950E-04_JPRB,0.27231E-04_JPRB,0.27150E-04_JPRB,0.14393E-04_JPRB /)  
KB(:, 5,54, 5) = (/ &
 & 0.10373E-05_JPRB,0.26013E-04_JPRB,0.31791E-04_JPRB,0.31828E-04_JPRB,0.16379E-04_JPRB /)  
KB(:, 1,55, 5) = (/ &
 & 0.31928E-06_JPRB,0.96162E-05_JPRB,0.13257E-04_JPRB,0.14053E-04_JPRB,0.77741E-05_JPRB /)  
KB(:, 2,55, 5) = (/ &
 & 0.40112E-06_JPRB,0.11963E-04_JPRB,0.15906E-04_JPRB,0.16257E-04_JPRB,0.89578E-05_JPRB /)  
KB(:, 3,55, 5) = (/ &
 & 0.50816E-06_JPRB,0.14717E-04_JPRB,0.18886E-04_JPRB,0.18947E-04_JPRB,0.10262E-04_JPRB /)  
KB(:, 4,55, 5) = (/ &
 & 0.64465E-06_JPRB,0.17864E-04_JPRB,0.22207E-04_JPRB,0.22155E-04_JPRB,0.11715E-04_JPRB /)  
KB(:, 5,55, 5) = (/ &
 & 0.81328E-06_JPRB,0.21326E-04_JPRB,0.26076E-04_JPRB,0.26061E-04_JPRB,0.13376E-04_JPRB /)  
KB(:, 1,56, 5) = (/ &
 & 0.24829E-06_JPRB,0.76204E-05_JPRB,0.10578E-04_JPRB,0.11309E-04_JPRB,0.62208E-05_JPRB /)  
KB(:, 2,56, 5) = (/ &
 & 0.31176E-06_JPRB,0.95488E-05_JPRB,0.12780E-04_JPRB,0.13125E-04_JPRB,0.72013E-05_JPRB /)  
KB(:, 3,56, 5) = (/ &
 & 0.39506E-06_JPRB,0.11850E-04_JPRB,0.15279E-04_JPRB,0.15348E-04_JPRB,0.82947E-05_JPRB /)  
KB(:, 4,56, 5) = (/ &
 & 0.50266E-06_JPRB,0.14492E-04_JPRB,0.18074E-04_JPRB,0.18040E-04_JPRB,0.95153E-05_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART19',1,ZHOOK_HANDLE)
END SUBROUTINE PART19


SUBROUTINE PART20

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART20',0,ZHOOK_HANDLE)


KB(:, 5,56, 5) = (/ &
 & 0.63638E-06_JPRB,0.17442E-04_JPRB,0.21336E-04_JPRB,0.21310E-04_JPRB,0.10904E-04_JPRB /)  
KB(:, 1,57, 5) = (/ &
 & 0.19302E-06_JPRB,0.60187E-05_JPRB,0.84162E-05_JPRB,0.90799E-05_JPRB,0.49649E-05_JPRB /)  
KB(:, 2,57, 5) = (/ &
 & 0.24222E-06_JPRB,0.75959E-05_JPRB,0.10233E-04_JPRB,0.10570E-04_JPRB,0.57701E-05_JPRB /)  
KB(:, 3,57, 5) = (/ &
 & 0.30688E-06_JPRB,0.95080E-05_JPRB,0.12318E-04_JPRB,0.12403E-04_JPRB,0.66913E-05_JPRB /)  
KB(:, 4,57, 5) = (/ &
 & 0.39089E-06_JPRB,0.11719E-04_JPRB,0.14670E-04_JPRB,0.14644E-04_JPRB,0.77166E-05_JPRB /)  
KB(:, 5,57, 5) = (/ &
 & 0.49674E-06_JPRB,0.14214E-04_JPRB,0.17402E-04_JPRB,0.17382E-04_JPRB,0.88727E-05_JPRB /)  
KB(:, 1,58, 5) = (/ &
 & 0.15046E-06_JPRB,0.47663E-05_JPRB,0.66998E-05_JPRB,0.72908E-05_JPRB,0.39631E-05_JPRB /)  
KB(:, 2,58, 5) = (/ &
 & 0.18856E-06_JPRB,0.60459E-05_JPRB,0.81908E-05_JPRB,0.85206E-05_JPRB,0.46270E-05_JPRB /)  
KB(:, 3,58, 5) = (/ &
 & 0.23869E-06_JPRB,0.76302E-05_JPRB,0.99245E-05_JPRB,0.10023E-04_JPRB,0.53977E-05_JPRB /)  
KB(:, 4,58, 5) = (/ &
 & 0.30459E-06_JPRB,0.94767E-05_JPRB,0.11911E-04_JPRB,0.11894E-04_JPRB,0.62579E-05_JPRB /)  
KB(:, 5,58, 5) = (/ &
 & 0.38820E-06_JPRB,0.11588E-04_JPRB,0.14205E-04_JPRB,0.14182E-04_JPRB,0.72226E-05_JPRB /)  
KB(:, 1,59, 5) = (/ &
 & 0.12212E-06_JPRB,0.39332E-05_JPRB,0.55230E-05_JPRB,0.60094E-05_JPRB,0.32499E-05_JPRB /)  
KB(:, 2,59, 5) = (/ &
 & 0.15324E-06_JPRB,0.50178E-05_JPRB,0.67879E-05_JPRB,0.70566E-05_JPRB,0.38108E-05_JPRB /)  
KB(:, 3,59, 5) = (/ &
 & 0.19418E-06_JPRB,0.63678E-05_JPRB,0.82647E-05_JPRB,0.83443E-05_JPRB,0.44672E-05_JPRB /)  
KB(:, 4,59, 5) = (/ &
 & 0.24820E-06_JPRB,0.79543E-05_JPRB,0.99670E-05_JPRB,0.99518E-05_JPRB,0.52027E-05_JPRB /)  
KB(:, 5,59, 5) = (/ &
 & 0.31740E-06_JPRB,0.97704E-05_JPRB,0.11964E-04_JPRB,0.11938E-04_JPRB,0.60278E-05_JPRB /)  
KB(:, 1,13, 6) = (/ &
 & 0.10896E-01_JPRB,0.63076E-01_JPRB,0.78831E-01_JPRB,0.78091E-01_JPRB,0.55428E-01_JPRB /)  
KB(:, 2,13, 6) = (/ &
 & 0.13036E-01_JPRB,0.66370E-01_JPRB,0.81226E-01_JPRB,0.79692E-01_JPRB,0.56778E-01_JPRB /)  
KB(:, 3,13, 6) = (/ &
 & 0.15498E-01_JPRB,0.69685E-01_JPRB,0.83483E-01_JPRB,0.81400E-01_JPRB,0.57975E-01_JPRB /)  
KB(:, 4,13, 6) = (/ &
 & 0.18239E-01_JPRB,0.73147E-01_JPRB,0.85845E-01_JPRB,0.83249E-01_JPRB,0.59127E-01_JPRB /)  
KB(:, 5,13, 6) = (/ &
 & 0.21232E-01_JPRB,0.76581E-01_JPRB,0.88266E-01_JPRB,0.85245E-01_JPRB,0.60192E-01_JPRB /)  
KB(:, 1,14, 6) = (/ &
 & 0.94274E-02_JPRB,0.53526E-01_JPRB,0.66496E-01_JPRB,0.65527E-01_JPRB,0.46374E-01_JPRB /)  
KB(:, 2,14, 6) = (/ &
 & 0.11284E-01_JPRB,0.56390E-01_JPRB,0.68527E-01_JPRB,0.66955E-01_JPRB,0.47524E-01_JPRB /)  
KB(:, 3,14, 6) = (/ &
 & 0.13394E-01_JPRB,0.59305E-01_JPRB,0.70546E-01_JPRB,0.68479E-01_JPRB,0.48560E-01_JPRB /)  
KB(:, 4,14, 6) = (/ &
 & 0.15751E-01_JPRB,0.62293E-01_JPRB,0.72634E-01_JPRB,0.70165E-01_JPRB,0.49587E-01_JPRB /)  
KB(:, 5,14, 6) = (/ &
 & 0.18326E-01_JPRB,0.65240E-01_JPRB,0.74773E-01_JPRB,0.71967E-01_JPRB,0.50492E-01_JPRB /)  
KB(:, 1,15, 6) = (/ &
 & 0.81352E-02_JPRB,0.45294E-01_JPRB,0.55939E-01_JPRB,0.54933E-01_JPRB,0.38471E-01_JPRB /)  
KB(:, 2,15, 6) = (/ &
 & 0.97406E-02_JPRB,0.47797E-01_JPRB,0.57705E-01_JPRB,0.56201E-01_JPRB,0.39475E-01_JPRB /)  
KB(:, 3,15, 6) = (/ &
 & 0.11542E-01_JPRB,0.50349E-01_JPRB,0.59500E-01_JPRB,0.57588E-01_JPRB,0.40391E-01_JPRB /)  
KB(:, 4,15, 6) = (/ &
 & 0.13568E-01_JPRB,0.52924E-01_JPRB,0.61342E-01_JPRB,0.59116E-01_JPRB,0.41250E-01_JPRB /)  
KB(:, 5,15, 6) = (/ &
 & 0.15789E-01_JPRB,0.55427E-01_JPRB,0.63250E-01_JPRB,0.60727E-01_JPRB,0.42016E-01_JPRB /)  
KB(:, 1,16, 6) = (/ &
 & 0.70159E-02_JPRB,0.38272E-01_JPRB,0.46984E-01_JPRB,0.46002E-01_JPRB,0.31818E-01_JPRB /)  
KB(:, 2,16, 6) = (/ &
 & 0.83846E-02_JPRB,0.40476E-01_JPRB,0.48519E-01_JPRB,0.47148E-01_JPRB,0.32640E-01_JPRB /)  
KB(:, 3,16, 6) = (/ &
 & 0.99392E-02_JPRB,0.42699E-01_JPRB,0.50118E-01_JPRB,0.48421E-01_JPRB,0.33435E-01_JPRB /)  
KB(:, 4,16, 6) = (/ &
 & 0.11675E-01_JPRB,0.44875E-01_JPRB,0.51760E-01_JPRB,0.49780E-01_JPRB,0.34161E-01_JPRB /)  
KB(:, 5,16, 6) = (/ &
 & 0.13584E-01_JPRB,0.46992E-01_JPRB,0.53405E-01_JPRB,0.51224E-01_JPRB,0.34855E-01_JPRB /)  
KB(:, 1,17, 6) = (/ &
 & 0.60402E-02_JPRB,0.32343E-01_JPRB,0.39419E-01_JPRB,0.38482E-01_JPRB,0.26323E-01_JPRB /)  
KB(:, 2,17, 6) = (/ &
 & 0.72134E-02_JPRB,0.34265E-01_JPRB,0.40783E-01_JPRB,0.39523E-01_JPRB,0.27045E-01_JPRB /)  
KB(:, 3,17, 6) = (/ &
 & 0.85415E-02_JPRB,0.36157E-01_JPRB,0.42200E-01_JPRB,0.40657E-01_JPRB,0.27733E-01_JPRB /)  
KB(:, 4,17, 6) = (/ &
 & 0.10023E-01_JPRB,0.37979E-01_JPRB,0.43620E-01_JPRB,0.41877E-01_JPRB,0.28354E-01_JPRB /)  
KB(:, 5,17, 6) = (/ &
 & 0.11662E-01_JPRB,0.39775E-01_JPRB,0.45034E-01_JPRB,0.43161E-01_JPRB,0.28989E-01_JPRB /)  
KB(:, 1,18, 6) = (/ &
 & 0.51905E-02_JPRB,0.27334E-01_JPRB,0.33081E-01_JPRB,0.32183E-01_JPRB,0.21845E-01_JPRB /)  
KB(:, 2,18, 6) = (/ &
 & 0.61907E-02_JPRB,0.28996E-01_JPRB,0.34295E-01_JPRB,0.33127E-01_JPRB,0.22456E-01_JPRB /)  
KB(:, 3,18, 6) = (/ &
 & 0.73283E-02_JPRB,0.30572E-01_JPRB,0.35522E-01_JPRB,0.34131E-01_JPRB,0.23047E-01_JPRB /)  
KB(:, 4,18, 6) = (/ &
 & 0.85960E-02_JPRB,0.32113E-01_JPRB,0.36725E-01_JPRB,0.35202E-01_JPRB,0.23589E-01_JPRB /)  
KB(:, 5,18, 6) = (/ &
 & 0.10011E-01_JPRB,0.33654E-01_JPRB,0.37950E-01_JPRB,0.36339E-01_JPRB,0.24154E-01_JPRB /)  
KB(:, 1,19, 6) = (/ &
 & 0.44474E-02_JPRB,0.23093E-01_JPRB,0.27758E-01_JPRB,0.26913E-01_JPRB,0.18159E-01_JPRB /)  
KB(:, 2,19, 6) = (/ &
 & 0.53019E-02_JPRB,0.24497E-01_JPRB,0.28826E-01_JPRB,0.27764E-01_JPRB,0.18694E-01_JPRB /)  
KB(:, 3,19, 6) = (/ &
 & 0.62735E-02_JPRB,0.25825E-01_JPRB,0.29864E-01_JPRB,0.28669E-01_JPRB,0.19187E-01_JPRB /)  
KB(:, 4,19, 6) = (/ &
 & 0.73683E-02_JPRB,0.27139E-01_JPRB,0.30890E-01_JPRB,0.29627E-01_JPRB,0.19650E-01_JPRB /)  
KB(:, 5,19, 6) = (/ &
 & 0.85933E-02_JPRB,0.28467E-01_JPRB,0.31975E-01_JPRB,0.30634E-01_JPRB,0.20138E-01_JPRB /)  
KB(:, 1,20, 6) = (/ &
 & 0.38215E-02_JPRB,0.19522E-01_JPRB,0.23307E-01_JPRB,0.22532E-01_JPRB,0.15180E-01_JPRB /)  
KB(:, 2,20, 6) = (/ &
 & 0.45489E-02_JPRB,0.20697E-01_JPRB,0.24217E-01_JPRB,0.23292E-01_JPRB,0.15626E-01_JPRB /)  
KB(:, 3,20, 6) = (/ &
 & 0.53838E-02_JPRB,0.21827E-01_JPRB,0.25099E-01_JPRB,0.24107E-01_JPRB,0.16039E-01_JPRB /)  
KB(:, 4,20, 6) = (/ &
 & 0.63294E-02_JPRB,0.22947E-01_JPRB,0.25996E-01_JPRB,0.24951E-01_JPRB,0.16431E-01_JPRB /)  
KB(:, 5,20, 6) = (/ &
 & 0.73910E-02_JPRB,0.24098E-01_JPRB,0.26969E-01_JPRB,0.25840E-01_JPRB,0.16861E-01_JPRB /)  
KB(:, 1,21, 6) = (/ &
 & 0.32849E-02_JPRB,0.16485E-01_JPRB,0.19564E-01_JPRB,0.18873E-01_JPRB,0.12724E-01_JPRB /)  
KB(:, 2,21, 6) = (/ &
 & 0.39093E-02_JPRB,0.17476E-01_JPRB,0.20333E-01_JPRB,0.19553E-01_JPRB,0.13080E-01_JPRB /)  
KB(:, 3,21, 6) = (/ &
 & 0.46257E-02_JPRB,0.18440E-01_JPRB,0.21099E-01_JPRB,0.20272E-01_JPRB,0.13424E-01_JPRB /)  
KB(:, 4,21, 6) = (/ &
 & 0.54436E-02_JPRB,0.19400E-01_JPRB,0.21897E-01_JPRB,0.21018E-01_JPRB,0.13774E-01_JPRB /)  
KB(:, 5,21, 6) = (/ &
 & 0.63568E-02_JPRB,0.20406E-01_JPRB,0.22777E-01_JPRB,0.21806E-01_JPRB,0.14153E-01_JPRB /)  
KB(:, 1,22, 6) = (/ &
 & 0.28524E-02_JPRB,0.13970E-01_JPRB,0.16464E-01_JPRB,0.15855E-01_JPRB,0.10647E-01_JPRB /)  
KB(:, 2,22, 6) = (/ &
 & 0.33998E-02_JPRB,0.14799E-01_JPRB,0.17121E-01_JPRB,0.16464E-01_JPRB,0.10957E-01_JPRB /)  
KB(:, 3,22, 6) = (/ &
 & 0.40218E-02_JPRB,0.15618E-01_JPRB,0.17789E-01_JPRB,0.17098E-01_JPRB,0.11264E-01_JPRB /)  
KB(:, 4,22, 6) = (/ &
 & 0.47350E-02_JPRB,0.16459E-01_JPRB,0.18512E-01_JPRB,0.17761E-01_JPRB,0.11585E-01_JPRB /)  
KB(:, 5,22, 6) = (/ &
 & 0.55269E-02_JPRB,0.17342E-01_JPRB,0.19306E-01_JPRB,0.18466E-01_JPRB,0.11905E-01_JPRB /)  
KB(:, 1,23, 6) = (/ &
 & 0.24776E-02_JPRB,0.11832E-01_JPRB,0.13862E-01_JPRB,0.13338E-01_JPRB,0.89101E-02_JPRB /)  
KB(:, 2,23, 6) = (/ &
 & 0.29594E-02_JPRB,0.12532E-01_JPRB,0.14430E-01_JPRB,0.13874E-01_JPRB,0.91836E-02_JPRB /)  
KB(:, 3,23, 6) = (/ &
 & 0.35060E-02_JPRB,0.13237E-01_JPRB,0.15025E-01_JPRB,0.14435E-01_JPRB,0.94582E-02_JPRB /)  
KB(:, 4,23, 6) = (/ &
 & 0.41276E-02_JPRB,0.13976E-01_JPRB,0.15673E-01_JPRB,0.15028E-01_JPRB,0.97462E-02_JPRB /)  
KB(:, 5,23, 6) = (/ &
 & 0.48108E-02_JPRB,0.14761E-01_JPRB,0.16387E-01_JPRB,0.15666E-01_JPRB,0.10041E-01_JPRB /)  
KB(:, 1,24, 6) = (/ &
 & 0.21553E-02_JPRB,0.10022E-01_JPRB,0.11681E-01_JPRB,0.11233E-01_JPRB,0.74484E-02_JPRB /)  
KB(:, 2,24, 6) = (/ &
 & 0.25764E-02_JPRB,0.10621E-01_JPRB,0.12176E-01_JPRB,0.11709E-01_JPRB,0.76914E-02_JPRB /)  
KB(:, 3,24, 6) = (/ &
 & 0.30587E-02_JPRB,0.11236E-01_JPRB,0.12711E-01_JPRB,0.12208E-01_JPRB,0.79451E-02_JPRB /)  
KB(:, 4,24, 6) = (/ &
 & 0.36022E-02_JPRB,0.11891E-01_JPRB,0.13293E-01_JPRB,0.12744E-01_JPRB,0.82033E-02_JPRB /)  
KB(:, 5,24, 6) = (/ &
 & 0.41914E-02_JPRB,0.12593E-01_JPRB,0.13939E-01_JPRB,0.13324E-01_JPRB,0.84674E-02_JPRB /)  
KB(:, 1,25, 6) = (/ &
 & 0.18796E-02_JPRB,0.85000E-02_JPRB,0.98543E-02_JPRB,0.94788E-02_JPRB,0.62281E-02_JPRB /)  
KB(:, 2,25, 6) = (/ &
 & 0.22512E-02_JPRB,0.90173E-02_JPRB,0.10293E-01_JPRB,0.99015E-02_JPRB,0.64465E-02_JPRB /)  
KB(:, 3,25, 6) = (/ &
 & 0.26761E-02_JPRB,0.95606E-02_JPRB,0.10772E-01_JPRB,0.10351E-01_JPRB,0.66771E-02_JPRB /)  
KB(:, 4,25, 6) = (/ &
 & 0.31512E-02_JPRB,0.10144E-01_JPRB,0.11303E-01_JPRB,0.10838E-01_JPRB,0.69100E-02_JPRB /)  
KB(:, 5,25, 6) = (/ &
 & 0.36575E-02_JPRB,0.10772E-01_JPRB,0.11893E-01_JPRB,0.11363E-01_JPRB,0.71526E-02_JPRB /)  
KB(:, 1,26, 6) = (/ &
 & 0.16486E-02_JPRB,0.72263E-02_JPRB,0.83293E-02_JPRB,0.80207E-02_JPRB,0.52267E-02_JPRB /)  
KB(:, 2,26, 6) = (/ &
 & 0.19790E-02_JPRB,0.76783E-02_JPRB,0.87239E-02_JPRB,0.83966E-02_JPRB,0.54266E-02_JPRB /)  
KB(:, 3,26, 6) = (/ &
 & 0.23552E-02_JPRB,0.81632E-02_JPRB,0.91606E-02_JPRB,0.88030E-02_JPRB,0.56340E-02_JPRB /)  
KB(:, 4,26, 6) = (/ &
 & 0.27655E-02_JPRB,0.86841E-02_JPRB,0.96465E-02_JPRB,0.92463E-02_JPRB,0.58421E-02_JPRB /)  
KB(:, 5,26, 6) = (/ &
 & 0.32014E-02_JPRB,0.92461E-02_JPRB,0.10190E-01_JPRB,0.97263E-02_JPRB,0.60618E-02_JPRB /)  
KB(:, 1,27, 6) = (/ &
 & 0.14479E-02_JPRB,0.61551E-02_JPRB,0.70548E-02_JPRB,0.67980E-02_JPRB,0.43916E-02_JPRB /)  
KB(:, 2,27, 6) = (/ &
 & 0.17422E-02_JPRB,0.65560E-02_JPRB,0.74109E-02_JPRB,0.71369E-02_JPRB,0.45703E-02_JPRB /)  
KB(:, 3,27, 6) = (/ &
 & 0.20711E-02_JPRB,0.69878E-02_JPRB,0.78116E-02_JPRB,0.75081E-02_JPRB,0.47565E-02_JPRB /)  
KB(:, 4,27, 6) = (/ &
 & 0.24273E-02_JPRB,0.74543E-02_JPRB,0.82596E-02_JPRB,0.79125E-02_JPRB,0.49414E-02_JPRB /)  
KB(:, 5,27, 6) = (/ &
 & 0.28006E-02_JPRB,0.79622E-02_JPRB,0.87633E-02_JPRB,0.83523E-02_JPRB,0.51438E-02_JPRB /)  
KB(:, 1,28, 6) = (/ &
 & 0.12757E-02_JPRB,0.52552E-02_JPRB,0.59880E-02_JPRB,0.57731E-02_JPRB,0.36940E-02_JPRB /)  
KB(:, 2,28, 6) = (/ &
 & 0.15355E-02_JPRB,0.56117E-02_JPRB,0.63148E-02_JPRB,0.60828E-02_JPRB,0.38537E-02_JPRB /)  
KB(:, 3,28, 6) = (/ &
 & 0.18209E-02_JPRB,0.60000E-02_JPRB,0.66831E-02_JPRB,0.64236E-02_JPRB,0.40153E-02_JPRB /)  
KB(:, 4,28, 6) = (/ &
 & 0.21272E-02_JPRB,0.64202E-02_JPRB,0.70979E-02_JPRB,0.67923E-02_JPRB,0.41811E-02_JPRB /)  
KB(:, 5,28, 6) = (/ &
 & 0.24474E-02_JPRB,0.68778E-02_JPRB,0.75643E-02_JPRB,0.71983E-02_JPRB,0.43640E-02_JPRB /)  
KB(:, 1,29, 6) = (/ &
 & 0.11295E-02_JPRB,0.45004E-02_JPRB,0.50997E-02_JPRB,0.49184E-02_JPRB,0.31153E-02_JPRB /)  
KB(:, 2,29, 6) = (/ &
 & 0.13559E-02_JPRB,0.48180E-02_JPRB,0.54010E-02_JPRB,0.52034E-02_JPRB,0.32572E-02_JPRB /)  
KB(:, 3,29, 6) = (/ &
 & 0.16033E-02_JPRB,0.51685E-02_JPRB,0.57423E-02_JPRB,0.55151E-02_JPRB,0.33997E-02_JPRB /)  
KB(:, 4,29, 6) = (/ &
 & 0.18647E-02_JPRB,0.55488E-02_JPRB,0.61280E-02_JPRB,0.58545E-02_JPRB,0.35531E-02_JPRB /)  
KB(:, 5,29, 6) = (/ &
 & 0.21368E-02_JPRB,0.59683E-02_JPRB,0.65578E-02_JPRB,0.62309E-02_JPRB,0.37192E-02_JPRB /)  
KB(:, 1,30, 6) = (/ &
 & 0.10010E-02_JPRB,0.38621E-02_JPRB,0.43580E-02_JPRB,0.42036E-02_JPRB,0.26325E-02_JPRB /)  
KB(:, 2,30, 6) = (/ &
 & 0.11967E-02_JPRB,0.41511E-02_JPRB,0.46366E-02_JPRB,0.44656E-02_JPRB,0.27570E-02_JPRB /)  
KB(:, 3,30, 6) = (/ &
 & 0.14096E-02_JPRB,0.44678E-02_JPRB,0.49534E-02_JPRB,0.47515E-02_JPRB,0.28856E-02_JPRB /)  
KB(:, 4,30, 6) = (/ &
 & 0.16325E-02_JPRB,0.48140E-02_JPRB,0.53117E-02_JPRB,0.50685E-02_JPRB,0.30242E-02_JPRB /)  
KB(:, 5,30, 6) = (/ &
 & 0.18599E-02_JPRB,0.52016E-02_JPRB,0.57103E-02_JPRB,0.54169E-02_JPRB,0.31738E-02_JPRB /)  
KB(:, 1,31, 6) = (/ &
 & 0.88685E-03_JPRB,0.33266E-02_JPRB,0.37394E-02_JPRB,0.36064E-02_JPRB,0.22280E-02_JPRB /)  
KB(:, 2,31, 6) = (/ &
 & 0.10569E-02_JPRB,0.35897E-02_JPRB,0.39964E-02_JPRB,0.38465E-02_JPRB,0.23389E-02_JPRB /)  
KB(:, 3,31, 6) = (/ &
 & 0.12382E-02_JPRB,0.38779E-02_JPRB,0.42920E-02_JPRB,0.41135E-02_JPRB,0.24573E-02_JPRB /)  
KB(:, 4,31, 6) = (/ &
 & 0.14278E-02_JPRB,0.41961E-02_JPRB,0.46258E-02_JPRB,0.44080E-02_JPRB,0.25818E-02_JPRB /)  
KB(:, 5,31, 6) = (/ &
 & 0.16136E-02_JPRB,0.45547E-02_JPRB,0.50001E-02_JPRB,0.47313E-02_JPRB,0.27214E-02_JPRB /)  
KB(:, 1,32, 6) = (/ &
 & 0.78559E-03_JPRB,0.28763E-02_JPRB,0.32195E-02_JPRB,0.31059E-02_JPRB,0.18911E-02_JPRB /)  
KB(:, 2,32, 6) = (/ &
 & 0.93178E-03_JPRB,0.31157E-02_JPRB,0.34609E-02_JPRB,0.33287E-02_JPRB,0.19930E-02_JPRB /)  
KB(:, 3,32, 6) = (/ &
 & 0.10867E-02_JPRB,0.33798E-02_JPRB,0.37377E-02_JPRB,0.35772E-02_JPRB,0.21006E-02_JPRB /)  
KB(:, 4,32, 6) = (/ &
 & 0.12446E-02_JPRB,0.36754E-02_JPRB,0.40497E-02_JPRB,0.38517E-02_JPRB,0.22158E-02_JPRB /)  
KB(:, 5,32, 6) = (/ &
 & 0.13936E-02_JPRB,0.40072E-02_JPRB,0.44007E-02_JPRB,0.41538E-02_JPRB,0.23413E-02_JPRB /)  
KB(:, 1,33, 6) = (/ &
 & 0.69486E-03_JPRB,0.24959E-02_JPRB,0.27846E-02_JPRB,0.26858E-02_JPRB,0.16103E-02_JPRB /)  
KB(:, 2,33, 6) = (/ &
 & 0.82037E-03_JPRB,0.27142E-02_JPRB,0.30117E-02_JPRB,0.28933E-02_JPRB,0.17041E-02_JPRB /)  
KB(:, 3,33, 6) = (/ &
 & 0.95137E-03_JPRB,0.29589E-02_JPRB,0.32703E-02_JPRB,0.31258E-02_JPRB,0.18033E-02_JPRB /)  
KB(:, 4,33, 6) = (/ &
 & 0.10800E-02_JPRB,0.32345E-02_JPRB,0.35641E-02_JPRB,0.33810E-02_JPRB,0.19089E-02_JPRB /)  
KB(:, 5,33, 6) = (/ &
 & 0.11986E-02_JPRB,0.35406E-02_JPRB,0.38943E-02_JPRB,0.36682E-02_JPRB,0.20234E-02_JPRB /)  
KB(:, 1,34, 6) = (/ &
 & 0.61032E-03_JPRB,0.21671E-02_JPRB,0.24134E-02_JPRB,0.23268E-02_JPRB,0.13754E-02_JPRB /)  
KB(:, 2,34, 6) = (/ &
 & 0.71748E-03_JPRB,0.23678E-02_JPRB,0.26264E-02_JPRB,0.25207E-02_JPRB,0.14624E-02_JPRB /)  
KB(:, 3,34, 6) = (/ &
 & 0.82600E-03_JPRB,0.25947E-02_JPRB,0.28697E-02_JPRB,0.27368E-02_JPRB,0.15523E-02_JPRB /)  
KB(:, 4,34, 6) = (/ &
 & 0.92939E-03_JPRB,0.28495E-02_JPRB,0.31449E-02_JPRB,0.29773E-02_JPRB,0.16488E-02_JPRB /)  
KB(:, 5,34, 6) = (/ &
 & 0.10239E-02_JPRB,0.31299E-02_JPRB,0.34552E-02_JPRB,0.32520E-02_JPRB,0.17543E-02_JPRB /)  
KB(:, 1,35, 6) = (/ &
 & 0.52678E-03_JPRB,0.18713E-02_JPRB,0.20838E-02_JPRB,0.20082E-02_JPRB,0.11717E-02_JPRB /)  
KB(:, 2,35, 6) = (/ &
 & 0.61674E-03_JPRB,0.20541E-02_JPRB,0.22811E-02_JPRB,0.21873E-02_JPRB,0.12500E-02_JPRB /)  
KB(:, 3,35, 6) = (/ &
 & 0.70570E-03_JPRB,0.22625E-02_JPRB,0.25066E-02_JPRB,0.23870E-02_JPRB,0.13326E-02_JPRB /)  
KB(:, 4,35, 6) = (/ &
 & 0.78855E-03_JPRB,0.24971E-02_JPRB,0.27629E-02_JPRB,0.26134E-02_JPRB,0.14204E-02_JPRB /)  
KB(:, 5,35, 6) = (/ &
 & 0.86492E-03_JPRB,0.27499E-02_JPRB,0.30514E-02_JPRB,0.28766E-02_JPRB,0.15154E-02_JPRB /)  
KB(:, 1,36, 6) = (/ &
 & 0.44569E-03_JPRB,0.16031E-02_JPRB,0.17868E-02_JPRB,0.17221E-02_JPRB,0.99240E-03_JPRB /)  
KB(:, 2,36, 6) = (/ &
 & 0.52055E-03_JPRB,0.17679E-02_JPRB,0.19674E-02_JPRB,0.18854E-02_JPRB,0.10623E-02_JPRB /)  
KB(:, 3,36, 6) = (/ &
 & 0.59380E-03_JPRB,0.19567E-02_JPRB,0.21742E-02_JPRB,0.20700E-02_JPRB,0.11368E-02_JPRB /)  
KB(:, 4,36, 6) = (/ &
 & 0.66114E-03_JPRB,0.21690E-02_JPRB,0.24093E-02_JPRB,0.22827E-02_JPRB,0.12171E-02_JPRB /)  
KB(:, 5,36, 6) = (/ &
 & 0.72347E-03_JPRB,0.23953E-02_JPRB,0.26735E-02_JPRB,0.25294E-02_JPRB,0.13028E-02_JPRB /)  
KB(:, 1,37, 6) = (/ &
 & 0.36881E-03_JPRB,0.13558E-02_JPRB,0.15140E-02_JPRB,0.14605E-02_JPRB,0.83527E-03_JPRB /)  
KB(:, 2,37, 6) = (/ &
 & 0.43070E-03_JPRB,0.15018E-02_JPRB,0.16759E-02_JPRB,0.16073E-02_JPRB,0.89749E-03_JPRB /)  
KB(:, 3,37, 6) = (/ &
 & 0.49122E-03_JPRB,0.16697E-02_JPRB,0.18620E-02_JPRB,0.17747E-02_JPRB,0.96428E-03_JPRB /)  
KB(:, 4,37, 6) = (/ &
 & 0.54687E-03_JPRB,0.18590E-02_JPRB,0.20742E-02_JPRB,0.19690E-02_JPRB,0.10365E-02_JPRB /)  
KB(:, 5,37, 6) = (/ &
 & 0.59826E-03_JPRB,0.20615E-02_JPRB,0.23143E-02_JPRB,0.21948E-02_JPRB,0.11140E-02_JPRB /)  
KB(:, 1,38, 6) = (/ &
 & 0.30472E-03_JPRB,0.11463E-02_JPRB,0.12827E-02_JPRB,0.12387E-02_JPRB,0.70293E-03_JPRB /)  
KB(:, 2,38, 6) = (/ &
 & 0.35606E-03_JPRB,0.12755E-02_JPRB,0.14277E-02_JPRB,0.13705E-02_JPRB,0.75844E-03_JPRB /)  
KB(:, 3,38, 6) = (/ &
 & 0.40587E-03_JPRB,0.14248E-02_JPRB,0.15948E-02_JPRB,0.15225E-02_JPRB,0.81832E-03_JPRB /)  
KB(:, 4,38, 6) = (/ &
 & 0.45170E-03_JPRB,0.15929E-02_JPRB,0.17869E-02_JPRB,0.16996E-02_JPRB,0.88272E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART20',1,ZHOOK_HANDLE)
END SUBROUTINE PART20


SUBROUTINE PART21

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART21',0,ZHOOK_HANDLE)


KB(:, 5,38, 6) = (/ &
 & 0.49447E-03_JPRB,0.17743E-02_JPRB,0.20049E-02_JPRB,0.19060E-02_JPRB,0.95296E-03_JPRB /)  
KB(:, 1,39, 6) = (/ &
 & 0.25159E-03_JPRB,0.96943E-03_JPRB,0.10877E-02_JPRB,0.10513E-02_JPRB,0.59159E-03_JPRB /)  
KB(:, 2,39, 6) = (/ &
 & 0.29433E-03_JPRB,0.10839E-02_JPRB,0.12173E-02_JPRB,0.11700E-02_JPRB,0.64088E-03_JPRB /)  
KB(:, 3,39, 6) = (/ &
 & 0.33554E-03_JPRB,0.12164E-02_JPRB,0.13675E-02_JPRB,0.13079E-02_JPRB,0.69454E-03_JPRB /)  
KB(:, 4,39, 6) = (/ &
 & 0.37315E-03_JPRB,0.13660E-02_JPRB,0.15416E-02_JPRB,0.14697E-02_JPRB,0.75241E-03_JPRB /)  
KB(:, 5,39, 6) = (/ &
 & 0.40840E-03_JPRB,0.15291E-02_JPRB,0.17396E-02_JPRB,0.16583E-02_JPRB,0.81566E-03_JPRB /)  
KB(:, 1,40, 6) = (/ &
 & 0.20445E-03_JPRB,0.81104E-03_JPRB,0.91201E-03_JPRB,0.88303E-03_JPRB,0.49462E-03_JPRB /)  
KB(:, 2,40, 6) = (/ &
 & 0.24013E-03_JPRB,0.91062E-03_JPRB,0.10259E-02_JPRB,0.98834E-03_JPRB,0.53806E-03_JPRB /)  
KB(:, 3,40, 6) = (/ &
 & 0.27454E-03_JPRB,0.10267E-02_JPRB,0.11591E-02_JPRB,0.11112E-02_JPRB,0.58582E-03_JPRB /)  
KB(:, 4,40, 6) = (/ &
 & 0.30609E-03_JPRB,0.11586E-02_JPRB,0.13148E-02_JPRB,0.12564E-02_JPRB,0.63733E-03_JPRB /)  
KB(:, 5,40, 6) = (/ &
 & 0.33521E-03_JPRB,0.13038E-02_JPRB,0.14932E-02_JPRB,0.14267E-02_JPRB,0.69406E-03_JPRB /)  
KB(:, 1,41, 6) = (/ &
 & 0.16568E-03_JPRB,0.67706E-03_JPRB,0.76339E-03_JPRB,0.74014E-03_JPRB,0.41311E-03_JPRB /)  
KB(:, 2,41, 6) = (/ &
 & 0.19545E-03_JPRB,0.76370E-03_JPRB,0.86317E-03_JPRB,0.83349E-03_JPRB,0.45126E-03_JPRB /)  
KB(:, 3,41, 6) = (/ &
 & 0.22429E-03_JPRB,0.86513E-03_JPRB,0.98057E-03_JPRB,0.94284E-03_JPRB,0.49336E-03_JPRB /)  
KB(:, 4,41, 6) = (/ &
 & 0.25075E-03_JPRB,0.98100E-03_JPRB,0.11192E-02_JPRB,0.10723E-02_JPRB,0.53916E-03_JPRB /)  
KB(:, 5,41, 6) = (/ &
 & 0.27523E-03_JPRB,0.11101E-02_JPRB,0.12797E-02_JPRB,0.12259E-02_JPRB,0.58980E-03_JPRB /)  
KB(:, 1,42, 6) = (/ &
 & 0.13464E-03_JPRB,0.56478E-03_JPRB,0.63846E-03_JPRB,0.61972E-03_JPRB,0.34485E-03_JPRB /)  
KB(:, 2,42, 6) = (/ &
 & 0.15918E-03_JPRB,0.64002E-03_JPRB,0.72573E-03_JPRB,0.70212E-03_JPRB,0.37807E-03_JPRB /)  
KB(:, 3,42, 6) = (/ &
 & 0.18309E-03_JPRB,0.72866E-03_JPRB,0.82914E-03_JPRB,0.79959E-03_JPRB,0.41541E-03_JPRB /)  
KB(:, 4,42, 6) = (/ &
 & 0.20534E-03_JPRB,0.83063E-03_JPRB,0.95224E-03_JPRB,0.91510E-03_JPRB,0.45609E-03_JPRB /)  
KB(:, 5,42, 6) = (/ &
 & 0.22591E-03_JPRB,0.94536E-03_JPRB,0.10960E-02_JPRB,0.10535E-02_JPRB,0.50132E-03_JPRB /)  
KB(:, 1,43, 6) = (/ &
 & 0.10834E-03_JPRB,0.46763E-03_JPRB,0.52964E-03_JPRB,0.51479E-03_JPRB,0.28641E-03_JPRB /)  
KB(:, 2,43, 6) = (/ &
 & 0.12878E-03_JPRB,0.53191E-03_JPRB,0.60529E-03_JPRB,0.58655E-03_JPRB,0.31538E-03_JPRB /)  
KB(:, 3,43, 6) = (/ &
 & 0.14877E-03_JPRB,0.60848E-03_JPRB,0.69517E-03_JPRB,0.67233E-03_JPRB,0.34781E-03_JPRB /)  
KB(:, 4,43, 6) = (/ &
 & 0.16739E-03_JPRB,0.69818E-03_JPRB,0.80315E-03_JPRB,0.77433E-03_JPRB,0.38376E-03_JPRB /)  
KB(:, 5,43, 6) = (/ &
 & 0.18458E-03_JPRB,0.79951E-03_JPRB,0.93071E-03_JPRB,0.89755E-03_JPRB,0.42371E-03_JPRB /)  
KB(:, 1,44, 6) = (/ &
 & 0.86770E-04_JPRB,0.38551E-03_JPRB,0.43712E-03_JPRB,0.42544E-03_JPRB,0.23710E-03_JPRB /)  
KB(:, 2,44, 6) = (/ &
 & 0.10382E-03_JPRB,0.44040E-03_JPRB,0.50222E-03_JPRB,0.48753E-03_JPRB,0.26235E-03_JPRB /)  
KB(:, 3,44, 6) = (/ &
 & 0.12059E-03_JPRB,0.50571E-03_JPRB,0.58013E-03_JPRB,0.56233E-03_JPRB,0.29036E-03_JPRB /)  
KB(:, 4,44, 6) = (/ &
 & 0.13632E-03_JPRB,0.58391E-03_JPRB,0.67429E-03_JPRB,0.65221E-03_JPRB,0.32192E-03_JPRB /)  
KB(:, 5,44, 6) = (/ &
 & 0.15073E-03_JPRB,0.67339E-03_JPRB,0.78624E-03_JPRB,0.76086E-03_JPRB,0.35732E-03_JPRB /)  
KB(:, 1,45, 6) = (/ &
 & 0.69317E-04_JPRB,0.31724E-03_JPRB,0.36001E-03_JPRB,0.35090E-03_JPRB,0.19579E-03_JPRB /)  
KB(:, 2,45, 6) = (/ &
 & 0.83569E-04_JPRB,0.36417E-03_JPRB,0.41579E-03_JPRB,0.40435E-03_JPRB,0.21781E-03_JPRB /)  
KB(:, 3,45, 6) = (/ &
 & 0.97725E-04_JPRB,0.42014E-03_JPRB,0.48329E-03_JPRB,0.46938E-03_JPRB,0.24226E-03_JPRB /)  
KB(:, 4,45, 6) = (/ &
 & 0.11101E-03_JPRB,0.48745E-03_JPRB,0.56520E-03_JPRB,0.54804E-03_JPRB,0.26965E-03_JPRB /)  
KB(:, 5,45, 6) = (/ &
 & 0.12310E-03_JPRB,0.56606E-03_JPRB,0.66327E-03_JPRB,0.64374E-03_JPRB,0.30080E-03_JPRB /)  
KB(:, 1,46, 6) = (/ &
 & 0.55030E-04_JPRB,0.26007E-03_JPRB,0.29522E-03_JPRB,0.28798E-03_JPRB,0.16098E-03_JPRB /)  
KB(:, 2,46, 6) = (/ &
 & 0.66908E-04_JPRB,0.29981E-03_JPRB,0.34235E-03_JPRB,0.33361E-03_JPRB,0.18009E-03_JPRB /)  
KB(:, 3,46, 6) = (/ &
 & 0.78894E-04_JPRB,0.34737E-03_JPRB,0.40028E-03_JPRB,0.38969E-03_JPRB,0.20138E-03_JPRB /)  
KB(:, 4,46, 6) = (/ &
 & 0.90228E-04_JPRB,0.40507E-03_JPRB,0.47110E-03_JPRB,0.45796E-03_JPRB,0.22525E-03_JPRB /)  
KB(:, 5,46, 6) = (/ &
 & 0.10044E-03_JPRB,0.47380E-03_JPRB,0.55673E-03_JPRB,0.54149E-03_JPRB,0.25231E-03_JPRB /)  
KB(:, 1,47, 6) = (/ &
 & 0.43131E-04_JPRB,0.21132E-03_JPRB,0.23992E-03_JPRB,0.23430E-03_JPRB,0.13147E-03_JPRB /)  
KB(:, 2,47, 6) = (/ &
 & 0.53026E-04_JPRB,0.24489E-03_JPRB,0.27966E-03_JPRB,0.27282E-03_JPRB,0.14794E-03_JPRB /)  
KB(:, 3,47, 6) = (/ &
 & 0.63179E-04_JPRB,0.28502E-03_JPRB,0.32837E-03_JPRB,0.32046E-03_JPRB,0.16642E-03_JPRB /)  
KB(:, 4,47, 6) = (/ &
 & 0.72849E-04_JPRB,0.33391E-03_JPRB,0.38868E-03_JPRB,0.37909E-03_JPRB,0.18727E-03_JPRB /)  
KB(:, 5,47, 6) = (/ &
 & 0.81641E-04_JPRB,0.39308E-03_JPRB,0.46293E-03_JPRB,0.45114E-03_JPRB,0.21071E-03_JPRB /)  
KB(:, 1,48, 6) = (/ &
 & 0.33560E-04_JPRB,0.17139E-03_JPRB,0.19468E-03_JPRB,0.19001E-03_JPRB,0.10710E-03_JPRB /)  
KB(:, 2,48, 6) = (/ &
 & 0.41736E-04_JPRB,0.19942E-03_JPRB,0.22765E-03_JPRB,0.22235E-03_JPRB,0.12121E-03_JPRB /)  
KB(:, 3,48, 6) = (/ &
 & 0.50371E-04_JPRB,0.23319E-03_JPRB,0.26893E-03_JPRB,0.26280E-03_JPRB,0.13718E-03_JPRB /)  
KB(:, 4,48, 6) = (/ &
 & 0.58779E-04_JPRB,0.27466E-03_JPRB,0.31973E-03_JPRB,0.31295E-03_JPRB,0.15543E-03_JPRB /)  
KB(:, 5,48, 6) = (/ &
 & 0.66247E-04_JPRB,0.32531E-03_JPRB,0.38347E-03_JPRB,0.37465E-03_JPRB,0.17582E-03_JPRB /)  
KB(:, 1,49, 6) = (/ &
 & 0.25958E-04_JPRB,0.13895E-03_JPRB,0.15751E-03_JPRB,0.15378E-03_JPRB,0.86997E-04_JPRB /)  
KB(:, 2,49, 6) = (/ &
 & 0.32663E-04_JPRB,0.16210E-03_JPRB,0.18496E-03_JPRB,0.18058E-03_JPRB,0.99003E-04_JPRB /)  
KB(:, 3,49, 6) = (/ &
 & 0.39912E-04_JPRB,0.19033E-03_JPRB,0.21954E-03_JPRB,0.21463E-03_JPRB,0.11278E-03_JPRB /)  
KB(:, 4,49, 6) = (/ &
 & 0.47146E-04_JPRB,0.22536E-03_JPRB,0.26252E-03_JPRB,0.25743E-03_JPRB,0.12854E-03_JPRB /)  
KB(:, 5,49, 6) = (/ &
 & 0.53714E-04_JPRB,0.26879E-03_JPRB,0.31652E-03_JPRB,0.31040E-03_JPRB,0.14638E-03_JPRB /)  
KB(:, 1,50, 6) = (/ &
 & 0.20123E-04_JPRB,0.11283E-03_JPRB,0.12763E-03_JPRB,0.12462E-03_JPRB,0.70722E-04_JPRB /)  
KB(:, 2,50, 6) = (/ &
 & 0.25601E-04_JPRB,0.13215E-03_JPRB,0.15042E-03_JPRB,0.14697E-03_JPRB,0.80931E-04_JPRB /)  
KB(:, 3,50, 6) = (/ &
 & 0.31614E-04_JPRB,0.15574E-03_JPRB,0.17957E-03_JPRB,0.17552E-03_JPRB,0.92734E-04_JPRB /)  
KB(:, 4,50, 6) = (/ &
 & 0.37764E-04_JPRB,0.18520E-03_JPRB,0.21596E-03_JPRB,0.21200E-03_JPRB,0.10641E-03_JPRB /)  
KB(:, 5,50, 6) = (/ &
 & 0.43463E-04_JPRB,0.22248E-03_JPRB,0.26195E-03_JPRB,0.25758E-03_JPRB,0.12203E-03_JPRB /)  
KB(:, 1,51, 6) = (/ &
 & 0.15566E-04_JPRB,0.91692E-04_JPRB,0.10348E-03_JPRB,0.10093E-03_JPRB,0.57420E-04_JPRB /)  
KB(:, 2,51, 6) = (/ &
 & 0.20041E-04_JPRB,0.10771E-03_JPRB,0.12230E-03_JPRB,0.11952E-03_JPRB,0.66019E-04_JPRB /)  
KB(:, 3,51, 6) = (/ &
 & 0.25022E-04_JPRB,0.12757E-03_JPRB,0.14670E-03_JPRB,0.14349E-03_JPRB,0.76182E-04_JPRB /)  
KB(:, 4,51, 6) = (/ &
 & 0.30196E-04_JPRB,0.15226E-03_JPRB,0.17772E-03_JPRB,0.17429E-03_JPRB,0.87954E-04_JPRB /)  
KB(:, 5,51, 6) = (/ &
 & 0.35140E-04_JPRB,0.18405E-03_JPRB,0.21697E-03_JPRB,0.21356E-03_JPRB,0.10162E-03_JPRB /)  
KB(:, 1,52, 6) = (/ &
 & 0.11977E-04_JPRB,0.74321E-04_JPRB,0.83777E-04_JPRB,0.81525E-04_JPRB,0.46492E-04_JPRB /)  
KB(:, 2,52, 6) = (/ &
 & 0.15618E-04_JPRB,0.87662E-04_JPRB,0.99315E-04_JPRB,0.96995E-04_JPRB,0.53744E-04_JPRB /)  
KB(:, 3,52, 6) = (/ &
 & 0.19731E-04_JPRB,0.10434E-03_JPRB,0.11957E-03_JPRB,0.11696E-03_JPRB,0.62355E-04_JPRB /)  
KB(:, 4,52, 6) = (/ &
 & 0.24071E-04_JPRB,0.12514E-03_JPRB,0.14574E-03_JPRB,0.14300E-03_JPRB,0.72491E-04_JPRB /)  
KB(:, 5,52, 6) = (/ &
 & 0.28292E-04_JPRB,0.15185E-03_JPRB,0.17919E-03_JPRB,0.17642E-03_JPRB,0.84356E-04_JPRB /)  
KB(:, 1,53, 6) = (/ &
 & 0.91836E-05_JPRB,0.60131E-04_JPRB,0.67720E-04_JPRB,0.65649E-04_JPRB,0.37522E-04_JPRB /)  
KB(:, 2,53, 6) = (/ &
 & 0.12113E-04_JPRB,0.71192E-04_JPRB,0.80457E-04_JPRB,0.78425E-04_JPRB,0.43599E-04_JPRB /)  
KB(:, 3,53, 6) = (/ &
 & 0.15471E-04_JPRB,0.85141E-04_JPRB,0.97276E-04_JPRB,0.95110E-04_JPRB,0.50903E-04_JPRB /)  
KB(:, 4,53, 6) = (/ &
 & 0.19102E-04_JPRB,0.10263E-03_JPRB,0.11918E-03_JPRB,0.11694E-03_JPRB,0.59553E-04_JPRB /)  
KB(:, 5,53, 6) = (/ &
 & 0.22693E-04_JPRB,0.12514E-03_JPRB,0.14755E-03_JPRB,0.14527E-03_JPRB,0.69812E-04_JPRB /)  
KB(:, 1,54, 6) = (/ &
 & 0.70721E-05_JPRB,0.48764E-04_JPRB,0.54926E-04_JPRB,0.53041E-04_JPRB,0.30337E-04_JPRB /)  
KB(:, 2,54, 6) = (/ &
 & 0.94270E-05_JPRB,0.57982E-04_JPRB,0.65461E-04_JPRB,0.63579E-04_JPRB,0.35439E-04_JPRB /)  
KB(:, 3,54, 6) = (/ &
 & 0.12173E-04_JPRB,0.69671E-04_JPRB,0.79433E-04_JPRB,0.77530E-04_JPRB,0.41618E-04_JPRB /)  
KB(:, 4,54, 6) = (/ &
 & 0.15195E-04_JPRB,0.84502E-04_JPRB,0.97826E-04_JPRB,0.96029E-04_JPRB,0.49017E-04_JPRB /)  
KB(:, 5,54, 6) = (/ &
 & 0.18243E-04_JPRB,0.10358E-03_JPRB,0.12196E-03_JPRB,0.12023E-03_JPRB,0.57880E-04_JPRB /)  
KB(:, 1,55, 6) = (/ &
 & 0.54549E-05_JPRB,0.39521E-04_JPRB,0.44580E-04_JPRB,0.42901E-04_JPRB,0.24523E-04_JPRB /)  
KB(:, 2,55, 6) = (/ &
 & 0.73474E-05_JPRB,0.47258E-04_JPRB,0.53311E-04_JPRB,0.51627E-04_JPRB,0.28799E-04_JPRB /)  
KB(:, 3,55, 6) = (/ &
 & 0.95818E-05_JPRB,0.57041E-04_JPRB,0.64957E-04_JPRB,0.63210E-04_JPRB,0.34015E-04_JPRB /)  
KB(:, 4,55, 6) = (/ &
 & 0.12078E-04_JPRB,0.69528E-04_JPRB,0.80422E-04_JPRB,0.78845E-04_JPRB,0.40325E-04_JPRB /)  
KB(:, 5,55, 6) = (/ &
 & 0.14658E-04_JPRB,0.85891E-04_JPRB,0.10087E-03_JPRB,0.99485E-04_JPRB,0.47973E-04_JPRB /)  
KB(:, 1,56, 6) = (/ &
 & 0.41972E-05_JPRB,0.31935E-04_JPRB,0.36125E-04_JPRB,0.34628E-04_JPRB,0.19758E-04_JPRB /)  
KB(:, 2,56, 6) = (/ &
 & 0.56951E-05_JPRB,0.38357E-04_JPRB,0.43303E-04_JPRB,0.41823E-04_JPRB,0.23341E-04_JPRB /)  
KB(:, 3,56, 6) = (/ &
 & 0.75109E-05_JPRB,0.46586E-04_JPRB,0.52984E-04_JPRB,0.51438E-04_JPRB,0.27705E-04_JPRB /)  
KB(:, 4,56, 6) = (/ &
 & 0.95701E-05_JPRB,0.57135E-04_JPRB,0.66020E-04_JPRB,0.64513E-04_JPRB,0.33090E-04_JPRB /)  
KB(:, 5,56, 6) = (/ &
 & 0.11741E-04_JPRB,0.70996E-04_JPRB,0.83348E-04_JPRB,0.82172E-04_JPRB,0.39639E-04_JPRB /)  
KB(:, 1,57, 6) = (/ &
 & 0.32187E-05_JPRB,0.25710E-04_JPRB,0.29175E-04_JPRB,0.27903E-04_JPRB,0.15874E-04_JPRB /)  
KB(:, 2,57, 6) = (/ &
 & 0.44067E-05_JPRB,0.31037E-04_JPRB,0.35094E-04_JPRB,0.33812E-04_JPRB,0.18857E-04_JPRB /)  
KB(:, 3,57, 6) = (/ &
 & 0.58663E-05_JPRB,0.37889E-04_JPRB,0.43100E-04_JPRB,0.41766E-04_JPRB,0.22502E-04_JPRB /)  
KB(:, 4,57, 6) = (/ &
 & 0.75519E-05_JPRB,0.46817E-04_JPRB,0.54053E-04_JPRB,0.52634E-04_JPRB,0.27030E-04_JPRB /)  
KB(:, 5,57, 6) = (/ &
 & 0.93649E-05_JPRB,0.58529E-04_JPRB,0.68705E-04_JPRB,0.67601E-04_JPRB,0.32661E-04_JPRB /)  
KB(:, 1,58, 6) = (/ &
 & 0.24696E-05_JPRB,0.20698E-04_JPRB,0.23574E-04_JPRB,0.22507E-04_JPRB,0.12764E-04_JPRB /)  
KB(:, 2,58, 6) = (/ &
 & 0.34175E-05_JPRB,0.25141E-04_JPRB,0.28438E-04_JPRB,0.27351E-04_JPRB,0.15243E-04_JPRB /)  
KB(:, 3,58, 6) = (/ &
 & 0.45825E-05_JPRB,0.30855E-04_JPRB,0.35092E-04_JPRB,0.33951E-04_JPRB,0.18275E-04_JPRB /)  
KB(:, 4,58, 6) = (/ &
 & 0.59665E-05_JPRB,0.38392E-04_JPRB,0.44239E-04_JPRB,0.43055E-04_JPRB,0.22112E-04_JPRB /)  
KB(:, 5,58, 6) = (/ &
 & 0.74784E-05_JPRB,0.48383E-04_JPRB,0.56772E-04_JPRB,0.55657E-04_JPRB,0.26900E-04_JPRB /)  
KB(:, 1,59, 6) = (/ &
 & 0.20113E-05_JPRB,0.17223E-04_JPRB,0.19628E-04_JPRB,0.18772E-04_JPRB,0.10576E-04_JPRB /)  
KB(:, 2,59, 6) = (/ &
 & 0.27973E-05_JPRB,0.21075E-04_JPRB,0.23849E-04_JPRB,0.22960E-04_JPRB,0.12702E-04_JPRB /)  
KB(:, 3,59, 6) = (/ &
 & 0.37714E-05_JPRB,0.26064E-04_JPRB,0.29696E-04_JPRB,0.28726E-04_JPRB,0.15326E-04_JPRB /)  
KB(:, 4,59, 6) = (/ &
 & 0.49189E-05_JPRB,0.32724E-04_JPRB,0.37808E-04_JPRB,0.36791E-04_JPRB,0.18710E-04_JPRB /)  
KB(:, 5,59, 6) = (/ &
 & 0.61850E-05_JPRB,0.41676E-04_JPRB,0.49043E-04_JPRB,0.48051E-04_JPRB,0.22936E-04_JPRB /)  
KB(:, 1,13, 7) = (/ &
 & 0.90574E-01_JPRB,0.18508E+00_JPRB,0.20125E+00_JPRB,0.19353E+00_JPRB,0.13590E+00_JPRB /)  
KB(:, 2,13, 7) = (/ &
 & 0.96633E-01_JPRB,0.18856E+00_JPRB,0.20514E+00_JPRB,0.19781E+00_JPRB,0.13867E+00_JPRB /)  
KB(:, 3,13, 7) = (/ &
 & 0.10246E+00_JPRB,0.19231E+00_JPRB,0.20916E+00_JPRB,0.20175E+00_JPRB,0.14157E+00_JPRB /)  
KB(:, 4,13, 7) = (/ &
 & 0.10831E+00_JPRB,0.19664E+00_JPRB,0.21340E+00_JPRB,0.20566E+00_JPRB,0.14422E+00_JPRB /)  
KB(:, 5,13, 7) = (/ &
 & 0.11418E+00_JPRB,0.20190E+00_JPRB,0.21829E+00_JPRB,0.20964E+00_JPRB,0.14715E+00_JPRB /)  
KB(:, 1,14, 7) = (/ &
 & 0.76731E-01_JPRB,0.15637E+00_JPRB,0.17031E+00_JPRB,0.16454E+00_JPRB,0.11471E+00_JPRB /)  
KB(:, 2,14, 7) = (/ &
 & 0.81853E-01_JPRB,0.15935E+00_JPRB,0.17367E+00_JPRB,0.16809E+00_JPRB,0.11738E+00_JPRB /)  
KB(:, 3,14, 7) = (/ &
 & 0.86939E-01_JPRB,0.16284E+00_JPRB,0.17719E+00_JPRB,0.17151E+00_JPRB,0.11993E+00_JPRB /)  
KB(:, 4,14, 7) = (/ &
 & 0.91985E-01_JPRB,0.16698E+00_JPRB,0.18115E+00_JPRB,0.17500E+00_JPRB,0.12254E+00_JPRB /)  
KB(:, 5,14, 7) = (/ &
 & 0.97005E-01_JPRB,0.17199E+00_JPRB,0.18590E+00_JPRB,0.17860E+00_JPRB,0.12524E+00_JPRB /)  
KB(:, 1,15, 7) = (/ &
 & 0.64796E-01_JPRB,0.13180E+00_JPRB,0.14379E+00_JPRB,0.13927E+00_JPRB,0.96282E-01_JPRB /)  
KB(:, 2,15, 7) = (/ &
 & 0.69175E-01_JPRB,0.13451E+00_JPRB,0.14669E+00_JPRB,0.14230E+00_JPRB,0.98702E-01_JPRB /)  
KB(:, 3,15, 7) = (/ &
 & 0.73574E-01_JPRB,0.13779E+00_JPRB,0.14991E+00_JPRB,0.14533E+00_JPRB,0.10111E+00_JPRB /)  
KB(:, 4,15, 7) = (/ &
 & 0.77907E-01_JPRB,0.14175E+00_JPRB,0.15375E+00_JPRB,0.14848E+00_JPRB,0.10336E+00_JPRB /)  
KB(:, 5,15, 7) = (/ &
 & 0.82082E-01_JPRB,0.14644E+00_JPRB,0.15826E+00_JPRB,0.15192E+00_JPRB,0.10558E+00_JPRB /)  
KB(:, 1,16, 7) = (/ &
 & 0.54603E-01_JPRB,0.11092E+00_JPRB,0.12113E+00_JPRB,0.11747E+00_JPRB,0.80564E-01_JPRB /)  
KB(:, 2,16, 7) = (/ &
 & 0.58392E-01_JPRB,0.11343E+00_JPRB,0.12376E+00_JPRB,0.12011E+00_JPRB,0.82662E-01_JPRB /)  
KB(:, 3,16, 7) = (/ &
 & 0.62149E-01_JPRB,0.11652E+00_JPRB,0.12680E+00_JPRB,0.12283E+00_JPRB,0.84744E-01_JPRB /)  
KB(:, 4,16, 7) = (/ &
 & 0.65779E-01_JPRB,0.12031E+00_JPRB,0.13049E+00_JPRB,0.12576E+00_JPRB,0.86806E-01_JPRB /)  
KB(:, 5,16, 7) = (/ &
 & 0.69275E-01_JPRB,0.12462E+00_JPRB,0.13474E+00_JPRB,0.12909E+00_JPRB,0.88592E-01_JPRB /)  
KB(:, 1,17, 7) = (/ &
 & 0.46019E-01_JPRB,0.93276E-01_JPRB,0.10182E+00_JPRB,0.98886E-01_JPRB,0.67386E-01_JPRB /)  
KB(:, 2,17, 7) = (/ &
 & 0.49257E-01_JPRB,0.95617E-01_JPRB,0.10427E+00_JPRB,0.10122E+00_JPRB,0.69214E-01_JPRB /)  
KB(:, 3,17, 7) = (/ &
 & 0.52438E-01_JPRB,0.98544E-01_JPRB,0.10723E+00_JPRB,0.10369E+00_JPRB,0.71047E-01_JPRB /)  
KB(:, 4,17, 7) = (/ &
 & 0.55444E-01_JPRB,0.10204E+00_JPRB,0.11074E+00_JPRB,0.10647E+00_JPRB,0.72809E-01_JPRB /)  
KB(:, 5,17, 7) = (/ &
 & 0.58360E-01_JPRB,0.10585E+00_JPRB,0.11469E+00_JPRB,0.10967E+00_JPRB,0.74297E-01_JPRB /)  
KB(:, 1,18, 7) = (/ &
 & 0.38789E-01_JPRB,0.78385E-01_JPRB,0.85426E-01_JPRB,0.83127E-01_JPRB,0.56424E-01_JPRB /)  
KB(:, 2,18, 7) = (/ &
 & 0.41550E-01_JPRB,0.80626E-01_JPRB,0.87775E-01_JPRB,0.85216E-01_JPRB,0.58103E-01_JPRB /)  
KB(:, 3,18, 7) = (/ &
 & 0.44172E-01_JPRB,0.83391E-01_JPRB,0.90633E-01_JPRB,0.87547E-01_JPRB,0.59665E-01_JPRB /)  
KB(:, 4,18, 7) = (/ &
 & 0.46672E-01_JPRB,0.86541E-01_JPRB,0.93910E-01_JPRB,0.90224E-01_JPRB,0.61155E-01_JPRB /)  
KB(:, 5,18, 7) = (/ &
 & 0.49119E-01_JPRB,0.89890E-01_JPRB,0.97478E-01_JPRB,0.93171E-01_JPRB,0.62440E-01_JPRB /)  
KB(:, 1,19, 7) = (/ &
 & 0.32688E-01_JPRB,0.65866E-01_JPRB,0.71699E-01_JPRB,0.69831E-01_JPRB,0.47341E-01_JPRB /)  
KB(:, 2,19, 7) = (/ &
 & 0.34993E-01_JPRB,0.67987E-01_JPRB,0.73938E-01_JPRB,0.71758E-01_JPRB,0.48787E-01_JPRB /)  
KB(:, 3,19, 7) = (/ &
 & 0.37158E-01_JPRB,0.70566E-01_JPRB,0.76608E-01_JPRB,0.73972E-01_JPRB,0.50204E-01_JPRB /)  
KB(:, 4,19, 7) = (/ &
 & 0.39257E-01_JPRB,0.73365E-01_JPRB,0.79594E-01_JPRB,0.76458E-01_JPRB,0.51459E-01_JPRB /)  
KB(:, 5,19, 7) = (/ &
 & 0.41326E-01_JPRB,0.76343E-01_JPRB,0.82757E-01_JPRB,0.79138E-01_JPRB,0.52598E-01_JPRB /)  
KB(:, 1,20, 7) = (/ &
 & 0.27557E-01_JPRB,0.55396E-01_JPRB,0.60366E-01_JPRB,0.58674E-01_JPRB,0.39775E-01_JPRB /)  
KB(:, 2,20, 7) = (/ &
 & 0.29458E-01_JPRB,0.57423E-01_JPRB,0.62478E-01_JPRB,0.60497E-01_JPRB,0.41091E-01_JPRB /)  
KB(:, 3,20, 7) = (/ &
 & 0.31261E-01_JPRB,0.59745E-01_JPRB,0.64927E-01_JPRB,0.62579E-01_JPRB,0.42317E-01_JPRB /)  
KB(:, 4,20, 7) = (/ &
 & 0.33046E-01_JPRB,0.62240E-01_JPRB,0.67549E-01_JPRB,0.64853E-01_JPRB,0.43439E-01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART21',1,ZHOOK_HANDLE)
END SUBROUTINE PART21


SUBROUTINE PART22

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART22',0,ZHOOK_HANDLE)


KB(:, 5,20, 7) = (/ &
 & 0.34818E-01_JPRB,0.64890E-01_JPRB,0.70320E-01_JPRB,0.67290E-01_JPRB,0.44513E-01_JPRB /)  
KB(:, 1,21, 7) = (/ &
 & 0.23194E-01_JPRB,0.46662E-01_JPRB,0.50879E-01_JPRB,0.49331E-01_JPRB,0.33429E-01_JPRB /)  
KB(:, 2,21, 7) = (/ &
 & 0.24776E-01_JPRB,0.48529E-01_JPRB,0.52871E-01_JPRB,0.51054E-01_JPRB,0.34590E-01_JPRB /)  
KB(:, 3,21, 7) = (/ &
 & 0.26303E-01_JPRB,0.50578E-01_JPRB,0.55098E-01_JPRB,0.52980E-01_JPRB,0.35684E-01_JPRB /)  
KB(:, 4,21, 7) = (/ &
 & 0.27810E-01_JPRB,0.52793E-01_JPRB,0.57429E-01_JPRB,0.55052E-01_JPRB,0.36688E-01_JPRB /)  
KB(:, 5,21, 7) = (/ &
 & 0.29323E-01_JPRB,0.55187E-01_JPRB,0.59853E-01_JPRB,0.57245E-01_JPRB,0.37657E-01_JPRB /)  
KB(:, 1,22, 7) = (/ &
 & 0.19600E-01_JPRB,0.39448E-01_JPRB,0.43057E-01_JPRB,0.41623E-01_JPRB,0.28169E-01_JPRB /)  
KB(:, 2,22, 7) = (/ &
 & 0.20910E-01_JPRB,0.41135E-01_JPRB,0.44924E-01_JPRB,0.43250E-01_JPRB,0.29188E-01_JPRB /)  
KB(:, 3,22, 7) = (/ &
 & 0.22195E-01_JPRB,0.42970E-01_JPRB,0.46916E-01_JPRB,0.45021E-01_JPRB,0.30138E-01_JPRB /)  
KB(:, 4,22, 7) = (/ &
 & 0.23466E-01_JPRB,0.44963E-01_JPRB,0.48978E-01_JPRB,0.46906E-01_JPRB,0.31021E-01_JPRB /)  
KB(:, 5,22, 7) = (/ &
 & 0.24791E-01_JPRB,0.47151E-01_JPRB,0.51143E-01_JPRB,0.48901E-01_JPRB,0.31919E-01_JPRB /)  
KB(:, 1,23, 7) = (/ &
 & 0.16563E-01_JPRB,0.33405E-01_JPRB,0.36517E-01_JPRB,0.35235E-01_JPRB,0.23758E-01_JPRB /)  
KB(:, 2,23, 7) = (/ &
 & 0.17634E-01_JPRB,0.34920E-01_JPRB,0.38215E-01_JPRB,0.36726E-01_JPRB,0.24656E-01_JPRB /)  
KB(:, 3,23, 7) = (/ &
 & 0.18715E-01_JPRB,0.36571E-01_JPRB,0.39976E-01_JPRB,0.38337E-01_JPRB,0.25473E-01_JPRB /)  
KB(:, 4,23, 7) = (/ &
 & 0.19810E-01_JPRB,0.38397E-01_JPRB,0.41828E-01_JPRB,0.40046E-01_JPRB,0.26273E-01_JPRB /)  
KB(:, 5,23, 7) = (/ &
 & 0.20990E-01_JPRB,0.40406E-01_JPRB,0.43840E-01_JPRB,0.41881E-01_JPRB,0.27068E-01_JPRB /)  
KB(:, 1,24, 7) = (/ &
 & 0.13980E-01_JPRB,0.28346E-01_JPRB,0.31027E-01_JPRB,0.29909E-01_JPRB,0.20058E-01_JPRB /)  
KB(:, 2,24, 7) = (/ &
 & 0.14874E-01_JPRB,0.29707E-01_JPRB,0.32546E-01_JPRB,0.31266E-01_JPRB,0.20839E-01_JPRB /)  
KB(:, 3,24, 7) = (/ &
 & 0.15797E-01_JPRB,0.31204E-01_JPRB,0.34123E-01_JPRB,0.32728E-01_JPRB,0.21557E-01_JPRB /)  
KB(:, 4,24, 7) = (/ &
 & 0.16758E-01_JPRB,0.32875E-01_JPRB,0.35824E-01_JPRB,0.34296E-01_JPRB,0.22274E-01_JPRB /)  
KB(:, 5,24, 7) = (/ &
 & 0.17809E-01_JPRB,0.34737E-01_JPRB,0.37711E-01_JPRB,0.35981E-01_JPRB,0.22992E-01_JPRB /)  
KB(:, 1,25, 7) = (/ &
 & 0.11798E-01_JPRB,0.24110E-01_JPRB,0.26426E-01_JPRB,0.25457E-01_JPRB,0.16985E-01_JPRB /)  
KB(:, 2,25, 7) = (/ &
 & 0.12561E-01_JPRB,0.25347E-01_JPRB,0.27781E-01_JPRB,0.26691E-01_JPRB,0.17655E-01_JPRB /)  
KB(:, 3,25, 7) = (/ &
 & 0.13359E-01_JPRB,0.26711E-01_JPRB,0.29222E-01_JPRB,0.28026E-01_JPRB,0.18302E-01_JPRB /)  
KB(:, 4,25, 7) = (/ &
 & 0.14208E-01_JPRB,0.28241E-01_JPRB,0.30806E-01_JPRB,0.29472E-01_JPRB,0.18949E-01_JPRB /)  
KB(:, 5,25, 7) = (/ &
 & 0.15157E-01_JPRB,0.29980E-01_JPRB,0.32597E-01_JPRB,0.31029E-01_JPRB,0.19596E-01_JPRB /)  
KB(:, 1,26, 7) = (/ &
 & 0.99745E-02_JPRB,0.20581E-01_JPRB,0.22580E-01_JPRB,0.21746E-01_JPRB,0.14432E-01_JPRB /)  
KB(:, 2,26, 7) = (/ &
 & 0.10633E-01_JPRB,0.21703E-01_JPRB,0.23807E-01_JPRB,0.22873E-01_JPRB,0.15014E-01_JPRB /)  
KB(:, 3,26, 7) = (/ &
 & 0.11328E-01_JPRB,0.22948E-01_JPRB,0.25141E-01_JPRB,0.24108E-01_JPRB,0.15588E-01_JPRB /)  
KB(:, 4,26, 7) = (/ &
 & 0.12091E-01_JPRB,0.24380E-01_JPRB,0.26636E-01_JPRB,0.25439E-01_JPRB,0.16180E-01_JPRB /)  
KB(:, 5,26, 7) = (/ &
 & 0.12943E-01_JPRB,0.26016E-01_JPRB,0.28335E-01_JPRB,0.26899E-01_JPRB,0.16787E-01_JPRB /)  
KB(:, 1,27, 7) = (/ &
 & 0.84424E-02_JPRB,0.17603E-01_JPRB,0.19348E-01_JPRB,0.18632E-01_JPRB,0.12275E-01_JPRB /)  
KB(:, 2,27, 7) = (/ &
 & 0.90172E-02_JPRB,0.18627E-01_JPRB,0.20475E-01_JPRB,0.19670E-01_JPRB,0.12796E-01_JPRB /)  
KB(:, 3,27, 7) = (/ &
 & 0.96344E-02_JPRB,0.19791E-01_JPRB,0.21724E-01_JPRB,0.20817E-01_JPRB,0.13316E-01_JPRB /)  
KB(:, 4,27, 7) = (/ &
 & 0.10319E-01_JPRB,0.21143E-01_JPRB,0.23141E-01_JPRB,0.22059E-01_JPRB,0.13859E-01_JPRB /)  
KB(:, 5,27, 7) = (/ &
 & 0.11083E-01_JPRB,0.22688E-01_JPRB,0.24742E-01_JPRB,0.23449E-01_JPRB,0.14418E-01_JPRB /)  
KB(:, 1,28, 7) = (/ &
 & 0.71594E-02_JPRB,0.15094E-01_JPRB,0.16638E-01_JPRB,0.16016E-01_JPRB,0.10452E-01_JPRB /)  
KB(:, 2,28, 7) = (/ &
 & 0.76603E-02_JPRB,0.16043E-01_JPRB,0.17678E-01_JPRB,0.16989E-01_JPRB,0.10928E-01_JPRB /)  
KB(:, 3,28, 7) = (/ &
 & 0.82161E-02_JPRB,0.17148E-01_JPRB,0.18856E-01_JPRB,0.18055E-01_JPRB,0.11409E-01_JPRB /)  
KB(:, 4,28, 7) = (/ &
 & 0.88297E-02_JPRB,0.18429E-01_JPRB,0.20193E-01_JPRB,0.19234E-01_JPRB,0.11908E-01_JPRB /)  
KB(:, 5,28, 7) = (/ &
 & 0.95210E-02_JPRB,0.19896E-01_JPRB,0.21697E-01_JPRB,0.20565E-01_JPRB,0.12423E-01_JPRB /)  
KB(:, 1,29, 7) = (/ &
 & 0.60865E-02_JPRB,0.12992E-01_JPRB,0.14367E-01_JPRB,0.13830E-01_JPRB,0.89337E-02_JPRB /)  
KB(:, 2,29, 7) = (/ &
 & 0.65273E-02_JPRB,0.13894E-01_JPRB,0.15342E-01_JPRB,0.14741E-01_JPRB,0.93649E-02_JPRB /)  
KB(:, 3,29, 7) = (/ &
 & 0.70278E-02_JPRB,0.14949E-01_JPRB,0.16457E-01_JPRB,0.15746E-01_JPRB,0.98158E-02_JPRB /)  
KB(:, 4,29, 7) = (/ &
 & 0.75858E-02_JPRB,0.16169E-01_JPRB,0.17720E-01_JPRB,0.16877E-01_JPRB,0.10273E-01_JPRB /)  
KB(:, 5,29, 7) = (/ &
 & 0.82154E-02_JPRB,0.17564E-01_JPRB,0.19150E-01_JPRB,0.18159E-01_JPRB,0.10745E-01_JPRB /)  
KB(:, 1,30, 7) = (/ &
 & 0.51820E-02_JPRB,0.11236E-01_JPRB,0.12459E-01_JPRB,0.12000E-01_JPRB,0.76507E-02_JPRB /)  
KB(:, 2,30, 7) = (/ &
 & 0.55811E-02_JPRB,0.12098E-01_JPRB,0.13380E-01_JPRB,0.12854E-01_JPRB,0.80497E-02_JPRB /)  
KB(:, 3,30, 7) = (/ &
 & 0.60310E-02_JPRB,0.13108E-01_JPRB,0.14440E-01_JPRB,0.13813E-01_JPRB,0.84648E-02_JPRB /)  
KB(:, 4,30, 7) = (/ &
 & 0.65404E-02_JPRB,0.14273E-01_JPRB,0.15644E-01_JPRB,0.14905E-01_JPRB,0.88882E-02_JPRB /)  
KB(:, 5,30, 7) = (/ &
 & 0.71170E-02_JPRB,0.15597E-01_JPRB,0.17012E-01_JPRB,0.16134E-01_JPRB,0.93248E-02_JPRB /)  
KB(:, 1,31, 7) = (/ &
 & 0.44272E-02_JPRB,0.97757E-02_JPRB,0.10859E-01_JPRB,0.10467E-01_JPRB,0.65734E-02_JPRB /)  
KB(:, 2,31, 7) = (/ &
 & 0.47878E-02_JPRB,0.10603E-01_JPRB,0.11740E-01_JPRB,0.11277E-01_JPRB,0.69415E-02_JPRB /)  
KB(:, 3,31, 7) = (/ &
 & 0.51963E-02_JPRB,0.11572E-01_JPRB,0.12753E-01_JPRB,0.12201E-01_JPRB,0.73188E-02_JPRB /)  
KB(:, 4,31, 7) = (/ &
 & 0.56609E-02_JPRB,0.12684E-01_JPRB,0.13904E-01_JPRB,0.13252E-01_JPRB,0.77091E-02_JPRB /)  
KB(:, 5,31, 7) = (/ &
 & 0.61977E-02_JPRB,0.13944E-01_JPRB,0.15244E-01_JPRB,0.14424E-01_JPRB,0.81161E-02_JPRB /)  
KB(:, 1,32, 7) = (/ &
 & 0.37962E-02_JPRB,0.85614E-02_JPRB,0.95233E-02_JPRB,0.91812E-02_JPRB,0.56658E-02_JPRB /)  
KB(:, 2,32, 7) = (/ &
 & 0.41228E-02_JPRB,0.93595E-02_JPRB,0.10368E-01_JPRB,0.99574E-02_JPRB,0.60000E-02_JPRB /)  
KB(:, 3,32, 7) = (/ &
 & 0.44947E-02_JPRB,0.10287E-01_JPRB,0.11338E-01_JPRB,0.10850E-01_JPRB,0.63462E-02_JPRB /)  
KB(:, 4,32, 7) = (/ &
 & 0.49244E-02_JPRB,0.11349E-01_JPRB,0.12467E-01_JPRB,0.11857E-01_JPRB,0.67069E-02_JPRB /)  
KB(:, 5,32, 7) = (/ &
 & 0.54252E-02_JPRB,0.12554E-01_JPRB,0.13767E-01_JPRB,0.12983E-01_JPRB,0.70910E-02_JPRB /)  
KB(:, 1,33, 7) = (/ &
 & 0.32656E-02_JPRB,0.75519E-02_JPRB,0.84026E-02_JPRB,0.81028E-02_JPRB,0.48937E-02_JPRB /)  
KB(:, 2,33, 7) = (/ &
 & 0.35630E-02_JPRB,0.83178E-02_JPRB,0.92157E-02_JPRB,0.88531E-02_JPRB,0.52004E-02_JPRB /)  
KB(:, 3,33, 7) = (/ &
 & 0.39050E-02_JPRB,0.92063E-02_JPRB,0.10168E-01_JPRB,0.97125E-02_JPRB,0.55156E-02_JPRB /)  
KB(:, 4,33, 7) = (/ &
 & 0.43055E-02_JPRB,0.10227E-01_JPRB,0.11270E-01_JPRB,0.10682E-01_JPRB,0.58516E-02_JPRB /)  
KB(:, 5,33, 7) = (/ &
 & 0.47651E-02_JPRB,0.11396E-01_JPRB,0.12524E-01_JPRB,0.11769E-01_JPRB,0.62091E-02_JPRB /)  
KB(:, 1,34, 7) = (/ &
 & 0.28105E-02_JPRB,0.66873E-02_JPRB,0.74405E-02_JPRB,0.71742E-02_JPRB,0.42413E-02_JPRB /)  
KB(:, 2,34, 7) = (/ &
 & 0.30819E-02_JPRB,0.74197E-02_JPRB,0.82328E-02_JPRB,0.78962E-02_JPRB,0.45189E-02_JPRB /)  
KB(:, 3,34, 7) = (/ &
 & 0.33974E-02_JPRB,0.82731E-02_JPRB,0.91582E-02_JPRB,0.87214E-02_JPRB,0.48133E-02_JPRB /)  
KB(:, 4,34, 7) = (/ &
 & 0.37682E-02_JPRB,0.92558E-02_JPRB,0.10225E-01_JPRB,0.96550E-02_JPRB,0.51300E-02_JPRB /)  
KB(:, 5,34, 7) = (/ &
 & 0.41836E-02_JPRB,0.10408E-01_JPRB,0.11429E-01_JPRB,0.10709E-01_JPRB,0.54671E-02_JPRB /)  
KB(:, 1,35, 7) = (/ &
 & 0.24038E-02_JPRB,0.58948E-02_JPRB,0.65709E-02_JPRB,0.63304E-02_JPRB,0.36544E-02_JPRB /)  
KB(:, 2,35, 7) = (/ &
 & 0.26483E-02_JPRB,0.65885E-02_JPRB,0.73295E-02_JPRB,0.70175E-02_JPRB,0.39080E-02_JPRB /)  
KB(:, 3,35, 7) = (/ &
 & 0.29372E-02_JPRB,0.74016E-02_JPRB,0.82197E-02_JPRB,0.78032E-02_JPRB,0.41855E-02_JPRB /)  
KB(:, 4,35, 7) = (/ &
 & 0.32728E-02_JPRB,0.83531E-02_JPRB,0.92365E-02_JPRB,0.86973E-02_JPRB,0.44777E-02_JPRB /)  
KB(:, 5,35, 7) = (/ &
 & 0.36421E-02_JPRB,0.94681E-02_JPRB,0.10387E-01_JPRB,0.97145E-02_JPRB,0.47967E-02_JPRB /)  
KB(:, 1,36, 7) = (/ &
 & 0.20373E-02_JPRB,0.51550E-02_JPRB,0.57662E-02_JPRB,0.55498E-02_JPRB,0.31231E-02_JPRB /)  
KB(:, 2,36, 7) = (/ &
 & 0.22554E-02_JPRB,0.58057E-02_JPRB,0.64818E-02_JPRB,0.61953E-02_JPRB,0.33549E-02_JPRB /)  
KB(:, 3,36, 7) = (/ &
 & 0.25127E-02_JPRB,0.65796E-02_JPRB,0.73228E-02_JPRB,0.69361E-02_JPRB,0.36112E-02_JPRB /)  
KB(:, 4,36, 7) = (/ &
 & 0.28104E-02_JPRB,0.74827E-02_JPRB,0.82833E-02_JPRB,0.77843E-02_JPRB,0.38823E-02_JPRB /)  
KB(:, 5,36, 7) = (/ &
 & 0.31359E-02_JPRB,0.85467E-02_JPRB,0.93763E-02_JPRB,0.87575E-02_JPRB,0.41812E-02_JPRB /)  
KB(:, 1,37, 7) = (/ &
 & 0.17035E-02_JPRB,0.44466E-02_JPRB,0.49856E-02_JPRB,0.47970E-02_JPRB,0.26734E-02_JPRB /)  
KB(:, 2,37, 7) = (/ &
 & 0.18934E-02_JPRB,0.50433E-02_JPRB,0.56462E-02_JPRB,0.53907E-02_JPRB,0.28873E-02_JPRB /)  
KB(:, 3,37, 7) = (/ &
 & 0.21171E-02_JPRB,0.57558E-02_JPRB,0.64223E-02_JPRB,0.60783E-02_JPRB,0.31233E-02_JPRB /)  
KB(:, 4,37, 7) = (/ &
 & 0.23767E-02_JPRB,0.65938E-02_JPRB,0.73141E-02_JPRB,0.68717E-02_JPRB,0.33760E-02_JPRB /)  
KB(:, 5,37, 7) = (/ &
 & 0.26616E-02_JPRB,0.75860E-02_JPRB,0.83359E-02_JPRB,0.77859E-02_JPRB,0.36530E-02_JPRB /)  
KB(:, 1,38, 7) = (/ &
 & 0.14234E-02_JPRB,0.38379E-02_JPRB,0.43139E-02_JPRB,0.41486E-02_JPRB,0.22904E-02_JPRB /)  
KB(:, 2,38, 7) = (/ &
 & 0.15875E-02_JPRB,0.43850E-02_JPRB,0.49236E-02_JPRB,0.46956E-02_JPRB,0.24873E-02_JPRB /)  
KB(:, 3,38, 7) = (/ &
 & 0.17824E-02_JPRB,0.50419E-02_JPRB,0.56400E-02_JPRB,0.53338E-02_JPRB,0.27024E-02_JPRB /)  
KB(:, 4,38, 7) = (/ &
 & 0.20080E-02_JPRB,0.58195E-02_JPRB,0.64682E-02_JPRB,0.60767E-02_JPRB,0.29386E-02_JPRB /)  
KB(:, 5,38, 7) = (/ &
 & 0.22567E-02_JPRB,0.67445E-02_JPRB,0.74253E-02_JPRB,0.69357E-02_JPRB,0.31979E-02_JPRB /)  
KB(:, 1,39, 7) = (/ &
 & 0.11890E-02_JPRB,0.33180E-02_JPRB,0.37396E-02_JPRB,0.35935E-02_JPRB,0.19623E-02_JPRB /)  
KB(:, 2,39, 7) = (/ &
 & 0.13309E-02_JPRB,0.38204E-02_JPRB,0.43017E-02_JPRB,0.40980E-02_JPRB,0.21427E-02_JPRB /)  
KB(:, 3,39, 7) = (/ &
 & 0.14997E-02_JPRB,0.44279E-02_JPRB,0.49653E-02_JPRB,0.46926E-02_JPRB,0.23415E-02_JPRB /)  
KB(:, 4,39, 7) = (/ &
 & 0.16956E-02_JPRB,0.51508E-02_JPRB,0.57361E-02_JPRB,0.53891E-02_JPRB,0.25595E-02_JPRB /)  
KB(:, 5,39, 7) = (/ &
 & 0.19128E-02_JPRB,0.60136E-02_JPRB,0.66353E-02_JPRB,0.61975E-02_JPRB,0.28034E-02_JPRB /)  
KB(:, 1,40, 7) = (/ &
 & 0.98185E-03_JPRB,0.28304E-02_JPRB,0.31989E-02_JPRB,0.30741E-02_JPRB,0.16759E-02_JPRB /)  
KB(:, 2,40, 7) = (/ &
 & 0.11018E-02_JPRB,0.32825E-02_JPRB,0.37073E-02_JPRB,0.35318E-02_JPRB,0.18412E-02_JPRB /)  
KB(:, 3,40, 7) = (/ &
 & 0.12459E-02_JPRB,0.38338E-02_JPRB,0.43125E-02_JPRB,0.40771E-02_JPRB,0.20230E-02_JPRB /)  
KB(:, 4,40, 7) = (/ &
 & 0.14138E-02_JPRB,0.44950E-02_JPRB,0.50204E-02_JPRB,0.47198E-02_JPRB,0.22264E-02_JPRB /)  
KB(:, 5,40, 7) = (/ &
 & 0.16015E-02_JPRB,0.52867E-02_JPRB,0.58524E-02_JPRB,0.54701E-02_JPRB,0.24538E-02_JPRB /)  
KB(:, 1,41, 7) = (/ &
 & 0.80888E-03_JPRB,0.24101E-02_JPRB,0.27302E-02_JPRB,0.26250E-02_JPRB,0.14285E-02_JPRB /)  
KB(:, 2,41, 7) = (/ &
 & 0.91042E-03_JPRB,0.28166E-02_JPRB,0.31895E-02_JPRB,0.30396E-02_JPRB,0.15812E-02_JPRB /)  
KB(:, 3,41, 7) = (/ &
 & 0.10323E-02_JPRB,0.33144E-02_JPRB,0.37392E-02_JPRB,0.35375E-02_JPRB,0.17482E-02_JPRB /)  
KB(:, 4,41, 7) = (/ &
 & 0.11757E-02_JPRB,0.39172E-02_JPRB,0.43885E-02_JPRB,0.41290E-02_JPRB,0.19366E-02_JPRB /)  
KB(:, 5,41, 7) = (/ &
 & 0.13368E-02_JPRB,0.46417E-02_JPRB,0.51571E-02_JPRB,0.48237E-02_JPRB,0.21455E-02_JPRB /)  
KB(:, 1,42, 7) = (/ &
 & 0.66584E-03_JPRB,0.20506E-02_JPRB,0.23294E-02_JPRB,0.22418E-02_JPRB,0.12147E-02_JPRB /)  
KB(:, 2,42, 7) = (/ &
 & 0.75117E-03_JPRB,0.24164E-02_JPRB,0.27427E-02_JPRB,0.26163E-02_JPRB,0.13552E-02_JPRB /)  
KB(:, 3,42, 7) = (/ &
 & 0.85464E-03_JPRB,0.28657E-02_JPRB,0.32419E-02_JPRB,0.30702E-02_JPRB,0.15103E-02_JPRB /)  
KB(:, 4,42, 7) = (/ &
 & 0.97690E-03_JPRB,0.34148E-02_JPRB,0.38374E-02_JPRB,0.36136E-02_JPRB,0.16836E-02_JPRB /)  
KB(:, 5,42, 7) = (/ &
 & 0.11154E-02_JPRB,0.40777E-02_JPRB,0.45486E-02_JPRB,0.42564E-02_JPRB,0.18765E-02_JPRB /)  
KB(:, 1,43, 7) = (/ &
 & 0.54468E-03_JPRB,0.17260E-02_JPRB,0.19662E-02_JPRB,0.18963E-02_JPRB,0.10278E-02_JPRB /)  
KB(:, 2,43, 7) = (/ &
 & 0.61495E-03_JPRB,0.20517E-02_JPRB,0.23339E-02_JPRB,0.22307E-02_JPRB,0.11544E-02_JPRB /)  
KB(:, 3,43, 7) = (/ &
 & 0.70090E-03_JPRB,0.24526E-02_JPRB,0.27821E-02_JPRB,0.26393E-02_JPRB,0.12972E-02_JPRB /)  
KB(:, 4,43, 7) = (/ &
 & 0.80460E-03_JPRB,0.29460E-02_JPRB,0.33228E-02_JPRB,0.31329E-02_JPRB,0.14583E-02_JPRB /)  
KB(:, 5,43, 7) = (/ &
 & 0.92296E-03_JPRB,0.35462E-02_JPRB,0.39738E-02_JPRB,0.37220E-02_JPRB,0.16369E-02_JPRB /)  
KB(:, 1,44, 7) = (/ &
 & 0.44364E-03_JPRB,0.14437E-02_JPRB,0.16496E-02_JPRB,0.15952E-02_JPRB,0.86540E-03_JPRB /)  
KB(:, 2,44, 7) = (/ &
 & 0.50199E-03_JPRB,0.17304E-02_JPRB,0.19739E-02_JPRB,0.18912E-02_JPRB,0.97937E-03_JPRB /)  
KB(:, 3,44, 7) = (/ &
 & 0.57242E-03_JPRB,0.20860E-02_JPRB,0.23731E-02_JPRB,0.22565E-02_JPRB,0.11106E-02_JPRB /)  
KB(:, 4,44, 7) = (/ &
 & 0.65930E-03_JPRB,0.25283E-02_JPRB,0.28613E-02_JPRB,0.27024E-02_JPRB,0.12573E-02_JPRB /)  
KB(:, 5,44, 7) = (/ &
 & 0.75974E-03_JPRB,0.30673E-02_JPRB,0.34531E-02_JPRB,0.32379E-02_JPRB,0.14238E-02_JPRB /)  
KB(:, 1,45, 7) = (/ &
 & 0.36129E-03_JPRB,0.12055E-02_JPRB,0.13811E-02_JPRB,0.13394E-02_JPRB,0.72668E-03_JPRB /)  
KB(:, 2,45, 7) = (/ &
 & 0.40925E-03_JPRB,0.14558E-02_JPRB,0.16660E-02_JPRB,0.16003E-02_JPRB,0.82937E-03_JPRB /)  
KB(:, 3,45, 7) = (/ &
 & 0.46755E-03_JPRB,0.17705E-02_JPRB,0.20201E-02_JPRB,0.19260E-02_JPRB,0.94755E-03_JPRB /)  
KB(:, 4,45, 7) = (/ &
 & 0.53937E-03_JPRB,0.21654E-02_JPRB,0.24593E-02_JPRB,0.23275E-02_JPRB,0.10822E-02_JPRB /)  
KB(:, 5,45, 7) = (/ &
 & 0.62400E-03_JPRB,0.26505E-02_JPRB,0.29965E-02_JPRB,0.28141E-02_JPRB,0.12345E-02_JPRB /)  
KB(:, 1,46, 7) = (/ &
 & 0.29308E-03_JPRB,0.99917E-03_JPRB,0.11483E-02_JPRB,0.11175E-02_JPRB,0.60699E-03_JPRB /)  
KB(:, 2,46, 7) = (/ &
 & 0.33256E-03_JPRB,0.12167E-02_JPRB,0.13963E-02_JPRB,0.13454E-02_JPRB,0.69810E-03_JPRB /)  
KB(:, 3,46, 7) = (/ &
 & 0.38031E-03_JPRB,0.14933E-02_JPRB,0.17091E-02_JPRB,0.16341E-02_JPRB,0.80431E-03_JPRB /)  
KB(:, 4,46, 7) = (/ &
 & 0.43974E-03_JPRB,0.18423E-02_JPRB,0.21003E-02_JPRB,0.19926E-02_JPRB,0.92607E-03_JPRB /)  
KB(:, 5,46, 7) = (/ &
 & 0.51042E-03_JPRB,0.22760E-02_JPRB,0.25842E-02_JPRB,0.24318E-02_JPRB,0.10656E-02_JPRB /)  
KB(:, 1,47, 7) = (/ &
 & 0.23621E-03_JPRB,0.81920E-03_JPRB,0.94415E-03_JPRB,0.92230E-03_JPRB,0.50239E-03_JPRB /)  
KB(:, 2,47, 7) = (/ &
 & 0.26847E-03_JPRB,0.10045E-02_JPRB,0.11560E-02_JPRB,0.11182E-02_JPRB,0.58268E-03_JPRB /)  
KB(:, 3,47, 7) = (/ &
 & 0.30727E-03_JPRB,0.12442E-02_JPRB,0.14284E-02_JPRB,0.13701E-02_JPRB,0.67654E-03_JPRB /)  
KB(:, 4,47, 7) = (/ &
 & 0.35565E-03_JPRB,0.15479E-02_JPRB,0.17727E-02_JPRB,0.16866E-02_JPRB,0.78602E-03_JPRB /)  
KB(:, 5,47, 7) = (/ &
 & 0.41455E-03_JPRB,0.19320E-02_JPRB,0.22031E-02_JPRB,0.20787E-02_JPRB,0.91297E-03_JPRB /)  
KB(:, 1,48, 7) = (/ &
 & 0.19056E-03_JPRB,0.66912E-03_JPRB,0.77329E-03_JPRB,0.75810E-03_JPRB,0.41434E-03_JPRB /)  
KB(:, 2,48, 7) = (/ &
 & 0.21662E-03_JPRB,0.82638E-03_JPRB,0.95404E-03_JPRB,0.92602E-03_JPRB,0.48448E-03_JPRB /)  
KB(:, 3,48, 7) = (/ &
 & 0.24805E-03_JPRB,0.10324E-02_JPRB,0.11883E-02_JPRB,0.11443E-02_JPRB,0.56714E-03_JPRB /)  
KB(:, 4,48, 7) = (/ &
 & 0.28732E-03_JPRB,0.12967E-02_JPRB,0.14909E-02_JPRB,0.14226E-02_JPRB,0.66465E-03_JPRB /)  
KB(:, 5,48, 7) = (/ &
 & 0.33598E-03_JPRB,0.16339E-02_JPRB,0.18720E-02_JPRB,0.17712E-02_JPRB,0.77925E-03_JPRB /)  
KB(:, 1,49, 7) = (/ &
 & 0.15370E-03_JPRB,0.54435E-03_JPRB,0.63072E-03_JPRB,0.62031E-03_JPRB,0.34039E-03_JPRB /)  
KB(:, 2,49, 7) = (/ &
 & 0.17493E-03_JPRB,0.67703E-03_JPRB,0.78385E-03_JPRB,0.76375E-03_JPRB,0.40110E-03_JPRB /)  
KB(:, 3,49, 7) = (/ &
 & 0.20006E-03_JPRB,0.85331E-03_JPRB,0.98454E-03_JPRB,0.95185E-03_JPRB,0.47334E-03_JPRB /)  
KB(:, 4,49, 7) = (/ &
 & 0.23184E-03_JPRB,0.10822E-02_JPRB,0.12482E-02_JPRB,0.11953E-02_JPRB,0.56021E-03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART22',1,ZHOOK_HANDLE)
END SUBROUTINE PART22


SUBROUTINE PART23

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART23',0,ZHOOK_HANDLE)


KB(:, 5,49, 7) = (/ &
 & 0.27201E-03_JPRB,0.13761E-02_JPRB,0.15848E-02_JPRB,0.15038E-02_JPRB,0.66336E-03_JPRB /)  
KB(:, 1,50, 7) = (/ &
 & 0.12445E-03_JPRB,0.44363E-03_JPRB,0.51558E-03_JPRB,0.50858E-03_JPRB,0.27983E-03_JPRB /)  
KB(:, 2,50, 7) = (/ &
 & 0.14173E-03_JPRB,0.55572E-03_JPRB,0.64516E-03_JPRB,0.63048E-03_JPRB,0.33240E-03_JPRB /)  
KB(:, 3,50, 7) = (/ &
 & 0.16225E-03_JPRB,0.70658E-03_JPRB,0.81789E-03_JPRB,0.79296E-03_JPRB,0.39601E-03_JPRB /)  
KB(:, 4,50, 7) = (/ &
 & 0.18768E-03_JPRB,0.90539E-03_JPRB,0.10468E-02_JPRB,0.10060E-02_JPRB,0.47285E-03_JPRB /)  
KB(:, 5,50, 7) = (/ &
 & 0.22071E-03_JPRB,0.11624E-02_JPRB,0.13446E-02_JPRB,0.12795E-02_JPRB,0.56523E-03_JPRB /)  
KB(:, 1,51, 7) = (/ &
 & 0.10079E-03_JPRB,0.36142E-03_JPRB,0.42089E-03_JPRB,0.41617E-03_JPRB,0.23042E-03_JPRB /)  
KB(:, 2,51, 7) = (/ &
 & 0.11508E-03_JPRB,0.45540E-03_JPRB,0.53023E-03_JPRB,0.51983E-03_JPRB,0.27489E-03_JPRB /)  
KB(:, 3,51, 7) = (/ &
 & 0.13183E-03_JPRB,0.58426E-03_JPRB,0.67873E-03_JPRB,0.65942E-03_JPRB,0.33073E-03_JPRB /)  
KB(:, 4,51, 7) = (/ &
 & 0.15243E-03_JPRB,0.75694E-03_JPRB,0.87652E-03_JPRB,0.84573E-03_JPRB,0.39869E-03_JPRB /)  
KB(:, 5,51, 7) = (/ &
 & 0.17921E-03_JPRB,0.98295E-03_JPRB,0.11402E-02_JPRB,0.10885E-02_JPRB,0.48140E-03_JPRB /)  
KB(:, 1,52, 7) = (/ &
 & 0.81556E-04_JPRB,0.29363E-03_JPRB,0.34244E-03_JPRB,0.33921E-03_JPRB,0.18905E-03_JPRB /)  
KB(:, 2,52, 7) = (/ &
 & 0.93358E-04_JPRB,0.37204E-03_JPRB,0.43415E-03_JPRB,0.42707E-03_JPRB,0.22730E-03_JPRB /)  
KB(:, 3,52, 7) = (/ &
 & 0.10711E-03_JPRB,0.48125E-03_JPRB,0.56095E-03_JPRB,0.54625E-03_JPRB,0.27517E-03_JPRB /)  
KB(:, 4,52, 7) = (/ &
 & 0.12382E-03_JPRB,0.62999E-03_JPRB,0.73195E-03_JPRB,0.70815E-03_JPRB,0.33506E-03_JPRB /)  
KB(:, 5,52, 7) = (/ &
 & 0.14564E-03_JPRB,0.82786E-03_JPRB,0.96258E-03_JPRB,0.92197E-03_JPRB,0.40847E-03_JPRB /)  
KB(:, 1,53, 7) = (/ &
 & 0.65849E-04_JPRB,0.23779E-03_JPRB,0.27734E-03_JPRB,0.27519E-03_JPRB,0.15433E-03_JPRB /)  
KB(:, 2,53, 7) = (/ &
 & 0.75546E-04_JPRB,0.30303E-03_JPRB,0.35410E-03_JPRB,0.34952E-03_JPRB,0.18741E-03_JPRB /)  
KB(:, 3,53, 7) = (/ &
 & 0.86880E-04_JPRB,0.39464E-03_JPRB,0.46133E-03_JPRB,0.45049E-03_JPRB,0.22844E-03_JPRB /)  
KB(:, 4,53, 7) = (/ &
 & 0.10061E-03_JPRB,0.52205E-03_JPRB,0.60866E-03_JPRB,0.59002E-03_JPRB,0.28045E-03_JPRB /)  
KB(:, 5,53, 7) = (/ &
 & 0.11837E-03_JPRB,0.69424E-03_JPRB,0.80911E-03_JPRB,0.77763E-03_JPRB,0.34549E-03_JPRB /)  
KB(:, 1,54, 7) = (/ &
 & 0.53194E-04_JPRB,0.19358E-03_JPRB,0.22554E-03_JPRB,0.22386E-03_JPRB,0.12634E-03_JPRB /)  
KB(:, 2,54, 7) = (/ &
 & 0.61356E-04_JPRB,0.24774E-03_JPRB,0.28991E-03_JPRB,0.28698E-03_JPRB,0.15485E-03_JPRB /)  
KB(:, 3,54, 7) = (/ &
 & 0.70732E-04_JPRB,0.32546E-03_JPRB,0.38104E-03_JPRB,0.37325E-03_JPRB,0.19067E-03_JPRB /)  
KB(:, 4,54, 7) = (/ &
 & 0.81989E-04_JPRB,0.43475E-03_JPRB,0.50842E-03_JPRB,0.49348E-03_JPRB,0.23573E-03_JPRB /)  
KB(:, 5,54, 7) = (/ &
 & 0.96606E-04_JPRB,0.58491E-03_JPRB,0.68358E-03_JPRB,0.65848E-03_JPRB,0.29331E-03_JPRB /)  
KB(:, 1,55, 7) = (/ &
 & 0.42968E-04_JPRB,0.15774E-03_JPRB,0.18351E-03_JPRB,0.18209E-03_JPRB,0.10325E-03_JPRB /)  
KB(:, 2,55, 7) = (/ &
 & 0.49757E-04_JPRB,0.20300E-03_JPRB,0.23752E-03_JPRB,0.23563E-03_JPRB,0.12786E-03_JPRB /)  
KB(:, 3,55, 7) = (/ &
 & 0.57602E-04_JPRB,0.26853E-03_JPRB,0.31476E-03_JPRB,0.30938E-03_JPRB,0.15908E-03_JPRB /)  
KB(:, 4,55, 7) = (/ &
 & 0.66944E-04_JPRB,0.36215E-03_JPRB,0.42458E-03_JPRB,0.41285E-03_JPRB,0.19867E-03_JPRB /)  
KB(:, 5,55, 7) = (/ &
 & 0.78909E-04_JPRB,0.49332E-03_JPRB,0.57794E-03_JPRB,0.55775E-03_JPRB,0.24929E-03_JPRB /)  
KB(:, 1,56, 7) = (/ &
 & 0.34572E-04_JPRB,0.12819E-03_JPRB,0.14868E-03_JPRB,0.14747E-03_JPRB,0.84103E-04_JPRB /)  
KB(:, 2,56, 7) = (/ &
 & 0.40234E-04_JPRB,0.16586E-03_JPRB,0.19409E-03_JPRB,0.19266E-03_JPRB,0.10511E-03_JPRB /)  
KB(:, 3,56, 7) = (/ &
 & 0.46756E-04_JPRB,0.22079E-03_JPRB,0.25905E-03_JPRB,0.25536E-03_JPRB,0.13228E-03_JPRB /)  
KB(:, 4,56, 7) = (/ &
 & 0.54583E-04_JPRB,0.30103E-03_JPRB,0.35315E-03_JPRB,0.34421E-03_JPRB,0.16708E-03_JPRB /)  
KB(:, 5,56, 7) = (/ &
 & 0.64414E-04_JPRB,0.41471E-03_JPRB,0.48701E-03_JPRB,0.47045E-03_JPRB,0.21139E-03_JPRB /)  
KB(:, 1,57, 7) = (/ &
 & 0.27768E-04_JPRB,0.10391E-03_JPRB,0.12029E-03_JPRB,0.11888E-03_JPRB,0.68178E-04_JPRB /)  
KB(:, 2,57, 7) = (/ &
 & 0.32463E-04_JPRB,0.13502E-03_JPRB,0.15785E-03_JPRB,0.15684E-03_JPRB,0.86073E-04_JPRB /)  
KB(:, 3,57, 7) = (/ &
 & 0.37880E-04_JPRB,0.18114E-03_JPRB,0.21255E-03_JPRB,0.20984E-03_JPRB,0.10949E-03_JPRB /)  
KB(:, 4,57, 7) = (/ &
 & 0.44374E-04_JPRB,0.24914E-03_JPRB,0.29262E-03_JPRB,0.28609E-03_JPRB,0.14004E-03_JPRB /)  
KB(:, 5,57, 7) = (/ &
 & 0.52560E-04_JPRB,0.34723E-03_JPRB,0.40853E-03_JPRB,0.39531E-03_JPRB,0.17907E-03_JPRB /)  
KB(:, 1,58, 7) = (/ &
 & 0.22293E-04_JPRB,0.84410E-04_JPRB,0.97318E-04_JPRB,0.95954E-04_JPRB,0.55246E-04_JPRB /)  
KB(:, 2,58, 7) = (/ &
 & 0.26200E-04_JPRB,0.11013E-03_JPRB,0.12878E-03_JPRB,0.12778E-03_JPRB,0.70434E-04_JPRB /)  
KB(:, 3,58, 7) = (/ &
 & 0.30694E-04_JPRB,0.14878E-03_JPRB,0.17475E-03_JPRB,0.17269E-03_JPRB,0.90681E-04_JPRB /)  
KB(:, 4,58, 7) = (/ &
 & 0.36071E-04_JPRB,0.20666E-03_JPRB,0.24284E-03_JPRB,0.23795E-03_JPRB,0.11731E-03_JPRB /)  
KB(:, 5,58, 7) = (/ &
 & 0.42845E-04_JPRB,0.29161E-03_JPRB,0.34322E-03_JPRB,0.33267E-03_JPRB,0.15208E-03_JPRB /)  
KB(:, 1,59, 7) = (/ &
 & 0.18430E-04_JPRB,0.71706E-04_JPRB,0.82601E-04_JPRB,0.81289E-04_JPRB,0.46584E-04_JPRB /)  
KB(:, 2,59, 7) = (/ &
 & 0.21734E-04_JPRB,0.94599E-04_JPRB,0.11060E-03_JPRB,0.10958E-03_JPRB,0.60168E-04_JPRB /)  
KB(:, 3,59, 7) = (/ &
 & 0.25561E-04_JPRB,0.12924E-03_JPRB,0.15196E-03_JPRB,0.15008E-03_JPRB,0.78430E-04_JPRB /)  
KB(:, 4,59, 7) = (/ &
 & 0.30185E-04_JPRB,0.18220E-03_JPRB,0.21420E-03_JPRB,0.20980E-03_JPRB,0.10280E-03_JPRB /)  
KB(:, 5,59, 7) = (/ &
 & 0.36067E-04_JPRB,0.26061E-03_JPRB,0.30710E-03_JPRB,0.29739E-03_JPRB,0.13531E-03_JPRB /)  
KB(:, 1,13, 8) = (/ &
 & 0.32299E+00_JPRB,0.54760E+00_JPRB,0.60079E+00_JPRB,0.58517E+00_JPRB,0.42276E+00_JPRB /)  
KB(:, 2,13, 8) = (/ &
 & 0.32594E+00_JPRB,0.55963E+00_JPRB,0.61653E+00_JPRB,0.60147E+00_JPRB,0.43281E+00_JPRB /)  
KB(:, 3,13, 8) = (/ &
 & 0.33056E+00_JPRB,0.57182E+00_JPRB,0.63236E+00_JPRB,0.61863E+00_JPRB,0.44149E+00_JPRB /)  
KB(:, 4,13, 8) = (/ &
 & 0.33706E+00_JPRB,0.58426E+00_JPRB,0.64822E+00_JPRB,0.63489E+00_JPRB,0.44893E+00_JPRB /)  
KB(:, 5,13, 8) = (/ &
 & 0.34635E+00_JPRB,0.59739E+00_JPRB,0.66343E+00_JPRB,0.65003E+00_JPRB,0.45486E+00_JPRB /)  
KB(:, 1,14, 8) = (/ &
 & 0.27185E+00_JPRB,0.47396E+00_JPRB,0.52087E+00_JPRB,0.50518E+00_JPRB,0.35898E+00_JPRB /)  
KB(:, 2,14, 8) = (/ &
 & 0.27455E+00_JPRB,0.48454E+00_JPRB,0.53473E+00_JPRB,0.52058E+00_JPRB,0.36725E+00_JPRB /)  
KB(:, 3,14, 8) = (/ &
 & 0.27878E+00_JPRB,0.49523E+00_JPRB,0.54876E+00_JPRB,0.53556E+00_JPRB,0.37477E+00_JPRB /)  
KB(:, 4,14, 8) = (/ &
 & 0.28540E+00_JPRB,0.50660E+00_JPRB,0.56244E+00_JPRB,0.54948E+00_JPRB,0.38095E+00_JPRB /)  
KB(:, 5,14, 8) = (/ &
 & 0.29474E+00_JPRB,0.51876E+00_JPRB,0.57592E+00_JPRB,0.56255E+00_JPRB,0.38660E+00_JPRB /)  
KB(:, 1,15, 8) = (/ &
 & 0.22818E+00_JPRB,0.40825E+00_JPRB,0.45003E+00_JPRB,0.43582E+00_JPRB,0.30350E+00_JPRB /)  
KB(:, 2,15, 8) = (/ &
 & 0.23074E+00_JPRB,0.41749E+00_JPRB,0.46220E+00_JPRB,0.44930E+00_JPRB,0.31064E+00_JPRB /)  
KB(:, 3,15, 8) = (/ &
 & 0.23510E+00_JPRB,0.42737E+00_JPRB,0.47434E+00_JPRB,0.46202E+00_JPRB,0.31696E+00_JPRB /)  
KB(:, 4,15, 8) = (/ &
 & 0.24186E+00_JPRB,0.43783E+00_JPRB,0.48637E+00_JPRB,0.47387E+00_JPRB,0.32265E+00_JPRB /)  
KB(:, 5,15, 8) = (/ &
 & 0.25121E+00_JPRB,0.44943E+00_JPRB,0.49855E+00_JPRB,0.48519E+00_JPRB,0.32816E+00_JPRB /)  
KB(:, 1,16, 8) = (/ &
 & 0.19120E+00_JPRB,0.34975E+00_JPRB,0.38732E+00_JPRB,0.37509E+00_JPRB,0.25617E+00_JPRB /)  
KB(:, 2,16, 8) = (/ &
 & 0.19385E+00_JPRB,0.35826E+00_JPRB,0.39799E+00_JPRB,0.38666E+00_JPRB,0.26259E+00_JPRB /)  
KB(:, 3,16, 8) = (/ &
 & 0.19846E+00_JPRB,0.36727E+00_JPRB,0.40872E+00_JPRB,0.39750E+00_JPRB,0.26815E+00_JPRB /)  
KB(:, 4,16, 8) = (/ &
 & 0.20537E+00_JPRB,0.37712E+00_JPRB,0.41954E+00_JPRB,0.40777E+00_JPRB,0.27330E+00_JPRB /)  
KB(:, 5,16, 8) = (/ &
 & 0.21427E+00_JPRB,0.38868E+00_JPRB,0.43071E+00_JPRB,0.41784E+00_JPRB,0.27853E+00_JPRB /)  
KB(:, 1,17, 8) = (/ &
 & 0.15988E+00_JPRB,0.29854E+00_JPRB,0.33180E+00_JPRB,0.32201E+00_JPRB,0.21611E+00_JPRB /)  
KB(:, 2,17, 8) = (/ &
 & 0.16279E+00_JPRB,0.30628E+00_JPRB,0.34129E+00_JPRB,0.33188E+00_JPRB,0.22162E+00_JPRB /)  
KB(:, 3,17, 8) = (/ &
 & 0.16763E+00_JPRB,0.31463E+00_JPRB,0.35085E+00_JPRB,0.34122E+00_JPRB,0.22664E+00_JPRB /)  
KB(:, 4,17, 8) = (/ &
 & 0.17444E+00_JPRB,0.32432E+00_JPRB,0.36068E+00_JPRB,0.35032E+00_JPRB,0.23161E+00_JPRB /)  
KB(:, 5,17, 8) = (/ &
 & 0.18274E+00_JPRB,0.33609E+00_JPRB,0.37140E+00_JPRB,0.35944E+00_JPRB,0.23665E+00_JPRB /)  
KB(:, 1,18, 8) = (/ &
 & 0.13352E+00_JPRB,0.25404E+00_JPRB,0.28330E+00_JPRB,0.27577E+00_JPRB,0.18225E+00_JPRB /)  
KB(:, 2,18, 8) = (/ &
 & 0.13667E+00_JPRB,0.26103E+00_JPRB,0.29171E+00_JPRB,0.28431E+00_JPRB,0.18712E+00_JPRB /)  
KB(:, 3,18, 8) = (/ &
 & 0.14164E+00_JPRB,0.26910E+00_JPRB,0.30030E+00_JPRB,0.29254E+00_JPRB,0.19176E+00_JPRB /)  
KB(:, 4,18, 8) = (/ &
 & 0.14809E+00_JPRB,0.27886E+00_JPRB,0.30959E+00_JPRB,0.30073E+00_JPRB,0.19637E+00_JPRB /)  
KB(:, 5,18, 8) = (/ &
 & 0.15551E+00_JPRB,0.29050E+00_JPRB,0.32020E+00_JPRB,0.30930E+00_JPRB,0.20115E+00_JPRB /)  
KB(:, 1,19, 8) = (/ &
 & 0.11177E+00_JPRB,0.21580E+00_JPRB,0.24136E+00_JPRB,0.23552E+00_JPRB,0.15392E+00_JPRB /)  
KB(:, 2,19, 8) = (/ &
 & 0.11504E+00_JPRB,0.22243E+00_JPRB,0.24890E+00_JPRB,0.24304E+00_JPRB,0.15833E+00_JPRB /)  
KB(:, 3,19, 8) = (/ &
 & 0.11975E+00_JPRB,0.23031E+00_JPRB,0.25687E+00_JPRB,0.25048E+00_JPRB,0.16244E+00_JPRB /)  
KB(:, 4,19, 8) = (/ &
 & 0.12553E+00_JPRB,0.23994E+00_JPRB,0.26588E+00_JPRB,0.25812E+00_JPRB,0.16671E+00_JPRB /)  
KB(:, 5,19, 8) = (/ &
 & 0.13204E+00_JPRB,0.25107E+00_JPRB,0.27639E+00_JPRB,0.26629E+00_JPRB,0.17110E+00_JPRB /)  
KB(:, 1,20, 8) = (/ &
 & 0.93818E-01_JPRB,0.18336E+00_JPRB,0.20533E+00_JPRB,0.20083E+00_JPRB,0.13063E+00_JPRB /)  
KB(:, 2,20, 8) = (/ &
 & 0.97153E-01_JPRB,0.18975E+00_JPRB,0.21222E+00_JPRB,0.20754E+00_JPRB,0.13445E+00_JPRB /)  
KB(:, 3,20, 8) = (/ &
 & 0.10157E+00_JPRB,0.19759E+00_JPRB,0.21989E+00_JPRB,0.21439E+00_JPRB,0.13819E+00_JPRB /)  
KB(:, 4,20, 8) = (/ &
 & 0.10656E+00_JPRB,0.20692E+00_JPRB,0.22885E+00_JPRB,0.22170E+00_JPRB,0.14200E+00_JPRB /)  
KB(:, 5,20, 8) = (/ &
 & 0.11217E+00_JPRB,0.21741E+00_JPRB,0.23914E+00_JPRB,0.22972E+00_JPRB,0.14595E+00_JPRB /)  
KB(:, 1,21, 8) = (/ &
 & 0.78864E-01_JPRB,0.15581E+00_JPRB,0.17467E+00_JPRB,0.17111E+00_JPRB,0.11093E+00_JPRB /)  
KB(:, 2,21, 8) = (/ &
 & 0.82115E-01_JPRB,0.16213E+00_JPRB,0.18114E+00_JPRB,0.17722E+00_JPRB,0.11448E+00_JPRB /)  
KB(:, 3,21, 8) = (/ &
 & 0.86091E-01_JPRB,0.16989E+00_JPRB,0.18858E+00_JPRB,0.18368E+00_JPRB,0.11795E+00_JPRB /)  
KB(:, 4,21, 8) = (/ &
 & 0.90544E-01_JPRB,0.17883E+00_JPRB,0.19740E+00_JPRB,0.19075E+00_JPRB,0.12140E+00_JPRB /)  
KB(:, 5,21, 8) = (/ &
 & 0.95531E-01_JPRB,0.18857E+00_JPRB,0.20719E+00_JPRB,0.19872E+00_JPRB,0.12494E+00_JPRB /)  
KB(:, 1,22, 8) = (/ &
 & 0.66536E-01_JPRB,0.13293E+00_JPRB,0.14913E+00_JPRB,0.14618E+00_JPRB,0.94429E-01_JPRB /)  
KB(:, 2,22, 8) = (/ &
 & 0.69639E-01_JPRB,0.13931E+00_JPRB,0.15537E+00_JPRB,0.15187E+00_JPRB,0.97680E-01_JPRB /)  
KB(:, 3,22, 8) = (/ &
 & 0.73194E-01_JPRB,0.14688E+00_JPRB,0.16282E+00_JPRB,0.15805E+00_JPRB,0.10087E+00_JPRB /)  
KB(:, 4,22, 8) = (/ &
 & 0.77205E-01_JPRB,0.15536E+00_JPRB,0.17135E+00_JPRB,0.16503E+00_JPRB,0.10414E+00_JPRB /)  
KB(:, 5,22, 8) = (/ &
 & 0.81667E-01_JPRB,0.16427E+00_JPRB,0.18066E+00_JPRB,0.17291E+00_JPRB,0.10744E+00_JPRB /)  
KB(:, 1,23, 8) = (/ &
 & 0.56261E-01_JPRB,0.11383E+00_JPRB,0.12760E+00_JPRB,0.12512E+00_JPRB,0.80559E-01_JPRB /)  
KB(:, 2,23, 8) = (/ &
 & 0.59086E-01_JPRB,0.12014E+00_JPRB,0.13384E+00_JPRB,0.13048E+00_JPRB,0.83485E-01_JPRB /)  
KB(:, 3,23, 8) = (/ &
 & 0.62281E-01_JPRB,0.12738E+00_JPRB,0.14121E+00_JPRB,0.13648E+00_JPRB,0.86460E-01_JPRB /)  
KB(:, 4,23, 8) = (/ &
 & 0.65906E-01_JPRB,0.13517E+00_JPRB,0.14937E+00_JPRB,0.14336E+00_JPRB,0.89462E-01_JPRB /)  
KB(:, 5,23, 8) = (/ &
 & 0.69998E-01_JPRB,0.14335E+00_JPRB,0.15807E+00_JPRB,0.15098E+00_JPRB,0.92588E-01_JPRB /)  
KB(:, 1,24, 8) = (/ &
 & 0.47642E-01_JPRB,0.97933E-01_JPRB,0.10963E+00_JPRB,0.10742E+00_JPRB,0.68750E-01_JPRB /)  
KB(:, 2,24, 8) = (/ &
 & 0.50193E-01_JPRB,0.10399E+00_JPRB,0.11587E+00_JPRB,0.11258E+00_JPRB,0.71432E-01_JPRB /)  
KB(:, 3,24, 8) = (/ &
 & 0.53085E-01_JPRB,0.11077E+00_JPRB,0.12298E+00_JPRB,0.11845E+00_JPRB,0.74194E-01_JPRB /)  
KB(:, 4,24, 8) = (/ &
 & 0.56384E-01_JPRB,0.11795E+00_JPRB,0.13070E+00_JPRB,0.12512E+00_JPRB,0.76973E-01_JPRB /)  
KB(:, 5,24, 8) = (/ &
 & 0.60174E-01_JPRB,0.12555E+00_JPRB,0.13879E+00_JPRB,0.13237E+00_JPRB,0.79920E-01_JPRB /)  
KB(:, 1,25, 8) = (/ &
 & 0.40432E-01_JPRB,0.84645E-01_JPRB,0.94724E-01_JPRB,0.92637E-01_JPRB,0.58805E-01_JPRB /)  
KB(:, 2,25, 8) = (/ &
 & 0.42748E-01_JPRB,0.90409E-01_JPRB,0.10079E+00_JPRB,0.97654E-01_JPRB,0.61289E-01_JPRB /)  
KB(:, 3,25, 8) = (/ &
 & 0.45392E-01_JPRB,0.96682E-01_JPRB,0.10756E+00_JPRB,0.10341E+00_JPRB,0.63818E-01_JPRB /)  
KB(:, 4,25, 8) = (/ &
 & 0.48438E-01_JPRB,0.10335E+00_JPRB,0.11478E+00_JPRB,0.10978E+00_JPRB,0.66481E-01_JPRB /)  
KB(:, 5,25, 8) = (/ &
 & 0.52019E-01_JPRB,0.11050E+00_JPRB,0.12234E+00_JPRB,0.11664E+00_JPRB,0.69209E-01_JPRB /)  
KB(:, 1,26, 8) = (/ &
 & 0.34430E-01_JPRB,0.73567E-01_JPRB,0.82349E-01_JPRB,0.80341E-01_JPRB,0.50485E-01_JPRB /)  
KB(:, 2,26, 8) = (/ &
 & 0.36558E-01_JPRB,0.78997E-01_JPRB,0.88163E-01_JPRB,0.85293E-01_JPRB,0.52835E-01_JPRB /)  
KB(:, 3,26, 8) = (/ &
 & 0.39009E-01_JPRB,0.84818E-01_JPRB,0.94521E-01_JPRB,0.90851E-01_JPRB,0.55181E-01_JPRB /)  
KB(:, 4,26, 8) = (/ &
 & 0.41876E-01_JPRB,0.91074E-01_JPRB,0.10127E+00_JPRB,0.96922E-01_JPRB,0.57644E-01_JPRB /)  
KB(:, 5,26, 8) = (/ &
 & 0.45294E-01_JPRB,0.97874E-01_JPRB,0.10841E+00_JPRB,0.10340E+00_JPRB,0.60258E-01_JPRB /)  
KB(:, 1,27, 8) = (/ &
 & 0.29418E-01_JPRB,0.64289E-01_JPRB,0.71984E-01_JPRB,0.70112E-01_JPRB,0.43514E-01_JPRB /)  
KB(:, 2,27, 8) = (/ &
 & 0.31367E-01_JPRB,0.69333E-01_JPRB,0.77500E-01_JPRB,0.74945E-01_JPRB,0.45654E-01_JPRB /)  
KB(:, 3,27, 8) = (/ &
 & 0.33650E-01_JPRB,0.74779E-01_JPRB,0.83451E-01_JPRB,0.80284E-01_JPRB,0.47838E-01_JPRB /)  
KB(:, 4,27, 8) = (/ &
 & 0.36373E-01_JPRB,0.80698E-01_JPRB,0.89803E-01_JPRB,0.86035E-01_JPRB,0.50188E-01_JPRB /)  
KB(:, 5,27, 8) = (/ &
 & 0.39625E-01_JPRB,0.87227E-01_JPRB,0.96605E-01_JPRB,0.92163E-01_JPRB,0.52661E-01_JPRB /)  
KB(:, 1,28, 8) = (/ &
 & 0.25206E-01_JPRB,0.56436E-01_JPRB,0.63282E-01_JPRB,0.61571E-01_JPRB,0.37602E-01_JPRB /)  
KB(:, 2,28, 8) = (/ &
 & 0.27009E-01_JPRB,0.61147E-01_JPRB,0.68481E-01_JPRB,0.66237E-01_JPRB,0.39562E-01_JPRB /)  
KB(:, 3,28, 8) = (/ &
 & 0.29150E-01_JPRB,0.66302E-01_JPRB,0.74074E-01_JPRB,0.71341E-01_JPRB,0.41601E-01_JPRB /)  
KB(:, 4,28, 8) = (/ &
 & 0.31750E-01_JPRB,0.71955E-01_JPRB,0.80104E-01_JPRB,0.76785E-01_JPRB,0.43794E-01_JPRB /)  
KB(:, 5,28, 8) = (/ &
 & 0.34834E-01_JPRB,0.78268E-01_JPRB,0.86662E-01_JPRB,0.82632E-01_JPRB,0.46193E-01_JPRB /)  
KB(:, 1,29, 8) = (/ &
 & 0.21672E-01_JPRB,0.49821E-01_JPRB,0.55985E-01_JPRB,0.54431E-01_JPRB,0.32677E-01_JPRB /)  
KB(:, 2,29, 8) = (/ &
 & 0.23360E-01_JPRB,0.54257E-01_JPRB,0.60871E-01_JPRB,0.58918E-01_JPRB,0.34453E-01_JPRB /)  
KB(:, 3,29, 8) = (/ &
 & 0.25420E-01_JPRB,0.59159E-01_JPRB,0.66168E-01_JPRB,0.63765E-01_JPRB,0.36398E-01_JPRB /)  
KB(:, 4,29, 8) = (/ &
 & 0.27908E-01_JPRB,0.64629E-01_JPRB,0.71935E-01_JPRB,0.68977E-01_JPRB,0.38490E-01_JPRB /)  
KB(:, 5,29, 8) = (/ &
 & 0.30843E-01_JPRB,0.70791E-01_JPRB,0.78323E-01_JPRB,0.74610E-01_JPRB,0.40747E-01_JPRB /)  
KB(:, 1,30, 8) = (/ &
 & 0.18703E-01_JPRB,0.44236E-01_JPRB,0.49819E-01_JPRB,0.48423E-01_JPRB,0.28503E-01_JPRB /)  
KB(:, 2,30, 8) = (/ &
 & 0.20315E-01_JPRB,0.48445E-01_JPRB,0.54425E-01_JPRB,0.52720E-01_JPRB,0.30174E-01_JPRB /)  
KB(:, 3,30, 8) = (/ &
 & 0.22307E-01_JPRB,0.53163E-01_JPRB,0.59481E-01_JPRB,0.57359E-01_JPRB,0.32018E-01_JPRB /)  
KB(:, 4,30, 8) = (/ &
 & 0.24687E-01_JPRB,0.58495E-01_JPRB,0.65064E-01_JPRB,0.62368E-01_JPRB,0.34022E-01_JPRB /)  
KB(:, 5,30, 8) = (/ &
 & 0.27510E-01_JPRB,0.64597E-01_JPRB,0.71352E-01_JPRB,0.67860E-01_JPRB,0.36243E-01_JPRB /)  
KB(:, 1,31, 8) = (/ &
 & 0.16227E-01_JPRB,0.39546E-01_JPRB,0.44613E-01_JPRB,0.43384E-01_JPRB,0.24947E-01_JPRB /)  
KB(:, 2,31, 8) = (/ &
 & 0.17791E-01_JPRB,0.43576E-01_JPRB,0.49010E-01_JPRB,0.47501E-01_JPRB,0.26577E-01_JPRB /)  
KB(:, 3,31, 8) = (/ &
 & 0.19720E-01_JPRB,0.48163E-01_JPRB,0.53877E-01_JPRB,0.51962E-01_JPRB,0.28347E-01_JPRB /)  
KB(:, 4,31, 8) = (/ &
 & 0.22010E-01_JPRB,0.53419E-01_JPRB,0.59368E-01_JPRB,0.56842E-01_JPRB,0.30326E-01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART23',1,ZHOOK_HANDLE)
END SUBROUTINE PART23


SUBROUTINE PART24

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART24',0,ZHOOK_HANDLE)


KB(:, 5,31, 8) = (/ &
 & 0.24778E-01_JPRB,0.59533E-01_JPRB,0.65582E-01_JPRB,0.62279E-01_JPRB,0.32464E-01_JPRB /)  
KB(:, 1,32, 8) = (/ &
 & 0.14168E-01_JPRB,0.35610E-01_JPRB,0.40228E-01_JPRB,0.39145E-01_JPRB,0.21998E-01_JPRB /)  
KB(:, 2,32, 8) = (/ &
 & 0.15701E-01_JPRB,0.39518E-01_JPRB,0.44455E-01_JPRB,0.43108E-01_JPRB,0.23551E-01_JPRB /)  
KB(:, 3,32, 8) = (/ &
 & 0.17568E-01_JPRB,0.44028E-01_JPRB,0.49228E-01_JPRB,0.47442E-01_JPRB,0.25303E-01_JPRB /)  
KB(:, 4,32, 8) = (/ &
 & 0.19822E-01_JPRB,0.49274E-01_JPRB,0.54644E-01_JPRB,0.52269E-01_JPRB,0.27219E-01_JPRB /)  
KB(:, 5,32, 8) = (/ &
 & 0.22492E-01_JPRB,0.55429E-01_JPRB,0.60878E-01_JPRB,0.57696E-01_JPRB,0.29289E-01_JPRB /)  
KB(:, 1,33, 8) = (/ &
 & 0.12469E-01_JPRB,0.32321E-01_JPRB,0.36548E-01_JPRB,0.35586E-01_JPRB,0.19535E-01_JPRB /)  
KB(:, 2,33, 8) = (/ &
 & 0.13967E-01_JPRB,0.36160E-01_JPRB,0.40670E-01_JPRB,0.39414E-01_JPRB,0.21057E-01_JPRB /)  
KB(:, 3,33, 8) = (/ &
 & 0.15804E-01_JPRB,0.40646E-01_JPRB,0.45371E-01_JPRB,0.43697E-01_JPRB,0.22748E-01_JPRB /)  
KB(:, 4,33, 8) = (/ &
 & 0.18007E-01_JPRB,0.45935E-01_JPRB,0.50790E-01_JPRB,0.48504E-01_JPRB,0.24589E-01_JPRB /)  
KB(:, 5,33, 8) = (/ &
 & 0.20583E-01_JPRB,0.52117E-01_JPRB,0.57083E-01_JPRB,0.53949E-01_JPRB,0.26612E-01_JPRB /)  
KB(:, 1,34, 8) = (/ &
 & 0.11030E-01_JPRB,0.29462E-01_JPRB,0.33333E-01_JPRB,0.32457E-01_JPRB,0.17441E-01_JPRB /)  
KB(:, 2,34, 8) = (/ &
 & 0.12485E-01_JPRB,0.33252E-01_JPRB,0.37374E-01_JPRB,0.36203E-01_JPRB,0.18902E-01_JPRB /)  
KB(:, 3,34, 8) = (/ &
 & 0.14284E-01_JPRB,0.37735E-01_JPRB,0.42039E-01_JPRB,0.40449E-01_JPRB,0.20533E-01_JPRB /)  
KB(:, 4,34, 8) = (/ &
 & 0.16406E-01_JPRB,0.43050E-01_JPRB,0.47473E-01_JPRB,0.45250E-01_JPRB,0.22315E-01_JPRB /)  
KB(:, 5,34, 8) = (/ &
 & 0.18889E-01_JPRB,0.49221E-01_JPRB,0.53838E-01_JPRB,0.50709E-01_JPRB,0.24295E-01_JPRB /)  
KB(:, 1,35, 8) = (/ &
 & 0.97045E-02_JPRB,0.26765E-01_JPRB,0.30294E-01_JPRB,0.29494E-01_JPRB,0.15527E-01_JPRB /)  
KB(:, 2,35, 8) = (/ &
 & 0.11116E-01_JPRB,0.30471E-01_JPRB,0.34237E-01_JPRB,0.33156E-01_JPRB,0.16936E-01_JPRB /)  
KB(:, 3,35, 8) = (/ &
 & 0.12833E-01_JPRB,0.34908E-01_JPRB,0.38827E-01_JPRB,0.37335E-01_JPRB,0.18494E-01_JPRB /)  
KB(:, 4,35, 8) = (/ &
 & 0.14851E-01_JPRB,0.40160E-01_JPRB,0.44228E-01_JPRB,0.42095E-01_JPRB,0.20230E-01_JPRB /)  
KB(:, 5,35, 8) = (/ &
 & 0.17220E-01_JPRB,0.46275E-01_JPRB,0.50600E-01_JPRB,0.47524E-01_JPRB,0.22137E-01_JPRB /)  
KB(:, 1,36, 8) = (/ &
 & 0.84787E-02_JPRB,0.24131E-01_JPRB,0.27339E-01_JPRB,0.26619E-01_JPRB,0.13756E-01_JPRB /)  
KB(:, 2,36, 8) = (/ &
 & 0.98033E-02_JPRB,0.27706E-01_JPRB,0.31147E-01_JPRB,0.30166E-01_JPRB,0.15106E-01_JPRB /)  
KB(:, 3,36, 8) = (/ &
 & 0.11407E-01_JPRB,0.32015E-01_JPRB,0.35610E-01_JPRB,0.34239E-01_JPRB,0.16593E-01_JPRB /)  
KB(:, 4,36, 8) = (/ &
 & 0.13302E-01_JPRB,0.37140E-01_JPRB,0.40907E-01_JPRB,0.38904E-01_JPRB,0.18257E-01_JPRB /)  
KB(:, 5,36, 8) = (/ &
 & 0.15537E-01_JPRB,0.43129E-01_JPRB,0.47182E-01_JPRB,0.44236E-01_JPRB,0.20074E-01_JPRB /)  
KB(:, 1,37, 8) = (/ &
 & 0.72685E-02_JPRB,0.21392E-01_JPRB,0.24301E-01_JPRB,0.23679E-01_JPRB,0.12087E-01_JPRB /)  
KB(:, 2,37, 8) = (/ &
 & 0.84733E-02_JPRB,0.24759E-01_JPRB,0.27898E-01_JPRB,0.27046E-01_JPRB,0.13342E-01_JPRB /)  
KB(:, 3,37, 8) = (/ &
 & 0.99353E-02_JPRB,0.28848E-01_JPRB,0.32152E-01_JPRB,0.30940E-01_JPRB,0.14748E-01_JPRB /)  
KB(:, 4,37, 8) = (/ &
 & 0.11673E-01_JPRB,0.33734E-01_JPRB,0.37224E-01_JPRB,0.35422E-01_JPRB,0.16319E-01_JPRB /)  
KB(:, 5,37, 8) = (/ &
 & 0.13740E-01_JPRB,0.39481E-01_JPRB,0.43256E-01_JPRB,0.40566E-01_JPRB,0.18049E-01_JPRB /)  
KB(:, 1,38, 8) = (/ &
 & 0.62326E-02_JPRB,0.18999E-01_JPRB,0.21644E-01_JPRB,0.21103E-01_JPRB,0.10629E-01_JPRB /)  
KB(:, 2,38, 8) = (/ &
 & 0.73269E-02_JPRB,0.22170E-01_JPRB,0.25042E-01_JPRB,0.24299E-01_JPRB,0.11807E-01_JPRB /)  
KB(:, 3,38, 8) = (/ &
 & 0.86586E-02_JPRB,0.26045E-01_JPRB,0.29098E-01_JPRB,0.28019E-01_JPRB,0.13138E-01_JPRB /)  
KB(:, 4,38, 8) = (/ &
 & 0.10254E-01_JPRB,0.30699E-01_JPRB,0.33952E-01_JPRB,0.32316E-01_JPRB,0.14621E-01_JPRB /)  
KB(:, 5,38, 8) = (/ &
 & 0.12168E-01_JPRB,0.36211E-01_JPRB,0.39748E-01_JPRB,0.37288E-01_JPRB,0.16263E-01_JPRB /)  
KB(:, 1,39, 8) = (/ &
 & 0.53522E-02_JPRB,0.16925E-01_JPRB,0.19337E-01_JPRB,0.18863E-01_JPRB,0.93697E-02_JPRB /)  
KB(:, 2,39, 8) = (/ &
 & 0.63437E-02_JPRB,0.19916E-01_JPRB,0.22555E-01_JPRB,0.21900E-01_JPRB,0.10477E-01_JPRB /)  
KB(:, 3,39, 8) = (/ &
 & 0.75600E-02_JPRB,0.23590E-01_JPRB,0.26428E-01_JPRB,0.25453E-01_JPRB,0.11732E-01_JPRB /)  
KB(:, 4,39, 8) = (/ &
 & 0.90277E-02_JPRB,0.28027E-01_JPRB,0.31081E-01_JPRB,0.29581E-01_JPRB,0.13140E-01_JPRB /)  
KB(:, 5,39, 8) = (/ &
 & 0.10804E-01_JPRB,0.33325E-01_JPRB,0.36655E-01_JPRB,0.34396E-01_JPRB,0.14714E-01_JPRB /)  
KB(:, 1,40, 8) = (/ &
 & 0.45183E-02_JPRB,0.14862E-01_JPRB,0.17043E-01_JPRB,0.16640E-01_JPRB,0.81906E-02_JPRB /)  
KB(:, 2,40, 8) = (/ &
 & 0.53964E-02_JPRB,0.17630E-01_JPRB,0.20043E-01_JPRB,0.19482E-01_JPRB,0.92335E-02_JPRB /)  
KB(:, 3,40, 8) = (/ &
 & 0.64835E-02_JPRB,0.21041E-01_JPRB,0.23674E-01_JPRB,0.22821E-01_JPRB,0.10400E-01_JPRB /)  
KB(:, 4,40, 8) = (/ &
 & 0.78100E-02_JPRB,0.25197E-01_JPRB,0.28056E-01_JPRB,0.26733E-01_JPRB,0.11718E-01_JPRB /)  
KB(:, 5,40, 8) = (/ &
 & 0.94310E-02_JPRB,0.30203E-01_JPRB,0.33322E-01_JPRB,0.31321E-01_JPRB,0.13209E-01_JPRB /)  
KB(:, 1,41, 8) = (/ &
 & 0.38020E-02_JPRB,0.13035E-01_JPRB,0.15007E-01_JPRB,0.14665E-01_JPRB,0.71645E-02_JPRB /)  
KB(:, 2,41, 8) = (/ &
 & 0.45796E-02_JPRB,0.15592E-01_JPRB,0.17802E-01_JPRB,0.17320E-01_JPRB,0.81332E-02_JPRB /)  
KB(:, 3,41, 8) = (/ &
 & 0.55464E-02_JPRB,0.18749E-01_JPRB,0.21191E-01_JPRB,0.20448E-01_JPRB,0.92312E-02_JPRB /)  
KB(:, 4,41, 8) = (/ &
 & 0.67408E-02_JPRB,0.22629E-01_JPRB,0.25309E-01_JPRB,0.24143E-01_JPRB,0.10458E-01_JPRB /)  
KB(:, 5,41, 8) = (/ &
 & 0.82155E-02_JPRB,0.27347E-01_JPRB,0.30277E-01_JPRB,0.28506E-01_JPRB,0.11871E-01_JPRB /)  
KB(:, 1,42, 8) = (/ &
 & 0.31962E-02_JPRB,0.11444E-01_JPRB,0.13229E-01_JPRB,0.12937E-01_JPRB,0.62788E-02_JPRB /)  
KB(:, 2,42, 8) = (/ &
 & 0.38815E-02_JPRB,0.13798E-01_JPRB,0.15822E-01_JPRB,0.15407E-01_JPRB,0.71774E-02_JPRB /)  
KB(:, 3,42, 8) = (/ &
 & 0.47422E-02_JPRB,0.16722E-01_JPRB,0.18990E-01_JPRB,0.18339E-01_JPRB,0.81986E-02_JPRB /)  
KB(:, 4,42, 8) = (/ &
 & 0.58154E-02_JPRB,0.20342E-01_JPRB,0.22857E-01_JPRB,0.21830E-01_JPRB,0.93594E-02_JPRB /)  
KB(:, 5,42, 8) = (/ &
 & 0.71546E-02_JPRB,0.24787E-01_JPRB,0.27545E-01_JPRB,0.25973E-01_JPRB,0.10684E-01_JPRB /)  
KB(:, 1,43, 8) = (/ &
 & 0.26542E-02_JPRB,0.99421E-02_JPRB,0.11545E-01_JPRB,0.11297E-01_JPRB,0.54681E-02_JPRB /)  
KB(:, 2,43, 8) = (/ &
 & 0.32467E-02_JPRB,0.12085E-01_JPRB,0.13926E-01_JPRB,0.13575E-01_JPRB,0.63017E-02_JPRB /)  
KB(:, 3,43, 8) = (/ &
 & 0.40037E-02_JPRB,0.14758E-01_JPRB,0.16848E-01_JPRB,0.16296E-01_JPRB,0.72434E-02_JPRB /)  
KB(:, 4,43, 8) = (/ &
 & 0.49534E-02_JPRB,0.18094E-01_JPRB,0.20438E-01_JPRB,0.19556E-01_JPRB,0.83354E-02_JPRB /)  
KB(:, 5,43, 8) = (/ &
 & 0.61525E-02_JPRB,0.22230E-01_JPRB,0.24817E-01_JPRB,0.23450E-01_JPRB,0.95751E-02_JPRB /)  
KB(:, 1,44, 8) = (/ &
 & 0.21881E-02_JPRB,0.85857E-02_JPRB,0.10019E-01_JPRB,0.98043E-02_JPRB,0.47456E-02_JPRB /)  
KB(:, 2,44, 8) = (/ &
 & 0.26937E-02_JPRB,0.10525E-01_JPRB,0.12192E-01_JPRB,0.11898E-01_JPRB,0.55168E-02_JPRB /)  
KB(:, 3,44, 8) = (/ &
 & 0.33531E-02_JPRB,0.12952E-01_JPRB,0.14870E-01_JPRB,0.14408E-01_JPRB,0.63938E-02_JPRB /)  
KB(:, 4,44, 8) = (/ &
 & 0.41916E-02_JPRB,0.16016E-01_JPRB,0.18187E-01_JPRB,0.17441E-01_JPRB,0.73995E-02_JPRB /)  
KB(:, 5,44, 8) = (/ &
 & 0.52529E-02_JPRB,0.19825E-01_JPRB,0.22245E-01_JPRB,0.21074E-01_JPRB,0.85693E-02_JPRB /)  
KB(:, 1,45, 8) = (/ &
 & 0.17974E-02_JPRB,0.74036E-02_JPRB,0.86819E-02_JPRB,0.84949E-02_JPRB,0.41100E-02_JPRB /)  
KB(:, 2,45, 8) = (/ &
 & 0.22283E-02_JPRB,0.91556E-02_JPRB,0.10664E-01_JPRB,0.10414E-01_JPRB,0.48257E-02_JPRB /)  
KB(:, 3,45, 8) = (/ &
 & 0.27993E-02_JPRB,0.11360E-01_JPRB,0.13115E-01_JPRB,0.12731E-01_JPRB,0.56423E-02_JPRB /)  
KB(:, 4,45, 8) = (/ &
 & 0.35358E-02_JPRB,0.14164E-01_JPRB,0.16170E-01_JPRB,0.15543E-01_JPRB,0.65867E-02_JPRB /)  
KB(:, 5,45, 8) = (/ &
 & 0.44762E-02_JPRB,0.17671E-01_JPRB,0.19928E-01_JPRB,0.18931E-01_JPRB,0.76725E-02_JPRB /)  
KB(:, 1,46, 8) = (/ &
 & 0.14666E-02_JPRB,0.63443E-02_JPRB,0.74710E-02_JPRB,0.73099E-02_JPRB,0.35540E-02_JPRB /)  
KB(:, 2,46, 8) = (/ &
 & 0.18286E-02_JPRB,0.79140E-02_JPRB,0.92719E-02_JPRB,0.90588E-02_JPRB,0.41981E-02_JPRB /)  
KB(:, 3,46, 8) = (/ &
 & 0.23196E-02_JPRB,0.99089E-02_JPRB,0.11508E-01_JPRB,0.11192E-01_JPRB,0.49656E-02_JPRB /)  
KB(:, 4,46, 8) = (/ &
 & 0.29575E-02_JPRB,0.12451E-01_JPRB,0.14296E-01_JPRB,0.13779E-01_JPRB,0.58441E-02_JPRB /)  
KB(:, 5,46, 8) = (/ &
 & 0.37842E-02_JPRB,0.15662E-01_JPRB,0.17758E-01_JPRB,0.16921E-01_JPRB,0.68660E-02_JPRB /)  
KB(:, 1,47, 8) = (/ &
 & 0.11822E-02_JPRB,0.53700E-02_JPRB,0.63483E-02_JPRB,0.62090E-02_JPRB,0.30500E-02_JPRB /)  
KB(:, 2,47, 8) = (/ &
 & 0.14817E-02_JPRB,0.67616E-02_JPRB,0.79678E-02_JPRB,0.77874E-02_JPRB,0.36317E-02_JPRB /)  
KB(:, 3,47, 8) = (/ &
 & 0.18918E-02_JPRB,0.85392E-02_JPRB,0.99818E-02_JPRB,0.97254E-02_JPRB,0.43248E-02_JPRB /)  
KB(:, 4,47, 8) = (/ &
 & 0.24382E-02_JPRB,0.10820E-01_JPRB,0.12503E-01_JPRB,0.12088E-01_JPRB,0.51477E-02_JPRB /)  
KB(:, 5,47, 8) = (/ &
 & 0.31533E-02_JPRB,0.13725E-01_JPRB,0.15656E-01_JPRB,0.14970E-01_JPRB,0.61000E-02_JPRB /)  
KB(:, 1,48, 8) = (/ &
 & 0.94906E-03_JPRB,0.45298E-02_JPRB,0.53706E-02_JPRB,0.52506E-02_JPRB,0.26162E-02_JPRB /)  
KB(:, 2,48, 8) = (/ &
 & 0.11965E-02_JPRB,0.57597E-02_JPRB,0.68213E-02_JPRB,0.66698E-02_JPRB,0.31403E-02_JPRB /)  
KB(:, 3,48, 8) = (/ &
 & 0.15369E-02_JPRB,0.73380E-02_JPRB,0.86368E-02_JPRB,0.84246E-02_JPRB,0.37687E-02_JPRB /)  
KB(:, 4,48, 8) = (/ &
 & 0.20008E-02_JPRB,0.93814E-02_JPRB,0.10911E-01_JPRB,0.10580E-01_JPRB,0.45213E-02_JPRB /)  
KB(:, 5,48, 8) = (/ &
 & 0.26159E-02_JPRB,0.12002E-01_JPRB,0.13774E-01_JPRB,0.13221E-01_JPRB,0.54142E-02_JPRB /)  
KB(:, 1,49, 8) = (/ &
 & 0.75913E-03_JPRB,0.38043E-02_JPRB,0.45203E-02_JPRB,0.44181E-02_JPRB,0.22379E-02_JPRB /)  
KB(:, 2,49, 8) = (/ &
 & 0.96097E-03_JPRB,0.48899E-02_JPRB,0.58138E-02_JPRB,0.56878E-02_JPRB,0.27098E-02_JPRB /)  
KB(:, 3,49, 8) = (/ &
 & 0.12447E-02_JPRB,0.62895E-02_JPRB,0.74501E-02_JPRB,0.72727E-02_JPRB,0.32859E-02_JPRB /)  
KB(:, 4,49, 8) = (/ &
 & 0.16322E-02_JPRB,0.81122E-02_JPRB,0.94989E-02_JPRB,0.92349E-02_JPRB,0.39720E-02_JPRB /)  
KB(:, 5,49, 8) = (/ &
 & 0.21597E-02_JPRB,0.10470E-01_JPRB,0.12092E-01_JPRB,0.11650E-01_JPRB,0.47938E-02_JPRB /)  
KB(:, 1,50, 8) = (/ &
 & 0.60949E-03_JPRB,0.32009E-02_JPRB,0.38080E-02_JPRB,0.37204E-02_JPRB,0.19148E-02_JPRB /)  
KB(:, 2,50, 8) = (/ &
 & 0.77332E-03_JPRB,0.41637E-02_JPRB,0.49658E-02_JPRB,0.48588E-02_JPRB,0.23498E-02_JPRB /)  
KB(:, 3,50, 8) = (/ &
 & 0.10099E-02_JPRB,0.54095E-02_JPRB,0.64416E-02_JPRB,0.62938E-02_JPRB,0.28713E-02_JPRB /)  
KB(:, 4,50, 8) = (/ &
 & 0.13353E-02_JPRB,0.70417E-02_JPRB,0.83004E-02_JPRB,0.80844E-02_JPRB,0.35114E-02_JPRB /)  
KB(:, 5,50, 8) = (/ &
 & 0.17873E-02_JPRB,0.91691E-02_JPRB,0.10658E-01_JPRB,0.10303E-01_JPRB,0.42641E-02_JPRB /)  
KB(:, 1,51, 8) = (/ &
 & 0.48960E-03_JPRB,0.26873E-02_JPRB,0.32008E-02_JPRB,0.31259E-02_JPRB,0.16378E-02_JPRB /)  
KB(:, 2,51, 8) = (/ &
 & 0.62187E-03_JPRB,0.35423E-02_JPRB,0.42349E-02_JPRB,0.41443E-02_JPRB,0.20325E-02_JPRB /)  
KB(:, 3,51, 8) = (/ &
 & 0.81788E-03_JPRB,0.46529E-02_JPRB,0.55656E-02_JPRB,0.54424E-02_JPRB,0.25164E-02_JPRB /)  
KB(:, 4,51, 8) = (/ &
 & 0.10935E-02_JPRB,0.61155E-02_JPRB,0.72565E-02_JPRB,0.70765E-02_JPRB,0.31007E-02_JPRB /)  
KB(:, 5,51, 8) = (/ &
 & 0.14776E-02_JPRB,0.80416E-02_JPRB,0.94087E-02_JPRB,0.91197E-02_JPRB,0.38085E-02_JPRB /)  
KB(:, 1,52, 8) = (/ &
 & 0.39302E-03_JPRB,0.22435E-02_JPRB,0.26754E-02_JPRB,0.26122E-02_JPRB,0.13898E-02_JPRB /)  
KB(:, 2,52, 8) = (/ &
 & 0.49889E-03_JPRB,0.30006E-02_JPRB,0.35943E-02_JPRB,0.35172E-02_JPRB,0.17532E-02_JPRB /)  
KB(:, 3,52, 8) = (/ &
 & 0.65922E-03_JPRB,0.39906E-02_JPRB,0.47901E-02_JPRB,0.46880E-02_JPRB,0.21980E-02_JPRB /)  
KB(:, 4,52, 8) = (/ &
 & 0.89075E-03_JPRB,0.52980E-02_JPRB,0.63237E-02_JPRB,0.61748E-02_JPRB,0.27412E-02_JPRB /)  
KB(:, 5,52, 8) = (/ &
 & 0.12150E-02_JPRB,0.70312E-02_JPRB,0.82837E-02_JPRB,0.80497E-02_JPRB,0.33956E-02_JPRB /)  
KB(:, 1,53, 8) = (/ &
 & 0.31533E-03_JPRB,0.18598E-02_JPRB,0.22216E-02_JPRB,0.21690E-02_JPRB,0.11705E-02_JPRB /)  
KB(:, 2,53, 8) = (/ &
 & 0.39919E-03_JPRB,0.25290E-02_JPRB,0.30338E-02_JPRB,0.29679E-02_JPRB,0.15051E-02_JPRB /)  
KB(:, 3,53, 8) = (/ &
 & 0.52958E-03_JPRB,0.34096E-02_JPRB,0.41030E-02_JPRB,0.40189E-02_JPRB,0.19137E-02_JPRB /)  
KB(:, 4,53, 8) = (/ &
 & 0.72147E-03_JPRB,0.45756E-02_JPRB,0.54894E-02_JPRB,0.53678E-02_JPRB,0.24147E-02_JPRB /)  
KB(:, 5,53, 8) = (/ &
 & 0.99563E-03_JPRB,0.61321E-02_JPRB,0.72739E-02_JPRB,0.70826E-02_JPRB,0.30286E-02_JPRB /)  
KB(:, 1,54, 8) = (/ &
 & 0.25434E-03_JPRB,0.15477E-02_JPRB,0.18502E-02_JPRB,0.18075E-02_JPRB,0.98891E-03_JPRB /)  
KB(:, 2,54, 8) = (/ &
 & 0.32221E-03_JPRB,0.21398E-02_JPRB,0.25708E-02_JPRB,0.25148E-02_JPRB,0.12935E-02_JPRB /)  
KB(:, 3,54, 8) = (/ &
 & 0.42775E-03_JPRB,0.29272E-02_JPRB,0.35315E-02_JPRB,0.34599E-02_JPRB,0.16741E-02_JPRB /)  
KB(:, 4,54, 8) = (/ &
 & 0.58762E-03_JPRB,0.39761E-02_JPRB,0.47907E-02_JPRB,0.46896E-02_JPRB,0.21376E-02_JPRB /)  
KB(:, 5,54, 8) = (/ &
 & 0.82053E-03_JPRB,0.53824E-02_JPRB,0.64244E-02_JPRB,0.62664E-02_JPRB,0.27173E-02_JPRB /)  
KB(:, 1,55, 8) = (/ &
 & 0.20618E-03_JPRB,0.12866E-02_JPRB,0.15400E-02_JPRB,0.15055E-02_JPRB,0.83572E-03_JPRB /)  
KB(:, 2,55, 8) = (/ &
 & 0.26059E-03_JPRB,0.18094E-02_JPRB,0.21787E-02_JPRB,0.21302E-02_JPRB,0.11090E-02_JPRB /)  
KB(:, 3,55, 8) = (/ &
 & 0.34651E-03_JPRB,0.25140E-02_JPRB,0.30392E-02_JPRB,0.29780E-02_JPRB,0.14628E-02_JPRB /)  
KB(:, 4,55, 8) = (/ &
 & 0.47882E-03_JPRB,0.34608E-02_JPRB,0.41831E-02_JPRB,0.41003E-02_JPRB,0.18992E-02_JPRB /)  
KB(:, 5,55, 8) = (/ &
 & 0.67671E-03_JPRB,0.47331E-02_JPRB,0.56817E-02_JPRB,0.55503E-02_JPRB,0.24360E-02_JPRB /)  
KB(:, 1,56, 8) = (/ &
 & 0.16681E-03_JPRB,0.10621E-02_JPRB,0.12728E-02_JPRB,0.12461E-02_JPRB,0.70162E-03_JPRB /)  
KB(:, 2,56, 8) = (/ &
 & 0.21064E-03_JPRB,0.15213E-02_JPRB,0.18350E-02_JPRB,0.17945E-02_JPRB,0.94828E-03_JPRB /)  
KB(:, 3,56, 8) = (/ &
 & 0.28028E-03_JPRB,0.21500E-02_JPRB,0.26045E-02_JPRB,0.25521E-02_JPRB,0.12721E-02_JPRB /)  
KB(:, 4,56, 8) = (/ &
 & 0.38906E-03_JPRB,0.30029E-02_JPRB,0.36387E-02_JPRB,0.35710E-02_JPRB,0.16833E-02_JPRB /)  
KB(:, 5,56, 8) = (/ &
 & 0.55568E-03_JPRB,0.41534E-02_JPRB,0.50111E-02_JPRB,0.49027E-02_JPRB,0.21849E-02_JPRB /)  
KB(:, 1,57, 8) = (/ &
 & 0.13484E-03_JPRB,0.87168E-03_JPRB,0.10444E-02_JPRB,0.10248E-02_JPRB,0.58516E-03_JPRB /)  
KB(:, 2,57, 8) = (/ &
 & 0.17007E-03_JPRB,0.12717E-02_JPRB,0.15360E-02_JPRB,0.15024E-02_JPRB,0.80805E-03_JPRB /)  
KB(:, 3,57, 8) = (/ &
 & 0.22603E-03_JPRB,0.18296E-02_JPRB,0.22211E-02_JPRB,0.21757E-02_JPRB,0.11006E-02_JPRB /)  
KB(:, 4,57, 8) = (/ &
 & 0.31565E-03_JPRB,0.25963E-02_JPRB,0.31531E-02_JPRB,0.30959E-02_JPRB,0.14851E-02_JPRB /)  
KB(:, 5,57, 8) = (/ &
 & 0.45417E-03_JPRB,0.36365E-02_JPRB,0.44058E-02_JPRB,0.43157E-02_JPRB,0.19625E-02_JPRB /)  
KB(:, 1,58, 8) = (/ &
 & 0.10938E-03_JPRB,0.71449E-03_JPRB,0.85655E-03_JPRB,0.84240E-03_JPRB,0.48772E-03_JPRB /)  
KB(:, 2,58, 8) = (/ &
 & 0.13752E-03_JPRB,0.10624E-02_JPRB,0.12849E-02_JPRB,0.12583E-02_JPRB,0.68689E-03_JPRB /)  
KB(:, 3,58, 8) = (/ &
 & 0.18307E-03_JPRB,0.15572E-02_JPRB,0.18954E-02_JPRB,0.18566E-02_JPRB,0.95344E-03_JPRB /)  
KB(:, 4,58, 8) = (/ &
 & 0.25673E-03_JPRB,0.22481E-02_JPRB,0.27363E-02_JPRB,0.26877E-02_JPRB,0.13079E-02_JPRB /)  
KB(:, 5,58, 8) = (/ &
 & 0.37230E-03_JPRB,0.31921E-02_JPRB,0.38812E-02_JPRB,0.38070E-02_JPRB,0.17570E-02_JPRB /)  
KB(:, 1,59, 8) = (/ &
 & 0.92153E-04_JPRB,0.62798E-03_JPRB,0.75374E-03_JPRB,0.74243E-03_JPRB,0.43161E-03_JPRB /)  
KB(:, 2,59, 8) = (/ &
 & 0.11676E-03_JPRB,0.95019E-03_JPRB,0.11525E-02_JPRB,0.11296E-02_JPRB,0.61959E-03_JPRB /)  
KB(:, 3,59, 8) = (/ &
 & 0.15687E-03_JPRB,0.14168E-02_JPRB,0.17285E-02_JPRB,0.16938E-02_JPRB,0.87468E-03_JPRB /)  
KB(:, 4,59, 8) = (/ &
 & 0.22278E-03_JPRB,0.20743E-02_JPRB,0.25302E-02_JPRB,0.24863E-02_JPRB,0.12161E-02_JPRB /)  
KB(:, 5,59, 8) = (/ &
 & 0.32724E-03_JPRB,0.29797E-02_JPRB,0.36313E-02_JPRB,0.35664E-02_JPRB,0.16577E-02_JPRB /)  
KB(:, 1,13, 9) = (/ &
 & 0.16403E+01_JPRB,0.27290E+01_JPRB,0.31326E+01_JPRB,0.31890E+01_JPRB,0.23307E+01_JPRB /)  
KB(:, 2,13, 9) = (/ &
 & 0.16862E+01_JPRB,0.27611E+01_JPRB,0.31617E+01_JPRB,0.32226E+01_JPRB,0.23816E+01_JPRB /)  
KB(:, 3,13, 9) = (/ &
 & 0.17455E+01_JPRB,0.28101E+01_JPRB,0.32005E+01_JPRB,0.32552E+01_JPRB,0.24291E+01_JPRB /)  
KB(:, 4,13, 9) = (/ &
 & 0.18100E+01_JPRB,0.28758E+01_JPRB,0.32471E+01_JPRB,0.32901E+01_JPRB,0.24729E+01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART24',1,ZHOOK_HANDLE)
END SUBROUTINE PART24


SUBROUTINE PART25

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART25',0,ZHOOK_HANDLE)


KB(:, 5,13, 9) = (/ &
 & 0.18736E+01_JPRB,0.29528E+01_JPRB,0.33027E+01_JPRB,0.33291E+01_JPRB,0.25126E+01_JPRB /)  
KB(:, 1,14, 9) = (/ &
 & 0.14276E+01_JPRB,0.24116E+01_JPRB,0.27645E+01_JPRB,0.28207E+01_JPRB,0.20786E+01_JPRB /)  
KB(:, 2,14, 9) = (/ &
 & 0.14761E+01_JPRB,0.24553E+01_JPRB,0.28027E+01_JPRB,0.28564E+01_JPRB,0.21275E+01_JPRB /)  
KB(:, 3,14, 9) = (/ &
 & 0.15303E+01_JPRB,0.25161E+01_JPRB,0.28501E+01_JPRB,0.28940E+01_JPRB,0.21750E+01_JPRB /)  
KB(:, 4,14, 9) = (/ &
 & 0.15845E+01_JPRB,0.25879E+01_JPRB,0.29061E+01_JPRB,0.29354E+01_JPRB,0.22167E+01_JPRB /)  
KB(:, 5,14, 9) = (/ &
 & 0.16378E+01_JPRB,0.26632E+01_JPRB,0.29707E+01_JPRB,0.29827E+01_JPRB,0.22552E+01_JPRB /)  
KB(:, 1,15, 9) = (/ &
 & 0.12454E+01_JPRB,0.21329E+01_JPRB,0.24382E+01_JPRB,0.24839E+01_JPRB,0.18332E+01_JPRB /)  
KB(:, 2,15, 9) = (/ &
 & 0.12895E+01_JPRB,0.21869E+01_JPRB,0.24841E+01_JPRB,0.25234E+01_JPRB,0.18816E+01_JPRB /)  
KB(:, 3,15, 9) = (/ &
 & 0.13344E+01_JPRB,0.22528E+01_JPRB,0.25385E+01_JPRB,0.25663E+01_JPRB,0.19251E+01_JPRB /)  
KB(:, 4,15, 9) = (/ &
 & 0.13794E+01_JPRB,0.23234E+01_JPRB,0.26021E+01_JPRB,0.26153E+01_JPRB,0.19652E+01_JPRB /)  
KB(:, 5,15, 9) = (/ &
 & 0.14250E+01_JPRB,0.23931E+01_JPRB,0.26727E+01_JPRB,0.26688E+01_JPRB,0.20043E+01_JPRB /)  
KB(:, 1,16, 9) = (/ &
 & 0.10848E+01_JPRB,0.18880E+01_JPRB,0.21511E+01_JPRB,0.21813E+01_JPRB,0.16071E+01_JPRB /)  
KB(:, 2,16, 9) = (/ &
 & 0.11214E+01_JPRB,0.19471E+01_JPRB,0.22027E+01_JPRB,0.22246E+01_JPRB,0.16520E+01_JPRB /)  
KB(:, 3,16, 9) = (/ &
 & 0.11587E+01_JPRB,0.20122E+01_JPRB,0.22636E+01_JPRB,0.22737E+01_JPRB,0.16924E+01_JPRB /)  
KB(:, 4,16, 9) = (/ &
 & 0.11968E+01_JPRB,0.20768E+01_JPRB,0.23313E+01_JPRB,0.23282E+01_JPRB,0.17327E+01_JPRB /)  
KB(:, 5,16, 9) = (/ &
 & 0.12369E+01_JPRB,0.21393E+01_JPRB,0.24028E+01_JPRB,0.23861E+01_JPRB,0.17713E+01_JPRB /)  
KB(:, 1,17, 9) = (/ &
 & 0.94054E+00_JPRB,0.16727E+01_JPRB,0.18972E+01_JPRB,0.19128E+01_JPRB,0.14046E+01_JPRB /)  
KB(:, 2,17, 9) = (/ &
 & 0.97101E+00_JPRB,0.17314E+01_JPRB,0.19542E+01_JPRB,0.19610E+01_JPRB,0.14464E+01_JPRB /)  
KB(:, 3,17, 9) = (/ &
 & 0.10024E+01_JPRB,0.17905E+01_JPRB,0.20183E+01_JPRB,0.20147E+01_JPRB,0.14867E+01_JPRB /)  
KB(:, 4,17, 9) = (/ &
 & 0.10357E+01_JPRB,0.18485E+01_JPRB,0.20868E+01_JPRB,0.20722E+01_JPRB,0.15247E+01_JPRB /)  
KB(:, 5,17, 9) = (/ &
 & 0.10722E+01_JPRB,0.19059E+01_JPRB,0.21551E+01_JPRB,0.21344E+01_JPRB,0.15620E+01_JPRB /)  
KB(:, 1,18, 9) = (/ &
 & 0.81293E+00_JPRB,0.14815E+01_JPRB,0.16736E+01_JPRB,0.16776E+01_JPRB,0.12272E+01_JPRB /)  
KB(:, 2,18, 9) = (/ &
 & 0.83847E+00_JPRB,0.15352E+01_JPRB,0.17337E+01_JPRB,0.17293E+01_JPRB,0.12665E+01_JPRB /)  
KB(:, 3,18, 9) = (/ &
 & 0.86557E+00_JPRB,0.15883E+01_JPRB,0.17983E+01_JPRB,0.17854E+01_JPRB,0.13052E+01_JPRB /)  
KB(:, 4,18, 9) = (/ &
 & 0.89549E+00_JPRB,0.16413E+01_JPRB,0.18633E+01_JPRB,0.18465E+01_JPRB,0.13420E+01_JPRB /)  
KB(:, 5,18, 9) = (/ &
 & 0.92973E+00_JPRB,0.16952E+01_JPRB,0.19268E+01_JPRB,0.19102E+01_JPRB,0.13778E+01_JPRB /)  
KB(:, 1,19, 9) = (/ &
 & 0.70038E+00_JPRB,0.13093E+01_JPRB,0.14779E+01_JPRB,0.14733E+01_JPRB,0.10709E+01_JPRB /)  
KB(:, 2,19, 9) = (/ &
 & 0.72263E+00_JPRB,0.13577E+01_JPRB,0.15381E+01_JPRB,0.15268E+01_JPRB,0.11090E+01_JPRB /)  
KB(:, 3,19, 9) = (/ &
 & 0.74709E+00_JPRB,0.14065E+01_JPRB,0.15995E+01_JPRB,0.15853E+01_JPRB,0.11457E+01_JPRB /)  
KB(:, 4,19, 9) = (/ &
 & 0.77505E+00_JPRB,0.14562E+01_JPRB,0.16599E+01_JPRB,0.16467E+01_JPRB,0.11819E+01_JPRB /)  
KB(:, 5,19, 9) = (/ &
 & 0.80778E+00_JPRB,0.15082E+01_JPRB,0.17205E+01_JPRB,0.17095E+01_JPRB,0.12170E+01_JPRB /)  
KB(:, 1,20, 9) = (/ &
 & 0.60096E+00_JPRB,0.11549E+01_JPRB,0.13070E+01_JPRB,0.12966E+01_JPRB,0.93504E+00_JPRB /)  
KB(:, 2,20, 9) = (/ &
 & 0.62117E+00_JPRB,0.11996E+01_JPRB,0.13644E+01_JPRB,0.13518E+01_JPRB,0.97145E+00_JPRB /)  
KB(:, 3,20, 9) = (/ &
 & 0.64437E+00_JPRB,0.12456E+01_JPRB,0.14215E+01_JPRB,0.14105E+01_JPRB,0.10075E+01_JPRB /)  
KB(:, 4,20, 9) = (/ &
 & 0.67172E+00_JPRB,0.12935E+01_JPRB,0.14792E+01_JPRB,0.14711E+01_JPRB,0.10425E+01_JPRB /)  
KB(:, 5,20, 9) = (/ &
 & 0.70425E+00_JPRB,0.13447E+01_JPRB,0.15379E+01_JPRB,0.15320E+01_JPRB,0.10771E+01_JPRB /)  
KB(:, 1,21, 9) = (/ &
 & 0.51409E+00_JPRB,0.10184E+01_JPRB,0.11562E+01_JPRB,0.11440E+01_JPRB,0.81589E+00_JPRB /)  
KB(:, 2,21, 9) = (/ &
 & 0.53296E+00_JPRB,0.10604E+01_JPRB,0.12096E+01_JPRB,0.11991E+01_JPRB,0.85095E+00_JPRB /)  
KB(:, 3,21, 9) = (/ &
 & 0.55527E+00_JPRB,0.11043E+01_JPRB,0.12638E+01_JPRB,0.12567E+01_JPRB,0.88570E+00_JPRB /)  
KB(:, 4,21, 9) = (/ &
 & 0.58243E+00_JPRB,0.11512E+01_JPRB,0.13194E+01_JPRB,0.13151E+01_JPRB,0.92023E+00_JPRB /)  
KB(:, 5,21, 9) = (/ &
 & 0.61501E+00_JPRB,0.12017E+01_JPRB,0.13771E+01_JPRB,0.13737E+01_JPRB,0.95470E+00_JPRB /)  
KB(:, 1,22, 9) = (/ &
 & 0.44038E+00_JPRB,0.90186E+00_JPRB,0.10262E+01_JPRB,0.10153E+01_JPRB,0.71382E+00_JPRB /)  
KB(:, 2,22, 9) = (/ &
 & 0.45853E+00_JPRB,0.94198E+00_JPRB,0.10770E+01_JPRB,0.10695E+01_JPRB,0.74736E+00_JPRB /)  
KB(:, 3,22, 9) = (/ &
 & 0.48068E+00_JPRB,0.98449E+00_JPRB,0.11290E+01_JPRB,0.11248E+01_JPRB,0.78150E+00_JPRB /)  
KB(:, 4,22, 9) = (/ &
 & 0.50812E+00_JPRB,0.10306E+01_JPRB,0.11833E+01_JPRB,0.11809E+01_JPRB,0.81518E+00_JPRB /)  
KB(:, 5,22, 9) = (/ &
 & 0.54141E+00_JPRB,0.10817E+01_JPRB,0.12405E+01_JPRB,0.12383E+01_JPRB,0.84849E+00_JPRB /)  
KB(:, 1,23, 9) = (/ &
 & 0.37767E+00_JPRB,0.80078E+00_JPRB,0.91306E+00_JPRB,0.90433E+00_JPRB,0.62612E+00_JPRB /)  
KB(:, 2,23, 9) = (/ &
 & 0.39558E+00_JPRB,0.83957E+00_JPRB,0.96154E+00_JPRB,0.95658E+00_JPRB,0.65837E+00_JPRB /)  
KB(:, 3,23, 9) = (/ &
 & 0.41794E+00_JPRB,0.88149E+00_JPRB,0.10123E+01_JPRB,0.10097E+01_JPRB,0.69117E+00_JPRB /)  
KB(:, 4,23, 9) = (/ &
 & 0.44579E+00_JPRB,0.92784E+00_JPRB,0.10657E+01_JPRB,0.10643E+01_JPRB,0.72352E+00_JPRB /)  
KB(:, 5,23, 9) = (/ &
 & 0.47930E+00_JPRB,0.97981E+00_JPRB,0.11229E+01_JPRB,0.11209E+01_JPRB,0.75697E+00_JPRB /)  
KB(:, 1,24, 9) = (/ &
 & 0.32501E+00_JPRB,0.71314E+00_JPRB,0.81551E+00_JPRB,0.80817E+00_JPRB,0.55055E+00_JPRB /)  
KB(:, 2,24, 9) = (/ &
 & 0.34301E+00_JPRB,0.75171E+00_JPRB,0.86229E+00_JPRB,0.85830E+00_JPRB,0.58144E+00_JPRB /)  
KB(:, 3,24, 9) = (/ &
 & 0.36572E+00_JPRB,0.79385E+00_JPRB,0.91196E+00_JPRB,0.91014E+00_JPRB,0.61242E+00_JPRB /)  
KB(:, 4,24, 9) = (/ &
 & 0.39391E+00_JPRB,0.84084E+00_JPRB,0.96525E+00_JPRB,0.96386E+00_JPRB,0.64468E+00_JPRB /)  
KB(:, 5,24, 9) = (/ &
 & 0.42682E+00_JPRB,0.89378E+00_JPRB,0.10230E+01_JPRB,0.10202E+01_JPRB,0.67755E+00_JPRB /)  
KB(:, 1,25, 9) = (/ &
 & 0.28120E+00_JPRB,0.63782E+00_JPRB,0.73197E+00_JPRB,0.72532E+00_JPRB,0.48624E+00_JPRB /)  
KB(:, 2,25, 9) = (/ &
 & 0.29939E+00_JPRB,0.67672E+00_JPRB,0.77772E+00_JPRB,0.77395E+00_JPRB,0.51566E+00_JPRB /)  
KB(:, 3,25, 9) = (/ &
 & 0.32259E+00_JPRB,0.71969E+00_JPRB,0.82682E+00_JPRB,0.82484E+00_JPRB,0.54562E+00_JPRB /)  
KB(:, 4,25, 9) = (/ &
 & 0.35054E+00_JPRB,0.76785E+00_JPRB,0.88040E+00_JPRB,0.87836E+00_JPRB,0.57709E+00_JPRB /)  
KB(:, 5,25, 9) = (/ &
 & 0.38231E+00_JPRB,0.82200E+00_JPRB,0.93896E+00_JPRB,0.93503E+00_JPRB,0.60997E+00_JPRB /)  
KB(:, 1,26, 9) = (/ &
 & 0.24516E+00_JPRB,0.57415E+00_JPRB,0.66146E+00_JPRB,0.65501E+00_JPRB,0.43198E+00_JPRB /)  
KB(:, 2,26, 9) = (/ &
 & 0.26380E+00_JPRB,0.61364E+00_JPRB,0.70651E+00_JPRB,0.70261E+00_JPRB,0.46025E+00_JPRB /)  
KB(:, 3,26, 9) = (/ &
 & 0.28716E+00_JPRB,0.65790E+00_JPRB,0.75577E+00_JPRB,0.75300E+00_JPRB,0.48987E+00_JPRB /)  
KB(:, 4,26, 9) = (/ &
 & 0.31438E+00_JPRB,0.70747E+00_JPRB,0.80990E+00_JPRB,0.80672E+00_JPRB,0.52086E+00_JPRB /)  
KB(:, 5,26, 9) = (/ &
 & 0.34509E+00_JPRB,0.76331E+00_JPRB,0.86957E+00_JPRB,0.86437E+00_JPRB,0.55315E+00_JPRB /)  
KB(:, 1,27, 9) = (/ &
 & 0.21544E+00_JPRB,0.52037E+00_JPRB,0.60144E+00_JPRB,0.59535E+00_JPRB,0.38600E+00_JPRB /)  
KB(:, 2,27, 9) = (/ &
 & 0.23456E+00_JPRB,0.56067E+00_JPRB,0.64661E+00_JPRB,0.64229E+00_JPRB,0.41342E+00_JPRB /)  
KB(:, 3,27, 9) = (/ &
 & 0.25766E+00_JPRB,0.60633E+00_JPRB,0.69633E+00_JPRB,0.69257E+00_JPRB,0.44235E+00_JPRB /)  
KB(:, 4,27, 9) = (/ &
 & 0.28405E+00_JPRB,0.65751E+00_JPRB,0.75133E+00_JPRB,0.74692E+00_JPRB,0.47298E+00_JPRB /)  
KB(:, 5,27, 9) = (/ &
 & 0.31370E+00_JPRB,0.71529E+00_JPRB,0.81234E+00_JPRB,0.80601E+00_JPRB,0.50534E+00_JPRB /)  
KB(:, 1,28, 9) = (/ &
 & 0.19107E+00_JPRB,0.47529E+00_JPRB,0.55077E+00_JPRB,0.54503E+00_JPRB,0.34666E+00_JPRB /)  
KB(:, 2,28, 9) = (/ &
 & 0.21041E+00_JPRB,0.51675E+00_JPRB,0.59653E+00_JPRB,0.59172E+00_JPRB,0.37350E+00_JPRB /)  
KB(:, 3,28, 9) = (/ &
 & 0.23301E+00_JPRB,0.56364E+00_JPRB,0.64698E+00_JPRB,0.64221E+00_JPRB,0.40186E+00_JPRB /)  
KB(:, 4,28, 9) = (/ &
 & 0.25866E+00_JPRB,0.61667E+00_JPRB,0.70320E+00_JPRB,0.69763E+00_JPRB,0.43205E+00_JPRB /)  
KB(:, 5,28, 9) = (/ &
 & 0.28710E+00_JPRB,0.67650E+00_JPRB,0.76586E+00_JPRB,0.75834E+00_JPRB,0.46367E+00_JPRB /)  
KB(:, 1,29, 9) = (/ &
 & 0.17112E+00_JPRB,0.43830E+00_JPRB,0.50881E+00_JPRB,0.50311E+00_JPRB,0.31371E+00_JPRB /)  
KB(:, 2,29, 9) = (/ &
 & 0.19046E+00_JPRB,0.48081E+00_JPRB,0.55535E+00_JPRB,0.54996E+00_JPRB,0.34018E+00_JPRB /)  
KB(:, 3,29, 9) = (/ &
 & 0.21264E+00_JPRB,0.52926E+00_JPRB,0.60692E+00_JPRB,0.60125E+00_JPRB,0.36829E+00_JPRB /)  
KB(:, 4,29, 9) = (/ &
 & 0.23734E+00_JPRB,0.58428E+00_JPRB,0.66473E+00_JPRB,0.65816E+00_JPRB,0.39807E+00_JPRB /)  
KB(:, 5,29, 9) = (/ &
 & 0.26483E+00_JPRB,0.64604E+00_JPRB,0.72961E+00_JPRB,0.72085E+00_JPRB,0.42916E+00_JPRB /)  
KB(:, 1,30, 9) = (/ &
 & 0.15474E+00_JPRB,0.40804E+00_JPRB,0.47416E+00_JPRB,0.46844E+00_JPRB,0.28591E+00_JPRB /)  
KB(:, 2,30, 9) = (/ &
 & 0.17385E+00_JPRB,0.45175E+00_JPRB,0.52179E+00_JPRB,0.51582E+00_JPRB,0.31208E+00_JPRB /)  
KB(:, 3,30, 9) = (/ &
 & 0.19550E+00_JPRB,0.50197E+00_JPRB,0.57484E+00_JPRB,0.56852E+00_JPRB,0.33963E+00_JPRB /)  
KB(:, 4,30, 9) = (/ &
 & 0.21942E+00_JPRB,0.55897E+00_JPRB,0.63459E+00_JPRB,0.62718E+00_JPRB,0.36926E+00_JPRB /)  
KB(:, 5,30, 9) = (/ &
 & 0.24626E+00_JPRB,0.62254E+00_JPRB,0.70206E+00_JPRB,0.69222E+00_JPRB,0.40317E+00_JPRB /)  
KB(:, 1,31, 9) = (/ &
 & 0.14123E+00_JPRB,0.38383E+00_JPRB,0.44627E+00_JPRB,0.44042E+00_JPRB,0.26282E+00_JPRB /)  
KB(:, 2,31, 9) = (/ &
 & 0.16008E+00_JPRB,0.42905E+00_JPRB,0.49523E+00_JPRB,0.48891E+00_JPRB,0.28832E+00_JPRB /)  
KB(:, 3,31, 9) = (/ &
 & 0.18115E+00_JPRB,0.48120E+00_JPRB,0.55018E+00_JPRB,0.54338E+00_JPRB,0.31669E+00_JPRB /)  
KB(:, 4,31, 9) = (/ &
 & 0.20456E+00_JPRB,0.54014E+00_JPRB,0.61227E+00_JPRB,0.60422E+00_JPRB,0.34861E+00_JPRB /)  
KB(:, 5,31, 9) = (/ &
 & 0.23090E+00_JPRB,0.60549E+00_JPRB,0.68253E+00_JPRB,0.67193E+00_JPRB,0.38334E+00_JPRB /)  
KB(:, 1,32, 9) = (/ &
 & 0.13011E+00_JPRB,0.36494E+00_JPRB,0.42434E+00_JPRB,0.41840E+00_JPRB,0.24343E+00_JPRB /)  
KB(:, 2,32, 9) = (/ &
 & 0.14859E+00_JPRB,0.41192E+00_JPRB,0.47502E+00_JPRB,0.46846E+00_JPRB,0.27034E+00_JPRB /)  
KB(:, 3,32, 9) = (/ &
 & 0.16925E+00_JPRB,0.46604E+00_JPRB,0.53210E+00_JPRB,0.52502E+00_JPRB,0.30012E+00_JPRB /)  
KB(:, 4,32, 9) = (/ &
 & 0.19229E+00_JPRB,0.52692E+00_JPRB,0.59693E+00_JPRB,0.58841E+00_JPRB,0.33258E+00_JPRB /)  
KB(:, 5,32, 9) = (/ &
 & 0.21839E+00_JPRB,0.59419E+00_JPRB,0.67028E+00_JPRB,0.65920E+00_JPRB,0.36819E+00_JPRB /)  
KB(:, 1,33, 9) = (/ &
 & 0.12092E+00_JPRB,0.35074E+00_JPRB,0.40776E+00_JPRB,0.40175E+00_JPRB,0.22934E+00_JPRB /)  
KB(:, 2,33, 9) = (/ &
 & 0.13904E+00_JPRB,0.39967E+00_JPRB,0.46044E+00_JPRB,0.45383E+00_JPRB,0.25698E+00_JPRB /)  
KB(:, 3,33, 9) = (/ &
 & 0.15944E+00_JPRB,0.45574E+00_JPRB,0.51998E+00_JPRB,0.51285E+00_JPRB,0.28727E+00_JPRB /)  
KB(:, 4,33, 9) = (/ &
 & 0.18230E+00_JPRB,0.51859E+00_JPRB,0.58782E+00_JPRB,0.57914E+00_JPRB,0.32052E+00_JPRB /)  
KB(:, 5,33, 9) = (/ &
 & 0.20843E+00_JPRB,0.58793E+00_JPRB,0.66452E+00_JPRB,0.65307E+00_JPRB,0.35723E+00_JPRB /)  
KB(:, 1,34, 9) = (/ &
 & 0.11270E+00_JPRB,0.33906E+00_JPRB,0.39419E+00_JPRB,0.38828E+00_JPRB,0.21761E+00_JPRB /)  
KB(:, 2,34, 9) = (/ &
 & 0.13054E+00_JPRB,0.38970E+00_JPRB,0.44887E+00_JPRB,0.44251E+00_JPRB,0.24563E+00_JPRB /)  
KB(:, 3,34, 9) = (/ &
 & 0.15070E+00_JPRB,0.44751E+00_JPRB,0.51092E+00_JPRB,0.50399E+00_JPRB,0.27652E+00_JPRB /)  
KB(:, 4,34, 9) = (/ &
 & 0.17349E+00_JPRB,0.51224E+00_JPRB,0.58169E+00_JPRB,0.57301E+00_JPRB,0.31064E+00_JPRB /)  
KB(:, 5,34, 9) = (/ &
 & 0.19973E+00_JPRB,0.58363E+00_JPRB,0.66163E+00_JPRB,0.64989E+00_JPRB,0.34860E+00_JPRB /)  
KB(:, 1,35, 9) = (/ &
 & 0.10431E+00_JPRB,0.32621E+00_JPRB,0.37969E+00_JPRB,0.37421E+00_JPRB,0.20589E+00_JPRB /)  
KB(:, 2,35, 9) = (/ &
 & 0.12172E+00_JPRB,0.37794E+00_JPRB,0.43594E+00_JPRB,0.43005E+00_JPRB,0.23415E+00_JPRB /)  
KB(:, 3,35, 9) = (/ &
 & 0.14155E+00_JPRB,0.43696E+00_JPRB,0.49993E+00_JPRB,0.49338E+00_JPRB,0.26546E+00_JPRB /)  
KB(:, 4,35, 9) = (/ &
 & 0.16416E+00_JPRB,0.50303E+00_JPRB,0.57285E+00_JPRB,0.56442E+00_JPRB,0.30031E+00_JPRB /)  
KB(:, 5,35, 9) = (/ &
 & 0.19033E+00_JPRB,0.57592E+00_JPRB,0.65509E+00_JPRB,0.64342E+00_JPRB,0.33926E+00_JPRB /)  
KB(:, 1,36, 9) = (/ &
 & 0.95441E-01_JPRB,0.31093E+00_JPRB,0.36283E+00_JPRB,0.35795E+00_JPRB,0.19348E+00_JPRB /)  
KB(:, 2,36, 9) = (/ &
 & 0.11226E+00_JPRB,0.36299E+00_JPRB,0.41996E+00_JPRB,0.41468E+00_JPRB,0.22173E+00_JPRB /)  
KB(:, 3,36, 9) = (/ &
 & 0.13160E+00_JPRB,0.42251E+00_JPRB,0.48508E+00_JPRB,0.47906E+00_JPRB,0.25327E+00_JPRB /)  
KB(:, 4,36, 9) = (/ &
 & 0.15379E+00_JPRB,0.48924E+00_JPRB,0.55909E+00_JPRB,0.55119E+00_JPRB,0.28853E+00_JPRB /)  
KB(:, 5,36, 9) = (/ &
 & 0.17959E+00_JPRB,0.56298E+00_JPRB,0.64257E+00_JPRB,0.63136E+00_JPRB,0.32808E+00_JPRB /)  
KB(:, 1,37, 9) = (/ &
 & 0.85477E-01_JPRB,0.29072E+00_JPRB,0.34067E+00_JPRB,0.33658E+00_JPRB,0.17886E+00_JPRB /)  
KB(:, 2,37, 9) = (/ &
 & 0.10144E+00_JPRB,0.34200E+00_JPRB,0.39763E+00_JPRB,0.39300E+00_JPRB,0.20669E+00_JPRB /)  
KB(:, 3,37, 9) = (/ &
 & 0.11996E+00_JPRB,0.40095E+00_JPRB,0.46252E+00_JPRB,0.45719E+00_JPRB,0.23796E+00_JPRB /)  
KB(:, 4,37, 9) = (/ &
 & 0.14137E+00_JPRB,0.46732E+00_JPRB,0.53621E+00_JPRB,0.52913E+00_JPRB,0.27304E+00_JPRB /)  
KB(:, 5,37, 9) = (/ &
 & 0.16629E+00_JPRB,0.54086E+00_JPRB,0.61939E+00_JPRB,0.60918E+00_JPRB,0.31246E+00_JPRB /)  
KB(:, 1,38, 9) = (/ &
 & 0.76626E-01_JPRB,0.27223E+00_JPRB,0.32047E+00_JPRB,0.31724E+00_JPRB,0.16576E+00_JPRB /)  
KB(:, 2,38, 9) = (/ &
 & 0.91774E-01_JPRB,0.32273E+00_JPRB,0.37721E+00_JPRB,0.37319E+00_JPRB,0.19315E+00_JPRB /)  
KB(:, 3,38, 9) = (/ &
 & 0.10950E+00_JPRB,0.38104E+00_JPRB,0.44177E+00_JPRB,0.43708E+00_JPRB,0.22413E+00_JPRB /)  
KB(:, 4,38, 9) = (/ &
 & 0.13015E+00_JPRB,0.44697E+00_JPRB,0.51498E+00_JPRB,0.50870E+00_JPRB,0.25903E+00_JPRB /)  
KB(:, 5,38, 9) = (/ &
 & 0.15424E+00_JPRB,0.52018E+00_JPRB,0.59766E+00_JPRB,0.58842E+00_JPRB,0.29827E+00_JPRB /)  
KB(:, 1,39, 9) = (/ &
 & 0.68857E-01_JPRB,0.25564E+00_JPRB,0.30247E+00_JPRB,0.30005E+00_JPRB,0.15419E+00_JPRB /)  
KB(:, 2,39, 9) = (/ &
 & 0.83231E-01_JPRB,0.30541E+00_JPRB,0.35891E+00_JPRB,0.35551E+00_JPRB,0.18117E+00_JPRB /)  
KB(:, 3,39, 9) = (/ &
 & 0.10022E+00_JPRB,0.36305E+00_JPRB,0.42306E+00_JPRB,0.41901E+00_JPRB,0.21190E+00_JPRB /)  
KB(:, 4,39, 9) = (/ &
 & 0.12015E+00_JPRB,0.42854E+00_JPRB,0.49574E+00_JPRB,0.49023E+00_JPRB,0.24662E+00_JPRB /)  
KB(:, 5,39, 9) = (/ &
 & 0.14353E+00_JPRB,0.50140E+00_JPRB,0.57784E+00_JPRB,0.56950E+00_JPRB,0.28564E+00_JPRB /)  
KB(:, 1,40, 9) = (/ &
 & 0.60721E-01_JPRB,0.23607E+00_JPRB,0.28098E+00_JPRB,0.27949E+00_JPRB,0.14134E+00_JPRB /)  
KB(:, 2,40, 9) = (/ &
 & 0.74142E-01_JPRB,0.28436E+00_JPRB,0.33629E+00_JPRB,0.33356E+00_JPRB,0.16758E+00_JPRB /)  
KB(:, 3,40, 9) = (/ &
 & 0.90161E-01_JPRB,0.34051E+00_JPRB,0.39918E+00_JPRB,0.39576E+00_JPRB,0.19765E+00_JPRB /)  
KB(:, 4,40, 9) = (/ &
 & 0.10909E+00_JPRB,0.40469E+00_JPRB,0.47035E+00_JPRB,0.46571E+00_JPRB,0.23173E+00_JPRB /)  
KB(:, 5,40, 9) = (/ &
 & 0.13146E+00_JPRB,0.47643E+00_JPRB,0.55083E+00_JPRB,0.54364E+00_JPRB,0.27006E+00_JPRB /)  
KB(:, 1,41, 9) = (/ &
 & 0.53403E-01_JPRB,0.21760E+00_JPRB,0.26060E+00_JPRB,0.26004E+00_JPRB,0.12944E+00_JPRB /)  
KB(:, 2,41, 9) = (/ &
 & 0.65918E-01_JPRB,0.26438E+00_JPRB,0.31466E+00_JPRB,0.31265E+00_JPRB,0.15490E+00_JPRB /)  
KB(:, 3,41, 9) = (/ &
 & 0.80936E-01_JPRB,0.31888E+00_JPRB,0.37609E+00_JPRB,0.37327E+00_JPRB,0.18421E+00_JPRB /)  
KB(:, 4,41, 9) = (/ &
 & 0.98889E-01_JPRB,0.38155E+00_JPRB,0.44565E+00_JPRB,0.44176E+00_JPRB,0.21756E+00_JPRB /)  
KB(:, 5,41, 9) = (/ &
 & 0.12024E+00_JPRB,0.45195E+00_JPRB,0.52424E+00_JPRB,0.51812E+00_JPRB,0.25511E+00_JPRB /)  
KB(:, 1,42, 9) = (/ &
 & 0.46980E-01_JPRB,0.20072E+00_JPRB,0.24188E+00_JPRB,0.24222E+00_JPRB,0.11863E+00_JPRB /)  
KB(:, 2,42, 9) = (/ &
 & 0.58572E-01_JPRB,0.24586E+00_JPRB,0.29443E+00_JPRB,0.29314E+00_JPRB,0.14330E+00_JPRB /)  
KB(:, 3,42, 9) = (/ &
 & 0.72653E-01_JPRB,0.29875E+00_JPRB,0.35445E+00_JPRB,0.35212E+00_JPRB,0.17184E+00_JPRB /)  
KB(:, 4,42, 9) = (/ &
 & 0.89663E-01_JPRB,0.35979E+00_JPRB,0.42236E+00_JPRB,0.41911E+00_JPRB,0.20443E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART25',1,ZHOOK_HANDLE)
END SUBROUTINE PART25


SUBROUTINE PART26

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART26',0,ZHOOK_HANDLE)


KB(:, 5,42, 9) = (/ &
 & 0.11004E+00_JPRB,0.42873E+00_JPRB,0.49904E+00_JPRB,0.49389E+00_JPRB,0.24118E+00_JPRB /)  
KB(:, 1,43, 9) = (/ &
 & 0.40748E-01_JPRB,0.18301E+00_JPRB,0.22189E+00_JPRB,0.22309E+00_JPRB,0.10752E+00_JPRB /)  
KB(:, 2,43, 9) = (/ &
 & 0.51357E-01_JPRB,0.22603E+00_JPRB,0.27246E+00_JPRB,0.27198E+00_JPRB,0.13119E+00_JPRB /)  
KB(:, 3,43, 9) = (/ &
 & 0.64381E-01_JPRB,0.27684E+00_JPRB,0.33058E+00_JPRB,0.32881E+00_JPRB,0.15875E+00_JPRB /)  
KB(:, 4,43, 9) = (/ &
 & 0.80299E-01_JPRB,0.33572E+00_JPRB,0.39639E+00_JPRB,0.39376E+00_JPRB,0.19029E+00_JPRB /)  
KB(:, 5,43, 9) = (/ &
 & 0.99551E-01_JPRB,0.40267E+00_JPRB,0.47065E+00_JPRB,0.46647E+00_JPRB,0.22598E+00_JPRB /)  
KB(:, 1,44, 9) = (/ &
 & 0.35065E-01_JPRB,0.16586E+00_JPRB,0.20221E+00_JPRB,0.20417E+00_JPRB,0.96831E-01_JPRB /)  
KB(:, 2,44, 9) = (/ &
 & 0.44686E-01_JPRB,0.20650E+00_JPRB,0.25055E+00_JPRB,0.25097E+00_JPRB,0.11942E+00_JPRB /)  
KB(:, 3,44, 9) = (/ &
 & 0.56631E-01_JPRB,0.25500E+00_JPRB,0.30652E+00_JPRB,0.30540E+00_JPRB,0.14585E+00_JPRB /)  
KB(:, 4,44, 9) = (/ &
 & 0.71442E-01_JPRB,0.31160E+00_JPRB,0.37021E+00_JPRB,0.36812E+00_JPRB,0.17630E+00_JPRB /)  
KB(:, 5,44, 9) = (/ &
 & 0.89487E-01_JPRB,0.37611E+00_JPRB,0.44177E+00_JPRB,0.43843E+00_JPRB,0.21076E+00_JPRB /)  
KB(:, 1,45, 9) = (/ &
 & 0.30099E-01_JPRB,0.15014E+00_JPRB,0.18399E+00_JPRB,0.18651E+00_JPRB,0.87081E-01_JPRB /)  
KB(:, 2,45, 9) = (/ &
 & 0.38792E-01_JPRB,0.18842E+00_JPRB,0.23006E+00_JPRB,0.23134E+00_JPRB,0.10857E+00_JPRB /)  
KB(:, 3,45, 9) = (/ &
 & 0.49706E-01_JPRB,0.23455E+00_JPRB,0.28377E+00_JPRB,0.28337E+00_JPRB,0.13385E+00_JPRB /)  
KB(:, 4,45, 9) = (/ &
 & 0.63416E-01_JPRB,0.28880E+00_JPRB,0.34526E+00_JPRB,0.34365E+00_JPRB,0.16313E+00_JPRB /)  
KB(:, 5,45, 9) = (/ &
 & 0.80320E-01_JPRB,0.35087E+00_JPRB,0.41430E+00_JPRB,0.41165E+00_JPRB,0.19641E+00_JPRB /)  
KB(:, 1,46, 9) = (/ &
 & 0.25615E-01_JPRB,0.13501E+00_JPRB,0.16621E+00_JPRB,0.16909E+00_JPRB,0.77761E-01_JPRB /)  
KB(:, 2,46, 9) = (/ &
 & 0.33396E-01_JPRB,0.17087E+00_JPRB,0.20986E+00_JPRB,0.21193E+00_JPRB,0.98069E-01_JPRB /)  
KB(:, 3,46, 9) = (/ &
 & 0.43320E-01_JPRB,0.21451E+00_JPRB,0.26120E+00_JPRB,0.26156E+00_JPRB,0.12212E+00_JPRB /)  
KB(:, 4,46, 9) = (/ &
 & 0.55857E-01_JPRB,0.26606E+00_JPRB,0.32018E+00_JPRB,0.31908E+00_JPRB,0.15012E+00_JPRB /)  
KB(:, 5,46, 9) = (/ &
 & 0.71564E-01_JPRB,0.32546E+00_JPRB,0.38657E+00_JPRB,0.38454E+00_JPRB,0.18211E+00_JPRB /)  
KB(:, 1,47, 9) = (/ &
 & 0.21470E-01_JPRB,0.11984E+00_JPRB,0.14813E+00_JPRB,0.15126E+00_JPRB,0.68564E-01_JPRB /)  
KB(:, 2,47, 9) = (/ &
 & 0.28327E-01_JPRB,0.15313E+00_JPRB,0.18908E+00_JPRB,0.19182E+00_JPRB,0.87445E-01_JPRB /)  
KB(:, 3,47, 9) = (/ &
 & 0.37186E-01_JPRB,0.19381E+00_JPRB,0.23756E+00_JPRB,0.23882E+00_JPRB,0.11016E+00_JPRB /)  
KB(:, 4,47, 9) = (/ &
 & 0.48514E-01_JPRB,0.24239E+00_JPRB,0.29373E+00_JPRB,0.29331E+00_JPRB,0.13670E+00_JPRB /)  
KB(:, 5,47, 9) = (/ &
 & 0.62915E-01_JPRB,0.29879E+00_JPRB,0.35729E+00_JPRB,0.35580E+00_JPRB,0.16718E+00_JPRB /)  
KB(:, 1,48, 9) = (/ &
 & 0.17915E-01_JPRB,0.10594E+00_JPRB,0.13153E+00_JPRB,0.13471E+00_JPRB,0.60247E-01_JPRB /)  
KB(:, 2,48, 9) = (/ &
 & 0.23922E-01_JPRB,0.13687E+00_JPRB,0.16982E+00_JPRB,0.17297E+00_JPRB,0.77702E-01_JPRB /)  
KB(:, 3,48, 9) = (/ &
 & 0.31789E-01_JPRB,0.17464E+00_JPRB,0.21543E+00_JPRB,0.21754E+00_JPRB,0.99032E-01_JPRB /)  
KB(:, 4,48, 9) = (/ &
 & 0.41975E-01_JPRB,0.22024E+00_JPRB,0.26872E+00_JPRB,0.26906E+00_JPRB,0.12414E+00_JPRB /)  
KB(:, 5,48, 9) = (/ &
 & 0.55099E-01_JPRB,0.27366E+00_JPRB,0.32950E+00_JPRB,0.32848E+00_JPRB,0.15313E+00_JPRB /)  
KB(:, 1,49, 9) = (/ &
 & 0.14883E-01_JPRB,0.93224E-01_JPRB,0.11635E+00_JPRB,0.11939E+00_JPRB,0.52749E-01_JPRB /)  
KB(:, 2,49, 9) = (/ &
 & 0.20112E-01_JPRB,0.12194E+00_JPRB,0.15191E+00_JPRB,0.15532E+00_JPRB,0.68811E-01_JPRB /)  
KB(:, 3,49, 9) = (/ &
 & 0.27052E-01_JPRB,0.15700E+00_JPRB,0.19473E+00_JPRB,0.19754E+00_JPRB,0.88692E-01_JPRB /)  
KB(:, 4,49, 9) = (/ &
 & 0.36170E-01_JPRB,0.19958E+00_JPRB,0.24512E+00_JPRB,0.24626E+00_JPRB,0.11239E+00_JPRB /)  
KB(:, 5,49, 9) = (/ &
 & 0.48053E-01_JPRB,0.24998E+00_JPRB,0.30305E+00_JPRB,0.30260E+00_JPRB,0.13992E+00_JPRB /)  
KB(:, 1,50, 9) = (/ &
 & 0.12401E-01_JPRB,0.82224E-01_JPRB,0.10323E+00_JPRB,0.10603E+00_JPRB,0.46388E-01_JPRB /)  
KB(:, 2,50, 9) = (/ &
 & 0.16961E-01_JPRB,0.10896E+00_JPRB,0.13629E+00_JPRB,0.13978E+00_JPRB,0.61130E-01_JPRB /)  
KB(:, 3,50, 9) = (/ &
 & 0.23097E-01_JPRB,0.14168E+00_JPRB,0.17654E+00_JPRB,0.17982E+00_JPRB,0.79649E-01_JPRB /)  
KB(:, 4,50, 9) = (/ &
 & 0.31266E-01_JPRB,0.18143E+00_JPRB,0.22418E+00_JPRB,0.22611E+00_JPRB,0.10201E+00_JPRB /)  
KB(:, 5,50, 9) = (/ &
 & 0.42049E-01_JPRB,0.22900E+00_JPRB,0.27939E+00_JPRB,0.27959E+00_JPRB,0.12818E+00_JPRB /)  
KB(:, 1,51, 9) = (/ &
 & 0.10311E-01_JPRB,0.72407E-01_JPRB,0.91543E-01_JPRB,0.94015E-01_JPRB,0.40739E-01_JPRB /)  
KB(:, 2,51, 9) = (/ &
 & 0.14299E-01_JPRB,0.97301E-01_JPRB,0.12223E+00_JPRB,0.12566E+00_JPRB,0.54336E-01_JPRB /)  
KB(:, 3,51, 9) = (/ &
 & 0.19709E-01_JPRB,0.12788E+00_JPRB,0.16001E+00_JPRB,0.16354E+00_JPRB,0.71514E-01_JPRB /)  
KB(:, 4,51, 9) = (/ &
 & 0.27010E-01_JPRB,0.16504E+00_JPRB,0.20502E+00_JPRB,0.20766E+00_JPRB,0.92576E-01_JPRB /)  
KB(:, 5,51, 9) = (/ &
 & 0.36820E-01_JPRB,0.20996E+00_JPRB,0.25769E+00_JPRB,0.25854E+00_JPRB,0.11743E+00_JPRB /)  
KB(:, 1,52, 9) = (/ &
 & 0.85238E-02_JPRB,0.63439E-01_JPRB,0.80796E-01_JPRB,0.82950E-01_JPRB,0.35726E-01_JPRB /)  
KB(:, 2,52, 9) = (/ &
 & 0.12004E-01_JPRB,0.86535E-01_JPRB,0.10929E+00_JPRB,0.11252E+00_JPRB,0.48201E-01_JPRB /)  
KB(:, 3,52, 9) = (/ &
 & 0.16756E-01_JPRB,0.11511E+00_JPRB,0.14456E+00_JPRB,0.14824E+00_JPRB,0.64036E-01_JPRB /)  
KB(:, 4,52, 9) = (/ &
 & 0.23247E-01_JPRB,0.14984E+00_JPRB,0.18701E+00_JPRB,0.19020E+00_JPRB,0.83745E-01_JPRB /)  
KB(:, 5,52, 9) = (/ &
 & 0.32110E-01_JPRB,0.19199E+00_JPRB,0.23699E+00_JPRB,0.23857E+00_JPRB,0.10729E+00_JPRB /)  
KB(:, 1,53, 9) = (/ &
 & 0.70021E-02_JPRB,0.55279E-01_JPRB,0.70908E-01_JPRB,0.72826E-01_JPRB,0.31267E-01_JPRB /)  
KB(:, 2,53, 9) = (/ &
 & 0.10022E-01_JPRB,0.76605E-01_JPRB,0.97337E-01_JPRB,0.10026E+00_JPRB,0.42555E-01_JPRB /)  
KB(:, 3,53, 9) = (/ &
 & 0.14186E-01_JPRB,0.10324E+00_JPRB,0.13015E+00_JPRB,0.13384E+00_JPRB,0.57176E-01_JPRB /)  
KB(:, 4,53, 9) = (/ &
 & 0.19924E-01_JPRB,0.13568E+00_JPRB,0.17006E+00_JPRB,0.17360E+00_JPRB,0.75508E-01_JPRB /)  
KB(:, 5,53, 9) = (/ &
 & 0.27873E-01_JPRB,0.17508E+00_JPRB,0.21734E+00_JPRB,0.21965E+00_JPRB,0.97730E-01_JPRB /)  
KB(:, 1,54, 9) = (/ &
 & 0.57827E-02_JPRB,0.48416E-01_JPRB,0.62508E-01_JPRB,0.64310E-01_JPRB,0.27618E-01_JPRB /)  
KB(:, 2,54, 9) = (/ &
 & 0.84043E-02_JPRB,0.68151E-01_JPRB,0.87167E-01_JPRB,0.89761E-01_JPRB,0.37874E-01_JPRB /)  
KB(:, 3,54, 9) = (/ &
 & 0.12088E-01_JPRB,0.93069E-01_JPRB,0.11782E+00_JPRB,0.12138E+00_JPRB,0.51418E-01_JPRB /)  
KB(:, 4,54, 9) = (/ &
 & 0.17188E-01_JPRB,0.12356E+00_JPRB,0.15542E+00_JPRB,0.15914E+00_JPRB,0.68446E-01_JPRB /)  
KB(:, 5,54, 9) = (/ &
 & 0.24356E-01_JPRB,0.16057E+00_JPRB,0.20027E+00_JPRB,0.20317E+00_JPRB,0.89427E-01_JPRB /)  
KB(:, 1,55, 9) = (/ &
 & 0.47829E-02_JPRB,0.42445E-01_JPRB,0.55108E-01_JPRB,0.56879E-01_JPRB,0.24415E-01_JPRB /)  
KB(:, 2,55, 9) = (/ &
 & 0.70515E-02_JPRB,0.60688E-01_JPRB,0.78130E-01_JPRB,0.80430E-01_JPRB,0.33849E-01_JPRB /)  
KB(:, 3,55, 9) = (/ &
 & 0.10307E-01_JPRB,0.83954E-01_JPRB,0.10678E+00_JPRB,0.11014E+00_JPRB,0.46263E-01_JPRB /)  
KB(:, 4,55, 9) = (/ &
 & 0.14854E-01_JPRB,0.11267E+00_JPRB,0.14216E+00_JPRB,0.14598E+00_JPRB,0.62158E-01_JPRB /)  
KB(:, 5,55, 9) = (/ &
 & 0.21317E-01_JPRB,0.14754E+00_JPRB,0.18474E+00_JPRB,0.18809E+00_JPRB,0.81914E-01_JPRB /)  
KB(:, 1,56, 9) = (/ &
 & 0.39349E-02_JPRB,0.37013E-01_JPRB,0.48295E-01_JPRB,0.50091E-01_JPRB,0.21529E-01_JPRB /)  
KB(:, 2,56, 9) = (/ &
 & 0.58808E-02_JPRB,0.53785E-01_JPRB,0.69695E-01_JPRB,0.71776E-01_JPRB,0.30144E-01_JPRB /)  
KB(:, 3,56, 9) = (/ &
 & 0.87470E-02_JPRB,0.75476E-01_JPRB,0.96519E-01_JPRB,0.99590E-01_JPRB,0.41605E-01_JPRB /)  
KB(:, 4,56, 9) = (/ &
 & 0.12799E-01_JPRB,0.10247E+00_JPRB,0.12972E+00_JPRB,0.13354E+00_JPRB,0.56396E-01_JPRB /)  
KB(:, 5,56, 9) = (/ &
 & 0.18597E-01_JPRB,0.13533E+00_JPRB,0.17007E+00_JPRB,0.17370E+00_JPRB,0.74854E-01_JPRB /)  
KB(:, 1,57, 9) = (/ &
 & 0.32237E-02_JPRB,0.32103E-01_JPRB,0.42068E-01_JPRB,0.43893E-01_JPRB,0.18889E-01_JPRB /)  
KB(:, 2,57, 9) = (/ &
 & 0.48776E-02_JPRB,0.47453E-01_JPRB,0.61873E-01_JPRB,0.63812E-01_JPRB,0.26899E-01_JPRB /)  
KB(:, 3,57, 9) = (/ &
 & 0.73816E-02_JPRB,0.67586E-01_JPRB,0.86956E-01_JPRB,0.89701E-01_JPRB,0.37405E-01_JPRB /)  
KB(:, 4,57, 9) = (/ &
 & 0.10984E-01_JPRB,0.92907E-01_JPRB,0.11806E+00_JPRB,0.12175E+00_JPRB,0.51002E-01_JPRB /)  
KB(:, 5,57, 9) = (/ &
 & 0.16168E-01_JPRB,0.12385E+00_JPRB,0.15617E+00_JPRB,0.15996E+00_JPRB,0.68253E-01_JPRB /)  
KB(:, 1,58, 9) = (/ &
 & 0.26462E-02_JPRB,0.27879E-01_JPRB,0.36685E-01_JPRB,0.38484E-01_JPRB,0.16601E-01_JPRB /)  
KB(:, 2,58, 9) = (/ &
 & 0.40522E-02_JPRB,0.41929E-01_JPRB,0.54967E-01_JPRB,0.56858E-01_JPRB,0.24050E-01_JPRB /)  
KB(:, 3,58, 9) = (/ &
 & 0.62364E-02_JPRB,0.60609E-01_JPRB,0.78458E-01_JPRB,0.80919E-01_JPRB,0.33657E-01_JPRB /)  
KB(:, 4,58, 9) = (/ &
 & 0.94512E-02_JPRB,0.84383E-01_JPRB,0.10769E+00_JPRB,0.11117E+00_JPRB,0.46338E-01_JPRB /)  
KB(:, 5,58, 9) = (/ &
 & 0.14101E-01_JPRB,0.11363E+00_JPRB,0.14367E+00_JPRB,0.14755E+00_JPRB,0.62487E-01_JPRB /)  
KB(:, 1,59, 9) = (/ &
 & 0.23375E-02_JPRB,0.26104E-01_JPRB,0.34483E-01_JPRB,0.36273E-01_JPRB,0.15643E-01_JPRB /)  
KB(:, 2,59, 9) = (/ &
 & 0.36353E-02_JPRB,0.39676E-01_JPRB,0.52191E-01_JPRB,0.54098E-01_JPRB,0.22879E-01_JPRB /)  
KB(:, 3,59, 9) = (/ &
 & 0.56781E-02_JPRB,0.57810E-01_JPRB,0.75085E-01_JPRB,0.77452E-01_JPRB,0.32253E-01_JPRB /)  
KB(:, 4,59, 9) = (/ &
 & 0.87345E-02_JPRB,0.80998E-01_JPRB,0.10362E+00_JPRB,0.10701E+00_JPRB,0.44587E-01_JPRB /)  
KB(:, 5,59, 9) = (/ &
 & 0.13202E-01_JPRB,0.10960E+00_JPRB,0.13878E+00_JPRB,0.14268E+00_JPRB,0.60173E-01_JPRB /)  
KB(:, 1,13,10) = (/ &
 & 0.68082E+01_JPRB,0.10647E+02_JPRB,0.12044E+02_JPRB,0.12092E+02_JPRB,0.85097E+01_JPRB /)  
KB(:, 2,13,10) = (/ &
 & 0.67019E+01_JPRB,0.10585E+02_JPRB,0.12055E+02_JPRB,0.12198E+02_JPRB,0.87119E+01_JPRB /)  
KB(:, 3,13,10) = (/ &
 & 0.67137E+01_JPRB,0.10536E+02_JPRB,0.12063E+02_JPRB,0.12312E+02_JPRB,0.88714E+01_JPRB /)  
KB(:, 4,13,10) = (/ &
 & 0.68713E+01_JPRB,0.10489E+02_JPRB,0.12087E+02_JPRB,0.12413E+02_JPRB,0.90170E+01_JPRB /)  
KB(:, 5,13,10) = (/ &
 & 0.71185E+01_JPRB,0.10479E+02_JPRB,0.12121E+02_JPRB,0.12479E+02_JPRB,0.91853E+01_JPRB /)  
KB(:, 1,14,10) = (/ &
 & 0.58410E+01_JPRB,0.94018E+01_JPRB,0.10846E+02_JPRB,0.11035E+02_JPRB,0.76674E+01_JPRB /)  
KB(:, 2,14,10) = (/ &
 & 0.58467E+01_JPRB,0.93735E+01_JPRB,0.10875E+02_JPRB,0.11156E+02_JPRB,0.78256E+01_JPRB /)  
KB(:, 3,14,10) = (/ &
 & 0.59984E+01_JPRB,0.93438E+01_JPRB,0.10908E+02_JPRB,0.11271E+02_JPRB,0.79426E+01_JPRB /)  
KB(:, 4,14,10) = (/ &
 & 0.62373E+01_JPRB,0.93563E+01_JPRB,0.10953E+02_JPRB,0.11364E+02_JPRB,0.81071E+01_JPRB /)  
KB(:, 5,14,10) = (/ &
 & 0.65135E+01_JPRB,0.94809E+01_JPRB,0.10997E+02_JPRB,0.11429E+02_JPRB,0.82861E+01_JPRB /)  
KB(:, 1,15,10) = (/ &
 & 0.50343E+01_JPRB,0.83265E+01_JPRB,0.97137E+01_JPRB,0.99946E+01_JPRB,0.69930E+01_JPRB /)  
KB(:, 2,15,10) = (/ &
 & 0.51660E+01_JPRB,0.83107E+01_JPRB,0.97594E+01_JPRB,0.10123E+02_JPRB,0.71240E+01_JPRB /)  
KB(:, 3,15,10) = (/ &
 & 0.53903E+01_JPRB,0.83316E+01_JPRB,0.98216E+01_JPRB,0.10239E+02_JPRB,0.72628E+01_JPRB /)  
KB(:, 4,15,10) = (/ &
 & 0.56415E+01_JPRB,0.84645E+01_JPRB,0.98856E+01_JPRB,0.10324E+02_JPRB,0.74229E+01_JPRB /)  
KB(:, 5,15,10) = (/ &
 & 0.58842E+01_JPRB,0.87055E+01_JPRB,0.99631E+01_JPRB,0.10400E+02_JPRB,0.75908E+01_JPRB /)  
KB(:, 1,16,10) = (/ &
 & 0.44015E+01_JPRB,0.74103E+01_JPRB,0.86530E+01_JPRB,0.90071E+01_JPRB,0.63301E+01_JPRB /)  
KB(:, 2,16,10) = (/ &
 & 0.45955E+01_JPRB,0.74391E+01_JPRB,0.87237E+01_JPRB,0.91359E+01_JPRB,0.64715E+01_JPRB /)  
KB(:, 3,16,10) = (/ &
 & 0.48140E+01_JPRB,0.75662E+01_JPRB,0.88065E+01_JPRB,0.92379E+01_JPRB,0.66426E+01_JPRB /)  
KB(:, 4,16,10) = (/ &
 & 0.50318E+01_JPRB,0.77981E+01_JPRB,0.89101E+01_JPRB,0.93283E+01_JPRB,0.68095E+01_JPRB /)  
KB(:, 5,16,10) = (/ &
 & 0.52436E+01_JPRB,0.80914E+01_JPRB,0.90522E+01_JPRB,0.94292E+01_JPRB,0.69717E+01_JPRB /)  
KB(:, 1,17,10) = (/ &
 & 0.38938E+01_JPRB,0.65976E+01_JPRB,0.77151E+01_JPRB,0.80672E+01_JPRB,0.57119E+01_JPRB /)  
KB(:, 2,17,10) = (/ &
 & 0.40781E+01_JPRB,0.67171E+01_JPRB,0.78068E+01_JPRB,0.81879E+01_JPRB,0.58706E+01_JPRB /)  
KB(:, 3,17,10) = (/ &
 & 0.42641E+01_JPRB,0.69435E+01_JPRB,0.79191E+01_JPRB,0.82934E+01_JPRB,0.60296E+01_JPRB /)  
KB(:, 4,17,10) = (/ &
 & 0.44480E+01_JPRB,0.72305E+01_JPRB,0.80762E+01_JPRB,0.84106E+01_JPRB,0.62012E+01_JPRB /)  
KB(:, 5,17,10) = (/ &
 & 0.46308E+01_JPRB,0.75237E+01_JPRB,0.83037E+01_JPRB,0.85418E+01_JPRB,0.63775E+01_JPRB /)  
KB(:, 1,18,10) = (/ &
 & 0.34407E+01_JPRB,0.58963E+01_JPRB,0.69001E+01_JPRB,0.71891E+01_JPRB,0.51366E+01_JPRB /)  
KB(:, 2,18,10) = (/ &
 & 0.35988E+01_JPRB,0.61068E+01_JPRB,0.70120E+01_JPRB,0.73051E+01_JPRB,0.52912E+01_JPRB /)  
KB(:, 3,18,10) = (/ &
 & 0.37577E+01_JPRB,0.63853E+01_JPRB,0.71752E+01_JPRB,0.74336E+01_JPRB,0.54376E+01_JPRB /)  
KB(:, 4,18,10) = (/ &
 & 0.39161E+01_JPRB,0.66726E+01_JPRB,0.74020E+01_JPRB,0.75773E+01_JPRB,0.56097E+01_JPRB /)  
KB(:, 5,18,10) = (/ &
 & 0.40711E+01_JPRB,0.69480E+01_JPRB,0.76793E+01_JPRB,0.77395E+01_JPRB,0.57994E+01_JPRB /)  
KB(:, 1,19,10) = (/ &
 & 0.30222E+01_JPRB,0.53136E+01_JPRB,0.61695E+01_JPRB,0.63815E+01_JPRB,0.46248E+01_JPRB /)  
KB(:, 2,19,10) = (/ &
 & 0.31568E+01_JPRB,0.55745E+01_JPRB,0.63303E+01_JPRB,0.65186E+01_JPRB,0.47653E+01_JPRB /)  
KB(:, 3,19,10) = (/ &
 & 0.32936E+01_JPRB,0.58515E+01_JPRB,0.65536E+01_JPRB,0.66691E+01_JPRB,0.49110E+01_JPRB /)  
KB(:, 4,19,10) = (/ &
 & 0.34320E+01_JPRB,0.61200E+01_JPRB,0.68298E+01_JPRB,0.68431E+01_JPRB,0.50671E+01_JPRB /)  
KB(:, 5,19,10) = (/ &
 & 0.35717E+01_JPRB,0.63810E+01_JPRB,0.71341E+01_JPRB,0.70485E+01_JPRB,0.52482E+01_JPRB /)  
KB(:, 1,20,10) = (/ &
 & 0.26646E+01_JPRB,0.48341E+01_JPRB,0.55294E+01_JPRB,0.56818E+01_JPRB,0.41697E+01_JPRB /)  
KB(:, 2,20,10) = (/ &
 & 0.27751E+01_JPRB,0.50933E+01_JPRB,0.57470E+01_JPRB,0.58376E+01_JPRB,0.43064E+01_JPRB /)  
KB(:, 3,20,10) = (/ &
 & 0.28895E+01_JPRB,0.53454E+01_JPRB,0.60203E+01_JPRB,0.60166E+01_JPRB,0.44569E+01_JPRB /)  
KB(:, 4,20,10) = (/ &
 & 0.30071E+01_JPRB,0.55962E+01_JPRB,0.63194E+01_JPRB,0.62235E+01_JPRB,0.46038E+01_JPRB /)  
KB(:, 5,20,10) = (/ &
 & 0.31278E+01_JPRB,0.58505E+01_JPRB,0.66184E+01_JPRB,0.64780E+01_JPRB,0.47569E+01_JPRB /)  
KB(:, 1,21,10) = (/ &
 & 0.23601E+01_JPRB,0.44020E+01_JPRB,0.49905E+01_JPRB,0.50776E+01_JPRB,0.37561E+01_JPRB /)  
KB(:, 2,21,10) = (/ &
 & 0.24527E+01_JPRB,0.46408E+01_JPRB,0.52514E+01_JPRB,0.52563E+01_JPRB,0.39021E+01_JPRB /)  
KB(:, 3,21,10) = (/ &
 & 0.25482E+01_JPRB,0.48775E+01_JPRB,0.55424E+01_JPRB,0.54642E+01_JPRB,0.40531E+01_JPRB /)  
KB(:, 4,21,10) = (/ &
 & 0.26469E+01_JPRB,0.51183E+01_JPRB,0.58389E+01_JPRB,0.57185E+01_JPRB,0.42025E+01_JPRB /)  
KB(:, 5,21,10) = (/ &
 & 0.27509E+01_JPRB,0.53673E+01_JPRB,0.61341E+01_JPRB,0.60025E+01_JPRB,0.43477E+01_JPRB /)  
KB(:, 1,22,10) = (/ &
 & 0.20933E+01_JPRB,0.40130E+01_JPRB,0.45530E+01_JPRB,0.45722E+01_JPRB,0.33997E+01_JPRB /)  
KB(:, 2,22,10) = (/ &
 & 0.21774E+01_JPRB,0.42389E+01_JPRB,0.48339E+01_JPRB,0.47801E+01_JPRB,0.35503E+01_JPRB /)  
KB(:, 3,22,10) = (/ &
 & 0.22636E+01_JPRB,0.44688E+01_JPRB,0.51214E+01_JPRB,0.50286E+01_JPRB,0.36916E+01_JPRB /)  
KB(:, 4,22,10) = (/ &
 & 0.23497E+01_JPRB,0.47085E+01_JPRB,0.54112E+01_JPRB,0.53109E+01_JPRB,0.38464E+01_JPRB /)  
KB(:, 5,22,10) = (/ &
 & 0.24400E+01_JPRB,0.49544E+01_JPRB,0.57104E+01_JPRB,0.56159E+01_JPRB,0.40026E+01_JPRB /)  
KB(:, 1,23,10) = (/ &
 & 0.18483E+01_JPRB,0.36572E+01_JPRB,0.41816E+01_JPRB,0.41476E+01_JPRB,0.30773E+01_JPRB /)  
KB(:, 2,23,10) = (/ &
 & 0.19296E+01_JPRB,0.38779E+01_JPRB,0.44582E+01_JPRB,0.43906E+01_JPRB,0.32324E+01_JPRB /)  
KB(:, 3,23,10) = (/ &
 & 0.20105E+01_JPRB,0.41090E+01_JPRB,0.47398E+01_JPRB,0.46676E+01_JPRB,0.33790E+01_JPRB /)  
KB(:, 4,23,10) = (/ &
 & 0.20922E+01_JPRB,0.43460E+01_JPRB,0.50319E+01_JPRB,0.49689E+01_JPRB,0.35381E+01_JPRB /)  
KB(:, 5,23,10) = (/ &
 & 0.21812E+01_JPRB,0.45942E+01_JPRB,0.53379E+01_JPRB,0.52907E+01_JPRB,0.36872E+01_JPRB /)  
KB(:, 1,24,10) = (/ &
 & 0.16291E+01_JPRB,0.33480E+01_JPRB,0.38514E+01_JPRB,0.38051E+01_JPRB,0.27880E+01_JPRB /)  
KB(:, 2,24,10) = (/ &
 & 0.17053E+01_JPRB,0.35635E+01_JPRB,0.41240E+01_JPRB,0.40716E+01_JPRB,0.29407E+01_JPRB /)  
KB(:, 3,24,10) = (/ &
 & 0.17841E+01_JPRB,0.37930E+01_JPRB,0.44076E+01_JPRB,0.43668E+01_JPRB,0.31035E+01_JPRB /)  
KB(:, 4,24,10) = (/ &
 & 0.18670E+01_JPRB,0.40349E+01_JPRB,0.47044E+01_JPRB,0.46831E+01_JPRB,0.32549E+01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART26',1,ZHOOK_HANDLE)
END SUBROUTINE PART26


SUBROUTINE PART27

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART27',0,ZHOOK_HANDLE)


KB(:, 5,24,10) = (/ &
 & 0.19687E+01_JPRB,0.42837E+01_JPRB,0.50178E+01_JPRB,0.50123E+01_JPRB,0.34093E+01_JPRB /)  
KB(:, 1,25,10) = (/ &
 & 0.14342E+01_JPRB,0.30870E+01_JPRB,0.35616E+01_JPRB,0.35262E+01_JPRB,0.25309E+01_JPRB /)  
KB(:, 2,25,10) = (/ &
 & 0.15073E+01_JPRB,0.32988E+01_JPRB,0.38348E+01_JPRB,0.38083E+01_JPRB,0.26935E+01_JPRB /)  
KB(:, 3,25,10) = (/ &
 & 0.15855E+01_JPRB,0.35267E+01_JPRB,0.41227E+01_JPRB,0.41156E+01_JPRB,0.28544E+01_JPRB /)  
KB(:, 4,25,10) = (/ &
 & 0.16765E+01_JPRB,0.37674E+01_JPRB,0.44270E+01_JPRB,0.44387E+01_JPRB,0.30112E+01_JPRB /)  
KB(:, 5,25,10) = (/ &
 & 0.17969E+01_JPRB,0.40179E+01_JPRB,0.47482E+01_JPRB,0.47807E+01_JPRB,0.31986E+01_JPRB /)  
KB(:, 1,26,10) = (/ &
 & 0.12644E+01_JPRB,0.28734E+01_JPRB,0.33145E+01_JPRB,0.33023E+01_JPRB,0.23207E+01_JPRB /)  
KB(:, 2,26,10) = (/ &
 & 0.13357E+01_JPRB,0.30796E+01_JPRB,0.35932E+01_JPRB,0.35956E+01_JPRB,0.24777E+01_JPRB /)  
KB(:, 3,26,10) = (/ &
 & 0.14174E+01_JPRB,0.33035E+01_JPRB,0.38863E+01_JPRB,0.39081E+01_JPRB,0.26420E+01_JPRB /)  
KB(:, 4,26,10) = (/ &
 & 0.15234E+01_JPRB,0.35430E+01_JPRB,0.41997E+01_JPRB,0.42431E+01_JPRB,0.28241E+01_JPRB /)  
KB(:, 5,26,10) = (/ &
 & 0.16603E+01_JPRB,0.37959E+01_JPRB,0.45341E+01_JPRB,0.45996E+01_JPRB,0.30401E+01_JPRB /)  
KB(:, 1,27,10) = (/ &
 & 0.11180E+01_JPRB,0.26923E+01_JPRB,0.31092E+01_JPRB,0.31181E+01_JPRB,0.21320E+01_JPRB /)  
KB(:, 2,27,10) = (/ &
 & 0.11893E+01_JPRB,0.28981E+01_JPRB,0.33903E+01_JPRB,0.34176E+01_JPRB,0.22961E+01_JPRB /)  
KB(:, 3,27,10) = (/ &
 & 0.12805E+01_JPRB,0.31184E+01_JPRB,0.36930E+01_JPRB,0.37398E+01_JPRB,0.24775E+01_JPRB /)  
KB(:, 4,27,10) = (/ &
 & 0.14017E+01_JPRB,0.33577E+01_JPRB,0.40190E+01_JPRB,0.40909E+01_JPRB,0.26920E+01_JPRB /)  
KB(:, 5,27,10) = (/ &
 & 0.15494E+01_JPRB,0.36148E+01_JPRB,0.43685E+01_JPRB,0.44626E+01_JPRB,0.29161E+01_JPRB /)  
KB(:, 1,28,10) = (/ &
 & 0.99411E+00_JPRB,0.25422E+01_JPRB,0.29403E+01_JPRB,0.29678E+01_JPRB,0.19736E+01_JPRB /)  
KB(:, 2,28,10) = (/ &
 & 0.10693E+01_JPRB,0.27468E+01_JPRB,0.32278E+01_JPRB,0.32747E+01_JPRB,0.21580E+01_JPRB /)  
KB(:, 3,28,10) = (/ &
 & 0.11727E+01_JPRB,0.29677E+01_JPRB,0.35410E+01_JPRB,0.36136E+01_JPRB,0.23718E+01_JPRB /)  
KB(:, 4,28,10) = (/ &
 & 0.13040E+01_JPRB,0.32092E+01_JPRB,0.38816E+01_JPRB,0.39808E+01_JPRB,0.25959E+01_JPRB /)  
KB(:, 5,28,10) = (/ &
 & 0.14604E+01_JPRB,0.34721E+01_JPRB,0.42472E+01_JPRB,0.43708E+01_JPRB,0.28373E+01_JPRB /)  
KB(:, 1,29,10) = (/ &
 & 0.89294E+00_JPRB,0.24188E+01_JPRB,0.28058E+01_JPRB,0.28515E+01_JPRB,0.18636E+01_JPRB /)  
KB(:, 2,29,10) = (/ &
 & 0.97544E+00_JPRB,0.26259E+01_JPRB,0.31039E+01_JPRB,0.31712E+01_JPRB,0.20699E+01_JPRB /)  
KB(:, 3,29,10) = (/ &
 & 0.10880E+01_JPRB,0.28493E+01_JPRB,0.34305E+01_JPRB,0.35278E+01_JPRB,0.22886E+01_JPRB /)  
KB(:, 4,29,10) = (/ &
 & 0.12277E+01_JPRB,0.30947E+01_JPRB,0.37862E+01_JPRB,0.39124E+01_JPRB,0.25256E+01_JPRB /)  
KB(:, 5,29,10) = (/ &
 & 0.13896E+01_JPRB,0.33676E+01_JPRB,0.41685E+01_JPRB,0.43225E+01_JPRB,0.27864E+01_JPRB /)  
KB(:, 1,30,10) = (/ &
 & 0.81230E+00_JPRB,0.23190E+01_JPRB,0.27059E+01_JPRB,0.27666E+01_JPRB,0.17929E+01_JPRB /)  
KB(:, 2,30,10) = (/ &
 & 0.90285E+00_JPRB,0.25306E+01_JPRB,0.30146E+01_JPRB,0.31051E+01_JPRB,0.20049E+01_JPRB /)  
KB(:, 3,30,10) = (/ &
 & 0.10223E+01_JPRB,0.27572E+01_JPRB,0.33560E+01_JPRB,0.34779E+01_JPRB,0.22359E+01_JPRB /)  
KB(:, 4,30,10) = (/ &
 & 0.11675E+01_JPRB,0.30101E+01_JPRB,0.37284E+01_JPRB,0.38827E+01_JPRB,0.24866E+01_JPRB /)  
KB(:, 5,30,10) = (/ &
 & 0.13337E+01_JPRB,0.32968E+01_JPRB,0.41265E+01_JPRB,0.43099E+01_JPRB,0.27369E+01_JPRB /)  
KB(:, 1,31,10) = (/ &
 & 0.75110E+00_JPRB,0.22419E+01_JPRB,0.26379E+01_JPRB,0.27157E+01_JPRB,0.17433E+01_JPRB /)  
KB(:, 2,31,10) = (/ &
 & 0.84809E+00_JPRB,0.24579E+01_JPRB,0.29592E+01_JPRB,0.30730E+01_JPRB,0.19665E+01_JPRB /)  
KB(:, 3,31,10) = (/ &
 & 0.97252E+00_JPRB,0.26914E+01_JPRB,0.33168E+01_JPRB,0.34645E+01_JPRB,0.22008E+01_JPRB /)  
KB(:, 4,31,10) = (/ &
 & 0.11219E+01_JPRB,0.29550E+01_JPRB,0.37069E+01_JPRB,0.38878E+01_JPRB,0.24456E+01_JPRB /)  
KB(:, 5,31,10) = (/ &
 & 0.12926E+01_JPRB,0.32597E+01_JPRB,0.41224E+01_JPRB,0.43304E+01_JPRB,0.27059E+01_JPRB /)  
KB(:, 1,32,10) = (/ &
 & 0.70499E+00_JPRB,0.21846E+01_JPRB,0.25985E+01_JPRB,0.26966E+01_JPRB,0.17143E+01_JPRB /)  
KB(:, 2,32,10) = (/ &
 & 0.80768E+00_JPRB,0.24067E+01_JPRB,0.29356E+01_JPRB,0.30726E+01_JPRB,0.19337E+01_JPRB /)  
KB(:, 3,32,10) = (/ &
 & 0.93561E+00_JPRB,0.26499E+01_JPRB,0.33107E+01_JPRB,0.34825E+01_JPRB,0.21698E+01_JPRB /)  
KB(:, 4,32,10) = (/ &
 & 0.10894E+01_JPRB,0.29281E+01_JPRB,0.37179E+01_JPRB,0.39220E+01_JPRB,0.24264E+01_JPRB /)  
KB(:, 5,32,10) = (/ &
 & 0.12637E+01_JPRB,0.32525E+01_JPRB,0.41500E+01_JPRB,0.43764E+01_JPRB,0.26992E+01_JPRB /)  
KB(:, 1,33,10) = (/ &
 & 0.67118E+00_JPRB,0.21457E+01_JPRB,0.25854E+01_JPRB,0.27057E+01_JPRB,0.16861E+01_JPRB /)  
KB(:, 2,33,10) = (/ &
 & 0.77795E+00_JPRB,0.23758E+01_JPRB,0.29404E+01_JPRB,0.30997E+01_JPRB,0.19111E+01_JPRB /)  
KB(:, 3,33,10) = (/ &
 & 0.91001E+00_JPRB,0.26325E+01_JPRB,0.33337E+01_JPRB,0.35269E+01_JPRB,0.21600E+01_JPRB /)  
KB(:, 4,33,10) = (/ &
 & 0.10674E+01_JPRB,0.29280E+01_JPRB,0.37566E+01_JPRB,0.39787E+01_JPRB,0.24291E+01_JPRB /)  
KB(:, 5,33,10) = (/ &
 & 0.12452E+01_JPRB,0.32737E+01_JPRB,0.42022E+01_JPRB,0.44428E+01_JPRB,0.27130E+01_JPRB /)  
KB(:, 1,34,10) = (/ &
 & 0.64347E+00_JPRB,0.21163E+01_JPRB,0.25854E+01_JPRB,0.27260E+01_JPRB,0.16632E+01_JPRB /)  
KB(:, 2,34,10) = (/ &
 & 0.75313E+00_JPRB,0.23563E+01_JPRB,0.29579E+01_JPRB,0.31342E+01_JPRB,0.18999E+01_JPRB /)  
KB(:, 3,34,10) = (/ &
 & 0.88833E+00_JPRB,0.26269E+01_JPRB,0.33662E+01_JPRB,0.35749E+01_JPRB,0.21605E+01_JPRB /)  
KB(:, 4,34,10) = (/ &
 & 0.10487E+01_JPRB,0.29401E+01_JPRB,0.38003E+01_JPRB,0.40358E+01_JPRB,0.24405E+01_JPRB /)  
KB(:, 5,34,10) = (/ &
 & 0.12301E+01_JPRB,0.33056E+01_JPRB,0.42553E+01_JPRB,0.45073E+01_JPRB,0.27333E+01_JPRB /)  
KB(:, 1,35,10) = (/ &
 & 0.61333E+00_JPRB,0.20804E+01_JPRB,0.25725E+01_JPRB,0.27255E+01_JPRB,0.16337E+01_JPRB /)  
KB(:, 2,35,10) = (/ &
 & 0.72416E+00_JPRB,0.23301E+01_JPRB,0.29566E+01_JPRB,0.31440E+01_JPRB,0.18805E+01_JPRB /)  
KB(:, 3,35,10) = (/ &
 & 0.85987E+00_JPRB,0.26111E+01_JPRB,0.33740E+01_JPRB,0.35934E+01_JPRB,0.21502E+01_JPRB /)  
KB(:, 4,35,10) = (/ &
 & 0.10212E+01_JPRB,0.29378E+01_JPRB,0.38159E+01_JPRB,0.40603E+01_JPRB,0.24378E+01_JPRB /)  
KB(:, 5,35,10) = (/ &
 & 0.12063E+01_JPRB,0.33167E+01_JPRB,0.42768E+01_JPRB,0.45362E+01_JPRB,0.27369E+01_JPRB /)  
KB(:, 1,36,10) = (/ &
 & 0.57858E+00_JPRB,0.20318E+01_JPRB,0.25343E+01_JPRB,0.26932E+01_JPRB,0.15911E+01_JPRB /)  
KB(:, 2,36,10) = (/ &
 & 0.68823E+00_JPRB,0.22888E+01_JPRB,0.29242E+01_JPRB,0.31171E+01_JPRB,0.18445E+01_JPRB /)  
KB(:, 3,36,10) = (/ &
 & 0.82172E+00_JPRB,0.25765E+01_JPRB,0.33460E+01_JPRB,0.35706E+01_JPRB,0.21205E+01_JPRB /)  
KB(:, 4,36,10) = (/ &
 & 0.98227E+00_JPRB,0.29099E+01_JPRB,0.37920E+01_JPRB,0.40410E+01_JPRB,0.24128E+01_JPRB /)  
KB(:, 5,36,10) = (/ &
 & 0.11693E+01_JPRB,0.32947E+01_JPRB,0.42558E+01_JPRB,0.45198E+01_JPRB,0.27160E+01_JPRB /)  
KB(:, 1,37,10) = (/ &
 & 0.53405E+00_JPRB,0.19558E+01_JPRB,0.24506E+01_JPRB,0.26071E+01_JPRB,0.15218E+01_JPRB /)  
KB(:, 2,37,10) = (/ &
 & 0.63968E+00_JPRB,0.22170E+01_JPRB,0.28388E+01_JPRB,0.30310E+01_JPRB,0.17770E+01_JPRB /)  
KB(:, 3,37,10) = (/ &
 & 0.76779E+00_JPRB,0.25049E+01_JPRB,0.32599E+01_JPRB,0.34842E+01_JPRB,0.20552E+01_JPRB /)  
KB(:, 4,37,10) = (/ &
 & 0.92384E+00_JPRB,0.28358E+01_JPRB,0.37058E+01_JPRB,0.39557E+01_JPRB,0.23490E+01_JPRB /)  
KB(:, 5,37,10) = (/ &
 & 0.11094E+01_JPRB,0.32175E+01_JPRB,0.41691E+01_JPRB,0.44348E+01_JPRB,0.26544E+01_JPRB /)  
KB(:, 1,38,10) = (/ &
 & 0.49328E+00_JPRB,0.18861E+01_JPRB,0.23724E+01_JPRB,0.25236E+01_JPRB,0.14577E+01_JPRB /)  
KB(:, 2,38,10) = (/ &
 & 0.59575E+00_JPRB,0.21506E+01_JPRB,0.27570E+01_JPRB,0.29471E+01_JPRB,0.17138E+01_JPRB /)  
KB(:, 3,38,10) = (/ &
 & 0.71877E+00_JPRB,0.24381E+01_JPRB,0.31760E+01_JPRB,0.33985E+01_JPRB,0.19934E+01_JPRB /)  
KB(:, 4,38,10) = (/ &
 & 0.87044E+00_JPRB,0.27651E+01_JPRB,0.36203E+01_JPRB,0.38701E+01_JPRB,0.22879E+01_JPRB /)  
KB(:, 5,38,10) = (/ &
 & 0.10541E+01_JPRB,0.31424E+01_JPRB,0.40835E+01_JPRB,0.43497E+01_JPRB,0.25942E+01_JPRB /)  
KB(:, 1,39,10) = (/ &
 & 0.45633E+00_JPRB,0.18232E+01_JPRB,0.23004E+01_JPRB,0.24453E+01_JPRB,0.13998E+01_JPRB /)  
KB(:, 2,39,10) = (/ &
 & 0.55664E+00_JPRB,0.20902E+01_JPRB,0.26810E+01_JPRB,0.28682E+01_JPRB,0.16563E+01_JPRB /)  
KB(:, 3,39,10) = (/ &
 & 0.67511E+00_JPRB,0.23775E+01_JPRB,0.30973E+01_JPRB,0.33174E+01_JPRB,0.19363E+01_JPRB /)  
KB(:, 4,39,10) = (/ &
 & 0.82312E+00_JPRB,0.27002E+01_JPRB,0.35399E+01_JPRB,0.37881E+01_JPRB,0.22310E+01_JPRB /)  
KB(:, 5,39,10) = (/ &
 & 0.10047E+01_JPRB,0.30719E+01_JPRB,0.40016E+01_JPRB,0.42681E+01_JPRB,0.25376E+01_JPRB /)  
KB(:, 1,40,10) = (/ &
 & 0.41369E+00_JPRB,0.17392E+01_JPRB,0.21979E+01_JPRB,0.23287E+01_JPRB,0.13226E+01_JPRB /)  
KB(:, 2,40,10) = (/ &
 & 0.51051E+00_JPRB,0.20064E+01_JPRB,0.25693E+01_JPRB,0.27492E+01_JPRB,0.15756E+01_JPRB /)  
KB(:, 3,40,10) = (/ &
 & 0.62337E+00_JPRB,0.22909E+01_JPRB,0.29791E+01_JPRB,0.31928E+01_JPRB,0.18532E+01_JPRB /)  
KB(:, 4,40,10) = (/ &
 & 0.76463E+00_JPRB,0.26052E+01_JPRB,0.34168E+01_JPRB,0.36603E+01_JPRB,0.21464E+01_JPRB /)  
KB(:, 5,40,10) = (/ &
 & 0.94032E+00_JPRB,0.29656E+01_JPRB,0.38751E+01_JPRB,0.41396E+01_JPRB,0.24517E+01_JPRB /)  
KB(:, 1,41,10) = (/ &
 & 0.37354E+00_JPRB,0.16561E+01_JPRB,0.20963E+01_JPRB,0.22111E+01_JPRB,0.12469E+01_JPRB /)  
KB(:, 2,41,10) = (/ &
 & 0.46665E+00_JPRB,0.19239E+01_JPRB,0.24587E+01_JPRB,0.26289E+01_JPRB,0.14959E+01_JPRB /)  
KB(:, 3,41,10) = (/ &
 & 0.57545E+00_JPRB,0.22047E+01_JPRB,0.28597E+01_JPRB,0.30659E+01_JPRB,0.17694E+01_JPRB /)  
KB(:, 4,41,10) = (/ &
 & 0.70985E+00_JPRB,0.25106E+01_JPRB,0.32912E+01_JPRB,0.35291E+01_JPRB,0.20606E+01_JPRB /)  
KB(:, 5,41,10) = (/ &
 & 0.87840E+00_JPRB,0.28591E+01_JPRB,0.37457E+01_JPRB,0.40073E+01_JPRB,0.23640E+01_JPRB /)  
KB(:, 1,42,10) = (/ &
 & 0.33676E+00_JPRB,0.15772E+01_JPRB,0.19999E+01_JPRB,0.20973E+01_JPRB,0.11755E+01_JPRB /)  
KB(:, 2,42,10) = (/ &
 & 0.42603E+00_JPRB,0.18429E+01_JPRB,0.23518E+01_JPRB,0.25105E+01_JPRB,0.14196E+01_JPRB /)  
KB(:, 3,42,10) = (/ &
 & 0.53169E+00_JPRB,0.21211E+01_JPRB,0.27440E+01_JPRB,0.29424E+01_JPRB,0.16886E+01_JPRB /)  
KB(:, 4,42,10) = (/ &
 & 0.65992E+00_JPRB,0.24200E+01_JPRB,0.31691E+01_JPRB,0.34004E+01_JPRB,0.19770E+01_JPRB /)  
KB(:, 5,42,10) = (/ &
 & 0.82123E+00_JPRB,0.27572E+01_JPRB,0.36189E+01_JPRB,0.38764E+01_JPRB,0.22780E+01_JPRB /)  
KB(:, 1,43,10) = (/ &
 & 0.29880E+00_JPRB,0.14855E+01_JPRB,0.18883E+01_JPRB,0.19649E+01_JPRB,0.10947E+01_JPRB /)  
KB(:, 2,43,10) = (/ &
 & 0.38323E+00_JPRB,0.17495E+01_JPRB,0.22289E+01_JPRB,0.23704E+01_JPRB,0.13324E+01_JPRB /)  
KB(:, 3,43,10) = (/ &
 & 0.48519E+00_JPRB,0.20243E+01_JPRB,0.26093E+01_JPRB,0.27970E+01_JPRB,0.15948E+01_JPRB /)  
KB(:, 4,43,10) = (/ &
 & 0.60690E+00_JPRB,0.23164E+01_JPRB,0.30260E+01_JPRB,0.32477E+01_JPRB,0.18788E+01_JPRB /)  
KB(:, 5,43,10) = (/ &
 & 0.75876E+00_JPRB,0.26404E+01_JPRB,0.34692E+01_JPRB,0.37199E+01_JPRB,0.21767E+01_JPRB /)  
KB(:, 1,44,10) = (/ &
 & 0.26234E+00_JPRB,0.13896E+01_JPRB,0.17735E+01_JPRB,0.18283E+01_JPRB,0.10125E+01_JPRB /)  
KB(:, 2,44,10) = (/ &
 & 0.34133E+00_JPRB,0.16516E+01_JPRB,0.21029E+01_JPRB,0.22231E+01_JPRB,0.12426E+01_JPRB /)  
KB(:, 3,44,10) = (/ &
 & 0.43896E+00_JPRB,0.19234E+01_JPRB,0.24698E+01_JPRB,0.26446E+01_JPRB,0.14975E+01_JPRB /)  
KB(:, 4,44,10) = (/ &
 & 0.55556E+00_JPRB,0.22104E+01_JPRB,0.28764E+01_JPRB,0.30872E+01_JPRB,0.17758E+01_JPRB /)  
KB(:, 5,44,10) = (/ &
 & 0.69720E+00_JPRB,0.25211E+01_JPRB,0.33108E+01_JPRB,0.35530E+01_JPRB,0.20699E+01_JPRB /)  
KB(:, 1,45,10) = (/ &
 & 0.22932E+00_JPRB,0.12967E+01_JPRB,0.16617E+01_JPRB,0.16976E+01_JPRB,0.93402E+00_JPRB /)  
KB(:, 2,45,10) = (/ &
 & 0.30290E+00_JPRB,0.15560E+01_JPRB,0.19824E+01_JPRB,0.20804E+01_JPRB,0.11566E+01_JPRB /)  
KB(:, 3,45,10) = (/ &
 & 0.39581E+00_JPRB,0.18251E+01_JPRB,0.23356E+01_JPRB,0.24949E+01_JPRB,0.14039E+01_JPRB /)  
KB(:, 4,45,10) = (/ &
 & 0.50777E+00_JPRB,0.21068E+01_JPRB,0.27305E+01_JPRB,0.29300E+01_JPRB,0.16755E+01_JPRB /)  
KB(:, 5,45,10) = (/ &
 & 0.64060E+00_JPRB,0.24073E+01_JPRB,0.31565E+01_JPRB,0.33892E+01_JPRB,0.19653E+01_JPRB /)  
KB(:, 1,46,10) = (/ &
 & 0.19825E+00_JPRB,0.12020E+01_JPRB,0.15457E+01_JPRB,0.15662E+01_JPRB,0.85464E+00_JPRB /)  
KB(:, 2,46,10) = (/ &
 & 0.26591E+00_JPRB,0.14563E+01_JPRB,0.18595E+01_JPRB,0.19337E+01_JPRB,0.10694E+01_JPRB /)  
KB(:, 3,46,10) = (/ &
 & 0.35343E+00_JPRB,0.17232E+01_JPRB,0.22000E+01_JPRB,0.23390E+01_JPRB,0.13083E+01_JPRB /)  
KB(:, 4,46,10) = (/ &
 & 0.46053E+00_JPRB,0.19999E+01_JPRB,0.25801E+01_JPRB,0.27669E+01_JPRB,0.15716E+01_JPRB /)  
KB(:, 5,46,10) = (/ &
 & 0.58556E+00_JPRB,0.22922E+01_JPRB,0.29962E+01_JPRB,0.32174E+01_JPRB,0.18560E+01_JPRB /)  
KB(:, 1,47,10) = (/ &
 & 0.16836E+00_JPRB,0.11008E+01_JPRB,0.14194E+01_JPRB,0.14270E+01_JPRB,0.77061E+00_JPRB /)  
KB(:, 2,47,10) = (/ &
 & 0.22922E+00_JPRB,0.13473E+01_JPRB,0.17277E+01_JPRB,0.17767E+01_JPRB,0.97668E+00_JPRB /)  
KB(:, 3,47,10) = (/ &
 & 0.31004E+00_JPRB,0.16106E+01_JPRB,0.20551E+01_JPRB,0.21688E+01_JPRB,0.12060E+01_JPRB /)  
KB(:, 4,47,10) = (/ &
 & 0.41110E+00_JPRB,0.18840E+01_JPRB,0.24189E+01_JPRB,0.25893E+01_JPRB,0.14598E+01_JPRB /)  
KB(:, 5,47,10) = (/ &
 & 0.52932E+00_JPRB,0.21690E+01_JPRB,0.28216E+01_JPRB,0.30298E+01_JPRB,0.17368E+01_JPRB /)  
KB(:, 1,48,10) = (/ &
 & 0.14220E+00_JPRB,0.10041E+01_JPRB,0.12957E+01_JPRB,0.12963E+01_JPRB,0.69114E+00_JPRB /)  
KB(:, 2,48,10) = (/ &
 & 0.19626E+00_JPRB,0.12419E+01_JPRB,0.15985E+01_JPRB,0.16273E+01_JPRB,0.88794E+00_JPRB /)  
KB(:, 3,48,10) = (/ &
 & 0.27002E+00_JPRB,0.15006E+01_JPRB,0.19169E+01_JPRB,0.20039E+01_JPRB,0.11083E+01_JPRB /)  
KB(:, 4,48,10) = (/ &
 & 0.36488E+00_JPRB,0.17700E+01_JPRB,0.22644E+01_JPRB,0.24151E+01_JPRB,0.13523E+01_JPRB /)  
KB(:, 5,48,10) = (/ &
 & 0.47701E+00_JPRB,0.20494E+01_JPRB,0.26525E+01_JPRB,0.28466E+01_JPRB,0.16205E+01_JPRB /)  
KB(:, 1,49,10) = (/ &
 & 0.11950E+00_JPRB,0.91234E+00_JPRB,0.11755E+01_JPRB,0.11741E+01_JPRB,0.61611E+00_JPRB /)  
KB(:, 2,49,10) = (/ &
 & 0.16698E+00_JPRB,0.11406E+01_JPRB,0.14723E+01_JPRB,0.14860E+01_JPRB,0.80337E+00_JPRB /)  
KB(:, 3,49,10) = (/ &
 & 0.23352E+00_JPRB,0.13921E+01_JPRB,0.17842E+01_JPRB,0.18450E+01_JPRB,0.10147E+01_JPRB /)  
KB(:, 4,49,10) = (/ &
 & 0.32154E+00_JPRB,0.16580E+01_JPRB,0.21177E+01_JPRB,0.22439E+01_JPRB,0.12490E+01_JPRB /)  
KB(:, 5,49,10) = (/ &
 & 0.42774E+00_JPRB,0.19330E+01_JPRB,0.24891E+01_JPRB,0.26683E+01_JPRB,0.15078E+01_JPRB /)  
KB(:, 1,50,10) = (/ &
 & 0.10087E+00_JPRB,0.83065E+00_JPRB,0.10669E+01_JPRB,0.10674E+01_JPRB,0.54936E+00_JPRB /)  
KB(:, 2,50,10) = (/ &
 & 0.14237E+00_JPRB,0.10490E+01_JPRB,0.13561E+01_JPRB,0.13605E+01_JPRB,0.72778E+00_JPRB /)  
KB(:, 3,50,10) = (/ &
 & 0.20234E+00_JPRB,0.12926E+01_JPRB,0.16630E+01_JPRB,0.17021E+01_JPRB,0.93055E+00_JPRB /)  
KB(:, 4,50,10) = (/ &
 & 0.28362E+00_JPRB,0.15546E+01_JPRB,0.19861E+01_JPRB,0.20879E+01_JPRB,0.11563E+01_JPRB /)  
KB(:, 5,50,10) = (/ &
 & 0.38392E+00_JPRB,0.18265E+01_JPRB,0.23423E+01_JPRB,0.25044E+01_JPRB,0.14058E+01_JPRB /)  
KB(:, 1,51,10) = (/ &
 & 0.85305E-01_JPRB,0.75516E+00_JPRB,0.96600E+00_JPRB,0.96989E+00_JPRB,0.48900E+00_JPRB /)  
KB(:, 2,51,10) = (/ &
 & 0.12119E+00_JPRB,0.96396E+00_JPRB,0.12458E+01_JPRB,0.12458E+01_JPRB,0.65803E+00_JPRB /)  
KB(:, 3,51,10) = (/ &
 & 0.17492E+00_JPRB,0.11993E+01_JPRB,0.15474E+01_JPRB,0.15706E+01_JPRB,0.85222E+00_JPRB /)  
KB(:, 4,51,10) = (/ &
 & 0.24953E+00_JPRB,0.14559E+01_JPRB,0.18635E+01_JPRB,0.19410E+01_JPRB,0.10697E+01_JPRB /)  
KB(:, 5,51,10) = (/ &
 & 0.34420E+00_JPRB,0.17250E+01_JPRB,0.22062E+01_JPRB,0.23483E+01_JPRB,0.13105E+01_JPRB /)  
KB(:, 1,52,10) = (/ &
 & 0.72122E-01_JPRB,0.68398E+00_JPRB,0.87088E+00_JPRB,0.87737E+00_JPRB,0.43154E+00_JPRB /)  
KB(:, 2,52,10) = (/ &
 & 0.10277E+00_JPRB,0.88315E+00_JPRB,0.11388E+01_JPRB,0.11383E+01_JPRB,0.59136E+00_JPRB /)  
KB(:, 3,52,10) = (/ &
 & 0.15043E+00_JPRB,0.11094E+01_JPRB,0.14345E+01_JPRB,0.14453E+01_JPRB,0.77736E+00_JPRB /)  
KB(:, 4,52,10) = (/ &
 & 0.21816E+00_JPRB,0.13587E+01_JPRB,0.17451E+01_JPRB,0.17993E+01_JPRB,0.98663E+00_JPRB /)  
KB(:, 5,52,10) = (/ &
 & 0.30639E+00_JPRB,0.16242E+01_JPRB,0.20759E+01_JPRB,0.21951E+01_JPRB,0.12188E+01_JPRB /)  
KB(:, 1,53,10) = (/ &
 & 0.60992E-01_JPRB,0.61681E+00_JPRB,0.78096E+00_JPRB,0.78801E+00_JPRB,0.37771E+00_JPRB /)  
KB(:, 2,53,10) = (/ &
 & 0.86893E-01_JPRB,0.80591E+00_JPRB,0.10354E+01_JPRB,0.10374E+01_JPRB,0.52892E+00_JPRB /)  
KB(:, 3,53,10) = (/ &
 & 0.12844E+00_JPRB,0.10223E+01_JPRB,0.13228E+01_JPRB,0.13263E+01_JPRB,0.70557E+00_JPRB /)  
KB(:, 4,53,10) = (/ &
 & 0.18962E+00_JPRB,0.12639E+01_JPRB,0.16288E+01_JPRB,0.16633E+01_JPRB,0.90648E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART27',1,ZHOOK_HANDLE)
END SUBROUTINE PART27


SUBROUTINE PART28

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART28',0,ZHOOK_HANDLE)


KB(:, 5,53,10) = (/ &
 & 0.27104E+00_JPRB,0.15253E+01_JPRB,0.19505E+01_JPRB,0.20457E+01_JPRB,0.11304E+01_JPRB /)  
KB(:, 1,54,10) = (/ &
 & 0.52146E-01_JPRB,0.55862E+00_JPRB,0.70341E+00_JPRB,0.70953E+00_JPRB,0.33141E+00_JPRB /)  
KB(:, 2,54,10) = (/ &
 & 0.74252E-01_JPRB,0.73817E+00_JPRB,0.94468E+00_JPRB,0.94968E+00_JPRB,0.47420E+00_JPRB /)  
KB(:, 3,54,10) = (/ &
 & 0.11046E+00_JPRB,0.94583E+00_JPRB,0.12229E+01_JPRB,0.12232E+01_JPRB,0.64224E+00_JPRB /)  
KB(:, 4,54,10) = (/ &
 & 0.16584E+00_JPRB,0.11796E+01_JPRB,0.15239E+01_JPRB,0.15447E+01_JPRB,0.83594E+00_JPRB /)  
KB(:, 5,54,10) = (/ &
 & 0.24084E+00_JPRB,0.14356E+01_JPRB,0.18395E+01_JPRB,0.19125E+01_JPRB,0.10521E+01_JPRB /)  
KB(:, 1,55,10) = (/ &
 & 0.44769E-01_JPRB,0.50580E+00_JPRB,0.63367E+00_JPRB,0.63830E+00_JPRB,0.29171E+00_JPRB /)  
KB(:, 2,55,10) = (/ &
 & 0.63801E-01_JPRB,0.67695E+00_JPRB,0.86251E+00_JPRB,0.86950E+00_JPRB,0.42385E+00_JPRB /)  
KB(:, 3,55,10) = (/ &
 & 0.95281E-01_JPRB,0.87561E+00_JPRB,0.11296E+01_JPRB,0.11298E+01_JPRB,0.58465E+00_JPRB /)  
KB(:, 4,55,10) = (/ &
 & 0.14509E+00_JPRB,0.11012E+01_JPRB,0.14250E+01_JPRB,0.14355E+01_JPRB,0.77056E+00_JPRB /)  
KB(:, 5,55,10) = (/ &
 & 0.21402E+00_JPRB,0.13506E+01_JPRB,0.17360E+01_JPRB,0.17888E+01_JPRB,0.97966E+00_JPRB /)  
KB(:, 1,56,10) = (/ &
 & 0.38303E-01_JPRB,0.45495E+00_JPRB,0.56826E+00_JPRB,0.57046E+00_JPRB,0.25591E+00_JPRB /)  
KB(:, 2,56,10) = (/ &
 & 0.54762E-01_JPRB,0.61846E+00_JPRB,0.78411E+00_JPRB,0.79150E+00_JPRB,0.37700E+00_JPRB /)  
KB(:, 3,56,10) = (/ &
 & 0.82009E-01_JPRB,0.80830E+00_JPRB,0.10394E+01_JPRB,0.10417E+01_JPRB,0.52950E+00_JPRB /)  
KB(:, 4,56,10) = (/ &
 & 0.12621E+00_JPRB,0.10253E+01_JPRB,0.13275E+01_JPRB,0.13316E+01_JPRB,0.70721E+00_JPRB /)  
KB(:, 5,56,10) = (/ &
 & 0.18937E+00_JPRB,0.12680E+01_JPRB,0.16344E+01_JPRB,0.16700E+01_JPRB,0.90979E+00_JPRB /)  
KB(:, 1,57,10) = (/ &
 & 0.32632E-01_JPRB,0.40611E+00_JPRB,0.50731E+00_JPRB,0.50659E+00_JPRB,0.22496E+00_JPRB /)  
KB(:, 2,57,10) = (/ &
 & 0.47019E-01_JPRB,0.56304E+00_JPRB,0.71002E+00_JPRB,0.71651E+00_JPRB,0.33305E+00_JPRB /)  
KB(:, 3,57,10) = (/ &
 & 0.70456E-01_JPRB,0.74361E+00_JPRB,0.95266E+00_JPRB,0.95775E+00_JPRB,0.47635E+00_JPRB /)  
KB(:, 4,57,10) = (/ &
 & 0.10937E+00_JPRB,0.95229E+00_JPRB,0.12322E+01_JPRB,0.12329E+01_JPRB,0.64711E+00_JPRB /)  
KB(:, 5,57,10) = (/ &
 & 0.16675E+00_JPRB,0.11875E+01_JPRB,0.15342E+01_JPRB,0.15565E+01_JPRB,0.84216E+00_JPRB /)  
KB(:, 1,58,10) = (/ &
 & 0.27856E-01_JPRB,0.36188E+00_JPRB,0.45369E+00_JPRB,0.45016E+00_JPRB,0.19835E+00_JPRB /)  
KB(:, 2,58,10) = (/ &
 & 0.40581E-01_JPRB,0.51273E+00_JPRB,0.64353E+00_JPRB,0.64865E+00_JPRB,0.29546E+00_JPRB /)  
KB(:, 3,58,10) = (/ &
 & 0.60914E-01_JPRB,0.68524E+00_JPRB,0.87436E+00_JPRB,0.88146E+00_JPRB,0.42903E+00_JPRB /)  
KB(:, 4,58,10) = (/ &
 & 0.95154E-01_JPRB,0.88582E+00_JPRB,0.11439E+01_JPRB,0.11441E+01_JPRB,0.59161E+00_JPRB /)  
KB(:, 5,58,10) = (/ &
 & 0.14715E+00_JPRB,0.11133E+01_JPRB,0.14407E+01_JPRB,0.14528E+01_JPRB,0.77938E+00_JPRB /)  
KB(:, 1,59,10) = (/ &
 & 0.25371E-01_JPRB,0.34461E+00_JPRB,0.43295E+00_JPRB,0.42860E+00_JPRB,0.18805E+00_JPRB /)  
KB(:, 2,59,10) = (/ &
 & 0.37551E-01_JPRB,0.49296E+00_JPRB,0.61778E+00_JPRB,0.62208E+00_JPRB,0.28092E+00_JPRB /)  
KB(:, 3,59,10) = (/ &
 & 0.57031E-01_JPRB,0.66239E+00_JPRB,0.84380E+00_JPRB,0.85137E+00_JPRB,0.40984E+00_JPRB /)  
KB(:, 4,59,10) = (/ &
 & 0.89730E-01_JPRB,0.85967E+00_JPRB,0.11090E+01_JPRB,0.11096E+01_JPRB,0.56882E+00_JPRB /)  
KB(:, 5,59,10) = (/ &
 & 0.13959E+00_JPRB,0.10839E+01_JPRB,0.14035E+01_JPRB,0.14125E+01_JPRB,0.75487E+00_JPRB /)  
KB(:, 1,13,11) = (/ &
 & 0.13518E+02_JPRB,0.19426E+02_JPRB,0.21368E+02_JPRB,0.20607E+02_JPRB,0.15967E+02_JPRB /)  
KB(:, 2,13,11) = (/ &
 & 0.13249E+02_JPRB,0.19278E+02_JPRB,0.21345E+02_JPRB,0.20725E+02_JPRB,0.16218E+02_JPRB /)  
KB(:, 3,13,11) = (/ &
 & 0.12991E+02_JPRB,0.19106E+02_JPRB,0.21344E+02_JPRB,0.20838E+02_JPRB,0.16493E+02_JPRB /)  
KB(:, 4,13,11) = (/ &
 & 0.12783E+02_JPRB,0.18953E+02_JPRB,0.21337E+02_JPRB,0.20959E+02_JPRB,0.16769E+02_JPRB /)  
KB(:, 5,13,11) = (/ &
 & 0.12735E+02_JPRB,0.18820E+02_JPRB,0.21328E+02_JPRB,0.21104E+02_JPRB,0.16982E+02_JPRB /)  
KB(:, 1,14,11) = (/ &
 & 0.11504E+02_JPRB,0.17534E+02_JPRB,0.19457E+02_JPRB,0.19131E+02_JPRB,0.14625E+02_JPRB /)  
KB(:, 2,14,11) = (/ &
 & 0.11281E+02_JPRB,0.17396E+02_JPRB,0.19491E+02_JPRB,0.19271E+02_JPRB,0.14939E+02_JPRB /)  
KB(:, 3,14,11) = (/ &
 & 0.11112E+02_JPRB,0.17290E+02_JPRB,0.19527E+02_JPRB,0.19415E+02_JPRB,0.15255E+02_JPRB /)  
KB(:, 4,14,11) = (/ &
 & 0.11115E+02_JPRB,0.17213E+02_JPRB,0.19560E+02_JPRB,0.19580E+02_JPRB,0.15504E+02_JPRB /)  
KB(:, 5,14,11) = (/ &
 & 0.11342E+02_JPRB,0.17139E+02_JPRB,0.19615E+02_JPRB,0.19759E+02_JPRB,0.15706E+02_JPRB /)  
KB(:, 1,15,11) = (/ &
 & 0.98170E+01_JPRB,0.15599E+02_JPRB,0.17627E+02_JPRB,0.17666E+02_JPRB,0.13354E+02_JPRB /)  
KB(:, 2,15,11) = (/ &
 & 0.96747E+01_JPRB,0.15533E+02_JPRB,0.17695E+02_JPRB,0.17842E+02_JPRB,0.13687E+02_JPRB /)  
KB(:, 3,15,11) = (/ &
 & 0.96984E+01_JPRB,0.15502E+02_JPRB,0.17755E+02_JPRB,0.18036E+02_JPRB,0.14004E+02_JPRB /)  
KB(:, 4,15,11) = (/ &
 & 0.99522E+01_JPRB,0.15480E+02_JPRB,0.17829E+02_JPRB,0.18235E+02_JPRB,0.14263E+02_JPRB /)  
KB(:, 5,15,11) = (/ &
 & 0.10344E+02_JPRB,0.15525E+02_JPRB,0.17929E+02_JPRB,0.18418E+02_JPRB,0.14475E+02_JPRB /)  
KB(:, 1,16,11) = (/ &
 & 0.84332E+01_JPRB,0.13806E+02_JPRB,0.15926E+02_JPRB,0.16215E+02_JPRB,0.12224E+02_JPRB /)  
KB(:, 2,16,11) = (/ &
 & 0.84583E+01_JPRB,0.13805E+02_JPRB,0.16021E+02_JPRB,0.16437E+02_JPRB,0.12556E+02_JPRB /)  
KB(:, 3,16,11) = (/ &
 & 0.87066E+01_JPRB,0.13823E+02_JPRB,0.16108E+02_JPRB,0.16660E+02_JPRB,0.12834E+02_JPRB /)  
KB(:, 4,16,11) = (/ &
 & 0.90827E+01_JPRB,0.13924E+02_JPRB,0.16226E+02_JPRB,0.16883E+02_JPRB,0.13078E+02_JPRB /)  
KB(:, 5,16,11) = (/ &
 & 0.95263E+01_JPRB,0.14156E+02_JPRB,0.16382E+02_JPRB,0.17079E+02_JPRB,0.13334E+02_JPRB /)  
KB(:, 1,17,11) = (/ &
 & 0.73068E+01_JPRB,0.12252E+02_JPRB,0.14341E+02_JPRB,0.14810E+02_JPRB,0.11129E+02_JPRB /)  
KB(:, 2,17,11) = (/ &
 & 0.75295E+01_JPRB,0.12291E+02_JPRB,0.14463E+02_JPRB,0.15052E+02_JPRB,0.11439E+02_JPRB /)  
KB(:, 3,17,11) = (/ &
 & 0.78853E+01_JPRB,0.12405E+02_JPRB,0.14606E+02_JPRB,0.15309E+02_JPRB,0.11729E+02_JPRB /)  
KB(:, 4,17,11) = (/ &
 & 0.83040E+01_JPRB,0.12643E+02_JPRB,0.14776E+02_JPRB,0.15548E+02_JPRB,0.12006E+02_JPRB /)  
KB(:, 5,17,11) = (/ &
 & 0.87123E+01_JPRB,0.13039E+02_JPRB,0.14982E+02_JPRB,0.15762E+02_JPRB,0.12286E+02_JPRB /)  
KB(:, 1,18,11) = (/ &
 & 0.64287E+01_JPRB,0.10933E+02_JPRB,0.12879E+02_JPRB,0.13451E+02_JPRB,0.10053E+02_JPRB /)  
KB(:, 2,18,11) = (/ &
 & 0.67446E+01_JPRB,0.11039E+02_JPRB,0.13041E+02_JPRB,0.13740E+02_JPRB,0.10377E+02_JPRB /)  
KB(:, 3,18,11) = (/ &
 & 0.71271E+01_JPRB,0.11266E+02_JPRB,0.13222E+02_JPRB,0.14018E+02_JPRB,0.10699E+02_JPRB /)  
KB(:, 4,18,11) = (/ &
 & 0.75067E+01_JPRB,0.11650E+02_JPRB,0.13455E+02_JPRB,0.14263E+02_JPRB,0.11011E+02_JPRB /)  
KB(:, 5,18,11) = (/ &
 & 0.78797E+01_JPRB,0.12144E+02_JPRB,0.13766E+02_JPRB,0.14517E+02_JPRB,0.11323E+02_JPRB /)  
KB(:, 1,19,11) = (/ &
 & 0.57165E+01_JPRB,0.98198E+01_JPRB,0.11563E+02_JPRB,0.12210E+02_JPRB,0.90287E+01_JPRB /)  
KB(:, 2,19,11) = (/ &
 & 0.60504E+01_JPRB,0.10030E+02_JPRB,0.11759E+02_JPRB,0.12511E+02_JPRB,0.93771E+01_JPRB /)  
KB(:, 3,19,11) = (/ &
 & 0.63872E+01_JPRB,0.10390E+02_JPRB,0.12004E+02_JPRB,0.12787E+02_JPRB,0.97382E+01_JPRB /)  
KB(:, 4,19,11) = (/ &
 & 0.67262E+01_JPRB,0.10858E+02_JPRB,0.12325E+02_JPRB,0.13071E+02_JPRB,0.10100E+02_JPRB /)  
KB(:, 5,19,11) = (/ &
 & 0.70630E+01_JPRB,0.11396E+02_JPRB,0.12720E+02_JPRB,0.13371E+02_JPRB,0.10433E+02_JPRB /)  
KB(:, 1,20,11) = (/ &
 & 0.51077E+01_JPRB,0.88680E+01_JPRB,0.10415E+02_JPRB,0.11053E+02_JPRB,0.80963E+01_JPRB /)  
KB(:, 2,20,11) = (/ &
 & 0.54017E+01_JPRB,0.92107E+01_JPRB,0.10662E+02_JPRB,0.11361E+02_JPRB,0.84758E+01_JPRB /)  
KB(:, 3,20,11) = (/ &
 & 0.57015E+01_JPRB,0.96698E+01_JPRB,0.10982E+02_JPRB,0.11668E+02_JPRB,0.88481E+01_JPRB /)  
KB(:, 4,20,11) = (/ &
 & 0.60041E+01_JPRB,0.10196E+02_JPRB,0.11384E+02_JPRB,0.12000E+02_JPRB,0.92376E+01_JPRB /)  
KB(:, 5,20,11) = (/ &
 & 0.63106E+01_JPRB,0.10732E+02_JPRB,0.11884E+02_JPRB,0.12349E+02_JPRB,0.96255E+01_JPRB /)  
KB(:, 1,21,11) = (/ &
 & 0.45414E+01_JPRB,0.80841E+01_JPRB,0.94333E+01_JPRB,0.10001E+02_JPRB,0.72987E+01_JPRB /)  
KB(:, 2,21,11) = (/ &
 & 0.48060E+01_JPRB,0.85169E+01_JPRB,0.97399E+01_JPRB,0.10324E+02_JPRB,0.76799E+01_JPRB /)  
KB(:, 3,21,11) = (/ &
 & 0.50754E+01_JPRB,0.90311E+01_JPRB,0.10134E+02_JPRB,0.10673E+02_JPRB,0.80692E+01_JPRB /)  
KB(:, 4,21,11) = (/ &
 & 0.53489E+01_JPRB,0.95660E+01_JPRB,0.10626E+02_JPRB,0.11046E+02_JPRB,0.84671E+01_JPRB /)  
KB(:, 5,21,11) = (/ &
 & 0.56226E+01_JPRB,0.10100E+02_JPRB,0.11188E+02_JPRB,0.11467E+02_JPRB,0.88878E+01_JPRB /)  
KB(:, 1,22,11) = (/ &
 & 0.40512E+01_JPRB,0.74537E+01_JPRB,0.86113E+01_JPRB,0.90760E+01_JPRB,0.66406E+01_JPRB /)  
KB(:, 2,22,11) = (/ &
 & 0.42861E+01_JPRB,0.79455E+01_JPRB,0.89988E+01_JPRB,0.94326E+01_JPRB,0.70298E+01_JPRB /)  
KB(:, 3,22,11) = (/ &
 & 0.45284E+01_JPRB,0.84723E+01_JPRB,0.94806E+01_JPRB,0.98282E+01_JPRB,0.74365E+01_JPRB /)  
KB(:, 4,22,11) = (/ &
 & 0.47765E+01_JPRB,0.90022E+01_JPRB,0.10036E+02_JPRB,0.10267E+02_JPRB,0.78530E+01_JPRB /)  
KB(:, 5,22,11) = (/ &
 & 0.50273E+01_JPRB,0.95375E+01_JPRB,0.10644E+02_JPRB,0.10762E+02_JPRB,0.82925E+01_JPRB /)  
KB(:, 1,23,11) = (/ &
 & 0.36272E+01_JPRB,0.69345E+01_JPRB,0.79292E+01_JPRB,0.82821E+01_JPRB,0.60862E+01_JPRB /)  
KB(:, 2,23,11) = (/ &
 & 0.38324E+01_JPRB,0.74412E+01_JPRB,0.84058E+01_JPRB,0.86779E+01_JPRB,0.64814E+01_JPRB /)  
KB(:, 3,23,11) = (/ &
 & 0.40496E+01_JPRB,0.79556E+01_JPRB,0.89497E+01_JPRB,0.91277E+01_JPRB,0.69031E+01_JPRB /)  
KB(:, 4,23,11) = (/ &
 & 0.42736E+01_JPRB,0.84881E+01_JPRB,0.95512E+01_JPRB,0.96353E+01_JPRB,0.73423E+01_JPRB /)  
KB(:, 5,23,11) = (/ &
 & 0.45008E+01_JPRB,0.90231E+01_JPRB,0.10199E+02_JPRB,0.10196E+02_JPRB,0.78107E+01_JPRB /)  
KB(:, 1,24,11) = (/ &
 & 0.32617E+01_JPRB,0.64927E+01_JPRB,0.73814E+01_JPRB,0.76204E+01_JPRB,0.56351E+01_JPRB /)  
KB(:, 2,24,11) = (/ &
 & 0.34455E+01_JPRB,0.69864E+01_JPRB,0.79146E+01_JPRB,0.80668E+01_JPRB,0.60482E+01_JPRB /)  
KB(:, 3,24,11) = (/ &
 & 0.36375E+01_JPRB,0.74982E+01_JPRB,0.85124E+01_JPRB,0.85688E+01_JPRB,0.64793E+01_JPRB /)  
KB(:, 4,24,11) = (/ &
 & 0.38361E+01_JPRB,0.80253E+01_JPRB,0.91530E+01_JPRB,0.91384E+01_JPRB,0.69488E+01_JPRB /)  
KB(:, 5,24,11) = (/ &
 & 0.40434E+01_JPRB,0.85770E+01_JPRB,0.98249E+01_JPRB,0.97701E+01_JPRB,0.74392E+01_JPRB /)  
KB(:, 1,25,11) = (/ &
 & 0.29504E+01_JPRB,0.60996E+01_JPRB,0.69378E+01_JPRB,0.70933E+01_JPRB,0.52696E+01_JPRB /)  
KB(:, 2,25,11) = (/ &
 & 0.31134E+01_JPRB,0.65859E+01_JPRB,0.75193E+01_JPRB,0.75874E+01_JPRB,0.56908E+01_JPRB /)  
KB(:, 3,25,11) = (/ &
 & 0.32850E+01_JPRB,0.70991E+01_JPRB,0.81583E+01_JPRB,0.81455E+01_JPRB,0.61504E+01_JPRB /)  
KB(:, 4,25,11) = (/ &
 & 0.34639E+01_JPRB,0.76357E+01_JPRB,0.88289E+01_JPRB,0.87766E+01_JPRB,0.66391E+01_JPRB /)  
KB(:, 5,25,11) = (/ &
 & 0.36575E+01_JPRB,0.82031E+01_JPRB,0.95335E+01_JPRB,0.94728E+01_JPRB,0.71181E+01_JPRB /)  
KB(:, 1,26,11) = (/ &
 & 0.26785E+01_JPRB,0.57592E+01_JPRB,0.65944E+01_JPRB,0.66793E+01_JPRB,0.49659E+01_JPRB /)  
KB(:, 2,26,11) = (/ &
 & 0.28303E+01_JPRB,0.62512E+01_JPRB,0.72180E+01_JPRB,0.72292E+01_JPRB,0.54158E+01_JPRB /)  
KB(:, 3,26,11) = (/ &
 & 0.29845E+01_JPRB,0.67700E+01_JPRB,0.78853E+01_JPRB,0.78517E+01_JPRB,0.58929E+01_JPRB /)  
KB(:, 4,26,11) = (/ &
 & 0.31498E+01_JPRB,0.73218E+01_JPRB,0.85892E+01_JPRB,0.85405E+01_JPRB,0.63779E+01_JPRB /)  
KB(:, 5,26,11) = (/ &
 & 0.33365E+01_JPRB,0.79095E+01_JPRB,0.93260E+01_JPRB,0.92876E+01_JPRB,0.68593E+01_JPRB /)  
KB(:, 1,27,11) = (/ &
 & 0.24381E+01_JPRB,0.54719E+01_JPRB,0.63296E+01_JPRB,0.63699E+01_JPRB,0.47378E+01_JPRB /)  
KB(:, 2,27,11) = (/ &
 & 0.25833E+01_JPRB,0.59706E+01_JPRB,0.69839E+01_JPRB,0.69809E+01_JPRB,0.52024E+01_JPRB /)  
KB(:, 3,27,11) = (/ &
 & 0.27276E+01_JPRB,0.65032E+01_JPRB,0.76823E+01_JPRB,0.76623E+01_JPRB,0.56849E+01_JPRB /)  
KB(:, 4,27,11) = (/ &
 & 0.28843E+01_JPRB,0.70768E+01_JPRB,0.84223E+01_JPRB,0.83973E+01_JPRB,0.61613E+01_JPRB /)  
KB(:, 5,27,11) = (/ &
 & 0.30776E+01_JPRB,0.76837E+01_JPRB,0.91929E+01_JPRB,0.91871E+01_JPRB,0.66697E+01_JPRB /)  
KB(:, 1,28,11) = (/ &
 & 0.22238E+01_JPRB,0.52366E+01_JPRB,0.61335E+01_JPRB,0.61574E+01_JPRB,0.45705E+01_JPRB /)  
KB(:, 2,28,11) = (/ &
 & 0.23648E+01_JPRB,0.57451E+01_JPRB,0.68151E+01_JPRB,0.68266E+01_JPRB,0.50347E+01_JPRB /)  
KB(:, 3,28,11) = (/ &
 & 0.25067E+01_JPRB,0.62980E+01_JPRB,0.75460E+01_JPRB,0.75548E+01_JPRB,0.55064E+01_JPRB /)  
KB(:, 4,28,11) = (/ &
 & 0.26680E+01_JPRB,0.68930E+01_JPRB,0.83223E+01_JPRB,0.83308E+01_JPRB,0.60103E+01_JPRB /)  
KB(:, 5,28,11) = (/ &
 & 0.28763E+01_JPRB,0.75234E+01_JPRB,0.91269E+01_JPRB,0.91547E+01_JPRB,0.65443E+01_JPRB /)  
KB(:, 1,29,11) = (/ &
 & 0.20343E+01_JPRB,0.50540E+01_JPRB,0.60021E+01_JPRB,0.60360E+01_JPRB,0.44306E+01_JPRB /)  
KB(:, 2,29,11) = (/ &
 & 0.21732E+01_JPRB,0.55785E+01_JPRB,0.67134E+01_JPRB,0.67544E+01_JPRB,0.48924E+01_JPRB /)  
KB(:, 3,29,11) = (/ &
 & 0.23217E+01_JPRB,0.61554E+01_JPRB,0.74828E+01_JPRB,0.75217E+01_JPRB,0.53899E+01_JPRB /)  
KB(:, 4,29,11) = (/ &
 & 0.24991E+01_JPRB,0.67727E+01_JPRB,0.82943E+01_JPRB,0.83341E+01_JPRB,0.59211E+01_JPRB /)  
KB(:, 5,29,11) = (/ &
 & 0.27298E+01_JPRB,0.74309E+01_JPRB,0.91294E+01_JPRB,0.91877E+01_JPRB,0.64776E+01_JPRB /)  
KB(:, 1,30,11) = (/ &
 & 0.18678E+01_JPRB,0.49203E+01_JPRB,0.59291E+01_JPRB,0.59875E+01_JPRB,0.43204E+01_JPRB /)  
KB(:, 2,30,11) = (/ &
 & 0.20102E+01_JPRB,0.54667E+01_JPRB,0.66747E+01_JPRB,0.67430E+01_JPRB,0.48026E+01_JPRB /)  
KB(:, 3,30,11) = (/ &
 & 0.21719E+01_JPRB,0.60682E+01_JPRB,0.74827E+01_JPRB,0.75477E+01_JPRB,0.53281E+01_JPRB /)  
KB(:, 4,30,11) = (/ &
 & 0.23720E+01_JPRB,0.67126E+01_JPRB,0.83252E+01_JPRB,0.83910E+01_JPRB,0.58826E+01_JPRB /)  
KB(:, 5,30,11) = (/ &
 & 0.26264E+01_JPRB,0.73977E+01_JPRB,0.91870E+01_JPRB,0.92723E+01_JPRB,0.64598E+01_JPRB /)  
KB(:, 1,31,11) = (/ &
 & 0.17244E+01_JPRB,0.48370E+01_JPRB,0.59156E+01_JPRB,0.60001E+01_JPRB,0.42555E+01_JPRB /)  
KB(:, 2,31,11) = (/ &
 & 0.18755E+01_JPRB,0.54107E+01_JPRB,0.66999E+01_JPRB,0.67904E+01_JPRB,0.47644E+01_JPRB /)  
KB(:, 3,31,11) = (/ &
 & 0.20573E+01_JPRB,0.60363E+01_JPRB,0.75402E+01_JPRB,0.76274E+01_JPRB,0.53155E+01_JPRB /)  
KB(:, 4,31,11) = (/ &
 & 0.22829E+01_JPRB,0.67094E+01_JPRB,0.84079E+01_JPRB,0.84962E+01_JPRB,0.58901E+01_JPRB /)  
KB(:, 5,31,11) = (/ &
 & 0.25590E+01_JPRB,0.74195E+01_JPRB,0.92909E+01_JPRB,0.93994E+01_JPRB,0.64871E+01_JPRB /)  
KB(:, 1,32,11) = (/ &
 & 0.16069E+01_JPRB,0.48030E+01_JPRB,0.59579E+01_JPRB,0.60639E+01_JPRB,0.42356E+01_JPRB /)  
KB(:, 2,32,11) = (/ &
 & 0.17705E+01_JPRB,0.54037E+01_JPRB,0.67788E+01_JPRB,0.68874E+01_JPRB,0.47712E+01_JPRB /)  
KB(:, 3,32,11) = (/ &
 & 0.19742E+01_JPRB,0.60574E+01_JPRB,0.76448E+01_JPRB,0.77491E+01_JPRB,0.53434E+01_JPRB /)  
KB(:, 4,32,11) = (/ &
 & 0.22247E+01_JPRB,0.67560E+01_JPRB,0.85310E+01_JPRB,0.86385E+01_JPRB,0.59381E+01_JPRB /)  
KB(:, 5,32,11) = (/ &
 & 0.25238E+01_JPRB,0.74880E+01_JPRB,0.94292E+01_JPRB,0.95570E+01_JPRB,0.65497E+01_JPRB /)  
KB(:, 1,33,11) = (/ &
 & 0.15128E+01_JPRB,0.48140E+01_JPRB,0.60501E+01_JPRB,0.61714E+01_JPRB,0.42550E+01_JPRB /)  
KB(:, 2,33,11) = (/ &
 & 0.16946E+01_JPRB,0.54417E+01_JPRB,0.69000E+01_JPRB,0.70212E+01_JPRB,0.48155E+01_JPRB /)  
KB(:, 3,33,11) = (/ &
 & 0.19206E+01_JPRB,0.61213E+01_JPRB,0.77839E+01_JPRB,0.79020E+01_JPRB,0.54069E+01_JPRB /)  
KB(:, 4,33,11) = (/ &
 & 0.21946E+01_JPRB,0.68422E+01_JPRB,0.86827E+01_JPRB,0.88075E+01_JPRB,0.60169E+01_JPRB /)  
KB(:, 5,33,11) = (/ &
 & 0.25173E+01_JPRB,0.75913E+01_JPRB,0.95924E+01_JPRB,0.97373E+01_JPRB,0.66398E+01_JPRB /)  
KB(:, 1,34,11) = (/ &
 & 0.14356E+01_JPRB,0.48418E+01_JPRB,0.61495E+01_JPRB,0.62828E+01_JPRB,0.42896E+01_JPRB /)  
KB(:, 2,34,11) = (/ &
 & 0.16357E+01_JPRB,0.54935E+01_JPRB,0.70184E+01_JPRB,0.71516E+01_JPRB,0.48691E+01_JPRB /)  
KB(:, 3,34,11) = (/ &
 & 0.18838E+01_JPRB,0.61957E+01_JPRB,0.79151E+01_JPRB,0.80457E+01_JPRB,0.54742E+01_JPRB /)  
KB(:, 4,34,11) = (/ &
 & 0.21788E+01_JPRB,0.69325E+01_JPRB,0.88256E+01_JPRB,0.89643E+01_JPRB,0.60956E+01_JPRB /)  
KB(:, 5,34,11) = (/ &
 & 0.25238E+01_JPRB,0.76930E+01_JPRB,0.97439E+01_JPRB,0.99021E+01_JPRB,0.67264E+01_JPRB /)  
KB(:, 1,35,11) = (/ &
 & 0.13620E+01_JPRB,0.48400E+01_JPRB,0.61911E+01_JPRB,0.63341E+01_JPRB,0.42950E+01_JPRB /)  
KB(:, 2,35,11) = (/ &
 & 0.15765E+01_JPRB,0.55077E+01_JPRB,0.70717E+01_JPRB,0.72149E+01_JPRB,0.48872E+01_JPRB /)  
KB(:, 3,35,11) = (/ &
 & 0.18416E+01_JPRB,0.62238E+01_JPRB,0.79778E+01_JPRB,0.81173E+01_JPRB,0.55014E+01_JPRB /)  
KB(:, 4,35,11) = (/ &
 & 0.21528E+01_JPRB,0.69694E+01_JPRB,0.88951E+01_JPRB,0.90430E+01_JPRB,0.61304E+01_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART28',1,ZHOOK_HANDLE)
END SUBROUTINE PART28


SUBROUTINE PART29

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART29',0,ZHOOK_HANDLE)


KB(:, 5,35,11) = (/ &
 & 0.25135E+01_JPRB,0.77370E+01_JPRB,0.98191E+01_JPRB,0.99865E+01_JPRB,0.67662E+01_JPRB /)  
KB(:, 1,36,11) = (/ &
 & 0.12836E+01_JPRB,0.47892E+01_JPRB,0.61549E+01_JPRB,0.63050E+01_JPRB,0.42540E+01_JPRB /)  
KB(:, 2,36,11) = (/ &
 & 0.15070E+01_JPRB,0.54649E+01_JPRB,0.70416E+01_JPRB,0.71923E+01_JPRB,0.48536E+01_JPRB /)  
KB(:, 3,36,11) = (/ &
 & 0.17830E+01_JPRB,0.61872E+01_JPRB,0.79531E+01_JPRB,0.80994E+01_JPRB,0.54734E+01_JPRB /)  
KB(:, 4,36,11) = (/ &
 & 0.21055E+01_JPRB,0.69369E+01_JPRB,0.88745E+01_JPRB,0.90288E+01_JPRB,0.61066E+01_JPRB /)  
KB(:, 5,36,11) = (/ &
 & 0.24754E+01_JPRB,0.77090E+01_JPRB,0.98023E+01_JPRB,0.99759E+01_JPRB,0.67459E+01_JPRB /)  
KB(:, 1,37,11) = (/ &
 & 0.11878E+01_JPRB,0.46541E+01_JPRB,0.59975E+01_JPRB,0.61531E+01_JPRB,0.41357E+01_JPRB /)  
KB(:, 2,37,11) = (/ &
 & 0.14114E+01_JPRB,0.53279E+01_JPRB,0.68836E+01_JPRB,0.70407E+01_JPRB,0.47366E+01_JPRB /)  
KB(:, 3,37,11) = (/ &
 & 0.16907E+01_JPRB,0.60488E+01_JPRB,0.77961E+01_JPRB,0.79492E+01_JPRB,0.53587E+01_JPRB /)  
KB(:, 4,37,11) = (/ &
 & 0.20171E+01_JPRB,0.67987E+01_JPRB,0.87214E+01_JPRB,0.88782E+01_JPRB,0.59931E+01_JPRB /)  
KB(:, 5,37,11) = (/ &
 & 0.23879E+01_JPRB,0.75721E+01_JPRB,0.96505E+01_JPRB,0.98263E+01_JPRB,0.66346E+01_JPRB /)  
KB(:, 1,38,11) = (/ &
 & 0.11019E+01_JPRB,0.45241E+01_JPRB,0.58411E+01_JPRB,0.60015E+01_JPRB,0.40206E+01_JPRB /)  
KB(:, 2,38,11) = (/ &
 & 0.13240E+01_JPRB,0.51938E+01_JPRB,0.67248E+01_JPRB,0.68881E+01_JPRB,0.46215E+01_JPRB /)  
KB(:, 3,38,11) = (/ &
 & 0.16050E+01_JPRB,0.59127E+01_JPRB,0.76377E+01_JPRB,0.77969E+01_JPRB,0.52444E+01_JPRB /)  
KB(:, 4,38,11) = (/ &
 & 0.19344E+01_JPRB,0.66614E+01_JPRB,0.85656E+01_JPRB,0.87241E+01_JPRB,0.58797E+01_JPRB /)  
KB(:, 5,38,11) = (/ &
 & 0.23053E+01_JPRB,0.74352E+01_JPRB,0.94961E+01_JPRB,0.96730E+01_JPRB,0.65232E+01_JPRB /)  
KB(:, 1,39,11) = (/ &
 & 0.10261E+01_JPRB,0.44035E+01_JPRB,0.56925E+01_JPRB,0.58571E+01_JPRB,0.39130E+01_JPRB /)  
KB(:, 2,39,11) = (/ &
 & 0.12458E+01_JPRB,0.50694E+01_JPRB,0.65735E+01_JPRB,0.67411E+01_JPRB,0.45130E+01_JPRB /)  
KB(:, 3,39,11) = (/ &
 & 0.15281E+01_JPRB,0.57844E+01_JPRB,0.74853E+01_JPRB,0.76497E+01_JPRB,0.51353E+01_JPRB /)  
KB(:, 4,39,11) = (/ &
 & 0.18590E+01_JPRB,0.65310E+01_JPRB,0.84139E+01_JPRB,0.85752E+01_JPRB,0.57711E+01_JPRB /)  
KB(:, 5,39,11) = (/ &
 & 0.22296E+01_JPRB,0.73031E+01_JPRB,0.93461E+01_JPRB,0.95233E+01_JPRB,0.64155E+01_JPRB /)  
KB(:, 1,40,11) = (/ &
 & 0.94020E+00_JPRB,0.42252E+01_JPRB,0.54618E+01_JPRB,0.56305E+01_JPRB,0.37514E+01_JPRB /)  
KB(:, 2,40,11) = (/ &
 & 0.11510E+01_JPRB,0.48808E+01_JPRB,0.63359E+01_JPRB,0.65051E+01_JPRB,0.43464E+01_JPRB /)  
KB(:, 3,40,11) = (/ &
 & 0.14267E+01_JPRB,0.55865E+01_JPRB,0.72429E+01_JPRB,0.74116E+01_JPRB,0.49659E+01_JPRB /)  
KB(:, 4,40,11) = (/ &
 & 0.17534E+01_JPRB,0.63284E+01_JPRB,0.81706E+01_JPRB,0.83346E+01_JPRB,0.56004E+01_JPRB /)  
KB(:, 5,40,11) = (/ &
 & 0.21196E+01_JPRB,0.70954E+01_JPRB,0.91038E+01_JPRB,0.92790E+01_JPRB,0.62443E+01_JPRB /)  
KB(:, 1,41,11) = (/ &
 & 0.86129E+00_JPRB,0.40457E+01_JPRB,0.52264E+01_JPRB,0.53976E+01_JPRB,0.35879E+01_JPRB /)  
KB(:, 2,41,11) = (/ &
 & 0.10633E+01_JPRB,0.46915E+01_JPRB,0.60924E+01_JPRB,0.62635E+01_JPRB,0.41768E+01_JPRB /)  
KB(:, 3,41,11) = (/ &
 & 0.13283E+01_JPRB,0.53845E+01_JPRB,0.69926E+01_JPRB,0.71649E+01_JPRB,0.47921E+01_JPRB /)  
KB(:, 4,41,11) = (/ &
 & 0.16485E+01_JPRB,0.61201E+01_JPRB,0.79175E+01_JPRB,0.80844E+01_JPRB,0.54240E+01_JPRB /)  
KB(:, 5,41,11) = (/ &
 & 0.20093E+01_JPRB,0.68812E+01_JPRB,0.88522E+01_JPRB,0.90249E+01_JPRB,0.60668E+01_JPRB /)  
KB(:, 1,42,11) = (/ &
 & 0.79123E+00_JPRB,0.38735E+01_JPRB,0.49960E+01_JPRB,0.51699E+01_JPRB,0.34287E+01_JPRB /)  
KB(:, 2,42,11) = (/ &
 & 0.98295E+00_JPRB,0.45072E+01_JPRB,0.58533E+01_JPRB,0.60254E+01_JPRB,0.40109E+01_JPRB /)  
KB(:, 3,42,11) = (/ &
 & 0.12364E+01_JPRB,0.51876E+01_JPRB,0.67459E+01_JPRB,0.69214E+01_JPRB,0.46212E+01_JPRB /)  
KB(:, 4,42,11) = (/ &
 & 0.15484E+01_JPRB,0.59150E+01_JPRB,0.76665E+01_JPRB,0.78373E+01_JPRB,0.52503E+01_JPRB /)  
KB(:, 5,42,11) = (/ &
 & 0.19026E+01_JPRB,0.66716E+01_JPRB,0.86018E+01_JPRB,0.87728E+01_JPRB,0.58915E+01_JPRB /)  
KB(:, 1,43,11) = (/ &
 & 0.71984E+00_JPRB,0.36729E+01_JPRB,0.47235E+01_JPRB,0.48975E+01_JPRB,0.32397E+01_JPRB /)  
KB(:, 2,43,11) = (/ &
 & 0.89808E+00_JPRB,0.42916E+01_JPRB,0.55697E+01_JPRB,0.57443E+01_JPRB,0.38153E+01_JPRB /)  
KB(:, 3,43,11) = (/ &
 & 0.11360E+01_JPRB,0.49574E+01_JPRB,0.64519E+01_JPRB,0.66289E+01_JPRB,0.44184E+01_JPRB /)  
KB(:, 4,43,11) = (/ &
 & 0.14345E+01_JPRB,0.56728E+01_JPRB,0.73660E+01_JPRB,0.75410E+01_JPRB,0.50437E+01_JPRB /)  
KB(:, 5,43,11) = (/ &
 & 0.17793E+01_JPRB,0.64228E+01_JPRB,0.82999E+01_JPRB,0.84705E+01_JPRB,0.56823E+01_JPRB /)  
KB(:, 1,44,11) = (/ &
 & 0.65285E+00_JPRB,0.34667E+01_JPRB,0.44372E+01_JPRB,0.46082E+01_JPRB,0.30399E+01_JPRB /)  
KB(:, 2,44,11) = (/ &
 & 0.81657E+00_JPRB,0.40674E+01_JPRB,0.52701E+01_JPRB,0.54466E+01_JPRB,0.36094E+01_JPRB /)  
KB(:, 3,44,11) = (/ &
 & 0.10370E+01_JPRB,0.47171E+01_JPRB,0.61405E+01_JPRB,0.63175E+01_JPRB,0.42038E+01_JPRB /)  
KB(:, 4,44,11) = (/ &
 & 0.13194E+01_JPRB,0.54184E+01_JPRB,0.70473E+01_JPRB,0.72248E+01_JPRB,0.48237E+01_JPRB /)  
KB(:, 5,44,11) = (/ &
 & 0.16514E+01_JPRB,0.61584E+01_JPRB,0.79760E+01_JPRB,0.81477E+01_JPRB,0.54581E+01_JPRB /)  
KB(:, 1,45,11) = (/ &
 & 0.59324E+00_JPRB,0.32687E+01_JPRB,0.41610E+01_JPRB,0.43270E+01_JPRB,0.28437E+01_JPRB /)  
KB(:, 2,45,11) = (/ &
 & 0.74292E+00_JPRB,0.38502E+01_JPRB,0.49754E+01_JPRB,0.51525E+01_JPRB,0.34081E+01_JPRB /)  
KB(:, 3,45,11) = (/ &
 & 0.94606E+00_JPRB,0.44838E+01_JPRB,0.58347E+01_JPRB,0.60112E+01_JPRB,0.39932E+01_JPRB /)  
KB(:, 4,45,11) = (/ &
 & 0.12103E+01_JPRB,0.51691E+01_JPRB,0.67312E+01_JPRB,0.69113E+01_JPRB,0.46063E+01_JPRB /)  
KB(:, 5,45,11) = (/ &
 & 0.15283E+01_JPRB,0.58970E+01_JPRB,0.76529E+01_JPRB,0.78283E+01_JPRB,0.52365E+01_JPRB /)  
KB(:, 1,46,11) = (/ &
 & 0.53665E+00_JPRB,0.30665E+01_JPRB,0.38788E+01_JPRB,0.40344E+01_JPRB,0.26396E+01_JPRB /)  
KB(:, 2,46,11) = (/ &
 & 0.67326E+00_JPRB,0.36275E+01_JPRB,0.46685E+01_JPRB,0.48445E+01_JPRB,0.31970E+01_JPRB /)  
KB(:, 3,46,11) = (/ &
 & 0.85964E+00_JPRB,0.42450E+01_JPRB,0.55161E+01_JPRB,0.56940E+01_JPRB,0.37742E+01_JPRB /)  
KB(:, 4,46,11) = (/ &
 & 0.11026E+01_JPRB,0.49112E+01_JPRB,0.63992E+01_JPRB,0.65795E+01_JPRB,0.43785E+01_JPRB /)  
KB(:, 5,46,11) = (/ &
 & 0.14030E+01_JPRB,0.56247E+01_JPRB,0.73128E+01_JPRB,0.74918E+01_JPRB,0.50037E+01_JPRB /)  
KB(:, 1,47,11) = (/ &
 & 0.47965E+00_JPRB,0.28512E+01_JPRB,0.35773E+01_JPRB,0.37190E+01_JPRB,0.24179E+01_JPRB /)  
KB(:, 2,47,11) = (/ &
 & 0.60499E+00_JPRB,0.33895E+01_JPRB,0.43353E+01_JPRB,0.45070E+01_JPRB,0.29653E+01_JPRB /)  
KB(:, 3,47,11) = (/ &
 & 0.77211E+00_JPRB,0.39857E+01_JPRB,0.51656E+01_JPRB,0.53439E+01_JPRB,0.35346E+01_JPRB /)  
KB(:, 4,47,11) = (/ &
 & 0.99280E+00_JPRB,0.46320E+01_JPRB,0.60346E+01_JPRB,0.62138E+01_JPRB,0.41278E+01_JPRB /)  
KB(:, 5,47,11) = (/ &
 & 0.12711E+01_JPRB,0.53272E+01_JPRB,0.69377E+01_JPRB,0.71189E+01_JPRB,0.47464E+01_JPRB /)  
KB(:, 1,48,11) = (/ &
 & 0.42651E+00_JPRB,0.26445E+01_JPRB,0.32894E+01_JPRB,0.34148E+01_JPRB,0.22033E+01_JPRB /)  
KB(:, 2,48,11) = (/ &
 & 0.54388E+00_JPRB,0.31611E+01_JPRB,0.40161E+01_JPRB,0.41791E+01_JPRB,0.27373E+01_JPRB /)  
KB(:, 3,48,11) = (/ &
 & 0.69368E+00_JPRB,0.37347E+01_JPRB,0.48206E+01_JPRB,0.49989E+01_JPRB,0.32997E+01_JPRB /)  
KB(:, 4,48,11) = (/ &
 & 0.89279E+00_JPRB,0.43620E+01_JPRB,0.56767E+01_JPRB,0.58554E+01_JPRB,0.38822E+01_JPRB /)  
KB(:, 5,48,11) = (/ &
 & 0.11484E+01_JPRB,0.50369E+01_JPRB,0.65668E+01_JPRB,0.67495E+01_JPRB,0.44918E+01_JPRB /)  
KB(:, 1,49,11) = (/ &
 & 0.37713E+00_JPRB,0.24439E+01_JPRB,0.30160E+01_JPRB,0.31206E+01_JPRB,0.19976E+01_JPRB /)  
KB(:, 2,49,11) = (/ &
 & 0.48766E+00_JPRB,0.29434E+01_JPRB,0.37104E+01_JPRB,0.38599E+01_JPRB,0.25143E+01_JPRB /)  
KB(:, 3,49,11) = (/ &
 & 0.62407E+00_JPRB,0.34939E+01_JPRB,0.44847E+01_JPRB,0.46596E+01_JPRB,0.30680E+01_JPRB /)  
KB(:, 4,49,11) = (/ &
 & 0.80298E+00_JPRB,0.41006E+01_JPRB,0.53255E+01_JPRB,0.55049E+01_JPRB,0.36413E+01_JPRB /)  
KB(:, 5,49,11) = (/ &
 & 0.10353E+01_JPRB,0.47554E+01_JPRB,0.62010E+01_JPRB,0.63820E+01_JPRB,0.42407E+01_JPRB /)  
KB(:, 1,50,11) = (/ &
 & 0.33334E+00_JPRB,0.22573E+01_JPRB,0.27730E+01_JPRB,0.28537E+01_JPRB,0.18141E+01_JPRB /)  
KB(:, 2,50,11) = (/ &
 & 0.43824E+00_JPRB,0.27477E+01_JPRB,0.34359E+01_JPRB,0.35712E+01_JPRB,0.23112E+01_JPRB /)  
KB(:, 3,50,11) = (/ &
 & 0.56555E+00_JPRB,0.32767E+01_JPRB,0.41807E+01_JPRB,0.43497E+01_JPRB,0.28540E+01_JPRB /)  
KB(:, 4,50,11) = (/ &
 & 0.72662E+00_JPRB,0.38631E+01_JPRB,0.50003E+01_JPRB,0.51798E+01_JPRB,0.34206E+01_JPRB /)  
KB(:, 5,50,11) = (/ &
 & 0.93811E+00_JPRB,0.44998E+01_JPRB,0.58635E+01_JPRB,0.60433E+01_JPRB,0.40092E+01_JPRB /)  
KB(:, 1,51,11) = (/ &
 & 0.29344E+00_JPRB,0.20792E+01_JPRB,0.25493E+01_JPRB,0.26045E+01_JPRB,0.16447E+01_JPRB /)  
KB(:, 2,51,11) = (/ &
 & 0.39320E+00_JPRB,0.25633E+01_JPRB,0.31811E+01_JPRB,0.32996E+01_JPRB,0.21202E+01_JPRB /)  
KB(:, 3,51,11) = (/ &
 & 0.51335E+00_JPRB,0.30739E+01_JPRB,0.38968E+01_JPRB,0.40554E+01_JPRB,0.26493E+01_JPRB /)  
KB(:, 4,51,11) = (/ &
 & 0.65991E+00_JPRB,0.36396E+01_JPRB,0.46910E+01_JPRB,0.48692E+01_JPRB,0.32095E+01_JPRB /)  
KB(:, 5,51,11) = (/ &
 & 0.85305E+00_JPRB,0.42602E+01_JPRB,0.55428E+01_JPRB,0.57227E+01_JPRB,0.37890E+01_JPRB /)  
KB(:, 1,52,11) = (/ &
 & 0.25634E+00_JPRB,0.19065E+01_JPRB,0.23373E+01_JPRB,0.23675E+01_JPRB,0.14849E+01_JPRB /)  
KB(:, 2,52,11) = (/ &
 & 0.35085E+00_JPRB,0.23832E+01_JPRB,0.29380E+01_JPRB,0.30363E+01_JPRB,0.19379E+01_JPRB /)  
KB(:, 3,52,11) = (/ &
 & 0.46463E+00_JPRB,0.28806E+01_JPRB,0.36245E+01_JPRB,0.37705E+01_JPRB,0.24499E+01_JPRB /)  
KB(:, 4,52,11) = (/ &
 & 0.60014E+00_JPRB,0.34247E+01_JPRB,0.43901E+01_JPRB,0.45644E+01_JPRB,0.30013E+01_JPRB /)  
KB(:, 5,52,11) = (/ &
 & 0.77502E+00_JPRB,0.40268E+01_JPRB,0.52264E+01_JPRB,0.54064E+01_JPRB,0.35729E+01_JPRB /)  
KB(:, 1,53,11) = (/ &
 & 0.22198E+00_JPRB,0.17382E+01_JPRB,0.21355E+01_JPRB,0.21443E+01_JPRB,0.13321E+01_JPRB /)  
KB(:, 2,53,11) = (/ &
 & 0.31088E+00_JPRB,0.22037E+01_JPRB,0.27070E+01_JPRB,0.27809E+01_JPRB,0.17631E+01_JPRB /)  
KB(:, 3,53,11) = (/ &
 & 0.41868E+00_JPRB,0.26937E+01_JPRB,0.33628E+01_JPRB,0.34937E+01_JPRB,0.22551E+01_JPRB /)  
KB(:, 4,53,11) = (/ &
 & 0.54590E+00_JPRB,0.32172E+01_JPRB,0.40994E+01_JPRB,0.42669E+01_JPRB,0.27950E+01_JPRB /)  
KB(:, 5,53,11) = (/ &
 & 0.70382E+00_JPRB,0.37993E+01_JPRB,0.49134E+01_JPRB,0.50934E+01_JPRB,0.33609E+01_JPRB /)  
KB(:, 1,54,11) = (/ &
 & 0.19279E+00_JPRB,0.15884E+01_JPRB,0.19576E+01_JPRB,0.19516E+01_JPRB,0.11991E+01_JPRB /)  
KB(:, 2,54,11) = (/ &
 & 0.27614E+00_JPRB,0.20423E+01_JPRB,0.25053E+01_JPRB,0.25559E+01_JPRB,0.16106E+01_JPRB /)  
KB(:, 3,54,11) = (/ &
 & 0.37900E+00_JPRB,0.25264E+01_JPRB,0.31323E+01_JPRB,0.32473E+01_JPRB,0.20825E+01_JPRB /)  
KB(:, 4,54,11) = (/ &
 & 0.49954E+00_JPRB,0.30344E+01_JPRB,0.38425E+01_JPRB,0.39994E+01_JPRB,0.26090E+01_JPRB /)  
KB(:, 5,54,11) = (/ &
 & 0.64483E+00_JPRB,0.35967E+01_JPRB,0.46320E+01_JPRB,0.48104E+01_JPRB,0.31683E+01_JPRB /)  
KB(:, 1,55,11) = (/ &
 & 0.16752E+00_JPRB,0.14506E+01_JPRB,0.17924E+01_JPRB,0.17780E+01_JPRB,0.10766E+01_JPRB /)  
KB(:, 2,55,11) = (/ &
 & 0.24546E+00_JPRB,0.18924E+01_JPRB,0.23215E+01_JPRB,0.23502E+01_JPRB,0.14718E+01_JPRB /)  
KB(:, 3,55,11) = (/ &
 & 0.34282E+00_JPRB,0.23686E+01_JPRB,0.29203E+01_JPRB,0.30171E+01_JPRB,0.19238E+01_JPRB /)  
KB(:, 4,55,11) = (/ &
 & 0.45751E+00_JPRB,0.28657E+01_JPRB,0.36048E+01_JPRB,0.37504E+01_JPRB,0.24347E+01_JPRB /)  
KB(:, 5,55,11) = (/ &
 & 0.59345E+00_JPRB,0.34091E+01_JPRB,0.43692E+01_JPRB,0.45436E+01_JPRB,0.29860E+01_JPRB /)  
KB(:, 1,56,11) = (/ &
 & 0.14442E+00_JPRB,0.13191E+01_JPRB,0.16307E+01_JPRB,0.16158E+01_JPRB,0.95966E+00_JPRB /)  
KB(:, 2,56,11) = (/ &
 & 0.21629E+00_JPRB,0.17456E+01_JPRB,0.21454E+01_JPRB,0.21553E+01_JPRB,0.13384E+01_JPRB /)  
KB(:, 3,56,11) = (/ &
 & 0.30838E+00_JPRB,0.22117E+01_JPRB,0.27184E+01_JPRB,0.27939E+01_JPRB,0.17710E+01_JPRB /)  
KB(:, 4,56,11) = (/ &
 & 0.41780E+00_JPRB,0.27024E+01_JPRB,0.33761E+01_JPRB,0.35083E+01_JPRB,0.22647E+01_JPRB /)  
KB(:, 5,56,11) = (/ &
 & 0.54633E+00_JPRB,0.32277E+01_JPRB,0.41153E+01_JPRB,0.42835E+01_JPRB,0.28057E+01_JPRB /)  
KB(:, 1,57,11) = (/ &
 & 0.12369E+00_JPRB,0.11942E+01_JPRB,0.14751E+01_JPRB,0.14660E+01_JPRB,0.84794E+00_JPRB /)  
KB(:, 2,57,11) = (/ &
 & 0.18943E+00_JPRB,0.16025E+01_JPRB,0.19752E+01_JPRB,0.19706E+01_JPRB,0.12104E+01_JPRB /)  
KB(:, 3,57,11) = (/ &
 & 0.27580E+00_JPRB,0.20577E+01_JPRB,0.25253E+01_JPRB,0.25785E+01_JPRB,0.16249E+01_JPRB /)  
KB(:, 4,57,11) = (/ &
 & 0.38015E+00_JPRB,0.25425E+01_JPRB,0.31554E+01_JPRB,0.32724E+01_JPRB,0.20995E+01_JPRB /)  
KB(:, 5,57,11) = (/ &
 & 0.50220E+00_JPRB,0.30528E+01_JPRB,0.38694E+01_JPRB,0.40275E+01_JPRB,0.26279E+01_JPRB /)  
KB(:, 1,58,11) = (/ &
 & 0.10619E+00_JPRB,0.10815E+01_JPRB,0.13338E+01_JPRB,0.13340E+01_JPRB,0.74924E+00_JPRB /)  
KB(:, 2,58,11) = (/ &
 & 0.16586E+00_JPRB,0.14713E+01_JPRB,0.18183E+01_JPRB,0.18047E+01_JPRB,0.10933E+01_JPRB /)  
KB(:, 3,58,11) = (/ &
 & 0.24668E+00_JPRB,0.19150E+01_JPRB,0.23498E+01_JPRB,0.23824E+01_JPRB,0.14931E+01_JPRB /)  
KB(:, 4,58,11) = (/ &
 & 0.34613E+00_JPRB,0.23936E+01_JPRB,0.29542E+01_JPRB,0.30545E+01_JPRB,0.19489E+01_JPRB /)  
KB(:, 5,58,11) = (/ &
 & 0.46251E+00_JPRB,0.28928E+01_JPRB,0.36439E+01_JPRB,0.37914E+01_JPRB,0.24628E+01_JPRB /)  
KB(:, 1,59,11) = (/ &
 & 0.98781E-01_JPRB,0.10374E+01_JPRB,0.12790E+01_JPRB,0.12834E+01_JPRB,0.71091E+00_JPRB /)  
KB(:, 2,59,11) = (/ &
 & 0.15643E+00_JPRB,0.14199E+01_JPRB,0.17560E+01_JPRB,0.17406E+01_JPRB,0.10475E+01_JPRB /)  
KB(:, 3,59,11) = (/ &
 & 0.23512E+00_JPRB,0.18585E+01_JPRB,0.22815E+01_JPRB,0.23061E+01_JPRB,0.14408E+01_JPRB /)  
KB(:, 4,59,11) = (/ &
 & 0.33250E+00_JPRB,0.23338E+01_JPRB,0.28755E+01_JPRB,0.29686E+01_JPRB,0.18898E+01_JPRB /)  
KB(:, 5,59,11) = (/ &
 & 0.44697E+00_JPRB,0.28298E+01_JPRB,0.35555E+01_JPRB,0.36984E+01_JPRB,0.23975E+01_JPRB /)  
KB(:, 1,13,12) = (/ &
 & 0.30998E+02_JPRB,0.37385E+02_JPRB,0.40609E+02_JPRB,0.38100E+02_JPRB,0.30845E+02_JPRB /)  
KB(:, 2,13,12) = (/ &
 & 0.30490E+02_JPRB,0.37042E+02_JPRB,0.40582E+02_JPRB,0.38272E+02_JPRB,0.31245E+02_JPRB /)  
KB(:, 3,13,12) = (/ &
 & 0.29985E+02_JPRB,0.36701E+02_JPRB,0.40520E+02_JPRB,0.38445E+02_JPRB,0.31621E+02_JPRB /)  
KB(:, 4,13,12) = (/ &
 & 0.29490E+02_JPRB,0.36329E+02_JPRB,0.40415E+02_JPRB,0.38594E+02_JPRB,0.32000E+02_JPRB /)  
KB(:, 5,13,12) = (/ &
 & 0.29015E+02_JPRB,0.35959E+02_JPRB,0.40312E+02_JPRB,0.38750E+02_JPRB,0.32433E+02_JPRB /)  
KB(:, 1,14,12) = (/ &
 & 0.27110E+02_JPRB,0.35184E+02_JPRB,0.38617E+02_JPRB,0.36399E+02_JPRB,0.28635E+02_JPRB /)  
KB(:, 2,14,12) = (/ &
 & 0.26641E+02_JPRB,0.34930E+02_JPRB,0.38606E+02_JPRB,0.36649E+02_JPRB,0.29079E+02_JPRB /)  
KB(:, 3,14,12) = (/ &
 & 0.26184E+02_JPRB,0.34642E+02_JPRB,0.38568E+02_JPRB,0.36926E+02_JPRB,0.29498E+02_JPRB /)  
KB(:, 4,14,12) = (/ &
 & 0.25751E+02_JPRB,0.34348E+02_JPRB,0.38555E+02_JPRB,0.37188E+02_JPRB,0.29949E+02_JPRB /)  
KB(:, 5,14,12) = (/ &
 & 0.25340E+02_JPRB,0.34077E+02_JPRB,0.38568E+02_JPRB,0.37453E+02_JPRB,0.30433E+02_JPRB /)  
KB(:, 1,15,12) = (/ &
 & 0.23379E+02_JPRB,0.32658E+02_JPRB,0.36083E+02_JPRB,0.34396E+02_JPRB,0.26632E+02_JPRB /)  
KB(:, 2,15,12) = (/ &
 & 0.22961E+02_JPRB,0.32462E+02_JPRB,0.36143E+02_JPRB,0.34739E+02_JPRB,0.27099E+02_JPRB /)  
KB(:, 3,15,12) = (/ &
 & 0.22574E+02_JPRB,0.32277E+02_JPRB,0.36234E+02_JPRB,0.35089E+02_JPRB,0.27554E+02_JPRB /)  
KB(:, 4,15,12) = (/ &
 & 0.22226E+02_JPRB,0.32107E+02_JPRB,0.36368E+02_JPRB,0.35457E+02_JPRB,0.28061E+02_JPRB /)  
KB(:, 5,15,12) = (/ &
 & 0.22052E+02_JPRB,0.31945E+02_JPRB,0.36473E+02_JPRB,0.35860E+02_JPRB,0.28623E+02_JPRB /)  
KB(:, 1,16,12) = (/ &
 & 0.19977E+02_JPRB,0.29953E+02_JPRB,0.33281E+02_JPRB,0.32282E+02_JPRB,0.24730E+02_JPRB /)  
KB(:, 2,16,12) = (/ &
 & 0.19633E+02_JPRB,0.29859E+02_JPRB,0.33454E+02_JPRB,0.32701E+02_JPRB,0.25245E+02_JPRB /)  
KB(:, 3,16,12) = (/ &
 & 0.19340E+02_JPRB,0.29766E+02_JPRB,0.33693E+02_JPRB,0.33152E+02_JPRB,0.25800E+02_JPRB /)  
KB(:, 4,16,12) = (/ &
 & 0.19247E+02_JPRB,0.29689E+02_JPRB,0.33933E+02_JPRB,0.33616E+02_JPRB,0.26378E+02_JPRB /)  
KB(:, 5,16,12) = (/ &
 & 0.19403E+02_JPRB,0.29623E+02_JPRB,0.34160E+02_JPRB,0.34111E+02_JPRB,0.26924E+02_JPRB /)  
KB(:, 1,17,12) = (/ &
 & 0.17051E+02_JPRB,0.27143E+02_JPRB,0.30473E+02_JPRB,0.30161E+02_JPRB,0.22931E+02_JPRB /)  
KB(:, 2,17,12) = (/ &
 & 0.16797E+02_JPRB,0.27123E+02_JPRB,0.30776E+02_JPRB,0.30670E+02_JPRB,0.23518E+02_JPRB /)  
KB(:, 3,17,12) = (/ &
 & 0.16741E+02_JPRB,0.27141E+02_JPRB,0.31121E+02_JPRB,0.31186E+02_JPRB,0.24127E+02_JPRB /)  
KB(:, 4,17,12) = (/ &
 & 0.16948E+02_JPRB,0.27189E+02_JPRB,0.31472E+02_JPRB,0.31736E+02_JPRB,0.24729E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART29',1,ZHOOK_HANDLE)
END SUBROUTINE PART29


SUBROUTINE PART30

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART30',0,ZHOOK_HANDLE)


KB(:, 5,17,12) = (/ &
 & 0.17485E+02_JPRB,0.27288E+02_JPRB,0.31858E+02_JPRB,0.32324E+02_JPRB,0.25297E+02_JPRB /)  
KB(:, 1,18,12) = (/ &
 & 0.14597E+02_JPRB,0.24342E+02_JPRB,0.27826E+02_JPRB,0.28130E+02_JPRB,0.21245E+02_JPRB /)  
KB(:, 2,18,12) = (/ &
 & 0.14547E+02_JPRB,0.24446E+02_JPRB,0.28237E+02_JPRB,0.28704E+02_JPRB,0.21885E+02_JPRB /)  
KB(:, 3,18,12) = (/ &
 & 0.14765E+02_JPRB,0.24583E+02_JPRB,0.28672E+02_JPRB,0.29288E+02_JPRB,0.22535E+02_JPRB /)  
KB(:, 4,18,12) = (/ &
 & 0.15315E+02_JPRB,0.24794E+02_JPRB,0.29147E+02_JPRB,0.29934E+02_JPRB,0.23159E+02_JPRB /)  
KB(:, 5,18,12) = (/ &
 & 0.16067E+02_JPRB,0.25143E+02_JPRB,0.29634E+02_JPRB,0.30628E+02_JPRB,0.23749E+02_JPRB /)  
KB(:, 1,19,12) = (/ &
 & 0.12640E+02_JPRB,0.21753E+02_JPRB,0.25384E+02_JPRB,0.26151E+02_JPRB,0.19661E+02_JPRB /)  
KB(:, 2,19,12) = (/ &
 & 0.12835E+02_JPRB,0.21949E+02_JPRB,0.25878E+02_JPRB,0.26810E+02_JPRB,0.20358E+02_JPRB /)  
KB(:, 3,19,12) = (/ &
 & 0.13356E+02_JPRB,0.22229E+02_JPRB,0.26410E+02_JPRB,0.27515E+02_JPRB,0.21037E+02_JPRB /)  
KB(:, 4,19,12) = (/ &
 & 0.14056E+02_JPRB,0.22664E+02_JPRB,0.26964E+02_JPRB,0.28265E+02_JPRB,0.21685E+02_JPRB /)  
KB(:, 5,19,12) = (/ &
 & 0.14855E+02_JPRB,0.23244E+02_JPRB,0.27571E+02_JPRB,0.29046E+02_JPRB,0.22336E+02_JPRB /)  
KB(:, 1,20,12) = (/ &
 & 0.11082E+02_JPRB,0.19491E+02_JPRB,0.23194E+02_JPRB,0.24313E+02_JPRB,0.18232E+02_JPRB /)  
KB(:, 2,20,12) = (/ &
 & 0.11562E+02_JPRB,0.19787E+02_JPRB,0.23755E+02_JPRB,0.25073E+02_JPRB,0.18946E+02_JPRB /)  
KB(:, 3,20,12) = (/ &
 & 0.12224E+02_JPRB,0.20238E+02_JPRB,0.24350E+02_JPRB,0.25880E+02_JPRB,0.19650E+02_JPRB /)  
KB(:, 4,20,12) = (/ &
 & 0.12987E+02_JPRB,0.20868E+02_JPRB,0.25012E+02_JPRB,0.26726E+02_JPRB,0.20347E+02_JPRB /)  
KB(:, 5,20,12) = (/ &
 & 0.13788E+02_JPRB,0.21712E+02_JPRB,0.25741E+02_JPRB,0.27588E+02_JPRB,0.21074E+02_JPRB /)  
KB(:, 1,21,12) = (/ &
 & 0.98833E+01_JPRB,0.17574E+02_JPRB,0.21209E+02_JPRB,0.22623E+02_JPRB,0.16925E+02_JPRB /)  
KB(:, 2,21,12) = (/ &
 & 0.10489E+02_JPRB,0.18010E+02_JPRB,0.21858E+02_JPRB,0.23471E+02_JPRB,0.17666E+02_JPRB /)  
KB(:, 3,21,12) = (/ &
 & 0.11209E+02_JPRB,0.18622E+02_JPRB,0.22555E+02_JPRB,0.24382E+02_JPRB,0.18394E+02_JPRB /)  
KB(:, 4,21,12) = (/ &
 & 0.11974E+02_JPRB,0.19474E+02_JPRB,0.23320E+02_JPRB,0.25315E+02_JPRB,0.19156E+02_JPRB /)  
KB(:, 5,21,12) = (/ &
 & 0.12743E+02_JPRB,0.20530E+02_JPRB,0.24213E+02_JPRB,0.26280E+02_JPRB,0.19957E+02_JPRB /)  
KB(:, 1,22,12) = (/ &
 & 0.89432E+01_JPRB,0.16023E+02_JPRB,0.19521E+02_JPRB,0.21142E+02_JPRB,0.15785E+02_JPRB /)  
KB(:, 2,22,12) = (/ &
 & 0.96012E+01_JPRB,0.16615E+02_JPRB,0.20251E+02_JPRB,0.22105E+02_JPRB,0.16565E+02_JPRB /)  
KB(:, 3,22,12) = (/ &
 & 0.10308E+02_JPRB,0.17429E+02_JPRB,0.21053E+02_JPRB,0.23102E+02_JPRB,0.17352E+02_JPRB /)  
KB(:, 4,22,12) = (/ &
 & 0.11034E+02_JPRB,0.18474E+02_JPRB,0.21986E+02_JPRB,0.24140E+02_JPRB,0.18184E+02_JPRB /)  
KB(:, 5,22,12) = (/ &
 & 0.11779E+02_JPRB,0.19675E+02_JPRB,0.23025E+02_JPRB,0.25198E+02_JPRB,0.19053E+02_JPRB /)  
KB(:, 1,23,12) = (/ &
 & 0.81558E+01_JPRB,0.14793E+02_JPRB,0.18088E+02_JPRB,0.19855E+02_JPRB,0.14800E+02_JPRB /)  
KB(:, 2,23,12) = (/ &
 & 0.87957E+01_JPRB,0.15543E+02_JPRB,0.18895E+02_JPRB,0.20923E+02_JPRB,0.15621E+02_JPRB /)  
KB(:, 3,23,12) = (/ &
 & 0.94593E+01_JPRB,0.16540E+02_JPRB,0.19849E+02_JPRB,0.22025E+02_JPRB,0.16480E+02_JPRB /)  
KB(:, 4,23,12) = (/ &
 & 0.10153E+02_JPRB,0.17706E+02_JPRB,0.20923E+02_JPRB,0.23160E+02_JPRB,0.17388E+02_JPRB /)  
KB(:, 5,23,12) = (/ &
 & 0.10876E+02_JPRB,0.18993E+02_JPRB,0.22113E+02_JPRB,0.24310E+02_JPRB,0.18322E+02_JPRB /)  
KB(:, 1,24,12) = (/ &
 & 0.74526E+01_JPRB,0.13830E+02_JPRB,0.16894E+02_JPRB,0.18769E+02_JPRB,0.13959E+02_JPRB /)  
KB(:, 2,24,12) = (/ &
 & 0.80517E+01_JPRB,0.14766E+02_JPRB,0.17833E+02_JPRB,0.19936E+02_JPRB,0.14836E+02_JPRB /)  
KB(:, 3,24,12) = (/ &
 & 0.86841E+01_JPRB,0.15873E+02_JPRB,0.18916E+02_JPRB,0.21150E+02_JPRB,0.15773E+02_JPRB /)  
KB(:, 4,24,12) = (/ &
 & 0.93535E+01_JPRB,0.17122E+02_JPRB,0.20131E+02_JPRB,0.22383E+02_JPRB,0.16742E+02_JPRB /)  
KB(:, 5,24,12) = (/ &
 & 0.10068E+02_JPRB,0.18482E+02_JPRB,0.21482E+02_JPRB,0.23634E+02_JPRB,0.17753E+02_JPRB /)  
KB(:, 1,25,12) = (/ &
 & 0.68105E+01_JPRB,0.13122E+02_JPRB,0.15953E+02_JPRB,0.17890E+02_JPRB,0.13264E+02_JPRB /)  
KB(:, 2,25,12) = (/ &
 & 0.73796E+01_JPRB,0.14193E+02_JPRB,0.17028E+02_JPRB,0.19160E+02_JPRB,0.14211E+02_JPRB /)  
KB(:, 3,25,12) = (/ &
 & 0.79883E+01_JPRB,0.15386E+02_JPRB,0.18237E+02_JPRB,0.20473E+02_JPRB,0.15219E+02_JPRB /)  
KB(:, 4,25,12) = (/ &
 & 0.86473E+01_JPRB,0.16702E+02_JPRB,0.19605E+02_JPRB,0.21810E+02_JPRB,0.16257E+02_JPRB /)  
KB(:, 5,25,12) = (/ &
 & 0.93513E+01_JPRB,0.18139E+02_JPRB,0.21087E+02_JPRB,0.23158E+02_JPRB,0.17339E+02_JPRB /)  
KB(:, 1,26,12) = (/ &
 & 0.62530E+01_JPRB,0.12619E+02_JPRB,0.15260E+02_JPRB,0.17241E+02_JPRB,0.12729E+02_JPRB /)  
KB(:, 2,26,12) = (/ &
 & 0.67955E+01_JPRB,0.13786E+02_JPRB,0.16460E+02_JPRB,0.18602E+02_JPRB,0.13751E+02_JPRB /)  
KB(:, 3,26,12) = (/ &
 & 0.73876E+01_JPRB,0.15061E+02_JPRB,0.17816E+02_JPRB,0.20014E+02_JPRB,0.14821E+02_JPRB /)  
KB(:, 4,26,12) = (/ &
 & 0.80374E+01_JPRB,0.16453E+02_JPRB,0.19314E+02_JPRB,0.21444E+02_JPRB,0.15933E+02_JPRB /)  
KB(:, 5,26,12) = (/ &
 & 0.87427E+01_JPRB,0.17956E+02_JPRB,0.20909E+02_JPRB,0.22878E+02_JPRB,0.17080E+02_JPRB /)  
KB(:, 1,27,12) = (/ &
 & 0.57700E+01_JPRB,0.12257E+02_JPRB,0.14782E+02_JPRB,0.16780E+02_JPRB,0.12335E+02_JPRB /)  
KB(:, 2,27,12) = (/ &
 & 0.62864E+01_JPRB,0.13513E+02_JPRB,0.16114E+02_JPRB,0.18231E+02_JPRB,0.13431E+02_JPRB /)  
KB(:, 3,27,12) = (/ &
 & 0.68675E+01_JPRB,0.14868E+02_JPRB,0.17601E+02_JPRB,0.19730E+02_JPRB,0.14565E+02_JPRB /)  
KB(:, 4,27,12) = (/ &
 & 0.75138E+01_JPRB,0.16329E+02_JPRB,0.19199E+02_JPRB,0.21244E+02_JPRB,0.15742E+02_JPRB /)  
KB(:, 5,27,12) = (/ &
 & 0.82289E+01_JPRB,0.17883E+02_JPRB,0.20886E+02_JPRB,0.22748E+02_JPRB,0.16940E+02_JPRB /)  
KB(:, 1,28,12) = (/ &
 & 0.53548E+01_JPRB,0.12024E+02_JPRB,0.14494E+02_JPRB,0.16490E+02_JPRB,0.12074E+02_JPRB /)  
KB(:, 2,28,12) = (/ &
 & 0.58567E+01_JPRB,0.13364E+02_JPRB,0.15954E+02_JPRB,0.18023E+02_JPRB,0.13231E+02_JPRB /)  
KB(:, 3,28,12) = (/ &
 & 0.64249E+01_JPRB,0.14793E+02_JPRB,0.17548E+02_JPRB,0.19599E+02_JPRB,0.14431E+02_JPRB /)  
KB(:, 4,28,12) = (/ &
 & 0.70763E+01_JPRB,0.16306E+02_JPRB,0.19232E+02_JPRB,0.21185E+02_JPRB,0.15664E+02_JPRB /)  
KB(:, 5,28,12) = (/ &
 & 0.78108E+01_JPRB,0.17913E+02_JPRB,0.20999E+02_JPRB,0.22748E+02_JPRB,0.16904E+02_JPRB /)  
KB(:, 1,29,12) = (/ &
 & 0.50045E+01_JPRB,0.11918E+02_JPRB,0.14389E+02_JPRB,0.16363E+02_JPRB,0.11938E+02_JPRB /)  
KB(:, 2,29,12) = (/ &
 & 0.55030E+01_JPRB,0.13334E+02_JPRB,0.15959E+02_JPRB,0.17970E+02_JPRB,0.13155E+02_JPRB /)  
KB(:, 3,29,12) = (/ &
 & 0.60662E+01_JPRB,0.14820E+02_JPRB,0.17638E+02_JPRB,0.19611E+02_JPRB,0.14408E+02_JPRB /)  
KB(:, 4,29,12) = (/ &
 & 0.67325E+01_JPRB,0.16392E+02_JPRB,0.19392E+02_JPRB,0.21253E+02_JPRB,0.15686E+02_JPRB /)  
KB(:, 5,29,12) = (/ &
 & 0.74925E+01_JPRB,0.18044E+02_JPRB,0.21206E+02_JPRB,0.22856E+02_JPRB,0.16965E+02_JPRB /)  
KB(:, 1,30,12) = (/ &
 & 0.47172E+01_JPRB,0.11917E+02_JPRB,0.14428E+02_JPRB,0.16368E+02_JPRB,0.11903E+02_JPRB /)  
KB(:, 2,30,12) = (/ &
 & 0.52125E+01_JPRB,0.13400E+02_JPRB,0.16089E+02_JPRB,0.18040E+02_JPRB,0.13179E+02_JPRB /)  
KB(:, 3,30,12) = (/ &
 & 0.57884E+01_JPRB,0.14940E+02_JPRB,0.17829E+02_JPRB,0.19728E+02_JPRB,0.14475E+02_JPRB /)  
KB(:, 4,30,12) = (/ &
 & 0.64722E+01_JPRB,0.16556E+02_JPRB,0.19636E+02_JPRB,0.21408E+02_JPRB,0.15787E+02_JPRB /)  
KB(:, 5,30,12) = (/ &
 & 0.72704E+01_JPRB,0.18251E+02_JPRB,0.21479E+02_JPRB,0.23035E+02_JPRB,0.17093E+02_JPRB /)  
KB(:, 1,31,12) = (/ &
 & 0.44858E+01_JPRB,0.12017E+02_JPRB,0.14590E+02_JPRB,0.16495E+02_JPRB,0.11969E+02_JPRB /)  
KB(:, 2,31,12) = (/ &
 & 0.49908E+01_JPRB,0.13550E+02_JPRB,0.16315E+02_JPRB,0.18215E+02_JPRB,0.13287E+02_JPRB /)  
KB(:, 3,31,12) = (/ &
 & 0.55864E+01_JPRB,0.15140E+02_JPRB,0.18101E+02_JPRB,0.19933E+02_JPRB,0.14620E+02_JPRB /)  
KB(:, 4,31,12) = (/ &
 & 0.63024E+01_JPRB,0.16801E+02_JPRB,0.19948E+02_JPRB,0.21636E+02_JPRB,0.15956E+02_JPRB /)  
KB(:, 5,31,12) = (/ &
 & 0.71504E+01_JPRB,0.18530E+02_JPRB,0.21815E+02_JPRB,0.23280E+02_JPRB,0.17277E+02_JPRB /)  
KB(:, 1,32,12) = (/ &
 & 0.43064E+01_JPRB,0.12199E+02_JPRB,0.14841E+02_JPRB,0.16712E+02_JPRB,0.12112E+02_JPRB /)  
KB(:, 2,32,12) = (/ &
 & 0.48346E+01_JPRB,0.13779E+02_JPRB,0.16613E+02_JPRB,0.18463E+02_JPRB,0.13462E+02_JPRB /)  
KB(:, 3,32,12) = (/ &
 & 0.54614E+01_JPRB,0.15404E+02_JPRB,0.18438E+02_JPRB,0.20209E+02_JPRB,0.14821E+02_JPRB /)  
KB(:, 4,32,12) = (/ &
 & 0.62177E+01_JPRB,0.17102E+02_JPRB,0.20311E+02_JPRB,0.21920E+02_JPRB,0.16172E+02_JPRB /)  
KB(:, 5,32,12) = (/ &
 & 0.71259E+01_JPRB,0.18855E+02_JPRB,0.22195E+02_JPRB,0.23574E+02_JPRB,0.17506E+02_JPRB /)  
KB(:, 1,33,12) = (/ &
 & 0.41801E+01_JPRB,0.12450E+02_JPRB,0.15154E+02_JPRB,0.16994E+02_JPRB,0.12315E+02_JPRB /)  
KB(:, 2,33,12) = (/ &
 & 0.47391E+01_JPRB,0.14064E+02_JPRB,0.16963E+02_JPRB,0.18765E+02_JPRB,0.13689E+02_JPRB /)  
KB(:, 3,33,12) = (/ &
 & 0.54061E+01_JPRB,0.15717E+02_JPRB,0.18820E+02_JPRB,0.20527E+02_JPRB,0.15064E+02_JPRB /)  
KB(:, 4,33,12) = (/ &
 & 0.62146E+01_JPRB,0.17442E+02_JPRB,0.20711E+02_JPRB,0.22242E+02_JPRB,0.16420E+02_JPRB /)  
KB(:, 5,33,12) = (/ &
 & 0.71827E+01_JPRB,0.19219E+02_JPRB,0.22608E+02_JPRB,0.23903E+02_JPRB,0.17762E+02_JPRB /)  
KB(:, 1,34,12) = (/ &
 & 0.40887E+01_JPRB,0.12691E+02_JPRB,0.15451E+02_JPRB,0.17259E+02_JPRB,0.12512E+02_JPRB /)  
KB(:, 2,34,12) = (/ &
 & 0.46819E+01_JPRB,0.14330E+02_JPRB,0.17288E+02_JPRB,0.19046E+02_JPRB,0.13902E+02_JPRB /)  
KB(:, 3,34,12) = (/ &
 & 0.53890E+01_JPRB,0.16007E+02_JPRB,0.19166E+02_JPRB,0.20816E+02_JPRB,0.15287E+02_JPRB /)  
KB(:, 4,34,12) = (/ &
 & 0.62486E+01_JPRB,0.17752E+02_JPRB,0.21067E+02_JPRB,0.22532E+02_JPRB,0.16650E+02_JPRB /)  
KB(:, 5,34,12) = (/ &
 & 0.72682E+01_JPRB,0.19545E+02_JPRB,0.22972E+02_JPRB,0.24194E+02_JPRB,0.17995E+02_JPRB /)  
KB(:, 1,35,12) = (/ &
 & 0.39916E+01_JPRB,0.12809E+02_JPRB,0.15601E+02_JPRB,0.17383E+02_JPRB,0.12605E+02_JPRB /)  
KB(:, 2,35,12) = (/ &
 & 0.46112E+01_JPRB,0.14460E+02_JPRB,0.17457E+02_JPRB,0.19181E+02_JPRB,0.14005E+02_JPRB /)  
KB(:, 3,35,12) = (/ &
 & 0.53474E+01_JPRB,0.16154E+02_JPRB,0.19347E+02_JPRB,0.20958E+02_JPRB,0.15398E+02_JPRB /)  
KB(:, 4,35,12) = (/ &
 & 0.62430E+01_JPRB,0.17913E+02_JPRB,0.21258E+02_JPRB,0.22679E+02_JPRB,0.16764E+02_JPRB /)  
KB(:, 5,35,12) = (/ &
 & 0.72953E+01_JPRB,0.19716E+02_JPRB,0.23169E+02_JPRB,0.24345E+02_JPRB,0.18113E+02_JPRB /)  
KB(:, 1,36,12) = (/ &
 & 0.38696E+01_JPRB,0.12768E+02_JPRB,0.15571E+02_JPRB,0.17332E+02_JPRB,0.12565E+02_JPRB /)  
KB(:, 2,36,12) = (/ &
 & 0.45034E+01_JPRB,0.14429E+02_JPRB,0.17436E+02_JPRB,0.19141E+02_JPRB,0.13973E+02_JPRB /)  
KB(:, 3,36,12) = (/ &
 & 0.52555E+01_JPRB,0.16128E+02_JPRB,0.19333E+02_JPRB,0.20927E+02_JPRB,0.15372E+02_JPRB /)  
KB(:, 4,36,12) = (/ &
 & 0.61640E+01_JPRB,0.17893E+02_JPRB,0.21249E+02_JPRB,0.22656E+02_JPRB,0.16743E+02_JPRB /)  
KB(:, 5,36,12) = (/ &
 & 0.72295E+01_JPRB,0.19702E+02_JPRB,0.23168E+02_JPRB,0.24329E+02_JPRB,0.18096E+02_JPRB /)  
KB(:, 1,37,12) = (/ &
 & 0.36883E+01_JPRB,0.12493E+02_JPRB,0.15274E+02_JPRB,0.17021E+02_JPRB,0.12322E+02_JPRB /)  
KB(:, 2,37,12) = (/ &
 & 0.43193E+01_JPRB,0.14156E+02_JPRB,0.17140E+02_JPRB,0.18841E+02_JPRB,0.13739E+02_JPRB /)  
KB(:, 3,37,12) = (/ &
 & 0.50636E+01_JPRB,0.15852E+02_JPRB,0.19039E+02_JPRB,0.20638E+02_JPRB,0.15145E+02_JPRB /)  
KB(:, 4,37,12) = (/ &
 & 0.59573E+01_JPRB,0.17616E+02_JPRB,0.20958E+02_JPRB,0.22386E+02_JPRB,0.16525E+02_JPRB /)  
KB(:, 5,37,12) = (/ &
 & 0.70089E+01_JPRB,0.19421E+02_JPRB,0.22881E+02_JPRB,0.24071E+02_JPRB,0.17883E+02_JPRB /)  
KB(:, 1,38,12) = (/ &
 & 0.35253E+01_JPRB,0.12215E+02_JPRB,0.14971E+02_JPRB,0.16706E+02_JPRB,0.12079E+02_JPRB /)  
KB(:, 2,38,12) = (/ &
 & 0.41507E+01_JPRB,0.13877E+02_JPRB,0.16837E+02_JPRB,0.18535E+02_JPRB,0.13501E+02_JPRB /)  
KB(:, 3,38,12) = (/ &
 & 0.48852E+01_JPRB,0.15572E+02_JPRB,0.18736E+02_JPRB,0.20342E+02_JPRB,0.14913E+02_JPRB /)  
KB(:, 4,38,12) = (/ &
 & 0.57613E+01_JPRB,0.17329E+02_JPRB,0.20656E+02_JPRB,0.22106E+02_JPRB,0.16300E+02_JPRB /)  
KB(:, 5,38,12) = (/ &
 & 0.67957E+01_JPRB,0.19130E+02_JPRB,0.22581E+02_JPRB,0.23804E+02_JPRB,0.17665E+02_JPRB /)  
KB(:, 1,39,12) = (/ &
 & 0.33825E+01_JPRB,0.11947E+02_JPRB,0.14676E+02_JPRB,0.16402E+02_JPRB,0.11843E+02_JPRB /)  
KB(:, 2,39,12) = (/ &
 & 0.39997E+01_JPRB,0.13607E+02_JPRB,0.16542E+02_JPRB,0.18237E+02_JPRB,0.13271E+02_JPRB /)  
KB(:, 3,39,12) = (/ &
 & 0.47242E+01_JPRB,0.15300E+02_JPRB,0.18440E+02_JPRB,0.20053E+02_JPRB,0.14687E+02_JPRB /)  
KB(:, 4,39,12) = (/ &
 & 0.55821E+01_JPRB,0.17050E+02_JPRB,0.20362E+02_JPRB,0.21831E+02_JPRB,0.16081E+02_JPRB /)  
KB(:, 5,39,12) = (/ &
 & 0.65965E+01_JPRB,0.18849E+02_JPRB,0.22289E+02_JPRB,0.23541E+02_JPRB,0.17452E+02_JPRB /)  
KB(:, 1,40,12) = (/ &
 & 0.31990E+01_JPRB,0.11518E+02_JPRB,0.14197E+02_JPRB,0.15916E+02_JPRB,0.11466E+02_JPRB /)  
KB(:, 2,40,12) = (/ &
 & 0.37954E+01_JPRB,0.13171E+02_JPRB,0.16060E+02_JPRB,0.17759E+02_JPRB,0.12898E+02_JPRB /)  
KB(:, 3,40,12) = (/ &
 & 0.44984E+01_JPRB,0.14859E+02_JPRB,0.17955E+02_JPRB,0.19586E+02_JPRB,0.14321E+02_JPRB /)  
KB(:, 4,40,12) = (/ &
 & 0.53220E+01_JPRB,0.16595E+02_JPRB,0.19875E+02_JPRB,0.21381E+02_JPRB,0.15725E+02_JPRB /)  
KB(:, 5,40,12) = (/ &
 & 0.62999E+01_JPRB,0.18387E+02_JPRB,0.21803E+02_JPRB,0.23109E+02_JPRB,0.17102E+02_JPRB /)  
KB(:, 1,41,12) = (/ &
 & 0.30240E+01_JPRB,0.11079E+02_JPRB,0.13703E+02_JPRB,0.15411E+02_JPRB,0.11075E+02_JPRB /)  
KB(:, 2,41,12) = (/ &
 & 0.35998E+01_JPRB,0.12722E+02_JPRB,0.15561E+02_JPRB,0.17259E+02_JPRB,0.12509E+02_JPRB /)  
KB(:, 3,41,12) = (/ &
 & 0.42766E+01_JPRB,0.14402E+02_JPRB,0.17450E+02_JPRB,0.19096E+02_JPRB,0.13938E+02_JPRB /)  
KB(:, 4,41,12) = (/ &
 & 0.50663E+01_JPRB,0.16123E+02_JPRB,0.19365E+02_JPRB,0.20905E+02_JPRB,0.15352E+02_JPRB /)  
KB(:, 5,41,12) = (/ &
 & 0.60051E+01_JPRB,0.17908E+02_JPRB,0.21295E+02_JPRB,0.22653E+02_JPRB,0.16735E+02_JPRB /)  
KB(:, 1,42,12) = (/ &
 & 0.28652E+01_JPRB,0.10648E+02_JPRB,0.13219E+02_JPRB,0.14913E+02_JPRB,0.10689E+02_JPRB /)  
KB(:, 2,42,12) = (/ &
 & 0.34153E+01_JPRB,0.12278E+02_JPRB,0.15063E+02_JPRB,0.16761E+02_JPRB,0.12121E+02_JPRB /)  
KB(:, 3,42,12) = (/ &
 & 0.40672E+01_JPRB,0.13952E+02_JPRB,0.16947E+02_JPRB,0.18606E+02_JPRB,0.13557E+02_JPRB /)  
KB(:, 4,42,12) = (/ &
 & 0.48264E+01_JPRB,0.15661E+02_JPRB,0.18858E+02_JPRB,0.20426E+02_JPRB,0.14977E+02_JPRB /)  
KB(:, 5,42,12) = (/ &
 & 0.57266E+01_JPRB,0.17431E+02_JPRB,0.20787E+02_JPRB,0.22197E+02_JPRB,0.16370E+02_JPRB /)  
KB(:, 1,43,12) = (/ &
 & 0.26870E+01_JPRB,0.10134E+02_JPRB,0.12642E+02_JPRB,0.14316E+02_JPRB,0.10228E+02_JPRB /)  
KB(:, 2,43,12) = (/ &
 & 0.32108E+01_JPRB,0.11745E+02_JPRB,0.14465E+02_JPRB,0.16161E+02_JPRB,0.11657E+02_JPRB /)  
KB(:, 3,43,12) = (/ &
 & 0.38308E+01_JPRB,0.13408E+02_JPRB,0.16340E+02_JPRB,0.18012E+02_JPRB,0.13095E+02_JPRB /)  
KB(:, 4,43,12) = (/ &
 & 0.45569E+01_JPRB,0.15107E+02_JPRB,0.18246E+02_JPRB,0.19843E+02_JPRB,0.14521E+02_JPRB /)  
KB(:, 5,43,12) = (/ &
 & 0.54100E+01_JPRB,0.16859E+02_JPRB,0.20173E+02_JPRB,0.21637E+02_JPRB,0.15927E+02_JPRB /)  
KB(:, 1,44,12) = (/ &
 & 0.25051E+01_JPRB,0.95885E+01_JPRB,0.12032E+02_JPRB,0.13682E+02_JPRB,0.97372E+01_JPRB /)  
KB(:, 2,44,12) = (/ &
 & 0.30054E+01_JPRB,0.11180E+02_JPRB,0.13825E+02_JPRB,0.15517E+02_JPRB,0.11159E+02_JPRB /)  
KB(:, 3,44,12) = (/ &
 & 0.35923E+01_JPRB,0.12828E+02_JPRB,0.15690E+02_JPRB,0.17372E+02_JPRB,0.12597E+02_JPRB /)  
KB(:, 4,44,12) = (/ &
 & 0.42861E+01_JPRB,0.14518E+02_JPRB,0.17591E+02_JPRB,0.19215E+02_JPRB,0.14031E+02_JPRB /)  
KB(:, 5,44,12) = (/ &
 & 0.50891E+01_JPRB,0.16248E+02_JPRB,0.19511E+02_JPRB,0.21026E+02_JPRB,0.15447E+02_JPRB /)  
KB(:, 1,45,12) = (/ &
 & 0.23284E+01_JPRB,0.90519E+01_JPRB,0.11435E+02_JPRB,0.13049E+02_JPRB,0.92487E+01_JPRB /)  
KB(:, 2,45,12) = (/ &
 & 0.28153E+01_JPRB,0.10623E+02_JPRB,0.13197E+02_JPRB,0.14880E+02_JPRB,0.10666E+02_JPRB /)  
KB(:, 3,45,12) = (/ &
 & 0.33686E+01_JPRB,0.12254E+02_JPRB,0.15046E+02_JPRB,0.16733E+02_JPRB,0.12101E+02_JPRB /)  
KB(:, 4,45,12) = (/ &
 & 0.40279E+01_JPRB,0.13936E+02_JPRB,0.16938E+02_JPRB,0.18583E+02_JPRB,0.13540E+02_JPRB /)  
KB(:, 5,45,12) = (/ &
 & 0.47894E+01_JPRB,0.15648E+02_JPRB,0.18852E+02_JPRB,0.20408E+02_JPRB,0.14963E+02_JPRB /)  
KB(:, 1,46,12) = (/ &
 & 0.21477E+01_JPRB,0.84947E+01_JPRB,0.10808E+02_JPRB,0.12382E+02_JPRB,0.87316E+01_JPRB /)  
KB(:, 2,46,12) = (/ &
 & 0.26237E+01_JPRB,0.10040E+02_JPRB,0.12543E+02_JPRB,0.14206E+02_JPRB,0.10145E+02_JPRB /)  
KB(:, 3,46,12) = (/ &
 & 0.31493E+01_JPRB,0.11653E+02_JPRB,0.14367E+02_JPRB,0.16054E+02_JPRB,0.11575E+02_JPRB /)  
KB(:, 4,46,12) = (/ &
 & 0.37687E+01_JPRB,0.13319E+02_JPRB,0.16247E+02_JPRB,0.17910E+02_JPRB,0.13015E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART30',1,ZHOOK_HANDLE)
END SUBROUTINE PART30


SUBROUTINE PART31

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART31',0,ZHOOK_HANDLE)


KB(:, 5,46,12) = (/ &
 & 0.44919E+01_JPRB,0.15018E+02_JPRB,0.18154E+02_JPRB,0.19746E+02_JPRB,0.14446E+02_JPRB /)  
KB(:, 1,47,12) = (/ &
 & 0.19539E+01_JPRB,0.78866E+01_JPRB,0.10121E+02_JPRB,0.11642E+02_JPRB,0.81629E+01_JPRB /)  
KB(:, 2,47,12) = (/ &
 & 0.24188E+01_JPRB,0.94011E+01_JPRB,0.11827E+02_JPRB,0.13461E+02_JPRB,0.95671E+01_JPRB /)  
KB(:, 3,47,12) = (/ &
 & 0.29183E+01_JPRB,0.10990E+02_JPRB,0.13614E+02_JPRB,0.15297E+02_JPRB,0.10990E+02_JPRB /)  
KB(:, 4,47,12) = (/ &
 & 0.34981E+01_JPRB,0.12636E+02_JPRB,0.15480E+02_JPRB,0.17155E+02_JPRB,0.12429E+02_JPRB /)  
KB(:, 5,47,12) = (/ &
 & 0.41787E+01_JPRB,0.14323E+02_JPRB,0.17378E+02_JPRB,0.19005E+02_JPRB,0.13866E+02_JPRB /)  
KB(:, 1,48,12) = (/ &
 & 0.17686E+01_JPRB,0.73016E+01_JPRB,0.94471E+01_JPRB,0.10908E+02_JPRB,0.76062E+01_JPRB /)  
KB(:, 2,48,12) = (/ &
 & 0.22191E+01_JPRB,0.87750E+01_JPRB,0.11125E+02_JPRB,0.12718E+02_JPRB,0.89921E+01_JPRB /)  
KB(:, 3,48,12) = (/ &
 & 0.27045E+01_JPRB,0.10336E+02_JPRB,0.12878E+02_JPRB,0.14548E+02_JPRB,0.10409E+02_JPRB /)  
KB(:, 4,48,12) = (/ &
 & 0.32460E+01_JPRB,0.11962E+02_JPRB,0.14721E+02_JPRB,0.16399E+02_JPRB,0.11843E+02_JPRB /)  
KB(:, 5,48,12) = (/ &
 & 0.38847E+01_JPRB,0.13635E+02_JPRB,0.16605E+02_JPRB,0.18256E+02_JPRB,0.13285E+02_JPRB /)  
KB(:, 1,49,12) = (/ &
 & 0.15926E+01_JPRB,0.67448E+01_JPRB,0.87885E+01_JPRB,0.10183E+02_JPRB,0.70558E+01_JPRB /)  
KB(:, 2,49,12) = (/ &
 & 0.20265E+01_JPRB,0.81616E+01_JPRB,0.10434E+02_JPRB,0.11978E+02_JPRB,0.84210E+01_JPRB /)  
KB(:, 3,49,12) = (/ &
 & 0.24995E+01_JPRB,0.96943E+01_JPRB,0.12158E+02_JPRB,0.13804E+02_JPRB,0.98335E+01_JPRB /)  
KB(:, 4,49,12) = (/ &
 & 0.30106E+01_JPRB,0.11296E+02_JPRB,0.13964E+02_JPRB,0.15645E+02_JPRB,0.11261E+02_JPRB /)  
KB(:, 5,49,12) = (/ &
 & 0.36091E+01_JPRB,0.12953E+02_JPRB,0.15838E+02_JPRB,0.17505E+02_JPRB,0.12701E+02_JPRB /)  
KB(:, 1,50,12) = (/ &
 & 0.14367E+01_JPRB,0.62503E+01_JPRB,0.81839E+01_JPRB,0.95114E+01_JPRB,0.65470E+01_JPRB /)  
KB(:, 2,50,12) = (/ &
 & 0.18513E+01_JPRB,0.76037E+01_JPRB,0.97986E+01_JPRB,0.11290E+02_JPRB,0.78962E+01_JPRB /)  
KB(:, 3,50,12) = (/ &
 & 0.23123E+01_JPRB,0.91032E+01_JPRB,0.11496E+02_JPRB,0.13108E+02_JPRB,0.92947E+01_JPRB /)  
KB(:, 4,50,12) = (/ &
 & 0.28056E+01_JPRB,0.10680E+02_JPRB,0.13267E+02_JPRB,0.14942E+02_JPRB,0.10716E+02_JPRB /)  
KB(:, 5,50,12) = (/ &
 & 0.33664E+01_JPRB,0.12318E+02_JPRB,0.15124E+02_JPRB,0.16800E+02_JPRB,0.12153E+02_JPRB /)  
KB(:, 1,51,12) = (/ &
 & 0.12944E+01_JPRB,0.57936E+01_JPRB,0.76117E+01_JPRB,0.88742E+01_JPRB,0.60642E+01_JPRB /)  
KB(:, 2,51,12) = (/ &
 & 0.16888E+01_JPRB,0.70852E+01_JPRB,0.91933E+01_JPRB,0.10628E+02_JPRB,0.73944E+01_JPRB /)  
KB(:, 3,51,12) = (/ &
 & 0.21353E+01_JPRB,0.85416E+01_JPRB,0.10863E+02_JPRB,0.12436E+02_JPRB,0.87735E+01_JPRB /)  
KB(:, 4,51,12) = (/ &
 & 0.26169E+01_JPRB,0.10093E+02_JPRB,0.12607E+02_JPRB,0.14266E+02_JPRB,0.10192E+02_JPRB /)  
KB(:, 5,51,12) = (/ &
 & 0.31479E+01_JPRB,0.11711E+02_JPRB,0.14438E+02_JPRB,0.16116E+02_JPRB,0.11624E+02_JPRB /)  
KB(:, 1,52,12) = (/ &
 & 0.11616E+01_JPRB,0.53570E+01_JPRB,0.70533E+01_JPRB,0.82560E+01_JPRB,0.55953E+01_JPRB /)  
KB(:, 2,52,12) = (/ &
 & 0.15340E+01_JPRB,0.65899E+01_JPRB,0.86019E+01_JPRB,0.99750E+01_JPRB,0.68982E+01_JPRB /)  
KB(:, 3,52,12) = (/ &
 & 0.19643E+01_JPRB,0.79903E+01_JPRB,0.10241E+02_JPRB,0.11768E+02_JPRB,0.82604E+01_JPRB /)  
KB(:, 4,52,12) = (/ &
 & 0.24347E+01_JPRB,0.95157E+01_JPRB,0.11958E+02_JPRB,0.13593E+02_JPRB,0.96707E+01_JPRB /)  
KB(:, 5,52,12) = (/ &
 & 0.29410E+01_JPRB,0.11112E+02_JPRB,0.13756E+02_JPRB,0.15434E+02_JPRB,0.11097E+02_JPRB /)  
KB(:, 1,53,12) = (/ &
 & 0.10377E+01_JPRB,0.49398E+01_JPRB,0.65141E+01_JPRB,0.76518E+01_JPRB,0.51386E+01_JPRB /)  
KB(:, 2,53,12) = (/ &
 & 0.13876E+01_JPRB,0.61188E+01_JPRB,0.80207E+01_JPRB,0.93291E+01_JPRB,0.64095E+01_JPRB /)  
KB(:, 3,53,12) = (/ &
 & 0.17987E+01_JPRB,0.74567E+01_JPRB,0.96292E+01_JPRB,0.11104E+02_JPRB,0.77562E+01_JPRB /)  
KB(:, 4,53,12) = (/ &
 & 0.22559E+01_JPRB,0.89467E+01_JPRB,0.11320E+02_JPRB,0.12921E+02_JPRB,0.91504E+01_JPRB /)  
KB(:, 5,53,12) = (/ &
 & 0.27477E+01_JPRB,0.10518E+02_JPRB,0.13086E+02_JPRB,0.14756E+02_JPRB,0.10571E+02_JPRB /)  
KB(:, 1,54,12) = (/ &
 & 0.93266E+00_JPRB,0.45754E+01_JPRB,0.60420E+01_JPRB,0.71108E+01_JPRB,0.47321E+01_JPRB /)  
KB(:, 2,54,12) = (/ &
 & 0.12608E+01_JPRB,0.57055E+01_JPRB,0.75003E+01_JPRB,0.87512E+01_JPRB,0.59717E+01_JPRB /)  
KB(:, 3,54,12) = (/ &
 & 0.16525E+01_JPRB,0.69875E+01_JPRB,0.90782E+01_JPRB,0.10501E+02_JPRB,0.72982E+01_JPRB /)  
KB(:, 4,54,12) = (/ &
 & 0.20962E+01_JPRB,0.84351E+01_JPRB,0.10744E+02_JPRB,0.12308E+02_JPRB,0.86747E+01_JPRB /)  
KB(:, 5,54,12) = (/ &
 & 0.25775E+01_JPRB,0.99827E+01_JPRB,0.12485E+02_JPRB,0.14138E+02_JPRB,0.10092E+02_JPRB /)  
KB(:, 1,55,12) = (/ &
 & 0.84048E+00_JPRB,0.42428E+01_JPRB,0.56145E+01_JPRB,0.66054E+01_JPRB,0.43544E+01_JPRB /)  
KB(:, 2,55,12) = (/ &
 & 0.11472E+01_JPRB,0.53270E+01_JPRB,0.70144E+01_JPRB,0.82122E+01_JPRB,0.55615E+01_JPRB /)  
KB(:, 3,55,12) = (/ &
 & 0.15181E+01_JPRB,0.65556E+01_JPRB,0.85601E+01_JPRB,0.99280E+01_JPRB,0.68631E+01_JPRB /)  
KB(:, 4,55,12) = (/ &
 & 0.19474E+01_JPRB,0.79524E+01_JPRB,0.10198E+02_JPRB,0.11721E+02_JPRB,0.82252E+01_JPRB /)  
KB(:, 5,55,12) = (/ &
 & 0.24188E+01_JPRB,0.94776E+01_JPRB,0.11916E+02_JPRB,0.13548E+02_JPRB,0.96351E+01_JPRB /)  
KB(:, 1,56,12) = (/ &
 & 0.75447E+00_JPRB,0.39270E+01_JPRB,0.52064E+01_JPRB,0.61093E+01_JPRB,0.39870E+01_JPRB /)  
KB(:, 2,56,12) = (/ &
 & 0.10395E+01_JPRB,0.49623E+01_JPRB,0.65429E+01_JPRB,0.76840E+01_JPRB,0.51623E+01_JPRB /)  
KB(:, 3,56,12) = (/ &
 & 0.13908E+01_JPRB,0.61440E+01_JPRB,0.80522E+01_JPRB,0.93640E+01_JPRB,0.64360E+01_JPRB /)  
KB(:, 4,56,12) = (/ &
 & 0.18031E+01_JPRB,0.74859E+01_JPRB,0.96627E+01_JPRB,0.11140E+02_JPRB,0.77842E+01_JPRB /)  
KB(:, 5,56,12) = (/ &
 & 0.22626E+01_JPRB,0.89798E+01_JPRB,0.11358E+02_JPRB,0.12960E+02_JPRB,0.91800E+01_JPRB /)  
KB(:, 1,57,12) = (/ &
 & 0.67513E+00_JPRB,0.36336E+01_JPRB,0.48180E+01_JPRB,0.56247E+01_JPRB,0.36284E+01_JPRB /)  
KB(:, 2,57,12) = (/ &
 & 0.93951E+00_JPRB,0.46135E+01_JPRB,0.60910E+01_JPRB,0.71671E+01_JPRB,0.47736E+01_JPRB /)  
KB(:, 3,57,12) = (/ &
 & 0.12699E+01_JPRB,0.57481E+01_JPRB,0.75541E+01_JPRB,0.88107E+01_JPRB,0.60168E+01_JPRB /)  
KB(:, 4,57,12) = (/ &
 & 0.16637E+01_JPRB,0.70362E+01_JPRB,0.91351E+01_JPRB,0.10564E+02_JPRB,0.73465E+01_JPRB /)  
KB(:, 5,57,12) = (/ &
 & 0.21102E+01_JPRB,0.84904E+01_JPRB,0.10807E+02_JPRB,0.12374E+02_JPRB,0.87256E+01_JPRB /)  
KB(:, 1,58,12) = (/ &
 & 0.60371E+00_JPRB,0.33725E+01_JPRB,0.44640E+01_JPRB,0.51801E+01_JPRB,0.32968E+01_JPRB /)  
KB(:, 2,58,12) = (/ &
 & 0.85131E+00_JPRB,0.42951E+01_JPRB,0.56822E+01_JPRB,0.66873E+01_JPRB,0.44155E+01_JPRB /)  
KB(:, 3,58,12) = (/ &
 & 0.11611E+01_JPRB,0.53867E+01_JPRB,0.70919E+01_JPRB,0.82985E+01_JPRB,0.56282E+01_JPRB /)  
KB(:, 4,58,12) = (/ &
 & 0.15366E+01_JPRB,0.66258E+01_JPRB,0.86445E+01_JPRB,0.10022E+02_JPRB,0.69358E+01_JPRB /)  
KB(:, 5,58,12) = (/ &
 & 0.19698E+01_JPRB,0.80329E+01_JPRB,0.10290E+02_JPRB,0.11819E+02_JPRB,0.83004E+01_JPRB /)  
KB(:, 1,59,12) = (/ &
 & 0.57552E+00_JPRB,0.32717E+01_JPRB,0.43250E+01_JPRB,0.50045E+01_JPRB,0.31668E+01_JPRB /)  
KB(:, 2,59,12) = (/ &
 & 0.81716E+00_JPRB,0.41713E+01_JPRB,0.55225E+01_JPRB,0.64964E+01_JPRB,0.42740E+01_JPRB /)  
KB(:, 3,59,12) = (/ &
 & 0.11190E+01_JPRB,0.52446E+01_JPRB,0.69091E+01_JPRB,0.80966E+01_JPRB,0.54744E+01_JPRB /)  
KB(:, 4,59,12) = (/ &
 & 0.14869E+01_JPRB,0.64659E+01_JPRB,0.84502E+01_JPRB,0.98065E+01_JPRB,0.67716E+01_JPRB /)  
KB(:, 5,59,12) = (/ &
 & 0.19139E+01_JPRB,0.78535E+01_JPRB,0.10085E+02_JPRB,0.11598E+02_JPRB,0.81311E+01_JPRB /)  
KB(:, 1,13,13) = (/ &
 & 0.79406E+02_JPRB,0.76977E+02_JPRB,0.79398E+02_JPRB,0.72265E+02_JPRB,0.70608E+02_JPRB /)  
KB(:, 2,13,13) = (/ &
 & 0.78716E+02_JPRB,0.76325E+02_JPRB,0.79145E+02_JPRB,0.72561E+02_JPRB,0.71233E+02_JPRB /)  
KB(:, 3,13,13) = (/ &
 & 0.77960E+02_JPRB,0.75684E+02_JPRB,0.78864E+02_JPRB,0.72811E+02_JPRB,0.71703E+02_JPRB /)  
KB(:, 4,13,13) = (/ &
 & 0.77172E+02_JPRB,0.75038E+02_JPRB,0.78462E+02_JPRB,0.73003E+02_JPRB,0.72067E+02_JPRB /)  
KB(:, 5,13,13) = (/ &
 & 0.76342E+02_JPRB,0.74357E+02_JPRB,0.78015E+02_JPRB,0.73077E+02_JPRB,0.72406E+02_JPRB /)  
KB(:, 1,14,13) = (/ &
 & 0.74002E+02_JPRB,0.75964E+02_JPRB,0.80244E+02_JPRB,0.73931E+02_JPRB,0.67973E+02_JPRB /)  
KB(:, 2,14,13) = (/ &
 & 0.73259E+02_JPRB,0.75350E+02_JPRB,0.80187E+02_JPRB,0.74373E+02_JPRB,0.68671E+02_JPRB /)  
KB(:, 3,14,13) = (/ &
 & 0.72511E+02_JPRB,0.74741E+02_JPRB,0.79998E+02_JPRB,0.74718E+02_JPRB,0.69297E+02_JPRB /)  
KB(:, 4,14,13) = (/ &
 & 0.71760E+02_JPRB,0.74129E+02_JPRB,0.79694E+02_JPRB,0.74933E+02_JPRB,0.69925E+02_JPRB /)  
KB(:, 5,14,13) = (/ &
 & 0.70963E+02_JPRB,0.73482E+02_JPRB,0.79282E+02_JPRB,0.75062E+02_JPRB,0.70592E+02_JPRB /)  
KB(:, 1,15,13) = (/ &
 & 0.67727E+02_JPRB,0.74204E+02_JPRB,0.79973E+02_JPRB,0.74524E+02_JPRB,0.64503E+02_JPRB /)  
KB(:, 2,15,13) = (/ &
 & 0.66995E+02_JPRB,0.73663E+02_JPRB,0.80067E+02_JPRB,0.75070E+02_JPRB,0.65404E+02_JPRB /)  
KB(:, 3,15,13) = (/ &
 & 0.66299E+02_JPRB,0.73080E+02_JPRB,0.80001E+02_JPRB,0.75489E+02_JPRB,0.66341E+02_JPRB /)  
KB(:, 4,15,13) = (/ &
 & 0.65584E+02_JPRB,0.72498E+02_JPRB,0.79808E+02_JPRB,0.75814E+02_JPRB,0.67293E+02_JPRB /)  
KB(:, 5,15,13) = (/ &
 & 0.64881E+02_JPRB,0.71894E+02_JPRB,0.79644E+02_JPRB,0.76073E+02_JPRB,0.68159E+02_JPRB /)  
KB(:, 1,16,13) = (/ &
 & 0.60910E+02_JPRB,0.71706E+02_JPRB,0.78658E+02_JPRB,0.73971E+02_JPRB,0.60740E+02_JPRB /)  
KB(:, 2,16,13) = (/ &
 & 0.60264E+02_JPRB,0.71204E+02_JPRB,0.78897E+02_JPRB,0.74647E+02_JPRB,0.61882E+02_JPRB /)  
KB(:, 3,16,13) = (/ &
 & 0.59646E+02_JPRB,0.70743E+02_JPRB,0.78998E+02_JPRB,0.75253E+02_JPRB,0.63062E+02_JPRB /)  
KB(:, 4,16,13) = (/ &
 & 0.59033E+02_JPRB,0.70274E+02_JPRB,0.79093E+02_JPRB,0.75819E+02_JPRB,0.64263E+02_JPRB /)  
KB(:, 5,16,13) = (/ &
 & 0.58482E+02_JPRB,0.69838E+02_JPRB,0.79175E+02_JPRB,0.76359E+02_JPRB,0.65453E+02_JPRB /)  
KB(:, 1,17,13) = (/ &
 & 0.53962E+02_JPRB,0.68666E+02_JPRB,0.76384E+02_JPRB,0.72467E+02_JPRB,0.57058E+02_JPRB /)  
KB(:, 2,17,13) = (/ &
 & 0.53430E+02_JPRB,0.68393E+02_JPRB,0.76843E+02_JPRB,0.73413E+02_JPRB,0.58438E+02_JPRB /)  
KB(:, 3,17,13) = (/ &
 & 0.52920E+02_JPRB,0.68105E+02_JPRB,0.77273E+02_JPRB,0.74323E+02_JPRB,0.59869E+02_JPRB /)  
KB(:, 4,17,13) = (/ &
 & 0.52483E+02_JPRB,0.67847E+02_JPRB,0.77698E+02_JPRB,0.75214E+02_JPRB,0.61307E+02_JPRB /)  
KB(:, 5,17,13) = (/ &
 & 0.52082E+02_JPRB,0.67535E+02_JPRB,0.78034E+02_JPRB,0.76077E+02_JPRB,0.62785E+02_JPRB /)  
KB(:, 1,18,13) = (/ &
 & 0.47235E+02_JPRB,0.65232E+02_JPRB,0.73440E+02_JPRB,0.70305E+02_JPRB,0.53676E+02_JPRB /)  
KB(:, 2,18,13) = (/ &
 & 0.46798E+02_JPRB,0.65205E+02_JPRB,0.74239E+02_JPRB,0.71589E+02_JPRB,0.55262E+02_JPRB /)  
KB(:, 3,18,13) = (/ &
 & 0.46439E+02_JPRB,0.65179E+02_JPRB,0.75037E+02_JPRB,0.72870E+02_JPRB,0.56922E+02_JPRB /)  
KB(:, 4,18,13) = (/ &
 & 0.46165E+02_JPRB,0.65077E+02_JPRB,0.75787E+02_JPRB,0.74113E+02_JPRB,0.58606E+02_JPRB /)  
KB(:, 5,18,13) = (/ &
 & 0.46076E+02_JPRB,0.64950E+02_JPRB,0.76497E+02_JPRB,0.75319E+02_JPRB,0.60364E+02_JPRB /)  
KB(:, 1,19,13) = (/ &
 & 0.40875E+02_JPRB,0.61443E+02_JPRB,0.70167E+02_JPRB,0.67815E+02_JPRB,0.50666E+02_JPRB /)  
KB(:, 2,19,13) = (/ &
 & 0.40599E+02_JPRB,0.61754E+02_JPRB,0.71348E+02_JPRB,0.69451E+02_JPRB,0.52443E+02_JPRB /)  
KB(:, 3,19,13) = (/ &
 & 0.40423E+02_JPRB,0.61971E+02_JPRB,0.72494E+02_JPRB,0.71103E+02_JPRB,0.54265E+02_JPRB /)  
KB(:, 4,19,13) = (/ &
 & 0.40489E+02_JPRB,0.62135E+02_JPRB,0.73624E+02_JPRB,0.72723E+02_JPRB,0.56176E+02_JPRB /)  
KB(:, 5,19,13) = (/ &
 & 0.40909E+02_JPRB,0.62251E+02_JPRB,0.74691E+02_JPRB,0.74287E+02_JPRB,0.58151E+02_JPRB /)  
KB(:, 1,20,13) = (/ &
 & 0.35203E+02_JPRB,0.57554E+02_JPRB,0.66740E+02_JPRB,0.65266E+02_JPRB,0.47986E+02_JPRB /)  
KB(:, 2,20,13) = (/ &
 & 0.35059E+02_JPRB,0.58164E+02_JPRB,0.68281E+02_JPRB,0.67270E+02_JPRB,0.49928E+02_JPRB /)  
KB(:, 3,20,13) = (/ &
 & 0.35179E+02_JPRB,0.58679E+02_JPRB,0.69865E+02_JPRB,0.69298E+02_JPRB,0.51957E+02_JPRB /)  
KB(:, 4,20,13) = (/ &
 & 0.35687E+02_JPRB,0.59136E+02_JPRB,0.71375E+02_JPRB,0.71295E+02_JPRB,0.54068E+02_JPRB /)  
KB(:, 5,20,13) = (/ &
 & 0.36572E+02_JPRB,0.59563E+02_JPRB,0.72814E+02_JPRB,0.73197E+02_JPRB,0.56184E+02_JPRB /)  
KB(:, 1,21,13) = (/ &
 & 0.30294E+02_JPRB,0.53730E+02_JPRB,0.63335E+02_JPRB,0.62843E+02_JPRB,0.45639E+02_JPRB /)  
KB(:, 2,21,13) = (/ &
 & 0.30407E+02_JPRB,0.54622E+02_JPRB,0.65309E+02_JPRB,0.65230E+02_JPRB,0.47736E+02_JPRB /)  
KB(:, 3,21,13) = (/ &
 & 0.30898E+02_JPRB,0.55470E+02_JPRB,0.67283E+02_JPRB,0.67630E+02_JPRB,0.49955E+02_JPRB /)  
KB(:, 4,21,13) = (/ &
 & 0.31814E+02_JPRB,0.56234E+02_JPRB,0.69205E+02_JPRB,0.69979E+02_JPRB,0.52223E+02_JPRB /)  
KB(:, 5,21,13) = (/ &
 & 0.33171E+02_JPRB,0.57002E+02_JPRB,0.70988E+02_JPRB,0.72170E+02_JPRB,0.54507E+02_JPRB /)  
KB(:, 1,22,13) = (/ &
 & 0.26203E+02_JPRB,0.50178E+02_JPRB,0.60369E+02_JPRB,0.60883E+02_JPRB,0.43752E+02_JPRB /)  
KB(:, 2,22,13) = (/ &
 & 0.26668E+02_JPRB,0.51399E+02_JPRB,0.62731E+02_JPRB,0.63628E+02_JPRB,0.46055E+02_JPRB /)  
KB(:, 3,22,13) = (/ &
 & 0.27573E+02_JPRB,0.52567E+02_JPRB,0.65094E+02_JPRB,0.66337E+02_JPRB,0.48427E+02_JPRB /)  
KB(:, 4,22,13) = (/ &
 & 0.28933E+02_JPRB,0.53710E+02_JPRB,0.67379E+02_JPRB,0.68992E+02_JPRB,0.50840E+02_JPRB /)  
KB(:, 5,22,13) = (/ &
 & 0.30713E+02_JPRB,0.54842E+02_JPRB,0.69500E+02_JPRB,0.71453E+02_JPRB,0.53313E+02_JPRB /)  
KB(:, 1,23,13) = (/ &
 & 0.22949E+02_JPRB,0.47062E+02_JPRB,0.57786E+02_JPRB,0.59287E+02_JPRB,0.42207E+02_JPRB /)  
KB(:, 2,23,13) = (/ &
 & 0.23779E+02_JPRB,0.48563E+02_JPRB,0.60567E+02_JPRB,0.62337E+02_JPRB,0.44709E+02_JPRB /)  
KB(:, 3,23,13) = (/ &
 & 0.25087E+02_JPRB,0.50088E+02_JPRB,0.63282E+02_JPRB,0.65361E+02_JPRB,0.47224E+02_JPRB /)  
KB(:, 4,23,13) = (/ &
 & 0.26833E+02_JPRB,0.51601E+02_JPRB,0.65861E+02_JPRB,0.68253E+02_JPRB,0.49790E+02_JPRB /)  
KB(:, 5,23,13) = (/ &
 & 0.28975E+02_JPRB,0.53148E+02_JPRB,0.68312E+02_JPRB,0.70979E+02_JPRB,0.52442E+02_JPRB /)  
KB(:, 1,24,13) = (/ &
 & 0.20450E+02_JPRB,0.44418E+02_JPRB,0.55719E+02_JPRB,0.58070E+02_JPRB,0.41028E+02_JPRB /)  
KB(:, 2,24,13) = (/ &
 & 0.21647E+02_JPRB,0.46218E+02_JPRB,0.58860E+02_JPRB,0.61413E+02_JPRB,0.43697E+02_JPRB /)  
KB(:, 3,24,13) = (/ &
 & 0.23313E+02_JPRB,0.48082E+02_JPRB,0.61856E+02_JPRB,0.64696E+02_JPRB,0.46357E+02_JPRB /)  
KB(:, 4,24,13) = (/ &
 & 0.25383E+02_JPRB,0.49987E+02_JPRB,0.64735E+02_JPRB,0.67792E+02_JPRB,0.49079E+02_JPRB /)  
KB(:, 5,24,13) = (/ &
 & 0.27788E+02_JPRB,0.51882E+02_JPRB,0.67449E+02_JPRB,0.70725E+02_JPRB,0.51885E+02_JPRB /)  
KB(:, 1,25,13) = (/ &
 & 0.18632E+02_JPRB,0.42267E+02_JPRB,0.54194E+02_JPRB,0.57249E+02_JPRB,0.40189E+02_JPRB /)  
KB(:, 2,25,13) = (/ &
 & 0.20151E+02_JPRB,0.44393E+02_JPRB,0.57583E+02_JPRB,0.60858E+02_JPRB,0.43004E+02_JPRB /)  
KB(:, 3,25,13) = (/ &
 & 0.22101E+02_JPRB,0.46593E+02_JPRB,0.60865E+02_JPRB,0.64337E+02_JPRB,0.45809E+02_JPRB /)  
KB(:, 4,25,13) = (/ &
 & 0.24391E+02_JPRB,0.48836E+02_JPRB,0.63984E+02_JPRB,0.67613E+02_JPRB,0.48696E+02_JPRB /)  
KB(:, 5,25,13) = (/ &
 & 0.26959E+02_JPRB,0.50995E+02_JPRB,0.66882E+02_JPRB,0.70682E+02_JPRB,0.51602E+02_JPRB /)  
KB(:, 1,26,13) = (/ &
 & 0.17370E+02_JPRB,0.40657E+02_JPRB,0.53173E+02_JPRB,0.56858E+02_JPRB,0.39692E+02_JPRB /)  
KB(:, 2,26,13) = (/ &
 & 0.19155E+02_JPRB,0.43087E+02_JPRB,0.56801E+02_JPRB,0.60671E+02_JPRB,0.42632E+02_JPRB /)  
KB(:, 3,26,13) = (/ &
 & 0.21292E+02_JPRB,0.45598E+02_JPRB,0.60302E+02_JPRB,0.64290E+02_JPRB,0.45592E+02_JPRB /)  
KB(:, 4,26,13) = (/ &
 & 0.23727E+02_JPRB,0.48098E+02_JPRB,0.63591E+02_JPRB,0.67690E+02_JPRB,0.48603E+02_JPRB /)  
KB(:, 5,26,13) = (/ &
 & 0.26455E+02_JPRB,0.50493E+02_JPRB,0.66616E+02_JPRB,0.70861E+02_JPRB,0.51588E+02_JPRB /)  
KB(:, 1,27,13) = (/ &
 & 0.16499E+02_JPRB,0.39533E+02_JPRB,0.52563E+02_JPRB,0.56787E+02_JPRB,0.39461E+02_JPRB /)  
KB(:, 2,27,13) = (/ &
 & 0.18462E+02_JPRB,0.42240E+02_JPRB,0.56391E+02_JPRB,0.60738E+02_JPRB,0.42525E+02_JPRB /)  
KB(:, 3,27,13) = (/ &
 & 0.20737E+02_JPRB,0.45009E+02_JPRB,0.60060E+02_JPRB,0.64459E+02_JPRB,0.45612E+02_JPRB /)  
KB(:, 4,27,13) = (/ &
 & 0.23336E+02_JPRB,0.47712E+02_JPRB,0.63452E+02_JPRB,0.67944E+02_JPRB,0.48705E+02_JPRB /)  
KB(:, 5,27,13) = (/ &
 & 0.26215E+02_JPRB,0.50322E+02_JPRB,0.66583E+02_JPRB,0.71174E+02_JPRB,0.51756E+02_JPRB /)  
KB(:, 1,28,13) = (/ &
 & 0.15882E+02_JPRB,0.38845E+02_JPRB,0.52318E+02_JPRB,0.56965E+02_JPRB,0.39468E+02_JPRB /)  
KB(:, 2,28,13) = (/ &
 & 0.17994E+02_JPRB,0.41785E+02_JPRB,0.56289E+02_JPRB,0.61007E+02_JPRB,0.42649E+02_JPRB /)  
KB(:, 3,28,13) = (/ &
 & 0.20424E+02_JPRB,0.44749E+02_JPRB,0.60052E+02_JPRB,0.64808E+02_JPRB,0.45826E+02_JPRB /)  
KB(:, 4,28,13) = (/ &
 & 0.23178E+02_JPRB,0.47630E+02_JPRB,0.63526E+02_JPRB,0.68347E+02_JPRB,0.48967E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART31',1,ZHOOK_HANDLE)
END SUBROUTINE PART31


SUBROUTINE PART32

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART32',0,ZHOOK_HANDLE)


KB(:, 5,28,13) = (/ &
 & 0.26217E+02_JPRB,0.50385E+02_JPRB,0.66714E+02_JPRB,0.71584E+02_JPRB,0.52071E+02_JPRB /)  
KB(:, 1,29,13) = (/ &
 & 0.15496E+02_JPRB,0.38533E+02_JPRB,0.52388E+02_JPRB,0.57377E+02_JPRB,0.39687E+02_JPRB /)  
KB(:, 2,29,13) = (/ &
 & 0.17758E+02_JPRB,0.41667E+02_JPRB,0.56458E+02_JPRB,0.61470E+02_JPRB,0.42963E+02_JPRB /)  
KB(:, 3,29,13) = (/ &
 & 0.20345E+02_JPRB,0.44782E+02_JPRB,0.60267E+02_JPRB,0.65320E+02_JPRB,0.46203E+02_JPRB /)  
KB(:, 4,29,13) = (/ &
 & 0.23257E+02_JPRB,0.47788E+02_JPRB,0.63789E+02_JPRB,0.68865E+02_JPRB,0.49378E+02_JPRB /)  
KB(:, 5,29,13) = (/ &
 & 0.26442E+02_JPRB,0.50623E+02_JPRB,0.67004E+02_JPRB,0.72085E+02_JPRB,0.52513E+02_JPRB /)  
KB(:, 1,30,13) = (/ &
 & 0.15305E+02_JPRB,0.38520E+02_JPRB,0.52687E+02_JPRB,0.57942E+02_JPRB,0.40075E+02_JPRB /)  
KB(:, 2,30,13) = (/ &
 & 0.17725E+02_JPRB,0.41787E+02_JPRB,0.56809E+02_JPRB,0.62069E+02_JPRB,0.43408E+02_JPRB /)  
KB(:, 3,30,13) = (/ &
 & 0.20471E+02_JPRB,0.45011E+02_JPRB,0.60646E+02_JPRB,0.65935E+02_JPRB,0.46678E+02_JPRB /)  
KB(:, 4,30,13) = (/ &
 & 0.23532E+02_JPRB,0.48109E+02_JPRB,0.64191E+02_JPRB,0.69457E+02_JPRB,0.49879E+02_JPRB /)  
KB(:, 5,30,13) = (/ &
 & 0.26835E+02_JPRB,0.50980E+02_JPRB,0.67409E+02_JPRB,0.72648E+02_JPRB,0.53041E+02_JPRB /)  
KB(:, 1,31,13) = (/ &
 & 0.15319E+02_JPRB,0.38759E+02_JPRB,0.53187E+02_JPRB,0.58637E+02_JPRB,0.40597E+02_JPRB /)  
KB(:, 2,31,13) = (/ &
 & 0.17890E+02_JPRB,0.42121E+02_JPRB,0.57326E+02_JPRB,0.62778E+02_JPRB,0.43969E+02_JPRB /)  
KB(:, 3,31,13) = (/ &
 & 0.20784E+02_JPRB,0.45419E+02_JPRB,0.61174E+02_JPRB,0.66627E+02_JPRB,0.47246E+02_JPRB /)  
KB(:, 4,31,13) = (/ &
 & 0.23963E+02_JPRB,0.48555E+02_JPRB,0.64709E+02_JPRB,0.70119E+02_JPRB,0.50470E+02_JPRB /)  
KB(:, 5,31,13) = (/ &
 & 0.27377E+02_JPRB,0.51448E+02_JPRB,0.67912E+02_JPRB,0.73265E+02_JPRB,0.53642E+02_JPRB /)  
KB(:, 1,32,13) = (/ &
 & 0.15518E+02_JPRB,0.39176E+02_JPRB,0.53833E+02_JPRB,0.59441E+02_JPRB,0.41231E+02_JPRB /)  
KB(:, 2,32,13) = (/ &
 & 0.18219E+02_JPRB,0.42608E+02_JPRB,0.57967E+02_JPRB,0.63575E+02_JPRB,0.44614E+02_JPRB /)  
KB(:, 3,32,13) = (/ &
 & 0.21240E+02_JPRB,0.45958E+02_JPRB,0.61807E+02_JPRB,0.67376E+02_JPRB,0.47899E+02_JPRB /)  
KB(:, 4,32,13) = (/ &
 & 0.24535E+02_JPRB,0.49103E+02_JPRB,0.65323E+02_JPRB,0.70819E+02_JPRB,0.51129E+02_JPRB /)  
KB(:, 5,32,13) = (/ &
 & 0.28030E+02_JPRB,0.51991E+02_JPRB,0.68477E+02_JPRB,0.73912E+02_JPRB,0.54297E+02_JPRB /)  
KB(:, 1,33,13) = (/ &
 & 0.15857E+02_JPRB,0.39728E+02_JPRB,0.54587E+02_JPRB,0.60326E+02_JPRB,0.41934E+02_JPRB /)  
KB(:, 2,33,13) = (/ &
 & 0.18681E+02_JPRB,0.43207E+02_JPRB,0.58700E+02_JPRB,0.64428E+02_JPRB,0.45312E+02_JPRB /)  
KB(:, 3,33,13) = (/ &
 & 0.21817E+02_JPRB,0.46584E+02_JPRB,0.62510E+02_JPRB,0.68164E+02_JPRB,0.48601E+02_JPRB /)  
KB(:, 4,33,13) = (/ &
 & 0.25208E+02_JPRB,0.49716E+02_JPRB,0.65986E+02_JPRB,0.71546E+02_JPRB,0.51832E+02_JPRB /)  
KB(:, 5,33,13) = (/ &
 & 0.28769E+02_JPRB,0.52588E+02_JPRB,0.69085E+02_JPRB,0.74576E+02_JPRB,0.54996E+02_JPRB /)  
KB(:, 1,34,13) = (/ &
 & 0.16218E+02_JPRB,0.40255E+02_JPRB,0.55264E+02_JPRB,0.61104E+02_JPRB,0.42563E+02_JPRB /)  
KB(:, 2,34,13) = (/ &
 & 0.19136E+02_JPRB,0.43775E+02_JPRB,0.59363E+02_JPRB,0.65173E+02_JPRB,0.45933E+02_JPRB /)  
KB(:, 3,34,13) = (/ &
 & 0.22367E+02_JPRB,0.47148E+02_JPRB,0.63138E+02_JPRB,0.68848E+02_JPRB,0.49223E+02_JPRB /)  
KB(:, 4,34,13) = (/ &
 & 0.25824E+02_JPRB,0.50264E+02_JPRB,0.66569E+02_JPRB,0.72180E+02_JPRB,0.52454E+02_JPRB /)  
KB(:, 5,34,13) = (/ &
 & 0.29432E+02_JPRB,0.53119E+02_JPRB,0.69617E+02_JPRB,0.75149E+02_JPRB,0.55607E+02_JPRB /)  
KB(:, 1,35,13) = (/ &
 & 0.16382E+02_JPRB,0.40509E+02_JPRB,0.55591E+02_JPRB,0.61512E+02_JPRB,0.42891E+02_JPRB /)  
KB(:, 2,35,13) = (/ &
 & 0.19362E+02_JPRB,0.44056E+02_JPRB,0.59682E+02_JPRB,0.65556E+02_JPRB,0.46259E+02_JPRB /)  
KB(:, 3,35,13) = (/ &
 & 0.22646E+02_JPRB,0.47437E+02_JPRB,0.63450E+02_JPRB,0.69212E+02_JPRB,0.49551E+02_JPRB /)  
KB(:, 4,35,13) = (/ &
 & 0.26140E+02_JPRB,0.50553E+02_JPRB,0.66864E+02_JPRB,0.72519E+02_JPRB,0.52785E+02_JPRB /)  
KB(:, 5,35,13) = (/ &
 & 0.29778E+02_JPRB,0.53403E+02_JPRB,0.69889E+02_JPRB,0.75460E+02_JPRB,0.55937E+02_JPRB /)  
KB(:, 1,36,13) = (/ &
 & 0.16282E+02_JPRB,0.40412E+02_JPRB,0.55499E+02_JPRB,0.61489E+02_JPRB,0.42866E+02_JPRB /)  
KB(:, 2,36,13) = (/ &
 & 0.19286E+02_JPRB,0.43996E+02_JPRB,0.59618E+02_JPRB,0.65550E+02_JPRB,0.46244E+02_JPRB /)  
KB(:, 3,36,13) = (/ &
 & 0.22586E+02_JPRB,0.47399E+02_JPRB,0.63406E+02_JPRB,0.69212E+02_JPRB,0.49542E+02_JPRB /)  
KB(:, 4,36,13) = (/ &
 & 0.26096E+02_JPRB,0.50533E+02_JPRB,0.66829E+02_JPRB,0.72526E+02_JPRB,0.52781E+02_JPRB /)  
KB(:, 5,36,13) = (/ &
 & 0.29750E+02_JPRB,0.53407E+02_JPRB,0.69875E+02_JPRB,0.75478E+02_JPRB,0.55943E+02_JPRB /)  
KB(:, 1,37,13) = (/ &
 & 0.15776E+02_JPRB,0.39797E+02_JPRB,0.54788E+02_JPRB,0.60844E+02_JPRB,0.42332E+02_JPRB /)  
KB(:, 2,37,13) = (/ &
 & 0.18757E+02_JPRB,0.43418E+02_JPRB,0.58970E+02_JPRB,0.64965E+02_JPRB,0.45736E+02_JPRB /)  
KB(:, 3,37,13) = (/ &
 & 0.22032E+02_JPRB,0.46879E+02_JPRB,0.62830E+02_JPRB,0.68697E+02_JPRB,0.49053E+02_JPRB /)  
KB(:, 4,37,13) = (/ &
 & 0.25533E+02_JPRB,0.50076E+02_JPRB,0.66324E+02_JPRB,0.72072E+02_JPRB,0.52311E+02_JPRB /)  
KB(:, 5,37,13) = (/ &
 & 0.29180E+02_JPRB,0.52997E+02_JPRB,0.69437E+02_JPRB,0.75080E+02_JPRB,0.55481E+02_JPRB /)  
KB(:, 1,38,13) = (/ &
 & 0.15271E+02_JPRB,0.39166E+02_JPRB,0.54054E+02_JPRB,0.60165E+02_JPRB,0.41777E+02_JPRB /)  
KB(:, 2,38,13) = (/ &
 & 0.18227E+02_JPRB,0.42823E+02_JPRB,0.58302E+02_JPRB,0.64350E+02_JPRB,0.45207E+02_JPRB /)  
KB(:, 3,38,13) = (/ &
 & 0.21473E+02_JPRB,0.46333E+02_JPRB,0.62224E+02_JPRB,0.68144E+02_JPRB,0.48540E+02_JPRB /)  
KB(:, 4,38,13) = (/ &
 & 0.24954E+02_JPRB,0.49588E+02_JPRB,0.65790E+02_JPRB,0.71578E+02_JPRB,0.51811E+02_JPRB /)  
KB(:, 5,38,13) = (/ &
 & 0.28592E+02_JPRB,0.52564E+02_JPRB,0.68973E+02_JPRB,0.74653E+02_JPRB,0.55000E+02_JPRB /)  
KB(:, 1,39,13) = (/ &
 & 0.14788E+02_JPRB,0.38557E+02_JPRB,0.53339E+02_JPRB,0.59493E+02_JPRB,0.41232E+02_JPRB /)  
KB(:, 2,39,13) = (/ &
 & 0.17725E+02_JPRB,0.42239E+02_JPRB,0.57643E+02_JPRB,0.63735E+02_JPRB,0.44689E+02_JPRB /)  
KB(:, 3,39,13) = (/ &
 & 0.20936E+02_JPRB,0.45800E+02_JPRB,0.61629E+02_JPRB,0.67599E+02_JPRB,0.48036E+02_JPRB /)  
KB(:, 4,39,13) = (/ &
 & 0.24393E+02_JPRB,0.49102E+02_JPRB,0.65258E+02_JPRB,0.71089E+02_JPRB,0.51322E+02_JPRB /)  
KB(:, 5,39,13) = (/ &
 & 0.28020E+02_JPRB,0.52130E+02_JPRB,0.68507E+02_JPRB,0.74225E+02_JPRB,0.54528E+02_JPRB /)  
KB(:, 1,40,13) = (/ &
 & 0.14035E+02_JPRB,0.37576E+02_JPRB,0.52178E+02_JPRB,0.58374E+02_JPRB,0.40328E+02_JPRB /)  
KB(:, 2,40,13) = (/ &
 & 0.16933E+02_JPRB,0.41290E+02_JPRB,0.56557E+02_JPRB,0.62694E+02_JPRB,0.43829E+02_JPRB /)  
KB(:, 3,40,13) = (/ &
 & 0.20073E+02_JPRB,0.44909E+02_JPRB,0.60638E+02_JPRB,0.66668E+02_JPRB,0.47203E+02_JPRB /)  
KB(:, 4,40,13) = (/ &
 & 0.23486E+02_JPRB,0.48287E+02_JPRB,0.64365E+02_JPRB,0.70250E+02_JPRB,0.50504E+02_JPRB /)  
KB(:, 5,40,13) = (/ &
 & 0.27084E+02_JPRB,0.51393E+02_JPRB,0.67719E+02_JPRB,0.73485E+02_JPRB,0.53736E+02_JPRB /)  
KB(:, 1,41,13) = (/ &
 & 0.13270E+02_JPRB,0.36551E+02_JPRB,0.50952E+02_JPRB,0.57187E+02_JPRB,0.39381E+02_JPRB /)  
KB(:, 2,41,13) = (/ &
 & 0.16132E+02_JPRB,0.40293E+02_JPRB,0.55396E+02_JPRB,0.61573E+02_JPRB,0.42921E+02_JPRB /)  
KB(:, 3,41,13) = (/ &
 & 0.19195E+02_JPRB,0.43957E+02_JPRB,0.59575E+02_JPRB,0.65658E+02_JPRB,0.46320E+02_JPRB /)  
KB(:, 4,41,13) = (/ &
 & 0.22552E+02_JPRB,0.47415E+02_JPRB,0.63413E+02_JPRB,0.69340E+02_JPRB,0.49639E+02_JPRB /)  
KB(:, 5,41,13) = (/ &
 & 0.26115E+02_JPRB,0.50603E+02_JPRB,0.66868E+02_JPRB,0.72675E+02_JPRB,0.52897E+02_JPRB /)  
KB(:, 1,42,13) = (/ &
 & 0.12533E+02_JPRB,0.35537E+02_JPRB,0.49715E+02_JPRB,0.55979E+02_JPRB,0.38430E+02_JPRB /)  
KB(:, 2,42,13) = (/ &
 & 0.15340E+02_JPRB,0.39292E+02_JPRB,0.54229E+02_JPRB,0.60445E+02_JPRB,0.42004E+02_JPRB /)  
KB(:, 3,42,13) = (/ &
 & 0.18342E+02_JPRB,0.42991E+02_JPRB,0.58494E+02_JPRB,0.64631E+02_JPRB,0.45437E+02_JPRB /)  
KB(:, 4,42,13) = (/ &
 & 0.21634E+02_JPRB,0.46527E+02_JPRB,0.62435E+02_JPRB,0.68417E+02_JPRB,0.48777E+02_JPRB /)  
KB(:, 5,42,13) = (/ &
 & 0.25154E+02_JPRB,0.49791E+02_JPRB,0.65989E+02_JPRB,0.71836E+02_JPRB,0.52054E+02_JPRB /)  
KB(:, 1,43,13) = (/ &
 & 0.11668E+02_JPRB,0.34309E+02_JPRB,0.48203E+02_JPRB,0.54498E+02_JPRB,0.37270E+02_JPRB /)  
KB(:, 2,43,13) = (/ &
 & 0.14402E+02_JPRB,0.38082E+02_JPRB,0.52797E+02_JPRB,0.59048E+02_JPRB,0.40873E+02_JPRB /)  
KB(:, 3,43,13) = (/ &
 & 0.17344E+02_JPRB,0.41812E+02_JPRB,0.57160E+02_JPRB,0.63341E+02_JPRB,0.44355E+02_JPRB /)  
KB(:, 4,43,13) = (/ &
 & 0.20545E+02_JPRB,0.45427E+02_JPRB,0.61209E+02_JPRB,0.67260E+02_JPRB,0.47724E+02_JPRB /)  
KB(:, 5,43,13) = (/ &
 & 0.24007E+02_JPRB,0.48779E+02_JPRB,0.64893E+02_JPRB,0.70794E+02_JPRB,0.51019E+02_JPRB /)  
KB(:, 1,44,13) = (/ &
 & 0.10777E+02_JPRB,0.32982E+02_JPRB,0.46555E+02_JPRB,0.52865E+02_JPRB,0.36017E+02_JPRB /)  
KB(:, 2,44,13) = (/ &
 & 0.13422E+02_JPRB,0.36774E+02_JPRB,0.51234E+02_JPRB,0.57518E+02_JPRB,0.39647E+02_JPRB /)  
KB(:, 3,44,13) = (/ &
 & 0.16301E+02_JPRB,0.40529E+02_JPRB,0.55688E+02_JPRB,0.61909E+02_JPRB,0.43184E+02_JPRB /)  
KB(:, 4,44,13) = (/ &
 & 0.19410E+02_JPRB,0.44205E+02_JPRB,0.59841E+02_JPRB,0.65956E+02_JPRB,0.46575E+02_JPRB /)  
KB(:, 5,44,13) = (/ &
 & 0.22792E+02_JPRB,0.47657E+02_JPRB,0.63668E+02_JPRB,0.69623E+02_JPRB,0.49898E+02_JPRB /)  
KB(:, 1,45,13) = (/ &
 & 0.99376E+01_JPRB,0.31658E+02_JPRB,0.44891E+02_JPRB,0.51201E+02_JPRB,0.34758E+02_JPRB /)  
KB(:, 2,45,13) = (/ &
 & 0.12468E+02_JPRB,0.35468E+02_JPRB,0.49648E+02_JPRB,0.55955E+02_JPRB,0.38412E+02_JPRB /)  
KB(:, 3,45,13) = (/ &
 & 0.15282E+02_JPRB,0.39240E+02_JPRB,0.54182E+02_JPRB,0.60441E+02_JPRB,0.41991E+02_JPRB /)  
KB(:, 4,45,13) = (/ &
 & 0.18307E+02_JPRB,0.42958E+02_JPRB,0.58447E+02_JPRB,0.64617E+02_JPRB,0.45427E+02_JPRB /)  
KB(:, 5,45,13) = (/ &
 & 0.21602E+02_JPRB,0.46508E+02_JPRB,0.62404E+02_JPRB,0.68417E+02_JPRB,0.48775E+02_JPRB /)  
KB(:, 1,46,13) = (/ &
 & 0.90997E+01_JPRB,0.30250E+02_JPRB,0.43114E+02_JPRB,0.49420E+02_JPRB,0.33417E+02_JPRB /)  
KB(:, 2,46,13) = (/ &
 & 0.11497E+02_JPRB,0.34076E+02_JPRB,0.47932E+02_JPRB,0.54263E+02_JPRB,0.37087E+02_JPRB /)  
KB(:, 3,46,13) = (/ &
 & 0.14229E+02_JPRB,0.37865E+02_JPRB,0.52547E+02_JPRB,0.58836E+02_JPRB,0.40705E+02_JPRB /)  
KB(:, 4,46,13) = (/ &
 & 0.17178E+02_JPRB,0.41613E+02_JPRB,0.56930E+02_JPRB,0.63142E+02_JPRB,0.44193E+02_JPRB /)  
KB(:, 5,46,13) = (/ &
 & 0.20366E+02_JPRB,0.45251E+02_JPRB,0.61008E+02_JPRB,0.67091E+02_JPRB,0.47569E+02_JPRB /)  
KB(:, 1,47,13) = (/ &
 & 0.82326E+01_JPRB,0.28698E+02_JPRB,0.41131E+02_JPRB,0.47406E+02_JPRB,0.31895E+02_JPRB /)  
KB(:, 2,47,13) = (/ &
 & 0.10467E+02_JPRB,0.32516E+02_JPRB,0.45987E+02_JPRB,0.52322E+02_JPRB,0.35605E+02_JPRB /)  
KB(:, 3,47,13) = (/ &
 & 0.13084E+02_JPRB,0.36324E+02_JPRB,0.50700E+02_JPRB,0.57015E+02_JPRB,0.39250E+02_JPRB /)  
KB(:, 4,47,13) = (/ &
 & 0.15956E+02_JPRB,0.40097E+02_JPRB,0.55181E+02_JPRB,0.61437E+02_JPRB,0.42802E+02_JPRB /)  
KB(:, 5,47,13) = (/ &
 & 0.19031E+02_JPRB,0.43799E+02_JPRB,0.59396E+02_JPRB,0.65543E+02_JPRB,0.46212E+02_JPRB /)  
KB(:, 1,48,13) = (/ &
 & 0.74393E+01_JPRB,0.27161E+02_JPRB,0.39157E+02_JPRB,0.45343E+02_JPRB,0.30350E+02_JPRB /)  
KB(:, 2,48,13) = (/ &
 & 0.95049E+01_JPRB,0.30953E+02_JPRB,0.44020E+02_JPRB,0.50347E+02_JPRB,0.34113E+02_JPRB /)  
KB(:, 3,48,13) = (/ &
 & 0.11978E+02_JPRB,0.34782E+02_JPRB,0.48813E+02_JPRB,0.55151E+02_JPRB,0.37782E+02_JPRB /)  
KB(:, 4,48,13) = (/ &
 & 0.14764E+02_JPRB,0.38570E+02_JPRB,0.53387E+02_JPRB,0.59681E+02_JPRB,0.41384E+02_JPRB /)  
KB(:, 5,48,13) = (/ &
 & 0.17748E+02_JPRB,0.42312E+02_JPRB,0.57728E+02_JPRB,0.63933E+02_JPRB,0.44844E+02_JPRB /)  
KB(:, 1,49,13) = (/ &
 & 0.67167E+01_JPRB,0.25650E+02_JPRB,0.37197E+02_JPRB,0.43247E+02_JPRB,0.28796E+02_JPRB /)  
KB(:, 2,49,13) = (/ &
 & 0.86101E+01_JPRB,0.29402E+02_JPRB,0.42045E+02_JPRB,0.48354E+02_JPRB,0.32610E+02_JPRB /)  
KB(:, 3,49,13) = (/ &
 & 0.10926E+02_JPRB,0.33234E+02_JPRB,0.46891E+02_JPRB,0.53243E+02_JPRB,0.36305E+02_JPRB /)  
KB(:, 4,49,13) = (/ &
 & 0.13605E+02_JPRB,0.37035E+02_JPRB,0.51562E+02_JPRB,0.57884E+02_JPRB,0.39936E+02_JPRB /)  
KB(:, 5,49,13) = (/ &
 & 0.16513E+02_JPRB,0.40804E+02_JPRB,0.56010E+02_JPRB,0.62260E+02_JPRB,0.43466E+02_JPRB /)  
KB(:, 1,50,13) = (/ &
 & 0.60927E+01_JPRB,0.24264E+02_JPRB,0.35366E+02_JPRB,0.41271E+02_JPRB,0.27331E+02_JPRB /)  
KB(:, 2,50,13) = (/ &
 & 0.78376E+01_JPRB,0.27958E+02_JPRB,0.40194E+02_JPRB,0.46451E+02_JPRB,0.31176E+02_JPRB /)  
KB(:, 3,50,13) = (/ &
 & 0.99975E+01_JPRB,0.31777E+02_JPRB,0.45061E+02_JPRB,0.51408E+02_JPRB,0.34914E+02_JPRB /)  
KB(:, 4,50,13) = (/ &
 & 0.12552E+02_JPRB,0.35595E+02_JPRB,0.49816E+02_JPRB,0.56159E+02_JPRB,0.38569E+02_JPRB /)  
KB(:, 5,50,13) = (/ &
 & 0.15384E+02_JPRB,0.39379E+02_JPRB,0.54352E+02_JPRB,0.60637E+02_JPRB,0.42153E+02_JPRB /)  
KB(:, 1,51,13) = (/ &
 & 0.55303E+01_JPRB,0.22951E+02_JPRB,0.33599E+02_JPRB,0.39341E+02_JPRB,0.25901E+02_JPRB /)  
KB(:, 2,51,13) = (/ &
 & 0.71468E+01_JPRB,0.26574E+02_JPRB,0.38412E+02_JPRB,0.44565E+02_JPRB,0.29771E+02_JPRB /)  
KB(:, 3,51,13) = (/ &
 & 0.91530E+01_JPRB,0.30360E+02_JPRB,0.43274E+02_JPRB,0.49608E+02_JPRB,0.33559E+02_JPRB /)  
KB(:, 4,51,13) = (/ &
 & 0.11570E+02_JPRB,0.34196E+02_JPRB,0.48091E+02_JPRB,0.54457E+02_JPRB,0.37233E+02_JPRB /)  
KB(:, 5,51,13) = (/ &
 & 0.14322E+02_JPRB,0.37996E+02_JPRB,0.52708E+02_JPRB,0.59018E+02_JPRB,0.40851E+02_JPRB /)  
KB(:, 1,52,13) = (/ &
 & 0.50134E+01_JPRB,0.21673E+02_JPRB,0.31833E+02_JPRB,0.37382E+02_JPRB,0.24463E+02_JPRB /)  
KB(:, 2,52,13) = (/ &
 & 0.65135E+01_JPRB,0.25216E+02_JPRB,0.36639E+02_JPRB,0.42658E+02_JPRB,0.28359E+02_JPRB /)  
KB(:, 3,52,13) = (/ &
 & 0.83642E+01_JPRB,0.28959E+02_JPRB,0.41485E+02_JPRB,0.47797E+02_JPRB,0.32187E+02_JPRB /)  
KB(:, 4,52,13) = (/ &
 & 0.10636E+02_JPRB,0.32789E+02_JPRB,0.46344E+02_JPRB,0.52709E+02_JPRB,0.35895E+02_JPRB /)  
KB(:, 5,52,13) = (/ &
 & 0.13285E+02_JPRB,0.36604E+02_JPRB,0.51047E+02_JPRB,0.57380E+02_JPRB,0.39540E+02_JPRB /)  
KB(:, 1,53,13) = (/ &
 & 0.45376E+01_JPRB,0.20438E+02_JPRB,0.30067E+02_JPRB,0.35396E+02_JPRB,0.23001E+02_JPRB /)  
KB(:, 2,53,13) = (/ &
 & 0.59241E+01_JPRB,0.23884E+02_JPRB,0.34872E+02_JPRB,0.40744E+02_JPRB,0.26941E+02_JPRB /)  
KB(:, 3,53,13) = (/ &
 & 0.76354E+01_JPRB,0.27568E+02_JPRB,0.39698E+02_JPRB,0.45939E+02_JPRB,0.30794E+02_JPRB /)  
KB(:, 4,53,13) = (/ &
 & 0.97536E+01_JPRB,0.31378E+02_JPRB,0.44569E+02_JPRB,0.50924E+02_JPRB,0.34545E+02_JPRB /)  
KB(:, 5,53,13) = (/ &
 & 0.12275E+02_JPRB,0.35210E+02_JPRB,0.49348E+02_JPRB,0.55701E+02_JPRB,0.38212E+02_JPRB /)  
KB(:, 1,54,13) = (/ &
 & 0.41389E+01_JPRB,0.19353E+02_JPRB,0.28454E+02_JPRB,0.33563E+02_JPRB,0.21647E+02_JPRB /)  
KB(:, 2,54,13) = (/ &
 & 0.54194E+01_JPRB,0.22692E+02_JPRB,0.33259E+02_JPRB,0.38976E+02_JPRB,0.25632E+02_JPRB /)  
KB(:, 3,54,13) = (/ &
 & 0.70164E+01_JPRB,0.26307E+02_JPRB,0.38072E+02_JPRB,0.44208E+02_JPRB,0.29508E+02_JPRB /)  
KB(:, 4,54,13) = (/ &
 & 0.89936E+01_JPRB,0.30086E+02_JPRB,0.42934E+02_JPRB,0.49276E+02_JPRB,0.33306E+02_JPRB /)  
KB(:, 5,54,13) = (/ &
 & 0.11387E+02_JPRB,0.33931E+02_JPRB,0.47765E+02_JPRB,0.54132E+02_JPRB,0.36987E+02_JPRB /)  
KB(:, 1,55,13) = (/ &
 & 0.37927E+01_JPRB,0.18358E+02_JPRB,0.26927E+02_JPRB,0.31801E+02_JPRB,0.20350E+02_JPRB /)  
KB(:, 2,55,13) = (/ &
 & 0.49755E+01_JPRB,0.21582E+02_JPRB,0.31711E+02_JPRB,0.37250E+02_JPRB,0.24368E+02_JPRB /)  
KB(:, 3,55,13) = (/ &
 & 0.64669E+01_JPRB,0.25119E+02_JPRB,0.36517E+02_JPRB,0.42532E+02_JPRB,0.28268E+02_JPRB /)  
KB(:, 4,55,13) = (/ &
 & 0.83082E+01_JPRB,0.28857E+02_JPRB,0.41362E+02_JPRB,0.47679E+02_JPRB,0.32095E+02_JPRB /)  
KB(:, 5,55,13) = (/ &
 & 0.10573E+02_JPRB,0.32695E+02_JPRB,0.46225E+02_JPRB,0.52593E+02_JPRB,0.35810E+02_JPRB /)  
KB(:, 1,56,13) = (/ &
 & 0.34680E+01_JPRB,0.17374E+02_JPRB,0.25413E+02_JPRB,0.30039E+02_JPRB,0.19069E+02_JPRB /)  
KB(:, 2,56,13) = (/ &
 & 0.45601E+01_JPRB,0.20503E+02_JPRB,0.30163E+02_JPRB,0.35509E+02_JPRB,0.23088E+02_JPRB /)  
KB(:, 3,56,13) = (/ &
 & 0.59518E+01_JPRB,0.23956E+02_JPRB,0.34971E+02_JPRB,0.40858E+02_JPRB,0.27027E+02_JPRB /)  
KB(:, 4,56,13) = (/ &
 & 0.76711E+01_JPRB,0.27642E+02_JPRB,0.39801E+02_JPRB,0.46057E+02_JPRB,0.30878E+02_JPRB /)  
KB(:, 5,56,13) = (/ &
 & 0.98017E+01_JPRB,0.31462E+02_JPRB,0.44674E+02_JPRB,0.51031E+02_JPRB,0.34630E+02_JPRB /)  
KB(:, 1,57,13) = (/ &
 & 0.31571E+01_JPRB,0.16389E+02_JPRB,0.23903E+02_JPRB,0.28270E+02_JPRB,0.17802E+02_JPRB /)  
KB(:, 2,57,13) = (/ &
 & 0.41775E+01_JPRB,0.19466E+02_JPRB,0.28628E+02_JPRB,0.33765E+02_JPRB,0.21796E+02_JPRB /)  
KB(:, 3,57,13) = (/ &
 & 0.54676E+01_JPRB,0.22817E+02_JPRB,0.33433E+02_JPRB,0.39170E+02_JPRB,0.25777E+02_JPRB /)  
KB(:, 4,57,13) = (/ &
 & 0.70767E+01_JPRB,0.26436E+02_JPRB,0.38248E+02_JPRB,0.44404E+02_JPRB,0.29650E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART32',1,ZHOOK_HANDLE)
END SUBROUTINE PART32


SUBROUTINE PART33

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART33',0,ZHOOK_HANDLE)


KB(:, 5,57,13) = (/ &
 & 0.90728E+01_JPRB,0.30224E+02_JPRB,0.43110E+02_JPRB,0.49455E+02_JPRB,0.33445E+02_JPRB /)  
KB(:, 1,58,13) = (/ &
 & 0.28749E+01_JPRB,0.15464E+02_JPRB,0.22485E+02_JPRB,0.26596E+02_JPRB,0.16612E+02_JPRB /)  
KB(:, 2,58,13) = (/ &
 & 0.38438E+01_JPRB,0.18517E+02_JPRB,0.27179E+02_JPRB,0.32099E+02_JPRB,0.20568E+02_JPRB /)  
KB(:, 3,58,13) = (/ &
 & 0.50410E+01_JPRB,0.21758E+02_JPRB,0.31967E+02_JPRB,0.37546E+02_JPRB,0.24584E+02_JPRB /)  
KB(:, 4,58,13) = (/ &
 & 0.65535E+01_JPRB,0.25311E+02_JPRB,0.36779E+02_JPRB,0.42823E+02_JPRB,0.28478E+02_JPRB /)  
KB(:, 5,58,13) = (/ &
 & 0.84187E+01_JPRB,0.29065E+02_JPRB,0.41628E+02_JPRB,0.47951E+02_JPRB,0.32304E+02_JPRB /)  
KB(:, 1,59,13) = (/ &
 & 0.27657E+01_JPRB,0.15098E+02_JPRB,0.21927E+02_JPRB,0.25930E+02_JPRB,0.16137E+02_JPRB /)  
KB(:, 2,59,13) = (/ &
 & 0.37163E+01_JPRB,0.18141E+02_JPRB,0.26603E+02_JPRB,0.31433E+02_JPRB,0.20078E+02_JPRB /)  
KB(:, 3,59,13) = (/ &
 & 0.48770E+01_JPRB,0.21342E+02_JPRB,0.31379E+02_JPRB,0.36884E+02_JPRB,0.24100E+02_JPRB /)  
KB(:, 4,59,13) = (/ &
 & 0.63518E+01_JPRB,0.24865E+02_JPRB,0.36188E+02_JPRB,0.42182E+02_JPRB,0.28007E+02_JPRB /)  
KB(:, 5,59,13) = (/ &
 & 0.81684E+01_JPRB,0.28600E+02_JPRB,0.41035E+02_JPRB,0.47343E+02_JPRB,0.31847E+02_JPRB /)  
KB(:, 1,13,14) = (/ &
 & 0.20563E+03_JPRB,0.16395E+03_JPRB,0.15131E+03_JPRB,0.13928E+03_JPRB,0.17336E+03_JPRB /)  
KB(:, 2,13,14) = (/ &
 & 0.20583E+03_JPRB,0.16346E+03_JPRB,0.15102E+03_JPRB,0.13867E+03_JPRB,0.17209E+03_JPRB /)  
KB(:, 3,13,14) = (/ &
 & 0.20579E+03_JPRB,0.16282E+03_JPRB,0.15051E+03_JPRB,0.13803E+03_JPRB,0.17119E+03_JPRB /)  
KB(:, 4,13,14) = (/ &
 & 0.20538E+03_JPRB,0.16198E+03_JPRB,0.15005E+03_JPRB,0.13746E+03_JPRB,0.17062E+03_JPRB /)  
KB(:, 5,13,14) = (/ &
 & 0.20471E+03_JPRB,0.16100E+03_JPRB,0.14942E+03_JPRB,0.13685E+03_JPRB,0.16998E+03_JPRB /)  
KB(:, 1,14,14) = (/ &
 & 0.21387E+03_JPRB,0.17486E+03_JPRB,0.16410E+03_JPRB,0.14896E+03_JPRB,0.17926E+03_JPRB /)  
KB(:, 2,14,14) = (/ &
 & 0.21398E+03_JPRB,0.17407E+03_JPRB,0.16354E+03_JPRB,0.14849E+03_JPRB,0.17872E+03_JPRB /)  
KB(:, 3,14,14) = (/ &
 & 0.21371E+03_JPRB,0.17306E+03_JPRB,0.16300E+03_JPRB,0.14796E+03_JPRB,0.17838E+03_JPRB /)  
KB(:, 4,14,14) = (/ &
 & 0.21320E+03_JPRB,0.17193E+03_JPRB,0.16238E+03_JPRB,0.14748E+03_JPRB,0.17807E+03_JPRB /)  
KB(:, 5,14,14) = (/ &
 & 0.21239E+03_JPRB,0.17062E+03_JPRB,0.16158E+03_JPRB,0.14661E+03_JPRB,0.17726E+03_JPRB /)  
KB(:, 1,15,14) = (/ &
 & 0.21868E+03_JPRB,0.18392E+03_JPRB,0.17597E+03_JPRB,0.15877E+03_JPRB,0.18409E+03_JPRB /)  
KB(:, 2,15,14) = (/ &
 & 0.21861E+03_JPRB,0.18285E+03_JPRB,0.17533E+03_JPRB,0.15845E+03_JPRB,0.18413E+03_JPRB /)  
KB(:, 3,15,14) = (/ &
 & 0.21838E+03_JPRB,0.18168E+03_JPRB,0.17469E+03_JPRB,0.15814E+03_JPRB,0.18423E+03_JPRB /)  
KB(:, 4,15,14) = (/ &
 & 0.21785E+03_JPRB,0.18028E+03_JPRB,0.17392E+03_JPRB,0.15747E+03_JPRB,0.18391E+03_JPRB /)  
KB(:, 5,15,14) = (/ &
 & 0.21714E+03_JPRB,0.17881E+03_JPRB,0.17281E+03_JPRB,0.15644E+03_JPRB,0.18337E+03_JPRB /)  
KB(:, 1,16,14) = (/ &
 & 0.21989E+03_JPRB,0.19090E+03_JPRB,0.18666E+03_JPRB,0.16823E+03_JPRB,0.18717E+03_JPRB /)  
KB(:, 2,16,14) = (/ &
 & 0.22000E+03_JPRB,0.18989E+03_JPRB,0.18604E+03_JPRB,0.16822E+03_JPRB,0.18797E+03_JPRB /)  
KB(:, 3,16,14) = (/ &
 & 0.21982E+03_JPRB,0.18856E+03_JPRB,0.18533E+03_JPRB,0.16794E+03_JPRB,0.18851E+03_JPRB /)  
KB(:, 4,16,14) = (/ &
 & 0.21954E+03_JPRB,0.18709E+03_JPRB,0.18432E+03_JPRB,0.16715E+03_JPRB,0.18854E+03_JPRB /)  
KB(:, 5,16,14) = (/ &
 & 0.21898E+03_JPRB,0.18542E+03_JPRB,0.18303E+03_JPRB,0.16600E+03_JPRB,0.18839E+03_JPRB /)  
KB(:, 1,17,14) = (/ &
 & 0.21793E+03_JPRB,0.19596E+03_JPRB,0.19603E+03_JPRB,0.17703E+03_JPRB,0.18857E+03_JPRB /)  
KB(:, 2,17,14) = (/ &
 & 0.21821E+03_JPRB,0.19492E+03_JPRB,0.19548E+03_JPRB,0.17725E+03_JPRB,0.19023E+03_JPRB /)  
KB(:, 3,17,14) = (/ &
 & 0.21850E+03_JPRB,0.19369E+03_JPRB,0.19462E+03_JPRB,0.17701E+03_JPRB,0.19133E+03_JPRB /)  
KB(:, 4,17,14) = (/ &
 & 0.21855E+03_JPRB,0.19221E+03_JPRB,0.19343E+03_JPRB,0.17616E+03_JPRB,0.19194E+03_JPRB /)  
KB(:, 5,17,14) = (/ &
 & 0.21839E+03_JPRB,0.19057E+03_JPRB,0.19206E+03_JPRB,0.17490E+03_JPRB,0.19225E+03_JPRB /)  
KB(:, 1,18,14) = (/ &
 & 0.21311E+03_JPRB,0.19935E+03_JPRB,0.20385E+03_JPRB,0.18492E+03_JPRB,0.18864E+03_JPRB /)  
KB(:, 2,18,14) = (/ &
 & 0.21399E+03_JPRB,0.19838E+03_JPRB,0.20339E+03_JPRB,0.18536E+03_JPRB,0.19117E+03_JPRB /)  
KB(:, 3,18,14) = (/ &
 & 0.21477E+03_JPRB,0.19727E+03_JPRB,0.20251E+03_JPRB,0.18517E+03_JPRB,0.19296E+03_JPRB /)  
KB(:, 4,18,14) = (/ &
 & 0.21537E+03_JPRB,0.19602E+03_JPRB,0.20131E+03_JPRB,0.18433E+03_JPRB,0.19426E+03_JPRB /)  
KB(:, 5,18,14) = (/ &
 & 0.21594E+03_JPRB,0.19460E+03_JPRB,0.19989E+03_JPRB,0.18299E+03_JPRB,0.19511E+03_JPRB /)  
KB(:, 1,19,14) = (/ &
 & 0.20628E+03_JPRB,0.20131E+03_JPRB,0.21018E+03_JPRB,0.19181E+03_JPRB,0.18780E+03_JPRB /)  
KB(:, 2,19,14) = (/ &
 & 0.20786E+03_JPRB,0.20061E+03_JPRB,0.20985E+03_JPRB,0.19249E+03_JPRB,0.19117E+03_JPRB /)  
KB(:, 3,19,14) = (/ &
 & 0.20939E+03_JPRB,0.19978E+03_JPRB,0.20915E+03_JPRB,0.19245E+03_JPRB,0.19379E+03_JPRB /)  
KB(:, 4,19,14) = (/ &
 & 0.21078E+03_JPRB,0.19876E+03_JPRB,0.20808E+03_JPRB,0.19159E+03_JPRB,0.19578E+03_JPRB /)  
KB(:, 5,19,14) = (/ &
 & 0.21196E+03_JPRB,0.19762E+03_JPRB,0.20666E+03_JPRB,0.19020E+03_JPRB,0.19726E+03_JPRB /)  
KB(:, 1,20,14) = (/ &
 & 0.19806E+03_JPRB,0.20215E+03_JPRB,0.21525E+03_JPRB,0.19781E+03_JPRB,0.18646E+03_JPRB /)  
KB(:, 2,20,14) = (/ &
 & 0.20054E+03_JPRB,0.20180E+03_JPRB,0.21527E+03_JPRB,0.19874E+03_JPRB,0.19072E+03_JPRB /)  
KB(:, 3,20,14) = (/ &
 & 0.20298E+03_JPRB,0.20132E+03_JPRB,0.21478E+03_JPRB,0.19877E+03_JPRB,0.19413E+03_JPRB /)  
KB(:, 4,20,14) = (/ &
 & 0.20522E+03_JPRB,0.20070E+03_JPRB,0.21384E+03_JPRB,0.19793E+03_JPRB,0.19681E+03_JPRB /)  
KB(:, 5,20,14) = (/ &
 & 0.20725E+03_JPRB,0.19975E+03_JPRB,0.21249E+03_JPRB,0.19659E+03_JPRB,0.19899E+03_JPRB /)  
KB(:, 1,21,14) = (/ &
 & 0.18919E+03_JPRB,0.20217E+03_JPRB,0.21942E+03_JPRB,0.20291E+03_JPRB,0.18499E+03_JPRB /)  
KB(:, 2,21,14) = (/ &
 & 0.19268E+03_JPRB,0.20239E+03_JPRB,0.21974E+03_JPRB,0.20415E+03_JPRB,0.19012E+03_JPRB /)  
KB(:, 3,21,14) = (/ &
 & 0.19609E+03_JPRB,0.20231E+03_JPRB,0.21947E+03_JPRB,0.20425E+03_JPRB,0.19432E+03_JPRB /)  
KB(:, 4,21,14) = (/ &
 & 0.19926E+03_JPRB,0.20201E+03_JPRB,0.21866E+03_JPRB,0.20346E+03_JPRB,0.19770E+03_JPRB /)  
KB(:, 5,21,14) = (/ &
 & 0.20224E+03_JPRB,0.20136E+03_JPRB,0.21742E+03_JPRB,0.20212E+03_JPRB,0.20044E+03_JPRB /)  
KB(:, 1,22,14) = (/ &
 & 0.18064E+03_JPRB,0.20182E+03_JPRB,0.22276E+03_JPRB,0.20740E+03_JPRB,0.18409E+03_JPRB /)  
KB(:, 2,22,14) = (/ &
 & 0.18513E+03_JPRB,0.20253E+03_JPRB,0.22341E+03_JPRB,0.20876E+03_JPRB,0.18988E+03_JPRB /)  
KB(:, 3,22,14) = (/ &
 & 0.18951E+03_JPRB,0.20287E+03_JPRB,0.22329E+03_JPRB,0.20890E+03_JPRB,0.19474E+03_JPRB /)  
KB(:, 4,22,14) = (/ &
 & 0.19368E+03_JPRB,0.20283E+03_JPRB,0.22259E+03_JPRB,0.20812E+03_JPRB,0.19869E+03_JPRB /)  
KB(:, 5,22,14) = (/ &
 & 0.19752E+03_JPRB,0.20248E+03_JPRB,0.22143E+03_JPRB,0.20676E+03_JPRB,0.20185E+03_JPRB /)  
KB(:, 1,23,14) = (/ &
 & 0.17261E+03_JPRB,0.20129E+03_JPRB,0.22560E+03_JPRB,0.21126E+03_JPRB,0.18360E+03_JPRB /)  
KB(:, 2,23,14) = (/ &
 & 0.17813E+03_JPRB,0.20255E+03_JPRB,0.22645E+03_JPRB,0.21277E+03_JPRB,0.18993E+03_JPRB /)  
KB(:, 3,23,14) = (/ &
 & 0.18347E+03_JPRB,0.20322E+03_JPRB,0.22649E+03_JPRB,0.21288E+03_JPRB,0.19534E+03_JPRB /)  
KB(:, 4,23,14) = (/ &
 & 0.18858E+03_JPRB,0.20345E+03_JPRB,0.22593E+03_JPRB,0.21211E+03_JPRB,0.19972E+03_JPRB /)  
KB(:, 5,23,14) = (/ &
 & 0.19325E+03_JPRB,0.20330E+03_JPRB,0.22470E+03_JPRB,0.21066E+03_JPRB,0.20314E+03_JPRB /)  
KB(:, 1,24,14) = (/ &
 & 0.16550E+03_JPRB,0.20079E+03_JPRB,0.22797E+03_JPRB,0.21459E+03_JPRB,0.18352E+03_JPRB /)  
KB(:, 2,24,14) = (/ &
 & 0.17199E+03_JPRB,0.20247E+03_JPRB,0.22899E+03_JPRB,0.21614E+03_JPRB,0.19031E+03_JPRB /)  
KB(:, 3,24,14) = (/ &
 & 0.17829E+03_JPRB,0.20349E+03_JPRB,0.22920E+03_JPRB,0.21621E+03_JPRB,0.19610E+03_JPRB /)  
KB(:, 4,24,14) = (/ &
 & 0.18424E+03_JPRB,0.20395E+03_JPRB,0.22865E+03_JPRB,0.21544E+03_JPRB,0.20080E+03_JPRB /)  
KB(:, 5,24,14) = (/ &
 & 0.18966E+03_JPRB,0.20393E+03_JPRB,0.22735E+03_JPRB,0.21388E+03_JPRB,0.20437E+03_JPRB /)  
KB(:, 1,25,14) = (/ &
 & 0.15949E+03_JPRB,0.20048E+03_JPRB,0.22999E+03_JPRB,0.21758E+03_JPRB,0.18395E+03_JPRB /)  
KB(:, 2,25,14) = (/ &
 & 0.16698E+03_JPRB,0.20247E+03_JPRB,0.23119E+03_JPRB,0.21903E+03_JPRB,0.19108E+03_JPRB /)  
KB(:, 3,25,14) = (/ &
 & 0.17411E+03_JPRB,0.20370E+03_JPRB,0.23144E+03_JPRB,0.21904E+03_JPRB,0.19711E+03_JPRB /)  
KB(:, 4,25,14) = (/ &
 & 0.18088E+03_JPRB,0.20435E+03_JPRB,0.23082E+03_JPRB,0.21817E+03_JPRB,0.20192E+03_JPRB /)  
KB(:, 5,25,14) = (/ &
 & 0.18710E+03_JPRB,0.20450E+03_JPRB,0.22950E+03_JPRB,0.21648E+03_JPRB,0.20559E+03_JPRB /)  
KB(:, 1,26,14) = (/ &
 & 0.15479E+03_JPRB,0.20038E+03_JPRB,0.23181E+03_JPRB,0.22016E+03_JPRB,0.18490E+03_JPRB /)  
KB(:, 2,26,14) = (/ &
 & 0.16322E+03_JPRB,0.20258E+03_JPRB,0.23307E+03_JPRB,0.22145E+03_JPRB,0.19222E+03_JPRB /)  
KB(:, 3,26,14) = (/ &
 & 0.17119E+03_JPRB,0.20401E+03_JPRB,0.23326E+03_JPRB,0.22140E+03_JPRB,0.19831E+03_JPRB /)  
KB(:, 4,26,14) = (/ &
 & 0.17866E+03_JPRB,0.20478E+03_JPRB,0.23259E+03_JPRB,0.22038E+03_JPRB,0.20315E+03_JPRB /)  
KB(:, 5,26,14) = (/ &
 & 0.18553E+03_JPRB,0.20498E+03_JPRB,0.23122E+03_JPRB,0.21854E+03_JPRB,0.20685E+03_JPRB /)  
KB(:, 1,27,14) = (/ &
 & 0.15143E+03_JPRB,0.20049E+03_JPRB,0.23344E+03_JPRB,0.22241E+03_JPRB,0.18615E+03_JPRB /)  
KB(:, 2,27,14) = (/ &
 & 0.16070E+03_JPRB,0.20279E+03_JPRB,0.23465E+03_JPRB,0.22352E+03_JPRB,0.19353E+03_JPRB /)  
KB(:, 3,27,14) = (/ &
 & 0.16932E+03_JPRB,0.20430E+03_JPRB,0.23473E+03_JPRB,0.22331E+03_JPRB,0.19960E+03_JPRB /)  
KB(:, 4,27,14) = (/ &
 & 0.17737E+03_JPRB,0.20518E+03_JPRB,0.23402E+03_JPRB,0.22212E+03_JPRB,0.20440E+03_JPRB /)  
KB(:, 5,27,14) = (/ &
 & 0.18472E+03_JPRB,0.20537E+03_JPRB,0.23257E+03_JPRB,0.22015E+03_JPRB,0.20807E+03_JPRB /)  
KB(:, 1,28,14) = (/ &
 & 0.14935E+03_JPRB,0.20078E+03_JPRB,0.23487E+03_JPRB,0.22436E+03_JPRB,0.18762E+03_JPRB /)  
KB(:, 2,28,14) = (/ &
 & 0.15926E+03_JPRB,0.20312E+03_JPRB,0.23597E+03_JPRB,0.22523E+03_JPRB,0.19491E+03_JPRB /)  
KB(:, 3,28,14) = (/ &
 & 0.16839E+03_JPRB,0.20467E+03_JPRB,0.23597E+03_JPRB,0.22484E+03_JPRB,0.20092E+03_JPRB /)  
KB(:, 4,28,14) = (/ &
 & 0.17687E+03_JPRB,0.20554E+03_JPRB,0.23516E+03_JPRB,0.22345E+03_JPRB,0.20562E+03_JPRB /)  
KB(:, 5,28,14) = (/ &
 & 0.18453E+03_JPRB,0.20570E+03_JPRB,0.23357E+03_JPRB,0.22135E+03_JPRB,0.20921E+03_JPRB /)  
KB(:, 1,29,14) = (/ &
 & 0.14844E+03_JPRB,0.20117E+03_JPRB,0.23614E+03_JPRB,0.22601E+03_JPRB,0.18927E+03_JPRB /)  
KB(:, 2,29,14) = (/ &
 & 0.15878E+03_JPRB,0.20350E+03_JPRB,0.23707E+03_JPRB,0.22664E+03_JPRB,0.19642E+03_JPRB /)  
KB(:, 3,29,14) = (/ &
 & 0.16829E+03_JPRB,0.20505E+03_JPRB,0.23696E+03_JPRB,0.22601E+03_JPRB,0.20229E+03_JPRB /)  
KB(:, 4,29,14) = (/ &
 & 0.17702E+03_JPRB,0.20585E+03_JPRB,0.23602E+03_JPRB,0.22445E+03_JPRB,0.20685E+03_JPRB /)  
KB(:, 5,29,14) = (/ &
 & 0.18487E+03_JPRB,0.20599E+03_JPRB,0.23430E+03_JPRB,0.22220E+03_JPRB,0.21031E+03_JPRB /)  
KB(:, 1,30,14) = (/ &
 & 0.14841E+03_JPRB,0.20165E+03_JPRB,0.23724E+03_JPRB,0.22742E+03_JPRB,0.19101E+03_JPRB /)  
KB(:, 2,30,14) = (/ &
 & 0.15903E+03_JPRB,0.20395E+03_JPRB,0.23798E+03_JPRB,0.22774E+03_JPRB,0.19796E+03_JPRB /)  
KB(:, 3,30,14) = (/ &
 & 0.16878E+03_JPRB,0.20543E+03_JPRB,0.23774E+03_JPRB,0.22689E+03_JPRB,0.20367E+03_JPRB /)  
KB(:, 4,30,14) = (/ &
 & 0.17765E+03_JPRB,0.20614E+03_JPRB,0.23662E+03_JPRB,0.22515E+03_JPRB,0.20804E+03_JPRB /)  
KB(:, 5,30,14) = (/ &
 & 0.18556E+03_JPRB,0.20626E+03_JPRB,0.23478E+03_JPRB,0.22274E+03_JPRB,0.21133E+03_JPRB /)  
KB(:, 1,31,14) = (/ &
 & 0.14910E+03_JPRB,0.20219E+03_JPRB,0.23816E+03_JPRB,0.22857E+03_JPRB,0.19280E+03_JPRB /)  
KB(:, 2,31,14) = (/ &
 & 0.15987E+03_JPRB,0.20442E+03_JPRB,0.23873E+03_JPRB,0.22860E+03_JPRB,0.19955E+03_JPRB /)  
KB(:, 3,31,14) = (/ &
 & 0.16974E+03_JPRB,0.20578E+03_JPRB,0.23830E+03_JPRB,0.22751E+03_JPRB,0.20503E+03_JPRB /)  
KB(:, 4,31,14) = (/ &
 & 0.17870E+03_JPRB,0.20640E+03_JPRB,0.23703E+03_JPRB,0.22559E+03_JPRB,0.20917E+03_JPRB /)  
KB(:, 5,31,14) = (/ &
 & 0.18656E+03_JPRB,0.20647E+03_JPRB,0.23504E+03_JPRB,0.22303E+03_JPRB,0.21232E+03_JPRB /)  
KB(:, 1,32,14) = (/ &
 & 0.15031E+03_JPRB,0.20279E+03_JPRB,0.23897E+03_JPRB,0.22949E+03_JPRB,0.19459E+03_JPRB /)  
KB(:, 2,32,14) = (/ &
 & 0.16119E+03_JPRB,0.20489E+03_JPRB,0.23931E+03_JPRB,0.22922E+03_JPRB,0.20113E+03_JPRB /)  
KB(:, 3,32,14) = (/ &
 & 0.17110E+03_JPRB,0.20610E+03_JPRB,0.23869E+03_JPRB,0.22791E+03_JPRB,0.20634E+03_JPRB /)  
KB(:, 4,32,14) = (/ &
 & 0.18002E+03_JPRB,0.20662E+03_JPRB,0.23723E+03_JPRB,0.22582E+03_JPRB,0.21029E+03_JPRB /)  
KB(:, 5,32,14) = (/ &
 & 0.18777E+03_JPRB,0.20659E+03_JPRB,0.23510E+03_JPRB,0.22308E+03_JPRB,0.21322E+03_JPRB /)  
KB(:, 1,33,14) = (/ &
 & 0.15197E+03_JPRB,0.20341E+03_JPRB,0.23965E+03_JPRB,0.23019E+03_JPRB,0.19639E+03_JPRB /)  
KB(:, 2,33,14) = (/ &
 & 0.16285E+03_JPRB,0.20534E+03_JPRB,0.23976E+03_JPRB,0.22964E+03_JPRB,0.20267E+03_JPRB /)  
KB(:, 3,33,14) = (/ &
 & 0.17270E+03_JPRB,0.20638E+03_JPRB,0.23893E+03_JPRB,0.22811E+03_JPRB,0.20758E+03_JPRB /)  
KB(:, 4,33,14) = (/ &
 & 0.18151E+03_JPRB,0.20680E+03_JPRB,0.23727E+03_JPRB,0.22584E+03_JPRB,0.21132E+03_JPRB /)  
KB(:, 5,33,14) = (/ &
 & 0.18912E+03_JPRB,0.20665E+03_JPRB,0.23500E+03_JPRB,0.22296E+03_JPRB,0.21406E+03_JPRB /)  
KB(:, 1,34,14) = (/ &
 & 0.15352E+03_JPRB,0.20391E+03_JPRB,0.24014E+03_JPRB,0.23069E+03_JPRB,0.19790E+03_JPRB /)  
KB(:, 2,34,14) = (/ &
 & 0.16437E+03_JPRB,0.20566E+03_JPRB,0.24006E+03_JPRB,0.22992E+03_JPRB,0.20396E+03_JPRB /)  
KB(:, 3,34,14) = (/ &
 & 0.17416E+03_JPRB,0.20662E+03_JPRB,0.23907E+03_JPRB,0.22823E+03_JPRB,0.20863E+03_JPRB /)  
KB(:, 4,34,14) = (/ &
 & 0.18285E+03_JPRB,0.20695E+03_JPRB,0.23728E+03_JPRB,0.22580E+03_JPRB,0.21218E+03_JPRB /)  
KB(:, 5,34,14) = (/ &
 & 0.19033E+03_JPRB,0.20667E+03_JPRB,0.23487E+03_JPRB,0.22280E+03_JPRB,0.21474E+03_JPRB /)  
KB(:, 1,35,14) = (/ &
 & 0.15421E+03_JPRB,0.20418E+03_JPRB,0.24052E+03_JPRB,0.23110E+03_JPRB,0.19876E+03_JPRB /)  
KB(:, 2,35,14) = (/ &
 & 0.16507E+03_JPRB,0.20586E+03_JPRB,0.24033E+03_JPRB,0.23020E+03_JPRB,0.20468E+03_JPRB /)  
KB(:, 3,35,14) = (/ &
 & 0.17486E+03_JPRB,0.20677E+03_JPRB,0.23924E+03_JPRB,0.22841E+03_JPRB,0.20923E+03_JPRB /)  
KB(:, 4,35,14) = (/ &
 & 0.18350E+03_JPRB,0.20705E+03_JPRB,0.23737E+03_JPRB,0.22589E+03_JPRB,0.21269E+03_JPRB /)  
KB(:, 5,35,14) = (/ &
 & 0.19094E+03_JPRB,0.20669E+03_JPRB,0.23489E+03_JPRB,0.22281E+03_JPRB,0.21514E+03_JPRB /)  
KB(:, 1,36,14) = (/ &
 & 0.15381E+03_JPRB,0.20424E+03_JPRB,0.24080E+03_JPRB,0.23145E+03_JPRB,0.19888E+03_JPRB /)  
KB(:, 2,36,14) = (/ &
 & 0.16478E+03_JPRB,0.20592E+03_JPRB,0.24060E+03_JPRB,0.23055E+03_JPRB,0.20484E+03_JPRB /)  
KB(:, 3,36,14) = (/ &
 & 0.17464E+03_JPRB,0.20684E+03_JPRB,0.23950E+03_JPRB,0.22874E+03_JPRB,0.20938E+03_JPRB /)  
KB(:, 4,36,14) = (/ &
 & 0.18336E+03_JPRB,0.20715E+03_JPRB,0.23762E+03_JPRB,0.22618E+03_JPRB,0.21284E+03_JPRB /)  
KB(:, 5,36,14) = (/ &
 & 0.19086E+03_JPRB,0.20678E+03_JPRB,0.23514E+03_JPRB,0.22311E+03_JPRB,0.21532E+03_JPRB /)  
KB(:, 1,37,14) = (/ &
 & 0.15177E+03_JPRB,0.20394E+03_JPRB,0.24096E+03_JPRB,0.23178E+03_JPRB,0.19802E+03_JPRB /)  
KB(:, 2,37,14) = (/ &
 & 0.16298E+03_JPRB,0.20578E+03_JPRB,0.24091E+03_JPRB,0.23102E+03_JPRB,0.20416E+03_JPRB /)  
KB(:, 3,37,14) = (/ &
 & 0.17307E+03_JPRB,0.20681E+03_JPRB,0.23994E+03_JPRB,0.22934E+03_JPRB,0.20893E+03_JPRB /)  
KB(:, 4,37,14) = (/ &
 & 0.18204E+03_JPRB,0.20721E+03_JPRB,0.23818E+03_JPRB,0.22688E+03_JPRB,0.21255E+03_JPRB /)  
KB(:, 5,37,14) = (/ &
 & 0.18973E+03_JPRB,0.20695E+03_JPRB,0.23573E+03_JPRB,0.22383E+03_JPRB,0.21516E+03_JPRB /)  
KB(:, 1,38,14) = (/ &
 & 0.14968E+03_JPRB,0.20359E+03_JPRB,0.24104E+03_JPRB,0.23202E+03_JPRB,0.19703E+03_JPRB /)  
KB(:, 2,38,14) = (/ &
 & 0.16113E+03_JPRB,0.20560E+03_JPRB,0.24116E+03_JPRB,0.23143E+03_JPRB,0.20341E+03_JPRB /)  
KB(:, 3,38,14) = (/ &
 & 0.17144E+03_JPRB,0.20674E+03_JPRB,0.24033E+03_JPRB,0.22988E+03_JPRB,0.20838E+03_JPRB /)  
KB(:, 4,38,14) = (/ &
 & 0.18063E+03_JPRB,0.20724E+03_JPRB,0.23866E+03_JPRB,0.22752E+03_JPRB,0.21216E+03_JPRB /)  
KB(:, 5,38,14) = (/ &
 & 0.18855E+03_JPRB,0.20710E+03_JPRB,0.23632E+03_JPRB,0.22453E+03_JPRB,0.21493E+03_JPRB /)  
KB(:, 1,39,14) = (/ &
 & 0.14764E+03_JPRB,0.20322E+03_JPRB,0.24106E+03_JPRB,0.23220E+03_JPRB,0.19604E+03_JPRB /)  
KB(:, 2,39,14) = (/ &
 & 0.15932E+03_JPRB,0.20540E+03_JPRB,0.24137E+03_JPRB,0.23180E+03_JPRB,0.20262E+03_JPRB /)  
KB(:, 3,39,14) = (/ &
 & 0.16984E+03_JPRB,0.20665E+03_JPRB,0.24065E+03_JPRB,0.23036E+03_JPRB,0.20781E+03_JPRB /)  
KB(:, 4,39,14) = (/ &
 & 0.17923E+03_JPRB,0.20725E+03_JPRB,0.23910E+03_JPRB,0.22810E+03_JPRB,0.21175E+03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART33',1,ZHOOK_HANDLE)
END SUBROUTINE PART33


SUBROUTINE PART34

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART34',0,ZHOOK_HANDLE)


KB(:, 5,39,14) = (/ &
 & 0.18737E+03_JPRB,0.20722E+03_JPRB,0.23684E+03_JPRB,0.22517E+03_JPRB,0.21467E+03_JPRB /)  
KB(:, 1,40,14) = (/ &
 & 0.14438E+03_JPRB,0.20254E+03_JPRB,0.24092E+03_JPRB,0.23225E+03_JPRB,0.19425E+03_JPRB /)  
KB(:, 2,40,14) = (/ &
 & 0.15633E+03_JPRB,0.20498E+03_JPRB,0.24152E+03_JPRB,0.23217E+03_JPRB,0.20115E+03_JPRB /)  
KB(:, 3,40,14) = (/ &
 & 0.16718E+03_JPRB,0.20642E+03_JPRB,0.24105E+03_JPRB,0.23096E+03_JPRB,0.20672E+03_JPRB /)  
KB(:, 4,40,14) = (/ &
 & 0.17690E+03_JPRB,0.20720E+03_JPRB,0.23969E+03_JPRB,0.22887E+03_JPRB,0.21093E+03_JPRB /)  
KB(:, 5,40,14) = (/ &
 & 0.18539E+03_JPRB,0.20733E+03_JPRB,0.23758E+03_JPRB,0.22609E+03_JPRB,0.21411E+03_JPRB /)  
KB(:, 1,41,14) = (/ &
 & 0.14093E+03_JPRB,0.20170E+03_JPRB,0.24062E+03_JPRB,0.23214E+03_JPRB,0.19226E+03_JPRB /)  
KB(:, 2,41,14) = (/ &
 & 0.15309E+03_JPRB,0.20441E+03_JPRB,0.24155E+03_JPRB,0.23243E+03_JPRB,0.19951E+03_JPRB /)  
KB(:, 3,41,14) = (/ &
 & 0.16434E+03_JPRB,0.20613E+03_JPRB,0.24136E+03_JPRB,0.23149E+03_JPRB,0.20545E+03_JPRB /)  
KB(:, 4,41,14) = (/ &
 & 0.17439E+03_JPRB,0.20709E+03_JPRB,0.24022E+03_JPRB,0.22963E+03_JPRB,0.21000E+03_JPRB /)  
KB(:, 5,41,14) = (/ &
 & 0.18325E+03_JPRB,0.20739E+03_JPRB,0.23829E+03_JPRB,0.22700E+03_JPRB,0.21344E+03_JPRB /)  
KB(:, 1,42,14) = (/ &
 & 0.13742E+03_JPRB,0.20072E+03_JPRB,0.24018E+03_JPRB,0.23188E+03_JPRB,0.19017E+03_JPRB /)  
KB(:, 2,42,14) = (/ &
 & 0.14987E+03_JPRB,0.20381E+03_JPRB,0.24151E+03_JPRB,0.23260E+03_JPRB,0.19778E+03_JPRB /)  
KB(:, 3,42,14) = (/ &
 & 0.16144E+03_JPRB,0.20580E+03_JPRB,0.24159E+03_JPRB,0.23194E+03_JPRB,0.20408E+03_JPRB /)  
KB(:, 4,42,14) = (/ &
 & 0.17182E+03_JPRB,0.20693E+03_JPRB,0.24068E+03_JPRB,0.23030E+03_JPRB,0.20897E+03_JPRB /)  
KB(:, 5,42,14) = (/ &
 & 0.18101E+03_JPRB,0.20739E+03_JPRB,0.23894E+03_JPRB,0.22785E+03_JPRB,0.21269E+03_JPRB /)  
KB(:, 1,43,14) = (/ &
 & 0.13316E+03_JPRB,0.19946E+03_JPRB,0.23952E+03_JPRB,0.23134E+03_JPRB,0.18746E+03_JPRB /)  
KB(:, 2,43,14) = (/ &
 & 0.14590E+03_JPRB,0.20299E+03_JPRB,0.24131E+03_JPRB,0.23265E+03_JPRB,0.19555E+03_JPRB /)  
KB(:, 3,43,14) = (/ &
 & 0.15782E+03_JPRB,0.20531E+03_JPRB,0.24176E+03_JPRB,0.23237E+03_JPRB,0.20228E+03_JPRB /)  
KB(:, 4,43,14) = (/ &
 & 0.16860E+03_JPRB,0.20666E+03_JPRB,0.24113E+03_JPRB,0.23099E+03_JPRB,0.20761E+03_JPRB /)  
KB(:, 5,43,14) = (/ &
 & 0.17818E+03_JPRB,0.20733E+03_JPRB,0.23964E+03_JPRB,0.22878E+03_JPRB,0.21166E+03_JPRB /)  
KB(:, 1,44,14) = (/ &
 & 0.12851E+03_JPRB,0.19793E+03_JPRB,0.23860E+03_JPRB,0.23051E+03_JPRB,0.18440E+03_JPRB /)  
KB(:, 2,44,14) = (/ &
 & 0.14156E+03_JPRB,0.20195E+03_JPRB,0.24092E+03_JPRB,0.23249E+03_JPRB,0.19298E+03_JPRB /)  
KB(:, 3,44,14) = (/ &
 & 0.15381E+03_JPRB,0.20468E+03_JPRB,0.24182E+03_JPRB,0.23268E+03_JPRB,0.20015E+03_JPRB /)  
KB(:, 4,44,14) = (/ &
 & 0.16494E+03_JPRB,0.20625E+03_JPRB,0.24148E+03_JPRB,0.23163E+03_JPRB,0.20597E+03_JPRB /)  
KB(:, 5,44,14) = (/ &
 & 0.17499E+03_JPRB,0.20719E+03_JPRB,0.24029E+03_JPRB,0.22969E+03_JPRB,0.21043E+03_JPRB /)  
KB(:, 1,45,14) = (/ &
 & 0.12377E+03_JPRB,0.19622E+03_JPRB,0.23745E+03_JPRB,0.22938E+03_JPRB,0.18114E+03_JPRB /)  
KB(:, 2,45,14) = (/ &
 & 0.13713E+03_JPRB,0.20074E+03_JPRB,0.24035E+03_JPRB,0.23210E+03_JPRB,0.19024E+03_JPRB /)  
KB(:, 3,45,14) = (/ &
 & 0.14969E+03_JPRB,0.20389E+03_JPRB,0.24171E+03_JPRB,0.23283E+03_JPRB,0.19787E+03_JPRB /)  
KB(:, 4,45,14) = (/ &
 & 0.16122E+03_JPRB,0.20580E+03_JPRB,0.24172E+03_JPRB,0.23215E+03_JPRB,0.20417E+03_JPRB /)  
KB(:, 5,45,14) = (/ &
 & 0.17169E+03_JPRB,0.20697E+03_JPRB,0.24085E+03_JPRB,0.23051E+03_JPRB,0.20907E+03_JPRB /)  
KB(:, 1,46,14) = (/ &
 & 0.11871E+03_JPRB,0.19418E+03_JPRB,0.23600E+03_JPRB,0.22790E+03_JPRB,0.17747E+03_JPRB /)  
KB(:, 2,46,14) = (/ &
 & 0.13231E+03_JPRB,0.19929E+03_JPRB,0.23954E+03_JPRB,0.23143E+03_JPRB,0.18712E+03_JPRB /)  
KB(:, 3,46,14) = (/ &
 & 0.14514E+03_JPRB,0.20288E+03_JPRB,0.24138E+03_JPRB,0.23280E+03_JPRB,0.19526E+03_JPRB /)  
KB(:, 4,46,14) = (/ &
 & 0.15711E+03_JPRB,0.20523E+03_JPRB,0.24187E+03_JPRB,0.23257E+03_JPRB,0.20207E+03_JPRB /)  
KB(:, 5,46,14) = (/ &
 & 0.16802E+03_JPRB,0.20664E+03_JPRB,0.24132E+03_JPRB,0.23126E+03_JPRB,0.20749E+03_JPRB /)  
KB(:, 1,47,14) = (/ &
 & 0.11295E+03_JPRB,0.19159E+03_JPRB,0.23398E+03_JPRB,0.22588E+03_JPRB,0.17313E+03_JPRB /)  
KB(:, 2,47,14) = (/ &
 & 0.12683E+03_JPRB,0.19741E+03_JPRB,0.23835E+03_JPRB,0.23031E+03_JPRB,0.18342E+03_JPRB /)  
KB(:, 3,47,14) = (/ &
 & 0.13999E+03_JPRB,0.20159E+03_JPRB,0.24085E+03_JPRB,0.23253E+03_JPRB,0.19217E+03_JPRB /)  
KB(:, 4,47,14) = (/ &
 & 0.15234E+03_JPRB,0.20442E+03_JPRB,0.24186E+03_JPRB,0.23286E+03_JPRB,0.19949E+03_JPRB /)  
KB(:, 5,47,14) = (/ &
 & 0.16373E+03_JPRB,0.20618E+03_JPRB,0.24169E+03_JPRB,0.23194E+03_JPRB,0.20549E+03_JPRB /)  
KB(:, 1,48,14) = (/ &
 & 0.10712E+03_JPRB,0.18871E+03_JPRB,0.23159E+03_JPRB,0.22347E+03_JPRB,0.16850E+03_JPRB /)  
KB(:, 2,48,14) = (/ &
 & 0.12124E+03_JPRB,0.19529E+03_JPRB,0.23687E+03_JPRB,0.22882E+03_JPRB,0.17946E+03_JPRB /)  
KB(:, 3,48,14) = (/ &
 & 0.13473E+03_JPRB,0.20007E+03_JPRB,0.24005E+03_JPRB,0.23191E+03_JPRB,0.18883E+03_JPRB /)  
KB(:, 4,48,14) = (/ &
 & 0.14742E+03_JPRB,0.20342E+03_JPRB,0.24164E+03_JPRB,0.23294E+03_JPRB,0.19670E+03_JPRB /)  
KB(:, 5,48,14) = (/ &
 & 0.15928E+03_JPRB,0.20562E+03_JPRB,0.24192E+03_JPRB,0.23247E+03_JPRB,0.20325E+03_JPRB /)  
KB(:, 1,49,14) = (/ &
 & 0.10120E+03_JPRB,0.18550E+03_JPRB,0.22880E+03_JPRB,0.22071E+03_JPRB,0.16363E+03_JPRB /)  
KB(:, 2,49,14) = (/ &
 & 0.11556E+03_JPRB,0.19285E+03_JPRB,0.23504E+03_JPRB,0.22697E+03_JPRB,0.17524E+03_JPRB /)  
KB(:, 3,49,14) = (/ &
 & 0.12932E+03_JPRB,0.19832E+03_JPRB,0.23901E+03_JPRB,0.23097E+03_JPRB,0.18524E+03_JPRB /)  
KB(:, 4,49,14) = (/ &
 & 0.14238E+03_JPRB,0.20226E+03_JPRB,0.24120E+03_JPRB,0.23278E+03_JPRB,0.19370E+03_JPRB /)  
KB(:, 5,49,14) = (/ &
 & 0.15460E+03_JPRB,0.20488E+03_JPRB,0.24199E+03_JPRB,0.23283E+03_JPRB,0.20078E+03_JPRB /)  
KB(:, 1,50,14) = (/ &
 & 0.95603E+02_JPRB,0.18216E+03_JPRB,0.22576E+03_JPRB,0.21768E+03_JPRB,0.15878E+03_JPRB /)  
KB(:, 2,50,14) = (/ &
 & 0.11015E+03_JPRB,0.19031E+03_JPRB,0.23298E+03_JPRB,0.22490E+03_JPRB,0.17105E+03_JPRB /)  
KB(:, 3,50,14) = (/ &
 & 0.12415E+03_JPRB,0.19646E+03_JPRB,0.23775E+03_JPRB,0.22975E+03_JPRB,0.18166E+03_JPRB /)  
KB(:, 4,50,14) = (/ &
 & 0.13752E+03_JPRB,0.20094E+03_JPRB,0.24058E+03_JPRB,0.23236E+03_JPRB,0.19069E+03_JPRB /)  
KB(:, 5,50,14) = (/ &
 & 0.15007E+03_JPRB,0.20403E+03_JPRB,0.24187E+03_JPRB,0.23299E+03_JPRB,0.19826E+03_JPRB /)  
KB(:, 1,51,14) = (/ &
 & 0.90137E+02_JPRB,0.17868E+03_JPRB,0.22240E+03_JPRB,0.21442E+03_JPRB,0.15384E+03_JPRB /)  
KB(:, 2,51,14) = (/ &
 & 0.10484E+03_JPRB,0.18757E+03_JPRB,0.23066E+03_JPRB,0.22258E+03_JPRB,0.16677E+03_JPRB /)  
KB(:, 3,51,14) = (/ &
 & 0.11907E+03_JPRB,0.19442E+03_JPRB,0.23628E+03_JPRB,0.22824E+03_JPRB,0.17796E+03_JPRB /)  
KB(:, 4,51,14) = (/ &
 & 0.13269E+03_JPRB,0.19948E+03_JPRB,0.23976E+03_JPRB,0.23167E+03_JPRB,0.18756E+03_JPRB /)  
KB(:, 5,51,14) = (/ &
 & 0.14552E+03_JPRB,0.20302E+03_JPRB,0.24154E+03_JPRB,0.23296E+03_JPRB,0.19565E+03_JPRB /)  
KB(:, 1,52,14) = (/ &
 & 0.84690E+02_JPRB,0.17496E+03_JPRB,0.21864E+03_JPRB,0.21080E+03_JPRB,0.14862E+03_JPRB /)  
KB(:, 2,52,14) = (/ &
 & 0.99471E+02_JPRB,0.18453E+03_JPRB,0.22798E+03_JPRB,0.21992E+03_JPRB,0.16225E+03_JPRB /)  
KB(:, 3,52,14) = (/ &
 & 0.11391E+03_JPRB,0.19213E+03_JPRB,0.23451E+03_JPRB,0.22644E+03_JPRB,0.17406E+03_JPRB /)  
KB(:, 4,52,14) = (/ &
 & 0.12777E+03_JPRB,0.19781E+03_JPRB,0.23872E+03_JPRB,0.23070E+03_JPRB,0.18424E+03_JPRB /)  
KB(:, 5,52,14) = (/ &
 & 0.14091E+03_JPRB,0.20189E+03_JPRB,0.24107E+03_JPRB,0.23273E+03_JPRB,0.19286E+03_JPRB /)  
KB(:, 1,53,14) = (/ &
 & 0.79262E+02_JPRB,0.17095E+03_JPRB,0.21436E+03_JPRB,0.20681E+03_JPRB,0.14317E+03_JPRB /)  
KB(:, 2,53,14) = (/ &
 & 0.94047E+02_JPRB,0.18126E+03_JPRB,0.22494E+03_JPRB,0.21690E+03_JPRB,0.15748E+03_JPRB /)  
KB(:, 3,53,14) = (/ &
 & 0.10865E+03_JPRB,0.18958E+03_JPRB,0.23241E+03_JPRB,0.22434E+03_JPRB,0.16994E+03_JPRB /)  
KB(:, 4,53,14) = (/ &
 & 0.12274E+03_JPRB,0.19595E+03_JPRB,0.23742E+03_JPRB,0.22941E+03_JPRB,0.18070E+03_JPRB /)  
KB(:, 5,53,14) = (/ &
 & 0.13618E+03_JPRB,0.20056E+03_JPRB,0.24040E+03_JPRB,0.23224E+03_JPRB,0.18988E+03_JPRB /)  
KB(:, 1,54,14) = (/ &
 & 0.74312E+02_JPRB,0.16701E+03_JPRB,0.21000E+03_JPRB,0.20283E+03_JPRB,0.13801E+03_JPRB /)  
KB(:, 2,54,14) = (/ &
 & 0.89059E+02_JPRB,0.17802E+03_JPRB,0.22177E+03_JPRB,0.21381E+03_JPRB,0.15289E+03_JPRB /)  
KB(:, 3,54,14) = (/ &
 & 0.10379E+03_JPRB,0.18701E+03_JPRB,0.23021E+03_JPRB,0.22214E+03_JPRB,0.16595E+03_JPRB /)  
KB(:, 4,54,14) = (/ &
 & 0.11808E+03_JPRB,0.19403E+03_JPRB,0.23602E+03_JPRB,0.22797E+03_JPRB,0.17728E+03_JPRB /)  
KB(:, 5,54,14) = (/ &
 & 0.13174E+03_JPRB,0.19918E+03_JPRB,0.23961E+03_JPRB,0.23155E+03_JPRB,0.18697E+03_JPRB /)  
KB(:, 1,55,14) = (/ &
 & 0.69615E+02_JPRB,0.16296E+03_JPRB,0.20540E+03_JPRB,0.19866E+03_JPRB,0.13288E+03_JPRB /)  
KB(:, 2,55,14) = (/ &
 & 0.84276E+02_JPRB,0.17466E+03_JPRB,0.21835E+03_JPRB,0.21056E+03_JPRB,0.14828E+03_JPRB /)  
KB(:, 3,55,14) = (/ &
 & 0.99066E+02_JPRB,0.18433E+03_JPRB,0.22782E+03_JPRB,0.21977E+03_JPRB,0.16197E+03_JPRB /)  
KB(:, 4,55,14) = (/ &
 & 0.11354E+03_JPRB,0.19199E+03_JPRB,0.23442E+03_JPRB,0.22636E+03_JPRB,0.17383E+03_JPRB /)  
KB(:, 5,55,14) = (/ &
 & 0.12741E+03_JPRB,0.19770E+03_JPRB,0.23866E+03_JPRB,0.23065E+03_JPRB,0.18403E+03_JPRB /)  
KB(:, 1,56,14) = (/ &
 & 0.64944E+02_JPRB,0.15877E+03_JPRB,0.20044E+03_JPRB,0.19421E+03_JPRB,0.12762E+03_JPRB /)  
KB(:, 2,56,14) = (/ &
 & 0.79524E+02_JPRB,0.17114E+03_JPRB,0.21461E+03_JPRB,0.20707E+03_JPRB,0.14351E+03_JPRB /)  
KB(:, 3,56,14) = (/ &
 & 0.94323E+02_JPRB,0.18144E+03_JPRB,0.22514E+03_JPRB,0.21711E+03_JPRB,0.15778E+03_JPRB /)  
KB(:, 4,56,14) = (/ &
 & 0.10894E+03_JPRB,0.18976E+03_JPRB,0.23257E+03_JPRB,0.22452E+03_JPRB,0.17022E+03_JPRB /)  
KB(:, 5,56,14) = (/ &
 & 0.12301E+03_JPRB,0.19605E+03_JPRB,0.23752E+03_JPRB,0.22954E+03_JPRB,0.18094E+03_JPRB /)  
KB(:, 1,57,14) = (/ &
 & 0.60353E+02_JPRB,0.15431E+03_JPRB,0.19514E+03_JPRB,0.18945E+03_JPRB,0.12225E+03_JPRB /)  
KB(:, 2,57,14) = (/ &
 & 0.74815E+02_JPRB,0.16742E+03_JPRB,0.21049E+03_JPRB,0.20329E+03_JPRB,0.13860E+03_JPRB /)  
KB(:, 3,57,14) = (/ &
 & 0.89567E+02_JPRB,0.17837E+03_JPRB,0.22214E+03_JPRB,0.21419E+03_JPRB,0.15343E+03_JPRB /)  
KB(:, 4,57,14) = (/ &
 & 0.10431E+03_JPRB,0.18733E+03_JPRB,0.23050E+03_JPRB,0.22244E+03_JPRB,0.16644E+03_JPRB /)  
KB(:, 5,57,14) = (/ &
 & 0.11856E+03_JPRB,0.19423E+03_JPRB,0.23618E+03_JPRB,0.22816E+03_JPRB,0.17767E+03_JPRB /)  
KB(:, 1,58,14) = (/ &
 & 0.56098E+02_JPRB,0.14991E+03_JPRB,0.18980E+03_JPRB,0.18465E+03_JPRB,0.11706E+03_JPRB /)  
KB(:, 2,58,14) = (/ &
 & 0.70377E+02_JPRB,0.16367E+03_JPRB,0.20622E+03_JPRB,0.19942E+03_JPRB,0.13378E+03_JPRB /)  
KB(:, 3,58,14) = (/ &
 & 0.85049E+02_JPRB,0.17528E+03_JPRB,0.21902E+03_JPRB,0.21119E+03_JPRB,0.14910E+03_JPRB /)  
KB(:, 4,58,14) = (/ &
 & 0.99857E+02_JPRB,0.18482E+03_JPRB,0.22827E+03_JPRB,0.22022E+03_JPRB,0.16268E+03_JPRB /)  
KB(:, 5,58,14) = (/ &
 & 0.11428E+03_JPRB,0.19233E+03_JPRB,0.23470E+03_JPRB,0.22666E+03_JPRB,0.17444E+03_JPRB /)  
KB(:, 1,59,14) = (/ &
 & 0.54418E+02_JPRB,0.14809E+03_JPRB,0.18754E+03_JPRB,0.18261E+03_JPRB,0.11495E+03_JPRB /)  
KB(:, 2,59,14) = (/ &
 & 0.68598E+02_JPRB,0.16210E+03_JPRB,0.20441E+03_JPRB,0.19778E+03_JPRB,0.13180E+03_JPRB /)  
KB(:, 3,59,14) = (/ &
 & 0.83246E+02_JPRB,0.17398E+03_JPRB,0.21768E+03_JPRB,0.20993E+03_JPRB,0.14733E+03_JPRB /)  
KB(:, 4,59,14) = (/ &
 & 0.98055E+02_JPRB,0.18375E+03_JPRB,0.22732E+03_JPRB,0.21927E+03_JPRB,0.16113E+03_JPRB /)  
KB(:, 5,59,14) = (/ &
 & 0.11255E+03_JPRB,0.19153E+03_JPRB,0.23406E+03_JPRB,0.22601E+03_JPRB,0.17310E+03_JPRB /)  
KB(:, 1,13,15) = (/ &
 & 0.40932E+03_JPRB,0.30758E+03_JPRB,0.26133E+03_JPRB,0.32395E+03_JPRB,0.43211E+03_JPRB /)  
KB(:, 2,13,15) = (/ &
 & 0.41123E+03_JPRB,0.30908E+03_JPRB,0.25921E+03_JPRB,0.31805E+03_JPRB,0.42431E+03_JPRB /)  
KB(:, 3,13,15) = (/ &
 & 0.41219E+03_JPRB,0.30983E+03_JPRB,0.25685E+03_JPRB,0.31214E+03_JPRB,0.41639E+03_JPRB /)  
KB(:, 4,13,15) = (/ &
 & 0.41228E+03_JPRB,0.30991E+03_JPRB,0.25419E+03_JPRB,0.30614E+03_JPRB,0.40836E+03_JPRB /)  
KB(:, 5,13,15) = (/ &
 & 0.41130E+03_JPRB,0.30917E+03_JPRB,0.25126E+03_JPRB,0.30055E+03_JPRB,0.40088E+03_JPRB /)  
KB(:, 1,14,15) = (/ &
 & 0.46527E+03_JPRB,0.34966E+03_JPRB,0.29823E+03_JPRB,0.35533E+03_JPRB,0.47402E+03_JPRB /)  
KB(:, 2,14,15) = (/ &
 & 0.46656E+03_JPRB,0.35065E+03_JPRB,0.29540E+03_JPRB,0.34864E+03_JPRB,0.46510E+03_JPRB /)  
KB(:, 3,14,15) = (/ &
 & 0.46685E+03_JPRB,0.35090E+03_JPRB,0.29209E+03_JPRB,0.34189E+03_JPRB,0.45610E+03_JPRB /)  
KB(:, 4,14,15) = (/ &
 & 0.46575E+03_JPRB,0.35012E+03_JPRB,0.28845E+03_JPRB,0.33526E+03_JPRB,0.44716E+03_JPRB /)  
KB(:, 5,14,15) = (/ &
 & 0.46388E+03_JPRB,0.34873E+03_JPRB,0.28457E+03_JPRB,0.32965E+03_JPRB,0.43950E+03_JPRB /)  
KB(:, 1,15,15) = (/ &
 & 0.52376E+03_JPRB,0.39388E+03_JPRB,0.33756E+03_JPRB,0.38636E+03_JPRB,0.51543E+03_JPRB /)  
KB(:, 2,15,15) = (/ &
 & 0.52445E+03_JPRB,0.39416E+03_JPRB,0.33368E+03_JPRB,0.37892E+03_JPRB,0.50548E+03_JPRB /)  
KB(:, 3,15,15) = (/ &
 & 0.52345E+03_JPRB,0.39343E+03_JPRB,0.32922E+03_JPRB,0.37141E+03_JPRB,0.49535E+03_JPRB /)  
KB(:, 4,15,15) = (/ &
 & 0.52134E+03_JPRB,0.39188E+03_JPRB,0.32434E+03_JPRB,0.36468E+03_JPRB,0.48621E+03_JPRB /)  
KB(:, 5,15,15) = (/ &
 & 0.51791E+03_JPRB,0.38933E+03_JPRB,0.31931E+03_JPRB,0.35855E+03_JPRB,0.47766E+03_JPRB /)  
KB(:, 1,16,15) = (/ &
 & 0.58401E+03_JPRB,0.43962E+03_JPRB,0.37845E+03_JPRB,0.41772E+03_JPRB,0.55681E+03_JPRB /)  
KB(:, 2,16,15) = (/ &
 & 0.58308E+03_JPRB,0.43844E+03_JPRB,0.37324E+03_JPRB,0.40927E+03_JPRB,0.54538E+03_JPRB /)  
KB(:, 3,16,15) = (/ &
 & 0.58094E+03_JPRB,0.43662E+03_JPRB,0.36730E+03_JPRB,0.40107E+03_JPRB,0.53429E+03_JPRB /)  
KB(:, 4,16,15) = (/ &
 & 0.57721E+03_JPRB,0.43385E+03_JPRB,0.36102E+03_JPRB,0.39367E+03_JPRB,0.52421E+03_JPRB /)  
KB(:, 5,16,15) = (/ &
 & 0.57218E+03_JPRB,0.43010E+03_JPRB,0.35444E+03_JPRB,0.38654E+03_JPRB,0.51433E+03_JPRB /)  
KB(:, 1,17,15) = (/ &
 & 0.64407E+03_JPRB,0.48569E+03_JPRB,0.41994E+03_JPRB,0.44912E+03_JPRB,0.59692E+03_JPRB /)  
KB(:, 2,17,15) = (/ &
 & 0.64180E+03_JPRB,0.48304E+03_JPRB,0.41300E+03_JPRB,0.43957E+03_JPRB,0.58409E+03_JPRB /)  
KB(:, 3,17,15) = (/ &
 & 0.63774E+03_JPRB,0.47951E+03_JPRB,0.40543E+03_JPRB,0.43048E+03_JPRB,0.57188E+03_JPRB /)  
KB(:, 4,17,15) = (/ &
 & 0.63221E+03_JPRB,0.47511E+03_JPRB,0.39752E+03_JPRB,0.42195E+03_JPRB,0.56041E+03_JPRB /)  
KB(:, 5,17,15) = (/ &
 & 0.62531E+03_JPRB,0.46997E+03_JPRB,0.38917E+03_JPRB,0.41353E+03_JPRB,0.54901E+03_JPRB /)  
KB(:, 1,18,15) = (/ &
 & 0.70302E+03_JPRB,0.53125E+03_JPRB,0.46110E+03_JPRB,0.48015E+03_JPRB,0.63499E+03_JPRB /)  
KB(:, 2,18,15) = (/ &
 & 0.69876E+03_JPRB,0.52681E+03_JPRB,0.45218E+03_JPRB,0.46935E+03_JPRB,0.62082E+03_JPRB /)  
KB(:, 3,18,15) = (/ &
 & 0.69273E+03_JPRB,0.52130E+03_JPRB,0.44272E+03_JPRB,0.45897E+03_JPRB,0.60731E+03_JPRB /)  
KB(:, 4,18,15) = (/ &
 & 0.68529E+03_JPRB,0.51514E+03_JPRB,0.43287E+03_JPRB,0.44907E+03_JPRB,0.59416E+03_JPRB /)  
KB(:, 5,18,15) = (/ &
 & 0.67604E+03_JPRB,0.50804E+03_JPRB,0.42255E+03_JPRB,0.43929E+03_JPRB,0.58117E+03_JPRB /)  
KB(:, 1,19,15) = (/ &
 & 0.75927E+03_JPRB,0.57536E+03_JPRB,0.50097E+03_JPRB,0.51007E+03_JPRB,0.67027E+03_JPRB /)  
KB(:, 2,19,15) = (/ &
 & 0.75290E+03_JPRB,0.56864E+03_JPRB,0.48996E+03_JPRB,0.49791E+03_JPRB,0.65476E+03_JPRB /)  
KB(:, 3,19,15) = (/ &
 & 0.74466E+03_JPRB,0.56117E+03_JPRB,0.47832E+03_JPRB,0.48599E+03_JPRB,0.63995E+03_JPRB /)  
KB(:, 4,19,15) = (/ &
 & 0.73483E+03_JPRB,0.55286E+03_JPRB,0.46627E+03_JPRB,0.47459E+03_JPRB,0.62519E+03_JPRB /)  
KB(:, 5,19,15) = (/ &
 & 0.72353E+03_JPRB,0.54375E+03_JPRB,0.45395E+03_JPRB,0.46331E+03_JPRB,0.61054E+03_JPRB /)  
KB(:, 1,20,15) = (/ &
 & 0.81171E+03_JPRB,0.61670E+03_JPRB,0.53858E+03_JPRB,0.53802E+03_JPRB,0.70226E+03_JPRB /)  
KB(:, 2,20,15) = (/ &
 & 0.80307E+03_JPRB,0.60788E+03_JPRB,0.52517E+03_JPRB,0.52417E+03_JPRB,0.68550E+03_JPRB /)  
KB(:, 3,20,15) = (/ &
 & 0.79257E+03_JPRB,0.59823E+03_JPRB,0.51114E+03_JPRB,0.51080E+03_JPRB,0.66917E+03_JPRB /)  
KB(:, 4,20,15) = (/ &
 & 0.78036E+03_JPRB,0.58759E+03_JPRB,0.49687E+03_JPRB,0.49775E+03_JPRB,0.65285E+03_JPRB /)  
KB(:, 5,20,15) = (/ &
 & 0.76671E+03_JPRB,0.57649E+03_JPRB,0.48237E+03_JPRB,0.48486E+03_JPRB,0.63647E+03_JPRB /)  
KB(:, 1,21,15) = (/ &
 & 0.85929E+03_JPRB,0.65464E+03_JPRB,0.57309E+03_JPRB,0.56354E+03_JPRB,0.73074E+03_JPRB /)  
KB(:, 2,21,15) = (/ &
 & 0.84853E+03_JPRB,0.64350E+03_JPRB,0.55721E+03_JPRB,0.54790E+03_JPRB,0.71267E+03_JPRB /)  
KB(:, 3,21,15) = (/ &
 & 0.83578E+03_JPRB,0.63172E+03_JPRB,0.54090E+03_JPRB,0.53299E+03_JPRB,0.69483E+03_JPRB /)  
KB(:, 4,21,15) = (/ &
 & 0.82132E+03_JPRB,0.61900E+03_JPRB,0.52438E+03_JPRB,0.51831E+03_JPRB,0.67689E+03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART34',1,ZHOOK_HANDLE)
END SUBROUTINE PART34


SUBROUTINE PART35

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART35',0,ZHOOK_HANDLE)


KB(:, 5,21,15) = (/ &
 & 0.80511E+03_JPRB,0.60568E+03_JPRB,0.50774E+03_JPRB,0.50398E+03_JPRB,0.65894E+03_JPRB /)  
KB(:, 1,22,15) = (/ &
 & 0.90088E+03_JPRB,0.68794E+03_JPRB,0.60297E+03_JPRB,0.58517E+03_JPRB,0.75429E+03_JPRB /)  
KB(:, 2,22,15) = (/ &
 & 0.88795E+03_JPRB,0.67453E+03_JPRB,0.58458E+03_JPRB,0.56794E+03_JPRB,0.73512E+03_JPRB /)  
KB(:, 3,22,15) = (/ &
 & 0.87296E+03_JPRB,0.66047E+03_JPRB,0.56607E+03_JPRB,0.55151E+03_JPRB,0.71573E+03_JPRB /)  
KB(:, 4,22,15) = (/ &
 & 0.85602E+03_JPRB,0.64569E+03_JPRB,0.54736E+03_JPRB,0.53534E+03_JPRB,0.69633E+03_JPRB /)  
KB(:, 5,22,15) = (/ &
 & 0.83763E+03_JPRB,0.63042E+03_JPRB,0.52879E+03_JPRB,0.51959E+03_JPRB,0.67694E+03_JPRB /)  
KB(:, 1,23,15) = (/ &
 & 0.93708E+03_JPRB,0.71670E+03_JPRB,0.62868E+03_JPRB,0.60370E+03_JPRB,0.77407E+03_JPRB /)  
KB(:, 2,23,15) = (/ &
 & 0.92204E+03_JPRB,0.70111E+03_JPRB,0.60797E+03_JPRB,0.58479E+03_JPRB,0.75367E+03_JPRB /)  
KB(:, 3,23,15) = (/ &
 & 0.90485E+03_JPRB,0.68501E+03_JPRB,0.58723E+03_JPRB,0.56696E+03_JPRB,0.73284E+03_JPRB /)  
KB(:, 4,23,15) = (/ &
 & 0.88551E+03_JPRB,0.66835E+03_JPRB,0.56656E+03_JPRB,0.54939E+03_JPRB,0.71207E+03_JPRB /)  
KB(:, 5,23,15) = (/ &
 & 0.86499E+03_JPRB,0.65129E+03_JPRB,0.54624E+03_JPRB,0.53240E+03_JPRB,0.69156E+03_JPRB /)  
KB(:, 1,24,15) = (/ &
 & 0.96776E+03_JPRB,0.74092E+03_JPRB,0.64997E+03_JPRB,0.61898E+03_JPRB,0.79010E+03_JPRB /)  
KB(:, 2,24,15) = (/ &
 & 0.95072E+03_JPRB,0.72338E+03_JPRB,0.62717E+03_JPRB,0.59867E+03_JPRB,0.76855E+03_JPRB /)  
KB(:, 3,24,15) = (/ &
 & 0.93122E+03_JPRB,0.70539E+03_JPRB,0.60446E+03_JPRB,0.57944E+03_JPRB,0.74652E+03_JPRB /)  
KB(:, 4,24,15) = (/ &
 & 0.90993E+03_JPRB,0.68704E+03_JPRB,0.58213E+03_JPRB,0.56067E+03_JPRB,0.72451E+03_JPRB /)  
KB(:, 5,24,15) = (/ &
 & 0.88757E+03_JPRB,0.66845E+03_JPRB,0.56030E+03_JPRB,0.54254E+03_JPRB,0.70312E+03_JPRB /)  
KB(:, 1,25,15) = (/ &
 & 0.99329E+03_JPRB,0.76073E+03_JPRB,0.66706E+03_JPRB,0.63101E+03_JPRB,0.80276E+03_JPRB /)  
KB(:, 2,25,15) = (/ &
 & 0.97397E+03_JPRB,0.74138E+03_JPRB,0.64231E+03_JPRB,0.60949E+03_JPRB,0.78003E+03_JPRB /)  
KB(:, 3,25,15) = (/ &
 & 0.95257E+03_JPRB,0.72186E+03_JPRB,0.61798E+03_JPRB,0.58904E+03_JPRB,0.75681E+03_JPRB /)  
KB(:, 4,25,15) = (/ &
 & 0.92942E+03_JPRB,0.70193E+03_JPRB,0.59417E+03_JPRB,0.56923E+03_JPRB,0.73392E+03_JPRB /)  
KB(:, 5,25,15) = (/ &
 & 0.90532E+03_JPRB,0.68191E+03_JPRB,0.57100E+03_JPRB,0.55015E+03_JPRB,0.71169E+03_JPRB /)  
KB(:, 1,26,15) = (/ &
 & 0.10136E+04_JPRB,0.77623E+03_JPRB,0.67983E+03_JPRB,0.63982E+03_JPRB,0.81189E+03_JPRB /)  
KB(:, 2,26,15) = (/ &
 & 0.99212E+03_JPRB,0.75536E+03_JPRB,0.65345E+03_JPRB,0.61726E+03_JPRB,0.78804E+03_JPRB /)  
KB(:, 3,26,15) = (/ &
 & 0.96906E+03_JPRB,0.73441E+03_JPRB,0.62784E+03_JPRB,0.59585E+03_JPRB,0.76400E+03_JPRB /)  
KB(:, 4,26,15) = (/ &
 & 0.94442E+03_JPRB,0.71314E+03_JPRB,0.60278E+03_JPRB,0.57514E+03_JPRB,0.74031E+03_JPRB /)  
KB(:, 5,26,15) = (/ &
 & 0.91870E+03_JPRB,0.69199E+03_JPRB,0.57850E+03_JPRB,0.55532E+03_JPRB,0.71748E+03_JPRB /)  
KB(:, 1,27,15) = (/ &
 & 0.10295E+04_JPRB,0.78816E+03_JPRB,0.68910E+03_JPRB,0.64601E+03_JPRB,0.81822E+03_JPRB /)  
KB(:, 2,27,15) = (/ &
 & 0.10061E+04_JPRB,0.76604E+03_JPRB,0.66144E+03_JPRB,0.62260E+03_JPRB,0.79343E+03_JPRB /)  
KB(:, 3,27,15) = (/ &
 & 0.98153E+03_JPRB,0.74373E+03_JPRB,0.63470E+03_JPRB,0.60041E+03_JPRB,0.76875E+03_JPRB /)  
KB(:, 4,27,15) = (/ &
 & 0.95548E+03_JPRB,0.72130E+03_JPRB,0.60866E+03_JPRB,0.57907E+03_JPRB,0.74456E+03_JPRB /)  
KB(:, 5,27,15) = (/ &
 & 0.92838E+03_JPRB,0.69916E+03_JPRB,0.58347E+03_JPRB,0.55864E+03_JPRB,0.72113E+03_JPRB /)  
KB(:, 1,28,15) = (/ &
 & 0.10413E+04_JPRB,0.79681E+03_JPRB,0.69534E+03_JPRB,0.64995E+03_JPRB,0.82220E+03_JPRB /)  
KB(:, 2,28,15) = (/ &
 & 0.10164E+04_JPRB,0.77357E+03_JPRB,0.66667E+03_JPRB,0.62595E+03_JPRB,0.79680E+03_JPRB /)  
KB(:, 3,28,15) = (/ &
 & 0.99062E+03_JPRB,0.75026E+03_JPRB,0.63903E+03_JPRB,0.60314E+03_JPRB,0.77147E+03_JPRB /)  
KB(:, 4,28,15) = (/ &
 & 0.96323E+03_JPRB,0.72694E+03_JPRB,0.61220E+03_JPRB,0.58130E+03_JPRB,0.74687E+03_JPRB /)  
KB(:, 5,28,15) = (/ &
 & 0.93489E+03_JPRB,0.70393E+03_JPRB,0.58636E+03_JPRB,0.56041E+03_JPRB,0.72308E+03_JPRB /)  
KB(:, 1,29,15) = (/ &
 & 0.10495E+04_JPRB,0.80260E+03_JPRB,0.69878E+03_JPRB,0.65184E+03_JPRB,0.82409E+03_JPRB /)  
KB(:, 2,29,15) = (/ &
 & 0.10235E+04_JPRB,0.77841E+03_JPRB,0.66934E+03_JPRB,0.62739E+03_JPRB,0.79811E+03_JPRB /)  
KB(:, 3,29,15) = (/ &
 & 0.99642E+03_JPRB,0.75425E+03_JPRB,0.64103E+03_JPRB,0.60412E+03_JPRB,0.77230E+03_JPRB /)  
KB(:, 4,29,15) = (/ &
 & 0.96796E+03_JPRB,0.73025E+03_JPRB,0.61357E+03_JPRB,0.58189E+03_JPRB,0.74741E+03_JPRB /)  
KB(:, 5,29,15) = (/ &
 & 0.93857E+03_JPRB,0.70654E+03_JPRB,0.58732E+03_JPRB,0.56077E+03_JPRB,0.72335E+03_JPRB /)  
KB(:, 1,30,15) = (/ &
 & 0.10549E+04_JPRB,0.80614E+03_JPRB,0.70001E+03_JPRB,0.65202E+03_JPRB,0.82418E+03_JPRB /)  
KB(:, 2,30,15) = (/ &
 & 0.10278E+04_JPRB,0.78108E+03_JPRB,0.67004E+03_JPRB,0.62730E+03_JPRB,0.79771E+03_JPRB /)  
KB(:, 3,30,15) = (/ &
 & 0.99966E+03_JPRB,0.75628E+03_JPRB,0.64121E+03_JPRB,0.60374E+03_JPRB,0.77172E+03_JPRB /)  
KB(:, 4,30,15) = (/ &
 & 0.97021E+03_JPRB,0.73170E+03_JPRB,0.61335E+03_JPRB,0.58130E+03_JPRB,0.74664E+03_JPRB /)  
KB(:, 5,30,15) = (/ &
 & 0.94007E+03_JPRB,0.70743E+03_JPRB,0.58676E+03_JPRB,0.55999E+03_JPRB,0.72234E+03_JPRB /)  
KB(:, 1,31,15) = (/ &
 & 0.10577E+04_JPRB,0.80741E+03_JPRB,0.69925E+03_JPRB,0.65081E+03_JPRB,0.82281E+03_JPRB /)  
KB(:, 2,31,15) = (/ &
 & 0.10297E+04_JPRB,0.78182E+03_JPRB,0.66894E+03_JPRB,0.62588E+03_JPRB,0.79605E+03_JPRB /)  
KB(:, 3,31,15) = (/ &
 & 0.10005E+04_JPRB,0.75649E+03_JPRB,0.63976E+03_JPRB,0.60219E+03_JPRB,0.76987E+03_JPRB /)  
KB(:, 4,31,15) = (/ &
 & 0.97028E+03_JPRB,0.73149E+03_JPRB,0.61167E+03_JPRB,0.57962E+03_JPRB,0.74468E+03_JPRB /)  
KB(:, 5,31,15) = (/ &
 & 0.93951E+03_JPRB,0.70673E+03_JPRB,0.58494E+03_JPRB,0.55830E+03_JPRB,0.72033E+03_JPRB /)  
KB(:, 1,32,15) = (/ &
 & 0.10585E+04_JPRB,0.80706E+03_JPRB,0.69697E+03_JPRB,0.64853E+03_JPRB,0.82034E+03_JPRB /)  
KB(:, 2,32,15) = (/ &
 & 0.10295E+04_JPRB,0.78094E+03_JPRB,0.66639E+03_JPRB,0.62348E+03_JPRB,0.79329E+03_JPRB /)  
KB(:, 3,32,15) = (/ &
 & 0.99955E+03_JPRB,0.75528E+03_JPRB,0.63700E+03_JPRB,0.59969E+03_JPRB,0.76700E+03_JPRB /)  
KB(:, 4,32,15) = (/ &
 & 0.96864E+03_JPRB,0.72996E+03_JPRB,0.60885E+03_JPRB,0.57712E+03_JPRB,0.74178E+03_JPRB /)  
KB(:, 5,32,15) = (/ &
 & 0.93737E+03_JPRB,0.70488E+03_JPRB,0.58204E+03_JPRB,0.55579E+03_JPRB,0.71738E+03_JPRB /)  
KB(:, 1,33,15) = (/ &
 & 0.10575E+04_JPRB,0.80530E+03_JPRB,0.69345E+03_JPRB,0.64529E+03_JPRB,0.81678E+03_JPRB /)  
KB(:, 2,33,15) = (/ &
 & 0.10278E+04_JPRB,0.77890E+03_JPRB,0.66278E+03_JPRB,0.62027E+03_JPRB,0.78965E+03_JPRB /)  
KB(:, 3,33,15) = (/ &
 & 0.99704E+03_JPRB,0.75290E+03_JPRB,0.63324E+03_JPRB,0.59645E+03_JPRB,0.76337E+03_JPRB /)  
KB(:, 4,33,15) = (/ &
 & 0.96555E+03_JPRB,0.72726E+03_JPRB,0.60509E+03_JPRB,0.57394E+03_JPRB,0.73813E+03_JPRB /)  
KB(:, 5,33,15) = (/ &
 & 0.93393E+03_JPRB,0.70207E+03_JPRB,0.57839E+03_JPRB,0.55267E+03_JPRB,0.71377E+03_JPRB /)  
KB(:, 1,34,15) = (/ &
 & 0.10561E+04_JPRB,0.80340E+03_JPRB,0.69012E+03_JPRB,0.64228E+03_JPRB,0.81344E+03_JPRB /)  
KB(:, 2,34,15) = (/ &
 & 0.10257E+04_JPRB,0.77677E+03_JPRB,0.65936E+03_JPRB,0.61726E+03_JPRB,0.78628E+03_JPRB /)  
KB(:, 3,34,15) = (/ &
 & 0.99442E+03_JPRB,0.75053E+03_JPRB,0.62978E+03_JPRB,0.59351E+03_JPRB,0.76009E+03_JPRB /)  
KB(:, 4,34,15) = (/ &
 & 0.96258E+03_JPRB,0.72472E+03_JPRB,0.60168E+03_JPRB,0.57104E+03_JPRB,0.73478E+03_JPRB /)  
KB(:, 5,34,15) = (/ &
 & 0.93053E+03_JPRB,0.69938E+03_JPRB,0.57499E+03_JPRB,0.54984E+03_JPRB,0.71051E+03_JPRB /)  
KB(:, 1,35,15) = (/ &
 & 0.10564E+04_JPRB,0.80326E+03_JPRB,0.68907E+03_JPRB,0.64121E+03_JPRB,0.81221E+03_JPRB /)  
KB(:, 2,35,15) = (/ &
 & 0.10257E+04_JPRB,0.77646E+03_JPRB,0.65819E+03_JPRB,0.61612E+03_JPRB,0.78498E+03_JPRB /)  
KB(:, 3,35,15) = (/ &
 & 0.99396E+03_JPRB,0.74998E+03_JPRB,0.62850E+03_JPRB,0.59231E+03_JPRB,0.75874E+03_JPRB /)  
KB(:, 4,35,15) = (/ &
 & 0.96182E+03_JPRB,0.72398E+03_JPRB,0.60037E+03_JPRB,0.56987E+03_JPRB,0.73339E+03_JPRB /)  
KB(:, 5,35,15) = (/ &
 & 0.92945E+03_JPRB,0.69852E+03_JPRB,0.57362E+03_JPRB,0.54864E+03_JPRB,0.70910E+03_JPRB /)  
KB(:, 1,36,15) = (/ &
 & 0.10593E+04_JPRB,0.80545E+03_JPRB,0.69086E+03_JPRB,0.64252E+03_JPRB,0.81357E+03_JPRB /)  
KB(:, 2,36,15) = (/ &
 & 0.10283E+04_JPRB,0.77842E+03_JPRB,0.65978E+03_JPRB,0.61726E+03_JPRB,0.78619E+03_JPRB /)  
KB(:, 3,36,15) = (/ &
 & 0.99627E+03_JPRB,0.75174E+03_JPRB,0.62993E+03_JPRB,0.59335E+03_JPRB,0.75988E+03_JPRB /)  
KB(:, 4,36,15) = (/ &
 & 0.96386E+03_JPRB,0.72553E+03_JPRB,0.60161E+03_JPRB,0.57080E+03_JPRB,0.73443E+03_JPRB /)  
KB(:, 5,36,15) = (/ &
 & 0.93134E+03_JPRB,0.69996E+03_JPRB,0.57477E+03_JPRB,0.54947E+03_JPRB,0.71003E+03_JPRB /)  
KB(:, 1,37,15) = (/ &
 & 0.10662E+04_JPRB,0.81134E+03_JPRB,0.69713E+03_JPRB,0.64751E+03_JPRB,0.81885E+03_JPRB /)  
KB(:, 2,37,15) = (/ &
 & 0.10351E+04_JPRB,0.78402E+03_JPRB,0.66565E+03_JPRB,0.62189E+03_JPRB,0.79122E+03_JPRB /)  
KB(:, 3,37,15) = (/ &
 & 0.10030E+04_JPRB,0.75714E+03_JPRB,0.63542E+03_JPRB,0.59764E+03_JPRB,0.76460E+03_JPRB /)  
KB(:, 4,37,15) = (/ &
 & 0.97042E+03_JPRB,0.73071E+03_JPRB,0.60674E+03_JPRB,0.57477E+03_JPRB,0.73895E+03_JPRB /)  
KB(:, 5,37,15) = (/ &
 & 0.93771E+03_JPRB,0.70485E+03_JPRB,0.57959E+03_JPRB,0.55322E+03_JPRB,0.71431E+03_JPRB /)  
KB(:, 1,38,15) = (/ &
 & 0.10729E+04_JPRB,0.81713E+03_JPRB,0.70342E+03_JPRB,0.65252E+03_JPRB,0.82415E+03_JPRB /)  
KB(:, 2,38,15) = (/ &
 & 0.10416E+04_JPRB,0.78952E+03_JPRB,0.67152E+03_JPRB,0.62655E+03_JPRB,0.79626E+03_JPRB /)  
KB(:, 3,38,15) = (/ &
 & 0.10096E+04_JPRB,0.76249E+03_JPRB,0.64098E+03_JPRB,0.60198E+03_JPRB,0.76937E+03_JPRB /)  
KB(:, 4,38,15) = (/ &
 & 0.97695E+03_JPRB,0.73588E+03_JPRB,0.61197E+03_JPRB,0.57883E+03_JPRB,0.74352E+03_JPRB /)  
KB(:, 5,38,15) = (/ &
 & 0.94411E+03_JPRB,0.70978E+03_JPRB,0.58447E+03_JPRB,0.55704E+03_JPRB,0.71866E+03_JPRB /)  
KB(:, 1,39,15) = (/ &
 & 0.10791E+04_JPRB,0.82257E+03_JPRB,0.70938E+03_JPRB,0.65729E+03_JPRB,0.82913E+03_JPRB /)  
KB(:, 2,39,15) = (/ &
 & 0.10479E+04_JPRB,0.79481E+03_JPRB,0.67717E+03_JPRB,0.63099E+03_JPRB,0.80105E+03_JPRB /)  
KB(:, 3,39,15) = (/ &
 & 0.10158E+04_JPRB,0.76754E+03_JPRB,0.64630E+03_JPRB,0.60614E+03_JPRB,0.77394E+03_JPRB /)  
KB(:, 4,39,15) = (/ &
 & 0.98307E+03_JPRB,0.74076E+03_JPRB,0.61694E+03_JPRB,0.58271E+03_JPRB,0.74789E+03_JPRB /)  
KB(:, 5,39,15) = (/ &
 & 0.95013E+03_JPRB,0.71446E+03_JPRB,0.58917E+03_JPRB,0.56072E+03_JPRB,0.72285E+03_JPRB /)  
KB(:, 1,40,15) = (/ &
 & 0.10882E+04_JPRB,0.83071E+03_JPRB,0.71862E+03_JPRB,0.66478E+03_JPRB,0.83689E+03_JPRB /)  
KB(:, 2,40,15) = (/ &
 & 0.10571E+04_JPRB,0.80265E+03_JPRB,0.68589E+03_JPRB,0.63804E+03_JPRB,0.80862E+03_JPRB /)  
KB(:, 3,40,15) = (/ &
 & 0.10251E+04_JPRB,0.77527E+03_JPRB,0.65462E+03_JPRB,0.61278E+03_JPRB,0.78119E+03_JPRB /)  
KB(:, 4,40,15) = (/ &
 & 0.99232E+03_JPRB,0.74818E+03_JPRB,0.62475E+03_JPRB,0.58893E+03_JPRB,0.75487E+03_JPRB /)  
KB(:, 5,40,15) = (/ &
 & 0.95932E+03_JPRB,0.72168E+03_JPRB,0.59655E+03_JPRB,0.56653E+03_JPRB,0.72946E+03_JPRB /)  
KB(:, 1,41,15) = (/ &
 & 0.10971E+04_JPRB,0.83901E+03_JPRB,0.72823E+03_JPRB,0.67265E+03_JPRB,0.84493E+03_JPRB /)  
KB(:, 2,41,15) = (/ &
 & 0.10663E+04_JPRB,0.81071E+03_JPRB,0.69500E+03_JPRB,0.64543E+03_JPRB,0.81648E+03_JPRB /)  
KB(:, 3,41,15) = (/ &
 & 0.10345E+04_JPRB,0.78315E+03_JPRB,0.66331E+03_JPRB,0.61971E+03_JPRB,0.78878E+03_JPRB /)  
KB(:, 4,41,15) = (/ &
 & 0.10019E+04_JPRB,0.75590E+03_JPRB,0.63295E+03_JPRB,0.59541E+03_JPRB,0.76210E+03_JPRB /)  
KB(:, 5,41,15) = (/ &
 & 0.96878E+03_JPRB,0.72921E+03_JPRB,0.60428E+03_JPRB,0.57260E+03_JPRB,0.73637E+03_JPRB /)  
KB(:, 1,42,15) = (/ &
 & 0.11058E+04_JPRB,0.84736E+03_JPRB,0.73795E+03_JPRB,0.68059E+03_JPRB,0.85278E+03_JPRB /)  
KB(:, 2,42,15) = (/ &
 & 0.10754E+04_JPRB,0.81879E+03_JPRB,0.70412E+03_JPRB,0.65281E+03_JPRB,0.82432E+03_JPRB /)  
KB(:, 3,42,15) = (/ &
 & 0.10438E+04_JPRB,0.79093E+03_JPRB,0.67198E+03_JPRB,0.62664E+03_JPRB,0.79629E+03_JPRB /)  
KB(:, 4,42,15) = (/ &
 & 0.10112E+04_JPRB,0.76353E+03_JPRB,0.64116E+03_JPRB,0.60189E+03_JPRB,0.76925E+03_JPRB /)  
KB(:, 5,42,15) = (/ &
 & 0.97804E+03_JPRB,0.73660E+03_JPRB,0.61202E+03_JPRB,0.57870E+03_JPRB,0.74332E+03_JPRB /)  
KB(:, 1,43,15) = (/ &
 & 0.11158E+04_JPRB,0.85717E+03_JPRB,0.74955E+03_JPRB,0.69024E+03_JPRB,0.86217E+03_JPRB /)  
KB(:, 2,43,15) = (/ &
 & 0.10861E+04_JPRB,0.82836E+03_JPRB,0.71518E+03_JPRB,0.66177E+03_JPRB,0.83370E+03_JPRB /)  
KB(:, 3,43,15) = (/ &
 & 0.10546E+04_JPRB,0.80021E+03_JPRB,0.68243E+03_JPRB,0.63507E+03_JPRB,0.80541E+03_JPRB /)  
KB(:, 4,43,15) = (/ &
 & 0.10222E+04_JPRB,0.77261E+03_JPRB,0.65115E+03_JPRB,0.60984E+03_JPRB,0.77795E+03_JPRB /)  
KB(:, 5,43,15) = (/ &
 & 0.98916E+03_JPRB,0.74551E+03_JPRB,0.62143E+03_JPRB,0.58614E+03_JPRB,0.75171E+03_JPRB /)  
KB(:, 1,44,15) = (/ &
 & 0.11264E+04_JPRB,0.86786E+03_JPRB,0.76217E+03_JPRB,0.70088E+03_JPRB,0.87207E+03_JPRB /)  
KB(:, 2,44,15) = (/ &
 & 0.10970E+04_JPRB,0.83855E+03_JPRB,0.72711E+03_JPRB,0.67158E+03_JPRB,0.84381E+03_JPRB /)  
KB(:, 3,44,15) = (/ &
 & 0.10660E+04_JPRB,0.81015E+03_JPRB,0.69375E+03_JPRB,0.64429E+03_JPRB,0.81530E+03_JPRB /)  
KB(:, 4,44,15) = (/ &
 & 0.10339E+04_JPRB,0.78245E+03_JPRB,0.66207E+03_JPRB,0.61859E+03_JPRB,0.78750E+03_JPRB /)  
KB(:, 5,44,15) = (/ &
 & 0.10010E+04_JPRB,0.75506E+03_JPRB,0.63169E+03_JPRB,0.59432E+03_JPRB,0.76086E+03_JPRB /)  
KB(:, 1,45,15) = (/ &
 & 0.11364E+04_JPRB,0.87855E+03_JPRB,0.77494E+03_JPRB,0.71181E+03_JPRB,0.88191E+03_JPRB /)  
KB(:, 2,45,15) = (/ &
 & 0.11078E+04_JPRB,0.84885E+03_JPRB,0.73921E+03_JPRB,0.68154E+03_JPRB,0.85373E+03_JPRB /)  
KB(:, 3,45,15) = (/ &
 & 0.10773E+04_JPRB,0.82021E+03_JPRB,0.70525E+03_JPRB,0.65361E+03_JPRB,0.82516E+03_JPRB /)  
KB(:, 4,45,15) = (/ &
 & 0.10454E+04_JPRB,0.79218E+03_JPRB,0.67305E+03_JPRB,0.62740E+03_JPRB,0.79708E+03_JPRB /)  
KB(:, 5,45,15) = (/ &
 & 0.10127E+04_JPRB,0.76466E+03_JPRB,0.64208E+03_JPRB,0.60256E+03_JPRB,0.76997E+03_JPRB /)  
KB(:, 1,46,15) = (/ &
 & 0.11465E+04_JPRB,0.88995E+03_JPRB,0.78864E+03_JPRB,0.72357E+03_JPRB,0.89218E+03_JPRB /)  
KB(:, 2,46,15) = (/ &
 & 0.11189E+04_JPRB,0.85981E+03_JPRB,0.75227E+03_JPRB,0.69242E+03_JPRB,0.86430E+03_JPRB /)  
KB(:, 3,46,15) = (/ &
 & 0.10889E+04_JPRB,0.83077E+03_JPRB,0.71764E+03_JPRB,0.66370E+03_JPRB,0.83569E+03_JPRB /)  
KB(:, 4,46,15) = (/ &
 & 0.10574E+04_JPRB,0.80253E+03_JPRB,0.68479E+03_JPRB,0.63689E+03_JPRB,0.80730E+03_JPRB /)  
KB(:, 5,46,15) = (/ &
 & 0.10249E+04_JPRB,0.77483E+03_JPRB,0.65332E+03_JPRB,0.61153E+03_JPRB,0.77982E+03_JPRB /)  
KB(:, 1,47,15) = (/ &
 & 0.11573E+04_JPRB,0.90286E+03_JPRB,0.80421E+03_JPRB,0.73669E+03_JPRB,0.90313E+03_JPRB /)  
KB(:, 2,47,15) = (/ &
 & 0.11308E+04_JPRB,0.87219E+03_JPRB,0.76703E+03_JPRB,0.70495E+03_JPRB,0.87583E+03_JPRB /)  
KB(:, 3,47,15) = (/ &
 & 0.11017E+04_JPRB,0.84272E+03_JPRB,0.73168E+03_JPRB,0.67524E+03_JPRB,0.84747E+03_JPRB /)  
KB(:, 4,47,15) = (/ &
 & 0.10706E+04_JPRB,0.81413E+03_JPRB,0.69808E+03_JPRB,0.64772E+03_JPRB,0.81886E+03_JPRB /)  
KB(:, 5,47,15) = (/ &
 & 0.10385E+04_JPRB,0.78623E+03_JPRB,0.66606E+03_JPRB,0.62176E+03_JPRB,0.79095E+03_JPRB /)  
KB(:, 1,48,15) = (/ &
 & 0.11675E+04_JPRB,0.91580E+03_JPRB,0.81991E+03_JPRB,0.74998E+03_JPRB,0.91375E+03_JPRB /)  
KB(:, 2,48,15) = (/ &
 & 0.11421E+04_JPRB,0.88462E+03_JPRB,0.78203E+03_JPRB,0.71783E+03_JPRB,0.88726E+03_JPRB /)  
KB(:, 3,48,15) = (/ &
 & 0.11139E+04_JPRB,0.85471E+03_JPRB,0.74597E+03_JPRB,0.68710E+03_JPRB,0.85917E+03_JPRB /)  
KB(:, 4,48,15) = (/ &
 & 0.10836E+04_JPRB,0.82582E+03_JPRB,0.71165E+03_JPRB,0.65875E+03_JPRB,0.83052E+03_JPRB /)  
KB(:, 5,48,15) = (/ &
 & 0.10518E+04_JPRB,0.79762E+03_JPRB,0.67897E+03_JPRB,0.63216E+03_JPRB,0.80224E+03_JPRB /)  
KB(:, 1,49,15) = (/ &
 & 0.11770E+04_JPRB,0.92887E+03_JPRB,0.83589E+03_JPRB,0.76347E+03_JPRB,0.92401E+03_JPRB /)  
KB(:, 2,49,15) = (/ &
 & 0.11531E+04_JPRB,0.89735E+03_JPRB,0.79736E+03_JPRB,0.73085E+03_JPRB,0.89839E+03_JPRB /)  
KB(:, 3,49,15) = (/ &
 & 0.11259E+04_JPRB,0.86690E+03_JPRB,0.76049E+03_JPRB,0.69928E+03_JPRB,0.87069E+03_JPRB /)  
KB(:, 4,49,15) = (/ &
 & 0.10963E+04_JPRB,0.83754E+03_JPRB,0.72543E+03_JPRB,0.67003E+03_JPRB,0.84223E+03_JPRB /)  
KB(:, 5,49,15) = (/ &
 & 0.10650E+04_JPRB,0.80903E+03_JPRB,0.69202E+03_JPRB,0.64278E+03_JPRB,0.81363E+03_JPRB /)  
KB(:, 1,50,15) = (/ &
 & 0.11850E+04_JPRB,0.94106E+03_JPRB,0.85114E+03_JPRB,0.77623E+03_JPRB,0.93320E+03_JPRB /)  
KB(:, 2,50,15) = (/ &
 & 0.11628E+04_JPRB,0.90935E+03_JPRB,0.81191E+03_JPRB,0.74315E+03_JPRB,0.90846E+03_JPRB /)  
KB(:, 3,50,15) = (/ &
 & 0.11368E+04_JPRB,0.87848E+03_JPRB,0.77441E+03_JPRB,0.71118E+03_JPRB,0.88145E+03_JPRB /)  
KB(:, 4,50,15) = (/ &
 & 0.11080E+04_JPRB,0.84872E+03_JPRB,0.73862E+03_JPRB,0.68089E+03_JPRB,0.85311E+03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART35',1,ZHOOK_HANDLE)
END SUBROUTINE PART35


SUBROUTINE PART36

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART36',0,ZHOOK_HANDLE)


KB(:, 5,50,15) = (/ &
 & 0.10771E+04_JPRB,0.81987E+03_JPRB,0.70453E+03_JPRB,0.65297E+03_JPRB,0.82446E+03_JPRB /)  
KB(:, 1,51,15) = (/ &
 & 0.11923E+04_JPRB,0.95283E+03_JPRB,0.86626E+03_JPRB,0.78865E+03_JPRB,0.94170E+03_JPRB /)  
KB(:, 2,51,15) = (/ &
 & 0.11717E+04_JPRB,0.92110E+03_JPRB,0.82616E+03_JPRB,0.75525E+03_JPRB,0.91794E+03_JPRB /)  
KB(:, 3,51,15) = (/ &
 & 0.11468E+04_JPRB,0.88978E+03_JPRB,0.78804E+03_JPRB,0.72292E+03_JPRB,0.89168E+03_JPRB /)  
KB(:, 4,51,15) = (/ &
 & 0.11189E+04_JPRB,0.85951E+03_JPRB,0.75159E+03_JPRB,0.69174E+03_JPRB,0.86368E+03_JPRB /)  
KB(:, 5,51,15) = (/ &
 & 0.10888E+04_JPRB,0.83043E+03_JPRB,0.71698E+03_JPRB,0.66309E+03_JPRB,0.83504E+03_JPRB /)  
KB(:, 1,52,15) = (/ &
 & 0.11987E+04_JPRB,0.96448E+03_JPRB,0.88155E+03_JPRB,0.80101E+03_JPRB,0.94976E+03_JPRB /)  
KB(:, 2,52,15) = (/ &
 & 0.11799E+04_JPRB,0.93288E+03_JPRB,0.84067E+03_JPRB,0.76742E+03_JPRB,0.92694E+03_JPRB /)  
KB(:, 3,52,15) = (/ &
 & 0.11564E+04_JPRB,0.90125E+03_JPRB,0.80189E+03_JPRB,0.73467E+03_JPRB,0.90155E+03_JPRB /)  
KB(:, 4,52,15) = (/ &
 & 0.11296E+04_JPRB,0.87065E+03_JPRB,0.76482E+03_JPRB,0.70289E+03_JPRB,0.87401E+03_JPRB /)  
KB(:, 5,52,15) = (/ &
 & 0.11001E+04_JPRB,0.84107E+03_JPRB,0.72948E+03_JPRB,0.67337E+03_JPRB,0.84559E+03_JPRB /)  
KB(:, 1,53,15) = (/ &
 & 0.12042E+04_JPRB,0.97597E+03_JPRB,0.89729E+03_JPRB,0.81334E+03_JPRB,0.95716E+03_JPRB /)  
KB(:, 2,53,15) = (/ &
 & 0.11876E+04_JPRB,0.94467E+03_JPRB,0.85557E+03_JPRB,0.77990E+03_JPRB,0.93591E+03_JPRB /)  
KB(:, 3,53,15) = (/ &
 & 0.11657E+04_JPRB,0.91285E+03_JPRB,0.81605E+03_JPRB,0.74663E+03_JPRB,0.91125E+03_JPRB /)  
KB(:, 4,53,15) = (/ &
 & 0.11399E+04_JPRB,0.88179E+03_JPRB,0.77830E+03_JPRB,0.71447E+03_JPRB,0.88437E+03_JPRB /)  
KB(:, 5,53,15) = (/ &
 & 0.11113E+04_JPRB,0.85189E+03_JPRB,0.74233E+03_JPRB,0.68396E+03_JPRB,0.85611E+03_JPRB /)  
KB(:, 1,54,15) = (/ &
 & 0.12085E+04_JPRB,0.98643E+03_JPRB,0.91208E+03_JPRB,0.82462E+03_JPRB,0.96332E+03_JPRB /)  
KB(:, 2,54,15) = (/ &
 & 0.11940E+04_JPRB,0.95533E+03_JPRB,0.86934E+03_JPRB,0.79114E+03_JPRB,0.94342E+03_JPRB /)  
KB(:, 3,54,15) = (/ &
 & 0.11737E+04_JPRB,0.92362E+03_JPRB,0.82909E+03_JPRB,0.75767E+03_JPRB,0.91977E+03_JPRB /)  
KB(:, 4,54,15) = (/ &
 & 0.11490E+04_JPRB,0.89214E+03_JPRB,0.79079E+03_JPRB,0.72522E+03_JPRB,0.89369E+03_JPRB /)  
KB(:, 5,54,15) = (/ &
 & 0.11212E+04_JPRB,0.86180E+03_JPRB,0.75420E+03_JPRB,0.69390E+03_JPRB,0.86571E+03_JPRB /)  
KB(:, 1,55,15) = (/ &
 & 0.12111E+04_JPRB,0.99597E+03_JPRB,0.92635E+03_JPRB,0.83534E+03_JPRB,0.96856E+03_JPRB /)  
KB(:, 2,55,15) = (/ &
 & 0.11993E+04_JPRB,0.96550E+03_JPRB,0.88281E+03_JPRB,0.80196E+03_JPRB,0.95029E+03_JPRB /)  
KB(:, 3,55,15) = (/ &
 & 0.11808E+04_JPRB,0.93390E+03_JPRB,0.84185E+03_JPRB,0.76841E+03_JPRB,0.92774E+03_JPRB /)  
KB(:, 4,55,15) = (/ &
 & 0.11574E+04_JPRB,0.90226E+03_JPRB,0.80305E+03_JPRB,0.73557E+03_JPRB,0.90236E+03_JPRB /)  
KB(:, 5,55,15) = (/ &
 & 0.11305E+04_JPRB,0.87151E+03_JPRB,0.76581E+03_JPRB,0.70377E+03_JPRB,0.87482E+03_JPRB /)  
KB(:, 1,56,15) = (/ &
 & 0.12133E+04_JPRB,0.10055E+04_JPRB,0.94091E+03_JPRB,0.84599E+03_JPRB,0.97308E+03_JPRB /)  
KB(:, 2,56,15) = (/ &
 & 0.12041E+04_JPRB,0.97555E+03_JPRB,0.89660E+03_JPRB,0.81280E+03_JPRB,0.95684E+03_JPRB /)  
KB(:, 3,56,15) = (/ &
 & 0.11875E+04_JPRB,0.94422E+03_JPRB,0.85482E+03_JPRB,0.77921E+03_JPRB,0.93538E+03_JPRB /)  
KB(:, 4,56,15) = (/ &
 & 0.11654E+04_JPRB,0.91235E+03_JPRB,0.81536E+03_JPRB,0.74599E+03_JPRB,0.91077E+03_JPRB /)  
KB(:, 5,56,15) = (/ &
 & 0.11395E+04_JPRB,0.88125E+03_JPRB,0.77756E+03_JPRB,0.71383E+03_JPRB,0.88381E+03_JPRB /)  
KB(:, 1,57,15) = (/ &
 & 0.12144E+04_JPRB,0.10149E+04_JPRB,0.95530E+03_JPRB,0.85635E+03_JPRB,0.97654E+03_JPRB /)  
KB(:, 2,57,15) = (/ &
 & 0.12082E+04_JPRB,0.98553E+03_JPRB,0.91069E+03_JPRB,0.82360E+03_JPRB,0.96286E+03_JPRB /)  
KB(:, 3,57,15) = (/ &
 & 0.11936E+04_JPRB,0.95436E+03_JPRB,0.86797E+03_JPRB,0.78997E+03_JPRB,0.94263E+03_JPRB /)  
KB(:, 4,57,15) = (/ &
 & 0.11730E+04_JPRB,0.92261E+03_JPRB,0.82779E+03_JPRB,0.75653E+03_JPRB,0.91896E+03_JPRB /)  
KB(:, 5,57,15) = (/ &
 & 0.11481E+04_JPRB,0.89107E+03_JPRB,0.78949E+03_JPRB,0.72412E+03_JPRB,0.89274E+03_JPRB /)  
KB(:, 1,58,15) = (/ &
 & 0.12146E+04_JPRB,0.10236E+04_JPRB,0.96889E+03_JPRB,0.86606E+03_JPRB,0.97897E+03_JPRB /)  
KB(:, 2,58,15) = (/ &
 & 0.12111E+04_JPRB,0.99468E+03_JPRB,0.92419E+03_JPRB,0.83372E+03_JPRB,0.96790E+03_JPRB /)  
KB(:, 3,58,15) = (/ &
 & 0.11988E+04_JPRB,0.96400E+03_JPRB,0.88060E+03_JPRB,0.80022E+03_JPRB,0.94932E+03_JPRB /)  
KB(:, 4,58,15) = (/ &
 & 0.11798E+04_JPRB,0.93230E+03_JPRB,0.83979E+03_JPRB,0.76663E+03_JPRB,0.92647E+03_JPRB /)  
KB(:, 5,58,15) = (/ &
 & 0.11561E+04_JPRB,0.90059E+03_JPRB,0.80102E+03_JPRB,0.73388E+03_JPRB,0.90094E+03_JPRB /)  
KB(:, 1,59,15) = (/ &
 & 0.12143E+04_JPRB,0.10270E+04_JPRB,0.97431E+03_JPRB,0.86988E+03_JPRB,0.97963E+03_JPRB /)  
KB(:, 2,59,15) = (/ &
 & 0.12120E+04_JPRB,0.99826E+03_JPRB,0.92964E+03_JPRB,0.83774E+03_JPRB,0.96974E+03_JPRB /)  
KB(:, 3,59,15) = (/ &
 & 0.12008E+04_JPRB,0.96785E+03_JPRB,0.88575E+03_JPRB,0.80426E+03_JPRB,0.95182E+03_JPRB /)  
KB(:, 4,59,15) = (/ &
 & 0.11824E+04_JPRB,0.93625E+03_JPRB,0.84468E+03_JPRB,0.77075E+03_JPRB,0.92946E+03_JPRB /)  
KB(:, 5,59,15) = (/ &
 & 0.11592E+04_JPRB,0.90444E+03_JPRB,0.80567E+03_JPRB,0.73781E+03_JPRB,0.90417E+03_JPRB /)  
KB(:, 1,13,16) = (/ &
 & 0.60786E+03_JPRB,0.45592E+03_JPRB,0.38499E+03_JPRB,0.57704E+03_JPRB,0.77025E+03_JPRB /)  
KB(:, 2,13,16) = (/ &
 & 0.61089E+03_JPRB,0.45819E+03_JPRB,0.37289E+03_JPRB,0.55854E+03_JPRB,0.74550E+03_JPRB /)  
KB(:, 3,13,16) = (/ &
 & 0.61169E+03_JPRB,0.45879E+03_JPRB,0.36189E+03_JPRB,0.54102E+03_JPRB,0.72223E+03_JPRB /)  
KB(:, 4,13,16) = (/ &
 & 0.61079E+03_JPRB,0.45811E+03_JPRB,0.35169E+03_JPRB,0.52404E+03_JPRB,0.69950E+03_JPRB /)  
KB(:, 5,13,16) = (/ &
 & 0.60850E+03_JPRB,0.45639E+03_JPRB,0.34199E+03_JPRB,0.50729E+03_JPRB,0.67716E+03_JPRB /)  
KB(:, 1,14,16) = (/ &
 & 0.71905E+03_JPRB,0.53931E+03_JPRB,0.44704E+03_JPRB,0.66948E+03_JPRB,0.89363E+03_JPRB /)  
KB(:, 2,14,16) = (/ &
 & 0.71950E+03_JPRB,0.53965E+03_JPRB,0.43274E+03_JPRB,0.64598E+03_JPRB,0.86230E+03_JPRB /)  
KB(:, 3,14,16) = (/ &
 & 0.71818E+03_JPRB,0.53865E+03_JPRB,0.41969E+03_JPRB,0.62353E+03_JPRB,0.83220E+03_JPRB /)  
KB(:, 4,14,16) = (/ &
 & 0.71532E+03_JPRB,0.53651E+03_JPRB,0.40717E+03_JPRB,0.60193E+03_JPRB,0.80343E+03_JPRB /)  
KB(:, 5,14,16) = (/ &
 & 0.71008E+03_JPRB,0.53258E+03_JPRB,0.39527E+03_JPRB,0.58080E+03_JPRB,0.77521E+03_JPRB /)  
KB(:, 1,15,16) = (/ &
 & 0.84339E+03_JPRB,0.63256E+03_JPRB,0.51534E+03_JPRB,0.76897E+03_JPRB,0.10264E+04_JPRB /)  
KB(:, 2,15,16) = (/ &
 & 0.84056E+03_JPRB,0.63042E+03_JPRB,0.49783E+03_JPRB,0.73927E+03_JPRB,0.98670E+03_JPRB /)  
KB(:, 3,15,16) = (/ &
 & 0.83549E+03_JPRB,0.62663E+03_JPRB,0.48183E+03_JPRB,0.71056E+03_JPRB,0.94836E+03_JPRB /)  
KB(:, 4,15,16) = (/ &
 & 0.82865E+03_JPRB,0.62150E+03_JPRB,0.46649E+03_JPRB,0.68266E+03_JPRB,0.91115E+03_JPRB /)  
KB(:, 5,15,16) = (/ &
 & 0.81975E+03_JPRB,0.61483E+03_JPRB,0.45195E+03_JPRB,0.65670E+03_JPRB,0.87636E+03_JPRB /)  
KB(:, 1,16,16) = (/ &
 & 0.97910E+03_JPRB,0.73434E+03_JPRB,0.58857E+03_JPRB,0.87272E+03_JPRB,0.11648E+04_JPRB /)  
KB(:, 2,16,16) = (/ &
 & 0.97153E+03_JPRB,0.72866E+03_JPRB,0.56721E+03_JPRB,0.83540E+03_JPRB,0.11150E+04_JPRB /)  
KB(:, 3,16,16) = (/ &
 & 0.96129E+03_JPRB,0.72098E+03_JPRB,0.54742E+03_JPRB,0.79937E+03_JPRB,0.10667E+04_JPRB /)  
KB(:, 4,16,16) = (/ &
 & 0.94880E+03_JPRB,0.71161E+03_JPRB,0.52876E+03_JPRB,0.76497E+03_JPRB,0.10209E+04_JPRB /)  
KB(:, 5,16,16) = (/ &
 & 0.93421E+03_JPRB,0.70067E+03_JPRB,0.51082E+03_JPRB,0.73352E+03_JPRB,0.97881E+03_JPRB /)  
KB(:, 1,17,16) = (/ &
 & 0.11229E+04_JPRB,0.84221E+03_JPRB,0.66547E+03_JPRB,0.97911E+03_JPRB,0.13066E+04_JPRB /)  
KB(:, 2,17,16) = (/ &
 & 0.11091E+04_JPRB,0.83187E+03_JPRB,0.63930E+03_JPRB,0.93226E+03_JPRB,0.12440E+04_JPRB /)  
KB(:, 3,17,16) = (/ &
 & 0.10923E+04_JPRB,0.81922E+03_JPRB,0.61539E+03_JPRB,0.88802E+03_JPRB,0.11849E+04_JPRB /)  
KB(:, 4,17,16) = (/ &
 & 0.10728E+04_JPRB,0.80459E+03_JPRB,0.59256E+03_JPRB,0.84691E+03_JPRB,0.11301E+04_JPRB /)  
KB(:, 5,17,16) = (/ &
 & 0.10515E+04_JPRB,0.78865E+03_JPRB,0.57044E+03_JPRB,0.80936E+03_JPRB,0.10799E+04_JPRB /)  
KB(:, 1,18,16) = (/ &
 & 0.12716E+04_JPRB,0.95370E+03_JPRB,0.74447E+03_JPRB,0.10843E+04_JPRB,0.14469E+04_JPRB /)  
KB(:, 2,18,16) = (/ &
 & 0.12500E+04_JPRB,0.93749E+03_JPRB,0.71274E+03_JPRB,0.10272E+04_JPRB,0.13706E+04_JPRB /)  
KB(:, 3,18,16) = (/ &
 & 0.12251E+04_JPRB,0.91883E+03_JPRB,0.68394E+03_JPRB,0.97432E+03_JPRB,0.13000E+04_JPRB /)  
KB(:, 4,18,16) = (/ &
 & 0.11973E+04_JPRB,0.89795E+03_JPRB,0.65609E+03_JPRB,0.92626E+03_JPRB,0.12359E+04_JPRB /)  
KB(:, 5,18,16) = (/ &
 & 0.11679E+04_JPRB,0.87596E+03_JPRB,0.62959E+03_JPRB,0.88232E+03_JPRB,0.11772E+04_JPRB /)  
KB(:, 1,19,16) = (/ &
 & 0.14213E+04_JPRB,0.10659E+04_JPRB,0.82299E+03_JPRB,0.11854E+04_JPRB,0.15817E+04_JPRB /)  
KB(:, 2,19,16) = (/ &
 & 0.13899E+04_JPRB,0.10424E+04_JPRB,0.78536E+03_JPRB,0.11181E+04_JPRB,0.14919E+04_JPRB /)  
KB(:, 3,19,16) = (/ &
 & 0.13555E+04_JPRB,0.10166E+04_JPRB,0.75067E+03_JPRB,0.10563E+04_JPRB,0.14093E+04_JPRB /)  
KB(:, 4,19,16) = (/ &
 & 0.13187E+04_JPRB,0.98902E+03_JPRB,0.71751E+03_JPRB,0.10008E+04_JPRB,0.13351E+04_JPRB /)  
KB(:, 5,19,16) = (/ &
 & 0.12809E+04_JPRB,0.96067E+03_JPRB,0.68653E+03_JPRB,0.95065E+03_JPRB,0.12682E+04_JPRB /)  
KB(:, 1,20,16) = (/ &
 & 0.15671E+04_JPRB,0.11753E+04_JPRB,0.89787E+03_JPRB,0.12782E+04_JPRB,0.17052E+04_JPRB /)  
KB(:, 2,20,16) = (/ &
 & 0.15245E+04_JPRB,0.11434E+04_JPRB,0.85373E+03_JPRB,0.12013E+04_JPRB,0.16026E+04_JPRB /)  
KB(:, 3,20,16) = (/ &
 & 0.14795E+04_JPRB,0.11097E+04_JPRB,0.81323E+03_JPRB,0.11307E+04_JPRB,0.15085E+04_JPRB /)  
KB(:, 4,20,16) = (/ &
 & 0.14333E+04_JPRB,0.10750E+04_JPRB,0.77488E+03_JPRB,0.10684E+04_JPRB,0.14252E+04_JPRB /)  
KB(:, 5,20,16) = (/ &
 & 0.13861E+04_JPRB,0.10396E+04_JPRB,0.73891E+03_JPRB,0.10119E+04_JPRB,0.13498E+04_JPRB /)  
KB(:, 1,21,16) = (/ &
 & 0.17057E+04_JPRB,0.12793E+04_JPRB,0.96840E+03_JPRB,0.13620E+04_JPRB,0.18170E+04_JPRB /)  
KB(:, 2,21,16) = (/ &
 & 0.16509E+04_JPRB,0.12382E+04_JPRB,0.91726E+03_JPRB,0.12758E+04_JPRB,0.17018E+04_JPRB /)  
KB(:, 3,21,16) = (/ &
 & 0.15947E+04_JPRB,0.11960E+04_JPRB,0.87064E+03_JPRB,0.11975E+04_JPRB,0.15973E+04_JPRB /)  
KB(:, 4,21,16) = (/ &
 & 0.15386E+04_JPRB,0.11540E+04_JPRB,0.82723E+03_JPRB,0.11286E+04_JPRB,0.15054E+04_JPRB /)  
KB(:, 5,21,16) = (/ &
 & 0.14823E+04_JPRB,0.11117E+04_JPRB,0.78614E+03_JPRB,0.10661E+04_JPRB,0.14220E+04_JPRB /)  
KB(:, 1,22,16) = (/ &
 & 0.18293E+04_JPRB,0.13720E+04_JPRB,0.10288E+04_JPRB,0.14300E+04_JPRB,0.19074E+04_JPRB /)  
KB(:, 2,22,16) = (/ &
 & 0.17617E+04_JPRB,0.13213E+04_JPRB,0.97120E+03_JPRB,0.13351E+04_JPRB,0.17808E+04_JPRB /)  
KB(:, 3,22,16) = (/ &
 & 0.16944E+04_JPRB,0.12708E+04_JPRB,0.91894E+03_JPRB,0.12506E+04_JPRB,0.16681E+04_JPRB /)  
KB(:, 4,22,16) = (/ &
 & 0.16287E+04_JPRB,0.12215E+04_JPRB,0.87041E+03_JPRB,0.11757E+04_JPRB,0.15681E+04_JPRB /)  
KB(:, 5,22,16) = (/ &
 & 0.15635E+04_JPRB,0.11726E+04_JPRB,0.82499E+03_JPRB,0.11083E+04_JPRB,0.14783E+04_JPRB /)  
KB(:, 1,23,16) = (/ &
 & 0.19373E+04_JPRB,0.14530E+04_JPRB,0.10803E+04_JPRB,0.14855E+04_JPRB,0.19814E+04_JPRB /)  
KB(:, 2,23,16) = (/ &
 & 0.18577E+04_JPRB,0.13933E+04_JPRB,0.10171E+04_JPRB,0.13836E+04_JPRB,0.18455E+04_JPRB /)  
KB(:, 3,23,16) = (/ &
 & 0.17799E+04_JPRB,0.13350E+04_JPRB,0.95955E+03_JPRB,0.12936E+04_JPRB,0.17253E+04_JPRB /)  
KB(:, 4,23,16) = (/ &
 & 0.17053E+04_JPRB,0.12790E+04_JPRB,0.90643E+03_JPRB,0.12138E+04_JPRB,0.16189E+04_JPRB /)  
KB(:, 5,23,16) = (/ &
 & 0.16318E+04_JPRB,0.12239E+04_JPRB,0.85742E+03_JPRB,0.11422E+04_JPRB,0.15233E+04_JPRB /)  
KB(:, 1,24,16) = (/ &
 & 0.20285E+04_JPRB,0.15214E+04_JPRB,0.11229E+04_JPRB,0.15287E+04_JPRB,0.20389E+04_JPRB /)  
KB(:, 2,24,16) = (/ &
 & 0.19379E+04_JPRB,0.14534E+04_JPRB,0.10546E+04_JPRB,0.14215E+04_JPRB,0.18958E+04_JPRB /)  
KB(:, 3,24,16) = (/ &
 & 0.18509E+04_JPRB,0.13882E+04_JPRB,0.99252E+03_JPRB,0.13268E+04_JPRB,0.17696E+04_JPRB /)  
KB(:, 4,24,16) = (/ &
 & 0.17680E+04_JPRB,0.13260E+04_JPRB,0.93542E+03_JPRB,0.12431E+04_JPRB,0.16579E+04_JPRB /)  
KB(:, 5,24,16) = (/ &
 & 0.16872E+04_JPRB,0.12654E+04_JPRB,0.88318E+03_JPRB,0.11679E+04_JPRB,0.15576E+04_JPRB /)  
KB(:, 1,25,16) = (/ &
 & 0.21022E+04_JPRB,0.15767E+04_JPRB,0.11562E+04_JPRB,0.15596E+04_JPRB,0.20800E+04_JPRB /)  
KB(:, 2,25,16) = (/ &
 & 0.20021E+04_JPRB,0.15016E+04_JPRB,0.10837E+04_JPRB,0.14483E+04_JPRB,0.19315E+04_JPRB /)  
KB(:, 3,25,16) = (/ &
 & 0.19072E+04_JPRB,0.14304E+04_JPRB,0.10177E+04_JPRB,0.13507E+04_JPRB,0.18013E+04_JPRB /)  
KB(:, 4,25,16) = (/ &
 & 0.18172E+04_JPRB,0.13629E+04_JPRB,0.95761E+03_JPRB,0.12639E+04_JPRB,0.16854E+04_JPRB /)  
KB(:, 5,25,16) = (/ &
 & 0.17302E+04_JPRB,0.12976E+04_JPRB,0.90262E+03_JPRB,0.11861E+04_JPRB,0.15818E+04_JPRB /)  
KB(:, 1,26,16) = (/ &
 & 0.21584E+04_JPRB,0.16188E+04_JPRB,0.11798E+04_JPRB,0.15785E+04_JPRB,0.21051E+04_JPRB /)  
KB(:, 2,26,16) = (/ &
 & 0.20504E+04_JPRB,0.15378E+04_JPRB,0.11040E+04_JPRB,0.14649E+04_JPRB,0.19536E+04_JPRB /)  
KB(:, 3,26,16) = (/ &
 & 0.19488E+04_JPRB,0.14616E+04_JPRB,0.10351E+04_JPRB,0.13650E+04_JPRB,0.18204E+04_JPRB /)  
KB(:, 4,26,16) = (/ &
 & 0.18527E+04_JPRB,0.13896E+04_JPRB,0.97267E+03_JPRB,0.12762E+04_JPRB,0.17019E+04_JPRB /)  
KB(:, 5,26,16) = (/ &
 & 0.17609E+04_JPRB,0.13206E+04_JPRB,0.91583E+03_JPRB,0.11969E+04_JPRB,0.15961E+04_JPRB /)  
KB(:, 1,27,16) = (/ &
 & 0.21995E+04_JPRB,0.16496E+04_JPRB,0.11960E+04_JPRB,0.15887E+04_JPRB,0.21185E+04_JPRB /)  
KB(:, 2,27,16) = (/ &
 & 0.20852E+04_JPRB,0.15639E+04_JPRB,0.11175E+04_JPRB,0.14736E+04_JPRB,0.19651E+04_JPRB /)  
KB(:, 3,27,16) = (/ &
 & 0.19784E+04_JPRB,0.14838E+04_JPRB,0.10466E+04_JPRB,0.13723E+04_JPRB,0.18300E+04_JPRB /)  
KB(:, 4,27,16) = (/ &
 & 0.18776E+04_JPRB,0.14082E+04_JPRB,0.98231E+03_JPRB,0.12823E+04_JPRB,0.17101E+04_JPRB /)  
KB(:, 5,27,16) = (/ &
 & 0.17820E+04_JPRB,0.13365E+04_JPRB,0.92416E+03_JPRB,0.12022E+04_JPRB,0.16031E+04_JPRB /)  
KB(:, 1,28,16) = (/ &
 & 0.22274E+04_JPRB,0.16706E+04_JPRB,0.12052E+04_JPRB,0.15913E+04_JPRB,0.21220E+04_JPRB /)  
KB(:, 2,28,16) = (/ &
 & 0.21084E+04_JPRB,0.15813E+04_JPRB,0.11251E+04_JPRB,0.14757E+04_JPRB,0.19679E+04_JPRB /)  
KB(:, 3,28,16) = (/ &
 & 0.19974E+04_JPRB,0.14981E+04_JPRB,0.10528E+04_JPRB,0.13738E+04_JPRB,0.18320E+04_JPRB /)  
KB(:, 4,28,16) = (/ &
 & 0.18930E+04_JPRB,0.14198E+04_JPRB,0.98736E+03_JPRB,0.12834E+04_JPRB,0.17114E+04_JPRB /)  
KB(:, 5,28,16) = (/ &
 & 0.17945E+04_JPRB,0.13459E+04_JPRB,0.92826E+03_JPRB,0.12029E+04_JPRB,0.16040E+04_JPRB /)  
KB(:, 1,29,16) = (/ &
 & 0.22434E+04_JPRB,0.16825E+04_JPRB,0.12082E+04_JPRB,0.15868E+04_JPRB,0.21160E+04_JPRB /)  
KB(:, 2,29,16) = (/ &
 & 0.21209E+04_JPRB,0.15907E+04_JPRB,0.11272E+04_JPRB,0.14716E+04_JPRB,0.19623E+04_JPRB /)  
KB(:, 3,29,16) = (/ &
 & 0.20069E+04_JPRB,0.15052E+04_JPRB,0.10541E+04_JPRB,0.13700E+04_JPRB,0.18268E+04_JPRB /)  
KB(:, 4,29,16) = (/ &
 & 0.18999E+04_JPRB,0.14249E+04_JPRB,0.98819E+03_JPRB,0.12798E+04_JPRB,0.17065E+04_JPRB /)  
KB(:, 5,29,16) = (/ &
 & 0.17996E+04_JPRB,0.13497E+04_JPRB,0.92869E+03_JPRB,0.11992E+04_JPRB,0.15991E+04_JPRB /)  
KB(:, 1,30,16) = (/ &
 & 0.22495E+04_JPRB,0.16871E+04_JPRB,0.12065E+04_JPRB,0.15776E+04_JPRB,0.21036E+04_JPRB /)  
KB(:, 2,30,16) = (/ &
 & 0.21251E+04_JPRB,0.15938E+04_JPRB,0.11251E+04_JPRB,0.14633E+04_JPRB,0.19512E+04_JPRB /)  
KB(:, 3,30,16) = (/ &
 & 0.20091E+04_JPRB,0.15068E+04_JPRB,0.10517E+04_JPRB,0.13621E+04_JPRB,0.18163E+04_JPRB /)  
KB(:, 4,30,16) = (/ &
 & 0.19004E+04_JPRB,0.14253E+04_JPRB,0.98584E+03_JPRB,0.12727E+04_JPRB,0.16970E+04_JPRB /)  
KB(:, 5,30,16) = (/ &
 & 0.17984E+04_JPRB,0.13488E+04_JPRB,0.92610E+03_JPRB,0.11928E+04_JPRB,0.15905E+04_JPRB /)  
KB(:, 1,31,16) = (/ &
 & 0.22474E+04_JPRB,0.16855E+04_JPRB,0.12005E+04_JPRB,0.15635E+04_JPRB,0.20848E+04_JPRB /)  
KB(:, 2,31,16) = (/ &
 & 0.21214E+04_JPRB,0.15910E+04_JPRB,0.11192E+04_JPRB,0.14507E+04_JPRB,0.19344E+04_JPRB /)  
KB(:, 3,31,16) = (/ &
 & 0.20043E+04_JPRB,0.15033E+04_JPRB,0.10461E+04_JPRB,0.13510E+04_JPRB,0.18015E+04_JPRB /)  
KB(:, 4,31,16) = (/ &
 & 0.18948E+04_JPRB,0.14211E+04_JPRB,0.98049E+03_JPRB,0.12625E+04_JPRB,0.16835E+04_JPRB /)  
KB(:, 5,31,16) = (/ &
 & 0.17922E+04_JPRB,0.13441E+04_JPRB,0.92102E+03_JPRB,0.11837E+04_JPRB,0.15784E+04_JPRB /)  
KB(:, 1,32,16) = (/ &
 & 0.22387E+04_JPRB,0.16790E+04_JPRB,0.11913E+04_JPRB,0.15463E+04_JPRB,0.20617E+04_JPRB /)  
KB(:, 2,32,16) = (/ &
 & 0.21117E+04_JPRB,0.15838E+04_JPRB,0.11104E+04_JPRB,0.14353E+04_JPRB,0.19138E+04_JPRB /)  
KB(:, 3,32,16) = (/ &
 & 0.19944E+04_JPRB,0.14958E+04_JPRB,0.10381E+04_JPRB,0.13373E+04_JPRB,0.17831E+04_JPRB /)  
KB(:, 4,32,16) = (/ &
 & 0.18846E+04_JPRB,0.14135E+04_JPRB,0.97304E+03_JPRB,0.12502E+04_JPRB,0.16670E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART36',1,ZHOOK_HANDLE)
END SUBROUTINE PART36


SUBROUTINE PART37

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART37',0,ZHOOK_HANDLE)


KB(:, 5,32,16) = (/ &
 & 0.17818E+04_JPRB,0.13363E+04_JPRB,0.91392E+03_JPRB,0.11724E+04_JPRB,0.15633E+04_JPRB /)  
KB(:, 1,33,16) = (/ &
 & 0.22243E+04_JPRB,0.16682E+04_JPRB,0.11793E+04_JPRB,0.15266E+04_JPRB,0.20355E+04_JPRB /)  
KB(:, 2,33,16) = (/ &
 & 0.20975E+04_JPRB,0.15731E+04_JPRB,0.10994E+04_JPRB,0.14177E+04_JPRB,0.18903E+04_JPRB /)  
KB(:, 3,33,16) = (/ &
 & 0.19805E+04_JPRB,0.14854E+04_JPRB,0.10282E+04_JPRB,0.13217E+04_JPRB,0.17623E+04_JPRB /)  
KB(:, 4,33,16) = (/ &
 & 0.18707E+04_JPRB,0.14030E+04_JPRB,0.96384E+03_JPRB,0.12361E+04_JPRB,0.16482E+04_JPRB /)  
KB(:, 5,33,16) = (/ &
 & 0.17684E+04_JPRB,0.13263E+04_JPRB,0.90541E+03_JPRB,0.11600E+04_JPRB,0.15467E+04_JPRB /)  
KB(:, 1,34,16) = (/ &
 & 0.22110E+04_JPRB,0.16582E+04_JPRB,0.11687E+04_JPRB,0.15094E+04_JPRB,0.20126E+04_JPRB /)  
KB(:, 2,34,16) = (/ &
 & 0.20843E+04_JPRB,0.15632E+04_JPRB,0.10894E+04_JPRB,0.14021E+04_JPRB,0.18696E+04_JPRB /)  
KB(:, 3,34,16) = (/ &
 & 0.19675E+04_JPRB,0.14756E+04_JPRB,0.10193E+04_JPRB,0.13079E+04_JPRB,0.17439E+04_JPRB /)  
KB(:, 4,34,16) = (/ &
 & 0.18579E+04_JPRB,0.13934E+04_JPRB,0.95559E+03_JPRB,0.12238E+04_JPRB,0.16318E+04_JPRB /)  
KB(:, 5,34,16) = (/ &
 & 0.17560E+04_JPRB,0.13170E+04_JPRB,0.89776E+03_JPRB,0.11489E+04_JPRB,0.15318E+04_JPRB /)  
KB(:, 1,35,16) = (/ &
 & 0.22070E+04_JPRB,0.16552E+04_JPRB,0.11645E+04_JPRB,0.15017E+04_JPRB,0.20024E+04_JPRB /)  
KB(:, 2,35,16) = (/ &
 & 0.20800E+04_JPRB,0.15600E+04_JPRB,0.10855E+04_JPRB,0.13953E+04_JPRB,0.18605E+04_JPRB /)  
KB(:, 3,35,16) = (/ &
 & 0.19630E+04_JPRB,0.14722E+04_JPRB,0.10157E+04_JPRB,0.13017E+04_JPRB,0.17356E+04_JPRB /)  
KB(:, 4,35,16) = (/ &
 & 0.18532E+04_JPRB,0.13899E+04_JPRB,0.95221E+03_JPRB,0.12182E+04_JPRB,0.16243E+04_JPRB /)  
KB(:, 5,35,16) = (/ &
 & 0.17512E+04_JPRB,0.13134E+04_JPRB,0.89456E+03_JPRB,0.11438E+04_JPRB,0.15251E+04_JPRB /)  
KB(:, 1,36,16) = (/ &
 & 0.22146E+04_JPRB,0.16609E+04_JPRB,0.11681E+04_JPRB,0.15050E+04_JPRB,0.20067E+04_JPRB /)  
KB(:, 2,36,16) = (/ &
 & 0.20867E+04_JPRB,0.15651E+04_JPRB,0.10887E+04_JPRB,0.13982E+04_JPRB,0.18642E+04_JPRB /)  
KB(:, 3,36,16) = (/ &
 & 0.19689E+04_JPRB,0.14767E+04_JPRB,0.10184E+04_JPRB,0.13041E+04_JPRB,0.17389E+04_JPRB /)  
KB(:, 4,36,16) = (/ &
 & 0.18582E+04_JPRB,0.13937E+04_JPRB,0.95458E+03_JPRB,0.12204E+04_JPRB,0.16272E+04_JPRB /)  
KB(:, 5,36,16) = (/ &
 & 0.17557E+04_JPRB,0.13168E+04_JPRB,0.89664E+03_JPRB,0.11458E+04_JPRB,0.15277E+04_JPRB /)  
KB(:, 1,37,16) = (/ &
 & 0.22411E+04_JPRB,0.16809E+04_JPRB,0.11837E+04_JPRB,0.15248E+04_JPRB,0.20331E+04_JPRB /)  
KB(:, 2,37,16) = (/ &
 & 0.21106E+04_JPRB,0.15830E+04_JPRB,0.11025E+04_JPRB,0.14155E+04_JPRB,0.18873E+04_JPRB /)  
KB(:, 3,37,16) = (/ &
 & 0.19909E+04_JPRB,0.14932E+04_JPRB,0.10307E+04_JPRB,0.13195E+04_JPRB,0.17594E+04_JPRB /)  
KB(:, 4,37,16) = (/ &
 & 0.18783E+04_JPRB,0.14088E+04_JPRB,0.96559E+03_JPRB,0.12340E+04_JPRB,0.16453E+04_JPRB /)  
KB(:, 5,37,16) = (/ &
 & 0.17743E+04_JPRB,0.13307E+04_JPRB,0.90666E+03_JPRB,0.11578E+04_JPRB,0.15438E+04_JPRB /)  
KB(:, 1,38,16) = (/ &
 & 0.22677E+04_JPRB,0.17008E+04_JPRB,0.11995E+04_JPRB,0.15451E+04_JPRB,0.20601E+04_JPRB /)  
KB(:, 2,38,16) = (/ &
 & 0.21347E+04_JPRB,0.16010E+04_JPRB,0.11166E+04_JPRB,0.14334E+04_JPRB,0.19112E+04_JPRB /)  
KB(:, 3,38,16) = (/ &
 & 0.20130E+04_JPRB,0.15097E+04_JPRB,0.10432E+04_JPRB,0.13353E+04_JPRB,0.17805E+04_JPRB /)  
KB(:, 4,38,16) = (/ &
 & 0.18989E+04_JPRB,0.14242E+04_JPRB,0.97692E+03_JPRB,0.12480E+04_JPRB,0.16640E+04_JPRB /)  
KB(:, 5,38,16) = (/ &
 & 0.17929E+04_JPRB,0.13447E+04_JPRB,0.91684E+03_JPRB,0.11704E+04_JPRB,0.15605E+04_JPRB /)  
KB(:, 1,39,16) = (/ &
 & 0.22932E+04_JPRB,0.17199E+04_JPRB,0.12149E+04_JPRB,0.15649E+04_JPRB,0.20865E+04_JPRB /)  
KB(:, 2,39,16) = (/ &
 & 0.21580E+04_JPRB,0.16185E+04_JPRB,0.11304E+04_JPRB,0.14510E+04_JPRB,0.19346E+04_JPRB /)  
KB(:, 3,39,16) = (/ &
 & 0.20342E+04_JPRB,0.15257E+04_JPRB,0.10554E+04_JPRB,0.13508E+04_JPRB,0.18011E+04_JPRB /)  
KB(:, 4,39,16) = (/ &
 & 0.19186E+04_JPRB,0.14389E+04_JPRB,0.98789E+03_JPRB,0.12618E+04_JPRB,0.16825E+04_JPRB /)  
KB(:, 5,39,16) = (/ &
 & 0.18110E+04_JPRB,0.13582E+04_JPRB,0.92676E+03_JPRB,0.11826E+04_JPRB,0.15768E+04_JPRB /)  
KB(:, 1,40,16) = (/ &
 & 0.23330E+04_JPRB,0.17497E+04_JPRB,0.12394E+04_JPRB,0.15975E+04_JPRB,0.21300E+04_JPRB /)  
KB(:, 2,40,16) = (/ &
 & 0.21946E+04_JPRB,0.16460E+04_JPRB,0.11524E+04_JPRB,0.14797E+04_JPRB,0.19730E+04_JPRB /)  
KB(:, 3,40,16) = (/ &
 & 0.20673E+04_JPRB,0.15505E+04_JPRB,0.10747E+04_JPRB,0.13759E+04_JPRB,0.18346E+04_JPRB /)  
KB(:, 4,40,16) = (/ &
 & 0.19494E+04_JPRB,0.14621E+04_JPRB,0.10054E+04_JPRB,0.12842E+04_JPRB,0.17123E+04_JPRB /)  
KB(:, 5,40,16) = (/ &
 & 0.18395E+04_JPRB,0.13796E+04_JPRB,0.94264E+03_JPRB,0.12026E+04_JPRB,0.16034E+04_JPRB /)  
KB(:, 1,41,16) = (/ &
 & 0.23748E+04_JPRB,0.17811E+04_JPRB,0.12653E+04_JPRB,0.16323E+04_JPRB,0.21765E+04_JPRB /)  
KB(:, 2,41,16) = (/ &
 & 0.22335E+04_JPRB,0.16751E+04_JPRB,0.11760E+04_JPRB,0.15106E+04_JPRB,0.20142E+04_JPRB /)  
KB(:, 3,41,16) = (/ &
 & 0.21020E+04_JPRB,0.15765E+04_JPRB,0.10953E+04_JPRB,0.14029E+04_JPRB,0.18706E+04_JPRB /)  
KB(:, 4,41,16) = (/ &
 & 0.19818E+04_JPRB,0.14863E+04_JPRB,0.10239E+04_JPRB,0.13082E+04_JPRB,0.17443E+04_JPRB /)  
KB(:, 5,41,16) = (/ &
 & 0.18696E+04_JPRB,0.14022E+04_JPRB,0.95944E+03_JPRB,0.12238E+04_JPRB,0.16317E+04_JPRB /)  
KB(:, 1,42,16) = (/ &
 & 0.24183E+04_JPRB,0.18137E+04_JPRB,0.12922E+04_JPRB,0.16686E+04_JPRB,0.22248E+04_JPRB /)  
KB(:, 2,42,16) = (/ &
 & 0.22718E+04_JPRB,0.17039E+04_JPRB,0.11997E+04_JPRB,0.15420E+04_JPRB,0.20561E+04_JPRB /)  
KB(:, 3,42,16) = (/ &
 & 0.21373E+04_JPRB,0.16030E+04_JPRB,0.11164E+04_JPRB,0.14305E+04_JPRB,0.19073E+04_JPRB /)  
KB(:, 4,42,16) = (/ &
 & 0.20143E+04_JPRB,0.15107E+04_JPRB,0.10428E+04_JPRB,0.13327E+04_JPRB,0.17770E+04_JPRB /)  
KB(:, 5,42,16) = (/ &
 & 0.18998E+04_JPRB,0.14249E+04_JPRB,0.97647E+03_JPRB,0.12457E+04_JPRB,0.16610E+04_JPRB /)  
KB(:, 1,43,16) = (/ &
 & 0.24703E+04_JPRB,0.18528E+04_JPRB,0.13249E+04_JPRB,0.17136E+04_JPRB,0.22848E+04_JPRB /)  
KB(:, 2,43,16) = (/ &
 & 0.23188E+04_JPRB,0.17391E+04_JPRB,0.12289E+04_JPRB,0.15811E+04_JPRB,0.21082E+04_JPRB /)  
KB(:, 3,43,16) = (/ &
 & 0.21803E+04_JPRB,0.16352E+04_JPRB,0.11426E+04_JPRB,0.14651E+04_JPRB,0.19535E+04_JPRB /)  
KB(:, 4,43,16) = (/ &
 & 0.20539E+04_JPRB,0.15404E+04_JPRB,0.10659E+04_JPRB,0.13633E+04_JPRB,0.18177E+04_JPRB /)  
KB(:, 5,43,16) = (/ &
 & 0.19367E+04_JPRB,0.14525E+04_JPRB,0.99744E+03_JPRB,0.12728E+04_JPRB,0.16970E+04_JPRB /)  
KB(:, 1,44,16) = (/ &
 & 0.25274E+04_JPRB,0.18956E+04_JPRB,0.13612E+04_JPRB,0.17642E+04_JPRB,0.23522E+04_JPRB /)  
KB(:, 2,44,16) = (/ &
 & 0.23706E+04_JPRB,0.17780E+04_JPRB,0.12614E+04_JPRB,0.16248E+04_JPRB,0.21664E+04_JPRB /)  
KB(:, 3,44,16) = (/ &
 & 0.22278E+04_JPRB,0.16708E+04_JPRB,0.11717E+04_JPRB,0.15040E+04_JPRB,0.20053E+04_JPRB /)  
KB(:, 4,44,16) = (/ &
 & 0.20979E+04_JPRB,0.15734E+04_JPRB,0.10920E+04_JPRB,0.13972E+04_JPRB,0.18630E+04_JPRB /)  
KB(:, 5,44,16) = (/ &
 & 0.19771E+04_JPRB,0.14828E+04_JPRB,0.10207E+04_JPRB,0.13030E+04_JPRB,0.17374E+04_JPRB /)  
KB(:, 1,45,16) = (/ &
 & 0.25859E+04_JPRB,0.19394E+04_JPRB,0.13990E+04_JPRB,0.18173E+04_JPRB,0.24231E+04_JPRB /)  
KB(:, 2,45,16) = (/ &
 & 0.24239E+04_JPRB,0.18179E+04_JPRB,0.12948E+04_JPRB,0.16708E+04_JPRB,0.22278E+04_JPRB /)  
KB(:, 3,45,16) = (/ &
 & 0.22761E+04_JPRB,0.17071E+04_JPRB,0.12017E+04_JPRB,0.15441E+04_JPRB,0.20588E+04_JPRB /)  
KB(:, 4,45,16) = (/ &
 & 0.21421E+04_JPRB,0.16066E+04_JPRB,0.11186E+04_JPRB,0.14324E+04_JPRB,0.19099E+04_JPRB /)  
KB(:, 5,45,16) = (/ &
 & 0.20183E+04_JPRB,0.15137E+04_JPRB,0.10446E+04_JPRB,0.13343E+04_JPRB,0.17791E+04_JPRB /)  
KB(:, 1,46,16) = (/ &
 & 0.26504E+04_JPRB,0.19878E+04_JPRB,0.14409E+04_JPRB,0.18767E+04_JPRB,0.25023E+04_JPRB /)  
KB(:, 2,46,16) = (/ &
 & 0.24823E+04_JPRB,0.18617E+04_JPRB,0.13316E+04_JPRB,0.17220E+04_JPRB,0.22960E+04_JPRB /)  
KB(:, 3,46,16) = (/ &
 & 0.23297E+04_JPRB,0.17473E+04_JPRB,0.12351E+04_JPRB,0.15885E+04_JPRB,0.21180E+04_JPRB /)  
KB(:, 4,46,16) = (/ &
 & 0.21905E+04_JPRB,0.16429E+04_JPRB,0.11482E+04_JPRB,0.14718E+04_JPRB,0.19624E+04_JPRB /)  
KB(:, 5,46,16) = (/ &
 & 0.20627E+04_JPRB,0.15470E+04_JPRB,0.10708E+04_JPRB,0.13689E+04_JPRB,0.18252E+04_JPRB /)  
KB(:, 1,47,16) = (/ &
 & 0.27247E+04_JPRB,0.20435E+04_JPRB,0.14902E+04_JPRB,0.19477E+04_JPRB,0.25969E+04_JPRB /)  
KB(:, 2,47,16) = (/ &
 & 0.25493E+04_JPRB,0.19120E+04_JPRB,0.13747E+04_JPRB,0.17822E+04_JPRB,0.23763E+04_JPRB /)  
KB(:, 3,47,16) = (/ &
 & 0.23907E+04_JPRB,0.17930E+04_JPRB,0.12733E+04_JPRB,0.16405E+04_JPRB,0.21874E+04_JPRB /)  
KB(:, 4,47,16) = (/ &
 & 0.22466E+04_JPRB,0.16850E+04_JPRB,0.11827E+04_JPRB,0.15177E+04_JPRB,0.20235E+04_JPRB /)  
KB(:, 5,47,16) = (/ &
 & 0.21136E+04_JPRB,0.15852E+04_JPRB,0.11012E+04_JPRB,0.14091E+04_JPRB,0.18788E+04_JPRB /)  
KB(:, 1,48,16) = (/ &
 & 0.28012E+04_JPRB,0.21009E+04_JPRB,0.15426E+04_JPRB,0.20233E+04_JPRB,0.26978E+04_JPRB /)  
KB(:, 2,48,16) = (/ &
 & 0.26190E+04_JPRB,0.19642E+04_JPRB,0.14199E+04_JPRB,0.18460E+04_JPRB,0.24614E+04_JPRB /)  
KB(:, 3,48,16) = (/ &
 & 0.24541E+04_JPRB,0.18406E+04_JPRB,0.13132E+04_JPRB,0.16956E+04_JPRB,0.22609E+04_JPRB /)  
KB(:, 4,48,16) = (/ &
 & 0.23037E+04_JPRB,0.17278E+04_JPRB,0.12184E+04_JPRB,0.15658E+04_JPRB,0.20877E+04_JPRB /)  
KB(:, 5,48,16) = (/ &
 & 0.21661E+04_JPRB,0.16246E+04_JPRB,0.11331E+04_JPRB,0.14514E+04_JPRB,0.19352E+04_JPRB /)  
KB(:, 1,49,16) = (/ &
 & 0.28818E+04_JPRB,0.21613E+04_JPRB,0.15982E+04_JPRB,0.21038E+04_JPRB,0.28050E+04_JPRB /)  
KB(:, 2,49,16) = (/ &
 & 0.26914E+04_JPRB,0.20185E+04_JPRB,0.14674E+04_JPRB,0.19143E+04_JPRB,0.25524E+04_JPRB /)  
KB(:, 3,49,16) = (/ &
 & 0.25196E+04_JPRB,0.18897E+04_JPRB,0.13550E+04_JPRB,0.17541E+04_JPRB,0.23389E+04_JPRB /)  
KB(:, 4,49,16) = (/ &
 & 0.23632E+04_JPRB,0.17724E+04_JPRB,0.12557E+04_JPRB,0.16163E+04_JPRB,0.21550E+04_JPRB /)  
KB(:, 5,49,16) = (/ &
 & 0.22208E+04_JPRB,0.16656E+04_JPRB,0.11666E+04_JPRB,0.14961E+04_JPRB,0.19948E+04_JPRB /)  
KB(:, 1,50,16) = (/ &
 & 0.29612E+04_JPRB,0.22209E+04_JPRB,0.16532E+04_JPRB,0.21839E+04_JPRB,0.29118E+04_JPRB /)  
KB(:, 2,50,16) = (/ &
 & 0.27615E+04_JPRB,0.20712E+04_JPRB,0.15149E+04_JPRB,0.19827E+04_JPRB,0.26437E+04_JPRB /)  
KB(:, 3,50,16) = (/ &
 & 0.25830E+04_JPRB,0.19373E+04_JPRB,0.13961E+04_JPRB,0.18120E+04_JPRB,0.24160E+04_JPRB /)  
KB(:, 4,50,16) = (/ &
 & 0.24210E+04_JPRB,0.18157E+04_JPRB,0.12921E+04_JPRB,0.16664E+04_JPRB,0.22218E+04_JPRB /)  
KB(:, 5,50,16) = (/ &
 & 0.22734E+04_JPRB,0.17051E+04_JPRB,0.11994E+04_JPRB,0.15401E+04_JPRB,0.20534E+04_JPRB /)  
KB(:, 1,51,16) = (/ &
 & 0.30414E+04_JPRB,0.22810E+04_JPRB,0.17098E+04_JPRB,0.22662E+04_JPRB,0.30216E+04_JPRB /)  
KB(:, 2,51,16) = (/ &
 & 0.28321E+04_JPRB,0.21241E+04_JPRB,0.15635E+04_JPRB,0.20530E+04_JPRB,0.27374E+04_JPRB /)  
KB(:, 3,51,16) = (/ &
 & 0.26473E+04_JPRB,0.19855E+04_JPRB,0.14379E+04_JPRB,0.18712E+04_JPRB,0.24950E+04_JPRB /)  
KB(:, 4,51,16) = (/ &
 & 0.24793E+04_JPRB,0.18595E+04_JPRB,0.13289E+04_JPRB,0.17174E+04_JPRB,0.22898E+04_JPRB /)  
KB(:, 5,51,16) = (/ &
 & 0.23268E+04_JPRB,0.17451E+04_JPRB,0.12327E+04_JPRB,0.15846E+04_JPRB,0.21128E+04_JPRB /)  
KB(:, 1,52,16) = (/ &
 & 0.31248E+04_JPRB,0.23436E+04_JPRB,0.17703E+04_JPRB,0.23534E+04_JPRB,0.31379E+04_JPRB /)  
KB(:, 2,52,16) = (/ &
 & 0.29063E+04_JPRB,0.21797E+04_JPRB,0.16147E+04_JPRB,0.21274E+04_JPRB,0.28366E+04_JPRB /)  
KB(:, 3,52,16) = (/ &
 & 0.27134E+04_JPRB,0.20351E+04_JPRB,0.14818E+04_JPRB,0.19344E+04_JPRB,0.25793E+04_JPRB /)  
KB(:, 4,52,16) = (/ &
 & 0.25389E+04_JPRB,0.19042E+04_JPRB,0.13672E+04_JPRB,0.17712E+04_JPRB,0.23616E+04_JPRB /)  
KB(:, 5,52,16) = (/ &
 & 0.23814E+04_JPRB,0.17860E+04_JPRB,0.12669E+04_JPRB,0.16310E+04_JPRB,0.21746E+04_JPRB /)  
KB(:, 1,53,16) = (/ &
 & 0.32126E+04_JPRB,0.24095E+04_JPRB,0.18346E+04_JPRB,0.24459E+04_JPRB,0.32612E+04_JPRB /)  
KB(:, 2,53,16) = (/ &
 & 0.29838E+04_JPRB,0.22378E+04_JPRB,0.16687E+04_JPRB,0.22061E+04_JPRB,0.29415E+04_JPRB /)  
KB(:, 3,53,16) = (/ &
 & 0.27817E+04_JPRB,0.20863E+04_JPRB,0.15283E+04_JPRB,0.20017E+04_JPRB,0.26689E+04_JPRB /)  
KB(:, 4,53,16) = (/ &
 & 0.26009E+04_JPRB,0.19507E+04_JPRB,0.14074E+04_JPRB,0.18280E+04_JPRB,0.24374E+04_JPRB /)  
KB(:, 5,53,16) = (/ &
 & 0.24377E+04_JPRB,0.18283E+04_JPRB,0.13025E+04_JPRB,0.16802E+04_JPRB,0.22403E+04_JPRB /)  
KB(:, 1,54,16) = (/ &
 & 0.32965E+04_JPRB,0.24725E+04_JPRB,0.18972E+04_JPRB,0.25356E+04_JPRB,0.33807E+04_JPRB /)  
KB(:, 2,54,16) = (/ &
 & 0.30576E+04_JPRB,0.22932E+04_JPRB,0.17211E+04_JPRB,0.22822E+04_JPRB,0.30430E+04_JPRB /)  
KB(:, 3,54,16) = (/ &
 & 0.28468E+04_JPRB,0.21351E+04_JPRB,0.15733E+04_JPRB,0.20668E+04_JPRB,0.27558E+04_JPRB /)  
KB(:, 4,54,16) = (/ &
 & 0.26600E+04_JPRB,0.19950E+04_JPRB,0.14459E+04_JPRB,0.18829E+04_JPRB,0.25105E+04_JPRB /)  
KB(:, 5,54,16) = (/ &
 & 0.24912E+04_JPRB,0.18684E+04_JPRB,0.13364E+04_JPRB,0.17275E+04_JPRB,0.23034E+04_JPRB /)  
KB(:, 1,55,16) = (/ &
 & 0.33833E+04_JPRB,0.25376E+04_JPRB,0.19611E+04_JPRB,0.26264E+04_JPRB,0.35019E+04_JPRB /)  
KB(:, 2,55,16) = (/ &
 & 0.31321E+04_JPRB,0.23491E+04_JPRB,0.17750E+04_JPRB,0.23596E+04_JPRB,0.31462E+04_JPRB /)  
KB(:, 3,55,16) = (/ &
 & 0.29119E+04_JPRB,0.21839E+04_JPRB,0.16184E+04_JPRB,0.21327E+04_JPRB,0.28435E+04_JPRB /)  
KB(:, 4,55,16) = (/ &
 & 0.27182E+04_JPRB,0.20386E+04_JPRB,0.14848E+04_JPRB,0.19390E+04_JPRB,0.25853E+04_JPRB /)  
KB(:, 5,55,16) = (/ &
 & 0.25438E+04_JPRB,0.19078E+04_JPRB,0.13702E+04_JPRB,0.17749E+04_JPRB,0.23665E+04_JPRB /)  
KB(:, 1,56,16) = (/ &
 & 0.34732E+04_JPRB,0.26050E+04_JPRB,0.20286E+04_JPRB,0.27221E+04_JPRB,0.36294E+04_JPRB /)  
KB(:, 2,56,16) = (/ &
 & 0.32087E+04_JPRB,0.24066E+04_JPRB,0.18312E+04_JPRB,0.24406E+04_JPRB,0.32540E+04_JPRB /)  
KB(:, 3,56,16) = (/ &
 & 0.29798E+04_JPRB,0.22348E+04_JPRB,0.16657E+04_JPRB,0.22014E+04_JPRB,0.29353E+04_JPRB /)  
KB(:, 4,56,16) = (/ &
 & 0.27779E+04_JPRB,0.20834E+04_JPRB,0.15255E+04_JPRB,0.19978E+04_JPRB,0.26637E+04_JPRB /)  
KB(:, 5,56,16) = (/ &
 & 0.25980E+04_JPRB,0.19485E+04_JPRB,0.14055E+04_JPRB,0.18247E+04_JPRB,0.24330E+04_JPRB /)  
KB(:, 1,57,16) = (/ &
 & 0.35673E+04_JPRB,0.26755E+04_JPRB,0.21006E+04_JPRB,0.28229E+04_JPRB,0.37639E+04_JPRB /)  
KB(:, 2,57,16) = (/ &
 & 0.32883E+04_JPRB,0.24663E+04_JPRB,0.18907E+04_JPRB,0.25257E+04_JPRB,0.33676E+04_JPRB /)  
KB(:, 3,57,16) = (/ &
 & 0.30500E+04_JPRB,0.22875E+04_JPRB,0.17155E+04_JPRB,0.22739E+04_JPRB,0.30319E+04_JPRB /)  
KB(:, 4,57,16) = (/ &
 & 0.28394E+04_JPRB,0.21295E+04_JPRB,0.15682E+04_JPRB,0.20597E+04_JPRB,0.27463E+04_JPRB /)  
KB(:, 5,57,16) = (/ &
 & 0.26543E+04_JPRB,0.19907E+04_JPRB,0.14421E+04_JPRB,0.18768E+04_JPRB,0.25025E+04_JPRB /)  
KB(:, 1,58,16) = (/ &
 & 0.36607E+04_JPRB,0.27457E+04_JPRB,0.21738E+04_JPRB,0.29233E+04_JPRB,0.38978E+04_JPRB /)  
KB(:, 2,58,16) = (/ &
 & 0.33686E+04_JPRB,0.25266E+04_JPRB,0.19501E+04_JPRB,0.26108E+04_JPRB,0.34810E+04_JPRB /)  
KB(:, 3,58,16) = (/ &
 & 0.31191E+04_JPRB,0.23393E+04_JPRB,0.17656E+04_JPRB,0.23462E+04_JPRB,0.31282E+04_JPRB /)  
KB(:, 4,58,16) = (/ &
 & 0.29009E+04_JPRB,0.21757E+04_JPRB,0.16107E+04_JPRB,0.21213E+04_JPRB,0.28285E+04_JPRB /)  
KB(:, 5,58,16) = (/ &
 & 0.27090E+04_JPRB,0.20318E+04_JPRB,0.14784E+04_JPRB,0.19292E+04_JPRB,0.25722E+04_JPRB /)  
KB(:, 1,59,16) = (/ &
 & 0.36992E+04_JPRB,0.27745E+04_JPRB,0.22044E+04_JPRB,0.29651E+04_JPRB,0.39534E+04_JPRB /)  
KB(:, 2,59,16) = (/ &
 & 0.34022E+04_JPRB,0.25517E+04_JPRB,0.19749E+04_JPRB,0.26461E+04_JPRB,0.35281E+04_JPRB /)  
KB(:, 3,59,16) = (/ &
 & 0.31476E+04_JPRB,0.23607E+04_JPRB,0.17864E+04_JPRB,0.23762E+04_JPRB,0.31682E+04_JPRB /)  
KB(:, 4,59,16) = (/ &
 & 0.29259E+04_JPRB,0.21945E+04_JPRB,0.16281E+04_JPRB,0.21469E+04_JPRB,0.28626E+04_JPRB /)  
KB(:, 5,59,16) = (/ &
 & 0.27315E+04_JPRB,0.20486E+04_JPRB,0.14936E+04_JPRB,0.19510E+04_JPRB,0.26013E+04_JPRB /)  

!     -----------------------------------------------------------------

FORREF(:, 1) = (/ 0.553258E-03_JPRB, 0.555486E-03_JPRB, 0.601339E-03_JPRB, 0.708280E-03_JPRB /)
FORREF(:, 2) = (/ 0.158558E-02_JPRB, 0.162957E-02_JPRB, 0.204991E-02_JPRB, 0.475881E-02_JPRB /)
FORREF(:, 3) = (/ 0.772542E-02_JPRB, 0.784562E-02_JPRB, 0.111979E-01_JPRB, 0.229016E-01_JPRB /)
FORREF(:, 4) = (/ 0.255097E-01_JPRB, 0.256272E-01_JPRB, 0.270691E-01_JPRB, 0.259505E-01_JPRB /)
FORREF(:, 5) = (/ 0.323263E-01_JPRB, 0.324495E-01_JPRB, 0.305535E-01_JPRB, 0.263993E-01_JPRB /)
FORREF(:, 6) = (/ 0.346920E-01_JPRB, 0.348255E-01_JPRB, 0.323586E-01_JPRB, 0.276357E-01_JPRB /)
FORREF(:, 7) = (/ 0.366509E-01_JPRB, 0.366412E-01_JPRB, 0.344434E-01_JPRB, 0.319223E-01_JPRB /)
FORREF(:, 8) = (/ 0.378451E-01_JPRB, 0.375341E-01_JPRB, 0.374369E-01_JPRB, 0.320334E-01_JPRB /)
FORREF(:, 9) = (/ 0.407348E-01_JPRB, 0.396203E-01_JPRB, 0.393988E-01_JPRB, 0.318343E-01_JPRB /)
FORREF(:,10) = (/ 0.433035E-01_JPRB, 0.426488E-01_JPRB, 0.408085E-01_JPRB, 0.332749E-01_JPRB /)
FORREF(:,11) = (/ 0.428254E-01_JPRB, 0.441151E-01_JPRB, 0.408887E-01_JPRB, 0.327077E-01_JPRB /)
FORREF(:,12) = (/ 0.443226E-01_JPRB, 0.446690E-01_JPRB, 0.404676E-01_JPRB, 0.350492E-01_JPRB /)
FORREF(:,13) = (/ 0.466103E-01_JPRB, 0.460809E-01_JPRB, 0.401286E-01_JPRB, 0.370427E-01_JPRB /)
FORREF(:,14) = (/ 0.483928E-01_JPRB, 0.477284E-01_JPRB, 0.380684E-01_JPRB, 0.387940E-01_JPRB /)
FORREF(:,15) = (/ 0.506987E-01_JPRB, 0.490016E-01_JPRB, 0.467069E-01_JPRB, 0.368998E-01_JPRB /)
FORREF(:,16) = (/ 0.510836E-01_JPRB, 0.522771E-01_JPRB, 0.500130E-01_JPRB, 0.483406E-01_JPRB /)

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART37',1,ZHOOK_HANDLE)
END SUBROUTINE PART37


SUBROUTINE PART38

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART38',0,ZHOOK_HANDLE)



!     -----------------------------------------------------------------
!     The array SELFREF contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREF(:, 1) = (/ &
 & 0.160537E-01_JPRB, 0.149038E-01_JPRB, 0.138363E-01_JPRB, 0.128452E-01_JPRB, 0.119251E-01_JPRB, &
 & 0.110709E-01_JPRB, 0.102779E-01_JPRB, 0.954175E-02_JPRB, 0.885829E-02_JPRB, 0.822379E-02_JPRB /)  
SELFREF(:, 2) = (/ &
 & 0.365753E-01_JPRB, 0.342267E-01_JPRB, 0.320288E-01_JPRB, 0.299720E-01_JPRB, 0.280474E-01_JPRB, &
 & 0.262463E-01_JPRB, 0.245609E-01_JPRB, 0.229837E-01_JPRB, 0.215078E-01_JPRB, 0.201267E-01_JPRB /)  
SELFREF(:, 3) = (/ &
 & 0.127419E+00_JPRB, 0.118553E+00_JPRB, 0.110304E+00_JPRB, 0.102629E+00_JPRB, 0.954883E-01_JPRB, &
 & 0.888442E-01_JPRB, 0.826624E-01_JPRB, 0.769107E-01_JPRB, 0.715593E-01_JPRB, 0.665802E-01_JPRB /)  
SELFREF(:, 4) = (/ &
 & 0.378687E+00_JPRB, 0.348961E+00_JPRB, 0.321568E+00_JPRB, 0.296325E+00_JPRB, 0.273064E+00_JPRB, &
 & 0.251629E+00_JPRB, 0.231876E+00_JPRB, 0.213674E+00_JPRB, 0.196901E+00_JPRB, 0.181444E+00_JPRB /)  
SELFREF(:, 5) = (/ &
 & 0.472822E+00_JPRB, 0.435018E+00_JPRB, 0.400236E+00_JPRB, 0.368236E+00_JPRB, 0.338794E+00_JPRB, &
 & 0.311706E+00_JPRB, 0.286783E+00_JPRB, 0.263854E+00_JPRB, 0.242757E+00_JPRB, 0.223348E+00_JPRB /)  
SELFREF(:, 6) = (/ &
 & 0.505620E+00_JPRB, 0.465050E+00_JPRB, 0.427736E+00_JPRB, 0.393416E+00_JPRB, 0.361849E+00_JPRB, &
 & 0.332815E+00_JPRB, 0.306111E+00_JPRB, 0.281550E+00_JPRB, 0.258959E+00_JPRB, 0.238181E+00_JPRB /)  
SELFREF(:, 7) = (/ &
 & 0.530488E+00_JPRB, 0.487993E+00_JPRB, 0.448902E+00_JPRB, 0.412943E+00_JPRB, 0.379864E+00_JPRB, &
 & 0.349434E+00_JPRB, 0.321443E+00_JPRB, 0.295694E+00_JPRB, 0.272007E+00_JPRB, 0.250218E+00_JPRB /)  
SELFREF(:, 8) = (/ &
 & 0.540222E+00_JPRB, 0.497746E+00_JPRB, 0.458610E+00_JPRB, 0.422551E+00_JPRB, 0.389327E+00_JPRB, &
 & 0.358716E+00_JPRB, 0.330511E+00_JPRB, 0.304524E+00_JPRB, 0.280580E+00_JPRB, 0.258519E+00_JPRB /)  
SELFREF(:, 9) = (/ &
 & 0.565727E+00_JPRB, 0.522899E+00_JPRB, 0.483313E+00_JPRB, 0.446724E+00_JPRB, 0.412905E+00_JPRB, &
 & 0.381646E+00_JPRB, 0.352753E+00_JPRB, 0.326048E+00_JPRB, 0.301365E+00_JPRB, 0.278550E+00_JPRB /)  
SELFREF(:,10) = (/ &
 & 0.610122E+00_JPRB, 0.562337E+00_JPRB, 0.518295E+00_JPRB, 0.477702E+00_JPRB, 0.440289E+00_JPRB, &
 & 0.405806E+00_JPRB, 0.374023E+00_JPRB, 0.344730E+00_JPRB, 0.317730E+00_JPRB, 0.292846E+00_JPRB /)  
SELFREF(:,11) = (/ &
 & 0.645176E+00_JPRB, 0.588957E+00_JPRB, 0.537636E+00_JPRB, 0.490788E+00_JPRB, 0.448022E+00_JPRB, &
 & 0.408982E+00_JPRB, 0.373344E+00_JPRB, 0.340812E+00_JPRB, 0.311114E+00_JPRB, 0.284004E+00_JPRB /)  
SELFREF(:,12) = (/ &
 & 0.651737E+00_JPRB, 0.596547E+00_JPRB, 0.546031E+00_JPRB, 0.499792E+00_JPRB, 0.457469E+00_JPRB, &
 & 0.418730E+00_JPRB, 0.383272E+00_JPRB, 0.350816E+00_JPRB, 0.321108E+00_JPRB, 0.293916E+00_JPRB /)  
SELFREF(:,13) = (/ &
 & 0.661086E+00_JPRB, 0.607954E+00_JPRB, 0.559093E+00_JPRB, 0.514159E+00_JPRB, 0.472836E+00_JPRB, &
 & 0.434834E+00_JPRB, 0.399886E+00_JPRB, 0.367747E+00_JPRB, 0.338191E+00_JPRB, 0.311011E+00_JPRB /)  
SELFREF(:,14) = (/ &
 & 0.692554E+00_JPRB, 0.635574E+00_JPRB, 0.583282E+00_JPRB, 0.535293E+00_JPRB, 0.491251E+00_JPRB, &
 & 0.450834E+00_JPRB, 0.413741E+00_JPRB, 0.379701E+00_JPRB, 0.348461E+00_JPRB, 0.319791E+00_JPRB /)  
SELFREF(:,15) = (/ &
 & 0.714646E+00_JPRB, 0.657179E+00_JPRB, 0.604334E+00_JPRB, 0.555737E+00_JPRB, 0.511049E+00_JPRB, &
 & 0.469954E+00_JPRB, 0.432164E+00_JPRB, 0.397412E+00_JPRB, 0.365455E+00_JPRB, 0.336068E+00_JPRB /)  
SELFREF(:,16) = (/ &
 & 0.782126E+00_JPRB, 0.710682E+00_JPRB, 0.645764E+00_JPRB, 0.586776E+00_JPRB, 0.533177E+00_JPRB, &
 & 0.484473E+00_JPRB, 0.440219E+00_JPRB, 0.400007E+00_JPRB, 0.363468E+00_JPRB, 0.330266E+00_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB17:PART38',1,ZHOOK_HANDLE)
END SUBROUTINE PART38


END SUBROUTINE SRTM_KGB17
