!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif
!pgi$r opt=0 
SUBROUTINE RRTM_KGB15

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 15:  2380-2600 cm-1 (low - N2O,CO2; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOERRTO15, ONLY : KAO     ,SELFREFO   ,FRACREFAO
USE YOERRTA15, ONLY : STRRAT

!     ------------------------------------------------------------------

IMPLICIT NONE
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('RRTM_KGB15',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2
CALL PART3
CALL PART4
CALL PART5
CALL PART6
CALL PART7
CALL PART8
CALL PART9
CALL PART10
CALL PART11
CALL PART12

IF (LHOOK) CALL DR_HOOK('RRTM_KGB15',1,ZHOOK_HANDLE)

!     -----------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART1',0,ZHOOK_HANDLE)


STRRAT = 0.2883201_JPRB

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.

KAO( :, 1, 1, 1) = (/&
 & 4.2962E-03_JPRB,1.5232E-02_JPRB,1.9579E-02_JPRB,2.1453E-02_JPRB,2.1148E-02_JPRB,1.9096E-02_JPRB,&
 & 1.5358E-02_JPRB,9.6936E-03_JPRB,2.2149E+00_JPRB/)  
KAO( :, 2, 1, 1) = (/&
 & 4.2518E-03_JPRB,1.5711E-02_JPRB,2.0424E-02_JPRB,2.2179E-02_JPRB,2.1702E-02_JPRB,1.9467E-02_JPRB,&
 & 1.5548E-02_JPRB,9.9480E-03_JPRB,2.1772E+00_JPRB/)  
KAO( :, 3, 1, 1) = (/&
 & 4.2138E-03_JPRB,1.6217E-02_JPRB,2.1181E-02_JPRB,2.2786E-02_JPRB,2.2148E-02_JPRB,1.9747E-02_JPRB,&
 & 1.5738E-02_JPRB,1.0309E-02_JPRB,2.1464E+00_JPRB/)  
KAO( :, 4, 1, 1) = (/&
 & 4.1834E-03_JPRB,1.6748E-02_JPRB,2.1843E-02_JPRB,2.3305E-02_JPRB,2.2496E-02_JPRB,1.9972E-02_JPRB,&
 & 1.5965E-02_JPRB,1.0775E-02_JPRB,2.1191E+00_JPRB/)  
KAO( :, 5, 1, 1) = (/&
 & 4.1558E-03_JPRB,1.7275E-02_JPRB,2.2401E-02_JPRB,2.3742E-02_JPRB,2.2783E-02_JPRB,2.0184E-02_JPRB,&
 & 1.6265E-02_JPRB,1.1330E-02_JPRB,2.0949E+00_JPRB/)  
KAO( :, 1, 2, 1) = (/&
 & 3.2144E-03_JPRB,1.2713E-02_JPRB,1.6397E-02_JPRB,1.7964E-02_JPRB,1.7671E-02_JPRB,1.5897E-02_JPRB,&
 & 1.2690E-02_JPRB,7.9486E-03_JPRB,1.7669E+00_JPRB/)  
KAO( :, 2, 2, 1) = (/&
 & 3.1641E-03_JPRB,1.3084E-02_JPRB,1.7085E-02_JPRB,1.8507E-02_JPRB,1.8077E-02_JPRB,1.6151E-02_JPRB,&
 & 1.2818E-02_JPRB,8.1279E-03_JPRB,1.7352E+00_JPRB/)  
KAO( :, 3, 2, 1) = (/&
 & 3.1193E-03_JPRB,1.3476E-02_JPRB,1.7665E-02_JPRB,1.8949E-02_JPRB,1.8392E-02_JPRB,1.6337E-02_JPRB,&
 & 1.2943E-02_JPRB,8.3974E-03_JPRB,1.7079E+00_JPRB/)  
KAO( :, 4, 2, 1) = (/&
 & 3.0784E-03_JPRB,1.3887E-02_JPRB,1.8147E-02_JPRB,1.9317E-02_JPRB,1.8624E-02_JPRB,1.6477E-02_JPRB,&
 & 1.3099E-02_JPRB,8.7556E-03_JPRB,1.6824E+00_JPRB/)  
KAO( :, 5, 2, 1) = (/&
 & 3.0409E-03_JPRB,1.4281E-02_JPRB,1.8529E-02_JPRB,1.9610E-02_JPRB,1.8808E-02_JPRB,1.6609E-02_JPRB,&
 & 1.3316E-02_JPRB,9.1921E-03_JPRB,1.6588E+00_JPRB/)  
KAO( :, 1, 3, 1) = (/&
 & 2.3395E-03_JPRB,1.0516E-02_JPRB,1.3567E-02_JPRB,1.4918E-02_JPRB,1.4648E-02_JPRB,1.3103E-02_JPRB,&
 & 1.0421E-02_JPRB,6.4902E-03_JPRB,1.3955E+00_JPRB/)  
KAO( :, 2, 3, 1) = (/&
 & 2.2828E-03_JPRB,1.0805E-02_JPRB,1.4151E-02_JPRB,1.5331E-02_JPRB,1.4952E-02_JPRB,1.3287E-02_JPRB,&
 & 1.0515E-02_JPRB,6.5971E-03_JPRB,1.3684E+00_JPRB/)  
KAO( :, 3, 3, 1) = (/&
 & 2.2291E-03_JPRB,1.1094E-02_JPRB,1.4601E-02_JPRB,1.5662E-02_JPRB,1.5177E-02_JPRB,1.3417E-02_JPRB,&
 & 1.0594E-02_JPRB,6.7764E-03_JPRB,1.3430E+00_JPRB/)  
KAO( :, 4, 3, 1) = (/&
 & 2.1795E-03_JPRB,1.1390E-02_JPRB,1.4954E-02_JPRB,1.5923E-02_JPRB,1.5330E-02_JPRB,1.3512E-02_JPRB,&
 & 1.0687E-02_JPRB,7.0307E-03_JPRB,1.3188E+00_JPRB/)  
KAO( :, 5, 3, 1) = (/&
 & 2.1341E-03_JPRB,1.1671E-02_JPRB,1.5220E-02_JPRB,1.6118E-02_JPRB,1.5441E-02_JPRB,1.3589E-02_JPRB,&
 & 1.0824E-02_JPRB,7.3529E-03_JPRB,1.2961E+00_JPRB/)  
KAO( :, 1, 4, 1) = (/&
 & 1.7840E-03_JPRB,8.7256E-03_JPRB,1.1210E-02_JPRB,1.2367E-02_JPRB,1.2063E-02_JPRB,1.0762E-02_JPRB,&
 & 8.5444E-03_JPRB,5.3058E-03_JPRB,1.1276E+00_JPRB/)  
KAO( :, 2, 4, 1) = (/&
 & 1.7259E-03_JPRB,8.9625E-03_JPRB,1.1715E-02_JPRB,1.2698E-02_JPRB,1.2306E-02_JPRB,1.0908E-02_JPRB,&
 & 8.6186E-03_JPRB,5.3631E-03_JPRB,1.1050E+00_JPRB/)  
KAO( :, 3, 4, 1) = (/&
 & 1.6740E-03_JPRB,9.1828E-03_JPRB,1.2089E-02_JPRB,1.2950E-02_JPRB,1.2485E-02_JPRB,1.1008E-02_JPRB,&
 & 8.6759E-03_JPRB,5.4730E-03_JPRB,1.0830E+00_JPRB/)  
KAO( :, 4, 4, 1) = (/&
 & 1.6269E-03_JPRB,9.4080E-03_JPRB,1.2363E-02_JPRB,1.3144E-02_JPRB,1.2603E-02_JPRB,1.1084E-02_JPRB,&
 & 8.7331E-03_JPRB,5.6457E-03_JPRB,1.0617E+00_JPRB/)  
KAO( :, 5, 4, 1) = (/&
 & 1.5826E-03_JPRB,9.6219E-03_JPRB,1.2561E-02_JPRB,1.3277E-02_JPRB,1.2681E-02_JPRB,1.1138E-02_JPRB,&
 & 8.8166E-03_JPRB,5.8778E-03_JPRB,1.0410E+00_JPRB/)  
KAO( :, 1, 5, 1) = (/&
 & 1.4218E-03_JPRB,7.2507E-03_JPRB,9.2498E-03_JPRB,1.0184E-02_JPRB,9.8965E-03_JPRB,8.8186E-03_JPRB,&
 & 6.9985E-03_JPRB,4.3450E-03_JPRB,9.2779E-01_JPRB/)  
KAO( :, 2, 5, 1) = (/&
 & 1.3666E-03_JPRB,7.4483E-03_JPRB,9.6959E-03_JPRB,1.0459E-02_JPRB,1.0098E-02_JPRB,8.9432E-03_JPRB,&
 & 7.0603E-03_JPRB,4.3726E-03_JPRB,9.0832E-01_JPRB/)  
KAO( :, 3, 5, 1) = (/&
 & 1.3168E-03_JPRB,7.6293E-03_JPRB,1.0015E-02_JPRB,1.0662E-02_JPRB,1.0249E-02_JPRB,9.0283E-03_JPRB,&
 & 7.1071E-03_JPRB,4.4354E-03_JPRB,8.8937E-01_JPRB/)  
KAO( :, 4, 5, 1) = (/&
 & 1.2715E-03_JPRB,7.8071E-03_JPRB,1.0236E-02_JPRB,1.0812E-02_JPRB,1.0352E-02_JPRB,9.0911E-03_JPRB,&
 & 7.1478E-03_JPRB,4.5476E-03_JPRB,8.7061E-01_JPRB/)  
KAO( :, 5, 5, 1) = (/&
 & 1.2303E-03_JPRB,7.9773E-03_JPRB,1.0389E-02_JPRB,1.0918E-02_JPRB,1.0419E-02_JPRB,9.1375E-03_JPRB,&
 & 7.1984E-03_JPRB,4.7106E-03_JPRB,8.5172E-01_JPRB/)  
KAO( :, 1, 6, 1) = (/&
 & 1.1609E-03_JPRB,5.9982E-03_JPRB,7.5441E-03_JPRB,8.3219E-03_JPRB,8.0915E-03_JPRB,7.2051E-03_JPRB,&
 & 5.7215E-03_JPRB,3.5604E-03_JPRB,7.7269E-01_JPRB/)  
KAO( :, 2, 6, 1) = (/&
 & 1.1108E-03_JPRB,6.1686E-03_JPRB,7.9597E-03_JPRB,8.5717E-03_JPRB,8.2612E-03_JPRB,7.3195E-03_JPRB,&
 & 5.7777E-03_JPRB,3.5731E-03_JPRB,7.5578E-01_JPRB/)  
KAO( :, 3, 6, 1) = (/&
 & 1.0654E-03_JPRB,6.3243E-03_JPRB,8.2392E-03_JPRB,8.7441E-03_JPRB,8.3924E-03_JPRB,7.3948E-03_JPRB,&
 & 5.8188E-03_JPRB,3.6047E-03_JPRB,7.3901E-01_JPRB/)  
KAO( :, 4, 6, 1) = (/&
 & 1.0238E-03_JPRB,6.4720E-03_JPRB,8.4331E-03_JPRB,8.8696E-03_JPRB,8.4869E-03_JPRB,7.4498E-03_JPRB,&
 & 5.8508E-03_JPRB,3.6714E-03_JPRB,7.2195E-01_JPRB/)  
KAO( :, 5, 6, 1) = (/&
 & 9.8558E-04_JPRB,6.6127E-03_JPRB,8.5578E-03_JPRB,8.9617E-03_JPRB,8.5506E-03_JPRB,7.4929E-03_JPRB,&
 & 5.8848E-03_JPRB,3.7810E-03_JPRB,7.0447E-01_JPRB/)  
KAO( :, 1, 7, 1) = (/&
 & 9.5793E-04_JPRB,4.9392E-03_JPRB,6.0959E-03_JPRB,6.7658E-03_JPRB,6.6008E-03_JPRB,5.8761E-03_JPRB,&
 & 4.6722E-03_JPRB,2.9165E-03_JPRB,6.5237E-01_JPRB/)  
KAO( :, 2, 7, 1) = (/&
 & 9.1189E-04_JPRB,5.0775E-03_JPRB,6.4806E-03_JPRB,7.0004E-03_JPRB,6.7455E-03_JPRB,5.9796E-03_JPRB,&
 & 4.7234E-03_JPRB,2.9250E-03_JPRB,6.3689E-01_JPRB/)  
KAO( :, 3, 7, 1) = (/&
 & 8.7036E-04_JPRB,5.2121E-03_JPRB,6.7389E-03_JPRB,7.1547E-03_JPRB,6.8614E-03_JPRB,6.0502E-03_JPRB,&
 & 4.7609E-03_JPRB,2.9391E-03_JPRB,6.2141E-01_JPRB/)  
KAO( :, 4, 7, 1) = (/&
 & 8.3275E-04_JPRB,5.3378E-03_JPRB,6.9169E-03_JPRB,7.2639E-03_JPRB,6.9474E-03_JPRB,6.1007E-03_JPRB,&
 & 4.7893E-03_JPRB,2.9754E-03_JPRB,6.0575E-01_JPRB/)  
KAO( :, 5, 7, 1) = (/&
 & 7.9855E-04_JPRB,5.4591E-03_JPRB,7.0288E-03_JPRB,7.3444E-03_JPRB,7.0074E-03_JPRB,6.1400E-03_JPRB,&
 & 4.8149E-03_JPRB,3.0449E-03_JPRB,5.8968E-01_JPRB/)  
KAO( :, 1, 8, 1) = (/&
 & 7.9465E-04_JPRB,4.0550E-03_JPRB,4.9071E-03_JPRB,5.4722E-03_JPRB,5.3709E-03_JPRB,4.7864E-03_JPRB,&
 & 3.8134E-03_JPRB,2.3876E-03_JPRB,5.5983E-01_JPRB/)  
KAO( :, 2, 8, 1) = (/&
 & 7.5211E-04_JPRB,4.1645E-03_JPRB,5.2395E-03_JPRB,5.6983E-03_JPRB,5.5014E-03_JPRB,4.8765E-03_JPRB,&
 & 3.8582E-03_JPRB,2.3958E-03_JPRB,5.4541E-01_JPRB/)  
KAO( :, 3, 8, 1) = (/&
 & 7.1425E-04_JPRB,4.2775E-03_JPRB,5.4907E-03_JPRB,5.8442E-03_JPRB,5.6010E-03_JPRB,4.9449E-03_JPRB,&
 & 3.8932E-03_JPRB,2.4025E-03_JPRB,5.3089E-01_JPRB/)  
KAO( :, 4, 8, 1) = (/&
 & 6.8017E-04_JPRB,4.3807E-03_JPRB,5.6532E-03_JPRB,5.9396E-03_JPRB,5.6779E-03_JPRB,4.9919E-03_JPRB,&
 & 3.9191E-03_JPRB,2.4205E-03_JPRB,5.1625E-01_JPRB/)  
KAO( :, 5, 8, 1) = (/&
 & 6.4915E-04_JPRB,4.4822E-03_JPRB,5.7602E-03_JPRB,6.0112E-03_JPRB,5.7346E-03_JPRB,5.0274E-03_JPRB,&
 & 3.9402E-03_JPRB,2.4616E-03_JPRB,5.0156E-01_JPRB/)  
KAO( :, 1, 9, 1) = (/&
 & 6.6256E-04_JPRB,3.3231E-03_JPRB,3.9423E-03_JPRB,4.3965E-03_JPRB,4.3550E-03_JPRB,3.8950E-03_JPRB,&
 & 3.1106E-03_JPRB,1.9527E-03_JPRB,4.7909E-01_JPRB/)  
KAO( :, 2, 9, 1) = (/&
 & 6.2337E-04_JPRB,3.4093E-03_JPRB,4.2109E-03_JPRB,4.6231E-03_JPRB,4.4821E-03_JPRB,3.9733E-03_JPRB,&
 & 3.1493E-03_JPRB,1.9618E-03_JPRB,4.6525E-01_JPRB/)  
KAO( :, 3, 9, 1) = (/&
 & 5.8859E-04_JPRB,3.5021E-03_JPRB,4.4524E-03_JPRB,4.7638E-03_JPRB,4.5675E-03_JPRB,4.0358E-03_JPRB,&
 & 3.1809E-03_JPRB,1.9669E-03_JPRB,4.5157E-01_JPRB/)  
KAO( :, 4, 9, 1) = (/&
 & 5.5740E-04_JPRB,3.5874E-03_JPRB,4.6083E-03_JPRB,4.8522E-03_JPRB,4.6363E-03_JPRB,4.0813E-03_JPRB,&
 & 3.2054E-03_JPRB,1.9751E-03_JPRB,4.3811E-01_JPRB/)  
KAO( :, 5, 9, 1) = (/&
 & 5.2927E-04_JPRB,3.6711E-03_JPRB,4.7102E-03_JPRB,4.9155E-03_JPRB,4.6887E-03_JPRB,4.1135E-03_JPRB,&
 & 3.2248E-03_JPRB,1.9974E-03_JPRB,4.2484E-01_JPRB/)  
KAO( :, 1,10, 1) = (/&
 & 5.5819E-04_JPRB,2.7284E-03_JPRB,3.1809E-03_JPRB,3.5314E-03_JPRB,3.5278E-03_JPRB,3.1713E-03_JPRB,&
 & 2.5390E-03_JPRB,1.5979E-03_JPRB,4.1170E-01_JPRB/)  
KAO( :, 2,10, 1) = (/&
 & 5.2264E-04_JPRB,2.7960E-03_JPRB,3.3951E-03_JPRB,3.7490E-03_JPRB,3.6516E-03_JPRB,3.2397E-03_JPRB,&
 & 2.5727E-03_JPRB,1.6061E-03_JPRB,3.9866E-01_JPRB/)  
KAO( :, 3,10, 1) = (/&
 & 4.9139E-04_JPRB,2.8693E-03_JPRB,3.6092E-03_JPRB,3.8820E-03_JPRB,3.7278E-03_JPRB,3.2940E-03_JPRB,&
 & 2.5999E-03_JPRB,1.6112E-03_JPRB,3.8585E-01_JPRB/)  
KAO( :, 4,10, 1) = (/&
 & 4.6354E-04_JPRB,2.9405E-03_JPRB,3.7573E-03_JPRB,3.9654E-03_JPRB,3.7869E-03_JPRB,3.3368E-03_JPRB,&
 & 2.6225E-03_JPRB,1.6157E-03_JPRB,3.7334E-01_JPRB/)  
KAO( :, 5,10, 1) = (/&
 & 4.3854E-04_JPRB,3.0087E-03_JPRB,3.8506E-03_JPRB,4.0212E-03_JPRB,3.8338E-03_JPRB,3.3662E-03_JPRB,&
 & 2.6402E-03_JPRB,1.6279E-03_JPRB,3.6129E-01_JPRB/)  
KAO( :, 1,11, 1) = (/&
 & 4.5821E-04_JPRB,2.2621E-03_JPRB,2.6447E-03_JPRB,2.9297E-03_JPRB,2.9129E-03_JPRB,2.6105E-03_JPRB,&
 & 2.0860E-03_JPRB,1.3108E-03_JPRB,3.4781E-01_JPRB/)  
KAO( :, 2,11, 1) = (/&
 & 4.2863E-04_JPRB,2.3183E-03_JPRB,2.8194E-03_JPRB,3.0973E-03_JPRB,3.0077E-03_JPRB,2.6638E-03_JPRB,&
 & 2.1125E-03_JPRB,1.3172E-03_JPRB,3.3606E-01_JPRB/)  
KAO( :, 3,11, 1) = (/&
 & 4.0252E-04_JPRB,2.3779E-03_JPRB,2.9883E-03_JPRB,3.2000E-03_JPRB,3.0663E-03_JPRB,2.7064E-03_JPRB,&
 & 2.1343E-03_JPRB,1.3214E-03_JPRB,3.2458E-01_JPRB/)  
KAO( :, 4,11, 1) = (/&
 & 3.7927E-04_JPRB,2.4351E-03_JPRB,3.1025E-03_JPRB,3.2639E-03_JPRB,3.1126E-03_JPRB,2.7399E-03_JPRB,&
 & 2.1527E-03_JPRB,1.3253E-03_JPRB,3.1358E-01_JPRB/)  
KAO( :, 5,11, 1) = (/&
 & 3.5851E-04_JPRB,2.4897E-03_JPRB,3.1743E-03_JPRB,3.3073E-03_JPRB,3.1494E-03_JPRB,2.7631E-03_JPRB,&
 & 2.1670E-03_JPRB,1.3357E-03_JPRB,3.0304E-01_JPRB/)  
KAO( :, 1,12, 1) = (/&
 & 3.7566E-04_JPRB,1.8705E-03_JPRB,2.1955E-03_JPRB,2.4263E-03_JPRB,2.4027E-03_JPRB,2.1477E-03_JPRB,&
 & 1.7133E-03_JPRB,1.0753E-03_JPRB,2.9614E-01_JPRB/)  
KAO( :, 2,12, 1) = (/&
 & 3.5112E-04_JPRB,1.9175E-03_JPRB,2.3381E-03_JPRB,2.5565E-03_JPRB,2.4759E-03_JPRB,2.1892E-03_JPRB,&
 & 1.7343E-03_JPRB,1.0803E-03_JPRB,2.8551E-01_JPRB/)  
KAO( :, 3,12, 1) = (/&
 & 3.2946E-04_JPRB,1.9676E-03_JPRB,2.4711E-03_JPRB,2.6363E-03_JPRB,2.5213E-03_JPRB,2.2227E-03_JPRB,&
 & 1.7519E-03_JPRB,1.0837E-03_JPRB,2.7528E-01_JPRB/)  
KAO( :, 4,12, 1) = (/&
 & 3.1028E-04_JPRB,2.0138E-03_JPRB,2.5600E-03_JPRB,2.6860E-03_JPRB,2.5577E-03_JPRB,2.2494E-03_JPRB,&
 & 1.7667E-03_JPRB,1.0872E-03_JPRB,2.6557E-01_JPRB/)  
KAO( :, 5,12, 1) = (/&
 & 2.9320E-04_JPRB,2.0583E-03_JPRB,2.6161E-03_JPRB,2.7200E-03_JPRB,2.5866E-03_JPRB,2.2676E-03_JPRB,&
 & 1.7779E-03_JPRB,1.0961E-03_JPRB,2.5635E-01_JPRB/)  
KAO( :, 1,13, 1) = (/&
 & 3.0764E-04_JPRB,1.5429E-03_JPRB,1.8188E-03_JPRB,2.0063E-03_JPRB,1.9799E-03_JPRB,1.7660E-03_JPRB,&
 & 1.4068E-03_JPRB,8.8203E-04_JPRB,2.5899E-01_JPRB/)  
KAO( :, 2,13, 1) = (/&
 & 2.8735E-04_JPRB,1.5821E-03_JPRB,1.9364E-03_JPRB,2.1086E-03_JPRB,2.0369E-03_JPRB,1.7986E-03_JPRB,&
 & 1.4237E-03_JPRB,8.8599E-04_JPRB,2.4914E-01_JPRB/)  
KAO( :, 3,13, 1) = (/&
 & 2.6953E-04_JPRB,1.6236E-03_JPRB,2.0412E-03_JPRB,2.1709E-03_JPRB,2.0725E-03_JPRB,1.8251E-03_JPRB,&
 & 1.4376E-03_JPRB,8.8887E-04_JPRB,2.3982E-01_JPRB/)  
KAO( :, 4,13, 1) = (/&
 & 2.5380E-04_JPRB,1.6612E-03_JPRB,2.1113E-03_JPRB,2.2099E-03_JPRB,2.1013E-03_JPRB,1.8462E-03_JPRB,&
 & 1.4493E-03_JPRB,8.9188E-04_JPRB,2.3102E-01_JPRB/)  
KAO( :, 5,13, 1) = (/&
 & 2.3980E-04_JPRB,1.6979E-03_JPRB,2.1555E-03_JPRB,2.2365E-03_JPRB,2.1241E-03_JPRB,1.8607E-03_JPRB,&
 & 1.4583E-03_JPRB,8.9931E-04_JPRB,2.2279E-01_JPRB/)  
KAO( :, 1, 1, 2) = (/&
 & 7.0943E-03_JPRB,3.8387E-02_JPRB,4.3151E-02_JPRB,4.2731E-02_JPRB,4.0946E-02_JPRB,3.8949E-02_JPRB,&
 & 3.7362E-02_JPRB,3.5997E-02_JPRB,3.1543E+00_JPRB/)  
KAO( :, 2, 1, 2) = (/&
 & 7.0850E-03_JPRB,3.8454E-02_JPRB,4.2900E-02_JPRB,4.3028E-02_JPRB,4.2284E-02_JPRB,4.1753E-02_JPRB,&
 & 4.1711E-02_JPRB,4.1528E-02_JPRB,3.1189E+00_JPRB/)  
KAO( :, 3, 1, 2) = (/&
 & 7.0813E-03_JPRB,3.8363E-02_JPRB,4.2614E-02_JPRB,4.3463E-02_JPRB,4.3963E-02_JPRB,4.4905E-02_JPRB,&
 & 4.6271E-02_JPRB,4.7132E-02_JPRB,3.0948E+00_JPRB/)  
KAO( :, 4, 1, 2) = (/&
 & 7.0651E-03_JPRB,3.8151E-02_JPRB,4.2395E-02_JPRB,4.4068E-02_JPRB,4.5862E-02_JPRB,4.8163E-02_JPRB,&
 & 5.0764E-02_JPRB,5.2533E-02_JPRB,3.0805E+00_JPRB/)  
KAO( :, 5, 1, 2) = (/&
 & 7.0475E-03_JPRB,3.7840E-02_JPRB,4.2280E-02_JPRB,4.4809E-02_JPRB,4.7823E-02_JPRB,5.1372E-02_JPRB,&
 & 5.5020E-02_JPRB,5.7574E-02_JPRB,3.0698E+00_JPRB/)  
KAO( :, 1, 2, 2) = (/&
 & 5.4133E-03_JPRB,3.2388E-02_JPRB,3.6287E-02_JPRB,3.5903E-02_JPRB,3.4407E-02_JPRB,3.2747E-02_JPRB,&
 & 3.1453E-02_JPRB,3.0272E-02_JPRB,2.5533E+00_JPRB/)  
KAO( :, 2, 2, 2) = (/&
 & 5.3611E-03_JPRB,3.2430E-02_JPRB,3.6074E-02_JPRB,3.6216E-02_JPRB,3.5593E-02_JPRB,3.5203E-02_JPRB,&
 & 3.5194E-02_JPRB,3.4997E-02_JPRB,2.5086E+00_JPRB/)  
KAO( :, 3, 2, 2) = (/&
 & 5.3281E-03_JPRB,3.2322E-02_JPRB,3.5847E-02_JPRB,3.6639E-02_JPRB,3.7078E-02_JPRB,3.7935E-02_JPRB,&
 & 3.9143E-02_JPRB,3.9849E-02_JPRB,2.4723E+00_JPRB/)  
KAO( :, 4, 2, 2) = (/&
 & 5.3094E-03_JPRB,3.2112E-02_JPRB,3.5677E-02_JPRB,3.7178E-02_JPRB,3.8741E-02_JPRB,4.0767E-02_JPRB,&
 & 4.3021E-02_JPRB,4.4489E-02_JPRB,2.4475E+00_JPRB/)  
KAO( :, 5, 2, 2) = (/&
 & 5.2887E-03_JPRB,3.1839E-02_JPRB,3.5583E-02_JPRB,3.7831E-02_JPRB,4.0436E-02_JPRB,4.3525E-02_JPRB,&
 & 4.6680E-02_JPRB,4.8869E-02_JPRB,2.4311E+00_JPRB/)  
KAO( :, 1, 3, 2) = (/&
 & 4.0611E-03_JPRB,2.7170E-02_JPRB,3.0405E-02_JPRB,3.0026E-02_JPRB,2.8647E-02_JPRB,2.7115E-02_JPRB,&
 & 2.5770E-02_JPRB,2.4484E-02_JPRB,2.0491E+00_JPRB/)  
KAO( :, 2, 3, 2) = (/&
 & 3.9775E-03_JPRB,2.7189E-02_JPRB,3.0241E-02_JPRB,3.0301E-02_JPRB,2.9626E-02_JPRB,2.9114E-02_JPRB,&
 & 2.8843E-02_JPRB,2.8434E-02_JPRB,1.9991E+00_JPRB/)  
KAO( :, 3, 3, 2) = (/&
 & 3.9065E-03_JPRB,2.7099E-02_JPRB,3.0059E-02_JPRB,3.0647E-02_JPRB,3.0854E-02_JPRB,3.1397E-02_JPRB,&
 & 3.2170E-02_JPRB,3.2541E-02_JPRB,1.9562E+00_JPRB/)  
KAO( :, 4, 3, 2) = (/&
 & 3.8466E-03_JPRB,2.6925E-02_JPRB,2.9905E-02_JPRB,3.1087E-02_JPRB,3.2235E-02_JPRB,3.3772E-02_JPRB,&
 & 3.5477E-02_JPRB,3.6558E-02_JPRB,1.9207E+00_JPRB/)  
KAO( :, 5, 3, 2) = (/&
 & 3.7983E-03_JPRB,2.6668E-02_JPRB,2.9797E-02_JPRB,3.1593E-02_JPRB,3.3666E-02_JPRB,3.6136E-02_JPRB,&
 & 3.8655E-02_JPRB,4.0337E-02_JPRB,1.8904E+00_JPRB/)  
KAO( :, 1, 4, 2) = (/&
 & 3.1618E-03_JPRB,2.2735E-02_JPRB,2.5430E-02_JPRB,2.5073E-02_JPRB,2.3860E-02_JPRB,2.2346E-02_JPRB,&
 & 2.0906E-02_JPRB,1.9493E-02_JPRB,1.6815E+00_JPRB/)  
KAO( :, 2, 4, 2) = (/&
 & 3.0772E-03_JPRB,2.2769E-02_JPRB,2.5323E-02_JPRB,2.5294E-02_JPRB,2.4614E-02_JPRB,2.3917E-02_JPRB,&
 & 2.3363E-02_JPRB,2.2717E-02_JPRB,1.6300E+00_JPRB/)  
KAO( :, 3, 4, 2) = (/&
 & 2.9989E-03_JPRB,2.2705E-02_JPRB,2.5187E-02_JPRB,2.5585E-02_JPRB,2.5590E-02_JPRB,2.5772E-02_JPRB,&
 & 2.6101E-02_JPRB,2.6159E-02_JPRB,1.5868E+00_JPRB/)  
KAO( :, 4, 4, 2) = (/&
 & 2.9269E-03_JPRB,2.2567E-02_JPRB,2.5061E-02_JPRB,2.5933E-02_JPRB,2.6708E-02_JPRB,2.7738E-02_JPRB,&
 & 2.8897E-02_JPRB,2.9580E-02_JPRB,1.5492E+00_JPRB/)  
KAO( :, 5, 4, 2) = (/&
 & 2.8633E-03_JPRB,2.2345E-02_JPRB,2.4951E-02_JPRB,2.6338E-02_JPRB,2.7898E-02_JPRB,2.9732E-02_JPRB,&
 & 3.1610E-02_JPRB,3.2830E-02_JPRB,1.5179E+00_JPRB/)  
KAO( :, 1, 5, 2) = (/&
 & 2.5495E-03_JPRB,1.8985E-02_JPRB,2.1259E-02_JPRB,2.0956E-02_JPRB,1.9882E-02_JPRB,1.8351E-02_JPRB,&
 & 1.6812E-02_JPRB,1.5262E-02_JPRB,1.4081E+00_JPRB/)  
KAO( :, 2, 5, 2) = (/&
 & 2.4663E-03_JPRB,1.9038E-02_JPRB,2.1177E-02_JPRB,2.1145E-02_JPRB,2.0437E-02_JPRB,1.9579E-02_JPRB,&
 & 1.8803E-02_JPRB,1.7942E-02_JPRB,1.3595E+00_JPRB/)  
KAO( :, 3, 5, 2) = (/&
 & 2.3921E-03_JPRB,1.9006E-02_JPRB,2.1089E-02_JPRB,2.1375E-02_JPRB,2.1189E-02_JPRB,2.1072E-02_JPRB,&
 & 2.1043E-02_JPRB,2.0814E-02_JPRB,1.3176E+00_JPRB/)  
KAO( :, 4, 5, 2) = (/&
 & 2.3238E-03_JPRB,1.8899E-02_JPRB,2.0991E-02_JPRB,2.1643E-02_JPRB,2.2082E-02_JPRB,2.2687E-02_JPRB,&
 & 2.3376E-02_JPRB,2.3722E-02_JPRB,1.2814E+00_JPRB/)  
KAO( :, 5, 5, 2) = (/&
 & 2.2609E-03_JPRB,1.8711E-02_JPRB,2.0886E-02_JPRB,2.1958E-02_JPRB,2.3037E-02_JPRB,2.4321E-02_JPRB,&
 & 2.5657E-02_JPRB,2.6474E-02_JPRB,1.2502E+00_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART2',0,ZHOOK_HANDLE)


KAO( :, 1, 6, 2) = (/&
 & 2.1136E-03_JPRB,1.5844E-02_JPRB,1.7815E-02_JPRB,1.7475E-02_JPRB,1.6448E-02_JPRB,1.4925E-02_JPRB,&
 & 1.3323E-02_JPRB,1.1714E-02_JPRB,1.1933E+00_JPRB/)  
KAO( :, 2, 6, 2) = (/&
 & 2.0306E-03_JPRB,1.5911E-02_JPRB,1.7725E-02_JPRB,1.7645E-02_JPRB,1.6857E-02_JPRB,1.5846E-02_JPRB,&
 & 1.4877E-02_JPRB,1.3852E-02_JPRB,1.1478E+00_JPRB/)  
KAO( :, 3, 6, 2) = (/&
 & 1.9573E-03_JPRB,1.5900E-02_JPRB,1.7665E-02_JPRB,1.7815E-02_JPRB,1.7433E-02_JPRB,1.7030E-02_JPRB,&
 & 1.6681E-02_JPRB,1.6204E-02_JPRB,1.1091E+00_JPRB/)  
KAO( :, 4, 6, 2) = (/&
 & 1.8915E-03_JPRB,1.5823E-02_JPRB,1.7587E-02_JPRB,1.8019E-02_JPRB,1.8141E-02_JPRB,1.8355E-02_JPRB,&
 & 1.8615E-02_JPRB,1.8633E-02_JPRB,1.0755E+00_JPRB/)  
KAO( :, 5, 6, 2) = (/&
 & 1.8316E-03_JPRB,1.5671E-02_JPRB,1.7495E-02_JPRB,1.8250E-02_JPRB,1.8907E-02_JPRB,1.9704E-02_JPRB,&
 & 2.0534E-02_JPRB,2.0986E-02_JPRB,1.0458E+00_JPRB/)  
KAO( :, 1, 7, 2) = (/&
 & 1.7779E-03_JPRB,1.3214E-02_JPRB,1.4915E-02_JPRB,1.4490E-02_JPRB,1.3534E-02_JPRB,1.2115E-02_JPRB,&
 & 1.0525E-02_JPRB,8.9151E-03_JPRB,1.0250E+00_JPRB/)  
KAO( :, 2, 7, 2) = (/&
 & 1.6955E-03_JPRB,1.3308E-02_JPRB,1.4823E-02_JPRB,1.4622E-02_JPRB,1.3840E-02_JPRB,1.2763E-02_JPRB,&
 & 1.1685E-02_JPRB,1.0574E-02_JPRB,9.8268E-01_JPRB/)  
KAO( :, 3, 7, 2) = (/&
 & 1.6237E-03_JPRB,1.3311E-02_JPRB,1.4766E-02_JPRB,1.4761E-02_JPRB,1.4249E-02_JPRB,1.3650E-02_JPRB,&
 & 1.3091E-02_JPRB,1.2450E-02_JPRB,9.4696E-01_JPRB/)  
KAO( :, 4, 7, 2) = (/&
 & 1.5603E-03_JPRB,1.3256E-02_JPRB,1.4695E-02_JPRB,1.4910E-02_JPRB,1.4782E-02_JPRB,1.4700E-02_JPRB,&
 & 1.4648E-02_JPRB,1.4438E-02_JPRB,9.1575E-01_JPRB/)  
KAO( :, 5, 7, 2) = (/&
 & 1.5029E-03_JPRB,1.3127E-02_JPRB,1.4617E-02_JPRB,1.5078E-02_JPRB,1.5382E-02_JPRB,1.5792E-02_JPRB,&
 & 1.6228E-02_JPRB,1.6399E-02_JPRB,8.8786E-01_JPRB/)  
KAO( :, 1, 8, 2) = (/&
 & 1.5020E-03_JPRB,1.1002E-02_JPRB,1.2408E-02_JPRB,1.1986E-02_JPRB,1.1101E-02_JPRB,9.8378E-03_JPRB,&
 & 8.3304E-03_JPRB,6.7732E-03_JPRB,8.9770E-01_JPRB/)  
KAO( :, 2, 8, 2) = (/&
 & 1.4230E-03_JPRB,1.1110E-02_JPRB,1.2342E-02_JPRB,1.2073E-02_JPRB,1.1340E-02_JPRB,1.0282E-02_JPRB,&
 & 9.1665E-03_JPRB,8.0270E-03_JPRB,8.5759E-01_JPRB/)  
KAO( :, 3, 8, 2) = (/&
 & 1.3543E-03_JPRB,1.1124E-02_JPRB,1.2281E-02_JPRB,1.2183E-02_JPRB,1.1624E-02_JPRB,1.0918E-02_JPRB,&
 & 1.0231E-02_JPRB,9.4957E-03_JPRB,8.2343E-01_JPRB/)  
KAO( :, 4, 8, 2) = (/&
 & 1.2937E-03_JPRB,1.1088E-02_JPRB,1.2220E-02_JPRB,1.2293E-02_JPRB,1.2008E-02_JPRB,1.1719E-02_JPRB,&
 & 1.1453E-02_JPRB,1.1081E-02_JPRB,7.9354E-01_JPRB/)  
KAO( :, 5, 8, 2) = (/&
 & 1.2398E-03_JPRB,1.0985E-02_JPRB,1.2152E-02_JPRB,1.2411E-02_JPRB,1.2469E-02_JPRB,1.2594E-02_JPRB,&
 & 1.2739E-02_JPRB,1.2705E-02_JPRB,7.6694E-01_JPRB/)  
KAO( :, 1, 9, 2) = (/&
 & 1.2772E-03_JPRB,9.1185E-03_JPRB,1.0283E-02_JPRB,9.9108E-03_JPRB,9.0933E-03_JPRB,7.9937E-03_JPRB,&
 & 6.6146E-03_JPRB,5.1482E-03_JPRB,7.8565E-01_JPRB/)  
KAO( :, 2, 9, 2) = (/&
 & 1.2008E-03_JPRB,9.2246E-03_JPRB,1.0254E-02_JPRB,9.9497E-03_JPRB,9.2744E-03_JPRB,8.2956E-03_JPRB,&
 & 7.1977E-03_JPRB,6.0715E-03_JPRB,7.4762E-01_JPRB/)  
KAO( :, 3, 9, 2) = (/&
 & 1.1346E-03_JPRB,9.2567E-03_JPRB,1.0190E-02_JPRB,1.0030E-02_JPRB,9.4797E-03_JPRB,8.7349E-03_JPRB,&
 & 7.9799E-03_JPRB,7.1919E-03_JPRB,7.1506E-01_JPRB/)  
KAO( :, 4, 9, 2) = (/&
 & 1.0767E-03_JPRB,9.2317E-03_JPRB,1.0137E-02_JPRB,1.0114E-02_JPRB,9.7458E-03_JPRB,9.3188E-03_JPRB,&
 & 8.9121E-03_JPRB,8.4415E-03_JPRB,6.8636E-01_JPRB/)  
KAO( :, 5, 9, 2) = (/&
 & 1.0254E-03_JPRB,9.1543E-03_JPRB,1.0077E-02_JPRB,1.0198E-02_JPRB,1.0088E-02_JPRB,1.0005E-02_JPRB,&
 & 9.9430E-03_JPRB,9.7610E-03_JPRB,6.6072E-01_JPRB/)  
KAO( :, 1,10, 2) = (/&
 & 1.0908E-03_JPRB,7.5349E-03_JPRB,8.5055E-03_JPRB,8.1913E-03_JPRB,7.4594E-03_JPRB,6.5117E-03_JPRB,&
 & 5.3043E-03_JPRB,3.9738E-03_JPRB,6.8647E-01_JPRB/)  
KAO( :, 2,10, 2) = (/&
 & 1.0219E-03_JPRB,7.6350E-03_JPRB,8.4942E-03_JPRB,8.2002E-03_JPRB,7.5922E-03_JPRB,6.7288E-03_JPRB,&
 & 5.7099E-03_JPRB,4.6532E-03_JPRB,6.5148E-01_JPRB/)  
KAO( :, 3,10, 2) = (/&
 & 9.6216E-04_JPRB,7.6768E-03_JPRB,8.4412E-03_JPRB,8.2544E-03_JPRB,7.7463E-03_JPRB,7.0316E-03_JPRB,&
 & 6.2789E-03_JPRB,5.5007E-03_JPRB,6.2153E-01_JPRB/)  
KAO( :, 4,10, 2) = (/&
 & 9.0949E-04_JPRB,7.6636E-03_JPRB,8.3915E-03_JPRB,8.3156E-03_JPRB,7.9306E-03_JPRB,7.4536E-03_JPRB,&
 & 6.9877E-03_JPRB,6.4813E-03_JPRB,5.9517E-01_JPRB/)  
KAO( :, 5,10, 2) = (/&
 & 8.6244E-04_JPRB,7.6028E-03_JPRB,8.3387E-03_JPRB,8.3779E-03_JPRB,8.1810E-03_JPRB,7.9831E-03_JPRB,&
 & 7.7997E-03_JPRB,7.5371E-03_JPRB,5.7147E-01_JPRB/)  
KAO( :, 1,11, 2) = (/&
 & 9.0171E-04_JPRB,6.2591E-03_JPRB,7.0260E-03_JPRB,6.7592E-03_JPRB,6.1582E-03_JPRB,5.3757E-03_JPRB,&
 & 4.3823E-03_JPRB,3.2909E-03_JPRB,5.8305E-01_JPRB/)  
KAO( :, 2,11, 2) = (/&
 & 8.4471E-04_JPRB,6.3292E-03_JPRB,7.0117E-03_JPRB,6.7680E-03_JPRB,6.2644E-03_JPRB,5.5512E-03_JPRB,&
 & 4.7161E-03_JPRB,3.8488E-03_JPRB,5.5321E-01_JPRB/)  
KAO( :, 3,11, 2) = (/&
 & 7.9501E-04_JPRB,6.3542E-03_JPRB,6.9623E-03_JPRB,6.8076E-03_JPRB,6.3850E-03_JPRB,5.7984E-03_JPRB,&
 & 5.1814E-03_JPRB,4.5421E-03_JPRB,5.2752E-01_JPRB/)  
KAO( :, 4,11, 2) = (/&
 & 7.5106E-04_JPRB,6.3305E-03_JPRB,6.9164E-03_JPRB,6.8517E-03_JPRB,6.5339E-03_JPRB,6.1441E-03_JPRB,&
 & 5.7616E-03_JPRB,5.3442E-03_JPRB,5.0480E-01_JPRB/)  
KAO( :, 5,11, 2) = (/&
 & 7.1176E-04_JPRB,6.2680E-03_JPRB,6.8638E-03_JPRB,6.9010E-03_JPRB,6.7399E-03_JPRB,6.5787E-03_JPRB,&
 & 6.4276E-03_JPRB,6.2093E-03_JPRB,4.8460E-01_JPRB/)  
KAO( :, 1,12, 2) = (/&
 & 7.4344E-04_JPRB,5.1893E-03_JPRB,5.7960E-03_JPRB,5.5712E-03_JPRB,5.0774E-03_JPRB,4.4320E-03_JPRB,&
 & 3.6146E-03_JPRB,2.7192E-03_JPRB,4.9987E-01_JPRB/)  
KAO( :, 2,12, 2) = (/&
 & 6.9630E-04_JPRB,5.2389E-03_JPRB,5.7776E-03_JPRB,5.5769E-03_JPRB,5.1607E-03_JPRB,4.5730E-03_JPRB,&
 & 3.8872E-03_JPRB,3.1759E-03_JPRB,4.7411E-01_JPRB/)  
KAO( :, 3,12, 2) = (/&
 & 6.5505E-04_JPRB,5.2495E-03_JPRB,5.7335E-03_JPRB,5.6051E-03_JPRB,5.2555E-03_JPRB,4.7752E-03_JPRB,&
 & 4.2687E-03_JPRB,3.7439E-03_JPRB,4.5176E-01_JPRB/)  
KAO( :, 4,12, 2) = (/&
 & 6.1851E-04_JPRB,5.2199E-03_JPRB,5.6893E-03_JPRB,5.6379E-03_JPRB,5.3780E-03_JPRB,5.0596E-03_JPRB,&
 & 4.7451E-03_JPRB,4.4010E-03_JPRB,4.3213E-01_JPRB/)  
KAO( :, 5,12, 2) = (/&
 & 5.8564E-04_JPRB,5.1584E-03_JPRB,5.6408E-03_JPRB,5.6781E-03_JPRB,5.5493E-03_JPRB,5.4174E-03_JPRB,&
 & 5.2919E-03_JPRB,5.1102E-03_JPRB,4.1474E-01_JPRB/)  
KAO( :, 1,13, 2) = (/&
 & 6.1162E-04_JPRB,4.2978E-03_JPRB,4.7775E-03_JPRB,4.5861E-03_JPRB,4.1806E-03_JPRB,3.6483E-03_JPRB,&
 & 2.9761E-03_JPRB,2.2409E-03_JPRB,4.4173E-01_JPRB/)  
KAO( :, 2,13, 2) = (/&
 & 5.7264E-04_JPRB,4.3335E-03_JPRB,4.7546E-03_JPRB,4.5895E-03_JPRB,4.2458E-03_JPRB,3.7618E-03_JPRB,&
 & 3.1994E-03_JPRB,2.6153E-03_JPRB,4.1858E-01_JPRB/)  
KAO( :, 3,13, 2) = (/&
 & 5.3845E-04_JPRB,4.3324E-03_JPRB,4.7152E-03_JPRB,4.6098E-03_JPRB,4.3213E-03_JPRB,3.9280E-03_JPRB,&
 & 3.5124E-03_JPRB,3.0807E-03_JPRB,3.9852E-01_JPRB/)  
KAO( :, 4,13, 2) = (/&
 & 5.0800E-04_JPRB,4.3007E-03_JPRB,4.6739E-03_JPRB,4.6354E-03_JPRB,4.4237E-03_JPRB,4.1636E-03_JPRB,&
 & 3.9041E-03_JPRB,3.6190E-03_JPRB,3.8103E-01_JPRB/)  
KAO( :, 5,13, 2) = (/&
 & 4.8061E-04_JPRB,4.2432E-03_JPRB,4.6321E-03_JPRB,4.6674E-03_JPRB,4.5673E-03_JPRB,4.4592E-03_JPRB,&
 & 4.3539E-03_JPRB,4.2010E-03_JPRB,3.6549E-01_JPRB/)  
KAO( :, 1, 1, 3) = (/&
 & 1.1504E-02_JPRB,5.1115E-02_JPRB,6.3490E-02_JPRB,7.5739E-02_JPRB,8.9129E-02_JPRB,1.0261E-01_JPRB,&
 & 1.1510E-01_JPRB,1.2497E-01_JPRB,4.5470E+00_JPRB/)  
KAO( :, 2, 1, 3) = (/&
 & 1.1411E-02_JPRB,5.0441E-02_JPRB,6.4398E-02_JPRB,7.8958E-02_JPRB,9.4436E-02_JPRB,1.0965E-01_JPRB,&
 & 1.2371E-01_JPRB,1.3505E-01_JPRB,4.5111E+00_JPRB/)  
KAO( :, 3, 1, 3) = (/&
 & 1.1360E-02_JPRB,4.9859E-02_JPRB,6.5352E-02_JPRB,8.1890E-02_JPRB,9.8960E-02_JPRB,1.1556E-01_JPRB,&
 & 1.3095E-01_JPRB,1.4357E-01_JPRB,4.4964E+00_JPRB/)  
KAO( :, 4, 1, 3) = (/&
 & 1.1361E-02_JPRB,4.9396E-02_JPRB,6.6358E-02_JPRB,8.4565E-02_JPRB,1.0289E-01_JPRB,1.2064E-01_JPRB,&
 & 1.3719E-01_JPRB,1.5089E-01_JPRB,4.4952E+00_JPRB/)  
KAO( :, 5, 1, 3) = (/&
 & 1.1398E-02_JPRB,4.9071E-02_JPRB,6.7320E-02_JPRB,8.6942E-02_JPRB,1.0642E-01_JPRB,1.2520E-01_JPRB,&
 & 1.4278E-01_JPRB,1.5748E-01_JPRB,4.5069E+00_JPRB/)  
KAO( :, 1, 2, 3) = (/&
 & 9.0800E-03_JPRB,4.3518E-02_JPRB,5.4317E-02_JPRB,6.5007E-02_JPRB,7.6680E-02_JPRB,8.8428E-02_JPRB,&
 & 9.9245E-02_JPRB,1.0777E-01_JPRB,3.7305E+00_JPRB/)  
KAO( :, 2, 2, 3) = (/&
 & 8.9700E-03_JPRB,4.2947E-02_JPRB,5.5146E-02_JPRB,6.7953E-02_JPRB,8.1575E-02_JPRB,9.4893E-02_JPRB,&
 & 1.0724E-01_JPRB,1.1720E-01_JPRB,3.6786E+00_JPRB/)  
KAO( :, 3, 2, 3) = (/&
 & 8.8659E-03_JPRB,4.2433E-02_JPRB,5.6085E-02_JPRB,7.0736E-02_JPRB,8.5859E-02_JPRB,1.0050E-01_JPRB,&
 & 1.1405E-01_JPRB,1.2513E-01_JPRB,3.6433E+00_JPRB/)  
KAO( :, 4, 2, 3) = (/&
 & 8.7765E-03_JPRB,4.1995E-02_JPRB,5.7083E-02_JPRB,7.3307E-02_JPRB,8.9633E-02_JPRB,1.0538E-01_JPRB,&
 & 1.1996E-01_JPRB,1.3207E-01_JPRB,3.6200E+00_JPRB/)  
KAO( :, 5, 2, 3) = (/&
 & 8.7192E-03_JPRB,4.1672E-02_JPRB,5.8019E-02_JPRB,7.5546E-02_JPRB,9.2932E-02_JPRB,1.0966E-01_JPRB,&
 & 1.2527E-01_JPRB,1.3822E-01_JPRB,3.6042E+00_JPRB/)  
KAO( :, 1, 3, 3) = (/&
 & 6.9828E-03_JPRB,3.6975E-02_JPRB,4.6012E-02_JPRB,5.4717E-02_JPRB,6.4326E-02_JPRB,7.4011E-02_JPRB,&
 & 8.2981E-02_JPRB,8.9968E-02_JPRB,3.0198E+00_JPRB/)  
KAO( :, 2, 3, 3) = (/&
 & 6.8270E-03_JPRB,3.6472E-02_JPRB,4.6704E-02_JPRB,5.7392E-02_JPRB,6.8826E-02_JPRB,8.0074E-02_JPRB,&
 & 9.0443E-02_JPRB,9.8762E-02_JPRB,2.9461E+00_JPRB/)  
KAO( :, 3, 3, 3) = (/&
 & 6.7044E-03_JPRB,3.6003E-02_JPRB,4.7551E-02_JPRB,5.9975E-02_JPRB,7.2865E-02_JPRB,8.5354E-02_JPRB,&
 & 9.6922E-02_JPRB,1.0635E-01_JPRB,2.8886E+00_JPRB/)  
KAO( :, 4, 3, 3) = (/&
 & 6.5993E-03_JPRB,3.5562E-02_JPRB,4.8474E-02_JPRB,6.2398E-02_JPRB,7.6490E-02_JPRB,9.0037E-02_JPRB,&
 & 1.0257E-01_JPRB,1.1285E-01_JPRB,2.8436E+00_JPRB/)  
KAO( :, 5, 3, 3) = (/&
 & 6.5059E-03_JPRB,3.5210E-02_JPRB,4.9353E-02_JPRB,6.4534E-02_JPRB,7.9605E-02_JPRB,9.4094E-02_JPRB,&
 & 1.0752E-01_JPRB,1.1864E-01_JPRB,2.8111E+00_JPRB/)  
KAO( :, 1, 4, 3) = (/&
 & 5.5908E-03_JPRB,3.1365E-02_JPRB,3.8737E-02_JPRB,4.5544E-02_JPRB,5.3149E-02_JPRB,6.0919E-02_JPRB,&
 & 6.8125E-02_JPRB,7.3670E-02_JPRB,2.5046E+00_JPRB/)  
KAO( :, 2, 4, 3) = (/&
 & 5.3957E-03_JPRB,3.0920E-02_JPRB,3.9328E-02_JPRB,4.7957E-02_JPRB,5.7284E-02_JPRB,6.6485E-02_JPRB,&
 & 7.5002E-02_JPRB,8.1748E-02_JPRB,2.4277E+00_JPRB/)  
KAO( :, 3, 4, 3) = (/&
 & 5.2334E-03_JPRB,3.0500E-02_JPRB,4.0047E-02_JPRB,5.0287E-02_JPRB,6.0995E-02_JPRB,7.1412E-02_JPRB,&
 & 8.1019E-02_JPRB,8.8826E-02_JPRB,2.3616E+00_JPRB/)  
KAO( :, 4, 4, 3) = (/&
 & 5.0990E-03_JPRB,3.0103E-02_JPRB,4.0857E-02_JPRB,5.2515E-02_JPRB,6.4366E-02_JPRB,7.5769E-02_JPRB,&
 & 8.6313E-02_JPRB,9.4909E-02_JPRB,2.3071E+00_JPRB/)  
KAO( :, 5, 4, 3) = (/&
 & 4.9843E-03_JPRB,2.9769E-02_JPRB,4.1653E-02_JPRB,5.4480E-02_JPRB,6.7248E-02_JPRB,7.9493E-02_JPRB,&
 & 9.0850E-02_JPRB,1.0015E-01_JPRB,2.2622E+00_JPRB/)  
KAO( :, 1, 5, 3) = (/&
 & 4.6371E-03_JPRB,2.6536E-02_JPRB,3.2443E-02_JPRB,3.7642E-02_JPRB,4.3487E-02_JPRB,4.9620E-02_JPRB,&
 & 5.5321E-02_JPRB,5.9691E-02_JPRB,2.1169E+00_JPRB/)  
KAO( :, 2, 5, 3) = (/&
 & 4.4354E-03_JPRB,2.6146E-02_JPRB,3.2937E-02_JPRB,3.9753E-02_JPRB,4.7206E-02_JPRB,5.4649E-02_JPRB,&
 & 6.1517E-02_JPRB,6.6941E-02_JPRB,2.0403E+00_JPRB/)  
KAO( :, 3, 5, 3) = (/&
 & 4.2621E-03_JPRB,2.5770E-02_JPRB,3.3534E-02_JPRB,4.1840E-02_JPRB,5.0602E-02_JPRB,5.9123E-02_JPRB,&
 & 6.7019E-02_JPRB,7.3387E-02_JPRB,1.9782E+00_JPRB/)  
KAO( :, 4, 5, 3) = (/&
 & 4.1136E-03_JPRB,2.5421E-02_JPRB,3.4232E-02_JPRB,4.3837E-02_JPRB,5.3645E-02_JPRB,6.3092E-02_JPRB,&
 & 7.1794E-02_JPRB,7.8876E-02_JPRB,1.9264E+00_JPRB/)  
KAO( :, 5, 5, 3) = (/&
 & 3.9859E-03_JPRB,2.5135E-02_JPRB,3.4954E-02_JPRB,4.5597E-02_JPRB,5.6243E-02_JPRB,6.6466E-02_JPRB,&
 & 7.5915E-02_JPRB,8.3643E-02_JPRB,1.8824E+00_JPRB/)  
KAO( :, 1, 6, 3) = (/&
 & 3.9304E-03_JPRB,2.2403E-02_JPRB,2.7063E-02_JPRB,3.0926E-02_JPRB,3.5302E-02_JPRB,4.0017E-02_JPRB,&
 & 4.4453E-02_JPRB,4.7785E-02_JPRB,1.8116E+00_JPRB/)  
KAO( :, 2, 6, 3) = (/&
 & 3.7327E-03_JPRB,2.2045E-02_JPRB,2.7456E-02_JPRB,3.2698E-02_JPRB,3.8563E-02_JPRB,4.4474E-02_JPRB,&
 & 4.9934E-02_JPRB,5.4194E-02_JPRB,1.7392E+00_JPRB/)  
KAO( :, 3, 6, 3) = (/&
 & 3.5637E-03_JPRB,2.1717E-02_JPRB,2.7946E-02_JPRB,3.4540E-02_JPRB,4.1589E-02_JPRB,4.8508E-02_JPRB,&
 & 5.4887E-02_JPRB,6.0005E-02_JPRB,1.6805E+00_JPRB/)  
KAO( :, 4, 6, 3) = (/&
 & 3.4181E-03_JPRB,2.1413E-02_JPRB,2.8528E-02_JPRB,3.6294E-02_JPRB,4.4304E-02_JPRB,5.2019E-02_JPRB,&
 & 5.9160E-02_JPRB,6.4927E-02_JPRB,1.6325E+00_JPRB/)  
KAO( :, 5, 6, 3) = (/&
 & 3.2918E-03_JPRB,2.1166E-02_JPRB,2.9161E-02_JPRB,3.7872E-02_JPRB,4.6642E-02_JPRB,5.5066E-02_JPRB,&
 & 6.2852E-02_JPRB,6.9193E-02_JPRB,1.5934E+00_JPRB/)  
KAO( :, 1, 7, 3) = (/&
 & 3.3611E-03_JPRB,1.8890E-02_JPRB,2.2580E-02_JPRB,2.5423E-02_JPRB,2.8547E-02_JPRB,3.2022E-02_JPRB,&
 & 3.5350E-02_JPRB,3.7816E-02_JPRB,1.5699E+00_JPRB/)  
KAO( :, 2, 7, 3) = (/&
 & 3.1761E-03_JPRB,1.8547E-02_JPRB,2.2859E-02_JPRB,2.6861E-02_JPRB,3.1328E-02_JPRB,3.5924E-02_JPRB,&
 & 4.0179E-02_JPRB,4.3442E-02_JPRB,1.5027E+00_JPRB/)  
KAO( :, 3, 7, 3) = (/&
 & 3.0174E-03_JPRB,1.8258E-02_JPRB,2.3246E-02_JPRB,2.8428E-02_JPRB,3.4019E-02_JPRB,3.9530E-02_JPRB,&
 & 4.4619E-02_JPRB,4.8631E-02_JPRB,1.4482E+00_JPRB/)  
KAO( :, 4, 7, 3) = (/&
 & 2.8795E-03_JPRB,1.7993E-02_JPRB,2.3728E-02_JPRB,2.9950E-02_JPRB,3.6407E-02_JPRB,4.2653E-02_JPRB,&
 & 4.8406E-02_JPRB,5.3042E-02_JPRB,1.4039E+00_JPRB/)  
KAO( :, 5, 7, 3) = (/&
 & 2.7589E-03_JPRB,1.7786E-02_JPRB,2.4255E-02_JPRB,3.1342E-02_JPRB,3.8508E-02_JPRB,4.5385E-02_JPRB,&
 & 5.1742E-02_JPRB,5.6887E-02_JPRB,1.3676E+00_JPRB/)  
KAO( :, 1, 8, 3) = (/&
 & 2.8871E-03_JPRB,1.5916E-02_JPRB,1.8850E-02_JPRB,2.0853E-02_JPRB,2.2958E-02_JPRB,2.5335E-02_JPRB,&
 & 2.7709E-02_JPRB,2.9422E-02_JPRB,1.3854E+00_JPRB/)  
KAO( :, 2, 8, 3) = (/&
 & 2.7155E-03_JPRB,1.5597E-02_JPRB,1.9055E-02_JPRB,2.1994E-02_JPRB,2.5264E-02_JPRB,2.8724E-02_JPRB,&
 & 3.1943E-02_JPRB,3.4360E-02_JPRB,1.3215E+00_JPRB/)  
KAO( :, 3, 8, 3) = (/&
 & 2.5680E-03_JPRB,1.5338E-02_JPRB,1.9338E-02_JPRB,2.3296E-02_JPRB,2.7614E-02_JPRB,3.1925E-02_JPRB,&
 & 3.5879E-02_JPRB,3.8941E-02_JPRB,1.2707E+00_JPRB/)  
KAO( :, 4, 8, 3) = (/&
 & 2.4392E-03_JPRB,1.5108E-02_JPRB,1.9717E-02_JPRB,2.4602E-02_JPRB,2.9735E-02_JPRB,3.4708E-02_JPRB,&
 & 3.9299E-02_JPRB,4.2946E-02_JPRB,1.2299E+00_JPRB/)  
KAO( :, 5, 8, 3) = (/&
 & 2.3263E-03_JPRB,1.4926E-02_JPRB,2.0145E-02_JPRB,2.5818E-02_JPRB,3.1599E-02_JPRB,3.7151E-02_JPRB,&
 & 4.2259E-02_JPRB,4.6364E-02_JPRB,1.1947E+00_JPRB/)  
KAO( :, 1, 9, 3) = (/&
 & 2.4934E-03_JPRB,1.3429E-02_JPRB,1.5676E-02_JPRB,1.6996E-02_JPRB,1.8299E-02_JPRB,1.9797E-02_JPRB,&
 & 2.1368E-02_JPRB,2.2488E-02_JPRB,1.2194E+00_JPRB/)  
KAO( :, 2, 9, 3) = (/&
 & 2.3370E-03_JPRB,1.3137E-02_JPRB,1.5812E-02_JPRB,1.7884E-02_JPRB,2.0163E-02_JPRB,2.2642E-02_JPRB,&
 & 2.5001E-02_JPRB,2.6734E-02_JPRB,1.1601E+00_JPRB/)  
KAO( :, 3, 9, 3) = (/&
 & 2.2009E-03_JPRB,1.2890E-02_JPRB,1.6023E-02_JPRB,1.8937E-02_JPRB,2.2155E-02_JPRB,2.5427E-02_JPRB,&
 & 2.8446E-02_JPRB,3.0735E-02_JPRB,1.1135E+00_JPRB/)  
KAO( :, 4, 9, 3) = (/&
 & 2.0815E-03_JPRB,1.2690E-02_JPRB,1.6303E-02_JPRB,2.0037E-02_JPRB,2.4017E-02_JPRB,2.7921E-02_JPRB,&
 & 3.1498E-02_JPRB,3.4306E-02_JPRB,1.0751E+00_JPRB/)  
KAO( :, 5, 9, 3) = (/&
 & 1.9758E-03_JPRB,1.2522E-02_JPRB,1.6643E-02_JPRB,2.1089E-02_JPRB,2.5672E-02_JPRB,3.0080E-02_JPRB,&
 & 3.4128E-02_JPRB,3.7357E-02_JPRB,1.0412E+00_JPRB/)  
KAO( :, 1,10, 3) = (/&
 & 2.1444E-03_JPRB,1.1292E-02_JPRB,1.2992E-02_JPRB,1.3863E-02_JPRB,1.4632E-02_JPRB,1.5527E-02_JPRB,&
 & 1.6522E-02_JPRB,1.7216E-02_JPRB,1.0697E+00_JPRB/)  
KAO( :, 2,10, 3) = (/&
 & 2.0062E-03_JPRB,1.1025E-02_JPRB,1.3086E-02_JPRB,1.4548E-02_JPRB,1.6122E-02_JPRB,1.7867E-02_JPRB,&
 & 1.9575E-02_JPRB,2.0804E-02_JPRB,1.0168E+00_JPRB/)  
KAO( :, 3,10, 3) = (/&
 & 1.8858E-03_JPRB,1.0796E-02_JPRB,1.3240E-02_JPRB,1.5386E-02_JPRB,1.7762E-02_JPRB,2.0237E-02_JPRB,&
 & 2.2522E-02_JPRB,2.4230E-02_JPRB,9.7508E-01_JPRB/)  
KAO( :, 4,10, 3) = (/&
 & 1.7806E-03_JPRB,1.0614E-02_JPRB,1.3451E-02_JPRB,1.6297E-02_JPRB,1.9372E-02_JPRB,2.2410E-02_JPRB,&
 & 2.5204E-02_JPRB,2.7358E-02_JPRB,9.3955E-01_JPRB/)  
KAO( :, 5,10, 3) = (/&
 & 1.6877E-03_JPRB,1.0465E-02_JPRB,1.3712E-02_JPRB,1.7180E-02_JPRB,2.0798E-02_JPRB,2.4286E-02_JPRB,&
 & 2.7488E-02_JPRB,3.0016E-02_JPRB,9.0793E-01_JPRB/)  
KAO( :, 1,11, 3) = (/&
 & 1.7833E-03_JPRB,9.3555E-03_JPRB,1.0771E-02_JPRB,1.1508E-02_JPRB,1.2189E-02_JPRB,1.2975E-02_JPRB,&
 & 1.3836E-02_JPRB,1.4432E-02_JPRB,9.1283E-01_JPRB/)  
KAO( :, 2,11, 3) = (/&
 & 1.6687E-03_JPRB,9.1314E-03_JPRB,1.0850E-02_JPRB,1.2098E-02_JPRB,1.3448E-02_JPRB,1.4933E-02_JPRB,&
 & 1.6373E-02_JPRB,1.7407E-02_JPRB,8.7061E-01_JPRB/)  
KAO( :, 3,11, 3) = (/&
 & 1.5693E-03_JPRB,8.9406E-03_JPRB,1.0990E-02_JPRB,1.2807E-02_JPRB,1.4816E-02_JPRB,1.6890E-02_JPRB,&
 & 1.8802E-02_JPRB,2.0227E-02_JPRB,8.3514E-01_JPRB/)  
KAO( :, 4,11, 3) = (/&
 & 1.4823E-03_JPRB,8.7931E-03_JPRB,1.1163E-02_JPRB,1.3552E-02_JPRB,1.6124E-02_JPRB,1.8657E-02_JPRB,&
 & 2.0985E-02_JPRB,2.2777E-02_JPRB,8.0415E-01_JPRB/)  
KAO( :, 5,11, 3) = (/&
 & 1.4048E-03_JPRB,8.6627E-03_JPRB,1.1377E-02_JPRB,1.4262E-02_JPRB,1.7270E-02_JPRB,2.0165E-02_JPRB,&
 & 2.2814E-02_JPRB,2.4901E-02_JPRB,7.7610E-01_JPRB/)  
KAO( :, 1,12, 3) = (/&
 & 1.4795E-03_JPRB,7.7320E-03_JPRB,8.9123E-03_JPRB,9.5371E-03_JPRB,1.0129E-02_JPRB,1.0809E-02_JPRB,&
 & 1.1546E-02_JPRB,1.2053E-02_JPRB,7.8854E-01_JPRB/)  
KAO( :, 2,12, 3) = (/&
 & 1.3850E-03_JPRB,7.5464E-03_JPRB,8.9834E-03_JPRB,1.0043E-02_JPRB,1.1188E-02_JPRB,1.2441E-02_JPRB,&
 & 1.3647E-02_JPRB,1.4511E-02_JPRB,7.5243E-01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


SUBROUTINE PART3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART3',0,ZHOOK_HANDLE)


KAO( :, 3,12, 3) = (/&
 & 1.3027E-03_JPRB,7.3902E-03_JPRB,9.1016E-03_JPRB,1.0632E-02_JPRB,1.2313E-02_JPRB,1.4042E-02_JPRB,&
 & 1.5632E-02_JPRB,1.6816E-02_JPRB,7.2138E-01_JPRB/)  
KAO( :, 4,12, 3) = (/&
 & 1.2303E-03_JPRB,7.2649E-03_JPRB,9.2431E-03_JPRB,1.1235E-02_JPRB,1.3368E-02_JPRB,1.5466E-02_JPRB,&
 & 1.7392E-02_JPRB,1.8872E-02_JPRB,6.9377E-01_JPRB/)  
KAO( :, 5,12, 3) = (/&
 & 1.1660E-03_JPRB,7.1513E-03_JPRB,9.4159E-03_JPRB,1.1801E-02_JPRB,1.4281E-02_JPRB,1.6671E-02_JPRB,&
 & 1.8852E-02_JPRB,2.0566E-02_JPRB,6.6914E-01_JPRB/)  
KAO( :, 1,13, 3) = (/&
 & 1.2249E-03_JPRB,6.3782E-03_JPRB,7.3622E-03_JPRB,7.8943E-03_JPRB,8.4021E-03_JPRB,8.9820E-03_JPRB,&
 & 9.6036E-03_JPRB,1.0029E-02_JPRB,7.0365E-01_JPRB/)  
KAO( :, 2,13, 3) = (/&
 & 1.1466E-03_JPRB,6.2255E-03_JPRB,7.4265E-03_JPRB,8.3184E-03_JPRB,9.2818E-03_JPRB,1.0328E-02_JPRB,&
 & 1.1327E-02_JPRB,1.2042E-02_JPRB,6.7076E-01_JPRB/)  
KAO( :, 3,13, 3) = (/&
 & 1.0784E-03_JPRB,6.0974E-03_JPRB,7.5218E-03_JPRB,8.8021E-03_JPRB,1.0201E-02_JPRB,1.1630E-02_JPRB,&
 & 1.2945E-02_JPRB,1.3920E-02_JPRB,6.4220E-01_JPRB/)  
KAO( :, 4,13, 3) = (/&
 & 1.0185E-03_JPRB,5.9888E-03_JPRB,7.6372E-03_JPRB,9.2865E-03_JPRB,1.1046E-02_JPRB,1.2772E-02_JPRB,&
 & 1.4357E-02_JPRB,1.5571E-02_JPRB,6.1693E-01_JPRB/)  
KAO( :, 5,13, 3) = (/&
 & 9.6529E-04_JPRB,5.8902E-03_JPRB,7.7765E-03_JPRB,9.7442E-03_JPRB,1.1781E-02_JPRB,1.3744E-02_JPRB,&
 & 1.5534E-02_JPRB,1.6937E-02_JPRB,5.9454E-01_JPRB/)  
KAO( :, 1, 1, 4) = (/&
 & 1.8021E-02_JPRB,6.5790E-02_JPRB,9.7338E-02_JPRB,1.3126E-01_JPRB,1.6473E-01_JPRB,1.9719E-01_JPRB,&
 & 2.2788E-01_JPRB,2.5486E-01_JPRB,6.7734E+00_JPRB/)  
KAO( :, 2, 1, 4) = (/&
 & 1.7655E-02_JPRB,6.4900E-02_JPRB,9.8783E-02_JPRB,1.3458E-01_JPRB,1.6983E-01_JPRB,2.0389E-01_JPRB,&
 & 2.3625E-01_JPRB,2.6464E-01_JPRB,6.6229E+00_JPRB/)  
KAO( :, 3, 1, 4) = (/&
 & 1.7413E-02_JPRB,6.4418E-02_JPRB,1.0054E-01_JPRB,1.3796E-01_JPRB,1.7471E-01_JPRB,2.1025E-01_JPRB,&
 & 2.4393E-01_JPRB,2.7353E-01_JPRB,6.4891E+00_JPRB/)  
KAO( :, 4, 1, 4) = (/&
 & 1.7262E-02_JPRB,6.4165E-02_JPRB,1.0227E-01_JPRB,1.4108E-01_JPRB,1.7917E-01_JPRB,2.1605E-01_JPRB,&
 & 2.5091E-01_JPRB,2.8164E-01_JPRB,6.3763E+00_JPRB/)  
KAO( :, 5, 1, 4) = (/&
 & 1.7196E-02_JPRB,6.4095E-02_JPRB,1.0392E-01_JPRB,1.4402E-01_JPRB,1.8328E-01_JPRB,2.2127E-01_JPRB,&
 & 2.5722E-01_JPRB,2.8879E-01_JPRB,6.2911E+00_JPRB/)  
KAO( :, 1, 2, 4) = (/&
 & 1.4529E-02_JPRB,5.6872E-02_JPRB,8.5086E-02_JPRB,1.1534E-01_JPRB,1.4512E-01_JPRB,1.7394E-01_JPRB,&
 & 2.0123E-01_JPRB,2.2499E-01_JPRB,5.6977E+00_JPRB/)  
KAO( :, 2, 2, 4) = (/&
 & 1.4123E-02_JPRB,5.6310E-02_JPRB,8.6845E-02_JPRB,1.1891E-01_JPRB,1.5031E-01_JPRB,1.8072E-01_JPRB,&
 & 2.0938E-01_JPRB,2.3448E-01_JPRB,5.5431E+00_JPRB/)  
KAO( :, 3, 2, 4) = (/&
 & 1.3817E-02_JPRB,5.6056E-02_JPRB,8.8719E-02_JPRB,1.2233E-01_JPRB,1.5523E-01_JPRB,1.8697E-01_JPRB,&
 & 2.1702E-01_JPRB,2.4322E-01_JPRB,5.4063E+00_JPRB/)  
KAO( :, 4, 2, 4) = (/&
 & 1.3599E-02_JPRB,5.5957E-02_JPRB,9.0467E-02_JPRB,1.2549E-01_JPRB,1.5975E-01_JPRB,1.9279E-01_JPRB,&
 & 2.2406E-01_JPRB,2.5131E-01_JPRB,5.2860E+00_JPRB/)  
KAO( :, 5, 2, 4) = (/&
 & 1.3460E-02_JPRB,5.5961E-02_JPRB,9.2180E-02_JPRB,1.2851E-01_JPRB,1.6399E-01_JPRB,1.9829E-01_JPRB,&
 & 2.3058E-01_JPRB,2.5880E-01_JPRB,5.1861E+00_JPRB/)  
KAO( :, 1, 3, 4) = (/&
 & 1.1705E-02_JPRB,4.8966E-02_JPRB,7.3479E-02_JPRB,9.9794E-02_JPRB,1.2575E-01_JPRB,1.5078E-01_JPRB,&
 & 1.7441E-01_JPRB,1.9480E-01_JPRB,4.7593E+00_JPRB/)  
KAO( :, 2, 3, 4) = (/&
 & 1.1254E-02_JPRB,4.8604E-02_JPRB,7.5346E-02_JPRB,1.0340E-01_JPRB,1.3083E-01_JPRB,1.5727E-01_JPRB,&
 & 1.8221E-01_JPRB,2.0377E-01_JPRB,4.6048E+00_JPRB/)  
KAO( :, 3, 3, 4) = (/&
 & 1.0873E-02_JPRB,4.8463E-02_JPRB,7.7240E-02_JPRB,1.0681E-01_JPRB,1.3563E-01_JPRB,1.6344E-01_JPRB,&
 & 1.8954E-01_JPRB,2.1219E-01_JPRB,4.4612E+00_JPRB/)  
KAO( :, 4, 3, 4) = (/&
 & 1.0555E-02_JPRB,4.8429E-02_JPRB,7.9010E-02_JPRB,1.0996E-01_JPRB,1.4012E-01_JPRB,1.6913E-01_JPRB,&
 & 1.9654E-01_JPRB,2.2020E-01_JPRB,4.3302E+00_JPRB/)  
KAO( :, 5, 3, 4) = (/&
 & 1.0298E-02_JPRB,4.8470E-02_JPRB,8.0657E-02_JPRB,1.1290E-01_JPRB,1.4434E-01_JPRB,1.7459E-01_JPRB,&
 & 2.0310E-01_JPRB,2.2776E-01_JPRB,4.2150E+00_JPRB/)  
KAO( :, 1, 4, 4) = (/&
 & 9.6427E-03_JPRB,4.2071E-02_JPRB,6.2842E-02_JPRB,8.5269E-02_JPRB,1.0739E-01_JPRB,1.2873E-01_JPRB,&
 & 1.4874E-01_JPRB,1.6592E-01_JPRB,4.0400E+00_JPRB/)  
KAO( :, 2, 4, 4) = (/&
 & 9.2011E-03_JPRB,4.1815E-02_JPRB,6.4680E-02_JPRB,8.8757E-02_JPRB,1.1230E-01_JPRB,1.3495E-01_JPRB,&
 & 1.5622E-01_JPRB,1.7447E-01_JPRB,3.8793E+00_JPRB/)  
KAO( :, 3, 4, 4) = (/&
 & 8.8205E-03_JPRB,4.1737E-02_JPRB,6.6556E-02_JPRB,9.2068E-02_JPRB,1.1693E-01_JPRB,1.4084E-01_JPRB,&
 & 1.6327E-01_JPRB,1.8245E-01_JPRB,3.7400E+00_JPRB/)  
KAO( :, 4, 4, 4) = (/&
 & 8.4836E-03_JPRB,4.1724E-02_JPRB,6.8311E-02_JPRB,9.5165E-02_JPRB,1.2127E-01_JPRB,1.4641E-01_JPRB,&
 & 1.6997E-01_JPRB,1.9023E-01_JPRB,3.6160E+00_JPRB/)  
KAO( :, 5, 4, 4) = (/&
 & 8.1913E-03_JPRB,4.1779E-02_JPRB,6.9919E-02_JPRB,9.8052E-02_JPRB,1.2544E-01_JPRB,1.5176E-01_JPRB,&
 & 1.7649E-01_JPRB,1.9765E-01_JPRB,3.5010E+00_JPRB/)  
KAO( :, 1, 5, 4) = (/&
 & 8.1345E-03_JPRB,3.6015E-02_JPRB,5.3335E-02_JPRB,7.2138E-02_JPRB,9.0702E-02_JPRB,1.0859E-01_JPRB,&
 & 1.2537E-01_JPRB,1.3961E-01_JPRB,3.4725E+00_JPRB/)  
KAO( :, 2, 5, 4) = (/&
 & 7.7094E-03_JPRB,3.5776E-02_JPRB,5.4998E-02_JPRB,7.5337E-02_JPRB,9.5240E-02_JPRB,1.1439E-01_JPRB,&
 & 1.3227E-01_JPRB,1.4749E-01_JPRB,3.3178E+00_JPRB/)  
KAO( :, 3, 5, 4) = (/&
 & 7.3411E-03_JPRB,3.5699E-02_JPRB,5.6747E-02_JPRB,7.8425E-02_JPRB,9.9566E-02_JPRB,1.1985E-01_JPRB,&
 & 1.3882E-01_JPRB,1.5490E-01_JPRB,3.1804E+00_JPRB/)  
KAO( :, 4, 5, 4) = (/&
 & 7.0201E-03_JPRB,3.5715E-02_JPRB,5.8432E-02_JPRB,8.1402E-02_JPRB,1.0370E-01_JPRB,1.2511E-01_JPRB,&
 & 1.4516E-01_JPRB,1.6215E-01_JPRB,3.0592E+00_JPRB/)  
KAO( :, 5, 5, 4) = (/&
 & 6.7383E-03_JPRB,3.5791E-02_JPRB,5.9960E-02_JPRB,8.4146E-02_JPRB,1.0763E-01_JPRB,1.3019E-01_JPRB,&
 & 1.5126E-01_JPRB,1.6919E-01_JPRB,2.9545E+00_JPRB/)  
KAO( :, 1, 6, 4) = (/&
 & 6.9574E-03_JPRB,3.0705E-02_JPRB,4.4873E-02_JPRB,6.0368E-02_JPRB,7.5716E-02_JPRB,9.0457E-02_JPRB,&
 & 1.0422E-01_JPRB,1.1586E-01_JPRB,3.0030E+00_JPRB/)  
KAO( :, 2, 6, 4) = (/&
 & 6.5599E-03_JPRB,3.0473E-02_JPRB,4.6327E-02_JPRB,6.3240E-02_JPRB,7.9791E-02_JPRB,9.5693E-02_JPRB,&
 & 1.1056E-01_JPRB,1.2311E-01_JPRB,2.8591E+00_JPRB/)  
KAO( :, 3, 6, 4) = (/&
 & 6.2154E-03_JPRB,3.0355E-02_JPRB,4.7875E-02_JPRB,6.6021E-02_JPRB,8.3704E-02_JPRB,1.0067E-01_JPRB,&
 & 1.1647E-01_JPRB,1.2979E-01_JPRB,2.7316E+00_JPRB/)  
KAO( :, 4, 6, 4) = (/&
 & 5.9146E-03_JPRB,3.0358E-02_JPRB,4.9433E-02_JPRB,6.8766E-02_JPRB,8.7543E-02_JPRB,1.0553E-01_JPRB,&
 & 1.2232E-01_JPRB,1.3650E-01_JPRB,2.6198E+00_JPRB/)  
KAO( :, 5, 6, 4) = (/&
 & 5.6484E-03_JPRB,3.0432E-02_JPRB,5.0868E-02_JPRB,7.1327E-02_JPRB,9.1169E-02_JPRB,1.1020E-01_JPRB,&
 & 1.2797E-01_JPRB,1.4294E-01_JPRB,2.5219E+00_JPRB/)  
KAO( :, 1, 7, 4) = (/&
 & 5.9858E-03_JPRB,2.6066E-02_JPRB,3.7491E-02_JPRB,5.0091E-02_JPRB,6.2632E-02_JPRB,7.4695E-02_JPRB,&
 & 8.5899E-02_JPRB,9.5307E-02_JPRB,2.6265E+00_JPRB/)  
KAO( :, 2, 7, 4) = (/&
 & 5.6201E-03_JPRB,2.5818E-02_JPRB,3.8713E-02_JPRB,5.2603E-02_JPRB,6.6261E-02_JPRB,7.9344E-02_JPRB,&
 & 9.1528E-02_JPRB,1.0179E-01_JPRB,2.4915E+00_JPRB/)  
KAO( :, 3, 7, 4) = (/&
 & 5.3028E-03_JPRB,2.5679E-02_JPRB,4.0067E-02_JPRB,5.5077E-02_JPRB,6.9715E-02_JPRB,8.3744E-02_JPRB,&
 & 9.6820E-02_JPRB,1.0780E-01_JPRB,2.3737E+00_JPRB/)  
KAO( :, 4, 7, 4) = (/&
 & 5.0250E-03_JPRB,2.5664E-02_JPRB,4.1469E-02_JPRB,5.7563E-02_JPRB,7.3190E-02_JPRB,8.8174E-02_JPRB,&
 & 1.0210E-01_JPRB,1.1380E-01_JPRB,2.2719E+00_JPRB/)  
KAO( :, 5, 7, 4) = (/&
 & 4.7808E-03_JPRB,2.5724E-02_JPRB,4.2789E-02_JPRB,5.9902E-02_JPRB,7.6504E-02_JPRB,9.2382E-02_JPRB,&
 & 1.0715E-01_JPRB,1.1955E-01_JPRB,2.1838E+00_JPRB/)  
KAO( :, 1, 8, 4) = (/&
 & 5.1596E-03_JPRB,2.2052E-02_JPRB,3.1199E-02_JPRB,4.1353E-02_JPRB,5.1554E-02_JPRB,6.1370E-02_JPRB,&
 & 7.0499E-02_JPRB,7.8103E-02_JPRB,2.3369E+00_JPRB/)  
KAO( :, 2, 8, 4) = (/&
 & 4.8272E-03_JPRB,2.1774E-02_JPRB,3.2180E-02_JPRB,4.3545E-02_JPRB,5.4719E-02_JPRB,6.5446E-02_JPRB,&
 & 7.5433E-02_JPRB,8.3810E-02_JPRB,2.2096E+00_JPRB/)  
KAO( :, 3, 8, 4) = (/&
 & 4.5379E-03_JPRB,2.1626E-02_JPRB,3.3329E-02_JPRB,4.5683E-02_JPRB,5.7755E-02_JPRB,6.9313E-02_JPRB,&
 & 8.0057E-02_JPRB,8.9096E-02_JPRB,2.0999E+00_JPRB/)  
KAO( :, 4, 8, 4) = (/&
 & 4.2850E-03_JPRB,2.1592E-02_JPRB,3.4574E-02_JPRB,4.7884E-02_JPRB,6.0825E-02_JPRB,7.3203E-02_JPRB,&
 & 8.4719E-02_JPRB,9.4365E-02_JPRB,2.0061E+00_JPRB/)  
KAO( :, 5, 8, 4) = (/&
 & 4.0623E-03_JPRB,2.1641E-02_JPRB,3.5762E-02_JPRB,4.9985E-02_JPRB,6.3751E-02_JPRB,7.6922E-02_JPRB,&
 & 8.9154E-02_JPRB,9.9364E-02_JPRB,1.9265E+00_JPRB/)  
KAO( :, 1, 9, 4) = (/&
 & 4.4531E-03_JPRB,1.8626E-02_JPRB,2.5958E-02_JPRB,3.4051E-02_JPRB,4.2290E-02_JPRB,5.0232E-02_JPRB,&
 & 5.7580E-02_JPRB,6.3645E-02_JPRB,2.0688E+00_JPRB/)  
KAO( :, 2, 9, 4) = (/&
 & 4.1555E-03_JPRB,1.8330E-02_JPRB,2.6712E-02_JPRB,3.5938E-02_JPRB,4.5066E-02_JPRB,5.3798E-02_JPRB,&
 & 6.1907E-02_JPRB,6.8669E-02_JPRB,1.9511E+00_JPRB/)  
KAO( :, 3, 9, 4) = (/&
 & 3.8980E-03_JPRB,1.8171E-02_JPRB,2.7659E-02_JPRB,3.7795E-02_JPRB,4.7683E-02_JPRB,5.7159E-02_JPRB,&
 & 6.5983E-02_JPRB,7.3362E-02_JPRB,1.8504E+00_JPRB/)  
KAO( :, 4, 9, 4) = (/&
 & 3.6726E-03_JPRB,1.8123E-02_JPRB,2.8719E-02_JPRB,3.9685E-02_JPRB,5.0340E-02_JPRB,6.0531E-02_JPRB,&
 & 6.9978E-02_JPRB,7.7857E-02_JPRB,1.7654E+00_JPRB/)  
KAO( :, 5, 9, 4) = (/&
 & 3.4732E-03_JPRB,1.8155E-02_JPRB,2.9764E-02_JPRB,4.1511E-02_JPRB,5.2898E-02_JPRB,6.3750E-02_JPRB,&
 & 7.3823E-02_JPRB,8.2208E-02_JPRB,1.6947E+00_JPRB/)  
KAO( :, 1,10, 4) = (/&
 & 3.8264E-03_JPRB,1.5718E-02_JPRB,2.1595E-02_JPRB,2.8016E-02_JPRB,3.4614E-02_JPRB,4.0975E-02_JPRB,&
 & 4.6868E-02_JPRB,5.1662E-02_JPRB,1.8197E+00_JPRB/)  
KAO( :, 2,10, 4) = (/&
 & 3.5642E-03_JPRB,1.5429E-02_JPRB,2.2178E-02_JPRB,2.9617E-02_JPRB,3.7012E-02_JPRB,4.4107E-02_JPRB,&
 & 5.0673E-02_JPRB,5.6104E-02_JPRB,1.7127E+00_JPRB/)  
KAO( :, 3,10, 4) = (/&
 & 3.3388E-03_JPRB,1.5262E-02_JPRB,2.2939E-02_JPRB,3.1209E-02_JPRB,3.9306E-02_JPRB,4.7049E-02_JPRB,&
 & 5.4217E-02_JPRB,6.0186E-02_JPRB,1.6230E+00_JPRB/)  
KAO( :, 4,10, 4) = (/&
 & 3.1419E-03_JPRB,1.5205E-02_JPRB,2.3835E-02_JPRB,3.2828E-02_JPRB,4.1571E-02_JPRB,4.9911E-02_JPRB,&
 & 5.7637E-02_JPRB,6.4044E-02_JPRB,1.5488E+00_JPRB/)  
KAO( :, 5,10, 4) = (/&
 & 2.9677E-03_JPRB,1.5219E-02_JPRB,2.4740E-02_JPRB,3.4412E-02_JPRB,4.3767E-02_JPRB,5.2705E-02_JPRB,&
 & 6.0972E-02_JPRB,6.7792E-02_JPRB,1.4876E+00_JPRB/)  
KAO( :, 1,11, 4) = (/&
 & 3.1779E-03_JPRB,1.3095E-02_JPRB,1.8055E-02_JPRB,2.3506E-02_JPRB,2.9061E-02_JPRB,3.4415E-02_JPRB,&
 & 3.9369E-02_JPRB,4.3393E-02_JPRB,1.5476E+00_JPRB/)  
KAO( :, 2,11, 4) = (/&
 & 2.9632E-03_JPRB,1.2861E-02_JPRB,1.8568E-02_JPRB,2.4842E-02_JPRB,3.1070E-02_JPRB,3.7036E-02_JPRB,&
 & 4.2545E-02_JPRB,4.7085E-02_JPRB,1.4599E+00_JPRB/)  
KAO( :, 3,11, 4) = (/&
 & 2.7773E-03_JPRB,1.2736E-02_JPRB,1.9231E-02_JPRB,2.6199E-02_JPRB,3.3009E-02_JPRB,3.9506E-02_JPRB,&
 & 4.5515E-02_JPRB,5.0494E-02_JPRB,1.3882E+00_JPRB/)  
KAO( :, 4,11, 4) = (/&
 & 2.6144E-03_JPRB,1.2699E-02_JPRB,1.9998E-02_JPRB,2.7568E-02_JPRB,3.4911E-02_JPRB,4.1912E-02_JPRB,&
 & 4.8384E-02_JPRB,5.3719E-02_JPRB,1.3291E+00_JPRB/)  
KAO( :, 5,11, 4) = (/&
 & 2.4704E-03_JPRB,1.2732E-02_JPRB,2.0751E-02_JPRB,2.8878E-02_JPRB,3.6736E-02_JPRB,4.4233E-02_JPRB,&
 & 5.1154E-02_JPRB,5.6829E-02_JPRB,1.2767E+00_JPRB/)  
KAO( :, 1,12, 4) = (/&
 & 2.6367E-03_JPRB,1.0870E-02_JPRB,1.5028E-02_JPRB,1.9613E-02_JPRB,2.4267E-02_JPRB,2.8743E-02_JPRB,&
 & 3.2886E-02_JPRB,3.6247E-02_JPRB,1.3323E+00_JPRB/)  
KAO( :, 2,12, 4) = (/&
 & 2.4596E-03_JPRB,1.0682E-02_JPRB,1.5472E-02_JPRB,2.0731E-02_JPRB,2.5941E-02_JPRB,3.0929E-02_JPRB,&
 & 3.5529E-02_JPRB,3.9309E-02_JPRB,1.2608E+00_JPRB/)  
KAO( :, 3,12, 4) = (/&
 & 2.3058E-03_JPRB,1.0585E-02_JPRB,1.6043E-02_JPRB,2.1873E-02_JPRB,2.7564E-02_JPRB,3.2990E-02_JPRB,&
 & 3.8001E-02_JPRB,4.2137E-02_JPRB,1.2024E+00_JPRB/)  
KAO( :, 4,12, 4) = (/&
 & 2.1711E-03_JPRB,1.0572E-02_JPRB,1.6696E-02_JPRB,2.3023E-02_JPRB,2.9157E-02_JPRB,3.5001E-02_JPRB,&
 & 4.0396E-02_JPRB,4.4820E-02_JPRB,1.1510E+00_JPRB/)  
KAO( :, 5,12, 4) = (/&
 & 2.0522E-03_JPRB,1.0605E-02_JPRB,1.7302E-02_JPRB,2.4078E-02_JPRB,3.0631E-02_JPRB,3.6880E-02_JPRB,&
 & 4.2638E-02_JPRB,4.7351E-02_JPRB,1.1041E+00_JPRB/)  
KAO( :, 1,13, 4) = (/&
 & 2.1839E-03_JPRB,8.9998E-03_JPRB,1.2472E-02_JPRB,1.6303E-02_JPRB,2.0181E-02_JPRB,2.3909E-02_JPRB,&
 & 2.7356E-02_JPRB,3.0152E-02_JPRB,1.1877E+00_JPRB/)  
KAO( :, 2,13, 4) = (/&
 & 2.0376E-03_JPRB,8.8480E-03_JPRB,1.2851E-02_JPRB,1.7235E-02_JPRB,2.1572E-02_JPRB,2.5723E-02_JPRB,&
 & 2.9547E-02_JPRB,3.2688E-02_JPRB,1.1266E+00_JPRB/)  
KAO( :, 3,13, 4) = (/&
 & 1.9106E-03_JPRB,8.7808E-03_JPRB,1.3344E-02_JPRB,1.8195E-02_JPRB,2.2927E-02_JPRB,2.7435E-02_JPRB,&
 & 3.1599E-02_JPRB,3.5023E-02_JPRB,1.0740E+00_JPRB/)  
KAO( :, 4,13, 4) = (/&
 & 1.7994E-03_JPRB,8.7806E-03_JPRB,1.3884E-02_JPRB,1.9140E-02_JPRB,2.4232E-02_JPRB,2.9085E-02_JPRB,&
 & 3.3560E-02_JPRB,3.7215E-02_JPRB,1.0271E+00_JPRB/)  
KAO( :, 5,13, 4) = (/&
 & 1.7009E-03_JPRB,8.8054E-03_JPRB,1.4366E-02_JPRB,1.9979E-02_JPRB,2.5409E-02_JPRB,3.0588E-02_JPRB,&
 & 3.5352E-02_JPRB,3.9242E-02_JPRB,9.8352E-01_JPRB/)  
KAO( :, 1, 1, 5) = (/&
 & 2.7821E-02_JPRB,9.4758E-02_JPRB,1.5999E-01_JPRB,2.2454E-01_JPRB,2.8692E-01_JPRB,3.4665E-01_JPRB,&
 & 4.0214E-01_JPRB,4.4847E-01_JPRB,9.2144E+00_JPRB/)  
KAO( :, 2, 1, 5) = (/&
 & 2.6913E-02_JPRB,9.4630E-02_JPRB,1.6244E-01_JPRB,2.2902E-01_JPRB,2.9341E-01_JPRB,3.5518E-01_JPRB,&
 & 4.1260E-01_JPRB,4.6112E-01_JPRB,8.9389E+00_JPRB/)  
KAO( :, 3, 1, 5) = (/&
 & 2.6162E-02_JPRB,9.4753E-02_JPRB,1.6454E-01_JPRB,2.3287E-01_JPRB,2.9898E-01_JPRB,3.6235E-01_JPRB,&
 & 4.2172E-01_JPRB,4.7189E-01_JPRB,8.6829E+00_JPRB/)  
KAO( :, 4, 1, 5) = (/&
 & 2.5554E-02_JPRB,9.5076E-02_JPRB,1.6645E-01_JPRB,2.3629E-01_JPRB,3.0381E-01_JPRB,3.6863E-01_JPRB,&
 & 4.2942E-01_JPRB,4.8118E-01_JPRB,8.4692E+00_JPRB/)  
KAO( :, 5, 1, 5) = (/&
 & 2.5132E-02_JPRB,9.5584E-02_JPRB,1.6836E-01_JPRB,2.3931E-01_JPRB,3.0801E-01_JPRB,3.7403E-01_JPRB,&
 & 4.3587E-01_JPRB,4.8876E-01_JPRB,8.2899E+00_JPRB/)  
KAO( :, 1, 2, 5) = (/&
 & 2.2786E-02_JPRB,8.2873E-02_JPRB,1.4193E-01_JPRB,2.0025E-01_JPRB,2.5674E-01_JPRB,3.1069E-01_JPRB,&
 & 3.6090E-01_JPRB,4.0281E-01_JPRB,7.8467E+00_JPRB/)  
KAO( :, 2, 2, 5) = (/&
 & 2.1926E-02_JPRB,8.2844E-02_JPRB,1.4423E-01_JPRB,2.0445E-01_JPRB,2.6273E-01_JPRB,3.1850E-01_JPRB,&
 & 3.7058E-01_JPRB,4.1426E-01_JPRB,7.5685E+00_JPRB/)  
KAO( :, 3, 2, 5) = (/&
 & 2.1216E-02_JPRB,8.3137E-02_JPRB,1.4626E-01_JPRB,2.0800E-01_JPRB,2.6778E-01_JPRB,3.2530E-01_JPRB,&
 & 3.7887E-01_JPRB,4.2447E-01_JPRB,7.3113E+00_JPRB/)  
KAO( :, 4, 2, 5) = (/&
 & 2.0609E-02_JPRB,8.3648E-02_JPRB,1.4825E-01_JPRB,2.1130E-01_JPRB,2.7244E-01_JPRB,3.3120E-01_JPRB,&
 & 3.8633E-01_JPRB,4.3319E-01_JPRB,7.0868E+00_JPRB/)  
KAO( :, 5, 2, 5) = (/&
 & 2.0124E-02_JPRB,8.4283E-02_JPRB,1.5023E-01_JPRB,2.1439E-01_JPRB,2.7658E-01_JPRB,3.3624E-01_JPRB,&
 & 3.9227E-01_JPRB,4.4011E-01_JPRB,6.8977E+00_JPRB/)  
KAO( :, 1, 3, 5) = (/&
 & 1.8617E-02_JPRB,7.1627E-02_JPRB,1.2381E-01_JPRB,1.7543E-01_JPRB,2.2536E-01_JPRB,2.7317E-01_JPRB,&
 & 3.1745E-01_JPRB,3.5456E-01_JPRB,6.6821E+00_JPRB/)  
KAO( :, 2, 3, 5) = (/&
 & 1.7803E-02_JPRB,7.1692E-02_JPRB,1.2605E-01_JPRB,1.7941E-01_JPRB,2.3119E-01_JPRB,2.8073E-01_JPRB,&
 & 3.2696E-01_JPRB,3.6594E-01_JPRB,6.4024E+00_JPRB/)  
KAO( :, 3, 3, 5) = (/&
 & 1.7094E-02_JPRB,7.2019E-02_JPRB,1.2810E-01_JPRB,1.8301E-01_JPRB,2.3626E-01_JPRB,2.8733E-01_JPRB,&
 & 3.3525E-01_JPRB,3.7585E-01_JPRB,6.1586E+00_JPRB/)  
KAO( :, 4, 3, 5) = (/&
 & 1.6473E-02_JPRB,7.2618E-02_JPRB,1.3012E-01_JPRB,1.8637E-01_JPRB,2.4089E-01_JPRB,2.9345E-01_JPRB,&
 & 3.4253E-01_JPRB,3.8463E-01_JPRB,5.9399E+00_JPRB/)  
KAO( :, 5, 3, 5) = (/&
 & 1.5950E-02_JPRB,7.3287E-02_JPRB,1.3213E-01_JPRB,1.8950E-01_JPRB,2.4513E-01_JPRB,2.9856E-01_JPRB,&
 & 3.4870E-01_JPRB,3.9140E-01_JPRB,5.7373E+00_JPRB/)  
KAO( :, 1, 4, 5) = (/&
 & 1.5580E-02_JPRB,6.1790E-02_JPRB,1.0733E-01_JPRB,1.5233E-01_JPRB,1.9578E-01_JPRB,2.3731E-01_JPRB,&
 & 2.7596E-01_JPRB,3.0816E-01_JPRB,5.7644E+00_JPRB/)  
KAO( :, 2, 4, 5) = (/&
 & 1.4777E-02_JPRB,6.1923E-02_JPRB,1.0950E-01_JPRB,1.5621E-01_JPRB,2.0143E-01_JPRB,2.4487E-01_JPRB,&
 & 2.8520E-01_JPRB,3.1931E-01_JPRB,5.4929E+00_JPRB/)  
KAO( :, 3, 4, 5) = (/&
 & 1.4083E-02_JPRB,6.2360E-02_JPRB,1.1165E-01_JPRB,1.5990E-01_JPRB,2.0675E-01_JPRB,2.5162E-01_JPRB,&
 & 2.9363E-01_JPRB,3.2936E-01_JPRB,5.2479E+00_JPRB/)  
KAO( :, 4, 4, 5) = (/&
 & 1.3489E-02_JPRB,6.3056E-02_JPRB,1.1379E-01_JPRB,1.6338E-01_JPRB,2.1152E-01_JPRB,2.5770E-01_JPRB,&
 & 3.0103E-01_JPRB,3.3790E-01_JPRB,5.0295E+00_JPRB/)  
KAO( :, 5, 4, 5) = (/&
 & 1.2974E-02_JPRB,6.3786E-02_JPRB,1.1583E-01_JPRB,1.6662E-01_JPRB,2.1582E-01_JPRB,2.6318E-01_JPRB,&
 & 3.0742E-01_JPRB,3.4538E-01_JPRB,4.8395E+00_JPRB/)  
KAO( :, 1, 5, 5) = (/&
 & 1.3213E-02_JPRB,5.3251E-02_JPRB,9.2575E-02_JPRB,1.3138E-01_JPRB,1.6890E-01_JPRB,2.0468E-01_JPRB,&
 & 2.3789E-01_JPRB,2.6563E-01_JPRB,4.9912E+00_JPRB/)  
KAO( :, 2, 5, 5) = (/&
 & 1.2469E-02_JPRB,5.3471E-02_JPRB,9.4761E-02_JPRB,1.3531E-01_JPRB,1.7451E-01_JPRB,2.1205E-01_JPRB,&
 & 2.4715E-01_JPRB,2.7671E-01_JPRB,4.7367E+00_JPRB/)  
KAO( :, 3, 5, 5) = (/&
 & 1.1826E-02_JPRB,5.4006E-02_JPRB,9.6957E-02_JPRB,1.3905E-01_JPRB,1.7980E-01_JPRB,2.1900E-01_JPRB,&
 & 2.5553E-01_JPRB,2.8664E-01_JPRB,4.5084E+00_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART3',1,ZHOOK_HANDLE)
END SUBROUTINE PART3


SUBROUTINE PART4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART4',0,ZHOOK_HANDLE)


KAO( :, 4, 5, 5) = (/&
 & 1.1265E-02_JPRB,5.4777E-02_JPRB,9.9171E-02_JPRB,1.4252E-01_JPRB,1.8466E-01_JPRB,2.2509E-01_JPRB,&
 & 2.6296E-01_JPRB,2.9525E-01_JPRB,4.3062E+00_JPRB/)  
KAO( :, 5, 5, 5) = (/&
 & 1.0774E-02_JPRB,5.5536E-02_JPRB,1.0132E-01_JPRB,1.4589E-01_JPRB,1.8914E-01_JPRB,2.3064E-01_JPRB,&
 & 2.6960E-01_JPRB,3.0272E-01_JPRB,4.1237E+00_JPRB/)  
KAO( :, 1, 6, 5) = (/&
 & 1.1298E-02_JPRB,4.5718E-02_JPRB,7.9200E-02_JPRB,1.1232E-01_JPRB,1.4430E-01_JPRB,1.7486E-01_JPRB,&
 & 2.0309E-01_JPRB,2.2655E-01_JPRB,4.3329E+00_JPRB/)  
KAO( :, 2, 6, 5) = (/&
 & 1.0622E-02_JPRB,4.6005E-02_JPRB,8.1486E-02_JPRB,1.1629E-01_JPRB,1.5001E-01_JPRB,1.8222E-01_JPRB,&
 & 2.1218E-01_JPRB,2.3741E-01_JPRB,4.0960E+00_JPRB/)  
KAO( :, 3, 6, 5) = (/&
 & 1.0034E-02_JPRB,4.6615E-02_JPRB,8.3719E-02_JPRB,1.2009E-01_JPRB,1.5528E-01_JPRB,1.8897E-01_JPRB,&
 & 2.2052E-01_JPRB,2.4712E-01_JPRB,3.8879E+00_JPRB/)  
KAO( :, 4, 6, 5) = (/&
 & 9.5191E-03_JPRB,4.7402E-02_JPRB,8.5902E-02_JPRB,1.2353E-01_JPRB,1.5997E-01_JPRB,1.9501E-01_JPRB,&
 & 2.2766E-01_JPRB,2.5531E-01_JPRB,3.7023E+00_JPRB/)  
KAO( :, 5, 6, 5) = (/&
 & 9.0694E-03_JPRB,4.8127E-02_JPRB,8.7970E-02_JPRB,1.2673E-01_JPRB,1.6428E-01_JPRB,2.0026E-01_JPRB,&
 & 2.3384E-01_JPRB,2.6225E-01_JPRB,3.5368E+00_JPRB/)  
KAO( :, 1, 7, 5) = (/&
 & 9.7003E-03_JPRB,3.9103E-02_JPRB,6.7303E-02_JPRB,9.5321E-02_JPRB,1.2233E-01_JPRB,1.4806E-01_JPRB,&
 & 1.7192E-01_JPRB,1.9156E-01_JPRB,3.7979E+00_JPRB/)  
KAO( :, 2, 7, 5) = (/&
 & 9.0880E-03_JPRB,3.9405E-02_JPRB,6.9590E-02_JPRB,9.9254E-02_JPRB,1.2789E-01_JPRB,1.5530E-01_JPRB,&
 & 1.8072E-01_JPRB,2.0187E-01_JPRB,3.5772E+00_JPRB/)  
KAO( :, 3, 7, 5) = (/&
 & 8.5547E-03_JPRB,3.9999E-02_JPRB,7.1749E-02_JPRB,1.0282E-01_JPRB,1.3290E-01_JPRB,1.6166E-01_JPRB,&
 & 1.8835E-01_JPRB,2.1077E-01_JPRB,3.3854E+00_JPRB/)  
KAO( :, 4, 7, 5) = (/&
 & 8.0885E-03_JPRB,4.0699E-02_JPRB,7.3711E-02_JPRB,1.0595E-01_JPRB,1.3715E-01_JPRB,1.6698E-01_JPRB,&
 & 1.9485E-01_JPRB,2.1815E-01_JPRB,3.2157E+00_JPRB/)  
KAO( :, 5, 7, 5) = (/&
 & 7.6793E-03_JPRB,4.1301E-02_JPRB,7.5502E-02_JPRB,1.0878E-01_JPRB,1.4090E-01_JPRB,1.7170E-01_JPRB,&
 & 2.0034E-01_JPRB,2.2441E-01_JPRB,3.0651E+00_JPRB/)  
KAO( :, 1, 8, 5) = (/&
 & 8.3356E-03_JPRB,3.3311E-02_JPRB,5.6870E-02_JPRB,8.0308E-02_JPRB,1.0295E-01_JPRB,1.2448E-01_JPRB,&
 & 1.4428E-01_JPRB,1.6086E-01_JPRB,3.3908E+00_JPRB/)  
KAO( :, 2, 8, 5) = (/&
 & 7.7853E-03_JPRB,3.3608E-02_JPRB,5.9028E-02_JPRB,8.4055E-02_JPRB,1.0819E-01_JPRB,1.3119E-01_JPRB,&
 & 1.5248E-01_JPRB,1.7004E-01_JPRB,3.1845E+00_JPRB/)  
KAO( :, 3, 8, 5) = (/&
 & 7.3065E-03_JPRB,3.4089E-02_JPRB,6.0968E-02_JPRB,8.7276E-02_JPRB,1.1264E-01_JPRB,1.3686E-01_JPRB,&
 & 1.5934E-01_JPRB,1.7794E-01_JPRB,3.0043E+00_JPRB/)  
KAO( :, 4, 8, 5) = (/&
 & 6.8879E-03_JPRB,3.4663E-02_JPRB,6.2677E-02_JPRB,8.9967E-02_JPRB,1.1635E-01_JPRB,1.4158E-01_JPRB,&
 & 1.6491E-01_JPRB,1.8439E-01_JPRB,2.8456E+00_JPRB/)  
KAO( :, 5, 8, 5) = (/&
 & 6.5199E-03_JPRB,3.5157E-02_JPRB,6.4215E-02_JPRB,9.2448E-02_JPRB,1.1974E-01_JPRB,1.4577E-01_JPRB,&
 & 1.7002E-01_JPRB,1.9020E-01_JPRB,2.7064E+00_JPRB/)  
KAO( :, 1, 9, 5) = (/&
 & 7.1670E-03_JPRB,2.8264E-02_JPRB,4.7722E-02_JPRB,6.7185E-02_JPRB,8.5943E-02_JPRB,1.0376E-01_JPRB,&
 & 1.2019E-01_JPRB,1.3426E-01_JPRB,3.0087E+00_JPRB/)  
KAO( :, 2, 9, 5) = (/&
 & 6.6733E-03_JPRB,2.8499E-02_JPRB,4.9676E-02_JPRB,7.0525E-02_JPRB,9.0644E-02_JPRB,1.0983E-01_JPRB,&
 & 1.2746E-01_JPRB,1.4211E-01_JPRB,2.8169E+00_JPRB/)  
KAO( :, 3, 9, 5) = (/&
 & 6.2464E-03_JPRB,2.8870E-02_JPRB,5.1362E-02_JPRB,7.3368E-02_JPRB,9.4608E-02_JPRB,1.1481E-01_JPRB,&
 & 1.3345E-01_JPRB,1.4885E-01_JPRB,2.6506E+00_JPRB/)  
KAO( :, 4, 9, 5) = (/&
 & 5.8753E-03_JPRB,2.9313E-02_JPRB,5.2839E-02_JPRB,7.5761E-02_JPRB,9.7853E-02_JPRB,1.1892E-01_JPRB,&
 & 1.3848E-01_JPRB,1.5462E-01_JPRB,2.5062E+00_JPRB/)  
KAO( :, 5, 9, 5) = (/&
 & 5.5500E-03_JPRB,2.9736E-02_JPRB,5.4197E-02_JPRB,7.7953E-02_JPRB,1.0085E-01_JPRB,1.2274E-01_JPRB,&
 & 1.4297E-01_JPRB,1.5977E-01_JPRB,2.3796E+00_JPRB/)  
KAO( :, 1,10, 5) = (/&
 & 6.1244E-03_JPRB,2.3891E-02_JPRB,3.9969E-02_JPRB,5.6166E-02_JPRB,7.1759E-02_JPRB,8.6539E-02_JPRB,&
 & 1.0009E-01_JPRB,1.1231E-01_JPRB,2.6506E+00_JPRB/)  
KAO( :, 2,10, 5) = (/&
 & 5.6882E-03_JPRB,2.4047E-02_JPRB,4.1658E-02_JPRB,5.9064E-02_JPRB,7.5818E-02_JPRB,9.1738E-02_JPRB,&
 & 1.0641E-01_JPRB,1.1881E-01_JPRB,2.4752E+00_JPRB/)  
KAO( :, 3,10, 5) = (/&
 & 5.3134E-03_JPRB,2.4335E-02_JPRB,4.3112E-02_JPRB,6.1483E-02_JPRB,7.9176E-02_JPRB,9.6027E-02_JPRB,&
 & 1.1160E-01_JPRB,1.2443E-01_JPRB,2.3246E+00_JPRB/)  
KAO( :, 4,10, 5) = (/&
 & 4.9890E-03_JPRB,2.4682E-02_JPRB,4.4370E-02_JPRB,6.3529E-02_JPRB,8.2017E-02_JPRB,9.9655E-02_JPRB,&
 & 1.1591E-01_JPRB,1.2935E-01_JPRB,2.1952E+00_JPRB/)  
KAO( :, 5,10, 5) = (/&
 & 4.7070E-03_JPRB,2.5048E-02_JPRB,4.5565E-02_JPRB,6.5484E-02_JPRB,8.4705E-02_JPRB,1.0298E-01_JPRB,&
 & 1.1992E-01_JPRB,1.3395E-01_JPRB,2.0819E+00_JPRB/)  
KAO( :, 1,11, 5) = (/&
 & 5.0497E-03_JPRB,2.0186E-02_JPRB,3.4078E-02_JPRB,4.7979E-02_JPRB,6.1354E-02_JPRB,7.4036E-02_JPRB,&
 & 8.5636E-02_JPRB,9.6183E-02_JPRB,2.2490E+00_JPRB/)  
KAO( :, 2,11, 5) = (/&
 & 4.6938E-03_JPRB,2.0334E-02_JPRB,3.5429E-02_JPRB,5.0287E-02_JPRB,6.4580E-02_JPRB,7.8155E-02_JPRB,&
 & 9.0667E-02_JPRB,1.0125E-01_JPRB,2.1005E+00_JPRB/)  
KAO( :, 3,11, 5) = (/&
 & 4.3895E-03_JPRB,2.0572E-02_JPRB,3.6577E-02_JPRB,5.2195E-02_JPRB,6.7235E-02_JPRB,8.1560E-02_JPRB,&
 & 9.4765E-02_JPRB,1.0567E-01_JPRB,1.9750E+00_JPRB/)  
KAO( :, 4,11, 5) = (/&
 & 4.1271E-03_JPRB,2.0876E-02_JPRB,3.7641E-02_JPRB,5.3937E-02_JPRB,6.9658E-02_JPRB,8.4612E-02_JPRB,&
 & 9.8403E-02_JPRB,1.0977E-01_JPRB,1.8669E+00_JPRB/)  
KAO( :, 5,11, 5) = (/&
 & 3.8988E-03_JPRB,2.1198E-02_JPRB,3.8649E-02_JPRB,5.5601E-02_JPRB,7.1927E-02_JPRB,8.7466E-02_JPRB,&
 & 1.0184E-01_JPRB,1.1364E-01_JPRB,1.7763E+00_JPRB/)  
KAO( :, 1,12, 5) = (/&
 & 4.1728E-03_JPRB,1.6993E-02_JPRB,2.8852E-02_JPRB,4.0662E-02_JPRB,5.2011E-02_JPRB,6.2760E-02_JPRB,&
 & 7.2578E-02_JPRB,8.1564E-02_JPRB,1.9301E+00_JPRB/)  
KAO( :, 2,12, 5) = (/&
 & 3.8841E-03_JPRB,1.7115E-02_JPRB,2.9921E-02_JPRB,4.2476E-02_JPRB,5.4549E-02_JPRB,6.6006E-02_JPRB,&
 & 7.6561E-02_JPRB,8.5509E-02_JPRB,1.8048E+00_JPRB/)  
KAO( :, 3,12, 5) = (/&
 & 3.6372E-03_JPRB,1.7332E-02_JPRB,3.0872E-02_JPRB,4.4059E-02_JPRB,5.6757E-02_JPRB,6.8840E-02_JPRB,&
 & 7.9938E-02_JPRB,8.9112E-02_JPRB,1.6994E+00_JPRB/)  
KAO( :, 4,12, 5) = (/&
 & 3.4237E-03_JPRB,1.7595E-02_JPRB,3.1771E-02_JPRB,4.5538E-02_JPRB,5.8804E-02_JPRB,7.1398E-02_JPRB,&
 & 8.2985E-02_JPRB,9.2488E-02_JPRB,1.6111E+00_JPRB/)  
KAO( :, 5,12, 5) = (/&
 & 3.2373E-03_JPRB,1.7880E-02_JPRB,3.2595E-02_JPRB,4.6898E-02_JPRB,6.0660E-02_JPRB,7.3740E-02_JPRB,&
 & 8.5835E-02_JPRB,9.5657E-02_JPRB,1.5338E+00_JPRB/)  
KAO( :, 1,13, 5) = (/&
 & 3.4531E-03_JPRB,1.4217E-02_JPRB,2.4215E-02_JPRB,3.4135E-02_JPRB,4.3667E-02_JPRB,5.2684E-02_JPRB,&
 & 6.0918E-02_JPRB,6.8490E-02_JPRB,1.7191E+00_JPRB/)  
KAO( :, 2,13, 5) = (/&
 & 3.2166E-03_JPRB,1.4327E-02_JPRB,2.5086E-02_JPRB,3.5607E-02_JPRB,4.5722E-02_JPRB,5.5317E-02_JPRB,&
 & 6.4142E-02_JPRB,7.1650E-02_JPRB,1.6100E+00_JPRB/)  
KAO( :, 3,13, 5) = (/&
 & 3.0139E-03_JPRB,1.4515E-02_JPRB,2.5871E-02_JPRB,3.6915E-02_JPRB,4.7550E-02_JPRB,5.7658E-02_JPRB,&
 & 6.6926E-02_JPRB,7.4589E-02_JPRB,1.5199E+00_JPRB/)  
KAO( :, 4,13, 5) = (/&
 & 2.8380E-03_JPRB,1.4739E-02_JPRB,2.6616E-02_JPRB,3.8152E-02_JPRB,4.9253E-02_JPRB,5.9779E-02_JPRB,&
 & 6.9455E-02_JPRB,7.7339E-02_JPRB,1.4413E+00_JPRB/)  
KAO( :, 5,13, 5) = (/&
 & 2.6842E-03_JPRB,1.4990E-02_JPRB,2.7278E-02_JPRB,3.9228E-02_JPRB,5.0729E-02_JPRB,6.1660E-02_JPRB,&
 & 7.1747E-02_JPRB,7.9916E-02_JPRB,1.3713E+00_JPRB/)  
KAO( :, 1, 1, 6) = (/&
 & 3.8632E-02_JPRB,1.4563E-01_JPRB,2.6438E-01_JPRB,3.7994E-01_JPRB,4.9178E-01_JPRB,5.9825E-01_JPRB,&
 & 6.9697E-01_JPRB,7.7896E-01_JPRB,1.1356E+01_JPRB/)  
KAO( :, 2, 1, 6) = (/&
 & 3.7252E-02_JPRB,1.4645E-01_JPRB,2.6646E-01_JPRB,3.8318E-01_JPRB,4.9611E-01_JPRB,6.0391E-01_JPRB,&
 & 7.0433E-01_JPRB,7.8721E-01_JPRB,1.0913E+01_JPRB/)  
KAO( :, 3, 1, 6) = (/&
 & 3.6055E-02_JPRB,1.4710E-01_JPRB,2.6822E-01_JPRB,3.8583E-01_JPRB,4.9949E-01_JPRB,6.0852E-01_JPRB,&
 & 7.0979E-01_JPRB,7.9483E-01_JPRB,1.0530E+01_JPRB/)  
KAO( :, 4, 1, 6) = (/&
 & 3.5090E-02_JPRB,1.4760E-01_JPRB,2.6956E-01_JPRB,3.8772E-01_JPRB,5.0210E-01_JPRB,6.1181E-01_JPRB,&
 & 7.1390E-01_JPRB,7.9958E-01_JPRB,1.0180E+01_JPRB/)  
KAO( :, 5, 1, 6) = (/&
 & 3.4260E-02_JPRB,1.4804E-01_JPRB,2.7047E-01_JPRB,3.8919E-01_JPRB,5.0401E-01_JPRB,6.1383E-01_JPRB,&
 & 7.1642E-01_JPRB,8.0271E-01_JPRB,9.8574E+00_JPRB/)  
KAO( :, 1, 2, 6) = (/&
 & 3.1826E-02_JPRB,1.3117E-01_JPRB,2.4082E-01_JPRB,3.4734E-01_JPRB,4.4987E-01_JPRB,5.4781E-01_JPRB,&
 & 6.3804E-01_JPRB,7.1206E-01_JPRB,9.6043E+00_JPRB/)  
KAO( :, 2, 2, 6) = (/&
 & 3.0580E-02_JPRB,1.3188E-01_JPRB,2.4250E-01_JPRB,3.4978E-01_JPRB,4.5341E-01_JPRB,5.5237E-01_JPRB,&
 & 6.4380E-01_JPRB,7.1952E-01_JPRB,9.2042E+00_JPRB/)  
KAO( :, 3, 2, 6) = (/&
 & 2.9477E-02_JPRB,1.3242E-01_JPRB,2.4394E-01_JPRB,3.5199E-01_JPRB,4.5646E-01_JPRB,5.5595E-01_JPRB,&
 & 6.4859E-01_JPRB,7.2500E-01_JPRB,8.8547E+00_JPRB/)  
KAO( :, 4, 2, 6) = (/&
 & 2.8580E-02_JPRB,1.3291E-01_JPRB,2.4517E-01_JPRB,3.5389E-01_JPRB,4.5886E-01_JPRB,5.5917E-01_JPRB,&
 & 6.5208E-01_JPRB,7.2920E-01_JPRB,8.5255E+00_JPRB/)  
KAO( :, 5, 2, 6) = (/&
 & 2.7810E-02_JPRB,1.3345E-01_JPRB,2.4608E-01_JPRB,3.5526E-01_JPRB,4.6068E-01_JPRB,5.6160E-01_JPRB,&
 & 6.5500E-01_JPRB,7.3217E-01_JPRB,8.2220E+00_JPRB/)  
KAO( :, 1, 3, 6) = (/&
 & 2.6420E-02_JPRB,1.1646E-01_JPRB,2.1549E-01_JPRB,3.1138E-01_JPRB,4.0359E-01_JPRB,4.9120E-01_JPRB,&
 & 5.7225E-01_JPRB,6.3794E-01_JPRB,8.1678E+00_JPRB/)  
KAO( :, 2, 3, 6) = (/&
 & 2.5165E-02_JPRB,1.1697E-01_JPRB,2.1694E-01_JPRB,3.1375E-01_JPRB,4.0678E-01_JPRB,4.9551E-01_JPRB,&
 & 5.7728E-01_JPRB,6.4420E-01_JPRB,7.7828E+00_JPRB/)  
KAO( :, 3, 3, 6) = (/&
 & 2.4099E-02_JPRB,1.1741E-01_JPRB,2.1826E-01_JPRB,3.1581E-01_JPRB,4.0983E-01_JPRB,4.9937E-01_JPRB,&
 & 5.8185E-01_JPRB,6.4952E-01_JPRB,7.4421E+00_JPRB/)  
KAO( :, 4, 3, 6) = (/&
 & 2.3226E-02_JPRB,1.1793E-01_JPRB,2.1960E-01_JPRB,3.1782E-01_JPRB,4.1268E-01_JPRB,5.0276E-01_JPRB,&
 & 5.8605E-01_JPRB,6.5374E-01_JPRB,7.1416E+00_JPRB/)  
KAO( :, 5, 3, 6) = (/&
 & 2.2449E-02_JPRB,1.1853E-01_JPRB,2.2074E-01_JPRB,3.1965E-01_JPRB,4.1487E-01_JPRB,5.0573E-01_JPRB,&
 & 5.8935E-01_JPRB,6.5775E-01_JPRB,6.8702E+00_JPRB/)  
KAO( :, 1, 4, 6) = (/&
 & 2.2282E-02_JPRB,1.0267E-01_JPRB,1.9038E-01_JPRB,2.7507E-01_JPRB,3.5668E-01_JPRB,4.3406E-01_JPRB,&
 & 5.0509E-01_JPRB,5.6272E-01_JPRB,7.0192E+00_JPRB/)  
KAO( :, 2, 4, 6) = (/&
 & 2.1101E-02_JPRB,1.0311E-01_JPRB,1.9184E-01_JPRB,2.7754E-01_JPRB,3.5984E-01_JPRB,4.3790E-01_JPRB,&
 & 5.1005E-01_JPRB,5.6828E-01_JPRB,6.6594E+00_JPRB/)  
KAO( :, 3, 4, 6) = (/&
 & 2.0092E-02_JPRB,1.0356E-01_JPRB,1.9318E-01_JPRB,2.7978E-01_JPRB,3.6293E-01_JPRB,4.4207E-01_JPRB,&
 & 5.1463E-01_JPRB,5.7356E-01_JPRB,6.3438E+00_JPRB/)  
KAO( :, 4, 4, 6) = (/&
 & 1.9228E-02_JPRB,1.0414E-01_JPRB,1.9468E-01_JPRB,2.8199E-01_JPRB,3.6599E-01_JPRB,4.4583E-01_JPRB,&
 & 5.1913E-01_JPRB,5.7829E-01_JPRB,6.0576E+00_JPRB/)  
KAO( :, 5, 4, 6) = (/&
 & 1.8478E-02_JPRB,1.0486E-01_JPRB,1.9620E-01_JPRB,2.8416E-01_JPRB,3.6882E-01_JPRB,4.4907E-01_JPRB,&
 & 5.2302E-01_JPRB,5.8267E-01_JPRB,5.7987E+00_JPRB/)  
KAO( :, 1, 5, 6) = (/&
 & 1.8927E-02_JPRB,8.9665E-02_JPRB,1.6623E-01_JPRB,2.4010E-01_JPRB,3.1103E-01_JPRB,3.7843E-01_JPRB,&
 & 4.4012E-01_JPRB,4.9065E-01_JPRB,6.0454E+00_JPRB/)  
KAO( :, 2, 5, 6) = (/&
 & 1.7852E-02_JPRB,9.0154E-02_JPRB,1.6776E-01_JPRB,2.4246E-01_JPRB,3.1432E-01_JPRB,3.8239E-01_JPRB,&
 & 4.4467E-01_JPRB,4.9513E-01_JPRB,5.7165E+00_JPRB/)  
KAO( :, 3, 5, 6) = (/&
 & 1.6931E-02_JPRB,9.0711E-02_JPRB,1.6930E-01_JPRB,2.4502E-01_JPRB,3.1769E-01_JPRB,3.8643E-01_JPRB,&
 & 4.4965E-01_JPRB,5.0025E-01_JPRB,5.4249E+00_JPRB/)  
KAO( :, 4, 5, 6) = (/&
 & 1.6136E-02_JPRB,9.1383E-02_JPRB,1.7089E-01_JPRB,2.4749E-01_JPRB,3.2087E-01_JPRB,3.9057E-01_JPRB,&
 & 4.5430E-01_JPRB,5.0560E-01_JPRB,5.1610E+00_JPRB/)  
KAO( :, 5, 5, 6) = (/&
 & 1.5442E-02_JPRB,9.2230E-02_JPRB,1.7257E-01_JPRB,2.4990E-01_JPRB,3.2412E-01_JPRB,3.9447E-01_JPRB,&
 & 4.5892E-01_JPRB,5.1059E-01_JPRB,4.9249E+00_JPRB/)  
KAO( :, 1, 6, 6) = (/&
 & 1.6173E-02_JPRB,7.7572E-02_JPRB,1.4357E-01_JPRB,2.0729E-01_JPRB,2.6833E-01_JPRB,3.2615E-01_JPRB,&
 & 3.7930E-01_JPRB,4.2429E-01_JPRB,5.2215E+00_JPRB/)  
KAO( :, 2, 6, 6) = (/&
 & 1.5200E-02_JPRB,7.8077E-02_JPRB,1.4510E-01_JPRB,2.0962E-01_JPRB,2.7142E-01_JPRB,3.3008E-01_JPRB,&
 & 3.8383E-01_JPRB,4.2773E-01_JPRB,4.9175E+00_JPRB/)  
KAO( :, 3, 6, 6) = (/&
 & 1.4368E-02_JPRB,7.8730E-02_JPRB,1.4681E-01_JPRB,2.1218E-01_JPRB,2.7493E-01_JPRB,3.3435E-01_JPRB,&
 & 3.8857E-01_JPRB,4.3236E-01_JPRB,4.6498E+00_JPRB/)  
KAO( :, 4, 6, 6) = (/&
 & 1.3651E-02_JPRB,7.9498E-02_JPRB,1.4852E-01_JPRB,2.1489E-01_JPRB,2.7853E-01_JPRB,3.3867E-01_JPRB,&
 & 3.9393E-01_JPRB,4.3813E-01_JPRB,4.4118E+00_JPRB/)  
KAO( :, 5, 6, 6) = (/&
 & 1.3021E-02_JPRB,8.0512E-02_JPRB,1.5047E-01_JPRB,2.1785E-01_JPRB,2.8237E-01_JPRB,3.4356E-01_JPRB,&
 & 3.9943E-01_JPRB,4.4445E-01_JPRB,4.1985E+00_JPRB/)  
KAO( :, 1, 7, 6) = (/&
 & 1.3842E-02_JPRB,6.6570E-02_JPRB,1.2297E-01_JPRB,1.7734E-01_JPRB,2.2958E-01_JPRB,2.7900E-01_JPRB,&
 & 3.2406E-01_JPRB,3.6469E-01_JPRB,4.5564E+00_JPRB/)  
KAO( :, 2, 7, 6) = (/&
 & 1.2974E-02_JPRB,6.7120E-02_JPRB,1.2449E-01_JPRB,1.7977E-01_JPRB,2.3270E-01_JPRB,2.8277E-01_JPRB,&
 & 3.2872E-01_JPRB,3.6760E-01_JPRB,4.2769E+00_JPRB/)  
KAO( :, 3, 7, 6) = (/&
 & 1.2231E-02_JPRB,6.7829E-02_JPRB,1.2627E-01_JPRB,1.8248E-01_JPRB,2.3625E-01_JPRB,2.8721E-01_JPRB,&
 & 3.3397E-01_JPRB,3.7214E-01_JPRB,4.0308E+00_JPRB/)  
KAO( :, 4, 7, 6) = (/&
 & 1.1586E-02_JPRB,6.8704E-02_JPRB,1.2831E-01_JPRB,1.8551E-01_JPRB,2.4039E-01_JPRB,2.9244E-01_JPRB,&
 & 3.3993E-01_JPRB,3.7842E-01_JPRB,3.8137E+00_JPRB/)  
KAO( :, 5, 7, 6) = (/&
 & 1.1019E-02_JPRB,6.9935E-02_JPRB,1.3064E-01_JPRB,1.8899E-01_JPRB,2.4502E-01_JPRB,2.9795E-01_JPRB,&
 & 3.4661E-01_JPRB,3.8562E-01_JPRB,3.6208E+00_JPRB/)  
KAO( :, 1, 8, 6) = (/&
 & 1.1856E-02_JPRB,5.6687E-02_JPRB,1.0456E-01_JPRB,1.5068E-01_JPRB,1.9490E-01_JPRB,2.3680E-01_JPRB,&
 & 2.7529E-01_JPRB,3.1187E-01_JPRB,4.0573E+00_JPRB/)  
KAO( :, 2, 8, 6) = (/&
 & 1.1084E-02_JPRB,5.7283E-02_JPRB,1.0610E-01_JPRB,1.5305E-01_JPRB,1.9814E-01_JPRB,2.4092E-01_JPRB,&
 & 2.8002E-01_JPRB,3.1482E-01_JPRB,3.7969E+00_JPRB/)  
KAO( :, 3, 8, 6) = (/&
 & 1.0424E-02_JPRB,5.8111E-02_JPRB,1.0802E-01_JPRB,1.5601E-01_JPRB,2.0208E-01_JPRB,2.4566E-01_JPRB,&
 & 2.8562E-01_JPRB,3.1943E-01_JPRB,3.5697E+00_JPRB/)  
KAO( :, 4, 8, 6) = (/&
 & 9.8517E-03_JPRB,5.9109E-02_JPRB,1.1026E-01_JPRB,1.5951E-01_JPRB,2.0663E-01_JPRB,2.5128E-01_JPRB,&
 & 2.9237E-01_JPRB,3.2591E-01_JPRB,3.3690E+00_JPRB/)  
KAO( :, 5, 8, 6) = (/&
 & 9.3473E-03_JPRB,6.0458E-02_JPRB,1.1290E-01_JPRB,1.6330E-01_JPRB,2.1161E-01_JPRB,2.5747E-01_JPRB,&
 & 2.9929E-01_JPRB,3.3311E-01_JPRB,3.1918E+00_JPRB/)  
KAO( :, 1, 9, 6) = (/&
 & 1.0174E-02_JPRB,4.8047E-02_JPRB,8.8410E-02_JPRB,1.2743E-01_JPRB,1.6481E-01_JPRB,2.0018E-01_JPRB,&
 & 2.3315E-01_JPRB,2.6585E-01_JPRB,3.5956E+00_JPRB/)  
KAO( :, 2, 9, 6) = (/&
 & 9.4844E-03_JPRB,4.8661E-02_JPRB,9.0043E-02_JPRB,1.2994E-01_JPRB,1.6817E-01_JPRB,2.0441E-01_JPRB,&
 & 2.3776E-01_JPRB,2.6902E-01_JPRB,3.3539E+00_JPRB/)  
KAO( :, 3, 9, 6) = (/&
 & 8.8959E-03_JPRB,4.9547E-02_JPRB,9.2085E-02_JPRB,1.3295E-01_JPRB,1.7216E-01_JPRB,2.0943E-01_JPRB,&
 & 2.4369E-01_JPRB,2.7374E-01_JPRB,3.1436E+00_JPRB/)  
KAO( :, 4, 9, 6) = (/&
 & 8.3843E-03_JPRB,5.0652E-02_JPRB,9.4445E-02_JPRB,1.3652E-01_JPRB,1.7695E-01_JPRB,2.1526E-01_JPRB,&
 & 2.5026E-01_JPRB,2.7964E-01_JPRB,2.9597E+00_JPRB/)  
KAO( :, 5, 9, 6) = (/&
 & 7.9361E-03_JPRB,5.1996E-02_JPRB,9.7022E-02_JPRB,1.4032E-01_JPRB,1.8172E-01_JPRB,2.2081E-01_JPRB,&
 & 2.5660E-01_JPRB,2.8539E-01_JPRB,2.7995E+00_JPRB/)  
KAO( :, 1,10, 6) = (/&
 & 8.6910E-03_JPRB,4.0662E-02_JPRB,7.4709E-02_JPRB,1.0753E-01_JPRB,1.3903E-01_JPRB,1.6890E-01_JPRB,&
 & 1.9755E-01_JPRB,2.2624E-01_JPRB,3.1658E+00_JPRB/)  
KAO( :, 2,10, 6) = (/&
 & 8.0781E-03_JPRB,4.1334E-02_JPRB,7.6396E-02_JPRB,1.1015E-01_JPRB,1.4261E-01_JPRB,1.7346E-01_JPRB,&
 & 2.0195E-01_JPRB,2.2973E-01_JPRB,2.9443E+00_JPRB/)  
KAO( :, 3,10, 6) = (/&
 & 7.5558E-03_JPRB,4.2237E-02_JPRB,7.8425E-02_JPRB,1.1329E-01_JPRB,1.4677E-01_JPRB,1.7847E-01_JPRB,&
 & 2.0753E-01_JPRB,2.3421E-01_JPRB,2.7528E+00_JPRB/)  
KAO( :, 4,10, 6) = (/&
 & 7.1052E-03_JPRB,4.3295E-02_JPRB,8.0652E-02_JPRB,1.1657E-01_JPRB,1.5091E-01_JPRB,1.8339E-01_JPRB,&
 & 2.1320E-01_JPRB,2.3872E-01_JPRB,2.5875E+00_JPRB/)  
KAO( :, 5,10, 6) = (/&
 & 6.7112E-03_JPRB,4.4456E-02_JPRB,8.2854E-02_JPRB,1.1964E-01_JPRB,1.5483E-01_JPRB,1.8812E-01_JPRB,&
 & 2.1828E-01_JPRB,2.4305E-01_JPRB,2.4449E+00_JPRB/)  
KAO( :, 1,11, 6) = (/&
 & 7.1546E-03_JPRB,3.4641E-02_JPRB,6.3729E-02_JPRB,9.1774E-02_JPRB,1.1873E-01_JPRB,1.4430E-01_JPRB,&
 & 1.6899E-01_JPRB,1.9377E-01_JPRB,2.6800E+00_JPRB/)  
KAO( :, 2,11, 6) = (/&
 & 6.6497E-03_JPRB,3.5437E-02_JPRB,6.5581E-02_JPRB,9.4605E-02_JPRB,1.2249E-01_JPRB,1.4891E-01_JPRB,&
 & 1.7335E-01_JPRB,1.9740E-01_JPRB,2.4922E+00_JPRB/)  
KAO( :, 3,11, 6) = (/&
 & 6.2203E-03_JPRB,3.6291E-02_JPRB,6.7410E-02_JPRB,9.7360E-02_JPRB,1.2600E-01_JPRB,1.5308E-01_JPRB,&
 & 1.7786E-01_JPRB,2.0080E-01_JPRB,2.3311E+00_JPRB/)  
KAO( :, 4,11, 6) = (/&
 & 5.8484E-03_JPRB,3.7194E-02_JPRB,6.9237E-02_JPRB,9.9960E-02_JPRB,1.2931E-01_JPRB,1.5705E-01_JPRB,&
 & 1.8234E-01_JPRB,2.0415E-01_JPRB,2.1940E+00_JPRB/)  
KAO( :, 5,11, 6) = (/&
 & 5.5242E-03_JPRB,3.8204E-02_JPRB,7.1094E-02_JPRB,1.0253E-01_JPRB,1.3260E-01_JPRB,1.6091E-01_JPRB,&
 & 1.8653E-01_JPRB,2.0766E-01_JPRB,2.0745E+00_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART4',1,ZHOOK_HANDLE)
END SUBROUTINE PART4


SUBROUTINE PART5

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART5',0,ZHOOK_HANDLE)


KAO( :, 1,12, 6) = (/&
 & 5.8816E-03_JPRB,2.9599E-02_JPRB,5.4489E-02_JPRB,7.8480E-02_JPRB,1.0153E-01_JPRB,1.2338E-01_JPRB,&
 & 1.4461E-01_JPRB,1.6589E-01_JPRB,2.2985E+00_JPRB/)  
KAO( :, 2,12, 6) = (/&
 & 5.4688E-03_JPRB,3.0298E-02_JPRB,5.6046E-02_JPRB,8.0826E-02_JPRB,1.0456E-01_JPRB,1.2701E-01_JPRB,&
 & 1.4783E-01_JPRB,1.6844E-01_JPRB,2.1377E+00_JPRB/)  
KAO( :, 3,12, 6) = (/&
 & 5.1175E-03_JPRB,3.1020E-02_JPRB,5.7585E-02_JPRB,8.3084E-02_JPRB,1.0742E-01_JPRB,1.3040E-01_JPRB,&
 & 1.5140E-01_JPRB,1.7099E-01_JPRB,2.0023E+00_JPRB/)  
KAO( :, 4,12, 6) = (/&
 & 4.8144E-03_JPRB,3.1808E-02_JPRB,5.9123E-02_JPRB,8.5255E-02_JPRB,1.1020E-01_JPRB,1.3374E-01_JPRB,&
 & 1.5506E-01_JPRB,1.7366E-01_JPRB,1.8864E+00_JPRB/)  
KAO( :, 5,12, 6) = (/&
 & 4.5497E-03_JPRB,3.2704E-02_JPRB,6.0814E-02_JPRB,8.7626E-02_JPRB,1.1321E-01_JPRB,1.3720E-01_JPRB,&
 & 1.5886E-01_JPRB,1.7678E-01_JPRB,1.7844E+00_JPRB/)  
KAO( :, 1,13, 6) = (/&
 & 4.8422E-03_JPRB,2.5177E-02_JPRB,4.6344E-02_JPRB,6.6734E-02_JPRB,8.6291E-02_JPRB,1.0482E-01_JPRB,&
 & 1.2289E-01_JPRB,1.4102E-01_JPRB,2.0501E+00_JPRB/)  
KAO( :, 2,13, 6) = (/&
 & 4.5082E-03_JPRB,2.5759E-02_JPRB,4.7623E-02_JPRB,6.8651E-02_JPRB,8.8749E-02_JPRB,1.0771E-01_JPRB,&
 & 1.2536E-01_JPRB,1.4285E-01_JPRB,1.9088E+00_JPRB/)  
KAO( :, 3,13, 6) = (/&
 & 4.2221E-03_JPRB,2.6388E-02_JPRB,4.8921E-02_JPRB,7.0509E-02_JPRB,9.1098E-02_JPRB,1.1050E-01_JPRB,&
 & 1.2820E-01_JPRB,1.4481E-01_JPRB,1.7897E+00_JPRB/)  
KAO( :, 4,13, 6) = (/&
 & 3.9753E-03_JPRB,2.7097E-02_JPRB,5.0270E-02_JPRB,7.2404E-02_JPRB,9.3520E-02_JPRB,1.1341E-01_JPRB,&
 & 1.3134E-01_JPRB,1.4713E-01_JPRB,1.6870E+00_JPRB/)  
KAO( :, 5,13, 6) = (/&
 & 3.7603E-03_JPRB,2.7904E-02_JPRB,5.1825E-02_JPRB,7.4620E-02_JPRB,9.6277E-02_JPRB,1.1654E-01_JPRB,&
 & 1.3481E-01_JPRB,1.4987E-01_JPRB,1.5960E+00_JPRB/)  
KAO( :, 1, 1, 7) = (/&
 & 5.2128E-02_JPRB,2.2573E-01_JPRB,4.1698E-01_JPRB,6.0142E-01_JPRB,7.7838E-01_JPRB,9.4635E-01_JPRB,&
 & 1.1013E+00_JPRB,1.2264E+00_JPRB,1.2683E+01_JPRB/)  
KAO( :, 2, 1, 7) = (/&
 & 5.0382E-02_JPRB,2.2718E-01_JPRB,4.1897E-01_JPRB,6.0369E-01_JPRB,7.8036E-01_JPRB,9.4806E-01_JPRB,&
 & 1.1011E+00_JPRB,1.2250E+00_JPRB,1.2078E+01_JPRB/)  
KAO( :, 3, 1, 7) = (/&
 & 4.9050E-02_JPRB,2.2916E-01_JPRB,4.2172E-01_JPRB,6.0675E-01_JPRB,7.8406E-01_JPRB,9.5134E-01_JPRB,&
 & 1.1038E+00_JPRB,1.2245E+00_JPRB,1.1561E+01_JPRB/)  
KAO( :, 4, 1, 7) = (/&
 & 4.8000E-02_JPRB,2.3161E-01_JPRB,4.2498E-01_JPRB,6.1081E-01_JPRB,7.8880E-01_JPRB,9.5615E-01_JPRB,&
 & 1.1084E+00_JPRB,1.2283E+00_JPRB,1.1090E+01_JPRB/)  
KAO( :, 5, 1, 7) = (/&
 & 4.7267E-02_JPRB,2.3436E-01_JPRB,4.2865E-01_JPRB,6.1543E-01_JPRB,7.9387E-01_JPRB,9.6245E-01_JPRB,&
 & 1.1147E+00_JPRB,1.2334E+00_JPRB,1.0665E+01_JPRB/)  
KAO( :, 1, 2, 7) = (/&
 & 4.2932E-02_JPRB,2.1372E-01_JPRB,3.9561E-01_JPRB,5.6920E-01_JPRB,7.3515E-01_JPRB,8.9082E-01_JPRB,&
 & 1.0322E+00_JPRB,1.1443E+00_JPRB,1.0613E+01_JPRB/)  
KAO( :, 2, 2, 7) = (/&
 & 4.1235E-02_JPRB,2.1562E-01_JPRB,3.9903E-01_JPRB,5.7421E-01_JPRB,7.4053E-01_JPRB,8.9640E-01_JPRB,&
 & 1.0375E+00_JPRB,1.1460E+00_JPRB,1.0106E+01_JPRB/)  
KAO( :, 3, 2, 7) = (/&
 & 3.9904E-02_JPRB,2.1797E-01_JPRB,4.0322E-01_JPRB,5.7993E-01_JPRB,7.4744E-01_JPRB,9.0475E-01_JPRB,&
 & 1.0452E+00_JPRB,1.1527E+00_JPRB,9.6511E+00_JPRB/)  
KAO( :, 4, 2, 7) = (/&
 & 3.8807E-02_JPRB,2.2063E-01_JPRB,4.0792E-01_JPRB,5.8615E-01_JPRB,7.5558E-01_JPRB,9.1342E-01_JPRB,&
 & 1.0550E+00_JPRB,1.1616E+00_JPRB,9.2444E+00_JPRB/)  
KAO( :, 5, 2, 7) = (/&
 & 3.7944E-02_JPRB,2.2348E-01_JPRB,4.1278E-01_JPRB,5.9308E-01_JPRB,7.6392E-01_JPRB,9.2334E-01_JPRB,&
 & 1.0654E+00_JPRB,1.1718E+00_JPRB,8.8704E+00_JPRB/)  
KAO( :, 1, 3, 7) = (/&
 & 3.5644E-02_JPRB,1.9900E-01_JPRB,3.6873E-01_JPRB,5.2969E-01_JPRB,6.8262E-01_JPRB,8.2576E-01_JPRB,&
 & 9.5330E-01_JPRB,1.0560E+00_JPRB,9.0225E+00_JPRB/)  
KAO( :, 2, 3, 7) = (/&
 & 3.3919E-02_JPRB,2.0128E-01_JPRB,3.7328E-01_JPRB,5.3629E-01_JPRB,6.9070E-01_JPRB,8.3419E-01_JPRB,&
 & 9.6259E-01_JPRB,1.0599E+00_JPRB,8.5592E+00_JPRB/)  
KAO( :, 3, 3, 7) = (/&
 & 3.2476E-02_JPRB,2.0401E-01_JPRB,3.7867E-01_JPRB,5.4408E-01_JPRB,7.0000E-01_JPRB,8.4506E-01_JPRB,&
 & 9.7370E-01_JPRB,1.0690E+00_JPRB,8.1409E+00_JPRB/)  
KAO( :, 4, 3, 7) = (/&
 & 3.1249E-02_JPRB,2.0698E-01_JPRB,3.8457E-01_JPRB,5.5225E-01_JPRB,7.1038E-01_JPRB,8.5708E-01_JPRB,&
 & 9.8671E-01_JPRB,1.0811E+00_JPRB,7.7623E+00_JPRB/)  
KAO( :, 5, 3, 7) = (/&
 & 3.0275E-02_JPRB,2.1021E-01_JPRB,3.9069E-01_JPRB,5.6104E-01_JPRB,7.2150E-01_JPRB,8.6973E-01_JPRB,&
 & 1.0004E+00_JPRB,1.0948E+00_JPRB,7.4273E+00_JPRB/)  
KAO( :, 1, 4, 7) = (/&
 & 3.0097E-02_JPRB,1.8261E-01_JPRB,3.3811E-01_JPRB,4.8498E-01_JPRB,6.2347E-01_JPRB,7.5244E-01_JPRB,&
 & 8.6689E-01_JPRB,9.6397E-01_JPRB,7.7267E+00_JPRB/)  
KAO( :, 2, 4, 7) = (/&
 & 2.8465E-02_JPRB,1.8532E-01_JPRB,3.4351E-01_JPRB,4.9262E-01_JPRB,6.3341E-01_JPRB,7.6377E-01_JPRB,&
 & 8.7850E-01_JPRB,9.6891E-01_JPRB,7.2971E+00_JPRB/)  
KAO( :, 3, 4, 7) = (/&
 & 2.7069E-02_JPRB,1.8851E-01_JPRB,3.4990E-01_JPRB,5.0190E-01_JPRB,6.4465E-01_JPRB,7.7654E-01_JPRB,&
 & 8.9285E-01_JPRB,9.7883E-01_JPRB,6.9159E+00_JPRB/)  
KAO( :, 4, 4, 7) = (/&
 & 2.5871E-02_JPRB,1.9199E-01_JPRB,3.5682E-01_JPRB,5.1175E-01_JPRB,6.5706E-01_JPRB,7.9119E-01_JPRB,&
 & 9.0820E-01_JPRB,9.9217E-01_JPRB,6.5751E+00_JPRB/)  
KAO( :, 5, 4, 7) = (/&
 & 2.4866E-02_JPRB,1.9576E-01_JPRB,3.6404E-01_JPRB,5.2207E-01_JPRB,6.7030E-01_JPRB,8.0638E-01_JPRB,&
 & 9.2498E-01_JPRB,1.0073E+00_JPRB,6.2687E+00_JPRB/)  
KAO( :, 1, 5, 7) = (/&
 & 2.5614E-02_JPRB,1.6487E-01_JPRB,3.0459E-01_JPRB,4.3623E-01_JPRB,5.5976E-01_JPRB,6.7396E-01_JPRB,&
 & 7.7520E-01_JPRB,8.6835E-01_JPRB,6.6219E+00_JPRB/)  
KAO( :, 2, 5, 7) = (/&
 & 2.4116E-02_JPRB,1.6799E-01_JPRB,3.1096E-01_JPRB,4.4514E-01_JPRB,5.7096E-01_JPRB,6.8731E-01_JPRB,&
 & 7.8907E-01_JPRB,8.7442E-01_JPRB,6.2328E+00_JPRB/)  
KAO( :, 3, 5, 7) = (/&
 & 2.2830E-02_JPRB,1.7162E-01_JPRB,3.1815E-01_JPRB,4.5551E-01_JPRB,5.8428E-01_JPRB,7.0249E-01_JPRB,&
 & 8.0544E-01_JPRB,8.8480E-01_JPRB,5.8899E+00_JPRB/)  
KAO( :, 4, 5, 7) = (/&
 & 2.1736E-02_JPRB,1.7560E-01_JPRB,3.2603E-01_JPRB,4.6697E-01_JPRB,5.9854E-01_JPRB,7.1908E-01_JPRB,&
 & 8.2326E-01_JPRB,8.9862E-01_JPRB,5.5832E+00_JPRB/)  
KAO( :, 5, 5, 7) = (/&
 & 2.0809E-02_JPRB,1.7988E-01_JPRB,3.3435E-01_JPRB,4.7875E-01_JPRB,6.1356E-01_JPRB,7.3657E-01_JPRB,&
 & 8.4234E-01_JPRB,9.1423E-01_JPRB,5.3090E+00_JPRB/)  
KAO( :, 1, 6, 7) = (/&
 & 2.1880E-02_JPRB,1.4623E-01_JPRB,2.6962E-01_JPRB,3.8553E-01_JPRB,4.9437E-01_JPRB,5.9458E-01_JPRB,&
 & 6.8464E-01_JPRB,7.7290E-01_JPRB,5.6893E+00_JPRB/)  
KAO( :, 2, 6, 7) = (/&
 & 2.0541E-02_JPRB,1.4964E-01_JPRB,2.7646E-01_JPRB,3.9534E-01_JPRB,5.0653E-01_JPRB,6.0867E-01_JPRB,&
 & 6.9802E-01_JPRB,7.7944E-01_JPRB,5.3383E+00_JPRB/)  
KAO( :, 3, 6, 7) = (/&
 & 1.9387E-02_JPRB,1.5367E-01_JPRB,2.8442E-01_JPRB,4.0664E-01_JPRB,5.2073E-01_JPRB,6.2519E-01_JPRB,&
 & 7.1506E-01_JPRB,7.9013E-01_JPRB,5.0300E+00_JPRB/)  
KAO( :, 4, 6, 7) = (/&
 & 1.8399E-02_JPRB,1.5808E-01_JPRB,2.9302E-01_JPRB,4.1898E-01_JPRB,5.3609E-01_JPRB,6.4281E-01_JPRB,&
 & 7.3443E-01_JPRB,8.0386E-01_JPRB,4.7570E+00_JPRB/)  
KAO( :, 5, 6, 7) = (/&
 & 1.7565E-02_JPRB,1.6282E-01_JPRB,3.0216E-01_JPRB,4.3178E-01_JPRB,5.5216E-01_JPRB,6.6163E-01_JPRB,&
 & 7.5404E-01_JPRB,8.1847E-01_JPRB,4.5125E+00_JPRB/)  
KAO( :, 1, 7, 7) = (/&
 & 1.8714E-02_JPRB,1.2767E-01_JPRB,2.3517E-01_JPRB,3.3585E-01_JPRB,4.3014E-01_JPRB,5.1698E-01_JPRB,&
 & 5.9889E-01_JPRB,6.8052E-01_JPRB,4.9475E+00_JPRB/)  
KAO( :, 2, 7, 7) = (/&
 & 1.7519E-02_JPRB,1.3119E-01_JPRB,2.4211E-01_JPRB,3.4588E-01_JPRB,4.4292E-01_JPRB,5.3168E-01_JPRB,&
 & 6.1066E-01_JPRB,6.8710E-01_JPRB,4.6289E+00_JPRB/)  
KAO( :, 3, 7, 7) = (/&
 & 1.6495E-02_JPRB,1.3547E-01_JPRB,2.5037E-01_JPRB,3.5759E-01_JPRB,4.5729E-01_JPRB,5.4816E-01_JPRB,&
 & 6.2674E-01_JPRB,6.9772E-01_JPRB,4.3494E+00_JPRB/)  
KAO( :, 4, 7, 7) = (/&
 & 1.5623E-02_JPRB,1.4024E-01_JPRB,2.5938E-01_JPRB,3.7018E-01_JPRB,4.7307E-01_JPRB,5.6640E-01_JPRB,&
 & 6.4533E-01_JPRB,7.1032E-01_JPRB,4.1027E+00_JPRB/)  
KAO( :, 5, 7, 7) = (/&
 & 1.4883E-02_JPRB,1.4521E-01_JPRB,2.6879E-01_JPRB,3.8347E-01_JPRB,4.8911E-01_JPRB,5.8444E-01_JPRB,&
 & 6.6428E-01_JPRB,7.2392E-01_JPRB,3.8827E+00_JPRB/)  
KAO( :, 1, 8, 7) = (/&
 & 1.6011E-02_JPRB,1.1016E-01_JPRB,2.0259E-01_JPRB,2.8923E-01_JPRB,3.7024E-01_JPRB,4.4570E-01_JPRB,&
 & 5.1977E-01_JPRB,5.9363E-01_JPRB,4.3984E+00_JPRB/)  
KAO( :, 2, 8, 7) = (/&
 & 1.4948E-02_JPRB,1.1367E-01_JPRB,2.0954E-01_JPRB,2.9900E-01_JPRB,3.8239E-01_JPRB,4.5865E-01_JPRB,&
 & 5.2962E-01_JPRB,5.9992E-01_JPRB,4.1028E+00_JPRB/)  
KAO( :, 3, 8, 7) = (/&
 & 1.4043E-02_JPRB,1.1790E-01_JPRB,2.1765E-01_JPRB,3.1052E-01_JPRB,3.9683E-01_JPRB,4.7512E-01_JPRB,&
 & 5.4401E-01_JPRB,6.0979E-01_JPRB,3.8451E+00_JPRB/)  
KAO( :, 4, 8, 7) = (/&
 & 1.3277E-02_JPRB,1.2271E-01_JPRB,2.2662E-01_JPRB,3.2293E-01_JPRB,4.1184E-01_JPRB,4.9204E-01_JPRB,&
 & 5.6016E-01_JPRB,6.2114E-01_JPRB,3.6180E+00_JPRB/)  
KAO( :, 5, 8, 7) = (/&
 & 1.2628E-02_JPRB,1.2779E-01_JPRB,2.3576E-01_JPRB,3.3533E-01_JPRB,4.2713E-01_JPRB,5.0925E-01_JPRB,&
 & 5.7770E-01_JPRB,6.3359E-01_JPRB,3.4160E+00_JPRB/)  
KAO( :, 1, 9, 7) = (/&
 & 1.3722E-02_JPRB,9.3985E-02_JPRB,1.7271E-01_JPRB,2.4639E-01_JPRB,3.1541E-01_JPRB,3.8164E-01_JPRB,&
 & 4.4798E-01_JPRB,5.1362E-01_JPRB,3.8929E+00_JPRB/)  
KAO( :, 2, 9, 7) = (/&
 & 1.2777E-02_JPRB,9.7414E-02_JPRB,1.7934E-01_JPRB,2.5581E-01_JPRB,3.2699E-01_JPRB,3.9259E-01_JPRB,&
 & 4.5617E-01_JPRB,5.1941E-01_JPRB,3.6200E+00_JPRB/)  
KAO( :, 3, 9, 7) = (/&
 & 1.1979E-02_JPRB,1.0152E-01_JPRB,1.8716E-01_JPRB,2.6666E-01_JPRB,3.4026E-01_JPRB,4.0688E-01_JPRB,&
 & 4.6784E-01_JPRB,5.2783E-01_JPRB,3.3828E+00_JPRB/)  
KAO( :, 4, 9, 7) = (/&
 & 1.1306E-02_JPRB,1.0607E-01_JPRB,1.9536E-01_JPRB,2.7793E-01_JPRB,3.5411E-01_JPRB,4.2250E-01_JPRB,&
 & 4.8212E-01_JPRB,5.3856E-01_JPRB,3.1744E+00_JPRB/)  
KAO( :, 5, 9, 7) = (/&
 & 1.0737E-02_JPRB,1.1080E-01_JPRB,2.0394E-01_JPRB,2.8968E-01_JPRB,3.6840E-01_JPRB,4.3899E-01_JPRB,&
 & 4.9835E-01_JPRB,5.5128E-01_JPRB,2.9902E+00_JPRB/)  
KAO( :, 1,10, 7) = (/&
 & 1.1712E-02_JPRB,7.9698E-02_JPRB,1.4636E-01_JPRB,2.0884E-01_JPRB,2.6772E-01_JPRB,3.2572E-01_JPRB,&
 & 3.8403E-01_JPRB,4.4146E-01_JPRB,3.4238E+00_JPRB/)  
KAO( :, 2,10, 7) = (/&
 & 1.0885E-02_JPRB,8.2934E-02_JPRB,1.5255E-01_JPRB,2.1737E-01_JPRB,2.7766E-01_JPRB,3.3439E-01_JPRB,&
 & 3.9066E-01_JPRB,4.4635E-01_JPRB,3.1745E+00_JPRB/)  
KAO( :, 3,10, 7) = (/&
 & 1.0188E-02_JPRB,8.6824E-02_JPRB,1.5967E-01_JPRB,2.2716E-01_JPRB,2.8954E-01_JPRB,3.4626E-01_JPRB,&
 & 4.0034E-01_JPRB,4.5401E-01_JPRB,2.9589E+00_JPRB/)  
KAO( :, 4,10, 7) = (/&
 & 9.6011E-03_JPRB,9.1065E-02_JPRB,1.6737E-01_JPRB,2.3778E-01_JPRB,3.0267E-01_JPRB,3.6104E-01_JPRB,&
 & 4.1369E-01_JPRB,4.6516E-01_JPRB,2.7702E+00_JPRB/)  
KAO( :, 5,10, 7) = (/&
 & 9.1043E-03_JPRB,9.5561E-02_JPRB,1.7554E-01_JPRB,2.4912E-01_JPRB,3.1674E-01_JPRB,3.7708E-01_JPRB,&
 & 4.2925E-01_JPRB,4.7811E-01_JPRB,2.6047E+00_JPRB/)  
KAO( :, 1,11, 7) = (/&
 & 9.6600E-03_JPRB,6.8416E-02_JPRB,1.2568E-01_JPRB,1.7918E-01_JPRB,2.2969E-01_JPRB,2.7960E-01_JPRB,&
 & 3.2973E-01_JPRB,3.7899E-01_JPRB,2.8930E+00_JPRB/)  
KAO( :, 2,11, 7) = (/&
 & 8.9878E-03_JPRB,7.1652E-02_JPRB,1.3155E-01_JPRB,1.8712E-01_JPRB,2.3867E-01_JPRB,2.8757E-01_JPRB,&
 & 3.3629E-01_JPRB,3.8441E-01_JPRB,2.6816E+00_JPRB/)  
KAO( :, 3,11, 7) = (/&
 & 8.4222E-03_JPRB,7.5378E-02_JPRB,1.3835E-01_JPRB,1.9668E-01_JPRB,2.5051E-01_JPRB,2.9968E-01_JPRB,&
 & 3.4702E-01_JPRB,3.9398E-01_JPRB,2.4985E+00_JPRB/)  
KAO( :, 4,11, 7) = (/&
 & 7.9456E-03_JPRB,7.9499E-02_JPRB,1.4588E-01_JPRB,2.0704E-01_JPRB,2.6333E-01_JPRB,3.1396E-01_JPRB,&
 & 3.6037E-01_JPRB,4.0593E-01_JPRB,2.3394E+00_JPRB/)  
KAO( :, 5,11, 7) = (/&
 & 7.5367E-03_JPRB,8.3782E-02_JPRB,1.5372E-01_JPRB,2.1807E-01_JPRB,2.7700E-01_JPRB,3.2966E-01_JPRB,&
 & 3.7579E-01_JPRB,4.1961E-01_JPRB,2.2005E+00_JPRB/)  
KAO( :, 1,12, 7) = (/&
 & 7.9651E-03_JPRB,5.8686E-02_JPRB,1.0769E-01_JPRB,1.5334E-01_JPRB,1.9661E-01_JPRB,2.3953E-01_JPRB,&
 & 2.8260E-01_JPRB,3.2486E-01_JPRB,2.4784E+00_JPRB/)  
KAO( :, 2,12, 7) = (/&
 & 7.4154E-03_JPRB,6.1767E-02_JPRB,1.1336E-01_JPRB,1.6127E-01_JPRB,2.0569E-01_JPRB,2.4818E-01_JPRB,&
 & 2.9059E-01_JPRB,3.3236E-01_JPRB,2.2967E+00_JPRB/)  
KAO( :, 3,12, 7) = (/&
 & 6.9534E-03_JPRB,6.5368E-02_JPRB,1.1996E-01_JPRB,1.7048E-01_JPRB,2.1709E-01_JPRB,2.5998E-01_JPRB,&
 & 3.0158E-01_JPRB,3.4278E-01_JPRB,2.1399E+00_JPRB/)  
KAO( :, 4,12, 7) = (/&
 & 6.5627E-03_JPRB,6.9215E-02_JPRB,1.2702E-01_JPRB,1.8030E-01_JPRB,2.2939E-01_JPRB,2.7353E-01_JPRB,&
 & 3.1454E-01_JPRB,3.5481E-01_JPRB,2.0047E+00_JPRB/)  
KAO( :, 5,12, 7) = (/&
 & 6.2252E-03_JPRB,7.3310E-02_JPRB,1.3449E-01_JPRB,1.9068E-01_JPRB,2.4194E-01_JPRB,2.8763E-01_JPRB,&
 & 3.2799E-01_JPRB,3.6662E-01_JPRB,1.8867E+00_JPRB/)  
KAO( :, 1,13, 7) = (/&
 & 6.5616E-03_JPRB,5.0380E-02_JPRB,9.2460E-02_JPRB,1.3167E-01_JPRB,1.6900E-01_JPRB,2.0616E-01_JPRB,&
 & 2.4338E-01_JPRB,2.7988E-01_JPRB,2.2117E+00_JPRB/)  
KAO( :, 2,13, 7) = (/&
 & 6.1120E-03_JPRB,5.3375E-02_JPRB,9.7998E-02_JPRB,1.3948E-01_JPRB,1.7796E-01_JPRB,2.1500E-01_JPRB,&
 & 2.5201E-01_JPRB,2.8843E-01_JPRB,2.0497E+00_JPRB/)  
KAO( :, 3,13, 7) = (/&
 & 5.7372E-03_JPRB,5.6731E-02_JPRB,1.0419E-01_JPRB,1.4804E-01_JPRB,1.8846E-01_JPRB,2.2583E-01_JPRB,&
 & 2.6228E-01_JPRB,2.9829E-01_JPRB,1.9105E+00_JPRB/)  
KAO( :, 4,13, 7) = (/&
 & 5.4187E-03_JPRB,6.0281E-02_JPRB,1.1054E-01_JPRB,1.5676E-01_JPRB,1.9913E-01_JPRB,2.3709E-01_JPRB,&
 & 2.7280E-01_JPRB,3.0791E-01_JPRB,1.7905E+00_JPRB/)  
KAO( :, 5,13, 7) = (/&
 & 5.1412E-03_JPRB,6.3942E-02_JPRB,1.1702E-01_JPRB,1.6550E-01_JPRB,2.0967E-01_JPRB,2.4883E-01_JPRB,&
 & 2.8378E-01_JPRB,3.1751E-01_JPRB,1.6855E+00_JPRB/)  
KAO( :, 1, 1, 8) = (/&
 & 8.0925E-02_JPRB,4.4695E-01_JPRB,8.0232E-01_JPRB,1.1226E+00_JPRB,1.4103E+00_JPRB,1.6623E+00_JPRB,&
 & 1.8647E+00_JPRB,1.9976E+00_JPRB,1.3169E+01_JPRB/)  
KAO( :, 2, 1, 8) = (/&
 & 7.9475E-02_JPRB,4.6155E-01_JPRB,8.2577E-01_JPRB,1.1515E+00_JPRB,1.4434E+00_JPRB,1.6972E+00_JPRB,&
 & 1.8967E+00_JPRB,2.0110E+00_JPRB,1.2516E+01_JPRB/)  
KAO( :, 3, 1, 8) = (/&
 & 7.9284E-02_JPRB,4.7585E-01_JPRB,8.4839E-01_JPRB,1.1813E+00_JPRB,1.4771E+00_JPRB,1.7315E+00_JPRB,&
 & 1.9304E+00_JPRB,2.0281E+00_JPRB,1.1933E+01_JPRB/)  
KAO( :, 4, 1, 8) = (/&
 & 8.0560E-02_JPRB,4.9019E-01_JPRB,8.7148E-01_JPRB,1.2102E+00_JPRB,1.5100E+00_JPRB,1.7671E+00_JPRB,&
 & 1.9624E+00_JPRB,2.0460E+00_JPRB,1.1433E+01_JPRB/)  
KAO( :, 5, 1, 8) = (/&
 & 8.3397E-02_JPRB,5.0455E-01_JPRB,8.9392E-01_JPRB,1.2384E+00_JPRB,1.5426E+00_JPRB,1.7995E+00_JPRB,&
 & 1.9927E+00_JPRB,2.0655E+00_JPRB,1.1063E+01_JPRB/)  
KAO( :, 1, 2, 8) = (/&
 & 6.6575E-02_JPRB,4.3479E-01_JPRB,7.7702E-01_JPRB,1.0845E+00_JPRB,1.3608E+00_JPRB,1.6027E+00_JPRB,&
 & 1.7979E+00_JPRB,1.9533E+00_JPRB,1.1027E+01_JPRB/)  
KAO( :, 2, 2, 8) = (/&
 & 6.4692E-02_JPRB,4.5045E-01_JPRB,8.0204E-01_JPRB,1.1153E+00_JPRB,1.3951E+00_JPRB,1.6384E+00_JPRB,&
 & 1.8309E+00_JPRB,1.9634E+00_JPRB,1.0460E+01_JPRB/)  
KAO( :, 3, 2, 8) = (/&
 & 6.3712E-02_JPRB,4.6604E-01_JPRB,8.2695E-01_JPRB,1.1467E+00_JPRB,1.4311E+00_JPRB,1.6740E+00_JPRB,&
 & 1.8639E+00_JPRB,1.9755E+00_JPRB,9.9574E+00_JPRB/)  
KAO( :, 4, 2, 8) = (/&
 & 6.3793E-02_JPRB,4.8171E-01_JPRB,8.5176E-01_JPRB,1.1782E+00_JPRB,1.4648E+00_JPRB,1.7096E+00_JPRB,&
 & 1.8945E+00_JPRB,1.9900E+00_JPRB,9.5122E+00_JPRB/)  
KAO( :, 5, 2, 8) = (/&
 & 6.5076E-02_JPRB,4.9750E-01_JPRB,8.7656E-01_JPRB,1.2084E+00_JPRB,1.4992E+00_JPRB,1.7428E+00_JPRB,&
 & 1.9259E+00_JPRB,2.0066E+00_JPRB,9.1382E+00_JPRB/)  
KAO( :, 1, 3, 8) = (/&
 & 5.5145E-02_JPRB,4.1677E-01_JPRB,7.4511E-01_JPRB,1.0407E+00_JPRB,1.3075E+00_JPRB,1.5427E+00_JPRB,&
 & 1.7389E+00_JPRB,1.9204E+00_JPRB,9.3514E+00_JPRB/)  
KAO( :, 2, 3, 8) = (/&
 & 5.2833E-02_JPRB,4.3270E-01_JPRB,7.7006E-01_JPRB,1.0719E+00_JPRB,1.3419E+00_JPRB,1.5776E+00_JPRB,&
 & 1.7672E+00_JPRB,1.9272E+00_JPRB,8.8440E+00_JPRB/)  
KAO( :, 3, 3, 8) = (/&
 & 5.1113E-02_JPRB,4.4882E-01_JPRB,7.9562E-01_JPRB,1.1025E+00_JPRB,1.3760E+00_JPRB,1.6125E+00_JPRB,&
 & 1.7982E+00_JPRB,1.9366E+00_JPRB,8.3935E+00_JPRB/)  
KAO( :, 4, 3, 8) = (/&
 & 5.0028E-02_JPRB,4.6513E-01_JPRB,8.2062E-01_JPRB,1.1341E+00_JPRB,1.4094E+00_JPRB,1.6457E+00_JPRB,&
 & 1.8296E+00_JPRB,1.9485E+00_JPRB,7.9906E+00_JPRB/)  
KAO( :, 5, 3, 8) = (/&
 & 4.9686E-02_JPRB,4.8163E-01_JPRB,8.4610E-01_JPRB,1.1641E+00_JPRB,1.4433E+00_JPRB,1.6796E+00_JPRB,&
 & 1.8613E+00_JPRB,1.9622E+00_JPRB,7.6298E+00_JPRB/)  
KAO( :, 1, 4, 8) = (/&
 & 4.6588E-02_JPRB,3.9692E-01_JPRB,7.1203E-01_JPRB,9.9677E-01_JPRB,1.2538E+00_JPRB,1.4779E+00_JPRB,&
 & 1.6775E+00_JPRB,1.8726E+00_JPRB,7.9787E+00_JPRB/)  
KAO( :, 2, 4, 8) = (/&
 & 4.4258E-02_JPRB,4.1229E-01_JPRB,7.3599E-01_JPRB,1.0269E+00_JPRB,1.2877E+00_JPRB,1.5133E+00_JPRB,&
 & 1.7010E+00_JPRB,1.8766E+00_JPRB,7.5234E+00_JPRB/)  
KAO( :, 3, 4, 8) = (/&
 & 4.2368E-02_JPRB,4.2843E-01_JPRB,7.6079E-01_JPRB,1.0562E+00_JPRB,1.3204E+00_JPRB,1.5488E+00_JPRB,&
 & 1.7282E+00_JPRB,1.8838E+00_JPRB,7.1193E+00_JPRB/)  
KAO( :, 4, 4, 8) = (/&
 & 4.0943E-02_JPRB,4.4462E-01_JPRB,7.8470E-01_JPRB,1.0862E+00_JPRB,1.3538E+00_JPRB,1.5826E+00_JPRB,&
 & 1.7585E+00_JPRB,1.8945E+00_JPRB,6.7587E+00_JPRB/)  
KAO( :, 5, 4, 8) = (/&
 & 4.0040E-02_JPRB,4.6133E-01_JPRB,8.0984E-01_JPRB,1.1157E+00_JPRB,1.3860E+00_JPRB,1.6174E+00_JPRB,&
 & 1.7900E+00_JPRB,1.9072E+00_JPRB,6.4359E+00_JPRB/)  
KAO( :, 1, 5, 8) = (/&
 & 3.9526E-02_JPRB,3.7682E-01_JPRB,6.7689E-01_JPRB,9.4443E-01_JPRB,1.1824E+00_JPRB,1.3941E+00_JPRB,&
 & 1.5967E+00_JPRB,1.7951E+00_JPRB,6.8177E+00_JPRB/)  
KAO( :, 2, 5, 8) = (/&
 & 3.7399E-02_JPRB,3.9138E-01_JPRB,7.0025E-01_JPRB,9.7513E-01_JPRB,1.2184E+00_JPRB,1.4257E+00_JPRB,&
 & 1.6138E+00_JPRB,1.7967E+00_JPRB,6.4101E+00_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART5',1,ZHOOK_HANDLE)
END SUBROUTINE PART5


SUBROUTINE PART6

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART6',0,ZHOOK_HANDLE)


KAO( :, 3, 5, 8) = (/&
 & 3.5621E-02_JPRB,4.0679E-01_JPRB,7.2414E-01_JPRB,1.0055E+00_JPRB,1.2524E+00_JPRB,1.4609E+00_JPRB,&
 & 1.6366E+00_JPRB,1.8029E+00_JPRB,6.0506E+00_JPRB/)  
KAO( :, 4, 5, 8) = (/&
 & 3.4188E-02_JPRB,4.2215E-01_JPRB,7.4791E-01_JPRB,1.0353E+00_JPRB,1.2879E+00_JPRB,1.4982E+00_JPRB,&
 & 1.6647E+00_JPRB,1.8130E+00_JPRB,5.7295E+00_JPRB/)  
KAO( :, 5, 5, 8) = (/&
 & 3.3152E-02_JPRB,4.3822E-01_JPRB,7.7182E-01_JPRB,1.0659E+00_JPRB,1.3217E+00_JPRB,1.5355E+00_JPRB,&
 & 1.6945E+00_JPRB,1.8268E+00_JPRB,5.4423E+00_JPRB/)  
KAO( :, 1, 6, 8) = (/&
 & 3.3649E-02_JPRB,3.5246E-01_JPRB,6.2833E-01_JPRB,8.7232E-01_JPRB,1.0890E+00_JPRB,1.2936E+00_JPRB,&
 & 1.4963E+00_JPRB,1.6916E+00_JPRB,5.8468E+00_JPRB/)  
KAO( :, 2, 6, 8) = (/&
 & 3.1717E-02_JPRB,3.6739E-01_JPRB,6.5289E-01_JPRB,9.0324E-01_JPRB,1.1228E+00_JPRB,1.3194E+00_JPRB,&
 & 1.5082E+00_JPRB,1.6913E+00_JPRB,5.4809E+00_JPRB/)  
KAO( :, 3, 6, 8) = (/&
 & 3.0089E-02_JPRB,3.8258E-01_JPRB,6.7739E-01_JPRB,9.3533E-01_JPRB,1.1590E+00_JPRB,1.3502E+00_JPRB,&
 & 1.5266E+00_JPRB,1.6967E+00_JPRB,5.1581E+00_JPRB/)  
KAO( :, 4, 6, 8) = (/&
 & 2.8750E-02_JPRB,3.9797E-01_JPRB,7.0274E-01_JPRB,9.6682E-01_JPRB,1.1958E+00_JPRB,1.3860E+00_JPRB,&
 & 1.5502E+00_JPRB,1.7067E+00_JPRB,4.8739E+00_JPRB/)  
KAO( :, 5, 6, 8) = (/&
 & 2.7719E-02_JPRB,4.1340E-01_JPRB,7.2752E-01_JPRB,9.9958E-01_JPRB,1.2327E+00_JPRB,1.4235E+00_JPRB,&
 & 1.5795E+00_JPRB,1.7225E+00_JPRB,4.6250E+00_JPRB/)  
KAO( :, 1, 7, 8) = (/&
 & 2.8686E-02_JPRB,3.2127E-01_JPRB,5.6887E-01_JPRB,7.8697E-01_JPRB,9.8824E-01_JPRB,1.1850E+00_JPRB,&
 & 1.3805E+00_JPRB,1.5678E+00_JPRB,5.0771E+00_JPRB/)  
KAO( :, 2, 7, 8) = (/&
 & 2.6938E-02_JPRB,3.3637E-01_JPRB,5.9372E-01_JPRB,8.1756E-01_JPRB,1.0158E+00_JPRB,1.2031E+00_JPRB,&
 & 1.3885E+00_JPRB,1.5659E+00_JPRB,4.7449E+00_JPRB/)  
KAO( :, 3, 7, 8) = (/&
 & 2.5461E-02_JPRB,3.5175E-01_JPRB,6.1823E-01_JPRB,8.4914E-01_JPRB,1.0491E+00_JPRB,1.2297E+00_JPRB,&
 & 1.4035E+00_JPRB,1.5709E+00_JPRB,4.4560E+00_JPRB/)  
KAO( :, 4, 7, 8) = (/&
 & 2.4234E-02_JPRB,3.6782E-01_JPRB,6.4422E-01_JPRB,8.8204E-01_JPRB,1.0858E+00_JPRB,1.2613E+00_JPRB,&
 & 1.4250E+00_JPRB,1.5825E+00_JPRB,4.2060E+00_JPRB/)  
KAO( :, 5, 7, 8) = (/&
 & 2.3263E-02_JPRB,3.8390E-01_JPRB,6.7021E-01_JPRB,9.1556E-01_JPRB,1.1251E+00_JPRB,1.2988E+00_JPRB,&
 & 1.4532E+00_JPRB,1.6007E+00_JPRB,3.9900E+00_JPRB/)  
KAO( :, 1, 8, 8) = (/&
 & 2.4476E-02_JPRB,2.8592E-01_JPRB,5.0420E-01_JPRB,6.9822E-01_JPRB,8.8452E-01_JPRB,1.0702E+00_JPRB,&
 & 1.2531E+00_JPRB,1.4283E+00_JPRB,4.5096E+00_JPRB/)  
KAO( :, 2, 8, 8) = (/&
 & 2.2902E-02_JPRB,3.0083E-01_JPRB,5.2768E-01_JPRB,7.2503E-01_JPRB,9.0657E-01_JPRB,1.0833E+00_JPRB,&
 & 1.2584E+00_JPRB,1.4254E+00_JPRB,4.2037E+00_JPRB/)  
KAO( :, 3, 8, 8) = (/&
 & 2.1570E-02_JPRB,3.1592E-01_JPRB,5.5240E-01_JPRB,7.5563E-01_JPRB,9.3505E-01_JPRB,1.1044E+00_JPRB,&
 & 1.2718E+00_JPRB,1.4312E+00_JPRB,3.9432E+00_JPRB/)  
KAO( :, 4, 8, 8) = (/&
 & 2.0460E-02_JPRB,3.3184E-01_JPRB,5.7760E-01_JPRB,7.8855E-01_JPRB,9.6959E-01_JPRB,1.1343E+00_JPRB,&
 & 1.2935E+00_JPRB,1.4455E+00_JPRB,3.7209E+00_JPRB/)  
KAO( :, 5, 8, 8) = (/&
 & 1.9571E-02_JPRB,3.4825E-01_JPRB,6.0453E-01_JPRB,8.2286E-01_JPRB,1.0085E+00_JPRB,1.1703E+00_JPRB,&
 & 1.3222E+00_JPRB,1.4674E+00_JPRB,3.5292E+00_JPRB/)  
KAO( :, 1, 9, 8) = (/&
 & 2.0914E-02_JPRB,2.4921E-01_JPRB,4.3781E-01_JPRB,6.1146E-01_JPRB,7.8268E-01_JPRB,9.5318E-01_JPRB,&
 & 1.1204E+00_JPRB,1.2813E+00_JPRB,3.9890E+00_JPRB/)  
KAO( :, 2, 9, 8) = (/&
 & 1.9500E-02_JPRB,2.6300E-01_JPRB,4.5963E-01_JPRB,6.3281E-01_JPRB,7.9816E-01_JPRB,9.6251E-01_JPRB,&
 & 1.1241E+00_JPRB,1.2781E+00_JPRB,3.7129E+00_JPRB/)  
KAO( :, 3, 9, 8) = (/&
 & 1.8305E-02_JPRB,2.7783E-01_JPRB,4.8302E-01_JPRB,6.5998E-01_JPRB,8.2260E-01_JPRB,9.8070E-01_JPRB,&
 & 1.1371E+00_JPRB,1.2855E+00_JPRB,3.4817E+00_JPRB/)  
KAO( :, 4, 9, 8) = (/&
 & 1.7310E-02_JPRB,2.9315E-01_JPRB,5.0848E-01_JPRB,6.9210E-01_JPRB,8.5443E-01_JPRB,1.0078E+00_JPRB,&
 & 1.1591E+00_JPRB,1.3024E+00_JPRB,3.2848E+00_JPRB/)  
KAO( :, 5, 9, 8) = (/&
 & 1.6510E-02_JPRB,3.0981E-01_JPRB,5.3550E-01_JPRB,7.2742E-01_JPRB,8.9223E-01_JPRB,1.0429E+00_JPRB,&
 & 1.1888E+00_JPRB,1.3273E+00_JPRB,3.1158E+00_JPRB/)  
KAO( :, 1,10, 8) = (/&
 & 1.7793E-02_JPRB,2.1412E-01_JPRB,3.7675E-01_JPRB,5.3142E-01_JPRB,6.8591E-01_JPRB,8.3908E-01_JPRB,&
 & 9.8911E-01_JPRB,1.1340E+00_JPRB,3.5109E+00_JPRB/)  
KAO( :, 2,10, 8) = (/&
 & 1.6546E-02_JPRB,2.2684E-01_JPRB,3.9518E-01_JPRB,5.4826E-01_JPRB,6.9777E-01_JPRB,8.4666E-01_JPRB,&
 & 9.9261E-01_JPRB,1.1322E+00_JPRB,3.2650E+00_JPRB/)  
KAO( :, 3,10, 8) = (/&
 & 1.5496E-02_JPRB,2.4055E-01_JPRB,4.1757E-01_JPRB,5.7218E-01_JPRB,7.1874E-01_JPRB,8.6407E-01_JPRB,&
 & 1.0067E+00_JPRB,1.1422E+00_JPRB,3.0604E+00_JPRB/)  
KAO( :, 4,10, 8) = (/&
 & 1.4625E-02_JPRB,2.5576E-01_JPRB,4.4224E-01_JPRB,6.0209E-01_JPRB,7.4840E-01_JPRB,8.9005E-01_JPRB,&
 & 1.0298E+00_JPRB,1.1620E+00_JPRB,2.8873E+00_JPRB/)  
KAO( :, 5,10, 8) = (/&
 & 1.3927E-02_JPRB,2.7189E-01_JPRB,4.6913E-01_JPRB,6.3661E-01_JPRB,7.8430E-01_JPRB,9.2340E-01_JPRB,&
 & 1.0602E+00_JPRB,1.1893E+00_JPRB,2.7412E+00_JPRB/)  
KAO( :, 1,11, 8) = (/&
 & 1.4634E-02_JPRB,1.8646E-01_JPRB,3.2761E-01_JPRB,4.6309E-01_JPRB,5.9849E-01_JPRB,7.3245E-01_JPRB,&
 & 8.6367E-01_JPRB,9.9041E-01_JPRB,2.9771E+00_JPRB/)  
KAO( :, 2,11, 8) = (/&
 & 1.3624E-02_JPRB,1.9847E-01_JPRB,3.4526E-01_JPRB,4.8008E-01_JPRB,6.1254E-01_JPRB,7.4424E-01_JPRB,&
 & 8.7321E-01_JPRB,9.9642E-01_JPRB,2.7768E+00_JPRB/)  
KAO( :, 3,11, 8) = (/&
 & 1.2781E-02_JPRB,2.1218E-01_JPRB,3.6739E-01_JPRB,5.0421E-01_JPRB,6.3507E-01_JPRB,7.6517E-01_JPRB,&
 & 8.9263E-01_JPRB,1.0135E+00_JPRB,2.6101E+00_JPRB/)  
KAO( :, 4,11, 8) = (/&
 & 1.2094E-02_JPRB,2.2714E-01_JPRB,3.9240E-01_JPRB,5.3424E-01_JPRB,6.6566E-01_JPRB,7.9378E-01_JPRB,&
 & 9.1970E-01_JPRB,1.0385E+00_JPRB,2.4710E+00_JPRB/)  
KAO( :, 5,11, 8) = (/&
 & 1.1565E-02_JPRB,2.4340E-01_JPRB,4.1903E-01_JPRB,5.6803E-01_JPRB,7.0132E-01_JPRB,8.2803E-01_JPRB,&
 & 9.5252E-01_JPRB,1.0696E+00_JPRB,2.3570E+00_JPRB/)  
KAO( :, 1,12, 8) = (/&
 & 1.2066E-02_JPRB,1.6101E-01_JPRB,2.8340E-01_JPRB,4.0165E-01_JPRB,5.1974E-01_JPRB,6.3658E-01_JPRB,&
 & 7.5093E-01_JPRB,8.6137E-01_JPRB,2.5621E+00_JPRB/)  
KAO( :, 2,12, 8) = (/&
 & 1.1251E-02_JPRB,1.7279E-01_JPRB,3.0073E-01_JPRB,4.1913E-01_JPRB,5.3610E-01_JPRB,6.5212E-01_JPRB,&
 & 7.6558E-01_JPRB,8.7414E-01_JPRB,2.3949E+00_JPRB/)  
KAO( :, 3,12, 8) = (/&
 & 1.0577E-02_JPRB,1.8625E-01_JPRB,3.2218E-01_JPRB,4.4327E-01_JPRB,5.5974E-01_JPRB,6.7543E-01_JPRB,&
 & 7.8860E-01_JPRB,8.9593E-01_JPRB,2.2565E+00_JPRB/)  
KAO( :, 4,12, 8) = (/&
 & 1.0040E-02_JPRB,2.0090E-01_JPRB,3.4668E-01_JPRB,4.7237E-01_JPRB,5.8984E-01_JPRB,7.0511E-01_JPRB,&
 & 8.1812E-01_JPRB,9.2463E-01_JPRB,2.1449E+00_JPRB/)  
KAO( :, 5,12, 8) = (/&
 & 9.6497E-03_JPRB,2.1689E-01_JPRB,3.7279E-01_JPRB,5.0486E-01_JPRB,6.2430E-01_JPRB,7.3876E-01_JPRB,&
 & 8.5101E-01_JPRB,9.5619E-01_JPRB,2.0655E+00_JPRB/)  
KAO( :, 1,13, 8) = (/&
 & 9.9585E-03_JPRB,1.3861E-01_JPRB,2.4453E-01_JPRB,3.4735E-01_JPRB,4.5003E-01_JPRB,5.5145E-01_JPRB,&
 & 6.5075E-01_JPRB,7.4674E-01_JPRB,2.2898E+00_JPRB/)  
KAO( :, 2,13, 8) = (/&
 & 9.2992E-03_JPRB,1.5005E-01_JPRB,2.6138E-01_JPRB,3.6503E-01_JPRB,4.6776E-01_JPRB,5.6948E-01_JPRB,&
 & 6.6893E-01_JPRB,7.6408E-01_JPRB,2.1410E+00_JPRB/)  
KAO( :, 3,13, 8) = (/&
 & 8.7626E-03_JPRB,1.6301E-01_JPRB,2.8187E-01_JPRB,3.8870E-01_JPRB,4.9199E-01_JPRB,5.9459E-01_JPRB,&
 & 6.9480E-01_JPRB,7.8975E-01_JPRB,2.0213E+00_JPRB/)  
KAO( :, 4,13, 8) = (/&
 & 8.3523E-03_JPRB,1.7715E-01_JPRB,3.0539E-01_JPRB,4.1632E-01_JPRB,5.2068E-01_JPRB,6.2370E-01_JPRB,&
 & 7.2425E-01_JPRB,8.1879E-01_JPRB,1.9340E+00_JPRB/)  
KAO( :, 5,13, 8) = (/&
 & 8.0561E-03_JPRB,1.9260E-01_JPRB,3.3012E-01_JPRB,4.4598E-01_JPRB,5.5239E-01_JPRB,6.5539E-01_JPRB,&
 & 7.5612E-01_JPRB,8.5015E-01_JPRB,1.8746E+00_JPRB/)  
KAO( :, 1, 1, 9) = (/&
 & 1.4008E+00_JPRB,1.6014E+00_JPRB,2.0178E+00_JPRB,2.5290E+00_JPRB,3.0648E+00_JPRB,3.4883E+00_JPRB,&
 & 3.8106E+00_JPRB,4.1078E+00_JPRB,1.3510E+01_JPRB/)  
KAO( :, 2, 1, 9) = (/&
 & 1.8642E+00_JPRB,1.9682E+00_JPRB,2.2869E+00_JPRB,2.7055E+00_JPRB,3.2045E+00_JPRB,3.6259E+00_JPRB,&
 & 3.9148E+00_JPRB,4.1490E+00_JPRB,1.3219E+01_JPRB/)  
KAO( :, 3, 1, 9) = (/&
 & 2.4188E+00_JPRB,2.4150E+00_JPRB,2.6255E+00_JPRB,2.9382E+00_JPRB,3.3460E+00_JPRB,3.7645E+00_JPRB,&
 & 4.0194E+00_JPRB,4.1942E+00_JPRB,1.3301E+01_JPRB/)  
KAO( :, 4, 1, 9) = (/&
 & 3.0606E+00_JPRB,2.9381E+00_JPRB,3.0294E+00_JPRB,3.2272E+00_JPRB,3.5230E+00_JPRB,3.8956E+00_JPRB,&
 & 4.1275E+00_JPRB,4.2397E+00_JPRB,1.3766E+01_JPRB/)  
KAO( :, 5, 1, 9) = (/&
 & 3.7794E+00_JPRB,3.5290E+00_JPRB,3.4922E+00_JPRB,3.5653E+00_JPRB,3.7393E+00_JPRB,4.0279E+00_JPRB,&
 & 4.2356E+00_JPRB,4.2849E+00_JPRB,1.4541E+01_JPRB/)  
KAO( :, 1, 2, 9) = (/&
 & 1.0743E+00_JPRB,1.4254E+00_JPRB,1.9959E+00_JPRB,2.6242E+00_JPRB,3.1478E+00_JPRB,3.5640E+00_JPRB,&
 & 3.9315E+00_JPRB,4.2780E+00_JPRB,1.1246E+01_JPRB/)  
KAO( :, 2, 2, 9) = (/&
 & 1.4450E+00_JPRB,1.7077E+00_JPRB,2.1920E+00_JPRB,2.7731E+00_JPRB,3.3077E+00_JPRB,3.7068E+00_JPRB,&
 & 4.0280E+00_JPRB,4.3205E+00_JPRB,1.0854E+01_JPRB/)  
KAO( :, 3, 2, 9) = (/&
 & 1.8935E+00_JPRB,2.0578E+00_JPRB,2.4461E+00_JPRB,2.9377E+00_JPRB,3.4636E+00_JPRB,3.8524E+00_JPRB,&
 & 4.1310E+00_JPRB,4.3656E+00_JPRB,1.0696E+01_JPRB/)  
KAO( :, 4, 2, 9) = (/&
 & 2.4131E+00_JPRB,2.4697E+00_JPRB,2.7529E+00_JPRB,3.1439E+00_JPRB,3.6214E+00_JPRB,3.9997E+00_JPRB,&
 & 4.2395E+00_JPRB,4.4100E+00_JPRB,1.0792E+01_JPRB/)  
KAO( :, 5, 2, 9) = (/&
 & 3.0060E+00_JPRB,2.9455E+00_JPRB,3.1147E+00_JPRB,3.3967E+00_JPRB,3.7810E+00_JPRB,4.1480E+00_JPRB,&
 & 4.3467E+00_JPRB,4.4539E+00_JPRB,1.1120E+01_JPRB/)  
KAO( :, 1, 3, 9) = (/&
 & 7.6472E-01_JPRB,1.2830E+00_JPRB,2.0011E+00_JPRB,2.6221E+00_JPRB,3.1251E+00_JPRB,3.5689E+00_JPRB,&
 & 3.9960E+00_JPRB,4.3904E+00_JPRB,9.5265E+00_JPRB/)  
KAO( :, 2, 3, 9) = (/&
 & 1.0454E+00_JPRB,1.4850E+00_JPRB,2.1444E+00_JPRB,2.7873E+00_JPRB,3.2876E+00_JPRB,3.7049E+00_JPRB,&
 & 4.0848E+00_JPRB,4.4319E+00_JPRB,9.1222E+00_JPRB/)  
KAO( :, 3, 3, 9) = (/&
 & 1.3885E+00_JPRB,1.7405E+00_JPRB,2.3171E+00_JPRB,2.9536E+00_JPRB,3.4575E+00_JPRB,3.8474E+00_JPRB,&
 & 4.1795E+00_JPRB,4.4739E+00_JPRB,8.8598E+00_JPRB/)  
KAO( :, 4, 3, 9) = (/&
 & 1.7962E+00_JPRB,2.0514E+00_JPRB,2.5375E+00_JPRB,3.1222E+00_JPRB,3.6306E+00_JPRB,3.9962E+00_JPRB,&
 & 4.2785E+00_JPRB,4.5165E+00_JPRB,8.7328E+00_JPRB/)  
KAO( :, 5, 3, 9) = (/&
 & 2.2640E+00_JPRB,2.4140E+00_JPRB,2.8016E+00_JPRB,3.3001E+00_JPRB,3.8026E+00_JPRB,4.1450E+00_JPRB,&
 & 4.3795E+00_JPRB,4.5585E+00_JPRB,8.7266E+00_JPRB/)  
KAO( :, 1, 4, 9) = (/&
 & 5.2796E-01_JPRB,1.2120E+00_JPRB,1.9543E+00_JPRB,2.5382E+00_JPRB,3.0533E+00_JPRB,3.5474E+00_JPRB,&
 & 4.0298E+00_JPRB,4.4716E+00_JPRB,8.2598E+00_JPRB/)  
KAO( :, 2, 4, 9) = (/&
 & 7.3237E-01_JPRB,1.3475E+00_JPRB,2.1063E+00_JPRB,2.7052E+00_JPRB,3.2055E+00_JPRB,3.6631E+00_JPRB,&
 & 4.1092E+00_JPRB,4.5092E+00_JPRB,7.9321E+00_JPRB/)  
KAO( :, 3, 4, 9) = (/&
 & 9.9035E-01_JPRB,1.5277E+00_JPRB,2.2632E+00_JPRB,2.8812E+00_JPRB,3.3695E+00_JPRB,3.7914E+00_JPRB,&
 & 4.1936E+00_JPRB,4.5489E+00_JPRB,7.6815E+00_JPRB/)  
KAO( :, 4, 4, 9) = (/&
 & 1.3002E+00_JPRB,1.7521E+00_JPRB,2.4291E+00_JPRB,3.0611E+00_JPRB,3.5379E+00_JPRB,3.9283E+00_JPRB,&
 & 4.2814E+00_JPRB,4.5884E+00_JPRB,7.5173E+00_JPRB/)  
KAO( :, 5, 4, 9) = (/&
 & 1.6645E+00_JPRB,2.0223E+00_JPRB,2.6149E+00_JPRB,3.2452E+00_JPRB,3.7109E+00_JPRB,4.0687E+00_JPRB,&
 & 4.3710E+00_JPRB,4.6264E+00_JPRB,7.4184E+00_JPRB/)  
KAO( :, 1, 5, 9) = (/&
 & 3.6057E-01_JPRB,1.1636E+00_JPRB,1.8513E+00_JPRB,2.4342E+00_JPRB,2.9866E+00_JPRB,3.5323E+00_JPRB,&
 & 4.0567E+00_JPRB,4.5370E+00_JPRB,7.4568E+00_JPRB/)  
KAO( :, 2, 5, 9) = (/&
 & 5.0709E-01_JPRB,1.2813E+00_JPRB,2.0048E+00_JPRB,2.5857E+00_JPRB,3.1141E+00_JPRB,3.6303E+00_JPRB,&
 & 4.1258E+00_JPRB,4.5699E+00_JPRB,7.1852E+00_JPRB/)  
KAO( :, 3, 5, 9) = (/&
 & 6.9711E-01_JPRB,1.4088E+00_JPRB,2.1674E+00_JPRB,2.7491E+00_JPRB,3.2569E+00_JPRB,3.7377E+00_JPRB,&
 & 4.1985E+00_JPRB,4.6043E+00_JPRB,6.9783E+00_JPRB/)  
KAO( :, 4, 5, 9) = (/&
 & 9.3089E-01_JPRB,1.5674E+00_JPRB,2.3376E+00_JPRB,2.9224E+00_JPRB,3.4095E+00_JPRB,3.8525E+00_JPRB,&
 & 4.2748E+00_JPRB,4.6380E+00_JPRB,6.8324E+00_JPRB/)  
KAO( :, 5, 5, 9) = (/&
 & 1.2095E+00_JPRB,1.7631E+00_JPRB,2.5127E+00_JPRB,3.1011E+00_JPRB,3.5697E+00_JPRB,3.9735E+00_JPRB,&
 & 4.3536E+00_JPRB,4.6710E+00_JPRB,6.7237E+00_JPRB/)  
KAO( :, 1, 6, 9) = (/&
 & 2.4200E-01_JPRB,1.0838E+00_JPRB,1.7394E+00_JPRB,2.3387E+00_JPRB,2.9299E+00_JPRB,3.5073E+00_JPRB,&
 & 4.0603E+00_JPRB,4.5751E+00_JPRB,6.9990E+00_JPRB/)  
KAO( :, 2, 6, 9) = (/&
 & 3.4394E-01_JPRB,1.1999E+00_JPRB,1.8760E+00_JPRB,2.4663E+00_JPRB,3.0343E+00_JPRB,3.5897E+00_JPRB,&
 & 4.1192E+00_JPRB,4.6007E+00_JPRB,6.7915E+00_JPRB/)  
KAO( :, 3, 6, 9) = (/&
 & 4.8030E-01_JPRB,1.3232E+00_JPRB,2.0255E+00_JPRB,2.6081E+00_JPRB,3.1512E+00_JPRB,3.6810E+00_JPRB,&
 & 4.1825E+00_JPRB,4.6279E+00_JPRB,6.6211E+00_JPRB/)  
KAO( :, 4, 6, 9) = (/&
 & 6.5272E-01_JPRB,1.4558E+00_JPRB,2.1847E+00_JPRB,2.7631E+00_JPRB,3.2807E+00_JPRB,3.7792E+00_JPRB,&
 & 4.2485E+00_JPRB,4.6560E+00_JPRB,6.4814E+00_JPRB/)  
KAO( :, 5, 6, 9) = (/&
 & 8.6213E-01_JPRB,1.5990E+00_JPRB,2.3528E+00_JPRB,2.9249E+00_JPRB,3.4200E+00_JPRB,3.8827E+00_JPRB,&
 & 4.3177E+00_JPRB,4.6844E+00_JPRB,6.3643E+00_JPRB/)  
KAO( :, 1, 7, 9) = (/&
 & 1.6234E-01_JPRB,9.9163E-01_JPRB,1.6372E+00_JPRB,2.2588E+00_JPRB,2.8704E+00_JPRB,3.4657E+00_JPRB,&
 & 4.0381E+00_JPRB,4.5791E+00_JPRB,6.7312E+00_JPRB/)  
KAO( :, 2, 7, 9) = (/&
 & 2.3147E-01_JPRB,1.0981E+00_JPRB,1.7520E+00_JPRB,2.3595E+00_JPRB,2.9563E+00_JPRB,3.5352E+00_JPRB,&
 & 4.0869E+00_JPRB,4.5966E+00_JPRB,6.5680E+00_JPRB/)  
KAO( :, 3, 7, 9) = (/&
 & 3.2772E-01_JPRB,1.2156E+00_JPRB,1.8829E+00_JPRB,2.4770E+00_JPRB,3.0534E+00_JPRB,3.6116E+00_JPRB,&
 & 4.1400E+00_JPRB,4.6166E+00_JPRB,6.4257E+00_JPRB/)  
KAO( :, 4, 7, 9) = (/&
 & 4.5268E-01_JPRB,1.3423E+00_JPRB,2.0240E+00_JPRB,2.6084E+00_JPRB,3.1603E+00_JPRB,3.6950E+00_JPRB,&
 & 4.1975E+00_JPRB,4.6391E+00_JPRB,6.2960E+00_JPRB/)  
KAO( :, 5, 7, 9) = (/&
 & 6.0838E-01_JPRB,1.4784E+00_JPRB,2.1759E+00_JPRB,2.7497E+00_JPRB,3.2763E+00_JPRB,3.7840E+00_JPRB,&
 & 4.2569E+00_JPRB,4.6620E+00_JPRB,6.1756E+00_JPRB/)  
KAO( :, 1, 8, 9) = (/&
 & 1.1004E-01_JPRB,9.0528E-01_JPRB,1.5488E+00_JPRB,2.1828E+00_JPRB,2.8043E+00_JPRB,3.4087E+00_JPRB,&
 & 3.9936E+00_JPRB,4.5522E+00_JPRB,6.5679E+00_JPRB/)  
KAO( :, 2, 8, 9) = (/&
 & 1.5599E-01_JPRB,9.9632E-01_JPRB,1.6406E+00_JPRB,2.2628E+00_JPRB,2.8729E+00_JPRB,3.4645E+00_JPRB,&
 & 4.0312E+00_JPRB,4.5616E+00_JPRB,6.4237E+00_JPRB/)  
KAO( :, 3, 8, 9) = (/&
 & 2.2275E-01_JPRB,1.1002E+00_JPRB,1.7485E+00_JPRB,2.3565E+00_JPRB,2.9517E+00_JPRB,3.5270E+00_JPRB,&
 & 4.0737E+00_JPRB,4.5749E+00_JPRB,6.2919E+00_JPRB/)  
KAO( :, 4, 8, 9) = (/&
 & 3.1235E-01_JPRB,1.2144E+00_JPRB,1.8706E+00_JPRB,2.4635E+00_JPRB,3.0405E+00_JPRB,3.5959E+00_JPRB,&
 & 4.1201E+00_JPRB,4.5903E+00_JPRB,6.1693E+00_JPRB/)  
KAO( :, 5, 8, 9) = (/&
 & 4.2664E-01_JPRB,1.3386E+00_JPRB,2.0030E+00_JPRB,2.5834E+00_JPRB,3.1377E+00_JPRB,3.6706E+00_JPRB,&
 & 4.1692E+00_JPRB,4.6062E+00_JPRB,6.0528E+00_JPRB/)  
KAO( :, 1, 9, 9) = (/&
 & 7.5621E-02_JPRB,8.2912E-01_JPRB,1.4726E+00_JPRB,2.1058E+00_JPRB,2.7258E+00_JPRB,3.3321E+00_JPRB,&
 & 3.9225E+00_JPRB,4.4919E+00_JPRB,6.3820E+00_JPRB/)  
KAO( :, 2, 9, 9) = (/&
 & 1.0543E-01_JPRB,9.0364E-01_JPRB,1.5428E+00_JPRB,2.1689E+00_JPRB,2.7807E+00_JPRB,3.3755E+00_JPRB,&
 & 3.9494E+00_JPRB,4.4934E+00_JPRB,6.2476E+00_JPRB/)  
KAO( :, 3, 9, 9) = (/&
 & 1.5066E-01_JPRB,9.9073E-01_JPRB,1.6283E+00_JPRB,2.2439E+00_JPRB,2.8447E+00_JPRB,3.4264E+00_JPRB,&
 & 3.9821E+00_JPRB,4.4994E+00_JPRB,6.1231E+00_JPRB/)  
KAO( :, 4, 9, 9) = (/&
 & 2.1408E-01_JPRB,1.0896E+00_JPRB,1.7277E+00_JPRB,2.3302E+00_JPRB,2.9173E+00_JPRB,3.4831E+00_JPRB,&
 & 4.0188E+00_JPRB,4.5079E+00_JPRB,6.0062E+00_JPRB/)  
KAO( :, 5, 9, 9) = (/&
 & 2.9679E-01_JPRB,1.1980E+00_JPRB,1.8391E+00_JPRB,2.4267E+00_JPRB,2.9974E+00_JPRB,3.5447E+00_JPRB,&
 & 4.0590E+00_JPRB,4.5182E+00_JPRB,5.8937E+00_JPRB/)  
KAO( :, 1,10, 9) = (/&
 & 5.4240E-02_JPRB,7.6886E-01_JPRB,1.4043E+00_JPRB,2.0272E+00_JPRB,2.6366E+00_JPRB,3.2336E+00_JPRB,&
 & 3.8172E+00_JPRB,4.3834E+00_JPRB,6.1517E+00_JPRB/)  
KAO( :, 2,10, 9) = (/&
 & 7.3880E-02_JPRB,8.2766E-01_JPRB,1.4592E+00_JPRB,2.0774E+00_JPRB,2.6804E+00_JPRB,3.2668E+00_JPRB,&
 & 3.8346E+00_JPRB,4.3761E+00_JPRB,6.0252E+00_JPRB/)  
KAO( :, 3,10, 9) = (/&
 & 1.0494E-01_JPRB,8.9945E-01_JPRB,1.5264E+00_JPRB,2.1379E+00_JPRB,2.7325E+00_JPRB,3.3074E+00_JPRB,&
 & 3.8583E+00_JPRB,4.3744E+00_JPRB,5.9074E+00_JPRB/)  
KAO( :, 4,10, 9) = (/&
 & 1.5013E-01_JPRB,9.8203E-01_JPRB,1.6069E+00_JPRB,2.2084E+00_JPRB,2.7922E+00_JPRB,3.3540E+00_JPRB,&
 & 3.8866E+00_JPRB,4.3763E+00_JPRB,5.7958E+00_JPRB/)  
KAO( :, 5,10, 9) = (/&
 & 2.1071E-01_JPRB,1.0751E+00_JPRB,1.6988E+00_JPRB,2.2877E+00_JPRB,2.8591E+00_JPRB,3.4064E+00_JPRB,&
 & 3.9198E+00_JPRB,4.3819E+00_JPRB,5.6875E+00_JPRB/)  
KAO( :, 1,11, 9) = (/&
 & 4.4683E-02_JPRB,7.3372E-01_JPRB,1.3451E+00_JPRB,1.9417E+00_JPRB,2.5248E+00_JPRB,3.0962E+00_JPRB,&
 & 3.6538E+00_JPRB,4.1928E+00_JPRB,5.8131E+00_JPRB/)  
KAO( :, 2,11, 9) = (/&
 & 6.0954E-02_JPRB,7.8585E-01_JPRB,1.3950E+00_JPRB,1.9873E+00_JPRB,2.5636E+00_JPRB,3.1235E+00_JPRB,&
 & 3.6649E+00_JPRB,4.1802E+00_JPRB,5.6980E+00_JPRB/)  
KAO( :, 3,11, 9) = (/&
 & 8.6688E-02_JPRB,8.4834E-01_JPRB,1.4554E+00_JPRB,2.0422E+00_JPRB,2.6105E+00_JPRB,3.1582E+00_JPRB,&
 & 3.6827E+00_JPRB,4.1732E+00_JPRB,5.5896E+00_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART6',1,ZHOOK_HANDLE)
END SUBROUTINE PART6


SUBROUTINE PART7

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART7',0,ZHOOK_HANDLE)


KAO( :, 4,11, 9) = (/&
 & 1.2398E-01_JPRB,9.2090E-01_JPRB,1.5262E+00_JPRB,2.1063E+00_JPRB,2.6652E+00_JPRB,3.2007E+00_JPRB,&
 & 3.7079E+00_JPRB,4.1732E+00_JPRB,5.4857E+00_JPRB/)  
KAO( :, 5,11, 9) = (/&
 & 1.7398E-01_JPRB,1.0025E+00_JPRB,1.6073E+00_JPRB,2.1784E+00_JPRB,2.7274E+00_JPRB,3.2503E+00_JPRB,&
 & 3.7400E+00_JPRB,4.1797E+00_JPRB,5.3881E+00_JPRB/)  
KAO( :, 1,12, 9) = (/&
 & 3.6885E-02_JPRB,6.8826E-01_JPRB,1.2637E+00_JPRB,1.8240E+00_JPRB,2.3716E+00_JPRB,2.9070E+00_JPRB,&
 & 3.4294E+00_JPRB,3.9342E+00_JPRB,5.4594E+00_JPRB/)  
KAO( :, 2,12, 9) = (/&
 & 5.0362E-02_JPRB,7.3520E-01_JPRB,1.3086E+00_JPRB,1.8646E+00_JPRB,2.4044E+00_JPRB,2.9285E+00_JPRB,&
 & 3.4352E+00_JPRB,3.9171E+00_JPRB,5.3534E+00_JPRB/)  
KAO( :, 3,12, 9) = (/&
 & 7.1651E-02_JPRB,7.9173E-01_JPRB,1.3635E+00_JPRB,1.9144E+00_JPRB,2.4467E+00_JPRB,2.9595E+00_JPRB,&
 & 3.4502E+00_JPRB,3.9090E+00_JPRB,5.2531E+00_JPRB/)  
KAO( :, 4,12, 9) = (/&
 & 1.0249E-01_JPRB,8.5728E-01_JPRB,1.4282E+00_JPRB,1.9738E+00_JPRB,2.4980E+00_JPRB,2.9998E+00_JPRB,&
 & 3.4748E+00_JPRB,3.9108E+00_JPRB,5.1595E+00_JPRB/)  
KAO( :, 5,12, 9) = (/&
 & 1.4372E-01_JPRB,9.2980E-01_JPRB,1.5022E+00_JPRB,2.0418E+00_JPRB,2.5591E+00_JPRB,3.0515E+00_JPRB,&
 & 3.5127E+00_JPRB,3.9276E+00_JPRB,5.0750E+00_JPRB/)  
KAO( :, 1,13, 9) = (/&
 & 3.0491E-02_JPRB,6.3441E-01_JPRB,1.1660E+00_JPRB,1.6828E+00_JPRB,2.1872E+00_JPRB,2.6805E+00_JPRB,&
 & 3.1616E+00_JPRB,3.6254E+00_JPRB,5.1279E+00_JPRB/)  
KAO( :, 2,13, 9) = (/&
 & 4.1640E-02_JPRB,6.7602E-01_JPRB,1.2060E+00_JPRB,1.7186E+00_JPRB,2.2159E+00_JPRB,2.6988E+00_JPRB,&
 & 3.1653E+00_JPRB,3.6082E+00_JPRB,5.0296E+00_JPRB/)  
KAO( :, 3,13, 9) = (/&
 & 5.9248E-02_JPRB,7.2677E-01_JPRB,1.2558E+00_JPRB,1.7643E+00_JPRB,2.2553E+00_JPRB,2.7282E+00_JPRB,&
 & 3.1808E+00_JPRB,3.6035E+00_JPRB,4.9390E+00_JPRB/)  
KAO( :, 4,13, 9) = (/&
 & 8.4663E-02_JPRB,7.8595E-01_JPRB,1.3152E+00_JPRB,1.8213E+00_JPRB,2.3074E+00_JPRB,2.7724E+00_JPRB,&
 & 3.2128E+00_JPRB,3.6169E+00_JPRB,4.8589E+00_JPRB/)  
KAO( :, 5,13, 9) = (/&
 & 1.1865E-01_JPRB,8.5205E-01_JPRB,1.3845E+00_JPRB,1.8890E+00_JPRB,2.3711E+00_JPRB,2.8293E+00_JPRB,&
 & 3.2586E+00_JPRB,3.6454E+00_JPRB,4.7958E+00_JPRB/)  
KAO( :, 1, 1,10) = (/&
 & 8.3046E+00_JPRB,7.2666E+00_JPRB,6.2285E+00_JPRB,5.1904E+00_JPRB,4.7329E+00_JPRB,5.2261E+00_JPRB,&
 & 5.7808E+00_JPRB,6.3145E+00_JPRB,1.5403E+01_JPRB/)  
KAO( :, 2, 1,10) = (/&
 & 1.0500E+01_JPRB,9.1879E+00_JPRB,7.8753E+00_JPRB,6.5628E+00_JPRB,5.3429E+00_JPRB,5.4501E+00_JPRB,&
 & 5.9313E+00_JPRB,6.4007E+00_JPRB,1.7452E+01_JPRB/)  
KAO( :, 3, 1,10) = (/&
 & 1.2866E+01_JPRB,1.1258E+01_JPRB,9.6496E+00_JPRB,8.0413E+00_JPRB,6.4330E+00_JPRB,5.7014E+00_JPRB,&
 & 6.0980E+00_JPRB,6.4718E+00_JPRB,1.9513E+01_JPRB/)  
KAO( :, 4, 1,10) = (/&
 & 1.5392E+01_JPRB,1.3468E+01_JPRB,1.1544E+01_JPRB,9.6199E+00_JPRB,7.6959E+00_JPRB,6.1009E+00_JPRB,&
 & 6.2722E+00_JPRB,6.5575E+00_JPRB,2.1715E+01_JPRB/)  
KAO( :, 5, 1,10) = (/&
 & 1.8056E+01_JPRB,1.5799E+01_JPRB,1.3542E+01_JPRB,1.1285E+01_JPRB,9.0279E+00_JPRB,6.8103E+00_JPRB,&
 & 6.4441E+00_JPRB,6.6397E+00_JPRB,2.3850E+01_JPRB/)  
KAO( :, 1, 2,10) = (/&
 & 6.4947E+00_JPRB,5.6829E+00_JPRB,4.8711E+00_JPRB,4.3890E+00_JPRB,5.0074E+00_JPRB,5.7366E+00_JPRB,&
 & 6.4315E+00_JPRB,7.0725E+00_JPRB,1.2054E+01_JPRB/)  
KAO( :, 2, 2,10) = (/&
 & 8.3011E+00_JPRB,7.2634E+00_JPRB,6.2258E+00_JPRB,5.2050E+00_JPRB,5.2909E+00_JPRB,5.9522E+00_JPRB,&
 & 6.5881E+00_JPRB,7.1588E+00_JPRB,1.2666E+01_JPRB/)  
KAO( :, 3, 2,10) = (/&
 & 1.0256E+01_JPRB,8.9740E+00_JPRB,7.6920E+00_JPRB,6.4100E+00_JPRB,5.6644E+00_JPRB,6.1894E+00_JPRB,&
 & 6.7625E+00_JPRB,7.2404E+00_JPRB,1.3682E+01_JPRB/)  
KAO( :, 4, 2,10) = (/&
 & 1.2397E+01_JPRB,1.0847E+01_JPRB,9.2971E+00_JPRB,7.7479E+00_JPRB,6.3118E+00_JPRB,6.4388E+00_JPRB,&
 & 6.9414E+00_JPRB,7.3378E+00_JPRB,1.5028E+01_JPRB/)  
KAO( :, 5, 2,10) = (/&
 & 1.4660E+01_JPRB,1.2828E+01_JPRB,1.0995E+01_JPRB,9.1626E+00_JPRB,7.3301E+00_JPRB,6.6905E+00_JPRB,&
 & 7.1124E+00_JPRB,7.4264E+00_JPRB,1.6436E+01_JPRB/)  
KAO( :, 1, 3,10) = (/&
 & 4.7461E+00_JPRB,4.1529E+00_JPRB,3.7000E+00_JPRB,4.4615E+00_JPRB,5.3639E+00_JPRB,6.2356E+00_JPRB,&
 & 7.0823E+00_JPRB,7.8222E+00_JPRB,1.0768E+01_JPRB/)  
KAO( :, 2, 3,10) = (/&
 & 6.1674E+00_JPRB,5.3965E+00_JPRB,4.6255E+00_JPRB,4.7868E+00_JPRB,5.6404E+00_JPRB,6.4644E+00_JPRB,&
 & 7.2578E+00_JPRB,7.9155E+00_JPRB,1.1012E+01_JPRB/)  
KAO( :, 3, 3,10) = (/&
 & 7.7651E+00_JPRB,6.7945E+00_JPRB,5.8238E+00_JPRB,5.2211E+00_JPRB,5.9299E+00_JPRB,6.7104E+00_JPRB,&
 & 7.4369E+00_JPRB,8.0208E+00_JPRB,1.1349E+01_JPRB/)  
KAO( :, 4, 3,10) = (/&
 & 9.5128E+00_JPRB,8.3237E+00_JPRB,7.1346E+00_JPRB,5.9977E+00_JPRB,6.2294E+00_JPRB,6.9597E+00_JPRB,&
 & 7.6063E+00_JPRB,8.1225E+00_JPRB,1.1679E+01_JPRB/)  
KAO( :, 5, 3,10) = (/&
 & 1.1390E+01_JPRB,9.9664E+00_JPRB,8.5426E+00_JPRB,7.1189E+00_JPRB,6.5507E+00_JPRB,7.2016E+00_JPRB,&
 & 7.7732E+00_JPRB,8.2118E+00_JPRB,1.2040E+01_JPRB/)  
KAO( :, 1, 4,10) = (/&
 & 3.3503E+00_JPRB,2.9315E+00_JPRB,3.5683E+00_JPRB,4.6667E+00_JPRB,5.7273E+00_JPRB,6.7580E+00_JPRB,&
 & 7.7198E+00_JPRB,8.5710E+00_JPRB,1.0440E+01_JPRB/)  
KAO( :, 2, 4,10) = (/&
 & 4.4561E+00_JPRB,3.8991E+00_JPRB,3.9300E+00_JPRB,4.9622E+00_JPRB,5.9939E+00_JPRB,6.9871E+00_JPRB,&
 & 7.8925E+00_JPRB,8.6774E+00_JPRB,1.0521E+01_JPRB/)  
KAO( :, 3, 4,10) = (/&
 & 5.7189E+00_JPRB,5.0041E+00_JPRB,4.4573E+00_JPRB,5.2834E+00_JPRB,6.2798E+00_JPRB,7.2167E+00_JPRB,&
 & 8.0686E+00_JPRB,8.7808E+00_JPRB,1.0645E+01_JPRB/)  
KAO( :, 4, 4,10) = (/&
 & 7.1243E+00_JPRB,6.2338E+00_JPRB,5.3456E+00_JPRB,5.6334E+00_JPRB,6.5793E+00_JPRB,7.4542E+00_JPRB,&
 & 8.2512E+00_JPRB,8.8783E+00_JPRB,1.0735E+01_JPRB/)  
KAO( :, 5, 4,10) = (/&
 & 8.6595E+00_JPRB,7.5770E+00_JPRB,6.4946E+00_JPRB,6.0192E+00_JPRB,6.8955E+00_JPRB,7.7038E+00_JPRB,&
 & 8.4443E+00_JPRB,8.9879E+00_JPRB,1.0819E+01_JPRB/)  
KAO( :, 1, 5,10) = (/&
 & 2.3228E+00_JPRB,2.3763E+00_JPRB,3.6372E+00_JPRB,4.8666E+00_JPRB,6.0758E+00_JPRB,7.2202E+00_JPRB,&
 & 8.2887E+00_JPRB,9.2790E+00_JPRB,1.1044E+01_JPRB/)  
KAO( :, 2, 5,10) = (/&
 & 3.1750E+00_JPRB,2.8335E+00_JPRB,3.9429E+00_JPRB,5.1625E+00_JPRB,6.3325E+00_JPRB,7.4495E+00_JPRB,&
 & 8.4649E+00_JPRB,9.3795E+00_JPRB,1.0992E+01_JPRB/)  
KAO( :, 3, 5,10) = (/&
 & 4.1502E+00_JPRB,3.6314E+00_JPRB,4.2777E+00_JPRB,5.4822E+00_JPRB,6.6129E+00_JPRB,7.6864E+00_JPRB,&
 & 8.6584E+00_JPRB,9.4768E+00_JPRB,1.0934E+01_JPRB/)  
KAO( :, 4, 5,10) = (/&
 & 5.2710E+00_JPRB,4.6121E+00_JPRB,4.6433E+00_JPRB,5.8225E+00_JPRB,6.9099E+00_JPRB,7.9434E+00_JPRB,&
 & 8.8623E+00_JPRB,9.5919E+00_JPRB,1.0860E+01_JPRB/)  
KAO( :, 5, 5,10) = (/&
 & 6.4981E+00_JPRB,5.6859E+00_JPRB,5.1116E+00_JPRB,6.1710E+00_JPRB,7.2254E+00_JPRB,8.2046E+00_JPRB,&
 & 9.0650E+00_JPRB,9.7138E+00_JPRB,1.0789E+01_JPRB/)  
KAO( :, 1, 6,10) = (/&
 & 1.5637E+00_JPRB,2.2731E+00_JPRB,3.6873E+00_JPRB,5.0614E+00_JPRB,6.3700E+00_JPRB,7.6047E+00_JPRB,&
 & 8.7790E+00_JPRB,9.8692E+00_JPRB,1.1665E+01_JPRB/)  
KAO( :, 2, 6,10) = (/&
 & 2.2000E+00_JPRB,2.5584E+00_JPRB,3.9755E+00_JPRB,5.3314E+00_JPRB,6.6268E+00_JPRB,7.8407E+00_JPRB,&
 & 8.9633E+00_JPRB,9.9641E+00_JPRB,1.1590E+01_JPRB/)  
KAO( :, 3, 6,10) = (/&
 & 2.9496E+00_JPRB,2.8996E+00_JPRB,4.2934E+00_JPRB,5.6265E+00_JPRB,6.9043E+00_JPRB,8.0863E+00_JPRB,&
 & 9.1639E+00_JPRB,1.0078E+01_JPRB,1.1504E+01_JPRB/)  
KAO( :, 4, 6,10) = (/&
 & 3.8153E+00_JPRB,3.4040E+00_JPRB,4.6361E+00_JPRB,5.9468E+00_JPRB,7.1994E+00_JPRB,8.3443E+00_JPRB,&
 & 9.3743E+00_JPRB,1.0202E+01_JPRB,1.1405E+01_JPRB/)  
KAO( :, 5, 6,10) = (/&
 & 4.7923E+00_JPRB,4.1932E+00_JPRB,5.0029E+00_JPRB,6.2942E+00_JPRB,7.4973E+00_JPRB,8.6152E+00_JPRB,&
 & 9.5722E+00_JPRB,1.0324E+01_JPRB,1.1282E+01_JPRB/)  
KAO( :, 1, 7,10) = (/&
 & 1.0319E+00_JPRB,2.2030E+00_JPRB,3.7189E+00_JPRB,5.1722E+00_JPRB,6.5639E+00_JPRB,7.8914E+00_JPRB,&
 & 9.1498E+00_JPRB,1.0323E+01_JPRB,1.2175E+01_JPRB/)  
KAO( :, 2, 7,10) = (/&
 & 1.5011E+00_JPRB,2.4558E+00_JPRB,3.9785E+00_JPRB,5.4357E+00_JPRB,6.8145E+00_JPRB,8.1167E+00_JPRB,&
 & 9.3258E+00_JPRB,1.0416E+01_JPRB,1.2083E+01_JPRB/)  
KAO( :, 3, 7,10) = (/&
 & 2.0652E+00_JPRB,2.7433E+00_JPRB,4.2735E+00_JPRB,5.7267E+00_JPRB,7.0874E+00_JPRB,8.3608E+00_JPRB,&
 & 9.5223E+00_JPRB,1.0531E+01_JPRB,1.1978E+01_JPRB/)  
KAO( :, 4, 7,10) = (/&
 & 2.7290E+00_JPRB,3.0650E+00_JPRB,4.6079E+00_JPRB,6.0349E+00_JPRB,7.3838E+00_JPRB,8.6181E+00_JPRB,&
 & 9.7231E+00_JPRB,1.0649E+01_JPRB,1.1858E+01_JPRB/)  
KAO( :, 5, 7,10) = (/&
 & 3.4888E+00_JPRB,3.4187E+00_JPRB,4.9649E+00_JPRB,6.3686E+00_JPRB,7.6906E+00_JPRB,8.8849E+00_JPRB,&
 & 9.9240E+00_JPRB,1.0751E+01_JPRB,1.1715E+01_JPRB/)  
KAO( :, 1, 8,10) = (/&
 & 6.7247E-01_JPRB,2.1299E+00_JPRB,3.7166E+00_JPRB,5.2113E+00_JPRB,6.6383E+00_JPRB,8.0164E+00_JPRB,&
 & 9.3365E+00_JPRB,1.0603E+01_JPRB,1.2480E+01_JPRB/)  
KAO( :, 2, 8,10) = (/&
 & 1.0116E+00_JPRB,2.3605E+00_JPRB,3.9609E+00_JPRB,5.4626E+00_JPRB,6.8806E+00_JPRB,8.2311E+00_JPRB,&
 & 9.5015E+00_JPRB,1.0678E+01_JPRB,1.2368E+01_JPRB/)  
KAO( :, 3, 8,10) = (/&
 & 1.4308E+00_JPRB,2.6245E+00_JPRB,4.2324E+00_JPRB,5.7459E+00_JPRB,7.1525E+00_JPRB,8.4713E+00_JPRB,&
 & 9.6847E+00_JPRB,1.0770E+01_JPRB,1.2245E+01_JPRB/)  
KAO( :, 4, 8,10) = (/&
 & 1.9350E+00_JPRB,2.9206E+00_JPRB,4.5353E+00_JPRB,6.0493E+00_JPRB,7.4438E+00_JPRB,8.7255E+00_JPRB,&
 & 9.8811E+00_JPRB,1.0861E+01_JPRB,1.2099E+01_JPRB/)  
KAO( :, 5, 8,10) = (/&
 & 2.5213E+00_JPRB,3.2436E+00_JPRB,4.8666E+00_JPRB,6.3763E+00_JPRB,7.7488E+00_JPRB,8.9884E+00_JPRB,&
 & 1.0076E+01_JPRB,1.0954E+01_JPRB,1.1942E+01_JPRB/)  
KAO( :, 1, 9,10) = (/&
 & 4.3208E-01_JPRB,2.0475E+00_JPRB,3.6377E+00_JPRB,5.1514E+00_JPRB,6.6073E+00_JPRB,8.0088E+00_JPRB,&
 & 9.3664E+00_JPRB,1.0689E+01_JPRB,1.2722E+01_JPRB/)  
KAO( :, 2, 9,10) = (/&
 & 6.7092E-01_JPRB,2.2446E+00_JPRB,3.8634E+00_JPRB,5.3834E+00_JPRB,6.8242E+00_JPRB,8.1962E+00_JPRB,&
 & 9.5019E+00_JPRB,1.0731E+01_JPRB,1.2602E+01_JPRB/)  
KAO( :, 3, 9,10) = (/&
 & 9.7959E-01_JPRB,2.4790E+00_JPRB,4.1220E+00_JPRB,5.6464E+00_JPRB,7.0720E+00_JPRB,8.4107E+00_JPRB,&
 & 9.6598E+00_JPRB,1.0791E+01_JPRB,1.2470E+01_JPRB/)  
KAO( :, 4, 9,10) = (/&
 & 1.3555E+00_JPRB,2.7516E+00_JPRB,4.4105E+00_JPRB,5.9355E+00_JPRB,7.3438E+00_JPRB,8.6425E+00_JPRB,&
 & 9.8283E+00_JPRB,1.0860E+01_JPRB,1.2324E+01_JPRB/)  
KAO( :, 5, 9,10) = (/&
 & 1.8036E+00_JPRB,3.0512E+00_JPRB,4.7212E+00_JPRB,6.2493E+00_JPRB,7.6308E+00_JPRB,8.8891E+00_JPRB,&
 & 1.0011E+01_JPRB,1.0943E+01_JPRB,1.2174E+01_JPRB/)  
KAO( :, 1,10,10) = (/&
 & 2.8562E-01_JPRB,1.9513E+00_JPRB,3.5205E+00_JPRB,5.0276E+00_JPRB,6.5019E+00_JPRB,7.9388E+00_JPRB,&
 & 9.3417E+00_JPRB,1.0714E+01_JPRB,1.3024E+01_JPRB/)  
KAO( :, 2,10,10) = (/&
 & 4.5369E-01_JPRB,2.1274E+00_JPRB,3.7193E+00_JPRB,5.2300E+00_JPRB,6.6874E+00_JPRB,8.0937E+00_JPRB,&
 & 9.4530E+00_JPRB,1.0753E+01_JPRB,1.2922E+01_JPRB/)  
KAO( :, 3,10,10) = (/&
 & 6.8195E-01_JPRB,2.3352E+00_JPRB,3.9538E+00_JPRB,5.4609E+00_JPRB,6.8984E+00_JPRB,8.2697E+00_JPRB,&
 & 9.5779E+00_JPRB,1.0802E+01_JPRB,1.2803E+01_JPRB/)  
KAO( :, 4,10,10) = (/&
 & 9.6434E-01_JPRB,2.5767E+00_JPRB,4.2212E+00_JPRB,5.7204E+00_JPRB,7.1311E+00_JPRB,8.4647E+00_JPRB,&
 & 9.7207E+00_JPRB,1.0863E+01_JPRB,1.2673E+01_JPRB/)  
KAO( :, 5,10,10) = (/&
 & 1.3075E+00_JPRB,2.8520E+00_JPRB,4.5133E+00_JPRB,6.0099E+00_JPRB,7.3901E+00_JPRB,8.6775E+00_JPRB,&
 & 9.8779E+00_JPRB,1.0938E+01_JPRB,1.2543E+01_JPRB/)  
KAO( :, 1,11,10) = (/&
 & 2.3625E-01_JPRB,1.9181E+00_JPRB,3.5155E+00_JPRB,5.0744E+00_JPRB,6.6008E+00_JPRB,8.0955E+00_JPRB,&
 & 9.5644E+00_JPRB,1.1013E+01_JPRB,1.3397E+01_JPRB/)  
KAO( :, 2,11,10) = (/&
 & 3.7530E-01_JPRB,2.0748E+00_JPRB,3.6829E+00_JPRB,5.2358E+00_JPRB,6.7464E+00_JPRB,8.2221E+00_JPRB,&
 & 9.6585E+00_JPRB,1.1047E+01_JPRB,1.3278E+01_JPRB/)  
KAO( :, 3,11,10) = (/&
 & 5.6319E-01_JPRB,2.2660E+00_JPRB,3.8799E+00_JPRB,5.4224E+00_JPRB,6.9139E+00_JPRB,8.3641E+00_JPRB,&
 & 9.7629E+00_JPRB,1.1090E+01_JPRB,1.3144E+01_JPRB/)  
KAO( :, 4,11,10) = (/&
 & 7.9630E-01_JPRB,2.4928E+00_JPRB,4.1097E+00_JPRB,5.6369E+00_JPRB,7.1043E+00_JPRB,8.5217E+00_JPRB,&
 & 9.8785E+00_JPRB,1.1143E+01_JPRB,1.3008E+01_JPRB/)  
KAO( :, 5,11,10) = (/&
 & 1.0789E+00_JPRB,2.7503E+00_JPRB,4.3718E+00_JPRB,5.8827E+00_JPRB,7.3180E+00_JPRB,8.6936E+00_JPRB,&
 & 9.9992E+00_JPRB,1.1196E+01_JPRB,1.2862E+01_JPRB/)  
KAO( :, 1,12,10) = (/&
 & 1.9532E-01_JPRB,1.9250E+00_JPRB,3.5848E+00_JPRB,5.1929E+00_JPRB,6.7611E+00_JPRB,8.3016E+00_JPRB,&
 & 9.8096E+00_JPRB,1.1276E+01_JPRB,1.3592E+01_JPRB/)  
KAO( :, 2,12,10) = (/&
 & 3.1059E-01_JPRB,2.0481E+00_JPRB,3.7225E+00_JPRB,5.3350E+00_JPRB,6.8984E+00_JPRB,8.4223E+00_JPRB,&
 & 9.8976E+00_JPRB,1.1304E+01_JPRB,1.3454E+01_JPRB/)  
KAO( :, 3,12,10) = (/&
 & 4.6509E-01_JPRB,2.2010E+00_JPRB,3.8811E+00_JPRB,5.4933E+00_JPRB,7.0507E+00_JPRB,8.5551E+00_JPRB,&
 & 9.9951E+00_JPRB,1.1342E+01_JPRB,1.3311E+01_JPRB/)  
KAO( :, 4,12,10) = (/&
 & 6.5689E-01_JPRB,2.3881E+00_JPRB,4.0636E+00_JPRB,5.6724E+00_JPRB,7.2165E+00_JPRB,8.6961E+00_JPRB,&
 & 1.0098E+01_JPRB,1.1383E+01_JPRB,1.3165E+01_JPRB/)  
KAO( :, 5,12,10) = (/&
 & 8.9052E-01_JPRB,2.6097E+00_JPRB,4.2735E+00_JPRB,5.8670E+00_JPRB,7.3919E+00_JPRB,8.8391E+00_JPRB,&
 & 1.0193E+01_JPRB,1.1412E+01_JPRB,1.2995E+01_JPRB/)  
KAO( :, 1,13,10) = (/&
 & 1.6125E-01_JPRB,1.9342E+00_JPRB,3.5999E+00_JPRB,5.2092E+00_JPRB,6.7843E+00_JPRB,8.3295E+00_JPRB,&
 & 9.8358E+00_JPRB,1.1294E+01_JPRB,1.3567E+01_JPRB/)  
KAO( :, 2,13,10) = (/&
 & 2.5632E-01_JPRB,2.0509E+00_JPRB,3.7362E+00_JPRB,5.3503E+00_JPRB,6.9167E+00_JPRB,8.4371E+00_JPRB,&
 & 9.9071E+00_JPRB,1.1309E+01_JPRB,1.3421E+01_JPRB/)  
KAO( :, 3,13,10) = (/&
 & 3.8326E-01_JPRB,2.1844E+00_JPRB,3.8935E+00_JPRB,5.5111E+00_JPRB,7.0668E+00_JPRB,8.5618E+00_JPRB,&
 & 9.9929E+00_JPRB,1.1334E+01_JPRB,1.3271E+01_JPRB/)  
KAO( :, 4,13,10) = (/&
 & 5.4156E-01_JPRB,2.3369E+00_JPRB,4.0660E+00_JPRB,5.6864E+00_JPRB,7.2274E+00_JPRB,8.6942E+00_JPRB,&
 & 1.0083E+01_JPRB,1.1355E+01_JPRB,1.3103E+01_JPRB/)  
KAO( :, 5,13,10) = (/&
 & 7.3401E-01_JPRB,2.5129E+00_JPRB,4.2495E+00_JPRB,5.8694E+00_JPRB,7.3940E+00_JPRB,8.8302E+00_JPRB,&
 & 1.0173E+01_JPRB,1.1375E+01_JPRB,1.2923E+01_JPRB/)  
KAO( :, 1, 1,11) = (/&
 & 1.2249E+01_JPRB,1.0718E+01_JPRB,9.1868E+00_JPRB,7.6557E+00_JPRB,6.1245E+00_JPRB,5.7627E+00_JPRB,&
 & 6.3444E+00_JPRB,6.9424E+00_JPRB,1.9044E+01_JPRB/)  
KAO( :, 2, 1,11) = (/&
 & 1.5357E+01_JPRB,1.3437E+01_JPRB,1.1518E+01_JPRB,9.5981E+00_JPRB,7.6785E+00_JPRB,6.1637E+00_JPRB,&
 & 6.5230E+00_JPRB,7.0281E+00_JPRB,2.1345E+01_JPRB/)  
KAO( :, 3, 1,11) = (/&
 & 1.8886E+01_JPRB,1.6526E+01_JPRB,1.4165E+01_JPRB,1.1804E+01_JPRB,9.4432E+00_JPRB,7.1211E+00_JPRB,&
 & 6.7255E+00_JPRB,7.1348E+00_JPRB,2.3750E+01_JPRB/)  
KAO( :, 4, 1,11) = (/&
 & 2.2784E+01_JPRB,1.9936E+01_JPRB,1.7088E+01_JPRB,1.4240E+01_JPRB,1.1392E+01_JPRB,8.5439E+00_JPRB,&
 & 6.9461E+00_JPRB,7.2435E+00_JPRB,2.6291E+01_JPRB/)  
KAO( :, 5, 1,11) = (/&
 & 2.6987E+01_JPRB,2.3613E+01_JPRB,2.0240E+01_JPRB,1.6867E+01_JPRB,1.3493E+01_JPRB,1.0120E+01_JPRB,&
 & 7.2891E+00_JPRB,7.3404E+00_JPRB,2.9031E+01_JPRB/)  
KAO( :, 1, 2,11) = (/&
 & 9.7136E+00_JPRB,8.4994E+00_JPRB,7.2852E+00_JPRB,6.0710E+00_JPRB,5.6278E+00_JPRB,6.3983E+00_JPRB,&
 & 7.1952E+00_JPRB,7.9135E+00_JPRB,1.3515E+01_JPRB/)  
KAO( :, 2, 2,11) = (/&
 & 1.2396E+01_JPRB,1.0847E+01_JPRB,9.2971E+00_JPRB,7.7476E+00_JPRB,6.3714E+00_JPRB,6.6654E+00_JPRB,&
 & 7.3884E+00_JPRB,8.0262E+00_JPRB,1.4990E+01_JPRB/)  
KAO( :, 3, 2,11) = (/&
 & 1.5432E+01_JPRB,1.3503E+01_JPRB,1.1574E+01_JPRB,9.6447E+00_JPRB,7.7158E+00_JPRB,6.9761E+00_JPRB,&
 & 7.5844E+00_JPRB,8.1568E+00_JPRB,1.6717E+01_JPRB/)  
KAO( :, 4, 2,11) = (/&
 & 1.8816E+01_JPRB,1.6464E+01_JPRB,1.4112E+01_JPRB,1.1760E+01_JPRB,9.4077E+00_JPRB,7.5034E+00_JPRB,&
 & 7.7791E+00_JPRB,8.2755E+00_JPRB,1.8558E+01_JPRB/)  
KAO( :, 5, 2,11) = (/&
 & 2.2537E+01_JPRB,1.9720E+01_JPRB,1.6903E+01_JPRB,1.4086E+01_JPRB,1.1268E+01_JPRB,8.5223E+00_JPRB,&
 & 7.9761E+00_JPRB,8.3719E+00_JPRB,2.0482E+01_JPRB/)  
KAO( :, 1, 3,11) = (/&
 & 7.2299E+00_JPRB,6.3262E+00_JPRB,5.4224E+00_JPRB,5.1159E+00_JPRB,6.1132E+00_JPRB,7.1369E+00_JPRB,&
 & 8.1089E+00_JPRB,8.9636E+00_JPRB,1.1955E+01_JPRB/)  
KAO( :, 2, 3,11) = (/&
 & 9.3918E+00_JPRB,8.2178E+00_JPRB,7.0438E+00_JPRB,5.9613E+00_JPRB,6.4360E+00_JPRB,7.3941E+00_JPRB,&
 & 8.3154E+00_JPRB,9.1046E+00_JPRB,1.2271E+01_JPRB/)  
KAO( :, 3, 3,11) = (/&
 & 1.1905E+01_JPRB,1.0417E+01_JPRB,8.9285E+00_JPRB,7.4405E+00_JPRB,6.8201E+00_JPRB,7.6628E+00_JPRB,&
 & 8.5181E+00_JPRB,9.2389E+00_JPRB,1.2625E+01_JPRB/)  
KAO( :, 4, 3,11) = (/&
 & 1.4757E+01_JPRB,1.2912E+01_JPRB,1.1068E+01_JPRB,9.2230E+00_JPRB,7.6302E+00_JPRB,7.9463E+00_JPRB,&
 & 8.7305E+00_JPRB,9.3535E+00_JPRB,1.3024E+01_JPRB/)  
KAO( :, 5, 3,11) = (/&
 & 1.7893E+01_JPRB,1.5656E+01_JPRB,1.3420E+01_JPRB,1.1183E+01_JPRB,8.9555E+00_JPRB,8.2708E+00_JPRB,&
 & 8.9555E+00_JPRB,9.4787E+00_JPRB,1.3397E+01_JPRB/)  
KAO( :, 1, 4,11) = (/&
 & 5.1773E+00_JPRB,4.5301E+00_JPRB,4.2164E+00_JPRB,5.4189E+00_JPRB,6.6862E+00_JPRB,7.9110E+00_JPRB,&
 & 9.0375E+00_JPRB,1.0082E+01_JPRB,1.2163E+01_JPRB/)  
KAO( :, 2, 4,11) = (/&
 & 6.8907E+00_JPRB,6.0294E+00_JPRB,5.1859E+00_JPRB,5.7789E+00_JPRB,6.9881E+00_JPRB,8.1777E+00_JPRB,&
 & 9.2600E+00_JPRB,1.0217E+01_JPRB,1.2164E+01_JPRB/)  
KAO( :, 3, 4,11) = (/&
 & 8.9163E+00_JPRB,7.8018E+00_JPRB,6.6872E+00_JPRB,6.2510E+00_JPRB,7.3281E+00_JPRB,8.4646E+00_JPRB,&
 & 9.5034E+00_JPRB,1.0348E+01_JPRB,1.2247E+01_JPRB/)  
KAO( :, 4, 4,11) = (/&
 & 1.1229E+01_JPRB,9.8256E+00_JPRB,8.4220E+00_JPRB,7.1712E+00_JPRB,7.6975E+00_JPRB,8.7686E+00_JPRB,&
 & 9.7453E+00_JPRB,1.0493E+01_JPRB,1.2364E+01_JPRB/)  
KAO( :, 5, 4,11) = (/&
 & 1.3839E+01_JPRB,1.2109E+01_JPRB,1.0379E+01_JPRB,8.6495E+00_JPRB,8.1169E+00_JPRB,9.0750E+00_JPRB,&
 & 9.9810E+00_JPRB,1.0635E+01_JPRB,1.2462E+01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART7',1,ZHOOK_HANDLE)
END SUBROUTINE PART7


SUBROUTINE PART8

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART8',0,ZHOOK_HANDLE)


KAO( :, 1, 5,11) = (/&
 & 3.6436E+00_JPRB,3.1897E+00_JPRB,4.3289E+00_JPRB,5.8481E+00_JPRB,7.3102E+00_JPRB,8.6929E+00_JPRB,&
 & 9.9995E+00_JPRB,1.1197E+01_JPRB,1.3283E+01_JPRB/)  
KAO( :, 2, 5,11) = (/&
 & 4.9664E+00_JPRB,4.3456E+00_JPRB,4.6924E+00_JPRB,6.1837E+00_JPRB,7.6374E+00_JPRB,8.9934E+00_JPRB,&
 & 1.0249E+01_JPRB,1.1339E+01_JPRB,1.3236E+01_JPRB/)  
KAO( :, 3, 5,11) = (/&
 & 6.5513E+00_JPRB,5.7324E+00_JPRB,5.2481E+00_JPRB,6.5577E+00_JPRB,7.9818E+00_JPRB,9.3087E+00_JPRB,&
 & 1.0503E+01_JPRB,1.1501E+01_JPRB,1.3169E+01_JPRB/)  
KAO( :, 4, 5,11) = (/&
 & 8.4164E+00_JPRB,7.3644E+00_JPRB,6.3448E+00_JPRB,6.9578E+00_JPRB,8.3373E+00_JPRB,9.6258E+00_JPRB,&
 & 1.0752E+01_JPRB,1.1656E+01_JPRB,1.3106E+01_JPRB/)  
KAO( :, 5, 5,11) = (/&
 & 1.0527E+01_JPRB,9.2115E+00_JPRB,7.8956E+00_JPRB,7.4639E+00_JPRB,8.6974E+00_JPRB,9.9429E+00_JPRB,&
 & 1.0997E+01_JPRB,1.1797E+01_JPRB,1.3036E+01_JPRB/)  
KAO( :, 1, 6,11) = (/&
 & 2.4932E+00_JPRB,2.7486E+00_JPRB,4.5320E+00_JPRB,6.2546E+00_JPRB,7.8988E+00_JPRB,9.4652E+00_JPRB,&
 & 1.0939E+01_JPRB,1.2316E+01_JPRB,1.4467E+01_JPRB/)  
KAO( :, 2, 6,11) = (/&
 & 3.4773E+00_JPRB,3.1985E+00_JPRB,4.8742E+00_JPRB,6.5999E+00_JPRB,8.2329E+00_JPRB,9.7664E+00_JPRB,&
 & 1.1186E+01_JPRB,1.2469E+01_JPRB,1.4417E+01_JPRB/)  
KAO( :, 3, 6,11) = (/&
 & 4.6971E+00_JPRB,4.1115E+00_JPRB,5.2651E+00_JPRB,6.9733E+00_JPRB,8.5867E+00_JPRB,1.0084E+01_JPRB,&
 & 1.1436E+01_JPRB,1.2624E+01_JPRB,1.4351E+01_JPRB/)  
KAO( :, 4, 6,11) = (/&
 & 6.1495E+00_JPRB,5.3808E+00_JPRB,5.6975E+00_JPRB,7.3726E+00_JPRB,8.9642E+00_JPRB,1.0415E+01_JPRB,&
 & 1.1698E+01_JPRB,1.2772E+01_JPRB,1.4267E+01_JPRB/)  
KAO( :, 5, 6,11) = (/&
 & 7.8284E+00_JPRB,6.8498E+00_JPRB,6.3225E+00_JPRB,7.7926E+00_JPRB,9.3619E+00_JPRB,1.0759E+01_JPRB,&
 & 1.1977E+01_JPRB,1.2918E+01_JPRB,1.4175E+01_JPRB/)  
KAO( :, 1, 7,11) = (/&
 & 1.6743E+00_JPRB,2.7740E+00_JPRB,4.7631E+00_JPRB,6.6392E+00_JPRB,8.4234E+00_JPRB,1.0141E+01_JPRB,&
 & 1.1784E+01_JPRB,1.3373E+01_JPRB,1.5635E+01_JPRB/)  
KAO( :, 2, 7,11) = (/&
 & 2.3935E+00_JPRB,3.0856E+00_JPRB,5.0953E+00_JPRB,6.9911E+00_JPRB,8.7690E+00_JPRB,1.0447E+01_JPRB,&
 & 1.2034E+01_JPRB,1.3500E+01_JPRB,1.5579E+01_JPRB/)  
KAO( :, 3, 7,11) = (/&
 & 3.3116E+00_JPRB,3.4457E+00_JPRB,5.4635E+00_JPRB,7.3709E+00_JPRB,9.1406E+00_JPRB,1.0784E+01_JPRB,&
 & 1.2298E+01_JPRB,1.3644E+01_JPRB,1.5506E+01_JPRB/)  
KAO( :, 4, 7,11) = (/&
 & 4.4248E+00_JPRB,4.0263E+00_JPRB,5.8643E+00_JPRB,7.7821E+00_JPRB,9.5339E+00_JPRB,1.1137E+01_JPRB,&
 & 1.2583E+01_JPRB,1.3796E+01_JPRB,1.5411E+01_JPRB/)  
KAO( :, 5, 7,11) = (/&
 & 5.7412E+00_JPRB,5.0279E+00_JPRB,6.2969E+00_JPRB,8.2091E+00_JPRB,9.9459E+00_JPRB,1.1502E+01_JPRB,&
 & 1.2876E+01_JPRB,1.3971E+01_JPRB,1.5296E+01_JPRB/)  
KAO( :, 1, 8,11) = (/&
 & 1.1086E+00_JPRB,2.8048E+00_JPRB,4.9324E+00_JPRB,6.9454E+00_JPRB,8.8812E+00_JPRB,1.0739E+01_JPRB,&
 & 1.2537E+01_JPRB,1.4271E+01_JPRB,1.6686E+01_JPRB/)  
KAO( :, 2, 8,11) = (/&
 & 1.6296E+00_JPRB,3.0851E+00_JPRB,5.2594E+00_JPRB,7.2944E+00_JPRB,9.2229E+00_JPRB,1.1045E+01_JPRB,&
 & 1.2773E+01_JPRB,1.4378E+01_JPRB,1.6616E+01_JPRB/)  
KAO( :, 3, 8,11) = (/&
 & 2.3055E+00_JPRB,3.4160E+00_JPRB,5.6286E+00_JPRB,7.6727E+00_JPRB,9.5919E+00_JPRB,1.1383E+01_JPRB,&
 & 1.3041E+01_JPRB,1.4518E+01_JPRB,1.6520E+01_JPRB/)  
KAO( :, 4, 8,11) = (/&
 & 3.1507E+00_JPRB,3.7895E+00_JPRB,6.0300E+00_JPRB,8.0860E+00_JPRB,9.9827E+00_JPRB,1.1736E+01_JPRB,&
 & 1.3326E+01_JPRB,1.4687E+01_JPRB,1.6411E+01_JPRB/)  
KAO( :, 5, 8,11) = (/&
 & 4.1629E+00_JPRB,4.2135E+00_JPRB,6.4636E+00_JPRB,8.5234E+00_JPRB,1.0396E+01_JPRB,1.2103E+01_JPRB,&
 & 1.3619E+01_JPRB,1.4867E+01_JPRB,1.6271E+01_JPRB/)  
KAO( :, 1, 9,11) = (/&
 & 7.2274E-01_JPRB,2.8188E+00_JPRB,5.0463E+00_JPRB,7.1564E+00_JPRB,9.1934E+00_JPRB,1.1175E+01_JPRB,&
 & 1.3093E+01_JPRB,1.4982E+01_JPRB,1.7490E+01_JPRB/)  
KAO( :, 2, 9,11) = (/&
 & 1.0936E+00_JPRB,3.0846E+00_JPRB,5.3597E+00_JPRB,7.4879E+00_JPRB,9.5212E+00_JPRB,1.1468E+01_JPRB,&
 & 1.3317E+01_JPRB,1.5061E+01_JPRB,1.7405E+01_JPRB/)  
KAO( :, 3, 9,11) = (/&
 & 1.5844E+00_JPRB,3.3914E+00_JPRB,5.7218E+00_JPRB,7.8597E+00_JPRB,9.8794E+00_JPRB,1.1792E+01_JPRB,&
 & 1.3571E+01_JPRB,1.5196E+01_JPRB,1.7299E+01_JPRB/)  
KAO( :, 4, 9,11) = (/&
 & 2.2133E+00_JPRB,3.7382E+00_JPRB,6.1198E+00_JPRB,8.2738E+00_JPRB,1.0272E+01_JPRB,1.2140E+01_JPRB,&
 & 1.3853E+01_JPRB,1.5355E+01_JPRB,1.7167E+01_JPRB/)  
KAO( :, 5, 9,11) = (/&
 & 2.9830E+00_JPRB,4.1284E+00_JPRB,6.5526E+00_JPRB,8.7144E+00_JPRB,1.0697E+01_JPRB,1.2510E+01_JPRB,&
 & 1.4140E+01_JPRB,1.5515E+01_JPRB,1.7007E+01_JPRB/)  
KAO( :, 1,10,11) = (/&
 & 4.8237E-01_JPRB,2.8147E+00_JPRB,5.0928E+00_JPRB,7.2773E+00_JPRB,9.3839E+00_JPRB,1.1437E+01_JPRB,&
 & 1.3443E+01_JPRB,1.5464E+01_JPRB,1.8003E+01_JPRB/)  
KAO( :, 2,10,11) = (/&
 & 7.4855E-01_JPRB,3.0669E+00_JPRB,5.3977E+00_JPRB,7.5863E+00_JPRB,9.6799E+00_JPRB,1.1699E+01_JPRB,&
 & 1.3634E+01_JPRB,1.5493E+01_JPRB,1.7884E+01_JPRB/)  
KAO( :, 3,10,11) = (/&
 & 1.1085E+00_JPRB,3.3611E+00_JPRB,5.7474E+00_JPRB,7.9493E+00_JPRB,1.0026E+01_JPRB,1.2005E+01_JPRB,&
 & 1.3869E+01_JPRB,1.5596E+01_JPRB,1.7749E+01_JPRB/)  
KAO( :, 4,10,11) = (/&
 & 1.5772E+00_JPRB,3.6970E+00_JPRB,6.1332E+00_JPRB,8.3566E+00_JPRB,1.0418E+01_JPRB,1.2345E+01_JPRB,&
 & 1.4128E+01_JPRB,1.5721E+01_JPRB,1.7584E+01_JPRB/)  
KAO( :, 5,10,11) = (/&
 & 2.1652E+00_JPRB,4.0698E+00_JPRB,6.5606E+00_JPRB,8.7912E+00_JPRB,1.0837E+01_JPRB,1.2714E+01_JPRB,&
 & 1.4407E+01_JPRB,1.5850E+01_JPRB,1.7388E+01_JPRB/)  
KAO( :, 1,11,11) = (/&
 & 3.9938E-01_JPRB,2.8599E+00_JPRB,5.1737E+00_JPRB,7.3744E+00_JPRB,9.5072E+00_JPRB,1.1586E+01_JPRB,&
 & 1.3611E+01_JPRB,1.5598E+01_JPRB,1.8201E+01_JPRB/)  
KAO( :, 2,11,11) = (/&
 & 6.1944E-01_JPRB,3.1115E+00_JPRB,5.4721E+00_JPRB,7.6865E+00_JPRB,9.8054E+00_JPRB,1.1843E+01_JPRB,&
 & 1.3793E+01_JPRB,1.5638E+01_JPRB,1.8068E+01_JPRB/)  
KAO( :, 3,11,11) = (/&
 & 9.1846E-01_JPRB,3.4110E+00_JPRB,5.8171E+00_JPRB,8.0466E+00_JPRB,1.0149E+01_JPRB,1.2140E+01_JPRB,&
 & 1.4010E+01_JPRB,1.5725E+01_JPRB,1.7913E+01_JPRB/)  
KAO( :, 4,11,11) = (/&
 & 1.3105E+00_JPRB,3.7482E+00_JPRB,6.2097E+00_JPRB,8.4443E+00_JPRB,1.0527E+01_JPRB,1.2468E+01_JPRB,&
 & 1.4250E+01_JPRB,1.5828E+01_JPRB,1.7729E+01_JPRB/)  
KAO( :, 5,11,11) = (/&
 & 1.7999E+00_JPRB,4.1235E+00_JPRB,6.6430E+00_JPRB,8.8791E+00_JPRB,1.0932E+01_JPRB,1.2815E+01_JPRB,&
 & 1.4506E+01_JPRB,1.5945E+01_JPRB,1.7528E+01_JPRB/)  
KAO( :, 1,12,11) = (/&
 & 3.3001E-01_JPRB,2.8413E+00_JPRB,5.1496E+00_JPRB,7.3701E+00_JPRB,9.5381E+00_JPRB,1.1655E+01_JPRB,&
 & 1.3720E+01_JPRB,1.5739E+01_JPRB,1.8506E+01_JPRB/)  
KAO( :, 2,12,11) = (/&
 & 5.1236E-01_JPRB,3.0945E+00_JPRB,5.4327E+00_JPRB,7.6537E+00_JPRB,9.8045E+00_JPRB,1.1878E+01_JPRB,&
 & 1.3880E+01_JPRB,1.5791E+01_JPRB,1.8378E+01_JPRB/)  
KAO( :, 3,12,11) = (/&
 & 7.6165E-01_JPRB,3.3895E+00_JPRB,5.7691E+00_JPRB,7.9857E+00_JPRB,1.0106E+01_JPRB,1.2132E+01_JPRB,&
 & 1.4063E+01_JPRB,1.5865E+01_JPRB,1.8221E+01_JPRB/)  
KAO( :, 4,12,11) = (/&
 & 1.0868E+00_JPRB,3.7244E+00_JPRB,6.1541E+00_JPRB,8.3616E+00_JPRB,1.0442E+01_JPRB,1.2411E+01_JPRB,&
 & 1.4266E+01_JPRB,1.5951E+01_JPRB,1.8046E+01_JPRB/)  
KAO( :, 5,12,11) = (/&
 & 1.4941E+00_JPRB,4.0983E+00_JPRB,6.5760E+00_JPRB,8.7801E+00_JPRB,1.0819E+01_JPRB,1.2722E+01_JPRB,&
 & 1.4491E+01_JPRB,1.6054E+01_JPRB,1.7865E+01_JPRB/)  
KAO( :, 1,13,11) = (/&
 & 2.7270E-01_JPRB,2.8097E+00_JPRB,5.1608E+00_JPRB,7.4465E+00_JPRB,9.6830E+00_JPRB,1.1871E+01_JPRB,&
 & 1.4022E+01_JPRB,1.6138E+01_JPRB,1.9047E+01_JPRB/)  
KAO( :, 2,13,11) = (/&
 & 4.2335E-01_JPRB,3.0310E+00_JPRB,5.4040E+00_JPRB,7.6870E+00_JPRB,9.9007E+00_JPRB,1.2059E+01_JPRB,&
 & 1.4159E+01_JPRB,1.6185E+01_JPRB,1.8912E+01_JPRB/)  
KAO( :, 3,13,11) = (/&
 & 6.2933E-01_JPRB,3.3002E+00_JPRB,5.6896E+00_JPRB,7.9624E+00_JPRB,1.0150E+01_JPRB,1.2270E+01_JPRB,&
 & 1.4311E+01_JPRB,1.6247E+01_JPRB,1.8754E+01_JPRB/)  
KAO( :, 4,13,11) = (/&
 & 8.9928E-01_JPRB,3.6212E+00_JPRB,6.0182E+00_JPRB,8.2763E+00_JPRB,1.0433E+01_JPRB,1.2504E+01_JPRB,&
 & 1.4478E+01_JPRB,1.6320E+01_JPRB,1.8583E+01_JPRB/)  
KAO( :, 5,13,11) = (/&
 & 1.2370E+00_JPRB,3.9832E+00_JPRB,6.3965E+00_JPRB,8.6284E+00_JPRB,1.0744E+01_JPRB,1.2756E+01_JPRB,&
 & 1.4653E+01_JPRB,1.6388E+01_JPRB,1.8390E+01_JPRB/)  
KAO( :, 1, 1,12) = (/&
 & 1.9306E+01_JPRB,1.6893E+01_JPRB,1.4480E+01_JPRB,1.2067E+01_JPRB,9.6532E+00_JPRB,7.2945E+00_JPRB,&
 & 6.9148E+00_JPRB,7.5278E+00_JPRB,2.3433E+01_JPRB/)  
KAO( :, 2, 1,12) = (/&
 & 2.4650E+01_JPRB,2.1569E+01_JPRB,1.8488E+01_JPRB,1.5406E+01_JPRB,1.2325E+01_JPRB,9.2438E+00_JPRB,&
 & 7.2171E+00_JPRB,7.6406E+00_JPRB,2.6606E+01_JPRB/)  
KAO( :, 3, 1,12) = (/&
 & 3.0678E+01_JPRB,2.6843E+01_JPRB,2.3008E+01_JPRB,1.9174E+01_JPRB,1.5339E+01_JPRB,1.1504E+01_JPRB,&
 & 7.9763E+00_JPRB,7.7730E+00_JPRB,2.9832E+01_JPRB/)  
KAO( :, 4, 1,12) = (/&
 & 3.7441E+01_JPRB,3.2761E+01_JPRB,2.8081E+01_JPRB,2.3400E+01_JPRB,1.8720E+01_JPRB,1.4040E+01_JPRB,&
 & 9.3666E+00_JPRB,7.8947E+00_JPRB,3.2935E+01_JPRB/)  
KAO( :, 5, 1,12) = (/&
 & 4.5012E+01_JPRB,3.9386E+01_JPRB,3.3759E+01_JPRB,2.8133E+01_JPRB,2.2506E+01_JPRB,1.6880E+01_JPRB,&
 & 1.1253E+01_JPRB,8.0012E+00_JPRB,3.6133E+01_JPRB/)  
KAO( :, 1, 2,12) = (/&
 & 1.5936E+01_JPRB,1.3944E+01_JPRB,1.1952E+01_JPRB,9.9601E+00_JPRB,7.9681E+00_JPRB,7.1477E+00_JPRB,&
 & 7.9439E+00_JPRB,8.7252E+00_JPRB,1.6736E+01_JPRB/)  
KAO( :, 2, 2,12) = (/&
 & 2.0659E+01_JPRB,1.8076E+01_JPRB,1.5494E+01_JPRB,1.2912E+01_JPRB,1.0329E+01_JPRB,8.0751E+00_JPRB,&
 & 8.1865E+00_JPRB,8.8715E+00_JPRB,1.8751E+01_JPRB/)  
KAO( :, 3, 2,12) = (/&
 & 2.6211E+01_JPRB,2.2935E+01_JPRB,1.9658E+01_JPRB,1.6382E+01_JPRB,1.3106E+01_JPRB,9.8303E+00_JPRB,&
 & 8.4476E+00_JPRB,9.0112E+00_JPRB,2.0857E+01_JPRB/)  
KAO( :, 4, 2,12) = (/&
 & 3.2434E+01_JPRB,2.8380E+01_JPRB,2.4326E+01_JPRB,2.0271E+01_JPRB,1.6217E+01_JPRB,1.2163E+01_JPRB,&
 & 8.9851E+00_JPRB,9.1339E+00_JPRB,2.2883E+01_JPRB/)  
KAO( :, 5, 2,12) = (/&
 & 3.9217E+01_JPRB,3.4315E+01_JPRB,2.9413E+01_JPRB,2.4511E+01_JPRB,1.9608E+01_JPRB,1.4706E+01_JPRB,&
 & 1.0077E+01_JPRB,9.2744E+00_JPRB,2.5016E+01_JPRB/)  
KAO( :, 1, 3,12) = (/&
 & 1.2204E+01_JPRB,1.0678E+01_JPRB,9.1529E+00_JPRB,7.6274E+00_JPRB,7.0064E+00_JPRB,8.0165E+00_JPRB,&
 & 9.1087E+00_JPRB,1.0091E+01_JPRB,1.3158E+01_JPRB/)  
KAO( :, 2, 3,12) = (/&
 & 1.6264E+01_JPRB,1.4231E+01_JPRB,1.2198E+01_JPRB,1.0165E+01_JPRB,8.2928E+00_JPRB,8.3522E+00_JPRB,&
 & 9.3382E+00_JPRB,1.0239E+01_JPRB,1.3470E+01_JPRB/)  
KAO( :, 3, 3,12) = (/&
 & 2.0966E+01_JPRB,1.8346E+01_JPRB,1.5725E+01_JPRB,1.3104E+01_JPRB,1.0483E+01_JPRB,8.9163E+00_JPRB,&
 & 9.5941E+00_JPRB,1.0378E+01_JPRB,1.3791E+01_JPRB/)  
KAO( :, 4, 3,12) = (/&
 & 2.6346E+01_JPRB,2.3053E+01_JPRB,1.9760E+01_JPRB,1.6466E+01_JPRB,1.3173E+01_JPRB,1.0186E+01_JPRB,&
 & 9.8769E+00_JPRB,1.0543E+01_JPRB,1.4208E+01_JPRB/)  
KAO( :, 5, 3,12) = (/&
 & 3.2499E+01_JPRB,2.8437E+01_JPRB,2.4374E+01_JPRB,2.0312E+01_JPRB,1.6250E+01_JPRB,1.2192E+01_JPRB,&
 & 1.0198E+01_JPRB,1.0709E+01_JPRB,1.4690E+01_JPRB/)  
KAO( :, 1, 4,12) = (/&
 & 9.0048E+00_JPRB,7.8792E+00_JPRB,6.7536E+00_JPRB,6.3903E+00_JPRB,7.6603E+00_JPRB,9.0569E+00_JPRB,&
 & 1.0373E+01_JPRB,1.1571E+01_JPRB,1.3828E+01_JPRB/)  
KAO( :, 2, 4,12) = (/&
 & 1.2261E+01_JPRB,1.0728E+01_JPRB,9.1954E+00_JPRB,7.7773E+00_JPRB,8.0813E+00_JPRB,9.3965E+00_JPRB,&
 & 1.0654E+01_JPRB,1.1734E+01_JPRB,1.3859E+01_JPRB/)  
KAO( :, 3, 4,12) = (/&
 & 1.6168E+01_JPRB,1.4147E+01_JPRB,1.2126E+01_JPRB,1.0105E+01_JPRB,8.8961E+00_JPRB,9.7573E+00_JPRB,&
 & 1.0940E+01_JPRB,1.1931E+01_JPRB,1.3916E+01_JPRB/)  
KAO( :, 4, 4,12) = (/&
 & 2.0801E+01_JPRB,1.8201E+01_JPRB,1.5600E+01_JPRB,1.3000E+01_JPRB,1.0554E+01_JPRB,1.0169E+01_JPRB,&
 & 1.1223E+01_JPRB,1.2118E+01_JPRB,1.4034E+01_JPRB/)  
KAO( :, 5, 4,12) = (/&
 & 2.5988E+01_JPRB,2.2740E+01_JPRB,1.9491E+01_JPRB,1.6243E+01_JPRB,1.2994E+01_JPRB,1.0946E+01_JPRB,&
 & 1.1496E+01_JPRB,1.2284E+01_JPRB,1.4164E+01_JPRB/)  
KAO( :, 1, 5,12) = (/&
 & 6.4609E+00_JPRB,5.6532E+00_JPRB,5.2932E+00_JPRB,6.8539E+00_JPRB,8.5960E+00_JPRB,1.0239E+01_JPRB,&
 & 1.1787E+01_JPRB,1.3220E+01_JPRB,1.5562E+01_JPRB/)  
KAO( :, 2, 5,12) = (/&
 & 9.0364E+00_JPRB,7.9068E+00_JPRB,6.8055E+00_JPRB,7.2952E+00_JPRB,8.9859E+00_JPRB,1.0601E+01_JPRB,&
 & 1.2085E+01_JPRB,1.3419E+01_JPRB,1.5565E+01_JPRB/)  
KAO( :, 3, 5,12) = (/&
 & 1.2240E+01_JPRB,1.0710E+01_JPRB,9.1797E+00_JPRB,8.2618E+00_JPRB,9.3995E+00_JPRB,1.0970E+01_JPRB,&
 & 1.2380E+01_JPRB,1.3618E+01_JPRB,1.5546E+01_JPRB/)  
KAO( :, 4, 5,12) = (/&
 & 1.6001E+01_JPRB,1.4001E+01_JPRB,1.2001E+01_JPRB,1.0093E+01_JPRB,9.9460E+00_JPRB,1.1348E+01_JPRB,&
 & 1.2695E+01_JPRB,1.3806E+01_JPRB,1.5493E+01_JPRB/)  
KAO( :, 5, 5,12) = (/&
 & 2.0392E+01_JPRB,1.7843E+01_JPRB,1.5294E+01_JPRB,1.2745E+01_JPRB,1.1072E+01_JPRB,1.1762E+01_JPRB,&
 & 1.3031E+01_JPRB,1.4007E+01_JPRB,1.5413E+01_JPRB/)  
KAO( :, 1, 6,12) = (/&
 & 4.4633E+00_JPRB,3.9388E+00_JPRB,5.4668E+00_JPRB,7.5584E+00_JPRB,9.5392E+00_JPRB,1.1432E+01_JPRB,&
 & 1.3234E+01_JPRB,1.4983E+01_JPRB,1.7552E+01_JPRB/)  
KAO( :, 2, 6,12) = (/&
 & 6.4534E+00_JPRB,5.6467E+00_JPRB,5.9493E+00_JPRB,7.9882E+00_JPRB,9.9652E+00_JPRB,1.1825E+01_JPRB,&
 & 1.3565E+01_JPRB,1.5163E+01_JPRB,1.7552E+01_JPRB/)  
KAO( :, 3, 6,12) = (/&
 & 8.9369E+00_JPRB,7.8198E+00_JPRB,7.0306E+00_JPRB,8.4620E+00_JPRB,1.0422E+01_JPRB,1.2244E+01_JPRB,&
 & 1.3924E+01_JPRB,1.5375E+01_JPRB,1.7522E+01_JPRB/)  
KAO( :, 4, 6,12) = (/&
 & 1.1971E+01_JPRB,1.0475E+01_JPRB,8.9883E+00_JPRB,9.0910E+00_JPRB,1.0899E+01_JPRB,1.2682E+01_JPRB,&
 & 1.4284E+01_JPRB,1.5608E+01_JPRB,1.7458E+01_JPRB/)  
KAO( :, 5, 6,12) = (/&
 & 1.5570E+01_JPRB,1.3624E+01_JPRB,1.1678E+01_JPRB,1.0383E+01_JPRB,1.1407E+01_JPRB,1.3124E+01_JPRB,&
 & 1.4643E+01_JPRB,1.5845E+01_JPRB,1.7360E+01_JPRB/)  
KAO( :, 1, 7,12) = (/&
 & 3.0144E+00_JPRB,3.4301E+00_JPRB,5.9195E+00_JPRB,8.2854E+00_JPRB,1.0547E+01_JPRB,1.2704E+01_JPRB,&
 & 1.4784E+01_JPRB,1.6795E+01_JPRB,1.9646E+01_JPRB/)  
KAO( :, 2, 7,12) = (/&
 & 4.4866E+00_JPRB,4.1345E+00_JPRB,6.3401E+00_JPRB,8.7329E+00_JPRB,1.0993E+01_JPRB,1.3127E+01_JPRB,&
 & 1.5133E+01_JPRB,1.6992E+01_JPRB,1.9648E+01_JPRB/)  
KAO( :, 3, 7,12) = (/&
 & 6.3891E+00_JPRB,5.5915E+00_JPRB,6.8167E+00_JPRB,9.2170E+00_JPRB,1.1473E+01_JPRB,1.3569E+01_JPRB,&
 & 1.5507E+01_JPRB,1.7228E+01_JPRB,1.9616E+01_JPRB/)  
KAO( :, 4, 7,12) = (/&
 & 8.7782E+00_JPRB,7.6809E+00_JPRB,7.5739E+00_JPRB,9.7331E+00_JPRB,1.1970E+01_JPRB,1.4031E+01_JPRB,&
 & 1.5873E+01_JPRB,1.7477E+01_JPRB,1.9541E+01_JPRB/)  
KAO( :, 5, 7,12) = (/&
 & 1.1625E+01_JPRB,1.0171E+01_JPRB,9.0298E+00_JPRB,1.0306E+01_JPRB,1.2492E+01_JPRB,1.4497E+01_JPRB,&
 & 1.6257E+01_JPRB,1.7701E+01_JPRB,1.9439E+01_JPRB/)  
KAO( :, 1, 8,12) = (/&
 & 1.9926E+00_JPRB,3.6034E+00_JPRB,6.3775E+00_JPRB,8.9929E+00_JPRB,1.1503E+01_JPRB,1.3945E+01_JPRB,&
 & 1.6299E+01_JPRB,1.8684E+01_JPRB,2.1745E+01_JPRB/)  
KAO( :, 2, 8,12) = (/&
 & 3.0617E+00_JPRB,3.9634E+00_JPRB,6.8142E+00_JPRB,9.4600E+00_JPRB,1.1969E+01_JPRB,1.4375E+01_JPRB,&
 & 1.6657E+01_JPRB,1.8850E+01_JPRB,2.1761E+01_JPRB/)  
KAO( :, 3, 8,12) = (/&
 & 4.4985E+00_JPRB,4.5132E+00_JPRB,7.2998E+00_JPRB,9.9757E+00_JPRB,1.2478E+01_JPRB,1.4838E+01_JPRB,&
 & 1.7040E+01_JPRB,1.9071E+01_JPRB,2.1736E+01_JPRB/)  
KAO( :, 4, 8,12) = (/&
 & 6.3130E+00_JPRB,5.6506E+00_JPRB,7.8250E+00_JPRB,1.0530E+01_JPRB,1.3024E+01_JPRB,1.5335E+01_JPRB,&
 & 1.7448E+01_JPRB,1.9301E+01_JPRB,2.1660E+01_JPRB/)  
KAO( :, 5, 8,12) = (/&
 & 8.5677E+00_JPRB,7.4967E+00_JPRB,8.4271E+00_JPRB,1.1119E+01_JPRB,1.3598E+01_JPRB,1.5852E+01_JPRB,&
 & 1.7874E+01_JPRB,1.9541E+01_JPRB,2.1548E+01_JPRB/)  
KAO( :, 1, 9,12) = (/&
 & 1.2882E+00_JPRB,3.7811E+00_JPRB,6.7889E+00_JPRB,9.6675E+00_JPRB,1.2448E+01_JPRB,1.5144E+01_JPRB,&
 & 1.7789E+01_JPRB,2.0526E+01_JPRB,2.3798E+01_JPRB/)  
KAO( :, 2, 9,12) = (/&
 & 2.0503E+00_JPRB,4.1428E+00_JPRB,7.2351E+00_JPRB,1.0146E+01_JPRB,1.2918E+01_JPRB,1.5574E+01_JPRB,&
 & 1.8133E+01_JPRB,2.0600E+01_JPRB,2.3807E+01_JPRB/)  
KAO( :, 3, 9,12) = (/&
 & 3.0980E+00_JPRB,4.5533E+00_JPRB,7.7296E+00_JPRB,1.0674E+01_JPRB,1.3445E+01_JPRB,1.6056E+01_JPRB,&
 & 1.8526E+01_JPRB,2.0799E+01_JPRB,2.3759E+01_JPRB/)  
KAO( :, 4, 9,12) = (/&
 & 4.4694E+00_JPRB,5.0345E+00_JPRB,8.2724E+00_JPRB,1.1243E+01_JPRB,1.4010E+01_JPRB,1.6578E+01_JPRB,&
 & 1.8947E+01_JPRB,2.1039E+01_JPRB,2.3671E+01_JPRB/)  
KAO( :, 5, 9,12) = (/&
 & 6.1961E+00_JPRB,5.9006E+00_JPRB,8.8587E+00_JPRB,1.1853E+01_JPRB,1.4601E+01_JPRB,1.7119E+01_JPRB,&
 & 1.9383E+01_JPRB,2.1299E+01_JPRB,2.3541E+01_JPRB/)  
KAO( :, 1,10,12) = (/&
 & 8.5127E-01_JPRB,3.9419E+00_JPRB,7.1781E+00_JPRB,1.0273E+01_JPRB,1.3291E+01_JPRB,1.6253E+01_JPRB,&
 & 1.9160E+01_JPRB,2.2190E+01_JPRB,2.5668E+01_JPRB/)  
KAO( :, 2,10,12) = (/&
 & 1.3967E+00_JPRB,4.3019E+00_JPRB,7.6193E+00_JPRB,1.0754E+01_JPRB,1.3770E+01_JPRB,1.6679E+01_JPRB,&
 & 1.9482E+01_JPRB,2.2205E+01_JPRB,2.5653E+01_JPRB/)  
KAO( :, 3,10,12) = (/&
 & 2.1663E+00_JPRB,4.7169E+00_JPRB,8.1215E+00_JPRB,1.1290E+01_JPRB,1.4299E+01_JPRB,1.7163E+01_JPRB,&
 & 1.9866E+01_JPRB,2.2382E+01_JPRB,2.5585E+01_JPRB/)  
KAO( :, 4,10,12) = (/&
 & 3.2052E+00_JPRB,5.1856E+00_JPRB,8.6831E+00_JPRB,1.1877E+01_JPRB,1.4873E+01_JPRB,1.7685E+01_JPRB,&
 & 2.0283E+01_JPRB,2.2619E+01_JPRB,2.5476E+01_JPRB/)  
KAO( :, 5,10,12) = (/&
 & 4.5284E+00_JPRB,5.7035E+00_JPRB,9.2918E+00_JPRB,1.2513E+01_JPRB,1.5482E+01_JPRB,1.8231E+01_JPRB,&
 & 2.0720E+01_JPRB,2.2887E+01_JPRB,2.5332E+01_JPRB/)  
KAO( :, 1,11,12) = (/&
 & 7.1408E-01_JPRB,4.2187E+00_JPRB,7.6724E+00_JPRB,1.0987E+01_JPRB,1.4213E+01_JPRB,1.7344E+01_JPRB,&
 & 2.0412E+01_JPRB,2.3581E+01_JPRB,2.7221E+01_JPRB/)  
KAO( :, 2,11,12) = (/&
 & 1.1737E+00_JPRB,4.6015E+00_JPRB,8.1394E+00_JPRB,1.1481E+01_JPRB,1.4695E+01_JPRB,1.7776E+01_JPRB,&
 & 2.0744E+01_JPRB,2.3608E+01_JPRB,2.7158E+01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART8',1,ZHOOK_HANDLE)
END SUBROUTINE PART8


SUBROUTINE PART9

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART9',0,ZHOOK_HANDLE)


KAO( :, 3,11,12) = (/&
 & 1.8278E+00_JPRB,5.0397E+00_JPRB,8.6695E+00_JPRB,1.2042E+01_JPRB,1.5239E+01_JPRB,1.8262E+01_JPRB,&
 & 2.1130E+01_JPRB,2.3787E+01_JPRB,2.7045E+01_JPRB/)  
KAO( :, 4,11,12) = (/&
 & 2.7031E+00_JPRB,5.5344E+00_JPRB,9.2593E+00_JPRB,1.2658E+01_JPRB,1.5837E+01_JPRB,1.8803E+01_JPRB,&
 & 2.1557E+01_JPRB,2.4018E+01_JPRB,2.6895E+01_JPRB/)  
KAO( :, 5,11,12) = (/&
 & 3.8301E+00_JPRB,6.0785E+00_JPRB,9.8968E+00_JPRB,1.3323E+01_JPRB,1.6474E+01_JPRB,1.9384E+01_JPRB,&
 & 2.2018E+01_JPRB,2.4269E+01_JPRB,2.6697E+01_JPRB/)  
KAO( :, 1,12,12) = (/&
 & 5.9719E-01_JPRB,4.4357E+00_JPRB,8.0495E+00_JPRB,1.1513E+01_JPRB,1.4864E+01_JPRB,1.8123E+01_JPRB,&
 & 2.1317E+01_JPRB,2.4560E+01_JPRB,2.8304E+01_JPRB/)  
KAO( :, 2,12,12) = (/&
 & 9.8514E-01_JPRB,4.8310E+00_JPRB,8.5352E+00_JPRB,1.2024E+01_JPRB,1.5349E+01_JPRB,1.8551E+01_JPRB,&
 & 2.1630E+01_JPRB,2.4592E+01_JPRB,2.8167E+01_JPRB/)  
KAO( :, 3,12,12) = (/&
 & 1.5344E+00_JPRB,5.2869E+00_JPRB,9.0837E+00_JPRB,1.2602E+01_JPRB,1.5914E+01_JPRB,1.9055E+01_JPRB,&
 & 2.2019E+01_JPRB,2.4762E+01_JPRB,2.7998E+01_JPRB/)  
KAO( :, 4,12,12) = (/&
 & 2.2758E+00_JPRB,5.8021E+00_JPRB,9.6908E+00_JPRB,1.3238E+01_JPRB,1.6534E+01_JPRB,1.9617E+01_JPRB,&
 & 2.2454E+01_JPRB,2.4978E+01_JPRB,2.7783E+01_JPRB/)  
KAO( :, 5,12,12) = (/&
 & 3.2239E+00_JPRB,6.3684E+00_JPRB,1.0355E+01_JPRB,1.3925E+01_JPRB,1.7197E+01_JPRB,2.0204E+01_JPRB,&
 & 2.2925E+01_JPRB,2.5222E+01_JPRB,2.7528E+01_JPRB/)  
KAO( :, 1,13,12) = (/&
 & 4.9832E-01_JPRB,4.5623E+00_JPRB,8.2781E+00_JPRB,1.1820E+01_JPRB,1.5240E+01_JPRB,1.8570E+01_JPRB,&
 & 2.1811E+01_JPRB,2.5026E+01_JPRB,2.8851E+01_JPRB/)  
KAO( :, 2,13,12) = (/&
 & 8.2244E-01_JPRB,4.9642E+00_JPRB,8.7578E+00_JPRB,1.2321E+01_JPRB,1.5731E+01_JPRB,1.9002E+01_JPRB,&
 & 2.2129E+01_JPRB,2.5100E+01_JPRB,2.8676E+01_JPRB/)  
KAO( :, 3,13,12) = (/&
 & 1.2846E+00_JPRB,5.4326E+00_JPRB,9.3155E+00_JPRB,1.2900E+01_JPRB,1.6287E+01_JPRB,1.9496E+01_JPRB,&
 & 2.2507E+01_JPRB,2.5267E+01_JPRB,2.8460E+01_JPRB/)  
KAO( :, 4,13,12) = (/&
 & 1.9049E+00_JPRB,5.9589E+00_JPRB,9.9399E+00_JPRB,1.3548E+01_JPRB,1.6904E+01_JPRB,2.0038E+01_JPRB,&
 & 2.2926E+01_JPRB,2.5474E+01_JPRB,2.8207E+01_JPRB/)  
KAO( :, 5,13,12) = (/&
 & 2.7022E+00_JPRB,6.5411E+00_JPRB,1.0623E+01_JPRB,1.4250E+01_JPRB,1.7574E+01_JPRB,2.0623E+01_JPRB,&
 & 2.3373E+01_JPRB,2.5690E+01_JPRB,2.7914E+01_JPRB/)  
KAO( :, 1, 1,13) = (/&
 & 3.4080E+01_JPRB,2.9820E+01_JPRB,2.5560E+01_JPRB,2.1300E+01_JPRB,1.7040E+01_JPRB,1.2780E+01_JPRB,&
 & 8.7310E+00_JPRB,8.0673E+00_JPRB,2.9577E+01_JPRB/)  
KAO( :, 2, 1,13) = (/&
 & 4.4290E+01_JPRB,3.8754E+01_JPRB,3.3217E+01_JPRB,2.7681E+01_JPRB,2.2145E+01_JPRB,1.6609E+01_JPRB,&
 & 1.1073E+01_JPRB,8.2554E+00_JPRB,3.3128E+01_JPRB/)  
KAO( :, 3, 1,13) = (/&
 & 5.6045E+01_JPRB,4.9040E+01_JPRB,4.2034E+01_JPRB,3.5028E+01_JPRB,2.8023E+01_JPRB,2.1017E+01_JPRB,&
 & 1.4011E+01_JPRB,8.4999E+00_JPRB,3.6715E+01_JPRB/)  
KAO( :, 4, 1,13) = (/&
 & 6.9030E+01_JPRB,6.0401E+01_JPRB,5.1772E+01_JPRB,4.3144E+01_JPRB,3.4515E+01_JPRB,2.5886E+01_JPRB,&
 & 1.7257E+01_JPRB,9.2154E+00_JPRB,4.0421E+01_JPRB/)  
KAO( :, 5, 1,13) = (/&
 & 8.3025E+01_JPRB,7.2647E+01_JPRB,6.2269E+01_JPRB,5.1890E+01_JPRB,4.1512E+01_JPRB,3.1134E+01_JPRB,&
 & 2.0756E+01_JPRB,1.0504E+01_JPRB,4.4180E+01_JPRB/)  
KAO( :, 1, 2,13) = (/&
 & 3.0233E+01_JPRB,2.6454E+01_JPRB,2.2675E+01_JPRB,1.8895E+01_JPRB,1.5116E+01_JPRB,1.1337E+01_JPRB,&
 & 8.9456E+00_JPRB,9.4618E+00_JPRB,2.0893E+01_JPRB/)  
KAO( :, 2, 2,13) = (/&
 & 3.9883E+01_JPRB,3.4897E+01_JPRB,2.9912E+01_JPRB,2.4927E+01_JPRB,1.9941E+01_JPRB,1.4956E+01_JPRB,&
 & 1.0322E+01_JPRB,9.6468E+00_JPRB,2.3460E+01_JPRB/)  
KAO( :, 3, 2,13) = (/&
 & 5.0858E+01_JPRB,4.4501E+01_JPRB,3.8144E+01_JPRB,3.1786E+01_JPRB,2.5429E+01_JPRB,1.9072E+01_JPRB,&
 & 1.2717E+01_JPRB,9.8260E+00_JPRB,2.6105E+01_JPRB/)  
KAO( :, 4, 2,13) = (/&
 & 6.3293E+01_JPRB,5.5381E+01_JPRB,4.7469E+01_JPRB,3.9558E+01_JPRB,3.1646E+01_JPRB,2.3735E+01_JPRB,&
 & 1.5823E+01_JPRB,1.0061E+01_JPRB,2.8871E+01_JPRB/)  
KAO( :, 5, 2,13) = (/&
 & 7.7095E+01_JPRB,6.7458E+01_JPRB,5.7821E+01_JPRB,4.8184E+01_JPRB,3.8547E+01_JPRB,2.8911E+01_JPRB,&
 & 1.9274E+01_JPRB,1.0716E+01_JPRB,3.1684E+01_JPRB/)  
KAO( :, 1, 3,13) = (/&
 & 2.4631E+01_JPRB,2.1553E+01_JPRB,1.8474E+01_JPRB,1.5395E+01_JPRB,1.2316E+01_JPRB,9.8916E+00_JPRB,&
 & 1.0038E+01_JPRB,1.1089E+01_JPRB,1.4306E+01_JPRB/)  
KAO( :, 2, 3,13) = (/&
 & 3.3118E+01_JPRB,2.8978E+01_JPRB,2.4838E+01_JPRB,2.0699E+01_JPRB,1.6559E+01_JPRB,1.2452E+01_JPRB,&
 & 1.0491E+01_JPRB,1.1254E+01_JPRB,1.4773E+01_JPRB/)  
KAO( :, 3, 3,13) = (/&
 & 4.3194E+01_JPRB,3.7795E+01_JPRB,3.2396E+01_JPRB,2.6996E+01_JPRB,2.1597E+01_JPRB,1.6198E+01_JPRB,&
 & 1.1695E+01_JPRB,1.1459E+01_JPRB,1.5413E+01_JPRB/)  
KAO( :, 4, 3,13) = (/&
 & 5.4783E+01_JPRB,4.7935E+01_JPRB,4.1087E+01_JPRB,3.4239E+01_JPRB,2.7391E+01_JPRB,2.0543E+01_JPRB,&
 & 1.3845E+01_JPRB,1.1681E+01_JPRB,1.6296E+01_JPRB/)  
KAO( :, 5, 3,13) = (/&
 & 6.7780E+01_JPRB,5.9307E+01_JPRB,5.0835E+01_JPRB,4.2362E+01_JPRB,3.3890E+01_JPRB,2.5417E+01_JPRB,&
 & 1.6945E+01_JPRB,1.1890E+01_JPRB,1.7557E+01_JPRB/)  
KAO( :, 1, 4,13) = (/&
 & 1.9088E+01_JPRB,1.6702E+01_JPRB,1.4316E+01_JPRB,1.1930E+01_JPRB,1.0048E+01_JPRB,1.0234E+01_JPRB,&
 & 1.1609E+01_JPRB,1.2948E+01_JPRB,1.5443E+01_JPRB/)  
KAO( :, 2, 4,13) = (/&
 & 2.6468E+01_JPRB,2.3159E+01_JPRB,1.9851E+01_JPRB,1.6542E+01_JPRB,1.3234E+01_JPRB,1.1284E+01_JPRB,&
 & 1.1975E+01_JPRB,1.3181E+01_JPRB,1.5496E+01_JPRB/)  
KAO( :, 3, 4,13) = (/&
 & 3.5386E+01_JPRB,3.0963E+01_JPRB,2.6539E+01_JPRB,2.2116E+01_JPRB,1.7693E+01_JPRB,1.3581E+01_JPRB,&
 & 1.2366E+01_JPRB,1.3400E+01_JPRB,1.5533E+01_JPRB/)  
KAO( :, 4, 4,13) = (/&
 & 4.5721E+01_JPRB,4.0006E+01_JPRB,3.4291E+01_JPRB,2.8576E+01_JPRB,2.2861E+01_JPRB,1.7146E+01_JPRB,&
 & 1.3293E+01_JPRB,1.3609E+01_JPRB,1.5601E+01_JPRB/)  
KAO( :, 5, 4,13) = (/&
 & 5.7463E+01_JPRB,5.0280E+01_JPRB,4.3097E+01_JPRB,3.5914E+01_JPRB,2.8732E+01_JPRB,2.1549E+01_JPRB,&
 & 1.5088E+01_JPRB,1.3821E+01_JPRB,1.5706E+01_JPRB/)  
KAO( :, 1, 5,13) = (/&
 & 1.4426E+01_JPRB,1.2622E+01_JPRB,1.0819E+01_JPRB,9.3955E+00_JPRB,9.8959E+00_JPRB,1.1682E+01_JPRB,&
 & 1.3442E+01_JPRB,1.5150E+01_JPRB,1.7787E+01_JPRB/)  
KAO( :, 2, 5,13) = (/&
 & 2.0633E+01_JPRB,1.8054E+01_JPRB,1.5474E+01_JPRB,1.2895E+01_JPRB,1.1371E+01_JPRB,1.2152E+01_JPRB,&
 & 1.3795E+01_JPRB,1.5372E+01_JPRB,1.7817E+01_JPRB/)  
KAO( :, 3, 5,13) = (/&
 & 2.8181E+01_JPRB,2.4658E+01_JPRB,2.1135E+01_JPRB,1.7613E+01_JPRB,1.4271E+01_JPRB,1.3007E+01_JPRB,&
 & 1.4200E+01_JPRB,1.5591E+01_JPRB,1.7815E+01_JPRB/)  
KAO( :, 4, 5,13) = (/&
 & 3.7172E+01_JPRB,3.2526E+01_JPRB,2.7879E+01_JPRB,2.3233E+01_JPRB,1.8586E+01_JPRB,1.4927E+01_JPRB,&
 & 1.4654E+01_JPRB,1.5856E+01_JPRB,1.7795E+01_JPRB/)  
KAO( :, 5, 5,13) = (/&
 & 4.7583E+01_JPRB,4.1635E+01_JPRB,3.5687E+01_JPRB,2.9739E+01_JPRB,2.3791E+01_JPRB,1.8024E+01_JPRB,&
 & 1.5280E+01_JPRB,1.6121E+01_JPRB,1.7748E+01_JPRB/)  
KAO( :, 1, 6,13) = (/&
 & 1.0461E+01_JPRB,9.1530E+00_JPRB,8.0649E+00_JPRB,8.9595E+00_JPRB,1.1163E+01_JPRB,1.3388E+01_JPRB,&
 & 1.5529E+01_JPRB,1.7569E+01_JPRB,2.0564E+01_JPRB/)  
KAO( :, 2, 6,13) = (/&
 & 1.5391E+01_JPRB,1.3467E+01_JPRB,1.1543E+01_JPRB,1.0534E+01_JPRB,1.1753E+01_JPRB,1.3875E+01_JPRB,&
 & 1.5945E+01_JPRB,1.7834E+01_JPRB,2.0625E+01_JPRB/)  
KAO( :, 3, 6,13) = (/&
 & 2.1628E+01_JPRB,1.8924E+01_JPRB,1.6221E+01_JPRB,1.3622E+01_JPRB,1.2887E+01_JPRB,1.4422E+01_JPRB,&
 & 1.6374E+01_JPRB,1.8123E+01_JPRB,2.0643E+01_JPRB/)  
KAO( :, 4, 6,13) = (/&
 & 2.9247E+01_JPRB,2.5591E+01_JPRB,2.1935E+01_JPRB,1.8279E+01_JPRB,1.5333E+01_JPRB,1.5076E+01_JPRB,&
 & 1.6798E+01_JPRB,1.8415E+01_JPRB,2.0622E+01_JPRB/)  
KAO( :, 5, 6,13) = (/&
 & 3.8260E+01_JPRB,3.3478E+01_JPRB,2.8695E+01_JPRB,2.3913E+01_JPRB,1.9193E+01_JPRB,1.6572E+01_JPRB,&
 & 1.7244E+01_JPRB,1.8672E+01_JPRB,2.0568E+01_JPRB/)  
KAO( :, 1, 7,13) = (/&
 & 7.3043E+00_JPRB,6.3921E+00_JPRB,7.2574E+00_JPRB,9.9309E+00_JPRB,1.2660E+01_JPRB,1.5305E+01_JPRB,&
 & 1.7830E+01_JPRB,2.0388E+01_JPRB,2.3721E+01_JPRB/)  
KAO( :, 2, 7,13) = (/&
 & 1.1153E+01_JPRB,9.7589E+00_JPRB,8.9368E+00_JPRB,1.0556E+01_JPRB,1.3220E+01_JPRB,1.5825E+01_JPRB,&
 & 1.8263E+01_JPRB,2.0631E+01_JPRB,2.3818E+01_JPRB/)  
KAO( :, 3, 7,13) = (/&
 & 1.6186E+01_JPRB,1.4162E+01_JPRB,1.2167E+01_JPRB,1.1878E+01_JPRB,1.3854E+01_JPRB,1.6375E+01_JPRB,&
 & 1.8737E+01_JPRB,2.0904E+01_JPRB,2.3851E+01_JPRB/)  
KAO( :, 4, 7,13) = (/&
 & 2.2456E+01_JPRB,1.9649E+01_JPRB,1.6842E+01_JPRB,1.4587E+01_JPRB,1.4796E+01_JPRB,1.6968E+01_JPRB,&
 & 1.9249E+01_JPRB,2.1203E+01_JPRB,2.3842E+01_JPRB/)  
KAO( :, 5, 7,13) = (/&
 & 2.9970E+01_JPRB,2.6223E+01_JPRB,2.2477E+01_JPRB,1.8752E+01_JPRB,1.6763E+01_JPRB,1.7653E+01_JPRB,&
 & 1.9767E+01_JPRB,2.1542E+01_JPRB,2.3797E+01_JPRB/)  
KAO( :, 1, 8,13) = (/&
 & 4.9692E+00_JPRB,4.9125E+00_JPRB,7.9064E+00_JPRB,1.1184E+01_JPRB,1.4336E+01_JPRB,1.7379E+01_JPRB,&
 & 2.0369E+01_JPRB,2.3491E+01_JPRB,2.7234E+01_JPRB/)  
KAO( :, 2, 8,13) = (/&
 & 7.9016E+00_JPRB,6.9643E+00_JPRB,8.5289E+00_JPRB,1.1787E+01_JPRB,1.4948E+01_JPRB,1.7963E+01_JPRB,&
 & 2.0857E+01_JPRB,2.3626E+01_JPRB,2.7349E+01_JPRB/)  
KAO( :, 3, 8,13) = (/&
 & 1.1829E+01_JPRB,1.0351E+01_JPRB,1.0018E+01_JPRB,1.2473E+01_JPRB,1.5611E+01_JPRB,1.8590E+01_JPRB,&
 & 2.1391E+01_JPRB,2.3947E+01_JPRB,2.7404E+01_JPRB/)  
KAO( :, 4, 8,13) = (/&
 & 1.6837E+01_JPRB,1.4732E+01_JPRB,1.2874E+01_JPRB,1.3529E+01_JPRB,1.6319E+01_JPRB,1.9246E+01_JPRB,&
 & 2.1937E+01_JPRB,2.4318E+01_JPRB,2.7406E+01_JPRB/)  
KAO( :, 5, 8,13) = (/&
 & 2.2996E+01_JPRB,2.0122E+01_JPRB,1.7247E+01_JPRB,1.5765E+01_JPRB,1.7114E+01_JPRB,1.9918E+01_JPRB,&
 & 2.2479E+01_JPRB,2.4688E+01_JPRB,2.7359E+01_JPRB/)  
KAO( :, 1, 9,13) = (/&
 & 3.2797E+00_JPRB,4.8490E+00_JPRB,8.7424E+00_JPRB,1.2456E+01_JPRB,1.6073E+01_JPRB,1.9620E+01_JPRB,&
 & 2.3097E+01_JPRB,2.6808E+01_JPRB,3.0988E+01_JPRB/)  
KAO( :, 2, 9,13) = (/&
 & 5.4392E+00_JPRB,5.6637E+00_JPRB,9.3267E+00_JPRB,1.3100E+01_JPRB,1.6727E+01_JPRB,2.0234E+01_JPRB,&
 & 2.3592E+01_JPRB,2.6965E+01_JPRB,3.1144E+01_JPRB/)  
KAO( :, 3, 9,13) = (/&
 & 8.4169E+00_JPRB,7.5619E+00_JPRB,1.0020E+01_JPRB,1.3811E+01_JPRB,1.7436E+01_JPRB,2.0893E+01_JPRB,&
 & 2.4142E+01_JPRB,2.7260E+01_JPRB,3.1227E+01_JPRB/)  
KAO( :, 4, 9,13) = (/&
 & 1.2342E+01_JPRB,1.0800E+01_JPRB,1.1274E+01_JPRB,1.4589E+01_JPRB,1.8199E+01_JPRB,2.1593E+01_JPRB,&
 & 2.4734E+01_JPRB,2.7614E+01_JPRB,3.1244E+01_JPRB/)  
KAO( :, 5, 9,13) = (/&
 & 1.7292E+01_JPRB,1.5131E+01_JPRB,1.3759E+01_JPRB,1.5542E+01_JPRB,1.9006E+01_JPRB,2.2332E+01_JPRB,&
 & 2.5355E+01_JPRB,2.7981E+01_JPRB,3.1197E+01_JPRB/)  
KAO( :, 1,10,13) = (/&
 & 2.2032E+00_JPRB,5.2890E+00_JPRB,9.6706E+00_JPRB,1.3878E+01_JPRB,1.7966E+01_JPRB,2.1973E+01_JPRB,&
 & 2.5989E+01_JPRB,3.0314E+01_JPRB,3.4958E+01_JPRB/)  
KAO( :, 2,10,13) = (/&
 & 3.7831E+00_JPRB,5.7837E+00_JPRB,1.0292E+01_JPRB,1.4556E+01_JPRB,1.8648E+01_JPRB,2.2606E+01_JPRB,&
 & 2.6478E+01_JPRB,3.0484E+01_JPRB,3.5130E+01_JPRB/)  
KAO( :, 3,10,13) = (/&
 & 6.0546E+00_JPRB,6.6064E+00_JPRB,1.0987E+01_JPRB,1.5317E+01_JPRB,1.9415E+01_JPRB,2.3325E+01_JPRB,&
 & 2.7070E+01_JPRB,3.0679E+01_JPRB,3.5221E+01_JPRB/)  
KAO( :, 4,10,13) = (/&
 & 9.1249E+00_JPRB,8.4338E+00_JPRB,1.1767E+01_JPRB,1.6143E+01_JPRB,2.0247E+01_JPRB,2.4103E+01_JPRB,&
 & 2.7726E+01_JPRB,3.1040E+01_JPRB,3.5231E+01_JPRB/)  
KAO( :, 5,10,13) = (/&
 & 1.3052E+01_JPRB,1.1454E+01_JPRB,1.2877E+01_JPRB,1.7024E+01_JPRB,2.1124E+01_JPRB,2.4923E+01_JPRB,&
 & 2.8417E+01_JPRB,3.1455E+01_JPRB,3.5171E+01_JPRB/)  
KAO( :, 1,11,13) = (/&
 & 1.9086E+00_JPRB,5.9459E+00_JPRB,1.0873E+01_JPRB,1.5591E+01_JPRB,2.0164E+01_JPRB,2.4670E+01_JPRB,&
 & 2.9154E+01_JPRB,3.3957E+01_JPRB,3.9072E+01_JPRB/)  
KAO( :, 2,11,13) = (/&
 & 3.2952E+00_JPRB,6.4851E+00_JPRB,1.1554E+01_JPRB,1.6337E+01_JPRB,2.0921E+01_JPRB,2.5369E+01_JPRB,&
 & 2.9685E+01_JPRB,3.4092E+01_JPRB,3.9214E+01_JPRB/)  
KAO( :, 3,11,13) = (/&
 & 5.2771E+00_JPRB,7.1279E+00_JPRB,1.2325E+01_JPRB,1.7170E+01_JPRB,2.1762E+01_JPRB,2.6155E+01_JPRB,&
 & 3.0331E+01_JPRB,3.4338E+01_JPRB,3.9267E+01_JPRB/)  
KAO( :, 4,11,13) = (/&
 & 7.9532E+00_JPRB,8.2986E+00_JPRB,1.3169E+01_JPRB,1.8082E+01_JPRB,2.2666E+01_JPRB,2.6993E+01_JPRB,&
 & 3.1034E+01_JPRB,3.4728E+01_JPRB,3.9232E+01_JPRB/)  
KAO( :, 5,11,13) = (/&
 & 1.1408E+01_JPRB,1.0479E+01_JPRB,1.4101E+01_JPRB,1.9050E+01_JPRB,2.3632E+01_JPRB,2.7870E+01_JPRB,&
 & 3.1762E+01_JPRB,3.5164E+01_JPRB,3.9117E+01_JPRB/)  
KAO( :, 1,12,13) = (/&
 & 1.6495E+00_JPRB,6.5961E+00_JPRB,1.2057E+01_JPRB,1.7278E+01_JPRB,2.2356E+01_JPRB,2.7342E+01_JPRB,&
 & 3.2267E+01_JPRB,3.7500E+01_JPRB,4.3085E+01_JPRB/)  
KAO( :, 2,12,13) = (/&
 & 2.8452E+00_JPRB,7.1855E+00_JPRB,1.2796E+01_JPRB,1.8080E+01_JPRB,2.3168E+01_JPRB,2.8094E+01_JPRB,&
 & 3.2847E+01_JPRB,3.7597E+01_JPRB,4.3183E+01_JPRB/)  
KAO( :, 3,12,13) = (/&
 & 4.5627E+00_JPRB,7.8617E+00_JPRB,1.3635E+01_JPRB,1.8987E+01_JPRB,2.4069E+01_JPRB,2.8923E+01_JPRB,&
 & 3.3529E+01_JPRB,3.7904E+01_JPRB,4.3185E+01_JPRB/)  
KAO( :, 4,12,13) = (/&
 & 6.8882E+00_JPRB,8.6791E+00_JPRB,1.4557E+01_JPRB,1.9976E+01_JPRB,2.5052E+01_JPRB,2.9817E+01_JPRB,&
 & 3.4260E+01_JPRB,3.8316E+01_JPRB,4.3097E+01_JPRB/)  
KAO( :, 5,12,13) = (/&
 & 9.8701E+00_JPRB,1.0128E+01_JPRB,1.5550E+01_JPRB,2.1028E+01_JPRB,2.6084E+01_JPRB,3.0768E+01_JPRB,&
 & 3.5030E+01_JPRB,3.8758E+01_JPRB,4.2923E+01_JPRB/)  
KAO( :, 1,13,13) = (/&
 & 1.4102E+00_JPRB,7.2101E+00_JPRB,1.3161E+01_JPRB,1.8856E+01_JPRB,2.4405E+01_JPRB,2.9839E+01_JPRB,&
 & 3.5177E+01_JPRB,4.0784E+01_JPRB,4.6821E+01_JPRB/)  
KAO( :, 2,13,13) = (/&
 & 2.4382E+00_JPRB,7.8482E+00_JPRB,1.3963E+01_JPRB,1.9729E+01_JPRB,2.5265E+01_JPRB,3.0620E+01_JPRB,&
 & 3.5779E+01_JPRB,4.0841E+01_JPRB,4.6845E+01_JPRB/)  
KAO( :, 3,13,13) = (/&
 & 3.9130E+00_JPRB,8.5783E+00_JPRB,1.4859E+01_JPRB,2.0699E+01_JPRB,2.6235E+01_JPRB,3.1498E+01_JPRB,&
 & 3.6480E+01_JPRB,4.1163E+01_JPRB,4.6764E+01_JPRB/)  
KAO( :, 4,13,13) = (/&
 & 5.9062E+00_JPRB,9.3898E+00_JPRB,1.5851E+01_JPRB,2.1749E+01_JPRB,2.7273E+01_JPRB,3.2456E+01_JPRB,&
 & 3.7253E+01_JPRB,4.1590E+01_JPRB,4.6596E+01_JPRB/)  
KAO( :, 5,13,13) = (/&
 & 8.4798E+00_JPRB,1.0367E+01_JPRB,1.6908E+01_JPRB,2.2869E+01_JPRB,2.8363E+01_JPRB,3.3450E+01_JPRB,&
 & 3.8074E+01_JPRB,4.2068E+01_JPRB,4.6355E+01_JPRB/)  
KAO( :, 1, 1,14) = (/&
 & 6.5174E+01_JPRB,5.7027E+01_JPRB,4.8880E+01_JPRB,4.0734E+01_JPRB,3.2587E+01_JPRB,2.4440E+01_JPRB,&
 & 1.6293E+01_JPRB,9.0902E+00_JPRB,3.6845E+01_JPRB/)  
KAO( :, 2, 1,14) = (/&
 & 8.4423E+01_JPRB,7.3870E+01_JPRB,6.3317E+01_JPRB,5.2765E+01_JPRB,4.2212E+01_JPRB,3.1659E+01_JPRB,&
 & 2.1106E+01_JPRB,1.0672E+01_JPRB,4.1742E+01_JPRB/)  
KAO( :, 3, 1,14) = (/&
 & 1.0604E+02_JPRB,9.2788E+01_JPRB,7.9533E+01_JPRB,6.6277E+01_JPRB,5.3022E+01_JPRB,3.9766E+01_JPRB,&
 & 2.6511E+01_JPRB,1.3255E+01_JPRB,4.6647E+01_JPRB/)  
KAO( :, 4, 1,14) = (/&
 & 1.3020E+02_JPRB,1.1393E+02_JPRB,9.7651E+01_JPRB,8.1376E+01_JPRB,6.5100E+01_JPRB,4.8825E+01_JPRB,&
 & 3.2550E+01_JPRB,1.6275E+01_JPRB,5.1511E+01_JPRB/)  
KAO( :, 5, 1,14) = (/&
 & 1.5659E+02_JPRB,1.3701E+02_JPRB,1.1744E+02_JPRB,9.7867E+01_JPRB,7.8294E+01_JPRB,5.8720E+01_JPRB,&
 & 3.9147E+01_JPRB,1.9573E+01_JPRB,5.6274E+01_JPRB/)  
KAO( :, 1, 2,14) = (/&
 & 6.1823E+01_JPRB,5.4095E+01_JPRB,4.6367E+01_JPRB,3.8639E+01_JPRB,3.0911E+01_JPRB,2.3183E+01_JPRB,&
 & 1.5456E+01_JPRB,1.0277E+01_JPRB,2.7318E+01_JPRB/)  
KAO( :, 2, 2,14) = (/&
 & 8.1223E+01_JPRB,7.1070E+01_JPRB,6.0917E+01_JPRB,5.0764E+01_JPRB,4.0612E+01_JPRB,3.0459E+01_JPRB,&
 & 2.0306E+01_JPRB,1.1162E+01_JPRB,3.1010E+01_JPRB/)  
KAO( :, 3, 2,14) = (/&
 & 1.0367E+02_JPRB,9.0711E+01_JPRB,7.7752E+01_JPRB,6.4794E+01_JPRB,5.1835E+01_JPRB,3.8876E+01_JPRB,&
 & 2.5917E+01_JPRB,1.3111E+01_JPRB,3.4709E+01_JPRB/)  
KAO( :, 4, 2,14) = (/&
 & 1.2892E+02_JPRB,1.1280E+02_JPRB,9.6686E+01_JPRB,8.0572E+01_JPRB,6.4458E+01_JPRB,4.8343E+01_JPRB,&
 & 3.2229E+01_JPRB,1.6114E+01_JPRB,3.8368E+01_JPRB/)  
KAO( :, 5, 2,14) = (/&
 & 1.5667E+02_JPRB,1.3708E+02_JPRB,1.1750E+02_JPRB,9.7916E+01_JPRB,7.8333E+01_JPRB,5.8750E+01_JPRB,&
 & 3.9167E+01_JPRB,1.9583E+01_JPRB,4.1940E+01_JPRB/)  
KAO( :, 1, 3,14) = (/&
 & 5.4340E+01_JPRB,4.7547E+01_JPRB,4.0755E+01_JPRB,3.3962E+01_JPRB,2.7170E+01_JPRB,2.0377E+01_JPRB,&
 & 1.3826E+01_JPRB,1.1988E+01_JPRB,1.6208E+01_JPRB/)  
KAO( :, 2, 3,14) = (/&
 & 7.3213E+01_JPRB,6.4061E+01_JPRB,5.4910E+01_JPRB,4.5758E+01_JPRB,3.6606E+01_JPRB,2.7455E+01_JPRB,&
 & 1.8303E+01_JPRB,1.2321E+01_JPRB,1.7853E+01_JPRB/)  
KAO( :, 3, 3,14) = (/&
 & 9.5330E+01_JPRB,8.3414E+01_JPRB,7.1498E+01_JPRB,5.9581E+01_JPRB,4.7665E+01_JPRB,3.5749E+01_JPRB,&
 & 2.3833E+01_JPRB,1.3383E+01_JPRB,1.9735E+01_JPRB/)  
KAO( :, 4, 3,14) = (/&
 & 1.2051E+02_JPRB,1.0545E+02_JPRB,9.0386E+01_JPRB,7.5322E+01_JPRB,6.0257E+01_JPRB,4.5193E+01_JPRB,&
 & 3.0129E+01_JPRB,1.5439E+01_JPRB,2.1688E+01_JPRB/)  
KAO( :, 5, 3,14) = (/&
 & 1.4852E+02_JPRB,1.2996E+02_JPRB,1.1139E+02_JPRB,9.2828E+01_JPRB,7.4262E+01_JPRB,5.5697E+01_JPRB,&
 & 3.7131E+01_JPRB,1.8572E+01_JPRB,2.3613E+01_JPRB/)  
KAO( :, 1, 4,14) = (/&
 & 4.5833E+01_JPRB,4.0104E+01_JPRB,3.4375E+01_JPRB,2.8646E+01_JPRB,2.2917E+01_JPRB,1.7188E+01_JPRB,&
 & 1.3524E+01_JPRB,1.4143E+01_JPRB,1.6776E+01_JPRB/)  
KAO( :, 2, 4,14) = (/&
 & 6.3459E+01_JPRB,5.5527E+01_JPRB,4.7594E+01_JPRB,3.9662E+01_JPRB,3.1730E+01_JPRB,2.3797E+01_JPRB,&
 & 1.6331E+01_JPRB,1.4451E+01_JPRB,1.6850E+01_JPRB/)  
KAO( :, 3, 4,14) = (/&
 & 8.4502E+01_JPRB,7.3939E+01_JPRB,6.3376E+01_JPRB,5.2814E+01_JPRB,4.2251E+01_JPRB,3.1688E+01_JPRB,&
 & 2.1126E+01_JPRB,1.4779E+01_JPRB,1.6907E+01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART9',1,ZHOOK_HANDLE)
END SUBROUTINE PART9


SUBROUTINE PART10

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART10',0,ZHOOK_HANDLE)


KAO( :, 4, 4,14) = (/&
 & 1.0912E+02_JPRB,9.5484E+01_JPRB,8.1843E+01_JPRB,6.8203E+01_JPRB,5.4562E+01_JPRB,4.0922E+01_JPRB,&
 & 2.7281E+01_JPRB,1.5904E+01_JPRB,1.6987E+01_JPRB/)  
KAO( :, 5, 4,14) = (/&
 & 1.3712E+02_JPRB,1.1998E+02_JPRB,1.0284E+02_JPRB,8.5701E+01_JPRB,6.8561E+01_JPRB,5.1421E+01_JPRB,&
 & 3.4281E+01_JPRB,1.8042E+01_JPRB,1.7134E+01_JPRB/)  
KAO( :, 1, 5,14) = (/&
 & 3.7621E+01_JPRB,3.2918E+01_JPRB,2.8216E+01_JPRB,2.3513E+01_JPRB,1.8810E+01_JPRB,1.5213E+01_JPRB,&
 & 1.4972E+01_JPRB,1.6713E+01_JPRB,1.9607E+01_JPRB/)  
KAO( :, 2, 5,14) = (/&
 & 5.3640E+01_JPRB,4.6935E+01_JPRB,4.0230E+01_JPRB,3.3525E+01_JPRB,2.6820E+01_JPRB,2.0195E+01_JPRB,&
 & 1.6296E+01_JPRB,1.6983E+01_JPRB,1.9709E+01_JPRB/)  
KAO( :, 3, 5,14) = (/&
 & 7.3434E+01_JPRB,6.4254E+01_JPRB,5.5075E+01_JPRB,4.5896E+01_JPRB,3.6717E+01_JPRB,2.7538E+01_JPRB,&
 & 1.9356E+01_JPRB,1.7364E+01_JPRB,1.9752E+01_JPRB/)  
KAO( :, 4, 5,14) = (/&
 & 9.6831E+01_JPRB,8.4727E+01_JPRB,7.2623E+01_JPRB,6.0519E+01_JPRB,4.8415E+01_JPRB,3.6311E+01_JPRB,&
 & 2.4262E+01_JPRB,1.7815E+01_JPRB,1.9747E+01_JPRB/)  
KAO( :, 5, 5,14) = (/&
 & 1.2364E+02_JPRB,1.0818E+02_JPRB,9.2728E+01_JPRB,7.7274E+01_JPRB,6.1819E+01_JPRB,4.6364E+01_JPRB,&
 & 3.0909E+01_JPRB,1.8880E+01_JPRB,1.9719E+01_JPRB/)  
KAO( :, 1, 6,14) = (/&
 & 2.9612E+01_JPRB,2.5911E+01_JPRB,2.2209E+01_JPRB,1.8508E+01_JPRB,1.5714E+01_JPRB,1.5485E+01_JPRB,&
 & 1.7513E+01_JPRB,1.9803E+01_JPRB,2.3106E+01_JPRB/)  
KAO( :, 2, 6,14) = (/&
 & 4.3748E+01_JPRB,3.8279E+01_JPRB,3.2811E+01_JPRB,2.7342E+01_JPRB,2.1877E+01_JPRB,1.8205E+01_JPRB,&
 & 1.8101E+01_JPRB,2.0115E+01_JPRB,2.3246E+01_JPRB/)  
KAO( :, 3, 6,14) = (/&
 & 6.1468E+01_JPRB,5.3784E+01_JPRB,4.6101E+01_JPRB,3.8417E+01_JPRB,3.0734E+01_JPRB,2.3328E+01_JPRB,&
 & 1.9453E+01_JPRB,2.0483E+01_JPRB,2.3324E+01_JPRB/)  
KAO( :, 4, 6,14) = (/&
 & 8.2819E+01_JPRB,7.2467E+01_JPRB,6.2114E+01_JPRB,5.1762E+01_JPRB,4.1410E+01_JPRB,3.1057E+01_JPRB,&
 & 2.2516E+01_JPRB,2.0832E+01_JPRB,2.3358E+01_JPRB/)  
KAO( :, 5, 6,14) = (/&
 & 1.0782E+02_JPRB,9.4345E+01_JPRB,8.0867E+01_JPRB,6.7389E+01_JPRB,5.3911E+01_JPRB,4.0434E+01_JPRB,&
 & 2.7416E+01_JPRB,2.1303E+01_JPRB,2.3341E+01_JPRB/)  
KAO( :, 1, 7,14) = (/&
 & 2.2563E+01_JPRB,1.9743E+01_JPRB,1.6922E+01_JPRB,1.4880E+01_JPRB,1.5210E+01_JPRB,1.7595E+01_JPRB,&
 & 2.0450E+01_JPRB,2.3517E+01_JPRB,2.7272E+01_JPRB/)  
KAO( :, 2, 7,14) = (/&
 & 3.4511E+01_JPRB,3.0197E+01_JPRB,2.5883E+01_JPRB,2.1569E+01_JPRB,1.8701E+01_JPRB,1.8664E+01_JPRB,&
 & 2.1070E+01_JPRB,2.3724E+01_JPRB,2.7469E+01_JPRB/)  
KAO( :, 3, 7,14) = (/&
 & 4.9903E+01_JPRB,4.3665E+01_JPRB,3.7427E+01_JPRB,3.1189E+01_JPRB,2.5108E+01_JPRB,2.1510E+01_JPRB,&
 & 2.1786E+01_JPRB,2.4110E+01_JPRB,2.7600E+01_JPRB/)  
KAO( :, 4, 7,14) = (/&
 & 6.8998E+01_JPRB,6.0373E+01_JPRB,5.1749E+01_JPRB,4.3124E+01_JPRB,3.4499E+01_JPRB,2.6735E+01_JPRB,&
 & 2.3147E+01_JPRB,2.4558E+01_JPRB,2.7662E+01_JPRB/)  
KAO( :, 5, 7,14) = (/&
 & 9.2035E+01_JPRB,8.0530E+01_JPRB,6.9026E+01_JPRB,5.7522E+01_JPRB,4.6017E+01_JPRB,3.4527E+01_JPRB,&
 & 2.6142E+01_JPRB,2.5028E+01_JPRB,2.7662E+01_JPRB/)  
KAO( :, 1, 8,14) = (/&
 & 1.6646E+01_JPRB,1.4565E+01_JPRB,1.2937E+01_JPRB,1.3876E+01_JPRB,1.6955E+01_JPRB,2.0502E+01_JPRB,&
 & 2.4054E+01_JPRB,2.7834E+01_JPRB,3.2161E+01_JPRB/)  
KAO( :, 2, 8,14) = (/&
 & 2.6448E+01_JPRB,2.3142E+01_JPRB,1.9836E+01_JPRB,1.7715E+01_JPRB,1.8335E+01_JPRB,2.1296E+01_JPRB,&
 & 2.4653E+01_JPRB,2.8077E+01_JPRB,3.2424E+01_JPRB/)  
KAO( :, 3, 8,14) = (/&
 & 3.9552E+01_JPRB,3.4608E+01_JPRB,2.9664E+01_JPRB,2.4793E+01_JPRB,2.2053E+01_JPRB,2.2399E+01_JPRB,&
 & 2.5322E+01_JPRB,2.8464E+01_JPRB,3.2607E+01_JPRB/)  
KAO( :, 4, 8,14) = (/&
 & 5.6374E+01_JPRB,4.9327E+01_JPRB,4.2280E+01_JPRB,3.5233E+01_JPRB,2.8686E+01_JPRB,2.5344E+01_JPRB,&
 & 2.6090E+01_JPRB,2.8900E+01_JPRB,3.2702E+01_JPRB/)  
KAO( :, 5, 8,14) = (/&
 & 7.7053E+01_JPRB,6.7421E+01_JPRB,5.7790E+01_JPRB,4.8158E+01_JPRB,3.8527E+01_JPRB,3.0635E+01_JPRB,&
 & 2.7529E+01_JPRB,2.9328E+01_JPRB,3.2729E+01_JPRB/)  
KAO( :, 1, 9,14) = (/&
 & 1.1833E+01_JPRB,1.0384E+01_JPRB,1.1459E+01_JPRB,1.5199E+01_JPRB,1.9504E+01_JPRB,2.3789E+01_JPRB,&
 & 2.8102E+01_JPRB,3.2786E+01_JPRB,3.7785E+01_JPRB/)  
KAO( :, 2, 9,14) = (/&
 & 1.9655E+01_JPRB,1.7198E+01_JPRB,1.5507E+01_JPRB,1.6804E+01_JPRB,2.0431E+01_JPRB,2.4589E+01_JPRB,&
 & 2.8753E+01_JPRB,3.3108E+01_JPRB,3.8143E+01_JPRB/)  
KAO( :, 3, 9,14) = (/&
 & 3.0574E+01_JPRB,2.6753E+01_JPRB,2.2935E+01_JPRB,2.1004E+01_JPRB,2.2051E+01_JPRB,2.5542E+01_JPRB,&
 & 2.9510E+01_JPRB,3.3363E+01_JPRB,3.8391E+01_JPRB/)  
KAO( :, 4, 9,14) = (/&
 & 4.4893E+01_JPRB,3.9281E+01_JPRB,3.3669E+01_JPRB,2.8405E+01_JPRB,2.5980E+01_JPRB,2.6856E+01_JPRB,&
 & 3.0337E+01_JPRB,3.3859E+01_JPRB,3.8531E+01_JPRB/)  
KAO( :, 5, 9,14) = (/&
 & 6.2714E+01_JPRB,5.4875E+01_JPRB,4.7035E+01_JPRB,3.9196E+01_JPRB,3.2630E+01_JPRB,2.9798E+01_JPRB,&
 & 3.1253E+01_JPRB,3.4423E+01_JPRB,3.8580E+01_JPRB/)  
KAO( :, 1,10,14) = (/&
 & 8.5124E+00_JPRB,8.2727E+00_JPRB,1.2161E+01_JPRB,1.7400E+01_JPRB,2.2620E+01_JPRB,2.7747E+01_JPRB,&
 & 3.2952E+01_JPRB,3.8443E+01_JPRB,4.4221E+01_JPRB/)  
KAO( :, 2,10,14) = (/&
 & 1.4801E+01_JPRB,1.2999E+01_JPRB,1.4181E+01_JPRB,1.8385E+01_JPRB,2.3543E+01_JPRB,2.8614E+01_JPRB,&
 & 3.3590E+01_JPRB,3.8847E+01_JPRB,4.4675E+01_JPRB/)  
KAO( :, 3,10,14) = (/&
 & 2.3770E+01_JPRB,2.0799E+01_JPRB,1.8887E+01_JPRB,2.0455E+01_JPRB,2.4642E+01_JPRB,2.9573E+01_JPRB,&
 & 3.4392E+01_JPRB,3.9131E+01_JPRB,4.4994E+01_JPRB/)  
KAO( :, 4,10,14) = (/&
 & 3.5762E+01_JPRB,3.1292E+01_JPRB,2.6896E+01_JPRB,2.5061E+01_JPRB,2.6502E+01_JPRB,3.0662E+01_JPRB,&
 & 3.5247E+01_JPRB,3.9648E+01_JPRB,4.5184E+01_JPRB/)  
KAO( :, 5,10,14) = (/&
 & 5.1160E+01_JPRB,4.4765E+01_JPRB,3.8370E+01_JPRB,3.2741E+01_JPRB,3.0611E+01_JPRB,3.2021E+01_JPRB,&
 & 3.6131E+01_JPRB,4.0213E+01_JPRB,4.5252E+01_JPRB/)  
KAO( :, 1,11,14) = (/&
 & 7.9777E+00_JPRB,8.7265E+00_JPRB,1.4218E+01_JPRB,2.0419E+01_JPRB,2.6536E+01_JPRB,3.2537E+01_JPRB,&
 & 3.8615E+01_JPRB,4.5051E+01_JPRB,5.1748E+01_JPRB/)  
KAO( :, 2,11,14) = (/&
 & 1.3839E+01_JPRB,1.2575E+01_JPRB,1.5679E+01_JPRB,2.1487E+01_JPRB,2.7590E+01_JPRB,3.3521E+01_JPRB,&
 & 3.9346E+01_JPRB,4.5471E+01_JPRB,5.2220E+01_JPRB/)  
KAO( :, 3,11,14) = (/&
 & 2.2213E+01_JPRB,1.9436E+01_JPRB,1.9340E+01_JPRB,2.2978E+01_JPRB,2.8775E+01_JPRB,3.4623E+01_JPRB,&
 & 4.0260E+01_JPRB,4.5752E+01_JPRB,5.2534E+01_JPRB/)  
KAO( :, 4,11,14) = (/&
 & 3.3533E+01_JPRB,2.9341E+01_JPRB,2.5981E+01_JPRB,2.6492E+01_JPRB,3.0190E+01_JPRB,3.5801E+01_JPRB,&
 & 4.1239E+01_JPRB,4.6338E+01_JPRB,5.2703E+01_JPRB/)  
KAO( :, 5,11,14) = (/&
 & 4.8125E+01_JPRB,4.2109E+01_JPRB,3.6128E+01_JPRB,3.2789E+01_JPRB,3.3249E+01_JPRB,3.7092E+01_JPRB,&
 & 4.2227E+01_JPRB,4.6984E+01_JPRB,5.2733E+01_JPRB/)  
KAO( :, 1,12,14) = (/&
 & 7.3404E+00_JPRB,9.4591E+00_JPRB,1.6537E+01_JPRB,2.3797E+01_JPRB,3.0901E+01_JPRB,3.7866E+01_JPRB,&
 & 4.4903E+01_JPRB,5.2386E+01_JPRB,6.0116E+01_JPRB/)  
KAO( :, 2,12,14) = (/&
 & 1.2760E+01_JPRB,1.2502E+01_JPRB,1.7728E+01_JPRB,2.4979E+01_JPRB,3.2095E+01_JPRB,3.8976E+01_JPRB,&
 & 4.5735E+01_JPRB,5.2811E+01_JPRB,6.0596E+01_JPRB/)  
KAO( :, 3,12,14) = (/&
 & 2.0574E+01_JPRB,1.8262E+01_JPRB,2.0491E+01_JPRB,2.6348E+01_JPRB,3.3404E+01_JPRB,4.0219E+01_JPRB,&
 & 4.6757E+01_JPRB,5.3073E+01_JPRB,6.0869E+01_JPRB/)  
KAO( :, 4,12,14) = (/&
 & 3.1115E+01_JPRB,2.7226E+01_JPRB,2.5855E+01_JPRB,2.8871E+01_JPRB,3.4864E+01_JPRB,4.1538E+01_JPRB,&
 & 4.7864E+01_JPRB,5.3711E+01_JPRB,6.0982E+01_JPRB/)  
KAO( :, 5,12,14) = (/&
 & 4.4619E+01_JPRB,3.9042E+01_JPRB,3.4233E+01_JPRB,3.3732E+01_JPRB,3.6915E+01_JPRB,4.2904E+01_JPRB,&
 & 4.8966E+01_JPRB,5.4437E+01_JPRB,6.0955E+01_JPRB/)  
KAO( :, 1,13,14) = (/&
 & 6.6733E+00_JPRB,1.0528E+01_JPRB,1.9102E+01_JPRB,2.7491E+01_JPRB,3.5658E+01_JPRB,4.3660E+01_JPRB,&
 & 5.1735E+01_JPRB,6.0358E+01_JPRB,6.9219E+01_JPRB/)  
KAO( :, 2,13,14) = (/&
 & 1.1655E+01_JPRB,1.2870E+01_JPRB,2.0329E+01_JPRB,2.8808E+01_JPRB,3.6997E+01_JPRB,4.4910E+01_JPRB,&
 & 5.2656E+01_JPRB,6.0744E+01_JPRB,6.9651E+01_JPRB/)  
KAO( :, 3,13,14) = (/&
 & 1.8767E+01_JPRB,1.7501E+01_JPRB,2.2287E+01_JPRB,3.0262E+01_JPRB,3.8454E+01_JPRB,4.6291E+01_JPRB,&
 & 5.3806E+01_JPRB,6.1028E+01_JPRB,6.9886E+01_JPRB/)  
KAO( :, 4,13,14) = (/&
 & 2.8382E+01_JPRB,2.4995E+01_JPRB,2.6394E+01_JPRB,3.2078E+01_JPRB,4.0012E+01_JPRB,4.7748E+01_JPRB,&
 & 5.5029E+01_JPRB,6.1702E+01_JPRB,6.9938E+01_JPRB/)  
KAO( :, 5,13,14) = (/&
 & 4.0772E+01_JPRB,3.5676E+01_JPRB,3.3182E+01_JPRB,3.5686E+01_JPRB,4.1712E+01_JPRB,4.9244E+01_JPRB,&
 & 5.6238E+01_JPRB,6.2475E+01_JPRB,6.9819E+01_JPRB/)  
KAO( :, 1, 1,15) = (/&
 & 1.1094E+02_JPRB,9.7072E+01_JPRB,8.3204E+01_JPRB,6.9337E+01_JPRB,5.5470E+01_JPRB,4.1602E+01_JPRB,&
 & 2.7735E+01_JPRB,1.3867E+01_JPRB,4.4845E+01_JPRB/)  
KAO( :, 2, 1,15) = (/&
 & 1.4352E+02_JPRB,1.2558E+02_JPRB,1.0764E+02_JPRB,8.9703E+01_JPRB,7.1762E+01_JPRB,5.3822E+01_JPRB,&
 & 3.5881E+01_JPRB,1.7941E+01_JPRB,5.0973E+01_JPRB/)  
KAO( :, 3, 1,15) = (/&
 & 1.8038E+02_JPRB,1.5783E+02_JPRB,1.3528E+02_JPRB,1.1274E+02_JPRB,9.0189E+01_JPRB,6.7642E+01_JPRB,&
 & 4.5094E+01_JPRB,2.2547E+01_JPRB,5.7040E+01_JPRB/)  
KAO( :, 4, 1,15) = (/&
 & 2.2134E+02_JPRB,1.9367E+02_JPRB,1.6600E+02_JPRB,1.3834E+02_JPRB,1.1067E+02_JPRB,8.3002E+01_JPRB,&
 & 5.5334E+01_JPRB,2.7667E+01_JPRB,6.3000E+01_JPRB/)  
KAO( :, 5, 1,15) = (/&
 & 2.6568E+02_JPRB,2.3247E+02_JPRB,1.9926E+02_JPRB,1.6605E+02_JPRB,1.3284E+02_JPRB,9.9630E+01_JPRB,&
 & 6.6420E+01_JPRB,3.3210E+01_JPRB,6.8855E+01_JPRB/)  
KAO( :, 1, 2,15) = (/&
 & 1.1363E+02_JPRB,9.9422E+01_JPRB,8.5219E+01_JPRB,7.1016E+01_JPRB,5.6813E+01_JPRB,4.2609E+01_JPRB,&
 & 2.8406E+01_JPRB,1.4203E+01_JPRB,3.3096E+01_JPRB/)  
KAO( :, 2, 2,15) = (/&
 & 1.4930E+02_JPRB,1.3064E+02_JPRB,1.1197E+02_JPRB,9.3312E+01_JPRB,7.4650E+01_JPRB,5.5987E+01_JPRB,&
 & 3.7325E+01_JPRB,1.8662E+01_JPRB,3.7888E+01_JPRB/)  
KAO( :, 3, 2,15) = (/&
 & 1.9010E+02_JPRB,1.6634E+02_JPRB,1.4258E+02_JPRB,1.1881E+02_JPRB,9.5050E+01_JPRB,7.1288E+01_JPRB,&
 & 4.7525E+01_JPRB,2.3763E+01_JPRB,4.2686E+01_JPRB/)  
KAO( :, 4, 2,15) = (/&
 & 2.3571E+02_JPRB,2.0625E+02_JPRB,1.7678E+02_JPRB,1.4732E+02_JPRB,1.1785E+02_JPRB,8.8391E+01_JPRB,&
 & 5.8927E+01_JPRB,2.9464E+01_JPRB,4.7440E+01_JPRB/)  
KAO( :, 5, 2,15) = (/&
 & 2.8549E+02_JPRB,2.4980E+02_JPRB,2.1412E+02_JPRB,1.7843E+02_JPRB,1.4274E+02_JPRB,1.0706E+02_JPRB,&
 & 7.1372E+01_JPRB,3.5686E+01_JPRB,5.2117E+01_JPRB/)  
KAO( :, 1, 3,15) = (/&
 & 1.0870E+02_JPRB,9.5115E+01_JPRB,8.1527E+01_JPRB,6.7939E+01_JPRB,5.4352E+01_JPRB,4.0764E+01_JPRB,&
 & 2.7176E+01_JPRB,1.4092E+01_JPRB,1.9358E+01_JPRB/)  
KAO( :, 2, 3,15) = (/&
 & 1.4594E+02_JPRB,1.2770E+02_JPRB,1.0946E+02_JPRB,9.1215E+01_JPRB,7.2972E+01_JPRB,5.4729E+01_JPRB,&
 & 3.6486E+01_JPRB,1.8243E+01_JPRB,2.1671E+01_JPRB/)  
KAO( :, 3, 3,15) = (/&
 & 1.8927E+02_JPRB,1.6561E+02_JPRB,1.4196E+02_JPRB,1.1830E+02_JPRB,9.4637E+01_JPRB,7.0978E+01_JPRB,&
 & 4.7319E+01_JPRB,2.3659E+01_JPRB,2.4176E+01_JPRB/)  
KAO( :, 4, 3,15) = (/&
 & 2.3825E+02_JPRB,2.0847E+02_JPRB,1.7869E+02_JPRB,1.4891E+02_JPRB,1.1913E+02_JPRB,8.9345E+01_JPRB,&
 & 5.9563E+01_JPRB,2.9782E+01_JPRB,2.6798E+01_JPRB/)  
KAO( :, 5, 3,15) = (/&
 & 2.9226E+02_JPRB,2.5573E+02_JPRB,2.1920E+02_JPRB,1.8266E+02_JPRB,1.4613E+02_JPRB,1.0960E+02_JPRB,&
 & 7.3065E+01_JPRB,3.6533E+01_JPRB,2.9446E+01_JPRB/)  
KAO( :, 1, 4,15) = (/&
 & 1.0014E+02_JPRB,8.7619E+01_JPRB,7.5102E+01_JPRB,6.2585E+01_JPRB,5.0068E+01_JPRB,3.7551E+01_JPRB,&
 & 2.5034E+01_JPRB,1.5422E+01_JPRB,1.8003E+01_JPRB/)  
KAO( :, 2, 4,15) = (/&
 & 1.3789E+02_JPRB,1.2065E+02_JPRB,1.0342E+02_JPRB,8.6180E+01_JPRB,6.8944E+01_JPRB,5.1708E+01_JPRB,&
 & 3.4472E+01_JPRB,1.7683E+01_JPRB,1.8158E+01_JPRB/)  
KAO( :, 3, 4,15) = (/&
 & 1.8258E+02_JPRB,1.5976E+02_JPRB,1.3693E+02_JPRB,1.1411E+02_JPRB,9.1289E+01_JPRB,6.8467E+01_JPRB,&
 & 4.5645E+01_JPRB,2.2822E+01_JPRB,1.8280E+01_JPRB/)  
KAO( :, 4, 4,15) = (/&
 & 2.3380E+02_JPRB,2.0458E+02_JPRB,1.7535E+02_JPRB,1.4613E+02_JPRB,1.1690E+02_JPRB,8.7677E+01_JPRB,&
 & 5.8451E+01_JPRB,2.9226E+01_JPRB,1.8394E+01_JPRB/)  
KAO( :, 5, 4,15) = (/&
 & 2.9132E+02_JPRB,2.5490E+02_JPRB,2.1849E+02_JPRB,1.8207E+02_JPRB,1.4566E+02_JPRB,1.0924E+02_JPRB,&
 & 7.2830E+01_JPRB,3.6415E+01_JPRB,1.8697E+01_JPRB/)  
KAO( :, 1, 5,15) = (/&
 & 9.0165E+01_JPRB,7.8895E+01_JPRB,6.7624E+01_JPRB,5.6353E+01_JPRB,4.5083E+01_JPRB,3.3812E+01_JPRB,&
 & 2.2547E+01_JPRB,1.8028E+01_JPRB,2.1110E+01_JPRB/)  
KAO( :, 2, 5,15) = (/&
 & 1.2751E+02_JPRB,1.1157E+02_JPRB,9.5631E+01_JPRB,7.9692E+01_JPRB,6.3754E+01_JPRB,4.7815E+01_JPRB,&
 & 3.1877E+01_JPRB,1.9044E+01_JPRB,2.1192E+01_JPRB/)  
KAO( :, 3, 5,15) = (/&
 & 1.7270E+02_JPRB,1.5111E+02_JPRB,1.2952E+02_JPRB,1.0794E+02_JPRB,8.6350E+01_JPRB,6.4762E+01_JPRB,&
 & 4.3175E+01_JPRB,2.2254E+01_JPRB,2.1273E+01_JPRB/)  
KAO( :, 4, 5,15) = (/&
 & 2.2614E+02_JPRB,1.9787E+02_JPRB,1.6960E+02_JPRB,1.4133E+02_JPRB,1.1307E+02_JPRB,8.4801E+01_JPRB,&
 & 5.6534E+01_JPRB,2.8267E+01_JPRB,2.1307E+01_JPRB/)  
KAO( :, 5, 5,15) = (/&
 & 2.8741E+02_JPRB,2.5148E+02_JPRB,2.1556E+02_JPRB,1.7963E+02_JPRB,1.4370E+02_JPRB,1.0778E+02_JPRB,&
 & 7.1852E+01_JPRB,3.5926E+01_JPRB,2.1269E+01_JPRB/)  
KAO( :, 1, 6,15) = (/&
 & 7.8026E+01_JPRB,6.8273E+01_JPRB,5.8519E+01_JPRB,4.8766E+01_JPRB,3.9013E+01_JPRB,2.9260E+01_JPRB,&
 & 2.1248E+01_JPRB,2.1634E+01_JPRB,2.5118E+01_JPRB/)  
KAO( :, 2, 6,15) = (/&
 & 1.1411E+02_JPRB,9.9849E+01_JPRB,8.5585E+01_JPRB,7.1321E+01_JPRB,5.7057E+01_JPRB,4.2792E+01_JPRB,&
 & 2.8533E+01_JPRB,2.2027E+01_JPRB,2.5242E+01_JPRB/)  
KAO( :, 3, 6,15) = (/&
 & 1.5933E+02_JPRB,1.3941E+02_JPRB,1.1950E+02_JPRB,9.9580E+01_JPRB,7.9664E+01_JPRB,5.9748E+01_JPRB,&
 & 3.9832E+01_JPRB,2.3409E+01_JPRB,2.5326E+01_JPRB/)  
KAO( :, 4, 6,15) = (/&
 & 2.1384E+02_JPRB,1.8711E+02_JPRB,1.6038E+02_JPRB,1.3365E+02_JPRB,1.0692E+02_JPRB,8.0189E+01_JPRB,&
 & 5.3459E+01_JPRB,2.7570E+01_JPRB,2.5371E+01_JPRB/)  
KAO( :, 5, 6,15) = (/&
 & 2.7735E+02_JPRB,2.4268E+02_JPRB,2.0801E+02_JPRB,1.7334E+02_JPRB,1.3868E+02_JPRB,1.0401E+02_JPRB,&
 & 6.9338E+01_JPRB,3.4669E+01_JPRB,2.5359E+01_JPRB/)  
KAO( :, 1, 7,15) = (/&
 & 6.5827E+01_JPRB,5.7598E+01_JPRB,4.9370E+01_JPRB,4.1142E+01_JPRB,3.2913E+01_JPRB,2.5331E+01_JPRB,&
 & 2.3025E+01_JPRB,2.5936E+01_JPRB,2.9970E+01_JPRB/)  
KAO( :, 2, 7,15) = (/&
 & 1.0010E+02_JPRB,8.7584E+01_JPRB,7.5072E+01_JPRB,6.2560E+01_JPRB,5.0048E+01_JPRB,3.7536E+01_JPRB,&
 & 2.7016E+01_JPRB,2.6117E+01_JPRB,3.0165E+01_JPRB/)  
KAO( :, 3, 7,15) = (/&
 & 1.4417E+02_JPRB,1.2615E+02_JPRB,1.0813E+02_JPRB,9.0105E+01_JPRB,7.2084E+01_JPRB,5.4063E+01_JPRB,&
 & 3.6043E+01_JPRB,2.6827E+01_JPRB,3.0311E+01_JPRB/)  
KAO( :, 4, 7,15) = (/&
 & 1.9838E+02_JPRB,1.7359E+02_JPRB,1.4879E+02_JPRB,1.2399E+02_JPRB,9.9192E+01_JPRB,7.4394E+01_JPRB,&
 & 4.9596E+01_JPRB,2.8984E+01_JPRB,3.0397E+01_JPRB/)  
KAO( :, 5, 7,15) = (/&
 & 2.6264E+02_JPRB,2.2981E+02_JPRB,1.9698E+02_JPRB,1.6415E+02_JPRB,1.3132E+02_JPRB,9.8492E+01_JPRB,&
 & 6.5661E+01_JPRB,3.3916E+01_JPRB,3.0409E+01_JPRB/)  
KAO( :, 1, 8,15) = (/&
 & 5.4379E+01_JPRB,4.7581E+01_JPRB,4.0784E+01_JPRB,3.3987E+01_JPRB,2.7376E+01_JPRB,2.4616E+01_JPRB,&
 & 2.6821E+01_JPRB,3.1053E+01_JPRB,3.5784E+01_JPRB/)  
KAO( :, 2, 8,15) = (/&
 & 8.6031E+01_JPRB,7.5277E+01_JPRB,6.4523E+01_JPRB,5.3770E+01_JPRB,4.3016E+01_JPRB,3.2712E+01_JPRB,&
 & 2.8406E+01_JPRB,3.1344E+01_JPRB,3.6100E+01_JPRB/)  
KAO( :, 3, 8,15) = (/&
 & 1.2793E+02_JPRB,1.1194E+02_JPRB,9.5951E+01_JPRB,7.9959E+01_JPRB,6.3967E+01_JPRB,4.7975E+01_JPRB,&
 & 3.4121E+01_JPRB,3.1758E+01_JPRB,3.6313E+01_JPRB/)  
KAO( :, 4, 8,15) = (/&
 & 1.8066E+02_JPRB,1.5808E+02_JPRB,1.3550E+02_JPRB,1.1291E+02_JPRB,9.0332E+01_JPRB,6.7749E+01_JPRB,&
 & 4.5233E+01_JPRB,3.2608E+01_JPRB,3.6463E+01_JPRB/)  
KAO( :, 5, 8,15) = (/&
 & 2.4439E+02_JPRB,2.1384E+02_JPRB,1.8329E+02_JPRB,1.5274E+02_JPRB,1.2219E+02_JPRB,9.1646E+01_JPRB,&
 & 6.1097E+01_JPRB,3.5772E+01_JPRB,3.6527E+01_JPRB/)  
KAO( :, 1, 9,15) = (/&
 & 4.3573E+01_JPRB,3.8127E+01_JPRB,3.2680E+01_JPRB,2.7311E+01_JPRB,2.5199E+01_JPRB,2.7215E+01_JPRB,&
 & 3.1843E+01_JPRB,3.7151E+01_JPRB,4.2720E+01_JPRB/)  
KAO( :, 2, 9,15) = (/&
 & 7.1953E+01_JPRB,6.2959E+01_JPRB,5.3964E+01_JPRB,4.4970E+01_JPRB,3.6145E+01_JPRB,3.1469E+01_JPRB,&
 & 3.2757E+01_JPRB,3.7549E+01_JPRB,4.3159E+01_JPRB/)  
KAO( :, 3, 9,15) = (/&
 & 1.1068E+02_JPRB,9.6849E+01_JPRB,8.3014E+01_JPRB,6.9178E+01_JPRB,5.5342E+01_JPRB,4.2149E+01_JPRB,&
 & 3.5486E+01_JPRB,3.7854E+01_JPRB,4.3494E+01_JPRB/)  
KAO( :, 4, 9,15) = (/&
 & 1.6091E+02_JPRB,1.4079E+02_JPRB,1.2068E+02_JPRB,1.0057E+02_JPRB,8.0454E+01_JPRB,6.0340E+01_JPRB,&
 & 4.2919E+01_JPRB,3.8576E+01_JPRB,4.3720E+01_JPRB/)  
KAO( :, 5, 9,15) = (/&
 & 2.2364E+02_JPRB,1.9568E+02_JPRB,1.6773E+02_JPRB,1.3977E+02_JPRB,1.1182E+02_JPRB,8.3864E+01_JPRB,&
 & 5.6032E+01_JPRB,3.9906E+01_JPRB,4.3837E+01_JPRB/)  
KAO( :, 1,10,15) = (/&
 & 3.5400E+01_JPRB,3.0975E+01_JPRB,2.6550E+01_JPRB,2.4562E+01_JPRB,2.6642E+01_JPRB,3.2016E+01_JPRB,&
 & 3.8070E+01_JPRB,4.4415E+01_JPRB,5.0995E+01_JPRB/)  
KAO( :, 2,10,15) = (/&
 & 6.0807E+01_JPRB,5.3206E+01_JPRB,4.5605E+01_JPRB,3.8054E+01_JPRB,3.3439E+01_JPRB,3.3829E+01_JPRB,&
 & 3.8722E+01_JPRB,4.4959E+01_JPRB,5.1600E+01_JPRB/)  
KAO( :, 3,10,15) = (/&
 & 9.6798E+01_JPRB,8.4698E+01_JPRB,7.2598E+01_JPRB,6.0498E+01_JPRB,4.8510E+01_JPRB,4.0770E+01_JPRB,&
 & 4.0001E+01_JPRB,4.5358E+01_JPRB,5.2042E+01_JPRB/)  
KAO( :, 4,10,15) = (/&
 & 1.4501E+02_JPRB,1.2688E+02_JPRB,1.0876E+02_JPRB,9.0630E+01_JPRB,7.2504E+01_JPRB,5.4950E+01_JPRB,&
 & 4.4708E+01_JPRB,4.5865E+01_JPRB,5.2368E+01_JPRB/)  
KAO( :, 5,10,15) = (/&
 & 2.0627E+02_JPRB,1.8049E+02_JPRB,1.5470E+02_JPRB,1.2892E+02_JPRB,1.0314E+02_JPRB,7.7351E+01_JPRB,&
 & 5.4677E+01_JPRB,4.6645E+01_JPRB,5.2546E+01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART10',1,ZHOOK_HANDLE)
END SUBROUTINE PART10


SUBROUTINE PART11

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART11',0,ZHOOK_HANDLE)


KAO( :, 1,11,15) = (/&
 & 3.7164E+01_JPRB,3.2519E+01_JPRB,2.8213E+01_JPRB,2.7852E+01_JPRB,3.1623E+01_JPRB,3.8446E+01_JPRB,&
 & 4.5726E+01_JPRB,5.3347E+01_JPRB,6.1167E+01_JPRB/)  
KAO( :, 2,11,15) = (/&
 & 6.4161E+01_JPRB,5.6141E+01_JPRB,4.8121E+01_JPRB,4.0753E+01_JPRB,3.7907E+01_JPRB,4.0136E+01_JPRB,&
 & 4.6490E+01_JPRB,5.3971E+01_JPRB,6.1868E+01_JPRB/)  
KAO( :, 3,11,15) = (/&
 & 1.0256E+02_JPRB,8.9738E+01_JPRB,7.6919E+01_JPRB,6.4099E+01_JPRB,5.2370E+01_JPRB,4.6558E+01_JPRB,&
 & 4.7795E+01_JPRB,5.4418E+01_JPRB,6.2373E+01_JPRB/)  
KAO( :, 4,11,15) = (/&
 & 1.5386E+02_JPRB,1.3463E+02_JPRB,1.1539E+02_JPRB,9.6161E+01_JPRB,7.6929E+01_JPRB,6.0144E+01_JPRB,&
 & 5.2042E+01_JPRB,5.4998E+01_JPRB,6.2715E+01_JPRB/)  
KAO( :, 5,11,15) = (/&
 & 2.1904E+02_JPRB,1.9166E+02_JPRB,1.6428E+02_JPRB,1.3690E+02_JPRB,1.0952E+02_JPRB,8.2243E+01_JPRB,&
 & 6.1497E+01_JPRB,5.5854E+01_JPRB,6.2906E+01_JPRB/)  
KAO( :, 1,12,15) = (/&
 & 3.8871E+01_JPRB,3.4012E+01_JPRB,3.0393E+01_JPRB,3.1931E+01_JPRB,3.7660E+01_JPRB,4.6060E+01_JPRB,&
 & 5.4792E+01_JPRB,6.3924E+01_JPRB,7.3229E+01_JPRB/)  
KAO( :, 2,12,15) = (/&
 & 6.7284E+01_JPRB,5.8873E+01_JPRB,5.0463E+01_JPRB,4.4214E+01_JPRB,4.3443E+01_JPRB,4.7760E+01_JPRB,&
 & 5.5669E+01_JPRB,6.4596E+01_JPRB,7.3985E+01_JPRB/)  
KAO( :, 3,12,15) = (/&
 & 1.0766E+02_JPRB,9.4199E+01_JPRB,8.0742E+01_JPRB,6.7302E+01_JPRB,5.7248E+01_JPRB,5.3670E+01_JPRB,&
 & 5.7112E+01_JPRB,6.5078E+01_JPRB,7.4551E+01_JPRB/)  
KAO( :, 4,12,15) = (/&
 & 1.6163E+02_JPRB,1.4143E+02_JPRB,1.2122E+02_JPRB,1.0102E+02_JPRB,8.1042E+01_JPRB,6.6522E+01_JPRB,&
 & 6.0901E+01_JPRB,6.5731E+01_JPRB,7.4885E+01_JPRB/)  
KAO( :, 5,12,15) = (/&
 & 2.3044E+02_JPRB,2.0164E+02_JPRB,1.7283E+02_JPRB,1.4403E+02_JPRB,1.1522E+02_JPRB,8.7709E+01_JPRB,&
 & 6.9646E+01_JPRB,6.6631E+01_JPRB,7.5001E+01_JPRB/)  
KAO( :, 1,13,15) = (/&
 & 4.0246E+01_JPRB,3.5215E+01_JPRB,3.3104E+01_JPRB,3.6905E+01_JPRB,4.4893E+01_JPRB,5.4993E+01_JPRB,&
 & 6.5407E+01_JPRB,7.6308E+01_JPRB,8.7364E+01_JPRB/)  
KAO( :, 2,13,15) = (/&
 & 6.9680E+01_JPRB,6.0970E+01_JPRB,5.2454E+01_JPRB,4.8453E+01_JPRB,5.0138E+01_JPRB,5.6837E+01_JPRB,&
 & 6.6412E+01_JPRB,7.7026E+01_JPRB,8.8187E+01_JPRB/)  
KAO( :, 3,13,15) = (/&
 & 1.1160E+02_JPRB,9.7650E+01_JPRB,8.3700E+01_JPRB,7.0502E+01_JPRB,6.3014E+01_JPRB,6.2089E+01_JPRB,&
 & 6.7983E+01_JPRB,7.7487E+01_JPRB,8.8731E+01_JPRB/)  
KAO( :, 4,13,15) = (/&
 & 1.6767E+02_JPRB,1.4671E+02_JPRB,1.2575E+02_JPRB,1.0479E+02_JPRB,8.5648E+01_JPRB,7.3989E+01_JPRB,&
 & 7.1252E+01_JPRB,7.8174E+01_JPRB,8.8985E+01_JPRB/)  
KAO( :, 5,13,15) = (/&
 & 2.3895E+02_JPRB,2.0908E+02_JPRB,1.7922E+02_JPRB,1.4935E+02_JPRB,1.1948E+02_JPRB,9.3985E+01_JPRB,&
 & 7.9182E+01_JPRB,7.9098E+01_JPRB,8.9007E+01_JPRB/)  
KAO( :, 1, 1,16) = (/&
 & 1.3674E+02_JPRB,1.1964E+02_JPRB,1.0255E+02_JPRB,8.5460E+01_JPRB,6.8368E+01_JPRB,5.1276E+01_JPRB,&
 & 3.4184E+01_JPRB,1.7092E+01_JPRB,4.7777E+01_JPRB/)  
KAO( :, 2, 1,16) = (/&
 & 1.7779E+02_JPRB,1.5556E+02_JPRB,1.3334E+02_JPRB,1.1112E+02_JPRB,8.8894E+01_JPRB,6.6670E+01_JPRB,&
 & 4.4447E+01_JPRB,2.2223E+01_JPRB,5.4515E+01_JPRB/)  
KAO( :, 3, 1,16) = (/&
 & 2.2447E+02_JPRB,1.9641E+02_JPRB,1.6835E+02_JPRB,1.4030E+02_JPRB,1.1224E+02_JPRB,8.4177E+01_JPRB,&
 & 5.6118E+01_JPRB,2.8059E+01_JPRB,6.1237E+01_JPRB/)  
KAO( :, 4, 1,16) = (/&
 & 2.7629E+02_JPRB,2.4176E+02_JPRB,2.0722E+02_JPRB,1.7268E+02_JPRB,1.3815E+02_JPRB,1.0361E+02_JPRB,&
 & 6.9073E+01_JPRB,3.4537E+01_JPRB,6.7881E+01_JPRB/)  
KAO( :, 5, 1,16) = (/&
 & 3.3259E+02_JPRB,2.9102E+02_JPRB,2.4944E+02_JPRB,2.0787E+02_JPRB,1.6630E+02_JPRB,1.2472E+02_JPRB,&
 & 8.3148E+01_JPRB,4.1574E+01_JPRB,7.4387E+01_JPRB/)  
KAO( :, 1, 2,16) = (/&
 & 1.4678E+02_JPRB,1.2843E+02_JPRB,1.1009E+02_JPRB,9.1739E+01_JPRB,7.3391E+01_JPRB,5.5044E+01_JPRB,&
 & 3.6696E+01_JPRB,1.8348E+01_JPRB,3.6081E+01_JPRB/)  
KAO( :, 2, 2,16) = (/&
 & 1.9364E+02_JPRB,1.6943E+02_JPRB,1.4523E+02_JPRB,1.2102E+02_JPRB,9.6819E+01_JPRB,7.2614E+01_JPRB,&
 & 4.8409E+01_JPRB,2.4205E+01_JPRB,4.1498E+01_JPRB/)  
KAO( :, 3, 2,16) = (/&
 & 2.4749E+02_JPRB,2.1655E+02_JPRB,1.8562E+02_JPRB,1.5468E+02_JPRB,1.2374E+02_JPRB,9.2808E+01_JPRB,&
 & 6.1872E+01_JPRB,3.0936E+01_JPRB,4.6929E+01_JPRB/)  
KAO( :, 4, 2,16) = (/&
 & 3.0786E+02_JPRB,2.6938E+02_JPRB,2.3089E+02_JPRB,1.9241E+02_JPRB,1.5393E+02_JPRB,1.1545E+02_JPRB,&
 & 7.6965E+01_JPRB,3.8482E+01_JPRB,5.2308E+01_JPRB/)  
KAO( :, 5, 2,16) = (/&
 & 3.7405E+02_JPRB,3.2730E+02_JPRB,2.8054E+02_JPRB,2.3378E+02_JPRB,1.8703E+02_JPRB,1.4027E+02_JPRB,&
 & 9.3513E+01_JPRB,4.6757E+01_JPRB,5.7603E+01_JPRB/)  
KAO( :, 1, 3,16) = (/&
 & 1.4770E+02_JPRB,1.2924E+02_JPRB,1.1078E+02_JPRB,9.2315E+01_JPRB,7.3852E+01_JPRB,5.5389E+01_JPRB,&
 & 3.6926E+01_JPRB,1.8463E+01_JPRB,2.0017E+01_JPRB/)  
KAO( :, 2, 3,16) = (/&
 & 1.9922E+02_JPRB,1.7432E+02_JPRB,1.4941E+02_JPRB,1.2451E+02_JPRB,9.9609E+01_JPRB,7.4707E+01_JPRB,&
 & 4.9805E+01_JPRB,2.4902E+01_JPRB,2.3072E+01_JPRB/)  
KAO( :, 3, 3,16) = (/&
 & 2.5951E+02_JPRB,2.2707E+02_JPRB,1.9463E+02_JPRB,1.6219E+02_JPRB,1.2975E+02_JPRB,9.7315E+01_JPRB,&
 & 6.4877E+01_JPRB,3.2438E+01_JPRB,2.6326E+01_JPRB/)  
KAO( :, 4, 3,16) = (/&
 & 3.2798E+02_JPRB,2.8698E+02_JPRB,2.4598E+02_JPRB,2.0498E+02_JPRB,1.6399E+02_JPRB,1.2299E+02_JPRB,&
 & 8.1994E+01_JPRB,4.0997E+01_JPRB,2.9574E+01_JPRB/)  
KAO( :, 5, 3,16) = (/&
 & 4.0406E+02_JPRB,3.5355E+02_JPRB,3.0305E+02_JPRB,2.5254E+02_JPRB,2.0203E+02_JPRB,1.5152E+02_JPRB,&
 & 1.0102E+02_JPRB,5.0508E+01_JPRB,3.2777E+01_JPRB/)  
KAO( :, 1, 4,16) = (/&
 & 1.4422E+02_JPRB,1.2619E+02_JPRB,1.0816E+02_JPRB,9.0137E+01_JPRB,7.2109E+01_JPRB,5.4082E+01_JPRB,&
 & 3.6055E+01_JPRB,1.8027E+01_JPRB,1.8526E+01_JPRB/)  
KAO( :, 2, 4,16) = (/&
 & 1.9978E+02_JPRB,1.7481E+02_JPRB,1.4983E+02_JPRB,1.2486E+02_JPRB,9.9890E+01_JPRB,7.4917E+01_JPRB,&
 & 4.9945E+01_JPRB,2.4972E+01_JPRB,1.9155E+01_JPRB/)  
KAO( :, 3, 4,16) = (/&
 & 2.6597E+02_JPRB,2.3273E+02_JPRB,1.9948E+02_JPRB,1.6623E+02_JPRB,1.3299E+02_JPRB,9.9740E+01_JPRB,&
 & 6.6493E+01_JPRB,3.3247E+01_JPRB,1.9814E+01_JPRB/)  
KAO( :, 4, 4,16) = (/&
 & 3.4257E+02_JPRB,2.9975E+02_JPRB,2.5693E+02_JPRB,2.1411E+02_JPRB,1.7128E+02_JPRB,1.2846E+02_JPRB,&
 & 8.5642E+01_JPRB,4.2821E+01_JPRB,2.0371E+01_JPRB/)  
KAO( :, 5, 4,16) = (/&
 & 4.2875E+02_JPRB,3.7515E+02_JPRB,3.2156E+02_JPRB,2.6797E+02_JPRB,2.1437E+02_JPRB,1.6078E+02_JPRB,&
 & 1.0719E+02_JPRB,5.3593E+01_JPRB,2.0835E+01_JPRB/)  
KAO( :, 1, 5,16) = (/&
 & 1.3899E+02_JPRB,1.2162E+02_JPRB,1.0425E+02_JPRB,8.6871E+01_JPRB,6.9497E+01_JPRB,5.2123E+01_JPRB,&
 & 3.4748E+01_JPRB,1.8596E+01_JPRB,2.1711E+01_JPRB/)  
KAO( :, 2, 5,16) = (/&
 & 1.9805E+02_JPRB,1.7329E+02_JPRB,1.4854E+02_JPRB,1.2378E+02_JPRB,9.9025E+01_JPRB,7.4269E+01_JPRB,&
 & 4.9513E+01_JPRB,2.4756E+01_JPRB,2.1848E+01_JPRB/)  
KAO( :, 3, 5,16) = (/&
 & 2.7005E+02_JPRB,2.3630E+02_JPRB,2.0254E+02_JPRB,1.6878E+02_JPRB,1.3503E+02_JPRB,1.0127E+02_JPRB,&
 & 6.7514E+01_JPRB,3.3757E+01_JPRB,2.1967E+01_JPRB/)  
KAO( :, 4, 5,16) = (/&
 & 3.5478E+02_JPRB,3.1044E+02_JPRB,2.6609E+02_JPRB,2.2174E+02_JPRB,1.7739E+02_JPRB,1.3304E+02_JPRB,&
 & 8.8696E+01_JPRB,4.4348E+01_JPRB,2.2139E+01_JPRB/)  
KAO( :, 5, 5,16) = (/&
 & 4.5175E+02_JPRB,3.9528E+02_JPRB,3.3881E+02_JPRB,2.8234E+02_JPRB,2.2588E+02_JPRB,1.6941E+02_JPRB,&
 & 1.1294E+02_JPRB,5.6469E+01_JPRB,2.2377E+01_JPRB/)  
KAO( :, 1, 6,16) = (/&
 & 1.3013E+02_JPRB,1.1386E+02_JPRB,9.7595E+01_JPRB,8.1329E+01_JPRB,6.5064E+01_JPRB,4.8798E+01_JPRB,&
 & 3.2532E+01_JPRB,2.2484E+01_JPRB,2.6076E+01_JPRB/)  
KAO( :, 2, 6,16) = (/&
 & 1.9160E+02_JPRB,1.6765E+02_JPRB,1.4370E+02_JPRB,1.1975E+02_JPRB,9.5800E+01_JPRB,7.1850E+01_JPRB,&
 & 4.7900E+01_JPRB,2.3950E+01_JPRB,2.6232E+01_JPRB/)  
KAO( :, 3, 6,16) = (/&
 & 2.6831E+02_JPRB,2.3477E+02_JPRB,2.0123E+02_JPRB,1.6769E+02_JPRB,1.3415E+02_JPRB,1.0061E+02_JPRB,&
 & 6.7076E+01_JPRB,3.3538E+01_JPRB,2.6352E+01_JPRB/)  
KAO( :, 4, 6,16) = (/&
 & 3.6064E+02_JPRB,3.1556E+02_JPRB,2.7048E+02_JPRB,2.2540E+02_JPRB,1.8032E+02_JPRB,1.3524E+02_JPRB,&
 & 9.0160E+01_JPRB,4.5080E+01_JPRB,2.6414E+01_JPRB/)  
KAO( :, 5, 6,16) = (/&
 & 4.6794E+02_JPRB,4.0944E+02_JPRB,3.5095E+02_JPRB,2.9246E+02_JPRB,2.3397E+02_JPRB,1.7548E+02_JPRB,&
 & 1.1698E+02_JPRB,5.8492E+01_JPRB,2.6392E+01_JPRB/)  
KAO( :, 1, 7,16) = (/&
 & 1.1956E+02_JPRB,1.0461E+02_JPRB,8.9667E+01_JPRB,7.4722E+01_JPRB,5.9778E+01_JPRB,4.4833E+01_JPRB,&
 & 2.9889E+01_JPRB,2.7199E+01_JPRB,3.1421E+01_JPRB/)  
KAO( :, 2, 7,16) = (/&
 & 1.8238E+02_JPRB,1.5958E+02_JPRB,1.3678E+02_JPRB,1.1398E+02_JPRB,9.1188E+01_JPRB,6.8391E+01_JPRB,&
 & 4.5594E+01_JPRB,2.7417E+01_JPRB,3.1636E+01_JPRB/)  
KAO( :, 3, 7,16) = (/&
 & 2.6306E+02_JPRB,2.3018E+02_JPRB,1.9730E+02_JPRB,1.6441E+02_JPRB,1.3153E+02_JPRB,9.8648E+01_JPRB,&
 & 6.5766E+01_JPRB,3.2883E+01_JPRB,3.1799E+01_JPRB/)  
KAO( :, 4, 7,16) = (/&
 & 3.6216E+02_JPRB,3.1689E+02_JPRB,2.7162E+02_JPRB,2.2635E+02_JPRB,1.8108E+02_JPRB,1.3581E+02_JPRB,&
 & 9.0539E+01_JPRB,4.5269E+01_JPRB,3.1905E+01_JPRB/)  
KAO( :, 5, 7,16) = (/&
 & 4.7940E+02_JPRB,4.1947E+02_JPRB,3.5955E+02_JPRB,2.9962E+02_JPRB,2.3970E+02_JPRB,1.7977E+02_JPRB,&
 & 1.1985E+02_JPRB,5.9925E+01_JPRB,3.1925E+01_JPRB/)  
KAO( :, 1, 8,16) = (/&
 & 1.0811E+02_JPRB,9.4599E+01_JPRB,8.1085E+01_JPRB,6.7571E+01_JPRB,5.4057E+01_JPRB,4.0543E+01_JPRB,&
 & 2.8198E+01_JPRB,3.2881E+01_JPRB,3.7875E+01_JPRB/)  
KAO( :, 2, 8,16) = (/&
 & 1.7137E+02_JPRB,1.4995E+02_JPRB,1.2853E+02_JPRB,1.0711E+02_JPRB,8.5687E+01_JPRB,6.4265E+01_JPRB,&
 & 4.2843E+01_JPRB,3.3181E+01_JPRB,3.8195E+01_JPRB/)  
KAO( :, 3, 8,16) = (/&
 & 2.5494E+02_JPRB,2.2307E+02_JPRB,1.9121E+02_JPRB,1.5934E+02_JPRB,1.2747E+02_JPRB,9.5603E+01_JPRB,&
 & 6.3736E+01_JPRB,3.3454E+01_JPRB,3.8440E+01_JPRB/)  
KAO( :, 4, 8,16) = (/&
 & 3.5993E+02_JPRB,3.1494E+02_JPRB,2.6995E+02_JPRB,2.2496E+02_JPRB,1.7997E+02_JPRB,1.3498E+02_JPRB,&
 & 8.9984E+01_JPRB,4.4992E+01_JPRB,3.8593E+01_JPRB/)  
KAO( :, 5, 8,16) = (/&
 & 4.8664E+02_JPRB,4.2581E+02_JPRB,3.6498E+02_JPRB,3.0415E+02_JPRB,2.4332E+02_JPRB,1.8249E+02_JPRB,&
 & 1.2166E+02_JPRB,6.0830E+01_JPRB,3.8660E+01_JPRB/)  
KAO( :, 1, 9,16) = (/&
 & 9.5566E+01_JPRB,8.3620E+01_JPRB,7.1674E+01_JPRB,5.9728E+01_JPRB,4.7783E+01_JPRB,3.5837E+01_JPRB,&
 & 3.4022E+01_JPRB,3.9693E+01_JPRB,4.5621E+01_JPRB/)  
KAO( :, 2, 9,16) = (/&
 & 1.5795E+02_JPRB,1.3820E+02_JPRB,1.1846E+02_JPRB,9.8717E+01_JPRB,7.8974E+01_JPRB,5.9230E+01_JPRB,&
 & 3.9487E+01_JPRB,4.0126E+01_JPRB,4.6102E+01_JPRB/)  
KAO( :, 3, 9,16) = (/&
 & 2.4293E+02_JPRB,2.1257E+02_JPRB,1.8220E+02_JPRB,1.5183E+02_JPRB,1.2147E+02_JPRB,9.1099E+01_JPRB,&
 & 6.0733E+01_JPRB,4.0455E+01_JPRB,4.6460E+01_JPRB/)  
KAO( :, 4, 9,16) = (/&
 & 3.5246E+02_JPRB,3.0840E+02_JPRB,2.6435E+02_JPRB,2.2029E+02_JPRB,1.7623E+02_JPRB,1.3217E+02_JPRB,&
 & 8.8115E+01_JPRB,4.4330E+01_JPRB,4.6688E+01_JPRB/)  
KAO( :, 5, 9,16) = (/&
 & 4.8730E+02_JPRB,4.2639E+02_JPRB,3.6548E+02_JPRB,3.0456E+02_JPRB,2.4365E+02_JPRB,1.8274E+02_JPRB,&
 & 1.2183E+02_JPRB,6.0913E+01_JPRB,4.6814E+01_JPRB/)  
KAO( :, 1,10,16) = (/&
 & 8.6364E+01_JPRB,7.5568E+01_JPRB,6.4773E+01_JPRB,5.3977E+01_JPRB,4.3182E+01_JPRB,3.4440E+01_JPRB,&
 & 4.1088E+01_JPRB,4.7936E+01_JPRB,5.5004E+01_JPRB/)  
KAO( :, 2,10,16) = (/&
 & 1.4833E+02_JPRB,1.2979E+02_JPRB,1.1125E+02_JPRB,9.2705E+01_JPRB,7.4164E+01_JPRB,5.5623E+01_JPRB,&
 & 4.1568E+01_JPRB,4.8496E+01_JPRB,5.5636E+01_JPRB/)  
KAO( :, 3,10,16) = (/&
 & 2.3518E+02_JPRB,2.0578E+02_JPRB,1.7638E+02_JPRB,1.4699E+02_JPRB,1.1759E+02_JPRB,8.8191E+01_JPRB,&
 & 5.8794E+01_JPRB,4.8955E+01_JPRB,5.6147E+01_JPRB/)  
KAO( :, 4,10,16) = (/&
 & 3.4963E+02_JPRB,3.0592E+02_JPRB,2.6222E+02_JPRB,2.1852E+02_JPRB,1.7481E+02_JPRB,1.3111E+02_JPRB,&
 & 8.7406E+01_JPRB,4.9235E+01_JPRB,5.6450E+01_JPRB/)  
KAO( :, 5,10,16) = (/&
 & 4.9302E+02_JPRB,4.3139E+02_JPRB,3.6977E+02_JPRB,3.0814E+02_JPRB,2.4651E+02_JPRB,1.8488E+02_JPRB,&
 & 1.2326E+02_JPRB,6.1628E+01_JPRB,5.6644E+01_JPRB/)  
KAO( :, 1,11,16) = (/&
 & 1.0149E+02_JPRB,8.8804E+01_JPRB,7.6118E+01_JPRB,6.3431E+01_JPRB,5.0745E+01_JPRB,4.1772E+01_JPRB,&
 & 4.9883E+01_JPRB,5.8197E+01_JPRB,6.6698E+01_JPRB/)  
KAO( :, 2,11,16) = (/&
 & 1.7380E+02_JPRB,1.5208E+02_JPRB,1.3035E+02_JPRB,1.0863E+02_JPRB,8.6902E+01_JPRB,6.5176E+01_JPRB,&
 & 5.0425E+01_JPRB,5.8829E+01_JPRB,6.7412E+01_JPRB/)  
KAO( :, 3,11,16) = (/&
 & 2.7485E+02_JPRB,2.4050E+02_JPRB,2.0614E+02_JPRB,1.7178E+02_JPRB,1.3743E+02_JPRB,1.0307E+02_JPRB,&
 & 6.8713E+01_JPRB,5.9345E+01_JPRB,6.7990E+01_JPRB/)  
KAO( :, 4,11,16) = (/&
 & 4.0747E+02_JPRB,3.5653E+02_JPRB,3.0560E+02_JPRB,2.5467E+02_JPRB,2.0373E+02_JPRB,1.5280E+02_JPRB,&
 & 1.0187E+02_JPRB,5.9645E+01_JPRB,6.8320E+01_JPRB/)  
KAO( :, 5,11,16) = (/&
 & 5.7295E+02_JPRB,5.0133E+02_JPRB,4.2971E+02_JPRB,3.5809E+02_JPRB,2.8648E+02_JPRB,2.1486E+02_JPRB,&
 & 1.4324E+02_JPRB,7.2192E+01_JPRB,6.8483E+01_JPRB/)  
KAO( :, 1,12,16) = (/&
 & 1.1827E+02_JPRB,1.0349E+02_JPRB,8.8705E+01_JPRB,7.3921E+01_JPRB,5.9137E+01_JPRB,5.0630E+01_JPRB,&
 & 6.0438E+01_JPRB,7.0510E+01_JPRB,8.0746E+01_JPRB/)  
KAO( :, 2,12,16) = (/&
 & 2.0179E+02_JPRB,1.7656E+02_JPRB,1.5134E+02_JPRB,1.2612E+02_JPRB,1.0089E+02_JPRB,7.5670E+01_JPRB,&
 & 6.1072E+01_JPRB,7.1251E+01_JPRB,8.1581E+01_JPRB/)  
KAO( :, 3,12,16) = (/&
 & 3.1798E+02_JPRB,2.7824E+02_JPRB,2.3849E+02_JPRB,1.9874E+02_JPRB,1.5899E+02_JPRB,1.1924E+02_JPRB,&
 & 7.9796E+01_JPRB,7.1750E+01_JPRB,8.2143E+01_JPRB/)  
KAO( :, 4,12,16) = (/&
 & 4.7106E+02_JPRB,4.1218E+02_JPRB,3.5330E+02_JPRB,2.9441E+02_JPRB,2.3553E+02_JPRB,1.7665E+02_JPRB,&
 & 1.1777E+02_JPRB,7.2076E+01_JPRB,8.2504E+01_JPRB/)  
KAO( :, 5,12,16) = (/&
 & 6.6390E+02_JPRB,5.8091E+02_JPRB,4.9792E+02_JPRB,4.1494E+02_JPRB,3.3195E+02_JPRB,2.4896E+02_JPRB,&
 & 1.6597E+02_JPRB,8.4840E+01_JPRB,8.2551E+01_JPRB/)  
KAO( :, 1,13,16) = (/&
 & 1.3595E+02_JPRB,1.1896E+02_JPRB,1.0196E+02_JPRB,8.4968E+01_JPRB,6.8087E+01_JPRB,6.1225E+01_JPRB,&
 & 7.3041E+01_JPRB,8.5214E+01_JPRB,9.7532E+01_JPRB/)  
KAO( :, 2,13,16) = (/&
 & 2.3178E+02_JPRB,2.0280E+02_JPRB,1.7383E+02_JPRB,1.4486E+02_JPRB,1.1589E+02_JPRB,8.6916E+01_JPRB,&
 & 7.3742E+01_JPRB,8.6032E+01_JPRB,9.8456E+01_JPRB/)  
KAO( :, 3,13,16) = (/&
 & 3.6636E+02_JPRB,3.2056E+02_JPRB,2.7477E+02_JPRB,2.2897E+02_JPRB,1.8318E+02_JPRB,1.3738E+02_JPRB,&
 & 9.2837E+01_JPRB,8.6498E+01_JPRB,9.8980E+01_JPRB/)  
KAO( :, 4,13,16) = (/&
 & 5.4438E+02_JPRB,4.7633E+02_JPRB,4.0829E+02_JPRB,3.4024E+02_JPRB,2.7219E+02_JPRB,2.0414E+02_JPRB,&
 & 1.3610E+02_JPRB,8.6750E+01_JPRB,9.9251E+01_JPRB/)  
KAO( :, 5,13,16) = (/&
 & 7.6815E+02_JPRB,6.7213E+02_JPRB,5.7611E+02_JPRB,4.8009E+02_JPRB,3.8407E+02_JPRB,2.8805E+02_JPRB,&
 & 1.9204E+02_JPRB,9.9763E+01_JPRB,9.9159E+01_JPRB/)  

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
 & 1.72146E-03_JPRB, 1.41213E-03_JPRB, 1.15839E-03_JPRB, 9.50236E-04_JPRB, 7.79489E-04_JPRB,&
 & 6.39423E-04_JPRB, 5.24525E-04_JPRB, 4.30274E-04_JPRB, 3.52958E-04_JPRB, 2.89535E-04_JPRB/)  
SELFREFO( :, 2) = (/&
 & 1.83092E-03_JPRB, 1.50082E-03_JPRB, 1.23023E-03_JPRB, 1.00843E-03_JPRB, 8.26611E-04_JPRB,&
 & 6.77578E-04_JPRB, 5.55414E-04_JPRB, 4.55276E-04_JPRB, 3.73192E-04_JPRB, 3.05908E-04_JPRB/)  
SELFREFO( :, 3) = (/&
 & 1.92620E-03_JPRB, 1.57871E-03_JPRB, 1.29391E-03_JPRB, 1.06048E-03_JPRB, 8.69169E-04_JPRB,&
 & 7.12370E-04_JPRB, 5.83857E-04_JPRB, 4.78528E-04_JPRB, 3.92201E-04_JPRB, 3.21447E-04_JPRB/)  
SELFREFO( :, 4) = (/&
 & 2.11224E-03_JPRB, 1.72966E-03_JPRB, 1.41638E-03_JPRB, 1.15984E-03_JPRB, 9.49760E-04_JPRB,&
 & 7.77734E-04_JPRB, 6.36867E-04_JPRB, 5.21514E-04_JPRB, 4.27055E-04_JPRB, 3.49704E-04_JPRB/)  
SELFREFO( :, 5) = (/&
 & 2.31367E-03_JPRB, 1.88988E-03_JPRB, 1.54371E-03_JPRB, 1.26095E-03_JPRB, 1.02999E-03_JPRB,&
 & 8.41325E-04_JPRB, 6.87221E-04_JPRB, 5.61344E-04_JPRB, 4.58523E-04_JPRB, 3.74536E-04_JPRB/)  
SELFREFO( :, 6) = (/&
 & 2.47614E-03_JPRB, 2.03107E-03_JPRB, 1.66599E-03_JPRB, 1.36654E-03_JPRB, 1.12091E-03_JPRB,&
 & 9.19433E-04_JPRB, 7.54170E-04_JPRB, 6.18612E-04_JPRB, 5.07419E-04_JPRB, 4.16213E-04_JPRB/)  
SELFREFO( :, 7) = (/&
 & 2.55137E-03_JPRB, 2.10353E-03_JPRB, 1.73430E-03_JPRB, 1.42987E-03_JPRB, 1.17889E-03_JPRB,&
 & 9.71958E-04_JPRB, 8.01350E-04_JPRB, 6.60688E-04_JPRB, 5.44717E-04_JPRB, 4.49103E-04_JPRB/)  
SELFREFO( :, 8) = (/&
 & 2.59317E-03_JPRB, 2.13957E-03_JPRB, 1.76532E-03_JPRB, 1.45653E-03_JPRB, 1.20175E-03_JPRB,&
 & 9.91539E-04_JPRB, 8.18098E-04_JPRB, 6.74996E-04_JPRB, 5.56926E-04_JPRB, 4.59508E-04_JPRB/)  
SELFREFO( :, 9) = (/&
 & 2.83495E-03_JPRB, 2.34704E-03_JPRB, 1.94309E-03_JPRB, 1.60867E-03_JPRB, 1.33181E-03_JPRB,&
 & 1.10259E-03_JPRB, 9.12826E-04_JPRB, 7.55721E-04_JPRB, 6.25656E-04_JPRB, 5.17975E-04_JPRB/)  
SELFREFO( :,10) = (/&
 & 2.98196E-03_JPRB, 2.46746E-03_JPRB, 2.04173E-03_JPRB, 1.68946E-03_JPRB, 1.39796E-03_JPRB,&
 & 1.15676E-03_JPRB, 9.57177E-04_JPRB, 7.92028E-04_JPRB, 6.55373E-04_JPRB, 5.42297E-04_JPRB/)  
SELFREFO( :,11) = (/&
 & 2.98241E-03_JPRB, 2.46776E-03_JPRB, 2.04191E-03_JPRB, 1.68955E-03_JPRB, 1.39800E-03_JPRB,&
 & 1.15675E-03_JPRB, 9.57141E-04_JPRB, 7.91974E-04_JPRB, 6.55308E-04_JPRB, 5.42226E-04_JPRB/)  
SELFREFO( :,12) = (/&
 & 2.97837E-03_JPRB, 2.46464E-03_JPRB, 2.03952E-03_JPRB, 1.68773E-03_JPRB, 1.39662E-03_JPRB,&
 & 1.15572E-03_JPRB, 9.56375E-04_JPRB, 7.91413E-04_JPRB, 6.54904E-04_JPRB, 5.41942E-04_JPRB/)  
SELFREFO( :,13) = (/&
 & 2.97777E-03_JPRB, 2.46461E-03_JPRB, 2.03989E-03_JPRB, 1.68835E-03_JPRB, 1.39740E-03_JPRB,&
 & 1.15659E-03_JPRB, 9.57271E-04_JPRB, 7.92305E-04_JPRB, 6.55767E-04_JPRB, 5.42759E-04_JPRB/)  
SELFREFO( :,14) = (/&
 & 2.98331E-03_JPRB, 2.46947E-03_JPRB, 2.04413E-03_JPRB, 1.69205E-03_JPRB, 1.40061E-03_JPRB,&
 & 1.15937E-03_JPRB, 9.59683E-04_JPRB, 7.94388E-04_JPRB, 6.57564E-04_JPRB, 5.44306E-04_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART11',1,ZHOOK_HANDLE)
END SUBROUTINE PART11


SUBROUTINE PART12

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART12',0,ZHOOK_HANDLE)


SELFREFO( :,15) = (/&
 & 2.99414E-03_JPRB, 2.47830E-03_JPRB, 2.05133E-03_JPRB, 1.69792E-03_JPRB, 1.40540E-03_JPRB,&
 & 1.16328E-03_JPRB, 9.62863E-04_JPRB, 7.96978E-04_JPRB, 6.59673E-04_JPRB, 5.46023E-04_JPRB/)  
SELFREFO( :,16) = (/&
 & 3.00006E-03_JPRB, 2.48297E-03_JPRB, 2.05501E-03_JPRB, 1.70081E-03_JPRB, 1.40766E-03_JPRB,&
 & 1.16503E-03_JPRB, 9.64227E-04_JPRB, 7.98033E-04_JPRB, 6.60484E-04_JPRB, 5.46643E-04_JPRB/)  

FRACREFAO( :, 1) = (/&
 !     From P = 1053.6 mb.
 & 0.11287100_JPRB,0.12070200_JPRB,0.12729000_JPRB,0.12858100_JPRB,&
 & 0.12743001_JPRB,0.11961800_JPRB,0.10290400_JPRB,0.07888980_JPRB,&
 & 0.05900120_JPRB,0.00667979_JPRB,0.00552926_JPRB,0.00436993_JPRB,&
 & 0.00320611_JPRB,0.00204765_JPRB,0.00077371_JPRB,0.00010894_JPRB/)  
FRACREFAO( :, 2) = (/&
 & 0.13918801_JPRB,0.16353001_JPRB,0.16155800_JPRB,0.14090499_JPRB,&
 & 0.11322300_JPRB,0.08757720_JPRB,0.07225720_JPRB,0.05173390_JPRB,&
 & 0.04731360_JPRB,0.00667979_JPRB,0.00552926_JPRB,0.00436993_JPRB,&
 & 0.00320611_JPRB,0.00204765_JPRB,0.00077371_JPRB,0.00010894_JPRB/)  
FRACREFAO( :, 3) = (/&
 & 0.14687300_JPRB,0.17853101_JPRB,0.15664500_JPRB,0.13351700_JPRB,&
 & 0.10791200_JPRB,0.08684320_JPRB,0.07158090_JPRB,0.05198410_JPRB,&
 & 0.04340110_JPRB,0.00667979_JPRB,0.00552926_JPRB,0.00436993_JPRB,&
 & 0.00320611_JPRB,0.00204765_JPRB,0.00077371_JPRB,0.00010894_JPRB/)  
FRACREFAO( :, 4) = (/&
 & 0.15760700_JPRB,0.17759100_JPRB,0.15158001_JPRB,0.13193300_JPRB,&
 & 0.10742800_JPRB,0.08693760_JPRB,0.07159490_JPRB,0.05196250_JPRB,&
 & 0.04065270_JPRB,0.00667979_JPRB,0.00552926_JPRB,0.00436993_JPRB,&
 & 0.00320611_JPRB,0.00204765_JPRB,0.00077371_JPRB,0.00010894_JPRB/)  
FRACREFAO( :, 5) = (/&
 & 0.16646700_JPRB,0.17299300_JPRB,0.15018500_JPRB,0.13138700_JPRB,&
 & 0.10735900_JPRB,0.08713110_JPRB,0.07130330_JPRB,0.05279420_JPRB,&
 & 0.03766730_JPRB,0.00667979_JPRB,0.00552926_JPRB,0.00436993_JPRB,&
 & 0.00320611_JPRB,0.00204765_JPRB,0.00077371_JPRB,0.00010894_JPRB/)  
FRACREFAO( :, 6) = (/&
 & 0.17546000_JPRB,0.16666500_JPRB,0.14969499_JPRB,0.13105400_JPRB,&
 & 0.10782500_JPRB,0.08718610_JPRB,0.07156770_JPRB,0.05308320_JPRB,&
 & 0.03753960_JPRB,0.00432465_JPRB,0.00509623_JPRB,0.00436993_JPRB,&
 & 0.00320611_JPRB,0.00204765_JPRB,0.00077371_JPRB,0.00010894_JPRB/)  
FRACREFAO( :, 7) = (/&
 & 0.18378501_JPRB,0.16064601_JPRB,0.14940400_JPRB,0.13146400_JPRB,&
 & 0.10810300_JPRB,0.08775740_JPRB,0.07115360_JPRB,0.05400040_JPRB,&
 & 0.03689970_JPRB,0.00388333_JPRB,0.00323610_JPRB,0.00353414_JPRB,&
 & 0.00320611_JPRB,0.00204765_JPRB,0.00077371_JPRB,0.00010894_JPRB/)  
FRACREFAO( :, 8) = (/&
 & 0.18966800_JPRB,0.15744300_JPRB,0.14993000_JPRB,0.13152599_JPRB,&
 & 0.10899200_JPRB,0.08858690_JPRB,0.07142920_JPRB,0.05399600_JPRB,&
 & 0.03433460_JPRB,0.00374886_JPRB,0.00302066_JPRB,0.00240653_JPRB,&
 & 0.00199205_JPRB,0.00204765_JPRB,0.00077371_JPRB,0.00010894_JPRB/)  
FRACREFAO( :, 9) = (/&
 & 0.11887100_JPRB,0.12479600_JPRB,0.12569501_JPRB,0.12839900_JPRB,&
 & 0.12473500_JPRB,0.12012800_JPRB,0.11086700_JPRB,0.08493590_JPRB,&
 & 0.05063770_JPRB,0.00328723_JPRB,0.00266849_JPRB,0.00210232_JPRB,&
 & 0.00152114_JPRB,0.00095635_JPRB,0.00035374_JPRB,0.00004980_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB15:PART12',1,ZHOOK_HANDLE)
END SUBROUTINE PART12


END SUBROUTINE RRTM_KGB15
