#!/bin/bash

mth_i=200501
mth_f=201112
GRID_DIR=./INIT

while (($# > 0))
   do
   case $1 in
     "-h") cat <<........fin
           lance.sh [-mthini initial_month] [-mthend final_month] [-grid_dir directory_containing_grille_gcm.nc]
........fin
     exit ;;
     "-grille_dir") GRID_DIR=$2 ; shift ; shift ;;
     "-mthini") mth_i=$2 ; shift ; shift ;;
     "-mthend") mth_f=$2 ; shift ; shift ;;
     *) $0 -h ; exit
   esac
done


tmin=1
resol=grilles_gcm.nc
rea=erai

GRID_FI=${GRID_DIR}/${resol}
if [ ! -f "$GRID_FI" ] ; then
   echo Le gichiers $GRID_DIR/$resol est necessaire
   echo creer le fichier $GRID_FI avec grilles_gcm_netcdf.e
   exit
fi
mth=$mth_i


#####################################################################
while (( $mth <= $mth_f )) ; do
#####################################################################
   echo mth $mth
   mois=`echo $mth | cut -c 5-`
   an=`echo $mth | cut -c -4`
   ndays=( 31 28 31 30 31 30 31 31 30 31 30 31 )
   months=( jan feb mar apr may jun jul aug sep oct nov dec )
   if [ $(( $an % 4 )) = 0 ] ; then ndays[1]=29 ; fi
   imois=$(( ${mois#0} - 1 ))
   month=${months[$imois]}
   nday=${ndays[$imois]}
   tmax=$(( $nday * 4 ))
   echo PARAMETRES CALENDAIRES $imois $month $nday $tmax


   iip1=`ncdump -h $GRID_FI | grep lonu | head -1 | awk ' { print $3 } '`
   jjm=`ncdump -h $GRID_FI | grep latv | head -1 | awk ' { print $3 } '`
   (( jjp1 =  $jjm + 1 ))
   (( iim  = $iip1 - 1 ))
   \rm t2.nc ua.nc va.nc sst.nc u.nc v.nc T.nc ts.nc

#####################################################################
# Choix de la periode temporelle
#####################################################################

   t0="l=$tmin"
   t1tn="l=${tmin}:${tmax}"

#####################################################################
# Lien avec les cihiers netcdf contenant les d0 NCEP
#####################################################################

   if [ "$rea" = "erai" ] ; then
      ANA_DIR='http://prodn.idris.fr/thredds/dodsC/ipsl_private/rpsl376/ERAI/NETCDF/GLOBAL_1125/4xdaily'
      ANA_DIR='/arch/home/rech/psl/rpsl376/ERAI/NETCDF/GLOBAL_1125/4xdaily'
      suf="ei.GLOBAL_1125"
   else
      ANA_DIR='http://prodn.idris.fr/thredds/dodsC/ipsl_private/rpsl376/OPERA/NETCDF/4xdaily'
      suf=".GLOBAL_1125"
   fi

varu=u
varv=v
varp=msl
vart=ta
varq=q
fileu="$ANA_DIR/AN_PL/$an/u.$an$mois.aph$suf.nc"
filev="$ANA_DIR/AN_PL/$an/v.$an$mois.aph$suf.nc"
fileq="$ANA_DIR/AN_PL/$an/r.$an$mois.aph$suf.nc"
filet="$ANA_DIR/AN_PL/$an/ta.$an$mois.aph$suf.nc"
echo  fileu=$fileu
echo  filev=$filev

###################################################################3
# script ferret pour interpolation
###################################################################3

outd=GUIDE/$an/$mois
mkdir -p $outd
ij="i=1:$iip1,j=1:$jjp1"
ijm="i=1:$iip1,j=1:$jjm"

cat <<eod>| tmp.jnl
set memory/size=50
use "$GRID_FI"
use "$fileu"
use "$filev"
use "$filet"
use "$fileq"
let uwnd=$varu
let vwnd=$varv
let air='T' ! ancienne astuce pour le cas ou la temperature est t
let air=$vart
let rh=$varq
let sp=$varp
define axis/t="1-${month}-${an}:00:00":"${nday}-${month}-${an}:18:00":6/units=hours thour
define grid/like=uwnd[d=2]/x=grille_u[d=1]/y=grille_u[d=1] grille_u
define grid/like=vwnd[d=3]/x=grille_v[d=1]/y=grille_v[d=1] grille_v
define grid/like=air[d=4]/x=grille_v[d=1]/y=grille_u[d=1] grille_T
save/clobber/file="$outd/hur.nc" r[d=5,g=grille_T,$ij,$t0,gt=thour@asn]
repeat/$t1tn save/file="$outd/hur.nc"/append r[d=5,g=grille_T,$ij,gt=thour@asn]
save/clobber/file="$outd/T.nc" air[d=4,g=grille_T,$ij,$t0,gt=thour@asn]
repeat/$t1tn save/file="$outd/T.nc"/append air[d=4,g=grille_T,$ij,gt=thour@asn]
save/clobber/file="$outd/u.nc" uwnd[d=2,g=grille_u,$ij,$t0,gt=thour@asn]
repeat/$t1tn save/file="$outd/u.nc"/append uwnd[d=2,g=grille_u,$ij,gt=thour@asn]
save/clobber/file="$outd/v.nc" vwnd[d=3,g=grille_v,$ijm,$t0,gt=thour@asn]
repeat/$t1tn save/file="$outd/v.nc"/append vwnd[d=3,g=grille_v,$ijm,gt=thour@asn]
eod

ferret -nojnl <<eod
go tmp.jnl
quit
eod

echo AN MTH $an $mois
(( mth = $mth + 1 ))
if [ $mois = 12 ] ; then
   (( an = $an + 1 ))
   mth=${an}01
fi

done
