#!/bin/bash

#set -vx

sed -i -e 's/hostname=.*.$/hostname='`hostname`'/' lmdz_env.sh
. lmdz_env.sh
module list

# Pour les post-traitements
sed -i'' -e 's/groupe@cpu/'$groupe'@cpu/' seasonal.sh
local=`pwd`

##############################################################

##############################################################
# Choices : name, nudging, calendar ...
##############################################################
SIM=`basename \`pwd\``CTL
phylmd=lmd #option -p $phylmd for makelmdz
ok_guide=n
veget=y
cosp=n
xios=n

# If wanting to change the Orchidee revision number.
# 3013, 4470 , 5004
orchidee_rev=5004
climato=1
freq=mo  # frequence mensuelle mo ou annuelle yr

# With nudging, real calendar and monthly integrations
mthini=200001
mthend=200501
resol=144x142x79

svn=""
version=20160614.trunk

install=0
init=0

LIMIT=LIMIT


##############################################################
# Controling compilation
##############################################################
fcm=-nofcm
fcm=""
optim="-debug"
optim=""
if [ "$ARCH" = "" ] ; then arch= ; else arch="-arch $ARCH" ; fi
##############################################################

if [ $veget = y ] ; then
  opt_veget=' -v orchidee2.0 -cpp ORCHIDEE_NOZ0H '
  suforch='_orch'
else
  opt_veget=""
  suforch=''
fi

##############################################################
# options
##############################################################

while (($# > 0))
   do
   case $1 in
     "-h") cat <<........fin
           lance.sh [-v version] [-r svn_release] [-init INIT] [-d 96x95x79] [-f mo] [-nudging]
           "version" like 20150828.trunk ; see http://www.lmd.jussieu.fr/~lmdz/Distrib/LISMOI.trunk
           "svn_release"      either the svn release number or "last"
           -d IMxJMxLM        to run in resolution IM x JM x LM
           -install           pour installer et compiler le modele
           -f mo/yr           pour tourner en mensuel ou annuel
           "INIT"             1: creates INIT and LIMIT
                              0: reads from INIT and LIMIT
                              SIMU: reads from preexisting simulation SIMU and LIMIT
           -nudging           to run with nudging. Nudging files must be created independently
........fin
     exit ;;
     "-v") version=$2 ; shift ; shift ;;
     "-r") svn=$2 ; shift ; shift ;;
     "-d") resol=$2 ; shift ; shift ;;
     "-f") freq=$2 ; shift ; shift ;;
     "-install") install=1 ; shift ;;
     "-wrkgcm") LMDZD=$2 ; shift ; shift ;;
     "-name") SIM=$2 ; shift ; shift ;;
     "-cosp") cosp=y ; shift ;;
     "-xios") xios=y ; shift ;;
     "-init") init=$2 ; shift ; shift ;;
     "-nudging") ok_guide=y ; shift ;;
     "-climato") climato=$2 ; shift ; shift ;;
     "-mthini") mthini=$2 ; shift ; shift ;;
     "-mthend") mthend=$2 ; shift ; shift ;;
     *) $0 -h ; exit
   esac
done

# Three options for initialisation
# 1: Create INIT
# 0: Take from INIT
# DIR : Take from DIR
if [ $init = 1 -o $init = 0 ] ; then
   INIT=INIT
else
   INIT=$init
fi

if [ $ok_guide = y -a $climato = 1 ] ; then
   echo "================================================================"
   echo Running nudged simulations with climatological SSTs
   echo is not planned. Change climato to 0 or modify the setup \(experts\)
   echo "================================================================"
   exit
fi

if [ $climato = 0 -a $freq = yr ] ; then
   echo "================================================================"
   echo running simulations with interannual SSTs is possible only
   echo month by moonth and a true calendar.
   echo Change climato to 1 or freq to mo or modify setup.sh \(experts\)
   echo "================================================================"
   exit
fi

if [ "$svn" = "" ] ; then svnopt="" ; else svnopt="-r $svn" ; fi


if [ -d $SIM ] ; then
   echo La simulation $SIM existe deja
   echo Il est preferable d arreter et de verifier.
   echo Si vous etes sur de vous, vous pouvez la prolonger
   echo Voulez vous la prolonger '? (y/o)' 
   read ans
   if [ $ans != y -a $ans != o ] ; then
      exit
   fi
fi

yearini=`echo $mthini | cut -c-4`
if [ $freq = yr ] ; then stopsim=`echo $mthend | cut -c-4` ; else stopsim=$mthend ; fi

########################################################################
# Recuperation ou compilation du GCM
########################################################################
if [ ! -d $LMDZD ] ; then mkdir -p $LMDZD ; fi


LMDZname=LMDZ$version${svn}$optim
if [ "$orchidee_rev" != "" ] ; then
   LMDZname=${LMDZname}OR$orchidee_rev
   ins_orch="-orchidee_rev $orchidee_rev"
fi
MODEL=$LMDZD/$LMDZname/modipsl/modeles/LMDZ


if [ $cosp = y ] ; then
   opt_cosp="-cosp true" ; ins_cosp="-cosp"
else
   opt_cosp=""           ; ins_cosp=""
fi

if [ $xios = y ] ; then ins_xios="-xios" ; else ins_xios="" ; fi

if [ $install = 1 ] ; then
   if [ -d $MODEL ] ; then
      echo "Vous essayez d installer une version deja presente"
      exit
   else
      echo On installe le modele
      cd $LMDZD
      echo wget http://www.lmd.jussieu.fr/~lmdz/pub/install_lmdz.sh
      \rm -f install_lmdz.sh
      wget --no-cache http://www.lmd.jussieu.fr/~lmdz/pub/install_lmdz.sh
      chmod +x install_lmdz.sh
      ./install_lmdz.sh $fcm $optim -v $version $svnopt -d $resol -bench 0 -parallel mpi_omp $ins_cosp $ins_xios $ins_orch -name $LMDZname -env_file $local/lmdz_env.sh
      mv install_lmdz.sh install_lmdz.$$
      cd $local
   fi
else
   if [ ! -d $MODEL ] ; then
      echo Le model $MODEL n est pas installe
      echo relancer avec install=1 si vous voulez l installer automatiquement
      exit
   fi
fi


#######################################################################
# Compilation du modele
#######################################################################
gcm=$MODEL/bin/gcm_${resol}_phy${phylmd}_para_mem${suforch}.e
if [ ! -f $gcm  ] ; then
   echo Le model $gcm n existe pas
   echo il va se compiler automatiquement sur $MODEL
   sleep 10
   cd $MODEL
   if [ "$fcm" = "-nofcm" ] ; then
      ./makelmdz $optim -p $phylmd $opt_cosp -rrtm true $arch  -d $resol $opt_veget -mem -parallel mpi_omp $arch  gcm ; mkdir -p bin ; \mv -f gcm.e $gcm
   else
      ./makelmdz_fcm $optim -p $phylmd $opt_cosp -rrtm true $arch  -j 8 -d $resol $opt_veget -mem -parallel mpi_omp $arch  gcm
   fi
   if [ ! -f $gcm ] ; then echo la compilation a echoue ; exit ; fi
   cd $local
fi


######################################################################
# Choix du nombre de processeurs
jm=`echo $resol | cut -dx -f2`
(( mpi = ( $jm + 1 ) / 2 ))
omp=8
if [ $mpi -gt $nb_mpi_max ] ; then mpi=$nb_mpi_max ; fi
if [ $omp -gt $nb_omp_max ] ; then omp=$nb_omp_max ; fi

######################################################################
# Choix de la grille verticale
######################################################################
if [ ! -d DEF ] ; then echo Recuperer un repertoire DEF ; exit ; fi
lm=`echo $resol | cut -dx -f3`
if [ ! -f DEF/L$lm.def ] ; then echo resolution verticale non prevu
                                 echo creer un fichier DEF/L$lm.def
   exit
else
   sed -i -e 's/INCLUDEDEF=L.*.def/INCLUDEDEF=L'$lm'.def/' DEF/run.def
fi
if [ $cosp = y ] ; then
   sed -i -e 's/ok_cosp.*.$/ok_cosp=y/' DEF/config.def
   \cp -f $MODEL/DefLists/cosp_input_nl.txt $local/DEF/
   \cp -f $MODEL/DefLists/cosp_output_nl.txt $local/DEF/
fi


######################################################################
# Verification de l'existance de l'etat unitial et compilation eventuelle
# pour sa creation
######################################################################
if [ ! -d $INIT ] ; then 
   if [ $init = 0 ] ; then
      echo  Recuperer les repertoires $INIT ou lancer avec option -init ; exit
   else
      cd $MODEL
      ce0l=$MODEL/bin/ce0l_${resol}_phy${phylmd}_para_mem${suforch}.e
      if [ "$fcm" = "-nofcm" ] ; then
          ./makelmdz $optim -p $phylmd -rrtm true $arch  -d $resol $opt_veget -mem -parallel mpi_omp $arch  ce0l ; mkdir -p bin ; \mv -f ce0l.e $ce0l
      else
         ./makelmdz_fcm $optim -p $phylmd -rrtm true $arch  -j 8 -d $resol $opt_veget -mem -parallel mpi_omp $arch  ce0l
      fi
      cd $local
   fi
elif [ $init = 1 ] ; then
   echo Vous essayer d initialiser le modele mais $INIT existe deja
   exit
fi

MAINDIR=`basename \`pwd\``


######################################################################
# On cree sur le SCRATCHD un repertoir de travail avec le meme
# nom que le repertoire local
######################################################################
. ./lmdz_env.sh
WRK=$SCRATCHD/$MAINDIR
mkdir -p $WRK
cd $WRK
echo La simuation s executera sur $SCRATCHD/$MAINDIR

#####################################################################
# Creation du repertoire $SIM s il n'existe pas deja
#####################################################################

if [ ! -d $local/$SIM ] ; then
mkdir $local/$SIM
cd $local
sed -e 's/compilo=.*.$/compilo='$compilo'/' -e 's:^rebuild=.*.$:rebuild='$LMDZD/$LMDZname/modipsl/bin/rebuild':' -e 's/groupe@cpu/'$groupe'@cpu/' reb.sh  >| $local/$SIM/reb.sh ; chmod +x $local/$SIM/reb.sh
cp lmdz_env.sh $local/$SIM/
mkdir $local/$SIM/DEF ; cp DEF/*def DEF/cosp*txt $local/$SIM/DEF/
chmod u+w $local/$SIM/DEF/*

# Gestion du calendrier
#######################
sed -e 's/anneeref=.*.$/anneeref='$yearini'/' \
    DEF/run.def >| $local/$SIM/DEF/run.def
cd $SIM
if [ "$freq" = "yr" ] ; then date=$yearini ; else date=$mthini ; fi
if [ "$freq" = "yr" ] ; then cput=04:00:00 ; else cput=01:00:00 ; fi
echo $date a faire >| etat

# Recuperation des fichiers : executable initiaux et forcages
#############################################################
for f in start startphy ; do inf=../$INIT/$f.$date.nc ; if [ -f $inf -o $init = 1 ] ; then ln -s $inf ./ ; else echo $inf inexistant ; exit ; fi ; done
for f in sechiba stomate ; do if [ -f ../$INIT/start_$f.$date.nc ] ; then ln -sf  ../$INIT/start_$f.$date.nc . ; fi ; done
cp $gcm gcm.e
fi
cd $local/..


#####################################################################
echo Modification du script de lancement
###################################################################/$S

sed -e 's/stopsim=.*.$/stopsim='$stopsim'/' -e 's/INIT/'$INIT'/' -e 's/^veget=.*.$/veget='$veget'/' -e 's/NOM_SIMU/'$SIM'/' -e 's/\-\-time.*.$/--time='$cput'/' -e 's/MAINDIR=.*.$/MAINDIR='$MAINDIR'/' -e 's:STORED=.*.*:STORED='$STORED':'  -e 's:SCRATCHD=.*.*:SCRATCHD='$SCRATCHD':' -e 's/ntasks=.*.$/ntasks='$mpi'/' -e 's/cpus-per-task=.*.$/cpus-per-task='$omp'/' -e 's/nthreads=.*./nthreads='$omp'/' -e 's/^climato=.*.$/climato='$climato'/' -e 's/^ok_guide=.*.$/ok_guide='$ok_guide'/' -e 's/^compilo=.*.$/compilo='$compilo'/' -e 's/groupe@cpu/'$groupe'@cpu/' $local/script_SIMU >| $WRK/tmp_$SIM


if [ $climato = 0 ] ; then
calend=gregorian
yrini=`echo $mthini | cut -c-4`
yrend=`echo $mthend | cut -c-4`
yrs="" ; yr=$yrini ; while [ $yr -le $yrend ] ; do yrs="$yrs $yr" ; (( yr = $yr + 1 )) ; done
suf=360x180_
else
calend=earth_360d
yrs=2000
suf=1x1_clim
fi

#####################################################################
   echo Recuperation eventuelle de certains fichiers sur LMDZ_Init
#####################################################################

for file in PFTmap_IPCC_2000.nc cartepente2d_15min.nc \
          routing.nc lai2D.nc soils_param.nc \
          aerosols1850_from_inca.nc aerosols2000_from_inca.nc \
          woodharvest_2000.nc \
          PFTmap_15PFT.v1_2000.nc \
          alb_bg_modisopt_2D_ESA_v2.nc reftemp.nc ; do
          if [ ! -f $LMDZ_Init/$file ] ; then
              mkdir $LMDZ_Init ; cd $LMDZ_Init
              wget http://www.lmd.jussieu.fr/~lmdz/LMDZ_Init/$file
              cd -
          fi
done
cd $local



if [ $init = 1 ] ; then
   #####################################################################
      echo Creation de l etat initial
   #####################################################################

   # Creation du repertoire INIT et mise en place de liens logiques vers les starts
   # en anticipation de leur création :
   mkdir $local/$INIT ; cd $local/$INIT
   for an in $mthini $yearini ; do for f in start startphy ; do ln -s $f.nc $f.$an.nc ; done ; done

   # Creation du repertoire INIT temporaire et rapatriement des fichiers necessaires
   if [ -d $WRK/$INIT ] ; then mv $WRK/$INIT $WRK/$INIT$$ ; fi
   mkdir $WRK/$INIT ; cd .. ;  cp -r DEF $WRK/$INIT/
   cd $WRK/$INIT ; cp DEF/* . ; cp $local/lmdz_env.sh .
   sed -e 's/anneeref=.*.$/anneeref='$yearini'/' DEF/run.def >| run.def
   get="wget http://www.lmd.jussieu.fr/~lmdz/LMDZ_Init/"
   liste_get="Albedo.nc ECDYN.nc Relief.nc Rugos.nc landiceref.nc"
   for yr in $yrs ; do
       if [ $climato = 0 ] ; then sufyr=$suf$yr ; else sufyr=$suf ; fi
       liste_get="$liste_get  amipbc_sic_$sufyr.nc amipbc_sst_$sufyr.nc"
   done
   echo LISTEGET $liste_get
   for file in $liste_get ; do
     if [ ! -f $LMDZ_Init/$file ] ; then cd $LMDZ_Init ; ${get}$file ; cd - ; fi
     ln -s $LMDZ_Init/$file
   done
   ln -sf ECDYN.nc ECPHY.nc

   # Creation du script d'initialisation
   cat <<...eod>| tmp
#!/bin/bash

#SBATCH --job-name=Init         # nom du job
#SBATCH -A "$groupe"@cpu
#SBATCH --ntasks=1             # Nombre de processus MPI
#SBATCH --cpus-per-task=16     # nombre de threads OpenMP
# /!\ Attention, la ligne suivante est trompeuse mais dans le vocabulaire
# de Slurm "multithread" fait bien rÃ©fÃ©rence Ã  l'hyperthreading.
#SBATCH --hint=nomultithread   # 1 thread par coeur physique (pas d'hyperthreading)
#SBATCH --time=00:10:00            # Temps dâ€™exÃ©cution maximum demandÃ© (HH:MM:SS)
#SBATCH --output=Init%j.out     # Nom du fichier de sortie
#SBATCH --error=Init%j.out      # Nom du fichier d'erreur (ici commun avec la sortie)


# ANCIEN MULTI STEP  case \${LOADL_STEP_NAME} in

# ANCIEN MULTI STEP   init )

   if [ ! -f lmdz_env.sh ] ; then echo manque fichier lmdz_env.sh ; ls ; exit ; fi
   . lmdz_env.sh
   ulimit -s unlimited
   export OMP_STACKSIZE=800M
   export OMP_NUM_THREADS=1
   cd $WRK/$INIT
   echo Executable : $ce0l
   for yr in $yrs ; do 
      if [ $climato = 0 ] ; then sufyr=$suf\$yr ; else sufyr=$suf ; fi
      ln -sf amipbc_sic_\$sufyr.nc amipbc_sic_1x1.nc
      ln -sf amipbc_sst_\$sufyr.nc amipbc_sst_1x1.nc
      # if [ $climato = 1 ] ; then calend=earth_360d ; elif [ \$(( \$yr % 4 )) = 0 ] ; then calend=earth_366d ; else calend=earth_365d ; fi
      sed -e 's/anneeref=.*.$/anneeref='\$yr'/' -e 's/^calend=.*.$/calend='$calend'/' DEF/run.def >| run.def
      $run 1 $ce0l
      if [ $climato = 0 ] ; then mv limit.nc limit.\$yr.nc ; fi
   done
# ANCIEN MULTI STEP    ;;

# ANCIEN MULTI STEP   interp )
    cp $local/interp_aerosols.sh . ; chmod +x interp_aerosols.sh
    for year in 2000 1850 ; do  ./interp_aerosols.sh \$year ; done
    mv aerosols.2000.nc aerosols.clim.nc ; mv aerosols.1850.nc aerosols.nat.nc
   for f in sta* limit.nc gri*nc ; do cp \$f $local/$INIT/\$f ; done
    mkdir -p $local/$LIMIT
   for f in aerosols[.0-9]*nc ; do cp \$f $local/$LIMIT/\$f ; done
   for f in limit*.nc  ; do cp \$f $local/$LIMIT/\$f ; done
   cd $WRK
...eod
   if [ $ok_guide != y ] ; then # Runing first simulation automatically except for nudging
      cat <<...eod>> tmp
         $submit tmp_$SIM
...eod
   fi
   cat <<...eod>> tmp
# ANCIEN MULTI STEP   esac
...eod

   echo '###############################################################################'
   echo Submitting initialisation job
pwd
   $submit tmp
   echo '###############################################################################'

else

   cd $WRK
   echo '###############################################################################'
   echo Submitting job tmp_$SIM
   $submit tmp_$SIM
   echo '###############################################################################'
fi


if [ $ok_guide = y -a $init = 1 ] ; then
   echo Once initialisation is finished, you have to create nudging files with
   echo era2gcm.sh -mthini $mthini -mthend $mthend
else
   echo Si tout se passe bien, vous avez initialise et lance automatiquement
   echo la simulation.
   echo Si vous voulez modifier les caracteristiques tu job, comme le temps
   echo max ou le nombre de proc, il se trouve sur
   echo $SCRATCHD/$MAINDIR/tmp_$SIM
fi
 
