#!/bin/csh

set listecas=( 00WC 05WC 00SC 03SC  05SC  24SC  24F 15B 24B )
set wtmin=(  -0.01 -0.02 -0.01 -0.02 -0.02 -0.1 -0.1 -0.1 -0.1 )
set wtmax=(   0.01  0.06  0.01  0.04  0.06  0.3  0.3  0.2  0.3 )

set dir=`pwd`


set lmax=25
set modele=ayotte2


set lmax=80
set modele=ayotte

set SIM=$1

cd $SIM
../traite.x

####################################################################
#   INITIALISATION DU FICHIER LATEX DE SORTIES.
####################################################################


if  ( 0 == 0 ) then

set amongcas=" 2 5 6 7 "
cat << eod > ! resua.tex
\documentclass{article}
\usepackage{a4}
\textheight 27cm
\topmargin -2cm
\def\sizea{3.5cm}
\def\sizeb{7cm}
eod


else
set amongcas=" 2 6 "
cat << eod > ! resua.tex
\documentclass{article}
\usepackage{a4}
\usepackage[landscape]{geometry}
\textwidth 27cm
\oddsidemargin -2cm
\topmargin -3cm
\textheight 20cm
\def\sizea{5cm}
\def\sizeb{8cm}
eod
endif

cat <<eod>> resua.tex
\pagestyle{empty}
\usepackage{graphicx}
\begin{document}
\begin{verbatim}
eod


echo SIMULATIONS $SIM >> resua.tex
echo $dir >> resua.tex

cat << eod >> resua.tex
\end{verbatim}

\def\legsz{\footnotesize}
\def\legendes{\\legsz \$\\theta K\$ &\\legsz \$w'\\theta'\$ &\\legsz B &\\legsz C &\\legsz u (m~s\$^{-1}\$) &\\legsz v (m~s\$^{-1}\$)\normalsize}

\begin{center}
\begin{tabular}{cccccc}
eod



####################################################################
#  DEBUT DE LA BOUCLE SUR LES CAS
####################################################################

set  zmax=( 1.400    1.500    0.700     0.700     0.700     1.500    1.500     1.500    1.500 )

foreach c ( 1 2 3 4 5 6 7 8 9 )
set cas=$listecas[$c]


echo CAS $cas

set descr=`grep $cas ../description`
set wt0=`echo $descr | awk ' { print $2 } '`
set Ug=`echo $descr | awk ' { print $3 } '`
set Vg=`echo $descr | awk ' { print $4 } '`
set t0=`echo $descr | awk ' { print $5 } '`
set t1=`echo $descr | awk ' { print $6 } '`
set dt=`echo $descr | awk ' { print $7 } '`
set ustar=`echo $descr | awk ' { print $8 } '`
cd $cas

set data=/home/hourdin/TEX/HABIL/therm/AYOTTE/DONNEES/LES$cas

if ( 1 == 1 ) then
set umin=5
set umax=16
set vmin=-1
set vmax=3
set tmin=299
set tmax=310
set bmin=0
set bmax=18
set cmin=-0.5
set cmax=1.5

if ( $cas == 24B ) then
set vmin=2
set vmax=14
set umin=4
set umax=11
endif

if ( $cas == 05WC ) then
set tmax=304
endif

set simc=`echo $SIM | cut -c-1`

set simu=$SIM

echo MODELE $simu
../../xmgr.x $umin $umax $zmax[$c] 0.5 u $data/um um $data/u0
../../xmgr.x $vmin $vmax $zmax[$c] 0.4 v $data/vm vm $data/v0
../../xmgrz.x $tmin $tmax $zmax[$c] 0.6 temp on $simu $data/tm tm $data/t0
../../xmgr.x $bmin $bmax $zmax[$c] 0.3 B $data/bm bm $data/b0
../../xmgr.x $cmin $cmax $zmax[$c] 0.3 C $data/cm cm $data/c0

../../xmgr.x $wtmin[$c] $wtmax[$c] $zmax[$c] 0.6 flux $data/wtm wttot wtnul wtvdf wtthe

endif
cd ..

end

foreach c ( $amongcas )
set cas=$listecas[$c]

########################################################################
# fin des fichiers Latex ###############################################
########################################################################
cat <<eod>> resua.tex
$cas &
\\multicolumn{5}{c}{ - - - - : t=0 ;  ----- (LES) and  {\bf\huge --} GCM  }\\\
\includegraphics[clip,height=\sizea]{$cas/temp.eps}&
\includegraphics[clip,height=\sizea]{$cas/flux.eps} &
\includegraphics[clip,height=\sizea]{$cas/B.eps} &
\includegraphics[clip,height=\sizea]{$cas/C.eps} &
\includegraphics[clip,height=\sizea]{$cas/u.eps} &
\includegraphics[clip,height=\sizea]{$cas/v.eps} \\\\
\\legendes\\\\
eod

end
########################################################################
echo OK OK OK OK

cat <<eod>> resua.tex

\end{tabular}
\end{center}

\centerline{\begin{tabular}{cc}
A1 \$ \\theta \$ & A1 traceur B \\\\
\includegraphics[clip,width=\sizeb]{a1t.eps} & \includegraphics[clip,width=\sizeb]{a1c.eps}
\end{tabular}}
\end{document}

eod

pwd
echo latex resua
latex resua
dvipdf resua
# gzip resua.ps
#evince resua.pdf

