#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on 01 October 2020

@author: Etienne Vignon
"""

## COMBKE SCM-enabled case definition

import numpy as np
import netCDF4 as nc
from dephycf.Case import Case

################################################
# 0. General configuration of the present script
################################################

lplot = True     # plot the new version of the case
lcompare = True  # plot comparisons between original and new versions
lverbose = True # print information on variables and case

################################################
# 1. Get the original version of the case
################################################

# initialize the case structure for the original version
case = Case('COMBLE/REF')

# read case information in file
case.read('COMBLE_REF_DEF_driver.nc')

# display some information about the case
if lverbose:
    case.info()

################################################
# 2. Interpolate onto a new grid, same for all the variables
#    and add new variables if needed
################################################

# grid onto which interpolate the input data
timeout=np.arange(0,72000,3600)
fin = nc.Dataset('COMBLE_INTERCOMPARISON_FORCING_V2.4.nc','r')
z=np.array(np.squeeze(fin['lev'][:]))
print(z)

# conversion
newcase = case.convert2SCM(time=timeout,lev=z,levtype='altitude')


# update some attributes
newcase.set_title("Forcing and initial conditions for COMBLE/REF case - SCM-enabled version")
newcase.set_script("driver_SCM.py")

# display some information about the new version of the case
if lverbose:
    newcase.info()



################################################
# 3. Save new version of the case in netcdf file
################################################
# save the new version of the case in netcdf file 
newcase.write('COMBLE_REF_SCM_driver.nc')

################################################
# 4. Plots if asked
################################################

if lplot:
    newcase.plot(rep_images='./images/driver_SCM/',timeunits='hours')

if lcompare:
    newcase.plot_compare(case,rep_images='./images/compare/',label1="SCM-enabled",label2="Original",timeunits='hours')
