#!/bin/bash

date="24-JUN-1969 04:00:00"

if [ ! -f Sample.nc ] ; then ln -s ../../../CAS/$cas/Sample.nc . ; fi


cat <<eod>| edopen.jnl
reg/t="$date"
use Sample.nc
use hourly.nc
eod

cat <<eod>| ed1.jnl
go edopen.jnl
set v left
plot/vs/line=13/d=1/hlim=0:0.01/vlim=0:2.8/title="E/f (LES)" entr,zz/1000
plot/vs/line=14/d=2/o/title="E/f(SCM)" e_th/(geop[k=@shf:-1]-geop[k=@shf:+1])*2*9.81/f_th,geop/9810
plot/vs/line=1/d=1/o/title="D/f(LES)" detr,zz/1000
plot/vs/line=2/d=2/o/title="D/f(SCM)" d_th/(geop[k=@shf:-1]-geop[k=@shf:+1])*2*9.81/f_th,geop/9810
set v right
plot/vs/line=13/d=1/hlim=0:20/vlim=0:2.8/title="QV(g/kg), LES"  alpha*rta+(1-alpha)*rte,zz/1000
plot/vs/line=14/d=2/o/title="QV, SCM" ovap*1000,geop/9800
plot/vs/line=1/d=1/o/title="QVa, LES"  rta,zz/1000
plot/vs/line=2/d=2/o/title="QVa, SCM" q_th*1000,geop/9800
eod

cat <<eod>| ed2.jnl
go edopen.jnl
set v left
plot/vs/line=13/d=1/hlim=0:.5/vlim=0:2.8/title="alpha LES" alpha,zz/1000
plot/vs/line=14/d=2/o/title="alpha SCM" a_th,geop/9810
plot/vs/line=1/d=1/o/title="f LES" wa*rho*alpha,zz/1000
plot/vs/line=2/d=2/o/title="f SCM" f_th,geop/9810
set v right
plot/vs/line=13/d=1/hlim=0:5/vlim=0:2.8/title="W th LES (m/s)" wa,zz/1000
plot/vs/line=14/d=2/o/title="W SCM" w_th,geop/9810
eod

for i in 1 2 ; do
\rm -f tmp.ps
ferret -batch tmp.ps -script ed$i.jnl
ps2epsi tmp.ps
epstopdf tmp.epsi 
\mv -f tmp.pdf ed$i.pdf
done

pdfjam --nup 2x2 ed[12].pdf tmp[12].pdf --outfile tout.pdf
