import numpy as np

timeF= [0.,10800.,21600.]
ntf = len(timeF)
zforc = [16., 51.4, 86.9, 122.6, 158.4, 212.3, 284.7, 357.7, 431.2, 505.2, 579.9, 655.1, 769.0, 923.1, 1079.8, 1239.0, 1401.0, 1586.6, 1797.2, 2122.2, 2574.1, 3049.3, 3811.9, 4500.]
nzf = len(zforc)

ug = np.zeros((ntf,nzf),dtype=np.float64)
vg = np.zeros((ntf,nzf),dtype=np.float64)
w = np.zeros((ntf,nzf),dtype=np.float64)
thadv = np.zeros((ntf,nzf),dtype=np.float64)
rvadv = np.zeros((ntf,nzf),dtype=np.float64)
ug[0,:]=[-0.5,-0.6,-0.9,-1.1,-1.3,-1.5,-1.8,-2.2,-2.3,-2.2,-2.0,-1.8,-1.4,-0.9,-0.6,-0.5,-1.0,-1.9,-2.4,-1.3,2.3,6.2,12.1,19.0]
ug[1,:]=[-0.9,-0.9,-0.9,-0.9,-0.8,-0.8,-0.8,-0.8,-0.8,-0.8,-0.7,-0.5,-0.0,0.5,0.7,0.4,-0.1,0.1,0.9,2.3,5.0,7.3,12.1,17.0]
ug[2,:]=[-3.8,-3.8,-3.8,-3.8,-3.8,-3.7,-3.7,-3.6,-3.6,-3.5,-3.5,-3.4,-3.2,-2.9,-2.4,-1.5,-0.4,1.3,2.5,2.7,4.4,7.4,9.9,13.0]
vg[0,:]=[-2.6,-2.7,-2.8,-2.7,-2.7,-2.6,-2.4,-2.0,-1.6,-1.5,-1.5,-1.5,-1.9,-2.5,-3.2,-3.9,-4.4,-5.1,-5.8,-6.3,-7.5,-10.1,-12.7,-15.0]
vg[1,:]=[-2.3,-2.3,-2.3,-2.3,-2.3,-2.3,-2.3,-2.2,-2.2,-2.0,-1.8,-1.7,-1.5,-1.5,-1.4,-1.3,-1.6,-2.7,-4.1,-5.3,-6.7,-9.8,-11.5,-14.0]
vg[2,:]=[-0.8,-0.7,-0.7,-0.7,-0.7,-0.6,-0.6,-0.6,-0.5,-0.4,-0.4,-0.3,-0.2,0.1,0.4,0.9,1.5,1.0,-0.8,-2.8,-4.1,-5.8,-10.2,-14.0]
w[0,:]=[0.000,0.000,0.000,0.000,0.000,0.000,-0.005,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.005,0.000]
w[1,:]=[0.000,0.000,0.000,0.000,0.000,0.000,-0.000,-0.000,-0.000,-0.003,-0.006,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.005,0.000]
w[2,:]=[0.000,0.000,0.000,0.000,0.000,0.000,-0.000,-0.000,-0.000,-0.000,-0.001,-0.002,-0.004,-0.006,-0.008,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.010,-0.005,0.000]
thadv[0,:]=[-0.00004,-0.00004,-0.00004,-0.00004,-0.00004,-0.00004,-0.00004,-0.00004,-0.00004,-0.00003,-0.00002,-0.00002,-0.00002,-0.00002,-0.00002,-0.00002,-0.00002,-0.00002,-0.00003,-0.00007,-0.00008,-0.00010,-0.00007,-0.00005]
thadv[1,:]=[-0.00004,-0.00004,-0.00004,-0.00004,-0.00004,-0.00004,-0.00004,-0.00004,-0.00004,-0.00004,-0.00003,-0.00003,-0.00002,-0.00002,-0.00001,-0.00000,-0.00001,-0.00003,-0.00004,-0.00005,-0.00006,-0.00010,-0.00007,-0.00005]
thadv[2,:]=[-0.00004,-0.00004,-0.00004,-0.00004,-0.00004,-0.00004,-0.00004,-0.00003,-0.00003,-0.00003,-0.00003,-0.00003,-0.00002,-0.00002,-0.00001,0.00000,-0.00001,-0.00002,-0.00005,-0.00003,-0.00004,-0.00011,-0.00008,-0.00005]
rvadv[0,:]=[-0.00000002,-0.00000002,-0.00000003,-0.00000003,-0.00000003,-0.00000003,-0.00000003,-0.00000003,-0.00000003,-0.00000003,-0.00000003,-0.00000003,-0.00000003,-0.00000003,-0.00000005,-0.00000006,-0.00000007,-0.00000008,-0.00000009,-0.00000007,-0.00000006,-0.00000000,0.00000000,-0.00000000]
rvadv[1,:]=[-0.00000004,-0.00000004,-0.00000004,-0.00000004,-0.00000004,-0.00000004,-0.00000004,-0.00000004,-0.00000003,-0.00000003,-0.00000003,-0.00000003,-0.00000002,-0.00000002,-0.00000002,-0.00000002,-0.00000001,-0.00000001,-0.00000002,-0.00000005,-0.00000002,0.00000004,0.00000001,0.00000000]
rvadv[2,:]=[-0.00000002,-0.00000002,-0.00000002,-0.00000002,-0.00000002,-0.00000002,-0.00000002,-0.00000002,-0.00000002,-0.00000001,-0.00000001,-0.00000001,-0.00000001,-0.00000000,0.00000000,0.00000001,0.00000002,0.00000006,0.00000008,-0.00000002,-0.00000005,-0.00000001,0.00000001,0.00000000]


f = open('atm_forcing.txt','w')

header = '{0:>8} {1:>6} {2:>6} {3:>8} {4:>12} {5:>12}\n'.format('z','ug','vg','w','theta_adv','rv_adv')
f.write(header)

for it in range(0,ntf):
    comment = '# Forcing time: {0:>6}\n'.format(timeF[it])
    f.write(comment)
    for ilev in range(0,nzf):
        line = '{0:8.2f} {1:6.2f} {2:6.2f} {3:8.4f} {4:12.8f} {5:12.8f}\n'.format(zforc[ilev],ug[it,ilev],vg[it,ilev],w[it,ilev],thadv[it,ilev],rvadv[it,ilev])
        f.write(line)

f.close()


XTIMEF = np.zeros(24+1)
XSFTH = np.zeros(24+1)
XSFTQ = np.zeros(24+1)

XTIMEF[1]=0.
XTIMEF[2]=3600.
XTIMEF[3]=7200.
XTIMEF[4]=10800.
XTIMEF[5]=14400.
XTIMEF[6]=18000.
XTIMEF[7]=21600.
XTIMEF[8]=25200.
XTIMEF[9]=28800.
XTIMEF[10]=32400.
XTIMEF[11]=36000.
XTIMEF[12]=39600.
XTIMEF[13]=43200.
XTIMEF[14]=46800.
XTIMEF[15]=50400.
XTIMEF[16]=54000.
XTIMEF[17]=57600.
XTIMEF[18]=61200.
XTIMEF[19]=64800.
XTIMEF[20]=68400.
XTIMEF[21]=72000.
XTIMEF[22]=75600.
XTIMEF[23]=79200.
XTIMEF[24]=82800.
XSFTH[1]=5.0
XSFTH[2]=35.0
XSFTH[3]=80.0
XSFTH[4]=126.0
XSFTH[5]=149.0
XSFTH[6]=172.0
XSFTH[7]=197.0
XSFTH[8]=214.0
XSFTH[9]=203.0
XSFTH[10]=188.0
XSFTH[11]=150.0
XSFTH[12]=87.0
XSFTH[13]=31.0
XSFTH[14]=6.0
XSFTH[15]=-5.0
XSFTH[16]=-10.0
XSFTH[17]=-4.0
XSFTH[18]=-2.0
XSFTH[19]=-13.0
XSFTH[20]=-14.0
XSFTH[21]=-7.0
XSFTH[22]=-11.0
XSFTH[23]=-13.0
XSFTH[24]=-4.0
XSFTQ[1]=22.00
XSFTQ[2]=64.00
XSFTQ[3]=87.5
XSFTQ[4]=113.0
XSFTQ[5]=135.0
XSFTQ[6]=153.0
XSFTQ[7]=168.0
XSFTQ[8]=179.0
XSFTQ[9]=166.0
XSFTQ[10]=149.0
XSFTQ[11]=128.0
XSFTQ[12]=83.0
XSFTQ[13]=50.0
XSFTQ[14]=30.0
XSFTQ[15]=32.0
XSFTQ[16]=16.
XSFTQ[17]=0.0
XSFTQ[18]=0.0
XSFTQ[19]=2.0
XSFTQ[20]=3.0
XSFTQ[21]=0.0
XSFTQ[22]=0.0
XSFTQ[23]=0.0
XSFTQ[24]=0.0


f = open('surface_forcing.txt','w')

header = '{0:>8} {1:>6} {2:>6}\n'.format('time','shf','lhf')
f.write(header)

for it in range(0,24):
    line = '{0:>8} {1:6.2f} {2:6.2f}\n'.format(XTIMEF[it+1],XSFTH[it+1],XSFTQ[it+1])
    f.write(line)

f.close()


