#!/bin/bash

cas=1

if [ $cas = 1 ] ; then
   listepbl=" 11 20 21 22 23 24 25 26 27 28 29"
   listecons=" 0 1 "
   FIGS=FPBL
else
   listpbl=11
   FIGS=FIGS
   listecons=" 0 -1 1 2 110 101"
fi

\rm -rf $FIGS
mkdir -p $FIGS

for cas in 1 2 ; do

for pbl in $listepbl ; do

if [ $cas = 1 ] ; then
   wtsurf=0.
else
   wtsurf=0.015
fi
cp -f lmdz1d.def tmp ; sed -e 's/wtsur.*.=.*.$/wtsurf='$wtsurf'/' tmp >| lmdz1d.def
cp -f physiq.def tmp ; sed -e 's/iflag_pbl*.=.*.$/iflag_pbl='$pbl'/' tmp >| physiq.def

dirout=CAS$cas.$pbl
mkdir -p $dirout

for cons in $listecons ; do

cat <<eod>| gcm.def
iflag_ener_conserv=$cons
day_step=144
iphysiq=1
eod

./lmdz1d.e > /dev/null
ncks -v cldt,precip,sens,flat,bils,bils_diss,bils_ec,bils_ech,bils_tke,bils_kinetic,bils_latent,bils_enthalp histhf.nc -O $dirout/cons$cons.nc

out=$FIGS/CAS$cas.cons$cons.$pbl.gif
\rm -f $out
ferret -nojnl <<eod
use "$dirout/cons$cons.nc"
set v upper ; plot/vlim=-6.:6./title="conservation $cons" bils_ec
plot/o bils_ech
plot/o bils_ec-bils_ech
plot/o/line=7 bils_enthalp+bils_kinetic+bils_tke+bils_latent+flat+sens
set view lower
plot/vlim=0.:0.3 cldt
frame/file="$out"
quit
eod

done
done
done
done
