
import os
import sys
import numpy as np
from matplotlib import dates
import datetime
import netCDF4 as nc4
import xarray as xr
import pandas as pd

path='/home/evignon/dw/LMDZ/LMDZ-CLOUD/1D/OBS/MPACE/REF/raw_data/arm-iop/2004/nsa/mpace/mcfarquhar-microphysics/'
file_list=[path+'1009a.txt',path+'1009b.txt',path+'1010.txt']
dateref_list=["2004-10-09 00:00:00","2004-10-09 00:00:00","2004-10-10 00:00:00"]


time_obs=[]
phase_obs=[]
lwc_obs=[]
iwc_obs=[]
cwc_obs=[]
re_w_obs=[]
re_i_obs=[]
number_w_obs=[]
number_i_obs=[]
temp_obs=[]
normalized_height_obs=[]

fmt='%Y-%m-%d %H:%M:%S'

for ind in range(len(file_list)):

    # read file
    ascii_file=file_list[ind]
    f = open(ascii_file, 'r') 

    for line in f:

        info=[x for x in line.split()]

        if info[0]=='starting':
       	    xx=float(info[2])
            tt=pd.to_datetime(dateref_list[ind],format=fmt)+pd.to_timedelta(xx,'S')
            time_obs=np.append(time_obs,tt)

        if info[0]=="phase":
            xx=float(info[2])
            phase_obs=np.append(phase_obs,xx)

        if info[0]=="temperature":
            xx=float(info[1])+273.15 # to K
            temp_obs=np.append(temp_obs,xx)

        if info[0]=="height":
            xx=float(info[1])
            normalized_height_obs=np.append(normalized_height_obs,xx)

        if info[0]=="cwc":
            xx=float(info[1])/1000. # to kg/m3
            cwc_obs=np.append(cwc_obs,xx)

        if info[0]=="lwc":
            xx=float(info[1])/1000. # to kg/m3
            lwc_obs=np.append(lwc_obs,xx)

        if info[0]=="iwc":
            xx=float(info[1])/1000. # to kg/m3
            iwc_obs=np.append(iwc_obs,xx)

        if info[0]=="re_w":
            xx=float(info[1])/1e6 # to m
            re_w_obs=np.append(re_w_obs,xx)

        if info[0]=="re_i":
            xx=float(info[1])/1e6 # to m
            re_i_obs=np.append(re_i_obs,xx)

        if info[0]=="number_w":
            xx=float(info[1])*1000. # to m-3
            number_w_obs=np.append(number_w_obs,xx)

        if info[0]=="number_i":
            xx=float(info[1])*1000. # to m-3
            number_i_obs=np.append(number_i_obs,xx)


# moyennage sur la normalized height avec 20 bins entre 0 et 1 (1bin=0.05)
# moyennage horaire sur les 2 jours
zbinvec=np.linspace(-1,1,40)


bibin=np.linspace(0,48,49)
tbinvec=[]

tt=pd.to_datetime(dateref_list[0],format=fmt)
for i in range(len(bibin)):
    tt=tt+pd.to_timedelta(1.,'H')
    tbinvec=np.append(tbinvec,tt)


z_vec=zbinvec[1::]
time_vec=tbinvec[1::]



# declaration des matrices temps-z

phase_mat=np.zeros((len(tbinvec)-1,len(zbinvec)-1))
temp_mat=np.zeros((len(tbinvec)-1,len(zbinvec)-1))
cwc_mat=np.zeros((len(tbinvec)-1,len(zbinvec)-1))
lwc_mat=np.zeros((len(tbinvec)-1,len(zbinvec)-1))
iwc_mat=np.zeros((len(tbinvec)-1,len(zbinvec)-1))
re_w_mat=np.zeros((len(tbinvec)-1,len(zbinvec)-1))
re_i_mat=np.zeros((len(tbinvec)-1,len(zbinvec)-1))
number_w_mat=np.zeros((len(tbinvec)-1,len(zbinvec)-1))
number_i_mat=np.zeros((len(tbinvec)-1,len(zbinvec)-1))

npoints_mat=np.zeros((len(tbinvec)-1,len(zbinvec)-1))


for i in range(len(time_vec)):
    for k in range(len(z_vec)):
        indici1=time_obs>=tbinvec[i]
        indici2=time_obs<tbinvec[i+1]
        indici=np.logical_and(indici1,indici2)
        indick1=normalized_height_obs>=zbinvec[k]
        indick2=normalized_height_obs<zbinvec[k+1]
        indick=np.logical_and(indick1,indick2)
        indic=np.logical_and(indici,indick)
        temp_mat[i,k]=np.mean(temp_obs[indic])
        cwc_mat[i,k]=np.mean(cwc_obs[indic])
        lwc_mat[i,k]=np.mean(lwc_obs[indic])
        iwc_mat[i,k]=np.mean(iwc_obs[indic])
        re_w_mat[i,k]=np.mean(re_w_obs[indic])
        re_i_mat[i,k]=np.mean(re_i_obs[indic])
        number_w_mat[i,k]=np.mean(number_w_obs[indic])
        number_i_mat[i,k]=np.mean(number_i_obs[indic])
        phase_mat[i,k]=np.mean(phase_obs[indic])
        npoints_mat[i,k]=len(phase_obs[indic])
        
   
        
# create a dataset

ds=xr.Dataset({'temp' :(['time','normalized_height'],temp_mat),
               'phase':(['time','normalized_height'],phase_mat),
               'cwc':(['time','normalized_height'],cwc_mat),
               'lwc':(['time','normalized_height'],lwc_mat),
               'iwc':(['time','normalized_height'],iwc_mat),
               're_w':(['time','normalized_height'],re_w_mat),
               're_i':(['time','normalized_height'],re_i_mat),
               'Nc':(['time','normalized_height'],number_w_mat),
               'Ni':(['time','normalized_height'],number_i_mat)},
                coords={'time': time_vec, 'normalized_height': z_vec})

# define attributes
ds['temp'].attrs['units']='K'
ds['temp'].attrs['long_name']='temperature'
ds['temp'].attrs['standard_name']='temperature'

ds['cwc'].attrs['units']='kg/m3'
ds['cwc'].attrs['long_name']='condensed water content'
ds['cwc'].attrs['standard_name']='cwc'

ds['lwc'].attrs['units']='kg/m3'
ds['lwc'].attrs['long_name']='liquid water content'
ds['lwc'].attrs['standard_name']='lwc'

ds['iwc'].attrs['units']='kg/m3'
ds['iwc'].attrs['long_name']='ice water content'
ds['iwc'].attrs['standard_name']='iwc'

ds['phase'].attrs['units']='-'
ds['phase'].attrs['long_name']='cloud phase'
ds['phase'].attrs['standard_name']='0 no clouds, 1 ice clouds, 2 mixed-phase clouds, 3 water clouds'

ds['re_w'].attrs['units']='m'
ds['re_w'].attrs['long_name']='effective radius of supercooled water droplets'
ds['re_w'].attrs['standard_name']='re_w'

ds['re_i'].attrs['units']='m'
ds['re_i'].attrs['long_name']='effective radius of ice crystals'
ds['re_i'].attrs['standard_name']='re_i'

ds['Nc'].attrs['units']='m-3'
ds['Nc'].attrs['long_name']='number concentration of droplets'
ds['Nc'].attrs['standard_name']='Nc'

ds['Ni'].attrs['units']='m-3'
ds['Ni'].attrs['long_name']='number concentration of ice crystals'
ds['Ni'].attrs['standard_name']='Ni'


ds=ds.sel(time=slice("2004-10-09 17:00:00","2004-10-10 05:00:00"))

ds.to_netcdf('OBS_aircraft.nc')

