#!/bin/bash

#-----------------------------------------------------------
# fichier filehf.nc on donne les "bons noms" de variables
# si un nom ne figure pas c est qu il porte le meme nom dans
# filehf.nc et histhf.nc
#-----------------------------------------------------------


ncdump -h hourly.nc | grep -i float | sed -e 's/(/ /' | cut -d' ' -f2 >| tmp_list_var

vars=""
for var in zfull zhalf pres paprs temp theta ovap oliq lwcon iwcon rhl rhi vitu vitv LWdnSFC LWupSFC SWdnSFC SWupSFC sens flat evap evu ustar precip psol tsol s_pblh alb1 z0m z0h t2m q2m rh2m u10m v10m cldt rneb rneblsvol rsd rsu rld rlu f_th mc dtthe dtswr dtlwr dtcon dtvdf dtlsc dteva dqthe dqcon dqvdf dqlsc dqeva tke lwp iwp tke_dissip ; do
  if [ "`grep '^'$var'$' tmp_list_var`" != "" ] ; then
      vars="$vars,$var"
  fi
done

ncks -O -v time_counter,presnivs,phis,geop$vars hourly.nc tmp0.nc

ncap2 -O -s 'zf=geop/9.81-phis/9.81' -s 'rho=pres/(287.*temp)' -s 'WND=(vitu^2+vitv^2)^0.5' tmp0.nc  tmp.nc


if [ "`grep '^'dtlwr'$' tmp_list_var`" != "" ] ; then ncap2 -s 'dtdt_rad=dtlwr+dtswr' tmp.nc -O tmp0.nc ; mv -f tmp0.nc tmp.nc ; fi
if [ "`grep '^'dqlsc'$' tmp_list_var`" != "" ] ; then ncap2 -s 'dqtdt_ls=dqlsc+dqeva' tmp.nc -O tmp0.nc ;  mv -f tmp0.nc tmp.nc ; fi
if [ "`grep '^'dtlsc'$' tmp_list_var`" != "" ] ; then ncap2 -s 'dttdt_ls=dtlsc+dteva' tmp.nc -O tmp0.nc ;  mv -f tmp0.nc tmp.nc ; fi

ncatted -O -a _FillValue,,d,, tmp.nc
ncrename -d time_counter,time \
         -v time_counter,time \
         -d presnivs,levf \
         -v presnivs,levf \
	 tmp.nc


# atonce est une cle introduite momentanement pour un probleme de bug nco
# qui n'arrive pas a traiter d'un coup plusieurs ncrename.
# atonce=1 , on essaie de les faire d'un coup (pour que ca tourne plus vite)
# atonce=0 , on fait la modif variable par variable. Plus sur mais plus lent
atonce=0
tobechanged=""
for paire in \
          pres,pf \
          zhalf,zh \
          paprs,ph \
          ovap,qv \
          lwcon,ql \
          iwcon,qi \
          vitu,u \
          vitv,v \
          LWdnSFC,lwdw \
          LWupSFC,lwup \
          SWdnSFC,swdw \
          SWupSFC,swup \
          sens,shf \
          flat,lhf \
          precip,rain \
          psol,psurf \
          tsol,tsurf \
          s_pblh,hpbl \
          alb1,alb \
          cldt,cc \
          rsd,sw_dn \
          rsu,sw_up \
          rld,lw_dn \
          rlu,lw_up \
          dtswr,dtdt_swrad \
          dtlwr,dtdt_lwrad \
          dtthe,dtdt_shcon \
          dqthe,dqtdt_shcon \
          dtcon,dtdt_conv \
          dqcon,dqtdt_conv \
          dqvdf,dqtdt_turb ; do
          var=`echo $paire | cut -d, -f1`
	  if [ "`grep '^'$var'$' tmp_list_var`" != "" ] ; then
              if [ $atonce = 1 ] ; then
	          tobechanged="$tobechanged -v $paire"
              else
echo TOBECHANGED $paire
	          ncrename -v $paire tmp.nc
              fi
          fi
done
if  [ $atonce = 1 ] ; then ncrename $tobechanged tmp.nc ; fi

#if [ 1 = 0 ] ; then
        echo 'ncatted process'
	# WAS crashing on some simulations when a variable was not present
	#to be checked in loop as other variables above
#ncrename $tobechanged tmp.nc
       ncatted  -a calendar,time,o,c,'365_day' tmp.nc
       ncatted -a standard_name,pf,o,c,'pressure at full level' tmp.nc
       ncatted -a standard_name,zh,o,c,'height half' tmp.nc
       ncatted -a long_name,zh,o,c,'height of half level' tmp.nc
       ncatted -a long_name,ph,o,c,'Half vertical levels' tmp.nc
       ncatted -a long_name,u10m,o,c,'10m u-component wind' tmp.nc
       ncatted -a standard_name,u10m,o,c,'10m u-component wind' tmp.nc
       ncatted -a long_name,v10m,o,c,'10m v-component wind' tmp.nc
       ncatted -a standard_name,v10m,o,c,'10m v-component wind' tmp.nc
       ncatted -a long_name,rain,o,c,'rainfall rate' tmp.nc
       ncatted -a standard_name,rain,o,c,'rainfall rate' tmp.nc
       ncatted -a long_name,cc,o,c,'total cloud cover fraction' tmp.nc
       ncatted -a standard_name,cc,o,c,'total cloud cover fraction' tmp.nc
       ncatted -a long_name,dtdt_rad,o,c,'Radiative tendency' tmp.nc
       ncatted -a standard_name,rho,o,c,'Density' tmp.nc
       ncatted -a long_name,rho,o,c,'Air Density' tmp.nc       
       ncatted -a units,rho,o,c,'kg/m3' tmp.nc
       ncatted -a standard_name,WND,o,c,'wind magnitude' tmp.nc
       ncatted -a long_name,WND,o,c,'wind speed' tmp.nc
       ncatted -a units,WND,o,c,'m/s' tmp.nc
       ncatted -a title,levf,o,c,'levf' tmp.nc
       ncatted -a long_name,levf,o,c,'Full vertical levels' tmp.nc
       ncatted -a coordinates,,o,c,'time levf lat lon' tmp.nc
       ncatted -a standard_name,zf,o,c,'zf' tmp.nc
       ncatted -a long_name,zf,o,c,'height of full level' tmp.nc    
       ncatted -a units,zf,o,c,'m' tmp.nc
       ncatted -a long_name,dtdt_swrad,o,c,'temperature tendency from short wave radiation' tmp.nc
       ncatted -a standard_name,dtdt_swrad,o,c,'temperature tendency from short wave radiation' tmp.nc
       ncatted -a long_name,dtdt_lwrad,o,c,'temperature tendency from long wave radiation' tmp.nc
       ncatted -a standard_name,dtdt_lwrad,o,c,'temperature tendency from long wave radiation' tmp.nc
       ncatted  -a long_name,dtdt_ls,o,c,'Temperature tendency from large scale forcings' tmp.nc
       ncatted  -a standard_name,dtdt_ls,o,c,'Temperature advection' tmp.nc
       ncatted -a long_name,dtdt_ls,o,c,'temperature advection' tmp.nc
       ncatted -a standard_name,dtdt_ls,o,c,'temperature advection' tmp.nc
       ncatted -a long_name,dqtdt_ls,o,c,'Moisture tendency from large scale forcings' tmp.nc
       ncatted -a standard_name,dqtdt_ls,o,c,'Moisture advection' tmp.nc
       ncatted -a author,global,o,c,'MP Lefebvre' tmp.nc
       ncatted -h -a history,global,o,c,'history goes here' tmp.nc
       ncatted -a physics,global,o,c,`pwd` tmp.nc
#fi

ncks -v dtlsc,dteva,dqlsc,dqeva -x -O tmp.nc hourly_std.nc
#-----------------------------------------------------------
# On change les noms des fichiers tmp.nc et tmp.nc
\rm -rf tmp*nc
