\rm -rf cas*tmp
\rm -rf cas*nc
#-----------------------------------------------------------
# fichier filehf.nc on donne les "bons noms" de variables
# si un nom ne figure pas c est qu il porte le meme nom dans
# filehf.nc et histhf.nc
#-----------------------------------------------------------

#cp histhf.nc filehf.nc
cp filehf.nc filehf_save.nc
ncatted -O -a _FillValue,,d,, filehf.nc
ncrename -d time_counter,time filehf.nc
ncrename -v time_counter,time filehf.nc
ncrename -d presnivs,levf filehf.nc
ncrename -v presnivs,levf filehf.nc
ncatted  -a title,levf,o,c,'levf' filehf.nc
ncatted  -a long_name,levf,o,c,'Full vertical levels' filehf.nc
ncatted -a calendar,time,o,c,'365_day' filehf.nc
ncatted  -a coordinates,,o,c,'time levf lat lon' filehf.nc
ncrename  -v pres,pf filehf.nc
ncatted  -a long_name,pf,o,c,'pressure at full level' filehf.nc
ncatted  -a standard_name,pf,o,c,'pressure at full level' filehf.nc
#ncap2 -O -s 'geop=geop/9.81' filehf.nc cas1.nc
#ncatted -a units,geop,o,c,'m' cas1.nc
#ncrename  -v geop,zf filehf.nc
#ncatted  -a long_name,zf,o,c,'height of full level' filehf.nc
#ncatted  -a standard_name,zf,o,c,'height of full level' filehf.nc
ncrename  -v zfull,zf filehf.nc
ncatted -a standard_name,zf,o,c,'height full' filehf.nc
ncatted -a long_name,zf,o,c,'height of full level' filehf.nc
ncrename  -v zhalf,zh filehf.nc
ncatted -a standard_name,zh,o,c,'height half' filehf.nc
ncatted -a long_name,zh,o,c,'height of half level' filehf.nc
ncrename  -v paprs,ph filehf.nc
ncatted  -a long_name,ph,o,c,'Half vertical levels' filehf.nc
ncrename  -v ovap,qv filehf.nc
ncrename  -v oliq,ql filehf.nc
ncrename  -v vitu,u filehf.nc
ncatted  -a long_name,u10m,o,c,'10m u-component wind' filehf.nc
ncatted  -a standard_name,u10m,o,c,'10m u-component wind' filehf.nc
ncrename  -v vitv,v filehf.nc
ncatted  -a long_name,v10m,o,c,'10m v-component wind' filehf.nc
ncatted  -a standard_name,v10m,o,c,'10m v-component wind' filehf.nc
ncrename  -v LWdnSFC,lwdw filehf.nc
ncrename  -v LWupSFC,lwup filehf.nc
ncrename  -v SWdnSFC,swdw filehf.nc
ncrename  -v SWupSFC,swup filehf.nc
ncrename  -v sens,shf filehf.nc
ncrename  -v flat,lhf filehf.nc
ncrename  -v precip,rain filehf.nc
ncatted  -a long_name,rain,o,c,'rainfall rate' filehf.nc
ncatted  -a standard_name,rain,o,c,'rainfall rate' filehf.nc
ncrename  -v psol,psurf filehf.nc
ncrename  -v tsol,tsurf filehf.nc
ncrename  -v s_pblh,hpbl filehf.nc
ncrename  -v alb1,alb filehf.nc
ncrename  -v cldt,cc filehf.nc
ncatted  -a long_name,cc,o,c,'total cloud cover fraction' filehf.nc
ncatted  -a standard_name,cc,o,c,'total cloud cover fraction' filehf.nc
ncrename  -v rsd,sw_dn filehf.nc
ncrename  -v rsu,sw_up filehf.nc
ncrename  -v rld,lw_dn filehf.nc
ncrename  -v rlu,lw_up filehf.nc
ncap2 -O -s 'dtdt_rad=dtlwr+dtswr' filehf.nc cas1.nc
ncatted -a long_name,dtlwr,o,c,'Radiative tendency' cas1.nc
ncap2 -O -s 'rho=pf/9.81/zf' cas1.nc cas2.nc
ncatted -a standard_name,zh,o,c,'Density' cas2.nc
ncatted -a long_name,zh,o,c,'Density' cas2.nc
ncatted -a units,rho,o,c,'kg/m3' cas2.nc
mv cas2.nc filehf.nc
ncrename  -v dtswr,dtdt_swrad filehf.nc
ncatted  -a long_name,dtdt_swrad,o,c,'temperature tendency from short wave radiation' filehf.nc
ncatted  -a standard_name,dtdt_swrad,o,c,'temperature tendency from short wave radiation' filehf.nc
ncrename  -v dtlwr,dtdt_lwrad filehf.nc
ncatted  -a long_name,dtdt_lwrad,o,c,'temperature tendency from long wave radiation' filehf.nc
ncatted  -a standard_name,dtdt_lwrad,o,c,'temperature tendency from long wave radiation' filehf.nc
ncrename  -v f_th,mu_shcon filehf.nc
ncrename  -v mc,mu_conv filehf.nc
ncrename  -v dtvdf,dtdt_turb filehf.nc
ncap2 -O -s 'dtdt_ls=dtlsc+dteva' filehf.nc cas1.nc
ncatted -a long_name,dtdt_ls,o,c,'Temperature tendency from large scale forcings' cas1.nc
ncatted -a standard_name,dtdt_ls,o,c,'Temperature advection' cas1.nc
mv cas1.nc filehf.nc
ncatted  -a long_name,dtdt_ls,o,c,'temperature advection' filehf.nc
ncatted  -a standard_name,dtdt_ls,o,c,'temperature advection' filehf.nc
ncrename  -v dtthe,dtdt_shcon filehf.nc
ncrename  -v dqthe,dqtdt_shcon filehf.nc
ncrename  -v dtcon,dtdt_conv filehf.nc
ncrename  -v dqcon,dqtdt_conv filehf.nc
ncrename  -v dqvdf,dqtdt_turb filehf.nc
ncap2 -O -s 'dqtdt_ls=dqlsc+dqeva' filehf.nc cas1.nc
ncatted -a long_name,dqtdt_ls,o,c,'Moisture tendency from large scale forcings' cas1.nc
ncatted -a standard_name,dqtdt_ls,o,c,'Moisture advection' cas1.nc
mv cas1.nc filehf.nc
ncatted  -a long_name,tke,o,c,'turbulent kinetic energy' filehf.nc
ncatted  -a standard_name,tke,o,c,'turbulent kinetic energy' filehf.nc
ncatted -O -h -a author,global,o,c,'MP Lefebvre' filehf.nc
ncatted -O -h -a physics,global,o,c,$2 filehf.nc
ncks -v dtlsc -x filehf.nc cas5.nc
ncks -v dteva -x cas5.nc cas6.nc
ncks -v dqlsc -x cas6.nc cas7.nc
ncks -v dqeva -x cas7.nc cas8.nc
mv cas8.nc filehf.nc
ncatted -O -h -a history,global,o,c,'history goes here' filehf.nc

#-----------------------------------------------------------
# On change les noms des fichiers filehf.nc et filehf.nc
cp filehf.nc $1_scm_lmd_lmdz.nc
\rm -rf cas*tmp
\rm -rf cas*nc
