#!/bin/ksh

# Name experiment:

if [ -n "${1}" ]
then
 expin="${1}"
 exp="${expin}"
else
 expin=""
 exp="std"
fi

echo EXP $exp

#-------------------------------------------------
# Diagnostics & evaluation
#-------------------------------------------------

# evaluation profiles temp and rh:
grads -lbc "run diags/toga_profiles $expin $exp temp "  2>/dev/null
grads -lbc "run diags/toga_profiles $expin $exp rh"     2>/dev/null
grads -lbc "run diags/toga_profiles $expin $exp Q1"     2>/dev/null
grads -lbc "run diags/toga_profiles $expin $exp Q2"     2>/dev/null
                                           
# evaluation precip and surface LH:        
grads -pbc "run diags/eval_toga_sfc $expin $exp "       2>/dev/null
                                           
# evaluation CRF and planetary albedo:     
grads -pbc "run diags/eval_toga_radfluxes $expin $exp " 2>/dev/null
