      program main
c
c   compute zt and zw (layer mid points and boundaries)
c   dz = 5m from 645 to 2400 m, increasing beneath and aloft 
c
      real, parameter :: dzrat = 1.095

      real :: zt(500)
      real :: zw(500)
      real :: zz,dz
      integer :: k,nz

c     ... input parameters

c     ... top of domain (m)
      domain_H = 3100.

c     ... minimum dz (m) - around cloud top
      dz_ct = 5.0 

c     ...  dz (m) - beneath cloud top
      dz_bl = 15.0 


c     ... height beneath/above which dz increases (m)
      zi = 540.
      zf = 2400.

c     ... vertical positions of cell boundaries
      k=1
      zz=0.

      do while (zz.lt.zi)
         zz=(k-1)*dz_bl
         zw(k) = zz 
      write(*,'(i4,f7.1)') k, zw(k)
         k=k+1
      end do
      
c     write(*,'(a20, i4,f7.1)') "1 after do while", k, zw(k)

      dz=dz_bl

      do while (dz.gt.dz_ct+0.5)
         dz=dz/dzrat
         zz=zz+dz
         zw(k) = zz 
      write(*,'(i4,2f7.1)') k, zw(k),dz
         k=k+1
      end do

      zz=645.
      zw(49) = zz

      do while (zz.lt.2400.)
         zz=zz+dz_ct
         zw(k) = zz 
      write(*,'(i4,1x,f7.1)') k, zw(k)
         k=k+1
      end do

      do while (zz.lt.domain_H-50.)
         dz=dz*dzrat
         zz=zz+dz
         zw(k) = zz 
      write(*,'(i4,2f7.1)') k, zw(k),dz
         k=k+1
      end do
       
      nz=k-1 
c     ... layer mid-points
      do k = nz-1, 1, -1
         zt(k)  = 0.5*zw(k) + 0.5*zw(k+1)
      enddo


c     ... print them out
      write(*,'("  k     zw     zt    dz")')
c      write(*,'(i4,2f7.1)') nz+1, zw(nz+1)
      do k = nz-1, 1, -1
         write(*,'(i4,3f7.1)') k, zw(k), zt(k), zw(k+1) - zw(k)
      enddo
      write(*,'("  k     zw     zt    dz")')

c     ... prepare files for the UCLA LES input
      open (1,file='zm_grid_in_new',status='new',form='formatted')
      do k = 1, nz
        write(1,'(f7.1)') zw(k)
      end do
      close (1)

      open (2,file='zt_grid_in_new',status='new',form='formatted')
      zt0 = zt(1) - (zt(2)-zt(1))
      write(2,'(f7.1)') zt0
      do k = 1, nz-1
        write(2,'(f7.1)') zt(k)
      end do
      close (2)

      end
