#!/bin/bash


if [ "`which python`" = "" ] ; then echo you need python2 ; exit ; fi
if [ "`python --version 2>&1 | awk ' { print $2 } ' | cut -c1`" != "2" ] ; then echo python version 2 is required ; exit ; fi

local=`pwd`
listecas="ARMCU/REF RICO/SHORT SANDU/REF AYOTTE/05WC AYOTTE/24SC"
listecas="GABLS1/REF"
listpdf=""


OUT=../OUTPUT

for cas in $listecas ; do


#    OUT=../OUTPUT/${cas}
#    mkdir -p $OUT

   main=`echo $cas | cut -d/ -f1` ; sub=`echo $cas | cut -d/ -f2`
   case $main in
       AYOTTE) vars=theta ;;
       *) vars="theta u v"
   esac
   for var in $vars ; do
       echo main $main sub $sub
       python trace_sens_LES.py ${var} ${main} ${sub}
       #display profil_${cas}_${var}_*.png
       out=`basename profil_${main}_${sub}_${var}_*.png .png`
       mv $out.png $OUT/

           convert  $OUT/$out.png  $OUT/$out.pdf 

       #evince $OUT/$out.pdf
       #display $OUT/$out.png

       rm  $OUT/$out.png
       listpdf="$listpdf $OUT/$out.pdf"
   done
   diag_obs=diag_obs.py
   if test -f "specific_diagnostics/${main}/${sub}/${diag_obs}"; then
       echo diagobs for $main $sub
       cd specific_diagnostics/${main}/${sub}/
       python ${diag_obs}   
       cd -    
   fi
done

if  command -v pdfjam &> /dev/null
then
pdfjam $listpdf --outfile $OUT/allpython.pdf --nup 3x3
else
pdftk $listpdf cat output $OUT/allpython.pdf
fi
rm $listpdf
evince $OUT/allpython.pdf
