#!/bin/bash

listcas="ARMCU/REF RICO/SHORT SANDU/REF AYOTTE/05WC AYOTTE/24SC"
listcas="ARMCU/REF RICO/SHORT SANDU/REF"
listcas="GABLS4/STAGE3"
listname="6AL79"
#===================================================================
# Automatic ferret post processing using the DEPHY standard format
# F. Hourdin, 2020/06/10
# For name in $listname, files should be stored as
# ../SCM/CASE/SUB/$name.nc
# LES results on
# ../LES/CASE/SUB/LES0.nc
#===================================================================
#################################################################
# TBD : add precip rrt/rain
#       add incloud water QC
#################################################################


listfinalpdf=""

for cas in $listcas ; do

for name in $listname ; do
 pdfdir=../OUTPUT/${name}/${cas}


\rm -f tmp.*

main=`echo $cas | cut -d/ -f1`
sub=`echo $cas | cut -d/ -f2`

#====================================================================
# Case dependent setup
#====================================================================
d0=""
zmax=4
tminmax=295:320
Plot2D=cloud

case $main in
   ARMCU)
      year=1997
      month=JUN
      day0=21
      day1=22
      time0=12:00:00
      time1=03:00:00
      day0z=21
      day1z=21
      time0z=13:00:00
      time1z=22:00:00
      uvmin=-2
      uvmax=12
      nebmax=30
      zmax=3.
      ;;
   BOMEX)
      year=2001
      month=SEP
      day0=27
      day1=27
      time0=01:00:00
      time1=11:00:00
      day0z=27
      day1z=27
      time0z=01:00:00
      time1z=11:00:00
      uvmin=-10
      uvmax=2
      d0=2001-09-27
      nebmax=12
      ;;
   SANDU)
      year=2006
      day0=15
      day1=18
      month=JUL
      time0=18:00:00
      time1=06:00:00
      day0z=15
      day1z=17
      time0z=19:00:00
      time1z=06:00:00
      uvmin=-6
      uvmax=4
      nebmax=120
      zmax=2.5
      tminmax=280:320
      ;;
   FIRE)
      year=1987
      day0=14
      day1=17
      month=JUL
      time0=00:00:00
      time1=00:00:00
      day0z=14
      day1z=15
      time0z=15:00:00
      time1z=06:00:00
      uvmin=-5
      uvmax=8
      nebmax=120
      zmax=1.8
      tminmax=280:320
      ;;
   AYOTTE)
      year=2009
      month=DEC
      day0=11
      day1=11
      time0=11:00:00
      time1=17:00:00
      day0z=11
      day1z=11
      time0z=12:00:00
      time1z=16:00:00
      uvmin=-2
      uvmax=12
      nebmax=100
      zmax=2.
      lcible=6
      tminmax=300:310
      uvmin=-2
      uvmax=18
      Plot2D=dtheta
      ;;
   RICO)
      year=2004
      month=DEC
      day0=27
      day1=30
      time0=01:00:00
      time1=00:00:00
      day0z=27
      day1z=27
      time0z=02:00:00
      time1z=22:00:00
      uvmin=-10
      uvmax=2
      d0=2004-12-27
      nebmax=18
      ;;
      
   MPACE)
      year=2004
      month=OCT
      day0=09
      day1=10
      time0=17:00:00
      time1=05:00:00
      day0z=09
      day1z=10
      time0z=21:00:00
      time1z=05:00:00
      uvmin=-10
      uvmax=2
      d0=2004-10-09
      nebmax=18
      zmax=2   
      tminmax=265:285  
      ;;

   GABLS1)
      year=2000
      month=JAN
      day0=01
      day1=01
      time0=10:00:00
      time1=19:00:00
      day0z=01
      day1z=01
      time0z=18:00:00
      time1z=19:00:00
      uvmin=-10
      uvmax=10
      d0=2000-01-001
      nebmax=18
      zmax=0.3
      tminmax=262:268
      ;;


    GABLS4)
      year=2009
      month=DEC
      day0=11
      day1=12
      time0=00:00:00
      time1=00:00:00
      day0z=11
      day1z=11
      time0z=17:00:00
      time1z=18:00:00
      uvmin=-8
      uvmax=8
      d0=2004-10-09
      nebmax=18
      zmax=0.2
      tminmax=260:280
      ;;


    *)
       echo cas non prevu
       exit
esac

case $Plot2D in
	dtheta) mainvar="theta-theta[l=1]"
		levels
		levels="lev=(-Inf)(-5,5,0.3)(Inf)/pal=blue_darkred/"
		subtitle="Potential temperature minus initial" ;;
	*) mainvar='100*rneb' 
		levels="lev=(1)(2)(4,10,2)(15,30,5)(40,100,10)(Inf)/"
		subtitle="Cloud fraction"
esac


les_file="../LES/${main}/${sub}/LES0.nc"
scm_file="../OUTPUT/${name}/${main}/${sub}/${name}.nc"
echo $scm_file
if [ "$d0" != "" ] ; then
 ncatted  -a "units",time,o,c,"seconds since $d0 00:00:00" -O $scm_file
fi

DASH="DASH=(0.3,0.1,0.3,0.1)"
day0my=$day0-$month-$year
day1my=$day1-$month-$year
day0myz=$day0z-$month-$year
day1myz=$day1z-$month-$year


#======================================================================================
# Ferret script for second page
# Vertical profiles of wind and time evolution of clouds
#======================================================================================

cat <<eod>| tmp.jnl
use "$les_file"
use "$scm_file"


DEFINE VIEWPORT/XLIM=0.,0.5/YLIM= 0.55,1.0 V1
DEFINE VIEWPORT/XLIM=0.,0.5/YLIM= 0.2,0.65 V2
DEFINE VIEWPORT/XLIM=0.,0.5/YLIM= 0.0,0.3 V3


DEFINE VIEWPORT/XLIM=0.50,0.75/YLIM=0.5,1.0 V4
DEFINE VIEWPORT/XLIM=0.75,1.00/YLIM=0.5,1.0 V5
DEFINE VIEWPORT/XLIM=0.50,0.75/YLIM=0.0,0.5 V6
DEFINE VIEWPORT/XLIM=0.75,1.00/YLIM=0.0,0.5 V7


! -------- evolution t-z Cloud fraction LES -------------------
set v V1
define axis/z=0:$zmax:0.05 axm
let mvar=$mainvar
let nebzt=ZAXREPLACE(mvar,zf[l=1]/1000.,z[gz=axm])
fill/nolabel/d=1/${levels}title="$phys"/hlim="$day0my $time0":"$day1my $time1"  nebzt
! Adding vertical lines to show the time of profiles plots
let tt=t[gt=nebzt,d=1]
LET datelabelpos=TT[T="$day0myz $time0z"@ITP]
PLOT/VS/NOLAB/LINE=1/OVER {\`datelabelpos\`,\`datelabelpos\`},{0,$zmax}
LET datelabelposb=TT[T="$day1myz $time1z"@ITP]
PLOT/VS/NOLAB/LINE=13/OVER {\`datelabelposb\`,\`datelabelposb\`},{0,$zmax}
!contour/nolabel/o/d=1/lev=(1.)/col=1 nebzt
!contour/nolabel/o/d=2/lev=(1.)/col=2 nebzt

! ------------- title ----------------------------------
ANNOTATE/NORM/XPOS=0.1/YPOS=1.25/HALIGN=0 "LES/SCM comparison, $cas case, SCM $name"
ANNOTATE/NORM/XPOS=0.1/YPOS=1.15/HALIGN=0 "$subtitle"

! -------- evolution t-z Cloud fraction SCM -------------------
set v V2
fill/nolabel/d=2/k=1:100/${levels}title="Nebul (%), LES , $cas"/hlim="$day0my $time0":"$day1my $time1" nebzt
!contour/nolabel/o/d=1/lev=(1.)/col=1 nebzt
!contour/nolabel/o/d=2/lev=(1.)/col=2 nebzt
! Adding vertical lines to show the time of profiles plots
let tt=t[gt=nebzt,d=2]
LET datelabelpos=TT[T="$day0myz $time0z"@ITP]
PLOT/VS/NOLAB/LINE=2/OVER {\`datelabelpos\`,\`datelabelpos\`},{0,$zmax}
LET datelabelposb=TT[T="$day1myz $time1z"@ITP]
PLOT/VS/NOLAB/LINE=14/OVER {\`datelabelposb\`,\`datelabelposb\`},{0,$zmax}

! -------- Vertical profiles potential temperature ------------------------
set v V6
let vles=theta
let vscm=theta
plot/d=1/vs/line=1/$DASH/vlim=0:$zmax/hlim=$tminmax/title="Theta (K), LES, ini"  vles[t="$day0myz $time0z"],zf[l=1]/1000
plot/d=1/vs/o/line=13/title="LES" vles[t="$day1myz $time1z"],zf[l=1]/1000
plot/d=2/vs/line=2/$DASH/o/title="$name, ini" vscm[t="$day0myz $time0z"],zf[l=1]/1000
plot/d=2/vs/line=14/o/title="$name" vscm[t="$day1myz $time1z"],zf[l=1]/1000

! ----------------------- Time evolution of cloud fraction ----------------------------
set v V3
plot/vlim=0:$nebmax/title="CLD %"/nolabel mvar[d=1,k=@max],mvar[d=2,k=@max]
!!!! plot/title="Precip (mm/day)" rrt[k=1,d=1]*86400,rain[d=2]*86400
reg/t="$day1myz $time1z"

! ----------------------- Vertical profiles : cloud fraction and in cloud water --------
set v V4
plot/vs/line=13/vlim=0:$zmax/d=1/title="Nebul, $phys, $cas, LES"/hlim=0:$nebmax mvar[l=@ave],zf[l=1]/1000
plot/vs/line=14/vlim=0:$zmax/d=2/o/title="$name" mvar[l=@ave],zf[l=1]/1000
! plot/vs/line=1/vlim=0:$zmax/$DASH/d=1/o/title="QC(LES)" 1000*qc[l=@ave],zf[l=1]/1000
! plot/vs/line=2/vlim=0:$zmax/$DASH/d=2/o/title="QC($name)" 1000*ql[l=@ave],zf[l=1]/1000

! ----------------------- Vertical profiles : wind -------------------------------------
set v V7
plot/vs/line=13/vlim=0:$zmax/d=1/title="U LES (m/s)"/hlim=$uvmin:$uvmax u[l=@ave],zf[l=1]/1000
plot/vs/line=14/vlim=0:$zmax/d=2/o/title="U $name" u[l=@ave],zf[l=1]/1000
plot/vs/line=1/$DASH/vlim=0:$zmax/d=1/o/title="V LES" v[l=@ave],zf[l=1]/1000
plot/vs/line=2/$DASH/vlim=0:$zmax/d=2/o/title="V $name" v[l=@ave],zf[l=1]/1000

! -------- Vertical profiles water vapor------------------------------------
set v V5
let vles=1000*qv
let vscm=1000*qv
plot/d=1/vs/line=1/$DASH/vlim=0:$zmax/hlim=0:18/title="Spec. humid (g/kg), LES, ini" vles[t="$day0myz $time0z"],zf[l=1]/1000
plot/d=1/vs/o/line=13/title="LES" vles[t="$day1myz $time1z"],zf[l=1]/1000
plot/d=2/vs/line=2/$DASH/o/title="$name, ini" vscm[t="$day0myz $time0z"],zf[l=1]/1000
plot/d=2/vs/line=14/o/title="$name" vscm[t="$day1myz $time1z"],zf[l=1]/1000

quit
eod

#=============================================================================
# Running ferret
#=============================================================================
ferret -batch tmp.ps -nojnl -script tmp.jnl
ps2epsi tmp.ps
epstopdf tmp.epsi 
echo OK1
\mv -f tmp.pdf $pdfdir/${main}${sub}${name}.pdf
echo OK2

\rm -f tmp*ps*

# evince tmp12.pdf
done

listpdf="" ; for name in $listname ; do listpdf="$listpdf ../OUTPUT/${name}/${cas}/${main}${sub}${name}.pdf" ; done

finalpdf=../OUTPUT/${main}${sub}.pdf
if command -v pdfjam &> /dev/null
then
pdfjam $listpdf --outfile $finalpdf
else
pdftk $listpdf cat output $finalpdf
fi

evince $finalpdf

listfinalpdf="$listfinalpdf $finalpdf" 
done



if  command -v pdfjam &> /dev/null
then
pdfjam $listfinalpdf --outfile ../OUTPUT/allferret.pdf 
else
pdftk $listfinalpdf cat output ../OUTPUT/allferret.pdf
fi
rm $listfinalpdf
evince ../OUTPUT/allferret.pdf


