#!/bin/csh


set local=`pwd`
cd ..
gfortran a1a2.F -o a1a2
cd $local


set cas=( 00WC    05WC    00SC    03SC    05SC    24SC    24F      15B     24B )
set z1=(  1020.83 979.167 468.750 479.167 458.333 958.333 1000.000 916.667 916.667 )
set  z2=( 1400    1500    700     700     700     1500    1500     1500    1500 )
set  dt=(  150     53     43      40      30      30      30       30 30 ) # dt ( 100s )

foreach var ( t b c )
# foreach var ( t )

foreach f ( a1${var}d a1${var}s a2${var}d a2${var}s )
\rm $f
touch  $f
end

set cc=0
foreach c ( 1 2 3  4 5 6 7 8 9 )

set liste=""
foreach i ( ../DONNEES/LES$cas[$c]/${var}0 ../DONNEES/LES$cas[$c]/${var}m $cas[$c]/${var}m )
\rm tmp0
# ls -l $i
ln -s $i tmp0
../a1a2 <<eod> ! tmp
$z1[$c]
$z2[$c]
eod
cat tmp

set liste="$liste "`cat tmp`
end

echo OK0
pwd
ls tmp0
echo $liste
echo OK1


set a1d=`echo $liste | awk ' { print ( $3 - $1 ) / '$dt[$c]' } '`
set a2d=`echo $liste | awk ' { print ( $4 - $2 ) / '$dt[$c]' } '`
set a1s=`echo $liste | awk ' { print ( $5 - $1 ) / '$dt[$c]' } '`
set a2s=`echo $liste | awk ' { print ( $6 - $2 ) / '$dt[$c]' } '`

echo
echo
echo
echo Variable $var CAS $cas[$c]
echo A1D=$a1d A2D=$a2d
echo A1S=$a1s A2S=$a2s

set cc=`expr $cc + 1`
echo $cc $a1d >> a1${var}d
echo $cc $a1s >> a1${var}s
echo $cc $a2d >> a2${var}d
echo $cc $a2s >> a2${var}s

end

echo OK0

set list=`awk ' { print $2 } ' a1${var}d`
set a1n=`echo $list | awk ' { print ( $1 + $2 + $3 + $4 + $5 + $6 + $7 + $8 + $9 ) / 9 } '`
echo A1N $a1n
echo $list

awk ' { print $1 , $2 / '$a1n' } ' a1${var}d > ! a1${var}nd
awk ' { print $1 , $2 / '$a1n' } ' a1${var}s > ! a1${var}ns

echo OK1

\rm a1${var}.eps
xmgrace -hardcopy -hdevice EPS -printfile a1${var}.eps a1${var}d a1${var}s -param ../a1.param

if ( $var == t ) then
paste a1${var}d a2${var}d | sed -e 1d | sed -e 2d | awk ' { print $1 , $2 / ( $4 - $2 ) } ' > ! stbd
paste a1${var}d a2${var}d | sed -e 1d | sed -e 2d | awk ' { print $1 , ( $4 - $2 ) } ' > ! totd
paste a1${var}s a2${var}s | sed -e 1d | sed -e 2d | awk ' { print $1 , $2 / ( $4 - $2 ) } ' > ! stbs
paste a1${var}s a2${var}s | sed -e 1d | sed -e 2d | awk ' { print $1 , ( $4 - $2 ) } ' > ! tots
\rm stab${var}.eps

xmgrace -hardcopy -hdevice EPS -printfile stab${var}.eps stbd stbs

endif

end
