#################################################################
# 1Ddiag.sh
#
# Script that plots the diagnostics for a LMDZ-1D simulation
# using standard LMDZ output files
#
# How to use: ./1Ddiag.sh $config $case/subcase 
#
# Etienne Vignon, November 2020
#################################################################

config=$1
cas=$2
llm=$3
dtsuf=$4
ici=`pwd`

echo $config
echo $cas
echo $ici

HISTDIR=$ici/../OUTPUT/$config/$cas
LESDIR=$ici/../LES/$cas
OUTDIR=$HISTDIR

#mkdir -p $OUTDIR

SPDIR=$ici/../DIAGS/specific_diagnostics/$cas
CASDIR=$ici/../OLDCASES/$cas

   case $cas in 
        arm_cu|arm_cu2|rico|rico2|bomex|bomex2|arm_cons|sandufast|sanduref|sanduslow|ihop|ayotte_00WC|ayotte_05SC|ayotte_24F|ayotte_00SC|ayotte_03SC|ayotte_05WC|ayotte_24SC) zmin=70000. ;;
        fire|dice_bucket|dice_force) zmin=88000. ;;
        gabls4) zmin=60000. ;;                                                                      
      *) zmin=70000
   esac
   echo post-traitement

   case $cas in
        gabls4|dice_bucket|dice_force|ihop|ayotte_00WC|ayotte_05SC|ayotte_24F|ayotte_00SC|ayotte_03SC|ayotte_05WC|ayotte_24SC|GABLS4/STAGE1|GABLS4/STAGE3|GABLS4/STAGE3-SHORT|GABLS1/REF) ferret=temp ;;
        *) ferret=neb
   esac

cd $HISTDIR

   if [ $ferret = temp ] ; then
   ferret -gif <<eod> out_ferret 2>&1
   DEFINE VIEWPORT/XLIM=0.,1/YLIM=0,.4 V1
   DEFINE VIEWPORT/XLIM=0.,1/YLIM=.3,.7 V2
   DEFINE VIEWPORT/XLIM=0.,1/YLIM=.5,1 V3
   use histhf
   use hourly
   set view V3
   reg/z=100000:60000
   shade/lev=(-Inf)(-11,11,2)(Inf)/pal=blue_darkred/title="$cas $config $dtsuf" temp-temp[l=1]
   set view V2
   plot/title="Ts (K)"/line=7 tsol
   plot/o/title="T2m"/line=8/o t2m
   plot/o/title="T2m hf"/line=9/o t2m[d=1]
   set view V1
   plot/title="Module V (m/s)" mod(u10m,v10m)
   frame/file=neb.gif
   quit
eod
   else

   ferret -gif <<eod> out_ferret 2>&1
   DEFINE VIEWPORT/XLIM=0.,1/YLIM=0,.4 V1
   DEFINE VIEWPORT/XLIM=0.,1/YLIM=.3,1 V2
   use histhf
   set view V2
   reg/z=100000:$zmin
   shade/lev=(0.5)(1,5,1)(5,30,5)(40,100,10)/title="$cas $config $dtsuf" rneb*100
   contour/o geop/9.8

   set view V1
   let pr=86400*(pluc+plul)
   plot/title="Precip (mm/day)"/line=7 pr
   plot/o/title="PLUL" 86400*plul
   plot/o/title="PLUC"/line=3 86400*pluc
   frame/file=neb.gif
   quit
eod
   fi
   pwd
   ls -l neb.gif
   
   
# Activation d'un script de diagnostic specifique au cas
# For the new cases (common format)

   echo 'SPDIR' $SPDIR
   echo `ls $SPDIR`
   if [ -f ${SPDIR}/diag.sh ] ; then 
	   ln -sf $LESDIR/LES.nc .
	   cp ${SPDIR}/diag.sh .
	   ./diag.sh  
   fi
   
   if [ -f ${SPDIR}/autre_diag.sh ] ; then 
	   cp ${SPDIR}/autre_diag.sh .
	   if [ ! -f Sample.nc ] ; then ln -s ${SPDIR}/Sample.nc . ; fi
	   ./autre_diag.sh  
   fi
# for the old cases
   if [ -f ${CASDIR}/diag.sh ] ; then
	   ln -sf $CASDIR/LES.nc . 
	   cp ${CASDIR}/diag.sh .
	   ./diag.sh  
   fi

   if [ -f ${CASDIR}/autre_diag.sh ] ;
   then cp ${CASDIR}/autre_diag.sh .
	   if [ ! -f Sample.nc ] ; then ln -s ${CASDIR}/Sample.nc . ; fi
	   ./autre_diag.sh 
   fi

   if command -v img2pdf &> /dev/null ; then
           img2pdf -o neb.pdf neb.gif
   else
	   convert neb.gif neb.pdf
   fi
   
   if [ ! -s neb.pdf ]; then
    cp neb_vide.pdf neb.pdf
   fi
   
   mv neb.* ${OUTDIR}/.
   mv tout.pdf ${OUTDIR}/.  
   mv out_ferret ${OUTDIR}/.     

# remove next lines if you want to keep the diag scripts in the OUTPUT directory
   cd $OUTDIR
   rm *.jnl* diag.sh autre_diag.sh *neb.gif.* Sample.nc 

