#!/bin/bash
#
####################################################################
listecas="arm_cu bomex ihop rico ayotte_24SC ayotte_05WC sanduslow sanduref sandufast ARMCU/REF RICO/REF SANDU/REF"
listecas="DYNAMO/NSA3A"
listecas="cindynamo"

####################################################################
# Select cases to be considered
# Available cases in ./CAS
# dry                     : ayotte
# cumulus continent       : arm_cu
# marine cumulus          : rico rico2  bomex bomex2
# strato cumulus          : fire sandufast sanduref sanduslow
# ocean. deep convection  : toga twpice
# cont.  deep convection  : amma
# radiative/conv. eq.     : eq_rd_cv
# other                   : hapex92_init dice_bucket gabls4
####################################################################


####################################################################
listedef=NOCONV
####################################################################
# Select list of physics configuration
# Available physics in INPUT/PHYS
####################################################################

flag_output_commun="1"
LLM="" # imposing the number of vertical level.
       # default values for various cases are defined bellow
day_step=""

####################################################################
# usage to run cosp: ./run.sh -cosp 
#               or   ./run.sh -cosp2
# Attention, cosp2 needs a recent version of gfortran
####################################################################
cosp=0 ; opt_cosp1=""
cosp2=0 ; opt_cosp2=""
opt_cosp=""
##################################
#          Fonctions             # 
#
help_needed ()
{
    cat <<EOI
#
#  Usage : `basename $0` [-r] 
#
#  -r : run only (no compilation)
#
EOI
  exit $1
}
#
shell_name=`basename $0`

ok_compile=true

  while [ $# -gt 0 ]
  do
     case "$1" in
        -h | -help | -\? | \? | -u )
             help_needed 0
             shift
             ;;
        -day_step)
             day_step=$2
             shift ; shift
             ;;
        -r)
             ok_compile=false
             shift
             ;;
        "-cosp") cosp=1 ; opt_cosp1="cosp" ; shift ;;
        "-cosp2") cosp2=1 ; opt_cosp2="cosp2" ; shift ;;
         *)
             shift
             ;;
       esac
  done
##################################

local=`pwd`
UTILS=$local/UTILS

# Options par defaut
phys=
# phys=new # Si on veut compiler avec phynew plutot que phylmd


ici=`pwd`
if [ "$phys" = "" ] ; then
   phys_=""
else
   phys_=${phys}_
fi

# Cosp
if [ "$cosp" = 1 -a "$cosp2" = 1 ] ; then
   echo "Error, you can't run with cosp1 and cosp2"
   exit
fi
if [ "$cosp" = 1 ] ; then 
   opt_cosp="$opt_cosp1"
fi
if [ "$cosp2" = 1 ] ; then
   opt_cosp="$opt_cosp2"
fi

# sauvegarde d'anciennes simulations
mkdir -p $ici/RESU/SAVE$$
mv $ici/RESU/*pdf $ici/RESU/SAVE$$

listepdf=""
listedir=""

for DEF in $listedef ; do

if [ "$LLM" = "" ] ; then
   case $DEF in
      SP|NPv3.1|NPv3.2) L=39 ;;
      NPv4.12) L=59 ;;
      H2002) L=130 ;;
      *) L=79
   esac
else
   L=$LLM
fi

if ${ok_compile}
then
  # Compilation 
  ########################################################################
  echo =========== Compilation de la version L$L =========================
  cd $ici/bin ; ./compile -L $L $phys $opt_cosp
  if [ $? != 0 ] ; then exit 1 ; fi
  ########################################################################
fi
if [ "$day_step" = "" ] ; then dtsuf="" ; else dtsuf=dt$day_step ; fi
dirsim=${DEF}L${L}$phys$dtsuf
OUT=$ici/RESU/$dirsim

list_pdf=" "  # contient la liste des fichiers pdf a concatener dans all.pdf

for cas in $listecas ; do

   if [ "`echo $cas | grep '/'`" = "" ] ; then
	   std=0 ; pointpoint=..
   else
	   std=1 ; pointpoint=../..
   fi
   mkdir -p $OUT/$cas
   cd $OUT/$cas

   # Fichiers d'entree du CAS
   ln -sf $ici/CAS/$cas/* . ; \rm *.d[ae]*

   # Fichiers par defaut
   cp $ici/INPUT/DEF/*.def .
   if [ "$cosp" = 1 -o "$cosp2" = 1 ] ; then
# copier les fichiers namelist input et output our COSP
     cp $ici/INPUT/DEF/cosp_input_nl.txt .
     cp $ici/INPUT/DEF/cosp_output_nl.txt .
# Activer la cles ok_cosp pour tourner avec COSP
     sed -e 's@ok_cosp=n@ok_cosp=y@' config.def > tmp
     \mv -f tmp config.def
     sed -e 's@ok_hfCOSP=n@ok_hfCOSP=y@' config.def > tmp
     \mv -f tmp config.def
   fi
  
   # Fichier physiq.def
   cp $ici/INPUT/PHYS/physiq.def_$DEF physiq.def
   if [ $L -gt 100 ] ; then
      sed -i -e 's/iflag_rrtm=1/iflag_rrtm=0/' -e 's/NSW=.*./NSW=2/' physiq.def
      echo WARNING !!!!!!!!!!!!!!   RRTM NOT USED FOR LLM = $L > 100
   fi
   # Fichier contenant la grille verticale
   LDEF=$L ; VERT_DIR=$ici/INPUT/VERT/L$L
   if [ ! -d $ici/INPUT/VERT/L$LDEF ] ; then LDEF=DEFAULT ; fi
   cp -f $ici/INPUT/VERT/L$LDEF/* . ; ln -sf L$LDEF.def vert.def

   # Fichiers contenant la description du cas
   cp $ici/CAS/$cas/*.d[ae]* . # on donne la priorite aux .def et .data du cas
   if [ "$day_step" != "" ] ; then \mv -f gcm1d.def ttt
       sed -e 's/day_step=.*.$/day_step='$day_step'/' ttt >| gcm1d.def ; fi
   case $cas in
      arm_cu_old) llm=40
           cd $ici/bin ; ./compile -L 40 $phys $opt_cosp ; cd $OUT/$cas ;;
      *)               llm=$L
   esac
   # Si on veut sortir un fichier output au format commun DEPHY
   cp $UTILS/lmdz2std.sh .
   if [ "$cosp" = 1 ] ; then 
      ln -sf $ici/bin/lmdz1d_${phys_}cosp_L${llm}.e lmdz1d.e
   elif [ "$cosp2" = 1 ] ; then
      ln -sf $ici/bin/lmdz1d_${phys_}cosp2_L${llm}.e lmdz1d.e
   else
      ln -sf $ici/bin/lmdz1d_${phys_}L$llm.e lmdz1d.e
   fi
   cat <<...eod>| compile.sh
   cd $pointpoint/../../bin/
   ./compile -L $llm $phys $opt_cosp
...eod

   if [ $std = 1 ] ; then $UTILS/cas2def.sh ; fi

   chmod +x compile.sh
   ls -l lmdz1d.e
############################################################################
   echo " =============  CAS $cas .def issus de $DEF  ================"
############################################################################
   if [ $cas == "ayotte" ]||[ $cas = idealq ]||[ $cas = eq_rd_cv_1p1eq2 ]  ; then
      ./lance.sh 
   else
      ./lmdz1d.e > listing 2>&1 
      grep 'is cool' listing
      grep 'is cool' listing > resul
   if [ -f listing.gz ] ; then rm -f listing.gz ; fi
      gzip listing
      if [ "$flag_output_commun" = "1" ] ; then
        ./lmdz2std.sh
      fi

   case $cas in 
        arm_cu|arm_cu2|rico|rico2|bomex|bomex2|arm_cons|sandufast|sanduref|sanduslow|ihop|ayotte_00WC|ayotte_05SC|ayotte_24F|ayotte_00SC|ayotte_03SC|ayotte_05WC|ayotte_24SC) zmin=70000. ;;
        fire|dice_bucket|dice_force) zmin=88000. ;;
        gabls4) zmin=60000. ;;                                                                      
      *) zmin=1000
   esac
   echo post-traitement

   case $cas in
        gabls4|dice_bucket|dice_force|ihop|ayotte_00WC|ayotte_05SC|ayotte_24F|ayotte_00SC|ayotte_03SC|ayotte_05WC|ayotte_24SC) ferret=temp ;;
        *) ferret=neb
   esac

   if [ $ferret = temp ] ; then
   ferret -gif <<eod> out_ferret 2>&1
   DEFINE VIEWPORT/XLIM=0.,1/YLIM=0,.4 V1
   DEFINE VIEWPORT/XLIM=0.,1/YLIM=.3,.7 V2
   DEFINE VIEWPORT/XLIM=0.,1/YLIM=.5,1 V3
   use histhf
   use hourly
   set view V3
   reg/z=100000:60000
   shade/lev=(-Inf)(-11,11,2)(Inf)/pal=blue_darkred/title="$cas $dtsuf" temp-temp[l=1]
   set view V2
   plot/title="Ts (K)"/line=7 tsol
   plot/o/title="T2m"/line=8/o t2m
   plot/o/title="T2m hf"/line=9/o t2m[d=1]
   set view V1
   plot/title="Module V (m/s)" mod(u10m,v10m)
   frame/file=neb.gif
   quit
eod
   else

   ferret -gif <<eod> out_ferret 2>&1
   DEFINE VIEWPORT/XLIM=0.,1/YLIM=0,.4 V1
   DEFINE VIEWPORT/XLIM=0.,1/YLIM=.3,1 V2
   use histhf
   set view V2
   reg/z=100000:$zmin
   shade/lev=(0.5)(1,5,1)(5,30,5)(40,100,10)/title="$cas L$llm $phys $DEF $dtsuf" rneb*100
   contour/o geop/9.8

   set view V1
   let pr=86400*(pluc+plul)
   plot/title="Precip (mm/day)"/line=7 pr
   plot/o/title="PLUL" 86400*plul
   plot/o/title="PLUC"/line=3 86400*pluc
   frame/file=neb.gif
   quit
eod
   fi
   pwd
   ls -l neb.gif
   # Activation d'un script de diagnostic specifique au cas
   if [ -f diag.sh ] ; then ./diag.sh ; fi
   convert neb.gif neb.pdf
   if [ ! -s neb.pdf ]; then
	cp neb_vide.pdf neb.pdf
   fi
   list_pdf="${list_pdf} $cas/neb.pdf"
   fi  #  end if cas == "ayotte"
done


cd $OUT
nfig=`echo $listecas | sed -e 's/ayotte//' | wc -w`
pp=`echo $nfig | awk ' {  print int(($1-1)^0.5) +1 } '`
if [ $(( $(( pp - 1 )) * $pp )) -ge $nfig ] ; then (( py = $pp - 1 )) ; else py=$pp ; fi
echo $pp $py

out=neb$DEF$phys.pdf

pdfjam --nup ${pp}x${py} --frame true --landscape ${list_pdf} -o $pointpoint/$out

listepdf="$listepdf RESU/$out"
listedir="$listedir $dirsim"


done

cd $ici
pdfjam $listepdf --landscape -o RESU/all.pdf


#########################################################
# Regroupement des resultats par cas
#########################################################
for cas in $listecas ; do
    listepdf=""
    ls -d RESU/*/$cas
    if [ "`ls -d RESU/*/$cas`" != "" ] ; then
       echo ON TRAITE LE CAS $cas
       for s in $listedir ; do
         case $cas in
            arm_cu2) pdf=RESU/$s/$cas/tout.pdf ; lp= ;;
            *) pdf=RESU/$s/$cas/tmp12.pdf ; lp="--landscape"
         esac
         echo pdf $pdf
         if [ -f $pdf ] ; then
            listepdf="$listepdf $pdf"
         fi
         echo $listepdf
       done
       if [ "$listepdf" != "" ] ; then pdfjam $listepdf --outfile RESU/`echo $cas | sed -e 's/\///'`.pdf $lp ; fi
    fi
done
